/*
 * Copyright 2025 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/cloud/aiplatform/v1/notebook_runtime.proto

// Protobuf Java Version: 3.25.5
package com.google.cloud.aiplatform.v1;

/**
 *
 *
 * <pre>
 * A template that specifies runtime configurations such as machine type,
 * runtime version, network configurations, etc.
 * Multiple runtimes can be created from a runtime template.
 * </pre>
 *
 * Protobuf type {@code google.cloud.aiplatform.v1.NotebookRuntimeTemplate}
 */
public final class NotebookRuntimeTemplate extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.cloud.aiplatform.v1.NotebookRuntimeTemplate)
    NotebookRuntimeTemplateOrBuilder {
  private static final long serialVersionUID = 0L;
  // Use NotebookRuntimeTemplate.newBuilder() to construct.
  private NotebookRuntimeTemplate(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private NotebookRuntimeTemplate() {
    name_ = "";
    displayName_ = "";
    description_ = "";
    serviceAccount_ = "";
    etag_ = "";
    notebookRuntimeType_ = 0;
    networkTags_ = com.google.protobuf.LazyStringArrayList.emptyList();
  }

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new NotebookRuntimeTemplate();
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.cloud.aiplatform.v1.NotebookRuntimeProto
        .internal_static_google_cloud_aiplatform_v1_NotebookRuntimeTemplate_descriptor;
  }

  @SuppressWarnings({"rawtypes"})
  @java.lang.Override
  protected com.google.protobuf.MapFieldReflectionAccessor internalGetMapFieldReflection(
      int number) {
    switch (number) {
      case 15:
        return internalGetLabels();
      default:
        throw new RuntimeException("Invalid map field number: " + number);
    }
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.cloud.aiplatform.v1.NotebookRuntimeProto
        .internal_static_google_cloud_aiplatform_v1_NotebookRuntimeTemplate_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.cloud.aiplatform.v1.NotebookRuntimeTemplate.class,
            com.google.cloud.aiplatform.v1.NotebookRuntimeTemplate.Builder.class);
  }

  private int bitField0_;
  public static final int NAME_FIELD_NUMBER = 1;

  @SuppressWarnings("serial")
  private volatile java.lang.Object name_ = "";
  /**
   *
   *
   * <pre>
   * The resource name of the NotebookRuntimeTemplate.
   * </pre>
   *
   * <code>string name = 1;</code>
   *
   * @return The name.
   */
  @java.lang.Override
  public java.lang.String getName() {
    java.lang.Object ref = name_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      name_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * The resource name of the NotebookRuntimeTemplate.
   * </pre>
   *
   * <code>string name = 1;</code>
   *
   * @return The bytes for name.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getNameBytes() {
    java.lang.Object ref = name_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      name_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int DISPLAY_NAME_FIELD_NUMBER = 2;

  @SuppressWarnings("serial")
  private volatile java.lang.Object displayName_ = "";
  /**
   *
   *
   * <pre>
   * Required. The display name of the NotebookRuntimeTemplate.
   * The name can be up to 128 characters long and can consist of any UTF-8
   * characters.
   * </pre>
   *
   * <code>string display_name = 2 [(.google.api.field_behavior) = REQUIRED];</code>
   *
   * @return The displayName.
   */
  @java.lang.Override
  public java.lang.String getDisplayName() {
    java.lang.Object ref = displayName_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      displayName_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Required. The display name of the NotebookRuntimeTemplate.
   * The name can be up to 128 characters long and can consist of any UTF-8
   * characters.
   * </pre>
   *
   * <code>string display_name = 2 [(.google.api.field_behavior) = REQUIRED];</code>
   *
   * @return The bytes for displayName.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getDisplayNameBytes() {
    java.lang.Object ref = displayName_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      displayName_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int DESCRIPTION_FIELD_NUMBER = 3;

  @SuppressWarnings("serial")
  private volatile java.lang.Object description_ = "";
  /**
   *
   *
   * <pre>
   * The description of the NotebookRuntimeTemplate.
   * </pre>
   *
   * <code>string description = 3;</code>
   *
   * @return The description.
   */
  @java.lang.Override
  public java.lang.String getDescription() {
    java.lang.Object ref = description_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      description_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * The description of the NotebookRuntimeTemplate.
   * </pre>
   *
   * <code>string description = 3;</code>
   *
   * @return The bytes for description.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getDescriptionBytes() {
    java.lang.Object ref = description_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      description_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int IS_DEFAULT_FIELD_NUMBER = 4;
  private boolean isDefault_ = false;
  /**
   *
   *
   * <pre>
   * Output only. Deprecated: This field has no behavior. Use
   * notebook_runtime_type = 'ONE_CLICK' instead.
   *
   * The default template to use if not specified.
   * </pre>
   *
   * <code>bool is_default = 4 [deprecated = true, (.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @deprecated google.cloud.aiplatform.v1.NotebookRuntimeTemplate.is_default is deprecated. See
   *     google/cloud/aiplatform/v1/notebook_runtime.proto;l=74
   * @return The isDefault.
   */
  @java.lang.Override
  @java.lang.Deprecated
  public boolean getIsDefault() {
    return isDefault_;
  }

  public static final int MACHINE_SPEC_FIELD_NUMBER = 5;
  private com.google.cloud.aiplatform.v1.MachineSpec machineSpec_;
  /**
   *
   *
   * <pre>
   * Optional. Immutable. The specification of a single machine for the
   * template.
   * </pre>
   *
   * <code>
   * .google.cloud.aiplatform.v1.MachineSpec machine_spec = 5 [(.google.api.field_behavior) = OPTIONAL, (.google.api.field_behavior) = IMMUTABLE];
   * </code>
   *
   * @return Whether the machineSpec field is set.
   */
  @java.lang.Override
  public boolean hasMachineSpec() {
    return ((bitField0_ & 0x00000001) != 0);
  }
  /**
   *
   *
   * <pre>
   * Optional. Immutable. The specification of a single machine for the
   * template.
   * </pre>
   *
   * <code>
   * .google.cloud.aiplatform.v1.MachineSpec machine_spec = 5 [(.google.api.field_behavior) = OPTIONAL, (.google.api.field_behavior) = IMMUTABLE];
   * </code>
   *
   * @return The machineSpec.
   */
  @java.lang.Override
  public com.google.cloud.aiplatform.v1.MachineSpec getMachineSpec() {
    return machineSpec_ == null
        ? com.google.cloud.aiplatform.v1.MachineSpec.getDefaultInstance()
        : machineSpec_;
  }
  /**
   *
   *
   * <pre>
   * Optional. Immutable. The specification of a single machine for the
   * template.
   * </pre>
   *
   * <code>
   * .google.cloud.aiplatform.v1.MachineSpec machine_spec = 5 [(.google.api.field_behavior) = OPTIONAL, (.google.api.field_behavior) = IMMUTABLE];
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.aiplatform.v1.MachineSpecOrBuilder getMachineSpecOrBuilder() {
    return machineSpec_ == null
        ? com.google.cloud.aiplatform.v1.MachineSpec.getDefaultInstance()
        : machineSpec_;
  }

  public static final int DATA_PERSISTENT_DISK_SPEC_FIELD_NUMBER = 8;
  private com.google.cloud.aiplatform.v1.PersistentDiskSpec dataPersistentDiskSpec_;
  /**
   *
   *
   * <pre>
   * Optional. The specification of [persistent
   * disk][https://cloud.google.com/compute/docs/disks/persistent-disks]
   * attached to the runtime as data disk storage.
   * </pre>
   *
   * <code>
   * .google.cloud.aiplatform.v1.PersistentDiskSpec data_persistent_disk_spec = 8 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   *
   * @return Whether the dataPersistentDiskSpec field is set.
   */
  @java.lang.Override
  public boolean hasDataPersistentDiskSpec() {
    return ((bitField0_ & 0x00000002) != 0);
  }
  /**
   *
   *
   * <pre>
   * Optional. The specification of [persistent
   * disk][https://cloud.google.com/compute/docs/disks/persistent-disks]
   * attached to the runtime as data disk storage.
   * </pre>
   *
   * <code>
   * .google.cloud.aiplatform.v1.PersistentDiskSpec data_persistent_disk_spec = 8 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   *
   * @return The dataPersistentDiskSpec.
   */
  @java.lang.Override
  public com.google.cloud.aiplatform.v1.PersistentDiskSpec getDataPersistentDiskSpec() {
    return dataPersistentDiskSpec_ == null
        ? com.google.cloud.aiplatform.v1.PersistentDiskSpec.getDefaultInstance()
        : dataPersistentDiskSpec_;
  }
  /**
   *
   *
   * <pre>
   * Optional. The specification of [persistent
   * disk][https://cloud.google.com/compute/docs/disks/persistent-disks]
   * attached to the runtime as data disk storage.
   * </pre>
   *
   * <code>
   * .google.cloud.aiplatform.v1.PersistentDiskSpec data_persistent_disk_spec = 8 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.aiplatform.v1.PersistentDiskSpecOrBuilder
      getDataPersistentDiskSpecOrBuilder() {
    return dataPersistentDiskSpec_ == null
        ? com.google.cloud.aiplatform.v1.PersistentDiskSpec.getDefaultInstance()
        : dataPersistentDiskSpec_;
  }

  public static final int NETWORK_SPEC_FIELD_NUMBER = 12;
  private com.google.cloud.aiplatform.v1.NetworkSpec networkSpec_;
  /**
   *
   *
   * <pre>
   * Optional. Network spec.
   * </pre>
   *
   * <code>
   * .google.cloud.aiplatform.v1.NetworkSpec network_spec = 12 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   *
   * @return Whether the networkSpec field is set.
   */
  @java.lang.Override
  public boolean hasNetworkSpec() {
    return ((bitField0_ & 0x00000004) != 0);
  }
  /**
   *
   *
   * <pre>
   * Optional. Network spec.
   * </pre>
   *
   * <code>
   * .google.cloud.aiplatform.v1.NetworkSpec network_spec = 12 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   *
   * @return The networkSpec.
   */
  @java.lang.Override
  public com.google.cloud.aiplatform.v1.NetworkSpec getNetworkSpec() {
    return networkSpec_ == null
        ? com.google.cloud.aiplatform.v1.NetworkSpec.getDefaultInstance()
        : networkSpec_;
  }
  /**
   *
   *
   * <pre>
   * Optional. Network spec.
   * </pre>
   *
   * <code>
   * .google.cloud.aiplatform.v1.NetworkSpec network_spec = 12 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.aiplatform.v1.NetworkSpecOrBuilder getNetworkSpecOrBuilder() {
    return networkSpec_ == null
        ? com.google.cloud.aiplatform.v1.NetworkSpec.getDefaultInstance()
        : networkSpec_;
  }

  public static final int SERVICE_ACCOUNT_FIELD_NUMBER = 13;

  @SuppressWarnings("serial")
  private volatile java.lang.Object serviceAccount_ = "";
  /**
   *
   *
   * <pre>
   * Deprecated: This field is ignored and the "Vertex AI Notebook Service
   * Account"
   * (service-PROJECT_NUMBER&#64;gcp-sa-aiplatform-vm.iam.gserviceaccount.com) is
   * used for the runtime workload identity.
   * See
   * https://cloud.google.com/iam/docs/service-agents#vertex-ai-notebook-service-account
   * for more details.
   * For NotebookExecutionJob, use NotebookExecutionJob.service_account instead.
   *
   * The service account that the runtime workload runs as.
   * You can use any service account within the same project, but you
   * must have the service account user permission to use the instance.
   *
   * If not specified, the [Compute Engine default service
   * account](https://cloud.google.com/compute/docs/access/service-accounts#default_service_account)
   * is used.
   * </pre>
   *
   * <code>string service_account = 13 [deprecated = true];</code>
   *
   * @deprecated google.cloud.aiplatform.v1.NotebookRuntimeTemplate.service_account is deprecated.
   *     See google/cloud/aiplatform/v1/notebook_runtime.proto;l=109
   * @return The serviceAccount.
   */
  @java.lang.Override
  @java.lang.Deprecated
  public java.lang.String getServiceAccount() {
    java.lang.Object ref = serviceAccount_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      serviceAccount_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Deprecated: This field is ignored and the "Vertex AI Notebook Service
   * Account"
   * (service-PROJECT_NUMBER&#64;gcp-sa-aiplatform-vm.iam.gserviceaccount.com) is
   * used for the runtime workload identity.
   * See
   * https://cloud.google.com/iam/docs/service-agents#vertex-ai-notebook-service-account
   * for more details.
   * For NotebookExecutionJob, use NotebookExecutionJob.service_account instead.
   *
   * The service account that the runtime workload runs as.
   * You can use any service account within the same project, but you
   * must have the service account user permission to use the instance.
   *
   * If not specified, the [Compute Engine default service
   * account](https://cloud.google.com/compute/docs/access/service-accounts#default_service_account)
   * is used.
   * </pre>
   *
   * <code>string service_account = 13 [deprecated = true];</code>
   *
   * @deprecated google.cloud.aiplatform.v1.NotebookRuntimeTemplate.service_account is deprecated.
   *     See google/cloud/aiplatform/v1/notebook_runtime.proto;l=109
   * @return The bytes for serviceAccount.
   */
  @java.lang.Override
  @java.lang.Deprecated
  public com.google.protobuf.ByteString getServiceAccountBytes() {
    java.lang.Object ref = serviceAccount_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      serviceAccount_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int ETAG_FIELD_NUMBER = 14;

  @SuppressWarnings("serial")
  private volatile java.lang.Object etag_ = "";
  /**
   *
   *
   * <pre>
   * Used to perform consistent read-modify-write updates. If not set, a blind
   * "overwrite" update happens.
   * </pre>
   *
   * <code>string etag = 14;</code>
   *
   * @return The etag.
   */
  @java.lang.Override
  public java.lang.String getEtag() {
    java.lang.Object ref = etag_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      etag_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Used to perform consistent read-modify-write updates. If not set, a blind
   * "overwrite" update happens.
   * </pre>
   *
   * <code>string etag = 14;</code>
   *
   * @return The bytes for etag.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getEtagBytes() {
    java.lang.Object ref = etag_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      etag_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int LABELS_FIELD_NUMBER = 15;

  private static final class LabelsDefaultEntryHolder {
    static final com.google.protobuf.MapEntry<java.lang.String, java.lang.String> defaultEntry =
        com.google.protobuf.MapEntry.<java.lang.String, java.lang.String>newDefaultInstance(
            com.google.cloud.aiplatform.v1.NotebookRuntimeProto
                .internal_static_google_cloud_aiplatform_v1_NotebookRuntimeTemplate_LabelsEntry_descriptor,
            com.google.protobuf.WireFormat.FieldType.STRING,
            "",
            com.google.protobuf.WireFormat.FieldType.STRING,
            "");
  }

  @SuppressWarnings("serial")
  private com.google.protobuf.MapField<java.lang.String, java.lang.String> labels_;

  private com.google.protobuf.MapField<java.lang.String, java.lang.String> internalGetLabels() {
    if (labels_ == null) {
      return com.google.protobuf.MapField.emptyMapField(LabelsDefaultEntryHolder.defaultEntry);
    }
    return labels_;
  }

  public int getLabelsCount() {
    return internalGetLabels().getMap().size();
  }
  /**
   *
   *
   * <pre>
   * The labels with user-defined metadata to organize the
   * NotebookRuntimeTemplates.
   *
   * Label keys and values can be no longer than 64 characters
   * (Unicode codepoints), can only contain lowercase letters, numeric
   * characters, underscores and dashes. International characters are allowed.
   *
   * See https://goo.gl/xmQnxf for more information and examples of labels.
   * </pre>
   *
   * <code>map&lt;string, string&gt; labels = 15;</code>
   */
  @java.lang.Override
  public boolean containsLabels(java.lang.String key) {
    if (key == null) {
      throw new NullPointerException("map key");
    }
    return internalGetLabels().getMap().containsKey(key);
  }
  /** Use {@link #getLabelsMap()} instead. */
  @java.lang.Override
  @java.lang.Deprecated
  public java.util.Map<java.lang.String, java.lang.String> getLabels() {
    return getLabelsMap();
  }
  /**
   *
   *
   * <pre>
   * The labels with user-defined metadata to organize the
   * NotebookRuntimeTemplates.
   *
   * Label keys and values can be no longer than 64 characters
   * (Unicode codepoints), can only contain lowercase letters, numeric
   * characters, underscores and dashes. International characters are allowed.
   *
   * See https://goo.gl/xmQnxf for more information and examples of labels.
   * </pre>
   *
   * <code>map&lt;string, string&gt; labels = 15;</code>
   */
  @java.lang.Override
  public java.util.Map<java.lang.String, java.lang.String> getLabelsMap() {
    return internalGetLabels().getMap();
  }
  /**
   *
   *
   * <pre>
   * The labels with user-defined metadata to organize the
   * NotebookRuntimeTemplates.
   *
   * Label keys and values can be no longer than 64 characters
   * (Unicode codepoints), can only contain lowercase letters, numeric
   * characters, underscores and dashes. International characters are allowed.
   *
   * See https://goo.gl/xmQnxf for more information and examples of labels.
   * </pre>
   *
   * <code>map&lt;string, string&gt; labels = 15;</code>
   */
  @java.lang.Override
  public /* nullable */ java.lang.String getLabelsOrDefault(
      java.lang.String key,
      /* nullable */
      java.lang.String defaultValue) {
    if (key == null) {
      throw new NullPointerException("map key");
    }
    java.util.Map<java.lang.String, java.lang.String> map = internalGetLabels().getMap();
    return map.containsKey(key) ? map.get(key) : defaultValue;
  }
  /**
   *
   *
   * <pre>
   * The labels with user-defined metadata to organize the
   * NotebookRuntimeTemplates.
   *
   * Label keys and values can be no longer than 64 characters
   * (Unicode codepoints), can only contain lowercase letters, numeric
   * characters, underscores and dashes. International characters are allowed.
   *
   * See https://goo.gl/xmQnxf for more information and examples of labels.
   * </pre>
   *
   * <code>map&lt;string, string&gt; labels = 15;</code>
   */
  @java.lang.Override
  public java.lang.String getLabelsOrThrow(java.lang.String key) {
    if (key == null) {
      throw new NullPointerException("map key");
    }
    java.util.Map<java.lang.String, java.lang.String> map = internalGetLabels().getMap();
    if (!map.containsKey(key)) {
      throw new java.lang.IllegalArgumentException();
    }
    return map.get(key);
  }

  public static final int IDLE_SHUTDOWN_CONFIG_FIELD_NUMBER = 17;
  private com.google.cloud.aiplatform.v1.NotebookIdleShutdownConfig idleShutdownConfig_;
  /**
   *
   *
   * <pre>
   * The idle shutdown configuration of NotebookRuntimeTemplate. This config
   * will only be set when idle shutdown is enabled.
   * </pre>
   *
   * <code>.google.cloud.aiplatform.v1.NotebookIdleShutdownConfig idle_shutdown_config = 17;</code>
   *
   * @return Whether the idleShutdownConfig field is set.
   */
  @java.lang.Override
  public boolean hasIdleShutdownConfig() {
    return ((bitField0_ & 0x00000008) != 0);
  }
  /**
   *
   *
   * <pre>
   * The idle shutdown configuration of NotebookRuntimeTemplate. This config
   * will only be set when idle shutdown is enabled.
   * </pre>
   *
   * <code>.google.cloud.aiplatform.v1.NotebookIdleShutdownConfig idle_shutdown_config = 17;</code>
   *
   * @return The idleShutdownConfig.
   */
  @java.lang.Override
  public com.google.cloud.aiplatform.v1.NotebookIdleShutdownConfig getIdleShutdownConfig() {
    return idleShutdownConfig_ == null
        ? com.google.cloud.aiplatform.v1.NotebookIdleShutdownConfig.getDefaultInstance()
        : idleShutdownConfig_;
  }
  /**
   *
   *
   * <pre>
   * The idle shutdown configuration of NotebookRuntimeTemplate. This config
   * will only be set when idle shutdown is enabled.
   * </pre>
   *
   * <code>.google.cloud.aiplatform.v1.NotebookIdleShutdownConfig idle_shutdown_config = 17;</code>
   */
  @java.lang.Override
  public com.google.cloud.aiplatform.v1.NotebookIdleShutdownConfigOrBuilder
      getIdleShutdownConfigOrBuilder() {
    return idleShutdownConfig_ == null
        ? com.google.cloud.aiplatform.v1.NotebookIdleShutdownConfig.getDefaultInstance()
        : idleShutdownConfig_;
  }

  public static final int EUC_CONFIG_FIELD_NUMBER = 18;
  private com.google.cloud.aiplatform.v1.NotebookEucConfig eucConfig_;
  /**
   *
   *
   * <pre>
   * EUC configuration of the NotebookRuntimeTemplate.
   * </pre>
   *
   * <code>.google.cloud.aiplatform.v1.NotebookEucConfig euc_config = 18;</code>
   *
   * @return Whether the eucConfig field is set.
   */
  @java.lang.Override
  public boolean hasEucConfig() {
    return ((bitField0_ & 0x00000010) != 0);
  }
  /**
   *
   *
   * <pre>
   * EUC configuration of the NotebookRuntimeTemplate.
   * </pre>
   *
   * <code>.google.cloud.aiplatform.v1.NotebookEucConfig euc_config = 18;</code>
   *
   * @return The eucConfig.
   */
  @java.lang.Override
  public com.google.cloud.aiplatform.v1.NotebookEucConfig getEucConfig() {
    return eucConfig_ == null
        ? com.google.cloud.aiplatform.v1.NotebookEucConfig.getDefaultInstance()
        : eucConfig_;
  }
  /**
   *
   *
   * <pre>
   * EUC configuration of the NotebookRuntimeTemplate.
   * </pre>
   *
   * <code>.google.cloud.aiplatform.v1.NotebookEucConfig euc_config = 18;</code>
   */
  @java.lang.Override
  public com.google.cloud.aiplatform.v1.NotebookEucConfigOrBuilder getEucConfigOrBuilder() {
    return eucConfig_ == null
        ? com.google.cloud.aiplatform.v1.NotebookEucConfig.getDefaultInstance()
        : eucConfig_;
  }

  public static final int CREATE_TIME_FIELD_NUMBER = 10;
  private com.google.protobuf.Timestamp createTime_;
  /**
   *
   *
   * <pre>
   * Output only. Timestamp when this NotebookRuntimeTemplate was created.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp create_time = 10 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return Whether the createTime field is set.
   */
  @java.lang.Override
  public boolean hasCreateTime() {
    return ((bitField0_ & 0x00000020) != 0);
  }
  /**
   *
   *
   * <pre>
   * Output only. Timestamp when this NotebookRuntimeTemplate was created.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp create_time = 10 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return The createTime.
   */
  @java.lang.Override
  public com.google.protobuf.Timestamp getCreateTime() {
    return createTime_ == null ? com.google.protobuf.Timestamp.getDefaultInstance() : createTime_;
  }
  /**
   *
   *
   * <pre>
   * Output only. Timestamp when this NotebookRuntimeTemplate was created.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp create_time = 10 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   */
  @java.lang.Override
  public com.google.protobuf.TimestampOrBuilder getCreateTimeOrBuilder() {
    return createTime_ == null ? com.google.protobuf.Timestamp.getDefaultInstance() : createTime_;
  }

  public static final int UPDATE_TIME_FIELD_NUMBER = 11;
  private com.google.protobuf.Timestamp updateTime_;
  /**
   *
   *
   * <pre>
   * Output only. Timestamp when this NotebookRuntimeTemplate was most recently
   * updated.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp update_time = 11 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return Whether the updateTime field is set.
   */
  @java.lang.Override
  public boolean hasUpdateTime() {
    return ((bitField0_ & 0x00000040) != 0);
  }
  /**
   *
   *
   * <pre>
   * Output only. Timestamp when this NotebookRuntimeTemplate was most recently
   * updated.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp update_time = 11 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return The updateTime.
   */
  @java.lang.Override
  public com.google.protobuf.Timestamp getUpdateTime() {
    return updateTime_ == null ? com.google.protobuf.Timestamp.getDefaultInstance() : updateTime_;
  }
  /**
   *
   *
   * <pre>
   * Output only. Timestamp when this NotebookRuntimeTemplate was most recently
   * updated.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp update_time = 11 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   */
  @java.lang.Override
  public com.google.protobuf.TimestampOrBuilder getUpdateTimeOrBuilder() {
    return updateTime_ == null ? com.google.protobuf.Timestamp.getDefaultInstance() : updateTime_;
  }

  public static final int NOTEBOOK_RUNTIME_TYPE_FIELD_NUMBER = 19;
  private int notebookRuntimeType_ = 0;
  /**
   *
   *
   * <pre>
   * Optional. Immutable. The type of the notebook runtime template.
   * </pre>
   *
   * <code>
   * .google.cloud.aiplatform.v1.NotebookRuntimeType notebook_runtime_type = 19 [(.google.api.field_behavior) = OPTIONAL, (.google.api.field_behavior) = IMMUTABLE];
   * </code>
   *
   * @return The enum numeric value on the wire for notebookRuntimeType.
   */
  @java.lang.Override
  public int getNotebookRuntimeTypeValue() {
    return notebookRuntimeType_;
  }
  /**
   *
   *
   * <pre>
   * Optional. Immutable. The type of the notebook runtime template.
   * </pre>
   *
   * <code>
   * .google.cloud.aiplatform.v1.NotebookRuntimeType notebook_runtime_type = 19 [(.google.api.field_behavior) = OPTIONAL, (.google.api.field_behavior) = IMMUTABLE];
   * </code>
   *
   * @return The notebookRuntimeType.
   */
  @java.lang.Override
  public com.google.cloud.aiplatform.v1.NotebookRuntimeType getNotebookRuntimeType() {
    com.google.cloud.aiplatform.v1.NotebookRuntimeType result =
        com.google.cloud.aiplatform.v1.NotebookRuntimeType.forNumber(notebookRuntimeType_);
    return result == null
        ? com.google.cloud.aiplatform.v1.NotebookRuntimeType.UNRECOGNIZED
        : result;
  }

  public static final int SHIELDED_VM_CONFIG_FIELD_NUMBER = 20;
  private com.google.cloud.aiplatform.v1.ShieldedVmConfig shieldedVmConfig_;
  /**
   *
   *
   * <pre>
   * Optional. Immutable. Runtime Shielded VM spec.
   * </pre>
   *
   * <code>
   * .google.cloud.aiplatform.v1.ShieldedVmConfig shielded_vm_config = 20 [(.google.api.field_behavior) = OPTIONAL, (.google.api.field_behavior) = IMMUTABLE];
   * </code>
   *
   * @return Whether the shieldedVmConfig field is set.
   */
  @java.lang.Override
  public boolean hasShieldedVmConfig() {
    return ((bitField0_ & 0x00000080) != 0);
  }
  /**
   *
   *
   * <pre>
   * Optional. Immutable. Runtime Shielded VM spec.
   * </pre>
   *
   * <code>
   * .google.cloud.aiplatform.v1.ShieldedVmConfig shielded_vm_config = 20 [(.google.api.field_behavior) = OPTIONAL, (.google.api.field_behavior) = IMMUTABLE];
   * </code>
   *
   * @return The shieldedVmConfig.
   */
  @java.lang.Override
  public com.google.cloud.aiplatform.v1.ShieldedVmConfig getShieldedVmConfig() {
    return shieldedVmConfig_ == null
        ? com.google.cloud.aiplatform.v1.ShieldedVmConfig.getDefaultInstance()
        : shieldedVmConfig_;
  }
  /**
   *
   *
   * <pre>
   * Optional. Immutable. Runtime Shielded VM spec.
   * </pre>
   *
   * <code>
   * .google.cloud.aiplatform.v1.ShieldedVmConfig shielded_vm_config = 20 [(.google.api.field_behavior) = OPTIONAL, (.google.api.field_behavior) = IMMUTABLE];
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.aiplatform.v1.ShieldedVmConfigOrBuilder getShieldedVmConfigOrBuilder() {
    return shieldedVmConfig_ == null
        ? com.google.cloud.aiplatform.v1.ShieldedVmConfig.getDefaultInstance()
        : shieldedVmConfig_;
  }

  public static final int NETWORK_TAGS_FIELD_NUMBER = 21;

  @SuppressWarnings("serial")
  private com.google.protobuf.LazyStringArrayList networkTags_ =
      com.google.protobuf.LazyStringArrayList.emptyList();
  /**
   *
   *
   * <pre>
   * Optional. The Compute Engine tags to add to runtime (see [Tagging
   * instances](https://cloud.google.com/vpc/docs/add-remove-network-tags)).
   * </pre>
   *
   * <code>repeated string network_tags = 21 [(.google.api.field_behavior) = OPTIONAL];</code>
   *
   * @return A list containing the networkTags.
   */
  public com.google.protobuf.ProtocolStringList getNetworkTagsList() {
    return networkTags_;
  }
  /**
   *
   *
   * <pre>
   * Optional. The Compute Engine tags to add to runtime (see [Tagging
   * instances](https://cloud.google.com/vpc/docs/add-remove-network-tags)).
   * </pre>
   *
   * <code>repeated string network_tags = 21 [(.google.api.field_behavior) = OPTIONAL];</code>
   *
   * @return The count of networkTags.
   */
  public int getNetworkTagsCount() {
    return networkTags_.size();
  }
  /**
   *
   *
   * <pre>
   * Optional. The Compute Engine tags to add to runtime (see [Tagging
   * instances](https://cloud.google.com/vpc/docs/add-remove-network-tags)).
   * </pre>
   *
   * <code>repeated string network_tags = 21 [(.google.api.field_behavior) = OPTIONAL];</code>
   *
   * @param index The index of the element to return.
   * @return The networkTags at the given index.
   */
  public java.lang.String getNetworkTags(int index) {
    return networkTags_.get(index);
  }
  /**
   *
   *
   * <pre>
   * Optional. The Compute Engine tags to add to runtime (see [Tagging
   * instances](https://cloud.google.com/vpc/docs/add-remove-network-tags)).
   * </pre>
   *
   * <code>repeated string network_tags = 21 [(.google.api.field_behavior) = OPTIONAL];</code>
   *
   * @param index The index of the value to return.
   * @return The bytes of the networkTags at the given index.
   */
  public com.google.protobuf.ByteString getNetworkTagsBytes(int index) {
    return networkTags_.getByteString(index);
  }

  public static final int ENCRYPTION_SPEC_FIELD_NUMBER = 23;
  private com.google.cloud.aiplatform.v1.EncryptionSpec encryptionSpec_;
  /**
   *
   *
   * <pre>
   * Customer-managed encryption key spec for the notebook runtime.
   * </pre>
   *
   * <code>.google.cloud.aiplatform.v1.EncryptionSpec encryption_spec = 23;</code>
   *
   * @return Whether the encryptionSpec field is set.
   */
  @java.lang.Override
  public boolean hasEncryptionSpec() {
    return ((bitField0_ & 0x00000100) != 0);
  }
  /**
   *
   *
   * <pre>
   * Customer-managed encryption key spec for the notebook runtime.
   * </pre>
   *
   * <code>.google.cloud.aiplatform.v1.EncryptionSpec encryption_spec = 23;</code>
   *
   * @return The encryptionSpec.
   */
  @java.lang.Override
  public com.google.cloud.aiplatform.v1.EncryptionSpec getEncryptionSpec() {
    return encryptionSpec_ == null
        ? com.google.cloud.aiplatform.v1.EncryptionSpec.getDefaultInstance()
        : encryptionSpec_;
  }
  /**
   *
   *
   * <pre>
   * Customer-managed encryption key spec for the notebook runtime.
   * </pre>
   *
   * <code>.google.cloud.aiplatform.v1.EncryptionSpec encryption_spec = 23;</code>
   */
  @java.lang.Override
  public com.google.cloud.aiplatform.v1.EncryptionSpecOrBuilder getEncryptionSpecOrBuilder() {
    return encryptionSpec_ == null
        ? com.google.cloud.aiplatform.v1.EncryptionSpec.getDefaultInstance()
        : encryptionSpec_;
  }

  public static final int SOFTWARE_CONFIG_FIELD_NUMBER = 24;
  private com.google.cloud.aiplatform.v1.NotebookSoftwareConfig softwareConfig_;
  /**
   *
   *
   * <pre>
   * Optional. The notebook software configuration of the notebook runtime.
   * </pre>
   *
   * <code>
   * .google.cloud.aiplatform.v1.NotebookSoftwareConfig software_config = 24 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   *
   * @return Whether the softwareConfig field is set.
   */
  @java.lang.Override
  public boolean hasSoftwareConfig() {
    return ((bitField0_ & 0x00000200) != 0);
  }
  /**
   *
   *
   * <pre>
   * Optional. The notebook software configuration of the notebook runtime.
   * </pre>
   *
   * <code>
   * .google.cloud.aiplatform.v1.NotebookSoftwareConfig software_config = 24 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   *
   * @return The softwareConfig.
   */
  @java.lang.Override
  public com.google.cloud.aiplatform.v1.NotebookSoftwareConfig getSoftwareConfig() {
    return softwareConfig_ == null
        ? com.google.cloud.aiplatform.v1.NotebookSoftwareConfig.getDefaultInstance()
        : softwareConfig_;
  }
  /**
   *
   *
   * <pre>
   * Optional. The notebook software configuration of the notebook runtime.
   * </pre>
   *
   * <code>
   * .google.cloud.aiplatform.v1.NotebookSoftwareConfig software_config = 24 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.aiplatform.v1.NotebookSoftwareConfigOrBuilder
      getSoftwareConfigOrBuilder() {
    return softwareConfig_ == null
        ? com.google.cloud.aiplatform.v1.NotebookSoftwareConfig.getDefaultInstance()
        : softwareConfig_;
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(name_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 1, name_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(displayName_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 2, displayName_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(description_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 3, description_);
    }
    if (isDefault_ != false) {
      output.writeBool(4, isDefault_);
    }
    if (((bitField0_ & 0x00000001) != 0)) {
      output.writeMessage(5, getMachineSpec());
    }
    if (((bitField0_ & 0x00000002) != 0)) {
      output.writeMessage(8, getDataPersistentDiskSpec());
    }
    if (((bitField0_ & 0x00000020) != 0)) {
      output.writeMessage(10, getCreateTime());
    }
    if (((bitField0_ & 0x00000040) != 0)) {
      output.writeMessage(11, getUpdateTime());
    }
    if (((bitField0_ & 0x00000004) != 0)) {
      output.writeMessage(12, getNetworkSpec());
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(serviceAccount_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 13, serviceAccount_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(etag_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 14, etag_);
    }
    com.google.protobuf.GeneratedMessageV3.serializeStringMapTo(
        output, internalGetLabels(), LabelsDefaultEntryHolder.defaultEntry, 15);
    if (((bitField0_ & 0x00000008) != 0)) {
      output.writeMessage(17, getIdleShutdownConfig());
    }
    if (((bitField0_ & 0x00000010) != 0)) {
      output.writeMessage(18, getEucConfig());
    }
    if (notebookRuntimeType_
        != com.google.cloud.aiplatform.v1.NotebookRuntimeType.NOTEBOOK_RUNTIME_TYPE_UNSPECIFIED
            .getNumber()) {
      output.writeEnum(19, notebookRuntimeType_);
    }
    if (((bitField0_ & 0x00000080) != 0)) {
      output.writeMessage(20, getShieldedVmConfig());
    }
    for (int i = 0; i < networkTags_.size(); i++) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 21, networkTags_.getRaw(i));
    }
    if (((bitField0_ & 0x00000100) != 0)) {
      output.writeMessage(23, getEncryptionSpec());
    }
    if (((bitField0_ & 0x00000200) != 0)) {
      output.writeMessage(24, getSoftwareConfig());
    }
    getUnknownFields().writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(name_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(1, name_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(displayName_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(2, displayName_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(description_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(3, description_);
    }
    if (isDefault_ != false) {
      size += com.google.protobuf.CodedOutputStream.computeBoolSize(4, isDefault_);
    }
    if (((bitField0_ & 0x00000001) != 0)) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(5, getMachineSpec());
    }
    if (((bitField0_ & 0x00000002) != 0)) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(8, getDataPersistentDiskSpec());
    }
    if (((bitField0_ & 0x00000020) != 0)) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(10, getCreateTime());
    }
    if (((bitField0_ & 0x00000040) != 0)) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(11, getUpdateTime());
    }
    if (((bitField0_ & 0x00000004) != 0)) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(12, getNetworkSpec());
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(serviceAccount_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(13, serviceAccount_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(etag_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(14, etag_);
    }
    for (java.util.Map.Entry<java.lang.String, java.lang.String> entry :
        internalGetLabels().getMap().entrySet()) {
      com.google.protobuf.MapEntry<java.lang.String, java.lang.String> labels__ =
          LabelsDefaultEntryHolder.defaultEntry
              .newBuilderForType()
              .setKey(entry.getKey())
              .setValue(entry.getValue())
              .build();
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(15, labels__);
    }
    if (((bitField0_ & 0x00000008) != 0)) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(17, getIdleShutdownConfig());
    }
    if (((bitField0_ & 0x00000010) != 0)) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(18, getEucConfig());
    }
    if (notebookRuntimeType_
        != com.google.cloud.aiplatform.v1.NotebookRuntimeType.NOTEBOOK_RUNTIME_TYPE_UNSPECIFIED
            .getNumber()) {
      size += com.google.protobuf.CodedOutputStream.computeEnumSize(19, notebookRuntimeType_);
    }
    if (((bitField0_ & 0x00000080) != 0)) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(20, getShieldedVmConfig());
    }
    {
      int dataSize = 0;
      for (int i = 0; i < networkTags_.size(); i++) {
        dataSize += computeStringSizeNoTag(networkTags_.getRaw(i));
      }
      size += dataSize;
      size += 2 * getNetworkTagsList().size();
    }
    if (((bitField0_ & 0x00000100) != 0)) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(23, getEncryptionSpec());
    }
    if (((bitField0_ & 0x00000200) != 0)) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(24, getSoftwareConfig());
    }
    size += getUnknownFields().getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.cloud.aiplatform.v1.NotebookRuntimeTemplate)) {
      return super.equals(obj);
    }
    com.google.cloud.aiplatform.v1.NotebookRuntimeTemplate other =
        (com.google.cloud.aiplatform.v1.NotebookRuntimeTemplate) obj;

    if (!getName().equals(other.getName())) return false;
    if (!getDisplayName().equals(other.getDisplayName())) return false;
    if (!getDescription().equals(other.getDescription())) return false;
    if (getIsDefault() != other.getIsDefault()) return false;
    if (hasMachineSpec() != other.hasMachineSpec()) return false;
    if (hasMachineSpec()) {
      if (!getMachineSpec().equals(other.getMachineSpec())) return false;
    }
    if (hasDataPersistentDiskSpec() != other.hasDataPersistentDiskSpec()) return false;
    if (hasDataPersistentDiskSpec()) {
      if (!getDataPersistentDiskSpec().equals(other.getDataPersistentDiskSpec())) return false;
    }
    if (hasNetworkSpec() != other.hasNetworkSpec()) return false;
    if (hasNetworkSpec()) {
      if (!getNetworkSpec().equals(other.getNetworkSpec())) return false;
    }
    if (!getServiceAccount().equals(other.getServiceAccount())) return false;
    if (!getEtag().equals(other.getEtag())) return false;
    if (!internalGetLabels().equals(other.internalGetLabels())) return false;
    if (hasIdleShutdownConfig() != other.hasIdleShutdownConfig()) return false;
    if (hasIdleShutdownConfig()) {
      if (!getIdleShutdownConfig().equals(other.getIdleShutdownConfig())) return false;
    }
    if (hasEucConfig() != other.hasEucConfig()) return false;
    if (hasEucConfig()) {
      if (!getEucConfig().equals(other.getEucConfig())) return false;
    }
    if (hasCreateTime() != other.hasCreateTime()) return false;
    if (hasCreateTime()) {
      if (!getCreateTime().equals(other.getCreateTime())) return false;
    }
    if (hasUpdateTime() != other.hasUpdateTime()) return false;
    if (hasUpdateTime()) {
      if (!getUpdateTime().equals(other.getUpdateTime())) return false;
    }
    if (notebookRuntimeType_ != other.notebookRuntimeType_) return false;
    if (hasShieldedVmConfig() != other.hasShieldedVmConfig()) return false;
    if (hasShieldedVmConfig()) {
      if (!getShieldedVmConfig().equals(other.getShieldedVmConfig())) return false;
    }
    if (!getNetworkTagsList().equals(other.getNetworkTagsList())) return false;
    if (hasEncryptionSpec() != other.hasEncryptionSpec()) return false;
    if (hasEncryptionSpec()) {
      if (!getEncryptionSpec().equals(other.getEncryptionSpec())) return false;
    }
    if (hasSoftwareConfig() != other.hasSoftwareConfig()) return false;
    if (hasSoftwareConfig()) {
      if (!getSoftwareConfig().equals(other.getSoftwareConfig())) return false;
    }
    if (!getUnknownFields().equals(other.getUnknownFields())) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    hash = (37 * hash) + NAME_FIELD_NUMBER;
    hash = (53 * hash) + getName().hashCode();
    hash = (37 * hash) + DISPLAY_NAME_FIELD_NUMBER;
    hash = (53 * hash) + getDisplayName().hashCode();
    hash = (37 * hash) + DESCRIPTION_FIELD_NUMBER;
    hash = (53 * hash) + getDescription().hashCode();
    hash = (37 * hash) + IS_DEFAULT_FIELD_NUMBER;
    hash = (53 * hash) + com.google.protobuf.Internal.hashBoolean(getIsDefault());
    if (hasMachineSpec()) {
      hash = (37 * hash) + MACHINE_SPEC_FIELD_NUMBER;
      hash = (53 * hash) + getMachineSpec().hashCode();
    }
    if (hasDataPersistentDiskSpec()) {
      hash = (37 * hash) + DATA_PERSISTENT_DISK_SPEC_FIELD_NUMBER;
      hash = (53 * hash) + getDataPersistentDiskSpec().hashCode();
    }
    if (hasNetworkSpec()) {
      hash = (37 * hash) + NETWORK_SPEC_FIELD_NUMBER;
      hash = (53 * hash) + getNetworkSpec().hashCode();
    }
    hash = (37 * hash) + SERVICE_ACCOUNT_FIELD_NUMBER;
    hash = (53 * hash) + getServiceAccount().hashCode();
    hash = (37 * hash) + ETAG_FIELD_NUMBER;
    hash = (53 * hash) + getEtag().hashCode();
    if (!internalGetLabels().getMap().isEmpty()) {
      hash = (37 * hash) + LABELS_FIELD_NUMBER;
      hash = (53 * hash) + internalGetLabels().hashCode();
    }
    if (hasIdleShutdownConfig()) {
      hash = (37 * hash) + IDLE_SHUTDOWN_CONFIG_FIELD_NUMBER;
      hash = (53 * hash) + getIdleShutdownConfig().hashCode();
    }
    if (hasEucConfig()) {
      hash = (37 * hash) + EUC_CONFIG_FIELD_NUMBER;
      hash = (53 * hash) + getEucConfig().hashCode();
    }
    if (hasCreateTime()) {
      hash = (37 * hash) + CREATE_TIME_FIELD_NUMBER;
      hash = (53 * hash) + getCreateTime().hashCode();
    }
    if (hasUpdateTime()) {
      hash = (37 * hash) + UPDATE_TIME_FIELD_NUMBER;
      hash = (53 * hash) + getUpdateTime().hashCode();
    }
    hash = (37 * hash) + NOTEBOOK_RUNTIME_TYPE_FIELD_NUMBER;
    hash = (53 * hash) + notebookRuntimeType_;
    if (hasShieldedVmConfig()) {
      hash = (37 * hash) + SHIELDED_VM_CONFIG_FIELD_NUMBER;
      hash = (53 * hash) + getShieldedVmConfig().hashCode();
    }
    if (getNetworkTagsCount() > 0) {
      hash = (37 * hash) + NETWORK_TAGS_FIELD_NUMBER;
      hash = (53 * hash) + getNetworkTagsList().hashCode();
    }
    if (hasEncryptionSpec()) {
      hash = (37 * hash) + ENCRYPTION_SPEC_FIELD_NUMBER;
      hash = (53 * hash) + getEncryptionSpec().hashCode();
    }
    if (hasSoftwareConfig()) {
      hash = (37 * hash) + SOFTWARE_CONFIG_FIELD_NUMBER;
      hash = (53 * hash) + getSoftwareConfig().hashCode();
    }
    hash = (29 * hash) + getUnknownFields().hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.cloud.aiplatform.v1.NotebookRuntimeTemplate parseFrom(
      java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.aiplatform.v1.NotebookRuntimeTemplate parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.aiplatform.v1.NotebookRuntimeTemplate parseFrom(
      com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.aiplatform.v1.NotebookRuntimeTemplate parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.aiplatform.v1.NotebookRuntimeTemplate parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.aiplatform.v1.NotebookRuntimeTemplate parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.aiplatform.v1.NotebookRuntimeTemplate parseFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.aiplatform.v1.NotebookRuntimeTemplate parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.aiplatform.v1.NotebookRuntimeTemplate parseDelimitedFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.cloud.aiplatform.v1.NotebookRuntimeTemplate parseDelimitedFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.aiplatform.v1.NotebookRuntimeTemplate parseFrom(
      com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.aiplatform.v1.NotebookRuntimeTemplate parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(
      com.google.cloud.aiplatform.v1.NotebookRuntimeTemplate prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }
  /**
   *
   *
   * <pre>
   * A template that specifies runtime configurations such as machine type,
   * runtime version, network configurations, etc.
   * Multiple runtimes can be created from a runtime template.
   * </pre>
   *
   * Protobuf type {@code google.cloud.aiplatform.v1.NotebookRuntimeTemplate}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.cloud.aiplatform.v1.NotebookRuntimeTemplate)
      com.google.cloud.aiplatform.v1.NotebookRuntimeTemplateOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.aiplatform.v1.NotebookRuntimeProto
          .internal_static_google_cloud_aiplatform_v1_NotebookRuntimeTemplate_descriptor;
    }

    @SuppressWarnings({"rawtypes"})
    protected com.google.protobuf.MapFieldReflectionAccessor internalGetMapFieldReflection(
        int number) {
      switch (number) {
        case 15:
          return internalGetLabels();
        default:
          throw new RuntimeException("Invalid map field number: " + number);
      }
    }

    @SuppressWarnings({"rawtypes"})
    protected com.google.protobuf.MapFieldReflectionAccessor internalGetMutableMapFieldReflection(
        int number) {
      switch (number) {
        case 15:
          return internalGetMutableLabels();
        default:
          throw new RuntimeException("Invalid map field number: " + number);
      }
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.aiplatform.v1.NotebookRuntimeProto
          .internal_static_google_cloud_aiplatform_v1_NotebookRuntimeTemplate_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.aiplatform.v1.NotebookRuntimeTemplate.class,
              com.google.cloud.aiplatform.v1.NotebookRuntimeTemplate.Builder.class);
    }

    // Construct using com.google.cloud.aiplatform.v1.NotebookRuntimeTemplate.newBuilder()
    private Builder() {
      maybeForceBuilderInitialization();
    }

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
      maybeForceBuilderInitialization();
    }

    private void maybeForceBuilderInitialization() {
      if (com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders) {
        getMachineSpecFieldBuilder();
        getDataPersistentDiskSpecFieldBuilder();
        getNetworkSpecFieldBuilder();
        getIdleShutdownConfigFieldBuilder();
        getEucConfigFieldBuilder();
        getCreateTimeFieldBuilder();
        getUpdateTimeFieldBuilder();
        getShieldedVmConfigFieldBuilder();
        getEncryptionSpecFieldBuilder();
        getSoftwareConfigFieldBuilder();
      }
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      bitField0_ = 0;
      name_ = "";
      displayName_ = "";
      description_ = "";
      isDefault_ = false;
      machineSpec_ = null;
      if (machineSpecBuilder_ != null) {
        machineSpecBuilder_.dispose();
        machineSpecBuilder_ = null;
      }
      dataPersistentDiskSpec_ = null;
      if (dataPersistentDiskSpecBuilder_ != null) {
        dataPersistentDiskSpecBuilder_.dispose();
        dataPersistentDiskSpecBuilder_ = null;
      }
      networkSpec_ = null;
      if (networkSpecBuilder_ != null) {
        networkSpecBuilder_.dispose();
        networkSpecBuilder_ = null;
      }
      serviceAccount_ = "";
      etag_ = "";
      internalGetMutableLabels().clear();
      idleShutdownConfig_ = null;
      if (idleShutdownConfigBuilder_ != null) {
        idleShutdownConfigBuilder_.dispose();
        idleShutdownConfigBuilder_ = null;
      }
      eucConfig_ = null;
      if (eucConfigBuilder_ != null) {
        eucConfigBuilder_.dispose();
        eucConfigBuilder_ = null;
      }
      createTime_ = null;
      if (createTimeBuilder_ != null) {
        createTimeBuilder_.dispose();
        createTimeBuilder_ = null;
      }
      updateTime_ = null;
      if (updateTimeBuilder_ != null) {
        updateTimeBuilder_.dispose();
        updateTimeBuilder_ = null;
      }
      notebookRuntimeType_ = 0;
      shieldedVmConfig_ = null;
      if (shieldedVmConfigBuilder_ != null) {
        shieldedVmConfigBuilder_.dispose();
        shieldedVmConfigBuilder_ = null;
      }
      networkTags_ = com.google.protobuf.LazyStringArrayList.emptyList();
      encryptionSpec_ = null;
      if (encryptionSpecBuilder_ != null) {
        encryptionSpecBuilder_.dispose();
        encryptionSpecBuilder_ = null;
      }
      softwareConfig_ = null;
      if (softwareConfigBuilder_ != null) {
        softwareConfigBuilder_.dispose();
        softwareConfigBuilder_ = null;
      }
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.cloud.aiplatform.v1.NotebookRuntimeProto
          .internal_static_google_cloud_aiplatform_v1_NotebookRuntimeTemplate_descriptor;
    }

    @java.lang.Override
    public com.google.cloud.aiplatform.v1.NotebookRuntimeTemplate getDefaultInstanceForType() {
      return com.google.cloud.aiplatform.v1.NotebookRuntimeTemplate.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.cloud.aiplatform.v1.NotebookRuntimeTemplate build() {
      com.google.cloud.aiplatform.v1.NotebookRuntimeTemplate result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.cloud.aiplatform.v1.NotebookRuntimeTemplate buildPartial() {
      com.google.cloud.aiplatform.v1.NotebookRuntimeTemplate result =
          new com.google.cloud.aiplatform.v1.NotebookRuntimeTemplate(this);
      if (bitField0_ != 0) {
        buildPartial0(result);
      }
      onBuilt();
      return result;
    }

    private void buildPartial0(com.google.cloud.aiplatform.v1.NotebookRuntimeTemplate result) {
      int from_bitField0_ = bitField0_;
      if (((from_bitField0_ & 0x00000001) != 0)) {
        result.name_ = name_;
      }
      if (((from_bitField0_ & 0x00000002) != 0)) {
        result.displayName_ = displayName_;
      }
      if (((from_bitField0_ & 0x00000004) != 0)) {
        result.description_ = description_;
      }
      if (((from_bitField0_ & 0x00000008) != 0)) {
        result.isDefault_ = isDefault_;
      }
      int to_bitField0_ = 0;
      if (((from_bitField0_ & 0x00000010) != 0)) {
        result.machineSpec_ =
            machineSpecBuilder_ == null ? machineSpec_ : machineSpecBuilder_.build();
        to_bitField0_ |= 0x00000001;
      }
      if (((from_bitField0_ & 0x00000020) != 0)) {
        result.dataPersistentDiskSpec_ =
            dataPersistentDiskSpecBuilder_ == null
                ? dataPersistentDiskSpec_
                : dataPersistentDiskSpecBuilder_.build();
        to_bitField0_ |= 0x00000002;
      }
      if (((from_bitField0_ & 0x00000040) != 0)) {
        result.networkSpec_ =
            networkSpecBuilder_ == null ? networkSpec_ : networkSpecBuilder_.build();
        to_bitField0_ |= 0x00000004;
      }
      if (((from_bitField0_ & 0x00000080) != 0)) {
        result.serviceAccount_ = serviceAccount_;
      }
      if (((from_bitField0_ & 0x00000100) != 0)) {
        result.etag_ = etag_;
      }
      if (((from_bitField0_ & 0x00000200) != 0)) {
        result.labels_ = internalGetLabels();
        result.labels_.makeImmutable();
      }
      if (((from_bitField0_ & 0x00000400) != 0)) {
        result.idleShutdownConfig_ =
            idleShutdownConfigBuilder_ == null
                ? idleShutdownConfig_
                : idleShutdownConfigBuilder_.build();
        to_bitField0_ |= 0x00000008;
      }
      if (((from_bitField0_ & 0x00000800) != 0)) {
        result.eucConfig_ = eucConfigBuilder_ == null ? eucConfig_ : eucConfigBuilder_.build();
        to_bitField0_ |= 0x00000010;
      }
      if (((from_bitField0_ & 0x00001000) != 0)) {
        result.createTime_ = createTimeBuilder_ == null ? createTime_ : createTimeBuilder_.build();
        to_bitField0_ |= 0x00000020;
      }
      if (((from_bitField0_ & 0x00002000) != 0)) {
        result.updateTime_ = updateTimeBuilder_ == null ? updateTime_ : updateTimeBuilder_.build();
        to_bitField0_ |= 0x00000040;
      }
      if (((from_bitField0_ & 0x00004000) != 0)) {
        result.notebookRuntimeType_ = notebookRuntimeType_;
      }
      if (((from_bitField0_ & 0x00008000) != 0)) {
        result.shieldedVmConfig_ =
            shieldedVmConfigBuilder_ == null ? shieldedVmConfig_ : shieldedVmConfigBuilder_.build();
        to_bitField0_ |= 0x00000080;
      }
      if (((from_bitField0_ & 0x00010000) != 0)) {
        networkTags_.makeImmutable();
        result.networkTags_ = networkTags_;
      }
      if (((from_bitField0_ & 0x00020000) != 0)) {
        result.encryptionSpec_ =
            encryptionSpecBuilder_ == null ? encryptionSpec_ : encryptionSpecBuilder_.build();
        to_bitField0_ |= 0x00000100;
      }
      if (((from_bitField0_ & 0x00040000) != 0)) {
        result.softwareConfig_ =
            softwareConfigBuilder_ == null ? softwareConfig_ : softwareConfigBuilder_.build();
        to_bitField0_ |= 0x00000200;
      }
      result.bitField0_ |= to_bitField0_;
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.cloud.aiplatform.v1.NotebookRuntimeTemplate) {
        return mergeFrom((com.google.cloud.aiplatform.v1.NotebookRuntimeTemplate) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(com.google.cloud.aiplatform.v1.NotebookRuntimeTemplate other) {
      if (other == com.google.cloud.aiplatform.v1.NotebookRuntimeTemplate.getDefaultInstance())
        return this;
      if (!other.getName().isEmpty()) {
        name_ = other.name_;
        bitField0_ |= 0x00000001;
        onChanged();
      }
      if (!other.getDisplayName().isEmpty()) {
        displayName_ = other.displayName_;
        bitField0_ |= 0x00000002;
        onChanged();
      }
      if (!other.getDescription().isEmpty()) {
        description_ = other.description_;
        bitField0_ |= 0x00000004;
        onChanged();
      }
      if (other.getIsDefault() != false) {
        setIsDefault(other.getIsDefault());
      }
      if (other.hasMachineSpec()) {
        mergeMachineSpec(other.getMachineSpec());
      }
      if (other.hasDataPersistentDiskSpec()) {
        mergeDataPersistentDiskSpec(other.getDataPersistentDiskSpec());
      }
      if (other.hasNetworkSpec()) {
        mergeNetworkSpec(other.getNetworkSpec());
      }
      if (!other.getServiceAccount().isEmpty()) {
        serviceAccount_ = other.serviceAccount_;
        bitField0_ |= 0x00000080;
        onChanged();
      }
      if (!other.getEtag().isEmpty()) {
        etag_ = other.etag_;
        bitField0_ |= 0x00000100;
        onChanged();
      }
      internalGetMutableLabels().mergeFrom(other.internalGetLabels());
      bitField0_ |= 0x00000200;
      if (other.hasIdleShutdownConfig()) {
        mergeIdleShutdownConfig(other.getIdleShutdownConfig());
      }
      if (other.hasEucConfig()) {
        mergeEucConfig(other.getEucConfig());
      }
      if (other.hasCreateTime()) {
        mergeCreateTime(other.getCreateTime());
      }
      if (other.hasUpdateTime()) {
        mergeUpdateTime(other.getUpdateTime());
      }
      if (other.notebookRuntimeType_ != 0) {
        setNotebookRuntimeTypeValue(other.getNotebookRuntimeTypeValue());
      }
      if (other.hasShieldedVmConfig()) {
        mergeShieldedVmConfig(other.getShieldedVmConfig());
      }
      if (!other.networkTags_.isEmpty()) {
        if (networkTags_.isEmpty()) {
          networkTags_ = other.networkTags_;
          bitField0_ |= 0x00010000;
        } else {
          ensureNetworkTagsIsMutable();
          networkTags_.addAll(other.networkTags_);
        }
        onChanged();
      }
      if (other.hasEncryptionSpec()) {
        mergeEncryptionSpec(other.getEncryptionSpec());
      }
      if (other.hasSoftwareConfig()) {
        mergeSoftwareConfig(other.getSoftwareConfig());
      }
      this.mergeUnknownFields(other.getUnknownFields());
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 10:
              {
                name_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000001;
                break;
              } // case 10
            case 18:
              {
                displayName_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000002;
                break;
              } // case 18
            case 26:
              {
                description_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000004;
                break;
              } // case 26
            case 32:
              {
                isDefault_ = input.readBool();
                bitField0_ |= 0x00000008;
                break;
              } // case 32
            case 42:
              {
                input.readMessage(getMachineSpecFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000010;
                break;
              } // case 42
            case 66:
              {
                input.readMessage(
                    getDataPersistentDiskSpecFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000020;
                break;
              } // case 66
            case 82:
              {
                input.readMessage(getCreateTimeFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00001000;
                break;
              } // case 82
            case 90:
              {
                input.readMessage(getUpdateTimeFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00002000;
                break;
              } // case 90
            case 98:
              {
                input.readMessage(getNetworkSpecFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000040;
                break;
              } // case 98
            case 106:
              {
                serviceAccount_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000080;
                break;
              } // case 106
            case 114:
              {
                etag_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000100;
                break;
              } // case 114
            case 122:
              {
                com.google.protobuf.MapEntry<java.lang.String, java.lang.String> labels__ =
                    input.readMessage(
                        LabelsDefaultEntryHolder.defaultEntry.getParserForType(),
                        extensionRegistry);
                internalGetMutableLabels()
                    .getMutableMap()
                    .put(labels__.getKey(), labels__.getValue());
                bitField0_ |= 0x00000200;
                break;
              } // case 122
            case 138:
              {
                input.readMessage(
                    getIdleShutdownConfigFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000400;
                break;
              } // case 138
            case 146:
              {
                input.readMessage(getEucConfigFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000800;
                break;
              } // case 146
            case 152:
              {
                notebookRuntimeType_ = input.readEnum();
                bitField0_ |= 0x00004000;
                break;
              } // case 152
            case 162:
              {
                input.readMessage(
                    getShieldedVmConfigFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00008000;
                break;
              } // case 162
            case 170:
              {
                java.lang.String s = input.readStringRequireUtf8();
                ensureNetworkTagsIsMutable();
                networkTags_.add(s);
                break;
              } // case 170
            case 186:
              {
                input.readMessage(getEncryptionSpecFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00020000;
                break;
              } // case 186
            case 194:
              {
                input.readMessage(getSoftwareConfigFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00040000;
                break;
              } // case 194
            default:
              {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
          } // switch (tag)
        } // while (!done)
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.unwrapIOException();
      } finally {
        onChanged();
      } // finally
      return this;
    }

    private int bitField0_;

    private java.lang.Object name_ = "";
    /**
     *
     *
     * <pre>
     * The resource name of the NotebookRuntimeTemplate.
     * </pre>
     *
     * <code>string name = 1;</code>
     *
     * @return The name.
     */
    public java.lang.String getName() {
      java.lang.Object ref = name_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        name_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * The resource name of the NotebookRuntimeTemplate.
     * </pre>
     *
     * <code>string name = 1;</code>
     *
     * @return The bytes for name.
     */
    public com.google.protobuf.ByteString getNameBytes() {
      java.lang.Object ref = name_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        name_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * The resource name of the NotebookRuntimeTemplate.
     * </pre>
     *
     * <code>string name = 1;</code>
     *
     * @param value The name to set.
     * @return This builder for chaining.
     */
    public Builder setName(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      name_ = value;
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The resource name of the NotebookRuntimeTemplate.
     * </pre>
     *
     * <code>string name = 1;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearName() {
      name_ = getDefaultInstance().getName();
      bitField0_ = (bitField0_ & ~0x00000001);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The resource name of the NotebookRuntimeTemplate.
     * </pre>
     *
     * <code>string name = 1;</code>
     *
     * @param value The bytes for name to set.
     * @return This builder for chaining.
     */
    public Builder setNameBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      name_ = value;
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }

    private java.lang.Object displayName_ = "";
    /**
     *
     *
     * <pre>
     * Required. The display name of the NotebookRuntimeTemplate.
     * The name can be up to 128 characters long and can consist of any UTF-8
     * characters.
     * </pre>
     *
     * <code>string display_name = 2 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return The displayName.
     */
    public java.lang.String getDisplayName() {
      java.lang.Object ref = displayName_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        displayName_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Required. The display name of the NotebookRuntimeTemplate.
     * The name can be up to 128 characters long and can consist of any UTF-8
     * characters.
     * </pre>
     *
     * <code>string display_name = 2 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return The bytes for displayName.
     */
    public com.google.protobuf.ByteString getDisplayNameBytes() {
      java.lang.Object ref = displayName_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        displayName_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Required. The display name of the NotebookRuntimeTemplate.
     * The name can be up to 128 characters long and can consist of any UTF-8
     * characters.
     * </pre>
     *
     * <code>string display_name = 2 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @param value The displayName to set.
     * @return This builder for chaining.
     */
    public Builder setDisplayName(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      displayName_ = value;
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. The display name of the NotebookRuntimeTemplate.
     * The name can be up to 128 characters long and can consist of any UTF-8
     * characters.
     * </pre>
     *
     * <code>string display_name = 2 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearDisplayName() {
      displayName_ = getDefaultInstance().getDisplayName();
      bitField0_ = (bitField0_ & ~0x00000002);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. The display name of the NotebookRuntimeTemplate.
     * The name can be up to 128 characters long and can consist of any UTF-8
     * characters.
     * </pre>
     *
     * <code>string display_name = 2 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @param value The bytes for displayName to set.
     * @return This builder for chaining.
     */
    public Builder setDisplayNameBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      displayName_ = value;
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }

    private java.lang.Object description_ = "";
    /**
     *
     *
     * <pre>
     * The description of the NotebookRuntimeTemplate.
     * </pre>
     *
     * <code>string description = 3;</code>
     *
     * @return The description.
     */
    public java.lang.String getDescription() {
      java.lang.Object ref = description_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        description_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * The description of the NotebookRuntimeTemplate.
     * </pre>
     *
     * <code>string description = 3;</code>
     *
     * @return The bytes for description.
     */
    public com.google.protobuf.ByteString getDescriptionBytes() {
      java.lang.Object ref = description_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        description_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * The description of the NotebookRuntimeTemplate.
     * </pre>
     *
     * <code>string description = 3;</code>
     *
     * @param value The description to set.
     * @return This builder for chaining.
     */
    public Builder setDescription(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      description_ = value;
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The description of the NotebookRuntimeTemplate.
     * </pre>
     *
     * <code>string description = 3;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearDescription() {
      description_ = getDefaultInstance().getDescription();
      bitField0_ = (bitField0_ & ~0x00000004);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The description of the NotebookRuntimeTemplate.
     * </pre>
     *
     * <code>string description = 3;</code>
     *
     * @param value The bytes for description to set.
     * @return This builder for chaining.
     */
    public Builder setDescriptionBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      description_ = value;
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }

    private boolean isDefault_;
    /**
     *
     *
     * <pre>
     * Output only. Deprecated: This field has no behavior. Use
     * notebook_runtime_type = 'ONE_CLICK' instead.
     *
     * The default template to use if not specified.
     * </pre>
     *
     * <code>bool is_default = 4 [deprecated = true, (.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @deprecated google.cloud.aiplatform.v1.NotebookRuntimeTemplate.is_default is deprecated. See
     *     google/cloud/aiplatform/v1/notebook_runtime.proto;l=74
     * @return The isDefault.
     */
    @java.lang.Override
    @java.lang.Deprecated
    public boolean getIsDefault() {
      return isDefault_;
    }
    /**
     *
     *
     * <pre>
     * Output only. Deprecated: This field has no behavior. Use
     * notebook_runtime_type = 'ONE_CLICK' instead.
     *
     * The default template to use if not specified.
     * </pre>
     *
     * <code>bool is_default = 4 [deprecated = true, (.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @deprecated google.cloud.aiplatform.v1.NotebookRuntimeTemplate.is_default is deprecated. See
     *     google/cloud/aiplatform/v1/notebook_runtime.proto;l=74
     * @param value The isDefault to set.
     * @return This builder for chaining.
     */
    @java.lang.Deprecated
    public Builder setIsDefault(boolean value) {

      isDefault_ = value;
      bitField0_ |= 0x00000008;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Deprecated: This field has no behavior. Use
     * notebook_runtime_type = 'ONE_CLICK' instead.
     *
     * The default template to use if not specified.
     * </pre>
     *
     * <code>bool is_default = 4 [deprecated = true, (.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @deprecated google.cloud.aiplatform.v1.NotebookRuntimeTemplate.is_default is deprecated. See
     *     google/cloud/aiplatform/v1/notebook_runtime.proto;l=74
     * @return This builder for chaining.
     */
    @java.lang.Deprecated
    public Builder clearIsDefault() {
      bitField0_ = (bitField0_ & ~0x00000008);
      isDefault_ = false;
      onChanged();
      return this;
    }

    private com.google.cloud.aiplatform.v1.MachineSpec machineSpec_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.aiplatform.v1.MachineSpec,
            com.google.cloud.aiplatform.v1.MachineSpec.Builder,
            com.google.cloud.aiplatform.v1.MachineSpecOrBuilder>
        machineSpecBuilder_;
    /**
     *
     *
     * <pre>
     * Optional. Immutable. The specification of a single machine for the
     * template.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1.MachineSpec machine_spec = 5 [(.google.api.field_behavior) = OPTIONAL, (.google.api.field_behavior) = IMMUTABLE];
     * </code>
     *
     * @return Whether the machineSpec field is set.
     */
    public boolean hasMachineSpec() {
      return ((bitField0_ & 0x00000010) != 0);
    }
    /**
     *
     *
     * <pre>
     * Optional. Immutable. The specification of a single machine for the
     * template.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1.MachineSpec machine_spec = 5 [(.google.api.field_behavior) = OPTIONAL, (.google.api.field_behavior) = IMMUTABLE];
     * </code>
     *
     * @return The machineSpec.
     */
    public com.google.cloud.aiplatform.v1.MachineSpec getMachineSpec() {
      if (machineSpecBuilder_ == null) {
        return machineSpec_ == null
            ? com.google.cloud.aiplatform.v1.MachineSpec.getDefaultInstance()
            : machineSpec_;
      } else {
        return machineSpecBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Optional. Immutable. The specification of a single machine for the
     * template.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1.MachineSpec machine_spec = 5 [(.google.api.field_behavior) = OPTIONAL, (.google.api.field_behavior) = IMMUTABLE];
     * </code>
     */
    public Builder setMachineSpec(com.google.cloud.aiplatform.v1.MachineSpec value) {
      if (machineSpecBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        machineSpec_ = value;
      } else {
        machineSpecBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000010;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. Immutable. The specification of a single machine for the
     * template.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1.MachineSpec machine_spec = 5 [(.google.api.field_behavior) = OPTIONAL, (.google.api.field_behavior) = IMMUTABLE];
     * </code>
     */
    public Builder setMachineSpec(
        com.google.cloud.aiplatform.v1.MachineSpec.Builder builderForValue) {
      if (machineSpecBuilder_ == null) {
        machineSpec_ = builderForValue.build();
      } else {
        machineSpecBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000010;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. Immutable. The specification of a single machine for the
     * template.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1.MachineSpec machine_spec = 5 [(.google.api.field_behavior) = OPTIONAL, (.google.api.field_behavior) = IMMUTABLE];
     * </code>
     */
    public Builder mergeMachineSpec(com.google.cloud.aiplatform.v1.MachineSpec value) {
      if (machineSpecBuilder_ == null) {
        if (((bitField0_ & 0x00000010) != 0)
            && machineSpec_ != null
            && machineSpec_ != com.google.cloud.aiplatform.v1.MachineSpec.getDefaultInstance()) {
          getMachineSpecBuilder().mergeFrom(value);
        } else {
          machineSpec_ = value;
        }
      } else {
        machineSpecBuilder_.mergeFrom(value);
      }
      if (machineSpec_ != null) {
        bitField0_ |= 0x00000010;
        onChanged();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. Immutable. The specification of a single machine for the
     * template.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1.MachineSpec machine_spec = 5 [(.google.api.field_behavior) = OPTIONAL, (.google.api.field_behavior) = IMMUTABLE];
     * </code>
     */
    public Builder clearMachineSpec() {
      bitField0_ = (bitField0_ & ~0x00000010);
      machineSpec_ = null;
      if (machineSpecBuilder_ != null) {
        machineSpecBuilder_.dispose();
        machineSpecBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. Immutable. The specification of a single machine for the
     * template.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1.MachineSpec machine_spec = 5 [(.google.api.field_behavior) = OPTIONAL, (.google.api.field_behavior) = IMMUTABLE];
     * </code>
     */
    public com.google.cloud.aiplatform.v1.MachineSpec.Builder getMachineSpecBuilder() {
      bitField0_ |= 0x00000010;
      onChanged();
      return getMachineSpecFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Optional. Immutable. The specification of a single machine for the
     * template.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1.MachineSpec machine_spec = 5 [(.google.api.field_behavior) = OPTIONAL, (.google.api.field_behavior) = IMMUTABLE];
     * </code>
     */
    public com.google.cloud.aiplatform.v1.MachineSpecOrBuilder getMachineSpecOrBuilder() {
      if (machineSpecBuilder_ != null) {
        return machineSpecBuilder_.getMessageOrBuilder();
      } else {
        return machineSpec_ == null
            ? com.google.cloud.aiplatform.v1.MachineSpec.getDefaultInstance()
            : machineSpec_;
      }
    }
    /**
     *
     *
     * <pre>
     * Optional. Immutable. The specification of a single machine for the
     * template.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1.MachineSpec machine_spec = 5 [(.google.api.field_behavior) = OPTIONAL, (.google.api.field_behavior) = IMMUTABLE];
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.aiplatform.v1.MachineSpec,
            com.google.cloud.aiplatform.v1.MachineSpec.Builder,
            com.google.cloud.aiplatform.v1.MachineSpecOrBuilder>
        getMachineSpecFieldBuilder() {
      if (machineSpecBuilder_ == null) {
        machineSpecBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.aiplatform.v1.MachineSpec,
                com.google.cloud.aiplatform.v1.MachineSpec.Builder,
                com.google.cloud.aiplatform.v1.MachineSpecOrBuilder>(
                getMachineSpec(), getParentForChildren(), isClean());
        machineSpec_ = null;
      }
      return machineSpecBuilder_;
    }

    private com.google.cloud.aiplatform.v1.PersistentDiskSpec dataPersistentDiskSpec_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.aiplatform.v1.PersistentDiskSpec,
            com.google.cloud.aiplatform.v1.PersistentDiskSpec.Builder,
            com.google.cloud.aiplatform.v1.PersistentDiskSpecOrBuilder>
        dataPersistentDiskSpecBuilder_;
    /**
     *
     *
     * <pre>
     * Optional. The specification of [persistent
     * disk][https://cloud.google.com/compute/docs/disks/persistent-disks]
     * attached to the runtime as data disk storage.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1.PersistentDiskSpec data_persistent_disk_spec = 8 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return Whether the dataPersistentDiskSpec field is set.
     */
    public boolean hasDataPersistentDiskSpec() {
      return ((bitField0_ & 0x00000020) != 0);
    }
    /**
     *
     *
     * <pre>
     * Optional. The specification of [persistent
     * disk][https://cloud.google.com/compute/docs/disks/persistent-disks]
     * attached to the runtime as data disk storage.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1.PersistentDiskSpec data_persistent_disk_spec = 8 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return The dataPersistentDiskSpec.
     */
    public com.google.cloud.aiplatform.v1.PersistentDiskSpec getDataPersistentDiskSpec() {
      if (dataPersistentDiskSpecBuilder_ == null) {
        return dataPersistentDiskSpec_ == null
            ? com.google.cloud.aiplatform.v1.PersistentDiskSpec.getDefaultInstance()
            : dataPersistentDiskSpec_;
      } else {
        return dataPersistentDiskSpecBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Optional. The specification of [persistent
     * disk][https://cloud.google.com/compute/docs/disks/persistent-disks]
     * attached to the runtime as data disk storage.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1.PersistentDiskSpec data_persistent_disk_spec = 8 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder setDataPersistentDiskSpec(
        com.google.cloud.aiplatform.v1.PersistentDiskSpec value) {
      if (dataPersistentDiskSpecBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        dataPersistentDiskSpec_ = value;
      } else {
        dataPersistentDiskSpecBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000020;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. The specification of [persistent
     * disk][https://cloud.google.com/compute/docs/disks/persistent-disks]
     * attached to the runtime as data disk storage.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1.PersistentDiskSpec data_persistent_disk_spec = 8 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder setDataPersistentDiskSpec(
        com.google.cloud.aiplatform.v1.PersistentDiskSpec.Builder builderForValue) {
      if (dataPersistentDiskSpecBuilder_ == null) {
        dataPersistentDiskSpec_ = builderForValue.build();
      } else {
        dataPersistentDiskSpecBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000020;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. The specification of [persistent
     * disk][https://cloud.google.com/compute/docs/disks/persistent-disks]
     * attached to the runtime as data disk storage.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1.PersistentDiskSpec data_persistent_disk_spec = 8 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder mergeDataPersistentDiskSpec(
        com.google.cloud.aiplatform.v1.PersistentDiskSpec value) {
      if (dataPersistentDiskSpecBuilder_ == null) {
        if (((bitField0_ & 0x00000020) != 0)
            && dataPersistentDiskSpec_ != null
            && dataPersistentDiskSpec_
                != com.google.cloud.aiplatform.v1.PersistentDiskSpec.getDefaultInstance()) {
          getDataPersistentDiskSpecBuilder().mergeFrom(value);
        } else {
          dataPersistentDiskSpec_ = value;
        }
      } else {
        dataPersistentDiskSpecBuilder_.mergeFrom(value);
      }
      if (dataPersistentDiskSpec_ != null) {
        bitField0_ |= 0x00000020;
        onChanged();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. The specification of [persistent
     * disk][https://cloud.google.com/compute/docs/disks/persistent-disks]
     * attached to the runtime as data disk storage.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1.PersistentDiskSpec data_persistent_disk_spec = 8 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder clearDataPersistentDiskSpec() {
      bitField0_ = (bitField0_ & ~0x00000020);
      dataPersistentDiskSpec_ = null;
      if (dataPersistentDiskSpecBuilder_ != null) {
        dataPersistentDiskSpecBuilder_.dispose();
        dataPersistentDiskSpecBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. The specification of [persistent
     * disk][https://cloud.google.com/compute/docs/disks/persistent-disks]
     * attached to the runtime as data disk storage.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1.PersistentDiskSpec data_persistent_disk_spec = 8 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public com.google.cloud.aiplatform.v1.PersistentDiskSpec.Builder
        getDataPersistentDiskSpecBuilder() {
      bitField0_ |= 0x00000020;
      onChanged();
      return getDataPersistentDiskSpecFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Optional. The specification of [persistent
     * disk][https://cloud.google.com/compute/docs/disks/persistent-disks]
     * attached to the runtime as data disk storage.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1.PersistentDiskSpec data_persistent_disk_spec = 8 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public com.google.cloud.aiplatform.v1.PersistentDiskSpecOrBuilder
        getDataPersistentDiskSpecOrBuilder() {
      if (dataPersistentDiskSpecBuilder_ != null) {
        return dataPersistentDiskSpecBuilder_.getMessageOrBuilder();
      } else {
        return dataPersistentDiskSpec_ == null
            ? com.google.cloud.aiplatform.v1.PersistentDiskSpec.getDefaultInstance()
            : dataPersistentDiskSpec_;
      }
    }
    /**
     *
     *
     * <pre>
     * Optional. The specification of [persistent
     * disk][https://cloud.google.com/compute/docs/disks/persistent-disks]
     * attached to the runtime as data disk storage.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1.PersistentDiskSpec data_persistent_disk_spec = 8 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.aiplatform.v1.PersistentDiskSpec,
            com.google.cloud.aiplatform.v1.PersistentDiskSpec.Builder,
            com.google.cloud.aiplatform.v1.PersistentDiskSpecOrBuilder>
        getDataPersistentDiskSpecFieldBuilder() {
      if (dataPersistentDiskSpecBuilder_ == null) {
        dataPersistentDiskSpecBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.aiplatform.v1.PersistentDiskSpec,
                com.google.cloud.aiplatform.v1.PersistentDiskSpec.Builder,
                com.google.cloud.aiplatform.v1.PersistentDiskSpecOrBuilder>(
                getDataPersistentDiskSpec(), getParentForChildren(), isClean());
        dataPersistentDiskSpec_ = null;
      }
      return dataPersistentDiskSpecBuilder_;
    }

    private com.google.cloud.aiplatform.v1.NetworkSpec networkSpec_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.aiplatform.v1.NetworkSpec,
            com.google.cloud.aiplatform.v1.NetworkSpec.Builder,
            com.google.cloud.aiplatform.v1.NetworkSpecOrBuilder>
        networkSpecBuilder_;
    /**
     *
     *
     * <pre>
     * Optional. Network spec.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1.NetworkSpec network_spec = 12 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return Whether the networkSpec field is set.
     */
    public boolean hasNetworkSpec() {
      return ((bitField0_ & 0x00000040) != 0);
    }
    /**
     *
     *
     * <pre>
     * Optional. Network spec.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1.NetworkSpec network_spec = 12 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return The networkSpec.
     */
    public com.google.cloud.aiplatform.v1.NetworkSpec getNetworkSpec() {
      if (networkSpecBuilder_ == null) {
        return networkSpec_ == null
            ? com.google.cloud.aiplatform.v1.NetworkSpec.getDefaultInstance()
            : networkSpec_;
      } else {
        return networkSpecBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Optional. Network spec.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1.NetworkSpec network_spec = 12 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder setNetworkSpec(com.google.cloud.aiplatform.v1.NetworkSpec value) {
      if (networkSpecBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        networkSpec_ = value;
      } else {
        networkSpecBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000040;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. Network spec.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1.NetworkSpec network_spec = 12 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder setNetworkSpec(
        com.google.cloud.aiplatform.v1.NetworkSpec.Builder builderForValue) {
      if (networkSpecBuilder_ == null) {
        networkSpec_ = builderForValue.build();
      } else {
        networkSpecBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000040;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. Network spec.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1.NetworkSpec network_spec = 12 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder mergeNetworkSpec(com.google.cloud.aiplatform.v1.NetworkSpec value) {
      if (networkSpecBuilder_ == null) {
        if (((bitField0_ & 0x00000040) != 0)
            && networkSpec_ != null
            && networkSpec_ != com.google.cloud.aiplatform.v1.NetworkSpec.getDefaultInstance()) {
          getNetworkSpecBuilder().mergeFrom(value);
        } else {
          networkSpec_ = value;
        }
      } else {
        networkSpecBuilder_.mergeFrom(value);
      }
      if (networkSpec_ != null) {
        bitField0_ |= 0x00000040;
        onChanged();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. Network spec.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1.NetworkSpec network_spec = 12 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder clearNetworkSpec() {
      bitField0_ = (bitField0_ & ~0x00000040);
      networkSpec_ = null;
      if (networkSpecBuilder_ != null) {
        networkSpecBuilder_.dispose();
        networkSpecBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. Network spec.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1.NetworkSpec network_spec = 12 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public com.google.cloud.aiplatform.v1.NetworkSpec.Builder getNetworkSpecBuilder() {
      bitField0_ |= 0x00000040;
      onChanged();
      return getNetworkSpecFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Optional. Network spec.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1.NetworkSpec network_spec = 12 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public com.google.cloud.aiplatform.v1.NetworkSpecOrBuilder getNetworkSpecOrBuilder() {
      if (networkSpecBuilder_ != null) {
        return networkSpecBuilder_.getMessageOrBuilder();
      } else {
        return networkSpec_ == null
            ? com.google.cloud.aiplatform.v1.NetworkSpec.getDefaultInstance()
            : networkSpec_;
      }
    }
    /**
     *
     *
     * <pre>
     * Optional. Network spec.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1.NetworkSpec network_spec = 12 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.aiplatform.v1.NetworkSpec,
            com.google.cloud.aiplatform.v1.NetworkSpec.Builder,
            com.google.cloud.aiplatform.v1.NetworkSpecOrBuilder>
        getNetworkSpecFieldBuilder() {
      if (networkSpecBuilder_ == null) {
        networkSpecBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.aiplatform.v1.NetworkSpec,
                com.google.cloud.aiplatform.v1.NetworkSpec.Builder,
                com.google.cloud.aiplatform.v1.NetworkSpecOrBuilder>(
                getNetworkSpec(), getParentForChildren(), isClean());
        networkSpec_ = null;
      }
      return networkSpecBuilder_;
    }

    private java.lang.Object serviceAccount_ = "";
    /**
     *
     *
     * <pre>
     * Deprecated: This field is ignored and the "Vertex AI Notebook Service
     * Account"
     * (service-PROJECT_NUMBER&#64;gcp-sa-aiplatform-vm.iam.gserviceaccount.com) is
     * used for the runtime workload identity.
     * See
     * https://cloud.google.com/iam/docs/service-agents#vertex-ai-notebook-service-account
     * for more details.
     * For NotebookExecutionJob, use NotebookExecutionJob.service_account instead.
     *
     * The service account that the runtime workload runs as.
     * You can use any service account within the same project, but you
     * must have the service account user permission to use the instance.
     *
     * If not specified, the [Compute Engine default service
     * account](https://cloud.google.com/compute/docs/access/service-accounts#default_service_account)
     * is used.
     * </pre>
     *
     * <code>string service_account = 13 [deprecated = true];</code>
     *
     * @deprecated google.cloud.aiplatform.v1.NotebookRuntimeTemplate.service_account is deprecated.
     *     See google/cloud/aiplatform/v1/notebook_runtime.proto;l=109
     * @return The serviceAccount.
     */
    @java.lang.Deprecated
    public java.lang.String getServiceAccount() {
      java.lang.Object ref = serviceAccount_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        serviceAccount_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Deprecated: This field is ignored and the "Vertex AI Notebook Service
     * Account"
     * (service-PROJECT_NUMBER&#64;gcp-sa-aiplatform-vm.iam.gserviceaccount.com) is
     * used for the runtime workload identity.
     * See
     * https://cloud.google.com/iam/docs/service-agents#vertex-ai-notebook-service-account
     * for more details.
     * For NotebookExecutionJob, use NotebookExecutionJob.service_account instead.
     *
     * The service account that the runtime workload runs as.
     * You can use any service account within the same project, but you
     * must have the service account user permission to use the instance.
     *
     * If not specified, the [Compute Engine default service
     * account](https://cloud.google.com/compute/docs/access/service-accounts#default_service_account)
     * is used.
     * </pre>
     *
     * <code>string service_account = 13 [deprecated = true];</code>
     *
     * @deprecated google.cloud.aiplatform.v1.NotebookRuntimeTemplate.service_account is deprecated.
     *     See google/cloud/aiplatform/v1/notebook_runtime.proto;l=109
     * @return The bytes for serviceAccount.
     */
    @java.lang.Deprecated
    public com.google.protobuf.ByteString getServiceAccountBytes() {
      java.lang.Object ref = serviceAccount_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        serviceAccount_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Deprecated: This field is ignored and the "Vertex AI Notebook Service
     * Account"
     * (service-PROJECT_NUMBER&#64;gcp-sa-aiplatform-vm.iam.gserviceaccount.com) is
     * used for the runtime workload identity.
     * See
     * https://cloud.google.com/iam/docs/service-agents#vertex-ai-notebook-service-account
     * for more details.
     * For NotebookExecutionJob, use NotebookExecutionJob.service_account instead.
     *
     * The service account that the runtime workload runs as.
     * You can use any service account within the same project, but you
     * must have the service account user permission to use the instance.
     *
     * If not specified, the [Compute Engine default service
     * account](https://cloud.google.com/compute/docs/access/service-accounts#default_service_account)
     * is used.
     * </pre>
     *
     * <code>string service_account = 13 [deprecated = true];</code>
     *
     * @deprecated google.cloud.aiplatform.v1.NotebookRuntimeTemplate.service_account is deprecated.
     *     See google/cloud/aiplatform/v1/notebook_runtime.proto;l=109
     * @param value The serviceAccount to set.
     * @return This builder for chaining.
     */
    @java.lang.Deprecated
    public Builder setServiceAccount(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      serviceAccount_ = value;
      bitField0_ |= 0x00000080;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Deprecated: This field is ignored and the "Vertex AI Notebook Service
     * Account"
     * (service-PROJECT_NUMBER&#64;gcp-sa-aiplatform-vm.iam.gserviceaccount.com) is
     * used for the runtime workload identity.
     * See
     * https://cloud.google.com/iam/docs/service-agents#vertex-ai-notebook-service-account
     * for more details.
     * For NotebookExecutionJob, use NotebookExecutionJob.service_account instead.
     *
     * The service account that the runtime workload runs as.
     * You can use any service account within the same project, but you
     * must have the service account user permission to use the instance.
     *
     * If not specified, the [Compute Engine default service
     * account](https://cloud.google.com/compute/docs/access/service-accounts#default_service_account)
     * is used.
     * </pre>
     *
     * <code>string service_account = 13 [deprecated = true];</code>
     *
     * @deprecated google.cloud.aiplatform.v1.NotebookRuntimeTemplate.service_account is deprecated.
     *     See google/cloud/aiplatform/v1/notebook_runtime.proto;l=109
     * @return This builder for chaining.
     */
    @java.lang.Deprecated
    public Builder clearServiceAccount() {
      serviceAccount_ = getDefaultInstance().getServiceAccount();
      bitField0_ = (bitField0_ & ~0x00000080);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Deprecated: This field is ignored and the "Vertex AI Notebook Service
     * Account"
     * (service-PROJECT_NUMBER&#64;gcp-sa-aiplatform-vm.iam.gserviceaccount.com) is
     * used for the runtime workload identity.
     * See
     * https://cloud.google.com/iam/docs/service-agents#vertex-ai-notebook-service-account
     * for more details.
     * For NotebookExecutionJob, use NotebookExecutionJob.service_account instead.
     *
     * The service account that the runtime workload runs as.
     * You can use any service account within the same project, but you
     * must have the service account user permission to use the instance.
     *
     * If not specified, the [Compute Engine default service
     * account](https://cloud.google.com/compute/docs/access/service-accounts#default_service_account)
     * is used.
     * </pre>
     *
     * <code>string service_account = 13 [deprecated = true];</code>
     *
     * @deprecated google.cloud.aiplatform.v1.NotebookRuntimeTemplate.service_account is deprecated.
     *     See google/cloud/aiplatform/v1/notebook_runtime.proto;l=109
     * @param value The bytes for serviceAccount to set.
     * @return This builder for chaining.
     */
    @java.lang.Deprecated
    public Builder setServiceAccountBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      serviceAccount_ = value;
      bitField0_ |= 0x00000080;
      onChanged();
      return this;
    }

    private java.lang.Object etag_ = "";
    /**
     *
     *
     * <pre>
     * Used to perform consistent read-modify-write updates. If not set, a blind
     * "overwrite" update happens.
     * </pre>
     *
     * <code>string etag = 14;</code>
     *
     * @return The etag.
     */
    public java.lang.String getEtag() {
      java.lang.Object ref = etag_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        etag_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Used to perform consistent read-modify-write updates. If not set, a blind
     * "overwrite" update happens.
     * </pre>
     *
     * <code>string etag = 14;</code>
     *
     * @return The bytes for etag.
     */
    public com.google.protobuf.ByteString getEtagBytes() {
      java.lang.Object ref = etag_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        etag_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Used to perform consistent read-modify-write updates. If not set, a blind
     * "overwrite" update happens.
     * </pre>
     *
     * <code>string etag = 14;</code>
     *
     * @param value The etag to set.
     * @return This builder for chaining.
     */
    public Builder setEtag(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      etag_ = value;
      bitField0_ |= 0x00000100;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Used to perform consistent read-modify-write updates. If not set, a blind
     * "overwrite" update happens.
     * </pre>
     *
     * <code>string etag = 14;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearEtag() {
      etag_ = getDefaultInstance().getEtag();
      bitField0_ = (bitField0_ & ~0x00000100);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Used to perform consistent read-modify-write updates. If not set, a blind
     * "overwrite" update happens.
     * </pre>
     *
     * <code>string etag = 14;</code>
     *
     * @param value The bytes for etag to set.
     * @return This builder for chaining.
     */
    public Builder setEtagBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      etag_ = value;
      bitField0_ |= 0x00000100;
      onChanged();
      return this;
    }

    private com.google.protobuf.MapField<java.lang.String, java.lang.String> labels_;

    private com.google.protobuf.MapField<java.lang.String, java.lang.String> internalGetLabels() {
      if (labels_ == null) {
        return com.google.protobuf.MapField.emptyMapField(LabelsDefaultEntryHolder.defaultEntry);
      }
      return labels_;
    }

    private com.google.protobuf.MapField<java.lang.String, java.lang.String>
        internalGetMutableLabels() {
      if (labels_ == null) {
        labels_ = com.google.protobuf.MapField.newMapField(LabelsDefaultEntryHolder.defaultEntry);
      }
      if (!labels_.isMutable()) {
        labels_ = labels_.copy();
      }
      bitField0_ |= 0x00000200;
      onChanged();
      return labels_;
    }

    public int getLabelsCount() {
      return internalGetLabels().getMap().size();
    }
    /**
     *
     *
     * <pre>
     * The labels with user-defined metadata to organize the
     * NotebookRuntimeTemplates.
     *
     * Label keys and values can be no longer than 64 characters
     * (Unicode codepoints), can only contain lowercase letters, numeric
     * characters, underscores and dashes. International characters are allowed.
     *
     * See https://goo.gl/xmQnxf for more information and examples of labels.
     * </pre>
     *
     * <code>map&lt;string, string&gt; labels = 15;</code>
     */
    @java.lang.Override
    public boolean containsLabels(java.lang.String key) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      return internalGetLabels().getMap().containsKey(key);
    }
    /** Use {@link #getLabelsMap()} instead. */
    @java.lang.Override
    @java.lang.Deprecated
    public java.util.Map<java.lang.String, java.lang.String> getLabels() {
      return getLabelsMap();
    }
    /**
     *
     *
     * <pre>
     * The labels with user-defined metadata to organize the
     * NotebookRuntimeTemplates.
     *
     * Label keys and values can be no longer than 64 characters
     * (Unicode codepoints), can only contain lowercase letters, numeric
     * characters, underscores and dashes. International characters are allowed.
     *
     * See https://goo.gl/xmQnxf for more information and examples of labels.
     * </pre>
     *
     * <code>map&lt;string, string&gt; labels = 15;</code>
     */
    @java.lang.Override
    public java.util.Map<java.lang.String, java.lang.String> getLabelsMap() {
      return internalGetLabels().getMap();
    }
    /**
     *
     *
     * <pre>
     * The labels with user-defined metadata to organize the
     * NotebookRuntimeTemplates.
     *
     * Label keys and values can be no longer than 64 characters
     * (Unicode codepoints), can only contain lowercase letters, numeric
     * characters, underscores and dashes. International characters are allowed.
     *
     * See https://goo.gl/xmQnxf for more information and examples of labels.
     * </pre>
     *
     * <code>map&lt;string, string&gt; labels = 15;</code>
     */
    @java.lang.Override
    public /* nullable */ java.lang.String getLabelsOrDefault(
        java.lang.String key,
        /* nullable */
        java.lang.String defaultValue) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      java.util.Map<java.lang.String, java.lang.String> map = internalGetLabels().getMap();
      return map.containsKey(key) ? map.get(key) : defaultValue;
    }
    /**
     *
     *
     * <pre>
     * The labels with user-defined metadata to organize the
     * NotebookRuntimeTemplates.
     *
     * Label keys and values can be no longer than 64 characters
     * (Unicode codepoints), can only contain lowercase letters, numeric
     * characters, underscores and dashes. International characters are allowed.
     *
     * See https://goo.gl/xmQnxf for more information and examples of labels.
     * </pre>
     *
     * <code>map&lt;string, string&gt; labels = 15;</code>
     */
    @java.lang.Override
    public java.lang.String getLabelsOrThrow(java.lang.String key) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      java.util.Map<java.lang.String, java.lang.String> map = internalGetLabels().getMap();
      if (!map.containsKey(key)) {
        throw new java.lang.IllegalArgumentException();
      }
      return map.get(key);
    }

    public Builder clearLabels() {
      bitField0_ = (bitField0_ & ~0x00000200);
      internalGetMutableLabels().getMutableMap().clear();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The labels with user-defined metadata to organize the
     * NotebookRuntimeTemplates.
     *
     * Label keys and values can be no longer than 64 characters
     * (Unicode codepoints), can only contain lowercase letters, numeric
     * characters, underscores and dashes. International characters are allowed.
     *
     * See https://goo.gl/xmQnxf for more information and examples of labels.
     * </pre>
     *
     * <code>map&lt;string, string&gt; labels = 15;</code>
     */
    public Builder removeLabels(java.lang.String key) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      internalGetMutableLabels().getMutableMap().remove(key);
      return this;
    }
    /** Use alternate mutation accessors instead. */
    @java.lang.Deprecated
    public java.util.Map<java.lang.String, java.lang.String> getMutableLabels() {
      bitField0_ |= 0x00000200;
      return internalGetMutableLabels().getMutableMap();
    }
    /**
     *
     *
     * <pre>
     * The labels with user-defined metadata to organize the
     * NotebookRuntimeTemplates.
     *
     * Label keys and values can be no longer than 64 characters
     * (Unicode codepoints), can only contain lowercase letters, numeric
     * characters, underscores and dashes. International characters are allowed.
     *
     * See https://goo.gl/xmQnxf for more information and examples of labels.
     * </pre>
     *
     * <code>map&lt;string, string&gt; labels = 15;</code>
     */
    public Builder putLabels(java.lang.String key, java.lang.String value) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      if (value == null) {
        throw new NullPointerException("map value");
      }
      internalGetMutableLabels().getMutableMap().put(key, value);
      bitField0_ |= 0x00000200;
      return this;
    }
    /**
     *
     *
     * <pre>
     * The labels with user-defined metadata to organize the
     * NotebookRuntimeTemplates.
     *
     * Label keys and values can be no longer than 64 characters
     * (Unicode codepoints), can only contain lowercase letters, numeric
     * characters, underscores and dashes. International characters are allowed.
     *
     * See https://goo.gl/xmQnxf for more information and examples of labels.
     * </pre>
     *
     * <code>map&lt;string, string&gt; labels = 15;</code>
     */
    public Builder putAllLabels(java.util.Map<java.lang.String, java.lang.String> values) {
      internalGetMutableLabels().getMutableMap().putAll(values);
      bitField0_ |= 0x00000200;
      return this;
    }

    private com.google.cloud.aiplatform.v1.NotebookIdleShutdownConfig idleShutdownConfig_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.aiplatform.v1.NotebookIdleShutdownConfig,
            com.google.cloud.aiplatform.v1.NotebookIdleShutdownConfig.Builder,
            com.google.cloud.aiplatform.v1.NotebookIdleShutdownConfigOrBuilder>
        idleShutdownConfigBuilder_;
    /**
     *
     *
     * <pre>
     * The idle shutdown configuration of NotebookRuntimeTemplate. This config
     * will only be set when idle shutdown is enabled.
     * </pre>
     *
     * <code>.google.cloud.aiplatform.v1.NotebookIdleShutdownConfig idle_shutdown_config = 17;
     * </code>
     *
     * @return Whether the idleShutdownConfig field is set.
     */
    public boolean hasIdleShutdownConfig() {
      return ((bitField0_ & 0x00000400) != 0);
    }
    /**
     *
     *
     * <pre>
     * The idle shutdown configuration of NotebookRuntimeTemplate. This config
     * will only be set when idle shutdown is enabled.
     * </pre>
     *
     * <code>.google.cloud.aiplatform.v1.NotebookIdleShutdownConfig idle_shutdown_config = 17;
     * </code>
     *
     * @return The idleShutdownConfig.
     */
    public com.google.cloud.aiplatform.v1.NotebookIdleShutdownConfig getIdleShutdownConfig() {
      if (idleShutdownConfigBuilder_ == null) {
        return idleShutdownConfig_ == null
            ? com.google.cloud.aiplatform.v1.NotebookIdleShutdownConfig.getDefaultInstance()
            : idleShutdownConfig_;
      } else {
        return idleShutdownConfigBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * The idle shutdown configuration of NotebookRuntimeTemplate. This config
     * will only be set when idle shutdown is enabled.
     * </pre>
     *
     * <code>.google.cloud.aiplatform.v1.NotebookIdleShutdownConfig idle_shutdown_config = 17;
     * </code>
     */
    public Builder setIdleShutdownConfig(
        com.google.cloud.aiplatform.v1.NotebookIdleShutdownConfig value) {
      if (idleShutdownConfigBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        idleShutdownConfig_ = value;
      } else {
        idleShutdownConfigBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000400;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The idle shutdown configuration of NotebookRuntimeTemplate. This config
     * will only be set when idle shutdown is enabled.
     * </pre>
     *
     * <code>.google.cloud.aiplatform.v1.NotebookIdleShutdownConfig idle_shutdown_config = 17;
     * </code>
     */
    public Builder setIdleShutdownConfig(
        com.google.cloud.aiplatform.v1.NotebookIdleShutdownConfig.Builder builderForValue) {
      if (idleShutdownConfigBuilder_ == null) {
        idleShutdownConfig_ = builderForValue.build();
      } else {
        idleShutdownConfigBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000400;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The idle shutdown configuration of NotebookRuntimeTemplate. This config
     * will only be set when idle shutdown is enabled.
     * </pre>
     *
     * <code>.google.cloud.aiplatform.v1.NotebookIdleShutdownConfig idle_shutdown_config = 17;
     * </code>
     */
    public Builder mergeIdleShutdownConfig(
        com.google.cloud.aiplatform.v1.NotebookIdleShutdownConfig value) {
      if (idleShutdownConfigBuilder_ == null) {
        if (((bitField0_ & 0x00000400) != 0)
            && idleShutdownConfig_ != null
            && idleShutdownConfig_
                != com.google.cloud.aiplatform.v1.NotebookIdleShutdownConfig.getDefaultInstance()) {
          getIdleShutdownConfigBuilder().mergeFrom(value);
        } else {
          idleShutdownConfig_ = value;
        }
      } else {
        idleShutdownConfigBuilder_.mergeFrom(value);
      }
      if (idleShutdownConfig_ != null) {
        bitField0_ |= 0x00000400;
        onChanged();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * The idle shutdown configuration of NotebookRuntimeTemplate. This config
     * will only be set when idle shutdown is enabled.
     * </pre>
     *
     * <code>.google.cloud.aiplatform.v1.NotebookIdleShutdownConfig idle_shutdown_config = 17;
     * </code>
     */
    public Builder clearIdleShutdownConfig() {
      bitField0_ = (bitField0_ & ~0x00000400);
      idleShutdownConfig_ = null;
      if (idleShutdownConfigBuilder_ != null) {
        idleShutdownConfigBuilder_.dispose();
        idleShutdownConfigBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The idle shutdown configuration of NotebookRuntimeTemplate. This config
     * will only be set when idle shutdown is enabled.
     * </pre>
     *
     * <code>.google.cloud.aiplatform.v1.NotebookIdleShutdownConfig idle_shutdown_config = 17;
     * </code>
     */
    public com.google.cloud.aiplatform.v1.NotebookIdleShutdownConfig.Builder
        getIdleShutdownConfigBuilder() {
      bitField0_ |= 0x00000400;
      onChanged();
      return getIdleShutdownConfigFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * The idle shutdown configuration of NotebookRuntimeTemplate. This config
     * will only be set when idle shutdown is enabled.
     * </pre>
     *
     * <code>.google.cloud.aiplatform.v1.NotebookIdleShutdownConfig idle_shutdown_config = 17;
     * </code>
     */
    public com.google.cloud.aiplatform.v1.NotebookIdleShutdownConfigOrBuilder
        getIdleShutdownConfigOrBuilder() {
      if (idleShutdownConfigBuilder_ != null) {
        return idleShutdownConfigBuilder_.getMessageOrBuilder();
      } else {
        return idleShutdownConfig_ == null
            ? com.google.cloud.aiplatform.v1.NotebookIdleShutdownConfig.getDefaultInstance()
            : idleShutdownConfig_;
      }
    }
    /**
     *
     *
     * <pre>
     * The idle shutdown configuration of NotebookRuntimeTemplate. This config
     * will only be set when idle shutdown is enabled.
     * </pre>
     *
     * <code>.google.cloud.aiplatform.v1.NotebookIdleShutdownConfig idle_shutdown_config = 17;
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.aiplatform.v1.NotebookIdleShutdownConfig,
            com.google.cloud.aiplatform.v1.NotebookIdleShutdownConfig.Builder,
            com.google.cloud.aiplatform.v1.NotebookIdleShutdownConfigOrBuilder>
        getIdleShutdownConfigFieldBuilder() {
      if (idleShutdownConfigBuilder_ == null) {
        idleShutdownConfigBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.aiplatform.v1.NotebookIdleShutdownConfig,
                com.google.cloud.aiplatform.v1.NotebookIdleShutdownConfig.Builder,
                com.google.cloud.aiplatform.v1.NotebookIdleShutdownConfigOrBuilder>(
                getIdleShutdownConfig(), getParentForChildren(), isClean());
        idleShutdownConfig_ = null;
      }
      return idleShutdownConfigBuilder_;
    }

    private com.google.cloud.aiplatform.v1.NotebookEucConfig eucConfig_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.aiplatform.v1.NotebookEucConfig,
            com.google.cloud.aiplatform.v1.NotebookEucConfig.Builder,
            com.google.cloud.aiplatform.v1.NotebookEucConfigOrBuilder>
        eucConfigBuilder_;
    /**
     *
     *
     * <pre>
     * EUC configuration of the NotebookRuntimeTemplate.
     * </pre>
     *
     * <code>.google.cloud.aiplatform.v1.NotebookEucConfig euc_config = 18;</code>
     *
     * @return Whether the eucConfig field is set.
     */
    public boolean hasEucConfig() {
      return ((bitField0_ & 0x00000800) != 0);
    }
    /**
     *
     *
     * <pre>
     * EUC configuration of the NotebookRuntimeTemplate.
     * </pre>
     *
     * <code>.google.cloud.aiplatform.v1.NotebookEucConfig euc_config = 18;</code>
     *
     * @return The eucConfig.
     */
    public com.google.cloud.aiplatform.v1.NotebookEucConfig getEucConfig() {
      if (eucConfigBuilder_ == null) {
        return eucConfig_ == null
            ? com.google.cloud.aiplatform.v1.NotebookEucConfig.getDefaultInstance()
            : eucConfig_;
      } else {
        return eucConfigBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * EUC configuration of the NotebookRuntimeTemplate.
     * </pre>
     *
     * <code>.google.cloud.aiplatform.v1.NotebookEucConfig euc_config = 18;</code>
     */
    public Builder setEucConfig(com.google.cloud.aiplatform.v1.NotebookEucConfig value) {
      if (eucConfigBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        eucConfig_ = value;
      } else {
        eucConfigBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000800;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * EUC configuration of the NotebookRuntimeTemplate.
     * </pre>
     *
     * <code>.google.cloud.aiplatform.v1.NotebookEucConfig euc_config = 18;</code>
     */
    public Builder setEucConfig(
        com.google.cloud.aiplatform.v1.NotebookEucConfig.Builder builderForValue) {
      if (eucConfigBuilder_ == null) {
        eucConfig_ = builderForValue.build();
      } else {
        eucConfigBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000800;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * EUC configuration of the NotebookRuntimeTemplate.
     * </pre>
     *
     * <code>.google.cloud.aiplatform.v1.NotebookEucConfig euc_config = 18;</code>
     */
    public Builder mergeEucConfig(com.google.cloud.aiplatform.v1.NotebookEucConfig value) {
      if (eucConfigBuilder_ == null) {
        if (((bitField0_ & 0x00000800) != 0)
            && eucConfig_ != null
            && eucConfig_
                != com.google.cloud.aiplatform.v1.NotebookEucConfig.getDefaultInstance()) {
          getEucConfigBuilder().mergeFrom(value);
        } else {
          eucConfig_ = value;
        }
      } else {
        eucConfigBuilder_.mergeFrom(value);
      }
      if (eucConfig_ != null) {
        bitField0_ |= 0x00000800;
        onChanged();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * EUC configuration of the NotebookRuntimeTemplate.
     * </pre>
     *
     * <code>.google.cloud.aiplatform.v1.NotebookEucConfig euc_config = 18;</code>
     */
    public Builder clearEucConfig() {
      bitField0_ = (bitField0_ & ~0x00000800);
      eucConfig_ = null;
      if (eucConfigBuilder_ != null) {
        eucConfigBuilder_.dispose();
        eucConfigBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * EUC configuration of the NotebookRuntimeTemplate.
     * </pre>
     *
     * <code>.google.cloud.aiplatform.v1.NotebookEucConfig euc_config = 18;</code>
     */
    public com.google.cloud.aiplatform.v1.NotebookEucConfig.Builder getEucConfigBuilder() {
      bitField0_ |= 0x00000800;
      onChanged();
      return getEucConfigFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * EUC configuration of the NotebookRuntimeTemplate.
     * </pre>
     *
     * <code>.google.cloud.aiplatform.v1.NotebookEucConfig euc_config = 18;</code>
     */
    public com.google.cloud.aiplatform.v1.NotebookEucConfigOrBuilder getEucConfigOrBuilder() {
      if (eucConfigBuilder_ != null) {
        return eucConfigBuilder_.getMessageOrBuilder();
      } else {
        return eucConfig_ == null
            ? com.google.cloud.aiplatform.v1.NotebookEucConfig.getDefaultInstance()
            : eucConfig_;
      }
    }
    /**
     *
     *
     * <pre>
     * EUC configuration of the NotebookRuntimeTemplate.
     * </pre>
     *
     * <code>.google.cloud.aiplatform.v1.NotebookEucConfig euc_config = 18;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.aiplatform.v1.NotebookEucConfig,
            com.google.cloud.aiplatform.v1.NotebookEucConfig.Builder,
            com.google.cloud.aiplatform.v1.NotebookEucConfigOrBuilder>
        getEucConfigFieldBuilder() {
      if (eucConfigBuilder_ == null) {
        eucConfigBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.aiplatform.v1.NotebookEucConfig,
                com.google.cloud.aiplatform.v1.NotebookEucConfig.Builder,
                com.google.cloud.aiplatform.v1.NotebookEucConfigOrBuilder>(
                getEucConfig(), getParentForChildren(), isClean());
        eucConfig_ = null;
      }
      return eucConfigBuilder_;
    }

    private com.google.protobuf.Timestamp createTime_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Timestamp,
            com.google.protobuf.Timestamp.Builder,
            com.google.protobuf.TimestampOrBuilder>
        createTimeBuilder_;
    /**
     *
     *
     * <pre>
     * Output only. Timestamp when this NotebookRuntimeTemplate was created.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp create_time = 10 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return Whether the createTime field is set.
     */
    public boolean hasCreateTime() {
      return ((bitField0_ & 0x00001000) != 0);
    }
    /**
     *
     *
     * <pre>
     * Output only. Timestamp when this NotebookRuntimeTemplate was created.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp create_time = 10 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return The createTime.
     */
    public com.google.protobuf.Timestamp getCreateTime() {
      if (createTimeBuilder_ == null) {
        return createTime_ == null
            ? com.google.protobuf.Timestamp.getDefaultInstance()
            : createTime_;
      } else {
        return createTimeBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. Timestamp when this NotebookRuntimeTemplate was created.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp create_time = 10 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder setCreateTime(com.google.protobuf.Timestamp value) {
      if (createTimeBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        createTime_ = value;
      } else {
        createTimeBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00001000;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Timestamp when this NotebookRuntimeTemplate was created.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp create_time = 10 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder setCreateTime(com.google.protobuf.Timestamp.Builder builderForValue) {
      if (createTimeBuilder_ == null) {
        createTime_ = builderForValue.build();
      } else {
        createTimeBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00001000;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Timestamp when this NotebookRuntimeTemplate was created.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp create_time = 10 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder mergeCreateTime(com.google.protobuf.Timestamp value) {
      if (createTimeBuilder_ == null) {
        if (((bitField0_ & 0x00001000) != 0)
            && createTime_ != null
            && createTime_ != com.google.protobuf.Timestamp.getDefaultInstance()) {
          getCreateTimeBuilder().mergeFrom(value);
        } else {
          createTime_ = value;
        }
      } else {
        createTimeBuilder_.mergeFrom(value);
      }
      if (createTime_ != null) {
        bitField0_ |= 0x00001000;
        onChanged();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Timestamp when this NotebookRuntimeTemplate was created.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp create_time = 10 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder clearCreateTime() {
      bitField0_ = (bitField0_ & ~0x00001000);
      createTime_ = null;
      if (createTimeBuilder_ != null) {
        createTimeBuilder_.dispose();
        createTimeBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Timestamp when this NotebookRuntimeTemplate was created.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp create_time = 10 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.protobuf.Timestamp.Builder getCreateTimeBuilder() {
      bitField0_ |= 0x00001000;
      onChanged();
      return getCreateTimeFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Output only. Timestamp when this NotebookRuntimeTemplate was created.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp create_time = 10 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.protobuf.TimestampOrBuilder getCreateTimeOrBuilder() {
      if (createTimeBuilder_ != null) {
        return createTimeBuilder_.getMessageOrBuilder();
      } else {
        return createTime_ == null
            ? com.google.protobuf.Timestamp.getDefaultInstance()
            : createTime_;
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. Timestamp when this NotebookRuntimeTemplate was created.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp create_time = 10 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Timestamp,
            com.google.protobuf.Timestamp.Builder,
            com.google.protobuf.TimestampOrBuilder>
        getCreateTimeFieldBuilder() {
      if (createTimeBuilder_ == null) {
        createTimeBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.protobuf.Timestamp,
                com.google.protobuf.Timestamp.Builder,
                com.google.protobuf.TimestampOrBuilder>(
                getCreateTime(), getParentForChildren(), isClean());
        createTime_ = null;
      }
      return createTimeBuilder_;
    }

    private com.google.protobuf.Timestamp updateTime_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Timestamp,
            com.google.protobuf.Timestamp.Builder,
            com.google.protobuf.TimestampOrBuilder>
        updateTimeBuilder_;
    /**
     *
     *
     * <pre>
     * Output only. Timestamp when this NotebookRuntimeTemplate was most recently
     * updated.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp update_time = 11 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return Whether the updateTime field is set.
     */
    public boolean hasUpdateTime() {
      return ((bitField0_ & 0x00002000) != 0);
    }
    /**
     *
     *
     * <pre>
     * Output only. Timestamp when this NotebookRuntimeTemplate was most recently
     * updated.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp update_time = 11 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return The updateTime.
     */
    public com.google.protobuf.Timestamp getUpdateTime() {
      if (updateTimeBuilder_ == null) {
        return updateTime_ == null
            ? com.google.protobuf.Timestamp.getDefaultInstance()
            : updateTime_;
      } else {
        return updateTimeBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. Timestamp when this NotebookRuntimeTemplate was most recently
     * updated.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp update_time = 11 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder setUpdateTime(com.google.protobuf.Timestamp value) {
      if (updateTimeBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        updateTime_ = value;
      } else {
        updateTimeBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00002000;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Timestamp when this NotebookRuntimeTemplate was most recently
     * updated.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp update_time = 11 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder setUpdateTime(com.google.protobuf.Timestamp.Builder builderForValue) {
      if (updateTimeBuilder_ == null) {
        updateTime_ = builderForValue.build();
      } else {
        updateTimeBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00002000;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Timestamp when this NotebookRuntimeTemplate was most recently
     * updated.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp update_time = 11 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder mergeUpdateTime(com.google.protobuf.Timestamp value) {
      if (updateTimeBuilder_ == null) {
        if (((bitField0_ & 0x00002000) != 0)
            && updateTime_ != null
            && updateTime_ != com.google.protobuf.Timestamp.getDefaultInstance()) {
          getUpdateTimeBuilder().mergeFrom(value);
        } else {
          updateTime_ = value;
        }
      } else {
        updateTimeBuilder_.mergeFrom(value);
      }
      if (updateTime_ != null) {
        bitField0_ |= 0x00002000;
        onChanged();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Timestamp when this NotebookRuntimeTemplate was most recently
     * updated.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp update_time = 11 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder clearUpdateTime() {
      bitField0_ = (bitField0_ & ~0x00002000);
      updateTime_ = null;
      if (updateTimeBuilder_ != null) {
        updateTimeBuilder_.dispose();
        updateTimeBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Timestamp when this NotebookRuntimeTemplate was most recently
     * updated.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp update_time = 11 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.protobuf.Timestamp.Builder getUpdateTimeBuilder() {
      bitField0_ |= 0x00002000;
      onChanged();
      return getUpdateTimeFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Output only. Timestamp when this NotebookRuntimeTemplate was most recently
     * updated.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp update_time = 11 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.protobuf.TimestampOrBuilder getUpdateTimeOrBuilder() {
      if (updateTimeBuilder_ != null) {
        return updateTimeBuilder_.getMessageOrBuilder();
      } else {
        return updateTime_ == null
            ? com.google.protobuf.Timestamp.getDefaultInstance()
            : updateTime_;
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. Timestamp when this NotebookRuntimeTemplate was most recently
     * updated.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp update_time = 11 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Timestamp,
            com.google.protobuf.Timestamp.Builder,
            com.google.protobuf.TimestampOrBuilder>
        getUpdateTimeFieldBuilder() {
      if (updateTimeBuilder_ == null) {
        updateTimeBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.protobuf.Timestamp,
                com.google.protobuf.Timestamp.Builder,
                com.google.protobuf.TimestampOrBuilder>(
                getUpdateTime(), getParentForChildren(), isClean());
        updateTime_ = null;
      }
      return updateTimeBuilder_;
    }

    private int notebookRuntimeType_ = 0;
    /**
     *
     *
     * <pre>
     * Optional. Immutable. The type of the notebook runtime template.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1.NotebookRuntimeType notebook_runtime_type = 19 [(.google.api.field_behavior) = OPTIONAL, (.google.api.field_behavior) = IMMUTABLE];
     * </code>
     *
     * @return The enum numeric value on the wire for notebookRuntimeType.
     */
    @java.lang.Override
    public int getNotebookRuntimeTypeValue() {
      return notebookRuntimeType_;
    }
    /**
     *
     *
     * <pre>
     * Optional. Immutable. The type of the notebook runtime template.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1.NotebookRuntimeType notebook_runtime_type = 19 [(.google.api.field_behavior) = OPTIONAL, (.google.api.field_behavior) = IMMUTABLE];
     * </code>
     *
     * @param value The enum numeric value on the wire for notebookRuntimeType to set.
     * @return This builder for chaining.
     */
    public Builder setNotebookRuntimeTypeValue(int value) {
      notebookRuntimeType_ = value;
      bitField0_ |= 0x00004000;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. Immutable. The type of the notebook runtime template.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1.NotebookRuntimeType notebook_runtime_type = 19 [(.google.api.field_behavior) = OPTIONAL, (.google.api.field_behavior) = IMMUTABLE];
     * </code>
     *
     * @return The notebookRuntimeType.
     */
    @java.lang.Override
    public com.google.cloud.aiplatform.v1.NotebookRuntimeType getNotebookRuntimeType() {
      com.google.cloud.aiplatform.v1.NotebookRuntimeType result =
          com.google.cloud.aiplatform.v1.NotebookRuntimeType.forNumber(notebookRuntimeType_);
      return result == null
          ? com.google.cloud.aiplatform.v1.NotebookRuntimeType.UNRECOGNIZED
          : result;
    }
    /**
     *
     *
     * <pre>
     * Optional. Immutable. The type of the notebook runtime template.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1.NotebookRuntimeType notebook_runtime_type = 19 [(.google.api.field_behavior) = OPTIONAL, (.google.api.field_behavior) = IMMUTABLE];
     * </code>
     *
     * @param value The notebookRuntimeType to set.
     * @return This builder for chaining.
     */
    public Builder setNotebookRuntimeType(
        com.google.cloud.aiplatform.v1.NotebookRuntimeType value) {
      if (value == null) {
        throw new NullPointerException();
      }
      bitField0_ |= 0x00004000;
      notebookRuntimeType_ = value.getNumber();
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. Immutable. The type of the notebook runtime template.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1.NotebookRuntimeType notebook_runtime_type = 19 [(.google.api.field_behavior) = OPTIONAL, (.google.api.field_behavior) = IMMUTABLE];
     * </code>
     *
     * @return This builder for chaining.
     */
    public Builder clearNotebookRuntimeType() {
      bitField0_ = (bitField0_ & ~0x00004000);
      notebookRuntimeType_ = 0;
      onChanged();
      return this;
    }

    private com.google.cloud.aiplatform.v1.ShieldedVmConfig shieldedVmConfig_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.aiplatform.v1.ShieldedVmConfig,
            com.google.cloud.aiplatform.v1.ShieldedVmConfig.Builder,
            com.google.cloud.aiplatform.v1.ShieldedVmConfigOrBuilder>
        shieldedVmConfigBuilder_;
    /**
     *
     *
     * <pre>
     * Optional. Immutable. Runtime Shielded VM spec.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1.ShieldedVmConfig shielded_vm_config = 20 [(.google.api.field_behavior) = OPTIONAL, (.google.api.field_behavior) = IMMUTABLE];
     * </code>
     *
     * @return Whether the shieldedVmConfig field is set.
     */
    public boolean hasShieldedVmConfig() {
      return ((bitField0_ & 0x00008000) != 0);
    }
    /**
     *
     *
     * <pre>
     * Optional. Immutable. Runtime Shielded VM spec.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1.ShieldedVmConfig shielded_vm_config = 20 [(.google.api.field_behavior) = OPTIONAL, (.google.api.field_behavior) = IMMUTABLE];
     * </code>
     *
     * @return The shieldedVmConfig.
     */
    public com.google.cloud.aiplatform.v1.ShieldedVmConfig getShieldedVmConfig() {
      if (shieldedVmConfigBuilder_ == null) {
        return shieldedVmConfig_ == null
            ? com.google.cloud.aiplatform.v1.ShieldedVmConfig.getDefaultInstance()
            : shieldedVmConfig_;
      } else {
        return shieldedVmConfigBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Optional. Immutable. Runtime Shielded VM spec.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1.ShieldedVmConfig shielded_vm_config = 20 [(.google.api.field_behavior) = OPTIONAL, (.google.api.field_behavior) = IMMUTABLE];
     * </code>
     */
    public Builder setShieldedVmConfig(com.google.cloud.aiplatform.v1.ShieldedVmConfig value) {
      if (shieldedVmConfigBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        shieldedVmConfig_ = value;
      } else {
        shieldedVmConfigBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00008000;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. Immutable. Runtime Shielded VM spec.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1.ShieldedVmConfig shielded_vm_config = 20 [(.google.api.field_behavior) = OPTIONAL, (.google.api.field_behavior) = IMMUTABLE];
     * </code>
     */
    public Builder setShieldedVmConfig(
        com.google.cloud.aiplatform.v1.ShieldedVmConfig.Builder builderForValue) {
      if (shieldedVmConfigBuilder_ == null) {
        shieldedVmConfig_ = builderForValue.build();
      } else {
        shieldedVmConfigBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00008000;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. Immutable. Runtime Shielded VM spec.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1.ShieldedVmConfig shielded_vm_config = 20 [(.google.api.field_behavior) = OPTIONAL, (.google.api.field_behavior) = IMMUTABLE];
     * </code>
     */
    public Builder mergeShieldedVmConfig(com.google.cloud.aiplatform.v1.ShieldedVmConfig value) {
      if (shieldedVmConfigBuilder_ == null) {
        if (((bitField0_ & 0x00008000) != 0)
            && shieldedVmConfig_ != null
            && shieldedVmConfig_
                != com.google.cloud.aiplatform.v1.ShieldedVmConfig.getDefaultInstance()) {
          getShieldedVmConfigBuilder().mergeFrom(value);
        } else {
          shieldedVmConfig_ = value;
        }
      } else {
        shieldedVmConfigBuilder_.mergeFrom(value);
      }
      if (shieldedVmConfig_ != null) {
        bitField0_ |= 0x00008000;
        onChanged();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. Immutable. Runtime Shielded VM spec.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1.ShieldedVmConfig shielded_vm_config = 20 [(.google.api.field_behavior) = OPTIONAL, (.google.api.field_behavior) = IMMUTABLE];
     * </code>
     */
    public Builder clearShieldedVmConfig() {
      bitField0_ = (bitField0_ & ~0x00008000);
      shieldedVmConfig_ = null;
      if (shieldedVmConfigBuilder_ != null) {
        shieldedVmConfigBuilder_.dispose();
        shieldedVmConfigBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. Immutable. Runtime Shielded VM spec.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1.ShieldedVmConfig shielded_vm_config = 20 [(.google.api.field_behavior) = OPTIONAL, (.google.api.field_behavior) = IMMUTABLE];
     * </code>
     */
    public com.google.cloud.aiplatform.v1.ShieldedVmConfig.Builder getShieldedVmConfigBuilder() {
      bitField0_ |= 0x00008000;
      onChanged();
      return getShieldedVmConfigFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Optional. Immutable. Runtime Shielded VM spec.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1.ShieldedVmConfig shielded_vm_config = 20 [(.google.api.field_behavior) = OPTIONAL, (.google.api.field_behavior) = IMMUTABLE];
     * </code>
     */
    public com.google.cloud.aiplatform.v1.ShieldedVmConfigOrBuilder getShieldedVmConfigOrBuilder() {
      if (shieldedVmConfigBuilder_ != null) {
        return shieldedVmConfigBuilder_.getMessageOrBuilder();
      } else {
        return shieldedVmConfig_ == null
            ? com.google.cloud.aiplatform.v1.ShieldedVmConfig.getDefaultInstance()
            : shieldedVmConfig_;
      }
    }
    /**
     *
     *
     * <pre>
     * Optional. Immutable. Runtime Shielded VM spec.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1.ShieldedVmConfig shielded_vm_config = 20 [(.google.api.field_behavior) = OPTIONAL, (.google.api.field_behavior) = IMMUTABLE];
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.aiplatform.v1.ShieldedVmConfig,
            com.google.cloud.aiplatform.v1.ShieldedVmConfig.Builder,
            com.google.cloud.aiplatform.v1.ShieldedVmConfigOrBuilder>
        getShieldedVmConfigFieldBuilder() {
      if (shieldedVmConfigBuilder_ == null) {
        shieldedVmConfigBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.aiplatform.v1.ShieldedVmConfig,
                com.google.cloud.aiplatform.v1.ShieldedVmConfig.Builder,
                com.google.cloud.aiplatform.v1.ShieldedVmConfigOrBuilder>(
                getShieldedVmConfig(), getParentForChildren(), isClean());
        shieldedVmConfig_ = null;
      }
      return shieldedVmConfigBuilder_;
    }

    private com.google.protobuf.LazyStringArrayList networkTags_ =
        com.google.protobuf.LazyStringArrayList.emptyList();

    private void ensureNetworkTagsIsMutable() {
      if (!networkTags_.isModifiable()) {
        networkTags_ = new com.google.protobuf.LazyStringArrayList(networkTags_);
      }
      bitField0_ |= 0x00010000;
    }
    /**
     *
     *
     * <pre>
     * Optional. The Compute Engine tags to add to runtime (see [Tagging
     * instances](https://cloud.google.com/vpc/docs/add-remove-network-tags)).
     * </pre>
     *
     * <code>repeated string network_tags = 21 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return A list containing the networkTags.
     */
    public com.google.protobuf.ProtocolStringList getNetworkTagsList() {
      networkTags_.makeImmutable();
      return networkTags_;
    }
    /**
     *
     *
     * <pre>
     * Optional. The Compute Engine tags to add to runtime (see [Tagging
     * instances](https://cloud.google.com/vpc/docs/add-remove-network-tags)).
     * </pre>
     *
     * <code>repeated string network_tags = 21 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return The count of networkTags.
     */
    public int getNetworkTagsCount() {
      return networkTags_.size();
    }
    /**
     *
     *
     * <pre>
     * Optional. The Compute Engine tags to add to runtime (see [Tagging
     * instances](https://cloud.google.com/vpc/docs/add-remove-network-tags)).
     * </pre>
     *
     * <code>repeated string network_tags = 21 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @param index The index of the element to return.
     * @return The networkTags at the given index.
     */
    public java.lang.String getNetworkTags(int index) {
      return networkTags_.get(index);
    }
    /**
     *
     *
     * <pre>
     * Optional. The Compute Engine tags to add to runtime (see [Tagging
     * instances](https://cloud.google.com/vpc/docs/add-remove-network-tags)).
     * </pre>
     *
     * <code>repeated string network_tags = 21 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @param index The index of the value to return.
     * @return The bytes of the networkTags at the given index.
     */
    public com.google.protobuf.ByteString getNetworkTagsBytes(int index) {
      return networkTags_.getByteString(index);
    }
    /**
     *
     *
     * <pre>
     * Optional. The Compute Engine tags to add to runtime (see [Tagging
     * instances](https://cloud.google.com/vpc/docs/add-remove-network-tags)).
     * </pre>
     *
     * <code>repeated string network_tags = 21 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @param index The index to set the value at.
     * @param value The networkTags to set.
     * @return This builder for chaining.
     */
    public Builder setNetworkTags(int index, java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      ensureNetworkTagsIsMutable();
      networkTags_.set(index, value);
      bitField0_ |= 0x00010000;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. The Compute Engine tags to add to runtime (see [Tagging
     * instances](https://cloud.google.com/vpc/docs/add-remove-network-tags)).
     * </pre>
     *
     * <code>repeated string network_tags = 21 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @param value The networkTags to add.
     * @return This builder for chaining.
     */
    public Builder addNetworkTags(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      ensureNetworkTagsIsMutable();
      networkTags_.add(value);
      bitField0_ |= 0x00010000;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. The Compute Engine tags to add to runtime (see [Tagging
     * instances](https://cloud.google.com/vpc/docs/add-remove-network-tags)).
     * </pre>
     *
     * <code>repeated string network_tags = 21 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @param values The networkTags to add.
     * @return This builder for chaining.
     */
    public Builder addAllNetworkTags(java.lang.Iterable<java.lang.String> values) {
      ensureNetworkTagsIsMutable();
      com.google.protobuf.AbstractMessageLite.Builder.addAll(values, networkTags_);
      bitField0_ |= 0x00010000;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. The Compute Engine tags to add to runtime (see [Tagging
     * instances](https://cloud.google.com/vpc/docs/add-remove-network-tags)).
     * </pre>
     *
     * <code>repeated string network_tags = 21 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearNetworkTags() {
      networkTags_ = com.google.protobuf.LazyStringArrayList.emptyList();
      bitField0_ = (bitField0_ & ~0x00010000);
      ;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. The Compute Engine tags to add to runtime (see [Tagging
     * instances](https://cloud.google.com/vpc/docs/add-remove-network-tags)).
     * </pre>
     *
     * <code>repeated string network_tags = 21 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @param value The bytes of the networkTags to add.
     * @return This builder for chaining.
     */
    public Builder addNetworkTagsBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      ensureNetworkTagsIsMutable();
      networkTags_.add(value);
      bitField0_ |= 0x00010000;
      onChanged();
      return this;
    }

    private com.google.cloud.aiplatform.v1.EncryptionSpec encryptionSpec_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.aiplatform.v1.EncryptionSpec,
            com.google.cloud.aiplatform.v1.EncryptionSpec.Builder,
            com.google.cloud.aiplatform.v1.EncryptionSpecOrBuilder>
        encryptionSpecBuilder_;
    /**
     *
     *
     * <pre>
     * Customer-managed encryption key spec for the notebook runtime.
     * </pre>
     *
     * <code>.google.cloud.aiplatform.v1.EncryptionSpec encryption_spec = 23;</code>
     *
     * @return Whether the encryptionSpec field is set.
     */
    public boolean hasEncryptionSpec() {
      return ((bitField0_ & 0x00020000) != 0);
    }
    /**
     *
     *
     * <pre>
     * Customer-managed encryption key spec for the notebook runtime.
     * </pre>
     *
     * <code>.google.cloud.aiplatform.v1.EncryptionSpec encryption_spec = 23;</code>
     *
     * @return The encryptionSpec.
     */
    public com.google.cloud.aiplatform.v1.EncryptionSpec getEncryptionSpec() {
      if (encryptionSpecBuilder_ == null) {
        return encryptionSpec_ == null
            ? com.google.cloud.aiplatform.v1.EncryptionSpec.getDefaultInstance()
            : encryptionSpec_;
      } else {
        return encryptionSpecBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Customer-managed encryption key spec for the notebook runtime.
     * </pre>
     *
     * <code>.google.cloud.aiplatform.v1.EncryptionSpec encryption_spec = 23;</code>
     */
    public Builder setEncryptionSpec(com.google.cloud.aiplatform.v1.EncryptionSpec value) {
      if (encryptionSpecBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        encryptionSpec_ = value;
      } else {
        encryptionSpecBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00020000;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Customer-managed encryption key spec for the notebook runtime.
     * </pre>
     *
     * <code>.google.cloud.aiplatform.v1.EncryptionSpec encryption_spec = 23;</code>
     */
    public Builder setEncryptionSpec(
        com.google.cloud.aiplatform.v1.EncryptionSpec.Builder builderForValue) {
      if (encryptionSpecBuilder_ == null) {
        encryptionSpec_ = builderForValue.build();
      } else {
        encryptionSpecBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00020000;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Customer-managed encryption key spec for the notebook runtime.
     * </pre>
     *
     * <code>.google.cloud.aiplatform.v1.EncryptionSpec encryption_spec = 23;</code>
     */
    public Builder mergeEncryptionSpec(com.google.cloud.aiplatform.v1.EncryptionSpec value) {
      if (encryptionSpecBuilder_ == null) {
        if (((bitField0_ & 0x00020000) != 0)
            && encryptionSpec_ != null
            && encryptionSpec_
                != com.google.cloud.aiplatform.v1.EncryptionSpec.getDefaultInstance()) {
          getEncryptionSpecBuilder().mergeFrom(value);
        } else {
          encryptionSpec_ = value;
        }
      } else {
        encryptionSpecBuilder_.mergeFrom(value);
      }
      if (encryptionSpec_ != null) {
        bitField0_ |= 0x00020000;
        onChanged();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Customer-managed encryption key spec for the notebook runtime.
     * </pre>
     *
     * <code>.google.cloud.aiplatform.v1.EncryptionSpec encryption_spec = 23;</code>
     */
    public Builder clearEncryptionSpec() {
      bitField0_ = (bitField0_ & ~0x00020000);
      encryptionSpec_ = null;
      if (encryptionSpecBuilder_ != null) {
        encryptionSpecBuilder_.dispose();
        encryptionSpecBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Customer-managed encryption key spec for the notebook runtime.
     * </pre>
     *
     * <code>.google.cloud.aiplatform.v1.EncryptionSpec encryption_spec = 23;</code>
     */
    public com.google.cloud.aiplatform.v1.EncryptionSpec.Builder getEncryptionSpecBuilder() {
      bitField0_ |= 0x00020000;
      onChanged();
      return getEncryptionSpecFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Customer-managed encryption key spec for the notebook runtime.
     * </pre>
     *
     * <code>.google.cloud.aiplatform.v1.EncryptionSpec encryption_spec = 23;</code>
     */
    public com.google.cloud.aiplatform.v1.EncryptionSpecOrBuilder getEncryptionSpecOrBuilder() {
      if (encryptionSpecBuilder_ != null) {
        return encryptionSpecBuilder_.getMessageOrBuilder();
      } else {
        return encryptionSpec_ == null
            ? com.google.cloud.aiplatform.v1.EncryptionSpec.getDefaultInstance()
            : encryptionSpec_;
      }
    }
    /**
     *
     *
     * <pre>
     * Customer-managed encryption key spec for the notebook runtime.
     * </pre>
     *
     * <code>.google.cloud.aiplatform.v1.EncryptionSpec encryption_spec = 23;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.aiplatform.v1.EncryptionSpec,
            com.google.cloud.aiplatform.v1.EncryptionSpec.Builder,
            com.google.cloud.aiplatform.v1.EncryptionSpecOrBuilder>
        getEncryptionSpecFieldBuilder() {
      if (encryptionSpecBuilder_ == null) {
        encryptionSpecBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.aiplatform.v1.EncryptionSpec,
                com.google.cloud.aiplatform.v1.EncryptionSpec.Builder,
                com.google.cloud.aiplatform.v1.EncryptionSpecOrBuilder>(
                getEncryptionSpec(), getParentForChildren(), isClean());
        encryptionSpec_ = null;
      }
      return encryptionSpecBuilder_;
    }

    private com.google.cloud.aiplatform.v1.NotebookSoftwareConfig softwareConfig_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.aiplatform.v1.NotebookSoftwareConfig,
            com.google.cloud.aiplatform.v1.NotebookSoftwareConfig.Builder,
            com.google.cloud.aiplatform.v1.NotebookSoftwareConfigOrBuilder>
        softwareConfigBuilder_;
    /**
     *
     *
     * <pre>
     * Optional. The notebook software configuration of the notebook runtime.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1.NotebookSoftwareConfig software_config = 24 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return Whether the softwareConfig field is set.
     */
    public boolean hasSoftwareConfig() {
      return ((bitField0_ & 0x00040000) != 0);
    }
    /**
     *
     *
     * <pre>
     * Optional. The notebook software configuration of the notebook runtime.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1.NotebookSoftwareConfig software_config = 24 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return The softwareConfig.
     */
    public com.google.cloud.aiplatform.v1.NotebookSoftwareConfig getSoftwareConfig() {
      if (softwareConfigBuilder_ == null) {
        return softwareConfig_ == null
            ? com.google.cloud.aiplatform.v1.NotebookSoftwareConfig.getDefaultInstance()
            : softwareConfig_;
      } else {
        return softwareConfigBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Optional. The notebook software configuration of the notebook runtime.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1.NotebookSoftwareConfig software_config = 24 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder setSoftwareConfig(com.google.cloud.aiplatform.v1.NotebookSoftwareConfig value) {
      if (softwareConfigBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        softwareConfig_ = value;
      } else {
        softwareConfigBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00040000;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. The notebook software configuration of the notebook runtime.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1.NotebookSoftwareConfig software_config = 24 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder setSoftwareConfig(
        com.google.cloud.aiplatform.v1.NotebookSoftwareConfig.Builder builderForValue) {
      if (softwareConfigBuilder_ == null) {
        softwareConfig_ = builderForValue.build();
      } else {
        softwareConfigBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00040000;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. The notebook software configuration of the notebook runtime.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1.NotebookSoftwareConfig software_config = 24 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder mergeSoftwareConfig(
        com.google.cloud.aiplatform.v1.NotebookSoftwareConfig value) {
      if (softwareConfigBuilder_ == null) {
        if (((bitField0_ & 0x00040000) != 0)
            && softwareConfig_ != null
            && softwareConfig_
                != com.google.cloud.aiplatform.v1.NotebookSoftwareConfig.getDefaultInstance()) {
          getSoftwareConfigBuilder().mergeFrom(value);
        } else {
          softwareConfig_ = value;
        }
      } else {
        softwareConfigBuilder_.mergeFrom(value);
      }
      if (softwareConfig_ != null) {
        bitField0_ |= 0x00040000;
        onChanged();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. The notebook software configuration of the notebook runtime.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1.NotebookSoftwareConfig software_config = 24 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder clearSoftwareConfig() {
      bitField0_ = (bitField0_ & ~0x00040000);
      softwareConfig_ = null;
      if (softwareConfigBuilder_ != null) {
        softwareConfigBuilder_.dispose();
        softwareConfigBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. The notebook software configuration of the notebook runtime.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1.NotebookSoftwareConfig software_config = 24 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public com.google.cloud.aiplatform.v1.NotebookSoftwareConfig.Builder
        getSoftwareConfigBuilder() {
      bitField0_ |= 0x00040000;
      onChanged();
      return getSoftwareConfigFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Optional. The notebook software configuration of the notebook runtime.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1.NotebookSoftwareConfig software_config = 24 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public com.google.cloud.aiplatform.v1.NotebookSoftwareConfigOrBuilder
        getSoftwareConfigOrBuilder() {
      if (softwareConfigBuilder_ != null) {
        return softwareConfigBuilder_.getMessageOrBuilder();
      } else {
        return softwareConfig_ == null
            ? com.google.cloud.aiplatform.v1.NotebookSoftwareConfig.getDefaultInstance()
            : softwareConfig_;
      }
    }
    /**
     *
     *
     * <pre>
     * Optional. The notebook software configuration of the notebook runtime.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1.NotebookSoftwareConfig software_config = 24 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.aiplatform.v1.NotebookSoftwareConfig,
            com.google.cloud.aiplatform.v1.NotebookSoftwareConfig.Builder,
            com.google.cloud.aiplatform.v1.NotebookSoftwareConfigOrBuilder>
        getSoftwareConfigFieldBuilder() {
      if (softwareConfigBuilder_ == null) {
        softwareConfigBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.aiplatform.v1.NotebookSoftwareConfig,
                com.google.cloud.aiplatform.v1.NotebookSoftwareConfig.Builder,
                com.google.cloud.aiplatform.v1.NotebookSoftwareConfigOrBuilder>(
                getSoftwareConfig(), getParentForChildren(), isClean());
        softwareConfig_ = null;
      }
      return softwareConfigBuilder_;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.cloud.aiplatform.v1.NotebookRuntimeTemplate)
  }

  // @@protoc_insertion_point(class_scope:google.cloud.aiplatform.v1.NotebookRuntimeTemplate)
  private static final com.google.cloud.aiplatform.v1.NotebookRuntimeTemplate DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.cloud.aiplatform.v1.NotebookRuntimeTemplate();
  }

  public static com.google.cloud.aiplatform.v1.NotebookRuntimeTemplate getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<NotebookRuntimeTemplate> PARSER =
      new com.google.protobuf.AbstractParser<NotebookRuntimeTemplate>() {
        @java.lang.Override
        public NotebookRuntimeTemplate parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          Builder builder = newBuilder();
          try {
            builder.mergeFrom(input, extensionRegistry);
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.setUnfinishedMessage(builder.buildPartial());
          } catch (com.google.protobuf.UninitializedMessageException e) {
            throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
          } catch (java.io.IOException e) {
            throw new com.google.protobuf.InvalidProtocolBufferException(e)
                .setUnfinishedMessage(builder.buildPartial());
          }
          return builder.buildPartial();
        }
      };

  public static com.google.protobuf.Parser<NotebookRuntimeTemplate> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<NotebookRuntimeTemplate> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.cloud.aiplatform.v1.NotebookRuntimeTemplate getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
