/*
 * Copyright 2025 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/cloud/aiplatform/v1/vertex_rag_data.proto

// Protobuf Java Version: 3.25.5
package com.google.cloud.aiplatform.v1;

/**
 *
 *
 * <pre>
 * Specifies the parsing config for RagFiles.
 * </pre>
 *
 * Protobuf type {@code google.cloud.aiplatform.v1.RagFileParsingConfig}
 */
public final class RagFileParsingConfig extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.cloud.aiplatform.v1.RagFileParsingConfig)
    RagFileParsingConfigOrBuilder {
  private static final long serialVersionUID = 0L;
  // Use RagFileParsingConfig.newBuilder() to construct.
  private RagFileParsingConfig(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private RagFileParsingConfig() {}

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new RagFileParsingConfig();
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.cloud.aiplatform.v1.VertexRagDataProto
        .internal_static_google_cloud_aiplatform_v1_RagFileParsingConfig_descriptor;
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.cloud.aiplatform.v1.VertexRagDataProto
        .internal_static_google_cloud_aiplatform_v1_RagFileParsingConfig_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.cloud.aiplatform.v1.RagFileParsingConfig.class,
            com.google.cloud.aiplatform.v1.RagFileParsingConfig.Builder.class);
  }

  public interface LayoutParserOrBuilder
      extends
      // @@protoc_insertion_point(interface_extends:google.cloud.aiplatform.v1.RagFileParsingConfig.LayoutParser)
      com.google.protobuf.MessageOrBuilder {

    /**
     *
     *
     * <pre>
     * The full resource name of a Document AI processor or processor version.
     * The processor must have type `LAYOUT_PARSER_PROCESSOR`. If specified, the
     * `additional_config.parse_as_scanned_pdf` field must be false.
     * Format:
     * * `projects/{project_id}/locations/{location}/processors/{processor_id}`
     * * `projects/{project_id}/locations/{location}/processors/{processor_id}/processorVersions/{processor_version_id}`
     * </pre>
     *
     * <code>string processor_name = 1;</code>
     *
     * @return The processorName.
     */
    java.lang.String getProcessorName();
    /**
     *
     *
     * <pre>
     * The full resource name of a Document AI processor or processor version.
     * The processor must have type `LAYOUT_PARSER_PROCESSOR`. If specified, the
     * `additional_config.parse_as_scanned_pdf` field must be false.
     * Format:
     * * `projects/{project_id}/locations/{location}/processors/{processor_id}`
     * * `projects/{project_id}/locations/{location}/processors/{processor_id}/processorVersions/{processor_version_id}`
     * </pre>
     *
     * <code>string processor_name = 1;</code>
     *
     * @return The bytes for processorName.
     */
    com.google.protobuf.ByteString getProcessorNameBytes();

    /**
     *
     *
     * <pre>
     * The maximum number of requests the job is allowed to make to the Document
     * AI processor per minute. Consult
     * https://cloud.google.com/document-ai/quotas and the Quota page for your
     * project to set an appropriate value here. If unspecified, a default value
     * of 120 QPM would be used.
     * </pre>
     *
     * <code>int32 max_parsing_requests_per_min = 2;</code>
     *
     * @return The maxParsingRequestsPerMin.
     */
    int getMaxParsingRequestsPerMin();
  }
  /**
   *
   *
   * <pre>
   * Document AI Layout Parser config.
   * </pre>
   *
   * Protobuf type {@code google.cloud.aiplatform.v1.RagFileParsingConfig.LayoutParser}
   */
  public static final class LayoutParser extends com.google.protobuf.GeneratedMessageV3
      implements
      // @@protoc_insertion_point(message_implements:google.cloud.aiplatform.v1.RagFileParsingConfig.LayoutParser)
      LayoutParserOrBuilder {
    private static final long serialVersionUID = 0L;
    // Use LayoutParser.newBuilder() to construct.
    private LayoutParser(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
      super(builder);
    }

    private LayoutParser() {
      processorName_ = "";
    }

    @java.lang.Override
    @SuppressWarnings({"unused"})
    protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
      return new LayoutParser();
    }

    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.aiplatform.v1.VertexRagDataProto
          .internal_static_google_cloud_aiplatform_v1_RagFileParsingConfig_LayoutParser_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.aiplatform.v1.VertexRagDataProto
          .internal_static_google_cloud_aiplatform_v1_RagFileParsingConfig_LayoutParser_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.aiplatform.v1.RagFileParsingConfig.LayoutParser.class,
              com.google.cloud.aiplatform.v1.RagFileParsingConfig.LayoutParser.Builder.class);
    }

    public static final int PROCESSOR_NAME_FIELD_NUMBER = 1;

    @SuppressWarnings("serial")
    private volatile java.lang.Object processorName_ = "";
    /**
     *
     *
     * <pre>
     * The full resource name of a Document AI processor or processor version.
     * The processor must have type `LAYOUT_PARSER_PROCESSOR`. If specified, the
     * `additional_config.parse_as_scanned_pdf` field must be false.
     * Format:
     * * `projects/{project_id}/locations/{location}/processors/{processor_id}`
     * * `projects/{project_id}/locations/{location}/processors/{processor_id}/processorVersions/{processor_version_id}`
     * </pre>
     *
     * <code>string processor_name = 1;</code>
     *
     * @return The processorName.
     */
    @java.lang.Override
    public java.lang.String getProcessorName() {
      java.lang.Object ref = processorName_;
      if (ref instanceof java.lang.String) {
        return (java.lang.String) ref;
      } else {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        processorName_ = s;
        return s;
      }
    }
    /**
     *
     *
     * <pre>
     * The full resource name of a Document AI processor or processor version.
     * The processor must have type `LAYOUT_PARSER_PROCESSOR`. If specified, the
     * `additional_config.parse_as_scanned_pdf` field must be false.
     * Format:
     * * `projects/{project_id}/locations/{location}/processors/{processor_id}`
     * * `projects/{project_id}/locations/{location}/processors/{processor_id}/processorVersions/{processor_version_id}`
     * </pre>
     *
     * <code>string processor_name = 1;</code>
     *
     * @return The bytes for processorName.
     */
    @java.lang.Override
    public com.google.protobuf.ByteString getProcessorNameBytes() {
      java.lang.Object ref = processorName_;
      if (ref instanceof java.lang.String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        processorName_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    public static final int MAX_PARSING_REQUESTS_PER_MIN_FIELD_NUMBER = 2;
    private int maxParsingRequestsPerMin_ = 0;
    /**
     *
     *
     * <pre>
     * The maximum number of requests the job is allowed to make to the Document
     * AI processor per minute. Consult
     * https://cloud.google.com/document-ai/quotas and the Quota page for your
     * project to set an appropriate value here. If unspecified, a default value
     * of 120 QPM would be used.
     * </pre>
     *
     * <code>int32 max_parsing_requests_per_min = 2;</code>
     *
     * @return The maxParsingRequestsPerMin.
     */
    @java.lang.Override
    public int getMaxParsingRequestsPerMin() {
      return maxParsingRequestsPerMin_;
    }

    private byte memoizedIsInitialized = -1;

    @java.lang.Override
    public final boolean isInitialized() {
      byte isInitialized = memoizedIsInitialized;
      if (isInitialized == 1) return true;
      if (isInitialized == 0) return false;

      memoizedIsInitialized = 1;
      return true;
    }

    @java.lang.Override
    public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(processorName_)) {
        com.google.protobuf.GeneratedMessageV3.writeString(output, 1, processorName_);
      }
      if (maxParsingRequestsPerMin_ != 0) {
        output.writeInt32(2, maxParsingRequestsPerMin_);
      }
      getUnknownFields().writeTo(output);
    }

    @java.lang.Override
    public int getSerializedSize() {
      int size = memoizedSize;
      if (size != -1) return size;

      size = 0;
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(processorName_)) {
        size += com.google.protobuf.GeneratedMessageV3.computeStringSize(1, processorName_);
      }
      if (maxParsingRequestsPerMin_ != 0) {
        size +=
            com.google.protobuf.CodedOutputStream.computeInt32Size(2, maxParsingRequestsPerMin_);
      }
      size += getUnknownFields().getSerializedSize();
      memoizedSize = size;
      return size;
    }

    @java.lang.Override
    public boolean equals(final java.lang.Object obj) {
      if (obj == this) {
        return true;
      }
      if (!(obj instanceof com.google.cloud.aiplatform.v1.RagFileParsingConfig.LayoutParser)) {
        return super.equals(obj);
      }
      com.google.cloud.aiplatform.v1.RagFileParsingConfig.LayoutParser other =
          (com.google.cloud.aiplatform.v1.RagFileParsingConfig.LayoutParser) obj;

      if (!getProcessorName().equals(other.getProcessorName())) return false;
      if (getMaxParsingRequestsPerMin() != other.getMaxParsingRequestsPerMin()) return false;
      if (!getUnknownFields().equals(other.getUnknownFields())) return false;
      return true;
    }

    @java.lang.Override
    public int hashCode() {
      if (memoizedHashCode != 0) {
        return memoizedHashCode;
      }
      int hash = 41;
      hash = (19 * hash) + getDescriptor().hashCode();
      hash = (37 * hash) + PROCESSOR_NAME_FIELD_NUMBER;
      hash = (53 * hash) + getProcessorName().hashCode();
      hash = (37 * hash) + MAX_PARSING_REQUESTS_PER_MIN_FIELD_NUMBER;
      hash = (53 * hash) + getMaxParsingRequestsPerMin();
      hash = (29 * hash) + getUnknownFields().hashCode();
      memoizedHashCode = hash;
      return hash;
    }

    public static com.google.cloud.aiplatform.v1.RagFileParsingConfig.LayoutParser parseFrom(
        java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.aiplatform.v1.RagFileParsingConfig.LayoutParser parseFrom(
        java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.aiplatform.v1.RagFileParsingConfig.LayoutParser parseFrom(
        com.google.protobuf.ByteString data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.aiplatform.v1.RagFileParsingConfig.LayoutParser parseFrom(
        com.google.protobuf.ByteString data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.aiplatform.v1.RagFileParsingConfig.LayoutParser parseFrom(
        byte[] data) throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.aiplatform.v1.RagFileParsingConfig.LayoutParser parseFrom(
        byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.aiplatform.v1.RagFileParsingConfig.LayoutParser parseFrom(
        java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.cloud.aiplatform.v1.RagFileParsingConfig.LayoutParser parseFrom(
        java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.cloud.aiplatform.v1.RagFileParsingConfig.LayoutParser
        parseDelimitedFrom(java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
    }

    public static com.google.cloud.aiplatform.v1.RagFileParsingConfig.LayoutParser
        parseDelimitedFrom(
            java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.cloud.aiplatform.v1.RagFileParsingConfig.LayoutParser parseFrom(
        com.google.protobuf.CodedInputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.cloud.aiplatform.v1.RagFileParsingConfig.LayoutParser parseFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    @java.lang.Override
    public Builder newBuilderForType() {
      return newBuilder();
    }

    public static Builder newBuilder() {
      return DEFAULT_INSTANCE.toBuilder();
    }

    public static Builder newBuilder(
        com.google.cloud.aiplatform.v1.RagFileParsingConfig.LayoutParser prototype) {
      return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }

    @java.lang.Override
    public Builder toBuilder() {
      return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
    }

    @java.lang.Override
    protected Builder newBuilderForType(
        com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      Builder builder = new Builder(parent);
      return builder;
    }
    /**
     *
     *
     * <pre>
     * Document AI Layout Parser config.
     * </pre>
     *
     * Protobuf type {@code google.cloud.aiplatform.v1.RagFileParsingConfig.LayoutParser}
     */
    public static final class Builder
        extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
        implements
        // @@protoc_insertion_point(builder_implements:google.cloud.aiplatform.v1.RagFileParsingConfig.LayoutParser)
        com.google.cloud.aiplatform.v1.RagFileParsingConfig.LayoutParserOrBuilder {
      public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
        return com.google.cloud.aiplatform.v1.VertexRagDataProto
            .internal_static_google_cloud_aiplatform_v1_RagFileParsingConfig_LayoutParser_descriptor;
      }

      @java.lang.Override
      protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return com.google.cloud.aiplatform.v1.VertexRagDataProto
            .internal_static_google_cloud_aiplatform_v1_RagFileParsingConfig_LayoutParser_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                com.google.cloud.aiplatform.v1.RagFileParsingConfig.LayoutParser.class,
                com.google.cloud.aiplatform.v1.RagFileParsingConfig.LayoutParser.Builder.class);
      }

      // Construct using
      // com.google.cloud.aiplatform.v1.RagFileParsingConfig.LayoutParser.newBuilder()
      private Builder() {}

      private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
        super(parent);
      }

      @java.lang.Override
      public Builder clear() {
        super.clear();
        bitField0_ = 0;
        processorName_ = "";
        maxParsingRequestsPerMin_ = 0;
        return this;
      }

      @java.lang.Override
      public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
        return com.google.cloud.aiplatform.v1.VertexRagDataProto
            .internal_static_google_cloud_aiplatform_v1_RagFileParsingConfig_LayoutParser_descriptor;
      }

      @java.lang.Override
      public com.google.cloud.aiplatform.v1.RagFileParsingConfig.LayoutParser
          getDefaultInstanceForType() {
        return com.google.cloud.aiplatform.v1.RagFileParsingConfig.LayoutParser
            .getDefaultInstance();
      }

      @java.lang.Override
      public com.google.cloud.aiplatform.v1.RagFileParsingConfig.LayoutParser build() {
        com.google.cloud.aiplatform.v1.RagFileParsingConfig.LayoutParser result = buildPartial();
        if (!result.isInitialized()) {
          throw newUninitializedMessageException(result);
        }
        return result;
      }

      @java.lang.Override
      public com.google.cloud.aiplatform.v1.RagFileParsingConfig.LayoutParser buildPartial() {
        com.google.cloud.aiplatform.v1.RagFileParsingConfig.LayoutParser result =
            new com.google.cloud.aiplatform.v1.RagFileParsingConfig.LayoutParser(this);
        if (bitField0_ != 0) {
          buildPartial0(result);
        }
        onBuilt();
        return result;
      }

      private void buildPartial0(
          com.google.cloud.aiplatform.v1.RagFileParsingConfig.LayoutParser result) {
        int from_bitField0_ = bitField0_;
        if (((from_bitField0_ & 0x00000001) != 0)) {
          result.processorName_ = processorName_;
        }
        if (((from_bitField0_ & 0x00000002) != 0)) {
          result.maxParsingRequestsPerMin_ = maxParsingRequestsPerMin_;
        }
      }

      @java.lang.Override
      public Builder clone() {
        return super.clone();
      }

      @java.lang.Override
      public Builder setField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.setField(field, value);
      }

      @java.lang.Override
      public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
        return super.clearField(field);
      }

      @java.lang.Override
      public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
        return super.clearOneof(oneof);
      }

      @java.lang.Override
      public Builder setRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          int index,
          java.lang.Object value) {
        return super.setRepeatedField(field, index, value);
      }

      @java.lang.Override
      public Builder addRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.addRepeatedField(field, value);
      }

      @java.lang.Override
      public Builder mergeFrom(com.google.protobuf.Message other) {
        if (other instanceof com.google.cloud.aiplatform.v1.RagFileParsingConfig.LayoutParser) {
          return mergeFrom(
              (com.google.cloud.aiplatform.v1.RagFileParsingConfig.LayoutParser) other);
        } else {
          super.mergeFrom(other);
          return this;
        }
      }

      public Builder mergeFrom(
          com.google.cloud.aiplatform.v1.RagFileParsingConfig.LayoutParser other) {
        if (other
            == com.google.cloud.aiplatform.v1.RagFileParsingConfig.LayoutParser
                .getDefaultInstance()) return this;
        if (!other.getProcessorName().isEmpty()) {
          processorName_ = other.processorName_;
          bitField0_ |= 0x00000001;
          onChanged();
        }
        if (other.getMaxParsingRequestsPerMin() != 0) {
          setMaxParsingRequestsPerMin(other.getMaxParsingRequestsPerMin());
        }
        this.mergeUnknownFields(other.getUnknownFields());
        onChanged();
        return this;
      }

      @java.lang.Override
      public final boolean isInitialized() {
        return true;
      }

      @java.lang.Override
      public Builder mergeFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        if (extensionRegistry == null) {
          throw new java.lang.NullPointerException();
        }
        try {
          boolean done = false;
          while (!done) {
            int tag = input.readTag();
            switch (tag) {
              case 0:
                done = true;
                break;
              case 10:
                {
                  processorName_ = input.readStringRequireUtf8();
                  bitField0_ |= 0x00000001;
                  break;
                } // case 10
              case 16:
                {
                  maxParsingRequestsPerMin_ = input.readInt32();
                  bitField0_ |= 0x00000002;
                  break;
                } // case 16
              default:
                {
                  if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                    done = true; // was an endgroup tag
                  }
                  break;
                } // default:
            } // switch (tag)
          } // while (!done)
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          throw e.unwrapIOException();
        } finally {
          onChanged();
        } // finally
        return this;
      }

      private int bitField0_;

      private java.lang.Object processorName_ = "";
      /**
       *
       *
       * <pre>
       * The full resource name of a Document AI processor or processor version.
       * The processor must have type `LAYOUT_PARSER_PROCESSOR`. If specified, the
       * `additional_config.parse_as_scanned_pdf` field must be false.
       * Format:
       * * `projects/{project_id}/locations/{location}/processors/{processor_id}`
       * * `projects/{project_id}/locations/{location}/processors/{processor_id}/processorVersions/{processor_version_id}`
       * </pre>
       *
       * <code>string processor_name = 1;</code>
       *
       * @return The processorName.
       */
      public java.lang.String getProcessorName() {
        java.lang.Object ref = processorName_;
        if (!(ref instanceof java.lang.String)) {
          com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
          java.lang.String s = bs.toStringUtf8();
          processorName_ = s;
          return s;
        } else {
          return (java.lang.String) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * The full resource name of a Document AI processor or processor version.
       * The processor must have type `LAYOUT_PARSER_PROCESSOR`. If specified, the
       * `additional_config.parse_as_scanned_pdf` field must be false.
       * Format:
       * * `projects/{project_id}/locations/{location}/processors/{processor_id}`
       * * `projects/{project_id}/locations/{location}/processors/{processor_id}/processorVersions/{processor_version_id}`
       * </pre>
       *
       * <code>string processor_name = 1;</code>
       *
       * @return The bytes for processorName.
       */
      public com.google.protobuf.ByteString getProcessorNameBytes() {
        java.lang.Object ref = processorName_;
        if (ref instanceof String) {
          com.google.protobuf.ByteString b =
              com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
          processorName_ = b;
          return b;
        } else {
          return (com.google.protobuf.ByteString) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * The full resource name of a Document AI processor or processor version.
       * The processor must have type `LAYOUT_PARSER_PROCESSOR`. If specified, the
       * `additional_config.parse_as_scanned_pdf` field must be false.
       * Format:
       * * `projects/{project_id}/locations/{location}/processors/{processor_id}`
       * * `projects/{project_id}/locations/{location}/processors/{processor_id}/processorVersions/{processor_version_id}`
       * </pre>
       *
       * <code>string processor_name = 1;</code>
       *
       * @param value The processorName to set.
       * @return This builder for chaining.
       */
      public Builder setProcessorName(java.lang.String value) {
        if (value == null) {
          throw new NullPointerException();
        }
        processorName_ = value;
        bitField0_ |= 0x00000001;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * The full resource name of a Document AI processor or processor version.
       * The processor must have type `LAYOUT_PARSER_PROCESSOR`. If specified, the
       * `additional_config.parse_as_scanned_pdf` field must be false.
       * Format:
       * * `projects/{project_id}/locations/{location}/processors/{processor_id}`
       * * `projects/{project_id}/locations/{location}/processors/{processor_id}/processorVersions/{processor_version_id}`
       * </pre>
       *
       * <code>string processor_name = 1;</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearProcessorName() {
        processorName_ = getDefaultInstance().getProcessorName();
        bitField0_ = (bitField0_ & ~0x00000001);
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * The full resource name of a Document AI processor or processor version.
       * The processor must have type `LAYOUT_PARSER_PROCESSOR`. If specified, the
       * `additional_config.parse_as_scanned_pdf` field must be false.
       * Format:
       * * `projects/{project_id}/locations/{location}/processors/{processor_id}`
       * * `projects/{project_id}/locations/{location}/processors/{processor_id}/processorVersions/{processor_version_id}`
       * </pre>
       *
       * <code>string processor_name = 1;</code>
       *
       * @param value The bytes for processorName to set.
       * @return This builder for chaining.
       */
      public Builder setProcessorNameBytes(com.google.protobuf.ByteString value) {
        if (value == null) {
          throw new NullPointerException();
        }
        checkByteStringIsUtf8(value);
        processorName_ = value;
        bitField0_ |= 0x00000001;
        onChanged();
        return this;
      }

      private int maxParsingRequestsPerMin_;
      /**
       *
       *
       * <pre>
       * The maximum number of requests the job is allowed to make to the Document
       * AI processor per minute. Consult
       * https://cloud.google.com/document-ai/quotas and the Quota page for your
       * project to set an appropriate value here. If unspecified, a default value
       * of 120 QPM would be used.
       * </pre>
       *
       * <code>int32 max_parsing_requests_per_min = 2;</code>
       *
       * @return The maxParsingRequestsPerMin.
       */
      @java.lang.Override
      public int getMaxParsingRequestsPerMin() {
        return maxParsingRequestsPerMin_;
      }
      /**
       *
       *
       * <pre>
       * The maximum number of requests the job is allowed to make to the Document
       * AI processor per minute. Consult
       * https://cloud.google.com/document-ai/quotas and the Quota page for your
       * project to set an appropriate value here. If unspecified, a default value
       * of 120 QPM would be used.
       * </pre>
       *
       * <code>int32 max_parsing_requests_per_min = 2;</code>
       *
       * @param value The maxParsingRequestsPerMin to set.
       * @return This builder for chaining.
       */
      public Builder setMaxParsingRequestsPerMin(int value) {

        maxParsingRequestsPerMin_ = value;
        bitField0_ |= 0x00000002;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * The maximum number of requests the job is allowed to make to the Document
       * AI processor per minute. Consult
       * https://cloud.google.com/document-ai/quotas and the Quota page for your
       * project to set an appropriate value here. If unspecified, a default value
       * of 120 QPM would be used.
       * </pre>
       *
       * <code>int32 max_parsing_requests_per_min = 2;</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearMaxParsingRequestsPerMin() {
        bitField0_ = (bitField0_ & ~0x00000002);
        maxParsingRequestsPerMin_ = 0;
        onChanged();
        return this;
      }

      @java.lang.Override
      public final Builder setUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.setUnknownFields(unknownFields);
      }

      @java.lang.Override
      public final Builder mergeUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.mergeUnknownFields(unknownFields);
      }

      // @@protoc_insertion_point(builder_scope:google.cloud.aiplatform.v1.RagFileParsingConfig.LayoutParser)
    }

    // @@protoc_insertion_point(class_scope:google.cloud.aiplatform.v1.RagFileParsingConfig.LayoutParser)
    private static final com.google.cloud.aiplatform.v1.RagFileParsingConfig.LayoutParser
        DEFAULT_INSTANCE;

    static {
      DEFAULT_INSTANCE = new com.google.cloud.aiplatform.v1.RagFileParsingConfig.LayoutParser();
    }

    public static com.google.cloud.aiplatform.v1.RagFileParsingConfig.LayoutParser
        getDefaultInstance() {
      return DEFAULT_INSTANCE;
    }

    private static final com.google.protobuf.Parser<LayoutParser> PARSER =
        new com.google.protobuf.AbstractParser<LayoutParser>() {
          @java.lang.Override
          public LayoutParser parsePartialFrom(
              com.google.protobuf.CodedInputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
            Builder builder = newBuilder();
            try {
              builder.mergeFrom(input, extensionRegistry);
            } catch (com.google.protobuf.InvalidProtocolBufferException e) {
              throw e.setUnfinishedMessage(builder.buildPartial());
            } catch (com.google.protobuf.UninitializedMessageException e) {
              throw e.asInvalidProtocolBufferException()
                  .setUnfinishedMessage(builder.buildPartial());
            } catch (java.io.IOException e) {
              throw new com.google.protobuf.InvalidProtocolBufferException(e)
                  .setUnfinishedMessage(builder.buildPartial());
            }
            return builder.buildPartial();
          }
        };

    public static com.google.protobuf.Parser<LayoutParser> parser() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.protobuf.Parser<LayoutParser> getParserForType() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.cloud.aiplatform.v1.RagFileParsingConfig.LayoutParser
        getDefaultInstanceForType() {
      return DEFAULT_INSTANCE;
    }
  }

  private int parserCase_ = 0;

  @SuppressWarnings("serial")
  private java.lang.Object parser_;

  public enum ParserCase
      implements
          com.google.protobuf.Internal.EnumLite,
          com.google.protobuf.AbstractMessage.InternalOneOfEnum {
    LAYOUT_PARSER(4),
    PARSER_NOT_SET(0);
    private final int value;

    private ParserCase(int value) {
      this.value = value;
    }
    /**
     * @param value The number of the enum to look for.
     * @return The enum associated with the given number.
     * @deprecated Use {@link #forNumber(int)} instead.
     */
    @java.lang.Deprecated
    public static ParserCase valueOf(int value) {
      return forNumber(value);
    }

    public static ParserCase forNumber(int value) {
      switch (value) {
        case 4:
          return LAYOUT_PARSER;
        case 0:
          return PARSER_NOT_SET;
        default:
          return null;
      }
    }

    public int getNumber() {
      return this.value;
    }
  };

  public ParserCase getParserCase() {
    return ParserCase.forNumber(parserCase_);
  }

  public static final int LAYOUT_PARSER_FIELD_NUMBER = 4;
  /**
   *
   *
   * <pre>
   * The Layout Parser to use for RagFiles.
   * </pre>
   *
   * <code>.google.cloud.aiplatform.v1.RagFileParsingConfig.LayoutParser layout_parser = 4;</code>
   *
   * @return Whether the layoutParser field is set.
   */
  @java.lang.Override
  public boolean hasLayoutParser() {
    return parserCase_ == 4;
  }
  /**
   *
   *
   * <pre>
   * The Layout Parser to use for RagFiles.
   * </pre>
   *
   * <code>.google.cloud.aiplatform.v1.RagFileParsingConfig.LayoutParser layout_parser = 4;</code>
   *
   * @return The layoutParser.
   */
  @java.lang.Override
  public com.google.cloud.aiplatform.v1.RagFileParsingConfig.LayoutParser getLayoutParser() {
    if (parserCase_ == 4) {
      return (com.google.cloud.aiplatform.v1.RagFileParsingConfig.LayoutParser) parser_;
    }
    return com.google.cloud.aiplatform.v1.RagFileParsingConfig.LayoutParser.getDefaultInstance();
  }
  /**
   *
   *
   * <pre>
   * The Layout Parser to use for RagFiles.
   * </pre>
   *
   * <code>.google.cloud.aiplatform.v1.RagFileParsingConfig.LayoutParser layout_parser = 4;</code>
   */
  @java.lang.Override
  public com.google.cloud.aiplatform.v1.RagFileParsingConfig.LayoutParserOrBuilder
      getLayoutParserOrBuilder() {
    if (parserCase_ == 4) {
      return (com.google.cloud.aiplatform.v1.RagFileParsingConfig.LayoutParser) parser_;
    }
    return com.google.cloud.aiplatform.v1.RagFileParsingConfig.LayoutParser.getDefaultInstance();
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    if (parserCase_ == 4) {
      output.writeMessage(
          4, (com.google.cloud.aiplatform.v1.RagFileParsingConfig.LayoutParser) parser_);
    }
    getUnknownFields().writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    if (parserCase_ == 4) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(
              4, (com.google.cloud.aiplatform.v1.RagFileParsingConfig.LayoutParser) parser_);
    }
    size += getUnknownFields().getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.cloud.aiplatform.v1.RagFileParsingConfig)) {
      return super.equals(obj);
    }
    com.google.cloud.aiplatform.v1.RagFileParsingConfig other =
        (com.google.cloud.aiplatform.v1.RagFileParsingConfig) obj;

    if (!getParserCase().equals(other.getParserCase())) return false;
    switch (parserCase_) {
      case 4:
        if (!getLayoutParser().equals(other.getLayoutParser())) return false;
        break;
      case 0:
      default:
    }
    if (!getUnknownFields().equals(other.getUnknownFields())) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    switch (parserCase_) {
      case 4:
        hash = (37 * hash) + LAYOUT_PARSER_FIELD_NUMBER;
        hash = (53 * hash) + getLayoutParser().hashCode();
        break;
      case 0:
      default:
    }
    hash = (29 * hash) + getUnknownFields().hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.cloud.aiplatform.v1.RagFileParsingConfig parseFrom(
      java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.aiplatform.v1.RagFileParsingConfig parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.aiplatform.v1.RagFileParsingConfig parseFrom(
      com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.aiplatform.v1.RagFileParsingConfig parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.aiplatform.v1.RagFileParsingConfig parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.aiplatform.v1.RagFileParsingConfig parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.aiplatform.v1.RagFileParsingConfig parseFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.aiplatform.v1.RagFileParsingConfig parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.aiplatform.v1.RagFileParsingConfig parseDelimitedFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.cloud.aiplatform.v1.RagFileParsingConfig parseDelimitedFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.aiplatform.v1.RagFileParsingConfig parseFrom(
      com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.aiplatform.v1.RagFileParsingConfig parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(com.google.cloud.aiplatform.v1.RagFileParsingConfig prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }
  /**
   *
   *
   * <pre>
   * Specifies the parsing config for RagFiles.
   * </pre>
   *
   * Protobuf type {@code google.cloud.aiplatform.v1.RagFileParsingConfig}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.cloud.aiplatform.v1.RagFileParsingConfig)
      com.google.cloud.aiplatform.v1.RagFileParsingConfigOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.aiplatform.v1.VertexRagDataProto
          .internal_static_google_cloud_aiplatform_v1_RagFileParsingConfig_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.aiplatform.v1.VertexRagDataProto
          .internal_static_google_cloud_aiplatform_v1_RagFileParsingConfig_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.aiplatform.v1.RagFileParsingConfig.class,
              com.google.cloud.aiplatform.v1.RagFileParsingConfig.Builder.class);
    }

    // Construct using com.google.cloud.aiplatform.v1.RagFileParsingConfig.newBuilder()
    private Builder() {}

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      bitField0_ = 0;
      if (layoutParserBuilder_ != null) {
        layoutParserBuilder_.clear();
      }
      parserCase_ = 0;
      parser_ = null;
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.cloud.aiplatform.v1.VertexRagDataProto
          .internal_static_google_cloud_aiplatform_v1_RagFileParsingConfig_descriptor;
    }

    @java.lang.Override
    public com.google.cloud.aiplatform.v1.RagFileParsingConfig getDefaultInstanceForType() {
      return com.google.cloud.aiplatform.v1.RagFileParsingConfig.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.cloud.aiplatform.v1.RagFileParsingConfig build() {
      com.google.cloud.aiplatform.v1.RagFileParsingConfig result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.cloud.aiplatform.v1.RagFileParsingConfig buildPartial() {
      com.google.cloud.aiplatform.v1.RagFileParsingConfig result =
          new com.google.cloud.aiplatform.v1.RagFileParsingConfig(this);
      if (bitField0_ != 0) {
        buildPartial0(result);
      }
      buildPartialOneofs(result);
      onBuilt();
      return result;
    }

    private void buildPartial0(com.google.cloud.aiplatform.v1.RagFileParsingConfig result) {
      int from_bitField0_ = bitField0_;
    }

    private void buildPartialOneofs(com.google.cloud.aiplatform.v1.RagFileParsingConfig result) {
      result.parserCase_ = parserCase_;
      result.parser_ = this.parser_;
      if (parserCase_ == 4 && layoutParserBuilder_ != null) {
        result.parser_ = layoutParserBuilder_.build();
      }
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.cloud.aiplatform.v1.RagFileParsingConfig) {
        return mergeFrom((com.google.cloud.aiplatform.v1.RagFileParsingConfig) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(com.google.cloud.aiplatform.v1.RagFileParsingConfig other) {
      if (other == com.google.cloud.aiplatform.v1.RagFileParsingConfig.getDefaultInstance())
        return this;
      switch (other.getParserCase()) {
        case LAYOUT_PARSER:
          {
            mergeLayoutParser(other.getLayoutParser());
            break;
          }
        case PARSER_NOT_SET:
          {
            break;
          }
      }
      this.mergeUnknownFields(other.getUnknownFields());
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 34:
              {
                input.readMessage(getLayoutParserFieldBuilder().getBuilder(), extensionRegistry);
                parserCase_ = 4;
                break;
              } // case 34
            default:
              {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
          } // switch (tag)
        } // while (!done)
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.unwrapIOException();
      } finally {
        onChanged();
      } // finally
      return this;
    }

    private int parserCase_ = 0;
    private java.lang.Object parser_;

    public ParserCase getParserCase() {
      return ParserCase.forNumber(parserCase_);
    }

    public Builder clearParser() {
      parserCase_ = 0;
      parser_ = null;
      onChanged();
      return this;
    }

    private int bitField0_;

    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.aiplatform.v1.RagFileParsingConfig.LayoutParser,
            com.google.cloud.aiplatform.v1.RagFileParsingConfig.LayoutParser.Builder,
            com.google.cloud.aiplatform.v1.RagFileParsingConfig.LayoutParserOrBuilder>
        layoutParserBuilder_;
    /**
     *
     *
     * <pre>
     * The Layout Parser to use for RagFiles.
     * </pre>
     *
     * <code>.google.cloud.aiplatform.v1.RagFileParsingConfig.LayoutParser layout_parser = 4;</code>
     *
     * @return Whether the layoutParser field is set.
     */
    @java.lang.Override
    public boolean hasLayoutParser() {
      return parserCase_ == 4;
    }
    /**
     *
     *
     * <pre>
     * The Layout Parser to use for RagFiles.
     * </pre>
     *
     * <code>.google.cloud.aiplatform.v1.RagFileParsingConfig.LayoutParser layout_parser = 4;</code>
     *
     * @return The layoutParser.
     */
    @java.lang.Override
    public com.google.cloud.aiplatform.v1.RagFileParsingConfig.LayoutParser getLayoutParser() {
      if (layoutParserBuilder_ == null) {
        if (parserCase_ == 4) {
          return (com.google.cloud.aiplatform.v1.RagFileParsingConfig.LayoutParser) parser_;
        }
        return com.google.cloud.aiplatform.v1.RagFileParsingConfig.LayoutParser
            .getDefaultInstance();
      } else {
        if (parserCase_ == 4) {
          return layoutParserBuilder_.getMessage();
        }
        return com.google.cloud.aiplatform.v1.RagFileParsingConfig.LayoutParser
            .getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * The Layout Parser to use for RagFiles.
     * </pre>
     *
     * <code>.google.cloud.aiplatform.v1.RagFileParsingConfig.LayoutParser layout_parser = 4;</code>
     */
    public Builder setLayoutParser(
        com.google.cloud.aiplatform.v1.RagFileParsingConfig.LayoutParser value) {
      if (layoutParserBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        parser_ = value;
        onChanged();
      } else {
        layoutParserBuilder_.setMessage(value);
      }
      parserCase_ = 4;
      return this;
    }
    /**
     *
     *
     * <pre>
     * The Layout Parser to use for RagFiles.
     * </pre>
     *
     * <code>.google.cloud.aiplatform.v1.RagFileParsingConfig.LayoutParser layout_parser = 4;</code>
     */
    public Builder setLayoutParser(
        com.google.cloud.aiplatform.v1.RagFileParsingConfig.LayoutParser.Builder builderForValue) {
      if (layoutParserBuilder_ == null) {
        parser_ = builderForValue.build();
        onChanged();
      } else {
        layoutParserBuilder_.setMessage(builderForValue.build());
      }
      parserCase_ = 4;
      return this;
    }
    /**
     *
     *
     * <pre>
     * The Layout Parser to use for RagFiles.
     * </pre>
     *
     * <code>.google.cloud.aiplatform.v1.RagFileParsingConfig.LayoutParser layout_parser = 4;</code>
     */
    public Builder mergeLayoutParser(
        com.google.cloud.aiplatform.v1.RagFileParsingConfig.LayoutParser value) {
      if (layoutParserBuilder_ == null) {
        if (parserCase_ == 4
            && parser_
                != com.google.cloud.aiplatform.v1.RagFileParsingConfig.LayoutParser
                    .getDefaultInstance()) {
          parser_ =
              com.google.cloud.aiplatform.v1.RagFileParsingConfig.LayoutParser.newBuilder(
                      (com.google.cloud.aiplatform.v1.RagFileParsingConfig.LayoutParser) parser_)
                  .mergeFrom(value)
                  .buildPartial();
        } else {
          parser_ = value;
        }
        onChanged();
      } else {
        if (parserCase_ == 4) {
          layoutParserBuilder_.mergeFrom(value);
        } else {
          layoutParserBuilder_.setMessage(value);
        }
      }
      parserCase_ = 4;
      return this;
    }
    /**
     *
     *
     * <pre>
     * The Layout Parser to use for RagFiles.
     * </pre>
     *
     * <code>.google.cloud.aiplatform.v1.RagFileParsingConfig.LayoutParser layout_parser = 4;</code>
     */
    public Builder clearLayoutParser() {
      if (layoutParserBuilder_ == null) {
        if (parserCase_ == 4) {
          parserCase_ = 0;
          parser_ = null;
          onChanged();
        }
      } else {
        if (parserCase_ == 4) {
          parserCase_ = 0;
          parser_ = null;
        }
        layoutParserBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * The Layout Parser to use for RagFiles.
     * </pre>
     *
     * <code>.google.cloud.aiplatform.v1.RagFileParsingConfig.LayoutParser layout_parser = 4;</code>
     */
    public com.google.cloud.aiplatform.v1.RagFileParsingConfig.LayoutParser.Builder
        getLayoutParserBuilder() {
      return getLayoutParserFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * The Layout Parser to use for RagFiles.
     * </pre>
     *
     * <code>.google.cloud.aiplatform.v1.RagFileParsingConfig.LayoutParser layout_parser = 4;</code>
     */
    @java.lang.Override
    public com.google.cloud.aiplatform.v1.RagFileParsingConfig.LayoutParserOrBuilder
        getLayoutParserOrBuilder() {
      if ((parserCase_ == 4) && (layoutParserBuilder_ != null)) {
        return layoutParserBuilder_.getMessageOrBuilder();
      } else {
        if (parserCase_ == 4) {
          return (com.google.cloud.aiplatform.v1.RagFileParsingConfig.LayoutParser) parser_;
        }
        return com.google.cloud.aiplatform.v1.RagFileParsingConfig.LayoutParser
            .getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * The Layout Parser to use for RagFiles.
     * </pre>
     *
     * <code>.google.cloud.aiplatform.v1.RagFileParsingConfig.LayoutParser layout_parser = 4;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.aiplatform.v1.RagFileParsingConfig.LayoutParser,
            com.google.cloud.aiplatform.v1.RagFileParsingConfig.LayoutParser.Builder,
            com.google.cloud.aiplatform.v1.RagFileParsingConfig.LayoutParserOrBuilder>
        getLayoutParserFieldBuilder() {
      if (layoutParserBuilder_ == null) {
        if (!(parserCase_ == 4)) {
          parser_ =
              com.google.cloud.aiplatform.v1.RagFileParsingConfig.LayoutParser.getDefaultInstance();
        }
        layoutParserBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.aiplatform.v1.RagFileParsingConfig.LayoutParser,
                com.google.cloud.aiplatform.v1.RagFileParsingConfig.LayoutParser.Builder,
                com.google.cloud.aiplatform.v1.RagFileParsingConfig.LayoutParserOrBuilder>(
                (com.google.cloud.aiplatform.v1.RagFileParsingConfig.LayoutParser) parser_,
                getParentForChildren(),
                isClean());
        parser_ = null;
      }
      parserCase_ = 4;
      onChanged();
      return layoutParserBuilder_;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.cloud.aiplatform.v1.RagFileParsingConfig)
  }

  // @@protoc_insertion_point(class_scope:google.cloud.aiplatform.v1.RagFileParsingConfig)
  private static final com.google.cloud.aiplatform.v1.RagFileParsingConfig DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.cloud.aiplatform.v1.RagFileParsingConfig();
  }

  public static com.google.cloud.aiplatform.v1.RagFileParsingConfig getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<RagFileParsingConfig> PARSER =
      new com.google.protobuf.AbstractParser<RagFileParsingConfig>() {
        @java.lang.Override
        public RagFileParsingConfig parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          Builder builder = newBuilder();
          try {
            builder.mergeFrom(input, extensionRegistry);
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.setUnfinishedMessage(builder.buildPartial());
          } catch (com.google.protobuf.UninitializedMessageException e) {
            throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
          } catch (java.io.IOException e) {
            throw new com.google.protobuf.InvalidProtocolBufferException(e)
                .setUnfinishedMessage(builder.buildPartial());
          }
          return builder.buildPartial();
        }
      };

  public static com.google.protobuf.Parser<RagFileParsingConfig> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<RagFileParsingConfig> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.cloud.aiplatform.v1.RagFileParsingConfig getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
