/*
 * Copyright 2025 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/cloud/aiplatform/v1/vertex_rag_service.proto

// Protobuf Java Version: 3.25.8
package com.google.cloud.aiplatform.v1;

/**
 *
 *
 * <pre>
 * Request message for CorroborateContent.
 * </pre>
 *
 * Protobuf type {@code google.cloud.aiplatform.v1.CorroborateContentRequest}
 */
public final class CorroborateContentRequest extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.cloud.aiplatform.v1.CorroborateContentRequest)
    CorroborateContentRequestOrBuilder {
  private static final long serialVersionUID = 0L;

  // Use CorroborateContentRequest.newBuilder() to construct.
  private CorroborateContentRequest(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private CorroborateContentRequest() {
    parent_ = "";
    facts_ = java.util.Collections.emptyList();
  }

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new CorroborateContentRequest();
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.cloud.aiplatform.v1.VertexRagServiceProto
        .internal_static_google_cloud_aiplatform_v1_CorroborateContentRequest_descriptor;
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.cloud.aiplatform.v1.VertexRagServiceProto
        .internal_static_google_cloud_aiplatform_v1_CorroborateContentRequest_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.cloud.aiplatform.v1.CorroborateContentRequest.class,
            com.google.cloud.aiplatform.v1.CorroborateContentRequest.Builder.class);
  }

  public interface ParametersOrBuilder
      extends
      // @@protoc_insertion_point(interface_extends:google.cloud.aiplatform.v1.CorroborateContentRequest.Parameters)
      com.google.protobuf.MessageOrBuilder {

    /**
     *
     *
     * <pre>
     * Optional. Only return claims with citation score larger than the
     * threshold.
     * </pre>
     *
     * <code>double citation_threshold = 1 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return The citationThreshold.
     */
    double getCitationThreshold();
  }

  /**
   *
   *
   * <pre>
   * Parameters that can be overrided per request.
   * </pre>
   *
   * Protobuf type {@code google.cloud.aiplatform.v1.CorroborateContentRequest.Parameters}
   */
  public static final class Parameters extends com.google.protobuf.GeneratedMessageV3
      implements
      // @@protoc_insertion_point(message_implements:google.cloud.aiplatform.v1.CorroborateContentRequest.Parameters)
      ParametersOrBuilder {
    private static final long serialVersionUID = 0L;

    // Use Parameters.newBuilder() to construct.
    private Parameters(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
      super(builder);
    }

    private Parameters() {}

    @java.lang.Override
    @SuppressWarnings({"unused"})
    protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
      return new Parameters();
    }

    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.aiplatform.v1.VertexRagServiceProto
          .internal_static_google_cloud_aiplatform_v1_CorroborateContentRequest_Parameters_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.aiplatform.v1.VertexRagServiceProto
          .internal_static_google_cloud_aiplatform_v1_CorroborateContentRequest_Parameters_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.aiplatform.v1.CorroborateContentRequest.Parameters.class,
              com.google.cloud.aiplatform.v1.CorroborateContentRequest.Parameters.Builder.class);
    }

    public static final int CITATION_THRESHOLD_FIELD_NUMBER = 1;
    private double citationThreshold_ = 0D;

    /**
     *
     *
     * <pre>
     * Optional. Only return claims with citation score larger than the
     * threshold.
     * </pre>
     *
     * <code>double citation_threshold = 1 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return The citationThreshold.
     */
    @java.lang.Override
    public double getCitationThreshold() {
      return citationThreshold_;
    }

    private byte memoizedIsInitialized = -1;

    @java.lang.Override
    public final boolean isInitialized() {
      byte isInitialized = memoizedIsInitialized;
      if (isInitialized == 1) return true;
      if (isInitialized == 0) return false;

      memoizedIsInitialized = 1;
      return true;
    }

    @java.lang.Override
    public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
      if (java.lang.Double.doubleToRawLongBits(citationThreshold_) != 0) {
        output.writeDouble(1, citationThreshold_);
      }
      getUnknownFields().writeTo(output);
    }

    @java.lang.Override
    public int getSerializedSize() {
      int size = memoizedSize;
      if (size != -1) return size;

      size = 0;
      if (java.lang.Double.doubleToRawLongBits(citationThreshold_) != 0) {
        size += com.google.protobuf.CodedOutputStream.computeDoubleSize(1, citationThreshold_);
      }
      size += getUnknownFields().getSerializedSize();
      memoizedSize = size;
      return size;
    }

    @java.lang.Override
    public boolean equals(final java.lang.Object obj) {
      if (obj == this) {
        return true;
      }
      if (!(obj instanceof com.google.cloud.aiplatform.v1.CorroborateContentRequest.Parameters)) {
        return super.equals(obj);
      }
      com.google.cloud.aiplatform.v1.CorroborateContentRequest.Parameters other =
          (com.google.cloud.aiplatform.v1.CorroborateContentRequest.Parameters) obj;

      if (java.lang.Double.doubleToLongBits(getCitationThreshold())
          != java.lang.Double.doubleToLongBits(other.getCitationThreshold())) return false;
      if (!getUnknownFields().equals(other.getUnknownFields())) return false;
      return true;
    }

    @java.lang.Override
    public int hashCode() {
      if (memoizedHashCode != 0) {
        return memoizedHashCode;
      }
      int hash = 41;
      hash = (19 * hash) + getDescriptor().hashCode();
      hash = (37 * hash) + CITATION_THRESHOLD_FIELD_NUMBER;
      hash =
          (53 * hash)
              + com.google.protobuf.Internal.hashLong(
                  java.lang.Double.doubleToLongBits(getCitationThreshold()));
      hash = (29 * hash) + getUnknownFields().hashCode();
      memoizedHashCode = hash;
      return hash;
    }

    public static com.google.cloud.aiplatform.v1.CorroborateContentRequest.Parameters parseFrom(
        java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.aiplatform.v1.CorroborateContentRequest.Parameters parseFrom(
        java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.aiplatform.v1.CorroborateContentRequest.Parameters parseFrom(
        com.google.protobuf.ByteString data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.aiplatform.v1.CorroborateContentRequest.Parameters parseFrom(
        com.google.protobuf.ByteString data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.aiplatform.v1.CorroborateContentRequest.Parameters parseFrom(
        byte[] data) throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.aiplatform.v1.CorroborateContentRequest.Parameters parseFrom(
        byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.aiplatform.v1.CorroborateContentRequest.Parameters parseFrom(
        java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.cloud.aiplatform.v1.CorroborateContentRequest.Parameters parseFrom(
        java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.cloud.aiplatform.v1.CorroborateContentRequest.Parameters
        parseDelimitedFrom(java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
    }

    public static com.google.cloud.aiplatform.v1.CorroborateContentRequest.Parameters
        parseDelimitedFrom(
            java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.cloud.aiplatform.v1.CorroborateContentRequest.Parameters parseFrom(
        com.google.protobuf.CodedInputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.cloud.aiplatform.v1.CorroborateContentRequest.Parameters parseFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    @java.lang.Override
    public Builder newBuilderForType() {
      return newBuilder();
    }

    public static Builder newBuilder() {
      return DEFAULT_INSTANCE.toBuilder();
    }

    public static Builder newBuilder(
        com.google.cloud.aiplatform.v1.CorroborateContentRequest.Parameters prototype) {
      return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }

    @java.lang.Override
    public Builder toBuilder() {
      return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
    }

    @java.lang.Override
    protected Builder newBuilderForType(
        com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      Builder builder = new Builder(parent);
      return builder;
    }

    /**
     *
     *
     * <pre>
     * Parameters that can be overrided per request.
     * </pre>
     *
     * Protobuf type {@code google.cloud.aiplatform.v1.CorroborateContentRequest.Parameters}
     */
    public static final class Builder
        extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
        implements
        // @@protoc_insertion_point(builder_implements:google.cloud.aiplatform.v1.CorroborateContentRequest.Parameters)
        com.google.cloud.aiplatform.v1.CorroborateContentRequest.ParametersOrBuilder {
      public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
        return com.google.cloud.aiplatform.v1.VertexRagServiceProto
            .internal_static_google_cloud_aiplatform_v1_CorroborateContentRequest_Parameters_descriptor;
      }

      @java.lang.Override
      protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return com.google.cloud.aiplatform.v1.VertexRagServiceProto
            .internal_static_google_cloud_aiplatform_v1_CorroborateContentRequest_Parameters_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                com.google.cloud.aiplatform.v1.CorroborateContentRequest.Parameters.class,
                com.google.cloud.aiplatform.v1.CorroborateContentRequest.Parameters.Builder.class);
      }

      // Construct using
      // com.google.cloud.aiplatform.v1.CorroborateContentRequest.Parameters.newBuilder()
      private Builder() {}

      private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
        super(parent);
      }

      @java.lang.Override
      public Builder clear() {
        super.clear();
        bitField0_ = 0;
        citationThreshold_ = 0D;
        return this;
      }

      @java.lang.Override
      public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
        return com.google.cloud.aiplatform.v1.VertexRagServiceProto
            .internal_static_google_cloud_aiplatform_v1_CorroborateContentRequest_Parameters_descriptor;
      }

      @java.lang.Override
      public com.google.cloud.aiplatform.v1.CorroborateContentRequest.Parameters
          getDefaultInstanceForType() {
        return com.google.cloud.aiplatform.v1.CorroborateContentRequest.Parameters
            .getDefaultInstance();
      }

      @java.lang.Override
      public com.google.cloud.aiplatform.v1.CorroborateContentRequest.Parameters build() {
        com.google.cloud.aiplatform.v1.CorroborateContentRequest.Parameters result = buildPartial();
        if (!result.isInitialized()) {
          throw newUninitializedMessageException(result);
        }
        return result;
      }

      @java.lang.Override
      public com.google.cloud.aiplatform.v1.CorroborateContentRequest.Parameters buildPartial() {
        com.google.cloud.aiplatform.v1.CorroborateContentRequest.Parameters result =
            new com.google.cloud.aiplatform.v1.CorroborateContentRequest.Parameters(this);
        if (bitField0_ != 0) {
          buildPartial0(result);
        }
        onBuilt();
        return result;
      }

      private void buildPartial0(
          com.google.cloud.aiplatform.v1.CorroborateContentRequest.Parameters result) {
        int from_bitField0_ = bitField0_;
        if (((from_bitField0_ & 0x00000001) != 0)) {
          result.citationThreshold_ = citationThreshold_;
        }
      }

      @java.lang.Override
      public Builder clone() {
        return super.clone();
      }

      @java.lang.Override
      public Builder setField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.setField(field, value);
      }

      @java.lang.Override
      public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
        return super.clearField(field);
      }

      @java.lang.Override
      public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
        return super.clearOneof(oneof);
      }

      @java.lang.Override
      public Builder setRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          int index,
          java.lang.Object value) {
        return super.setRepeatedField(field, index, value);
      }

      @java.lang.Override
      public Builder addRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.addRepeatedField(field, value);
      }

      @java.lang.Override
      public Builder mergeFrom(com.google.protobuf.Message other) {
        if (other instanceof com.google.cloud.aiplatform.v1.CorroborateContentRequest.Parameters) {
          return mergeFrom(
              (com.google.cloud.aiplatform.v1.CorroborateContentRequest.Parameters) other);
        } else {
          super.mergeFrom(other);
          return this;
        }
      }

      public Builder mergeFrom(
          com.google.cloud.aiplatform.v1.CorroborateContentRequest.Parameters other) {
        if (other
            == com.google.cloud.aiplatform.v1.CorroborateContentRequest.Parameters
                .getDefaultInstance()) return this;
        if (other.getCitationThreshold() != 0D) {
          setCitationThreshold(other.getCitationThreshold());
        }
        this.mergeUnknownFields(other.getUnknownFields());
        onChanged();
        return this;
      }

      @java.lang.Override
      public final boolean isInitialized() {
        return true;
      }

      @java.lang.Override
      public Builder mergeFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        if (extensionRegistry == null) {
          throw new java.lang.NullPointerException();
        }
        try {
          boolean done = false;
          while (!done) {
            int tag = input.readTag();
            switch (tag) {
              case 0:
                done = true;
                break;
              case 9:
                {
                  citationThreshold_ = input.readDouble();
                  bitField0_ |= 0x00000001;
                  break;
                } // case 9
              default:
                {
                  if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                    done = true; // was an endgroup tag
                  }
                  break;
                } // default:
            } // switch (tag)
          } // while (!done)
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          throw e.unwrapIOException();
        } finally {
          onChanged();
        } // finally
        return this;
      }

      private int bitField0_;

      private double citationThreshold_;

      /**
       *
       *
       * <pre>
       * Optional. Only return claims with citation score larger than the
       * threshold.
       * </pre>
       *
       * <code>double citation_threshold = 1 [(.google.api.field_behavior) = OPTIONAL];</code>
       *
       * @return The citationThreshold.
       */
      @java.lang.Override
      public double getCitationThreshold() {
        return citationThreshold_;
      }

      /**
       *
       *
       * <pre>
       * Optional. Only return claims with citation score larger than the
       * threshold.
       * </pre>
       *
       * <code>double citation_threshold = 1 [(.google.api.field_behavior) = OPTIONAL];</code>
       *
       * @param value The citationThreshold to set.
       * @return This builder for chaining.
       */
      public Builder setCitationThreshold(double value) {

        citationThreshold_ = value;
        bitField0_ |= 0x00000001;
        onChanged();
        return this;
      }

      /**
       *
       *
       * <pre>
       * Optional. Only return claims with citation score larger than the
       * threshold.
       * </pre>
       *
       * <code>double citation_threshold = 1 [(.google.api.field_behavior) = OPTIONAL];</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearCitationThreshold() {
        bitField0_ = (bitField0_ & ~0x00000001);
        citationThreshold_ = 0D;
        onChanged();
        return this;
      }

      @java.lang.Override
      public final Builder setUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.setUnknownFields(unknownFields);
      }

      @java.lang.Override
      public final Builder mergeUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.mergeUnknownFields(unknownFields);
      }

      // @@protoc_insertion_point(builder_scope:google.cloud.aiplatform.v1.CorroborateContentRequest.Parameters)
    }

    // @@protoc_insertion_point(class_scope:google.cloud.aiplatform.v1.CorroborateContentRequest.Parameters)
    private static final com.google.cloud.aiplatform.v1.CorroborateContentRequest.Parameters
        DEFAULT_INSTANCE;

    static {
      DEFAULT_INSTANCE = new com.google.cloud.aiplatform.v1.CorroborateContentRequest.Parameters();
    }

    public static com.google.cloud.aiplatform.v1.CorroborateContentRequest.Parameters
        getDefaultInstance() {
      return DEFAULT_INSTANCE;
    }

    private static final com.google.protobuf.Parser<Parameters> PARSER =
        new com.google.protobuf.AbstractParser<Parameters>() {
          @java.lang.Override
          public Parameters parsePartialFrom(
              com.google.protobuf.CodedInputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
            Builder builder = newBuilder();
            try {
              builder.mergeFrom(input, extensionRegistry);
            } catch (com.google.protobuf.InvalidProtocolBufferException e) {
              throw e.setUnfinishedMessage(builder.buildPartial());
            } catch (com.google.protobuf.UninitializedMessageException e) {
              throw e.asInvalidProtocolBufferException()
                  .setUnfinishedMessage(builder.buildPartial());
            } catch (java.io.IOException e) {
              throw new com.google.protobuf.InvalidProtocolBufferException(e)
                  .setUnfinishedMessage(builder.buildPartial());
            }
            return builder.buildPartial();
          }
        };

    public static com.google.protobuf.Parser<Parameters> parser() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.protobuf.Parser<Parameters> getParserForType() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.cloud.aiplatform.v1.CorroborateContentRequest.Parameters
        getDefaultInstanceForType() {
      return DEFAULT_INSTANCE;
    }
  }

  private int bitField0_;
  public static final int PARENT_FIELD_NUMBER = 1;

  @SuppressWarnings("serial")
  private volatile java.lang.Object parent_ = "";

  /**
   *
   *
   * <pre>
   * Required. The resource name of the Location from which to corroborate text.
   * The users must have permission to make a call in the project.
   * Format:
   * `projects/{project}/locations/{location}`.
   * </pre>
   *
   * <code>
   * string parent = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
   * </code>
   *
   * @return The parent.
   */
  @java.lang.Override
  public java.lang.String getParent() {
    java.lang.Object ref = parent_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      parent_ = s;
      return s;
    }
  }

  /**
   *
   *
   * <pre>
   * Required. The resource name of the Location from which to corroborate text.
   * The users must have permission to make a call in the project.
   * Format:
   * `projects/{project}/locations/{location}`.
   * </pre>
   *
   * <code>
   * string parent = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
   * </code>
   *
   * @return The bytes for parent.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getParentBytes() {
    java.lang.Object ref = parent_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      parent_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int CONTENT_FIELD_NUMBER = 2;
  private com.google.cloud.aiplatform.v1.Content content_;

  /**
   *
   *
   * <pre>
   * Optional. Input content to corroborate, only text format is supported for
   * now.
   * </pre>
   *
   * <code>
   * optional .google.cloud.aiplatform.v1.Content content = 2 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   *
   * @return Whether the content field is set.
   */
  @java.lang.Override
  public boolean hasContent() {
    return ((bitField0_ & 0x00000001) != 0);
  }

  /**
   *
   *
   * <pre>
   * Optional. Input content to corroborate, only text format is supported for
   * now.
   * </pre>
   *
   * <code>
   * optional .google.cloud.aiplatform.v1.Content content = 2 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   *
   * @return The content.
   */
  @java.lang.Override
  public com.google.cloud.aiplatform.v1.Content getContent() {
    return content_ == null
        ? com.google.cloud.aiplatform.v1.Content.getDefaultInstance()
        : content_;
  }

  /**
   *
   *
   * <pre>
   * Optional. Input content to corroborate, only text format is supported for
   * now.
   * </pre>
   *
   * <code>
   * optional .google.cloud.aiplatform.v1.Content content = 2 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.aiplatform.v1.ContentOrBuilder getContentOrBuilder() {
    return content_ == null
        ? com.google.cloud.aiplatform.v1.Content.getDefaultInstance()
        : content_;
  }

  public static final int FACTS_FIELD_NUMBER = 3;

  @SuppressWarnings("serial")
  private java.util.List<com.google.cloud.aiplatform.v1.Fact> facts_;

  /**
   *
   *
   * <pre>
   * Optional. Facts used to generate the text can also be used to corroborate
   * the text.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.aiplatform.v1.Fact facts = 3 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   */
  @java.lang.Override
  public java.util.List<com.google.cloud.aiplatform.v1.Fact> getFactsList() {
    return facts_;
  }

  /**
   *
   *
   * <pre>
   * Optional. Facts used to generate the text can also be used to corroborate
   * the text.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.aiplatform.v1.Fact facts = 3 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   */
  @java.lang.Override
  public java.util.List<? extends com.google.cloud.aiplatform.v1.FactOrBuilder>
      getFactsOrBuilderList() {
    return facts_;
  }

  /**
   *
   *
   * <pre>
   * Optional. Facts used to generate the text can also be used to corroborate
   * the text.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.aiplatform.v1.Fact facts = 3 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   */
  @java.lang.Override
  public int getFactsCount() {
    return facts_.size();
  }

  /**
   *
   *
   * <pre>
   * Optional. Facts used to generate the text can also be used to corroborate
   * the text.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.aiplatform.v1.Fact facts = 3 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.aiplatform.v1.Fact getFacts(int index) {
    return facts_.get(index);
  }

  /**
   *
   *
   * <pre>
   * Optional. Facts used to generate the text can also be used to corroborate
   * the text.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.aiplatform.v1.Fact facts = 3 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.aiplatform.v1.FactOrBuilder getFactsOrBuilder(int index) {
    return facts_.get(index);
  }

  public static final int PARAMETERS_FIELD_NUMBER = 4;
  private com.google.cloud.aiplatform.v1.CorroborateContentRequest.Parameters parameters_;

  /**
   *
   *
   * <pre>
   * Optional. Parameters that can be set to override default settings per
   * request.
   * </pre>
   *
   * <code>
   * .google.cloud.aiplatform.v1.CorroborateContentRequest.Parameters parameters = 4 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   *
   * @return Whether the parameters field is set.
   */
  @java.lang.Override
  public boolean hasParameters() {
    return ((bitField0_ & 0x00000002) != 0);
  }

  /**
   *
   *
   * <pre>
   * Optional. Parameters that can be set to override default settings per
   * request.
   * </pre>
   *
   * <code>
   * .google.cloud.aiplatform.v1.CorroborateContentRequest.Parameters parameters = 4 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   *
   * @return The parameters.
   */
  @java.lang.Override
  public com.google.cloud.aiplatform.v1.CorroborateContentRequest.Parameters getParameters() {
    return parameters_ == null
        ? com.google.cloud.aiplatform.v1.CorroborateContentRequest.Parameters.getDefaultInstance()
        : parameters_;
  }

  /**
   *
   *
   * <pre>
   * Optional. Parameters that can be set to override default settings per
   * request.
   * </pre>
   *
   * <code>
   * .google.cloud.aiplatform.v1.CorroborateContentRequest.Parameters parameters = 4 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.aiplatform.v1.CorroborateContentRequest.ParametersOrBuilder
      getParametersOrBuilder() {
    return parameters_ == null
        ? com.google.cloud.aiplatform.v1.CorroborateContentRequest.Parameters.getDefaultInstance()
        : parameters_;
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(parent_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 1, parent_);
    }
    if (((bitField0_ & 0x00000001) != 0)) {
      output.writeMessage(2, getContent());
    }
    for (int i = 0; i < facts_.size(); i++) {
      output.writeMessage(3, facts_.get(i));
    }
    if (((bitField0_ & 0x00000002) != 0)) {
      output.writeMessage(4, getParameters());
    }
    getUnknownFields().writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(parent_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(1, parent_);
    }
    if (((bitField0_ & 0x00000001) != 0)) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(2, getContent());
    }
    for (int i = 0; i < facts_.size(); i++) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(3, facts_.get(i));
    }
    if (((bitField0_ & 0x00000002) != 0)) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(4, getParameters());
    }
    size += getUnknownFields().getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.cloud.aiplatform.v1.CorroborateContentRequest)) {
      return super.equals(obj);
    }
    com.google.cloud.aiplatform.v1.CorroborateContentRequest other =
        (com.google.cloud.aiplatform.v1.CorroborateContentRequest) obj;

    if (!getParent().equals(other.getParent())) return false;
    if (hasContent() != other.hasContent()) return false;
    if (hasContent()) {
      if (!getContent().equals(other.getContent())) return false;
    }
    if (!getFactsList().equals(other.getFactsList())) return false;
    if (hasParameters() != other.hasParameters()) return false;
    if (hasParameters()) {
      if (!getParameters().equals(other.getParameters())) return false;
    }
    if (!getUnknownFields().equals(other.getUnknownFields())) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    hash = (37 * hash) + PARENT_FIELD_NUMBER;
    hash = (53 * hash) + getParent().hashCode();
    if (hasContent()) {
      hash = (37 * hash) + CONTENT_FIELD_NUMBER;
      hash = (53 * hash) + getContent().hashCode();
    }
    if (getFactsCount() > 0) {
      hash = (37 * hash) + FACTS_FIELD_NUMBER;
      hash = (53 * hash) + getFactsList().hashCode();
    }
    if (hasParameters()) {
      hash = (37 * hash) + PARAMETERS_FIELD_NUMBER;
      hash = (53 * hash) + getParameters().hashCode();
    }
    hash = (29 * hash) + getUnknownFields().hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.cloud.aiplatform.v1.CorroborateContentRequest parseFrom(
      java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.aiplatform.v1.CorroborateContentRequest parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.aiplatform.v1.CorroborateContentRequest parseFrom(
      com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.aiplatform.v1.CorroborateContentRequest parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.aiplatform.v1.CorroborateContentRequest parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.aiplatform.v1.CorroborateContentRequest parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.aiplatform.v1.CorroborateContentRequest parseFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.aiplatform.v1.CorroborateContentRequest parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.aiplatform.v1.CorroborateContentRequest parseDelimitedFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.cloud.aiplatform.v1.CorroborateContentRequest parseDelimitedFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.aiplatform.v1.CorroborateContentRequest parseFrom(
      com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.aiplatform.v1.CorroborateContentRequest parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(
      com.google.cloud.aiplatform.v1.CorroborateContentRequest prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }

  /**
   *
   *
   * <pre>
   * Request message for CorroborateContent.
   * </pre>
   *
   * Protobuf type {@code google.cloud.aiplatform.v1.CorroborateContentRequest}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.cloud.aiplatform.v1.CorroborateContentRequest)
      com.google.cloud.aiplatform.v1.CorroborateContentRequestOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.aiplatform.v1.VertexRagServiceProto
          .internal_static_google_cloud_aiplatform_v1_CorroborateContentRequest_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.aiplatform.v1.VertexRagServiceProto
          .internal_static_google_cloud_aiplatform_v1_CorroborateContentRequest_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.aiplatform.v1.CorroborateContentRequest.class,
              com.google.cloud.aiplatform.v1.CorroborateContentRequest.Builder.class);
    }

    // Construct using com.google.cloud.aiplatform.v1.CorroborateContentRequest.newBuilder()
    private Builder() {
      maybeForceBuilderInitialization();
    }

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
      maybeForceBuilderInitialization();
    }

    private void maybeForceBuilderInitialization() {
      if (com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders) {
        getContentFieldBuilder();
        getFactsFieldBuilder();
        getParametersFieldBuilder();
      }
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      bitField0_ = 0;
      parent_ = "";
      content_ = null;
      if (contentBuilder_ != null) {
        contentBuilder_.dispose();
        contentBuilder_ = null;
      }
      if (factsBuilder_ == null) {
        facts_ = java.util.Collections.emptyList();
      } else {
        facts_ = null;
        factsBuilder_.clear();
      }
      bitField0_ = (bitField0_ & ~0x00000004);
      parameters_ = null;
      if (parametersBuilder_ != null) {
        parametersBuilder_.dispose();
        parametersBuilder_ = null;
      }
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.cloud.aiplatform.v1.VertexRagServiceProto
          .internal_static_google_cloud_aiplatform_v1_CorroborateContentRequest_descriptor;
    }

    @java.lang.Override
    public com.google.cloud.aiplatform.v1.CorroborateContentRequest getDefaultInstanceForType() {
      return com.google.cloud.aiplatform.v1.CorroborateContentRequest.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.cloud.aiplatform.v1.CorroborateContentRequest build() {
      com.google.cloud.aiplatform.v1.CorroborateContentRequest result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.cloud.aiplatform.v1.CorroborateContentRequest buildPartial() {
      com.google.cloud.aiplatform.v1.CorroborateContentRequest result =
          new com.google.cloud.aiplatform.v1.CorroborateContentRequest(this);
      buildPartialRepeatedFields(result);
      if (bitField0_ != 0) {
        buildPartial0(result);
      }
      onBuilt();
      return result;
    }

    private void buildPartialRepeatedFields(
        com.google.cloud.aiplatform.v1.CorroborateContentRequest result) {
      if (factsBuilder_ == null) {
        if (((bitField0_ & 0x00000004) != 0)) {
          facts_ = java.util.Collections.unmodifiableList(facts_);
          bitField0_ = (bitField0_ & ~0x00000004);
        }
        result.facts_ = facts_;
      } else {
        result.facts_ = factsBuilder_.build();
      }
    }

    private void buildPartial0(com.google.cloud.aiplatform.v1.CorroborateContentRequest result) {
      int from_bitField0_ = bitField0_;
      if (((from_bitField0_ & 0x00000001) != 0)) {
        result.parent_ = parent_;
      }
      int to_bitField0_ = 0;
      if (((from_bitField0_ & 0x00000002) != 0)) {
        result.content_ = contentBuilder_ == null ? content_ : contentBuilder_.build();
        to_bitField0_ |= 0x00000001;
      }
      if (((from_bitField0_ & 0x00000008) != 0)) {
        result.parameters_ = parametersBuilder_ == null ? parameters_ : parametersBuilder_.build();
        to_bitField0_ |= 0x00000002;
      }
      result.bitField0_ |= to_bitField0_;
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.cloud.aiplatform.v1.CorroborateContentRequest) {
        return mergeFrom((com.google.cloud.aiplatform.v1.CorroborateContentRequest) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(com.google.cloud.aiplatform.v1.CorroborateContentRequest other) {
      if (other == com.google.cloud.aiplatform.v1.CorroborateContentRequest.getDefaultInstance())
        return this;
      if (!other.getParent().isEmpty()) {
        parent_ = other.parent_;
        bitField0_ |= 0x00000001;
        onChanged();
      }
      if (other.hasContent()) {
        mergeContent(other.getContent());
      }
      if (factsBuilder_ == null) {
        if (!other.facts_.isEmpty()) {
          if (facts_.isEmpty()) {
            facts_ = other.facts_;
            bitField0_ = (bitField0_ & ~0x00000004);
          } else {
            ensureFactsIsMutable();
            facts_.addAll(other.facts_);
          }
          onChanged();
        }
      } else {
        if (!other.facts_.isEmpty()) {
          if (factsBuilder_.isEmpty()) {
            factsBuilder_.dispose();
            factsBuilder_ = null;
            facts_ = other.facts_;
            bitField0_ = (bitField0_ & ~0x00000004);
            factsBuilder_ =
                com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders
                    ? getFactsFieldBuilder()
                    : null;
          } else {
            factsBuilder_.addAllMessages(other.facts_);
          }
        }
      }
      if (other.hasParameters()) {
        mergeParameters(other.getParameters());
      }
      this.mergeUnknownFields(other.getUnknownFields());
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 10:
              {
                parent_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000001;
                break;
              } // case 10
            case 18:
              {
                input.readMessage(getContentFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000002;
                break;
              } // case 18
            case 26:
              {
                com.google.cloud.aiplatform.v1.Fact m =
                    input.readMessage(
                        com.google.cloud.aiplatform.v1.Fact.parser(), extensionRegistry);
                if (factsBuilder_ == null) {
                  ensureFactsIsMutable();
                  facts_.add(m);
                } else {
                  factsBuilder_.addMessage(m);
                }
                break;
              } // case 26
            case 34:
              {
                input.readMessage(getParametersFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000008;
                break;
              } // case 34
            default:
              {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
          } // switch (tag)
        } // while (!done)
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.unwrapIOException();
      } finally {
        onChanged();
      } // finally
      return this;
    }

    private int bitField0_;

    private java.lang.Object parent_ = "";

    /**
     *
     *
     * <pre>
     * Required. The resource name of the Location from which to corroborate text.
     * The users must have permission to make a call in the project.
     * Format:
     * `projects/{project}/locations/{location}`.
     * </pre>
     *
     * <code>
     * string parent = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @return The parent.
     */
    public java.lang.String getParent() {
      java.lang.Object ref = parent_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        parent_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }

    /**
     *
     *
     * <pre>
     * Required. The resource name of the Location from which to corroborate text.
     * The users must have permission to make a call in the project.
     * Format:
     * `projects/{project}/locations/{location}`.
     * </pre>
     *
     * <code>
     * string parent = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @return The bytes for parent.
     */
    public com.google.protobuf.ByteString getParentBytes() {
      java.lang.Object ref = parent_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        parent_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    /**
     *
     *
     * <pre>
     * Required. The resource name of the Location from which to corroborate text.
     * The users must have permission to make a call in the project.
     * Format:
     * `projects/{project}/locations/{location}`.
     * </pre>
     *
     * <code>
     * string parent = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @param value The parent to set.
     * @return This builder for chaining.
     */
    public Builder setParent(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      parent_ = value;
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Required. The resource name of the Location from which to corroborate text.
     * The users must have permission to make a call in the project.
     * Format:
     * `projects/{project}/locations/{location}`.
     * </pre>
     *
     * <code>
     * string parent = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @return This builder for chaining.
     */
    public Builder clearParent() {
      parent_ = getDefaultInstance().getParent();
      bitField0_ = (bitField0_ & ~0x00000001);
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Required. The resource name of the Location from which to corroborate text.
     * The users must have permission to make a call in the project.
     * Format:
     * `projects/{project}/locations/{location}`.
     * </pre>
     *
     * <code>
     * string parent = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @param value The bytes for parent to set.
     * @return This builder for chaining.
     */
    public Builder setParentBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      parent_ = value;
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }

    private com.google.cloud.aiplatform.v1.Content content_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.aiplatform.v1.Content,
            com.google.cloud.aiplatform.v1.Content.Builder,
            com.google.cloud.aiplatform.v1.ContentOrBuilder>
        contentBuilder_;

    /**
     *
     *
     * <pre>
     * Optional. Input content to corroborate, only text format is supported for
     * now.
     * </pre>
     *
     * <code>
     * optional .google.cloud.aiplatform.v1.Content content = 2 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return Whether the content field is set.
     */
    public boolean hasContent() {
      return ((bitField0_ & 0x00000002) != 0);
    }

    /**
     *
     *
     * <pre>
     * Optional. Input content to corroborate, only text format is supported for
     * now.
     * </pre>
     *
     * <code>
     * optional .google.cloud.aiplatform.v1.Content content = 2 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return The content.
     */
    public com.google.cloud.aiplatform.v1.Content getContent() {
      if (contentBuilder_ == null) {
        return content_ == null
            ? com.google.cloud.aiplatform.v1.Content.getDefaultInstance()
            : content_;
      } else {
        return contentBuilder_.getMessage();
      }
    }

    /**
     *
     *
     * <pre>
     * Optional. Input content to corroborate, only text format is supported for
     * now.
     * </pre>
     *
     * <code>
     * optional .google.cloud.aiplatform.v1.Content content = 2 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder setContent(com.google.cloud.aiplatform.v1.Content value) {
      if (contentBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        content_ = value;
      } else {
        contentBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Optional. Input content to corroborate, only text format is supported for
     * now.
     * </pre>
     *
     * <code>
     * optional .google.cloud.aiplatform.v1.Content content = 2 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder setContent(com.google.cloud.aiplatform.v1.Content.Builder builderForValue) {
      if (contentBuilder_ == null) {
        content_ = builderForValue.build();
      } else {
        contentBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Optional. Input content to corroborate, only text format is supported for
     * now.
     * </pre>
     *
     * <code>
     * optional .google.cloud.aiplatform.v1.Content content = 2 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder mergeContent(com.google.cloud.aiplatform.v1.Content value) {
      if (contentBuilder_ == null) {
        if (((bitField0_ & 0x00000002) != 0)
            && content_ != null
            && content_ != com.google.cloud.aiplatform.v1.Content.getDefaultInstance()) {
          getContentBuilder().mergeFrom(value);
        } else {
          content_ = value;
        }
      } else {
        contentBuilder_.mergeFrom(value);
      }
      if (content_ != null) {
        bitField0_ |= 0x00000002;
        onChanged();
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * Optional. Input content to corroborate, only text format is supported for
     * now.
     * </pre>
     *
     * <code>
     * optional .google.cloud.aiplatform.v1.Content content = 2 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder clearContent() {
      bitField0_ = (bitField0_ & ~0x00000002);
      content_ = null;
      if (contentBuilder_ != null) {
        contentBuilder_.dispose();
        contentBuilder_ = null;
      }
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Optional. Input content to corroborate, only text format is supported for
     * now.
     * </pre>
     *
     * <code>
     * optional .google.cloud.aiplatform.v1.Content content = 2 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public com.google.cloud.aiplatform.v1.Content.Builder getContentBuilder() {
      bitField0_ |= 0x00000002;
      onChanged();
      return getContentFieldBuilder().getBuilder();
    }

    /**
     *
     *
     * <pre>
     * Optional. Input content to corroborate, only text format is supported for
     * now.
     * </pre>
     *
     * <code>
     * optional .google.cloud.aiplatform.v1.Content content = 2 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public com.google.cloud.aiplatform.v1.ContentOrBuilder getContentOrBuilder() {
      if (contentBuilder_ != null) {
        return contentBuilder_.getMessageOrBuilder();
      } else {
        return content_ == null
            ? com.google.cloud.aiplatform.v1.Content.getDefaultInstance()
            : content_;
      }
    }

    /**
     *
     *
     * <pre>
     * Optional. Input content to corroborate, only text format is supported for
     * now.
     * </pre>
     *
     * <code>
     * optional .google.cloud.aiplatform.v1.Content content = 2 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.aiplatform.v1.Content,
            com.google.cloud.aiplatform.v1.Content.Builder,
            com.google.cloud.aiplatform.v1.ContentOrBuilder>
        getContentFieldBuilder() {
      if (contentBuilder_ == null) {
        contentBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.aiplatform.v1.Content,
                com.google.cloud.aiplatform.v1.Content.Builder,
                com.google.cloud.aiplatform.v1.ContentOrBuilder>(
                getContent(), getParentForChildren(), isClean());
        content_ = null;
      }
      return contentBuilder_;
    }

    private java.util.List<com.google.cloud.aiplatform.v1.Fact> facts_ =
        java.util.Collections.emptyList();

    private void ensureFactsIsMutable() {
      if (!((bitField0_ & 0x00000004) != 0)) {
        facts_ = new java.util.ArrayList<com.google.cloud.aiplatform.v1.Fact>(facts_);
        bitField0_ |= 0x00000004;
      }
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.cloud.aiplatform.v1.Fact,
            com.google.cloud.aiplatform.v1.Fact.Builder,
            com.google.cloud.aiplatform.v1.FactOrBuilder>
        factsBuilder_;

    /**
     *
     *
     * <pre>
     * Optional. Facts used to generate the text can also be used to corroborate
     * the text.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.aiplatform.v1.Fact facts = 3 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public java.util.List<com.google.cloud.aiplatform.v1.Fact> getFactsList() {
      if (factsBuilder_ == null) {
        return java.util.Collections.unmodifiableList(facts_);
      } else {
        return factsBuilder_.getMessageList();
      }
    }

    /**
     *
     *
     * <pre>
     * Optional. Facts used to generate the text can also be used to corroborate
     * the text.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.aiplatform.v1.Fact facts = 3 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public int getFactsCount() {
      if (factsBuilder_ == null) {
        return facts_.size();
      } else {
        return factsBuilder_.getCount();
      }
    }

    /**
     *
     *
     * <pre>
     * Optional. Facts used to generate the text can also be used to corroborate
     * the text.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.aiplatform.v1.Fact facts = 3 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public com.google.cloud.aiplatform.v1.Fact getFacts(int index) {
      if (factsBuilder_ == null) {
        return facts_.get(index);
      } else {
        return factsBuilder_.getMessage(index);
      }
    }

    /**
     *
     *
     * <pre>
     * Optional. Facts used to generate the text can also be used to corroborate
     * the text.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.aiplatform.v1.Fact facts = 3 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder setFacts(int index, com.google.cloud.aiplatform.v1.Fact value) {
      if (factsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureFactsIsMutable();
        facts_.set(index, value);
        onChanged();
      } else {
        factsBuilder_.setMessage(index, value);
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * Optional. Facts used to generate the text can also be used to corroborate
     * the text.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.aiplatform.v1.Fact facts = 3 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder setFacts(
        int index, com.google.cloud.aiplatform.v1.Fact.Builder builderForValue) {
      if (factsBuilder_ == null) {
        ensureFactsIsMutable();
        facts_.set(index, builderForValue.build());
        onChanged();
      } else {
        factsBuilder_.setMessage(index, builderForValue.build());
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * Optional. Facts used to generate the text can also be used to corroborate
     * the text.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.aiplatform.v1.Fact facts = 3 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder addFacts(com.google.cloud.aiplatform.v1.Fact value) {
      if (factsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureFactsIsMutable();
        facts_.add(value);
        onChanged();
      } else {
        factsBuilder_.addMessage(value);
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * Optional. Facts used to generate the text can also be used to corroborate
     * the text.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.aiplatform.v1.Fact facts = 3 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder addFacts(int index, com.google.cloud.aiplatform.v1.Fact value) {
      if (factsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureFactsIsMutable();
        facts_.add(index, value);
        onChanged();
      } else {
        factsBuilder_.addMessage(index, value);
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * Optional. Facts used to generate the text can also be used to corroborate
     * the text.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.aiplatform.v1.Fact facts = 3 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder addFacts(com.google.cloud.aiplatform.v1.Fact.Builder builderForValue) {
      if (factsBuilder_ == null) {
        ensureFactsIsMutable();
        facts_.add(builderForValue.build());
        onChanged();
      } else {
        factsBuilder_.addMessage(builderForValue.build());
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * Optional. Facts used to generate the text can also be used to corroborate
     * the text.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.aiplatform.v1.Fact facts = 3 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder addFacts(
        int index, com.google.cloud.aiplatform.v1.Fact.Builder builderForValue) {
      if (factsBuilder_ == null) {
        ensureFactsIsMutable();
        facts_.add(index, builderForValue.build());
        onChanged();
      } else {
        factsBuilder_.addMessage(index, builderForValue.build());
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * Optional. Facts used to generate the text can also be used to corroborate
     * the text.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.aiplatform.v1.Fact facts = 3 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder addAllFacts(
        java.lang.Iterable<? extends com.google.cloud.aiplatform.v1.Fact> values) {
      if (factsBuilder_ == null) {
        ensureFactsIsMutable();
        com.google.protobuf.AbstractMessageLite.Builder.addAll(values, facts_);
        onChanged();
      } else {
        factsBuilder_.addAllMessages(values);
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * Optional. Facts used to generate the text can also be used to corroborate
     * the text.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.aiplatform.v1.Fact facts = 3 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder clearFacts() {
      if (factsBuilder_ == null) {
        facts_ = java.util.Collections.emptyList();
        bitField0_ = (bitField0_ & ~0x00000004);
        onChanged();
      } else {
        factsBuilder_.clear();
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * Optional. Facts used to generate the text can also be used to corroborate
     * the text.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.aiplatform.v1.Fact facts = 3 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder removeFacts(int index) {
      if (factsBuilder_ == null) {
        ensureFactsIsMutable();
        facts_.remove(index);
        onChanged();
      } else {
        factsBuilder_.remove(index);
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * Optional. Facts used to generate the text can also be used to corroborate
     * the text.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.aiplatform.v1.Fact facts = 3 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public com.google.cloud.aiplatform.v1.Fact.Builder getFactsBuilder(int index) {
      return getFactsFieldBuilder().getBuilder(index);
    }

    /**
     *
     *
     * <pre>
     * Optional. Facts used to generate the text can also be used to corroborate
     * the text.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.aiplatform.v1.Fact facts = 3 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public com.google.cloud.aiplatform.v1.FactOrBuilder getFactsOrBuilder(int index) {
      if (factsBuilder_ == null) {
        return facts_.get(index);
      } else {
        return factsBuilder_.getMessageOrBuilder(index);
      }
    }

    /**
     *
     *
     * <pre>
     * Optional. Facts used to generate the text can also be used to corroborate
     * the text.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.aiplatform.v1.Fact facts = 3 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public java.util.List<? extends com.google.cloud.aiplatform.v1.FactOrBuilder>
        getFactsOrBuilderList() {
      if (factsBuilder_ != null) {
        return factsBuilder_.getMessageOrBuilderList();
      } else {
        return java.util.Collections.unmodifiableList(facts_);
      }
    }

    /**
     *
     *
     * <pre>
     * Optional. Facts used to generate the text can also be used to corroborate
     * the text.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.aiplatform.v1.Fact facts = 3 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public com.google.cloud.aiplatform.v1.Fact.Builder addFactsBuilder() {
      return getFactsFieldBuilder()
          .addBuilder(com.google.cloud.aiplatform.v1.Fact.getDefaultInstance());
    }

    /**
     *
     *
     * <pre>
     * Optional. Facts used to generate the text can also be used to corroborate
     * the text.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.aiplatform.v1.Fact facts = 3 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public com.google.cloud.aiplatform.v1.Fact.Builder addFactsBuilder(int index) {
      return getFactsFieldBuilder()
          .addBuilder(index, com.google.cloud.aiplatform.v1.Fact.getDefaultInstance());
    }

    /**
     *
     *
     * <pre>
     * Optional. Facts used to generate the text can also be used to corroborate
     * the text.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.aiplatform.v1.Fact facts = 3 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public java.util.List<com.google.cloud.aiplatform.v1.Fact.Builder> getFactsBuilderList() {
      return getFactsFieldBuilder().getBuilderList();
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.cloud.aiplatform.v1.Fact,
            com.google.cloud.aiplatform.v1.Fact.Builder,
            com.google.cloud.aiplatform.v1.FactOrBuilder>
        getFactsFieldBuilder() {
      if (factsBuilder_ == null) {
        factsBuilder_ =
            new com.google.protobuf.RepeatedFieldBuilderV3<
                com.google.cloud.aiplatform.v1.Fact,
                com.google.cloud.aiplatform.v1.Fact.Builder,
                com.google.cloud.aiplatform.v1.FactOrBuilder>(
                facts_, ((bitField0_ & 0x00000004) != 0), getParentForChildren(), isClean());
        facts_ = null;
      }
      return factsBuilder_;
    }

    private com.google.cloud.aiplatform.v1.CorroborateContentRequest.Parameters parameters_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.aiplatform.v1.CorroborateContentRequest.Parameters,
            com.google.cloud.aiplatform.v1.CorroborateContentRequest.Parameters.Builder,
            com.google.cloud.aiplatform.v1.CorroborateContentRequest.ParametersOrBuilder>
        parametersBuilder_;

    /**
     *
     *
     * <pre>
     * Optional. Parameters that can be set to override default settings per
     * request.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1.CorroborateContentRequest.Parameters parameters = 4 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return Whether the parameters field is set.
     */
    public boolean hasParameters() {
      return ((bitField0_ & 0x00000008) != 0);
    }

    /**
     *
     *
     * <pre>
     * Optional. Parameters that can be set to override default settings per
     * request.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1.CorroborateContentRequest.Parameters parameters = 4 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return The parameters.
     */
    public com.google.cloud.aiplatform.v1.CorroborateContentRequest.Parameters getParameters() {
      if (parametersBuilder_ == null) {
        return parameters_ == null
            ? com.google.cloud.aiplatform.v1.CorroborateContentRequest.Parameters
                .getDefaultInstance()
            : parameters_;
      } else {
        return parametersBuilder_.getMessage();
      }
    }

    /**
     *
     *
     * <pre>
     * Optional. Parameters that can be set to override default settings per
     * request.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1.CorroborateContentRequest.Parameters parameters = 4 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder setParameters(
        com.google.cloud.aiplatform.v1.CorroborateContentRequest.Parameters value) {
      if (parametersBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        parameters_ = value;
      } else {
        parametersBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000008;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Optional. Parameters that can be set to override default settings per
     * request.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1.CorroborateContentRequest.Parameters parameters = 4 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder setParameters(
        com.google.cloud.aiplatform.v1.CorroborateContentRequest.Parameters.Builder
            builderForValue) {
      if (parametersBuilder_ == null) {
        parameters_ = builderForValue.build();
      } else {
        parametersBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000008;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Optional. Parameters that can be set to override default settings per
     * request.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1.CorroborateContentRequest.Parameters parameters = 4 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder mergeParameters(
        com.google.cloud.aiplatform.v1.CorroborateContentRequest.Parameters value) {
      if (parametersBuilder_ == null) {
        if (((bitField0_ & 0x00000008) != 0)
            && parameters_ != null
            && parameters_
                != com.google.cloud.aiplatform.v1.CorroborateContentRequest.Parameters
                    .getDefaultInstance()) {
          getParametersBuilder().mergeFrom(value);
        } else {
          parameters_ = value;
        }
      } else {
        parametersBuilder_.mergeFrom(value);
      }
      if (parameters_ != null) {
        bitField0_ |= 0x00000008;
        onChanged();
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * Optional. Parameters that can be set to override default settings per
     * request.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1.CorroborateContentRequest.Parameters parameters = 4 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder clearParameters() {
      bitField0_ = (bitField0_ & ~0x00000008);
      parameters_ = null;
      if (parametersBuilder_ != null) {
        parametersBuilder_.dispose();
        parametersBuilder_ = null;
      }
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Optional. Parameters that can be set to override default settings per
     * request.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1.CorroborateContentRequest.Parameters parameters = 4 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public com.google.cloud.aiplatform.v1.CorroborateContentRequest.Parameters.Builder
        getParametersBuilder() {
      bitField0_ |= 0x00000008;
      onChanged();
      return getParametersFieldBuilder().getBuilder();
    }

    /**
     *
     *
     * <pre>
     * Optional. Parameters that can be set to override default settings per
     * request.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1.CorroborateContentRequest.Parameters parameters = 4 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public com.google.cloud.aiplatform.v1.CorroborateContentRequest.ParametersOrBuilder
        getParametersOrBuilder() {
      if (parametersBuilder_ != null) {
        return parametersBuilder_.getMessageOrBuilder();
      } else {
        return parameters_ == null
            ? com.google.cloud.aiplatform.v1.CorroborateContentRequest.Parameters
                .getDefaultInstance()
            : parameters_;
      }
    }

    /**
     *
     *
     * <pre>
     * Optional. Parameters that can be set to override default settings per
     * request.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1.CorroborateContentRequest.Parameters parameters = 4 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.aiplatform.v1.CorroborateContentRequest.Parameters,
            com.google.cloud.aiplatform.v1.CorroborateContentRequest.Parameters.Builder,
            com.google.cloud.aiplatform.v1.CorroborateContentRequest.ParametersOrBuilder>
        getParametersFieldBuilder() {
      if (parametersBuilder_ == null) {
        parametersBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.aiplatform.v1.CorroborateContentRequest.Parameters,
                com.google.cloud.aiplatform.v1.CorroborateContentRequest.Parameters.Builder,
                com.google.cloud.aiplatform.v1.CorroborateContentRequest.ParametersOrBuilder>(
                getParameters(), getParentForChildren(), isClean());
        parameters_ = null;
      }
      return parametersBuilder_;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.cloud.aiplatform.v1.CorroborateContentRequest)
  }

  // @@protoc_insertion_point(class_scope:google.cloud.aiplatform.v1.CorroborateContentRequest)
  private static final com.google.cloud.aiplatform.v1.CorroborateContentRequest DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.cloud.aiplatform.v1.CorroborateContentRequest();
  }

  public static com.google.cloud.aiplatform.v1.CorroborateContentRequest getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<CorroborateContentRequest> PARSER =
      new com.google.protobuf.AbstractParser<CorroborateContentRequest>() {
        @java.lang.Override
        public CorroborateContentRequest parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          Builder builder = newBuilder();
          try {
            builder.mergeFrom(input, extensionRegistry);
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.setUnfinishedMessage(builder.buildPartial());
          } catch (com.google.protobuf.UninitializedMessageException e) {
            throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
          } catch (java.io.IOException e) {
            throw new com.google.protobuf.InvalidProtocolBufferException(e)
                .setUnfinishedMessage(builder.buildPartial());
          }
          return builder.buildPartial();
        }
      };

  public static com.google.protobuf.Parser<CorroborateContentRequest> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<CorroborateContentRequest> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.cloud.aiplatform.v1.CorroborateContentRequest getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
