/*
 * Copyright 2025 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/cloud/aiplatform/v1/vertex_rag_data.proto

// Protobuf Java Version: 3.25.8
package com.google.cloud.aiplatform.v1;

/**
 *
 *
 * <pre>
 * Config for the Vector DB to use for RAG.
 * </pre>
 *
 * Protobuf type {@code google.cloud.aiplatform.v1.RagVectorDbConfig}
 */
public final class RagVectorDbConfig extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.cloud.aiplatform.v1.RagVectorDbConfig)
    RagVectorDbConfigOrBuilder {
  private static final long serialVersionUID = 0L;

  // Use RagVectorDbConfig.newBuilder() to construct.
  private RagVectorDbConfig(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private RagVectorDbConfig() {}

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new RagVectorDbConfig();
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.cloud.aiplatform.v1.VertexRagDataProto
        .internal_static_google_cloud_aiplatform_v1_RagVectorDbConfig_descriptor;
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.cloud.aiplatform.v1.VertexRagDataProto
        .internal_static_google_cloud_aiplatform_v1_RagVectorDbConfig_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.cloud.aiplatform.v1.RagVectorDbConfig.class,
            com.google.cloud.aiplatform.v1.RagVectorDbConfig.Builder.class);
  }

  public interface RagManagedDbOrBuilder
      extends
      // @@protoc_insertion_point(interface_extends:google.cloud.aiplatform.v1.RagVectorDbConfig.RagManagedDb)
      com.google.protobuf.MessageOrBuilder {

    /**
     *
     *
     * <pre>
     * Performs a KNN search on RagCorpus.
     * Default choice if not specified.
     * </pre>
     *
     * <code>.google.cloud.aiplatform.v1.RagVectorDbConfig.RagManagedDb.KNN knn = 1;</code>
     *
     * @return Whether the knn field is set.
     */
    boolean hasKnn();

    /**
     *
     *
     * <pre>
     * Performs a KNN search on RagCorpus.
     * Default choice if not specified.
     * </pre>
     *
     * <code>.google.cloud.aiplatform.v1.RagVectorDbConfig.RagManagedDb.KNN knn = 1;</code>
     *
     * @return The knn.
     */
    com.google.cloud.aiplatform.v1.RagVectorDbConfig.RagManagedDb.KNN getKnn();

    /**
     *
     *
     * <pre>
     * Performs a KNN search on RagCorpus.
     * Default choice if not specified.
     * </pre>
     *
     * <code>.google.cloud.aiplatform.v1.RagVectorDbConfig.RagManagedDb.KNN knn = 1;</code>
     */
    com.google.cloud.aiplatform.v1.RagVectorDbConfig.RagManagedDb.KNNOrBuilder getKnnOrBuilder();

    /**
     *
     *
     * <pre>
     * Performs an ANN search on RagCorpus. Use this if you have a lot of
     * files (&gt; 10K) in your RagCorpus and want to reduce the search latency.
     * </pre>
     *
     * <code>.google.cloud.aiplatform.v1.RagVectorDbConfig.RagManagedDb.ANN ann = 2;</code>
     *
     * @return Whether the ann field is set.
     */
    boolean hasAnn();

    /**
     *
     *
     * <pre>
     * Performs an ANN search on RagCorpus. Use this if you have a lot of
     * files (&gt; 10K) in your RagCorpus and want to reduce the search latency.
     * </pre>
     *
     * <code>.google.cloud.aiplatform.v1.RagVectorDbConfig.RagManagedDb.ANN ann = 2;</code>
     *
     * @return The ann.
     */
    com.google.cloud.aiplatform.v1.RagVectorDbConfig.RagManagedDb.ANN getAnn();

    /**
     *
     *
     * <pre>
     * Performs an ANN search on RagCorpus. Use this if you have a lot of
     * files (&gt; 10K) in your RagCorpus and want to reduce the search latency.
     * </pre>
     *
     * <code>.google.cloud.aiplatform.v1.RagVectorDbConfig.RagManagedDb.ANN ann = 2;</code>
     */
    com.google.cloud.aiplatform.v1.RagVectorDbConfig.RagManagedDb.ANNOrBuilder getAnnOrBuilder();

    com.google.cloud.aiplatform.v1.RagVectorDbConfig.RagManagedDb.RetrievalStrategyCase
        getRetrievalStrategyCase();
  }

  /**
   *
   *
   * <pre>
   * The config for the default RAG-managed Vector DB.
   * </pre>
   *
   * Protobuf type {@code google.cloud.aiplatform.v1.RagVectorDbConfig.RagManagedDb}
   */
  public static final class RagManagedDb extends com.google.protobuf.GeneratedMessageV3
      implements
      // @@protoc_insertion_point(message_implements:google.cloud.aiplatform.v1.RagVectorDbConfig.RagManagedDb)
      RagManagedDbOrBuilder {
    private static final long serialVersionUID = 0L;

    // Use RagManagedDb.newBuilder() to construct.
    private RagManagedDb(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
      super(builder);
    }

    private RagManagedDb() {}

    @java.lang.Override
    @SuppressWarnings({"unused"})
    protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
      return new RagManagedDb();
    }

    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.aiplatform.v1.VertexRagDataProto
          .internal_static_google_cloud_aiplatform_v1_RagVectorDbConfig_RagManagedDb_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.aiplatform.v1.VertexRagDataProto
          .internal_static_google_cloud_aiplatform_v1_RagVectorDbConfig_RagManagedDb_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.aiplatform.v1.RagVectorDbConfig.RagManagedDb.class,
              com.google.cloud.aiplatform.v1.RagVectorDbConfig.RagManagedDb.Builder.class);
    }

    public interface KNNOrBuilder
        extends
        // @@protoc_insertion_point(interface_extends:google.cloud.aiplatform.v1.RagVectorDbConfig.RagManagedDb.KNN)
        com.google.protobuf.MessageOrBuilder {}

    /**
     *
     *
     * <pre>
     * Config for KNN search.
     * </pre>
     *
     * Protobuf type {@code google.cloud.aiplatform.v1.RagVectorDbConfig.RagManagedDb.KNN}
     */
    public static final class KNN extends com.google.protobuf.GeneratedMessageV3
        implements
        // @@protoc_insertion_point(message_implements:google.cloud.aiplatform.v1.RagVectorDbConfig.RagManagedDb.KNN)
        KNNOrBuilder {
      private static final long serialVersionUID = 0L;

      // Use KNN.newBuilder() to construct.
      private KNN(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
        super(builder);
      }

      private KNN() {}

      @java.lang.Override
      @SuppressWarnings({"unused"})
      protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
        return new KNN();
      }

      public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
        return com.google.cloud.aiplatform.v1.VertexRagDataProto
            .internal_static_google_cloud_aiplatform_v1_RagVectorDbConfig_RagManagedDb_KNN_descriptor;
      }

      @java.lang.Override
      protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return com.google.cloud.aiplatform.v1.VertexRagDataProto
            .internal_static_google_cloud_aiplatform_v1_RagVectorDbConfig_RagManagedDb_KNN_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                com.google.cloud.aiplatform.v1.RagVectorDbConfig.RagManagedDb.KNN.class,
                com.google.cloud.aiplatform.v1.RagVectorDbConfig.RagManagedDb.KNN.Builder.class);
      }

      private byte memoizedIsInitialized = -1;

      @java.lang.Override
      public final boolean isInitialized() {
        byte isInitialized = memoizedIsInitialized;
        if (isInitialized == 1) return true;
        if (isInitialized == 0) return false;

        memoizedIsInitialized = 1;
        return true;
      }

      @java.lang.Override
      public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
        getUnknownFields().writeTo(output);
      }

      @java.lang.Override
      public int getSerializedSize() {
        int size = memoizedSize;
        if (size != -1) return size;

        size = 0;
        size += getUnknownFields().getSerializedSize();
        memoizedSize = size;
        return size;
      }

      @java.lang.Override
      public boolean equals(final java.lang.Object obj) {
        if (obj == this) {
          return true;
        }
        if (!(obj instanceof com.google.cloud.aiplatform.v1.RagVectorDbConfig.RagManagedDb.KNN)) {
          return super.equals(obj);
        }
        com.google.cloud.aiplatform.v1.RagVectorDbConfig.RagManagedDb.KNN other =
            (com.google.cloud.aiplatform.v1.RagVectorDbConfig.RagManagedDb.KNN) obj;

        if (!getUnknownFields().equals(other.getUnknownFields())) return false;
        return true;
      }

      @java.lang.Override
      public int hashCode() {
        if (memoizedHashCode != 0) {
          return memoizedHashCode;
        }
        int hash = 41;
        hash = (19 * hash) + getDescriptor().hashCode();
        hash = (29 * hash) + getUnknownFields().hashCode();
        memoizedHashCode = hash;
        return hash;
      }

      public static com.google.cloud.aiplatform.v1.RagVectorDbConfig.RagManagedDb.KNN parseFrom(
          java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data);
      }

      public static com.google.cloud.aiplatform.v1.RagVectorDbConfig.RagManagedDb.KNN parseFrom(
          java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data, extensionRegistry);
      }

      public static com.google.cloud.aiplatform.v1.RagVectorDbConfig.RagManagedDb.KNN parseFrom(
          com.google.protobuf.ByteString data)
          throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data);
      }

      public static com.google.cloud.aiplatform.v1.RagVectorDbConfig.RagManagedDb.KNN parseFrom(
          com.google.protobuf.ByteString data,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data, extensionRegistry);
      }

      public static com.google.cloud.aiplatform.v1.RagVectorDbConfig.RagManagedDb.KNN parseFrom(
          byte[] data) throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data);
      }

      public static com.google.cloud.aiplatform.v1.RagVectorDbConfig.RagManagedDb.KNN parseFrom(
          byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data, extensionRegistry);
      }

      public static com.google.cloud.aiplatform.v1.RagVectorDbConfig.RagManagedDb.KNN parseFrom(
          java.io.InputStream input) throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
      }

      public static com.google.cloud.aiplatform.v1.RagVectorDbConfig.RagManagedDb.KNN parseFrom(
          java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
            PARSER, input, extensionRegistry);
      }

      public static com.google.cloud.aiplatform.v1.RagVectorDbConfig.RagManagedDb.KNN
          parseDelimitedFrom(java.io.InputStream input) throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
      }

      public static com.google.cloud.aiplatform.v1.RagVectorDbConfig.RagManagedDb.KNN
          parseDelimitedFrom(
              java.io.InputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
            PARSER, input, extensionRegistry);
      }

      public static com.google.cloud.aiplatform.v1.RagVectorDbConfig.RagManagedDb.KNN parseFrom(
          com.google.protobuf.CodedInputStream input) throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
      }

      public static com.google.cloud.aiplatform.v1.RagVectorDbConfig.RagManagedDb.KNN parseFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
            PARSER, input, extensionRegistry);
      }

      @java.lang.Override
      public Builder newBuilderForType() {
        return newBuilder();
      }

      public static Builder newBuilder() {
        return DEFAULT_INSTANCE.toBuilder();
      }

      public static Builder newBuilder(
          com.google.cloud.aiplatform.v1.RagVectorDbConfig.RagManagedDb.KNN prototype) {
        return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
      }

      @java.lang.Override
      public Builder toBuilder() {
        return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
      }

      @java.lang.Override
      protected Builder newBuilderForType(
          com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
        Builder builder = new Builder(parent);
        return builder;
      }

      /**
       *
       *
       * <pre>
       * Config for KNN search.
       * </pre>
       *
       * Protobuf type {@code google.cloud.aiplatform.v1.RagVectorDbConfig.RagManagedDb.KNN}
       */
      public static final class Builder
          extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
          implements
          // @@protoc_insertion_point(builder_implements:google.cloud.aiplatform.v1.RagVectorDbConfig.RagManagedDb.KNN)
          com.google.cloud.aiplatform.v1.RagVectorDbConfig.RagManagedDb.KNNOrBuilder {
        public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
          return com.google.cloud.aiplatform.v1.VertexRagDataProto
              .internal_static_google_cloud_aiplatform_v1_RagVectorDbConfig_RagManagedDb_KNN_descriptor;
        }

        @java.lang.Override
        protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
            internalGetFieldAccessorTable() {
          return com.google.cloud.aiplatform.v1.VertexRagDataProto
              .internal_static_google_cloud_aiplatform_v1_RagVectorDbConfig_RagManagedDb_KNN_fieldAccessorTable
              .ensureFieldAccessorsInitialized(
                  com.google.cloud.aiplatform.v1.RagVectorDbConfig.RagManagedDb.KNN.class,
                  com.google.cloud.aiplatform.v1.RagVectorDbConfig.RagManagedDb.KNN.Builder.class);
        }

        // Construct using
        // com.google.cloud.aiplatform.v1.RagVectorDbConfig.RagManagedDb.KNN.newBuilder()
        private Builder() {}

        private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
          super(parent);
        }

        @java.lang.Override
        public Builder clear() {
          super.clear();
          return this;
        }

        @java.lang.Override
        public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
          return com.google.cloud.aiplatform.v1.VertexRagDataProto
              .internal_static_google_cloud_aiplatform_v1_RagVectorDbConfig_RagManagedDb_KNN_descriptor;
        }

        @java.lang.Override
        public com.google.cloud.aiplatform.v1.RagVectorDbConfig.RagManagedDb.KNN
            getDefaultInstanceForType() {
          return com.google.cloud.aiplatform.v1.RagVectorDbConfig.RagManagedDb.KNN
              .getDefaultInstance();
        }

        @java.lang.Override
        public com.google.cloud.aiplatform.v1.RagVectorDbConfig.RagManagedDb.KNN build() {
          com.google.cloud.aiplatform.v1.RagVectorDbConfig.RagManagedDb.KNN result = buildPartial();
          if (!result.isInitialized()) {
            throw newUninitializedMessageException(result);
          }
          return result;
        }

        @java.lang.Override
        public com.google.cloud.aiplatform.v1.RagVectorDbConfig.RagManagedDb.KNN buildPartial() {
          com.google.cloud.aiplatform.v1.RagVectorDbConfig.RagManagedDb.KNN result =
              new com.google.cloud.aiplatform.v1.RagVectorDbConfig.RagManagedDb.KNN(this);
          onBuilt();
          return result;
        }

        @java.lang.Override
        public Builder clone() {
          return super.clone();
        }

        @java.lang.Override
        public Builder setField(
            com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
          return super.setField(field, value);
        }

        @java.lang.Override
        public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
          return super.clearField(field);
        }

        @java.lang.Override
        public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
          return super.clearOneof(oneof);
        }

        @java.lang.Override
        public Builder setRepeatedField(
            com.google.protobuf.Descriptors.FieldDescriptor field,
            int index,
            java.lang.Object value) {
          return super.setRepeatedField(field, index, value);
        }

        @java.lang.Override
        public Builder addRepeatedField(
            com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
          return super.addRepeatedField(field, value);
        }

        @java.lang.Override
        public Builder mergeFrom(com.google.protobuf.Message other) {
          if (other instanceof com.google.cloud.aiplatform.v1.RagVectorDbConfig.RagManagedDb.KNN) {
            return mergeFrom(
                (com.google.cloud.aiplatform.v1.RagVectorDbConfig.RagManagedDb.KNN) other);
          } else {
            super.mergeFrom(other);
            return this;
          }
        }

        public Builder mergeFrom(
            com.google.cloud.aiplatform.v1.RagVectorDbConfig.RagManagedDb.KNN other) {
          if (other
              == com.google.cloud.aiplatform.v1.RagVectorDbConfig.RagManagedDb.KNN
                  .getDefaultInstance()) return this;
          this.mergeUnknownFields(other.getUnknownFields());
          onChanged();
          return this;
        }

        @java.lang.Override
        public final boolean isInitialized() {
          return true;
        }

        @java.lang.Override
        public Builder mergeFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws java.io.IOException {
          if (extensionRegistry == null) {
            throw new java.lang.NullPointerException();
          }
          try {
            boolean done = false;
            while (!done) {
              int tag = input.readTag();
              switch (tag) {
                case 0:
                  done = true;
                  break;
                default:
                  {
                    if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                      done = true; // was an endgroup tag
                    }
                    break;
                  } // default:
              } // switch (tag)
            } // while (!done)
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.unwrapIOException();
          } finally {
            onChanged();
          } // finally
          return this;
        }

        @java.lang.Override
        public final Builder setUnknownFields(
            final com.google.protobuf.UnknownFieldSet unknownFields) {
          return super.setUnknownFields(unknownFields);
        }

        @java.lang.Override
        public final Builder mergeUnknownFields(
            final com.google.protobuf.UnknownFieldSet unknownFields) {
          return super.mergeUnknownFields(unknownFields);
        }

        // @@protoc_insertion_point(builder_scope:google.cloud.aiplatform.v1.RagVectorDbConfig.RagManagedDb.KNN)
      }

      // @@protoc_insertion_point(class_scope:google.cloud.aiplatform.v1.RagVectorDbConfig.RagManagedDb.KNN)
      private static final com.google.cloud.aiplatform.v1.RagVectorDbConfig.RagManagedDb.KNN
          DEFAULT_INSTANCE;

      static {
        DEFAULT_INSTANCE = new com.google.cloud.aiplatform.v1.RagVectorDbConfig.RagManagedDb.KNN();
      }

      public static com.google.cloud.aiplatform.v1.RagVectorDbConfig.RagManagedDb.KNN
          getDefaultInstance() {
        return DEFAULT_INSTANCE;
      }

      private static final com.google.protobuf.Parser<KNN> PARSER =
          new com.google.protobuf.AbstractParser<KNN>() {
            @java.lang.Override
            public KNN parsePartialFrom(
                com.google.protobuf.CodedInputStream input,
                com.google.protobuf.ExtensionRegistryLite extensionRegistry)
                throws com.google.protobuf.InvalidProtocolBufferException {
              Builder builder = newBuilder();
              try {
                builder.mergeFrom(input, extensionRegistry);
              } catch (com.google.protobuf.InvalidProtocolBufferException e) {
                throw e.setUnfinishedMessage(builder.buildPartial());
              } catch (com.google.protobuf.UninitializedMessageException e) {
                throw e.asInvalidProtocolBufferException()
                    .setUnfinishedMessage(builder.buildPartial());
              } catch (java.io.IOException e) {
                throw new com.google.protobuf.InvalidProtocolBufferException(e)
                    .setUnfinishedMessage(builder.buildPartial());
              }
              return builder.buildPartial();
            }
          };

      public static com.google.protobuf.Parser<KNN> parser() {
        return PARSER;
      }

      @java.lang.Override
      public com.google.protobuf.Parser<KNN> getParserForType() {
        return PARSER;
      }

      @java.lang.Override
      public com.google.cloud.aiplatform.v1.RagVectorDbConfig.RagManagedDb.KNN
          getDefaultInstanceForType() {
        return DEFAULT_INSTANCE;
      }
    }

    public interface ANNOrBuilder
        extends
        // @@protoc_insertion_point(interface_extends:google.cloud.aiplatform.v1.RagVectorDbConfig.RagManagedDb.ANN)
        com.google.protobuf.MessageOrBuilder {

      /**
       *
       *
       * <pre>
       * The depth of the tree-based structure. Only depth values of 2 and 3 are
       * supported.
       *
       * Recommended value is 2 if you have if you have O(10K) files in the
       * RagCorpus and set this to 3 if more than that.
       *
       * Default value is 2.
       * </pre>
       *
       * <code>int32 tree_depth = 1;</code>
       *
       * @return The treeDepth.
       */
      int getTreeDepth();

      /**
       *
       *
       * <pre>
       * Number of leaf nodes in the tree-based structure. Each leaf node
       * contains groups of closely related vectors along with their
       * corresponding centroid.
       *
       * Recommended value is 10 * sqrt(num of RagFiles in your RagCorpus).
       *
       * Default value is 500.
       * </pre>
       *
       * <code>int32 leaf_count = 2;</code>
       *
       * @return The leafCount.
       */
      int getLeafCount();
    }

    /**
     *
     *
     * <pre>
     * Config for ANN search.
     *
     * RagManagedDb uses a tree-based structure to partition data and
     * facilitate faster searches. As a tradeoff, it requires longer indexing
     * time and manual triggering of index rebuild via the ImportRagFiles and
     * UpdateRagCorpus API.
     * </pre>
     *
     * Protobuf type {@code google.cloud.aiplatform.v1.RagVectorDbConfig.RagManagedDb.ANN}
     */
    public static final class ANN extends com.google.protobuf.GeneratedMessageV3
        implements
        // @@protoc_insertion_point(message_implements:google.cloud.aiplatform.v1.RagVectorDbConfig.RagManagedDb.ANN)
        ANNOrBuilder {
      private static final long serialVersionUID = 0L;

      // Use ANN.newBuilder() to construct.
      private ANN(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
        super(builder);
      }

      private ANN() {}

      @java.lang.Override
      @SuppressWarnings({"unused"})
      protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
        return new ANN();
      }

      public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
        return com.google.cloud.aiplatform.v1.VertexRagDataProto
            .internal_static_google_cloud_aiplatform_v1_RagVectorDbConfig_RagManagedDb_ANN_descriptor;
      }

      @java.lang.Override
      protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return com.google.cloud.aiplatform.v1.VertexRagDataProto
            .internal_static_google_cloud_aiplatform_v1_RagVectorDbConfig_RagManagedDb_ANN_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                com.google.cloud.aiplatform.v1.RagVectorDbConfig.RagManagedDb.ANN.class,
                com.google.cloud.aiplatform.v1.RagVectorDbConfig.RagManagedDb.ANN.Builder.class);
      }

      public static final int TREE_DEPTH_FIELD_NUMBER = 1;
      private int treeDepth_ = 0;

      /**
       *
       *
       * <pre>
       * The depth of the tree-based structure. Only depth values of 2 and 3 are
       * supported.
       *
       * Recommended value is 2 if you have if you have O(10K) files in the
       * RagCorpus and set this to 3 if more than that.
       *
       * Default value is 2.
       * </pre>
       *
       * <code>int32 tree_depth = 1;</code>
       *
       * @return The treeDepth.
       */
      @java.lang.Override
      public int getTreeDepth() {
        return treeDepth_;
      }

      public static final int LEAF_COUNT_FIELD_NUMBER = 2;
      private int leafCount_ = 0;

      /**
       *
       *
       * <pre>
       * Number of leaf nodes in the tree-based structure. Each leaf node
       * contains groups of closely related vectors along with their
       * corresponding centroid.
       *
       * Recommended value is 10 * sqrt(num of RagFiles in your RagCorpus).
       *
       * Default value is 500.
       * </pre>
       *
       * <code>int32 leaf_count = 2;</code>
       *
       * @return The leafCount.
       */
      @java.lang.Override
      public int getLeafCount() {
        return leafCount_;
      }

      private byte memoizedIsInitialized = -1;

      @java.lang.Override
      public final boolean isInitialized() {
        byte isInitialized = memoizedIsInitialized;
        if (isInitialized == 1) return true;
        if (isInitialized == 0) return false;

        memoizedIsInitialized = 1;
        return true;
      }

      @java.lang.Override
      public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
        if (treeDepth_ != 0) {
          output.writeInt32(1, treeDepth_);
        }
        if (leafCount_ != 0) {
          output.writeInt32(2, leafCount_);
        }
        getUnknownFields().writeTo(output);
      }

      @java.lang.Override
      public int getSerializedSize() {
        int size = memoizedSize;
        if (size != -1) return size;

        size = 0;
        if (treeDepth_ != 0) {
          size += com.google.protobuf.CodedOutputStream.computeInt32Size(1, treeDepth_);
        }
        if (leafCount_ != 0) {
          size += com.google.protobuf.CodedOutputStream.computeInt32Size(2, leafCount_);
        }
        size += getUnknownFields().getSerializedSize();
        memoizedSize = size;
        return size;
      }

      @java.lang.Override
      public boolean equals(final java.lang.Object obj) {
        if (obj == this) {
          return true;
        }
        if (!(obj instanceof com.google.cloud.aiplatform.v1.RagVectorDbConfig.RagManagedDb.ANN)) {
          return super.equals(obj);
        }
        com.google.cloud.aiplatform.v1.RagVectorDbConfig.RagManagedDb.ANN other =
            (com.google.cloud.aiplatform.v1.RagVectorDbConfig.RagManagedDb.ANN) obj;

        if (getTreeDepth() != other.getTreeDepth()) return false;
        if (getLeafCount() != other.getLeafCount()) return false;
        if (!getUnknownFields().equals(other.getUnknownFields())) return false;
        return true;
      }

      @java.lang.Override
      public int hashCode() {
        if (memoizedHashCode != 0) {
          return memoizedHashCode;
        }
        int hash = 41;
        hash = (19 * hash) + getDescriptor().hashCode();
        hash = (37 * hash) + TREE_DEPTH_FIELD_NUMBER;
        hash = (53 * hash) + getTreeDepth();
        hash = (37 * hash) + LEAF_COUNT_FIELD_NUMBER;
        hash = (53 * hash) + getLeafCount();
        hash = (29 * hash) + getUnknownFields().hashCode();
        memoizedHashCode = hash;
        return hash;
      }

      public static com.google.cloud.aiplatform.v1.RagVectorDbConfig.RagManagedDb.ANN parseFrom(
          java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data);
      }

      public static com.google.cloud.aiplatform.v1.RagVectorDbConfig.RagManagedDb.ANN parseFrom(
          java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data, extensionRegistry);
      }

      public static com.google.cloud.aiplatform.v1.RagVectorDbConfig.RagManagedDb.ANN parseFrom(
          com.google.protobuf.ByteString data)
          throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data);
      }

      public static com.google.cloud.aiplatform.v1.RagVectorDbConfig.RagManagedDb.ANN parseFrom(
          com.google.protobuf.ByteString data,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data, extensionRegistry);
      }

      public static com.google.cloud.aiplatform.v1.RagVectorDbConfig.RagManagedDb.ANN parseFrom(
          byte[] data) throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data);
      }

      public static com.google.cloud.aiplatform.v1.RagVectorDbConfig.RagManagedDb.ANN parseFrom(
          byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data, extensionRegistry);
      }

      public static com.google.cloud.aiplatform.v1.RagVectorDbConfig.RagManagedDb.ANN parseFrom(
          java.io.InputStream input) throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
      }

      public static com.google.cloud.aiplatform.v1.RagVectorDbConfig.RagManagedDb.ANN parseFrom(
          java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
            PARSER, input, extensionRegistry);
      }

      public static com.google.cloud.aiplatform.v1.RagVectorDbConfig.RagManagedDb.ANN
          parseDelimitedFrom(java.io.InputStream input) throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
      }

      public static com.google.cloud.aiplatform.v1.RagVectorDbConfig.RagManagedDb.ANN
          parseDelimitedFrom(
              java.io.InputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
            PARSER, input, extensionRegistry);
      }

      public static com.google.cloud.aiplatform.v1.RagVectorDbConfig.RagManagedDb.ANN parseFrom(
          com.google.protobuf.CodedInputStream input) throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
      }

      public static com.google.cloud.aiplatform.v1.RagVectorDbConfig.RagManagedDb.ANN parseFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
            PARSER, input, extensionRegistry);
      }

      @java.lang.Override
      public Builder newBuilderForType() {
        return newBuilder();
      }

      public static Builder newBuilder() {
        return DEFAULT_INSTANCE.toBuilder();
      }

      public static Builder newBuilder(
          com.google.cloud.aiplatform.v1.RagVectorDbConfig.RagManagedDb.ANN prototype) {
        return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
      }

      @java.lang.Override
      public Builder toBuilder() {
        return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
      }

      @java.lang.Override
      protected Builder newBuilderForType(
          com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
        Builder builder = new Builder(parent);
        return builder;
      }

      /**
       *
       *
       * <pre>
       * Config for ANN search.
       *
       * RagManagedDb uses a tree-based structure to partition data and
       * facilitate faster searches. As a tradeoff, it requires longer indexing
       * time and manual triggering of index rebuild via the ImportRagFiles and
       * UpdateRagCorpus API.
       * </pre>
       *
       * Protobuf type {@code google.cloud.aiplatform.v1.RagVectorDbConfig.RagManagedDb.ANN}
       */
      public static final class Builder
          extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
          implements
          // @@protoc_insertion_point(builder_implements:google.cloud.aiplatform.v1.RagVectorDbConfig.RagManagedDb.ANN)
          com.google.cloud.aiplatform.v1.RagVectorDbConfig.RagManagedDb.ANNOrBuilder {
        public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
          return com.google.cloud.aiplatform.v1.VertexRagDataProto
              .internal_static_google_cloud_aiplatform_v1_RagVectorDbConfig_RagManagedDb_ANN_descriptor;
        }

        @java.lang.Override
        protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
            internalGetFieldAccessorTable() {
          return com.google.cloud.aiplatform.v1.VertexRagDataProto
              .internal_static_google_cloud_aiplatform_v1_RagVectorDbConfig_RagManagedDb_ANN_fieldAccessorTable
              .ensureFieldAccessorsInitialized(
                  com.google.cloud.aiplatform.v1.RagVectorDbConfig.RagManagedDb.ANN.class,
                  com.google.cloud.aiplatform.v1.RagVectorDbConfig.RagManagedDb.ANN.Builder.class);
        }

        // Construct using
        // com.google.cloud.aiplatform.v1.RagVectorDbConfig.RagManagedDb.ANN.newBuilder()
        private Builder() {}

        private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
          super(parent);
        }

        @java.lang.Override
        public Builder clear() {
          super.clear();
          bitField0_ = 0;
          treeDepth_ = 0;
          leafCount_ = 0;
          return this;
        }

        @java.lang.Override
        public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
          return com.google.cloud.aiplatform.v1.VertexRagDataProto
              .internal_static_google_cloud_aiplatform_v1_RagVectorDbConfig_RagManagedDb_ANN_descriptor;
        }

        @java.lang.Override
        public com.google.cloud.aiplatform.v1.RagVectorDbConfig.RagManagedDb.ANN
            getDefaultInstanceForType() {
          return com.google.cloud.aiplatform.v1.RagVectorDbConfig.RagManagedDb.ANN
              .getDefaultInstance();
        }

        @java.lang.Override
        public com.google.cloud.aiplatform.v1.RagVectorDbConfig.RagManagedDb.ANN build() {
          com.google.cloud.aiplatform.v1.RagVectorDbConfig.RagManagedDb.ANN result = buildPartial();
          if (!result.isInitialized()) {
            throw newUninitializedMessageException(result);
          }
          return result;
        }

        @java.lang.Override
        public com.google.cloud.aiplatform.v1.RagVectorDbConfig.RagManagedDb.ANN buildPartial() {
          com.google.cloud.aiplatform.v1.RagVectorDbConfig.RagManagedDb.ANN result =
              new com.google.cloud.aiplatform.v1.RagVectorDbConfig.RagManagedDb.ANN(this);
          if (bitField0_ != 0) {
            buildPartial0(result);
          }
          onBuilt();
          return result;
        }

        private void buildPartial0(
            com.google.cloud.aiplatform.v1.RagVectorDbConfig.RagManagedDb.ANN result) {
          int from_bitField0_ = bitField0_;
          if (((from_bitField0_ & 0x00000001) != 0)) {
            result.treeDepth_ = treeDepth_;
          }
          if (((from_bitField0_ & 0x00000002) != 0)) {
            result.leafCount_ = leafCount_;
          }
        }

        @java.lang.Override
        public Builder clone() {
          return super.clone();
        }

        @java.lang.Override
        public Builder setField(
            com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
          return super.setField(field, value);
        }

        @java.lang.Override
        public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
          return super.clearField(field);
        }

        @java.lang.Override
        public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
          return super.clearOneof(oneof);
        }

        @java.lang.Override
        public Builder setRepeatedField(
            com.google.protobuf.Descriptors.FieldDescriptor field,
            int index,
            java.lang.Object value) {
          return super.setRepeatedField(field, index, value);
        }

        @java.lang.Override
        public Builder addRepeatedField(
            com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
          return super.addRepeatedField(field, value);
        }

        @java.lang.Override
        public Builder mergeFrom(com.google.protobuf.Message other) {
          if (other instanceof com.google.cloud.aiplatform.v1.RagVectorDbConfig.RagManagedDb.ANN) {
            return mergeFrom(
                (com.google.cloud.aiplatform.v1.RagVectorDbConfig.RagManagedDb.ANN) other);
          } else {
            super.mergeFrom(other);
            return this;
          }
        }

        public Builder mergeFrom(
            com.google.cloud.aiplatform.v1.RagVectorDbConfig.RagManagedDb.ANN other) {
          if (other
              == com.google.cloud.aiplatform.v1.RagVectorDbConfig.RagManagedDb.ANN
                  .getDefaultInstance()) return this;
          if (other.getTreeDepth() != 0) {
            setTreeDepth(other.getTreeDepth());
          }
          if (other.getLeafCount() != 0) {
            setLeafCount(other.getLeafCount());
          }
          this.mergeUnknownFields(other.getUnknownFields());
          onChanged();
          return this;
        }

        @java.lang.Override
        public final boolean isInitialized() {
          return true;
        }

        @java.lang.Override
        public Builder mergeFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws java.io.IOException {
          if (extensionRegistry == null) {
            throw new java.lang.NullPointerException();
          }
          try {
            boolean done = false;
            while (!done) {
              int tag = input.readTag();
              switch (tag) {
                case 0:
                  done = true;
                  break;
                case 8:
                  {
                    treeDepth_ = input.readInt32();
                    bitField0_ |= 0x00000001;
                    break;
                  } // case 8
                case 16:
                  {
                    leafCount_ = input.readInt32();
                    bitField0_ |= 0x00000002;
                    break;
                  } // case 16
                default:
                  {
                    if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                      done = true; // was an endgroup tag
                    }
                    break;
                  } // default:
              } // switch (tag)
            } // while (!done)
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.unwrapIOException();
          } finally {
            onChanged();
          } // finally
          return this;
        }

        private int bitField0_;

        private int treeDepth_;

        /**
         *
         *
         * <pre>
         * The depth of the tree-based structure. Only depth values of 2 and 3 are
         * supported.
         *
         * Recommended value is 2 if you have if you have O(10K) files in the
         * RagCorpus and set this to 3 if more than that.
         *
         * Default value is 2.
         * </pre>
         *
         * <code>int32 tree_depth = 1;</code>
         *
         * @return The treeDepth.
         */
        @java.lang.Override
        public int getTreeDepth() {
          return treeDepth_;
        }

        /**
         *
         *
         * <pre>
         * The depth of the tree-based structure. Only depth values of 2 and 3 are
         * supported.
         *
         * Recommended value is 2 if you have if you have O(10K) files in the
         * RagCorpus and set this to 3 if more than that.
         *
         * Default value is 2.
         * </pre>
         *
         * <code>int32 tree_depth = 1;</code>
         *
         * @param value The treeDepth to set.
         * @return This builder for chaining.
         */
        public Builder setTreeDepth(int value) {

          treeDepth_ = value;
          bitField0_ |= 0x00000001;
          onChanged();
          return this;
        }

        /**
         *
         *
         * <pre>
         * The depth of the tree-based structure. Only depth values of 2 and 3 are
         * supported.
         *
         * Recommended value is 2 if you have if you have O(10K) files in the
         * RagCorpus and set this to 3 if more than that.
         *
         * Default value is 2.
         * </pre>
         *
         * <code>int32 tree_depth = 1;</code>
         *
         * @return This builder for chaining.
         */
        public Builder clearTreeDepth() {
          bitField0_ = (bitField0_ & ~0x00000001);
          treeDepth_ = 0;
          onChanged();
          return this;
        }

        private int leafCount_;

        /**
         *
         *
         * <pre>
         * Number of leaf nodes in the tree-based structure. Each leaf node
         * contains groups of closely related vectors along with their
         * corresponding centroid.
         *
         * Recommended value is 10 * sqrt(num of RagFiles in your RagCorpus).
         *
         * Default value is 500.
         * </pre>
         *
         * <code>int32 leaf_count = 2;</code>
         *
         * @return The leafCount.
         */
        @java.lang.Override
        public int getLeafCount() {
          return leafCount_;
        }

        /**
         *
         *
         * <pre>
         * Number of leaf nodes in the tree-based structure. Each leaf node
         * contains groups of closely related vectors along with their
         * corresponding centroid.
         *
         * Recommended value is 10 * sqrt(num of RagFiles in your RagCorpus).
         *
         * Default value is 500.
         * </pre>
         *
         * <code>int32 leaf_count = 2;</code>
         *
         * @param value The leafCount to set.
         * @return This builder for chaining.
         */
        public Builder setLeafCount(int value) {

          leafCount_ = value;
          bitField0_ |= 0x00000002;
          onChanged();
          return this;
        }

        /**
         *
         *
         * <pre>
         * Number of leaf nodes in the tree-based structure. Each leaf node
         * contains groups of closely related vectors along with their
         * corresponding centroid.
         *
         * Recommended value is 10 * sqrt(num of RagFiles in your RagCorpus).
         *
         * Default value is 500.
         * </pre>
         *
         * <code>int32 leaf_count = 2;</code>
         *
         * @return This builder for chaining.
         */
        public Builder clearLeafCount() {
          bitField0_ = (bitField0_ & ~0x00000002);
          leafCount_ = 0;
          onChanged();
          return this;
        }

        @java.lang.Override
        public final Builder setUnknownFields(
            final com.google.protobuf.UnknownFieldSet unknownFields) {
          return super.setUnknownFields(unknownFields);
        }

        @java.lang.Override
        public final Builder mergeUnknownFields(
            final com.google.protobuf.UnknownFieldSet unknownFields) {
          return super.mergeUnknownFields(unknownFields);
        }

        // @@protoc_insertion_point(builder_scope:google.cloud.aiplatform.v1.RagVectorDbConfig.RagManagedDb.ANN)
      }

      // @@protoc_insertion_point(class_scope:google.cloud.aiplatform.v1.RagVectorDbConfig.RagManagedDb.ANN)
      private static final com.google.cloud.aiplatform.v1.RagVectorDbConfig.RagManagedDb.ANN
          DEFAULT_INSTANCE;

      static {
        DEFAULT_INSTANCE = new com.google.cloud.aiplatform.v1.RagVectorDbConfig.RagManagedDb.ANN();
      }

      public static com.google.cloud.aiplatform.v1.RagVectorDbConfig.RagManagedDb.ANN
          getDefaultInstance() {
        return DEFAULT_INSTANCE;
      }

      private static final com.google.protobuf.Parser<ANN> PARSER =
          new com.google.protobuf.AbstractParser<ANN>() {
            @java.lang.Override
            public ANN parsePartialFrom(
                com.google.protobuf.CodedInputStream input,
                com.google.protobuf.ExtensionRegistryLite extensionRegistry)
                throws com.google.protobuf.InvalidProtocolBufferException {
              Builder builder = newBuilder();
              try {
                builder.mergeFrom(input, extensionRegistry);
              } catch (com.google.protobuf.InvalidProtocolBufferException e) {
                throw e.setUnfinishedMessage(builder.buildPartial());
              } catch (com.google.protobuf.UninitializedMessageException e) {
                throw e.asInvalidProtocolBufferException()
                    .setUnfinishedMessage(builder.buildPartial());
              } catch (java.io.IOException e) {
                throw new com.google.protobuf.InvalidProtocolBufferException(e)
                    .setUnfinishedMessage(builder.buildPartial());
              }
              return builder.buildPartial();
            }
          };

      public static com.google.protobuf.Parser<ANN> parser() {
        return PARSER;
      }

      @java.lang.Override
      public com.google.protobuf.Parser<ANN> getParserForType() {
        return PARSER;
      }

      @java.lang.Override
      public com.google.cloud.aiplatform.v1.RagVectorDbConfig.RagManagedDb.ANN
          getDefaultInstanceForType() {
        return DEFAULT_INSTANCE;
      }
    }

    private int retrievalStrategyCase_ = 0;

    @SuppressWarnings("serial")
    private java.lang.Object retrievalStrategy_;

    public enum RetrievalStrategyCase
        implements
            com.google.protobuf.Internal.EnumLite,
            com.google.protobuf.AbstractMessage.InternalOneOfEnum {
      KNN(1),
      ANN(2),
      RETRIEVALSTRATEGY_NOT_SET(0);
      private final int value;

      private RetrievalStrategyCase(int value) {
        this.value = value;
      }

      /**
       * @param value The number of the enum to look for.
       * @return The enum associated with the given number.
       * @deprecated Use {@link #forNumber(int)} instead.
       */
      @java.lang.Deprecated
      public static RetrievalStrategyCase valueOf(int value) {
        return forNumber(value);
      }

      public static RetrievalStrategyCase forNumber(int value) {
        switch (value) {
          case 1:
            return KNN;
          case 2:
            return ANN;
          case 0:
            return RETRIEVALSTRATEGY_NOT_SET;
          default:
            return null;
        }
      }

      public int getNumber() {
        return this.value;
      }
    };

    public RetrievalStrategyCase getRetrievalStrategyCase() {
      return RetrievalStrategyCase.forNumber(retrievalStrategyCase_);
    }

    public static final int KNN_FIELD_NUMBER = 1;

    /**
     *
     *
     * <pre>
     * Performs a KNN search on RagCorpus.
     * Default choice if not specified.
     * </pre>
     *
     * <code>.google.cloud.aiplatform.v1.RagVectorDbConfig.RagManagedDb.KNN knn = 1;</code>
     *
     * @return Whether the knn field is set.
     */
    @java.lang.Override
    public boolean hasKnn() {
      return retrievalStrategyCase_ == 1;
    }

    /**
     *
     *
     * <pre>
     * Performs a KNN search on RagCorpus.
     * Default choice if not specified.
     * </pre>
     *
     * <code>.google.cloud.aiplatform.v1.RagVectorDbConfig.RagManagedDb.KNN knn = 1;</code>
     *
     * @return The knn.
     */
    @java.lang.Override
    public com.google.cloud.aiplatform.v1.RagVectorDbConfig.RagManagedDb.KNN getKnn() {
      if (retrievalStrategyCase_ == 1) {
        return (com.google.cloud.aiplatform.v1.RagVectorDbConfig.RagManagedDb.KNN)
            retrievalStrategy_;
      }
      return com.google.cloud.aiplatform.v1.RagVectorDbConfig.RagManagedDb.KNN.getDefaultInstance();
    }

    /**
     *
     *
     * <pre>
     * Performs a KNN search on RagCorpus.
     * Default choice if not specified.
     * </pre>
     *
     * <code>.google.cloud.aiplatform.v1.RagVectorDbConfig.RagManagedDb.KNN knn = 1;</code>
     */
    @java.lang.Override
    public com.google.cloud.aiplatform.v1.RagVectorDbConfig.RagManagedDb.KNNOrBuilder
        getKnnOrBuilder() {
      if (retrievalStrategyCase_ == 1) {
        return (com.google.cloud.aiplatform.v1.RagVectorDbConfig.RagManagedDb.KNN)
            retrievalStrategy_;
      }
      return com.google.cloud.aiplatform.v1.RagVectorDbConfig.RagManagedDb.KNN.getDefaultInstance();
    }

    public static final int ANN_FIELD_NUMBER = 2;

    /**
     *
     *
     * <pre>
     * Performs an ANN search on RagCorpus. Use this if you have a lot of
     * files (&gt; 10K) in your RagCorpus and want to reduce the search latency.
     * </pre>
     *
     * <code>.google.cloud.aiplatform.v1.RagVectorDbConfig.RagManagedDb.ANN ann = 2;</code>
     *
     * @return Whether the ann field is set.
     */
    @java.lang.Override
    public boolean hasAnn() {
      return retrievalStrategyCase_ == 2;
    }

    /**
     *
     *
     * <pre>
     * Performs an ANN search on RagCorpus. Use this if you have a lot of
     * files (&gt; 10K) in your RagCorpus and want to reduce the search latency.
     * </pre>
     *
     * <code>.google.cloud.aiplatform.v1.RagVectorDbConfig.RagManagedDb.ANN ann = 2;</code>
     *
     * @return The ann.
     */
    @java.lang.Override
    public com.google.cloud.aiplatform.v1.RagVectorDbConfig.RagManagedDb.ANN getAnn() {
      if (retrievalStrategyCase_ == 2) {
        return (com.google.cloud.aiplatform.v1.RagVectorDbConfig.RagManagedDb.ANN)
            retrievalStrategy_;
      }
      return com.google.cloud.aiplatform.v1.RagVectorDbConfig.RagManagedDb.ANN.getDefaultInstance();
    }

    /**
     *
     *
     * <pre>
     * Performs an ANN search on RagCorpus. Use this if you have a lot of
     * files (&gt; 10K) in your RagCorpus and want to reduce the search latency.
     * </pre>
     *
     * <code>.google.cloud.aiplatform.v1.RagVectorDbConfig.RagManagedDb.ANN ann = 2;</code>
     */
    @java.lang.Override
    public com.google.cloud.aiplatform.v1.RagVectorDbConfig.RagManagedDb.ANNOrBuilder
        getAnnOrBuilder() {
      if (retrievalStrategyCase_ == 2) {
        return (com.google.cloud.aiplatform.v1.RagVectorDbConfig.RagManagedDb.ANN)
            retrievalStrategy_;
      }
      return com.google.cloud.aiplatform.v1.RagVectorDbConfig.RagManagedDb.ANN.getDefaultInstance();
    }

    private byte memoizedIsInitialized = -1;

    @java.lang.Override
    public final boolean isInitialized() {
      byte isInitialized = memoizedIsInitialized;
      if (isInitialized == 1) return true;
      if (isInitialized == 0) return false;

      memoizedIsInitialized = 1;
      return true;
    }

    @java.lang.Override
    public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
      if (retrievalStrategyCase_ == 1) {
        output.writeMessage(
            1,
            (com.google.cloud.aiplatform.v1.RagVectorDbConfig.RagManagedDb.KNN) retrievalStrategy_);
      }
      if (retrievalStrategyCase_ == 2) {
        output.writeMessage(
            2,
            (com.google.cloud.aiplatform.v1.RagVectorDbConfig.RagManagedDb.ANN) retrievalStrategy_);
      }
      getUnknownFields().writeTo(output);
    }

    @java.lang.Override
    public int getSerializedSize() {
      int size = memoizedSize;
      if (size != -1) return size;

      size = 0;
      if (retrievalStrategyCase_ == 1) {
        size +=
            com.google.protobuf.CodedOutputStream.computeMessageSize(
                1,
                (com.google.cloud.aiplatform.v1.RagVectorDbConfig.RagManagedDb.KNN)
                    retrievalStrategy_);
      }
      if (retrievalStrategyCase_ == 2) {
        size +=
            com.google.protobuf.CodedOutputStream.computeMessageSize(
                2,
                (com.google.cloud.aiplatform.v1.RagVectorDbConfig.RagManagedDb.ANN)
                    retrievalStrategy_);
      }
      size += getUnknownFields().getSerializedSize();
      memoizedSize = size;
      return size;
    }

    @java.lang.Override
    public boolean equals(final java.lang.Object obj) {
      if (obj == this) {
        return true;
      }
      if (!(obj instanceof com.google.cloud.aiplatform.v1.RagVectorDbConfig.RagManagedDb)) {
        return super.equals(obj);
      }
      com.google.cloud.aiplatform.v1.RagVectorDbConfig.RagManagedDb other =
          (com.google.cloud.aiplatform.v1.RagVectorDbConfig.RagManagedDb) obj;

      if (!getRetrievalStrategyCase().equals(other.getRetrievalStrategyCase())) return false;
      switch (retrievalStrategyCase_) {
        case 1:
          if (!getKnn().equals(other.getKnn())) return false;
          break;
        case 2:
          if (!getAnn().equals(other.getAnn())) return false;
          break;
        case 0:
        default:
      }
      if (!getUnknownFields().equals(other.getUnknownFields())) return false;
      return true;
    }

    @java.lang.Override
    public int hashCode() {
      if (memoizedHashCode != 0) {
        return memoizedHashCode;
      }
      int hash = 41;
      hash = (19 * hash) + getDescriptor().hashCode();
      switch (retrievalStrategyCase_) {
        case 1:
          hash = (37 * hash) + KNN_FIELD_NUMBER;
          hash = (53 * hash) + getKnn().hashCode();
          break;
        case 2:
          hash = (37 * hash) + ANN_FIELD_NUMBER;
          hash = (53 * hash) + getAnn().hashCode();
          break;
        case 0:
        default:
      }
      hash = (29 * hash) + getUnknownFields().hashCode();
      memoizedHashCode = hash;
      return hash;
    }

    public static com.google.cloud.aiplatform.v1.RagVectorDbConfig.RagManagedDb parseFrom(
        java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.aiplatform.v1.RagVectorDbConfig.RagManagedDb parseFrom(
        java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.aiplatform.v1.RagVectorDbConfig.RagManagedDb parseFrom(
        com.google.protobuf.ByteString data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.aiplatform.v1.RagVectorDbConfig.RagManagedDb parseFrom(
        com.google.protobuf.ByteString data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.aiplatform.v1.RagVectorDbConfig.RagManagedDb parseFrom(
        byte[] data) throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.aiplatform.v1.RagVectorDbConfig.RagManagedDb parseFrom(
        byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.aiplatform.v1.RagVectorDbConfig.RagManagedDb parseFrom(
        java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.cloud.aiplatform.v1.RagVectorDbConfig.RagManagedDb parseFrom(
        java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.cloud.aiplatform.v1.RagVectorDbConfig.RagManagedDb parseDelimitedFrom(
        java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
    }

    public static com.google.cloud.aiplatform.v1.RagVectorDbConfig.RagManagedDb parseDelimitedFrom(
        java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.cloud.aiplatform.v1.RagVectorDbConfig.RagManagedDb parseFrom(
        com.google.protobuf.CodedInputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.cloud.aiplatform.v1.RagVectorDbConfig.RagManagedDb parseFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    @java.lang.Override
    public Builder newBuilderForType() {
      return newBuilder();
    }

    public static Builder newBuilder() {
      return DEFAULT_INSTANCE.toBuilder();
    }

    public static Builder newBuilder(
        com.google.cloud.aiplatform.v1.RagVectorDbConfig.RagManagedDb prototype) {
      return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }

    @java.lang.Override
    public Builder toBuilder() {
      return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
    }

    @java.lang.Override
    protected Builder newBuilderForType(
        com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      Builder builder = new Builder(parent);
      return builder;
    }

    /**
     *
     *
     * <pre>
     * The config for the default RAG-managed Vector DB.
     * </pre>
     *
     * Protobuf type {@code google.cloud.aiplatform.v1.RagVectorDbConfig.RagManagedDb}
     */
    public static final class Builder
        extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
        implements
        // @@protoc_insertion_point(builder_implements:google.cloud.aiplatform.v1.RagVectorDbConfig.RagManagedDb)
        com.google.cloud.aiplatform.v1.RagVectorDbConfig.RagManagedDbOrBuilder {
      public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
        return com.google.cloud.aiplatform.v1.VertexRagDataProto
            .internal_static_google_cloud_aiplatform_v1_RagVectorDbConfig_RagManagedDb_descriptor;
      }

      @java.lang.Override
      protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return com.google.cloud.aiplatform.v1.VertexRagDataProto
            .internal_static_google_cloud_aiplatform_v1_RagVectorDbConfig_RagManagedDb_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                com.google.cloud.aiplatform.v1.RagVectorDbConfig.RagManagedDb.class,
                com.google.cloud.aiplatform.v1.RagVectorDbConfig.RagManagedDb.Builder.class);
      }

      // Construct using com.google.cloud.aiplatform.v1.RagVectorDbConfig.RagManagedDb.newBuilder()
      private Builder() {}

      private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
        super(parent);
      }

      @java.lang.Override
      public Builder clear() {
        super.clear();
        bitField0_ = 0;
        if (knnBuilder_ != null) {
          knnBuilder_.clear();
        }
        if (annBuilder_ != null) {
          annBuilder_.clear();
        }
        retrievalStrategyCase_ = 0;
        retrievalStrategy_ = null;
        return this;
      }

      @java.lang.Override
      public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
        return com.google.cloud.aiplatform.v1.VertexRagDataProto
            .internal_static_google_cloud_aiplatform_v1_RagVectorDbConfig_RagManagedDb_descriptor;
      }

      @java.lang.Override
      public com.google.cloud.aiplatform.v1.RagVectorDbConfig.RagManagedDb
          getDefaultInstanceForType() {
        return com.google.cloud.aiplatform.v1.RagVectorDbConfig.RagManagedDb.getDefaultInstance();
      }

      @java.lang.Override
      public com.google.cloud.aiplatform.v1.RagVectorDbConfig.RagManagedDb build() {
        com.google.cloud.aiplatform.v1.RagVectorDbConfig.RagManagedDb result = buildPartial();
        if (!result.isInitialized()) {
          throw newUninitializedMessageException(result);
        }
        return result;
      }

      @java.lang.Override
      public com.google.cloud.aiplatform.v1.RagVectorDbConfig.RagManagedDb buildPartial() {
        com.google.cloud.aiplatform.v1.RagVectorDbConfig.RagManagedDb result =
            new com.google.cloud.aiplatform.v1.RagVectorDbConfig.RagManagedDb(this);
        if (bitField0_ != 0) {
          buildPartial0(result);
        }
        buildPartialOneofs(result);
        onBuilt();
        return result;
      }

      private void buildPartial0(
          com.google.cloud.aiplatform.v1.RagVectorDbConfig.RagManagedDb result) {
        int from_bitField0_ = bitField0_;
      }

      private void buildPartialOneofs(
          com.google.cloud.aiplatform.v1.RagVectorDbConfig.RagManagedDb result) {
        result.retrievalStrategyCase_ = retrievalStrategyCase_;
        result.retrievalStrategy_ = this.retrievalStrategy_;
        if (retrievalStrategyCase_ == 1 && knnBuilder_ != null) {
          result.retrievalStrategy_ = knnBuilder_.build();
        }
        if (retrievalStrategyCase_ == 2 && annBuilder_ != null) {
          result.retrievalStrategy_ = annBuilder_.build();
        }
      }

      @java.lang.Override
      public Builder clone() {
        return super.clone();
      }

      @java.lang.Override
      public Builder setField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.setField(field, value);
      }

      @java.lang.Override
      public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
        return super.clearField(field);
      }

      @java.lang.Override
      public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
        return super.clearOneof(oneof);
      }

      @java.lang.Override
      public Builder setRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          int index,
          java.lang.Object value) {
        return super.setRepeatedField(field, index, value);
      }

      @java.lang.Override
      public Builder addRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.addRepeatedField(field, value);
      }

      @java.lang.Override
      public Builder mergeFrom(com.google.protobuf.Message other) {
        if (other instanceof com.google.cloud.aiplatform.v1.RagVectorDbConfig.RagManagedDb) {
          return mergeFrom((com.google.cloud.aiplatform.v1.RagVectorDbConfig.RagManagedDb) other);
        } else {
          super.mergeFrom(other);
          return this;
        }
      }

      public Builder mergeFrom(
          com.google.cloud.aiplatform.v1.RagVectorDbConfig.RagManagedDb other) {
        if (other
            == com.google.cloud.aiplatform.v1.RagVectorDbConfig.RagManagedDb.getDefaultInstance())
          return this;
        switch (other.getRetrievalStrategyCase()) {
          case KNN:
            {
              mergeKnn(other.getKnn());
              break;
            }
          case ANN:
            {
              mergeAnn(other.getAnn());
              break;
            }
          case RETRIEVALSTRATEGY_NOT_SET:
            {
              break;
            }
        }
        this.mergeUnknownFields(other.getUnknownFields());
        onChanged();
        return this;
      }

      @java.lang.Override
      public final boolean isInitialized() {
        return true;
      }

      @java.lang.Override
      public Builder mergeFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        if (extensionRegistry == null) {
          throw new java.lang.NullPointerException();
        }
        try {
          boolean done = false;
          while (!done) {
            int tag = input.readTag();
            switch (tag) {
              case 0:
                done = true;
                break;
              case 10:
                {
                  input.readMessage(getKnnFieldBuilder().getBuilder(), extensionRegistry);
                  retrievalStrategyCase_ = 1;
                  break;
                } // case 10
              case 18:
                {
                  input.readMessage(getAnnFieldBuilder().getBuilder(), extensionRegistry);
                  retrievalStrategyCase_ = 2;
                  break;
                } // case 18
              default:
                {
                  if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                    done = true; // was an endgroup tag
                  }
                  break;
                } // default:
            } // switch (tag)
          } // while (!done)
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          throw e.unwrapIOException();
        } finally {
          onChanged();
        } // finally
        return this;
      }

      private int retrievalStrategyCase_ = 0;
      private java.lang.Object retrievalStrategy_;

      public RetrievalStrategyCase getRetrievalStrategyCase() {
        return RetrievalStrategyCase.forNumber(retrievalStrategyCase_);
      }

      public Builder clearRetrievalStrategy() {
        retrievalStrategyCase_ = 0;
        retrievalStrategy_ = null;
        onChanged();
        return this;
      }

      private int bitField0_;

      private com.google.protobuf.SingleFieldBuilderV3<
              com.google.cloud.aiplatform.v1.RagVectorDbConfig.RagManagedDb.KNN,
              com.google.cloud.aiplatform.v1.RagVectorDbConfig.RagManagedDb.KNN.Builder,
              com.google.cloud.aiplatform.v1.RagVectorDbConfig.RagManagedDb.KNNOrBuilder>
          knnBuilder_;

      /**
       *
       *
       * <pre>
       * Performs a KNN search on RagCorpus.
       * Default choice if not specified.
       * </pre>
       *
       * <code>.google.cloud.aiplatform.v1.RagVectorDbConfig.RagManagedDb.KNN knn = 1;</code>
       *
       * @return Whether the knn field is set.
       */
      @java.lang.Override
      public boolean hasKnn() {
        return retrievalStrategyCase_ == 1;
      }

      /**
       *
       *
       * <pre>
       * Performs a KNN search on RagCorpus.
       * Default choice if not specified.
       * </pre>
       *
       * <code>.google.cloud.aiplatform.v1.RagVectorDbConfig.RagManagedDb.KNN knn = 1;</code>
       *
       * @return The knn.
       */
      @java.lang.Override
      public com.google.cloud.aiplatform.v1.RagVectorDbConfig.RagManagedDb.KNN getKnn() {
        if (knnBuilder_ == null) {
          if (retrievalStrategyCase_ == 1) {
            return (com.google.cloud.aiplatform.v1.RagVectorDbConfig.RagManagedDb.KNN)
                retrievalStrategy_;
          }
          return com.google.cloud.aiplatform.v1.RagVectorDbConfig.RagManagedDb.KNN
              .getDefaultInstance();
        } else {
          if (retrievalStrategyCase_ == 1) {
            return knnBuilder_.getMessage();
          }
          return com.google.cloud.aiplatform.v1.RagVectorDbConfig.RagManagedDb.KNN
              .getDefaultInstance();
        }
      }

      /**
       *
       *
       * <pre>
       * Performs a KNN search on RagCorpus.
       * Default choice if not specified.
       * </pre>
       *
       * <code>.google.cloud.aiplatform.v1.RagVectorDbConfig.RagManagedDb.KNN knn = 1;</code>
       */
      public Builder setKnn(
          com.google.cloud.aiplatform.v1.RagVectorDbConfig.RagManagedDb.KNN value) {
        if (knnBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          retrievalStrategy_ = value;
          onChanged();
        } else {
          knnBuilder_.setMessage(value);
        }
        retrievalStrategyCase_ = 1;
        return this;
      }

      /**
       *
       *
       * <pre>
       * Performs a KNN search on RagCorpus.
       * Default choice if not specified.
       * </pre>
       *
       * <code>.google.cloud.aiplatform.v1.RagVectorDbConfig.RagManagedDb.KNN knn = 1;</code>
       */
      public Builder setKnn(
          com.google.cloud.aiplatform.v1.RagVectorDbConfig.RagManagedDb.KNN.Builder
              builderForValue) {
        if (knnBuilder_ == null) {
          retrievalStrategy_ = builderForValue.build();
          onChanged();
        } else {
          knnBuilder_.setMessage(builderForValue.build());
        }
        retrievalStrategyCase_ = 1;
        return this;
      }

      /**
       *
       *
       * <pre>
       * Performs a KNN search on RagCorpus.
       * Default choice if not specified.
       * </pre>
       *
       * <code>.google.cloud.aiplatform.v1.RagVectorDbConfig.RagManagedDb.KNN knn = 1;</code>
       */
      public Builder mergeKnn(
          com.google.cloud.aiplatform.v1.RagVectorDbConfig.RagManagedDb.KNN value) {
        if (knnBuilder_ == null) {
          if (retrievalStrategyCase_ == 1
              && retrievalStrategy_
                  != com.google.cloud.aiplatform.v1.RagVectorDbConfig.RagManagedDb.KNN
                      .getDefaultInstance()) {
            retrievalStrategy_ =
                com.google.cloud.aiplatform.v1.RagVectorDbConfig.RagManagedDb.KNN
                    .newBuilder(
                        (com.google.cloud.aiplatform.v1.RagVectorDbConfig.RagManagedDb.KNN)
                            retrievalStrategy_)
                    .mergeFrom(value)
                    .buildPartial();
          } else {
            retrievalStrategy_ = value;
          }
          onChanged();
        } else {
          if (retrievalStrategyCase_ == 1) {
            knnBuilder_.mergeFrom(value);
          } else {
            knnBuilder_.setMessage(value);
          }
        }
        retrievalStrategyCase_ = 1;
        return this;
      }

      /**
       *
       *
       * <pre>
       * Performs a KNN search on RagCorpus.
       * Default choice if not specified.
       * </pre>
       *
       * <code>.google.cloud.aiplatform.v1.RagVectorDbConfig.RagManagedDb.KNN knn = 1;</code>
       */
      public Builder clearKnn() {
        if (knnBuilder_ == null) {
          if (retrievalStrategyCase_ == 1) {
            retrievalStrategyCase_ = 0;
            retrievalStrategy_ = null;
            onChanged();
          }
        } else {
          if (retrievalStrategyCase_ == 1) {
            retrievalStrategyCase_ = 0;
            retrievalStrategy_ = null;
          }
          knnBuilder_.clear();
        }
        return this;
      }

      /**
       *
       *
       * <pre>
       * Performs a KNN search on RagCorpus.
       * Default choice if not specified.
       * </pre>
       *
       * <code>.google.cloud.aiplatform.v1.RagVectorDbConfig.RagManagedDb.KNN knn = 1;</code>
       */
      public com.google.cloud.aiplatform.v1.RagVectorDbConfig.RagManagedDb.KNN.Builder
          getKnnBuilder() {
        return getKnnFieldBuilder().getBuilder();
      }

      /**
       *
       *
       * <pre>
       * Performs a KNN search on RagCorpus.
       * Default choice if not specified.
       * </pre>
       *
       * <code>.google.cloud.aiplatform.v1.RagVectorDbConfig.RagManagedDb.KNN knn = 1;</code>
       */
      @java.lang.Override
      public com.google.cloud.aiplatform.v1.RagVectorDbConfig.RagManagedDb.KNNOrBuilder
          getKnnOrBuilder() {
        if ((retrievalStrategyCase_ == 1) && (knnBuilder_ != null)) {
          return knnBuilder_.getMessageOrBuilder();
        } else {
          if (retrievalStrategyCase_ == 1) {
            return (com.google.cloud.aiplatform.v1.RagVectorDbConfig.RagManagedDb.KNN)
                retrievalStrategy_;
          }
          return com.google.cloud.aiplatform.v1.RagVectorDbConfig.RagManagedDb.KNN
              .getDefaultInstance();
        }
      }

      /**
       *
       *
       * <pre>
       * Performs a KNN search on RagCorpus.
       * Default choice if not specified.
       * </pre>
       *
       * <code>.google.cloud.aiplatform.v1.RagVectorDbConfig.RagManagedDb.KNN knn = 1;</code>
       */
      private com.google.protobuf.SingleFieldBuilderV3<
              com.google.cloud.aiplatform.v1.RagVectorDbConfig.RagManagedDb.KNN,
              com.google.cloud.aiplatform.v1.RagVectorDbConfig.RagManagedDb.KNN.Builder,
              com.google.cloud.aiplatform.v1.RagVectorDbConfig.RagManagedDb.KNNOrBuilder>
          getKnnFieldBuilder() {
        if (knnBuilder_ == null) {
          if (!(retrievalStrategyCase_ == 1)) {
            retrievalStrategy_ =
                com.google.cloud.aiplatform.v1.RagVectorDbConfig.RagManagedDb.KNN
                    .getDefaultInstance();
          }
          knnBuilder_ =
              new com.google.protobuf.SingleFieldBuilderV3<
                  com.google.cloud.aiplatform.v1.RagVectorDbConfig.RagManagedDb.KNN,
                  com.google.cloud.aiplatform.v1.RagVectorDbConfig.RagManagedDb.KNN.Builder,
                  com.google.cloud.aiplatform.v1.RagVectorDbConfig.RagManagedDb.KNNOrBuilder>(
                  (com.google.cloud.aiplatform.v1.RagVectorDbConfig.RagManagedDb.KNN)
                      retrievalStrategy_,
                  getParentForChildren(),
                  isClean());
          retrievalStrategy_ = null;
        }
        retrievalStrategyCase_ = 1;
        onChanged();
        return knnBuilder_;
      }

      private com.google.protobuf.SingleFieldBuilderV3<
              com.google.cloud.aiplatform.v1.RagVectorDbConfig.RagManagedDb.ANN,
              com.google.cloud.aiplatform.v1.RagVectorDbConfig.RagManagedDb.ANN.Builder,
              com.google.cloud.aiplatform.v1.RagVectorDbConfig.RagManagedDb.ANNOrBuilder>
          annBuilder_;

      /**
       *
       *
       * <pre>
       * Performs an ANN search on RagCorpus. Use this if you have a lot of
       * files (&gt; 10K) in your RagCorpus and want to reduce the search latency.
       * </pre>
       *
       * <code>.google.cloud.aiplatform.v1.RagVectorDbConfig.RagManagedDb.ANN ann = 2;</code>
       *
       * @return Whether the ann field is set.
       */
      @java.lang.Override
      public boolean hasAnn() {
        return retrievalStrategyCase_ == 2;
      }

      /**
       *
       *
       * <pre>
       * Performs an ANN search on RagCorpus. Use this if you have a lot of
       * files (&gt; 10K) in your RagCorpus and want to reduce the search latency.
       * </pre>
       *
       * <code>.google.cloud.aiplatform.v1.RagVectorDbConfig.RagManagedDb.ANN ann = 2;</code>
       *
       * @return The ann.
       */
      @java.lang.Override
      public com.google.cloud.aiplatform.v1.RagVectorDbConfig.RagManagedDb.ANN getAnn() {
        if (annBuilder_ == null) {
          if (retrievalStrategyCase_ == 2) {
            return (com.google.cloud.aiplatform.v1.RagVectorDbConfig.RagManagedDb.ANN)
                retrievalStrategy_;
          }
          return com.google.cloud.aiplatform.v1.RagVectorDbConfig.RagManagedDb.ANN
              .getDefaultInstance();
        } else {
          if (retrievalStrategyCase_ == 2) {
            return annBuilder_.getMessage();
          }
          return com.google.cloud.aiplatform.v1.RagVectorDbConfig.RagManagedDb.ANN
              .getDefaultInstance();
        }
      }

      /**
       *
       *
       * <pre>
       * Performs an ANN search on RagCorpus. Use this if you have a lot of
       * files (&gt; 10K) in your RagCorpus and want to reduce the search latency.
       * </pre>
       *
       * <code>.google.cloud.aiplatform.v1.RagVectorDbConfig.RagManagedDb.ANN ann = 2;</code>
       */
      public Builder setAnn(
          com.google.cloud.aiplatform.v1.RagVectorDbConfig.RagManagedDb.ANN value) {
        if (annBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          retrievalStrategy_ = value;
          onChanged();
        } else {
          annBuilder_.setMessage(value);
        }
        retrievalStrategyCase_ = 2;
        return this;
      }

      /**
       *
       *
       * <pre>
       * Performs an ANN search on RagCorpus. Use this if you have a lot of
       * files (&gt; 10K) in your RagCorpus and want to reduce the search latency.
       * </pre>
       *
       * <code>.google.cloud.aiplatform.v1.RagVectorDbConfig.RagManagedDb.ANN ann = 2;</code>
       */
      public Builder setAnn(
          com.google.cloud.aiplatform.v1.RagVectorDbConfig.RagManagedDb.ANN.Builder
              builderForValue) {
        if (annBuilder_ == null) {
          retrievalStrategy_ = builderForValue.build();
          onChanged();
        } else {
          annBuilder_.setMessage(builderForValue.build());
        }
        retrievalStrategyCase_ = 2;
        return this;
      }

      /**
       *
       *
       * <pre>
       * Performs an ANN search on RagCorpus. Use this if you have a lot of
       * files (&gt; 10K) in your RagCorpus and want to reduce the search latency.
       * </pre>
       *
       * <code>.google.cloud.aiplatform.v1.RagVectorDbConfig.RagManagedDb.ANN ann = 2;</code>
       */
      public Builder mergeAnn(
          com.google.cloud.aiplatform.v1.RagVectorDbConfig.RagManagedDb.ANN value) {
        if (annBuilder_ == null) {
          if (retrievalStrategyCase_ == 2
              && retrievalStrategy_
                  != com.google.cloud.aiplatform.v1.RagVectorDbConfig.RagManagedDb.ANN
                      .getDefaultInstance()) {
            retrievalStrategy_ =
                com.google.cloud.aiplatform.v1.RagVectorDbConfig.RagManagedDb.ANN
                    .newBuilder(
                        (com.google.cloud.aiplatform.v1.RagVectorDbConfig.RagManagedDb.ANN)
                            retrievalStrategy_)
                    .mergeFrom(value)
                    .buildPartial();
          } else {
            retrievalStrategy_ = value;
          }
          onChanged();
        } else {
          if (retrievalStrategyCase_ == 2) {
            annBuilder_.mergeFrom(value);
          } else {
            annBuilder_.setMessage(value);
          }
        }
        retrievalStrategyCase_ = 2;
        return this;
      }

      /**
       *
       *
       * <pre>
       * Performs an ANN search on RagCorpus. Use this if you have a lot of
       * files (&gt; 10K) in your RagCorpus and want to reduce the search latency.
       * </pre>
       *
       * <code>.google.cloud.aiplatform.v1.RagVectorDbConfig.RagManagedDb.ANN ann = 2;</code>
       */
      public Builder clearAnn() {
        if (annBuilder_ == null) {
          if (retrievalStrategyCase_ == 2) {
            retrievalStrategyCase_ = 0;
            retrievalStrategy_ = null;
            onChanged();
          }
        } else {
          if (retrievalStrategyCase_ == 2) {
            retrievalStrategyCase_ = 0;
            retrievalStrategy_ = null;
          }
          annBuilder_.clear();
        }
        return this;
      }

      /**
       *
       *
       * <pre>
       * Performs an ANN search on RagCorpus. Use this if you have a lot of
       * files (&gt; 10K) in your RagCorpus and want to reduce the search latency.
       * </pre>
       *
       * <code>.google.cloud.aiplatform.v1.RagVectorDbConfig.RagManagedDb.ANN ann = 2;</code>
       */
      public com.google.cloud.aiplatform.v1.RagVectorDbConfig.RagManagedDb.ANN.Builder
          getAnnBuilder() {
        return getAnnFieldBuilder().getBuilder();
      }

      /**
       *
       *
       * <pre>
       * Performs an ANN search on RagCorpus. Use this if you have a lot of
       * files (&gt; 10K) in your RagCorpus and want to reduce the search latency.
       * </pre>
       *
       * <code>.google.cloud.aiplatform.v1.RagVectorDbConfig.RagManagedDb.ANN ann = 2;</code>
       */
      @java.lang.Override
      public com.google.cloud.aiplatform.v1.RagVectorDbConfig.RagManagedDb.ANNOrBuilder
          getAnnOrBuilder() {
        if ((retrievalStrategyCase_ == 2) && (annBuilder_ != null)) {
          return annBuilder_.getMessageOrBuilder();
        } else {
          if (retrievalStrategyCase_ == 2) {
            return (com.google.cloud.aiplatform.v1.RagVectorDbConfig.RagManagedDb.ANN)
                retrievalStrategy_;
          }
          return com.google.cloud.aiplatform.v1.RagVectorDbConfig.RagManagedDb.ANN
              .getDefaultInstance();
        }
      }

      /**
       *
       *
       * <pre>
       * Performs an ANN search on RagCorpus. Use this if you have a lot of
       * files (&gt; 10K) in your RagCorpus and want to reduce the search latency.
       * </pre>
       *
       * <code>.google.cloud.aiplatform.v1.RagVectorDbConfig.RagManagedDb.ANN ann = 2;</code>
       */
      private com.google.protobuf.SingleFieldBuilderV3<
              com.google.cloud.aiplatform.v1.RagVectorDbConfig.RagManagedDb.ANN,
              com.google.cloud.aiplatform.v1.RagVectorDbConfig.RagManagedDb.ANN.Builder,
              com.google.cloud.aiplatform.v1.RagVectorDbConfig.RagManagedDb.ANNOrBuilder>
          getAnnFieldBuilder() {
        if (annBuilder_ == null) {
          if (!(retrievalStrategyCase_ == 2)) {
            retrievalStrategy_ =
                com.google.cloud.aiplatform.v1.RagVectorDbConfig.RagManagedDb.ANN
                    .getDefaultInstance();
          }
          annBuilder_ =
              new com.google.protobuf.SingleFieldBuilderV3<
                  com.google.cloud.aiplatform.v1.RagVectorDbConfig.RagManagedDb.ANN,
                  com.google.cloud.aiplatform.v1.RagVectorDbConfig.RagManagedDb.ANN.Builder,
                  com.google.cloud.aiplatform.v1.RagVectorDbConfig.RagManagedDb.ANNOrBuilder>(
                  (com.google.cloud.aiplatform.v1.RagVectorDbConfig.RagManagedDb.ANN)
                      retrievalStrategy_,
                  getParentForChildren(),
                  isClean());
          retrievalStrategy_ = null;
        }
        retrievalStrategyCase_ = 2;
        onChanged();
        return annBuilder_;
      }

      @java.lang.Override
      public final Builder setUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.setUnknownFields(unknownFields);
      }

      @java.lang.Override
      public final Builder mergeUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.mergeUnknownFields(unknownFields);
      }

      // @@protoc_insertion_point(builder_scope:google.cloud.aiplatform.v1.RagVectorDbConfig.RagManagedDb)
    }

    // @@protoc_insertion_point(class_scope:google.cloud.aiplatform.v1.RagVectorDbConfig.RagManagedDb)
    private static final com.google.cloud.aiplatform.v1.RagVectorDbConfig.RagManagedDb
        DEFAULT_INSTANCE;

    static {
      DEFAULT_INSTANCE = new com.google.cloud.aiplatform.v1.RagVectorDbConfig.RagManagedDb();
    }

    public static com.google.cloud.aiplatform.v1.RagVectorDbConfig.RagManagedDb
        getDefaultInstance() {
      return DEFAULT_INSTANCE;
    }

    private static final com.google.protobuf.Parser<RagManagedDb> PARSER =
        new com.google.protobuf.AbstractParser<RagManagedDb>() {
          @java.lang.Override
          public RagManagedDb parsePartialFrom(
              com.google.protobuf.CodedInputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
            Builder builder = newBuilder();
            try {
              builder.mergeFrom(input, extensionRegistry);
            } catch (com.google.protobuf.InvalidProtocolBufferException e) {
              throw e.setUnfinishedMessage(builder.buildPartial());
            } catch (com.google.protobuf.UninitializedMessageException e) {
              throw e.asInvalidProtocolBufferException()
                  .setUnfinishedMessage(builder.buildPartial());
            } catch (java.io.IOException e) {
              throw new com.google.protobuf.InvalidProtocolBufferException(e)
                  .setUnfinishedMessage(builder.buildPartial());
            }
            return builder.buildPartial();
          }
        };

    public static com.google.protobuf.Parser<RagManagedDb> parser() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.protobuf.Parser<RagManagedDb> getParserForType() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.cloud.aiplatform.v1.RagVectorDbConfig.RagManagedDb
        getDefaultInstanceForType() {
      return DEFAULT_INSTANCE;
    }
  }

  public interface PineconeOrBuilder
      extends
      // @@protoc_insertion_point(interface_extends:google.cloud.aiplatform.v1.RagVectorDbConfig.Pinecone)
      com.google.protobuf.MessageOrBuilder {

    /**
     *
     *
     * <pre>
     * Pinecone index name.
     * This value cannot be changed after it's set.
     * </pre>
     *
     * <code>string index_name = 1;</code>
     *
     * @return The indexName.
     */
    java.lang.String getIndexName();

    /**
     *
     *
     * <pre>
     * Pinecone index name.
     * This value cannot be changed after it's set.
     * </pre>
     *
     * <code>string index_name = 1;</code>
     *
     * @return The bytes for indexName.
     */
    com.google.protobuf.ByteString getIndexNameBytes();
  }

  /**
   *
   *
   * <pre>
   * The config for the Pinecone.
   * </pre>
   *
   * Protobuf type {@code google.cloud.aiplatform.v1.RagVectorDbConfig.Pinecone}
   */
  public static final class Pinecone extends com.google.protobuf.GeneratedMessageV3
      implements
      // @@protoc_insertion_point(message_implements:google.cloud.aiplatform.v1.RagVectorDbConfig.Pinecone)
      PineconeOrBuilder {
    private static final long serialVersionUID = 0L;

    // Use Pinecone.newBuilder() to construct.
    private Pinecone(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
      super(builder);
    }

    private Pinecone() {
      indexName_ = "";
    }

    @java.lang.Override
    @SuppressWarnings({"unused"})
    protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
      return new Pinecone();
    }

    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.aiplatform.v1.VertexRagDataProto
          .internal_static_google_cloud_aiplatform_v1_RagVectorDbConfig_Pinecone_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.aiplatform.v1.VertexRagDataProto
          .internal_static_google_cloud_aiplatform_v1_RagVectorDbConfig_Pinecone_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.aiplatform.v1.RagVectorDbConfig.Pinecone.class,
              com.google.cloud.aiplatform.v1.RagVectorDbConfig.Pinecone.Builder.class);
    }

    public static final int INDEX_NAME_FIELD_NUMBER = 1;

    @SuppressWarnings("serial")
    private volatile java.lang.Object indexName_ = "";

    /**
     *
     *
     * <pre>
     * Pinecone index name.
     * This value cannot be changed after it's set.
     * </pre>
     *
     * <code>string index_name = 1;</code>
     *
     * @return The indexName.
     */
    @java.lang.Override
    public java.lang.String getIndexName() {
      java.lang.Object ref = indexName_;
      if (ref instanceof java.lang.String) {
        return (java.lang.String) ref;
      } else {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        indexName_ = s;
        return s;
      }
    }

    /**
     *
     *
     * <pre>
     * Pinecone index name.
     * This value cannot be changed after it's set.
     * </pre>
     *
     * <code>string index_name = 1;</code>
     *
     * @return The bytes for indexName.
     */
    @java.lang.Override
    public com.google.protobuf.ByteString getIndexNameBytes() {
      java.lang.Object ref = indexName_;
      if (ref instanceof java.lang.String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        indexName_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    private byte memoizedIsInitialized = -1;

    @java.lang.Override
    public final boolean isInitialized() {
      byte isInitialized = memoizedIsInitialized;
      if (isInitialized == 1) return true;
      if (isInitialized == 0) return false;

      memoizedIsInitialized = 1;
      return true;
    }

    @java.lang.Override
    public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(indexName_)) {
        com.google.protobuf.GeneratedMessageV3.writeString(output, 1, indexName_);
      }
      getUnknownFields().writeTo(output);
    }

    @java.lang.Override
    public int getSerializedSize() {
      int size = memoizedSize;
      if (size != -1) return size;

      size = 0;
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(indexName_)) {
        size += com.google.protobuf.GeneratedMessageV3.computeStringSize(1, indexName_);
      }
      size += getUnknownFields().getSerializedSize();
      memoizedSize = size;
      return size;
    }

    @java.lang.Override
    public boolean equals(final java.lang.Object obj) {
      if (obj == this) {
        return true;
      }
      if (!(obj instanceof com.google.cloud.aiplatform.v1.RagVectorDbConfig.Pinecone)) {
        return super.equals(obj);
      }
      com.google.cloud.aiplatform.v1.RagVectorDbConfig.Pinecone other =
          (com.google.cloud.aiplatform.v1.RagVectorDbConfig.Pinecone) obj;

      if (!getIndexName().equals(other.getIndexName())) return false;
      if (!getUnknownFields().equals(other.getUnknownFields())) return false;
      return true;
    }

    @java.lang.Override
    public int hashCode() {
      if (memoizedHashCode != 0) {
        return memoizedHashCode;
      }
      int hash = 41;
      hash = (19 * hash) + getDescriptor().hashCode();
      hash = (37 * hash) + INDEX_NAME_FIELD_NUMBER;
      hash = (53 * hash) + getIndexName().hashCode();
      hash = (29 * hash) + getUnknownFields().hashCode();
      memoizedHashCode = hash;
      return hash;
    }

    public static com.google.cloud.aiplatform.v1.RagVectorDbConfig.Pinecone parseFrom(
        java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.aiplatform.v1.RagVectorDbConfig.Pinecone parseFrom(
        java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.aiplatform.v1.RagVectorDbConfig.Pinecone parseFrom(
        com.google.protobuf.ByteString data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.aiplatform.v1.RagVectorDbConfig.Pinecone parseFrom(
        com.google.protobuf.ByteString data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.aiplatform.v1.RagVectorDbConfig.Pinecone parseFrom(byte[] data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.aiplatform.v1.RagVectorDbConfig.Pinecone parseFrom(
        byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.aiplatform.v1.RagVectorDbConfig.Pinecone parseFrom(
        java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.cloud.aiplatform.v1.RagVectorDbConfig.Pinecone parseFrom(
        java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.cloud.aiplatform.v1.RagVectorDbConfig.Pinecone parseDelimitedFrom(
        java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
    }

    public static com.google.cloud.aiplatform.v1.RagVectorDbConfig.Pinecone parseDelimitedFrom(
        java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.cloud.aiplatform.v1.RagVectorDbConfig.Pinecone parseFrom(
        com.google.protobuf.CodedInputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.cloud.aiplatform.v1.RagVectorDbConfig.Pinecone parseFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    @java.lang.Override
    public Builder newBuilderForType() {
      return newBuilder();
    }

    public static Builder newBuilder() {
      return DEFAULT_INSTANCE.toBuilder();
    }

    public static Builder newBuilder(
        com.google.cloud.aiplatform.v1.RagVectorDbConfig.Pinecone prototype) {
      return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }

    @java.lang.Override
    public Builder toBuilder() {
      return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
    }

    @java.lang.Override
    protected Builder newBuilderForType(
        com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      Builder builder = new Builder(parent);
      return builder;
    }

    /**
     *
     *
     * <pre>
     * The config for the Pinecone.
     * </pre>
     *
     * Protobuf type {@code google.cloud.aiplatform.v1.RagVectorDbConfig.Pinecone}
     */
    public static final class Builder
        extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
        implements
        // @@protoc_insertion_point(builder_implements:google.cloud.aiplatform.v1.RagVectorDbConfig.Pinecone)
        com.google.cloud.aiplatform.v1.RagVectorDbConfig.PineconeOrBuilder {
      public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
        return com.google.cloud.aiplatform.v1.VertexRagDataProto
            .internal_static_google_cloud_aiplatform_v1_RagVectorDbConfig_Pinecone_descriptor;
      }

      @java.lang.Override
      protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return com.google.cloud.aiplatform.v1.VertexRagDataProto
            .internal_static_google_cloud_aiplatform_v1_RagVectorDbConfig_Pinecone_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                com.google.cloud.aiplatform.v1.RagVectorDbConfig.Pinecone.class,
                com.google.cloud.aiplatform.v1.RagVectorDbConfig.Pinecone.Builder.class);
      }

      // Construct using com.google.cloud.aiplatform.v1.RagVectorDbConfig.Pinecone.newBuilder()
      private Builder() {}

      private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
        super(parent);
      }

      @java.lang.Override
      public Builder clear() {
        super.clear();
        bitField0_ = 0;
        indexName_ = "";
        return this;
      }

      @java.lang.Override
      public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
        return com.google.cloud.aiplatform.v1.VertexRagDataProto
            .internal_static_google_cloud_aiplatform_v1_RagVectorDbConfig_Pinecone_descriptor;
      }

      @java.lang.Override
      public com.google.cloud.aiplatform.v1.RagVectorDbConfig.Pinecone getDefaultInstanceForType() {
        return com.google.cloud.aiplatform.v1.RagVectorDbConfig.Pinecone.getDefaultInstance();
      }

      @java.lang.Override
      public com.google.cloud.aiplatform.v1.RagVectorDbConfig.Pinecone build() {
        com.google.cloud.aiplatform.v1.RagVectorDbConfig.Pinecone result = buildPartial();
        if (!result.isInitialized()) {
          throw newUninitializedMessageException(result);
        }
        return result;
      }

      @java.lang.Override
      public com.google.cloud.aiplatform.v1.RagVectorDbConfig.Pinecone buildPartial() {
        com.google.cloud.aiplatform.v1.RagVectorDbConfig.Pinecone result =
            new com.google.cloud.aiplatform.v1.RagVectorDbConfig.Pinecone(this);
        if (bitField0_ != 0) {
          buildPartial0(result);
        }
        onBuilt();
        return result;
      }

      private void buildPartial0(com.google.cloud.aiplatform.v1.RagVectorDbConfig.Pinecone result) {
        int from_bitField0_ = bitField0_;
        if (((from_bitField0_ & 0x00000001) != 0)) {
          result.indexName_ = indexName_;
        }
      }

      @java.lang.Override
      public Builder clone() {
        return super.clone();
      }

      @java.lang.Override
      public Builder setField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.setField(field, value);
      }

      @java.lang.Override
      public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
        return super.clearField(field);
      }

      @java.lang.Override
      public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
        return super.clearOneof(oneof);
      }

      @java.lang.Override
      public Builder setRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          int index,
          java.lang.Object value) {
        return super.setRepeatedField(field, index, value);
      }

      @java.lang.Override
      public Builder addRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.addRepeatedField(field, value);
      }

      @java.lang.Override
      public Builder mergeFrom(com.google.protobuf.Message other) {
        if (other instanceof com.google.cloud.aiplatform.v1.RagVectorDbConfig.Pinecone) {
          return mergeFrom((com.google.cloud.aiplatform.v1.RagVectorDbConfig.Pinecone) other);
        } else {
          super.mergeFrom(other);
          return this;
        }
      }

      public Builder mergeFrom(com.google.cloud.aiplatform.v1.RagVectorDbConfig.Pinecone other) {
        if (other == com.google.cloud.aiplatform.v1.RagVectorDbConfig.Pinecone.getDefaultInstance())
          return this;
        if (!other.getIndexName().isEmpty()) {
          indexName_ = other.indexName_;
          bitField0_ |= 0x00000001;
          onChanged();
        }
        this.mergeUnknownFields(other.getUnknownFields());
        onChanged();
        return this;
      }

      @java.lang.Override
      public final boolean isInitialized() {
        return true;
      }

      @java.lang.Override
      public Builder mergeFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        if (extensionRegistry == null) {
          throw new java.lang.NullPointerException();
        }
        try {
          boolean done = false;
          while (!done) {
            int tag = input.readTag();
            switch (tag) {
              case 0:
                done = true;
                break;
              case 10:
                {
                  indexName_ = input.readStringRequireUtf8();
                  bitField0_ |= 0x00000001;
                  break;
                } // case 10
              default:
                {
                  if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                    done = true; // was an endgroup tag
                  }
                  break;
                } // default:
            } // switch (tag)
          } // while (!done)
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          throw e.unwrapIOException();
        } finally {
          onChanged();
        } // finally
        return this;
      }

      private int bitField0_;

      private java.lang.Object indexName_ = "";

      /**
       *
       *
       * <pre>
       * Pinecone index name.
       * This value cannot be changed after it's set.
       * </pre>
       *
       * <code>string index_name = 1;</code>
       *
       * @return The indexName.
       */
      public java.lang.String getIndexName() {
        java.lang.Object ref = indexName_;
        if (!(ref instanceof java.lang.String)) {
          com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
          java.lang.String s = bs.toStringUtf8();
          indexName_ = s;
          return s;
        } else {
          return (java.lang.String) ref;
        }
      }

      /**
       *
       *
       * <pre>
       * Pinecone index name.
       * This value cannot be changed after it's set.
       * </pre>
       *
       * <code>string index_name = 1;</code>
       *
       * @return The bytes for indexName.
       */
      public com.google.protobuf.ByteString getIndexNameBytes() {
        java.lang.Object ref = indexName_;
        if (ref instanceof String) {
          com.google.protobuf.ByteString b =
              com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
          indexName_ = b;
          return b;
        } else {
          return (com.google.protobuf.ByteString) ref;
        }
      }

      /**
       *
       *
       * <pre>
       * Pinecone index name.
       * This value cannot be changed after it's set.
       * </pre>
       *
       * <code>string index_name = 1;</code>
       *
       * @param value The indexName to set.
       * @return This builder for chaining.
       */
      public Builder setIndexName(java.lang.String value) {
        if (value == null) {
          throw new NullPointerException();
        }
        indexName_ = value;
        bitField0_ |= 0x00000001;
        onChanged();
        return this;
      }

      /**
       *
       *
       * <pre>
       * Pinecone index name.
       * This value cannot be changed after it's set.
       * </pre>
       *
       * <code>string index_name = 1;</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearIndexName() {
        indexName_ = getDefaultInstance().getIndexName();
        bitField0_ = (bitField0_ & ~0x00000001);
        onChanged();
        return this;
      }

      /**
       *
       *
       * <pre>
       * Pinecone index name.
       * This value cannot be changed after it's set.
       * </pre>
       *
       * <code>string index_name = 1;</code>
       *
       * @param value The bytes for indexName to set.
       * @return This builder for chaining.
       */
      public Builder setIndexNameBytes(com.google.protobuf.ByteString value) {
        if (value == null) {
          throw new NullPointerException();
        }
        checkByteStringIsUtf8(value);
        indexName_ = value;
        bitField0_ |= 0x00000001;
        onChanged();
        return this;
      }

      @java.lang.Override
      public final Builder setUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.setUnknownFields(unknownFields);
      }

      @java.lang.Override
      public final Builder mergeUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.mergeUnknownFields(unknownFields);
      }

      // @@protoc_insertion_point(builder_scope:google.cloud.aiplatform.v1.RagVectorDbConfig.Pinecone)
    }

    // @@protoc_insertion_point(class_scope:google.cloud.aiplatform.v1.RagVectorDbConfig.Pinecone)
    private static final com.google.cloud.aiplatform.v1.RagVectorDbConfig.Pinecone DEFAULT_INSTANCE;

    static {
      DEFAULT_INSTANCE = new com.google.cloud.aiplatform.v1.RagVectorDbConfig.Pinecone();
    }

    public static com.google.cloud.aiplatform.v1.RagVectorDbConfig.Pinecone getDefaultInstance() {
      return DEFAULT_INSTANCE;
    }

    private static final com.google.protobuf.Parser<Pinecone> PARSER =
        new com.google.protobuf.AbstractParser<Pinecone>() {
          @java.lang.Override
          public Pinecone parsePartialFrom(
              com.google.protobuf.CodedInputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
            Builder builder = newBuilder();
            try {
              builder.mergeFrom(input, extensionRegistry);
            } catch (com.google.protobuf.InvalidProtocolBufferException e) {
              throw e.setUnfinishedMessage(builder.buildPartial());
            } catch (com.google.protobuf.UninitializedMessageException e) {
              throw e.asInvalidProtocolBufferException()
                  .setUnfinishedMessage(builder.buildPartial());
            } catch (java.io.IOException e) {
              throw new com.google.protobuf.InvalidProtocolBufferException(e)
                  .setUnfinishedMessage(builder.buildPartial());
            }
            return builder.buildPartial();
          }
        };

    public static com.google.protobuf.Parser<Pinecone> parser() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.protobuf.Parser<Pinecone> getParserForType() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.cloud.aiplatform.v1.RagVectorDbConfig.Pinecone getDefaultInstanceForType() {
      return DEFAULT_INSTANCE;
    }
  }

  public interface VertexVectorSearchOrBuilder
      extends
      // @@protoc_insertion_point(interface_extends:google.cloud.aiplatform.v1.RagVectorDbConfig.VertexVectorSearch)
      com.google.protobuf.MessageOrBuilder {

    /**
     *
     *
     * <pre>
     * The resource name of the Index Endpoint.
     * Format:
     * `projects/{project}/locations/{location}/indexEndpoints/{index_endpoint}`
     * </pre>
     *
     * <code>string index_endpoint = 1;</code>
     *
     * @return The indexEndpoint.
     */
    java.lang.String getIndexEndpoint();

    /**
     *
     *
     * <pre>
     * The resource name of the Index Endpoint.
     * Format:
     * `projects/{project}/locations/{location}/indexEndpoints/{index_endpoint}`
     * </pre>
     *
     * <code>string index_endpoint = 1;</code>
     *
     * @return The bytes for indexEndpoint.
     */
    com.google.protobuf.ByteString getIndexEndpointBytes();

    /**
     *
     *
     * <pre>
     * The resource name of the Index.
     * Format:
     * `projects/{project}/locations/{location}/indexes/{index}`
     * </pre>
     *
     * <code>string index = 2;</code>
     *
     * @return The index.
     */
    java.lang.String getIndex();

    /**
     *
     *
     * <pre>
     * The resource name of the Index.
     * Format:
     * `projects/{project}/locations/{location}/indexes/{index}`
     * </pre>
     *
     * <code>string index = 2;</code>
     *
     * @return The bytes for index.
     */
    com.google.protobuf.ByteString getIndexBytes();
  }

  /**
   *
   *
   * <pre>
   * The config for the Vertex Vector Search.
   * </pre>
   *
   * Protobuf type {@code google.cloud.aiplatform.v1.RagVectorDbConfig.VertexVectorSearch}
   */
  public static final class VertexVectorSearch extends com.google.protobuf.GeneratedMessageV3
      implements
      // @@protoc_insertion_point(message_implements:google.cloud.aiplatform.v1.RagVectorDbConfig.VertexVectorSearch)
      VertexVectorSearchOrBuilder {
    private static final long serialVersionUID = 0L;

    // Use VertexVectorSearch.newBuilder() to construct.
    private VertexVectorSearch(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
      super(builder);
    }

    private VertexVectorSearch() {
      indexEndpoint_ = "";
      index_ = "";
    }

    @java.lang.Override
    @SuppressWarnings({"unused"})
    protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
      return new VertexVectorSearch();
    }

    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.aiplatform.v1.VertexRagDataProto
          .internal_static_google_cloud_aiplatform_v1_RagVectorDbConfig_VertexVectorSearch_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.aiplatform.v1.VertexRagDataProto
          .internal_static_google_cloud_aiplatform_v1_RagVectorDbConfig_VertexVectorSearch_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.aiplatform.v1.RagVectorDbConfig.VertexVectorSearch.class,
              com.google.cloud.aiplatform.v1.RagVectorDbConfig.VertexVectorSearch.Builder.class);
    }

    public static final int INDEX_ENDPOINT_FIELD_NUMBER = 1;

    @SuppressWarnings("serial")
    private volatile java.lang.Object indexEndpoint_ = "";

    /**
     *
     *
     * <pre>
     * The resource name of the Index Endpoint.
     * Format:
     * `projects/{project}/locations/{location}/indexEndpoints/{index_endpoint}`
     * </pre>
     *
     * <code>string index_endpoint = 1;</code>
     *
     * @return The indexEndpoint.
     */
    @java.lang.Override
    public java.lang.String getIndexEndpoint() {
      java.lang.Object ref = indexEndpoint_;
      if (ref instanceof java.lang.String) {
        return (java.lang.String) ref;
      } else {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        indexEndpoint_ = s;
        return s;
      }
    }

    /**
     *
     *
     * <pre>
     * The resource name of the Index Endpoint.
     * Format:
     * `projects/{project}/locations/{location}/indexEndpoints/{index_endpoint}`
     * </pre>
     *
     * <code>string index_endpoint = 1;</code>
     *
     * @return The bytes for indexEndpoint.
     */
    @java.lang.Override
    public com.google.protobuf.ByteString getIndexEndpointBytes() {
      java.lang.Object ref = indexEndpoint_;
      if (ref instanceof java.lang.String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        indexEndpoint_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    public static final int INDEX_FIELD_NUMBER = 2;

    @SuppressWarnings("serial")
    private volatile java.lang.Object index_ = "";

    /**
     *
     *
     * <pre>
     * The resource name of the Index.
     * Format:
     * `projects/{project}/locations/{location}/indexes/{index}`
     * </pre>
     *
     * <code>string index = 2;</code>
     *
     * @return The index.
     */
    @java.lang.Override
    public java.lang.String getIndex() {
      java.lang.Object ref = index_;
      if (ref instanceof java.lang.String) {
        return (java.lang.String) ref;
      } else {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        index_ = s;
        return s;
      }
    }

    /**
     *
     *
     * <pre>
     * The resource name of the Index.
     * Format:
     * `projects/{project}/locations/{location}/indexes/{index}`
     * </pre>
     *
     * <code>string index = 2;</code>
     *
     * @return The bytes for index.
     */
    @java.lang.Override
    public com.google.protobuf.ByteString getIndexBytes() {
      java.lang.Object ref = index_;
      if (ref instanceof java.lang.String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        index_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    private byte memoizedIsInitialized = -1;

    @java.lang.Override
    public final boolean isInitialized() {
      byte isInitialized = memoizedIsInitialized;
      if (isInitialized == 1) return true;
      if (isInitialized == 0) return false;

      memoizedIsInitialized = 1;
      return true;
    }

    @java.lang.Override
    public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(indexEndpoint_)) {
        com.google.protobuf.GeneratedMessageV3.writeString(output, 1, indexEndpoint_);
      }
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(index_)) {
        com.google.protobuf.GeneratedMessageV3.writeString(output, 2, index_);
      }
      getUnknownFields().writeTo(output);
    }

    @java.lang.Override
    public int getSerializedSize() {
      int size = memoizedSize;
      if (size != -1) return size;

      size = 0;
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(indexEndpoint_)) {
        size += com.google.protobuf.GeneratedMessageV3.computeStringSize(1, indexEndpoint_);
      }
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(index_)) {
        size += com.google.protobuf.GeneratedMessageV3.computeStringSize(2, index_);
      }
      size += getUnknownFields().getSerializedSize();
      memoizedSize = size;
      return size;
    }

    @java.lang.Override
    public boolean equals(final java.lang.Object obj) {
      if (obj == this) {
        return true;
      }
      if (!(obj instanceof com.google.cloud.aiplatform.v1.RagVectorDbConfig.VertexVectorSearch)) {
        return super.equals(obj);
      }
      com.google.cloud.aiplatform.v1.RagVectorDbConfig.VertexVectorSearch other =
          (com.google.cloud.aiplatform.v1.RagVectorDbConfig.VertexVectorSearch) obj;

      if (!getIndexEndpoint().equals(other.getIndexEndpoint())) return false;
      if (!getIndex().equals(other.getIndex())) return false;
      if (!getUnknownFields().equals(other.getUnknownFields())) return false;
      return true;
    }

    @java.lang.Override
    public int hashCode() {
      if (memoizedHashCode != 0) {
        return memoizedHashCode;
      }
      int hash = 41;
      hash = (19 * hash) + getDescriptor().hashCode();
      hash = (37 * hash) + INDEX_ENDPOINT_FIELD_NUMBER;
      hash = (53 * hash) + getIndexEndpoint().hashCode();
      hash = (37 * hash) + INDEX_FIELD_NUMBER;
      hash = (53 * hash) + getIndex().hashCode();
      hash = (29 * hash) + getUnknownFields().hashCode();
      memoizedHashCode = hash;
      return hash;
    }

    public static com.google.cloud.aiplatform.v1.RagVectorDbConfig.VertexVectorSearch parseFrom(
        java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.aiplatform.v1.RagVectorDbConfig.VertexVectorSearch parseFrom(
        java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.aiplatform.v1.RagVectorDbConfig.VertexVectorSearch parseFrom(
        com.google.protobuf.ByteString data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.aiplatform.v1.RagVectorDbConfig.VertexVectorSearch parseFrom(
        com.google.protobuf.ByteString data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.aiplatform.v1.RagVectorDbConfig.VertexVectorSearch parseFrom(
        byte[] data) throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.aiplatform.v1.RagVectorDbConfig.VertexVectorSearch parseFrom(
        byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.aiplatform.v1.RagVectorDbConfig.VertexVectorSearch parseFrom(
        java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.cloud.aiplatform.v1.RagVectorDbConfig.VertexVectorSearch parseFrom(
        java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.cloud.aiplatform.v1.RagVectorDbConfig.VertexVectorSearch
        parseDelimitedFrom(java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
    }

    public static com.google.cloud.aiplatform.v1.RagVectorDbConfig.VertexVectorSearch
        parseDelimitedFrom(
            java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.cloud.aiplatform.v1.RagVectorDbConfig.VertexVectorSearch parseFrom(
        com.google.protobuf.CodedInputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.cloud.aiplatform.v1.RagVectorDbConfig.VertexVectorSearch parseFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    @java.lang.Override
    public Builder newBuilderForType() {
      return newBuilder();
    }

    public static Builder newBuilder() {
      return DEFAULT_INSTANCE.toBuilder();
    }

    public static Builder newBuilder(
        com.google.cloud.aiplatform.v1.RagVectorDbConfig.VertexVectorSearch prototype) {
      return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }

    @java.lang.Override
    public Builder toBuilder() {
      return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
    }

    @java.lang.Override
    protected Builder newBuilderForType(
        com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      Builder builder = new Builder(parent);
      return builder;
    }

    /**
     *
     *
     * <pre>
     * The config for the Vertex Vector Search.
     * </pre>
     *
     * Protobuf type {@code google.cloud.aiplatform.v1.RagVectorDbConfig.VertexVectorSearch}
     */
    public static final class Builder
        extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
        implements
        // @@protoc_insertion_point(builder_implements:google.cloud.aiplatform.v1.RagVectorDbConfig.VertexVectorSearch)
        com.google.cloud.aiplatform.v1.RagVectorDbConfig.VertexVectorSearchOrBuilder {
      public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
        return com.google.cloud.aiplatform.v1.VertexRagDataProto
            .internal_static_google_cloud_aiplatform_v1_RagVectorDbConfig_VertexVectorSearch_descriptor;
      }

      @java.lang.Override
      protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return com.google.cloud.aiplatform.v1.VertexRagDataProto
            .internal_static_google_cloud_aiplatform_v1_RagVectorDbConfig_VertexVectorSearch_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                com.google.cloud.aiplatform.v1.RagVectorDbConfig.VertexVectorSearch.class,
                com.google.cloud.aiplatform.v1.RagVectorDbConfig.VertexVectorSearch.Builder.class);
      }

      // Construct using
      // com.google.cloud.aiplatform.v1.RagVectorDbConfig.VertexVectorSearch.newBuilder()
      private Builder() {}

      private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
        super(parent);
      }

      @java.lang.Override
      public Builder clear() {
        super.clear();
        bitField0_ = 0;
        indexEndpoint_ = "";
        index_ = "";
        return this;
      }

      @java.lang.Override
      public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
        return com.google.cloud.aiplatform.v1.VertexRagDataProto
            .internal_static_google_cloud_aiplatform_v1_RagVectorDbConfig_VertexVectorSearch_descriptor;
      }

      @java.lang.Override
      public com.google.cloud.aiplatform.v1.RagVectorDbConfig.VertexVectorSearch
          getDefaultInstanceForType() {
        return com.google.cloud.aiplatform.v1.RagVectorDbConfig.VertexVectorSearch
            .getDefaultInstance();
      }

      @java.lang.Override
      public com.google.cloud.aiplatform.v1.RagVectorDbConfig.VertexVectorSearch build() {
        com.google.cloud.aiplatform.v1.RagVectorDbConfig.VertexVectorSearch result = buildPartial();
        if (!result.isInitialized()) {
          throw newUninitializedMessageException(result);
        }
        return result;
      }

      @java.lang.Override
      public com.google.cloud.aiplatform.v1.RagVectorDbConfig.VertexVectorSearch buildPartial() {
        com.google.cloud.aiplatform.v1.RagVectorDbConfig.VertexVectorSearch result =
            new com.google.cloud.aiplatform.v1.RagVectorDbConfig.VertexVectorSearch(this);
        if (bitField0_ != 0) {
          buildPartial0(result);
        }
        onBuilt();
        return result;
      }

      private void buildPartial0(
          com.google.cloud.aiplatform.v1.RagVectorDbConfig.VertexVectorSearch result) {
        int from_bitField0_ = bitField0_;
        if (((from_bitField0_ & 0x00000001) != 0)) {
          result.indexEndpoint_ = indexEndpoint_;
        }
        if (((from_bitField0_ & 0x00000002) != 0)) {
          result.index_ = index_;
        }
      }

      @java.lang.Override
      public Builder clone() {
        return super.clone();
      }

      @java.lang.Override
      public Builder setField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.setField(field, value);
      }

      @java.lang.Override
      public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
        return super.clearField(field);
      }

      @java.lang.Override
      public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
        return super.clearOneof(oneof);
      }

      @java.lang.Override
      public Builder setRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          int index,
          java.lang.Object value) {
        return super.setRepeatedField(field, index, value);
      }

      @java.lang.Override
      public Builder addRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.addRepeatedField(field, value);
      }

      @java.lang.Override
      public Builder mergeFrom(com.google.protobuf.Message other) {
        if (other instanceof com.google.cloud.aiplatform.v1.RagVectorDbConfig.VertexVectorSearch) {
          return mergeFrom(
              (com.google.cloud.aiplatform.v1.RagVectorDbConfig.VertexVectorSearch) other);
        } else {
          super.mergeFrom(other);
          return this;
        }
      }

      public Builder mergeFrom(
          com.google.cloud.aiplatform.v1.RagVectorDbConfig.VertexVectorSearch other) {
        if (other
            == com.google.cloud.aiplatform.v1.RagVectorDbConfig.VertexVectorSearch
                .getDefaultInstance()) return this;
        if (!other.getIndexEndpoint().isEmpty()) {
          indexEndpoint_ = other.indexEndpoint_;
          bitField0_ |= 0x00000001;
          onChanged();
        }
        if (!other.getIndex().isEmpty()) {
          index_ = other.index_;
          bitField0_ |= 0x00000002;
          onChanged();
        }
        this.mergeUnknownFields(other.getUnknownFields());
        onChanged();
        return this;
      }

      @java.lang.Override
      public final boolean isInitialized() {
        return true;
      }

      @java.lang.Override
      public Builder mergeFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        if (extensionRegistry == null) {
          throw new java.lang.NullPointerException();
        }
        try {
          boolean done = false;
          while (!done) {
            int tag = input.readTag();
            switch (tag) {
              case 0:
                done = true;
                break;
              case 10:
                {
                  indexEndpoint_ = input.readStringRequireUtf8();
                  bitField0_ |= 0x00000001;
                  break;
                } // case 10
              case 18:
                {
                  index_ = input.readStringRequireUtf8();
                  bitField0_ |= 0x00000002;
                  break;
                } // case 18
              default:
                {
                  if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                    done = true; // was an endgroup tag
                  }
                  break;
                } // default:
            } // switch (tag)
          } // while (!done)
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          throw e.unwrapIOException();
        } finally {
          onChanged();
        } // finally
        return this;
      }

      private int bitField0_;

      private java.lang.Object indexEndpoint_ = "";

      /**
       *
       *
       * <pre>
       * The resource name of the Index Endpoint.
       * Format:
       * `projects/{project}/locations/{location}/indexEndpoints/{index_endpoint}`
       * </pre>
       *
       * <code>string index_endpoint = 1;</code>
       *
       * @return The indexEndpoint.
       */
      public java.lang.String getIndexEndpoint() {
        java.lang.Object ref = indexEndpoint_;
        if (!(ref instanceof java.lang.String)) {
          com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
          java.lang.String s = bs.toStringUtf8();
          indexEndpoint_ = s;
          return s;
        } else {
          return (java.lang.String) ref;
        }
      }

      /**
       *
       *
       * <pre>
       * The resource name of the Index Endpoint.
       * Format:
       * `projects/{project}/locations/{location}/indexEndpoints/{index_endpoint}`
       * </pre>
       *
       * <code>string index_endpoint = 1;</code>
       *
       * @return The bytes for indexEndpoint.
       */
      public com.google.protobuf.ByteString getIndexEndpointBytes() {
        java.lang.Object ref = indexEndpoint_;
        if (ref instanceof String) {
          com.google.protobuf.ByteString b =
              com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
          indexEndpoint_ = b;
          return b;
        } else {
          return (com.google.protobuf.ByteString) ref;
        }
      }

      /**
       *
       *
       * <pre>
       * The resource name of the Index Endpoint.
       * Format:
       * `projects/{project}/locations/{location}/indexEndpoints/{index_endpoint}`
       * </pre>
       *
       * <code>string index_endpoint = 1;</code>
       *
       * @param value The indexEndpoint to set.
       * @return This builder for chaining.
       */
      public Builder setIndexEndpoint(java.lang.String value) {
        if (value == null) {
          throw new NullPointerException();
        }
        indexEndpoint_ = value;
        bitField0_ |= 0x00000001;
        onChanged();
        return this;
      }

      /**
       *
       *
       * <pre>
       * The resource name of the Index Endpoint.
       * Format:
       * `projects/{project}/locations/{location}/indexEndpoints/{index_endpoint}`
       * </pre>
       *
       * <code>string index_endpoint = 1;</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearIndexEndpoint() {
        indexEndpoint_ = getDefaultInstance().getIndexEndpoint();
        bitField0_ = (bitField0_ & ~0x00000001);
        onChanged();
        return this;
      }

      /**
       *
       *
       * <pre>
       * The resource name of the Index Endpoint.
       * Format:
       * `projects/{project}/locations/{location}/indexEndpoints/{index_endpoint}`
       * </pre>
       *
       * <code>string index_endpoint = 1;</code>
       *
       * @param value The bytes for indexEndpoint to set.
       * @return This builder for chaining.
       */
      public Builder setIndexEndpointBytes(com.google.protobuf.ByteString value) {
        if (value == null) {
          throw new NullPointerException();
        }
        checkByteStringIsUtf8(value);
        indexEndpoint_ = value;
        bitField0_ |= 0x00000001;
        onChanged();
        return this;
      }

      private java.lang.Object index_ = "";

      /**
       *
       *
       * <pre>
       * The resource name of the Index.
       * Format:
       * `projects/{project}/locations/{location}/indexes/{index}`
       * </pre>
       *
       * <code>string index = 2;</code>
       *
       * @return The index.
       */
      public java.lang.String getIndex() {
        java.lang.Object ref = index_;
        if (!(ref instanceof java.lang.String)) {
          com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
          java.lang.String s = bs.toStringUtf8();
          index_ = s;
          return s;
        } else {
          return (java.lang.String) ref;
        }
      }

      /**
       *
       *
       * <pre>
       * The resource name of the Index.
       * Format:
       * `projects/{project}/locations/{location}/indexes/{index}`
       * </pre>
       *
       * <code>string index = 2;</code>
       *
       * @return The bytes for index.
       */
      public com.google.protobuf.ByteString getIndexBytes() {
        java.lang.Object ref = index_;
        if (ref instanceof String) {
          com.google.protobuf.ByteString b =
              com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
          index_ = b;
          return b;
        } else {
          return (com.google.protobuf.ByteString) ref;
        }
      }

      /**
       *
       *
       * <pre>
       * The resource name of the Index.
       * Format:
       * `projects/{project}/locations/{location}/indexes/{index}`
       * </pre>
       *
       * <code>string index = 2;</code>
       *
       * @param value The index to set.
       * @return This builder for chaining.
       */
      public Builder setIndex(java.lang.String value) {
        if (value == null) {
          throw new NullPointerException();
        }
        index_ = value;
        bitField0_ |= 0x00000002;
        onChanged();
        return this;
      }

      /**
       *
       *
       * <pre>
       * The resource name of the Index.
       * Format:
       * `projects/{project}/locations/{location}/indexes/{index}`
       * </pre>
       *
       * <code>string index = 2;</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearIndex() {
        index_ = getDefaultInstance().getIndex();
        bitField0_ = (bitField0_ & ~0x00000002);
        onChanged();
        return this;
      }

      /**
       *
       *
       * <pre>
       * The resource name of the Index.
       * Format:
       * `projects/{project}/locations/{location}/indexes/{index}`
       * </pre>
       *
       * <code>string index = 2;</code>
       *
       * @param value The bytes for index to set.
       * @return This builder for chaining.
       */
      public Builder setIndexBytes(com.google.protobuf.ByteString value) {
        if (value == null) {
          throw new NullPointerException();
        }
        checkByteStringIsUtf8(value);
        index_ = value;
        bitField0_ |= 0x00000002;
        onChanged();
        return this;
      }

      @java.lang.Override
      public final Builder setUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.setUnknownFields(unknownFields);
      }

      @java.lang.Override
      public final Builder mergeUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.mergeUnknownFields(unknownFields);
      }

      // @@protoc_insertion_point(builder_scope:google.cloud.aiplatform.v1.RagVectorDbConfig.VertexVectorSearch)
    }

    // @@protoc_insertion_point(class_scope:google.cloud.aiplatform.v1.RagVectorDbConfig.VertexVectorSearch)
    private static final com.google.cloud.aiplatform.v1.RagVectorDbConfig.VertexVectorSearch
        DEFAULT_INSTANCE;

    static {
      DEFAULT_INSTANCE = new com.google.cloud.aiplatform.v1.RagVectorDbConfig.VertexVectorSearch();
    }

    public static com.google.cloud.aiplatform.v1.RagVectorDbConfig.VertexVectorSearch
        getDefaultInstance() {
      return DEFAULT_INSTANCE;
    }

    private static final com.google.protobuf.Parser<VertexVectorSearch> PARSER =
        new com.google.protobuf.AbstractParser<VertexVectorSearch>() {
          @java.lang.Override
          public VertexVectorSearch parsePartialFrom(
              com.google.protobuf.CodedInputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
            Builder builder = newBuilder();
            try {
              builder.mergeFrom(input, extensionRegistry);
            } catch (com.google.protobuf.InvalidProtocolBufferException e) {
              throw e.setUnfinishedMessage(builder.buildPartial());
            } catch (com.google.protobuf.UninitializedMessageException e) {
              throw e.asInvalidProtocolBufferException()
                  .setUnfinishedMessage(builder.buildPartial());
            } catch (java.io.IOException e) {
              throw new com.google.protobuf.InvalidProtocolBufferException(e)
                  .setUnfinishedMessage(builder.buildPartial());
            }
            return builder.buildPartial();
          }
        };

    public static com.google.protobuf.Parser<VertexVectorSearch> parser() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.protobuf.Parser<VertexVectorSearch> getParserForType() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.cloud.aiplatform.v1.RagVectorDbConfig.VertexVectorSearch
        getDefaultInstanceForType() {
      return DEFAULT_INSTANCE;
    }
  }

  private int bitField0_;
  private int vectorDbCase_ = 0;

  @SuppressWarnings("serial")
  private java.lang.Object vectorDb_;

  public enum VectorDbCase
      implements
          com.google.protobuf.Internal.EnumLite,
          com.google.protobuf.AbstractMessage.InternalOneOfEnum {
    RAG_MANAGED_DB(1),
    PINECONE(3),
    VERTEX_VECTOR_SEARCH(6),
    VECTORDB_NOT_SET(0);
    private final int value;

    private VectorDbCase(int value) {
      this.value = value;
    }

    /**
     * @param value The number of the enum to look for.
     * @return The enum associated with the given number.
     * @deprecated Use {@link #forNumber(int)} instead.
     */
    @java.lang.Deprecated
    public static VectorDbCase valueOf(int value) {
      return forNumber(value);
    }

    public static VectorDbCase forNumber(int value) {
      switch (value) {
        case 1:
          return RAG_MANAGED_DB;
        case 3:
          return PINECONE;
        case 6:
          return VERTEX_VECTOR_SEARCH;
        case 0:
          return VECTORDB_NOT_SET;
        default:
          return null;
      }
    }

    public int getNumber() {
      return this.value;
    }
  };

  public VectorDbCase getVectorDbCase() {
    return VectorDbCase.forNumber(vectorDbCase_);
  }

  public static final int RAG_MANAGED_DB_FIELD_NUMBER = 1;

  /**
   *
   *
   * <pre>
   * The config for the RAG-managed Vector DB.
   * </pre>
   *
   * <code>.google.cloud.aiplatform.v1.RagVectorDbConfig.RagManagedDb rag_managed_db = 1;</code>
   *
   * @return Whether the ragManagedDb field is set.
   */
  @java.lang.Override
  public boolean hasRagManagedDb() {
    return vectorDbCase_ == 1;
  }

  /**
   *
   *
   * <pre>
   * The config for the RAG-managed Vector DB.
   * </pre>
   *
   * <code>.google.cloud.aiplatform.v1.RagVectorDbConfig.RagManagedDb rag_managed_db = 1;</code>
   *
   * @return The ragManagedDb.
   */
  @java.lang.Override
  public com.google.cloud.aiplatform.v1.RagVectorDbConfig.RagManagedDb getRagManagedDb() {
    if (vectorDbCase_ == 1) {
      return (com.google.cloud.aiplatform.v1.RagVectorDbConfig.RagManagedDb) vectorDb_;
    }
    return com.google.cloud.aiplatform.v1.RagVectorDbConfig.RagManagedDb.getDefaultInstance();
  }

  /**
   *
   *
   * <pre>
   * The config for the RAG-managed Vector DB.
   * </pre>
   *
   * <code>.google.cloud.aiplatform.v1.RagVectorDbConfig.RagManagedDb rag_managed_db = 1;</code>
   */
  @java.lang.Override
  public com.google.cloud.aiplatform.v1.RagVectorDbConfig.RagManagedDbOrBuilder
      getRagManagedDbOrBuilder() {
    if (vectorDbCase_ == 1) {
      return (com.google.cloud.aiplatform.v1.RagVectorDbConfig.RagManagedDb) vectorDb_;
    }
    return com.google.cloud.aiplatform.v1.RagVectorDbConfig.RagManagedDb.getDefaultInstance();
  }

  public static final int PINECONE_FIELD_NUMBER = 3;

  /**
   *
   *
   * <pre>
   * The config for the Pinecone.
   * </pre>
   *
   * <code>.google.cloud.aiplatform.v1.RagVectorDbConfig.Pinecone pinecone = 3;</code>
   *
   * @return Whether the pinecone field is set.
   */
  @java.lang.Override
  public boolean hasPinecone() {
    return vectorDbCase_ == 3;
  }

  /**
   *
   *
   * <pre>
   * The config for the Pinecone.
   * </pre>
   *
   * <code>.google.cloud.aiplatform.v1.RagVectorDbConfig.Pinecone pinecone = 3;</code>
   *
   * @return The pinecone.
   */
  @java.lang.Override
  public com.google.cloud.aiplatform.v1.RagVectorDbConfig.Pinecone getPinecone() {
    if (vectorDbCase_ == 3) {
      return (com.google.cloud.aiplatform.v1.RagVectorDbConfig.Pinecone) vectorDb_;
    }
    return com.google.cloud.aiplatform.v1.RagVectorDbConfig.Pinecone.getDefaultInstance();
  }

  /**
   *
   *
   * <pre>
   * The config for the Pinecone.
   * </pre>
   *
   * <code>.google.cloud.aiplatform.v1.RagVectorDbConfig.Pinecone pinecone = 3;</code>
   */
  @java.lang.Override
  public com.google.cloud.aiplatform.v1.RagVectorDbConfig.PineconeOrBuilder getPineconeOrBuilder() {
    if (vectorDbCase_ == 3) {
      return (com.google.cloud.aiplatform.v1.RagVectorDbConfig.Pinecone) vectorDb_;
    }
    return com.google.cloud.aiplatform.v1.RagVectorDbConfig.Pinecone.getDefaultInstance();
  }

  public static final int VERTEX_VECTOR_SEARCH_FIELD_NUMBER = 6;

  /**
   *
   *
   * <pre>
   * The config for the Vertex Vector Search.
   * </pre>
   *
   * <code>
   * .google.cloud.aiplatform.v1.RagVectorDbConfig.VertexVectorSearch vertex_vector_search = 6;
   * </code>
   *
   * @return Whether the vertexVectorSearch field is set.
   */
  @java.lang.Override
  public boolean hasVertexVectorSearch() {
    return vectorDbCase_ == 6;
  }

  /**
   *
   *
   * <pre>
   * The config for the Vertex Vector Search.
   * </pre>
   *
   * <code>
   * .google.cloud.aiplatform.v1.RagVectorDbConfig.VertexVectorSearch vertex_vector_search = 6;
   * </code>
   *
   * @return The vertexVectorSearch.
   */
  @java.lang.Override
  public com.google.cloud.aiplatform.v1.RagVectorDbConfig.VertexVectorSearch
      getVertexVectorSearch() {
    if (vectorDbCase_ == 6) {
      return (com.google.cloud.aiplatform.v1.RagVectorDbConfig.VertexVectorSearch) vectorDb_;
    }
    return com.google.cloud.aiplatform.v1.RagVectorDbConfig.VertexVectorSearch.getDefaultInstance();
  }

  /**
   *
   *
   * <pre>
   * The config for the Vertex Vector Search.
   * </pre>
   *
   * <code>
   * .google.cloud.aiplatform.v1.RagVectorDbConfig.VertexVectorSearch vertex_vector_search = 6;
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.aiplatform.v1.RagVectorDbConfig.VertexVectorSearchOrBuilder
      getVertexVectorSearchOrBuilder() {
    if (vectorDbCase_ == 6) {
      return (com.google.cloud.aiplatform.v1.RagVectorDbConfig.VertexVectorSearch) vectorDb_;
    }
    return com.google.cloud.aiplatform.v1.RagVectorDbConfig.VertexVectorSearch.getDefaultInstance();
  }

  public static final int API_AUTH_FIELD_NUMBER = 5;
  private com.google.cloud.aiplatform.v1.ApiAuth apiAuth_;

  /**
   *
   *
   * <pre>
   * Authentication config for the chosen Vector DB.
   * </pre>
   *
   * <code>.google.cloud.aiplatform.v1.ApiAuth api_auth = 5;</code>
   *
   * @return Whether the apiAuth field is set.
   */
  @java.lang.Override
  public boolean hasApiAuth() {
    return ((bitField0_ & 0x00000001) != 0);
  }

  /**
   *
   *
   * <pre>
   * Authentication config for the chosen Vector DB.
   * </pre>
   *
   * <code>.google.cloud.aiplatform.v1.ApiAuth api_auth = 5;</code>
   *
   * @return The apiAuth.
   */
  @java.lang.Override
  public com.google.cloud.aiplatform.v1.ApiAuth getApiAuth() {
    return apiAuth_ == null
        ? com.google.cloud.aiplatform.v1.ApiAuth.getDefaultInstance()
        : apiAuth_;
  }

  /**
   *
   *
   * <pre>
   * Authentication config for the chosen Vector DB.
   * </pre>
   *
   * <code>.google.cloud.aiplatform.v1.ApiAuth api_auth = 5;</code>
   */
  @java.lang.Override
  public com.google.cloud.aiplatform.v1.ApiAuthOrBuilder getApiAuthOrBuilder() {
    return apiAuth_ == null
        ? com.google.cloud.aiplatform.v1.ApiAuth.getDefaultInstance()
        : apiAuth_;
  }

  public static final int RAG_EMBEDDING_MODEL_CONFIG_FIELD_NUMBER = 7;
  private com.google.cloud.aiplatform.v1.RagEmbeddingModelConfig ragEmbeddingModelConfig_;

  /**
   *
   *
   * <pre>
   * Optional. Immutable. The embedding model config of the Vector DB.
   * </pre>
   *
   * <code>
   * .google.cloud.aiplatform.v1.RagEmbeddingModelConfig rag_embedding_model_config = 7 [(.google.api.field_behavior) = OPTIONAL, (.google.api.field_behavior) = IMMUTABLE];
   * </code>
   *
   * @return Whether the ragEmbeddingModelConfig field is set.
   */
  @java.lang.Override
  public boolean hasRagEmbeddingModelConfig() {
    return ((bitField0_ & 0x00000002) != 0);
  }

  /**
   *
   *
   * <pre>
   * Optional. Immutable. The embedding model config of the Vector DB.
   * </pre>
   *
   * <code>
   * .google.cloud.aiplatform.v1.RagEmbeddingModelConfig rag_embedding_model_config = 7 [(.google.api.field_behavior) = OPTIONAL, (.google.api.field_behavior) = IMMUTABLE];
   * </code>
   *
   * @return The ragEmbeddingModelConfig.
   */
  @java.lang.Override
  public com.google.cloud.aiplatform.v1.RagEmbeddingModelConfig getRagEmbeddingModelConfig() {
    return ragEmbeddingModelConfig_ == null
        ? com.google.cloud.aiplatform.v1.RagEmbeddingModelConfig.getDefaultInstance()
        : ragEmbeddingModelConfig_;
  }

  /**
   *
   *
   * <pre>
   * Optional. Immutable. The embedding model config of the Vector DB.
   * </pre>
   *
   * <code>
   * .google.cloud.aiplatform.v1.RagEmbeddingModelConfig rag_embedding_model_config = 7 [(.google.api.field_behavior) = OPTIONAL, (.google.api.field_behavior) = IMMUTABLE];
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.aiplatform.v1.RagEmbeddingModelConfigOrBuilder
      getRagEmbeddingModelConfigOrBuilder() {
    return ragEmbeddingModelConfig_ == null
        ? com.google.cloud.aiplatform.v1.RagEmbeddingModelConfig.getDefaultInstance()
        : ragEmbeddingModelConfig_;
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    if (vectorDbCase_ == 1) {
      output.writeMessage(
          1, (com.google.cloud.aiplatform.v1.RagVectorDbConfig.RagManagedDb) vectorDb_);
    }
    if (vectorDbCase_ == 3) {
      output.writeMessage(3, (com.google.cloud.aiplatform.v1.RagVectorDbConfig.Pinecone) vectorDb_);
    }
    if (((bitField0_ & 0x00000001) != 0)) {
      output.writeMessage(5, getApiAuth());
    }
    if (vectorDbCase_ == 6) {
      output.writeMessage(
          6, (com.google.cloud.aiplatform.v1.RagVectorDbConfig.VertexVectorSearch) vectorDb_);
    }
    if (((bitField0_ & 0x00000002) != 0)) {
      output.writeMessage(7, getRagEmbeddingModelConfig());
    }
    getUnknownFields().writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    if (vectorDbCase_ == 1) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(
              1, (com.google.cloud.aiplatform.v1.RagVectorDbConfig.RagManagedDb) vectorDb_);
    }
    if (vectorDbCase_ == 3) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(
              3, (com.google.cloud.aiplatform.v1.RagVectorDbConfig.Pinecone) vectorDb_);
    }
    if (((bitField0_ & 0x00000001) != 0)) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(5, getApiAuth());
    }
    if (vectorDbCase_ == 6) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(
              6, (com.google.cloud.aiplatform.v1.RagVectorDbConfig.VertexVectorSearch) vectorDb_);
    }
    if (((bitField0_ & 0x00000002) != 0)) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(7, getRagEmbeddingModelConfig());
    }
    size += getUnknownFields().getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.cloud.aiplatform.v1.RagVectorDbConfig)) {
      return super.equals(obj);
    }
    com.google.cloud.aiplatform.v1.RagVectorDbConfig other =
        (com.google.cloud.aiplatform.v1.RagVectorDbConfig) obj;

    if (hasApiAuth() != other.hasApiAuth()) return false;
    if (hasApiAuth()) {
      if (!getApiAuth().equals(other.getApiAuth())) return false;
    }
    if (hasRagEmbeddingModelConfig() != other.hasRagEmbeddingModelConfig()) return false;
    if (hasRagEmbeddingModelConfig()) {
      if (!getRagEmbeddingModelConfig().equals(other.getRagEmbeddingModelConfig())) return false;
    }
    if (!getVectorDbCase().equals(other.getVectorDbCase())) return false;
    switch (vectorDbCase_) {
      case 1:
        if (!getRagManagedDb().equals(other.getRagManagedDb())) return false;
        break;
      case 3:
        if (!getPinecone().equals(other.getPinecone())) return false;
        break;
      case 6:
        if (!getVertexVectorSearch().equals(other.getVertexVectorSearch())) return false;
        break;
      case 0:
      default:
    }
    if (!getUnknownFields().equals(other.getUnknownFields())) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    if (hasApiAuth()) {
      hash = (37 * hash) + API_AUTH_FIELD_NUMBER;
      hash = (53 * hash) + getApiAuth().hashCode();
    }
    if (hasRagEmbeddingModelConfig()) {
      hash = (37 * hash) + RAG_EMBEDDING_MODEL_CONFIG_FIELD_NUMBER;
      hash = (53 * hash) + getRagEmbeddingModelConfig().hashCode();
    }
    switch (vectorDbCase_) {
      case 1:
        hash = (37 * hash) + RAG_MANAGED_DB_FIELD_NUMBER;
        hash = (53 * hash) + getRagManagedDb().hashCode();
        break;
      case 3:
        hash = (37 * hash) + PINECONE_FIELD_NUMBER;
        hash = (53 * hash) + getPinecone().hashCode();
        break;
      case 6:
        hash = (37 * hash) + VERTEX_VECTOR_SEARCH_FIELD_NUMBER;
        hash = (53 * hash) + getVertexVectorSearch().hashCode();
        break;
      case 0:
      default:
    }
    hash = (29 * hash) + getUnknownFields().hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.cloud.aiplatform.v1.RagVectorDbConfig parseFrom(java.nio.ByteBuffer data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.aiplatform.v1.RagVectorDbConfig parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.aiplatform.v1.RagVectorDbConfig parseFrom(
      com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.aiplatform.v1.RagVectorDbConfig parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.aiplatform.v1.RagVectorDbConfig parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.aiplatform.v1.RagVectorDbConfig parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.aiplatform.v1.RagVectorDbConfig parseFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.aiplatform.v1.RagVectorDbConfig parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.aiplatform.v1.RagVectorDbConfig parseDelimitedFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.cloud.aiplatform.v1.RagVectorDbConfig parseDelimitedFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.aiplatform.v1.RagVectorDbConfig parseFrom(
      com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.aiplatform.v1.RagVectorDbConfig parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(com.google.cloud.aiplatform.v1.RagVectorDbConfig prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }

  /**
   *
   *
   * <pre>
   * Config for the Vector DB to use for RAG.
   * </pre>
   *
   * Protobuf type {@code google.cloud.aiplatform.v1.RagVectorDbConfig}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.cloud.aiplatform.v1.RagVectorDbConfig)
      com.google.cloud.aiplatform.v1.RagVectorDbConfigOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.aiplatform.v1.VertexRagDataProto
          .internal_static_google_cloud_aiplatform_v1_RagVectorDbConfig_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.aiplatform.v1.VertexRagDataProto
          .internal_static_google_cloud_aiplatform_v1_RagVectorDbConfig_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.aiplatform.v1.RagVectorDbConfig.class,
              com.google.cloud.aiplatform.v1.RagVectorDbConfig.Builder.class);
    }

    // Construct using com.google.cloud.aiplatform.v1.RagVectorDbConfig.newBuilder()
    private Builder() {
      maybeForceBuilderInitialization();
    }

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
      maybeForceBuilderInitialization();
    }

    private void maybeForceBuilderInitialization() {
      if (com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders) {
        getApiAuthFieldBuilder();
        getRagEmbeddingModelConfigFieldBuilder();
      }
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      bitField0_ = 0;
      if (ragManagedDbBuilder_ != null) {
        ragManagedDbBuilder_.clear();
      }
      if (pineconeBuilder_ != null) {
        pineconeBuilder_.clear();
      }
      if (vertexVectorSearchBuilder_ != null) {
        vertexVectorSearchBuilder_.clear();
      }
      apiAuth_ = null;
      if (apiAuthBuilder_ != null) {
        apiAuthBuilder_.dispose();
        apiAuthBuilder_ = null;
      }
      ragEmbeddingModelConfig_ = null;
      if (ragEmbeddingModelConfigBuilder_ != null) {
        ragEmbeddingModelConfigBuilder_.dispose();
        ragEmbeddingModelConfigBuilder_ = null;
      }
      vectorDbCase_ = 0;
      vectorDb_ = null;
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.cloud.aiplatform.v1.VertexRagDataProto
          .internal_static_google_cloud_aiplatform_v1_RagVectorDbConfig_descriptor;
    }

    @java.lang.Override
    public com.google.cloud.aiplatform.v1.RagVectorDbConfig getDefaultInstanceForType() {
      return com.google.cloud.aiplatform.v1.RagVectorDbConfig.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.cloud.aiplatform.v1.RagVectorDbConfig build() {
      com.google.cloud.aiplatform.v1.RagVectorDbConfig result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.cloud.aiplatform.v1.RagVectorDbConfig buildPartial() {
      com.google.cloud.aiplatform.v1.RagVectorDbConfig result =
          new com.google.cloud.aiplatform.v1.RagVectorDbConfig(this);
      if (bitField0_ != 0) {
        buildPartial0(result);
      }
      buildPartialOneofs(result);
      onBuilt();
      return result;
    }

    private void buildPartial0(com.google.cloud.aiplatform.v1.RagVectorDbConfig result) {
      int from_bitField0_ = bitField0_;
      int to_bitField0_ = 0;
      if (((from_bitField0_ & 0x00000008) != 0)) {
        result.apiAuth_ = apiAuthBuilder_ == null ? apiAuth_ : apiAuthBuilder_.build();
        to_bitField0_ |= 0x00000001;
      }
      if (((from_bitField0_ & 0x00000010) != 0)) {
        result.ragEmbeddingModelConfig_ =
            ragEmbeddingModelConfigBuilder_ == null
                ? ragEmbeddingModelConfig_
                : ragEmbeddingModelConfigBuilder_.build();
        to_bitField0_ |= 0x00000002;
      }
      result.bitField0_ |= to_bitField0_;
    }

    private void buildPartialOneofs(com.google.cloud.aiplatform.v1.RagVectorDbConfig result) {
      result.vectorDbCase_ = vectorDbCase_;
      result.vectorDb_ = this.vectorDb_;
      if (vectorDbCase_ == 1 && ragManagedDbBuilder_ != null) {
        result.vectorDb_ = ragManagedDbBuilder_.build();
      }
      if (vectorDbCase_ == 3 && pineconeBuilder_ != null) {
        result.vectorDb_ = pineconeBuilder_.build();
      }
      if (vectorDbCase_ == 6 && vertexVectorSearchBuilder_ != null) {
        result.vectorDb_ = vertexVectorSearchBuilder_.build();
      }
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.cloud.aiplatform.v1.RagVectorDbConfig) {
        return mergeFrom((com.google.cloud.aiplatform.v1.RagVectorDbConfig) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(com.google.cloud.aiplatform.v1.RagVectorDbConfig other) {
      if (other == com.google.cloud.aiplatform.v1.RagVectorDbConfig.getDefaultInstance())
        return this;
      if (other.hasApiAuth()) {
        mergeApiAuth(other.getApiAuth());
      }
      if (other.hasRagEmbeddingModelConfig()) {
        mergeRagEmbeddingModelConfig(other.getRagEmbeddingModelConfig());
      }
      switch (other.getVectorDbCase()) {
        case RAG_MANAGED_DB:
          {
            mergeRagManagedDb(other.getRagManagedDb());
            break;
          }
        case PINECONE:
          {
            mergePinecone(other.getPinecone());
            break;
          }
        case VERTEX_VECTOR_SEARCH:
          {
            mergeVertexVectorSearch(other.getVertexVectorSearch());
            break;
          }
        case VECTORDB_NOT_SET:
          {
            break;
          }
      }
      this.mergeUnknownFields(other.getUnknownFields());
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 10:
              {
                input.readMessage(getRagManagedDbFieldBuilder().getBuilder(), extensionRegistry);
                vectorDbCase_ = 1;
                break;
              } // case 10
            case 26:
              {
                input.readMessage(getPineconeFieldBuilder().getBuilder(), extensionRegistry);
                vectorDbCase_ = 3;
                break;
              } // case 26
            case 42:
              {
                input.readMessage(getApiAuthFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000008;
                break;
              } // case 42
            case 50:
              {
                input.readMessage(
                    getVertexVectorSearchFieldBuilder().getBuilder(), extensionRegistry);
                vectorDbCase_ = 6;
                break;
              } // case 50
            case 58:
              {
                input.readMessage(
                    getRagEmbeddingModelConfigFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000010;
                break;
              } // case 58
            default:
              {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
          } // switch (tag)
        } // while (!done)
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.unwrapIOException();
      } finally {
        onChanged();
      } // finally
      return this;
    }

    private int vectorDbCase_ = 0;
    private java.lang.Object vectorDb_;

    public VectorDbCase getVectorDbCase() {
      return VectorDbCase.forNumber(vectorDbCase_);
    }

    public Builder clearVectorDb() {
      vectorDbCase_ = 0;
      vectorDb_ = null;
      onChanged();
      return this;
    }

    private int bitField0_;

    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.aiplatform.v1.RagVectorDbConfig.RagManagedDb,
            com.google.cloud.aiplatform.v1.RagVectorDbConfig.RagManagedDb.Builder,
            com.google.cloud.aiplatform.v1.RagVectorDbConfig.RagManagedDbOrBuilder>
        ragManagedDbBuilder_;

    /**
     *
     *
     * <pre>
     * The config for the RAG-managed Vector DB.
     * </pre>
     *
     * <code>.google.cloud.aiplatform.v1.RagVectorDbConfig.RagManagedDb rag_managed_db = 1;</code>
     *
     * @return Whether the ragManagedDb field is set.
     */
    @java.lang.Override
    public boolean hasRagManagedDb() {
      return vectorDbCase_ == 1;
    }

    /**
     *
     *
     * <pre>
     * The config for the RAG-managed Vector DB.
     * </pre>
     *
     * <code>.google.cloud.aiplatform.v1.RagVectorDbConfig.RagManagedDb rag_managed_db = 1;</code>
     *
     * @return The ragManagedDb.
     */
    @java.lang.Override
    public com.google.cloud.aiplatform.v1.RagVectorDbConfig.RagManagedDb getRagManagedDb() {
      if (ragManagedDbBuilder_ == null) {
        if (vectorDbCase_ == 1) {
          return (com.google.cloud.aiplatform.v1.RagVectorDbConfig.RagManagedDb) vectorDb_;
        }
        return com.google.cloud.aiplatform.v1.RagVectorDbConfig.RagManagedDb.getDefaultInstance();
      } else {
        if (vectorDbCase_ == 1) {
          return ragManagedDbBuilder_.getMessage();
        }
        return com.google.cloud.aiplatform.v1.RagVectorDbConfig.RagManagedDb.getDefaultInstance();
      }
    }

    /**
     *
     *
     * <pre>
     * The config for the RAG-managed Vector DB.
     * </pre>
     *
     * <code>.google.cloud.aiplatform.v1.RagVectorDbConfig.RagManagedDb rag_managed_db = 1;</code>
     */
    public Builder setRagManagedDb(
        com.google.cloud.aiplatform.v1.RagVectorDbConfig.RagManagedDb value) {
      if (ragManagedDbBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        vectorDb_ = value;
        onChanged();
      } else {
        ragManagedDbBuilder_.setMessage(value);
      }
      vectorDbCase_ = 1;
      return this;
    }

    /**
     *
     *
     * <pre>
     * The config for the RAG-managed Vector DB.
     * </pre>
     *
     * <code>.google.cloud.aiplatform.v1.RagVectorDbConfig.RagManagedDb rag_managed_db = 1;</code>
     */
    public Builder setRagManagedDb(
        com.google.cloud.aiplatform.v1.RagVectorDbConfig.RagManagedDb.Builder builderForValue) {
      if (ragManagedDbBuilder_ == null) {
        vectorDb_ = builderForValue.build();
        onChanged();
      } else {
        ragManagedDbBuilder_.setMessage(builderForValue.build());
      }
      vectorDbCase_ = 1;
      return this;
    }

    /**
     *
     *
     * <pre>
     * The config for the RAG-managed Vector DB.
     * </pre>
     *
     * <code>.google.cloud.aiplatform.v1.RagVectorDbConfig.RagManagedDb rag_managed_db = 1;</code>
     */
    public Builder mergeRagManagedDb(
        com.google.cloud.aiplatform.v1.RagVectorDbConfig.RagManagedDb value) {
      if (ragManagedDbBuilder_ == null) {
        if (vectorDbCase_ == 1
            && vectorDb_
                != com.google.cloud.aiplatform.v1.RagVectorDbConfig.RagManagedDb
                    .getDefaultInstance()) {
          vectorDb_ =
              com.google.cloud.aiplatform.v1.RagVectorDbConfig.RagManagedDb.newBuilder(
                      (com.google.cloud.aiplatform.v1.RagVectorDbConfig.RagManagedDb) vectorDb_)
                  .mergeFrom(value)
                  .buildPartial();
        } else {
          vectorDb_ = value;
        }
        onChanged();
      } else {
        if (vectorDbCase_ == 1) {
          ragManagedDbBuilder_.mergeFrom(value);
        } else {
          ragManagedDbBuilder_.setMessage(value);
        }
      }
      vectorDbCase_ = 1;
      return this;
    }

    /**
     *
     *
     * <pre>
     * The config for the RAG-managed Vector DB.
     * </pre>
     *
     * <code>.google.cloud.aiplatform.v1.RagVectorDbConfig.RagManagedDb rag_managed_db = 1;</code>
     */
    public Builder clearRagManagedDb() {
      if (ragManagedDbBuilder_ == null) {
        if (vectorDbCase_ == 1) {
          vectorDbCase_ = 0;
          vectorDb_ = null;
          onChanged();
        }
      } else {
        if (vectorDbCase_ == 1) {
          vectorDbCase_ = 0;
          vectorDb_ = null;
        }
        ragManagedDbBuilder_.clear();
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * The config for the RAG-managed Vector DB.
     * </pre>
     *
     * <code>.google.cloud.aiplatform.v1.RagVectorDbConfig.RagManagedDb rag_managed_db = 1;</code>
     */
    public com.google.cloud.aiplatform.v1.RagVectorDbConfig.RagManagedDb.Builder
        getRagManagedDbBuilder() {
      return getRagManagedDbFieldBuilder().getBuilder();
    }

    /**
     *
     *
     * <pre>
     * The config for the RAG-managed Vector DB.
     * </pre>
     *
     * <code>.google.cloud.aiplatform.v1.RagVectorDbConfig.RagManagedDb rag_managed_db = 1;</code>
     */
    @java.lang.Override
    public com.google.cloud.aiplatform.v1.RagVectorDbConfig.RagManagedDbOrBuilder
        getRagManagedDbOrBuilder() {
      if ((vectorDbCase_ == 1) && (ragManagedDbBuilder_ != null)) {
        return ragManagedDbBuilder_.getMessageOrBuilder();
      } else {
        if (vectorDbCase_ == 1) {
          return (com.google.cloud.aiplatform.v1.RagVectorDbConfig.RagManagedDb) vectorDb_;
        }
        return com.google.cloud.aiplatform.v1.RagVectorDbConfig.RagManagedDb.getDefaultInstance();
      }
    }

    /**
     *
     *
     * <pre>
     * The config for the RAG-managed Vector DB.
     * </pre>
     *
     * <code>.google.cloud.aiplatform.v1.RagVectorDbConfig.RagManagedDb rag_managed_db = 1;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.aiplatform.v1.RagVectorDbConfig.RagManagedDb,
            com.google.cloud.aiplatform.v1.RagVectorDbConfig.RagManagedDb.Builder,
            com.google.cloud.aiplatform.v1.RagVectorDbConfig.RagManagedDbOrBuilder>
        getRagManagedDbFieldBuilder() {
      if (ragManagedDbBuilder_ == null) {
        if (!(vectorDbCase_ == 1)) {
          vectorDb_ =
              com.google.cloud.aiplatform.v1.RagVectorDbConfig.RagManagedDb.getDefaultInstance();
        }
        ragManagedDbBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.aiplatform.v1.RagVectorDbConfig.RagManagedDb,
                com.google.cloud.aiplatform.v1.RagVectorDbConfig.RagManagedDb.Builder,
                com.google.cloud.aiplatform.v1.RagVectorDbConfig.RagManagedDbOrBuilder>(
                (com.google.cloud.aiplatform.v1.RagVectorDbConfig.RagManagedDb) vectorDb_,
                getParentForChildren(),
                isClean());
        vectorDb_ = null;
      }
      vectorDbCase_ = 1;
      onChanged();
      return ragManagedDbBuilder_;
    }

    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.aiplatform.v1.RagVectorDbConfig.Pinecone,
            com.google.cloud.aiplatform.v1.RagVectorDbConfig.Pinecone.Builder,
            com.google.cloud.aiplatform.v1.RagVectorDbConfig.PineconeOrBuilder>
        pineconeBuilder_;

    /**
     *
     *
     * <pre>
     * The config for the Pinecone.
     * </pre>
     *
     * <code>.google.cloud.aiplatform.v1.RagVectorDbConfig.Pinecone pinecone = 3;</code>
     *
     * @return Whether the pinecone field is set.
     */
    @java.lang.Override
    public boolean hasPinecone() {
      return vectorDbCase_ == 3;
    }

    /**
     *
     *
     * <pre>
     * The config for the Pinecone.
     * </pre>
     *
     * <code>.google.cloud.aiplatform.v1.RagVectorDbConfig.Pinecone pinecone = 3;</code>
     *
     * @return The pinecone.
     */
    @java.lang.Override
    public com.google.cloud.aiplatform.v1.RagVectorDbConfig.Pinecone getPinecone() {
      if (pineconeBuilder_ == null) {
        if (vectorDbCase_ == 3) {
          return (com.google.cloud.aiplatform.v1.RagVectorDbConfig.Pinecone) vectorDb_;
        }
        return com.google.cloud.aiplatform.v1.RagVectorDbConfig.Pinecone.getDefaultInstance();
      } else {
        if (vectorDbCase_ == 3) {
          return pineconeBuilder_.getMessage();
        }
        return com.google.cloud.aiplatform.v1.RagVectorDbConfig.Pinecone.getDefaultInstance();
      }
    }

    /**
     *
     *
     * <pre>
     * The config for the Pinecone.
     * </pre>
     *
     * <code>.google.cloud.aiplatform.v1.RagVectorDbConfig.Pinecone pinecone = 3;</code>
     */
    public Builder setPinecone(com.google.cloud.aiplatform.v1.RagVectorDbConfig.Pinecone value) {
      if (pineconeBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        vectorDb_ = value;
        onChanged();
      } else {
        pineconeBuilder_.setMessage(value);
      }
      vectorDbCase_ = 3;
      return this;
    }

    /**
     *
     *
     * <pre>
     * The config for the Pinecone.
     * </pre>
     *
     * <code>.google.cloud.aiplatform.v1.RagVectorDbConfig.Pinecone pinecone = 3;</code>
     */
    public Builder setPinecone(
        com.google.cloud.aiplatform.v1.RagVectorDbConfig.Pinecone.Builder builderForValue) {
      if (pineconeBuilder_ == null) {
        vectorDb_ = builderForValue.build();
        onChanged();
      } else {
        pineconeBuilder_.setMessage(builderForValue.build());
      }
      vectorDbCase_ = 3;
      return this;
    }

    /**
     *
     *
     * <pre>
     * The config for the Pinecone.
     * </pre>
     *
     * <code>.google.cloud.aiplatform.v1.RagVectorDbConfig.Pinecone pinecone = 3;</code>
     */
    public Builder mergePinecone(com.google.cloud.aiplatform.v1.RagVectorDbConfig.Pinecone value) {
      if (pineconeBuilder_ == null) {
        if (vectorDbCase_ == 3
            && vectorDb_
                != com.google.cloud.aiplatform.v1.RagVectorDbConfig.Pinecone.getDefaultInstance()) {
          vectorDb_ =
              com.google.cloud.aiplatform.v1.RagVectorDbConfig.Pinecone.newBuilder(
                      (com.google.cloud.aiplatform.v1.RagVectorDbConfig.Pinecone) vectorDb_)
                  .mergeFrom(value)
                  .buildPartial();
        } else {
          vectorDb_ = value;
        }
        onChanged();
      } else {
        if (vectorDbCase_ == 3) {
          pineconeBuilder_.mergeFrom(value);
        } else {
          pineconeBuilder_.setMessage(value);
        }
      }
      vectorDbCase_ = 3;
      return this;
    }

    /**
     *
     *
     * <pre>
     * The config for the Pinecone.
     * </pre>
     *
     * <code>.google.cloud.aiplatform.v1.RagVectorDbConfig.Pinecone pinecone = 3;</code>
     */
    public Builder clearPinecone() {
      if (pineconeBuilder_ == null) {
        if (vectorDbCase_ == 3) {
          vectorDbCase_ = 0;
          vectorDb_ = null;
          onChanged();
        }
      } else {
        if (vectorDbCase_ == 3) {
          vectorDbCase_ = 0;
          vectorDb_ = null;
        }
        pineconeBuilder_.clear();
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * The config for the Pinecone.
     * </pre>
     *
     * <code>.google.cloud.aiplatform.v1.RagVectorDbConfig.Pinecone pinecone = 3;</code>
     */
    public com.google.cloud.aiplatform.v1.RagVectorDbConfig.Pinecone.Builder getPineconeBuilder() {
      return getPineconeFieldBuilder().getBuilder();
    }

    /**
     *
     *
     * <pre>
     * The config for the Pinecone.
     * </pre>
     *
     * <code>.google.cloud.aiplatform.v1.RagVectorDbConfig.Pinecone pinecone = 3;</code>
     */
    @java.lang.Override
    public com.google.cloud.aiplatform.v1.RagVectorDbConfig.PineconeOrBuilder
        getPineconeOrBuilder() {
      if ((vectorDbCase_ == 3) && (pineconeBuilder_ != null)) {
        return pineconeBuilder_.getMessageOrBuilder();
      } else {
        if (vectorDbCase_ == 3) {
          return (com.google.cloud.aiplatform.v1.RagVectorDbConfig.Pinecone) vectorDb_;
        }
        return com.google.cloud.aiplatform.v1.RagVectorDbConfig.Pinecone.getDefaultInstance();
      }
    }

    /**
     *
     *
     * <pre>
     * The config for the Pinecone.
     * </pre>
     *
     * <code>.google.cloud.aiplatform.v1.RagVectorDbConfig.Pinecone pinecone = 3;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.aiplatform.v1.RagVectorDbConfig.Pinecone,
            com.google.cloud.aiplatform.v1.RagVectorDbConfig.Pinecone.Builder,
            com.google.cloud.aiplatform.v1.RagVectorDbConfig.PineconeOrBuilder>
        getPineconeFieldBuilder() {
      if (pineconeBuilder_ == null) {
        if (!(vectorDbCase_ == 3)) {
          vectorDb_ =
              com.google.cloud.aiplatform.v1.RagVectorDbConfig.Pinecone.getDefaultInstance();
        }
        pineconeBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.aiplatform.v1.RagVectorDbConfig.Pinecone,
                com.google.cloud.aiplatform.v1.RagVectorDbConfig.Pinecone.Builder,
                com.google.cloud.aiplatform.v1.RagVectorDbConfig.PineconeOrBuilder>(
                (com.google.cloud.aiplatform.v1.RagVectorDbConfig.Pinecone) vectorDb_,
                getParentForChildren(),
                isClean());
        vectorDb_ = null;
      }
      vectorDbCase_ = 3;
      onChanged();
      return pineconeBuilder_;
    }

    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.aiplatform.v1.RagVectorDbConfig.VertexVectorSearch,
            com.google.cloud.aiplatform.v1.RagVectorDbConfig.VertexVectorSearch.Builder,
            com.google.cloud.aiplatform.v1.RagVectorDbConfig.VertexVectorSearchOrBuilder>
        vertexVectorSearchBuilder_;

    /**
     *
     *
     * <pre>
     * The config for the Vertex Vector Search.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1.RagVectorDbConfig.VertexVectorSearch vertex_vector_search = 6;
     * </code>
     *
     * @return Whether the vertexVectorSearch field is set.
     */
    @java.lang.Override
    public boolean hasVertexVectorSearch() {
      return vectorDbCase_ == 6;
    }

    /**
     *
     *
     * <pre>
     * The config for the Vertex Vector Search.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1.RagVectorDbConfig.VertexVectorSearch vertex_vector_search = 6;
     * </code>
     *
     * @return The vertexVectorSearch.
     */
    @java.lang.Override
    public com.google.cloud.aiplatform.v1.RagVectorDbConfig.VertexVectorSearch
        getVertexVectorSearch() {
      if (vertexVectorSearchBuilder_ == null) {
        if (vectorDbCase_ == 6) {
          return (com.google.cloud.aiplatform.v1.RagVectorDbConfig.VertexVectorSearch) vectorDb_;
        }
        return com.google.cloud.aiplatform.v1.RagVectorDbConfig.VertexVectorSearch
            .getDefaultInstance();
      } else {
        if (vectorDbCase_ == 6) {
          return vertexVectorSearchBuilder_.getMessage();
        }
        return com.google.cloud.aiplatform.v1.RagVectorDbConfig.VertexVectorSearch
            .getDefaultInstance();
      }
    }

    /**
     *
     *
     * <pre>
     * The config for the Vertex Vector Search.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1.RagVectorDbConfig.VertexVectorSearch vertex_vector_search = 6;
     * </code>
     */
    public Builder setVertexVectorSearch(
        com.google.cloud.aiplatform.v1.RagVectorDbConfig.VertexVectorSearch value) {
      if (vertexVectorSearchBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        vectorDb_ = value;
        onChanged();
      } else {
        vertexVectorSearchBuilder_.setMessage(value);
      }
      vectorDbCase_ = 6;
      return this;
    }

    /**
     *
     *
     * <pre>
     * The config for the Vertex Vector Search.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1.RagVectorDbConfig.VertexVectorSearch vertex_vector_search = 6;
     * </code>
     */
    public Builder setVertexVectorSearch(
        com.google.cloud.aiplatform.v1.RagVectorDbConfig.VertexVectorSearch.Builder
            builderForValue) {
      if (vertexVectorSearchBuilder_ == null) {
        vectorDb_ = builderForValue.build();
        onChanged();
      } else {
        vertexVectorSearchBuilder_.setMessage(builderForValue.build());
      }
      vectorDbCase_ = 6;
      return this;
    }

    /**
     *
     *
     * <pre>
     * The config for the Vertex Vector Search.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1.RagVectorDbConfig.VertexVectorSearch vertex_vector_search = 6;
     * </code>
     */
    public Builder mergeVertexVectorSearch(
        com.google.cloud.aiplatform.v1.RagVectorDbConfig.VertexVectorSearch value) {
      if (vertexVectorSearchBuilder_ == null) {
        if (vectorDbCase_ == 6
            && vectorDb_
                != com.google.cloud.aiplatform.v1.RagVectorDbConfig.VertexVectorSearch
                    .getDefaultInstance()) {
          vectorDb_ =
              com.google.cloud.aiplatform.v1.RagVectorDbConfig.VertexVectorSearch.newBuilder(
                      (com.google.cloud.aiplatform.v1.RagVectorDbConfig.VertexVectorSearch)
                          vectorDb_)
                  .mergeFrom(value)
                  .buildPartial();
        } else {
          vectorDb_ = value;
        }
        onChanged();
      } else {
        if (vectorDbCase_ == 6) {
          vertexVectorSearchBuilder_.mergeFrom(value);
        } else {
          vertexVectorSearchBuilder_.setMessage(value);
        }
      }
      vectorDbCase_ = 6;
      return this;
    }

    /**
     *
     *
     * <pre>
     * The config for the Vertex Vector Search.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1.RagVectorDbConfig.VertexVectorSearch vertex_vector_search = 6;
     * </code>
     */
    public Builder clearVertexVectorSearch() {
      if (vertexVectorSearchBuilder_ == null) {
        if (vectorDbCase_ == 6) {
          vectorDbCase_ = 0;
          vectorDb_ = null;
          onChanged();
        }
      } else {
        if (vectorDbCase_ == 6) {
          vectorDbCase_ = 0;
          vectorDb_ = null;
        }
        vertexVectorSearchBuilder_.clear();
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * The config for the Vertex Vector Search.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1.RagVectorDbConfig.VertexVectorSearch vertex_vector_search = 6;
     * </code>
     */
    public com.google.cloud.aiplatform.v1.RagVectorDbConfig.VertexVectorSearch.Builder
        getVertexVectorSearchBuilder() {
      return getVertexVectorSearchFieldBuilder().getBuilder();
    }

    /**
     *
     *
     * <pre>
     * The config for the Vertex Vector Search.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1.RagVectorDbConfig.VertexVectorSearch vertex_vector_search = 6;
     * </code>
     */
    @java.lang.Override
    public com.google.cloud.aiplatform.v1.RagVectorDbConfig.VertexVectorSearchOrBuilder
        getVertexVectorSearchOrBuilder() {
      if ((vectorDbCase_ == 6) && (vertexVectorSearchBuilder_ != null)) {
        return vertexVectorSearchBuilder_.getMessageOrBuilder();
      } else {
        if (vectorDbCase_ == 6) {
          return (com.google.cloud.aiplatform.v1.RagVectorDbConfig.VertexVectorSearch) vectorDb_;
        }
        return com.google.cloud.aiplatform.v1.RagVectorDbConfig.VertexVectorSearch
            .getDefaultInstance();
      }
    }

    /**
     *
     *
     * <pre>
     * The config for the Vertex Vector Search.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1.RagVectorDbConfig.VertexVectorSearch vertex_vector_search = 6;
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.aiplatform.v1.RagVectorDbConfig.VertexVectorSearch,
            com.google.cloud.aiplatform.v1.RagVectorDbConfig.VertexVectorSearch.Builder,
            com.google.cloud.aiplatform.v1.RagVectorDbConfig.VertexVectorSearchOrBuilder>
        getVertexVectorSearchFieldBuilder() {
      if (vertexVectorSearchBuilder_ == null) {
        if (!(vectorDbCase_ == 6)) {
          vectorDb_ =
              com.google.cloud.aiplatform.v1.RagVectorDbConfig.VertexVectorSearch
                  .getDefaultInstance();
        }
        vertexVectorSearchBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.aiplatform.v1.RagVectorDbConfig.VertexVectorSearch,
                com.google.cloud.aiplatform.v1.RagVectorDbConfig.VertexVectorSearch.Builder,
                com.google.cloud.aiplatform.v1.RagVectorDbConfig.VertexVectorSearchOrBuilder>(
                (com.google.cloud.aiplatform.v1.RagVectorDbConfig.VertexVectorSearch) vectorDb_,
                getParentForChildren(),
                isClean());
        vectorDb_ = null;
      }
      vectorDbCase_ = 6;
      onChanged();
      return vertexVectorSearchBuilder_;
    }

    private com.google.cloud.aiplatform.v1.ApiAuth apiAuth_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.aiplatform.v1.ApiAuth,
            com.google.cloud.aiplatform.v1.ApiAuth.Builder,
            com.google.cloud.aiplatform.v1.ApiAuthOrBuilder>
        apiAuthBuilder_;

    /**
     *
     *
     * <pre>
     * Authentication config for the chosen Vector DB.
     * </pre>
     *
     * <code>.google.cloud.aiplatform.v1.ApiAuth api_auth = 5;</code>
     *
     * @return Whether the apiAuth field is set.
     */
    public boolean hasApiAuth() {
      return ((bitField0_ & 0x00000008) != 0);
    }

    /**
     *
     *
     * <pre>
     * Authentication config for the chosen Vector DB.
     * </pre>
     *
     * <code>.google.cloud.aiplatform.v1.ApiAuth api_auth = 5;</code>
     *
     * @return The apiAuth.
     */
    public com.google.cloud.aiplatform.v1.ApiAuth getApiAuth() {
      if (apiAuthBuilder_ == null) {
        return apiAuth_ == null
            ? com.google.cloud.aiplatform.v1.ApiAuth.getDefaultInstance()
            : apiAuth_;
      } else {
        return apiAuthBuilder_.getMessage();
      }
    }

    /**
     *
     *
     * <pre>
     * Authentication config for the chosen Vector DB.
     * </pre>
     *
     * <code>.google.cloud.aiplatform.v1.ApiAuth api_auth = 5;</code>
     */
    public Builder setApiAuth(com.google.cloud.aiplatform.v1.ApiAuth value) {
      if (apiAuthBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        apiAuth_ = value;
      } else {
        apiAuthBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000008;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Authentication config for the chosen Vector DB.
     * </pre>
     *
     * <code>.google.cloud.aiplatform.v1.ApiAuth api_auth = 5;</code>
     */
    public Builder setApiAuth(com.google.cloud.aiplatform.v1.ApiAuth.Builder builderForValue) {
      if (apiAuthBuilder_ == null) {
        apiAuth_ = builderForValue.build();
      } else {
        apiAuthBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000008;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Authentication config for the chosen Vector DB.
     * </pre>
     *
     * <code>.google.cloud.aiplatform.v1.ApiAuth api_auth = 5;</code>
     */
    public Builder mergeApiAuth(com.google.cloud.aiplatform.v1.ApiAuth value) {
      if (apiAuthBuilder_ == null) {
        if (((bitField0_ & 0x00000008) != 0)
            && apiAuth_ != null
            && apiAuth_ != com.google.cloud.aiplatform.v1.ApiAuth.getDefaultInstance()) {
          getApiAuthBuilder().mergeFrom(value);
        } else {
          apiAuth_ = value;
        }
      } else {
        apiAuthBuilder_.mergeFrom(value);
      }
      if (apiAuth_ != null) {
        bitField0_ |= 0x00000008;
        onChanged();
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * Authentication config for the chosen Vector DB.
     * </pre>
     *
     * <code>.google.cloud.aiplatform.v1.ApiAuth api_auth = 5;</code>
     */
    public Builder clearApiAuth() {
      bitField0_ = (bitField0_ & ~0x00000008);
      apiAuth_ = null;
      if (apiAuthBuilder_ != null) {
        apiAuthBuilder_.dispose();
        apiAuthBuilder_ = null;
      }
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Authentication config for the chosen Vector DB.
     * </pre>
     *
     * <code>.google.cloud.aiplatform.v1.ApiAuth api_auth = 5;</code>
     */
    public com.google.cloud.aiplatform.v1.ApiAuth.Builder getApiAuthBuilder() {
      bitField0_ |= 0x00000008;
      onChanged();
      return getApiAuthFieldBuilder().getBuilder();
    }

    /**
     *
     *
     * <pre>
     * Authentication config for the chosen Vector DB.
     * </pre>
     *
     * <code>.google.cloud.aiplatform.v1.ApiAuth api_auth = 5;</code>
     */
    public com.google.cloud.aiplatform.v1.ApiAuthOrBuilder getApiAuthOrBuilder() {
      if (apiAuthBuilder_ != null) {
        return apiAuthBuilder_.getMessageOrBuilder();
      } else {
        return apiAuth_ == null
            ? com.google.cloud.aiplatform.v1.ApiAuth.getDefaultInstance()
            : apiAuth_;
      }
    }

    /**
     *
     *
     * <pre>
     * Authentication config for the chosen Vector DB.
     * </pre>
     *
     * <code>.google.cloud.aiplatform.v1.ApiAuth api_auth = 5;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.aiplatform.v1.ApiAuth,
            com.google.cloud.aiplatform.v1.ApiAuth.Builder,
            com.google.cloud.aiplatform.v1.ApiAuthOrBuilder>
        getApiAuthFieldBuilder() {
      if (apiAuthBuilder_ == null) {
        apiAuthBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.aiplatform.v1.ApiAuth,
                com.google.cloud.aiplatform.v1.ApiAuth.Builder,
                com.google.cloud.aiplatform.v1.ApiAuthOrBuilder>(
                getApiAuth(), getParentForChildren(), isClean());
        apiAuth_ = null;
      }
      return apiAuthBuilder_;
    }

    private com.google.cloud.aiplatform.v1.RagEmbeddingModelConfig ragEmbeddingModelConfig_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.aiplatform.v1.RagEmbeddingModelConfig,
            com.google.cloud.aiplatform.v1.RagEmbeddingModelConfig.Builder,
            com.google.cloud.aiplatform.v1.RagEmbeddingModelConfigOrBuilder>
        ragEmbeddingModelConfigBuilder_;

    /**
     *
     *
     * <pre>
     * Optional. Immutable. The embedding model config of the Vector DB.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1.RagEmbeddingModelConfig rag_embedding_model_config = 7 [(.google.api.field_behavior) = OPTIONAL, (.google.api.field_behavior) = IMMUTABLE];
     * </code>
     *
     * @return Whether the ragEmbeddingModelConfig field is set.
     */
    public boolean hasRagEmbeddingModelConfig() {
      return ((bitField0_ & 0x00000010) != 0);
    }

    /**
     *
     *
     * <pre>
     * Optional. Immutable. The embedding model config of the Vector DB.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1.RagEmbeddingModelConfig rag_embedding_model_config = 7 [(.google.api.field_behavior) = OPTIONAL, (.google.api.field_behavior) = IMMUTABLE];
     * </code>
     *
     * @return The ragEmbeddingModelConfig.
     */
    public com.google.cloud.aiplatform.v1.RagEmbeddingModelConfig getRagEmbeddingModelConfig() {
      if (ragEmbeddingModelConfigBuilder_ == null) {
        return ragEmbeddingModelConfig_ == null
            ? com.google.cloud.aiplatform.v1.RagEmbeddingModelConfig.getDefaultInstance()
            : ragEmbeddingModelConfig_;
      } else {
        return ragEmbeddingModelConfigBuilder_.getMessage();
      }
    }

    /**
     *
     *
     * <pre>
     * Optional. Immutable. The embedding model config of the Vector DB.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1.RagEmbeddingModelConfig rag_embedding_model_config = 7 [(.google.api.field_behavior) = OPTIONAL, (.google.api.field_behavior) = IMMUTABLE];
     * </code>
     */
    public Builder setRagEmbeddingModelConfig(
        com.google.cloud.aiplatform.v1.RagEmbeddingModelConfig value) {
      if (ragEmbeddingModelConfigBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ragEmbeddingModelConfig_ = value;
      } else {
        ragEmbeddingModelConfigBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000010;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Optional. Immutable. The embedding model config of the Vector DB.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1.RagEmbeddingModelConfig rag_embedding_model_config = 7 [(.google.api.field_behavior) = OPTIONAL, (.google.api.field_behavior) = IMMUTABLE];
     * </code>
     */
    public Builder setRagEmbeddingModelConfig(
        com.google.cloud.aiplatform.v1.RagEmbeddingModelConfig.Builder builderForValue) {
      if (ragEmbeddingModelConfigBuilder_ == null) {
        ragEmbeddingModelConfig_ = builderForValue.build();
      } else {
        ragEmbeddingModelConfigBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000010;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Optional. Immutable. The embedding model config of the Vector DB.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1.RagEmbeddingModelConfig rag_embedding_model_config = 7 [(.google.api.field_behavior) = OPTIONAL, (.google.api.field_behavior) = IMMUTABLE];
     * </code>
     */
    public Builder mergeRagEmbeddingModelConfig(
        com.google.cloud.aiplatform.v1.RagEmbeddingModelConfig value) {
      if (ragEmbeddingModelConfigBuilder_ == null) {
        if (((bitField0_ & 0x00000010) != 0)
            && ragEmbeddingModelConfig_ != null
            && ragEmbeddingModelConfig_
                != com.google.cloud.aiplatform.v1.RagEmbeddingModelConfig.getDefaultInstance()) {
          getRagEmbeddingModelConfigBuilder().mergeFrom(value);
        } else {
          ragEmbeddingModelConfig_ = value;
        }
      } else {
        ragEmbeddingModelConfigBuilder_.mergeFrom(value);
      }
      if (ragEmbeddingModelConfig_ != null) {
        bitField0_ |= 0x00000010;
        onChanged();
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * Optional. Immutable. The embedding model config of the Vector DB.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1.RagEmbeddingModelConfig rag_embedding_model_config = 7 [(.google.api.field_behavior) = OPTIONAL, (.google.api.field_behavior) = IMMUTABLE];
     * </code>
     */
    public Builder clearRagEmbeddingModelConfig() {
      bitField0_ = (bitField0_ & ~0x00000010);
      ragEmbeddingModelConfig_ = null;
      if (ragEmbeddingModelConfigBuilder_ != null) {
        ragEmbeddingModelConfigBuilder_.dispose();
        ragEmbeddingModelConfigBuilder_ = null;
      }
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Optional. Immutable. The embedding model config of the Vector DB.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1.RagEmbeddingModelConfig rag_embedding_model_config = 7 [(.google.api.field_behavior) = OPTIONAL, (.google.api.field_behavior) = IMMUTABLE];
     * </code>
     */
    public com.google.cloud.aiplatform.v1.RagEmbeddingModelConfig.Builder
        getRagEmbeddingModelConfigBuilder() {
      bitField0_ |= 0x00000010;
      onChanged();
      return getRagEmbeddingModelConfigFieldBuilder().getBuilder();
    }

    /**
     *
     *
     * <pre>
     * Optional. Immutable. The embedding model config of the Vector DB.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1.RagEmbeddingModelConfig rag_embedding_model_config = 7 [(.google.api.field_behavior) = OPTIONAL, (.google.api.field_behavior) = IMMUTABLE];
     * </code>
     */
    public com.google.cloud.aiplatform.v1.RagEmbeddingModelConfigOrBuilder
        getRagEmbeddingModelConfigOrBuilder() {
      if (ragEmbeddingModelConfigBuilder_ != null) {
        return ragEmbeddingModelConfigBuilder_.getMessageOrBuilder();
      } else {
        return ragEmbeddingModelConfig_ == null
            ? com.google.cloud.aiplatform.v1.RagEmbeddingModelConfig.getDefaultInstance()
            : ragEmbeddingModelConfig_;
      }
    }

    /**
     *
     *
     * <pre>
     * Optional. Immutable. The embedding model config of the Vector DB.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1.RagEmbeddingModelConfig rag_embedding_model_config = 7 [(.google.api.field_behavior) = OPTIONAL, (.google.api.field_behavior) = IMMUTABLE];
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.aiplatform.v1.RagEmbeddingModelConfig,
            com.google.cloud.aiplatform.v1.RagEmbeddingModelConfig.Builder,
            com.google.cloud.aiplatform.v1.RagEmbeddingModelConfigOrBuilder>
        getRagEmbeddingModelConfigFieldBuilder() {
      if (ragEmbeddingModelConfigBuilder_ == null) {
        ragEmbeddingModelConfigBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.aiplatform.v1.RagEmbeddingModelConfig,
                com.google.cloud.aiplatform.v1.RagEmbeddingModelConfig.Builder,
                com.google.cloud.aiplatform.v1.RagEmbeddingModelConfigOrBuilder>(
                getRagEmbeddingModelConfig(), getParentForChildren(), isClean());
        ragEmbeddingModelConfig_ = null;
      }
      return ragEmbeddingModelConfigBuilder_;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.cloud.aiplatform.v1.RagVectorDbConfig)
  }

  // @@protoc_insertion_point(class_scope:google.cloud.aiplatform.v1.RagVectorDbConfig)
  private static final com.google.cloud.aiplatform.v1.RagVectorDbConfig DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.cloud.aiplatform.v1.RagVectorDbConfig();
  }

  public static com.google.cloud.aiplatform.v1.RagVectorDbConfig getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<RagVectorDbConfig> PARSER =
      new com.google.protobuf.AbstractParser<RagVectorDbConfig>() {
        @java.lang.Override
        public RagVectorDbConfig parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          Builder builder = newBuilder();
          try {
            builder.mergeFrom(input, extensionRegistry);
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.setUnfinishedMessage(builder.buildPartial());
          } catch (com.google.protobuf.UninitializedMessageException e) {
            throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
          } catch (java.io.IOException e) {
            throw new com.google.protobuf.InvalidProtocolBufferException(e)
                .setUnfinishedMessage(builder.buildPartial());
          }
          return builder.buildPartial();
        }
      };

  public static com.google.protobuf.Parser<RagVectorDbConfig> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<RagVectorDbConfig> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.cloud.aiplatform.v1.RagVectorDbConfig getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
