/*
 * Copyright 2025 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/cloud/aiplatform/v1/featurestore_service.proto

// Protobuf Java Version: 3.25.8
package com.google.cloud.aiplatform.v1;

/**
 *
 *
 * <pre>
 * Request message for
 * [FeaturestoreService.SearchFeatures][google.cloud.aiplatform.v1.FeaturestoreService.SearchFeatures].
 * </pre>
 *
 * Protobuf type {@code google.cloud.aiplatform.v1.SearchFeaturesRequest}
 */
public final class SearchFeaturesRequest extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.cloud.aiplatform.v1.SearchFeaturesRequest)
    SearchFeaturesRequestOrBuilder {
  private static final long serialVersionUID = 0L;

  // Use SearchFeaturesRequest.newBuilder() to construct.
  private SearchFeaturesRequest(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private SearchFeaturesRequest() {
    location_ = "";
    query_ = "";
    pageToken_ = "";
  }

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new SearchFeaturesRequest();
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.cloud.aiplatform.v1.FeaturestoreServiceProto
        .internal_static_google_cloud_aiplatform_v1_SearchFeaturesRequest_descriptor;
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.cloud.aiplatform.v1.FeaturestoreServiceProto
        .internal_static_google_cloud_aiplatform_v1_SearchFeaturesRequest_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.cloud.aiplatform.v1.SearchFeaturesRequest.class,
            com.google.cloud.aiplatform.v1.SearchFeaturesRequest.Builder.class);
  }

  public static final int LOCATION_FIELD_NUMBER = 1;

  @SuppressWarnings("serial")
  private volatile java.lang.Object location_ = "";

  /**
   *
   *
   * <pre>
   * Required. The resource name of the Location to search Features.
   * Format:
   * `projects/{project}/locations/{location}`
   * </pre>
   *
   * <code>
   * string location = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
   * </code>
   *
   * @return The location.
   */
  @java.lang.Override
  public java.lang.String getLocation() {
    java.lang.Object ref = location_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      location_ = s;
      return s;
    }
  }

  /**
   *
   *
   * <pre>
   * Required. The resource name of the Location to search Features.
   * Format:
   * `projects/{project}/locations/{location}`
   * </pre>
   *
   * <code>
   * string location = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
   * </code>
   *
   * @return The bytes for location.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getLocationBytes() {
    java.lang.Object ref = location_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      location_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int QUERY_FIELD_NUMBER = 3;

  @SuppressWarnings("serial")
  private volatile java.lang.Object query_ = "";

  /**
   *
   *
   * <pre>
   * Query string that is a conjunction of field-restricted queries and/or
   * field-restricted filters.  Field-restricted queries and filters can be
   * combined using `AND` to form a conjunction.
   *
   * A field query is in the form FIELD:QUERY. This implicitly checks if QUERY
   * exists as a substring within Feature's FIELD. The QUERY
   * and the FIELD are converted to a sequence of words (i.e. tokens) for
   * comparison. This is done by:
   *
   *   * Removing leading/trailing whitespace and tokenizing the search value.
   *   Characters that are not one of alphanumeric `[a-zA-Z0-9]`, underscore
   *   `_`, or asterisk `*` are treated as delimiters for tokens. `*` is treated
   *   as a wildcard that matches characters within a token.
   *   * Ignoring case.
   *   * Prepending an asterisk to the first and appending an asterisk to the
   *   last token in QUERY.
   *
   * A QUERY must be either a singular token or a phrase. A phrase is one or
   * multiple words enclosed in double quotation marks ("). With phrases, the
   * order of the words is important. Words in the phrase must be matching in
   * order and consecutively.
   *
   * Supported FIELDs for field-restricted queries:
   *
   * * `feature_id`
   * * `description`
   * * `entity_type_id`
   *
   * Examples:
   *
   * * `feature_id: foo` --&gt; Matches a Feature with ID containing the substring
   * `foo` (eg. `foo`, `foofeature`, `barfoo`).
   * * `feature_id: foo*feature` --&gt; Matches a Feature with ID containing the
   * substring `foo*feature` (eg. `foobarfeature`).
   * * `feature_id: foo AND description: bar` --&gt; Matches a Feature with ID
   * containing the substring `foo` and description containing the substring
   * `bar`.
   *
   *
   * Besides field queries, the following exact-match filters are
   * supported. The exact-match filters do not support wildcards. Unlike
   * field-restricted queries, exact-match filters are case-sensitive.
   *
   * * `feature_id`: Supports = comparisons.
   * * `description`: Supports = comparisons. Multi-token filters should be
   * enclosed in quotes.
   * * `entity_type_id`: Supports = comparisons.
   * * `value_type`: Supports = and != comparisons.
   * * `labels`: Supports key-value equality as well as key presence.
   * * `featurestore_id`: Supports = comparisons.
   *
   * Examples:
   *
   * * `description = "foo bar"` --&gt; Any Feature with description exactly equal
   * to `foo bar`
   * * `value_type = DOUBLE` --&gt; Features whose type is DOUBLE.
   * * `labels.active = yes AND labels.env = prod` --&gt; Features having both
   *     (active: yes) and (env: prod) labels.
   * * `labels.env: *` --&gt; Any Feature which has a label with `env` as the
   *   key.
   * </pre>
   *
   * <code>string query = 3;</code>
   *
   * @return The query.
   */
  @java.lang.Override
  public java.lang.String getQuery() {
    java.lang.Object ref = query_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      query_ = s;
      return s;
    }
  }

  /**
   *
   *
   * <pre>
   * Query string that is a conjunction of field-restricted queries and/or
   * field-restricted filters.  Field-restricted queries and filters can be
   * combined using `AND` to form a conjunction.
   *
   * A field query is in the form FIELD:QUERY. This implicitly checks if QUERY
   * exists as a substring within Feature's FIELD. The QUERY
   * and the FIELD are converted to a sequence of words (i.e. tokens) for
   * comparison. This is done by:
   *
   *   * Removing leading/trailing whitespace and tokenizing the search value.
   *   Characters that are not one of alphanumeric `[a-zA-Z0-9]`, underscore
   *   `_`, or asterisk `*` are treated as delimiters for tokens. `*` is treated
   *   as a wildcard that matches characters within a token.
   *   * Ignoring case.
   *   * Prepending an asterisk to the first and appending an asterisk to the
   *   last token in QUERY.
   *
   * A QUERY must be either a singular token or a phrase. A phrase is one or
   * multiple words enclosed in double quotation marks ("). With phrases, the
   * order of the words is important. Words in the phrase must be matching in
   * order and consecutively.
   *
   * Supported FIELDs for field-restricted queries:
   *
   * * `feature_id`
   * * `description`
   * * `entity_type_id`
   *
   * Examples:
   *
   * * `feature_id: foo` --&gt; Matches a Feature with ID containing the substring
   * `foo` (eg. `foo`, `foofeature`, `barfoo`).
   * * `feature_id: foo*feature` --&gt; Matches a Feature with ID containing the
   * substring `foo*feature` (eg. `foobarfeature`).
   * * `feature_id: foo AND description: bar` --&gt; Matches a Feature with ID
   * containing the substring `foo` and description containing the substring
   * `bar`.
   *
   *
   * Besides field queries, the following exact-match filters are
   * supported. The exact-match filters do not support wildcards. Unlike
   * field-restricted queries, exact-match filters are case-sensitive.
   *
   * * `feature_id`: Supports = comparisons.
   * * `description`: Supports = comparisons. Multi-token filters should be
   * enclosed in quotes.
   * * `entity_type_id`: Supports = comparisons.
   * * `value_type`: Supports = and != comparisons.
   * * `labels`: Supports key-value equality as well as key presence.
   * * `featurestore_id`: Supports = comparisons.
   *
   * Examples:
   *
   * * `description = "foo bar"` --&gt; Any Feature with description exactly equal
   * to `foo bar`
   * * `value_type = DOUBLE` --&gt; Features whose type is DOUBLE.
   * * `labels.active = yes AND labels.env = prod` --&gt; Features having both
   *     (active: yes) and (env: prod) labels.
   * * `labels.env: *` --&gt; Any Feature which has a label with `env` as the
   *   key.
   * </pre>
   *
   * <code>string query = 3;</code>
   *
   * @return The bytes for query.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getQueryBytes() {
    java.lang.Object ref = query_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      query_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int PAGE_SIZE_FIELD_NUMBER = 4;
  private int pageSize_ = 0;

  /**
   *
   *
   * <pre>
   * The maximum number of Features to return. The service may return fewer
   * than this value. If unspecified, at most 100 Features will be returned.
   * The maximum value is 100; any value greater than 100 will be coerced to
   * 100.
   * </pre>
   *
   * <code>int32 page_size = 4;</code>
   *
   * @return The pageSize.
   */
  @java.lang.Override
  public int getPageSize() {
    return pageSize_;
  }

  public static final int PAGE_TOKEN_FIELD_NUMBER = 5;

  @SuppressWarnings("serial")
  private volatile java.lang.Object pageToken_ = "";

  /**
   *
   *
   * <pre>
   * A page token, received from a previous
   * [FeaturestoreService.SearchFeatures][google.cloud.aiplatform.v1.FeaturestoreService.SearchFeatures]
   * call. Provide this to retrieve the subsequent page.
   *
   * When paginating, all other parameters provided to
   * [FeaturestoreService.SearchFeatures][google.cloud.aiplatform.v1.FeaturestoreService.SearchFeatures],
   * except `page_size`, must match the call that provided the page token.
   * </pre>
   *
   * <code>string page_token = 5;</code>
   *
   * @return The pageToken.
   */
  @java.lang.Override
  public java.lang.String getPageToken() {
    java.lang.Object ref = pageToken_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      pageToken_ = s;
      return s;
    }
  }

  /**
   *
   *
   * <pre>
   * A page token, received from a previous
   * [FeaturestoreService.SearchFeatures][google.cloud.aiplatform.v1.FeaturestoreService.SearchFeatures]
   * call. Provide this to retrieve the subsequent page.
   *
   * When paginating, all other parameters provided to
   * [FeaturestoreService.SearchFeatures][google.cloud.aiplatform.v1.FeaturestoreService.SearchFeatures],
   * except `page_size`, must match the call that provided the page token.
   * </pre>
   *
   * <code>string page_token = 5;</code>
   *
   * @return The bytes for pageToken.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getPageTokenBytes() {
    java.lang.Object ref = pageToken_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      pageToken_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(location_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 1, location_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(query_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 3, query_);
    }
    if (pageSize_ != 0) {
      output.writeInt32(4, pageSize_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(pageToken_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 5, pageToken_);
    }
    getUnknownFields().writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(location_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(1, location_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(query_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(3, query_);
    }
    if (pageSize_ != 0) {
      size += com.google.protobuf.CodedOutputStream.computeInt32Size(4, pageSize_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(pageToken_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(5, pageToken_);
    }
    size += getUnknownFields().getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.cloud.aiplatform.v1.SearchFeaturesRequest)) {
      return super.equals(obj);
    }
    com.google.cloud.aiplatform.v1.SearchFeaturesRequest other =
        (com.google.cloud.aiplatform.v1.SearchFeaturesRequest) obj;

    if (!getLocation().equals(other.getLocation())) return false;
    if (!getQuery().equals(other.getQuery())) return false;
    if (getPageSize() != other.getPageSize()) return false;
    if (!getPageToken().equals(other.getPageToken())) return false;
    if (!getUnknownFields().equals(other.getUnknownFields())) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    hash = (37 * hash) + LOCATION_FIELD_NUMBER;
    hash = (53 * hash) + getLocation().hashCode();
    hash = (37 * hash) + QUERY_FIELD_NUMBER;
    hash = (53 * hash) + getQuery().hashCode();
    hash = (37 * hash) + PAGE_SIZE_FIELD_NUMBER;
    hash = (53 * hash) + getPageSize();
    hash = (37 * hash) + PAGE_TOKEN_FIELD_NUMBER;
    hash = (53 * hash) + getPageToken().hashCode();
    hash = (29 * hash) + getUnknownFields().hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.cloud.aiplatform.v1.SearchFeaturesRequest parseFrom(
      java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.aiplatform.v1.SearchFeaturesRequest parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.aiplatform.v1.SearchFeaturesRequest parseFrom(
      com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.aiplatform.v1.SearchFeaturesRequest parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.aiplatform.v1.SearchFeaturesRequest parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.aiplatform.v1.SearchFeaturesRequest parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.aiplatform.v1.SearchFeaturesRequest parseFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.aiplatform.v1.SearchFeaturesRequest parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.aiplatform.v1.SearchFeaturesRequest parseDelimitedFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.cloud.aiplatform.v1.SearchFeaturesRequest parseDelimitedFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.aiplatform.v1.SearchFeaturesRequest parseFrom(
      com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.aiplatform.v1.SearchFeaturesRequest parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(com.google.cloud.aiplatform.v1.SearchFeaturesRequest prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }

  /**
   *
   *
   * <pre>
   * Request message for
   * [FeaturestoreService.SearchFeatures][google.cloud.aiplatform.v1.FeaturestoreService.SearchFeatures].
   * </pre>
   *
   * Protobuf type {@code google.cloud.aiplatform.v1.SearchFeaturesRequest}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.cloud.aiplatform.v1.SearchFeaturesRequest)
      com.google.cloud.aiplatform.v1.SearchFeaturesRequestOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.aiplatform.v1.FeaturestoreServiceProto
          .internal_static_google_cloud_aiplatform_v1_SearchFeaturesRequest_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.aiplatform.v1.FeaturestoreServiceProto
          .internal_static_google_cloud_aiplatform_v1_SearchFeaturesRequest_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.aiplatform.v1.SearchFeaturesRequest.class,
              com.google.cloud.aiplatform.v1.SearchFeaturesRequest.Builder.class);
    }

    // Construct using com.google.cloud.aiplatform.v1.SearchFeaturesRequest.newBuilder()
    private Builder() {}

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      bitField0_ = 0;
      location_ = "";
      query_ = "";
      pageSize_ = 0;
      pageToken_ = "";
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.cloud.aiplatform.v1.FeaturestoreServiceProto
          .internal_static_google_cloud_aiplatform_v1_SearchFeaturesRequest_descriptor;
    }

    @java.lang.Override
    public com.google.cloud.aiplatform.v1.SearchFeaturesRequest getDefaultInstanceForType() {
      return com.google.cloud.aiplatform.v1.SearchFeaturesRequest.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.cloud.aiplatform.v1.SearchFeaturesRequest build() {
      com.google.cloud.aiplatform.v1.SearchFeaturesRequest result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.cloud.aiplatform.v1.SearchFeaturesRequest buildPartial() {
      com.google.cloud.aiplatform.v1.SearchFeaturesRequest result =
          new com.google.cloud.aiplatform.v1.SearchFeaturesRequest(this);
      if (bitField0_ != 0) {
        buildPartial0(result);
      }
      onBuilt();
      return result;
    }

    private void buildPartial0(com.google.cloud.aiplatform.v1.SearchFeaturesRequest result) {
      int from_bitField0_ = bitField0_;
      if (((from_bitField0_ & 0x00000001) != 0)) {
        result.location_ = location_;
      }
      if (((from_bitField0_ & 0x00000002) != 0)) {
        result.query_ = query_;
      }
      if (((from_bitField0_ & 0x00000004) != 0)) {
        result.pageSize_ = pageSize_;
      }
      if (((from_bitField0_ & 0x00000008) != 0)) {
        result.pageToken_ = pageToken_;
      }
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.cloud.aiplatform.v1.SearchFeaturesRequest) {
        return mergeFrom((com.google.cloud.aiplatform.v1.SearchFeaturesRequest) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(com.google.cloud.aiplatform.v1.SearchFeaturesRequest other) {
      if (other == com.google.cloud.aiplatform.v1.SearchFeaturesRequest.getDefaultInstance())
        return this;
      if (!other.getLocation().isEmpty()) {
        location_ = other.location_;
        bitField0_ |= 0x00000001;
        onChanged();
      }
      if (!other.getQuery().isEmpty()) {
        query_ = other.query_;
        bitField0_ |= 0x00000002;
        onChanged();
      }
      if (other.getPageSize() != 0) {
        setPageSize(other.getPageSize());
      }
      if (!other.getPageToken().isEmpty()) {
        pageToken_ = other.pageToken_;
        bitField0_ |= 0x00000008;
        onChanged();
      }
      this.mergeUnknownFields(other.getUnknownFields());
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 10:
              {
                location_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000001;
                break;
              } // case 10
            case 26:
              {
                query_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000002;
                break;
              } // case 26
            case 32:
              {
                pageSize_ = input.readInt32();
                bitField0_ |= 0x00000004;
                break;
              } // case 32
            case 42:
              {
                pageToken_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000008;
                break;
              } // case 42
            default:
              {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
          } // switch (tag)
        } // while (!done)
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.unwrapIOException();
      } finally {
        onChanged();
      } // finally
      return this;
    }

    private int bitField0_;

    private java.lang.Object location_ = "";

    /**
     *
     *
     * <pre>
     * Required. The resource name of the Location to search Features.
     * Format:
     * `projects/{project}/locations/{location}`
     * </pre>
     *
     * <code>
     * string location = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @return The location.
     */
    public java.lang.String getLocation() {
      java.lang.Object ref = location_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        location_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }

    /**
     *
     *
     * <pre>
     * Required. The resource name of the Location to search Features.
     * Format:
     * `projects/{project}/locations/{location}`
     * </pre>
     *
     * <code>
     * string location = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @return The bytes for location.
     */
    public com.google.protobuf.ByteString getLocationBytes() {
      java.lang.Object ref = location_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        location_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    /**
     *
     *
     * <pre>
     * Required. The resource name of the Location to search Features.
     * Format:
     * `projects/{project}/locations/{location}`
     * </pre>
     *
     * <code>
     * string location = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @param value The location to set.
     * @return This builder for chaining.
     */
    public Builder setLocation(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      location_ = value;
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Required. The resource name of the Location to search Features.
     * Format:
     * `projects/{project}/locations/{location}`
     * </pre>
     *
     * <code>
     * string location = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @return This builder for chaining.
     */
    public Builder clearLocation() {
      location_ = getDefaultInstance().getLocation();
      bitField0_ = (bitField0_ & ~0x00000001);
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Required. The resource name of the Location to search Features.
     * Format:
     * `projects/{project}/locations/{location}`
     * </pre>
     *
     * <code>
     * string location = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @param value The bytes for location to set.
     * @return This builder for chaining.
     */
    public Builder setLocationBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      location_ = value;
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }

    private java.lang.Object query_ = "";

    /**
     *
     *
     * <pre>
     * Query string that is a conjunction of field-restricted queries and/or
     * field-restricted filters.  Field-restricted queries and filters can be
     * combined using `AND` to form a conjunction.
     *
     * A field query is in the form FIELD:QUERY. This implicitly checks if QUERY
     * exists as a substring within Feature's FIELD. The QUERY
     * and the FIELD are converted to a sequence of words (i.e. tokens) for
     * comparison. This is done by:
     *
     *   * Removing leading/trailing whitespace and tokenizing the search value.
     *   Characters that are not one of alphanumeric `[a-zA-Z0-9]`, underscore
     *   `_`, or asterisk `*` are treated as delimiters for tokens. `*` is treated
     *   as a wildcard that matches characters within a token.
     *   * Ignoring case.
     *   * Prepending an asterisk to the first and appending an asterisk to the
     *   last token in QUERY.
     *
     * A QUERY must be either a singular token or a phrase. A phrase is one or
     * multiple words enclosed in double quotation marks ("). With phrases, the
     * order of the words is important. Words in the phrase must be matching in
     * order and consecutively.
     *
     * Supported FIELDs for field-restricted queries:
     *
     * * `feature_id`
     * * `description`
     * * `entity_type_id`
     *
     * Examples:
     *
     * * `feature_id: foo` --&gt; Matches a Feature with ID containing the substring
     * `foo` (eg. `foo`, `foofeature`, `barfoo`).
     * * `feature_id: foo*feature` --&gt; Matches a Feature with ID containing the
     * substring `foo*feature` (eg. `foobarfeature`).
     * * `feature_id: foo AND description: bar` --&gt; Matches a Feature with ID
     * containing the substring `foo` and description containing the substring
     * `bar`.
     *
     *
     * Besides field queries, the following exact-match filters are
     * supported. The exact-match filters do not support wildcards. Unlike
     * field-restricted queries, exact-match filters are case-sensitive.
     *
     * * `feature_id`: Supports = comparisons.
     * * `description`: Supports = comparisons. Multi-token filters should be
     * enclosed in quotes.
     * * `entity_type_id`: Supports = comparisons.
     * * `value_type`: Supports = and != comparisons.
     * * `labels`: Supports key-value equality as well as key presence.
     * * `featurestore_id`: Supports = comparisons.
     *
     * Examples:
     *
     * * `description = "foo bar"` --&gt; Any Feature with description exactly equal
     * to `foo bar`
     * * `value_type = DOUBLE` --&gt; Features whose type is DOUBLE.
     * * `labels.active = yes AND labels.env = prod` --&gt; Features having both
     *     (active: yes) and (env: prod) labels.
     * * `labels.env: *` --&gt; Any Feature which has a label with `env` as the
     *   key.
     * </pre>
     *
     * <code>string query = 3;</code>
     *
     * @return The query.
     */
    public java.lang.String getQuery() {
      java.lang.Object ref = query_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        query_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }

    /**
     *
     *
     * <pre>
     * Query string that is a conjunction of field-restricted queries and/or
     * field-restricted filters.  Field-restricted queries and filters can be
     * combined using `AND` to form a conjunction.
     *
     * A field query is in the form FIELD:QUERY. This implicitly checks if QUERY
     * exists as a substring within Feature's FIELD. The QUERY
     * and the FIELD are converted to a sequence of words (i.e. tokens) for
     * comparison. This is done by:
     *
     *   * Removing leading/trailing whitespace and tokenizing the search value.
     *   Characters that are not one of alphanumeric `[a-zA-Z0-9]`, underscore
     *   `_`, or asterisk `*` are treated as delimiters for tokens. `*` is treated
     *   as a wildcard that matches characters within a token.
     *   * Ignoring case.
     *   * Prepending an asterisk to the first and appending an asterisk to the
     *   last token in QUERY.
     *
     * A QUERY must be either a singular token or a phrase. A phrase is one or
     * multiple words enclosed in double quotation marks ("). With phrases, the
     * order of the words is important. Words in the phrase must be matching in
     * order and consecutively.
     *
     * Supported FIELDs for field-restricted queries:
     *
     * * `feature_id`
     * * `description`
     * * `entity_type_id`
     *
     * Examples:
     *
     * * `feature_id: foo` --&gt; Matches a Feature with ID containing the substring
     * `foo` (eg. `foo`, `foofeature`, `barfoo`).
     * * `feature_id: foo*feature` --&gt; Matches a Feature with ID containing the
     * substring `foo*feature` (eg. `foobarfeature`).
     * * `feature_id: foo AND description: bar` --&gt; Matches a Feature with ID
     * containing the substring `foo` and description containing the substring
     * `bar`.
     *
     *
     * Besides field queries, the following exact-match filters are
     * supported. The exact-match filters do not support wildcards. Unlike
     * field-restricted queries, exact-match filters are case-sensitive.
     *
     * * `feature_id`: Supports = comparisons.
     * * `description`: Supports = comparisons. Multi-token filters should be
     * enclosed in quotes.
     * * `entity_type_id`: Supports = comparisons.
     * * `value_type`: Supports = and != comparisons.
     * * `labels`: Supports key-value equality as well as key presence.
     * * `featurestore_id`: Supports = comparisons.
     *
     * Examples:
     *
     * * `description = "foo bar"` --&gt; Any Feature with description exactly equal
     * to `foo bar`
     * * `value_type = DOUBLE` --&gt; Features whose type is DOUBLE.
     * * `labels.active = yes AND labels.env = prod` --&gt; Features having both
     *     (active: yes) and (env: prod) labels.
     * * `labels.env: *` --&gt; Any Feature which has a label with `env` as the
     *   key.
     * </pre>
     *
     * <code>string query = 3;</code>
     *
     * @return The bytes for query.
     */
    public com.google.protobuf.ByteString getQueryBytes() {
      java.lang.Object ref = query_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        query_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    /**
     *
     *
     * <pre>
     * Query string that is a conjunction of field-restricted queries and/or
     * field-restricted filters.  Field-restricted queries and filters can be
     * combined using `AND` to form a conjunction.
     *
     * A field query is in the form FIELD:QUERY. This implicitly checks if QUERY
     * exists as a substring within Feature's FIELD. The QUERY
     * and the FIELD are converted to a sequence of words (i.e. tokens) for
     * comparison. This is done by:
     *
     *   * Removing leading/trailing whitespace and tokenizing the search value.
     *   Characters that are not one of alphanumeric `[a-zA-Z0-9]`, underscore
     *   `_`, or asterisk `*` are treated as delimiters for tokens. `*` is treated
     *   as a wildcard that matches characters within a token.
     *   * Ignoring case.
     *   * Prepending an asterisk to the first and appending an asterisk to the
     *   last token in QUERY.
     *
     * A QUERY must be either a singular token or a phrase. A phrase is one or
     * multiple words enclosed in double quotation marks ("). With phrases, the
     * order of the words is important. Words in the phrase must be matching in
     * order and consecutively.
     *
     * Supported FIELDs for field-restricted queries:
     *
     * * `feature_id`
     * * `description`
     * * `entity_type_id`
     *
     * Examples:
     *
     * * `feature_id: foo` --&gt; Matches a Feature with ID containing the substring
     * `foo` (eg. `foo`, `foofeature`, `barfoo`).
     * * `feature_id: foo*feature` --&gt; Matches a Feature with ID containing the
     * substring `foo*feature` (eg. `foobarfeature`).
     * * `feature_id: foo AND description: bar` --&gt; Matches a Feature with ID
     * containing the substring `foo` and description containing the substring
     * `bar`.
     *
     *
     * Besides field queries, the following exact-match filters are
     * supported. The exact-match filters do not support wildcards. Unlike
     * field-restricted queries, exact-match filters are case-sensitive.
     *
     * * `feature_id`: Supports = comparisons.
     * * `description`: Supports = comparisons. Multi-token filters should be
     * enclosed in quotes.
     * * `entity_type_id`: Supports = comparisons.
     * * `value_type`: Supports = and != comparisons.
     * * `labels`: Supports key-value equality as well as key presence.
     * * `featurestore_id`: Supports = comparisons.
     *
     * Examples:
     *
     * * `description = "foo bar"` --&gt; Any Feature with description exactly equal
     * to `foo bar`
     * * `value_type = DOUBLE` --&gt; Features whose type is DOUBLE.
     * * `labels.active = yes AND labels.env = prod` --&gt; Features having both
     *     (active: yes) and (env: prod) labels.
     * * `labels.env: *` --&gt; Any Feature which has a label with `env` as the
     *   key.
     * </pre>
     *
     * <code>string query = 3;</code>
     *
     * @param value The query to set.
     * @return This builder for chaining.
     */
    public Builder setQuery(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      query_ = value;
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Query string that is a conjunction of field-restricted queries and/or
     * field-restricted filters.  Field-restricted queries and filters can be
     * combined using `AND` to form a conjunction.
     *
     * A field query is in the form FIELD:QUERY. This implicitly checks if QUERY
     * exists as a substring within Feature's FIELD. The QUERY
     * and the FIELD are converted to a sequence of words (i.e. tokens) for
     * comparison. This is done by:
     *
     *   * Removing leading/trailing whitespace and tokenizing the search value.
     *   Characters that are not one of alphanumeric `[a-zA-Z0-9]`, underscore
     *   `_`, or asterisk `*` are treated as delimiters for tokens. `*` is treated
     *   as a wildcard that matches characters within a token.
     *   * Ignoring case.
     *   * Prepending an asterisk to the first and appending an asterisk to the
     *   last token in QUERY.
     *
     * A QUERY must be either a singular token or a phrase. A phrase is one or
     * multiple words enclosed in double quotation marks ("). With phrases, the
     * order of the words is important. Words in the phrase must be matching in
     * order and consecutively.
     *
     * Supported FIELDs for field-restricted queries:
     *
     * * `feature_id`
     * * `description`
     * * `entity_type_id`
     *
     * Examples:
     *
     * * `feature_id: foo` --&gt; Matches a Feature with ID containing the substring
     * `foo` (eg. `foo`, `foofeature`, `barfoo`).
     * * `feature_id: foo*feature` --&gt; Matches a Feature with ID containing the
     * substring `foo*feature` (eg. `foobarfeature`).
     * * `feature_id: foo AND description: bar` --&gt; Matches a Feature with ID
     * containing the substring `foo` and description containing the substring
     * `bar`.
     *
     *
     * Besides field queries, the following exact-match filters are
     * supported. The exact-match filters do not support wildcards. Unlike
     * field-restricted queries, exact-match filters are case-sensitive.
     *
     * * `feature_id`: Supports = comparisons.
     * * `description`: Supports = comparisons. Multi-token filters should be
     * enclosed in quotes.
     * * `entity_type_id`: Supports = comparisons.
     * * `value_type`: Supports = and != comparisons.
     * * `labels`: Supports key-value equality as well as key presence.
     * * `featurestore_id`: Supports = comparisons.
     *
     * Examples:
     *
     * * `description = "foo bar"` --&gt; Any Feature with description exactly equal
     * to `foo bar`
     * * `value_type = DOUBLE` --&gt; Features whose type is DOUBLE.
     * * `labels.active = yes AND labels.env = prod` --&gt; Features having both
     *     (active: yes) and (env: prod) labels.
     * * `labels.env: *` --&gt; Any Feature which has a label with `env` as the
     *   key.
     * </pre>
     *
     * <code>string query = 3;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearQuery() {
      query_ = getDefaultInstance().getQuery();
      bitField0_ = (bitField0_ & ~0x00000002);
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Query string that is a conjunction of field-restricted queries and/or
     * field-restricted filters.  Field-restricted queries and filters can be
     * combined using `AND` to form a conjunction.
     *
     * A field query is in the form FIELD:QUERY. This implicitly checks if QUERY
     * exists as a substring within Feature's FIELD. The QUERY
     * and the FIELD are converted to a sequence of words (i.e. tokens) for
     * comparison. This is done by:
     *
     *   * Removing leading/trailing whitespace and tokenizing the search value.
     *   Characters that are not one of alphanumeric `[a-zA-Z0-9]`, underscore
     *   `_`, or asterisk `*` are treated as delimiters for tokens. `*` is treated
     *   as a wildcard that matches characters within a token.
     *   * Ignoring case.
     *   * Prepending an asterisk to the first and appending an asterisk to the
     *   last token in QUERY.
     *
     * A QUERY must be either a singular token or a phrase. A phrase is one or
     * multiple words enclosed in double quotation marks ("). With phrases, the
     * order of the words is important. Words in the phrase must be matching in
     * order and consecutively.
     *
     * Supported FIELDs for field-restricted queries:
     *
     * * `feature_id`
     * * `description`
     * * `entity_type_id`
     *
     * Examples:
     *
     * * `feature_id: foo` --&gt; Matches a Feature with ID containing the substring
     * `foo` (eg. `foo`, `foofeature`, `barfoo`).
     * * `feature_id: foo*feature` --&gt; Matches a Feature with ID containing the
     * substring `foo*feature` (eg. `foobarfeature`).
     * * `feature_id: foo AND description: bar` --&gt; Matches a Feature with ID
     * containing the substring `foo` and description containing the substring
     * `bar`.
     *
     *
     * Besides field queries, the following exact-match filters are
     * supported. The exact-match filters do not support wildcards. Unlike
     * field-restricted queries, exact-match filters are case-sensitive.
     *
     * * `feature_id`: Supports = comparisons.
     * * `description`: Supports = comparisons. Multi-token filters should be
     * enclosed in quotes.
     * * `entity_type_id`: Supports = comparisons.
     * * `value_type`: Supports = and != comparisons.
     * * `labels`: Supports key-value equality as well as key presence.
     * * `featurestore_id`: Supports = comparisons.
     *
     * Examples:
     *
     * * `description = "foo bar"` --&gt; Any Feature with description exactly equal
     * to `foo bar`
     * * `value_type = DOUBLE` --&gt; Features whose type is DOUBLE.
     * * `labels.active = yes AND labels.env = prod` --&gt; Features having both
     *     (active: yes) and (env: prod) labels.
     * * `labels.env: *` --&gt; Any Feature which has a label with `env` as the
     *   key.
     * </pre>
     *
     * <code>string query = 3;</code>
     *
     * @param value The bytes for query to set.
     * @return This builder for chaining.
     */
    public Builder setQueryBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      query_ = value;
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }

    private int pageSize_;

    /**
     *
     *
     * <pre>
     * The maximum number of Features to return. The service may return fewer
     * than this value. If unspecified, at most 100 Features will be returned.
     * The maximum value is 100; any value greater than 100 will be coerced to
     * 100.
     * </pre>
     *
     * <code>int32 page_size = 4;</code>
     *
     * @return The pageSize.
     */
    @java.lang.Override
    public int getPageSize() {
      return pageSize_;
    }

    /**
     *
     *
     * <pre>
     * The maximum number of Features to return. The service may return fewer
     * than this value. If unspecified, at most 100 Features will be returned.
     * The maximum value is 100; any value greater than 100 will be coerced to
     * 100.
     * </pre>
     *
     * <code>int32 page_size = 4;</code>
     *
     * @param value The pageSize to set.
     * @return This builder for chaining.
     */
    public Builder setPageSize(int value) {

      pageSize_ = value;
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * The maximum number of Features to return. The service may return fewer
     * than this value. If unspecified, at most 100 Features will be returned.
     * The maximum value is 100; any value greater than 100 will be coerced to
     * 100.
     * </pre>
     *
     * <code>int32 page_size = 4;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearPageSize() {
      bitField0_ = (bitField0_ & ~0x00000004);
      pageSize_ = 0;
      onChanged();
      return this;
    }

    private java.lang.Object pageToken_ = "";

    /**
     *
     *
     * <pre>
     * A page token, received from a previous
     * [FeaturestoreService.SearchFeatures][google.cloud.aiplatform.v1.FeaturestoreService.SearchFeatures]
     * call. Provide this to retrieve the subsequent page.
     *
     * When paginating, all other parameters provided to
     * [FeaturestoreService.SearchFeatures][google.cloud.aiplatform.v1.FeaturestoreService.SearchFeatures],
     * except `page_size`, must match the call that provided the page token.
     * </pre>
     *
     * <code>string page_token = 5;</code>
     *
     * @return The pageToken.
     */
    public java.lang.String getPageToken() {
      java.lang.Object ref = pageToken_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        pageToken_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }

    /**
     *
     *
     * <pre>
     * A page token, received from a previous
     * [FeaturestoreService.SearchFeatures][google.cloud.aiplatform.v1.FeaturestoreService.SearchFeatures]
     * call. Provide this to retrieve the subsequent page.
     *
     * When paginating, all other parameters provided to
     * [FeaturestoreService.SearchFeatures][google.cloud.aiplatform.v1.FeaturestoreService.SearchFeatures],
     * except `page_size`, must match the call that provided the page token.
     * </pre>
     *
     * <code>string page_token = 5;</code>
     *
     * @return The bytes for pageToken.
     */
    public com.google.protobuf.ByteString getPageTokenBytes() {
      java.lang.Object ref = pageToken_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        pageToken_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    /**
     *
     *
     * <pre>
     * A page token, received from a previous
     * [FeaturestoreService.SearchFeatures][google.cloud.aiplatform.v1.FeaturestoreService.SearchFeatures]
     * call. Provide this to retrieve the subsequent page.
     *
     * When paginating, all other parameters provided to
     * [FeaturestoreService.SearchFeatures][google.cloud.aiplatform.v1.FeaturestoreService.SearchFeatures],
     * except `page_size`, must match the call that provided the page token.
     * </pre>
     *
     * <code>string page_token = 5;</code>
     *
     * @param value The pageToken to set.
     * @return This builder for chaining.
     */
    public Builder setPageToken(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      pageToken_ = value;
      bitField0_ |= 0x00000008;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * A page token, received from a previous
     * [FeaturestoreService.SearchFeatures][google.cloud.aiplatform.v1.FeaturestoreService.SearchFeatures]
     * call. Provide this to retrieve the subsequent page.
     *
     * When paginating, all other parameters provided to
     * [FeaturestoreService.SearchFeatures][google.cloud.aiplatform.v1.FeaturestoreService.SearchFeatures],
     * except `page_size`, must match the call that provided the page token.
     * </pre>
     *
     * <code>string page_token = 5;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearPageToken() {
      pageToken_ = getDefaultInstance().getPageToken();
      bitField0_ = (bitField0_ & ~0x00000008);
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * A page token, received from a previous
     * [FeaturestoreService.SearchFeatures][google.cloud.aiplatform.v1.FeaturestoreService.SearchFeatures]
     * call. Provide this to retrieve the subsequent page.
     *
     * When paginating, all other parameters provided to
     * [FeaturestoreService.SearchFeatures][google.cloud.aiplatform.v1.FeaturestoreService.SearchFeatures],
     * except `page_size`, must match the call that provided the page token.
     * </pre>
     *
     * <code>string page_token = 5;</code>
     *
     * @param value The bytes for pageToken to set.
     * @return This builder for chaining.
     */
    public Builder setPageTokenBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      pageToken_ = value;
      bitField0_ |= 0x00000008;
      onChanged();
      return this;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.cloud.aiplatform.v1.SearchFeaturesRequest)
  }

  // @@protoc_insertion_point(class_scope:google.cloud.aiplatform.v1.SearchFeaturesRequest)
  private static final com.google.cloud.aiplatform.v1.SearchFeaturesRequest DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.cloud.aiplatform.v1.SearchFeaturesRequest();
  }

  public static com.google.cloud.aiplatform.v1.SearchFeaturesRequest getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<SearchFeaturesRequest> PARSER =
      new com.google.protobuf.AbstractParser<SearchFeaturesRequest>() {
        @java.lang.Override
        public SearchFeaturesRequest parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          Builder builder = newBuilder();
          try {
            builder.mergeFrom(input, extensionRegistry);
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.setUnfinishedMessage(builder.buildPartial());
          } catch (com.google.protobuf.UninitializedMessageException e) {
            throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
          } catch (java.io.IOException e) {
            throw new com.google.protobuf.InvalidProtocolBufferException(e)
                .setUnfinishedMessage(builder.buildPartial());
          }
          return builder.buildPartial();
        }
      };

  public static com.google.protobuf.Parser<SearchFeaturesRequest> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<SearchFeaturesRequest> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.cloud.aiplatform.v1.SearchFeaturesRequest getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
