/*
 * Copyright 2025 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/cloud/aiplatform/v1/tool.proto

// Protobuf Java Version: 3.25.8
package com.google.cloud.aiplatform.v1;

/**
 *
 *
 * <pre>
 * Retrieve from Vertex RAG Store for grounding.
 * </pre>
 *
 * Protobuf type {@code google.cloud.aiplatform.v1.VertexRagStore}
 */
public final class VertexRagStore extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.cloud.aiplatform.v1.VertexRagStore)
    VertexRagStoreOrBuilder {
  private static final long serialVersionUID = 0L;

  // Use VertexRagStore.newBuilder() to construct.
  private VertexRagStore(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private VertexRagStore() {
    ragResources_ = java.util.Collections.emptyList();
  }

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new VertexRagStore();
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.cloud.aiplatform.v1.ToolProto
        .internal_static_google_cloud_aiplatform_v1_VertexRagStore_descriptor;
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.cloud.aiplatform.v1.ToolProto
        .internal_static_google_cloud_aiplatform_v1_VertexRagStore_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.cloud.aiplatform.v1.VertexRagStore.class,
            com.google.cloud.aiplatform.v1.VertexRagStore.Builder.class);
  }

  public interface RagResourceOrBuilder
      extends
      // @@protoc_insertion_point(interface_extends:google.cloud.aiplatform.v1.VertexRagStore.RagResource)
      com.google.protobuf.MessageOrBuilder {

    /**
     *
     *
     * <pre>
     * Optional. RagCorpora resource name.
     * Format:
     * `projects/{project}/locations/{location}/ragCorpora/{rag_corpus}`
     * </pre>
     *
     * <code>
     * string rag_corpus = 1 [(.google.api.field_behavior) = OPTIONAL, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @return The ragCorpus.
     */
    java.lang.String getRagCorpus();

    /**
     *
     *
     * <pre>
     * Optional. RagCorpora resource name.
     * Format:
     * `projects/{project}/locations/{location}/ragCorpora/{rag_corpus}`
     * </pre>
     *
     * <code>
     * string rag_corpus = 1 [(.google.api.field_behavior) = OPTIONAL, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @return The bytes for ragCorpus.
     */
    com.google.protobuf.ByteString getRagCorpusBytes();

    /**
     *
     *
     * <pre>
     * Optional. rag_file_id. The files should be in the same rag_corpus set in
     * rag_corpus field.
     * </pre>
     *
     * <code>repeated string rag_file_ids = 2 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return A list containing the ragFileIds.
     */
    java.util.List<java.lang.String> getRagFileIdsList();

    /**
     *
     *
     * <pre>
     * Optional. rag_file_id. The files should be in the same rag_corpus set in
     * rag_corpus field.
     * </pre>
     *
     * <code>repeated string rag_file_ids = 2 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return The count of ragFileIds.
     */
    int getRagFileIdsCount();

    /**
     *
     *
     * <pre>
     * Optional. rag_file_id. The files should be in the same rag_corpus set in
     * rag_corpus field.
     * </pre>
     *
     * <code>repeated string rag_file_ids = 2 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @param index The index of the element to return.
     * @return The ragFileIds at the given index.
     */
    java.lang.String getRagFileIds(int index);

    /**
     *
     *
     * <pre>
     * Optional. rag_file_id. The files should be in the same rag_corpus set in
     * rag_corpus field.
     * </pre>
     *
     * <code>repeated string rag_file_ids = 2 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @param index The index of the value to return.
     * @return The bytes of the ragFileIds at the given index.
     */
    com.google.protobuf.ByteString getRagFileIdsBytes(int index);
  }

  /**
   *
   *
   * <pre>
   * The definition of the Rag resource.
   * </pre>
   *
   * Protobuf type {@code google.cloud.aiplatform.v1.VertexRagStore.RagResource}
   */
  public static final class RagResource extends com.google.protobuf.GeneratedMessageV3
      implements
      // @@protoc_insertion_point(message_implements:google.cloud.aiplatform.v1.VertexRagStore.RagResource)
      RagResourceOrBuilder {
    private static final long serialVersionUID = 0L;

    // Use RagResource.newBuilder() to construct.
    private RagResource(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
      super(builder);
    }

    private RagResource() {
      ragCorpus_ = "";
      ragFileIds_ = com.google.protobuf.LazyStringArrayList.emptyList();
    }

    @java.lang.Override
    @SuppressWarnings({"unused"})
    protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
      return new RagResource();
    }

    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.aiplatform.v1.ToolProto
          .internal_static_google_cloud_aiplatform_v1_VertexRagStore_RagResource_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.aiplatform.v1.ToolProto
          .internal_static_google_cloud_aiplatform_v1_VertexRagStore_RagResource_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.aiplatform.v1.VertexRagStore.RagResource.class,
              com.google.cloud.aiplatform.v1.VertexRagStore.RagResource.Builder.class);
    }

    public static final int RAG_CORPUS_FIELD_NUMBER = 1;

    @SuppressWarnings("serial")
    private volatile java.lang.Object ragCorpus_ = "";

    /**
     *
     *
     * <pre>
     * Optional. RagCorpora resource name.
     * Format:
     * `projects/{project}/locations/{location}/ragCorpora/{rag_corpus}`
     * </pre>
     *
     * <code>
     * string rag_corpus = 1 [(.google.api.field_behavior) = OPTIONAL, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @return The ragCorpus.
     */
    @java.lang.Override
    public java.lang.String getRagCorpus() {
      java.lang.Object ref = ragCorpus_;
      if (ref instanceof java.lang.String) {
        return (java.lang.String) ref;
      } else {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        ragCorpus_ = s;
        return s;
      }
    }

    /**
     *
     *
     * <pre>
     * Optional. RagCorpora resource name.
     * Format:
     * `projects/{project}/locations/{location}/ragCorpora/{rag_corpus}`
     * </pre>
     *
     * <code>
     * string rag_corpus = 1 [(.google.api.field_behavior) = OPTIONAL, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @return The bytes for ragCorpus.
     */
    @java.lang.Override
    public com.google.protobuf.ByteString getRagCorpusBytes() {
      java.lang.Object ref = ragCorpus_;
      if (ref instanceof java.lang.String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        ragCorpus_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    public static final int RAG_FILE_IDS_FIELD_NUMBER = 2;

    @SuppressWarnings("serial")
    private com.google.protobuf.LazyStringArrayList ragFileIds_ =
        com.google.protobuf.LazyStringArrayList.emptyList();

    /**
     *
     *
     * <pre>
     * Optional. rag_file_id. The files should be in the same rag_corpus set in
     * rag_corpus field.
     * </pre>
     *
     * <code>repeated string rag_file_ids = 2 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return A list containing the ragFileIds.
     */
    public com.google.protobuf.ProtocolStringList getRagFileIdsList() {
      return ragFileIds_;
    }

    /**
     *
     *
     * <pre>
     * Optional. rag_file_id. The files should be in the same rag_corpus set in
     * rag_corpus field.
     * </pre>
     *
     * <code>repeated string rag_file_ids = 2 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return The count of ragFileIds.
     */
    public int getRagFileIdsCount() {
      return ragFileIds_.size();
    }

    /**
     *
     *
     * <pre>
     * Optional. rag_file_id. The files should be in the same rag_corpus set in
     * rag_corpus field.
     * </pre>
     *
     * <code>repeated string rag_file_ids = 2 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @param index The index of the element to return.
     * @return The ragFileIds at the given index.
     */
    public java.lang.String getRagFileIds(int index) {
      return ragFileIds_.get(index);
    }

    /**
     *
     *
     * <pre>
     * Optional. rag_file_id. The files should be in the same rag_corpus set in
     * rag_corpus field.
     * </pre>
     *
     * <code>repeated string rag_file_ids = 2 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @param index The index of the value to return.
     * @return The bytes of the ragFileIds at the given index.
     */
    public com.google.protobuf.ByteString getRagFileIdsBytes(int index) {
      return ragFileIds_.getByteString(index);
    }

    private byte memoizedIsInitialized = -1;

    @java.lang.Override
    public final boolean isInitialized() {
      byte isInitialized = memoizedIsInitialized;
      if (isInitialized == 1) return true;
      if (isInitialized == 0) return false;

      memoizedIsInitialized = 1;
      return true;
    }

    @java.lang.Override
    public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(ragCorpus_)) {
        com.google.protobuf.GeneratedMessageV3.writeString(output, 1, ragCorpus_);
      }
      for (int i = 0; i < ragFileIds_.size(); i++) {
        com.google.protobuf.GeneratedMessageV3.writeString(output, 2, ragFileIds_.getRaw(i));
      }
      getUnknownFields().writeTo(output);
    }

    @java.lang.Override
    public int getSerializedSize() {
      int size = memoizedSize;
      if (size != -1) return size;

      size = 0;
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(ragCorpus_)) {
        size += com.google.protobuf.GeneratedMessageV3.computeStringSize(1, ragCorpus_);
      }
      {
        int dataSize = 0;
        for (int i = 0; i < ragFileIds_.size(); i++) {
          dataSize += computeStringSizeNoTag(ragFileIds_.getRaw(i));
        }
        size += dataSize;
        size += 1 * getRagFileIdsList().size();
      }
      size += getUnknownFields().getSerializedSize();
      memoizedSize = size;
      return size;
    }

    @java.lang.Override
    public boolean equals(final java.lang.Object obj) {
      if (obj == this) {
        return true;
      }
      if (!(obj instanceof com.google.cloud.aiplatform.v1.VertexRagStore.RagResource)) {
        return super.equals(obj);
      }
      com.google.cloud.aiplatform.v1.VertexRagStore.RagResource other =
          (com.google.cloud.aiplatform.v1.VertexRagStore.RagResource) obj;

      if (!getRagCorpus().equals(other.getRagCorpus())) return false;
      if (!getRagFileIdsList().equals(other.getRagFileIdsList())) return false;
      if (!getUnknownFields().equals(other.getUnknownFields())) return false;
      return true;
    }

    @java.lang.Override
    public int hashCode() {
      if (memoizedHashCode != 0) {
        return memoizedHashCode;
      }
      int hash = 41;
      hash = (19 * hash) + getDescriptor().hashCode();
      hash = (37 * hash) + RAG_CORPUS_FIELD_NUMBER;
      hash = (53 * hash) + getRagCorpus().hashCode();
      if (getRagFileIdsCount() > 0) {
        hash = (37 * hash) + RAG_FILE_IDS_FIELD_NUMBER;
        hash = (53 * hash) + getRagFileIdsList().hashCode();
      }
      hash = (29 * hash) + getUnknownFields().hashCode();
      memoizedHashCode = hash;
      return hash;
    }

    public static com.google.cloud.aiplatform.v1.VertexRagStore.RagResource parseFrom(
        java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.aiplatform.v1.VertexRagStore.RagResource parseFrom(
        java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.aiplatform.v1.VertexRagStore.RagResource parseFrom(
        com.google.protobuf.ByteString data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.aiplatform.v1.VertexRagStore.RagResource parseFrom(
        com.google.protobuf.ByteString data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.aiplatform.v1.VertexRagStore.RagResource parseFrom(byte[] data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.aiplatform.v1.VertexRagStore.RagResource parseFrom(
        byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.aiplatform.v1.VertexRagStore.RagResource parseFrom(
        java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.cloud.aiplatform.v1.VertexRagStore.RagResource parseFrom(
        java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.cloud.aiplatform.v1.VertexRagStore.RagResource parseDelimitedFrom(
        java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
    }

    public static com.google.cloud.aiplatform.v1.VertexRagStore.RagResource parseDelimitedFrom(
        java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.cloud.aiplatform.v1.VertexRagStore.RagResource parseFrom(
        com.google.protobuf.CodedInputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.cloud.aiplatform.v1.VertexRagStore.RagResource parseFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    @java.lang.Override
    public Builder newBuilderForType() {
      return newBuilder();
    }

    public static Builder newBuilder() {
      return DEFAULT_INSTANCE.toBuilder();
    }

    public static Builder newBuilder(
        com.google.cloud.aiplatform.v1.VertexRagStore.RagResource prototype) {
      return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }

    @java.lang.Override
    public Builder toBuilder() {
      return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
    }

    @java.lang.Override
    protected Builder newBuilderForType(
        com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      Builder builder = new Builder(parent);
      return builder;
    }

    /**
     *
     *
     * <pre>
     * The definition of the Rag resource.
     * </pre>
     *
     * Protobuf type {@code google.cloud.aiplatform.v1.VertexRagStore.RagResource}
     */
    public static final class Builder
        extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
        implements
        // @@protoc_insertion_point(builder_implements:google.cloud.aiplatform.v1.VertexRagStore.RagResource)
        com.google.cloud.aiplatform.v1.VertexRagStore.RagResourceOrBuilder {
      public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
        return com.google.cloud.aiplatform.v1.ToolProto
            .internal_static_google_cloud_aiplatform_v1_VertexRagStore_RagResource_descriptor;
      }

      @java.lang.Override
      protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return com.google.cloud.aiplatform.v1.ToolProto
            .internal_static_google_cloud_aiplatform_v1_VertexRagStore_RagResource_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                com.google.cloud.aiplatform.v1.VertexRagStore.RagResource.class,
                com.google.cloud.aiplatform.v1.VertexRagStore.RagResource.Builder.class);
      }

      // Construct using com.google.cloud.aiplatform.v1.VertexRagStore.RagResource.newBuilder()
      private Builder() {}

      private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
        super(parent);
      }

      @java.lang.Override
      public Builder clear() {
        super.clear();
        bitField0_ = 0;
        ragCorpus_ = "";
        ragFileIds_ = com.google.protobuf.LazyStringArrayList.emptyList();
        return this;
      }

      @java.lang.Override
      public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
        return com.google.cloud.aiplatform.v1.ToolProto
            .internal_static_google_cloud_aiplatform_v1_VertexRagStore_RagResource_descriptor;
      }

      @java.lang.Override
      public com.google.cloud.aiplatform.v1.VertexRagStore.RagResource getDefaultInstanceForType() {
        return com.google.cloud.aiplatform.v1.VertexRagStore.RagResource.getDefaultInstance();
      }

      @java.lang.Override
      public com.google.cloud.aiplatform.v1.VertexRagStore.RagResource build() {
        com.google.cloud.aiplatform.v1.VertexRagStore.RagResource result = buildPartial();
        if (!result.isInitialized()) {
          throw newUninitializedMessageException(result);
        }
        return result;
      }

      @java.lang.Override
      public com.google.cloud.aiplatform.v1.VertexRagStore.RagResource buildPartial() {
        com.google.cloud.aiplatform.v1.VertexRagStore.RagResource result =
            new com.google.cloud.aiplatform.v1.VertexRagStore.RagResource(this);
        if (bitField0_ != 0) {
          buildPartial0(result);
        }
        onBuilt();
        return result;
      }

      private void buildPartial0(com.google.cloud.aiplatform.v1.VertexRagStore.RagResource result) {
        int from_bitField0_ = bitField0_;
        if (((from_bitField0_ & 0x00000001) != 0)) {
          result.ragCorpus_ = ragCorpus_;
        }
        if (((from_bitField0_ & 0x00000002) != 0)) {
          ragFileIds_.makeImmutable();
          result.ragFileIds_ = ragFileIds_;
        }
      }

      @java.lang.Override
      public Builder clone() {
        return super.clone();
      }

      @java.lang.Override
      public Builder setField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.setField(field, value);
      }

      @java.lang.Override
      public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
        return super.clearField(field);
      }

      @java.lang.Override
      public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
        return super.clearOneof(oneof);
      }

      @java.lang.Override
      public Builder setRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          int index,
          java.lang.Object value) {
        return super.setRepeatedField(field, index, value);
      }

      @java.lang.Override
      public Builder addRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.addRepeatedField(field, value);
      }

      @java.lang.Override
      public Builder mergeFrom(com.google.protobuf.Message other) {
        if (other instanceof com.google.cloud.aiplatform.v1.VertexRagStore.RagResource) {
          return mergeFrom((com.google.cloud.aiplatform.v1.VertexRagStore.RagResource) other);
        } else {
          super.mergeFrom(other);
          return this;
        }
      }

      public Builder mergeFrom(com.google.cloud.aiplatform.v1.VertexRagStore.RagResource other) {
        if (other == com.google.cloud.aiplatform.v1.VertexRagStore.RagResource.getDefaultInstance())
          return this;
        if (!other.getRagCorpus().isEmpty()) {
          ragCorpus_ = other.ragCorpus_;
          bitField0_ |= 0x00000001;
          onChanged();
        }
        if (!other.ragFileIds_.isEmpty()) {
          if (ragFileIds_.isEmpty()) {
            ragFileIds_ = other.ragFileIds_;
            bitField0_ |= 0x00000002;
          } else {
            ensureRagFileIdsIsMutable();
            ragFileIds_.addAll(other.ragFileIds_);
          }
          onChanged();
        }
        this.mergeUnknownFields(other.getUnknownFields());
        onChanged();
        return this;
      }

      @java.lang.Override
      public final boolean isInitialized() {
        return true;
      }

      @java.lang.Override
      public Builder mergeFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        if (extensionRegistry == null) {
          throw new java.lang.NullPointerException();
        }
        try {
          boolean done = false;
          while (!done) {
            int tag = input.readTag();
            switch (tag) {
              case 0:
                done = true;
                break;
              case 10:
                {
                  ragCorpus_ = input.readStringRequireUtf8();
                  bitField0_ |= 0x00000001;
                  break;
                } // case 10
              case 18:
                {
                  java.lang.String s = input.readStringRequireUtf8();
                  ensureRagFileIdsIsMutable();
                  ragFileIds_.add(s);
                  break;
                } // case 18
              default:
                {
                  if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                    done = true; // was an endgroup tag
                  }
                  break;
                } // default:
            } // switch (tag)
          } // while (!done)
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          throw e.unwrapIOException();
        } finally {
          onChanged();
        } // finally
        return this;
      }

      private int bitField0_;

      private java.lang.Object ragCorpus_ = "";

      /**
       *
       *
       * <pre>
       * Optional. RagCorpora resource name.
       * Format:
       * `projects/{project}/locations/{location}/ragCorpora/{rag_corpus}`
       * </pre>
       *
       * <code>
       * string rag_corpus = 1 [(.google.api.field_behavior) = OPTIONAL, (.google.api.resource_reference) = { ... }
       * </code>
       *
       * @return The ragCorpus.
       */
      public java.lang.String getRagCorpus() {
        java.lang.Object ref = ragCorpus_;
        if (!(ref instanceof java.lang.String)) {
          com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
          java.lang.String s = bs.toStringUtf8();
          ragCorpus_ = s;
          return s;
        } else {
          return (java.lang.String) ref;
        }
      }

      /**
       *
       *
       * <pre>
       * Optional. RagCorpora resource name.
       * Format:
       * `projects/{project}/locations/{location}/ragCorpora/{rag_corpus}`
       * </pre>
       *
       * <code>
       * string rag_corpus = 1 [(.google.api.field_behavior) = OPTIONAL, (.google.api.resource_reference) = { ... }
       * </code>
       *
       * @return The bytes for ragCorpus.
       */
      public com.google.protobuf.ByteString getRagCorpusBytes() {
        java.lang.Object ref = ragCorpus_;
        if (ref instanceof String) {
          com.google.protobuf.ByteString b =
              com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
          ragCorpus_ = b;
          return b;
        } else {
          return (com.google.protobuf.ByteString) ref;
        }
      }

      /**
       *
       *
       * <pre>
       * Optional. RagCorpora resource name.
       * Format:
       * `projects/{project}/locations/{location}/ragCorpora/{rag_corpus}`
       * </pre>
       *
       * <code>
       * string rag_corpus = 1 [(.google.api.field_behavior) = OPTIONAL, (.google.api.resource_reference) = { ... }
       * </code>
       *
       * @param value The ragCorpus to set.
       * @return This builder for chaining.
       */
      public Builder setRagCorpus(java.lang.String value) {
        if (value == null) {
          throw new NullPointerException();
        }
        ragCorpus_ = value;
        bitField0_ |= 0x00000001;
        onChanged();
        return this;
      }

      /**
       *
       *
       * <pre>
       * Optional. RagCorpora resource name.
       * Format:
       * `projects/{project}/locations/{location}/ragCorpora/{rag_corpus}`
       * </pre>
       *
       * <code>
       * string rag_corpus = 1 [(.google.api.field_behavior) = OPTIONAL, (.google.api.resource_reference) = { ... }
       * </code>
       *
       * @return This builder for chaining.
       */
      public Builder clearRagCorpus() {
        ragCorpus_ = getDefaultInstance().getRagCorpus();
        bitField0_ = (bitField0_ & ~0x00000001);
        onChanged();
        return this;
      }

      /**
       *
       *
       * <pre>
       * Optional. RagCorpora resource name.
       * Format:
       * `projects/{project}/locations/{location}/ragCorpora/{rag_corpus}`
       * </pre>
       *
       * <code>
       * string rag_corpus = 1 [(.google.api.field_behavior) = OPTIONAL, (.google.api.resource_reference) = { ... }
       * </code>
       *
       * @param value The bytes for ragCorpus to set.
       * @return This builder for chaining.
       */
      public Builder setRagCorpusBytes(com.google.protobuf.ByteString value) {
        if (value == null) {
          throw new NullPointerException();
        }
        checkByteStringIsUtf8(value);
        ragCorpus_ = value;
        bitField0_ |= 0x00000001;
        onChanged();
        return this;
      }

      private com.google.protobuf.LazyStringArrayList ragFileIds_ =
          com.google.protobuf.LazyStringArrayList.emptyList();

      private void ensureRagFileIdsIsMutable() {
        if (!ragFileIds_.isModifiable()) {
          ragFileIds_ = new com.google.protobuf.LazyStringArrayList(ragFileIds_);
        }
        bitField0_ |= 0x00000002;
      }

      /**
       *
       *
       * <pre>
       * Optional. rag_file_id. The files should be in the same rag_corpus set in
       * rag_corpus field.
       * </pre>
       *
       * <code>repeated string rag_file_ids = 2 [(.google.api.field_behavior) = OPTIONAL];</code>
       *
       * @return A list containing the ragFileIds.
       */
      public com.google.protobuf.ProtocolStringList getRagFileIdsList() {
        ragFileIds_.makeImmutable();
        return ragFileIds_;
      }

      /**
       *
       *
       * <pre>
       * Optional. rag_file_id. The files should be in the same rag_corpus set in
       * rag_corpus field.
       * </pre>
       *
       * <code>repeated string rag_file_ids = 2 [(.google.api.field_behavior) = OPTIONAL];</code>
       *
       * @return The count of ragFileIds.
       */
      public int getRagFileIdsCount() {
        return ragFileIds_.size();
      }

      /**
       *
       *
       * <pre>
       * Optional. rag_file_id. The files should be in the same rag_corpus set in
       * rag_corpus field.
       * </pre>
       *
       * <code>repeated string rag_file_ids = 2 [(.google.api.field_behavior) = OPTIONAL];</code>
       *
       * @param index The index of the element to return.
       * @return The ragFileIds at the given index.
       */
      public java.lang.String getRagFileIds(int index) {
        return ragFileIds_.get(index);
      }

      /**
       *
       *
       * <pre>
       * Optional. rag_file_id. The files should be in the same rag_corpus set in
       * rag_corpus field.
       * </pre>
       *
       * <code>repeated string rag_file_ids = 2 [(.google.api.field_behavior) = OPTIONAL];</code>
       *
       * @param index The index of the value to return.
       * @return The bytes of the ragFileIds at the given index.
       */
      public com.google.protobuf.ByteString getRagFileIdsBytes(int index) {
        return ragFileIds_.getByteString(index);
      }

      /**
       *
       *
       * <pre>
       * Optional. rag_file_id. The files should be in the same rag_corpus set in
       * rag_corpus field.
       * </pre>
       *
       * <code>repeated string rag_file_ids = 2 [(.google.api.field_behavior) = OPTIONAL];</code>
       *
       * @param index The index to set the value at.
       * @param value The ragFileIds to set.
       * @return This builder for chaining.
       */
      public Builder setRagFileIds(int index, java.lang.String value) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureRagFileIdsIsMutable();
        ragFileIds_.set(index, value);
        bitField0_ |= 0x00000002;
        onChanged();
        return this;
      }

      /**
       *
       *
       * <pre>
       * Optional. rag_file_id. The files should be in the same rag_corpus set in
       * rag_corpus field.
       * </pre>
       *
       * <code>repeated string rag_file_ids = 2 [(.google.api.field_behavior) = OPTIONAL];</code>
       *
       * @param value The ragFileIds to add.
       * @return This builder for chaining.
       */
      public Builder addRagFileIds(java.lang.String value) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureRagFileIdsIsMutable();
        ragFileIds_.add(value);
        bitField0_ |= 0x00000002;
        onChanged();
        return this;
      }

      /**
       *
       *
       * <pre>
       * Optional. rag_file_id. The files should be in the same rag_corpus set in
       * rag_corpus field.
       * </pre>
       *
       * <code>repeated string rag_file_ids = 2 [(.google.api.field_behavior) = OPTIONAL];</code>
       *
       * @param values The ragFileIds to add.
       * @return This builder for chaining.
       */
      public Builder addAllRagFileIds(java.lang.Iterable<java.lang.String> values) {
        ensureRagFileIdsIsMutable();
        com.google.protobuf.AbstractMessageLite.Builder.addAll(values, ragFileIds_);
        bitField0_ |= 0x00000002;
        onChanged();
        return this;
      }

      /**
       *
       *
       * <pre>
       * Optional. rag_file_id. The files should be in the same rag_corpus set in
       * rag_corpus field.
       * </pre>
       *
       * <code>repeated string rag_file_ids = 2 [(.google.api.field_behavior) = OPTIONAL];</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearRagFileIds() {
        ragFileIds_ = com.google.protobuf.LazyStringArrayList.emptyList();
        bitField0_ = (bitField0_ & ~0x00000002);
        ;
        onChanged();
        return this;
      }

      /**
       *
       *
       * <pre>
       * Optional. rag_file_id. The files should be in the same rag_corpus set in
       * rag_corpus field.
       * </pre>
       *
       * <code>repeated string rag_file_ids = 2 [(.google.api.field_behavior) = OPTIONAL];</code>
       *
       * @param value The bytes of the ragFileIds to add.
       * @return This builder for chaining.
       */
      public Builder addRagFileIdsBytes(com.google.protobuf.ByteString value) {
        if (value == null) {
          throw new NullPointerException();
        }
        checkByteStringIsUtf8(value);
        ensureRagFileIdsIsMutable();
        ragFileIds_.add(value);
        bitField0_ |= 0x00000002;
        onChanged();
        return this;
      }

      @java.lang.Override
      public final Builder setUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.setUnknownFields(unknownFields);
      }

      @java.lang.Override
      public final Builder mergeUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.mergeUnknownFields(unknownFields);
      }

      // @@protoc_insertion_point(builder_scope:google.cloud.aiplatform.v1.VertexRagStore.RagResource)
    }

    // @@protoc_insertion_point(class_scope:google.cloud.aiplatform.v1.VertexRagStore.RagResource)
    private static final com.google.cloud.aiplatform.v1.VertexRagStore.RagResource DEFAULT_INSTANCE;

    static {
      DEFAULT_INSTANCE = new com.google.cloud.aiplatform.v1.VertexRagStore.RagResource();
    }

    public static com.google.cloud.aiplatform.v1.VertexRagStore.RagResource getDefaultInstance() {
      return DEFAULT_INSTANCE;
    }

    private static final com.google.protobuf.Parser<RagResource> PARSER =
        new com.google.protobuf.AbstractParser<RagResource>() {
          @java.lang.Override
          public RagResource parsePartialFrom(
              com.google.protobuf.CodedInputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
            Builder builder = newBuilder();
            try {
              builder.mergeFrom(input, extensionRegistry);
            } catch (com.google.protobuf.InvalidProtocolBufferException e) {
              throw e.setUnfinishedMessage(builder.buildPartial());
            } catch (com.google.protobuf.UninitializedMessageException e) {
              throw e.asInvalidProtocolBufferException()
                  .setUnfinishedMessage(builder.buildPartial());
            } catch (java.io.IOException e) {
              throw new com.google.protobuf.InvalidProtocolBufferException(e)
                  .setUnfinishedMessage(builder.buildPartial());
            }
            return builder.buildPartial();
          }
        };

    public static com.google.protobuf.Parser<RagResource> parser() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.protobuf.Parser<RagResource> getParserForType() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.cloud.aiplatform.v1.VertexRagStore.RagResource getDefaultInstanceForType() {
      return DEFAULT_INSTANCE;
    }
  }

  private int bitField0_;
  public static final int RAG_RESOURCES_FIELD_NUMBER = 4;

  @SuppressWarnings("serial")
  private java.util.List<com.google.cloud.aiplatform.v1.VertexRagStore.RagResource> ragResources_;

  /**
   *
   *
   * <pre>
   * Optional. The representation of the rag source. It can be used to specify
   * corpus only or ragfiles. Currently only support one corpus or multiple
   * files from one corpus. In the future we may open up multiple corpora
   * support.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.aiplatform.v1.VertexRagStore.RagResource rag_resources = 4 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   */
  @java.lang.Override
  public java.util.List<com.google.cloud.aiplatform.v1.VertexRagStore.RagResource>
      getRagResourcesList() {
    return ragResources_;
  }

  /**
   *
   *
   * <pre>
   * Optional. The representation of the rag source. It can be used to specify
   * corpus only or ragfiles. Currently only support one corpus or multiple
   * files from one corpus. In the future we may open up multiple corpora
   * support.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.aiplatform.v1.VertexRagStore.RagResource rag_resources = 4 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   */
  @java.lang.Override
  public java.util.List<
          ? extends com.google.cloud.aiplatform.v1.VertexRagStore.RagResourceOrBuilder>
      getRagResourcesOrBuilderList() {
    return ragResources_;
  }

  /**
   *
   *
   * <pre>
   * Optional. The representation of the rag source. It can be used to specify
   * corpus only or ragfiles. Currently only support one corpus or multiple
   * files from one corpus. In the future we may open up multiple corpora
   * support.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.aiplatform.v1.VertexRagStore.RagResource rag_resources = 4 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   */
  @java.lang.Override
  public int getRagResourcesCount() {
    return ragResources_.size();
  }

  /**
   *
   *
   * <pre>
   * Optional. The representation of the rag source. It can be used to specify
   * corpus only or ragfiles. Currently only support one corpus or multiple
   * files from one corpus. In the future we may open up multiple corpora
   * support.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.aiplatform.v1.VertexRagStore.RagResource rag_resources = 4 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.aiplatform.v1.VertexRagStore.RagResource getRagResources(int index) {
    return ragResources_.get(index);
  }

  /**
   *
   *
   * <pre>
   * Optional. The representation of the rag source. It can be used to specify
   * corpus only or ragfiles. Currently only support one corpus or multiple
   * files from one corpus. In the future we may open up multiple corpora
   * support.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.aiplatform.v1.VertexRagStore.RagResource rag_resources = 4 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.aiplatform.v1.VertexRagStore.RagResourceOrBuilder
      getRagResourcesOrBuilder(int index) {
    return ragResources_.get(index);
  }

  public static final int SIMILARITY_TOP_K_FIELD_NUMBER = 2;
  private int similarityTopK_ = 0;

  /**
   *
   *
   * <pre>
   * Optional. Number of top k results to return from the selected corpora.
   * </pre>
   *
   * <code>
   * optional int32 similarity_top_k = 2 [deprecated = true, (.google.api.field_behavior) = OPTIONAL];
   * </code>
   *
   * @deprecated google.cloud.aiplatform.v1.VertexRagStore.similarity_top_k is deprecated. See
   *     google/cloud/aiplatform/v1/tool.proto;l=304
   * @return Whether the similarityTopK field is set.
   */
  @java.lang.Override
  @java.lang.Deprecated
  public boolean hasSimilarityTopK() {
    return ((bitField0_ & 0x00000001) != 0);
  }

  /**
   *
   *
   * <pre>
   * Optional. Number of top k results to return from the selected corpora.
   * </pre>
   *
   * <code>
   * optional int32 similarity_top_k = 2 [deprecated = true, (.google.api.field_behavior) = OPTIONAL];
   * </code>
   *
   * @deprecated google.cloud.aiplatform.v1.VertexRagStore.similarity_top_k is deprecated. See
   *     google/cloud/aiplatform/v1/tool.proto;l=304
   * @return The similarityTopK.
   */
  @java.lang.Override
  @java.lang.Deprecated
  public int getSimilarityTopK() {
    return similarityTopK_;
  }

  public static final int VECTOR_DISTANCE_THRESHOLD_FIELD_NUMBER = 3;
  private double vectorDistanceThreshold_ = 0D;

  /**
   *
   *
   * <pre>
   * Optional. Only return results with vector distance smaller than the
   * threshold.
   * </pre>
   *
   * <code>
   * optional double vector_distance_threshold = 3 [deprecated = true, (.google.api.field_behavior) = OPTIONAL];
   * </code>
   *
   * @deprecated google.cloud.aiplatform.v1.VertexRagStore.vector_distance_threshold is deprecated.
   *     See google/cloud/aiplatform/v1/tool.proto;l=309
   * @return Whether the vectorDistanceThreshold field is set.
   */
  @java.lang.Override
  @java.lang.Deprecated
  public boolean hasVectorDistanceThreshold() {
    return ((bitField0_ & 0x00000002) != 0);
  }

  /**
   *
   *
   * <pre>
   * Optional. Only return results with vector distance smaller than the
   * threshold.
   * </pre>
   *
   * <code>
   * optional double vector_distance_threshold = 3 [deprecated = true, (.google.api.field_behavior) = OPTIONAL];
   * </code>
   *
   * @deprecated google.cloud.aiplatform.v1.VertexRagStore.vector_distance_threshold is deprecated.
   *     See google/cloud/aiplatform/v1/tool.proto;l=309
   * @return The vectorDistanceThreshold.
   */
  @java.lang.Override
  @java.lang.Deprecated
  public double getVectorDistanceThreshold() {
    return vectorDistanceThreshold_;
  }

  public static final int RAG_RETRIEVAL_CONFIG_FIELD_NUMBER = 6;
  private com.google.cloud.aiplatform.v1.RagRetrievalConfig ragRetrievalConfig_;

  /**
   *
   *
   * <pre>
   * Optional. The retrieval config for the Rag query.
   * </pre>
   *
   * <code>
   * .google.cloud.aiplatform.v1.RagRetrievalConfig rag_retrieval_config = 6 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   *
   * @return Whether the ragRetrievalConfig field is set.
   */
  @java.lang.Override
  public boolean hasRagRetrievalConfig() {
    return ((bitField0_ & 0x00000004) != 0);
  }

  /**
   *
   *
   * <pre>
   * Optional. The retrieval config for the Rag query.
   * </pre>
   *
   * <code>
   * .google.cloud.aiplatform.v1.RagRetrievalConfig rag_retrieval_config = 6 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   *
   * @return The ragRetrievalConfig.
   */
  @java.lang.Override
  public com.google.cloud.aiplatform.v1.RagRetrievalConfig getRagRetrievalConfig() {
    return ragRetrievalConfig_ == null
        ? com.google.cloud.aiplatform.v1.RagRetrievalConfig.getDefaultInstance()
        : ragRetrievalConfig_;
  }

  /**
   *
   *
   * <pre>
   * Optional. The retrieval config for the Rag query.
   * </pre>
   *
   * <code>
   * .google.cloud.aiplatform.v1.RagRetrievalConfig rag_retrieval_config = 6 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.aiplatform.v1.RagRetrievalConfigOrBuilder
      getRagRetrievalConfigOrBuilder() {
    return ragRetrievalConfig_ == null
        ? com.google.cloud.aiplatform.v1.RagRetrievalConfig.getDefaultInstance()
        : ragRetrievalConfig_;
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    if (((bitField0_ & 0x00000001) != 0)) {
      output.writeInt32(2, similarityTopK_);
    }
    if (((bitField0_ & 0x00000002) != 0)) {
      output.writeDouble(3, vectorDistanceThreshold_);
    }
    for (int i = 0; i < ragResources_.size(); i++) {
      output.writeMessage(4, ragResources_.get(i));
    }
    if (((bitField0_ & 0x00000004) != 0)) {
      output.writeMessage(6, getRagRetrievalConfig());
    }
    getUnknownFields().writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    if (((bitField0_ & 0x00000001) != 0)) {
      size += com.google.protobuf.CodedOutputStream.computeInt32Size(2, similarityTopK_);
    }
    if (((bitField0_ & 0x00000002) != 0)) {
      size += com.google.protobuf.CodedOutputStream.computeDoubleSize(3, vectorDistanceThreshold_);
    }
    for (int i = 0; i < ragResources_.size(); i++) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(4, ragResources_.get(i));
    }
    if (((bitField0_ & 0x00000004) != 0)) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(6, getRagRetrievalConfig());
    }
    size += getUnknownFields().getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.cloud.aiplatform.v1.VertexRagStore)) {
      return super.equals(obj);
    }
    com.google.cloud.aiplatform.v1.VertexRagStore other =
        (com.google.cloud.aiplatform.v1.VertexRagStore) obj;

    if (!getRagResourcesList().equals(other.getRagResourcesList())) return false;
    if (hasSimilarityTopK() != other.hasSimilarityTopK()) return false;
    if (hasSimilarityTopK()) {
      if (getSimilarityTopK() != other.getSimilarityTopK()) return false;
    }
    if (hasVectorDistanceThreshold() != other.hasVectorDistanceThreshold()) return false;
    if (hasVectorDistanceThreshold()) {
      if (java.lang.Double.doubleToLongBits(getVectorDistanceThreshold())
          != java.lang.Double.doubleToLongBits(other.getVectorDistanceThreshold())) return false;
    }
    if (hasRagRetrievalConfig() != other.hasRagRetrievalConfig()) return false;
    if (hasRagRetrievalConfig()) {
      if (!getRagRetrievalConfig().equals(other.getRagRetrievalConfig())) return false;
    }
    if (!getUnknownFields().equals(other.getUnknownFields())) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    if (getRagResourcesCount() > 0) {
      hash = (37 * hash) + RAG_RESOURCES_FIELD_NUMBER;
      hash = (53 * hash) + getRagResourcesList().hashCode();
    }
    if (hasSimilarityTopK()) {
      hash = (37 * hash) + SIMILARITY_TOP_K_FIELD_NUMBER;
      hash = (53 * hash) + getSimilarityTopK();
    }
    if (hasVectorDistanceThreshold()) {
      hash = (37 * hash) + VECTOR_DISTANCE_THRESHOLD_FIELD_NUMBER;
      hash =
          (53 * hash)
              + com.google.protobuf.Internal.hashLong(
                  java.lang.Double.doubleToLongBits(getVectorDistanceThreshold()));
    }
    if (hasRagRetrievalConfig()) {
      hash = (37 * hash) + RAG_RETRIEVAL_CONFIG_FIELD_NUMBER;
      hash = (53 * hash) + getRagRetrievalConfig().hashCode();
    }
    hash = (29 * hash) + getUnknownFields().hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.cloud.aiplatform.v1.VertexRagStore parseFrom(java.nio.ByteBuffer data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.aiplatform.v1.VertexRagStore parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.aiplatform.v1.VertexRagStore parseFrom(
      com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.aiplatform.v1.VertexRagStore parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.aiplatform.v1.VertexRagStore parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.aiplatform.v1.VertexRagStore parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.aiplatform.v1.VertexRagStore parseFrom(java.io.InputStream input)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.aiplatform.v1.VertexRagStore parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.aiplatform.v1.VertexRagStore parseDelimitedFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.cloud.aiplatform.v1.VertexRagStore parseDelimitedFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.aiplatform.v1.VertexRagStore parseFrom(
      com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.aiplatform.v1.VertexRagStore parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(com.google.cloud.aiplatform.v1.VertexRagStore prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }

  /**
   *
   *
   * <pre>
   * Retrieve from Vertex RAG Store for grounding.
   * </pre>
   *
   * Protobuf type {@code google.cloud.aiplatform.v1.VertexRagStore}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.cloud.aiplatform.v1.VertexRagStore)
      com.google.cloud.aiplatform.v1.VertexRagStoreOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.aiplatform.v1.ToolProto
          .internal_static_google_cloud_aiplatform_v1_VertexRagStore_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.aiplatform.v1.ToolProto
          .internal_static_google_cloud_aiplatform_v1_VertexRagStore_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.aiplatform.v1.VertexRagStore.class,
              com.google.cloud.aiplatform.v1.VertexRagStore.Builder.class);
    }

    // Construct using com.google.cloud.aiplatform.v1.VertexRagStore.newBuilder()
    private Builder() {
      maybeForceBuilderInitialization();
    }

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
      maybeForceBuilderInitialization();
    }

    private void maybeForceBuilderInitialization() {
      if (com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders) {
        getRagResourcesFieldBuilder();
        getRagRetrievalConfigFieldBuilder();
      }
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      bitField0_ = 0;
      if (ragResourcesBuilder_ == null) {
        ragResources_ = java.util.Collections.emptyList();
      } else {
        ragResources_ = null;
        ragResourcesBuilder_.clear();
      }
      bitField0_ = (bitField0_ & ~0x00000001);
      similarityTopK_ = 0;
      vectorDistanceThreshold_ = 0D;
      ragRetrievalConfig_ = null;
      if (ragRetrievalConfigBuilder_ != null) {
        ragRetrievalConfigBuilder_.dispose();
        ragRetrievalConfigBuilder_ = null;
      }
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.cloud.aiplatform.v1.ToolProto
          .internal_static_google_cloud_aiplatform_v1_VertexRagStore_descriptor;
    }

    @java.lang.Override
    public com.google.cloud.aiplatform.v1.VertexRagStore getDefaultInstanceForType() {
      return com.google.cloud.aiplatform.v1.VertexRagStore.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.cloud.aiplatform.v1.VertexRagStore build() {
      com.google.cloud.aiplatform.v1.VertexRagStore result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.cloud.aiplatform.v1.VertexRagStore buildPartial() {
      com.google.cloud.aiplatform.v1.VertexRagStore result =
          new com.google.cloud.aiplatform.v1.VertexRagStore(this);
      buildPartialRepeatedFields(result);
      if (bitField0_ != 0) {
        buildPartial0(result);
      }
      onBuilt();
      return result;
    }

    private void buildPartialRepeatedFields(com.google.cloud.aiplatform.v1.VertexRagStore result) {
      if (ragResourcesBuilder_ == null) {
        if (((bitField0_ & 0x00000001) != 0)) {
          ragResources_ = java.util.Collections.unmodifiableList(ragResources_);
          bitField0_ = (bitField0_ & ~0x00000001);
        }
        result.ragResources_ = ragResources_;
      } else {
        result.ragResources_ = ragResourcesBuilder_.build();
      }
    }

    private void buildPartial0(com.google.cloud.aiplatform.v1.VertexRagStore result) {
      int from_bitField0_ = bitField0_;
      int to_bitField0_ = 0;
      if (((from_bitField0_ & 0x00000002) != 0)) {
        result.similarityTopK_ = similarityTopK_;
        to_bitField0_ |= 0x00000001;
      }
      if (((from_bitField0_ & 0x00000004) != 0)) {
        result.vectorDistanceThreshold_ = vectorDistanceThreshold_;
        to_bitField0_ |= 0x00000002;
      }
      if (((from_bitField0_ & 0x00000008) != 0)) {
        result.ragRetrievalConfig_ =
            ragRetrievalConfigBuilder_ == null
                ? ragRetrievalConfig_
                : ragRetrievalConfigBuilder_.build();
        to_bitField0_ |= 0x00000004;
      }
      result.bitField0_ |= to_bitField0_;
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.cloud.aiplatform.v1.VertexRagStore) {
        return mergeFrom((com.google.cloud.aiplatform.v1.VertexRagStore) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(com.google.cloud.aiplatform.v1.VertexRagStore other) {
      if (other == com.google.cloud.aiplatform.v1.VertexRagStore.getDefaultInstance()) return this;
      if (ragResourcesBuilder_ == null) {
        if (!other.ragResources_.isEmpty()) {
          if (ragResources_.isEmpty()) {
            ragResources_ = other.ragResources_;
            bitField0_ = (bitField0_ & ~0x00000001);
          } else {
            ensureRagResourcesIsMutable();
            ragResources_.addAll(other.ragResources_);
          }
          onChanged();
        }
      } else {
        if (!other.ragResources_.isEmpty()) {
          if (ragResourcesBuilder_.isEmpty()) {
            ragResourcesBuilder_.dispose();
            ragResourcesBuilder_ = null;
            ragResources_ = other.ragResources_;
            bitField0_ = (bitField0_ & ~0x00000001);
            ragResourcesBuilder_ =
                com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders
                    ? getRagResourcesFieldBuilder()
                    : null;
          } else {
            ragResourcesBuilder_.addAllMessages(other.ragResources_);
          }
        }
      }
      if (other.hasSimilarityTopK()) {
        setSimilarityTopK(other.getSimilarityTopK());
      }
      if (other.hasVectorDistanceThreshold()) {
        setVectorDistanceThreshold(other.getVectorDistanceThreshold());
      }
      if (other.hasRagRetrievalConfig()) {
        mergeRagRetrievalConfig(other.getRagRetrievalConfig());
      }
      this.mergeUnknownFields(other.getUnknownFields());
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 16:
              {
                similarityTopK_ = input.readInt32();
                bitField0_ |= 0x00000002;
                break;
              } // case 16
            case 25:
              {
                vectorDistanceThreshold_ = input.readDouble();
                bitField0_ |= 0x00000004;
                break;
              } // case 25
            case 34:
              {
                com.google.cloud.aiplatform.v1.VertexRagStore.RagResource m =
                    input.readMessage(
                        com.google.cloud.aiplatform.v1.VertexRagStore.RagResource.parser(),
                        extensionRegistry);
                if (ragResourcesBuilder_ == null) {
                  ensureRagResourcesIsMutable();
                  ragResources_.add(m);
                } else {
                  ragResourcesBuilder_.addMessage(m);
                }
                break;
              } // case 34
            case 50:
              {
                input.readMessage(
                    getRagRetrievalConfigFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000008;
                break;
              } // case 50
            default:
              {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
          } // switch (tag)
        } // while (!done)
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.unwrapIOException();
      } finally {
        onChanged();
      } // finally
      return this;
    }

    private int bitField0_;

    private java.util.List<com.google.cloud.aiplatform.v1.VertexRagStore.RagResource>
        ragResources_ = java.util.Collections.emptyList();

    private void ensureRagResourcesIsMutable() {
      if (!((bitField0_ & 0x00000001) != 0)) {
        ragResources_ =
            new java.util.ArrayList<com.google.cloud.aiplatform.v1.VertexRagStore.RagResource>(
                ragResources_);
        bitField0_ |= 0x00000001;
      }
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.cloud.aiplatform.v1.VertexRagStore.RagResource,
            com.google.cloud.aiplatform.v1.VertexRagStore.RagResource.Builder,
            com.google.cloud.aiplatform.v1.VertexRagStore.RagResourceOrBuilder>
        ragResourcesBuilder_;

    /**
     *
     *
     * <pre>
     * Optional. The representation of the rag source. It can be used to specify
     * corpus only or ragfiles. Currently only support one corpus or multiple
     * files from one corpus. In the future we may open up multiple corpora
     * support.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.aiplatform.v1.VertexRagStore.RagResource rag_resources = 4 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public java.util.List<com.google.cloud.aiplatform.v1.VertexRagStore.RagResource>
        getRagResourcesList() {
      if (ragResourcesBuilder_ == null) {
        return java.util.Collections.unmodifiableList(ragResources_);
      } else {
        return ragResourcesBuilder_.getMessageList();
      }
    }

    /**
     *
     *
     * <pre>
     * Optional. The representation of the rag source. It can be used to specify
     * corpus only or ragfiles. Currently only support one corpus or multiple
     * files from one corpus. In the future we may open up multiple corpora
     * support.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.aiplatform.v1.VertexRagStore.RagResource rag_resources = 4 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public int getRagResourcesCount() {
      if (ragResourcesBuilder_ == null) {
        return ragResources_.size();
      } else {
        return ragResourcesBuilder_.getCount();
      }
    }

    /**
     *
     *
     * <pre>
     * Optional. The representation of the rag source. It can be used to specify
     * corpus only or ragfiles. Currently only support one corpus or multiple
     * files from one corpus. In the future we may open up multiple corpora
     * support.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.aiplatform.v1.VertexRagStore.RagResource rag_resources = 4 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public com.google.cloud.aiplatform.v1.VertexRagStore.RagResource getRagResources(int index) {
      if (ragResourcesBuilder_ == null) {
        return ragResources_.get(index);
      } else {
        return ragResourcesBuilder_.getMessage(index);
      }
    }

    /**
     *
     *
     * <pre>
     * Optional. The representation of the rag source. It can be used to specify
     * corpus only or ragfiles. Currently only support one corpus or multiple
     * files from one corpus. In the future we may open up multiple corpora
     * support.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.aiplatform.v1.VertexRagStore.RagResource rag_resources = 4 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder setRagResources(
        int index, com.google.cloud.aiplatform.v1.VertexRagStore.RagResource value) {
      if (ragResourcesBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureRagResourcesIsMutable();
        ragResources_.set(index, value);
        onChanged();
      } else {
        ragResourcesBuilder_.setMessage(index, value);
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * Optional. The representation of the rag source. It can be used to specify
     * corpus only or ragfiles. Currently only support one corpus or multiple
     * files from one corpus. In the future we may open up multiple corpora
     * support.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.aiplatform.v1.VertexRagStore.RagResource rag_resources = 4 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder setRagResources(
        int index,
        com.google.cloud.aiplatform.v1.VertexRagStore.RagResource.Builder builderForValue) {
      if (ragResourcesBuilder_ == null) {
        ensureRagResourcesIsMutable();
        ragResources_.set(index, builderForValue.build());
        onChanged();
      } else {
        ragResourcesBuilder_.setMessage(index, builderForValue.build());
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * Optional. The representation of the rag source. It can be used to specify
     * corpus only or ragfiles. Currently only support one corpus or multiple
     * files from one corpus. In the future we may open up multiple corpora
     * support.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.aiplatform.v1.VertexRagStore.RagResource rag_resources = 4 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder addRagResources(
        com.google.cloud.aiplatform.v1.VertexRagStore.RagResource value) {
      if (ragResourcesBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureRagResourcesIsMutable();
        ragResources_.add(value);
        onChanged();
      } else {
        ragResourcesBuilder_.addMessage(value);
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * Optional. The representation of the rag source. It can be used to specify
     * corpus only or ragfiles. Currently only support one corpus or multiple
     * files from one corpus. In the future we may open up multiple corpora
     * support.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.aiplatform.v1.VertexRagStore.RagResource rag_resources = 4 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder addRagResources(
        int index, com.google.cloud.aiplatform.v1.VertexRagStore.RagResource value) {
      if (ragResourcesBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureRagResourcesIsMutable();
        ragResources_.add(index, value);
        onChanged();
      } else {
        ragResourcesBuilder_.addMessage(index, value);
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * Optional. The representation of the rag source. It can be used to specify
     * corpus only or ragfiles. Currently only support one corpus or multiple
     * files from one corpus. In the future we may open up multiple corpora
     * support.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.aiplatform.v1.VertexRagStore.RagResource rag_resources = 4 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder addRagResources(
        com.google.cloud.aiplatform.v1.VertexRagStore.RagResource.Builder builderForValue) {
      if (ragResourcesBuilder_ == null) {
        ensureRagResourcesIsMutable();
        ragResources_.add(builderForValue.build());
        onChanged();
      } else {
        ragResourcesBuilder_.addMessage(builderForValue.build());
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * Optional. The representation of the rag source. It can be used to specify
     * corpus only or ragfiles. Currently only support one corpus or multiple
     * files from one corpus. In the future we may open up multiple corpora
     * support.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.aiplatform.v1.VertexRagStore.RagResource rag_resources = 4 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder addRagResources(
        int index,
        com.google.cloud.aiplatform.v1.VertexRagStore.RagResource.Builder builderForValue) {
      if (ragResourcesBuilder_ == null) {
        ensureRagResourcesIsMutable();
        ragResources_.add(index, builderForValue.build());
        onChanged();
      } else {
        ragResourcesBuilder_.addMessage(index, builderForValue.build());
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * Optional. The representation of the rag source. It can be used to specify
     * corpus only or ragfiles. Currently only support one corpus or multiple
     * files from one corpus. In the future we may open up multiple corpora
     * support.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.aiplatform.v1.VertexRagStore.RagResource rag_resources = 4 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder addAllRagResources(
        java.lang.Iterable<? extends com.google.cloud.aiplatform.v1.VertexRagStore.RagResource>
            values) {
      if (ragResourcesBuilder_ == null) {
        ensureRagResourcesIsMutable();
        com.google.protobuf.AbstractMessageLite.Builder.addAll(values, ragResources_);
        onChanged();
      } else {
        ragResourcesBuilder_.addAllMessages(values);
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * Optional. The representation of the rag source. It can be used to specify
     * corpus only or ragfiles. Currently only support one corpus or multiple
     * files from one corpus. In the future we may open up multiple corpora
     * support.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.aiplatform.v1.VertexRagStore.RagResource rag_resources = 4 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder clearRagResources() {
      if (ragResourcesBuilder_ == null) {
        ragResources_ = java.util.Collections.emptyList();
        bitField0_ = (bitField0_ & ~0x00000001);
        onChanged();
      } else {
        ragResourcesBuilder_.clear();
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * Optional. The representation of the rag source. It can be used to specify
     * corpus only or ragfiles. Currently only support one corpus or multiple
     * files from one corpus. In the future we may open up multiple corpora
     * support.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.aiplatform.v1.VertexRagStore.RagResource rag_resources = 4 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder removeRagResources(int index) {
      if (ragResourcesBuilder_ == null) {
        ensureRagResourcesIsMutable();
        ragResources_.remove(index);
        onChanged();
      } else {
        ragResourcesBuilder_.remove(index);
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * Optional. The representation of the rag source. It can be used to specify
     * corpus only or ragfiles. Currently only support one corpus or multiple
     * files from one corpus. In the future we may open up multiple corpora
     * support.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.aiplatform.v1.VertexRagStore.RagResource rag_resources = 4 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public com.google.cloud.aiplatform.v1.VertexRagStore.RagResource.Builder getRagResourcesBuilder(
        int index) {
      return getRagResourcesFieldBuilder().getBuilder(index);
    }

    /**
     *
     *
     * <pre>
     * Optional. The representation of the rag source. It can be used to specify
     * corpus only or ragfiles. Currently only support one corpus or multiple
     * files from one corpus. In the future we may open up multiple corpora
     * support.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.aiplatform.v1.VertexRagStore.RagResource rag_resources = 4 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public com.google.cloud.aiplatform.v1.VertexRagStore.RagResourceOrBuilder
        getRagResourcesOrBuilder(int index) {
      if (ragResourcesBuilder_ == null) {
        return ragResources_.get(index);
      } else {
        return ragResourcesBuilder_.getMessageOrBuilder(index);
      }
    }

    /**
     *
     *
     * <pre>
     * Optional. The representation of the rag source. It can be used to specify
     * corpus only or ragfiles. Currently only support one corpus or multiple
     * files from one corpus. In the future we may open up multiple corpora
     * support.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.aiplatform.v1.VertexRagStore.RagResource rag_resources = 4 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public java.util.List<
            ? extends com.google.cloud.aiplatform.v1.VertexRagStore.RagResourceOrBuilder>
        getRagResourcesOrBuilderList() {
      if (ragResourcesBuilder_ != null) {
        return ragResourcesBuilder_.getMessageOrBuilderList();
      } else {
        return java.util.Collections.unmodifiableList(ragResources_);
      }
    }

    /**
     *
     *
     * <pre>
     * Optional. The representation of the rag source. It can be used to specify
     * corpus only or ragfiles. Currently only support one corpus or multiple
     * files from one corpus. In the future we may open up multiple corpora
     * support.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.aiplatform.v1.VertexRagStore.RagResource rag_resources = 4 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public com.google.cloud.aiplatform.v1.VertexRagStore.RagResource.Builder
        addRagResourcesBuilder() {
      return getRagResourcesFieldBuilder()
          .addBuilder(
              com.google.cloud.aiplatform.v1.VertexRagStore.RagResource.getDefaultInstance());
    }

    /**
     *
     *
     * <pre>
     * Optional. The representation of the rag source. It can be used to specify
     * corpus only or ragfiles. Currently only support one corpus or multiple
     * files from one corpus. In the future we may open up multiple corpora
     * support.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.aiplatform.v1.VertexRagStore.RagResource rag_resources = 4 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public com.google.cloud.aiplatform.v1.VertexRagStore.RagResource.Builder addRagResourcesBuilder(
        int index) {
      return getRagResourcesFieldBuilder()
          .addBuilder(
              index,
              com.google.cloud.aiplatform.v1.VertexRagStore.RagResource.getDefaultInstance());
    }

    /**
     *
     *
     * <pre>
     * Optional. The representation of the rag source. It can be used to specify
     * corpus only or ragfiles. Currently only support one corpus or multiple
     * files from one corpus. In the future we may open up multiple corpora
     * support.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.aiplatform.v1.VertexRagStore.RagResource rag_resources = 4 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public java.util.List<com.google.cloud.aiplatform.v1.VertexRagStore.RagResource.Builder>
        getRagResourcesBuilderList() {
      return getRagResourcesFieldBuilder().getBuilderList();
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.cloud.aiplatform.v1.VertexRagStore.RagResource,
            com.google.cloud.aiplatform.v1.VertexRagStore.RagResource.Builder,
            com.google.cloud.aiplatform.v1.VertexRagStore.RagResourceOrBuilder>
        getRagResourcesFieldBuilder() {
      if (ragResourcesBuilder_ == null) {
        ragResourcesBuilder_ =
            new com.google.protobuf.RepeatedFieldBuilderV3<
                com.google.cloud.aiplatform.v1.VertexRagStore.RagResource,
                com.google.cloud.aiplatform.v1.VertexRagStore.RagResource.Builder,
                com.google.cloud.aiplatform.v1.VertexRagStore.RagResourceOrBuilder>(
                ragResources_, ((bitField0_ & 0x00000001) != 0), getParentForChildren(), isClean());
        ragResources_ = null;
      }
      return ragResourcesBuilder_;
    }

    private int similarityTopK_;

    /**
     *
     *
     * <pre>
     * Optional. Number of top k results to return from the selected corpora.
     * </pre>
     *
     * <code>
     * optional int32 similarity_top_k = 2 [deprecated = true, (.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @deprecated google.cloud.aiplatform.v1.VertexRagStore.similarity_top_k is deprecated. See
     *     google/cloud/aiplatform/v1/tool.proto;l=304
     * @return Whether the similarityTopK field is set.
     */
    @java.lang.Override
    @java.lang.Deprecated
    public boolean hasSimilarityTopK() {
      return ((bitField0_ & 0x00000002) != 0);
    }

    /**
     *
     *
     * <pre>
     * Optional. Number of top k results to return from the selected corpora.
     * </pre>
     *
     * <code>
     * optional int32 similarity_top_k = 2 [deprecated = true, (.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @deprecated google.cloud.aiplatform.v1.VertexRagStore.similarity_top_k is deprecated. See
     *     google/cloud/aiplatform/v1/tool.proto;l=304
     * @return The similarityTopK.
     */
    @java.lang.Override
    @java.lang.Deprecated
    public int getSimilarityTopK() {
      return similarityTopK_;
    }

    /**
     *
     *
     * <pre>
     * Optional. Number of top k results to return from the selected corpora.
     * </pre>
     *
     * <code>
     * optional int32 similarity_top_k = 2 [deprecated = true, (.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @deprecated google.cloud.aiplatform.v1.VertexRagStore.similarity_top_k is deprecated. See
     *     google/cloud/aiplatform/v1/tool.proto;l=304
     * @param value The similarityTopK to set.
     * @return This builder for chaining.
     */
    @java.lang.Deprecated
    public Builder setSimilarityTopK(int value) {

      similarityTopK_ = value;
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Optional. Number of top k results to return from the selected corpora.
     * </pre>
     *
     * <code>
     * optional int32 similarity_top_k = 2 [deprecated = true, (.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @deprecated google.cloud.aiplatform.v1.VertexRagStore.similarity_top_k is deprecated. See
     *     google/cloud/aiplatform/v1/tool.proto;l=304
     * @return This builder for chaining.
     */
    @java.lang.Deprecated
    public Builder clearSimilarityTopK() {
      bitField0_ = (bitField0_ & ~0x00000002);
      similarityTopK_ = 0;
      onChanged();
      return this;
    }

    private double vectorDistanceThreshold_;

    /**
     *
     *
     * <pre>
     * Optional. Only return results with vector distance smaller than the
     * threshold.
     * </pre>
     *
     * <code>
     * optional double vector_distance_threshold = 3 [deprecated = true, (.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @deprecated google.cloud.aiplatform.v1.VertexRagStore.vector_distance_threshold is
     *     deprecated. See google/cloud/aiplatform/v1/tool.proto;l=309
     * @return Whether the vectorDistanceThreshold field is set.
     */
    @java.lang.Override
    @java.lang.Deprecated
    public boolean hasVectorDistanceThreshold() {
      return ((bitField0_ & 0x00000004) != 0);
    }

    /**
     *
     *
     * <pre>
     * Optional. Only return results with vector distance smaller than the
     * threshold.
     * </pre>
     *
     * <code>
     * optional double vector_distance_threshold = 3 [deprecated = true, (.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @deprecated google.cloud.aiplatform.v1.VertexRagStore.vector_distance_threshold is
     *     deprecated. See google/cloud/aiplatform/v1/tool.proto;l=309
     * @return The vectorDistanceThreshold.
     */
    @java.lang.Override
    @java.lang.Deprecated
    public double getVectorDistanceThreshold() {
      return vectorDistanceThreshold_;
    }

    /**
     *
     *
     * <pre>
     * Optional. Only return results with vector distance smaller than the
     * threshold.
     * </pre>
     *
     * <code>
     * optional double vector_distance_threshold = 3 [deprecated = true, (.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @deprecated google.cloud.aiplatform.v1.VertexRagStore.vector_distance_threshold is
     *     deprecated. See google/cloud/aiplatform/v1/tool.proto;l=309
     * @param value The vectorDistanceThreshold to set.
     * @return This builder for chaining.
     */
    @java.lang.Deprecated
    public Builder setVectorDistanceThreshold(double value) {

      vectorDistanceThreshold_ = value;
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Optional. Only return results with vector distance smaller than the
     * threshold.
     * </pre>
     *
     * <code>
     * optional double vector_distance_threshold = 3 [deprecated = true, (.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @deprecated google.cloud.aiplatform.v1.VertexRagStore.vector_distance_threshold is
     *     deprecated. See google/cloud/aiplatform/v1/tool.proto;l=309
     * @return This builder for chaining.
     */
    @java.lang.Deprecated
    public Builder clearVectorDistanceThreshold() {
      bitField0_ = (bitField0_ & ~0x00000004);
      vectorDistanceThreshold_ = 0D;
      onChanged();
      return this;
    }

    private com.google.cloud.aiplatform.v1.RagRetrievalConfig ragRetrievalConfig_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.aiplatform.v1.RagRetrievalConfig,
            com.google.cloud.aiplatform.v1.RagRetrievalConfig.Builder,
            com.google.cloud.aiplatform.v1.RagRetrievalConfigOrBuilder>
        ragRetrievalConfigBuilder_;

    /**
     *
     *
     * <pre>
     * Optional. The retrieval config for the Rag query.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1.RagRetrievalConfig rag_retrieval_config = 6 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return Whether the ragRetrievalConfig field is set.
     */
    public boolean hasRagRetrievalConfig() {
      return ((bitField0_ & 0x00000008) != 0);
    }

    /**
     *
     *
     * <pre>
     * Optional. The retrieval config for the Rag query.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1.RagRetrievalConfig rag_retrieval_config = 6 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return The ragRetrievalConfig.
     */
    public com.google.cloud.aiplatform.v1.RagRetrievalConfig getRagRetrievalConfig() {
      if (ragRetrievalConfigBuilder_ == null) {
        return ragRetrievalConfig_ == null
            ? com.google.cloud.aiplatform.v1.RagRetrievalConfig.getDefaultInstance()
            : ragRetrievalConfig_;
      } else {
        return ragRetrievalConfigBuilder_.getMessage();
      }
    }

    /**
     *
     *
     * <pre>
     * Optional. The retrieval config for the Rag query.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1.RagRetrievalConfig rag_retrieval_config = 6 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder setRagRetrievalConfig(com.google.cloud.aiplatform.v1.RagRetrievalConfig value) {
      if (ragRetrievalConfigBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ragRetrievalConfig_ = value;
      } else {
        ragRetrievalConfigBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000008;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Optional. The retrieval config for the Rag query.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1.RagRetrievalConfig rag_retrieval_config = 6 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder setRagRetrievalConfig(
        com.google.cloud.aiplatform.v1.RagRetrievalConfig.Builder builderForValue) {
      if (ragRetrievalConfigBuilder_ == null) {
        ragRetrievalConfig_ = builderForValue.build();
      } else {
        ragRetrievalConfigBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000008;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Optional. The retrieval config for the Rag query.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1.RagRetrievalConfig rag_retrieval_config = 6 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder mergeRagRetrievalConfig(
        com.google.cloud.aiplatform.v1.RagRetrievalConfig value) {
      if (ragRetrievalConfigBuilder_ == null) {
        if (((bitField0_ & 0x00000008) != 0)
            && ragRetrievalConfig_ != null
            && ragRetrievalConfig_
                != com.google.cloud.aiplatform.v1.RagRetrievalConfig.getDefaultInstance()) {
          getRagRetrievalConfigBuilder().mergeFrom(value);
        } else {
          ragRetrievalConfig_ = value;
        }
      } else {
        ragRetrievalConfigBuilder_.mergeFrom(value);
      }
      if (ragRetrievalConfig_ != null) {
        bitField0_ |= 0x00000008;
        onChanged();
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * Optional. The retrieval config for the Rag query.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1.RagRetrievalConfig rag_retrieval_config = 6 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder clearRagRetrievalConfig() {
      bitField0_ = (bitField0_ & ~0x00000008);
      ragRetrievalConfig_ = null;
      if (ragRetrievalConfigBuilder_ != null) {
        ragRetrievalConfigBuilder_.dispose();
        ragRetrievalConfigBuilder_ = null;
      }
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Optional. The retrieval config for the Rag query.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1.RagRetrievalConfig rag_retrieval_config = 6 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public com.google.cloud.aiplatform.v1.RagRetrievalConfig.Builder
        getRagRetrievalConfigBuilder() {
      bitField0_ |= 0x00000008;
      onChanged();
      return getRagRetrievalConfigFieldBuilder().getBuilder();
    }

    /**
     *
     *
     * <pre>
     * Optional. The retrieval config for the Rag query.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1.RagRetrievalConfig rag_retrieval_config = 6 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public com.google.cloud.aiplatform.v1.RagRetrievalConfigOrBuilder
        getRagRetrievalConfigOrBuilder() {
      if (ragRetrievalConfigBuilder_ != null) {
        return ragRetrievalConfigBuilder_.getMessageOrBuilder();
      } else {
        return ragRetrievalConfig_ == null
            ? com.google.cloud.aiplatform.v1.RagRetrievalConfig.getDefaultInstance()
            : ragRetrievalConfig_;
      }
    }

    /**
     *
     *
     * <pre>
     * Optional. The retrieval config for the Rag query.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1.RagRetrievalConfig rag_retrieval_config = 6 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.aiplatform.v1.RagRetrievalConfig,
            com.google.cloud.aiplatform.v1.RagRetrievalConfig.Builder,
            com.google.cloud.aiplatform.v1.RagRetrievalConfigOrBuilder>
        getRagRetrievalConfigFieldBuilder() {
      if (ragRetrievalConfigBuilder_ == null) {
        ragRetrievalConfigBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.aiplatform.v1.RagRetrievalConfig,
                com.google.cloud.aiplatform.v1.RagRetrievalConfig.Builder,
                com.google.cloud.aiplatform.v1.RagRetrievalConfigOrBuilder>(
                getRagRetrievalConfig(), getParentForChildren(), isClean());
        ragRetrievalConfig_ = null;
      }
      return ragRetrievalConfigBuilder_;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.cloud.aiplatform.v1.VertexRagStore)
  }

  // @@protoc_insertion_point(class_scope:google.cloud.aiplatform.v1.VertexRagStore)
  private static final com.google.cloud.aiplatform.v1.VertexRagStore DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.cloud.aiplatform.v1.VertexRagStore();
  }

  public static com.google.cloud.aiplatform.v1.VertexRagStore getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<VertexRagStore> PARSER =
      new com.google.protobuf.AbstractParser<VertexRagStore>() {
        @java.lang.Override
        public VertexRagStore parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          Builder builder = newBuilder();
          try {
            builder.mergeFrom(input, extensionRegistry);
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.setUnfinishedMessage(builder.buildPartial());
          } catch (com.google.protobuf.UninitializedMessageException e) {
            throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
          } catch (java.io.IOException e) {
            throw new com.google.protobuf.InvalidProtocolBufferException(e)
                .setUnfinishedMessage(builder.buildPartial());
          }
          return builder.buildPartial();
        }
      };

  public static com.google.protobuf.Parser<VertexRagStore> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<VertexRagStore> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.cloud.aiplatform.v1.VertexRagStore getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
