/*
 * Copyright 2025 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/cloud/aiplatform/v1/featurestore_online_service.proto

// Protobuf Java Version: 3.25.8
package com.google.cloud.aiplatform.v1;

/**
 *
 *
 * <pre>
 * Request message for
 * [FeaturestoreOnlineServingService.WriteFeatureValues][google.cloud.aiplatform.v1.FeaturestoreOnlineServingService.WriteFeatureValues].
 * </pre>
 *
 * Protobuf type {@code google.cloud.aiplatform.v1.WriteFeatureValuesRequest}
 */
public final class WriteFeatureValuesRequest extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.cloud.aiplatform.v1.WriteFeatureValuesRequest)
    WriteFeatureValuesRequestOrBuilder {
  private static final long serialVersionUID = 0L;

  // Use WriteFeatureValuesRequest.newBuilder() to construct.
  private WriteFeatureValuesRequest(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private WriteFeatureValuesRequest() {
    entityType_ = "";
    payloads_ = java.util.Collections.emptyList();
  }

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new WriteFeatureValuesRequest();
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.cloud.aiplatform.v1.FeaturestoreOnlineServiceProto
        .internal_static_google_cloud_aiplatform_v1_WriteFeatureValuesRequest_descriptor;
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.cloud.aiplatform.v1.FeaturestoreOnlineServiceProto
        .internal_static_google_cloud_aiplatform_v1_WriteFeatureValuesRequest_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.cloud.aiplatform.v1.WriteFeatureValuesRequest.class,
            com.google.cloud.aiplatform.v1.WriteFeatureValuesRequest.Builder.class);
  }

  public static final int ENTITY_TYPE_FIELD_NUMBER = 1;

  @SuppressWarnings("serial")
  private volatile java.lang.Object entityType_ = "";

  /**
   *
   *
   * <pre>
   * Required. The resource name of the EntityType for the entities being
   * written. Value format:
   * `projects/{project}/locations/{location}/featurestores/
   * {featurestore}/entityTypes/{entityType}`. For example,
   * for a machine learning model predicting user clicks on a website, an
   * EntityType ID could be `user`.
   * </pre>
   *
   * <code>
   * string entity_type = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
   * </code>
   *
   * @return The entityType.
   */
  @java.lang.Override
  public java.lang.String getEntityType() {
    java.lang.Object ref = entityType_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      entityType_ = s;
      return s;
    }
  }

  /**
   *
   *
   * <pre>
   * Required. The resource name of the EntityType for the entities being
   * written. Value format:
   * `projects/{project}/locations/{location}/featurestores/
   * {featurestore}/entityTypes/{entityType}`. For example,
   * for a machine learning model predicting user clicks on a website, an
   * EntityType ID could be `user`.
   * </pre>
   *
   * <code>
   * string entity_type = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
   * </code>
   *
   * @return The bytes for entityType.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getEntityTypeBytes() {
    java.lang.Object ref = entityType_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      entityType_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int PAYLOADS_FIELD_NUMBER = 2;

  @SuppressWarnings("serial")
  private java.util.List<com.google.cloud.aiplatform.v1.WriteFeatureValuesPayload> payloads_;

  /**
   *
   *
   * <pre>
   * Required. The entities to be written. Up to 100,000 feature values can be
   * written across all `payloads`.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.aiplatform.v1.WriteFeatureValuesPayload payloads = 2 [(.google.api.field_behavior) = REQUIRED];
   * </code>
   */
  @java.lang.Override
  public java.util.List<com.google.cloud.aiplatform.v1.WriteFeatureValuesPayload>
      getPayloadsList() {
    return payloads_;
  }

  /**
   *
   *
   * <pre>
   * Required. The entities to be written. Up to 100,000 feature values can be
   * written across all `payloads`.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.aiplatform.v1.WriteFeatureValuesPayload payloads = 2 [(.google.api.field_behavior) = REQUIRED];
   * </code>
   */
  @java.lang.Override
  public java.util.List<? extends com.google.cloud.aiplatform.v1.WriteFeatureValuesPayloadOrBuilder>
      getPayloadsOrBuilderList() {
    return payloads_;
  }

  /**
   *
   *
   * <pre>
   * Required. The entities to be written. Up to 100,000 feature values can be
   * written across all `payloads`.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.aiplatform.v1.WriteFeatureValuesPayload payloads = 2 [(.google.api.field_behavior) = REQUIRED];
   * </code>
   */
  @java.lang.Override
  public int getPayloadsCount() {
    return payloads_.size();
  }

  /**
   *
   *
   * <pre>
   * Required. The entities to be written. Up to 100,000 feature values can be
   * written across all `payloads`.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.aiplatform.v1.WriteFeatureValuesPayload payloads = 2 [(.google.api.field_behavior) = REQUIRED];
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.aiplatform.v1.WriteFeatureValuesPayload getPayloads(int index) {
    return payloads_.get(index);
  }

  /**
   *
   *
   * <pre>
   * Required. The entities to be written. Up to 100,000 feature values can be
   * written across all `payloads`.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.aiplatform.v1.WriteFeatureValuesPayload payloads = 2 [(.google.api.field_behavior) = REQUIRED];
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.aiplatform.v1.WriteFeatureValuesPayloadOrBuilder getPayloadsOrBuilder(
      int index) {
    return payloads_.get(index);
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(entityType_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 1, entityType_);
    }
    for (int i = 0; i < payloads_.size(); i++) {
      output.writeMessage(2, payloads_.get(i));
    }
    getUnknownFields().writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(entityType_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(1, entityType_);
    }
    for (int i = 0; i < payloads_.size(); i++) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(2, payloads_.get(i));
    }
    size += getUnknownFields().getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.cloud.aiplatform.v1.WriteFeatureValuesRequest)) {
      return super.equals(obj);
    }
    com.google.cloud.aiplatform.v1.WriteFeatureValuesRequest other =
        (com.google.cloud.aiplatform.v1.WriteFeatureValuesRequest) obj;

    if (!getEntityType().equals(other.getEntityType())) return false;
    if (!getPayloadsList().equals(other.getPayloadsList())) return false;
    if (!getUnknownFields().equals(other.getUnknownFields())) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    hash = (37 * hash) + ENTITY_TYPE_FIELD_NUMBER;
    hash = (53 * hash) + getEntityType().hashCode();
    if (getPayloadsCount() > 0) {
      hash = (37 * hash) + PAYLOADS_FIELD_NUMBER;
      hash = (53 * hash) + getPayloadsList().hashCode();
    }
    hash = (29 * hash) + getUnknownFields().hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.cloud.aiplatform.v1.WriteFeatureValuesRequest parseFrom(
      java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.aiplatform.v1.WriteFeatureValuesRequest parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.aiplatform.v1.WriteFeatureValuesRequest parseFrom(
      com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.aiplatform.v1.WriteFeatureValuesRequest parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.aiplatform.v1.WriteFeatureValuesRequest parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.aiplatform.v1.WriteFeatureValuesRequest parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.aiplatform.v1.WriteFeatureValuesRequest parseFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.aiplatform.v1.WriteFeatureValuesRequest parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.aiplatform.v1.WriteFeatureValuesRequest parseDelimitedFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.cloud.aiplatform.v1.WriteFeatureValuesRequest parseDelimitedFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.aiplatform.v1.WriteFeatureValuesRequest parseFrom(
      com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.aiplatform.v1.WriteFeatureValuesRequest parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(
      com.google.cloud.aiplatform.v1.WriteFeatureValuesRequest prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }

  /**
   *
   *
   * <pre>
   * Request message for
   * [FeaturestoreOnlineServingService.WriteFeatureValues][google.cloud.aiplatform.v1.FeaturestoreOnlineServingService.WriteFeatureValues].
   * </pre>
   *
   * Protobuf type {@code google.cloud.aiplatform.v1.WriteFeatureValuesRequest}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.cloud.aiplatform.v1.WriteFeatureValuesRequest)
      com.google.cloud.aiplatform.v1.WriteFeatureValuesRequestOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.aiplatform.v1.FeaturestoreOnlineServiceProto
          .internal_static_google_cloud_aiplatform_v1_WriteFeatureValuesRequest_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.aiplatform.v1.FeaturestoreOnlineServiceProto
          .internal_static_google_cloud_aiplatform_v1_WriteFeatureValuesRequest_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.aiplatform.v1.WriteFeatureValuesRequest.class,
              com.google.cloud.aiplatform.v1.WriteFeatureValuesRequest.Builder.class);
    }

    // Construct using com.google.cloud.aiplatform.v1.WriteFeatureValuesRequest.newBuilder()
    private Builder() {}

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      bitField0_ = 0;
      entityType_ = "";
      if (payloadsBuilder_ == null) {
        payloads_ = java.util.Collections.emptyList();
      } else {
        payloads_ = null;
        payloadsBuilder_.clear();
      }
      bitField0_ = (bitField0_ & ~0x00000002);
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.cloud.aiplatform.v1.FeaturestoreOnlineServiceProto
          .internal_static_google_cloud_aiplatform_v1_WriteFeatureValuesRequest_descriptor;
    }

    @java.lang.Override
    public com.google.cloud.aiplatform.v1.WriteFeatureValuesRequest getDefaultInstanceForType() {
      return com.google.cloud.aiplatform.v1.WriteFeatureValuesRequest.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.cloud.aiplatform.v1.WriteFeatureValuesRequest build() {
      com.google.cloud.aiplatform.v1.WriteFeatureValuesRequest result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.cloud.aiplatform.v1.WriteFeatureValuesRequest buildPartial() {
      com.google.cloud.aiplatform.v1.WriteFeatureValuesRequest result =
          new com.google.cloud.aiplatform.v1.WriteFeatureValuesRequest(this);
      buildPartialRepeatedFields(result);
      if (bitField0_ != 0) {
        buildPartial0(result);
      }
      onBuilt();
      return result;
    }

    private void buildPartialRepeatedFields(
        com.google.cloud.aiplatform.v1.WriteFeatureValuesRequest result) {
      if (payloadsBuilder_ == null) {
        if (((bitField0_ & 0x00000002) != 0)) {
          payloads_ = java.util.Collections.unmodifiableList(payloads_);
          bitField0_ = (bitField0_ & ~0x00000002);
        }
        result.payloads_ = payloads_;
      } else {
        result.payloads_ = payloadsBuilder_.build();
      }
    }

    private void buildPartial0(com.google.cloud.aiplatform.v1.WriteFeatureValuesRequest result) {
      int from_bitField0_ = bitField0_;
      if (((from_bitField0_ & 0x00000001) != 0)) {
        result.entityType_ = entityType_;
      }
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.cloud.aiplatform.v1.WriteFeatureValuesRequest) {
        return mergeFrom((com.google.cloud.aiplatform.v1.WriteFeatureValuesRequest) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(com.google.cloud.aiplatform.v1.WriteFeatureValuesRequest other) {
      if (other == com.google.cloud.aiplatform.v1.WriteFeatureValuesRequest.getDefaultInstance())
        return this;
      if (!other.getEntityType().isEmpty()) {
        entityType_ = other.entityType_;
        bitField0_ |= 0x00000001;
        onChanged();
      }
      if (payloadsBuilder_ == null) {
        if (!other.payloads_.isEmpty()) {
          if (payloads_.isEmpty()) {
            payloads_ = other.payloads_;
            bitField0_ = (bitField0_ & ~0x00000002);
          } else {
            ensurePayloadsIsMutable();
            payloads_.addAll(other.payloads_);
          }
          onChanged();
        }
      } else {
        if (!other.payloads_.isEmpty()) {
          if (payloadsBuilder_.isEmpty()) {
            payloadsBuilder_.dispose();
            payloadsBuilder_ = null;
            payloads_ = other.payloads_;
            bitField0_ = (bitField0_ & ~0x00000002);
            payloadsBuilder_ =
                com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders
                    ? getPayloadsFieldBuilder()
                    : null;
          } else {
            payloadsBuilder_.addAllMessages(other.payloads_);
          }
        }
      }
      this.mergeUnknownFields(other.getUnknownFields());
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 10:
              {
                entityType_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000001;
                break;
              } // case 10
            case 18:
              {
                com.google.cloud.aiplatform.v1.WriteFeatureValuesPayload m =
                    input.readMessage(
                        com.google.cloud.aiplatform.v1.WriteFeatureValuesPayload.parser(),
                        extensionRegistry);
                if (payloadsBuilder_ == null) {
                  ensurePayloadsIsMutable();
                  payloads_.add(m);
                } else {
                  payloadsBuilder_.addMessage(m);
                }
                break;
              } // case 18
            default:
              {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
          } // switch (tag)
        } // while (!done)
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.unwrapIOException();
      } finally {
        onChanged();
      } // finally
      return this;
    }

    private int bitField0_;

    private java.lang.Object entityType_ = "";

    /**
     *
     *
     * <pre>
     * Required. The resource name of the EntityType for the entities being
     * written. Value format:
     * `projects/{project}/locations/{location}/featurestores/
     * {featurestore}/entityTypes/{entityType}`. For example,
     * for a machine learning model predicting user clicks on a website, an
     * EntityType ID could be `user`.
     * </pre>
     *
     * <code>
     * string entity_type = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @return The entityType.
     */
    public java.lang.String getEntityType() {
      java.lang.Object ref = entityType_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        entityType_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }

    /**
     *
     *
     * <pre>
     * Required. The resource name of the EntityType for the entities being
     * written. Value format:
     * `projects/{project}/locations/{location}/featurestores/
     * {featurestore}/entityTypes/{entityType}`. For example,
     * for a machine learning model predicting user clicks on a website, an
     * EntityType ID could be `user`.
     * </pre>
     *
     * <code>
     * string entity_type = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @return The bytes for entityType.
     */
    public com.google.protobuf.ByteString getEntityTypeBytes() {
      java.lang.Object ref = entityType_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        entityType_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    /**
     *
     *
     * <pre>
     * Required. The resource name of the EntityType for the entities being
     * written. Value format:
     * `projects/{project}/locations/{location}/featurestores/
     * {featurestore}/entityTypes/{entityType}`. For example,
     * for a machine learning model predicting user clicks on a website, an
     * EntityType ID could be `user`.
     * </pre>
     *
     * <code>
     * string entity_type = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @param value The entityType to set.
     * @return This builder for chaining.
     */
    public Builder setEntityType(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      entityType_ = value;
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Required. The resource name of the EntityType for the entities being
     * written. Value format:
     * `projects/{project}/locations/{location}/featurestores/
     * {featurestore}/entityTypes/{entityType}`. For example,
     * for a machine learning model predicting user clicks on a website, an
     * EntityType ID could be `user`.
     * </pre>
     *
     * <code>
     * string entity_type = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @return This builder for chaining.
     */
    public Builder clearEntityType() {
      entityType_ = getDefaultInstance().getEntityType();
      bitField0_ = (bitField0_ & ~0x00000001);
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Required. The resource name of the EntityType for the entities being
     * written. Value format:
     * `projects/{project}/locations/{location}/featurestores/
     * {featurestore}/entityTypes/{entityType}`. For example,
     * for a machine learning model predicting user clicks on a website, an
     * EntityType ID could be `user`.
     * </pre>
     *
     * <code>
     * string entity_type = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @param value The bytes for entityType to set.
     * @return This builder for chaining.
     */
    public Builder setEntityTypeBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      entityType_ = value;
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }

    private java.util.List<com.google.cloud.aiplatform.v1.WriteFeatureValuesPayload> payloads_ =
        java.util.Collections.emptyList();

    private void ensurePayloadsIsMutable() {
      if (!((bitField0_ & 0x00000002) != 0)) {
        payloads_ =
            new java.util.ArrayList<com.google.cloud.aiplatform.v1.WriteFeatureValuesPayload>(
                payloads_);
        bitField0_ |= 0x00000002;
      }
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.cloud.aiplatform.v1.WriteFeatureValuesPayload,
            com.google.cloud.aiplatform.v1.WriteFeatureValuesPayload.Builder,
            com.google.cloud.aiplatform.v1.WriteFeatureValuesPayloadOrBuilder>
        payloadsBuilder_;

    /**
     *
     *
     * <pre>
     * Required. The entities to be written. Up to 100,000 feature values can be
     * written across all `payloads`.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.aiplatform.v1.WriteFeatureValuesPayload payloads = 2 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public java.util.List<com.google.cloud.aiplatform.v1.WriteFeatureValuesPayload>
        getPayloadsList() {
      if (payloadsBuilder_ == null) {
        return java.util.Collections.unmodifiableList(payloads_);
      } else {
        return payloadsBuilder_.getMessageList();
      }
    }

    /**
     *
     *
     * <pre>
     * Required. The entities to be written. Up to 100,000 feature values can be
     * written across all `payloads`.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.aiplatform.v1.WriteFeatureValuesPayload payloads = 2 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public int getPayloadsCount() {
      if (payloadsBuilder_ == null) {
        return payloads_.size();
      } else {
        return payloadsBuilder_.getCount();
      }
    }

    /**
     *
     *
     * <pre>
     * Required. The entities to be written. Up to 100,000 feature values can be
     * written across all `payloads`.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.aiplatform.v1.WriteFeatureValuesPayload payloads = 2 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public com.google.cloud.aiplatform.v1.WriteFeatureValuesPayload getPayloads(int index) {
      if (payloadsBuilder_ == null) {
        return payloads_.get(index);
      } else {
        return payloadsBuilder_.getMessage(index);
      }
    }

    /**
     *
     *
     * <pre>
     * Required. The entities to be written. Up to 100,000 feature values can be
     * written across all `payloads`.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.aiplatform.v1.WriteFeatureValuesPayload payloads = 2 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public Builder setPayloads(
        int index, com.google.cloud.aiplatform.v1.WriteFeatureValuesPayload value) {
      if (payloadsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensurePayloadsIsMutable();
        payloads_.set(index, value);
        onChanged();
      } else {
        payloadsBuilder_.setMessage(index, value);
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * Required. The entities to be written. Up to 100,000 feature values can be
     * written across all `payloads`.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.aiplatform.v1.WriteFeatureValuesPayload payloads = 2 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public Builder setPayloads(
        int index,
        com.google.cloud.aiplatform.v1.WriteFeatureValuesPayload.Builder builderForValue) {
      if (payloadsBuilder_ == null) {
        ensurePayloadsIsMutable();
        payloads_.set(index, builderForValue.build());
        onChanged();
      } else {
        payloadsBuilder_.setMessage(index, builderForValue.build());
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * Required. The entities to be written. Up to 100,000 feature values can be
     * written across all `payloads`.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.aiplatform.v1.WriteFeatureValuesPayload payloads = 2 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public Builder addPayloads(com.google.cloud.aiplatform.v1.WriteFeatureValuesPayload value) {
      if (payloadsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensurePayloadsIsMutable();
        payloads_.add(value);
        onChanged();
      } else {
        payloadsBuilder_.addMessage(value);
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * Required. The entities to be written. Up to 100,000 feature values can be
     * written across all `payloads`.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.aiplatform.v1.WriteFeatureValuesPayload payloads = 2 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public Builder addPayloads(
        int index, com.google.cloud.aiplatform.v1.WriteFeatureValuesPayload value) {
      if (payloadsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensurePayloadsIsMutable();
        payloads_.add(index, value);
        onChanged();
      } else {
        payloadsBuilder_.addMessage(index, value);
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * Required. The entities to be written. Up to 100,000 feature values can be
     * written across all `payloads`.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.aiplatform.v1.WriteFeatureValuesPayload payloads = 2 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public Builder addPayloads(
        com.google.cloud.aiplatform.v1.WriteFeatureValuesPayload.Builder builderForValue) {
      if (payloadsBuilder_ == null) {
        ensurePayloadsIsMutable();
        payloads_.add(builderForValue.build());
        onChanged();
      } else {
        payloadsBuilder_.addMessage(builderForValue.build());
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * Required. The entities to be written. Up to 100,000 feature values can be
     * written across all `payloads`.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.aiplatform.v1.WriteFeatureValuesPayload payloads = 2 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public Builder addPayloads(
        int index,
        com.google.cloud.aiplatform.v1.WriteFeatureValuesPayload.Builder builderForValue) {
      if (payloadsBuilder_ == null) {
        ensurePayloadsIsMutable();
        payloads_.add(index, builderForValue.build());
        onChanged();
      } else {
        payloadsBuilder_.addMessage(index, builderForValue.build());
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * Required. The entities to be written. Up to 100,000 feature values can be
     * written across all `payloads`.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.aiplatform.v1.WriteFeatureValuesPayload payloads = 2 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public Builder addAllPayloads(
        java.lang.Iterable<? extends com.google.cloud.aiplatform.v1.WriteFeatureValuesPayload>
            values) {
      if (payloadsBuilder_ == null) {
        ensurePayloadsIsMutable();
        com.google.protobuf.AbstractMessageLite.Builder.addAll(values, payloads_);
        onChanged();
      } else {
        payloadsBuilder_.addAllMessages(values);
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * Required. The entities to be written. Up to 100,000 feature values can be
     * written across all `payloads`.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.aiplatform.v1.WriteFeatureValuesPayload payloads = 2 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public Builder clearPayloads() {
      if (payloadsBuilder_ == null) {
        payloads_ = java.util.Collections.emptyList();
        bitField0_ = (bitField0_ & ~0x00000002);
        onChanged();
      } else {
        payloadsBuilder_.clear();
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * Required. The entities to be written. Up to 100,000 feature values can be
     * written across all `payloads`.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.aiplatform.v1.WriteFeatureValuesPayload payloads = 2 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public Builder removePayloads(int index) {
      if (payloadsBuilder_ == null) {
        ensurePayloadsIsMutable();
        payloads_.remove(index);
        onChanged();
      } else {
        payloadsBuilder_.remove(index);
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * Required. The entities to be written. Up to 100,000 feature values can be
     * written across all `payloads`.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.aiplatform.v1.WriteFeatureValuesPayload payloads = 2 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public com.google.cloud.aiplatform.v1.WriteFeatureValuesPayload.Builder getPayloadsBuilder(
        int index) {
      return getPayloadsFieldBuilder().getBuilder(index);
    }

    /**
     *
     *
     * <pre>
     * Required. The entities to be written. Up to 100,000 feature values can be
     * written across all `payloads`.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.aiplatform.v1.WriteFeatureValuesPayload payloads = 2 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public com.google.cloud.aiplatform.v1.WriteFeatureValuesPayloadOrBuilder getPayloadsOrBuilder(
        int index) {
      if (payloadsBuilder_ == null) {
        return payloads_.get(index);
      } else {
        return payloadsBuilder_.getMessageOrBuilder(index);
      }
    }

    /**
     *
     *
     * <pre>
     * Required. The entities to be written. Up to 100,000 feature values can be
     * written across all `payloads`.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.aiplatform.v1.WriteFeatureValuesPayload payloads = 2 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public java.util.List<
            ? extends com.google.cloud.aiplatform.v1.WriteFeatureValuesPayloadOrBuilder>
        getPayloadsOrBuilderList() {
      if (payloadsBuilder_ != null) {
        return payloadsBuilder_.getMessageOrBuilderList();
      } else {
        return java.util.Collections.unmodifiableList(payloads_);
      }
    }

    /**
     *
     *
     * <pre>
     * Required. The entities to be written. Up to 100,000 feature values can be
     * written across all `payloads`.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.aiplatform.v1.WriteFeatureValuesPayload payloads = 2 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public com.google.cloud.aiplatform.v1.WriteFeatureValuesPayload.Builder addPayloadsBuilder() {
      return getPayloadsFieldBuilder()
          .addBuilder(
              com.google.cloud.aiplatform.v1.WriteFeatureValuesPayload.getDefaultInstance());
    }

    /**
     *
     *
     * <pre>
     * Required. The entities to be written. Up to 100,000 feature values can be
     * written across all `payloads`.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.aiplatform.v1.WriteFeatureValuesPayload payloads = 2 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public com.google.cloud.aiplatform.v1.WriteFeatureValuesPayload.Builder addPayloadsBuilder(
        int index) {
      return getPayloadsFieldBuilder()
          .addBuilder(
              index, com.google.cloud.aiplatform.v1.WriteFeatureValuesPayload.getDefaultInstance());
    }

    /**
     *
     *
     * <pre>
     * Required. The entities to be written. Up to 100,000 feature values can be
     * written across all `payloads`.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.aiplatform.v1.WriteFeatureValuesPayload payloads = 2 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public java.util.List<com.google.cloud.aiplatform.v1.WriteFeatureValuesPayload.Builder>
        getPayloadsBuilderList() {
      return getPayloadsFieldBuilder().getBuilderList();
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.cloud.aiplatform.v1.WriteFeatureValuesPayload,
            com.google.cloud.aiplatform.v1.WriteFeatureValuesPayload.Builder,
            com.google.cloud.aiplatform.v1.WriteFeatureValuesPayloadOrBuilder>
        getPayloadsFieldBuilder() {
      if (payloadsBuilder_ == null) {
        payloadsBuilder_ =
            new com.google.protobuf.RepeatedFieldBuilderV3<
                com.google.cloud.aiplatform.v1.WriteFeatureValuesPayload,
                com.google.cloud.aiplatform.v1.WriteFeatureValuesPayload.Builder,
                com.google.cloud.aiplatform.v1.WriteFeatureValuesPayloadOrBuilder>(
                payloads_, ((bitField0_ & 0x00000002) != 0), getParentForChildren(), isClean());
        payloads_ = null;
      }
      return payloadsBuilder_;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.cloud.aiplatform.v1.WriteFeatureValuesRequest)
  }

  // @@protoc_insertion_point(class_scope:google.cloud.aiplatform.v1.WriteFeatureValuesRequest)
  private static final com.google.cloud.aiplatform.v1.WriteFeatureValuesRequest DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.cloud.aiplatform.v1.WriteFeatureValuesRequest();
  }

  public static com.google.cloud.aiplatform.v1.WriteFeatureValuesRequest getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<WriteFeatureValuesRequest> PARSER =
      new com.google.protobuf.AbstractParser<WriteFeatureValuesRequest>() {
        @java.lang.Override
        public WriteFeatureValuesRequest parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          Builder builder = newBuilder();
          try {
            builder.mergeFrom(input, extensionRegistry);
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.setUnfinishedMessage(builder.buildPartial());
          } catch (com.google.protobuf.UninitializedMessageException e) {
            throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
          } catch (java.io.IOException e) {
            throw new com.google.protobuf.InvalidProtocolBufferException(e)
                .setUnfinishedMessage(builder.buildPartial());
          }
          return builder.buildPartial();
        }
      };

  public static com.google.protobuf.Parser<WriteFeatureValuesRequest> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<WriteFeatureValuesRequest> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.cloud.aiplatform.v1.WriteFeatureValuesRequest getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
