/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.aiplatform.v1beta1;

import com.google.api.pathtemplate.PathTemplate;
import com.google.api.resourcenames.ResourceName;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class ArtifactName
implements ResourceName {
    private static final PathTemplate PROJECT_LOCATION_METADATA_STORE_ARTIFACT = PathTemplate.createWithoutUrlEncoding((String)"projects/{project}/locations/{location}/metadataStores/{metadata_store}/artifacts/{artifact}");
    private volatile Map<String, String> fieldValuesMap;
    private final String project;
    private final String location;
    private final String metadataStore;
    private final String artifact;

    @Deprecated
    protected ArtifactName() {
        this.project = null;
        this.location = null;
        this.metadataStore = null;
        this.artifact = null;
    }

    private ArtifactName(Builder builder) {
        this.project = (String)Preconditions.checkNotNull((Object)builder.getProject());
        this.location = (String)Preconditions.checkNotNull((Object)builder.getLocation());
        this.metadataStore = (String)Preconditions.checkNotNull((Object)builder.getMetadataStore());
        this.artifact = (String)Preconditions.checkNotNull((Object)builder.getArtifact());
    }

    public String getProject() {
        return this.project;
    }

    public String getLocation() {
        return this.location;
    }

    public String getMetadataStore() {
        return this.metadataStore;
    }

    public String getArtifact() {
        return this.artifact;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    public static ArtifactName of(String project, String location, String metadataStore, String artifact) {
        return ArtifactName.newBuilder().setProject(project).setLocation(location).setMetadataStore(metadataStore).setArtifact(artifact).build();
    }

    public static String format(String project, String location, String metadataStore, String artifact) {
        return ArtifactName.newBuilder().setProject(project).setLocation(location).setMetadataStore(metadataStore).setArtifact(artifact).build().toString();
    }

    public static ArtifactName parse(String formattedString) {
        if (formattedString.isEmpty()) {
            return null;
        }
        Map matchMap = PROJECT_LOCATION_METADATA_STORE_ARTIFACT.validatedMatch(formattedString, "ArtifactName.parse: formattedString not in valid format");
        return ArtifactName.of((String)matchMap.get("project"), (String)matchMap.get("location"), (String)matchMap.get("metadata_store"), (String)matchMap.get("artifact"));
    }

    public static List<ArtifactName> parseList(List<String> formattedStrings) {
        ArrayList<ArtifactName> list = new ArrayList<ArtifactName>(formattedStrings.size());
        for (String formattedString : formattedStrings) {
            list.add(ArtifactName.parse(formattedString));
        }
        return list;
    }

    public static List<String> toStringList(List<ArtifactName> values) {
        ArrayList<String> list = new ArrayList<String>(values.size());
        for (ArtifactName value : values) {
            if (value == null) {
                list.add("");
                continue;
            }
            list.add(value.toString());
        }
        return list;
    }

    public static boolean isParsableFrom(String formattedString) {
        return PROJECT_LOCATION_METADATA_STORE_ARTIFACT.matches(formattedString);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, String> getFieldValuesMap() {
        if (this.fieldValuesMap == null) {
            ArtifactName artifactName = this;
            synchronized (artifactName) {
                if (this.fieldValuesMap == null) {
                    ImmutableMap.Builder fieldMapBuilder = ImmutableMap.builder();
                    if (this.project != null) {
                        fieldMapBuilder.put((Object)"project", (Object)this.project);
                    }
                    if (this.location != null) {
                        fieldMapBuilder.put((Object)"location", (Object)this.location);
                    }
                    if (this.metadataStore != null) {
                        fieldMapBuilder.put((Object)"metadata_store", (Object)this.metadataStore);
                    }
                    if (this.artifact != null) {
                        fieldMapBuilder.put((Object)"artifact", (Object)this.artifact);
                    }
                    this.fieldValuesMap = fieldMapBuilder.build();
                }
            }
        }
        return this.fieldValuesMap;
    }

    public String getFieldValue(String fieldName) {
        return this.getFieldValuesMap().get(fieldName);
    }

    public String toString() {
        return PROJECT_LOCATION_METADATA_STORE_ARTIFACT.instantiate(new String[]{"project", this.project, "location", this.location, "metadata_store", this.metadataStore, "artifact", this.artifact});
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o != null && this.getClass() == o.getClass()) {
            ArtifactName that = (ArtifactName)o;
            return Objects.equals(this.project, that.project) && Objects.equals(this.location, that.location) && Objects.equals(this.metadataStore, that.metadataStore) && Objects.equals(this.artifact, that.artifact);
        }
        return false;
    }

    public int hashCode() {
        int h = 1;
        h *= 1000003;
        h ^= Objects.hashCode(this.project);
        h *= 1000003;
        h ^= Objects.hashCode(this.location);
        h *= 1000003;
        h ^= Objects.hashCode(this.metadataStore);
        h *= 1000003;
        return h ^= Objects.hashCode(this.artifact);
    }

    public static class Builder {
        private String project;
        private String location;
        private String metadataStore;
        private String artifact;

        protected Builder() {
        }

        public String getProject() {
            return this.project;
        }

        public String getLocation() {
            return this.location;
        }

        public String getMetadataStore() {
            return this.metadataStore;
        }

        public String getArtifact() {
            return this.artifact;
        }

        public Builder setProject(String project) {
            this.project = project;
            return this;
        }

        public Builder setLocation(String location) {
            this.location = location;
            return this;
        }

        public Builder setMetadataStore(String metadataStore) {
            this.metadataStore = metadataStore;
            return this;
        }

        public Builder setArtifact(String artifact) {
            this.artifact = artifact;
            return this;
        }

        private Builder(ArtifactName artifactName) {
            this.project = artifactName.project;
            this.location = artifactName.location;
            this.metadataStore = artifactName.metadataStore;
            this.artifact = artifactName.artifact;
        }

        public ArtifactName build() {
            return new ArtifactName(this);
        }
    }
}

