/*
 * Copyright 2023 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/cloud/aiplatform/v1beta1/feature_group.proto

package com.google.cloud.aiplatform.v1beta1;

/**
 *
 *
 * <pre>
 * Vertex AI Feature Group.
 * </pre>
 *
 * Protobuf type {@code google.cloud.aiplatform.v1beta1.FeatureGroup}
 */
public final class FeatureGroup extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.cloud.aiplatform.v1beta1.FeatureGroup)
    FeatureGroupOrBuilder {
  private static final long serialVersionUID = 0L;
  // Use FeatureGroup.newBuilder() to construct.
  private FeatureGroup(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private FeatureGroup() {
    name_ = "";
    etag_ = "";
    description_ = "";
  }

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new FeatureGroup();
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.cloud.aiplatform.v1beta1.FeatureGroupProto
        .internal_static_google_cloud_aiplatform_v1beta1_FeatureGroup_descriptor;
  }

  @SuppressWarnings({"rawtypes"})
  @java.lang.Override
  protected com.google.protobuf.MapField internalGetMapField(int number) {
    switch (number) {
      case 5:
        return internalGetLabels();
      default:
        throw new RuntimeException("Invalid map field number: " + number);
    }
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.cloud.aiplatform.v1beta1.FeatureGroupProto
        .internal_static_google_cloud_aiplatform_v1beta1_FeatureGroup_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.cloud.aiplatform.v1beta1.FeatureGroup.class,
            com.google.cloud.aiplatform.v1beta1.FeatureGroup.Builder.class);
  }

  public interface BigQueryOrBuilder
      extends
      // @@protoc_insertion_point(interface_extends:google.cloud.aiplatform.v1beta1.FeatureGroup.BigQuery)
      com.google.protobuf.MessageOrBuilder {

    /**
     *
     *
     * <pre>
     * Required. Immutable. The BigQuery source URI that points to either a
     * BigQuery Table or View.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.BigQuerySource big_query_source = 1 [(.google.api.field_behavior) = IMMUTABLE, (.google.api.field_behavior) = REQUIRED];
     * </code>
     *
     * @return Whether the bigQuerySource field is set.
     */
    boolean hasBigQuerySource();
    /**
     *
     *
     * <pre>
     * Required. Immutable. The BigQuery source URI that points to either a
     * BigQuery Table or View.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.BigQuerySource big_query_source = 1 [(.google.api.field_behavior) = IMMUTABLE, (.google.api.field_behavior) = REQUIRED];
     * </code>
     *
     * @return The bigQuerySource.
     */
    com.google.cloud.aiplatform.v1beta1.BigQuerySource getBigQuerySource();
    /**
     *
     *
     * <pre>
     * Required. Immutable. The BigQuery source URI that points to either a
     * BigQuery Table or View.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.BigQuerySource big_query_source = 1 [(.google.api.field_behavior) = IMMUTABLE, (.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    com.google.cloud.aiplatform.v1beta1.BigQuerySourceOrBuilder getBigQuerySourceOrBuilder();

    /**
     *
     *
     * <pre>
     * Optional. Columns to construct entity_id / row keys. Currently only
     * supports 1 entity_id_column. If not provided defaults to `entity_id`.
     * </pre>
     *
     * <code>repeated string entity_id_columns = 2 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return A list containing the entityIdColumns.
     */
    java.util.List<java.lang.String> getEntityIdColumnsList();
    /**
     *
     *
     * <pre>
     * Optional. Columns to construct entity_id / row keys. Currently only
     * supports 1 entity_id_column. If not provided defaults to `entity_id`.
     * </pre>
     *
     * <code>repeated string entity_id_columns = 2 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return The count of entityIdColumns.
     */
    int getEntityIdColumnsCount();
    /**
     *
     *
     * <pre>
     * Optional. Columns to construct entity_id / row keys. Currently only
     * supports 1 entity_id_column. If not provided defaults to `entity_id`.
     * </pre>
     *
     * <code>repeated string entity_id_columns = 2 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @param index The index of the element to return.
     * @return The entityIdColumns at the given index.
     */
    java.lang.String getEntityIdColumns(int index);
    /**
     *
     *
     * <pre>
     * Optional. Columns to construct entity_id / row keys. Currently only
     * supports 1 entity_id_column. If not provided defaults to `entity_id`.
     * </pre>
     *
     * <code>repeated string entity_id_columns = 2 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @param index The index of the value to return.
     * @return The bytes of the entityIdColumns at the given index.
     */
    com.google.protobuf.ByteString getEntityIdColumnsBytes(int index);
  }
  /**
   *
   *
   * <pre>
   * Input source type for BigQuery Tables and Views.
   * </pre>
   *
   * Protobuf type {@code google.cloud.aiplatform.v1beta1.FeatureGroup.BigQuery}
   */
  public static final class BigQuery extends com.google.protobuf.GeneratedMessageV3
      implements
      // @@protoc_insertion_point(message_implements:google.cloud.aiplatform.v1beta1.FeatureGroup.BigQuery)
      BigQueryOrBuilder {
    private static final long serialVersionUID = 0L;
    // Use BigQuery.newBuilder() to construct.
    private BigQuery(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
      super(builder);
    }

    private BigQuery() {
      entityIdColumns_ = com.google.protobuf.LazyStringArrayList.emptyList();
    }

    @java.lang.Override
    @SuppressWarnings({"unused"})
    protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
      return new BigQuery();
    }

    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.aiplatform.v1beta1.FeatureGroupProto
          .internal_static_google_cloud_aiplatform_v1beta1_FeatureGroup_BigQuery_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.aiplatform.v1beta1.FeatureGroupProto
          .internal_static_google_cloud_aiplatform_v1beta1_FeatureGroup_BigQuery_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.aiplatform.v1beta1.FeatureGroup.BigQuery.class,
              com.google.cloud.aiplatform.v1beta1.FeatureGroup.BigQuery.Builder.class);
    }

    public static final int BIG_QUERY_SOURCE_FIELD_NUMBER = 1;
    private com.google.cloud.aiplatform.v1beta1.BigQuerySource bigQuerySource_;
    /**
     *
     *
     * <pre>
     * Required. Immutable. The BigQuery source URI that points to either a
     * BigQuery Table or View.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.BigQuerySource big_query_source = 1 [(.google.api.field_behavior) = IMMUTABLE, (.google.api.field_behavior) = REQUIRED];
     * </code>
     *
     * @return Whether the bigQuerySource field is set.
     */
    @java.lang.Override
    public boolean hasBigQuerySource() {
      return bigQuerySource_ != null;
    }
    /**
     *
     *
     * <pre>
     * Required. Immutable. The BigQuery source URI that points to either a
     * BigQuery Table or View.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.BigQuerySource big_query_source = 1 [(.google.api.field_behavior) = IMMUTABLE, (.google.api.field_behavior) = REQUIRED];
     * </code>
     *
     * @return The bigQuerySource.
     */
    @java.lang.Override
    public com.google.cloud.aiplatform.v1beta1.BigQuerySource getBigQuerySource() {
      return bigQuerySource_ == null
          ? com.google.cloud.aiplatform.v1beta1.BigQuerySource.getDefaultInstance()
          : bigQuerySource_;
    }
    /**
     *
     *
     * <pre>
     * Required. Immutable. The BigQuery source URI that points to either a
     * BigQuery Table or View.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.BigQuerySource big_query_source = 1 [(.google.api.field_behavior) = IMMUTABLE, (.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    @java.lang.Override
    public com.google.cloud.aiplatform.v1beta1.BigQuerySourceOrBuilder
        getBigQuerySourceOrBuilder() {
      return bigQuerySource_ == null
          ? com.google.cloud.aiplatform.v1beta1.BigQuerySource.getDefaultInstance()
          : bigQuerySource_;
    }

    public static final int ENTITY_ID_COLUMNS_FIELD_NUMBER = 2;

    @SuppressWarnings("serial")
    private com.google.protobuf.LazyStringArrayList entityIdColumns_ =
        com.google.protobuf.LazyStringArrayList.emptyList();
    /**
     *
     *
     * <pre>
     * Optional. Columns to construct entity_id / row keys. Currently only
     * supports 1 entity_id_column. If not provided defaults to `entity_id`.
     * </pre>
     *
     * <code>repeated string entity_id_columns = 2 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return A list containing the entityIdColumns.
     */
    public com.google.protobuf.ProtocolStringList getEntityIdColumnsList() {
      return entityIdColumns_;
    }
    /**
     *
     *
     * <pre>
     * Optional. Columns to construct entity_id / row keys. Currently only
     * supports 1 entity_id_column. If not provided defaults to `entity_id`.
     * </pre>
     *
     * <code>repeated string entity_id_columns = 2 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return The count of entityIdColumns.
     */
    public int getEntityIdColumnsCount() {
      return entityIdColumns_.size();
    }
    /**
     *
     *
     * <pre>
     * Optional. Columns to construct entity_id / row keys. Currently only
     * supports 1 entity_id_column. If not provided defaults to `entity_id`.
     * </pre>
     *
     * <code>repeated string entity_id_columns = 2 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @param index The index of the element to return.
     * @return The entityIdColumns at the given index.
     */
    public java.lang.String getEntityIdColumns(int index) {
      return entityIdColumns_.get(index);
    }
    /**
     *
     *
     * <pre>
     * Optional. Columns to construct entity_id / row keys. Currently only
     * supports 1 entity_id_column. If not provided defaults to `entity_id`.
     * </pre>
     *
     * <code>repeated string entity_id_columns = 2 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @param index The index of the value to return.
     * @return The bytes of the entityIdColumns at the given index.
     */
    public com.google.protobuf.ByteString getEntityIdColumnsBytes(int index) {
      return entityIdColumns_.getByteString(index);
    }

    private byte memoizedIsInitialized = -1;

    @java.lang.Override
    public final boolean isInitialized() {
      byte isInitialized = memoizedIsInitialized;
      if (isInitialized == 1) return true;
      if (isInitialized == 0) return false;

      memoizedIsInitialized = 1;
      return true;
    }

    @java.lang.Override
    public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
      if (bigQuerySource_ != null) {
        output.writeMessage(1, getBigQuerySource());
      }
      for (int i = 0; i < entityIdColumns_.size(); i++) {
        com.google.protobuf.GeneratedMessageV3.writeString(output, 2, entityIdColumns_.getRaw(i));
      }
      getUnknownFields().writeTo(output);
    }

    @java.lang.Override
    public int getSerializedSize() {
      int size = memoizedSize;
      if (size != -1) return size;

      size = 0;
      if (bigQuerySource_ != null) {
        size += com.google.protobuf.CodedOutputStream.computeMessageSize(1, getBigQuerySource());
      }
      {
        int dataSize = 0;
        for (int i = 0; i < entityIdColumns_.size(); i++) {
          dataSize += computeStringSizeNoTag(entityIdColumns_.getRaw(i));
        }
        size += dataSize;
        size += 1 * getEntityIdColumnsList().size();
      }
      size += getUnknownFields().getSerializedSize();
      memoizedSize = size;
      return size;
    }

    @java.lang.Override
    public boolean equals(final java.lang.Object obj) {
      if (obj == this) {
        return true;
      }
      if (!(obj instanceof com.google.cloud.aiplatform.v1beta1.FeatureGroup.BigQuery)) {
        return super.equals(obj);
      }
      com.google.cloud.aiplatform.v1beta1.FeatureGroup.BigQuery other =
          (com.google.cloud.aiplatform.v1beta1.FeatureGroup.BigQuery) obj;

      if (hasBigQuerySource() != other.hasBigQuerySource()) return false;
      if (hasBigQuerySource()) {
        if (!getBigQuerySource().equals(other.getBigQuerySource())) return false;
      }
      if (!getEntityIdColumnsList().equals(other.getEntityIdColumnsList())) return false;
      if (!getUnknownFields().equals(other.getUnknownFields())) return false;
      return true;
    }

    @java.lang.Override
    public int hashCode() {
      if (memoizedHashCode != 0) {
        return memoizedHashCode;
      }
      int hash = 41;
      hash = (19 * hash) + getDescriptor().hashCode();
      if (hasBigQuerySource()) {
        hash = (37 * hash) + BIG_QUERY_SOURCE_FIELD_NUMBER;
        hash = (53 * hash) + getBigQuerySource().hashCode();
      }
      if (getEntityIdColumnsCount() > 0) {
        hash = (37 * hash) + ENTITY_ID_COLUMNS_FIELD_NUMBER;
        hash = (53 * hash) + getEntityIdColumnsList().hashCode();
      }
      hash = (29 * hash) + getUnknownFields().hashCode();
      memoizedHashCode = hash;
      return hash;
    }

    public static com.google.cloud.aiplatform.v1beta1.FeatureGroup.BigQuery parseFrom(
        java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.aiplatform.v1beta1.FeatureGroup.BigQuery parseFrom(
        java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.aiplatform.v1beta1.FeatureGroup.BigQuery parseFrom(
        com.google.protobuf.ByteString data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.aiplatform.v1beta1.FeatureGroup.BigQuery parseFrom(
        com.google.protobuf.ByteString data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.aiplatform.v1beta1.FeatureGroup.BigQuery parseFrom(byte[] data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.aiplatform.v1beta1.FeatureGroup.BigQuery parseFrom(
        byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.aiplatform.v1beta1.FeatureGroup.BigQuery parseFrom(
        java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.cloud.aiplatform.v1beta1.FeatureGroup.BigQuery parseFrom(
        java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.cloud.aiplatform.v1beta1.FeatureGroup.BigQuery parseDelimitedFrom(
        java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
    }

    public static com.google.cloud.aiplatform.v1beta1.FeatureGroup.BigQuery parseDelimitedFrom(
        java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.cloud.aiplatform.v1beta1.FeatureGroup.BigQuery parseFrom(
        com.google.protobuf.CodedInputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.cloud.aiplatform.v1beta1.FeatureGroup.BigQuery parseFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    @java.lang.Override
    public Builder newBuilderForType() {
      return newBuilder();
    }

    public static Builder newBuilder() {
      return DEFAULT_INSTANCE.toBuilder();
    }

    public static Builder newBuilder(
        com.google.cloud.aiplatform.v1beta1.FeatureGroup.BigQuery prototype) {
      return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }

    @java.lang.Override
    public Builder toBuilder() {
      return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
    }

    @java.lang.Override
    protected Builder newBuilderForType(
        com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      Builder builder = new Builder(parent);
      return builder;
    }
    /**
     *
     *
     * <pre>
     * Input source type for BigQuery Tables and Views.
     * </pre>
     *
     * Protobuf type {@code google.cloud.aiplatform.v1beta1.FeatureGroup.BigQuery}
     */
    public static final class Builder
        extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
        implements
        // @@protoc_insertion_point(builder_implements:google.cloud.aiplatform.v1beta1.FeatureGroup.BigQuery)
        com.google.cloud.aiplatform.v1beta1.FeatureGroup.BigQueryOrBuilder {
      public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
        return com.google.cloud.aiplatform.v1beta1.FeatureGroupProto
            .internal_static_google_cloud_aiplatform_v1beta1_FeatureGroup_BigQuery_descriptor;
      }

      @java.lang.Override
      protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return com.google.cloud.aiplatform.v1beta1.FeatureGroupProto
            .internal_static_google_cloud_aiplatform_v1beta1_FeatureGroup_BigQuery_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                com.google.cloud.aiplatform.v1beta1.FeatureGroup.BigQuery.class,
                com.google.cloud.aiplatform.v1beta1.FeatureGroup.BigQuery.Builder.class);
      }

      // Construct using com.google.cloud.aiplatform.v1beta1.FeatureGroup.BigQuery.newBuilder()
      private Builder() {}

      private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
        super(parent);
      }

      @java.lang.Override
      public Builder clear() {
        super.clear();
        bitField0_ = 0;
        bigQuerySource_ = null;
        if (bigQuerySourceBuilder_ != null) {
          bigQuerySourceBuilder_.dispose();
          bigQuerySourceBuilder_ = null;
        }
        entityIdColumns_ = com.google.protobuf.LazyStringArrayList.emptyList();
        return this;
      }

      @java.lang.Override
      public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
        return com.google.cloud.aiplatform.v1beta1.FeatureGroupProto
            .internal_static_google_cloud_aiplatform_v1beta1_FeatureGroup_BigQuery_descriptor;
      }

      @java.lang.Override
      public com.google.cloud.aiplatform.v1beta1.FeatureGroup.BigQuery getDefaultInstanceForType() {
        return com.google.cloud.aiplatform.v1beta1.FeatureGroup.BigQuery.getDefaultInstance();
      }

      @java.lang.Override
      public com.google.cloud.aiplatform.v1beta1.FeatureGroup.BigQuery build() {
        com.google.cloud.aiplatform.v1beta1.FeatureGroup.BigQuery result = buildPartial();
        if (!result.isInitialized()) {
          throw newUninitializedMessageException(result);
        }
        return result;
      }

      @java.lang.Override
      public com.google.cloud.aiplatform.v1beta1.FeatureGroup.BigQuery buildPartial() {
        com.google.cloud.aiplatform.v1beta1.FeatureGroup.BigQuery result =
            new com.google.cloud.aiplatform.v1beta1.FeatureGroup.BigQuery(this);
        if (bitField0_ != 0) {
          buildPartial0(result);
        }
        onBuilt();
        return result;
      }

      private void buildPartial0(com.google.cloud.aiplatform.v1beta1.FeatureGroup.BigQuery result) {
        int from_bitField0_ = bitField0_;
        if (((from_bitField0_ & 0x00000001) != 0)) {
          result.bigQuerySource_ =
              bigQuerySourceBuilder_ == null ? bigQuerySource_ : bigQuerySourceBuilder_.build();
        }
        if (((from_bitField0_ & 0x00000002) != 0)) {
          entityIdColumns_.makeImmutable();
          result.entityIdColumns_ = entityIdColumns_;
        }
      }

      @java.lang.Override
      public Builder clone() {
        return super.clone();
      }

      @java.lang.Override
      public Builder setField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.setField(field, value);
      }

      @java.lang.Override
      public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
        return super.clearField(field);
      }

      @java.lang.Override
      public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
        return super.clearOneof(oneof);
      }

      @java.lang.Override
      public Builder setRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          int index,
          java.lang.Object value) {
        return super.setRepeatedField(field, index, value);
      }

      @java.lang.Override
      public Builder addRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.addRepeatedField(field, value);
      }

      @java.lang.Override
      public Builder mergeFrom(com.google.protobuf.Message other) {
        if (other instanceof com.google.cloud.aiplatform.v1beta1.FeatureGroup.BigQuery) {
          return mergeFrom((com.google.cloud.aiplatform.v1beta1.FeatureGroup.BigQuery) other);
        } else {
          super.mergeFrom(other);
          return this;
        }
      }

      public Builder mergeFrom(com.google.cloud.aiplatform.v1beta1.FeatureGroup.BigQuery other) {
        if (other == com.google.cloud.aiplatform.v1beta1.FeatureGroup.BigQuery.getDefaultInstance())
          return this;
        if (other.hasBigQuerySource()) {
          mergeBigQuerySource(other.getBigQuerySource());
        }
        if (!other.entityIdColumns_.isEmpty()) {
          if (entityIdColumns_.isEmpty()) {
            entityIdColumns_ = other.entityIdColumns_;
            bitField0_ |= 0x00000002;
          } else {
            ensureEntityIdColumnsIsMutable();
            entityIdColumns_.addAll(other.entityIdColumns_);
          }
          onChanged();
        }
        this.mergeUnknownFields(other.getUnknownFields());
        onChanged();
        return this;
      }

      @java.lang.Override
      public final boolean isInitialized() {
        return true;
      }

      @java.lang.Override
      public Builder mergeFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        if (extensionRegistry == null) {
          throw new java.lang.NullPointerException();
        }
        try {
          boolean done = false;
          while (!done) {
            int tag = input.readTag();
            switch (tag) {
              case 0:
                done = true;
                break;
              case 10:
                {
                  input.readMessage(
                      getBigQuerySourceFieldBuilder().getBuilder(), extensionRegistry);
                  bitField0_ |= 0x00000001;
                  break;
                } // case 10
              case 18:
                {
                  java.lang.String s = input.readStringRequireUtf8();
                  ensureEntityIdColumnsIsMutable();
                  entityIdColumns_.add(s);
                  break;
                } // case 18
              default:
                {
                  if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                    done = true; // was an endgroup tag
                  }
                  break;
                } // default:
            } // switch (tag)
          } // while (!done)
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          throw e.unwrapIOException();
        } finally {
          onChanged();
        } // finally
        return this;
      }

      private int bitField0_;

      private com.google.cloud.aiplatform.v1beta1.BigQuerySource bigQuerySource_;
      private com.google.protobuf.SingleFieldBuilderV3<
              com.google.cloud.aiplatform.v1beta1.BigQuerySource,
              com.google.cloud.aiplatform.v1beta1.BigQuerySource.Builder,
              com.google.cloud.aiplatform.v1beta1.BigQuerySourceOrBuilder>
          bigQuerySourceBuilder_;
      /**
       *
       *
       * <pre>
       * Required. Immutable. The BigQuery source URI that points to either a
       * BigQuery Table or View.
       * </pre>
       *
       * <code>
       * .google.cloud.aiplatform.v1beta1.BigQuerySource big_query_source = 1 [(.google.api.field_behavior) = IMMUTABLE, (.google.api.field_behavior) = REQUIRED];
       * </code>
       *
       * @return Whether the bigQuerySource field is set.
       */
      public boolean hasBigQuerySource() {
        return ((bitField0_ & 0x00000001) != 0);
      }
      /**
       *
       *
       * <pre>
       * Required. Immutable. The BigQuery source URI that points to either a
       * BigQuery Table or View.
       * </pre>
       *
       * <code>
       * .google.cloud.aiplatform.v1beta1.BigQuerySource big_query_source = 1 [(.google.api.field_behavior) = IMMUTABLE, (.google.api.field_behavior) = REQUIRED];
       * </code>
       *
       * @return The bigQuerySource.
       */
      public com.google.cloud.aiplatform.v1beta1.BigQuerySource getBigQuerySource() {
        if (bigQuerySourceBuilder_ == null) {
          return bigQuerySource_ == null
              ? com.google.cloud.aiplatform.v1beta1.BigQuerySource.getDefaultInstance()
              : bigQuerySource_;
        } else {
          return bigQuerySourceBuilder_.getMessage();
        }
      }
      /**
       *
       *
       * <pre>
       * Required. Immutable. The BigQuery source URI that points to either a
       * BigQuery Table or View.
       * </pre>
       *
       * <code>
       * .google.cloud.aiplatform.v1beta1.BigQuerySource big_query_source = 1 [(.google.api.field_behavior) = IMMUTABLE, (.google.api.field_behavior) = REQUIRED];
       * </code>
       */
      public Builder setBigQuerySource(com.google.cloud.aiplatform.v1beta1.BigQuerySource value) {
        if (bigQuerySourceBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          bigQuerySource_ = value;
        } else {
          bigQuerySourceBuilder_.setMessage(value);
        }
        bitField0_ |= 0x00000001;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Required. Immutable. The BigQuery source URI that points to either a
       * BigQuery Table or View.
       * </pre>
       *
       * <code>
       * .google.cloud.aiplatform.v1beta1.BigQuerySource big_query_source = 1 [(.google.api.field_behavior) = IMMUTABLE, (.google.api.field_behavior) = REQUIRED];
       * </code>
       */
      public Builder setBigQuerySource(
          com.google.cloud.aiplatform.v1beta1.BigQuerySource.Builder builderForValue) {
        if (bigQuerySourceBuilder_ == null) {
          bigQuerySource_ = builderForValue.build();
        } else {
          bigQuerySourceBuilder_.setMessage(builderForValue.build());
        }
        bitField0_ |= 0x00000001;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Required. Immutable. The BigQuery source URI that points to either a
       * BigQuery Table or View.
       * </pre>
       *
       * <code>
       * .google.cloud.aiplatform.v1beta1.BigQuerySource big_query_source = 1 [(.google.api.field_behavior) = IMMUTABLE, (.google.api.field_behavior) = REQUIRED];
       * </code>
       */
      public Builder mergeBigQuerySource(com.google.cloud.aiplatform.v1beta1.BigQuerySource value) {
        if (bigQuerySourceBuilder_ == null) {
          if (((bitField0_ & 0x00000001) != 0)
              && bigQuerySource_ != null
              && bigQuerySource_
                  != com.google.cloud.aiplatform.v1beta1.BigQuerySource.getDefaultInstance()) {
            getBigQuerySourceBuilder().mergeFrom(value);
          } else {
            bigQuerySource_ = value;
          }
        } else {
          bigQuerySourceBuilder_.mergeFrom(value);
        }
        bitField0_ |= 0x00000001;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Required. Immutable. The BigQuery source URI that points to either a
       * BigQuery Table or View.
       * </pre>
       *
       * <code>
       * .google.cloud.aiplatform.v1beta1.BigQuerySource big_query_source = 1 [(.google.api.field_behavior) = IMMUTABLE, (.google.api.field_behavior) = REQUIRED];
       * </code>
       */
      public Builder clearBigQuerySource() {
        bitField0_ = (bitField0_ & ~0x00000001);
        bigQuerySource_ = null;
        if (bigQuerySourceBuilder_ != null) {
          bigQuerySourceBuilder_.dispose();
          bigQuerySourceBuilder_ = null;
        }
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Required. Immutable. The BigQuery source URI that points to either a
       * BigQuery Table or View.
       * </pre>
       *
       * <code>
       * .google.cloud.aiplatform.v1beta1.BigQuerySource big_query_source = 1 [(.google.api.field_behavior) = IMMUTABLE, (.google.api.field_behavior) = REQUIRED];
       * </code>
       */
      public com.google.cloud.aiplatform.v1beta1.BigQuerySource.Builder getBigQuerySourceBuilder() {
        bitField0_ |= 0x00000001;
        onChanged();
        return getBigQuerySourceFieldBuilder().getBuilder();
      }
      /**
       *
       *
       * <pre>
       * Required. Immutable. The BigQuery source URI that points to either a
       * BigQuery Table or View.
       * </pre>
       *
       * <code>
       * .google.cloud.aiplatform.v1beta1.BigQuerySource big_query_source = 1 [(.google.api.field_behavior) = IMMUTABLE, (.google.api.field_behavior) = REQUIRED];
       * </code>
       */
      public com.google.cloud.aiplatform.v1beta1.BigQuerySourceOrBuilder
          getBigQuerySourceOrBuilder() {
        if (bigQuerySourceBuilder_ != null) {
          return bigQuerySourceBuilder_.getMessageOrBuilder();
        } else {
          return bigQuerySource_ == null
              ? com.google.cloud.aiplatform.v1beta1.BigQuerySource.getDefaultInstance()
              : bigQuerySource_;
        }
      }
      /**
       *
       *
       * <pre>
       * Required. Immutable. The BigQuery source URI that points to either a
       * BigQuery Table or View.
       * </pre>
       *
       * <code>
       * .google.cloud.aiplatform.v1beta1.BigQuerySource big_query_source = 1 [(.google.api.field_behavior) = IMMUTABLE, (.google.api.field_behavior) = REQUIRED];
       * </code>
       */
      private com.google.protobuf.SingleFieldBuilderV3<
              com.google.cloud.aiplatform.v1beta1.BigQuerySource,
              com.google.cloud.aiplatform.v1beta1.BigQuerySource.Builder,
              com.google.cloud.aiplatform.v1beta1.BigQuerySourceOrBuilder>
          getBigQuerySourceFieldBuilder() {
        if (bigQuerySourceBuilder_ == null) {
          bigQuerySourceBuilder_ =
              new com.google.protobuf.SingleFieldBuilderV3<
                  com.google.cloud.aiplatform.v1beta1.BigQuerySource,
                  com.google.cloud.aiplatform.v1beta1.BigQuerySource.Builder,
                  com.google.cloud.aiplatform.v1beta1.BigQuerySourceOrBuilder>(
                  getBigQuerySource(), getParentForChildren(), isClean());
          bigQuerySource_ = null;
        }
        return bigQuerySourceBuilder_;
      }

      private com.google.protobuf.LazyStringArrayList entityIdColumns_ =
          com.google.protobuf.LazyStringArrayList.emptyList();

      private void ensureEntityIdColumnsIsMutable() {
        if (!entityIdColumns_.isModifiable()) {
          entityIdColumns_ = new com.google.protobuf.LazyStringArrayList(entityIdColumns_);
        }
        bitField0_ |= 0x00000002;
      }
      /**
       *
       *
       * <pre>
       * Optional. Columns to construct entity_id / row keys. Currently only
       * supports 1 entity_id_column. If not provided defaults to `entity_id`.
       * </pre>
       *
       * <code>repeated string entity_id_columns = 2 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       *
       * @return A list containing the entityIdColumns.
       */
      public com.google.protobuf.ProtocolStringList getEntityIdColumnsList() {
        entityIdColumns_.makeImmutable();
        return entityIdColumns_;
      }
      /**
       *
       *
       * <pre>
       * Optional. Columns to construct entity_id / row keys. Currently only
       * supports 1 entity_id_column. If not provided defaults to `entity_id`.
       * </pre>
       *
       * <code>repeated string entity_id_columns = 2 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       *
       * @return The count of entityIdColumns.
       */
      public int getEntityIdColumnsCount() {
        return entityIdColumns_.size();
      }
      /**
       *
       *
       * <pre>
       * Optional. Columns to construct entity_id / row keys. Currently only
       * supports 1 entity_id_column. If not provided defaults to `entity_id`.
       * </pre>
       *
       * <code>repeated string entity_id_columns = 2 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       *
       * @param index The index of the element to return.
       * @return The entityIdColumns at the given index.
       */
      public java.lang.String getEntityIdColumns(int index) {
        return entityIdColumns_.get(index);
      }
      /**
       *
       *
       * <pre>
       * Optional. Columns to construct entity_id / row keys. Currently only
       * supports 1 entity_id_column. If not provided defaults to `entity_id`.
       * </pre>
       *
       * <code>repeated string entity_id_columns = 2 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       *
       * @param index The index of the value to return.
       * @return The bytes of the entityIdColumns at the given index.
       */
      public com.google.protobuf.ByteString getEntityIdColumnsBytes(int index) {
        return entityIdColumns_.getByteString(index);
      }
      /**
       *
       *
       * <pre>
       * Optional. Columns to construct entity_id / row keys. Currently only
       * supports 1 entity_id_column. If not provided defaults to `entity_id`.
       * </pre>
       *
       * <code>repeated string entity_id_columns = 2 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       *
       * @param index The index to set the value at.
       * @param value The entityIdColumns to set.
       * @return This builder for chaining.
       */
      public Builder setEntityIdColumns(int index, java.lang.String value) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureEntityIdColumnsIsMutable();
        entityIdColumns_.set(index, value);
        bitField0_ |= 0x00000002;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Optional. Columns to construct entity_id / row keys. Currently only
       * supports 1 entity_id_column. If not provided defaults to `entity_id`.
       * </pre>
       *
       * <code>repeated string entity_id_columns = 2 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       *
       * @param value The entityIdColumns to add.
       * @return This builder for chaining.
       */
      public Builder addEntityIdColumns(java.lang.String value) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureEntityIdColumnsIsMutable();
        entityIdColumns_.add(value);
        bitField0_ |= 0x00000002;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Optional. Columns to construct entity_id / row keys. Currently only
       * supports 1 entity_id_column. If not provided defaults to `entity_id`.
       * </pre>
       *
       * <code>repeated string entity_id_columns = 2 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       *
       * @param values The entityIdColumns to add.
       * @return This builder for chaining.
       */
      public Builder addAllEntityIdColumns(java.lang.Iterable<java.lang.String> values) {
        ensureEntityIdColumnsIsMutable();
        com.google.protobuf.AbstractMessageLite.Builder.addAll(values, entityIdColumns_);
        bitField0_ |= 0x00000002;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Optional. Columns to construct entity_id / row keys. Currently only
       * supports 1 entity_id_column. If not provided defaults to `entity_id`.
       * </pre>
       *
       * <code>repeated string entity_id_columns = 2 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       *
       * @return This builder for chaining.
       */
      public Builder clearEntityIdColumns() {
        entityIdColumns_ = com.google.protobuf.LazyStringArrayList.emptyList();
        bitField0_ = (bitField0_ & ~0x00000002);
        ;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Optional. Columns to construct entity_id / row keys. Currently only
       * supports 1 entity_id_column. If not provided defaults to `entity_id`.
       * </pre>
       *
       * <code>repeated string entity_id_columns = 2 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       *
       * @param value The bytes of the entityIdColumns to add.
       * @return This builder for chaining.
       */
      public Builder addEntityIdColumnsBytes(com.google.protobuf.ByteString value) {
        if (value == null) {
          throw new NullPointerException();
        }
        checkByteStringIsUtf8(value);
        ensureEntityIdColumnsIsMutable();
        entityIdColumns_.add(value);
        bitField0_ |= 0x00000002;
        onChanged();
        return this;
      }

      @java.lang.Override
      public final Builder setUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.setUnknownFields(unknownFields);
      }

      @java.lang.Override
      public final Builder mergeUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.mergeUnknownFields(unknownFields);
      }

      // @@protoc_insertion_point(builder_scope:google.cloud.aiplatform.v1beta1.FeatureGroup.BigQuery)
    }

    // @@protoc_insertion_point(class_scope:google.cloud.aiplatform.v1beta1.FeatureGroup.BigQuery)
    private static final com.google.cloud.aiplatform.v1beta1.FeatureGroup.BigQuery DEFAULT_INSTANCE;

    static {
      DEFAULT_INSTANCE = new com.google.cloud.aiplatform.v1beta1.FeatureGroup.BigQuery();
    }

    public static com.google.cloud.aiplatform.v1beta1.FeatureGroup.BigQuery getDefaultInstance() {
      return DEFAULT_INSTANCE;
    }

    private static final com.google.protobuf.Parser<BigQuery> PARSER =
        new com.google.protobuf.AbstractParser<BigQuery>() {
          @java.lang.Override
          public BigQuery parsePartialFrom(
              com.google.protobuf.CodedInputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
            Builder builder = newBuilder();
            try {
              builder.mergeFrom(input, extensionRegistry);
            } catch (com.google.protobuf.InvalidProtocolBufferException e) {
              throw e.setUnfinishedMessage(builder.buildPartial());
            } catch (com.google.protobuf.UninitializedMessageException e) {
              throw e.asInvalidProtocolBufferException()
                  .setUnfinishedMessage(builder.buildPartial());
            } catch (java.io.IOException e) {
              throw new com.google.protobuf.InvalidProtocolBufferException(e)
                  .setUnfinishedMessage(builder.buildPartial());
            }
            return builder.buildPartial();
          }
        };

    public static com.google.protobuf.Parser<BigQuery> parser() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.protobuf.Parser<BigQuery> getParserForType() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.cloud.aiplatform.v1beta1.FeatureGroup.BigQuery getDefaultInstanceForType() {
      return DEFAULT_INSTANCE;
    }
  }

  private int sourceCase_ = 0;

  @SuppressWarnings("serial")
  private java.lang.Object source_;

  public enum SourceCase
      implements
          com.google.protobuf.Internal.EnumLite,
          com.google.protobuf.AbstractMessage.InternalOneOfEnum {
    BIG_QUERY(7),
    SOURCE_NOT_SET(0);
    private final int value;

    private SourceCase(int value) {
      this.value = value;
    }
    /**
     * @param value The number of the enum to look for.
     * @return The enum associated with the given number.
     * @deprecated Use {@link #forNumber(int)} instead.
     */
    @java.lang.Deprecated
    public static SourceCase valueOf(int value) {
      return forNumber(value);
    }

    public static SourceCase forNumber(int value) {
      switch (value) {
        case 7:
          return BIG_QUERY;
        case 0:
          return SOURCE_NOT_SET;
        default:
          return null;
      }
    }

    public int getNumber() {
      return this.value;
    }
  };

  public SourceCase getSourceCase() {
    return SourceCase.forNumber(sourceCase_);
  }

  public static final int BIG_QUERY_FIELD_NUMBER = 7;
  /**
   *
   *
   * <pre>
   * Indicates that features for this group come from BigQuery Table/View.
   * By default treats the source as a sparse time series source, which is
   * required to have an entity_id and a feature_timestamp column in the
   * source.
   * </pre>
   *
   * <code>.google.cloud.aiplatform.v1beta1.FeatureGroup.BigQuery big_query = 7;</code>
   *
   * @return Whether the bigQuery field is set.
   */
  @java.lang.Override
  public boolean hasBigQuery() {
    return sourceCase_ == 7;
  }
  /**
   *
   *
   * <pre>
   * Indicates that features for this group come from BigQuery Table/View.
   * By default treats the source as a sparse time series source, which is
   * required to have an entity_id and a feature_timestamp column in the
   * source.
   * </pre>
   *
   * <code>.google.cloud.aiplatform.v1beta1.FeatureGroup.BigQuery big_query = 7;</code>
   *
   * @return The bigQuery.
   */
  @java.lang.Override
  public com.google.cloud.aiplatform.v1beta1.FeatureGroup.BigQuery getBigQuery() {
    if (sourceCase_ == 7) {
      return (com.google.cloud.aiplatform.v1beta1.FeatureGroup.BigQuery) source_;
    }
    return com.google.cloud.aiplatform.v1beta1.FeatureGroup.BigQuery.getDefaultInstance();
  }
  /**
   *
   *
   * <pre>
   * Indicates that features for this group come from BigQuery Table/View.
   * By default treats the source as a sparse time series source, which is
   * required to have an entity_id and a feature_timestamp column in the
   * source.
   * </pre>
   *
   * <code>.google.cloud.aiplatform.v1beta1.FeatureGroup.BigQuery big_query = 7;</code>
   */
  @java.lang.Override
  public com.google.cloud.aiplatform.v1beta1.FeatureGroup.BigQueryOrBuilder getBigQueryOrBuilder() {
    if (sourceCase_ == 7) {
      return (com.google.cloud.aiplatform.v1beta1.FeatureGroup.BigQuery) source_;
    }
    return com.google.cloud.aiplatform.v1beta1.FeatureGroup.BigQuery.getDefaultInstance();
  }

  public static final int NAME_FIELD_NUMBER = 1;

  @SuppressWarnings("serial")
  private volatile java.lang.Object name_ = "";
  /**
   *
   *
   * <pre>
   * Identifier. Name of the FeatureGroup. Format:
   * `projects/{project}/locations/{location}/featureGroups/{featureGroup}`
   * </pre>
   *
   * <code>string name = 1 [(.google.api.field_behavior) = IDENTIFIER];</code>
   *
   * @return The name.
   */
  @java.lang.Override
  public java.lang.String getName() {
    java.lang.Object ref = name_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      name_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Identifier. Name of the FeatureGroup. Format:
   * `projects/{project}/locations/{location}/featureGroups/{featureGroup}`
   * </pre>
   *
   * <code>string name = 1 [(.google.api.field_behavior) = IDENTIFIER];</code>
   *
   * @return The bytes for name.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getNameBytes() {
    java.lang.Object ref = name_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      name_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int CREATE_TIME_FIELD_NUMBER = 2;
  private com.google.protobuf.Timestamp createTime_;
  /**
   *
   *
   * <pre>
   * Output only. Timestamp when this FeatureGroup was created.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp create_time = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return Whether the createTime field is set.
   */
  @java.lang.Override
  public boolean hasCreateTime() {
    return createTime_ != null;
  }
  /**
   *
   *
   * <pre>
   * Output only. Timestamp when this FeatureGroup was created.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp create_time = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return The createTime.
   */
  @java.lang.Override
  public com.google.protobuf.Timestamp getCreateTime() {
    return createTime_ == null ? com.google.protobuf.Timestamp.getDefaultInstance() : createTime_;
  }
  /**
   *
   *
   * <pre>
   * Output only. Timestamp when this FeatureGroup was created.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp create_time = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   */
  @java.lang.Override
  public com.google.protobuf.TimestampOrBuilder getCreateTimeOrBuilder() {
    return createTime_ == null ? com.google.protobuf.Timestamp.getDefaultInstance() : createTime_;
  }

  public static final int UPDATE_TIME_FIELD_NUMBER = 3;
  private com.google.protobuf.Timestamp updateTime_;
  /**
   *
   *
   * <pre>
   * Output only. Timestamp when this FeatureGroup was last updated.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp update_time = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return Whether the updateTime field is set.
   */
  @java.lang.Override
  public boolean hasUpdateTime() {
    return updateTime_ != null;
  }
  /**
   *
   *
   * <pre>
   * Output only. Timestamp when this FeatureGroup was last updated.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp update_time = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return The updateTime.
   */
  @java.lang.Override
  public com.google.protobuf.Timestamp getUpdateTime() {
    return updateTime_ == null ? com.google.protobuf.Timestamp.getDefaultInstance() : updateTime_;
  }
  /**
   *
   *
   * <pre>
   * Output only. Timestamp when this FeatureGroup was last updated.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp update_time = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   */
  @java.lang.Override
  public com.google.protobuf.TimestampOrBuilder getUpdateTimeOrBuilder() {
    return updateTime_ == null ? com.google.protobuf.Timestamp.getDefaultInstance() : updateTime_;
  }

  public static final int ETAG_FIELD_NUMBER = 4;

  @SuppressWarnings("serial")
  private volatile java.lang.Object etag_ = "";
  /**
   *
   *
   * <pre>
   * Optional. Used to perform consistent read-modify-write updates. If not set,
   * a blind "overwrite" update happens.
   * </pre>
   *
   * <code>string etag = 4 [(.google.api.field_behavior) = OPTIONAL];</code>
   *
   * @return The etag.
   */
  @java.lang.Override
  public java.lang.String getEtag() {
    java.lang.Object ref = etag_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      etag_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Optional. Used to perform consistent read-modify-write updates. If not set,
   * a blind "overwrite" update happens.
   * </pre>
   *
   * <code>string etag = 4 [(.google.api.field_behavior) = OPTIONAL];</code>
   *
   * @return The bytes for etag.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getEtagBytes() {
    java.lang.Object ref = etag_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      etag_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int LABELS_FIELD_NUMBER = 5;

  private static final class LabelsDefaultEntryHolder {
    static final com.google.protobuf.MapEntry<java.lang.String, java.lang.String> defaultEntry =
        com.google.protobuf.MapEntry.<java.lang.String, java.lang.String>newDefaultInstance(
            com.google.cloud.aiplatform.v1beta1.FeatureGroupProto
                .internal_static_google_cloud_aiplatform_v1beta1_FeatureGroup_LabelsEntry_descriptor,
            com.google.protobuf.WireFormat.FieldType.STRING,
            "",
            com.google.protobuf.WireFormat.FieldType.STRING,
            "");
  }

  @SuppressWarnings("serial")
  private com.google.protobuf.MapField<java.lang.String, java.lang.String> labels_;

  private com.google.protobuf.MapField<java.lang.String, java.lang.String> internalGetLabels() {
    if (labels_ == null) {
      return com.google.protobuf.MapField.emptyMapField(LabelsDefaultEntryHolder.defaultEntry);
    }
    return labels_;
  }

  public int getLabelsCount() {
    return internalGetLabels().getMap().size();
  }
  /**
   *
   *
   * <pre>
   * Optional. The labels with user-defined metadata to organize your
   * FeatureGroup.
   *
   * Label keys and values can be no longer than 64 characters
   * (Unicode codepoints), can only contain lowercase letters, numeric
   * characters, underscores and dashes. International characters are allowed.
   *
   * See https://goo.gl/xmQnxf for more information on and examples of labels.
   * No more than 64 user labels can be associated with one
   * FeatureGroup(System labels are excluded)." System reserved label keys
   * are prefixed with "aiplatform.googleapis.com/" and are immutable.
   * </pre>
   *
   * <code>map&lt;string, string&gt; labels = 5 [(.google.api.field_behavior) = OPTIONAL];</code>
   */
  @java.lang.Override
  public boolean containsLabels(java.lang.String key) {
    if (key == null) {
      throw new NullPointerException("map key");
    }
    return internalGetLabels().getMap().containsKey(key);
  }
  /** Use {@link #getLabelsMap()} instead. */
  @java.lang.Override
  @java.lang.Deprecated
  public java.util.Map<java.lang.String, java.lang.String> getLabels() {
    return getLabelsMap();
  }
  /**
   *
   *
   * <pre>
   * Optional. The labels with user-defined metadata to organize your
   * FeatureGroup.
   *
   * Label keys and values can be no longer than 64 characters
   * (Unicode codepoints), can only contain lowercase letters, numeric
   * characters, underscores and dashes. International characters are allowed.
   *
   * See https://goo.gl/xmQnxf for more information on and examples of labels.
   * No more than 64 user labels can be associated with one
   * FeatureGroup(System labels are excluded)." System reserved label keys
   * are prefixed with "aiplatform.googleapis.com/" and are immutable.
   * </pre>
   *
   * <code>map&lt;string, string&gt; labels = 5 [(.google.api.field_behavior) = OPTIONAL];</code>
   */
  @java.lang.Override
  public java.util.Map<java.lang.String, java.lang.String> getLabelsMap() {
    return internalGetLabels().getMap();
  }
  /**
   *
   *
   * <pre>
   * Optional. The labels with user-defined metadata to organize your
   * FeatureGroup.
   *
   * Label keys and values can be no longer than 64 characters
   * (Unicode codepoints), can only contain lowercase letters, numeric
   * characters, underscores and dashes. International characters are allowed.
   *
   * See https://goo.gl/xmQnxf for more information on and examples of labels.
   * No more than 64 user labels can be associated with one
   * FeatureGroup(System labels are excluded)." System reserved label keys
   * are prefixed with "aiplatform.googleapis.com/" and are immutable.
   * </pre>
   *
   * <code>map&lt;string, string&gt; labels = 5 [(.google.api.field_behavior) = OPTIONAL];</code>
   */
  @java.lang.Override
  public /* nullable */ java.lang.String getLabelsOrDefault(
      java.lang.String key,
      /* nullable */
      java.lang.String defaultValue) {
    if (key == null) {
      throw new NullPointerException("map key");
    }
    java.util.Map<java.lang.String, java.lang.String> map = internalGetLabels().getMap();
    return map.containsKey(key) ? map.get(key) : defaultValue;
  }
  /**
   *
   *
   * <pre>
   * Optional. The labels with user-defined metadata to organize your
   * FeatureGroup.
   *
   * Label keys and values can be no longer than 64 characters
   * (Unicode codepoints), can only contain lowercase letters, numeric
   * characters, underscores and dashes. International characters are allowed.
   *
   * See https://goo.gl/xmQnxf for more information on and examples of labels.
   * No more than 64 user labels can be associated with one
   * FeatureGroup(System labels are excluded)." System reserved label keys
   * are prefixed with "aiplatform.googleapis.com/" and are immutable.
   * </pre>
   *
   * <code>map&lt;string, string&gt; labels = 5 [(.google.api.field_behavior) = OPTIONAL];</code>
   */
  @java.lang.Override
  public java.lang.String getLabelsOrThrow(java.lang.String key) {
    if (key == null) {
      throw new NullPointerException("map key");
    }
    java.util.Map<java.lang.String, java.lang.String> map = internalGetLabels().getMap();
    if (!map.containsKey(key)) {
      throw new java.lang.IllegalArgumentException();
    }
    return map.get(key);
  }

  public static final int DESCRIPTION_FIELD_NUMBER = 6;

  @SuppressWarnings("serial")
  private volatile java.lang.Object description_ = "";
  /**
   *
   *
   * <pre>
   * Optional. Description of the FeatureGroup.
   * </pre>
   *
   * <code>string description = 6 [(.google.api.field_behavior) = OPTIONAL];</code>
   *
   * @return The description.
   */
  @java.lang.Override
  public java.lang.String getDescription() {
    java.lang.Object ref = description_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      description_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Optional. Description of the FeatureGroup.
   * </pre>
   *
   * <code>string description = 6 [(.google.api.field_behavior) = OPTIONAL];</code>
   *
   * @return The bytes for description.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getDescriptionBytes() {
    java.lang.Object ref = description_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      description_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(name_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 1, name_);
    }
    if (createTime_ != null) {
      output.writeMessage(2, getCreateTime());
    }
    if (updateTime_ != null) {
      output.writeMessage(3, getUpdateTime());
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(etag_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 4, etag_);
    }
    com.google.protobuf.GeneratedMessageV3.serializeStringMapTo(
        output, internalGetLabels(), LabelsDefaultEntryHolder.defaultEntry, 5);
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(description_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 6, description_);
    }
    if (sourceCase_ == 7) {
      output.writeMessage(7, (com.google.cloud.aiplatform.v1beta1.FeatureGroup.BigQuery) source_);
    }
    getUnknownFields().writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(name_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(1, name_);
    }
    if (createTime_ != null) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(2, getCreateTime());
    }
    if (updateTime_ != null) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(3, getUpdateTime());
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(etag_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(4, etag_);
    }
    for (java.util.Map.Entry<java.lang.String, java.lang.String> entry :
        internalGetLabels().getMap().entrySet()) {
      com.google.protobuf.MapEntry<java.lang.String, java.lang.String> labels__ =
          LabelsDefaultEntryHolder.defaultEntry
              .newBuilderForType()
              .setKey(entry.getKey())
              .setValue(entry.getValue())
              .build();
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(5, labels__);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(description_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(6, description_);
    }
    if (sourceCase_ == 7) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(
              7, (com.google.cloud.aiplatform.v1beta1.FeatureGroup.BigQuery) source_);
    }
    size += getUnknownFields().getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.cloud.aiplatform.v1beta1.FeatureGroup)) {
      return super.equals(obj);
    }
    com.google.cloud.aiplatform.v1beta1.FeatureGroup other =
        (com.google.cloud.aiplatform.v1beta1.FeatureGroup) obj;

    if (!getName().equals(other.getName())) return false;
    if (hasCreateTime() != other.hasCreateTime()) return false;
    if (hasCreateTime()) {
      if (!getCreateTime().equals(other.getCreateTime())) return false;
    }
    if (hasUpdateTime() != other.hasUpdateTime()) return false;
    if (hasUpdateTime()) {
      if (!getUpdateTime().equals(other.getUpdateTime())) return false;
    }
    if (!getEtag().equals(other.getEtag())) return false;
    if (!internalGetLabels().equals(other.internalGetLabels())) return false;
    if (!getDescription().equals(other.getDescription())) return false;
    if (!getSourceCase().equals(other.getSourceCase())) return false;
    switch (sourceCase_) {
      case 7:
        if (!getBigQuery().equals(other.getBigQuery())) return false;
        break;
      case 0:
      default:
    }
    if (!getUnknownFields().equals(other.getUnknownFields())) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    hash = (37 * hash) + NAME_FIELD_NUMBER;
    hash = (53 * hash) + getName().hashCode();
    if (hasCreateTime()) {
      hash = (37 * hash) + CREATE_TIME_FIELD_NUMBER;
      hash = (53 * hash) + getCreateTime().hashCode();
    }
    if (hasUpdateTime()) {
      hash = (37 * hash) + UPDATE_TIME_FIELD_NUMBER;
      hash = (53 * hash) + getUpdateTime().hashCode();
    }
    hash = (37 * hash) + ETAG_FIELD_NUMBER;
    hash = (53 * hash) + getEtag().hashCode();
    if (!internalGetLabels().getMap().isEmpty()) {
      hash = (37 * hash) + LABELS_FIELD_NUMBER;
      hash = (53 * hash) + internalGetLabels().hashCode();
    }
    hash = (37 * hash) + DESCRIPTION_FIELD_NUMBER;
    hash = (53 * hash) + getDescription().hashCode();
    switch (sourceCase_) {
      case 7:
        hash = (37 * hash) + BIG_QUERY_FIELD_NUMBER;
        hash = (53 * hash) + getBigQuery().hashCode();
        break;
      case 0:
      default:
    }
    hash = (29 * hash) + getUnknownFields().hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.cloud.aiplatform.v1beta1.FeatureGroup parseFrom(java.nio.ByteBuffer data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.aiplatform.v1beta1.FeatureGroup parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.aiplatform.v1beta1.FeatureGroup parseFrom(
      com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.aiplatform.v1beta1.FeatureGroup parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.aiplatform.v1beta1.FeatureGroup parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.aiplatform.v1beta1.FeatureGroup parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.aiplatform.v1beta1.FeatureGroup parseFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.aiplatform.v1beta1.FeatureGroup parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.aiplatform.v1beta1.FeatureGroup parseDelimitedFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.cloud.aiplatform.v1beta1.FeatureGroup parseDelimitedFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.aiplatform.v1beta1.FeatureGroup parseFrom(
      com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.aiplatform.v1beta1.FeatureGroup parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(com.google.cloud.aiplatform.v1beta1.FeatureGroup prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }
  /**
   *
   *
   * <pre>
   * Vertex AI Feature Group.
   * </pre>
   *
   * Protobuf type {@code google.cloud.aiplatform.v1beta1.FeatureGroup}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.cloud.aiplatform.v1beta1.FeatureGroup)
      com.google.cloud.aiplatform.v1beta1.FeatureGroupOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.aiplatform.v1beta1.FeatureGroupProto
          .internal_static_google_cloud_aiplatform_v1beta1_FeatureGroup_descriptor;
    }

    @SuppressWarnings({"rawtypes"})
    protected com.google.protobuf.MapField internalGetMapField(int number) {
      switch (number) {
        case 5:
          return internalGetLabels();
        default:
          throw new RuntimeException("Invalid map field number: " + number);
      }
    }

    @SuppressWarnings({"rawtypes"})
    protected com.google.protobuf.MapField internalGetMutableMapField(int number) {
      switch (number) {
        case 5:
          return internalGetMutableLabels();
        default:
          throw new RuntimeException("Invalid map field number: " + number);
      }
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.aiplatform.v1beta1.FeatureGroupProto
          .internal_static_google_cloud_aiplatform_v1beta1_FeatureGroup_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.aiplatform.v1beta1.FeatureGroup.class,
              com.google.cloud.aiplatform.v1beta1.FeatureGroup.Builder.class);
    }

    // Construct using com.google.cloud.aiplatform.v1beta1.FeatureGroup.newBuilder()
    private Builder() {}

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      bitField0_ = 0;
      if (bigQueryBuilder_ != null) {
        bigQueryBuilder_.clear();
      }
      name_ = "";
      createTime_ = null;
      if (createTimeBuilder_ != null) {
        createTimeBuilder_.dispose();
        createTimeBuilder_ = null;
      }
      updateTime_ = null;
      if (updateTimeBuilder_ != null) {
        updateTimeBuilder_.dispose();
        updateTimeBuilder_ = null;
      }
      etag_ = "";
      internalGetMutableLabels().clear();
      description_ = "";
      sourceCase_ = 0;
      source_ = null;
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.cloud.aiplatform.v1beta1.FeatureGroupProto
          .internal_static_google_cloud_aiplatform_v1beta1_FeatureGroup_descriptor;
    }

    @java.lang.Override
    public com.google.cloud.aiplatform.v1beta1.FeatureGroup getDefaultInstanceForType() {
      return com.google.cloud.aiplatform.v1beta1.FeatureGroup.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.cloud.aiplatform.v1beta1.FeatureGroup build() {
      com.google.cloud.aiplatform.v1beta1.FeatureGroup result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.cloud.aiplatform.v1beta1.FeatureGroup buildPartial() {
      com.google.cloud.aiplatform.v1beta1.FeatureGroup result =
          new com.google.cloud.aiplatform.v1beta1.FeatureGroup(this);
      if (bitField0_ != 0) {
        buildPartial0(result);
      }
      buildPartialOneofs(result);
      onBuilt();
      return result;
    }

    private void buildPartial0(com.google.cloud.aiplatform.v1beta1.FeatureGroup result) {
      int from_bitField0_ = bitField0_;
      if (((from_bitField0_ & 0x00000002) != 0)) {
        result.name_ = name_;
      }
      if (((from_bitField0_ & 0x00000004) != 0)) {
        result.createTime_ = createTimeBuilder_ == null ? createTime_ : createTimeBuilder_.build();
      }
      if (((from_bitField0_ & 0x00000008) != 0)) {
        result.updateTime_ = updateTimeBuilder_ == null ? updateTime_ : updateTimeBuilder_.build();
      }
      if (((from_bitField0_ & 0x00000010) != 0)) {
        result.etag_ = etag_;
      }
      if (((from_bitField0_ & 0x00000020) != 0)) {
        result.labels_ = internalGetLabels();
        result.labels_.makeImmutable();
      }
      if (((from_bitField0_ & 0x00000040) != 0)) {
        result.description_ = description_;
      }
    }

    private void buildPartialOneofs(com.google.cloud.aiplatform.v1beta1.FeatureGroup result) {
      result.sourceCase_ = sourceCase_;
      result.source_ = this.source_;
      if (sourceCase_ == 7 && bigQueryBuilder_ != null) {
        result.source_ = bigQueryBuilder_.build();
      }
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.cloud.aiplatform.v1beta1.FeatureGroup) {
        return mergeFrom((com.google.cloud.aiplatform.v1beta1.FeatureGroup) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(com.google.cloud.aiplatform.v1beta1.FeatureGroup other) {
      if (other == com.google.cloud.aiplatform.v1beta1.FeatureGroup.getDefaultInstance())
        return this;
      if (!other.getName().isEmpty()) {
        name_ = other.name_;
        bitField0_ |= 0x00000002;
        onChanged();
      }
      if (other.hasCreateTime()) {
        mergeCreateTime(other.getCreateTime());
      }
      if (other.hasUpdateTime()) {
        mergeUpdateTime(other.getUpdateTime());
      }
      if (!other.getEtag().isEmpty()) {
        etag_ = other.etag_;
        bitField0_ |= 0x00000010;
        onChanged();
      }
      internalGetMutableLabels().mergeFrom(other.internalGetLabels());
      bitField0_ |= 0x00000020;
      if (!other.getDescription().isEmpty()) {
        description_ = other.description_;
        bitField0_ |= 0x00000040;
        onChanged();
      }
      switch (other.getSourceCase()) {
        case BIG_QUERY:
          {
            mergeBigQuery(other.getBigQuery());
            break;
          }
        case SOURCE_NOT_SET:
          {
            break;
          }
      }
      this.mergeUnknownFields(other.getUnknownFields());
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 10:
              {
                name_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000002;
                break;
              } // case 10
            case 18:
              {
                input.readMessage(getCreateTimeFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000004;
                break;
              } // case 18
            case 26:
              {
                input.readMessage(getUpdateTimeFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000008;
                break;
              } // case 26
            case 34:
              {
                etag_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000010;
                break;
              } // case 34
            case 42:
              {
                com.google.protobuf.MapEntry<java.lang.String, java.lang.String> labels__ =
                    input.readMessage(
                        LabelsDefaultEntryHolder.defaultEntry.getParserForType(),
                        extensionRegistry);
                internalGetMutableLabels()
                    .getMutableMap()
                    .put(labels__.getKey(), labels__.getValue());
                bitField0_ |= 0x00000020;
                break;
              } // case 42
            case 50:
              {
                description_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000040;
                break;
              } // case 50
            case 58:
              {
                input.readMessage(getBigQueryFieldBuilder().getBuilder(), extensionRegistry);
                sourceCase_ = 7;
                break;
              } // case 58
            default:
              {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
          } // switch (tag)
        } // while (!done)
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.unwrapIOException();
      } finally {
        onChanged();
      } // finally
      return this;
    }

    private int sourceCase_ = 0;
    private java.lang.Object source_;

    public SourceCase getSourceCase() {
      return SourceCase.forNumber(sourceCase_);
    }

    public Builder clearSource() {
      sourceCase_ = 0;
      source_ = null;
      onChanged();
      return this;
    }

    private int bitField0_;

    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.aiplatform.v1beta1.FeatureGroup.BigQuery,
            com.google.cloud.aiplatform.v1beta1.FeatureGroup.BigQuery.Builder,
            com.google.cloud.aiplatform.v1beta1.FeatureGroup.BigQueryOrBuilder>
        bigQueryBuilder_;
    /**
     *
     *
     * <pre>
     * Indicates that features for this group come from BigQuery Table/View.
     * By default treats the source as a sparse time series source, which is
     * required to have an entity_id and a feature_timestamp column in the
     * source.
     * </pre>
     *
     * <code>.google.cloud.aiplatform.v1beta1.FeatureGroup.BigQuery big_query = 7;</code>
     *
     * @return Whether the bigQuery field is set.
     */
    @java.lang.Override
    public boolean hasBigQuery() {
      return sourceCase_ == 7;
    }
    /**
     *
     *
     * <pre>
     * Indicates that features for this group come from BigQuery Table/View.
     * By default treats the source as a sparse time series source, which is
     * required to have an entity_id and a feature_timestamp column in the
     * source.
     * </pre>
     *
     * <code>.google.cloud.aiplatform.v1beta1.FeatureGroup.BigQuery big_query = 7;</code>
     *
     * @return The bigQuery.
     */
    @java.lang.Override
    public com.google.cloud.aiplatform.v1beta1.FeatureGroup.BigQuery getBigQuery() {
      if (bigQueryBuilder_ == null) {
        if (sourceCase_ == 7) {
          return (com.google.cloud.aiplatform.v1beta1.FeatureGroup.BigQuery) source_;
        }
        return com.google.cloud.aiplatform.v1beta1.FeatureGroup.BigQuery.getDefaultInstance();
      } else {
        if (sourceCase_ == 7) {
          return bigQueryBuilder_.getMessage();
        }
        return com.google.cloud.aiplatform.v1beta1.FeatureGroup.BigQuery.getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * Indicates that features for this group come from BigQuery Table/View.
     * By default treats the source as a sparse time series source, which is
     * required to have an entity_id and a feature_timestamp column in the
     * source.
     * </pre>
     *
     * <code>.google.cloud.aiplatform.v1beta1.FeatureGroup.BigQuery big_query = 7;</code>
     */
    public Builder setBigQuery(com.google.cloud.aiplatform.v1beta1.FeatureGroup.BigQuery value) {
      if (bigQueryBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        source_ = value;
        onChanged();
      } else {
        bigQueryBuilder_.setMessage(value);
      }
      sourceCase_ = 7;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Indicates that features for this group come from BigQuery Table/View.
     * By default treats the source as a sparse time series source, which is
     * required to have an entity_id and a feature_timestamp column in the
     * source.
     * </pre>
     *
     * <code>.google.cloud.aiplatform.v1beta1.FeatureGroup.BigQuery big_query = 7;</code>
     */
    public Builder setBigQuery(
        com.google.cloud.aiplatform.v1beta1.FeatureGroup.BigQuery.Builder builderForValue) {
      if (bigQueryBuilder_ == null) {
        source_ = builderForValue.build();
        onChanged();
      } else {
        bigQueryBuilder_.setMessage(builderForValue.build());
      }
      sourceCase_ = 7;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Indicates that features for this group come from BigQuery Table/View.
     * By default treats the source as a sparse time series source, which is
     * required to have an entity_id and a feature_timestamp column in the
     * source.
     * </pre>
     *
     * <code>.google.cloud.aiplatform.v1beta1.FeatureGroup.BigQuery big_query = 7;</code>
     */
    public Builder mergeBigQuery(com.google.cloud.aiplatform.v1beta1.FeatureGroup.BigQuery value) {
      if (bigQueryBuilder_ == null) {
        if (sourceCase_ == 7
            && source_
                != com.google.cloud.aiplatform.v1beta1.FeatureGroup.BigQuery.getDefaultInstance()) {
          source_ =
              com.google.cloud.aiplatform.v1beta1.FeatureGroup.BigQuery.newBuilder(
                      (com.google.cloud.aiplatform.v1beta1.FeatureGroup.BigQuery) source_)
                  .mergeFrom(value)
                  .buildPartial();
        } else {
          source_ = value;
        }
        onChanged();
      } else {
        if (sourceCase_ == 7) {
          bigQueryBuilder_.mergeFrom(value);
        } else {
          bigQueryBuilder_.setMessage(value);
        }
      }
      sourceCase_ = 7;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Indicates that features for this group come from BigQuery Table/View.
     * By default treats the source as a sparse time series source, which is
     * required to have an entity_id and a feature_timestamp column in the
     * source.
     * </pre>
     *
     * <code>.google.cloud.aiplatform.v1beta1.FeatureGroup.BigQuery big_query = 7;</code>
     */
    public Builder clearBigQuery() {
      if (bigQueryBuilder_ == null) {
        if (sourceCase_ == 7) {
          sourceCase_ = 0;
          source_ = null;
          onChanged();
        }
      } else {
        if (sourceCase_ == 7) {
          sourceCase_ = 0;
          source_ = null;
        }
        bigQueryBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Indicates that features for this group come from BigQuery Table/View.
     * By default treats the source as a sparse time series source, which is
     * required to have an entity_id and a feature_timestamp column in the
     * source.
     * </pre>
     *
     * <code>.google.cloud.aiplatform.v1beta1.FeatureGroup.BigQuery big_query = 7;</code>
     */
    public com.google.cloud.aiplatform.v1beta1.FeatureGroup.BigQuery.Builder getBigQueryBuilder() {
      return getBigQueryFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Indicates that features for this group come from BigQuery Table/View.
     * By default treats the source as a sparse time series source, which is
     * required to have an entity_id and a feature_timestamp column in the
     * source.
     * </pre>
     *
     * <code>.google.cloud.aiplatform.v1beta1.FeatureGroup.BigQuery big_query = 7;</code>
     */
    @java.lang.Override
    public com.google.cloud.aiplatform.v1beta1.FeatureGroup.BigQueryOrBuilder
        getBigQueryOrBuilder() {
      if ((sourceCase_ == 7) && (bigQueryBuilder_ != null)) {
        return bigQueryBuilder_.getMessageOrBuilder();
      } else {
        if (sourceCase_ == 7) {
          return (com.google.cloud.aiplatform.v1beta1.FeatureGroup.BigQuery) source_;
        }
        return com.google.cloud.aiplatform.v1beta1.FeatureGroup.BigQuery.getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * Indicates that features for this group come from BigQuery Table/View.
     * By default treats the source as a sparse time series source, which is
     * required to have an entity_id and a feature_timestamp column in the
     * source.
     * </pre>
     *
     * <code>.google.cloud.aiplatform.v1beta1.FeatureGroup.BigQuery big_query = 7;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.aiplatform.v1beta1.FeatureGroup.BigQuery,
            com.google.cloud.aiplatform.v1beta1.FeatureGroup.BigQuery.Builder,
            com.google.cloud.aiplatform.v1beta1.FeatureGroup.BigQueryOrBuilder>
        getBigQueryFieldBuilder() {
      if (bigQueryBuilder_ == null) {
        if (!(sourceCase_ == 7)) {
          source_ = com.google.cloud.aiplatform.v1beta1.FeatureGroup.BigQuery.getDefaultInstance();
        }
        bigQueryBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.aiplatform.v1beta1.FeatureGroup.BigQuery,
                com.google.cloud.aiplatform.v1beta1.FeatureGroup.BigQuery.Builder,
                com.google.cloud.aiplatform.v1beta1.FeatureGroup.BigQueryOrBuilder>(
                (com.google.cloud.aiplatform.v1beta1.FeatureGroup.BigQuery) source_,
                getParentForChildren(),
                isClean());
        source_ = null;
      }
      sourceCase_ = 7;
      onChanged();
      return bigQueryBuilder_;
    }

    private java.lang.Object name_ = "";
    /**
     *
     *
     * <pre>
     * Identifier. Name of the FeatureGroup. Format:
     * `projects/{project}/locations/{location}/featureGroups/{featureGroup}`
     * </pre>
     *
     * <code>string name = 1 [(.google.api.field_behavior) = IDENTIFIER];</code>
     *
     * @return The name.
     */
    public java.lang.String getName() {
      java.lang.Object ref = name_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        name_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Identifier. Name of the FeatureGroup. Format:
     * `projects/{project}/locations/{location}/featureGroups/{featureGroup}`
     * </pre>
     *
     * <code>string name = 1 [(.google.api.field_behavior) = IDENTIFIER];</code>
     *
     * @return The bytes for name.
     */
    public com.google.protobuf.ByteString getNameBytes() {
      java.lang.Object ref = name_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        name_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Identifier. Name of the FeatureGroup. Format:
     * `projects/{project}/locations/{location}/featureGroups/{featureGroup}`
     * </pre>
     *
     * <code>string name = 1 [(.google.api.field_behavior) = IDENTIFIER];</code>
     *
     * @param value The name to set.
     * @return This builder for chaining.
     */
    public Builder setName(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      name_ = value;
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Identifier. Name of the FeatureGroup. Format:
     * `projects/{project}/locations/{location}/featureGroups/{featureGroup}`
     * </pre>
     *
     * <code>string name = 1 [(.google.api.field_behavior) = IDENTIFIER];</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearName() {
      name_ = getDefaultInstance().getName();
      bitField0_ = (bitField0_ & ~0x00000002);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Identifier. Name of the FeatureGroup. Format:
     * `projects/{project}/locations/{location}/featureGroups/{featureGroup}`
     * </pre>
     *
     * <code>string name = 1 [(.google.api.field_behavior) = IDENTIFIER];</code>
     *
     * @param value The bytes for name to set.
     * @return This builder for chaining.
     */
    public Builder setNameBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      name_ = value;
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }

    private com.google.protobuf.Timestamp createTime_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Timestamp,
            com.google.protobuf.Timestamp.Builder,
            com.google.protobuf.TimestampOrBuilder>
        createTimeBuilder_;
    /**
     *
     *
     * <pre>
     * Output only. Timestamp when this FeatureGroup was created.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp create_time = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return Whether the createTime field is set.
     */
    public boolean hasCreateTime() {
      return ((bitField0_ & 0x00000004) != 0);
    }
    /**
     *
     *
     * <pre>
     * Output only. Timestamp when this FeatureGroup was created.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp create_time = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return The createTime.
     */
    public com.google.protobuf.Timestamp getCreateTime() {
      if (createTimeBuilder_ == null) {
        return createTime_ == null
            ? com.google.protobuf.Timestamp.getDefaultInstance()
            : createTime_;
      } else {
        return createTimeBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. Timestamp when this FeatureGroup was created.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp create_time = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder setCreateTime(com.google.protobuf.Timestamp value) {
      if (createTimeBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        createTime_ = value;
      } else {
        createTimeBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Timestamp when this FeatureGroup was created.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp create_time = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder setCreateTime(com.google.protobuf.Timestamp.Builder builderForValue) {
      if (createTimeBuilder_ == null) {
        createTime_ = builderForValue.build();
      } else {
        createTimeBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Timestamp when this FeatureGroup was created.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp create_time = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder mergeCreateTime(com.google.protobuf.Timestamp value) {
      if (createTimeBuilder_ == null) {
        if (((bitField0_ & 0x00000004) != 0)
            && createTime_ != null
            && createTime_ != com.google.protobuf.Timestamp.getDefaultInstance()) {
          getCreateTimeBuilder().mergeFrom(value);
        } else {
          createTime_ = value;
        }
      } else {
        createTimeBuilder_.mergeFrom(value);
      }
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Timestamp when this FeatureGroup was created.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp create_time = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder clearCreateTime() {
      bitField0_ = (bitField0_ & ~0x00000004);
      createTime_ = null;
      if (createTimeBuilder_ != null) {
        createTimeBuilder_.dispose();
        createTimeBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Timestamp when this FeatureGroup was created.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp create_time = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.protobuf.Timestamp.Builder getCreateTimeBuilder() {
      bitField0_ |= 0x00000004;
      onChanged();
      return getCreateTimeFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Output only. Timestamp when this FeatureGroup was created.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp create_time = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.protobuf.TimestampOrBuilder getCreateTimeOrBuilder() {
      if (createTimeBuilder_ != null) {
        return createTimeBuilder_.getMessageOrBuilder();
      } else {
        return createTime_ == null
            ? com.google.protobuf.Timestamp.getDefaultInstance()
            : createTime_;
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. Timestamp when this FeatureGroup was created.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp create_time = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Timestamp,
            com.google.protobuf.Timestamp.Builder,
            com.google.protobuf.TimestampOrBuilder>
        getCreateTimeFieldBuilder() {
      if (createTimeBuilder_ == null) {
        createTimeBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.protobuf.Timestamp,
                com.google.protobuf.Timestamp.Builder,
                com.google.protobuf.TimestampOrBuilder>(
                getCreateTime(), getParentForChildren(), isClean());
        createTime_ = null;
      }
      return createTimeBuilder_;
    }

    private com.google.protobuf.Timestamp updateTime_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Timestamp,
            com.google.protobuf.Timestamp.Builder,
            com.google.protobuf.TimestampOrBuilder>
        updateTimeBuilder_;
    /**
     *
     *
     * <pre>
     * Output only. Timestamp when this FeatureGroup was last updated.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp update_time = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return Whether the updateTime field is set.
     */
    public boolean hasUpdateTime() {
      return ((bitField0_ & 0x00000008) != 0);
    }
    /**
     *
     *
     * <pre>
     * Output only. Timestamp when this FeatureGroup was last updated.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp update_time = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return The updateTime.
     */
    public com.google.protobuf.Timestamp getUpdateTime() {
      if (updateTimeBuilder_ == null) {
        return updateTime_ == null
            ? com.google.protobuf.Timestamp.getDefaultInstance()
            : updateTime_;
      } else {
        return updateTimeBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. Timestamp when this FeatureGroup was last updated.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp update_time = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder setUpdateTime(com.google.protobuf.Timestamp value) {
      if (updateTimeBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        updateTime_ = value;
      } else {
        updateTimeBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000008;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Timestamp when this FeatureGroup was last updated.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp update_time = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder setUpdateTime(com.google.protobuf.Timestamp.Builder builderForValue) {
      if (updateTimeBuilder_ == null) {
        updateTime_ = builderForValue.build();
      } else {
        updateTimeBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000008;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Timestamp when this FeatureGroup was last updated.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp update_time = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder mergeUpdateTime(com.google.protobuf.Timestamp value) {
      if (updateTimeBuilder_ == null) {
        if (((bitField0_ & 0x00000008) != 0)
            && updateTime_ != null
            && updateTime_ != com.google.protobuf.Timestamp.getDefaultInstance()) {
          getUpdateTimeBuilder().mergeFrom(value);
        } else {
          updateTime_ = value;
        }
      } else {
        updateTimeBuilder_.mergeFrom(value);
      }
      bitField0_ |= 0x00000008;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Timestamp when this FeatureGroup was last updated.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp update_time = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder clearUpdateTime() {
      bitField0_ = (bitField0_ & ~0x00000008);
      updateTime_ = null;
      if (updateTimeBuilder_ != null) {
        updateTimeBuilder_.dispose();
        updateTimeBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Timestamp when this FeatureGroup was last updated.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp update_time = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.protobuf.Timestamp.Builder getUpdateTimeBuilder() {
      bitField0_ |= 0x00000008;
      onChanged();
      return getUpdateTimeFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Output only. Timestamp when this FeatureGroup was last updated.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp update_time = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.protobuf.TimestampOrBuilder getUpdateTimeOrBuilder() {
      if (updateTimeBuilder_ != null) {
        return updateTimeBuilder_.getMessageOrBuilder();
      } else {
        return updateTime_ == null
            ? com.google.protobuf.Timestamp.getDefaultInstance()
            : updateTime_;
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. Timestamp when this FeatureGroup was last updated.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp update_time = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Timestamp,
            com.google.protobuf.Timestamp.Builder,
            com.google.protobuf.TimestampOrBuilder>
        getUpdateTimeFieldBuilder() {
      if (updateTimeBuilder_ == null) {
        updateTimeBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.protobuf.Timestamp,
                com.google.protobuf.Timestamp.Builder,
                com.google.protobuf.TimestampOrBuilder>(
                getUpdateTime(), getParentForChildren(), isClean());
        updateTime_ = null;
      }
      return updateTimeBuilder_;
    }

    private java.lang.Object etag_ = "";
    /**
     *
     *
     * <pre>
     * Optional. Used to perform consistent read-modify-write updates. If not set,
     * a blind "overwrite" update happens.
     * </pre>
     *
     * <code>string etag = 4 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return The etag.
     */
    public java.lang.String getEtag() {
      java.lang.Object ref = etag_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        etag_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Optional. Used to perform consistent read-modify-write updates. If not set,
     * a blind "overwrite" update happens.
     * </pre>
     *
     * <code>string etag = 4 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return The bytes for etag.
     */
    public com.google.protobuf.ByteString getEtagBytes() {
      java.lang.Object ref = etag_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        etag_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Optional. Used to perform consistent read-modify-write updates. If not set,
     * a blind "overwrite" update happens.
     * </pre>
     *
     * <code>string etag = 4 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @param value The etag to set.
     * @return This builder for chaining.
     */
    public Builder setEtag(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      etag_ = value;
      bitField0_ |= 0x00000010;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. Used to perform consistent read-modify-write updates. If not set,
     * a blind "overwrite" update happens.
     * </pre>
     *
     * <code>string etag = 4 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearEtag() {
      etag_ = getDefaultInstance().getEtag();
      bitField0_ = (bitField0_ & ~0x00000010);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. Used to perform consistent read-modify-write updates. If not set,
     * a blind "overwrite" update happens.
     * </pre>
     *
     * <code>string etag = 4 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @param value The bytes for etag to set.
     * @return This builder for chaining.
     */
    public Builder setEtagBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      etag_ = value;
      bitField0_ |= 0x00000010;
      onChanged();
      return this;
    }

    private com.google.protobuf.MapField<java.lang.String, java.lang.String> labels_;

    private com.google.protobuf.MapField<java.lang.String, java.lang.String> internalGetLabels() {
      if (labels_ == null) {
        return com.google.protobuf.MapField.emptyMapField(LabelsDefaultEntryHolder.defaultEntry);
      }
      return labels_;
    }

    private com.google.protobuf.MapField<java.lang.String, java.lang.String>
        internalGetMutableLabels() {
      if (labels_ == null) {
        labels_ = com.google.protobuf.MapField.newMapField(LabelsDefaultEntryHolder.defaultEntry);
      }
      if (!labels_.isMutable()) {
        labels_ = labels_.copy();
      }
      bitField0_ |= 0x00000020;
      onChanged();
      return labels_;
    }

    public int getLabelsCount() {
      return internalGetLabels().getMap().size();
    }
    /**
     *
     *
     * <pre>
     * Optional. The labels with user-defined metadata to organize your
     * FeatureGroup.
     *
     * Label keys and values can be no longer than 64 characters
     * (Unicode codepoints), can only contain lowercase letters, numeric
     * characters, underscores and dashes. International characters are allowed.
     *
     * See https://goo.gl/xmQnxf for more information on and examples of labels.
     * No more than 64 user labels can be associated with one
     * FeatureGroup(System labels are excluded)." System reserved label keys
     * are prefixed with "aiplatform.googleapis.com/" and are immutable.
     * </pre>
     *
     * <code>map&lt;string, string&gt; labels = 5 [(.google.api.field_behavior) = OPTIONAL];</code>
     */
    @java.lang.Override
    public boolean containsLabels(java.lang.String key) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      return internalGetLabels().getMap().containsKey(key);
    }
    /** Use {@link #getLabelsMap()} instead. */
    @java.lang.Override
    @java.lang.Deprecated
    public java.util.Map<java.lang.String, java.lang.String> getLabels() {
      return getLabelsMap();
    }
    /**
     *
     *
     * <pre>
     * Optional. The labels with user-defined metadata to organize your
     * FeatureGroup.
     *
     * Label keys and values can be no longer than 64 characters
     * (Unicode codepoints), can only contain lowercase letters, numeric
     * characters, underscores and dashes. International characters are allowed.
     *
     * See https://goo.gl/xmQnxf for more information on and examples of labels.
     * No more than 64 user labels can be associated with one
     * FeatureGroup(System labels are excluded)." System reserved label keys
     * are prefixed with "aiplatform.googleapis.com/" and are immutable.
     * </pre>
     *
     * <code>map&lt;string, string&gt; labels = 5 [(.google.api.field_behavior) = OPTIONAL];</code>
     */
    @java.lang.Override
    public java.util.Map<java.lang.String, java.lang.String> getLabelsMap() {
      return internalGetLabels().getMap();
    }
    /**
     *
     *
     * <pre>
     * Optional. The labels with user-defined metadata to organize your
     * FeatureGroup.
     *
     * Label keys and values can be no longer than 64 characters
     * (Unicode codepoints), can only contain lowercase letters, numeric
     * characters, underscores and dashes. International characters are allowed.
     *
     * See https://goo.gl/xmQnxf for more information on and examples of labels.
     * No more than 64 user labels can be associated with one
     * FeatureGroup(System labels are excluded)." System reserved label keys
     * are prefixed with "aiplatform.googleapis.com/" and are immutable.
     * </pre>
     *
     * <code>map&lt;string, string&gt; labels = 5 [(.google.api.field_behavior) = OPTIONAL];</code>
     */
    @java.lang.Override
    public /* nullable */ java.lang.String getLabelsOrDefault(
        java.lang.String key,
        /* nullable */
        java.lang.String defaultValue) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      java.util.Map<java.lang.String, java.lang.String> map = internalGetLabels().getMap();
      return map.containsKey(key) ? map.get(key) : defaultValue;
    }
    /**
     *
     *
     * <pre>
     * Optional. The labels with user-defined metadata to organize your
     * FeatureGroup.
     *
     * Label keys and values can be no longer than 64 characters
     * (Unicode codepoints), can only contain lowercase letters, numeric
     * characters, underscores and dashes. International characters are allowed.
     *
     * See https://goo.gl/xmQnxf for more information on and examples of labels.
     * No more than 64 user labels can be associated with one
     * FeatureGroup(System labels are excluded)." System reserved label keys
     * are prefixed with "aiplatform.googleapis.com/" and are immutable.
     * </pre>
     *
     * <code>map&lt;string, string&gt; labels = 5 [(.google.api.field_behavior) = OPTIONAL];</code>
     */
    @java.lang.Override
    public java.lang.String getLabelsOrThrow(java.lang.String key) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      java.util.Map<java.lang.String, java.lang.String> map = internalGetLabels().getMap();
      if (!map.containsKey(key)) {
        throw new java.lang.IllegalArgumentException();
      }
      return map.get(key);
    }

    public Builder clearLabels() {
      bitField0_ = (bitField0_ & ~0x00000020);
      internalGetMutableLabels().getMutableMap().clear();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. The labels with user-defined metadata to organize your
     * FeatureGroup.
     *
     * Label keys and values can be no longer than 64 characters
     * (Unicode codepoints), can only contain lowercase letters, numeric
     * characters, underscores and dashes. International characters are allowed.
     *
     * See https://goo.gl/xmQnxf for more information on and examples of labels.
     * No more than 64 user labels can be associated with one
     * FeatureGroup(System labels are excluded)." System reserved label keys
     * are prefixed with "aiplatform.googleapis.com/" and are immutable.
     * </pre>
     *
     * <code>map&lt;string, string&gt; labels = 5 [(.google.api.field_behavior) = OPTIONAL];</code>
     */
    public Builder removeLabels(java.lang.String key) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      internalGetMutableLabels().getMutableMap().remove(key);
      return this;
    }
    /** Use alternate mutation accessors instead. */
    @java.lang.Deprecated
    public java.util.Map<java.lang.String, java.lang.String> getMutableLabels() {
      bitField0_ |= 0x00000020;
      return internalGetMutableLabels().getMutableMap();
    }
    /**
     *
     *
     * <pre>
     * Optional. The labels with user-defined metadata to organize your
     * FeatureGroup.
     *
     * Label keys and values can be no longer than 64 characters
     * (Unicode codepoints), can only contain lowercase letters, numeric
     * characters, underscores and dashes. International characters are allowed.
     *
     * See https://goo.gl/xmQnxf for more information on and examples of labels.
     * No more than 64 user labels can be associated with one
     * FeatureGroup(System labels are excluded)." System reserved label keys
     * are prefixed with "aiplatform.googleapis.com/" and are immutable.
     * </pre>
     *
     * <code>map&lt;string, string&gt; labels = 5 [(.google.api.field_behavior) = OPTIONAL];</code>
     */
    public Builder putLabels(java.lang.String key, java.lang.String value) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      if (value == null) {
        throw new NullPointerException("map value");
      }
      internalGetMutableLabels().getMutableMap().put(key, value);
      bitField0_ |= 0x00000020;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. The labels with user-defined metadata to organize your
     * FeatureGroup.
     *
     * Label keys and values can be no longer than 64 characters
     * (Unicode codepoints), can only contain lowercase letters, numeric
     * characters, underscores and dashes. International characters are allowed.
     *
     * See https://goo.gl/xmQnxf for more information on and examples of labels.
     * No more than 64 user labels can be associated with one
     * FeatureGroup(System labels are excluded)." System reserved label keys
     * are prefixed with "aiplatform.googleapis.com/" and are immutable.
     * </pre>
     *
     * <code>map&lt;string, string&gt; labels = 5 [(.google.api.field_behavior) = OPTIONAL];</code>
     */
    public Builder putAllLabels(java.util.Map<java.lang.String, java.lang.String> values) {
      internalGetMutableLabels().getMutableMap().putAll(values);
      bitField0_ |= 0x00000020;
      return this;
    }

    private java.lang.Object description_ = "";
    /**
     *
     *
     * <pre>
     * Optional. Description of the FeatureGroup.
     * </pre>
     *
     * <code>string description = 6 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return The description.
     */
    public java.lang.String getDescription() {
      java.lang.Object ref = description_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        description_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Optional. Description of the FeatureGroup.
     * </pre>
     *
     * <code>string description = 6 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return The bytes for description.
     */
    public com.google.protobuf.ByteString getDescriptionBytes() {
      java.lang.Object ref = description_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        description_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Optional. Description of the FeatureGroup.
     * </pre>
     *
     * <code>string description = 6 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @param value The description to set.
     * @return This builder for chaining.
     */
    public Builder setDescription(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      description_ = value;
      bitField0_ |= 0x00000040;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. Description of the FeatureGroup.
     * </pre>
     *
     * <code>string description = 6 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearDescription() {
      description_ = getDefaultInstance().getDescription();
      bitField0_ = (bitField0_ & ~0x00000040);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. Description of the FeatureGroup.
     * </pre>
     *
     * <code>string description = 6 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @param value The bytes for description to set.
     * @return This builder for chaining.
     */
    public Builder setDescriptionBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      description_ = value;
      bitField0_ |= 0x00000040;
      onChanged();
      return this;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.cloud.aiplatform.v1beta1.FeatureGroup)
  }

  // @@protoc_insertion_point(class_scope:google.cloud.aiplatform.v1beta1.FeatureGroup)
  private static final com.google.cloud.aiplatform.v1beta1.FeatureGroup DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.cloud.aiplatform.v1beta1.FeatureGroup();
  }

  public static com.google.cloud.aiplatform.v1beta1.FeatureGroup getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<FeatureGroup> PARSER =
      new com.google.protobuf.AbstractParser<FeatureGroup>() {
        @java.lang.Override
        public FeatureGroup parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          Builder builder = newBuilder();
          try {
            builder.mergeFrom(input, extensionRegistry);
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.setUnfinishedMessage(builder.buildPartial());
          } catch (com.google.protobuf.UninitializedMessageException e) {
            throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
          } catch (java.io.IOException e) {
            throw new com.google.protobuf.InvalidProtocolBufferException(e)
                .setUnfinishedMessage(builder.buildPartial());
          }
          return builder.buildPartial();
        }
      };

  public static com.google.protobuf.Parser<FeatureGroup> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<FeatureGroup> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.cloud.aiplatform.v1beta1.FeatureGroup getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
