/*
 * Copyright 2023 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/cloud/aiplatform/v1beta1/model_service.proto

package com.google.cloud.aiplatform.v1beta1;

/**
 *
 *
 * <pre>
 * Request message for
 * [ModelService.MergeVersionAliases][google.cloud.aiplatform.v1beta1.ModelService.MergeVersionAliases].
 * </pre>
 *
 * Protobuf type {@code google.cloud.aiplatform.v1beta1.MergeVersionAliasesRequest}
 */
public final class MergeVersionAliasesRequest extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.cloud.aiplatform.v1beta1.MergeVersionAliasesRequest)
    MergeVersionAliasesRequestOrBuilder {
  private static final long serialVersionUID = 0L;
  // Use MergeVersionAliasesRequest.newBuilder() to construct.
  private MergeVersionAliasesRequest(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private MergeVersionAliasesRequest() {
    name_ = "";
    versionAliases_ = com.google.protobuf.LazyStringArrayList.emptyList();
  }

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new MergeVersionAliasesRequest();
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.cloud.aiplatform.v1beta1.ModelServiceProto
        .internal_static_google_cloud_aiplatform_v1beta1_MergeVersionAliasesRequest_descriptor;
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.cloud.aiplatform.v1beta1.ModelServiceProto
        .internal_static_google_cloud_aiplatform_v1beta1_MergeVersionAliasesRequest_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.cloud.aiplatform.v1beta1.MergeVersionAliasesRequest.class,
            com.google.cloud.aiplatform.v1beta1.MergeVersionAliasesRequest.Builder.class);
  }

  public static final int NAME_FIELD_NUMBER = 1;

  @SuppressWarnings("serial")
  private volatile java.lang.Object name_ = "";
  /**
   *
   *
   * <pre>
   * Required. The name of the model version to merge aliases, with a version ID
   * explicitly included.
   *
   * Example: `projects/{project}/locations/{location}/models/{model}&#64;1234`
   * </pre>
   *
   * <code>
   * string name = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
   * </code>
   *
   * @return The name.
   */
  @java.lang.Override
  public java.lang.String getName() {
    java.lang.Object ref = name_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      name_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Required. The name of the model version to merge aliases, with a version ID
   * explicitly included.
   *
   * Example: `projects/{project}/locations/{location}/models/{model}&#64;1234`
   * </pre>
   *
   * <code>
   * string name = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
   * </code>
   *
   * @return The bytes for name.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getNameBytes() {
    java.lang.Object ref = name_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      name_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int VERSION_ALIASES_FIELD_NUMBER = 2;

  @SuppressWarnings("serial")
  private com.google.protobuf.LazyStringArrayList versionAliases_ =
      com.google.protobuf.LazyStringArrayList.emptyList();
  /**
   *
   *
   * <pre>
   * Required. The set of version aliases to merge.
   * The alias should be at most 128 characters, and match
   * `[a-z][a-zA-Z0-9-]{0,126}[a-z-0-9]`.
   * Add the `-` prefix to an alias means removing that alias from the version.
   * `-` is NOT counted in the 128 characters. Example: `-golden` means removing
   * the `golden` alias from the version.
   *
   * There is NO ordering in aliases, which means
   * 1) The aliases returned from GetModel API might not have the exactly same
   * order from this MergeVersionAliases API. 2) Adding and deleting the same
   * alias in the request is not recommended, and the 2 operations will be
   * cancelled out.
   * </pre>
   *
   * <code>repeated string version_aliases = 2 [(.google.api.field_behavior) = REQUIRED];</code>
   *
   * @return A list containing the versionAliases.
   */
  public com.google.protobuf.ProtocolStringList getVersionAliasesList() {
    return versionAliases_;
  }
  /**
   *
   *
   * <pre>
   * Required. The set of version aliases to merge.
   * The alias should be at most 128 characters, and match
   * `[a-z][a-zA-Z0-9-]{0,126}[a-z-0-9]`.
   * Add the `-` prefix to an alias means removing that alias from the version.
   * `-` is NOT counted in the 128 characters. Example: `-golden` means removing
   * the `golden` alias from the version.
   *
   * There is NO ordering in aliases, which means
   * 1) The aliases returned from GetModel API might not have the exactly same
   * order from this MergeVersionAliases API. 2) Adding and deleting the same
   * alias in the request is not recommended, and the 2 operations will be
   * cancelled out.
   * </pre>
   *
   * <code>repeated string version_aliases = 2 [(.google.api.field_behavior) = REQUIRED];</code>
   *
   * @return The count of versionAliases.
   */
  public int getVersionAliasesCount() {
    return versionAliases_.size();
  }
  /**
   *
   *
   * <pre>
   * Required. The set of version aliases to merge.
   * The alias should be at most 128 characters, and match
   * `[a-z][a-zA-Z0-9-]{0,126}[a-z-0-9]`.
   * Add the `-` prefix to an alias means removing that alias from the version.
   * `-` is NOT counted in the 128 characters. Example: `-golden` means removing
   * the `golden` alias from the version.
   *
   * There is NO ordering in aliases, which means
   * 1) The aliases returned from GetModel API might not have the exactly same
   * order from this MergeVersionAliases API. 2) Adding and deleting the same
   * alias in the request is not recommended, and the 2 operations will be
   * cancelled out.
   * </pre>
   *
   * <code>repeated string version_aliases = 2 [(.google.api.field_behavior) = REQUIRED];</code>
   *
   * @param index The index of the element to return.
   * @return The versionAliases at the given index.
   */
  public java.lang.String getVersionAliases(int index) {
    return versionAliases_.get(index);
  }
  /**
   *
   *
   * <pre>
   * Required. The set of version aliases to merge.
   * The alias should be at most 128 characters, and match
   * `[a-z][a-zA-Z0-9-]{0,126}[a-z-0-9]`.
   * Add the `-` prefix to an alias means removing that alias from the version.
   * `-` is NOT counted in the 128 characters. Example: `-golden` means removing
   * the `golden` alias from the version.
   *
   * There is NO ordering in aliases, which means
   * 1) The aliases returned from GetModel API might not have the exactly same
   * order from this MergeVersionAliases API. 2) Adding and deleting the same
   * alias in the request is not recommended, and the 2 operations will be
   * cancelled out.
   * </pre>
   *
   * <code>repeated string version_aliases = 2 [(.google.api.field_behavior) = REQUIRED];</code>
   *
   * @param index The index of the value to return.
   * @return The bytes of the versionAliases at the given index.
   */
  public com.google.protobuf.ByteString getVersionAliasesBytes(int index) {
    return versionAliases_.getByteString(index);
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(name_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 1, name_);
    }
    for (int i = 0; i < versionAliases_.size(); i++) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 2, versionAliases_.getRaw(i));
    }
    getUnknownFields().writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(name_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(1, name_);
    }
    {
      int dataSize = 0;
      for (int i = 0; i < versionAliases_.size(); i++) {
        dataSize += computeStringSizeNoTag(versionAliases_.getRaw(i));
      }
      size += dataSize;
      size += 1 * getVersionAliasesList().size();
    }
    size += getUnknownFields().getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.cloud.aiplatform.v1beta1.MergeVersionAliasesRequest)) {
      return super.equals(obj);
    }
    com.google.cloud.aiplatform.v1beta1.MergeVersionAliasesRequest other =
        (com.google.cloud.aiplatform.v1beta1.MergeVersionAliasesRequest) obj;

    if (!getName().equals(other.getName())) return false;
    if (!getVersionAliasesList().equals(other.getVersionAliasesList())) return false;
    if (!getUnknownFields().equals(other.getUnknownFields())) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    hash = (37 * hash) + NAME_FIELD_NUMBER;
    hash = (53 * hash) + getName().hashCode();
    if (getVersionAliasesCount() > 0) {
      hash = (37 * hash) + VERSION_ALIASES_FIELD_NUMBER;
      hash = (53 * hash) + getVersionAliasesList().hashCode();
    }
    hash = (29 * hash) + getUnknownFields().hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.cloud.aiplatform.v1beta1.MergeVersionAliasesRequest parseFrom(
      java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.aiplatform.v1beta1.MergeVersionAliasesRequest parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.aiplatform.v1beta1.MergeVersionAliasesRequest parseFrom(
      com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.aiplatform.v1beta1.MergeVersionAliasesRequest parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.aiplatform.v1beta1.MergeVersionAliasesRequest parseFrom(
      byte[] data) throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.aiplatform.v1beta1.MergeVersionAliasesRequest parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.aiplatform.v1beta1.MergeVersionAliasesRequest parseFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.aiplatform.v1beta1.MergeVersionAliasesRequest parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.aiplatform.v1beta1.MergeVersionAliasesRequest parseDelimitedFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.cloud.aiplatform.v1beta1.MergeVersionAliasesRequest parseDelimitedFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.aiplatform.v1beta1.MergeVersionAliasesRequest parseFrom(
      com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.aiplatform.v1beta1.MergeVersionAliasesRequest parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(
      com.google.cloud.aiplatform.v1beta1.MergeVersionAliasesRequest prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }
  /**
   *
   *
   * <pre>
   * Request message for
   * [ModelService.MergeVersionAliases][google.cloud.aiplatform.v1beta1.ModelService.MergeVersionAliases].
   * </pre>
   *
   * Protobuf type {@code google.cloud.aiplatform.v1beta1.MergeVersionAliasesRequest}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.cloud.aiplatform.v1beta1.MergeVersionAliasesRequest)
      com.google.cloud.aiplatform.v1beta1.MergeVersionAliasesRequestOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.aiplatform.v1beta1.ModelServiceProto
          .internal_static_google_cloud_aiplatform_v1beta1_MergeVersionAliasesRequest_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.aiplatform.v1beta1.ModelServiceProto
          .internal_static_google_cloud_aiplatform_v1beta1_MergeVersionAliasesRequest_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.aiplatform.v1beta1.MergeVersionAliasesRequest.class,
              com.google.cloud.aiplatform.v1beta1.MergeVersionAliasesRequest.Builder.class);
    }

    // Construct using com.google.cloud.aiplatform.v1beta1.MergeVersionAliasesRequest.newBuilder()
    private Builder() {}

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      bitField0_ = 0;
      name_ = "";
      versionAliases_ = com.google.protobuf.LazyStringArrayList.emptyList();
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.cloud.aiplatform.v1beta1.ModelServiceProto
          .internal_static_google_cloud_aiplatform_v1beta1_MergeVersionAliasesRequest_descriptor;
    }

    @java.lang.Override
    public com.google.cloud.aiplatform.v1beta1.MergeVersionAliasesRequest
        getDefaultInstanceForType() {
      return com.google.cloud.aiplatform.v1beta1.MergeVersionAliasesRequest.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.cloud.aiplatform.v1beta1.MergeVersionAliasesRequest build() {
      com.google.cloud.aiplatform.v1beta1.MergeVersionAliasesRequest result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.cloud.aiplatform.v1beta1.MergeVersionAliasesRequest buildPartial() {
      com.google.cloud.aiplatform.v1beta1.MergeVersionAliasesRequest result =
          new com.google.cloud.aiplatform.v1beta1.MergeVersionAliasesRequest(this);
      if (bitField0_ != 0) {
        buildPartial0(result);
      }
      onBuilt();
      return result;
    }

    private void buildPartial0(
        com.google.cloud.aiplatform.v1beta1.MergeVersionAliasesRequest result) {
      int from_bitField0_ = bitField0_;
      if (((from_bitField0_ & 0x00000001) != 0)) {
        result.name_ = name_;
      }
      if (((from_bitField0_ & 0x00000002) != 0)) {
        versionAliases_.makeImmutable();
        result.versionAliases_ = versionAliases_;
      }
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.cloud.aiplatform.v1beta1.MergeVersionAliasesRequest) {
        return mergeFrom((com.google.cloud.aiplatform.v1beta1.MergeVersionAliasesRequest) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(com.google.cloud.aiplatform.v1beta1.MergeVersionAliasesRequest other) {
      if (other
          == com.google.cloud.aiplatform.v1beta1.MergeVersionAliasesRequest.getDefaultInstance())
        return this;
      if (!other.getName().isEmpty()) {
        name_ = other.name_;
        bitField0_ |= 0x00000001;
        onChanged();
      }
      if (!other.versionAliases_.isEmpty()) {
        if (versionAliases_.isEmpty()) {
          versionAliases_ = other.versionAliases_;
          bitField0_ |= 0x00000002;
        } else {
          ensureVersionAliasesIsMutable();
          versionAliases_.addAll(other.versionAliases_);
        }
        onChanged();
      }
      this.mergeUnknownFields(other.getUnknownFields());
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 10:
              {
                name_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000001;
                break;
              } // case 10
            case 18:
              {
                java.lang.String s = input.readStringRequireUtf8();
                ensureVersionAliasesIsMutable();
                versionAliases_.add(s);
                break;
              } // case 18
            default:
              {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
          } // switch (tag)
        } // while (!done)
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.unwrapIOException();
      } finally {
        onChanged();
      } // finally
      return this;
    }

    private int bitField0_;

    private java.lang.Object name_ = "";
    /**
     *
     *
     * <pre>
     * Required. The name of the model version to merge aliases, with a version ID
     * explicitly included.
     *
     * Example: `projects/{project}/locations/{location}/models/{model}&#64;1234`
     * </pre>
     *
     * <code>
     * string name = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @return The name.
     */
    public java.lang.String getName() {
      java.lang.Object ref = name_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        name_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Required. The name of the model version to merge aliases, with a version ID
     * explicitly included.
     *
     * Example: `projects/{project}/locations/{location}/models/{model}&#64;1234`
     * </pre>
     *
     * <code>
     * string name = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @return The bytes for name.
     */
    public com.google.protobuf.ByteString getNameBytes() {
      java.lang.Object ref = name_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        name_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Required. The name of the model version to merge aliases, with a version ID
     * explicitly included.
     *
     * Example: `projects/{project}/locations/{location}/models/{model}&#64;1234`
     * </pre>
     *
     * <code>
     * string name = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @param value The name to set.
     * @return This builder for chaining.
     */
    public Builder setName(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      name_ = value;
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. The name of the model version to merge aliases, with a version ID
     * explicitly included.
     *
     * Example: `projects/{project}/locations/{location}/models/{model}&#64;1234`
     * </pre>
     *
     * <code>
     * string name = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @return This builder for chaining.
     */
    public Builder clearName() {
      name_ = getDefaultInstance().getName();
      bitField0_ = (bitField0_ & ~0x00000001);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. The name of the model version to merge aliases, with a version ID
     * explicitly included.
     *
     * Example: `projects/{project}/locations/{location}/models/{model}&#64;1234`
     * </pre>
     *
     * <code>
     * string name = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @param value The bytes for name to set.
     * @return This builder for chaining.
     */
    public Builder setNameBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      name_ = value;
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }

    private com.google.protobuf.LazyStringArrayList versionAliases_ =
        com.google.protobuf.LazyStringArrayList.emptyList();

    private void ensureVersionAliasesIsMutable() {
      if (!versionAliases_.isModifiable()) {
        versionAliases_ = new com.google.protobuf.LazyStringArrayList(versionAliases_);
      }
      bitField0_ |= 0x00000002;
    }
    /**
     *
     *
     * <pre>
     * Required. The set of version aliases to merge.
     * The alias should be at most 128 characters, and match
     * `[a-z][a-zA-Z0-9-]{0,126}[a-z-0-9]`.
     * Add the `-` prefix to an alias means removing that alias from the version.
     * `-` is NOT counted in the 128 characters. Example: `-golden` means removing
     * the `golden` alias from the version.
     *
     * There is NO ordering in aliases, which means
     * 1) The aliases returned from GetModel API might not have the exactly same
     * order from this MergeVersionAliases API. 2) Adding and deleting the same
     * alias in the request is not recommended, and the 2 operations will be
     * cancelled out.
     * </pre>
     *
     * <code>repeated string version_aliases = 2 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return A list containing the versionAliases.
     */
    public com.google.protobuf.ProtocolStringList getVersionAliasesList() {
      versionAliases_.makeImmutable();
      return versionAliases_;
    }
    /**
     *
     *
     * <pre>
     * Required. The set of version aliases to merge.
     * The alias should be at most 128 characters, and match
     * `[a-z][a-zA-Z0-9-]{0,126}[a-z-0-9]`.
     * Add the `-` prefix to an alias means removing that alias from the version.
     * `-` is NOT counted in the 128 characters. Example: `-golden` means removing
     * the `golden` alias from the version.
     *
     * There is NO ordering in aliases, which means
     * 1) The aliases returned from GetModel API might not have the exactly same
     * order from this MergeVersionAliases API. 2) Adding and deleting the same
     * alias in the request is not recommended, and the 2 operations will be
     * cancelled out.
     * </pre>
     *
     * <code>repeated string version_aliases = 2 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return The count of versionAliases.
     */
    public int getVersionAliasesCount() {
      return versionAliases_.size();
    }
    /**
     *
     *
     * <pre>
     * Required. The set of version aliases to merge.
     * The alias should be at most 128 characters, and match
     * `[a-z][a-zA-Z0-9-]{0,126}[a-z-0-9]`.
     * Add the `-` prefix to an alias means removing that alias from the version.
     * `-` is NOT counted in the 128 characters. Example: `-golden` means removing
     * the `golden` alias from the version.
     *
     * There is NO ordering in aliases, which means
     * 1) The aliases returned from GetModel API might not have the exactly same
     * order from this MergeVersionAliases API. 2) Adding and deleting the same
     * alias in the request is not recommended, and the 2 operations will be
     * cancelled out.
     * </pre>
     *
     * <code>repeated string version_aliases = 2 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @param index The index of the element to return.
     * @return The versionAliases at the given index.
     */
    public java.lang.String getVersionAliases(int index) {
      return versionAliases_.get(index);
    }
    /**
     *
     *
     * <pre>
     * Required. The set of version aliases to merge.
     * The alias should be at most 128 characters, and match
     * `[a-z][a-zA-Z0-9-]{0,126}[a-z-0-9]`.
     * Add the `-` prefix to an alias means removing that alias from the version.
     * `-` is NOT counted in the 128 characters. Example: `-golden` means removing
     * the `golden` alias from the version.
     *
     * There is NO ordering in aliases, which means
     * 1) The aliases returned from GetModel API might not have the exactly same
     * order from this MergeVersionAliases API. 2) Adding and deleting the same
     * alias in the request is not recommended, and the 2 operations will be
     * cancelled out.
     * </pre>
     *
     * <code>repeated string version_aliases = 2 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @param index The index of the value to return.
     * @return The bytes of the versionAliases at the given index.
     */
    public com.google.protobuf.ByteString getVersionAliasesBytes(int index) {
      return versionAliases_.getByteString(index);
    }
    /**
     *
     *
     * <pre>
     * Required. The set of version aliases to merge.
     * The alias should be at most 128 characters, and match
     * `[a-z][a-zA-Z0-9-]{0,126}[a-z-0-9]`.
     * Add the `-` prefix to an alias means removing that alias from the version.
     * `-` is NOT counted in the 128 characters. Example: `-golden` means removing
     * the `golden` alias from the version.
     *
     * There is NO ordering in aliases, which means
     * 1) The aliases returned from GetModel API might not have the exactly same
     * order from this MergeVersionAliases API. 2) Adding and deleting the same
     * alias in the request is not recommended, and the 2 operations will be
     * cancelled out.
     * </pre>
     *
     * <code>repeated string version_aliases = 2 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @param index The index to set the value at.
     * @param value The versionAliases to set.
     * @return This builder for chaining.
     */
    public Builder setVersionAliases(int index, java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      ensureVersionAliasesIsMutable();
      versionAliases_.set(index, value);
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. The set of version aliases to merge.
     * The alias should be at most 128 characters, and match
     * `[a-z][a-zA-Z0-9-]{0,126}[a-z-0-9]`.
     * Add the `-` prefix to an alias means removing that alias from the version.
     * `-` is NOT counted in the 128 characters. Example: `-golden` means removing
     * the `golden` alias from the version.
     *
     * There is NO ordering in aliases, which means
     * 1) The aliases returned from GetModel API might not have the exactly same
     * order from this MergeVersionAliases API. 2) Adding and deleting the same
     * alias in the request is not recommended, and the 2 operations will be
     * cancelled out.
     * </pre>
     *
     * <code>repeated string version_aliases = 2 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @param value The versionAliases to add.
     * @return This builder for chaining.
     */
    public Builder addVersionAliases(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      ensureVersionAliasesIsMutable();
      versionAliases_.add(value);
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. The set of version aliases to merge.
     * The alias should be at most 128 characters, and match
     * `[a-z][a-zA-Z0-9-]{0,126}[a-z-0-9]`.
     * Add the `-` prefix to an alias means removing that alias from the version.
     * `-` is NOT counted in the 128 characters. Example: `-golden` means removing
     * the `golden` alias from the version.
     *
     * There is NO ordering in aliases, which means
     * 1) The aliases returned from GetModel API might not have the exactly same
     * order from this MergeVersionAliases API. 2) Adding and deleting the same
     * alias in the request is not recommended, and the 2 operations will be
     * cancelled out.
     * </pre>
     *
     * <code>repeated string version_aliases = 2 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @param values The versionAliases to add.
     * @return This builder for chaining.
     */
    public Builder addAllVersionAliases(java.lang.Iterable<java.lang.String> values) {
      ensureVersionAliasesIsMutable();
      com.google.protobuf.AbstractMessageLite.Builder.addAll(values, versionAliases_);
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. The set of version aliases to merge.
     * The alias should be at most 128 characters, and match
     * `[a-z][a-zA-Z0-9-]{0,126}[a-z-0-9]`.
     * Add the `-` prefix to an alias means removing that alias from the version.
     * `-` is NOT counted in the 128 characters. Example: `-golden` means removing
     * the `golden` alias from the version.
     *
     * There is NO ordering in aliases, which means
     * 1) The aliases returned from GetModel API might not have the exactly same
     * order from this MergeVersionAliases API. 2) Adding and deleting the same
     * alias in the request is not recommended, and the 2 operations will be
     * cancelled out.
     * </pre>
     *
     * <code>repeated string version_aliases = 2 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearVersionAliases() {
      versionAliases_ = com.google.protobuf.LazyStringArrayList.emptyList();
      bitField0_ = (bitField0_ & ~0x00000002);
      ;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. The set of version aliases to merge.
     * The alias should be at most 128 characters, and match
     * `[a-z][a-zA-Z0-9-]{0,126}[a-z-0-9]`.
     * Add the `-` prefix to an alias means removing that alias from the version.
     * `-` is NOT counted in the 128 characters. Example: `-golden` means removing
     * the `golden` alias from the version.
     *
     * There is NO ordering in aliases, which means
     * 1) The aliases returned from GetModel API might not have the exactly same
     * order from this MergeVersionAliases API. 2) Adding and deleting the same
     * alias in the request is not recommended, and the 2 operations will be
     * cancelled out.
     * </pre>
     *
     * <code>repeated string version_aliases = 2 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @param value The bytes of the versionAliases to add.
     * @return This builder for chaining.
     */
    public Builder addVersionAliasesBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      ensureVersionAliasesIsMutable();
      versionAliases_.add(value);
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.cloud.aiplatform.v1beta1.MergeVersionAliasesRequest)
  }

  // @@protoc_insertion_point(class_scope:google.cloud.aiplatform.v1beta1.MergeVersionAliasesRequest)
  private static final com.google.cloud.aiplatform.v1beta1.MergeVersionAliasesRequest
      DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.cloud.aiplatform.v1beta1.MergeVersionAliasesRequest();
  }

  public static com.google.cloud.aiplatform.v1beta1.MergeVersionAliasesRequest
      getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<MergeVersionAliasesRequest> PARSER =
      new com.google.protobuf.AbstractParser<MergeVersionAliasesRequest>() {
        @java.lang.Override
        public MergeVersionAliasesRequest parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          Builder builder = newBuilder();
          try {
            builder.mergeFrom(input, extensionRegistry);
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.setUnfinishedMessage(builder.buildPartial());
          } catch (com.google.protobuf.UninitializedMessageException e) {
            throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
          } catch (java.io.IOException e) {
            throw new com.google.protobuf.InvalidProtocolBufferException(e)
                .setUnfinishedMessage(builder.buildPartial());
          }
          return builder.buildPartial();
        }
      };

  public static com.google.protobuf.Parser<MergeVersionAliasesRequest> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<MergeVersionAliasesRequest> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.cloud.aiplatform.v1beta1.MergeVersionAliasesRequest
      getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
