/*
 * Copyright 2023 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/cloud/aiplatform/v1beta1/dataset_service.proto

package com.google.cloud.aiplatform.v1beta1;

/**
 *
 *
 * <pre>
 * Request message for
 * [DatasetService.SearchDataItems][google.cloud.aiplatform.v1beta1.DatasetService.SearchDataItems].
 * </pre>
 *
 * Protobuf type {@code google.cloud.aiplatform.v1beta1.SearchDataItemsRequest}
 */
public final class SearchDataItemsRequest extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.cloud.aiplatform.v1beta1.SearchDataItemsRequest)
    SearchDataItemsRequestOrBuilder {
  private static final long serialVersionUID = 0L;
  // Use SearchDataItemsRequest.newBuilder() to construct.
  private SearchDataItemsRequest(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private SearchDataItemsRequest() {
    dataset_ = "";
    savedQuery_ = "";
    dataLabelingJob_ = "";
    dataItemFilter_ = "";
    annotationsFilter_ = "";
    annotationFilters_ = com.google.protobuf.LazyStringArrayList.emptyList();
    orderBy_ = "";
    pageToken_ = "";
  }

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new SearchDataItemsRequest();
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.cloud.aiplatform.v1beta1.DatasetServiceProto
        .internal_static_google_cloud_aiplatform_v1beta1_SearchDataItemsRequest_descriptor;
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.cloud.aiplatform.v1beta1.DatasetServiceProto
        .internal_static_google_cloud_aiplatform_v1beta1_SearchDataItemsRequest_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.cloud.aiplatform.v1beta1.SearchDataItemsRequest.class,
            com.google.cloud.aiplatform.v1beta1.SearchDataItemsRequest.Builder.class);
  }

  public interface OrderByAnnotationOrBuilder
      extends
      // @@protoc_insertion_point(interface_extends:google.cloud.aiplatform.v1beta1.SearchDataItemsRequest.OrderByAnnotation)
      com.google.protobuf.MessageOrBuilder {

    /**
     *
     *
     * <pre>
     * Required. Saved query of the Annotation. Only Annotations belong to this
     * saved query will be considered for ordering.
     * </pre>
     *
     * <code>string saved_query = 1 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return The savedQuery.
     */
    java.lang.String getSavedQuery();
    /**
     *
     *
     * <pre>
     * Required. Saved query of the Annotation. Only Annotations belong to this
     * saved query will be considered for ordering.
     * </pre>
     *
     * <code>string saved_query = 1 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return The bytes for savedQuery.
     */
    com.google.protobuf.ByteString getSavedQueryBytes();

    /**
     *
     *
     * <pre>
     * A comma-separated list of annotation fields to order by, sorted in
     * ascending order. Use "desc" after a field name for descending. Must also
     * specify saved_query.
     * </pre>
     *
     * <code>string order_by = 2;</code>
     *
     * @return The orderBy.
     */
    java.lang.String getOrderBy();
    /**
     *
     *
     * <pre>
     * A comma-separated list of annotation fields to order by, sorted in
     * ascending order. Use "desc" after a field name for descending. Must also
     * specify saved_query.
     * </pre>
     *
     * <code>string order_by = 2;</code>
     *
     * @return The bytes for orderBy.
     */
    com.google.protobuf.ByteString getOrderByBytes();
  }
  /**
   *
   *
   * <pre>
   * Expression that allows ranking results based on annotation's property.
   * </pre>
   *
   * Protobuf type {@code google.cloud.aiplatform.v1beta1.SearchDataItemsRequest.OrderByAnnotation}
   */
  public static final class OrderByAnnotation extends com.google.protobuf.GeneratedMessageV3
      implements
      // @@protoc_insertion_point(message_implements:google.cloud.aiplatform.v1beta1.SearchDataItemsRequest.OrderByAnnotation)
      OrderByAnnotationOrBuilder {
    private static final long serialVersionUID = 0L;
    // Use OrderByAnnotation.newBuilder() to construct.
    private OrderByAnnotation(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
      super(builder);
    }

    private OrderByAnnotation() {
      savedQuery_ = "";
      orderBy_ = "";
    }

    @java.lang.Override
    @SuppressWarnings({"unused"})
    protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
      return new OrderByAnnotation();
    }

    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.aiplatform.v1beta1.DatasetServiceProto
          .internal_static_google_cloud_aiplatform_v1beta1_SearchDataItemsRequest_OrderByAnnotation_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.aiplatform.v1beta1.DatasetServiceProto
          .internal_static_google_cloud_aiplatform_v1beta1_SearchDataItemsRequest_OrderByAnnotation_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.aiplatform.v1beta1.SearchDataItemsRequest.OrderByAnnotation.class,
              com.google.cloud.aiplatform.v1beta1.SearchDataItemsRequest.OrderByAnnotation.Builder
                  .class);
    }

    public static final int SAVED_QUERY_FIELD_NUMBER = 1;

    @SuppressWarnings("serial")
    private volatile java.lang.Object savedQuery_ = "";
    /**
     *
     *
     * <pre>
     * Required. Saved query of the Annotation. Only Annotations belong to this
     * saved query will be considered for ordering.
     * </pre>
     *
     * <code>string saved_query = 1 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return The savedQuery.
     */
    @java.lang.Override
    public java.lang.String getSavedQuery() {
      java.lang.Object ref = savedQuery_;
      if (ref instanceof java.lang.String) {
        return (java.lang.String) ref;
      } else {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        savedQuery_ = s;
        return s;
      }
    }
    /**
     *
     *
     * <pre>
     * Required. Saved query of the Annotation. Only Annotations belong to this
     * saved query will be considered for ordering.
     * </pre>
     *
     * <code>string saved_query = 1 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return The bytes for savedQuery.
     */
    @java.lang.Override
    public com.google.protobuf.ByteString getSavedQueryBytes() {
      java.lang.Object ref = savedQuery_;
      if (ref instanceof java.lang.String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        savedQuery_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    public static final int ORDER_BY_FIELD_NUMBER = 2;

    @SuppressWarnings("serial")
    private volatile java.lang.Object orderBy_ = "";
    /**
     *
     *
     * <pre>
     * A comma-separated list of annotation fields to order by, sorted in
     * ascending order. Use "desc" after a field name for descending. Must also
     * specify saved_query.
     * </pre>
     *
     * <code>string order_by = 2;</code>
     *
     * @return The orderBy.
     */
    @java.lang.Override
    public java.lang.String getOrderBy() {
      java.lang.Object ref = orderBy_;
      if (ref instanceof java.lang.String) {
        return (java.lang.String) ref;
      } else {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        orderBy_ = s;
        return s;
      }
    }
    /**
     *
     *
     * <pre>
     * A comma-separated list of annotation fields to order by, sorted in
     * ascending order. Use "desc" after a field name for descending. Must also
     * specify saved_query.
     * </pre>
     *
     * <code>string order_by = 2;</code>
     *
     * @return The bytes for orderBy.
     */
    @java.lang.Override
    public com.google.protobuf.ByteString getOrderByBytes() {
      java.lang.Object ref = orderBy_;
      if (ref instanceof java.lang.String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        orderBy_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    private byte memoizedIsInitialized = -1;

    @java.lang.Override
    public final boolean isInitialized() {
      byte isInitialized = memoizedIsInitialized;
      if (isInitialized == 1) return true;
      if (isInitialized == 0) return false;

      memoizedIsInitialized = 1;
      return true;
    }

    @java.lang.Override
    public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(savedQuery_)) {
        com.google.protobuf.GeneratedMessageV3.writeString(output, 1, savedQuery_);
      }
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(orderBy_)) {
        com.google.protobuf.GeneratedMessageV3.writeString(output, 2, orderBy_);
      }
      getUnknownFields().writeTo(output);
    }

    @java.lang.Override
    public int getSerializedSize() {
      int size = memoizedSize;
      if (size != -1) return size;

      size = 0;
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(savedQuery_)) {
        size += com.google.protobuf.GeneratedMessageV3.computeStringSize(1, savedQuery_);
      }
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(orderBy_)) {
        size += com.google.protobuf.GeneratedMessageV3.computeStringSize(2, orderBy_);
      }
      size += getUnknownFields().getSerializedSize();
      memoizedSize = size;
      return size;
    }

    @java.lang.Override
    public boolean equals(final java.lang.Object obj) {
      if (obj == this) {
        return true;
      }
      if (!(obj
          instanceof
          com.google.cloud.aiplatform.v1beta1.SearchDataItemsRequest.OrderByAnnotation)) {
        return super.equals(obj);
      }
      com.google.cloud.aiplatform.v1beta1.SearchDataItemsRequest.OrderByAnnotation other =
          (com.google.cloud.aiplatform.v1beta1.SearchDataItemsRequest.OrderByAnnotation) obj;

      if (!getSavedQuery().equals(other.getSavedQuery())) return false;
      if (!getOrderBy().equals(other.getOrderBy())) return false;
      if (!getUnknownFields().equals(other.getUnknownFields())) return false;
      return true;
    }

    @java.lang.Override
    public int hashCode() {
      if (memoizedHashCode != 0) {
        return memoizedHashCode;
      }
      int hash = 41;
      hash = (19 * hash) + getDescriptor().hashCode();
      hash = (37 * hash) + SAVED_QUERY_FIELD_NUMBER;
      hash = (53 * hash) + getSavedQuery().hashCode();
      hash = (37 * hash) + ORDER_BY_FIELD_NUMBER;
      hash = (53 * hash) + getOrderBy().hashCode();
      hash = (29 * hash) + getUnknownFields().hashCode();
      memoizedHashCode = hash;
      return hash;
    }

    public static com.google.cloud.aiplatform.v1beta1.SearchDataItemsRequest.OrderByAnnotation
        parseFrom(java.nio.ByteBuffer data)
            throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.aiplatform.v1beta1.SearchDataItemsRequest.OrderByAnnotation
        parseFrom(
            java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.aiplatform.v1beta1.SearchDataItemsRequest.OrderByAnnotation
        parseFrom(com.google.protobuf.ByteString data)
            throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.aiplatform.v1beta1.SearchDataItemsRequest.OrderByAnnotation
        parseFrom(
            com.google.protobuf.ByteString data,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.aiplatform.v1beta1.SearchDataItemsRequest.OrderByAnnotation
        parseFrom(byte[] data) throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.aiplatform.v1beta1.SearchDataItemsRequest.OrderByAnnotation
        parseFrom(byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.aiplatform.v1beta1.SearchDataItemsRequest.OrderByAnnotation
        parseFrom(java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.cloud.aiplatform.v1beta1.SearchDataItemsRequest.OrderByAnnotation
        parseFrom(
            java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.cloud.aiplatform.v1beta1.SearchDataItemsRequest.OrderByAnnotation
        parseDelimitedFrom(java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
    }

    public static com.google.cloud.aiplatform.v1beta1.SearchDataItemsRequest.OrderByAnnotation
        parseDelimitedFrom(
            java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.cloud.aiplatform.v1beta1.SearchDataItemsRequest.OrderByAnnotation
        parseFrom(com.google.protobuf.CodedInputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.cloud.aiplatform.v1beta1.SearchDataItemsRequest.OrderByAnnotation
        parseFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    @java.lang.Override
    public Builder newBuilderForType() {
      return newBuilder();
    }

    public static Builder newBuilder() {
      return DEFAULT_INSTANCE.toBuilder();
    }

    public static Builder newBuilder(
        com.google.cloud.aiplatform.v1beta1.SearchDataItemsRequest.OrderByAnnotation prototype) {
      return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }

    @java.lang.Override
    public Builder toBuilder() {
      return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
    }

    @java.lang.Override
    protected Builder newBuilderForType(
        com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      Builder builder = new Builder(parent);
      return builder;
    }
    /**
     *
     *
     * <pre>
     * Expression that allows ranking results based on annotation's property.
     * </pre>
     *
     * Protobuf type {@code
     * google.cloud.aiplatform.v1beta1.SearchDataItemsRequest.OrderByAnnotation}
     */
    public static final class Builder
        extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
        implements
        // @@protoc_insertion_point(builder_implements:google.cloud.aiplatform.v1beta1.SearchDataItemsRequest.OrderByAnnotation)
        com.google.cloud.aiplatform.v1beta1.SearchDataItemsRequest.OrderByAnnotationOrBuilder {
      public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
        return com.google.cloud.aiplatform.v1beta1.DatasetServiceProto
            .internal_static_google_cloud_aiplatform_v1beta1_SearchDataItemsRequest_OrderByAnnotation_descriptor;
      }

      @java.lang.Override
      protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return com.google.cloud.aiplatform.v1beta1.DatasetServiceProto
            .internal_static_google_cloud_aiplatform_v1beta1_SearchDataItemsRequest_OrderByAnnotation_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                com.google.cloud.aiplatform.v1beta1.SearchDataItemsRequest.OrderByAnnotation.class,
                com.google.cloud.aiplatform.v1beta1.SearchDataItemsRequest.OrderByAnnotation.Builder
                    .class);
      }

      // Construct using
      // com.google.cloud.aiplatform.v1beta1.SearchDataItemsRequest.OrderByAnnotation.newBuilder()
      private Builder() {}

      private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
        super(parent);
      }

      @java.lang.Override
      public Builder clear() {
        super.clear();
        bitField0_ = 0;
        savedQuery_ = "";
        orderBy_ = "";
        return this;
      }

      @java.lang.Override
      public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
        return com.google.cloud.aiplatform.v1beta1.DatasetServiceProto
            .internal_static_google_cloud_aiplatform_v1beta1_SearchDataItemsRequest_OrderByAnnotation_descriptor;
      }

      @java.lang.Override
      public com.google.cloud.aiplatform.v1beta1.SearchDataItemsRequest.OrderByAnnotation
          getDefaultInstanceForType() {
        return com.google.cloud.aiplatform.v1beta1.SearchDataItemsRequest.OrderByAnnotation
            .getDefaultInstance();
      }

      @java.lang.Override
      public com.google.cloud.aiplatform.v1beta1.SearchDataItemsRequest.OrderByAnnotation build() {
        com.google.cloud.aiplatform.v1beta1.SearchDataItemsRequest.OrderByAnnotation result =
            buildPartial();
        if (!result.isInitialized()) {
          throw newUninitializedMessageException(result);
        }
        return result;
      }

      @java.lang.Override
      public com.google.cloud.aiplatform.v1beta1.SearchDataItemsRequest.OrderByAnnotation
          buildPartial() {
        com.google.cloud.aiplatform.v1beta1.SearchDataItemsRequest.OrderByAnnotation result =
            new com.google.cloud.aiplatform.v1beta1.SearchDataItemsRequest.OrderByAnnotation(this);
        if (bitField0_ != 0) {
          buildPartial0(result);
        }
        onBuilt();
        return result;
      }

      private void buildPartial0(
          com.google.cloud.aiplatform.v1beta1.SearchDataItemsRequest.OrderByAnnotation result) {
        int from_bitField0_ = bitField0_;
        if (((from_bitField0_ & 0x00000001) != 0)) {
          result.savedQuery_ = savedQuery_;
        }
        if (((from_bitField0_ & 0x00000002) != 0)) {
          result.orderBy_ = orderBy_;
        }
      }

      @java.lang.Override
      public Builder clone() {
        return super.clone();
      }

      @java.lang.Override
      public Builder setField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.setField(field, value);
      }

      @java.lang.Override
      public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
        return super.clearField(field);
      }

      @java.lang.Override
      public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
        return super.clearOneof(oneof);
      }

      @java.lang.Override
      public Builder setRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          int index,
          java.lang.Object value) {
        return super.setRepeatedField(field, index, value);
      }

      @java.lang.Override
      public Builder addRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.addRepeatedField(field, value);
      }

      @java.lang.Override
      public Builder mergeFrom(com.google.protobuf.Message other) {
        if (other
            instanceof
            com.google.cloud.aiplatform.v1beta1.SearchDataItemsRequest.OrderByAnnotation) {
          return mergeFrom(
              (com.google.cloud.aiplatform.v1beta1.SearchDataItemsRequest.OrderByAnnotation) other);
        } else {
          super.mergeFrom(other);
          return this;
        }
      }

      public Builder mergeFrom(
          com.google.cloud.aiplatform.v1beta1.SearchDataItemsRequest.OrderByAnnotation other) {
        if (other
            == com.google.cloud.aiplatform.v1beta1.SearchDataItemsRequest.OrderByAnnotation
                .getDefaultInstance()) return this;
        if (!other.getSavedQuery().isEmpty()) {
          savedQuery_ = other.savedQuery_;
          bitField0_ |= 0x00000001;
          onChanged();
        }
        if (!other.getOrderBy().isEmpty()) {
          orderBy_ = other.orderBy_;
          bitField0_ |= 0x00000002;
          onChanged();
        }
        this.mergeUnknownFields(other.getUnknownFields());
        onChanged();
        return this;
      }

      @java.lang.Override
      public final boolean isInitialized() {
        return true;
      }

      @java.lang.Override
      public Builder mergeFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        if (extensionRegistry == null) {
          throw new java.lang.NullPointerException();
        }
        try {
          boolean done = false;
          while (!done) {
            int tag = input.readTag();
            switch (tag) {
              case 0:
                done = true;
                break;
              case 10:
                {
                  savedQuery_ = input.readStringRequireUtf8();
                  bitField0_ |= 0x00000001;
                  break;
                } // case 10
              case 18:
                {
                  orderBy_ = input.readStringRequireUtf8();
                  bitField0_ |= 0x00000002;
                  break;
                } // case 18
              default:
                {
                  if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                    done = true; // was an endgroup tag
                  }
                  break;
                } // default:
            } // switch (tag)
          } // while (!done)
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          throw e.unwrapIOException();
        } finally {
          onChanged();
        } // finally
        return this;
      }

      private int bitField0_;

      private java.lang.Object savedQuery_ = "";
      /**
       *
       *
       * <pre>
       * Required. Saved query of the Annotation. Only Annotations belong to this
       * saved query will be considered for ordering.
       * </pre>
       *
       * <code>string saved_query = 1 [(.google.api.field_behavior) = REQUIRED];</code>
       *
       * @return The savedQuery.
       */
      public java.lang.String getSavedQuery() {
        java.lang.Object ref = savedQuery_;
        if (!(ref instanceof java.lang.String)) {
          com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
          java.lang.String s = bs.toStringUtf8();
          savedQuery_ = s;
          return s;
        } else {
          return (java.lang.String) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * Required. Saved query of the Annotation. Only Annotations belong to this
       * saved query will be considered for ordering.
       * </pre>
       *
       * <code>string saved_query = 1 [(.google.api.field_behavior) = REQUIRED];</code>
       *
       * @return The bytes for savedQuery.
       */
      public com.google.protobuf.ByteString getSavedQueryBytes() {
        java.lang.Object ref = savedQuery_;
        if (ref instanceof String) {
          com.google.protobuf.ByteString b =
              com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
          savedQuery_ = b;
          return b;
        } else {
          return (com.google.protobuf.ByteString) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * Required. Saved query of the Annotation. Only Annotations belong to this
       * saved query will be considered for ordering.
       * </pre>
       *
       * <code>string saved_query = 1 [(.google.api.field_behavior) = REQUIRED];</code>
       *
       * @param value The savedQuery to set.
       * @return This builder for chaining.
       */
      public Builder setSavedQuery(java.lang.String value) {
        if (value == null) {
          throw new NullPointerException();
        }
        savedQuery_ = value;
        bitField0_ |= 0x00000001;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Required. Saved query of the Annotation. Only Annotations belong to this
       * saved query will be considered for ordering.
       * </pre>
       *
       * <code>string saved_query = 1 [(.google.api.field_behavior) = REQUIRED];</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearSavedQuery() {
        savedQuery_ = getDefaultInstance().getSavedQuery();
        bitField0_ = (bitField0_ & ~0x00000001);
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Required. Saved query of the Annotation. Only Annotations belong to this
       * saved query will be considered for ordering.
       * </pre>
       *
       * <code>string saved_query = 1 [(.google.api.field_behavior) = REQUIRED];</code>
       *
       * @param value The bytes for savedQuery to set.
       * @return This builder for chaining.
       */
      public Builder setSavedQueryBytes(com.google.protobuf.ByteString value) {
        if (value == null) {
          throw new NullPointerException();
        }
        checkByteStringIsUtf8(value);
        savedQuery_ = value;
        bitField0_ |= 0x00000001;
        onChanged();
        return this;
      }

      private java.lang.Object orderBy_ = "";
      /**
       *
       *
       * <pre>
       * A comma-separated list of annotation fields to order by, sorted in
       * ascending order. Use "desc" after a field name for descending. Must also
       * specify saved_query.
       * </pre>
       *
       * <code>string order_by = 2;</code>
       *
       * @return The orderBy.
       */
      public java.lang.String getOrderBy() {
        java.lang.Object ref = orderBy_;
        if (!(ref instanceof java.lang.String)) {
          com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
          java.lang.String s = bs.toStringUtf8();
          orderBy_ = s;
          return s;
        } else {
          return (java.lang.String) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * A comma-separated list of annotation fields to order by, sorted in
       * ascending order. Use "desc" after a field name for descending. Must also
       * specify saved_query.
       * </pre>
       *
       * <code>string order_by = 2;</code>
       *
       * @return The bytes for orderBy.
       */
      public com.google.protobuf.ByteString getOrderByBytes() {
        java.lang.Object ref = orderBy_;
        if (ref instanceof String) {
          com.google.protobuf.ByteString b =
              com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
          orderBy_ = b;
          return b;
        } else {
          return (com.google.protobuf.ByteString) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * A comma-separated list of annotation fields to order by, sorted in
       * ascending order. Use "desc" after a field name for descending. Must also
       * specify saved_query.
       * </pre>
       *
       * <code>string order_by = 2;</code>
       *
       * @param value The orderBy to set.
       * @return This builder for chaining.
       */
      public Builder setOrderBy(java.lang.String value) {
        if (value == null) {
          throw new NullPointerException();
        }
        orderBy_ = value;
        bitField0_ |= 0x00000002;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * A comma-separated list of annotation fields to order by, sorted in
       * ascending order. Use "desc" after a field name for descending. Must also
       * specify saved_query.
       * </pre>
       *
       * <code>string order_by = 2;</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearOrderBy() {
        orderBy_ = getDefaultInstance().getOrderBy();
        bitField0_ = (bitField0_ & ~0x00000002);
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * A comma-separated list of annotation fields to order by, sorted in
       * ascending order. Use "desc" after a field name for descending. Must also
       * specify saved_query.
       * </pre>
       *
       * <code>string order_by = 2;</code>
       *
       * @param value The bytes for orderBy to set.
       * @return This builder for chaining.
       */
      public Builder setOrderByBytes(com.google.protobuf.ByteString value) {
        if (value == null) {
          throw new NullPointerException();
        }
        checkByteStringIsUtf8(value);
        orderBy_ = value;
        bitField0_ |= 0x00000002;
        onChanged();
        return this;
      }

      @java.lang.Override
      public final Builder setUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.setUnknownFields(unknownFields);
      }

      @java.lang.Override
      public final Builder mergeUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.mergeUnknownFields(unknownFields);
      }

      // @@protoc_insertion_point(builder_scope:google.cloud.aiplatform.v1beta1.SearchDataItemsRequest.OrderByAnnotation)
    }

    // @@protoc_insertion_point(class_scope:google.cloud.aiplatform.v1beta1.SearchDataItemsRequest.OrderByAnnotation)
    private static final com.google.cloud.aiplatform.v1beta1.SearchDataItemsRequest
            .OrderByAnnotation
        DEFAULT_INSTANCE;

    static {
      DEFAULT_INSTANCE =
          new com.google.cloud.aiplatform.v1beta1.SearchDataItemsRequest.OrderByAnnotation();
    }

    public static com.google.cloud.aiplatform.v1beta1.SearchDataItemsRequest.OrderByAnnotation
        getDefaultInstance() {
      return DEFAULT_INSTANCE;
    }

    private static final com.google.protobuf.Parser<OrderByAnnotation> PARSER =
        new com.google.protobuf.AbstractParser<OrderByAnnotation>() {
          @java.lang.Override
          public OrderByAnnotation parsePartialFrom(
              com.google.protobuf.CodedInputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
            Builder builder = newBuilder();
            try {
              builder.mergeFrom(input, extensionRegistry);
            } catch (com.google.protobuf.InvalidProtocolBufferException e) {
              throw e.setUnfinishedMessage(builder.buildPartial());
            } catch (com.google.protobuf.UninitializedMessageException e) {
              throw e.asInvalidProtocolBufferException()
                  .setUnfinishedMessage(builder.buildPartial());
            } catch (java.io.IOException e) {
              throw new com.google.protobuf.InvalidProtocolBufferException(e)
                  .setUnfinishedMessage(builder.buildPartial());
            }
            return builder.buildPartial();
          }
        };

    public static com.google.protobuf.Parser<OrderByAnnotation> parser() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.protobuf.Parser<OrderByAnnotation> getParserForType() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.cloud.aiplatform.v1beta1.SearchDataItemsRequest.OrderByAnnotation
        getDefaultInstanceForType() {
      return DEFAULT_INSTANCE;
    }
  }

  private int orderCase_ = 0;

  @SuppressWarnings("serial")
  private java.lang.Object order_;

  public enum OrderCase
      implements
          com.google.protobuf.Internal.EnumLite,
          com.google.protobuf.AbstractMessage.InternalOneOfEnum {
    ORDER_BY_DATA_ITEM(12),
    ORDER_BY_ANNOTATION(13),
    ORDER_NOT_SET(0);
    private final int value;

    private OrderCase(int value) {
      this.value = value;
    }
    /**
     * @param value The number of the enum to look for.
     * @return The enum associated with the given number.
     * @deprecated Use {@link #forNumber(int)} instead.
     */
    @java.lang.Deprecated
    public static OrderCase valueOf(int value) {
      return forNumber(value);
    }

    public static OrderCase forNumber(int value) {
      switch (value) {
        case 12:
          return ORDER_BY_DATA_ITEM;
        case 13:
          return ORDER_BY_ANNOTATION;
        case 0:
          return ORDER_NOT_SET;
        default:
          return null;
      }
    }

    public int getNumber() {
      return this.value;
    }
  };

  public OrderCase getOrderCase() {
    return OrderCase.forNumber(orderCase_);
  }

  public static final int ORDER_BY_DATA_ITEM_FIELD_NUMBER = 12;
  /**
   *
   *
   * <pre>
   * A comma-separated list of data item fields to order by, sorted in
   * ascending order. Use "desc" after a field name for descending.
   * </pre>
   *
   * <code>string order_by_data_item = 12;</code>
   *
   * @return Whether the orderByDataItem field is set.
   */
  public boolean hasOrderByDataItem() {
    return orderCase_ == 12;
  }
  /**
   *
   *
   * <pre>
   * A comma-separated list of data item fields to order by, sorted in
   * ascending order. Use "desc" after a field name for descending.
   * </pre>
   *
   * <code>string order_by_data_item = 12;</code>
   *
   * @return The orderByDataItem.
   */
  public java.lang.String getOrderByDataItem() {
    java.lang.Object ref = "";
    if (orderCase_ == 12) {
      ref = order_;
    }
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      if (orderCase_ == 12) {
        order_ = s;
      }
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * A comma-separated list of data item fields to order by, sorted in
   * ascending order. Use "desc" after a field name for descending.
   * </pre>
   *
   * <code>string order_by_data_item = 12;</code>
   *
   * @return The bytes for orderByDataItem.
   */
  public com.google.protobuf.ByteString getOrderByDataItemBytes() {
    java.lang.Object ref = "";
    if (orderCase_ == 12) {
      ref = order_;
    }
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      if (orderCase_ == 12) {
        order_ = b;
      }
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int ORDER_BY_ANNOTATION_FIELD_NUMBER = 13;
  /**
   *
   *
   * <pre>
   * Expression that allows ranking results based on annotation's property.
   * </pre>
   *
   * <code>
   * .google.cloud.aiplatform.v1beta1.SearchDataItemsRequest.OrderByAnnotation order_by_annotation = 13;
   * </code>
   *
   * @return Whether the orderByAnnotation field is set.
   */
  @java.lang.Override
  public boolean hasOrderByAnnotation() {
    return orderCase_ == 13;
  }
  /**
   *
   *
   * <pre>
   * Expression that allows ranking results based on annotation's property.
   * </pre>
   *
   * <code>
   * .google.cloud.aiplatform.v1beta1.SearchDataItemsRequest.OrderByAnnotation order_by_annotation = 13;
   * </code>
   *
   * @return The orderByAnnotation.
   */
  @java.lang.Override
  public com.google.cloud.aiplatform.v1beta1.SearchDataItemsRequest.OrderByAnnotation
      getOrderByAnnotation() {
    if (orderCase_ == 13) {
      return (com.google.cloud.aiplatform.v1beta1.SearchDataItemsRequest.OrderByAnnotation) order_;
    }
    return com.google.cloud.aiplatform.v1beta1.SearchDataItemsRequest.OrderByAnnotation
        .getDefaultInstance();
  }
  /**
   *
   *
   * <pre>
   * Expression that allows ranking results based on annotation's property.
   * </pre>
   *
   * <code>
   * .google.cloud.aiplatform.v1beta1.SearchDataItemsRequest.OrderByAnnotation order_by_annotation = 13;
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.aiplatform.v1beta1.SearchDataItemsRequest.OrderByAnnotationOrBuilder
      getOrderByAnnotationOrBuilder() {
    if (orderCase_ == 13) {
      return (com.google.cloud.aiplatform.v1beta1.SearchDataItemsRequest.OrderByAnnotation) order_;
    }
    return com.google.cloud.aiplatform.v1beta1.SearchDataItemsRequest.OrderByAnnotation
        .getDefaultInstance();
  }

  public static final int DATASET_FIELD_NUMBER = 1;

  @SuppressWarnings("serial")
  private volatile java.lang.Object dataset_ = "";
  /**
   *
   *
   * <pre>
   * Required. The resource name of the Dataset from which to search DataItems.
   * Format:
   * `projects/{project}/locations/{location}/datasets/{dataset}`
   * </pre>
   *
   * <code>
   * string dataset = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
   * </code>
   *
   * @return The dataset.
   */
  @java.lang.Override
  public java.lang.String getDataset() {
    java.lang.Object ref = dataset_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      dataset_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Required. The resource name of the Dataset from which to search DataItems.
   * Format:
   * `projects/{project}/locations/{location}/datasets/{dataset}`
   * </pre>
   *
   * <code>
   * string dataset = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
   * </code>
   *
   * @return The bytes for dataset.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getDatasetBytes() {
    java.lang.Object ref = dataset_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      dataset_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int SAVED_QUERY_FIELD_NUMBER = 2;

  @SuppressWarnings("serial")
  private volatile java.lang.Object savedQuery_ = "";
  /**
   *
   *
   * <pre>
   * The resource name of a SavedQuery(annotation set in UI).
   * Format:
   * `projects/{project}/locations/{location}/datasets/{dataset}/savedQueries/{saved_query}`
   * All of the search will be done in the context of this SavedQuery.
   * </pre>
   *
   * <code>string saved_query = 2 [deprecated = true, (.google.api.resource_reference) = { ... }
   * </code>
   *
   * @deprecated google.cloud.aiplatform.v1beta1.SearchDataItemsRequest.saved_query is deprecated.
   *     See google/cloud/aiplatform/v1beta1/dataset_service.proto;l=629
   * @return The savedQuery.
   */
  @java.lang.Override
  @java.lang.Deprecated
  public java.lang.String getSavedQuery() {
    java.lang.Object ref = savedQuery_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      savedQuery_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * The resource name of a SavedQuery(annotation set in UI).
   * Format:
   * `projects/{project}/locations/{location}/datasets/{dataset}/savedQueries/{saved_query}`
   * All of the search will be done in the context of this SavedQuery.
   * </pre>
   *
   * <code>string saved_query = 2 [deprecated = true, (.google.api.resource_reference) = { ... }
   * </code>
   *
   * @deprecated google.cloud.aiplatform.v1beta1.SearchDataItemsRequest.saved_query is deprecated.
   *     See google/cloud/aiplatform/v1beta1/dataset_service.proto;l=629
   * @return The bytes for savedQuery.
   */
  @java.lang.Override
  @java.lang.Deprecated
  public com.google.protobuf.ByteString getSavedQueryBytes() {
    java.lang.Object ref = savedQuery_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      savedQuery_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int DATA_LABELING_JOB_FIELD_NUMBER = 3;

  @SuppressWarnings("serial")
  private volatile java.lang.Object dataLabelingJob_ = "";
  /**
   *
   *
   * <pre>
   * The resource name of a DataLabelingJob.
   * Format:
   * `projects/{project}/locations/{location}/dataLabelingJobs/{data_labeling_job}`
   * If this field is set, all of the search will be done in the context of
   * this DataLabelingJob.
   * </pre>
   *
   * <code>string data_labeling_job = 3;</code>
   *
   * @return The dataLabelingJob.
   */
  @java.lang.Override
  public java.lang.String getDataLabelingJob() {
    java.lang.Object ref = dataLabelingJob_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      dataLabelingJob_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * The resource name of a DataLabelingJob.
   * Format:
   * `projects/{project}/locations/{location}/dataLabelingJobs/{data_labeling_job}`
   * If this field is set, all of the search will be done in the context of
   * this DataLabelingJob.
   * </pre>
   *
   * <code>string data_labeling_job = 3;</code>
   *
   * @return The bytes for dataLabelingJob.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getDataLabelingJobBytes() {
    java.lang.Object ref = dataLabelingJob_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      dataLabelingJob_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int DATA_ITEM_FILTER_FIELD_NUMBER = 4;

  @SuppressWarnings("serial")
  private volatile java.lang.Object dataItemFilter_ = "";
  /**
   *
   *
   * <pre>
   * An expression for filtering the DataItem that will be returned.
   *
   *   * `data_item_id` - for = or !=.
   *   * `labeled` - for = or !=.
   *   * `has_annotation(ANNOTATION_SPEC_ID)` - true only for DataItem that
   *     have at least one annotation with annotation_spec_id =
   *     `ANNOTATION_SPEC_ID` in the context of SavedQuery or DataLabelingJob.
   *
   * For example:
   *
   * * `data_item=1`
   * * `has_annotation(5)`
   * </pre>
   *
   * <code>string data_item_filter = 4;</code>
   *
   * @return The dataItemFilter.
   */
  @java.lang.Override
  public java.lang.String getDataItemFilter() {
    java.lang.Object ref = dataItemFilter_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      dataItemFilter_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * An expression for filtering the DataItem that will be returned.
   *
   *   * `data_item_id` - for = or !=.
   *   * `labeled` - for = or !=.
   *   * `has_annotation(ANNOTATION_SPEC_ID)` - true only for DataItem that
   *     have at least one annotation with annotation_spec_id =
   *     `ANNOTATION_SPEC_ID` in the context of SavedQuery or DataLabelingJob.
   *
   * For example:
   *
   * * `data_item=1`
   * * `has_annotation(5)`
   * </pre>
   *
   * <code>string data_item_filter = 4;</code>
   *
   * @return The bytes for dataItemFilter.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getDataItemFilterBytes() {
    java.lang.Object ref = dataItemFilter_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      dataItemFilter_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int ANNOTATIONS_FILTER_FIELD_NUMBER = 5;

  @SuppressWarnings("serial")
  private volatile java.lang.Object annotationsFilter_ = "";
  /**
   *
   *
   * <pre>
   * An expression for filtering the Annotations that will be returned per
   * DataItem.
   *   * `annotation_spec_id` - for = or !=.
   * </pre>
   *
   * <code>string annotations_filter = 5 [deprecated = true];</code>
   *
   * @deprecated google.cloud.aiplatform.v1beta1.SearchDataItemsRequest.annotations_filter is
   *     deprecated. See google/cloud/aiplatform/v1beta1/dataset_service.proto;l=660
   * @return The annotationsFilter.
   */
  @java.lang.Override
  @java.lang.Deprecated
  public java.lang.String getAnnotationsFilter() {
    java.lang.Object ref = annotationsFilter_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      annotationsFilter_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * An expression for filtering the Annotations that will be returned per
   * DataItem.
   *   * `annotation_spec_id` - for = or !=.
   * </pre>
   *
   * <code>string annotations_filter = 5 [deprecated = true];</code>
   *
   * @deprecated google.cloud.aiplatform.v1beta1.SearchDataItemsRequest.annotations_filter is
   *     deprecated. See google/cloud/aiplatform/v1beta1/dataset_service.proto;l=660
   * @return The bytes for annotationsFilter.
   */
  @java.lang.Override
  @java.lang.Deprecated
  public com.google.protobuf.ByteString getAnnotationsFilterBytes() {
    java.lang.Object ref = annotationsFilter_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      annotationsFilter_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int ANNOTATION_FILTERS_FIELD_NUMBER = 11;

  @SuppressWarnings("serial")
  private com.google.protobuf.LazyStringArrayList annotationFilters_ =
      com.google.protobuf.LazyStringArrayList.emptyList();
  /**
   *
   *
   * <pre>
   * An expression that specifies what Annotations will be returned per
   * DataItem. Annotations satisfied either of the conditions will be returned.
   *   * `annotation_spec_id` - for = or !=.
   * Must specify `saved_query_id=` - saved query id that annotations should
   * belong to.
   * </pre>
   *
   * <code>repeated string annotation_filters = 11;</code>
   *
   * @return A list containing the annotationFilters.
   */
  public com.google.protobuf.ProtocolStringList getAnnotationFiltersList() {
    return annotationFilters_;
  }
  /**
   *
   *
   * <pre>
   * An expression that specifies what Annotations will be returned per
   * DataItem. Annotations satisfied either of the conditions will be returned.
   *   * `annotation_spec_id` - for = or !=.
   * Must specify `saved_query_id=` - saved query id that annotations should
   * belong to.
   * </pre>
   *
   * <code>repeated string annotation_filters = 11;</code>
   *
   * @return The count of annotationFilters.
   */
  public int getAnnotationFiltersCount() {
    return annotationFilters_.size();
  }
  /**
   *
   *
   * <pre>
   * An expression that specifies what Annotations will be returned per
   * DataItem. Annotations satisfied either of the conditions will be returned.
   *   * `annotation_spec_id` - for = or !=.
   * Must specify `saved_query_id=` - saved query id that annotations should
   * belong to.
   * </pre>
   *
   * <code>repeated string annotation_filters = 11;</code>
   *
   * @param index The index of the element to return.
   * @return The annotationFilters at the given index.
   */
  public java.lang.String getAnnotationFilters(int index) {
    return annotationFilters_.get(index);
  }
  /**
   *
   *
   * <pre>
   * An expression that specifies what Annotations will be returned per
   * DataItem. Annotations satisfied either of the conditions will be returned.
   *   * `annotation_spec_id` - for = or !=.
   * Must specify `saved_query_id=` - saved query id that annotations should
   * belong to.
   * </pre>
   *
   * <code>repeated string annotation_filters = 11;</code>
   *
   * @param index The index of the value to return.
   * @return The bytes of the annotationFilters at the given index.
   */
  public com.google.protobuf.ByteString getAnnotationFiltersBytes(int index) {
    return annotationFilters_.getByteString(index);
  }

  public static final int FIELD_MASK_FIELD_NUMBER = 6;
  private com.google.protobuf.FieldMask fieldMask_;
  /**
   *
   *
   * <pre>
   * Mask specifying which fields of
   * [DataItemView][google.cloud.aiplatform.v1beta1.DataItemView] to read.
   * </pre>
   *
   * <code>.google.protobuf.FieldMask field_mask = 6;</code>
   *
   * @return Whether the fieldMask field is set.
   */
  @java.lang.Override
  public boolean hasFieldMask() {
    return fieldMask_ != null;
  }
  /**
   *
   *
   * <pre>
   * Mask specifying which fields of
   * [DataItemView][google.cloud.aiplatform.v1beta1.DataItemView] to read.
   * </pre>
   *
   * <code>.google.protobuf.FieldMask field_mask = 6;</code>
   *
   * @return The fieldMask.
   */
  @java.lang.Override
  public com.google.protobuf.FieldMask getFieldMask() {
    return fieldMask_ == null ? com.google.protobuf.FieldMask.getDefaultInstance() : fieldMask_;
  }
  /**
   *
   *
   * <pre>
   * Mask specifying which fields of
   * [DataItemView][google.cloud.aiplatform.v1beta1.DataItemView] to read.
   * </pre>
   *
   * <code>.google.protobuf.FieldMask field_mask = 6;</code>
   */
  @java.lang.Override
  public com.google.protobuf.FieldMaskOrBuilder getFieldMaskOrBuilder() {
    return fieldMask_ == null ? com.google.protobuf.FieldMask.getDefaultInstance() : fieldMask_;
  }

  public static final int ANNOTATIONS_LIMIT_FIELD_NUMBER = 7;
  private int annotationsLimit_ = 0;
  /**
   *
   *
   * <pre>
   * If set, only up to this many of Annotations will be returned per
   * DataItemView. The maximum value is 1000. If not set, the maximum value will
   * be used.
   * </pre>
   *
   * <code>int32 annotations_limit = 7;</code>
   *
   * @return The annotationsLimit.
   */
  @java.lang.Override
  public int getAnnotationsLimit() {
    return annotationsLimit_;
  }

  public static final int PAGE_SIZE_FIELD_NUMBER = 8;
  private int pageSize_ = 0;
  /**
   *
   *
   * <pre>
   * Requested page size. Server may return fewer results than requested.
   * Default and maximum page size is 100.
   * </pre>
   *
   * <code>int32 page_size = 8;</code>
   *
   * @return The pageSize.
   */
  @java.lang.Override
  public int getPageSize() {
    return pageSize_;
  }

  public static final int ORDER_BY_FIELD_NUMBER = 9;

  @SuppressWarnings("serial")
  private volatile java.lang.Object orderBy_ = "";
  /**
   *
   *
   * <pre>
   * A comma-separated list of fields to order by, sorted in ascending order.
   * Use "desc" after a field name for descending.
   * </pre>
   *
   * <code>string order_by = 9 [deprecated = true];</code>
   *
   * @deprecated google.cloud.aiplatform.v1beta1.SearchDataItemsRequest.order_by is deprecated. See
   *     google/cloud/aiplatform/v1beta1/dataset_service.proto;l=684
   * @return The orderBy.
   */
  @java.lang.Override
  @java.lang.Deprecated
  public java.lang.String getOrderBy() {
    java.lang.Object ref = orderBy_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      orderBy_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * A comma-separated list of fields to order by, sorted in ascending order.
   * Use "desc" after a field name for descending.
   * </pre>
   *
   * <code>string order_by = 9 [deprecated = true];</code>
   *
   * @deprecated google.cloud.aiplatform.v1beta1.SearchDataItemsRequest.order_by is deprecated. See
   *     google/cloud/aiplatform/v1beta1/dataset_service.proto;l=684
   * @return The bytes for orderBy.
   */
  @java.lang.Override
  @java.lang.Deprecated
  public com.google.protobuf.ByteString getOrderByBytes() {
    java.lang.Object ref = orderBy_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      orderBy_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int PAGE_TOKEN_FIELD_NUMBER = 10;

  @SuppressWarnings("serial")
  private volatile java.lang.Object pageToken_ = "";
  /**
   *
   *
   * <pre>
   * A token identifying a page of results for the server to return
   * Typically obtained via
   * [SearchDataItemsResponse.next_page_token][google.cloud.aiplatform.v1beta1.SearchDataItemsResponse.next_page_token]
   * of the previous
   * [DatasetService.SearchDataItems][google.cloud.aiplatform.v1beta1.DatasetService.SearchDataItems]
   * call.
   * </pre>
   *
   * <code>string page_token = 10;</code>
   *
   * @return The pageToken.
   */
  @java.lang.Override
  public java.lang.String getPageToken() {
    java.lang.Object ref = pageToken_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      pageToken_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * A token identifying a page of results for the server to return
   * Typically obtained via
   * [SearchDataItemsResponse.next_page_token][google.cloud.aiplatform.v1beta1.SearchDataItemsResponse.next_page_token]
   * of the previous
   * [DatasetService.SearchDataItems][google.cloud.aiplatform.v1beta1.DatasetService.SearchDataItems]
   * call.
   * </pre>
   *
   * <code>string page_token = 10;</code>
   *
   * @return The bytes for pageToken.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getPageTokenBytes() {
    java.lang.Object ref = pageToken_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      pageToken_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(dataset_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 1, dataset_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(savedQuery_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 2, savedQuery_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(dataLabelingJob_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 3, dataLabelingJob_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(dataItemFilter_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 4, dataItemFilter_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(annotationsFilter_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 5, annotationsFilter_);
    }
    if (fieldMask_ != null) {
      output.writeMessage(6, getFieldMask());
    }
    if (annotationsLimit_ != 0) {
      output.writeInt32(7, annotationsLimit_);
    }
    if (pageSize_ != 0) {
      output.writeInt32(8, pageSize_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(orderBy_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 9, orderBy_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(pageToken_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 10, pageToken_);
    }
    for (int i = 0; i < annotationFilters_.size(); i++) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 11, annotationFilters_.getRaw(i));
    }
    if (orderCase_ == 12) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 12, order_);
    }
    if (orderCase_ == 13) {
      output.writeMessage(
          13,
          (com.google.cloud.aiplatform.v1beta1.SearchDataItemsRequest.OrderByAnnotation) order_);
    }
    getUnknownFields().writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(dataset_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(1, dataset_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(savedQuery_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(2, savedQuery_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(dataLabelingJob_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(3, dataLabelingJob_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(dataItemFilter_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(4, dataItemFilter_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(annotationsFilter_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(5, annotationsFilter_);
    }
    if (fieldMask_ != null) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(6, getFieldMask());
    }
    if (annotationsLimit_ != 0) {
      size += com.google.protobuf.CodedOutputStream.computeInt32Size(7, annotationsLimit_);
    }
    if (pageSize_ != 0) {
      size += com.google.protobuf.CodedOutputStream.computeInt32Size(8, pageSize_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(orderBy_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(9, orderBy_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(pageToken_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(10, pageToken_);
    }
    {
      int dataSize = 0;
      for (int i = 0; i < annotationFilters_.size(); i++) {
        dataSize += computeStringSizeNoTag(annotationFilters_.getRaw(i));
      }
      size += dataSize;
      size += 1 * getAnnotationFiltersList().size();
    }
    if (orderCase_ == 12) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(12, order_);
    }
    if (orderCase_ == 13) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(
              13,
              (com.google.cloud.aiplatform.v1beta1.SearchDataItemsRequest.OrderByAnnotation)
                  order_);
    }
    size += getUnknownFields().getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.cloud.aiplatform.v1beta1.SearchDataItemsRequest)) {
      return super.equals(obj);
    }
    com.google.cloud.aiplatform.v1beta1.SearchDataItemsRequest other =
        (com.google.cloud.aiplatform.v1beta1.SearchDataItemsRequest) obj;

    if (!getDataset().equals(other.getDataset())) return false;
    if (!getSavedQuery().equals(other.getSavedQuery())) return false;
    if (!getDataLabelingJob().equals(other.getDataLabelingJob())) return false;
    if (!getDataItemFilter().equals(other.getDataItemFilter())) return false;
    if (!getAnnotationsFilter().equals(other.getAnnotationsFilter())) return false;
    if (!getAnnotationFiltersList().equals(other.getAnnotationFiltersList())) return false;
    if (hasFieldMask() != other.hasFieldMask()) return false;
    if (hasFieldMask()) {
      if (!getFieldMask().equals(other.getFieldMask())) return false;
    }
    if (getAnnotationsLimit() != other.getAnnotationsLimit()) return false;
    if (getPageSize() != other.getPageSize()) return false;
    if (!getOrderBy().equals(other.getOrderBy())) return false;
    if (!getPageToken().equals(other.getPageToken())) return false;
    if (!getOrderCase().equals(other.getOrderCase())) return false;
    switch (orderCase_) {
      case 12:
        if (!getOrderByDataItem().equals(other.getOrderByDataItem())) return false;
        break;
      case 13:
        if (!getOrderByAnnotation().equals(other.getOrderByAnnotation())) return false;
        break;
      case 0:
      default:
    }
    if (!getUnknownFields().equals(other.getUnknownFields())) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    hash = (37 * hash) + DATASET_FIELD_NUMBER;
    hash = (53 * hash) + getDataset().hashCode();
    hash = (37 * hash) + SAVED_QUERY_FIELD_NUMBER;
    hash = (53 * hash) + getSavedQuery().hashCode();
    hash = (37 * hash) + DATA_LABELING_JOB_FIELD_NUMBER;
    hash = (53 * hash) + getDataLabelingJob().hashCode();
    hash = (37 * hash) + DATA_ITEM_FILTER_FIELD_NUMBER;
    hash = (53 * hash) + getDataItemFilter().hashCode();
    hash = (37 * hash) + ANNOTATIONS_FILTER_FIELD_NUMBER;
    hash = (53 * hash) + getAnnotationsFilter().hashCode();
    if (getAnnotationFiltersCount() > 0) {
      hash = (37 * hash) + ANNOTATION_FILTERS_FIELD_NUMBER;
      hash = (53 * hash) + getAnnotationFiltersList().hashCode();
    }
    if (hasFieldMask()) {
      hash = (37 * hash) + FIELD_MASK_FIELD_NUMBER;
      hash = (53 * hash) + getFieldMask().hashCode();
    }
    hash = (37 * hash) + ANNOTATIONS_LIMIT_FIELD_NUMBER;
    hash = (53 * hash) + getAnnotationsLimit();
    hash = (37 * hash) + PAGE_SIZE_FIELD_NUMBER;
    hash = (53 * hash) + getPageSize();
    hash = (37 * hash) + ORDER_BY_FIELD_NUMBER;
    hash = (53 * hash) + getOrderBy().hashCode();
    hash = (37 * hash) + PAGE_TOKEN_FIELD_NUMBER;
    hash = (53 * hash) + getPageToken().hashCode();
    switch (orderCase_) {
      case 12:
        hash = (37 * hash) + ORDER_BY_DATA_ITEM_FIELD_NUMBER;
        hash = (53 * hash) + getOrderByDataItem().hashCode();
        break;
      case 13:
        hash = (37 * hash) + ORDER_BY_ANNOTATION_FIELD_NUMBER;
        hash = (53 * hash) + getOrderByAnnotation().hashCode();
        break;
      case 0:
      default:
    }
    hash = (29 * hash) + getUnknownFields().hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.cloud.aiplatform.v1beta1.SearchDataItemsRequest parseFrom(
      java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.aiplatform.v1beta1.SearchDataItemsRequest parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.aiplatform.v1beta1.SearchDataItemsRequest parseFrom(
      com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.aiplatform.v1beta1.SearchDataItemsRequest parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.aiplatform.v1beta1.SearchDataItemsRequest parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.aiplatform.v1beta1.SearchDataItemsRequest parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.aiplatform.v1beta1.SearchDataItemsRequest parseFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.aiplatform.v1beta1.SearchDataItemsRequest parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.aiplatform.v1beta1.SearchDataItemsRequest parseDelimitedFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.cloud.aiplatform.v1beta1.SearchDataItemsRequest parseDelimitedFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.aiplatform.v1beta1.SearchDataItemsRequest parseFrom(
      com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.aiplatform.v1beta1.SearchDataItemsRequest parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(
      com.google.cloud.aiplatform.v1beta1.SearchDataItemsRequest prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }
  /**
   *
   *
   * <pre>
   * Request message for
   * [DatasetService.SearchDataItems][google.cloud.aiplatform.v1beta1.DatasetService.SearchDataItems].
   * </pre>
   *
   * Protobuf type {@code google.cloud.aiplatform.v1beta1.SearchDataItemsRequest}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.cloud.aiplatform.v1beta1.SearchDataItemsRequest)
      com.google.cloud.aiplatform.v1beta1.SearchDataItemsRequestOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.aiplatform.v1beta1.DatasetServiceProto
          .internal_static_google_cloud_aiplatform_v1beta1_SearchDataItemsRequest_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.aiplatform.v1beta1.DatasetServiceProto
          .internal_static_google_cloud_aiplatform_v1beta1_SearchDataItemsRequest_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.aiplatform.v1beta1.SearchDataItemsRequest.class,
              com.google.cloud.aiplatform.v1beta1.SearchDataItemsRequest.Builder.class);
    }

    // Construct using com.google.cloud.aiplatform.v1beta1.SearchDataItemsRequest.newBuilder()
    private Builder() {}

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      bitField0_ = 0;
      if (orderByAnnotationBuilder_ != null) {
        orderByAnnotationBuilder_.clear();
      }
      dataset_ = "";
      savedQuery_ = "";
      dataLabelingJob_ = "";
      dataItemFilter_ = "";
      annotationsFilter_ = "";
      annotationFilters_ = com.google.protobuf.LazyStringArrayList.emptyList();
      fieldMask_ = null;
      if (fieldMaskBuilder_ != null) {
        fieldMaskBuilder_.dispose();
        fieldMaskBuilder_ = null;
      }
      annotationsLimit_ = 0;
      pageSize_ = 0;
      orderBy_ = "";
      pageToken_ = "";
      orderCase_ = 0;
      order_ = null;
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.cloud.aiplatform.v1beta1.DatasetServiceProto
          .internal_static_google_cloud_aiplatform_v1beta1_SearchDataItemsRequest_descriptor;
    }

    @java.lang.Override
    public com.google.cloud.aiplatform.v1beta1.SearchDataItemsRequest getDefaultInstanceForType() {
      return com.google.cloud.aiplatform.v1beta1.SearchDataItemsRequest.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.cloud.aiplatform.v1beta1.SearchDataItemsRequest build() {
      com.google.cloud.aiplatform.v1beta1.SearchDataItemsRequest result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.cloud.aiplatform.v1beta1.SearchDataItemsRequest buildPartial() {
      com.google.cloud.aiplatform.v1beta1.SearchDataItemsRequest result =
          new com.google.cloud.aiplatform.v1beta1.SearchDataItemsRequest(this);
      if (bitField0_ != 0) {
        buildPartial0(result);
      }
      buildPartialOneofs(result);
      onBuilt();
      return result;
    }

    private void buildPartial0(com.google.cloud.aiplatform.v1beta1.SearchDataItemsRequest result) {
      int from_bitField0_ = bitField0_;
      if (((from_bitField0_ & 0x00000004) != 0)) {
        result.dataset_ = dataset_;
      }
      if (((from_bitField0_ & 0x00000008) != 0)) {
        result.savedQuery_ = savedQuery_;
      }
      if (((from_bitField0_ & 0x00000010) != 0)) {
        result.dataLabelingJob_ = dataLabelingJob_;
      }
      if (((from_bitField0_ & 0x00000020) != 0)) {
        result.dataItemFilter_ = dataItemFilter_;
      }
      if (((from_bitField0_ & 0x00000040) != 0)) {
        result.annotationsFilter_ = annotationsFilter_;
      }
      if (((from_bitField0_ & 0x00000080) != 0)) {
        annotationFilters_.makeImmutable();
        result.annotationFilters_ = annotationFilters_;
      }
      if (((from_bitField0_ & 0x00000100) != 0)) {
        result.fieldMask_ = fieldMaskBuilder_ == null ? fieldMask_ : fieldMaskBuilder_.build();
      }
      if (((from_bitField0_ & 0x00000200) != 0)) {
        result.annotationsLimit_ = annotationsLimit_;
      }
      if (((from_bitField0_ & 0x00000400) != 0)) {
        result.pageSize_ = pageSize_;
      }
      if (((from_bitField0_ & 0x00000800) != 0)) {
        result.orderBy_ = orderBy_;
      }
      if (((from_bitField0_ & 0x00001000) != 0)) {
        result.pageToken_ = pageToken_;
      }
    }

    private void buildPartialOneofs(
        com.google.cloud.aiplatform.v1beta1.SearchDataItemsRequest result) {
      result.orderCase_ = orderCase_;
      result.order_ = this.order_;
      if (orderCase_ == 13 && orderByAnnotationBuilder_ != null) {
        result.order_ = orderByAnnotationBuilder_.build();
      }
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.cloud.aiplatform.v1beta1.SearchDataItemsRequest) {
        return mergeFrom((com.google.cloud.aiplatform.v1beta1.SearchDataItemsRequest) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(com.google.cloud.aiplatform.v1beta1.SearchDataItemsRequest other) {
      if (other == com.google.cloud.aiplatform.v1beta1.SearchDataItemsRequest.getDefaultInstance())
        return this;
      if (!other.getDataset().isEmpty()) {
        dataset_ = other.dataset_;
        bitField0_ |= 0x00000004;
        onChanged();
      }
      if (!other.getSavedQuery().isEmpty()) {
        savedQuery_ = other.savedQuery_;
        bitField0_ |= 0x00000008;
        onChanged();
      }
      if (!other.getDataLabelingJob().isEmpty()) {
        dataLabelingJob_ = other.dataLabelingJob_;
        bitField0_ |= 0x00000010;
        onChanged();
      }
      if (!other.getDataItemFilter().isEmpty()) {
        dataItemFilter_ = other.dataItemFilter_;
        bitField0_ |= 0x00000020;
        onChanged();
      }
      if (!other.getAnnotationsFilter().isEmpty()) {
        annotationsFilter_ = other.annotationsFilter_;
        bitField0_ |= 0x00000040;
        onChanged();
      }
      if (!other.annotationFilters_.isEmpty()) {
        if (annotationFilters_.isEmpty()) {
          annotationFilters_ = other.annotationFilters_;
          bitField0_ |= 0x00000080;
        } else {
          ensureAnnotationFiltersIsMutable();
          annotationFilters_.addAll(other.annotationFilters_);
        }
        onChanged();
      }
      if (other.hasFieldMask()) {
        mergeFieldMask(other.getFieldMask());
      }
      if (other.getAnnotationsLimit() != 0) {
        setAnnotationsLimit(other.getAnnotationsLimit());
      }
      if (other.getPageSize() != 0) {
        setPageSize(other.getPageSize());
      }
      if (!other.getOrderBy().isEmpty()) {
        orderBy_ = other.orderBy_;
        bitField0_ |= 0x00000800;
        onChanged();
      }
      if (!other.getPageToken().isEmpty()) {
        pageToken_ = other.pageToken_;
        bitField0_ |= 0x00001000;
        onChanged();
      }
      switch (other.getOrderCase()) {
        case ORDER_BY_DATA_ITEM:
          {
            orderCase_ = 12;
            order_ = other.order_;
            onChanged();
            break;
          }
        case ORDER_BY_ANNOTATION:
          {
            mergeOrderByAnnotation(other.getOrderByAnnotation());
            break;
          }
        case ORDER_NOT_SET:
          {
            break;
          }
      }
      this.mergeUnknownFields(other.getUnknownFields());
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 10:
              {
                dataset_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000004;
                break;
              } // case 10
            case 18:
              {
                savedQuery_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000008;
                break;
              } // case 18
            case 26:
              {
                dataLabelingJob_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000010;
                break;
              } // case 26
            case 34:
              {
                dataItemFilter_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000020;
                break;
              } // case 34
            case 42:
              {
                annotationsFilter_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000040;
                break;
              } // case 42
            case 50:
              {
                input.readMessage(getFieldMaskFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000100;
                break;
              } // case 50
            case 56:
              {
                annotationsLimit_ = input.readInt32();
                bitField0_ |= 0x00000200;
                break;
              } // case 56
            case 64:
              {
                pageSize_ = input.readInt32();
                bitField0_ |= 0x00000400;
                break;
              } // case 64
            case 74:
              {
                orderBy_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000800;
                break;
              } // case 74
            case 82:
              {
                pageToken_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00001000;
                break;
              } // case 82
            case 90:
              {
                java.lang.String s = input.readStringRequireUtf8();
                ensureAnnotationFiltersIsMutable();
                annotationFilters_.add(s);
                break;
              } // case 90
            case 98:
              {
                java.lang.String s = input.readStringRequireUtf8();
                orderCase_ = 12;
                order_ = s;
                break;
              } // case 98
            case 106:
              {
                input.readMessage(
                    getOrderByAnnotationFieldBuilder().getBuilder(), extensionRegistry);
                orderCase_ = 13;
                break;
              } // case 106
            default:
              {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
          } // switch (tag)
        } // while (!done)
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.unwrapIOException();
      } finally {
        onChanged();
      } // finally
      return this;
    }

    private int orderCase_ = 0;
    private java.lang.Object order_;

    public OrderCase getOrderCase() {
      return OrderCase.forNumber(orderCase_);
    }

    public Builder clearOrder() {
      orderCase_ = 0;
      order_ = null;
      onChanged();
      return this;
    }

    private int bitField0_;

    /**
     *
     *
     * <pre>
     * A comma-separated list of data item fields to order by, sorted in
     * ascending order. Use "desc" after a field name for descending.
     * </pre>
     *
     * <code>string order_by_data_item = 12;</code>
     *
     * @return Whether the orderByDataItem field is set.
     */
    @java.lang.Override
    public boolean hasOrderByDataItem() {
      return orderCase_ == 12;
    }
    /**
     *
     *
     * <pre>
     * A comma-separated list of data item fields to order by, sorted in
     * ascending order. Use "desc" after a field name for descending.
     * </pre>
     *
     * <code>string order_by_data_item = 12;</code>
     *
     * @return The orderByDataItem.
     */
    @java.lang.Override
    public java.lang.String getOrderByDataItem() {
      java.lang.Object ref = "";
      if (orderCase_ == 12) {
        ref = order_;
      }
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        if (orderCase_ == 12) {
          order_ = s;
        }
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * A comma-separated list of data item fields to order by, sorted in
     * ascending order. Use "desc" after a field name for descending.
     * </pre>
     *
     * <code>string order_by_data_item = 12;</code>
     *
     * @return The bytes for orderByDataItem.
     */
    @java.lang.Override
    public com.google.protobuf.ByteString getOrderByDataItemBytes() {
      java.lang.Object ref = "";
      if (orderCase_ == 12) {
        ref = order_;
      }
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        if (orderCase_ == 12) {
          order_ = b;
        }
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * A comma-separated list of data item fields to order by, sorted in
     * ascending order. Use "desc" after a field name for descending.
     * </pre>
     *
     * <code>string order_by_data_item = 12;</code>
     *
     * @param value The orderByDataItem to set.
     * @return This builder for chaining.
     */
    public Builder setOrderByDataItem(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      orderCase_ = 12;
      order_ = value;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * A comma-separated list of data item fields to order by, sorted in
     * ascending order. Use "desc" after a field name for descending.
     * </pre>
     *
     * <code>string order_by_data_item = 12;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearOrderByDataItem() {
      if (orderCase_ == 12) {
        orderCase_ = 0;
        order_ = null;
        onChanged();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * A comma-separated list of data item fields to order by, sorted in
     * ascending order. Use "desc" after a field name for descending.
     * </pre>
     *
     * <code>string order_by_data_item = 12;</code>
     *
     * @param value The bytes for orderByDataItem to set.
     * @return This builder for chaining.
     */
    public Builder setOrderByDataItemBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      orderCase_ = 12;
      order_ = value;
      onChanged();
      return this;
    }

    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.aiplatform.v1beta1.SearchDataItemsRequest.OrderByAnnotation,
            com.google.cloud.aiplatform.v1beta1.SearchDataItemsRequest.OrderByAnnotation.Builder,
            com.google.cloud.aiplatform.v1beta1.SearchDataItemsRequest.OrderByAnnotationOrBuilder>
        orderByAnnotationBuilder_;
    /**
     *
     *
     * <pre>
     * Expression that allows ranking results based on annotation's property.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.SearchDataItemsRequest.OrderByAnnotation order_by_annotation = 13;
     * </code>
     *
     * @return Whether the orderByAnnotation field is set.
     */
    @java.lang.Override
    public boolean hasOrderByAnnotation() {
      return orderCase_ == 13;
    }
    /**
     *
     *
     * <pre>
     * Expression that allows ranking results based on annotation's property.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.SearchDataItemsRequest.OrderByAnnotation order_by_annotation = 13;
     * </code>
     *
     * @return The orderByAnnotation.
     */
    @java.lang.Override
    public com.google.cloud.aiplatform.v1beta1.SearchDataItemsRequest.OrderByAnnotation
        getOrderByAnnotation() {
      if (orderByAnnotationBuilder_ == null) {
        if (orderCase_ == 13) {
          return (com.google.cloud.aiplatform.v1beta1.SearchDataItemsRequest.OrderByAnnotation)
              order_;
        }
        return com.google.cloud.aiplatform.v1beta1.SearchDataItemsRequest.OrderByAnnotation
            .getDefaultInstance();
      } else {
        if (orderCase_ == 13) {
          return orderByAnnotationBuilder_.getMessage();
        }
        return com.google.cloud.aiplatform.v1beta1.SearchDataItemsRequest.OrderByAnnotation
            .getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * Expression that allows ranking results based on annotation's property.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.SearchDataItemsRequest.OrderByAnnotation order_by_annotation = 13;
     * </code>
     */
    public Builder setOrderByAnnotation(
        com.google.cloud.aiplatform.v1beta1.SearchDataItemsRequest.OrderByAnnotation value) {
      if (orderByAnnotationBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        order_ = value;
        onChanged();
      } else {
        orderByAnnotationBuilder_.setMessage(value);
      }
      orderCase_ = 13;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Expression that allows ranking results based on annotation's property.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.SearchDataItemsRequest.OrderByAnnotation order_by_annotation = 13;
     * </code>
     */
    public Builder setOrderByAnnotation(
        com.google.cloud.aiplatform.v1beta1.SearchDataItemsRequest.OrderByAnnotation.Builder
            builderForValue) {
      if (orderByAnnotationBuilder_ == null) {
        order_ = builderForValue.build();
        onChanged();
      } else {
        orderByAnnotationBuilder_.setMessage(builderForValue.build());
      }
      orderCase_ = 13;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Expression that allows ranking results based on annotation's property.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.SearchDataItemsRequest.OrderByAnnotation order_by_annotation = 13;
     * </code>
     */
    public Builder mergeOrderByAnnotation(
        com.google.cloud.aiplatform.v1beta1.SearchDataItemsRequest.OrderByAnnotation value) {
      if (orderByAnnotationBuilder_ == null) {
        if (orderCase_ == 13
            && order_
                != com.google.cloud.aiplatform.v1beta1.SearchDataItemsRequest.OrderByAnnotation
                    .getDefaultInstance()) {
          order_ =
              com.google.cloud.aiplatform.v1beta1.SearchDataItemsRequest.OrderByAnnotation
                  .newBuilder(
                      (com.google.cloud.aiplatform.v1beta1.SearchDataItemsRequest.OrderByAnnotation)
                          order_)
                  .mergeFrom(value)
                  .buildPartial();
        } else {
          order_ = value;
        }
        onChanged();
      } else {
        if (orderCase_ == 13) {
          orderByAnnotationBuilder_.mergeFrom(value);
        } else {
          orderByAnnotationBuilder_.setMessage(value);
        }
      }
      orderCase_ = 13;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Expression that allows ranking results based on annotation's property.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.SearchDataItemsRequest.OrderByAnnotation order_by_annotation = 13;
     * </code>
     */
    public Builder clearOrderByAnnotation() {
      if (orderByAnnotationBuilder_ == null) {
        if (orderCase_ == 13) {
          orderCase_ = 0;
          order_ = null;
          onChanged();
        }
      } else {
        if (orderCase_ == 13) {
          orderCase_ = 0;
          order_ = null;
        }
        orderByAnnotationBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Expression that allows ranking results based on annotation's property.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.SearchDataItemsRequest.OrderByAnnotation order_by_annotation = 13;
     * </code>
     */
    public com.google.cloud.aiplatform.v1beta1.SearchDataItemsRequest.OrderByAnnotation.Builder
        getOrderByAnnotationBuilder() {
      return getOrderByAnnotationFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Expression that allows ranking results based on annotation's property.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.SearchDataItemsRequest.OrderByAnnotation order_by_annotation = 13;
     * </code>
     */
    @java.lang.Override
    public com.google.cloud.aiplatform.v1beta1.SearchDataItemsRequest.OrderByAnnotationOrBuilder
        getOrderByAnnotationOrBuilder() {
      if ((orderCase_ == 13) && (orderByAnnotationBuilder_ != null)) {
        return orderByAnnotationBuilder_.getMessageOrBuilder();
      } else {
        if (orderCase_ == 13) {
          return (com.google.cloud.aiplatform.v1beta1.SearchDataItemsRequest.OrderByAnnotation)
              order_;
        }
        return com.google.cloud.aiplatform.v1beta1.SearchDataItemsRequest.OrderByAnnotation
            .getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * Expression that allows ranking results based on annotation's property.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.SearchDataItemsRequest.OrderByAnnotation order_by_annotation = 13;
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.aiplatform.v1beta1.SearchDataItemsRequest.OrderByAnnotation,
            com.google.cloud.aiplatform.v1beta1.SearchDataItemsRequest.OrderByAnnotation.Builder,
            com.google.cloud.aiplatform.v1beta1.SearchDataItemsRequest.OrderByAnnotationOrBuilder>
        getOrderByAnnotationFieldBuilder() {
      if (orderByAnnotationBuilder_ == null) {
        if (!(orderCase_ == 13)) {
          order_ =
              com.google.cloud.aiplatform.v1beta1.SearchDataItemsRequest.OrderByAnnotation
                  .getDefaultInstance();
        }
        orderByAnnotationBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.aiplatform.v1beta1.SearchDataItemsRequest.OrderByAnnotation,
                com.google.cloud.aiplatform.v1beta1.SearchDataItemsRequest.OrderByAnnotation
                    .Builder,
                com.google.cloud.aiplatform.v1beta1.SearchDataItemsRequest
                    .OrderByAnnotationOrBuilder>(
                (com.google.cloud.aiplatform.v1beta1.SearchDataItemsRequest.OrderByAnnotation)
                    order_,
                getParentForChildren(),
                isClean());
        order_ = null;
      }
      orderCase_ = 13;
      onChanged();
      return orderByAnnotationBuilder_;
    }

    private java.lang.Object dataset_ = "";
    /**
     *
     *
     * <pre>
     * Required. The resource name of the Dataset from which to search DataItems.
     * Format:
     * `projects/{project}/locations/{location}/datasets/{dataset}`
     * </pre>
     *
     * <code>
     * string dataset = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @return The dataset.
     */
    public java.lang.String getDataset() {
      java.lang.Object ref = dataset_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        dataset_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Required. The resource name of the Dataset from which to search DataItems.
     * Format:
     * `projects/{project}/locations/{location}/datasets/{dataset}`
     * </pre>
     *
     * <code>
     * string dataset = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @return The bytes for dataset.
     */
    public com.google.protobuf.ByteString getDatasetBytes() {
      java.lang.Object ref = dataset_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        dataset_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Required. The resource name of the Dataset from which to search DataItems.
     * Format:
     * `projects/{project}/locations/{location}/datasets/{dataset}`
     * </pre>
     *
     * <code>
     * string dataset = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @param value The dataset to set.
     * @return This builder for chaining.
     */
    public Builder setDataset(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      dataset_ = value;
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. The resource name of the Dataset from which to search DataItems.
     * Format:
     * `projects/{project}/locations/{location}/datasets/{dataset}`
     * </pre>
     *
     * <code>
     * string dataset = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @return This builder for chaining.
     */
    public Builder clearDataset() {
      dataset_ = getDefaultInstance().getDataset();
      bitField0_ = (bitField0_ & ~0x00000004);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. The resource name of the Dataset from which to search DataItems.
     * Format:
     * `projects/{project}/locations/{location}/datasets/{dataset}`
     * </pre>
     *
     * <code>
     * string dataset = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @param value The bytes for dataset to set.
     * @return This builder for chaining.
     */
    public Builder setDatasetBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      dataset_ = value;
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }

    private java.lang.Object savedQuery_ = "";
    /**
     *
     *
     * <pre>
     * The resource name of a SavedQuery(annotation set in UI).
     * Format:
     * `projects/{project}/locations/{location}/datasets/{dataset}/savedQueries/{saved_query}`
     * All of the search will be done in the context of this SavedQuery.
     * </pre>
     *
     * <code>string saved_query = 2 [deprecated = true, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @deprecated google.cloud.aiplatform.v1beta1.SearchDataItemsRequest.saved_query is deprecated.
     *     See google/cloud/aiplatform/v1beta1/dataset_service.proto;l=629
     * @return The savedQuery.
     */
    @java.lang.Deprecated
    public java.lang.String getSavedQuery() {
      java.lang.Object ref = savedQuery_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        savedQuery_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * The resource name of a SavedQuery(annotation set in UI).
     * Format:
     * `projects/{project}/locations/{location}/datasets/{dataset}/savedQueries/{saved_query}`
     * All of the search will be done in the context of this SavedQuery.
     * </pre>
     *
     * <code>string saved_query = 2 [deprecated = true, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @deprecated google.cloud.aiplatform.v1beta1.SearchDataItemsRequest.saved_query is deprecated.
     *     See google/cloud/aiplatform/v1beta1/dataset_service.proto;l=629
     * @return The bytes for savedQuery.
     */
    @java.lang.Deprecated
    public com.google.protobuf.ByteString getSavedQueryBytes() {
      java.lang.Object ref = savedQuery_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        savedQuery_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * The resource name of a SavedQuery(annotation set in UI).
     * Format:
     * `projects/{project}/locations/{location}/datasets/{dataset}/savedQueries/{saved_query}`
     * All of the search will be done in the context of this SavedQuery.
     * </pre>
     *
     * <code>string saved_query = 2 [deprecated = true, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @deprecated google.cloud.aiplatform.v1beta1.SearchDataItemsRequest.saved_query is deprecated.
     *     See google/cloud/aiplatform/v1beta1/dataset_service.proto;l=629
     * @param value The savedQuery to set.
     * @return This builder for chaining.
     */
    @java.lang.Deprecated
    public Builder setSavedQuery(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      savedQuery_ = value;
      bitField0_ |= 0x00000008;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The resource name of a SavedQuery(annotation set in UI).
     * Format:
     * `projects/{project}/locations/{location}/datasets/{dataset}/savedQueries/{saved_query}`
     * All of the search will be done in the context of this SavedQuery.
     * </pre>
     *
     * <code>string saved_query = 2 [deprecated = true, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @deprecated google.cloud.aiplatform.v1beta1.SearchDataItemsRequest.saved_query is deprecated.
     *     See google/cloud/aiplatform/v1beta1/dataset_service.proto;l=629
     * @return This builder for chaining.
     */
    @java.lang.Deprecated
    public Builder clearSavedQuery() {
      savedQuery_ = getDefaultInstance().getSavedQuery();
      bitField0_ = (bitField0_ & ~0x00000008);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The resource name of a SavedQuery(annotation set in UI).
     * Format:
     * `projects/{project}/locations/{location}/datasets/{dataset}/savedQueries/{saved_query}`
     * All of the search will be done in the context of this SavedQuery.
     * </pre>
     *
     * <code>string saved_query = 2 [deprecated = true, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @deprecated google.cloud.aiplatform.v1beta1.SearchDataItemsRequest.saved_query is deprecated.
     *     See google/cloud/aiplatform/v1beta1/dataset_service.proto;l=629
     * @param value The bytes for savedQuery to set.
     * @return This builder for chaining.
     */
    @java.lang.Deprecated
    public Builder setSavedQueryBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      savedQuery_ = value;
      bitField0_ |= 0x00000008;
      onChanged();
      return this;
    }

    private java.lang.Object dataLabelingJob_ = "";
    /**
     *
     *
     * <pre>
     * The resource name of a DataLabelingJob.
     * Format:
     * `projects/{project}/locations/{location}/dataLabelingJobs/{data_labeling_job}`
     * If this field is set, all of the search will be done in the context of
     * this DataLabelingJob.
     * </pre>
     *
     * <code>string data_labeling_job = 3;</code>
     *
     * @return The dataLabelingJob.
     */
    public java.lang.String getDataLabelingJob() {
      java.lang.Object ref = dataLabelingJob_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        dataLabelingJob_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * The resource name of a DataLabelingJob.
     * Format:
     * `projects/{project}/locations/{location}/dataLabelingJobs/{data_labeling_job}`
     * If this field is set, all of the search will be done in the context of
     * this DataLabelingJob.
     * </pre>
     *
     * <code>string data_labeling_job = 3;</code>
     *
     * @return The bytes for dataLabelingJob.
     */
    public com.google.protobuf.ByteString getDataLabelingJobBytes() {
      java.lang.Object ref = dataLabelingJob_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        dataLabelingJob_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * The resource name of a DataLabelingJob.
     * Format:
     * `projects/{project}/locations/{location}/dataLabelingJobs/{data_labeling_job}`
     * If this field is set, all of the search will be done in the context of
     * this DataLabelingJob.
     * </pre>
     *
     * <code>string data_labeling_job = 3;</code>
     *
     * @param value The dataLabelingJob to set.
     * @return This builder for chaining.
     */
    public Builder setDataLabelingJob(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      dataLabelingJob_ = value;
      bitField0_ |= 0x00000010;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The resource name of a DataLabelingJob.
     * Format:
     * `projects/{project}/locations/{location}/dataLabelingJobs/{data_labeling_job}`
     * If this field is set, all of the search will be done in the context of
     * this DataLabelingJob.
     * </pre>
     *
     * <code>string data_labeling_job = 3;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearDataLabelingJob() {
      dataLabelingJob_ = getDefaultInstance().getDataLabelingJob();
      bitField0_ = (bitField0_ & ~0x00000010);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The resource name of a DataLabelingJob.
     * Format:
     * `projects/{project}/locations/{location}/dataLabelingJobs/{data_labeling_job}`
     * If this field is set, all of the search will be done in the context of
     * this DataLabelingJob.
     * </pre>
     *
     * <code>string data_labeling_job = 3;</code>
     *
     * @param value The bytes for dataLabelingJob to set.
     * @return This builder for chaining.
     */
    public Builder setDataLabelingJobBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      dataLabelingJob_ = value;
      bitField0_ |= 0x00000010;
      onChanged();
      return this;
    }

    private java.lang.Object dataItemFilter_ = "";
    /**
     *
     *
     * <pre>
     * An expression for filtering the DataItem that will be returned.
     *
     *   * `data_item_id` - for = or !=.
     *   * `labeled` - for = or !=.
     *   * `has_annotation(ANNOTATION_SPEC_ID)` - true only for DataItem that
     *     have at least one annotation with annotation_spec_id =
     *     `ANNOTATION_SPEC_ID` in the context of SavedQuery or DataLabelingJob.
     *
     * For example:
     *
     * * `data_item=1`
     * * `has_annotation(5)`
     * </pre>
     *
     * <code>string data_item_filter = 4;</code>
     *
     * @return The dataItemFilter.
     */
    public java.lang.String getDataItemFilter() {
      java.lang.Object ref = dataItemFilter_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        dataItemFilter_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * An expression for filtering the DataItem that will be returned.
     *
     *   * `data_item_id` - for = or !=.
     *   * `labeled` - for = or !=.
     *   * `has_annotation(ANNOTATION_SPEC_ID)` - true only for DataItem that
     *     have at least one annotation with annotation_spec_id =
     *     `ANNOTATION_SPEC_ID` in the context of SavedQuery or DataLabelingJob.
     *
     * For example:
     *
     * * `data_item=1`
     * * `has_annotation(5)`
     * </pre>
     *
     * <code>string data_item_filter = 4;</code>
     *
     * @return The bytes for dataItemFilter.
     */
    public com.google.protobuf.ByteString getDataItemFilterBytes() {
      java.lang.Object ref = dataItemFilter_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        dataItemFilter_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * An expression for filtering the DataItem that will be returned.
     *
     *   * `data_item_id` - for = or !=.
     *   * `labeled` - for = or !=.
     *   * `has_annotation(ANNOTATION_SPEC_ID)` - true only for DataItem that
     *     have at least one annotation with annotation_spec_id =
     *     `ANNOTATION_SPEC_ID` in the context of SavedQuery or DataLabelingJob.
     *
     * For example:
     *
     * * `data_item=1`
     * * `has_annotation(5)`
     * </pre>
     *
     * <code>string data_item_filter = 4;</code>
     *
     * @param value The dataItemFilter to set.
     * @return This builder for chaining.
     */
    public Builder setDataItemFilter(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      dataItemFilter_ = value;
      bitField0_ |= 0x00000020;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * An expression for filtering the DataItem that will be returned.
     *
     *   * `data_item_id` - for = or !=.
     *   * `labeled` - for = or !=.
     *   * `has_annotation(ANNOTATION_SPEC_ID)` - true only for DataItem that
     *     have at least one annotation with annotation_spec_id =
     *     `ANNOTATION_SPEC_ID` in the context of SavedQuery or DataLabelingJob.
     *
     * For example:
     *
     * * `data_item=1`
     * * `has_annotation(5)`
     * </pre>
     *
     * <code>string data_item_filter = 4;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearDataItemFilter() {
      dataItemFilter_ = getDefaultInstance().getDataItemFilter();
      bitField0_ = (bitField0_ & ~0x00000020);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * An expression for filtering the DataItem that will be returned.
     *
     *   * `data_item_id` - for = or !=.
     *   * `labeled` - for = or !=.
     *   * `has_annotation(ANNOTATION_SPEC_ID)` - true only for DataItem that
     *     have at least one annotation with annotation_spec_id =
     *     `ANNOTATION_SPEC_ID` in the context of SavedQuery or DataLabelingJob.
     *
     * For example:
     *
     * * `data_item=1`
     * * `has_annotation(5)`
     * </pre>
     *
     * <code>string data_item_filter = 4;</code>
     *
     * @param value The bytes for dataItemFilter to set.
     * @return This builder for chaining.
     */
    public Builder setDataItemFilterBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      dataItemFilter_ = value;
      bitField0_ |= 0x00000020;
      onChanged();
      return this;
    }

    private java.lang.Object annotationsFilter_ = "";
    /**
     *
     *
     * <pre>
     * An expression for filtering the Annotations that will be returned per
     * DataItem.
     *   * `annotation_spec_id` - for = or !=.
     * </pre>
     *
     * <code>string annotations_filter = 5 [deprecated = true];</code>
     *
     * @deprecated google.cloud.aiplatform.v1beta1.SearchDataItemsRequest.annotations_filter is
     *     deprecated. See google/cloud/aiplatform/v1beta1/dataset_service.proto;l=660
     * @return The annotationsFilter.
     */
    @java.lang.Deprecated
    public java.lang.String getAnnotationsFilter() {
      java.lang.Object ref = annotationsFilter_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        annotationsFilter_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * An expression for filtering the Annotations that will be returned per
     * DataItem.
     *   * `annotation_spec_id` - for = or !=.
     * </pre>
     *
     * <code>string annotations_filter = 5 [deprecated = true];</code>
     *
     * @deprecated google.cloud.aiplatform.v1beta1.SearchDataItemsRequest.annotations_filter is
     *     deprecated. See google/cloud/aiplatform/v1beta1/dataset_service.proto;l=660
     * @return The bytes for annotationsFilter.
     */
    @java.lang.Deprecated
    public com.google.protobuf.ByteString getAnnotationsFilterBytes() {
      java.lang.Object ref = annotationsFilter_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        annotationsFilter_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * An expression for filtering the Annotations that will be returned per
     * DataItem.
     *   * `annotation_spec_id` - for = or !=.
     * </pre>
     *
     * <code>string annotations_filter = 5 [deprecated = true];</code>
     *
     * @deprecated google.cloud.aiplatform.v1beta1.SearchDataItemsRequest.annotations_filter is
     *     deprecated. See google/cloud/aiplatform/v1beta1/dataset_service.proto;l=660
     * @param value The annotationsFilter to set.
     * @return This builder for chaining.
     */
    @java.lang.Deprecated
    public Builder setAnnotationsFilter(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      annotationsFilter_ = value;
      bitField0_ |= 0x00000040;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * An expression for filtering the Annotations that will be returned per
     * DataItem.
     *   * `annotation_spec_id` - for = or !=.
     * </pre>
     *
     * <code>string annotations_filter = 5 [deprecated = true];</code>
     *
     * @deprecated google.cloud.aiplatform.v1beta1.SearchDataItemsRequest.annotations_filter is
     *     deprecated. See google/cloud/aiplatform/v1beta1/dataset_service.proto;l=660
     * @return This builder for chaining.
     */
    @java.lang.Deprecated
    public Builder clearAnnotationsFilter() {
      annotationsFilter_ = getDefaultInstance().getAnnotationsFilter();
      bitField0_ = (bitField0_ & ~0x00000040);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * An expression for filtering the Annotations that will be returned per
     * DataItem.
     *   * `annotation_spec_id` - for = or !=.
     * </pre>
     *
     * <code>string annotations_filter = 5 [deprecated = true];</code>
     *
     * @deprecated google.cloud.aiplatform.v1beta1.SearchDataItemsRequest.annotations_filter is
     *     deprecated. See google/cloud/aiplatform/v1beta1/dataset_service.proto;l=660
     * @param value The bytes for annotationsFilter to set.
     * @return This builder for chaining.
     */
    @java.lang.Deprecated
    public Builder setAnnotationsFilterBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      annotationsFilter_ = value;
      bitField0_ |= 0x00000040;
      onChanged();
      return this;
    }

    private com.google.protobuf.LazyStringArrayList annotationFilters_ =
        com.google.protobuf.LazyStringArrayList.emptyList();

    private void ensureAnnotationFiltersIsMutable() {
      if (!annotationFilters_.isModifiable()) {
        annotationFilters_ = new com.google.protobuf.LazyStringArrayList(annotationFilters_);
      }
      bitField0_ |= 0x00000080;
    }
    /**
     *
     *
     * <pre>
     * An expression that specifies what Annotations will be returned per
     * DataItem. Annotations satisfied either of the conditions will be returned.
     *   * `annotation_spec_id` - for = or !=.
     * Must specify `saved_query_id=` - saved query id that annotations should
     * belong to.
     * </pre>
     *
     * <code>repeated string annotation_filters = 11;</code>
     *
     * @return A list containing the annotationFilters.
     */
    public com.google.protobuf.ProtocolStringList getAnnotationFiltersList() {
      annotationFilters_.makeImmutable();
      return annotationFilters_;
    }
    /**
     *
     *
     * <pre>
     * An expression that specifies what Annotations will be returned per
     * DataItem. Annotations satisfied either of the conditions will be returned.
     *   * `annotation_spec_id` - for = or !=.
     * Must specify `saved_query_id=` - saved query id that annotations should
     * belong to.
     * </pre>
     *
     * <code>repeated string annotation_filters = 11;</code>
     *
     * @return The count of annotationFilters.
     */
    public int getAnnotationFiltersCount() {
      return annotationFilters_.size();
    }
    /**
     *
     *
     * <pre>
     * An expression that specifies what Annotations will be returned per
     * DataItem. Annotations satisfied either of the conditions will be returned.
     *   * `annotation_spec_id` - for = or !=.
     * Must specify `saved_query_id=` - saved query id that annotations should
     * belong to.
     * </pre>
     *
     * <code>repeated string annotation_filters = 11;</code>
     *
     * @param index The index of the element to return.
     * @return The annotationFilters at the given index.
     */
    public java.lang.String getAnnotationFilters(int index) {
      return annotationFilters_.get(index);
    }
    /**
     *
     *
     * <pre>
     * An expression that specifies what Annotations will be returned per
     * DataItem. Annotations satisfied either of the conditions will be returned.
     *   * `annotation_spec_id` - for = or !=.
     * Must specify `saved_query_id=` - saved query id that annotations should
     * belong to.
     * </pre>
     *
     * <code>repeated string annotation_filters = 11;</code>
     *
     * @param index The index of the value to return.
     * @return The bytes of the annotationFilters at the given index.
     */
    public com.google.protobuf.ByteString getAnnotationFiltersBytes(int index) {
      return annotationFilters_.getByteString(index);
    }
    /**
     *
     *
     * <pre>
     * An expression that specifies what Annotations will be returned per
     * DataItem. Annotations satisfied either of the conditions will be returned.
     *   * `annotation_spec_id` - for = or !=.
     * Must specify `saved_query_id=` - saved query id that annotations should
     * belong to.
     * </pre>
     *
     * <code>repeated string annotation_filters = 11;</code>
     *
     * @param index The index to set the value at.
     * @param value The annotationFilters to set.
     * @return This builder for chaining.
     */
    public Builder setAnnotationFilters(int index, java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      ensureAnnotationFiltersIsMutable();
      annotationFilters_.set(index, value);
      bitField0_ |= 0x00000080;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * An expression that specifies what Annotations will be returned per
     * DataItem. Annotations satisfied either of the conditions will be returned.
     *   * `annotation_spec_id` - for = or !=.
     * Must specify `saved_query_id=` - saved query id that annotations should
     * belong to.
     * </pre>
     *
     * <code>repeated string annotation_filters = 11;</code>
     *
     * @param value The annotationFilters to add.
     * @return This builder for chaining.
     */
    public Builder addAnnotationFilters(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      ensureAnnotationFiltersIsMutable();
      annotationFilters_.add(value);
      bitField0_ |= 0x00000080;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * An expression that specifies what Annotations will be returned per
     * DataItem. Annotations satisfied either of the conditions will be returned.
     *   * `annotation_spec_id` - for = or !=.
     * Must specify `saved_query_id=` - saved query id that annotations should
     * belong to.
     * </pre>
     *
     * <code>repeated string annotation_filters = 11;</code>
     *
     * @param values The annotationFilters to add.
     * @return This builder for chaining.
     */
    public Builder addAllAnnotationFilters(java.lang.Iterable<java.lang.String> values) {
      ensureAnnotationFiltersIsMutable();
      com.google.protobuf.AbstractMessageLite.Builder.addAll(values, annotationFilters_);
      bitField0_ |= 0x00000080;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * An expression that specifies what Annotations will be returned per
     * DataItem. Annotations satisfied either of the conditions will be returned.
     *   * `annotation_spec_id` - for = or !=.
     * Must specify `saved_query_id=` - saved query id that annotations should
     * belong to.
     * </pre>
     *
     * <code>repeated string annotation_filters = 11;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearAnnotationFilters() {
      annotationFilters_ = com.google.protobuf.LazyStringArrayList.emptyList();
      bitField0_ = (bitField0_ & ~0x00000080);
      ;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * An expression that specifies what Annotations will be returned per
     * DataItem. Annotations satisfied either of the conditions will be returned.
     *   * `annotation_spec_id` - for = or !=.
     * Must specify `saved_query_id=` - saved query id that annotations should
     * belong to.
     * </pre>
     *
     * <code>repeated string annotation_filters = 11;</code>
     *
     * @param value The bytes of the annotationFilters to add.
     * @return This builder for chaining.
     */
    public Builder addAnnotationFiltersBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      ensureAnnotationFiltersIsMutable();
      annotationFilters_.add(value);
      bitField0_ |= 0x00000080;
      onChanged();
      return this;
    }

    private com.google.protobuf.FieldMask fieldMask_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.FieldMask,
            com.google.protobuf.FieldMask.Builder,
            com.google.protobuf.FieldMaskOrBuilder>
        fieldMaskBuilder_;
    /**
     *
     *
     * <pre>
     * Mask specifying which fields of
     * [DataItemView][google.cloud.aiplatform.v1beta1.DataItemView] to read.
     * </pre>
     *
     * <code>.google.protobuf.FieldMask field_mask = 6;</code>
     *
     * @return Whether the fieldMask field is set.
     */
    public boolean hasFieldMask() {
      return ((bitField0_ & 0x00000100) != 0);
    }
    /**
     *
     *
     * <pre>
     * Mask specifying which fields of
     * [DataItemView][google.cloud.aiplatform.v1beta1.DataItemView] to read.
     * </pre>
     *
     * <code>.google.protobuf.FieldMask field_mask = 6;</code>
     *
     * @return The fieldMask.
     */
    public com.google.protobuf.FieldMask getFieldMask() {
      if (fieldMaskBuilder_ == null) {
        return fieldMask_ == null ? com.google.protobuf.FieldMask.getDefaultInstance() : fieldMask_;
      } else {
        return fieldMaskBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Mask specifying which fields of
     * [DataItemView][google.cloud.aiplatform.v1beta1.DataItemView] to read.
     * </pre>
     *
     * <code>.google.protobuf.FieldMask field_mask = 6;</code>
     */
    public Builder setFieldMask(com.google.protobuf.FieldMask value) {
      if (fieldMaskBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        fieldMask_ = value;
      } else {
        fieldMaskBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000100;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Mask specifying which fields of
     * [DataItemView][google.cloud.aiplatform.v1beta1.DataItemView] to read.
     * </pre>
     *
     * <code>.google.protobuf.FieldMask field_mask = 6;</code>
     */
    public Builder setFieldMask(com.google.protobuf.FieldMask.Builder builderForValue) {
      if (fieldMaskBuilder_ == null) {
        fieldMask_ = builderForValue.build();
      } else {
        fieldMaskBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000100;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Mask specifying which fields of
     * [DataItemView][google.cloud.aiplatform.v1beta1.DataItemView] to read.
     * </pre>
     *
     * <code>.google.protobuf.FieldMask field_mask = 6;</code>
     */
    public Builder mergeFieldMask(com.google.protobuf.FieldMask value) {
      if (fieldMaskBuilder_ == null) {
        if (((bitField0_ & 0x00000100) != 0)
            && fieldMask_ != null
            && fieldMask_ != com.google.protobuf.FieldMask.getDefaultInstance()) {
          getFieldMaskBuilder().mergeFrom(value);
        } else {
          fieldMask_ = value;
        }
      } else {
        fieldMaskBuilder_.mergeFrom(value);
      }
      bitField0_ |= 0x00000100;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Mask specifying which fields of
     * [DataItemView][google.cloud.aiplatform.v1beta1.DataItemView] to read.
     * </pre>
     *
     * <code>.google.protobuf.FieldMask field_mask = 6;</code>
     */
    public Builder clearFieldMask() {
      bitField0_ = (bitField0_ & ~0x00000100);
      fieldMask_ = null;
      if (fieldMaskBuilder_ != null) {
        fieldMaskBuilder_.dispose();
        fieldMaskBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Mask specifying which fields of
     * [DataItemView][google.cloud.aiplatform.v1beta1.DataItemView] to read.
     * </pre>
     *
     * <code>.google.protobuf.FieldMask field_mask = 6;</code>
     */
    public com.google.protobuf.FieldMask.Builder getFieldMaskBuilder() {
      bitField0_ |= 0x00000100;
      onChanged();
      return getFieldMaskFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Mask specifying which fields of
     * [DataItemView][google.cloud.aiplatform.v1beta1.DataItemView] to read.
     * </pre>
     *
     * <code>.google.protobuf.FieldMask field_mask = 6;</code>
     */
    public com.google.protobuf.FieldMaskOrBuilder getFieldMaskOrBuilder() {
      if (fieldMaskBuilder_ != null) {
        return fieldMaskBuilder_.getMessageOrBuilder();
      } else {
        return fieldMask_ == null ? com.google.protobuf.FieldMask.getDefaultInstance() : fieldMask_;
      }
    }
    /**
     *
     *
     * <pre>
     * Mask specifying which fields of
     * [DataItemView][google.cloud.aiplatform.v1beta1.DataItemView] to read.
     * </pre>
     *
     * <code>.google.protobuf.FieldMask field_mask = 6;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.FieldMask,
            com.google.protobuf.FieldMask.Builder,
            com.google.protobuf.FieldMaskOrBuilder>
        getFieldMaskFieldBuilder() {
      if (fieldMaskBuilder_ == null) {
        fieldMaskBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.protobuf.FieldMask,
                com.google.protobuf.FieldMask.Builder,
                com.google.protobuf.FieldMaskOrBuilder>(
                getFieldMask(), getParentForChildren(), isClean());
        fieldMask_ = null;
      }
      return fieldMaskBuilder_;
    }

    private int annotationsLimit_;
    /**
     *
     *
     * <pre>
     * If set, only up to this many of Annotations will be returned per
     * DataItemView. The maximum value is 1000. If not set, the maximum value will
     * be used.
     * </pre>
     *
     * <code>int32 annotations_limit = 7;</code>
     *
     * @return The annotationsLimit.
     */
    @java.lang.Override
    public int getAnnotationsLimit() {
      return annotationsLimit_;
    }
    /**
     *
     *
     * <pre>
     * If set, only up to this many of Annotations will be returned per
     * DataItemView. The maximum value is 1000. If not set, the maximum value will
     * be used.
     * </pre>
     *
     * <code>int32 annotations_limit = 7;</code>
     *
     * @param value The annotationsLimit to set.
     * @return This builder for chaining.
     */
    public Builder setAnnotationsLimit(int value) {

      annotationsLimit_ = value;
      bitField0_ |= 0x00000200;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * If set, only up to this many of Annotations will be returned per
     * DataItemView. The maximum value is 1000. If not set, the maximum value will
     * be used.
     * </pre>
     *
     * <code>int32 annotations_limit = 7;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearAnnotationsLimit() {
      bitField0_ = (bitField0_ & ~0x00000200);
      annotationsLimit_ = 0;
      onChanged();
      return this;
    }

    private int pageSize_;
    /**
     *
     *
     * <pre>
     * Requested page size. Server may return fewer results than requested.
     * Default and maximum page size is 100.
     * </pre>
     *
     * <code>int32 page_size = 8;</code>
     *
     * @return The pageSize.
     */
    @java.lang.Override
    public int getPageSize() {
      return pageSize_;
    }
    /**
     *
     *
     * <pre>
     * Requested page size. Server may return fewer results than requested.
     * Default and maximum page size is 100.
     * </pre>
     *
     * <code>int32 page_size = 8;</code>
     *
     * @param value The pageSize to set.
     * @return This builder for chaining.
     */
    public Builder setPageSize(int value) {

      pageSize_ = value;
      bitField0_ |= 0x00000400;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Requested page size. Server may return fewer results than requested.
     * Default and maximum page size is 100.
     * </pre>
     *
     * <code>int32 page_size = 8;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearPageSize() {
      bitField0_ = (bitField0_ & ~0x00000400);
      pageSize_ = 0;
      onChanged();
      return this;
    }

    private java.lang.Object orderBy_ = "";
    /**
     *
     *
     * <pre>
     * A comma-separated list of fields to order by, sorted in ascending order.
     * Use "desc" after a field name for descending.
     * </pre>
     *
     * <code>string order_by = 9 [deprecated = true];</code>
     *
     * @deprecated google.cloud.aiplatform.v1beta1.SearchDataItemsRequest.order_by is deprecated.
     *     See google/cloud/aiplatform/v1beta1/dataset_service.proto;l=684
     * @return The orderBy.
     */
    @java.lang.Deprecated
    public java.lang.String getOrderBy() {
      java.lang.Object ref = orderBy_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        orderBy_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * A comma-separated list of fields to order by, sorted in ascending order.
     * Use "desc" after a field name for descending.
     * </pre>
     *
     * <code>string order_by = 9 [deprecated = true];</code>
     *
     * @deprecated google.cloud.aiplatform.v1beta1.SearchDataItemsRequest.order_by is deprecated.
     *     See google/cloud/aiplatform/v1beta1/dataset_service.proto;l=684
     * @return The bytes for orderBy.
     */
    @java.lang.Deprecated
    public com.google.protobuf.ByteString getOrderByBytes() {
      java.lang.Object ref = orderBy_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        orderBy_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * A comma-separated list of fields to order by, sorted in ascending order.
     * Use "desc" after a field name for descending.
     * </pre>
     *
     * <code>string order_by = 9 [deprecated = true];</code>
     *
     * @deprecated google.cloud.aiplatform.v1beta1.SearchDataItemsRequest.order_by is deprecated.
     *     See google/cloud/aiplatform/v1beta1/dataset_service.proto;l=684
     * @param value The orderBy to set.
     * @return This builder for chaining.
     */
    @java.lang.Deprecated
    public Builder setOrderBy(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      orderBy_ = value;
      bitField0_ |= 0x00000800;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * A comma-separated list of fields to order by, sorted in ascending order.
     * Use "desc" after a field name for descending.
     * </pre>
     *
     * <code>string order_by = 9 [deprecated = true];</code>
     *
     * @deprecated google.cloud.aiplatform.v1beta1.SearchDataItemsRequest.order_by is deprecated.
     *     See google/cloud/aiplatform/v1beta1/dataset_service.proto;l=684
     * @return This builder for chaining.
     */
    @java.lang.Deprecated
    public Builder clearOrderBy() {
      orderBy_ = getDefaultInstance().getOrderBy();
      bitField0_ = (bitField0_ & ~0x00000800);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * A comma-separated list of fields to order by, sorted in ascending order.
     * Use "desc" after a field name for descending.
     * </pre>
     *
     * <code>string order_by = 9 [deprecated = true];</code>
     *
     * @deprecated google.cloud.aiplatform.v1beta1.SearchDataItemsRequest.order_by is deprecated.
     *     See google/cloud/aiplatform/v1beta1/dataset_service.proto;l=684
     * @param value The bytes for orderBy to set.
     * @return This builder for chaining.
     */
    @java.lang.Deprecated
    public Builder setOrderByBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      orderBy_ = value;
      bitField0_ |= 0x00000800;
      onChanged();
      return this;
    }

    private java.lang.Object pageToken_ = "";
    /**
     *
     *
     * <pre>
     * A token identifying a page of results for the server to return
     * Typically obtained via
     * [SearchDataItemsResponse.next_page_token][google.cloud.aiplatform.v1beta1.SearchDataItemsResponse.next_page_token]
     * of the previous
     * [DatasetService.SearchDataItems][google.cloud.aiplatform.v1beta1.DatasetService.SearchDataItems]
     * call.
     * </pre>
     *
     * <code>string page_token = 10;</code>
     *
     * @return The pageToken.
     */
    public java.lang.String getPageToken() {
      java.lang.Object ref = pageToken_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        pageToken_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * A token identifying a page of results for the server to return
     * Typically obtained via
     * [SearchDataItemsResponse.next_page_token][google.cloud.aiplatform.v1beta1.SearchDataItemsResponse.next_page_token]
     * of the previous
     * [DatasetService.SearchDataItems][google.cloud.aiplatform.v1beta1.DatasetService.SearchDataItems]
     * call.
     * </pre>
     *
     * <code>string page_token = 10;</code>
     *
     * @return The bytes for pageToken.
     */
    public com.google.protobuf.ByteString getPageTokenBytes() {
      java.lang.Object ref = pageToken_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        pageToken_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * A token identifying a page of results for the server to return
     * Typically obtained via
     * [SearchDataItemsResponse.next_page_token][google.cloud.aiplatform.v1beta1.SearchDataItemsResponse.next_page_token]
     * of the previous
     * [DatasetService.SearchDataItems][google.cloud.aiplatform.v1beta1.DatasetService.SearchDataItems]
     * call.
     * </pre>
     *
     * <code>string page_token = 10;</code>
     *
     * @param value The pageToken to set.
     * @return This builder for chaining.
     */
    public Builder setPageToken(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      pageToken_ = value;
      bitField0_ |= 0x00001000;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * A token identifying a page of results for the server to return
     * Typically obtained via
     * [SearchDataItemsResponse.next_page_token][google.cloud.aiplatform.v1beta1.SearchDataItemsResponse.next_page_token]
     * of the previous
     * [DatasetService.SearchDataItems][google.cloud.aiplatform.v1beta1.DatasetService.SearchDataItems]
     * call.
     * </pre>
     *
     * <code>string page_token = 10;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearPageToken() {
      pageToken_ = getDefaultInstance().getPageToken();
      bitField0_ = (bitField0_ & ~0x00001000);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * A token identifying a page of results for the server to return
     * Typically obtained via
     * [SearchDataItemsResponse.next_page_token][google.cloud.aiplatform.v1beta1.SearchDataItemsResponse.next_page_token]
     * of the previous
     * [DatasetService.SearchDataItems][google.cloud.aiplatform.v1beta1.DatasetService.SearchDataItems]
     * call.
     * </pre>
     *
     * <code>string page_token = 10;</code>
     *
     * @param value The bytes for pageToken to set.
     * @return This builder for chaining.
     */
    public Builder setPageTokenBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      pageToken_ = value;
      bitField0_ |= 0x00001000;
      onChanged();
      return this;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.cloud.aiplatform.v1beta1.SearchDataItemsRequest)
  }

  // @@protoc_insertion_point(class_scope:google.cloud.aiplatform.v1beta1.SearchDataItemsRequest)
  private static final com.google.cloud.aiplatform.v1beta1.SearchDataItemsRequest DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.cloud.aiplatform.v1beta1.SearchDataItemsRequest();
  }

  public static com.google.cloud.aiplatform.v1beta1.SearchDataItemsRequest getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<SearchDataItemsRequest> PARSER =
      new com.google.protobuf.AbstractParser<SearchDataItemsRequest>() {
        @java.lang.Override
        public SearchDataItemsRequest parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          Builder builder = newBuilder();
          try {
            builder.mergeFrom(input, extensionRegistry);
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.setUnfinishedMessage(builder.buildPartial());
          } catch (com.google.protobuf.UninitializedMessageException e) {
            throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
          } catch (java.io.IOException e) {
            throw new com.google.protobuf.InvalidProtocolBufferException(e)
                .setUnfinishedMessage(builder.buildPartial());
          }
          return builder.buildPartial();
        }
      };

  public static com.google.protobuf.Parser<SearchDataItemsRequest> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<SearchDataItemsRequest> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.cloud.aiplatform.v1beta1.SearchDataItemsRequest getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
