/*
 * Copyright 2024 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/cloud/aiplatform/v1beta1/feature_view.proto

// Protobuf Java Version: 3.25.2
package com.google.cloud.aiplatform.v1beta1;

/**
 *
 *
 * <pre>
 * FeatureView is representation of values that the FeatureOnlineStore will
 * serve based on its syncConfig.
 * </pre>
 *
 * Protobuf type {@code google.cloud.aiplatform.v1beta1.FeatureView}
 */
public final class FeatureView extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.cloud.aiplatform.v1beta1.FeatureView)
    FeatureViewOrBuilder {
  private static final long serialVersionUID = 0L;
  // Use FeatureView.newBuilder() to construct.
  private FeatureView(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private FeatureView() {
    name_ = "";
    etag_ = "";
  }

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new FeatureView();
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.cloud.aiplatform.v1beta1.FeatureViewProto
        .internal_static_google_cloud_aiplatform_v1beta1_FeatureView_descriptor;
  }

  @SuppressWarnings({"rawtypes"})
  @java.lang.Override
  protected com.google.protobuf.MapFieldReflectionAccessor internalGetMapFieldReflection(
      int number) {
    switch (number) {
      case 5:
        return internalGetLabels();
      default:
        throw new RuntimeException("Invalid map field number: " + number);
    }
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.cloud.aiplatform.v1beta1.FeatureViewProto
        .internal_static_google_cloud_aiplatform_v1beta1_FeatureView_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.cloud.aiplatform.v1beta1.FeatureView.class,
            com.google.cloud.aiplatform.v1beta1.FeatureView.Builder.class);
  }

  public interface BigQuerySourceOrBuilder
      extends
      // @@protoc_insertion_point(interface_extends:google.cloud.aiplatform.v1beta1.FeatureView.BigQuerySource)
      com.google.protobuf.MessageOrBuilder {

    /**
     *
     *
     * <pre>
     * Required. The BigQuery view URI that will be materialized on each sync
     * trigger based on FeatureView.SyncConfig.
     * </pre>
     *
     * <code>string uri = 1 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return The uri.
     */
    java.lang.String getUri();
    /**
     *
     *
     * <pre>
     * Required. The BigQuery view URI that will be materialized on each sync
     * trigger based on FeatureView.SyncConfig.
     * </pre>
     *
     * <code>string uri = 1 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return The bytes for uri.
     */
    com.google.protobuf.ByteString getUriBytes();

    /**
     *
     *
     * <pre>
     * Required. Columns to construct entity_id / row keys. Start by supporting
     * 1 only.
     * </pre>
     *
     * <code>repeated string entity_id_columns = 2 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return A list containing the entityIdColumns.
     */
    java.util.List<java.lang.String> getEntityIdColumnsList();
    /**
     *
     *
     * <pre>
     * Required. Columns to construct entity_id / row keys. Start by supporting
     * 1 only.
     * </pre>
     *
     * <code>repeated string entity_id_columns = 2 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return The count of entityIdColumns.
     */
    int getEntityIdColumnsCount();
    /**
     *
     *
     * <pre>
     * Required. Columns to construct entity_id / row keys. Start by supporting
     * 1 only.
     * </pre>
     *
     * <code>repeated string entity_id_columns = 2 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @param index The index of the element to return.
     * @return The entityIdColumns at the given index.
     */
    java.lang.String getEntityIdColumns(int index);
    /**
     *
     *
     * <pre>
     * Required. Columns to construct entity_id / row keys. Start by supporting
     * 1 only.
     * </pre>
     *
     * <code>repeated string entity_id_columns = 2 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @param index The index of the value to return.
     * @return The bytes of the entityIdColumns at the given index.
     */
    com.google.protobuf.ByteString getEntityIdColumnsBytes(int index);
  }
  /** Protobuf type {@code google.cloud.aiplatform.v1beta1.FeatureView.BigQuerySource} */
  public static final class BigQuerySource extends com.google.protobuf.GeneratedMessageV3
      implements
      // @@protoc_insertion_point(message_implements:google.cloud.aiplatform.v1beta1.FeatureView.BigQuerySource)
      BigQuerySourceOrBuilder {
    private static final long serialVersionUID = 0L;
    // Use BigQuerySource.newBuilder() to construct.
    private BigQuerySource(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
      super(builder);
    }

    private BigQuerySource() {
      uri_ = "";
      entityIdColumns_ = com.google.protobuf.LazyStringArrayList.emptyList();
    }

    @java.lang.Override
    @SuppressWarnings({"unused"})
    protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
      return new BigQuerySource();
    }

    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.aiplatform.v1beta1.FeatureViewProto
          .internal_static_google_cloud_aiplatform_v1beta1_FeatureView_BigQuerySource_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.aiplatform.v1beta1.FeatureViewProto
          .internal_static_google_cloud_aiplatform_v1beta1_FeatureView_BigQuerySource_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.aiplatform.v1beta1.FeatureView.BigQuerySource.class,
              com.google.cloud.aiplatform.v1beta1.FeatureView.BigQuerySource.Builder.class);
    }

    public static final int URI_FIELD_NUMBER = 1;

    @SuppressWarnings("serial")
    private volatile java.lang.Object uri_ = "";
    /**
     *
     *
     * <pre>
     * Required. The BigQuery view URI that will be materialized on each sync
     * trigger based on FeatureView.SyncConfig.
     * </pre>
     *
     * <code>string uri = 1 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return The uri.
     */
    @java.lang.Override
    public java.lang.String getUri() {
      java.lang.Object ref = uri_;
      if (ref instanceof java.lang.String) {
        return (java.lang.String) ref;
      } else {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        uri_ = s;
        return s;
      }
    }
    /**
     *
     *
     * <pre>
     * Required. The BigQuery view URI that will be materialized on each sync
     * trigger based on FeatureView.SyncConfig.
     * </pre>
     *
     * <code>string uri = 1 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return The bytes for uri.
     */
    @java.lang.Override
    public com.google.protobuf.ByteString getUriBytes() {
      java.lang.Object ref = uri_;
      if (ref instanceof java.lang.String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        uri_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    public static final int ENTITY_ID_COLUMNS_FIELD_NUMBER = 2;

    @SuppressWarnings("serial")
    private com.google.protobuf.LazyStringArrayList entityIdColumns_ =
        com.google.protobuf.LazyStringArrayList.emptyList();
    /**
     *
     *
     * <pre>
     * Required. Columns to construct entity_id / row keys. Start by supporting
     * 1 only.
     * </pre>
     *
     * <code>repeated string entity_id_columns = 2 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return A list containing the entityIdColumns.
     */
    public com.google.protobuf.ProtocolStringList getEntityIdColumnsList() {
      return entityIdColumns_;
    }
    /**
     *
     *
     * <pre>
     * Required. Columns to construct entity_id / row keys. Start by supporting
     * 1 only.
     * </pre>
     *
     * <code>repeated string entity_id_columns = 2 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return The count of entityIdColumns.
     */
    public int getEntityIdColumnsCount() {
      return entityIdColumns_.size();
    }
    /**
     *
     *
     * <pre>
     * Required. Columns to construct entity_id / row keys. Start by supporting
     * 1 only.
     * </pre>
     *
     * <code>repeated string entity_id_columns = 2 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @param index The index of the element to return.
     * @return The entityIdColumns at the given index.
     */
    public java.lang.String getEntityIdColumns(int index) {
      return entityIdColumns_.get(index);
    }
    /**
     *
     *
     * <pre>
     * Required. Columns to construct entity_id / row keys. Start by supporting
     * 1 only.
     * </pre>
     *
     * <code>repeated string entity_id_columns = 2 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @param index The index of the value to return.
     * @return The bytes of the entityIdColumns at the given index.
     */
    public com.google.protobuf.ByteString getEntityIdColumnsBytes(int index) {
      return entityIdColumns_.getByteString(index);
    }

    private byte memoizedIsInitialized = -1;

    @java.lang.Override
    public final boolean isInitialized() {
      byte isInitialized = memoizedIsInitialized;
      if (isInitialized == 1) return true;
      if (isInitialized == 0) return false;

      memoizedIsInitialized = 1;
      return true;
    }

    @java.lang.Override
    public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(uri_)) {
        com.google.protobuf.GeneratedMessageV3.writeString(output, 1, uri_);
      }
      for (int i = 0; i < entityIdColumns_.size(); i++) {
        com.google.protobuf.GeneratedMessageV3.writeString(output, 2, entityIdColumns_.getRaw(i));
      }
      getUnknownFields().writeTo(output);
    }

    @java.lang.Override
    public int getSerializedSize() {
      int size = memoizedSize;
      if (size != -1) return size;

      size = 0;
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(uri_)) {
        size += com.google.protobuf.GeneratedMessageV3.computeStringSize(1, uri_);
      }
      {
        int dataSize = 0;
        for (int i = 0; i < entityIdColumns_.size(); i++) {
          dataSize += computeStringSizeNoTag(entityIdColumns_.getRaw(i));
        }
        size += dataSize;
        size += 1 * getEntityIdColumnsList().size();
      }
      size += getUnknownFields().getSerializedSize();
      memoizedSize = size;
      return size;
    }

    @java.lang.Override
    public boolean equals(final java.lang.Object obj) {
      if (obj == this) {
        return true;
      }
      if (!(obj instanceof com.google.cloud.aiplatform.v1beta1.FeatureView.BigQuerySource)) {
        return super.equals(obj);
      }
      com.google.cloud.aiplatform.v1beta1.FeatureView.BigQuerySource other =
          (com.google.cloud.aiplatform.v1beta1.FeatureView.BigQuerySource) obj;

      if (!getUri().equals(other.getUri())) return false;
      if (!getEntityIdColumnsList().equals(other.getEntityIdColumnsList())) return false;
      if (!getUnknownFields().equals(other.getUnknownFields())) return false;
      return true;
    }

    @java.lang.Override
    public int hashCode() {
      if (memoizedHashCode != 0) {
        return memoizedHashCode;
      }
      int hash = 41;
      hash = (19 * hash) + getDescriptor().hashCode();
      hash = (37 * hash) + URI_FIELD_NUMBER;
      hash = (53 * hash) + getUri().hashCode();
      if (getEntityIdColumnsCount() > 0) {
        hash = (37 * hash) + ENTITY_ID_COLUMNS_FIELD_NUMBER;
        hash = (53 * hash) + getEntityIdColumnsList().hashCode();
      }
      hash = (29 * hash) + getUnknownFields().hashCode();
      memoizedHashCode = hash;
      return hash;
    }

    public static com.google.cloud.aiplatform.v1beta1.FeatureView.BigQuerySource parseFrom(
        java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.aiplatform.v1beta1.FeatureView.BigQuerySource parseFrom(
        java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.aiplatform.v1beta1.FeatureView.BigQuerySource parseFrom(
        com.google.protobuf.ByteString data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.aiplatform.v1beta1.FeatureView.BigQuerySource parseFrom(
        com.google.protobuf.ByteString data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.aiplatform.v1beta1.FeatureView.BigQuerySource parseFrom(
        byte[] data) throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.aiplatform.v1beta1.FeatureView.BigQuerySource parseFrom(
        byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.aiplatform.v1beta1.FeatureView.BigQuerySource parseFrom(
        java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.cloud.aiplatform.v1beta1.FeatureView.BigQuerySource parseFrom(
        java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.cloud.aiplatform.v1beta1.FeatureView.BigQuerySource parseDelimitedFrom(
        java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
    }

    public static com.google.cloud.aiplatform.v1beta1.FeatureView.BigQuerySource parseDelimitedFrom(
        java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.cloud.aiplatform.v1beta1.FeatureView.BigQuerySource parseFrom(
        com.google.protobuf.CodedInputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.cloud.aiplatform.v1beta1.FeatureView.BigQuerySource parseFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    @java.lang.Override
    public Builder newBuilderForType() {
      return newBuilder();
    }

    public static Builder newBuilder() {
      return DEFAULT_INSTANCE.toBuilder();
    }

    public static Builder newBuilder(
        com.google.cloud.aiplatform.v1beta1.FeatureView.BigQuerySource prototype) {
      return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }

    @java.lang.Override
    public Builder toBuilder() {
      return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
    }

    @java.lang.Override
    protected Builder newBuilderForType(
        com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      Builder builder = new Builder(parent);
      return builder;
    }
    /** Protobuf type {@code google.cloud.aiplatform.v1beta1.FeatureView.BigQuerySource} */
    public static final class Builder
        extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
        implements
        // @@protoc_insertion_point(builder_implements:google.cloud.aiplatform.v1beta1.FeatureView.BigQuerySource)
        com.google.cloud.aiplatform.v1beta1.FeatureView.BigQuerySourceOrBuilder {
      public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
        return com.google.cloud.aiplatform.v1beta1.FeatureViewProto
            .internal_static_google_cloud_aiplatform_v1beta1_FeatureView_BigQuerySource_descriptor;
      }

      @java.lang.Override
      protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return com.google.cloud.aiplatform.v1beta1.FeatureViewProto
            .internal_static_google_cloud_aiplatform_v1beta1_FeatureView_BigQuerySource_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                com.google.cloud.aiplatform.v1beta1.FeatureView.BigQuerySource.class,
                com.google.cloud.aiplatform.v1beta1.FeatureView.BigQuerySource.Builder.class);
      }

      // Construct using com.google.cloud.aiplatform.v1beta1.FeatureView.BigQuerySource.newBuilder()
      private Builder() {}

      private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
        super(parent);
      }

      @java.lang.Override
      public Builder clear() {
        super.clear();
        bitField0_ = 0;
        uri_ = "";
        entityIdColumns_ = com.google.protobuf.LazyStringArrayList.emptyList();
        return this;
      }

      @java.lang.Override
      public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
        return com.google.cloud.aiplatform.v1beta1.FeatureViewProto
            .internal_static_google_cloud_aiplatform_v1beta1_FeatureView_BigQuerySource_descriptor;
      }

      @java.lang.Override
      public com.google.cloud.aiplatform.v1beta1.FeatureView.BigQuerySource
          getDefaultInstanceForType() {
        return com.google.cloud.aiplatform.v1beta1.FeatureView.BigQuerySource.getDefaultInstance();
      }

      @java.lang.Override
      public com.google.cloud.aiplatform.v1beta1.FeatureView.BigQuerySource build() {
        com.google.cloud.aiplatform.v1beta1.FeatureView.BigQuerySource result = buildPartial();
        if (!result.isInitialized()) {
          throw newUninitializedMessageException(result);
        }
        return result;
      }

      @java.lang.Override
      public com.google.cloud.aiplatform.v1beta1.FeatureView.BigQuerySource buildPartial() {
        com.google.cloud.aiplatform.v1beta1.FeatureView.BigQuerySource result =
            new com.google.cloud.aiplatform.v1beta1.FeatureView.BigQuerySource(this);
        if (bitField0_ != 0) {
          buildPartial0(result);
        }
        onBuilt();
        return result;
      }

      private void buildPartial0(
          com.google.cloud.aiplatform.v1beta1.FeatureView.BigQuerySource result) {
        int from_bitField0_ = bitField0_;
        if (((from_bitField0_ & 0x00000001) != 0)) {
          result.uri_ = uri_;
        }
        if (((from_bitField0_ & 0x00000002) != 0)) {
          entityIdColumns_.makeImmutable();
          result.entityIdColumns_ = entityIdColumns_;
        }
      }

      @java.lang.Override
      public Builder clone() {
        return super.clone();
      }

      @java.lang.Override
      public Builder setField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.setField(field, value);
      }

      @java.lang.Override
      public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
        return super.clearField(field);
      }

      @java.lang.Override
      public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
        return super.clearOneof(oneof);
      }

      @java.lang.Override
      public Builder setRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          int index,
          java.lang.Object value) {
        return super.setRepeatedField(field, index, value);
      }

      @java.lang.Override
      public Builder addRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.addRepeatedField(field, value);
      }

      @java.lang.Override
      public Builder mergeFrom(com.google.protobuf.Message other) {
        if (other instanceof com.google.cloud.aiplatform.v1beta1.FeatureView.BigQuerySource) {
          return mergeFrom((com.google.cloud.aiplatform.v1beta1.FeatureView.BigQuerySource) other);
        } else {
          super.mergeFrom(other);
          return this;
        }
      }

      public Builder mergeFrom(
          com.google.cloud.aiplatform.v1beta1.FeatureView.BigQuerySource other) {
        if (other
            == com.google.cloud.aiplatform.v1beta1.FeatureView.BigQuerySource.getDefaultInstance())
          return this;
        if (!other.getUri().isEmpty()) {
          uri_ = other.uri_;
          bitField0_ |= 0x00000001;
          onChanged();
        }
        if (!other.entityIdColumns_.isEmpty()) {
          if (entityIdColumns_.isEmpty()) {
            entityIdColumns_ = other.entityIdColumns_;
            bitField0_ |= 0x00000002;
          } else {
            ensureEntityIdColumnsIsMutable();
            entityIdColumns_.addAll(other.entityIdColumns_);
          }
          onChanged();
        }
        this.mergeUnknownFields(other.getUnknownFields());
        onChanged();
        return this;
      }

      @java.lang.Override
      public final boolean isInitialized() {
        return true;
      }

      @java.lang.Override
      public Builder mergeFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        if (extensionRegistry == null) {
          throw new java.lang.NullPointerException();
        }
        try {
          boolean done = false;
          while (!done) {
            int tag = input.readTag();
            switch (tag) {
              case 0:
                done = true;
                break;
              case 10:
                {
                  uri_ = input.readStringRequireUtf8();
                  bitField0_ |= 0x00000001;
                  break;
                } // case 10
              case 18:
                {
                  java.lang.String s = input.readStringRequireUtf8();
                  ensureEntityIdColumnsIsMutable();
                  entityIdColumns_.add(s);
                  break;
                } // case 18
              default:
                {
                  if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                    done = true; // was an endgroup tag
                  }
                  break;
                } // default:
            } // switch (tag)
          } // while (!done)
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          throw e.unwrapIOException();
        } finally {
          onChanged();
        } // finally
        return this;
      }

      private int bitField0_;

      private java.lang.Object uri_ = "";
      /**
       *
       *
       * <pre>
       * Required. The BigQuery view URI that will be materialized on each sync
       * trigger based on FeatureView.SyncConfig.
       * </pre>
       *
       * <code>string uri = 1 [(.google.api.field_behavior) = REQUIRED];</code>
       *
       * @return The uri.
       */
      public java.lang.String getUri() {
        java.lang.Object ref = uri_;
        if (!(ref instanceof java.lang.String)) {
          com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
          java.lang.String s = bs.toStringUtf8();
          uri_ = s;
          return s;
        } else {
          return (java.lang.String) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * Required. The BigQuery view URI that will be materialized on each sync
       * trigger based on FeatureView.SyncConfig.
       * </pre>
       *
       * <code>string uri = 1 [(.google.api.field_behavior) = REQUIRED];</code>
       *
       * @return The bytes for uri.
       */
      public com.google.protobuf.ByteString getUriBytes() {
        java.lang.Object ref = uri_;
        if (ref instanceof String) {
          com.google.protobuf.ByteString b =
              com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
          uri_ = b;
          return b;
        } else {
          return (com.google.protobuf.ByteString) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * Required. The BigQuery view URI that will be materialized on each sync
       * trigger based on FeatureView.SyncConfig.
       * </pre>
       *
       * <code>string uri = 1 [(.google.api.field_behavior) = REQUIRED];</code>
       *
       * @param value The uri to set.
       * @return This builder for chaining.
       */
      public Builder setUri(java.lang.String value) {
        if (value == null) {
          throw new NullPointerException();
        }
        uri_ = value;
        bitField0_ |= 0x00000001;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Required. The BigQuery view URI that will be materialized on each sync
       * trigger based on FeatureView.SyncConfig.
       * </pre>
       *
       * <code>string uri = 1 [(.google.api.field_behavior) = REQUIRED];</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearUri() {
        uri_ = getDefaultInstance().getUri();
        bitField0_ = (bitField0_ & ~0x00000001);
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Required. The BigQuery view URI that will be materialized on each sync
       * trigger based on FeatureView.SyncConfig.
       * </pre>
       *
       * <code>string uri = 1 [(.google.api.field_behavior) = REQUIRED];</code>
       *
       * @param value The bytes for uri to set.
       * @return This builder for chaining.
       */
      public Builder setUriBytes(com.google.protobuf.ByteString value) {
        if (value == null) {
          throw new NullPointerException();
        }
        checkByteStringIsUtf8(value);
        uri_ = value;
        bitField0_ |= 0x00000001;
        onChanged();
        return this;
      }

      private com.google.protobuf.LazyStringArrayList entityIdColumns_ =
          com.google.protobuf.LazyStringArrayList.emptyList();

      private void ensureEntityIdColumnsIsMutable() {
        if (!entityIdColumns_.isModifiable()) {
          entityIdColumns_ = new com.google.protobuf.LazyStringArrayList(entityIdColumns_);
        }
        bitField0_ |= 0x00000002;
      }
      /**
       *
       *
       * <pre>
       * Required. Columns to construct entity_id / row keys. Start by supporting
       * 1 only.
       * </pre>
       *
       * <code>repeated string entity_id_columns = 2 [(.google.api.field_behavior) = REQUIRED];
       * </code>
       *
       * @return A list containing the entityIdColumns.
       */
      public com.google.protobuf.ProtocolStringList getEntityIdColumnsList() {
        entityIdColumns_.makeImmutable();
        return entityIdColumns_;
      }
      /**
       *
       *
       * <pre>
       * Required. Columns to construct entity_id / row keys. Start by supporting
       * 1 only.
       * </pre>
       *
       * <code>repeated string entity_id_columns = 2 [(.google.api.field_behavior) = REQUIRED];
       * </code>
       *
       * @return The count of entityIdColumns.
       */
      public int getEntityIdColumnsCount() {
        return entityIdColumns_.size();
      }
      /**
       *
       *
       * <pre>
       * Required. Columns to construct entity_id / row keys. Start by supporting
       * 1 only.
       * </pre>
       *
       * <code>repeated string entity_id_columns = 2 [(.google.api.field_behavior) = REQUIRED];
       * </code>
       *
       * @param index The index of the element to return.
       * @return The entityIdColumns at the given index.
       */
      public java.lang.String getEntityIdColumns(int index) {
        return entityIdColumns_.get(index);
      }
      /**
       *
       *
       * <pre>
       * Required. Columns to construct entity_id / row keys. Start by supporting
       * 1 only.
       * </pre>
       *
       * <code>repeated string entity_id_columns = 2 [(.google.api.field_behavior) = REQUIRED];
       * </code>
       *
       * @param index The index of the value to return.
       * @return The bytes of the entityIdColumns at the given index.
       */
      public com.google.protobuf.ByteString getEntityIdColumnsBytes(int index) {
        return entityIdColumns_.getByteString(index);
      }
      /**
       *
       *
       * <pre>
       * Required. Columns to construct entity_id / row keys. Start by supporting
       * 1 only.
       * </pre>
       *
       * <code>repeated string entity_id_columns = 2 [(.google.api.field_behavior) = REQUIRED];
       * </code>
       *
       * @param index The index to set the value at.
       * @param value The entityIdColumns to set.
       * @return This builder for chaining.
       */
      public Builder setEntityIdColumns(int index, java.lang.String value) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureEntityIdColumnsIsMutable();
        entityIdColumns_.set(index, value);
        bitField0_ |= 0x00000002;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Required. Columns to construct entity_id / row keys. Start by supporting
       * 1 only.
       * </pre>
       *
       * <code>repeated string entity_id_columns = 2 [(.google.api.field_behavior) = REQUIRED];
       * </code>
       *
       * @param value The entityIdColumns to add.
       * @return This builder for chaining.
       */
      public Builder addEntityIdColumns(java.lang.String value) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureEntityIdColumnsIsMutable();
        entityIdColumns_.add(value);
        bitField0_ |= 0x00000002;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Required. Columns to construct entity_id / row keys. Start by supporting
       * 1 only.
       * </pre>
       *
       * <code>repeated string entity_id_columns = 2 [(.google.api.field_behavior) = REQUIRED];
       * </code>
       *
       * @param values The entityIdColumns to add.
       * @return This builder for chaining.
       */
      public Builder addAllEntityIdColumns(java.lang.Iterable<java.lang.String> values) {
        ensureEntityIdColumnsIsMutable();
        com.google.protobuf.AbstractMessageLite.Builder.addAll(values, entityIdColumns_);
        bitField0_ |= 0x00000002;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Required. Columns to construct entity_id / row keys. Start by supporting
       * 1 only.
       * </pre>
       *
       * <code>repeated string entity_id_columns = 2 [(.google.api.field_behavior) = REQUIRED];
       * </code>
       *
       * @return This builder for chaining.
       */
      public Builder clearEntityIdColumns() {
        entityIdColumns_ = com.google.protobuf.LazyStringArrayList.emptyList();
        bitField0_ = (bitField0_ & ~0x00000002);
        ;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Required. Columns to construct entity_id / row keys. Start by supporting
       * 1 only.
       * </pre>
       *
       * <code>repeated string entity_id_columns = 2 [(.google.api.field_behavior) = REQUIRED];
       * </code>
       *
       * @param value The bytes of the entityIdColumns to add.
       * @return This builder for chaining.
       */
      public Builder addEntityIdColumnsBytes(com.google.protobuf.ByteString value) {
        if (value == null) {
          throw new NullPointerException();
        }
        checkByteStringIsUtf8(value);
        ensureEntityIdColumnsIsMutable();
        entityIdColumns_.add(value);
        bitField0_ |= 0x00000002;
        onChanged();
        return this;
      }

      @java.lang.Override
      public final Builder setUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.setUnknownFields(unknownFields);
      }

      @java.lang.Override
      public final Builder mergeUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.mergeUnknownFields(unknownFields);
      }

      // @@protoc_insertion_point(builder_scope:google.cloud.aiplatform.v1beta1.FeatureView.BigQuerySource)
    }

    // @@protoc_insertion_point(class_scope:google.cloud.aiplatform.v1beta1.FeatureView.BigQuerySource)
    private static final com.google.cloud.aiplatform.v1beta1.FeatureView.BigQuerySource
        DEFAULT_INSTANCE;

    static {
      DEFAULT_INSTANCE = new com.google.cloud.aiplatform.v1beta1.FeatureView.BigQuerySource();
    }

    public static com.google.cloud.aiplatform.v1beta1.FeatureView.BigQuerySource
        getDefaultInstance() {
      return DEFAULT_INSTANCE;
    }

    private static final com.google.protobuf.Parser<BigQuerySource> PARSER =
        new com.google.protobuf.AbstractParser<BigQuerySource>() {
          @java.lang.Override
          public BigQuerySource parsePartialFrom(
              com.google.protobuf.CodedInputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
            Builder builder = newBuilder();
            try {
              builder.mergeFrom(input, extensionRegistry);
            } catch (com.google.protobuf.InvalidProtocolBufferException e) {
              throw e.setUnfinishedMessage(builder.buildPartial());
            } catch (com.google.protobuf.UninitializedMessageException e) {
              throw e.asInvalidProtocolBufferException()
                  .setUnfinishedMessage(builder.buildPartial());
            } catch (java.io.IOException e) {
              throw new com.google.protobuf.InvalidProtocolBufferException(e)
                  .setUnfinishedMessage(builder.buildPartial());
            }
            return builder.buildPartial();
          }
        };

    public static com.google.protobuf.Parser<BigQuerySource> parser() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.protobuf.Parser<BigQuerySource> getParserForType() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.cloud.aiplatform.v1beta1.FeatureView.BigQuerySource
        getDefaultInstanceForType() {
      return DEFAULT_INSTANCE;
    }
  }

  public interface SyncConfigOrBuilder
      extends
      // @@protoc_insertion_point(interface_extends:google.cloud.aiplatform.v1beta1.FeatureView.SyncConfig)
      com.google.protobuf.MessageOrBuilder {

    /**
     *
     *
     * <pre>
     * Cron schedule (https://en.wikipedia.org/wiki/Cron) to launch scheduled
     * runs. To explicitly set a timezone to the cron tab, apply a prefix in
     * the cron tab: "CRON_TZ=${IANA_TIME_ZONE}" or "TZ=${IANA_TIME_ZONE}".
     * The ${IANA_TIME_ZONE} may only be a valid string from IANA time zone
     * database. For example, "CRON_TZ=America/New_York 1 * * * *", or
     * "TZ=America/New_York 1 * * * *".
     * </pre>
     *
     * <code>string cron = 1;</code>
     *
     * @return The cron.
     */
    java.lang.String getCron();
    /**
     *
     *
     * <pre>
     * Cron schedule (https://en.wikipedia.org/wiki/Cron) to launch scheduled
     * runs. To explicitly set a timezone to the cron tab, apply a prefix in
     * the cron tab: "CRON_TZ=${IANA_TIME_ZONE}" or "TZ=${IANA_TIME_ZONE}".
     * The ${IANA_TIME_ZONE} may only be a valid string from IANA time zone
     * database. For example, "CRON_TZ=America/New_York 1 * * * *", or
     * "TZ=America/New_York 1 * * * *".
     * </pre>
     *
     * <code>string cron = 1;</code>
     *
     * @return The bytes for cron.
     */
    com.google.protobuf.ByteString getCronBytes();
  }
  /**
   *
   *
   * <pre>
   * Configuration for Sync. Only one option is set.
   * </pre>
   *
   * Protobuf type {@code google.cloud.aiplatform.v1beta1.FeatureView.SyncConfig}
   */
  public static final class SyncConfig extends com.google.protobuf.GeneratedMessageV3
      implements
      // @@protoc_insertion_point(message_implements:google.cloud.aiplatform.v1beta1.FeatureView.SyncConfig)
      SyncConfigOrBuilder {
    private static final long serialVersionUID = 0L;
    // Use SyncConfig.newBuilder() to construct.
    private SyncConfig(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
      super(builder);
    }

    private SyncConfig() {
      cron_ = "";
    }

    @java.lang.Override
    @SuppressWarnings({"unused"})
    protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
      return new SyncConfig();
    }

    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.aiplatform.v1beta1.FeatureViewProto
          .internal_static_google_cloud_aiplatform_v1beta1_FeatureView_SyncConfig_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.aiplatform.v1beta1.FeatureViewProto
          .internal_static_google_cloud_aiplatform_v1beta1_FeatureView_SyncConfig_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.aiplatform.v1beta1.FeatureView.SyncConfig.class,
              com.google.cloud.aiplatform.v1beta1.FeatureView.SyncConfig.Builder.class);
    }

    public static final int CRON_FIELD_NUMBER = 1;

    @SuppressWarnings("serial")
    private volatile java.lang.Object cron_ = "";
    /**
     *
     *
     * <pre>
     * Cron schedule (https://en.wikipedia.org/wiki/Cron) to launch scheduled
     * runs. To explicitly set a timezone to the cron tab, apply a prefix in
     * the cron tab: "CRON_TZ=${IANA_TIME_ZONE}" or "TZ=${IANA_TIME_ZONE}".
     * The ${IANA_TIME_ZONE} may only be a valid string from IANA time zone
     * database. For example, "CRON_TZ=America/New_York 1 * * * *", or
     * "TZ=America/New_York 1 * * * *".
     * </pre>
     *
     * <code>string cron = 1;</code>
     *
     * @return The cron.
     */
    @java.lang.Override
    public java.lang.String getCron() {
      java.lang.Object ref = cron_;
      if (ref instanceof java.lang.String) {
        return (java.lang.String) ref;
      } else {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        cron_ = s;
        return s;
      }
    }
    /**
     *
     *
     * <pre>
     * Cron schedule (https://en.wikipedia.org/wiki/Cron) to launch scheduled
     * runs. To explicitly set a timezone to the cron tab, apply a prefix in
     * the cron tab: "CRON_TZ=${IANA_TIME_ZONE}" or "TZ=${IANA_TIME_ZONE}".
     * The ${IANA_TIME_ZONE} may only be a valid string from IANA time zone
     * database. For example, "CRON_TZ=America/New_York 1 * * * *", or
     * "TZ=America/New_York 1 * * * *".
     * </pre>
     *
     * <code>string cron = 1;</code>
     *
     * @return The bytes for cron.
     */
    @java.lang.Override
    public com.google.protobuf.ByteString getCronBytes() {
      java.lang.Object ref = cron_;
      if (ref instanceof java.lang.String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        cron_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    private byte memoizedIsInitialized = -1;

    @java.lang.Override
    public final boolean isInitialized() {
      byte isInitialized = memoizedIsInitialized;
      if (isInitialized == 1) return true;
      if (isInitialized == 0) return false;

      memoizedIsInitialized = 1;
      return true;
    }

    @java.lang.Override
    public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(cron_)) {
        com.google.protobuf.GeneratedMessageV3.writeString(output, 1, cron_);
      }
      getUnknownFields().writeTo(output);
    }

    @java.lang.Override
    public int getSerializedSize() {
      int size = memoizedSize;
      if (size != -1) return size;

      size = 0;
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(cron_)) {
        size += com.google.protobuf.GeneratedMessageV3.computeStringSize(1, cron_);
      }
      size += getUnknownFields().getSerializedSize();
      memoizedSize = size;
      return size;
    }

    @java.lang.Override
    public boolean equals(final java.lang.Object obj) {
      if (obj == this) {
        return true;
      }
      if (!(obj instanceof com.google.cloud.aiplatform.v1beta1.FeatureView.SyncConfig)) {
        return super.equals(obj);
      }
      com.google.cloud.aiplatform.v1beta1.FeatureView.SyncConfig other =
          (com.google.cloud.aiplatform.v1beta1.FeatureView.SyncConfig) obj;

      if (!getCron().equals(other.getCron())) return false;
      if (!getUnknownFields().equals(other.getUnknownFields())) return false;
      return true;
    }

    @java.lang.Override
    public int hashCode() {
      if (memoizedHashCode != 0) {
        return memoizedHashCode;
      }
      int hash = 41;
      hash = (19 * hash) + getDescriptor().hashCode();
      hash = (37 * hash) + CRON_FIELD_NUMBER;
      hash = (53 * hash) + getCron().hashCode();
      hash = (29 * hash) + getUnknownFields().hashCode();
      memoizedHashCode = hash;
      return hash;
    }

    public static com.google.cloud.aiplatform.v1beta1.FeatureView.SyncConfig parseFrom(
        java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.aiplatform.v1beta1.FeatureView.SyncConfig parseFrom(
        java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.aiplatform.v1beta1.FeatureView.SyncConfig parseFrom(
        com.google.protobuf.ByteString data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.aiplatform.v1beta1.FeatureView.SyncConfig parseFrom(
        com.google.protobuf.ByteString data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.aiplatform.v1beta1.FeatureView.SyncConfig parseFrom(byte[] data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.aiplatform.v1beta1.FeatureView.SyncConfig parseFrom(
        byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.aiplatform.v1beta1.FeatureView.SyncConfig parseFrom(
        java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.cloud.aiplatform.v1beta1.FeatureView.SyncConfig parseFrom(
        java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.cloud.aiplatform.v1beta1.FeatureView.SyncConfig parseDelimitedFrom(
        java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
    }

    public static com.google.cloud.aiplatform.v1beta1.FeatureView.SyncConfig parseDelimitedFrom(
        java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.cloud.aiplatform.v1beta1.FeatureView.SyncConfig parseFrom(
        com.google.protobuf.CodedInputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.cloud.aiplatform.v1beta1.FeatureView.SyncConfig parseFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    @java.lang.Override
    public Builder newBuilderForType() {
      return newBuilder();
    }

    public static Builder newBuilder() {
      return DEFAULT_INSTANCE.toBuilder();
    }

    public static Builder newBuilder(
        com.google.cloud.aiplatform.v1beta1.FeatureView.SyncConfig prototype) {
      return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }

    @java.lang.Override
    public Builder toBuilder() {
      return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
    }

    @java.lang.Override
    protected Builder newBuilderForType(
        com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      Builder builder = new Builder(parent);
      return builder;
    }
    /**
     *
     *
     * <pre>
     * Configuration for Sync. Only one option is set.
     * </pre>
     *
     * Protobuf type {@code google.cloud.aiplatform.v1beta1.FeatureView.SyncConfig}
     */
    public static final class Builder
        extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
        implements
        // @@protoc_insertion_point(builder_implements:google.cloud.aiplatform.v1beta1.FeatureView.SyncConfig)
        com.google.cloud.aiplatform.v1beta1.FeatureView.SyncConfigOrBuilder {
      public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
        return com.google.cloud.aiplatform.v1beta1.FeatureViewProto
            .internal_static_google_cloud_aiplatform_v1beta1_FeatureView_SyncConfig_descriptor;
      }

      @java.lang.Override
      protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return com.google.cloud.aiplatform.v1beta1.FeatureViewProto
            .internal_static_google_cloud_aiplatform_v1beta1_FeatureView_SyncConfig_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                com.google.cloud.aiplatform.v1beta1.FeatureView.SyncConfig.class,
                com.google.cloud.aiplatform.v1beta1.FeatureView.SyncConfig.Builder.class);
      }

      // Construct using com.google.cloud.aiplatform.v1beta1.FeatureView.SyncConfig.newBuilder()
      private Builder() {}

      private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
        super(parent);
      }

      @java.lang.Override
      public Builder clear() {
        super.clear();
        bitField0_ = 0;
        cron_ = "";
        return this;
      }

      @java.lang.Override
      public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
        return com.google.cloud.aiplatform.v1beta1.FeatureViewProto
            .internal_static_google_cloud_aiplatform_v1beta1_FeatureView_SyncConfig_descriptor;
      }

      @java.lang.Override
      public com.google.cloud.aiplatform.v1beta1.FeatureView.SyncConfig
          getDefaultInstanceForType() {
        return com.google.cloud.aiplatform.v1beta1.FeatureView.SyncConfig.getDefaultInstance();
      }

      @java.lang.Override
      public com.google.cloud.aiplatform.v1beta1.FeatureView.SyncConfig build() {
        com.google.cloud.aiplatform.v1beta1.FeatureView.SyncConfig result = buildPartial();
        if (!result.isInitialized()) {
          throw newUninitializedMessageException(result);
        }
        return result;
      }

      @java.lang.Override
      public com.google.cloud.aiplatform.v1beta1.FeatureView.SyncConfig buildPartial() {
        com.google.cloud.aiplatform.v1beta1.FeatureView.SyncConfig result =
            new com.google.cloud.aiplatform.v1beta1.FeatureView.SyncConfig(this);
        if (bitField0_ != 0) {
          buildPartial0(result);
        }
        onBuilt();
        return result;
      }

      private void buildPartial0(
          com.google.cloud.aiplatform.v1beta1.FeatureView.SyncConfig result) {
        int from_bitField0_ = bitField0_;
        if (((from_bitField0_ & 0x00000001) != 0)) {
          result.cron_ = cron_;
        }
      }

      @java.lang.Override
      public Builder clone() {
        return super.clone();
      }

      @java.lang.Override
      public Builder setField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.setField(field, value);
      }

      @java.lang.Override
      public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
        return super.clearField(field);
      }

      @java.lang.Override
      public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
        return super.clearOneof(oneof);
      }

      @java.lang.Override
      public Builder setRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          int index,
          java.lang.Object value) {
        return super.setRepeatedField(field, index, value);
      }

      @java.lang.Override
      public Builder addRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.addRepeatedField(field, value);
      }

      @java.lang.Override
      public Builder mergeFrom(com.google.protobuf.Message other) {
        if (other instanceof com.google.cloud.aiplatform.v1beta1.FeatureView.SyncConfig) {
          return mergeFrom((com.google.cloud.aiplatform.v1beta1.FeatureView.SyncConfig) other);
        } else {
          super.mergeFrom(other);
          return this;
        }
      }

      public Builder mergeFrom(com.google.cloud.aiplatform.v1beta1.FeatureView.SyncConfig other) {
        if (other
            == com.google.cloud.aiplatform.v1beta1.FeatureView.SyncConfig.getDefaultInstance())
          return this;
        if (!other.getCron().isEmpty()) {
          cron_ = other.cron_;
          bitField0_ |= 0x00000001;
          onChanged();
        }
        this.mergeUnknownFields(other.getUnknownFields());
        onChanged();
        return this;
      }

      @java.lang.Override
      public final boolean isInitialized() {
        return true;
      }

      @java.lang.Override
      public Builder mergeFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        if (extensionRegistry == null) {
          throw new java.lang.NullPointerException();
        }
        try {
          boolean done = false;
          while (!done) {
            int tag = input.readTag();
            switch (tag) {
              case 0:
                done = true;
                break;
              case 10:
                {
                  cron_ = input.readStringRequireUtf8();
                  bitField0_ |= 0x00000001;
                  break;
                } // case 10
              default:
                {
                  if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                    done = true; // was an endgroup tag
                  }
                  break;
                } // default:
            } // switch (tag)
          } // while (!done)
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          throw e.unwrapIOException();
        } finally {
          onChanged();
        } // finally
        return this;
      }

      private int bitField0_;

      private java.lang.Object cron_ = "";
      /**
       *
       *
       * <pre>
       * Cron schedule (https://en.wikipedia.org/wiki/Cron) to launch scheduled
       * runs. To explicitly set a timezone to the cron tab, apply a prefix in
       * the cron tab: "CRON_TZ=${IANA_TIME_ZONE}" or "TZ=${IANA_TIME_ZONE}".
       * The ${IANA_TIME_ZONE} may only be a valid string from IANA time zone
       * database. For example, "CRON_TZ=America/New_York 1 * * * *", or
       * "TZ=America/New_York 1 * * * *".
       * </pre>
       *
       * <code>string cron = 1;</code>
       *
       * @return The cron.
       */
      public java.lang.String getCron() {
        java.lang.Object ref = cron_;
        if (!(ref instanceof java.lang.String)) {
          com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
          java.lang.String s = bs.toStringUtf8();
          cron_ = s;
          return s;
        } else {
          return (java.lang.String) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * Cron schedule (https://en.wikipedia.org/wiki/Cron) to launch scheduled
       * runs. To explicitly set a timezone to the cron tab, apply a prefix in
       * the cron tab: "CRON_TZ=${IANA_TIME_ZONE}" or "TZ=${IANA_TIME_ZONE}".
       * The ${IANA_TIME_ZONE} may only be a valid string from IANA time zone
       * database. For example, "CRON_TZ=America/New_York 1 * * * *", or
       * "TZ=America/New_York 1 * * * *".
       * </pre>
       *
       * <code>string cron = 1;</code>
       *
       * @return The bytes for cron.
       */
      public com.google.protobuf.ByteString getCronBytes() {
        java.lang.Object ref = cron_;
        if (ref instanceof String) {
          com.google.protobuf.ByteString b =
              com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
          cron_ = b;
          return b;
        } else {
          return (com.google.protobuf.ByteString) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * Cron schedule (https://en.wikipedia.org/wiki/Cron) to launch scheduled
       * runs. To explicitly set a timezone to the cron tab, apply a prefix in
       * the cron tab: "CRON_TZ=${IANA_TIME_ZONE}" or "TZ=${IANA_TIME_ZONE}".
       * The ${IANA_TIME_ZONE} may only be a valid string from IANA time zone
       * database. For example, "CRON_TZ=America/New_York 1 * * * *", or
       * "TZ=America/New_York 1 * * * *".
       * </pre>
       *
       * <code>string cron = 1;</code>
       *
       * @param value The cron to set.
       * @return This builder for chaining.
       */
      public Builder setCron(java.lang.String value) {
        if (value == null) {
          throw new NullPointerException();
        }
        cron_ = value;
        bitField0_ |= 0x00000001;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Cron schedule (https://en.wikipedia.org/wiki/Cron) to launch scheduled
       * runs. To explicitly set a timezone to the cron tab, apply a prefix in
       * the cron tab: "CRON_TZ=${IANA_TIME_ZONE}" or "TZ=${IANA_TIME_ZONE}".
       * The ${IANA_TIME_ZONE} may only be a valid string from IANA time zone
       * database. For example, "CRON_TZ=America/New_York 1 * * * *", or
       * "TZ=America/New_York 1 * * * *".
       * </pre>
       *
       * <code>string cron = 1;</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearCron() {
        cron_ = getDefaultInstance().getCron();
        bitField0_ = (bitField0_ & ~0x00000001);
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Cron schedule (https://en.wikipedia.org/wiki/Cron) to launch scheduled
       * runs. To explicitly set a timezone to the cron tab, apply a prefix in
       * the cron tab: "CRON_TZ=${IANA_TIME_ZONE}" or "TZ=${IANA_TIME_ZONE}".
       * The ${IANA_TIME_ZONE} may only be a valid string from IANA time zone
       * database. For example, "CRON_TZ=America/New_York 1 * * * *", or
       * "TZ=America/New_York 1 * * * *".
       * </pre>
       *
       * <code>string cron = 1;</code>
       *
       * @param value The bytes for cron to set.
       * @return This builder for chaining.
       */
      public Builder setCronBytes(com.google.protobuf.ByteString value) {
        if (value == null) {
          throw new NullPointerException();
        }
        checkByteStringIsUtf8(value);
        cron_ = value;
        bitField0_ |= 0x00000001;
        onChanged();
        return this;
      }

      @java.lang.Override
      public final Builder setUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.setUnknownFields(unknownFields);
      }

      @java.lang.Override
      public final Builder mergeUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.mergeUnknownFields(unknownFields);
      }

      // @@protoc_insertion_point(builder_scope:google.cloud.aiplatform.v1beta1.FeatureView.SyncConfig)
    }

    // @@protoc_insertion_point(class_scope:google.cloud.aiplatform.v1beta1.FeatureView.SyncConfig)
    private static final com.google.cloud.aiplatform.v1beta1.FeatureView.SyncConfig
        DEFAULT_INSTANCE;

    static {
      DEFAULT_INSTANCE = new com.google.cloud.aiplatform.v1beta1.FeatureView.SyncConfig();
    }

    public static com.google.cloud.aiplatform.v1beta1.FeatureView.SyncConfig getDefaultInstance() {
      return DEFAULT_INSTANCE;
    }

    private static final com.google.protobuf.Parser<SyncConfig> PARSER =
        new com.google.protobuf.AbstractParser<SyncConfig>() {
          @java.lang.Override
          public SyncConfig parsePartialFrom(
              com.google.protobuf.CodedInputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
            Builder builder = newBuilder();
            try {
              builder.mergeFrom(input, extensionRegistry);
            } catch (com.google.protobuf.InvalidProtocolBufferException e) {
              throw e.setUnfinishedMessage(builder.buildPartial());
            } catch (com.google.protobuf.UninitializedMessageException e) {
              throw e.asInvalidProtocolBufferException()
                  .setUnfinishedMessage(builder.buildPartial());
            } catch (java.io.IOException e) {
              throw new com.google.protobuf.InvalidProtocolBufferException(e)
                  .setUnfinishedMessage(builder.buildPartial());
            }
            return builder.buildPartial();
          }
        };

    public static com.google.protobuf.Parser<SyncConfig> parser() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.protobuf.Parser<SyncConfig> getParserForType() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.cloud.aiplatform.v1beta1.FeatureView.SyncConfig getDefaultInstanceForType() {
      return DEFAULT_INSTANCE;
    }
  }

  public interface VectorSearchConfigOrBuilder
      extends
      // @@protoc_insertion_point(interface_extends:google.cloud.aiplatform.v1beta1.FeatureView.VectorSearchConfig)
      com.google.protobuf.MessageOrBuilder {

    /**
     *
     *
     * <pre>
     * Optional. Configuration options for the tree-AH algorithm (Shallow tree
     * + Asymmetric Hashing). Please refer to this paper for more details:
     * https://arxiv.org/abs/1908.10396
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.FeatureView.VectorSearchConfig.TreeAHConfig tree_ah_config = 8 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return Whether the treeAhConfig field is set.
     */
    boolean hasTreeAhConfig();
    /**
     *
     *
     * <pre>
     * Optional. Configuration options for the tree-AH algorithm (Shallow tree
     * + Asymmetric Hashing). Please refer to this paper for more details:
     * https://arxiv.org/abs/1908.10396
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.FeatureView.VectorSearchConfig.TreeAHConfig tree_ah_config = 8 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return The treeAhConfig.
     */
    com.google.cloud.aiplatform.v1beta1.FeatureView.VectorSearchConfig.TreeAHConfig
        getTreeAhConfig();
    /**
     *
     *
     * <pre>
     * Optional. Configuration options for the tree-AH algorithm (Shallow tree
     * + Asymmetric Hashing). Please refer to this paper for more details:
     * https://arxiv.org/abs/1908.10396
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.FeatureView.VectorSearchConfig.TreeAHConfig tree_ah_config = 8 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    com.google.cloud.aiplatform.v1beta1.FeatureView.VectorSearchConfig.TreeAHConfigOrBuilder
        getTreeAhConfigOrBuilder();

    /**
     *
     *
     * <pre>
     * Optional. Configuration options for using brute force search, which
     * simply implements the standard linear search in the database for each
     * query. It is primarily meant for benchmarking and to generate the
     * ground truth for approximate search.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.FeatureView.VectorSearchConfig.BruteForceConfig brute_force_config = 9 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return Whether the bruteForceConfig field is set.
     */
    boolean hasBruteForceConfig();
    /**
     *
     *
     * <pre>
     * Optional. Configuration options for using brute force search, which
     * simply implements the standard linear search in the database for each
     * query. It is primarily meant for benchmarking and to generate the
     * ground truth for approximate search.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.FeatureView.VectorSearchConfig.BruteForceConfig brute_force_config = 9 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return The bruteForceConfig.
     */
    com.google.cloud.aiplatform.v1beta1.FeatureView.VectorSearchConfig.BruteForceConfig
        getBruteForceConfig();
    /**
     *
     *
     * <pre>
     * Optional. Configuration options for using brute force search, which
     * simply implements the standard linear search in the database for each
     * query. It is primarily meant for benchmarking and to generate the
     * ground truth for approximate search.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.FeatureView.VectorSearchConfig.BruteForceConfig brute_force_config = 9 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    com.google.cloud.aiplatform.v1beta1.FeatureView.VectorSearchConfig.BruteForceConfigOrBuilder
        getBruteForceConfigOrBuilder();

    /**
     *
     *
     * <pre>
     * Optional. Column of embedding. This column contains the source data to
     * create index for vector search. embedding_column must be set when using
     * vector search.
     * </pre>
     *
     * <code>string embedding_column = 3 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return The embeddingColumn.
     */
    java.lang.String getEmbeddingColumn();
    /**
     *
     *
     * <pre>
     * Optional. Column of embedding. This column contains the source data to
     * create index for vector search. embedding_column must be set when using
     * vector search.
     * </pre>
     *
     * <code>string embedding_column = 3 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return The bytes for embeddingColumn.
     */
    com.google.protobuf.ByteString getEmbeddingColumnBytes();

    /**
     *
     *
     * <pre>
     * Optional. Columns of features that're used to filter vector search
     * results.
     * </pre>
     *
     * <code>repeated string filter_columns = 4 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return A list containing the filterColumns.
     */
    java.util.List<java.lang.String> getFilterColumnsList();
    /**
     *
     *
     * <pre>
     * Optional. Columns of features that're used to filter vector search
     * results.
     * </pre>
     *
     * <code>repeated string filter_columns = 4 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return The count of filterColumns.
     */
    int getFilterColumnsCount();
    /**
     *
     *
     * <pre>
     * Optional. Columns of features that're used to filter vector search
     * results.
     * </pre>
     *
     * <code>repeated string filter_columns = 4 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @param index The index of the element to return.
     * @return The filterColumns at the given index.
     */
    java.lang.String getFilterColumns(int index);
    /**
     *
     *
     * <pre>
     * Optional. Columns of features that're used to filter vector search
     * results.
     * </pre>
     *
     * <code>repeated string filter_columns = 4 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @param index The index of the value to return.
     * @return The bytes of the filterColumns at the given index.
     */
    com.google.protobuf.ByteString getFilterColumnsBytes(int index);

    /**
     *
     *
     * <pre>
     * Optional. Column of crowding. This column contains crowding attribute
     * which is a constraint on a neighbor list produced by nearest neighbor
     * search requiring that no more than some value k' of the k neighbors
     * returned have the same value of crowding_attribute.
     * </pre>
     *
     * <code>string crowding_column = 5 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return The crowdingColumn.
     */
    java.lang.String getCrowdingColumn();
    /**
     *
     *
     * <pre>
     * Optional. Column of crowding. This column contains crowding attribute
     * which is a constraint on a neighbor list produced by nearest neighbor
     * search requiring that no more than some value k' of the k neighbors
     * returned have the same value of crowding_attribute.
     * </pre>
     *
     * <code>string crowding_column = 5 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return The bytes for crowdingColumn.
     */
    com.google.protobuf.ByteString getCrowdingColumnBytes();

    /**
     *
     *
     * <pre>
     * Optional. The number of dimensions of the input embedding.
     * </pre>
     *
     * <code>optional int32 embedding_dimension = 6 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return Whether the embeddingDimension field is set.
     */
    boolean hasEmbeddingDimension();
    /**
     *
     *
     * <pre>
     * Optional. The number of dimensions of the input embedding.
     * </pre>
     *
     * <code>optional int32 embedding_dimension = 6 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return The embeddingDimension.
     */
    int getEmbeddingDimension();

    /**
     *
     *
     * <pre>
     * Optional. The distance measure used in nearest neighbor search.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.FeatureView.VectorSearchConfig.DistanceMeasureType distance_measure_type = 7 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return The enum numeric value on the wire for distanceMeasureType.
     */
    int getDistanceMeasureTypeValue();
    /**
     *
     *
     * <pre>
     * Optional. The distance measure used in nearest neighbor search.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.FeatureView.VectorSearchConfig.DistanceMeasureType distance_measure_type = 7 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return The distanceMeasureType.
     */
    com.google.cloud.aiplatform.v1beta1.FeatureView.VectorSearchConfig.DistanceMeasureType
        getDistanceMeasureType();

    com.google.cloud.aiplatform.v1beta1.FeatureView.VectorSearchConfig.AlgorithmConfigCase
        getAlgorithmConfigCase();
  }
  /**
   *
   *
   * <pre>
   * Configuration for vector search.
   * </pre>
   *
   * Protobuf type {@code google.cloud.aiplatform.v1beta1.FeatureView.VectorSearchConfig}
   */
  public static final class VectorSearchConfig extends com.google.protobuf.GeneratedMessageV3
      implements
      // @@protoc_insertion_point(message_implements:google.cloud.aiplatform.v1beta1.FeatureView.VectorSearchConfig)
      VectorSearchConfigOrBuilder {
    private static final long serialVersionUID = 0L;
    // Use VectorSearchConfig.newBuilder() to construct.
    private VectorSearchConfig(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
      super(builder);
    }

    private VectorSearchConfig() {
      embeddingColumn_ = "";
      filterColumns_ = com.google.protobuf.LazyStringArrayList.emptyList();
      crowdingColumn_ = "";
      distanceMeasureType_ = 0;
    }

    @java.lang.Override
    @SuppressWarnings({"unused"})
    protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
      return new VectorSearchConfig();
    }

    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.aiplatform.v1beta1.FeatureViewProto
          .internal_static_google_cloud_aiplatform_v1beta1_FeatureView_VectorSearchConfig_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.aiplatform.v1beta1.FeatureViewProto
          .internal_static_google_cloud_aiplatform_v1beta1_FeatureView_VectorSearchConfig_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.aiplatform.v1beta1.FeatureView.VectorSearchConfig.class,
              com.google.cloud.aiplatform.v1beta1.FeatureView.VectorSearchConfig.Builder.class);
    }

    /**
     * Protobuf enum {@code
     * google.cloud.aiplatform.v1beta1.FeatureView.VectorSearchConfig.DistanceMeasureType}
     */
    public enum DistanceMeasureType implements com.google.protobuf.ProtocolMessageEnum {
      /**
       *
       *
       * <pre>
       * Should not be set.
       * </pre>
       *
       * <code>DISTANCE_MEASURE_TYPE_UNSPECIFIED = 0;</code>
       */
      DISTANCE_MEASURE_TYPE_UNSPECIFIED(0),
      /**
       *
       *
       * <pre>
       * Euclidean (L_2) Distance.
       * </pre>
       *
       * <code>SQUARED_L2_DISTANCE = 1;</code>
       */
      SQUARED_L2_DISTANCE(1),
      /**
       *
       *
       * <pre>
       * Cosine Distance. Defined as 1 - cosine similarity.
       *
       * We strongly suggest using DOT_PRODUCT_DISTANCE + UNIT_L2_NORM instead
       * of COSINE distance. Our algorithms have been more optimized for
       * DOT_PRODUCT distance which, when combined with UNIT_L2_NORM, is
       * mathematically equivalent to COSINE distance and results in the same
       * ranking.
       * </pre>
       *
       * <code>COSINE_DISTANCE = 2;</code>
       */
      COSINE_DISTANCE(2),
      /**
       *
       *
       * <pre>
       * Dot Product Distance. Defined as a negative of the dot product.
       * </pre>
       *
       * <code>DOT_PRODUCT_DISTANCE = 3;</code>
       */
      DOT_PRODUCT_DISTANCE(3),
      UNRECOGNIZED(-1),
      ;

      /**
       *
       *
       * <pre>
       * Should not be set.
       * </pre>
       *
       * <code>DISTANCE_MEASURE_TYPE_UNSPECIFIED = 0;</code>
       */
      public static final int DISTANCE_MEASURE_TYPE_UNSPECIFIED_VALUE = 0;
      /**
       *
       *
       * <pre>
       * Euclidean (L_2) Distance.
       * </pre>
       *
       * <code>SQUARED_L2_DISTANCE = 1;</code>
       */
      public static final int SQUARED_L2_DISTANCE_VALUE = 1;
      /**
       *
       *
       * <pre>
       * Cosine Distance. Defined as 1 - cosine similarity.
       *
       * We strongly suggest using DOT_PRODUCT_DISTANCE + UNIT_L2_NORM instead
       * of COSINE distance. Our algorithms have been more optimized for
       * DOT_PRODUCT distance which, when combined with UNIT_L2_NORM, is
       * mathematically equivalent to COSINE distance and results in the same
       * ranking.
       * </pre>
       *
       * <code>COSINE_DISTANCE = 2;</code>
       */
      public static final int COSINE_DISTANCE_VALUE = 2;
      /**
       *
       *
       * <pre>
       * Dot Product Distance. Defined as a negative of the dot product.
       * </pre>
       *
       * <code>DOT_PRODUCT_DISTANCE = 3;</code>
       */
      public static final int DOT_PRODUCT_DISTANCE_VALUE = 3;

      public final int getNumber() {
        if (this == UNRECOGNIZED) {
          throw new java.lang.IllegalArgumentException(
              "Can't get the number of an unknown enum value.");
        }
        return value;
      }

      /**
       * @param value The numeric wire value of the corresponding enum entry.
       * @return The enum associated with the given numeric wire value.
       * @deprecated Use {@link #forNumber(int)} instead.
       */
      @java.lang.Deprecated
      public static DistanceMeasureType valueOf(int value) {
        return forNumber(value);
      }

      /**
       * @param value The numeric wire value of the corresponding enum entry.
       * @return The enum associated with the given numeric wire value.
       */
      public static DistanceMeasureType forNumber(int value) {
        switch (value) {
          case 0:
            return DISTANCE_MEASURE_TYPE_UNSPECIFIED;
          case 1:
            return SQUARED_L2_DISTANCE;
          case 2:
            return COSINE_DISTANCE;
          case 3:
            return DOT_PRODUCT_DISTANCE;
          default:
            return null;
        }
      }

      public static com.google.protobuf.Internal.EnumLiteMap<DistanceMeasureType>
          internalGetValueMap() {
        return internalValueMap;
      }

      private static final com.google.protobuf.Internal.EnumLiteMap<DistanceMeasureType>
          internalValueMap =
              new com.google.protobuf.Internal.EnumLiteMap<DistanceMeasureType>() {
                public DistanceMeasureType findValueByNumber(int number) {
                  return DistanceMeasureType.forNumber(number);
                }
              };

      public final com.google.protobuf.Descriptors.EnumValueDescriptor getValueDescriptor() {
        if (this == UNRECOGNIZED) {
          throw new java.lang.IllegalStateException(
              "Can't get the descriptor of an unrecognized enum value.");
        }
        return getDescriptor().getValues().get(ordinal());
      }

      public final com.google.protobuf.Descriptors.EnumDescriptor getDescriptorForType() {
        return getDescriptor();
      }

      public static final com.google.protobuf.Descriptors.EnumDescriptor getDescriptor() {
        return com.google.cloud.aiplatform.v1beta1.FeatureView.VectorSearchConfig.getDescriptor()
            .getEnumTypes()
            .get(0);
      }

      private static final DistanceMeasureType[] VALUES = values();

      public static DistanceMeasureType valueOf(
          com.google.protobuf.Descriptors.EnumValueDescriptor desc) {
        if (desc.getType() != getDescriptor()) {
          throw new java.lang.IllegalArgumentException("EnumValueDescriptor is not for this type.");
        }
        if (desc.getIndex() == -1) {
          return UNRECOGNIZED;
        }
        return VALUES[desc.getIndex()];
      }

      private final int value;

      private DistanceMeasureType(int value) {
        this.value = value;
      }

      // @@protoc_insertion_point(enum_scope:google.cloud.aiplatform.v1beta1.FeatureView.VectorSearchConfig.DistanceMeasureType)
    }

    public interface BruteForceConfigOrBuilder
        extends
        // @@protoc_insertion_point(interface_extends:google.cloud.aiplatform.v1beta1.FeatureView.VectorSearchConfig.BruteForceConfig)
        com.google.protobuf.MessageOrBuilder {}
    /**
     * Protobuf type {@code
     * google.cloud.aiplatform.v1beta1.FeatureView.VectorSearchConfig.BruteForceConfig}
     */
    public static final class BruteForceConfig extends com.google.protobuf.GeneratedMessageV3
        implements
        // @@protoc_insertion_point(message_implements:google.cloud.aiplatform.v1beta1.FeatureView.VectorSearchConfig.BruteForceConfig)
        BruteForceConfigOrBuilder {
      private static final long serialVersionUID = 0L;
      // Use BruteForceConfig.newBuilder() to construct.
      private BruteForceConfig(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
        super(builder);
      }

      private BruteForceConfig() {}

      @java.lang.Override
      @SuppressWarnings({"unused"})
      protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
        return new BruteForceConfig();
      }

      public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
        return com.google.cloud.aiplatform.v1beta1.FeatureViewProto
            .internal_static_google_cloud_aiplatform_v1beta1_FeatureView_VectorSearchConfig_BruteForceConfig_descriptor;
      }

      @java.lang.Override
      protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return com.google.cloud.aiplatform.v1beta1.FeatureViewProto
            .internal_static_google_cloud_aiplatform_v1beta1_FeatureView_VectorSearchConfig_BruteForceConfig_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                com.google.cloud.aiplatform.v1beta1.FeatureView.VectorSearchConfig.BruteForceConfig
                    .class,
                com.google.cloud.aiplatform.v1beta1.FeatureView.VectorSearchConfig.BruteForceConfig
                    .Builder.class);
      }

      private byte memoizedIsInitialized = -1;

      @java.lang.Override
      public final boolean isInitialized() {
        byte isInitialized = memoizedIsInitialized;
        if (isInitialized == 1) return true;
        if (isInitialized == 0) return false;

        memoizedIsInitialized = 1;
        return true;
      }

      @java.lang.Override
      public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
        getUnknownFields().writeTo(output);
      }

      @java.lang.Override
      public int getSerializedSize() {
        int size = memoizedSize;
        if (size != -1) return size;

        size = 0;
        size += getUnknownFields().getSerializedSize();
        memoizedSize = size;
        return size;
      }

      @java.lang.Override
      public boolean equals(final java.lang.Object obj) {
        if (obj == this) {
          return true;
        }
        if (!(obj
            instanceof
            com.google.cloud.aiplatform.v1beta1.FeatureView.VectorSearchConfig.BruteForceConfig)) {
          return super.equals(obj);
        }
        com.google.cloud.aiplatform.v1beta1.FeatureView.VectorSearchConfig.BruteForceConfig other =
            (com.google.cloud.aiplatform.v1beta1.FeatureView.VectorSearchConfig.BruteForceConfig)
                obj;

        if (!getUnknownFields().equals(other.getUnknownFields())) return false;
        return true;
      }

      @java.lang.Override
      public int hashCode() {
        if (memoizedHashCode != 0) {
          return memoizedHashCode;
        }
        int hash = 41;
        hash = (19 * hash) + getDescriptor().hashCode();
        hash = (29 * hash) + getUnknownFields().hashCode();
        memoizedHashCode = hash;
        return hash;
      }

      public static com.google.cloud.aiplatform.v1beta1.FeatureView.VectorSearchConfig
              .BruteForceConfig
          parseFrom(java.nio.ByteBuffer data)
              throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data);
      }

      public static com.google.cloud.aiplatform.v1beta1.FeatureView.VectorSearchConfig
              .BruteForceConfig
          parseFrom(
              java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data, extensionRegistry);
      }

      public static com.google.cloud.aiplatform.v1beta1.FeatureView.VectorSearchConfig
              .BruteForceConfig
          parseFrom(com.google.protobuf.ByteString data)
              throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data);
      }

      public static com.google.cloud.aiplatform.v1beta1.FeatureView.VectorSearchConfig
              .BruteForceConfig
          parseFrom(
              com.google.protobuf.ByteString data,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data, extensionRegistry);
      }

      public static com.google.cloud.aiplatform.v1beta1.FeatureView.VectorSearchConfig
              .BruteForceConfig
          parseFrom(byte[] data) throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data);
      }

      public static com.google.cloud.aiplatform.v1beta1.FeatureView.VectorSearchConfig
              .BruteForceConfig
          parseFrom(byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data, extensionRegistry);
      }

      public static com.google.cloud.aiplatform.v1beta1.FeatureView.VectorSearchConfig
              .BruteForceConfig
          parseFrom(java.io.InputStream input) throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
      }

      public static com.google.cloud.aiplatform.v1beta1.FeatureView.VectorSearchConfig
              .BruteForceConfig
          parseFrom(
              java.io.InputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
            PARSER, input, extensionRegistry);
      }

      public static com.google.cloud.aiplatform.v1beta1.FeatureView.VectorSearchConfig
              .BruteForceConfig
          parseDelimitedFrom(java.io.InputStream input) throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
      }

      public static com.google.cloud.aiplatform.v1beta1.FeatureView.VectorSearchConfig
              .BruteForceConfig
          parseDelimitedFrom(
              java.io.InputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
            PARSER, input, extensionRegistry);
      }

      public static com.google.cloud.aiplatform.v1beta1.FeatureView.VectorSearchConfig
              .BruteForceConfig
          parseFrom(com.google.protobuf.CodedInputStream input) throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
      }

      public static com.google.cloud.aiplatform.v1beta1.FeatureView.VectorSearchConfig
              .BruteForceConfig
          parseFrom(
              com.google.protobuf.CodedInputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
            PARSER, input, extensionRegistry);
      }

      @java.lang.Override
      public Builder newBuilderForType() {
        return newBuilder();
      }

      public static Builder newBuilder() {
        return DEFAULT_INSTANCE.toBuilder();
      }

      public static Builder newBuilder(
          com.google.cloud.aiplatform.v1beta1.FeatureView.VectorSearchConfig.BruteForceConfig
              prototype) {
        return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
      }

      @java.lang.Override
      public Builder toBuilder() {
        return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
      }

      @java.lang.Override
      protected Builder newBuilderForType(
          com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
        Builder builder = new Builder(parent);
        return builder;
      }
      /**
       * Protobuf type {@code
       * google.cloud.aiplatform.v1beta1.FeatureView.VectorSearchConfig.BruteForceConfig}
       */
      public static final class Builder
          extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
          implements
          // @@protoc_insertion_point(builder_implements:google.cloud.aiplatform.v1beta1.FeatureView.VectorSearchConfig.BruteForceConfig)
          com.google.cloud.aiplatform.v1beta1.FeatureView.VectorSearchConfig
              .BruteForceConfigOrBuilder {
        public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
          return com.google.cloud.aiplatform.v1beta1.FeatureViewProto
              .internal_static_google_cloud_aiplatform_v1beta1_FeatureView_VectorSearchConfig_BruteForceConfig_descriptor;
        }

        @java.lang.Override
        protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
            internalGetFieldAccessorTable() {
          return com.google.cloud.aiplatform.v1beta1.FeatureViewProto
              .internal_static_google_cloud_aiplatform_v1beta1_FeatureView_VectorSearchConfig_BruteForceConfig_fieldAccessorTable
              .ensureFieldAccessorsInitialized(
                  com.google.cloud.aiplatform.v1beta1.FeatureView.VectorSearchConfig
                      .BruteForceConfig.class,
                  com.google.cloud.aiplatform.v1beta1.FeatureView.VectorSearchConfig
                      .BruteForceConfig.Builder.class);
        }

        // Construct using
        // com.google.cloud.aiplatform.v1beta1.FeatureView.VectorSearchConfig.BruteForceConfig.newBuilder()
        private Builder() {}

        private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
          super(parent);
        }

        @java.lang.Override
        public Builder clear() {
          super.clear();
          return this;
        }

        @java.lang.Override
        public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
          return com.google.cloud.aiplatform.v1beta1.FeatureViewProto
              .internal_static_google_cloud_aiplatform_v1beta1_FeatureView_VectorSearchConfig_BruteForceConfig_descriptor;
        }

        @java.lang.Override
        public com.google.cloud.aiplatform.v1beta1.FeatureView.VectorSearchConfig.BruteForceConfig
            getDefaultInstanceForType() {
          return com.google.cloud.aiplatform.v1beta1.FeatureView.VectorSearchConfig.BruteForceConfig
              .getDefaultInstance();
        }

        @java.lang.Override
        public com.google.cloud.aiplatform.v1beta1.FeatureView.VectorSearchConfig.BruteForceConfig
            build() {
          com.google.cloud.aiplatform.v1beta1.FeatureView.VectorSearchConfig.BruteForceConfig
              result = buildPartial();
          if (!result.isInitialized()) {
            throw newUninitializedMessageException(result);
          }
          return result;
        }

        @java.lang.Override
        public com.google.cloud.aiplatform.v1beta1.FeatureView.VectorSearchConfig.BruteForceConfig
            buildPartial() {
          com.google.cloud.aiplatform.v1beta1.FeatureView.VectorSearchConfig.BruteForceConfig
              result =
                  new com.google.cloud.aiplatform.v1beta1.FeatureView.VectorSearchConfig
                      .BruteForceConfig(this);
          onBuilt();
          return result;
        }

        @java.lang.Override
        public Builder clone() {
          return super.clone();
        }

        @java.lang.Override
        public Builder setField(
            com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
          return super.setField(field, value);
        }

        @java.lang.Override
        public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
          return super.clearField(field);
        }

        @java.lang.Override
        public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
          return super.clearOneof(oneof);
        }

        @java.lang.Override
        public Builder setRepeatedField(
            com.google.protobuf.Descriptors.FieldDescriptor field,
            int index,
            java.lang.Object value) {
          return super.setRepeatedField(field, index, value);
        }

        @java.lang.Override
        public Builder addRepeatedField(
            com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
          return super.addRepeatedField(field, value);
        }

        @java.lang.Override
        public Builder mergeFrom(com.google.protobuf.Message other) {
          if (other
              instanceof
              com.google.cloud.aiplatform.v1beta1.FeatureView.VectorSearchConfig.BruteForceConfig) {
            return mergeFrom(
                (com.google.cloud.aiplatform.v1beta1.FeatureView.VectorSearchConfig
                        .BruteForceConfig)
                    other);
          } else {
            super.mergeFrom(other);
            return this;
          }
        }

        public Builder mergeFrom(
            com.google.cloud.aiplatform.v1beta1.FeatureView.VectorSearchConfig.BruteForceConfig
                other) {
          if (other
              == com.google.cloud.aiplatform.v1beta1.FeatureView.VectorSearchConfig.BruteForceConfig
                  .getDefaultInstance()) return this;
          this.mergeUnknownFields(other.getUnknownFields());
          onChanged();
          return this;
        }

        @java.lang.Override
        public final boolean isInitialized() {
          return true;
        }

        @java.lang.Override
        public Builder mergeFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws java.io.IOException {
          if (extensionRegistry == null) {
            throw new java.lang.NullPointerException();
          }
          try {
            boolean done = false;
            while (!done) {
              int tag = input.readTag();
              switch (tag) {
                case 0:
                  done = true;
                  break;
                default:
                  {
                    if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                      done = true; // was an endgroup tag
                    }
                    break;
                  } // default:
              } // switch (tag)
            } // while (!done)
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.unwrapIOException();
          } finally {
            onChanged();
          } // finally
          return this;
        }

        @java.lang.Override
        public final Builder setUnknownFields(
            final com.google.protobuf.UnknownFieldSet unknownFields) {
          return super.setUnknownFields(unknownFields);
        }

        @java.lang.Override
        public final Builder mergeUnknownFields(
            final com.google.protobuf.UnknownFieldSet unknownFields) {
          return super.mergeUnknownFields(unknownFields);
        }

        // @@protoc_insertion_point(builder_scope:google.cloud.aiplatform.v1beta1.FeatureView.VectorSearchConfig.BruteForceConfig)
      }

      // @@protoc_insertion_point(class_scope:google.cloud.aiplatform.v1beta1.FeatureView.VectorSearchConfig.BruteForceConfig)
      private static final com.google.cloud.aiplatform.v1beta1.FeatureView.VectorSearchConfig
              .BruteForceConfig
          DEFAULT_INSTANCE;

      static {
        DEFAULT_INSTANCE =
            new com.google.cloud.aiplatform.v1beta1.FeatureView.VectorSearchConfig
                .BruteForceConfig();
      }

      public static com.google.cloud.aiplatform.v1beta1.FeatureView.VectorSearchConfig
              .BruteForceConfig
          getDefaultInstance() {
        return DEFAULT_INSTANCE;
      }

      private static final com.google.protobuf.Parser<BruteForceConfig> PARSER =
          new com.google.protobuf.AbstractParser<BruteForceConfig>() {
            @java.lang.Override
            public BruteForceConfig parsePartialFrom(
                com.google.protobuf.CodedInputStream input,
                com.google.protobuf.ExtensionRegistryLite extensionRegistry)
                throws com.google.protobuf.InvalidProtocolBufferException {
              Builder builder = newBuilder();
              try {
                builder.mergeFrom(input, extensionRegistry);
              } catch (com.google.protobuf.InvalidProtocolBufferException e) {
                throw e.setUnfinishedMessage(builder.buildPartial());
              } catch (com.google.protobuf.UninitializedMessageException e) {
                throw e.asInvalidProtocolBufferException()
                    .setUnfinishedMessage(builder.buildPartial());
              } catch (java.io.IOException e) {
                throw new com.google.protobuf.InvalidProtocolBufferException(e)
                    .setUnfinishedMessage(builder.buildPartial());
              }
              return builder.buildPartial();
            }
          };

      public static com.google.protobuf.Parser<BruteForceConfig> parser() {
        return PARSER;
      }

      @java.lang.Override
      public com.google.protobuf.Parser<BruteForceConfig> getParserForType() {
        return PARSER;
      }

      @java.lang.Override
      public com.google.cloud.aiplatform.v1beta1.FeatureView.VectorSearchConfig.BruteForceConfig
          getDefaultInstanceForType() {
        return DEFAULT_INSTANCE;
      }
    }

    public interface TreeAHConfigOrBuilder
        extends
        // @@protoc_insertion_point(interface_extends:google.cloud.aiplatform.v1beta1.FeatureView.VectorSearchConfig.TreeAHConfig)
        com.google.protobuf.MessageOrBuilder {

      /**
       *
       *
       * <pre>
       * Optional. Number of embeddings on each leaf node. The default value is
       * 1000 if not set.
       * </pre>
       *
       * <code>
       * optional int64 leaf_node_embedding_count = 1 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       *
       * @return Whether the leafNodeEmbeddingCount field is set.
       */
      boolean hasLeafNodeEmbeddingCount();
      /**
       *
       *
       * <pre>
       * Optional. Number of embeddings on each leaf node. The default value is
       * 1000 if not set.
       * </pre>
       *
       * <code>
       * optional int64 leaf_node_embedding_count = 1 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       *
       * @return The leafNodeEmbeddingCount.
       */
      long getLeafNodeEmbeddingCount();
    }
    /**
     * Protobuf type {@code
     * google.cloud.aiplatform.v1beta1.FeatureView.VectorSearchConfig.TreeAHConfig}
     */
    public static final class TreeAHConfig extends com.google.protobuf.GeneratedMessageV3
        implements
        // @@protoc_insertion_point(message_implements:google.cloud.aiplatform.v1beta1.FeatureView.VectorSearchConfig.TreeAHConfig)
        TreeAHConfigOrBuilder {
      private static final long serialVersionUID = 0L;
      // Use TreeAHConfig.newBuilder() to construct.
      private TreeAHConfig(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
        super(builder);
      }

      private TreeAHConfig() {}

      @java.lang.Override
      @SuppressWarnings({"unused"})
      protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
        return new TreeAHConfig();
      }

      public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
        return com.google.cloud.aiplatform.v1beta1.FeatureViewProto
            .internal_static_google_cloud_aiplatform_v1beta1_FeatureView_VectorSearchConfig_TreeAHConfig_descriptor;
      }

      @java.lang.Override
      protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return com.google.cloud.aiplatform.v1beta1.FeatureViewProto
            .internal_static_google_cloud_aiplatform_v1beta1_FeatureView_VectorSearchConfig_TreeAHConfig_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                com.google.cloud.aiplatform.v1beta1.FeatureView.VectorSearchConfig.TreeAHConfig
                    .class,
                com.google.cloud.aiplatform.v1beta1.FeatureView.VectorSearchConfig.TreeAHConfig
                    .Builder.class);
      }

      private int bitField0_;
      public static final int LEAF_NODE_EMBEDDING_COUNT_FIELD_NUMBER = 1;
      private long leafNodeEmbeddingCount_ = 0L;
      /**
       *
       *
       * <pre>
       * Optional. Number of embeddings on each leaf node. The default value is
       * 1000 if not set.
       * </pre>
       *
       * <code>
       * optional int64 leaf_node_embedding_count = 1 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       *
       * @return Whether the leafNodeEmbeddingCount field is set.
       */
      @java.lang.Override
      public boolean hasLeafNodeEmbeddingCount() {
        return ((bitField0_ & 0x00000001) != 0);
      }
      /**
       *
       *
       * <pre>
       * Optional. Number of embeddings on each leaf node. The default value is
       * 1000 if not set.
       * </pre>
       *
       * <code>
       * optional int64 leaf_node_embedding_count = 1 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       *
       * @return The leafNodeEmbeddingCount.
       */
      @java.lang.Override
      public long getLeafNodeEmbeddingCount() {
        return leafNodeEmbeddingCount_;
      }

      private byte memoizedIsInitialized = -1;

      @java.lang.Override
      public final boolean isInitialized() {
        byte isInitialized = memoizedIsInitialized;
        if (isInitialized == 1) return true;
        if (isInitialized == 0) return false;

        memoizedIsInitialized = 1;
        return true;
      }

      @java.lang.Override
      public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
        if (((bitField0_ & 0x00000001) != 0)) {
          output.writeInt64(1, leafNodeEmbeddingCount_);
        }
        getUnknownFields().writeTo(output);
      }

      @java.lang.Override
      public int getSerializedSize() {
        int size = memoizedSize;
        if (size != -1) return size;

        size = 0;
        if (((bitField0_ & 0x00000001) != 0)) {
          size +=
              com.google.protobuf.CodedOutputStream.computeInt64Size(1, leafNodeEmbeddingCount_);
        }
        size += getUnknownFields().getSerializedSize();
        memoizedSize = size;
        return size;
      }

      @java.lang.Override
      public boolean equals(final java.lang.Object obj) {
        if (obj == this) {
          return true;
        }
        if (!(obj
            instanceof
            com.google.cloud.aiplatform.v1beta1.FeatureView.VectorSearchConfig.TreeAHConfig)) {
          return super.equals(obj);
        }
        com.google.cloud.aiplatform.v1beta1.FeatureView.VectorSearchConfig.TreeAHConfig other =
            (com.google.cloud.aiplatform.v1beta1.FeatureView.VectorSearchConfig.TreeAHConfig) obj;

        if (hasLeafNodeEmbeddingCount() != other.hasLeafNodeEmbeddingCount()) return false;
        if (hasLeafNodeEmbeddingCount()) {
          if (getLeafNodeEmbeddingCount() != other.getLeafNodeEmbeddingCount()) return false;
        }
        if (!getUnknownFields().equals(other.getUnknownFields())) return false;
        return true;
      }

      @java.lang.Override
      public int hashCode() {
        if (memoizedHashCode != 0) {
          return memoizedHashCode;
        }
        int hash = 41;
        hash = (19 * hash) + getDescriptor().hashCode();
        if (hasLeafNodeEmbeddingCount()) {
          hash = (37 * hash) + LEAF_NODE_EMBEDDING_COUNT_FIELD_NUMBER;
          hash = (53 * hash) + com.google.protobuf.Internal.hashLong(getLeafNodeEmbeddingCount());
        }
        hash = (29 * hash) + getUnknownFields().hashCode();
        memoizedHashCode = hash;
        return hash;
      }

      public static com.google.cloud.aiplatform.v1beta1.FeatureView.VectorSearchConfig.TreeAHConfig
          parseFrom(java.nio.ByteBuffer data)
              throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data);
      }

      public static com.google.cloud.aiplatform.v1beta1.FeatureView.VectorSearchConfig.TreeAHConfig
          parseFrom(
              java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data, extensionRegistry);
      }

      public static com.google.cloud.aiplatform.v1beta1.FeatureView.VectorSearchConfig.TreeAHConfig
          parseFrom(com.google.protobuf.ByteString data)
              throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data);
      }

      public static com.google.cloud.aiplatform.v1beta1.FeatureView.VectorSearchConfig.TreeAHConfig
          parseFrom(
              com.google.protobuf.ByteString data,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data, extensionRegistry);
      }

      public static com.google.cloud.aiplatform.v1beta1.FeatureView.VectorSearchConfig.TreeAHConfig
          parseFrom(byte[] data) throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data);
      }

      public static com.google.cloud.aiplatform.v1beta1.FeatureView.VectorSearchConfig.TreeAHConfig
          parseFrom(byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data, extensionRegistry);
      }

      public static com.google.cloud.aiplatform.v1beta1.FeatureView.VectorSearchConfig.TreeAHConfig
          parseFrom(java.io.InputStream input) throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
      }

      public static com.google.cloud.aiplatform.v1beta1.FeatureView.VectorSearchConfig.TreeAHConfig
          parseFrom(
              java.io.InputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
            PARSER, input, extensionRegistry);
      }

      public static com.google.cloud.aiplatform.v1beta1.FeatureView.VectorSearchConfig.TreeAHConfig
          parseDelimitedFrom(java.io.InputStream input) throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
      }

      public static com.google.cloud.aiplatform.v1beta1.FeatureView.VectorSearchConfig.TreeAHConfig
          parseDelimitedFrom(
              java.io.InputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
            PARSER, input, extensionRegistry);
      }

      public static com.google.cloud.aiplatform.v1beta1.FeatureView.VectorSearchConfig.TreeAHConfig
          parseFrom(com.google.protobuf.CodedInputStream input) throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
      }

      public static com.google.cloud.aiplatform.v1beta1.FeatureView.VectorSearchConfig.TreeAHConfig
          parseFrom(
              com.google.protobuf.CodedInputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
            PARSER, input, extensionRegistry);
      }

      @java.lang.Override
      public Builder newBuilderForType() {
        return newBuilder();
      }

      public static Builder newBuilder() {
        return DEFAULT_INSTANCE.toBuilder();
      }

      public static Builder newBuilder(
          com.google.cloud.aiplatform.v1beta1.FeatureView.VectorSearchConfig.TreeAHConfig
              prototype) {
        return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
      }

      @java.lang.Override
      public Builder toBuilder() {
        return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
      }

      @java.lang.Override
      protected Builder newBuilderForType(
          com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
        Builder builder = new Builder(parent);
        return builder;
      }
      /**
       * Protobuf type {@code
       * google.cloud.aiplatform.v1beta1.FeatureView.VectorSearchConfig.TreeAHConfig}
       */
      public static final class Builder
          extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
          implements
          // @@protoc_insertion_point(builder_implements:google.cloud.aiplatform.v1beta1.FeatureView.VectorSearchConfig.TreeAHConfig)
          com.google.cloud.aiplatform.v1beta1.FeatureView.VectorSearchConfig.TreeAHConfigOrBuilder {
        public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
          return com.google.cloud.aiplatform.v1beta1.FeatureViewProto
              .internal_static_google_cloud_aiplatform_v1beta1_FeatureView_VectorSearchConfig_TreeAHConfig_descriptor;
        }

        @java.lang.Override
        protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
            internalGetFieldAccessorTable() {
          return com.google.cloud.aiplatform.v1beta1.FeatureViewProto
              .internal_static_google_cloud_aiplatform_v1beta1_FeatureView_VectorSearchConfig_TreeAHConfig_fieldAccessorTable
              .ensureFieldAccessorsInitialized(
                  com.google.cloud.aiplatform.v1beta1.FeatureView.VectorSearchConfig.TreeAHConfig
                      .class,
                  com.google.cloud.aiplatform.v1beta1.FeatureView.VectorSearchConfig.TreeAHConfig
                      .Builder.class);
        }

        // Construct using
        // com.google.cloud.aiplatform.v1beta1.FeatureView.VectorSearchConfig.TreeAHConfig.newBuilder()
        private Builder() {}

        private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
          super(parent);
        }

        @java.lang.Override
        public Builder clear() {
          super.clear();
          bitField0_ = 0;
          leafNodeEmbeddingCount_ = 0L;
          return this;
        }

        @java.lang.Override
        public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
          return com.google.cloud.aiplatform.v1beta1.FeatureViewProto
              .internal_static_google_cloud_aiplatform_v1beta1_FeatureView_VectorSearchConfig_TreeAHConfig_descriptor;
        }

        @java.lang.Override
        public com.google.cloud.aiplatform.v1beta1.FeatureView.VectorSearchConfig.TreeAHConfig
            getDefaultInstanceForType() {
          return com.google.cloud.aiplatform.v1beta1.FeatureView.VectorSearchConfig.TreeAHConfig
              .getDefaultInstance();
        }

        @java.lang.Override
        public com.google.cloud.aiplatform.v1beta1.FeatureView.VectorSearchConfig.TreeAHConfig
            build() {
          com.google.cloud.aiplatform.v1beta1.FeatureView.VectorSearchConfig.TreeAHConfig result =
              buildPartial();
          if (!result.isInitialized()) {
            throw newUninitializedMessageException(result);
          }
          return result;
        }

        @java.lang.Override
        public com.google.cloud.aiplatform.v1beta1.FeatureView.VectorSearchConfig.TreeAHConfig
            buildPartial() {
          com.google.cloud.aiplatform.v1beta1.FeatureView.VectorSearchConfig.TreeAHConfig result =
              new com.google.cloud.aiplatform.v1beta1.FeatureView.VectorSearchConfig.TreeAHConfig(
                  this);
          if (bitField0_ != 0) {
            buildPartial0(result);
          }
          onBuilt();
          return result;
        }

        private void buildPartial0(
            com.google.cloud.aiplatform.v1beta1.FeatureView.VectorSearchConfig.TreeAHConfig
                result) {
          int from_bitField0_ = bitField0_;
          int to_bitField0_ = 0;
          if (((from_bitField0_ & 0x00000001) != 0)) {
            result.leafNodeEmbeddingCount_ = leafNodeEmbeddingCount_;
            to_bitField0_ |= 0x00000001;
          }
          result.bitField0_ |= to_bitField0_;
        }

        @java.lang.Override
        public Builder clone() {
          return super.clone();
        }

        @java.lang.Override
        public Builder setField(
            com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
          return super.setField(field, value);
        }

        @java.lang.Override
        public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
          return super.clearField(field);
        }

        @java.lang.Override
        public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
          return super.clearOneof(oneof);
        }

        @java.lang.Override
        public Builder setRepeatedField(
            com.google.protobuf.Descriptors.FieldDescriptor field,
            int index,
            java.lang.Object value) {
          return super.setRepeatedField(field, index, value);
        }

        @java.lang.Override
        public Builder addRepeatedField(
            com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
          return super.addRepeatedField(field, value);
        }

        @java.lang.Override
        public Builder mergeFrom(com.google.protobuf.Message other) {
          if (other
              instanceof
              com.google.cloud.aiplatform.v1beta1.FeatureView.VectorSearchConfig.TreeAHConfig) {
            return mergeFrom(
                (com.google.cloud.aiplatform.v1beta1.FeatureView.VectorSearchConfig.TreeAHConfig)
                    other);
          } else {
            super.mergeFrom(other);
            return this;
          }
        }

        public Builder mergeFrom(
            com.google.cloud.aiplatform.v1beta1.FeatureView.VectorSearchConfig.TreeAHConfig other) {
          if (other
              == com.google.cloud.aiplatform.v1beta1.FeatureView.VectorSearchConfig.TreeAHConfig
                  .getDefaultInstance()) return this;
          if (other.hasLeafNodeEmbeddingCount()) {
            setLeafNodeEmbeddingCount(other.getLeafNodeEmbeddingCount());
          }
          this.mergeUnknownFields(other.getUnknownFields());
          onChanged();
          return this;
        }

        @java.lang.Override
        public final boolean isInitialized() {
          return true;
        }

        @java.lang.Override
        public Builder mergeFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws java.io.IOException {
          if (extensionRegistry == null) {
            throw new java.lang.NullPointerException();
          }
          try {
            boolean done = false;
            while (!done) {
              int tag = input.readTag();
              switch (tag) {
                case 0:
                  done = true;
                  break;
                case 8:
                  {
                    leafNodeEmbeddingCount_ = input.readInt64();
                    bitField0_ |= 0x00000001;
                    break;
                  } // case 8
                default:
                  {
                    if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                      done = true; // was an endgroup tag
                    }
                    break;
                  } // default:
              } // switch (tag)
            } // while (!done)
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.unwrapIOException();
          } finally {
            onChanged();
          } // finally
          return this;
        }

        private int bitField0_;

        private long leafNodeEmbeddingCount_;
        /**
         *
         *
         * <pre>
         * Optional. Number of embeddings on each leaf node. The default value is
         * 1000 if not set.
         * </pre>
         *
         * <code>
         * optional int64 leaf_node_embedding_count = 1 [(.google.api.field_behavior) = OPTIONAL];
         * </code>
         *
         * @return Whether the leafNodeEmbeddingCount field is set.
         */
        @java.lang.Override
        public boolean hasLeafNodeEmbeddingCount() {
          return ((bitField0_ & 0x00000001) != 0);
        }
        /**
         *
         *
         * <pre>
         * Optional. Number of embeddings on each leaf node. The default value is
         * 1000 if not set.
         * </pre>
         *
         * <code>
         * optional int64 leaf_node_embedding_count = 1 [(.google.api.field_behavior) = OPTIONAL];
         * </code>
         *
         * @return The leafNodeEmbeddingCount.
         */
        @java.lang.Override
        public long getLeafNodeEmbeddingCount() {
          return leafNodeEmbeddingCount_;
        }
        /**
         *
         *
         * <pre>
         * Optional. Number of embeddings on each leaf node. The default value is
         * 1000 if not set.
         * </pre>
         *
         * <code>
         * optional int64 leaf_node_embedding_count = 1 [(.google.api.field_behavior) = OPTIONAL];
         * </code>
         *
         * @param value The leafNodeEmbeddingCount to set.
         * @return This builder for chaining.
         */
        public Builder setLeafNodeEmbeddingCount(long value) {

          leafNodeEmbeddingCount_ = value;
          bitField0_ |= 0x00000001;
          onChanged();
          return this;
        }
        /**
         *
         *
         * <pre>
         * Optional. Number of embeddings on each leaf node. The default value is
         * 1000 if not set.
         * </pre>
         *
         * <code>
         * optional int64 leaf_node_embedding_count = 1 [(.google.api.field_behavior) = OPTIONAL];
         * </code>
         *
         * @return This builder for chaining.
         */
        public Builder clearLeafNodeEmbeddingCount() {
          bitField0_ = (bitField0_ & ~0x00000001);
          leafNodeEmbeddingCount_ = 0L;
          onChanged();
          return this;
        }

        @java.lang.Override
        public final Builder setUnknownFields(
            final com.google.protobuf.UnknownFieldSet unknownFields) {
          return super.setUnknownFields(unknownFields);
        }

        @java.lang.Override
        public final Builder mergeUnknownFields(
            final com.google.protobuf.UnknownFieldSet unknownFields) {
          return super.mergeUnknownFields(unknownFields);
        }

        // @@protoc_insertion_point(builder_scope:google.cloud.aiplatform.v1beta1.FeatureView.VectorSearchConfig.TreeAHConfig)
      }

      // @@protoc_insertion_point(class_scope:google.cloud.aiplatform.v1beta1.FeatureView.VectorSearchConfig.TreeAHConfig)
      private static final com.google.cloud.aiplatform.v1beta1.FeatureView.VectorSearchConfig
              .TreeAHConfig
          DEFAULT_INSTANCE;

      static {
        DEFAULT_INSTANCE =
            new com.google.cloud.aiplatform.v1beta1.FeatureView.VectorSearchConfig.TreeAHConfig();
      }

      public static com.google.cloud.aiplatform.v1beta1.FeatureView.VectorSearchConfig.TreeAHConfig
          getDefaultInstance() {
        return DEFAULT_INSTANCE;
      }

      private static final com.google.protobuf.Parser<TreeAHConfig> PARSER =
          new com.google.protobuf.AbstractParser<TreeAHConfig>() {
            @java.lang.Override
            public TreeAHConfig parsePartialFrom(
                com.google.protobuf.CodedInputStream input,
                com.google.protobuf.ExtensionRegistryLite extensionRegistry)
                throws com.google.protobuf.InvalidProtocolBufferException {
              Builder builder = newBuilder();
              try {
                builder.mergeFrom(input, extensionRegistry);
              } catch (com.google.protobuf.InvalidProtocolBufferException e) {
                throw e.setUnfinishedMessage(builder.buildPartial());
              } catch (com.google.protobuf.UninitializedMessageException e) {
                throw e.asInvalidProtocolBufferException()
                    .setUnfinishedMessage(builder.buildPartial());
              } catch (java.io.IOException e) {
                throw new com.google.protobuf.InvalidProtocolBufferException(e)
                    .setUnfinishedMessage(builder.buildPartial());
              }
              return builder.buildPartial();
            }
          };

      public static com.google.protobuf.Parser<TreeAHConfig> parser() {
        return PARSER;
      }

      @java.lang.Override
      public com.google.protobuf.Parser<TreeAHConfig> getParserForType() {
        return PARSER;
      }

      @java.lang.Override
      public com.google.cloud.aiplatform.v1beta1.FeatureView.VectorSearchConfig.TreeAHConfig
          getDefaultInstanceForType() {
        return DEFAULT_INSTANCE;
      }
    }

    private int bitField0_;
    private int algorithmConfigCase_ = 0;

    @SuppressWarnings("serial")
    private java.lang.Object algorithmConfig_;

    public enum AlgorithmConfigCase
        implements
            com.google.protobuf.Internal.EnumLite,
            com.google.protobuf.AbstractMessage.InternalOneOfEnum {
      TREE_AH_CONFIG(8),
      BRUTE_FORCE_CONFIG(9),
      ALGORITHMCONFIG_NOT_SET(0);
      private final int value;

      private AlgorithmConfigCase(int value) {
        this.value = value;
      }
      /**
       * @param value The number of the enum to look for.
       * @return The enum associated with the given number.
       * @deprecated Use {@link #forNumber(int)} instead.
       */
      @java.lang.Deprecated
      public static AlgorithmConfigCase valueOf(int value) {
        return forNumber(value);
      }

      public static AlgorithmConfigCase forNumber(int value) {
        switch (value) {
          case 8:
            return TREE_AH_CONFIG;
          case 9:
            return BRUTE_FORCE_CONFIG;
          case 0:
            return ALGORITHMCONFIG_NOT_SET;
          default:
            return null;
        }
      }

      public int getNumber() {
        return this.value;
      }
    };

    public AlgorithmConfigCase getAlgorithmConfigCase() {
      return AlgorithmConfigCase.forNumber(algorithmConfigCase_);
    }

    public static final int TREE_AH_CONFIG_FIELD_NUMBER = 8;
    /**
     *
     *
     * <pre>
     * Optional. Configuration options for the tree-AH algorithm (Shallow tree
     * + Asymmetric Hashing). Please refer to this paper for more details:
     * https://arxiv.org/abs/1908.10396
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.FeatureView.VectorSearchConfig.TreeAHConfig tree_ah_config = 8 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return Whether the treeAhConfig field is set.
     */
    @java.lang.Override
    public boolean hasTreeAhConfig() {
      return algorithmConfigCase_ == 8;
    }
    /**
     *
     *
     * <pre>
     * Optional. Configuration options for the tree-AH algorithm (Shallow tree
     * + Asymmetric Hashing). Please refer to this paper for more details:
     * https://arxiv.org/abs/1908.10396
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.FeatureView.VectorSearchConfig.TreeAHConfig tree_ah_config = 8 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return The treeAhConfig.
     */
    @java.lang.Override
    public com.google.cloud.aiplatform.v1beta1.FeatureView.VectorSearchConfig.TreeAHConfig
        getTreeAhConfig() {
      if (algorithmConfigCase_ == 8) {
        return (com.google.cloud.aiplatform.v1beta1.FeatureView.VectorSearchConfig.TreeAHConfig)
            algorithmConfig_;
      }
      return com.google.cloud.aiplatform.v1beta1.FeatureView.VectorSearchConfig.TreeAHConfig
          .getDefaultInstance();
    }
    /**
     *
     *
     * <pre>
     * Optional. Configuration options for the tree-AH algorithm (Shallow tree
     * + Asymmetric Hashing). Please refer to this paper for more details:
     * https://arxiv.org/abs/1908.10396
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.FeatureView.VectorSearchConfig.TreeAHConfig tree_ah_config = 8 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    @java.lang.Override
    public com.google.cloud.aiplatform.v1beta1.FeatureView.VectorSearchConfig.TreeAHConfigOrBuilder
        getTreeAhConfigOrBuilder() {
      if (algorithmConfigCase_ == 8) {
        return (com.google.cloud.aiplatform.v1beta1.FeatureView.VectorSearchConfig.TreeAHConfig)
            algorithmConfig_;
      }
      return com.google.cloud.aiplatform.v1beta1.FeatureView.VectorSearchConfig.TreeAHConfig
          .getDefaultInstance();
    }

    public static final int BRUTE_FORCE_CONFIG_FIELD_NUMBER = 9;
    /**
     *
     *
     * <pre>
     * Optional. Configuration options for using brute force search, which
     * simply implements the standard linear search in the database for each
     * query. It is primarily meant for benchmarking and to generate the
     * ground truth for approximate search.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.FeatureView.VectorSearchConfig.BruteForceConfig brute_force_config = 9 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return Whether the bruteForceConfig field is set.
     */
    @java.lang.Override
    public boolean hasBruteForceConfig() {
      return algorithmConfigCase_ == 9;
    }
    /**
     *
     *
     * <pre>
     * Optional. Configuration options for using brute force search, which
     * simply implements the standard linear search in the database for each
     * query. It is primarily meant for benchmarking and to generate the
     * ground truth for approximate search.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.FeatureView.VectorSearchConfig.BruteForceConfig brute_force_config = 9 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return The bruteForceConfig.
     */
    @java.lang.Override
    public com.google.cloud.aiplatform.v1beta1.FeatureView.VectorSearchConfig.BruteForceConfig
        getBruteForceConfig() {
      if (algorithmConfigCase_ == 9) {
        return (com.google.cloud.aiplatform.v1beta1.FeatureView.VectorSearchConfig.BruteForceConfig)
            algorithmConfig_;
      }
      return com.google.cloud.aiplatform.v1beta1.FeatureView.VectorSearchConfig.BruteForceConfig
          .getDefaultInstance();
    }
    /**
     *
     *
     * <pre>
     * Optional. Configuration options for using brute force search, which
     * simply implements the standard linear search in the database for each
     * query. It is primarily meant for benchmarking and to generate the
     * ground truth for approximate search.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.FeatureView.VectorSearchConfig.BruteForceConfig brute_force_config = 9 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    @java.lang.Override
    public com.google.cloud.aiplatform.v1beta1.FeatureView.VectorSearchConfig
            .BruteForceConfigOrBuilder
        getBruteForceConfigOrBuilder() {
      if (algorithmConfigCase_ == 9) {
        return (com.google.cloud.aiplatform.v1beta1.FeatureView.VectorSearchConfig.BruteForceConfig)
            algorithmConfig_;
      }
      return com.google.cloud.aiplatform.v1beta1.FeatureView.VectorSearchConfig.BruteForceConfig
          .getDefaultInstance();
    }

    public static final int EMBEDDING_COLUMN_FIELD_NUMBER = 3;

    @SuppressWarnings("serial")
    private volatile java.lang.Object embeddingColumn_ = "";
    /**
     *
     *
     * <pre>
     * Optional. Column of embedding. This column contains the source data to
     * create index for vector search. embedding_column must be set when using
     * vector search.
     * </pre>
     *
     * <code>string embedding_column = 3 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return The embeddingColumn.
     */
    @java.lang.Override
    public java.lang.String getEmbeddingColumn() {
      java.lang.Object ref = embeddingColumn_;
      if (ref instanceof java.lang.String) {
        return (java.lang.String) ref;
      } else {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        embeddingColumn_ = s;
        return s;
      }
    }
    /**
     *
     *
     * <pre>
     * Optional. Column of embedding. This column contains the source data to
     * create index for vector search. embedding_column must be set when using
     * vector search.
     * </pre>
     *
     * <code>string embedding_column = 3 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return The bytes for embeddingColumn.
     */
    @java.lang.Override
    public com.google.protobuf.ByteString getEmbeddingColumnBytes() {
      java.lang.Object ref = embeddingColumn_;
      if (ref instanceof java.lang.String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        embeddingColumn_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    public static final int FILTER_COLUMNS_FIELD_NUMBER = 4;

    @SuppressWarnings("serial")
    private com.google.protobuf.LazyStringArrayList filterColumns_ =
        com.google.protobuf.LazyStringArrayList.emptyList();
    /**
     *
     *
     * <pre>
     * Optional. Columns of features that're used to filter vector search
     * results.
     * </pre>
     *
     * <code>repeated string filter_columns = 4 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return A list containing the filterColumns.
     */
    public com.google.protobuf.ProtocolStringList getFilterColumnsList() {
      return filterColumns_;
    }
    /**
     *
     *
     * <pre>
     * Optional. Columns of features that're used to filter vector search
     * results.
     * </pre>
     *
     * <code>repeated string filter_columns = 4 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return The count of filterColumns.
     */
    public int getFilterColumnsCount() {
      return filterColumns_.size();
    }
    /**
     *
     *
     * <pre>
     * Optional. Columns of features that're used to filter vector search
     * results.
     * </pre>
     *
     * <code>repeated string filter_columns = 4 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @param index The index of the element to return.
     * @return The filterColumns at the given index.
     */
    public java.lang.String getFilterColumns(int index) {
      return filterColumns_.get(index);
    }
    /**
     *
     *
     * <pre>
     * Optional. Columns of features that're used to filter vector search
     * results.
     * </pre>
     *
     * <code>repeated string filter_columns = 4 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @param index The index of the value to return.
     * @return The bytes of the filterColumns at the given index.
     */
    public com.google.protobuf.ByteString getFilterColumnsBytes(int index) {
      return filterColumns_.getByteString(index);
    }

    public static final int CROWDING_COLUMN_FIELD_NUMBER = 5;

    @SuppressWarnings("serial")
    private volatile java.lang.Object crowdingColumn_ = "";
    /**
     *
     *
     * <pre>
     * Optional. Column of crowding. This column contains crowding attribute
     * which is a constraint on a neighbor list produced by nearest neighbor
     * search requiring that no more than some value k' of the k neighbors
     * returned have the same value of crowding_attribute.
     * </pre>
     *
     * <code>string crowding_column = 5 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return The crowdingColumn.
     */
    @java.lang.Override
    public java.lang.String getCrowdingColumn() {
      java.lang.Object ref = crowdingColumn_;
      if (ref instanceof java.lang.String) {
        return (java.lang.String) ref;
      } else {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        crowdingColumn_ = s;
        return s;
      }
    }
    /**
     *
     *
     * <pre>
     * Optional. Column of crowding. This column contains crowding attribute
     * which is a constraint on a neighbor list produced by nearest neighbor
     * search requiring that no more than some value k' of the k neighbors
     * returned have the same value of crowding_attribute.
     * </pre>
     *
     * <code>string crowding_column = 5 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return The bytes for crowdingColumn.
     */
    @java.lang.Override
    public com.google.protobuf.ByteString getCrowdingColumnBytes() {
      java.lang.Object ref = crowdingColumn_;
      if (ref instanceof java.lang.String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        crowdingColumn_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    public static final int EMBEDDING_DIMENSION_FIELD_NUMBER = 6;
    private int embeddingDimension_ = 0;
    /**
     *
     *
     * <pre>
     * Optional. The number of dimensions of the input embedding.
     * </pre>
     *
     * <code>optional int32 embedding_dimension = 6 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return Whether the embeddingDimension field is set.
     */
    @java.lang.Override
    public boolean hasEmbeddingDimension() {
      return ((bitField0_ & 0x00000001) != 0);
    }
    /**
     *
     *
     * <pre>
     * Optional. The number of dimensions of the input embedding.
     * </pre>
     *
     * <code>optional int32 embedding_dimension = 6 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return The embeddingDimension.
     */
    @java.lang.Override
    public int getEmbeddingDimension() {
      return embeddingDimension_;
    }

    public static final int DISTANCE_MEASURE_TYPE_FIELD_NUMBER = 7;
    private int distanceMeasureType_ = 0;
    /**
     *
     *
     * <pre>
     * Optional. The distance measure used in nearest neighbor search.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.FeatureView.VectorSearchConfig.DistanceMeasureType distance_measure_type = 7 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return The enum numeric value on the wire for distanceMeasureType.
     */
    @java.lang.Override
    public int getDistanceMeasureTypeValue() {
      return distanceMeasureType_;
    }
    /**
     *
     *
     * <pre>
     * Optional. The distance measure used in nearest neighbor search.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.FeatureView.VectorSearchConfig.DistanceMeasureType distance_measure_type = 7 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return The distanceMeasureType.
     */
    @java.lang.Override
    public com.google.cloud.aiplatform.v1beta1.FeatureView.VectorSearchConfig.DistanceMeasureType
        getDistanceMeasureType() {
      com.google.cloud.aiplatform.v1beta1.FeatureView.VectorSearchConfig.DistanceMeasureType
          result =
              com.google.cloud.aiplatform.v1beta1.FeatureView.VectorSearchConfig.DistanceMeasureType
                  .forNumber(distanceMeasureType_);
      return result == null
          ? com.google.cloud.aiplatform.v1beta1.FeatureView.VectorSearchConfig.DistanceMeasureType
              .UNRECOGNIZED
          : result;
    }

    private byte memoizedIsInitialized = -1;

    @java.lang.Override
    public final boolean isInitialized() {
      byte isInitialized = memoizedIsInitialized;
      if (isInitialized == 1) return true;
      if (isInitialized == 0) return false;

      memoizedIsInitialized = 1;
      return true;
    }

    @java.lang.Override
    public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(embeddingColumn_)) {
        com.google.protobuf.GeneratedMessageV3.writeString(output, 3, embeddingColumn_);
      }
      for (int i = 0; i < filterColumns_.size(); i++) {
        com.google.protobuf.GeneratedMessageV3.writeString(output, 4, filterColumns_.getRaw(i));
      }
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(crowdingColumn_)) {
        com.google.protobuf.GeneratedMessageV3.writeString(output, 5, crowdingColumn_);
      }
      if (((bitField0_ & 0x00000001) != 0)) {
        output.writeInt32(6, embeddingDimension_);
      }
      if (distanceMeasureType_
          != com.google.cloud.aiplatform.v1beta1.FeatureView.VectorSearchConfig.DistanceMeasureType
              .DISTANCE_MEASURE_TYPE_UNSPECIFIED
              .getNumber()) {
        output.writeEnum(7, distanceMeasureType_);
      }
      if (algorithmConfigCase_ == 8) {
        output.writeMessage(
            8,
            (com.google.cloud.aiplatform.v1beta1.FeatureView.VectorSearchConfig.TreeAHConfig)
                algorithmConfig_);
      }
      if (algorithmConfigCase_ == 9) {
        output.writeMessage(
            9,
            (com.google.cloud.aiplatform.v1beta1.FeatureView.VectorSearchConfig.BruteForceConfig)
                algorithmConfig_);
      }
      getUnknownFields().writeTo(output);
    }

    @java.lang.Override
    public int getSerializedSize() {
      int size = memoizedSize;
      if (size != -1) return size;

      size = 0;
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(embeddingColumn_)) {
        size += com.google.protobuf.GeneratedMessageV3.computeStringSize(3, embeddingColumn_);
      }
      {
        int dataSize = 0;
        for (int i = 0; i < filterColumns_.size(); i++) {
          dataSize += computeStringSizeNoTag(filterColumns_.getRaw(i));
        }
        size += dataSize;
        size += 1 * getFilterColumnsList().size();
      }
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(crowdingColumn_)) {
        size += com.google.protobuf.GeneratedMessageV3.computeStringSize(5, crowdingColumn_);
      }
      if (((bitField0_ & 0x00000001) != 0)) {
        size += com.google.protobuf.CodedOutputStream.computeInt32Size(6, embeddingDimension_);
      }
      if (distanceMeasureType_
          != com.google.cloud.aiplatform.v1beta1.FeatureView.VectorSearchConfig.DistanceMeasureType
              .DISTANCE_MEASURE_TYPE_UNSPECIFIED
              .getNumber()) {
        size += com.google.protobuf.CodedOutputStream.computeEnumSize(7, distanceMeasureType_);
      }
      if (algorithmConfigCase_ == 8) {
        size +=
            com.google.protobuf.CodedOutputStream.computeMessageSize(
                8,
                (com.google.cloud.aiplatform.v1beta1.FeatureView.VectorSearchConfig.TreeAHConfig)
                    algorithmConfig_);
      }
      if (algorithmConfigCase_ == 9) {
        size +=
            com.google.protobuf.CodedOutputStream.computeMessageSize(
                9,
                (com.google.cloud.aiplatform.v1beta1.FeatureView.VectorSearchConfig
                        .BruteForceConfig)
                    algorithmConfig_);
      }
      size += getUnknownFields().getSerializedSize();
      memoizedSize = size;
      return size;
    }

    @java.lang.Override
    public boolean equals(final java.lang.Object obj) {
      if (obj == this) {
        return true;
      }
      if (!(obj instanceof com.google.cloud.aiplatform.v1beta1.FeatureView.VectorSearchConfig)) {
        return super.equals(obj);
      }
      com.google.cloud.aiplatform.v1beta1.FeatureView.VectorSearchConfig other =
          (com.google.cloud.aiplatform.v1beta1.FeatureView.VectorSearchConfig) obj;

      if (!getEmbeddingColumn().equals(other.getEmbeddingColumn())) return false;
      if (!getFilterColumnsList().equals(other.getFilterColumnsList())) return false;
      if (!getCrowdingColumn().equals(other.getCrowdingColumn())) return false;
      if (hasEmbeddingDimension() != other.hasEmbeddingDimension()) return false;
      if (hasEmbeddingDimension()) {
        if (getEmbeddingDimension() != other.getEmbeddingDimension()) return false;
      }
      if (distanceMeasureType_ != other.distanceMeasureType_) return false;
      if (!getAlgorithmConfigCase().equals(other.getAlgorithmConfigCase())) return false;
      switch (algorithmConfigCase_) {
        case 8:
          if (!getTreeAhConfig().equals(other.getTreeAhConfig())) return false;
          break;
        case 9:
          if (!getBruteForceConfig().equals(other.getBruteForceConfig())) return false;
          break;
        case 0:
        default:
      }
      if (!getUnknownFields().equals(other.getUnknownFields())) return false;
      return true;
    }

    @java.lang.Override
    public int hashCode() {
      if (memoizedHashCode != 0) {
        return memoizedHashCode;
      }
      int hash = 41;
      hash = (19 * hash) + getDescriptor().hashCode();
      hash = (37 * hash) + EMBEDDING_COLUMN_FIELD_NUMBER;
      hash = (53 * hash) + getEmbeddingColumn().hashCode();
      if (getFilterColumnsCount() > 0) {
        hash = (37 * hash) + FILTER_COLUMNS_FIELD_NUMBER;
        hash = (53 * hash) + getFilterColumnsList().hashCode();
      }
      hash = (37 * hash) + CROWDING_COLUMN_FIELD_NUMBER;
      hash = (53 * hash) + getCrowdingColumn().hashCode();
      if (hasEmbeddingDimension()) {
        hash = (37 * hash) + EMBEDDING_DIMENSION_FIELD_NUMBER;
        hash = (53 * hash) + getEmbeddingDimension();
      }
      hash = (37 * hash) + DISTANCE_MEASURE_TYPE_FIELD_NUMBER;
      hash = (53 * hash) + distanceMeasureType_;
      switch (algorithmConfigCase_) {
        case 8:
          hash = (37 * hash) + TREE_AH_CONFIG_FIELD_NUMBER;
          hash = (53 * hash) + getTreeAhConfig().hashCode();
          break;
        case 9:
          hash = (37 * hash) + BRUTE_FORCE_CONFIG_FIELD_NUMBER;
          hash = (53 * hash) + getBruteForceConfig().hashCode();
          break;
        case 0:
        default:
      }
      hash = (29 * hash) + getUnknownFields().hashCode();
      memoizedHashCode = hash;
      return hash;
    }

    public static com.google.cloud.aiplatform.v1beta1.FeatureView.VectorSearchConfig parseFrom(
        java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.aiplatform.v1beta1.FeatureView.VectorSearchConfig parseFrom(
        java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.aiplatform.v1beta1.FeatureView.VectorSearchConfig parseFrom(
        com.google.protobuf.ByteString data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.aiplatform.v1beta1.FeatureView.VectorSearchConfig parseFrom(
        com.google.protobuf.ByteString data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.aiplatform.v1beta1.FeatureView.VectorSearchConfig parseFrom(
        byte[] data) throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.aiplatform.v1beta1.FeatureView.VectorSearchConfig parseFrom(
        byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.aiplatform.v1beta1.FeatureView.VectorSearchConfig parseFrom(
        java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.cloud.aiplatform.v1beta1.FeatureView.VectorSearchConfig parseFrom(
        java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.cloud.aiplatform.v1beta1.FeatureView.VectorSearchConfig
        parseDelimitedFrom(java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
    }

    public static com.google.cloud.aiplatform.v1beta1.FeatureView.VectorSearchConfig
        parseDelimitedFrom(
            java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.cloud.aiplatform.v1beta1.FeatureView.VectorSearchConfig parseFrom(
        com.google.protobuf.CodedInputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.cloud.aiplatform.v1beta1.FeatureView.VectorSearchConfig parseFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    @java.lang.Override
    public Builder newBuilderForType() {
      return newBuilder();
    }

    public static Builder newBuilder() {
      return DEFAULT_INSTANCE.toBuilder();
    }

    public static Builder newBuilder(
        com.google.cloud.aiplatform.v1beta1.FeatureView.VectorSearchConfig prototype) {
      return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }

    @java.lang.Override
    public Builder toBuilder() {
      return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
    }

    @java.lang.Override
    protected Builder newBuilderForType(
        com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      Builder builder = new Builder(parent);
      return builder;
    }
    /**
     *
     *
     * <pre>
     * Configuration for vector search.
     * </pre>
     *
     * Protobuf type {@code google.cloud.aiplatform.v1beta1.FeatureView.VectorSearchConfig}
     */
    public static final class Builder
        extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
        implements
        // @@protoc_insertion_point(builder_implements:google.cloud.aiplatform.v1beta1.FeatureView.VectorSearchConfig)
        com.google.cloud.aiplatform.v1beta1.FeatureView.VectorSearchConfigOrBuilder {
      public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
        return com.google.cloud.aiplatform.v1beta1.FeatureViewProto
            .internal_static_google_cloud_aiplatform_v1beta1_FeatureView_VectorSearchConfig_descriptor;
      }

      @java.lang.Override
      protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return com.google.cloud.aiplatform.v1beta1.FeatureViewProto
            .internal_static_google_cloud_aiplatform_v1beta1_FeatureView_VectorSearchConfig_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                com.google.cloud.aiplatform.v1beta1.FeatureView.VectorSearchConfig.class,
                com.google.cloud.aiplatform.v1beta1.FeatureView.VectorSearchConfig.Builder.class);
      }

      // Construct using
      // com.google.cloud.aiplatform.v1beta1.FeatureView.VectorSearchConfig.newBuilder()
      private Builder() {}

      private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
        super(parent);
      }

      @java.lang.Override
      public Builder clear() {
        super.clear();
        bitField0_ = 0;
        if (treeAhConfigBuilder_ != null) {
          treeAhConfigBuilder_.clear();
        }
        if (bruteForceConfigBuilder_ != null) {
          bruteForceConfigBuilder_.clear();
        }
        embeddingColumn_ = "";
        filterColumns_ = com.google.protobuf.LazyStringArrayList.emptyList();
        crowdingColumn_ = "";
        embeddingDimension_ = 0;
        distanceMeasureType_ = 0;
        algorithmConfigCase_ = 0;
        algorithmConfig_ = null;
        return this;
      }

      @java.lang.Override
      public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
        return com.google.cloud.aiplatform.v1beta1.FeatureViewProto
            .internal_static_google_cloud_aiplatform_v1beta1_FeatureView_VectorSearchConfig_descriptor;
      }

      @java.lang.Override
      public com.google.cloud.aiplatform.v1beta1.FeatureView.VectorSearchConfig
          getDefaultInstanceForType() {
        return com.google.cloud.aiplatform.v1beta1.FeatureView.VectorSearchConfig
            .getDefaultInstance();
      }

      @java.lang.Override
      public com.google.cloud.aiplatform.v1beta1.FeatureView.VectorSearchConfig build() {
        com.google.cloud.aiplatform.v1beta1.FeatureView.VectorSearchConfig result = buildPartial();
        if (!result.isInitialized()) {
          throw newUninitializedMessageException(result);
        }
        return result;
      }

      @java.lang.Override
      public com.google.cloud.aiplatform.v1beta1.FeatureView.VectorSearchConfig buildPartial() {
        com.google.cloud.aiplatform.v1beta1.FeatureView.VectorSearchConfig result =
            new com.google.cloud.aiplatform.v1beta1.FeatureView.VectorSearchConfig(this);
        if (bitField0_ != 0) {
          buildPartial0(result);
        }
        buildPartialOneofs(result);
        onBuilt();
        return result;
      }

      private void buildPartial0(
          com.google.cloud.aiplatform.v1beta1.FeatureView.VectorSearchConfig result) {
        int from_bitField0_ = bitField0_;
        if (((from_bitField0_ & 0x00000004) != 0)) {
          result.embeddingColumn_ = embeddingColumn_;
        }
        if (((from_bitField0_ & 0x00000008) != 0)) {
          filterColumns_.makeImmutable();
          result.filterColumns_ = filterColumns_;
        }
        if (((from_bitField0_ & 0x00000010) != 0)) {
          result.crowdingColumn_ = crowdingColumn_;
        }
        int to_bitField0_ = 0;
        if (((from_bitField0_ & 0x00000020) != 0)) {
          result.embeddingDimension_ = embeddingDimension_;
          to_bitField0_ |= 0x00000001;
        }
        if (((from_bitField0_ & 0x00000040) != 0)) {
          result.distanceMeasureType_ = distanceMeasureType_;
        }
        result.bitField0_ |= to_bitField0_;
      }

      private void buildPartialOneofs(
          com.google.cloud.aiplatform.v1beta1.FeatureView.VectorSearchConfig result) {
        result.algorithmConfigCase_ = algorithmConfigCase_;
        result.algorithmConfig_ = this.algorithmConfig_;
        if (algorithmConfigCase_ == 8 && treeAhConfigBuilder_ != null) {
          result.algorithmConfig_ = treeAhConfigBuilder_.build();
        }
        if (algorithmConfigCase_ == 9 && bruteForceConfigBuilder_ != null) {
          result.algorithmConfig_ = bruteForceConfigBuilder_.build();
        }
      }

      @java.lang.Override
      public Builder clone() {
        return super.clone();
      }

      @java.lang.Override
      public Builder setField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.setField(field, value);
      }

      @java.lang.Override
      public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
        return super.clearField(field);
      }

      @java.lang.Override
      public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
        return super.clearOneof(oneof);
      }

      @java.lang.Override
      public Builder setRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          int index,
          java.lang.Object value) {
        return super.setRepeatedField(field, index, value);
      }

      @java.lang.Override
      public Builder addRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.addRepeatedField(field, value);
      }

      @java.lang.Override
      public Builder mergeFrom(com.google.protobuf.Message other) {
        if (other instanceof com.google.cloud.aiplatform.v1beta1.FeatureView.VectorSearchConfig) {
          return mergeFrom(
              (com.google.cloud.aiplatform.v1beta1.FeatureView.VectorSearchConfig) other);
        } else {
          super.mergeFrom(other);
          return this;
        }
      }

      public Builder mergeFrom(
          com.google.cloud.aiplatform.v1beta1.FeatureView.VectorSearchConfig other) {
        if (other
            == com.google.cloud.aiplatform.v1beta1.FeatureView.VectorSearchConfig
                .getDefaultInstance()) return this;
        if (!other.getEmbeddingColumn().isEmpty()) {
          embeddingColumn_ = other.embeddingColumn_;
          bitField0_ |= 0x00000004;
          onChanged();
        }
        if (!other.filterColumns_.isEmpty()) {
          if (filterColumns_.isEmpty()) {
            filterColumns_ = other.filterColumns_;
            bitField0_ |= 0x00000008;
          } else {
            ensureFilterColumnsIsMutable();
            filterColumns_.addAll(other.filterColumns_);
          }
          onChanged();
        }
        if (!other.getCrowdingColumn().isEmpty()) {
          crowdingColumn_ = other.crowdingColumn_;
          bitField0_ |= 0x00000010;
          onChanged();
        }
        if (other.hasEmbeddingDimension()) {
          setEmbeddingDimension(other.getEmbeddingDimension());
        }
        if (other.distanceMeasureType_ != 0) {
          setDistanceMeasureTypeValue(other.getDistanceMeasureTypeValue());
        }
        switch (other.getAlgorithmConfigCase()) {
          case TREE_AH_CONFIG:
            {
              mergeTreeAhConfig(other.getTreeAhConfig());
              break;
            }
          case BRUTE_FORCE_CONFIG:
            {
              mergeBruteForceConfig(other.getBruteForceConfig());
              break;
            }
          case ALGORITHMCONFIG_NOT_SET:
            {
              break;
            }
        }
        this.mergeUnknownFields(other.getUnknownFields());
        onChanged();
        return this;
      }

      @java.lang.Override
      public final boolean isInitialized() {
        return true;
      }

      @java.lang.Override
      public Builder mergeFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        if (extensionRegistry == null) {
          throw new java.lang.NullPointerException();
        }
        try {
          boolean done = false;
          while (!done) {
            int tag = input.readTag();
            switch (tag) {
              case 0:
                done = true;
                break;
              case 26:
                {
                  embeddingColumn_ = input.readStringRequireUtf8();
                  bitField0_ |= 0x00000004;
                  break;
                } // case 26
              case 34:
                {
                  java.lang.String s = input.readStringRequireUtf8();
                  ensureFilterColumnsIsMutable();
                  filterColumns_.add(s);
                  break;
                } // case 34
              case 42:
                {
                  crowdingColumn_ = input.readStringRequireUtf8();
                  bitField0_ |= 0x00000010;
                  break;
                } // case 42
              case 48:
                {
                  embeddingDimension_ = input.readInt32();
                  bitField0_ |= 0x00000020;
                  break;
                } // case 48
              case 56:
                {
                  distanceMeasureType_ = input.readEnum();
                  bitField0_ |= 0x00000040;
                  break;
                } // case 56
              case 66:
                {
                  input.readMessage(getTreeAhConfigFieldBuilder().getBuilder(), extensionRegistry);
                  algorithmConfigCase_ = 8;
                  break;
                } // case 66
              case 74:
                {
                  input.readMessage(
                      getBruteForceConfigFieldBuilder().getBuilder(), extensionRegistry);
                  algorithmConfigCase_ = 9;
                  break;
                } // case 74
              default:
                {
                  if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                    done = true; // was an endgroup tag
                  }
                  break;
                } // default:
            } // switch (tag)
          } // while (!done)
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          throw e.unwrapIOException();
        } finally {
          onChanged();
        } // finally
        return this;
      }

      private int algorithmConfigCase_ = 0;
      private java.lang.Object algorithmConfig_;

      public AlgorithmConfigCase getAlgorithmConfigCase() {
        return AlgorithmConfigCase.forNumber(algorithmConfigCase_);
      }

      public Builder clearAlgorithmConfig() {
        algorithmConfigCase_ = 0;
        algorithmConfig_ = null;
        onChanged();
        return this;
      }

      private int bitField0_;

      private com.google.protobuf.SingleFieldBuilderV3<
              com.google.cloud.aiplatform.v1beta1.FeatureView.VectorSearchConfig.TreeAHConfig,
              com.google.cloud.aiplatform.v1beta1.FeatureView.VectorSearchConfig.TreeAHConfig
                  .Builder,
              com.google.cloud.aiplatform.v1beta1.FeatureView.VectorSearchConfig
                  .TreeAHConfigOrBuilder>
          treeAhConfigBuilder_;
      /**
       *
       *
       * <pre>
       * Optional. Configuration options for the tree-AH algorithm (Shallow tree
       * + Asymmetric Hashing). Please refer to this paper for more details:
       * https://arxiv.org/abs/1908.10396
       * </pre>
       *
       * <code>
       * .google.cloud.aiplatform.v1beta1.FeatureView.VectorSearchConfig.TreeAHConfig tree_ah_config = 8 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       *
       * @return Whether the treeAhConfig field is set.
       */
      @java.lang.Override
      public boolean hasTreeAhConfig() {
        return algorithmConfigCase_ == 8;
      }
      /**
       *
       *
       * <pre>
       * Optional. Configuration options for the tree-AH algorithm (Shallow tree
       * + Asymmetric Hashing). Please refer to this paper for more details:
       * https://arxiv.org/abs/1908.10396
       * </pre>
       *
       * <code>
       * .google.cloud.aiplatform.v1beta1.FeatureView.VectorSearchConfig.TreeAHConfig tree_ah_config = 8 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       *
       * @return The treeAhConfig.
       */
      @java.lang.Override
      public com.google.cloud.aiplatform.v1beta1.FeatureView.VectorSearchConfig.TreeAHConfig
          getTreeAhConfig() {
        if (treeAhConfigBuilder_ == null) {
          if (algorithmConfigCase_ == 8) {
            return (com.google.cloud.aiplatform.v1beta1.FeatureView.VectorSearchConfig.TreeAHConfig)
                algorithmConfig_;
          }
          return com.google.cloud.aiplatform.v1beta1.FeatureView.VectorSearchConfig.TreeAHConfig
              .getDefaultInstance();
        } else {
          if (algorithmConfigCase_ == 8) {
            return treeAhConfigBuilder_.getMessage();
          }
          return com.google.cloud.aiplatform.v1beta1.FeatureView.VectorSearchConfig.TreeAHConfig
              .getDefaultInstance();
        }
      }
      /**
       *
       *
       * <pre>
       * Optional. Configuration options for the tree-AH algorithm (Shallow tree
       * + Asymmetric Hashing). Please refer to this paper for more details:
       * https://arxiv.org/abs/1908.10396
       * </pre>
       *
       * <code>
       * .google.cloud.aiplatform.v1beta1.FeatureView.VectorSearchConfig.TreeAHConfig tree_ah_config = 8 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       */
      public Builder setTreeAhConfig(
          com.google.cloud.aiplatform.v1beta1.FeatureView.VectorSearchConfig.TreeAHConfig value) {
        if (treeAhConfigBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          algorithmConfig_ = value;
          onChanged();
        } else {
          treeAhConfigBuilder_.setMessage(value);
        }
        algorithmConfigCase_ = 8;
        return this;
      }
      /**
       *
       *
       * <pre>
       * Optional. Configuration options for the tree-AH algorithm (Shallow tree
       * + Asymmetric Hashing). Please refer to this paper for more details:
       * https://arxiv.org/abs/1908.10396
       * </pre>
       *
       * <code>
       * .google.cloud.aiplatform.v1beta1.FeatureView.VectorSearchConfig.TreeAHConfig tree_ah_config = 8 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       */
      public Builder setTreeAhConfig(
          com.google.cloud.aiplatform.v1beta1.FeatureView.VectorSearchConfig.TreeAHConfig.Builder
              builderForValue) {
        if (treeAhConfigBuilder_ == null) {
          algorithmConfig_ = builderForValue.build();
          onChanged();
        } else {
          treeAhConfigBuilder_.setMessage(builderForValue.build());
        }
        algorithmConfigCase_ = 8;
        return this;
      }
      /**
       *
       *
       * <pre>
       * Optional. Configuration options for the tree-AH algorithm (Shallow tree
       * + Asymmetric Hashing). Please refer to this paper for more details:
       * https://arxiv.org/abs/1908.10396
       * </pre>
       *
       * <code>
       * .google.cloud.aiplatform.v1beta1.FeatureView.VectorSearchConfig.TreeAHConfig tree_ah_config = 8 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       */
      public Builder mergeTreeAhConfig(
          com.google.cloud.aiplatform.v1beta1.FeatureView.VectorSearchConfig.TreeAHConfig value) {
        if (treeAhConfigBuilder_ == null) {
          if (algorithmConfigCase_ == 8
              && algorithmConfig_
                  != com.google.cloud.aiplatform.v1beta1.FeatureView.VectorSearchConfig.TreeAHConfig
                      .getDefaultInstance()) {
            algorithmConfig_ =
                com.google.cloud.aiplatform.v1beta1.FeatureView.VectorSearchConfig.TreeAHConfig
                    .newBuilder(
                        (com.google.cloud.aiplatform.v1beta1.FeatureView.VectorSearchConfig
                                .TreeAHConfig)
                            algorithmConfig_)
                    .mergeFrom(value)
                    .buildPartial();
          } else {
            algorithmConfig_ = value;
          }
          onChanged();
        } else {
          if (algorithmConfigCase_ == 8) {
            treeAhConfigBuilder_.mergeFrom(value);
          } else {
            treeAhConfigBuilder_.setMessage(value);
          }
        }
        algorithmConfigCase_ = 8;
        return this;
      }
      /**
       *
       *
       * <pre>
       * Optional. Configuration options for the tree-AH algorithm (Shallow tree
       * + Asymmetric Hashing). Please refer to this paper for more details:
       * https://arxiv.org/abs/1908.10396
       * </pre>
       *
       * <code>
       * .google.cloud.aiplatform.v1beta1.FeatureView.VectorSearchConfig.TreeAHConfig tree_ah_config = 8 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       */
      public Builder clearTreeAhConfig() {
        if (treeAhConfigBuilder_ == null) {
          if (algorithmConfigCase_ == 8) {
            algorithmConfigCase_ = 0;
            algorithmConfig_ = null;
            onChanged();
          }
        } else {
          if (algorithmConfigCase_ == 8) {
            algorithmConfigCase_ = 0;
            algorithmConfig_ = null;
          }
          treeAhConfigBuilder_.clear();
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * Optional. Configuration options for the tree-AH algorithm (Shallow tree
       * + Asymmetric Hashing). Please refer to this paper for more details:
       * https://arxiv.org/abs/1908.10396
       * </pre>
       *
       * <code>
       * .google.cloud.aiplatform.v1beta1.FeatureView.VectorSearchConfig.TreeAHConfig tree_ah_config = 8 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       */
      public com.google.cloud.aiplatform.v1beta1.FeatureView.VectorSearchConfig.TreeAHConfig.Builder
          getTreeAhConfigBuilder() {
        return getTreeAhConfigFieldBuilder().getBuilder();
      }
      /**
       *
       *
       * <pre>
       * Optional. Configuration options for the tree-AH algorithm (Shallow tree
       * + Asymmetric Hashing). Please refer to this paper for more details:
       * https://arxiv.org/abs/1908.10396
       * </pre>
       *
       * <code>
       * .google.cloud.aiplatform.v1beta1.FeatureView.VectorSearchConfig.TreeAHConfig tree_ah_config = 8 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       */
      @java.lang.Override
      public com.google.cloud.aiplatform.v1beta1.FeatureView.VectorSearchConfig
              .TreeAHConfigOrBuilder
          getTreeAhConfigOrBuilder() {
        if ((algorithmConfigCase_ == 8) && (treeAhConfigBuilder_ != null)) {
          return treeAhConfigBuilder_.getMessageOrBuilder();
        } else {
          if (algorithmConfigCase_ == 8) {
            return (com.google.cloud.aiplatform.v1beta1.FeatureView.VectorSearchConfig.TreeAHConfig)
                algorithmConfig_;
          }
          return com.google.cloud.aiplatform.v1beta1.FeatureView.VectorSearchConfig.TreeAHConfig
              .getDefaultInstance();
        }
      }
      /**
       *
       *
       * <pre>
       * Optional. Configuration options for the tree-AH algorithm (Shallow tree
       * + Asymmetric Hashing). Please refer to this paper for more details:
       * https://arxiv.org/abs/1908.10396
       * </pre>
       *
       * <code>
       * .google.cloud.aiplatform.v1beta1.FeatureView.VectorSearchConfig.TreeAHConfig tree_ah_config = 8 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       */
      private com.google.protobuf.SingleFieldBuilderV3<
              com.google.cloud.aiplatform.v1beta1.FeatureView.VectorSearchConfig.TreeAHConfig,
              com.google.cloud.aiplatform.v1beta1.FeatureView.VectorSearchConfig.TreeAHConfig
                  .Builder,
              com.google.cloud.aiplatform.v1beta1.FeatureView.VectorSearchConfig
                  .TreeAHConfigOrBuilder>
          getTreeAhConfigFieldBuilder() {
        if (treeAhConfigBuilder_ == null) {
          if (!(algorithmConfigCase_ == 8)) {
            algorithmConfig_ =
                com.google.cloud.aiplatform.v1beta1.FeatureView.VectorSearchConfig.TreeAHConfig
                    .getDefaultInstance();
          }
          treeAhConfigBuilder_ =
              new com.google.protobuf.SingleFieldBuilderV3<
                  com.google.cloud.aiplatform.v1beta1.FeatureView.VectorSearchConfig.TreeAHConfig,
                  com.google.cloud.aiplatform.v1beta1.FeatureView.VectorSearchConfig.TreeAHConfig
                      .Builder,
                  com.google.cloud.aiplatform.v1beta1.FeatureView.VectorSearchConfig
                      .TreeAHConfigOrBuilder>(
                  (com.google.cloud.aiplatform.v1beta1.FeatureView.VectorSearchConfig.TreeAHConfig)
                      algorithmConfig_,
                  getParentForChildren(),
                  isClean());
          algorithmConfig_ = null;
        }
        algorithmConfigCase_ = 8;
        onChanged();
        return treeAhConfigBuilder_;
      }

      private com.google.protobuf.SingleFieldBuilderV3<
              com.google.cloud.aiplatform.v1beta1.FeatureView.VectorSearchConfig.BruteForceConfig,
              com.google.cloud.aiplatform.v1beta1.FeatureView.VectorSearchConfig.BruteForceConfig
                  .Builder,
              com.google.cloud.aiplatform.v1beta1.FeatureView.VectorSearchConfig
                  .BruteForceConfigOrBuilder>
          bruteForceConfigBuilder_;
      /**
       *
       *
       * <pre>
       * Optional. Configuration options for using brute force search, which
       * simply implements the standard linear search in the database for each
       * query. It is primarily meant for benchmarking and to generate the
       * ground truth for approximate search.
       * </pre>
       *
       * <code>
       * .google.cloud.aiplatform.v1beta1.FeatureView.VectorSearchConfig.BruteForceConfig brute_force_config = 9 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       *
       * @return Whether the bruteForceConfig field is set.
       */
      @java.lang.Override
      public boolean hasBruteForceConfig() {
        return algorithmConfigCase_ == 9;
      }
      /**
       *
       *
       * <pre>
       * Optional. Configuration options for using brute force search, which
       * simply implements the standard linear search in the database for each
       * query. It is primarily meant for benchmarking and to generate the
       * ground truth for approximate search.
       * </pre>
       *
       * <code>
       * .google.cloud.aiplatform.v1beta1.FeatureView.VectorSearchConfig.BruteForceConfig brute_force_config = 9 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       *
       * @return The bruteForceConfig.
       */
      @java.lang.Override
      public com.google.cloud.aiplatform.v1beta1.FeatureView.VectorSearchConfig.BruteForceConfig
          getBruteForceConfig() {
        if (bruteForceConfigBuilder_ == null) {
          if (algorithmConfigCase_ == 9) {
            return (com.google.cloud.aiplatform.v1beta1.FeatureView.VectorSearchConfig
                    .BruteForceConfig)
                algorithmConfig_;
          }
          return com.google.cloud.aiplatform.v1beta1.FeatureView.VectorSearchConfig.BruteForceConfig
              .getDefaultInstance();
        } else {
          if (algorithmConfigCase_ == 9) {
            return bruteForceConfigBuilder_.getMessage();
          }
          return com.google.cloud.aiplatform.v1beta1.FeatureView.VectorSearchConfig.BruteForceConfig
              .getDefaultInstance();
        }
      }
      /**
       *
       *
       * <pre>
       * Optional. Configuration options for using brute force search, which
       * simply implements the standard linear search in the database for each
       * query. It is primarily meant for benchmarking and to generate the
       * ground truth for approximate search.
       * </pre>
       *
       * <code>
       * .google.cloud.aiplatform.v1beta1.FeatureView.VectorSearchConfig.BruteForceConfig brute_force_config = 9 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       */
      public Builder setBruteForceConfig(
          com.google.cloud.aiplatform.v1beta1.FeatureView.VectorSearchConfig.BruteForceConfig
              value) {
        if (bruteForceConfigBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          algorithmConfig_ = value;
          onChanged();
        } else {
          bruteForceConfigBuilder_.setMessage(value);
        }
        algorithmConfigCase_ = 9;
        return this;
      }
      /**
       *
       *
       * <pre>
       * Optional. Configuration options for using brute force search, which
       * simply implements the standard linear search in the database for each
       * query. It is primarily meant for benchmarking and to generate the
       * ground truth for approximate search.
       * </pre>
       *
       * <code>
       * .google.cloud.aiplatform.v1beta1.FeatureView.VectorSearchConfig.BruteForceConfig brute_force_config = 9 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       */
      public Builder setBruteForceConfig(
          com.google.cloud.aiplatform.v1beta1.FeatureView.VectorSearchConfig.BruteForceConfig
                  .Builder
              builderForValue) {
        if (bruteForceConfigBuilder_ == null) {
          algorithmConfig_ = builderForValue.build();
          onChanged();
        } else {
          bruteForceConfigBuilder_.setMessage(builderForValue.build());
        }
        algorithmConfigCase_ = 9;
        return this;
      }
      /**
       *
       *
       * <pre>
       * Optional. Configuration options for using brute force search, which
       * simply implements the standard linear search in the database for each
       * query. It is primarily meant for benchmarking and to generate the
       * ground truth for approximate search.
       * </pre>
       *
       * <code>
       * .google.cloud.aiplatform.v1beta1.FeatureView.VectorSearchConfig.BruteForceConfig brute_force_config = 9 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       */
      public Builder mergeBruteForceConfig(
          com.google.cloud.aiplatform.v1beta1.FeatureView.VectorSearchConfig.BruteForceConfig
              value) {
        if (bruteForceConfigBuilder_ == null) {
          if (algorithmConfigCase_ == 9
              && algorithmConfig_
                  != com.google.cloud.aiplatform.v1beta1.FeatureView.VectorSearchConfig
                      .BruteForceConfig.getDefaultInstance()) {
            algorithmConfig_ =
                com.google.cloud.aiplatform.v1beta1.FeatureView.VectorSearchConfig.BruteForceConfig
                    .newBuilder(
                        (com.google.cloud.aiplatform.v1beta1.FeatureView.VectorSearchConfig
                                .BruteForceConfig)
                            algorithmConfig_)
                    .mergeFrom(value)
                    .buildPartial();
          } else {
            algorithmConfig_ = value;
          }
          onChanged();
        } else {
          if (algorithmConfigCase_ == 9) {
            bruteForceConfigBuilder_.mergeFrom(value);
          } else {
            bruteForceConfigBuilder_.setMessage(value);
          }
        }
        algorithmConfigCase_ = 9;
        return this;
      }
      /**
       *
       *
       * <pre>
       * Optional. Configuration options for using brute force search, which
       * simply implements the standard linear search in the database for each
       * query. It is primarily meant for benchmarking and to generate the
       * ground truth for approximate search.
       * </pre>
       *
       * <code>
       * .google.cloud.aiplatform.v1beta1.FeatureView.VectorSearchConfig.BruteForceConfig brute_force_config = 9 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       */
      public Builder clearBruteForceConfig() {
        if (bruteForceConfigBuilder_ == null) {
          if (algorithmConfigCase_ == 9) {
            algorithmConfigCase_ = 0;
            algorithmConfig_ = null;
            onChanged();
          }
        } else {
          if (algorithmConfigCase_ == 9) {
            algorithmConfigCase_ = 0;
            algorithmConfig_ = null;
          }
          bruteForceConfigBuilder_.clear();
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * Optional. Configuration options for using brute force search, which
       * simply implements the standard linear search in the database for each
       * query. It is primarily meant for benchmarking and to generate the
       * ground truth for approximate search.
       * </pre>
       *
       * <code>
       * .google.cloud.aiplatform.v1beta1.FeatureView.VectorSearchConfig.BruteForceConfig brute_force_config = 9 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       */
      public com.google.cloud.aiplatform.v1beta1.FeatureView.VectorSearchConfig.BruteForceConfig
              .Builder
          getBruteForceConfigBuilder() {
        return getBruteForceConfigFieldBuilder().getBuilder();
      }
      /**
       *
       *
       * <pre>
       * Optional. Configuration options for using brute force search, which
       * simply implements the standard linear search in the database for each
       * query. It is primarily meant for benchmarking and to generate the
       * ground truth for approximate search.
       * </pre>
       *
       * <code>
       * .google.cloud.aiplatform.v1beta1.FeatureView.VectorSearchConfig.BruteForceConfig brute_force_config = 9 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       */
      @java.lang.Override
      public com.google.cloud.aiplatform.v1beta1.FeatureView.VectorSearchConfig
              .BruteForceConfigOrBuilder
          getBruteForceConfigOrBuilder() {
        if ((algorithmConfigCase_ == 9) && (bruteForceConfigBuilder_ != null)) {
          return bruteForceConfigBuilder_.getMessageOrBuilder();
        } else {
          if (algorithmConfigCase_ == 9) {
            return (com.google.cloud.aiplatform.v1beta1.FeatureView.VectorSearchConfig
                    .BruteForceConfig)
                algorithmConfig_;
          }
          return com.google.cloud.aiplatform.v1beta1.FeatureView.VectorSearchConfig.BruteForceConfig
              .getDefaultInstance();
        }
      }
      /**
       *
       *
       * <pre>
       * Optional. Configuration options for using brute force search, which
       * simply implements the standard linear search in the database for each
       * query. It is primarily meant for benchmarking and to generate the
       * ground truth for approximate search.
       * </pre>
       *
       * <code>
       * .google.cloud.aiplatform.v1beta1.FeatureView.VectorSearchConfig.BruteForceConfig brute_force_config = 9 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       */
      private com.google.protobuf.SingleFieldBuilderV3<
              com.google.cloud.aiplatform.v1beta1.FeatureView.VectorSearchConfig.BruteForceConfig,
              com.google.cloud.aiplatform.v1beta1.FeatureView.VectorSearchConfig.BruteForceConfig
                  .Builder,
              com.google.cloud.aiplatform.v1beta1.FeatureView.VectorSearchConfig
                  .BruteForceConfigOrBuilder>
          getBruteForceConfigFieldBuilder() {
        if (bruteForceConfigBuilder_ == null) {
          if (!(algorithmConfigCase_ == 9)) {
            algorithmConfig_ =
                com.google.cloud.aiplatform.v1beta1.FeatureView.VectorSearchConfig.BruteForceConfig
                    .getDefaultInstance();
          }
          bruteForceConfigBuilder_ =
              new com.google.protobuf.SingleFieldBuilderV3<
                  com.google.cloud.aiplatform.v1beta1.FeatureView.VectorSearchConfig
                      .BruteForceConfig,
                  com.google.cloud.aiplatform.v1beta1.FeatureView.VectorSearchConfig
                      .BruteForceConfig.Builder,
                  com.google.cloud.aiplatform.v1beta1.FeatureView.VectorSearchConfig
                      .BruteForceConfigOrBuilder>(
                  (com.google.cloud.aiplatform.v1beta1.FeatureView.VectorSearchConfig
                          .BruteForceConfig)
                      algorithmConfig_,
                  getParentForChildren(),
                  isClean());
          algorithmConfig_ = null;
        }
        algorithmConfigCase_ = 9;
        onChanged();
        return bruteForceConfigBuilder_;
      }

      private java.lang.Object embeddingColumn_ = "";
      /**
       *
       *
       * <pre>
       * Optional. Column of embedding. This column contains the source data to
       * create index for vector search. embedding_column must be set when using
       * vector search.
       * </pre>
       *
       * <code>string embedding_column = 3 [(.google.api.field_behavior) = OPTIONAL];</code>
       *
       * @return The embeddingColumn.
       */
      public java.lang.String getEmbeddingColumn() {
        java.lang.Object ref = embeddingColumn_;
        if (!(ref instanceof java.lang.String)) {
          com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
          java.lang.String s = bs.toStringUtf8();
          embeddingColumn_ = s;
          return s;
        } else {
          return (java.lang.String) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * Optional. Column of embedding. This column contains the source data to
       * create index for vector search. embedding_column must be set when using
       * vector search.
       * </pre>
       *
       * <code>string embedding_column = 3 [(.google.api.field_behavior) = OPTIONAL];</code>
       *
       * @return The bytes for embeddingColumn.
       */
      public com.google.protobuf.ByteString getEmbeddingColumnBytes() {
        java.lang.Object ref = embeddingColumn_;
        if (ref instanceof String) {
          com.google.protobuf.ByteString b =
              com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
          embeddingColumn_ = b;
          return b;
        } else {
          return (com.google.protobuf.ByteString) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * Optional. Column of embedding. This column contains the source data to
       * create index for vector search. embedding_column must be set when using
       * vector search.
       * </pre>
       *
       * <code>string embedding_column = 3 [(.google.api.field_behavior) = OPTIONAL];</code>
       *
       * @param value The embeddingColumn to set.
       * @return This builder for chaining.
       */
      public Builder setEmbeddingColumn(java.lang.String value) {
        if (value == null) {
          throw new NullPointerException();
        }
        embeddingColumn_ = value;
        bitField0_ |= 0x00000004;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Optional. Column of embedding. This column contains the source data to
       * create index for vector search. embedding_column must be set when using
       * vector search.
       * </pre>
       *
       * <code>string embedding_column = 3 [(.google.api.field_behavior) = OPTIONAL];</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearEmbeddingColumn() {
        embeddingColumn_ = getDefaultInstance().getEmbeddingColumn();
        bitField0_ = (bitField0_ & ~0x00000004);
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Optional. Column of embedding. This column contains the source data to
       * create index for vector search. embedding_column must be set when using
       * vector search.
       * </pre>
       *
       * <code>string embedding_column = 3 [(.google.api.field_behavior) = OPTIONAL];</code>
       *
       * @param value The bytes for embeddingColumn to set.
       * @return This builder for chaining.
       */
      public Builder setEmbeddingColumnBytes(com.google.protobuf.ByteString value) {
        if (value == null) {
          throw new NullPointerException();
        }
        checkByteStringIsUtf8(value);
        embeddingColumn_ = value;
        bitField0_ |= 0x00000004;
        onChanged();
        return this;
      }

      private com.google.protobuf.LazyStringArrayList filterColumns_ =
          com.google.protobuf.LazyStringArrayList.emptyList();

      private void ensureFilterColumnsIsMutable() {
        if (!filterColumns_.isModifiable()) {
          filterColumns_ = new com.google.protobuf.LazyStringArrayList(filterColumns_);
        }
        bitField0_ |= 0x00000008;
      }
      /**
       *
       *
       * <pre>
       * Optional. Columns of features that're used to filter vector search
       * results.
       * </pre>
       *
       * <code>repeated string filter_columns = 4 [(.google.api.field_behavior) = OPTIONAL];</code>
       *
       * @return A list containing the filterColumns.
       */
      public com.google.protobuf.ProtocolStringList getFilterColumnsList() {
        filterColumns_.makeImmutable();
        return filterColumns_;
      }
      /**
       *
       *
       * <pre>
       * Optional. Columns of features that're used to filter vector search
       * results.
       * </pre>
       *
       * <code>repeated string filter_columns = 4 [(.google.api.field_behavior) = OPTIONAL];</code>
       *
       * @return The count of filterColumns.
       */
      public int getFilterColumnsCount() {
        return filterColumns_.size();
      }
      /**
       *
       *
       * <pre>
       * Optional. Columns of features that're used to filter vector search
       * results.
       * </pre>
       *
       * <code>repeated string filter_columns = 4 [(.google.api.field_behavior) = OPTIONAL];</code>
       *
       * @param index The index of the element to return.
       * @return The filterColumns at the given index.
       */
      public java.lang.String getFilterColumns(int index) {
        return filterColumns_.get(index);
      }
      /**
       *
       *
       * <pre>
       * Optional. Columns of features that're used to filter vector search
       * results.
       * </pre>
       *
       * <code>repeated string filter_columns = 4 [(.google.api.field_behavior) = OPTIONAL];</code>
       *
       * @param index The index of the value to return.
       * @return The bytes of the filterColumns at the given index.
       */
      public com.google.protobuf.ByteString getFilterColumnsBytes(int index) {
        return filterColumns_.getByteString(index);
      }
      /**
       *
       *
       * <pre>
       * Optional. Columns of features that're used to filter vector search
       * results.
       * </pre>
       *
       * <code>repeated string filter_columns = 4 [(.google.api.field_behavior) = OPTIONAL];</code>
       *
       * @param index The index to set the value at.
       * @param value The filterColumns to set.
       * @return This builder for chaining.
       */
      public Builder setFilterColumns(int index, java.lang.String value) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureFilterColumnsIsMutable();
        filterColumns_.set(index, value);
        bitField0_ |= 0x00000008;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Optional. Columns of features that're used to filter vector search
       * results.
       * </pre>
       *
       * <code>repeated string filter_columns = 4 [(.google.api.field_behavior) = OPTIONAL];</code>
       *
       * @param value The filterColumns to add.
       * @return This builder for chaining.
       */
      public Builder addFilterColumns(java.lang.String value) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureFilterColumnsIsMutable();
        filterColumns_.add(value);
        bitField0_ |= 0x00000008;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Optional. Columns of features that're used to filter vector search
       * results.
       * </pre>
       *
       * <code>repeated string filter_columns = 4 [(.google.api.field_behavior) = OPTIONAL];</code>
       *
       * @param values The filterColumns to add.
       * @return This builder for chaining.
       */
      public Builder addAllFilterColumns(java.lang.Iterable<java.lang.String> values) {
        ensureFilterColumnsIsMutable();
        com.google.protobuf.AbstractMessageLite.Builder.addAll(values, filterColumns_);
        bitField0_ |= 0x00000008;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Optional. Columns of features that're used to filter vector search
       * results.
       * </pre>
       *
       * <code>repeated string filter_columns = 4 [(.google.api.field_behavior) = OPTIONAL];</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearFilterColumns() {
        filterColumns_ = com.google.protobuf.LazyStringArrayList.emptyList();
        bitField0_ = (bitField0_ & ~0x00000008);
        ;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Optional. Columns of features that're used to filter vector search
       * results.
       * </pre>
       *
       * <code>repeated string filter_columns = 4 [(.google.api.field_behavior) = OPTIONAL];</code>
       *
       * @param value The bytes of the filterColumns to add.
       * @return This builder for chaining.
       */
      public Builder addFilterColumnsBytes(com.google.protobuf.ByteString value) {
        if (value == null) {
          throw new NullPointerException();
        }
        checkByteStringIsUtf8(value);
        ensureFilterColumnsIsMutable();
        filterColumns_.add(value);
        bitField0_ |= 0x00000008;
        onChanged();
        return this;
      }

      private java.lang.Object crowdingColumn_ = "";
      /**
       *
       *
       * <pre>
       * Optional. Column of crowding. This column contains crowding attribute
       * which is a constraint on a neighbor list produced by nearest neighbor
       * search requiring that no more than some value k' of the k neighbors
       * returned have the same value of crowding_attribute.
       * </pre>
       *
       * <code>string crowding_column = 5 [(.google.api.field_behavior) = OPTIONAL];</code>
       *
       * @return The crowdingColumn.
       */
      public java.lang.String getCrowdingColumn() {
        java.lang.Object ref = crowdingColumn_;
        if (!(ref instanceof java.lang.String)) {
          com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
          java.lang.String s = bs.toStringUtf8();
          crowdingColumn_ = s;
          return s;
        } else {
          return (java.lang.String) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * Optional. Column of crowding. This column contains crowding attribute
       * which is a constraint on a neighbor list produced by nearest neighbor
       * search requiring that no more than some value k' of the k neighbors
       * returned have the same value of crowding_attribute.
       * </pre>
       *
       * <code>string crowding_column = 5 [(.google.api.field_behavior) = OPTIONAL];</code>
       *
       * @return The bytes for crowdingColumn.
       */
      public com.google.protobuf.ByteString getCrowdingColumnBytes() {
        java.lang.Object ref = crowdingColumn_;
        if (ref instanceof String) {
          com.google.protobuf.ByteString b =
              com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
          crowdingColumn_ = b;
          return b;
        } else {
          return (com.google.protobuf.ByteString) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * Optional. Column of crowding. This column contains crowding attribute
       * which is a constraint on a neighbor list produced by nearest neighbor
       * search requiring that no more than some value k' of the k neighbors
       * returned have the same value of crowding_attribute.
       * </pre>
       *
       * <code>string crowding_column = 5 [(.google.api.field_behavior) = OPTIONAL];</code>
       *
       * @param value The crowdingColumn to set.
       * @return This builder for chaining.
       */
      public Builder setCrowdingColumn(java.lang.String value) {
        if (value == null) {
          throw new NullPointerException();
        }
        crowdingColumn_ = value;
        bitField0_ |= 0x00000010;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Optional. Column of crowding. This column contains crowding attribute
       * which is a constraint on a neighbor list produced by nearest neighbor
       * search requiring that no more than some value k' of the k neighbors
       * returned have the same value of crowding_attribute.
       * </pre>
       *
       * <code>string crowding_column = 5 [(.google.api.field_behavior) = OPTIONAL];</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearCrowdingColumn() {
        crowdingColumn_ = getDefaultInstance().getCrowdingColumn();
        bitField0_ = (bitField0_ & ~0x00000010);
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Optional. Column of crowding. This column contains crowding attribute
       * which is a constraint on a neighbor list produced by nearest neighbor
       * search requiring that no more than some value k' of the k neighbors
       * returned have the same value of crowding_attribute.
       * </pre>
       *
       * <code>string crowding_column = 5 [(.google.api.field_behavior) = OPTIONAL];</code>
       *
       * @param value The bytes for crowdingColumn to set.
       * @return This builder for chaining.
       */
      public Builder setCrowdingColumnBytes(com.google.protobuf.ByteString value) {
        if (value == null) {
          throw new NullPointerException();
        }
        checkByteStringIsUtf8(value);
        crowdingColumn_ = value;
        bitField0_ |= 0x00000010;
        onChanged();
        return this;
      }

      private int embeddingDimension_;
      /**
       *
       *
       * <pre>
       * Optional. The number of dimensions of the input embedding.
       * </pre>
       *
       * <code>optional int32 embedding_dimension = 6 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       *
       * @return Whether the embeddingDimension field is set.
       */
      @java.lang.Override
      public boolean hasEmbeddingDimension() {
        return ((bitField0_ & 0x00000020) != 0);
      }
      /**
       *
       *
       * <pre>
       * Optional. The number of dimensions of the input embedding.
       * </pre>
       *
       * <code>optional int32 embedding_dimension = 6 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       *
       * @return The embeddingDimension.
       */
      @java.lang.Override
      public int getEmbeddingDimension() {
        return embeddingDimension_;
      }
      /**
       *
       *
       * <pre>
       * Optional. The number of dimensions of the input embedding.
       * </pre>
       *
       * <code>optional int32 embedding_dimension = 6 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       *
       * @param value The embeddingDimension to set.
       * @return This builder for chaining.
       */
      public Builder setEmbeddingDimension(int value) {

        embeddingDimension_ = value;
        bitField0_ |= 0x00000020;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Optional. The number of dimensions of the input embedding.
       * </pre>
       *
       * <code>optional int32 embedding_dimension = 6 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       *
       * @return This builder for chaining.
       */
      public Builder clearEmbeddingDimension() {
        bitField0_ = (bitField0_ & ~0x00000020);
        embeddingDimension_ = 0;
        onChanged();
        return this;
      }

      private int distanceMeasureType_ = 0;
      /**
       *
       *
       * <pre>
       * Optional. The distance measure used in nearest neighbor search.
       * </pre>
       *
       * <code>
       * .google.cloud.aiplatform.v1beta1.FeatureView.VectorSearchConfig.DistanceMeasureType distance_measure_type = 7 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       *
       * @return The enum numeric value on the wire for distanceMeasureType.
       */
      @java.lang.Override
      public int getDistanceMeasureTypeValue() {
        return distanceMeasureType_;
      }
      /**
       *
       *
       * <pre>
       * Optional. The distance measure used in nearest neighbor search.
       * </pre>
       *
       * <code>
       * .google.cloud.aiplatform.v1beta1.FeatureView.VectorSearchConfig.DistanceMeasureType distance_measure_type = 7 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       *
       * @param value The enum numeric value on the wire for distanceMeasureType to set.
       * @return This builder for chaining.
       */
      public Builder setDistanceMeasureTypeValue(int value) {
        distanceMeasureType_ = value;
        bitField0_ |= 0x00000040;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Optional. The distance measure used in nearest neighbor search.
       * </pre>
       *
       * <code>
       * .google.cloud.aiplatform.v1beta1.FeatureView.VectorSearchConfig.DistanceMeasureType distance_measure_type = 7 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       *
       * @return The distanceMeasureType.
       */
      @java.lang.Override
      public com.google.cloud.aiplatform.v1beta1.FeatureView.VectorSearchConfig.DistanceMeasureType
          getDistanceMeasureType() {
        com.google.cloud.aiplatform.v1beta1.FeatureView.VectorSearchConfig.DistanceMeasureType
            result =
                com.google.cloud.aiplatform.v1beta1.FeatureView.VectorSearchConfig
                    .DistanceMeasureType.forNumber(distanceMeasureType_);
        return result == null
            ? com.google.cloud.aiplatform.v1beta1.FeatureView.VectorSearchConfig.DistanceMeasureType
                .UNRECOGNIZED
            : result;
      }
      /**
       *
       *
       * <pre>
       * Optional. The distance measure used in nearest neighbor search.
       * </pre>
       *
       * <code>
       * .google.cloud.aiplatform.v1beta1.FeatureView.VectorSearchConfig.DistanceMeasureType distance_measure_type = 7 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       *
       * @param value The distanceMeasureType to set.
       * @return This builder for chaining.
       */
      public Builder setDistanceMeasureType(
          com.google.cloud.aiplatform.v1beta1.FeatureView.VectorSearchConfig.DistanceMeasureType
              value) {
        if (value == null) {
          throw new NullPointerException();
        }
        bitField0_ |= 0x00000040;
        distanceMeasureType_ = value.getNumber();
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Optional. The distance measure used in nearest neighbor search.
       * </pre>
       *
       * <code>
       * .google.cloud.aiplatform.v1beta1.FeatureView.VectorSearchConfig.DistanceMeasureType distance_measure_type = 7 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       *
       * @return This builder for chaining.
       */
      public Builder clearDistanceMeasureType() {
        bitField0_ = (bitField0_ & ~0x00000040);
        distanceMeasureType_ = 0;
        onChanged();
        return this;
      }

      @java.lang.Override
      public final Builder setUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.setUnknownFields(unknownFields);
      }

      @java.lang.Override
      public final Builder mergeUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.mergeUnknownFields(unknownFields);
      }

      // @@protoc_insertion_point(builder_scope:google.cloud.aiplatform.v1beta1.FeatureView.VectorSearchConfig)
    }

    // @@protoc_insertion_point(class_scope:google.cloud.aiplatform.v1beta1.FeatureView.VectorSearchConfig)
    private static final com.google.cloud.aiplatform.v1beta1.FeatureView.VectorSearchConfig
        DEFAULT_INSTANCE;

    static {
      DEFAULT_INSTANCE = new com.google.cloud.aiplatform.v1beta1.FeatureView.VectorSearchConfig();
    }

    public static com.google.cloud.aiplatform.v1beta1.FeatureView.VectorSearchConfig
        getDefaultInstance() {
      return DEFAULT_INSTANCE;
    }

    private static final com.google.protobuf.Parser<VectorSearchConfig> PARSER =
        new com.google.protobuf.AbstractParser<VectorSearchConfig>() {
          @java.lang.Override
          public VectorSearchConfig parsePartialFrom(
              com.google.protobuf.CodedInputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
            Builder builder = newBuilder();
            try {
              builder.mergeFrom(input, extensionRegistry);
            } catch (com.google.protobuf.InvalidProtocolBufferException e) {
              throw e.setUnfinishedMessage(builder.buildPartial());
            } catch (com.google.protobuf.UninitializedMessageException e) {
              throw e.asInvalidProtocolBufferException()
                  .setUnfinishedMessage(builder.buildPartial());
            } catch (java.io.IOException e) {
              throw new com.google.protobuf.InvalidProtocolBufferException(e)
                  .setUnfinishedMessage(builder.buildPartial());
            }
            return builder.buildPartial();
          }
        };

    public static com.google.protobuf.Parser<VectorSearchConfig> parser() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.protobuf.Parser<VectorSearchConfig> getParserForType() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.cloud.aiplatform.v1beta1.FeatureView.VectorSearchConfig
        getDefaultInstanceForType() {
      return DEFAULT_INSTANCE;
    }
  }

  public interface FeatureRegistrySourceOrBuilder
      extends
      // @@protoc_insertion_point(interface_extends:google.cloud.aiplatform.v1beta1.FeatureView.FeatureRegistrySource)
      com.google.protobuf.MessageOrBuilder {

    /**
     *
     *
     * <pre>
     * Required. List of features that need to be synced to Online Store.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.aiplatform.v1beta1.FeatureView.FeatureRegistrySource.FeatureGroup feature_groups = 1 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    java.util.List<
            com.google.cloud.aiplatform.v1beta1.FeatureView.FeatureRegistrySource.FeatureGroup>
        getFeatureGroupsList();
    /**
     *
     *
     * <pre>
     * Required. List of features that need to be synced to Online Store.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.aiplatform.v1beta1.FeatureView.FeatureRegistrySource.FeatureGroup feature_groups = 1 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    com.google.cloud.aiplatform.v1beta1.FeatureView.FeatureRegistrySource.FeatureGroup
        getFeatureGroups(int index);
    /**
     *
     *
     * <pre>
     * Required. List of features that need to be synced to Online Store.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.aiplatform.v1beta1.FeatureView.FeatureRegistrySource.FeatureGroup feature_groups = 1 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    int getFeatureGroupsCount();
    /**
     *
     *
     * <pre>
     * Required. List of features that need to be synced to Online Store.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.aiplatform.v1beta1.FeatureView.FeatureRegistrySource.FeatureGroup feature_groups = 1 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    java.util.List<
            ? extends
                com.google.cloud.aiplatform.v1beta1.FeatureView.FeatureRegistrySource
                    .FeatureGroupOrBuilder>
        getFeatureGroupsOrBuilderList();
    /**
     *
     *
     * <pre>
     * Required. List of features that need to be synced to Online Store.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.aiplatform.v1beta1.FeatureView.FeatureRegistrySource.FeatureGroup feature_groups = 1 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    com.google.cloud.aiplatform.v1beta1.FeatureView.FeatureRegistrySource.FeatureGroupOrBuilder
        getFeatureGroupsOrBuilder(int index);
  }
  /**
   *
   *
   * <pre>
   * A Feature Registry source for features that need to be synced to Online
   * Store.
   * </pre>
   *
   * Protobuf type {@code google.cloud.aiplatform.v1beta1.FeatureView.FeatureRegistrySource}
   */
  public static final class FeatureRegistrySource extends com.google.protobuf.GeneratedMessageV3
      implements
      // @@protoc_insertion_point(message_implements:google.cloud.aiplatform.v1beta1.FeatureView.FeatureRegistrySource)
      FeatureRegistrySourceOrBuilder {
    private static final long serialVersionUID = 0L;
    // Use FeatureRegistrySource.newBuilder() to construct.
    private FeatureRegistrySource(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
      super(builder);
    }

    private FeatureRegistrySource() {
      featureGroups_ = java.util.Collections.emptyList();
    }

    @java.lang.Override
    @SuppressWarnings({"unused"})
    protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
      return new FeatureRegistrySource();
    }

    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.aiplatform.v1beta1.FeatureViewProto
          .internal_static_google_cloud_aiplatform_v1beta1_FeatureView_FeatureRegistrySource_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.aiplatform.v1beta1.FeatureViewProto
          .internal_static_google_cloud_aiplatform_v1beta1_FeatureView_FeatureRegistrySource_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.aiplatform.v1beta1.FeatureView.FeatureRegistrySource.class,
              com.google.cloud.aiplatform.v1beta1.FeatureView.FeatureRegistrySource.Builder.class);
    }

    public interface FeatureGroupOrBuilder
        extends
        // @@protoc_insertion_point(interface_extends:google.cloud.aiplatform.v1beta1.FeatureView.FeatureRegistrySource.FeatureGroup)
        com.google.protobuf.MessageOrBuilder {

      /**
       *
       *
       * <pre>
       * Required. Identifier of the feature group.
       * </pre>
       *
       * <code>string feature_group_id = 1 [(.google.api.field_behavior) = REQUIRED];</code>
       *
       * @return The featureGroupId.
       */
      java.lang.String getFeatureGroupId();
      /**
       *
       *
       * <pre>
       * Required. Identifier of the feature group.
       * </pre>
       *
       * <code>string feature_group_id = 1 [(.google.api.field_behavior) = REQUIRED];</code>
       *
       * @return The bytes for featureGroupId.
       */
      com.google.protobuf.ByteString getFeatureGroupIdBytes();

      /**
       *
       *
       * <pre>
       * Required. Identifiers of features under the feature group.
       * </pre>
       *
       * <code>repeated string feature_ids = 2 [(.google.api.field_behavior) = REQUIRED];</code>
       *
       * @return A list containing the featureIds.
       */
      java.util.List<java.lang.String> getFeatureIdsList();
      /**
       *
       *
       * <pre>
       * Required. Identifiers of features under the feature group.
       * </pre>
       *
       * <code>repeated string feature_ids = 2 [(.google.api.field_behavior) = REQUIRED];</code>
       *
       * @return The count of featureIds.
       */
      int getFeatureIdsCount();
      /**
       *
       *
       * <pre>
       * Required. Identifiers of features under the feature group.
       * </pre>
       *
       * <code>repeated string feature_ids = 2 [(.google.api.field_behavior) = REQUIRED];</code>
       *
       * @param index The index of the element to return.
       * @return The featureIds at the given index.
       */
      java.lang.String getFeatureIds(int index);
      /**
       *
       *
       * <pre>
       * Required. Identifiers of features under the feature group.
       * </pre>
       *
       * <code>repeated string feature_ids = 2 [(.google.api.field_behavior) = REQUIRED];</code>
       *
       * @param index The index of the value to return.
       * @return The bytes of the featureIds at the given index.
       */
      com.google.protobuf.ByteString getFeatureIdsBytes(int index);
    }
    /**
     *
     *
     * <pre>
     * Features belonging to a single feature group that will be
     * synced to Online Store.
     * </pre>
     *
     * Protobuf type {@code
     * google.cloud.aiplatform.v1beta1.FeatureView.FeatureRegistrySource.FeatureGroup}
     */
    public static final class FeatureGroup extends com.google.protobuf.GeneratedMessageV3
        implements
        // @@protoc_insertion_point(message_implements:google.cloud.aiplatform.v1beta1.FeatureView.FeatureRegistrySource.FeatureGroup)
        FeatureGroupOrBuilder {
      private static final long serialVersionUID = 0L;
      // Use FeatureGroup.newBuilder() to construct.
      private FeatureGroup(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
        super(builder);
      }

      private FeatureGroup() {
        featureGroupId_ = "";
        featureIds_ = com.google.protobuf.LazyStringArrayList.emptyList();
      }

      @java.lang.Override
      @SuppressWarnings({"unused"})
      protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
        return new FeatureGroup();
      }

      public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
        return com.google.cloud.aiplatform.v1beta1.FeatureViewProto
            .internal_static_google_cloud_aiplatform_v1beta1_FeatureView_FeatureRegistrySource_FeatureGroup_descriptor;
      }

      @java.lang.Override
      protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return com.google.cloud.aiplatform.v1beta1.FeatureViewProto
            .internal_static_google_cloud_aiplatform_v1beta1_FeatureView_FeatureRegistrySource_FeatureGroup_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                com.google.cloud.aiplatform.v1beta1.FeatureView.FeatureRegistrySource.FeatureGroup
                    .class,
                com.google.cloud.aiplatform.v1beta1.FeatureView.FeatureRegistrySource.FeatureGroup
                    .Builder.class);
      }

      public static final int FEATURE_GROUP_ID_FIELD_NUMBER = 1;

      @SuppressWarnings("serial")
      private volatile java.lang.Object featureGroupId_ = "";
      /**
       *
       *
       * <pre>
       * Required. Identifier of the feature group.
       * </pre>
       *
       * <code>string feature_group_id = 1 [(.google.api.field_behavior) = REQUIRED];</code>
       *
       * @return The featureGroupId.
       */
      @java.lang.Override
      public java.lang.String getFeatureGroupId() {
        java.lang.Object ref = featureGroupId_;
        if (ref instanceof java.lang.String) {
          return (java.lang.String) ref;
        } else {
          com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
          java.lang.String s = bs.toStringUtf8();
          featureGroupId_ = s;
          return s;
        }
      }
      /**
       *
       *
       * <pre>
       * Required. Identifier of the feature group.
       * </pre>
       *
       * <code>string feature_group_id = 1 [(.google.api.field_behavior) = REQUIRED];</code>
       *
       * @return The bytes for featureGroupId.
       */
      @java.lang.Override
      public com.google.protobuf.ByteString getFeatureGroupIdBytes() {
        java.lang.Object ref = featureGroupId_;
        if (ref instanceof java.lang.String) {
          com.google.protobuf.ByteString b =
              com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
          featureGroupId_ = b;
          return b;
        } else {
          return (com.google.protobuf.ByteString) ref;
        }
      }

      public static final int FEATURE_IDS_FIELD_NUMBER = 2;

      @SuppressWarnings("serial")
      private com.google.protobuf.LazyStringArrayList featureIds_ =
          com.google.protobuf.LazyStringArrayList.emptyList();
      /**
       *
       *
       * <pre>
       * Required. Identifiers of features under the feature group.
       * </pre>
       *
       * <code>repeated string feature_ids = 2 [(.google.api.field_behavior) = REQUIRED];</code>
       *
       * @return A list containing the featureIds.
       */
      public com.google.protobuf.ProtocolStringList getFeatureIdsList() {
        return featureIds_;
      }
      /**
       *
       *
       * <pre>
       * Required. Identifiers of features under the feature group.
       * </pre>
       *
       * <code>repeated string feature_ids = 2 [(.google.api.field_behavior) = REQUIRED];</code>
       *
       * @return The count of featureIds.
       */
      public int getFeatureIdsCount() {
        return featureIds_.size();
      }
      /**
       *
       *
       * <pre>
       * Required. Identifiers of features under the feature group.
       * </pre>
       *
       * <code>repeated string feature_ids = 2 [(.google.api.field_behavior) = REQUIRED];</code>
       *
       * @param index The index of the element to return.
       * @return The featureIds at the given index.
       */
      public java.lang.String getFeatureIds(int index) {
        return featureIds_.get(index);
      }
      /**
       *
       *
       * <pre>
       * Required. Identifiers of features under the feature group.
       * </pre>
       *
       * <code>repeated string feature_ids = 2 [(.google.api.field_behavior) = REQUIRED];</code>
       *
       * @param index The index of the value to return.
       * @return The bytes of the featureIds at the given index.
       */
      public com.google.protobuf.ByteString getFeatureIdsBytes(int index) {
        return featureIds_.getByteString(index);
      }

      private byte memoizedIsInitialized = -1;

      @java.lang.Override
      public final boolean isInitialized() {
        byte isInitialized = memoizedIsInitialized;
        if (isInitialized == 1) return true;
        if (isInitialized == 0) return false;

        memoizedIsInitialized = 1;
        return true;
      }

      @java.lang.Override
      public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
        if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(featureGroupId_)) {
          com.google.protobuf.GeneratedMessageV3.writeString(output, 1, featureGroupId_);
        }
        for (int i = 0; i < featureIds_.size(); i++) {
          com.google.protobuf.GeneratedMessageV3.writeString(output, 2, featureIds_.getRaw(i));
        }
        getUnknownFields().writeTo(output);
      }

      @java.lang.Override
      public int getSerializedSize() {
        int size = memoizedSize;
        if (size != -1) return size;

        size = 0;
        if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(featureGroupId_)) {
          size += com.google.protobuf.GeneratedMessageV3.computeStringSize(1, featureGroupId_);
        }
        {
          int dataSize = 0;
          for (int i = 0; i < featureIds_.size(); i++) {
            dataSize += computeStringSizeNoTag(featureIds_.getRaw(i));
          }
          size += dataSize;
          size += 1 * getFeatureIdsList().size();
        }
        size += getUnknownFields().getSerializedSize();
        memoizedSize = size;
        return size;
      }

      @java.lang.Override
      public boolean equals(final java.lang.Object obj) {
        if (obj == this) {
          return true;
        }
        if (!(obj
            instanceof
            com.google.cloud.aiplatform.v1beta1.FeatureView.FeatureRegistrySource.FeatureGroup)) {
          return super.equals(obj);
        }
        com.google.cloud.aiplatform.v1beta1.FeatureView.FeatureRegistrySource.FeatureGroup other =
            (com.google.cloud.aiplatform.v1beta1.FeatureView.FeatureRegistrySource.FeatureGroup)
                obj;

        if (!getFeatureGroupId().equals(other.getFeatureGroupId())) return false;
        if (!getFeatureIdsList().equals(other.getFeatureIdsList())) return false;
        if (!getUnknownFields().equals(other.getUnknownFields())) return false;
        return true;
      }

      @java.lang.Override
      public int hashCode() {
        if (memoizedHashCode != 0) {
          return memoizedHashCode;
        }
        int hash = 41;
        hash = (19 * hash) + getDescriptor().hashCode();
        hash = (37 * hash) + FEATURE_GROUP_ID_FIELD_NUMBER;
        hash = (53 * hash) + getFeatureGroupId().hashCode();
        if (getFeatureIdsCount() > 0) {
          hash = (37 * hash) + FEATURE_IDS_FIELD_NUMBER;
          hash = (53 * hash) + getFeatureIdsList().hashCode();
        }
        hash = (29 * hash) + getUnknownFields().hashCode();
        memoizedHashCode = hash;
        return hash;
      }

      public static com.google.cloud.aiplatform.v1beta1.FeatureView.FeatureRegistrySource
              .FeatureGroup
          parseFrom(java.nio.ByteBuffer data)
              throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data);
      }

      public static com.google.cloud.aiplatform.v1beta1.FeatureView.FeatureRegistrySource
              .FeatureGroup
          parseFrom(
              java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data, extensionRegistry);
      }

      public static com.google.cloud.aiplatform.v1beta1.FeatureView.FeatureRegistrySource
              .FeatureGroup
          parseFrom(com.google.protobuf.ByteString data)
              throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data);
      }

      public static com.google.cloud.aiplatform.v1beta1.FeatureView.FeatureRegistrySource
              .FeatureGroup
          parseFrom(
              com.google.protobuf.ByteString data,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data, extensionRegistry);
      }

      public static com.google.cloud.aiplatform.v1beta1.FeatureView.FeatureRegistrySource
              .FeatureGroup
          parseFrom(byte[] data) throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data);
      }

      public static com.google.cloud.aiplatform.v1beta1.FeatureView.FeatureRegistrySource
              .FeatureGroup
          parseFrom(byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data, extensionRegistry);
      }

      public static com.google.cloud.aiplatform.v1beta1.FeatureView.FeatureRegistrySource
              .FeatureGroup
          parseFrom(java.io.InputStream input) throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
      }

      public static com.google.cloud.aiplatform.v1beta1.FeatureView.FeatureRegistrySource
              .FeatureGroup
          parseFrom(
              java.io.InputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
            PARSER, input, extensionRegistry);
      }

      public static com.google.cloud.aiplatform.v1beta1.FeatureView.FeatureRegistrySource
              .FeatureGroup
          parseDelimitedFrom(java.io.InputStream input) throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
      }

      public static com.google.cloud.aiplatform.v1beta1.FeatureView.FeatureRegistrySource
              .FeatureGroup
          parseDelimitedFrom(
              java.io.InputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
            PARSER, input, extensionRegistry);
      }

      public static com.google.cloud.aiplatform.v1beta1.FeatureView.FeatureRegistrySource
              .FeatureGroup
          parseFrom(com.google.protobuf.CodedInputStream input) throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
      }

      public static com.google.cloud.aiplatform.v1beta1.FeatureView.FeatureRegistrySource
              .FeatureGroup
          parseFrom(
              com.google.protobuf.CodedInputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
            PARSER, input, extensionRegistry);
      }

      @java.lang.Override
      public Builder newBuilderForType() {
        return newBuilder();
      }

      public static Builder newBuilder() {
        return DEFAULT_INSTANCE.toBuilder();
      }

      public static Builder newBuilder(
          com.google.cloud.aiplatform.v1beta1.FeatureView.FeatureRegistrySource.FeatureGroup
              prototype) {
        return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
      }

      @java.lang.Override
      public Builder toBuilder() {
        return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
      }

      @java.lang.Override
      protected Builder newBuilderForType(
          com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
        Builder builder = new Builder(parent);
        return builder;
      }
      /**
       *
       *
       * <pre>
       * Features belonging to a single feature group that will be
       * synced to Online Store.
       * </pre>
       *
       * Protobuf type {@code
       * google.cloud.aiplatform.v1beta1.FeatureView.FeatureRegistrySource.FeatureGroup}
       */
      public static final class Builder
          extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
          implements
          // @@protoc_insertion_point(builder_implements:google.cloud.aiplatform.v1beta1.FeatureView.FeatureRegistrySource.FeatureGroup)
          com.google.cloud.aiplatform.v1beta1.FeatureView.FeatureRegistrySource
              .FeatureGroupOrBuilder {
        public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
          return com.google.cloud.aiplatform.v1beta1.FeatureViewProto
              .internal_static_google_cloud_aiplatform_v1beta1_FeatureView_FeatureRegistrySource_FeatureGroup_descriptor;
        }

        @java.lang.Override
        protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
            internalGetFieldAccessorTable() {
          return com.google.cloud.aiplatform.v1beta1.FeatureViewProto
              .internal_static_google_cloud_aiplatform_v1beta1_FeatureView_FeatureRegistrySource_FeatureGroup_fieldAccessorTable
              .ensureFieldAccessorsInitialized(
                  com.google.cloud.aiplatform.v1beta1.FeatureView.FeatureRegistrySource.FeatureGroup
                      .class,
                  com.google.cloud.aiplatform.v1beta1.FeatureView.FeatureRegistrySource.FeatureGroup
                      .Builder.class);
        }

        // Construct using
        // com.google.cloud.aiplatform.v1beta1.FeatureView.FeatureRegistrySource.FeatureGroup.newBuilder()
        private Builder() {}

        private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
          super(parent);
        }

        @java.lang.Override
        public Builder clear() {
          super.clear();
          bitField0_ = 0;
          featureGroupId_ = "";
          featureIds_ = com.google.protobuf.LazyStringArrayList.emptyList();
          return this;
        }

        @java.lang.Override
        public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
          return com.google.cloud.aiplatform.v1beta1.FeatureViewProto
              .internal_static_google_cloud_aiplatform_v1beta1_FeatureView_FeatureRegistrySource_FeatureGroup_descriptor;
        }

        @java.lang.Override
        public com.google.cloud.aiplatform.v1beta1.FeatureView.FeatureRegistrySource.FeatureGroup
            getDefaultInstanceForType() {
          return com.google.cloud.aiplatform.v1beta1.FeatureView.FeatureRegistrySource.FeatureGroup
              .getDefaultInstance();
        }

        @java.lang.Override
        public com.google.cloud.aiplatform.v1beta1.FeatureView.FeatureRegistrySource.FeatureGroup
            build() {
          com.google.cloud.aiplatform.v1beta1.FeatureView.FeatureRegistrySource.FeatureGroup
              result = buildPartial();
          if (!result.isInitialized()) {
            throw newUninitializedMessageException(result);
          }
          return result;
        }

        @java.lang.Override
        public com.google.cloud.aiplatform.v1beta1.FeatureView.FeatureRegistrySource.FeatureGroup
            buildPartial() {
          com.google.cloud.aiplatform.v1beta1.FeatureView.FeatureRegistrySource.FeatureGroup
              result =
                  new com.google.cloud.aiplatform.v1beta1.FeatureView.FeatureRegistrySource
                      .FeatureGroup(this);
          if (bitField0_ != 0) {
            buildPartial0(result);
          }
          onBuilt();
          return result;
        }

        private void buildPartial0(
            com.google.cloud.aiplatform.v1beta1.FeatureView.FeatureRegistrySource.FeatureGroup
                result) {
          int from_bitField0_ = bitField0_;
          if (((from_bitField0_ & 0x00000001) != 0)) {
            result.featureGroupId_ = featureGroupId_;
          }
          if (((from_bitField0_ & 0x00000002) != 0)) {
            featureIds_.makeImmutable();
            result.featureIds_ = featureIds_;
          }
        }

        @java.lang.Override
        public Builder clone() {
          return super.clone();
        }

        @java.lang.Override
        public Builder setField(
            com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
          return super.setField(field, value);
        }

        @java.lang.Override
        public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
          return super.clearField(field);
        }

        @java.lang.Override
        public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
          return super.clearOneof(oneof);
        }

        @java.lang.Override
        public Builder setRepeatedField(
            com.google.protobuf.Descriptors.FieldDescriptor field,
            int index,
            java.lang.Object value) {
          return super.setRepeatedField(field, index, value);
        }

        @java.lang.Override
        public Builder addRepeatedField(
            com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
          return super.addRepeatedField(field, value);
        }

        @java.lang.Override
        public Builder mergeFrom(com.google.protobuf.Message other) {
          if (other
              instanceof
              com.google.cloud.aiplatform.v1beta1.FeatureView.FeatureRegistrySource.FeatureGroup) {
            return mergeFrom(
                (com.google.cloud.aiplatform.v1beta1.FeatureView.FeatureRegistrySource.FeatureGroup)
                    other);
          } else {
            super.mergeFrom(other);
            return this;
          }
        }

        public Builder mergeFrom(
            com.google.cloud.aiplatform.v1beta1.FeatureView.FeatureRegistrySource.FeatureGroup
                other) {
          if (other
              == com.google.cloud.aiplatform.v1beta1.FeatureView.FeatureRegistrySource.FeatureGroup
                  .getDefaultInstance()) return this;
          if (!other.getFeatureGroupId().isEmpty()) {
            featureGroupId_ = other.featureGroupId_;
            bitField0_ |= 0x00000001;
            onChanged();
          }
          if (!other.featureIds_.isEmpty()) {
            if (featureIds_.isEmpty()) {
              featureIds_ = other.featureIds_;
              bitField0_ |= 0x00000002;
            } else {
              ensureFeatureIdsIsMutable();
              featureIds_.addAll(other.featureIds_);
            }
            onChanged();
          }
          this.mergeUnknownFields(other.getUnknownFields());
          onChanged();
          return this;
        }

        @java.lang.Override
        public final boolean isInitialized() {
          return true;
        }

        @java.lang.Override
        public Builder mergeFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws java.io.IOException {
          if (extensionRegistry == null) {
            throw new java.lang.NullPointerException();
          }
          try {
            boolean done = false;
            while (!done) {
              int tag = input.readTag();
              switch (tag) {
                case 0:
                  done = true;
                  break;
                case 10:
                  {
                    featureGroupId_ = input.readStringRequireUtf8();
                    bitField0_ |= 0x00000001;
                    break;
                  } // case 10
                case 18:
                  {
                    java.lang.String s = input.readStringRequireUtf8();
                    ensureFeatureIdsIsMutable();
                    featureIds_.add(s);
                    break;
                  } // case 18
                default:
                  {
                    if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                      done = true; // was an endgroup tag
                    }
                    break;
                  } // default:
              } // switch (tag)
            } // while (!done)
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.unwrapIOException();
          } finally {
            onChanged();
          } // finally
          return this;
        }

        private int bitField0_;

        private java.lang.Object featureGroupId_ = "";
        /**
         *
         *
         * <pre>
         * Required. Identifier of the feature group.
         * </pre>
         *
         * <code>string feature_group_id = 1 [(.google.api.field_behavior) = REQUIRED];</code>
         *
         * @return The featureGroupId.
         */
        public java.lang.String getFeatureGroupId() {
          java.lang.Object ref = featureGroupId_;
          if (!(ref instanceof java.lang.String)) {
            com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
            java.lang.String s = bs.toStringUtf8();
            featureGroupId_ = s;
            return s;
          } else {
            return (java.lang.String) ref;
          }
        }
        /**
         *
         *
         * <pre>
         * Required. Identifier of the feature group.
         * </pre>
         *
         * <code>string feature_group_id = 1 [(.google.api.field_behavior) = REQUIRED];</code>
         *
         * @return The bytes for featureGroupId.
         */
        public com.google.protobuf.ByteString getFeatureGroupIdBytes() {
          java.lang.Object ref = featureGroupId_;
          if (ref instanceof String) {
            com.google.protobuf.ByteString b =
                com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
            featureGroupId_ = b;
            return b;
          } else {
            return (com.google.protobuf.ByteString) ref;
          }
        }
        /**
         *
         *
         * <pre>
         * Required. Identifier of the feature group.
         * </pre>
         *
         * <code>string feature_group_id = 1 [(.google.api.field_behavior) = REQUIRED];</code>
         *
         * @param value The featureGroupId to set.
         * @return This builder for chaining.
         */
        public Builder setFeatureGroupId(java.lang.String value) {
          if (value == null) {
            throw new NullPointerException();
          }
          featureGroupId_ = value;
          bitField0_ |= 0x00000001;
          onChanged();
          return this;
        }
        /**
         *
         *
         * <pre>
         * Required. Identifier of the feature group.
         * </pre>
         *
         * <code>string feature_group_id = 1 [(.google.api.field_behavior) = REQUIRED];</code>
         *
         * @return This builder for chaining.
         */
        public Builder clearFeatureGroupId() {
          featureGroupId_ = getDefaultInstance().getFeatureGroupId();
          bitField0_ = (bitField0_ & ~0x00000001);
          onChanged();
          return this;
        }
        /**
         *
         *
         * <pre>
         * Required. Identifier of the feature group.
         * </pre>
         *
         * <code>string feature_group_id = 1 [(.google.api.field_behavior) = REQUIRED];</code>
         *
         * @param value The bytes for featureGroupId to set.
         * @return This builder for chaining.
         */
        public Builder setFeatureGroupIdBytes(com.google.protobuf.ByteString value) {
          if (value == null) {
            throw new NullPointerException();
          }
          checkByteStringIsUtf8(value);
          featureGroupId_ = value;
          bitField0_ |= 0x00000001;
          onChanged();
          return this;
        }

        private com.google.protobuf.LazyStringArrayList featureIds_ =
            com.google.protobuf.LazyStringArrayList.emptyList();

        private void ensureFeatureIdsIsMutable() {
          if (!featureIds_.isModifiable()) {
            featureIds_ = new com.google.protobuf.LazyStringArrayList(featureIds_);
          }
          bitField0_ |= 0x00000002;
        }
        /**
         *
         *
         * <pre>
         * Required. Identifiers of features under the feature group.
         * </pre>
         *
         * <code>repeated string feature_ids = 2 [(.google.api.field_behavior) = REQUIRED];</code>
         *
         * @return A list containing the featureIds.
         */
        public com.google.protobuf.ProtocolStringList getFeatureIdsList() {
          featureIds_.makeImmutable();
          return featureIds_;
        }
        /**
         *
         *
         * <pre>
         * Required. Identifiers of features under the feature group.
         * </pre>
         *
         * <code>repeated string feature_ids = 2 [(.google.api.field_behavior) = REQUIRED];</code>
         *
         * @return The count of featureIds.
         */
        public int getFeatureIdsCount() {
          return featureIds_.size();
        }
        /**
         *
         *
         * <pre>
         * Required. Identifiers of features under the feature group.
         * </pre>
         *
         * <code>repeated string feature_ids = 2 [(.google.api.field_behavior) = REQUIRED];</code>
         *
         * @param index The index of the element to return.
         * @return The featureIds at the given index.
         */
        public java.lang.String getFeatureIds(int index) {
          return featureIds_.get(index);
        }
        /**
         *
         *
         * <pre>
         * Required. Identifiers of features under the feature group.
         * </pre>
         *
         * <code>repeated string feature_ids = 2 [(.google.api.field_behavior) = REQUIRED];</code>
         *
         * @param index The index of the value to return.
         * @return The bytes of the featureIds at the given index.
         */
        public com.google.protobuf.ByteString getFeatureIdsBytes(int index) {
          return featureIds_.getByteString(index);
        }
        /**
         *
         *
         * <pre>
         * Required. Identifiers of features under the feature group.
         * </pre>
         *
         * <code>repeated string feature_ids = 2 [(.google.api.field_behavior) = REQUIRED];</code>
         *
         * @param index The index to set the value at.
         * @param value The featureIds to set.
         * @return This builder for chaining.
         */
        public Builder setFeatureIds(int index, java.lang.String value) {
          if (value == null) {
            throw new NullPointerException();
          }
          ensureFeatureIdsIsMutable();
          featureIds_.set(index, value);
          bitField0_ |= 0x00000002;
          onChanged();
          return this;
        }
        /**
         *
         *
         * <pre>
         * Required. Identifiers of features under the feature group.
         * </pre>
         *
         * <code>repeated string feature_ids = 2 [(.google.api.field_behavior) = REQUIRED];</code>
         *
         * @param value The featureIds to add.
         * @return This builder for chaining.
         */
        public Builder addFeatureIds(java.lang.String value) {
          if (value == null) {
            throw new NullPointerException();
          }
          ensureFeatureIdsIsMutable();
          featureIds_.add(value);
          bitField0_ |= 0x00000002;
          onChanged();
          return this;
        }
        /**
         *
         *
         * <pre>
         * Required. Identifiers of features under the feature group.
         * </pre>
         *
         * <code>repeated string feature_ids = 2 [(.google.api.field_behavior) = REQUIRED];</code>
         *
         * @param values The featureIds to add.
         * @return This builder for chaining.
         */
        public Builder addAllFeatureIds(java.lang.Iterable<java.lang.String> values) {
          ensureFeatureIdsIsMutable();
          com.google.protobuf.AbstractMessageLite.Builder.addAll(values, featureIds_);
          bitField0_ |= 0x00000002;
          onChanged();
          return this;
        }
        /**
         *
         *
         * <pre>
         * Required. Identifiers of features under the feature group.
         * </pre>
         *
         * <code>repeated string feature_ids = 2 [(.google.api.field_behavior) = REQUIRED];</code>
         *
         * @return This builder for chaining.
         */
        public Builder clearFeatureIds() {
          featureIds_ = com.google.protobuf.LazyStringArrayList.emptyList();
          bitField0_ = (bitField0_ & ~0x00000002);
          ;
          onChanged();
          return this;
        }
        /**
         *
         *
         * <pre>
         * Required. Identifiers of features under the feature group.
         * </pre>
         *
         * <code>repeated string feature_ids = 2 [(.google.api.field_behavior) = REQUIRED];</code>
         *
         * @param value The bytes of the featureIds to add.
         * @return This builder for chaining.
         */
        public Builder addFeatureIdsBytes(com.google.protobuf.ByteString value) {
          if (value == null) {
            throw new NullPointerException();
          }
          checkByteStringIsUtf8(value);
          ensureFeatureIdsIsMutable();
          featureIds_.add(value);
          bitField0_ |= 0x00000002;
          onChanged();
          return this;
        }

        @java.lang.Override
        public final Builder setUnknownFields(
            final com.google.protobuf.UnknownFieldSet unknownFields) {
          return super.setUnknownFields(unknownFields);
        }

        @java.lang.Override
        public final Builder mergeUnknownFields(
            final com.google.protobuf.UnknownFieldSet unknownFields) {
          return super.mergeUnknownFields(unknownFields);
        }

        // @@protoc_insertion_point(builder_scope:google.cloud.aiplatform.v1beta1.FeatureView.FeatureRegistrySource.FeatureGroup)
      }

      // @@protoc_insertion_point(class_scope:google.cloud.aiplatform.v1beta1.FeatureView.FeatureRegistrySource.FeatureGroup)
      private static final com.google.cloud.aiplatform.v1beta1.FeatureView.FeatureRegistrySource
              .FeatureGroup
          DEFAULT_INSTANCE;

      static {
        DEFAULT_INSTANCE =
            new com.google.cloud.aiplatform.v1beta1.FeatureView.FeatureRegistrySource
                .FeatureGroup();
      }

      public static com.google.cloud.aiplatform.v1beta1.FeatureView.FeatureRegistrySource
              .FeatureGroup
          getDefaultInstance() {
        return DEFAULT_INSTANCE;
      }

      private static final com.google.protobuf.Parser<FeatureGroup> PARSER =
          new com.google.protobuf.AbstractParser<FeatureGroup>() {
            @java.lang.Override
            public FeatureGroup parsePartialFrom(
                com.google.protobuf.CodedInputStream input,
                com.google.protobuf.ExtensionRegistryLite extensionRegistry)
                throws com.google.protobuf.InvalidProtocolBufferException {
              Builder builder = newBuilder();
              try {
                builder.mergeFrom(input, extensionRegistry);
              } catch (com.google.protobuf.InvalidProtocolBufferException e) {
                throw e.setUnfinishedMessage(builder.buildPartial());
              } catch (com.google.protobuf.UninitializedMessageException e) {
                throw e.asInvalidProtocolBufferException()
                    .setUnfinishedMessage(builder.buildPartial());
              } catch (java.io.IOException e) {
                throw new com.google.protobuf.InvalidProtocolBufferException(e)
                    .setUnfinishedMessage(builder.buildPartial());
              }
              return builder.buildPartial();
            }
          };

      public static com.google.protobuf.Parser<FeatureGroup> parser() {
        return PARSER;
      }

      @java.lang.Override
      public com.google.protobuf.Parser<FeatureGroup> getParserForType() {
        return PARSER;
      }

      @java.lang.Override
      public com.google.cloud.aiplatform.v1beta1.FeatureView.FeatureRegistrySource.FeatureGroup
          getDefaultInstanceForType() {
        return DEFAULT_INSTANCE;
      }
    }

    public static final int FEATURE_GROUPS_FIELD_NUMBER = 1;

    @SuppressWarnings("serial")
    private java.util.List<
            com.google.cloud.aiplatform.v1beta1.FeatureView.FeatureRegistrySource.FeatureGroup>
        featureGroups_;
    /**
     *
     *
     * <pre>
     * Required. List of features that need to be synced to Online Store.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.aiplatform.v1beta1.FeatureView.FeatureRegistrySource.FeatureGroup feature_groups = 1 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    @java.lang.Override
    public java.util.List<
            com.google.cloud.aiplatform.v1beta1.FeatureView.FeatureRegistrySource.FeatureGroup>
        getFeatureGroupsList() {
      return featureGroups_;
    }
    /**
     *
     *
     * <pre>
     * Required. List of features that need to be synced to Online Store.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.aiplatform.v1beta1.FeatureView.FeatureRegistrySource.FeatureGroup feature_groups = 1 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    @java.lang.Override
    public java.util.List<
            ? extends
                com.google.cloud.aiplatform.v1beta1.FeatureView.FeatureRegistrySource
                    .FeatureGroupOrBuilder>
        getFeatureGroupsOrBuilderList() {
      return featureGroups_;
    }
    /**
     *
     *
     * <pre>
     * Required. List of features that need to be synced to Online Store.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.aiplatform.v1beta1.FeatureView.FeatureRegistrySource.FeatureGroup feature_groups = 1 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    @java.lang.Override
    public int getFeatureGroupsCount() {
      return featureGroups_.size();
    }
    /**
     *
     *
     * <pre>
     * Required. List of features that need to be synced to Online Store.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.aiplatform.v1beta1.FeatureView.FeatureRegistrySource.FeatureGroup feature_groups = 1 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    @java.lang.Override
    public com.google.cloud.aiplatform.v1beta1.FeatureView.FeatureRegistrySource.FeatureGroup
        getFeatureGroups(int index) {
      return featureGroups_.get(index);
    }
    /**
     *
     *
     * <pre>
     * Required. List of features that need to be synced to Online Store.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.aiplatform.v1beta1.FeatureView.FeatureRegistrySource.FeatureGroup feature_groups = 1 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    @java.lang.Override
    public com.google.cloud.aiplatform.v1beta1.FeatureView.FeatureRegistrySource
            .FeatureGroupOrBuilder
        getFeatureGroupsOrBuilder(int index) {
      return featureGroups_.get(index);
    }

    private byte memoizedIsInitialized = -1;

    @java.lang.Override
    public final boolean isInitialized() {
      byte isInitialized = memoizedIsInitialized;
      if (isInitialized == 1) return true;
      if (isInitialized == 0) return false;

      memoizedIsInitialized = 1;
      return true;
    }

    @java.lang.Override
    public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
      for (int i = 0; i < featureGroups_.size(); i++) {
        output.writeMessage(1, featureGroups_.get(i));
      }
      getUnknownFields().writeTo(output);
    }

    @java.lang.Override
    public int getSerializedSize() {
      int size = memoizedSize;
      if (size != -1) return size;

      size = 0;
      for (int i = 0; i < featureGroups_.size(); i++) {
        size += com.google.protobuf.CodedOutputStream.computeMessageSize(1, featureGroups_.get(i));
      }
      size += getUnknownFields().getSerializedSize();
      memoizedSize = size;
      return size;
    }

    @java.lang.Override
    public boolean equals(final java.lang.Object obj) {
      if (obj == this) {
        return true;
      }
      if (!(obj instanceof com.google.cloud.aiplatform.v1beta1.FeatureView.FeatureRegistrySource)) {
        return super.equals(obj);
      }
      com.google.cloud.aiplatform.v1beta1.FeatureView.FeatureRegistrySource other =
          (com.google.cloud.aiplatform.v1beta1.FeatureView.FeatureRegistrySource) obj;

      if (!getFeatureGroupsList().equals(other.getFeatureGroupsList())) return false;
      if (!getUnknownFields().equals(other.getUnknownFields())) return false;
      return true;
    }

    @java.lang.Override
    public int hashCode() {
      if (memoizedHashCode != 0) {
        return memoizedHashCode;
      }
      int hash = 41;
      hash = (19 * hash) + getDescriptor().hashCode();
      if (getFeatureGroupsCount() > 0) {
        hash = (37 * hash) + FEATURE_GROUPS_FIELD_NUMBER;
        hash = (53 * hash) + getFeatureGroupsList().hashCode();
      }
      hash = (29 * hash) + getUnknownFields().hashCode();
      memoizedHashCode = hash;
      return hash;
    }

    public static com.google.cloud.aiplatform.v1beta1.FeatureView.FeatureRegistrySource parseFrom(
        java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.aiplatform.v1beta1.FeatureView.FeatureRegistrySource parseFrom(
        java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.aiplatform.v1beta1.FeatureView.FeatureRegistrySource parseFrom(
        com.google.protobuf.ByteString data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.aiplatform.v1beta1.FeatureView.FeatureRegistrySource parseFrom(
        com.google.protobuf.ByteString data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.aiplatform.v1beta1.FeatureView.FeatureRegistrySource parseFrom(
        byte[] data) throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.aiplatform.v1beta1.FeatureView.FeatureRegistrySource parseFrom(
        byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.aiplatform.v1beta1.FeatureView.FeatureRegistrySource parseFrom(
        java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.cloud.aiplatform.v1beta1.FeatureView.FeatureRegistrySource parseFrom(
        java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.cloud.aiplatform.v1beta1.FeatureView.FeatureRegistrySource
        parseDelimitedFrom(java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
    }

    public static com.google.cloud.aiplatform.v1beta1.FeatureView.FeatureRegistrySource
        parseDelimitedFrom(
            java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.cloud.aiplatform.v1beta1.FeatureView.FeatureRegistrySource parseFrom(
        com.google.protobuf.CodedInputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.cloud.aiplatform.v1beta1.FeatureView.FeatureRegistrySource parseFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    @java.lang.Override
    public Builder newBuilderForType() {
      return newBuilder();
    }

    public static Builder newBuilder() {
      return DEFAULT_INSTANCE.toBuilder();
    }

    public static Builder newBuilder(
        com.google.cloud.aiplatform.v1beta1.FeatureView.FeatureRegistrySource prototype) {
      return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }

    @java.lang.Override
    public Builder toBuilder() {
      return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
    }

    @java.lang.Override
    protected Builder newBuilderForType(
        com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      Builder builder = new Builder(parent);
      return builder;
    }
    /**
     *
     *
     * <pre>
     * A Feature Registry source for features that need to be synced to Online
     * Store.
     * </pre>
     *
     * Protobuf type {@code google.cloud.aiplatform.v1beta1.FeatureView.FeatureRegistrySource}
     */
    public static final class Builder
        extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
        implements
        // @@protoc_insertion_point(builder_implements:google.cloud.aiplatform.v1beta1.FeatureView.FeatureRegistrySource)
        com.google.cloud.aiplatform.v1beta1.FeatureView.FeatureRegistrySourceOrBuilder {
      public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
        return com.google.cloud.aiplatform.v1beta1.FeatureViewProto
            .internal_static_google_cloud_aiplatform_v1beta1_FeatureView_FeatureRegistrySource_descriptor;
      }

      @java.lang.Override
      protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return com.google.cloud.aiplatform.v1beta1.FeatureViewProto
            .internal_static_google_cloud_aiplatform_v1beta1_FeatureView_FeatureRegistrySource_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                com.google.cloud.aiplatform.v1beta1.FeatureView.FeatureRegistrySource.class,
                com.google.cloud.aiplatform.v1beta1.FeatureView.FeatureRegistrySource.Builder
                    .class);
      }

      // Construct using
      // com.google.cloud.aiplatform.v1beta1.FeatureView.FeatureRegistrySource.newBuilder()
      private Builder() {}

      private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
        super(parent);
      }

      @java.lang.Override
      public Builder clear() {
        super.clear();
        bitField0_ = 0;
        if (featureGroupsBuilder_ == null) {
          featureGroups_ = java.util.Collections.emptyList();
        } else {
          featureGroups_ = null;
          featureGroupsBuilder_.clear();
        }
        bitField0_ = (bitField0_ & ~0x00000001);
        return this;
      }

      @java.lang.Override
      public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
        return com.google.cloud.aiplatform.v1beta1.FeatureViewProto
            .internal_static_google_cloud_aiplatform_v1beta1_FeatureView_FeatureRegistrySource_descriptor;
      }

      @java.lang.Override
      public com.google.cloud.aiplatform.v1beta1.FeatureView.FeatureRegistrySource
          getDefaultInstanceForType() {
        return com.google.cloud.aiplatform.v1beta1.FeatureView.FeatureRegistrySource
            .getDefaultInstance();
      }

      @java.lang.Override
      public com.google.cloud.aiplatform.v1beta1.FeatureView.FeatureRegistrySource build() {
        com.google.cloud.aiplatform.v1beta1.FeatureView.FeatureRegistrySource result =
            buildPartial();
        if (!result.isInitialized()) {
          throw newUninitializedMessageException(result);
        }
        return result;
      }

      @java.lang.Override
      public com.google.cloud.aiplatform.v1beta1.FeatureView.FeatureRegistrySource buildPartial() {
        com.google.cloud.aiplatform.v1beta1.FeatureView.FeatureRegistrySource result =
            new com.google.cloud.aiplatform.v1beta1.FeatureView.FeatureRegistrySource(this);
        buildPartialRepeatedFields(result);
        if (bitField0_ != 0) {
          buildPartial0(result);
        }
        onBuilt();
        return result;
      }

      private void buildPartialRepeatedFields(
          com.google.cloud.aiplatform.v1beta1.FeatureView.FeatureRegistrySource result) {
        if (featureGroupsBuilder_ == null) {
          if (((bitField0_ & 0x00000001) != 0)) {
            featureGroups_ = java.util.Collections.unmodifiableList(featureGroups_);
            bitField0_ = (bitField0_ & ~0x00000001);
          }
          result.featureGroups_ = featureGroups_;
        } else {
          result.featureGroups_ = featureGroupsBuilder_.build();
        }
      }

      private void buildPartial0(
          com.google.cloud.aiplatform.v1beta1.FeatureView.FeatureRegistrySource result) {
        int from_bitField0_ = bitField0_;
      }

      @java.lang.Override
      public Builder clone() {
        return super.clone();
      }

      @java.lang.Override
      public Builder setField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.setField(field, value);
      }

      @java.lang.Override
      public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
        return super.clearField(field);
      }

      @java.lang.Override
      public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
        return super.clearOneof(oneof);
      }

      @java.lang.Override
      public Builder setRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          int index,
          java.lang.Object value) {
        return super.setRepeatedField(field, index, value);
      }

      @java.lang.Override
      public Builder addRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.addRepeatedField(field, value);
      }

      @java.lang.Override
      public Builder mergeFrom(com.google.protobuf.Message other) {
        if (other
            instanceof com.google.cloud.aiplatform.v1beta1.FeatureView.FeatureRegistrySource) {
          return mergeFrom(
              (com.google.cloud.aiplatform.v1beta1.FeatureView.FeatureRegistrySource) other);
        } else {
          super.mergeFrom(other);
          return this;
        }
      }

      public Builder mergeFrom(
          com.google.cloud.aiplatform.v1beta1.FeatureView.FeatureRegistrySource other) {
        if (other
            == com.google.cloud.aiplatform.v1beta1.FeatureView.FeatureRegistrySource
                .getDefaultInstance()) return this;
        if (featureGroupsBuilder_ == null) {
          if (!other.featureGroups_.isEmpty()) {
            if (featureGroups_.isEmpty()) {
              featureGroups_ = other.featureGroups_;
              bitField0_ = (bitField0_ & ~0x00000001);
            } else {
              ensureFeatureGroupsIsMutable();
              featureGroups_.addAll(other.featureGroups_);
            }
            onChanged();
          }
        } else {
          if (!other.featureGroups_.isEmpty()) {
            if (featureGroupsBuilder_.isEmpty()) {
              featureGroupsBuilder_.dispose();
              featureGroupsBuilder_ = null;
              featureGroups_ = other.featureGroups_;
              bitField0_ = (bitField0_ & ~0x00000001);
              featureGroupsBuilder_ =
                  com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders
                      ? getFeatureGroupsFieldBuilder()
                      : null;
            } else {
              featureGroupsBuilder_.addAllMessages(other.featureGroups_);
            }
          }
        }
        this.mergeUnknownFields(other.getUnknownFields());
        onChanged();
        return this;
      }

      @java.lang.Override
      public final boolean isInitialized() {
        return true;
      }

      @java.lang.Override
      public Builder mergeFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        if (extensionRegistry == null) {
          throw new java.lang.NullPointerException();
        }
        try {
          boolean done = false;
          while (!done) {
            int tag = input.readTag();
            switch (tag) {
              case 0:
                done = true;
                break;
              case 10:
                {
                  com.google.cloud.aiplatform.v1beta1.FeatureView.FeatureRegistrySource.FeatureGroup
                      m =
                          input.readMessage(
                              com.google.cloud.aiplatform.v1beta1.FeatureView.FeatureRegistrySource
                                  .FeatureGroup.parser(),
                              extensionRegistry);
                  if (featureGroupsBuilder_ == null) {
                    ensureFeatureGroupsIsMutable();
                    featureGroups_.add(m);
                  } else {
                    featureGroupsBuilder_.addMessage(m);
                  }
                  break;
                } // case 10
              default:
                {
                  if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                    done = true; // was an endgroup tag
                  }
                  break;
                } // default:
            } // switch (tag)
          } // while (!done)
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          throw e.unwrapIOException();
        } finally {
          onChanged();
        } // finally
        return this;
      }

      private int bitField0_;

      private java.util.List<
              com.google.cloud.aiplatform.v1beta1.FeatureView.FeatureRegistrySource.FeatureGroup>
          featureGroups_ = java.util.Collections.emptyList();

      private void ensureFeatureGroupsIsMutable() {
        if (!((bitField0_ & 0x00000001) != 0)) {
          featureGroups_ =
              new java.util.ArrayList<
                  com.google.cloud.aiplatform.v1beta1.FeatureView.FeatureRegistrySource
                      .FeatureGroup>(featureGroups_);
          bitField0_ |= 0x00000001;
        }
      }

      private com.google.protobuf.RepeatedFieldBuilderV3<
              com.google.cloud.aiplatform.v1beta1.FeatureView.FeatureRegistrySource.FeatureGroup,
              com.google.cloud.aiplatform.v1beta1.FeatureView.FeatureRegistrySource.FeatureGroup
                  .Builder,
              com.google.cloud.aiplatform.v1beta1.FeatureView.FeatureRegistrySource
                  .FeatureGroupOrBuilder>
          featureGroupsBuilder_;

      /**
       *
       *
       * <pre>
       * Required. List of features that need to be synced to Online Store.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.aiplatform.v1beta1.FeatureView.FeatureRegistrySource.FeatureGroup feature_groups = 1 [(.google.api.field_behavior) = REQUIRED];
       * </code>
       */
      public java.util.List<
              com.google.cloud.aiplatform.v1beta1.FeatureView.FeatureRegistrySource.FeatureGroup>
          getFeatureGroupsList() {
        if (featureGroupsBuilder_ == null) {
          return java.util.Collections.unmodifiableList(featureGroups_);
        } else {
          return featureGroupsBuilder_.getMessageList();
        }
      }
      /**
       *
       *
       * <pre>
       * Required. List of features that need to be synced to Online Store.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.aiplatform.v1beta1.FeatureView.FeatureRegistrySource.FeatureGroup feature_groups = 1 [(.google.api.field_behavior) = REQUIRED];
       * </code>
       */
      public int getFeatureGroupsCount() {
        if (featureGroupsBuilder_ == null) {
          return featureGroups_.size();
        } else {
          return featureGroupsBuilder_.getCount();
        }
      }
      /**
       *
       *
       * <pre>
       * Required. List of features that need to be synced to Online Store.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.aiplatform.v1beta1.FeatureView.FeatureRegistrySource.FeatureGroup feature_groups = 1 [(.google.api.field_behavior) = REQUIRED];
       * </code>
       */
      public com.google.cloud.aiplatform.v1beta1.FeatureView.FeatureRegistrySource.FeatureGroup
          getFeatureGroups(int index) {
        if (featureGroupsBuilder_ == null) {
          return featureGroups_.get(index);
        } else {
          return featureGroupsBuilder_.getMessage(index);
        }
      }
      /**
       *
       *
       * <pre>
       * Required. List of features that need to be synced to Online Store.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.aiplatform.v1beta1.FeatureView.FeatureRegistrySource.FeatureGroup feature_groups = 1 [(.google.api.field_behavior) = REQUIRED];
       * </code>
       */
      public Builder setFeatureGroups(
          int index,
          com.google.cloud.aiplatform.v1beta1.FeatureView.FeatureRegistrySource.FeatureGroup
              value) {
        if (featureGroupsBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          ensureFeatureGroupsIsMutable();
          featureGroups_.set(index, value);
          onChanged();
        } else {
          featureGroupsBuilder_.setMessage(index, value);
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * Required. List of features that need to be synced to Online Store.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.aiplatform.v1beta1.FeatureView.FeatureRegistrySource.FeatureGroup feature_groups = 1 [(.google.api.field_behavior) = REQUIRED];
       * </code>
       */
      public Builder setFeatureGroups(
          int index,
          com.google.cloud.aiplatform.v1beta1.FeatureView.FeatureRegistrySource.FeatureGroup.Builder
              builderForValue) {
        if (featureGroupsBuilder_ == null) {
          ensureFeatureGroupsIsMutable();
          featureGroups_.set(index, builderForValue.build());
          onChanged();
        } else {
          featureGroupsBuilder_.setMessage(index, builderForValue.build());
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * Required. List of features that need to be synced to Online Store.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.aiplatform.v1beta1.FeatureView.FeatureRegistrySource.FeatureGroup feature_groups = 1 [(.google.api.field_behavior) = REQUIRED];
       * </code>
       */
      public Builder addFeatureGroups(
          com.google.cloud.aiplatform.v1beta1.FeatureView.FeatureRegistrySource.FeatureGroup
              value) {
        if (featureGroupsBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          ensureFeatureGroupsIsMutable();
          featureGroups_.add(value);
          onChanged();
        } else {
          featureGroupsBuilder_.addMessage(value);
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * Required. List of features that need to be synced to Online Store.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.aiplatform.v1beta1.FeatureView.FeatureRegistrySource.FeatureGroup feature_groups = 1 [(.google.api.field_behavior) = REQUIRED];
       * </code>
       */
      public Builder addFeatureGroups(
          int index,
          com.google.cloud.aiplatform.v1beta1.FeatureView.FeatureRegistrySource.FeatureGroup
              value) {
        if (featureGroupsBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          ensureFeatureGroupsIsMutable();
          featureGroups_.add(index, value);
          onChanged();
        } else {
          featureGroupsBuilder_.addMessage(index, value);
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * Required. List of features that need to be synced to Online Store.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.aiplatform.v1beta1.FeatureView.FeatureRegistrySource.FeatureGroup feature_groups = 1 [(.google.api.field_behavior) = REQUIRED];
       * </code>
       */
      public Builder addFeatureGroups(
          com.google.cloud.aiplatform.v1beta1.FeatureView.FeatureRegistrySource.FeatureGroup.Builder
              builderForValue) {
        if (featureGroupsBuilder_ == null) {
          ensureFeatureGroupsIsMutable();
          featureGroups_.add(builderForValue.build());
          onChanged();
        } else {
          featureGroupsBuilder_.addMessage(builderForValue.build());
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * Required. List of features that need to be synced to Online Store.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.aiplatform.v1beta1.FeatureView.FeatureRegistrySource.FeatureGroup feature_groups = 1 [(.google.api.field_behavior) = REQUIRED];
       * </code>
       */
      public Builder addFeatureGroups(
          int index,
          com.google.cloud.aiplatform.v1beta1.FeatureView.FeatureRegistrySource.FeatureGroup.Builder
              builderForValue) {
        if (featureGroupsBuilder_ == null) {
          ensureFeatureGroupsIsMutable();
          featureGroups_.add(index, builderForValue.build());
          onChanged();
        } else {
          featureGroupsBuilder_.addMessage(index, builderForValue.build());
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * Required. List of features that need to be synced to Online Store.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.aiplatform.v1beta1.FeatureView.FeatureRegistrySource.FeatureGroup feature_groups = 1 [(.google.api.field_behavior) = REQUIRED];
       * </code>
       */
      public Builder addAllFeatureGroups(
          java.lang.Iterable<
                  ? extends
                      com.google.cloud.aiplatform.v1beta1.FeatureView.FeatureRegistrySource
                          .FeatureGroup>
              values) {
        if (featureGroupsBuilder_ == null) {
          ensureFeatureGroupsIsMutable();
          com.google.protobuf.AbstractMessageLite.Builder.addAll(values, featureGroups_);
          onChanged();
        } else {
          featureGroupsBuilder_.addAllMessages(values);
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * Required. List of features that need to be synced to Online Store.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.aiplatform.v1beta1.FeatureView.FeatureRegistrySource.FeatureGroup feature_groups = 1 [(.google.api.field_behavior) = REQUIRED];
       * </code>
       */
      public Builder clearFeatureGroups() {
        if (featureGroupsBuilder_ == null) {
          featureGroups_ = java.util.Collections.emptyList();
          bitField0_ = (bitField0_ & ~0x00000001);
          onChanged();
        } else {
          featureGroupsBuilder_.clear();
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * Required. List of features that need to be synced to Online Store.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.aiplatform.v1beta1.FeatureView.FeatureRegistrySource.FeatureGroup feature_groups = 1 [(.google.api.field_behavior) = REQUIRED];
       * </code>
       */
      public Builder removeFeatureGroups(int index) {
        if (featureGroupsBuilder_ == null) {
          ensureFeatureGroupsIsMutable();
          featureGroups_.remove(index);
          onChanged();
        } else {
          featureGroupsBuilder_.remove(index);
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * Required. List of features that need to be synced to Online Store.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.aiplatform.v1beta1.FeatureView.FeatureRegistrySource.FeatureGroup feature_groups = 1 [(.google.api.field_behavior) = REQUIRED];
       * </code>
       */
      public com.google.cloud.aiplatform.v1beta1.FeatureView.FeatureRegistrySource.FeatureGroup
              .Builder
          getFeatureGroupsBuilder(int index) {
        return getFeatureGroupsFieldBuilder().getBuilder(index);
      }
      /**
       *
       *
       * <pre>
       * Required. List of features that need to be synced to Online Store.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.aiplatform.v1beta1.FeatureView.FeatureRegistrySource.FeatureGroup feature_groups = 1 [(.google.api.field_behavior) = REQUIRED];
       * </code>
       */
      public com.google.cloud.aiplatform.v1beta1.FeatureView.FeatureRegistrySource
              .FeatureGroupOrBuilder
          getFeatureGroupsOrBuilder(int index) {
        if (featureGroupsBuilder_ == null) {
          return featureGroups_.get(index);
        } else {
          return featureGroupsBuilder_.getMessageOrBuilder(index);
        }
      }
      /**
       *
       *
       * <pre>
       * Required. List of features that need to be synced to Online Store.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.aiplatform.v1beta1.FeatureView.FeatureRegistrySource.FeatureGroup feature_groups = 1 [(.google.api.field_behavior) = REQUIRED];
       * </code>
       */
      public java.util.List<
              ? extends
                  com.google.cloud.aiplatform.v1beta1.FeatureView.FeatureRegistrySource
                      .FeatureGroupOrBuilder>
          getFeatureGroupsOrBuilderList() {
        if (featureGroupsBuilder_ != null) {
          return featureGroupsBuilder_.getMessageOrBuilderList();
        } else {
          return java.util.Collections.unmodifiableList(featureGroups_);
        }
      }
      /**
       *
       *
       * <pre>
       * Required. List of features that need to be synced to Online Store.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.aiplatform.v1beta1.FeatureView.FeatureRegistrySource.FeatureGroup feature_groups = 1 [(.google.api.field_behavior) = REQUIRED];
       * </code>
       */
      public com.google.cloud.aiplatform.v1beta1.FeatureView.FeatureRegistrySource.FeatureGroup
              .Builder
          addFeatureGroupsBuilder() {
        return getFeatureGroupsFieldBuilder()
            .addBuilder(
                com.google.cloud.aiplatform.v1beta1.FeatureView.FeatureRegistrySource.FeatureGroup
                    .getDefaultInstance());
      }
      /**
       *
       *
       * <pre>
       * Required. List of features that need to be synced to Online Store.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.aiplatform.v1beta1.FeatureView.FeatureRegistrySource.FeatureGroup feature_groups = 1 [(.google.api.field_behavior) = REQUIRED];
       * </code>
       */
      public com.google.cloud.aiplatform.v1beta1.FeatureView.FeatureRegistrySource.FeatureGroup
              .Builder
          addFeatureGroupsBuilder(int index) {
        return getFeatureGroupsFieldBuilder()
            .addBuilder(
                index,
                com.google.cloud.aiplatform.v1beta1.FeatureView.FeatureRegistrySource.FeatureGroup
                    .getDefaultInstance());
      }
      /**
       *
       *
       * <pre>
       * Required. List of features that need to be synced to Online Store.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.aiplatform.v1beta1.FeatureView.FeatureRegistrySource.FeatureGroup feature_groups = 1 [(.google.api.field_behavior) = REQUIRED];
       * </code>
       */
      public java.util.List<
              com.google.cloud.aiplatform.v1beta1.FeatureView.FeatureRegistrySource.FeatureGroup
                  .Builder>
          getFeatureGroupsBuilderList() {
        return getFeatureGroupsFieldBuilder().getBuilderList();
      }

      private com.google.protobuf.RepeatedFieldBuilderV3<
              com.google.cloud.aiplatform.v1beta1.FeatureView.FeatureRegistrySource.FeatureGroup,
              com.google.cloud.aiplatform.v1beta1.FeatureView.FeatureRegistrySource.FeatureGroup
                  .Builder,
              com.google.cloud.aiplatform.v1beta1.FeatureView.FeatureRegistrySource
                  .FeatureGroupOrBuilder>
          getFeatureGroupsFieldBuilder() {
        if (featureGroupsBuilder_ == null) {
          featureGroupsBuilder_ =
              new com.google.protobuf.RepeatedFieldBuilderV3<
                  com.google.cloud.aiplatform.v1beta1.FeatureView.FeatureRegistrySource
                      .FeatureGroup,
                  com.google.cloud.aiplatform.v1beta1.FeatureView.FeatureRegistrySource.FeatureGroup
                      .Builder,
                  com.google.cloud.aiplatform.v1beta1.FeatureView.FeatureRegistrySource
                      .FeatureGroupOrBuilder>(
                  featureGroups_,
                  ((bitField0_ & 0x00000001) != 0),
                  getParentForChildren(),
                  isClean());
          featureGroups_ = null;
        }
        return featureGroupsBuilder_;
      }

      @java.lang.Override
      public final Builder setUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.setUnknownFields(unknownFields);
      }

      @java.lang.Override
      public final Builder mergeUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.mergeUnknownFields(unknownFields);
      }

      // @@protoc_insertion_point(builder_scope:google.cloud.aiplatform.v1beta1.FeatureView.FeatureRegistrySource)
    }

    // @@protoc_insertion_point(class_scope:google.cloud.aiplatform.v1beta1.FeatureView.FeatureRegistrySource)
    private static final com.google.cloud.aiplatform.v1beta1.FeatureView.FeatureRegistrySource
        DEFAULT_INSTANCE;

    static {
      DEFAULT_INSTANCE =
          new com.google.cloud.aiplatform.v1beta1.FeatureView.FeatureRegistrySource();
    }

    public static com.google.cloud.aiplatform.v1beta1.FeatureView.FeatureRegistrySource
        getDefaultInstance() {
      return DEFAULT_INSTANCE;
    }

    private static final com.google.protobuf.Parser<FeatureRegistrySource> PARSER =
        new com.google.protobuf.AbstractParser<FeatureRegistrySource>() {
          @java.lang.Override
          public FeatureRegistrySource parsePartialFrom(
              com.google.protobuf.CodedInputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
            Builder builder = newBuilder();
            try {
              builder.mergeFrom(input, extensionRegistry);
            } catch (com.google.protobuf.InvalidProtocolBufferException e) {
              throw e.setUnfinishedMessage(builder.buildPartial());
            } catch (com.google.protobuf.UninitializedMessageException e) {
              throw e.asInvalidProtocolBufferException()
                  .setUnfinishedMessage(builder.buildPartial());
            } catch (java.io.IOException e) {
              throw new com.google.protobuf.InvalidProtocolBufferException(e)
                  .setUnfinishedMessage(builder.buildPartial());
            }
            return builder.buildPartial();
          }
        };

    public static com.google.protobuf.Parser<FeatureRegistrySource> parser() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.protobuf.Parser<FeatureRegistrySource> getParserForType() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.cloud.aiplatform.v1beta1.FeatureView.FeatureRegistrySource
        getDefaultInstanceForType() {
      return DEFAULT_INSTANCE;
    }
  }

  private int bitField0_;
  private int sourceCase_ = 0;

  @SuppressWarnings("serial")
  private java.lang.Object source_;

  public enum SourceCase
      implements
          com.google.protobuf.Internal.EnumLite,
          com.google.protobuf.AbstractMessage.InternalOneOfEnum {
    BIG_QUERY_SOURCE(6),
    FEATURE_REGISTRY_SOURCE(9),
    SOURCE_NOT_SET(0);
    private final int value;

    private SourceCase(int value) {
      this.value = value;
    }
    /**
     * @param value The number of the enum to look for.
     * @return The enum associated with the given number.
     * @deprecated Use {@link #forNumber(int)} instead.
     */
    @java.lang.Deprecated
    public static SourceCase valueOf(int value) {
      return forNumber(value);
    }

    public static SourceCase forNumber(int value) {
      switch (value) {
        case 6:
          return BIG_QUERY_SOURCE;
        case 9:
          return FEATURE_REGISTRY_SOURCE;
        case 0:
          return SOURCE_NOT_SET;
        default:
          return null;
      }
    }

    public int getNumber() {
      return this.value;
    }
  };

  public SourceCase getSourceCase() {
    return SourceCase.forNumber(sourceCase_);
  }

  public static final int BIG_QUERY_SOURCE_FIELD_NUMBER = 6;
  /**
   *
   *
   * <pre>
   * Optional. Configures how data is supposed to be extracted from a BigQuery
   * source to be loaded onto the FeatureOnlineStore.
   * </pre>
   *
   * <code>
   * .google.cloud.aiplatform.v1beta1.FeatureView.BigQuerySource big_query_source = 6 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   *
   * @return Whether the bigQuerySource field is set.
   */
  @java.lang.Override
  public boolean hasBigQuerySource() {
    return sourceCase_ == 6;
  }
  /**
   *
   *
   * <pre>
   * Optional. Configures how data is supposed to be extracted from a BigQuery
   * source to be loaded onto the FeatureOnlineStore.
   * </pre>
   *
   * <code>
   * .google.cloud.aiplatform.v1beta1.FeatureView.BigQuerySource big_query_source = 6 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   *
   * @return The bigQuerySource.
   */
  @java.lang.Override
  public com.google.cloud.aiplatform.v1beta1.FeatureView.BigQuerySource getBigQuerySource() {
    if (sourceCase_ == 6) {
      return (com.google.cloud.aiplatform.v1beta1.FeatureView.BigQuerySource) source_;
    }
    return com.google.cloud.aiplatform.v1beta1.FeatureView.BigQuerySource.getDefaultInstance();
  }
  /**
   *
   *
   * <pre>
   * Optional. Configures how data is supposed to be extracted from a BigQuery
   * source to be loaded onto the FeatureOnlineStore.
   * </pre>
   *
   * <code>
   * .google.cloud.aiplatform.v1beta1.FeatureView.BigQuerySource big_query_source = 6 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.aiplatform.v1beta1.FeatureView.BigQuerySourceOrBuilder
      getBigQuerySourceOrBuilder() {
    if (sourceCase_ == 6) {
      return (com.google.cloud.aiplatform.v1beta1.FeatureView.BigQuerySource) source_;
    }
    return com.google.cloud.aiplatform.v1beta1.FeatureView.BigQuerySource.getDefaultInstance();
  }

  public static final int FEATURE_REGISTRY_SOURCE_FIELD_NUMBER = 9;
  /**
   *
   *
   * <pre>
   * Optional. Configures the features from a Feature Registry source that
   * need to be loaded onto the FeatureOnlineStore.
   * </pre>
   *
   * <code>
   * .google.cloud.aiplatform.v1beta1.FeatureView.FeatureRegistrySource feature_registry_source = 9 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   *
   * @return Whether the featureRegistrySource field is set.
   */
  @java.lang.Override
  public boolean hasFeatureRegistrySource() {
    return sourceCase_ == 9;
  }
  /**
   *
   *
   * <pre>
   * Optional. Configures the features from a Feature Registry source that
   * need to be loaded onto the FeatureOnlineStore.
   * </pre>
   *
   * <code>
   * .google.cloud.aiplatform.v1beta1.FeatureView.FeatureRegistrySource feature_registry_source = 9 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   *
   * @return The featureRegistrySource.
   */
  @java.lang.Override
  public com.google.cloud.aiplatform.v1beta1.FeatureView.FeatureRegistrySource
      getFeatureRegistrySource() {
    if (sourceCase_ == 9) {
      return (com.google.cloud.aiplatform.v1beta1.FeatureView.FeatureRegistrySource) source_;
    }
    return com.google.cloud.aiplatform.v1beta1.FeatureView.FeatureRegistrySource
        .getDefaultInstance();
  }
  /**
   *
   *
   * <pre>
   * Optional. Configures the features from a Feature Registry source that
   * need to be loaded onto the FeatureOnlineStore.
   * </pre>
   *
   * <code>
   * .google.cloud.aiplatform.v1beta1.FeatureView.FeatureRegistrySource feature_registry_source = 9 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.aiplatform.v1beta1.FeatureView.FeatureRegistrySourceOrBuilder
      getFeatureRegistrySourceOrBuilder() {
    if (sourceCase_ == 9) {
      return (com.google.cloud.aiplatform.v1beta1.FeatureView.FeatureRegistrySource) source_;
    }
    return com.google.cloud.aiplatform.v1beta1.FeatureView.FeatureRegistrySource
        .getDefaultInstance();
  }

  public static final int NAME_FIELD_NUMBER = 1;

  @SuppressWarnings("serial")
  private volatile java.lang.Object name_ = "";
  /**
   *
   *
   * <pre>
   * Identifier. Name of the FeatureView. Format:
   * `projects/{project}/locations/{location}/featureOnlineStores/{feature_online_store}/featureViews/{feature_view}`
   * </pre>
   *
   * <code>string name = 1 [(.google.api.field_behavior) = IDENTIFIER];</code>
   *
   * @return The name.
   */
  @java.lang.Override
  public java.lang.String getName() {
    java.lang.Object ref = name_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      name_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Identifier. Name of the FeatureView. Format:
   * `projects/{project}/locations/{location}/featureOnlineStores/{feature_online_store}/featureViews/{feature_view}`
   * </pre>
   *
   * <code>string name = 1 [(.google.api.field_behavior) = IDENTIFIER];</code>
   *
   * @return The bytes for name.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getNameBytes() {
    java.lang.Object ref = name_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      name_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int CREATE_TIME_FIELD_NUMBER = 2;
  private com.google.protobuf.Timestamp createTime_;
  /**
   *
   *
   * <pre>
   * Output only. Timestamp when this FeatureView was created.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp create_time = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return Whether the createTime field is set.
   */
  @java.lang.Override
  public boolean hasCreateTime() {
    return ((bitField0_ & 0x00000001) != 0);
  }
  /**
   *
   *
   * <pre>
   * Output only. Timestamp when this FeatureView was created.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp create_time = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return The createTime.
   */
  @java.lang.Override
  public com.google.protobuf.Timestamp getCreateTime() {
    return createTime_ == null ? com.google.protobuf.Timestamp.getDefaultInstance() : createTime_;
  }
  /**
   *
   *
   * <pre>
   * Output only. Timestamp when this FeatureView was created.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp create_time = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   */
  @java.lang.Override
  public com.google.protobuf.TimestampOrBuilder getCreateTimeOrBuilder() {
    return createTime_ == null ? com.google.protobuf.Timestamp.getDefaultInstance() : createTime_;
  }

  public static final int UPDATE_TIME_FIELD_NUMBER = 3;
  private com.google.protobuf.Timestamp updateTime_;
  /**
   *
   *
   * <pre>
   * Output only. Timestamp when this FeatureView was last updated.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp update_time = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return Whether the updateTime field is set.
   */
  @java.lang.Override
  public boolean hasUpdateTime() {
    return ((bitField0_ & 0x00000002) != 0);
  }
  /**
   *
   *
   * <pre>
   * Output only. Timestamp when this FeatureView was last updated.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp update_time = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return The updateTime.
   */
  @java.lang.Override
  public com.google.protobuf.Timestamp getUpdateTime() {
    return updateTime_ == null ? com.google.protobuf.Timestamp.getDefaultInstance() : updateTime_;
  }
  /**
   *
   *
   * <pre>
   * Output only. Timestamp when this FeatureView was last updated.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp update_time = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   */
  @java.lang.Override
  public com.google.protobuf.TimestampOrBuilder getUpdateTimeOrBuilder() {
    return updateTime_ == null ? com.google.protobuf.Timestamp.getDefaultInstance() : updateTime_;
  }

  public static final int ETAG_FIELD_NUMBER = 4;

  @SuppressWarnings("serial")
  private volatile java.lang.Object etag_ = "";
  /**
   *
   *
   * <pre>
   * Optional. Used to perform consistent read-modify-write updates. If not set,
   * a blind "overwrite" update happens.
   * </pre>
   *
   * <code>string etag = 4 [(.google.api.field_behavior) = OPTIONAL];</code>
   *
   * @return The etag.
   */
  @java.lang.Override
  public java.lang.String getEtag() {
    java.lang.Object ref = etag_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      etag_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Optional. Used to perform consistent read-modify-write updates. If not set,
   * a blind "overwrite" update happens.
   * </pre>
   *
   * <code>string etag = 4 [(.google.api.field_behavior) = OPTIONAL];</code>
   *
   * @return The bytes for etag.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getEtagBytes() {
    java.lang.Object ref = etag_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      etag_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int LABELS_FIELD_NUMBER = 5;

  private static final class LabelsDefaultEntryHolder {
    static final com.google.protobuf.MapEntry<java.lang.String, java.lang.String> defaultEntry =
        com.google.protobuf.MapEntry.<java.lang.String, java.lang.String>newDefaultInstance(
            com.google.cloud.aiplatform.v1beta1.FeatureViewProto
                .internal_static_google_cloud_aiplatform_v1beta1_FeatureView_LabelsEntry_descriptor,
            com.google.protobuf.WireFormat.FieldType.STRING,
            "",
            com.google.protobuf.WireFormat.FieldType.STRING,
            "");
  }

  @SuppressWarnings("serial")
  private com.google.protobuf.MapField<java.lang.String, java.lang.String> labels_;

  private com.google.protobuf.MapField<java.lang.String, java.lang.String> internalGetLabels() {
    if (labels_ == null) {
      return com.google.protobuf.MapField.emptyMapField(LabelsDefaultEntryHolder.defaultEntry);
    }
    return labels_;
  }

  public int getLabelsCount() {
    return internalGetLabels().getMap().size();
  }
  /**
   *
   *
   * <pre>
   * Optional. The labels with user-defined metadata to organize your
   * FeatureViews.
   *
   * Label keys and values can be no longer than 64 characters
   * (Unicode codepoints), can only contain lowercase letters, numeric
   * characters, underscores and dashes. International characters are allowed.
   *
   * See https://goo.gl/xmQnxf for more information on and examples of labels.
   * No more than 64 user labels can be associated with one
   * FeatureOnlineStore(System labels are excluded)." System reserved label keys
   * are prefixed with "aiplatform.googleapis.com/" and are immutable.
   * </pre>
   *
   * <code>map&lt;string, string&gt; labels = 5 [(.google.api.field_behavior) = OPTIONAL];</code>
   */
  @java.lang.Override
  public boolean containsLabels(java.lang.String key) {
    if (key == null) {
      throw new NullPointerException("map key");
    }
    return internalGetLabels().getMap().containsKey(key);
  }
  /** Use {@link #getLabelsMap()} instead. */
  @java.lang.Override
  @java.lang.Deprecated
  public java.util.Map<java.lang.String, java.lang.String> getLabels() {
    return getLabelsMap();
  }
  /**
   *
   *
   * <pre>
   * Optional. The labels with user-defined metadata to organize your
   * FeatureViews.
   *
   * Label keys and values can be no longer than 64 characters
   * (Unicode codepoints), can only contain lowercase letters, numeric
   * characters, underscores and dashes. International characters are allowed.
   *
   * See https://goo.gl/xmQnxf for more information on and examples of labels.
   * No more than 64 user labels can be associated with one
   * FeatureOnlineStore(System labels are excluded)." System reserved label keys
   * are prefixed with "aiplatform.googleapis.com/" and are immutable.
   * </pre>
   *
   * <code>map&lt;string, string&gt; labels = 5 [(.google.api.field_behavior) = OPTIONAL];</code>
   */
  @java.lang.Override
  public java.util.Map<java.lang.String, java.lang.String> getLabelsMap() {
    return internalGetLabels().getMap();
  }
  /**
   *
   *
   * <pre>
   * Optional. The labels with user-defined metadata to organize your
   * FeatureViews.
   *
   * Label keys and values can be no longer than 64 characters
   * (Unicode codepoints), can only contain lowercase letters, numeric
   * characters, underscores and dashes. International characters are allowed.
   *
   * See https://goo.gl/xmQnxf for more information on and examples of labels.
   * No more than 64 user labels can be associated with one
   * FeatureOnlineStore(System labels are excluded)." System reserved label keys
   * are prefixed with "aiplatform.googleapis.com/" and are immutable.
   * </pre>
   *
   * <code>map&lt;string, string&gt; labels = 5 [(.google.api.field_behavior) = OPTIONAL];</code>
   */
  @java.lang.Override
  public /* nullable */ java.lang.String getLabelsOrDefault(
      java.lang.String key,
      /* nullable */
      java.lang.String defaultValue) {
    if (key == null) {
      throw new NullPointerException("map key");
    }
    java.util.Map<java.lang.String, java.lang.String> map = internalGetLabels().getMap();
    return map.containsKey(key) ? map.get(key) : defaultValue;
  }
  /**
   *
   *
   * <pre>
   * Optional. The labels with user-defined metadata to organize your
   * FeatureViews.
   *
   * Label keys and values can be no longer than 64 characters
   * (Unicode codepoints), can only contain lowercase letters, numeric
   * characters, underscores and dashes. International characters are allowed.
   *
   * See https://goo.gl/xmQnxf for more information on and examples of labels.
   * No more than 64 user labels can be associated with one
   * FeatureOnlineStore(System labels are excluded)." System reserved label keys
   * are prefixed with "aiplatform.googleapis.com/" and are immutable.
   * </pre>
   *
   * <code>map&lt;string, string&gt; labels = 5 [(.google.api.field_behavior) = OPTIONAL];</code>
   */
  @java.lang.Override
  public java.lang.String getLabelsOrThrow(java.lang.String key) {
    if (key == null) {
      throw new NullPointerException("map key");
    }
    java.util.Map<java.lang.String, java.lang.String> map = internalGetLabels().getMap();
    if (!map.containsKey(key)) {
      throw new java.lang.IllegalArgumentException();
    }
    return map.get(key);
  }

  public static final int SYNC_CONFIG_FIELD_NUMBER = 7;
  private com.google.cloud.aiplatform.v1beta1.FeatureView.SyncConfig syncConfig_;
  /**
   *
   *
   * <pre>
   * Configures when data is to be synced/updated for this FeatureView. At the
   * end of the sync the latest featureValues for each entityId of this
   * FeatureView are made ready for online serving.
   * </pre>
   *
   * <code>.google.cloud.aiplatform.v1beta1.FeatureView.SyncConfig sync_config = 7;</code>
   *
   * @return Whether the syncConfig field is set.
   */
  @java.lang.Override
  public boolean hasSyncConfig() {
    return ((bitField0_ & 0x00000004) != 0);
  }
  /**
   *
   *
   * <pre>
   * Configures when data is to be synced/updated for this FeatureView. At the
   * end of the sync the latest featureValues for each entityId of this
   * FeatureView are made ready for online serving.
   * </pre>
   *
   * <code>.google.cloud.aiplatform.v1beta1.FeatureView.SyncConfig sync_config = 7;</code>
   *
   * @return The syncConfig.
   */
  @java.lang.Override
  public com.google.cloud.aiplatform.v1beta1.FeatureView.SyncConfig getSyncConfig() {
    return syncConfig_ == null
        ? com.google.cloud.aiplatform.v1beta1.FeatureView.SyncConfig.getDefaultInstance()
        : syncConfig_;
  }
  /**
   *
   *
   * <pre>
   * Configures when data is to be synced/updated for this FeatureView. At the
   * end of the sync the latest featureValues for each entityId of this
   * FeatureView are made ready for online serving.
   * </pre>
   *
   * <code>.google.cloud.aiplatform.v1beta1.FeatureView.SyncConfig sync_config = 7;</code>
   */
  @java.lang.Override
  public com.google.cloud.aiplatform.v1beta1.FeatureView.SyncConfigOrBuilder
      getSyncConfigOrBuilder() {
    return syncConfig_ == null
        ? com.google.cloud.aiplatform.v1beta1.FeatureView.SyncConfig.getDefaultInstance()
        : syncConfig_;
  }

  public static final int VECTOR_SEARCH_CONFIG_FIELD_NUMBER = 8;
  private com.google.cloud.aiplatform.v1beta1.FeatureView.VectorSearchConfig vectorSearchConfig_;
  /**
   *
   *
   * <pre>
   * Optional. Configuration for vector search. It contains the required
   * configurations to create an index from source data, so that approximate
   * nearest neighbor (a.k.a ANN) algorithms search can be performed during
   * online serving.
   * </pre>
   *
   * <code>
   * .google.cloud.aiplatform.v1beta1.FeatureView.VectorSearchConfig vector_search_config = 8 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   *
   * @return Whether the vectorSearchConfig field is set.
   */
  @java.lang.Override
  public boolean hasVectorSearchConfig() {
    return ((bitField0_ & 0x00000008) != 0);
  }
  /**
   *
   *
   * <pre>
   * Optional. Configuration for vector search. It contains the required
   * configurations to create an index from source data, so that approximate
   * nearest neighbor (a.k.a ANN) algorithms search can be performed during
   * online serving.
   * </pre>
   *
   * <code>
   * .google.cloud.aiplatform.v1beta1.FeatureView.VectorSearchConfig vector_search_config = 8 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   *
   * @return The vectorSearchConfig.
   */
  @java.lang.Override
  public com.google.cloud.aiplatform.v1beta1.FeatureView.VectorSearchConfig
      getVectorSearchConfig() {
    return vectorSearchConfig_ == null
        ? com.google.cloud.aiplatform.v1beta1.FeatureView.VectorSearchConfig.getDefaultInstance()
        : vectorSearchConfig_;
  }
  /**
   *
   *
   * <pre>
   * Optional. Configuration for vector search. It contains the required
   * configurations to create an index from source data, so that approximate
   * nearest neighbor (a.k.a ANN) algorithms search can be performed during
   * online serving.
   * </pre>
   *
   * <code>
   * .google.cloud.aiplatform.v1beta1.FeatureView.VectorSearchConfig vector_search_config = 8 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.aiplatform.v1beta1.FeatureView.VectorSearchConfigOrBuilder
      getVectorSearchConfigOrBuilder() {
    return vectorSearchConfig_ == null
        ? com.google.cloud.aiplatform.v1beta1.FeatureView.VectorSearchConfig.getDefaultInstance()
        : vectorSearchConfig_;
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(name_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 1, name_);
    }
    if (((bitField0_ & 0x00000001) != 0)) {
      output.writeMessage(2, getCreateTime());
    }
    if (((bitField0_ & 0x00000002) != 0)) {
      output.writeMessage(3, getUpdateTime());
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(etag_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 4, etag_);
    }
    com.google.protobuf.GeneratedMessageV3.serializeStringMapTo(
        output, internalGetLabels(), LabelsDefaultEntryHolder.defaultEntry, 5);
    if (sourceCase_ == 6) {
      output.writeMessage(
          6, (com.google.cloud.aiplatform.v1beta1.FeatureView.BigQuerySource) source_);
    }
    if (((bitField0_ & 0x00000004) != 0)) {
      output.writeMessage(7, getSyncConfig());
    }
    if (((bitField0_ & 0x00000008) != 0)) {
      output.writeMessage(8, getVectorSearchConfig());
    }
    if (sourceCase_ == 9) {
      output.writeMessage(
          9, (com.google.cloud.aiplatform.v1beta1.FeatureView.FeatureRegistrySource) source_);
    }
    getUnknownFields().writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(name_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(1, name_);
    }
    if (((bitField0_ & 0x00000001) != 0)) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(2, getCreateTime());
    }
    if (((bitField0_ & 0x00000002) != 0)) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(3, getUpdateTime());
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(etag_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(4, etag_);
    }
    for (java.util.Map.Entry<java.lang.String, java.lang.String> entry :
        internalGetLabels().getMap().entrySet()) {
      com.google.protobuf.MapEntry<java.lang.String, java.lang.String> labels__ =
          LabelsDefaultEntryHolder.defaultEntry
              .newBuilderForType()
              .setKey(entry.getKey())
              .setValue(entry.getValue())
              .build();
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(5, labels__);
    }
    if (sourceCase_ == 6) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(
              6, (com.google.cloud.aiplatform.v1beta1.FeatureView.BigQuerySource) source_);
    }
    if (((bitField0_ & 0x00000004) != 0)) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(7, getSyncConfig());
    }
    if (((bitField0_ & 0x00000008) != 0)) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(8, getVectorSearchConfig());
    }
    if (sourceCase_ == 9) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(
              9, (com.google.cloud.aiplatform.v1beta1.FeatureView.FeatureRegistrySource) source_);
    }
    size += getUnknownFields().getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.cloud.aiplatform.v1beta1.FeatureView)) {
      return super.equals(obj);
    }
    com.google.cloud.aiplatform.v1beta1.FeatureView other =
        (com.google.cloud.aiplatform.v1beta1.FeatureView) obj;

    if (!getName().equals(other.getName())) return false;
    if (hasCreateTime() != other.hasCreateTime()) return false;
    if (hasCreateTime()) {
      if (!getCreateTime().equals(other.getCreateTime())) return false;
    }
    if (hasUpdateTime() != other.hasUpdateTime()) return false;
    if (hasUpdateTime()) {
      if (!getUpdateTime().equals(other.getUpdateTime())) return false;
    }
    if (!getEtag().equals(other.getEtag())) return false;
    if (!internalGetLabels().equals(other.internalGetLabels())) return false;
    if (hasSyncConfig() != other.hasSyncConfig()) return false;
    if (hasSyncConfig()) {
      if (!getSyncConfig().equals(other.getSyncConfig())) return false;
    }
    if (hasVectorSearchConfig() != other.hasVectorSearchConfig()) return false;
    if (hasVectorSearchConfig()) {
      if (!getVectorSearchConfig().equals(other.getVectorSearchConfig())) return false;
    }
    if (!getSourceCase().equals(other.getSourceCase())) return false;
    switch (sourceCase_) {
      case 6:
        if (!getBigQuerySource().equals(other.getBigQuerySource())) return false;
        break;
      case 9:
        if (!getFeatureRegistrySource().equals(other.getFeatureRegistrySource())) return false;
        break;
      case 0:
      default:
    }
    if (!getUnknownFields().equals(other.getUnknownFields())) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    hash = (37 * hash) + NAME_FIELD_NUMBER;
    hash = (53 * hash) + getName().hashCode();
    if (hasCreateTime()) {
      hash = (37 * hash) + CREATE_TIME_FIELD_NUMBER;
      hash = (53 * hash) + getCreateTime().hashCode();
    }
    if (hasUpdateTime()) {
      hash = (37 * hash) + UPDATE_TIME_FIELD_NUMBER;
      hash = (53 * hash) + getUpdateTime().hashCode();
    }
    hash = (37 * hash) + ETAG_FIELD_NUMBER;
    hash = (53 * hash) + getEtag().hashCode();
    if (!internalGetLabels().getMap().isEmpty()) {
      hash = (37 * hash) + LABELS_FIELD_NUMBER;
      hash = (53 * hash) + internalGetLabels().hashCode();
    }
    if (hasSyncConfig()) {
      hash = (37 * hash) + SYNC_CONFIG_FIELD_NUMBER;
      hash = (53 * hash) + getSyncConfig().hashCode();
    }
    if (hasVectorSearchConfig()) {
      hash = (37 * hash) + VECTOR_SEARCH_CONFIG_FIELD_NUMBER;
      hash = (53 * hash) + getVectorSearchConfig().hashCode();
    }
    switch (sourceCase_) {
      case 6:
        hash = (37 * hash) + BIG_QUERY_SOURCE_FIELD_NUMBER;
        hash = (53 * hash) + getBigQuerySource().hashCode();
        break;
      case 9:
        hash = (37 * hash) + FEATURE_REGISTRY_SOURCE_FIELD_NUMBER;
        hash = (53 * hash) + getFeatureRegistrySource().hashCode();
        break;
      case 0:
      default:
    }
    hash = (29 * hash) + getUnknownFields().hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.cloud.aiplatform.v1beta1.FeatureView parseFrom(java.nio.ByteBuffer data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.aiplatform.v1beta1.FeatureView parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.aiplatform.v1beta1.FeatureView parseFrom(
      com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.aiplatform.v1beta1.FeatureView parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.aiplatform.v1beta1.FeatureView parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.aiplatform.v1beta1.FeatureView parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.aiplatform.v1beta1.FeatureView parseFrom(java.io.InputStream input)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.aiplatform.v1beta1.FeatureView parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.aiplatform.v1beta1.FeatureView parseDelimitedFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.cloud.aiplatform.v1beta1.FeatureView parseDelimitedFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.aiplatform.v1beta1.FeatureView parseFrom(
      com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.aiplatform.v1beta1.FeatureView parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(com.google.cloud.aiplatform.v1beta1.FeatureView prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }
  /**
   *
   *
   * <pre>
   * FeatureView is representation of values that the FeatureOnlineStore will
   * serve based on its syncConfig.
   * </pre>
   *
   * Protobuf type {@code google.cloud.aiplatform.v1beta1.FeatureView}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.cloud.aiplatform.v1beta1.FeatureView)
      com.google.cloud.aiplatform.v1beta1.FeatureViewOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.aiplatform.v1beta1.FeatureViewProto
          .internal_static_google_cloud_aiplatform_v1beta1_FeatureView_descriptor;
    }

    @SuppressWarnings({"rawtypes"})
    protected com.google.protobuf.MapFieldReflectionAccessor internalGetMapFieldReflection(
        int number) {
      switch (number) {
        case 5:
          return internalGetLabels();
        default:
          throw new RuntimeException("Invalid map field number: " + number);
      }
    }

    @SuppressWarnings({"rawtypes"})
    protected com.google.protobuf.MapFieldReflectionAccessor internalGetMutableMapFieldReflection(
        int number) {
      switch (number) {
        case 5:
          return internalGetMutableLabels();
        default:
          throw new RuntimeException("Invalid map field number: " + number);
      }
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.aiplatform.v1beta1.FeatureViewProto
          .internal_static_google_cloud_aiplatform_v1beta1_FeatureView_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.aiplatform.v1beta1.FeatureView.class,
              com.google.cloud.aiplatform.v1beta1.FeatureView.Builder.class);
    }

    // Construct using com.google.cloud.aiplatform.v1beta1.FeatureView.newBuilder()
    private Builder() {
      maybeForceBuilderInitialization();
    }

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
      maybeForceBuilderInitialization();
    }

    private void maybeForceBuilderInitialization() {
      if (com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders) {
        getCreateTimeFieldBuilder();
        getUpdateTimeFieldBuilder();
        getSyncConfigFieldBuilder();
        getVectorSearchConfigFieldBuilder();
      }
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      bitField0_ = 0;
      if (bigQuerySourceBuilder_ != null) {
        bigQuerySourceBuilder_.clear();
      }
      if (featureRegistrySourceBuilder_ != null) {
        featureRegistrySourceBuilder_.clear();
      }
      name_ = "";
      createTime_ = null;
      if (createTimeBuilder_ != null) {
        createTimeBuilder_.dispose();
        createTimeBuilder_ = null;
      }
      updateTime_ = null;
      if (updateTimeBuilder_ != null) {
        updateTimeBuilder_.dispose();
        updateTimeBuilder_ = null;
      }
      etag_ = "";
      internalGetMutableLabels().clear();
      syncConfig_ = null;
      if (syncConfigBuilder_ != null) {
        syncConfigBuilder_.dispose();
        syncConfigBuilder_ = null;
      }
      vectorSearchConfig_ = null;
      if (vectorSearchConfigBuilder_ != null) {
        vectorSearchConfigBuilder_.dispose();
        vectorSearchConfigBuilder_ = null;
      }
      sourceCase_ = 0;
      source_ = null;
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.cloud.aiplatform.v1beta1.FeatureViewProto
          .internal_static_google_cloud_aiplatform_v1beta1_FeatureView_descriptor;
    }

    @java.lang.Override
    public com.google.cloud.aiplatform.v1beta1.FeatureView getDefaultInstanceForType() {
      return com.google.cloud.aiplatform.v1beta1.FeatureView.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.cloud.aiplatform.v1beta1.FeatureView build() {
      com.google.cloud.aiplatform.v1beta1.FeatureView result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.cloud.aiplatform.v1beta1.FeatureView buildPartial() {
      com.google.cloud.aiplatform.v1beta1.FeatureView result =
          new com.google.cloud.aiplatform.v1beta1.FeatureView(this);
      if (bitField0_ != 0) {
        buildPartial0(result);
      }
      buildPartialOneofs(result);
      onBuilt();
      return result;
    }

    private void buildPartial0(com.google.cloud.aiplatform.v1beta1.FeatureView result) {
      int from_bitField0_ = bitField0_;
      if (((from_bitField0_ & 0x00000004) != 0)) {
        result.name_ = name_;
      }
      int to_bitField0_ = 0;
      if (((from_bitField0_ & 0x00000008) != 0)) {
        result.createTime_ = createTimeBuilder_ == null ? createTime_ : createTimeBuilder_.build();
        to_bitField0_ |= 0x00000001;
      }
      if (((from_bitField0_ & 0x00000010) != 0)) {
        result.updateTime_ = updateTimeBuilder_ == null ? updateTime_ : updateTimeBuilder_.build();
        to_bitField0_ |= 0x00000002;
      }
      if (((from_bitField0_ & 0x00000020) != 0)) {
        result.etag_ = etag_;
      }
      if (((from_bitField0_ & 0x00000040) != 0)) {
        result.labels_ = internalGetLabels();
        result.labels_.makeImmutable();
      }
      if (((from_bitField0_ & 0x00000080) != 0)) {
        result.syncConfig_ = syncConfigBuilder_ == null ? syncConfig_ : syncConfigBuilder_.build();
        to_bitField0_ |= 0x00000004;
      }
      if (((from_bitField0_ & 0x00000100) != 0)) {
        result.vectorSearchConfig_ =
            vectorSearchConfigBuilder_ == null
                ? vectorSearchConfig_
                : vectorSearchConfigBuilder_.build();
        to_bitField0_ |= 0x00000008;
      }
      result.bitField0_ |= to_bitField0_;
    }

    private void buildPartialOneofs(com.google.cloud.aiplatform.v1beta1.FeatureView result) {
      result.sourceCase_ = sourceCase_;
      result.source_ = this.source_;
      if (sourceCase_ == 6 && bigQuerySourceBuilder_ != null) {
        result.source_ = bigQuerySourceBuilder_.build();
      }
      if (sourceCase_ == 9 && featureRegistrySourceBuilder_ != null) {
        result.source_ = featureRegistrySourceBuilder_.build();
      }
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.cloud.aiplatform.v1beta1.FeatureView) {
        return mergeFrom((com.google.cloud.aiplatform.v1beta1.FeatureView) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(com.google.cloud.aiplatform.v1beta1.FeatureView other) {
      if (other == com.google.cloud.aiplatform.v1beta1.FeatureView.getDefaultInstance())
        return this;
      if (!other.getName().isEmpty()) {
        name_ = other.name_;
        bitField0_ |= 0x00000004;
        onChanged();
      }
      if (other.hasCreateTime()) {
        mergeCreateTime(other.getCreateTime());
      }
      if (other.hasUpdateTime()) {
        mergeUpdateTime(other.getUpdateTime());
      }
      if (!other.getEtag().isEmpty()) {
        etag_ = other.etag_;
        bitField0_ |= 0x00000020;
        onChanged();
      }
      internalGetMutableLabels().mergeFrom(other.internalGetLabels());
      bitField0_ |= 0x00000040;
      if (other.hasSyncConfig()) {
        mergeSyncConfig(other.getSyncConfig());
      }
      if (other.hasVectorSearchConfig()) {
        mergeVectorSearchConfig(other.getVectorSearchConfig());
      }
      switch (other.getSourceCase()) {
        case BIG_QUERY_SOURCE:
          {
            mergeBigQuerySource(other.getBigQuerySource());
            break;
          }
        case FEATURE_REGISTRY_SOURCE:
          {
            mergeFeatureRegistrySource(other.getFeatureRegistrySource());
            break;
          }
        case SOURCE_NOT_SET:
          {
            break;
          }
      }
      this.mergeUnknownFields(other.getUnknownFields());
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 10:
              {
                name_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000004;
                break;
              } // case 10
            case 18:
              {
                input.readMessage(getCreateTimeFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000008;
                break;
              } // case 18
            case 26:
              {
                input.readMessage(getUpdateTimeFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000010;
                break;
              } // case 26
            case 34:
              {
                etag_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000020;
                break;
              } // case 34
            case 42:
              {
                com.google.protobuf.MapEntry<java.lang.String, java.lang.String> labels__ =
                    input.readMessage(
                        LabelsDefaultEntryHolder.defaultEntry.getParserForType(),
                        extensionRegistry);
                internalGetMutableLabels()
                    .getMutableMap()
                    .put(labels__.getKey(), labels__.getValue());
                bitField0_ |= 0x00000040;
                break;
              } // case 42
            case 50:
              {
                input.readMessage(getBigQuerySourceFieldBuilder().getBuilder(), extensionRegistry);
                sourceCase_ = 6;
                break;
              } // case 50
            case 58:
              {
                input.readMessage(getSyncConfigFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000080;
                break;
              } // case 58
            case 66:
              {
                input.readMessage(
                    getVectorSearchConfigFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000100;
                break;
              } // case 66
            case 74:
              {
                input.readMessage(
                    getFeatureRegistrySourceFieldBuilder().getBuilder(), extensionRegistry);
                sourceCase_ = 9;
                break;
              } // case 74
            default:
              {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
          } // switch (tag)
        } // while (!done)
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.unwrapIOException();
      } finally {
        onChanged();
      } // finally
      return this;
    }

    private int sourceCase_ = 0;
    private java.lang.Object source_;

    public SourceCase getSourceCase() {
      return SourceCase.forNumber(sourceCase_);
    }

    public Builder clearSource() {
      sourceCase_ = 0;
      source_ = null;
      onChanged();
      return this;
    }

    private int bitField0_;

    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.aiplatform.v1beta1.FeatureView.BigQuerySource,
            com.google.cloud.aiplatform.v1beta1.FeatureView.BigQuerySource.Builder,
            com.google.cloud.aiplatform.v1beta1.FeatureView.BigQuerySourceOrBuilder>
        bigQuerySourceBuilder_;
    /**
     *
     *
     * <pre>
     * Optional. Configures how data is supposed to be extracted from a BigQuery
     * source to be loaded onto the FeatureOnlineStore.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.FeatureView.BigQuerySource big_query_source = 6 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return Whether the bigQuerySource field is set.
     */
    @java.lang.Override
    public boolean hasBigQuerySource() {
      return sourceCase_ == 6;
    }
    /**
     *
     *
     * <pre>
     * Optional. Configures how data is supposed to be extracted from a BigQuery
     * source to be loaded onto the FeatureOnlineStore.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.FeatureView.BigQuerySource big_query_source = 6 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return The bigQuerySource.
     */
    @java.lang.Override
    public com.google.cloud.aiplatform.v1beta1.FeatureView.BigQuerySource getBigQuerySource() {
      if (bigQuerySourceBuilder_ == null) {
        if (sourceCase_ == 6) {
          return (com.google.cloud.aiplatform.v1beta1.FeatureView.BigQuerySource) source_;
        }
        return com.google.cloud.aiplatform.v1beta1.FeatureView.BigQuerySource.getDefaultInstance();
      } else {
        if (sourceCase_ == 6) {
          return bigQuerySourceBuilder_.getMessage();
        }
        return com.google.cloud.aiplatform.v1beta1.FeatureView.BigQuerySource.getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * Optional. Configures how data is supposed to be extracted from a BigQuery
     * source to be loaded onto the FeatureOnlineStore.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.FeatureView.BigQuerySource big_query_source = 6 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder setBigQuerySource(
        com.google.cloud.aiplatform.v1beta1.FeatureView.BigQuerySource value) {
      if (bigQuerySourceBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        source_ = value;
        onChanged();
      } else {
        bigQuerySourceBuilder_.setMessage(value);
      }
      sourceCase_ = 6;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. Configures how data is supposed to be extracted from a BigQuery
     * source to be loaded onto the FeatureOnlineStore.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.FeatureView.BigQuerySource big_query_source = 6 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder setBigQuerySource(
        com.google.cloud.aiplatform.v1beta1.FeatureView.BigQuerySource.Builder builderForValue) {
      if (bigQuerySourceBuilder_ == null) {
        source_ = builderForValue.build();
        onChanged();
      } else {
        bigQuerySourceBuilder_.setMessage(builderForValue.build());
      }
      sourceCase_ = 6;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. Configures how data is supposed to be extracted from a BigQuery
     * source to be loaded onto the FeatureOnlineStore.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.FeatureView.BigQuerySource big_query_source = 6 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder mergeBigQuerySource(
        com.google.cloud.aiplatform.v1beta1.FeatureView.BigQuerySource value) {
      if (bigQuerySourceBuilder_ == null) {
        if (sourceCase_ == 6
            && source_
                != com.google.cloud.aiplatform.v1beta1.FeatureView.BigQuerySource
                    .getDefaultInstance()) {
          source_ =
              com.google.cloud.aiplatform.v1beta1.FeatureView.BigQuerySource.newBuilder(
                      (com.google.cloud.aiplatform.v1beta1.FeatureView.BigQuerySource) source_)
                  .mergeFrom(value)
                  .buildPartial();
        } else {
          source_ = value;
        }
        onChanged();
      } else {
        if (sourceCase_ == 6) {
          bigQuerySourceBuilder_.mergeFrom(value);
        } else {
          bigQuerySourceBuilder_.setMessage(value);
        }
      }
      sourceCase_ = 6;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. Configures how data is supposed to be extracted from a BigQuery
     * source to be loaded onto the FeatureOnlineStore.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.FeatureView.BigQuerySource big_query_source = 6 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder clearBigQuerySource() {
      if (bigQuerySourceBuilder_ == null) {
        if (sourceCase_ == 6) {
          sourceCase_ = 0;
          source_ = null;
          onChanged();
        }
      } else {
        if (sourceCase_ == 6) {
          sourceCase_ = 0;
          source_ = null;
        }
        bigQuerySourceBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. Configures how data is supposed to be extracted from a BigQuery
     * source to be loaded onto the FeatureOnlineStore.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.FeatureView.BigQuerySource big_query_source = 6 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public com.google.cloud.aiplatform.v1beta1.FeatureView.BigQuerySource.Builder
        getBigQuerySourceBuilder() {
      return getBigQuerySourceFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Optional. Configures how data is supposed to be extracted from a BigQuery
     * source to be loaded onto the FeatureOnlineStore.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.FeatureView.BigQuerySource big_query_source = 6 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    @java.lang.Override
    public com.google.cloud.aiplatform.v1beta1.FeatureView.BigQuerySourceOrBuilder
        getBigQuerySourceOrBuilder() {
      if ((sourceCase_ == 6) && (bigQuerySourceBuilder_ != null)) {
        return bigQuerySourceBuilder_.getMessageOrBuilder();
      } else {
        if (sourceCase_ == 6) {
          return (com.google.cloud.aiplatform.v1beta1.FeatureView.BigQuerySource) source_;
        }
        return com.google.cloud.aiplatform.v1beta1.FeatureView.BigQuerySource.getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * Optional. Configures how data is supposed to be extracted from a BigQuery
     * source to be loaded onto the FeatureOnlineStore.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.FeatureView.BigQuerySource big_query_source = 6 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.aiplatform.v1beta1.FeatureView.BigQuerySource,
            com.google.cloud.aiplatform.v1beta1.FeatureView.BigQuerySource.Builder,
            com.google.cloud.aiplatform.v1beta1.FeatureView.BigQuerySourceOrBuilder>
        getBigQuerySourceFieldBuilder() {
      if (bigQuerySourceBuilder_ == null) {
        if (!(sourceCase_ == 6)) {
          source_ =
              com.google.cloud.aiplatform.v1beta1.FeatureView.BigQuerySource.getDefaultInstance();
        }
        bigQuerySourceBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.aiplatform.v1beta1.FeatureView.BigQuerySource,
                com.google.cloud.aiplatform.v1beta1.FeatureView.BigQuerySource.Builder,
                com.google.cloud.aiplatform.v1beta1.FeatureView.BigQuerySourceOrBuilder>(
                (com.google.cloud.aiplatform.v1beta1.FeatureView.BigQuerySource) source_,
                getParentForChildren(),
                isClean());
        source_ = null;
      }
      sourceCase_ = 6;
      onChanged();
      return bigQuerySourceBuilder_;
    }

    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.aiplatform.v1beta1.FeatureView.FeatureRegistrySource,
            com.google.cloud.aiplatform.v1beta1.FeatureView.FeatureRegistrySource.Builder,
            com.google.cloud.aiplatform.v1beta1.FeatureView.FeatureRegistrySourceOrBuilder>
        featureRegistrySourceBuilder_;
    /**
     *
     *
     * <pre>
     * Optional. Configures the features from a Feature Registry source that
     * need to be loaded onto the FeatureOnlineStore.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.FeatureView.FeatureRegistrySource feature_registry_source = 9 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return Whether the featureRegistrySource field is set.
     */
    @java.lang.Override
    public boolean hasFeatureRegistrySource() {
      return sourceCase_ == 9;
    }
    /**
     *
     *
     * <pre>
     * Optional. Configures the features from a Feature Registry source that
     * need to be loaded onto the FeatureOnlineStore.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.FeatureView.FeatureRegistrySource feature_registry_source = 9 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return The featureRegistrySource.
     */
    @java.lang.Override
    public com.google.cloud.aiplatform.v1beta1.FeatureView.FeatureRegistrySource
        getFeatureRegistrySource() {
      if (featureRegistrySourceBuilder_ == null) {
        if (sourceCase_ == 9) {
          return (com.google.cloud.aiplatform.v1beta1.FeatureView.FeatureRegistrySource) source_;
        }
        return com.google.cloud.aiplatform.v1beta1.FeatureView.FeatureRegistrySource
            .getDefaultInstance();
      } else {
        if (sourceCase_ == 9) {
          return featureRegistrySourceBuilder_.getMessage();
        }
        return com.google.cloud.aiplatform.v1beta1.FeatureView.FeatureRegistrySource
            .getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * Optional. Configures the features from a Feature Registry source that
     * need to be loaded onto the FeatureOnlineStore.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.FeatureView.FeatureRegistrySource feature_registry_source = 9 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder setFeatureRegistrySource(
        com.google.cloud.aiplatform.v1beta1.FeatureView.FeatureRegistrySource value) {
      if (featureRegistrySourceBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        source_ = value;
        onChanged();
      } else {
        featureRegistrySourceBuilder_.setMessage(value);
      }
      sourceCase_ = 9;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. Configures the features from a Feature Registry source that
     * need to be loaded onto the FeatureOnlineStore.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.FeatureView.FeatureRegistrySource feature_registry_source = 9 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder setFeatureRegistrySource(
        com.google.cloud.aiplatform.v1beta1.FeatureView.FeatureRegistrySource.Builder
            builderForValue) {
      if (featureRegistrySourceBuilder_ == null) {
        source_ = builderForValue.build();
        onChanged();
      } else {
        featureRegistrySourceBuilder_.setMessage(builderForValue.build());
      }
      sourceCase_ = 9;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. Configures the features from a Feature Registry source that
     * need to be loaded onto the FeatureOnlineStore.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.FeatureView.FeatureRegistrySource feature_registry_source = 9 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder mergeFeatureRegistrySource(
        com.google.cloud.aiplatform.v1beta1.FeatureView.FeatureRegistrySource value) {
      if (featureRegistrySourceBuilder_ == null) {
        if (sourceCase_ == 9
            && source_
                != com.google.cloud.aiplatform.v1beta1.FeatureView.FeatureRegistrySource
                    .getDefaultInstance()) {
          source_ =
              com.google.cloud.aiplatform.v1beta1.FeatureView.FeatureRegistrySource.newBuilder(
                      (com.google.cloud.aiplatform.v1beta1.FeatureView.FeatureRegistrySource)
                          source_)
                  .mergeFrom(value)
                  .buildPartial();
        } else {
          source_ = value;
        }
        onChanged();
      } else {
        if (sourceCase_ == 9) {
          featureRegistrySourceBuilder_.mergeFrom(value);
        } else {
          featureRegistrySourceBuilder_.setMessage(value);
        }
      }
      sourceCase_ = 9;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. Configures the features from a Feature Registry source that
     * need to be loaded onto the FeatureOnlineStore.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.FeatureView.FeatureRegistrySource feature_registry_source = 9 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder clearFeatureRegistrySource() {
      if (featureRegistrySourceBuilder_ == null) {
        if (sourceCase_ == 9) {
          sourceCase_ = 0;
          source_ = null;
          onChanged();
        }
      } else {
        if (sourceCase_ == 9) {
          sourceCase_ = 0;
          source_ = null;
        }
        featureRegistrySourceBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. Configures the features from a Feature Registry source that
     * need to be loaded onto the FeatureOnlineStore.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.FeatureView.FeatureRegistrySource feature_registry_source = 9 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public com.google.cloud.aiplatform.v1beta1.FeatureView.FeatureRegistrySource.Builder
        getFeatureRegistrySourceBuilder() {
      return getFeatureRegistrySourceFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Optional. Configures the features from a Feature Registry source that
     * need to be loaded onto the FeatureOnlineStore.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.FeatureView.FeatureRegistrySource feature_registry_source = 9 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    @java.lang.Override
    public com.google.cloud.aiplatform.v1beta1.FeatureView.FeatureRegistrySourceOrBuilder
        getFeatureRegistrySourceOrBuilder() {
      if ((sourceCase_ == 9) && (featureRegistrySourceBuilder_ != null)) {
        return featureRegistrySourceBuilder_.getMessageOrBuilder();
      } else {
        if (sourceCase_ == 9) {
          return (com.google.cloud.aiplatform.v1beta1.FeatureView.FeatureRegistrySource) source_;
        }
        return com.google.cloud.aiplatform.v1beta1.FeatureView.FeatureRegistrySource
            .getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * Optional. Configures the features from a Feature Registry source that
     * need to be loaded onto the FeatureOnlineStore.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.FeatureView.FeatureRegistrySource feature_registry_source = 9 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.aiplatform.v1beta1.FeatureView.FeatureRegistrySource,
            com.google.cloud.aiplatform.v1beta1.FeatureView.FeatureRegistrySource.Builder,
            com.google.cloud.aiplatform.v1beta1.FeatureView.FeatureRegistrySourceOrBuilder>
        getFeatureRegistrySourceFieldBuilder() {
      if (featureRegistrySourceBuilder_ == null) {
        if (!(sourceCase_ == 9)) {
          source_ =
              com.google.cloud.aiplatform.v1beta1.FeatureView.FeatureRegistrySource
                  .getDefaultInstance();
        }
        featureRegistrySourceBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.aiplatform.v1beta1.FeatureView.FeatureRegistrySource,
                com.google.cloud.aiplatform.v1beta1.FeatureView.FeatureRegistrySource.Builder,
                com.google.cloud.aiplatform.v1beta1.FeatureView.FeatureRegistrySourceOrBuilder>(
                (com.google.cloud.aiplatform.v1beta1.FeatureView.FeatureRegistrySource) source_,
                getParentForChildren(),
                isClean());
        source_ = null;
      }
      sourceCase_ = 9;
      onChanged();
      return featureRegistrySourceBuilder_;
    }

    private java.lang.Object name_ = "";
    /**
     *
     *
     * <pre>
     * Identifier. Name of the FeatureView. Format:
     * `projects/{project}/locations/{location}/featureOnlineStores/{feature_online_store}/featureViews/{feature_view}`
     * </pre>
     *
     * <code>string name = 1 [(.google.api.field_behavior) = IDENTIFIER];</code>
     *
     * @return The name.
     */
    public java.lang.String getName() {
      java.lang.Object ref = name_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        name_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Identifier. Name of the FeatureView. Format:
     * `projects/{project}/locations/{location}/featureOnlineStores/{feature_online_store}/featureViews/{feature_view}`
     * </pre>
     *
     * <code>string name = 1 [(.google.api.field_behavior) = IDENTIFIER];</code>
     *
     * @return The bytes for name.
     */
    public com.google.protobuf.ByteString getNameBytes() {
      java.lang.Object ref = name_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        name_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Identifier. Name of the FeatureView. Format:
     * `projects/{project}/locations/{location}/featureOnlineStores/{feature_online_store}/featureViews/{feature_view}`
     * </pre>
     *
     * <code>string name = 1 [(.google.api.field_behavior) = IDENTIFIER];</code>
     *
     * @param value The name to set.
     * @return This builder for chaining.
     */
    public Builder setName(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      name_ = value;
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Identifier. Name of the FeatureView. Format:
     * `projects/{project}/locations/{location}/featureOnlineStores/{feature_online_store}/featureViews/{feature_view}`
     * </pre>
     *
     * <code>string name = 1 [(.google.api.field_behavior) = IDENTIFIER];</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearName() {
      name_ = getDefaultInstance().getName();
      bitField0_ = (bitField0_ & ~0x00000004);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Identifier. Name of the FeatureView. Format:
     * `projects/{project}/locations/{location}/featureOnlineStores/{feature_online_store}/featureViews/{feature_view}`
     * </pre>
     *
     * <code>string name = 1 [(.google.api.field_behavior) = IDENTIFIER];</code>
     *
     * @param value The bytes for name to set.
     * @return This builder for chaining.
     */
    public Builder setNameBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      name_ = value;
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }

    private com.google.protobuf.Timestamp createTime_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Timestamp,
            com.google.protobuf.Timestamp.Builder,
            com.google.protobuf.TimestampOrBuilder>
        createTimeBuilder_;
    /**
     *
     *
     * <pre>
     * Output only. Timestamp when this FeatureView was created.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp create_time = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return Whether the createTime field is set.
     */
    public boolean hasCreateTime() {
      return ((bitField0_ & 0x00000008) != 0);
    }
    /**
     *
     *
     * <pre>
     * Output only. Timestamp when this FeatureView was created.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp create_time = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return The createTime.
     */
    public com.google.protobuf.Timestamp getCreateTime() {
      if (createTimeBuilder_ == null) {
        return createTime_ == null
            ? com.google.protobuf.Timestamp.getDefaultInstance()
            : createTime_;
      } else {
        return createTimeBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. Timestamp when this FeatureView was created.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp create_time = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder setCreateTime(com.google.protobuf.Timestamp value) {
      if (createTimeBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        createTime_ = value;
      } else {
        createTimeBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000008;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Timestamp when this FeatureView was created.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp create_time = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder setCreateTime(com.google.protobuf.Timestamp.Builder builderForValue) {
      if (createTimeBuilder_ == null) {
        createTime_ = builderForValue.build();
      } else {
        createTimeBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000008;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Timestamp when this FeatureView was created.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp create_time = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder mergeCreateTime(com.google.protobuf.Timestamp value) {
      if (createTimeBuilder_ == null) {
        if (((bitField0_ & 0x00000008) != 0)
            && createTime_ != null
            && createTime_ != com.google.protobuf.Timestamp.getDefaultInstance()) {
          getCreateTimeBuilder().mergeFrom(value);
        } else {
          createTime_ = value;
        }
      } else {
        createTimeBuilder_.mergeFrom(value);
      }
      if (createTime_ != null) {
        bitField0_ |= 0x00000008;
        onChanged();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Timestamp when this FeatureView was created.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp create_time = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder clearCreateTime() {
      bitField0_ = (bitField0_ & ~0x00000008);
      createTime_ = null;
      if (createTimeBuilder_ != null) {
        createTimeBuilder_.dispose();
        createTimeBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Timestamp when this FeatureView was created.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp create_time = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.protobuf.Timestamp.Builder getCreateTimeBuilder() {
      bitField0_ |= 0x00000008;
      onChanged();
      return getCreateTimeFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Output only. Timestamp when this FeatureView was created.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp create_time = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.protobuf.TimestampOrBuilder getCreateTimeOrBuilder() {
      if (createTimeBuilder_ != null) {
        return createTimeBuilder_.getMessageOrBuilder();
      } else {
        return createTime_ == null
            ? com.google.protobuf.Timestamp.getDefaultInstance()
            : createTime_;
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. Timestamp when this FeatureView was created.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp create_time = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Timestamp,
            com.google.protobuf.Timestamp.Builder,
            com.google.protobuf.TimestampOrBuilder>
        getCreateTimeFieldBuilder() {
      if (createTimeBuilder_ == null) {
        createTimeBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.protobuf.Timestamp,
                com.google.protobuf.Timestamp.Builder,
                com.google.protobuf.TimestampOrBuilder>(
                getCreateTime(), getParentForChildren(), isClean());
        createTime_ = null;
      }
      return createTimeBuilder_;
    }

    private com.google.protobuf.Timestamp updateTime_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Timestamp,
            com.google.protobuf.Timestamp.Builder,
            com.google.protobuf.TimestampOrBuilder>
        updateTimeBuilder_;
    /**
     *
     *
     * <pre>
     * Output only. Timestamp when this FeatureView was last updated.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp update_time = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return Whether the updateTime field is set.
     */
    public boolean hasUpdateTime() {
      return ((bitField0_ & 0x00000010) != 0);
    }
    /**
     *
     *
     * <pre>
     * Output only. Timestamp when this FeatureView was last updated.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp update_time = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return The updateTime.
     */
    public com.google.protobuf.Timestamp getUpdateTime() {
      if (updateTimeBuilder_ == null) {
        return updateTime_ == null
            ? com.google.protobuf.Timestamp.getDefaultInstance()
            : updateTime_;
      } else {
        return updateTimeBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. Timestamp when this FeatureView was last updated.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp update_time = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder setUpdateTime(com.google.protobuf.Timestamp value) {
      if (updateTimeBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        updateTime_ = value;
      } else {
        updateTimeBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000010;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Timestamp when this FeatureView was last updated.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp update_time = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder setUpdateTime(com.google.protobuf.Timestamp.Builder builderForValue) {
      if (updateTimeBuilder_ == null) {
        updateTime_ = builderForValue.build();
      } else {
        updateTimeBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000010;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Timestamp when this FeatureView was last updated.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp update_time = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder mergeUpdateTime(com.google.protobuf.Timestamp value) {
      if (updateTimeBuilder_ == null) {
        if (((bitField0_ & 0x00000010) != 0)
            && updateTime_ != null
            && updateTime_ != com.google.protobuf.Timestamp.getDefaultInstance()) {
          getUpdateTimeBuilder().mergeFrom(value);
        } else {
          updateTime_ = value;
        }
      } else {
        updateTimeBuilder_.mergeFrom(value);
      }
      if (updateTime_ != null) {
        bitField0_ |= 0x00000010;
        onChanged();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Timestamp when this FeatureView was last updated.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp update_time = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder clearUpdateTime() {
      bitField0_ = (bitField0_ & ~0x00000010);
      updateTime_ = null;
      if (updateTimeBuilder_ != null) {
        updateTimeBuilder_.dispose();
        updateTimeBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Timestamp when this FeatureView was last updated.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp update_time = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.protobuf.Timestamp.Builder getUpdateTimeBuilder() {
      bitField0_ |= 0x00000010;
      onChanged();
      return getUpdateTimeFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Output only. Timestamp when this FeatureView was last updated.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp update_time = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.protobuf.TimestampOrBuilder getUpdateTimeOrBuilder() {
      if (updateTimeBuilder_ != null) {
        return updateTimeBuilder_.getMessageOrBuilder();
      } else {
        return updateTime_ == null
            ? com.google.protobuf.Timestamp.getDefaultInstance()
            : updateTime_;
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. Timestamp when this FeatureView was last updated.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp update_time = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Timestamp,
            com.google.protobuf.Timestamp.Builder,
            com.google.protobuf.TimestampOrBuilder>
        getUpdateTimeFieldBuilder() {
      if (updateTimeBuilder_ == null) {
        updateTimeBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.protobuf.Timestamp,
                com.google.protobuf.Timestamp.Builder,
                com.google.protobuf.TimestampOrBuilder>(
                getUpdateTime(), getParentForChildren(), isClean());
        updateTime_ = null;
      }
      return updateTimeBuilder_;
    }

    private java.lang.Object etag_ = "";
    /**
     *
     *
     * <pre>
     * Optional. Used to perform consistent read-modify-write updates. If not set,
     * a blind "overwrite" update happens.
     * </pre>
     *
     * <code>string etag = 4 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return The etag.
     */
    public java.lang.String getEtag() {
      java.lang.Object ref = etag_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        etag_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Optional. Used to perform consistent read-modify-write updates. If not set,
     * a blind "overwrite" update happens.
     * </pre>
     *
     * <code>string etag = 4 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return The bytes for etag.
     */
    public com.google.protobuf.ByteString getEtagBytes() {
      java.lang.Object ref = etag_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        etag_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Optional. Used to perform consistent read-modify-write updates. If not set,
     * a blind "overwrite" update happens.
     * </pre>
     *
     * <code>string etag = 4 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @param value The etag to set.
     * @return This builder for chaining.
     */
    public Builder setEtag(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      etag_ = value;
      bitField0_ |= 0x00000020;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. Used to perform consistent read-modify-write updates. If not set,
     * a blind "overwrite" update happens.
     * </pre>
     *
     * <code>string etag = 4 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearEtag() {
      etag_ = getDefaultInstance().getEtag();
      bitField0_ = (bitField0_ & ~0x00000020);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. Used to perform consistent read-modify-write updates. If not set,
     * a blind "overwrite" update happens.
     * </pre>
     *
     * <code>string etag = 4 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @param value The bytes for etag to set.
     * @return This builder for chaining.
     */
    public Builder setEtagBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      etag_ = value;
      bitField0_ |= 0x00000020;
      onChanged();
      return this;
    }

    private com.google.protobuf.MapField<java.lang.String, java.lang.String> labels_;

    private com.google.protobuf.MapField<java.lang.String, java.lang.String> internalGetLabels() {
      if (labels_ == null) {
        return com.google.protobuf.MapField.emptyMapField(LabelsDefaultEntryHolder.defaultEntry);
      }
      return labels_;
    }

    private com.google.protobuf.MapField<java.lang.String, java.lang.String>
        internalGetMutableLabels() {
      if (labels_ == null) {
        labels_ = com.google.protobuf.MapField.newMapField(LabelsDefaultEntryHolder.defaultEntry);
      }
      if (!labels_.isMutable()) {
        labels_ = labels_.copy();
      }
      bitField0_ |= 0x00000040;
      onChanged();
      return labels_;
    }

    public int getLabelsCount() {
      return internalGetLabels().getMap().size();
    }
    /**
     *
     *
     * <pre>
     * Optional. The labels with user-defined metadata to organize your
     * FeatureViews.
     *
     * Label keys and values can be no longer than 64 characters
     * (Unicode codepoints), can only contain lowercase letters, numeric
     * characters, underscores and dashes. International characters are allowed.
     *
     * See https://goo.gl/xmQnxf for more information on and examples of labels.
     * No more than 64 user labels can be associated with one
     * FeatureOnlineStore(System labels are excluded)." System reserved label keys
     * are prefixed with "aiplatform.googleapis.com/" and are immutable.
     * </pre>
     *
     * <code>map&lt;string, string&gt; labels = 5 [(.google.api.field_behavior) = OPTIONAL];</code>
     */
    @java.lang.Override
    public boolean containsLabels(java.lang.String key) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      return internalGetLabels().getMap().containsKey(key);
    }
    /** Use {@link #getLabelsMap()} instead. */
    @java.lang.Override
    @java.lang.Deprecated
    public java.util.Map<java.lang.String, java.lang.String> getLabels() {
      return getLabelsMap();
    }
    /**
     *
     *
     * <pre>
     * Optional. The labels with user-defined metadata to organize your
     * FeatureViews.
     *
     * Label keys and values can be no longer than 64 characters
     * (Unicode codepoints), can only contain lowercase letters, numeric
     * characters, underscores and dashes. International characters are allowed.
     *
     * See https://goo.gl/xmQnxf for more information on and examples of labels.
     * No more than 64 user labels can be associated with one
     * FeatureOnlineStore(System labels are excluded)." System reserved label keys
     * are prefixed with "aiplatform.googleapis.com/" and are immutable.
     * </pre>
     *
     * <code>map&lt;string, string&gt; labels = 5 [(.google.api.field_behavior) = OPTIONAL];</code>
     */
    @java.lang.Override
    public java.util.Map<java.lang.String, java.lang.String> getLabelsMap() {
      return internalGetLabels().getMap();
    }
    /**
     *
     *
     * <pre>
     * Optional. The labels with user-defined metadata to organize your
     * FeatureViews.
     *
     * Label keys and values can be no longer than 64 characters
     * (Unicode codepoints), can only contain lowercase letters, numeric
     * characters, underscores and dashes. International characters are allowed.
     *
     * See https://goo.gl/xmQnxf for more information on and examples of labels.
     * No more than 64 user labels can be associated with one
     * FeatureOnlineStore(System labels are excluded)." System reserved label keys
     * are prefixed with "aiplatform.googleapis.com/" and are immutable.
     * </pre>
     *
     * <code>map&lt;string, string&gt; labels = 5 [(.google.api.field_behavior) = OPTIONAL];</code>
     */
    @java.lang.Override
    public /* nullable */ java.lang.String getLabelsOrDefault(
        java.lang.String key,
        /* nullable */
        java.lang.String defaultValue) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      java.util.Map<java.lang.String, java.lang.String> map = internalGetLabels().getMap();
      return map.containsKey(key) ? map.get(key) : defaultValue;
    }
    /**
     *
     *
     * <pre>
     * Optional. The labels with user-defined metadata to organize your
     * FeatureViews.
     *
     * Label keys and values can be no longer than 64 characters
     * (Unicode codepoints), can only contain lowercase letters, numeric
     * characters, underscores and dashes. International characters are allowed.
     *
     * See https://goo.gl/xmQnxf for more information on and examples of labels.
     * No more than 64 user labels can be associated with one
     * FeatureOnlineStore(System labels are excluded)." System reserved label keys
     * are prefixed with "aiplatform.googleapis.com/" and are immutable.
     * </pre>
     *
     * <code>map&lt;string, string&gt; labels = 5 [(.google.api.field_behavior) = OPTIONAL];</code>
     */
    @java.lang.Override
    public java.lang.String getLabelsOrThrow(java.lang.String key) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      java.util.Map<java.lang.String, java.lang.String> map = internalGetLabels().getMap();
      if (!map.containsKey(key)) {
        throw new java.lang.IllegalArgumentException();
      }
      return map.get(key);
    }

    public Builder clearLabels() {
      bitField0_ = (bitField0_ & ~0x00000040);
      internalGetMutableLabels().getMutableMap().clear();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. The labels with user-defined metadata to organize your
     * FeatureViews.
     *
     * Label keys and values can be no longer than 64 characters
     * (Unicode codepoints), can only contain lowercase letters, numeric
     * characters, underscores and dashes. International characters are allowed.
     *
     * See https://goo.gl/xmQnxf for more information on and examples of labels.
     * No more than 64 user labels can be associated with one
     * FeatureOnlineStore(System labels are excluded)." System reserved label keys
     * are prefixed with "aiplatform.googleapis.com/" and are immutable.
     * </pre>
     *
     * <code>map&lt;string, string&gt; labels = 5 [(.google.api.field_behavior) = OPTIONAL];</code>
     */
    public Builder removeLabels(java.lang.String key) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      internalGetMutableLabels().getMutableMap().remove(key);
      return this;
    }
    /** Use alternate mutation accessors instead. */
    @java.lang.Deprecated
    public java.util.Map<java.lang.String, java.lang.String> getMutableLabels() {
      bitField0_ |= 0x00000040;
      return internalGetMutableLabels().getMutableMap();
    }
    /**
     *
     *
     * <pre>
     * Optional. The labels with user-defined metadata to organize your
     * FeatureViews.
     *
     * Label keys and values can be no longer than 64 characters
     * (Unicode codepoints), can only contain lowercase letters, numeric
     * characters, underscores and dashes. International characters are allowed.
     *
     * See https://goo.gl/xmQnxf for more information on and examples of labels.
     * No more than 64 user labels can be associated with one
     * FeatureOnlineStore(System labels are excluded)." System reserved label keys
     * are prefixed with "aiplatform.googleapis.com/" and are immutable.
     * </pre>
     *
     * <code>map&lt;string, string&gt; labels = 5 [(.google.api.field_behavior) = OPTIONAL];</code>
     */
    public Builder putLabels(java.lang.String key, java.lang.String value) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      if (value == null) {
        throw new NullPointerException("map value");
      }
      internalGetMutableLabels().getMutableMap().put(key, value);
      bitField0_ |= 0x00000040;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. The labels with user-defined metadata to organize your
     * FeatureViews.
     *
     * Label keys and values can be no longer than 64 characters
     * (Unicode codepoints), can only contain lowercase letters, numeric
     * characters, underscores and dashes. International characters are allowed.
     *
     * See https://goo.gl/xmQnxf for more information on and examples of labels.
     * No more than 64 user labels can be associated with one
     * FeatureOnlineStore(System labels are excluded)." System reserved label keys
     * are prefixed with "aiplatform.googleapis.com/" and are immutable.
     * </pre>
     *
     * <code>map&lt;string, string&gt; labels = 5 [(.google.api.field_behavior) = OPTIONAL];</code>
     */
    public Builder putAllLabels(java.util.Map<java.lang.String, java.lang.String> values) {
      internalGetMutableLabels().getMutableMap().putAll(values);
      bitField0_ |= 0x00000040;
      return this;
    }

    private com.google.cloud.aiplatform.v1beta1.FeatureView.SyncConfig syncConfig_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.aiplatform.v1beta1.FeatureView.SyncConfig,
            com.google.cloud.aiplatform.v1beta1.FeatureView.SyncConfig.Builder,
            com.google.cloud.aiplatform.v1beta1.FeatureView.SyncConfigOrBuilder>
        syncConfigBuilder_;
    /**
     *
     *
     * <pre>
     * Configures when data is to be synced/updated for this FeatureView. At the
     * end of the sync the latest featureValues for each entityId of this
     * FeatureView are made ready for online serving.
     * </pre>
     *
     * <code>.google.cloud.aiplatform.v1beta1.FeatureView.SyncConfig sync_config = 7;</code>
     *
     * @return Whether the syncConfig field is set.
     */
    public boolean hasSyncConfig() {
      return ((bitField0_ & 0x00000080) != 0);
    }
    /**
     *
     *
     * <pre>
     * Configures when data is to be synced/updated for this FeatureView. At the
     * end of the sync the latest featureValues for each entityId of this
     * FeatureView are made ready for online serving.
     * </pre>
     *
     * <code>.google.cloud.aiplatform.v1beta1.FeatureView.SyncConfig sync_config = 7;</code>
     *
     * @return The syncConfig.
     */
    public com.google.cloud.aiplatform.v1beta1.FeatureView.SyncConfig getSyncConfig() {
      if (syncConfigBuilder_ == null) {
        return syncConfig_ == null
            ? com.google.cloud.aiplatform.v1beta1.FeatureView.SyncConfig.getDefaultInstance()
            : syncConfig_;
      } else {
        return syncConfigBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Configures when data is to be synced/updated for this FeatureView. At the
     * end of the sync the latest featureValues for each entityId of this
     * FeatureView are made ready for online serving.
     * </pre>
     *
     * <code>.google.cloud.aiplatform.v1beta1.FeatureView.SyncConfig sync_config = 7;</code>
     */
    public Builder setSyncConfig(com.google.cloud.aiplatform.v1beta1.FeatureView.SyncConfig value) {
      if (syncConfigBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        syncConfig_ = value;
      } else {
        syncConfigBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000080;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Configures when data is to be synced/updated for this FeatureView. At the
     * end of the sync the latest featureValues for each entityId of this
     * FeatureView are made ready for online serving.
     * </pre>
     *
     * <code>.google.cloud.aiplatform.v1beta1.FeatureView.SyncConfig sync_config = 7;</code>
     */
    public Builder setSyncConfig(
        com.google.cloud.aiplatform.v1beta1.FeatureView.SyncConfig.Builder builderForValue) {
      if (syncConfigBuilder_ == null) {
        syncConfig_ = builderForValue.build();
      } else {
        syncConfigBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000080;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Configures when data is to be synced/updated for this FeatureView. At the
     * end of the sync the latest featureValues for each entityId of this
     * FeatureView are made ready for online serving.
     * </pre>
     *
     * <code>.google.cloud.aiplatform.v1beta1.FeatureView.SyncConfig sync_config = 7;</code>
     */
    public Builder mergeSyncConfig(
        com.google.cloud.aiplatform.v1beta1.FeatureView.SyncConfig value) {
      if (syncConfigBuilder_ == null) {
        if (((bitField0_ & 0x00000080) != 0)
            && syncConfig_ != null
            && syncConfig_
                != com.google.cloud.aiplatform.v1beta1.FeatureView.SyncConfig
                    .getDefaultInstance()) {
          getSyncConfigBuilder().mergeFrom(value);
        } else {
          syncConfig_ = value;
        }
      } else {
        syncConfigBuilder_.mergeFrom(value);
      }
      if (syncConfig_ != null) {
        bitField0_ |= 0x00000080;
        onChanged();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Configures when data is to be synced/updated for this FeatureView. At the
     * end of the sync the latest featureValues for each entityId of this
     * FeatureView are made ready for online serving.
     * </pre>
     *
     * <code>.google.cloud.aiplatform.v1beta1.FeatureView.SyncConfig sync_config = 7;</code>
     */
    public Builder clearSyncConfig() {
      bitField0_ = (bitField0_ & ~0x00000080);
      syncConfig_ = null;
      if (syncConfigBuilder_ != null) {
        syncConfigBuilder_.dispose();
        syncConfigBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Configures when data is to be synced/updated for this FeatureView. At the
     * end of the sync the latest featureValues for each entityId of this
     * FeatureView are made ready for online serving.
     * </pre>
     *
     * <code>.google.cloud.aiplatform.v1beta1.FeatureView.SyncConfig sync_config = 7;</code>
     */
    public com.google.cloud.aiplatform.v1beta1.FeatureView.SyncConfig.Builder
        getSyncConfigBuilder() {
      bitField0_ |= 0x00000080;
      onChanged();
      return getSyncConfigFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Configures when data is to be synced/updated for this FeatureView. At the
     * end of the sync the latest featureValues for each entityId of this
     * FeatureView are made ready for online serving.
     * </pre>
     *
     * <code>.google.cloud.aiplatform.v1beta1.FeatureView.SyncConfig sync_config = 7;</code>
     */
    public com.google.cloud.aiplatform.v1beta1.FeatureView.SyncConfigOrBuilder
        getSyncConfigOrBuilder() {
      if (syncConfigBuilder_ != null) {
        return syncConfigBuilder_.getMessageOrBuilder();
      } else {
        return syncConfig_ == null
            ? com.google.cloud.aiplatform.v1beta1.FeatureView.SyncConfig.getDefaultInstance()
            : syncConfig_;
      }
    }
    /**
     *
     *
     * <pre>
     * Configures when data is to be synced/updated for this FeatureView. At the
     * end of the sync the latest featureValues for each entityId of this
     * FeatureView are made ready for online serving.
     * </pre>
     *
     * <code>.google.cloud.aiplatform.v1beta1.FeatureView.SyncConfig sync_config = 7;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.aiplatform.v1beta1.FeatureView.SyncConfig,
            com.google.cloud.aiplatform.v1beta1.FeatureView.SyncConfig.Builder,
            com.google.cloud.aiplatform.v1beta1.FeatureView.SyncConfigOrBuilder>
        getSyncConfigFieldBuilder() {
      if (syncConfigBuilder_ == null) {
        syncConfigBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.aiplatform.v1beta1.FeatureView.SyncConfig,
                com.google.cloud.aiplatform.v1beta1.FeatureView.SyncConfig.Builder,
                com.google.cloud.aiplatform.v1beta1.FeatureView.SyncConfigOrBuilder>(
                getSyncConfig(), getParentForChildren(), isClean());
        syncConfig_ = null;
      }
      return syncConfigBuilder_;
    }

    private com.google.cloud.aiplatform.v1beta1.FeatureView.VectorSearchConfig vectorSearchConfig_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.aiplatform.v1beta1.FeatureView.VectorSearchConfig,
            com.google.cloud.aiplatform.v1beta1.FeatureView.VectorSearchConfig.Builder,
            com.google.cloud.aiplatform.v1beta1.FeatureView.VectorSearchConfigOrBuilder>
        vectorSearchConfigBuilder_;
    /**
     *
     *
     * <pre>
     * Optional. Configuration for vector search. It contains the required
     * configurations to create an index from source data, so that approximate
     * nearest neighbor (a.k.a ANN) algorithms search can be performed during
     * online serving.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.FeatureView.VectorSearchConfig vector_search_config = 8 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return Whether the vectorSearchConfig field is set.
     */
    public boolean hasVectorSearchConfig() {
      return ((bitField0_ & 0x00000100) != 0);
    }
    /**
     *
     *
     * <pre>
     * Optional. Configuration for vector search. It contains the required
     * configurations to create an index from source data, so that approximate
     * nearest neighbor (a.k.a ANN) algorithms search can be performed during
     * online serving.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.FeatureView.VectorSearchConfig vector_search_config = 8 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return The vectorSearchConfig.
     */
    public com.google.cloud.aiplatform.v1beta1.FeatureView.VectorSearchConfig
        getVectorSearchConfig() {
      if (vectorSearchConfigBuilder_ == null) {
        return vectorSearchConfig_ == null
            ? com.google.cloud.aiplatform.v1beta1.FeatureView.VectorSearchConfig
                .getDefaultInstance()
            : vectorSearchConfig_;
      } else {
        return vectorSearchConfigBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Optional. Configuration for vector search. It contains the required
     * configurations to create an index from source data, so that approximate
     * nearest neighbor (a.k.a ANN) algorithms search can be performed during
     * online serving.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.FeatureView.VectorSearchConfig vector_search_config = 8 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder setVectorSearchConfig(
        com.google.cloud.aiplatform.v1beta1.FeatureView.VectorSearchConfig value) {
      if (vectorSearchConfigBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        vectorSearchConfig_ = value;
      } else {
        vectorSearchConfigBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000100;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. Configuration for vector search. It contains the required
     * configurations to create an index from source data, so that approximate
     * nearest neighbor (a.k.a ANN) algorithms search can be performed during
     * online serving.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.FeatureView.VectorSearchConfig vector_search_config = 8 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder setVectorSearchConfig(
        com.google.cloud.aiplatform.v1beta1.FeatureView.VectorSearchConfig.Builder
            builderForValue) {
      if (vectorSearchConfigBuilder_ == null) {
        vectorSearchConfig_ = builderForValue.build();
      } else {
        vectorSearchConfigBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000100;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. Configuration for vector search. It contains the required
     * configurations to create an index from source data, so that approximate
     * nearest neighbor (a.k.a ANN) algorithms search can be performed during
     * online serving.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.FeatureView.VectorSearchConfig vector_search_config = 8 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder mergeVectorSearchConfig(
        com.google.cloud.aiplatform.v1beta1.FeatureView.VectorSearchConfig value) {
      if (vectorSearchConfigBuilder_ == null) {
        if (((bitField0_ & 0x00000100) != 0)
            && vectorSearchConfig_ != null
            && vectorSearchConfig_
                != com.google.cloud.aiplatform.v1beta1.FeatureView.VectorSearchConfig
                    .getDefaultInstance()) {
          getVectorSearchConfigBuilder().mergeFrom(value);
        } else {
          vectorSearchConfig_ = value;
        }
      } else {
        vectorSearchConfigBuilder_.mergeFrom(value);
      }
      if (vectorSearchConfig_ != null) {
        bitField0_ |= 0x00000100;
        onChanged();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. Configuration for vector search. It contains the required
     * configurations to create an index from source data, so that approximate
     * nearest neighbor (a.k.a ANN) algorithms search can be performed during
     * online serving.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.FeatureView.VectorSearchConfig vector_search_config = 8 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder clearVectorSearchConfig() {
      bitField0_ = (bitField0_ & ~0x00000100);
      vectorSearchConfig_ = null;
      if (vectorSearchConfigBuilder_ != null) {
        vectorSearchConfigBuilder_.dispose();
        vectorSearchConfigBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. Configuration for vector search. It contains the required
     * configurations to create an index from source data, so that approximate
     * nearest neighbor (a.k.a ANN) algorithms search can be performed during
     * online serving.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.FeatureView.VectorSearchConfig vector_search_config = 8 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public com.google.cloud.aiplatform.v1beta1.FeatureView.VectorSearchConfig.Builder
        getVectorSearchConfigBuilder() {
      bitField0_ |= 0x00000100;
      onChanged();
      return getVectorSearchConfigFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Optional. Configuration for vector search. It contains the required
     * configurations to create an index from source data, so that approximate
     * nearest neighbor (a.k.a ANN) algorithms search can be performed during
     * online serving.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.FeatureView.VectorSearchConfig vector_search_config = 8 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public com.google.cloud.aiplatform.v1beta1.FeatureView.VectorSearchConfigOrBuilder
        getVectorSearchConfigOrBuilder() {
      if (vectorSearchConfigBuilder_ != null) {
        return vectorSearchConfigBuilder_.getMessageOrBuilder();
      } else {
        return vectorSearchConfig_ == null
            ? com.google.cloud.aiplatform.v1beta1.FeatureView.VectorSearchConfig
                .getDefaultInstance()
            : vectorSearchConfig_;
      }
    }
    /**
     *
     *
     * <pre>
     * Optional. Configuration for vector search. It contains the required
     * configurations to create an index from source data, so that approximate
     * nearest neighbor (a.k.a ANN) algorithms search can be performed during
     * online serving.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.FeatureView.VectorSearchConfig vector_search_config = 8 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.aiplatform.v1beta1.FeatureView.VectorSearchConfig,
            com.google.cloud.aiplatform.v1beta1.FeatureView.VectorSearchConfig.Builder,
            com.google.cloud.aiplatform.v1beta1.FeatureView.VectorSearchConfigOrBuilder>
        getVectorSearchConfigFieldBuilder() {
      if (vectorSearchConfigBuilder_ == null) {
        vectorSearchConfigBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.aiplatform.v1beta1.FeatureView.VectorSearchConfig,
                com.google.cloud.aiplatform.v1beta1.FeatureView.VectorSearchConfig.Builder,
                com.google.cloud.aiplatform.v1beta1.FeatureView.VectorSearchConfigOrBuilder>(
                getVectorSearchConfig(), getParentForChildren(), isClean());
        vectorSearchConfig_ = null;
      }
      return vectorSearchConfigBuilder_;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.cloud.aiplatform.v1beta1.FeatureView)
  }

  // @@protoc_insertion_point(class_scope:google.cloud.aiplatform.v1beta1.FeatureView)
  private static final com.google.cloud.aiplatform.v1beta1.FeatureView DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.cloud.aiplatform.v1beta1.FeatureView();
  }

  public static com.google.cloud.aiplatform.v1beta1.FeatureView getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<FeatureView> PARSER =
      new com.google.protobuf.AbstractParser<FeatureView>() {
        @java.lang.Override
        public FeatureView parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          Builder builder = newBuilder();
          try {
            builder.mergeFrom(input, extensionRegistry);
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.setUnfinishedMessage(builder.buildPartial());
          } catch (com.google.protobuf.UninitializedMessageException e) {
            throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
          } catch (java.io.IOException e) {
            throw new com.google.protobuf.InvalidProtocolBufferException(e)
                .setUnfinishedMessage(builder.buildPartial());
          }
          return builder.buildPartial();
        }
      };

  public static com.google.protobuf.Parser<FeatureView> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<FeatureView> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.cloud.aiplatform.v1beta1.FeatureView getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
