/*
 * Copyright 2024 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/cloud/aiplatform/v1beta1/nas_job.proto

// Protobuf Java Version: 3.25.2
package com.google.cloud.aiplatform.v1beta1;

/**
 *
 *
 * <pre>
 * Represents the spec of a NasJob.
 * </pre>
 *
 * Protobuf type {@code google.cloud.aiplatform.v1beta1.NasJobSpec}
 */
public final class NasJobSpec extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.cloud.aiplatform.v1beta1.NasJobSpec)
    NasJobSpecOrBuilder {
  private static final long serialVersionUID = 0L;
  // Use NasJobSpec.newBuilder() to construct.
  private NasJobSpec(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private NasJobSpec() {
    resumeNasJobId_ = "";
    searchSpaceSpec_ = "";
  }

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new NasJobSpec();
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.cloud.aiplatform.v1beta1.NasJobProto
        .internal_static_google_cloud_aiplatform_v1beta1_NasJobSpec_descriptor;
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.cloud.aiplatform.v1beta1.NasJobProto
        .internal_static_google_cloud_aiplatform_v1beta1_NasJobSpec_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.cloud.aiplatform.v1beta1.NasJobSpec.class,
            com.google.cloud.aiplatform.v1beta1.NasJobSpec.Builder.class);
  }

  public interface MultiTrialAlgorithmSpecOrBuilder
      extends
      // @@protoc_insertion_point(interface_extends:google.cloud.aiplatform.v1beta1.NasJobSpec.MultiTrialAlgorithmSpec)
      com.google.protobuf.MessageOrBuilder {

    /**
     *
     *
     * <pre>
     * The multi-trial Neural Architecture Search (NAS) algorithm
     * type. Defaults to `REINFORCEMENT_LEARNING`.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.NasJobSpec.MultiTrialAlgorithmSpec.MultiTrialAlgorithm multi_trial_algorithm = 1;
     * </code>
     *
     * @return The enum numeric value on the wire for multiTrialAlgorithm.
     */
    int getMultiTrialAlgorithmValue();
    /**
     *
     *
     * <pre>
     * The multi-trial Neural Architecture Search (NAS) algorithm
     * type. Defaults to `REINFORCEMENT_LEARNING`.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.NasJobSpec.MultiTrialAlgorithmSpec.MultiTrialAlgorithm multi_trial_algorithm = 1;
     * </code>
     *
     * @return The multiTrialAlgorithm.
     */
    com.google.cloud.aiplatform.v1beta1.NasJobSpec.MultiTrialAlgorithmSpec.MultiTrialAlgorithm
        getMultiTrialAlgorithm();

    /**
     *
     *
     * <pre>
     * Metric specs for the NAS job.
     * Validation for this field is done at `multi_trial_algorithm_spec` field.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.NasJobSpec.MultiTrialAlgorithmSpec.MetricSpec metric = 2;
     * </code>
     *
     * @return Whether the metric field is set.
     */
    boolean hasMetric();
    /**
     *
     *
     * <pre>
     * Metric specs for the NAS job.
     * Validation for this field is done at `multi_trial_algorithm_spec` field.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.NasJobSpec.MultiTrialAlgorithmSpec.MetricSpec metric = 2;
     * </code>
     *
     * @return The metric.
     */
    com.google.cloud.aiplatform.v1beta1.NasJobSpec.MultiTrialAlgorithmSpec.MetricSpec getMetric();
    /**
     *
     *
     * <pre>
     * Metric specs for the NAS job.
     * Validation for this field is done at `multi_trial_algorithm_spec` field.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.NasJobSpec.MultiTrialAlgorithmSpec.MetricSpec metric = 2;
     * </code>
     */
    com.google.cloud.aiplatform.v1beta1.NasJobSpec.MultiTrialAlgorithmSpec.MetricSpecOrBuilder
        getMetricOrBuilder();

    /**
     *
     *
     * <pre>
     * Required. Spec for search trials.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.NasJobSpec.MultiTrialAlgorithmSpec.SearchTrialSpec search_trial_spec = 3 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     *
     * @return Whether the searchTrialSpec field is set.
     */
    boolean hasSearchTrialSpec();
    /**
     *
     *
     * <pre>
     * Required. Spec for search trials.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.NasJobSpec.MultiTrialAlgorithmSpec.SearchTrialSpec search_trial_spec = 3 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     *
     * @return The searchTrialSpec.
     */
    com.google.cloud.aiplatform.v1beta1.NasJobSpec.MultiTrialAlgorithmSpec.SearchTrialSpec
        getSearchTrialSpec();
    /**
     *
     *
     * <pre>
     * Required. Spec for search trials.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.NasJobSpec.MultiTrialAlgorithmSpec.SearchTrialSpec search_trial_spec = 3 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    com.google.cloud.aiplatform.v1beta1.NasJobSpec.MultiTrialAlgorithmSpec.SearchTrialSpecOrBuilder
        getSearchTrialSpecOrBuilder();

    /**
     *
     *
     * <pre>
     * Spec for train trials. Top N [TrainTrialSpec.max_parallel_trial_count]
     * search trials will be trained for every M
     * [TrainTrialSpec.frequency] trials searched.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.NasJobSpec.MultiTrialAlgorithmSpec.TrainTrialSpec train_trial_spec = 4;
     * </code>
     *
     * @return Whether the trainTrialSpec field is set.
     */
    boolean hasTrainTrialSpec();
    /**
     *
     *
     * <pre>
     * Spec for train trials. Top N [TrainTrialSpec.max_parallel_trial_count]
     * search trials will be trained for every M
     * [TrainTrialSpec.frequency] trials searched.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.NasJobSpec.MultiTrialAlgorithmSpec.TrainTrialSpec train_trial_spec = 4;
     * </code>
     *
     * @return The trainTrialSpec.
     */
    com.google.cloud.aiplatform.v1beta1.NasJobSpec.MultiTrialAlgorithmSpec.TrainTrialSpec
        getTrainTrialSpec();
    /**
     *
     *
     * <pre>
     * Spec for train trials. Top N [TrainTrialSpec.max_parallel_trial_count]
     * search trials will be trained for every M
     * [TrainTrialSpec.frequency] trials searched.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.NasJobSpec.MultiTrialAlgorithmSpec.TrainTrialSpec train_trial_spec = 4;
     * </code>
     */
    com.google.cloud.aiplatform.v1beta1.NasJobSpec.MultiTrialAlgorithmSpec.TrainTrialSpecOrBuilder
        getTrainTrialSpecOrBuilder();
  }
  /**
   *
   *
   * <pre>
   * The spec of multi-trial Neural Architecture Search (NAS).
   * </pre>
   *
   * Protobuf type {@code google.cloud.aiplatform.v1beta1.NasJobSpec.MultiTrialAlgorithmSpec}
   */
  public static final class MultiTrialAlgorithmSpec extends com.google.protobuf.GeneratedMessageV3
      implements
      // @@protoc_insertion_point(message_implements:google.cloud.aiplatform.v1beta1.NasJobSpec.MultiTrialAlgorithmSpec)
      MultiTrialAlgorithmSpecOrBuilder {
    private static final long serialVersionUID = 0L;
    // Use MultiTrialAlgorithmSpec.newBuilder() to construct.
    private MultiTrialAlgorithmSpec(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
      super(builder);
    }

    private MultiTrialAlgorithmSpec() {
      multiTrialAlgorithm_ = 0;
    }

    @java.lang.Override
    @SuppressWarnings({"unused"})
    protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
      return new MultiTrialAlgorithmSpec();
    }

    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.aiplatform.v1beta1.NasJobProto
          .internal_static_google_cloud_aiplatform_v1beta1_NasJobSpec_MultiTrialAlgorithmSpec_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.aiplatform.v1beta1.NasJobProto
          .internal_static_google_cloud_aiplatform_v1beta1_NasJobSpec_MultiTrialAlgorithmSpec_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.aiplatform.v1beta1.NasJobSpec.MultiTrialAlgorithmSpec.class,
              com.google.cloud.aiplatform.v1beta1.NasJobSpec.MultiTrialAlgorithmSpec.Builder.class);
    }

    /**
     *
     *
     * <pre>
     * The available types of multi-trial algorithms.
     * </pre>
     *
     * Protobuf enum {@code
     * google.cloud.aiplatform.v1beta1.NasJobSpec.MultiTrialAlgorithmSpec.MultiTrialAlgorithm}
     */
    public enum MultiTrialAlgorithm implements com.google.protobuf.ProtocolMessageEnum {
      /**
       *
       *
       * <pre>
       * Defaults to `REINFORCEMENT_LEARNING`.
       * </pre>
       *
       * <code>MULTI_TRIAL_ALGORITHM_UNSPECIFIED = 0;</code>
       */
      MULTI_TRIAL_ALGORITHM_UNSPECIFIED(0),
      /**
       *
       *
       * <pre>
       * The Reinforcement Learning Algorithm for Multi-trial Neural
       * Architecture Search (NAS).
       * </pre>
       *
       * <code>REINFORCEMENT_LEARNING = 1;</code>
       */
      REINFORCEMENT_LEARNING(1),
      /**
       *
       *
       * <pre>
       * The Grid Search Algorithm for Multi-trial Neural
       * Architecture Search (NAS).
       * </pre>
       *
       * <code>GRID_SEARCH = 2;</code>
       */
      GRID_SEARCH(2),
      UNRECOGNIZED(-1),
      ;

      /**
       *
       *
       * <pre>
       * Defaults to `REINFORCEMENT_LEARNING`.
       * </pre>
       *
       * <code>MULTI_TRIAL_ALGORITHM_UNSPECIFIED = 0;</code>
       */
      public static final int MULTI_TRIAL_ALGORITHM_UNSPECIFIED_VALUE = 0;
      /**
       *
       *
       * <pre>
       * The Reinforcement Learning Algorithm for Multi-trial Neural
       * Architecture Search (NAS).
       * </pre>
       *
       * <code>REINFORCEMENT_LEARNING = 1;</code>
       */
      public static final int REINFORCEMENT_LEARNING_VALUE = 1;
      /**
       *
       *
       * <pre>
       * The Grid Search Algorithm for Multi-trial Neural
       * Architecture Search (NAS).
       * </pre>
       *
       * <code>GRID_SEARCH = 2;</code>
       */
      public static final int GRID_SEARCH_VALUE = 2;

      public final int getNumber() {
        if (this == UNRECOGNIZED) {
          throw new java.lang.IllegalArgumentException(
              "Can't get the number of an unknown enum value.");
        }
        return value;
      }

      /**
       * @param value The numeric wire value of the corresponding enum entry.
       * @return The enum associated with the given numeric wire value.
       * @deprecated Use {@link #forNumber(int)} instead.
       */
      @java.lang.Deprecated
      public static MultiTrialAlgorithm valueOf(int value) {
        return forNumber(value);
      }

      /**
       * @param value The numeric wire value of the corresponding enum entry.
       * @return The enum associated with the given numeric wire value.
       */
      public static MultiTrialAlgorithm forNumber(int value) {
        switch (value) {
          case 0:
            return MULTI_TRIAL_ALGORITHM_UNSPECIFIED;
          case 1:
            return REINFORCEMENT_LEARNING;
          case 2:
            return GRID_SEARCH;
          default:
            return null;
        }
      }

      public static com.google.protobuf.Internal.EnumLiteMap<MultiTrialAlgorithm>
          internalGetValueMap() {
        return internalValueMap;
      }

      private static final com.google.protobuf.Internal.EnumLiteMap<MultiTrialAlgorithm>
          internalValueMap =
              new com.google.protobuf.Internal.EnumLiteMap<MultiTrialAlgorithm>() {
                public MultiTrialAlgorithm findValueByNumber(int number) {
                  return MultiTrialAlgorithm.forNumber(number);
                }
              };

      public final com.google.protobuf.Descriptors.EnumValueDescriptor getValueDescriptor() {
        if (this == UNRECOGNIZED) {
          throw new java.lang.IllegalStateException(
              "Can't get the descriptor of an unrecognized enum value.");
        }
        return getDescriptor().getValues().get(ordinal());
      }

      public final com.google.protobuf.Descriptors.EnumDescriptor getDescriptorForType() {
        return getDescriptor();
      }

      public static final com.google.protobuf.Descriptors.EnumDescriptor getDescriptor() {
        return com.google.cloud.aiplatform.v1beta1.NasJobSpec.MultiTrialAlgorithmSpec
            .getDescriptor()
            .getEnumTypes()
            .get(0);
      }

      private static final MultiTrialAlgorithm[] VALUES = values();

      public static MultiTrialAlgorithm valueOf(
          com.google.protobuf.Descriptors.EnumValueDescriptor desc) {
        if (desc.getType() != getDescriptor()) {
          throw new java.lang.IllegalArgumentException("EnumValueDescriptor is not for this type.");
        }
        if (desc.getIndex() == -1) {
          return UNRECOGNIZED;
        }
        return VALUES[desc.getIndex()];
      }

      private final int value;

      private MultiTrialAlgorithm(int value) {
        this.value = value;
      }

      // @@protoc_insertion_point(enum_scope:google.cloud.aiplatform.v1beta1.NasJobSpec.MultiTrialAlgorithmSpec.MultiTrialAlgorithm)
    }

    public interface MetricSpecOrBuilder
        extends
        // @@protoc_insertion_point(interface_extends:google.cloud.aiplatform.v1beta1.NasJobSpec.MultiTrialAlgorithmSpec.MetricSpec)
        com.google.protobuf.MessageOrBuilder {

      /**
       *
       *
       * <pre>
       * Required. The ID of the metric. Must not contain whitespaces.
       * </pre>
       *
       * <code>string metric_id = 1 [(.google.api.field_behavior) = REQUIRED];</code>
       *
       * @return The metricId.
       */
      java.lang.String getMetricId();
      /**
       *
       *
       * <pre>
       * Required. The ID of the metric. Must not contain whitespaces.
       * </pre>
       *
       * <code>string metric_id = 1 [(.google.api.field_behavior) = REQUIRED];</code>
       *
       * @return The bytes for metricId.
       */
      com.google.protobuf.ByteString getMetricIdBytes();

      /**
       *
       *
       * <pre>
       * Required. The optimization goal of the metric.
       * </pre>
       *
       * <code>
       * .google.cloud.aiplatform.v1beta1.NasJobSpec.MultiTrialAlgorithmSpec.MetricSpec.GoalType goal = 2 [(.google.api.field_behavior) = REQUIRED];
       * </code>
       *
       * @return The enum numeric value on the wire for goal.
       */
      int getGoalValue();
      /**
       *
       *
       * <pre>
       * Required. The optimization goal of the metric.
       * </pre>
       *
       * <code>
       * .google.cloud.aiplatform.v1beta1.NasJobSpec.MultiTrialAlgorithmSpec.MetricSpec.GoalType goal = 2 [(.google.api.field_behavior) = REQUIRED];
       * </code>
       *
       * @return The goal.
       */
      com.google.cloud.aiplatform.v1beta1.NasJobSpec.MultiTrialAlgorithmSpec.MetricSpec.GoalType
          getGoal();
    }
    /**
     *
     *
     * <pre>
     * Represents a metric to optimize.
     * </pre>
     *
     * Protobuf type {@code
     * google.cloud.aiplatform.v1beta1.NasJobSpec.MultiTrialAlgorithmSpec.MetricSpec}
     */
    public static final class MetricSpec extends com.google.protobuf.GeneratedMessageV3
        implements
        // @@protoc_insertion_point(message_implements:google.cloud.aiplatform.v1beta1.NasJobSpec.MultiTrialAlgorithmSpec.MetricSpec)
        MetricSpecOrBuilder {
      private static final long serialVersionUID = 0L;
      // Use MetricSpec.newBuilder() to construct.
      private MetricSpec(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
        super(builder);
      }

      private MetricSpec() {
        metricId_ = "";
        goal_ = 0;
      }

      @java.lang.Override
      @SuppressWarnings({"unused"})
      protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
        return new MetricSpec();
      }

      public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
        return com.google.cloud.aiplatform.v1beta1.NasJobProto
            .internal_static_google_cloud_aiplatform_v1beta1_NasJobSpec_MultiTrialAlgorithmSpec_MetricSpec_descriptor;
      }

      @java.lang.Override
      protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return com.google.cloud.aiplatform.v1beta1.NasJobProto
            .internal_static_google_cloud_aiplatform_v1beta1_NasJobSpec_MultiTrialAlgorithmSpec_MetricSpec_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                com.google.cloud.aiplatform.v1beta1.NasJobSpec.MultiTrialAlgorithmSpec.MetricSpec
                    .class,
                com.google.cloud.aiplatform.v1beta1.NasJobSpec.MultiTrialAlgorithmSpec.MetricSpec
                    .Builder.class);
      }

      /**
       *
       *
       * <pre>
       * The available types of optimization goals.
       * </pre>
       *
       * Protobuf enum {@code
       * google.cloud.aiplatform.v1beta1.NasJobSpec.MultiTrialAlgorithmSpec.MetricSpec.GoalType}
       */
      public enum GoalType implements com.google.protobuf.ProtocolMessageEnum {
        /**
         *
         *
         * <pre>
         * Goal Type will default to maximize.
         * </pre>
         *
         * <code>GOAL_TYPE_UNSPECIFIED = 0;</code>
         */
        GOAL_TYPE_UNSPECIFIED(0),
        /**
         *
         *
         * <pre>
         * Maximize the goal metric.
         * </pre>
         *
         * <code>MAXIMIZE = 1;</code>
         */
        MAXIMIZE(1),
        /**
         *
         *
         * <pre>
         * Minimize the goal metric.
         * </pre>
         *
         * <code>MINIMIZE = 2;</code>
         */
        MINIMIZE(2),
        UNRECOGNIZED(-1),
        ;

        /**
         *
         *
         * <pre>
         * Goal Type will default to maximize.
         * </pre>
         *
         * <code>GOAL_TYPE_UNSPECIFIED = 0;</code>
         */
        public static final int GOAL_TYPE_UNSPECIFIED_VALUE = 0;
        /**
         *
         *
         * <pre>
         * Maximize the goal metric.
         * </pre>
         *
         * <code>MAXIMIZE = 1;</code>
         */
        public static final int MAXIMIZE_VALUE = 1;
        /**
         *
         *
         * <pre>
         * Minimize the goal metric.
         * </pre>
         *
         * <code>MINIMIZE = 2;</code>
         */
        public static final int MINIMIZE_VALUE = 2;

        public final int getNumber() {
          if (this == UNRECOGNIZED) {
            throw new java.lang.IllegalArgumentException(
                "Can't get the number of an unknown enum value.");
          }
          return value;
        }

        /**
         * @param value The numeric wire value of the corresponding enum entry.
         * @return The enum associated with the given numeric wire value.
         * @deprecated Use {@link #forNumber(int)} instead.
         */
        @java.lang.Deprecated
        public static GoalType valueOf(int value) {
          return forNumber(value);
        }

        /**
         * @param value The numeric wire value of the corresponding enum entry.
         * @return The enum associated with the given numeric wire value.
         */
        public static GoalType forNumber(int value) {
          switch (value) {
            case 0:
              return GOAL_TYPE_UNSPECIFIED;
            case 1:
              return MAXIMIZE;
            case 2:
              return MINIMIZE;
            default:
              return null;
          }
        }

        public static com.google.protobuf.Internal.EnumLiteMap<GoalType> internalGetValueMap() {
          return internalValueMap;
        }

        private static final com.google.protobuf.Internal.EnumLiteMap<GoalType> internalValueMap =
            new com.google.protobuf.Internal.EnumLiteMap<GoalType>() {
              public GoalType findValueByNumber(int number) {
                return GoalType.forNumber(number);
              }
            };

        public final com.google.protobuf.Descriptors.EnumValueDescriptor getValueDescriptor() {
          if (this == UNRECOGNIZED) {
            throw new java.lang.IllegalStateException(
                "Can't get the descriptor of an unrecognized enum value.");
          }
          return getDescriptor().getValues().get(ordinal());
        }

        public final com.google.protobuf.Descriptors.EnumDescriptor getDescriptorForType() {
          return getDescriptor();
        }

        public static final com.google.protobuf.Descriptors.EnumDescriptor getDescriptor() {
          return com.google.cloud.aiplatform.v1beta1.NasJobSpec.MultiTrialAlgorithmSpec.MetricSpec
              .getDescriptor()
              .getEnumTypes()
              .get(0);
        }

        private static final GoalType[] VALUES = values();

        public static GoalType valueOf(com.google.protobuf.Descriptors.EnumValueDescriptor desc) {
          if (desc.getType() != getDescriptor()) {
            throw new java.lang.IllegalArgumentException(
                "EnumValueDescriptor is not for this type.");
          }
          if (desc.getIndex() == -1) {
            return UNRECOGNIZED;
          }
          return VALUES[desc.getIndex()];
        }

        private final int value;

        private GoalType(int value) {
          this.value = value;
        }

        // @@protoc_insertion_point(enum_scope:google.cloud.aiplatform.v1beta1.NasJobSpec.MultiTrialAlgorithmSpec.MetricSpec.GoalType)
      }

      public static final int METRIC_ID_FIELD_NUMBER = 1;

      @SuppressWarnings("serial")
      private volatile java.lang.Object metricId_ = "";
      /**
       *
       *
       * <pre>
       * Required. The ID of the metric. Must not contain whitespaces.
       * </pre>
       *
       * <code>string metric_id = 1 [(.google.api.field_behavior) = REQUIRED];</code>
       *
       * @return The metricId.
       */
      @java.lang.Override
      public java.lang.String getMetricId() {
        java.lang.Object ref = metricId_;
        if (ref instanceof java.lang.String) {
          return (java.lang.String) ref;
        } else {
          com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
          java.lang.String s = bs.toStringUtf8();
          metricId_ = s;
          return s;
        }
      }
      /**
       *
       *
       * <pre>
       * Required. The ID of the metric. Must not contain whitespaces.
       * </pre>
       *
       * <code>string metric_id = 1 [(.google.api.field_behavior) = REQUIRED];</code>
       *
       * @return The bytes for metricId.
       */
      @java.lang.Override
      public com.google.protobuf.ByteString getMetricIdBytes() {
        java.lang.Object ref = metricId_;
        if (ref instanceof java.lang.String) {
          com.google.protobuf.ByteString b =
              com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
          metricId_ = b;
          return b;
        } else {
          return (com.google.protobuf.ByteString) ref;
        }
      }

      public static final int GOAL_FIELD_NUMBER = 2;
      private int goal_ = 0;
      /**
       *
       *
       * <pre>
       * Required. The optimization goal of the metric.
       * </pre>
       *
       * <code>
       * .google.cloud.aiplatform.v1beta1.NasJobSpec.MultiTrialAlgorithmSpec.MetricSpec.GoalType goal = 2 [(.google.api.field_behavior) = REQUIRED];
       * </code>
       *
       * @return The enum numeric value on the wire for goal.
       */
      @java.lang.Override
      public int getGoalValue() {
        return goal_;
      }
      /**
       *
       *
       * <pre>
       * Required. The optimization goal of the metric.
       * </pre>
       *
       * <code>
       * .google.cloud.aiplatform.v1beta1.NasJobSpec.MultiTrialAlgorithmSpec.MetricSpec.GoalType goal = 2 [(.google.api.field_behavior) = REQUIRED];
       * </code>
       *
       * @return The goal.
       */
      @java.lang.Override
      public com.google.cloud.aiplatform.v1beta1.NasJobSpec.MultiTrialAlgorithmSpec.MetricSpec
              .GoalType
          getGoal() {
        com.google.cloud.aiplatform.v1beta1.NasJobSpec.MultiTrialAlgorithmSpec.MetricSpec.GoalType
            result =
                com.google.cloud.aiplatform.v1beta1.NasJobSpec.MultiTrialAlgorithmSpec.MetricSpec
                    .GoalType.forNumber(goal_);
        return result == null
            ? com.google.cloud.aiplatform.v1beta1.NasJobSpec.MultiTrialAlgorithmSpec.MetricSpec
                .GoalType.UNRECOGNIZED
            : result;
      }

      private byte memoizedIsInitialized = -1;

      @java.lang.Override
      public final boolean isInitialized() {
        byte isInitialized = memoizedIsInitialized;
        if (isInitialized == 1) return true;
        if (isInitialized == 0) return false;

        memoizedIsInitialized = 1;
        return true;
      }

      @java.lang.Override
      public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
        if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(metricId_)) {
          com.google.protobuf.GeneratedMessageV3.writeString(output, 1, metricId_);
        }
        if (goal_
            != com.google.cloud.aiplatform.v1beta1.NasJobSpec.MultiTrialAlgorithmSpec.MetricSpec
                .GoalType.GOAL_TYPE_UNSPECIFIED
                .getNumber()) {
          output.writeEnum(2, goal_);
        }
        getUnknownFields().writeTo(output);
      }

      @java.lang.Override
      public int getSerializedSize() {
        int size = memoizedSize;
        if (size != -1) return size;

        size = 0;
        if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(metricId_)) {
          size += com.google.protobuf.GeneratedMessageV3.computeStringSize(1, metricId_);
        }
        if (goal_
            != com.google.cloud.aiplatform.v1beta1.NasJobSpec.MultiTrialAlgorithmSpec.MetricSpec
                .GoalType.GOAL_TYPE_UNSPECIFIED
                .getNumber()) {
          size += com.google.protobuf.CodedOutputStream.computeEnumSize(2, goal_);
        }
        size += getUnknownFields().getSerializedSize();
        memoizedSize = size;
        return size;
      }

      @java.lang.Override
      public boolean equals(final java.lang.Object obj) {
        if (obj == this) {
          return true;
        }
        if (!(obj
            instanceof
            com.google.cloud.aiplatform.v1beta1.NasJobSpec.MultiTrialAlgorithmSpec.MetricSpec)) {
          return super.equals(obj);
        }
        com.google.cloud.aiplatform.v1beta1.NasJobSpec.MultiTrialAlgorithmSpec.MetricSpec other =
            (com.google.cloud.aiplatform.v1beta1.NasJobSpec.MultiTrialAlgorithmSpec.MetricSpec) obj;

        if (!getMetricId().equals(other.getMetricId())) return false;
        if (goal_ != other.goal_) return false;
        if (!getUnknownFields().equals(other.getUnknownFields())) return false;
        return true;
      }

      @java.lang.Override
      public int hashCode() {
        if (memoizedHashCode != 0) {
          return memoizedHashCode;
        }
        int hash = 41;
        hash = (19 * hash) + getDescriptor().hashCode();
        hash = (37 * hash) + METRIC_ID_FIELD_NUMBER;
        hash = (53 * hash) + getMetricId().hashCode();
        hash = (37 * hash) + GOAL_FIELD_NUMBER;
        hash = (53 * hash) + goal_;
        hash = (29 * hash) + getUnknownFields().hashCode();
        memoizedHashCode = hash;
        return hash;
      }

      public static com.google.cloud.aiplatform.v1beta1.NasJobSpec.MultiTrialAlgorithmSpec
              .MetricSpec
          parseFrom(java.nio.ByteBuffer data)
              throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data);
      }

      public static com.google.cloud.aiplatform.v1beta1.NasJobSpec.MultiTrialAlgorithmSpec
              .MetricSpec
          parseFrom(
              java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data, extensionRegistry);
      }

      public static com.google.cloud.aiplatform.v1beta1.NasJobSpec.MultiTrialAlgorithmSpec
              .MetricSpec
          parseFrom(com.google.protobuf.ByteString data)
              throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data);
      }

      public static com.google.cloud.aiplatform.v1beta1.NasJobSpec.MultiTrialAlgorithmSpec
              .MetricSpec
          parseFrom(
              com.google.protobuf.ByteString data,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data, extensionRegistry);
      }

      public static com.google.cloud.aiplatform.v1beta1.NasJobSpec.MultiTrialAlgorithmSpec
              .MetricSpec
          parseFrom(byte[] data) throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data);
      }

      public static com.google.cloud.aiplatform.v1beta1.NasJobSpec.MultiTrialAlgorithmSpec
              .MetricSpec
          parseFrom(byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data, extensionRegistry);
      }

      public static com.google.cloud.aiplatform.v1beta1.NasJobSpec.MultiTrialAlgorithmSpec
              .MetricSpec
          parseFrom(java.io.InputStream input) throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
      }

      public static com.google.cloud.aiplatform.v1beta1.NasJobSpec.MultiTrialAlgorithmSpec
              .MetricSpec
          parseFrom(
              java.io.InputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
            PARSER, input, extensionRegistry);
      }

      public static com.google.cloud.aiplatform.v1beta1.NasJobSpec.MultiTrialAlgorithmSpec
              .MetricSpec
          parseDelimitedFrom(java.io.InputStream input) throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
      }

      public static com.google.cloud.aiplatform.v1beta1.NasJobSpec.MultiTrialAlgorithmSpec
              .MetricSpec
          parseDelimitedFrom(
              java.io.InputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
            PARSER, input, extensionRegistry);
      }

      public static com.google.cloud.aiplatform.v1beta1.NasJobSpec.MultiTrialAlgorithmSpec
              .MetricSpec
          parseFrom(com.google.protobuf.CodedInputStream input) throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
      }

      public static com.google.cloud.aiplatform.v1beta1.NasJobSpec.MultiTrialAlgorithmSpec
              .MetricSpec
          parseFrom(
              com.google.protobuf.CodedInputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
            PARSER, input, extensionRegistry);
      }

      @java.lang.Override
      public Builder newBuilderForType() {
        return newBuilder();
      }

      public static Builder newBuilder() {
        return DEFAULT_INSTANCE.toBuilder();
      }

      public static Builder newBuilder(
          com.google.cloud.aiplatform.v1beta1.NasJobSpec.MultiTrialAlgorithmSpec.MetricSpec
              prototype) {
        return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
      }

      @java.lang.Override
      public Builder toBuilder() {
        return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
      }

      @java.lang.Override
      protected Builder newBuilderForType(
          com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
        Builder builder = new Builder(parent);
        return builder;
      }
      /**
       *
       *
       * <pre>
       * Represents a metric to optimize.
       * </pre>
       *
       * Protobuf type {@code
       * google.cloud.aiplatform.v1beta1.NasJobSpec.MultiTrialAlgorithmSpec.MetricSpec}
       */
      public static final class Builder
          extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
          implements
          // @@protoc_insertion_point(builder_implements:google.cloud.aiplatform.v1beta1.NasJobSpec.MultiTrialAlgorithmSpec.MetricSpec)
          com.google.cloud.aiplatform.v1beta1.NasJobSpec.MultiTrialAlgorithmSpec
              .MetricSpecOrBuilder {
        public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
          return com.google.cloud.aiplatform.v1beta1.NasJobProto
              .internal_static_google_cloud_aiplatform_v1beta1_NasJobSpec_MultiTrialAlgorithmSpec_MetricSpec_descriptor;
        }

        @java.lang.Override
        protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
            internalGetFieldAccessorTable() {
          return com.google.cloud.aiplatform.v1beta1.NasJobProto
              .internal_static_google_cloud_aiplatform_v1beta1_NasJobSpec_MultiTrialAlgorithmSpec_MetricSpec_fieldAccessorTable
              .ensureFieldAccessorsInitialized(
                  com.google.cloud.aiplatform.v1beta1.NasJobSpec.MultiTrialAlgorithmSpec.MetricSpec
                      .class,
                  com.google.cloud.aiplatform.v1beta1.NasJobSpec.MultiTrialAlgorithmSpec.MetricSpec
                      .Builder.class);
        }

        // Construct using
        // com.google.cloud.aiplatform.v1beta1.NasJobSpec.MultiTrialAlgorithmSpec.MetricSpec.newBuilder()
        private Builder() {}

        private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
          super(parent);
        }

        @java.lang.Override
        public Builder clear() {
          super.clear();
          bitField0_ = 0;
          metricId_ = "";
          goal_ = 0;
          return this;
        }

        @java.lang.Override
        public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
          return com.google.cloud.aiplatform.v1beta1.NasJobProto
              .internal_static_google_cloud_aiplatform_v1beta1_NasJobSpec_MultiTrialAlgorithmSpec_MetricSpec_descriptor;
        }

        @java.lang.Override
        public com.google.cloud.aiplatform.v1beta1.NasJobSpec.MultiTrialAlgorithmSpec.MetricSpec
            getDefaultInstanceForType() {
          return com.google.cloud.aiplatform.v1beta1.NasJobSpec.MultiTrialAlgorithmSpec.MetricSpec
              .getDefaultInstance();
        }

        @java.lang.Override
        public com.google.cloud.aiplatform.v1beta1.NasJobSpec.MultiTrialAlgorithmSpec.MetricSpec
            build() {
          com.google.cloud.aiplatform.v1beta1.NasJobSpec.MultiTrialAlgorithmSpec.MetricSpec result =
              buildPartial();
          if (!result.isInitialized()) {
            throw newUninitializedMessageException(result);
          }
          return result;
        }

        @java.lang.Override
        public com.google.cloud.aiplatform.v1beta1.NasJobSpec.MultiTrialAlgorithmSpec.MetricSpec
            buildPartial() {
          com.google.cloud.aiplatform.v1beta1.NasJobSpec.MultiTrialAlgorithmSpec.MetricSpec result =
              new com.google.cloud.aiplatform.v1beta1.NasJobSpec.MultiTrialAlgorithmSpec.MetricSpec(
                  this);
          if (bitField0_ != 0) {
            buildPartial0(result);
          }
          onBuilt();
          return result;
        }

        private void buildPartial0(
            com.google.cloud.aiplatform.v1beta1.NasJobSpec.MultiTrialAlgorithmSpec.MetricSpec
                result) {
          int from_bitField0_ = bitField0_;
          if (((from_bitField0_ & 0x00000001) != 0)) {
            result.metricId_ = metricId_;
          }
          if (((from_bitField0_ & 0x00000002) != 0)) {
            result.goal_ = goal_;
          }
        }

        @java.lang.Override
        public Builder clone() {
          return super.clone();
        }

        @java.lang.Override
        public Builder setField(
            com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
          return super.setField(field, value);
        }

        @java.lang.Override
        public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
          return super.clearField(field);
        }

        @java.lang.Override
        public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
          return super.clearOneof(oneof);
        }

        @java.lang.Override
        public Builder setRepeatedField(
            com.google.protobuf.Descriptors.FieldDescriptor field,
            int index,
            java.lang.Object value) {
          return super.setRepeatedField(field, index, value);
        }

        @java.lang.Override
        public Builder addRepeatedField(
            com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
          return super.addRepeatedField(field, value);
        }

        @java.lang.Override
        public Builder mergeFrom(com.google.protobuf.Message other) {
          if (other
              instanceof
              com.google.cloud.aiplatform.v1beta1.NasJobSpec.MultiTrialAlgorithmSpec.MetricSpec) {
            return mergeFrom(
                (com.google.cloud.aiplatform.v1beta1.NasJobSpec.MultiTrialAlgorithmSpec.MetricSpec)
                    other);
          } else {
            super.mergeFrom(other);
            return this;
          }
        }

        public Builder mergeFrom(
            com.google.cloud.aiplatform.v1beta1.NasJobSpec.MultiTrialAlgorithmSpec.MetricSpec
                other) {
          if (other
              == com.google.cloud.aiplatform.v1beta1.NasJobSpec.MultiTrialAlgorithmSpec.MetricSpec
                  .getDefaultInstance()) return this;
          if (!other.getMetricId().isEmpty()) {
            metricId_ = other.metricId_;
            bitField0_ |= 0x00000001;
            onChanged();
          }
          if (other.goal_ != 0) {
            setGoalValue(other.getGoalValue());
          }
          this.mergeUnknownFields(other.getUnknownFields());
          onChanged();
          return this;
        }

        @java.lang.Override
        public final boolean isInitialized() {
          return true;
        }

        @java.lang.Override
        public Builder mergeFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws java.io.IOException {
          if (extensionRegistry == null) {
            throw new java.lang.NullPointerException();
          }
          try {
            boolean done = false;
            while (!done) {
              int tag = input.readTag();
              switch (tag) {
                case 0:
                  done = true;
                  break;
                case 10:
                  {
                    metricId_ = input.readStringRequireUtf8();
                    bitField0_ |= 0x00000001;
                    break;
                  } // case 10
                case 16:
                  {
                    goal_ = input.readEnum();
                    bitField0_ |= 0x00000002;
                    break;
                  } // case 16
                default:
                  {
                    if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                      done = true; // was an endgroup tag
                    }
                    break;
                  } // default:
              } // switch (tag)
            } // while (!done)
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.unwrapIOException();
          } finally {
            onChanged();
          } // finally
          return this;
        }

        private int bitField0_;

        private java.lang.Object metricId_ = "";
        /**
         *
         *
         * <pre>
         * Required. The ID of the metric. Must not contain whitespaces.
         * </pre>
         *
         * <code>string metric_id = 1 [(.google.api.field_behavior) = REQUIRED];</code>
         *
         * @return The metricId.
         */
        public java.lang.String getMetricId() {
          java.lang.Object ref = metricId_;
          if (!(ref instanceof java.lang.String)) {
            com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
            java.lang.String s = bs.toStringUtf8();
            metricId_ = s;
            return s;
          } else {
            return (java.lang.String) ref;
          }
        }
        /**
         *
         *
         * <pre>
         * Required. The ID of the metric. Must not contain whitespaces.
         * </pre>
         *
         * <code>string metric_id = 1 [(.google.api.field_behavior) = REQUIRED];</code>
         *
         * @return The bytes for metricId.
         */
        public com.google.protobuf.ByteString getMetricIdBytes() {
          java.lang.Object ref = metricId_;
          if (ref instanceof String) {
            com.google.protobuf.ByteString b =
                com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
            metricId_ = b;
            return b;
          } else {
            return (com.google.protobuf.ByteString) ref;
          }
        }
        /**
         *
         *
         * <pre>
         * Required. The ID of the metric. Must not contain whitespaces.
         * </pre>
         *
         * <code>string metric_id = 1 [(.google.api.field_behavior) = REQUIRED];</code>
         *
         * @param value The metricId to set.
         * @return This builder for chaining.
         */
        public Builder setMetricId(java.lang.String value) {
          if (value == null) {
            throw new NullPointerException();
          }
          metricId_ = value;
          bitField0_ |= 0x00000001;
          onChanged();
          return this;
        }
        /**
         *
         *
         * <pre>
         * Required. The ID of the metric. Must not contain whitespaces.
         * </pre>
         *
         * <code>string metric_id = 1 [(.google.api.field_behavior) = REQUIRED];</code>
         *
         * @return This builder for chaining.
         */
        public Builder clearMetricId() {
          metricId_ = getDefaultInstance().getMetricId();
          bitField0_ = (bitField0_ & ~0x00000001);
          onChanged();
          return this;
        }
        /**
         *
         *
         * <pre>
         * Required. The ID of the metric. Must not contain whitespaces.
         * </pre>
         *
         * <code>string metric_id = 1 [(.google.api.field_behavior) = REQUIRED];</code>
         *
         * @param value The bytes for metricId to set.
         * @return This builder for chaining.
         */
        public Builder setMetricIdBytes(com.google.protobuf.ByteString value) {
          if (value == null) {
            throw new NullPointerException();
          }
          checkByteStringIsUtf8(value);
          metricId_ = value;
          bitField0_ |= 0x00000001;
          onChanged();
          return this;
        }

        private int goal_ = 0;
        /**
         *
         *
         * <pre>
         * Required. The optimization goal of the metric.
         * </pre>
         *
         * <code>
         * .google.cloud.aiplatform.v1beta1.NasJobSpec.MultiTrialAlgorithmSpec.MetricSpec.GoalType goal = 2 [(.google.api.field_behavior) = REQUIRED];
         * </code>
         *
         * @return The enum numeric value on the wire for goal.
         */
        @java.lang.Override
        public int getGoalValue() {
          return goal_;
        }
        /**
         *
         *
         * <pre>
         * Required. The optimization goal of the metric.
         * </pre>
         *
         * <code>
         * .google.cloud.aiplatform.v1beta1.NasJobSpec.MultiTrialAlgorithmSpec.MetricSpec.GoalType goal = 2 [(.google.api.field_behavior) = REQUIRED];
         * </code>
         *
         * @param value The enum numeric value on the wire for goal to set.
         * @return This builder for chaining.
         */
        public Builder setGoalValue(int value) {
          goal_ = value;
          bitField0_ |= 0x00000002;
          onChanged();
          return this;
        }
        /**
         *
         *
         * <pre>
         * Required. The optimization goal of the metric.
         * </pre>
         *
         * <code>
         * .google.cloud.aiplatform.v1beta1.NasJobSpec.MultiTrialAlgorithmSpec.MetricSpec.GoalType goal = 2 [(.google.api.field_behavior) = REQUIRED];
         * </code>
         *
         * @return The goal.
         */
        @java.lang.Override
        public com.google.cloud.aiplatform.v1beta1.NasJobSpec.MultiTrialAlgorithmSpec.MetricSpec
                .GoalType
            getGoal() {
          com.google.cloud.aiplatform.v1beta1.NasJobSpec.MultiTrialAlgorithmSpec.MetricSpec.GoalType
              result =
                  com.google.cloud.aiplatform.v1beta1.NasJobSpec.MultiTrialAlgorithmSpec.MetricSpec
                      .GoalType.forNumber(goal_);
          return result == null
              ? com.google.cloud.aiplatform.v1beta1.NasJobSpec.MultiTrialAlgorithmSpec.MetricSpec
                  .GoalType.UNRECOGNIZED
              : result;
        }
        /**
         *
         *
         * <pre>
         * Required. The optimization goal of the metric.
         * </pre>
         *
         * <code>
         * .google.cloud.aiplatform.v1beta1.NasJobSpec.MultiTrialAlgorithmSpec.MetricSpec.GoalType goal = 2 [(.google.api.field_behavior) = REQUIRED];
         * </code>
         *
         * @param value The goal to set.
         * @return This builder for chaining.
         */
        public Builder setGoal(
            com.google.cloud.aiplatform.v1beta1.NasJobSpec.MultiTrialAlgorithmSpec.MetricSpec
                    .GoalType
                value) {
          if (value == null) {
            throw new NullPointerException();
          }
          bitField0_ |= 0x00000002;
          goal_ = value.getNumber();
          onChanged();
          return this;
        }
        /**
         *
         *
         * <pre>
         * Required. The optimization goal of the metric.
         * </pre>
         *
         * <code>
         * .google.cloud.aiplatform.v1beta1.NasJobSpec.MultiTrialAlgorithmSpec.MetricSpec.GoalType goal = 2 [(.google.api.field_behavior) = REQUIRED];
         * </code>
         *
         * @return This builder for chaining.
         */
        public Builder clearGoal() {
          bitField0_ = (bitField0_ & ~0x00000002);
          goal_ = 0;
          onChanged();
          return this;
        }

        @java.lang.Override
        public final Builder setUnknownFields(
            final com.google.protobuf.UnknownFieldSet unknownFields) {
          return super.setUnknownFields(unknownFields);
        }

        @java.lang.Override
        public final Builder mergeUnknownFields(
            final com.google.protobuf.UnknownFieldSet unknownFields) {
          return super.mergeUnknownFields(unknownFields);
        }

        // @@protoc_insertion_point(builder_scope:google.cloud.aiplatform.v1beta1.NasJobSpec.MultiTrialAlgorithmSpec.MetricSpec)
      }

      // @@protoc_insertion_point(class_scope:google.cloud.aiplatform.v1beta1.NasJobSpec.MultiTrialAlgorithmSpec.MetricSpec)
      private static final com.google.cloud.aiplatform.v1beta1.NasJobSpec.MultiTrialAlgorithmSpec
              .MetricSpec
          DEFAULT_INSTANCE;

      static {
        DEFAULT_INSTANCE =
            new com.google.cloud.aiplatform.v1beta1.NasJobSpec.MultiTrialAlgorithmSpec.MetricSpec();
      }

      public static com.google.cloud.aiplatform.v1beta1.NasJobSpec.MultiTrialAlgorithmSpec
              .MetricSpec
          getDefaultInstance() {
        return DEFAULT_INSTANCE;
      }

      private static final com.google.protobuf.Parser<MetricSpec> PARSER =
          new com.google.protobuf.AbstractParser<MetricSpec>() {
            @java.lang.Override
            public MetricSpec parsePartialFrom(
                com.google.protobuf.CodedInputStream input,
                com.google.protobuf.ExtensionRegistryLite extensionRegistry)
                throws com.google.protobuf.InvalidProtocolBufferException {
              Builder builder = newBuilder();
              try {
                builder.mergeFrom(input, extensionRegistry);
              } catch (com.google.protobuf.InvalidProtocolBufferException e) {
                throw e.setUnfinishedMessage(builder.buildPartial());
              } catch (com.google.protobuf.UninitializedMessageException e) {
                throw e.asInvalidProtocolBufferException()
                    .setUnfinishedMessage(builder.buildPartial());
              } catch (java.io.IOException e) {
                throw new com.google.protobuf.InvalidProtocolBufferException(e)
                    .setUnfinishedMessage(builder.buildPartial());
              }
              return builder.buildPartial();
            }
          };

      public static com.google.protobuf.Parser<MetricSpec> parser() {
        return PARSER;
      }

      @java.lang.Override
      public com.google.protobuf.Parser<MetricSpec> getParserForType() {
        return PARSER;
      }

      @java.lang.Override
      public com.google.cloud.aiplatform.v1beta1.NasJobSpec.MultiTrialAlgorithmSpec.MetricSpec
          getDefaultInstanceForType() {
        return DEFAULT_INSTANCE;
      }
    }

    public interface SearchTrialSpecOrBuilder
        extends
        // @@protoc_insertion_point(interface_extends:google.cloud.aiplatform.v1beta1.NasJobSpec.MultiTrialAlgorithmSpec.SearchTrialSpec)
        com.google.protobuf.MessageOrBuilder {

      /**
       *
       *
       * <pre>
       * Required. The spec of a search trial job. The same spec applies to
       * all search trials.
       * </pre>
       *
       * <code>
       * .google.cloud.aiplatform.v1beta1.CustomJobSpec search_trial_job_spec = 1 [(.google.api.field_behavior) = REQUIRED];
       * </code>
       *
       * @return Whether the searchTrialJobSpec field is set.
       */
      boolean hasSearchTrialJobSpec();
      /**
       *
       *
       * <pre>
       * Required. The spec of a search trial job. The same spec applies to
       * all search trials.
       * </pre>
       *
       * <code>
       * .google.cloud.aiplatform.v1beta1.CustomJobSpec search_trial_job_spec = 1 [(.google.api.field_behavior) = REQUIRED];
       * </code>
       *
       * @return The searchTrialJobSpec.
       */
      com.google.cloud.aiplatform.v1beta1.CustomJobSpec getSearchTrialJobSpec();
      /**
       *
       *
       * <pre>
       * Required. The spec of a search trial job. The same spec applies to
       * all search trials.
       * </pre>
       *
       * <code>
       * .google.cloud.aiplatform.v1beta1.CustomJobSpec search_trial_job_spec = 1 [(.google.api.field_behavior) = REQUIRED];
       * </code>
       */
      com.google.cloud.aiplatform.v1beta1.CustomJobSpecOrBuilder getSearchTrialJobSpecOrBuilder();

      /**
       *
       *
       * <pre>
       * Required. The maximum number of Neural Architecture Search (NAS) trials
       * to run.
       * </pre>
       *
       * <code>int32 max_trial_count = 2 [(.google.api.field_behavior) = REQUIRED];</code>
       *
       * @return The maxTrialCount.
       */
      int getMaxTrialCount();

      /**
       *
       *
       * <pre>
       * Required. The maximum number of trials to run in parallel.
       * </pre>
       *
       * <code>int32 max_parallel_trial_count = 3 [(.google.api.field_behavior) = REQUIRED];</code>
       *
       * @return The maxParallelTrialCount.
       */
      int getMaxParallelTrialCount();

      /**
       *
       *
       * <pre>
       * The number of failed trials that need to be seen before failing
       * the NasJob.
       *
       * If set to 0, Vertex AI decides how many trials must fail
       * before the whole job fails.
       * </pre>
       *
       * <code>int32 max_failed_trial_count = 4;</code>
       *
       * @return The maxFailedTrialCount.
       */
      int getMaxFailedTrialCount();
    }
    /**
     *
     *
     * <pre>
     * Represent spec for search trials.
     * </pre>
     *
     * Protobuf type {@code
     * google.cloud.aiplatform.v1beta1.NasJobSpec.MultiTrialAlgorithmSpec.SearchTrialSpec}
     */
    public static final class SearchTrialSpec extends com.google.protobuf.GeneratedMessageV3
        implements
        // @@protoc_insertion_point(message_implements:google.cloud.aiplatform.v1beta1.NasJobSpec.MultiTrialAlgorithmSpec.SearchTrialSpec)
        SearchTrialSpecOrBuilder {
      private static final long serialVersionUID = 0L;
      // Use SearchTrialSpec.newBuilder() to construct.
      private SearchTrialSpec(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
        super(builder);
      }

      private SearchTrialSpec() {}

      @java.lang.Override
      @SuppressWarnings({"unused"})
      protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
        return new SearchTrialSpec();
      }

      public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
        return com.google.cloud.aiplatform.v1beta1.NasJobProto
            .internal_static_google_cloud_aiplatform_v1beta1_NasJobSpec_MultiTrialAlgorithmSpec_SearchTrialSpec_descriptor;
      }

      @java.lang.Override
      protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return com.google.cloud.aiplatform.v1beta1.NasJobProto
            .internal_static_google_cloud_aiplatform_v1beta1_NasJobSpec_MultiTrialAlgorithmSpec_SearchTrialSpec_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                com.google.cloud.aiplatform.v1beta1.NasJobSpec.MultiTrialAlgorithmSpec
                    .SearchTrialSpec.class,
                com.google.cloud.aiplatform.v1beta1.NasJobSpec.MultiTrialAlgorithmSpec
                    .SearchTrialSpec.Builder.class);
      }

      private int bitField0_;
      public static final int SEARCH_TRIAL_JOB_SPEC_FIELD_NUMBER = 1;
      private com.google.cloud.aiplatform.v1beta1.CustomJobSpec searchTrialJobSpec_;
      /**
       *
       *
       * <pre>
       * Required. The spec of a search trial job. The same spec applies to
       * all search trials.
       * </pre>
       *
       * <code>
       * .google.cloud.aiplatform.v1beta1.CustomJobSpec search_trial_job_spec = 1 [(.google.api.field_behavior) = REQUIRED];
       * </code>
       *
       * @return Whether the searchTrialJobSpec field is set.
       */
      @java.lang.Override
      public boolean hasSearchTrialJobSpec() {
        return ((bitField0_ & 0x00000001) != 0);
      }
      /**
       *
       *
       * <pre>
       * Required. The spec of a search trial job. The same spec applies to
       * all search trials.
       * </pre>
       *
       * <code>
       * .google.cloud.aiplatform.v1beta1.CustomJobSpec search_trial_job_spec = 1 [(.google.api.field_behavior) = REQUIRED];
       * </code>
       *
       * @return The searchTrialJobSpec.
       */
      @java.lang.Override
      public com.google.cloud.aiplatform.v1beta1.CustomJobSpec getSearchTrialJobSpec() {
        return searchTrialJobSpec_ == null
            ? com.google.cloud.aiplatform.v1beta1.CustomJobSpec.getDefaultInstance()
            : searchTrialJobSpec_;
      }
      /**
       *
       *
       * <pre>
       * Required. The spec of a search trial job. The same spec applies to
       * all search trials.
       * </pre>
       *
       * <code>
       * .google.cloud.aiplatform.v1beta1.CustomJobSpec search_trial_job_spec = 1 [(.google.api.field_behavior) = REQUIRED];
       * </code>
       */
      @java.lang.Override
      public com.google.cloud.aiplatform.v1beta1.CustomJobSpecOrBuilder
          getSearchTrialJobSpecOrBuilder() {
        return searchTrialJobSpec_ == null
            ? com.google.cloud.aiplatform.v1beta1.CustomJobSpec.getDefaultInstance()
            : searchTrialJobSpec_;
      }

      public static final int MAX_TRIAL_COUNT_FIELD_NUMBER = 2;
      private int maxTrialCount_ = 0;
      /**
       *
       *
       * <pre>
       * Required. The maximum number of Neural Architecture Search (NAS) trials
       * to run.
       * </pre>
       *
       * <code>int32 max_trial_count = 2 [(.google.api.field_behavior) = REQUIRED];</code>
       *
       * @return The maxTrialCount.
       */
      @java.lang.Override
      public int getMaxTrialCount() {
        return maxTrialCount_;
      }

      public static final int MAX_PARALLEL_TRIAL_COUNT_FIELD_NUMBER = 3;
      private int maxParallelTrialCount_ = 0;
      /**
       *
       *
       * <pre>
       * Required. The maximum number of trials to run in parallel.
       * </pre>
       *
       * <code>int32 max_parallel_trial_count = 3 [(.google.api.field_behavior) = REQUIRED];</code>
       *
       * @return The maxParallelTrialCount.
       */
      @java.lang.Override
      public int getMaxParallelTrialCount() {
        return maxParallelTrialCount_;
      }

      public static final int MAX_FAILED_TRIAL_COUNT_FIELD_NUMBER = 4;
      private int maxFailedTrialCount_ = 0;
      /**
       *
       *
       * <pre>
       * The number of failed trials that need to be seen before failing
       * the NasJob.
       *
       * If set to 0, Vertex AI decides how many trials must fail
       * before the whole job fails.
       * </pre>
       *
       * <code>int32 max_failed_trial_count = 4;</code>
       *
       * @return The maxFailedTrialCount.
       */
      @java.lang.Override
      public int getMaxFailedTrialCount() {
        return maxFailedTrialCount_;
      }

      private byte memoizedIsInitialized = -1;

      @java.lang.Override
      public final boolean isInitialized() {
        byte isInitialized = memoizedIsInitialized;
        if (isInitialized == 1) return true;
        if (isInitialized == 0) return false;

        memoizedIsInitialized = 1;
        return true;
      }

      @java.lang.Override
      public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
        if (((bitField0_ & 0x00000001) != 0)) {
          output.writeMessage(1, getSearchTrialJobSpec());
        }
        if (maxTrialCount_ != 0) {
          output.writeInt32(2, maxTrialCount_);
        }
        if (maxParallelTrialCount_ != 0) {
          output.writeInt32(3, maxParallelTrialCount_);
        }
        if (maxFailedTrialCount_ != 0) {
          output.writeInt32(4, maxFailedTrialCount_);
        }
        getUnknownFields().writeTo(output);
      }

      @java.lang.Override
      public int getSerializedSize() {
        int size = memoizedSize;
        if (size != -1) return size;

        size = 0;
        if (((bitField0_ & 0x00000001) != 0)) {
          size +=
              com.google.protobuf.CodedOutputStream.computeMessageSize(1, getSearchTrialJobSpec());
        }
        if (maxTrialCount_ != 0) {
          size += com.google.protobuf.CodedOutputStream.computeInt32Size(2, maxTrialCount_);
        }
        if (maxParallelTrialCount_ != 0) {
          size += com.google.protobuf.CodedOutputStream.computeInt32Size(3, maxParallelTrialCount_);
        }
        if (maxFailedTrialCount_ != 0) {
          size += com.google.protobuf.CodedOutputStream.computeInt32Size(4, maxFailedTrialCount_);
        }
        size += getUnknownFields().getSerializedSize();
        memoizedSize = size;
        return size;
      }

      @java.lang.Override
      public boolean equals(final java.lang.Object obj) {
        if (obj == this) {
          return true;
        }
        if (!(obj
            instanceof
            com.google.cloud.aiplatform.v1beta1.NasJobSpec.MultiTrialAlgorithmSpec
                .SearchTrialSpec)) {
          return super.equals(obj);
        }
        com.google.cloud.aiplatform.v1beta1.NasJobSpec.MultiTrialAlgorithmSpec.SearchTrialSpec
            other =
                (com.google.cloud.aiplatform.v1beta1.NasJobSpec.MultiTrialAlgorithmSpec
                        .SearchTrialSpec)
                    obj;

        if (hasSearchTrialJobSpec() != other.hasSearchTrialJobSpec()) return false;
        if (hasSearchTrialJobSpec()) {
          if (!getSearchTrialJobSpec().equals(other.getSearchTrialJobSpec())) return false;
        }
        if (getMaxTrialCount() != other.getMaxTrialCount()) return false;
        if (getMaxParallelTrialCount() != other.getMaxParallelTrialCount()) return false;
        if (getMaxFailedTrialCount() != other.getMaxFailedTrialCount()) return false;
        if (!getUnknownFields().equals(other.getUnknownFields())) return false;
        return true;
      }

      @java.lang.Override
      public int hashCode() {
        if (memoizedHashCode != 0) {
          return memoizedHashCode;
        }
        int hash = 41;
        hash = (19 * hash) + getDescriptor().hashCode();
        if (hasSearchTrialJobSpec()) {
          hash = (37 * hash) + SEARCH_TRIAL_JOB_SPEC_FIELD_NUMBER;
          hash = (53 * hash) + getSearchTrialJobSpec().hashCode();
        }
        hash = (37 * hash) + MAX_TRIAL_COUNT_FIELD_NUMBER;
        hash = (53 * hash) + getMaxTrialCount();
        hash = (37 * hash) + MAX_PARALLEL_TRIAL_COUNT_FIELD_NUMBER;
        hash = (53 * hash) + getMaxParallelTrialCount();
        hash = (37 * hash) + MAX_FAILED_TRIAL_COUNT_FIELD_NUMBER;
        hash = (53 * hash) + getMaxFailedTrialCount();
        hash = (29 * hash) + getUnknownFields().hashCode();
        memoizedHashCode = hash;
        return hash;
      }

      public static com.google.cloud.aiplatform.v1beta1.NasJobSpec.MultiTrialAlgorithmSpec
              .SearchTrialSpec
          parseFrom(java.nio.ByteBuffer data)
              throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data);
      }

      public static com.google.cloud.aiplatform.v1beta1.NasJobSpec.MultiTrialAlgorithmSpec
              .SearchTrialSpec
          parseFrom(
              java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data, extensionRegistry);
      }

      public static com.google.cloud.aiplatform.v1beta1.NasJobSpec.MultiTrialAlgorithmSpec
              .SearchTrialSpec
          parseFrom(com.google.protobuf.ByteString data)
              throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data);
      }

      public static com.google.cloud.aiplatform.v1beta1.NasJobSpec.MultiTrialAlgorithmSpec
              .SearchTrialSpec
          parseFrom(
              com.google.protobuf.ByteString data,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data, extensionRegistry);
      }

      public static com.google.cloud.aiplatform.v1beta1.NasJobSpec.MultiTrialAlgorithmSpec
              .SearchTrialSpec
          parseFrom(byte[] data) throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data);
      }

      public static com.google.cloud.aiplatform.v1beta1.NasJobSpec.MultiTrialAlgorithmSpec
              .SearchTrialSpec
          parseFrom(byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data, extensionRegistry);
      }

      public static com.google.cloud.aiplatform.v1beta1.NasJobSpec.MultiTrialAlgorithmSpec
              .SearchTrialSpec
          parseFrom(java.io.InputStream input) throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
      }

      public static com.google.cloud.aiplatform.v1beta1.NasJobSpec.MultiTrialAlgorithmSpec
              .SearchTrialSpec
          parseFrom(
              java.io.InputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
            PARSER, input, extensionRegistry);
      }

      public static com.google.cloud.aiplatform.v1beta1.NasJobSpec.MultiTrialAlgorithmSpec
              .SearchTrialSpec
          parseDelimitedFrom(java.io.InputStream input) throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
      }

      public static com.google.cloud.aiplatform.v1beta1.NasJobSpec.MultiTrialAlgorithmSpec
              .SearchTrialSpec
          parseDelimitedFrom(
              java.io.InputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
            PARSER, input, extensionRegistry);
      }

      public static com.google.cloud.aiplatform.v1beta1.NasJobSpec.MultiTrialAlgorithmSpec
              .SearchTrialSpec
          parseFrom(com.google.protobuf.CodedInputStream input) throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
      }

      public static com.google.cloud.aiplatform.v1beta1.NasJobSpec.MultiTrialAlgorithmSpec
              .SearchTrialSpec
          parseFrom(
              com.google.protobuf.CodedInputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
            PARSER, input, extensionRegistry);
      }

      @java.lang.Override
      public Builder newBuilderForType() {
        return newBuilder();
      }

      public static Builder newBuilder() {
        return DEFAULT_INSTANCE.toBuilder();
      }

      public static Builder newBuilder(
          com.google.cloud.aiplatform.v1beta1.NasJobSpec.MultiTrialAlgorithmSpec.SearchTrialSpec
              prototype) {
        return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
      }

      @java.lang.Override
      public Builder toBuilder() {
        return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
      }

      @java.lang.Override
      protected Builder newBuilderForType(
          com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
        Builder builder = new Builder(parent);
        return builder;
      }
      /**
       *
       *
       * <pre>
       * Represent spec for search trials.
       * </pre>
       *
       * Protobuf type {@code
       * google.cloud.aiplatform.v1beta1.NasJobSpec.MultiTrialAlgorithmSpec.SearchTrialSpec}
       */
      public static final class Builder
          extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
          implements
          // @@protoc_insertion_point(builder_implements:google.cloud.aiplatform.v1beta1.NasJobSpec.MultiTrialAlgorithmSpec.SearchTrialSpec)
          com.google.cloud.aiplatform.v1beta1.NasJobSpec.MultiTrialAlgorithmSpec
              .SearchTrialSpecOrBuilder {
        public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
          return com.google.cloud.aiplatform.v1beta1.NasJobProto
              .internal_static_google_cloud_aiplatform_v1beta1_NasJobSpec_MultiTrialAlgorithmSpec_SearchTrialSpec_descriptor;
        }

        @java.lang.Override
        protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
            internalGetFieldAccessorTable() {
          return com.google.cloud.aiplatform.v1beta1.NasJobProto
              .internal_static_google_cloud_aiplatform_v1beta1_NasJobSpec_MultiTrialAlgorithmSpec_SearchTrialSpec_fieldAccessorTable
              .ensureFieldAccessorsInitialized(
                  com.google.cloud.aiplatform.v1beta1.NasJobSpec.MultiTrialAlgorithmSpec
                      .SearchTrialSpec.class,
                  com.google.cloud.aiplatform.v1beta1.NasJobSpec.MultiTrialAlgorithmSpec
                      .SearchTrialSpec.Builder.class);
        }

        // Construct using
        // com.google.cloud.aiplatform.v1beta1.NasJobSpec.MultiTrialAlgorithmSpec.SearchTrialSpec.newBuilder()
        private Builder() {
          maybeForceBuilderInitialization();
        }

        private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
          super(parent);
          maybeForceBuilderInitialization();
        }

        private void maybeForceBuilderInitialization() {
          if (com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders) {
            getSearchTrialJobSpecFieldBuilder();
          }
        }

        @java.lang.Override
        public Builder clear() {
          super.clear();
          bitField0_ = 0;
          searchTrialJobSpec_ = null;
          if (searchTrialJobSpecBuilder_ != null) {
            searchTrialJobSpecBuilder_.dispose();
            searchTrialJobSpecBuilder_ = null;
          }
          maxTrialCount_ = 0;
          maxParallelTrialCount_ = 0;
          maxFailedTrialCount_ = 0;
          return this;
        }

        @java.lang.Override
        public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
          return com.google.cloud.aiplatform.v1beta1.NasJobProto
              .internal_static_google_cloud_aiplatform_v1beta1_NasJobSpec_MultiTrialAlgorithmSpec_SearchTrialSpec_descriptor;
        }

        @java.lang.Override
        public com.google.cloud.aiplatform.v1beta1.NasJobSpec.MultiTrialAlgorithmSpec
                .SearchTrialSpec
            getDefaultInstanceForType() {
          return com.google.cloud.aiplatform.v1beta1.NasJobSpec.MultiTrialAlgorithmSpec
              .SearchTrialSpec.getDefaultInstance();
        }

        @java.lang.Override
        public com.google.cloud.aiplatform.v1beta1.NasJobSpec.MultiTrialAlgorithmSpec
                .SearchTrialSpec
            build() {
          com.google.cloud.aiplatform.v1beta1.NasJobSpec.MultiTrialAlgorithmSpec.SearchTrialSpec
              result = buildPartial();
          if (!result.isInitialized()) {
            throw newUninitializedMessageException(result);
          }
          return result;
        }

        @java.lang.Override
        public com.google.cloud.aiplatform.v1beta1.NasJobSpec.MultiTrialAlgorithmSpec
                .SearchTrialSpec
            buildPartial() {
          com.google.cloud.aiplatform.v1beta1.NasJobSpec.MultiTrialAlgorithmSpec.SearchTrialSpec
              result =
                  new com.google.cloud.aiplatform.v1beta1.NasJobSpec.MultiTrialAlgorithmSpec
                      .SearchTrialSpec(this);
          if (bitField0_ != 0) {
            buildPartial0(result);
          }
          onBuilt();
          return result;
        }

        private void buildPartial0(
            com.google.cloud.aiplatform.v1beta1.NasJobSpec.MultiTrialAlgorithmSpec.SearchTrialSpec
                result) {
          int from_bitField0_ = bitField0_;
          int to_bitField0_ = 0;
          if (((from_bitField0_ & 0x00000001) != 0)) {
            result.searchTrialJobSpec_ =
                searchTrialJobSpecBuilder_ == null
                    ? searchTrialJobSpec_
                    : searchTrialJobSpecBuilder_.build();
            to_bitField0_ |= 0x00000001;
          }
          if (((from_bitField0_ & 0x00000002) != 0)) {
            result.maxTrialCount_ = maxTrialCount_;
          }
          if (((from_bitField0_ & 0x00000004) != 0)) {
            result.maxParallelTrialCount_ = maxParallelTrialCount_;
          }
          if (((from_bitField0_ & 0x00000008) != 0)) {
            result.maxFailedTrialCount_ = maxFailedTrialCount_;
          }
          result.bitField0_ |= to_bitField0_;
        }

        @java.lang.Override
        public Builder clone() {
          return super.clone();
        }

        @java.lang.Override
        public Builder setField(
            com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
          return super.setField(field, value);
        }

        @java.lang.Override
        public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
          return super.clearField(field);
        }

        @java.lang.Override
        public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
          return super.clearOneof(oneof);
        }

        @java.lang.Override
        public Builder setRepeatedField(
            com.google.protobuf.Descriptors.FieldDescriptor field,
            int index,
            java.lang.Object value) {
          return super.setRepeatedField(field, index, value);
        }

        @java.lang.Override
        public Builder addRepeatedField(
            com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
          return super.addRepeatedField(field, value);
        }

        @java.lang.Override
        public Builder mergeFrom(com.google.protobuf.Message other) {
          if (other
              instanceof
              com.google.cloud.aiplatform.v1beta1.NasJobSpec.MultiTrialAlgorithmSpec
                  .SearchTrialSpec) {
            return mergeFrom(
                (com.google.cloud.aiplatform.v1beta1.NasJobSpec.MultiTrialAlgorithmSpec
                        .SearchTrialSpec)
                    other);
          } else {
            super.mergeFrom(other);
            return this;
          }
        }

        public Builder mergeFrom(
            com.google.cloud.aiplatform.v1beta1.NasJobSpec.MultiTrialAlgorithmSpec.SearchTrialSpec
                other) {
          if (other
              == com.google.cloud.aiplatform.v1beta1.NasJobSpec.MultiTrialAlgorithmSpec
                  .SearchTrialSpec.getDefaultInstance()) return this;
          if (other.hasSearchTrialJobSpec()) {
            mergeSearchTrialJobSpec(other.getSearchTrialJobSpec());
          }
          if (other.getMaxTrialCount() != 0) {
            setMaxTrialCount(other.getMaxTrialCount());
          }
          if (other.getMaxParallelTrialCount() != 0) {
            setMaxParallelTrialCount(other.getMaxParallelTrialCount());
          }
          if (other.getMaxFailedTrialCount() != 0) {
            setMaxFailedTrialCount(other.getMaxFailedTrialCount());
          }
          this.mergeUnknownFields(other.getUnknownFields());
          onChanged();
          return this;
        }

        @java.lang.Override
        public final boolean isInitialized() {
          return true;
        }

        @java.lang.Override
        public Builder mergeFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws java.io.IOException {
          if (extensionRegistry == null) {
            throw new java.lang.NullPointerException();
          }
          try {
            boolean done = false;
            while (!done) {
              int tag = input.readTag();
              switch (tag) {
                case 0:
                  done = true;
                  break;
                case 10:
                  {
                    input.readMessage(
                        getSearchTrialJobSpecFieldBuilder().getBuilder(), extensionRegistry);
                    bitField0_ |= 0x00000001;
                    break;
                  } // case 10
                case 16:
                  {
                    maxTrialCount_ = input.readInt32();
                    bitField0_ |= 0x00000002;
                    break;
                  } // case 16
                case 24:
                  {
                    maxParallelTrialCount_ = input.readInt32();
                    bitField0_ |= 0x00000004;
                    break;
                  } // case 24
                case 32:
                  {
                    maxFailedTrialCount_ = input.readInt32();
                    bitField0_ |= 0x00000008;
                    break;
                  } // case 32
                default:
                  {
                    if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                      done = true; // was an endgroup tag
                    }
                    break;
                  } // default:
              } // switch (tag)
            } // while (!done)
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.unwrapIOException();
          } finally {
            onChanged();
          } // finally
          return this;
        }

        private int bitField0_;

        private com.google.cloud.aiplatform.v1beta1.CustomJobSpec searchTrialJobSpec_;
        private com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.aiplatform.v1beta1.CustomJobSpec,
                com.google.cloud.aiplatform.v1beta1.CustomJobSpec.Builder,
                com.google.cloud.aiplatform.v1beta1.CustomJobSpecOrBuilder>
            searchTrialJobSpecBuilder_;
        /**
         *
         *
         * <pre>
         * Required. The spec of a search trial job. The same spec applies to
         * all search trials.
         * </pre>
         *
         * <code>
         * .google.cloud.aiplatform.v1beta1.CustomJobSpec search_trial_job_spec = 1 [(.google.api.field_behavior) = REQUIRED];
         * </code>
         *
         * @return Whether the searchTrialJobSpec field is set.
         */
        public boolean hasSearchTrialJobSpec() {
          return ((bitField0_ & 0x00000001) != 0);
        }
        /**
         *
         *
         * <pre>
         * Required. The spec of a search trial job. The same spec applies to
         * all search trials.
         * </pre>
         *
         * <code>
         * .google.cloud.aiplatform.v1beta1.CustomJobSpec search_trial_job_spec = 1 [(.google.api.field_behavior) = REQUIRED];
         * </code>
         *
         * @return The searchTrialJobSpec.
         */
        public com.google.cloud.aiplatform.v1beta1.CustomJobSpec getSearchTrialJobSpec() {
          if (searchTrialJobSpecBuilder_ == null) {
            return searchTrialJobSpec_ == null
                ? com.google.cloud.aiplatform.v1beta1.CustomJobSpec.getDefaultInstance()
                : searchTrialJobSpec_;
          } else {
            return searchTrialJobSpecBuilder_.getMessage();
          }
        }
        /**
         *
         *
         * <pre>
         * Required. The spec of a search trial job. The same spec applies to
         * all search trials.
         * </pre>
         *
         * <code>
         * .google.cloud.aiplatform.v1beta1.CustomJobSpec search_trial_job_spec = 1 [(.google.api.field_behavior) = REQUIRED];
         * </code>
         */
        public Builder setSearchTrialJobSpec(
            com.google.cloud.aiplatform.v1beta1.CustomJobSpec value) {
          if (searchTrialJobSpecBuilder_ == null) {
            if (value == null) {
              throw new NullPointerException();
            }
            searchTrialJobSpec_ = value;
          } else {
            searchTrialJobSpecBuilder_.setMessage(value);
          }
          bitField0_ |= 0x00000001;
          onChanged();
          return this;
        }
        /**
         *
         *
         * <pre>
         * Required. The spec of a search trial job. The same spec applies to
         * all search trials.
         * </pre>
         *
         * <code>
         * .google.cloud.aiplatform.v1beta1.CustomJobSpec search_trial_job_spec = 1 [(.google.api.field_behavior) = REQUIRED];
         * </code>
         */
        public Builder setSearchTrialJobSpec(
            com.google.cloud.aiplatform.v1beta1.CustomJobSpec.Builder builderForValue) {
          if (searchTrialJobSpecBuilder_ == null) {
            searchTrialJobSpec_ = builderForValue.build();
          } else {
            searchTrialJobSpecBuilder_.setMessage(builderForValue.build());
          }
          bitField0_ |= 0x00000001;
          onChanged();
          return this;
        }
        /**
         *
         *
         * <pre>
         * Required. The spec of a search trial job. The same spec applies to
         * all search trials.
         * </pre>
         *
         * <code>
         * .google.cloud.aiplatform.v1beta1.CustomJobSpec search_trial_job_spec = 1 [(.google.api.field_behavior) = REQUIRED];
         * </code>
         */
        public Builder mergeSearchTrialJobSpec(
            com.google.cloud.aiplatform.v1beta1.CustomJobSpec value) {
          if (searchTrialJobSpecBuilder_ == null) {
            if (((bitField0_ & 0x00000001) != 0)
                && searchTrialJobSpec_ != null
                && searchTrialJobSpec_
                    != com.google.cloud.aiplatform.v1beta1.CustomJobSpec.getDefaultInstance()) {
              getSearchTrialJobSpecBuilder().mergeFrom(value);
            } else {
              searchTrialJobSpec_ = value;
            }
          } else {
            searchTrialJobSpecBuilder_.mergeFrom(value);
          }
          if (searchTrialJobSpec_ != null) {
            bitField0_ |= 0x00000001;
            onChanged();
          }
          return this;
        }
        /**
         *
         *
         * <pre>
         * Required. The spec of a search trial job. The same spec applies to
         * all search trials.
         * </pre>
         *
         * <code>
         * .google.cloud.aiplatform.v1beta1.CustomJobSpec search_trial_job_spec = 1 [(.google.api.field_behavior) = REQUIRED];
         * </code>
         */
        public Builder clearSearchTrialJobSpec() {
          bitField0_ = (bitField0_ & ~0x00000001);
          searchTrialJobSpec_ = null;
          if (searchTrialJobSpecBuilder_ != null) {
            searchTrialJobSpecBuilder_.dispose();
            searchTrialJobSpecBuilder_ = null;
          }
          onChanged();
          return this;
        }
        /**
         *
         *
         * <pre>
         * Required. The spec of a search trial job. The same spec applies to
         * all search trials.
         * </pre>
         *
         * <code>
         * .google.cloud.aiplatform.v1beta1.CustomJobSpec search_trial_job_spec = 1 [(.google.api.field_behavior) = REQUIRED];
         * </code>
         */
        public com.google.cloud.aiplatform.v1beta1.CustomJobSpec.Builder
            getSearchTrialJobSpecBuilder() {
          bitField0_ |= 0x00000001;
          onChanged();
          return getSearchTrialJobSpecFieldBuilder().getBuilder();
        }
        /**
         *
         *
         * <pre>
         * Required. The spec of a search trial job. The same spec applies to
         * all search trials.
         * </pre>
         *
         * <code>
         * .google.cloud.aiplatform.v1beta1.CustomJobSpec search_trial_job_spec = 1 [(.google.api.field_behavior) = REQUIRED];
         * </code>
         */
        public com.google.cloud.aiplatform.v1beta1.CustomJobSpecOrBuilder
            getSearchTrialJobSpecOrBuilder() {
          if (searchTrialJobSpecBuilder_ != null) {
            return searchTrialJobSpecBuilder_.getMessageOrBuilder();
          } else {
            return searchTrialJobSpec_ == null
                ? com.google.cloud.aiplatform.v1beta1.CustomJobSpec.getDefaultInstance()
                : searchTrialJobSpec_;
          }
        }
        /**
         *
         *
         * <pre>
         * Required. The spec of a search trial job. The same spec applies to
         * all search trials.
         * </pre>
         *
         * <code>
         * .google.cloud.aiplatform.v1beta1.CustomJobSpec search_trial_job_spec = 1 [(.google.api.field_behavior) = REQUIRED];
         * </code>
         */
        private com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.aiplatform.v1beta1.CustomJobSpec,
                com.google.cloud.aiplatform.v1beta1.CustomJobSpec.Builder,
                com.google.cloud.aiplatform.v1beta1.CustomJobSpecOrBuilder>
            getSearchTrialJobSpecFieldBuilder() {
          if (searchTrialJobSpecBuilder_ == null) {
            searchTrialJobSpecBuilder_ =
                new com.google.protobuf.SingleFieldBuilderV3<
                    com.google.cloud.aiplatform.v1beta1.CustomJobSpec,
                    com.google.cloud.aiplatform.v1beta1.CustomJobSpec.Builder,
                    com.google.cloud.aiplatform.v1beta1.CustomJobSpecOrBuilder>(
                    getSearchTrialJobSpec(), getParentForChildren(), isClean());
            searchTrialJobSpec_ = null;
          }
          return searchTrialJobSpecBuilder_;
        }

        private int maxTrialCount_;
        /**
         *
         *
         * <pre>
         * Required. The maximum number of Neural Architecture Search (NAS) trials
         * to run.
         * </pre>
         *
         * <code>int32 max_trial_count = 2 [(.google.api.field_behavior) = REQUIRED];</code>
         *
         * @return The maxTrialCount.
         */
        @java.lang.Override
        public int getMaxTrialCount() {
          return maxTrialCount_;
        }
        /**
         *
         *
         * <pre>
         * Required. The maximum number of Neural Architecture Search (NAS) trials
         * to run.
         * </pre>
         *
         * <code>int32 max_trial_count = 2 [(.google.api.field_behavior) = REQUIRED];</code>
         *
         * @param value The maxTrialCount to set.
         * @return This builder for chaining.
         */
        public Builder setMaxTrialCount(int value) {

          maxTrialCount_ = value;
          bitField0_ |= 0x00000002;
          onChanged();
          return this;
        }
        /**
         *
         *
         * <pre>
         * Required. The maximum number of Neural Architecture Search (NAS) trials
         * to run.
         * </pre>
         *
         * <code>int32 max_trial_count = 2 [(.google.api.field_behavior) = REQUIRED];</code>
         *
         * @return This builder for chaining.
         */
        public Builder clearMaxTrialCount() {
          bitField0_ = (bitField0_ & ~0x00000002);
          maxTrialCount_ = 0;
          onChanged();
          return this;
        }

        private int maxParallelTrialCount_;
        /**
         *
         *
         * <pre>
         * Required. The maximum number of trials to run in parallel.
         * </pre>
         *
         * <code>int32 max_parallel_trial_count = 3 [(.google.api.field_behavior) = REQUIRED];
         * </code>
         *
         * @return The maxParallelTrialCount.
         */
        @java.lang.Override
        public int getMaxParallelTrialCount() {
          return maxParallelTrialCount_;
        }
        /**
         *
         *
         * <pre>
         * Required. The maximum number of trials to run in parallel.
         * </pre>
         *
         * <code>int32 max_parallel_trial_count = 3 [(.google.api.field_behavior) = REQUIRED];
         * </code>
         *
         * @param value The maxParallelTrialCount to set.
         * @return This builder for chaining.
         */
        public Builder setMaxParallelTrialCount(int value) {

          maxParallelTrialCount_ = value;
          bitField0_ |= 0x00000004;
          onChanged();
          return this;
        }
        /**
         *
         *
         * <pre>
         * Required. The maximum number of trials to run in parallel.
         * </pre>
         *
         * <code>int32 max_parallel_trial_count = 3 [(.google.api.field_behavior) = REQUIRED];
         * </code>
         *
         * @return This builder for chaining.
         */
        public Builder clearMaxParallelTrialCount() {
          bitField0_ = (bitField0_ & ~0x00000004);
          maxParallelTrialCount_ = 0;
          onChanged();
          return this;
        }

        private int maxFailedTrialCount_;
        /**
         *
         *
         * <pre>
         * The number of failed trials that need to be seen before failing
         * the NasJob.
         *
         * If set to 0, Vertex AI decides how many trials must fail
         * before the whole job fails.
         * </pre>
         *
         * <code>int32 max_failed_trial_count = 4;</code>
         *
         * @return The maxFailedTrialCount.
         */
        @java.lang.Override
        public int getMaxFailedTrialCount() {
          return maxFailedTrialCount_;
        }
        /**
         *
         *
         * <pre>
         * The number of failed trials that need to be seen before failing
         * the NasJob.
         *
         * If set to 0, Vertex AI decides how many trials must fail
         * before the whole job fails.
         * </pre>
         *
         * <code>int32 max_failed_trial_count = 4;</code>
         *
         * @param value The maxFailedTrialCount to set.
         * @return This builder for chaining.
         */
        public Builder setMaxFailedTrialCount(int value) {

          maxFailedTrialCount_ = value;
          bitField0_ |= 0x00000008;
          onChanged();
          return this;
        }
        /**
         *
         *
         * <pre>
         * The number of failed trials that need to be seen before failing
         * the NasJob.
         *
         * If set to 0, Vertex AI decides how many trials must fail
         * before the whole job fails.
         * </pre>
         *
         * <code>int32 max_failed_trial_count = 4;</code>
         *
         * @return This builder for chaining.
         */
        public Builder clearMaxFailedTrialCount() {
          bitField0_ = (bitField0_ & ~0x00000008);
          maxFailedTrialCount_ = 0;
          onChanged();
          return this;
        }

        @java.lang.Override
        public final Builder setUnknownFields(
            final com.google.protobuf.UnknownFieldSet unknownFields) {
          return super.setUnknownFields(unknownFields);
        }

        @java.lang.Override
        public final Builder mergeUnknownFields(
            final com.google.protobuf.UnknownFieldSet unknownFields) {
          return super.mergeUnknownFields(unknownFields);
        }

        // @@protoc_insertion_point(builder_scope:google.cloud.aiplatform.v1beta1.NasJobSpec.MultiTrialAlgorithmSpec.SearchTrialSpec)
      }

      // @@protoc_insertion_point(class_scope:google.cloud.aiplatform.v1beta1.NasJobSpec.MultiTrialAlgorithmSpec.SearchTrialSpec)
      private static final com.google.cloud.aiplatform.v1beta1.NasJobSpec.MultiTrialAlgorithmSpec
              .SearchTrialSpec
          DEFAULT_INSTANCE;

      static {
        DEFAULT_INSTANCE =
            new com.google.cloud.aiplatform.v1beta1.NasJobSpec.MultiTrialAlgorithmSpec
                .SearchTrialSpec();
      }

      public static com.google.cloud.aiplatform.v1beta1.NasJobSpec.MultiTrialAlgorithmSpec
              .SearchTrialSpec
          getDefaultInstance() {
        return DEFAULT_INSTANCE;
      }

      private static final com.google.protobuf.Parser<SearchTrialSpec> PARSER =
          new com.google.protobuf.AbstractParser<SearchTrialSpec>() {
            @java.lang.Override
            public SearchTrialSpec parsePartialFrom(
                com.google.protobuf.CodedInputStream input,
                com.google.protobuf.ExtensionRegistryLite extensionRegistry)
                throws com.google.protobuf.InvalidProtocolBufferException {
              Builder builder = newBuilder();
              try {
                builder.mergeFrom(input, extensionRegistry);
              } catch (com.google.protobuf.InvalidProtocolBufferException e) {
                throw e.setUnfinishedMessage(builder.buildPartial());
              } catch (com.google.protobuf.UninitializedMessageException e) {
                throw e.asInvalidProtocolBufferException()
                    .setUnfinishedMessage(builder.buildPartial());
              } catch (java.io.IOException e) {
                throw new com.google.protobuf.InvalidProtocolBufferException(e)
                    .setUnfinishedMessage(builder.buildPartial());
              }
              return builder.buildPartial();
            }
          };

      public static com.google.protobuf.Parser<SearchTrialSpec> parser() {
        return PARSER;
      }

      @java.lang.Override
      public com.google.protobuf.Parser<SearchTrialSpec> getParserForType() {
        return PARSER;
      }

      @java.lang.Override
      public com.google.cloud.aiplatform.v1beta1.NasJobSpec.MultiTrialAlgorithmSpec.SearchTrialSpec
          getDefaultInstanceForType() {
        return DEFAULT_INSTANCE;
      }
    }

    public interface TrainTrialSpecOrBuilder
        extends
        // @@protoc_insertion_point(interface_extends:google.cloud.aiplatform.v1beta1.NasJobSpec.MultiTrialAlgorithmSpec.TrainTrialSpec)
        com.google.protobuf.MessageOrBuilder {

      /**
       *
       *
       * <pre>
       * Required. The spec of a train trial job. The same spec applies to
       * all train trials.
       * </pre>
       *
       * <code>
       * .google.cloud.aiplatform.v1beta1.CustomJobSpec train_trial_job_spec = 1 [(.google.api.field_behavior) = REQUIRED];
       * </code>
       *
       * @return Whether the trainTrialJobSpec field is set.
       */
      boolean hasTrainTrialJobSpec();
      /**
       *
       *
       * <pre>
       * Required. The spec of a train trial job. The same spec applies to
       * all train trials.
       * </pre>
       *
       * <code>
       * .google.cloud.aiplatform.v1beta1.CustomJobSpec train_trial_job_spec = 1 [(.google.api.field_behavior) = REQUIRED];
       * </code>
       *
       * @return The trainTrialJobSpec.
       */
      com.google.cloud.aiplatform.v1beta1.CustomJobSpec getTrainTrialJobSpec();
      /**
       *
       *
       * <pre>
       * Required. The spec of a train trial job. The same spec applies to
       * all train trials.
       * </pre>
       *
       * <code>
       * .google.cloud.aiplatform.v1beta1.CustomJobSpec train_trial_job_spec = 1 [(.google.api.field_behavior) = REQUIRED];
       * </code>
       */
      com.google.cloud.aiplatform.v1beta1.CustomJobSpecOrBuilder getTrainTrialJobSpecOrBuilder();

      /**
       *
       *
       * <pre>
       * Required. The maximum number of trials to run in parallel.
       * </pre>
       *
       * <code>int32 max_parallel_trial_count = 2 [(.google.api.field_behavior) = REQUIRED];</code>
       *
       * @return The maxParallelTrialCount.
       */
      int getMaxParallelTrialCount();

      /**
       *
       *
       * <pre>
       * Required. Frequency of search trials to start train stage. Top N
       * [TrainTrialSpec.max_parallel_trial_count]
       * search trials will be trained for every M
       * [TrainTrialSpec.frequency] trials searched.
       * </pre>
       *
       * <code>int32 frequency = 3 [(.google.api.field_behavior) = REQUIRED];</code>
       *
       * @return The frequency.
       */
      int getFrequency();
    }
    /**
     *
     *
     * <pre>
     * Represent spec for train trials.
     * </pre>
     *
     * Protobuf type {@code
     * google.cloud.aiplatform.v1beta1.NasJobSpec.MultiTrialAlgorithmSpec.TrainTrialSpec}
     */
    public static final class TrainTrialSpec extends com.google.protobuf.GeneratedMessageV3
        implements
        // @@protoc_insertion_point(message_implements:google.cloud.aiplatform.v1beta1.NasJobSpec.MultiTrialAlgorithmSpec.TrainTrialSpec)
        TrainTrialSpecOrBuilder {
      private static final long serialVersionUID = 0L;
      // Use TrainTrialSpec.newBuilder() to construct.
      private TrainTrialSpec(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
        super(builder);
      }

      private TrainTrialSpec() {}

      @java.lang.Override
      @SuppressWarnings({"unused"})
      protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
        return new TrainTrialSpec();
      }

      public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
        return com.google.cloud.aiplatform.v1beta1.NasJobProto
            .internal_static_google_cloud_aiplatform_v1beta1_NasJobSpec_MultiTrialAlgorithmSpec_TrainTrialSpec_descriptor;
      }

      @java.lang.Override
      protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return com.google.cloud.aiplatform.v1beta1.NasJobProto
            .internal_static_google_cloud_aiplatform_v1beta1_NasJobSpec_MultiTrialAlgorithmSpec_TrainTrialSpec_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                com.google.cloud.aiplatform.v1beta1.NasJobSpec.MultiTrialAlgorithmSpec
                    .TrainTrialSpec.class,
                com.google.cloud.aiplatform.v1beta1.NasJobSpec.MultiTrialAlgorithmSpec
                    .TrainTrialSpec.Builder.class);
      }

      private int bitField0_;
      public static final int TRAIN_TRIAL_JOB_SPEC_FIELD_NUMBER = 1;
      private com.google.cloud.aiplatform.v1beta1.CustomJobSpec trainTrialJobSpec_;
      /**
       *
       *
       * <pre>
       * Required. The spec of a train trial job. The same spec applies to
       * all train trials.
       * </pre>
       *
       * <code>
       * .google.cloud.aiplatform.v1beta1.CustomJobSpec train_trial_job_spec = 1 [(.google.api.field_behavior) = REQUIRED];
       * </code>
       *
       * @return Whether the trainTrialJobSpec field is set.
       */
      @java.lang.Override
      public boolean hasTrainTrialJobSpec() {
        return ((bitField0_ & 0x00000001) != 0);
      }
      /**
       *
       *
       * <pre>
       * Required. The spec of a train trial job. The same spec applies to
       * all train trials.
       * </pre>
       *
       * <code>
       * .google.cloud.aiplatform.v1beta1.CustomJobSpec train_trial_job_spec = 1 [(.google.api.field_behavior) = REQUIRED];
       * </code>
       *
       * @return The trainTrialJobSpec.
       */
      @java.lang.Override
      public com.google.cloud.aiplatform.v1beta1.CustomJobSpec getTrainTrialJobSpec() {
        return trainTrialJobSpec_ == null
            ? com.google.cloud.aiplatform.v1beta1.CustomJobSpec.getDefaultInstance()
            : trainTrialJobSpec_;
      }
      /**
       *
       *
       * <pre>
       * Required. The spec of a train trial job. The same spec applies to
       * all train trials.
       * </pre>
       *
       * <code>
       * .google.cloud.aiplatform.v1beta1.CustomJobSpec train_trial_job_spec = 1 [(.google.api.field_behavior) = REQUIRED];
       * </code>
       */
      @java.lang.Override
      public com.google.cloud.aiplatform.v1beta1.CustomJobSpecOrBuilder
          getTrainTrialJobSpecOrBuilder() {
        return trainTrialJobSpec_ == null
            ? com.google.cloud.aiplatform.v1beta1.CustomJobSpec.getDefaultInstance()
            : trainTrialJobSpec_;
      }

      public static final int MAX_PARALLEL_TRIAL_COUNT_FIELD_NUMBER = 2;
      private int maxParallelTrialCount_ = 0;
      /**
       *
       *
       * <pre>
       * Required. The maximum number of trials to run in parallel.
       * </pre>
       *
       * <code>int32 max_parallel_trial_count = 2 [(.google.api.field_behavior) = REQUIRED];</code>
       *
       * @return The maxParallelTrialCount.
       */
      @java.lang.Override
      public int getMaxParallelTrialCount() {
        return maxParallelTrialCount_;
      }

      public static final int FREQUENCY_FIELD_NUMBER = 3;
      private int frequency_ = 0;
      /**
       *
       *
       * <pre>
       * Required. Frequency of search trials to start train stage. Top N
       * [TrainTrialSpec.max_parallel_trial_count]
       * search trials will be trained for every M
       * [TrainTrialSpec.frequency] trials searched.
       * </pre>
       *
       * <code>int32 frequency = 3 [(.google.api.field_behavior) = REQUIRED];</code>
       *
       * @return The frequency.
       */
      @java.lang.Override
      public int getFrequency() {
        return frequency_;
      }

      private byte memoizedIsInitialized = -1;

      @java.lang.Override
      public final boolean isInitialized() {
        byte isInitialized = memoizedIsInitialized;
        if (isInitialized == 1) return true;
        if (isInitialized == 0) return false;

        memoizedIsInitialized = 1;
        return true;
      }

      @java.lang.Override
      public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
        if (((bitField0_ & 0x00000001) != 0)) {
          output.writeMessage(1, getTrainTrialJobSpec());
        }
        if (maxParallelTrialCount_ != 0) {
          output.writeInt32(2, maxParallelTrialCount_);
        }
        if (frequency_ != 0) {
          output.writeInt32(3, frequency_);
        }
        getUnknownFields().writeTo(output);
      }

      @java.lang.Override
      public int getSerializedSize() {
        int size = memoizedSize;
        if (size != -1) return size;

        size = 0;
        if (((bitField0_ & 0x00000001) != 0)) {
          size +=
              com.google.protobuf.CodedOutputStream.computeMessageSize(1, getTrainTrialJobSpec());
        }
        if (maxParallelTrialCount_ != 0) {
          size += com.google.protobuf.CodedOutputStream.computeInt32Size(2, maxParallelTrialCount_);
        }
        if (frequency_ != 0) {
          size += com.google.protobuf.CodedOutputStream.computeInt32Size(3, frequency_);
        }
        size += getUnknownFields().getSerializedSize();
        memoizedSize = size;
        return size;
      }

      @java.lang.Override
      public boolean equals(final java.lang.Object obj) {
        if (obj == this) {
          return true;
        }
        if (!(obj
            instanceof
            com.google.cloud.aiplatform.v1beta1.NasJobSpec.MultiTrialAlgorithmSpec
                .TrainTrialSpec)) {
          return super.equals(obj);
        }
        com.google.cloud.aiplatform.v1beta1.NasJobSpec.MultiTrialAlgorithmSpec.TrainTrialSpec
            other =
                (com.google.cloud.aiplatform.v1beta1.NasJobSpec.MultiTrialAlgorithmSpec
                        .TrainTrialSpec)
                    obj;

        if (hasTrainTrialJobSpec() != other.hasTrainTrialJobSpec()) return false;
        if (hasTrainTrialJobSpec()) {
          if (!getTrainTrialJobSpec().equals(other.getTrainTrialJobSpec())) return false;
        }
        if (getMaxParallelTrialCount() != other.getMaxParallelTrialCount()) return false;
        if (getFrequency() != other.getFrequency()) return false;
        if (!getUnknownFields().equals(other.getUnknownFields())) return false;
        return true;
      }

      @java.lang.Override
      public int hashCode() {
        if (memoizedHashCode != 0) {
          return memoizedHashCode;
        }
        int hash = 41;
        hash = (19 * hash) + getDescriptor().hashCode();
        if (hasTrainTrialJobSpec()) {
          hash = (37 * hash) + TRAIN_TRIAL_JOB_SPEC_FIELD_NUMBER;
          hash = (53 * hash) + getTrainTrialJobSpec().hashCode();
        }
        hash = (37 * hash) + MAX_PARALLEL_TRIAL_COUNT_FIELD_NUMBER;
        hash = (53 * hash) + getMaxParallelTrialCount();
        hash = (37 * hash) + FREQUENCY_FIELD_NUMBER;
        hash = (53 * hash) + getFrequency();
        hash = (29 * hash) + getUnknownFields().hashCode();
        memoizedHashCode = hash;
        return hash;
      }

      public static com.google.cloud.aiplatform.v1beta1.NasJobSpec.MultiTrialAlgorithmSpec
              .TrainTrialSpec
          parseFrom(java.nio.ByteBuffer data)
              throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data);
      }

      public static com.google.cloud.aiplatform.v1beta1.NasJobSpec.MultiTrialAlgorithmSpec
              .TrainTrialSpec
          parseFrom(
              java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data, extensionRegistry);
      }

      public static com.google.cloud.aiplatform.v1beta1.NasJobSpec.MultiTrialAlgorithmSpec
              .TrainTrialSpec
          parseFrom(com.google.protobuf.ByteString data)
              throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data);
      }

      public static com.google.cloud.aiplatform.v1beta1.NasJobSpec.MultiTrialAlgorithmSpec
              .TrainTrialSpec
          parseFrom(
              com.google.protobuf.ByteString data,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data, extensionRegistry);
      }

      public static com.google.cloud.aiplatform.v1beta1.NasJobSpec.MultiTrialAlgorithmSpec
              .TrainTrialSpec
          parseFrom(byte[] data) throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data);
      }

      public static com.google.cloud.aiplatform.v1beta1.NasJobSpec.MultiTrialAlgorithmSpec
              .TrainTrialSpec
          parseFrom(byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data, extensionRegistry);
      }

      public static com.google.cloud.aiplatform.v1beta1.NasJobSpec.MultiTrialAlgorithmSpec
              .TrainTrialSpec
          parseFrom(java.io.InputStream input) throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
      }

      public static com.google.cloud.aiplatform.v1beta1.NasJobSpec.MultiTrialAlgorithmSpec
              .TrainTrialSpec
          parseFrom(
              java.io.InputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
            PARSER, input, extensionRegistry);
      }

      public static com.google.cloud.aiplatform.v1beta1.NasJobSpec.MultiTrialAlgorithmSpec
              .TrainTrialSpec
          parseDelimitedFrom(java.io.InputStream input) throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
      }

      public static com.google.cloud.aiplatform.v1beta1.NasJobSpec.MultiTrialAlgorithmSpec
              .TrainTrialSpec
          parseDelimitedFrom(
              java.io.InputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
            PARSER, input, extensionRegistry);
      }

      public static com.google.cloud.aiplatform.v1beta1.NasJobSpec.MultiTrialAlgorithmSpec
              .TrainTrialSpec
          parseFrom(com.google.protobuf.CodedInputStream input) throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
      }

      public static com.google.cloud.aiplatform.v1beta1.NasJobSpec.MultiTrialAlgorithmSpec
              .TrainTrialSpec
          parseFrom(
              com.google.protobuf.CodedInputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
            PARSER, input, extensionRegistry);
      }

      @java.lang.Override
      public Builder newBuilderForType() {
        return newBuilder();
      }

      public static Builder newBuilder() {
        return DEFAULT_INSTANCE.toBuilder();
      }

      public static Builder newBuilder(
          com.google.cloud.aiplatform.v1beta1.NasJobSpec.MultiTrialAlgorithmSpec.TrainTrialSpec
              prototype) {
        return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
      }

      @java.lang.Override
      public Builder toBuilder() {
        return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
      }

      @java.lang.Override
      protected Builder newBuilderForType(
          com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
        Builder builder = new Builder(parent);
        return builder;
      }
      /**
       *
       *
       * <pre>
       * Represent spec for train trials.
       * </pre>
       *
       * Protobuf type {@code
       * google.cloud.aiplatform.v1beta1.NasJobSpec.MultiTrialAlgorithmSpec.TrainTrialSpec}
       */
      public static final class Builder
          extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
          implements
          // @@protoc_insertion_point(builder_implements:google.cloud.aiplatform.v1beta1.NasJobSpec.MultiTrialAlgorithmSpec.TrainTrialSpec)
          com.google.cloud.aiplatform.v1beta1.NasJobSpec.MultiTrialAlgorithmSpec
              .TrainTrialSpecOrBuilder {
        public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
          return com.google.cloud.aiplatform.v1beta1.NasJobProto
              .internal_static_google_cloud_aiplatform_v1beta1_NasJobSpec_MultiTrialAlgorithmSpec_TrainTrialSpec_descriptor;
        }

        @java.lang.Override
        protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
            internalGetFieldAccessorTable() {
          return com.google.cloud.aiplatform.v1beta1.NasJobProto
              .internal_static_google_cloud_aiplatform_v1beta1_NasJobSpec_MultiTrialAlgorithmSpec_TrainTrialSpec_fieldAccessorTable
              .ensureFieldAccessorsInitialized(
                  com.google.cloud.aiplatform.v1beta1.NasJobSpec.MultiTrialAlgorithmSpec
                      .TrainTrialSpec.class,
                  com.google.cloud.aiplatform.v1beta1.NasJobSpec.MultiTrialAlgorithmSpec
                      .TrainTrialSpec.Builder.class);
        }

        // Construct using
        // com.google.cloud.aiplatform.v1beta1.NasJobSpec.MultiTrialAlgorithmSpec.TrainTrialSpec.newBuilder()
        private Builder() {
          maybeForceBuilderInitialization();
        }

        private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
          super(parent);
          maybeForceBuilderInitialization();
        }

        private void maybeForceBuilderInitialization() {
          if (com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders) {
            getTrainTrialJobSpecFieldBuilder();
          }
        }

        @java.lang.Override
        public Builder clear() {
          super.clear();
          bitField0_ = 0;
          trainTrialJobSpec_ = null;
          if (trainTrialJobSpecBuilder_ != null) {
            trainTrialJobSpecBuilder_.dispose();
            trainTrialJobSpecBuilder_ = null;
          }
          maxParallelTrialCount_ = 0;
          frequency_ = 0;
          return this;
        }

        @java.lang.Override
        public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
          return com.google.cloud.aiplatform.v1beta1.NasJobProto
              .internal_static_google_cloud_aiplatform_v1beta1_NasJobSpec_MultiTrialAlgorithmSpec_TrainTrialSpec_descriptor;
        }

        @java.lang.Override
        public com.google.cloud.aiplatform.v1beta1.NasJobSpec.MultiTrialAlgorithmSpec.TrainTrialSpec
            getDefaultInstanceForType() {
          return com.google.cloud.aiplatform.v1beta1.NasJobSpec.MultiTrialAlgorithmSpec
              .TrainTrialSpec.getDefaultInstance();
        }

        @java.lang.Override
        public com.google.cloud.aiplatform.v1beta1.NasJobSpec.MultiTrialAlgorithmSpec.TrainTrialSpec
            build() {
          com.google.cloud.aiplatform.v1beta1.NasJobSpec.MultiTrialAlgorithmSpec.TrainTrialSpec
              result = buildPartial();
          if (!result.isInitialized()) {
            throw newUninitializedMessageException(result);
          }
          return result;
        }

        @java.lang.Override
        public com.google.cloud.aiplatform.v1beta1.NasJobSpec.MultiTrialAlgorithmSpec.TrainTrialSpec
            buildPartial() {
          com.google.cloud.aiplatform.v1beta1.NasJobSpec.MultiTrialAlgorithmSpec.TrainTrialSpec
              result =
                  new com.google.cloud.aiplatform.v1beta1.NasJobSpec.MultiTrialAlgorithmSpec
                      .TrainTrialSpec(this);
          if (bitField0_ != 0) {
            buildPartial0(result);
          }
          onBuilt();
          return result;
        }

        private void buildPartial0(
            com.google.cloud.aiplatform.v1beta1.NasJobSpec.MultiTrialAlgorithmSpec.TrainTrialSpec
                result) {
          int from_bitField0_ = bitField0_;
          int to_bitField0_ = 0;
          if (((from_bitField0_ & 0x00000001) != 0)) {
            result.trainTrialJobSpec_ =
                trainTrialJobSpecBuilder_ == null
                    ? trainTrialJobSpec_
                    : trainTrialJobSpecBuilder_.build();
            to_bitField0_ |= 0x00000001;
          }
          if (((from_bitField0_ & 0x00000002) != 0)) {
            result.maxParallelTrialCount_ = maxParallelTrialCount_;
          }
          if (((from_bitField0_ & 0x00000004) != 0)) {
            result.frequency_ = frequency_;
          }
          result.bitField0_ |= to_bitField0_;
        }

        @java.lang.Override
        public Builder clone() {
          return super.clone();
        }

        @java.lang.Override
        public Builder setField(
            com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
          return super.setField(field, value);
        }

        @java.lang.Override
        public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
          return super.clearField(field);
        }

        @java.lang.Override
        public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
          return super.clearOneof(oneof);
        }

        @java.lang.Override
        public Builder setRepeatedField(
            com.google.protobuf.Descriptors.FieldDescriptor field,
            int index,
            java.lang.Object value) {
          return super.setRepeatedField(field, index, value);
        }

        @java.lang.Override
        public Builder addRepeatedField(
            com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
          return super.addRepeatedField(field, value);
        }

        @java.lang.Override
        public Builder mergeFrom(com.google.protobuf.Message other) {
          if (other
              instanceof
              com.google.cloud.aiplatform.v1beta1.NasJobSpec.MultiTrialAlgorithmSpec
                  .TrainTrialSpec) {
            return mergeFrom(
                (com.google.cloud.aiplatform.v1beta1.NasJobSpec.MultiTrialAlgorithmSpec
                        .TrainTrialSpec)
                    other);
          } else {
            super.mergeFrom(other);
            return this;
          }
        }

        public Builder mergeFrom(
            com.google.cloud.aiplatform.v1beta1.NasJobSpec.MultiTrialAlgorithmSpec.TrainTrialSpec
                other) {
          if (other
              == com.google.cloud.aiplatform.v1beta1.NasJobSpec.MultiTrialAlgorithmSpec
                  .TrainTrialSpec.getDefaultInstance()) return this;
          if (other.hasTrainTrialJobSpec()) {
            mergeTrainTrialJobSpec(other.getTrainTrialJobSpec());
          }
          if (other.getMaxParallelTrialCount() != 0) {
            setMaxParallelTrialCount(other.getMaxParallelTrialCount());
          }
          if (other.getFrequency() != 0) {
            setFrequency(other.getFrequency());
          }
          this.mergeUnknownFields(other.getUnknownFields());
          onChanged();
          return this;
        }

        @java.lang.Override
        public final boolean isInitialized() {
          return true;
        }

        @java.lang.Override
        public Builder mergeFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws java.io.IOException {
          if (extensionRegistry == null) {
            throw new java.lang.NullPointerException();
          }
          try {
            boolean done = false;
            while (!done) {
              int tag = input.readTag();
              switch (tag) {
                case 0:
                  done = true;
                  break;
                case 10:
                  {
                    input.readMessage(
                        getTrainTrialJobSpecFieldBuilder().getBuilder(), extensionRegistry);
                    bitField0_ |= 0x00000001;
                    break;
                  } // case 10
                case 16:
                  {
                    maxParallelTrialCount_ = input.readInt32();
                    bitField0_ |= 0x00000002;
                    break;
                  } // case 16
                case 24:
                  {
                    frequency_ = input.readInt32();
                    bitField0_ |= 0x00000004;
                    break;
                  } // case 24
                default:
                  {
                    if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                      done = true; // was an endgroup tag
                    }
                    break;
                  } // default:
              } // switch (tag)
            } // while (!done)
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.unwrapIOException();
          } finally {
            onChanged();
          } // finally
          return this;
        }

        private int bitField0_;

        private com.google.cloud.aiplatform.v1beta1.CustomJobSpec trainTrialJobSpec_;
        private com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.aiplatform.v1beta1.CustomJobSpec,
                com.google.cloud.aiplatform.v1beta1.CustomJobSpec.Builder,
                com.google.cloud.aiplatform.v1beta1.CustomJobSpecOrBuilder>
            trainTrialJobSpecBuilder_;
        /**
         *
         *
         * <pre>
         * Required. The spec of a train trial job. The same spec applies to
         * all train trials.
         * </pre>
         *
         * <code>
         * .google.cloud.aiplatform.v1beta1.CustomJobSpec train_trial_job_spec = 1 [(.google.api.field_behavior) = REQUIRED];
         * </code>
         *
         * @return Whether the trainTrialJobSpec field is set.
         */
        public boolean hasTrainTrialJobSpec() {
          return ((bitField0_ & 0x00000001) != 0);
        }
        /**
         *
         *
         * <pre>
         * Required. The spec of a train trial job. The same spec applies to
         * all train trials.
         * </pre>
         *
         * <code>
         * .google.cloud.aiplatform.v1beta1.CustomJobSpec train_trial_job_spec = 1 [(.google.api.field_behavior) = REQUIRED];
         * </code>
         *
         * @return The trainTrialJobSpec.
         */
        public com.google.cloud.aiplatform.v1beta1.CustomJobSpec getTrainTrialJobSpec() {
          if (trainTrialJobSpecBuilder_ == null) {
            return trainTrialJobSpec_ == null
                ? com.google.cloud.aiplatform.v1beta1.CustomJobSpec.getDefaultInstance()
                : trainTrialJobSpec_;
          } else {
            return trainTrialJobSpecBuilder_.getMessage();
          }
        }
        /**
         *
         *
         * <pre>
         * Required. The spec of a train trial job. The same spec applies to
         * all train trials.
         * </pre>
         *
         * <code>
         * .google.cloud.aiplatform.v1beta1.CustomJobSpec train_trial_job_spec = 1 [(.google.api.field_behavior) = REQUIRED];
         * </code>
         */
        public Builder setTrainTrialJobSpec(
            com.google.cloud.aiplatform.v1beta1.CustomJobSpec value) {
          if (trainTrialJobSpecBuilder_ == null) {
            if (value == null) {
              throw new NullPointerException();
            }
            trainTrialJobSpec_ = value;
          } else {
            trainTrialJobSpecBuilder_.setMessage(value);
          }
          bitField0_ |= 0x00000001;
          onChanged();
          return this;
        }
        /**
         *
         *
         * <pre>
         * Required. The spec of a train trial job. The same spec applies to
         * all train trials.
         * </pre>
         *
         * <code>
         * .google.cloud.aiplatform.v1beta1.CustomJobSpec train_trial_job_spec = 1 [(.google.api.field_behavior) = REQUIRED];
         * </code>
         */
        public Builder setTrainTrialJobSpec(
            com.google.cloud.aiplatform.v1beta1.CustomJobSpec.Builder builderForValue) {
          if (trainTrialJobSpecBuilder_ == null) {
            trainTrialJobSpec_ = builderForValue.build();
          } else {
            trainTrialJobSpecBuilder_.setMessage(builderForValue.build());
          }
          bitField0_ |= 0x00000001;
          onChanged();
          return this;
        }
        /**
         *
         *
         * <pre>
         * Required. The spec of a train trial job. The same spec applies to
         * all train trials.
         * </pre>
         *
         * <code>
         * .google.cloud.aiplatform.v1beta1.CustomJobSpec train_trial_job_spec = 1 [(.google.api.field_behavior) = REQUIRED];
         * </code>
         */
        public Builder mergeTrainTrialJobSpec(
            com.google.cloud.aiplatform.v1beta1.CustomJobSpec value) {
          if (trainTrialJobSpecBuilder_ == null) {
            if (((bitField0_ & 0x00000001) != 0)
                && trainTrialJobSpec_ != null
                && trainTrialJobSpec_
                    != com.google.cloud.aiplatform.v1beta1.CustomJobSpec.getDefaultInstance()) {
              getTrainTrialJobSpecBuilder().mergeFrom(value);
            } else {
              trainTrialJobSpec_ = value;
            }
          } else {
            trainTrialJobSpecBuilder_.mergeFrom(value);
          }
          if (trainTrialJobSpec_ != null) {
            bitField0_ |= 0x00000001;
            onChanged();
          }
          return this;
        }
        /**
         *
         *
         * <pre>
         * Required. The spec of a train trial job. The same spec applies to
         * all train trials.
         * </pre>
         *
         * <code>
         * .google.cloud.aiplatform.v1beta1.CustomJobSpec train_trial_job_spec = 1 [(.google.api.field_behavior) = REQUIRED];
         * </code>
         */
        public Builder clearTrainTrialJobSpec() {
          bitField0_ = (bitField0_ & ~0x00000001);
          trainTrialJobSpec_ = null;
          if (trainTrialJobSpecBuilder_ != null) {
            trainTrialJobSpecBuilder_.dispose();
            trainTrialJobSpecBuilder_ = null;
          }
          onChanged();
          return this;
        }
        /**
         *
         *
         * <pre>
         * Required. The spec of a train trial job. The same spec applies to
         * all train trials.
         * </pre>
         *
         * <code>
         * .google.cloud.aiplatform.v1beta1.CustomJobSpec train_trial_job_spec = 1 [(.google.api.field_behavior) = REQUIRED];
         * </code>
         */
        public com.google.cloud.aiplatform.v1beta1.CustomJobSpec.Builder
            getTrainTrialJobSpecBuilder() {
          bitField0_ |= 0x00000001;
          onChanged();
          return getTrainTrialJobSpecFieldBuilder().getBuilder();
        }
        /**
         *
         *
         * <pre>
         * Required. The spec of a train trial job. The same spec applies to
         * all train trials.
         * </pre>
         *
         * <code>
         * .google.cloud.aiplatform.v1beta1.CustomJobSpec train_trial_job_spec = 1 [(.google.api.field_behavior) = REQUIRED];
         * </code>
         */
        public com.google.cloud.aiplatform.v1beta1.CustomJobSpecOrBuilder
            getTrainTrialJobSpecOrBuilder() {
          if (trainTrialJobSpecBuilder_ != null) {
            return trainTrialJobSpecBuilder_.getMessageOrBuilder();
          } else {
            return trainTrialJobSpec_ == null
                ? com.google.cloud.aiplatform.v1beta1.CustomJobSpec.getDefaultInstance()
                : trainTrialJobSpec_;
          }
        }
        /**
         *
         *
         * <pre>
         * Required. The spec of a train trial job. The same spec applies to
         * all train trials.
         * </pre>
         *
         * <code>
         * .google.cloud.aiplatform.v1beta1.CustomJobSpec train_trial_job_spec = 1 [(.google.api.field_behavior) = REQUIRED];
         * </code>
         */
        private com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.aiplatform.v1beta1.CustomJobSpec,
                com.google.cloud.aiplatform.v1beta1.CustomJobSpec.Builder,
                com.google.cloud.aiplatform.v1beta1.CustomJobSpecOrBuilder>
            getTrainTrialJobSpecFieldBuilder() {
          if (trainTrialJobSpecBuilder_ == null) {
            trainTrialJobSpecBuilder_ =
                new com.google.protobuf.SingleFieldBuilderV3<
                    com.google.cloud.aiplatform.v1beta1.CustomJobSpec,
                    com.google.cloud.aiplatform.v1beta1.CustomJobSpec.Builder,
                    com.google.cloud.aiplatform.v1beta1.CustomJobSpecOrBuilder>(
                    getTrainTrialJobSpec(), getParentForChildren(), isClean());
            trainTrialJobSpec_ = null;
          }
          return trainTrialJobSpecBuilder_;
        }

        private int maxParallelTrialCount_;
        /**
         *
         *
         * <pre>
         * Required. The maximum number of trials to run in parallel.
         * </pre>
         *
         * <code>int32 max_parallel_trial_count = 2 [(.google.api.field_behavior) = REQUIRED];
         * </code>
         *
         * @return The maxParallelTrialCount.
         */
        @java.lang.Override
        public int getMaxParallelTrialCount() {
          return maxParallelTrialCount_;
        }
        /**
         *
         *
         * <pre>
         * Required. The maximum number of trials to run in parallel.
         * </pre>
         *
         * <code>int32 max_parallel_trial_count = 2 [(.google.api.field_behavior) = REQUIRED];
         * </code>
         *
         * @param value The maxParallelTrialCount to set.
         * @return This builder for chaining.
         */
        public Builder setMaxParallelTrialCount(int value) {

          maxParallelTrialCount_ = value;
          bitField0_ |= 0x00000002;
          onChanged();
          return this;
        }
        /**
         *
         *
         * <pre>
         * Required. The maximum number of trials to run in parallel.
         * </pre>
         *
         * <code>int32 max_parallel_trial_count = 2 [(.google.api.field_behavior) = REQUIRED];
         * </code>
         *
         * @return This builder for chaining.
         */
        public Builder clearMaxParallelTrialCount() {
          bitField0_ = (bitField0_ & ~0x00000002);
          maxParallelTrialCount_ = 0;
          onChanged();
          return this;
        }

        private int frequency_;
        /**
         *
         *
         * <pre>
         * Required. Frequency of search trials to start train stage. Top N
         * [TrainTrialSpec.max_parallel_trial_count]
         * search trials will be trained for every M
         * [TrainTrialSpec.frequency] trials searched.
         * </pre>
         *
         * <code>int32 frequency = 3 [(.google.api.field_behavior) = REQUIRED];</code>
         *
         * @return The frequency.
         */
        @java.lang.Override
        public int getFrequency() {
          return frequency_;
        }
        /**
         *
         *
         * <pre>
         * Required. Frequency of search trials to start train stage. Top N
         * [TrainTrialSpec.max_parallel_trial_count]
         * search trials will be trained for every M
         * [TrainTrialSpec.frequency] trials searched.
         * </pre>
         *
         * <code>int32 frequency = 3 [(.google.api.field_behavior) = REQUIRED];</code>
         *
         * @param value The frequency to set.
         * @return This builder for chaining.
         */
        public Builder setFrequency(int value) {

          frequency_ = value;
          bitField0_ |= 0x00000004;
          onChanged();
          return this;
        }
        /**
         *
         *
         * <pre>
         * Required. Frequency of search trials to start train stage. Top N
         * [TrainTrialSpec.max_parallel_trial_count]
         * search trials will be trained for every M
         * [TrainTrialSpec.frequency] trials searched.
         * </pre>
         *
         * <code>int32 frequency = 3 [(.google.api.field_behavior) = REQUIRED];</code>
         *
         * @return This builder for chaining.
         */
        public Builder clearFrequency() {
          bitField0_ = (bitField0_ & ~0x00000004);
          frequency_ = 0;
          onChanged();
          return this;
        }

        @java.lang.Override
        public final Builder setUnknownFields(
            final com.google.protobuf.UnknownFieldSet unknownFields) {
          return super.setUnknownFields(unknownFields);
        }

        @java.lang.Override
        public final Builder mergeUnknownFields(
            final com.google.protobuf.UnknownFieldSet unknownFields) {
          return super.mergeUnknownFields(unknownFields);
        }

        // @@protoc_insertion_point(builder_scope:google.cloud.aiplatform.v1beta1.NasJobSpec.MultiTrialAlgorithmSpec.TrainTrialSpec)
      }

      // @@protoc_insertion_point(class_scope:google.cloud.aiplatform.v1beta1.NasJobSpec.MultiTrialAlgorithmSpec.TrainTrialSpec)
      private static final com.google.cloud.aiplatform.v1beta1.NasJobSpec.MultiTrialAlgorithmSpec
              .TrainTrialSpec
          DEFAULT_INSTANCE;

      static {
        DEFAULT_INSTANCE =
            new com.google.cloud.aiplatform.v1beta1.NasJobSpec.MultiTrialAlgorithmSpec
                .TrainTrialSpec();
      }

      public static com.google.cloud.aiplatform.v1beta1.NasJobSpec.MultiTrialAlgorithmSpec
              .TrainTrialSpec
          getDefaultInstance() {
        return DEFAULT_INSTANCE;
      }

      private static final com.google.protobuf.Parser<TrainTrialSpec> PARSER =
          new com.google.protobuf.AbstractParser<TrainTrialSpec>() {
            @java.lang.Override
            public TrainTrialSpec parsePartialFrom(
                com.google.protobuf.CodedInputStream input,
                com.google.protobuf.ExtensionRegistryLite extensionRegistry)
                throws com.google.protobuf.InvalidProtocolBufferException {
              Builder builder = newBuilder();
              try {
                builder.mergeFrom(input, extensionRegistry);
              } catch (com.google.protobuf.InvalidProtocolBufferException e) {
                throw e.setUnfinishedMessage(builder.buildPartial());
              } catch (com.google.protobuf.UninitializedMessageException e) {
                throw e.asInvalidProtocolBufferException()
                    .setUnfinishedMessage(builder.buildPartial());
              } catch (java.io.IOException e) {
                throw new com.google.protobuf.InvalidProtocolBufferException(e)
                    .setUnfinishedMessage(builder.buildPartial());
              }
              return builder.buildPartial();
            }
          };

      public static com.google.protobuf.Parser<TrainTrialSpec> parser() {
        return PARSER;
      }

      @java.lang.Override
      public com.google.protobuf.Parser<TrainTrialSpec> getParserForType() {
        return PARSER;
      }

      @java.lang.Override
      public com.google.cloud.aiplatform.v1beta1.NasJobSpec.MultiTrialAlgorithmSpec.TrainTrialSpec
          getDefaultInstanceForType() {
        return DEFAULT_INSTANCE;
      }
    }

    private int bitField0_;
    public static final int MULTI_TRIAL_ALGORITHM_FIELD_NUMBER = 1;
    private int multiTrialAlgorithm_ = 0;
    /**
     *
     *
     * <pre>
     * The multi-trial Neural Architecture Search (NAS) algorithm
     * type. Defaults to `REINFORCEMENT_LEARNING`.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.NasJobSpec.MultiTrialAlgorithmSpec.MultiTrialAlgorithm multi_trial_algorithm = 1;
     * </code>
     *
     * @return The enum numeric value on the wire for multiTrialAlgorithm.
     */
    @java.lang.Override
    public int getMultiTrialAlgorithmValue() {
      return multiTrialAlgorithm_;
    }
    /**
     *
     *
     * <pre>
     * The multi-trial Neural Architecture Search (NAS) algorithm
     * type. Defaults to `REINFORCEMENT_LEARNING`.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.NasJobSpec.MultiTrialAlgorithmSpec.MultiTrialAlgorithm multi_trial_algorithm = 1;
     * </code>
     *
     * @return The multiTrialAlgorithm.
     */
    @java.lang.Override
    public com.google.cloud.aiplatform.v1beta1.NasJobSpec.MultiTrialAlgorithmSpec
            .MultiTrialAlgorithm
        getMultiTrialAlgorithm() {
      com.google.cloud.aiplatform.v1beta1.NasJobSpec.MultiTrialAlgorithmSpec.MultiTrialAlgorithm
          result =
              com.google.cloud.aiplatform.v1beta1.NasJobSpec.MultiTrialAlgorithmSpec
                  .MultiTrialAlgorithm.forNumber(multiTrialAlgorithm_);
      return result == null
          ? com.google.cloud.aiplatform.v1beta1.NasJobSpec.MultiTrialAlgorithmSpec
              .MultiTrialAlgorithm.UNRECOGNIZED
          : result;
    }

    public static final int METRIC_FIELD_NUMBER = 2;
    private com.google.cloud.aiplatform.v1beta1.NasJobSpec.MultiTrialAlgorithmSpec.MetricSpec
        metric_;
    /**
     *
     *
     * <pre>
     * Metric specs for the NAS job.
     * Validation for this field is done at `multi_trial_algorithm_spec` field.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.NasJobSpec.MultiTrialAlgorithmSpec.MetricSpec metric = 2;
     * </code>
     *
     * @return Whether the metric field is set.
     */
    @java.lang.Override
    public boolean hasMetric() {
      return ((bitField0_ & 0x00000001) != 0);
    }
    /**
     *
     *
     * <pre>
     * Metric specs for the NAS job.
     * Validation for this field is done at `multi_trial_algorithm_spec` field.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.NasJobSpec.MultiTrialAlgorithmSpec.MetricSpec metric = 2;
     * </code>
     *
     * @return The metric.
     */
    @java.lang.Override
    public com.google.cloud.aiplatform.v1beta1.NasJobSpec.MultiTrialAlgorithmSpec.MetricSpec
        getMetric() {
      return metric_ == null
          ? com.google.cloud.aiplatform.v1beta1.NasJobSpec.MultiTrialAlgorithmSpec.MetricSpec
              .getDefaultInstance()
          : metric_;
    }
    /**
     *
     *
     * <pre>
     * Metric specs for the NAS job.
     * Validation for this field is done at `multi_trial_algorithm_spec` field.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.NasJobSpec.MultiTrialAlgorithmSpec.MetricSpec metric = 2;
     * </code>
     */
    @java.lang.Override
    public com.google.cloud.aiplatform.v1beta1.NasJobSpec.MultiTrialAlgorithmSpec
            .MetricSpecOrBuilder
        getMetricOrBuilder() {
      return metric_ == null
          ? com.google.cloud.aiplatform.v1beta1.NasJobSpec.MultiTrialAlgorithmSpec.MetricSpec
              .getDefaultInstance()
          : metric_;
    }

    public static final int SEARCH_TRIAL_SPEC_FIELD_NUMBER = 3;
    private com.google.cloud.aiplatform.v1beta1.NasJobSpec.MultiTrialAlgorithmSpec.SearchTrialSpec
        searchTrialSpec_;
    /**
     *
     *
     * <pre>
     * Required. Spec for search trials.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.NasJobSpec.MultiTrialAlgorithmSpec.SearchTrialSpec search_trial_spec = 3 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     *
     * @return Whether the searchTrialSpec field is set.
     */
    @java.lang.Override
    public boolean hasSearchTrialSpec() {
      return ((bitField0_ & 0x00000002) != 0);
    }
    /**
     *
     *
     * <pre>
     * Required. Spec for search trials.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.NasJobSpec.MultiTrialAlgorithmSpec.SearchTrialSpec search_trial_spec = 3 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     *
     * @return The searchTrialSpec.
     */
    @java.lang.Override
    public com.google.cloud.aiplatform.v1beta1.NasJobSpec.MultiTrialAlgorithmSpec.SearchTrialSpec
        getSearchTrialSpec() {
      return searchTrialSpec_ == null
          ? com.google.cloud.aiplatform.v1beta1.NasJobSpec.MultiTrialAlgorithmSpec.SearchTrialSpec
              .getDefaultInstance()
          : searchTrialSpec_;
    }
    /**
     *
     *
     * <pre>
     * Required. Spec for search trials.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.NasJobSpec.MultiTrialAlgorithmSpec.SearchTrialSpec search_trial_spec = 3 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    @java.lang.Override
    public com.google.cloud.aiplatform.v1beta1.NasJobSpec.MultiTrialAlgorithmSpec
            .SearchTrialSpecOrBuilder
        getSearchTrialSpecOrBuilder() {
      return searchTrialSpec_ == null
          ? com.google.cloud.aiplatform.v1beta1.NasJobSpec.MultiTrialAlgorithmSpec.SearchTrialSpec
              .getDefaultInstance()
          : searchTrialSpec_;
    }

    public static final int TRAIN_TRIAL_SPEC_FIELD_NUMBER = 4;
    private com.google.cloud.aiplatform.v1beta1.NasJobSpec.MultiTrialAlgorithmSpec.TrainTrialSpec
        trainTrialSpec_;
    /**
     *
     *
     * <pre>
     * Spec for train trials. Top N [TrainTrialSpec.max_parallel_trial_count]
     * search trials will be trained for every M
     * [TrainTrialSpec.frequency] trials searched.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.NasJobSpec.MultiTrialAlgorithmSpec.TrainTrialSpec train_trial_spec = 4;
     * </code>
     *
     * @return Whether the trainTrialSpec field is set.
     */
    @java.lang.Override
    public boolean hasTrainTrialSpec() {
      return ((bitField0_ & 0x00000004) != 0);
    }
    /**
     *
     *
     * <pre>
     * Spec for train trials. Top N [TrainTrialSpec.max_parallel_trial_count]
     * search trials will be trained for every M
     * [TrainTrialSpec.frequency] trials searched.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.NasJobSpec.MultiTrialAlgorithmSpec.TrainTrialSpec train_trial_spec = 4;
     * </code>
     *
     * @return The trainTrialSpec.
     */
    @java.lang.Override
    public com.google.cloud.aiplatform.v1beta1.NasJobSpec.MultiTrialAlgorithmSpec.TrainTrialSpec
        getTrainTrialSpec() {
      return trainTrialSpec_ == null
          ? com.google.cloud.aiplatform.v1beta1.NasJobSpec.MultiTrialAlgorithmSpec.TrainTrialSpec
              .getDefaultInstance()
          : trainTrialSpec_;
    }
    /**
     *
     *
     * <pre>
     * Spec for train trials. Top N [TrainTrialSpec.max_parallel_trial_count]
     * search trials will be trained for every M
     * [TrainTrialSpec.frequency] trials searched.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.NasJobSpec.MultiTrialAlgorithmSpec.TrainTrialSpec train_trial_spec = 4;
     * </code>
     */
    @java.lang.Override
    public com.google.cloud.aiplatform.v1beta1.NasJobSpec.MultiTrialAlgorithmSpec
            .TrainTrialSpecOrBuilder
        getTrainTrialSpecOrBuilder() {
      return trainTrialSpec_ == null
          ? com.google.cloud.aiplatform.v1beta1.NasJobSpec.MultiTrialAlgorithmSpec.TrainTrialSpec
              .getDefaultInstance()
          : trainTrialSpec_;
    }

    private byte memoizedIsInitialized = -1;

    @java.lang.Override
    public final boolean isInitialized() {
      byte isInitialized = memoizedIsInitialized;
      if (isInitialized == 1) return true;
      if (isInitialized == 0) return false;

      memoizedIsInitialized = 1;
      return true;
    }

    @java.lang.Override
    public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
      if (multiTrialAlgorithm_
          != com.google.cloud.aiplatform.v1beta1.NasJobSpec.MultiTrialAlgorithmSpec
              .MultiTrialAlgorithm.MULTI_TRIAL_ALGORITHM_UNSPECIFIED
              .getNumber()) {
        output.writeEnum(1, multiTrialAlgorithm_);
      }
      if (((bitField0_ & 0x00000001) != 0)) {
        output.writeMessage(2, getMetric());
      }
      if (((bitField0_ & 0x00000002) != 0)) {
        output.writeMessage(3, getSearchTrialSpec());
      }
      if (((bitField0_ & 0x00000004) != 0)) {
        output.writeMessage(4, getTrainTrialSpec());
      }
      getUnknownFields().writeTo(output);
    }

    @java.lang.Override
    public int getSerializedSize() {
      int size = memoizedSize;
      if (size != -1) return size;

      size = 0;
      if (multiTrialAlgorithm_
          != com.google.cloud.aiplatform.v1beta1.NasJobSpec.MultiTrialAlgorithmSpec
              .MultiTrialAlgorithm.MULTI_TRIAL_ALGORITHM_UNSPECIFIED
              .getNumber()) {
        size += com.google.protobuf.CodedOutputStream.computeEnumSize(1, multiTrialAlgorithm_);
      }
      if (((bitField0_ & 0x00000001) != 0)) {
        size += com.google.protobuf.CodedOutputStream.computeMessageSize(2, getMetric());
      }
      if (((bitField0_ & 0x00000002) != 0)) {
        size += com.google.protobuf.CodedOutputStream.computeMessageSize(3, getSearchTrialSpec());
      }
      if (((bitField0_ & 0x00000004) != 0)) {
        size += com.google.protobuf.CodedOutputStream.computeMessageSize(4, getTrainTrialSpec());
      }
      size += getUnknownFields().getSerializedSize();
      memoizedSize = size;
      return size;
    }

    @java.lang.Override
    public boolean equals(final java.lang.Object obj) {
      if (obj == this) {
        return true;
      }
      if (!(obj
          instanceof com.google.cloud.aiplatform.v1beta1.NasJobSpec.MultiTrialAlgorithmSpec)) {
        return super.equals(obj);
      }
      com.google.cloud.aiplatform.v1beta1.NasJobSpec.MultiTrialAlgorithmSpec other =
          (com.google.cloud.aiplatform.v1beta1.NasJobSpec.MultiTrialAlgorithmSpec) obj;

      if (multiTrialAlgorithm_ != other.multiTrialAlgorithm_) return false;
      if (hasMetric() != other.hasMetric()) return false;
      if (hasMetric()) {
        if (!getMetric().equals(other.getMetric())) return false;
      }
      if (hasSearchTrialSpec() != other.hasSearchTrialSpec()) return false;
      if (hasSearchTrialSpec()) {
        if (!getSearchTrialSpec().equals(other.getSearchTrialSpec())) return false;
      }
      if (hasTrainTrialSpec() != other.hasTrainTrialSpec()) return false;
      if (hasTrainTrialSpec()) {
        if (!getTrainTrialSpec().equals(other.getTrainTrialSpec())) return false;
      }
      if (!getUnknownFields().equals(other.getUnknownFields())) return false;
      return true;
    }

    @java.lang.Override
    public int hashCode() {
      if (memoizedHashCode != 0) {
        return memoizedHashCode;
      }
      int hash = 41;
      hash = (19 * hash) + getDescriptor().hashCode();
      hash = (37 * hash) + MULTI_TRIAL_ALGORITHM_FIELD_NUMBER;
      hash = (53 * hash) + multiTrialAlgorithm_;
      if (hasMetric()) {
        hash = (37 * hash) + METRIC_FIELD_NUMBER;
        hash = (53 * hash) + getMetric().hashCode();
      }
      if (hasSearchTrialSpec()) {
        hash = (37 * hash) + SEARCH_TRIAL_SPEC_FIELD_NUMBER;
        hash = (53 * hash) + getSearchTrialSpec().hashCode();
      }
      if (hasTrainTrialSpec()) {
        hash = (37 * hash) + TRAIN_TRIAL_SPEC_FIELD_NUMBER;
        hash = (53 * hash) + getTrainTrialSpec().hashCode();
      }
      hash = (29 * hash) + getUnknownFields().hashCode();
      memoizedHashCode = hash;
      return hash;
    }

    public static com.google.cloud.aiplatform.v1beta1.NasJobSpec.MultiTrialAlgorithmSpec parseFrom(
        java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.aiplatform.v1beta1.NasJobSpec.MultiTrialAlgorithmSpec parseFrom(
        java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.aiplatform.v1beta1.NasJobSpec.MultiTrialAlgorithmSpec parseFrom(
        com.google.protobuf.ByteString data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.aiplatform.v1beta1.NasJobSpec.MultiTrialAlgorithmSpec parseFrom(
        com.google.protobuf.ByteString data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.aiplatform.v1beta1.NasJobSpec.MultiTrialAlgorithmSpec parseFrom(
        byte[] data) throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.aiplatform.v1beta1.NasJobSpec.MultiTrialAlgorithmSpec parseFrom(
        byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.aiplatform.v1beta1.NasJobSpec.MultiTrialAlgorithmSpec parseFrom(
        java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.cloud.aiplatform.v1beta1.NasJobSpec.MultiTrialAlgorithmSpec parseFrom(
        java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.cloud.aiplatform.v1beta1.NasJobSpec.MultiTrialAlgorithmSpec
        parseDelimitedFrom(java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
    }

    public static com.google.cloud.aiplatform.v1beta1.NasJobSpec.MultiTrialAlgorithmSpec
        parseDelimitedFrom(
            java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.cloud.aiplatform.v1beta1.NasJobSpec.MultiTrialAlgorithmSpec parseFrom(
        com.google.protobuf.CodedInputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.cloud.aiplatform.v1beta1.NasJobSpec.MultiTrialAlgorithmSpec parseFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    @java.lang.Override
    public Builder newBuilderForType() {
      return newBuilder();
    }

    public static Builder newBuilder() {
      return DEFAULT_INSTANCE.toBuilder();
    }

    public static Builder newBuilder(
        com.google.cloud.aiplatform.v1beta1.NasJobSpec.MultiTrialAlgorithmSpec prototype) {
      return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }

    @java.lang.Override
    public Builder toBuilder() {
      return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
    }

    @java.lang.Override
    protected Builder newBuilderForType(
        com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      Builder builder = new Builder(parent);
      return builder;
    }
    /**
     *
     *
     * <pre>
     * The spec of multi-trial Neural Architecture Search (NAS).
     * </pre>
     *
     * Protobuf type {@code google.cloud.aiplatform.v1beta1.NasJobSpec.MultiTrialAlgorithmSpec}
     */
    public static final class Builder
        extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
        implements
        // @@protoc_insertion_point(builder_implements:google.cloud.aiplatform.v1beta1.NasJobSpec.MultiTrialAlgorithmSpec)
        com.google.cloud.aiplatform.v1beta1.NasJobSpec.MultiTrialAlgorithmSpecOrBuilder {
      public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
        return com.google.cloud.aiplatform.v1beta1.NasJobProto
            .internal_static_google_cloud_aiplatform_v1beta1_NasJobSpec_MultiTrialAlgorithmSpec_descriptor;
      }

      @java.lang.Override
      protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return com.google.cloud.aiplatform.v1beta1.NasJobProto
            .internal_static_google_cloud_aiplatform_v1beta1_NasJobSpec_MultiTrialAlgorithmSpec_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                com.google.cloud.aiplatform.v1beta1.NasJobSpec.MultiTrialAlgorithmSpec.class,
                com.google.cloud.aiplatform.v1beta1.NasJobSpec.MultiTrialAlgorithmSpec.Builder
                    .class);
      }

      // Construct using
      // com.google.cloud.aiplatform.v1beta1.NasJobSpec.MultiTrialAlgorithmSpec.newBuilder()
      private Builder() {
        maybeForceBuilderInitialization();
      }

      private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
        super(parent);
        maybeForceBuilderInitialization();
      }

      private void maybeForceBuilderInitialization() {
        if (com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders) {
          getMetricFieldBuilder();
          getSearchTrialSpecFieldBuilder();
          getTrainTrialSpecFieldBuilder();
        }
      }

      @java.lang.Override
      public Builder clear() {
        super.clear();
        bitField0_ = 0;
        multiTrialAlgorithm_ = 0;
        metric_ = null;
        if (metricBuilder_ != null) {
          metricBuilder_.dispose();
          metricBuilder_ = null;
        }
        searchTrialSpec_ = null;
        if (searchTrialSpecBuilder_ != null) {
          searchTrialSpecBuilder_.dispose();
          searchTrialSpecBuilder_ = null;
        }
        trainTrialSpec_ = null;
        if (trainTrialSpecBuilder_ != null) {
          trainTrialSpecBuilder_.dispose();
          trainTrialSpecBuilder_ = null;
        }
        return this;
      }

      @java.lang.Override
      public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
        return com.google.cloud.aiplatform.v1beta1.NasJobProto
            .internal_static_google_cloud_aiplatform_v1beta1_NasJobSpec_MultiTrialAlgorithmSpec_descriptor;
      }

      @java.lang.Override
      public com.google.cloud.aiplatform.v1beta1.NasJobSpec.MultiTrialAlgorithmSpec
          getDefaultInstanceForType() {
        return com.google.cloud.aiplatform.v1beta1.NasJobSpec.MultiTrialAlgorithmSpec
            .getDefaultInstance();
      }

      @java.lang.Override
      public com.google.cloud.aiplatform.v1beta1.NasJobSpec.MultiTrialAlgorithmSpec build() {
        com.google.cloud.aiplatform.v1beta1.NasJobSpec.MultiTrialAlgorithmSpec result =
            buildPartial();
        if (!result.isInitialized()) {
          throw newUninitializedMessageException(result);
        }
        return result;
      }

      @java.lang.Override
      public com.google.cloud.aiplatform.v1beta1.NasJobSpec.MultiTrialAlgorithmSpec buildPartial() {
        com.google.cloud.aiplatform.v1beta1.NasJobSpec.MultiTrialAlgorithmSpec result =
            new com.google.cloud.aiplatform.v1beta1.NasJobSpec.MultiTrialAlgorithmSpec(this);
        if (bitField0_ != 0) {
          buildPartial0(result);
        }
        onBuilt();
        return result;
      }

      private void buildPartial0(
          com.google.cloud.aiplatform.v1beta1.NasJobSpec.MultiTrialAlgorithmSpec result) {
        int from_bitField0_ = bitField0_;
        if (((from_bitField0_ & 0x00000001) != 0)) {
          result.multiTrialAlgorithm_ = multiTrialAlgorithm_;
        }
        int to_bitField0_ = 0;
        if (((from_bitField0_ & 0x00000002) != 0)) {
          result.metric_ = metricBuilder_ == null ? metric_ : metricBuilder_.build();
          to_bitField0_ |= 0x00000001;
        }
        if (((from_bitField0_ & 0x00000004) != 0)) {
          result.searchTrialSpec_ =
              searchTrialSpecBuilder_ == null ? searchTrialSpec_ : searchTrialSpecBuilder_.build();
          to_bitField0_ |= 0x00000002;
        }
        if (((from_bitField0_ & 0x00000008) != 0)) {
          result.trainTrialSpec_ =
              trainTrialSpecBuilder_ == null ? trainTrialSpec_ : trainTrialSpecBuilder_.build();
          to_bitField0_ |= 0x00000004;
        }
        result.bitField0_ |= to_bitField0_;
      }

      @java.lang.Override
      public Builder clone() {
        return super.clone();
      }

      @java.lang.Override
      public Builder setField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.setField(field, value);
      }

      @java.lang.Override
      public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
        return super.clearField(field);
      }

      @java.lang.Override
      public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
        return super.clearOneof(oneof);
      }

      @java.lang.Override
      public Builder setRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          int index,
          java.lang.Object value) {
        return super.setRepeatedField(field, index, value);
      }

      @java.lang.Override
      public Builder addRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.addRepeatedField(field, value);
      }

      @java.lang.Override
      public Builder mergeFrom(com.google.protobuf.Message other) {
        if (other
            instanceof com.google.cloud.aiplatform.v1beta1.NasJobSpec.MultiTrialAlgorithmSpec) {
          return mergeFrom(
              (com.google.cloud.aiplatform.v1beta1.NasJobSpec.MultiTrialAlgorithmSpec) other);
        } else {
          super.mergeFrom(other);
          return this;
        }
      }

      public Builder mergeFrom(
          com.google.cloud.aiplatform.v1beta1.NasJobSpec.MultiTrialAlgorithmSpec other) {
        if (other
            == com.google.cloud.aiplatform.v1beta1.NasJobSpec.MultiTrialAlgorithmSpec
                .getDefaultInstance()) return this;
        if (other.multiTrialAlgorithm_ != 0) {
          setMultiTrialAlgorithmValue(other.getMultiTrialAlgorithmValue());
        }
        if (other.hasMetric()) {
          mergeMetric(other.getMetric());
        }
        if (other.hasSearchTrialSpec()) {
          mergeSearchTrialSpec(other.getSearchTrialSpec());
        }
        if (other.hasTrainTrialSpec()) {
          mergeTrainTrialSpec(other.getTrainTrialSpec());
        }
        this.mergeUnknownFields(other.getUnknownFields());
        onChanged();
        return this;
      }

      @java.lang.Override
      public final boolean isInitialized() {
        return true;
      }

      @java.lang.Override
      public Builder mergeFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        if (extensionRegistry == null) {
          throw new java.lang.NullPointerException();
        }
        try {
          boolean done = false;
          while (!done) {
            int tag = input.readTag();
            switch (tag) {
              case 0:
                done = true;
                break;
              case 8:
                {
                  multiTrialAlgorithm_ = input.readEnum();
                  bitField0_ |= 0x00000001;
                  break;
                } // case 8
              case 18:
                {
                  input.readMessage(getMetricFieldBuilder().getBuilder(), extensionRegistry);
                  bitField0_ |= 0x00000002;
                  break;
                } // case 18
              case 26:
                {
                  input.readMessage(
                      getSearchTrialSpecFieldBuilder().getBuilder(), extensionRegistry);
                  bitField0_ |= 0x00000004;
                  break;
                } // case 26
              case 34:
                {
                  input.readMessage(
                      getTrainTrialSpecFieldBuilder().getBuilder(), extensionRegistry);
                  bitField0_ |= 0x00000008;
                  break;
                } // case 34
              default:
                {
                  if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                    done = true; // was an endgroup tag
                  }
                  break;
                } // default:
            } // switch (tag)
          } // while (!done)
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          throw e.unwrapIOException();
        } finally {
          onChanged();
        } // finally
        return this;
      }

      private int bitField0_;

      private int multiTrialAlgorithm_ = 0;
      /**
       *
       *
       * <pre>
       * The multi-trial Neural Architecture Search (NAS) algorithm
       * type. Defaults to `REINFORCEMENT_LEARNING`.
       * </pre>
       *
       * <code>
       * .google.cloud.aiplatform.v1beta1.NasJobSpec.MultiTrialAlgorithmSpec.MultiTrialAlgorithm multi_trial_algorithm = 1;
       * </code>
       *
       * @return The enum numeric value on the wire for multiTrialAlgorithm.
       */
      @java.lang.Override
      public int getMultiTrialAlgorithmValue() {
        return multiTrialAlgorithm_;
      }
      /**
       *
       *
       * <pre>
       * The multi-trial Neural Architecture Search (NAS) algorithm
       * type. Defaults to `REINFORCEMENT_LEARNING`.
       * </pre>
       *
       * <code>
       * .google.cloud.aiplatform.v1beta1.NasJobSpec.MultiTrialAlgorithmSpec.MultiTrialAlgorithm multi_trial_algorithm = 1;
       * </code>
       *
       * @param value The enum numeric value on the wire for multiTrialAlgorithm to set.
       * @return This builder for chaining.
       */
      public Builder setMultiTrialAlgorithmValue(int value) {
        multiTrialAlgorithm_ = value;
        bitField0_ |= 0x00000001;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * The multi-trial Neural Architecture Search (NAS) algorithm
       * type. Defaults to `REINFORCEMENT_LEARNING`.
       * </pre>
       *
       * <code>
       * .google.cloud.aiplatform.v1beta1.NasJobSpec.MultiTrialAlgorithmSpec.MultiTrialAlgorithm multi_trial_algorithm = 1;
       * </code>
       *
       * @return The multiTrialAlgorithm.
       */
      @java.lang.Override
      public com.google.cloud.aiplatform.v1beta1.NasJobSpec.MultiTrialAlgorithmSpec
              .MultiTrialAlgorithm
          getMultiTrialAlgorithm() {
        com.google.cloud.aiplatform.v1beta1.NasJobSpec.MultiTrialAlgorithmSpec.MultiTrialAlgorithm
            result =
                com.google.cloud.aiplatform.v1beta1.NasJobSpec.MultiTrialAlgorithmSpec
                    .MultiTrialAlgorithm.forNumber(multiTrialAlgorithm_);
        return result == null
            ? com.google.cloud.aiplatform.v1beta1.NasJobSpec.MultiTrialAlgorithmSpec
                .MultiTrialAlgorithm.UNRECOGNIZED
            : result;
      }
      /**
       *
       *
       * <pre>
       * The multi-trial Neural Architecture Search (NAS) algorithm
       * type. Defaults to `REINFORCEMENT_LEARNING`.
       * </pre>
       *
       * <code>
       * .google.cloud.aiplatform.v1beta1.NasJobSpec.MultiTrialAlgorithmSpec.MultiTrialAlgorithm multi_trial_algorithm = 1;
       * </code>
       *
       * @param value The multiTrialAlgorithm to set.
       * @return This builder for chaining.
       */
      public Builder setMultiTrialAlgorithm(
          com.google.cloud.aiplatform.v1beta1.NasJobSpec.MultiTrialAlgorithmSpec.MultiTrialAlgorithm
              value) {
        if (value == null) {
          throw new NullPointerException();
        }
        bitField0_ |= 0x00000001;
        multiTrialAlgorithm_ = value.getNumber();
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * The multi-trial Neural Architecture Search (NAS) algorithm
       * type. Defaults to `REINFORCEMENT_LEARNING`.
       * </pre>
       *
       * <code>
       * .google.cloud.aiplatform.v1beta1.NasJobSpec.MultiTrialAlgorithmSpec.MultiTrialAlgorithm multi_trial_algorithm = 1;
       * </code>
       *
       * @return This builder for chaining.
       */
      public Builder clearMultiTrialAlgorithm() {
        bitField0_ = (bitField0_ & ~0x00000001);
        multiTrialAlgorithm_ = 0;
        onChanged();
        return this;
      }

      private com.google.cloud.aiplatform.v1beta1.NasJobSpec.MultiTrialAlgorithmSpec.MetricSpec
          metric_;
      private com.google.protobuf.SingleFieldBuilderV3<
              com.google.cloud.aiplatform.v1beta1.NasJobSpec.MultiTrialAlgorithmSpec.MetricSpec,
              com.google.cloud.aiplatform.v1beta1.NasJobSpec.MultiTrialAlgorithmSpec.MetricSpec
                  .Builder,
              com.google.cloud.aiplatform.v1beta1.NasJobSpec.MultiTrialAlgorithmSpec
                  .MetricSpecOrBuilder>
          metricBuilder_;
      /**
       *
       *
       * <pre>
       * Metric specs for the NAS job.
       * Validation for this field is done at `multi_trial_algorithm_spec` field.
       * </pre>
       *
       * <code>
       * .google.cloud.aiplatform.v1beta1.NasJobSpec.MultiTrialAlgorithmSpec.MetricSpec metric = 2;
       * </code>
       *
       * @return Whether the metric field is set.
       */
      public boolean hasMetric() {
        return ((bitField0_ & 0x00000002) != 0);
      }
      /**
       *
       *
       * <pre>
       * Metric specs for the NAS job.
       * Validation for this field is done at `multi_trial_algorithm_spec` field.
       * </pre>
       *
       * <code>
       * .google.cloud.aiplatform.v1beta1.NasJobSpec.MultiTrialAlgorithmSpec.MetricSpec metric = 2;
       * </code>
       *
       * @return The metric.
       */
      public com.google.cloud.aiplatform.v1beta1.NasJobSpec.MultiTrialAlgorithmSpec.MetricSpec
          getMetric() {
        if (metricBuilder_ == null) {
          return metric_ == null
              ? com.google.cloud.aiplatform.v1beta1.NasJobSpec.MultiTrialAlgorithmSpec.MetricSpec
                  .getDefaultInstance()
              : metric_;
        } else {
          return metricBuilder_.getMessage();
        }
      }
      /**
       *
       *
       * <pre>
       * Metric specs for the NAS job.
       * Validation for this field is done at `multi_trial_algorithm_spec` field.
       * </pre>
       *
       * <code>
       * .google.cloud.aiplatform.v1beta1.NasJobSpec.MultiTrialAlgorithmSpec.MetricSpec metric = 2;
       * </code>
       */
      public Builder setMetric(
          com.google.cloud.aiplatform.v1beta1.NasJobSpec.MultiTrialAlgorithmSpec.MetricSpec value) {
        if (metricBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          metric_ = value;
        } else {
          metricBuilder_.setMessage(value);
        }
        bitField0_ |= 0x00000002;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Metric specs for the NAS job.
       * Validation for this field is done at `multi_trial_algorithm_spec` field.
       * </pre>
       *
       * <code>
       * .google.cloud.aiplatform.v1beta1.NasJobSpec.MultiTrialAlgorithmSpec.MetricSpec metric = 2;
       * </code>
       */
      public Builder setMetric(
          com.google.cloud.aiplatform.v1beta1.NasJobSpec.MultiTrialAlgorithmSpec.MetricSpec.Builder
              builderForValue) {
        if (metricBuilder_ == null) {
          metric_ = builderForValue.build();
        } else {
          metricBuilder_.setMessage(builderForValue.build());
        }
        bitField0_ |= 0x00000002;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Metric specs for the NAS job.
       * Validation for this field is done at `multi_trial_algorithm_spec` field.
       * </pre>
       *
       * <code>
       * .google.cloud.aiplatform.v1beta1.NasJobSpec.MultiTrialAlgorithmSpec.MetricSpec metric = 2;
       * </code>
       */
      public Builder mergeMetric(
          com.google.cloud.aiplatform.v1beta1.NasJobSpec.MultiTrialAlgorithmSpec.MetricSpec value) {
        if (metricBuilder_ == null) {
          if (((bitField0_ & 0x00000002) != 0)
              && metric_ != null
              && metric_
                  != com.google.cloud.aiplatform.v1beta1.NasJobSpec.MultiTrialAlgorithmSpec
                      .MetricSpec.getDefaultInstance()) {
            getMetricBuilder().mergeFrom(value);
          } else {
            metric_ = value;
          }
        } else {
          metricBuilder_.mergeFrom(value);
        }
        if (metric_ != null) {
          bitField0_ |= 0x00000002;
          onChanged();
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * Metric specs for the NAS job.
       * Validation for this field is done at `multi_trial_algorithm_spec` field.
       * </pre>
       *
       * <code>
       * .google.cloud.aiplatform.v1beta1.NasJobSpec.MultiTrialAlgorithmSpec.MetricSpec metric = 2;
       * </code>
       */
      public Builder clearMetric() {
        bitField0_ = (bitField0_ & ~0x00000002);
        metric_ = null;
        if (metricBuilder_ != null) {
          metricBuilder_.dispose();
          metricBuilder_ = null;
        }
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Metric specs for the NAS job.
       * Validation for this field is done at `multi_trial_algorithm_spec` field.
       * </pre>
       *
       * <code>
       * .google.cloud.aiplatform.v1beta1.NasJobSpec.MultiTrialAlgorithmSpec.MetricSpec metric = 2;
       * </code>
       */
      public com.google.cloud.aiplatform.v1beta1.NasJobSpec.MultiTrialAlgorithmSpec.MetricSpec
              .Builder
          getMetricBuilder() {
        bitField0_ |= 0x00000002;
        onChanged();
        return getMetricFieldBuilder().getBuilder();
      }
      /**
       *
       *
       * <pre>
       * Metric specs for the NAS job.
       * Validation for this field is done at `multi_trial_algorithm_spec` field.
       * </pre>
       *
       * <code>
       * .google.cloud.aiplatform.v1beta1.NasJobSpec.MultiTrialAlgorithmSpec.MetricSpec metric = 2;
       * </code>
       */
      public com.google.cloud.aiplatform.v1beta1.NasJobSpec.MultiTrialAlgorithmSpec
              .MetricSpecOrBuilder
          getMetricOrBuilder() {
        if (metricBuilder_ != null) {
          return metricBuilder_.getMessageOrBuilder();
        } else {
          return metric_ == null
              ? com.google.cloud.aiplatform.v1beta1.NasJobSpec.MultiTrialAlgorithmSpec.MetricSpec
                  .getDefaultInstance()
              : metric_;
        }
      }
      /**
       *
       *
       * <pre>
       * Metric specs for the NAS job.
       * Validation for this field is done at `multi_trial_algorithm_spec` field.
       * </pre>
       *
       * <code>
       * .google.cloud.aiplatform.v1beta1.NasJobSpec.MultiTrialAlgorithmSpec.MetricSpec metric = 2;
       * </code>
       */
      private com.google.protobuf.SingleFieldBuilderV3<
              com.google.cloud.aiplatform.v1beta1.NasJobSpec.MultiTrialAlgorithmSpec.MetricSpec,
              com.google.cloud.aiplatform.v1beta1.NasJobSpec.MultiTrialAlgorithmSpec.MetricSpec
                  .Builder,
              com.google.cloud.aiplatform.v1beta1.NasJobSpec.MultiTrialAlgorithmSpec
                  .MetricSpecOrBuilder>
          getMetricFieldBuilder() {
        if (metricBuilder_ == null) {
          metricBuilder_ =
              new com.google.protobuf.SingleFieldBuilderV3<
                  com.google.cloud.aiplatform.v1beta1.NasJobSpec.MultiTrialAlgorithmSpec.MetricSpec,
                  com.google.cloud.aiplatform.v1beta1.NasJobSpec.MultiTrialAlgorithmSpec.MetricSpec
                      .Builder,
                  com.google.cloud.aiplatform.v1beta1.NasJobSpec.MultiTrialAlgorithmSpec
                      .MetricSpecOrBuilder>(getMetric(), getParentForChildren(), isClean());
          metric_ = null;
        }
        return metricBuilder_;
      }

      private com.google.cloud.aiplatform.v1beta1.NasJobSpec.MultiTrialAlgorithmSpec.SearchTrialSpec
          searchTrialSpec_;
      private com.google.protobuf.SingleFieldBuilderV3<
              com.google.cloud.aiplatform.v1beta1.NasJobSpec.MultiTrialAlgorithmSpec
                  .SearchTrialSpec,
              com.google.cloud.aiplatform.v1beta1.NasJobSpec.MultiTrialAlgorithmSpec.SearchTrialSpec
                  .Builder,
              com.google.cloud.aiplatform.v1beta1.NasJobSpec.MultiTrialAlgorithmSpec
                  .SearchTrialSpecOrBuilder>
          searchTrialSpecBuilder_;
      /**
       *
       *
       * <pre>
       * Required. Spec for search trials.
       * </pre>
       *
       * <code>
       * .google.cloud.aiplatform.v1beta1.NasJobSpec.MultiTrialAlgorithmSpec.SearchTrialSpec search_trial_spec = 3 [(.google.api.field_behavior) = REQUIRED];
       * </code>
       *
       * @return Whether the searchTrialSpec field is set.
       */
      public boolean hasSearchTrialSpec() {
        return ((bitField0_ & 0x00000004) != 0);
      }
      /**
       *
       *
       * <pre>
       * Required. Spec for search trials.
       * </pre>
       *
       * <code>
       * .google.cloud.aiplatform.v1beta1.NasJobSpec.MultiTrialAlgorithmSpec.SearchTrialSpec search_trial_spec = 3 [(.google.api.field_behavior) = REQUIRED];
       * </code>
       *
       * @return The searchTrialSpec.
       */
      public com.google.cloud.aiplatform.v1beta1.NasJobSpec.MultiTrialAlgorithmSpec.SearchTrialSpec
          getSearchTrialSpec() {
        if (searchTrialSpecBuilder_ == null) {
          return searchTrialSpec_ == null
              ? com.google.cloud.aiplatform.v1beta1.NasJobSpec.MultiTrialAlgorithmSpec
                  .SearchTrialSpec.getDefaultInstance()
              : searchTrialSpec_;
        } else {
          return searchTrialSpecBuilder_.getMessage();
        }
      }
      /**
       *
       *
       * <pre>
       * Required. Spec for search trials.
       * </pre>
       *
       * <code>
       * .google.cloud.aiplatform.v1beta1.NasJobSpec.MultiTrialAlgorithmSpec.SearchTrialSpec search_trial_spec = 3 [(.google.api.field_behavior) = REQUIRED];
       * </code>
       */
      public Builder setSearchTrialSpec(
          com.google.cloud.aiplatform.v1beta1.NasJobSpec.MultiTrialAlgorithmSpec.SearchTrialSpec
              value) {
        if (searchTrialSpecBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          searchTrialSpec_ = value;
        } else {
          searchTrialSpecBuilder_.setMessage(value);
        }
        bitField0_ |= 0x00000004;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Required. Spec for search trials.
       * </pre>
       *
       * <code>
       * .google.cloud.aiplatform.v1beta1.NasJobSpec.MultiTrialAlgorithmSpec.SearchTrialSpec search_trial_spec = 3 [(.google.api.field_behavior) = REQUIRED];
       * </code>
       */
      public Builder setSearchTrialSpec(
          com.google.cloud.aiplatform.v1beta1.NasJobSpec.MultiTrialAlgorithmSpec.SearchTrialSpec
                  .Builder
              builderForValue) {
        if (searchTrialSpecBuilder_ == null) {
          searchTrialSpec_ = builderForValue.build();
        } else {
          searchTrialSpecBuilder_.setMessage(builderForValue.build());
        }
        bitField0_ |= 0x00000004;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Required. Spec for search trials.
       * </pre>
       *
       * <code>
       * .google.cloud.aiplatform.v1beta1.NasJobSpec.MultiTrialAlgorithmSpec.SearchTrialSpec search_trial_spec = 3 [(.google.api.field_behavior) = REQUIRED];
       * </code>
       */
      public Builder mergeSearchTrialSpec(
          com.google.cloud.aiplatform.v1beta1.NasJobSpec.MultiTrialAlgorithmSpec.SearchTrialSpec
              value) {
        if (searchTrialSpecBuilder_ == null) {
          if (((bitField0_ & 0x00000004) != 0)
              && searchTrialSpec_ != null
              && searchTrialSpec_
                  != com.google.cloud.aiplatform.v1beta1.NasJobSpec.MultiTrialAlgorithmSpec
                      .SearchTrialSpec.getDefaultInstance()) {
            getSearchTrialSpecBuilder().mergeFrom(value);
          } else {
            searchTrialSpec_ = value;
          }
        } else {
          searchTrialSpecBuilder_.mergeFrom(value);
        }
        if (searchTrialSpec_ != null) {
          bitField0_ |= 0x00000004;
          onChanged();
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * Required. Spec for search trials.
       * </pre>
       *
       * <code>
       * .google.cloud.aiplatform.v1beta1.NasJobSpec.MultiTrialAlgorithmSpec.SearchTrialSpec search_trial_spec = 3 [(.google.api.field_behavior) = REQUIRED];
       * </code>
       */
      public Builder clearSearchTrialSpec() {
        bitField0_ = (bitField0_ & ~0x00000004);
        searchTrialSpec_ = null;
        if (searchTrialSpecBuilder_ != null) {
          searchTrialSpecBuilder_.dispose();
          searchTrialSpecBuilder_ = null;
        }
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Required. Spec for search trials.
       * </pre>
       *
       * <code>
       * .google.cloud.aiplatform.v1beta1.NasJobSpec.MultiTrialAlgorithmSpec.SearchTrialSpec search_trial_spec = 3 [(.google.api.field_behavior) = REQUIRED];
       * </code>
       */
      public com.google.cloud.aiplatform.v1beta1.NasJobSpec.MultiTrialAlgorithmSpec.SearchTrialSpec
              .Builder
          getSearchTrialSpecBuilder() {
        bitField0_ |= 0x00000004;
        onChanged();
        return getSearchTrialSpecFieldBuilder().getBuilder();
      }
      /**
       *
       *
       * <pre>
       * Required. Spec for search trials.
       * </pre>
       *
       * <code>
       * .google.cloud.aiplatform.v1beta1.NasJobSpec.MultiTrialAlgorithmSpec.SearchTrialSpec search_trial_spec = 3 [(.google.api.field_behavior) = REQUIRED];
       * </code>
       */
      public com.google.cloud.aiplatform.v1beta1.NasJobSpec.MultiTrialAlgorithmSpec
              .SearchTrialSpecOrBuilder
          getSearchTrialSpecOrBuilder() {
        if (searchTrialSpecBuilder_ != null) {
          return searchTrialSpecBuilder_.getMessageOrBuilder();
        } else {
          return searchTrialSpec_ == null
              ? com.google.cloud.aiplatform.v1beta1.NasJobSpec.MultiTrialAlgorithmSpec
                  .SearchTrialSpec.getDefaultInstance()
              : searchTrialSpec_;
        }
      }
      /**
       *
       *
       * <pre>
       * Required. Spec for search trials.
       * </pre>
       *
       * <code>
       * .google.cloud.aiplatform.v1beta1.NasJobSpec.MultiTrialAlgorithmSpec.SearchTrialSpec search_trial_spec = 3 [(.google.api.field_behavior) = REQUIRED];
       * </code>
       */
      private com.google.protobuf.SingleFieldBuilderV3<
              com.google.cloud.aiplatform.v1beta1.NasJobSpec.MultiTrialAlgorithmSpec
                  .SearchTrialSpec,
              com.google.cloud.aiplatform.v1beta1.NasJobSpec.MultiTrialAlgorithmSpec.SearchTrialSpec
                  .Builder,
              com.google.cloud.aiplatform.v1beta1.NasJobSpec.MultiTrialAlgorithmSpec
                  .SearchTrialSpecOrBuilder>
          getSearchTrialSpecFieldBuilder() {
        if (searchTrialSpecBuilder_ == null) {
          searchTrialSpecBuilder_ =
              new com.google.protobuf.SingleFieldBuilderV3<
                  com.google.cloud.aiplatform.v1beta1.NasJobSpec.MultiTrialAlgorithmSpec
                      .SearchTrialSpec,
                  com.google.cloud.aiplatform.v1beta1.NasJobSpec.MultiTrialAlgorithmSpec
                      .SearchTrialSpec.Builder,
                  com.google.cloud.aiplatform.v1beta1.NasJobSpec.MultiTrialAlgorithmSpec
                      .SearchTrialSpecOrBuilder>(
                  getSearchTrialSpec(), getParentForChildren(), isClean());
          searchTrialSpec_ = null;
        }
        return searchTrialSpecBuilder_;
      }

      private com.google.cloud.aiplatform.v1beta1.NasJobSpec.MultiTrialAlgorithmSpec.TrainTrialSpec
          trainTrialSpec_;
      private com.google.protobuf.SingleFieldBuilderV3<
              com.google.cloud.aiplatform.v1beta1.NasJobSpec.MultiTrialAlgorithmSpec.TrainTrialSpec,
              com.google.cloud.aiplatform.v1beta1.NasJobSpec.MultiTrialAlgorithmSpec.TrainTrialSpec
                  .Builder,
              com.google.cloud.aiplatform.v1beta1.NasJobSpec.MultiTrialAlgorithmSpec
                  .TrainTrialSpecOrBuilder>
          trainTrialSpecBuilder_;
      /**
       *
       *
       * <pre>
       * Spec for train trials. Top N [TrainTrialSpec.max_parallel_trial_count]
       * search trials will be trained for every M
       * [TrainTrialSpec.frequency] trials searched.
       * </pre>
       *
       * <code>
       * .google.cloud.aiplatform.v1beta1.NasJobSpec.MultiTrialAlgorithmSpec.TrainTrialSpec train_trial_spec = 4;
       * </code>
       *
       * @return Whether the trainTrialSpec field is set.
       */
      public boolean hasTrainTrialSpec() {
        return ((bitField0_ & 0x00000008) != 0);
      }
      /**
       *
       *
       * <pre>
       * Spec for train trials. Top N [TrainTrialSpec.max_parallel_trial_count]
       * search trials will be trained for every M
       * [TrainTrialSpec.frequency] trials searched.
       * </pre>
       *
       * <code>
       * .google.cloud.aiplatform.v1beta1.NasJobSpec.MultiTrialAlgorithmSpec.TrainTrialSpec train_trial_spec = 4;
       * </code>
       *
       * @return The trainTrialSpec.
       */
      public com.google.cloud.aiplatform.v1beta1.NasJobSpec.MultiTrialAlgorithmSpec.TrainTrialSpec
          getTrainTrialSpec() {
        if (trainTrialSpecBuilder_ == null) {
          return trainTrialSpec_ == null
              ? com.google.cloud.aiplatform.v1beta1.NasJobSpec.MultiTrialAlgorithmSpec
                  .TrainTrialSpec.getDefaultInstance()
              : trainTrialSpec_;
        } else {
          return trainTrialSpecBuilder_.getMessage();
        }
      }
      /**
       *
       *
       * <pre>
       * Spec for train trials. Top N [TrainTrialSpec.max_parallel_trial_count]
       * search trials will be trained for every M
       * [TrainTrialSpec.frequency] trials searched.
       * </pre>
       *
       * <code>
       * .google.cloud.aiplatform.v1beta1.NasJobSpec.MultiTrialAlgorithmSpec.TrainTrialSpec train_trial_spec = 4;
       * </code>
       */
      public Builder setTrainTrialSpec(
          com.google.cloud.aiplatform.v1beta1.NasJobSpec.MultiTrialAlgorithmSpec.TrainTrialSpec
              value) {
        if (trainTrialSpecBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          trainTrialSpec_ = value;
        } else {
          trainTrialSpecBuilder_.setMessage(value);
        }
        bitField0_ |= 0x00000008;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Spec for train trials. Top N [TrainTrialSpec.max_parallel_trial_count]
       * search trials will be trained for every M
       * [TrainTrialSpec.frequency] trials searched.
       * </pre>
       *
       * <code>
       * .google.cloud.aiplatform.v1beta1.NasJobSpec.MultiTrialAlgorithmSpec.TrainTrialSpec train_trial_spec = 4;
       * </code>
       */
      public Builder setTrainTrialSpec(
          com.google.cloud.aiplatform.v1beta1.NasJobSpec.MultiTrialAlgorithmSpec.TrainTrialSpec
                  .Builder
              builderForValue) {
        if (trainTrialSpecBuilder_ == null) {
          trainTrialSpec_ = builderForValue.build();
        } else {
          trainTrialSpecBuilder_.setMessage(builderForValue.build());
        }
        bitField0_ |= 0x00000008;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Spec for train trials. Top N [TrainTrialSpec.max_parallel_trial_count]
       * search trials will be trained for every M
       * [TrainTrialSpec.frequency] trials searched.
       * </pre>
       *
       * <code>
       * .google.cloud.aiplatform.v1beta1.NasJobSpec.MultiTrialAlgorithmSpec.TrainTrialSpec train_trial_spec = 4;
       * </code>
       */
      public Builder mergeTrainTrialSpec(
          com.google.cloud.aiplatform.v1beta1.NasJobSpec.MultiTrialAlgorithmSpec.TrainTrialSpec
              value) {
        if (trainTrialSpecBuilder_ == null) {
          if (((bitField0_ & 0x00000008) != 0)
              && trainTrialSpec_ != null
              && trainTrialSpec_
                  != com.google.cloud.aiplatform.v1beta1.NasJobSpec.MultiTrialAlgorithmSpec
                      .TrainTrialSpec.getDefaultInstance()) {
            getTrainTrialSpecBuilder().mergeFrom(value);
          } else {
            trainTrialSpec_ = value;
          }
        } else {
          trainTrialSpecBuilder_.mergeFrom(value);
        }
        if (trainTrialSpec_ != null) {
          bitField0_ |= 0x00000008;
          onChanged();
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * Spec for train trials. Top N [TrainTrialSpec.max_parallel_trial_count]
       * search trials will be trained for every M
       * [TrainTrialSpec.frequency] trials searched.
       * </pre>
       *
       * <code>
       * .google.cloud.aiplatform.v1beta1.NasJobSpec.MultiTrialAlgorithmSpec.TrainTrialSpec train_trial_spec = 4;
       * </code>
       */
      public Builder clearTrainTrialSpec() {
        bitField0_ = (bitField0_ & ~0x00000008);
        trainTrialSpec_ = null;
        if (trainTrialSpecBuilder_ != null) {
          trainTrialSpecBuilder_.dispose();
          trainTrialSpecBuilder_ = null;
        }
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Spec for train trials. Top N [TrainTrialSpec.max_parallel_trial_count]
       * search trials will be trained for every M
       * [TrainTrialSpec.frequency] trials searched.
       * </pre>
       *
       * <code>
       * .google.cloud.aiplatform.v1beta1.NasJobSpec.MultiTrialAlgorithmSpec.TrainTrialSpec train_trial_spec = 4;
       * </code>
       */
      public com.google.cloud.aiplatform.v1beta1.NasJobSpec.MultiTrialAlgorithmSpec.TrainTrialSpec
              .Builder
          getTrainTrialSpecBuilder() {
        bitField0_ |= 0x00000008;
        onChanged();
        return getTrainTrialSpecFieldBuilder().getBuilder();
      }
      /**
       *
       *
       * <pre>
       * Spec for train trials. Top N [TrainTrialSpec.max_parallel_trial_count]
       * search trials will be trained for every M
       * [TrainTrialSpec.frequency] trials searched.
       * </pre>
       *
       * <code>
       * .google.cloud.aiplatform.v1beta1.NasJobSpec.MultiTrialAlgorithmSpec.TrainTrialSpec train_trial_spec = 4;
       * </code>
       */
      public com.google.cloud.aiplatform.v1beta1.NasJobSpec.MultiTrialAlgorithmSpec
              .TrainTrialSpecOrBuilder
          getTrainTrialSpecOrBuilder() {
        if (trainTrialSpecBuilder_ != null) {
          return trainTrialSpecBuilder_.getMessageOrBuilder();
        } else {
          return trainTrialSpec_ == null
              ? com.google.cloud.aiplatform.v1beta1.NasJobSpec.MultiTrialAlgorithmSpec
                  .TrainTrialSpec.getDefaultInstance()
              : trainTrialSpec_;
        }
      }
      /**
       *
       *
       * <pre>
       * Spec for train trials. Top N [TrainTrialSpec.max_parallel_trial_count]
       * search trials will be trained for every M
       * [TrainTrialSpec.frequency] trials searched.
       * </pre>
       *
       * <code>
       * .google.cloud.aiplatform.v1beta1.NasJobSpec.MultiTrialAlgorithmSpec.TrainTrialSpec train_trial_spec = 4;
       * </code>
       */
      private com.google.protobuf.SingleFieldBuilderV3<
              com.google.cloud.aiplatform.v1beta1.NasJobSpec.MultiTrialAlgorithmSpec.TrainTrialSpec,
              com.google.cloud.aiplatform.v1beta1.NasJobSpec.MultiTrialAlgorithmSpec.TrainTrialSpec
                  .Builder,
              com.google.cloud.aiplatform.v1beta1.NasJobSpec.MultiTrialAlgorithmSpec
                  .TrainTrialSpecOrBuilder>
          getTrainTrialSpecFieldBuilder() {
        if (trainTrialSpecBuilder_ == null) {
          trainTrialSpecBuilder_ =
              new com.google.protobuf.SingleFieldBuilderV3<
                  com.google.cloud.aiplatform.v1beta1.NasJobSpec.MultiTrialAlgorithmSpec
                      .TrainTrialSpec,
                  com.google.cloud.aiplatform.v1beta1.NasJobSpec.MultiTrialAlgorithmSpec
                      .TrainTrialSpec.Builder,
                  com.google.cloud.aiplatform.v1beta1.NasJobSpec.MultiTrialAlgorithmSpec
                      .TrainTrialSpecOrBuilder>(
                  getTrainTrialSpec(), getParentForChildren(), isClean());
          trainTrialSpec_ = null;
        }
        return trainTrialSpecBuilder_;
      }

      @java.lang.Override
      public final Builder setUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.setUnknownFields(unknownFields);
      }

      @java.lang.Override
      public final Builder mergeUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.mergeUnknownFields(unknownFields);
      }

      // @@protoc_insertion_point(builder_scope:google.cloud.aiplatform.v1beta1.NasJobSpec.MultiTrialAlgorithmSpec)
    }

    // @@protoc_insertion_point(class_scope:google.cloud.aiplatform.v1beta1.NasJobSpec.MultiTrialAlgorithmSpec)
    private static final com.google.cloud.aiplatform.v1beta1.NasJobSpec.MultiTrialAlgorithmSpec
        DEFAULT_INSTANCE;

    static {
      DEFAULT_INSTANCE =
          new com.google.cloud.aiplatform.v1beta1.NasJobSpec.MultiTrialAlgorithmSpec();
    }

    public static com.google.cloud.aiplatform.v1beta1.NasJobSpec.MultiTrialAlgorithmSpec
        getDefaultInstance() {
      return DEFAULT_INSTANCE;
    }

    private static final com.google.protobuf.Parser<MultiTrialAlgorithmSpec> PARSER =
        new com.google.protobuf.AbstractParser<MultiTrialAlgorithmSpec>() {
          @java.lang.Override
          public MultiTrialAlgorithmSpec parsePartialFrom(
              com.google.protobuf.CodedInputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
            Builder builder = newBuilder();
            try {
              builder.mergeFrom(input, extensionRegistry);
            } catch (com.google.protobuf.InvalidProtocolBufferException e) {
              throw e.setUnfinishedMessage(builder.buildPartial());
            } catch (com.google.protobuf.UninitializedMessageException e) {
              throw e.asInvalidProtocolBufferException()
                  .setUnfinishedMessage(builder.buildPartial());
            } catch (java.io.IOException e) {
              throw new com.google.protobuf.InvalidProtocolBufferException(e)
                  .setUnfinishedMessage(builder.buildPartial());
            }
            return builder.buildPartial();
          }
        };

    public static com.google.protobuf.Parser<MultiTrialAlgorithmSpec> parser() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.protobuf.Parser<MultiTrialAlgorithmSpec> getParserForType() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.cloud.aiplatform.v1beta1.NasJobSpec.MultiTrialAlgorithmSpec
        getDefaultInstanceForType() {
      return DEFAULT_INSTANCE;
    }
  }

  private int nasAlgorithmSpecCase_ = 0;

  @SuppressWarnings("serial")
  private java.lang.Object nasAlgorithmSpec_;

  public enum NasAlgorithmSpecCase
      implements
          com.google.protobuf.Internal.EnumLite,
          com.google.protobuf.AbstractMessage.InternalOneOfEnum {
    MULTI_TRIAL_ALGORITHM_SPEC(2),
    NASALGORITHMSPEC_NOT_SET(0);
    private final int value;

    private NasAlgorithmSpecCase(int value) {
      this.value = value;
    }
    /**
     * @param value The number of the enum to look for.
     * @return The enum associated with the given number.
     * @deprecated Use {@link #forNumber(int)} instead.
     */
    @java.lang.Deprecated
    public static NasAlgorithmSpecCase valueOf(int value) {
      return forNumber(value);
    }

    public static NasAlgorithmSpecCase forNumber(int value) {
      switch (value) {
        case 2:
          return MULTI_TRIAL_ALGORITHM_SPEC;
        case 0:
          return NASALGORITHMSPEC_NOT_SET;
        default:
          return null;
      }
    }

    public int getNumber() {
      return this.value;
    }
  };

  public NasAlgorithmSpecCase getNasAlgorithmSpecCase() {
    return NasAlgorithmSpecCase.forNumber(nasAlgorithmSpecCase_);
  }

  public static final int MULTI_TRIAL_ALGORITHM_SPEC_FIELD_NUMBER = 2;
  /**
   *
   *
   * <pre>
   * The spec of multi-trial algorithms.
   * </pre>
   *
   * <code>
   * .google.cloud.aiplatform.v1beta1.NasJobSpec.MultiTrialAlgorithmSpec multi_trial_algorithm_spec = 2;
   * </code>
   *
   * @return Whether the multiTrialAlgorithmSpec field is set.
   */
  @java.lang.Override
  public boolean hasMultiTrialAlgorithmSpec() {
    return nasAlgorithmSpecCase_ == 2;
  }
  /**
   *
   *
   * <pre>
   * The spec of multi-trial algorithms.
   * </pre>
   *
   * <code>
   * .google.cloud.aiplatform.v1beta1.NasJobSpec.MultiTrialAlgorithmSpec multi_trial_algorithm_spec = 2;
   * </code>
   *
   * @return The multiTrialAlgorithmSpec.
   */
  @java.lang.Override
  public com.google.cloud.aiplatform.v1beta1.NasJobSpec.MultiTrialAlgorithmSpec
      getMultiTrialAlgorithmSpec() {
    if (nasAlgorithmSpecCase_ == 2) {
      return (com.google.cloud.aiplatform.v1beta1.NasJobSpec.MultiTrialAlgorithmSpec)
          nasAlgorithmSpec_;
    }
    return com.google.cloud.aiplatform.v1beta1.NasJobSpec.MultiTrialAlgorithmSpec
        .getDefaultInstance();
  }
  /**
   *
   *
   * <pre>
   * The spec of multi-trial algorithms.
   * </pre>
   *
   * <code>
   * .google.cloud.aiplatform.v1beta1.NasJobSpec.MultiTrialAlgorithmSpec multi_trial_algorithm_spec = 2;
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.aiplatform.v1beta1.NasJobSpec.MultiTrialAlgorithmSpecOrBuilder
      getMultiTrialAlgorithmSpecOrBuilder() {
    if (nasAlgorithmSpecCase_ == 2) {
      return (com.google.cloud.aiplatform.v1beta1.NasJobSpec.MultiTrialAlgorithmSpec)
          nasAlgorithmSpec_;
    }
    return com.google.cloud.aiplatform.v1beta1.NasJobSpec.MultiTrialAlgorithmSpec
        .getDefaultInstance();
  }

  public static final int RESUME_NAS_JOB_ID_FIELD_NUMBER = 3;

  @SuppressWarnings("serial")
  private volatile java.lang.Object resumeNasJobId_ = "";
  /**
   *
   *
   * <pre>
   * The ID of the existing NasJob in the same Project and Location
   * which will be used to resume search. search_space_spec and
   * nas_algorithm_spec are obtained from previous NasJob hence should not
   * provide them again for this NasJob.
   * </pre>
   *
   * <code>string resume_nas_job_id = 3;</code>
   *
   * @return The resumeNasJobId.
   */
  @java.lang.Override
  public java.lang.String getResumeNasJobId() {
    java.lang.Object ref = resumeNasJobId_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      resumeNasJobId_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * The ID of the existing NasJob in the same Project and Location
   * which will be used to resume search. search_space_spec and
   * nas_algorithm_spec are obtained from previous NasJob hence should not
   * provide them again for this NasJob.
   * </pre>
   *
   * <code>string resume_nas_job_id = 3;</code>
   *
   * @return The bytes for resumeNasJobId.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getResumeNasJobIdBytes() {
    java.lang.Object ref = resumeNasJobId_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      resumeNasJobId_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int SEARCH_SPACE_SPEC_FIELD_NUMBER = 1;

  @SuppressWarnings("serial")
  private volatile java.lang.Object searchSpaceSpec_ = "";
  /**
   *
   *
   * <pre>
   * It defines the search space for Neural Architecture Search (NAS).
   * </pre>
   *
   * <code>string search_space_spec = 1;</code>
   *
   * @return The searchSpaceSpec.
   */
  @java.lang.Override
  public java.lang.String getSearchSpaceSpec() {
    java.lang.Object ref = searchSpaceSpec_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      searchSpaceSpec_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * It defines the search space for Neural Architecture Search (NAS).
   * </pre>
   *
   * <code>string search_space_spec = 1;</code>
   *
   * @return The bytes for searchSpaceSpec.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getSearchSpaceSpecBytes() {
    java.lang.Object ref = searchSpaceSpec_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      searchSpaceSpec_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(searchSpaceSpec_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 1, searchSpaceSpec_);
    }
    if (nasAlgorithmSpecCase_ == 2) {
      output.writeMessage(
          2,
          (com.google.cloud.aiplatform.v1beta1.NasJobSpec.MultiTrialAlgorithmSpec)
              nasAlgorithmSpec_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(resumeNasJobId_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 3, resumeNasJobId_);
    }
    getUnknownFields().writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(searchSpaceSpec_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(1, searchSpaceSpec_);
    }
    if (nasAlgorithmSpecCase_ == 2) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(
              2,
              (com.google.cloud.aiplatform.v1beta1.NasJobSpec.MultiTrialAlgorithmSpec)
                  nasAlgorithmSpec_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(resumeNasJobId_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(3, resumeNasJobId_);
    }
    size += getUnknownFields().getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.cloud.aiplatform.v1beta1.NasJobSpec)) {
      return super.equals(obj);
    }
    com.google.cloud.aiplatform.v1beta1.NasJobSpec other =
        (com.google.cloud.aiplatform.v1beta1.NasJobSpec) obj;

    if (!getResumeNasJobId().equals(other.getResumeNasJobId())) return false;
    if (!getSearchSpaceSpec().equals(other.getSearchSpaceSpec())) return false;
    if (!getNasAlgorithmSpecCase().equals(other.getNasAlgorithmSpecCase())) return false;
    switch (nasAlgorithmSpecCase_) {
      case 2:
        if (!getMultiTrialAlgorithmSpec().equals(other.getMultiTrialAlgorithmSpec())) return false;
        break;
      case 0:
      default:
    }
    if (!getUnknownFields().equals(other.getUnknownFields())) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    hash = (37 * hash) + RESUME_NAS_JOB_ID_FIELD_NUMBER;
    hash = (53 * hash) + getResumeNasJobId().hashCode();
    hash = (37 * hash) + SEARCH_SPACE_SPEC_FIELD_NUMBER;
    hash = (53 * hash) + getSearchSpaceSpec().hashCode();
    switch (nasAlgorithmSpecCase_) {
      case 2:
        hash = (37 * hash) + MULTI_TRIAL_ALGORITHM_SPEC_FIELD_NUMBER;
        hash = (53 * hash) + getMultiTrialAlgorithmSpec().hashCode();
        break;
      case 0:
      default:
    }
    hash = (29 * hash) + getUnknownFields().hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.cloud.aiplatform.v1beta1.NasJobSpec parseFrom(java.nio.ByteBuffer data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.aiplatform.v1beta1.NasJobSpec parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.aiplatform.v1beta1.NasJobSpec parseFrom(
      com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.aiplatform.v1beta1.NasJobSpec parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.aiplatform.v1beta1.NasJobSpec parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.aiplatform.v1beta1.NasJobSpec parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.aiplatform.v1beta1.NasJobSpec parseFrom(java.io.InputStream input)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.aiplatform.v1beta1.NasJobSpec parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.aiplatform.v1beta1.NasJobSpec parseDelimitedFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.cloud.aiplatform.v1beta1.NasJobSpec parseDelimitedFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.aiplatform.v1beta1.NasJobSpec parseFrom(
      com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.aiplatform.v1beta1.NasJobSpec parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(com.google.cloud.aiplatform.v1beta1.NasJobSpec prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }
  /**
   *
   *
   * <pre>
   * Represents the spec of a NasJob.
   * </pre>
   *
   * Protobuf type {@code google.cloud.aiplatform.v1beta1.NasJobSpec}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.cloud.aiplatform.v1beta1.NasJobSpec)
      com.google.cloud.aiplatform.v1beta1.NasJobSpecOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.aiplatform.v1beta1.NasJobProto
          .internal_static_google_cloud_aiplatform_v1beta1_NasJobSpec_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.aiplatform.v1beta1.NasJobProto
          .internal_static_google_cloud_aiplatform_v1beta1_NasJobSpec_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.aiplatform.v1beta1.NasJobSpec.class,
              com.google.cloud.aiplatform.v1beta1.NasJobSpec.Builder.class);
    }

    // Construct using com.google.cloud.aiplatform.v1beta1.NasJobSpec.newBuilder()
    private Builder() {}

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      bitField0_ = 0;
      if (multiTrialAlgorithmSpecBuilder_ != null) {
        multiTrialAlgorithmSpecBuilder_.clear();
      }
      resumeNasJobId_ = "";
      searchSpaceSpec_ = "";
      nasAlgorithmSpecCase_ = 0;
      nasAlgorithmSpec_ = null;
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.cloud.aiplatform.v1beta1.NasJobProto
          .internal_static_google_cloud_aiplatform_v1beta1_NasJobSpec_descriptor;
    }

    @java.lang.Override
    public com.google.cloud.aiplatform.v1beta1.NasJobSpec getDefaultInstanceForType() {
      return com.google.cloud.aiplatform.v1beta1.NasJobSpec.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.cloud.aiplatform.v1beta1.NasJobSpec build() {
      com.google.cloud.aiplatform.v1beta1.NasJobSpec result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.cloud.aiplatform.v1beta1.NasJobSpec buildPartial() {
      com.google.cloud.aiplatform.v1beta1.NasJobSpec result =
          new com.google.cloud.aiplatform.v1beta1.NasJobSpec(this);
      if (bitField0_ != 0) {
        buildPartial0(result);
      }
      buildPartialOneofs(result);
      onBuilt();
      return result;
    }

    private void buildPartial0(com.google.cloud.aiplatform.v1beta1.NasJobSpec result) {
      int from_bitField0_ = bitField0_;
      if (((from_bitField0_ & 0x00000002) != 0)) {
        result.resumeNasJobId_ = resumeNasJobId_;
      }
      if (((from_bitField0_ & 0x00000004) != 0)) {
        result.searchSpaceSpec_ = searchSpaceSpec_;
      }
    }

    private void buildPartialOneofs(com.google.cloud.aiplatform.v1beta1.NasJobSpec result) {
      result.nasAlgorithmSpecCase_ = nasAlgorithmSpecCase_;
      result.nasAlgorithmSpec_ = this.nasAlgorithmSpec_;
      if (nasAlgorithmSpecCase_ == 2 && multiTrialAlgorithmSpecBuilder_ != null) {
        result.nasAlgorithmSpec_ = multiTrialAlgorithmSpecBuilder_.build();
      }
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.cloud.aiplatform.v1beta1.NasJobSpec) {
        return mergeFrom((com.google.cloud.aiplatform.v1beta1.NasJobSpec) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(com.google.cloud.aiplatform.v1beta1.NasJobSpec other) {
      if (other == com.google.cloud.aiplatform.v1beta1.NasJobSpec.getDefaultInstance()) return this;
      if (!other.getResumeNasJobId().isEmpty()) {
        resumeNasJobId_ = other.resumeNasJobId_;
        bitField0_ |= 0x00000002;
        onChanged();
      }
      if (!other.getSearchSpaceSpec().isEmpty()) {
        searchSpaceSpec_ = other.searchSpaceSpec_;
        bitField0_ |= 0x00000004;
        onChanged();
      }
      switch (other.getNasAlgorithmSpecCase()) {
        case MULTI_TRIAL_ALGORITHM_SPEC:
          {
            mergeMultiTrialAlgorithmSpec(other.getMultiTrialAlgorithmSpec());
            break;
          }
        case NASALGORITHMSPEC_NOT_SET:
          {
            break;
          }
      }
      this.mergeUnknownFields(other.getUnknownFields());
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 10:
              {
                searchSpaceSpec_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000004;
                break;
              } // case 10
            case 18:
              {
                input.readMessage(
                    getMultiTrialAlgorithmSpecFieldBuilder().getBuilder(), extensionRegistry);
                nasAlgorithmSpecCase_ = 2;
                break;
              } // case 18
            case 26:
              {
                resumeNasJobId_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000002;
                break;
              } // case 26
            default:
              {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
          } // switch (tag)
        } // while (!done)
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.unwrapIOException();
      } finally {
        onChanged();
      } // finally
      return this;
    }

    private int nasAlgorithmSpecCase_ = 0;
    private java.lang.Object nasAlgorithmSpec_;

    public NasAlgorithmSpecCase getNasAlgorithmSpecCase() {
      return NasAlgorithmSpecCase.forNumber(nasAlgorithmSpecCase_);
    }

    public Builder clearNasAlgorithmSpec() {
      nasAlgorithmSpecCase_ = 0;
      nasAlgorithmSpec_ = null;
      onChanged();
      return this;
    }

    private int bitField0_;

    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.aiplatform.v1beta1.NasJobSpec.MultiTrialAlgorithmSpec,
            com.google.cloud.aiplatform.v1beta1.NasJobSpec.MultiTrialAlgorithmSpec.Builder,
            com.google.cloud.aiplatform.v1beta1.NasJobSpec.MultiTrialAlgorithmSpecOrBuilder>
        multiTrialAlgorithmSpecBuilder_;
    /**
     *
     *
     * <pre>
     * The spec of multi-trial algorithms.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.NasJobSpec.MultiTrialAlgorithmSpec multi_trial_algorithm_spec = 2;
     * </code>
     *
     * @return Whether the multiTrialAlgorithmSpec field is set.
     */
    @java.lang.Override
    public boolean hasMultiTrialAlgorithmSpec() {
      return nasAlgorithmSpecCase_ == 2;
    }
    /**
     *
     *
     * <pre>
     * The spec of multi-trial algorithms.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.NasJobSpec.MultiTrialAlgorithmSpec multi_trial_algorithm_spec = 2;
     * </code>
     *
     * @return The multiTrialAlgorithmSpec.
     */
    @java.lang.Override
    public com.google.cloud.aiplatform.v1beta1.NasJobSpec.MultiTrialAlgorithmSpec
        getMultiTrialAlgorithmSpec() {
      if (multiTrialAlgorithmSpecBuilder_ == null) {
        if (nasAlgorithmSpecCase_ == 2) {
          return (com.google.cloud.aiplatform.v1beta1.NasJobSpec.MultiTrialAlgorithmSpec)
              nasAlgorithmSpec_;
        }
        return com.google.cloud.aiplatform.v1beta1.NasJobSpec.MultiTrialAlgorithmSpec
            .getDefaultInstance();
      } else {
        if (nasAlgorithmSpecCase_ == 2) {
          return multiTrialAlgorithmSpecBuilder_.getMessage();
        }
        return com.google.cloud.aiplatform.v1beta1.NasJobSpec.MultiTrialAlgorithmSpec
            .getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * The spec of multi-trial algorithms.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.NasJobSpec.MultiTrialAlgorithmSpec multi_trial_algorithm_spec = 2;
     * </code>
     */
    public Builder setMultiTrialAlgorithmSpec(
        com.google.cloud.aiplatform.v1beta1.NasJobSpec.MultiTrialAlgorithmSpec value) {
      if (multiTrialAlgorithmSpecBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        nasAlgorithmSpec_ = value;
        onChanged();
      } else {
        multiTrialAlgorithmSpecBuilder_.setMessage(value);
      }
      nasAlgorithmSpecCase_ = 2;
      return this;
    }
    /**
     *
     *
     * <pre>
     * The spec of multi-trial algorithms.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.NasJobSpec.MultiTrialAlgorithmSpec multi_trial_algorithm_spec = 2;
     * </code>
     */
    public Builder setMultiTrialAlgorithmSpec(
        com.google.cloud.aiplatform.v1beta1.NasJobSpec.MultiTrialAlgorithmSpec.Builder
            builderForValue) {
      if (multiTrialAlgorithmSpecBuilder_ == null) {
        nasAlgorithmSpec_ = builderForValue.build();
        onChanged();
      } else {
        multiTrialAlgorithmSpecBuilder_.setMessage(builderForValue.build());
      }
      nasAlgorithmSpecCase_ = 2;
      return this;
    }
    /**
     *
     *
     * <pre>
     * The spec of multi-trial algorithms.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.NasJobSpec.MultiTrialAlgorithmSpec multi_trial_algorithm_spec = 2;
     * </code>
     */
    public Builder mergeMultiTrialAlgorithmSpec(
        com.google.cloud.aiplatform.v1beta1.NasJobSpec.MultiTrialAlgorithmSpec value) {
      if (multiTrialAlgorithmSpecBuilder_ == null) {
        if (nasAlgorithmSpecCase_ == 2
            && nasAlgorithmSpec_
                != com.google.cloud.aiplatform.v1beta1.NasJobSpec.MultiTrialAlgorithmSpec
                    .getDefaultInstance()) {
          nasAlgorithmSpec_ =
              com.google.cloud.aiplatform.v1beta1.NasJobSpec.MultiTrialAlgorithmSpec.newBuilder(
                      (com.google.cloud.aiplatform.v1beta1.NasJobSpec.MultiTrialAlgorithmSpec)
                          nasAlgorithmSpec_)
                  .mergeFrom(value)
                  .buildPartial();
        } else {
          nasAlgorithmSpec_ = value;
        }
        onChanged();
      } else {
        if (nasAlgorithmSpecCase_ == 2) {
          multiTrialAlgorithmSpecBuilder_.mergeFrom(value);
        } else {
          multiTrialAlgorithmSpecBuilder_.setMessage(value);
        }
      }
      nasAlgorithmSpecCase_ = 2;
      return this;
    }
    /**
     *
     *
     * <pre>
     * The spec of multi-trial algorithms.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.NasJobSpec.MultiTrialAlgorithmSpec multi_trial_algorithm_spec = 2;
     * </code>
     */
    public Builder clearMultiTrialAlgorithmSpec() {
      if (multiTrialAlgorithmSpecBuilder_ == null) {
        if (nasAlgorithmSpecCase_ == 2) {
          nasAlgorithmSpecCase_ = 0;
          nasAlgorithmSpec_ = null;
          onChanged();
        }
      } else {
        if (nasAlgorithmSpecCase_ == 2) {
          nasAlgorithmSpecCase_ = 0;
          nasAlgorithmSpec_ = null;
        }
        multiTrialAlgorithmSpecBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * The spec of multi-trial algorithms.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.NasJobSpec.MultiTrialAlgorithmSpec multi_trial_algorithm_spec = 2;
     * </code>
     */
    public com.google.cloud.aiplatform.v1beta1.NasJobSpec.MultiTrialAlgorithmSpec.Builder
        getMultiTrialAlgorithmSpecBuilder() {
      return getMultiTrialAlgorithmSpecFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * The spec of multi-trial algorithms.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.NasJobSpec.MultiTrialAlgorithmSpec multi_trial_algorithm_spec = 2;
     * </code>
     */
    @java.lang.Override
    public com.google.cloud.aiplatform.v1beta1.NasJobSpec.MultiTrialAlgorithmSpecOrBuilder
        getMultiTrialAlgorithmSpecOrBuilder() {
      if ((nasAlgorithmSpecCase_ == 2) && (multiTrialAlgorithmSpecBuilder_ != null)) {
        return multiTrialAlgorithmSpecBuilder_.getMessageOrBuilder();
      } else {
        if (nasAlgorithmSpecCase_ == 2) {
          return (com.google.cloud.aiplatform.v1beta1.NasJobSpec.MultiTrialAlgorithmSpec)
              nasAlgorithmSpec_;
        }
        return com.google.cloud.aiplatform.v1beta1.NasJobSpec.MultiTrialAlgorithmSpec
            .getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * The spec of multi-trial algorithms.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.NasJobSpec.MultiTrialAlgorithmSpec multi_trial_algorithm_spec = 2;
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.aiplatform.v1beta1.NasJobSpec.MultiTrialAlgorithmSpec,
            com.google.cloud.aiplatform.v1beta1.NasJobSpec.MultiTrialAlgorithmSpec.Builder,
            com.google.cloud.aiplatform.v1beta1.NasJobSpec.MultiTrialAlgorithmSpecOrBuilder>
        getMultiTrialAlgorithmSpecFieldBuilder() {
      if (multiTrialAlgorithmSpecBuilder_ == null) {
        if (!(nasAlgorithmSpecCase_ == 2)) {
          nasAlgorithmSpec_ =
              com.google.cloud.aiplatform.v1beta1.NasJobSpec.MultiTrialAlgorithmSpec
                  .getDefaultInstance();
        }
        multiTrialAlgorithmSpecBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.aiplatform.v1beta1.NasJobSpec.MultiTrialAlgorithmSpec,
                com.google.cloud.aiplatform.v1beta1.NasJobSpec.MultiTrialAlgorithmSpec.Builder,
                com.google.cloud.aiplatform.v1beta1.NasJobSpec.MultiTrialAlgorithmSpecOrBuilder>(
                (com.google.cloud.aiplatform.v1beta1.NasJobSpec.MultiTrialAlgorithmSpec)
                    nasAlgorithmSpec_,
                getParentForChildren(),
                isClean());
        nasAlgorithmSpec_ = null;
      }
      nasAlgorithmSpecCase_ = 2;
      onChanged();
      return multiTrialAlgorithmSpecBuilder_;
    }

    private java.lang.Object resumeNasJobId_ = "";
    /**
     *
     *
     * <pre>
     * The ID of the existing NasJob in the same Project and Location
     * which will be used to resume search. search_space_spec and
     * nas_algorithm_spec are obtained from previous NasJob hence should not
     * provide them again for this NasJob.
     * </pre>
     *
     * <code>string resume_nas_job_id = 3;</code>
     *
     * @return The resumeNasJobId.
     */
    public java.lang.String getResumeNasJobId() {
      java.lang.Object ref = resumeNasJobId_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        resumeNasJobId_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * The ID of the existing NasJob in the same Project and Location
     * which will be used to resume search. search_space_spec and
     * nas_algorithm_spec are obtained from previous NasJob hence should not
     * provide them again for this NasJob.
     * </pre>
     *
     * <code>string resume_nas_job_id = 3;</code>
     *
     * @return The bytes for resumeNasJobId.
     */
    public com.google.protobuf.ByteString getResumeNasJobIdBytes() {
      java.lang.Object ref = resumeNasJobId_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        resumeNasJobId_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * The ID of the existing NasJob in the same Project and Location
     * which will be used to resume search. search_space_spec and
     * nas_algorithm_spec are obtained from previous NasJob hence should not
     * provide them again for this NasJob.
     * </pre>
     *
     * <code>string resume_nas_job_id = 3;</code>
     *
     * @param value The resumeNasJobId to set.
     * @return This builder for chaining.
     */
    public Builder setResumeNasJobId(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      resumeNasJobId_ = value;
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The ID of the existing NasJob in the same Project and Location
     * which will be used to resume search. search_space_spec and
     * nas_algorithm_spec are obtained from previous NasJob hence should not
     * provide them again for this NasJob.
     * </pre>
     *
     * <code>string resume_nas_job_id = 3;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearResumeNasJobId() {
      resumeNasJobId_ = getDefaultInstance().getResumeNasJobId();
      bitField0_ = (bitField0_ & ~0x00000002);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The ID of the existing NasJob in the same Project and Location
     * which will be used to resume search. search_space_spec and
     * nas_algorithm_spec are obtained from previous NasJob hence should not
     * provide them again for this NasJob.
     * </pre>
     *
     * <code>string resume_nas_job_id = 3;</code>
     *
     * @param value The bytes for resumeNasJobId to set.
     * @return This builder for chaining.
     */
    public Builder setResumeNasJobIdBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      resumeNasJobId_ = value;
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }

    private java.lang.Object searchSpaceSpec_ = "";
    /**
     *
     *
     * <pre>
     * It defines the search space for Neural Architecture Search (NAS).
     * </pre>
     *
     * <code>string search_space_spec = 1;</code>
     *
     * @return The searchSpaceSpec.
     */
    public java.lang.String getSearchSpaceSpec() {
      java.lang.Object ref = searchSpaceSpec_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        searchSpaceSpec_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * It defines the search space for Neural Architecture Search (NAS).
     * </pre>
     *
     * <code>string search_space_spec = 1;</code>
     *
     * @return The bytes for searchSpaceSpec.
     */
    public com.google.protobuf.ByteString getSearchSpaceSpecBytes() {
      java.lang.Object ref = searchSpaceSpec_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        searchSpaceSpec_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * It defines the search space for Neural Architecture Search (NAS).
     * </pre>
     *
     * <code>string search_space_spec = 1;</code>
     *
     * @param value The searchSpaceSpec to set.
     * @return This builder for chaining.
     */
    public Builder setSearchSpaceSpec(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      searchSpaceSpec_ = value;
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * It defines the search space for Neural Architecture Search (NAS).
     * </pre>
     *
     * <code>string search_space_spec = 1;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearSearchSpaceSpec() {
      searchSpaceSpec_ = getDefaultInstance().getSearchSpaceSpec();
      bitField0_ = (bitField0_ & ~0x00000004);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * It defines the search space for Neural Architecture Search (NAS).
     * </pre>
     *
     * <code>string search_space_spec = 1;</code>
     *
     * @param value The bytes for searchSpaceSpec to set.
     * @return This builder for chaining.
     */
    public Builder setSearchSpaceSpecBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      searchSpaceSpec_ = value;
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.cloud.aiplatform.v1beta1.NasJobSpec)
  }

  // @@protoc_insertion_point(class_scope:google.cloud.aiplatform.v1beta1.NasJobSpec)
  private static final com.google.cloud.aiplatform.v1beta1.NasJobSpec DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.cloud.aiplatform.v1beta1.NasJobSpec();
  }

  public static com.google.cloud.aiplatform.v1beta1.NasJobSpec getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<NasJobSpec> PARSER =
      new com.google.protobuf.AbstractParser<NasJobSpec>() {
        @java.lang.Override
        public NasJobSpec parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          Builder builder = newBuilder();
          try {
            builder.mergeFrom(input, extensionRegistry);
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.setUnfinishedMessage(builder.buildPartial());
          } catch (com.google.protobuf.UninitializedMessageException e) {
            throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
          } catch (java.io.IOException e) {
            throw new com.google.protobuf.InvalidProtocolBufferException(e)
                .setUnfinishedMessage(builder.buildPartial());
          }
          return builder.buildPartial();
        }
      };

  public static com.google.protobuf.Parser<NasJobSpec> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<NasJobSpec> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.cloud.aiplatform.v1beta1.NasJobSpec getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
