/*
 * Copyright 2024 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/cloud/aiplatform/v1beta1/feature_online_store.proto

// Protobuf Java Version: 3.25.2
package com.google.cloud.aiplatform.v1beta1;

/**
 *
 *
 * <pre>
 * Vertex AI Feature Online Store provides a centralized repository for serving
 * ML features and embedding indexes at low latency. The Feature Online Store is
 * a top-level container.
 * </pre>
 *
 * Protobuf type {@code google.cloud.aiplatform.v1beta1.FeatureOnlineStore}
 */
public final class FeatureOnlineStore extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.cloud.aiplatform.v1beta1.FeatureOnlineStore)
    FeatureOnlineStoreOrBuilder {
  private static final long serialVersionUID = 0L;
  // Use FeatureOnlineStore.newBuilder() to construct.
  private FeatureOnlineStore(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private FeatureOnlineStore() {
    name_ = "";
    etag_ = "";
    state_ = 0;
  }

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new FeatureOnlineStore();
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.cloud.aiplatform.v1beta1.FeatureOnlineStoreProto
        .internal_static_google_cloud_aiplatform_v1beta1_FeatureOnlineStore_descriptor;
  }

  @SuppressWarnings({"rawtypes"})
  @java.lang.Override
  protected com.google.protobuf.MapFieldReflectionAccessor internalGetMapFieldReflection(
      int number) {
    switch (number) {
      case 6:
        return internalGetLabels();
      default:
        throw new RuntimeException("Invalid map field number: " + number);
    }
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.cloud.aiplatform.v1beta1.FeatureOnlineStoreProto
        .internal_static_google_cloud_aiplatform_v1beta1_FeatureOnlineStore_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.cloud.aiplatform.v1beta1.FeatureOnlineStore.class,
            com.google.cloud.aiplatform.v1beta1.FeatureOnlineStore.Builder.class);
  }

  /**
   *
   *
   * <pre>
   * Possible states a featureOnlineStore can have.
   * </pre>
   *
   * Protobuf enum {@code google.cloud.aiplatform.v1beta1.FeatureOnlineStore.State}
   */
  public enum State implements com.google.protobuf.ProtocolMessageEnum {
    /**
     *
     *
     * <pre>
     * Default value. This value is unused.
     * </pre>
     *
     * <code>STATE_UNSPECIFIED = 0;</code>
     */
    STATE_UNSPECIFIED(0),
    /**
     *
     *
     * <pre>
     * State when the featureOnlineStore configuration is not being updated and
     * the fields reflect the current configuration of the featureOnlineStore.
     * The featureOnlineStore is usable in this state.
     * </pre>
     *
     * <code>STABLE = 1;</code>
     */
    STABLE(1),
    /**
     *
     *
     * <pre>
     * The state of the featureOnlineStore configuration when it is being
     * updated. During an update, the fields reflect either the original
     * configuration or the updated configuration of the featureOnlineStore. The
     * featureOnlineStore is still usable in this state.
     * </pre>
     *
     * <code>UPDATING = 2;</code>
     */
    UPDATING(2),
    UNRECOGNIZED(-1),
    ;

    /**
     *
     *
     * <pre>
     * Default value. This value is unused.
     * </pre>
     *
     * <code>STATE_UNSPECIFIED = 0;</code>
     */
    public static final int STATE_UNSPECIFIED_VALUE = 0;
    /**
     *
     *
     * <pre>
     * State when the featureOnlineStore configuration is not being updated and
     * the fields reflect the current configuration of the featureOnlineStore.
     * The featureOnlineStore is usable in this state.
     * </pre>
     *
     * <code>STABLE = 1;</code>
     */
    public static final int STABLE_VALUE = 1;
    /**
     *
     *
     * <pre>
     * The state of the featureOnlineStore configuration when it is being
     * updated. During an update, the fields reflect either the original
     * configuration or the updated configuration of the featureOnlineStore. The
     * featureOnlineStore is still usable in this state.
     * </pre>
     *
     * <code>UPDATING = 2;</code>
     */
    public static final int UPDATING_VALUE = 2;

    public final int getNumber() {
      if (this == UNRECOGNIZED) {
        throw new java.lang.IllegalArgumentException(
            "Can't get the number of an unknown enum value.");
      }
      return value;
    }

    /**
     * @param value The numeric wire value of the corresponding enum entry.
     * @return The enum associated with the given numeric wire value.
     * @deprecated Use {@link #forNumber(int)} instead.
     */
    @java.lang.Deprecated
    public static State valueOf(int value) {
      return forNumber(value);
    }

    /**
     * @param value The numeric wire value of the corresponding enum entry.
     * @return The enum associated with the given numeric wire value.
     */
    public static State forNumber(int value) {
      switch (value) {
        case 0:
          return STATE_UNSPECIFIED;
        case 1:
          return STABLE;
        case 2:
          return UPDATING;
        default:
          return null;
      }
    }

    public static com.google.protobuf.Internal.EnumLiteMap<State> internalGetValueMap() {
      return internalValueMap;
    }

    private static final com.google.protobuf.Internal.EnumLiteMap<State> internalValueMap =
        new com.google.protobuf.Internal.EnumLiteMap<State>() {
          public State findValueByNumber(int number) {
            return State.forNumber(number);
          }
        };

    public final com.google.protobuf.Descriptors.EnumValueDescriptor getValueDescriptor() {
      if (this == UNRECOGNIZED) {
        throw new java.lang.IllegalStateException(
            "Can't get the descriptor of an unrecognized enum value.");
      }
      return getDescriptor().getValues().get(ordinal());
    }

    public final com.google.protobuf.Descriptors.EnumDescriptor getDescriptorForType() {
      return getDescriptor();
    }

    public static final com.google.protobuf.Descriptors.EnumDescriptor getDescriptor() {
      return com.google.cloud.aiplatform.v1beta1.FeatureOnlineStore.getDescriptor()
          .getEnumTypes()
          .get(0);
    }

    private static final State[] VALUES = values();

    public static State valueOf(com.google.protobuf.Descriptors.EnumValueDescriptor desc) {
      if (desc.getType() != getDescriptor()) {
        throw new java.lang.IllegalArgumentException("EnumValueDescriptor is not for this type.");
      }
      if (desc.getIndex() == -1) {
        return UNRECOGNIZED;
      }
      return VALUES[desc.getIndex()];
    }

    private final int value;

    private State(int value) {
      this.value = value;
    }

    // @@protoc_insertion_point(enum_scope:google.cloud.aiplatform.v1beta1.FeatureOnlineStore.State)
  }

  public interface BigtableOrBuilder
      extends
      // @@protoc_insertion_point(interface_extends:google.cloud.aiplatform.v1beta1.FeatureOnlineStore.Bigtable)
      com.google.protobuf.MessageOrBuilder {

    /**
     *
     *
     * <pre>
     * Required. Autoscaling config applied to Bigtable Instance.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.FeatureOnlineStore.Bigtable.AutoScaling auto_scaling = 1 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     *
     * @return Whether the autoScaling field is set.
     */
    boolean hasAutoScaling();
    /**
     *
     *
     * <pre>
     * Required. Autoscaling config applied to Bigtable Instance.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.FeatureOnlineStore.Bigtable.AutoScaling auto_scaling = 1 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     *
     * @return The autoScaling.
     */
    com.google.cloud.aiplatform.v1beta1.FeatureOnlineStore.Bigtable.AutoScaling getAutoScaling();
    /**
     *
     *
     * <pre>
     * Required. Autoscaling config applied to Bigtable Instance.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.FeatureOnlineStore.Bigtable.AutoScaling auto_scaling = 1 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    com.google.cloud.aiplatform.v1beta1.FeatureOnlineStore.Bigtable.AutoScalingOrBuilder
        getAutoScalingOrBuilder();
  }
  /** Protobuf type {@code google.cloud.aiplatform.v1beta1.FeatureOnlineStore.Bigtable} */
  public static final class Bigtable extends com.google.protobuf.GeneratedMessageV3
      implements
      // @@protoc_insertion_point(message_implements:google.cloud.aiplatform.v1beta1.FeatureOnlineStore.Bigtable)
      BigtableOrBuilder {
    private static final long serialVersionUID = 0L;
    // Use Bigtable.newBuilder() to construct.
    private Bigtable(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
      super(builder);
    }

    private Bigtable() {}

    @java.lang.Override
    @SuppressWarnings({"unused"})
    protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
      return new Bigtable();
    }

    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.aiplatform.v1beta1.FeatureOnlineStoreProto
          .internal_static_google_cloud_aiplatform_v1beta1_FeatureOnlineStore_Bigtable_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.aiplatform.v1beta1.FeatureOnlineStoreProto
          .internal_static_google_cloud_aiplatform_v1beta1_FeatureOnlineStore_Bigtable_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.aiplatform.v1beta1.FeatureOnlineStore.Bigtable.class,
              com.google.cloud.aiplatform.v1beta1.FeatureOnlineStore.Bigtable.Builder.class);
    }

    public interface AutoScalingOrBuilder
        extends
        // @@protoc_insertion_point(interface_extends:google.cloud.aiplatform.v1beta1.FeatureOnlineStore.Bigtable.AutoScaling)
        com.google.protobuf.MessageOrBuilder {

      /**
       *
       *
       * <pre>
       * Required. The minimum number of nodes to scale down to. Must be greater
       * than or equal to 1.
       * </pre>
       *
       * <code>int32 min_node_count = 1 [(.google.api.field_behavior) = REQUIRED];</code>
       *
       * @return The minNodeCount.
       */
      int getMinNodeCount();

      /**
       *
       *
       * <pre>
       * Required. The maximum number of nodes to scale up to. Must be greater
       * than or equal to min_node_count, and less than or equal to 10 times of
       * 'min_node_count'.
       * </pre>
       *
       * <code>int32 max_node_count = 2 [(.google.api.field_behavior) = REQUIRED];</code>
       *
       * @return The maxNodeCount.
       */
      int getMaxNodeCount();

      /**
       *
       *
       * <pre>
       * Optional. A percentage of the cluster's CPU capacity. Can be from 10%
       * to 80%. When a cluster's CPU utilization exceeds the target that you
       * have set, Bigtable immediately adds nodes to the cluster. When CPU
       * utilization is substantially lower than the target, Bigtable removes
       * nodes. If not set will default to 50%.
       * </pre>
       *
       * <code>int32 cpu_utilization_target = 3 [(.google.api.field_behavior) = OPTIONAL];</code>
       *
       * @return The cpuUtilizationTarget.
       */
      int getCpuUtilizationTarget();
    }
    /**
     * Protobuf type {@code google.cloud.aiplatform.v1beta1.FeatureOnlineStore.Bigtable.AutoScaling}
     */
    public static final class AutoScaling extends com.google.protobuf.GeneratedMessageV3
        implements
        // @@protoc_insertion_point(message_implements:google.cloud.aiplatform.v1beta1.FeatureOnlineStore.Bigtable.AutoScaling)
        AutoScalingOrBuilder {
      private static final long serialVersionUID = 0L;
      // Use AutoScaling.newBuilder() to construct.
      private AutoScaling(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
        super(builder);
      }

      private AutoScaling() {}

      @java.lang.Override
      @SuppressWarnings({"unused"})
      protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
        return new AutoScaling();
      }

      public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
        return com.google.cloud.aiplatform.v1beta1.FeatureOnlineStoreProto
            .internal_static_google_cloud_aiplatform_v1beta1_FeatureOnlineStore_Bigtable_AutoScaling_descriptor;
      }

      @java.lang.Override
      protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return com.google.cloud.aiplatform.v1beta1.FeatureOnlineStoreProto
            .internal_static_google_cloud_aiplatform_v1beta1_FeatureOnlineStore_Bigtable_AutoScaling_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                com.google.cloud.aiplatform.v1beta1.FeatureOnlineStore.Bigtable.AutoScaling.class,
                com.google.cloud.aiplatform.v1beta1.FeatureOnlineStore.Bigtable.AutoScaling.Builder
                    .class);
      }

      public static final int MIN_NODE_COUNT_FIELD_NUMBER = 1;
      private int minNodeCount_ = 0;
      /**
       *
       *
       * <pre>
       * Required. The minimum number of nodes to scale down to. Must be greater
       * than or equal to 1.
       * </pre>
       *
       * <code>int32 min_node_count = 1 [(.google.api.field_behavior) = REQUIRED];</code>
       *
       * @return The minNodeCount.
       */
      @java.lang.Override
      public int getMinNodeCount() {
        return minNodeCount_;
      }

      public static final int MAX_NODE_COUNT_FIELD_NUMBER = 2;
      private int maxNodeCount_ = 0;
      /**
       *
       *
       * <pre>
       * Required. The maximum number of nodes to scale up to. Must be greater
       * than or equal to min_node_count, and less than or equal to 10 times of
       * 'min_node_count'.
       * </pre>
       *
       * <code>int32 max_node_count = 2 [(.google.api.field_behavior) = REQUIRED];</code>
       *
       * @return The maxNodeCount.
       */
      @java.lang.Override
      public int getMaxNodeCount() {
        return maxNodeCount_;
      }

      public static final int CPU_UTILIZATION_TARGET_FIELD_NUMBER = 3;
      private int cpuUtilizationTarget_ = 0;
      /**
       *
       *
       * <pre>
       * Optional. A percentage of the cluster's CPU capacity. Can be from 10%
       * to 80%. When a cluster's CPU utilization exceeds the target that you
       * have set, Bigtable immediately adds nodes to the cluster. When CPU
       * utilization is substantially lower than the target, Bigtable removes
       * nodes. If not set will default to 50%.
       * </pre>
       *
       * <code>int32 cpu_utilization_target = 3 [(.google.api.field_behavior) = OPTIONAL];</code>
       *
       * @return The cpuUtilizationTarget.
       */
      @java.lang.Override
      public int getCpuUtilizationTarget() {
        return cpuUtilizationTarget_;
      }

      private byte memoizedIsInitialized = -1;

      @java.lang.Override
      public final boolean isInitialized() {
        byte isInitialized = memoizedIsInitialized;
        if (isInitialized == 1) return true;
        if (isInitialized == 0) return false;

        memoizedIsInitialized = 1;
        return true;
      }

      @java.lang.Override
      public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
        if (minNodeCount_ != 0) {
          output.writeInt32(1, minNodeCount_);
        }
        if (maxNodeCount_ != 0) {
          output.writeInt32(2, maxNodeCount_);
        }
        if (cpuUtilizationTarget_ != 0) {
          output.writeInt32(3, cpuUtilizationTarget_);
        }
        getUnknownFields().writeTo(output);
      }

      @java.lang.Override
      public int getSerializedSize() {
        int size = memoizedSize;
        if (size != -1) return size;

        size = 0;
        if (minNodeCount_ != 0) {
          size += com.google.protobuf.CodedOutputStream.computeInt32Size(1, minNodeCount_);
        }
        if (maxNodeCount_ != 0) {
          size += com.google.protobuf.CodedOutputStream.computeInt32Size(2, maxNodeCount_);
        }
        if (cpuUtilizationTarget_ != 0) {
          size += com.google.protobuf.CodedOutputStream.computeInt32Size(3, cpuUtilizationTarget_);
        }
        size += getUnknownFields().getSerializedSize();
        memoizedSize = size;
        return size;
      }

      @java.lang.Override
      public boolean equals(final java.lang.Object obj) {
        if (obj == this) {
          return true;
        }
        if (!(obj
            instanceof
            com.google.cloud.aiplatform.v1beta1.FeatureOnlineStore.Bigtable.AutoScaling)) {
          return super.equals(obj);
        }
        com.google.cloud.aiplatform.v1beta1.FeatureOnlineStore.Bigtable.AutoScaling other =
            (com.google.cloud.aiplatform.v1beta1.FeatureOnlineStore.Bigtable.AutoScaling) obj;

        if (getMinNodeCount() != other.getMinNodeCount()) return false;
        if (getMaxNodeCount() != other.getMaxNodeCount()) return false;
        if (getCpuUtilizationTarget() != other.getCpuUtilizationTarget()) return false;
        if (!getUnknownFields().equals(other.getUnknownFields())) return false;
        return true;
      }

      @java.lang.Override
      public int hashCode() {
        if (memoizedHashCode != 0) {
          return memoizedHashCode;
        }
        int hash = 41;
        hash = (19 * hash) + getDescriptor().hashCode();
        hash = (37 * hash) + MIN_NODE_COUNT_FIELD_NUMBER;
        hash = (53 * hash) + getMinNodeCount();
        hash = (37 * hash) + MAX_NODE_COUNT_FIELD_NUMBER;
        hash = (53 * hash) + getMaxNodeCount();
        hash = (37 * hash) + CPU_UTILIZATION_TARGET_FIELD_NUMBER;
        hash = (53 * hash) + getCpuUtilizationTarget();
        hash = (29 * hash) + getUnknownFields().hashCode();
        memoizedHashCode = hash;
        return hash;
      }

      public static com.google.cloud.aiplatform.v1beta1.FeatureOnlineStore.Bigtable.AutoScaling
          parseFrom(java.nio.ByteBuffer data)
              throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data);
      }

      public static com.google.cloud.aiplatform.v1beta1.FeatureOnlineStore.Bigtable.AutoScaling
          parseFrom(
              java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data, extensionRegistry);
      }

      public static com.google.cloud.aiplatform.v1beta1.FeatureOnlineStore.Bigtable.AutoScaling
          parseFrom(com.google.protobuf.ByteString data)
              throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data);
      }

      public static com.google.cloud.aiplatform.v1beta1.FeatureOnlineStore.Bigtable.AutoScaling
          parseFrom(
              com.google.protobuf.ByteString data,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data, extensionRegistry);
      }

      public static com.google.cloud.aiplatform.v1beta1.FeatureOnlineStore.Bigtable.AutoScaling
          parseFrom(byte[] data) throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data);
      }

      public static com.google.cloud.aiplatform.v1beta1.FeatureOnlineStore.Bigtable.AutoScaling
          parseFrom(byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data, extensionRegistry);
      }

      public static com.google.cloud.aiplatform.v1beta1.FeatureOnlineStore.Bigtable.AutoScaling
          parseFrom(java.io.InputStream input) throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
      }

      public static com.google.cloud.aiplatform.v1beta1.FeatureOnlineStore.Bigtable.AutoScaling
          parseFrom(
              java.io.InputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
            PARSER, input, extensionRegistry);
      }

      public static com.google.cloud.aiplatform.v1beta1.FeatureOnlineStore.Bigtable.AutoScaling
          parseDelimitedFrom(java.io.InputStream input) throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
      }

      public static com.google.cloud.aiplatform.v1beta1.FeatureOnlineStore.Bigtable.AutoScaling
          parseDelimitedFrom(
              java.io.InputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
            PARSER, input, extensionRegistry);
      }

      public static com.google.cloud.aiplatform.v1beta1.FeatureOnlineStore.Bigtable.AutoScaling
          parseFrom(com.google.protobuf.CodedInputStream input) throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
      }

      public static com.google.cloud.aiplatform.v1beta1.FeatureOnlineStore.Bigtable.AutoScaling
          parseFrom(
              com.google.protobuf.CodedInputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
            PARSER, input, extensionRegistry);
      }

      @java.lang.Override
      public Builder newBuilderForType() {
        return newBuilder();
      }

      public static Builder newBuilder() {
        return DEFAULT_INSTANCE.toBuilder();
      }

      public static Builder newBuilder(
          com.google.cloud.aiplatform.v1beta1.FeatureOnlineStore.Bigtable.AutoScaling prototype) {
        return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
      }

      @java.lang.Override
      public Builder toBuilder() {
        return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
      }

      @java.lang.Override
      protected Builder newBuilderForType(
          com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
        Builder builder = new Builder(parent);
        return builder;
      }
      /**
       * Protobuf type {@code
       * google.cloud.aiplatform.v1beta1.FeatureOnlineStore.Bigtable.AutoScaling}
       */
      public static final class Builder
          extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
          implements
          // @@protoc_insertion_point(builder_implements:google.cloud.aiplatform.v1beta1.FeatureOnlineStore.Bigtable.AutoScaling)
          com.google.cloud.aiplatform.v1beta1.FeatureOnlineStore.Bigtable.AutoScalingOrBuilder {
        public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
          return com.google.cloud.aiplatform.v1beta1.FeatureOnlineStoreProto
              .internal_static_google_cloud_aiplatform_v1beta1_FeatureOnlineStore_Bigtable_AutoScaling_descriptor;
        }

        @java.lang.Override
        protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
            internalGetFieldAccessorTable() {
          return com.google.cloud.aiplatform.v1beta1.FeatureOnlineStoreProto
              .internal_static_google_cloud_aiplatform_v1beta1_FeatureOnlineStore_Bigtable_AutoScaling_fieldAccessorTable
              .ensureFieldAccessorsInitialized(
                  com.google.cloud.aiplatform.v1beta1.FeatureOnlineStore.Bigtable.AutoScaling.class,
                  com.google.cloud.aiplatform.v1beta1.FeatureOnlineStore.Bigtable.AutoScaling
                      .Builder.class);
        }

        // Construct using
        // com.google.cloud.aiplatform.v1beta1.FeatureOnlineStore.Bigtable.AutoScaling.newBuilder()
        private Builder() {}

        private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
          super(parent);
        }

        @java.lang.Override
        public Builder clear() {
          super.clear();
          bitField0_ = 0;
          minNodeCount_ = 0;
          maxNodeCount_ = 0;
          cpuUtilizationTarget_ = 0;
          return this;
        }

        @java.lang.Override
        public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
          return com.google.cloud.aiplatform.v1beta1.FeatureOnlineStoreProto
              .internal_static_google_cloud_aiplatform_v1beta1_FeatureOnlineStore_Bigtable_AutoScaling_descriptor;
        }

        @java.lang.Override
        public com.google.cloud.aiplatform.v1beta1.FeatureOnlineStore.Bigtable.AutoScaling
            getDefaultInstanceForType() {
          return com.google.cloud.aiplatform.v1beta1.FeatureOnlineStore.Bigtable.AutoScaling
              .getDefaultInstance();
        }

        @java.lang.Override
        public com.google.cloud.aiplatform.v1beta1.FeatureOnlineStore.Bigtable.AutoScaling build() {
          com.google.cloud.aiplatform.v1beta1.FeatureOnlineStore.Bigtable.AutoScaling result =
              buildPartial();
          if (!result.isInitialized()) {
            throw newUninitializedMessageException(result);
          }
          return result;
        }

        @java.lang.Override
        public com.google.cloud.aiplatform.v1beta1.FeatureOnlineStore.Bigtable.AutoScaling
            buildPartial() {
          com.google.cloud.aiplatform.v1beta1.FeatureOnlineStore.Bigtable.AutoScaling result =
              new com.google.cloud.aiplatform.v1beta1.FeatureOnlineStore.Bigtable.AutoScaling(this);
          if (bitField0_ != 0) {
            buildPartial0(result);
          }
          onBuilt();
          return result;
        }

        private void buildPartial0(
            com.google.cloud.aiplatform.v1beta1.FeatureOnlineStore.Bigtable.AutoScaling result) {
          int from_bitField0_ = bitField0_;
          if (((from_bitField0_ & 0x00000001) != 0)) {
            result.minNodeCount_ = minNodeCount_;
          }
          if (((from_bitField0_ & 0x00000002) != 0)) {
            result.maxNodeCount_ = maxNodeCount_;
          }
          if (((from_bitField0_ & 0x00000004) != 0)) {
            result.cpuUtilizationTarget_ = cpuUtilizationTarget_;
          }
        }

        @java.lang.Override
        public Builder clone() {
          return super.clone();
        }

        @java.lang.Override
        public Builder setField(
            com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
          return super.setField(field, value);
        }

        @java.lang.Override
        public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
          return super.clearField(field);
        }

        @java.lang.Override
        public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
          return super.clearOneof(oneof);
        }

        @java.lang.Override
        public Builder setRepeatedField(
            com.google.protobuf.Descriptors.FieldDescriptor field,
            int index,
            java.lang.Object value) {
          return super.setRepeatedField(field, index, value);
        }

        @java.lang.Override
        public Builder addRepeatedField(
            com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
          return super.addRepeatedField(field, value);
        }

        @java.lang.Override
        public Builder mergeFrom(com.google.protobuf.Message other) {
          if (other
              instanceof
              com.google.cloud.aiplatform.v1beta1.FeatureOnlineStore.Bigtable.AutoScaling) {
            return mergeFrom(
                (com.google.cloud.aiplatform.v1beta1.FeatureOnlineStore.Bigtable.AutoScaling)
                    other);
          } else {
            super.mergeFrom(other);
            return this;
          }
        }

        public Builder mergeFrom(
            com.google.cloud.aiplatform.v1beta1.FeatureOnlineStore.Bigtable.AutoScaling other) {
          if (other
              == com.google.cloud.aiplatform.v1beta1.FeatureOnlineStore.Bigtable.AutoScaling
                  .getDefaultInstance()) return this;
          if (other.getMinNodeCount() != 0) {
            setMinNodeCount(other.getMinNodeCount());
          }
          if (other.getMaxNodeCount() != 0) {
            setMaxNodeCount(other.getMaxNodeCount());
          }
          if (other.getCpuUtilizationTarget() != 0) {
            setCpuUtilizationTarget(other.getCpuUtilizationTarget());
          }
          this.mergeUnknownFields(other.getUnknownFields());
          onChanged();
          return this;
        }

        @java.lang.Override
        public final boolean isInitialized() {
          return true;
        }

        @java.lang.Override
        public Builder mergeFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws java.io.IOException {
          if (extensionRegistry == null) {
            throw new java.lang.NullPointerException();
          }
          try {
            boolean done = false;
            while (!done) {
              int tag = input.readTag();
              switch (tag) {
                case 0:
                  done = true;
                  break;
                case 8:
                  {
                    minNodeCount_ = input.readInt32();
                    bitField0_ |= 0x00000001;
                    break;
                  } // case 8
                case 16:
                  {
                    maxNodeCount_ = input.readInt32();
                    bitField0_ |= 0x00000002;
                    break;
                  } // case 16
                case 24:
                  {
                    cpuUtilizationTarget_ = input.readInt32();
                    bitField0_ |= 0x00000004;
                    break;
                  } // case 24
                default:
                  {
                    if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                      done = true; // was an endgroup tag
                    }
                    break;
                  } // default:
              } // switch (tag)
            } // while (!done)
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.unwrapIOException();
          } finally {
            onChanged();
          } // finally
          return this;
        }

        private int bitField0_;

        private int minNodeCount_;
        /**
         *
         *
         * <pre>
         * Required. The minimum number of nodes to scale down to. Must be greater
         * than or equal to 1.
         * </pre>
         *
         * <code>int32 min_node_count = 1 [(.google.api.field_behavior) = REQUIRED];</code>
         *
         * @return The minNodeCount.
         */
        @java.lang.Override
        public int getMinNodeCount() {
          return minNodeCount_;
        }
        /**
         *
         *
         * <pre>
         * Required. The minimum number of nodes to scale down to. Must be greater
         * than or equal to 1.
         * </pre>
         *
         * <code>int32 min_node_count = 1 [(.google.api.field_behavior) = REQUIRED];</code>
         *
         * @param value The minNodeCount to set.
         * @return This builder for chaining.
         */
        public Builder setMinNodeCount(int value) {

          minNodeCount_ = value;
          bitField0_ |= 0x00000001;
          onChanged();
          return this;
        }
        /**
         *
         *
         * <pre>
         * Required. The minimum number of nodes to scale down to. Must be greater
         * than or equal to 1.
         * </pre>
         *
         * <code>int32 min_node_count = 1 [(.google.api.field_behavior) = REQUIRED];</code>
         *
         * @return This builder for chaining.
         */
        public Builder clearMinNodeCount() {
          bitField0_ = (bitField0_ & ~0x00000001);
          minNodeCount_ = 0;
          onChanged();
          return this;
        }

        private int maxNodeCount_;
        /**
         *
         *
         * <pre>
         * Required. The maximum number of nodes to scale up to. Must be greater
         * than or equal to min_node_count, and less than or equal to 10 times of
         * 'min_node_count'.
         * </pre>
         *
         * <code>int32 max_node_count = 2 [(.google.api.field_behavior) = REQUIRED];</code>
         *
         * @return The maxNodeCount.
         */
        @java.lang.Override
        public int getMaxNodeCount() {
          return maxNodeCount_;
        }
        /**
         *
         *
         * <pre>
         * Required. The maximum number of nodes to scale up to. Must be greater
         * than or equal to min_node_count, and less than or equal to 10 times of
         * 'min_node_count'.
         * </pre>
         *
         * <code>int32 max_node_count = 2 [(.google.api.field_behavior) = REQUIRED];</code>
         *
         * @param value The maxNodeCount to set.
         * @return This builder for chaining.
         */
        public Builder setMaxNodeCount(int value) {

          maxNodeCount_ = value;
          bitField0_ |= 0x00000002;
          onChanged();
          return this;
        }
        /**
         *
         *
         * <pre>
         * Required. The maximum number of nodes to scale up to. Must be greater
         * than or equal to min_node_count, and less than or equal to 10 times of
         * 'min_node_count'.
         * </pre>
         *
         * <code>int32 max_node_count = 2 [(.google.api.field_behavior) = REQUIRED];</code>
         *
         * @return This builder for chaining.
         */
        public Builder clearMaxNodeCount() {
          bitField0_ = (bitField0_ & ~0x00000002);
          maxNodeCount_ = 0;
          onChanged();
          return this;
        }

        private int cpuUtilizationTarget_;
        /**
         *
         *
         * <pre>
         * Optional. A percentage of the cluster's CPU capacity. Can be from 10%
         * to 80%. When a cluster's CPU utilization exceeds the target that you
         * have set, Bigtable immediately adds nodes to the cluster. When CPU
         * utilization is substantially lower than the target, Bigtable removes
         * nodes. If not set will default to 50%.
         * </pre>
         *
         * <code>int32 cpu_utilization_target = 3 [(.google.api.field_behavior) = OPTIONAL];</code>
         *
         * @return The cpuUtilizationTarget.
         */
        @java.lang.Override
        public int getCpuUtilizationTarget() {
          return cpuUtilizationTarget_;
        }
        /**
         *
         *
         * <pre>
         * Optional. A percentage of the cluster's CPU capacity. Can be from 10%
         * to 80%. When a cluster's CPU utilization exceeds the target that you
         * have set, Bigtable immediately adds nodes to the cluster. When CPU
         * utilization is substantially lower than the target, Bigtable removes
         * nodes. If not set will default to 50%.
         * </pre>
         *
         * <code>int32 cpu_utilization_target = 3 [(.google.api.field_behavior) = OPTIONAL];</code>
         *
         * @param value The cpuUtilizationTarget to set.
         * @return This builder for chaining.
         */
        public Builder setCpuUtilizationTarget(int value) {

          cpuUtilizationTarget_ = value;
          bitField0_ |= 0x00000004;
          onChanged();
          return this;
        }
        /**
         *
         *
         * <pre>
         * Optional. A percentage of the cluster's CPU capacity. Can be from 10%
         * to 80%. When a cluster's CPU utilization exceeds the target that you
         * have set, Bigtable immediately adds nodes to the cluster. When CPU
         * utilization is substantially lower than the target, Bigtable removes
         * nodes. If not set will default to 50%.
         * </pre>
         *
         * <code>int32 cpu_utilization_target = 3 [(.google.api.field_behavior) = OPTIONAL];</code>
         *
         * @return This builder for chaining.
         */
        public Builder clearCpuUtilizationTarget() {
          bitField0_ = (bitField0_ & ~0x00000004);
          cpuUtilizationTarget_ = 0;
          onChanged();
          return this;
        }

        @java.lang.Override
        public final Builder setUnknownFields(
            final com.google.protobuf.UnknownFieldSet unknownFields) {
          return super.setUnknownFields(unknownFields);
        }

        @java.lang.Override
        public final Builder mergeUnknownFields(
            final com.google.protobuf.UnknownFieldSet unknownFields) {
          return super.mergeUnknownFields(unknownFields);
        }

        // @@protoc_insertion_point(builder_scope:google.cloud.aiplatform.v1beta1.FeatureOnlineStore.Bigtable.AutoScaling)
      }

      // @@protoc_insertion_point(class_scope:google.cloud.aiplatform.v1beta1.FeatureOnlineStore.Bigtable.AutoScaling)
      private static final com.google.cloud.aiplatform.v1beta1.FeatureOnlineStore.Bigtable
              .AutoScaling
          DEFAULT_INSTANCE;

      static {
        DEFAULT_INSTANCE =
            new com.google.cloud.aiplatform.v1beta1.FeatureOnlineStore.Bigtable.AutoScaling();
      }

      public static com.google.cloud.aiplatform.v1beta1.FeatureOnlineStore.Bigtable.AutoScaling
          getDefaultInstance() {
        return DEFAULT_INSTANCE;
      }

      private static final com.google.protobuf.Parser<AutoScaling> PARSER =
          new com.google.protobuf.AbstractParser<AutoScaling>() {
            @java.lang.Override
            public AutoScaling parsePartialFrom(
                com.google.protobuf.CodedInputStream input,
                com.google.protobuf.ExtensionRegistryLite extensionRegistry)
                throws com.google.protobuf.InvalidProtocolBufferException {
              Builder builder = newBuilder();
              try {
                builder.mergeFrom(input, extensionRegistry);
              } catch (com.google.protobuf.InvalidProtocolBufferException e) {
                throw e.setUnfinishedMessage(builder.buildPartial());
              } catch (com.google.protobuf.UninitializedMessageException e) {
                throw e.asInvalidProtocolBufferException()
                    .setUnfinishedMessage(builder.buildPartial());
              } catch (java.io.IOException e) {
                throw new com.google.protobuf.InvalidProtocolBufferException(e)
                    .setUnfinishedMessage(builder.buildPartial());
              }
              return builder.buildPartial();
            }
          };

      public static com.google.protobuf.Parser<AutoScaling> parser() {
        return PARSER;
      }

      @java.lang.Override
      public com.google.protobuf.Parser<AutoScaling> getParserForType() {
        return PARSER;
      }

      @java.lang.Override
      public com.google.cloud.aiplatform.v1beta1.FeatureOnlineStore.Bigtable.AutoScaling
          getDefaultInstanceForType() {
        return DEFAULT_INSTANCE;
      }
    }

    private int bitField0_;
    public static final int AUTO_SCALING_FIELD_NUMBER = 1;
    private com.google.cloud.aiplatform.v1beta1.FeatureOnlineStore.Bigtable.AutoScaling
        autoScaling_;
    /**
     *
     *
     * <pre>
     * Required. Autoscaling config applied to Bigtable Instance.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.FeatureOnlineStore.Bigtable.AutoScaling auto_scaling = 1 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     *
     * @return Whether the autoScaling field is set.
     */
    @java.lang.Override
    public boolean hasAutoScaling() {
      return ((bitField0_ & 0x00000001) != 0);
    }
    /**
     *
     *
     * <pre>
     * Required. Autoscaling config applied to Bigtable Instance.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.FeatureOnlineStore.Bigtable.AutoScaling auto_scaling = 1 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     *
     * @return The autoScaling.
     */
    @java.lang.Override
    public com.google.cloud.aiplatform.v1beta1.FeatureOnlineStore.Bigtable.AutoScaling
        getAutoScaling() {
      return autoScaling_ == null
          ? com.google.cloud.aiplatform.v1beta1.FeatureOnlineStore.Bigtable.AutoScaling
              .getDefaultInstance()
          : autoScaling_;
    }
    /**
     *
     *
     * <pre>
     * Required. Autoscaling config applied to Bigtable Instance.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.FeatureOnlineStore.Bigtable.AutoScaling auto_scaling = 1 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    @java.lang.Override
    public com.google.cloud.aiplatform.v1beta1.FeatureOnlineStore.Bigtable.AutoScalingOrBuilder
        getAutoScalingOrBuilder() {
      return autoScaling_ == null
          ? com.google.cloud.aiplatform.v1beta1.FeatureOnlineStore.Bigtable.AutoScaling
              .getDefaultInstance()
          : autoScaling_;
    }

    private byte memoizedIsInitialized = -1;

    @java.lang.Override
    public final boolean isInitialized() {
      byte isInitialized = memoizedIsInitialized;
      if (isInitialized == 1) return true;
      if (isInitialized == 0) return false;

      memoizedIsInitialized = 1;
      return true;
    }

    @java.lang.Override
    public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
      if (((bitField0_ & 0x00000001) != 0)) {
        output.writeMessage(1, getAutoScaling());
      }
      getUnknownFields().writeTo(output);
    }

    @java.lang.Override
    public int getSerializedSize() {
      int size = memoizedSize;
      if (size != -1) return size;

      size = 0;
      if (((bitField0_ & 0x00000001) != 0)) {
        size += com.google.protobuf.CodedOutputStream.computeMessageSize(1, getAutoScaling());
      }
      size += getUnknownFields().getSerializedSize();
      memoizedSize = size;
      return size;
    }

    @java.lang.Override
    public boolean equals(final java.lang.Object obj) {
      if (obj == this) {
        return true;
      }
      if (!(obj instanceof com.google.cloud.aiplatform.v1beta1.FeatureOnlineStore.Bigtable)) {
        return super.equals(obj);
      }
      com.google.cloud.aiplatform.v1beta1.FeatureOnlineStore.Bigtable other =
          (com.google.cloud.aiplatform.v1beta1.FeatureOnlineStore.Bigtable) obj;

      if (hasAutoScaling() != other.hasAutoScaling()) return false;
      if (hasAutoScaling()) {
        if (!getAutoScaling().equals(other.getAutoScaling())) return false;
      }
      if (!getUnknownFields().equals(other.getUnknownFields())) return false;
      return true;
    }

    @java.lang.Override
    public int hashCode() {
      if (memoizedHashCode != 0) {
        return memoizedHashCode;
      }
      int hash = 41;
      hash = (19 * hash) + getDescriptor().hashCode();
      if (hasAutoScaling()) {
        hash = (37 * hash) + AUTO_SCALING_FIELD_NUMBER;
        hash = (53 * hash) + getAutoScaling().hashCode();
      }
      hash = (29 * hash) + getUnknownFields().hashCode();
      memoizedHashCode = hash;
      return hash;
    }

    public static com.google.cloud.aiplatform.v1beta1.FeatureOnlineStore.Bigtable parseFrom(
        java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.aiplatform.v1beta1.FeatureOnlineStore.Bigtable parseFrom(
        java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.aiplatform.v1beta1.FeatureOnlineStore.Bigtable parseFrom(
        com.google.protobuf.ByteString data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.aiplatform.v1beta1.FeatureOnlineStore.Bigtable parseFrom(
        com.google.protobuf.ByteString data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.aiplatform.v1beta1.FeatureOnlineStore.Bigtable parseFrom(
        byte[] data) throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.aiplatform.v1beta1.FeatureOnlineStore.Bigtable parseFrom(
        byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.aiplatform.v1beta1.FeatureOnlineStore.Bigtable parseFrom(
        java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.cloud.aiplatform.v1beta1.FeatureOnlineStore.Bigtable parseFrom(
        java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.cloud.aiplatform.v1beta1.FeatureOnlineStore.Bigtable
        parseDelimitedFrom(java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
    }

    public static com.google.cloud.aiplatform.v1beta1.FeatureOnlineStore.Bigtable
        parseDelimitedFrom(
            java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.cloud.aiplatform.v1beta1.FeatureOnlineStore.Bigtable parseFrom(
        com.google.protobuf.CodedInputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.cloud.aiplatform.v1beta1.FeatureOnlineStore.Bigtable parseFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    @java.lang.Override
    public Builder newBuilderForType() {
      return newBuilder();
    }

    public static Builder newBuilder() {
      return DEFAULT_INSTANCE.toBuilder();
    }

    public static Builder newBuilder(
        com.google.cloud.aiplatform.v1beta1.FeatureOnlineStore.Bigtable prototype) {
      return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }

    @java.lang.Override
    public Builder toBuilder() {
      return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
    }

    @java.lang.Override
    protected Builder newBuilderForType(
        com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      Builder builder = new Builder(parent);
      return builder;
    }
    /** Protobuf type {@code google.cloud.aiplatform.v1beta1.FeatureOnlineStore.Bigtable} */
    public static final class Builder
        extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
        implements
        // @@protoc_insertion_point(builder_implements:google.cloud.aiplatform.v1beta1.FeatureOnlineStore.Bigtable)
        com.google.cloud.aiplatform.v1beta1.FeatureOnlineStore.BigtableOrBuilder {
      public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
        return com.google.cloud.aiplatform.v1beta1.FeatureOnlineStoreProto
            .internal_static_google_cloud_aiplatform_v1beta1_FeatureOnlineStore_Bigtable_descriptor;
      }

      @java.lang.Override
      protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return com.google.cloud.aiplatform.v1beta1.FeatureOnlineStoreProto
            .internal_static_google_cloud_aiplatform_v1beta1_FeatureOnlineStore_Bigtable_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                com.google.cloud.aiplatform.v1beta1.FeatureOnlineStore.Bigtable.class,
                com.google.cloud.aiplatform.v1beta1.FeatureOnlineStore.Bigtable.Builder.class);
      }

      // Construct using
      // com.google.cloud.aiplatform.v1beta1.FeatureOnlineStore.Bigtable.newBuilder()
      private Builder() {
        maybeForceBuilderInitialization();
      }

      private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
        super(parent);
        maybeForceBuilderInitialization();
      }

      private void maybeForceBuilderInitialization() {
        if (com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders) {
          getAutoScalingFieldBuilder();
        }
      }

      @java.lang.Override
      public Builder clear() {
        super.clear();
        bitField0_ = 0;
        autoScaling_ = null;
        if (autoScalingBuilder_ != null) {
          autoScalingBuilder_.dispose();
          autoScalingBuilder_ = null;
        }
        return this;
      }

      @java.lang.Override
      public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
        return com.google.cloud.aiplatform.v1beta1.FeatureOnlineStoreProto
            .internal_static_google_cloud_aiplatform_v1beta1_FeatureOnlineStore_Bigtable_descriptor;
      }

      @java.lang.Override
      public com.google.cloud.aiplatform.v1beta1.FeatureOnlineStore.Bigtable
          getDefaultInstanceForType() {
        return com.google.cloud.aiplatform.v1beta1.FeatureOnlineStore.Bigtable.getDefaultInstance();
      }

      @java.lang.Override
      public com.google.cloud.aiplatform.v1beta1.FeatureOnlineStore.Bigtable build() {
        com.google.cloud.aiplatform.v1beta1.FeatureOnlineStore.Bigtable result = buildPartial();
        if (!result.isInitialized()) {
          throw newUninitializedMessageException(result);
        }
        return result;
      }

      @java.lang.Override
      public com.google.cloud.aiplatform.v1beta1.FeatureOnlineStore.Bigtable buildPartial() {
        com.google.cloud.aiplatform.v1beta1.FeatureOnlineStore.Bigtable result =
            new com.google.cloud.aiplatform.v1beta1.FeatureOnlineStore.Bigtable(this);
        if (bitField0_ != 0) {
          buildPartial0(result);
        }
        onBuilt();
        return result;
      }

      private void buildPartial0(
          com.google.cloud.aiplatform.v1beta1.FeatureOnlineStore.Bigtable result) {
        int from_bitField0_ = bitField0_;
        int to_bitField0_ = 0;
        if (((from_bitField0_ & 0x00000001) != 0)) {
          result.autoScaling_ =
              autoScalingBuilder_ == null ? autoScaling_ : autoScalingBuilder_.build();
          to_bitField0_ |= 0x00000001;
        }
        result.bitField0_ |= to_bitField0_;
      }

      @java.lang.Override
      public Builder clone() {
        return super.clone();
      }

      @java.lang.Override
      public Builder setField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.setField(field, value);
      }

      @java.lang.Override
      public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
        return super.clearField(field);
      }

      @java.lang.Override
      public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
        return super.clearOneof(oneof);
      }

      @java.lang.Override
      public Builder setRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          int index,
          java.lang.Object value) {
        return super.setRepeatedField(field, index, value);
      }

      @java.lang.Override
      public Builder addRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.addRepeatedField(field, value);
      }

      @java.lang.Override
      public Builder mergeFrom(com.google.protobuf.Message other) {
        if (other instanceof com.google.cloud.aiplatform.v1beta1.FeatureOnlineStore.Bigtable) {
          return mergeFrom((com.google.cloud.aiplatform.v1beta1.FeatureOnlineStore.Bigtable) other);
        } else {
          super.mergeFrom(other);
          return this;
        }
      }

      public Builder mergeFrom(
          com.google.cloud.aiplatform.v1beta1.FeatureOnlineStore.Bigtable other) {
        if (other
            == com.google.cloud.aiplatform.v1beta1.FeatureOnlineStore.Bigtable.getDefaultInstance())
          return this;
        if (other.hasAutoScaling()) {
          mergeAutoScaling(other.getAutoScaling());
        }
        this.mergeUnknownFields(other.getUnknownFields());
        onChanged();
        return this;
      }

      @java.lang.Override
      public final boolean isInitialized() {
        return true;
      }

      @java.lang.Override
      public Builder mergeFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        if (extensionRegistry == null) {
          throw new java.lang.NullPointerException();
        }
        try {
          boolean done = false;
          while (!done) {
            int tag = input.readTag();
            switch (tag) {
              case 0:
                done = true;
                break;
              case 10:
                {
                  input.readMessage(getAutoScalingFieldBuilder().getBuilder(), extensionRegistry);
                  bitField0_ |= 0x00000001;
                  break;
                } // case 10
              default:
                {
                  if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                    done = true; // was an endgroup tag
                  }
                  break;
                } // default:
            } // switch (tag)
          } // while (!done)
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          throw e.unwrapIOException();
        } finally {
          onChanged();
        } // finally
        return this;
      }

      private int bitField0_;

      private com.google.cloud.aiplatform.v1beta1.FeatureOnlineStore.Bigtable.AutoScaling
          autoScaling_;
      private com.google.protobuf.SingleFieldBuilderV3<
              com.google.cloud.aiplatform.v1beta1.FeatureOnlineStore.Bigtable.AutoScaling,
              com.google.cloud.aiplatform.v1beta1.FeatureOnlineStore.Bigtable.AutoScaling.Builder,
              com.google.cloud.aiplatform.v1beta1.FeatureOnlineStore.Bigtable.AutoScalingOrBuilder>
          autoScalingBuilder_;
      /**
       *
       *
       * <pre>
       * Required. Autoscaling config applied to Bigtable Instance.
       * </pre>
       *
       * <code>
       * .google.cloud.aiplatform.v1beta1.FeatureOnlineStore.Bigtable.AutoScaling auto_scaling = 1 [(.google.api.field_behavior) = REQUIRED];
       * </code>
       *
       * @return Whether the autoScaling field is set.
       */
      public boolean hasAutoScaling() {
        return ((bitField0_ & 0x00000001) != 0);
      }
      /**
       *
       *
       * <pre>
       * Required. Autoscaling config applied to Bigtable Instance.
       * </pre>
       *
       * <code>
       * .google.cloud.aiplatform.v1beta1.FeatureOnlineStore.Bigtable.AutoScaling auto_scaling = 1 [(.google.api.field_behavior) = REQUIRED];
       * </code>
       *
       * @return The autoScaling.
       */
      public com.google.cloud.aiplatform.v1beta1.FeatureOnlineStore.Bigtable.AutoScaling
          getAutoScaling() {
        if (autoScalingBuilder_ == null) {
          return autoScaling_ == null
              ? com.google.cloud.aiplatform.v1beta1.FeatureOnlineStore.Bigtable.AutoScaling
                  .getDefaultInstance()
              : autoScaling_;
        } else {
          return autoScalingBuilder_.getMessage();
        }
      }
      /**
       *
       *
       * <pre>
       * Required. Autoscaling config applied to Bigtable Instance.
       * </pre>
       *
       * <code>
       * .google.cloud.aiplatform.v1beta1.FeatureOnlineStore.Bigtable.AutoScaling auto_scaling = 1 [(.google.api.field_behavior) = REQUIRED];
       * </code>
       */
      public Builder setAutoScaling(
          com.google.cloud.aiplatform.v1beta1.FeatureOnlineStore.Bigtable.AutoScaling value) {
        if (autoScalingBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          autoScaling_ = value;
        } else {
          autoScalingBuilder_.setMessage(value);
        }
        bitField0_ |= 0x00000001;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Required. Autoscaling config applied to Bigtable Instance.
       * </pre>
       *
       * <code>
       * .google.cloud.aiplatform.v1beta1.FeatureOnlineStore.Bigtable.AutoScaling auto_scaling = 1 [(.google.api.field_behavior) = REQUIRED];
       * </code>
       */
      public Builder setAutoScaling(
          com.google.cloud.aiplatform.v1beta1.FeatureOnlineStore.Bigtable.AutoScaling.Builder
              builderForValue) {
        if (autoScalingBuilder_ == null) {
          autoScaling_ = builderForValue.build();
        } else {
          autoScalingBuilder_.setMessage(builderForValue.build());
        }
        bitField0_ |= 0x00000001;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Required. Autoscaling config applied to Bigtable Instance.
       * </pre>
       *
       * <code>
       * .google.cloud.aiplatform.v1beta1.FeatureOnlineStore.Bigtable.AutoScaling auto_scaling = 1 [(.google.api.field_behavior) = REQUIRED];
       * </code>
       */
      public Builder mergeAutoScaling(
          com.google.cloud.aiplatform.v1beta1.FeatureOnlineStore.Bigtable.AutoScaling value) {
        if (autoScalingBuilder_ == null) {
          if (((bitField0_ & 0x00000001) != 0)
              && autoScaling_ != null
              && autoScaling_
                  != com.google.cloud.aiplatform.v1beta1.FeatureOnlineStore.Bigtable.AutoScaling
                      .getDefaultInstance()) {
            getAutoScalingBuilder().mergeFrom(value);
          } else {
            autoScaling_ = value;
          }
        } else {
          autoScalingBuilder_.mergeFrom(value);
        }
        if (autoScaling_ != null) {
          bitField0_ |= 0x00000001;
          onChanged();
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * Required. Autoscaling config applied to Bigtable Instance.
       * </pre>
       *
       * <code>
       * .google.cloud.aiplatform.v1beta1.FeatureOnlineStore.Bigtable.AutoScaling auto_scaling = 1 [(.google.api.field_behavior) = REQUIRED];
       * </code>
       */
      public Builder clearAutoScaling() {
        bitField0_ = (bitField0_ & ~0x00000001);
        autoScaling_ = null;
        if (autoScalingBuilder_ != null) {
          autoScalingBuilder_.dispose();
          autoScalingBuilder_ = null;
        }
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Required. Autoscaling config applied to Bigtable Instance.
       * </pre>
       *
       * <code>
       * .google.cloud.aiplatform.v1beta1.FeatureOnlineStore.Bigtable.AutoScaling auto_scaling = 1 [(.google.api.field_behavior) = REQUIRED];
       * </code>
       */
      public com.google.cloud.aiplatform.v1beta1.FeatureOnlineStore.Bigtable.AutoScaling.Builder
          getAutoScalingBuilder() {
        bitField0_ |= 0x00000001;
        onChanged();
        return getAutoScalingFieldBuilder().getBuilder();
      }
      /**
       *
       *
       * <pre>
       * Required. Autoscaling config applied to Bigtable Instance.
       * </pre>
       *
       * <code>
       * .google.cloud.aiplatform.v1beta1.FeatureOnlineStore.Bigtable.AutoScaling auto_scaling = 1 [(.google.api.field_behavior) = REQUIRED];
       * </code>
       */
      public com.google.cloud.aiplatform.v1beta1.FeatureOnlineStore.Bigtable.AutoScalingOrBuilder
          getAutoScalingOrBuilder() {
        if (autoScalingBuilder_ != null) {
          return autoScalingBuilder_.getMessageOrBuilder();
        } else {
          return autoScaling_ == null
              ? com.google.cloud.aiplatform.v1beta1.FeatureOnlineStore.Bigtable.AutoScaling
                  .getDefaultInstance()
              : autoScaling_;
        }
      }
      /**
       *
       *
       * <pre>
       * Required. Autoscaling config applied to Bigtable Instance.
       * </pre>
       *
       * <code>
       * .google.cloud.aiplatform.v1beta1.FeatureOnlineStore.Bigtable.AutoScaling auto_scaling = 1 [(.google.api.field_behavior) = REQUIRED];
       * </code>
       */
      private com.google.protobuf.SingleFieldBuilderV3<
              com.google.cloud.aiplatform.v1beta1.FeatureOnlineStore.Bigtable.AutoScaling,
              com.google.cloud.aiplatform.v1beta1.FeatureOnlineStore.Bigtable.AutoScaling.Builder,
              com.google.cloud.aiplatform.v1beta1.FeatureOnlineStore.Bigtable.AutoScalingOrBuilder>
          getAutoScalingFieldBuilder() {
        if (autoScalingBuilder_ == null) {
          autoScalingBuilder_ =
              new com.google.protobuf.SingleFieldBuilderV3<
                  com.google.cloud.aiplatform.v1beta1.FeatureOnlineStore.Bigtable.AutoScaling,
                  com.google.cloud.aiplatform.v1beta1.FeatureOnlineStore.Bigtable.AutoScaling
                      .Builder,
                  com.google.cloud.aiplatform.v1beta1.FeatureOnlineStore.Bigtable
                      .AutoScalingOrBuilder>(getAutoScaling(), getParentForChildren(), isClean());
          autoScaling_ = null;
        }
        return autoScalingBuilder_;
      }

      @java.lang.Override
      public final Builder setUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.setUnknownFields(unknownFields);
      }

      @java.lang.Override
      public final Builder mergeUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.mergeUnknownFields(unknownFields);
      }

      // @@protoc_insertion_point(builder_scope:google.cloud.aiplatform.v1beta1.FeatureOnlineStore.Bigtable)
    }

    // @@protoc_insertion_point(class_scope:google.cloud.aiplatform.v1beta1.FeatureOnlineStore.Bigtable)
    private static final com.google.cloud.aiplatform.v1beta1.FeatureOnlineStore.Bigtable
        DEFAULT_INSTANCE;

    static {
      DEFAULT_INSTANCE = new com.google.cloud.aiplatform.v1beta1.FeatureOnlineStore.Bigtable();
    }

    public static com.google.cloud.aiplatform.v1beta1.FeatureOnlineStore.Bigtable
        getDefaultInstance() {
      return DEFAULT_INSTANCE;
    }

    private static final com.google.protobuf.Parser<Bigtable> PARSER =
        new com.google.protobuf.AbstractParser<Bigtable>() {
          @java.lang.Override
          public Bigtable parsePartialFrom(
              com.google.protobuf.CodedInputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
            Builder builder = newBuilder();
            try {
              builder.mergeFrom(input, extensionRegistry);
            } catch (com.google.protobuf.InvalidProtocolBufferException e) {
              throw e.setUnfinishedMessage(builder.buildPartial());
            } catch (com.google.protobuf.UninitializedMessageException e) {
              throw e.asInvalidProtocolBufferException()
                  .setUnfinishedMessage(builder.buildPartial());
            } catch (java.io.IOException e) {
              throw new com.google.protobuf.InvalidProtocolBufferException(e)
                  .setUnfinishedMessage(builder.buildPartial());
            }
            return builder.buildPartial();
          }
        };

    public static com.google.protobuf.Parser<Bigtable> parser() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.protobuf.Parser<Bigtable> getParserForType() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.cloud.aiplatform.v1beta1.FeatureOnlineStore.Bigtable
        getDefaultInstanceForType() {
      return DEFAULT_INSTANCE;
    }
  }

  public interface OptimizedOrBuilder
      extends
      // @@protoc_insertion_point(interface_extends:google.cloud.aiplatform.v1beta1.FeatureOnlineStore.Optimized)
      com.google.protobuf.MessageOrBuilder {}
  /**
   *
   *
   * <pre>
   * Optimized storage type
   * </pre>
   *
   * Protobuf type {@code google.cloud.aiplatform.v1beta1.FeatureOnlineStore.Optimized}
   */
  public static final class Optimized extends com.google.protobuf.GeneratedMessageV3
      implements
      // @@protoc_insertion_point(message_implements:google.cloud.aiplatform.v1beta1.FeatureOnlineStore.Optimized)
      OptimizedOrBuilder {
    private static final long serialVersionUID = 0L;
    // Use Optimized.newBuilder() to construct.
    private Optimized(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
      super(builder);
    }

    private Optimized() {}

    @java.lang.Override
    @SuppressWarnings({"unused"})
    protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
      return new Optimized();
    }

    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.aiplatform.v1beta1.FeatureOnlineStoreProto
          .internal_static_google_cloud_aiplatform_v1beta1_FeatureOnlineStore_Optimized_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.aiplatform.v1beta1.FeatureOnlineStoreProto
          .internal_static_google_cloud_aiplatform_v1beta1_FeatureOnlineStore_Optimized_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.aiplatform.v1beta1.FeatureOnlineStore.Optimized.class,
              com.google.cloud.aiplatform.v1beta1.FeatureOnlineStore.Optimized.Builder.class);
    }

    private byte memoizedIsInitialized = -1;

    @java.lang.Override
    public final boolean isInitialized() {
      byte isInitialized = memoizedIsInitialized;
      if (isInitialized == 1) return true;
      if (isInitialized == 0) return false;

      memoizedIsInitialized = 1;
      return true;
    }

    @java.lang.Override
    public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
      getUnknownFields().writeTo(output);
    }

    @java.lang.Override
    public int getSerializedSize() {
      int size = memoizedSize;
      if (size != -1) return size;

      size = 0;
      size += getUnknownFields().getSerializedSize();
      memoizedSize = size;
      return size;
    }

    @java.lang.Override
    public boolean equals(final java.lang.Object obj) {
      if (obj == this) {
        return true;
      }
      if (!(obj instanceof com.google.cloud.aiplatform.v1beta1.FeatureOnlineStore.Optimized)) {
        return super.equals(obj);
      }
      com.google.cloud.aiplatform.v1beta1.FeatureOnlineStore.Optimized other =
          (com.google.cloud.aiplatform.v1beta1.FeatureOnlineStore.Optimized) obj;

      if (!getUnknownFields().equals(other.getUnknownFields())) return false;
      return true;
    }

    @java.lang.Override
    public int hashCode() {
      if (memoizedHashCode != 0) {
        return memoizedHashCode;
      }
      int hash = 41;
      hash = (19 * hash) + getDescriptor().hashCode();
      hash = (29 * hash) + getUnknownFields().hashCode();
      memoizedHashCode = hash;
      return hash;
    }

    public static com.google.cloud.aiplatform.v1beta1.FeatureOnlineStore.Optimized parseFrom(
        java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.aiplatform.v1beta1.FeatureOnlineStore.Optimized parseFrom(
        java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.aiplatform.v1beta1.FeatureOnlineStore.Optimized parseFrom(
        com.google.protobuf.ByteString data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.aiplatform.v1beta1.FeatureOnlineStore.Optimized parseFrom(
        com.google.protobuf.ByteString data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.aiplatform.v1beta1.FeatureOnlineStore.Optimized parseFrom(
        byte[] data) throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.aiplatform.v1beta1.FeatureOnlineStore.Optimized parseFrom(
        byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.aiplatform.v1beta1.FeatureOnlineStore.Optimized parseFrom(
        java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.cloud.aiplatform.v1beta1.FeatureOnlineStore.Optimized parseFrom(
        java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.cloud.aiplatform.v1beta1.FeatureOnlineStore.Optimized
        parseDelimitedFrom(java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
    }

    public static com.google.cloud.aiplatform.v1beta1.FeatureOnlineStore.Optimized
        parseDelimitedFrom(
            java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.cloud.aiplatform.v1beta1.FeatureOnlineStore.Optimized parseFrom(
        com.google.protobuf.CodedInputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.cloud.aiplatform.v1beta1.FeatureOnlineStore.Optimized parseFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    @java.lang.Override
    public Builder newBuilderForType() {
      return newBuilder();
    }

    public static Builder newBuilder() {
      return DEFAULT_INSTANCE.toBuilder();
    }

    public static Builder newBuilder(
        com.google.cloud.aiplatform.v1beta1.FeatureOnlineStore.Optimized prototype) {
      return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }

    @java.lang.Override
    public Builder toBuilder() {
      return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
    }

    @java.lang.Override
    protected Builder newBuilderForType(
        com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      Builder builder = new Builder(parent);
      return builder;
    }
    /**
     *
     *
     * <pre>
     * Optimized storage type
     * </pre>
     *
     * Protobuf type {@code google.cloud.aiplatform.v1beta1.FeatureOnlineStore.Optimized}
     */
    public static final class Builder
        extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
        implements
        // @@protoc_insertion_point(builder_implements:google.cloud.aiplatform.v1beta1.FeatureOnlineStore.Optimized)
        com.google.cloud.aiplatform.v1beta1.FeatureOnlineStore.OptimizedOrBuilder {
      public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
        return com.google.cloud.aiplatform.v1beta1.FeatureOnlineStoreProto
            .internal_static_google_cloud_aiplatform_v1beta1_FeatureOnlineStore_Optimized_descriptor;
      }

      @java.lang.Override
      protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return com.google.cloud.aiplatform.v1beta1.FeatureOnlineStoreProto
            .internal_static_google_cloud_aiplatform_v1beta1_FeatureOnlineStore_Optimized_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                com.google.cloud.aiplatform.v1beta1.FeatureOnlineStore.Optimized.class,
                com.google.cloud.aiplatform.v1beta1.FeatureOnlineStore.Optimized.Builder.class);
      }

      // Construct using
      // com.google.cloud.aiplatform.v1beta1.FeatureOnlineStore.Optimized.newBuilder()
      private Builder() {}

      private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
        super(parent);
      }

      @java.lang.Override
      public Builder clear() {
        super.clear();
        return this;
      }

      @java.lang.Override
      public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
        return com.google.cloud.aiplatform.v1beta1.FeatureOnlineStoreProto
            .internal_static_google_cloud_aiplatform_v1beta1_FeatureOnlineStore_Optimized_descriptor;
      }

      @java.lang.Override
      public com.google.cloud.aiplatform.v1beta1.FeatureOnlineStore.Optimized
          getDefaultInstanceForType() {
        return com.google.cloud.aiplatform.v1beta1.FeatureOnlineStore.Optimized
            .getDefaultInstance();
      }

      @java.lang.Override
      public com.google.cloud.aiplatform.v1beta1.FeatureOnlineStore.Optimized build() {
        com.google.cloud.aiplatform.v1beta1.FeatureOnlineStore.Optimized result = buildPartial();
        if (!result.isInitialized()) {
          throw newUninitializedMessageException(result);
        }
        return result;
      }

      @java.lang.Override
      public com.google.cloud.aiplatform.v1beta1.FeatureOnlineStore.Optimized buildPartial() {
        com.google.cloud.aiplatform.v1beta1.FeatureOnlineStore.Optimized result =
            new com.google.cloud.aiplatform.v1beta1.FeatureOnlineStore.Optimized(this);
        onBuilt();
        return result;
      }

      @java.lang.Override
      public Builder clone() {
        return super.clone();
      }

      @java.lang.Override
      public Builder setField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.setField(field, value);
      }

      @java.lang.Override
      public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
        return super.clearField(field);
      }

      @java.lang.Override
      public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
        return super.clearOneof(oneof);
      }

      @java.lang.Override
      public Builder setRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          int index,
          java.lang.Object value) {
        return super.setRepeatedField(field, index, value);
      }

      @java.lang.Override
      public Builder addRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.addRepeatedField(field, value);
      }

      @java.lang.Override
      public Builder mergeFrom(com.google.protobuf.Message other) {
        if (other instanceof com.google.cloud.aiplatform.v1beta1.FeatureOnlineStore.Optimized) {
          return mergeFrom(
              (com.google.cloud.aiplatform.v1beta1.FeatureOnlineStore.Optimized) other);
        } else {
          super.mergeFrom(other);
          return this;
        }
      }

      public Builder mergeFrom(
          com.google.cloud.aiplatform.v1beta1.FeatureOnlineStore.Optimized other) {
        if (other
            == com.google.cloud.aiplatform.v1beta1.FeatureOnlineStore.Optimized
                .getDefaultInstance()) return this;
        this.mergeUnknownFields(other.getUnknownFields());
        onChanged();
        return this;
      }

      @java.lang.Override
      public final boolean isInitialized() {
        return true;
      }

      @java.lang.Override
      public Builder mergeFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        if (extensionRegistry == null) {
          throw new java.lang.NullPointerException();
        }
        try {
          boolean done = false;
          while (!done) {
            int tag = input.readTag();
            switch (tag) {
              case 0:
                done = true;
                break;
              default:
                {
                  if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                    done = true; // was an endgroup tag
                  }
                  break;
                } // default:
            } // switch (tag)
          } // while (!done)
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          throw e.unwrapIOException();
        } finally {
          onChanged();
        } // finally
        return this;
      }

      @java.lang.Override
      public final Builder setUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.setUnknownFields(unknownFields);
      }

      @java.lang.Override
      public final Builder mergeUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.mergeUnknownFields(unknownFields);
      }

      // @@protoc_insertion_point(builder_scope:google.cloud.aiplatform.v1beta1.FeatureOnlineStore.Optimized)
    }

    // @@protoc_insertion_point(class_scope:google.cloud.aiplatform.v1beta1.FeatureOnlineStore.Optimized)
    private static final com.google.cloud.aiplatform.v1beta1.FeatureOnlineStore.Optimized
        DEFAULT_INSTANCE;

    static {
      DEFAULT_INSTANCE = new com.google.cloud.aiplatform.v1beta1.FeatureOnlineStore.Optimized();
    }

    public static com.google.cloud.aiplatform.v1beta1.FeatureOnlineStore.Optimized
        getDefaultInstance() {
      return DEFAULT_INSTANCE;
    }

    private static final com.google.protobuf.Parser<Optimized> PARSER =
        new com.google.protobuf.AbstractParser<Optimized>() {
          @java.lang.Override
          public Optimized parsePartialFrom(
              com.google.protobuf.CodedInputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
            Builder builder = newBuilder();
            try {
              builder.mergeFrom(input, extensionRegistry);
            } catch (com.google.protobuf.InvalidProtocolBufferException e) {
              throw e.setUnfinishedMessage(builder.buildPartial());
            } catch (com.google.protobuf.UninitializedMessageException e) {
              throw e.asInvalidProtocolBufferException()
                  .setUnfinishedMessage(builder.buildPartial());
            } catch (java.io.IOException e) {
              throw new com.google.protobuf.InvalidProtocolBufferException(e)
                  .setUnfinishedMessage(builder.buildPartial());
            }
            return builder.buildPartial();
          }
        };

    public static com.google.protobuf.Parser<Optimized> parser() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.protobuf.Parser<Optimized> getParserForType() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.cloud.aiplatform.v1beta1.FeatureOnlineStore.Optimized
        getDefaultInstanceForType() {
      return DEFAULT_INSTANCE;
    }
  }

  public interface DedicatedServingEndpointOrBuilder
      extends
      // @@protoc_insertion_point(interface_extends:google.cloud.aiplatform.v1beta1.FeatureOnlineStore.DedicatedServingEndpoint)
      com.google.protobuf.MessageOrBuilder {

    /**
     *
     *
     * <pre>
     * Output only. This field will be populated with the domain name to use for
     * this FeatureOnlineStore
     * </pre>
     *
     * <code>string public_endpoint_domain_name = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return The publicEndpointDomainName.
     */
    java.lang.String getPublicEndpointDomainName();
    /**
     *
     *
     * <pre>
     * Output only. This field will be populated with the domain name to use for
     * this FeatureOnlineStore
     * </pre>
     *
     * <code>string public_endpoint_domain_name = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return The bytes for publicEndpointDomainName.
     */
    com.google.protobuf.ByteString getPublicEndpointDomainNameBytes();

    /**
     *
     *
     * <pre>
     * Optional. Private service connect config. The private service connection
     * is available only for Optimized storage type, not for embedding
     * management now. If
     * [PrivateServiceConnectConfig.enable_private_service_connect][google.cloud.aiplatform.v1beta1.PrivateServiceConnectConfig.enable_private_service_connect]
     * set to true, customers will use private service connection to send
     * request. Otherwise, the connection will set to public endpoint.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.PrivateServiceConnectConfig private_service_connect_config = 3 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return Whether the privateServiceConnectConfig field is set.
     */
    boolean hasPrivateServiceConnectConfig();
    /**
     *
     *
     * <pre>
     * Optional. Private service connect config. The private service connection
     * is available only for Optimized storage type, not for embedding
     * management now. If
     * [PrivateServiceConnectConfig.enable_private_service_connect][google.cloud.aiplatform.v1beta1.PrivateServiceConnectConfig.enable_private_service_connect]
     * set to true, customers will use private service connection to send
     * request. Otherwise, the connection will set to public endpoint.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.PrivateServiceConnectConfig private_service_connect_config = 3 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return The privateServiceConnectConfig.
     */
    com.google.cloud.aiplatform.v1beta1.PrivateServiceConnectConfig
        getPrivateServiceConnectConfig();
    /**
     *
     *
     * <pre>
     * Optional. Private service connect config. The private service connection
     * is available only for Optimized storage type, not for embedding
     * management now. If
     * [PrivateServiceConnectConfig.enable_private_service_connect][google.cloud.aiplatform.v1beta1.PrivateServiceConnectConfig.enable_private_service_connect]
     * set to true, customers will use private service connection to send
     * request. Otherwise, the connection will set to public endpoint.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.PrivateServiceConnectConfig private_service_connect_config = 3 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    com.google.cloud.aiplatform.v1beta1.PrivateServiceConnectConfigOrBuilder
        getPrivateServiceConnectConfigOrBuilder();

    /**
     *
     *
     * <pre>
     * Output only. The name of the service attachment resource. Populated if
     * private service connect is enabled and after FeatureViewSync is created.
     * </pre>
     *
     * <code>string service_attachment = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return The serviceAttachment.
     */
    java.lang.String getServiceAttachment();
    /**
     *
     *
     * <pre>
     * Output only. The name of the service attachment resource. Populated if
     * private service connect is enabled and after FeatureViewSync is created.
     * </pre>
     *
     * <code>string service_attachment = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return The bytes for serviceAttachment.
     */
    com.google.protobuf.ByteString getServiceAttachmentBytes();
  }
  /**
   *
   *
   * <pre>
   * The dedicated serving endpoint for this FeatureOnlineStore. Only need to
   * set when you choose Optimized storage type or enable EmbeddingManagement.
   * Will use public endpoint by default. Note, for EmbeddingManagement use
   * case, only [DedicatedServingEndpoint.public_endpoint_domain_name] is
   * available now.
   * </pre>
   *
   * Protobuf type {@code
   * google.cloud.aiplatform.v1beta1.FeatureOnlineStore.DedicatedServingEndpoint}
   */
  public static final class DedicatedServingEndpoint extends com.google.protobuf.GeneratedMessageV3
      implements
      // @@protoc_insertion_point(message_implements:google.cloud.aiplatform.v1beta1.FeatureOnlineStore.DedicatedServingEndpoint)
      DedicatedServingEndpointOrBuilder {
    private static final long serialVersionUID = 0L;
    // Use DedicatedServingEndpoint.newBuilder() to construct.
    private DedicatedServingEndpoint(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
      super(builder);
    }

    private DedicatedServingEndpoint() {
      publicEndpointDomainName_ = "";
      serviceAttachment_ = "";
    }

    @java.lang.Override
    @SuppressWarnings({"unused"})
    protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
      return new DedicatedServingEndpoint();
    }

    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.aiplatform.v1beta1.FeatureOnlineStoreProto
          .internal_static_google_cloud_aiplatform_v1beta1_FeatureOnlineStore_DedicatedServingEndpoint_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.aiplatform.v1beta1.FeatureOnlineStoreProto
          .internal_static_google_cloud_aiplatform_v1beta1_FeatureOnlineStore_DedicatedServingEndpoint_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.aiplatform.v1beta1.FeatureOnlineStore.DedicatedServingEndpoint.class,
              com.google.cloud.aiplatform.v1beta1.FeatureOnlineStore.DedicatedServingEndpoint
                  .Builder.class);
    }

    private int bitField0_;
    public static final int PUBLIC_ENDPOINT_DOMAIN_NAME_FIELD_NUMBER = 2;

    @SuppressWarnings("serial")
    private volatile java.lang.Object publicEndpointDomainName_ = "";
    /**
     *
     *
     * <pre>
     * Output only. This field will be populated with the domain name to use for
     * this FeatureOnlineStore
     * </pre>
     *
     * <code>string public_endpoint_domain_name = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return The publicEndpointDomainName.
     */
    @java.lang.Override
    public java.lang.String getPublicEndpointDomainName() {
      java.lang.Object ref = publicEndpointDomainName_;
      if (ref instanceof java.lang.String) {
        return (java.lang.String) ref;
      } else {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        publicEndpointDomainName_ = s;
        return s;
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. This field will be populated with the domain name to use for
     * this FeatureOnlineStore
     * </pre>
     *
     * <code>string public_endpoint_domain_name = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return The bytes for publicEndpointDomainName.
     */
    @java.lang.Override
    public com.google.protobuf.ByteString getPublicEndpointDomainNameBytes() {
      java.lang.Object ref = publicEndpointDomainName_;
      if (ref instanceof java.lang.String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        publicEndpointDomainName_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    public static final int PRIVATE_SERVICE_CONNECT_CONFIG_FIELD_NUMBER = 3;
    private com.google.cloud.aiplatform.v1beta1.PrivateServiceConnectConfig
        privateServiceConnectConfig_;
    /**
     *
     *
     * <pre>
     * Optional. Private service connect config. The private service connection
     * is available only for Optimized storage type, not for embedding
     * management now. If
     * [PrivateServiceConnectConfig.enable_private_service_connect][google.cloud.aiplatform.v1beta1.PrivateServiceConnectConfig.enable_private_service_connect]
     * set to true, customers will use private service connection to send
     * request. Otherwise, the connection will set to public endpoint.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.PrivateServiceConnectConfig private_service_connect_config = 3 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return Whether the privateServiceConnectConfig field is set.
     */
    @java.lang.Override
    public boolean hasPrivateServiceConnectConfig() {
      return ((bitField0_ & 0x00000001) != 0);
    }
    /**
     *
     *
     * <pre>
     * Optional. Private service connect config. The private service connection
     * is available only for Optimized storage type, not for embedding
     * management now. If
     * [PrivateServiceConnectConfig.enable_private_service_connect][google.cloud.aiplatform.v1beta1.PrivateServiceConnectConfig.enable_private_service_connect]
     * set to true, customers will use private service connection to send
     * request. Otherwise, the connection will set to public endpoint.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.PrivateServiceConnectConfig private_service_connect_config = 3 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return The privateServiceConnectConfig.
     */
    @java.lang.Override
    public com.google.cloud.aiplatform.v1beta1.PrivateServiceConnectConfig
        getPrivateServiceConnectConfig() {
      return privateServiceConnectConfig_ == null
          ? com.google.cloud.aiplatform.v1beta1.PrivateServiceConnectConfig.getDefaultInstance()
          : privateServiceConnectConfig_;
    }
    /**
     *
     *
     * <pre>
     * Optional. Private service connect config. The private service connection
     * is available only for Optimized storage type, not for embedding
     * management now. If
     * [PrivateServiceConnectConfig.enable_private_service_connect][google.cloud.aiplatform.v1beta1.PrivateServiceConnectConfig.enable_private_service_connect]
     * set to true, customers will use private service connection to send
     * request. Otherwise, the connection will set to public endpoint.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.PrivateServiceConnectConfig private_service_connect_config = 3 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    @java.lang.Override
    public com.google.cloud.aiplatform.v1beta1.PrivateServiceConnectConfigOrBuilder
        getPrivateServiceConnectConfigOrBuilder() {
      return privateServiceConnectConfig_ == null
          ? com.google.cloud.aiplatform.v1beta1.PrivateServiceConnectConfig.getDefaultInstance()
          : privateServiceConnectConfig_;
    }

    public static final int SERVICE_ATTACHMENT_FIELD_NUMBER = 4;

    @SuppressWarnings("serial")
    private volatile java.lang.Object serviceAttachment_ = "";
    /**
     *
     *
     * <pre>
     * Output only. The name of the service attachment resource. Populated if
     * private service connect is enabled and after FeatureViewSync is created.
     * </pre>
     *
     * <code>string service_attachment = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return The serviceAttachment.
     */
    @java.lang.Override
    public java.lang.String getServiceAttachment() {
      java.lang.Object ref = serviceAttachment_;
      if (ref instanceof java.lang.String) {
        return (java.lang.String) ref;
      } else {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        serviceAttachment_ = s;
        return s;
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. The name of the service attachment resource. Populated if
     * private service connect is enabled and after FeatureViewSync is created.
     * </pre>
     *
     * <code>string service_attachment = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return The bytes for serviceAttachment.
     */
    @java.lang.Override
    public com.google.protobuf.ByteString getServiceAttachmentBytes() {
      java.lang.Object ref = serviceAttachment_;
      if (ref instanceof java.lang.String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        serviceAttachment_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    private byte memoizedIsInitialized = -1;

    @java.lang.Override
    public final boolean isInitialized() {
      byte isInitialized = memoizedIsInitialized;
      if (isInitialized == 1) return true;
      if (isInitialized == 0) return false;

      memoizedIsInitialized = 1;
      return true;
    }

    @java.lang.Override
    public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(publicEndpointDomainName_)) {
        com.google.protobuf.GeneratedMessageV3.writeString(output, 2, publicEndpointDomainName_);
      }
      if (((bitField0_ & 0x00000001) != 0)) {
        output.writeMessage(3, getPrivateServiceConnectConfig());
      }
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(serviceAttachment_)) {
        com.google.protobuf.GeneratedMessageV3.writeString(output, 4, serviceAttachment_);
      }
      getUnknownFields().writeTo(output);
    }

    @java.lang.Override
    public int getSerializedSize() {
      int size = memoizedSize;
      if (size != -1) return size;

      size = 0;
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(publicEndpointDomainName_)) {
        size +=
            com.google.protobuf.GeneratedMessageV3.computeStringSize(2, publicEndpointDomainName_);
      }
      if (((bitField0_ & 0x00000001) != 0)) {
        size +=
            com.google.protobuf.CodedOutputStream.computeMessageSize(
                3, getPrivateServiceConnectConfig());
      }
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(serviceAttachment_)) {
        size += com.google.protobuf.GeneratedMessageV3.computeStringSize(4, serviceAttachment_);
      }
      size += getUnknownFields().getSerializedSize();
      memoizedSize = size;
      return size;
    }

    @java.lang.Override
    public boolean equals(final java.lang.Object obj) {
      if (obj == this) {
        return true;
      }
      if (!(obj
          instanceof
          com.google.cloud.aiplatform.v1beta1.FeatureOnlineStore.DedicatedServingEndpoint)) {
        return super.equals(obj);
      }
      com.google.cloud.aiplatform.v1beta1.FeatureOnlineStore.DedicatedServingEndpoint other =
          (com.google.cloud.aiplatform.v1beta1.FeatureOnlineStore.DedicatedServingEndpoint) obj;

      if (!getPublicEndpointDomainName().equals(other.getPublicEndpointDomainName())) return false;
      if (hasPrivateServiceConnectConfig() != other.hasPrivateServiceConnectConfig()) return false;
      if (hasPrivateServiceConnectConfig()) {
        if (!getPrivateServiceConnectConfig().equals(other.getPrivateServiceConnectConfig()))
          return false;
      }
      if (!getServiceAttachment().equals(other.getServiceAttachment())) return false;
      if (!getUnknownFields().equals(other.getUnknownFields())) return false;
      return true;
    }

    @java.lang.Override
    public int hashCode() {
      if (memoizedHashCode != 0) {
        return memoizedHashCode;
      }
      int hash = 41;
      hash = (19 * hash) + getDescriptor().hashCode();
      hash = (37 * hash) + PUBLIC_ENDPOINT_DOMAIN_NAME_FIELD_NUMBER;
      hash = (53 * hash) + getPublicEndpointDomainName().hashCode();
      if (hasPrivateServiceConnectConfig()) {
        hash = (37 * hash) + PRIVATE_SERVICE_CONNECT_CONFIG_FIELD_NUMBER;
        hash = (53 * hash) + getPrivateServiceConnectConfig().hashCode();
      }
      hash = (37 * hash) + SERVICE_ATTACHMENT_FIELD_NUMBER;
      hash = (53 * hash) + getServiceAttachment().hashCode();
      hash = (29 * hash) + getUnknownFields().hashCode();
      memoizedHashCode = hash;
      return hash;
    }

    public static com.google.cloud.aiplatform.v1beta1.FeatureOnlineStore.DedicatedServingEndpoint
        parseFrom(java.nio.ByteBuffer data)
            throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.aiplatform.v1beta1.FeatureOnlineStore.DedicatedServingEndpoint
        parseFrom(
            java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.aiplatform.v1beta1.FeatureOnlineStore.DedicatedServingEndpoint
        parseFrom(com.google.protobuf.ByteString data)
            throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.aiplatform.v1beta1.FeatureOnlineStore.DedicatedServingEndpoint
        parseFrom(
            com.google.protobuf.ByteString data,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.aiplatform.v1beta1.FeatureOnlineStore.DedicatedServingEndpoint
        parseFrom(byte[] data) throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.aiplatform.v1beta1.FeatureOnlineStore.DedicatedServingEndpoint
        parseFrom(byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.aiplatform.v1beta1.FeatureOnlineStore.DedicatedServingEndpoint
        parseFrom(java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.cloud.aiplatform.v1beta1.FeatureOnlineStore.DedicatedServingEndpoint
        parseFrom(
            java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.cloud.aiplatform.v1beta1.FeatureOnlineStore.DedicatedServingEndpoint
        parseDelimitedFrom(java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
    }

    public static com.google.cloud.aiplatform.v1beta1.FeatureOnlineStore.DedicatedServingEndpoint
        parseDelimitedFrom(
            java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.cloud.aiplatform.v1beta1.FeatureOnlineStore.DedicatedServingEndpoint
        parseFrom(com.google.protobuf.CodedInputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.cloud.aiplatform.v1beta1.FeatureOnlineStore.DedicatedServingEndpoint
        parseFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    @java.lang.Override
    public Builder newBuilderForType() {
      return newBuilder();
    }

    public static Builder newBuilder() {
      return DEFAULT_INSTANCE.toBuilder();
    }

    public static Builder newBuilder(
        com.google.cloud.aiplatform.v1beta1.FeatureOnlineStore.DedicatedServingEndpoint prototype) {
      return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }

    @java.lang.Override
    public Builder toBuilder() {
      return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
    }

    @java.lang.Override
    protected Builder newBuilderForType(
        com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      Builder builder = new Builder(parent);
      return builder;
    }
    /**
     *
     *
     * <pre>
     * The dedicated serving endpoint for this FeatureOnlineStore. Only need to
     * set when you choose Optimized storage type or enable EmbeddingManagement.
     * Will use public endpoint by default. Note, for EmbeddingManagement use
     * case, only [DedicatedServingEndpoint.public_endpoint_domain_name] is
     * available now.
     * </pre>
     *
     * Protobuf type {@code
     * google.cloud.aiplatform.v1beta1.FeatureOnlineStore.DedicatedServingEndpoint}
     */
    public static final class Builder
        extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
        implements
        // @@protoc_insertion_point(builder_implements:google.cloud.aiplatform.v1beta1.FeatureOnlineStore.DedicatedServingEndpoint)
        com.google.cloud.aiplatform.v1beta1.FeatureOnlineStore.DedicatedServingEndpointOrBuilder {
      public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
        return com.google.cloud.aiplatform.v1beta1.FeatureOnlineStoreProto
            .internal_static_google_cloud_aiplatform_v1beta1_FeatureOnlineStore_DedicatedServingEndpoint_descriptor;
      }

      @java.lang.Override
      protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return com.google.cloud.aiplatform.v1beta1.FeatureOnlineStoreProto
            .internal_static_google_cloud_aiplatform_v1beta1_FeatureOnlineStore_DedicatedServingEndpoint_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                com.google.cloud.aiplatform.v1beta1.FeatureOnlineStore.DedicatedServingEndpoint
                    .class,
                com.google.cloud.aiplatform.v1beta1.FeatureOnlineStore.DedicatedServingEndpoint
                    .Builder.class);
      }

      // Construct using
      // com.google.cloud.aiplatform.v1beta1.FeatureOnlineStore.DedicatedServingEndpoint.newBuilder()
      private Builder() {
        maybeForceBuilderInitialization();
      }

      private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
        super(parent);
        maybeForceBuilderInitialization();
      }

      private void maybeForceBuilderInitialization() {
        if (com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders) {
          getPrivateServiceConnectConfigFieldBuilder();
        }
      }

      @java.lang.Override
      public Builder clear() {
        super.clear();
        bitField0_ = 0;
        publicEndpointDomainName_ = "";
        privateServiceConnectConfig_ = null;
        if (privateServiceConnectConfigBuilder_ != null) {
          privateServiceConnectConfigBuilder_.dispose();
          privateServiceConnectConfigBuilder_ = null;
        }
        serviceAttachment_ = "";
        return this;
      }

      @java.lang.Override
      public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
        return com.google.cloud.aiplatform.v1beta1.FeatureOnlineStoreProto
            .internal_static_google_cloud_aiplatform_v1beta1_FeatureOnlineStore_DedicatedServingEndpoint_descriptor;
      }

      @java.lang.Override
      public com.google.cloud.aiplatform.v1beta1.FeatureOnlineStore.DedicatedServingEndpoint
          getDefaultInstanceForType() {
        return com.google.cloud.aiplatform.v1beta1.FeatureOnlineStore.DedicatedServingEndpoint
            .getDefaultInstance();
      }

      @java.lang.Override
      public com.google.cloud.aiplatform.v1beta1.FeatureOnlineStore.DedicatedServingEndpoint
          build() {
        com.google.cloud.aiplatform.v1beta1.FeatureOnlineStore.DedicatedServingEndpoint result =
            buildPartial();
        if (!result.isInitialized()) {
          throw newUninitializedMessageException(result);
        }
        return result;
      }

      @java.lang.Override
      public com.google.cloud.aiplatform.v1beta1.FeatureOnlineStore.DedicatedServingEndpoint
          buildPartial() {
        com.google.cloud.aiplatform.v1beta1.FeatureOnlineStore.DedicatedServingEndpoint result =
            new com.google.cloud.aiplatform.v1beta1.FeatureOnlineStore.DedicatedServingEndpoint(
                this);
        if (bitField0_ != 0) {
          buildPartial0(result);
        }
        onBuilt();
        return result;
      }

      private void buildPartial0(
          com.google.cloud.aiplatform.v1beta1.FeatureOnlineStore.DedicatedServingEndpoint result) {
        int from_bitField0_ = bitField0_;
        if (((from_bitField0_ & 0x00000001) != 0)) {
          result.publicEndpointDomainName_ = publicEndpointDomainName_;
        }
        int to_bitField0_ = 0;
        if (((from_bitField0_ & 0x00000002) != 0)) {
          result.privateServiceConnectConfig_ =
              privateServiceConnectConfigBuilder_ == null
                  ? privateServiceConnectConfig_
                  : privateServiceConnectConfigBuilder_.build();
          to_bitField0_ |= 0x00000001;
        }
        if (((from_bitField0_ & 0x00000004) != 0)) {
          result.serviceAttachment_ = serviceAttachment_;
        }
        result.bitField0_ |= to_bitField0_;
      }

      @java.lang.Override
      public Builder clone() {
        return super.clone();
      }

      @java.lang.Override
      public Builder setField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.setField(field, value);
      }

      @java.lang.Override
      public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
        return super.clearField(field);
      }

      @java.lang.Override
      public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
        return super.clearOneof(oneof);
      }

      @java.lang.Override
      public Builder setRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          int index,
          java.lang.Object value) {
        return super.setRepeatedField(field, index, value);
      }

      @java.lang.Override
      public Builder addRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.addRepeatedField(field, value);
      }

      @java.lang.Override
      public Builder mergeFrom(com.google.protobuf.Message other) {
        if (other
            instanceof
            com.google.cloud.aiplatform.v1beta1.FeatureOnlineStore.DedicatedServingEndpoint) {
          return mergeFrom(
              (com.google.cloud.aiplatform.v1beta1.FeatureOnlineStore.DedicatedServingEndpoint)
                  other);
        } else {
          super.mergeFrom(other);
          return this;
        }
      }

      public Builder mergeFrom(
          com.google.cloud.aiplatform.v1beta1.FeatureOnlineStore.DedicatedServingEndpoint other) {
        if (other
            == com.google.cloud.aiplatform.v1beta1.FeatureOnlineStore.DedicatedServingEndpoint
                .getDefaultInstance()) return this;
        if (!other.getPublicEndpointDomainName().isEmpty()) {
          publicEndpointDomainName_ = other.publicEndpointDomainName_;
          bitField0_ |= 0x00000001;
          onChanged();
        }
        if (other.hasPrivateServiceConnectConfig()) {
          mergePrivateServiceConnectConfig(other.getPrivateServiceConnectConfig());
        }
        if (!other.getServiceAttachment().isEmpty()) {
          serviceAttachment_ = other.serviceAttachment_;
          bitField0_ |= 0x00000004;
          onChanged();
        }
        this.mergeUnknownFields(other.getUnknownFields());
        onChanged();
        return this;
      }

      @java.lang.Override
      public final boolean isInitialized() {
        return true;
      }

      @java.lang.Override
      public Builder mergeFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        if (extensionRegistry == null) {
          throw new java.lang.NullPointerException();
        }
        try {
          boolean done = false;
          while (!done) {
            int tag = input.readTag();
            switch (tag) {
              case 0:
                done = true;
                break;
              case 18:
                {
                  publicEndpointDomainName_ = input.readStringRequireUtf8();
                  bitField0_ |= 0x00000001;
                  break;
                } // case 18
              case 26:
                {
                  input.readMessage(
                      getPrivateServiceConnectConfigFieldBuilder().getBuilder(), extensionRegistry);
                  bitField0_ |= 0x00000002;
                  break;
                } // case 26
              case 34:
                {
                  serviceAttachment_ = input.readStringRequireUtf8();
                  bitField0_ |= 0x00000004;
                  break;
                } // case 34
              default:
                {
                  if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                    done = true; // was an endgroup tag
                  }
                  break;
                } // default:
            } // switch (tag)
          } // while (!done)
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          throw e.unwrapIOException();
        } finally {
          onChanged();
        } // finally
        return this;
      }

      private int bitField0_;

      private java.lang.Object publicEndpointDomainName_ = "";
      /**
       *
       *
       * <pre>
       * Output only. This field will be populated with the domain name to use for
       * this FeatureOnlineStore
       * </pre>
       *
       * <code>string public_endpoint_domain_name = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];
       * </code>
       *
       * @return The publicEndpointDomainName.
       */
      public java.lang.String getPublicEndpointDomainName() {
        java.lang.Object ref = publicEndpointDomainName_;
        if (!(ref instanceof java.lang.String)) {
          com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
          java.lang.String s = bs.toStringUtf8();
          publicEndpointDomainName_ = s;
          return s;
        } else {
          return (java.lang.String) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * Output only. This field will be populated with the domain name to use for
       * this FeatureOnlineStore
       * </pre>
       *
       * <code>string public_endpoint_domain_name = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];
       * </code>
       *
       * @return The bytes for publicEndpointDomainName.
       */
      public com.google.protobuf.ByteString getPublicEndpointDomainNameBytes() {
        java.lang.Object ref = publicEndpointDomainName_;
        if (ref instanceof String) {
          com.google.protobuf.ByteString b =
              com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
          publicEndpointDomainName_ = b;
          return b;
        } else {
          return (com.google.protobuf.ByteString) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * Output only. This field will be populated with the domain name to use for
       * this FeatureOnlineStore
       * </pre>
       *
       * <code>string public_endpoint_domain_name = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];
       * </code>
       *
       * @param value The publicEndpointDomainName to set.
       * @return This builder for chaining.
       */
      public Builder setPublicEndpointDomainName(java.lang.String value) {
        if (value == null) {
          throw new NullPointerException();
        }
        publicEndpointDomainName_ = value;
        bitField0_ |= 0x00000001;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Output only. This field will be populated with the domain name to use for
       * this FeatureOnlineStore
       * </pre>
       *
       * <code>string public_endpoint_domain_name = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];
       * </code>
       *
       * @return This builder for chaining.
       */
      public Builder clearPublicEndpointDomainName() {
        publicEndpointDomainName_ = getDefaultInstance().getPublicEndpointDomainName();
        bitField0_ = (bitField0_ & ~0x00000001);
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Output only. This field will be populated with the domain name to use for
       * this FeatureOnlineStore
       * </pre>
       *
       * <code>string public_endpoint_domain_name = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];
       * </code>
       *
       * @param value The bytes for publicEndpointDomainName to set.
       * @return This builder for chaining.
       */
      public Builder setPublicEndpointDomainNameBytes(com.google.protobuf.ByteString value) {
        if (value == null) {
          throw new NullPointerException();
        }
        checkByteStringIsUtf8(value);
        publicEndpointDomainName_ = value;
        bitField0_ |= 0x00000001;
        onChanged();
        return this;
      }

      private com.google.cloud.aiplatform.v1beta1.PrivateServiceConnectConfig
          privateServiceConnectConfig_;
      private com.google.protobuf.SingleFieldBuilderV3<
              com.google.cloud.aiplatform.v1beta1.PrivateServiceConnectConfig,
              com.google.cloud.aiplatform.v1beta1.PrivateServiceConnectConfig.Builder,
              com.google.cloud.aiplatform.v1beta1.PrivateServiceConnectConfigOrBuilder>
          privateServiceConnectConfigBuilder_;
      /**
       *
       *
       * <pre>
       * Optional. Private service connect config. The private service connection
       * is available only for Optimized storage type, not for embedding
       * management now. If
       * [PrivateServiceConnectConfig.enable_private_service_connect][google.cloud.aiplatform.v1beta1.PrivateServiceConnectConfig.enable_private_service_connect]
       * set to true, customers will use private service connection to send
       * request. Otherwise, the connection will set to public endpoint.
       * </pre>
       *
       * <code>
       * .google.cloud.aiplatform.v1beta1.PrivateServiceConnectConfig private_service_connect_config = 3 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       *
       * @return Whether the privateServiceConnectConfig field is set.
       */
      public boolean hasPrivateServiceConnectConfig() {
        return ((bitField0_ & 0x00000002) != 0);
      }
      /**
       *
       *
       * <pre>
       * Optional. Private service connect config. The private service connection
       * is available only for Optimized storage type, not for embedding
       * management now. If
       * [PrivateServiceConnectConfig.enable_private_service_connect][google.cloud.aiplatform.v1beta1.PrivateServiceConnectConfig.enable_private_service_connect]
       * set to true, customers will use private service connection to send
       * request. Otherwise, the connection will set to public endpoint.
       * </pre>
       *
       * <code>
       * .google.cloud.aiplatform.v1beta1.PrivateServiceConnectConfig private_service_connect_config = 3 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       *
       * @return The privateServiceConnectConfig.
       */
      public com.google.cloud.aiplatform.v1beta1.PrivateServiceConnectConfig
          getPrivateServiceConnectConfig() {
        if (privateServiceConnectConfigBuilder_ == null) {
          return privateServiceConnectConfig_ == null
              ? com.google.cloud.aiplatform.v1beta1.PrivateServiceConnectConfig.getDefaultInstance()
              : privateServiceConnectConfig_;
        } else {
          return privateServiceConnectConfigBuilder_.getMessage();
        }
      }
      /**
       *
       *
       * <pre>
       * Optional. Private service connect config. The private service connection
       * is available only for Optimized storage type, not for embedding
       * management now. If
       * [PrivateServiceConnectConfig.enable_private_service_connect][google.cloud.aiplatform.v1beta1.PrivateServiceConnectConfig.enable_private_service_connect]
       * set to true, customers will use private service connection to send
       * request. Otherwise, the connection will set to public endpoint.
       * </pre>
       *
       * <code>
       * .google.cloud.aiplatform.v1beta1.PrivateServiceConnectConfig private_service_connect_config = 3 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       */
      public Builder setPrivateServiceConnectConfig(
          com.google.cloud.aiplatform.v1beta1.PrivateServiceConnectConfig value) {
        if (privateServiceConnectConfigBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          privateServiceConnectConfig_ = value;
        } else {
          privateServiceConnectConfigBuilder_.setMessage(value);
        }
        bitField0_ |= 0x00000002;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Optional. Private service connect config. The private service connection
       * is available only for Optimized storage type, not for embedding
       * management now. If
       * [PrivateServiceConnectConfig.enable_private_service_connect][google.cloud.aiplatform.v1beta1.PrivateServiceConnectConfig.enable_private_service_connect]
       * set to true, customers will use private service connection to send
       * request. Otherwise, the connection will set to public endpoint.
       * </pre>
       *
       * <code>
       * .google.cloud.aiplatform.v1beta1.PrivateServiceConnectConfig private_service_connect_config = 3 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       */
      public Builder setPrivateServiceConnectConfig(
          com.google.cloud.aiplatform.v1beta1.PrivateServiceConnectConfig.Builder builderForValue) {
        if (privateServiceConnectConfigBuilder_ == null) {
          privateServiceConnectConfig_ = builderForValue.build();
        } else {
          privateServiceConnectConfigBuilder_.setMessage(builderForValue.build());
        }
        bitField0_ |= 0x00000002;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Optional. Private service connect config. The private service connection
       * is available only for Optimized storage type, not for embedding
       * management now. If
       * [PrivateServiceConnectConfig.enable_private_service_connect][google.cloud.aiplatform.v1beta1.PrivateServiceConnectConfig.enable_private_service_connect]
       * set to true, customers will use private service connection to send
       * request. Otherwise, the connection will set to public endpoint.
       * </pre>
       *
       * <code>
       * .google.cloud.aiplatform.v1beta1.PrivateServiceConnectConfig private_service_connect_config = 3 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       */
      public Builder mergePrivateServiceConnectConfig(
          com.google.cloud.aiplatform.v1beta1.PrivateServiceConnectConfig value) {
        if (privateServiceConnectConfigBuilder_ == null) {
          if (((bitField0_ & 0x00000002) != 0)
              && privateServiceConnectConfig_ != null
              && privateServiceConnectConfig_
                  != com.google.cloud.aiplatform.v1beta1.PrivateServiceConnectConfig
                      .getDefaultInstance()) {
            getPrivateServiceConnectConfigBuilder().mergeFrom(value);
          } else {
            privateServiceConnectConfig_ = value;
          }
        } else {
          privateServiceConnectConfigBuilder_.mergeFrom(value);
        }
        if (privateServiceConnectConfig_ != null) {
          bitField0_ |= 0x00000002;
          onChanged();
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * Optional. Private service connect config. The private service connection
       * is available only for Optimized storage type, not for embedding
       * management now. If
       * [PrivateServiceConnectConfig.enable_private_service_connect][google.cloud.aiplatform.v1beta1.PrivateServiceConnectConfig.enable_private_service_connect]
       * set to true, customers will use private service connection to send
       * request. Otherwise, the connection will set to public endpoint.
       * </pre>
       *
       * <code>
       * .google.cloud.aiplatform.v1beta1.PrivateServiceConnectConfig private_service_connect_config = 3 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       */
      public Builder clearPrivateServiceConnectConfig() {
        bitField0_ = (bitField0_ & ~0x00000002);
        privateServiceConnectConfig_ = null;
        if (privateServiceConnectConfigBuilder_ != null) {
          privateServiceConnectConfigBuilder_.dispose();
          privateServiceConnectConfigBuilder_ = null;
        }
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Optional. Private service connect config. The private service connection
       * is available only for Optimized storage type, not for embedding
       * management now. If
       * [PrivateServiceConnectConfig.enable_private_service_connect][google.cloud.aiplatform.v1beta1.PrivateServiceConnectConfig.enable_private_service_connect]
       * set to true, customers will use private service connection to send
       * request. Otherwise, the connection will set to public endpoint.
       * </pre>
       *
       * <code>
       * .google.cloud.aiplatform.v1beta1.PrivateServiceConnectConfig private_service_connect_config = 3 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       */
      public com.google.cloud.aiplatform.v1beta1.PrivateServiceConnectConfig.Builder
          getPrivateServiceConnectConfigBuilder() {
        bitField0_ |= 0x00000002;
        onChanged();
        return getPrivateServiceConnectConfigFieldBuilder().getBuilder();
      }
      /**
       *
       *
       * <pre>
       * Optional. Private service connect config. The private service connection
       * is available only for Optimized storage type, not for embedding
       * management now. If
       * [PrivateServiceConnectConfig.enable_private_service_connect][google.cloud.aiplatform.v1beta1.PrivateServiceConnectConfig.enable_private_service_connect]
       * set to true, customers will use private service connection to send
       * request. Otherwise, the connection will set to public endpoint.
       * </pre>
       *
       * <code>
       * .google.cloud.aiplatform.v1beta1.PrivateServiceConnectConfig private_service_connect_config = 3 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       */
      public com.google.cloud.aiplatform.v1beta1.PrivateServiceConnectConfigOrBuilder
          getPrivateServiceConnectConfigOrBuilder() {
        if (privateServiceConnectConfigBuilder_ != null) {
          return privateServiceConnectConfigBuilder_.getMessageOrBuilder();
        } else {
          return privateServiceConnectConfig_ == null
              ? com.google.cloud.aiplatform.v1beta1.PrivateServiceConnectConfig.getDefaultInstance()
              : privateServiceConnectConfig_;
        }
      }
      /**
       *
       *
       * <pre>
       * Optional. Private service connect config. The private service connection
       * is available only for Optimized storage type, not for embedding
       * management now. If
       * [PrivateServiceConnectConfig.enable_private_service_connect][google.cloud.aiplatform.v1beta1.PrivateServiceConnectConfig.enable_private_service_connect]
       * set to true, customers will use private service connection to send
       * request. Otherwise, the connection will set to public endpoint.
       * </pre>
       *
       * <code>
       * .google.cloud.aiplatform.v1beta1.PrivateServiceConnectConfig private_service_connect_config = 3 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       */
      private com.google.protobuf.SingleFieldBuilderV3<
              com.google.cloud.aiplatform.v1beta1.PrivateServiceConnectConfig,
              com.google.cloud.aiplatform.v1beta1.PrivateServiceConnectConfig.Builder,
              com.google.cloud.aiplatform.v1beta1.PrivateServiceConnectConfigOrBuilder>
          getPrivateServiceConnectConfigFieldBuilder() {
        if (privateServiceConnectConfigBuilder_ == null) {
          privateServiceConnectConfigBuilder_ =
              new com.google.protobuf.SingleFieldBuilderV3<
                  com.google.cloud.aiplatform.v1beta1.PrivateServiceConnectConfig,
                  com.google.cloud.aiplatform.v1beta1.PrivateServiceConnectConfig.Builder,
                  com.google.cloud.aiplatform.v1beta1.PrivateServiceConnectConfigOrBuilder>(
                  getPrivateServiceConnectConfig(), getParentForChildren(), isClean());
          privateServiceConnectConfig_ = null;
        }
        return privateServiceConnectConfigBuilder_;
      }

      private java.lang.Object serviceAttachment_ = "";
      /**
       *
       *
       * <pre>
       * Output only. The name of the service attachment resource. Populated if
       * private service connect is enabled and after FeatureViewSync is created.
       * </pre>
       *
       * <code>string service_attachment = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
       *
       * @return The serviceAttachment.
       */
      public java.lang.String getServiceAttachment() {
        java.lang.Object ref = serviceAttachment_;
        if (!(ref instanceof java.lang.String)) {
          com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
          java.lang.String s = bs.toStringUtf8();
          serviceAttachment_ = s;
          return s;
        } else {
          return (java.lang.String) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * Output only. The name of the service attachment resource. Populated if
       * private service connect is enabled and after FeatureViewSync is created.
       * </pre>
       *
       * <code>string service_attachment = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
       *
       * @return The bytes for serviceAttachment.
       */
      public com.google.protobuf.ByteString getServiceAttachmentBytes() {
        java.lang.Object ref = serviceAttachment_;
        if (ref instanceof String) {
          com.google.protobuf.ByteString b =
              com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
          serviceAttachment_ = b;
          return b;
        } else {
          return (com.google.protobuf.ByteString) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * Output only. The name of the service attachment resource. Populated if
       * private service connect is enabled and after FeatureViewSync is created.
       * </pre>
       *
       * <code>string service_attachment = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
       *
       * @param value The serviceAttachment to set.
       * @return This builder for chaining.
       */
      public Builder setServiceAttachment(java.lang.String value) {
        if (value == null) {
          throw new NullPointerException();
        }
        serviceAttachment_ = value;
        bitField0_ |= 0x00000004;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Output only. The name of the service attachment resource. Populated if
       * private service connect is enabled and after FeatureViewSync is created.
       * </pre>
       *
       * <code>string service_attachment = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearServiceAttachment() {
        serviceAttachment_ = getDefaultInstance().getServiceAttachment();
        bitField0_ = (bitField0_ & ~0x00000004);
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Output only. The name of the service attachment resource. Populated if
       * private service connect is enabled and after FeatureViewSync is created.
       * </pre>
       *
       * <code>string service_attachment = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
       *
       * @param value The bytes for serviceAttachment to set.
       * @return This builder for chaining.
       */
      public Builder setServiceAttachmentBytes(com.google.protobuf.ByteString value) {
        if (value == null) {
          throw new NullPointerException();
        }
        checkByteStringIsUtf8(value);
        serviceAttachment_ = value;
        bitField0_ |= 0x00000004;
        onChanged();
        return this;
      }

      @java.lang.Override
      public final Builder setUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.setUnknownFields(unknownFields);
      }

      @java.lang.Override
      public final Builder mergeUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.mergeUnknownFields(unknownFields);
      }

      // @@protoc_insertion_point(builder_scope:google.cloud.aiplatform.v1beta1.FeatureOnlineStore.DedicatedServingEndpoint)
    }

    // @@protoc_insertion_point(class_scope:google.cloud.aiplatform.v1beta1.FeatureOnlineStore.DedicatedServingEndpoint)
    private static final com.google.cloud.aiplatform.v1beta1.FeatureOnlineStore
            .DedicatedServingEndpoint
        DEFAULT_INSTANCE;

    static {
      DEFAULT_INSTANCE =
          new com.google.cloud.aiplatform.v1beta1.FeatureOnlineStore.DedicatedServingEndpoint();
    }

    public static com.google.cloud.aiplatform.v1beta1.FeatureOnlineStore.DedicatedServingEndpoint
        getDefaultInstance() {
      return DEFAULT_INSTANCE;
    }

    private static final com.google.protobuf.Parser<DedicatedServingEndpoint> PARSER =
        new com.google.protobuf.AbstractParser<DedicatedServingEndpoint>() {
          @java.lang.Override
          public DedicatedServingEndpoint parsePartialFrom(
              com.google.protobuf.CodedInputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
            Builder builder = newBuilder();
            try {
              builder.mergeFrom(input, extensionRegistry);
            } catch (com.google.protobuf.InvalidProtocolBufferException e) {
              throw e.setUnfinishedMessage(builder.buildPartial());
            } catch (com.google.protobuf.UninitializedMessageException e) {
              throw e.asInvalidProtocolBufferException()
                  .setUnfinishedMessage(builder.buildPartial());
            } catch (java.io.IOException e) {
              throw new com.google.protobuf.InvalidProtocolBufferException(e)
                  .setUnfinishedMessage(builder.buildPartial());
            }
            return builder.buildPartial();
          }
        };

    public static com.google.protobuf.Parser<DedicatedServingEndpoint> parser() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.protobuf.Parser<DedicatedServingEndpoint> getParserForType() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.cloud.aiplatform.v1beta1.FeatureOnlineStore.DedicatedServingEndpoint
        getDefaultInstanceForType() {
      return DEFAULT_INSTANCE;
    }
  }

  public interface EmbeddingManagementOrBuilder
      extends
      // @@protoc_insertion_point(interface_extends:google.cloud.aiplatform.v1beta1.FeatureOnlineStore.EmbeddingManagement)
      com.google.protobuf.MessageOrBuilder {

    /**
     *
     *
     * <pre>
     * Optional. Immutable. Whether to enable embedding management in this
     * FeatureOnlineStore. It's immutable after creation to ensure the
     * FeatureOnlineStore availability.
     * </pre>
     *
     * <code>
     * bool enabled = 1 [(.google.api.field_behavior) = OPTIONAL, (.google.api.field_behavior) = IMMUTABLE];
     * </code>
     *
     * @return The enabled.
     */
    boolean getEnabled();
  }
  /**
   *
   *
   * <pre>
   * Contains settings for embedding management.
   * </pre>
   *
   * Protobuf type {@code google.cloud.aiplatform.v1beta1.FeatureOnlineStore.EmbeddingManagement}
   */
  public static final class EmbeddingManagement extends com.google.protobuf.GeneratedMessageV3
      implements
      // @@protoc_insertion_point(message_implements:google.cloud.aiplatform.v1beta1.FeatureOnlineStore.EmbeddingManagement)
      EmbeddingManagementOrBuilder {
    private static final long serialVersionUID = 0L;
    // Use EmbeddingManagement.newBuilder() to construct.
    private EmbeddingManagement(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
      super(builder);
    }

    private EmbeddingManagement() {}

    @java.lang.Override
    @SuppressWarnings({"unused"})
    protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
      return new EmbeddingManagement();
    }

    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.aiplatform.v1beta1.FeatureOnlineStoreProto
          .internal_static_google_cloud_aiplatform_v1beta1_FeatureOnlineStore_EmbeddingManagement_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.aiplatform.v1beta1.FeatureOnlineStoreProto
          .internal_static_google_cloud_aiplatform_v1beta1_FeatureOnlineStore_EmbeddingManagement_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.aiplatform.v1beta1.FeatureOnlineStore.EmbeddingManagement.class,
              com.google.cloud.aiplatform.v1beta1.FeatureOnlineStore.EmbeddingManagement.Builder
                  .class);
    }

    public static final int ENABLED_FIELD_NUMBER = 1;
    private boolean enabled_ = false;
    /**
     *
     *
     * <pre>
     * Optional. Immutable. Whether to enable embedding management in this
     * FeatureOnlineStore. It's immutable after creation to ensure the
     * FeatureOnlineStore availability.
     * </pre>
     *
     * <code>
     * bool enabled = 1 [(.google.api.field_behavior) = OPTIONAL, (.google.api.field_behavior) = IMMUTABLE];
     * </code>
     *
     * @return The enabled.
     */
    @java.lang.Override
    public boolean getEnabled() {
      return enabled_;
    }

    private byte memoizedIsInitialized = -1;

    @java.lang.Override
    public final boolean isInitialized() {
      byte isInitialized = memoizedIsInitialized;
      if (isInitialized == 1) return true;
      if (isInitialized == 0) return false;

      memoizedIsInitialized = 1;
      return true;
    }

    @java.lang.Override
    public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
      if (enabled_ != false) {
        output.writeBool(1, enabled_);
      }
      getUnknownFields().writeTo(output);
    }

    @java.lang.Override
    public int getSerializedSize() {
      int size = memoizedSize;
      if (size != -1) return size;

      size = 0;
      if (enabled_ != false) {
        size += com.google.protobuf.CodedOutputStream.computeBoolSize(1, enabled_);
      }
      size += getUnknownFields().getSerializedSize();
      memoizedSize = size;
      return size;
    }

    @java.lang.Override
    public boolean equals(final java.lang.Object obj) {
      if (obj == this) {
        return true;
      }
      if (!(obj
          instanceof com.google.cloud.aiplatform.v1beta1.FeatureOnlineStore.EmbeddingManagement)) {
        return super.equals(obj);
      }
      com.google.cloud.aiplatform.v1beta1.FeatureOnlineStore.EmbeddingManagement other =
          (com.google.cloud.aiplatform.v1beta1.FeatureOnlineStore.EmbeddingManagement) obj;

      if (getEnabled() != other.getEnabled()) return false;
      if (!getUnknownFields().equals(other.getUnknownFields())) return false;
      return true;
    }

    @java.lang.Override
    public int hashCode() {
      if (memoizedHashCode != 0) {
        return memoizedHashCode;
      }
      int hash = 41;
      hash = (19 * hash) + getDescriptor().hashCode();
      hash = (37 * hash) + ENABLED_FIELD_NUMBER;
      hash = (53 * hash) + com.google.protobuf.Internal.hashBoolean(getEnabled());
      hash = (29 * hash) + getUnknownFields().hashCode();
      memoizedHashCode = hash;
      return hash;
    }

    public static com.google.cloud.aiplatform.v1beta1.FeatureOnlineStore.EmbeddingManagement
        parseFrom(java.nio.ByteBuffer data)
            throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.aiplatform.v1beta1.FeatureOnlineStore.EmbeddingManagement
        parseFrom(
            java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.aiplatform.v1beta1.FeatureOnlineStore.EmbeddingManagement
        parseFrom(com.google.protobuf.ByteString data)
            throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.aiplatform.v1beta1.FeatureOnlineStore.EmbeddingManagement
        parseFrom(
            com.google.protobuf.ByteString data,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.aiplatform.v1beta1.FeatureOnlineStore.EmbeddingManagement
        parseFrom(byte[] data) throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.aiplatform.v1beta1.FeatureOnlineStore.EmbeddingManagement
        parseFrom(byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.aiplatform.v1beta1.FeatureOnlineStore.EmbeddingManagement
        parseFrom(java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.cloud.aiplatform.v1beta1.FeatureOnlineStore.EmbeddingManagement
        parseFrom(
            java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.cloud.aiplatform.v1beta1.FeatureOnlineStore.EmbeddingManagement
        parseDelimitedFrom(java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
    }

    public static com.google.cloud.aiplatform.v1beta1.FeatureOnlineStore.EmbeddingManagement
        parseDelimitedFrom(
            java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.cloud.aiplatform.v1beta1.FeatureOnlineStore.EmbeddingManagement
        parseFrom(com.google.protobuf.CodedInputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.cloud.aiplatform.v1beta1.FeatureOnlineStore.EmbeddingManagement
        parseFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    @java.lang.Override
    public Builder newBuilderForType() {
      return newBuilder();
    }

    public static Builder newBuilder() {
      return DEFAULT_INSTANCE.toBuilder();
    }

    public static Builder newBuilder(
        com.google.cloud.aiplatform.v1beta1.FeatureOnlineStore.EmbeddingManagement prototype) {
      return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }

    @java.lang.Override
    public Builder toBuilder() {
      return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
    }

    @java.lang.Override
    protected Builder newBuilderForType(
        com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      Builder builder = new Builder(parent);
      return builder;
    }
    /**
     *
     *
     * <pre>
     * Contains settings for embedding management.
     * </pre>
     *
     * Protobuf type {@code google.cloud.aiplatform.v1beta1.FeatureOnlineStore.EmbeddingManagement}
     */
    public static final class Builder
        extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
        implements
        // @@protoc_insertion_point(builder_implements:google.cloud.aiplatform.v1beta1.FeatureOnlineStore.EmbeddingManagement)
        com.google.cloud.aiplatform.v1beta1.FeatureOnlineStore.EmbeddingManagementOrBuilder {
      public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
        return com.google.cloud.aiplatform.v1beta1.FeatureOnlineStoreProto
            .internal_static_google_cloud_aiplatform_v1beta1_FeatureOnlineStore_EmbeddingManagement_descriptor;
      }

      @java.lang.Override
      protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return com.google.cloud.aiplatform.v1beta1.FeatureOnlineStoreProto
            .internal_static_google_cloud_aiplatform_v1beta1_FeatureOnlineStore_EmbeddingManagement_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                com.google.cloud.aiplatform.v1beta1.FeatureOnlineStore.EmbeddingManagement.class,
                com.google.cloud.aiplatform.v1beta1.FeatureOnlineStore.EmbeddingManagement.Builder
                    .class);
      }

      // Construct using
      // com.google.cloud.aiplatform.v1beta1.FeatureOnlineStore.EmbeddingManagement.newBuilder()
      private Builder() {}

      private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
        super(parent);
      }

      @java.lang.Override
      public Builder clear() {
        super.clear();
        bitField0_ = 0;
        enabled_ = false;
        return this;
      }

      @java.lang.Override
      public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
        return com.google.cloud.aiplatform.v1beta1.FeatureOnlineStoreProto
            .internal_static_google_cloud_aiplatform_v1beta1_FeatureOnlineStore_EmbeddingManagement_descriptor;
      }

      @java.lang.Override
      public com.google.cloud.aiplatform.v1beta1.FeatureOnlineStore.EmbeddingManagement
          getDefaultInstanceForType() {
        return com.google.cloud.aiplatform.v1beta1.FeatureOnlineStore.EmbeddingManagement
            .getDefaultInstance();
      }

      @java.lang.Override
      public com.google.cloud.aiplatform.v1beta1.FeatureOnlineStore.EmbeddingManagement build() {
        com.google.cloud.aiplatform.v1beta1.FeatureOnlineStore.EmbeddingManagement result =
            buildPartial();
        if (!result.isInitialized()) {
          throw newUninitializedMessageException(result);
        }
        return result;
      }

      @java.lang.Override
      public com.google.cloud.aiplatform.v1beta1.FeatureOnlineStore.EmbeddingManagement
          buildPartial() {
        com.google.cloud.aiplatform.v1beta1.FeatureOnlineStore.EmbeddingManagement result =
            new com.google.cloud.aiplatform.v1beta1.FeatureOnlineStore.EmbeddingManagement(this);
        if (bitField0_ != 0) {
          buildPartial0(result);
        }
        onBuilt();
        return result;
      }

      private void buildPartial0(
          com.google.cloud.aiplatform.v1beta1.FeatureOnlineStore.EmbeddingManagement result) {
        int from_bitField0_ = bitField0_;
        if (((from_bitField0_ & 0x00000001) != 0)) {
          result.enabled_ = enabled_;
        }
      }

      @java.lang.Override
      public Builder clone() {
        return super.clone();
      }

      @java.lang.Override
      public Builder setField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.setField(field, value);
      }

      @java.lang.Override
      public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
        return super.clearField(field);
      }

      @java.lang.Override
      public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
        return super.clearOneof(oneof);
      }

      @java.lang.Override
      public Builder setRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          int index,
          java.lang.Object value) {
        return super.setRepeatedField(field, index, value);
      }

      @java.lang.Override
      public Builder addRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.addRepeatedField(field, value);
      }

      @java.lang.Override
      public Builder mergeFrom(com.google.protobuf.Message other) {
        if (other
            instanceof com.google.cloud.aiplatform.v1beta1.FeatureOnlineStore.EmbeddingManagement) {
          return mergeFrom(
              (com.google.cloud.aiplatform.v1beta1.FeatureOnlineStore.EmbeddingManagement) other);
        } else {
          super.mergeFrom(other);
          return this;
        }
      }

      public Builder mergeFrom(
          com.google.cloud.aiplatform.v1beta1.FeatureOnlineStore.EmbeddingManagement other) {
        if (other
            == com.google.cloud.aiplatform.v1beta1.FeatureOnlineStore.EmbeddingManagement
                .getDefaultInstance()) return this;
        if (other.getEnabled() != false) {
          setEnabled(other.getEnabled());
        }
        this.mergeUnknownFields(other.getUnknownFields());
        onChanged();
        return this;
      }

      @java.lang.Override
      public final boolean isInitialized() {
        return true;
      }

      @java.lang.Override
      public Builder mergeFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        if (extensionRegistry == null) {
          throw new java.lang.NullPointerException();
        }
        try {
          boolean done = false;
          while (!done) {
            int tag = input.readTag();
            switch (tag) {
              case 0:
                done = true;
                break;
              case 8:
                {
                  enabled_ = input.readBool();
                  bitField0_ |= 0x00000001;
                  break;
                } // case 8
              default:
                {
                  if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                    done = true; // was an endgroup tag
                  }
                  break;
                } // default:
            } // switch (tag)
          } // while (!done)
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          throw e.unwrapIOException();
        } finally {
          onChanged();
        } // finally
        return this;
      }

      private int bitField0_;

      private boolean enabled_;
      /**
       *
       *
       * <pre>
       * Optional. Immutable. Whether to enable embedding management in this
       * FeatureOnlineStore. It's immutable after creation to ensure the
       * FeatureOnlineStore availability.
       * </pre>
       *
       * <code>
       * bool enabled = 1 [(.google.api.field_behavior) = OPTIONAL, (.google.api.field_behavior) = IMMUTABLE];
       * </code>
       *
       * @return The enabled.
       */
      @java.lang.Override
      public boolean getEnabled() {
        return enabled_;
      }
      /**
       *
       *
       * <pre>
       * Optional. Immutable. Whether to enable embedding management in this
       * FeatureOnlineStore. It's immutable after creation to ensure the
       * FeatureOnlineStore availability.
       * </pre>
       *
       * <code>
       * bool enabled = 1 [(.google.api.field_behavior) = OPTIONAL, (.google.api.field_behavior) = IMMUTABLE];
       * </code>
       *
       * @param value The enabled to set.
       * @return This builder for chaining.
       */
      public Builder setEnabled(boolean value) {

        enabled_ = value;
        bitField0_ |= 0x00000001;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Optional. Immutable. Whether to enable embedding management in this
       * FeatureOnlineStore. It's immutable after creation to ensure the
       * FeatureOnlineStore availability.
       * </pre>
       *
       * <code>
       * bool enabled = 1 [(.google.api.field_behavior) = OPTIONAL, (.google.api.field_behavior) = IMMUTABLE];
       * </code>
       *
       * @return This builder for chaining.
       */
      public Builder clearEnabled() {
        bitField0_ = (bitField0_ & ~0x00000001);
        enabled_ = false;
        onChanged();
        return this;
      }

      @java.lang.Override
      public final Builder setUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.setUnknownFields(unknownFields);
      }

      @java.lang.Override
      public final Builder mergeUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.mergeUnknownFields(unknownFields);
      }

      // @@protoc_insertion_point(builder_scope:google.cloud.aiplatform.v1beta1.FeatureOnlineStore.EmbeddingManagement)
    }

    // @@protoc_insertion_point(class_scope:google.cloud.aiplatform.v1beta1.FeatureOnlineStore.EmbeddingManagement)
    private static final com.google.cloud.aiplatform.v1beta1.FeatureOnlineStore.EmbeddingManagement
        DEFAULT_INSTANCE;

    static {
      DEFAULT_INSTANCE =
          new com.google.cloud.aiplatform.v1beta1.FeatureOnlineStore.EmbeddingManagement();
    }

    public static com.google.cloud.aiplatform.v1beta1.FeatureOnlineStore.EmbeddingManagement
        getDefaultInstance() {
      return DEFAULT_INSTANCE;
    }

    private static final com.google.protobuf.Parser<EmbeddingManagement> PARSER =
        new com.google.protobuf.AbstractParser<EmbeddingManagement>() {
          @java.lang.Override
          public EmbeddingManagement parsePartialFrom(
              com.google.protobuf.CodedInputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
            Builder builder = newBuilder();
            try {
              builder.mergeFrom(input, extensionRegistry);
            } catch (com.google.protobuf.InvalidProtocolBufferException e) {
              throw e.setUnfinishedMessage(builder.buildPartial());
            } catch (com.google.protobuf.UninitializedMessageException e) {
              throw e.asInvalidProtocolBufferException()
                  .setUnfinishedMessage(builder.buildPartial());
            } catch (java.io.IOException e) {
              throw new com.google.protobuf.InvalidProtocolBufferException(e)
                  .setUnfinishedMessage(builder.buildPartial());
            }
            return builder.buildPartial();
          }
        };

    public static com.google.protobuf.Parser<EmbeddingManagement> parser() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.protobuf.Parser<EmbeddingManagement> getParserForType() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.cloud.aiplatform.v1beta1.FeatureOnlineStore.EmbeddingManagement
        getDefaultInstanceForType() {
      return DEFAULT_INSTANCE;
    }
  }

  private int bitField0_;
  private int storageTypeCase_ = 0;

  @SuppressWarnings("serial")
  private java.lang.Object storageType_;

  public enum StorageTypeCase
      implements
          com.google.protobuf.Internal.EnumLite,
          com.google.protobuf.AbstractMessage.InternalOneOfEnum {
    BIGTABLE(8),
    OPTIMIZED(12),
    STORAGETYPE_NOT_SET(0);
    private final int value;

    private StorageTypeCase(int value) {
      this.value = value;
    }
    /**
     * @param value The number of the enum to look for.
     * @return The enum associated with the given number.
     * @deprecated Use {@link #forNumber(int)} instead.
     */
    @java.lang.Deprecated
    public static StorageTypeCase valueOf(int value) {
      return forNumber(value);
    }

    public static StorageTypeCase forNumber(int value) {
      switch (value) {
        case 8:
          return BIGTABLE;
        case 12:
          return OPTIMIZED;
        case 0:
          return STORAGETYPE_NOT_SET;
        default:
          return null;
      }
    }

    public int getNumber() {
      return this.value;
    }
  };

  public StorageTypeCase getStorageTypeCase() {
    return StorageTypeCase.forNumber(storageTypeCase_);
  }

  public static final int BIGTABLE_FIELD_NUMBER = 8;
  /**
   *
   *
   * <pre>
   * Contains settings for the Cloud Bigtable instance that will be created
   * to serve featureValues for all FeatureViews under this
   * FeatureOnlineStore.
   * </pre>
   *
   * <code>.google.cloud.aiplatform.v1beta1.FeatureOnlineStore.Bigtable bigtable = 8;</code>
   *
   * @return Whether the bigtable field is set.
   */
  @java.lang.Override
  public boolean hasBigtable() {
    return storageTypeCase_ == 8;
  }
  /**
   *
   *
   * <pre>
   * Contains settings for the Cloud Bigtable instance that will be created
   * to serve featureValues for all FeatureViews under this
   * FeatureOnlineStore.
   * </pre>
   *
   * <code>.google.cloud.aiplatform.v1beta1.FeatureOnlineStore.Bigtable bigtable = 8;</code>
   *
   * @return The bigtable.
   */
  @java.lang.Override
  public com.google.cloud.aiplatform.v1beta1.FeatureOnlineStore.Bigtable getBigtable() {
    if (storageTypeCase_ == 8) {
      return (com.google.cloud.aiplatform.v1beta1.FeatureOnlineStore.Bigtable) storageType_;
    }
    return com.google.cloud.aiplatform.v1beta1.FeatureOnlineStore.Bigtable.getDefaultInstance();
  }
  /**
   *
   *
   * <pre>
   * Contains settings for the Cloud Bigtable instance that will be created
   * to serve featureValues for all FeatureViews under this
   * FeatureOnlineStore.
   * </pre>
   *
   * <code>.google.cloud.aiplatform.v1beta1.FeatureOnlineStore.Bigtable bigtable = 8;</code>
   */
  @java.lang.Override
  public com.google.cloud.aiplatform.v1beta1.FeatureOnlineStore.BigtableOrBuilder
      getBigtableOrBuilder() {
    if (storageTypeCase_ == 8) {
      return (com.google.cloud.aiplatform.v1beta1.FeatureOnlineStore.Bigtable) storageType_;
    }
    return com.google.cloud.aiplatform.v1beta1.FeatureOnlineStore.Bigtable.getDefaultInstance();
  }

  public static final int OPTIMIZED_FIELD_NUMBER = 12;
  /**
   *
   *
   * <pre>
   * Contains settings for the Optimized store that will be created
   * to serve featureValues for all FeatureViews under this
   * FeatureOnlineStore. When choose Optimized storage type, need to set
   * [PrivateServiceConnectConfig.enable_private_service_connect][google.cloud.aiplatform.v1beta1.PrivateServiceConnectConfig.enable_private_service_connect]
   * to use private endpoint. Otherwise will use public endpoint by default.
   * </pre>
   *
   * <code>.google.cloud.aiplatform.v1beta1.FeatureOnlineStore.Optimized optimized = 12;</code>
   *
   * @return Whether the optimized field is set.
   */
  @java.lang.Override
  public boolean hasOptimized() {
    return storageTypeCase_ == 12;
  }
  /**
   *
   *
   * <pre>
   * Contains settings for the Optimized store that will be created
   * to serve featureValues for all FeatureViews under this
   * FeatureOnlineStore. When choose Optimized storage type, need to set
   * [PrivateServiceConnectConfig.enable_private_service_connect][google.cloud.aiplatform.v1beta1.PrivateServiceConnectConfig.enable_private_service_connect]
   * to use private endpoint. Otherwise will use public endpoint by default.
   * </pre>
   *
   * <code>.google.cloud.aiplatform.v1beta1.FeatureOnlineStore.Optimized optimized = 12;</code>
   *
   * @return The optimized.
   */
  @java.lang.Override
  public com.google.cloud.aiplatform.v1beta1.FeatureOnlineStore.Optimized getOptimized() {
    if (storageTypeCase_ == 12) {
      return (com.google.cloud.aiplatform.v1beta1.FeatureOnlineStore.Optimized) storageType_;
    }
    return com.google.cloud.aiplatform.v1beta1.FeatureOnlineStore.Optimized.getDefaultInstance();
  }
  /**
   *
   *
   * <pre>
   * Contains settings for the Optimized store that will be created
   * to serve featureValues for all FeatureViews under this
   * FeatureOnlineStore. When choose Optimized storage type, need to set
   * [PrivateServiceConnectConfig.enable_private_service_connect][google.cloud.aiplatform.v1beta1.PrivateServiceConnectConfig.enable_private_service_connect]
   * to use private endpoint. Otherwise will use public endpoint by default.
   * </pre>
   *
   * <code>.google.cloud.aiplatform.v1beta1.FeatureOnlineStore.Optimized optimized = 12;</code>
   */
  @java.lang.Override
  public com.google.cloud.aiplatform.v1beta1.FeatureOnlineStore.OptimizedOrBuilder
      getOptimizedOrBuilder() {
    if (storageTypeCase_ == 12) {
      return (com.google.cloud.aiplatform.v1beta1.FeatureOnlineStore.Optimized) storageType_;
    }
    return com.google.cloud.aiplatform.v1beta1.FeatureOnlineStore.Optimized.getDefaultInstance();
  }

  public static final int NAME_FIELD_NUMBER = 1;

  @SuppressWarnings("serial")
  private volatile java.lang.Object name_ = "";
  /**
   *
   *
   * <pre>
   * Identifier. Name of the FeatureOnlineStore. Format:
   * `projects/{project}/locations/{location}/featureOnlineStores/{featureOnlineStore}`
   * </pre>
   *
   * <code>string name = 1 [(.google.api.field_behavior) = IDENTIFIER];</code>
   *
   * @return The name.
   */
  @java.lang.Override
  public java.lang.String getName() {
    java.lang.Object ref = name_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      name_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Identifier. Name of the FeatureOnlineStore. Format:
   * `projects/{project}/locations/{location}/featureOnlineStores/{featureOnlineStore}`
   * </pre>
   *
   * <code>string name = 1 [(.google.api.field_behavior) = IDENTIFIER];</code>
   *
   * @return The bytes for name.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getNameBytes() {
    java.lang.Object ref = name_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      name_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int CREATE_TIME_FIELD_NUMBER = 3;
  private com.google.protobuf.Timestamp createTime_;
  /**
   *
   *
   * <pre>
   * Output only. Timestamp when this FeatureOnlineStore was created.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp create_time = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return Whether the createTime field is set.
   */
  @java.lang.Override
  public boolean hasCreateTime() {
    return ((bitField0_ & 0x00000001) != 0);
  }
  /**
   *
   *
   * <pre>
   * Output only. Timestamp when this FeatureOnlineStore was created.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp create_time = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return The createTime.
   */
  @java.lang.Override
  public com.google.protobuf.Timestamp getCreateTime() {
    return createTime_ == null ? com.google.protobuf.Timestamp.getDefaultInstance() : createTime_;
  }
  /**
   *
   *
   * <pre>
   * Output only. Timestamp when this FeatureOnlineStore was created.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp create_time = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   */
  @java.lang.Override
  public com.google.protobuf.TimestampOrBuilder getCreateTimeOrBuilder() {
    return createTime_ == null ? com.google.protobuf.Timestamp.getDefaultInstance() : createTime_;
  }

  public static final int UPDATE_TIME_FIELD_NUMBER = 4;
  private com.google.protobuf.Timestamp updateTime_;
  /**
   *
   *
   * <pre>
   * Output only. Timestamp when this FeatureOnlineStore was last updated.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp update_time = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return Whether the updateTime field is set.
   */
  @java.lang.Override
  public boolean hasUpdateTime() {
    return ((bitField0_ & 0x00000002) != 0);
  }
  /**
   *
   *
   * <pre>
   * Output only. Timestamp when this FeatureOnlineStore was last updated.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp update_time = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return The updateTime.
   */
  @java.lang.Override
  public com.google.protobuf.Timestamp getUpdateTime() {
    return updateTime_ == null ? com.google.protobuf.Timestamp.getDefaultInstance() : updateTime_;
  }
  /**
   *
   *
   * <pre>
   * Output only. Timestamp when this FeatureOnlineStore was last updated.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp update_time = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   */
  @java.lang.Override
  public com.google.protobuf.TimestampOrBuilder getUpdateTimeOrBuilder() {
    return updateTime_ == null ? com.google.protobuf.Timestamp.getDefaultInstance() : updateTime_;
  }

  public static final int ETAG_FIELD_NUMBER = 5;

  @SuppressWarnings("serial")
  private volatile java.lang.Object etag_ = "";
  /**
   *
   *
   * <pre>
   * Optional. Used to perform consistent read-modify-write updates. If not set,
   * a blind "overwrite" update happens.
   * </pre>
   *
   * <code>string etag = 5 [(.google.api.field_behavior) = OPTIONAL];</code>
   *
   * @return The etag.
   */
  @java.lang.Override
  public java.lang.String getEtag() {
    java.lang.Object ref = etag_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      etag_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Optional. Used to perform consistent read-modify-write updates. If not set,
   * a blind "overwrite" update happens.
   * </pre>
   *
   * <code>string etag = 5 [(.google.api.field_behavior) = OPTIONAL];</code>
   *
   * @return The bytes for etag.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getEtagBytes() {
    java.lang.Object ref = etag_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      etag_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int LABELS_FIELD_NUMBER = 6;

  private static final class LabelsDefaultEntryHolder {
    static final com.google.protobuf.MapEntry<java.lang.String, java.lang.String> defaultEntry =
        com.google.protobuf.MapEntry.<java.lang.String, java.lang.String>newDefaultInstance(
            com.google.cloud.aiplatform.v1beta1.FeatureOnlineStoreProto
                .internal_static_google_cloud_aiplatform_v1beta1_FeatureOnlineStore_LabelsEntry_descriptor,
            com.google.protobuf.WireFormat.FieldType.STRING,
            "",
            com.google.protobuf.WireFormat.FieldType.STRING,
            "");
  }

  @SuppressWarnings("serial")
  private com.google.protobuf.MapField<java.lang.String, java.lang.String> labels_;

  private com.google.protobuf.MapField<java.lang.String, java.lang.String> internalGetLabels() {
    if (labels_ == null) {
      return com.google.protobuf.MapField.emptyMapField(LabelsDefaultEntryHolder.defaultEntry);
    }
    return labels_;
  }

  public int getLabelsCount() {
    return internalGetLabels().getMap().size();
  }
  /**
   *
   *
   * <pre>
   * Optional. The labels with user-defined metadata to organize your
   * FeatureOnlineStore.
   *
   * Label keys and values can be no longer than 64 characters
   * (Unicode codepoints), can only contain lowercase letters, numeric
   * characters, underscores and dashes. International characters are allowed.
   *
   * See https://goo.gl/xmQnxf for more information on and examples of labels.
   * No more than 64 user labels can be associated with one
   * FeatureOnlineStore(System labels are excluded)." System reserved label keys
   * are prefixed with "aiplatform.googleapis.com/" and are immutable.
   * </pre>
   *
   * <code>map&lt;string, string&gt; labels = 6 [(.google.api.field_behavior) = OPTIONAL];</code>
   */
  @java.lang.Override
  public boolean containsLabels(java.lang.String key) {
    if (key == null) {
      throw new NullPointerException("map key");
    }
    return internalGetLabels().getMap().containsKey(key);
  }
  /** Use {@link #getLabelsMap()} instead. */
  @java.lang.Override
  @java.lang.Deprecated
  public java.util.Map<java.lang.String, java.lang.String> getLabels() {
    return getLabelsMap();
  }
  /**
   *
   *
   * <pre>
   * Optional. The labels with user-defined metadata to organize your
   * FeatureOnlineStore.
   *
   * Label keys and values can be no longer than 64 characters
   * (Unicode codepoints), can only contain lowercase letters, numeric
   * characters, underscores and dashes. International characters are allowed.
   *
   * See https://goo.gl/xmQnxf for more information on and examples of labels.
   * No more than 64 user labels can be associated with one
   * FeatureOnlineStore(System labels are excluded)." System reserved label keys
   * are prefixed with "aiplatform.googleapis.com/" and are immutable.
   * </pre>
   *
   * <code>map&lt;string, string&gt; labels = 6 [(.google.api.field_behavior) = OPTIONAL];</code>
   */
  @java.lang.Override
  public java.util.Map<java.lang.String, java.lang.String> getLabelsMap() {
    return internalGetLabels().getMap();
  }
  /**
   *
   *
   * <pre>
   * Optional. The labels with user-defined metadata to organize your
   * FeatureOnlineStore.
   *
   * Label keys and values can be no longer than 64 characters
   * (Unicode codepoints), can only contain lowercase letters, numeric
   * characters, underscores and dashes. International characters are allowed.
   *
   * See https://goo.gl/xmQnxf for more information on and examples of labels.
   * No more than 64 user labels can be associated with one
   * FeatureOnlineStore(System labels are excluded)." System reserved label keys
   * are prefixed with "aiplatform.googleapis.com/" and are immutable.
   * </pre>
   *
   * <code>map&lt;string, string&gt; labels = 6 [(.google.api.field_behavior) = OPTIONAL];</code>
   */
  @java.lang.Override
  public /* nullable */ java.lang.String getLabelsOrDefault(
      java.lang.String key,
      /* nullable */
      java.lang.String defaultValue) {
    if (key == null) {
      throw new NullPointerException("map key");
    }
    java.util.Map<java.lang.String, java.lang.String> map = internalGetLabels().getMap();
    return map.containsKey(key) ? map.get(key) : defaultValue;
  }
  /**
   *
   *
   * <pre>
   * Optional. The labels with user-defined metadata to organize your
   * FeatureOnlineStore.
   *
   * Label keys and values can be no longer than 64 characters
   * (Unicode codepoints), can only contain lowercase letters, numeric
   * characters, underscores and dashes. International characters are allowed.
   *
   * See https://goo.gl/xmQnxf for more information on and examples of labels.
   * No more than 64 user labels can be associated with one
   * FeatureOnlineStore(System labels are excluded)." System reserved label keys
   * are prefixed with "aiplatform.googleapis.com/" and are immutable.
   * </pre>
   *
   * <code>map&lt;string, string&gt; labels = 6 [(.google.api.field_behavior) = OPTIONAL];</code>
   */
  @java.lang.Override
  public java.lang.String getLabelsOrThrow(java.lang.String key) {
    if (key == null) {
      throw new NullPointerException("map key");
    }
    java.util.Map<java.lang.String, java.lang.String> map = internalGetLabels().getMap();
    if (!map.containsKey(key)) {
      throw new java.lang.IllegalArgumentException();
    }
    return map.get(key);
  }

  public static final int STATE_FIELD_NUMBER = 7;
  private int state_ = 0;
  /**
   *
   *
   * <pre>
   * Output only. State of the featureOnlineStore.
   * </pre>
   *
   * <code>
   * .google.cloud.aiplatform.v1beta1.FeatureOnlineStore.State state = 7 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return The enum numeric value on the wire for state.
   */
  @java.lang.Override
  public int getStateValue() {
    return state_;
  }
  /**
   *
   *
   * <pre>
   * Output only. State of the featureOnlineStore.
   * </pre>
   *
   * <code>
   * .google.cloud.aiplatform.v1beta1.FeatureOnlineStore.State state = 7 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return The state.
   */
  @java.lang.Override
  public com.google.cloud.aiplatform.v1beta1.FeatureOnlineStore.State getState() {
    com.google.cloud.aiplatform.v1beta1.FeatureOnlineStore.State result =
        com.google.cloud.aiplatform.v1beta1.FeatureOnlineStore.State.forNumber(state_);
    return result == null
        ? com.google.cloud.aiplatform.v1beta1.FeatureOnlineStore.State.UNRECOGNIZED
        : result;
  }

  public static final int DEDICATED_SERVING_ENDPOINT_FIELD_NUMBER = 10;
  private com.google.cloud.aiplatform.v1beta1.FeatureOnlineStore.DedicatedServingEndpoint
      dedicatedServingEndpoint_;
  /**
   *
   *
   * <pre>
   * Optional. The dedicated serving endpoint for this FeatureOnlineStore, which
   * is different from common Vertex service endpoint.
   * </pre>
   *
   * <code>
   * .google.cloud.aiplatform.v1beta1.FeatureOnlineStore.DedicatedServingEndpoint dedicated_serving_endpoint = 10 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   *
   * @return Whether the dedicatedServingEndpoint field is set.
   */
  @java.lang.Override
  public boolean hasDedicatedServingEndpoint() {
    return ((bitField0_ & 0x00000004) != 0);
  }
  /**
   *
   *
   * <pre>
   * Optional. The dedicated serving endpoint for this FeatureOnlineStore, which
   * is different from common Vertex service endpoint.
   * </pre>
   *
   * <code>
   * .google.cloud.aiplatform.v1beta1.FeatureOnlineStore.DedicatedServingEndpoint dedicated_serving_endpoint = 10 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   *
   * @return The dedicatedServingEndpoint.
   */
  @java.lang.Override
  public com.google.cloud.aiplatform.v1beta1.FeatureOnlineStore.DedicatedServingEndpoint
      getDedicatedServingEndpoint() {
    return dedicatedServingEndpoint_ == null
        ? com.google.cloud.aiplatform.v1beta1.FeatureOnlineStore.DedicatedServingEndpoint
            .getDefaultInstance()
        : dedicatedServingEndpoint_;
  }
  /**
   *
   *
   * <pre>
   * Optional. The dedicated serving endpoint for this FeatureOnlineStore, which
   * is different from common Vertex service endpoint.
   * </pre>
   *
   * <code>
   * .google.cloud.aiplatform.v1beta1.FeatureOnlineStore.DedicatedServingEndpoint dedicated_serving_endpoint = 10 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.aiplatform.v1beta1.FeatureOnlineStore.DedicatedServingEndpointOrBuilder
      getDedicatedServingEndpointOrBuilder() {
    return dedicatedServingEndpoint_ == null
        ? com.google.cloud.aiplatform.v1beta1.FeatureOnlineStore.DedicatedServingEndpoint
            .getDefaultInstance()
        : dedicatedServingEndpoint_;
  }

  public static final int EMBEDDING_MANAGEMENT_FIELD_NUMBER = 11;
  private com.google.cloud.aiplatform.v1beta1.FeatureOnlineStore.EmbeddingManagement
      embeddingManagement_;
  /**
   *
   *
   * <pre>
   * Optional. The settings for embedding management in FeatureOnlineStore.
   * </pre>
   *
   * <code>
   * .google.cloud.aiplatform.v1beta1.FeatureOnlineStore.EmbeddingManagement embedding_management = 11 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   *
   * @return Whether the embeddingManagement field is set.
   */
  @java.lang.Override
  public boolean hasEmbeddingManagement() {
    return ((bitField0_ & 0x00000008) != 0);
  }
  /**
   *
   *
   * <pre>
   * Optional. The settings for embedding management in FeatureOnlineStore.
   * </pre>
   *
   * <code>
   * .google.cloud.aiplatform.v1beta1.FeatureOnlineStore.EmbeddingManagement embedding_management = 11 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   *
   * @return The embeddingManagement.
   */
  @java.lang.Override
  public com.google.cloud.aiplatform.v1beta1.FeatureOnlineStore.EmbeddingManagement
      getEmbeddingManagement() {
    return embeddingManagement_ == null
        ? com.google.cloud.aiplatform.v1beta1.FeatureOnlineStore.EmbeddingManagement
            .getDefaultInstance()
        : embeddingManagement_;
  }
  /**
   *
   *
   * <pre>
   * Optional. The settings for embedding management in FeatureOnlineStore.
   * </pre>
   *
   * <code>
   * .google.cloud.aiplatform.v1beta1.FeatureOnlineStore.EmbeddingManagement embedding_management = 11 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.aiplatform.v1beta1.FeatureOnlineStore.EmbeddingManagementOrBuilder
      getEmbeddingManagementOrBuilder() {
    return embeddingManagement_ == null
        ? com.google.cloud.aiplatform.v1beta1.FeatureOnlineStore.EmbeddingManagement
            .getDefaultInstance()
        : embeddingManagement_;
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(name_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 1, name_);
    }
    if (((bitField0_ & 0x00000001) != 0)) {
      output.writeMessage(3, getCreateTime());
    }
    if (((bitField0_ & 0x00000002) != 0)) {
      output.writeMessage(4, getUpdateTime());
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(etag_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 5, etag_);
    }
    com.google.protobuf.GeneratedMessageV3.serializeStringMapTo(
        output, internalGetLabels(), LabelsDefaultEntryHolder.defaultEntry, 6);
    if (state_
        != com.google.cloud.aiplatform.v1beta1.FeatureOnlineStore.State.STATE_UNSPECIFIED
            .getNumber()) {
      output.writeEnum(7, state_);
    }
    if (storageTypeCase_ == 8) {
      output.writeMessage(
          8, (com.google.cloud.aiplatform.v1beta1.FeatureOnlineStore.Bigtable) storageType_);
    }
    if (((bitField0_ & 0x00000004) != 0)) {
      output.writeMessage(10, getDedicatedServingEndpoint());
    }
    if (((bitField0_ & 0x00000008) != 0)) {
      output.writeMessage(11, getEmbeddingManagement());
    }
    if (storageTypeCase_ == 12) {
      output.writeMessage(
          12, (com.google.cloud.aiplatform.v1beta1.FeatureOnlineStore.Optimized) storageType_);
    }
    getUnknownFields().writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(name_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(1, name_);
    }
    if (((bitField0_ & 0x00000001) != 0)) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(3, getCreateTime());
    }
    if (((bitField0_ & 0x00000002) != 0)) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(4, getUpdateTime());
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(etag_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(5, etag_);
    }
    for (java.util.Map.Entry<java.lang.String, java.lang.String> entry :
        internalGetLabels().getMap().entrySet()) {
      com.google.protobuf.MapEntry<java.lang.String, java.lang.String> labels__ =
          LabelsDefaultEntryHolder.defaultEntry
              .newBuilderForType()
              .setKey(entry.getKey())
              .setValue(entry.getValue())
              .build();
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(6, labels__);
    }
    if (state_
        != com.google.cloud.aiplatform.v1beta1.FeatureOnlineStore.State.STATE_UNSPECIFIED
            .getNumber()) {
      size += com.google.protobuf.CodedOutputStream.computeEnumSize(7, state_);
    }
    if (storageTypeCase_ == 8) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(
              8, (com.google.cloud.aiplatform.v1beta1.FeatureOnlineStore.Bigtable) storageType_);
    }
    if (((bitField0_ & 0x00000004) != 0)) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(
              10, getDedicatedServingEndpoint());
    }
    if (((bitField0_ & 0x00000008) != 0)) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(11, getEmbeddingManagement());
    }
    if (storageTypeCase_ == 12) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(
              12, (com.google.cloud.aiplatform.v1beta1.FeatureOnlineStore.Optimized) storageType_);
    }
    size += getUnknownFields().getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.cloud.aiplatform.v1beta1.FeatureOnlineStore)) {
      return super.equals(obj);
    }
    com.google.cloud.aiplatform.v1beta1.FeatureOnlineStore other =
        (com.google.cloud.aiplatform.v1beta1.FeatureOnlineStore) obj;

    if (!getName().equals(other.getName())) return false;
    if (hasCreateTime() != other.hasCreateTime()) return false;
    if (hasCreateTime()) {
      if (!getCreateTime().equals(other.getCreateTime())) return false;
    }
    if (hasUpdateTime() != other.hasUpdateTime()) return false;
    if (hasUpdateTime()) {
      if (!getUpdateTime().equals(other.getUpdateTime())) return false;
    }
    if (!getEtag().equals(other.getEtag())) return false;
    if (!internalGetLabels().equals(other.internalGetLabels())) return false;
    if (state_ != other.state_) return false;
    if (hasDedicatedServingEndpoint() != other.hasDedicatedServingEndpoint()) return false;
    if (hasDedicatedServingEndpoint()) {
      if (!getDedicatedServingEndpoint().equals(other.getDedicatedServingEndpoint())) return false;
    }
    if (hasEmbeddingManagement() != other.hasEmbeddingManagement()) return false;
    if (hasEmbeddingManagement()) {
      if (!getEmbeddingManagement().equals(other.getEmbeddingManagement())) return false;
    }
    if (!getStorageTypeCase().equals(other.getStorageTypeCase())) return false;
    switch (storageTypeCase_) {
      case 8:
        if (!getBigtable().equals(other.getBigtable())) return false;
        break;
      case 12:
        if (!getOptimized().equals(other.getOptimized())) return false;
        break;
      case 0:
      default:
    }
    if (!getUnknownFields().equals(other.getUnknownFields())) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    hash = (37 * hash) + NAME_FIELD_NUMBER;
    hash = (53 * hash) + getName().hashCode();
    if (hasCreateTime()) {
      hash = (37 * hash) + CREATE_TIME_FIELD_NUMBER;
      hash = (53 * hash) + getCreateTime().hashCode();
    }
    if (hasUpdateTime()) {
      hash = (37 * hash) + UPDATE_TIME_FIELD_NUMBER;
      hash = (53 * hash) + getUpdateTime().hashCode();
    }
    hash = (37 * hash) + ETAG_FIELD_NUMBER;
    hash = (53 * hash) + getEtag().hashCode();
    if (!internalGetLabels().getMap().isEmpty()) {
      hash = (37 * hash) + LABELS_FIELD_NUMBER;
      hash = (53 * hash) + internalGetLabels().hashCode();
    }
    hash = (37 * hash) + STATE_FIELD_NUMBER;
    hash = (53 * hash) + state_;
    if (hasDedicatedServingEndpoint()) {
      hash = (37 * hash) + DEDICATED_SERVING_ENDPOINT_FIELD_NUMBER;
      hash = (53 * hash) + getDedicatedServingEndpoint().hashCode();
    }
    if (hasEmbeddingManagement()) {
      hash = (37 * hash) + EMBEDDING_MANAGEMENT_FIELD_NUMBER;
      hash = (53 * hash) + getEmbeddingManagement().hashCode();
    }
    switch (storageTypeCase_) {
      case 8:
        hash = (37 * hash) + BIGTABLE_FIELD_NUMBER;
        hash = (53 * hash) + getBigtable().hashCode();
        break;
      case 12:
        hash = (37 * hash) + OPTIMIZED_FIELD_NUMBER;
        hash = (53 * hash) + getOptimized().hashCode();
        break;
      case 0:
      default:
    }
    hash = (29 * hash) + getUnknownFields().hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.cloud.aiplatform.v1beta1.FeatureOnlineStore parseFrom(
      java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.aiplatform.v1beta1.FeatureOnlineStore parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.aiplatform.v1beta1.FeatureOnlineStore parseFrom(
      com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.aiplatform.v1beta1.FeatureOnlineStore parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.aiplatform.v1beta1.FeatureOnlineStore parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.aiplatform.v1beta1.FeatureOnlineStore parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.aiplatform.v1beta1.FeatureOnlineStore parseFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.aiplatform.v1beta1.FeatureOnlineStore parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.aiplatform.v1beta1.FeatureOnlineStore parseDelimitedFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.cloud.aiplatform.v1beta1.FeatureOnlineStore parseDelimitedFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.aiplatform.v1beta1.FeatureOnlineStore parseFrom(
      com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.aiplatform.v1beta1.FeatureOnlineStore parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(
      com.google.cloud.aiplatform.v1beta1.FeatureOnlineStore prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }
  /**
   *
   *
   * <pre>
   * Vertex AI Feature Online Store provides a centralized repository for serving
   * ML features and embedding indexes at low latency. The Feature Online Store is
   * a top-level container.
   * </pre>
   *
   * Protobuf type {@code google.cloud.aiplatform.v1beta1.FeatureOnlineStore}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.cloud.aiplatform.v1beta1.FeatureOnlineStore)
      com.google.cloud.aiplatform.v1beta1.FeatureOnlineStoreOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.aiplatform.v1beta1.FeatureOnlineStoreProto
          .internal_static_google_cloud_aiplatform_v1beta1_FeatureOnlineStore_descriptor;
    }

    @SuppressWarnings({"rawtypes"})
    protected com.google.protobuf.MapFieldReflectionAccessor internalGetMapFieldReflection(
        int number) {
      switch (number) {
        case 6:
          return internalGetLabels();
        default:
          throw new RuntimeException("Invalid map field number: " + number);
      }
    }

    @SuppressWarnings({"rawtypes"})
    protected com.google.protobuf.MapFieldReflectionAccessor internalGetMutableMapFieldReflection(
        int number) {
      switch (number) {
        case 6:
          return internalGetMutableLabels();
        default:
          throw new RuntimeException("Invalid map field number: " + number);
      }
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.aiplatform.v1beta1.FeatureOnlineStoreProto
          .internal_static_google_cloud_aiplatform_v1beta1_FeatureOnlineStore_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.aiplatform.v1beta1.FeatureOnlineStore.class,
              com.google.cloud.aiplatform.v1beta1.FeatureOnlineStore.Builder.class);
    }

    // Construct using com.google.cloud.aiplatform.v1beta1.FeatureOnlineStore.newBuilder()
    private Builder() {
      maybeForceBuilderInitialization();
    }

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
      maybeForceBuilderInitialization();
    }

    private void maybeForceBuilderInitialization() {
      if (com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders) {
        getCreateTimeFieldBuilder();
        getUpdateTimeFieldBuilder();
        getDedicatedServingEndpointFieldBuilder();
        getEmbeddingManagementFieldBuilder();
      }
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      bitField0_ = 0;
      if (bigtableBuilder_ != null) {
        bigtableBuilder_.clear();
      }
      if (optimizedBuilder_ != null) {
        optimizedBuilder_.clear();
      }
      name_ = "";
      createTime_ = null;
      if (createTimeBuilder_ != null) {
        createTimeBuilder_.dispose();
        createTimeBuilder_ = null;
      }
      updateTime_ = null;
      if (updateTimeBuilder_ != null) {
        updateTimeBuilder_.dispose();
        updateTimeBuilder_ = null;
      }
      etag_ = "";
      internalGetMutableLabels().clear();
      state_ = 0;
      dedicatedServingEndpoint_ = null;
      if (dedicatedServingEndpointBuilder_ != null) {
        dedicatedServingEndpointBuilder_.dispose();
        dedicatedServingEndpointBuilder_ = null;
      }
      embeddingManagement_ = null;
      if (embeddingManagementBuilder_ != null) {
        embeddingManagementBuilder_.dispose();
        embeddingManagementBuilder_ = null;
      }
      storageTypeCase_ = 0;
      storageType_ = null;
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.cloud.aiplatform.v1beta1.FeatureOnlineStoreProto
          .internal_static_google_cloud_aiplatform_v1beta1_FeatureOnlineStore_descriptor;
    }

    @java.lang.Override
    public com.google.cloud.aiplatform.v1beta1.FeatureOnlineStore getDefaultInstanceForType() {
      return com.google.cloud.aiplatform.v1beta1.FeatureOnlineStore.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.cloud.aiplatform.v1beta1.FeatureOnlineStore build() {
      com.google.cloud.aiplatform.v1beta1.FeatureOnlineStore result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.cloud.aiplatform.v1beta1.FeatureOnlineStore buildPartial() {
      com.google.cloud.aiplatform.v1beta1.FeatureOnlineStore result =
          new com.google.cloud.aiplatform.v1beta1.FeatureOnlineStore(this);
      if (bitField0_ != 0) {
        buildPartial0(result);
      }
      buildPartialOneofs(result);
      onBuilt();
      return result;
    }

    private void buildPartial0(com.google.cloud.aiplatform.v1beta1.FeatureOnlineStore result) {
      int from_bitField0_ = bitField0_;
      if (((from_bitField0_ & 0x00000004) != 0)) {
        result.name_ = name_;
      }
      int to_bitField0_ = 0;
      if (((from_bitField0_ & 0x00000008) != 0)) {
        result.createTime_ = createTimeBuilder_ == null ? createTime_ : createTimeBuilder_.build();
        to_bitField0_ |= 0x00000001;
      }
      if (((from_bitField0_ & 0x00000010) != 0)) {
        result.updateTime_ = updateTimeBuilder_ == null ? updateTime_ : updateTimeBuilder_.build();
        to_bitField0_ |= 0x00000002;
      }
      if (((from_bitField0_ & 0x00000020) != 0)) {
        result.etag_ = etag_;
      }
      if (((from_bitField0_ & 0x00000040) != 0)) {
        result.labels_ = internalGetLabels();
        result.labels_.makeImmutable();
      }
      if (((from_bitField0_ & 0x00000080) != 0)) {
        result.state_ = state_;
      }
      if (((from_bitField0_ & 0x00000100) != 0)) {
        result.dedicatedServingEndpoint_ =
            dedicatedServingEndpointBuilder_ == null
                ? dedicatedServingEndpoint_
                : dedicatedServingEndpointBuilder_.build();
        to_bitField0_ |= 0x00000004;
      }
      if (((from_bitField0_ & 0x00000200) != 0)) {
        result.embeddingManagement_ =
            embeddingManagementBuilder_ == null
                ? embeddingManagement_
                : embeddingManagementBuilder_.build();
        to_bitField0_ |= 0x00000008;
      }
      result.bitField0_ |= to_bitField0_;
    }

    private void buildPartialOneofs(com.google.cloud.aiplatform.v1beta1.FeatureOnlineStore result) {
      result.storageTypeCase_ = storageTypeCase_;
      result.storageType_ = this.storageType_;
      if (storageTypeCase_ == 8 && bigtableBuilder_ != null) {
        result.storageType_ = bigtableBuilder_.build();
      }
      if (storageTypeCase_ == 12 && optimizedBuilder_ != null) {
        result.storageType_ = optimizedBuilder_.build();
      }
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.cloud.aiplatform.v1beta1.FeatureOnlineStore) {
        return mergeFrom((com.google.cloud.aiplatform.v1beta1.FeatureOnlineStore) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(com.google.cloud.aiplatform.v1beta1.FeatureOnlineStore other) {
      if (other == com.google.cloud.aiplatform.v1beta1.FeatureOnlineStore.getDefaultInstance())
        return this;
      if (!other.getName().isEmpty()) {
        name_ = other.name_;
        bitField0_ |= 0x00000004;
        onChanged();
      }
      if (other.hasCreateTime()) {
        mergeCreateTime(other.getCreateTime());
      }
      if (other.hasUpdateTime()) {
        mergeUpdateTime(other.getUpdateTime());
      }
      if (!other.getEtag().isEmpty()) {
        etag_ = other.etag_;
        bitField0_ |= 0x00000020;
        onChanged();
      }
      internalGetMutableLabels().mergeFrom(other.internalGetLabels());
      bitField0_ |= 0x00000040;
      if (other.state_ != 0) {
        setStateValue(other.getStateValue());
      }
      if (other.hasDedicatedServingEndpoint()) {
        mergeDedicatedServingEndpoint(other.getDedicatedServingEndpoint());
      }
      if (other.hasEmbeddingManagement()) {
        mergeEmbeddingManagement(other.getEmbeddingManagement());
      }
      switch (other.getStorageTypeCase()) {
        case BIGTABLE:
          {
            mergeBigtable(other.getBigtable());
            break;
          }
        case OPTIMIZED:
          {
            mergeOptimized(other.getOptimized());
            break;
          }
        case STORAGETYPE_NOT_SET:
          {
            break;
          }
      }
      this.mergeUnknownFields(other.getUnknownFields());
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 10:
              {
                name_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000004;
                break;
              } // case 10
            case 26:
              {
                input.readMessage(getCreateTimeFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000008;
                break;
              } // case 26
            case 34:
              {
                input.readMessage(getUpdateTimeFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000010;
                break;
              } // case 34
            case 42:
              {
                etag_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000020;
                break;
              } // case 42
            case 50:
              {
                com.google.protobuf.MapEntry<java.lang.String, java.lang.String> labels__ =
                    input.readMessage(
                        LabelsDefaultEntryHolder.defaultEntry.getParserForType(),
                        extensionRegistry);
                internalGetMutableLabels()
                    .getMutableMap()
                    .put(labels__.getKey(), labels__.getValue());
                bitField0_ |= 0x00000040;
                break;
              } // case 50
            case 56:
              {
                state_ = input.readEnum();
                bitField0_ |= 0x00000080;
                break;
              } // case 56
            case 66:
              {
                input.readMessage(getBigtableFieldBuilder().getBuilder(), extensionRegistry);
                storageTypeCase_ = 8;
                break;
              } // case 66
            case 82:
              {
                input.readMessage(
                    getDedicatedServingEndpointFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000100;
                break;
              } // case 82
            case 90:
              {
                input.readMessage(
                    getEmbeddingManagementFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000200;
                break;
              } // case 90
            case 98:
              {
                input.readMessage(getOptimizedFieldBuilder().getBuilder(), extensionRegistry);
                storageTypeCase_ = 12;
                break;
              } // case 98
            default:
              {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
          } // switch (tag)
        } // while (!done)
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.unwrapIOException();
      } finally {
        onChanged();
      } // finally
      return this;
    }

    private int storageTypeCase_ = 0;
    private java.lang.Object storageType_;

    public StorageTypeCase getStorageTypeCase() {
      return StorageTypeCase.forNumber(storageTypeCase_);
    }

    public Builder clearStorageType() {
      storageTypeCase_ = 0;
      storageType_ = null;
      onChanged();
      return this;
    }

    private int bitField0_;

    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.aiplatform.v1beta1.FeatureOnlineStore.Bigtable,
            com.google.cloud.aiplatform.v1beta1.FeatureOnlineStore.Bigtable.Builder,
            com.google.cloud.aiplatform.v1beta1.FeatureOnlineStore.BigtableOrBuilder>
        bigtableBuilder_;
    /**
     *
     *
     * <pre>
     * Contains settings for the Cloud Bigtable instance that will be created
     * to serve featureValues for all FeatureViews under this
     * FeatureOnlineStore.
     * </pre>
     *
     * <code>.google.cloud.aiplatform.v1beta1.FeatureOnlineStore.Bigtable bigtable = 8;</code>
     *
     * @return Whether the bigtable field is set.
     */
    @java.lang.Override
    public boolean hasBigtable() {
      return storageTypeCase_ == 8;
    }
    /**
     *
     *
     * <pre>
     * Contains settings for the Cloud Bigtable instance that will be created
     * to serve featureValues for all FeatureViews under this
     * FeatureOnlineStore.
     * </pre>
     *
     * <code>.google.cloud.aiplatform.v1beta1.FeatureOnlineStore.Bigtable bigtable = 8;</code>
     *
     * @return The bigtable.
     */
    @java.lang.Override
    public com.google.cloud.aiplatform.v1beta1.FeatureOnlineStore.Bigtable getBigtable() {
      if (bigtableBuilder_ == null) {
        if (storageTypeCase_ == 8) {
          return (com.google.cloud.aiplatform.v1beta1.FeatureOnlineStore.Bigtable) storageType_;
        }
        return com.google.cloud.aiplatform.v1beta1.FeatureOnlineStore.Bigtable.getDefaultInstance();
      } else {
        if (storageTypeCase_ == 8) {
          return bigtableBuilder_.getMessage();
        }
        return com.google.cloud.aiplatform.v1beta1.FeatureOnlineStore.Bigtable.getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * Contains settings for the Cloud Bigtable instance that will be created
     * to serve featureValues for all FeatureViews under this
     * FeatureOnlineStore.
     * </pre>
     *
     * <code>.google.cloud.aiplatform.v1beta1.FeatureOnlineStore.Bigtable bigtable = 8;</code>
     */
    public Builder setBigtable(
        com.google.cloud.aiplatform.v1beta1.FeatureOnlineStore.Bigtable value) {
      if (bigtableBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        storageType_ = value;
        onChanged();
      } else {
        bigtableBuilder_.setMessage(value);
      }
      storageTypeCase_ = 8;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Contains settings for the Cloud Bigtable instance that will be created
     * to serve featureValues for all FeatureViews under this
     * FeatureOnlineStore.
     * </pre>
     *
     * <code>.google.cloud.aiplatform.v1beta1.FeatureOnlineStore.Bigtable bigtable = 8;</code>
     */
    public Builder setBigtable(
        com.google.cloud.aiplatform.v1beta1.FeatureOnlineStore.Bigtable.Builder builderForValue) {
      if (bigtableBuilder_ == null) {
        storageType_ = builderForValue.build();
        onChanged();
      } else {
        bigtableBuilder_.setMessage(builderForValue.build());
      }
      storageTypeCase_ = 8;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Contains settings for the Cloud Bigtable instance that will be created
     * to serve featureValues for all FeatureViews under this
     * FeatureOnlineStore.
     * </pre>
     *
     * <code>.google.cloud.aiplatform.v1beta1.FeatureOnlineStore.Bigtable bigtable = 8;</code>
     */
    public Builder mergeBigtable(
        com.google.cloud.aiplatform.v1beta1.FeatureOnlineStore.Bigtable value) {
      if (bigtableBuilder_ == null) {
        if (storageTypeCase_ == 8
            && storageType_
                != com.google.cloud.aiplatform.v1beta1.FeatureOnlineStore.Bigtable
                    .getDefaultInstance()) {
          storageType_ =
              com.google.cloud.aiplatform.v1beta1.FeatureOnlineStore.Bigtable.newBuilder(
                      (com.google.cloud.aiplatform.v1beta1.FeatureOnlineStore.Bigtable)
                          storageType_)
                  .mergeFrom(value)
                  .buildPartial();
        } else {
          storageType_ = value;
        }
        onChanged();
      } else {
        if (storageTypeCase_ == 8) {
          bigtableBuilder_.mergeFrom(value);
        } else {
          bigtableBuilder_.setMessage(value);
        }
      }
      storageTypeCase_ = 8;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Contains settings for the Cloud Bigtable instance that will be created
     * to serve featureValues for all FeatureViews under this
     * FeatureOnlineStore.
     * </pre>
     *
     * <code>.google.cloud.aiplatform.v1beta1.FeatureOnlineStore.Bigtable bigtable = 8;</code>
     */
    public Builder clearBigtable() {
      if (bigtableBuilder_ == null) {
        if (storageTypeCase_ == 8) {
          storageTypeCase_ = 0;
          storageType_ = null;
          onChanged();
        }
      } else {
        if (storageTypeCase_ == 8) {
          storageTypeCase_ = 0;
          storageType_ = null;
        }
        bigtableBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Contains settings for the Cloud Bigtable instance that will be created
     * to serve featureValues for all FeatureViews under this
     * FeatureOnlineStore.
     * </pre>
     *
     * <code>.google.cloud.aiplatform.v1beta1.FeatureOnlineStore.Bigtable bigtable = 8;</code>
     */
    public com.google.cloud.aiplatform.v1beta1.FeatureOnlineStore.Bigtable.Builder
        getBigtableBuilder() {
      return getBigtableFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Contains settings for the Cloud Bigtable instance that will be created
     * to serve featureValues for all FeatureViews under this
     * FeatureOnlineStore.
     * </pre>
     *
     * <code>.google.cloud.aiplatform.v1beta1.FeatureOnlineStore.Bigtable bigtable = 8;</code>
     */
    @java.lang.Override
    public com.google.cloud.aiplatform.v1beta1.FeatureOnlineStore.BigtableOrBuilder
        getBigtableOrBuilder() {
      if ((storageTypeCase_ == 8) && (bigtableBuilder_ != null)) {
        return bigtableBuilder_.getMessageOrBuilder();
      } else {
        if (storageTypeCase_ == 8) {
          return (com.google.cloud.aiplatform.v1beta1.FeatureOnlineStore.Bigtable) storageType_;
        }
        return com.google.cloud.aiplatform.v1beta1.FeatureOnlineStore.Bigtable.getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * Contains settings for the Cloud Bigtable instance that will be created
     * to serve featureValues for all FeatureViews under this
     * FeatureOnlineStore.
     * </pre>
     *
     * <code>.google.cloud.aiplatform.v1beta1.FeatureOnlineStore.Bigtable bigtable = 8;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.aiplatform.v1beta1.FeatureOnlineStore.Bigtable,
            com.google.cloud.aiplatform.v1beta1.FeatureOnlineStore.Bigtable.Builder,
            com.google.cloud.aiplatform.v1beta1.FeatureOnlineStore.BigtableOrBuilder>
        getBigtableFieldBuilder() {
      if (bigtableBuilder_ == null) {
        if (!(storageTypeCase_ == 8)) {
          storageType_ =
              com.google.cloud.aiplatform.v1beta1.FeatureOnlineStore.Bigtable.getDefaultInstance();
        }
        bigtableBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.aiplatform.v1beta1.FeatureOnlineStore.Bigtable,
                com.google.cloud.aiplatform.v1beta1.FeatureOnlineStore.Bigtable.Builder,
                com.google.cloud.aiplatform.v1beta1.FeatureOnlineStore.BigtableOrBuilder>(
                (com.google.cloud.aiplatform.v1beta1.FeatureOnlineStore.Bigtable) storageType_,
                getParentForChildren(),
                isClean());
        storageType_ = null;
      }
      storageTypeCase_ = 8;
      onChanged();
      return bigtableBuilder_;
    }

    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.aiplatform.v1beta1.FeatureOnlineStore.Optimized,
            com.google.cloud.aiplatform.v1beta1.FeatureOnlineStore.Optimized.Builder,
            com.google.cloud.aiplatform.v1beta1.FeatureOnlineStore.OptimizedOrBuilder>
        optimizedBuilder_;
    /**
     *
     *
     * <pre>
     * Contains settings for the Optimized store that will be created
     * to serve featureValues for all FeatureViews under this
     * FeatureOnlineStore. When choose Optimized storage type, need to set
     * [PrivateServiceConnectConfig.enable_private_service_connect][google.cloud.aiplatform.v1beta1.PrivateServiceConnectConfig.enable_private_service_connect]
     * to use private endpoint. Otherwise will use public endpoint by default.
     * </pre>
     *
     * <code>.google.cloud.aiplatform.v1beta1.FeatureOnlineStore.Optimized optimized = 12;</code>
     *
     * @return Whether the optimized field is set.
     */
    @java.lang.Override
    public boolean hasOptimized() {
      return storageTypeCase_ == 12;
    }
    /**
     *
     *
     * <pre>
     * Contains settings for the Optimized store that will be created
     * to serve featureValues for all FeatureViews under this
     * FeatureOnlineStore. When choose Optimized storage type, need to set
     * [PrivateServiceConnectConfig.enable_private_service_connect][google.cloud.aiplatform.v1beta1.PrivateServiceConnectConfig.enable_private_service_connect]
     * to use private endpoint. Otherwise will use public endpoint by default.
     * </pre>
     *
     * <code>.google.cloud.aiplatform.v1beta1.FeatureOnlineStore.Optimized optimized = 12;</code>
     *
     * @return The optimized.
     */
    @java.lang.Override
    public com.google.cloud.aiplatform.v1beta1.FeatureOnlineStore.Optimized getOptimized() {
      if (optimizedBuilder_ == null) {
        if (storageTypeCase_ == 12) {
          return (com.google.cloud.aiplatform.v1beta1.FeatureOnlineStore.Optimized) storageType_;
        }
        return com.google.cloud.aiplatform.v1beta1.FeatureOnlineStore.Optimized
            .getDefaultInstance();
      } else {
        if (storageTypeCase_ == 12) {
          return optimizedBuilder_.getMessage();
        }
        return com.google.cloud.aiplatform.v1beta1.FeatureOnlineStore.Optimized
            .getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * Contains settings for the Optimized store that will be created
     * to serve featureValues for all FeatureViews under this
     * FeatureOnlineStore. When choose Optimized storage type, need to set
     * [PrivateServiceConnectConfig.enable_private_service_connect][google.cloud.aiplatform.v1beta1.PrivateServiceConnectConfig.enable_private_service_connect]
     * to use private endpoint. Otherwise will use public endpoint by default.
     * </pre>
     *
     * <code>.google.cloud.aiplatform.v1beta1.FeatureOnlineStore.Optimized optimized = 12;</code>
     */
    public Builder setOptimized(
        com.google.cloud.aiplatform.v1beta1.FeatureOnlineStore.Optimized value) {
      if (optimizedBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        storageType_ = value;
        onChanged();
      } else {
        optimizedBuilder_.setMessage(value);
      }
      storageTypeCase_ = 12;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Contains settings for the Optimized store that will be created
     * to serve featureValues for all FeatureViews under this
     * FeatureOnlineStore. When choose Optimized storage type, need to set
     * [PrivateServiceConnectConfig.enable_private_service_connect][google.cloud.aiplatform.v1beta1.PrivateServiceConnectConfig.enable_private_service_connect]
     * to use private endpoint. Otherwise will use public endpoint by default.
     * </pre>
     *
     * <code>.google.cloud.aiplatform.v1beta1.FeatureOnlineStore.Optimized optimized = 12;</code>
     */
    public Builder setOptimized(
        com.google.cloud.aiplatform.v1beta1.FeatureOnlineStore.Optimized.Builder builderForValue) {
      if (optimizedBuilder_ == null) {
        storageType_ = builderForValue.build();
        onChanged();
      } else {
        optimizedBuilder_.setMessage(builderForValue.build());
      }
      storageTypeCase_ = 12;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Contains settings for the Optimized store that will be created
     * to serve featureValues for all FeatureViews under this
     * FeatureOnlineStore. When choose Optimized storage type, need to set
     * [PrivateServiceConnectConfig.enable_private_service_connect][google.cloud.aiplatform.v1beta1.PrivateServiceConnectConfig.enable_private_service_connect]
     * to use private endpoint. Otherwise will use public endpoint by default.
     * </pre>
     *
     * <code>.google.cloud.aiplatform.v1beta1.FeatureOnlineStore.Optimized optimized = 12;</code>
     */
    public Builder mergeOptimized(
        com.google.cloud.aiplatform.v1beta1.FeatureOnlineStore.Optimized value) {
      if (optimizedBuilder_ == null) {
        if (storageTypeCase_ == 12
            && storageType_
                != com.google.cloud.aiplatform.v1beta1.FeatureOnlineStore.Optimized
                    .getDefaultInstance()) {
          storageType_ =
              com.google.cloud.aiplatform.v1beta1.FeatureOnlineStore.Optimized.newBuilder(
                      (com.google.cloud.aiplatform.v1beta1.FeatureOnlineStore.Optimized)
                          storageType_)
                  .mergeFrom(value)
                  .buildPartial();
        } else {
          storageType_ = value;
        }
        onChanged();
      } else {
        if (storageTypeCase_ == 12) {
          optimizedBuilder_.mergeFrom(value);
        } else {
          optimizedBuilder_.setMessage(value);
        }
      }
      storageTypeCase_ = 12;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Contains settings for the Optimized store that will be created
     * to serve featureValues for all FeatureViews under this
     * FeatureOnlineStore. When choose Optimized storage type, need to set
     * [PrivateServiceConnectConfig.enable_private_service_connect][google.cloud.aiplatform.v1beta1.PrivateServiceConnectConfig.enable_private_service_connect]
     * to use private endpoint. Otherwise will use public endpoint by default.
     * </pre>
     *
     * <code>.google.cloud.aiplatform.v1beta1.FeatureOnlineStore.Optimized optimized = 12;</code>
     */
    public Builder clearOptimized() {
      if (optimizedBuilder_ == null) {
        if (storageTypeCase_ == 12) {
          storageTypeCase_ = 0;
          storageType_ = null;
          onChanged();
        }
      } else {
        if (storageTypeCase_ == 12) {
          storageTypeCase_ = 0;
          storageType_ = null;
        }
        optimizedBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Contains settings for the Optimized store that will be created
     * to serve featureValues for all FeatureViews under this
     * FeatureOnlineStore. When choose Optimized storage type, need to set
     * [PrivateServiceConnectConfig.enable_private_service_connect][google.cloud.aiplatform.v1beta1.PrivateServiceConnectConfig.enable_private_service_connect]
     * to use private endpoint. Otherwise will use public endpoint by default.
     * </pre>
     *
     * <code>.google.cloud.aiplatform.v1beta1.FeatureOnlineStore.Optimized optimized = 12;</code>
     */
    public com.google.cloud.aiplatform.v1beta1.FeatureOnlineStore.Optimized.Builder
        getOptimizedBuilder() {
      return getOptimizedFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Contains settings for the Optimized store that will be created
     * to serve featureValues for all FeatureViews under this
     * FeatureOnlineStore. When choose Optimized storage type, need to set
     * [PrivateServiceConnectConfig.enable_private_service_connect][google.cloud.aiplatform.v1beta1.PrivateServiceConnectConfig.enable_private_service_connect]
     * to use private endpoint. Otherwise will use public endpoint by default.
     * </pre>
     *
     * <code>.google.cloud.aiplatform.v1beta1.FeatureOnlineStore.Optimized optimized = 12;</code>
     */
    @java.lang.Override
    public com.google.cloud.aiplatform.v1beta1.FeatureOnlineStore.OptimizedOrBuilder
        getOptimizedOrBuilder() {
      if ((storageTypeCase_ == 12) && (optimizedBuilder_ != null)) {
        return optimizedBuilder_.getMessageOrBuilder();
      } else {
        if (storageTypeCase_ == 12) {
          return (com.google.cloud.aiplatform.v1beta1.FeatureOnlineStore.Optimized) storageType_;
        }
        return com.google.cloud.aiplatform.v1beta1.FeatureOnlineStore.Optimized
            .getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * Contains settings for the Optimized store that will be created
     * to serve featureValues for all FeatureViews under this
     * FeatureOnlineStore. When choose Optimized storage type, need to set
     * [PrivateServiceConnectConfig.enable_private_service_connect][google.cloud.aiplatform.v1beta1.PrivateServiceConnectConfig.enable_private_service_connect]
     * to use private endpoint. Otherwise will use public endpoint by default.
     * </pre>
     *
     * <code>.google.cloud.aiplatform.v1beta1.FeatureOnlineStore.Optimized optimized = 12;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.aiplatform.v1beta1.FeatureOnlineStore.Optimized,
            com.google.cloud.aiplatform.v1beta1.FeatureOnlineStore.Optimized.Builder,
            com.google.cloud.aiplatform.v1beta1.FeatureOnlineStore.OptimizedOrBuilder>
        getOptimizedFieldBuilder() {
      if (optimizedBuilder_ == null) {
        if (!(storageTypeCase_ == 12)) {
          storageType_ =
              com.google.cloud.aiplatform.v1beta1.FeatureOnlineStore.Optimized.getDefaultInstance();
        }
        optimizedBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.aiplatform.v1beta1.FeatureOnlineStore.Optimized,
                com.google.cloud.aiplatform.v1beta1.FeatureOnlineStore.Optimized.Builder,
                com.google.cloud.aiplatform.v1beta1.FeatureOnlineStore.OptimizedOrBuilder>(
                (com.google.cloud.aiplatform.v1beta1.FeatureOnlineStore.Optimized) storageType_,
                getParentForChildren(),
                isClean());
        storageType_ = null;
      }
      storageTypeCase_ = 12;
      onChanged();
      return optimizedBuilder_;
    }

    private java.lang.Object name_ = "";
    /**
     *
     *
     * <pre>
     * Identifier. Name of the FeatureOnlineStore. Format:
     * `projects/{project}/locations/{location}/featureOnlineStores/{featureOnlineStore}`
     * </pre>
     *
     * <code>string name = 1 [(.google.api.field_behavior) = IDENTIFIER];</code>
     *
     * @return The name.
     */
    public java.lang.String getName() {
      java.lang.Object ref = name_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        name_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Identifier. Name of the FeatureOnlineStore. Format:
     * `projects/{project}/locations/{location}/featureOnlineStores/{featureOnlineStore}`
     * </pre>
     *
     * <code>string name = 1 [(.google.api.field_behavior) = IDENTIFIER];</code>
     *
     * @return The bytes for name.
     */
    public com.google.protobuf.ByteString getNameBytes() {
      java.lang.Object ref = name_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        name_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Identifier. Name of the FeatureOnlineStore. Format:
     * `projects/{project}/locations/{location}/featureOnlineStores/{featureOnlineStore}`
     * </pre>
     *
     * <code>string name = 1 [(.google.api.field_behavior) = IDENTIFIER];</code>
     *
     * @param value The name to set.
     * @return This builder for chaining.
     */
    public Builder setName(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      name_ = value;
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Identifier. Name of the FeatureOnlineStore. Format:
     * `projects/{project}/locations/{location}/featureOnlineStores/{featureOnlineStore}`
     * </pre>
     *
     * <code>string name = 1 [(.google.api.field_behavior) = IDENTIFIER];</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearName() {
      name_ = getDefaultInstance().getName();
      bitField0_ = (bitField0_ & ~0x00000004);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Identifier. Name of the FeatureOnlineStore. Format:
     * `projects/{project}/locations/{location}/featureOnlineStores/{featureOnlineStore}`
     * </pre>
     *
     * <code>string name = 1 [(.google.api.field_behavior) = IDENTIFIER];</code>
     *
     * @param value The bytes for name to set.
     * @return This builder for chaining.
     */
    public Builder setNameBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      name_ = value;
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }

    private com.google.protobuf.Timestamp createTime_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Timestamp,
            com.google.protobuf.Timestamp.Builder,
            com.google.protobuf.TimestampOrBuilder>
        createTimeBuilder_;
    /**
     *
     *
     * <pre>
     * Output only. Timestamp when this FeatureOnlineStore was created.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp create_time = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return Whether the createTime field is set.
     */
    public boolean hasCreateTime() {
      return ((bitField0_ & 0x00000008) != 0);
    }
    /**
     *
     *
     * <pre>
     * Output only. Timestamp when this FeatureOnlineStore was created.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp create_time = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return The createTime.
     */
    public com.google.protobuf.Timestamp getCreateTime() {
      if (createTimeBuilder_ == null) {
        return createTime_ == null
            ? com.google.protobuf.Timestamp.getDefaultInstance()
            : createTime_;
      } else {
        return createTimeBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. Timestamp when this FeatureOnlineStore was created.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp create_time = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder setCreateTime(com.google.protobuf.Timestamp value) {
      if (createTimeBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        createTime_ = value;
      } else {
        createTimeBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000008;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Timestamp when this FeatureOnlineStore was created.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp create_time = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder setCreateTime(com.google.protobuf.Timestamp.Builder builderForValue) {
      if (createTimeBuilder_ == null) {
        createTime_ = builderForValue.build();
      } else {
        createTimeBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000008;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Timestamp when this FeatureOnlineStore was created.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp create_time = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder mergeCreateTime(com.google.protobuf.Timestamp value) {
      if (createTimeBuilder_ == null) {
        if (((bitField0_ & 0x00000008) != 0)
            && createTime_ != null
            && createTime_ != com.google.protobuf.Timestamp.getDefaultInstance()) {
          getCreateTimeBuilder().mergeFrom(value);
        } else {
          createTime_ = value;
        }
      } else {
        createTimeBuilder_.mergeFrom(value);
      }
      if (createTime_ != null) {
        bitField0_ |= 0x00000008;
        onChanged();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Timestamp when this FeatureOnlineStore was created.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp create_time = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder clearCreateTime() {
      bitField0_ = (bitField0_ & ~0x00000008);
      createTime_ = null;
      if (createTimeBuilder_ != null) {
        createTimeBuilder_.dispose();
        createTimeBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Timestamp when this FeatureOnlineStore was created.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp create_time = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.protobuf.Timestamp.Builder getCreateTimeBuilder() {
      bitField0_ |= 0x00000008;
      onChanged();
      return getCreateTimeFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Output only. Timestamp when this FeatureOnlineStore was created.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp create_time = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.protobuf.TimestampOrBuilder getCreateTimeOrBuilder() {
      if (createTimeBuilder_ != null) {
        return createTimeBuilder_.getMessageOrBuilder();
      } else {
        return createTime_ == null
            ? com.google.protobuf.Timestamp.getDefaultInstance()
            : createTime_;
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. Timestamp when this FeatureOnlineStore was created.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp create_time = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Timestamp,
            com.google.protobuf.Timestamp.Builder,
            com.google.protobuf.TimestampOrBuilder>
        getCreateTimeFieldBuilder() {
      if (createTimeBuilder_ == null) {
        createTimeBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.protobuf.Timestamp,
                com.google.protobuf.Timestamp.Builder,
                com.google.protobuf.TimestampOrBuilder>(
                getCreateTime(), getParentForChildren(), isClean());
        createTime_ = null;
      }
      return createTimeBuilder_;
    }

    private com.google.protobuf.Timestamp updateTime_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Timestamp,
            com.google.protobuf.Timestamp.Builder,
            com.google.protobuf.TimestampOrBuilder>
        updateTimeBuilder_;
    /**
     *
     *
     * <pre>
     * Output only. Timestamp when this FeatureOnlineStore was last updated.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp update_time = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return Whether the updateTime field is set.
     */
    public boolean hasUpdateTime() {
      return ((bitField0_ & 0x00000010) != 0);
    }
    /**
     *
     *
     * <pre>
     * Output only. Timestamp when this FeatureOnlineStore was last updated.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp update_time = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return The updateTime.
     */
    public com.google.protobuf.Timestamp getUpdateTime() {
      if (updateTimeBuilder_ == null) {
        return updateTime_ == null
            ? com.google.protobuf.Timestamp.getDefaultInstance()
            : updateTime_;
      } else {
        return updateTimeBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. Timestamp when this FeatureOnlineStore was last updated.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp update_time = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder setUpdateTime(com.google.protobuf.Timestamp value) {
      if (updateTimeBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        updateTime_ = value;
      } else {
        updateTimeBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000010;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Timestamp when this FeatureOnlineStore was last updated.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp update_time = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder setUpdateTime(com.google.protobuf.Timestamp.Builder builderForValue) {
      if (updateTimeBuilder_ == null) {
        updateTime_ = builderForValue.build();
      } else {
        updateTimeBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000010;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Timestamp when this FeatureOnlineStore was last updated.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp update_time = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder mergeUpdateTime(com.google.protobuf.Timestamp value) {
      if (updateTimeBuilder_ == null) {
        if (((bitField0_ & 0x00000010) != 0)
            && updateTime_ != null
            && updateTime_ != com.google.protobuf.Timestamp.getDefaultInstance()) {
          getUpdateTimeBuilder().mergeFrom(value);
        } else {
          updateTime_ = value;
        }
      } else {
        updateTimeBuilder_.mergeFrom(value);
      }
      if (updateTime_ != null) {
        bitField0_ |= 0x00000010;
        onChanged();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Timestamp when this FeatureOnlineStore was last updated.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp update_time = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder clearUpdateTime() {
      bitField0_ = (bitField0_ & ~0x00000010);
      updateTime_ = null;
      if (updateTimeBuilder_ != null) {
        updateTimeBuilder_.dispose();
        updateTimeBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Timestamp when this FeatureOnlineStore was last updated.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp update_time = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.protobuf.Timestamp.Builder getUpdateTimeBuilder() {
      bitField0_ |= 0x00000010;
      onChanged();
      return getUpdateTimeFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Output only. Timestamp when this FeatureOnlineStore was last updated.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp update_time = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.protobuf.TimestampOrBuilder getUpdateTimeOrBuilder() {
      if (updateTimeBuilder_ != null) {
        return updateTimeBuilder_.getMessageOrBuilder();
      } else {
        return updateTime_ == null
            ? com.google.protobuf.Timestamp.getDefaultInstance()
            : updateTime_;
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. Timestamp when this FeatureOnlineStore was last updated.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp update_time = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Timestamp,
            com.google.protobuf.Timestamp.Builder,
            com.google.protobuf.TimestampOrBuilder>
        getUpdateTimeFieldBuilder() {
      if (updateTimeBuilder_ == null) {
        updateTimeBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.protobuf.Timestamp,
                com.google.protobuf.Timestamp.Builder,
                com.google.protobuf.TimestampOrBuilder>(
                getUpdateTime(), getParentForChildren(), isClean());
        updateTime_ = null;
      }
      return updateTimeBuilder_;
    }

    private java.lang.Object etag_ = "";
    /**
     *
     *
     * <pre>
     * Optional. Used to perform consistent read-modify-write updates. If not set,
     * a blind "overwrite" update happens.
     * </pre>
     *
     * <code>string etag = 5 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return The etag.
     */
    public java.lang.String getEtag() {
      java.lang.Object ref = etag_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        etag_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Optional. Used to perform consistent read-modify-write updates. If not set,
     * a blind "overwrite" update happens.
     * </pre>
     *
     * <code>string etag = 5 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return The bytes for etag.
     */
    public com.google.protobuf.ByteString getEtagBytes() {
      java.lang.Object ref = etag_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        etag_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Optional. Used to perform consistent read-modify-write updates. If not set,
     * a blind "overwrite" update happens.
     * </pre>
     *
     * <code>string etag = 5 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @param value The etag to set.
     * @return This builder for chaining.
     */
    public Builder setEtag(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      etag_ = value;
      bitField0_ |= 0x00000020;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. Used to perform consistent read-modify-write updates. If not set,
     * a blind "overwrite" update happens.
     * </pre>
     *
     * <code>string etag = 5 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearEtag() {
      etag_ = getDefaultInstance().getEtag();
      bitField0_ = (bitField0_ & ~0x00000020);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. Used to perform consistent read-modify-write updates. If not set,
     * a blind "overwrite" update happens.
     * </pre>
     *
     * <code>string etag = 5 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @param value The bytes for etag to set.
     * @return This builder for chaining.
     */
    public Builder setEtagBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      etag_ = value;
      bitField0_ |= 0x00000020;
      onChanged();
      return this;
    }

    private com.google.protobuf.MapField<java.lang.String, java.lang.String> labels_;

    private com.google.protobuf.MapField<java.lang.String, java.lang.String> internalGetLabels() {
      if (labels_ == null) {
        return com.google.protobuf.MapField.emptyMapField(LabelsDefaultEntryHolder.defaultEntry);
      }
      return labels_;
    }

    private com.google.protobuf.MapField<java.lang.String, java.lang.String>
        internalGetMutableLabels() {
      if (labels_ == null) {
        labels_ = com.google.protobuf.MapField.newMapField(LabelsDefaultEntryHolder.defaultEntry);
      }
      if (!labels_.isMutable()) {
        labels_ = labels_.copy();
      }
      bitField0_ |= 0x00000040;
      onChanged();
      return labels_;
    }

    public int getLabelsCount() {
      return internalGetLabels().getMap().size();
    }
    /**
     *
     *
     * <pre>
     * Optional. The labels with user-defined metadata to organize your
     * FeatureOnlineStore.
     *
     * Label keys and values can be no longer than 64 characters
     * (Unicode codepoints), can only contain lowercase letters, numeric
     * characters, underscores and dashes. International characters are allowed.
     *
     * See https://goo.gl/xmQnxf for more information on and examples of labels.
     * No more than 64 user labels can be associated with one
     * FeatureOnlineStore(System labels are excluded)." System reserved label keys
     * are prefixed with "aiplatform.googleapis.com/" and are immutable.
     * </pre>
     *
     * <code>map&lt;string, string&gt; labels = 6 [(.google.api.field_behavior) = OPTIONAL];</code>
     */
    @java.lang.Override
    public boolean containsLabels(java.lang.String key) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      return internalGetLabels().getMap().containsKey(key);
    }
    /** Use {@link #getLabelsMap()} instead. */
    @java.lang.Override
    @java.lang.Deprecated
    public java.util.Map<java.lang.String, java.lang.String> getLabels() {
      return getLabelsMap();
    }
    /**
     *
     *
     * <pre>
     * Optional. The labels with user-defined metadata to organize your
     * FeatureOnlineStore.
     *
     * Label keys and values can be no longer than 64 characters
     * (Unicode codepoints), can only contain lowercase letters, numeric
     * characters, underscores and dashes. International characters are allowed.
     *
     * See https://goo.gl/xmQnxf for more information on and examples of labels.
     * No more than 64 user labels can be associated with one
     * FeatureOnlineStore(System labels are excluded)." System reserved label keys
     * are prefixed with "aiplatform.googleapis.com/" and are immutable.
     * </pre>
     *
     * <code>map&lt;string, string&gt; labels = 6 [(.google.api.field_behavior) = OPTIONAL];</code>
     */
    @java.lang.Override
    public java.util.Map<java.lang.String, java.lang.String> getLabelsMap() {
      return internalGetLabels().getMap();
    }
    /**
     *
     *
     * <pre>
     * Optional. The labels with user-defined metadata to organize your
     * FeatureOnlineStore.
     *
     * Label keys and values can be no longer than 64 characters
     * (Unicode codepoints), can only contain lowercase letters, numeric
     * characters, underscores and dashes. International characters are allowed.
     *
     * See https://goo.gl/xmQnxf for more information on and examples of labels.
     * No more than 64 user labels can be associated with one
     * FeatureOnlineStore(System labels are excluded)." System reserved label keys
     * are prefixed with "aiplatform.googleapis.com/" and are immutable.
     * </pre>
     *
     * <code>map&lt;string, string&gt; labels = 6 [(.google.api.field_behavior) = OPTIONAL];</code>
     */
    @java.lang.Override
    public /* nullable */ java.lang.String getLabelsOrDefault(
        java.lang.String key,
        /* nullable */
        java.lang.String defaultValue) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      java.util.Map<java.lang.String, java.lang.String> map = internalGetLabels().getMap();
      return map.containsKey(key) ? map.get(key) : defaultValue;
    }
    /**
     *
     *
     * <pre>
     * Optional. The labels with user-defined metadata to organize your
     * FeatureOnlineStore.
     *
     * Label keys and values can be no longer than 64 characters
     * (Unicode codepoints), can only contain lowercase letters, numeric
     * characters, underscores and dashes. International characters are allowed.
     *
     * See https://goo.gl/xmQnxf for more information on and examples of labels.
     * No more than 64 user labels can be associated with one
     * FeatureOnlineStore(System labels are excluded)." System reserved label keys
     * are prefixed with "aiplatform.googleapis.com/" and are immutable.
     * </pre>
     *
     * <code>map&lt;string, string&gt; labels = 6 [(.google.api.field_behavior) = OPTIONAL];</code>
     */
    @java.lang.Override
    public java.lang.String getLabelsOrThrow(java.lang.String key) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      java.util.Map<java.lang.String, java.lang.String> map = internalGetLabels().getMap();
      if (!map.containsKey(key)) {
        throw new java.lang.IllegalArgumentException();
      }
      return map.get(key);
    }

    public Builder clearLabels() {
      bitField0_ = (bitField0_ & ~0x00000040);
      internalGetMutableLabels().getMutableMap().clear();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. The labels with user-defined metadata to organize your
     * FeatureOnlineStore.
     *
     * Label keys and values can be no longer than 64 characters
     * (Unicode codepoints), can only contain lowercase letters, numeric
     * characters, underscores and dashes. International characters are allowed.
     *
     * See https://goo.gl/xmQnxf for more information on and examples of labels.
     * No more than 64 user labels can be associated with one
     * FeatureOnlineStore(System labels are excluded)." System reserved label keys
     * are prefixed with "aiplatform.googleapis.com/" and are immutable.
     * </pre>
     *
     * <code>map&lt;string, string&gt; labels = 6 [(.google.api.field_behavior) = OPTIONAL];</code>
     */
    public Builder removeLabels(java.lang.String key) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      internalGetMutableLabels().getMutableMap().remove(key);
      return this;
    }
    /** Use alternate mutation accessors instead. */
    @java.lang.Deprecated
    public java.util.Map<java.lang.String, java.lang.String> getMutableLabels() {
      bitField0_ |= 0x00000040;
      return internalGetMutableLabels().getMutableMap();
    }
    /**
     *
     *
     * <pre>
     * Optional. The labels with user-defined metadata to organize your
     * FeatureOnlineStore.
     *
     * Label keys and values can be no longer than 64 characters
     * (Unicode codepoints), can only contain lowercase letters, numeric
     * characters, underscores and dashes. International characters are allowed.
     *
     * See https://goo.gl/xmQnxf for more information on and examples of labels.
     * No more than 64 user labels can be associated with one
     * FeatureOnlineStore(System labels are excluded)." System reserved label keys
     * are prefixed with "aiplatform.googleapis.com/" and are immutable.
     * </pre>
     *
     * <code>map&lt;string, string&gt; labels = 6 [(.google.api.field_behavior) = OPTIONAL];</code>
     */
    public Builder putLabels(java.lang.String key, java.lang.String value) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      if (value == null) {
        throw new NullPointerException("map value");
      }
      internalGetMutableLabels().getMutableMap().put(key, value);
      bitField0_ |= 0x00000040;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. The labels with user-defined metadata to organize your
     * FeatureOnlineStore.
     *
     * Label keys and values can be no longer than 64 characters
     * (Unicode codepoints), can only contain lowercase letters, numeric
     * characters, underscores and dashes. International characters are allowed.
     *
     * See https://goo.gl/xmQnxf for more information on and examples of labels.
     * No more than 64 user labels can be associated with one
     * FeatureOnlineStore(System labels are excluded)." System reserved label keys
     * are prefixed with "aiplatform.googleapis.com/" and are immutable.
     * </pre>
     *
     * <code>map&lt;string, string&gt; labels = 6 [(.google.api.field_behavior) = OPTIONAL];</code>
     */
    public Builder putAllLabels(java.util.Map<java.lang.String, java.lang.String> values) {
      internalGetMutableLabels().getMutableMap().putAll(values);
      bitField0_ |= 0x00000040;
      return this;
    }

    private int state_ = 0;
    /**
     *
     *
     * <pre>
     * Output only. State of the featureOnlineStore.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.FeatureOnlineStore.State state = 7 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return The enum numeric value on the wire for state.
     */
    @java.lang.Override
    public int getStateValue() {
      return state_;
    }
    /**
     *
     *
     * <pre>
     * Output only. State of the featureOnlineStore.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.FeatureOnlineStore.State state = 7 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @param value The enum numeric value on the wire for state to set.
     * @return This builder for chaining.
     */
    public Builder setStateValue(int value) {
      state_ = value;
      bitField0_ |= 0x00000080;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. State of the featureOnlineStore.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.FeatureOnlineStore.State state = 7 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return The state.
     */
    @java.lang.Override
    public com.google.cloud.aiplatform.v1beta1.FeatureOnlineStore.State getState() {
      com.google.cloud.aiplatform.v1beta1.FeatureOnlineStore.State result =
          com.google.cloud.aiplatform.v1beta1.FeatureOnlineStore.State.forNumber(state_);
      return result == null
          ? com.google.cloud.aiplatform.v1beta1.FeatureOnlineStore.State.UNRECOGNIZED
          : result;
    }
    /**
     *
     *
     * <pre>
     * Output only. State of the featureOnlineStore.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.FeatureOnlineStore.State state = 7 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @param value The state to set.
     * @return This builder for chaining.
     */
    public Builder setState(com.google.cloud.aiplatform.v1beta1.FeatureOnlineStore.State value) {
      if (value == null) {
        throw new NullPointerException();
      }
      bitField0_ |= 0x00000080;
      state_ = value.getNumber();
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. State of the featureOnlineStore.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.FeatureOnlineStore.State state = 7 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return This builder for chaining.
     */
    public Builder clearState() {
      bitField0_ = (bitField0_ & ~0x00000080);
      state_ = 0;
      onChanged();
      return this;
    }

    private com.google.cloud.aiplatform.v1beta1.FeatureOnlineStore.DedicatedServingEndpoint
        dedicatedServingEndpoint_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.aiplatform.v1beta1.FeatureOnlineStore.DedicatedServingEndpoint,
            com.google.cloud.aiplatform.v1beta1.FeatureOnlineStore.DedicatedServingEndpoint.Builder,
            com.google.cloud.aiplatform.v1beta1.FeatureOnlineStore
                .DedicatedServingEndpointOrBuilder>
        dedicatedServingEndpointBuilder_;
    /**
     *
     *
     * <pre>
     * Optional. The dedicated serving endpoint for this FeatureOnlineStore, which
     * is different from common Vertex service endpoint.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.FeatureOnlineStore.DedicatedServingEndpoint dedicated_serving_endpoint = 10 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return Whether the dedicatedServingEndpoint field is set.
     */
    public boolean hasDedicatedServingEndpoint() {
      return ((bitField0_ & 0x00000100) != 0);
    }
    /**
     *
     *
     * <pre>
     * Optional. The dedicated serving endpoint for this FeatureOnlineStore, which
     * is different from common Vertex service endpoint.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.FeatureOnlineStore.DedicatedServingEndpoint dedicated_serving_endpoint = 10 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return The dedicatedServingEndpoint.
     */
    public com.google.cloud.aiplatform.v1beta1.FeatureOnlineStore.DedicatedServingEndpoint
        getDedicatedServingEndpoint() {
      if (dedicatedServingEndpointBuilder_ == null) {
        return dedicatedServingEndpoint_ == null
            ? com.google.cloud.aiplatform.v1beta1.FeatureOnlineStore.DedicatedServingEndpoint
                .getDefaultInstance()
            : dedicatedServingEndpoint_;
      } else {
        return dedicatedServingEndpointBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Optional. The dedicated serving endpoint for this FeatureOnlineStore, which
     * is different from common Vertex service endpoint.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.FeatureOnlineStore.DedicatedServingEndpoint dedicated_serving_endpoint = 10 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder setDedicatedServingEndpoint(
        com.google.cloud.aiplatform.v1beta1.FeatureOnlineStore.DedicatedServingEndpoint value) {
      if (dedicatedServingEndpointBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        dedicatedServingEndpoint_ = value;
      } else {
        dedicatedServingEndpointBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000100;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. The dedicated serving endpoint for this FeatureOnlineStore, which
     * is different from common Vertex service endpoint.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.FeatureOnlineStore.DedicatedServingEndpoint dedicated_serving_endpoint = 10 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder setDedicatedServingEndpoint(
        com.google.cloud.aiplatform.v1beta1.FeatureOnlineStore.DedicatedServingEndpoint.Builder
            builderForValue) {
      if (dedicatedServingEndpointBuilder_ == null) {
        dedicatedServingEndpoint_ = builderForValue.build();
      } else {
        dedicatedServingEndpointBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000100;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. The dedicated serving endpoint for this FeatureOnlineStore, which
     * is different from common Vertex service endpoint.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.FeatureOnlineStore.DedicatedServingEndpoint dedicated_serving_endpoint = 10 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder mergeDedicatedServingEndpoint(
        com.google.cloud.aiplatform.v1beta1.FeatureOnlineStore.DedicatedServingEndpoint value) {
      if (dedicatedServingEndpointBuilder_ == null) {
        if (((bitField0_ & 0x00000100) != 0)
            && dedicatedServingEndpoint_ != null
            && dedicatedServingEndpoint_
                != com.google.cloud.aiplatform.v1beta1.FeatureOnlineStore.DedicatedServingEndpoint
                    .getDefaultInstance()) {
          getDedicatedServingEndpointBuilder().mergeFrom(value);
        } else {
          dedicatedServingEndpoint_ = value;
        }
      } else {
        dedicatedServingEndpointBuilder_.mergeFrom(value);
      }
      if (dedicatedServingEndpoint_ != null) {
        bitField0_ |= 0x00000100;
        onChanged();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. The dedicated serving endpoint for this FeatureOnlineStore, which
     * is different from common Vertex service endpoint.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.FeatureOnlineStore.DedicatedServingEndpoint dedicated_serving_endpoint = 10 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder clearDedicatedServingEndpoint() {
      bitField0_ = (bitField0_ & ~0x00000100);
      dedicatedServingEndpoint_ = null;
      if (dedicatedServingEndpointBuilder_ != null) {
        dedicatedServingEndpointBuilder_.dispose();
        dedicatedServingEndpointBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. The dedicated serving endpoint for this FeatureOnlineStore, which
     * is different from common Vertex service endpoint.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.FeatureOnlineStore.DedicatedServingEndpoint dedicated_serving_endpoint = 10 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public com.google.cloud.aiplatform.v1beta1.FeatureOnlineStore.DedicatedServingEndpoint.Builder
        getDedicatedServingEndpointBuilder() {
      bitField0_ |= 0x00000100;
      onChanged();
      return getDedicatedServingEndpointFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Optional. The dedicated serving endpoint for this FeatureOnlineStore, which
     * is different from common Vertex service endpoint.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.FeatureOnlineStore.DedicatedServingEndpoint dedicated_serving_endpoint = 10 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public com.google.cloud.aiplatform.v1beta1.FeatureOnlineStore.DedicatedServingEndpointOrBuilder
        getDedicatedServingEndpointOrBuilder() {
      if (dedicatedServingEndpointBuilder_ != null) {
        return dedicatedServingEndpointBuilder_.getMessageOrBuilder();
      } else {
        return dedicatedServingEndpoint_ == null
            ? com.google.cloud.aiplatform.v1beta1.FeatureOnlineStore.DedicatedServingEndpoint
                .getDefaultInstance()
            : dedicatedServingEndpoint_;
      }
    }
    /**
     *
     *
     * <pre>
     * Optional. The dedicated serving endpoint for this FeatureOnlineStore, which
     * is different from common Vertex service endpoint.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.FeatureOnlineStore.DedicatedServingEndpoint dedicated_serving_endpoint = 10 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.aiplatform.v1beta1.FeatureOnlineStore.DedicatedServingEndpoint,
            com.google.cloud.aiplatform.v1beta1.FeatureOnlineStore.DedicatedServingEndpoint.Builder,
            com.google.cloud.aiplatform.v1beta1.FeatureOnlineStore
                .DedicatedServingEndpointOrBuilder>
        getDedicatedServingEndpointFieldBuilder() {
      if (dedicatedServingEndpointBuilder_ == null) {
        dedicatedServingEndpointBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.aiplatform.v1beta1.FeatureOnlineStore.DedicatedServingEndpoint,
                com.google.cloud.aiplatform.v1beta1.FeatureOnlineStore.DedicatedServingEndpoint
                    .Builder,
                com.google.cloud.aiplatform.v1beta1.FeatureOnlineStore
                    .DedicatedServingEndpointOrBuilder>(
                getDedicatedServingEndpoint(), getParentForChildren(), isClean());
        dedicatedServingEndpoint_ = null;
      }
      return dedicatedServingEndpointBuilder_;
    }

    private com.google.cloud.aiplatform.v1beta1.FeatureOnlineStore.EmbeddingManagement
        embeddingManagement_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.aiplatform.v1beta1.FeatureOnlineStore.EmbeddingManagement,
            com.google.cloud.aiplatform.v1beta1.FeatureOnlineStore.EmbeddingManagement.Builder,
            com.google.cloud.aiplatform.v1beta1.FeatureOnlineStore.EmbeddingManagementOrBuilder>
        embeddingManagementBuilder_;
    /**
     *
     *
     * <pre>
     * Optional. The settings for embedding management in FeatureOnlineStore.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.FeatureOnlineStore.EmbeddingManagement embedding_management = 11 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return Whether the embeddingManagement field is set.
     */
    public boolean hasEmbeddingManagement() {
      return ((bitField0_ & 0x00000200) != 0);
    }
    /**
     *
     *
     * <pre>
     * Optional. The settings for embedding management in FeatureOnlineStore.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.FeatureOnlineStore.EmbeddingManagement embedding_management = 11 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return The embeddingManagement.
     */
    public com.google.cloud.aiplatform.v1beta1.FeatureOnlineStore.EmbeddingManagement
        getEmbeddingManagement() {
      if (embeddingManagementBuilder_ == null) {
        return embeddingManagement_ == null
            ? com.google.cloud.aiplatform.v1beta1.FeatureOnlineStore.EmbeddingManagement
                .getDefaultInstance()
            : embeddingManagement_;
      } else {
        return embeddingManagementBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Optional. The settings for embedding management in FeatureOnlineStore.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.FeatureOnlineStore.EmbeddingManagement embedding_management = 11 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder setEmbeddingManagement(
        com.google.cloud.aiplatform.v1beta1.FeatureOnlineStore.EmbeddingManagement value) {
      if (embeddingManagementBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        embeddingManagement_ = value;
      } else {
        embeddingManagementBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000200;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. The settings for embedding management in FeatureOnlineStore.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.FeatureOnlineStore.EmbeddingManagement embedding_management = 11 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder setEmbeddingManagement(
        com.google.cloud.aiplatform.v1beta1.FeatureOnlineStore.EmbeddingManagement.Builder
            builderForValue) {
      if (embeddingManagementBuilder_ == null) {
        embeddingManagement_ = builderForValue.build();
      } else {
        embeddingManagementBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000200;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. The settings for embedding management in FeatureOnlineStore.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.FeatureOnlineStore.EmbeddingManagement embedding_management = 11 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder mergeEmbeddingManagement(
        com.google.cloud.aiplatform.v1beta1.FeatureOnlineStore.EmbeddingManagement value) {
      if (embeddingManagementBuilder_ == null) {
        if (((bitField0_ & 0x00000200) != 0)
            && embeddingManagement_ != null
            && embeddingManagement_
                != com.google.cloud.aiplatform.v1beta1.FeatureOnlineStore.EmbeddingManagement
                    .getDefaultInstance()) {
          getEmbeddingManagementBuilder().mergeFrom(value);
        } else {
          embeddingManagement_ = value;
        }
      } else {
        embeddingManagementBuilder_.mergeFrom(value);
      }
      if (embeddingManagement_ != null) {
        bitField0_ |= 0x00000200;
        onChanged();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. The settings for embedding management in FeatureOnlineStore.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.FeatureOnlineStore.EmbeddingManagement embedding_management = 11 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder clearEmbeddingManagement() {
      bitField0_ = (bitField0_ & ~0x00000200);
      embeddingManagement_ = null;
      if (embeddingManagementBuilder_ != null) {
        embeddingManagementBuilder_.dispose();
        embeddingManagementBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. The settings for embedding management in FeatureOnlineStore.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.FeatureOnlineStore.EmbeddingManagement embedding_management = 11 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public com.google.cloud.aiplatform.v1beta1.FeatureOnlineStore.EmbeddingManagement.Builder
        getEmbeddingManagementBuilder() {
      bitField0_ |= 0x00000200;
      onChanged();
      return getEmbeddingManagementFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Optional. The settings for embedding management in FeatureOnlineStore.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.FeatureOnlineStore.EmbeddingManagement embedding_management = 11 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public com.google.cloud.aiplatform.v1beta1.FeatureOnlineStore.EmbeddingManagementOrBuilder
        getEmbeddingManagementOrBuilder() {
      if (embeddingManagementBuilder_ != null) {
        return embeddingManagementBuilder_.getMessageOrBuilder();
      } else {
        return embeddingManagement_ == null
            ? com.google.cloud.aiplatform.v1beta1.FeatureOnlineStore.EmbeddingManagement
                .getDefaultInstance()
            : embeddingManagement_;
      }
    }
    /**
     *
     *
     * <pre>
     * Optional. The settings for embedding management in FeatureOnlineStore.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.FeatureOnlineStore.EmbeddingManagement embedding_management = 11 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.aiplatform.v1beta1.FeatureOnlineStore.EmbeddingManagement,
            com.google.cloud.aiplatform.v1beta1.FeatureOnlineStore.EmbeddingManagement.Builder,
            com.google.cloud.aiplatform.v1beta1.FeatureOnlineStore.EmbeddingManagementOrBuilder>
        getEmbeddingManagementFieldBuilder() {
      if (embeddingManagementBuilder_ == null) {
        embeddingManagementBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.aiplatform.v1beta1.FeatureOnlineStore.EmbeddingManagement,
                com.google.cloud.aiplatform.v1beta1.FeatureOnlineStore.EmbeddingManagement.Builder,
                com.google.cloud.aiplatform.v1beta1.FeatureOnlineStore
                    .EmbeddingManagementOrBuilder>(
                getEmbeddingManagement(), getParentForChildren(), isClean());
        embeddingManagement_ = null;
      }
      return embeddingManagementBuilder_;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.cloud.aiplatform.v1beta1.FeatureOnlineStore)
  }

  // @@protoc_insertion_point(class_scope:google.cloud.aiplatform.v1beta1.FeatureOnlineStore)
  private static final com.google.cloud.aiplatform.v1beta1.FeatureOnlineStore DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.cloud.aiplatform.v1beta1.FeatureOnlineStore();
  }

  public static com.google.cloud.aiplatform.v1beta1.FeatureOnlineStore getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<FeatureOnlineStore> PARSER =
      new com.google.protobuf.AbstractParser<FeatureOnlineStore>() {
        @java.lang.Override
        public FeatureOnlineStore parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          Builder builder = newBuilder();
          try {
            builder.mergeFrom(input, extensionRegistry);
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.setUnfinishedMessage(builder.buildPartial());
          } catch (com.google.protobuf.UninitializedMessageException e) {
            throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
          } catch (java.io.IOException e) {
            throw new com.google.protobuf.InvalidProtocolBufferException(e)
                .setUnfinishedMessage(builder.buildPartial());
          }
          return builder.buildPartial();
        }
      };

  public static com.google.protobuf.Parser<FeatureOnlineStore> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<FeatureOnlineStore> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.cloud.aiplatform.v1beta1.FeatureOnlineStore getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
