/*
 * Copyright 2024 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/cloud/aiplatform/v1beta1/match_service.proto

// Protobuf Java Version: 3.25.2
package com.google.cloud.aiplatform.v1beta1;

/**
 *
 *
 * <pre>
 * The response message for
 * [MatchService.FindNeighbors][google.cloud.aiplatform.v1beta1.MatchService.FindNeighbors].
 * </pre>
 *
 * Protobuf type {@code google.cloud.aiplatform.v1beta1.FindNeighborsResponse}
 */
public final class FindNeighborsResponse extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.cloud.aiplatform.v1beta1.FindNeighborsResponse)
    FindNeighborsResponseOrBuilder {
  private static final long serialVersionUID = 0L;
  // Use FindNeighborsResponse.newBuilder() to construct.
  private FindNeighborsResponse(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private FindNeighborsResponse() {
    nearestNeighbors_ = java.util.Collections.emptyList();
  }

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new FindNeighborsResponse();
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.cloud.aiplatform.v1beta1.MatchServiceProto
        .internal_static_google_cloud_aiplatform_v1beta1_FindNeighborsResponse_descriptor;
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.cloud.aiplatform.v1beta1.MatchServiceProto
        .internal_static_google_cloud_aiplatform_v1beta1_FindNeighborsResponse_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.cloud.aiplatform.v1beta1.FindNeighborsResponse.class,
            com.google.cloud.aiplatform.v1beta1.FindNeighborsResponse.Builder.class);
  }

  public interface NeighborOrBuilder
      extends
      // @@protoc_insertion_point(interface_extends:google.cloud.aiplatform.v1beta1.FindNeighborsResponse.Neighbor)
      com.google.protobuf.MessageOrBuilder {

    /**
     *
     *
     * <pre>
     * The datapoint of the neighbor.
     * Note that full datapoints are returned only when "return_full_datapoint"
     * is set to true. Otherwise, only the "datapoint_id" and "crowding_tag"
     * fields are populated.
     * </pre>
     *
     * <code>.google.cloud.aiplatform.v1beta1.IndexDatapoint datapoint = 1;</code>
     *
     * @return Whether the datapoint field is set.
     */
    boolean hasDatapoint();
    /**
     *
     *
     * <pre>
     * The datapoint of the neighbor.
     * Note that full datapoints are returned only when "return_full_datapoint"
     * is set to true. Otherwise, only the "datapoint_id" and "crowding_tag"
     * fields are populated.
     * </pre>
     *
     * <code>.google.cloud.aiplatform.v1beta1.IndexDatapoint datapoint = 1;</code>
     *
     * @return The datapoint.
     */
    com.google.cloud.aiplatform.v1beta1.IndexDatapoint getDatapoint();
    /**
     *
     *
     * <pre>
     * The datapoint of the neighbor.
     * Note that full datapoints are returned only when "return_full_datapoint"
     * is set to true. Otherwise, only the "datapoint_id" and "crowding_tag"
     * fields are populated.
     * </pre>
     *
     * <code>.google.cloud.aiplatform.v1beta1.IndexDatapoint datapoint = 1;</code>
     */
    com.google.cloud.aiplatform.v1beta1.IndexDatapointOrBuilder getDatapointOrBuilder();

    /**
     *
     *
     * <pre>
     * The distance between the neighbor and the query vector.
     * </pre>
     *
     * <code>double distance = 2;</code>
     *
     * @return The distance.
     */
    double getDistance();
  }
  /**
   *
   *
   * <pre>
   * A neighbor of the query vector.
   * </pre>
   *
   * Protobuf type {@code google.cloud.aiplatform.v1beta1.FindNeighborsResponse.Neighbor}
   */
  public static final class Neighbor extends com.google.protobuf.GeneratedMessageV3
      implements
      // @@protoc_insertion_point(message_implements:google.cloud.aiplatform.v1beta1.FindNeighborsResponse.Neighbor)
      NeighborOrBuilder {
    private static final long serialVersionUID = 0L;
    // Use Neighbor.newBuilder() to construct.
    private Neighbor(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
      super(builder);
    }

    private Neighbor() {}

    @java.lang.Override
    @SuppressWarnings({"unused"})
    protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
      return new Neighbor();
    }

    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.aiplatform.v1beta1.MatchServiceProto
          .internal_static_google_cloud_aiplatform_v1beta1_FindNeighborsResponse_Neighbor_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.aiplatform.v1beta1.MatchServiceProto
          .internal_static_google_cloud_aiplatform_v1beta1_FindNeighborsResponse_Neighbor_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.aiplatform.v1beta1.FindNeighborsResponse.Neighbor.class,
              com.google.cloud.aiplatform.v1beta1.FindNeighborsResponse.Neighbor.Builder.class);
    }

    private int bitField0_;
    public static final int DATAPOINT_FIELD_NUMBER = 1;
    private com.google.cloud.aiplatform.v1beta1.IndexDatapoint datapoint_;
    /**
     *
     *
     * <pre>
     * The datapoint of the neighbor.
     * Note that full datapoints are returned only when "return_full_datapoint"
     * is set to true. Otherwise, only the "datapoint_id" and "crowding_tag"
     * fields are populated.
     * </pre>
     *
     * <code>.google.cloud.aiplatform.v1beta1.IndexDatapoint datapoint = 1;</code>
     *
     * @return Whether the datapoint field is set.
     */
    @java.lang.Override
    public boolean hasDatapoint() {
      return ((bitField0_ & 0x00000001) != 0);
    }
    /**
     *
     *
     * <pre>
     * The datapoint of the neighbor.
     * Note that full datapoints are returned only when "return_full_datapoint"
     * is set to true. Otherwise, only the "datapoint_id" and "crowding_tag"
     * fields are populated.
     * </pre>
     *
     * <code>.google.cloud.aiplatform.v1beta1.IndexDatapoint datapoint = 1;</code>
     *
     * @return The datapoint.
     */
    @java.lang.Override
    public com.google.cloud.aiplatform.v1beta1.IndexDatapoint getDatapoint() {
      return datapoint_ == null
          ? com.google.cloud.aiplatform.v1beta1.IndexDatapoint.getDefaultInstance()
          : datapoint_;
    }
    /**
     *
     *
     * <pre>
     * The datapoint of the neighbor.
     * Note that full datapoints are returned only when "return_full_datapoint"
     * is set to true. Otherwise, only the "datapoint_id" and "crowding_tag"
     * fields are populated.
     * </pre>
     *
     * <code>.google.cloud.aiplatform.v1beta1.IndexDatapoint datapoint = 1;</code>
     */
    @java.lang.Override
    public com.google.cloud.aiplatform.v1beta1.IndexDatapointOrBuilder getDatapointOrBuilder() {
      return datapoint_ == null
          ? com.google.cloud.aiplatform.v1beta1.IndexDatapoint.getDefaultInstance()
          : datapoint_;
    }

    public static final int DISTANCE_FIELD_NUMBER = 2;
    private double distance_ = 0D;
    /**
     *
     *
     * <pre>
     * The distance between the neighbor and the query vector.
     * </pre>
     *
     * <code>double distance = 2;</code>
     *
     * @return The distance.
     */
    @java.lang.Override
    public double getDistance() {
      return distance_;
    }

    private byte memoizedIsInitialized = -1;

    @java.lang.Override
    public final boolean isInitialized() {
      byte isInitialized = memoizedIsInitialized;
      if (isInitialized == 1) return true;
      if (isInitialized == 0) return false;

      memoizedIsInitialized = 1;
      return true;
    }

    @java.lang.Override
    public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
      if (((bitField0_ & 0x00000001) != 0)) {
        output.writeMessage(1, getDatapoint());
      }
      if (java.lang.Double.doubleToRawLongBits(distance_) != 0) {
        output.writeDouble(2, distance_);
      }
      getUnknownFields().writeTo(output);
    }

    @java.lang.Override
    public int getSerializedSize() {
      int size = memoizedSize;
      if (size != -1) return size;

      size = 0;
      if (((bitField0_ & 0x00000001) != 0)) {
        size += com.google.protobuf.CodedOutputStream.computeMessageSize(1, getDatapoint());
      }
      if (java.lang.Double.doubleToRawLongBits(distance_) != 0) {
        size += com.google.protobuf.CodedOutputStream.computeDoubleSize(2, distance_);
      }
      size += getUnknownFields().getSerializedSize();
      memoizedSize = size;
      return size;
    }

    @java.lang.Override
    public boolean equals(final java.lang.Object obj) {
      if (obj == this) {
        return true;
      }
      if (!(obj instanceof com.google.cloud.aiplatform.v1beta1.FindNeighborsResponse.Neighbor)) {
        return super.equals(obj);
      }
      com.google.cloud.aiplatform.v1beta1.FindNeighborsResponse.Neighbor other =
          (com.google.cloud.aiplatform.v1beta1.FindNeighborsResponse.Neighbor) obj;

      if (hasDatapoint() != other.hasDatapoint()) return false;
      if (hasDatapoint()) {
        if (!getDatapoint().equals(other.getDatapoint())) return false;
      }
      if (java.lang.Double.doubleToLongBits(getDistance())
          != java.lang.Double.doubleToLongBits(other.getDistance())) return false;
      if (!getUnknownFields().equals(other.getUnknownFields())) return false;
      return true;
    }

    @java.lang.Override
    public int hashCode() {
      if (memoizedHashCode != 0) {
        return memoizedHashCode;
      }
      int hash = 41;
      hash = (19 * hash) + getDescriptor().hashCode();
      if (hasDatapoint()) {
        hash = (37 * hash) + DATAPOINT_FIELD_NUMBER;
        hash = (53 * hash) + getDatapoint().hashCode();
      }
      hash = (37 * hash) + DISTANCE_FIELD_NUMBER;
      hash =
          (53 * hash)
              + com.google.protobuf.Internal.hashLong(
                  java.lang.Double.doubleToLongBits(getDistance()));
      hash = (29 * hash) + getUnknownFields().hashCode();
      memoizedHashCode = hash;
      return hash;
    }

    public static com.google.cloud.aiplatform.v1beta1.FindNeighborsResponse.Neighbor parseFrom(
        java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.aiplatform.v1beta1.FindNeighborsResponse.Neighbor parseFrom(
        java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.aiplatform.v1beta1.FindNeighborsResponse.Neighbor parseFrom(
        com.google.protobuf.ByteString data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.aiplatform.v1beta1.FindNeighborsResponse.Neighbor parseFrom(
        com.google.protobuf.ByteString data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.aiplatform.v1beta1.FindNeighborsResponse.Neighbor parseFrom(
        byte[] data) throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.aiplatform.v1beta1.FindNeighborsResponse.Neighbor parseFrom(
        byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.aiplatform.v1beta1.FindNeighborsResponse.Neighbor parseFrom(
        java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.cloud.aiplatform.v1beta1.FindNeighborsResponse.Neighbor parseFrom(
        java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.cloud.aiplatform.v1beta1.FindNeighborsResponse.Neighbor
        parseDelimitedFrom(java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
    }

    public static com.google.cloud.aiplatform.v1beta1.FindNeighborsResponse.Neighbor
        parseDelimitedFrom(
            java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.cloud.aiplatform.v1beta1.FindNeighborsResponse.Neighbor parseFrom(
        com.google.protobuf.CodedInputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.cloud.aiplatform.v1beta1.FindNeighborsResponse.Neighbor parseFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    @java.lang.Override
    public Builder newBuilderForType() {
      return newBuilder();
    }

    public static Builder newBuilder() {
      return DEFAULT_INSTANCE.toBuilder();
    }

    public static Builder newBuilder(
        com.google.cloud.aiplatform.v1beta1.FindNeighborsResponse.Neighbor prototype) {
      return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }

    @java.lang.Override
    public Builder toBuilder() {
      return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
    }

    @java.lang.Override
    protected Builder newBuilderForType(
        com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      Builder builder = new Builder(parent);
      return builder;
    }
    /**
     *
     *
     * <pre>
     * A neighbor of the query vector.
     * </pre>
     *
     * Protobuf type {@code google.cloud.aiplatform.v1beta1.FindNeighborsResponse.Neighbor}
     */
    public static final class Builder
        extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
        implements
        // @@protoc_insertion_point(builder_implements:google.cloud.aiplatform.v1beta1.FindNeighborsResponse.Neighbor)
        com.google.cloud.aiplatform.v1beta1.FindNeighborsResponse.NeighborOrBuilder {
      public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
        return com.google.cloud.aiplatform.v1beta1.MatchServiceProto
            .internal_static_google_cloud_aiplatform_v1beta1_FindNeighborsResponse_Neighbor_descriptor;
      }

      @java.lang.Override
      protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return com.google.cloud.aiplatform.v1beta1.MatchServiceProto
            .internal_static_google_cloud_aiplatform_v1beta1_FindNeighborsResponse_Neighbor_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                com.google.cloud.aiplatform.v1beta1.FindNeighborsResponse.Neighbor.class,
                com.google.cloud.aiplatform.v1beta1.FindNeighborsResponse.Neighbor.Builder.class);
      }

      // Construct using
      // com.google.cloud.aiplatform.v1beta1.FindNeighborsResponse.Neighbor.newBuilder()
      private Builder() {
        maybeForceBuilderInitialization();
      }

      private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
        super(parent);
        maybeForceBuilderInitialization();
      }

      private void maybeForceBuilderInitialization() {
        if (com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders) {
          getDatapointFieldBuilder();
        }
      }

      @java.lang.Override
      public Builder clear() {
        super.clear();
        bitField0_ = 0;
        datapoint_ = null;
        if (datapointBuilder_ != null) {
          datapointBuilder_.dispose();
          datapointBuilder_ = null;
        }
        distance_ = 0D;
        return this;
      }

      @java.lang.Override
      public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
        return com.google.cloud.aiplatform.v1beta1.MatchServiceProto
            .internal_static_google_cloud_aiplatform_v1beta1_FindNeighborsResponse_Neighbor_descriptor;
      }

      @java.lang.Override
      public com.google.cloud.aiplatform.v1beta1.FindNeighborsResponse.Neighbor
          getDefaultInstanceForType() {
        return com.google.cloud.aiplatform.v1beta1.FindNeighborsResponse.Neighbor
            .getDefaultInstance();
      }

      @java.lang.Override
      public com.google.cloud.aiplatform.v1beta1.FindNeighborsResponse.Neighbor build() {
        com.google.cloud.aiplatform.v1beta1.FindNeighborsResponse.Neighbor result = buildPartial();
        if (!result.isInitialized()) {
          throw newUninitializedMessageException(result);
        }
        return result;
      }

      @java.lang.Override
      public com.google.cloud.aiplatform.v1beta1.FindNeighborsResponse.Neighbor buildPartial() {
        com.google.cloud.aiplatform.v1beta1.FindNeighborsResponse.Neighbor result =
            new com.google.cloud.aiplatform.v1beta1.FindNeighborsResponse.Neighbor(this);
        if (bitField0_ != 0) {
          buildPartial0(result);
        }
        onBuilt();
        return result;
      }

      private void buildPartial0(
          com.google.cloud.aiplatform.v1beta1.FindNeighborsResponse.Neighbor result) {
        int from_bitField0_ = bitField0_;
        int to_bitField0_ = 0;
        if (((from_bitField0_ & 0x00000001) != 0)) {
          result.datapoint_ = datapointBuilder_ == null ? datapoint_ : datapointBuilder_.build();
          to_bitField0_ |= 0x00000001;
        }
        if (((from_bitField0_ & 0x00000002) != 0)) {
          result.distance_ = distance_;
        }
        result.bitField0_ |= to_bitField0_;
      }

      @java.lang.Override
      public Builder clone() {
        return super.clone();
      }

      @java.lang.Override
      public Builder setField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.setField(field, value);
      }

      @java.lang.Override
      public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
        return super.clearField(field);
      }

      @java.lang.Override
      public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
        return super.clearOneof(oneof);
      }

      @java.lang.Override
      public Builder setRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          int index,
          java.lang.Object value) {
        return super.setRepeatedField(field, index, value);
      }

      @java.lang.Override
      public Builder addRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.addRepeatedField(field, value);
      }

      @java.lang.Override
      public Builder mergeFrom(com.google.protobuf.Message other) {
        if (other instanceof com.google.cloud.aiplatform.v1beta1.FindNeighborsResponse.Neighbor) {
          return mergeFrom(
              (com.google.cloud.aiplatform.v1beta1.FindNeighborsResponse.Neighbor) other);
        } else {
          super.mergeFrom(other);
          return this;
        }
      }

      public Builder mergeFrom(
          com.google.cloud.aiplatform.v1beta1.FindNeighborsResponse.Neighbor other) {
        if (other
            == com.google.cloud.aiplatform.v1beta1.FindNeighborsResponse.Neighbor
                .getDefaultInstance()) return this;
        if (other.hasDatapoint()) {
          mergeDatapoint(other.getDatapoint());
        }
        if (other.getDistance() != 0D) {
          setDistance(other.getDistance());
        }
        this.mergeUnknownFields(other.getUnknownFields());
        onChanged();
        return this;
      }

      @java.lang.Override
      public final boolean isInitialized() {
        return true;
      }

      @java.lang.Override
      public Builder mergeFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        if (extensionRegistry == null) {
          throw new java.lang.NullPointerException();
        }
        try {
          boolean done = false;
          while (!done) {
            int tag = input.readTag();
            switch (tag) {
              case 0:
                done = true;
                break;
              case 10:
                {
                  input.readMessage(getDatapointFieldBuilder().getBuilder(), extensionRegistry);
                  bitField0_ |= 0x00000001;
                  break;
                } // case 10
              case 17:
                {
                  distance_ = input.readDouble();
                  bitField0_ |= 0x00000002;
                  break;
                } // case 17
              default:
                {
                  if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                    done = true; // was an endgroup tag
                  }
                  break;
                } // default:
            } // switch (tag)
          } // while (!done)
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          throw e.unwrapIOException();
        } finally {
          onChanged();
        } // finally
        return this;
      }

      private int bitField0_;

      private com.google.cloud.aiplatform.v1beta1.IndexDatapoint datapoint_;
      private com.google.protobuf.SingleFieldBuilderV3<
              com.google.cloud.aiplatform.v1beta1.IndexDatapoint,
              com.google.cloud.aiplatform.v1beta1.IndexDatapoint.Builder,
              com.google.cloud.aiplatform.v1beta1.IndexDatapointOrBuilder>
          datapointBuilder_;
      /**
       *
       *
       * <pre>
       * The datapoint of the neighbor.
       * Note that full datapoints are returned only when "return_full_datapoint"
       * is set to true. Otherwise, only the "datapoint_id" and "crowding_tag"
       * fields are populated.
       * </pre>
       *
       * <code>.google.cloud.aiplatform.v1beta1.IndexDatapoint datapoint = 1;</code>
       *
       * @return Whether the datapoint field is set.
       */
      public boolean hasDatapoint() {
        return ((bitField0_ & 0x00000001) != 0);
      }
      /**
       *
       *
       * <pre>
       * The datapoint of the neighbor.
       * Note that full datapoints are returned only when "return_full_datapoint"
       * is set to true. Otherwise, only the "datapoint_id" and "crowding_tag"
       * fields are populated.
       * </pre>
       *
       * <code>.google.cloud.aiplatform.v1beta1.IndexDatapoint datapoint = 1;</code>
       *
       * @return The datapoint.
       */
      public com.google.cloud.aiplatform.v1beta1.IndexDatapoint getDatapoint() {
        if (datapointBuilder_ == null) {
          return datapoint_ == null
              ? com.google.cloud.aiplatform.v1beta1.IndexDatapoint.getDefaultInstance()
              : datapoint_;
        } else {
          return datapointBuilder_.getMessage();
        }
      }
      /**
       *
       *
       * <pre>
       * The datapoint of the neighbor.
       * Note that full datapoints are returned only when "return_full_datapoint"
       * is set to true. Otherwise, only the "datapoint_id" and "crowding_tag"
       * fields are populated.
       * </pre>
       *
       * <code>.google.cloud.aiplatform.v1beta1.IndexDatapoint datapoint = 1;</code>
       */
      public Builder setDatapoint(com.google.cloud.aiplatform.v1beta1.IndexDatapoint value) {
        if (datapointBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          datapoint_ = value;
        } else {
          datapointBuilder_.setMessage(value);
        }
        bitField0_ |= 0x00000001;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * The datapoint of the neighbor.
       * Note that full datapoints are returned only when "return_full_datapoint"
       * is set to true. Otherwise, only the "datapoint_id" and "crowding_tag"
       * fields are populated.
       * </pre>
       *
       * <code>.google.cloud.aiplatform.v1beta1.IndexDatapoint datapoint = 1;</code>
       */
      public Builder setDatapoint(
          com.google.cloud.aiplatform.v1beta1.IndexDatapoint.Builder builderForValue) {
        if (datapointBuilder_ == null) {
          datapoint_ = builderForValue.build();
        } else {
          datapointBuilder_.setMessage(builderForValue.build());
        }
        bitField0_ |= 0x00000001;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * The datapoint of the neighbor.
       * Note that full datapoints are returned only when "return_full_datapoint"
       * is set to true. Otherwise, only the "datapoint_id" and "crowding_tag"
       * fields are populated.
       * </pre>
       *
       * <code>.google.cloud.aiplatform.v1beta1.IndexDatapoint datapoint = 1;</code>
       */
      public Builder mergeDatapoint(com.google.cloud.aiplatform.v1beta1.IndexDatapoint value) {
        if (datapointBuilder_ == null) {
          if (((bitField0_ & 0x00000001) != 0)
              && datapoint_ != null
              && datapoint_
                  != com.google.cloud.aiplatform.v1beta1.IndexDatapoint.getDefaultInstance()) {
            getDatapointBuilder().mergeFrom(value);
          } else {
            datapoint_ = value;
          }
        } else {
          datapointBuilder_.mergeFrom(value);
        }
        if (datapoint_ != null) {
          bitField0_ |= 0x00000001;
          onChanged();
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * The datapoint of the neighbor.
       * Note that full datapoints are returned only when "return_full_datapoint"
       * is set to true. Otherwise, only the "datapoint_id" and "crowding_tag"
       * fields are populated.
       * </pre>
       *
       * <code>.google.cloud.aiplatform.v1beta1.IndexDatapoint datapoint = 1;</code>
       */
      public Builder clearDatapoint() {
        bitField0_ = (bitField0_ & ~0x00000001);
        datapoint_ = null;
        if (datapointBuilder_ != null) {
          datapointBuilder_.dispose();
          datapointBuilder_ = null;
        }
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * The datapoint of the neighbor.
       * Note that full datapoints are returned only when "return_full_datapoint"
       * is set to true. Otherwise, only the "datapoint_id" and "crowding_tag"
       * fields are populated.
       * </pre>
       *
       * <code>.google.cloud.aiplatform.v1beta1.IndexDatapoint datapoint = 1;</code>
       */
      public com.google.cloud.aiplatform.v1beta1.IndexDatapoint.Builder getDatapointBuilder() {
        bitField0_ |= 0x00000001;
        onChanged();
        return getDatapointFieldBuilder().getBuilder();
      }
      /**
       *
       *
       * <pre>
       * The datapoint of the neighbor.
       * Note that full datapoints are returned only when "return_full_datapoint"
       * is set to true. Otherwise, only the "datapoint_id" and "crowding_tag"
       * fields are populated.
       * </pre>
       *
       * <code>.google.cloud.aiplatform.v1beta1.IndexDatapoint datapoint = 1;</code>
       */
      public com.google.cloud.aiplatform.v1beta1.IndexDatapointOrBuilder getDatapointOrBuilder() {
        if (datapointBuilder_ != null) {
          return datapointBuilder_.getMessageOrBuilder();
        } else {
          return datapoint_ == null
              ? com.google.cloud.aiplatform.v1beta1.IndexDatapoint.getDefaultInstance()
              : datapoint_;
        }
      }
      /**
       *
       *
       * <pre>
       * The datapoint of the neighbor.
       * Note that full datapoints are returned only when "return_full_datapoint"
       * is set to true. Otherwise, only the "datapoint_id" and "crowding_tag"
       * fields are populated.
       * </pre>
       *
       * <code>.google.cloud.aiplatform.v1beta1.IndexDatapoint datapoint = 1;</code>
       */
      private com.google.protobuf.SingleFieldBuilderV3<
              com.google.cloud.aiplatform.v1beta1.IndexDatapoint,
              com.google.cloud.aiplatform.v1beta1.IndexDatapoint.Builder,
              com.google.cloud.aiplatform.v1beta1.IndexDatapointOrBuilder>
          getDatapointFieldBuilder() {
        if (datapointBuilder_ == null) {
          datapointBuilder_ =
              new com.google.protobuf.SingleFieldBuilderV3<
                  com.google.cloud.aiplatform.v1beta1.IndexDatapoint,
                  com.google.cloud.aiplatform.v1beta1.IndexDatapoint.Builder,
                  com.google.cloud.aiplatform.v1beta1.IndexDatapointOrBuilder>(
                  getDatapoint(), getParentForChildren(), isClean());
          datapoint_ = null;
        }
        return datapointBuilder_;
      }

      private double distance_;
      /**
       *
       *
       * <pre>
       * The distance between the neighbor and the query vector.
       * </pre>
       *
       * <code>double distance = 2;</code>
       *
       * @return The distance.
       */
      @java.lang.Override
      public double getDistance() {
        return distance_;
      }
      /**
       *
       *
       * <pre>
       * The distance between the neighbor and the query vector.
       * </pre>
       *
       * <code>double distance = 2;</code>
       *
       * @param value The distance to set.
       * @return This builder for chaining.
       */
      public Builder setDistance(double value) {

        distance_ = value;
        bitField0_ |= 0x00000002;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * The distance between the neighbor and the query vector.
       * </pre>
       *
       * <code>double distance = 2;</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearDistance() {
        bitField0_ = (bitField0_ & ~0x00000002);
        distance_ = 0D;
        onChanged();
        return this;
      }

      @java.lang.Override
      public final Builder setUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.setUnknownFields(unknownFields);
      }

      @java.lang.Override
      public final Builder mergeUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.mergeUnknownFields(unknownFields);
      }

      // @@protoc_insertion_point(builder_scope:google.cloud.aiplatform.v1beta1.FindNeighborsResponse.Neighbor)
    }

    // @@protoc_insertion_point(class_scope:google.cloud.aiplatform.v1beta1.FindNeighborsResponse.Neighbor)
    private static final com.google.cloud.aiplatform.v1beta1.FindNeighborsResponse.Neighbor
        DEFAULT_INSTANCE;

    static {
      DEFAULT_INSTANCE = new com.google.cloud.aiplatform.v1beta1.FindNeighborsResponse.Neighbor();
    }

    public static com.google.cloud.aiplatform.v1beta1.FindNeighborsResponse.Neighbor
        getDefaultInstance() {
      return DEFAULT_INSTANCE;
    }

    private static final com.google.protobuf.Parser<Neighbor> PARSER =
        new com.google.protobuf.AbstractParser<Neighbor>() {
          @java.lang.Override
          public Neighbor parsePartialFrom(
              com.google.protobuf.CodedInputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
            Builder builder = newBuilder();
            try {
              builder.mergeFrom(input, extensionRegistry);
            } catch (com.google.protobuf.InvalidProtocolBufferException e) {
              throw e.setUnfinishedMessage(builder.buildPartial());
            } catch (com.google.protobuf.UninitializedMessageException e) {
              throw e.asInvalidProtocolBufferException()
                  .setUnfinishedMessage(builder.buildPartial());
            } catch (java.io.IOException e) {
              throw new com.google.protobuf.InvalidProtocolBufferException(e)
                  .setUnfinishedMessage(builder.buildPartial());
            }
            return builder.buildPartial();
          }
        };

    public static com.google.protobuf.Parser<Neighbor> parser() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.protobuf.Parser<Neighbor> getParserForType() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.cloud.aiplatform.v1beta1.FindNeighborsResponse.Neighbor
        getDefaultInstanceForType() {
      return DEFAULT_INSTANCE;
    }
  }

  public interface NearestNeighborsOrBuilder
      extends
      // @@protoc_insertion_point(interface_extends:google.cloud.aiplatform.v1beta1.FindNeighborsResponse.NearestNeighbors)
      com.google.protobuf.MessageOrBuilder {

    /**
     *
     *
     * <pre>
     * The ID of the query datapoint.
     * </pre>
     *
     * <code>string id = 1;</code>
     *
     * @return The id.
     */
    java.lang.String getId();
    /**
     *
     *
     * <pre>
     * The ID of the query datapoint.
     * </pre>
     *
     * <code>string id = 1;</code>
     *
     * @return The bytes for id.
     */
    com.google.protobuf.ByteString getIdBytes();

    /**
     *
     *
     * <pre>
     * All its neighbors.
     * </pre>
     *
     * <code>repeated .google.cloud.aiplatform.v1beta1.FindNeighborsResponse.Neighbor neighbors = 2;
     * </code>
     */
    java.util.List<com.google.cloud.aiplatform.v1beta1.FindNeighborsResponse.Neighbor>
        getNeighborsList();
    /**
     *
     *
     * <pre>
     * All its neighbors.
     * </pre>
     *
     * <code>repeated .google.cloud.aiplatform.v1beta1.FindNeighborsResponse.Neighbor neighbors = 2;
     * </code>
     */
    com.google.cloud.aiplatform.v1beta1.FindNeighborsResponse.Neighbor getNeighbors(int index);
    /**
     *
     *
     * <pre>
     * All its neighbors.
     * </pre>
     *
     * <code>repeated .google.cloud.aiplatform.v1beta1.FindNeighborsResponse.Neighbor neighbors = 2;
     * </code>
     */
    int getNeighborsCount();
    /**
     *
     *
     * <pre>
     * All its neighbors.
     * </pre>
     *
     * <code>repeated .google.cloud.aiplatform.v1beta1.FindNeighborsResponse.Neighbor neighbors = 2;
     * </code>
     */
    java.util.List<
            ? extends com.google.cloud.aiplatform.v1beta1.FindNeighborsResponse.NeighborOrBuilder>
        getNeighborsOrBuilderList();
    /**
     *
     *
     * <pre>
     * All its neighbors.
     * </pre>
     *
     * <code>repeated .google.cloud.aiplatform.v1beta1.FindNeighborsResponse.Neighbor neighbors = 2;
     * </code>
     */
    com.google.cloud.aiplatform.v1beta1.FindNeighborsResponse.NeighborOrBuilder
        getNeighborsOrBuilder(int index);
  }
  /**
   *
   *
   * <pre>
   * Nearest neighbors for one query.
   * </pre>
   *
   * Protobuf type {@code google.cloud.aiplatform.v1beta1.FindNeighborsResponse.NearestNeighbors}
   */
  public static final class NearestNeighbors extends com.google.protobuf.GeneratedMessageV3
      implements
      // @@protoc_insertion_point(message_implements:google.cloud.aiplatform.v1beta1.FindNeighborsResponse.NearestNeighbors)
      NearestNeighborsOrBuilder {
    private static final long serialVersionUID = 0L;
    // Use NearestNeighbors.newBuilder() to construct.
    private NearestNeighbors(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
      super(builder);
    }

    private NearestNeighbors() {
      id_ = "";
      neighbors_ = java.util.Collections.emptyList();
    }

    @java.lang.Override
    @SuppressWarnings({"unused"})
    protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
      return new NearestNeighbors();
    }

    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.aiplatform.v1beta1.MatchServiceProto
          .internal_static_google_cloud_aiplatform_v1beta1_FindNeighborsResponse_NearestNeighbors_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.aiplatform.v1beta1.MatchServiceProto
          .internal_static_google_cloud_aiplatform_v1beta1_FindNeighborsResponse_NearestNeighbors_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.aiplatform.v1beta1.FindNeighborsResponse.NearestNeighbors.class,
              com.google.cloud.aiplatform.v1beta1.FindNeighborsResponse.NearestNeighbors.Builder
                  .class);
    }

    public static final int ID_FIELD_NUMBER = 1;

    @SuppressWarnings("serial")
    private volatile java.lang.Object id_ = "";
    /**
     *
     *
     * <pre>
     * The ID of the query datapoint.
     * </pre>
     *
     * <code>string id = 1;</code>
     *
     * @return The id.
     */
    @java.lang.Override
    public java.lang.String getId() {
      java.lang.Object ref = id_;
      if (ref instanceof java.lang.String) {
        return (java.lang.String) ref;
      } else {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        id_ = s;
        return s;
      }
    }
    /**
     *
     *
     * <pre>
     * The ID of the query datapoint.
     * </pre>
     *
     * <code>string id = 1;</code>
     *
     * @return The bytes for id.
     */
    @java.lang.Override
    public com.google.protobuf.ByteString getIdBytes() {
      java.lang.Object ref = id_;
      if (ref instanceof java.lang.String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        id_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    public static final int NEIGHBORS_FIELD_NUMBER = 2;

    @SuppressWarnings("serial")
    private java.util.List<com.google.cloud.aiplatform.v1beta1.FindNeighborsResponse.Neighbor>
        neighbors_;
    /**
     *
     *
     * <pre>
     * All its neighbors.
     * </pre>
     *
     * <code>repeated .google.cloud.aiplatform.v1beta1.FindNeighborsResponse.Neighbor neighbors = 2;
     * </code>
     */
    @java.lang.Override
    public java.util.List<com.google.cloud.aiplatform.v1beta1.FindNeighborsResponse.Neighbor>
        getNeighborsList() {
      return neighbors_;
    }
    /**
     *
     *
     * <pre>
     * All its neighbors.
     * </pre>
     *
     * <code>repeated .google.cloud.aiplatform.v1beta1.FindNeighborsResponse.Neighbor neighbors = 2;
     * </code>
     */
    @java.lang.Override
    public java.util.List<
            ? extends com.google.cloud.aiplatform.v1beta1.FindNeighborsResponse.NeighborOrBuilder>
        getNeighborsOrBuilderList() {
      return neighbors_;
    }
    /**
     *
     *
     * <pre>
     * All its neighbors.
     * </pre>
     *
     * <code>repeated .google.cloud.aiplatform.v1beta1.FindNeighborsResponse.Neighbor neighbors = 2;
     * </code>
     */
    @java.lang.Override
    public int getNeighborsCount() {
      return neighbors_.size();
    }
    /**
     *
     *
     * <pre>
     * All its neighbors.
     * </pre>
     *
     * <code>repeated .google.cloud.aiplatform.v1beta1.FindNeighborsResponse.Neighbor neighbors = 2;
     * </code>
     */
    @java.lang.Override
    public com.google.cloud.aiplatform.v1beta1.FindNeighborsResponse.Neighbor getNeighbors(
        int index) {
      return neighbors_.get(index);
    }
    /**
     *
     *
     * <pre>
     * All its neighbors.
     * </pre>
     *
     * <code>repeated .google.cloud.aiplatform.v1beta1.FindNeighborsResponse.Neighbor neighbors = 2;
     * </code>
     */
    @java.lang.Override
    public com.google.cloud.aiplatform.v1beta1.FindNeighborsResponse.NeighborOrBuilder
        getNeighborsOrBuilder(int index) {
      return neighbors_.get(index);
    }

    private byte memoizedIsInitialized = -1;

    @java.lang.Override
    public final boolean isInitialized() {
      byte isInitialized = memoizedIsInitialized;
      if (isInitialized == 1) return true;
      if (isInitialized == 0) return false;

      memoizedIsInitialized = 1;
      return true;
    }

    @java.lang.Override
    public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(id_)) {
        com.google.protobuf.GeneratedMessageV3.writeString(output, 1, id_);
      }
      for (int i = 0; i < neighbors_.size(); i++) {
        output.writeMessage(2, neighbors_.get(i));
      }
      getUnknownFields().writeTo(output);
    }

    @java.lang.Override
    public int getSerializedSize() {
      int size = memoizedSize;
      if (size != -1) return size;

      size = 0;
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(id_)) {
        size += com.google.protobuf.GeneratedMessageV3.computeStringSize(1, id_);
      }
      for (int i = 0; i < neighbors_.size(); i++) {
        size += com.google.protobuf.CodedOutputStream.computeMessageSize(2, neighbors_.get(i));
      }
      size += getUnknownFields().getSerializedSize();
      memoizedSize = size;
      return size;
    }

    @java.lang.Override
    public boolean equals(final java.lang.Object obj) {
      if (obj == this) {
        return true;
      }
      if (!(obj
          instanceof com.google.cloud.aiplatform.v1beta1.FindNeighborsResponse.NearestNeighbors)) {
        return super.equals(obj);
      }
      com.google.cloud.aiplatform.v1beta1.FindNeighborsResponse.NearestNeighbors other =
          (com.google.cloud.aiplatform.v1beta1.FindNeighborsResponse.NearestNeighbors) obj;

      if (!getId().equals(other.getId())) return false;
      if (!getNeighborsList().equals(other.getNeighborsList())) return false;
      if (!getUnknownFields().equals(other.getUnknownFields())) return false;
      return true;
    }

    @java.lang.Override
    public int hashCode() {
      if (memoizedHashCode != 0) {
        return memoizedHashCode;
      }
      int hash = 41;
      hash = (19 * hash) + getDescriptor().hashCode();
      hash = (37 * hash) + ID_FIELD_NUMBER;
      hash = (53 * hash) + getId().hashCode();
      if (getNeighborsCount() > 0) {
        hash = (37 * hash) + NEIGHBORS_FIELD_NUMBER;
        hash = (53 * hash) + getNeighborsList().hashCode();
      }
      hash = (29 * hash) + getUnknownFields().hashCode();
      memoizedHashCode = hash;
      return hash;
    }

    public static com.google.cloud.aiplatform.v1beta1.FindNeighborsResponse.NearestNeighbors
        parseFrom(java.nio.ByteBuffer data)
            throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.aiplatform.v1beta1.FindNeighborsResponse.NearestNeighbors
        parseFrom(
            java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.aiplatform.v1beta1.FindNeighborsResponse.NearestNeighbors
        parseFrom(com.google.protobuf.ByteString data)
            throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.aiplatform.v1beta1.FindNeighborsResponse.NearestNeighbors
        parseFrom(
            com.google.protobuf.ByteString data,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.aiplatform.v1beta1.FindNeighborsResponse.NearestNeighbors
        parseFrom(byte[] data) throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.aiplatform.v1beta1.FindNeighborsResponse.NearestNeighbors
        parseFrom(byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.aiplatform.v1beta1.FindNeighborsResponse.NearestNeighbors
        parseFrom(java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.cloud.aiplatform.v1beta1.FindNeighborsResponse.NearestNeighbors
        parseFrom(
            java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.cloud.aiplatform.v1beta1.FindNeighborsResponse.NearestNeighbors
        parseDelimitedFrom(java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
    }

    public static com.google.cloud.aiplatform.v1beta1.FindNeighborsResponse.NearestNeighbors
        parseDelimitedFrom(
            java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.cloud.aiplatform.v1beta1.FindNeighborsResponse.NearestNeighbors
        parseFrom(com.google.protobuf.CodedInputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.cloud.aiplatform.v1beta1.FindNeighborsResponse.NearestNeighbors
        parseFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    @java.lang.Override
    public Builder newBuilderForType() {
      return newBuilder();
    }

    public static Builder newBuilder() {
      return DEFAULT_INSTANCE.toBuilder();
    }

    public static Builder newBuilder(
        com.google.cloud.aiplatform.v1beta1.FindNeighborsResponse.NearestNeighbors prototype) {
      return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }

    @java.lang.Override
    public Builder toBuilder() {
      return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
    }

    @java.lang.Override
    protected Builder newBuilderForType(
        com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      Builder builder = new Builder(parent);
      return builder;
    }
    /**
     *
     *
     * <pre>
     * Nearest neighbors for one query.
     * </pre>
     *
     * Protobuf type {@code google.cloud.aiplatform.v1beta1.FindNeighborsResponse.NearestNeighbors}
     */
    public static final class Builder
        extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
        implements
        // @@protoc_insertion_point(builder_implements:google.cloud.aiplatform.v1beta1.FindNeighborsResponse.NearestNeighbors)
        com.google.cloud.aiplatform.v1beta1.FindNeighborsResponse.NearestNeighborsOrBuilder {
      public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
        return com.google.cloud.aiplatform.v1beta1.MatchServiceProto
            .internal_static_google_cloud_aiplatform_v1beta1_FindNeighborsResponse_NearestNeighbors_descriptor;
      }

      @java.lang.Override
      protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return com.google.cloud.aiplatform.v1beta1.MatchServiceProto
            .internal_static_google_cloud_aiplatform_v1beta1_FindNeighborsResponse_NearestNeighbors_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                com.google.cloud.aiplatform.v1beta1.FindNeighborsResponse.NearestNeighbors.class,
                com.google.cloud.aiplatform.v1beta1.FindNeighborsResponse.NearestNeighbors.Builder
                    .class);
      }

      // Construct using
      // com.google.cloud.aiplatform.v1beta1.FindNeighborsResponse.NearestNeighbors.newBuilder()
      private Builder() {}

      private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
        super(parent);
      }

      @java.lang.Override
      public Builder clear() {
        super.clear();
        bitField0_ = 0;
        id_ = "";
        if (neighborsBuilder_ == null) {
          neighbors_ = java.util.Collections.emptyList();
        } else {
          neighbors_ = null;
          neighborsBuilder_.clear();
        }
        bitField0_ = (bitField0_ & ~0x00000002);
        return this;
      }

      @java.lang.Override
      public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
        return com.google.cloud.aiplatform.v1beta1.MatchServiceProto
            .internal_static_google_cloud_aiplatform_v1beta1_FindNeighborsResponse_NearestNeighbors_descriptor;
      }

      @java.lang.Override
      public com.google.cloud.aiplatform.v1beta1.FindNeighborsResponse.NearestNeighbors
          getDefaultInstanceForType() {
        return com.google.cloud.aiplatform.v1beta1.FindNeighborsResponse.NearestNeighbors
            .getDefaultInstance();
      }

      @java.lang.Override
      public com.google.cloud.aiplatform.v1beta1.FindNeighborsResponse.NearestNeighbors build() {
        com.google.cloud.aiplatform.v1beta1.FindNeighborsResponse.NearestNeighbors result =
            buildPartial();
        if (!result.isInitialized()) {
          throw newUninitializedMessageException(result);
        }
        return result;
      }

      @java.lang.Override
      public com.google.cloud.aiplatform.v1beta1.FindNeighborsResponse.NearestNeighbors
          buildPartial() {
        com.google.cloud.aiplatform.v1beta1.FindNeighborsResponse.NearestNeighbors result =
            new com.google.cloud.aiplatform.v1beta1.FindNeighborsResponse.NearestNeighbors(this);
        buildPartialRepeatedFields(result);
        if (bitField0_ != 0) {
          buildPartial0(result);
        }
        onBuilt();
        return result;
      }

      private void buildPartialRepeatedFields(
          com.google.cloud.aiplatform.v1beta1.FindNeighborsResponse.NearestNeighbors result) {
        if (neighborsBuilder_ == null) {
          if (((bitField0_ & 0x00000002) != 0)) {
            neighbors_ = java.util.Collections.unmodifiableList(neighbors_);
            bitField0_ = (bitField0_ & ~0x00000002);
          }
          result.neighbors_ = neighbors_;
        } else {
          result.neighbors_ = neighborsBuilder_.build();
        }
      }

      private void buildPartial0(
          com.google.cloud.aiplatform.v1beta1.FindNeighborsResponse.NearestNeighbors result) {
        int from_bitField0_ = bitField0_;
        if (((from_bitField0_ & 0x00000001) != 0)) {
          result.id_ = id_;
        }
      }

      @java.lang.Override
      public Builder clone() {
        return super.clone();
      }

      @java.lang.Override
      public Builder setField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.setField(field, value);
      }

      @java.lang.Override
      public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
        return super.clearField(field);
      }

      @java.lang.Override
      public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
        return super.clearOneof(oneof);
      }

      @java.lang.Override
      public Builder setRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          int index,
          java.lang.Object value) {
        return super.setRepeatedField(field, index, value);
      }

      @java.lang.Override
      public Builder addRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.addRepeatedField(field, value);
      }

      @java.lang.Override
      public Builder mergeFrom(com.google.protobuf.Message other) {
        if (other
            instanceof com.google.cloud.aiplatform.v1beta1.FindNeighborsResponse.NearestNeighbors) {
          return mergeFrom(
              (com.google.cloud.aiplatform.v1beta1.FindNeighborsResponse.NearestNeighbors) other);
        } else {
          super.mergeFrom(other);
          return this;
        }
      }

      public Builder mergeFrom(
          com.google.cloud.aiplatform.v1beta1.FindNeighborsResponse.NearestNeighbors other) {
        if (other
            == com.google.cloud.aiplatform.v1beta1.FindNeighborsResponse.NearestNeighbors
                .getDefaultInstance()) return this;
        if (!other.getId().isEmpty()) {
          id_ = other.id_;
          bitField0_ |= 0x00000001;
          onChanged();
        }
        if (neighborsBuilder_ == null) {
          if (!other.neighbors_.isEmpty()) {
            if (neighbors_.isEmpty()) {
              neighbors_ = other.neighbors_;
              bitField0_ = (bitField0_ & ~0x00000002);
            } else {
              ensureNeighborsIsMutable();
              neighbors_.addAll(other.neighbors_);
            }
            onChanged();
          }
        } else {
          if (!other.neighbors_.isEmpty()) {
            if (neighborsBuilder_.isEmpty()) {
              neighborsBuilder_.dispose();
              neighborsBuilder_ = null;
              neighbors_ = other.neighbors_;
              bitField0_ = (bitField0_ & ~0x00000002);
              neighborsBuilder_ =
                  com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders
                      ? getNeighborsFieldBuilder()
                      : null;
            } else {
              neighborsBuilder_.addAllMessages(other.neighbors_);
            }
          }
        }
        this.mergeUnknownFields(other.getUnknownFields());
        onChanged();
        return this;
      }

      @java.lang.Override
      public final boolean isInitialized() {
        return true;
      }

      @java.lang.Override
      public Builder mergeFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        if (extensionRegistry == null) {
          throw new java.lang.NullPointerException();
        }
        try {
          boolean done = false;
          while (!done) {
            int tag = input.readTag();
            switch (tag) {
              case 0:
                done = true;
                break;
              case 10:
                {
                  id_ = input.readStringRequireUtf8();
                  bitField0_ |= 0x00000001;
                  break;
                } // case 10
              case 18:
                {
                  com.google.cloud.aiplatform.v1beta1.FindNeighborsResponse.Neighbor m =
                      input.readMessage(
                          com.google.cloud.aiplatform.v1beta1.FindNeighborsResponse.Neighbor
                              .parser(),
                          extensionRegistry);
                  if (neighborsBuilder_ == null) {
                    ensureNeighborsIsMutable();
                    neighbors_.add(m);
                  } else {
                    neighborsBuilder_.addMessage(m);
                  }
                  break;
                } // case 18
              default:
                {
                  if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                    done = true; // was an endgroup tag
                  }
                  break;
                } // default:
            } // switch (tag)
          } // while (!done)
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          throw e.unwrapIOException();
        } finally {
          onChanged();
        } // finally
        return this;
      }

      private int bitField0_;

      private java.lang.Object id_ = "";
      /**
       *
       *
       * <pre>
       * The ID of the query datapoint.
       * </pre>
       *
       * <code>string id = 1;</code>
       *
       * @return The id.
       */
      public java.lang.String getId() {
        java.lang.Object ref = id_;
        if (!(ref instanceof java.lang.String)) {
          com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
          java.lang.String s = bs.toStringUtf8();
          id_ = s;
          return s;
        } else {
          return (java.lang.String) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * The ID of the query datapoint.
       * </pre>
       *
       * <code>string id = 1;</code>
       *
       * @return The bytes for id.
       */
      public com.google.protobuf.ByteString getIdBytes() {
        java.lang.Object ref = id_;
        if (ref instanceof String) {
          com.google.protobuf.ByteString b =
              com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
          id_ = b;
          return b;
        } else {
          return (com.google.protobuf.ByteString) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * The ID of the query datapoint.
       * </pre>
       *
       * <code>string id = 1;</code>
       *
       * @param value The id to set.
       * @return This builder for chaining.
       */
      public Builder setId(java.lang.String value) {
        if (value == null) {
          throw new NullPointerException();
        }
        id_ = value;
        bitField0_ |= 0x00000001;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * The ID of the query datapoint.
       * </pre>
       *
       * <code>string id = 1;</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearId() {
        id_ = getDefaultInstance().getId();
        bitField0_ = (bitField0_ & ~0x00000001);
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * The ID of the query datapoint.
       * </pre>
       *
       * <code>string id = 1;</code>
       *
       * @param value The bytes for id to set.
       * @return This builder for chaining.
       */
      public Builder setIdBytes(com.google.protobuf.ByteString value) {
        if (value == null) {
          throw new NullPointerException();
        }
        checkByteStringIsUtf8(value);
        id_ = value;
        bitField0_ |= 0x00000001;
        onChanged();
        return this;
      }

      private java.util.List<com.google.cloud.aiplatform.v1beta1.FindNeighborsResponse.Neighbor>
          neighbors_ = java.util.Collections.emptyList();

      private void ensureNeighborsIsMutable() {
        if (!((bitField0_ & 0x00000002) != 0)) {
          neighbors_ =
              new java.util.ArrayList<
                  com.google.cloud.aiplatform.v1beta1.FindNeighborsResponse.Neighbor>(neighbors_);
          bitField0_ |= 0x00000002;
        }
      }

      private com.google.protobuf.RepeatedFieldBuilderV3<
              com.google.cloud.aiplatform.v1beta1.FindNeighborsResponse.Neighbor,
              com.google.cloud.aiplatform.v1beta1.FindNeighborsResponse.Neighbor.Builder,
              com.google.cloud.aiplatform.v1beta1.FindNeighborsResponse.NeighborOrBuilder>
          neighborsBuilder_;

      /**
       *
       *
       * <pre>
       * All its neighbors.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.aiplatform.v1beta1.FindNeighborsResponse.Neighbor neighbors = 2;
       * </code>
       */
      public java.util.List<com.google.cloud.aiplatform.v1beta1.FindNeighborsResponse.Neighbor>
          getNeighborsList() {
        if (neighborsBuilder_ == null) {
          return java.util.Collections.unmodifiableList(neighbors_);
        } else {
          return neighborsBuilder_.getMessageList();
        }
      }
      /**
       *
       *
       * <pre>
       * All its neighbors.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.aiplatform.v1beta1.FindNeighborsResponse.Neighbor neighbors = 2;
       * </code>
       */
      public int getNeighborsCount() {
        if (neighborsBuilder_ == null) {
          return neighbors_.size();
        } else {
          return neighborsBuilder_.getCount();
        }
      }
      /**
       *
       *
       * <pre>
       * All its neighbors.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.aiplatform.v1beta1.FindNeighborsResponse.Neighbor neighbors = 2;
       * </code>
       */
      public com.google.cloud.aiplatform.v1beta1.FindNeighborsResponse.Neighbor getNeighbors(
          int index) {
        if (neighborsBuilder_ == null) {
          return neighbors_.get(index);
        } else {
          return neighborsBuilder_.getMessage(index);
        }
      }
      /**
       *
       *
       * <pre>
       * All its neighbors.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.aiplatform.v1beta1.FindNeighborsResponse.Neighbor neighbors = 2;
       * </code>
       */
      public Builder setNeighbors(
          int index, com.google.cloud.aiplatform.v1beta1.FindNeighborsResponse.Neighbor value) {
        if (neighborsBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          ensureNeighborsIsMutable();
          neighbors_.set(index, value);
          onChanged();
        } else {
          neighborsBuilder_.setMessage(index, value);
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * All its neighbors.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.aiplatform.v1beta1.FindNeighborsResponse.Neighbor neighbors = 2;
       * </code>
       */
      public Builder setNeighbors(
          int index,
          com.google.cloud.aiplatform.v1beta1.FindNeighborsResponse.Neighbor.Builder
              builderForValue) {
        if (neighborsBuilder_ == null) {
          ensureNeighborsIsMutable();
          neighbors_.set(index, builderForValue.build());
          onChanged();
        } else {
          neighborsBuilder_.setMessage(index, builderForValue.build());
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * All its neighbors.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.aiplatform.v1beta1.FindNeighborsResponse.Neighbor neighbors = 2;
       * </code>
       */
      public Builder addNeighbors(
          com.google.cloud.aiplatform.v1beta1.FindNeighborsResponse.Neighbor value) {
        if (neighborsBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          ensureNeighborsIsMutable();
          neighbors_.add(value);
          onChanged();
        } else {
          neighborsBuilder_.addMessage(value);
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * All its neighbors.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.aiplatform.v1beta1.FindNeighborsResponse.Neighbor neighbors = 2;
       * </code>
       */
      public Builder addNeighbors(
          int index, com.google.cloud.aiplatform.v1beta1.FindNeighborsResponse.Neighbor value) {
        if (neighborsBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          ensureNeighborsIsMutable();
          neighbors_.add(index, value);
          onChanged();
        } else {
          neighborsBuilder_.addMessage(index, value);
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * All its neighbors.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.aiplatform.v1beta1.FindNeighborsResponse.Neighbor neighbors = 2;
       * </code>
       */
      public Builder addNeighbors(
          com.google.cloud.aiplatform.v1beta1.FindNeighborsResponse.Neighbor.Builder
              builderForValue) {
        if (neighborsBuilder_ == null) {
          ensureNeighborsIsMutable();
          neighbors_.add(builderForValue.build());
          onChanged();
        } else {
          neighborsBuilder_.addMessage(builderForValue.build());
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * All its neighbors.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.aiplatform.v1beta1.FindNeighborsResponse.Neighbor neighbors = 2;
       * </code>
       */
      public Builder addNeighbors(
          int index,
          com.google.cloud.aiplatform.v1beta1.FindNeighborsResponse.Neighbor.Builder
              builderForValue) {
        if (neighborsBuilder_ == null) {
          ensureNeighborsIsMutable();
          neighbors_.add(index, builderForValue.build());
          onChanged();
        } else {
          neighborsBuilder_.addMessage(index, builderForValue.build());
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * All its neighbors.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.aiplatform.v1beta1.FindNeighborsResponse.Neighbor neighbors = 2;
       * </code>
       */
      public Builder addAllNeighbors(
          java.lang.Iterable<
                  ? extends com.google.cloud.aiplatform.v1beta1.FindNeighborsResponse.Neighbor>
              values) {
        if (neighborsBuilder_ == null) {
          ensureNeighborsIsMutable();
          com.google.protobuf.AbstractMessageLite.Builder.addAll(values, neighbors_);
          onChanged();
        } else {
          neighborsBuilder_.addAllMessages(values);
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * All its neighbors.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.aiplatform.v1beta1.FindNeighborsResponse.Neighbor neighbors = 2;
       * </code>
       */
      public Builder clearNeighbors() {
        if (neighborsBuilder_ == null) {
          neighbors_ = java.util.Collections.emptyList();
          bitField0_ = (bitField0_ & ~0x00000002);
          onChanged();
        } else {
          neighborsBuilder_.clear();
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * All its neighbors.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.aiplatform.v1beta1.FindNeighborsResponse.Neighbor neighbors = 2;
       * </code>
       */
      public Builder removeNeighbors(int index) {
        if (neighborsBuilder_ == null) {
          ensureNeighborsIsMutable();
          neighbors_.remove(index);
          onChanged();
        } else {
          neighborsBuilder_.remove(index);
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * All its neighbors.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.aiplatform.v1beta1.FindNeighborsResponse.Neighbor neighbors = 2;
       * </code>
       */
      public com.google.cloud.aiplatform.v1beta1.FindNeighborsResponse.Neighbor.Builder
          getNeighborsBuilder(int index) {
        return getNeighborsFieldBuilder().getBuilder(index);
      }
      /**
       *
       *
       * <pre>
       * All its neighbors.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.aiplatform.v1beta1.FindNeighborsResponse.Neighbor neighbors = 2;
       * </code>
       */
      public com.google.cloud.aiplatform.v1beta1.FindNeighborsResponse.NeighborOrBuilder
          getNeighborsOrBuilder(int index) {
        if (neighborsBuilder_ == null) {
          return neighbors_.get(index);
        } else {
          return neighborsBuilder_.getMessageOrBuilder(index);
        }
      }
      /**
       *
       *
       * <pre>
       * All its neighbors.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.aiplatform.v1beta1.FindNeighborsResponse.Neighbor neighbors = 2;
       * </code>
       */
      public java.util.List<
              ? extends com.google.cloud.aiplatform.v1beta1.FindNeighborsResponse.NeighborOrBuilder>
          getNeighborsOrBuilderList() {
        if (neighborsBuilder_ != null) {
          return neighborsBuilder_.getMessageOrBuilderList();
        } else {
          return java.util.Collections.unmodifiableList(neighbors_);
        }
      }
      /**
       *
       *
       * <pre>
       * All its neighbors.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.aiplatform.v1beta1.FindNeighborsResponse.Neighbor neighbors = 2;
       * </code>
       */
      public com.google.cloud.aiplatform.v1beta1.FindNeighborsResponse.Neighbor.Builder
          addNeighborsBuilder() {
        return getNeighborsFieldBuilder()
            .addBuilder(
                com.google.cloud.aiplatform.v1beta1.FindNeighborsResponse.Neighbor
                    .getDefaultInstance());
      }
      /**
       *
       *
       * <pre>
       * All its neighbors.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.aiplatform.v1beta1.FindNeighborsResponse.Neighbor neighbors = 2;
       * </code>
       */
      public com.google.cloud.aiplatform.v1beta1.FindNeighborsResponse.Neighbor.Builder
          addNeighborsBuilder(int index) {
        return getNeighborsFieldBuilder()
            .addBuilder(
                index,
                com.google.cloud.aiplatform.v1beta1.FindNeighborsResponse.Neighbor
                    .getDefaultInstance());
      }
      /**
       *
       *
       * <pre>
       * All its neighbors.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.aiplatform.v1beta1.FindNeighborsResponse.Neighbor neighbors = 2;
       * </code>
       */
      public java.util.List<
              com.google.cloud.aiplatform.v1beta1.FindNeighborsResponse.Neighbor.Builder>
          getNeighborsBuilderList() {
        return getNeighborsFieldBuilder().getBuilderList();
      }

      private com.google.protobuf.RepeatedFieldBuilderV3<
              com.google.cloud.aiplatform.v1beta1.FindNeighborsResponse.Neighbor,
              com.google.cloud.aiplatform.v1beta1.FindNeighborsResponse.Neighbor.Builder,
              com.google.cloud.aiplatform.v1beta1.FindNeighborsResponse.NeighborOrBuilder>
          getNeighborsFieldBuilder() {
        if (neighborsBuilder_ == null) {
          neighborsBuilder_ =
              new com.google.protobuf.RepeatedFieldBuilderV3<
                  com.google.cloud.aiplatform.v1beta1.FindNeighborsResponse.Neighbor,
                  com.google.cloud.aiplatform.v1beta1.FindNeighborsResponse.Neighbor.Builder,
                  com.google.cloud.aiplatform.v1beta1.FindNeighborsResponse.NeighborOrBuilder>(
                  neighbors_, ((bitField0_ & 0x00000002) != 0), getParentForChildren(), isClean());
          neighbors_ = null;
        }
        return neighborsBuilder_;
      }

      @java.lang.Override
      public final Builder setUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.setUnknownFields(unknownFields);
      }

      @java.lang.Override
      public final Builder mergeUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.mergeUnknownFields(unknownFields);
      }

      // @@protoc_insertion_point(builder_scope:google.cloud.aiplatform.v1beta1.FindNeighborsResponse.NearestNeighbors)
    }

    // @@protoc_insertion_point(class_scope:google.cloud.aiplatform.v1beta1.FindNeighborsResponse.NearestNeighbors)
    private static final com.google.cloud.aiplatform.v1beta1.FindNeighborsResponse.NearestNeighbors
        DEFAULT_INSTANCE;

    static {
      DEFAULT_INSTANCE =
          new com.google.cloud.aiplatform.v1beta1.FindNeighborsResponse.NearestNeighbors();
    }

    public static com.google.cloud.aiplatform.v1beta1.FindNeighborsResponse.NearestNeighbors
        getDefaultInstance() {
      return DEFAULT_INSTANCE;
    }

    private static final com.google.protobuf.Parser<NearestNeighbors> PARSER =
        new com.google.protobuf.AbstractParser<NearestNeighbors>() {
          @java.lang.Override
          public NearestNeighbors parsePartialFrom(
              com.google.protobuf.CodedInputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
            Builder builder = newBuilder();
            try {
              builder.mergeFrom(input, extensionRegistry);
            } catch (com.google.protobuf.InvalidProtocolBufferException e) {
              throw e.setUnfinishedMessage(builder.buildPartial());
            } catch (com.google.protobuf.UninitializedMessageException e) {
              throw e.asInvalidProtocolBufferException()
                  .setUnfinishedMessage(builder.buildPartial());
            } catch (java.io.IOException e) {
              throw new com.google.protobuf.InvalidProtocolBufferException(e)
                  .setUnfinishedMessage(builder.buildPartial());
            }
            return builder.buildPartial();
          }
        };

    public static com.google.protobuf.Parser<NearestNeighbors> parser() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.protobuf.Parser<NearestNeighbors> getParserForType() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.cloud.aiplatform.v1beta1.FindNeighborsResponse.NearestNeighbors
        getDefaultInstanceForType() {
      return DEFAULT_INSTANCE;
    }
  }

  public static final int NEAREST_NEIGHBORS_FIELD_NUMBER = 1;

  @SuppressWarnings("serial")
  private java.util.List<com.google.cloud.aiplatform.v1beta1.FindNeighborsResponse.NearestNeighbors>
      nearestNeighbors_;
  /**
   *
   *
   * <pre>
   * The nearest neighbors of the query datapoints.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.aiplatform.v1beta1.FindNeighborsResponse.NearestNeighbors nearest_neighbors = 1;
   * </code>
   */
  @java.lang.Override
  public java.util.List<com.google.cloud.aiplatform.v1beta1.FindNeighborsResponse.NearestNeighbors>
      getNearestNeighborsList() {
    return nearestNeighbors_;
  }
  /**
   *
   *
   * <pre>
   * The nearest neighbors of the query datapoints.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.aiplatform.v1beta1.FindNeighborsResponse.NearestNeighbors nearest_neighbors = 1;
   * </code>
   */
  @java.lang.Override
  public java.util.List<
          ? extends
              com.google.cloud.aiplatform.v1beta1.FindNeighborsResponse.NearestNeighborsOrBuilder>
      getNearestNeighborsOrBuilderList() {
    return nearestNeighbors_;
  }
  /**
   *
   *
   * <pre>
   * The nearest neighbors of the query datapoints.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.aiplatform.v1beta1.FindNeighborsResponse.NearestNeighbors nearest_neighbors = 1;
   * </code>
   */
  @java.lang.Override
  public int getNearestNeighborsCount() {
    return nearestNeighbors_.size();
  }
  /**
   *
   *
   * <pre>
   * The nearest neighbors of the query datapoints.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.aiplatform.v1beta1.FindNeighborsResponse.NearestNeighbors nearest_neighbors = 1;
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.aiplatform.v1beta1.FindNeighborsResponse.NearestNeighbors
      getNearestNeighbors(int index) {
    return nearestNeighbors_.get(index);
  }
  /**
   *
   *
   * <pre>
   * The nearest neighbors of the query datapoints.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.aiplatform.v1beta1.FindNeighborsResponse.NearestNeighbors nearest_neighbors = 1;
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.aiplatform.v1beta1.FindNeighborsResponse.NearestNeighborsOrBuilder
      getNearestNeighborsOrBuilder(int index) {
    return nearestNeighbors_.get(index);
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    for (int i = 0; i < nearestNeighbors_.size(); i++) {
      output.writeMessage(1, nearestNeighbors_.get(i));
    }
    getUnknownFields().writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    for (int i = 0; i < nearestNeighbors_.size(); i++) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(1, nearestNeighbors_.get(i));
    }
    size += getUnknownFields().getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.cloud.aiplatform.v1beta1.FindNeighborsResponse)) {
      return super.equals(obj);
    }
    com.google.cloud.aiplatform.v1beta1.FindNeighborsResponse other =
        (com.google.cloud.aiplatform.v1beta1.FindNeighborsResponse) obj;

    if (!getNearestNeighborsList().equals(other.getNearestNeighborsList())) return false;
    if (!getUnknownFields().equals(other.getUnknownFields())) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    if (getNearestNeighborsCount() > 0) {
      hash = (37 * hash) + NEAREST_NEIGHBORS_FIELD_NUMBER;
      hash = (53 * hash) + getNearestNeighborsList().hashCode();
    }
    hash = (29 * hash) + getUnknownFields().hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.cloud.aiplatform.v1beta1.FindNeighborsResponse parseFrom(
      java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.aiplatform.v1beta1.FindNeighborsResponse parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.aiplatform.v1beta1.FindNeighborsResponse parseFrom(
      com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.aiplatform.v1beta1.FindNeighborsResponse parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.aiplatform.v1beta1.FindNeighborsResponse parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.aiplatform.v1beta1.FindNeighborsResponse parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.aiplatform.v1beta1.FindNeighborsResponse parseFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.aiplatform.v1beta1.FindNeighborsResponse parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.aiplatform.v1beta1.FindNeighborsResponse parseDelimitedFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.cloud.aiplatform.v1beta1.FindNeighborsResponse parseDelimitedFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.aiplatform.v1beta1.FindNeighborsResponse parseFrom(
      com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.aiplatform.v1beta1.FindNeighborsResponse parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(
      com.google.cloud.aiplatform.v1beta1.FindNeighborsResponse prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }
  /**
   *
   *
   * <pre>
   * The response message for
   * [MatchService.FindNeighbors][google.cloud.aiplatform.v1beta1.MatchService.FindNeighbors].
   * </pre>
   *
   * Protobuf type {@code google.cloud.aiplatform.v1beta1.FindNeighborsResponse}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.cloud.aiplatform.v1beta1.FindNeighborsResponse)
      com.google.cloud.aiplatform.v1beta1.FindNeighborsResponseOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.aiplatform.v1beta1.MatchServiceProto
          .internal_static_google_cloud_aiplatform_v1beta1_FindNeighborsResponse_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.aiplatform.v1beta1.MatchServiceProto
          .internal_static_google_cloud_aiplatform_v1beta1_FindNeighborsResponse_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.aiplatform.v1beta1.FindNeighborsResponse.class,
              com.google.cloud.aiplatform.v1beta1.FindNeighborsResponse.Builder.class);
    }

    // Construct using com.google.cloud.aiplatform.v1beta1.FindNeighborsResponse.newBuilder()
    private Builder() {}

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      bitField0_ = 0;
      if (nearestNeighborsBuilder_ == null) {
        nearestNeighbors_ = java.util.Collections.emptyList();
      } else {
        nearestNeighbors_ = null;
        nearestNeighborsBuilder_.clear();
      }
      bitField0_ = (bitField0_ & ~0x00000001);
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.cloud.aiplatform.v1beta1.MatchServiceProto
          .internal_static_google_cloud_aiplatform_v1beta1_FindNeighborsResponse_descriptor;
    }

    @java.lang.Override
    public com.google.cloud.aiplatform.v1beta1.FindNeighborsResponse getDefaultInstanceForType() {
      return com.google.cloud.aiplatform.v1beta1.FindNeighborsResponse.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.cloud.aiplatform.v1beta1.FindNeighborsResponse build() {
      com.google.cloud.aiplatform.v1beta1.FindNeighborsResponse result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.cloud.aiplatform.v1beta1.FindNeighborsResponse buildPartial() {
      com.google.cloud.aiplatform.v1beta1.FindNeighborsResponse result =
          new com.google.cloud.aiplatform.v1beta1.FindNeighborsResponse(this);
      buildPartialRepeatedFields(result);
      if (bitField0_ != 0) {
        buildPartial0(result);
      }
      onBuilt();
      return result;
    }

    private void buildPartialRepeatedFields(
        com.google.cloud.aiplatform.v1beta1.FindNeighborsResponse result) {
      if (nearestNeighborsBuilder_ == null) {
        if (((bitField0_ & 0x00000001) != 0)) {
          nearestNeighbors_ = java.util.Collections.unmodifiableList(nearestNeighbors_);
          bitField0_ = (bitField0_ & ~0x00000001);
        }
        result.nearestNeighbors_ = nearestNeighbors_;
      } else {
        result.nearestNeighbors_ = nearestNeighborsBuilder_.build();
      }
    }

    private void buildPartial0(com.google.cloud.aiplatform.v1beta1.FindNeighborsResponse result) {
      int from_bitField0_ = bitField0_;
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.cloud.aiplatform.v1beta1.FindNeighborsResponse) {
        return mergeFrom((com.google.cloud.aiplatform.v1beta1.FindNeighborsResponse) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(com.google.cloud.aiplatform.v1beta1.FindNeighborsResponse other) {
      if (other == com.google.cloud.aiplatform.v1beta1.FindNeighborsResponse.getDefaultInstance())
        return this;
      if (nearestNeighborsBuilder_ == null) {
        if (!other.nearestNeighbors_.isEmpty()) {
          if (nearestNeighbors_.isEmpty()) {
            nearestNeighbors_ = other.nearestNeighbors_;
            bitField0_ = (bitField0_ & ~0x00000001);
          } else {
            ensureNearestNeighborsIsMutable();
            nearestNeighbors_.addAll(other.nearestNeighbors_);
          }
          onChanged();
        }
      } else {
        if (!other.nearestNeighbors_.isEmpty()) {
          if (nearestNeighborsBuilder_.isEmpty()) {
            nearestNeighborsBuilder_.dispose();
            nearestNeighborsBuilder_ = null;
            nearestNeighbors_ = other.nearestNeighbors_;
            bitField0_ = (bitField0_ & ~0x00000001);
            nearestNeighborsBuilder_ =
                com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders
                    ? getNearestNeighborsFieldBuilder()
                    : null;
          } else {
            nearestNeighborsBuilder_.addAllMessages(other.nearestNeighbors_);
          }
        }
      }
      this.mergeUnknownFields(other.getUnknownFields());
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 10:
              {
                com.google.cloud.aiplatform.v1beta1.FindNeighborsResponse.NearestNeighbors m =
                    input.readMessage(
                        com.google.cloud.aiplatform.v1beta1.FindNeighborsResponse.NearestNeighbors
                            .parser(),
                        extensionRegistry);
                if (nearestNeighborsBuilder_ == null) {
                  ensureNearestNeighborsIsMutable();
                  nearestNeighbors_.add(m);
                } else {
                  nearestNeighborsBuilder_.addMessage(m);
                }
                break;
              } // case 10
            default:
              {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
          } // switch (tag)
        } // while (!done)
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.unwrapIOException();
      } finally {
        onChanged();
      } // finally
      return this;
    }

    private int bitField0_;

    private java.util.List<
            com.google.cloud.aiplatform.v1beta1.FindNeighborsResponse.NearestNeighbors>
        nearestNeighbors_ = java.util.Collections.emptyList();

    private void ensureNearestNeighborsIsMutable() {
      if (!((bitField0_ & 0x00000001) != 0)) {
        nearestNeighbors_ =
            new java.util.ArrayList<
                com.google.cloud.aiplatform.v1beta1.FindNeighborsResponse.NearestNeighbors>(
                nearestNeighbors_);
        bitField0_ |= 0x00000001;
      }
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.cloud.aiplatform.v1beta1.FindNeighborsResponse.NearestNeighbors,
            com.google.cloud.aiplatform.v1beta1.FindNeighborsResponse.NearestNeighbors.Builder,
            com.google.cloud.aiplatform.v1beta1.FindNeighborsResponse.NearestNeighborsOrBuilder>
        nearestNeighborsBuilder_;

    /**
     *
     *
     * <pre>
     * The nearest neighbors of the query datapoints.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.aiplatform.v1beta1.FindNeighborsResponse.NearestNeighbors nearest_neighbors = 1;
     * </code>
     */
    public java.util.List<
            com.google.cloud.aiplatform.v1beta1.FindNeighborsResponse.NearestNeighbors>
        getNearestNeighborsList() {
      if (nearestNeighborsBuilder_ == null) {
        return java.util.Collections.unmodifiableList(nearestNeighbors_);
      } else {
        return nearestNeighborsBuilder_.getMessageList();
      }
    }
    /**
     *
     *
     * <pre>
     * The nearest neighbors of the query datapoints.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.aiplatform.v1beta1.FindNeighborsResponse.NearestNeighbors nearest_neighbors = 1;
     * </code>
     */
    public int getNearestNeighborsCount() {
      if (nearestNeighborsBuilder_ == null) {
        return nearestNeighbors_.size();
      } else {
        return nearestNeighborsBuilder_.getCount();
      }
    }
    /**
     *
     *
     * <pre>
     * The nearest neighbors of the query datapoints.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.aiplatform.v1beta1.FindNeighborsResponse.NearestNeighbors nearest_neighbors = 1;
     * </code>
     */
    public com.google.cloud.aiplatform.v1beta1.FindNeighborsResponse.NearestNeighbors
        getNearestNeighbors(int index) {
      if (nearestNeighborsBuilder_ == null) {
        return nearestNeighbors_.get(index);
      } else {
        return nearestNeighborsBuilder_.getMessage(index);
      }
    }
    /**
     *
     *
     * <pre>
     * The nearest neighbors of the query datapoints.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.aiplatform.v1beta1.FindNeighborsResponse.NearestNeighbors nearest_neighbors = 1;
     * </code>
     */
    public Builder setNearestNeighbors(
        int index,
        com.google.cloud.aiplatform.v1beta1.FindNeighborsResponse.NearestNeighbors value) {
      if (nearestNeighborsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureNearestNeighborsIsMutable();
        nearestNeighbors_.set(index, value);
        onChanged();
      } else {
        nearestNeighborsBuilder_.setMessage(index, value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * The nearest neighbors of the query datapoints.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.aiplatform.v1beta1.FindNeighborsResponse.NearestNeighbors nearest_neighbors = 1;
     * </code>
     */
    public Builder setNearestNeighbors(
        int index,
        com.google.cloud.aiplatform.v1beta1.FindNeighborsResponse.NearestNeighbors.Builder
            builderForValue) {
      if (nearestNeighborsBuilder_ == null) {
        ensureNearestNeighborsIsMutable();
        nearestNeighbors_.set(index, builderForValue.build());
        onChanged();
      } else {
        nearestNeighborsBuilder_.setMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * The nearest neighbors of the query datapoints.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.aiplatform.v1beta1.FindNeighborsResponse.NearestNeighbors nearest_neighbors = 1;
     * </code>
     */
    public Builder addNearestNeighbors(
        com.google.cloud.aiplatform.v1beta1.FindNeighborsResponse.NearestNeighbors value) {
      if (nearestNeighborsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureNearestNeighborsIsMutable();
        nearestNeighbors_.add(value);
        onChanged();
      } else {
        nearestNeighborsBuilder_.addMessage(value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * The nearest neighbors of the query datapoints.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.aiplatform.v1beta1.FindNeighborsResponse.NearestNeighbors nearest_neighbors = 1;
     * </code>
     */
    public Builder addNearestNeighbors(
        int index,
        com.google.cloud.aiplatform.v1beta1.FindNeighborsResponse.NearestNeighbors value) {
      if (nearestNeighborsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureNearestNeighborsIsMutable();
        nearestNeighbors_.add(index, value);
        onChanged();
      } else {
        nearestNeighborsBuilder_.addMessage(index, value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * The nearest neighbors of the query datapoints.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.aiplatform.v1beta1.FindNeighborsResponse.NearestNeighbors nearest_neighbors = 1;
     * </code>
     */
    public Builder addNearestNeighbors(
        com.google.cloud.aiplatform.v1beta1.FindNeighborsResponse.NearestNeighbors.Builder
            builderForValue) {
      if (nearestNeighborsBuilder_ == null) {
        ensureNearestNeighborsIsMutable();
        nearestNeighbors_.add(builderForValue.build());
        onChanged();
      } else {
        nearestNeighborsBuilder_.addMessage(builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * The nearest neighbors of the query datapoints.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.aiplatform.v1beta1.FindNeighborsResponse.NearestNeighbors nearest_neighbors = 1;
     * </code>
     */
    public Builder addNearestNeighbors(
        int index,
        com.google.cloud.aiplatform.v1beta1.FindNeighborsResponse.NearestNeighbors.Builder
            builderForValue) {
      if (nearestNeighborsBuilder_ == null) {
        ensureNearestNeighborsIsMutable();
        nearestNeighbors_.add(index, builderForValue.build());
        onChanged();
      } else {
        nearestNeighborsBuilder_.addMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * The nearest neighbors of the query datapoints.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.aiplatform.v1beta1.FindNeighborsResponse.NearestNeighbors nearest_neighbors = 1;
     * </code>
     */
    public Builder addAllNearestNeighbors(
        java.lang.Iterable<
                ? extends
                    com.google.cloud.aiplatform.v1beta1.FindNeighborsResponse.NearestNeighbors>
            values) {
      if (nearestNeighborsBuilder_ == null) {
        ensureNearestNeighborsIsMutable();
        com.google.protobuf.AbstractMessageLite.Builder.addAll(values, nearestNeighbors_);
        onChanged();
      } else {
        nearestNeighborsBuilder_.addAllMessages(values);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * The nearest neighbors of the query datapoints.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.aiplatform.v1beta1.FindNeighborsResponse.NearestNeighbors nearest_neighbors = 1;
     * </code>
     */
    public Builder clearNearestNeighbors() {
      if (nearestNeighborsBuilder_ == null) {
        nearestNeighbors_ = java.util.Collections.emptyList();
        bitField0_ = (bitField0_ & ~0x00000001);
        onChanged();
      } else {
        nearestNeighborsBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * The nearest neighbors of the query datapoints.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.aiplatform.v1beta1.FindNeighborsResponse.NearestNeighbors nearest_neighbors = 1;
     * </code>
     */
    public Builder removeNearestNeighbors(int index) {
      if (nearestNeighborsBuilder_ == null) {
        ensureNearestNeighborsIsMutable();
        nearestNeighbors_.remove(index);
        onChanged();
      } else {
        nearestNeighborsBuilder_.remove(index);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * The nearest neighbors of the query datapoints.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.aiplatform.v1beta1.FindNeighborsResponse.NearestNeighbors nearest_neighbors = 1;
     * </code>
     */
    public com.google.cloud.aiplatform.v1beta1.FindNeighborsResponse.NearestNeighbors.Builder
        getNearestNeighborsBuilder(int index) {
      return getNearestNeighborsFieldBuilder().getBuilder(index);
    }
    /**
     *
     *
     * <pre>
     * The nearest neighbors of the query datapoints.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.aiplatform.v1beta1.FindNeighborsResponse.NearestNeighbors nearest_neighbors = 1;
     * </code>
     */
    public com.google.cloud.aiplatform.v1beta1.FindNeighborsResponse.NearestNeighborsOrBuilder
        getNearestNeighborsOrBuilder(int index) {
      if (nearestNeighborsBuilder_ == null) {
        return nearestNeighbors_.get(index);
      } else {
        return nearestNeighborsBuilder_.getMessageOrBuilder(index);
      }
    }
    /**
     *
     *
     * <pre>
     * The nearest neighbors of the query datapoints.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.aiplatform.v1beta1.FindNeighborsResponse.NearestNeighbors nearest_neighbors = 1;
     * </code>
     */
    public java.util.List<
            ? extends
                com.google.cloud.aiplatform.v1beta1.FindNeighborsResponse.NearestNeighborsOrBuilder>
        getNearestNeighborsOrBuilderList() {
      if (nearestNeighborsBuilder_ != null) {
        return nearestNeighborsBuilder_.getMessageOrBuilderList();
      } else {
        return java.util.Collections.unmodifiableList(nearestNeighbors_);
      }
    }
    /**
     *
     *
     * <pre>
     * The nearest neighbors of the query datapoints.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.aiplatform.v1beta1.FindNeighborsResponse.NearestNeighbors nearest_neighbors = 1;
     * </code>
     */
    public com.google.cloud.aiplatform.v1beta1.FindNeighborsResponse.NearestNeighbors.Builder
        addNearestNeighborsBuilder() {
      return getNearestNeighborsFieldBuilder()
          .addBuilder(
              com.google.cloud.aiplatform.v1beta1.FindNeighborsResponse.NearestNeighbors
                  .getDefaultInstance());
    }
    /**
     *
     *
     * <pre>
     * The nearest neighbors of the query datapoints.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.aiplatform.v1beta1.FindNeighborsResponse.NearestNeighbors nearest_neighbors = 1;
     * </code>
     */
    public com.google.cloud.aiplatform.v1beta1.FindNeighborsResponse.NearestNeighbors.Builder
        addNearestNeighborsBuilder(int index) {
      return getNearestNeighborsFieldBuilder()
          .addBuilder(
              index,
              com.google.cloud.aiplatform.v1beta1.FindNeighborsResponse.NearestNeighbors
                  .getDefaultInstance());
    }
    /**
     *
     *
     * <pre>
     * The nearest neighbors of the query datapoints.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.aiplatform.v1beta1.FindNeighborsResponse.NearestNeighbors nearest_neighbors = 1;
     * </code>
     */
    public java.util.List<
            com.google.cloud.aiplatform.v1beta1.FindNeighborsResponse.NearestNeighbors.Builder>
        getNearestNeighborsBuilderList() {
      return getNearestNeighborsFieldBuilder().getBuilderList();
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.cloud.aiplatform.v1beta1.FindNeighborsResponse.NearestNeighbors,
            com.google.cloud.aiplatform.v1beta1.FindNeighborsResponse.NearestNeighbors.Builder,
            com.google.cloud.aiplatform.v1beta1.FindNeighborsResponse.NearestNeighborsOrBuilder>
        getNearestNeighborsFieldBuilder() {
      if (nearestNeighborsBuilder_ == null) {
        nearestNeighborsBuilder_ =
            new com.google.protobuf.RepeatedFieldBuilderV3<
                com.google.cloud.aiplatform.v1beta1.FindNeighborsResponse.NearestNeighbors,
                com.google.cloud.aiplatform.v1beta1.FindNeighborsResponse.NearestNeighbors.Builder,
                com.google.cloud.aiplatform.v1beta1.FindNeighborsResponse
                    .NearestNeighborsOrBuilder>(
                nearestNeighbors_,
                ((bitField0_ & 0x00000001) != 0),
                getParentForChildren(),
                isClean());
        nearestNeighbors_ = null;
      }
      return nearestNeighborsBuilder_;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.cloud.aiplatform.v1beta1.FindNeighborsResponse)
  }

  // @@protoc_insertion_point(class_scope:google.cloud.aiplatform.v1beta1.FindNeighborsResponse)
  private static final com.google.cloud.aiplatform.v1beta1.FindNeighborsResponse DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.cloud.aiplatform.v1beta1.FindNeighborsResponse();
  }

  public static com.google.cloud.aiplatform.v1beta1.FindNeighborsResponse getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<FindNeighborsResponse> PARSER =
      new com.google.protobuf.AbstractParser<FindNeighborsResponse>() {
        @java.lang.Override
        public FindNeighborsResponse parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          Builder builder = newBuilder();
          try {
            builder.mergeFrom(input, extensionRegistry);
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.setUnfinishedMessage(builder.buildPartial());
          } catch (com.google.protobuf.UninitializedMessageException e) {
            throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
          } catch (java.io.IOException e) {
            throw new com.google.protobuf.InvalidProtocolBufferException(e)
                .setUnfinishedMessage(builder.buildPartial());
          }
          return builder.buildPartial();
        }
      };

  public static com.google.protobuf.Parser<FindNeighborsResponse> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<FindNeighborsResponse> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.cloud.aiplatform.v1beta1.FindNeighborsResponse getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
