/*
 * Copyright 2024 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/cloud/aiplatform/v1beta1/persistent_resource.proto

// Protobuf Java Version: 3.25.2
package com.google.cloud.aiplatform.v1beta1;

/**
 *
 *
 * <pre>
 * Represents the spec of a group of resources of the same type,
 * for example machine type, disk, and accelerators, in a PersistentResource.
 * </pre>
 *
 * Protobuf type {@code google.cloud.aiplatform.v1beta1.ResourcePool}
 */
public final class ResourcePool extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.cloud.aiplatform.v1beta1.ResourcePool)
    ResourcePoolOrBuilder {
  private static final long serialVersionUID = 0L;
  // Use ResourcePool.newBuilder() to construct.
  private ResourcePool(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private ResourcePool() {
    id_ = "";
  }

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new ResourcePool();
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.cloud.aiplatform.v1beta1.PersistentResourceProto
        .internal_static_google_cloud_aiplatform_v1beta1_ResourcePool_descriptor;
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.cloud.aiplatform.v1beta1.PersistentResourceProto
        .internal_static_google_cloud_aiplatform_v1beta1_ResourcePool_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.cloud.aiplatform.v1beta1.ResourcePool.class,
            com.google.cloud.aiplatform.v1beta1.ResourcePool.Builder.class);
  }

  public interface AutoscalingSpecOrBuilder
      extends
      // @@protoc_insertion_point(interface_extends:google.cloud.aiplatform.v1beta1.ResourcePool.AutoscalingSpec)
      com.google.protobuf.MessageOrBuilder {

    /**
     *
     *
     * <pre>
     * Optional. min replicas in the node pool,
     * must be ≤ replica_count and &lt; max_replica_count or will throw error
     * </pre>
     *
     * <code>optional int64 min_replica_count = 1 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return Whether the minReplicaCount field is set.
     */
    boolean hasMinReplicaCount();
    /**
     *
     *
     * <pre>
     * Optional. min replicas in the node pool,
     * must be ≤ replica_count and &lt; max_replica_count or will throw error
     * </pre>
     *
     * <code>optional int64 min_replica_count = 1 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return The minReplicaCount.
     */
    long getMinReplicaCount();

    /**
     *
     *
     * <pre>
     * Optional. max replicas in the node pool,
     * must be ≥ replica_count and &gt; min_replica_count or will throw error
     * </pre>
     *
     * <code>optional int64 max_replica_count = 2 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return Whether the maxReplicaCount field is set.
     */
    boolean hasMaxReplicaCount();
    /**
     *
     *
     * <pre>
     * Optional. max replicas in the node pool,
     * must be ≥ replica_count and &gt; min_replica_count or will throw error
     * </pre>
     *
     * <code>optional int64 max_replica_count = 2 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return The maxReplicaCount.
     */
    long getMaxReplicaCount();
  }
  /**
   *
   *
   * <pre>
   * The min/max number of replicas allowed if enabling autoscaling
   * </pre>
   *
   * Protobuf type {@code google.cloud.aiplatform.v1beta1.ResourcePool.AutoscalingSpec}
   */
  public static final class AutoscalingSpec extends com.google.protobuf.GeneratedMessageV3
      implements
      // @@protoc_insertion_point(message_implements:google.cloud.aiplatform.v1beta1.ResourcePool.AutoscalingSpec)
      AutoscalingSpecOrBuilder {
    private static final long serialVersionUID = 0L;
    // Use AutoscalingSpec.newBuilder() to construct.
    private AutoscalingSpec(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
      super(builder);
    }

    private AutoscalingSpec() {}

    @java.lang.Override
    @SuppressWarnings({"unused"})
    protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
      return new AutoscalingSpec();
    }

    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.aiplatform.v1beta1.PersistentResourceProto
          .internal_static_google_cloud_aiplatform_v1beta1_ResourcePool_AutoscalingSpec_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.aiplatform.v1beta1.PersistentResourceProto
          .internal_static_google_cloud_aiplatform_v1beta1_ResourcePool_AutoscalingSpec_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.aiplatform.v1beta1.ResourcePool.AutoscalingSpec.class,
              com.google.cloud.aiplatform.v1beta1.ResourcePool.AutoscalingSpec.Builder.class);
    }

    private int bitField0_;
    public static final int MIN_REPLICA_COUNT_FIELD_NUMBER = 1;
    private long minReplicaCount_ = 0L;
    /**
     *
     *
     * <pre>
     * Optional. min replicas in the node pool,
     * must be ≤ replica_count and &lt; max_replica_count or will throw error
     * </pre>
     *
     * <code>optional int64 min_replica_count = 1 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return Whether the minReplicaCount field is set.
     */
    @java.lang.Override
    public boolean hasMinReplicaCount() {
      return ((bitField0_ & 0x00000001) != 0);
    }
    /**
     *
     *
     * <pre>
     * Optional. min replicas in the node pool,
     * must be ≤ replica_count and &lt; max_replica_count or will throw error
     * </pre>
     *
     * <code>optional int64 min_replica_count = 1 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return The minReplicaCount.
     */
    @java.lang.Override
    public long getMinReplicaCount() {
      return minReplicaCount_;
    }

    public static final int MAX_REPLICA_COUNT_FIELD_NUMBER = 2;
    private long maxReplicaCount_ = 0L;
    /**
     *
     *
     * <pre>
     * Optional. max replicas in the node pool,
     * must be ≥ replica_count and &gt; min_replica_count or will throw error
     * </pre>
     *
     * <code>optional int64 max_replica_count = 2 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return Whether the maxReplicaCount field is set.
     */
    @java.lang.Override
    public boolean hasMaxReplicaCount() {
      return ((bitField0_ & 0x00000002) != 0);
    }
    /**
     *
     *
     * <pre>
     * Optional. max replicas in the node pool,
     * must be ≥ replica_count and &gt; min_replica_count or will throw error
     * </pre>
     *
     * <code>optional int64 max_replica_count = 2 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return The maxReplicaCount.
     */
    @java.lang.Override
    public long getMaxReplicaCount() {
      return maxReplicaCount_;
    }

    private byte memoizedIsInitialized = -1;

    @java.lang.Override
    public final boolean isInitialized() {
      byte isInitialized = memoizedIsInitialized;
      if (isInitialized == 1) return true;
      if (isInitialized == 0) return false;

      memoizedIsInitialized = 1;
      return true;
    }

    @java.lang.Override
    public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
      if (((bitField0_ & 0x00000001) != 0)) {
        output.writeInt64(1, minReplicaCount_);
      }
      if (((bitField0_ & 0x00000002) != 0)) {
        output.writeInt64(2, maxReplicaCount_);
      }
      getUnknownFields().writeTo(output);
    }

    @java.lang.Override
    public int getSerializedSize() {
      int size = memoizedSize;
      if (size != -1) return size;

      size = 0;
      if (((bitField0_ & 0x00000001) != 0)) {
        size += com.google.protobuf.CodedOutputStream.computeInt64Size(1, minReplicaCount_);
      }
      if (((bitField0_ & 0x00000002) != 0)) {
        size += com.google.protobuf.CodedOutputStream.computeInt64Size(2, maxReplicaCount_);
      }
      size += getUnknownFields().getSerializedSize();
      memoizedSize = size;
      return size;
    }

    @java.lang.Override
    public boolean equals(final java.lang.Object obj) {
      if (obj == this) {
        return true;
      }
      if (!(obj instanceof com.google.cloud.aiplatform.v1beta1.ResourcePool.AutoscalingSpec)) {
        return super.equals(obj);
      }
      com.google.cloud.aiplatform.v1beta1.ResourcePool.AutoscalingSpec other =
          (com.google.cloud.aiplatform.v1beta1.ResourcePool.AutoscalingSpec) obj;

      if (hasMinReplicaCount() != other.hasMinReplicaCount()) return false;
      if (hasMinReplicaCount()) {
        if (getMinReplicaCount() != other.getMinReplicaCount()) return false;
      }
      if (hasMaxReplicaCount() != other.hasMaxReplicaCount()) return false;
      if (hasMaxReplicaCount()) {
        if (getMaxReplicaCount() != other.getMaxReplicaCount()) return false;
      }
      if (!getUnknownFields().equals(other.getUnknownFields())) return false;
      return true;
    }

    @java.lang.Override
    public int hashCode() {
      if (memoizedHashCode != 0) {
        return memoizedHashCode;
      }
      int hash = 41;
      hash = (19 * hash) + getDescriptor().hashCode();
      if (hasMinReplicaCount()) {
        hash = (37 * hash) + MIN_REPLICA_COUNT_FIELD_NUMBER;
        hash = (53 * hash) + com.google.protobuf.Internal.hashLong(getMinReplicaCount());
      }
      if (hasMaxReplicaCount()) {
        hash = (37 * hash) + MAX_REPLICA_COUNT_FIELD_NUMBER;
        hash = (53 * hash) + com.google.protobuf.Internal.hashLong(getMaxReplicaCount());
      }
      hash = (29 * hash) + getUnknownFields().hashCode();
      memoizedHashCode = hash;
      return hash;
    }

    public static com.google.cloud.aiplatform.v1beta1.ResourcePool.AutoscalingSpec parseFrom(
        java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.aiplatform.v1beta1.ResourcePool.AutoscalingSpec parseFrom(
        java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.aiplatform.v1beta1.ResourcePool.AutoscalingSpec parseFrom(
        com.google.protobuf.ByteString data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.aiplatform.v1beta1.ResourcePool.AutoscalingSpec parseFrom(
        com.google.protobuf.ByteString data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.aiplatform.v1beta1.ResourcePool.AutoscalingSpec parseFrom(
        byte[] data) throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.aiplatform.v1beta1.ResourcePool.AutoscalingSpec parseFrom(
        byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.aiplatform.v1beta1.ResourcePool.AutoscalingSpec parseFrom(
        java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.cloud.aiplatform.v1beta1.ResourcePool.AutoscalingSpec parseFrom(
        java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.cloud.aiplatform.v1beta1.ResourcePool.AutoscalingSpec
        parseDelimitedFrom(java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
    }

    public static com.google.cloud.aiplatform.v1beta1.ResourcePool.AutoscalingSpec
        parseDelimitedFrom(
            java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.cloud.aiplatform.v1beta1.ResourcePool.AutoscalingSpec parseFrom(
        com.google.protobuf.CodedInputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.cloud.aiplatform.v1beta1.ResourcePool.AutoscalingSpec parseFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    @java.lang.Override
    public Builder newBuilderForType() {
      return newBuilder();
    }

    public static Builder newBuilder() {
      return DEFAULT_INSTANCE.toBuilder();
    }

    public static Builder newBuilder(
        com.google.cloud.aiplatform.v1beta1.ResourcePool.AutoscalingSpec prototype) {
      return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }

    @java.lang.Override
    public Builder toBuilder() {
      return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
    }

    @java.lang.Override
    protected Builder newBuilderForType(
        com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      Builder builder = new Builder(parent);
      return builder;
    }
    /**
     *
     *
     * <pre>
     * The min/max number of replicas allowed if enabling autoscaling
     * </pre>
     *
     * Protobuf type {@code google.cloud.aiplatform.v1beta1.ResourcePool.AutoscalingSpec}
     */
    public static final class Builder
        extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
        implements
        // @@protoc_insertion_point(builder_implements:google.cloud.aiplatform.v1beta1.ResourcePool.AutoscalingSpec)
        com.google.cloud.aiplatform.v1beta1.ResourcePool.AutoscalingSpecOrBuilder {
      public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
        return com.google.cloud.aiplatform.v1beta1.PersistentResourceProto
            .internal_static_google_cloud_aiplatform_v1beta1_ResourcePool_AutoscalingSpec_descriptor;
      }

      @java.lang.Override
      protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return com.google.cloud.aiplatform.v1beta1.PersistentResourceProto
            .internal_static_google_cloud_aiplatform_v1beta1_ResourcePool_AutoscalingSpec_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                com.google.cloud.aiplatform.v1beta1.ResourcePool.AutoscalingSpec.class,
                com.google.cloud.aiplatform.v1beta1.ResourcePool.AutoscalingSpec.Builder.class);
      }

      // Construct using
      // com.google.cloud.aiplatform.v1beta1.ResourcePool.AutoscalingSpec.newBuilder()
      private Builder() {}

      private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
        super(parent);
      }

      @java.lang.Override
      public Builder clear() {
        super.clear();
        bitField0_ = 0;
        minReplicaCount_ = 0L;
        maxReplicaCount_ = 0L;
        return this;
      }

      @java.lang.Override
      public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
        return com.google.cloud.aiplatform.v1beta1.PersistentResourceProto
            .internal_static_google_cloud_aiplatform_v1beta1_ResourcePool_AutoscalingSpec_descriptor;
      }

      @java.lang.Override
      public com.google.cloud.aiplatform.v1beta1.ResourcePool.AutoscalingSpec
          getDefaultInstanceForType() {
        return com.google.cloud.aiplatform.v1beta1.ResourcePool.AutoscalingSpec
            .getDefaultInstance();
      }

      @java.lang.Override
      public com.google.cloud.aiplatform.v1beta1.ResourcePool.AutoscalingSpec build() {
        com.google.cloud.aiplatform.v1beta1.ResourcePool.AutoscalingSpec result = buildPartial();
        if (!result.isInitialized()) {
          throw newUninitializedMessageException(result);
        }
        return result;
      }

      @java.lang.Override
      public com.google.cloud.aiplatform.v1beta1.ResourcePool.AutoscalingSpec buildPartial() {
        com.google.cloud.aiplatform.v1beta1.ResourcePool.AutoscalingSpec result =
            new com.google.cloud.aiplatform.v1beta1.ResourcePool.AutoscalingSpec(this);
        if (bitField0_ != 0) {
          buildPartial0(result);
        }
        onBuilt();
        return result;
      }

      private void buildPartial0(
          com.google.cloud.aiplatform.v1beta1.ResourcePool.AutoscalingSpec result) {
        int from_bitField0_ = bitField0_;
        int to_bitField0_ = 0;
        if (((from_bitField0_ & 0x00000001) != 0)) {
          result.minReplicaCount_ = minReplicaCount_;
          to_bitField0_ |= 0x00000001;
        }
        if (((from_bitField0_ & 0x00000002) != 0)) {
          result.maxReplicaCount_ = maxReplicaCount_;
          to_bitField0_ |= 0x00000002;
        }
        result.bitField0_ |= to_bitField0_;
      }

      @java.lang.Override
      public Builder clone() {
        return super.clone();
      }

      @java.lang.Override
      public Builder setField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.setField(field, value);
      }

      @java.lang.Override
      public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
        return super.clearField(field);
      }

      @java.lang.Override
      public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
        return super.clearOneof(oneof);
      }

      @java.lang.Override
      public Builder setRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          int index,
          java.lang.Object value) {
        return super.setRepeatedField(field, index, value);
      }

      @java.lang.Override
      public Builder addRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.addRepeatedField(field, value);
      }

      @java.lang.Override
      public Builder mergeFrom(com.google.protobuf.Message other) {
        if (other instanceof com.google.cloud.aiplatform.v1beta1.ResourcePool.AutoscalingSpec) {
          return mergeFrom(
              (com.google.cloud.aiplatform.v1beta1.ResourcePool.AutoscalingSpec) other);
        } else {
          super.mergeFrom(other);
          return this;
        }
      }

      public Builder mergeFrom(
          com.google.cloud.aiplatform.v1beta1.ResourcePool.AutoscalingSpec other) {
        if (other
            == com.google.cloud.aiplatform.v1beta1.ResourcePool.AutoscalingSpec
                .getDefaultInstance()) return this;
        if (other.hasMinReplicaCount()) {
          setMinReplicaCount(other.getMinReplicaCount());
        }
        if (other.hasMaxReplicaCount()) {
          setMaxReplicaCount(other.getMaxReplicaCount());
        }
        this.mergeUnknownFields(other.getUnknownFields());
        onChanged();
        return this;
      }

      @java.lang.Override
      public final boolean isInitialized() {
        return true;
      }

      @java.lang.Override
      public Builder mergeFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        if (extensionRegistry == null) {
          throw new java.lang.NullPointerException();
        }
        try {
          boolean done = false;
          while (!done) {
            int tag = input.readTag();
            switch (tag) {
              case 0:
                done = true;
                break;
              case 8:
                {
                  minReplicaCount_ = input.readInt64();
                  bitField0_ |= 0x00000001;
                  break;
                } // case 8
              case 16:
                {
                  maxReplicaCount_ = input.readInt64();
                  bitField0_ |= 0x00000002;
                  break;
                } // case 16
              default:
                {
                  if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                    done = true; // was an endgroup tag
                  }
                  break;
                } // default:
            } // switch (tag)
          } // while (!done)
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          throw e.unwrapIOException();
        } finally {
          onChanged();
        } // finally
        return this;
      }

      private int bitField0_;

      private long minReplicaCount_;
      /**
       *
       *
       * <pre>
       * Optional. min replicas in the node pool,
       * must be ≤ replica_count and &lt; max_replica_count or will throw error
       * </pre>
       *
       * <code>optional int64 min_replica_count = 1 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       *
       * @return Whether the minReplicaCount field is set.
       */
      @java.lang.Override
      public boolean hasMinReplicaCount() {
        return ((bitField0_ & 0x00000001) != 0);
      }
      /**
       *
       *
       * <pre>
       * Optional. min replicas in the node pool,
       * must be ≤ replica_count and &lt; max_replica_count or will throw error
       * </pre>
       *
       * <code>optional int64 min_replica_count = 1 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       *
       * @return The minReplicaCount.
       */
      @java.lang.Override
      public long getMinReplicaCount() {
        return minReplicaCount_;
      }
      /**
       *
       *
       * <pre>
       * Optional. min replicas in the node pool,
       * must be ≤ replica_count and &lt; max_replica_count or will throw error
       * </pre>
       *
       * <code>optional int64 min_replica_count = 1 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       *
       * @param value The minReplicaCount to set.
       * @return This builder for chaining.
       */
      public Builder setMinReplicaCount(long value) {

        minReplicaCount_ = value;
        bitField0_ |= 0x00000001;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Optional. min replicas in the node pool,
       * must be ≤ replica_count and &lt; max_replica_count or will throw error
       * </pre>
       *
       * <code>optional int64 min_replica_count = 1 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       *
       * @return This builder for chaining.
       */
      public Builder clearMinReplicaCount() {
        bitField0_ = (bitField0_ & ~0x00000001);
        minReplicaCount_ = 0L;
        onChanged();
        return this;
      }

      private long maxReplicaCount_;
      /**
       *
       *
       * <pre>
       * Optional. max replicas in the node pool,
       * must be ≥ replica_count and &gt; min_replica_count or will throw error
       * </pre>
       *
       * <code>optional int64 max_replica_count = 2 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       *
       * @return Whether the maxReplicaCount field is set.
       */
      @java.lang.Override
      public boolean hasMaxReplicaCount() {
        return ((bitField0_ & 0x00000002) != 0);
      }
      /**
       *
       *
       * <pre>
       * Optional. max replicas in the node pool,
       * must be ≥ replica_count and &gt; min_replica_count or will throw error
       * </pre>
       *
       * <code>optional int64 max_replica_count = 2 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       *
       * @return The maxReplicaCount.
       */
      @java.lang.Override
      public long getMaxReplicaCount() {
        return maxReplicaCount_;
      }
      /**
       *
       *
       * <pre>
       * Optional. max replicas in the node pool,
       * must be ≥ replica_count and &gt; min_replica_count or will throw error
       * </pre>
       *
       * <code>optional int64 max_replica_count = 2 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       *
       * @param value The maxReplicaCount to set.
       * @return This builder for chaining.
       */
      public Builder setMaxReplicaCount(long value) {

        maxReplicaCount_ = value;
        bitField0_ |= 0x00000002;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Optional. max replicas in the node pool,
       * must be ≥ replica_count and &gt; min_replica_count or will throw error
       * </pre>
       *
       * <code>optional int64 max_replica_count = 2 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       *
       * @return This builder for chaining.
       */
      public Builder clearMaxReplicaCount() {
        bitField0_ = (bitField0_ & ~0x00000002);
        maxReplicaCount_ = 0L;
        onChanged();
        return this;
      }

      @java.lang.Override
      public final Builder setUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.setUnknownFields(unknownFields);
      }

      @java.lang.Override
      public final Builder mergeUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.mergeUnknownFields(unknownFields);
      }

      // @@protoc_insertion_point(builder_scope:google.cloud.aiplatform.v1beta1.ResourcePool.AutoscalingSpec)
    }

    // @@protoc_insertion_point(class_scope:google.cloud.aiplatform.v1beta1.ResourcePool.AutoscalingSpec)
    private static final com.google.cloud.aiplatform.v1beta1.ResourcePool.AutoscalingSpec
        DEFAULT_INSTANCE;

    static {
      DEFAULT_INSTANCE = new com.google.cloud.aiplatform.v1beta1.ResourcePool.AutoscalingSpec();
    }

    public static com.google.cloud.aiplatform.v1beta1.ResourcePool.AutoscalingSpec
        getDefaultInstance() {
      return DEFAULT_INSTANCE;
    }

    private static final com.google.protobuf.Parser<AutoscalingSpec> PARSER =
        new com.google.protobuf.AbstractParser<AutoscalingSpec>() {
          @java.lang.Override
          public AutoscalingSpec parsePartialFrom(
              com.google.protobuf.CodedInputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
            Builder builder = newBuilder();
            try {
              builder.mergeFrom(input, extensionRegistry);
            } catch (com.google.protobuf.InvalidProtocolBufferException e) {
              throw e.setUnfinishedMessage(builder.buildPartial());
            } catch (com.google.protobuf.UninitializedMessageException e) {
              throw e.asInvalidProtocolBufferException()
                  .setUnfinishedMessage(builder.buildPartial());
            } catch (java.io.IOException e) {
              throw new com.google.protobuf.InvalidProtocolBufferException(e)
                  .setUnfinishedMessage(builder.buildPartial());
            }
            return builder.buildPartial();
          }
        };

    public static com.google.protobuf.Parser<AutoscalingSpec> parser() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.protobuf.Parser<AutoscalingSpec> getParserForType() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.cloud.aiplatform.v1beta1.ResourcePool.AutoscalingSpec
        getDefaultInstanceForType() {
      return DEFAULT_INSTANCE;
    }
  }

  private int bitField0_;
  public static final int ID_FIELD_NUMBER = 1;

  @SuppressWarnings("serial")
  private volatile java.lang.Object id_ = "";
  /**
   *
   *
   * <pre>
   * Immutable. The unique ID in a PersistentResource for referring to this
   * resource pool. User can specify it if necessary. Otherwise, it's generated
   * automatically.
   * </pre>
   *
   * <code>string id = 1 [(.google.api.field_behavior) = IMMUTABLE];</code>
   *
   * @return The id.
   */
  @java.lang.Override
  public java.lang.String getId() {
    java.lang.Object ref = id_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      id_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Immutable. The unique ID in a PersistentResource for referring to this
   * resource pool. User can specify it if necessary. Otherwise, it's generated
   * automatically.
   * </pre>
   *
   * <code>string id = 1 [(.google.api.field_behavior) = IMMUTABLE];</code>
   *
   * @return The bytes for id.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getIdBytes() {
    java.lang.Object ref = id_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      id_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int MACHINE_SPEC_FIELD_NUMBER = 2;
  private com.google.cloud.aiplatform.v1beta1.MachineSpec machineSpec_;
  /**
   *
   *
   * <pre>
   * Required. Immutable. The specification of a single machine.
   * </pre>
   *
   * <code>
   * .google.cloud.aiplatform.v1beta1.MachineSpec machine_spec = 2 [(.google.api.field_behavior) = REQUIRED, (.google.api.field_behavior) = IMMUTABLE];
   * </code>
   *
   * @return Whether the machineSpec field is set.
   */
  @java.lang.Override
  public boolean hasMachineSpec() {
    return ((bitField0_ & 0x00000001) != 0);
  }
  /**
   *
   *
   * <pre>
   * Required. Immutable. The specification of a single machine.
   * </pre>
   *
   * <code>
   * .google.cloud.aiplatform.v1beta1.MachineSpec machine_spec = 2 [(.google.api.field_behavior) = REQUIRED, (.google.api.field_behavior) = IMMUTABLE];
   * </code>
   *
   * @return The machineSpec.
   */
  @java.lang.Override
  public com.google.cloud.aiplatform.v1beta1.MachineSpec getMachineSpec() {
    return machineSpec_ == null
        ? com.google.cloud.aiplatform.v1beta1.MachineSpec.getDefaultInstance()
        : machineSpec_;
  }
  /**
   *
   *
   * <pre>
   * Required. Immutable. The specification of a single machine.
   * </pre>
   *
   * <code>
   * .google.cloud.aiplatform.v1beta1.MachineSpec machine_spec = 2 [(.google.api.field_behavior) = REQUIRED, (.google.api.field_behavior) = IMMUTABLE];
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.aiplatform.v1beta1.MachineSpecOrBuilder getMachineSpecOrBuilder() {
    return machineSpec_ == null
        ? com.google.cloud.aiplatform.v1beta1.MachineSpec.getDefaultInstance()
        : machineSpec_;
  }

  public static final int REPLICA_COUNT_FIELD_NUMBER = 3;
  private long replicaCount_ = 0L;
  /**
   *
   *
   * <pre>
   * Optional. The total number of machines to use for this resource pool.
   * </pre>
   *
   * <code>optional int64 replica_count = 3 [(.google.api.field_behavior) = OPTIONAL];</code>
   *
   * @return Whether the replicaCount field is set.
   */
  @java.lang.Override
  public boolean hasReplicaCount() {
    return ((bitField0_ & 0x00000002) != 0);
  }
  /**
   *
   *
   * <pre>
   * Optional. The total number of machines to use for this resource pool.
   * </pre>
   *
   * <code>optional int64 replica_count = 3 [(.google.api.field_behavior) = OPTIONAL];</code>
   *
   * @return The replicaCount.
   */
  @java.lang.Override
  public long getReplicaCount() {
    return replicaCount_;
  }

  public static final int DISK_SPEC_FIELD_NUMBER = 4;
  private com.google.cloud.aiplatform.v1beta1.DiskSpec diskSpec_;
  /**
   *
   *
   * <pre>
   * Optional. Disk spec for the machine in this node pool.
   * </pre>
   *
   * <code>
   * .google.cloud.aiplatform.v1beta1.DiskSpec disk_spec = 4 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   *
   * @return Whether the diskSpec field is set.
   */
  @java.lang.Override
  public boolean hasDiskSpec() {
    return ((bitField0_ & 0x00000004) != 0);
  }
  /**
   *
   *
   * <pre>
   * Optional. Disk spec for the machine in this node pool.
   * </pre>
   *
   * <code>
   * .google.cloud.aiplatform.v1beta1.DiskSpec disk_spec = 4 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   *
   * @return The diskSpec.
   */
  @java.lang.Override
  public com.google.cloud.aiplatform.v1beta1.DiskSpec getDiskSpec() {
    return diskSpec_ == null
        ? com.google.cloud.aiplatform.v1beta1.DiskSpec.getDefaultInstance()
        : diskSpec_;
  }
  /**
   *
   *
   * <pre>
   * Optional. Disk spec for the machine in this node pool.
   * </pre>
   *
   * <code>
   * .google.cloud.aiplatform.v1beta1.DiskSpec disk_spec = 4 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.aiplatform.v1beta1.DiskSpecOrBuilder getDiskSpecOrBuilder() {
    return diskSpec_ == null
        ? com.google.cloud.aiplatform.v1beta1.DiskSpec.getDefaultInstance()
        : diskSpec_;
  }

  public static final int USED_REPLICA_COUNT_FIELD_NUMBER = 6;
  private long usedReplicaCount_ = 0L;
  /**
   *
   *
   * <pre>
   * Output only. The number of machines currently in use by training jobs for
   * this resource pool. Will replace idle_replica_count.
   * </pre>
   *
   * <code>int64 used_replica_count = 6 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
   *
   * @return The usedReplicaCount.
   */
  @java.lang.Override
  public long getUsedReplicaCount() {
    return usedReplicaCount_;
  }

  public static final int AUTOSCALING_SPEC_FIELD_NUMBER = 7;
  private com.google.cloud.aiplatform.v1beta1.ResourcePool.AutoscalingSpec autoscalingSpec_;
  /**
   *
   *
   * <pre>
   * Optional. Optional spec to configure GKE autoscaling
   * </pre>
   *
   * <code>
   * .google.cloud.aiplatform.v1beta1.ResourcePool.AutoscalingSpec autoscaling_spec = 7 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   *
   * @return Whether the autoscalingSpec field is set.
   */
  @java.lang.Override
  public boolean hasAutoscalingSpec() {
    return ((bitField0_ & 0x00000008) != 0);
  }
  /**
   *
   *
   * <pre>
   * Optional. Optional spec to configure GKE autoscaling
   * </pre>
   *
   * <code>
   * .google.cloud.aiplatform.v1beta1.ResourcePool.AutoscalingSpec autoscaling_spec = 7 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   *
   * @return The autoscalingSpec.
   */
  @java.lang.Override
  public com.google.cloud.aiplatform.v1beta1.ResourcePool.AutoscalingSpec getAutoscalingSpec() {
    return autoscalingSpec_ == null
        ? com.google.cloud.aiplatform.v1beta1.ResourcePool.AutoscalingSpec.getDefaultInstance()
        : autoscalingSpec_;
  }
  /**
   *
   *
   * <pre>
   * Optional. Optional spec to configure GKE autoscaling
   * </pre>
   *
   * <code>
   * .google.cloud.aiplatform.v1beta1.ResourcePool.AutoscalingSpec autoscaling_spec = 7 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.aiplatform.v1beta1.ResourcePool.AutoscalingSpecOrBuilder
      getAutoscalingSpecOrBuilder() {
    return autoscalingSpec_ == null
        ? com.google.cloud.aiplatform.v1beta1.ResourcePool.AutoscalingSpec.getDefaultInstance()
        : autoscalingSpec_;
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(id_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 1, id_);
    }
    if (((bitField0_ & 0x00000001) != 0)) {
      output.writeMessage(2, getMachineSpec());
    }
    if (((bitField0_ & 0x00000002) != 0)) {
      output.writeInt64(3, replicaCount_);
    }
    if (((bitField0_ & 0x00000004) != 0)) {
      output.writeMessage(4, getDiskSpec());
    }
    if (usedReplicaCount_ != 0L) {
      output.writeInt64(6, usedReplicaCount_);
    }
    if (((bitField0_ & 0x00000008) != 0)) {
      output.writeMessage(7, getAutoscalingSpec());
    }
    getUnknownFields().writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(id_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(1, id_);
    }
    if (((bitField0_ & 0x00000001) != 0)) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(2, getMachineSpec());
    }
    if (((bitField0_ & 0x00000002) != 0)) {
      size += com.google.protobuf.CodedOutputStream.computeInt64Size(3, replicaCount_);
    }
    if (((bitField0_ & 0x00000004) != 0)) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(4, getDiskSpec());
    }
    if (usedReplicaCount_ != 0L) {
      size += com.google.protobuf.CodedOutputStream.computeInt64Size(6, usedReplicaCount_);
    }
    if (((bitField0_ & 0x00000008) != 0)) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(7, getAutoscalingSpec());
    }
    size += getUnknownFields().getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.cloud.aiplatform.v1beta1.ResourcePool)) {
      return super.equals(obj);
    }
    com.google.cloud.aiplatform.v1beta1.ResourcePool other =
        (com.google.cloud.aiplatform.v1beta1.ResourcePool) obj;

    if (!getId().equals(other.getId())) return false;
    if (hasMachineSpec() != other.hasMachineSpec()) return false;
    if (hasMachineSpec()) {
      if (!getMachineSpec().equals(other.getMachineSpec())) return false;
    }
    if (hasReplicaCount() != other.hasReplicaCount()) return false;
    if (hasReplicaCount()) {
      if (getReplicaCount() != other.getReplicaCount()) return false;
    }
    if (hasDiskSpec() != other.hasDiskSpec()) return false;
    if (hasDiskSpec()) {
      if (!getDiskSpec().equals(other.getDiskSpec())) return false;
    }
    if (getUsedReplicaCount() != other.getUsedReplicaCount()) return false;
    if (hasAutoscalingSpec() != other.hasAutoscalingSpec()) return false;
    if (hasAutoscalingSpec()) {
      if (!getAutoscalingSpec().equals(other.getAutoscalingSpec())) return false;
    }
    if (!getUnknownFields().equals(other.getUnknownFields())) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    hash = (37 * hash) + ID_FIELD_NUMBER;
    hash = (53 * hash) + getId().hashCode();
    if (hasMachineSpec()) {
      hash = (37 * hash) + MACHINE_SPEC_FIELD_NUMBER;
      hash = (53 * hash) + getMachineSpec().hashCode();
    }
    if (hasReplicaCount()) {
      hash = (37 * hash) + REPLICA_COUNT_FIELD_NUMBER;
      hash = (53 * hash) + com.google.protobuf.Internal.hashLong(getReplicaCount());
    }
    if (hasDiskSpec()) {
      hash = (37 * hash) + DISK_SPEC_FIELD_NUMBER;
      hash = (53 * hash) + getDiskSpec().hashCode();
    }
    hash = (37 * hash) + USED_REPLICA_COUNT_FIELD_NUMBER;
    hash = (53 * hash) + com.google.protobuf.Internal.hashLong(getUsedReplicaCount());
    if (hasAutoscalingSpec()) {
      hash = (37 * hash) + AUTOSCALING_SPEC_FIELD_NUMBER;
      hash = (53 * hash) + getAutoscalingSpec().hashCode();
    }
    hash = (29 * hash) + getUnknownFields().hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.cloud.aiplatform.v1beta1.ResourcePool parseFrom(java.nio.ByteBuffer data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.aiplatform.v1beta1.ResourcePool parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.aiplatform.v1beta1.ResourcePool parseFrom(
      com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.aiplatform.v1beta1.ResourcePool parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.aiplatform.v1beta1.ResourcePool parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.aiplatform.v1beta1.ResourcePool parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.aiplatform.v1beta1.ResourcePool parseFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.aiplatform.v1beta1.ResourcePool parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.aiplatform.v1beta1.ResourcePool parseDelimitedFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.cloud.aiplatform.v1beta1.ResourcePool parseDelimitedFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.aiplatform.v1beta1.ResourcePool parseFrom(
      com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.aiplatform.v1beta1.ResourcePool parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(com.google.cloud.aiplatform.v1beta1.ResourcePool prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }
  /**
   *
   *
   * <pre>
   * Represents the spec of a group of resources of the same type,
   * for example machine type, disk, and accelerators, in a PersistentResource.
   * </pre>
   *
   * Protobuf type {@code google.cloud.aiplatform.v1beta1.ResourcePool}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.cloud.aiplatform.v1beta1.ResourcePool)
      com.google.cloud.aiplatform.v1beta1.ResourcePoolOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.aiplatform.v1beta1.PersistentResourceProto
          .internal_static_google_cloud_aiplatform_v1beta1_ResourcePool_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.aiplatform.v1beta1.PersistentResourceProto
          .internal_static_google_cloud_aiplatform_v1beta1_ResourcePool_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.aiplatform.v1beta1.ResourcePool.class,
              com.google.cloud.aiplatform.v1beta1.ResourcePool.Builder.class);
    }

    // Construct using com.google.cloud.aiplatform.v1beta1.ResourcePool.newBuilder()
    private Builder() {
      maybeForceBuilderInitialization();
    }

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
      maybeForceBuilderInitialization();
    }

    private void maybeForceBuilderInitialization() {
      if (com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders) {
        getMachineSpecFieldBuilder();
        getDiskSpecFieldBuilder();
        getAutoscalingSpecFieldBuilder();
      }
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      bitField0_ = 0;
      id_ = "";
      machineSpec_ = null;
      if (machineSpecBuilder_ != null) {
        machineSpecBuilder_.dispose();
        machineSpecBuilder_ = null;
      }
      replicaCount_ = 0L;
      diskSpec_ = null;
      if (diskSpecBuilder_ != null) {
        diskSpecBuilder_.dispose();
        diskSpecBuilder_ = null;
      }
      usedReplicaCount_ = 0L;
      autoscalingSpec_ = null;
      if (autoscalingSpecBuilder_ != null) {
        autoscalingSpecBuilder_.dispose();
        autoscalingSpecBuilder_ = null;
      }
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.cloud.aiplatform.v1beta1.PersistentResourceProto
          .internal_static_google_cloud_aiplatform_v1beta1_ResourcePool_descriptor;
    }

    @java.lang.Override
    public com.google.cloud.aiplatform.v1beta1.ResourcePool getDefaultInstanceForType() {
      return com.google.cloud.aiplatform.v1beta1.ResourcePool.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.cloud.aiplatform.v1beta1.ResourcePool build() {
      com.google.cloud.aiplatform.v1beta1.ResourcePool result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.cloud.aiplatform.v1beta1.ResourcePool buildPartial() {
      com.google.cloud.aiplatform.v1beta1.ResourcePool result =
          new com.google.cloud.aiplatform.v1beta1.ResourcePool(this);
      if (bitField0_ != 0) {
        buildPartial0(result);
      }
      onBuilt();
      return result;
    }

    private void buildPartial0(com.google.cloud.aiplatform.v1beta1.ResourcePool result) {
      int from_bitField0_ = bitField0_;
      if (((from_bitField0_ & 0x00000001) != 0)) {
        result.id_ = id_;
      }
      int to_bitField0_ = 0;
      if (((from_bitField0_ & 0x00000002) != 0)) {
        result.machineSpec_ =
            machineSpecBuilder_ == null ? machineSpec_ : machineSpecBuilder_.build();
        to_bitField0_ |= 0x00000001;
      }
      if (((from_bitField0_ & 0x00000004) != 0)) {
        result.replicaCount_ = replicaCount_;
        to_bitField0_ |= 0x00000002;
      }
      if (((from_bitField0_ & 0x00000008) != 0)) {
        result.diskSpec_ = diskSpecBuilder_ == null ? diskSpec_ : diskSpecBuilder_.build();
        to_bitField0_ |= 0x00000004;
      }
      if (((from_bitField0_ & 0x00000010) != 0)) {
        result.usedReplicaCount_ = usedReplicaCount_;
      }
      if (((from_bitField0_ & 0x00000020) != 0)) {
        result.autoscalingSpec_ =
            autoscalingSpecBuilder_ == null ? autoscalingSpec_ : autoscalingSpecBuilder_.build();
        to_bitField0_ |= 0x00000008;
      }
      result.bitField0_ |= to_bitField0_;
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.cloud.aiplatform.v1beta1.ResourcePool) {
        return mergeFrom((com.google.cloud.aiplatform.v1beta1.ResourcePool) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(com.google.cloud.aiplatform.v1beta1.ResourcePool other) {
      if (other == com.google.cloud.aiplatform.v1beta1.ResourcePool.getDefaultInstance())
        return this;
      if (!other.getId().isEmpty()) {
        id_ = other.id_;
        bitField0_ |= 0x00000001;
        onChanged();
      }
      if (other.hasMachineSpec()) {
        mergeMachineSpec(other.getMachineSpec());
      }
      if (other.hasReplicaCount()) {
        setReplicaCount(other.getReplicaCount());
      }
      if (other.hasDiskSpec()) {
        mergeDiskSpec(other.getDiskSpec());
      }
      if (other.getUsedReplicaCount() != 0L) {
        setUsedReplicaCount(other.getUsedReplicaCount());
      }
      if (other.hasAutoscalingSpec()) {
        mergeAutoscalingSpec(other.getAutoscalingSpec());
      }
      this.mergeUnknownFields(other.getUnknownFields());
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 10:
              {
                id_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000001;
                break;
              } // case 10
            case 18:
              {
                input.readMessage(getMachineSpecFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000002;
                break;
              } // case 18
            case 24:
              {
                replicaCount_ = input.readInt64();
                bitField0_ |= 0x00000004;
                break;
              } // case 24
            case 34:
              {
                input.readMessage(getDiskSpecFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000008;
                break;
              } // case 34
            case 48:
              {
                usedReplicaCount_ = input.readInt64();
                bitField0_ |= 0x00000010;
                break;
              } // case 48
            case 58:
              {
                input.readMessage(getAutoscalingSpecFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000020;
                break;
              } // case 58
            default:
              {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
          } // switch (tag)
        } // while (!done)
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.unwrapIOException();
      } finally {
        onChanged();
      } // finally
      return this;
    }

    private int bitField0_;

    private java.lang.Object id_ = "";
    /**
     *
     *
     * <pre>
     * Immutable. The unique ID in a PersistentResource for referring to this
     * resource pool. User can specify it if necessary. Otherwise, it's generated
     * automatically.
     * </pre>
     *
     * <code>string id = 1 [(.google.api.field_behavior) = IMMUTABLE];</code>
     *
     * @return The id.
     */
    public java.lang.String getId() {
      java.lang.Object ref = id_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        id_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Immutable. The unique ID in a PersistentResource for referring to this
     * resource pool. User can specify it if necessary. Otherwise, it's generated
     * automatically.
     * </pre>
     *
     * <code>string id = 1 [(.google.api.field_behavior) = IMMUTABLE];</code>
     *
     * @return The bytes for id.
     */
    public com.google.protobuf.ByteString getIdBytes() {
      java.lang.Object ref = id_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        id_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Immutable. The unique ID in a PersistentResource for referring to this
     * resource pool. User can specify it if necessary. Otherwise, it's generated
     * automatically.
     * </pre>
     *
     * <code>string id = 1 [(.google.api.field_behavior) = IMMUTABLE];</code>
     *
     * @param value The id to set.
     * @return This builder for chaining.
     */
    public Builder setId(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      id_ = value;
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Immutable. The unique ID in a PersistentResource for referring to this
     * resource pool. User can specify it if necessary. Otherwise, it's generated
     * automatically.
     * </pre>
     *
     * <code>string id = 1 [(.google.api.field_behavior) = IMMUTABLE];</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearId() {
      id_ = getDefaultInstance().getId();
      bitField0_ = (bitField0_ & ~0x00000001);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Immutable. The unique ID in a PersistentResource for referring to this
     * resource pool. User can specify it if necessary. Otherwise, it's generated
     * automatically.
     * </pre>
     *
     * <code>string id = 1 [(.google.api.field_behavior) = IMMUTABLE];</code>
     *
     * @param value The bytes for id to set.
     * @return This builder for chaining.
     */
    public Builder setIdBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      id_ = value;
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }

    private com.google.cloud.aiplatform.v1beta1.MachineSpec machineSpec_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.aiplatform.v1beta1.MachineSpec,
            com.google.cloud.aiplatform.v1beta1.MachineSpec.Builder,
            com.google.cloud.aiplatform.v1beta1.MachineSpecOrBuilder>
        machineSpecBuilder_;
    /**
     *
     *
     * <pre>
     * Required. Immutable. The specification of a single machine.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.MachineSpec machine_spec = 2 [(.google.api.field_behavior) = REQUIRED, (.google.api.field_behavior) = IMMUTABLE];
     * </code>
     *
     * @return Whether the machineSpec field is set.
     */
    public boolean hasMachineSpec() {
      return ((bitField0_ & 0x00000002) != 0);
    }
    /**
     *
     *
     * <pre>
     * Required. Immutable. The specification of a single machine.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.MachineSpec machine_spec = 2 [(.google.api.field_behavior) = REQUIRED, (.google.api.field_behavior) = IMMUTABLE];
     * </code>
     *
     * @return The machineSpec.
     */
    public com.google.cloud.aiplatform.v1beta1.MachineSpec getMachineSpec() {
      if (machineSpecBuilder_ == null) {
        return machineSpec_ == null
            ? com.google.cloud.aiplatform.v1beta1.MachineSpec.getDefaultInstance()
            : machineSpec_;
      } else {
        return machineSpecBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Required. Immutable. The specification of a single machine.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.MachineSpec machine_spec = 2 [(.google.api.field_behavior) = REQUIRED, (.google.api.field_behavior) = IMMUTABLE];
     * </code>
     */
    public Builder setMachineSpec(com.google.cloud.aiplatform.v1beta1.MachineSpec value) {
      if (machineSpecBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        machineSpec_ = value;
      } else {
        machineSpecBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. Immutable. The specification of a single machine.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.MachineSpec machine_spec = 2 [(.google.api.field_behavior) = REQUIRED, (.google.api.field_behavior) = IMMUTABLE];
     * </code>
     */
    public Builder setMachineSpec(
        com.google.cloud.aiplatform.v1beta1.MachineSpec.Builder builderForValue) {
      if (machineSpecBuilder_ == null) {
        machineSpec_ = builderForValue.build();
      } else {
        machineSpecBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. Immutable. The specification of a single machine.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.MachineSpec machine_spec = 2 [(.google.api.field_behavior) = REQUIRED, (.google.api.field_behavior) = IMMUTABLE];
     * </code>
     */
    public Builder mergeMachineSpec(com.google.cloud.aiplatform.v1beta1.MachineSpec value) {
      if (machineSpecBuilder_ == null) {
        if (((bitField0_ & 0x00000002) != 0)
            && machineSpec_ != null
            && machineSpec_
                != com.google.cloud.aiplatform.v1beta1.MachineSpec.getDefaultInstance()) {
          getMachineSpecBuilder().mergeFrom(value);
        } else {
          machineSpec_ = value;
        }
      } else {
        machineSpecBuilder_.mergeFrom(value);
      }
      if (machineSpec_ != null) {
        bitField0_ |= 0x00000002;
        onChanged();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. Immutable. The specification of a single machine.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.MachineSpec machine_spec = 2 [(.google.api.field_behavior) = REQUIRED, (.google.api.field_behavior) = IMMUTABLE];
     * </code>
     */
    public Builder clearMachineSpec() {
      bitField0_ = (bitField0_ & ~0x00000002);
      machineSpec_ = null;
      if (machineSpecBuilder_ != null) {
        machineSpecBuilder_.dispose();
        machineSpecBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. Immutable. The specification of a single machine.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.MachineSpec machine_spec = 2 [(.google.api.field_behavior) = REQUIRED, (.google.api.field_behavior) = IMMUTABLE];
     * </code>
     */
    public com.google.cloud.aiplatform.v1beta1.MachineSpec.Builder getMachineSpecBuilder() {
      bitField0_ |= 0x00000002;
      onChanged();
      return getMachineSpecFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Required. Immutable. The specification of a single machine.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.MachineSpec machine_spec = 2 [(.google.api.field_behavior) = REQUIRED, (.google.api.field_behavior) = IMMUTABLE];
     * </code>
     */
    public com.google.cloud.aiplatform.v1beta1.MachineSpecOrBuilder getMachineSpecOrBuilder() {
      if (machineSpecBuilder_ != null) {
        return machineSpecBuilder_.getMessageOrBuilder();
      } else {
        return machineSpec_ == null
            ? com.google.cloud.aiplatform.v1beta1.MachineSpec.getDefaultInstance()
            : machineSpec_;
      }
    }
    /**
     *
     *
     * <pre>
     * Required. Immutable. The specification of a single machine.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.MachineSpec machine_spec = 2 [(.google.api.field_behavior) = REQUIRED, (.google.api.field_behavior) = IMMUTABLE];
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.aiplatform.v1beta1.MachineSpec,
            com.google.cloud.aiplatform.v1beta1.MachineSpec.Builder,
            com.google.cloud.aiplatform.v1beta1.MachineSpecOrBuilder>
        getMachineSpecFieldBuilder() {
      if (machineSpecBuilder_ == null) {
        machineSpecBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.aiplatform.v1beta1.MachineSpec,
                com.google.cloud.aiplatform.v1beta1.MachineSpec.Builder,
                com.google.cloud.aiplatform.v1beta1.MachineSpecOrBuilder>(
                getMachineSpec(), getParentForChildren(), isClean());
        machineSpec_ = null;
      }
      return machineSpecBuilder_;
    }

    private long replicaCount_;
    /**
     *
     *
     * <pre>
     * Optional. The total number of machines to use for this resource pool.
     * </pre>
     *
     * <code>optional int64 replica_count = 3 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return Whether the replicaCount field is set.
     */
    @java.lang.Override
    public boolean hasReplicaCount() {
      return ((bitField0_ & 0x00000004) != 0);
    }
    /**
     *
     *
     * <pre>
     * Optional. The total number of machines to use for this resource pool.
     * </pre>
     *
     * <code>optional int64 replica_count = 3 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return The replicaCount.
     */
    @java.lang.Override
    public long getReplicaCount() {
      return replicaCount_;
    }
    /**
     *
     *
     * <pre>
     * Optional. The total number of machines to use for this resource pool.
     * </pre>
     *
     * <code>optional int64 replica_count = 3 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @param value The replicaCount to set.
     * @return This builder for chaining.
     */
    public Builder setReplicaCount(long value) {

      replicaCount_ = value;
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. The total number of machines to use for this resource pool.
     * </pre>
     *
     * <code>optional int64 replica_count = 3 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearReplicaCount() {
      bitField0_ = (bitField0_ & ~0x00000004);
      replicaCount_ = 0L;
      onChanged();
      return this;
    }

    private com.google.cloud.aiplatform.v1beta1.DiskSpec diskSpec_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.aiplatform.v1beta1.DiskSpec,
            com.google.cloud.aiplatform.v1beta1.DiskSpec.Builder,
            com.google.cloud.aiplatform.v1beta1.DiskSpecOrBuilder>
        diskSpecBuilder_;
    /**
     *
     *
     * <pre>
     * Optional. Disk spec for the machine in this node pool.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.DiskSpec disk_spec = 4 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return Whether the diskSpec field is set.
     */
    public boolean hasDiskSpec() {
      return ((bitField0_ & 0x00000008) != 0);
    }
    /**
     *
     *
     * <pre>
     * Optional. Disk spec for the machine in this node pool.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.DiskSpec disk_spec = 4 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return The diskSpec.
     */
    public com.google.cloud.aiplatform.v1beta1.DiskSpec getDiskSpec() {
      if (diskSpecBuilder_ == null) {
        return diskSpec_ == null
            ? com.google.cloud.aiplatform.v1beta1.DiskSpec.getDefaultInstance()
            : diskSpec_;
      } else {
        return diskSpecBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Optional. Disk spec for the machine in this node pool.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.DiskSpec disk_spec = 4 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder setDiskSpec(com.google.cloud.aiplatform.v1beta1.DiskSpec value) {
      if (diskSpecBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        diskSpec_ = value;
      } else {
        diskSpecBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000008;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. Disk spec for the machine in this node pool.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.DiskSpec disk_spec = 4 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder setDiskSpec(
        com.google.cloud.aiplatform.v1beta1.DiskSpec.Builder builderForValue) {
      if (diskSpecBuilder_ == null) {
        diskSpec_ = builderForValue.build();
      } else {
        diskSpecBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000008;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. Disk spec for the machine in this node pool.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.DiskSpec disk_spec = 4 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder mergeDiskSpec(com.google.cloud.aiplatform.v1beta1.DiskSpec value) {
      if (diskSpecBuilder_ == null) {
        if (((bitField0_ & 0x00000008) != 0)
            && diskSpec_ != null
            && diskSpec_ != com.google.cloud.aiplatform.v1beta1.DiskSpec.getDefaultInstance()) {
          getDiskSpecBuilder().mergeFrom(value);
        } else {
          diskSpec_ = value;
        }
      } else {
        diskSpecBuilder_.mergeFrom(value);
      }
      if (diskSpec_ != null) {
        bitField0_ |= 0x00000008;
        onChanged();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. Disk spec for the machine in this node pool.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.DiskSpec disk_spec = 4 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder clearDiskSpec() {
      bitField0_ = (bitField0_ & ~0x00000008);
      diskSpec_ = null;
      if (diskSpecBuilder_ != null) {
        diskSpecBuilder_.dispose();
        diskSpecBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. Disk spec for the machine in this node pool.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.DiskSpec disk_spec = 4 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public com.google.cloud.aiplatform.v1beta1.DiskSpec.Builder getDiskSpecBuilder() {
      bitField0_ |= 0x00000008;
      onChanged();
      return getDiskSpecFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Optional. Disk spec for the machine in this node pool.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.DiskSpec disk_spec = 4 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public com.google.cloud.aiplatform.v1beta1.DiskSpecOrBuilder getDiskSpecOrBuilder() {
      if (diskSpecBuilder_ != null) {
        return diskSpecBuilder_.getMessageOrBuilder();
      } else {
        return diskSpec_ == null
            ? com.google.cloud.aiplatform.v1beta1.DiskSpec.getDefaultInstance()
            : diskSpec_;
      }
    }
    /**
     *
     *
     * <pre>
     * Optional. Disk spec for the machine in this node pool.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.DiskSpec disk_spec = 4 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.aiplatform.v1beta1.DiskSpec,
            com.google.cloud.aiplatform.v1beta1.DiskSpec.Builder,
            com.google.cloud.aiplatform.v1beta1.DiskSpecOrBuilder>
        getDiskSpecFieldBuilder() {
      if (diskSpecBuilder_ == null) {
        diskSpecBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.aiplatform.v1beta1.DiskSpec,
                com.google.cloud.aiplatform.v1beta1.DiskSpec.Builder,
                com.google.cloud.aiplatform.v1beta1.DiskSpecOrBuilder>(
                getDiskSpec(), getParentForChildren(), isClean());
        diskSpec_ = null;
      }
      return diskSpecBuilder_;
    }

    private long usedReplicaCount_;
    /**
     *
     *
     * <pre>
     * Output only. The number of machines currently in use by training jobs for
     * this resource pool. Will replace idle_replica_count.
     * </pre>
     *
     * <code>int64 used_replica_count = 6 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return The usedReplicaCount.
     */
    @java.lang.Override
    public long getUsedReplicaCount() {
      return usedReplicaCount_;
    }
    /**
     *
     *
     * <pre>
     * Output only. The number of machines currently in use by training jobs for
     * this resource pool. Will replace idle_replica_count.
     * </pre>
     *
     * <code>int64 used_replica_count = 6 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @param value The usedReplicaCount to set.
     * @return This builder for chaining.
     */
    public Builder setUsedReplicaCount(long value) {

      usedReplicaCount_ = value;
      bitField0_ |= 0x00000010;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The number of machines currently in use by training jobs for
     * this resource pool. Will replace idle_replica_count.
     * </pre>
     *
     * <code>int64 used_replica_count = 6 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearUsedReplicaCount() {
      bitField0_ = (bitField0_ & ~0x00000010);
      usedReplicaCount_ = 0L;
      onChanged();
      return this;
    }

    private com.google.cloud.aiplatform.v1beta1.ResourcePool.AutoscalingSpec autoscalingSpec_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.aiplatform.v1beta1.ResourcePool.AutoscalingSpec,
            com.google.cloud.aiplatform.v1beta1.ResourcePool.AutoscalingSpec.Builder,
            com.google.cloud.aiplatform.v1beta1.ResourcePool.AutoscalingSpecOrBuilder>
        autoscalingSpecBuilder_;
    /**
     *
     *
     * <pre>
     * Optional. Optional spec to configure GKE autoscaling
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.ResourcePool.AutoscalingSpec autoscaling_spec = 7 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return Whether the autoscalingSpec field is set.
     */
    public boolean hasAutoscalingSpec() {
      return ((bitField0_ & 0x00000020) != 0);
    }
    /**
     *
     *
     * <pre>
     * Optional. Optional spec to configure GKE autoscaling
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.ResourcePool.AutoscalingSpec autoscaling_spec = 7 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return The autoscalingSpec.
     */
    public com.google.cloud.aiplatform.v1beta1.ResourcePool.AutoscalingSpec getAutoscalingSpec() {
      if (autoscalingSpecBuilder_ == null) {
        return autoscalingSpec_ == null
            ? com.google.cloud.aiplatform.v1beta1.ResourcePool.AutoscalingSpec.getDefaultInstance()
            : autoscalingSpec_;
      } else {
        return autoscalingSpecBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Optional. Optional spec to configure GKE autoscaling
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.ResourcePool.AutoscalingSpec autoscaling_spec = 7 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder setAutoscalingSpec(
        com.google.cloud.aiplatform.v1beta1.ResourcePool.AutoscalingSpec value) {
      if (autoscalingSpecBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        autoscalingSpec_ = value;
      } else {
        autoscalingSpecBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000020;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. Optional spec to configure GKE autoscaling
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.ResourcePool.AutoscalingSpec autoscaling_spec = 7 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder setAutoscalingSpec(
        com.google.cloud.aiplatform.v1beta1.ResourcePool.AutoscalingSpec.Builder builderForValue) {
      if (autoscalingSpecBuilder_ == null) {
        autoscalingSpec_ = builderForValue.build();
      } else {
        autoscalingSpecBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000020;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. Optional spec to configure GKE autoscaling
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.ResourcePool.AutoscalingSpec autoscaling_spec = 7 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder mergeAutoscalingSpec(
        com.google.cloud.aiplatform.v1beta1.ResourcePool.AutoscalingSpec value) {
      if (autoscalingSpecBuilder_ == null) {
        if (((bitField0_ & 0x00000020) != 0)
            && autoscalingSpec_ != null
            && autoscalingSpec_
                != com.google.cloud.aiplatform.v1beta1.ResourcePool.AutoscalingSpec
                    .getDefaultInstance()) {
          getAutoscalingSpecBuilder().mergeFrom(value);
        } else {
          autoscalingSpec_ = value;
        }
      } else {
        autoscalingSpecBuilder_.mergeFrom(value);
      }
      if (autoscalingSpec_ != null) {
        bitField0_ |= 0x00000020;
        onChanged();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. Optional spec to configure GKE autoscaling
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.ResourcePool.AutoscalingSpec autoscaling_spec = 7 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder clearAutoscalingSpec() {
      bitField0_ = (bitField0_ & ~0x00000020);
      autoscalingSpec_ = null;
      if (autoscalingSpecBuilder_ != null) {
        autoscalingSpecBuilder_.dispose();
        autoscalingSpecBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. Optional spec to configure GKE autoscaling
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.ResourcePool.AutoscalingSpec autoscaling_spec = 7 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public com.google.cloud.aiplatform.v1beta1.ResourcePool.AutoscalingSpec.Builder
        getAutoscalingSpecBuilder() {
      bitField0_ |= 0x00000020;
      onChanged();
      return getAutoscalingSpecFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Optional. Optional spec to configure GKE autoscaling
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.ResourcePool.AutoscalingSpec autoscaling_spec = 7 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public com.google.cloud.aiplatform.v1beta1.ResourcePool.AutoscalingSpecOrBuilder
        getAutoscalingSpecOrBuilder() {
      if (autoscalingSpecBuilder_ != null) {
        return autoscalingSpecBuilder_.getMessageOrBuilder();
      } else {
        return autoscalingSpec_ == null
            ? com.google.cloud.aiplatform.v1beta1.ResourcePool.AutoscalingSpec.getDefaultInstance()
            : autoscalingSpec_;
      }
    }
    /**
     *
     *
     * <pre>
     * Optional. Optional spec to configure GKE autoscaling
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.ResourcePool.AutoscalingSpec autoscaling_spec = 7 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.aiplatform.v1beta1.ResourcePool.AutoscalingSpec,
            com.google.cloud.aiplatform.v1beta1.ResourcePool.AutoscalingSpec.Builder,
            com.google.cloud.aiplatform.v1beta1.ResourcePool.AutoscalingSpecOrBuilder>
        getAutoscalingSpecFieldBuilder() {
      if (autoscalingSpecBuilder_ == null) {
        autoscalingSpecBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.aiplatform.v1beta1.ResourcePool.AutoscalingSpec,
                com.google.cloud.aiplatform.v1beta1.ResourcePool.AutoscalingSpec.Builder,
                com.google.cloud.aiplatform.v1beta1.ResourcePool.AutoscalingSpecOrBuilder>(
                getAutoscalingSpec(), getParentForChildren(), isClean());
        autoscalingSpec_ = null;
      }
      return autoscalingSpecBuilder_;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.cloud.aiplatform.v1beta1.ResourcePool)
  }

  // @@protoc_insertion_point(class_scope:google.cloud.aiplatform.v1beta1.ResourcePool)
  private static final com.google.cloud.aiplatform.v1beta1.ResourcePool DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.cloud.aiplatform.v1beta1.ResourcePool();
  }

  public static com.google.cloud.aiplatform.v1beta1.ResourcePool getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<ResourcePool> PARSER =
      new com.google.protobuf.AbstractParser<ResourcePool>() {
        @java.lang.Override
        public ResourcePool parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          Builder builder = newBuilder();
          try {
            builder.mergeFrom(input, extensionRegistry);
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.setUnfinishedMessage(builder.buildPartial());
          } catch (com.google.protobuf.UninitializedMessageException e) {
            throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
          } catch (java.io.IOException e) {
            throw new com.google.protobuf.InvalidProtocolBufferException(e)
                .setUnfinishedMessage(builder.buildPartial());
          }
          return builder.buildPartial();
        }
      };

  public static com.google.protobuf.Parser<ResourcePool> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<ResourcePool> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.cloud.aiplatform.v1beta1.ResourcePool getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
