/*
 * Copyright 2024 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/cloud/aiplatform/v1beta1/machine_resources.proto

// Protobuf Java Version: 3.25.3
package com.google.cloud.aiplatform.v1beta1;

/**
 *
 *
 * <pre>
 * A description of resources that are dedicated to a DeployedModel, and
 * that need a higher degree of manual configuration.
 * </pre>
 *
 * Protobuf type {@code google.cloud.aiplatform.v1beta1.DedicatedResources}
 */
public final class DedicatedResources extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.cloud.aiplatform.v1beta1.DedicatedResources)
    DedicatedResourcesOrBuilder {
  private static final long serialVersionUID = 0L;
  // Use DedicatedResources.newBuilder() to construct.
  private DedicatedResources(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private DedicatedResources() {
    autoscalingMetricSpecs_ = java.util.Collections.emptyList();
  }

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new DedicatedResources();
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.cloud.aiplatform.v1beta1.MachineResourcesProto
        .internal_static_google_cloud_aiplatform_v1beta1_DedicatedResources_descriptor;
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.cloud.aiplatform.v1beta1.MachineResourcesProto
        .internal_static_google_cloud_aiplatform_v1beta1_DedicatedResources_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.cloud.aiplatform.v1beta1.DedicatedResources.class,
            com.google.cloud.aiplatform.v1beta1.DedicatedResources.Builder.class);
  }

  private int bitField0_;
  public static final int MACHINE_SPEC_FIELD_NUMBER = 1;
  private com.google.cloud.aiplatform.v1beta1.MachineSpec machineSpec_;
  /**
   *
   *
   * <pre>
   * Required. Immutable. The specification of a single machine used by the
   * prediction.
   * </pre>
   *
   * <code>
   * .google.cloud.aiplatform.v1beta1.MachineSpec machine_spec = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.field_behavior) = IMMUTABLE];
   * </code>
   *
   * @return Whether the machineSpec field is set.
   */
  @java.lang.Override
  public boolean hasMachineSpec() {
    return ((bitField0_ & 0x00000001) != 0);
  }
  /**
   *
   *
   * <pre>
   * Required. Immutable. The specification of a single machine used by the
   * prediction.
   * </pre>
   *
   * <code>
   * .google.cloud.aiplatform.v1beta1.MachineSpec machine_spec = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.field_behavior) = IMMUTABLE];
   * </code>
   *
   * @return The machineSpec.
   */
  @java.lang.Override
  public com.google.cloud.aiplatform.v1beta1.MachineSpec getMachineSpec() {
    return machineSpec_ == null
        ? com.google.cloud.aiplatform.v1beta1.MachineSpec.getDefaultInstance()
        : machineSpec_;
  }
  /**
   *
   *
   * <pre>
   * Required. Immutable. The specification of a single machine used by the
   * prediction.
   * </pre>
   *
   * <code>
   * .google.cloud.aiplatform.v1beta1.MachineSpec machine_spec = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.field_behavior) = IMMUTABLE];
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.aiplatform.v1beta1.MachineSpecOrBuilder getMachineSpecOrBuilder() {
    return machineSpec_ == null
        ? com.google.cloud.aiplatform.v1beta1.MachineSpec.getDefaultInstance()
        : machineSpec_;
  }

  public static final int MIN_REPLICA_COUNT_FIELD_NUMBER = 2;
  private int minReplicaCount_ = 0;
  /**
   *
   *
   * <pre>
   * Required. Immutable. The minimum number of machine replicas this
   * DeployedModel will be always deployed on. This value must be greater than
   * or equal to 1.
   *
   * If traffic against the DeployedModel increases, it may dynamically be
   * deployed onto more replicas, and as traffic decreases, some of these extra
   * replicas may be freed.
   * </pre>
   *
   * <code>
   * int32 min_replica_count = 2 [(.google.api.field_behavior) = REQUIRED, (.google.api.field_behavior) = IMMUTABLE];
   * </code>
   *
   * @return The minReplicaCount.
   */
  @java.lang.Override
  public int getMinReplicaCount() {
    return minReplicaCount_;
  }

  public static final int MAX_REPLICA_COUNT_FIELD_NUMBER = 3;
  private int maxReplicaCount_ = 0;
  /**
   *
   *
   * <pre>
   * Immutable. The maximum number of replicas this DeployedModel may be
   * deployed on when the traffic against it increases. If the requested value
   * is too large, the deployment will error, but if deployment succeeds then
   * the ability to scale the model to that many replicas is guaranteed (barring
   * service outages). If traffic against the DeployedModel increases beyond
   * what its replicas at maximum may handle, a portion of the traffic will be
   * dropped. If this value is not provided, will use
   * [min_replica_count][google.cloud.aiplatform.v1beta1.DedicatedResources.min_replica_count]
   * as the default value.
   *
   * The value of this field impacts the charge against Vertex CPU and GPU
   * quotas. Specifically, you will be charged for (max_replica_count *
   * number of cores in the selected machine type) and (max_replica_count *
   * number of GPUs per replica in the selected machine type).
   * </pre>
   *
   * <code>int32 max_replica_count = 3 [(.google.api.field_behavior) = IMMUTABLE];</code>
   *
   * @return The maxReplicaCount.
   */
  @java.lang.Override
  public int getMaxReplicaCount() {
    return maxReplicaCount_;
  }

  public static final int AUTOSCALING_METRIC_SPECS_FIELD_NUMBER = 4;

  @SuppressWarnings("serial")
  private java.util.List<com.google.cloud.aiplatform.v1beta1.AutoscalingMetricSpec>
      autoscalingMetricSpecs_;
  /**
   *
   *
   * <pre>
   * Immutable. The metric specifications that overrides a resource
   * utilization metric (CPU utilization, accelerator's duty cycle, and so on)
   * target value (default to 60 if not set). At most one entry is allowed per
   * metric.
   *
   * If
   * [machine_spec.accelerator_count][google.cloud.aiplatform.v1beta1.MachineSpec.accelerator_count]
   * is above 0, the autoscaling will be based on both CPU utilization and
   * accelerator's duty cycle metrics and scale up when either metrics exceeds
   * its target value while scale down if both metrics are under their target
   * value. The default target value is 60 for both metrics.
   *
   * If
   * [machine_spec.accelerator_count][google.cloud.aiplatform.v1beta1.MachineSpec.accelerator_count]
   * is 0, the autoscaling will be based on CPU utilization metric only with
   * default target value 60 if not explicitly set.
   *
   * For example, in the case of Online Prediction, if you want to override
   * target CPU utilization to 80, you should set
   * [autoscaling_metric_specs.metric_name][google.cloud.aiplatform.v1beta1.AutoscalingMetricSpec.metric_name]
   * to `aiplatform.googleapis.com/prediction/online/cpu/utilization` and
   * [autoscaling_metric_specs.target][google.cloud.aiplatform.v1beta1.AutoscalingMetricSpec.target]
   * to `80`.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.aiplatform.v1beta1.AutoscalingMetricSpec autoscaling_metric_specs = 4 [(.google.api.field_behavior) = IMMUTABLE];
   * </code>
   */
  @java.lang.Override
  public java.util.List<com.google.cloud.aiplatform.v1beta1.AutoscalingMetricSpec>
      getAutoscalingMetricSpecsList() {
    return autoscalingMetricSpecs_;
  }
  /**
   *
   *
   * <pre>
   * Immutable. The metric specifications that overrides a resource
   * utilization metric (CPU utilization, accelerator's duty cycle, and so on)
   * target value (default to 60 if not set). At most one entry is allowed per
   * metric.
   *
   * If
   * [machine_spec.accelerator_count][google.cloud.aiplatform.v1beta1.MachineSpec.accelerator_count]
   * is above 0, the autoscaling will be based on both CPU utilization and
   * accelerator's duty cycle metrics and scale up when either metrics exceeds
   * its target value while scale down if both metrics are under their target
   * value. The default target value is 60 for both metrics.
   *
   * If
   * [machine_spec.accelerator_count][google.cloud.aiplatform.v1beta1.MachineSpec.accelerator_count]
   * is 0, the autoscaling will be based on CPU utilization metric only with
   * default target value 60 if not explicitly set.
   *
   * For example, in the case of Online Prediction, if you want to override
   * target CPU utilization to 80, you should set
   * [autoscaling_metric_specs.metric_name][google.cloud.aiplatform.v1beta1.AutoscalingMetricSpec.metric_name]
   * to `aiplatform.googleapis.com/prediction/online/cpu/utilization` and
   * [autoscaling_metric_specs.target][google.cloud.aiplatform.v1beta1.AutoscalingMetricSpec.target]
   * to `80`.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.aiplatform.v1beta1.AutoscalingMetricSpec autoscaling_metric_specs = 4 [(.google.api.field_behavior) = IMMUTABLE];
   * </code>
   */
  @java.lang.Override
  public java.util.List<
          ? extends com.google.cloud.aiplatform.v1beta1.AutoscalingMetricSpecOrBuilder>
      getAutoscalingMetricSpecsOrBuilderList() {
    return autoscalingMetricSpecs_;
  }
  /**
   *
   *
   * <pre>
   * Immutable. The metric specifications that overrides a resource
   * utilization metric (CPU utilization, accelerator's duty cycle, and so on)
   * target value (default to 60 if not set). At most one entry is allowed per
   * metric.
   *
   * If
   * [machine_spec.accelerator_count][google.cloud.aiplatform.v1beta1.MachineSpec.accelerator_count]
   * is above 0, the autoscaling will be based on both CPU utilization and
   * accelerator's duty cycle metrics and scale up when either metrics exceeds
   * its target value while scale down if both metrics are under their target
   * value. The default target value is 60 for both metrics.
   *
   * If
   * [machine_spec.accelerator_count][google.cloud.aiplatform.v1beta1.MachineSpec.accelerator_count]
   * is 0, the autoscaling will be based on CPU utilization metric only with
   * default target value 60 if not explicitly set.
   *
   * For example, in the case of Online Prediction, if you want to override
   * target CPU utilization to 80, you should set
   * [autoscaling_metric_specs.metric_name][google.cloud.aiplatform.v1beta1.AutoscalingMetricSpec.metric_name]
   * to `aiplatform.googleapis.com/prediction/online/cpu/utilization` and
   * [autoscaling_metric_specs.target][google.cloud.aiplatform.v1beta1.AutoscalingMetricSpec.target]
   * to `80`.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.aiplatform.v1beta1.AutoscalingMetricSpec autoscaling_metric_specs = 4 [(.google.api.field_behavior) = IMMUTABLE];
   * </code>
   */
  @java.lang.Override
  public int getAutoscalingMetricSpecsCount() {
    return autoscalingMetricSpecs_.size();
  }
  /**
   *
   *
   * <pre>
   * Immutable. The metric specifications that overrides a resource
   * utilization metric (CPU utilization, accelerator's duty cycle, and so on)
   * target value (default to 60 if not set). At most one entry is allowed per
   * metric.
   *
   * If
   * [machine_spec.accelerator_count][google.cloud.aiplatform.v1beta1.MachineSpec.accelerator_count]
   * is above 0, the autoscaling will be based on both CPU utilization and
   * accelerator's duty cycle metrics and scale up when either metrics exceeds
   * its target value while scale down if both metrics are under their target
   * value. The default target value is 60 for both metrics.
   *
   * If
   * [machine_spec.accelerator_count][google.cloud.aiplatform.v1beta1.MachineSpec.accelerator_count]
   * is 0, the autoscaling will be based on CPU utilization metric only with
   * default target value 60 if not explicitly set.
   *
   * For example, in the case of Online Prediction, if you want to override
   * target CPU utilization to 80, you should set
   * [autoscaling_metric_specs.metric_name][google.cloud.aiplatform.v1beta1.AutoscalingMetricSpec.metric_name]
   * to `aiplatform.googleapis.com/prediction/online/cpu/utilization` and
   * [autoscaling_metric_specs.target][google.cloud.aiplatform.v1beta1.AutoscalingMetricSpec.target]
   * to `80`.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.aiplatform.v1beta1.AutoscalingMetricSpec autoscaling_metric_specs = 4 [(.google.api.field_behavior) = IMMUTABLE];
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.aiplatform.v1beta1.AutoscalingMetricSpec getAutoscalingMetricSpecs(
      int index) {
    return autoscalingMetricSpecs_.get(index);
  }
  /**
   *
   *
   * <pre>
   * Immutable. The metric specifications that overrides a resource
   * utilization metric (CPU utilization, accelerator's duty cycle, and so on)
   * target value (default to 60 if not set). At most one entry is allowed per
   * metric.
   *
   * If
   * [machine_spec.accelerator_count][google.cloud.aiplatform.v1beta1.MachineSpec.accelerator_count]
   * is above 0, the autoscaling will be based on both CPU utilization and
   * accelerator's duty cycle metrics and scale up when either metrics exceeds
   * its target value while scale down if both metrics are under their target
   * value. The default target value is 60 for both metrics.
   *
   * If
   * [machine_spec.accelerator_count][google.cloud.aiplatform.v1beta1.MachineSpec.accelerator_count]
   * is 0, the autoscaling will be based on CPU utilization metric only with
   * default target value 60 if not explicitly set.
   *
   * For example, in the case of Online Prediction, if you want to override
   * target CPU utilization to 80, you should set
   * [autoscaling_metric_specs.metric_name][google.cloud.aiplatform.v1beta1.AutoscalingMetricSpec.metric_name]
   * to `aiplatform.googleapis.com/prediction/online/cpu/utilization` and
   * [autoscaling_metric_specs.target][google.cloud.aiplatform.v1beta1.AutoscalingMetricSpec.target]
   * to `80`.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.aiplatform.v1beta1.AutoscalingMetricSpec autoscaling_metric_specs = 4 [(.google.api.field_behavior) = IMMUTABLE];
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.aiplatform.v1beta1.AutoscalingMetricSpecOrBuilder
      getAutoscalingMetricSpecsOrBuilder(int index) {
    return autoscalingMetricSpecs_.get(index);
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    if (((bitField0_ & 0x00000001) != 0)) {
      output.writeMessage(1, getMachineSpec());
    }
    if (minReplicaCount_ != 0) {
      output.writeInt32(2, minReplicaCount_);
    }
    if (maxReplicaCount_ != 0) {
      output.writeInt32(3, maxReplicaCount_);
    }
    for (int i = 0; i < autoscalingMetricSpecs_.size(); i++) {
      output.writeMessage(4, autoscalingMetricSpecs_.get(i));
    }
    getUnknownFields().writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    if (((bitField0_ & 0x00000001) != 0)) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(1, getMachineSpec());
    }
    if (minReplicaCount_ != 0) {
      size += com.google.protobuf.CodedOutputStream.computeInt32Size(2, minReplicaCount_);
    }
    if (maxReplicaCount_ != 0) {
      size += com.google.protobuf.CodedOutputStream.computeInt32Size(3, maxReplicaCount_);
    }
    for (int i = 0; i < autoscalingMetricSpecs_.size(); i++) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(
              4, autoscalingMetricSpecs_.get(i));
    }
    size += getUnknownFields().getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.cloud.aiplatform.v1beta1.DedicatedResources)) {
      return super.equals(obj);
    }
    com.google.cloud.aiplatform.v1beta1.DedicatedResources other =
        (com.google.cloud.aiplatform.v1beta1.DedicatedResources) obj;

    if (hasMachineSpec() != other.hasMachineSpec()) return false;
    if (hasMachineSpec()) {
      if (!getMachineSpec().equals(other.getMachineSpec())) return false;
    }
    if (getMinReplicaCount() != other.getMinReplicaCount()) return false;
    if (getMaxReplicaCount() != other.getMaxReplicaCount()) return false;
    if (!getAutoscalingMetricSpecsList().equals(other.getAutoscalingMetricSpecsList()))
      return false;
    if (!getUnknownFields().equals(other.getUnknownFields())) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    if (hasMachineSpec()) {
      hash = (37 * hash) + MACHINE_SPEC_FIELD_NUMBER;
      hash = (53 * hash) + getMachineSpec().hashCode();
    }
    hash = (37 * hash) + MIN_REPLICA_COUNT_FIELD_NUMBER;
    hash = (53 * hash) + getMinReplicaCount();
    hash = (37 * hash) + MAX_REPLICA_COUNT_FIELD_NUMBER;
    hash = (53 * hash) + getMaxReplicaCount();
    if (getAutoscalingMetricSpecsCount() > 0) {
      hash = (37 * hash) + AUTOSCALING_METRIC_SPECS_FIELD_NUMBER;
      hash = (53 * hash) + getAutoscalingMetricSpecsList().hashCode();
    }
    hash = (29 * hash) + getUnknownFields().hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.cloud.aiplatform.v1beta1.DedicatedResources parseFrom(
      java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.aiplatform.v1beta1.DedicatedResources parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.aiplatform.v1beta1.DedicatedResources parseFrom(
      com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.aiplatform.v1beta1.DedicatedResources parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.aiplatform.v1beta1.DedicatedResources parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.aiplatform.v1beta1.DedicatedResources parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.aiplatform.v1beta1.DedicatedResources parseFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.aiplatform.v1beta1.DedicatedResources parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.aiplatform.v1beta1.DedicatedResources parseDelimitedFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.cloud.aiplatform.v1beta1.DedicatedResources parseDelimitedFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.aiplatform.v1beta1.DedicatedResources parseFrom(
      com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.aiplatform.v1beta1.DedicatedResources parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(
      com.google.cloud.aiplatform.v1beta1.DedicatedResources prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }
  /**
   *
   *
   * <pre>
   * A description of resources that are dedicated to a DeployedModel, and
   * that need a higher degree of manual configuration.
   * </pre>
   *
   * Protobuf type {@code google.cloud.aiplatform.v1beta1.DedicatedResources}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.cloud.aiplatform.v1beta1.DedicatedResources)
      com.google.cloud.aiplatform.v1beta1.DedicatedResourcesOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.aiplatform.v1beta1.MachineResourcesProto
          .internal_static_google_cloud_aiplatform_v1beta1_DedicatedResources_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.aiplatform.v1beta1.MachineResourcesProto
          .internal_static_google_cloud_aiplatform_v1beta1_DedicatedResources_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.aiplatform.v1beta1.DedicatedResources.class,
              com.google.cloud.aiplatform.v1beta1.DedicatedResources.Builder.class);
    }

    // Construct using com.google.cloud.aiplatform.v1beta1.DedicatedResources.newBuilder()
    private Builder() {
      maybeForceBuilderInitialization();
    }

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
      maybeForceBuilderInitialization();
    }

    private void maybeForceBuilderInitialization() {
      if (com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders) {
        getMachineSpecFieldBuilder();
        getAutoscalingMetricSpecsFieldBuilder();
      }
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      bitField0_ = 0;
      machineSpec_ = null;
      if (machineSpecBuilder_ != null) {
        machineSpecBuilder_.dispose();
        machineSpecBuilder_ = null;
      }
      minReplicaCount_ = 0;
      maxReplicaCount_ = 0;
      if (autoscalingMetricSpecsBuilder_ == null) {
        autoscalingMetricSpecs_ = java.util.Collections.emptyList();
      } else {
        autoscalingMetricSpecs_ = null;
        autoscalingMetricSpecsBuilder_.clear();
      }
      bitField0_ = (bitField0_ & ~0x00000008);
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.cloud.aiplatform.v1beta1.MachineResourcesProto
          .internal_static_google_cloud_aiplatform_v1beta1_DedicatedResources_descriptor;
    }

    @java.lang.Override
    public com.google.cloud.aiplatform.v1beta1.DedicatedResources getDefaultInstanceForType() {
      return com.google.cloud.aiplatform.v1beta1.DedicatedResources.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.cloud.aiplatform.v1beta1.DedicatedResources build() {
      com.google.cloud.aiplatform.v1beta1.DedicatedResources result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.cloud.aiplatform.v1beta1.DedicatedResources buildPartial() {
      com.google.cloud.aiplatform.v1beta1.DedicatedResources result =
          new com.google.cloud.aiplatform.v1beta1.DedicatedResources(this);
      buildPartialRepeatedFields(result);
      if (bitField0_ != 0) {
        buildPartial0(result);
      }
      onBuilt();
      return result;
    }

    private void buildPartialRepeatedFields(
        com.google.cloud.aiplatform.v1beta1.DedicatedResources result) {
      if (autoscalingMetricSpecsBuilder_ == null) {
        if (((bitField0_ & 0x00000008) != 0)) {
          autoscalingMetricSpecs_ = java.util.Collections.unmodifiableList(autoscalingMetricSpecs_);
          bitField0_ = (bitField0_ & ~0x00000008);
        }
        result.autoscalingMetricSpecs_ = autoscalingMetricSpecs_;
      } else {
        result.autoscalingMetricSpecs_ = autoscalingMetricSpecsBuilder_.build();
      }
    }

    private void buildPartial0(com.google.cloud.aiplatform.v1beta1.DedicatedResources result) {
      int from_bitField0_ = bitField0_;
      int to_bitField0_ = 0;
      if (((from_bitField0_ & 0x00000001) != 0)) {
        result.machineSpec_ =
            machineSpecBuilder_ == null ? machineSpec_ : machineSpecBuilder_.build();
        to_bitField0_ |= 0x00000001;
      }
      if (((from_bitField0_ & 0x00000002) != 0)) {
        result.minReplicaCount_ = minReplicaCount_;
      }
      if (((from_bitField0_ & 0x00000004) != 0)) {
        result.maxReplicaCount_ = maxReplicaCount_;
      }
      result.bitField0_ |= to_bitField0_;
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.cloud.aiplatform.v1beta1.DedicatedResources) {
        return mergeFrom((com.google.cloud.aiplatform.v1beta1.DedicatedResources) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(com.google.cloud.aiplatform.v1beta1.DedicatedResources other) {
      if (other == com.google.cloud.aiplatform.v1beta1.DedicatedResources.getDefaultInstance())
        return this;
      if (other.hasMachineSpec()) {
        mergeMachineSpec(other.getMachineSpec());
      }
      if (other.getMinReplicaCount() != 0) {
        setMinReplicaCount(other.getMinReplicaCount());
      }
      if (other.getMaxReplicaCount() != 0) {
        setMaxReplicaCount(other.getMaxReplicaCount());
      }
      if (autoscalingMetricSpecsBuilder_ == null) {
        if (!other.autoscalingMetricSpecs_.isEmpty()) {
          if (autoscalingMetricSpecs_.isEmpty()) {
            autoscalingMetricSpecs_ = other.autoscalingMetricSpecs_;
            bitField0_ = (bitField0_ & ~0x00000008);
          } else {
            ensureAutoscalingMetricSpecsIsMutable();
            autoscalingMetricSpecs_.addAll(other.autoscalingMetricSpecs_);
          }
          onChanged();
        }
      } else {
        if (!other.autoscalingMetricSpecs_.isEmpty()) {
          if (autoscalingMetricSpecsBuilder_.isEmpty()) {
            autoscalingMetricSpecsBuilder_.dispose();
            autoscalingMetricSpecsBuilder_ = null;
            autoscalingMetricSpecs_ = other.autoscalingMetricSpecs_;
            bitField0_ = (bitField0_ & ~0x00000008);
            autoscalingMetricSpecsBuilder_ =
                com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders
                    ? getAutoscalingMetricSpecsFieldBuilder()
                    : null;
          } else {
            autoscalingMetricSpecsBuilder_.addAllMessages(other.autoscalingMetricSpecs_);
          }
        }
      }
      this.mergeUnknownFields(other.getUnknownFields());
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 10:
              {
                input.readMessage(getMachineSpecFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000001;
                break;
              } // case 10
            case 16:
              {
                minReplicaCount_ = input.readInt32();
                bitField0_ |= 0x00000002;
                break;
              } // case 16
            case 24:
              {
                maxReplicaCount_ = input.readInt32();
                bitField0_ |= 0x00000004;
                break;
              } // case 24
            case 34:
              {
                com.google.cloud.aiplatform.v1beta1.AutoscalingMetricSpec m =
                    input.readMessage(
                        com.google.cloud.aiplatform.v1beta1.AutoscalingMetricSpec.parser(),
                        extensionRegistry);
                if (autoscalingMetricSpecsBuilder_ == null) {
                  ensureAutoscalingMetricSpecsIsMutable();
                  autoscalingMetricSpecs_.add(m);
                } else {
                  autoscalingMetricSpecsBuilder_.addMessage(m);
                }
                break;
              } // case 34
            default:
              {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
          } // switch (tag)
        } // while (!done)
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.unwrapIOException();
      } finally {
        onChanged();
      } // finally
      return this;
    }

    private int bitField0_;

    private com.google.cloud.aiplatform.v1beta1.MachineSpec machineSpec_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.aiplatform.v1beta1.MachineSpec,
            com.google.cloud.aiplatform.v1beta1.MachineSpec.Builder,
            com.google.cloud.aiplatform.v1beta1.MachineSpecOrBuilder>
        machineSpecBuilder_;
    /**
     *
     *
     * <pre>
     * Required. Immutable. The specification of a single machine used by the
     * prediction.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.MachineSpec machine_spec = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.field_behavior) = IMMUTABLE];
     * </code>
     *
     * @return Whether the machineSpec field is set.
     */
    public boolean hasMachineSpec() {
      return ((bitField0_ & 0x00000001) != 0);
    }
    /**
     *
     *
     * <pre>
     * Required. Immutable. The specification of a single machine used by the
     * prediction.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.MachineSpec machine_spec = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.field_behavior) = IMMUTABLE];
     * </code>
     *
     * @return The machineSpec.
     */
    public com.google.cloud.aiplatform.v1beta1.MachineSpec getMachineSpec() {
      if (machineSpecBuilder_ == null) {
        return machineSpec_ == null
            ? com.google.cloud.aiplatform.v1beta1.MachineSpec.getDefaultInstance()
            : machineSpec_;
      } else {
        return machineSpecBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Required. Immutable. The specification of a single machine used by the
     * prediction.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.MachineSpec machine_spec = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.field_behavior) = IMMUTABLE];
     * </code>
     */
    public Builder setMachineSpec(com.google.cloud.aiplatform.v1beta1.MachineSpec value) {
      if (machineSpecBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        machineSpec_ = value;
      } else {
        machineSpecBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. Immutable. The specification of a single machine used by the
     * prediction.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.MachineSpec machine_spec = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.field_behavior) = IMMUTABLE];
     * </code>
     */
    public Builder setMachineSpec(
        com.google.cloud.aiplatform.v1beta1.MachineSpec.Builder builderForValue) {
      if (machineSpecBuilder_ == null) {
        machineSpec_ = builderForValue.build();
      } else {
        machineSpecBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. Immutable. The specification of a single machine used by the
     * prediction.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.MachineSpec machine_spec = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.field_behavior) = IMMUTABLE];
     * </code>
     */
    public Builder mergeMachineSpec(com.google.cloud.aiplatform.v1beta1.MachineSpec value) {
      if (machineSpecBuilder_ == null) {
        if (((bitField0_ & 0x00000001) != 0)
            && machineSpec_ != null
            && machineSpec_
                != com.google.cloud.aiplatform.v1beta1.MachineSpec.getDefaultInstance()) {
          getMachineSpecBuilder().mergeFrom(value);
        } else {
          machineSpec_ = value;
        }
      } else {
        machineSpecBuilder_.mergeFrom(value);
      }
      if (machineSpec_ != null) {
        bitField0_ |= 0x00000001;
        onChanged();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. Immutable. The specification of a single machine used by the
     * prediction.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.MachineSpec machine_spec = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.field_behavior) = IMMUTABLE];
     * </code>
     */
    public Builder clearMachineSpec() {
      bitField0_ = (bitField0_ & ~0x00000001);
      machineSpec_ = null;
      if (machineSpecBuilder_ != null) {
        machineSpecBuilder_.dispose();
        machineSpecBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. Immutable. The specification of a single machine used by the
     * prediction.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.MachineSpec machine_spec = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.field_behavior) = IMMUTABLE];
     * </code>
     */
    public com.google.cloud.aiplatform.v1beta1.MachineSpec.Builder getMachineSpecBuilder() {
      bitField0_ |= 0x00000001;
      onChanged();
      return getMachineSpecFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Required. Immutable. The specification of a single machine used by the
     * prediction.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.MachineSpec machine_spec = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.field_behavior) = IMMUTABLE];
     * </code>
     */
    public com.google.cloud.aiplatform.v1beta1.MachineSpecOrBuilder getMachineSpecOrBuilder() {
      if (machineSpecBuilder_ != null) {
        return machineSpecBuilder_.getMessageOrBuilder();
      } else {
        return machineSpec_ == null
            ? com.google.cloud.aiplatform.v1beta1.MachineSpec.getDefaultInstance()
            : machineSpec_;
      }
    }
    /**
     *
     *
     * <pre>
     * Required. Immutable. The specification of a single machine used by the
     * prediction.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.MachineSpec machine_spec = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.field_behavior) = IMMUTABLE];
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.aiplatform.v1beta1.MachineSpec,
            com.google.cloud.aiplatform.v1beta1.MachineSpec.Builder,
            com.google.cloud.aiplatform.v1beta1.MachineSpecOrBuilder>
        getMachineSpecFieldBuilder() {
      if (machineSpecBuilder_ == null) {
        machineSpecBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.aiplatform.v1beta1.MachineSpec,
                com.google.cloud.aiplatform.v1beta1.MachineSpec.Builder,
                com.google.cloud.aiplatform.v1beta1.MachineSpecOrBuilder>(
                getMachineSpec(), getParentForChildren(), isClean());
        machineSpec_ = null;
      }
      return machineSpecBuilder_;
    }

    private int minReplicaCount_;
    /**
     *
     *
     * <pre>
     * Required. Immutable. The minimum number of machine replicas this
     * DeployedModel will be always deployed on. This value must be greater than
     * or equal to 1.
     *
     * If traffic against the DeployedModel increases, it may dynamically be
     * deployed onto more replicas, and as traffic decreases, some of these extra
     * replicas may be freed.
     * </pre>
     *
     * <code>
     * int32 min_replica_count = 2 [(.google.api.field_behavior) = REQUIRED, (.google.api.field_behavior) = IMMUTABLE];
     * </code>
     *
     * @return The minReplicaCount.
     */
    @java.lang.Override
    public int getMinReplicaCount() {
      return minReplicaCount_;
    }
    /**
     *
     *
     * <pre>
     * Required. Immutable. The minimum number of machine replicas this
     * DeployedModel will be always deployed on. This value must be greater than
     * or equal to 1.
     *
     * If traffic against the DeployedModel increases, it may dynamically be
     * deployed onto more replicas, and as traffic decreases, some of these extra
     * replicas may be freed.
     * </pre>
     *
     * <code>
     * int32 min_replica_count = 2 [(.google.api.field_behavior) = REQUIRED, (.google.api.field_behavior) = IMMUTABLE];
     * </code>
     *
     * @param value The minReplicaCount to set.
     * @return This builder for chaining.
     */
    public Builder setMinReplicaCount(int value) {

      minReplicaCount_ = value;
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. Immutable. The minimum number of machine replicas this
     * DeployedModel will be always deployed on. This value must be greater than
     * or equal to 1.
     *
     * If traffic against the DeployedModel increases, it may dynamically be
     * deployed onto more replicas, and as traffic decreases, some of these extra
     * replicas may be freed.
     * </pre>
     *
     * <code>
     * int32 min_replica_count = 2 [(.google.api.field_behavior) = REQUIRED, (.google.api.field_behavior) = IMMUTABLE];
     * </code>
     *
     * @return This builder for chaining.
     */
    public Builder clearMinReplicaCount() {
      bitField0_ = (bitField0_ & ~0x00000002);
      minReplicaCount_ = 0;
      onChanged();
      return this;
    }

    private int maxReplicaCount_;
    /**
     *
     *
     * <pre>
     * Immutable. The maximum number of replicas this DeployedModel may be
     * deployed on when the traffic against it increases. If the requested value
     * is too large, the deployment will error, but if deployment succeeds then
     * the ability to scale the model to that many replicas is guaranteed (barring
     * service outages). If traffic against the DeployedModel increases beyond
     * what its replicas at maximum may handle, a portion of the traffic will be
     * dropped. If this value is not provided, will use
     * [min_replica_count][google.cloud.aiplatform.v1beta1.DedicatedResources.min_replica_count]
     * as the default value.
     *
     * The value of this field impacts the charge against Vertex CPU and GPU
     * quotas. Specifically, you will be charged for (max_replica_count *
     * number of cores in the selected machine type) and (max_replica_count *
     * number of GPUs per replica in the selected machine type).
     * </pre>
     *
     * <code>int32 max_replica_count = 3 [(.google.api.field_behavior) = IMMUTABLE];</code>
     *
     * @return The maxReplicaCount.
     */
    @java.lang.Override
    public int getMaxReplicaCount() {
      return maxReplicaCount_;
    }
    /**
     *
     *
     * <pre>
     * Immutable. The maximum number of replicas this DeployedModel may be
     * deployed on when the traffic against it increases. If the requested value
     * is too large, the deployment will error, but if deployment succeeds then
     * the ability to scale the model to that many replicas is guaranteed (barring
     * service outages). If traffic against the DeployedModel increases beyond
     * what its replicas at maximum may handle, a portion of the traffic will be
     * dropped. If this value is not provided, will use
     * [min_replica_count][google.cloud.aiplatform.v1beta1.DedicatedResources.min_replica_count]
     * as the default value.
     *
     * The value of this field impacts the charge against Vertex CPU and GPU
     * quotas. Specifically, you will be charged for (max_replica_count *
     * number of cores in the selected machine type) and (max_replica_count *
     * number of GPUs per replica in the selected machine type).
     * </pre>
     *
     * <code>int32 max_replica_count = 3 [(.google.api.field_behavior) = IMMUTABLE];</code>
     *
     * @param value The maxReplicaCount to set.
     * @return This builder for chaining.
     */
    public Builder setMaxReplicaCount(int value) {

      maxReplicaCount_ = value;
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Immutable. The maximum number of replicas this DeployedModel may be
     * deployed on when the traffic against it increases. If the requested value
     * is too large, the deployment will error, but if deployment succeeds then
     * the ability to scale the model to that many replicas is guaranteed (barring
     * service outages). If traffic against the DeployedModel increases beyond
     * what its replicas at maximum may handle, a portion of the traffic will be
     * dropped. If this value is not provided, will use
     * [min_replica_count][google.cloud.aiplatform.v1beta1.DedicatedResources.min_replica_count]
     * as the default value.
     *
     * The value of this field impacts the charge against Vertex CPU and GPU
     * quotas. Specifically, you will be charged for (max_replica_count *
     * number of cores in the selected machine type) and (max_replica_count *
     * number of GPUs per replica in the selected machine type).
     * </pre>
     *
     * <code>int32 max_replica_count = 3 [(.google.api.field_behavior) = IMMUTABLE];</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearMaxReplicaCount() {
      bitField0_ = (bitField0_ & ~0x00000004);
      maxReplicaCount_ = 0;
      onChanged();
      return this;
    }

    private java.util.List<com.google.cloud.aiplatform.v1beta1.AutoscalingMetricSpec>
        autoscalingMetricSpecs_ = java.util.Collections.emptyList();

    private void ensureAutoscalingMetricSpecsIsMutable() {
      if (!((bitField0_ & 0x00000008) != 0)) {
        autoscalingMetricSpecs_ =
            new java.util.ArrayList<com.google.cloud.aiplatform.v1beta1.AutoscalingMetricSpec>(
                autoscalingMetricSpecs_);
        bitField0_ |= 0x00000008;
      }
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.cloud.aiplatform.v1beta1.AutoscalingMetricSpec,
            com.google.cloud.aiplatform.v1beta1.AutoscalingMetricSpec.Builder,
            com.google.cloud.aiplatform.v1beta1.AutoscalingMetricSpecOrBuilder>
        autoscalingMetricSpecsBuilder_;

    /**
     *
     *
     * <pre>
     * Immutable. The metric specifications that overrides a resource
     * utilization metric (CPU utilization, accelerator's duty cycle, and so on)
     * target value (default to 60 if not set). At most one entry is allowed per
     * metric.
     *
     * If
     * [machine_spec.accelerator_count][google.cloud.aiplatform.v1beta1.MachineSpec.accelerator_count]
     * is above 0, the autoscaling will be based on both CPU utilization and
     * accelerator's duty cycle metrics and scale up when either metrics exceeds
     * its target value while scale down if both metrics are under their target
     * value. The default target value is 60 for both metrics.
     *
     * If
     * [machine_spec.accelerator_count][google.cloud.aiplatform.v1beta1.MachineSpec.accelerator_count]
     * is 0, the autoscaling will be based on CPU utilization metric only with
     * default target value 60 if not explicitly set.
     *
     * For example, in the case of Online Prediction, if you want to override
     * target CPU utilization to 80, you should set
     * [autoscaling_metric_specs.metric_name][google.cloud.aiplatform.v1beta1.AutoscalingMetricSpec.metric_name]
     * to `aiplatform.googleapis.com/prediction/online/cpu/utilization` and
     * [autoscaling_metric_specs.target][google.cloud.aiplatform.v1beta1.AutoscalingMetricSpec.target]
     * to `80`.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.aiplatform.v1beta1.AutoscalingMetricSpec autoscaling_metric_specs = 4 [(.google.api.field_behavior) = IMMUTABLE];
     * </code>
     */
    public java.util.List<com.google.cloud.aiplatform.v1beta1.AutoscalingMetricSpec>
        getAutoscalingMetricSpecsList() {
      if (autoscalingMetricSpecsBuilder_ == null) {
        return java.util.Collections.unmodifiableList(autoscalingMetricSpecs_);
      } else {
        return autoscalingMetricSpecsBuilder_.getMessageList();
      }
    }
    /**
     *
     *
     * <pre>
     * Immutable. The metric specifications that overrides a resource
     * utilization metric (CPU utilization, accelerator's duty cycle, and so on)
     * target value (default to 60 if not set). At most one entry is allowed per
     * metric.
     *
     * If
     * [machine_spec.accelerator_count][google.cloud.aiplatform.v1beta1.MachineSpec.accelerator_count]
     * is above 0, the autoscaling will be based on both CPU utilization and
     * accelerator's duty cycle metrics and scale up when either metrics exceeds
     * its target value while scale down if both metrics are under their target
     * value. The default target value is 60 for both metrics.
     *
     * If
     * [machine_spec.accelerator_count][google.cloud.aiplatform.v1beta1.MachineSpec.accelerator_count]
     * is 0, the autoscaling will be based on CPU utilization metric only with
     * default target value 60 if not explicitly set.
     *
     * For example, in the case of Online Prediction, if you want to override
     * target CPU utilization to 80, you should set
     * [autoscaling_metric_specs.metric_name][google.cloud.aiplatform.v1beta1.AutoscalingMetricSpec.metric_name]
     * to `aiplatform.googleapis.com/prediction/online/cpu/utilization` and
     * [autoscaling_metric_specs.target][google.cloud.aiplatform.v1beta1.AutoscalingMetricSpec.target]
     * to `80`.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.aiplatform.v1beta1.AutoscalingMetricSpec autoscaling_metric_specs = 4 [(.google.api.field_behavior) = IMMUTABLE];
     * </code>
     */
    public int getAutoscalingMetricSpecsCount() {
      if (autoscalingMetricSpecsBuilder_ == null) {
        return autoscalingMetricSpecs_.size();
      } else {
        return autoscalingMetricSpecsBuilder_.getCount();
      }
    }
    /**
     *
     *
     * <pre>
     * Immutable. The metric specifications that overrides a resource
     * utilization metric (CPU utilization, accelerator's duty cycle, and so on)
     * target value (default to 60 if not set). At most one entry is allowed per
     * metric.
     *
     * If
     * [machine_spec.accelerator_count][google.cloud.aiplatform.v1beta1.MachineSpec.accelerator_count]
     * is above 0, the autoscaling will be based on both CPU utilization and
     * accelerator's duty cycle metrics and scale up when either metrics exceeds
     * its target value while scale down if both metrics are under their target
     * value. The default target value is 60 for both metrics.
     *
     * If
     * [machine_spec.accelerator_count][google.cloud.aiplatform.v1beta1.MachineSpec.accelerator_count]
     * is 0, the autoscaling will be based on CPU utilization metric only with
     * default target value 60 if not explicitly set.
     *
     * For example, in the case of Online Prediction, if you want to override
     * target CPU utilization to 80, you should set
     * [autoscaling_metric_specs.metric_name][google.cloud.aiplatform.v1beta1.AutoscalingMetricSpec.metric_name]
     * to `aiplatform.googleapis.com/prediction/online/cpu/utilization` and
     * [autoscaling_metric_specs.target][google.cloud.aiplatform.v1beta1.AutoscalingMetricSpec.target]
     * to `80`.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.aiplatform.v1beta1.AutoscalingMetricSpec autoscaling_metric_specs = 4 [(.google.api.field_behavior) = IMMUTABLE];
     * </code>
     */
    public com.google.cloud.aiplatform.v1beta1.AutoscalingMetricSpec getAutoscalingMetricSpecs(
        int index) {
      if (autoscalingMetricSpecsBuilder_ == null) {
        return autoscalingMetricSpecs_.get(index);
      } else {
        return autoscalingMetricSpecsBuilder_.getMessage(index);
      }
    }
    /**
     *
     *
     * <pre>
     * Immutable. The metric specifications that overrides a resource
     * utilization metric (CPU utilization, accelerator's duty cycle, and so on)
     * target value (default to 60 if not set). At most one entry is allowed per
     * metric.
     *
     * If
     * [machine_spec.accelerator_count][google.cloud.aiplatform.v1beta1.MachineSpec.accelerator_count]
     * is above 0, the autoscaling will be based on both CPU utilization and
     * accelerator's duty cycle metrics and scale up when either metrics exceeds
     * its target value while scale down if both metrics are under their target
     * value. The default target value is 60 for both metrics.
     *
     * If
     * [machine_spec.accelerator_count][google.cloud.aiplatform.v1beta1.MachineSpec.accelerator_count]
     * is 0, the autoscaling will be based on CPU utilization metric only with
     * default target value 60 if not explicitly set.
     *
     * For example, in the case of Online Prediction, if you want to override
     * target CPU utilization to 80, you should set
     * [autoscaling_metric_specs.metric_name][google.cloud.aiplatform.v1beta1.AutoscalingMetricSpec.metric_name]
     * to `aiplatform.googleapis.com/prediction/online/cpu/utilization` and
     * [autoscaling_metric_specs.target][google.cloud.aiplatform.v1beta1.AutoscalingMetricSpec.target]
     * to `80`.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.aiplatform.v1beta1.AutoscalingMetricSpec autoscaling_metric_specs = 4 [(.google.api.field_behavior) = IMMUTABLE];
     * </code>
     */
    public Builder setAutoscalingMetricSpecs(
        int index, com.google.cloud.aiplatform.v1beta1.AutoscalingMetricSpec value) {
      if (autoscalingMetricSpecsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureAutoscalingMetricSpecsIsMutable();
        autoscalingMetricSpecs_.set(index, value);
        onChanged();
      } else {
        autoscalingMetricSpecsBuilder_.setMessage(index, value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Immutable. The metric specifications that overrides a resource
     * utilization metric (CPU utilization, accelerator's duty cycle, and so on)
     * target value (default to 60 if not set). At most one entry is allowed per
     * metric.
     *
     * If
     * [machine_spec.accelerator_count][google.cloud.aiplatform.v1beta1.MachineSpec.accelerator_count]
     * is above 0, the autoscaling will be based on both CPU utilization and
     * accelerator's duty cycle metrics and scale up when either metrics exceeds
     * its target value while scale down if both metrics are under their target
     * value. The default target value is 60 for both metrics.
     *
     * If
     * [machine_spec.accelerator_count][google.cloud.aiplatform.v1beta1.MachineSpec.accelerator_count]
     * is 0, the autoscaling will be based on CPU utilization metric only with
     * default target value 60 if not explicitly set.
     *
     * For example, in the case of Online Prediction, if you want to override
     * target CPU utilization to 80, you should set
     * [autoscaling_metric_specs.metric_name][google.cloud.aiplatform.v1beta1.AutoscalingMetricSpec.metric_name]
     * to `aiplatform.googleapis.com/prediction/online/cpu/utilization` and
     * [autoscaling_metric_specs.target][google.cloud.aiplatform.v1beta1.AutoscalingMetricSpec.target]
     * to `80`.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.aiplatform.v1beta1.AutoscalingMetricSpec autoscaling_metric_specs = 4 [(.google.api.field_behavior) = IMMUTABLE];
     * </code>
     */
    public Builder setAutoscalingMetricSpecs(
        int index,
        com.google.cloud.aiplatform.v1beta1.AutoscalingMetricSpec.Builder builderForValue) {
      if (autoscalingMetricSpecsBuilder_ == null) {
        ensureAutoscalingMetricSpecsIsMutable();
        autoscalingMetricSpecs_.set(index, builderForValue.build());
        onChanged();
      } else {
        autoscalingMetricSpecsBuilder_.setMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Immutable. The metric specifications that overrides a resource
     * utilization metric (CPU utilization, accelerator's duty cycle, and so on)
     * target value (default to 60 if not set). At most one entry is allowed per
     * metric.
     *
     * If
     * [machine_spec.accelerator_count][google.cloud.aiplatform.v1beta1.MachineSpec.accelerator_count]
     * is above 0, the autoscaling will be based on both CPU utilization and
     * accelerator's duty cycle metrics and scale up when either metrics exceeds
     * its target value while scale down if both metrics are under their target
     * value. The default target value is 60 for both metrics.
     *
     * If
     * [machine_spec.accelerator_count][google.cloud.aiplatform.v1beta1.MachineSpec.accelerator_count]
     * is 0, the autoscaling will be based on CPU utilization metric only with
     * default target value 60 if not explicitly set.
     *
     * For example, in the case of Online Prediction, if you want to override
     * target CPU utilization to 80, you should set
     * [autoscaling_metric_specs.metric_name][google.cloud.aiplatform.v1beta1.AutoscalingMetricSpec.metric_name]
     * to `aiplatform.googleapis.com/prediction/online/cpu/utilization` and
     * [autoscaling_metric_specs.target][google.cloud.aiplatform.v1beta1.AutoscalingMetricSpec.target]
     * to `80`.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.aiplatform.v1beta1.AutoscalingMetricSpec autoscaling_metric_specs = 4 [(.google.api.field_behavior) = IMMUTABLE];
     * </code>
     */
    public Builder addAutoscalingMetricSpecs(
        com.google.cloud.aiplatform.v1beta1.AutoscalingMetricSpec value) {
      if (autoscalingMetricSpecsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureAutoscalingMetricSpecsIsMutable();
        autoscalingMetricSpecs_.add(value);
        onChanged();
      } else {
        autoscalingMetricSpecsBuilder_.addMessage(value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Immutable. The metric specifications that overrides a resource
     * utilization metric (CPU utilization, accelerator's duty cycle, and so on)
     * target value (default to 60 if not set). At most one entry is allowed per
     * metric.
     *
     * If
     * [machine_spec.accelerator_count][google.cloud.aiplatform.v1beta1.MachineSpec.accelerator_count]
     * is above 0, the autoscaling will be based on both CPU utilization and
     * accelerator's duty cycle metrics and scale up when either metrics exceeds
     * its target value while scale down if both metrics are under their target
     * value. The default target value is 60 for both metrics.
     *
     * If
     * [machine_spec.accelerator_count][google.cloud.aiplatform.v1beta1.MachineSpec.accelerator_count]
     * is 0, the autoscaling will be based on CPU utilization metric only with
     * default target value 60 if not explicitly set.
     *
     * For example, in the case of Online Prediction, if you want to override
     * target CPU utilization to 80, you should set
     * [autoscaling_metric_specs.metric_name][google.cloud.aiplatform.v1beta1.AutoscalingMetricSpec.metric_name]
     * to `aiplatform.googleapis.com/prediction/online/cpu/utilization` and
     * [autoscaling_metric_specs.target][google.cloud.aiplatform.v1beta1.AutoscalingMetricSpec.target]
     * to `80`.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.aiplatform.v1beta1.AutoscalingMetricSpec autoscaling_metric_specs = 4 [(.google.api.field_behavior) = IMMUTABLE];
     * </code>
     */
    public Builder addAutoscalingMetricSpecs(
        int index, com.google.cloud.aiplatform.v1beta1.AutoscalingMetricSpec value) {
      if (autoscalingMetricSpecsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureAutoscalingMetricSpecsIsMutable();
        autoscalingMetricSpecs_.add(index, value);
        onChanged();
      } else {
        autoscalingMetricSpecsBuilder_.addMessage(index, value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Immutable. The metric specifications that overrides a resource
     * utilization metric (CPU utilization, accelerator's duty cycle, and so on)
     * target value (default to 60 if not set). At most one entry is allowed per
     * metric.
     *
     * If
     * [machine_spec.accelerator_count][google.cloud.aiplatform.v1beta1.MachineSpec.accelerator_count]
     * is above 0, the autoscaling will be based on both CPU utilization and
     * accelerator's duty cycle metrics and scale up when either metrics exceeds
     * its target value while scale down if both metrics are under their target
     * value. The default target value is 60 for both metrics.
     *
     * If
     * [machine_spec.accelerator_count][google.cloud.aiplatform.v1beta1.MachineSpec.accelerator_count]
     * is 0, the autoscaling will be based on CPU utilization metric only with
     * default target value 60 if not explicitly set.
     *
     * For example, in the case of Online Prediction, if you want to override
     * target CPU utilization to 80, you should set
     * [autoscaling_metric_specs.metric_name][google.cloud.aiplatform.v1beta1.AutoscalingMetricSpec.metric_name]
     * to `aiplatform.googleapis.com/prediction/online/cpu/utilization` and
     * [autoscaling_metric_specs.target][google.cloud.aiplatform.v1beta1.AutoscalingMetricSpec.target]
     * to `80`.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.aiplatform.v1beta1.AutoscalingMetricSpec autoscaling_metric_specs = 4 [(.google.api.field_behavior) = IMMUTABLE];
     * </code>
     */
    public Builder addAutoscalingMetricSpecs(
        com.google.cloud.aiplatform.v1beta1.AutoscalingMetricSpec.Builder builderForValue) {
      if (autoscalingMetricSpecsBuilder_ == null) {
        ensureAutoscalingMetricSpecsIsMutable();
        autoscalingMetricSpecs_.add(builderForValue.build());
        onChanged();
      } else {
        autoscalingMetricSpecsBuilder_.addMessage(builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Immutable. The metric specifications that overrides a resource
     * utilization metric (CPU utilization, accelerator's duty cycle, and so on)
     * target value (default to 60 if not set). At most one entry is allowed per
     * metric.
     *
     * If
     * [machine_spec.accelerator_count][google.cloud.aiplatform.v1beta1.MachineSpec.accelerator_count]
     * is above 0, the autoscaling will be based on both CPU utilization and
     * accelerator's duty cycle metrics and scale up when either metrics exceeds
     * its target value while scale down if both metrics are under their target
     * value. The default target value is 60 for both metrics.
     *
     * If
     * [machine_spec.accelerator_count][google.cloud.aiplatform.v1beta1.MachineSpec.accelerator_count]
     * is 0, the autoscaling will be based on CPU utilization metric only with
     * default target value 60 if not explicitly set.
     *
     * For example, in the case of Online Prediction, if you want to override
     * target CPU utilization to 80, you should set
     * [autoscaling_metric_specs.metric_name][google.cloud.aiplatform.v1beta1.AutoscalingMetricSpec.metric_name]
     * to `aiplatform.googleapis.com/prediction/online/cpu/utilization` and
     * [autoscaling_metric_specs.target][google.cloud.aiplatform.v1beta1.AutoscalingMetricSpec.target]
     * to `80`.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.aiplatform.v1beta1.AutoscalingMetricSpec autoscaling_metric_specs = 4 [(.google.api.field_behavior) = IMMUTABLE];
     * </code>
     */
    public Builder addAutoscalingMetricSpecs(
        int index,
        com.google.cloud.aiplatform.v1beta1.AutoscalingMetricSpec.Builder builderForValue) {
      if (autoscalingMetricSpecsBuilder_ == null) {
        ensureAutoscalingMetricSpecsIsMutable();
        autoscalingMetricSpecs_.add(index, builderForValue.build());
        onChanged();
      } else {
        autoscalingMetricSpecsBuilder_.addMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Immutable. The metric specifications that overrides a resource
     * utilization metric (CPU utilization, accelerator's duty cycle, and so on)
     * target value (default to 60 if not set). At most one entry is allowed per
     * metric.
     *
     * If
     * [machine_spec.accelerator_count][google.cloud.aiplatform.v1beta1.MachineSpec.accelerator_count]
     * is above 0, the autoscaling will be based on both CPU utilization and
     * accelerator's duty cycle metrics and scale up when either metrics exceeds
     * its target value while scale down if both metrics are under their target
     * value. The default target value is 60 for both metrics.
     *
     * If
     * [machine_spec.accelerator_count][google.cloud.aiplatform.v1beta1.MachineSpec.accelerator_count]
     * is 0, the autoscaling will be based on CPU utilization metric only with
     * default target value 60 if not explicitly set.
     *
     * For example, in the case of Online Prediction, if you want to override
     * target CPU utilization to 80, you should set
     * [autoscaling_metric_specs.metric_name][google.cloud.aiplatform.v1beta1.AutoscalingMetricSpec.metric_name]
     * to `aiplatform.googleapis.com/prediction/online/cpu/utilization` and
     * [autoscaling_metric_specs.target][google.cloud.aiplatform.v1beta1.AutoscalingMetricSpec.target]
     * to `80`.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.aiplatform.v1beta1.AutoscalingMetricSpec autoscaling_metric_specs = 4 [(.google.api.field_behavior) = IMMUTABLE];
     * </code>
     */
    public Builder addAllAutoscalingMetricSpecs(
        java.lang.Iterable<? extends com.google.cloud.aiplatform.v1beta1.AutoscalingMetricSpec>
            values) {
      if (autoscalingMetricSpecsBuilder_ == null) {
        ensureAutoscalingMetricSpecsIsMutable();
        com.google.protobuf.AbstractMessageLite.Builder.addAll(values, autoscalingMetricSpecs_);
        onChanged();
      } else {
        autoscalingMetricSpecsBuilder_.addAllMessages(values);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Immutable. The metric specifications that overrides a resource
     * utilization metric (CPU utilization, accelerator's duty cycle, and so on)
     * target value (default to 60 if not set). At most one entry is allowed per
     * metric.
     *
     * If
     * [machine_spec.accelerator_count][google.cloud.aiplatform.v1beta1.MachineSpec.accelerator_count]
     * is above 0, the autoscaling will be based on both CPU utilization and
     * accelerator's duty cycle metrics and scale up when either metrics exceeds
     * its target value while scale down if both metrics are under their target
     * value. The default target value is 60 for both metrics.
     *
     * If
     * [machine_spec.accelerator_count][google.cloud.aiplatform.v1beta1.MachineSpec.accelerator_count]
     * is 0, the autoscaling will be based on CPU utilization metric only with
     * default target value 60 if not explicitly set.
     *
     * For example, in the case of Online Prediction, if you want to override
     * target CPU utilization to 80, you should set
     * [autoscaling_metric_specs.metric_name][google.cloud.aiplatform.v1beta1.AutoscalingMetricSpec.metric_name]
     * to `aiplatform.googleapis.com/prediction/online/cpu/utilization` and
     * [autoscaling_metric_specs.target][google.cloud.aiplatform.v1beta1.AutoscalingMetricSpec.target]
     * to `80`.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.aiplatform.v1beta1.AutoscalingMetricSpec autoscaling_metric_specs = 4 [(.google.api.field_behavior) = IMMUTABLE];
     * </code>
     */
    public Builder clearAutoscalingMetricSpecs() {
      if (autoscalingMetricSpecsBuilder_ == null) {
        autoscalingMetricSpecs_ = java.util.Collections.emptyList();
        bitField0_ = (bitField0_ & ~0x00000008);
        onChanged();
      } else {
        autoscalingMetricSpecsBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Immutable. The metric specifications that overrides a resource
     * utilization metric (CPU utilization, accelerator's duty cycle, and so on)
     * target value (default to 60 if not set). At most one entry is allowed per
     * metric.
     *
     * If
     * [machine_spec.accelerator_count][google.cloud.aiplatform.v1beta1.MachineSpec.accelerator_count]
     * is above 0, the autoscaling will be based on both CPU utilization and
     * accelerator's duty cycle metrics and scale up when either metrics exceeds
     * its target value while scale down if both metrics are under their target
     * value. The default target value is 60 for both metrics.
     *
     * If
     * [machine_spec.accelerator_count][google.cloud.aiplatform.v1beta1.MachineSpec.accelerator_count]
     * is 0, the autoscaling will be based on CPU utilization metric only with
     * default target value 60 if not explicitly set.
     *
     * For example, in the case of Online Prediction, if you want to override
     * target CPU utilization to 80, you should set
     * [autoscaling_metric_specs.metric_name][google.cloud.aiplatform.v1beta1.AutoscalingMetricSpec.metric_name]
     * to `aiplatform.googleapis.com/prediction/online/cpu/utilization` and
     * [autoscaling_metric_specs.target][google.cloud.aiplatform.v1beta1.AutoscalingMetricSpec.target]
     * to `80`.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.aiplatform.v1beta1.AutoscalingMetricSpec autoscaling_metric_specs = 4 [(.google.api.field_behavior) = IMMUTABLE];
     * </code>
     */
    public Builder removeAutoscalingMetricSpecs(int index) {
      if (autoscalingMetricSpecsBuilder_ == null) {
        ensureAutoscalingMetricSpecsIsMutable();
        autoscalingMetricSpecs_.remove(index);
        onChanged();
      } else {
        autoscalingMetricSpecsBuilder_.remove(index);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Immutable. The metric specifications that overrides a resource
     * utilization metric (CPU utilization, accelerator's duty cycle, and so on)
     * target value (default to 60 if not set). At most one entry is allowed per
     * metric.
     *
     * If
     * [machine_spec.accelerator_count][google.cloud.aiplatform.v1beta1.MachineSpec.accelerator_count]
     * is above 0, the autoscaling will be based on both CPU utilization and
     * accelerator's duty cycle metrics and scale up when either metrics exceeds
     * its target value while scale down if both metrics are under their target
     * value. The default target value is 60 for both metrics.
     *
     * If
     * [machine_spec.accelerator_count][google.cloud.aiplatform.v1beta1.MachineSpec.accelerator_count]
     * is 0, the autoscaling will be based on CPU utilization metric only with
     * default target value 60 if not explicitly set.
     *
     * For example, in the case of Online Prediction, if you want to override
     * target CPU utilization to 80, you should set
     * [autoscaling_metric_specs.metric_name][google.cloud.aiplatform.v1beta1.AutoscalingMetricSpec.metric_name]
     * to `aiplatform.googleapis.com/prediction/online/cpu/utilization` and
     * [autoscaling_metric_specs.target][google.cloud.aiplatform.v1beta1.AutoscalingMetricSpec.target]
     * to `80`.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.aiplatform.v1beta1.AutoscalingMetricSpec autoscaling_metric_specs = 4 [(.google.api.field_behavior) = IMMUTABLE];
     * </code>
     */
    public com.google.cloud.aiplatform.v1beta1.AutoscalingMetricSpec.Builder
        getAutoscalingMetricSpecsBuilder(int index) {
      return getAutoscalingMetricSpecsFieldBuilder().getBuilder(index);
    }
    /**
     *
     *
     * <pre>
     * Immutable. The metric specifications that overrides a resource
     * utilization metric (CPU utilization, accelerator's duty cycle, and so on)
     * target value (default to 60 if not set). At most one entry is allowed per
     * metric.
     *
     * If
     * [machine_spec.accelerator_count][google.cloud.aiplatform.v1beta1.MachineSpec.accelerator_count]
     * is above 0, the autoscaling will be based on both CPU utilization and
     * accelerator's duty cycle metrics and scale up when either metrics exceeds
     * its target value while scale down if both metrics are under their target
     * value. The default target value is 60 for both metrics.
     *
     * If
     * [machine_spec.accelerator_count][google.cloud.aiplatform.v1beta1.MachineSpec.accelerator_count]
     * is 0, the autoscaling will be based on CPU utilization metric only with
     * default target value 60 if not explicitly set.
     *
     * For example, in the case of Online Prediction, if you want to override
     * target CPU utilization to 80, you should set
     * [autoscaling_metric_specs.metric_name][google.cloud.aiplatform.v1beta1.AutoscalingMetricSpec.metric_name]
     * to `aiplatform.googleapis.com/prediction/online/cpu/utilization` and
     * [autoscaling_metric_specs.target][google.cloud.aiplatform.v1beta1.AutoscalingMetricSpec.target]
     * to `80`.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.aiplatform.v1beta1.AutoscalingMetricSpec autoscaling_metric_specs = 4 [(.google.api.field_behavior) = IMMUTABLE];
     * </code>
     */
    public com.google.cloud.aiplatform.v1beta1.AutoscalingMetricSpecOrBuilder
        getAutoscalingMetricSpecsOrBuilder(int index) {
      if (autoscalingMetricSpecsBuilder_ == null) {
        return autoscalingMetricSpecs_.get(index);
      } else {
        return autoscalingMetricSpecsBuilder_.getMessageOrBuilder(index);
      }
    }
    /**
     *
     *
     * <pre>
     * Immutable. The metric specifications that overrides a resource
     * utilization metric (CPU utilization, accelerator's duty cycle, and so on)
     * target value (default to 60 if not set). At most one entry is allowed per
     * metric.
     *
     * If
     * [machine_spec.accelerator_count][google.cloud.aiplatform.v1beta1.MachineSpec.accelerator_count]
     * is above 0, the autoscaling will be based on both CPU utilization and
     * accelerator's duty cycle metrics and scale up when either metrics exceeds
     * its target value while scale down if both metrics are under their target
     * value. The default target value is 60 for both metrics.
     *
     * If
     * [machine_spec.accelerator_count][google.cloud.aiplatform.v1beta1.MachineSpec.accelerator_count]
     * is 0, the autoscaling will be based on CPU utilization metric only with
     * default target value 60 if not explicitly set.
     *
     * For example, in the case of Online Prediction, if you want to override
     * target CPU utilization to 80, you should set
     * [autoscaling_metric_specs.metric_name][google.cloud.aiplatform.v1beta1.AutoscalingMetricSpec.metric_name]
     * to `aiplatform.googleapis.com/prediction/online/cpu/utilization` and
     * [autoscaling_metric_specs.target][google.cloud.aiplatform.v1beta1.AutoscalingMetricSpec.target]
     * to `80`.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.aiplatform.v1beta1.AutoscalingMetricSpec autoscaling_metric_specs = 4 [(.google.api.field_behavior) = IMMUTABLE];
     * </code>
     */
    public java.util.List<
            ? extends com.google.cloud.aiplatform.v1beta1.AutoscalingMetricSpecOrBuilder>
        getAutoscalingMetricSpecsOrBuilderList() {
      if (autoscalingMetricSpecsBuilder_ != null) {
        return autoscalingMetricSpecsBuilder_.getMessageOrBuilderList();
      } else {
        return java.util.Collections.unmodifiableList(autoscalingMetricSpecs_);
      }
    }
    /**
     *
     *
     * <pre>
     * Immutable. The metric specifications that overrides a resource
     * utilization metric (CPU utilization, accelerator's duty cycle, and so on)
     * target value (default to 60 if not set). At most one entry is allowed per
     * metric.
     *
     * If
     * [machine_spec.accelerator_count][google.cloud.aiplatform.v1beta1.MachineSpec.accelerator_count]
     * is above 0, the autoscaling will be based on both CPU utilization and
     * accelerator's duty cycle metrics and scale up when either metrics exceeds
     * its target value while scale down if both metrics are under their target
     * value. The default target value is 60 for both metrics.
     *
     * If
     * [machine_spec.accelerator_count][google.cloud.aiplatform.v1beta1.MachineSpec.accelerator_count]
     * is 0, the autoscaling will be based on CPU utilization metric only with
     * default target value 60 if not explicitly set.
     *
     * For example, in the case of Online Prediction, if you want to override
     * target CPU utilization to 80, you should set
     * [autoscaling_metric_specs.metric_name][google.cloud.aiplatform.v1beta1.AutoscalingMetricSpec.metric_name]
     * to `aiplatform.googleapis.com/prediction/online/cpu/utilization` and
     * [autoscaling_metric_specs.target][google.cloud.aiplatform.v1beta1.AutoscalingMetricSpec.target]
     * to `80`.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.aiplatform.v1beta1.AutoscalingMetricSpec autoscaling_metric_specs = 4 [(.google.api.field_behavior) = IMMUTABLE];
     * </code>
     */
    public com.google.cloud.aiplatform.v1beta1.AutoscalingMetricSpec.Builder
        addAutoscalingMetricSpecsBuilder() {
      return getAutoscalingMetricSpecsFieldBuilder()
          .addBuilder(
              com.google.cloud.aiplatform.v1beta1.AutoscalingMetricSpec.getDefaultInstance());
    }
    /**
     *
     *
     * <pre>
     * Immutable. The metric specifications that overrides a resource
     * utilization metric (CPU utilization, accelerator's duty cycle, and so on)
     * target value (default to 60 if not set). At most one entry is allowed per
     * metric.
     *
     * If
     * [machine_spec.accelerator_count][google.cloud.aiplatform.v1beta1.MachineSpec.accelerator_count]
     * is above 0, the autoscaling will be based on both CPU utilization and
     * accelerator's duty cycle metrics and scale up when either metrics exceeds
     * its target value while scale down if both metrics are under their target
     * value. The default target value is 60 for both metrics.
     *
     * If
     * [machine_spec.accelerator_count][google.cloud.aiplatform.v1beta1.MachineSpec.accelerator_count]
     * is 0, the autoscaling will be based on CPU utilization metric only with
     * default target value 60 if not explicitly set.
     *
     * For example, in the case of Online Prediction, if you want to override
     * target CPU utilization to 80, you should set
     * [autoscaling_metric_specs.metric_name][google.cloud.aiplatform.v1beta1.AutoscalingMetricSpec.metric_name]
     * to `aiplatform.googleapis.com/prediction/online/cpu/utilization` and
     * [autoscaling_metric_specs.target][google.cloud.aiplatform.v1beta1.AutoscalingMetricSpec.target]
     * to `80`.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.aiplatform.v1beta1.AutoscalingMetricSpec autoscaling_metric_specs = 4 [(.google.api.field_behavior) = IMMUTABLE];
     * </code>
     */
    public com.google.cloud.aiplatform.v1beta1.AutoscalingMetricSpec.Builder
        addAutoscalingMetricSpecsBuilder(int index) {
      return getAutoscalingMetricSpecsFieldBuilder()
          .addBuilder(
              index,
              com.google.cloud.aiplatform.v1beta1.AutoscalingMetricSpec.getDefaultInstance());
    }
    /**
     *
     *
     * <pre>
     * Immutable. The metric specifications that overrides a resource
     * utilization metric (CPU utilization, accelerator's duty cycle, and so on)
     * target value (default to 60 if not set). At most one entry is allowed per
     * metric.
     *
     * If
     * [machine_spec.accelerator_count][google.cloud.aiplatform.v1beta1.MachineSpec.accelerator_count]
     * is above 0, the autoscaling will be based on both CPU utilization and
     * accelerator's duty cycle metrics and scale up when either metrics exceeds
     * its target value while scale down if both metrics are under their target
     * value. The default target value is 60 for both metrics.
     *
     * If
     * [machine_spec.accelerator_count][google.cloud.aiplatform.v1beta1.MachineSpec.accelerator_count]
     * is 0, the autoscaling will be based on CPU utilization metric only with
     * default target value 60 if not explicitly set.
     *
     * For example, in the case of Online Prediction, if you want to override
     * target CPU utilization to 80, you should set
     * [autoscaling_metric_specs.metric_name][google.cloud.aiplatform.v1beta1.AutoscalingMetricSpec.metric_name]
     * to `aiplatform.googleapis.com/prediction/online/cpu/utilization` and
     * [autoscaling_metric_specs.target][google.cloud.aiplatform.v1beta1.AutoscalingMetricSpec.target]
     * to `80`.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.aiplatform.v1beta1.AutoscalingMetricSpec autoscaling_metric_specs = 4 [(.google.api.field_behavior) = IMMUTABLE];
     * </code>
     */
    public java.util.List<com.google.cloud.aiplatform.v1beta1.AutoscalingMetricSpec.Builder>
        getAutoscalingMetricSpecsBuilderList() {
      return getAutoscalingMetricSpecsFieldBuilder().getBuilderList();
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.cloud.aiplatform.v1beta1.AutoscalingMetricSpec,
            com.google.cloud.aiplatform.v1beta1.AutoscalingMetricSpec.Builder,
            com.google.cloud.aiplatform.v1beta1.AutoscalingMetricSpecOrBuilder>
        getAutoscalingMetricSpecsFieldBuilder() {
      if (autoscalingMetricSpecsBuilder_ == null) {
        autoscalingMetricSpecsBuilder_ =
            new com.google.protobuf.RepeatedFieldBuilderV3<
                com.google.cloud.aiplatform.v1beta1.AutoscalingMetricSpec,
                com.google.cloud.aiplatform.v1beta1.AutoscalingMetricSpec.Builder,
                com.google.cloud.aiplatform.v1beta1.AutoscalingMetricSpecOrBuilder>(
                autoscalingMetricSpecs_,
                ((bitField0_ & 0x00000008) != 0),
                getParentForChildren(),
                isClean());
        autoscalingMetricSpecs_ = null;
      }
      return autoscalingMetricSpecsBuilder_;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.cloud.aiplatform.v1beta1.DedicatedResources)
  }

  // @@protoc_insertion_point(class_scope:google.cloud.aiplatform.v1beta1.DedicatedResources)
  private static final com.google.cloud.aiplatform.v1beta1.DedicatedResources DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.cloud.aiplatform.v1beta1.DedicatedResources();
  }

  public static com.google.cloud.aiplatform.v1beta1.DedicatedResources getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<DedicatedResources> PARSER =
      new com.google.protobuf.AbstractParser<DedicatedResources>() {
        @java.lang.Override
        public DedicatedResources parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          Builder builder = newBuilder();
          try {
            builder.mergeFrom(input, extensionRegistry);
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.setUnfinishedMessage(builder.buildPartial());
          } catch (com.google.protobuf.UninitializedMessageException e) {
            throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
          } catch (java.io.IOException e) {
            throw new com.google.protobuf.InvalidProtocolBufferException(e)
                .setUnfinishedMessage(builder.buildPartial());
          }
          return builder.buildPartial();
        }
      };

  public static com.google.protobuf.Parser<DedicatedResources> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<DedicatedResources> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.cloud.aiplatform.v1beta1.DedicatedResources getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
