/*
 * Copyright 2024 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/cloud/aiplatform/v1beta1/dataset.proto

// Protobuf Java Version: 3.25.3
package com.google.cloud.aiplatform.v1beta1;

/**
 *
 *
 * <pre>
 * Describes what part of the Dataset is to be exported, the destination of
 * the export and how to export.
 * </pre>
 *
 * Protobuf type {@code google.cloud.aiplatform.v1beta1.ExportDataConfig}
 */
public final class ExportDataConfig extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.cloud.aiplatform.v1beta1.ExportDataConfig)
    ExportDataConfigOrBuilder {
  private static final long serialVersionUID = 0L;
  // Use ExportDataConfig.newBuilder() to construct.
  private ExportDataConfig(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private ExportDataConfig() {
    annotationsFilter_ = "";
  }

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new ExportDataConfig();
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.cloud.aiplatform.v1beta1.DatasetProto
        .internal_static_google_cloud_aiplatform_v1beta1_ExportDataConfig_descriptor;
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.cloud.aiplatform.v1beta1.DatasetProto
        .internal_static_google_cloud_aiplatform_v1beta1_ExportDataConfig_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.cloud.aiplatform.v1beta1.ExportDataConfig.class,
            com.google.cloud.aiplatform.v1beta1.ExportDataConfig.Builder.class);
  }

  private int destinationCase_ = 0;

  @SuppressWarnings("serial")
  private java.lang.Object destination_;

  public enum DestinationCase
      implements
          com.google.protobuf.Internal.EnumLite,
          com.google.protobuf.AbstractMessage.InternalOneOfEnum {
    GCS_DESTINATION(1),
    DESTINATION_NOT_SET(0);
    private final int value;

    private DestinationCase(int value) {
      this.value = value;
    }
    /**
     * @param value The number of the enum to look for.
     * @return The enum associated with the given number.
     * @deprecated Use {@link #forNumber(int)} instead.
     */
    @java.lang.Deprecated
    public static DestinationCase valueOf(int value) {
      return forNumber(value);
    }

    public static DestinationCase forNumber(int value) {
      switch (value) {
        case 1:
          return GCS_DESTINATION;
        case 0:
          return DESTINATION_NOT_SET;
        default:
          return null;
      }
    }

    public int getNumber() {
      return this.value;
    }
  };

  public DestinationCase getDestinationCase() {
    return DestinationCase.forNumber(destinationCase_);
  }

  private int splitCase_ = 0;

  @SuppressWarnings("serial")
  private java.lang.Object split_;

  public enum SplitCase
      implements
          com.google.protobuf.Internal.EnumLite,
          com.google.protobuf.AbstractMessage.InternalOneOfEnum {
    FRACTION_SPLIT(5),
    SPLIT_NOT_SET(0);
    private final int value;

    private SplitCase(int value) {
      this.value = value;
    }
    /**
     * @param value The number of the enum to look for.
     * @return The enum associated with the given number.
     * @deprecated Use {@link #forNumber(int)} instead.
     */
    @java.lang.Deprecated
    public static SplitCase valueOf(int value) {
      return forNumber(value);
    }

    public static SplitCase forNumber(int value) {
      switch (value) {
        case 5:
          return FRACTION_SPLIT;
        case 0:
          return SPLIT_NOT_SET;
        default:
          return null;
      }
    }

    public int getNumber() {
      return this.value;
    }
  };

  public SplitCase getSplitCase() {
    return SplitCase.forNumber(splitCase_);
  }

  public static final int GCS_DESTINATION_FIELD_NUMBER = 1;
  /**
   *
   *
   * <pre>
   * The Google Cloud Storage location where the output is to be written to.
   * In the given directory a new directory will be created with name:
   * `export-data-&lt;dataset-display-name&gt;-&lt;timestamp-of-export-call&gt;` where
   * timestamp is in YYYY-MM-DDThh:mm:ss.sssZ ISO-8601 format. All export
   * output will be written into that directory. Inside that directory,
   * annotations with the same schema will be grouped into sub directories
   * which are named with the corresponding annotations' schema title. Inside
   * these sub directories, a schema.yaml will be created to describe the
   * output format.
   * </pre>
   *
   * <code>.google.cloud.aiplatform.v1beta1.GcsDestination gcs_destination = 1;</code>
   *
   * @return Whether the gcsDestination field is set.
   */
  @java.lang.Override
  public boolean hasGcsDestination() {
    return destinationCase_ == 1;
  }
  /**
   *
   *
   * <pre>
   * The Google Cloud Storage location where the output is to be written to.
   * In the given directory a new directory will be created with name:
   * `export-data-&lt;dataset-display-name&gt;-&lt;timestamp-of-export-call&gt;` where
   * timestamp is in YYYY-MM-DDThh:mm:ss.sssZ ISO-8601 format. All export
   * output will be written into that directory. Inside that directory,
   * annotations with the same schema will be grouped into sub directories
   * which are named with the corresponding annotations' schema title. Inside
   * these sub directories, a schema.yaml will be created to describe the
   * output format.
   * </pre>
   *
   * <code>.google.cloud.aiplatform.v1beta1.GcsDestination gcs_destination = 1;</code>
   *
   * @return The gcsDestination.
   */
  @java.lang.Override
  public com.google.cloud.aiplatform.v1beta1.GcsDestination getGcsDestination() {
    if (destinationCase_ == 1) {
      return (com.google.cloud.aiplatform.v1beta1.GcsDestination) destination_;
    }
    return com.google.cloud.aiplatform.v1beta1.GcsDestination.getDefaultInstance();
  }
  /**
   *
   *
   * <pre>
   * The Google Cloud Storage location where the output is to be written to.
   * In the given directory a new directory will be created with name:
   * `export-data-&lt;dataset-display-name&gt;-&lt;timestamp-of-export-call&gt;` where
   * timestamp is in YYYY-MM-DDThh:mm:ss.sssZ ISO-8601 format. All export
   * output will be written into that directory. Inside that directory,
   * annotations with the same schema will be grouped into sub directories
   * which are named with the corresponding annotations' schema title. Inside
   * these sub directories, a schema.yaml will be created to describe the
   * output format.
   * </pre>
   *
   * <code>.google.cloud.aiplatform.v1beta1.GcsDestination gcs_destination = 1;</code>
   */
  @java.lang.Override
  public com.google.cloud.aiplatform.v1beta1.GcsDestinationOrBuilder getGcsDestinationOrBuilder() {
    if (destinationCase_ == 1) {
      return (com.google.cloud.aiplatform.v1beta1.GcsDestination) destination_;
    }
    return com.google.cloud.aiplatform.v1beta1.GcsDestination.getDefaultInstance();
  }

  public static final int FRACTION_SPLIT_FIELD_NUMBER = 5;
  /**
   *
   *
   * <pre>
   * Split based on fractions defining the size of each set.
   * </pre>
   *
   * <code>.google.cloud.aiplatform.v1beta1.ExportFractionSplit fraction_split = 5;</code>
   *
   * @return Whether the fractionSplit field is set.
   */
  @java.lang.Override
  public boolean hasFractionSplit() {
    return splitCase_ == 5;
  }
  /**
   *
   *
   * <pre>
   * Split based on fractions defining the size of each set.
   * </pre>
   *
   * <code>.google.cloud.aiplatform.v1beta1.ExportFractionSplit fraction_split = 5;</code>
   *
   * @return The fractionSplit.
   */
  @java.lang.Override
  public com.google.cloud.aiplatform.v1beta1.ExportFractionSplit getFractionSplit() {
    if (splitCase_ == 5) {
      return (com.google.cloud.aiplatform.v1beta1.ExportFractionSplit) split_;
    }
    return com.google.cloud.aiplatform.v1beta1.ExportFractionSplit.getDefaultInstance();
  }
  /**
   *
   *
   * <pre>
   * Split based on fractions defining the size of each set.
   * </pre>
   *
   * <code>.google.cloud.aiplatform.v1beta1.ExportFractionSplit fraction_split = 5;</code>
   */
  @java.lang.Override
  public com.google.cloud.aiplatform.v1beta1.ExportFractionSplitOrBuilder
      getFractionSplitOrBuilder() {
    if (splitCase_ == 5) {
      return (com.google.cloud.aiplatform.v1beta1.ExportFractionSplit) split_;
    }
    return com.google.cloud.aiplatform.v1beta1.ExportFractionSplit.getDefaultInstance();
  }

  public static final int ANNOTATIONS_FILTER_FIELD_NUMBER = 2;

  @SuppressWarnings("serial")
  private volatile java.lang.Object annotationsFilter_ = "";
  /**
   *
   *
   * <pre>
   * An expression for filtering what part of the Dataset is to be exported.
   * Only Annotations that match this filter will be exported. The filter syntax
   * is the same as in
   * [ListAnnotations][google.cloud.aiplatform.v1beta1.DatasetService.ListAnnotations].
   * </pre>
   *
   * <code>string annotations_filter = 2;</code>
   *
   * @return The annotationsFilter.
   */
  @java.lang.Override
  public java.lang.String getAnnotationsFilter() {
    java.lang.Object ref = annotationsFilter_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      annotationsFilter_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * An expression for filtering what part of the Dataset is to be exported.
   * Only Annotations that match this filter will be exported. The filter syntax
   * is the same as in
   * [ListAnnotations][google.cloud.aiplatform.v1beta1.DatasetService.ListAnnotations].
   * </pre>
   *
   * <code>string annotations_filter = 2;</code>
   *
   * @return The bytes for annotationsFilter.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getAnnotationsFilterBytes() {
    java.lang.Object ref = annotationsFilter_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      annotationsFilter_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    if (destinationCase_ == 1) {
      output.writeMessage(1, (com.google.cloud.aiplatform.v1beta1.GcsDestination) destination_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(annotationsFilter_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 2, annotationsFilter_);
    }
    if (splitCase_ == 5) {
      output.writeMessage(5, (com.google.cloud.aiplatform.v1beta1.ExportFractionSplit) split_);
    }
    getUnknownFields().writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    if (destinationCase_ == 1) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(
              1, (com.google.cloud.aiplatform.v1beta1.GcsDestination) destination_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(annotationsFilter_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(2, annotationsFilter_);
    }
    if (splitCase_ == 5) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(
              5, (com.google.cloud.aiplatform.v1beta1.ExportFractionSplit) split_);
    }
    size += getUnknownFields().getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.cloud.aiplatform.v1beta1.ExportDataConfig)) {
      return super.equals(obj);
    }
    com.google.cloud.aiplatform.v1beta1.ExportDataConfig other =
        (com.google.cloud.aiplatform.v1beta1.ExportDataConfig) obj;

    if (!getAnnotationsFilter().equals(other.getAnnotationsFilter())) return false;
    if (!getDestinationCase().equals(other.getDestinationCase())) return false;
    switch (destinationCase_) {
      case 1:
        if (!getGcsDestination().equals(other.getGcsDestination())) return false;
        break;
      case 0:
      default:
    }
    if (!getSplitCase().equals(other.getSplitCase())) return false;
    switch (splitCase_) {
      case 5:
        if (!getFractionSplit().equals(other.getFractionSplit())) return false;
        break;
      case 0:
      default:
    }
    if (!getUnknownFields().equals(other.getUnknownFields())) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    hash = (37 * hash) + ANNOTATIONS_FILTER_FIELD_NUMBER;
    hash = (53 * hash) + getAnnotationsFilter().hashCode();
    switch (destinationCase_) {
      case 1:
        hash = (37 * hash) + GCS_DESTINATION_FIELD_NUMBER;
        hash = (53 * hash) + getGcsDestination().hashCode();
        break;
      case 0:
      default:
    }
    switch (splitCase_) {
      case 5:
        hash = (37 * hash) + FRACTION_SPLIT_FIELD_NUMBER;
        hash = (53 * hash) + getFractionSplit().hashCode();
        break;
      case 0:
      default:
    }
    hash = (29 * hash) + getUnknownFields().hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.cloud.aiplatform.v1beta1.ExportDataConfig parseFrom(
      java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.aiplatform.v1beta1.ExportDataConfig parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.aiplatform.v1beta1.ExportDataConfig parseFrom(
      com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.aiplatform.v1beta1.ExportDataConfig parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.aiplatform.v1beta1.ExportDataConfig parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.aiplatform.v1beta1.ExportDataConfig parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.aiplatform.v1beta1.ExportDataConfig parseFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.aiplatform.v1beta1.ExportDataConfig parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.aiplatform.v1beta1.ExportDataConfig parseDelimitedFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.cloud.aiplatform.v1beta1.ExportDataConfig parseDelimitedFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.aiplatform.v1beta1.ExportDataConfig parseFrom(
      com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.aiplatform.v1beta1.ExportDataConfig parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(com.google.cloud.aiplatform.v1beta1.ExportDataConfig prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }
  /**
   *
   *
   * <pre>
   * Describes what part of the Dataset is to be exported, the destination of
   * the export and how to export.
   * </pre>
   *
   * Protobuf type {@code google.cloud.aiplatform.v1beta1.ExportDataConfig}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.cloud.aiplatform.v1beta1.ExportDataConfig)
      com.google.cloud.aiplatform.v1beta1.ExportDataConfigOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.aiplatform.v1beta1.DatasetProto
          .internal_static_google_cloud_aiplatform_v1beta1_ExportDataConfig_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.aiplatform.v1beta1.DatasetProto
          .internal_static_google_cloud_aiplatform_v1beta1_ExportDataConfig_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.aiplatform.v1beta1.ExportDataConfig.class,
              com.google.cloud.aiplatform.v1beta1.ExportDataConfig.Builder.class);
    }

    // Construct using com.google.cloud.aiplatform.v1beta1.ExportDataConfig.newBuilder()
    private Builder() {}

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      bitField0_ = 0;
      if (gcsDestinationBuilder_ != null) {
        gcsDestinationBuilder_.clear();
      }
      if (fractionSplitBuilder_ != null) {
        fractionSplitBuilder_.clear();
      }
      annotationsFilter_ = "";
      destinationCase_ = 0;
      destination_ = null;
      splitCase_ = 0;
      split_ = null;
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.cloud.aiplatform.v1beta1.DatasetProto
          .internal_static_google_cloud_aiplatform_v1beta1_ExportDataConfig_descriptor;
    }

    @java.lang.Override
    public com.google.cloud.aiplatform.v1beta1.ExportDataConfig getDefaultInstanceForType() {
      return com.google.cloud.aiplatform.v1beta1.ExportDataConfig.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.cloud.aiplatform.v1beta1.ExportDataConfig build() {
      com.google.cloud.aiplatform.v1beta1.ExportDataConfig result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.cloud.aiplatform.v1beta1.ExportDataConfig buildPartial() {
      com.google.cloud.aiplatform.v1beta1.ExportDataConfig result =
          new com.google.cloud.aiplatform.v1beta1.ExportDataConfig(this);
      if (bitField0_ != 0) {
        buildPartial0(result);
      }
      buildPartialOneofs(result);
      onBuilt();
      return result;
    }

    private void buildPartial0(com.google.cloud.aiplatform.v1beta1.ExportDataConfig result) {
      int from_bitField0_ = bitField0_;
      if (((from_bitField0_ & 0x00000004) != 0)) {
        result.annotationsFilter_ = annotationsFilter_;
      }
    }

    private void buildPartialOneofs(com.google.cloud.aiplatform.v1beta1.ExportDataConfig result) {
      result.destinationCase_ = destinationCase_;
      result.destination_ = this.destination_;
      if (destinationCase_ == 1 && gcsDestinationBuilder_ != null) {
        result.destination_ = gcsDestinationBuilder_.build();
      }
      result.splitCase_ = splitCase_;
      result.split_ = this.split_;
      if (splitCase_ == 5 && fractionSplitBuilder_ != null) {
        result.split_ = fractionSplitBuilder_.build();
      }
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.cloud.aiplatform.v1beta1.ExportDataConfig) {
        return mergeFrom((com.google.cloud.aiplatform.v1beta1.ExportDataConfig) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(com.google.cloud.aiplatform.v1beta1.ExportDataConfig other) {
      if (other == com.google.cloud.aiplatform.v1beta1.ExportDataConfig.getDefaultInstance())
        return this;
      if (!other.getAnnotationsFilter().isEmpty()) {
        annotationsFilter_ = other.annotationsFilter_;
        bitField0_ |= 0x00000004;
        onChanged();
      }
      switch (other.getDestinationCase()) {
        case GCS_DESTINATION:
          {
            mergeGcsDestination(other.getGcsDestination());
            break;
          }
        case DESTINATION_NOT_SET:
          {
            break;
          }
      }
      switch (other.getSplitCase()) {
        case FRACTION_SPLIT:
          {
            mergeFractionSplit(other.getFractionSplit());
            break;
          }
        case SPLIT_NOT_SET:
          {
            break;
          }
      }
      this.mergeUnknownFields(other.getUnknownFields());
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 10:
              {
                input.readMessage(getGcsDestinationFieldBuilder().getBuilder(), extensionRegistry);
                destinationCase_ = 1;
                break;
              } // case 10
            case 18:
              {
                annotationsFilter_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000004;
                break;
              } // case 18
            case 42:
              {
                input.readMessage(getFractionSplitFieldBuilder().getBuilder(), extensionRegistry);
                splitCase_ = 5;
                break;
              } // case 42
            default:
              {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
          } // switch (tag)
        } // while (!done)
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.unwrapIOException();
      } finally {
        onChanged();
      } // finally
      return this;
    }

    private int destinationCase_ = 0;
    private java.lang.Object destination_;

    public DestinationCase getDestinationCase() {
      return DestinationCase.forNumber(destinationCase_);
    }

    public Builder clearDestination() {
      destinationCase_ = 0;
      destination_ = null;
      onChanged();
      return this;
    }

    private int splitCase_ = 0;
    private java.lang.Object split_;

    public SplitCase getSplitCase() {
      return SplitCase.forNumber(splitCase_);
    }

    public Builder clearSplit() {
      splitCase_ = 0;
      split_ = null;
      onChanged();
      return this;
    }

    private int bitField0_;

    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.aiplatform.v1beta1.GcsDestination,
            com.google.cloud.aiplatform.v1beta1.GcsDestination.Builder,
            com.google.cloud.aiplatform.v1beta1.GcsDestinationOrBuilder>
        gcsDestinationBuilder_;
    /**
     *
     *
     * <pre>
     * The Google Cloud Storage location where the output is to be written to.
     * In the given directory a new directory will be created with name:
     * `export-data-&lt;dataset-display-name&gt;-&lt;timestamp-of-export-call&gt;` where
     * timestamp is in YYYY-MM-DDThh:mm:ss.sssZ ISO-8601 format. All export
     * output will be written into that directory. Inside that directory,
     * annotations with the same schema will be grouped into sub directories
     * which are named with the corresponding annotations' schema title. Inside
     * these sub directories, a schema.yaml will be created to describe the
     * output format.
     * </pre>
     *
     * <code>.google.cloud.aiplatform.v1beta1.GcsDestination gcs_destination = 1;</code>
     *
     * @return Whether the gcsDestination field is set.
     */
    @java.lang.Override
    public boolean hasGcsDestination() {
      return destinationCase_ == 1;
    }
    /**
     *
     *
     * <pre>
     * The Google Cloud Storage location where the output is to be written to.
     * In the given directory a new directory will be created with name:
     * `export-data-&lt;dataset-display-name&gt;-&lt;timestamp-of-export-call&gt;` where
     * timestamp is in YYYY-MM-DDThh:mm:ss.sssZ ISO-8601 format. All export
     * output will be written into that directory. Inside that directory,
     * annotations with the same schema will be grouped into sub directories
     * which are named with the corresponding annotations' schema title. Inside
     * these sub directories, a schema.yaml will be created to describe the
     * output format.
     * </pre>
     *
     * <code>.google.cloud.aiplatform.v1beta1.GcsDestination gcs_destination = 1;</code>
     *
     * @return The gcsDestination.
     */
    @java.lang.Override
    public com.google.cloud.aiplatform.v1beta1.GcsDestination getGcsDestination() {
      if (gcsDestinationBuilder_ == null) {
        if (destinationCase_ == 1) {
          return (com.google.cloud.aiplatform.v1beta1.GcsDestination) destination_;
        }
        return com.google.cloud.aiplatform.v1beta1.GcsDestination.getDefaultInstance();
      } else {
        if (destinationCase_ == 1) {
          return gcsDestinationBuilder_.getMessage();
        }
        return com.google.cloud.aiplatform.v1beta1.GcsDestination.getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * The Google Cloud Storage location where the output is to be written to.
     * In the given directory a new directory will be created with name:
     * `export-data-&lt;dataset-display-name&gt;-&lt;timestamp-of-export-call&gt;` where
     * timestamp is in YYYY-MM-DDThh:mm:ss.sssZ ISO-8601 format. All export
     * output will be written into that directory. Inside that directory,
     * annotations with the same schema will be grouped into sub directories
     * which are named with the corresponding annotations' schema title. Inside
     * these sub directories, a schema.yaml will be created to describe the
     * output format.
     * </pre>
     *
     * <code>.google.cloud.aiplatform.v1beta1.GcsDestination gcs_destination = 1;</code>
     */
    public Builder setGcsDestination(com.google.cloud.aiplatform.v1beta1.GcsDestination value) {
      if (gcsDestinationBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        destination_ = value;
        onChanged();
      } else {
        gcsDestinationBuilder_.setMessage(value);
      }
      destinationCase_ = 1;
      return this;
    }
    /**
     *
     *
     * <pre>
     * The Google Cloud Storage location where the output is to be written to.
     * In the given directory a new directory will be created with name:
     * `export-data-&lt;dataset-display-name&gt;-&lt;timestamp-of-export-call&gt;` where
     * timestamp is in YYYY-MM-DDThh:mm:ss.sssZ ISO-8601 format. All export
     * output will be written into that directory. Inside that directory,
     * annotations with the same schema will be grouped into sub directories
     * which are named with the corresponding annotations' schema title. Inside
     * these sub directories, a schema.yaml will be created to describe the
     * output format.
     * </pre>
     *
     * <code>.google.cloud.aiplatform.v1beta1.GcsDestination gcs_destination = 1;</code>
     */
    public Builder setGcsDestination(
        com.google.cloud.aiplatform.v1beta1.GcsDestination.Builder builderForValue) {
      if (gcsDestinationBuilder_ == null) {
        destination_ = builderForValue.build();
        onChanged();
      } else {
        gcsDestinationBuilder_.setMessage(builderForValue.build());
      }
      destinationCase_ = 1;
      return this;
    }
    /**
     *
     *
     * <pre>
     * The Google Cloud Storage location where the output is to be written to.
     * In the given directory a new directory will be created with name:
     * `export-data-&lt;dataset-display-name&gt;-&lt;timestamp-of-export-call&gt;` where
     * timestamp is in YYYY-MM-DDThh:mm:ss.sssZ ISO-8601 format. All export
     * output will be written into that directory. Inside that directory,
     * annotations with the same schema will be grouped into sub directories
     * which are named with the corresponding annotations' schema title. Inside
     * these sub directories, a schema.yaml will be created to describe the
     * output format.
     * </pre>
     *
     * <code>.google.cloud.aiplatform.v1beta1.GcsDestination gcs_destination = 1;</code>
     */
    public Builder mergeGcsDestination(com.google.cloud.aiplatform.v1beta1.GcsDestination value) {
      if (gcsDestinationBuilder_ == null) {
        if (destinationCase_ == 1
            && destination_
                != com.google.cloud.aiplatform.v1beta1.GcsDestination.getDefaultInstance()) {
          destination_ =
              com.google.cloud.aiplatform.v1beta1.GcsDestination.newBuilder(
                      (com.google.cloud.aiplatform.v1beta1.GcsDestination) destination_)
                  .mergeFrom(value)
                  .buildPartial();
        } else {
          destination_ = value;
        }
        onChanged();
      } else {
        if (destinationCase_ == 1) {
          gcsDestinationBuilder_.mergeFrom(value);
        } else {
          gcsDestinationBuilder_.setMessage(value);
        }
      }
      destinationCase_ = 1;
      return this;
    }
    /**
     *
     *
     * <pre>
     * The Google Cloud Storage location where the output is to be written to.
     * In the given directory a new directory will be created with name:
     * `export-data-&lt;dataset-display-name&gt;-&lt;timestamp-of-export-call&gt;` where
     * timestamp is in YYYY-MM-DDThh:mm:ss.sssZ ISO-8601 format. All export
     * output will be written into that directory. Inside that directory,
     * annotations with the same schema will be grouped into sub directories
     * which are named with the corresponding annotations' schema title. Inside
     * these sub directories, a schema.yaml will be created to describe the
     * output format.
     * </pre>
     *
     * <code>.google.cloud.aiplatform.v1beta1.GcsDestination gcs_destination = 1;</code>
     */
    public Builder clearGcsDestination() {
      if (gcsDestinationBuilder_ == null) {
        if (destinationCase_ == 1) {
          destinationCase_ = 0;
          destination_ = null;
          onChanged();
        }
      } else {
        if (destinationCase_ == 1) {
          destinationCase_ = 0;
          destination_ = null;
        }
        gcsDestinationBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * The Google Cloud Storage location where the output is to be written to.
     * In the given directory a new directory will be created with name:
     * `export-data-&lt;dataset-display-name&gt;-&lt;timestamp-of-export-call&gt;` where
     * timestamp is in YYYY-MM-DDThh:mm:ss.sssZ ISO-8601 format. All export
     * output will be written into that directory. Inside that directory,
     * annotations with the same schema will be grouped into sub directories
     * which are named with the corresponding annotations' schema title. Inside
     * these sub directories, a schema.yaml will be created to describe the
     * output format.
     * </pre>
     *
     * <code>.google.cloud.aiplatform.v1beta1.GcsDestination gcs_destination = 1;</code>
     */
    public com.google.cloud.aiplatform.v1beta1.GcsDestination.Builder getGcsDestinationBuilder() {
      return getGcsDestinationFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * The Google Cloud Storage location where the output is to be written to.
     * In the given directory a new directory will be created with name:
     * `export-data-&lt;dataset-display-name&gt;-&lt;timestamp-of-export-call&gt;` where
     * timestamp is in YYYY-MM-DDThh:mm:ss.sssZ ISO-8601 format. All export
     * output will be written into that directory. Inside that directory,
     * annotations with the same schema will be grouped into sub directories
     * which are named with the corresponding annotations' schema title. Inside
     * these sub directories, a schema.yaml will be created to describe the
     * output format.
     * </pre>
     *
     * <code>.google.cloud.aiplatform.v1beta1.GcsDestination gcs_destination = 1;</code>
     */
    @java.lang.Override
    public com.google.cloud.aiplatform.v1beta1.GcsDestinationOrBuilder
        getGcsDestinationOrBuilder() {
      if ((destinationCase_ == 1) && (gcsDestinationBuilder_ != null)) {
        return gcsDestinationBuilder_.getMessageOrBuilder();
      } else {
        if (destinationCase_ == 1) {
          return (com.google.cloud.aiplatform.v1beta1.GcsDestination) destination_;
        }
        return com.google.cloud.aiplatform.v1beta1.GcsDestination.getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * The Google Cloud Storage location where the output is to be written to.
     * In the given directory a new directory will be created with name:
     * `export-data-&lt;dataset-display-name&gt;-&lt;timestamp-of-export-call&gt;` where
     * timestamp is in YYYY-MM-DDThh:mm:ss.sssZ ISO-8601 format. All export
     * output will be written into that directory. Inside that directory,
     * annotations with the same schema will be grouped into sub directories
     * which are named with the corresponding annotations' schema title. Inside
     * these sub directories, a schema.yaml will be created to describe the
     * output format.
     * </pre>
     *
     * <code>.google.cloud.aiplatform.v1beta1.GcsDestination gcs_destination = 1;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.aiplatform.v1beta1.GcsDestination,
            com.google.cloud.aiplatform.v1beta1.GcsDestination.Builder,
            com.google.cloud.aiplatform.v1beta1.GcsDestinationOrBuilder>
        getGcsDestinationFieldBuilder() {
      if (gcsDestinationBuilder_ == null) {
        if (!(destinationCase_ == 1)) {
          destination_ = com.google.cloud.aiplatform.v1beta1.GcsDestination.getDefaultInstance();
        }
        gcsDestinationBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.aiplatform.v1beta1.GcsDestination,
                com.google.cloud.aiplatform.v1beta1.GcsDestination.Builder,
                com.google.cloud.aiplatform.v1beta1.GcsDestinationOrBuilder>(
                (com.google.cloud.aiplatform.v1beta1.GcsDestination) destination_,
                getParentForChildren(),
                isClean());
        destination_ = null;
      }
      destinationCase_ = 1;
      onChanged();
      return gcsDestinationBuilder_;
    }

    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.aiplatform.v1beta1.ExportFractionSplit,
            com.google.cloud.aiplatform.v1beta1.ExportFractionSplit.Builder,
            com.google.cloud.aiplatform.v1beta1.ExportFractionSplitOrBuilder>
        fractionSplitBuilder_;
    /**
     *
     *
     * <pre>
     * Split based on fractions defining the size of each set.
     * </pre>
     *
     * <code>.google.cloud.aiplatform.v1beta1.ExportFractionSplit fraction_split = 5;</code>
     *
     * @return Whether the fractionSplit field is set.
     */
    @java.lang.Override
    public boolean hasFractionSplit() {
      return splitCase_ == 5;
    }
    /**
     *
     *
     * <pre>
     * Split based on fractions defining the size of each set.
     * </pre>
     *
     * <code>.google.cloud.aiplatform.v1beta1.ExportFractionSplit fraction_split = 5;</code>
     *
     * @return The fractionSplit.
     */
    @java.lang.Override
    public com.google.cloud.aiplatform.v1beta1.ExportFractionSplit getFractionSplit() {
      if (fractionSplitBuilder_ == null) {
        if (splitCase_ == 5) {
          return (com.google.cloud.aiplatform.v1beta1.ExportFractionSplit) split_;
        }
        return com.google.cloud.aiplatform.v1beta1.ExportFractionSplit.getDefaultInstance();
      } else {
        if (splitCase_ == 5) {
          return fractionSplitBuilder_.getMessage();
        }
        return com.google.cloud.aiplatform.v1beta1.ExportFractionSplit.getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * Split based on fractions defining the size of each set.
     * </pre>
     *
     * <code>.google.cloud.aiplatform.v1beta1.ExportFractionSplit fraction_split = 5;</code>
     */
    public Builder setFractionSplit(com.google.cloud.aiplatform.v1beta1.ExportFractionSplit value) {
      if (fractionSplitBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        split_ = value;
        onChanged();
      } else {
        fractionSplitBuilder_.setMessage(value);
      }
      splitCase_ = 5;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Split based on fractions defining the size of each set.
     * </pre>
     *
     * <code>.google.cloud.aiplatform.v1beta1.ExportFractionSplit fraction_split = 5;</code>
     */
    public Builder setFractionSplit(
        com.google.cloud.aiplatform.v1beta1.ExportFractionSplit.Builder builderForValue) {
      if (fractionSplitBuilder_ == null) {
        split_ = builderForValue.build();
        onChanged();
      } else {
        fractionSplitBuilder_.setMessage(builderForValue.build());
      }
      splitCase_ = 5;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Split based on fractions defining the size of each set.
     * </pre>
     *
     * <code>.google.cloud.aiplatform.v1beta1.ExportFractionSplit fraction_split = 5;</code>
     */
    public Builder mergeFractionSplit(
        com.google.cloud.aiplatform.v1beta1.ExportFractionSplit value) {
      if (fractionSplitBuilder_ == null) {
        if (splitCase_ == 5
            && split_
                != com.google.cloud.aiplatform.v1beta1.ExportFractionSplit.getDefaultInstance()) {
          split_ =
              com.google.cloud.aiplatform.v1beta1.ExportFractionSplit.newBuilder(
                      (com.google.cloud.aiplatform.v1beta1.ExportFractionSplit) split_)
                  .mergeFrom(value)
                  .buildPartial();
        } else {
          split_ = value;
        }
        onChanged();
      } else {
        if (splitCase_ == 5) {
          fractionSplitBuilder_.mergeFrom(value);
        } else {
          fractionSplitBuilder_.setMessage(value);
        }
      }
      splitCase_ = 5;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Split based on fractions defining the size of each set.
     * </pre>
     *
     * <code>.google.cloud.aiplatform.v1beta1.ExportFractionSplit fraction_split = 5;</code>
     */
    public Builder clearFractionSplit() {
      if (fractionSplitBuilder_ == null) {
        if (splitCase_ == 5) {
          splitCase_ = 0;
          split_ = null;
          onChanged();
        }
      } else {
        if (splitCase_ == 5) {
          splitCase_ = 0;
          split_ = null;
        }
        fractionSplitBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Split based on fractions defining the size of each set.
     * </pre>
     *
     * <code>.google.cloud.aiplatform.v1beta1.ExportFractionSplit fraction_split = 5;</code>
     */
    public com.google.cloud.aiplatform.v1beta1.ExportFractionSplit.Builder
        getFractionSplitBuilder() {
      return getFractionSplitFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Split based on fractions defining the size of each set.
     * </pre>
     *
     * <code>.google.cloud.aiplatform.v1beta1.ExportFractionSplit fraction_split = 5;</code>
     */
    @java.lang.Override
    public com.google.cloud.aiplatform.v1beta1.ExportFractionSplitOrBuilder
        getFractionSplitOrBuilder() {
      if ((splitCase_ == 5) && (fractionSplitBuilder_ != null)) {
        return fractionSplitBuilder_.getMessageOrBuilder();
      } else {
        if (splitCase_ == 5) {
          return (com.google.cloud.aiplatform.v1beta1.ExportFractionSplit) split_;
        }
        return com.google.cloud.aiplatform.v1beta1.ExportFractionSplit.getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * Split based on fractions defining the size of each set.
     * </pre>
     *
     * <code>.google.cloud.aiplatform.v1beta1.ExportFractionSplit fraction_split = 5;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.aiplatform.v1beta1.ExportFractionSplit,
            com.google.cloud.aiplatform.v1beta1.ExportFractionSplit.Builder,
            com.google.cloud.aiplatform.v1beta1.ExportFractionSplitOrBuilder>
        getFractionSplitFieldBuilder() {
      if (fractionSplitBuilder_ == null) {
        if (!(splitCase_ == 5)) {
          split_ = com.google.cloud.aiplatform.v1beta1.ExportFractionSplit.getDefaultInstance();
        }
        fractionSplitBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.aiplatform.v1beta1.ExportFractionSplit,
                com.google.cloud.aiplatform.v1beta1.ExportFractionSplit.Builder,
                com.google.cloud.aiplatform.v1beta1.ExportFractionSplitOrBuilder>(
                (com.google.cloud.aiplatform.v1beta1.ExportFractionSplit) split_,
                getParentForChildren(),
                isClean());
        split_ = null;
      }
      splitCase_ = 5;
      onChanged();
      return fractionSplitBuilder_;
    }

    private java.lang.Object annotationsFilter_ = "";
    /**
     *
     *
     * <pre>
     * An expression for filtering what part of the Dataset is to be exported.
     * Only Annotations that match this filter will be exported. The filter syntax
     * is the same as in
     * [ListAnnotations][google.cloud.aiplatform.v1beta1.DatasetService.ListAnnotations].
     * </pre>
     *
     * <code>string annotations_filter = 2;</code>
     *
     * @return The annotationsFilter.
     */
    public java.lang.String getAnnotationsFilter() {
      java.lang.Object ref = annotationsFilter_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        annotationsFilter_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * An expression for filtering what part of the Dataset is to be exported.
     * Only Annotations that match this filter will be exported. The filter syntax
     * is the same as in
     * [ListAnnotations][google.cloud.aiplatform.v1beta1.DatasetService.ListAnnotations].
     * </pre>
     *
     * <code>string annotations_filter = 2;</code>
     *
     * @return The bytes for annotationsFilter.
     */
    public com.google.protobuf.ByteString getAnnotationsFilterBytes() {
      java.lang.Object ref = annotationsFilter_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        annotationsFilter_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * An expression for filtering what part of the Dataset is to be exported.
     * Only Annotations that match this filter will be exported. The filter syntax
     * is the same as in
     * [ListAnnotations][google.cloud.aiplatform.v1beta1.DatasetService.ListAnnotations].
     * </pre>
     *
     * <code>string annotations_filter = 2;</code>
     *
     * @param value The annotationsFilter to set.
     * @return This builder for chaining.
     */
    public Builder setAnnotationsFilter(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      annotationsFilter_ = value;
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * An expression for filtering what part of the Dataset is to be exported.
     * Only Annotations that match this filter will be exported. The filter syntax
     * is the same as in
     * [ListAnnotations][google.cloud.aiplatform.v1beta1.DatasetService.ListAnnotations].
     * </pre>
     *
     * <code>string annotations_filter = 2;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearAnnotationsFilter() {
      annotationsFilter_ = getDefaultInstance().getAnnotationsFilter();
      bitField0_ = (bitField0_ & ~0x00000004);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * An expression for filtering what part of the Dataset is to be exported.
     * Only Annotations that match this filter will be exported. The filter syntax
     * is the same as in
     * [ListAnnotations][google.cloud.aiplatform.v1beta1.DatasetService.ListAnnotations].
     * </pre>
     *
     * <code>string annotations_filter = 2;</code>
     *
     * @param value The bytes for annotationsFilter to set.
     * @return This builder for chaining.
     */
    public Builder setAnnotationsFilterBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      annotationsFilter_ = value;
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.cloud.aiplatform.v1beta1.ExportDataConfig)
  }

  // @@protoc_insertion_point(class_scope:google.cloud.aiplatform.v1beta1.ExportDataConfig)
  private static final com.google.cloud.aiplatform.v1beta1.ExportDataConfig DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.cloud.aiplatform.v1beta1.ExportDataConfig();
  }

  public static com.google.cloud.aiplatform.v1beta1.ExportDataConfig getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<ExportDataConfig> PARSER =
      new com.google.protobuf.AbstractParser<ExportDataConfig>() {
        @java.lang.Override
        public ExportDataConfig parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          Builder builder = newBuilder();
          try {
            builder.mergeFrom(input, extensionRegistry);
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.setUnfinishedMessage(builder.buildPartial());
          } catch (com.google.protobuf.UninitializedMessageException e) {
            throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
          } catch (java.io.IOException e) {
            throw new com.google.protobuf.InvalidProtocolBufferException(e)
                .setUnfinishedMessage(builder.buildPartial());
          }
          return builder.buildPartial();
        }
      };

  public static com.google.protobuf.Parser<ExportDataConfig> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<ExportDataConfig> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.cloud.aiplatform.v1beta1.ExportDataConfig getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
