/*
 * Copyright 2024 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/cloud/aiplatform/v1beta1/model_monitoring_job.proto

// Protobuf Java Version: 3.25.3
package com.google.cloud.aiplatform.v1beta1;

/**
 *
 *
 * <pre>
 * Represents a model monitoring job that analyze dataset using different
 * monitoring algorithm.
 * </pre>
 *
 * Protobuf type {@code google.cloud.aiplatform.v1beta1.ModelMonitoringJob}
 */
public final class ModelMonitoringJob extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.cloud.aiplatform.v1beta1.ModelMonitoringJob)
    ModelMonitoringJobOrBuilder {
  private static final long serialVersionUID = 0L;
  // Use ModelMonitoringJob.newBuilder() to construct.
  private ModelMonitoringJob(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private ModelMonitoringJob() {
    name_ = "";
    displayName_ = "";
    state_ = 0;
    schedule_ = "";
  }

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new ModelMonitoringJob();
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.cloud.aiplatform.v1beta1.ModelMonitoringJobProto
        .internal_static_google_cloud_aiplatform_v1beta1_ModelMonitoringJob_descriptor;
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.cloud.aiplatform.v1beta1.ModelMonitoringJobProto
        .internal_static_google_cloud_aiplatform_v1beta1_ModelMonitoringJob_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.cloud.aiplatform.v1beta1.ModelMonitoringJob.class,
            com.google.cloud.aiplatform.v1beta1.ModelMonitoringJob.Builder.class);
  }

  private int bitField0_;
  public static final int NAME_FIELD_NUMBER = 1;

  @SuppressWarnings("serial")
  private volatile java.lang.Object name_ = "";
  /**
   *
   *
   * <pre>
   * Output only. Resource name of a ModelMonitoringJob. Format:
   * `projects/{project_id}/locations/{location_id}/modelMonitors/{model_monitor_id}/modelMonitoringJobs/{model_monitoring_job_id}`
   * </pre>
   *
   * <code>string name = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
   *
   * @return The name.
   */
  @java.lang.Override
  public java.lang.String getName() {
    java.lang.Object ref = name_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      name_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Output only. Resource name of a ModelMonitoringJob. Format:
   * `projects/{project_id}/locations/{location_id}/modelMonitors/{model_monitor_id}/modelMonitoringJobs/{model_monitoring_job_id}`
   * </pre>
   *
   * <code>string name = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
   *
   * @return The bytes for name.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getNameBytes() {
    java.lang.Object ref = name_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      name_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int DISPLAY_NAME_FIELD_NUMBER = 2;

  @SuppressWarnings("serial")
  private volatile java.lang.Object displayName_ = "";
  /**
   *
   *
   * <pre>
   * The display name of the ModelMonitoringJob.
   * The name can be up to 128 characters long and can consist of any UTF-8.
   * </pre>
   *
   * <code>string display_name = 2;</code>
   *
   * @return The displayName.
   */
  @java.lang.Override
  public java.lang.String getDisplayName() {
    java.lang.Object ref = displayName_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      displayName_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * The display name of the ModelMonitoringJob.
   * The name can be up to 128 characters long and can consist of any UTF-8.
   * </pre>
   *
   * <code>string display_name = 2;</code>
   *
   * @return The bytes for displayName.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getDisplayNameBytes() {
    java.lang.Object ref = displayName_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      displayName_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int MODEL_MONITORING_SPEC_FIELD_NUMBER = 3;
  private com.google.cloud.aiplatform.v1beta1.ModelMonitoringSpec modelMonitoringSpec_;
  /**
   *
   *
   * <pre>
   * Monitoring monitoring job spec. It outlines the specifications for
   * monitoring objectives, notifications, and result exports. If left blank,
   * the default monitoring specifications from the top-level resource
   * 'ModelMonitor' will be applied. If provided, we will use the specification
   * defined here rather than the default one.
   * </pre>
   *
   * <code>.google.cloud.aiplatform.v1beta1.ModelMonitoringSpec model_monitoring_spec = 3;</code>
   *
   * @return Whether the modelMonitoringSpec field is set.
   */
  @java.lang.Override
  public boolean hasModelMonitoringSpec() {
    return ((bitField0_ & 0x00000001) != 0);
  }
  /**
   *
   *
   * <pre>
   * Monitoring monitoring job spec. It outlines the specifications for
   * monitoring objectives, notifications, and result exports. If left blank,
   * the default monitoring specifications from the top-level resource
   * 'ModelMonitor' will be applied. If provided, we will use the specification
   * defined here rather than the default one.
   * </pre>
   *
   * <code>.google.cloud.aiplatform.v1beta1.ModelMonitoringSpec model_monitoring_spec = 3;</code>
   *
   * @return The modelMonitoringSpec.
   */
  @java.lang.Override
  public com.google.cloud.aiplatform.v1beta1.ModelMonitoringSpec getModelMonitoringSpec() {
    return modelMonitoringSpec_ == null
        ? com.google.cloud.aiplatform.v1beta1.ModelMonitoringSpec.getDefaultInstance()
        : modelMonitoringSpec_;
  }
  /**
   *
   *
   * <pre>
   * Monitoring monitoring job spec. It outlines the specifications for
   * monitoring objectives, notifications, and result exports. If left blank,
   * the default monitoring specifications from the top-level resource
   * 'ModelMonitor' will be applied. If provided, we will use the specification
   * defined here rather than the default one.
   * </pre>
   *
   * <code>.google.cloud.aiplatform.v1beta1.ModelMonitoringSpec model_monitoring_spec = 3;</code>
   */
  @java.lang.Override
  public com.google.cloud.aiplatform.v1beta1.ModelMonitoringSpecOrBuilder
      getModelMonitoringSpecOrBuilder() {
    return modelMonitoringSpec_ == null
        ? com.google.cloud.aiplatform.v1beta1.ModelMonitoringSpec.getDefaultInstance()
        : modelMonitoringSpec_;
  }

  public static final int CREATE_TIME_FIELD_NUMBER = 4;
  private com.google.protobuf.Timestamp createTime_;
  /**
   *
   *
   * <pre>
   * Output only. Timestamp when this ModelMonitoringJob was created.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp create_time = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return Whether the createTime field is set.
   */
  @java.lang.Override
  public boolean hasCreateTime() {
    return ((bitField0_ & 0x00000002) != 0);
  }
  /**
   *
   *
   * <pre>
   * Output only. Timestamp when this ModelMonitoringJob was created.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp create_time = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return The createTime.
   */
  @java.lang.Override
  public com.google.protobuf.Timestamp getCreateTime() {
    return createTime_ == null ? com.google.protobuf.Timestamp.getDefaultInstance() : createTime_;
  }
  /**
   *
   *
   * <pre>
   * Output only. Timestamp when this ModelMonitoringJob was created.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp create_time = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   */
  @java.lang.Override
  public com.google.protobuf.TimestampOrBuilder getCreateTimeOrBuilder() {
    return createTime_ == null ? com.google.protobuf.Timestamp.getDefaultInstance() : createTime_;
  }

  public static final int UPDATE_TIME_FIELD_NUMBER = 5;
  private com.google.protobuf.Timestamp updateTime_;
  /**
   *
   *
   * <pre>
   * Output only. Timestamp when this ModelMonitoringJob was updated most
   * recently.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp update_time = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return Whether the updateTime field is set.
   */
  @java.lang.Override
  public boolean hasUpdateTime() {
    return ((bitField0_ & 0x00000004) != 0);
  }
  /**
   *
   *
   * <pre>
   * Output only. Timestamp when this ModelMonitoringJob was updated most
   * recently.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp update_time = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return The updateTime.
   */
  @java.lang.Override
  public com.google.protobuf.Timestamp getUpdateTime() {
    return updateTime_ == null ? com.google.protobuf.Timestamp.getDefaultInstance() : updateTime_;
  }
  /**
   *
   *
   * <pre>
   * Output only. Timestamp when this ModelMonitoringJob was updated most
   * recently.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp update_time = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   */
  @java.lang.Override
  public com.google.protobuf.TimestampOrBuilder getUpdateTimeOrBuilder() {
    return updateTime_ == null ? com.google.protobuf.Timestamp.getDefaultInstance() : updateTime_;
  }

  public static final int STATE_FIELD_NUMBER = 6;
  private int state_ = 0;
  /**
   *
   *
   * <pre>
   * Output only. The state of the monitoring job.
   *  * When the job is still creating, the state will be 'JOB_STATE_PENDING'.
   *  * Once the job is successfully created, the state will be
   *    'JOB_STATE_RUNNING'.
   *  * Once the job is finished, the state will be one of
   *    'JOB_STATE_FAILED', 'JOB_STATE_SUCCEEDED',
   *    'JOB_STATE_PARTIALLY_SUCCEEDED'.
   * </pre>
   *
   * <code>
   * .google.cloud.aiplatform.v1beta1.JobState state = 6 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return The enum numeric value on the wire for state.
   */
  @java.lang.Override
  public int getStateValue() {
    return state_;
  }
  /**
   *
   *
   * <pre>
   * Output only. The state of the monitoring job.
   *  * When the job is still creating, the state will be 'JOB_STATE_PENDING'.
   *  * Once the job is successfully created, the state will be
   *    'JOB_STATE_RUNNING'.
   *  * Once the job is finished, the state will be one of
   *    'JOB_STATE_FAILED', 'JOB_STATE_SUCCEEDED',
   *    'JOB_STATE_PARTIALLY_SUCCEEDED'.
   * </pre>
   *
   * <code>
   * .google.cloud.aiplatform.v1beta1.JobState state = 6 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return The state.
   */
  @java.lang.Override
  public com.google.cloud.aiplatform.v1beta1.JobState getState() {
    com.google.cloud.aiplatform.v1beta1.JobState result =
        com.google.cloud.aiplatform.v1beta1.JobState.forNumber(state_);
    return result == null ? com.google.cloud.aiplatform.v1beta1.JobState.UNRECOGNIZED : result;
  }

  public static final int SCHEDULE_FIELD_NUMBER = 7;

  @SuppressWarnings("serial")
  private volatile java.lang.Object schedule_ = "";
  /**
   *
   *
   * <pre>
   * Output only. Schedule resource name. It will only appear when this job is
   * triggered by a schedule.
   * </pre>
   *
   * <code>
   * string schedule = 7 [(.google.api.field_behavior) = OUTPUT_ONLY, (.google.api.resource_reference) = { ... }
   * </code>
   *
   * @return The schedule.
   */
  @java.lang.Override
  public java.lang.String getSchedule() {
    java.lang.Object ref = schedule_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      schedule_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Output only. Schedule resource name. It will only appear when this job is
   * triggered by a schedule.
   * </pre>
   *
   * <code>
   * string schedule = 7 [(.google.api.field_behavior) = OUTPUT_ONLY, (.google.api.resource_reference) = { ... }
   * </code>
   *
   * @return The bytes for schedule.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getScheduleBytes() {
    java.lang.Object ref = schedule_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      schedule_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int JOB_EXECUTION_DETAIL_FIELD_NUMBER = 8;
  private com.google.cloud.aiplatform.v1beta1.ModelMonitoringJobExecutionDetail jobExecutionDetail_;
  /**
   *
   *
   * <pre>
   * Output only. Execution results for all the monitoring objectives.
   * </pre>
   *
   * <code>
   * .google.cloud.aiplatform.v1beta1.ModelMonitoringJobExecutionDetail job_execution_detail = 8 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return Whether the jobExecutionDetail field is set.
   */
  @java.lang.Override
  public boolean hasJobExecutionDetail() {
    return ((bitField0_ & 0x00000008) != 0);
  }
  /**
   *
   *
   * <pre>
   * Output only. Execution results for all the monitoring objectives.
   * </pre>
   *
   * <code>
   * .google.cloud.aiplatform.v1beta1.ModelMonitoringJobExecutionDetail job_execution_detail = 8 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return The jobExecutionDetail.
   */
  @java.lang.Override
  public com.google.cloud.aiplatform.v1beta1.ModelMonitoringJobExecutionDetail
      getJobExecutionDetail() {
    return jobExecutionDetail_ == null
        ? com.google.cloud.aiplatform.v1beta1.ModelMonitoringJobExecutionDetail.getDefaultInstance()
        : jobExecutionDetail_;
  }
  /**
   *
   *
   * <pre>
   * Output only. Execution results for all the monitoring objectives.
   * </pre>
   *
   * <code>
   * .google.cloud.aiplatform.v1beta1.ModelMonitoringJobExecutionDetail job_execution_detail = 8 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.aiplatform.v1beta1.ModelMonitoringJobExecutionDetailOrBuilder
      getJobExecutionDetailOrBuilder() {
    return jobExecutionDetail_ == null
        ? com.google.cloud.aiplatform.v1beta1.ModelMonitoringJobExecutionDetail.getDefaultInstance()
        : jobExecutionDetail_;
  }

  public static final int SCHEDULE_TIME_FIELD_NUMBER = 9;
  private com.google.protobuf.Timestamp scheduleTime_;
  /**
   *
   *
   * <pre>
   * Output only. Timestamp when this ModelMonitoringJob was scheduled. It will
   * only appear when this job is triggered by a schedule.
   * </pre>
   *
   * <code>
   * .google.protobuf.Timestamp schedule_time = 9 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return Whether the scheduleTime field is set.
   */
  @java.lang.Override
  public boolean hasScheduleTime() {
    return ((bitField0_ & 0x00000010) != 0);
  }
  /**
   *
   *
   * <pre>
   * Output only. Timestamp when this ModelMonitoringJob was scheduled. It will
   * only appear when this job is triggered by a schedule.
   * </pre>
   *
   * <code>
   * .google.protobuf.Timestamp schedule_time = 9 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return The scheduleTime.
   */
  @java.lang.Override
  public com.google.protobuf.Timestamp getScheduleTime() {
    return scheduleTime_ == null
        ? com.google.protobuf.Timestamp.getDefaultInstance()
        : scheduleTime_;
  }
  /**
   *
   *
   * <pre>
   * Output only. Timestamp when this ModelMonitoringJob was scheduled. It will
   * only appear when this job is triggered by a schedule.
   * </pre>
   *
   * <code>
   * .google.protobuf.Timestamp schedule_time = 9 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   */
  @java.lang.Override
  public com.google.protobuf.TimestampOrBuilder getScheduleTimeOrBuilder() {
    return scheduleTime_ == null
        ? com.google.protobuf.Timestamp.getDefaultInstance()
        : scheduleTime_;
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(name_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 1, name_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(displayName_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 2, displayName_);
    }
    if (((bitField0_ & 0x00000001) != 0)) {
      output.writeMessage(3, getModelMonitoringSpec());
    }
    if (((bitField0_ & 0x00000002) != 0)) {
      output.writeMessage(4, getCreateTime());
    }
    if (((bitField0_ & 0x00000004) != 0)) {
      output.writeMessage(5, getUpdateTime());
    }
    if (state_ != com.google.cloud.aiplatform.v1beta1.JobState.JOB_STATE_UNSPECIFIED.getNumber()) {
      output.writeEnum(6, state_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(schedule_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 7, schedule_);
    }
    if (((bitField0_ & 0x00000008) != 0)) {
      output.writeMessage(8, getJobExecutionDetail());
    }
    if (((bitField0_ & 0x00000010) != 0)) {
      output.writeMessage(9, getScheduleTime());
    }
    getUnknownFields().writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(name_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(1, name_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(displayName_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(2, displayName_);
    }
    if (((bitField0_ & 0x00000001) != 0)) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(3, getModelMonitoringSpec());
    }
    if (((bitField0_ & 0x00000002) != 0)) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(4, getCreateTime());
    }
    if (((bitField0_ & 0x00000004) != 0)) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(5, getUpdateTime());
    }
    if (state_ != com.google.cloud.aiplatform.v1beta1.JobState.JOB_STATE_UNSPECIFIED.getNumber()) {
      size += com.google.protobuf.CodedOutputStream.computeEnumSize(6, state_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(schedule_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(7, schedule_);
    }
    if (((bitField0_ & 0x00000008) != 0)) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(8, getJobExecutionDetail());
    }
    if (((bitField0_ & 0x00000010) != 0)) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(9, getScheduleTime());
    }
    size += getUnknownFields().getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.cloud.aiplatform.v1beta1.ModelMonitoringJob)) {
      return super.equals(obj);
    }
    com.google.cloud.aiplatform.v1beta1.ModelMonitoringJob other =
        (com.google.cloud.aiplatform.v1beta1.ModelMonitoringJob) obj;

    if (!getName().equals(other.getName())) return false;
    if (!getDisplayName().equals(other.getDisplayName())) return false;
    if (hasModelMonitoringSpec() != other.hasModelMonitoringSpec()) return false;
    if (hasModelMonitoringSpec()) {
      if (!getModelMonitoringSpec().equals(other.getModelMonitoringSpec())) return false;
    }
    if (hasCreateTime() != other.hasCreateTime()) return false;
    if (hasCreateTime()) {
      if (!getCreateTime().equals(other.getCreateTime())) return false;
    }
    if (hasUpdateTime() != other.hasUpdateTime()) return false;
    if (hasUpdateTime()) {
      if (!getUpdateTime().equals(other.getUpdateTime())) return false;
    }
    if (state_ != other.state_) return false;
    if (!getSchedule().equals(other.getSchedule())) return false;
    if (hasJobExecutionDetail() != other.hasJobExecutionDetail()) return false;
    if (hasJobExecutionDetail()) {
      if (!getJobExecutionDetail().equals(other.getJobExecutionDetail())) return false;
    }
    if (hasScheduleTime() != other.hasScheduleTime()) return false;
    if (hasScheduleTime()) {
      if (!getScheduleTime().equals(other.getScheduleTime())) return false;
    }
    if (!getUnknownFields().equals(other.getUnknownFields())) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    hash = (37 * hash) + NAME_FIELD_NUMBER;
    hash = (53 * hash) + getName().hashCode();
    hash = (37 * hash) + DISPLAY_NAME_FIELD_NUMBER;
    hash = (53 * hash) + getDisplayName().hashCode();
    if (hasModelMonitoringSpec()) {
      hash = (37 * hash) + MODEL_MONITORING_SPEC_FIELD_NUMBER;
      hash = (53 * hash) + getModelMonitoringSpec().hashCode();
    }
    if (hasCreateTime()) {
      hash = (37 * hash) + CREATE_TIME_FIELD_NUMBER;
      hash = (53 * hash) + getCreateTime().hashCode();
    }
    if (hasUpdateTime()) {
      hash = (37 * hash) + UPDATE_TIME_FIELD_NUMBER;
      hash = (53 * hash) + getUpdateTime().hashCode();
    }
    hash = (37 * hash) + STATE_FIELD_NUMBER;
    hash = (53 * hash) + state_;
    hash = (37 * hash) + SCHEDULE_FIELD_NUMBER;
    hash = (53 * hash) + getSchedule().hashCode();
    if (hasJobExecutionDetail()) {
      hash = (37 * hash) + JOB_EXECUTION_DETAIL_FIELD_NUMBER;
      hash = (53 * hash) + getJobExecutionDetail().hashCode();
    }
    if (hasScheduleTime()) {
      hash = (37 * hash) + SCHEDULE_TIME_FIELD_NUMBER;
      hash = (53 * hash) + getScheduleTime().hashCode();
    }
    hash = (29 * hash) + getUnknownFields().hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.cloud.aiplatform.v1beta1.ModelMonitoringJob parseFrom(
      java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.aiplatform.v1beta1.ModelMonitoringJob parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.aiplatform.v1beta1.ModelMonitoringJob parseFrom(
      com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.aiplatform.v1beta1.ModelMonitoringJob parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.aiplatform.v1beta1.ModelMonitoringJob parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.aiplatform.v1beta1.ModelMonitoringJob parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.aiplatform.v1beta1.ModelMonitoringJob parseFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.aiplatform.v1beta1.ModelMonitoringJob parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.aiplatform.v1beta1.ModelMonitoringJob parseDelimitedFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.cloud.aiplatform.v1beta1.ModelMonitoringJob parseDelimitedFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.aiplatform.v1beta1.ModelMonitoringJob parseFrom(
      com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.aiplatform.v1beta1.ModelMonitoringJob parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(
      com.google.cloud.aiplatform.v1beta1.ModelMonitoringJob prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }
  /**
   *
   *
   * <pre>
   * Represents a model monitoring job that analyze dataset using different
   * monitoring algorithm.
   * </pre>
   *
   * Protobuf type {@code google.cloud.aiplatform.v1beta1.ModelMonitoringJob}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.cloud.aiplatform.v1beta1.ModelMonitoringJob)
      com.google.cloud.aiplatform.v1beta1.ModelMonitoringJobOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.aiplatform.v1beta1.ModelMonitoringJobProto
          .internal_static_google_cloud_aiplatform_v1beta1_ModelMonitoringJob_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.aiplatform.v1beta1.ModelMonitoringJobProto
          .internal_static_google_cloud_aiplatform_v1beta1_ModelMonitoringJob_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.aiplatform.v1beta1.ModelMonitoringJob.class,
              com.google.cloud.aiplatform.v1beta1.ModelMonitoringJob.Builder.class);
    }

    // Construct using com.google.cloud.aiplatform.v1beta1.ModelMonitoringJob.newBuilder()
    private Builder() {
      maybeForceBuilderInitialization();
    }

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
      maybeForceBuilderInitialization();
    }

    private void maybeForceBuilderInitialization() {
      if (com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders) {
        getModelMonitoringSpecFieldBuilder();
        getCreateTimeFieldBuilder();
        getUpdateTimeFieldBuilder();
        getJobExecutionDetailFieldBuilder();
        getScheduleTimeFieldBuilder();
      }
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      bitField0_ = 0;
      name_ = "";
      displayName_ = "";
      modelMonitoringSpec_ = null;
      if (modelMonitoringSpecBuilder_ != null) {
        modelMonitoringSpecBuilder_.dispose();
        modelMonitoringSpecBuilder_ = null;
      }
      createTime_ = null;
      if (createTimeBuilder_ != null) {
        createTimeBuilder_.dispose();
        createTimeBuilder_ = null;
      }
      updateTime_ = null;
      if (updateTimeBuilder_ != null) {
        updateTimeBuilder_.dispose();
        updateTimeBuilder_ = null;
      }
      state_ = 0;
      schedule_ = "";
      jobExecutionDetail_ = null;
      if (jobExecutionDetailBuilder_ != null) {
        jobExecutionDetailBuilder_.dispose();
        jobExecutionDetailBuilder_ = null;
      }
      scheduleTime_ = null;
      if (scheduleTimeBuilder_ != null) {
        scheduleTimeBuilder_.dispose();
        scheduleTimeBuilder_ = null;
      }
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.cloud.aiplatform.v1beta1.ModelMonitoringJobProto
          .internal_static_google_cloud_aiplatform_v1beta1_ModelMonitoringJob_descriptor;
    }

    @java.lang.Override
    public com.google.cloud.aiplatform.v1beta1.ModelMonitoringJob getDefaultInstanceForType() {
      return com.google.cloud.aiplatform.v1beta1.ModelMonitoringJob.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.cloud.aiplatform.v1beta1.ModelMonitoringJob build() {
      com.google.cloud.aiplatform.v1beta1.ModelMonitoringJob result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.cloud.aiplatform.v1beta1.ModelMonitoringJob buildPartial() {
      com.google.cloud.aiplatform.v1beta1.ModelMonitoringJob result =
          new com.google.cloud.aiplatform.v1beta1.ModelMonitoringJob(this);
      if (bitField0_ != 0) {
        buildPartial0(result);
      }
      onBuilt();
      return result;
    }

    private void buildPartial0(com.google.cloud.aiplatform.v1beta1.ModelMonitoringJob result) {
      int from_bitField0_ = bitField0_;
      if (((from_bitField0_ & 0x00000001) != 0)) {
        result.name_ = name_;
      }
      if (((from_bitField0_ & 0x00000002) != 0)) {
        result.displayName_ = displayName_;
      }
      int to_bitField0_ = 0;
      if (((from_bitField0_ & 0x00000004) != 0)) {
        result.modelMonitoringSpec_ =
            modelMonitoringSpecBuilder_ == null
                ? modelMonitoringSpec_
                : modelMonitoringSpecBuilder_.build();
        to_bitField0_ |= 0x00000001;
      }
      if (((from_bitField0_ & 0x00000008) != 0)) {
        result.createTime_ = createTimeBuilder_ == null ? createTime_ : createTimeBuilder_.build();
        to_bitField0_ |= 0x00000002;
      }
      if (((from_bitField0_ & 0x00000010) != 0)) {
        result.updateTime_ = updateTimeBuilder_ == null ? updateTime_ : updateTimeBuilder_.build();
        to_bitField0_ |= 0x00000004;
      }
      if (((from_bitField0_ & 0x00000020) != 0)) {
        result.state_ = state_;
      }
      if (((from_bitField0_ & 0x00000040) != 0)) {
        result.schedule_ = schedule_;
      }
      if (((from_bitField0_ & 0x00000080) != 0)) {
        result.jobExecutionDetail_ =
            jobExecutionDetailBuilder_ == null
                ? jobExecutionDetail_
                : jobExecutionDetailBuilder_.build();
        to_bitField0_ |= 0x00000008;
      }
      if (((from_bitField0_ & 0x00000100) != 0)) {
        result.scheduleTime_ =
            scheduleTimeBuilder_ == null ? scheduleTime_ : scheduleTimeBuilder_.build();
        to_bitField0_ |= 0x00000010;
      }
      result.bitField0_ |= to_bitField0_;
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.cloud.aiplatform.v1beta1.ModelMonitoringJob) {
        return mergeFrom((com.google.cloud.aiplatform.v1beta1.ModelMonitoringJob) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(com.google.cloud.aiplatform.v1beta1.ModelMonitoringJob other) {
      if (other == com.google.cloud.aiplatform.v1beta1.ModelMonitoringJob.getDefaultInstance())
        return this;
      if (!other.getName().isEmpty()) {
        name_ = other.name_;
        bitField0_ |= 0x00000001;
        onChanged();
      }
      if (!other.getDisplayName().isEmpty()) {
        displayName_ = other.displayName_;
        bitField0_ |= 0x00000002;
        onChanged();
      }
      if (other.hasModelMonitoringSpec()) {
        mergeModelMonitoringSpec(other.getModelMonitoringSpec());
      }
      if (other.hasCreateTime()) {
        mergeCreateTime(other.getCreateTime());
      }
      if (other.hasUpdateTime()) {
        mergeUpdateTime(other.getUpdateTime());
      }
      if (other.state_ != 0) {
        setStateValue(other.getStateValue());
      }
      if (!other.getSchedule().isEmpty()) {
        schedule_ = other.schedule_;
        bitField0_ |= 0x00000040;
        onChanged();
      }
      if (other.hasJobExecutionDetail()) {
        mergeJobExecutionDetail(other.getJobExecutionDetail());
      }
      if (other.hasScheduleTime()) {
        mergeScheduleTime(other.getScheduleTime());
      }
      this.mergeUnknownFields(other.getUnknownFields());
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 10:
              {
                name_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000001;
                break;
              } // case 10
            case 18:
              {
                displayName_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000002;
                break;
              } // case 18
            case 26:
              {
                input.readMessage(
                    getModelMonitoringSpecFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000004;
                break;
              } // case 26
            case 34:
              {
                input.readMessage(getCreateTimeFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000008;
                break;
              } // case 34
            case 42:
              {
                input.readMessage(getUpdateTimeFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000010;
                break;
              } // case 42
            case 48:
              {
                state_ = input.readEnum();
                bitField0_ |= 0x00000020;
                break;
              } // case 48
            case 58:
              {
                schedule_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000040;
                break;
              } // case 58
            case 66:
              {
                input.readMessage(
                    getJobExecutionDetailFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000080;
                break;
              } // case 66
            case 74:
              {
                input.readMessage(getScheduleTimeFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000100;
                break;
              } // case 74
            default:
              {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
          } // switch (tag)
        } // while (!done)
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.unwrapIOException();
      } finally {
        onChanged();
      } // finally
      return this;
    }

    private int bitField0_;

    private java.lang.Object name_ = "";
    /**
     *
     *
     * <pre>
     * Output only. Resource name of a ModelMonitoringJob. Format:
     * `projects/{project_id}/locations/{location_id}/modelMonitors/{model_monitor_id}/modelMonitoringJobs/{model_monitoring_job_id}`
     * </pre>
     *
     * <code>string name = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return The name.
     */
    public java.lang.String getName() {
      java.lang.Object ref = name_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        name_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. Resource name of a ModelMonitoringJob. Format:
     * `projects/{project_id}/locations/{location_id}/modelMonitors/{model_monitor_id}/modelMonitoringJobs/{model_monitoring_job_id}`
     * </pre>
     *
     * <code>string name = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return The bytes for name.
     */
    public com.google.protobuf.ByteString getNameBytes() {
      java.lang.Object ref = name_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        name_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. Resource name of a ModelMonitoringJob. Format:
     * `projects/{project_id}/locations/{location_id}/modelMonitors/{model_monitor_id}/modelMonitoringJobs/{model_monitoring_job_id}`
     * </pre>
     *
     * <code>string name = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @param value The name to set.
     * @return This builder for chaining.
     */
    public Builder setName(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      name_ = value;
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Resource name of a ModelMonitoringJob. Format:
     * `projects/{project_id}/locations/{location_id}/modelMonitors/{model_monitor_id}/modelMonitoringJobs/{model_monitoring_job_id}`
     * </pre>
     *
     * <code>string name = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearName() {
      name_ = getDefaultInstance().getName();
      bitField0_ = (bitField0_ & ~0x00000001);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Resource name of a ModelMonitoringJob. Format:
     * `projects/{project_id}/locations/{location_id}/modelMonitors/{model_monitor_id}/modelMonitoringJobs/{model_monitoring_job_id}`
     * </pre>
     *
     * <code>string name = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @param value The bytes for name to set.
     * @return This builder for chaining.
     */
    public Builder setNameBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      name_ = value;
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }

    private java.lang.Object displayName_ = "";
    /**
     *
     *
     * <pre>
     * The display name of the ModelMonitoringJob.
     * The name can be up to 128 characters long and can consist of any UTF-8.
     * </pre>
     *
     * <code>string display_name = 2;</code>
     *
     * @return The displayName.
     */
    public java.lang.String getDisplayName() {
      java.lang.Object ref = displayName_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        displayName_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * The display name of the ModelMonitoringJob.
     * The name can be up to 128 characters long and can consist of any UTF-8.
     * </pre>
     *
     * <code>string display_name = 2;</code>
     *
     * @return The bytes for displayName.
     */
    public com.google.protobuf.ByteString getDisplayNameBytes() {
      java.lang.Object ref = displayName_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        displayName_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * The display name of the ModelMonitoringJob.
     * The name can be up to 128 characters long and can consist of any UTF-8.
     * </pre>
     *
     * <code>string display_name = 2;</code>
     *
     * @param value The displayName to set.
     * @return This builder for chaining.
     */
    public Builder setDisplayName(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      displayName_ = value;
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The display name of the ModelMonitoringJob.
     * The name can be up to 128 characters long and can consist of any UTF-8.
     * </pre>
     *
     * <code>string display_name = 2;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearDisplayName() {
      displayName_ = getDefaultInstance().getDisplayName();
      bitField0_ = (bitField0_ & ~0x00000002);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The display name of the ModelMonitoringJob.
     * The name can be up to 128 characters long and can consist of any UTF-8.
     * </pre>
     *
     * <code>string display_name = 2;</code>
     *
     * @param value The bytes for displayName to set.
     * @return This builder for chaining.
     */
    public Builder setDisplayNameBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      displayName_ = value;
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }

    private com.google.cloud.aiplatform.v1beta1.ModelMonitoringSpec modelMonitoringSpec_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.aiplatform.v1beta1.ModelMonitoringSpec,
            com.google.cloud.aiplatform.v1beta1.ModelMonitoringSpec.Builder,
            com.google.cloud.aiplatform.v1beta1.ModelMonitoringSpecOrBuilder>
        modelMonitoringSpecBuilder_;
    /**
     *
     *
     * <pre>
     * Monitoring monitoring job spec. It outlines the specifications for
     * monitoring objectives, notifications, and result exports. If left blank,
     * the default monitoring specifications from the top-level resource
     * 'ModelMonitor' will be applied. If provided, we will use the specification
     * defined here rather than the default one.
     * </pre>
     *
     * <code>.google.cloud.aiplatform.v1beta1.ModelMonitoringSpec model_monitoring_spec = 3;</code>
     *
     * @return Whether the modelMonitoringSpec field is set.
     */
    public boolean hasModelMonitoringSpec() {
      return ((bitField0_ & 0x00000004) != 0);
    }
    /**
     *
     *
     * <pre>
     * Monitoring monitoring job spec. It outlines the specifications for
     * monitoring objectives, notifications, and result exports. If left blank,
     * the default monitoring specifications from the top-level resource
     * 'ModelMonitor' will be applied. If provided, we will use the specification
     * defined here rather than the default one.
     * </pre>
     *
     * <code>.google.cloud.aiplatform.v1beta1.ModelMonitoringSpec model_monitoring_spec = 3;</code>
     *
     * @return The modelMonitoringSpec.
     */
    public com.google.cloud.aiplatform.v1beta1.ModelMonitoringSpec getModelMonitoringSpec() {
      if (modelMonitoringSpecBuilder_ == null) {
        return modelMonitoringSpec_ == null
            ? com.google.cloud.aiplatform.v1beta1.ModelMonitoringSpec.getDefaultInstance()
            : modelMonitoringSpec_;
      } else {
        return modelMonitoringSpecBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Monitoring monitoring job spec. It outlines the specifications for
     * monitoring objectives, notifications, and result exports. If left blank,
     * the default monitoring specifications from the top-level resource
     * 'ModelMonitor' will be applied. If provided, we will use the specification
     * defined here rather than the default one.
     * </pre>
     *
     * <code>.google.cloud.aiplatform.v1beta1.ModelMonitoringSpec model_monitoring_spec = 3;</code>
     */
    public Builder setModelMonitoringSpec(
        com.google.cloud.aiplatform.v1beta1.ModelMonitoringSpec value) {
      if (modelMonitoringSpecBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        modelMonitoringSpec_ = value;
      } else {
        modelMonitoringSpecBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Monitoring monitoring job spec. It outlines the specifications for
     * monitoring objectives, notifications, and result exports. If left blank,
     * the default monitoring specifications from the top-level resource
     * 'ModelMonitor' will be applied. If provided, we will use the specification
     * defined here rather than the default one.
     * </pre>
     *
     * <code>.google.cloud.aiplatform.v1beta1.ModelMonitoringSpec model_monitoring_spec = 3;</code>
     */
    public Builder setModelMonitoringSpec(
        com.google.cloud.aiplatform.v1beta1.ModelMonitoringSpec.Builder builderForValue) {
      if (modelMonitoringSpecBuilder_ == null) {
        modelMonitoringSpec_ = builderForValue.build();
      } else {
        modelMonitoringSpecBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Monitoring monitoring job spec. It outlines the specifications for
     * monitoring objectives, notifications, and result exports. If left blank,
     * the default monitoring specifications from the top-level resource
     * 'ModelMonitor' will be applied. If provided, we will use the specification
     * defined here rather than the default one.
     * </pre>
     *
     * <code>.google.cloud.aiplatform.v1beta1.ModelMonitoringSpec model_monitoring_spec = 3;</code>
     */
    public Builder mergeModelMonitoringSpec(
        com.google.cloud.aiplatform.v1beta1.ModelMonitoringSpec value) {
      if (modelMonitoringSpecBuilder_ == null) {
        if (((bitField0_ & 0x00000004) != 0)
            && modelMonitoringSpec_ != null
            && modelMonitoringSpec_
                != com.google.cloud.aiplatform.v1beta1.ModelMonitoringSpec.getDefaultInstance()) {
          getModelMonitoringSpecBuilder().mergeFrom(value);
        } else {
          modelMonitoringSpec_ = value;
        }
      } else {
        modelMonitoringSpecBuilder_.mergeFrom(value);
      }
      if (modelMonitoringSpec_ != null) {
        bitField0_ |= 0x00000004;
        onChanged();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Monitoring monitoring job spec. It outlines the specifications for
     * monitoring objectives, notifications, and result exports. If left blank,
     * the default monitoring specifications from the top-level resource
     * 'ModelMonitor' will be applied. If provided, we will use the specification
     * defined here rather than the default one.
     * </pre>
     *
     * <code>.google.cloud.aiplatform.v1beta1.ModelMonitoringSpec model_monitoring_spec = 3;</code>
     */
    public Builder clearModelMonitoringSpec() {
      bitField0_ = (bitField0_ & ~0x00000004);
      modelMonitoringSpec_ = null;
      if (modelMonitoringSpecBuilder_ != null) {
        modelMonitoringSpecBuilder_.dispose();
        modelMonitoringSpecBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Monitoring monitoring job spec. It outlines the specifications for
     * monitoring objectives, notifications, and result exports. If left blank,
     * the default monitoring specifications from the top-level resource
     * 'ModelMonitor' will be applied. If provided, we will use the specification
     * defined here rather than the default one.
     * </pre>
     *
     * <code>.google.cloud.aiplatform.v1beta1.ModelMonitoringSpec model_monitoring_spec = 3;</code>
     */
    public com.google.cloud.aiplatform.v1beta1.ModelMonitoringSpec.Builder
        getModelMonitoringSpecBuilder() {
      bitField0_ |= 0x00000004;
      onChanged();
      return getModelMonitoringSpecFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Monitoring monitoring job spec. It outlines the specifications for
     * monitoring objectives, notifications, and result exports. If left blank,
     * the default monitoring specifications from the top-level resource
     * 'ModelMonitor' will be applied. If provided, we will use the specification
     * defined here rather than the default one.
     * </pre>
     *
     * <code>.google.cloud.aiplatform.v1beta1.ModelMonitoringSpec model_monitoring_spec = 3;</code>
     */
    public com.google.cloud.aiplatform.v1beta1.ModelMonitoringSpecOrBuilder
        getModelMonitoringSpecOrBuilder() {
      if (modelMonitoringSpecBuilder_ != null) {
        return modelMonitoringSpecBuilder_.getMessageOrBuilder();
      } else {
        return modelMonitoringSpec_ == null
            ? com.google.cloud.aiplatform.v1beta1.ModelMonitoringSpec.getDefaultInstance()
            : modelMonitoringSpec_;
      }
    }
    /**
     *
     *
     * <pre>
     * Monitoring monitoring job spec. It outlines the specifications for
     * monitoring objectives, notifications, and result exports. If left blank,
     * the default monitoring specifications from the top-level resource
     * 'ModelMonitor' will be applied. If provided, we will use the specification
     * defined here rather than the default one.
     * </pre>
     *
     * <code>.google.cloud.aiplatform.v1beta1.ModelMonitoringSpec model_monitoring_spec = 3;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.aiplatform.v1beta1.ModelMonitoringSpec,
            com.google.cloud.aiplatform.v1beta1.ModelMonitoringSpec.Builder,
            com.google.cloud.aiplatform.v1beta1.ModelMonitoringSpecOrBuilder>
        getModelMonitoringSpecFieldBuilder() {
      if (modelMonitoringSpecBuilder_ == null) {
        modelMonitoringSpecBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.aiplatform.v1beta1.ModelMonitoringSpec,
                com.google.cloud.aiplatform.v1beta1.ModelMonitoringSpec.Builder,
                com.google.cloud.aiplatform.v1beta1.ModelMonitoringSpecOrBuilder>(
                getModelMonitoringSpec(), getParentForChildren(), isClean());
        modelMonitoringSpec_ = null;
      }
      return modelMonitoringSpecBuilder_;
    }

    private com.google.protobuf.Timestamp createTime_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Timestamp,
            com.google.protobuf.Timestamp.Builder,
            com.google.protobuf.TimestampOrBuilder>
        createTimeBuilder_;
    /**
     *
     *
     * <pre>
     * Output only. Timestamp when this ModelMonitoringJob was created.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp create_time = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return Whether the createTime field is set.
     */
    public boolean hasCreateTime() {
      return ((bitField0_ & 0x00000008) != 0);
    }
    /**
     *
     *
     * <pre>
     * Output only. Timestamp when this ModelMonitoringJob was created.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp create_time = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return The createTime.
     */
    public com.google.protobuf.Timestamp getCreateTime() {
      if (createTimeBuilder_ == null) {
        return createTime_ == null
            ? com.google.protobuf.Timestamp.getDefaultInstance()
            : createTime_;
      } else {
        return createTimeBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. Timestamp when this ModelMonitoringJob was created.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp create_time = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder setCreateTime(com.google.protobuf.Timestamp value) {
      if (createTimeBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        createTime_ = value;
      } else {
        createTimeBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000008;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Timestamp when this ModelMonitoringJob was created.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp create_time = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder setCreateTime(com.google.protobuf.Timestamp.Builder builderForValue) {
      if (createTimeBuilder_ == null) {
        createTime_ = builderForValue.build();
      } else {
        createTimeBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000008;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Timestamp when this ModelMonitoringJob was created.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp create_time = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder mergeCreateTime(com.google.protobuf.Timestamp value) {
      if (createTimeBuilder_ == null) {
        if (((bitField0_ & 0x00000008) != 0)
            && createTime_ != null
            && createTime_ != com.google.protobuf.Timestamp.getDefaultInstance()) {
          getCreateTimeBuilder().mergeFrom(value);
        } else {
          createTime_ = value;
        }
      } else {
        createTimeBuilder_.mergeFrom(value);
      }
      if (createTime_ != null) {
        bitField0_ |= 0x00000008;
        onChanged();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Timestamp when this ModelMonitoringJob was created.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp create_time = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder clearCreateTime() {
      bitField0_ = (bitField0_ & ~0x00000008);
      createTime_ = null;
      if (createTimeBuilder_ != null) {
        createTimeBuilder_.dispose();
        createTimeBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Timestamp when this ModelMonitoringJob was created.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp create_time = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.protobuf.Timestamp.Builder getCreateTimeBuilder() {
      bitField0_ |= 0x00000008;
      onChanged();
      return getCreateTimeFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Output only. Timestamp when this ModelMonitoringJob was created.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp create_time = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.protobuf.TimestampOrBuilder getCreateTimeOrBuilder() {
      if (createTimeBuilder_ != null) {
        return createTimeBuilder_.getMessageOrBuilder();
      } else {
        return createTime_ == null
            ? com.google.protobuf.Timestamp.getDefaultInstance()
            : createTime_;
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. Timestamp when this ModelMonitoringJob was created.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp create_time = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Timestamp,
            com.google.protobuf.Timestamp.Builder,
            com.google.protobuf.TimestampOrBuilder>
        getCreateTimeFieldBuilder() {
      if (createTimeBuilder_ == null) {
        createTimeBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.protobuf.Timestamp,
                com.google.protobuf.Timestamp.Builder,
                com.google.protobuf.TimestampOrBuilder>(
                getCreateTime(), getParentForChildren(), isClean());
        createTime_ = null;
      }
      return createTimeBuilder_;
    }

    private com.google.protobuf.Timestamp updateTime_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Timestamp,
            com.google.protobuf.Timestamp.Builder,
            com.google.protobuf.TimestampOrBuilder>
        updateTimeBuilder_;
    /**
     *
     *
     * <pre>
     * Output only. Timestamp when this ModelMonitoringJob was updated most
     * recently.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp update_time = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return Whether the updateTime field is set.
     */
    public boolean hasUpdateTime() {
      return ((bitField0_ & 0x00000010) != 0);
    }
    /**
     *
     *
     * <pre>
     * Output only. Timestamp when this ModelMonitoringJob was updated most
     * recently.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp update_time = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return The updateTime.
     */
    public com.google.protobuf.Timestamp getUpdateTime() {
      if (updateTimeBuilder_ == null) {
        return updateTime_ == null
            ? com.google.protobuf.Timestamp.getDefaultInstance()
            : updateTime_;
      } else {
        return updateTimeBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. Timestamp when this ModelMonitoringJob was updated most
     * recently.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp update_time = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder setUpdateTime(com.google.protobuf.Timestamp value) {
      if (updateTimeBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        updateTime_ = value;
      } else {
        updateTimeBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000010;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Timestamp when this ModelMonitoringJob was updated most
     * recently.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp update_time = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder setUpdateTime(com.google.protobuf.Timestamp.Builder builderForValue) {
      if (updateTimeBuilder_ == null) {
        updateTime_ = builderForValue.build();
      } else {
        updateTimeBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000010;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Timestamp when this ModelMonitoringJob was updated most
     * recently.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp update_time = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder mergeUpdateTime(com.google.protobuf.Timestamp value) {
      if (updateTimeBuilder_ == null) {
        if (((bitField0_ & 0x00000010) != 0)
            && updateTime_ != null
            && updateTime_ != com.google.protobuf.Timestamp.getDefaultInstance()) {
          getUpdateTimeBuilder().mergeFrom(value);
        } else {
          updateTime_ = value;
        }
      } else {
        updateTimeBuilder_.mergeFrom(value);
      }
      if (updateTime_ != null) {
        bitField0_ |= 0x00000010;
        onChanged();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Timestamp when this ModelMonitoringJob was updated most
     * recently.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp update_time = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder clearUpdateTime() {
      bitField0_ = (bitField0_ & ~0x00000010);
      updateTime_ = null;
      if (updateTimeBuilder_ != null) {
        updateTimeBuilder_.dispose();
        updateTimeBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Timestamp when this ModelMonitoringJob was updated most
     * recently.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp update_time = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.protobuf.Timestamp.Builder getUpdateTimeBuilder() {
      bitField0_ |= 0x00000010;
      onChanged();
      return getUpdateTimeFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Output only. Timestamp when this ModelMonitoringJob was updated most
     * recently.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp update_time = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.protobuf.TimestampOrBuilder getUpdateTimeOrBuilder() {
      if (updateTimeBuilder_ != null) {
        return updateTimeBuilder_.getMessageOrBuilder();
      } else {
        return updateTime_ == null
            ? com.google.protobuf.Timestamp.getDefaultInstance()
            : updateTime_;
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. Timestamp when this ModelMonitoringJob was updated most
     * recently.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp update_time = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Timestamp,
            com.google.protobuf.Timestamp.Builder,
            com.google.protobuf.TimestampOrBuilder>
        getUpdateTimeFieldBuilder() {
      if (updateTimeBuilder_ == null) {
        updateTimeBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.protobuf.Timestamp,
                com.google.protobuf.Timestamp.Builder,
                com.google.protobuf.TimestampOrBuilder>(
                getUpdateTime(), getParentForChildren(), isClean());
        updateTime_ = null;
      }
      return updateTimeBuilder_;
    }

    private int state_ = 0;
    /**
     *
     *
     * <pre>
     * Output only. The state of the monitoring job.
     *  * When the job is still creating, the state will be 'JOB_STATE_PENDING'.
     *  * Once the job is successfully created, the state will be
     *    'JOB_STATE_RUNNING'.
     *  * Once the job is finished, the state will be one of
     *    'JOB_STATE_FAILED', 'JOB_STATE_SUCCEEDED',
     *    'JOB_STATE_PARTIALLY_SUCCEEDED'.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.JobState state = 6 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return The enum numeric value on the wire for state.
     */
    @java.lang.Override
    public int getStateValue() {
      return state_;
    }
    /**
     *
     *
     * <pre>
     * Output only. The state of the monitoring job.
     *  * When the job is still creating, the state will be 'JOB_STATE_PENDING'.
     *  * Once the job is successfully created, the state will be
     *    'JOB_STATE_RUNNING'.
     *  * Once the job is finished, the state will be one of
     *    'JOB_STATE_FAILED', 'JOB_STATE_SUCCEEDED',
     *    'JOB_STATE_PARTIALLY_SUCCEEDED'.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.JobState state = 6 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @param value The enum numeric value on the wire for state to set.
     * @return This builder for chaining.
     */
    public Builder setStateValue(int value) {
      state_ = value;
      bitField0_ |= 0x00000020;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The state of the monitoring job.
     *  * When the job is still creating, the state will be 'JOB_STATE_PENDING'.
     *  * Once the job is successfully created, the state will be
     *    'JOB_STATE_RUNNING'.
     *  * Once the job is finished, the state will be one of
     *    'JOB_STATE_FAILED', 'JOB_STATE_SUCCEEDED',
     *    'JOB_STATE_PARTIALLY_SUCCEEDED'.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.JobState state = 6 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return The state.
     */
    @java.lang.Override
    public com.google.cloud.aiplatform.v1beta1.JobState getState() {
      com.google.cloud.aiplatform.v1beta1.JobState result =
          com.google.cloud.aiplatform.v1beta1.JobState.forNumber(state_);
      return result == null ? com.google.cloud.aiplatform.v1beta1.JobState.UNRECOGNIZED : result;
    }
    /**
     *
     *
     * <pre>
     * Output only. The state of the monitoring job.
     *  * When the job is still creating, the state will be 'JOB_STATE_PENDING'.
     *  * Once the job is successfully created, the state will be
     *    'JOB_STATE_RUNNING'.
     *  * Once the job is finished, the state will be one of
     *    'JOB_STATE_FAILED', 'JOB_STATE_SUCCEEDED',
     *    'JOB_STATE_PARTIALLY_SUCCEEDED'.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.JobState state = 6 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @param value The state to set.
     * @return This builder for chaining.
     */
    public Builder setState(com.google.cloud.aiplatform.v1beta1.JobState value) {
      if (value == null) {
        throw new NullPointerException();
      }
      bitField0_ |= 0x00000020;
      state_ = value.getNumber();
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The state of the monitoring job.
     *  * When the job is still creating, the state will be 'JOB_STATE_PENDING'.
     *  * Once the job is successfully created, the state will be
     *    'JOB_STATE_RUNNING'.
     *  * Once the job is finished, the state will be one of
     *    'JOB_STATE_FAILED', 'JOB_STATE_SUCCEEDED',
     *    'JOB_STATE_PARTIALLY_SUCCEEDED'.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.JobState state = 6 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return This builder for chaining.
     */
    public Builder clearState() {
      bitField0_ = (bitField0_ & ~0x00000020);
      state_ = 0;
      onChanged();
      return this;
    }

    private java.lang.Object schedule_ = "";
    /**
     *
     *
     * <pre>
     * Output only. Schedule resource name. It will only appear when this job is
     * triggered by a schedule.
     * </pre>
     *
     * <code>
     * string schedule = 7 [(.google.api.field_behavior) = OUTPUT_ONLY, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @return The schedule.
     */
    public java.lang.String getSchedule() {
      java.lang.Object ref = schedule_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        schedule_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. Schedule resource name. It will only appear when this job is
     * triggered by a schedule.
     * </pre>
     *
     * <code>
     * string schedule = 7 [(.google.api.field_behavior) = OUTPUT_ONLY, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @return The bytes for schedule.
     */
    public com.google.protobuf.ByteString getScheduleBytes() {
      java.lang.Object ref = schedule_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        schedule_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. Schedule resource name. It will only appear when this job is
     * triggered by a schedule.
     * </pre>
     *
     * <code>
     * string schedule = 7 [(.google.api.field_behavior) = OUTPUT_ONLY, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @param value The schedule to set.
     * @return This builder for chaining.
     */
    public Builder setSchedule(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      schedule_ = value;
      bitField0_ |= 0x00000040;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Schedule resource name. It will only appear when this job is
     * triggered by a schedule.
     * </pre>
     *
     * <code>
     * string schedule = 7 [(.google.api.field_behavior) = OUTPUT_ONLY, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @return This builder for chaining.
     */
    public Builder clearSchedule() {
      schedule_ = getDefaultInstance().getSchedule();
      bitField0_ = (bitField0_ & ~0x00000040);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Schedule resource name. It will only appear when this job is
     * triggered by a schedule.
     * </pre>
     *
     * <code>
     * string schedule = 7 [(.google.api.field_behavior) = OUTPUT_ONLY, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @param value The bytes for schedule to set.
     * @return This builder for chaining.
     */
    public Builder setScheduleBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      schedule_ = value;
      bitField0_ |= 0x00000040;
      onChanged();
      return this;
    }

    private com.google.cloud.aiplatform.v1beta1.ModelMonitoringJobExecutionDetail
        jobExecutionDetail_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.aiplatform.v1beta1.ModelMonitoringJobExecutionDetail,
            com.google.cloud.aiplatform.v1beta1.ModelMonitoringJobExecutionDetail.Builder,
            com.google.cloud.aiplatform.v1beta1.ModelMonitoringJobExecutionDetailOrBuilder>
        jobExecutionDetailBuilder_;
    /**
     *
     *
     * <pre>
     * Output only. Execution results for all the monitoring objectives.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.ModelMonitoringJobExecutionDetail job_execution_detail = 8 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return Whether the jobExecutionDetail field is set.
     */
    public boolean hasJobExecutionDetail() {
      return ((bitField0_ & 0x00000080) != 0);
    }
    /**
     *
     *
     * <pre>
     * Output only. Execution results for all the monitoring objectives.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.ModelMonitoringJobExecutionDetail job_execution_detail = 8 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return The jobExecutionDetail.
     */
    public com.google.cloud.aiplatform.v1beta1.ModelMonitoringJobExecutionDetail
        getJobExecutionDetail() {
      if (jobExecutionDetailBuilder_ == null) {
        return jobExecutionDetail_ == null
            ? com.google.cloud.aiplatform.v1beta1.ModelMonitoringJobExecutionDetail
                .getDefaultInstance()
            : jobExecutionDetail_;
      } else {
        return jobExecutionDetailBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. Execution results for all the monitoring objectives.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.ModelMonitoringJobExecutionDetail job_execution_detail = 8 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder setJobExecutionDetail(
        com.google.cloud.aiplatform.v1beta1.ModelMonitoringJobExecutionDetail value) {
      if (jobExecutionDetailBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        jobExecutionDetail_ = value;
      } else {
        jobExecutionDetailBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000080;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Execution results for all the monitoring objectives.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.ModelMonitoringJobExecutionDetail job_execution_detail = 8 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder setJobExecutionDetail(
        com.google.cloud.aiplatform.v1beta1.ModelMonitoringJobExecutionDetail.Builder
            builderForValue) {
      if (jobExecutionDetailBuilder_ == null) {
        jobExecutionDetail_ = builderForValue.build();
      } else {
        jobExecutionDetailBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000080;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Execution results for all the monitoring objectives.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.ModelMonitoringJobExecutionDetail job_execution_detail = 8 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder mergeJobExecutionDetail(
        com.google.cloud.aiplatform.v1beta1.ModelMonitoringJobExecutionDetail value) {
      if (jobExecutionDetailBuilder_ == null) {
        if (((bitField0_ & 0x00000080) != 0)
            && jobExecutionDetail_ != null
            && jobExecutionDetail_
                != com.google.cloud.aiplatform.v1beta1.ModelMonitoringJobExecutionDetail
                    .getDefaultInstance()) {
          getJobExecutionDetailBuilder().mergeFrom(value);
        } else {
          jobExecutionDetail_ = value;
        }
      } else {
        jobExecutionDetailBuilder_.mergeFrom(value);
      }
      if (jobExecutionDetail_ != null) {
        bitField0_ |= 0x00000080;
        onChanged();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Execution results for all the monitoring objectives.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.ModelMonitoringJobExecutionDetail job_execution_detail = 8 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder clearJobExecutionDetail() {
      bitField0_ = (bitField0_ & ~0x00000080);
      jobExecutionDetail_ = null;
      if (jobExecutionDetailBuilder_ != null) {
        jobExecutionDetailBuilder_.dispose();
        jobExecutionDetailBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Execution results for all the monitoring objectives.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.ModelMonitoringJobExecutionDetail job_execution_detail = 8 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.cloud.aiplatform.v1beta1.ModelMonitoringJobExecutionDetail.Builder
        getJobExecutionDetailBuilder() {
      bitField0_ |= 0x00000080;
      onChanged();
      return getJobExecutionDetailFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Output only. Execution results for all the monitoring objectives.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.ModelMonitoringJobExecutionDetail job_execution_detail = 8 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.cloud.aiplatform.v1beta1.ModelMonitoringJobExecutionDetailOrBuilder
        getJobExecutionDetailOrBuilder() {
      if (jobExecutionDetailBuilder_ != null) {
        return jobExecutionDetailBuilder_.getMessageOrBuilder();
      } else {
        return jobExecutionDetail_ == null
            ? com.google.cloud.aiplatform.v1beta1.ModelMonitoringJobExecutionDetail
                .getDefaultInstance()
            : jobExecutionDetail_;
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. Execution results for all the monitoring objectives.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.ModelMonitoringJobExecutionDetail job_execution_detail = 8 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.aiplatform.v1beta1.ModelMonitoringJobExecutionDetail,
            com.google.cloud.aiplatform.v1beta1.ModelMonitoringJobExecutionDetail.Builder,
            com.google.cloud.aiplatform.v1beta1.ModelMonitoringJobExecutionDetailOrBuilder>
        getJobExecutionDetailFieldBuilder() {
      if (jobExecutionDetailBuilder_ == null) {
        jobExecutionDetailBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.aiplatform.v1beta1.ModelMonitoringJobExecutionDetail,
                com.google.cloud.aiplatform.v1beta1.ModelMonitoringJobExecutionDetail.Builder,
                com.google.cloud.aiplatform.v1beta1.ModelMonitoringJobExecutionDetailOrBuilder>(
                getJobExecutionDetail(), getParentForChildren(), isClean());
        jobExecutionDetail_ = null;
      }
      return jobExecutionDetailBuilder_;
    }

    private com.google.protobuf.Timestamp scheduleTime_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Timestamp,
            com.google.protobuf.Timestamp.Builder,
            com.google.protobuf.TimestampOrBuilder>
        scheduleTimeBuilder_;
    /**
     *
     *
     * <pre>
     * Output only. Timestamp when this ModelMonitoringJob was scheduled. It will
     * only appear when this job is triggered by a schedule.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp schedule_time = 9 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return Whether the scheduleTime field is set.
     */
    public boolean hasScheduleTime() {
      return ((bitField0_ & 0x00000100) != 0);
    }
    /**
     *
     *
     * <pre>
     * Output only. Timestamp when this ModelMonitoringJob was scheduled. It will
     * only appear when this job is triggered by a schedule.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp schedule_time = 9 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return The scheduleTime.
     */
    public com.google.protobuf.Timestamp getScheduleTime() {
      if (scheduleTimeBuilder_ == null) {
        return scheduleTime_ == null
            ? com.google.protobuf.Timestamp.getDefaultInstance()
            : scheduleTime_;
      } else {
        return scheduleTimeBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. Timestamp when this ModelMonitoringJob was scheduled. It will
     * only appear when this job is triggered by a schedule.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp schedule_time = 9 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder setScheduleTime(com.google.protobuf.Timestamp value) {
      if (scheduleTimeBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        scheduleTime_ = value;
      } else {
        scheduleTimeBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000100;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Timestamp when this ModelMonitoringJob was scheduled. It will
     * only appear when this job is triggered by a schedule.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp schedule_time = 9 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder setScheduleTime(com.google.protobuf.Timestamp.Builder builderForValue) {
      if (scheduleTimeBuilder_ == null) {
        scheduleTime_ = builderForValue.build();
      } else {
        scheduleTimeBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000100;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Timestamp when this ModelMonitoringJob was scheduled. It will
     * only appear when this job is triggered by a schedule.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp schedule_time = 9 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder mergeScheduleTime(com.google.protobuf.Timestamp value) {
      if (scheduleTimeBuilder_ == null) {
        if (((bitField0_ & 0x00000100) != 0)
            && scheduleTime_ != null
            && scheduleTime_ != com.google.protobuf.Timestamp.getDefaultInstance()) {
          getScheduleTimeBuilder().mergeFrom(value);
        } else {
          scheduleTime_ = value;
        }
      } else {
        scheduleTimeBuilder_.mergeFrom(value);
      }
      if (scheduleTime_ != null) {
        bitField0_ |= 0x00000100;
        onChanged();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Timestamp when this ModelMonitoringJob was scheduled. It will
     * only appear when this job is triggered by a schedule.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp schedule_time = 9 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder clearScheduleTime() {
      bitField0_ = (bitField0_ & ~0x00000100);
      scheduleTime_ = null;
      if (scheduleTimeBuilder_ != null) {
        scheduleTimeBuilder_.dispose();
        scheduleTimeBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Timestamp when this ModelMonitoringJob was scheduled. It will
     * only appear when this job is triggered by a schedule.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp schedule_time = 9 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.protobuf.Timestamp.Builder getScheduleTimeBuilder() {
      bitField0_ |= 0x00000100;
      onChanged();
      return getScheduleTimeFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Output only. Timestamp when this ModelMonitoringJob was scheduled. It will
     * only appear when this job is triggered by a schedule.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp schedule_time = 9 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.protobuf.TimestampOrBuilder getScheduleTimeOrBuilder() {
      if (scheduleTimeBuilder_ != null) {
        return scheduleTimeBuilder_.getMessageOrBuilder();
      } else {
        return scheduleTime_ == null
            ? com.google.protobuf.Timestamp.getDefaultInstance()
            : scheduleTime_;
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. Timestamp when this ModelMonitoringJob was scheduled. It will
     * only appear when this job is triggered by a schedule.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp schedule_time = 9 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Timestamp,
            com.google.protobuf.Timestamp.Builder,
            com.google.protobuf.TimestampOrBuilder>
        getScheduleTimeFieldBuilder() {
      if (scheduleTimeBuilder_ == null) {
        scheduleTimeBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.protobuf.Timestamp,
                com.google.protobuf.Timestamp.Builder,
                com.google.protobuf.TimestampOrBuilder>(
                getScheduleTime(), getParentForChildren(), isClean());
        scheduleTime_ = null;
      }
      return scheduleTimeBuilder_;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.cloud.aiplatform.v1beta1.ModelMonitoringJob)
  }

  // @@protoc_insertion_point(class_scope:google.cloud.aiplatform.v1beta1.ModelMonitoringJob)
  private static final com.google.cloud.aiplatform.v1beta1.ModelMonitoringJob DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.cloud.aiplatform.v1beta1.ModelMonitoringJob();
  }

  public static com.google.cloud.aiplatform.v1beta1.ModelMonitoringJob getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<ModelMonitoringJob> PARSER =
      new com.google.protobuf.AbstractParser<ModelMonitoringJob>() {
        @java.lang.Override
        public ModelMonitoringJob parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          Builder builder = newBuilder();
          try {
            builder.mergeFrom(input, extensionRegistry);
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.setUnfinishedMessage(builder.buildPartial());
          } catch (com.google.protobuf.UninitializedMessageException e) {
            throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
          } catch (java.io.IOException e) {
            throw new com.google.protobuf.InvalidProtocolBufferException(e)
                .setUnfinishedMessage(builder.buildPartial());
          }
          return builder.buildPartial();
        }
      };

  public static com.google.protobuf.Parser<ModelMonitoringJob> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<ModelMonitoringJob> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.cloud.aiplatform.v1beta1.ModelMonitoringJob getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
