/*
 * Copyright 2020 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/cloud/aiplatform/v1beta1/metadata_service.proto

package com.google.cloud.aiplatform.v1beta1;

/**
 *
 *
 * <pre>
 * Request message for [MetadataService.AddContextArtifactsAndExecutions][google.cloud.aiplatform.v1beta1.MetadataService.AddContextArtifactsAndExecutions].
 * </pre>
 *
 * Protobuf type {@code google.cloud.aiplatform.v1beta1.AddContextArtifactsAndExecutionsRequest}
 */
public final class AddContextArtifactsAndExecutionsRequest
    extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.cloud.aiplatform.v1beta1.AddContextArtifactsAndExecutionsRequest)
    AddContextArtifactsAndExecutionsRequestOrBuilder {
  private static final long serialVersionUID = 0L;
  // Use AddContextArtifactsAndExecutionsRequest.newBuilder() to construct.
  private AddContextArtifactsAndExecutionsRequest(
      com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private AddContextArtifactsAndExecutionsRequest() {
    context_ = "";
    artifacts_ = com.google.protobuf.LazyStringArrayList.EMPTY;
    executions_ = com.google.protobuf.LazyStringArrayList.EMPTY;
  }

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new AddContextArtifactsAndExecutionsRequest();
  }

  @java.lang.Override
  public final com.google.protobuf.UnknownFieldSet getUnknownFields() {
    return this.unknownFields;
  }

  private AddContextArtifactsAndExecutionsRequest(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    this();
    if (extensionRegistry == null) {
      throw new java.lang.NullPointerException();
    }
    int mutable_bitField0_ = 0;
    com.google.protobuf.UnknownFieldSet.Builder unknownFields =
        com.google.protobuf.UnknownFieldSet.newBuilder();
    try {
      boolean done = false;
      while (!done) {
        int tag = input.readTag();
        switch (tag) {
          case 0:
            done = true;
            break;
          case 10:
            {
              java.lang.String s = input.readStringRequireUtf8();

              context_ = s;
              break;
            }
          case 18:
            {
              java.lang.String s = input.readStringRequireUtf8();
              if (!((mutable_bitField0_ & 0x00000001) != 0)) {
                artifacts_ = new com.google.protobuf.LazyStringArrayList();
                mutable_bitField0_ |= 0x00000001;
              }
              artifacts_.add(s);
              break;
            }
          case 26:
            {
              java.lang.String s = input.readStringRequireUtf8();
              if (!((mutable_bitField0_ & 0x00000002) != 0)) {
                executions_ = new com.google.protobuf.LazyStringArrayList();
                mutable_bitField0_ |= 0x00000002;
              }
              executions_.add(s);
              break;
            }
          default:
            {
              if (!parseUnknownField(input, unknownFields, extensionRegistry, tag)) {
                done = true;
              }
              break;
            }
        }
      }
    } catch (com.google.protobuf.InvalidProtocolBufferException e) {
      throw e.setUnfinishedMessage(this);
    } catch (java.io.IOException e) {
      throw new com.google.protobuf.InvalidProtocolBufferException(e).setUnfinishedMessage(this);
    } finally {
      if (((mutable_bitField0_ & 0x00000001) != 0)) {
        artifacts_ = artifacts_.getUnmodifiableView();
      }
      if (((mutable_bitField0_ & 0x00000002) != 0)) {
        executions_ = executions_.getUnmodifiableView();
      }
      this.unknownFields = unknownFields.build();
      makeExtensionsImmutable();
    }
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.cloud.aiplatform.v1beta1.MetadataServiceProto
        .internal_static_google_cloud_aiplatform_v1beta1_AddContextArtifactsAndExecutionsRequest_descriptor;
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.cloud.aiplatform.v1beta1.MetadataServiceProto
        .internal_static_google_cloud_aiplatform_v1beta1_AddContextArtifactsAndExecutionsRequest_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.cloud.aiplatform.v1beta1.AddContextArtifactsAndExecutionsRequest.class,
            com.google.cloud.aiplatform.v1beta1.AddContextArtifactsAndExecutionsRequest.Builder
                .class);
  }

  public static final int CONTEXT_FIELD_NUMBER = 1;
  private volatile java.lang.Object context_;
  /**
   *
   *
   * <pre>
   * Required. The resource name of the Context that the Artifacts and Executions
   * belong to.
   * Format:
   * projects/{project}/locations/{location}/metadataStores/{metadatastore}/contexts/{context}
   * </pre>
   *
   * <code>
   * string context = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
   * </code>
   *
   * @return The context.
   */
  @java.lang.Override
  public java.lang.String getContext() {
    java.lang.Object ref = context_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      context_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Required. The resource name of the Context that the Artifacts and Executions
   * belong to.
   * Format:
   * projects/{project}/locations/{location}/metadataStores/{metadatastore}/contexts/{context}
   * </pre>
   *
   * <code>
   * string context = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
   * </code>
   *
   * @return The bytes for context.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getContextBytes() {
    java.lang.Object ref = context_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      context_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int ARTIFACTS_FIELD_NUMBER = 2;
  private com.google.protobuf.LazyStringList artifacts_;
  /**
   *
   *
   * <pre>
   * The resource names of the Artifacts to attribute to the Context.
   * Format:
   * projects/{project}/locations/{location}/metadataStores/{metadatastore}/artifacts/{artifact}
   * </pre>
   *
   * <code>repeated string artifacts = 2 [(.google.api.resource_reference) = { ... }</code>
   *
   * @return A list containing the artifacts.
   */
  public com.google.protobuf.ProtocolStringList getArtifactsList() {
    return artifacts_;
  }
  /**
   *
   *
   * <pre>
   * The resource names of the Artifacts to attribute to the Context.
   * Format:
   * projects/{project}/locations/{location}/metadataStores/{metadatastore}/artifacts/{artifact}
   * </pre>
   *
   * <code>repeated string artifacts = 2 [(.google.api.resource_reference) = { ... }</code>
   *
   * @return The count of artifacts.
   */
  public int getArtifactsCount() {
    return artifacts_.size();
  }
  /**
   *
   *
   * <pre>
   * The resource names of the Artifacts to attribute to the Context.
   * Format:
   * projects/{project}/locations/{location}/metadataStores/{metadatastore}/artifacts/{artifact}
   * </pre>
   *
   * <code>repeated string artifacts = 2 [(.google.api.resource_reference) = { ... }</code>
   *
   * @param index The index of the element to return.
   * @return The artifacts at the given index.
   */
  public java.lang.String getArtifacts(int index) {
    return artifacts_.get(index);
  }
  /**
   *
   *
   * <pre>
   * The resource names of the Artifacts to attribute to the Context.
   * Format:
   * projects/{project}/locations/{location}/metadataStores/{metadatastore}/artifacts/{artifact}
   * </pre>
   *
   * <code>repeated string artifacts = 2 [(.google.api.resource_reference) = { ... }</code>
   *
   * @param index The index of the value to return.
   * @return The bytes of the artifacts at the given index.
   */
  public com.google.protobuf.ByteString getArtifactsBytes(int index) {
    return artifacts_.getByteString(index);
  }

  public static final int EXECUTIONS_FIELD_NUMBER = 3;
  private com.google.protobuf.LazyStringList executions_;
  /**
   *
   *
   * <pre>
   * The resource names of the Executions to associate with the
   * Context.
   * Format:
   * projects/{project}/locations/{location}/metadataStores/{metadatastore}/executions/{execution}
   * </pre>
   *
   * <code>repeated string executions = 3 [(.google.api.resource_reference) = { ... }</code>
   *
   * @return A list containing the executions.
   */
  public com.google.protobuf.ProtocolStringList getExecutionsList() {
    return executions_;
  }
  /**
   *
   *
   * <pre>
   * The resource names of the Executions to associate with the
   * Context.
   * Format:
   * projects/{project}/locations/{location}/metadataStores/{metadatastore}/executions/{execution}
   * </pre>
   *
   * <code>repeated string executions = 3 [(.google.api.resource_reference) = { ... }</code>
   *
   * @return The count of executions.
   */
  public int getExecutionsCount() {
    return executions_.size();
  }
  /**
   *
   *
   * <pre>
   * The resource names of the Executions to associate with the
   * Context.
   * Format:
   * projects/{project}/locations/{location}/metadataStores/{metadatastore}/executions/{execution}
   * </pre>
   *
   * <code>repeated string executions = 3 [(.google.api.resource_reference) = { ... }</code>
   *
   * @param index The index of the element to return.
   * @return The executions at the given index.
   */
  public java.lang.String getExecutions(int index) {
    return executions_.get(index);
  }
  /**
   *
   *
   * <pre>
   * The resource names of the Executions to associate with the
   * Context.
   * Format:
   * projects/{project}/locations/{location}/metadataStores/{metadatastore}/executions/{execution}
   * </pre>
   *
   * <code>repeated string executions = 3 [(.google.api.resource_reference) = { ... }</code>
   *
   * @param index The index of the value to return.
   * @return The bytes of the executions at the given index.
   */
  public com.google.protobuf.ByteString getExecutionsBytes(int index) {
    return executions_.getByteString(index);
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    if (!getContextBytes().isEmpty()) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 1, context_);
    }
    for (int i = 0; i < artifacts_.size(); i++) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 2, artifacts_.getRaw(i));
    }
    for (int i = 0; i < executions_.size(); i++) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 3, executions_.getRaw(i));
    }
    unknownFields.writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    if (!getContextBytes().isEmpty()) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(1, context_);
    }
    {
      int dataSize = 0;
      for (int i = 0; i < artifacts_.size(); i++) {
        dataSize += computeStringSizeNoTag(artifacts_.getRaw(i));
      }
      size += dataSize;
      size += 1 * getArtifactsList().size();
    }
    {
      int dataSize = 0;
      for (int i = 0; i < executions_.size(); i++) {
        dataSize += computeStringSizeNoTag(executions_.getRaw(i));
      }
      size += dataSize;
      size += 1 * getExecutionsList().size();
    }
    size += unknownFields.getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj
        instanceof com.google.cloud.aiplatform.v1beta1.AddContextArtifactsAndExecutionsRequest)) {
      return super.equals(obj);
    }
    com.google.cloud.aiplatform.v1beta1.AddContextArtifactsAndExecutionsRequest other =
        (com.google.cloud.aiplatform.v1beta1.AddContextArtifactsAndExecutionsRequest) obj;

    if (!getContext().equals(other.getContext())) return false;
    if (!getArtifactsList().equals(other.getArtifactsList())) return false;
    if (!getExecutionsList().equals(other.getExecutionsList())) return false;
    if (!unknownFields.equals(other.unknownFields)) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    hash = (37 * hash) + CONTEXT_FIELD_NUMBER;
    hash = (53 * hash) + getContext().hashCode();
    if (getArtifactsCount() > 0) {
      hash = (37 * hash) + ARTIFACTS_FIELD_NUMBER;
      hash = (53 * hash) + getArtifactsList().hashCode();
    }
    if (getExecutionsCount() > 0) {
      hash = (37 * hash) + EXECUTIONS_FIELD_NUMBER;
      hash = (53 * hash) + getExecutionsList().hashCode();
    }
    hash = (29 * hash) + unknownFields.hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.cloud.aiplatform.v1beta1.AddContextArtifactsAndExecutionsRequest
      parseFrom(java.nio.ByteBuffer data)
          throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.aiplatform.v1beta1.AddContextArtifactsAndExecutionsRequest
      parseFrom(
          java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.aiplatform.v1beta1.AddContextArtifactsAndExecutionsRequest
      parseFrom(com.google.protobuf.ByteString data)
          throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.aiplatform.v1beta1.AddContextArtifactsAndExecutionsRequest
      parseFrom(
          com.google.protobuf.ByteString data,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.aiplatform.v1beta1.AddContextArtifactsAndExecutionsRequest
      parseFrom(byte[] data) throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.aiplatform.v1beta1.AddContextArtifactsAndExecutionsRequest
      parseFrom(byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.aiplatform.v1beta1.AddContextArtifactsAndExecutionsRequest
      parseFrom(java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.aiplatform.v1beta1.AddContextArtifactsAndExecutionsRequest
      parseFrom(
          java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.aiplatform.v1beta1.AddContextArtifactsAndExecutionsRequest
      parseDelimitedFrom(java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.cloud.aiplatform.v1beta1.AddContextArtifactsAndExecutionsRequest
      parseDelimitedFrom(
          java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.aiplatform.v1beta1.AddContextArtifactsAndExecutionsRequest
      parseFrom(com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.aiplatform.v1beta1.AddContextArtifactsAndExecutionsRequest
      parseFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(
      com.google.cloud.aiplatform.v1beta1.AddContextArtifactsAndExecutionsRequest prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }
  /**
   *
   *
   * <pre>
   * Request message for [MetadataService.AddContextArtifactsAndExecutions][google.cloud.aiplatform.v1beta1.MetadataService.AddContextArtifactsAndExecutions].
   * </pre>
   *
   * Protobuf type {@code google.cloud.aiplatform.v1beta1.AddContextArtifactsAndExecutionsRequest}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.cloud.aiplatform.v1beta1.AddContextArtifactsAndExecutionsRequest)
      com.google.cloud.aiplatform.v1beta1.AddContextArtifactsAndExecutionsRequestOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.aiplatform.v1beta1.MetadataServiceProto
          .internal_static_google_cloud_aiplatform_v1beta1_AddContextArtifactsAndExecutionsRequest_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.aiplatform.v1beta1.MetadataServiceProto
          .internal_static_google_cloud_aiplatform_v1beta1_AddContextArtifactsAndExecutionsRequest_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.aiplatform.v1beta1.AddContextArtifactsAndExecutionsRequest.class,
              com.google.cloud.aiplatform.v1beta1.AddContextArtifactsAndExecutionsRequest.Builder
                  .class);
    }

    // Construct using
    // com.google.cloud.aiplatform.v1beta1.AddContextArtifactsAndExecutionsRequest.newBuilder()
    private Builder() {
      maybeForceBuilderInitialization();
    }

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
      maybeForceBuilderInitialization();
    }

    private void maybeForceBuilderInitialization() {
      if (com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders) {}
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      context_ = "";

      artifacts_ = com.google.protobuf.LazyStringArrayList.EMPTY;
      bitField0_ = (bitField0_ & ~0x00000001);
      executions_ = com.google.protobuf.LazyStringArrayList.EMPTY;
      bitField0_ = (bitField0_ & ~0x00000002);
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.cloud.aiplatform.v1beta1.MetadataServiceProto
          .internal_static_google_cloud_aiplatform_v1beta1_AddContextArtifactsAndExecutionsRequest_descriptor;
    }

    @java.lang.Override
    public com.google.cloud.aiplatform.v1beta1.AddContextArtifactsAndExecutionsRequest
        getDefaultInstanceForType() {
      return com.google.cloud.aiplatform.v1beta1.AddContextArtifactsAndExecutionsRequest
          .getDefaultInstance();
    }

    @java.lang.Override
    public com.google.cloud.aiplatform.v1beta1.AddContextArtifactsAndExecutionsRequest build() {
      com.google.cloud.aiplatform.v1beta1.AddContextArtifactsAndExecutionsRequest result =
          buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.cloud.aiplatform.v1beta1.AddContextArtifactsAndExecutionsRequest
        buildPartial() {
      com.google.cloud.aiplatform.v1beta1.AddContextArtifactsAndExecutionsRequest result =
          new com.google.cloud.aiplatform.v1beta1.AddContextArtifactsAndExecutionsRequest(this);
      int from_bitField0_ = bitField0_;
      result.context_ = context_;
      if (((bitField0_ & 0x00000001) != 0)) {
        artifacts_ = artifacts_.getUnmodifiableView();
        bitField0_ = (bitField0_ & ~0x00000001);
      }
      result.artifacts_ = artifacts_;
      if (((bitField0_ & 0x00000002) != 0)) {
        executions_ = executions_.getUnmodifiableView();
        bitField0_ = (bitField0_ & ~0x00000002);
      }
      result.executions_ = executions_;
      onBuilt();
      return result;
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other
          instanceof com.google.cloud.aiplatform.v1beta1.AddContextArtifactsAndExecutionsRequest) {
        return mergeFrom(
            (com.google.cloud.aiplatform.v1beta1.AddContextArtifactsAndExecutionsRequest) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(
        com.google.cloud.aiplatform.v1beta1.AddContextArtifactsAndExecutionsRequest other) {
      if (other
          == com.google.cloud.aiplatform.v1beta1.AddContextArtifactsAndExecutionsRequest
              .getDefaultInstance()) return this;
      if (!other.getContext().isEmpty()) {
        context_ = other.context_;
        onChanged();
      }
      if (!other.artifacts_.isEmpty()) {
        if (artifacts_.isEmpty()) {
          artifacts_ = other.artifacts_;
          bitField0_ = (bitField0_ & ~0x00000001);
        } else {
          ensureArtifactsIsMutable();
          artifacts_.addAll(other.artifacts_);
        }
        onChanged();
      }
      if (!other.executions_.isEmpty()) {
        if (executions_.isEmpty()) {
          executions_ = other.executions_;
          bitField0_ = (bitField0_ & ~0x00000002);
        } else {
          ensureExecutionsIsMutable();
          executions_.addAll(other.executions_);
        }
        onChanged();
      }
      this.mergeUnknownFields(other.unknownFields);
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      com.google.cloud.aiplatform.v1beta1.AddContextArtifactsAndExecutionsRequest parsedMessage =
          null;
      try {
        parsedMessage = PARSER.parsePartialFrom(input, extensionRegistry);
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        parsedMessage =
            (com.google.cloud.aiplatform.v1beta1.AddContextArtifactsAndExecutionsRequest)
                e.getUnfinishedMessage();
        throw e.unwrapIOException();
      } finally {
        if (parsedMessage != null) {
          mergeFrom(parsedMessage);
        }
      }
      return this;
    }

    private int bitField0_;

    private java.lang.Object context_ = "";
    /**
     *
     *
     * <pre>
     * Required. The resource name of the Context that the Artifacts and Executions
     * belong to.
     * Format:
     * projects/{project}/locations/{location}/metadataStores/{metadatastore}/contexts/{context}
     * </pre>
     *
     * <code>
     * string context = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @return The context.
     */
    public java.lang.String getContext() {
      java.lang.Object ref = context_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        context_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Required. The resource name of the Context that the Artifacts and Executions
     * belong to.
     * Format:
     * projects/{project}/locations/{location}/metadataStores/{metadatastore}/contexts/{context}
     * </pre>
     *
     * <code>
     * string context = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @return The bytes for context.
     */
    public com.google.protobuf.ByteString getContextBytes() {
      java.lang.Object ref = context_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        context_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Required. The resource name of the Context that the Artifacts and Executions
     * belong to.
     * Format:
     * projects/{project}/locations/{location}/metadataStores/{metadatastore}/contexts/{context}
     * </pre>
     *
     * <code>
     * string context = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @param value The context to set.
     * @return This builder for chaining.
     */
    public Builder setContext(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }

      context_ = value;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. The resource name of the Context that the Artifacts and Executions
     * belong to.
     * Format:
     * projects/{project}/locations/{location}/metadataStores/{metadatastore}/contexts/{context}
     * </pre>
     *
     * <code>
     * string context = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @return This builder for chaining.
     */
    public Builder clearContext() {

      context_ = getDefaultInstance().getContext();
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. The resource name of the Context that the Artifacts and Executions
     * belong to.
     * Format:
     * projects/{project}/locations/{location}/metadataStores/{metadatastore}/contexts/{context}
     * </pre>
     *
     * <code>
     * string context = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @param value The bytes for context to set.
     * @return This builder for chaining.
     */
    public Builder setContextBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);

      context_ = value;
      onChanged();
      return this;
    }

    private com.google.protobuf.LazyStringList artifacts_ =
        com.google.protobuf.LazyStringArrayList.EMPTY;

    private void ensureArtifactsIsMutable() {
      if (!((bitField0_ & 0x00000001) != 0)) {
        artifacts_ = new com.google.protobuf.LazyStringArrayList(artifacts_);
        bitField0_ |= 0x00000001;
      }
    }
    /**
     *
     *
     * <pre>
     * The resource names of the Artifacts to attribute to the Context.
     * Format:
     * projects/{project}/locations/{location}/metadataStores/{metadatastore}/artifacts/{artifact}
     * </pre>
     *
     * <code>repeated string artifacts = 2 [(.google.api.resource_reference) = { ... }</code>
     *
     * @return A list containing the artifacts.
     */
    public com.google.protobuf.ProtocolStringList getArtifactsList() {
      return artifacts_.getUnmodifiableView();
    }
    /**
     *
     *
     * <pre>
     * The resource names of the Artifacts to attribute to the Context.
     * Format:
     * projects/{project}/locations/{location}/metadataStores/{metadatastore}/artifacts/{artifact}
     * </pre>
     *
     * <code>repeated string artifacts = 2 [(.google.api.resource_reference) = { ... }</code>
     *
     * @return The count of artifacts.
     */
    public int getArtifactsCount() {
      return artifacts_.size();
    }
    /**
     *
     *
     * <pre>
     * The resource names of the Artifacts to attribute to the Context.
     * Format:
     * projects/{project}/locations/{location}/metadataStores/{metadatastore}/artifacts/{artifact}
     * </pre>
     *
     * <code>repeated string artifacts = 2 [(.google.api.resource_reference) = { ... }</code>
     *
     * @param index The index of the element to return.
     * @return The artifacts at the given index.
     */
    public java.lang.String getArtifacts(int index) {
      return artifacts_.get(index);
    }
    /**
     *
     *
     * <pre>
     * The resource names of the Artifacts to attribute to the Context.
     * Format:
     * projects/{project}/locations/{location}/metadataStores/{metadatastore}/artifacts/{artifact}
     * </pre>
     *
     * <code>repeated string artifacts = 2 [(.google.api.resource_reference) = { ... }</code>
     *
     * @param index The index of the value to return.
     * @return The bytes of the artifacts at the given index.
     */
    public com.google.protobuf.ByteString getArtifactsBytes(int index) {
      return artifacts_.getByteString(index);
    }
    /**
     *
     *
     * <pre>
     * The resource names of the Artifacts to attribute to the Context.
     * Format:
     * projects/{project}/locations/{location}/metadataStores/{metadatastore}/artifacts/{artifact}
     * </pre>
     *
     * <code>repeated string artifacts = 2 [(.google.api.resource_reference) = { ... }</code>
     *
     * @param index The index to set the value at.
     * @param value The artifacts to set.
     * @return This builder for chaining.
     */
    public Builder setArtifacts(int index, java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      ensureArtifactsIsMutable();
      artifacts_.set(index, value);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The resource names of the Artifacts to attribute to the Context.
     * Format:
     * projects/{project}/locations/{location}/metadataStores/{metadatastore}/artifacts/{artifact}
     * </pre>
     *
     * <code>repeated string artifacts = 2 [(.google.api.resource_reference) = { ... }</code>
     *
     * @param value The artifacts to add.
     * @return This builder for chaining.
     */
    public Builder addArtifacts(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      ensureArtifactsIsMutable();
      artifacts_.add(value);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The resource names of the Artifacts to attribute to the Context.
     * Format:
     * projects/{project}/locations/{location}/metadataStores/{metadatastore}/artifacts/{artifact}
     * </pre>
     *
     * <code>repeated string artifacts = 2 [(.google.api.resource_reference) = { ... }</code>
     *
     * @param values The artifacts to add.
     * @return This builder for chaining.
     */
    public Builder addAllArtifacts(java.lang.Iterable<java.lang.String> values) {
      ensureArtifactsIsMutable();
      com.google.protobuf.AbstractMessageLite.Builder.addAll(values, artifacts_);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The resource names of the Artifacts to attribute to the Context.
     * Format:
     * projects/{project}/locations/{location}/metadataStores/{metadatastore}/artifacts/{artifact}
     * </pre>
     *
     * <code>repeated string artifacts = 2 [(.google.api.resource_reference) = { ... }</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearArtifacts() {
      artifacts_ = com.google.protobuf.LazyStringArrayList.EMPTY;
      bitField0_ = (bitField0_ & ~0x00000001);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The resource names of the Artifacts to attribute to the Context.
     * Format:
     * projects/{project}/locations/{location}/metadataStores/{metadatastore}/artifacts/{artifact}
     * </pre>
     *
     * <code>repeated string artifacts = 2 [(.google.api.resource_reference) = { ... }</code>
     *
     * @param value The bytes of the artifacts to add.
     * @return This builder for chaining.
     */
    public Builder addArtifactsBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      ensureArtifactsIsMutable();
      artifacts_.add(value);
      onChanged();
      return this;
    }

    private com.google.protobuf.LazyStringList executions_ =
        com.google.protobuf.LazyStringArrayList.EMPTY;

    private void ensureExecutionsIsMutable() {
      if (!((bitField0_ & 0x00000002) != 0)) {
        executions_ = new com.google.protobuf.LazyStringArrayList(executions_);
        bitField0_ |= 0x00000002;
      }
    }
    /**
     *
     *
     * <pre>
     * The resource names of the Executions to associate with the
     * Context.
     * Format:
     * projects/{project}/locations/{location}/metadataStores/{metadatastore}/executions/{execution}
     * </pre>
     *
     * <code>repeated string executions = 3 [(.google.api.resource_reference) = { ... }</code>
     *
     * @return A list containing the executions.
     */
    public com.google.protobuf.ProtocolStringList getExecutionsList() {
      return executions_.getUnmodifiableView();
    }
    /**
     *
     *
     * <pre>
     * The resource names of the Executions to associate with the
     * Context.
     * Format:
     * projects/{project}/locations/{location}/metadataStores/{metadatastore}/executions/{execution}
     * </pre>
     *
     * <code>repeated string executions = 3 [(.google.api.resource_reference) = { ... }</code>
     *
     * @return The count of executions.
     */
    public int getExecutionsCount() {
      return executions_.size();
    }
    /**
     *
     *
     * <pre>
     * The resource names of the Executions to associate with the
     * Context.
     * Format:
     * projects/{project}/locations/{location}/metadataStores/{metadatastore}/executions/{execution}
     * </pre>
     *
     * <code>repeated string executions = 3 [(.google.api.resource_reference) = { ... }</code>
     *
     * @param index The index of the element to return.
     * @return The executions at the given index.
     */
    public java.lang.String getExecutions(int index) {
      return executions_.get(index);
    }
    /**
     *
     *
     * <pre>
     * The resource names of the Executions to associate with the
     * Context.
     * Format:
     * projects/{project}/locations/{location}/metadataStores/{metadatastore}/executions/{execution}
     * </pre>
     *
     * <code>repeated string executions = 3 [(.google.api.resource_reference) = { ... }</code>
     *
     * @param index The index of the value to return.
     * @return The bytes of the executions at the given index.
     */
    public com.google.protobuf.ByteString getExecutionsBytes(int index) {
      return executions_.getByteString(index);
    }
    /**
     *
     *
     * <pre>
     * The resource names of the Executions to associate with the
     * Context.
     * Format:
     * projects/{project}/locations/{location}/metadataStores/{metadatastore}/executions/{execution}
     * </pre>
     *
     * <code>repeated string executions = 3 [(.google.api.resource_reference) = { ... }</code>
     *
     * @param index The index to set the value at.
     * @param value The executions to set.
     * @return This builder for chaining.
     */
    public Builder setExecutions(int index, java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      ensureExecutionsIsMutable();
      executions_.set(index, value);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The resource names of the Executions to associate with the
     * Context.
     * Format:
     * projects/{project}/locations/{location}/metadataStores/{metadatastore}/executions/{execution}
     * </pre>
     *
     * <code>repeated string executions = 3 [(.google.api.resource_reference) = { ... }</code>
     *
     * @param value The executions to add.
     * @return This builder for chaining.
     */
    public Builder addExecutions(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      ensureExecutionsIsMutable();
      executions_.add(value);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The resource names of the Executions to associate with the
     * Context.
     * Format:
     * projects/{project}/locations/{location}/metadataStores/{metadatastore}/executions/{execution}
     * </pre>
     *
     * <code>repeated string executions = 3 [(.google.api.resource_reference) = { ... }</code>
     *
     * @param values The executions to add.
     * @return This builder for chaining.
     */
    public Builder addAllExecutions(java.lang.Iterable<java.lang.String> values) {
      ensureExecutionsIsMutable();
      com.google.protobuf.AbstractMessageLite.Builder.addAll(values, executions_);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The resource names of the Executions to associate with the
     * Context.
     * Format:
     * projects/{project}/locations/{location}/metadataStores/{metadatastore}/executions/{execution}
     * </pre>
     *
     * <code>repeated string executions = 3 [(.google.api.resource_reference) = { ... }</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearExecutions() {
      executions_ = com.google.protobuf.LazyStringArrayList.EMPTY;
      bitField0_ = (bitField0_ & ~0x00000002);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The resource names of the Executions to associate with the
     * Context.
     * Format:
     * projects/{project}/locations/{location}/metadataStores/{metadatastore}/executions/{execution}
     * </pre>
     *
     * <code>repeated string executions = 3 [(.google.api.resource_reference) = { ... }</code>
     *
     * @param value The bytes of the executions to add.
     * @return This builder for chaining.
     */
    public Builder addExecutionsBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      ensureExecutionsIsMutable();
      executions_.add(value);
      onChanged();
      return this;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.cloud.aiplatform.v1beta1.AddContextArtifactsAndExecutionsRequest)
  }

  // @@protoc_insertion_point(class_scope:google.cloud.aiplatform.v1beta1.AddContextArtifactsAndExecutionsRequest)
  private static final com.google.cloud.aiplatform.v1beta1.AddContextArtifactsAndExecutionsRequest
      DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE =
        new com.google.cloud.aiplatform.v1beta1.AddContextArtifactsAndExecutionsRequest();
  }

  public static com.google.cloud.aiplatform.v1beta1.AddContextArtifactsAndExecutionsRequest
      getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<AddContextArtifactsAndExecutionsRequest> PARSER =
      new com.google.protobuf.AbstractParser<AddContextArtifactsAndExecutionsRequest>() {
        @java.lang.Override
        public AddContextArtifactsAndExecutionsRequest parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          return new AddContextArtifactsAndExecutionsRequest(input, extensionRegistry);
        }
      };

  public static com.google.protobuf.Parser<AddContextArtifactsAndExecutionsRequest> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<AddContextArtifactsAndExecutionsRequest> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.cloud.aiplatform.v1beta1.AddContextArtifactsAndExecutionsRequest
      getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
