/*
 * Copyright 2020 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/cloud/aiplatform/v1beta1/explanation.proto

package com.google.cloud.aiplatform.v1beta1;

/**
 *
 *
 * <pre>
 * Attribution that explains a particular prediction output.
 * </pre>
 *
 * Protobuf type {@code google.cloud.aiplatform.v1beta1.Attribution}
 */
public final class Attribution extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.cloud.aiplatform.v1beta1.Attribution)
    AttributionOrBuilder {
  private static final long serialVersionUID = 0L;
  // Use Attribution.newBuilder() to construct.
  private Attribution(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private Attribution() {
    outputIndex_ = emptyIntList();
    outputDisplayName_ = "";
    outputName_ = "";
  }

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new Attribution();
  }

  @java.lang.Override
  public final com.google.protobuf.UnknownFieldSet getUnknownFields() {
    return this.unknownFields;
  }

  private Attribution(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    this();
    if (extensionRegistry == null) {
      throw new java.lang.NullPointerException();
    }
    int mutable_bitField0_ = 0;
    com.google.protobuf.UnknownFieldSet.Builder unknownFields =
        com.google.protobuf.UnknownFieldSet.newBuilder();
    try {
      boolean done = false;
      while (!done) {
        int tag = input.readTag();
        switch (tag) {
          case 0:
            done = true;
            break;
          case 9:
            {
              baselineOutputValue_ = input.readDouble();
              break;
            }
          case 17:
            {
              instanceOutputValue_ = input.readDouble();
              break;
            }
          case 26:
            {
              com.google.protobuf.Value.Builder subBuilder = null;
              if (featureAttributions_ != null) {
                subBuilder = featureAttributions_.toBuilder();
              }
              featureAttributions_ =
                  input.readMessage(com.google.protobuf.Value.parser(), extensionRegistry);
              if (subBuilder != null) {
                subBuilder.mergeFrom(featureAttributions_);
                featureAttributions_ = subBuilder.buildPartial();
              }

              break;
            }
          case 32:
            {
              if (!((mutable_bitField0_ & 0x00000001) != 0)) {
                outputIndex_ = newIntList();
                mutable_bitField0_ |= 0x00000001;
              }
              outputIndex_.addInt(input.readInt32());
              break;
            }
          case 34:
            {
              int length = input.readRawVarint32();
              int limit = input.pushLimit(length);
              if (!((mutable_bitField0_ & 0x00000001) != 0) && input.getBytesUntilLimit() > 0) {
                outputIndex_ = newIntList();
                mutable_bitField0_ |= 0x00000001;
              }
              while (input.getBytesUntilLimit() > 0) {
                outputIndex_.addInt(input.readInt32());
              }
              input.popLimit(limit);
              break;
            }
          case 42:
            {
              java.lang.String s = input.readStringRequireUtf8();

              outputDisplayName_ = s;
              break;
            }
          case 49:
            {
              approximationError_ = input.readDouble();
              break;
            }
          case 58:
            {
              java.lang.String s = input.readStringRequireUtf8();

              outputName_ = s;
              break;
            }
          default:
            {
              if (!parseUnknownField(input, unknownFields, extensionRegistry, tag)) {
                done = true;
              }
              break;
            }
        }
      }
    } catch (com.google.protobuf.InvalidProtocolBufferException e) {
      throw e.setUnfinishedMessage(this);
    } catch (java.io.IOException e) {
      throw new com.google.protobuf.InvalidProtocolBufferException(e).setUnfinishedMessage(this);
    } finally {
      if (((mutable_bitField0_ & 0x00000001) != 0)) {
        outputIndex_.makeImmutable(); // C
      }
      this.unknownFields = unknownFields.build();
      makeExtensionsImmutable();
    }
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.cloud.aiplatform.v1beta1.ExplanationProto
        .internal_static_google_cloud_aiplatform_v1beta1_Attribution_descriptor;
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.cloud.aiplatform.v1beta1.ExplanationProto
        .internal_static_google_cloud_aiplatform_v1beta1_Attribution_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.cloud.aiplatform.v1beta1.Attribution.class,
            com.google.cloud.aiplatform.v1beta1.Attribution.Builder.class);
  }

  public static final int BASELINE_OUTPUT_VALUE_FIELD_NUMBER = 1;
  private double baselineOutputValue_;
  /**
   *
   *
   * <pre>
   * Output only. Model predicted output if the input instance is constructed from the
   * baselines of all the features defined in [ExplanationMetadata.inputs][google.cloud.aiplatform.v1beta1.ExplanationMetadata.inputs].
   * The field name of the output is determined by the key in
   * [ExplanationMetadata.outputs][google.cloud.aiplatform.v1beta1.ExplanationMetadata.outputs].
   * If the Model's predicted output has multiple dimensions (rank &gt; 1), this is
   * the value in the output located by [output_index][google.cloud.aiplatform.v1beta1.Attribution.output_index].
   * If there are multiple baselines, their output values are averaged.
   * </pre>
   *
   * <code>double baseline_output_value = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
   *
   * @return The baselineOutputValue.
   */
  @java.lang.Override
  public double getBaselineOutputValue() {
    return baselineOutputValue_;
  }

  public static final int INSTANCE_OUTPUT_VALUE_FIELD_NUMBER = 2;
  private double instanceOutputValue_;
  /**
   *
   *
   * <pre>
   * Output only. Model predicted output on the corresponding [explanation
   * instance][ExplainRequest.instances]. The field name of the output is
   * determined by the key in [ExplanationMetadata.outputs][google.cloud.aiplatform.v1beta1.ExplanationMetadata.outputs].
   * If the Model predicted output has multiple dimensions, this is the value in
   * the output located by [output_index][google.cloud.aiplatform.v1beta1.Attribution.output_index].
   * </pre>
   *
   * <code>double instance_output_value = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
   *
   * @return The instanceOutputValue.
   */
  @java.lang.Override
  public double getInstanceOutputValue() {
    return instanceOutputValue_;
  }

  public static final int FEATURE_ATTRIBUTIONS_FIELD_NUMBER = 3;
  private com.google.protobuf.Value featureAttributions_;
  /**
   *
   *
   * <pre>
   * Output only. Attributions of each explained feature. Features are extracted from
   * the [prediction instances][google.cloud.aiplatform.v1beta1.ExplainRequest.instances] according to
   * [explanation metadata for inputs][google.cloud.aiplatform.v1beta1.ExplanationMetadata.inputs].
   * The value is a struct, whose keys are the name of the feature. The values
   * are how much the feature in the [instance][google.cloud.aiplatform.v1beta1.ExplainRequest.instances]
   * contributed to the predicted result.
   * The format of the value is determined by the feature's input format:
   *   * If the feature is a scalar value, the attribution value is a
   *     [floating number][google.protobuf.Value.number_value].
   *   * If the feature is an array of scalar values, the attribution value is
   *     an [array][google.protobuf.Value.list_value].
   *   * If the feature is a struct, the attribution value is a
   *     [struct][google.protobuf.Value.struct_value]. The keys in the
   *     attribution value struct are the same as the keys in the feature
   *     struct. The formats of the values in the attribution struct are
   *     determined by the formats of the values in the feature struct.
   * The [ExplanationMetadata.feature_attributions_schema_uri][google.cloud.aiplatform.v1beta1.ExplanationMetadata.feature_attributions_schema_uri] field,
   * pointed to by the [ExplanationSpec][google.cloud.aiplatform.v1beta1.ExplanationSpec] field of the
   * [Endpoint.deployed_models][google.cloud.aiplatform.v1beta1.Endpoint.deployed_models] object, points to the schema file that
   * describes the features and their attribution values (if it is populated).
   * </pre>
   *
   * <code>
   * .google.protobuf.Value feature_attributions = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return Whether the featureAttributions field is set.
   */
  @java.lang.Override
  public boolean hasFeatureAttributions() {
    return featureAttributions_ != null;
  }
  /**
   *
   *
   * <pre>
   * Output only. Attributions of each explained feature. Features are extracted from
   * the [prediction instances][google.cloud.aiplatform.v1beta1.ExplainRequest.instances] according to
   * [explanation metadata for inputs][google.cloud.aiplatform.v1beta1.ExplanationMetadata.inputs].
   * The value is a struct, whose keys are the name of the feature. The values
   * are how much the feature in the [instance][google.cloud.aiplatform.v1beta1.ExplainRequest.instances]
   * contributed to the predicted result.
   * The format of the value is determined by the feature's input format:
   *   * If the feature is a scalar value, the attribution value is a
   *     [floating number][google.protobuf.Value.number_value].
   *   * If the feature is an array of scalar values, the attribution value is
   *     an [array][google.protobuf.Value.list_value].
   *   * If the feature is a struct, the attribution value is a
   *     [struct][google.protobuf.Value.struct_value]. The keys in the
   *     attribution value struct are the same as the keys in the feature
   *     struct. The formats of the values in the attribution struct are
   *     determined by the formats of the values in the feature struct.
   * The [ExplanationMetadata.feature_attributions_schema_uri][google.cloud.aiplatform.v1beta1.ExplanationMetadata.feature_attributions_schema_uri] field,
   * pointed to by the [ExplanationSpec][google.cloud.aiplatform.v1beta1.ExplanationSpec] field of the
   * [Endpoint.deployed_models][google.cloud.aiplatform.v1beta1.Endpoint.deployed_models] object, points to the schema file that
   * describes the features and their attribution values (if it is populated).
   * </pre>
   *
   * <code>
   * .google.protobuf.Value feature_attributions = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return The featureAttributions.
   */
  @java.lang.Override
  public com.google.protobuf.Value getFeatureAttributions() {
    return featureAttributions_ == null
        ? com.google.protobuf.Value.getDefaultInstance()
        : featureAttributions_;
  }
  /**
   *
   *
   * <pre>
   * Output only. Attributions of each explained feature. Features are extracted from
   * the [prediction instances][google.cloud.aiplatform.v1beta1.ExplainRequest.instances] according to
   * [explanation metadata for inputs][google.cloud.aiplatform.v1beta1.ExplanationMetadata.inputs].
   * The value is a struct, whose keys are the name of the feature. The values
   * are how much the feature in the [instance][google.cloud.aiplatform.v1beta1.ExplainRequest.instances]
   * contributed to the predicted result.
   * The format of the value is determined by the feature's input format:
   *   * If the feature is a scalar value, the attribution value is a
   *     [floating number][google.protobuf.Value.number_value].
   *   * If the feature is an array of scalar values, the attribution value is
   *     an [array][google.protobuf.Value.list_value].
   *   * If the feature is a struct, the attribution value is a
   *     [struct][google.protobuf.Value.struct_value]. The keys in the
   *     attribution value struct are the same as the keys in the feature
   *     struct. The formats of the values in the attribution struct are
   *     determined by the formats of the values in the feature struct.
   * The [ExplanationMetadata.feature_attributions_schema_uri][google.cloud.aiplatform.v1beta1.ExplanationMetadata.feature_attributions_schema_uri] field,
   * pointed to by the [ExplanationSpec][google.cloud.aiplatform.v1beta1.ExplanationSpec] field of the
   * [Endpoint.deployed_models][google.cloud.aiplatform.v1beta1.Endpoint.deployed_models] object, points to the schema file that
   * describes the features and their attribution values (if it is populated).
   * </pre>
   *
   * <code>
   * .google.protobuf.Value feature_attributions = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   */
  @java.lang.Override
  public com.google.protobuf.ValueOrBuilder getFeatureAttributionsOrBuilder() {
    return getFeatureAttributions();
  }

  public static final int OUTPUT_INDEX_FIELD_NUMBER = 4;
  private com.google.protobuf.Internal.IntList outputIndex_;
  /**
   *
   *
   * <pre>
   * Output only. The index that locates the explained prediction output.
   * If the prediction output is a scalar value, output_index is not populated.
   * If the prediction output has multiple dimensions, the length of the
   * output_index list is the same as the number of dimensions of the output.
   * The i-th element in output_index is the element index of the i-th dimension
   * of the output vector. Indices start from 0.
   * </pre>
   *
   * <code>repeated int32 output_index = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
   *
   * @return A list containing the outputIndex.
   */
  @java.lang.Override
  public java.util.List<java.lang.Integer> getOutputIndexList() {
    return outputIndex_;
  }
  /**
   *
   *
   * <pre>
   * Output only. The index that locates the explained prediction output.
   * If the prediction output is a scalar value, output_index is not populated.
   * If the prediction output has multiple dimensions, the length of the
   * output_index list is the same as the number of dimensions of the output.
   * The i-th element in output_index is the element index of the i-th dimension
   * of the output vector. Indices start from 0.
   * </pre>
   *
   * <code>repeated int32 output_index = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
   *
   * @return The count of outputIndex.
   */
  public int getOutputIndexCount() {
    return outputIndex_.size();
  }
  /**
   *
   *
   * <pre>
   * Output only. The index that locates the explained prediction output.
   * If the prediction output is a scalar value, output_index is not populated.
   * If the prediction output has multiple dimensions, the length of the
   * output_index list is the same as the number of dimensions of the output.
   * The i-th element in output_index is the element index of the i-th dimension
   * of the output vector. Indices start from 0.
   * </pre>
   *
   * <code>repeated int32 output_index = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
   *
   * @param index The index of the element to return.
   * @return The outputIndex at the given index.
   */
  public int getOutputIndex(int index) {
    return outputIndex_.getInt(index);
  }

  private int outputIndexMemoizedSerializedSize = -1;

  public static final int OUTPUT_DISPLAY_NAME_FIELD_NUMBER = 5;
  private volatile java.lang.Object outputDisplayName_;
  /**
   *
   *
   * <pre>
   * Output only. The display name of the output identified by [output_index][google.cloud.aiplatform.v1beta1.Attribution.output_index]. For example,
   * the predicted class name by a multi-classification Model.
   * This field is only populated iff the Model predicts display names as a
   * separate field along with the explained output. The predicted display name
   * must has the same shape of the explained output, and can be located using
   * output_index.
   * </pre>
   *
   * <code>string output_display_name = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
   *
   * @return The outputDisplayName.
   */
  @java.lang.Override
  public java.lang.String getOutputDisplayName() {
    java.lang.Object ref = outputDisplayName_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      outputDisplayName_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Output only. The display name of the output identified by [output_index][google.cloud.aiplatform.v1beta1.Attribution.output_index]. For example,
   * the predicted class name by a multi-classification Model.
   * This field is only populated iff the Model predicts display names as a
   * separate field along with the explained output. The predicted display name
   * must has the same shape of the explained output, and can be located using
   * output_index.
   * </pre>
   *
   * <code>string output_display_name = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
   *
   * @return The bytes for outputDisplayName.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getOutputDisplayNameBytes() {
    java.lang.Object ref = outputDisplayName_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      outputDisplayName_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int APPROXIMATION_ERROR_FIELD_NUMBER = 6;
  private double approximationError_;
  /**
   *
   *
   * <pre>
   * Output only. Error of [feature_attributions][google.cloud.aiplatform.v1beta1.Attribution.feature_attributions] caused by approximation used in the
   * explanation method. Lower value means more precise attributions.
   * * For Sampled Shapley
   * [attribution][google.cloud.aiplatform.v1beta1.ExplanationParameters.sampled_shapley_attribution],
   * increasing [path_count][google.cloud.aiplatform.v1beta1.SampledShapleyAttribution.path_count] might reduce
   * the error.
   * * For Integrated Gradients
   * [attribution][google.cloud.aiplatform.v1beta1.ExplanationParameters.integrated_gradients_attribution],
   * increasing [step_count][google.cloud.aiplatform.v1beta1.IntegratedGradientsAttribution.step_count] might
   * reduce the error.
   * * For [XRAI attribution][google.cloud.aiplatform.v1beta1.ExplanationParameters.xrai_attribution],
   * increasing
   * [step_count][google.cloud.aiplatform.v1beta1.XraiAttribution.step_count] might reduce the error.
   * See [this introduction](/vertex-ai/docs/explainable-ai/overview)
   * for more information.
   * </pre>
   *
   * <code>double approximation_error = 6 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
   *
   * @return The approximationError.
   */
  @java.lang.Override
  public double getApproximationError() {
    return approximationError_;
  }

  public static final int OUTPUT_NAME_FIELD_NUMBER = 7;
  private volatile java.lang.Object outputName_;
  /**
   *
   *
   * <pre>
   * Output only. Name of the explain output. Specified as the key in
   * [ExplanationMetadata.outputs][google.cloud.aiplatform.v1beta1.ExplanationMetadata.outputs].
   * </pre>
   *
   * <code>string output_name = 7 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
   *
   * @return The outputName.
   */
  @java.lang.Override
  public java.lang.String getOutputName() {
    java.lang.Object ref = outputName_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      outputName_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Output only. Name of the explain output. Specified as the key in
   * [ExplanationMetadata.outputs][google.cloud.aiplatform.v1beta1.ExplanationMetadata.outputs].
   * </pre>
   *
   * <code>string output_name = 7 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
   *
   * @return The bytes for outputName.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getOutputNameBytes() {
    java.lang.Object ref = outputName_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      outputName_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    getSerializedSize();
    if (baselineOutputValue_ != 0D) {
      output.writeDouble(1, baselineOutputValue_);
    }
    if (instanceOutputValue_ != 0D) {
      output.writeDouble(2, instanceOutputValue_);
    }
    if (featureAttributions_ != null) {
      output.writeMessage(3, getFeatureAttributions());
    }
    if (getOutputIndexList().size() > 0) {
      output.writeUInt32NoTag(34);
      output.writeUInt32NoTag(outputIndexMemoizedSerializedSize);
    }
    for (int i = 0; i < outputIndex_.size(); i++) {
      output.writeInt32NoTag(outputIndex_.getInt(i));
    }
    if (!getOutputDisplayNameBytes().isEmpty()) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 5, outputDisplayName_);
    }
    if (approximationError_ != 0D) {
      output.writeDouble(6, approximationError_);
    }
    if (!getOutputNameBytes().isEmpty()) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 7, outputName_);
    }
    unknownFields.writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    if (baselineOutputValue_ != 0D) {
      size += com.google.protobuf.CodedOutputStream.computeDoubleSize(1, baselineOutputValue_);
    }
    if (instanceOutputValue_ != 0D) {
      size += com.google.protobuf.CodedOutputStream.computeDoubleSize(2, instanceOutputValue_);
    }
    if (featureAttributions_ != null) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(3, getFeatureAttributions());
    }
    {
      int dataSize = 0;
      for (int i = 0; i < outputIndex_.size(); i++) {
        dataSize +=
            com.google.protobuf.CodedOutputStream.computeInt32SizeNoTag(outputIndex_.getInt(i));
      }
      size += dataSize;
      if (!getOutputIndexList().isEmpty()) {
        size += 1;
        size += com.google.protobuf.CodedOutputStream.computeInt32SizeNoTag(dataSize);
      }
      outputIndexMemoizedSerializedSize = dataSize;
    }
    if (!getOutputDisplayNameBytes().isEmpty()) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(5, outputDisplayName_);
    }
    if (approximationError_ != 0D) {
      size += com.google.protobuf.CodedOutputStream.computeDoubleSize(6, approximationError_);
    }
    if (!getOutputNameBytes().isEmpty()) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(7, outputName_);
    }
    size += unknownFields.getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.cloud.aiplatform.v1beta1.Attribution)) {
      return super.equals(obj);
    }
    com.google.cloud.aiplatform.v1beta1.Attribution other =
        (com.google.cloud.aiplatform.v1beta1.Attribution) obj;

    if (java.lang.Double.doubleToLongBits(getBaselineOutputValue())
        != java.lang.Double.doubleToLongBits(other.getBaselineOutputValue())) return false;
    if (java.lang.Double.doubleToLongBits(getInstanceOutputValue())
        != java.lang.Double.doubleToLongBits(other.getInstanceOutputValue())) return false;
    if (hasFeatureAttributions() != other.hasFeatureAttributions()) return false;
    if (hasFeatureAttributions()) {
      if (!getFeatureAttributions().equals(other.getFeatureAttributions())) return false;
    }
    if (!getOutputIndexList().equals(other.getOutputIndexList())) return false;
    if (!getOutputDisplayName().equals(other.getOutputDisplayName())) return false;
    if (java.lang.Double.doubleToLongBits(getApproximationError())
        != java.lang.Double.doubleToLongBits(other.getApproximationError())) return false;
    if (!getOutputName().equals(other.getOutputName())) return false;
    if (!unknownFields.equals(other.unknownFields)) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    hash = (37 * hash) + BASELINE_OUTPUT_VALUE_FIELD_NUMBER;
    hash =
        (53 * hash)
            + com.google.protobuf.Internal.hashLong(
                java.lang.Double.doubleToLongBits(getBaselineOutputValue()));
    hash = (37 * hash) + INSTANCE_OUTPUT_VALUE_FIELD_NUMBER;
    hash =
        (53 * hash)
            + com.google.protobuf.Internal.hashLong(
                java.lang.Double.doubleToLongBits(getInstanceOutputValue()));
    if (hasFeatureAttributions()) {
      hash = (37 * hash) + FEATURE_ATTRIBUTIONS_FIELD_NUMBER;
      hash = (53 * hash) + getFeatureAttributions().hashCode();
    }
    if (getOutputIndexCount() > 0) {
      hash = (37 * hash) + OUTPUT_INDEX_FIELD_NUMBER;
      hash = (53 * hash) + getOutputIndexList().hashCode();
    }
    hash = (37 * hash) + OUTPUT_DISPLAY_NAME_FIELD_NUMBER;
    hash = (53 * hash) + getOutputDisplayName().hashCode();
    hash = (37 * hash) + APPROXIMATION_ERROR_FIELD_NUMBER;
    hash =
        (53 * hash)
            + com.google.protobuf.Internal.hashLong(
                java.lang.Double.doubleToLongBits(getApproximationError()));
    hash = (37 * hash) + OUTPUT_NAME_FIELD_NUMBER;
    hash = (53 * hash) + getOutputName().hashCode();
    hash = (29 * hash) + unknownFields.hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.cloud.aiplatform.v1beta1.Attribution parseFrom(java.nio.ByteBuffer data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.aiplatform.v1beta1.Attribution parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.aiplatform.v1beta1.Attribution parseFrom(
      com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.aiplatform.v1beta1.Attribution parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.aiplatform.v1beta1.Attribution parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.aiplatform.v1beta1.Attribution parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.aiplatform.v1beta1.Attribution parseFrom(java.io.InputStream input)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.aiplatform.v1beta1.Attribution parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.aiplatform.v1beta1.Attribution parseDelimitedFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.cloud.aiplatform.v1beta1.Attribution parseDelimitedFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.aiplatform.v1beta1.Attribution parseFrom(
      com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.aiplatform.v1beta1.Attribution parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(com.google.cloud.aiplatform.v1beta1.Attribution prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }
  /**
   *
   *
   * <pre>
   * Attribution that explains a particular prediction output.
   * </pre>
   *
   * Protobuf type {@code google.cloud.aiplatform.v1beta1.Attribution}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.cloud.aiplatform.v1beta1.Attribution)
      com.google.cloud.aiplatform.v1beta1.AttributionOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.aiplatform.v1beta1.ExplanationProto
          .internal_static_google_cloud_aiplatform_v1beta1_Attribution_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.aiplatform.v1beta1.ExplanationProto
          .internal_static_google_cloud_aiplatform_v1beta1_Attribution_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.aiplatform.v1beta1.Attribution.class,
              com.google.cloud.aiplatform.v1beta1.Attribution.Builder.class);
    }

    // Construct using com.google.cloud.aiplatform.v1beta1.Attribution.newBuilder()
    private Builder() {
      maybeForceBuilderInitialization();
    }

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
      maybeForceBuilderInitialization();
    }

    private void maybeForceBuilderInitialization() {
      if (com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders) {}
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      baselineOutputValue_ = 0D;

      instanceOutputValue_ = 0D;

      if (featureAttributionsBuilder_ == null) {
        featureAttributions_ = null;
      } else {
        featureAttributions_ = null;
        featureAttributionsBuilder_ = null;
      }
      outputIndex_ = emptyIntList();
      bitField0_ = (bitField0_ & ~0x00000001);
      outputDisplayName_ = "";

      approximationError_ = 0D;

      outputName_ = "";

      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.cloud.aiplatform.v1beta1.ExplanationProto
          .internal_static_google_cloud_aiplatform_v1beta1_Attribution_descriptor;
    }

    @java.lang.Override
    public com.google.cloud.aiplatform.v1beta1.Attribution getDefaultInstanceForType() {
      return com.google.cloud.aiplatform.v1beta1.Attribution.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.cloud.aiplatform.v1beta1.Attribution build() {
      com.google.cloud.aiplatform.v1beta1.Attribution result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.cloud.aiplatform.v1beta1.Attribution buildPartial() {
      com.google.cloud.aiplatform.v1beta1.Attribution result =
          new com.google.cloud.aiplatform.v1beta1.Attribution(this);
      int from_bitField0_ = bitField0_;
      result.baselineOutputValue_ = baselineOutputValue_;
      result.instanceOutputValue_ = instanceOutputValue_;
      if (featureAttributionsBuilder_ == null) {
        result.featureAttributions_ = featureAttributions_;
      } else {
        result.featureAttributions_ = featureAttributionsBuilder_.build();
      }
      if (((bitField0_ & 0x00000001) != 0)) {
        outputIndex_.makeImmutable();
        bitField0_ = (bitField0_ & ~0x00000001);
      }
      result.outputIndex_ = outputIndex_;
      result.outputDisplayName_ = outputDisplayName_;
      result.approximationError_ = approximationError_;
      result.outputName_ = outputName_;
      onBuilt();
      return result;
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.cloud.aiplatform.v1beta1.Attribution) {
        return mergeFrom((com.google.cloud.aiplatform.v1beta1.Attribution) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(com.google.cloud.aiplatform.v1beta1.Attribution other) {
      if (other == com.google.cloud.aiplatform.v1beta1.Attribution.getDefaultInstance())
        return this;
      if (other.getBaselineOutputValue() != 0D) {
        setBaselineOutputValue(other.getBaselineOutputValue());
      }
      if (other.getInstanceOutputValue() != 0D) {
        setInstanceOutputValue(other.getInstanceOutputValue());
      }
      if (other.hasFeatureAttributions()) {
        mergeFeatureAttributions(other.getFeatureAttributions());
      }
      if (!other.outputIndex_.isEmpty()) {
        if (outputIndex_.isEmpty()) {
          outputIndex_ = other.outputIndex_;
          bitField0_ = (bitField0_ & ~0x00000001);
        } else {
          ensureOutputIndexIsMutable();
          outputIndex_.addAll(other.outputIndex_);
        }
        onChanged();
      }
      if (!other.getOutputDisplayName().isEmpty()) {
        outputDisplayName_ = other.outputDisplayName_;
        onChanged();
      }
      if (other.getApproximationError() != 0D) {
        setApproximationError(other.getApproximationError());
      }
      if (!other.getOutputName().isEmpty()) {
        outputName_ = other.outputName_;
        onChanged();
      }
      this.mergeUnknownFields(other.unknownFields);
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      com.google.cloud.aiplatform.v1beta1.Attribution parsedMessage = null;
      try {
        parsedMessage = PARSER.parsePartialFrom(input, extensionRegistry);
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        parsedMessage = (com.google.cloud.aiplatform.v1beta1.Attribution) e.getUnfinishedMessage();
        throw e.unwrapIOException();
      } finally {
        if (parsedMessage != null) {
          mergeFrom(parsedMessage);
        }
      }
      return this;
    }

    private int bitField0_;

    private double baselineOutputValue_;
    /**
     *
     *
     * <pre>
     * Output only. Model predicted output if the input instance is constructed from the
     * baselines of all the features defined in [ExplanationMetadata.inputs][google.cloud.aiplatform.v1beta1.ExplanationMetadata.inputs].
     * The field name of the output is determined by the key in
     * [ExplanationMetadata.outputs][google.cloud.aiplatform.v1beta1.ExplanationMetadata.outputs].
     * If the Model's predicted output has multiple dimensions (rank &gt; 1), this is
     * the value in the output located by [output_index][google.cloud.aiplatform.v1beta1.Attribution.output_index].
     * If there are multiple baselines, their output values are averaged.
     * </pre>
     *
     * <code>double baseline_output_value = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return The baselineOutputValue.
     */
    @java.lang.Override
    public double getBaselineOutputValue() {
      return baselineOutputValue_;
    }
    /**
     *
     *
     * <pre>
     * Output only. Model predicted output if the input instance is constructed from the
     * baselines of all the features defined in [ExplanationMetadata.inputs][google.cloud.aiplatform.v1beta1.ExplanationMetadata.inputs].
     * The field name of the output is determined by the key in
     * [ExplanationMetadata.outputs][google.cloud.aiplatform.v1beta1.ExplanationMetadata.outputs].
     * If the Model's predicted output has multiple dimensions (rank &gt; 1), this is
     * the value in the output located by [output_index][google.cloud.aiplatform.v1beta1.Attribution.output_index].
     * If there are multiple baselines, their output values are averaged.
     * </pre>
     *
     * <code>double baseline_output_value = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @param value The baselineOutputValue to set.
     * @return This builder for chaining.
     */
    public Builder setBaselineOutputValue(double value) {

      baselineOutputValue_ = value;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Model predicted output if the input instance is constructed from the
     * baselines of all the features defined in [ExplanationMetadata.inputs][google.cloud.aiplatform.v1beta1.ExplanationMetadata.inputs].
     * The field name of the output is determined by the key in
     * [ExplanationMetadata.outputs][google.cloud.aiplatform.v1beta1.ExplanationMetadata.outputs].
     * If the Model's predicted output has multiple dimensions (rank &gt; 1), this is
     * the value in the output located by [output_index][google.cloud.aiplatform.v1beta1.Attribution.output_index].
     * If there are multiple baselines, their output values are averaged.
     * </pre>
     *
     * <code>double baseline_output_value = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearBaselineOutputValue() {

      baselineOutputValue_ = 0D;
      onChanged();
      return this;
    }

    private double instanceOutputValue_;
    /**
     *
     *
     * <pre>
     * Output only. Model predicted output on the corresponding [explanation
     * instance][ExplainRequest.instances]. The field name of the output is
     * determined by the key in [ExplanationMetadata.outputs][google.cloud.aiplatform.v1beta1.ExplanationMetadata.outputs].
     * If the Model predicted output has multiple dimensions, this is the value in
     * the output located by [output_index][google.cloud.aiplatform.v1beta1.Attribution.output_index].
     * </pre>
     *
     * <code>double instance_output_value = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return The instanceOutputValue.
     */
    @java.lang.Override
    public double getInstanceOutputValue() {
      return instanceOutputValue_;
    }
    /**
     *
     *
     * <pre>
     * Output only. Model predicted output on the corresponding [explanation
     * instance][ExplainRequest.instances]. The field name of the output is
     * determined by the key in [ExplanationMetadata.outputs][google.cloud.aiplatform.v1beta1.ExplanationMetadata.outputs].
     * If the Model predicted output has multiple dimensions, this is the value in
     * the output located by [output_index][google.cloud.aiplatform.v1beta1.Attribution.output_index].
     * </pre>
     *
     * <code>double instance_output_value = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @param value The instanceOutputValue to set.
     * @return This builder for chaining.
     */
    public Builder setInstanceOutputValue(double value) {

      instanceOutputValue_ = value;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Model predicted output on the corresponding [explanation
     * instance][ExplainRequest.instances]. The field name of the output is
     * determined by the key in [ExplanationMetadata.outputs][google.cloud.aiplatform.v1beta1.ExplanationMetadata.outputs].
     * If the Model predicted output has multiple dimensions, this is the value in
     * the output located by [output_index][google.cloud.aiplatform.v1beta1.Attribution.output_index].
     * </pre>
     *
     * <code>double instance_output_value = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearInstanceOutputValue() {

      instanceOutputValue_ = 0D;
      onChanged();
      return this;
    }

    private com.google.protobuf.Value featureAttributions_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Value,
            com.google.protobuf.Value.Builder,
            com.google.protobuf.ValueOrBuilder>
        featureAttributionsBuilder_;
    /**
     *
     *
     * <pre>
     * Output only. Attributions of each explained feature. Features are extracted from
     * the [prediction instances][google.cloud.aiplatform.v1beta1.ExplainRequest.instances] according to
     * [explanation metadata for inputs][google.cloud.aiplatform.v1beta1.ExplanationMetadata.inputs].
     * The value is a struct, whose keys are the name of the feature. The values
     * are how much the feature in the [instance][google.cloud.aiplatform.v1beta1.ExplainRequest.instances]
     * contributed to the predicted result.
     * The format of the value is determined by the feature's input format:
     *   * If the feature is a scalar value, the attribution value is a
     *     [floating number][google.protobuf.Value.number_value].
     *   * If the feature is an array of scalar values, the attribution value is
     *     an [array][google.protobuf.Value.list_value].
     *   * If the feature is a struct, the attribution value is a
     *     [struct][google.protobuf.Value.struct_value]. The keys in the
     *     attribution value struct are the same as the keys in the feature
     *     struct. The formats of the values in the attribution struct are
     *     determined by the formats of the values in the feature struct.
     * The [ExplanationMetadata.feature_attributions_schema_uri][google.cloud.aiplatform.v1beta1.ExplanationMetadata.feature_attributions_schema_uri] field,
     * pointed to by the [ExplanationSpec][google.cloud.aiplatform.v1beta1.ExplanationSpec] field of the
     * [Endpoint.deployed_models][google.cloud.aiplatform.v1beta1.Endpoint.deployed_models] object, points to the schema file that
     * describes the features and their attribution values (if it is populated).
     * </pre>
     *
     * <code>
     * .google.protobuf.Value feature_attributions = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return Whether the featureAttributions field is set.
     */
    public boolean hasFeatureAttributions() {
      return featureAttributionsBuilder_ != null || featureAttributions_ != null;
    }
    /**
     *
     *
     * <pre>
     * Output only. Attributions of each explained feature. Features are extracted from
     * the [prediction instances][google.cloud.aiplatform.v1beta1.ExplainRequest.instances] according to
     * [explanation metadata for inputs][google.cloud.aiplatform.v1beta1.ExplanationMetadata.inputs].
     * The value is a struct, whose keys are the name of the feature. The values
     * are how much the feature in the [instance][google.cloud.aiplatform.v1beta1.ExplainRequest.instances]
     * contributed to the predicted result.
     * The format of the value is determined by the feature's input format:
     *   * If the feature is a scalar value, the attribution value is a
     *     [floating number][google.protobuf.Value.number_value].
     *   * If the feature is an array of scalar values, the attribution value is
     *     an [array][google.protobuf.Value.list_value].
     *   * If the feature is a struct, the attribution value is a
     *     [struct][google.protobuf.Value.struct_value]. The keys in the
     *     attribution value struct are the same as the keys in the feature
     *     struct. The formats of the values in the attribution struct are
     *     determined by the formats of the values in the feature struct.
     * The [ExplanationMetadata.feature_attributions_schema_uri][google.cloud.aiplatform.v1beta1.ExplanationMetadata.feature_attributions_schema_uri] field,
     * pointed to by the [ExplanationSpec][google.cloud.aiplatform.v1beta1.ExplanationSpec] field of the
     * [Endpoint.deployed_models][google.cloud.aiplatform.v1beta1.Endpoint.deployed_models] object, points to the schema file that
     * describes the features and their attribution values (if it is populated).
     * </pre>
     *
     * <code>
     * .google.protobuf.Value feature_attributions = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return The featureAttributions.
     */
    public com.google.protobuf.Value getFeatureAttributions() {
      if (featureAttributionsBuilder_ == null) {
        return featureAttributions_ == null
            ? com.google.protobuf.Value.getDefaultInstance()
            : featureAttributions_;
      } else {
        return featureAttributionsBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. Attributions of each explained feature. Features are extracted from
     * the [prediction instances][google.cloud.aiplatform.v1beta1.ExplainRequest.instances] according to
     * [explanation metadata for inputs][google.cloud.aiplatform.v1beta1.ExplanationMetadata.inputs].
     * The value is a struct, whose keys are the name of the feature. The values
     * are how much the feature in the [instance][google.cloud.aiplatform.v1beta1.ExplainRequest.instances]
     * contributed to the predicted result.
     * The format of the value is determined by the feature's input format:
     *   * If the feature is a scalar value, the attribution value is a
     *     [floating number][google.protobuf.Value.number_value].
     *   * If the feature is an array of scalar values, the attribution value is
     *     an [array][google.protobuf.Value.list_value].
     *   * If the feature is a struct, the attribution value is a
     *     [struct][google.protobuf.Value.struct_value]. The keys in the
     *     attribution value struct are the same as the keys in the feature
     *     struct. The formats of the values in the attribution struct are
     *     determined by the formats of the values in the feature struct.
     * The [ExplanationMetadata.feature_attributions_schema_uri][google.cloud.aiplatform.v1beta1.ExplanationMetadata.feature_attributions_schema_uri] field,
     * pointed to by the [ExplanationSpec][google.cloud.aiplatform.v1beta1.ExplanationSpec] field of the
     * [Endpoint.deployed_models][google.cloud.aiplatform.v1beta1.Endpoint.deployed_models] object, points to the schema file that
     * describes the features and their attribution values (if it is populated).
     * </pre>
     *
     * <code>
     * .google.protobuf.Value feature_attributions = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder setFeatureAttributions(com.google.protobuf.Value value) {
      if (featureAttributionsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        featureAttributions_ = value;
        onChanged();
      } else {
        featureAttributionsBuilder_.setMessage(value);
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Attributions of each explained feature. Features are extracted from
     * the [prediction instances][google.cloud.aiplatform.v1beta1.ExplainRequest.instances] according to
     * [explanation metadata for inputs][google.cloud.aiplatform.v1beta1.ExplanationMetadata.inputs].
     * The value is a struct, whose keys are the name of the feature. The values
     * are how much the feature in the [instance][google.cloud.aiplatform.v1beta1.ExplainRequest.instances]
     * contributed to the predicted result.
     * The format of the value is determined by the feature's input format:
     *   * If the feature is a scalar value, the attribution value is a
     *     [floating number][google.protobuf.Value.number_value].
     *   * If the feature is an array of scalar values, the attribution value is
     *     an [array][google.protobuf.Value.list_value].
     *   * If the feature is a struct, the attribution value is a
     *     [struct][google.protobuf.Value.struct_value]. The keys in the
     *     attribution value struct are the same as the keys in the feature
     *     struct. The formats of the values in the attribution struct are
     *     determined by the formats of the values in the feature struct.
     * The [ExplanationMetadata.feature_attributions_schema_uri][google.cloud.aiplatform.v1beta1.ExplanationMetadata.feature_attributions_schema_uri] field,
     * pointed to by the [ExplanationSpec][google.cloud.aiplatform.v1beta1.ExplanationSpec] field of the
     * [Endpoint.deployed_models][google.cloud.aiplatform.v1beta1.Endpoint.deployed_models] object, points to the schema file that
     * describes the features and their attribution values (if it is populated).
     * </pre>
     *
     * <code>
     * .google.protobuf.Value feature_attributions = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder setFeatureAttributions(com.google.protobuf.Value.Builder builderForValue) {
      if (featureAttributionsBuilder_ == null) {
        featureAttributions_ = builderForValue.build();
        onChanged();
      } else {
        featureAttributionsBuilder_.setMessage(builderForValue.build());
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Attributions of each explained feature. Features are extracted from
     * the [prediction instances][google.cloud.aiplatform.v1beta1.ExplainRequest.instances] according to
     * [explanation metadata for inputs][google.cloud.aiplatform.v1beta1.ExplanationMetadata.inputs].
     * The value is a struct, whose keys are the name of the feature. The values
     * are how much the feature in the [instance][google.cloud.aiplatform.v1beta1.ExplainRequest.instances]
     * contributed to the predicted result.
     * The format of the value is determined by the feature's input format:
     *   * If the feature is a scalar value, the attribution value is a
     *     [floating number][google.protobuf.Value.number_value].
     *   * If the feature is an array of scalar values, the attribution value is
     *     an [array][google.protobuf.Value.list_value].
     *   * If the feature is a struct, the attribution value is a
     *     [struct][google.protobuf.Value.struct_value]. The keys in the
     *     attribution value struct are the same as the keys in the feature
     *     struct. The formats of the values in the attribution struct are
     *     determined by the formats of the values in the feature struct.
     * The [ExplanationMetadata.feature_attributions_schema_uri][google.cloud.aiplatform.v1beta1.ExplanationMetadata.feature_attributions_schema_uri] field,
     * pointed to by the [ExplanationSpec][google.cloud.aiplatform.v1beta1.ExplanationSpec] field of the
     * [Endpoint.deployed_models][google.cloud.aiplatform.v1beta1.Endpoint.deployed_models] object, points to the schema file that
     * describes the features and their attribution values (if it is populated).
     * </pre>
     *
     * <code>
     * .google.protobuf.Value feature_attributions = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder mergeFeatureAttributions(com.google.protobuf.Value value) {
      if (featureAttributionsBuilder_ == null) {
        if (featureAttributions_ != null) {
          featureAttributions_ =
              com.google.protobuf.Value.newBuilder(featureAttributions_)
                  .mergeFrom(value)
                  .buildPartial();
        } else {
          featureAttributions_ = value;
        }
        onChanged();
      } else {
        featureAttributionsBuilder_.mergeFrom(value);
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Attributions of each explained feature. Features are extracted from
     * the [prediction instances][google.cloud.aiplatform.v1beta1.ExplainRequest.instances] according to
     * [explanation metadata for inputs][google.cloud.aiplatform.v1beta1.ExplanationMetadata.inputs].
     * The value is a struct, whose keys are the name of the feature. The values
     * are how much the feature in the [instance][google.cloud.aiplatform.v1beta1.ExplainRequest.instances]
     * contributed to the predicted result.
     * The format of the value is determined by the feature's input format:
     *   * If the feature is a scalar value, the attribution value is a
     *     [floating number][google.protobuf.Value.number_value].
     *   * If the feature is an array of scalar values, the attribution value is
     *     an [array][google.protobuf.Value.list_value].
     *   * If the feature is a struct, the attribution value is a
     *     [struct][google.protobuf.Value.struct_value]. The keys in the
     *     attribution value struct are the same as the keys in the feature
     *     struct. The formats of the values in the attribution struct are
     *     determined by the formats of the values in the feature struct.
     * The [ExplanationMetadata.feature_attributions_schema_uri][google.cloud.aiplatform.v1beta1.ExplanationMetadata.feature_attributions_schema_uri] field,
     * pointed to by the [ExplanationSpec][google.cloud.aiplatform.v1beta1.ExplanationSpec] field of the
     * [Endpoint.deployed_models][google.cloud.aiplatform.v1beta1.Endpoint.deployed_models] object, points to the schema file that
     * describes the features and their attribution values (if it is populated).
     * </pre>
     *
     * <code>
     * .google.protobuf.Value feature_attributions = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder clearFeatureAttributions() {
      if (featureAttributionsBuilder_ == null) {
        featureAttributions_ = null;
        onChanged();
      } else {
        featureAttributions_ = null;
        featureAttributionsBuilder_ = null;
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Attributions of each explained feature. Features are extracted from
     * the [prediction instances][google.cloud.aiplatform.v1beta1.ExplainRequest.instances] according to
     * [explanation metadata for inputs][google.cloud.aiplatform.v1beta1.ExplanationMetadata.inputs].
     * The value is a struct, whose keys are the name of the feature. The values
     * are how much the feature in the [instance][google.cloud.aiplatform.v1beta1.ExplainRequest.instances]
     * contributed to the predicted result.
     * The format of the value is determined by the feature's input format:
     *   * If the feature is a scalar value, the attribution value is a
     *     [floating number][google.protobuf.Value.number_value].
     *   * If the feature is an array of scalar values, the attribution value is
     *     an [array][google.protobuf.Value.list_value].
     *   * If the feature is a struct, the attribution value is a
     *     [struct][google.protobuf.Value.struct_value]. The keys in the
     *     attribution value struct are the same as the keys in the feature
     *     struct. The formats of the values in the attribution struct are
     *     determined by the formats of the values in the feature struct.
     * The [ExplanationMetadata.feature_attributions_schema_uri][google.cloud.aiplatform.v1beta1.ExplanationMetadata.feature_attributions_schema_uri] field,
     * pointed to by the [ExplanationSpec][google.cloud.aiplatform.v1beta1.ExplanationSpec] field of the
     * [Endpoint.deployed_models][google.cloud.aiplatform.v1beta1.Endpoint.deployed_models] object, points to the schema file that
     * describes the features and their attribution values (if it is populated).
     * </pre>
     *
     * <code>
     * .google.protobuf.Value feature_attributions = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.protobuf.Value.Builder getFeatureAttributionsBuilder() {

      onChanged();
      return getFeatureAttributionsFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Output only. Attributions of each explained feature. Features are extracted from
     * the [prediction instances][google.cloud.aiplatform.v1beta1.ExplainRequest.instances] according to
     * [explanation metadata for inputs][google.cloud.aiplatform.v1beta1.ExplanationMetadata.inputs].
     * The value is a struct, whose keys are the name of the feature. The values
     * are how much the feature in the [instance][google.cloud.aiplatform.v1beta1.ExplainRequest.instances]
     * contributed to the predicted result.
     * The format of the value is determined by the feature's input format:
     *   * If the feature is a scalar value, the attribution value is a
     *     [floating number][google.protobuf.Value.number_value].
     *   * If the feature is an array of scalar values, the attribution value is
     *     an [array][google.protobuf.Value.list_value].
     *   * If the feature is a struct, the attribution value is a
     *     [struct][google.protobuf.Value.struct_value]. The keys in the
     *     attribution value struct are the same as the keys in the feature
     *     struct. The formats of the values in the attribution struct are
     *     determined by the formats of the values in the feature struct.
     * The [ExplanationMetadata.feature_attributions_schema_uri][google.cloud.aiplatform.v1beta1.ExplanationMetadata.feature_attributions_schema_uri] field,
     * pointed to by the [ExplanationSpec][google.cloud.aiplatform.v1beta1.ExplanationSpec] field of the
     * [Endpoint.deployed_models][google.cloud.aiplatform.v1beta1.Endpoint.deployed_models] object, points to the schema file that
     * describes the features and their attribution values (if it is populated).
     * </pre>
     *
     * <code>
     * .google.protobuf.Value feature_attributions = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.protobuf.ValueOrBuilder getFeatureAttributionsOrBuilder() {
      if (featureAttributionsBuilder_ != null) {
        return featureAttributionsBuilder_.getMessageOrBuilder();
      } else {
        return featureAttributions_ == null
            ? com.google.protobuf.Value.getDefaultInstance()
            : featureAttributions_;
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. Attributions of each explained feature. Features are extracted from
     * the [prediction instances][google.cloud.aiplatform.v1beta1.ExplainRequest.instances] according to
     * [explanation metadata for inputs][google.cloud.aiplatform.v1beta1.ExplanationMetadata.inputs].
     * The value is a struct, whose keys are the name of the feature. The values
     * are how much the feature in the [instance][google.cloud.aiplatform.v1beta1.ExplainRequest.instances]
     * contributed to the predicted result.
     * The format of the value is determined by the feature's input format:
     *   * If the feature is a scalar value, the attribution value is a
     *     [floating number][google.protobuf.Value.number_value].
     *   * If the feature is an array of scalar values, the attribution value is
     *     an [array][google.protobuf.Value.list_value].
     *   * If the feature is a struct, the attribution value is a
     *     [struct][google.protobuf.Value.struct_value]. The keys in the
     *     attribution value struct are the same as the keys in the feature
     *     struct. The formats of the values in the attribution struct are
     *     determined by the formats of the values in the feature struct.
     * The [ExplanationMetadata.feature_attributions_schema_uri][google.cloud.aiplatform.v1beta1.ExplanationMetadata.feature_attributions_schema_uri] field,
     * pointed to by the [ExplanationSpec][google.cloud.aiplatform.v1beta1.ExplanationSpec] field of the
     * [Endpoint.deployed_models][google.cloud.aiplatform.v1beta1.Endpoint.deployed_models] object, points to the schema file that
     * describes the features and their attribution values (if it is populated).
     * </pre>
     *
     * <code>
     * .google.protobuf.Value feature_attributions = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Value,
            com.google.protobuf.Value.Builder,
            com.google.protobuf.ValueOrBuilder>
        getFeatureAttributionsFieldBuilder() {
      if (featureAttributionsBuilder_ == null) {
        featureAttributionsBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.protobuf.Value,
                com.google.protobuf.Value.Builder,
                com.google.protobuf.ValueOrBuilder>(
                getFeatureAttributions(), getParentForChildren(), isClean());
        featureAttributions_ = null;
      }
      return featureAttributionsBuilder_;
    }

    private com.google.protobuf.Internal.IntList outputIndex_ = emptyIntList();

    private void ensureOutputIndexIsMutable() {
      if (!((bitField0_ & 0x00000001) != 0)) {
        outputIndex_ = mutableCopy(outputIndex_);
        bitField0_ |= 0x00000001;
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. The index that locates the explained prediction output.
     * If the prediction output is a scalar value, output_index is not populated.
     * If the prediction output has multiple dimensions, the length of the
     * output_index list is the same as the number of dimensions of the output.
     * The i-th element in output_index is the element index of the i-th dimension
     * of the output vector. Indices start from 0.
     * </pre>
     *
     * <code>repeated int32 output_index = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return A list containing the outputIndex.
     */
    public java.util.List<java.lang.Integer> getOutputIndexList() {
      return ((bitField0_ & 0x00000001) != 0)
          ? java.util.Collections.unmodifiableList(outputIndex_)
          : outputIndex_;
    }
    /**
     *
     *
     * <pre>
     * Output only. The index that locates the explained prediction output.
     * If the prediction output is a scalar value, output_index is not populated.
     * If the prediction output has multiple dimensions, the length of the
     * output_index list is the same as the number of dimensions of the output.
     * The i-th element in output_index is the element index of the i-th dimension
     * of the output vector. Indices start from 0.
     * </pre>
     *
     * <code>repeated int32 output_index = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return The count of outputIndex.
     */
    public int getOutputIndexCount() {
      return outputIndex_.size();
    }
    /**
     *
     *
     * <pre>
     * Output only. The index that locates the explained prediction output.
     * If the prediction output is a scalar value, output_index is not populated.
     * If the prediction output has multiple dimensions, the length of the
     * output_index list is the same as the number of dimensions of the output.
     * The i-th element in output_index is the element index of the i-th dimension
     * of the output vector. Indices start from 0.
     * </pre>
     *
     * <code>repeated int32 output_index = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @param index The index of the element to return.
     * @return The outputIndex at the given index.
     */
    public int getOutputIndex(int index) {
      return outputIndex_.getInt(index);
    }
    /**
     *
     *
     * <pre>
     * Output only. The index that locates the explained prediction output.
     * If the prediction output is a scalar value, output_index is not populated.
     * If the prediction output has multiple dimensions, the length of the
     * output_index list is the same as the number of dimensions of the output.
     * The i-th element in output_index is the element index of the i-th dimension
     * of the output vector. Indices start from 0.
     * </pre>
     *
     * <code>repeated int32 output_index = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @param index The index to set the value at.
     * @param value The outputIndex to set.
     * @return This builder for chaining.
     */
    public Builder setOutputIndex(int index, int value) {
      ensureOutputIndexIsMutable();
      outputIndex_.setInt(index, value);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The index that locates the explained prediction output.
     * If the prediction output is a scalar value, output_index is not populated.
     * If the prediction output has multiple dimensions, the length of the
     * output_index list is the same as the number of dimensions of the output.
     * The i-th element in output_index is the element index of the i-th dimension
     * of the output vector. Indices start from 0.
     * </pre>
     *
     * <code>repeated int32 output_index = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @param value The outputIndex to add.
     * @return This builder for chaining.
     */
    public Builder addOutputIndex(int value) {
      ensureOutputIndexIsMutable();
      outputIndex_.addInt(value);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The index that locates the explained prediction output.
     * If the prediction output is a scalar value, output_index is not populated.
     * If the prediction output has multiple dimensions, the length of the
     * output_index list is the same as the number of dimensions of the output.
     * The i-th element in output_index is the element index of the i-th dimension
     * of the output vector. Indices start from 0.
     * </pre>
     *
     * <code>repeated int32 output_index = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @param values The outputIndex to add.
     * @return This builder for chaining.
     */
    public Builder addAllOutputIndex(java.lang.Iterable<? extends java.lang.Integer> values) {
      ensureOutputIndexIsMutable();
      com.google.protobuf.AbstractMessageLite.Builder.addAll(values, outputIndex_);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The index that locates the explained prediction output.
     * If the prediction output is a scalar value, output_index is not populated.
     * If the prediction output has multiple dimensions, the length of the
     * output_index list is the same as the number of dimensions of the output.
     * The i-th element in output_index is the element index of the i-th dimension
     * of the output vector. Indices start from 0.
     * </pre>
     *
     * <code>repeated int32 output_index = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearOutputIndex() {
      outputIndex_ = emptyIntList();
      bitField0_ = (bitField0_ & ~0x00000001);
      onChanged();
      return this;
    }

    private java.lang.Object outputDisplayName_ = "";
    /**
     *
     *
     * <pre>
     * Output only. The display name of the output identified by [output_index][google.cloud.aiplatform.v1beta1.Attribution.output_index]. For example,
     * the predicted class name by a multi-classification Model.
     * This field is only populated iff the Model predicts display names as a
     * separate field along with the explained output. The predicted display name
     * must has the same shape of the explained output, and can be located using
     * output_index.
     * </pre>
     *
     * <code>string output_display_name = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return The outputDisplayName.
     */
    public java.lang.String getOutputDisplayName() {
      java.lang.Object ref = outputDisplayName_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        outputDisplayName_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. The display name of the output identified by [output_index][google.cloud.aiplatform.v1beta1.Attribution.output_index]. For example,
     * the predicted class name by a multi-classification Model.
     * This field is only populated iff the Model predicts display names as a
     * separate field along with the explained output. The predicted display name
     * must has the same shape of the explained output, and can be located using
     * output_index.
     * </pre>
     *
     * <code>string output_display_name = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return The bytes for outputDisplayName.
     */
    public com.google.protobuf.ByteString getOutputDisplayNameBytes() {
      java.lang.Object ref = outputDisplayName_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        outputDisplayName_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. The display name of the output identified by [output_index][google.cloud.aiplatform.v1beta1.Attribution.output_index]. For example,
     * the predicted class name by a multi-classification Model.
     * This field is only populated iff the Model predicts display names as a
     * separate field along with the explained output. The predicted display name
     * must has the same shape of the explained output, and can be located using
     * output_index.
     * </pre>
     *
     * <code>string output_display_name = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @param value The outputDisplayName to set.
     * @return This builder for chaining.
     */
    public Builder setOutputDisplayName(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }

      outputDisplayName_ = value;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The display name of the output identified by [output_index][google.cloud.aiplatform.v1beta1.Attribution.output_index]. For example,
     * the predicted class name by a multi-classification Model.
     * This field is only populated iff the Model predicts display names as a
     * separate field along with the explained output. The predicted display name
     * must has the same shape of the explained output, and can be located using
     * output_index.
     * </pre>
     *
     * <code>string output_display_name = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearOutputDisplayName() {

      outputDisplayName_ = getDefaultInstance().getOutputDisplayName();
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The display name of the output identified by [output_index][google.cloud.aiplatform.v1beta1.Attribution.output_index]. For example,
     * the predicted class name by a multi-classification Model.
     * This field is only populated iff the Model predicts display names as a
     * separate field along with the explained output. The predicted display name
     * must has the same shape of the explained output, and can be located using
     * output_index.
     * </pre>
     *
     * <code>string output_display_name = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @param value The bytes for outputDisplayName to set.
     * @return This builder for chaining.
     */
    public Builder setOutputDisplayNameBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);

      outputDisplayName_ = value;
      onChanged();
      return this;
    }

    private double approximationError_;
    /**
     *
     *
     * <pre>
     * Output only. Error of [feature_attributions][google.cloud.aiplatform.v1beta1.Attribution.feature_attributions] caused by approximation used in the
     * explanation method. Lower value means more precise attributions.
     * * For Sampled Shapley
     * [attribution][google.cloud.aiplatform.v1beta1.ExplanationParameters.sampled_shapley_attribution],
     * increasing [path_count][google.cloud.aiplatform.v1beta1.SampledShapleyAttribution.path_count] might reduce
     * the error.
     * * For Integrated Gradients
     * [attribution][google.cloud.aiplatform.v1beta1.ExplanationParameters.integrated_gradients_attribution],
     * increasing [step_count][google.cloud.aiplatform.v1beta1.IntegratedGradientsAttribution.step_count] might
     * reduce the error.
     * * For [XRAI attribution][google.cloud.aiplatform.v1beta1.ExplanationParameters.xrai_attribution],
     * increasing
     * [step_count][google.cloud.aiplatform.v1beta1.XraiAttribution.step_count] might reduce the error.
     * See [this introduction](/vertex-ai/docs/explainable-ai/overview)
     * for more information.
     * </pre>
     *
     * <code>double approximation_error = 6 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return The approximationError.
     */
    @java.lang.Override
    public double getApproximationError() {
      return approximationError_;
    }
    /**
     *
     *
     * <pre>
     * Output only. Error of [feature_attributions][google.cloud.aiplatform.v1beta1.Attribution.feature_attributions] caused by approximation used in the
     * explanation method. Lower value means more precise attributions.
     * * For Sampled Shapley
     * [attribution][google.cloud.aiplatform.v1beta1.ExplanationParameters.sampled_shapley_attribution],
     * increasing [path_count][google.cloud.aiplatform.v1beta1.SampledShapleyAttribution.path_count] might reduce
     * the error.
     * * For Integrated Gradients
     * [attribution][google.cloud.aiplatform.v1beta1.ExplanationParameters.integrated_gradients_attribution],
     * increasing [step_count][google.cloud.aiplatform.v1beta1.IntegratedGradientsAttribution.step_count] might
     * reduce the error.
     * * For [XRAI attribution][google.cloud.aiplatform.v1beta1.ExplanationParameters.xrai_attribution],
     * increasing
     * [step_count][google.cloud.aiplatform.v1beta1.XraiAttribution.step_count] might reduce the error.
     * See [this introduction](/vertex-ai/docs/explainable-ai/overview)
     * for more information.
     * </pre>
     *
     * <code>double approximation_error = 6 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @param value The approximationError to set.
     * @return This builder for chaining.
     */
    public Builder setApproximationError(double value) {

      approximationError_ = value;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Error of [feature_attributions][google.cloud.aiplatform.v1beta1.Attribution.feature_attributions] caused by approximation used in the
     * explanation method. Lower value means more precise attributions.
     * * For Sampled Shapley
     * [attribution][google.cloud.aiplatform.v1beta1.ExplanationParameters.sampled_shapley_attribution],
     * increasing [path_count][google.cloud.aiplatform.v1beta1.SampledShapleyAttribution.path_count] might reduce
     * the error.
     * * For Integrated Gradients
     * [attribution][google.cloud.aiplatform.v1beta1.ExplanationParameters.integrated_gradients_attribution],
     * increasing [step_count][google.cloud.aiplatform.v1beta1.IntegratedGradientsAttribution.step_count] might
     * reduce the error.
     * * For [XRAI attribution][google.cloud.aiplatform.v1beta1.ExplanationParameters.xrai_attribution],
     * increasing
     * [step_count][google.cloud.aiplatform.v1beta1.XraiAttribution.step_count] might reduce the error.
     * See [this introduction](/vertex-ai/docs/explainable-ai/overview)
     * for more information.
     * </pre>
     *
     * <code>double approximation_error = 6 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearApproximationError() {

      approximationError_ = 0D;
      onChanged();
      return this;
    }

    private java.lang.Object outputName_ = "";
    /**
     *
     *
     * <pre>
     * Output only. Name of the explain output. Specified as the key in
     * [ExplanationMetadata.outputs][google.cloud.aiplatform.v1beta1.ExplanationMetadata.outputs].
     * </pre>
     *
     * <code>string output_name = 7 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return The outputName.
     */
    public java.lang.String getOutputName() {
      java.lang.Object ref = outputName_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        outputName_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. Name of the explain output. Specified as the key in
     * [ExplanationMetadata.outputs][google.cloud.aiplatform.v1beta1.ExplanationMetadata.outputs].
     * </pre>
     *
     * <code>string output_name = 7 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return The bytes for outputName.
     */
    public com.google.protobuf.ByteString getOutputNameBytes() {
      java.lang.Object ref = outputName_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        outputName_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. Name of the explain output. Specified as the key in
     * [ExplanationMetadata.outputs][google.cloud.aiplatform.v1beta1.ExplanationMetadata.outputs].
     * </pre>
     *
     * <code>string output_name = 7 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @param value The outputName to set.
     * @return This builder for chaining.
     */
    public Builder setOutputName(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }

      outputName_ = value;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Name of the explain output. Specified as the key in
     * [ExplanationMetadata.outputs][google.cloud.aiplatform.v1beta1.ExplanationMetadata.outputs].
     * </pre>
     *
     * <code>string output_name = 7 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearOutputName() {

      outputName_ = getDefaultInstance().getOutputName();
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Name of the explain output. Specified as the key in
     * [ExplanationMetadata.outputs][google.cloud.aiplatform.v1beta1.ExplanationMetadata.outputs].
     * </pre>
     *
     * <code>string output_name = 7 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @param value The bytes for outputName to set.
     * @return This builder for chaining.
     */
    public Builder setOutputNameBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);

      outputName_ = value;
      onChanged();
      return this;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.cloud.aiplatform.v1beta1.Attribution)
  }

  // @@protoc_insertion_point(class_scope:google.cloud.aiplatform.v1beta1.Attribution)
  private static final com.google.cloud.aiplatform.v1beta1.Attribution DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.cloud.aiplatform.v1beta1.Attribution();
  }

  public static com.google.cloud.aiplatform.v1beta1.Attribution getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<Attribution> PARSER =
      new com.google.protobuf.AbstractParser<Attribution>() {
        @java.lang.Override
        public Attribution parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          return new Attribution(input, extensionRegistry);
        }
      };

  public static com.google.protobuf.Parser<Attribution> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<Attribution> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.cloud.aiplatform.v1beta1.Attribution getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
