/*
 * Copyright 2020 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/cloud/aiplatform/v1beta1/batch_prediction_job.proto

package com.google.cloud.aiplatform.v1beta1;

/**
 *
 *
 * <pre>
 * A job that uses a [Model][google.cloud.aiplatform.v1beta1.BatchPredictionJob.model] to produce predictions
 * on multiple [input instances][google.cloud.aiplatform.v1beta1.BatchPredictionJob.input_config]. If
 * predictions for significant portion of the instances fail, the job may finish
 * without attempting predictions for all remaining instances.
 * </pre>
 *
 * Protobuf type {@code google.cloud.aiplatform.v1beta1.BatchPredictionJob}
 */
public final class BatchPredictionJob extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.cloud.aiplatform.v1beta1.BatchPredictionJob)
    BatchPredictionJobOrBuilder {
  private static final long serialVersionUID = 0L;
  // Use BatchPredictionJob.newBuilder() to construct.
  private BatchPredictionJob(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private BatchPredictionJob() {
    name_ = "";
    displayName_ = "";
    model_ = "";
    state_ = 0;
    partialFailures_ = java.util.Collections.emptyList();
  }

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new BatchPredictionJob();
  }

  @java.lang.Override
  public final com.google.protobuf.UnknownFieldSet getUnknownFields() {
    return this.unknownFields;
  }

  private BatchPredictionJob(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    this();
    if (extensionRegistry == null) {
      throw new java.lang.NullPointerException();
    }
    int mutable_bitField0_ = 0;
    com.google.protobuf.UnknownFieldSet.Builder unknownFields =
        com.google.protobuf.UnknownFieldSet.newBuilder();
    try {
      boolean done = false;
      while (!done) {
        int tag = input.readTag();
        switch (tag) {
          case 0:
            done = true;
            break;
          case 10:
            {
              java.lang.String s = input.readStringRequireUtf8();

              name_ = s;
              break;
            }
          case 18:
            {
              java.lang.String s = input.readStringRequireUtf8();

              displayName_ = s;
              break;
            }
          case 26:
            {
              java.lang.String s = input.readStringRequireUtf8();

              model_ = s;
              break;
            }
          case 34:
            {
              com.google.cloud.aiplatform.v1beta1.BatchPredictionJob.InputConfig.Builder
                  subBuilder = null;
              if (inputConfig_ != null) {
                subBuilder = inputConfig_.toBuilder();
              }
              inputConfig_ =
                  input.readMessage(
                      com.google.cloud.aiplatform.v1beta1.BatchPredictionJob.InputConfig.parser(),
                      extensionRegistry);
              if (subBuilder != null) {
                subBuilder.mergeFrom(inputConfig_);
                inputConfig_ = subBuilder.buildPartial();
              }

              break;
            }
          case 42:
            {
              com.google.protobuf.Value.Builder subBuilder = null;
              if (modelParameters_ != null) {
                subBuilder = modelParameters_.toBuilder();
              }
              modelParameters_ =
                  input.readMessage(com.google.protobuf.Value.parser(), extensionRegistry);
              if (subBuilder != null) {
                subBuilder.mergeFrom(modelParameters_);
                modelParameters_ = subBuilder.buildPartial();
              }

              break;
            }
          case 50:
            {
              com.google.cloud.aiplatform.v1beta1.BatchPredictionJob.OutputConfig.Builder
                  subBuilder = null;
              if (outputConfig_ != null) {
                subBuilder = outputConfig_.toBuilder();
              }
              outputConfig_ =
                  input.readMessage(
                      com.google.cloud.aiplatform.v1beta1.BatchPredictionJob.OutputConfig.parser(),
                      extensionRegistry);
              if (subBuilder != null) {
                subBuilder.mergeFrom(outputConfig_);
                outputConfig_ = subBuilder.buildPartial();
              }

              break;
            }
          case 58:
            {
              com.google.cloud.aiplatform.v1beta1.BatchDedicatedResources.Builder subBuilder = null;
              if (dedicatedResources_ != null) {
                subBuilder = dedicatedResources_.toBuilder();
              }
              dedicatedResources_ =
                  input.readMessage(
                      com.google.cloud.aiplatform.v1beta1.BatchDedicatedResources.parser(),
                      extensionRegistry);
              if (subBuilder != null) {
                subBuilder.mergeFrom(dedicatedResources_);
                dedicatedResources_ = subBuilder.buildPartial();
              }

              break;
            }
          case 66:
            {
              com.google.cloud.aiplatform.v1beta1.ManualBatchTuningParameters.Builder subBuilder =
                  null;
              if (manualBatchTuningParameters_ != null) {
                subBuilder = manualBatchTuningParameters_.toBuilder();
              }
              manualBatchTuningParameters_ =
                  input.readMessage(
                      com.google.cloud.aiplatform.v1beta1.ManualBatchTuningParameters.parser(),
                      extensionRegistry);
              if (subBuilder != null) {
                subBuilder.mergeFrom(manualBatchTuningParameters_);
                manualBatchTuningParameters_ = subBuilder.buildPartial();
              }

              break;
            }
          case 74:
            {
              com.google.cloud.aiplatform.v1beta1.BatchPredictionJob.OutputInfo.Builder subBuilder =
                  null;
              if (outputInfo_ != null) {
                subBuilder = outputInfo_.toBuilder();
              }
              outputInfo_ =
                  input.readMessage(
                      com.google.cloud.aiplatform.v1beta1.BatchPredictionJob.OutputInfo.parser(),
                      extensionRegistry);
              if (subBuilder != null) {
                subBuilder.mergeFrom(outputInfo_);
                outputInfo_ = subBuilder.buildPartial();
              }

              break;
            }
          case 80:
            {
              int rawValue = input.readEnum();

              state_ = rawValue;
              break;
            }
          case 90:
            {
              com.google.rpc.Status.Builder subBuilder = null;
              if (error_ != null) {
                subBuilder = error_.toBuilder();
              }
              error_ = input.readMessage(com.google.rpc.Status.parser(), extensionRegistry);
              if (subBuilder != null) {
                subBuilder.mergeFrom(error_);
                error_ = subBuilder.buildPartial();
              }

              break;
            }
          case 98:
            {
              if (!((mutable_bitField0_ & 0x00000001) != 0)) {
                partialFailures_ = new java.util.ArrayList<com.google.rpc.Status>();
                mutable_bitField0_ |= 0x00000001;
              }
              partialFailures_.add(
                  input.readMessage(com.google.rpc.Status.parser(), extensionRegistry));
              break;
            }
          case 106:
            {
              com.google.cloud.aiplatform.v1beta1.ResourcesConsumed.Builder subBuilder = null;
              if (resourcesConsumed_ != null) {
                subBuilder = resourcesConsumed_.toBuilder();
              }
              resourcesConsumed_ =
                  input.readMessage(
                      com.google.cloud.aiplatform.v1beta1.ResourcesConsumed.parser(),
                      extensionRegistry);
              if (subBuilder != null) {
                subBuilder.mergeFrom(resourcesConsumed_);
                resourcesConsumed_ = subBuilder.buildPartial();
              }

              break;
            }
          case 114:
            {
              com.google.cloud.aiplatform.v1beta1.CompletionStats.Builder subBuilder = null;
              if (completionStats_ != null) {
                subBuilder = completionStats_.toBuilder();
              }
              completionStats_ =
                  input.readMessage(
                      com.google.cloud.aiplatform.v1beta1.CompletionStats.parser(),
                      extensionRegistry);
              if (subBuilder != null) {
                subBuilder.mergeFrom(completionStats_);
                completionStats_ = subBuilder.buildPartial();
              }

              break;
            }
          case 122:
            {
              com.google.protobuf.Timestamp.Builder subBuilder = null;
              if (createTime_ != null) {
                subBuilder = createTime_.toBuilder();
              }
              createTime_ =
                  input.readMessage(com.google.protobuf.Timestamp.parser(), extensionRegistry);
              if (subBuilder != null) {
                subBuilder.mergeFrom(createTime_);
                createTime_ = subBuilder.buildPartial();
              }

              break;
            }
          case 130:
            {
              com.google.protobuf.Timestamp.Builder subBuilder = null;
              if (startTime_ != null) {
                subBuilder = startTime_.toBuilder();
              }
              startTime_ =
                  input.readMessage(com.google.protobuf.Timestamp.parser(), extensionRegistry);
              if (subBuilder != null) {
                subBuilder.mergeFrom(startTime_);
                startTime_ = subBuilder.buildPartial();
              }

              break;
            }
          case 138:
            {
              com.google.protobuf.Timestamp.Builder subBuilder = null;
              if (endTime_ != null) {
                subBuilder = endTime_.toBuilder();
              }
              endTime_ =
                  input.readMessage(com.google.protobuf.Timestamp.parser(), extensionRegistry);
              if (subBuilder != null) {
                subBuilder.mergeFrom(endTime_);
                endTime_ = subBuilder.buildPartial();
              }

              break;
            }
          case 146:
            {
              com.google.protobuf.Timestamp.Builder subBuilder = null;
              if (updateTime_ != null) {
                subBuilder = updateTime_.toBuilder();
              }
              updateTime_ =
                  input.readMessage(com.google.protobuf.Timestamp.parser(), extensionRegistry);
              if (subBuilder != null) {
                subBuilder.mergeFrom(updateTime_);
                updateTime_ = subBuilder.buildPartial();
              }

              break;
            }
          case 154:
            {
              if (!((mutable_bitField0_ & 0x00000002) != 0)) {
                labels_ =
                    com.google.protobuf.MapField.newMapField(LabelsDefaultEntryHolder.defaultEntry);
                mutable_bitField0_ |= 0x00000002;
              }
              com.google.protobuf.MapEntry<java.lang.String, java.lang.String> labels__ =
                  input.readMessage(
                      LabelsDefaultEntryHolder.defaultEntry.getParserForType(), extensionRegistry);
              labels_.getMutableMap().put(labels__.getKey(), labels__.getValue());
              break;
            }
          case 184:
            {
              generateExplanation_ = input.readBool();
              break;
            }
          case 194:
            {
              com.google.cloud.aiplatform.v1beta1.EncryptionSpec.Builder subBuilder = null;
              if (encryptionSpec_ != null) {
                subBuilder = encryptionSpec_.toBuilder();
              }
              encryptionSpec_ =
                  input.readMessage(
                      com.google.cloud.aiplatform.v1beta1.EncryptionSpec.parser(),
                      extensionRegistry);
              if (subBuilder != null) {
                subBuilder.mergeFrom(encryptionSpec_);
                encryptionSpec_ = subBuilder.buildPartial();
              }

              break;
            }
          case 202:
            {
              com.google.cloud.aiplatform.v1beta1.ExplanationSpec.Builder subBuilder = null;
              if (explanationSpec_ != null) {
                subBuilder = explanationSpec_.toBuilder();
              }
              explanationSpec_ =
                  input.readMessage(
                      com.google.cloud.aiplatform.v1beta1.ExplanationSpec.parser(),
                      extensionRegistry);
              if (subBuilder != null) {
                subBuilder.mergeFrom(explanationSpec_);
                explanationSpec_ = subBuilder.buildPartial();
              }

              break;
            }
          default:
            {
              if (!parseUnknownField(input, unknownFields, extensionRegistry, tag)) {
                done = true;
              }
              break;
            }
        }
      }
    } catch (com.google.protobuf.InvalidProtocolBufferException e) {
      throw e.setUnfinishedMessage(this);
    } catch (java.io.IOException e) {
      throw new com.google.protobuf.InvalidProtocolBufferException(e).setUnfinishedMessage(this);
    } finally {
      if (((mutable_bitField0_ & 0x00000001) != 0)) {
        partialFailures_ = java.util.Collections.unmodifiableList(partialFailures_);
      }
      this.unknownFields = unknownFields.build();
      makeExtensionsImmutable();
    }
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.cloud.aiplatform.v1beta1.BatchPredictionJobProto
        .internal_static_google_cloud_aiplatform_v1beta1_BatchPredictionJob_descriptor;
  }

  @SuppressWarnings({"rawtypes"})
  @java.lang.Override
  protected com.google.protobuf.MapField internalGetMapField(int number) {
    switch (number) {
      case 19:
        return internalGetLabels();
      default:
        throw new RuntimeException("Invalid map field number: " + number);
    }
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.cloud.aiplatform.v1beta1.BatchPredictionJobProto
        .internal_static_google_cloud_aiplatform_v1beta1_BatchPredictionJob_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.cloud.aiplatform.v1beta1.BatchPredictionJob.class,
            com.google.cloud.aiplatform.v1beta1.BatchPredictionJob.Builder.class);
  }

  public interface InputConfigOrBuilder
      extends
      // @@protoc_insertion_point(interface_extends:google.cloud.aiplatform.v1beta1.BatchPredictionJob.InputConfig)
      com.google.protobuf.MessageOrBuilder {

    /**
     *
     *
     * <pre>
     * The Cloud Storage location for the input instances.
     * </pre>
     *
     * <code>.google.cloud.aiplatform.v1beta1.GcsSource gcs_source = 2;</code>
     *
     * @return Whether the gcsSource field is set.
     */
    boolean hasGcsSource();
    /**
     *
     *
     * <pre>
     * The Cloud Storage location for the input instances.
     * </pre>
     *
     * <code>.google.cloud.aiplatform.v1beta1.GcsSource gcs_source = 2;</code>
     *
     * @return The gcsSource.
     */
    com.google.cloud.aiplatform.v1beta1.GcsSource getGcsSource();
    /**
     *
     *
     * <pre>
     * The Cloud Storage location for the input instances.
     * </pre>
     *
     * <code>.google.cloud.aiplatform.v1beta1.GcsSource gcs_source = 2;</code>
     */
    com.google.cloud.aiplatform.v1beta1.GcsSourceOrBuilder getGcsSourceOrBuilder();

    /**
     *
     *
     * <pre>
     * The BigQuery location of the input table.
     * The schema of the table should be in the format described by the given
     * context OpenAPI Schema, if one is provided. The table may contain
     * additional columns that are not described by the schema, and they will
     * be ignored.
     * </pre>
     *
     * <code>.google.cloud.aiplatform.v1beta1.BigQuerySource bigquery_source = 3;</code>
     *
     * @return Whether the bigquerySource field is set.
     */
    boolean hasBigquerySource();
    /**
     *
     *
     * <pre>
     * The BigQuery location of the input table.
     * The schema of the table should be in the format described by the given
     * context OpenAPI Schema, if one is provided. The table may contain
     * additional columns that are not described by the schema, and they will
     * be ignored.
     * </pre>
     *
     * <code>.google.cloud.aiplatform.v1beta1.BigQuerySource bigquery_source = 3;</code>
     *
     * @return The bigquerySource.
     */
    com.google.cloud.aiplatform.v1beta1.BigQuerySource getBigquerySource();
    /**
     *
     *
     * <pre>
     * The BigQuery location of the input table.
     * The schema of the table should be in the format described by the given
     * context OpenAPI Schema, if one is provided. The table may contain
     * additional columns that are not described by the schema, and they will
     * be ignored.
     * </pre>
     *
     * <code>.google.cloud.aiplatform.v1beta1.BigQuerySource bigquery_source = 3;</code>
     */
    com.google.cloud.aiplatform.v1beta1.BigQuerySourceOrBuilder getBigquerySourceOrBuilder();

    /**
     *
     *
     * <pre>
     * Required. The format in which instances are given, must be one of the
     * [Model's][google.cloud.aiplatform.v1beta1.BatchPredictionJob.model]
     * [supported_input_storage_formats][google.cloud.aiplatform.v1beta1.Model.supported_input_storage_formats].
     * </pre>
     *
     * <code>string instances_format = 1 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return The instancesFormat.
     */
    java.lang.String getInstancesFormat();
    /**
     *
     *
     * <pre>
     * Required. The format in which instances are given, must be one of the
     * [Model's][google.cloud.aiplatform.v1beta1.BatchPredictionJob.model]
     * [supported_input_storage_formats][google.cloud.aiplatform.v1beta1.Model.supported_input_storage_formats].
     * </pre>
     *
     * <code>string instances_format = 1 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return The bytes for instancesFormat.
     */
    com.google.protobuf.ByteString getInstancesFormatBytes();

    public com.google.cloud.aiplatform.v1beta1.BatchPredictionJob.InputConfig.SourceCase
        getSourceCase();
  }
  /**
   *
   *
   * <pre>
   * Configures the input to [BatchPredictionJob][google.cloud.aiplatform.v1beta1.BatchPredictionJob].
   * See [Model.supported_input_storage_formats][google.cloud.aiplatform.v1beta1.Model.supported_input_storage_formats] for Model's supported input
   * formats, and how instances should be expressed via any of them.
   * </pre>
   *
   * Protobuf type {@code google.cloud.aiplatform.v1beta1.BatchPredictionJob.InputConfig}
   */
  public static final class InputConfig extends com.google.protobuf.GeneratedMessageV3
      implements
      // @@protoc_insertion_point(message_implements:google.cloud.aiplatform.v1beta1.BatchPredictionJob.InputConfig)
      InputConfigOrBuilder {
    private static final long serialVersionUID = 0L;
    // Use InputConfig.newBuilder() to construct.
    private InputConfig(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
      super(builder);
    }

    private InputConfig() {
      instancesFormat_ = "";
    }

    @java.lang.Override
    @SuppressWarnings({"unused"})
    protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
      return new InputConfig();
    }

    @java.lang.Override
    public final com.google.protobuf.UnknownFieldSet getUnknownFields() {
      return this.unknownFields;
    }

    private InputConfig(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      this();
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      com.google.protobuf.UnknownFieldSet.Builder unknownFields =
          com.google.protobuf.UnknownFieldSet.newBuilder();
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 10:
              {
                java.lang.String s = input.readStringRequireUtf8();

                instancesFormat_ = s;
                break;
              }
            case 18:
              {
                com.google.cloud.aiplatform.v1beta1.GcsSource.Builder subBuilder = null;
                if (sourceCase_ == 2) {
                  subBuilder =
                      ((com.google.cloud.aiplatform.v1beta1.GcsSource) source_).toBuilder();
                }
                source_ =
                    input.readMessage(
                        com.google.cloud.aiplatform.v1beta1.GcsSource.parser(), extensionRegistry);
                if (subBuilder != null) {
                  subBuilder.mergeFrom((com.google.cloud.aiplatform.v1beta1.GcsSource) source_);
                  source_ = subBuilder.buildPartial();
                }
                sourceCase_ = 2;
                break;
              }
            case 26:
              {
                com.google.cloud.aiplatform.v1beta1.BigQuerySource.Builder subBuilder = null;
                if (sourceCase_ == 3) {
                  subBuilder =
                      ((com.google.cloud.aiplatform.v1beta1.BigQuerySource) source_).toBuilder();
                }
                source_ =
                    input.readMessage(
                        com.google.cloud.aiplatform.v1beta1.BigQuerySource.parser(),
                        extensionRegistry);
                if (subBuilder != null) {
                  subBuilder.mergeFrom(
                      (com.google.cloud.aiplatform.v1beta1.BigQuerySource) source_);
                  source_ = subBuilder.buildPartial();
                }
                sourceCase_ = 3;
                break;
              }
            default:
              {
                if (!parseUnknownField(input, unknownFields, extensionRegistry, tag)) {
                  done = true;
                }
                break;
              }
          }
        }
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.setUnfinishedMessage(this);
      } catch (java.io.IOException e) {
        throw new com.google.protobuf.InvalidProtocolBufferException(e).setUnfinishedMessage(this);
      } finally {
        this.unknownFields = unknownFields.build();
        makeExtensionsImmutable();
      }
    }

    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.aiplatform.v1beta1.BatchPredictionJobProto
          .internal_static_google_cloud_aiplatform_v1beta1_BatchPredictionJob_InputConfig_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.aiplatform.v1beta1.BatchPredictionJobProto
          .internal_static_google_cloud_aiplatform_v1beta1_BatchPredictionJob_InputConfig_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.aiplatform.v1beta1.BatchPredictionJob.InputConfig.class,
              com.google.cloud.aiplatform.v1beta1.BatchPredictionJob.InputConfig.Builder.class);
    }

    private int sourceCase_ = 0;
    private java.lang.Object source_;

    public enum SourceCase
        implements
            com.google.protobuf.Internal.EnumLite,
            com.google.protobuf.AbstractMessage.InternalOneOfEnum {
      GCS_SOURCE(2),
      BIGQUERY_SOURCE(3),
      SOURCE_NOT_SET(0);
      private final int value;

      private SourceCase(int value) {
        this.value = value;
      }
      /**
       * @param value The number of the enum to look for.
       * @return The enum associated with the given number.
       * @deprecated Use {@link #forNumber(int)} instead.
       */
      @java.lang.Deprecated
      public static SourceCase valueOf(int value) {
        return forNumber(value);
      }

      public static SourceCase forNumber(int value) {
        switch (value) {
          case 2:
            return GCS_SOURCE;
          case 3:
            return BIGQUERY_SOURCE;
          case 0:
            return SOURCE_NOT_SET;
          default:
            return null;
        }
      }

      public int getNumber() {
        return this.value;
      }
    };

    public SourceCase getSourceCase() {
      return SourceCase.forNumber(sourceCase_);
    }

    public static final int GCS_SOURCE_FIELD_NUMBER = 2;
    /**
     *
     *
     * <pre>
     * The Cloud Storage location for the input instances.
     * </pre>
     *
     * <code>.google.cloud.aiplatform.v1beta1.GcsSource gcs_source = 2;</code>
     *
     * @return Whether the gcsSource field is set.
     */
    @java.lang.Override
    public boolean hasGcsSource() {
      return sourceCase_ == 2;
    }
    /**
     *
     *
     * <pre>
     * The Cloud Storage location for the input instances.
     * </pre>
     *
     * <code>.google.cloud.aiplatform.v1beta1.GcsSource gcs_source = 2;</code>
     *
     * @return The gcsSource.
     */
    @java.lang.Override
    public com.google.cloud.aiplatform.v1beta1.GcsSource getGcsSource() {
      if (sourceCase_ == 2) {
        return (com.google.cloud.aiplatform.v1beta1.GcsSource) source_;
      }
      return com.google.cloud.aiplatform.v1beta1.GcsSource.getDefaultInstance();
    }
    /**
     *
     *
     * <pre>
     * The Cloud Storage location for the input instances.
     * </pre>
     *
     * <code>.google.cloud.aiplatform.v1beta1.GcsSource gcs_source = 2;</code>
     */
    @java.lang.Override
    public com.google.cloud.aiplatform.v1beta1.GcsSourceOrBuilder getGcsSourceOrBuilder() {
      if (sourceCase_ == 2) {
        return (com.google.cloud.aiplatform.v1beta1.GcsSource) source_;
      }
      return com.google.cloud.aiplatform.v1beta1.GcsSource.getDefaultInstance();
    }

    public static final int BIGQUERY_SOURCE_FIELD_NUMBER = 3;
    /**
     *
     *
     * <pre>
     * The BigQuery location of the input table.
     * The schema of the table should be in the format described by the given
     * context OpenAPI Schema, if one is provided. The table may contain
     * additional columns that are not described by the schema, and they will
     * be ignored.
     * </pre>
     *
     * <code>.google.cloud.aiplatform.v1beta1.BigQuerySource bigquery_source = 3;</code>
     *
     * @return Whether the bigquerySource field is set.
     */
    @java.lang.Override
    public boolean hasBigquerySource() {
      return sourceCase_ == 3;
    }
    /**
     *
     *
     * <pre>
     * The BigQuery location of the input table.
     * The schema of the table should be in the format described by the given
     * context OpenAPI Schema, if one is provided. The table may contain
     * additional columns that are not described by the schema, and they will
     * be ignored.
     * </pre>
     *
     * <code>.google.cloud.aiplatform.v1beta1.BigQuerySource bigquery_source = 3;</code>
     *
     * @return The bigquerySource.
     */
    @java.lang.Override
    public com.google.cloud.aiplatform.v1beta1.BigQuerySource getBigquerySource() {
      if (sourceCase_ == 3) {
        return (com.google.cloud.aiplatform.v1beta1.BigQuerySource) source_;
      }
      return com.google.cloud.aiplatform.v1beta1.BigQuerySource.getDefaultInstance();
    }
    /**
     *
     *
     * <pre>
     * The BigQuery location of the input table.
     * The schema of the table should be in the format described by the given
     * context OpenAPI Schema, if one is provided. The table may contain
     * additional columns that are not described by the schema, and they will
     * be ignored.
     * </pre>
     *
     * <code>.google.cloud.aiplatform.v1beta1.BigQuerySource bigquery_source = 3;</code>
     */
    @java.lang.Override
    public com.google.cloud.aiplatform.v1beta1.BigQuerySourceOrBuilder
        getBigquerySourceOrBuilder() {
      if (sourceCase_ == 3) {
        return (com.google.cloud.aiplatform.v1beta1.BigQuerySource) source_;
      }
      return com.google.cloud.aiplatform.v1beta1.BigQuerySource.getDefaultInstance();
    }

    public static final int INSTANCES_FORMAT_FIELD_NUMBER = 1;
    private volatile java.lang.Object instancesFormat_;
    /**
     *
     *
     * <pre>
     * Required. The format in which instances are given, must be one of the
     * [Model's][google.cloud.aiplatform.v1beta1.BatchPredictionJob.model]
     * [supported_input_storage_formats][google.cloud.aiplatform.v1beta1.Model.supported_input_storage_formats].
     * </pre>
     *
     * <code>string instances_format = 1 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return The instancesFormat.
     */
    @java.lang.Override
    public java.lang.String getInstancesFormat() {
      java.lang.Object ref = instancesFormat_;
      if (ref instanceof java.lang.String) {
        return (java.lang.String) ref;
      } else {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        instancesFormat_ = s;
        return s;
      }
    }
    /**
     *
     *
     * <pre>
     * Required. The format in which instances are given, must be one of the
     * [Model's][google.cloud.aiplatform.v1beta1.BatchPredictionJob.model]
     * [supported_input_storage_formats][google.cloud.aiplatform.v1beta1.Model.supported_input_storage_formats].
     * </pre>
     *
     * <code>string instances_format = 1 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return The bytes for instancesFormat.
     */
    @java.lang.Override
    public com.google.protobuf.ByteString getInstancesFormatBytes() {
      java.lang.Object ref = instancesFormat_;
      if (ref instanceof java.lang.String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        instancesFormat_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    private byte memoizedIsInitialized = -1;

    @java.lang.Override
    public final boolean isInitialized() {
      byte isInitialized = memoizedIsInitialized;
      if (isInitialized == 1) return true;
      if (isInitialized == 0) return false;

      memoizedIsInitialized = 1;
      return true;
    }

    @java.lang.Override
    public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
      if (!getInstancesFormatBytes().isEmpty()) {
        com.google.protobuf.GeneratedMessageV3.writeString(output, 1, instancesFormat_);
      }
      if (sourceCase_ == 2) {
        output.writeMessage(2, (com.google.cloud.aiplatform.v1beta1.GcsSource) source_);
      }
      if (sourceCase_ == 3) {
        output.writeMessage(3, (com.google.cloud.aiplatform.v1beta1.BigQuerySource) source_);
      }
      unknownFields.writeTo(output);
    }

    @java.lang.Override
    public int getSerializedSize() {
      int size = memoizedSize;
      if (size != -1) return size;

      size = 0;
      if (!getInstancesFormatBytes().isEmpty()) {
        size += com.google.protobuf.GeneratedMessageV3.computeStringSize(1, instancesFormat_);
      }
      if (sourceCase_ == 2) {
        size +=
            com.google.protobuf.CodedOutputStream.computeMessageSize(
                2, (com.google.cloud.aiplatform.v1beta1.GcsSource) source_);
      }
      if (sourceCase_ == 3) {
        size +=
            com.google.protobuf.CodedOutputStream.computeMessageSize(
                3, (com.google.cloud.aiplatform.v1beta1.BigQuerySource) source_);
      }
      size += unknownFields.getSerializedSize();
      memoizedSize = size;
      return size;
    }

    @java.lang.Override
    public boolean equals(final java.lang.Object obj) {
      if (obj == this) {
        return true;
      }
      if (!(obj instanceof com.google.cloud.aiplatform.v1beta1.BatchPredictionJob.InputConfig)) {
        return super.equals(obj);
      }
      com.google.cloud.aiplatform.v1beta1.BatchPredictionJob.InputConfig other =
          (com.google.cloud.aiplatform.v1beta1.BatchPredictionJob.InputConfig) obj;

      if (!getInstancesFormat().equals(other.getInstancesFormat())) return false;
      if (!getSourceCase().equals(other.getSourceCase())) return false;
      switch (sourceCase_) {
        case 2:
          if (!getGcsSource().equals(other.getGcsSource())) return false;
          break;
        case 3:
          if (!getBigquerySource().equals(other.getBigquerySource())) return false;
          break;
        case 0:
        default:
      }
      if (!unknownFields.equals(other.unknownFields)) return false;
      return true;
    }

    @java.lang.Override
    public int hashCode() {
      if (memoizedHashCode != 0) {
        return memoizedHashCode;
      }
      int hash = 41;
      hash = (19 * hash) + getDescriptor().hashCode();
      hash = (37 * hash) + INSTANCES_FORMAT_FIELD_NUMBER;
      hash = (53 * hash) + getInstancesFormat().hashCode();
      switch (sourceCase_) {
        case 2:
          hash = (37 * hash) + GCS_SOURCE_FIELD_NUMBER;
          hash = (53 * hash) + getGcsSource().hashCode();
          break;
        case 3:
          hash = (37 * hash) + BIGQUERY_SOURCE_FIELD_NUMBER;
          hash = (53 * hash) + getBigquerySource().hashCode();
          break;
        case 0:
        default:
      }
      hash = (29 * hash) + unknownFields.hashCode();
      memoizedHashCode = hash;
      return hash;
    }

    public static com.google.cloud.aiplatform.v1beta1.BatchPredictionJob.InputConfig parseFrom(
        java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.aiplatform.v1beta1.BatchPredictionJob.InputConfig parseFrom(
        java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.aiplatform.v1beta1.BatchPredictionJob.InputConfig parseFrom(
        com.google.protobuf.ByteString data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.aiplatform.v1beta1.BatchPredictionJob.InputConfig parseFrom(
        com.google.protobuf.ByteString data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.aiplatform.v1beta1.BatchPredictionJob.InputConfig parseFrom(
        byte[] data) throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.aiplatform.v1beta1.BatchPredictionJob.InputConfig parseFrom(
        byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.aiplatform.v1beta1.BatchPredictionJob.InputConfig parseFrom(
        java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.cloud.aiplatform.v1beta1.BatchPredictionJob.InputConfig parseFrom(
        java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.cloud.aiplatform.v1beta1.BatchPredictionJob.InputConfig
        parseDelimitedFrom(java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
    }

    public static com.google.cloud.aiplatform.v1beta1.BatchPredictionJob.InputConfig
        parseDelimitedFrom(
            java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.cloud.aiplatform.v1beta1.BatchPredictionJob.InputConfig parseFrom(
        com.google.protobuf.CodedInputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.cloud.aiplatform.v1beta1.BatchPredictionJob.InputConfig parseFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    @java.lang.Override
    public Builder newBuilderForType() {
      return newBuilder();
    }

    public static Builder newBuilder() {
      return DEFAULT_INSTANCE.toBuilder();
    }

    public static Builder newBuilder(
        com.google.cloud.aiplatform.v1beta1.BatchPredictionJob.InputConfig prototype) {
      return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }

    @java.lang.Override
    public Builder toBuilder() {
      return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
    }

    @java.lang.Override
    protected Builder newBuilderForType(
        com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      Builder builder = new Builder(parent);
      return builder;
    }
    /**
     *
     *
     * <pre>
     * Configures the input to [BatchPredictionJob][google.cloud.aiplatform.v1beta1.BatchPredictionJob].
     * See [Model.supported_input_storage_formats][google.cloud.aiplatform.v1beta1.Model.supported_input_storage_formats] for Model's supported input
     * formats, and how instances should be expressed via any of them.
     * </pre>
     *
     * Protobuf type {@code google.cloud.aiplatform.v1beta1.BatchPredictionJob.InputConfig}
     */
    public static final class Builder
        extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
        implements
        // @@protoc_insertion_point(builder_implements:google.cloud.aiplatform.v1beta1.BatchPredictionJob.InputConfig)
        com.google.cloud.aiplatform.v1beta1.BatchPredictionJob.InputConfigOrBuilder {
      public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
        return com.google.cloud.aiplatform.v1beta1.BatchPredictionJobProto
            .internal_static_google_cloud_aiplatform_v1beta1_BatchPredictionJob_InputConfig_descriptor;
      }

      @java.lang.Override
      protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return com.google.cloud.aiplatform.v1beta1.BatchPredictionJobProto
            .internal_static_google_cloud_aiplatform_v1beta1_BatchPredictionJob_InputConfig_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                com.google.cloud.aiplatform.v1beta1.BatchPredictionJob.InputConfig.class,
                com.google.cloud.aiplatform.v1beta1.BatchPredictionJob.InputConfig.Builder.class);
      }

      // Construct using
      // com.google.cloud.aiplatform.v1beta1.BatchPredictionJob.InputConfig.newBuilder()
      private Builder() {
        maybeForceBuilderInitialization();
      }

      private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
        super(parent);
        maybeForceBuilderInitialization();
      }

      private void maybeForceBuilderInitialization() {
        if (com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders) {}
      }

      @java.lang.Override
      public Builder clear() {
        super.clear();
        instancesFormat_ = "";

        sourceCase_ = 0;
        source_ = null;
        return this;
      }

      @java.lang.Override
      public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
        return com.google.cloud.aiplatform.v1beta1.BatchPredictionJobProto
            .internal_static_google_cloud_aiplatform_v1beta1_BatchPredictionJob_InputConfig_descriptor;
      }

      @java.lang.Override
      public com.google.cloud.aiplatform.v1beta1.BatchPredictionJob.InputConfig
          getDefaultInstanceForType() {
        return com.google.cloud.aiplatform.v1beta1.BatchPredictionJob.InputConfig
            .getDefaultInstance();
      }

      @java.lang.Override
      public com.google.cloud.aiplatform.v1beta1.BatchPredictionJob.InputConfig build() {
        com.google.cloud.aiplatform.v1beta1.BatchPredictionJob.InputConfig result = buildPartial();
        if (!result.isInitialized()) {
          throw newUninitializedMessageException(result);
        }
        return result;
      }

      @java.lang.Override
      public com.google.cloud.aiplatform.v1beta1.BatchPredictionJob.InputConfig buildPartial() {
        com.google.cloud.aiplatform.v1beta1.BatchPredictionJob.InputConfig result =
            new com.google.cloud.aiplatform.v1beta1.BatchPredictionJob.InputConfig(this);
        if (sourceCase_ == 2) {
          if (gcsSourceBuilder_ == null) {
            result.source_ = source_;
          } else {
            result.source_ = gcsSourceBuilder_.build();
          }
        }
        if (sourceCase_ == 3) {
          if (bigquerySourceBuilder_ == null) {
            result.source_ = source_;
          } else {
            result.source_ = bigquerySourceBuilder_.build();
          }
        }
        result.instancesFormat_ = instancesFormat_;
        result.sourceCase_ = sourceCase_;
        onBuilt();
        return result;
      }

      @java.lang.Override
      public Builder clone() {
        return super.clone();
      }

      @java.lang.Override
      public Builder setField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.setField(field, value);
      }

      @java.lang.Override
      public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
        return super.clearField(field);
      }

      @java.lang.Override
      public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
        return super.clearOneof(oneof);
      }

      @java.lang.Override
      public Builder setRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          int index,
          java.lang.Object value) {
        return super.setRepeatedField(field, index, value);
      }

      @java.lang.Override
      public Builder addRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.addRepeatedField(field, value);
      }

      @java.lang.Override
      public Builder mergeFrom(com.google.protobuf.Message other) {
        if (other instanceof com.google.cloud.aiplatform.v1beta1.BatchPredictionJob.InputConfig) {
          return mergeFrom(
              (com.google.cloud.aiplatform.v1beta1.BatchPredictionJob.InputConfig) other);
        } else {
          super.mergeFrom(other);
          return this;
        }
      }

      public Builder mergeFrom(
          com.google.cloud.aiplatform.v1beta1.BatchPredictionJob.InputConfig other) {
        if (other
            == com.google.cloud.aiplatform.v1beta1.BatchPredictionJob.InputConfig
                .getDefaultInstance()) return this;
        if (!other.getInstancesFormat().isEmpty()) {
          instancesFormat_ = other.instancesFormat_;
          onChanged();
        }
        switch (other.getSourceCase()) {
          case GCS_SOURCE:
            {
              mergeGcsSource(other.getGcsSource());
              break;
            }
          case BIGQUERY_SOURCE:
            {
              mergeBigquerySource(other.getBigquerySource());
              break;
            }
          case SOURCE_NOT_SET:
            {
              break;
            }
        }
        this.mergeUnknownFields(other.unknownFields);
        onChanged();
        return this;
      }

      @java.lang.Override
      public final boolean isInitialized() {
        return true;
      }

      @java.lang.Override
      public Builder mergeFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        com.google.cloud.aiplatform.v1beta1.BatchPredictionJob.InputConfig parsedMessage = null;
        try {
          parsedMessage = PARSER.parsePartialFrom(input, extensionRegistry);
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          parsedMessage =
              (com.google.cloud.aiplatform.v1beta1.BatchPredictionJob.InputConfig)
                  e.getUnfinishedMessage();
          throw e.unwrapIOException();
        } finally {
          if (parsedMessage != null) {
            mergeFrom(parsedMessage);
          }
        }
        return this;
      }

      private int sourceCase_ = 0;
      private java.lang.Object source_;

      public SourceCase getSourceCase() {
        return SourceCase.forNumber(sourceCase_);
      }

      public Builder clearSource() {
        sourceCase_ = 0;
        source_ = null;
        onChanged();
        return this;
      }

      private com.google.protobuf.SingleFieldBuilderV3<
              com.google.cloud.aiplatform.v1beta1.GcsSource,
              com.google.cloud.aiplatform.v1beta1.GcsSource.Builder,
              com.google.cloud.aiplatform.v1beta1.GcsSourceOrBuilder>
          gcsSourceBuilder_;
      /**
       *
       *
       * <pre>
       * The Cloud Storage location for the input instances.
       * </pre>
       *
       * <code>.google.cloud.aiplatform.v1beta1.GcsSource gcs_source = 2;</code>
       *
       * @return Whether the gcsSource field is set.
       */
      @java.lang.Override
      public boolean hasGcsSource() {
        return sourceCase_ == 2;
      }
      /**
       *
       *
       * <pre>
       * The Cloud Storage location for the input instances.
       * </pre>
       *
       * <code>.google.cloud.aiplatform.v1beta1.GcsSource gcs_source = 2;</code>
       *
       * @return The gcsSource.
       */
      @java.lang.Override
      public com.google.cloud.aiplatform.v1beta1.GcsSource getGcsSource() {
        if (gcsSourceBuilder_ == null) {
          if (sourceCase_ == 2) {
            return (com.google.cloud.aiplatform.v1beta1.GcsSource) source_;
          }
          return com.google.cloud.aiplatform.v1beta1.GcsSource.getDefaultInstance();
        } else {
          if (sourceCase_ == 2) {
            return gcsSourceBuilder_.getMessage();
          }
          return com.google.cloud.aiplatform.v1beta1.GcsSource.getDefaultInstance();
        }
      }
      /**
       *
       *
       * <pre>
       * The Cloud Storage location for the input instances.
       * </pre>
       *
       * <code>.google.cloud.aiplatform.v1beta1.GcsSource gcs_source = 2;</code>
       */
      public Builder setGcsSource(com.google.cloud.aiplatform.v1beta1.GcsSource value) {
        if (gcsSourceBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          source_ = value;
          onChanged();
        } else {
          gcsSourceBuilder_.setMessage(value);
        }
        sourceCase_ = 2;
        return this;
      }
      /**
       *
       *
       * <pre>
       * The Cloud Storage location for the input instances.
       * </pre>
       *
       * <code>.google.cloud.aiplatform.v1beta1.GcsSource gcs_source = 2;</code>
       */
      public Builder setGcsSource(
          com.google.cloud.aiplatform.v1beta1.GcsSource.Builder builderForValue) {
        if (gcsSourceBuilder_ == null) {
          source_ = builderForValue.build();
          onChanged();
        } else {
          gcsSourceBuilder_.setMessage(builderForValue.build());
        }
        sourceCase_ = 2;
        return this;
      }
      /**
       *
       *
       * <pre>
       * The Cloud Storage location for the input instances.
       * </pre>
       *
       * <code>.google.cloud.aiplatform.v1beta1.GcsSource gcs_source = 2;</code>
       */
      public Builder mergeGcsSource(com.google.cloud.aiplatform.v1beta1.GcsSource value) {
        if (gcsSourceBuilder_ == null) {
          if (sourceCase_ == 2
              && source_ != com.google.cloud.aiplatform.v1beta1.GcsSource.getDefaultInstance()) {
            source_ =
                com.google.cloud.aiplatform.v1beta1.GcsSource.newBuilder(
                        (com.google.cloud.aiplatform.v1beta1.GcsSource) source_)
                    .mergeFrom(value)
                    .buildPartial();
          } else {
            source_ = value;
          }
          onChanged();
        } else {
          if (sourceCase_ == 2) {
            gcsSourceBuilder_.mergeFrom(value);
          }
          gcsSourceBuilder_.setMessage(value);
        }
        sourceCase_ = 2;
        return this;
      }
      /**
       *
       *
       * <pre>
       * The Cloud Storage location for the input instances.
       * </pre>
       *
       * <code>.google.cloud.aiplatform.v1beta1.GcsSource gcs_source = 2;</code>
       */
      public Builder clearGcsSource() {
        if (gcsSourceBuilder_ == null) {
          if (sourceCase_ == 2) {
            sourceCase_ = 0;
            source_ = null;
            onChanged();
          }
        } else {
          if (sourceCase_ == 2) {
            sourceCase_ = 0;
            source_ = null;
          }
          gcsSourceBuilder_.clear();
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * The Cloud Storage location for the input instances.
       * </pre>
       *
       * <code>.google.cloud.aiplatform.v1beta1.GcsSource gcs_source = 2;</code>
       */
      public com.google.cloud.aiplatform.v1beta1.GcsSource.Builder getGcsSourceBuilder() {
        return getGcsSourceFieldBuilder().getBuilder();
      }
      /**
       *
       *
       * <pre>
       * The Cloud Storage location for the input instances.
       * </pre>
       *
       * <code>.google.cloud.aiplatform.v1beta1.GcsSource gcs_source = 2;</code>
       */
      @java.lang.Override
      public com.google.cloud.aiplatform.v1beta1.GcsSourceOrBuilder getGcsSourceOrBuilder() {
        if ((sourceCase_ == 2) && (gcsSourceBuilder_ != null)) {
          return gcsSourceBuilder_.getMessageOrBuilder();
        } else {
          if (sourceCase_ == 2) {
            return (com.google.cloud.aiplatform.v1beta1.GcsSource) source_;
          }
          return com.google.cloud.aiplatform.v1beta1.GcsSource.getDefaultInstance();
        }
      }
      /**
       *
       *
       * <pre>
       * The Cloud Storage location for the input instances.
       * </pre>
       *
       * <code>.google.cloud.aiplatform.v1beta1.GcsSource gcs_source = 2;</code>
       */
      private com.google.protobuf.SingleFieldBuilderV3<
              com.google.cloud.aiplatform.v1beta1.GcsSource,
              com.google.cloud.aiplatform.v1beta1.GcsSource.Builder,
              com.google.cloud.aiplatform.v1beta1.GcsSourceOrBuilder>
          getGcsSourceFieldBuilder() {
        if (gcsSourceBuilder_ == null) {
          if (!(sourceCase_ == 2)) {
            source_ = com.google.cloud.aiplatform.v1beta1.GcsSource.getDefaultInstance();
          }
          gcsSourceBuilder_ =
              new com.google.protobuf.SingleFieldBuilderV3<
                  com.google.cloud.aiplatform.v1beta1.GcsSource,
                  com.google.cloud.aiplatform.v1beta1.GcsSource.Builder,
                  com.google.cloud.aiplatform.v1beta1.GcsSourceOrBuilder>(
                  (com.google.cloud.aiplatform.v1beta1.GcsSource) source_,
                  getParentForChildren(),
                  isClean());
          source_ = null;
        }
        sourceCase_ = 2;
        onChanged();
        ;
        return gcsSourceBuilder_;
      }

      private com.google.protobuf.SingleFieldBuilderV3<
              com.google.cloud.aiplatform.v1beta1.BigQuerySource,
              com.google.cloud.aiplatform.v1beta1.BigQuerySource.Builder,
              com.google.cloud.aiplatform.v1beta1.BigQuerySourceOrBuilder>
          bigquerySourceBuilder_;
      /**
       *
       *
       * <pre>
       * The BigQuery location of the input table.
       * The schema of the table should be in the format described by the given
       * context OpenAPI Schema, if one is provided. The table may contain
       * additional columns that are not described by the schema, and they will
       * be ignored.
       * </pre>
       *
       * <code>.google.cloud.aiplatform.v1beta1.BigQuerySource bigquery_source = 3;</code>
       *
       * @return Whether the bigquerySource field is set.
       */
      @java.lang.Override
      public boolean hasBigquerySource() {
        return sourceCase_ == 3;
      }
      /**
       *
       *
       * <pre>
       * The BigQuery location of the input table.
       * The schema of the table should be in the format described by the given
       * context OpenAPI Schema, if one is provided. The table may contain
       * additional columns that are not described by the schema, and they will
       * be ignored.
       * </pre>
       *
       * <code>.google.cloud.aiplatform.v1beta1.BigQuerySource bigquery_source = 3;</code>
       *
       * @return The bigquerySource.
       */
      @java.lang.Override
      public com.google.cloud.aiplatform.v1beta1.BigQuerySource getBigquerySource() {
        if (bigquerySourceBuilder_ == null) {
          if (sourceCase_ == 3) {
            return (com.google.cloud.aiplatform.v1beta1.BigQuerySource) source_;
          }
          return com.google.cloud.aiplatform.v1beta1.BigQuerySource.getDefaultInstance();
        } else {
          if (sourceCase_ == 3) {
            return bigquerySourceBuilder_.getMessage();
          }
          return com.google.cloud.aiplatform.v1beta1.BigQuerySource.getDefaultInstance();
        }
      }
      /**
       *
       *
       * <pre>
       * The BigQuery location of the input table.
       * The schema of the table should be in the format described by the given
       * context OpenAPI Schema, if one is provided. The table may contain
       * additional columns that are not described by the schema, and they will
       * be ignored.
       * </pre>
       *
       * <code>.google.cloud.aiplatform.v1beta1.BigQuerySource bigquery_source = 3;</code>
       */
      public Builder setBigquerySource(com.google.cloud.aiplatform.v1beta1.BigQuerySource value) {
        if (bigquerySourceBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          source_ = value;
          onChanged();
        } else {
          bigquerySourceBuilder_.setMessage(value);
        }
        sourceCase_ = 3;
        return this;
      }
      /**
       *
       *
       * <pre>
       * The BigQuery location of the input table.
       * The schema of the table should be in the format described by the given
       * context OpenAPI Schema, if one is provided. The table may contain
       * additional columns that are not described by the schema, and they will
       * be ignored.
       * </pre>
       *
       * <code>.google.cloud.aiplatform.v1beta1.BigQuerySource bigquery_source = 3;</code>
       */
      public Builder setBigquerySource(
          com.google.cloud.aiplatform.v1beta1.BigQuerySource.Builder builderForValue) {
        if (bigquerySourceBuilder_ == null) {
          source_ = builderForValue.build();
          onChanged();
        } else {
          bigquerySourceBuilder_.setMessage(builderForValue.build());
        }
        sourceCase_ = 3;
        return this;
      }
      /**
       *
       *
       * <pre>
       * The BigQuery location of the input table.
       * The schema of the table should be in the format described by the given
       * context OpenAPI Schema, if one is provided. The table may contain
       * additional columns that are not described by the schema, and they will
       * be ignored.
       * </pre>
       *
       * <code>.google.cloud.aiplatform.v1beta1.BigQuerySource bigquery_source = 3;</code>
       */
      public Builder mergeBigquerySource(com.google.cloud.aiplatform.v1beta1.BigQuerySource value) {
        if (bigquerySourceBuilder_ == null) {
          if (sourceCase_ == 3
              && source_
                  != com.google.cloud.aiplatform.v1beta1.BigQuerySource.getDefaultInstance()) {
            source_ =
                com.google.cloud.aiplatform.v1beta1.BigQuerySource.newBuilder(
                        (com.google.cloud.aiplatform.v1beta1.BigQuerySource) source_)
                    .mergeFrom(value)
                    .buildPartial();
          } else {
            source_ = value;
          }
          onChanged();
        } else {
          if (sourceCase_ == 3) {
            bigquerySourceBuilder_.mergeFrom(value);
          }
          bigquerySourceBuilder_.setMessage(value);
        }
        sourceCase_ = 3;
        return this;
      }
      /**
       *
       *
       * <pre>
       * The BigQuery location of the input table.
       * The schema of the table should be in the format described by the given
       * context OpenAPI Schema, if one is provided. The table may contain
       * additional columns that are not described by the schema, and they will
       * be ignored.
       * </pre>
       *
       * <code>.google.cloud.aiplatform.v1beta1.BigQuerySource bigquery_source = 3;</code>
       */
      public Builder clearBigquerySource() {
        if (bigquerySourceBuilder_ == null) {
          if (sourceCase_ == 3) {
            sourceCase_ = 0;
            source_ = null;
            onChanged();
          }
        } else {
          if (sourceCase_ == 3) {
            sourceCase_ = 0;
            source_ = null;
          }
          bigquerySourceBuilder_.clear();
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * The BigQuery location of the input table.
       * The schema of the table should be in the format described by the given
       * context OpenAPI Schema, if one is provided. The table may contain
       * additional columns that are not described by the schema, and they will
       * be ignored.
       * </pre>
       *
       * <code>.google.cloud.aiplatform.v1beta1.BigQuerySource bigquery_source = 3;</code>
       */
      public com.google.cloud.aiplatform.v1beta1.BigQuerySource.Builder getBigquerySourceBuilder() {
        return getBigquerySourceFieldBuilder().getBuilder();
      }
      /**
       *
       *
       * <pre>
       * The BigQuery location of the input table.
       * The schema of the table should be in the format described by the given
       * context OpenAPI Schema, if one is provided. The table may contain
       * additional columns that are not described by the schema, and they will
       * be ignored.
       * </pre>
       *
       * <code>.google.cloud.aiplatform.v1beta1.BigQuerySource bigquery_source = 3;</code>
       */
      @java.lang.Override
      public com.google.cloud.aiplatform.v1beta1.BigQuerySourceOrBuilder
          getBigquerySourceOrBuilder() {
        if ((sourceCase_ == 3) && (bigquerySourceBuilder_ != null)) {
          return bigquerySourceBuilder_.getMessageOrBuilder();
        } else {
          if (sourceCase_ == 3) {
            return (com.google.cloud.aiplatform.v1beta1.BigQuerySource) source_;
          }
          return com.google.cloud.aiplatform.v1beta1.BigQuerySource.getDefaultInstance();
        }
      }
      /**
       *
       *
       * <pre>
       * The BigQuery location of the input table.
       * The schema of the table should be in the format described by the given
       * context OpenAPI Schema, if one is provided. The table may contain
       * additional columns that are not described by the schema, and they will
       * be ignored.
       * </pre>
       *
       * <code>.google.cloud.aiplatform.v1beta1.BigQuerySource bigquery_source = 3;</code>
       */
      private com.google.protobuf.SingleFieldBuilderV3<
              com.google.cloud.aiplatform.v1beta1.BigQuerySource,
              com.google.cloud.aiplatform.v1beta1.BigQuerySource.Builder,
              com.google.cloud.aiplatform.v1beta1.BigQuerySourceOrBuilder>
          getBigquerySourceFieldBuilder() {
        if (bigquerySourceBuilder_ == null) {
          if (!(sourceCase_ == 3)) {
            source_ = com.google.cloud.aiplatform.v1beta1.BigQuerySource.getDefaultInstance();
          }
          bigquerySourceBuilder_ =
              new com.google.protobuf.SingleFieldBuilderV3<
                  com.google.cloud.aiplatform.v1beta1.BigQuerySource,
                  com.google.cloud.aiplatform.v1beta1.BigQuerySource.Builder,
                  com.google.cloud.aiplatform.v1beta1.BigQuerySourceOrBuilder>(
                  (com.google.cloud.aiplatform.v1beta1.BigQuerySource) source_,
                  getParentForChildren(),
                  isClean());
          source_ = null;
        }
        sourceCase_ = 3;
        onChanged();
        ;
        return bigquerySourceBuilder_;
      }

      private java.lang.Object instancesFormat_ = "";
      /**
       *
       *
       * <pre>
       * Required. The format in which instances are given, must be one of the
       * [Model's][google.cloud.aiplatform.v1beta1.BatchPredictionJob.model]
       * [supported_input_storage_formats][google.cloud.aiplatform.v1beta1.Model.supported_input_storage_formats].
       * </pre>
       *
       * <code>string instances_format = 1 [(.google.api.field_behavior) = REQUIRED];</code>
       *
       * @return The instancesFormat.
       */
      public java.lang.String getInstancesFormat() {
        java.lang.Object ref = instancesFormat_;
        if (!(ref instanceof java.lang.String)) {
          com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
          java.lang.String s = bs.toStringUtf8();
          instancesFormat_ = s;
          return s;
        } else {
          return (java.lang.String) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * Required. The format in which instances are given, must be one of the
       * [Model's][google.cloud.aiplatform.v1beta1.BatchPredictionJob.model]
       * [supported_input_storage_formats][google.cloud.aiplatform.v1beta1.Model.supported_input_storage_formats].
       * </pre>
       *
       * <code>string instances_format = 1 [(.google.api.field_behavior) = REQUIRED];</code>
       *
       * @return The bytes for instancesFormat.
       */
      public com.google.protobuf.ByteString getInstancesFormatBytes() {
        java.lang.Object ref = instancesFormat_;
        if (ref instanceof String) {
          com.google.protobuf.ByteString b =
              com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
          instancesFormat_ = b;
          return b;
        } else {
          return (com.google.protobuf.ByteString) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * Required. The format in which instances are given, must be one of the
       * [Model's][google.cloud.aiplatform.v1beta1.BatchPredictionJob.model]
       * [supported_input_storage_formats][google.cloud.aiplatform.v1beta1.Model.supported_input_storage_formats].
       * </pre>
       *
       * <code>string instances_format = 1 [(.google.api.field_behavior) = REQUIRED];</code>
       *
       * @param value The instancesFormat to set.
       * @return This builder for chaining.
       */
      public Builder setInstancesFormat(java.lang.String value) {
        if (value == null) {
          throw new NullPointerException();
        }

        instancesFormat_ = value;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Required. The format in which instances are given, must be one of the
       * [Model's][google.cloud.aiplatform.v1beta1.BatchPredictionJob.model]
       * [supported_input_storage_formats][google.cloud.aiplatform.v1beta1.Model.supported_input_storage_formats].
       * </pre>
       *
       * <code>string instances_format = 1 [(.google.api.field_behavior) = REQUIRED];</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearInstancesFormat() {

        instancesFormat_ = getDefaultInstance().getInstancesFormat();
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Required. The format in which instances are given, must be one of the
       * [Model's][google.cloud.aiplatform.v1beta1.BatchPredictionJob.model]
       * [supported_input_storage_formats][google.cloud.aiplatform.v1beta1.Model.supported_input_storage_formats].
       * </pre>
       *
       * <code>string instances_format = 1 [(.google.api.field_behavior) = REQUIRED];</code>
       *
       * @param value The bytes for instancesFormat to set.
       * @return This builder for chaining.
       */
      public Builder setInstancesFormatBytes(com.google.protobuf.ByteString value) {
        if (value == null) {
          throw new NullPointerException();
        }
        checkByteStringIsUtf8(value);

        instancesFormat_ = value;
        onChanged();
        return this;
      }

      @java.lang.Override
      public final Builder setUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.setUnknownFields(unknownFields);
      }

      @java.lang.Override
      public final Builder mergeUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.mergeUnknownFields(unknownFields);
      }

      // @@protoc_insertion_point(builder_scope:google.cloud.aiplatform.v1beta1.BatchPredictionJob.InputConfig)
    }

    // @@protoc_insertion_point(class_scope:google.cloud.aiplatform.v1beta1.BatchPredictionJob.InputConfig)
    private static final com.google.cloud.aiplatform.v1beta1.BatchPredictionJob.InputConfig
        DEFAULT_INSTANCE;

    static {
      DEFAULT_INSTANCE = new com.google.cloud.aiplatform.v1beta1.BatchPredictionJob.InputConfig();
    }

    public static com.google.cloud.aiplatform.v1beta1.BatchPredictionJob.InputConfig
        getDefaultInstance() {
      return DEFAULT_INSTANCE;
    }

    private static final com.google.protobuf.Parser<InputConfig> PARSER =
        new com.google.protobuf.AbstractParser<InputConfig>() {
          @java.lang.Override
          public InputConfig parsePartialFrom(
              com.google.protobuf.CodedInputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
            return new InputConfig(input, extensionRegistry);
          }
        };

    public static com.google.protobuf.Parser<InputConfig> parser() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.protobuf.Parser<InputConfig> getParserForType() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.cloud.aiplatform.v1beta1.BatchPredictionJob.InputConfig
        getDefaultInstanceForType() {
      return DEFAULT_INSTANCE;
    }
  }

  public interface OutputConfigOrBuilder
      extends
      // @@protoc_insertion_point(interface_extends:google.cloud.aiplatform.v1beta1.BatchPredictionJob.OutputConfig)
      com.google.protobuf.MessageOrBuilder {

    /**
     *
     *
     * <pre>
     * The Cloud Storage location of the directory where the output is
     * to be written to. In the given directory a new directory is created.
     * Its name is `prediction-&lt;model-display-name&gt;-&lt;job-create-time&gt;`,
     * where timestamp is in YYYY-MM-DDThh:mm:ss.sssZ ISO-8601 format.
     * Inside of it files `predictions_0001.&lt;extension&gt;`,
     * `predictions_0002.&lt;extension&gt;`, ..., `predictions_N.&lt;extension&gt;`
     * are created where `&lt;extension&gt;` depends on chosen
     * [predictions_format][google.cloud.aiplatform.v1beta1.BatchPredictionJob.OutputConfig.predictions_format], and N may equal 0001 and depends on the total
     * number of successfully predicted instances.
     * If the Model has both [instance][google.cloud.aiplatform.v1beta1.PredictSchemata.instance_schema_uri]
     * and [prediction][google.cloud.aiplatform.v1beta1.PredictSchemata.parameters_schema_uri] schemata
     * defined then each such file contains predictions as per the
     * [predictions_format][google.cloud.aiplatform.v1beta1.BatchPredictionJob.OutputConfig.predictions_format].
     * If prediction for any instance failed (partially or completely), then
     * an additional `errors_0001.&lt;extension&gt;`, `errors_0002.&lt;extension&gt;`,...,
     * `errors_N.&lt;extension&gt;` files are created (N depends on total number
     * of failed predictions). These files contain the failed instances,
     * as per their schema, followed by an additional `error` field which as
     * value has [google.rpc.Status][google.rpc.Status]
     * containing only `code` and `message` fields.
     * </pre>
     *
     * <code>.google.cloud.aiplatform.v1beta1.GcsDestination gcs_destination = 2;</code>
     *
     * @return Whether the gcsDestination field is set.
     */
    boolean hasGcsDestination();
    /**
     *
     *
     * <pre>
     * The Cloud Storage location of the directory where the output is
     * to be written to. In the given directory a new directory is created.
     * Its name is `prediction-&lt;model-display-name&gt;-&lt;job-create-time&gt;`,
     * where timestamp is in YYYY-MM-DDThh:mm:ss.sssZ ISO-8601 format.
     * Inside of it files `predictions_0001.&lt;extension&gt;`,
     * `predictions_0002.&lt;extension&gt;`, ..., `predictions_N.&lt;extension&gt;`
     * are created where `&lt;extension&gt;` depends on chosen
     * [predictions_format][google.cloud.aiplatform.v1beta1.BatchPredictionJob.OutputConfig.predictions_format], and N may equal 0001 and depends on the total
     * number of successfully predicted instances.
     * If the Model has both [instance][google.cloud.aiplatform.v1beta1.PredictSchemata.instance_schema_uri]
     * and [prediction][google.cloud.aiplatform.v1beta1.PredictSchemata.parameters_schema_uri] schemata
     * defined then each such file contains predictions as per the
     * [predictions_format][google.cloud.aiplatform.v1beta1.BatchPredictionJob.OutputConfig.predictions_format].
     * If prediction for any instance failed (partially or completely), then
     * an additional `errors_0001.&lt;extension&gt;`, `errors_0002.&lt;extension&gt;`,...,
     * `errors_N.&lt;extension&gt;` files are created (N depends on total number
     * of failed predictions). These files contain the failed instances,
     * as per their schema, followed by an additional `error` field which as
     * value has [google.rpc.Status][google.rpc.Status]
     * containing only `code` and `message` fields.
     * </pre>
     *
     * <code>.google.cloud.aiplatform.v1beta1.GcsDestination gcs_destination = 2;</code>
     *
     * @return The gcsDestination.
     */
    com.google.cloud.aiplatform.v1beta1.GcsDestination getGcsDestination();
    /**
     *
     *
     * <pre>
     * The Cloud Storage location of the directory where the output is
     * to be written to. In the given directory a new directory is created.
     * Its name is `prediction-&lt;model-display-name&gt;-&lt;job-create-time&gt;`,
     * where timestamp is in YYYY-MM-DDThh:mm:ss.sssZ ISO-8601 format.
     * Inside of it files `predictions_0001.&lt;extension&gt;`,
     * `predictions_0002.&lt;extension&gt;`, ..., `predictions_N.&lt;extension&gt;`
     * are created where `&lt;extension&gt;` depends on chosen
     * [predictions_format][google.cloud.aiplatform.v1beta1.BatchPredictionJob.OutputConfig.predictions_format], and N may equal 0001 and depends on the total
     * number of successfully predicted instances.
     * If the Model has both [instance][google.cloud.aiplatform.v1beta1.PredictSchemata.instance_schema_uri]
     * and [prediction][google.cloud.aiplatform.v1beta1.PredictSchemata.parameters_schema_uri] schemata
     * defined then each such file contains predictions as per the
     * [predictions_format][google.cloud.aiplatform.v1beta1.BatchPredictionJob.OutputConfig.predictions_format].
     * If prediction for any instance failed (partially or completely), then
     * an additional `errors_0001.&lt;extension&gt;`, `errors_0002.&lt;extension&gt;`,...,
     * `errors_N.&lt;extension&gt;` files are created (N depends on total number
     * of failed predictions). These files contain the failed instances,
     * as per their schema, followed by an additional `error` field which as
     * value has [google.rpc.Status][google.rpc.Status]
     * containing only `code` and `message` fields.
     * </pre>
     *
     * <code>.google.cloud.aiplatform.v1beta1.GcsDestination gcs_destination = 2;</code>
     */
    com.google.cloud.aiplatform.v1beta1.GcsDestinationOrBuilder getGcsDestinationOrBuilder();

    /**
     *
     *
     * <pre>
     * The BigQuery project or dataset location where the output is to be
     * written to. If project is provided, a new dataset is created with name
     * `prediction_&lt;model-display-name&gt;_&lt;job-create-time&gt;`
     * where &lt;model-display-name&gt; is made
     * BigQuery-dataset-name compatible (for example, most special characters
     * become underscores), and timestamp is in
     * YYYY_MM_DDThh_mm_ss_sssZ "based on ISO-8601" format. In the dataset
     * two tables will be created, `predictions`, and `errors`.
     * If the Model has both [instance][google.cloud.aiplatform.v1beta1.PredictSchemata.instance_schema_uri]
     * and [prediction][google.cloud.aiplatform.v1beta1.PredictSchemata.parameters_schema_uri] schemata
     * defined then the tables have columns as follows: The `predictions`
     * table contains instances for which the prediction succeeded, it
     * has columns as per a concatenation of the Model's instance and
     * prediction schemata. The `errors` table contains rows for which the
     * prediction has failed, it has instance columns, as per the
     * instance schema, followed by a single "errors" column, which as values
     * has [google.rpc.Status][google.rpc.Status]
     * represented as a STRUCT, and containing only `code` and `message`.
     * </pre>
     *
     * <code>.google.cloud.aiplatform.v1beta1.BigQueryDestination bigquery_destination = 3;</code>
     *
     * @return Whether the bigqueryDestination field is set.
     */
    boolean hasBigqueryDestination();
    /**
     *
     *
     * <pre>
     * The BigQuery project or dataset location where the output is to be
     * written to. If project is provided, a new dataset is created with name
     * `prediction_&lt;model-display-name&gt;_&lt;job-create-time&gt;`
     * where &lt;model-display-name&gt; is made
     * BigQuery-dataset-name compatible (for example, most special characters
     * become underscores), and timestamp is in
     * YYYY_MM_DDThh_mm_ss_sssZ "based on ISO-8601" format. In the dataset
     * two tables will be created, `predictions`, and `errors`.
     * If the Model has both [instance][google.cloud.aiplatform.v1beta1.PredictSchemata.instance_schema_uri]
     * and [prediction][google.cloud.aiplatform.v1beta1.PredictSchemata.parameters_schema_uri] schemata
     * defined then the tables have columns as follows: The `predictions`
     * table contains instances for which the prediction succeeded, it
     * has columns as per a concatenation of the Model's instance and
     * prediction schemata. The `errors` table contains rows for which the
     * prediction has failed, it has instance columns, as per the
     * instance schema, followed by a single "errors" column, which as values
     * has [google.rpc.Status][google.rpc.Status]
     * represented as a STRUCT, and containing only `code` and `message`.
     * </pre>
     *
     * <code>.google.cloud.aiplatform.v1beta1.BigQueryDestination bigquery_destination = 3;</code>
     *
     * @return The bigqueryDestination.
     */
    com.google.cloud.aiplatform.v1beta1.BigQueryDestination getBigqueryDestination();
    /**
     *
     *
     * <pre>
     * The BigQuery project or dataset location where the output is to be
     * written to. If project is provided, a new dataset is created with name
     * `prediction_&lt;model-display-name&gt;_&lt;job-create-time&gt;`
     * where &lt;model-display-name&gt; is made
     * BigQuery-dataset-name compatible (for example, most special characters
     * become underscores), and timestamp is in
     * YYYY_MM_DDThh_mm_ss_sssZ "based on ISO-8601" format. In the dataset
     * two tables will be created, `predictions`, and `errors`.
     * If the Model has both [instance][google.cloud.aiplatform.v1beta1.PredictSchemata.instance_schema_uri]
     * and [prediction][google.cloud.aiplatform.v1beta1.PredictSchemata.parameters_schema_uri] schemata
     * defined then the tables have columns as follows: The `predictions`
     * table contains instances for which the prediction succeeded, it
     * has columns as per a concatenation of the Model's instance and
     * prediction schemata. The `errors` table contains rows for which the
     * prediction has failed, it has instance columns, as per the
     * instance schema, followed by a single "errors" column, which as values
     * has [google.rpc.Status][google.rpc.Status]
     * represented as a STRUCT, and containing only `code` and `message`.
     * </pre>
     *
     * <code>.google.cloud.aiplatform.v1beta1.BigQueryDestination bigquery_destination = 3;</code>
     */
    com.google.cloud.aiplatform.v1beta1.BigQueryDestinationOrBuilder
        getBigqueryDestinationOrBuilder();

    /**
     *
     *
     * <pre>
     * Required. The format in which Vertex AI gives the predictions, must be one of the
     * [Model's][google.cloud.aiplatform.v1beta1.BatchPredictionJob.model]
     * [supported_output_storage_formats][google.cloud.aiplatform.v1beta1.Model.supported_output_storage_formats].
     * </pre>
     *
     * <code>string predictions_format = 1 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return The predictionsFormat.
     */
    java.lang.String getPredictionsFormat();
    /**
     *
     *
     * <pre>
     * Required. The format in which Vertex AI gives the predictions, must be one of the
     * [Model's][google.cloud.aiplatform.v1beta1.BatchPredictionJob.model]
     * [supported_output_storage_formats][google.cloud.aiplatform.v1beta1.Model.supported_output_storage_formats].
     * </pre>
     *
     * <code>string predictions_format = 1 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return The bytes for predictionsFormat.
     */
    com.google.protobuf.ByteString getPredictionsFormatBytes();

    public com.google.cloud.aiplatform.v1beta1.BatchPredictionJob.OutputConfig.DestinationCase
        getDestinationCase();
  }
  /**
   *
   *
   * <pre>
   * Configures the output of [BatchPredictionJob][google.cloud.aiplatform.v1beta1.BatchPredictionJob].
   * See [Model.supported_output_storage_formats][google.cloud.aiplatform.v1beta1.Model.supported_output_storage_formats] for supported output
   * formats, and how predictions are expressed via any of them.
   * </pre>
   *
   * Protobuf type {@code google.cloud.aiplatform.v1beta1.BatchPredictionJob.OutputConfig}
   */
  public static final class OutputConfig extends com.google.protobuf.GeneratedMessageV3
      implements
      // @@protoc_insertion_point(message_implements:google.cloud.aiplatform.v1beta1.BatchPredictionJob.OutputConfig)
      OutputConfigOrBuilder {
    private static final long serialVersionUID = 0L;
    // Use OutputConfig.newBuilder() to construct.
    private OutputConfig(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
      super(builder);
    }

    private OutputConfig() {
      predictionsFormat_ = "";
    }

    @java.lang.Override
    @SuppressWarnings({"unused"})
    protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
      return new OutputConfig();
    }

    @java.lang.Override
    public final com.google.protobuf.UnknownFieldSet getUnknownFields() {
      return this.unknownFields;
    }

    private OutputConfig(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      this();
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      com.google.protobuf.UnknownFieldSet.Builder unknownFields =
          com.google.protobuf.UnknownFieldSet.newBuilder();
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 10:
              {
                java.lang.String s = input.readStringRequireUtf8();

                predictionsFormat_ = s;
                break;
              }
            case 18:
              {
                com.google.cloud.aiplatform.v1beta1.GcsDestination.Builder subBuilder = null;
                if (destinationCase_ == 2) {
                  subBuilder =
                      ((com.google.cloud.aiplatform.v1beta1.GcsDestination) destination_)
                          .toBuilder();
                }
                destination_ =
                    input.readMessage(
                        com.google.cloud.aiplatform.v1beta1.GcsDestination.parser(),
                        extensionRegistry);
                if (subBuilder != null) {
                  subBuilder.mergeFrom(
                      (com.google.cloud.aiplatform.v1beta1.GcsDestination) destination_);
                  destination_ = subBuilder.buildPartial();
                }
                destinationCase_ = 2;
                break;
              }
            case 26:
              {
                com.google.cloud.aiplatform.v1beta1.BigQueryDestination.Builder subBuilder = null;
                if (destinationCase_ == 3) {
                  subBuilder =
                      ((com.google.cloud.aiplatform.v1beta1.BigQueryDestination) destination_)
                          .toBuilder();
                }
                destination_ =
                    input.readMessage(
                        com.google.cloud.aiplatform.v1beta1.BigQueryDestination.parser(),
                        extensionRegistry);
                if (subBuilder != null) {
                  subBuilder.mergeFrom(
                      (com.google.cloud.aiplatform.v1beta1.BigQueryDestination) destination_);
                  destination_ = subBuilder.buildPartial();
                }
                destinationCase_ = 3;
                break;
              }
            default:
              {
                if (!parseUnknownField(input, unknownFields, extensionRegistry, tag)) {
                  done = true;
                }
                break;
              }
          }
        }
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.setUnfinishedMessage(this);
      } catch (java.io.IOException e) {
        throw new com.google.protobuf.InvalidProtocolBufferException(e).setUnfinishedMessage(this);
      } finally {
        this.unknownFields = unknownFields.build();
        makeExtensionsImmutable();
      }
    }

    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.aiplatform.v1beta1.BatchPredictionJobProto
          .internal_static_google_cloud_aiplatform_v1beta1_BatchPredictionJob_OutputConfig_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.aiplatform.v1beta1.BatchPredictionJobProto
          .internal_static_google_cloud_aiplatform_v1beta1_BatchPredictionJob_OutputConfig_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.aiplatform.v1beta1.BatchPredictionJob.OutputConfig.class,
              com.google.cloud.aiplatform.v1beta1.BatchPredictionJob.OutputConfig.Builder.class);
    }

    private int destinationCase_ = 0;
    private java.lang.Object destination_;

    public enum DestinationCase
        implements
            com.google.protobuf.Internal.EnumLite,
            com.google.protobuf.AbstractMessage.InternalOneOfEnum {
      GCS_DESTINATION(2),
      BIGQUERY_DESTINATION(3),
      DESTINATION_NOT_SET(0);
      private final int value;

      private DestinationCase(int value) {
        this.value = value;
      }
      /**
       * @param value The number of the enum to look for.
       * @return The enum associated with the given number.
       * @deprecated Use {@link #forNumber(int)} instead.
       */
      @java.lang.Deprecated
      public static DestinationCase valueOf(int value) {
        return forNumber(value);
      }

      public static DestinationCase forNumber(int value) {
        switch (value) {
          case 2:
            return GCS_DESTINATION;
          case 3:
            return BIGQUERY_DESTINATION;
          case 0:
            return DESTINATION_NOT_SET;
          default:
            return null;
        }
      }

      public int getNumber() {
        return this.value;
      }
    };

    public DestinationCase getDestinationCase() {
      return DestinationCase.forNumber(destinationCase_);
    }

    public static final int GCS_DESTINATION_FIELD_NUMBER = 2;
    /**
     *
     *
     * <pre>
     * The Cloud Storage location of the directory where the output is
     * to be written to. In the given directory a new directory is created.
     * Its name is `prediction-&lt;model-display-name&gt;-&lt;job-create-time&gt;`,
     * where timestamp is in YYYY-MM-DDThh:mm:ss.sssZ ISO-8601 format.
     * Inside of it files `predictions_0001.&lt;extension&gt;`,
     * `predictions_0002.&lt;extension&gt;`, ..., `predictions_N.&lt;extension&gt;`
     * are created where `&lt;extension&gt;` depends on chosen
     * [predictions_format][google.cloud.aiplatform.v1beta1.BatchPredictionJob.OutputConfig.predictions_format], and N may equal 0001 and depends on the total
     * number of successfully predicted instances.
     * If the Model has both [instance][google.cloud.aiplatform.v1beta1.PredictSchemata.instance_schema_uri]
     * and [prediction][google.cloud.aiplatform.v1beta1.PredictSchemata.parameters_schema_uri] schemata
     * defined then each such file contains predictions as per the
     * [predictions_format][google.cloud.aiplatform.v1beta1.BatchPredictionJob.OutputConfig.predictions_format].
     * If prediction for any instance failed (partially or completely), then
     * an additional `errors_0001.&lt;extension&gt;`, `errors_0002.&lt;extension&gt;`,...,
     * `errors_N.&lt;extension&gt;` files are created (N depends on total number
     * of failed predictions). These files contain the failed instances,
     * as per their schema, followed by an additional `error` field which as
     * value has [google.rpc.Status][google.rpc.Status]
     * containing only `code` and `message` fields.
     * </pre>
     *
     * <code>.google.cloud.aiplatform.v1beta1.GcsDestination gcs_destination = 2;</code>
     *
     * @return Whether the gcsDestination field is set.
     */
    @java.lang.Override
    public boolean hasGcsDestination() {
      return destinationCase_ == 2;
    }
    /**
     *
     *
     * <pre>
     * The Cloud Storage location of the directory where the output is
     * to be written to. In the given directory a new directory is created.
     * Its name is `prediction-&lt;model-display-name&gt;-&lt;job-create-time&gt;`,
     * where timestamp is in YYYY-MM-DDThh:mm:ss.sssZ ISO-8601 format.
     * Inside of it files `predictions_0001.&lt;extension&gt;`,
     * `predictions_0002.&lt;extension&gt;`, ..., `predictions_N.&lt;extension&gt;`
     * are created where `&lt;extension&gt;` depends on chosen
     * [predictions_format][google.cloud.aiplatform.v1beta1.BatchPredictionJob.OutputConfig.predictions_format], and N may equal 0001 and depends on the total
     * number of successfully predicted instances.
     * If the Model has both [instance][google.cloud.aiplatform.v1beta1.PredictSchemata.instance_schema_uri]
     * and [prediction][google.cloud.aiplatform.v1beta1.PredictSchemata.parameters_schema_uri] schemata
     * defined then each such file contains predictions as per the
     * [predictions_format][google.cloud.aiplatform.v1beta1.BatchPredictionJob.OutputConfig.predictions_format].
     * If prediction for any instance failed (partially or completely), then
     * an additional `errors_0001.&lt;extension&gt;`, `errors_0002.&lt;extension&gt;`,...,
     * `errors_N.&lt;extension&gt;` files are created (N depends on total number
     * of failed predictions). These files contain the failed instances,
     * as per their schema, followed by an additional `error` field which as
     * value has [google.rpc.Status][google.rpc.Status]
     * containing only `code` and `message` fields.
     * </pre>
     *
     * <code>.google.cloud.aiplatform.v1beta1.GcsDestination gcs_destination = 2;</code>
     *
     * @return The gcsDestination.
     */
    @java.lang.Override
    public com.google.cloud.aiplatform.v1beta1.GcsDestination getGcsDestination() {
      if (destinationCase_ == 2) {
        return (com.google.cloud.aiplatform.v1beta1.GcsDestination) destination_;
      }
      return com.google.cloud.aiplatform.v1beta1.GcsDestination.getDefaultInstance();
    }
    /**
     *
     *
     * <pre>
     * The Cloud Storage location of the directory where the output is
     * to be written to. In the given directory a new directory is created.
     * Its name is `prediction-&lt;model-display-name&gt;-&lt;job-create-time&gt;`,
     * where timestamp is in YYYY-MM-DDThh:mm:ss.sssZ ISO-8601 format.
     * Inside of it files `predictions_0001.&lt;extension&gt;`,
     * `predictions_0002.&lt;extension&gt;`, ..., `predictions_N.&lt;extension&gt;`
     * are created where `&lt;extension&gt;` depends on chosen
     * [predictions_format][google.cloud.aiplatform.v1beta1.BatchPredictionJob.OutputConfig.predictions_format], and N may equal 0001 and depends on the total
     * number of successfully predicted instances.
     * If the Model has both [instance][google.cloud.aiplatform.v1beta1.PredictSchemata.instance_schema_uri]
     * and [prediction][google.cloud.aiplatform.v1beta1.PredictSchemata.parameters_schema_uri] schemata
     * defined then each such file contains predictions as per the
     * [predictions_format][google.cloud.aiplatform.v1beta1.BatchPredictionJob.OutputConfig.predictions_format].
     * If prediction for any instance failed (partially or completely), then
     * an additional `errors_0001.&lt;extension&gt;`, `errors_0002.&lt;extension&gt;`,...,
     * `errors_N.&lt;extension&gt;` files are created (N depends on total number
     * of failed predictions). These files contain the failed instances,
     * as per their schema, followed by an additional `error` field which as
     * value has [google.rpc.Status][google.rpc.Status]
     * containing only `code` and `message` fields.
     * </pre>
     *
     * <code>.google.cloud.aiplatform.v1beta1.GcsDestination gcs_destination = 2;</code>
     */
    @java.lang.Override
    public com.google.cloud.aiplatform.v1beta1.GcsDestinationOrBuilder
        getGcsDestinationOrBuilder() {
      if (destinationCase_ == 2) {
        return (com.google.cloud.aiplatform.v1beta1.GcsDestination) destination_;
      }
      return com.google.cloud.aiplatform.v1beta1.GcsDestination.getDefaultInstance();
    }

    public static final int BIGQUERY_DESTINATION_FIELD_NUMBER = 3;
    /**
     *
     *
     * <pre>
     * The BigQuery project or dataset location where the output is to be
     * written to. If project is provided, a new dataset is created with name
     * `prediction_&lt;model-display-name&gt;_&lt;job-create-time&gt;`
     * where &lt;model-display-name&gt; is made
     * BigQuery-dataset-name compatible (for example, most special characters
     * become underscores), and timestamp is in
     * YYYY_MM_DDThh_mm_ss_sssZ "based on ISO-8601" format. In the dataset
     * two tables will be created, `predictions`, and `errors`.
     * If the Model has both [instance][google.cloud.aiplatform.v1beta1.PredictSchemata.instance_schema_uri]
     * and [prediction][google.cloud.aiplatform.v1beta1.PredictSchemata.parameters_schema_uri] schemata
     * defined then the tables have columns as follows: The `predictions`
     * table contains instances for which the prediction succeeded, it
     * has columns as per a concatenation of the Model's instance and
     * prediction schemata. The `errors` table contains rows for which the
     * prediction has failed, it has instance columns, as per the
     * instance schema, followed by a single "errors" column, which as values
     * has [google.rpc.Status][google.rpc.Status]
     * represented as a STRUCT, and containing only `code` and `message`.
     * </pre>
     *
     * <code>.google.cloud.aiplatform.v1beta1.BigQueryDestination bigquery_destination = 3;</code>
     *
     * @return Whether the bigqueryDestination field is set.
     */
    @java.lang.Override
    public boolean hasBigqueryDestination() {
      return destinationCase_ == 3;
    }
    /**
     *
     *
     * <pre>
     * The BigQuery project or dataset location where the output is to be
     * written to. If project is provided, a new dataset is created with name
     * `prediction_&lt;model-display-name&gt;_&lt;job-create-time&gt;`
     * where &lt;model-display-name&gt; is made
     * BigQuery-dataset-name compatible (for example, most special characters
     * become underscores), and timestamp is in
     * YYYY_MM_DDThh_mm_ss_sssZ "based on ISO-8601" format. In the dataset
     * two tables will be created, `predictions`, and `errors`.
     * If the Model has both [instance][google.cloud.aiplatform.v1beta1.PredictSchemata.instance_schema_uri]
     * and [prediction][google.cloud.aiplatform.v1beta1.PredictSchemata.parameters_schema_uri] schemata
     * defined then the tables have columns as follows: The `predictions`
     * table contains instances for which the prediction succeeded, it
     * has columns as per a concatenation of the Model's instance and
     * prediction schemata. The `errors` table contains rows for which the
     * prediction has failed, it has instance columns, as per the
     * instance schema, followed by a single "errors" column, which as values
     * has [google.rpc.Status][google.rpc.Status]
     * represented as a STRUCT, and containing only `code` and `message`.
     * </pre>
     *
     * <code>.google.cloud.aiplatform.v1beta1.BigQueryDestination bigquery_destination = 3;</code>
     *
     * @return The bigqueryDestination.
     */
    @java.lang.Override
    public com.google.cloud.aiplatform.v1beta1.BigQueryDestination getBigqueryDestination() {
      if (destinationCase_ == 3) {
        return (com.google.cloud.aiplatform.v1beta1.BigQueryDestination) destination_;
      }
      return com.google.cloud.aiplatform.v1beta1.BigQueryDestination.getDefaultInstance();
    }
    /**
     *
     *
     * <pre>
     * The BigQuery project or dataset location where the output is to be
     * written to. If project is provided, a new dataset is created with name
     * `prediction_&lt;model-display-name&gt;_&lt;job-create-time&gt;`
     * where &lt;model-display-name&gt; is made
     * BigQuery-dataset-name compatible (for example, most special characters
     * become underscores), and timestamp is in
     * YYYY_MM_DDThh_mm_ss_sssZ "based on ISO-8601" format. In the dataset
     * two tables will be created, `predictions`, and `errors`.
     * If the Model has both [instance][google.cloud.aiplatform.v1beta1.PredictSchemata.instance_schema_uri]
     * and [prediction][google.cloud.aiplatform.v1beta1.PredictSchemata.parameters_schema_uri] schemata
     * defined then the tables have columns as follows: The `predictions`
     * table contains instances for which the prediction succeeded, it
     * has columns as per a concatenation of the Model's instance and
     * prediction schemata. The `errors` table contains rows for which the
     * prediction has failed, it has instance columns, as per the
     * instance schema, followed by a single "errors" column, which as values
     * has [google.rpc.Status][google.rpc.Status]
     * represented as a STRUCT, and containing only `code` and `message`.
     * </pre>
     *
     * <code>.google.cloud.aiplatform.v1beta1.BigQueryDestination bigquery_destination = 3;</code>
     */
    @java.lang.Override
    public com.google.cloud.aiplatform.v1beta1.BigQueryDestinationOrBuilder
        getBigqueryDestinationOrBuilder() {
      if (destinationCase_ == 3) {
        return (com.google.cloud.aiplatform.v1beta1.BigQueryDestination) destination_;
      }
      return com.google.cloud.aiplatform.v1beta1.BigQueryDestination.getDefaultInstance();
    }

    public static final int PREDICTIONS_FORMAT_FIELD_NUMBER = 1;
    private volatile java.lang.Object predictionsFormat_;
    /**
     *
     *
     * <pre>
     * Required. The format in which Vertex AI gives the predictions, must be one of the
     * [Model's][google.cloud.aiplatform.v1beta1.BatchPredictionJob.model]
     * [supported_output_storage_formats][google.cloud.aiplatform.v1beta1.Model.supported_output_storage_formats].
     * </pre>
     *
     * <code>string predictions_format = 1 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return The predictionsFormat.
     */
    @java.lang.Override
    public java.lang.String getPredictionsFormat() {
      java.lang.Object ref = predictionsFormat_;
      if (ref instanceof java.lang.String) {
        return (java.lang.String) ref;
      } else {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        predictionsFormat_ = s;
        return s;
      }
    }
    /**
     *
     *
     * <pre>
     * Required. The format in which Vertex AI gives the predictions, must be one of the
     * [Model's][google.cloud.aiplatform.v1beta1.BatchPredictionJob.model]
     * [supported_output_storage_formats][google.cloud.aiplatform.v1beta1.Model.supported_output_storage_formats].
     * </pre>
     *
     * <code>string predictions_format = 1 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return The bytes for predictionsFormat.
     */
    @java.lang.Override
    public com.google.protobuf.ByteString getPredictionsFormatBytes() {
      java.lang.Object ref = predictionsFormat_;
      if (ref instanceof java.lang.String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        predictionsFormat_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    private byte memoizedIsInitialized = -1;

    @java.lang.Override
    public final boolean isInitialized() {
      byte isInitialized = memoizedIsInitialized;
      if (isInitialized == 1) return true;
      if (isInitialized == 0) return false;

      memoizedIsInitialized = 1;
      return true;
    }

    @java.lang.Override
    public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
      if (!getPredictionsFormatBytes().isEmpty()) {
        com.google.protobuf.GeneratedMessageV3.writeString(output, 1, predictionsFormat_);
      }
      if (destinationCase_ == 2) {
        output.writeMessage(2, (com.google.cloud.aiplatform.v1beta1.GcsDestination) destination_);
      }
      if (destinationCase_ == 3) {
        output.writeMessage(
            3, (com.google.cloud.aiplatform.v1beta1.BigQueryDestination) destination_);
      }
      unknownFields.writeTo(output);
    }

    @java.lang.Override
    public int getSerializedSize() {
      int size = memoizedSize;
      if (size != -1) return size;

      size = 0;
      if (!getPredictionsFormatBytes().isEmpty()) {
        size += com.google.protobuf.GeneratedMessageV3.computeStringSize(1, predictionsFormat_);
      }
      if (destinationCase_ == 2) {
        size +=
            com.google.protobuf.CodedOutputStream.computeMessageSize(
                2, (com.google.cloud.aiplatform.v1beta1.GcsDestination) destination_);
      }
      if (destinationCase_ == 3) {
        size +=
            com.google.protobuf.CodedOutputStream.computeMessageSize(
                3, (com.google.cloud.aiplatform.v1beta1.BigQueryDestination) destination_);
      }
      size += unknownFields.getSerializedSize();
      memoizedSize = size;
      return size;
    }

    @java.lang.Override
    public boolean equals(final java.lang.Object obj) {
      if (obj == this) {
        return true;
      }
      if (!(obj instanceof com.google.cloud.aiplatform.v1beta1.BatchPredictionJob.OutputConfig)) {
        return super.equals(obj);
      }
      com.google.cloud.aiplatform.v1beta1.BatchPredictionJob.OutputConfig other =
          (com.google.cloud.aiplatform.v1beta1.BatchPredictionJob.OutputConfig) obj;

      if (!getPredictionsFormat().equals(other.getPredictionsFormat())) return false;
      if (!getDestinationCase().equals(other.getDestinationCase())) return false;
      switch (destinationCase_) {
        case 2:
          if (!getGcsDestination().equals(other.getGcsDestination())) return false;
          break;
        case 3:
          if (!getBigqueryDestination().equals(other.getBigqueryDestination())) return false;
          break;
        case 0:
        default:
      }
      if (!unknownFields.equals(other.unknownFields)) return false;
      return true;
    }

    @java.lang.Override
    public int hashCode() {
      if (memoizedHashCode != 0) {
        return memoizedHashCode;
      }
      int hash = 41;
      hash = (19 * hash) + getDescriptor().hashCode();
      hash = (37 * hash) + PREDICTIONS_FORMAT_FIELD_NUMBER;
      hash = (53 * hash) + getPredictionsFormat().hashCode();
      switch (destinationCase_) {
        case 2:
          hash = (37 * hash) + GCS_DESTINATION_FIELD_NUMBER;
          hash = (53 * hash) + getGcsDestination().hashCode();
          break;
        case 3:
          hash = (37 * hash) + BIGQUERY_DESTINATION_FIELD_NUMBER;
          hash = (53 * hash) + getBigqueryDestination().hashCode();
          break;
        case 0:
        default:
      }
      hash = (29 * hash) + unknownFields.hashCode();
      memoizedHashCode = hash;
      return hash;
    }

    public static com.google.cloud.aiplatform.v1beta1.BatchPredictionJob.OutputConfig parseFrom(
        java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.aiplatform.v1beta1.BatchPredictionJob.OutputConfig parseFrom(
        java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.aiplatform.v1beta1.BatchPredictionJob.OutputConfig parseFrom(
        com.google.protobuf.ByteString data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.aiplatform.v1beta1.BatchPredictionJob.OutputConfig parseFrom(
        com.google.protobuf.ByteString data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.aiplatform.v1beta1.BatchPredictionJob.OutputConfig parseFrom(
        byte[] data) throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.aiplatform.v1beta1.BatchPredictionJob.OutputConfig parseFrom(
        byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.aiplatform.v1beta1.BatchPredictionJob.OutputConfig parseFrom(
        java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.cloud.aiplatform.v1beta1.BatchPredictionJob.OutputConfig parseFrom(
        java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.cloud.aiplatform.v1beta1.BatchPredictionJob.OutputConfig
        parseDelimitedFrom(java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
    }

    public static com.google.cloud.aiplatform.v1beta1.BatchPredictionJob.OutputConfig
        parseDelimitedFrom(
            java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.cloud.aiplatform.v1beta1.BatchPredictionJob.OutputConfig parseFrom(
        com.google.protobuf.CodedInputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.cloud.aiplatform.v1beta1.BatchPredictionJob.OutputConfig parseFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    @java.lang.Override
    public Builder newBuilderForType() {
      return newBuilder();
    }

    public static Builder newBuilder() {
      return DEFAULT_INSTANCE.toBuilder();
    }

    public static Builder newBuilder(
        com.google.cloud.aiplatform.v1beta1.BatchPredictionJob.OutputConfig prototype) {
      return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }

    @java.lang.Override
    public Builder toBuilder() {
      return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
    }

    @java.lang.Override
    protected Builder newBuilderForType(
        com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      Builder builder = new Builder(parent);
      return builder;
    }
    /**
     *
     *
     * <pre>
     * Configures the output of [BatchPredictionJob][google.cloud.aiplatform.v1beta1.BatchPredictionJob].
     * See [Model.supported_output_storage_formats][google.cloud.aiplatform.v1beta1.Model.supported_output_storage_formats] for supported output
     * formats, and how predictions are expressed via any of them.
     * </pre>
     *
     * Protobuf type {@code google.cloud.aiplatform.v1beta1.BatchPredictionJob.OutputConfig}
     */
    public static final class Builder
        extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
        implements
        // @@protoc_insertion_point(builder_implements:google.cloud.aiplatform.v1beta1.BatchPredictionJob.OutputConfig)
        com.google.cloud.aiplatform.v1beta1.BatchPredictionJob.OutputConfigOrBuilder {
      public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
        return com.google.cloud.aiplatform.v1beta1.BatchPredictionJobProto
            .internal_static_google_cloud_aiplatform_v1beta1_BatchPredictionJob_OutputConfig_descriptor;
      }

      @java.lang.Override
      protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return com.google.cloud.aiplatform.v1beta1.BatchPredictionJobProto
            .internal_static_google_cloud_aiplatform_v1beta1_BatchPredictionJob_OutputConfig_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                com.google.cloud.aiplatform.v1beta1.BatchPredictionJob.OutputConfig.class,
                com.google.cloud.aiplatform.v1beta1.BatchPredictionJob.OutputConfig.Builder.class);
      }

      // Construct using
      // com.google.cloud.aiplatform.v1beta1.BatchPredictionJob.OutputConfig.newBuilder()
      private Builder() {
        maybeForceBuilderInitialization();
      }

      private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
        super(parent);
        maybeForceBuilderInitialization();
      }

      private void maybeForceBuilderInitialization() {
        if (com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders) {}
      }

      @java.lang.Override
      public Builder clear() {
        super.clear();
        predictionsFormat_ = "";

        destinationCase_ = 0;
        destination_ = null;
        return this;
      }

      @java.lang.Override
      public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
        return com.google.cloud.aiplatform.v1beta1.BatchPredictionJobProto
            .internal_static_google_cloud_aiplatform_v1beta1_BatchPredictionJob_OutputConfig_descriptor;
      }

      @java.lang.Override
      public com.google.cloud.aiplatform.v1beta1.BatchPredictionJob.OutputConfig
          getDefaultInstanceForType() {
        return com.google.cloud.aiplatform.v1beta1.BatchPredictionJob.OutputConfig
            .getDefaultInstance();
      }

      @java.lang.Override
      public com.google.cloud.aiplatform.v1beta1.BatchPredictionJob.OutputConfig build() {
        com.google.cloud.aiplatform.v1beta1.BatchPredictionJob.OutputConfig result = buildPartial();
        if (!result.isInitialized()) {
          throw newUninitializedMessageException(result);
        }
        return result;
      }

      @java.lang.Override
      public com.google.cloud.aiplatform.v1beta1.BatchPredictionJob.OutputConfig buildPartial() {
        com.google.cloud.aiplatform.v1beta1.BatchPredictionJob.OutputConfig result =
            new com.google.cloud.aiplatform.v1beta1.BatchPredictionJob.OutputConfig(this);
        if (destinationCase_ == 2) {
          if (gcsDestinationBuilder_ == null) {
            result.destination_ = destination_;
          } else {
            result.destination_ = gcsDestinationBuilder_.build();
          }
        }
        if (destinationCase_ == 3) {
          if (bigqueryDestinationBuilder_ == null) {
            result.destination_ = destination_;
          } else {
            result.destination_ = bigqueryDestinationBuilder_.build();
          }
        }
        result.predictionsFormat_ = predictionsFormat_;
        result.destinationCase_ = destinationCase_;
        onBuilt();
        return result;
      }

      @java.lang.Override
      public Builder clone() {
        return super.clone();
      }

      @java.lang.Override
      public Builder setField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.setField(field, value);
      }

      @java.lang.Override
      public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
        return super.clearField(field);
      }

      @java.lang.Override
      public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
        return super.clearOneof(oneof);
      }

      @java.lang.Override
      public Builder setRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          int index,
          java.lang.Object value) {
        return super.setRepeatedField(field, index, value);
      }

      @java.lang.Override
      public Builder addRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.addRepeatedField(field, value);
      }

      @java.lang.Override
      public Builder mergeFrom(com.google.protobuf.Message other) {
        if (other instanceof com.google.cloud.aiplatform.v1beta1.BatchPredictionJob.OutputConfig) {
          return mergeFrom(
              (com.google.cloud.aiplatform.v1beta1.BatchPredictionJob.OutputConfig) other);
        } else {
          super.mergeFrom(other);
          return this;
        }
      }

      public Builder mergeFrom(
          com.google.cloud.aiplatform.v1beta1.BatchPredictionJob.OutputConfig other) {
        if (other
            == com.google.cloud.aiplatform.v1beta1.BatchPredictionJob.OutputConfig
                .getDefaultInstance()) return this;
        if (!other.getPredictionsFormat().isEmpty()) {
          predictionsFormat_ = other.predictionsFormat_;
          onChanged();
        }
        switch (other.getDestinationCase()) {
          case GCS_DESTINATION:
            {
              mergeGcsDestination(other.getGcsDestination());
              break;
            }
          case BIGQUERY_DESTINATION:
            {
              mergeBigqueryDestination(other.getBigqueryDestination());
              break;
            }
          case DESTINATION_NOT_SET:
            {
              break;
            }
        }
        this.mergeUnknownFields(other.unknownFields);
        onChanged();
        return this;
      }

      @java.lang.Override
      public final boolean isInitialized() {
        return true;
      }

      @java.lang.Override
      public Builder mergeFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        com.google.cloud.aiplatform.v1beta1.BatchPredictionJob.OutputConfig parsedMessage = null;
        try {
          parsedMessage = PARSER.parsePartialFrom(input, extensionRegistry);
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          parsedMessage =
              (com.google.cloud.aiplatform.v1beta1.BatchPredictionJob.OutputConfig)
                  e.getUnfinishedMessage();
          throw e.unwrapIOException();
        } finally {
          if (parsedMessage != null) {
            mergeFrom(parsedMessage);
          }
        }
        return this;
      }

      private int destinationCase_ = 0;
      private java.lang.Object destination_;

      public DestinationCase getDestinationCase() {
        return DestinationCase.forNumber(destinationCase_);
      }

      public Builder clearDestination() {
        destinationCase_ = 0;
        destination_ = null;
        onChanged();
        return this;
      }

      private com.google.protobuf.SingleFieldBuilderV3<
              com.google.cloud.aiplatform.v1beta1.GcsDestination,
              com.google.cloud.aiplatform.v1beta1.GcsDestination.Builder,
              com.google.cloud.aiplatform.v1beta1.GcsDestinationOrBuilder>
          gcsDestinationBuilder_;
      /**
       *
       *
       * <pre>
       * The Cloud Storage location of the directory where the output is
       * to be written to. In the given directory a new directory is created.
       * Its name is `prediction-&lt;model-display-name&gt;-&lt;job-create-time&gt;`,
       * where timestamp is in YYYY-MM-DDThh:mm:ss.sssZ ISO-8601 format.
       * Inside of it files `predictions_0001.&lt;extension&gt;`,
       * `predictions_0002.&lt;extension&gt;`, ..., `predictions_N.&lt;extension&gt;`
       * are created where `&lt;extension&gt;` depends on chosen
       * [predictions_format][google.cloud.aiplatform.v1beta1.BatchPredictionJob.OutputConfig.predictions_format], and N may equal 0001 and depends on the total
       * number of successfully predicted instances.
       * If the Model has both [instance][google.cloud.aiplatform.v1beta1.PredictSchemata.instance_schema_uri]
       * and [prediction][google.cloud.aiplatform.v1beta1.PredictSchemata.parameters_schema_uri] schemata
       * defined then each such file contains predictions as per the
       * [predictions_format][google.cloud.aiplatform.v1beta1.BatchPredictionJob.OutputConfig.predictions_format].
       * If prediction for any instance failed (partially or completely), then
       * an additional `errors_0001.&lt;extension&gt;`, `errors_0002.&lt;extension&gt;`,...,
       * `errors_N.&lt;extension&gt;` files are created (N depends on total number
       * of failed predictions). These files contain the failed instances,
       * as per their schema, followed by an additional `error` field which as
       * value has [google.rpc.Status][google.rpc.Status]
       * containing only `code` and `message` fields.
       * </pre>
       *
       * <code>.google.cloud.aiplatform.v1beta1.GcsDestination gcs_destination = 2;</code>
       *
       * @return Whether the gcsDestination field is set.
       */
      @java.lang.Override
      public boolean hasGcsDestination() {
        return destinationCase_ == 2;
      }
      /**
       *
       *
       * <pre>
       * The Cloud Storage location of the directory where the output is
       * to be written to. In the given directory a new directory is created.
       * Its name is `prediction-&lt;model-display-name&gt;-&lt;job-create-time&gt;`,
       * where timestamp is in YYYY-MM-DDThh:mm:ss.sssZ ISO-8601 format.
       * Inside of it files `predictions_0001.&lt;extension&gt;`,
       * `predictions_0002.&lt;extension&gt;`, ..., `predictions_N.&lt;extension&gt;`
       * are created where `&lt;extension&gt;` depends on chosen
       * [predictions_format][google.cloud.aiplatform.v1beta1.BatchPredictionJob.OutputConfig.predictions_format], and N may equal 0001 and depends on the total
       * number of successfully predicted instances.
       * If the Model has both [instance][google.cloud.aiplatform.v1beta1.PredictSchemata.instance_schema_uri]
       * and [prediction][google.cloud.aiplatform.v1beta1.PredictSchemata.parameters_schema_uri] schemata
       * defined then each such file contains predictions as per the
       * [predictions_format][google.cloud.aiplatform.v1beta1.BatchPredictionJob.OutputConfig.predictions_format].
       * If prediction for any instance failed (partially or completely), then
       * an additional `errors_0001.&lt;extension&gt;`, `errors_0002.&lt;extension&gt;`,...,
       * `errors_N.&lt;extension&gt;` files are created (N depends on total number
       * of failed predictions). These files contain the failed instances,
       * as per their schema, followed by an additional `error` field which as
       * value has [google.rpc.Status][google.rpc.Status]
       * containing only `code` and `message` fields.
       * </pre>
       *
       * <code>.google.cloud.aiplatform.v1beta1.GcsDestination gcs_destination = 2;</code>
       *
       * @return The gcsDestination.
       */
      @java.lang.Override
      public com.google.cloud.aiplatform.v1beta1.GcsDestination getGcsDestination() {
        if (gcsDestinationBuilder_ == null) {
          if (destinationCase_ == 2) {
            return (com.google.cloud.aiplatform.v1beta1.GcsDestination) destination_;
          }
          return com.google.cloud.aiplatform.v1beta1.GcsDestination.getDefaultInstance();
        } else {
          if (destinationCase_ == 2) {
            return gcsDestinationBuilder_.getMessage();
          }
          return com.google.cloud.aiplatform.v1beta1.GcsDestination.getDefaultInstance();
        }
      }
      /**
       *
       *
       * <pre>
       * The Cloud Storage location of the directory where the output is
       * to be written to. In the given directory a new directory is created.
       * Its name is `prediction-&lt;model-display-name&gt;-&lt;job-create-time&gt;`,
       * where timestamp is in YYYY-MM-DDThh:mm:ss.sssZ ISO-8601 format.
       * Inside of it files `predictions_0001.&lt;extension&gt;`,
       * `predictions_0002.&lt;extension&gt;`, ..., `predictions_N.&lt;extension&gt;`
       * are created where `&lt;extension&gt;` depends on chosen
       * [predictions_format][google.cloud.aiplatform.v1beta1.BatchPredictionJob.OutputConfig.predictions_format], and N may equal 0001 and depends on the total
       * number of successfully predicted instances.
       * If the Model has both [instance][google.cloud.aiplatform.v1beta1.PredictSchemata.instance_schema_uri]
       * and [prediction][google.cloud.aiplatform.v1beta1.PredictSchemata.parameters_schema_uri] schemata
       * defined then each such file contains predictions as per the
       * [predictions_format][google.cloud.aiplatform.v1beta1.BatchPredictionJob.OutputConfig.predictions_format].
       * If prediction for any instance failed (partially or completely), then
       * an additional `errors_0001.&lt;extension&gt;`, `errors_0002.&lt;extension&gt;`,...,
       * `errors_N.&lt;extension&gt;` files are created (N depends on total number
       * of failed predictions). These files contain the failed instances,
       * as per their schema, followed by an additional `error` field which as
       * value has [google.rpc.Status][google.rpc.Status]
       * containing only `code` and `message` fields.
       * </pre>
       *
       * <code>.google.cloud.aiplatform.v1beta1.GcsDestination gcs_destination = 2;</code>
       */
      public Builder setGcsDestination(com.google.cloud.aiplatform.v1beta1.GcsDestination value) {
        if (gcsDestinationBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          destination_ = value;
          onChanged();
        } else {
          gcsDestinationBuilder_.setMessage(value);
        }
        destinationCase_ = 2;
        return this;
      }
      /**
       *
       *
       * <pre>
       * The Cloud Storage location of the directory where the output is
       * to be written to. In the given directory a new directory is created.
       * Its name is `prediction-&lt;model-display-name&gt;-&lt;job-create-time&gt;`,
       * where timestamp is in YYYY-MM-DDThh:mm:ss.sssZ ISO-8601 format.
       * Inside of it files `predictions_0001.&lt;extension&gt;`,
       * `predictions_0002.&lt;extension&gt;`, ..., `predictions_N.&lt;extension&gt;`
       * are created where `&lt;extension&gt;` depends on chosen
       * [predictions_format][google.cloud.aiplatform.v1beta1.BatchPredictionJob.OutputConfig.predictions_format], and N may equal 0001 and depends on the total
       * number of successfully predicted instances.
       * If the Model has both [instance][google.cloud.aiplatform.v1beta1.PredictSchemata.instance_schema_uri]
       * and [prediction][google.cloud.aiplatform.v1beta1.PredictSchemata.parameters_schema_uri] schemata
       * defined then each such file contains predictions as per the
       * [predictions_format][google.cloud.aiplatform.v1beta1.BatchPredictionJob.OutputConfig.predictions_format].
       * If prediction for any instance failed (partially or completely), then
       * an additional `errors_0001.&lt;extension&gt;`, `errors_0002.&lt;extension&gt;`,...,
       * `errors_N.&lt;extension&gt;` files are created (N depends on total number
       * of failed predictions). These files contain the failed instances,
       * as per their schema, followed by an additional `error` field which as
       * value has [google.rpc.Status][google.rpc.Status]
       * containing only `code` and `message` fields.
       * </pre>
       *
       * <code>.google.cloud.aiplatform.v1beta1.GcsDestination gcs_destination = 2;</code>
       */
      public Builder setGcsDestination(
          com.google.cloud.aiplatform.v1beta1.GcsDestination.Builder builderForValue) {
        if (gcsDestinationBuilder_ == null) {
          destination_ = builderForValue.build();
          onChanged();
        } else {
          gcsDestinationBuilder_.setMessage(builderForValue.build());
        }
        destinationCase_ = 2;
        return this;
      }
      /**
       *
       *
       * <pre>
       * The Cloud Storage location of the directory where the output is
       * to be written to. In the given directory a new directory is created.
       * Its name is `prediction-&lt;model-display-name&gt;-&lt;job-create-time&gt;`,
       * where timestamp is in YYYY-MM-DDThh:mm:ss.sssZ ISO-8601 format.
       * Inside of it files `predictions_0001.&lt;extension&gt;`,
       * `predictions_0002.&lt;extension&gt;`, ..., `predictions_N.&lt;extension&gt;`
       * are created where `&lt;extension&gt;` depends on chosen
       * [predictions_format][google.cloud.aiplatform.v1beta1.BatchPredictionJob.OutputConfig.predictions_format], and N may equal 0001 and depends on the total
       * number of successfully predicted instances.
       * If the Model has both [instance][google.cloud.aiplatform.v1beta1.PredictSchemata.instance_schema_uri]
       * and [prediction][google.cloud.aiplatform.v1beta1.PredictSchemata.parameters_schema_uri] schemata
       * defined then each such file contains predictions as per the
       * [predictions_format][google.cloud.aiplatform.v1beta1.BatchPredictionJob.OutputConfig.predictions_format].
       * If prediction for any instance failed (partially or completely), then
       * an additional `errors_0001.&lt;extension&gt;`, `errors_0002.&lt;extension&gt;`,...,
       * `errors_N.&lt;extension&gt;` files are created (N depends on total number
       * of failed predictions). These files contain the failed instances,
       * as per their schema, followed by an additional `error` field which as
       * value has [google.rpc.Status][google.rpc.Status]
       * containing only `code` and `message` fields.
       * </pre>
       *
       * <code>.google.cloud.aiplatform.v1beta1.GcsDestination gcs_destination = 2;</code>
       */
      public Builder mergeGcsDestination(com.google.cloud.aiplatform.v1beta1.GcsDestination value) {
        if (gcsDestinationBuilder_ == null) {
          if (destinationCase_ == 2
              && destination_
                  != com.google.cloud.aiplatform.v1beta1.GcsDestination.getDefaultInstance()) {
            destination_ =
                com.google.cloud.aiplatform.v1beta1.GcsDestination.newBuilder(
                        (com.google.cloud.aiplatform.v1beta1.GcsDestination) destination_)
                    .mergeFrom(value)
                    .buildPartial();
          } else {
            destination_ = value;
          }
          onChanged();
        } else {
          if (destinationCase_ == 2) {
            gcsDestinationBuilder_.mergeFrom(value);
          }
          gcsDestinationBuilder_.setMessage(value);
        }
        destinationCase_ = 2;
        return this;
      }
      /**
       *
       *
       * <pre>
       * The Cloud Storage location of the directory where the output is
       * to be written to. In the given directory a new directory is created.
       * Its name is `prediction-&lt;model-display-name&gt;-&lt;job-create-time&gt;`,
       * where timestamp is in YYYY-MM-DDThh:mm:ss.sssZ ISO-8601 format.
       * Inside of it files `predictions_0001.&lt;extension&gt;`,
       * `predictions_0002.&lt;extension&gt;`, ..., `predictions_N.&lt;extension&gt;`
       * are created where `&lt;extension&gt;` depends on chosen
       * [predictions_format][google.cloud.aiplatform.v1beta1.BatchPredictionJob.OutputConfig.predictions_format], and N may equal 0001 and depends on the total
       * number of successfully predicted instances.
       * If the Model has both [instance][google.cloud.aiplatform.v1beta1.PredictSchemata.instance_schema_uri]
       * and [prediction][google.cloud.aiplatform.v1beta1.PredictSchemata.parameters_schema_uri] schemata
       * defined then each such file contains predictions as per the
       * [predictions_format][google.cloud.aiplatform.v1beta1.BatchPredictionJob.OutputConfig.predictions_format].
       * If prediction for any instance failed (partially or completely), then
       * an additional `errors_0001.&lt;extension&gt;`, `errors_0002.&lt;extension&gt;`,...,
       * `errors_N.&lt;extension&gt;` files are created (N depends on total number
       * of failed predictions). These files contain the failed instances,
       * as per their schema, followed by an additional `error` field which as
       * value has [google.rpc.Status][google.rpc.Status]
       * containing only `code` and `message` fields.
       * </pre>
       *
       * <code>.google.cloud.aiplatform.v1beta1.GcsDestination gcs_destination = 2;</code>
       */
      public Builder clearGcsDestination() {
        if (gcsDestinationBuilder_ == null) {
          if (destinationCase_ == 2) {
            destinationCase_ = 0;
            destination_ = null;
            onChanged();
          }
        } else {
          if (destinationCase_ == 2) {
            destinationCase_ = 0;
            destination_ = null;
          }
          gcsDestinationBuilder_.clear();
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * The Cloud Storage location of the directory where the output is
       * to be written to. In the given directory a new directory is created.
       * Its name is `prediction-&lt;model-display-name&gt;-&lt;job-create-time&gt;`,
       * where timestamp is in YYYY-MM-DDThh:mm:ss.sssZ ISO-8601 format.
       * Inside of it files `predictions_0001.&lt;extension&gt;`,
       * `predictions_0002.&lt;extension&gt;`, ..., `predictions_N.&lt;extension&gt;`
       * are created where `&lt;extension&gt;` depends on chosen
       * [predictions_format][google.cloud.aiplatform.v1beta1.BatchPredictionJob.OutputConfig.predictions_format], and N may equal 0001 and depends on the total
       * number of successfully predicted instances.
       * If the Model has both [instance][google.cloud.aiplatform.v1beta1.PredictSchemata.instance_schema_uri]
       * and [prediction][google.cloud.aiplatform.v1beta1.PredictSchemata.parameters_schema_uri] schemata
       * defined then each such file contains predictions as per the
       * [predictions_format][google.cloud.aiplatform.v1beta1.BatchPredictionJob.OutputConfig.predictions_format].
       * If prediction for any instance failed (partially or completely), then
       * an additional `errors_0001.&lt;extension&gt;`, `errors_0002.&lt;extension&gt;`,...,
       * `errors_N.&lt;extension&gt;` files are created (N depends on total number
       * of failed predictions). These files contain the failed instances,
       * as per their schema, followed by an additional `error` field which as
       * value has [google.rpc.Status][google.rpc.Status]
       * containing only `code` and `message` fields.
       * </pre>
       *
       * <code>.google.cloud.aiplatform.v1beta1.GcsDestination gcs_destination = 2;</code>
       */
      public com.google.cloud.aiplatform.v1beta1.GcsDestination.Builder getGcsDestinationBuilder() {
        return getGcsDestinationFieldBuilder().getBuilder();
      }
      /**
       *
       *
       * <pre>
       * The Cloud Storage location of the directory where the output is
       * to be written to. In the given directory a new directory is created.
       * Its name is `prediction-&lt;model-display-name&gt;-&lt;job-create-time&gt;`,
       * where timestamp is in YYYY-MM-DDThh:mm:ss.sssZ ISO-8601 format.
       * Inside of it files `predictions_0001.&lt;extension&gt;`,
       * `predictions_0002.&lt;extension&gt;`, ..., `predictions_N.&lt;extension&gt;`
       * are created where `&lt;extension&gt;` depends on chosen
       * [predictions_format][google.cloud.aiplatform.v1beta1.BatchPredictionJob.OutputConfig.predictions_format], and N may equal 0001 and depends on the total
       * number of successfully predicted instances.
       * If the Model has both [instance][google.cloud.aiplatform.v1beta1.PredictSchemata.instance_schema_uri]
       * and [prediction][google.cloud.aiplatform.v1beta1.PredictSchemata.parameters_schema_uri] schemata
       * defined then each such file contains predictions as per the
       * [predictions_format][google.cloud.aiplatform.v1beta1.BatchPredictionJob.OutputConfig.predictions_format].
       * If prediction for any instance failed (partially or completely), then
       * an additional `errors_0001.&lt;extension&gt;`, `errors_0002.&lt;extension&gt;`,...,
       * `errors_N.&lt;extension&gt;` files are created (N depends on total number
       * of failed predictions). These files contain the failed instances,
       * as per their schema, followed by an additional `error` field which as
       * value has [google.rpc.Status][google.rpc.Status]
       * containing only `code` and `message` fields.
       * </pre>
       *
       * <code>.google.cloud.aiplatform.v1beta1.GcsDestination gcs_destination = 2;</code>
       */
      @java.lang.Override
      public com.google.cloud.aiplatform.v1beta1.GcsDestinationOrBuilder
          getGcsDestinationOrBuilder() {
        if ((destinationCase_ == 2) && (gcsDestinationBuilder_ != null)) {
          return gcsDestinationBuilder_.getMessageOrBuilder();
        } else {
          if (destinationCase_ == 2) {
            return (com.google.cloud.aiplatform.v1beta1.GcsDestination) destination_;
          }
          return com.google.cloud.aiplatform.v1beta1.GcsDestination.getDefaultInstance();
        }
      }
      /**
       *
       *
       * <pre>
       * The Cloud Storage location of the directory where the output is
       * to be written to. In the given directory a new directory is created.
       * Its name is `prediction-&lt;model-display-name&gt;-&lt;job-create-time&gt;`,
       * where timestamp is in YYYY-MM-DDThh:mm:ss.sssZ ISO-8601 format.
       * Inside of it files `predictions_0001.&lt;extension&gt;`,
       * `predictions_0002.&lt;extension&gt;`, ..., `predictions_N.&lt;extension&gt;`
       * are created where `&lt;extension&gt;` depends on chosen
       * [predictions_format][google.cloud.aiplatform.v1beta1.BatchPredictionJob.OutputConfig.predictions_format], and N may equal 0001 and depends on the total
       * number of successfully predicted instances.
       * If the Model has both [instance][google.cloud.aiplatform.v1beta1.PredictSchemata.instance_schema_uri]
       * and [prediction][google.cloud.aiplatform.v1beta1.PredictSchemata.parameters_schema_uri] schemata
       * defined then each such file contains predictions as per the
       * [predictions_format][google.cloud.aiplatform.v1beta1.BatchPredictionJob.OutputConfig.predictions_format].
       * If prediction for any instance failed (partially or completely), then
       * an additional `errors_0001.&lt;extension&gt;`, `errors_0002.&lt;extension&gt;`,...,
       * `errors_N.&lt;extension&gt;` files are created (N depends on total number
       * of failed predictions). These files contain the failed instances,
       * as per their schema, followed by an additional `error` field which as
       * value has [google.rpc.Status][google.rpc.Status]
       * containing only `code` and `message` fields.
       * </pre>
       *
       * <code>.google.cloud.aiplatform.v1beta1.GcsDestination gcs_destination = 2;</code>
       */
      private com.google.protobuf.SingleFieldBuilderV3<
              com.google.cloud.aiplatform.v1beta1.GcsDestination,
              com.google.cloud.aiplatform.v1beta1.GcsDestination.Builder,
              com.google.cloud.aiplatform.v1beta1.GcsDestinationOrBuilder>
          getGcsDestinationFieldBuilder() {
        if (gcsDestinationBuilder_ == null) {
          if (!(destinationCase_ == 2)) {
            destination_ = com.google.cloud.aiplatform.v1beta1.GcsDestination.getDefaultInstance();
          }
          gcsDestinationBuilder_ =
              new com.google.protobuf.SingleFieldBuilderV3<
                  com.google.cloud.aiplatform.v1beta1.GcsDestination,
                  com.google.cloud.aiplatform.v1beta1.GcsDestination.Builder,
                  com.google.cloud.aiplatform.v1beta1.GcsDestinationOrBuilder>(
                  (com.google.cloud.aiplatform.v1beta1.GcsDestination) destination_,
                  getParentForChildren(),
                  isClean());
          destination_ = null;
        }
        destinationCase_ = 2;
        onChanged();
        ;
        return gcsDestinationBuilder_;
      }

      private com.google.protobuf.SingleFieldBuilderV3<
              com.google.cloud.aiplatform.v1beta1.BigQueryDestination,
              com.google.cloud.aiplatform.v1beta1.BigQueryDestination.Builder,
              com.google.cloud.aiplatform.v1beta1.BigQueryDestinationOrBuilder>
          bigqueryDestinationBuilder_;
      /**
       *
       *
       * <pre>
       * The BigQuery project or dataset location where the output is to be
       * written to. If project is provided, a new dataset is created with name
       * `prediction_&lt;model-display-name&gt;_&lt;job-create-time&gt;`
       * where &lt;model-display-name&gt; is made
       * BigQuery-dataset-name compatible (for example, most special characters
       * become underscores), and timestamp is in
       * YYYY_MM_DDThh_mm_ss_sssZ "based on ISO-8601" format. In the dataset
       * two tables will be created, `predictions`, and `errors`.
       * If the Model has both [instance][google.cloud.aiplatform.v1beta1.PredictSchemata.instance_schema_uri]
       * and [prediction][google.cloud.aiplatform.v1beta1.PredictSchemata.parameters_schema_uri] schemata
       * defined then the tables have columns as follows: The `predictions`
       * table contains instances for which the prediction succeeded, it
       * has columns as per a concatenation of the Model's instance and
       * prediction schemata. The `errors` table contains rows for which the
       * prediction has failed, it has instance columns, as per the
       * instance schema, followed by a single "errors" column, which as values
       * has [google.rpc.Status][google.rpc.Status]
       * represented as a STRUCT, and containing only `code` and `message`.
       * </pre>
       *
       * <code>.google.cloud.aiplatform.v1beta1.BigQueryDestination bigquery_destination = 3;</code>
       *
       * @return Whether the bigqueryDestination field is set.
       */
      @java.lang.Override
      public boolean hasBigqueryDestination() {
        return destinationCase_ == 3;
      }
      /**
       *
       *
       * <pre>
       * The BigQuery project or dataset location where the output is to be
       * written to. If project is provided, a new dataset is created with name
       * `prediction_&lt;model-display-name&gt;_&lt;job-create-time&gt;`
       * where &lt;model-display-name&gt; is made
       * BigQuery-dataset-name compatible (for example, most special characters
       * become underscores), and timestamp is in
       * YYYY_MM_DDThh_mm_ss_sssZ "based on ISO-8601" format. In the dataset
       * two tables will be created, `predictions`, and `errors`.
       * If the Model has both [instance][google.cloud.aiplatform.v1beta1.PredictSchemata.instance_schema_uri]
       * and [prediction][google.cloud.aiplatform.v1beta1.PredictSchemata.parameters_schema_uri] schemata
       * defined then the tables have columns as follows: The `predictions`
       * table contains instances for which the prediction succeeded, it
       * has columns as per a concatenation of the Model's instance and
       * prediction schemata. The `errors` table contains rows for which the
       * prediction has failed, it has instance columns, as per the
       * instance schema, followed by a single "errors" column, which as values
       * has [google.rpc.Status][google.rpc.Status]
       * represented as a STRUCT, and containing only `code` and `message`.
       * </pre>
       *
       * <code>.google.cloud.aiplatform.v1beta1.BigQueryDestination bigquery_destination = 3;</code>
       *
       * @return The bigqueryDestination.
       */
      @java.lang.Override
      public com.google.cloud.aiplatform.v1beta1.BigQueryDestination getBigqueryDestination() {
        if (bigqueryDestinationBuilder_ == null) {
          if (destinationCase_ == 3) {
            return (com.google.cloud.aiplatform.v1beta1.BigQueryDestination) destination_;
          }
          return com.google.cloud.aiplatform.v1beta1.BigQueryDestination.getDefaultInstance();
        } else {
          if (destinationCase_ == 3) {
            return bigqueryDestinationBuilder_.getMessage();
          }
          return com.google.cloud.aiplatform.v1beta1.BigQueryDestination.getDefaultInstance();
        }
      }
      /**
       *
       *
       * <pre>
       * The BigQuery project or dataset location where the output is to be
       * written to. If project is provided, a new dataset is created with name
       * `prediction_&lt;model-display-name&gt;_&lt;job-create-time&gt;`
       * where &lt;model-display-name&gt; is made
       * BigQuery-dataset-name compatible (for example, most special characters
       * become underscores), and timestamp is in
       * YYYY_MM_DDThh_mm_ss_sssZ "based on ISO-8601" format. In the dataset
       * two tables will be created, `predictions`, and `errors`.
       * If the Model has both [instance][google.cloud.aiplatform.v1beta1.PredictSchemata.instance_schema_uri]
       * and [prediction][google.cloud.aiplatform.v1beta1.PredictSchemata.parameters_schema_uri] schemata
       * defined then the tables have columns as follows: The `predictions`
       * table contains instances for which the prediction succeeded, it
       * has columns as per a concatenation of the Model's instance and
       * prediction schemata. The `errors` table contains rows for which the
       * prediction has failed, it has instance columns, as per the
       * instance schema, followed by a single "errors" column, which as values
       * has [google.rpc.Status][google.rpc.Status]
       * represented as a STRUCT, and containing only `code` and `message`.
       * </pre>
       *
       * <code>.google.cloud.aiplatform.v1beta1.BigQueryDestination bigquery_destination = 3;</code>
       */
      public Builder setBigqueryDestination(
          com.google.cloud.aiplatform.v1beta1.BigQueryDestination value) {
        if (bigqueryDestinationBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          destination_ = value;
          onChanged();
        } else {
          bigqueryDestinationBuilder_.setMessage(value);
        }
        destinationCase_ = 3;
        return this;
      }
      /**
       *
       *
       * <pre>
       * The BigQuery project or dataset location where the output is to be
       * written to. If project is provided, a new dataset is created with name
       * `prediction_&lt;model-display-name&gt;_&lt;job-create-time&gt;`
       * where &lt;model-display-name&gt; is made
       * BigQuery-dataset-name compatible (for example, most special characters
       * become underscores), and timestamp is in
       * YYYY_MM_DDThh_mm_ss_sssZ "based on ISO-8601" format. In the dataset
       * two tables will be created, `predictions`, and `errors`.
       * If the Model has both [instance][google.cloud.aiplatform.v1beta1.PredictSchemata.instance_schema_uri]
       * and [prediction][google.cloud.aiplatform.v1beta1.PredictSchemata.parameters_schema_uri] schemata
       * defined then the tables have columns as follows: The `predictions`
       * table contains instances for which the prediction succeeded, it
       * has columns as per a concatenation of the Model's instance and
       * prediction schemata. The `errors` table contains rows for which the
       * prediction has failed, it has instance columns, as per the
       * instance schema, followed by a single "errors" column, which as values
       * has [google.rpc.Status][google.rpc.Status]
       * represented as a STRUCT, and containing only `code` and `message`.
       * </pre>
       *
       * <code>.google.cloud.aiplatform.v1beta1.BigQueryDestination bigquery_destination = 3;</code>
       */
      public Builder setBigqueryDestination(
          com.google.cloud.aiplatform.v1beta1.BigQueryDestination.Builder builderForValue) {
        if (bigqueryDestinationBuilder_ == null) {
          destination_ = builderForValue.build();
          onChanged();
        } else {
          bigqueryDestinationBuilder_.setMessage(builderForValue.build());
        }
        destinationCase_ = 3;
        return this;
      }
      /**
       *
       *
       * <pre>
       * The BigQuery project or dataset location where the output is to be
       * written to. If project is provided, a new dataset is created with name
       * `prediction_&lt;model-display-name&gt;_&lt;job-create-time&gt;`
       * where &lt;model-display-name&gt; is made
       * BigQuery-dataset-name compatible (for example, most special characters
       * become underscores), and timestamp is in
       * YYYY_MM_DDThh_mm_ss_sssZ "based on ISO-8601" format. In the dataset
       * two tables will be created, `predictions`, and `errors`.
       * If the Model has both [instance][google.cloud.aiplatform.v1beta1.PredictSchemata.instance_schema_uri]
       * and [prediction][google.cloud.aiplatform.v1beta1.PredictSchemata.parameters_schema_uri] schemata
       * defined then the tables have columns as follows: The `predictions`
       * table contains instances for which the prediction succeeded, it
       * has columns as per a concatenation of the Model's instance and
       * prediction schemata. The `errors` table contains rows for which the
       * prediction has failed, it has instance columns, as per the
       * instance schema, followed by a single "errors" column, which as values
       * has [google.rpc.Status][google.rpc.Status]
       * represented as a STRUCT, and containing only `code` and `message`.
       * </pre>
       *
       * <code>.google.cloud.aiplatform.v1beta1.BigQueryDestination bigquery_destination = 3;</code>
       */
      public Builder mergeBigqueryDestination(
          com.google.cloud.aiplatform.v1beta1.BigQueryDestination value) {
        if (bigqueryDestinationBuilder_ == null) {
          if (destinationCase_ == 3
              && destination_
                  != com.google.cloud.aiplatform.v1beta1.BigQueryDestination.getDefaultInstance()) {
            destination_ =
                com.google.cloud.aiplatform.v1beta1.BigQueryDestination.newBuilder(
                        (com.google.cloud.aiplatform.v1beta1.BigQueryDestination) destination_)
                    .mergeFrom(value)
                    .buildPartial();
          } else {
            destination_ = value;
          }
          onChanged();
        } else {
          if (destinationCase_ == 3) {
            bigqueryDestinationBuilder_.mergeFrom(value);
          }
          bigqueryDestinationBuilder_.setMessage(value);
        }
        destinationCase_ = 3;
        return this;
      }
      /**
       *
       *
       * <pre>
       * The BigQuery project or dataset location where the output is to be
       * written to. If project is provided, a new dataset is created with name
       * `prediction_&lt;model-display-name&gt;_&lt;job-create-time&gt;`
       * where &lt;model-display-name&gt; is made
       * BigQuery-dataset-name compatible (for example, most special characters
       * become underscores), and timestamp is in
       * YYYY_MM_DDThh_mm_ss_sssZ "based on ISO-8601" format. In the dataset
       * two tables will be created, `predictions`, and `errors`.
       * If the Model has both [instance][google.cloud.aiplatform.v1beta1.PredictSchemata.instance_schema_uri]
       * and [prediction][google.cloud.aiplatform.v1beta1.PredictSchemata.parameters_schema_uri] schemata
       * defined then the tables have columns as follows: The `predictions`
       * table contains instances for which the prediction succeeded, it
       * has columns as per a concatenation of the Model's instance and
       * prediction schemata. The `errors` table contains rows for which the
       * prediction has failed, it has instance columns, as per the
       * instance schema, followed by a single "errors" column, which as values
       * has [google.rpc.Status][google.rpc.Status]
       * represented as a STRUCT, and containing only `code` and `message`.
       * </pre>
       *
       * <code>.google.cloud.aiplatform.v1beta1.BigQueryDestination bigquery_destination = 3;</code>
       */
      public Builder clearBigqueryDestination() {
        if (bigqueryDestinationBuilder_ == null) {
          if (destinationCase_ == 3) {
            destinationCase_ = 0;
            destination_ = null;
            onChanged();
          }
        } else {
          if (destinationCase_ == 3) {
            destinationCase_ = 0;
            destination_ = null;
          }
          bigqueryDestinationBuilder_.clear();
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * The BigQuery project or dataset location where the output is to be
       * written to. If project is provided, a new dataset is created with name
       * `prediction_&lt;model-display-name&gt;_&lt;job-create-time&gt;`
       * where &lt;model-display-name&gt; is made
       * BigQuery-dataset-name compatible (for example, most special characters
       * become underscores), and timestamp is in
       * YYYY_MM_DDThh_mm_ss_sssZ "based on ISO-8601" format. In the dataset
       * two tables will be created, `predictions`, and `errors`.
       * If the Model has both [instance][google.cloud.aiplatform.v1beta1.PredictSchemata.instance_schema_uri]
       * and [prediction][google.cloud.aiplatform.v1beta1.PredictSchemata.parameters_schema_uri] schemata
       * defined then the tables have columns as follows: The `predictions`
       * table contains instances for which the prediction succeeded, it
       * has columns as per a concatenation of the Model's instance and
       * prediction schemata. The `errors` table contains rows for which the
       * prediction has failed, it has instance columns, as per the
       * instance schema, followed by a single "errors" column, which as values
       * has [google.rpc.Status][google.rpc.Status]
       * represented as a STRUCT, and containing only `code` and `message`.
       * </pre>
       *
       * <code>.google.cloud.aiplatform.v1beta1.BigQueryDestination bigquery_destination = 3;</code>
       */
      public com.google.cloud.aiplatform.v1beta1.BigQueryDestination.Builder
          getBigqueryDestinationBuilder() {
        return getBigqueryDestinationFieldBuilder().getBuilder();
      }
      /**
       *
       *
       * <pre>
       * The BigQuery project or dataset location where the output is to be
       * written to. If project is provided, a new dataset is created with name
       * `prediction_&lt;model-display-name&gt;_&lt;job-create-time&gt;`
       * where &lt;model-display-name&gt; is made
       * BigQuery-dataset-name compatible (for example, most special characters
       * become underscores), and timestamp is in
       * YYYY_MM_DDThh_mm_ss_sssZ "based on ISO-8601" format. In the dataset
       * two tables will be created, `predictions`, and `errors`.
       * If the Model has both [instance][google.cloud.aiplatform.v1beta1.PredictSchemata.instance_schema_uri]
       * and [prediction][google.cloud.aiplatform.v1beta1.PredictSchemata.parameters_schema_uri] schemata
       * defined then the tables have columns as follows: The `predictions`
       * table contains instances for which the prediction succeeded, it
       * has columns as per a concatenation of the Model's instance and
       * prediction schemata. The `errors` table contains rows for which the
       * prediction has failed, it has instance columns, as per the
       * instance schema, followed by a single "errors" column, which as values
       * has [google.rpc.Status][google.rpc.Status]
       * represented as a STRUCT, and containing only `code` and `message`.
       * </pre>
       *
       * <code>.google.cloud.aiplatform.v1beta1.BigQueryDestination bigquery_destination = 3;</code>
       */
      @java.lang.Override
      public com.google.cloud.aiplatform.v1beta1.BigQueryDestinationOrBuilder
          getBigqueryDestinationOrBuilder() {
        if ((destinationCase_ == 3) && (bigqueryDestinationBuilder_ != null)) {
          return bigqueryDestinationBuilder_.getMessageOrBuilder();
        } else {
          if (destinationCase_ == 3) {
            return (com.google.cloud.aiplatform.v1beta1.BigQueryDestination) destination_;
          }
          return com.google.cloud.aiplatform.v1beta1.BigQueryDestination.getDefaultInstance();
        }
      }
      /**
       *
       *
       * <pre>
       * The BigQuery project or dataset location where the output is to be
       * written to. If project is provided, a new dataset is created with name
       * `prediction_&lt;model-display-name&gt;_&lt;job-create-time&gt;`
       * where &lt;model-display-name&gt; is made
       * BigQuery-dataset-name compatible (for example, most special characters
       * become underscores), and timestamp is in
       * YYYY_MM_DDThh_mm_ss_sssZ "based on ISO-8601" format. In the dataset
       * two tables will be created, `predictions`, and `errors`.
       * If the Model has both [instance][google.cloud.aiplatform.v1beta1.PredictSchemata.instance_schema_uri]
       * and [prediction][google.cloud.aiplatform.v1beta1.PredictSchemata.parameters_schema_uri] schemata
       * defined then the tables have columns as follows: The `predictions`
       * table contains instances for which the prediction succeeded, it
       * has columns as per a concatenation of the Model's instance and
       * prediction schemata. The `errors` table contains rows for which the
       * prediction has failed, it has instance columns, as per the
       * instance schema, followed by a single "errors" column, which as values
       * has [google.rpc.Status][google.rpc.Status]
       * represented as a STRUCT, and containing only `code` and `message`.
       * </pre>
       *
       * <code>.google.cloud.aiplatform.v1beta1.BigQueryDestination bigquery_destination = 3;</code>
       */
      private com.google.protobuf.SingleFieldBuilderV3<
              com.google.cloud.aiplatform.v1beta1.BigQueryDestination,
              com.google.cloud.aiplatform.v1beta1.BigQueryDestination.Builder,
              com.google.cloud.aiplatform.v1beta1.BigQueryDestinationOrBuilder>
          getBigqueryDestinationFieldBuilder() {
        if (bigqueryDestinationBuilder_ == null) {
          if (!(destinationCase_ == 3)) {
            destination_ =
                com.google.cloud.aiplatform.v1beta1.BigQueryDestination.getDefaultInstance();
          }
          bigqueryDestinationBuilder_ =
              new com.google.protobuf.SingleFieldBuilderV3<
                  com.google.cloud.aiplatform.v1beta1.BigQueryDestination,
                  com.google.cloud.aiplatform.v1beta1.BigQueryDestination.Builder,
                  com.google.cloud.aiplatform.v1beta1.BigQueryDestinationOrBuilder>(
                  (com.google.cloud.aiplatform.v1beta1.BigQueryDestination) destination_,
                  getParentForChildren(),
                  isClean());
          destination_ = null;
        }
        destinationCase_ = 3;
        onChanged();
        ;
        return bigqueryDestinationBuilder_;
      }

      private java.lang.Object predictionsFormat_ = "";
      /**
       *
       *
       * <pre>
       * Required. The format in which Vertex AI gives the predictions, must be one of the
       * [Model's][google.cloud.aiplatform.v1beta1.BatchPredictionJob.model]
       * [supported_output_storage_formats][google.cloud.aiplatform.v1beta1.Model.supported_output_storage_formats].
       * </pre>
       *
       * <code>string predictions_format = 1 [(.google.api.field_behavior) = REQUIRED];</code>
       *
       * @return The predictionsFormat.
       */
      public java.lang.String getPredictionsFormat() {
        java.lang.Object ref = predictionsFormat_;
        if (!(ref instanceof java.lang.String)) {
          com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
          java.lang.String s = bs.toStringUtf8();
          predictionsFormat_ = s;
          return s;
        } else {
          return (java.lang.String) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * Required. The format in which Vertex AI gives the predictions, must be one of the
       * [Model's][google.cloud.aiplatform.v1beta1.BatchPredictionJob.model]
       * [supported_output_storage_formats][google.cloud.aiplatform.v1beta1.Model.supported_output_storage_formats].
       * </pre>
       *
       * <code>string predictions_format = 1 [(.google.api.field_behavior) = REQUIRED];</code>
       *
       * @return The bytes for predictionsFormat.
       */
      public com.google.protobuf.ByteString getPredictionsFormatBytes() {
        java.lang.Object ref = predictionsFormat_;
        if (ref instanceof String) {
          com.google.protobuf.ByteString b =
              com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
          predictionsFormat_ = b;
          return b;
        } else {
          return (com.google.protobuf.ByteString) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * Required. The format in which Vertex AI gives the predictions, must be one of the
       * [Model's][google.cloud.aiplatform.v1beta1.BatchPredictionJob.model]
       * [supported_output_storage_formats][google.cloud.aiplatform.v1beta1.Model.supported_output_storage_formats].
       * </pre>
       *
       * <code>string predictions_format = 1 [(.google.api.field_behavior) = REQUIRED];</code>
       *
       * @param value The predictionsFormat to set.
       * @return This builder for chaining.
       */
      public Builder setPredictionsFormat(java.lang.String value) {
        if (value == null) {
          throw new NullPointerException();
        }

        predictionsFormat_ = value;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Required. The format in which Vertex AI gives the predictions, must be one of the
       * [Model's][google.cloud.aiplatform.v1beta1.BatchPredictionJob.model]
       * [supported_output_storage_formats][google.cloud.aiplatform.v1beta1.Model.supported_output_storage_formats].
       * </pre>
       *
       * <code>string predictions_format = 1 [(.google.api.field_behavior) = REQUIRED];</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearPredictionsFormat() {

        predictionsFormat_ = getDefaultInstance().getPredictionsFormat();
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Required. The format in which Vertex AI gives the predictions, must be one of the
       * [Model's][google.cloud.aiplatform.v1beta1.BatchPredictionJob.model]
       * [supported_output_storage_formats][google.cloud.aiplatform.v1beta1.Model.supported_output_storage_formats].
       * </pre>
       *
       * <code>string predictions_format = 1 [(.google.api.field_behavior) = REQUIRED];</code>
       *
       * @param value The bytes for predictionsFormat to set.
       * @return This builder for chaining.
       */
      public Builder setPredictionsFormatBytes(com.google.protobuf.ByteString value) {
        if (value == null) {
          throw new NullPointerException();
        }
        checkByteStringIsUtf8(value);

        predictionsFormat_ = value;
        onChanged();
        return this;
      }

      @java.lang.Override
      public final Builder setUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.setUnknownFields(unknownFields);
      }

      @java.lang.Override
      public final Builder mergeUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.mergeUnknownFields(unknownFields);
      }

      // @@protoc_insertion_point(builder_scope:google.cloud.aiplatform.v1beta1.BatchPredictionJob.OutputConfig)
    }

    // @@protoc_insertion_point(class_scope:google.cloud.aiplatform.v1beta1.BatchPredictionJob.OutputConfig)
    private static final com.google.cloud.aiplatform.v1beta1.BatchPredictionJob.OutputConfig
        DEFAULT_INSTANCE;

    static {
      DEFAULT_INSTANCE = new com.google.cloud.aiplatform.v1beta1.BatchPredictionJob.OutputConfig();
    }

    public static com.google.cloud.aiplatform.v1beta1.BatchPredictionJob.OutputConfig
        getDefaultInstance() {
      return DEFAULT_INSTANCE;
    }

    private static final com.google.protobuf.Parser<OutputConfig> PARSER =
        new com.google.protobuf.AbstractParser<OutputConfig>() {
          @java.lang.Override
          public OutputConfig parsePartialFrom(
              com.google.protobuf.CodedInputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
            return new OutputConfig(input, extensionRegistry);
          }
        };

    public static com.google.protobuf.Parser<OutputConfig> parser() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.protobuf.Parser<OutputConfig> getParserForType() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.cloud.aiplatform.v1beta1.BatchPredictionJob.OutputConfig
        getDefaultInstanceForType() {
      return DEFAULT_INSTANCE;
    }
  }

  public interface OutputInfoOrBuilder
      extends
      // @@protoc_insertion_point(interface_extends:google.cloud.aiplatform.v1beta1.BatchPredictionJob.OutputInfo)
      com.google.protobuf.MessageOrBuilder {

    /**
     *
     *
     * <pre>
     * Output only. The full path of the Cloud Storage directory created, into which
     * the prediction output is written.
     * </pre>
     *
     * <code>string gcs_output_directory = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return Whether the gcsOutputDirectory field is set.
     */
    boolean hasGcsOutputDirectory();
    /**
     *
     *
     * <pre>
     * Output only. The full path of the Cloud Storage directory created, into which
     * the prediction output is written.
     * </pre>
     *
     * <code>string gcs_output_directory = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return The gcsOutputDirectory.
     */
    java.lang.String getGcsOutputDirectory();
    /**
     *
     *
     * <pre>
     * Output only. The full path of the Cloud Storage directory created, into which
     * the prediction output is written.
     * </pre>
     *
     * <code>string gcs_output_directory = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return The bytes for gcsOutputDirectory.
     */
    com.google.protobuf.ByteString getGcsOutputDirectoryBytes();

    /**
     *
     *
     * <pre>
     * Output only. The path of the BigQuery dataset created, in
     * `bq://projectId.bqDatasetId`
     * format, into which the prediction output is written.
     * </pre>
     *
     * <code>string bigquery_output_dataset = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return Whether the bigqueryOutputDataset field is set.
     */
    boolean hasBigqueryOutputDataset();
    /**
     *
     *
     * <pre>
     * Output only. The path of the BigQuery dataset created, in
     * `bq://projectId.bqDatasetId`
     * format, into which the prediction output is written.
     * </pre>
     *
     * <code>string bigquery_output_dataset = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return The bigqueryOutputDataset.
     */
    java.lang.String getBigqueryOutputDataset();
    /**
     *
     *
     * <pre>
     * Output only. The path of the BigQuery dataset created, in
     * `bq://projectId.bqDatasetId`
     * format, into which the prediction output is written.
     * </pre>
     *
     * <code>string bigquery_output_dataset = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return The bytes for bigqueryOutputDataset.
     */
    com.google.protobuf.ByteString getBigqueryOutputDatasetBytes();

    /**
     *
     *
     * <pre>
     * Output only. The name of the BigQuery table created, in
     * `predictions_&lt;timestamp&gt;`
     * format, into which the prediction output is written.
     * Can be used by UI to generate the BigQuery output path, for example.
     * </pre>
     *
     * <code>string bigquery_output_table = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return The bigqueryOutputTable.
     */
    java.lang.String getBigqueryOutputTable();
    /**
     *
     *
     * <pre>
     * Output only. The name of the BigQuery table created, in
     * `predictions_&lt;timestamp&gt;`
     * format, into which the prediction output is written.
     * Can be used by UI to generate the BigQuery output path, for example.
     * </pre>
     *
     * <code>string bigquery_output_table = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return The bytes for bigqueryOutputTable.
     */
    com.google.protobuf.ByteString getBigqueryOutputTableBytes();

    public com.google.cloud.aiplatform.v1beta1.BatchPredictionJob.OutputInfo.OutputLocationCase
        getOutputLocationCase();
  }
  /**
   *
   *
   * <pre>
   * Further describes this job's output.
   * Supplements [output_config][google.cloud.aiplatform.v1beta1.BatchPredictionJob.output_config].
   * </pre>
   *
   * Protobuf type {@code google.cloud.aiplatform.v1beta1.BatchPredictionJob.OutputInfo}
   */
  public static final class OutputInfo extends com.google.protobuf.GeneratedMessageV3
      implements
      // @@protoc_insertion_point(message_implements:google.cloud.aiplatform.v1beta1.BatchPredictionJob.OutputInfo)
      OutputInfoOrBuilder {
    private static final long serialVersionUID = 0L;
    // Use OutputInfo.newBuilder() to construct.
    private OutputInfo(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
      super(builder);
    }

    private OutputInfo() {
      bigqueryOutputTable_ = "";
    }

    @java.lang.Override
    @SuppressWarnings({"unused"})
    protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
      return new OutputInfo();
    }

    @java.lang.Override
    public final com.google.protobuf.UnknownFieldSet getUnknownFields() {
      return this.unknownFields;
    }

    private OutputInfo(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      this();
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      com.google.protobuf.UnknownFieldSet.Builder unknownFields =
          com.google.protobuf.UnknownFieldSet.newBuilder();
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 10:
              {
                java.lang.String s = input.readStringRequireUtf8();
                outputLocationCase_ = 1;
                outputLocation_ = s;
                break;
              }
            case 18:
              {
                java.lang.String s = input.readStringRequireUtf8();
                outputLocationCase_ = 2;
                outputLocation_ = s;
                break;
              }
            case 34:
              {
                java.lang.String s = input.readStringRequireUtf8();

                bigqueryOutputTable_ = s;
                break;
              }
            default:
              {
                if (!parseUnknownField(input, unknownFields, extensionRegistry, tag)) {
                  done = true;
                }
                break;
              }
          }
        }
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.setUnfinishedMessage(this);
      } catch (java.io.IOException e) {
        throw new com.google.protobuf.InvalidProtocolBufferException(e).setUnfinishedMessage(this);
      } finally {
        this.unknownFields = unknownFields.build();
        makeExtensionsImmutable();
      }
    }

    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.aiplatform.v1beta1.BatchPredictionJobProto
          .internal_static_google_cloud_aiplatform_v1beta1_BatchPredictionJob_OutputInfo_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.aiplatform.v1beta1.BatchPredictionJobProto
          .internal_static_google_cloud_aiplatform_v1beta1_BatchPredictionJob_OutputInfo_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.aiplatform.v1beta1.BatchPredictionJob.OutputInfo.class,
              com.google.cloud.aiplatform.v1beta1.BatchPredictionJob.OutputInfo.Builder.class);
    }

    private int outputLocationCase_ = 0;
    private java.lang.Object outputLocation_;

    public enum OutputLocationCase
        implements
            com.google.protobuf.Internal.EnumLite,
            com.google.protobuf.AbstractMessage.InternalOneOfEnum {
      GCS_OUTPUT_DIRECTORY(1),
      BIGQUERY_OUTPUT_DATASET(2),
      OUTPUTLOCATION_NOT_SET(0);
      private final int value;

      private OutputLocationCase(int value) {
        this.value = value;
      }
      /**
       * @param value The number of the enum to look for.
       * @return The enum associated with the given number.
       * @deprecated Use {@link #forNumber(int)} instead.
       */
      @java.lang.Deprecated
      public static OutputLocationCase valueOf(int value) {
        return forNumber(value);
      }

      public static OutputLocationCase forNumber(int value) {
        switch (value) {
          case 1:
            return GCS_OUTPUT_DIRECTORY;
          case 2:
            return BIGQUERY_OUTPUT_DATASET;
          case 0:
            return OUTPUTLOCATION_NOT_SET;
          default:
            return null;
        }
      }

      public int getNumber() {
        return this.value;
      }
    };

    public OutputLocationCase getOutputLocationCase() {
      return OutputLocationCase.forNumber(outputLocationCase_);
    }

    public static final int GCS_OUTPUT_DIRECTORY_FIELD_NUMBER = 1;
    /**
     *
     *
     * <pre>
     * Output only. The full path of the Cloud Storage directory created, into which
     * the prediction output is written.
     * </pre>
     *
     * <code>string gcs_output_directory = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return Whether the gcsOutputDirectory field is set.
     */
    public boolean hasGcsOutputDirectory() {
      return outputLocationCase_ == 1;
    }
    /**
     *
     *
     * <pre>
     * Output only. The full path of the Cloud Storage directory created, into which
     * the prediction output is written.
     * </pre>
     *
     * <code>string gcs_output_directory = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return The gcsOutputDirectory.
     */
    public java.lang.String getGcsOutputDirectory() {
      java.lang.Object ref = "";
      if (outputLocationCase_ == 1) {
        ref = outputLocation_;
      }
      if (ref instanceof java.lang.String) {
        return (java.lang.String) ref;
      } else {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        if (outputLocationCase_ == 1) {
          outputLocation_ = s;
        }
        return s;
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. The full path of the Cloud Storage directory created, into which
     * the prediction output is written.
     * </pre>
     *
     * <code>string gcs_output_directory = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return The bytes for gcsOutputDirectory.
     */
    public com.google.protobuf.ByteString getGcsOutputDirectoryBytes() {
      java.lang.Object ref = "";
      if (outputLocationCase_ == 1) {
        ref = outputLocation_;
      }
      if (ref instanceof java.lang.String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        if (outputLocationCase_ == 1) {
          outputLocation_ = b;
        }
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    public static final int BIGQUERY_OUTPUT_DATASET_FIELD_NUMBER = 2;
    /**
     *
     *
     * <pre>
     * Output only. The path of the BigQuery dataset created, in
     * `bq://projectId.bqDatasetId`
     * format, into which the prediction output is written.
     * </pre>
     *
     * <code>string bigquery_output_dataset = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return Whether the bigqueryOutputDataset field is set.
     */
    public boolean hasBigqueryOutputDataset() {
      return outputLocationCase_ == 2;
    }
    /**
     *
     *
     * <pre>
     * Output only. The path of the BigQuery dataset created, in
     * `bq://projectId.bqDatasetId`
     * format, into which the prediction output is written.
     * </pre>
     *
     * <code>string bigquery_output_dataset = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return The bigqueryOutputDataset.
     */
    public java.lang.String getBigqueryOutputDataset() {
      java.lang.Object ref = "";
      if (outputLocationCase_ == 2) {
        ref = outputLocation_;
      }
      if (ref instanceof java.lang.String) {
        return (java.lang.String) ref;
      } else {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        if (outputLocationCase_ == 2) {
          outputLocation_ = s;
        }
        return s;
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. The path of the BigQuery dataset created, in
     * `bq://projectId.bqDatasetId`
     * format, into which the prediction output is written.
     * </pre>
     *
     * <code>string bigquery_output_dataset = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return The bytes for bigqueryOutputDataset.
     */
    public com.google.protobuf.ByteString getBigqueryOutputDatasetBytes() {
      java.lang.Object ref = "";
      if (outputLocationCase_ == 2) {
        ref = outputLocation_;
      }
      if (ref instanceof java.lang.String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        if (outputLocationCase_ == 2) {
          outputLocation_ = b;
        }
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    public static final int BIGQUERY_OUTPUT_TABLE_FIELD_NUMBER = 4;
    private volatile java.lang.Object bigqueryOutputTable_;
    /**
     *
     *
     * <pre>
     * Output only. The name of the BigQuery table created, in
     * `predictions_&lt;timestamp&gt;`
     * format, into which the prediction output is written.
     * Can be used by UI to generate the BigQuery output path, for example.
     * </pre>
     *
     * <code>string bigquery_output_table = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return The bigqueryOutputTable.
     */
    @java.lang.Override
    public java.lang.String getBigqueryOutputTable() {
      java.lang.Object ref = bigqueryOutputTable_;
      if (ref instanceof java.lang.String) {
        return (java.lang.String) ref;
      } else {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        bigqueryOutputTable_ = s;
        return s;
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. The name of the BigQuery table created, in
     * `predictions_&lt;timestamp&gt;`
     * format, into which the prediction output is written.
     * Can be used by UI to generate the BigQuery output path, for example.
     * </pre>
     *
     * <code>string bigquery_output_table = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return The bytes for bigqueryOutputTable.
     */
    @java.lang.Override
    public com.google.protobuf.ByteString getBigqueryOutputTableBytes() {
      java.lang.Object ref = bigqueryOutputTable_;
      if (ref instanceof java.lang.String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        bigqueryOutputTable_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    private byte memoizedIsInitialized = -1;

    @java.lang.Override
    public final boolean isInitialized() {
      byte isInitialized = memoizedIsInitialized;
      if (isInitialized == 1) return true;
      if (isInitialized == 0) return false;

      memoizedIsInitialized = 1;
      return true;
    }

    @java.lang.Override
    public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
      if (outputLocationCase_ == 1) {
        com.google.protobuf.GeneratedMessageV3.writeString(output, 1, outputLocation_);
      }
      if (outputLocationCase_ == 2) {
        com.google.protobuf.GeneratedMessageV3.writeString(output, 2, outputLocation_);
      }
      if (!getBigqueryOutputTableBytes().isEmpty()) {
        com.google.protobuf.GeneratedMessageV3.writeString(output, 4, bigqueryOutputTable_);
      }
      unknownFields.writeTo(output);
    }

    @java.lang.Override
    public int getSerializedSize() {
      int size = memoizedSize;
      if (size != -1) return size;

      size = 0;
      if (outputLocationCase_ == 1) {
        size += com.google.protobuf.GeneratedMessageV3.computeStringSize(1, outputLocation_);
      }
      if (outputLocationCase_ == 2) {
        size += com.google.protobuf.GeneratedMessageV3.computeStringSize(2, outputLocation_);
      }
      if (!getBigqueryOutputTableBytes().isEmpty()) {
        size += com.google.protobuf.GeneratedMessageV3.computeStringSize(4, bigqueryOutputTable_);
      }
      size += unknownFields.getSerializedSize();
      memoizedSize = size;
      return size;
    }

    @java.lang.Override
    public boolean equals(final java.lang.Object obj) {
      if (obj == this) {
        return true;
      }
      if (!(obj instanceof com.google.cloud.aiplatform.v1beta1.BatchPredictionJob.OutputInfo)) {
        return super.equals(obj);
      }
      com.google.cloud.aiplatform.v1beta1.BatchPredictionJob.OutputInfo other =
          (com.google.cloud.aiplatform.v1beta1.BatchPredictionJob.OutputInfo) obj;

      if (!getBigqueryOutputTable().equals(other.getBigqueryOutputTable())) return false;
      if (!getOutputLocationCase().equals(other.getOutputLocationCase())) return false;
      switch (outputLocationCase_) {
        case 1:
          if (!getGcsOutputDirectory().equals(other.getGcsOutputDirectory())) return false;
          break;
        case 2:
          if (!getBigqueryOutputDataset().equals(other.getBigqueryOutputDataset())) return false;
          break;
        case 0:
        default:
      }
      if (!unknownFields.equals(other.unknownFields)) return false;
      return true;
    }

    @java.lang.Override
    public int hashCode() {
      if (memoizedHashCode != 0) {
        return memoizedHashCode;
      }
      int hash = 41;
      hash = (19 * hash) + getDescriptor().hashCode();
      hash = (37 * hash) + BIGQUERY_OUTPUT_TABLE_FIELD_NUMBER;
      hash = (53 * hash) + getBigqueryOutputTable().hashCode();
      switch (outputLocationCase_) {
        case 1:
          hash = (37 * hash) + GCS_OUTPUT_DIRECTORY_FIELD_NUMBER;
          hash = (53 * hash) + getGcsOutputDirectory().hashCode();
          break;
        case 2:
          hash = (37 * hash) + BIGQUERY_OUTPUT_DATASET_FIELD_NUMBER;
          hash = (53 * hash) + getBigqueryOutputDataset().hashCode();
          break;
        case 0:
        default:
      }
      hash = (29 * hash) + unknownFields.hashCode();
      memoizedHashCode = hash;
      return hash;
    }

    public static com.google.cloud.aiplatform.v1beta1.BatchPredictionJob.OutputInfo parseFrom(
        java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.aiplatform.v1beta1.BatchPredictionJob.OutputInfo parseFrom(
        java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.aiplatform.v1beta1.BatchPredictionJob.OutputInfo parseFrom(
        com.google.protobuf.ByteString data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.aiplatform.v1beta1.BatchPredictionJob.OutputInfo parseFrom(
        com.google.protobuf.ByteString data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.aiplatform.v1beta1.BatchPredictionJob.OutputInfo parseFrom(
        byte[] data) throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.aiplatform.v1beta1.BatchPredictionJob.OutputInfo parseFrom(
        byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.aiplatform.v1beta1.BatchPredictionJob.OutputInfo parseFrom(
        java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.cloud.aiplatform.v1beta1.BatchPredictionJob.OutputInfo parseFrom(
        java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.cloud.aiplatform.v1beta1.BatchPredictionJob.OutputInfo
        parseDelimitedFrom(java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
    }

    public static com.google.cloud.aiplatform.v1beta1.BatchPredictionJob.OutputInfo
        parseDelimitedFrom(
            java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.cloud.aiplatform.v1beta1.BatchPredictionJob.OutputInfo parseFrom(
        com.google.protobuf.CodedInputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.cloud.aiplatform.v1beta1.BatchPredictionJob.OutputInfo parseFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    @java.lang.Override
    public Builder newBuilderForType() {
      return newBuilder();
    }

    public static Builder newBuilder() {
      return DEFAULT_INSTANCE.toBuilder();
    }

    public static Builder newBuilder(
        com.google.cloud.aiplatform.v1beta1.BatchPredictionJob.OutputInfo prototype) {
      return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }

    @java.lang.Override
    public Builder toBuilder() {
      return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
    }

    @java.lang.Override
    protected Builder newBuilderForType(
        com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      Builder builder = new Builder(parent);
      return builder;
    }
    /**
     *
     *
     * <pre>
     * Further describes this job's output.
     * Supplements [output_config][google.cloud.aiplatform.v1beta1.BatchPredictionJob.output_config].
     * </pre>
     *
     * Protobuf type {@code google.cloud.aiplatform.v1beta1.BatchPredictionJob.OutputInfo}
     */
    public static final class Builder
        extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
        implements
        // @@protoc_insertion_point(builder_implements:google.cloud.aiplatform.v1beta1.BatchPredictionJob.OutputInfo)
        com.google.cloud.aiplatform.v1beta1.BatchPredictionJob.OutputInfoOrBuilder {
      public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
        return com.google.cloud.aiplatform.v1beta1.BatchPredictionJobProto
            .internal_static_google_cloud_aiplatform_v1beta1_BatchPredictionJob_OutputInfo_descriptor;
      }

      @java.lang.Override
      protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return com.google.cloud.aiplatform.v1beta1.BatchPredictionJobProto
            .internal_static_google_cloud_aiplatform_v1beta1_BatchPredictionJob_OutputInfo_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                com.google.cloud.aiplatform.v1beta1.BatchPredictionJob.OutputInfo.class,
                com.google.cloud.aiplatform.v1beta1.BatchPredictionJob.OutputInfo.Builder.class);
      }

      // Construct using
      // com.google.cloud.aiplatform.v1beta1.BatchPredictionJob.OutputInfo.newBuilder()
      private Builder() {
        maybeForceBuilderInitialization();
      }

      private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
        super(parent);
        maybeForceBuilderInitialization();
      }

      private void maybeForceBuilderInitialization() {
        if (com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders) {}
      }

      @java.lang.Override
      public Builder clear() {
        super.clear();
        bigqueryOutputTable_ = "";

        outputLocationCase_ = 0;
        outputLocation_ = null;
        return this;
      }

      @java.lang.Override
      public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
        return com.google.cloud.aiplatform.v1beta1.BatchPredictionJobProto
            .internal_static_google_cloud_aiplatform_v1beta1_BatchPredictionJob_OutputInfo_descriptor;
      }

      @java.lang.Override
      public com.google.cloud.aiplatform.v1beta1.BatchPredictionJob.OutputInfo
          getDefaultInstanceForType() {
        return com.google.cloud.aiplatform.v1beta1.BatchPredictionJob.OutputInfo
            .getDefaultInstance();
      }

      @java.lang.Override
      public com.google.cloud.aiplatform.v1beta1.BatchPredictionJob.OutputInfo build() {
        com.google.cloud.aiplatform.v1beta1.BatchPredictionJob.OutputInfo result = buildPartial();
        if (!result.isInitialized()) {
          throw newUninitializedMessageException(result);
        }
        return result;
      }

      @java.lang.Override
      public com.google.cloud.aiplatform.v1beta1.BatchPredictionJob.OutputInfo buildPartial() {
        com.google.cloud.aiplatform.v1beta1.BatchPredictionJob.OutputInfo result =
            new com.google.cloud.aiplatform.v1beta1.BatchPredictionJob.OutputInfo(this);
        if (outputLocationCase_ == 1) {
          result.outputLocation_ = outputLocation_;
        }
        if (outputLocationCase_ == 2) {
          result.outputLocation_ = outputLocation_;
        }
        result.bigqueryOutputTable_ = bigqueryOutputTable_;
        result.outputLocationCase_ = outputLocationCase_;
        onBuilt();
        return result;
      }

      @java.lang.Override
      public Builder clone() {
        return super.clone();
      }

      @java.lang.Override
      public Builder setField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.setField(field, value);
      }

      @java.lang.Override
      public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
        return super.clearField(field);
      }

      @java.lang.Override
      public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
        return super.clearOneof(oneof);
      }

      @java.lang.Override
      public Builder setRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          int index,
          java.lang.Object value) {
        return super.setRepeatedField(field, index, value);
      }

      @java.lang.Override
      public Builder addRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.addRepeatedField(field, value);
      }

      @java.lang.Override
      public Builder mergeFrom(com.google.protobuf.Message other) {
        if (other instanceof com.google.cloud.aiplatform.v1beta1.BatchPredictionJob.OutputInfo) {
          return mergeFrom(
              (com.google.cloud.aiplatform.v1beta1.BatchPredictionJob.OutputInfo) other);
        } else {
          super.mergeFrom(other);
          return this;
        }
      }

      public Builder mergeFrom(
          com.google.cloud.aiplatform.v1beta1.BatchPredictionJob.OutputInfo other) {
        if (other
            == com.google.cloud.aiplatform.v1beta1.BatchPredictionJob.OutputInfo
                .getDefaultInstance()) return this;
        if (!other.getBigqueryOutputTable().isEmpty()) {
          bigqueryOutputTable_ = other.bigqueryOutputTable_;
          onChanged();
        }
        switch (other.getOutputLocationCase()) {
          case GCS_OUTPUT_DIRECTORY:
            {
              outputLocationCase_ = 1;
              outputLocation_ = other.outputLocation_;
              onChanged();
              break;
            }
          case BIGQUERY_OUTPUT_DATASET:
            {
              outputLocationCase_ = 2;
              outputLocation_ = other.outputLocation_;
              onChanged();
              break;
            }
          case OUTPUTLOCATION_NOT_SET:
            {
              break;
            }
        }
        this.mergeUnknownFields(other.unknownFields);
        onChanged();
        return this;
      }

      @java.lang.Override
      public final boolean isInitialized() {
        return true;
      }

      @java.lang.Override
      public Builder mergeFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        com.google.cloud.aiplatform.v1beta1.BatchPredictionJob.OutputInfo parsedMessage = null;
        try {
          parsedMessage = PARSER.parsePartialFrom(input, extensionRegistry);
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          parsedMessage =
              (com.google.cloud.aiplatform.v1beta1.BatchPredictionJob.OutputInfo)
                  e.getUnfinishedMessage();
          throw e.unwrapIOException();
        } finally {
          if (parsedMessage != null) {
            mergeFrom(parsedMessage);
          }
        }
        return this;
      }

      private int outputLocationCase_ = 0;
      private java.lang.Object outputLocation_;

      public OutputLocationCase getOutputLocationCase() {
        return OutputLocationCase.forNumber(outputLocationCase_);
      }

      public Builder clearOutputLocation() {
        outputLocationCase_ = 0;
        outputLocation_ = null;
        onChanged();
        return this;
      }

      /**
       *
       *
       * <pre>
       * Output only. The full path of the Cloud Storage directory created, into which
       * the prediction output is written.
       * </pre>
       *
       * <code>string gcs_output_directory = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
       *
       * @return Whether the gcsOutputDirectory field is set.
       */
      @java.lang.Override
      public boolean hasGcsOutputDirectory() {
        return outputLocationCase_ == 1;
      }
      /**
       *
       *
       * <pre>
       * Output only. The full path of the Cloud Storage directory created, into which
       * the prediction output is written.
       * </pre>
       *
       * <code>string gcs_output_directory = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
       *
       * @return The gcsOutputDirectory.
       */
      @java.lang.Override
      public java.lang.String getGcsOutputDirectory() {
        java.lang.Object ref = "";
        if (outputLocationCase_ == 1) {
          ref = outputLocation_;
        }
        if (!(ref instanceof java.lang.String)) {
          com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
          java.lang.String s = bs.toStringUtf8();
          if (outputLocationCase_ == 1) {
            outputLocation_ = s;
          }
          return s;
        } else {
          return (java.lang.String) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * Output only. The full path of the Cloud Storage directory created, into which
       * the prediction output is written.
       * </pre>
       *
       * <code>string gcs_output_directory = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
       *
       * @return The bytes for gcsOutputDirectory.
       */
      @java.lang.Override
      public com.google.protobuf.ByteString getGcsOutputDirectoryBytes() {
        java.lang.Object ref = "";
        if (outputLocationCase_ == 1) {
          ref = outputLocation_;
        }
        if (ref instanceof String) {
          com.google.protobuf.ByteString b =
              com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
          if (outputLocationCase_ == 1) {
            outputLocation_ = b;
          }
          return b;
        } else {
          return (com.google.protobuf.ByteString) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * Output only. The full path of the Cloud Storage directory created, into which
       * the prediction output is written.
       * </pre>
       *
       * <code>string gcs_output_directory = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
       *
       * @param value The gcsOutputDirectory to set.
       * @return This builder for chaining.
       */
      public Builder setGcsOutputDirectory(java.lang.String value) {
        if (value == null) {
          throw new NullPointerException();
        }
        outputLocationCase_ = 1;
        outputLocation_ = value;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Output only. The full path of the Cloud Storage directory created, into which
       * the prediction output is written.
       * </pre>
       *
       * <code>string gcs_output_directory = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearGcsOutputDirectory() {
        if (outputLocationCase_ == 1) {
          outputLocationCase_ = 0;
          outputLocation_ = null;
          onChanged();
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * Output only. The full path of the Cloud Storage directory created, into which
       * the prediction output is written.
       * </pre>
       *
       * <code>string gcs_output_directory = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
       *
       * @param value The bytes for gcsOutputDirectory to set.
       * @return This builder for chaining.
       */
      public Builder setGcsOutputDirectoryBytes(com.google.protobuf.ByteString value) {
        if (value == null) {
          throw new NullPointerException();
        }
        checkByteStringIsUtf8(value);
        outputLocationCase_ = 1;
        outputLocation_ = value;
        onChanged();
        return this;
      }

      /**
       *
       *
       * <pre>
       * Output only. The path of the BigQuery dataset created, in
       * `bq://projectId.bqDatasetId`
       * format, into which the prediction output is written.
       * </pre>
       *
       * <code>string bigquery_output_dataset = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];
       * </code>
       *
       * @return Whether the bigqueryOutputDataset field is set.
       */
      @java.lang.Override
      public boolean hasBigqueryOutputDataset() {
        return outputLocationCase_ == 2;
      }
      /**
       *
       *
       * <pre>
       * Output only. The path of the BigQuery dataset created, in
       * `bq://projectId.bqDatasetId`
       * format, into which the prediction output is written.
       * </pre>
       *
       * <code>string bigquery_output_dataset = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];
       * </code>
       *
       * @return The bigqueryOutputDataset.
       */
      @java.lang.Override
      public java.lang.String getBigqueryOutputDataset() {
        java.lang.Object ref = "";
        if (outputLocationCase_ == 2) {
          ref = outputLocation_;
        }
        if (!(ref instanceof java.lang.String)) {
          com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
          java.lang.String s = bs.toStringUtf8();
          if (outputLocationCase_ == 2) {
            outputLocation_ = s;
          }
          return s;
        } else {
          return (java.lang.String) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * Output only. The path of the BigQuery dataset created, in
       * `bq://projectId.bqDatasetId`
       * format, into which the prediction output is written.
       * </pre>
       *
       * <code>string bigquery_output_dataset = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];
       * </code>
       *
       * @return The bytes for bigqueryOutputDataset.
       */
      @java.lang.Override
      public com.google.protobuf.ByteString getBigqueryOutputDatasetBytes() {
        java.lang.Object ref = "";
        if (outputLocationCase_ == 2) {
          ref = outputLocation_;
        }
        if (ref instanceof String) {
          com.google.protobuf.ByteString b =
              com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
          if (outputLocationCase_ == 2) {
            outputLocation_ = b;
          }
          return b;
        } else {
          return (com.google.protobuf.ByteString) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * Output only. The path of the BigQuery dataset created, in
       * `bq://projectId.bqDatasetId`
       * format, into which the prediction output is written.
       * </pre>
       *
       * <code>string bigquery_output_dataset = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];
       * </code>
       *
       * @param value The bigqueryOutputDataset to set.
       * @return This builder for chaining.
       */
      public Builder setBigqueryOutputDataset(java.lang.String value) {
        if (value == null) {
          throw new NullPointerException();
        }
        outputLocationCase_ = 2;
        outputLocation_ = value;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Output only. The path of the BigQuery dataset created, in
       * `bq://projectId.bqDatasetId`
       * format, into which the prediction output is written.
       * </pre>
       *
       * <code>string bigquery_output_dataset = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];
       * </code>
       *
       * @return This builder for chaining.
       */
      public Builder clearBigqueryOutputDataset() {
        if (outputLocationCase_ == 2) {
          outputLocationCase_ = 0;
          outputLocation_ = null;
          onChanged();
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * Output only. The path of the BigQuery dataset created, in
       * `bq://projectId.bqDatasetId`
       * format, into which the prediction output is written.
       * </pre>
       *
       * <code>string bigquery_output_dataset = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];
       * </code>
       *
       * @param value The bytes for bigqueryOutputDataset to set.
       * @return This builder for chaining.
       */
      public Builder setBigqueryOutputDatasetBytes(com.google.protobuf.ByteString value) {
        if (value == null) {
          throw new NullPointerException();
        }
        checkByteStringIsUtf8(value);
        outputLocationCase_ = 2;
        outputLocation_ = value;
        onChanged();
        return this;
      }

      private java.lang.Object bigqueryOutputTable_ = "";
      /**
       *
       *
       * <pre>
       * Output only. The name of the BigQuery table created, in
       * `predictions_&lt;timestamp&gt;`
       * format, into which the prediction output is written.
       * Can be used by UI to generate the BigQuery output path, for example.
       * </pre>
       *
       * <code>string bigquery_output_table = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
       *
       * @return The bigqueryOutputTable.
       */
      public java.lang.String getBigqueryOutputTable() {
        java.lang.Object ref = bigqueryOutputTable_;
        if (!(ref instanceof java.lang.String)) {
          com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
          java.lang.String s = bs.toStringUtf8();
          bigqueryOutputTable_ = s;
          return s;
        } else {
          return (java.lang.String) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * Output only. The name of the BigQuery table created, in
       * `predictions_&lt;timestamp&gt;`
       * format, into which the prediction output is written.
       * Can be used by UI to generate the BigQuery output path, for example.
       * </pre>
       *
       * <code>string bigquery_output_table = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
       *
       * @return The bytes for bigqueryOutputTable.
       */
      public com.google.protobuf.ByteString getBigqueryOutputTableBytes() {
        java.lang.Object ref = bigqueryOutputTable_;
        if (ref instanceof String) {
          com.google.protobuf.ByteString b =
              com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
          bigqueryOutputTable_ = b;
          return b;
        } else {
          return (com.google.protobuf.ByteString) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * Output only. The name of the BigQuery table created, in
       * `predictions_&lt;timestamp&gt;`
       * format, into which the prediction output is written.
       * Can be used by UI to generate the BigQuery output path, for example.
       * </pre>
       *
       * <code>string bigquery_output_table = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
       *
       * @param value The bigqueryOutputTable to set.
       * @return This builder for chaining.
       */
      public Builder setBigqueryOutputTable(java.lang.String value) {
        if (value == null) {
          throw new NullPointerException();
        }

        bigqueryOutputTable_ = value;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Output only. The name of the BigQuery table created, in
       * `predictions_&lt;timestamp&gt;`
       * format, into which the prediction output is written.
       * Can be used by UI to generate the BigQuery output path, for example.
       * </pre>
       *
       * <code>string bigquery_output_table = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearBigqueryOutputTable() {

        bigqueryOutputTable_ = getDefaultInstance().getBigqueryOutputTable();
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Output only. The name of the BigQuery table created, in
       * `predictions_&lt;timestamp&gt;`
       * format, into which the prediction output is written.
       * Can be used by UI to generate the BigQuery output path, for example.
       * </pre>
       *
       * <code>string bigquery_output_table = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
       *
       * @param value The bytes for bigqueryOutputTable to set.
       * @return This builder for chaining.
       */
      public Builder setBigqueryOutputTableBytes(com.google.protobuf.ByteString value) {
        if (value == null) {
          throw new NullPointerException();
        }
        checkByteStringIsUtf8(value);

        bigqueryOutputTable_ = value;
        onChanged();
        return this;
      }

      @java.lang.Override
      public final Builder setUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.setUnknownFields(unknownFields);
      }

      @java.lang.Override
      public final Builder mergeUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.mergeUnknownFields(unknownFields);
      }

      // @@protoc_insertion_point(builder_scope:google.cloud.aiplatform.v1beta1.BatchPredictionJob.OutputInfo)
    }

    // @@protoc_insertion_point(class_scope:google.cloud.aiplatform.v1beta1.BatchPredictionJob.OutputInfo)
    private static final com.google.cloud.aiplatform.v1beta1.BatchPredictionJob.OutputInfo
        DEFAULT_INSTANCE;

    static {
      DEFAULT_INSTANCE = new com.google.cloud.aiplatform.v1beta1.BatchPredictionJob.OutputInfo();
    }

    public static com.google.cloud.aiplatform.v1beta1.BatchPredictionJob.OutputInfo
        getDefaultInstance() {
      return DEFAULT_INSTANCE;
    }

    private static final com.google.protobuf.Parser<OutputInfo> PARSER =
        new com.google.protobuf.AbstractParser<OutputInfo>() {
          @java.lang.Override
          public OutputInfo parsePartialFrom(
              com.google.protobuf.CodedInputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
            return new OutputInfo(input, extensionRegistry);
          }
        };

    public static com.google.protobuf.Parser<OutputInfo> parser() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.protobuf.Parser<OutputInfo> getParserForType() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.cloud.aiplatform.v1beta1.BatchPredictionJob.OutputInfo
        getDefaultInstanceForType() {
      return DEFAULT_INSTANCE;
    }
  }

  public static final int NAME_FIELD_NUMBER = 1;
  private volatile java.lang.Object name_;
  /**
   *
   *
   * <pre>
   * Output only. Resource name of the BatchPredictionJob.
   * </pre>
   *
   * <code>string name = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
   *
   * @return The name.
   */
  @java.lang.Override
  public java.lang.String getName() {
    java.lang.Object ref = name_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      name_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Output only. Resource name of the BatchPredictionJob.
   * </pre>
   *
   * <code>string name = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
   *
   * @return The bytes for name.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getNameBytes() {
    java.lang.Object ref = name_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      name_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int DISPLAY_NAME_FIELD_NUMBER = 2;
  private volatile java.lang.Object displayName_;
  /**
   *
   *
   * <pre>
   * Required. The user-defined name of this BatchPredictionJob.
   * </pre>
   *
   * <code>string display_name = 2 [(.google.api.field_behavior) = REQUIRED];</code>
   *
   * @return The displayName.
   */
  @java.lang.Override
  public java.lang.String getDisplayName() {
    java.lang.Object ref = displayName_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      displayName_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Required. The user-defined name of this BatchPredictionJob.
   * </pre>
   *
   * <code>string display_name = 2 [(.google.api.field_behavior) = REQUIRED];</code>
   *
   * @return The bytes for displayName.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getDisplayNameBytes() {
    java.lang.Object ref = displayName_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      displayName_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int MODEL_FIELD_NUMBER = 3;
  private volatile java.lang.Object model_;
  /**
   *
   *
   * <pre>
   * Required. The name of the Model that produces the predictions via this job,
   * must share the same ancestor Location.
   * Starting this job has no impact on any existing deployments of the Model
   * and their resources.
   * </pre>
   *
   * <code>
   * string model = 3 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
   * </code>
   *
   * @return The model.
   */
  @java.lang.Override
  public java.lang.String getModel() {
    java.lang.Object ref = model_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      model_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Required. The name of the Model that produces the predictions via this job,
   * must share the same ancestor Location.
   * Starting this job has no impact on any existing deployments of the Model
   * and their resources.
   * </pre>
   *
   * <code>
   * string model = 3 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
   * </code>
   *
   * @return The bytes for model.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getModelBytes() {
    java.lang.Object ref = model_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      model_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int INPUT_CONFIG_FIELD_NUMBER = 4;
  private com.google.cloud.aiplatform.v1beta1.BatchPredictionJob.InputConfig inputConfig_;
  /**
   *
   *
   * <pre>
   * Required. Input configuration of the instances on which predictions are performed.
   * The schema of any single instance may be specified via
   * the [Model's][google.cloud.aiplatform.v1beta1.BatchPredictionJob.model]
   * [PredictSchemata's][google.cloud.aiplatform.v1beta1.Model.predict_schemata]
   * [instance_schema_uri][google.cloud.aiplatform.v1beta1.PredictSchemata.instance_schema_uri].
   * </pre>
   *
   * <code>
   * .google.cloud.aiplatform.v1beta1.BatchPredictionJob.InputConfig input_config = 4 [(.google.api.field_behavior) = REQUIRED];
   * </code>
   *
   * @return Whether the inputConfig field is set.
   */
  @java.lang.Override
  public boolean hasInputConfig() {
    return inputConfig_ != null;
  }
  /**
   *
   *
   * <pre>
   * Required. Input configuration of the instances on which predictions are performed.
   * The schema of any single instance may be specified via
   * the [Model's][google.cloud.aiplatform.v1beta1.BatchPredictionJob.model]
   * [PredictSchemata's][google.cloud.aiplatform.v1beta1.Model.predict_schemata]
   * [instance_schema_uri][google.cloud.aiplatform.v1beta1.PredictSchemata.instance_schema_uri].
   * </pre>
   *
   * <code>
   * .google.cloud.aiplatform.v1beta1.BatchPredictionJob.InputConfig input_config = 4 [(.google.api.field_behavior) = REQUIRED];
   * </code>
   *
   * @return The inputConfig.
   */
  @java.lang.Override
  public com.google.cloud.aiplatform.v1beta1.BatchPredictionJob.InputConfig getInputConfig() {
    return inputConfig_ == null
        ? com.google.cloud.aiplatform.v1beta1.BatchPredictionJob.InputConfig.getDefaultInstance()
        : inputConfig_;
  }
  /**
   *
   *
   * <pre>
   * Required. Input configuration of the instances on which predictions are performed.
   * The schema of any single instance may be specified via
   * the [Model's][google.cloud.aiplatform.v1beta1.BatchPredictionJob.model]
   * [PredictSchemata's][google.cloud.aiplatform.v1beta1.Model.predict_schemata]
   * [instance_schema_uri][google.cloud.aiplatform.v1beta1.PredictSchemata.instance_schema_uri].
   * </pre>
   *
   * <code>
   * .google.cloud.aiplatform.v1beta1.BatchPredictionJob.InputConfig input_config = 4 [(.google.api.field_behavior) = REQUIRED];
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.aiplatform.v1beta1.BatchPredictionJob.InputConfigOrBuilder
      getInputConfigOrBuilder() {
    return getInputConfig();
  }

  public static final int MODEL_PARAMETERS_FIELD_NUMBER = 5;
  private com.google.protobuf.Value modelParameters_;
  /**
   *
   *
   * <pre>
   * The parameters that govern the predictions. The schema of the parameters
   * may be specified via the [Model's][google.cloud.aiplatform.v1beta1.BatchPredictionJob.model]
   * [PredictSchemata's][google.cloud.aiplatform.v1beta1.Model.predict_schemata]
   * [parameters_schema_uri][google.cloud.aiplatform.v1beta1.PredictSchemata.parameters_schema_uri].
   * </pre>
   *
   * <code>.google.protobuf.Value model_parameters = 5;</code>
   *
   * @return Whether the modelParameters field is set.
   */
  @java.lang.Override
  public boolean hasModelParameters() {
    return modelParameters_ != null;
  }
  /**
   *
   *
   * <pre>
   * The parameters that govern the predictions. The schema of the parameters
   * may be specified via the [Model's][google.cloud.aiplatform.v1beta1.BatchPredictionJob.model]
   * [PredictSchemata's][google.cloud.aiplatform.v1beta1.Model.predict_schemata]
   * [parameters_schema_uri][google.cloud.aiplatform.v1beta1.PredictSchemata.parameters_schema_uri].
   * </pre>
   *
   * <code>.google.protobuf.Value model_parameters = 5;</code>
   *
   * @return The modelParameters.
   */
  @java.lang.Override
  public com.google.protobuf.Value getModelParameters() {
    return modelParameters_ == null
        ? com.google.protobuf.Value.getDefaultInstance()
        : modelParameters_;
  }
  /**
   *
   *
   * <pre>
   * The parameters that govern the predictions. The schema of the parameters
   * may be specified via the [Model's][google.cloud.aiplatform.v1beta1.BatchPredictionJob.model]
   * [PredictSchemata's][google.cloud.aiplatform.v1beta1.Model.predict_schemata]
   * [parameters_schema_uri][google.cloud.aiplatform.v1beta1.PredictSchemata.parameters_schema_uri].
   * </pre>
   *
   * <code>.google.protobuf.Value model_parameters = 5;</code>
   */
  @java.lang.Override
  public com.google.protobuf.ValueOrBuilder getModelParametersOrBuilder() {
    return getModelParameters();
  }

  public static final int OUTPUT_CONFIG_FIELD_NUMBER = 6;
  private com.google.cloud.aiplatform.v1beta1.BatchPredictionJob.OutputConfig outputConfig_;
  /**
   *
   *
   * <pre>
   * Required. The Configuration specifying where output predictions should
   * be written.
   * The schema of any single prediction may be specified as a concatenation
   * of [Model's][google.cloud.aiplatform.v1beta1.BatchPredictionJob.model]
   * [PredictSchemata's][google.cloud.aiplatform.v1beta1.Model.predict_schemata]
   * [instance_schema_uri][google.cloud.aiplatform.v1beta1.PredictSchemata.instance_schema_uri]
   * and
   * [prediction_schema_uri][google.cloud.aiplatform.v1beta1.PredictSchemata.prediction_schema_uri].
   * </pre>
   *
   * <code>
   * .google.cloud.aiplatform.v1beta1.BatchPredictionJob.OutputConfig output_config = 6 [(.google.api.field_behavior) = REQUIRED];
   * </code>
   *
   * @return Whether the outputConfig field is set.
   */
  @java.lang.Override
  public boolean hasOutputConfig() {
    return outputConfig_ != null;
  }
  /**
   *
   *
   * <pre>
   * Required. The Configuration specifying where output predictions should
   * be written.
   * The schema of any single prediction may be specified as a concatenation
   * of [Model's][google.cloud.aiplatform.v1beta1.BatchPredictionJob.model]
   * [PredictSchemata's][google.cloud.aiplatform.v1beta1.Model.predict_schemata]
   * [instance_schema_uri][google.cloud.aiplatform.v1beta1.PredictSchemata.instance_schema_uri]
   * and
   * [prediction_schema_uri][google.cloud.aiplatform.v1beta1.PredictSchemata.prediction_schema_uri].
   * </pre>
   *
   * <code>
   * .google.cloud.aiplatform.v1beta1.BatchPredictionJob.OutputConfig output_config = 6 [(.google.api.field_behavior) = REQUIRED];
   * </code>
   *
   * @return The outputConfig.
   */
  @java.lang.Override
  public com.google.cloud.aiplatform.v1beta1.BatchPredictionJob.OutputConfig getOutputConfig() {
    return outputConfig_ == null
        ? com.google.cloud.aiplatform.v1beta1.BatchPredictionJob.OutputConfig.getDefaultInstance()
        : outputConfig_;
  }
  /**
   *
   *
   * <pre>
   * Required. The Configuration specifying where output predictions should
   * be written.
   * The schema of any single prediction may be specified as a concatenation
   * of [Model's][google.cloud.aiplatform.v1beta1.BatchPredictionJob.model]
   * [PredictSchemata's][google.cloud.aiplatform.v1beta1.Model.predict_schemata]
   * [instance_schema_uri][google.cloud.aiplatform.v1beta1.PredictSchemata.instance_schema_uri]
   * and
   * [prediction_schema_uri][google.cloud.aiplatform.v1beta1.PredictSchemata.prediction_schema_uri].
   * </pre>
   *
   * <code>
   * .google.cloud.aiplatform.v1beta1.BatchPredictionJob.OutputConfig output_config = 6 [(.google.api.field_behavior) = REQUIRED];
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.aiplatform.v1beta1.BatchPredictionJob.OutputConfigOrBuilder
      getOutputConfigOrBuilder() {
    return getOutputConfig();
  }

  public static final int DEDICATED_RESOURCES_FIELD_NUMBER = 7;
  private com.google.cloud.aiplatform.v1beta1.BatchDedicatedResources dedicatedResources_;
  /**
   *
   *
   * <pre>
   * The config of resources used by the Model during the batch prediction. If
   * the Model [supports][google.cloud.aiplatform.v1beta1.Model.supported_deployment_resources_types]
   * DEDICATED_RESOURCES this config may be provided (and the job will use these
   * resources), if the Model doesn't support AUTOMATIC_RESOURCES, this config
   * must be provided.
   * </pre>
   *
   * <code>.google.cloud.aiplatform.v1beta1.BatchDedicatedResources dedicated_resources = 7;</code>
   *
   * @return Whether the dedicatedResources field is set.
   */
  @java.lang.Override
  public boolean hasDedicatedResources() {
    return dedicatedResources_ != null;
  }
  /**
   *
   *
   * <pre>
   * The config of resources used by the Model during the batch prediction. If
   * the Model [supports][google.cloud.aiplatform.v1beta1.Model.supported_deployment_resources_types]
   * DEDICATED_RESOURCES this config may be provided (and the job will use these
   * resources), if the Model doesn't support AUTOMATIC_RESOURCES, this config
   * must be provided.
   * </pre>
   *
   * <code>.google.cloud.aiplatform.v1beta1.BatchDedicatedResources dedicated_resources = 7;</code>
   *
   * @return The dedicatedResources.
   */
  @java.lang.Override
  public com.google.cloud.aiplatform.v1beta1.BatchDedicatedResources getDedicatedResources() {
    return dedicatedResources_ == null
        ? com.google.cloud.aiplatform.v1beta1.BatchDedicatedResources.getDefaultInstance()
        : dedicatedResources_;
  }
  /**
   *
   *
   * <pre>
   * The config of resources used by the Model during the batch prediction. If
   * the Model [supports][google.cloud.aiplatform.v1beta1.Model.supported_deployment_resources_types]
   * DEDICATED_RESOURCES this config may be provided (and the job will use these
   * resources), if the Model doesn't support AUTOMATIC_RESOURCES, this config
   * must be provided.
   * </pre>
   *
   * <code>.google.cloud.aiplatform.v1beta1.BatchDedicatedResources dedicated_resources = 7;</code>
   */
  @java.lang.Override
  public com.google.cloud.aiplatform.v1beta1.BatchDedicatedResourcesOrBuilder
      getDedicatedResourcesOrBuilder() {
    return getDedicatedResources();
  }

  public static final int MANUAL_BATCH_TUNING_PARAMETERS_FIELD_NUMBER = 8;
  private com.google.cloud.aiplatform.v1beta1.ManualBatchTuningParameters
      manualBatchTuningParameters_;
  /**
   *
   *
   * <pre>
   * Immutable. Parameters configuring the batch behavior. Currently only applicable when
   * [dedicated_resources][google.cloud.aiplatform.v1beta1.BatchPredictionJob.dedicated_resources] are used (in other cases Vertex AI does
   * the tuning itself).
   * </pre>
   *
   * <code>
   * .google.cloud.aiplatform.v1beta1.ManualBatchTuningParameters manual_batch_tuning_parameters = 8 [(.google.api.field_behavior) = IMMUTABLE];
   * </code>
   *
   * @return Whether the manualBatchTuningParameters field is set.
   */
  @java.lang.Override
  public boolean hasManualBatchTuningParameters() {
    return manualBatchTuningParameters_ != null;
  }
  /**
   *
   *
   * <pre>
   * Immutable. Parameters configuring the batch behavior. Currently only applicable when
   * [dedicated_resources][google.cloud.aiplatform.v1beta1.BatchPredictionJob.dedicated_resources] are used (in other cases Vertex AI does
   * the tuning itself).
   * </pre>
   *
   * <code>
   * .google.cloud.aiplatform.v1beta1.ManualBatchTuningParameters manual_batch_tuning_parameters = 8 [(.google.api.field_behavior) = IMMUTABLE];
   * </code>
   *
   * @return The manualBatchTuningParameters.
   */
  @java.lang.Override
  public com.google.cloud.aiplatform.v1beta1.ManualBatchTuningParameters
      getManualBatchTuningParameters() {
    return manualBatchTuningParameters_ == null
        ? com.google.cloud.aiplatform.v1beta1.ManualBatchTuningParameters.getDefaultInstance()
        : manualBatchTuningParameters_;
  }
  /**
   *
   *
   * <pre>
   * Immutable. Parameters configuring the batch behavior. Currently only applicable when
   * [dedicated_resources][google.cloud.aiplatform.v1beta1.BatchPredictionJob.dedicated_resources] are used (in other cases Vertex AI does
   * the tuning itself).
   * </pre>
   *
   * <code>
   * .google.cloud.aiplatform.v1beta1.ManualBatchTuningParameters manual_batch_tuning_parameters = 8 [(.google.api.field_behavior) = IMMUTABLE];
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.aiplatform.v1beta1.ManualBatchTuningParametersOrBuilder
      getManualBatchTuningParametersOrBuilder() {
    return getManualBatchTuningParameters();
  }

  public static final int GENERATE_EXPLANATION_FIELD_NUMBER = 23;
  private boolean generateExplanation_;
  /**
   *
   *
   * <pre>
   * Generate explanation with the batch prediction results.
   * When set to `true`, the batch prediction output changes based on the
   * `predictions_format` field of the
   * [BatchPredictionJob.output_config][google.cloud.aiplatform.v1beta1.BatchPredictionJob.output_config] object:
   *  * `bigquery`: output includes a column named `explanation`. The value
   *    is a struct that conforms to the [Explanation][google.cloud.aiplatform.v1beta1.Explanation] object.
   *  * `jsonl`: The JSON objects on each line include an additional entry
   *    keyed `explanation`. The value of the entry is a JSON object that
   *    conforms to the [Explanation][google.cloud.aiplatform.v1beta1.Explanation] object.
   *  * `csv`: Generating explanations for CSV format is not supported.
   * If this field is set to true, either the [Model.explanation_spec][google.cloud.aiplatform.v1beta1.Model.explanation_spec] or
   * [explanation_spec][google.cloud.aiplatform.v1beta1.BatchPredictionJob.explanation_spec] must be populated.
   * </pre>
   *
   * <code>bool generate_explanation = 23;</code>
   *
   * @return The generateExplanation.
   */
  @java.lang.Override
  public boolean getGenerateExplanation() {
    return generateExplanation_;
  }

  public static final int EXPLANATION_SPEC_FIELD_NUMBER = 25;
  private com.google.cloud.aiplatform.v1beta1.ExplanationSpec explanationSpec_;
  /**
   *
   *
   * <pre>
   * Explanation configuration for this BatchPredictionJob. Can be
   * specified only if [generate_explanation][google.cloud.aiplatform.v1beta1.BatchPredictionJob.generate_explanation] is set to `true`.
   * This value overrides the value of [Model.explanation_spec][google.cloud.aiplatform.v1beta1.Model.explanation_spec]. All fields of
   * [explanation_spec][google.cloud.aiplatform.v1beta1.BatchPredictionJob.explanation_spec] are optional in the request. If a field of the
   * [explanation_spec][google.cloud.aiplatform.v1beta1.BatchPredictionJob.explanation_spec] object is not populated, the corresponding field of
   * the [Model.explanation_spec][google.cloud.aiplatform.v1beta1.Model.explanation_spec] object is inherited.
   * </pre>
   *
   * <code>.google.cloud.aiplatform.v1beta1.ExplanationSpec explanation_spec = 25;</code>
   *
   * @return Whether the explanationSpec field is set.
   */
  @java.lang.Override
  public boolean hasExplanationSpec() {
    return explanationSpec_ != null;
  }
  /**
   *
   *
   * <pre>
   * Explanation configuration for this BatchPredictionJob. Can be
   * specified only if [generate_explanation][google.cloud.aiplatform.v1beta1.BatchPredictionJob.generate_explanation] is set to `true`.
   * This value overrides the value of [Model.explanation_spec][google.cloud.aiplatform.v1beta1.Model.explanation_spec]. All fields of
   * [explanation_spec][google.cloud.aiplatform.v1beta1.BatchPredictionJob.explanation_spec] are optional in the request. If a field of the
   * [explanation_spec][google.cloud.aiplatform.v1beta1.BatchPredictionJob.explanation_spec] object is not populated, the corresponding field of
   * the [Model.explanation_spec][google.cloud.aiplatform.v1beta1.Model.explanation_spec] object is inherited.
   * </pre>
   *
   * <code>.google.cloud.aiplatform.v1beta1.ExplanationSpec explanation_spec = 25;</code>
   *
   * @return The explanationSpec.
   */
  @java.lang.Override
  public com.google.cloud.aiplatform.v1beta1.ExplanationSpec getExplanationSpec() {
    return explanationSpec_ == null
        ? com.google.cloud.aiplatform.v1beta1.ExplanationSpec.getDefaultInstance()
        : explanationSpec_;
  }
  /**
   *
   *
   * <pre>
   * Explanation configuration for this BatchPredictionJob. Can be
   * specified only if [generate_explanation][google.cloud.aiplatform.v1beta1.BatchPredictionJob.generate_explanation] is set to `true`.
   * This value overrides the value of [Model.explanation_spec][google.cloud.aiplatform.v1beta1.Model.explanation_spec]. All fields of
   * [explanation_spec][google.cloud.aiplatform.v1beta1.BatchPredictionJob.explanation_spec] are optional in the request. If a field of the
   * [explanation_spec][google.cloud.aiplatform.v1beta1.BatchPredictionJob.explanation_spec] object is not populated, the corresponding field of
   * the [Model.explanation_spec][google.cloud.aiplatform.v1beta1.Model.explanation_spec] object is inherited.
   * </pre>
   *
   * <code>.google.cloud.aiplatform.v1beta1.ExplanationSpec explanation_spec = 25;</code>
   */
  @java.lang.Override
  public com.google.cloud.aiplatform.v1beta1.ExplanationSpecOrBuilder
      getExplanationSpecOrBuilder() {
    return getExplanationSpec();
  }

  public static final int OUTPUT_INFO_FIELD_NUMBER = 9;
  private com.google.cloud.aiplatform.v1beta1.BatchPredictionJob.OutputInfo outputInfo_;
  /**
   *
   *
   * <pre>
   * Output only. Information further describing the output of this job.
   * </pre>
   *
   * <code>
   * .google.cloud.aiplatform.v1beta1.BatchPredictionJob.OutputInfo output_info = 9 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return Whether the outputInfo field is set.
   */
  @java.lang.Override
  public boolean hasOutputInfo() {
    return outputInfo_ != null;
  }
  /**
   *
   *
   * <pre>
   * Output only. Information further describing the output of this job.
   * </pre>
   *
   * <code>
   * .google.cloud.aiplatform.v1beta1.BatchPredictionJob.OutputInfo output_info = 9 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return The outputInfo.
   */
  @java.lang.Override
  public com.google.cloud.aiplatform.v1beta1.BatchPredictionJob.OutputInfo getOutputInfo() {
    return outputInfo_ == null
        ? com.google.cloud.aiplatform.v1beta1.BatchPredictionJob.OutputInfo.getDefaultInstance()
        : outputInfo_;
  }
  /**
   *
   *
   * <pre>
   * Output only. Information further describing the output of this job.
   * </pre>
   *
   * <code>
   * .google.cloud.aiplatform.v1beta1.BatchPredictionJob.OutputInfo output_info = 9 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.aiplatform.v1beta1.BatchPredictionJob.OutputInfoOrBuilder
      getOutputInfoOrBuilder() {
    return getOutputInfo();
  }

  public static final int STATE_FIELD_NUMBER = 10;
  private int state_;
  /**
   *
   *
   * <pre>
   * Output only. The detailed state of the job.
   * </pre>
   *
   * <code>
   * .google.cloud.aiplatform.v1beta1.JobState state = 10 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return The enum numeric value on the wire for state.
   */
  @java.lang.Override
  public int getStateValue() {
    return state_;
  }
  /**
   *
   *
   * <pre>
   * Output only. The detailed state of the job.
   * </pre>
   *
   * <code>
   * .google.cloud.aiplatform.v1beta1.JobState state = 10 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return The state.
   */
  @java.lang.Override
  public com.google.cloud.aiplatform.v1beta1.JobState getState() {
    @SuppressWarnings("deprecation")
    com.google.cloud.aiplatform.v1beta1.JobState result =
        com.google.cloud.aiplatform.v1beta1.JobState.valueOf(state_);
    return result == null ? com.google.cloud.aiplatform.v1beta1.JobState.UNRECOGNIZED : result;
  }

  public static final int ERROR_FIELD_NUMBER = 11;
  private com.google.rpc.Status error_;
  /**
   *
   *
   * <pre>
   * Output only. Only populated when the job's state is JOB_STATE_FAILED or
   * JOB_STATE_CANCELLED.
   * </pre>
   *
   * <code>.google.rpc.Status error = 11 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
   *
   * @return Whether the error field is set.
   */
  @java.lang.Override
  public boolean hasError() {
    return error_ != null;
  }
  /**
   *
   *
   * <pre>
   * Output only. Only populated when the job's state is JOB_STATE_FAILED or
   * JOB_STATE_CANCELLED.
   * </pre>
   *
   * <code>.google.rpc.Status error = 11 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
   *
   * @return The error.
   */
  @java.lang.Override
  public com.google.rpc.Status getError() {
    return error_ == null ? com.google.rpc.Status.getDefaultInstance() : error_;
  }
  /**
   *
   *
   * <pre>
   * Output only. Only populated when the job's state is JOB_STATE_FAILED or
   * JOB_STATE_CANCELLED.
   * </pre>
   *
   * <code>.google.rpc.Status error = 11 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
   */
  @java.lang.Override
  public com.google.rpc.StatusOrBuilder getErrorOrBuilder() {
    return getError();
  }

  public static final int PARTIAL_FAILURES_FIELD_NUMBER = 12;
  private java.util.List<com.google.rpc.Status> partialFailures_;
  /**
   *
   *
   * <pre>
   * Output only. Partial failures encountered.
   * For example, single files that can't be read.
   * This field never exceeds 20 entries.
   * Status details fields contain standard GCP error details.
   * </pre>
   *
   * <code>
   * repeated .google.rpc.Status partial_failures = 12 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   */
  @java.lang.Override
  public java.util.List<com.google.rpc.Status> getPartialFailuresList() {
    return partialFailures_;
  }
  /**
   *
   *
   * <pre>
   * Output only. Partial failures encountered.
   * For example, single files that can't be read.
   * This field never exceeds 20 entries.
   * Status details fields contain standard GCP error details.
   * </pre>
   *
   * <code>
   * repeated .google.rpc.Status partial_failures = 12 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   */
  @java.lang.Override
  public java.util.List<? extends com.google.rpc.StatusOrBuilder>
      getPartialFailuresOrBuilderList() {
    return partialFailures_;
  }
  /**
   *
   *
   * <pre>
   * Output only. Partial failures encountered.
   * For example, single files that can't be read.
   * This field never exceeds 20 entries.
   * Status details fields contain standard GCP error details.
   * </pre>
   *
   * <code>
   * repeated .google.rpc.Status partial_failures = 12 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   */
  @java.lang.Override
  public int getPartialFailuresCount() {
    return partialFailures_.size();
  }
  /**
   *
   *
   * <pre>
   * Output only. Partial failures encountered.
   * For example, single files that can't be read.
   * This field never exceeds 20 entries.
   * Status details fields contain standard GCP error details.
   * </pre>
   *
   * <code>
   * repeated .google.rpc.Status partial_failures = 12 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   */
  @java.lang.Override
  public com.google.rpc.Status getPartialFailures(int index) {
    return partialFailures_.get(index);
  }
  /**
   *
   *
   * <pre>
   * Output only. Partial failures encountered.
   * For example, single files that can't be read.
   * This field never exceeds 20 entries.
   * Status details fields contain standard GCP error details.
   * </pre>
   *
   * <code>
   * repeated .google.rpc.Status partial_failures = 12 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   */
  @java.lang.Override
  public com.google.rpc.StatusOrBuilder getPartialFailuresOrBuilder(int index) {
    return partialFailures_.get(index);
  }

  public static final int RESOURCES_CONSUMED_FIELD_NUMBER = 13;
  private com.google.cloud.aiplatform.v1beta1.ResourcesConsumed resourcesConsumed_;
  /**
   *
   *
   * <pre>
   * Output only. Information about resources that had been consumed by this job.
   * Provided in real time at best effort basis, as well as a final value
   * once the job completes.
   * Note: This field currently may be not populated for batch predictions that
   * use AutoML Models.
   * </pre>
   *
   * <code>
   * .google.cloud.aiplatform.v1beta1.ResourcesConsumed resources_consumed = 13 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return Whether the resourcesConsumed field is set.
   */
  @java.lang.Override
  public boolean hasResourcesConsumed() {
    return resourcesConsumed_ != null;
  }
  /**
   *
   *
   * <pre>
   * Output only. Information about resources that had been consumed by this job.
   * Provided in real time at best effort basis, as well as a final value
   * once the job completes.
   * Note: This field currently may be not populated for batch predictions that
   * use AutoML Models.
   * </pre>
   *
   * <code>
   * .google.cloud.aiplatform.v1beta1.ResourcesConsumed resources_consumed = 13 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return The resourcesConsumed.
   */
  @java.lang.Override
  public com.google.cloud.aiplatform.v1beta1.ResourcesConsumed getResourcesConsumed() {
    return resourcesConsumed_ == null
        ? com.google.cloud.aiplatform.v1beta1.ResourcesConsumed.getDefaultInstance()
        : resourcesConsumed_;
  }
  /**
   *
   *
   * <pre>
   * Output only. Information about resources that had been consumed by this job.
   * Provided in real time at best effort basis, as well as a final value
   * once the job completes.
   * Note: This field currently may be not populated for batch predictions that
   * use AutoML Models.
   * </pre>
   *
   * <code>
   * .google.cloud.aiplatform.v1beta1.ResourcesConsumed resources_consumed = 13 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.aiplatform.v1beta1.ResourcesConsumedOrBuilder
      getResourcesConsumedOrBuilder() {
    return getResourcesConsumed();
  }

  public static final int COMPLETION_STATS_FIELD_NUMBER = 14;
  private com.google.cloud.aiplatform.v1beta1.CompletionStats completionStats_;
  /**
   *
   *
   * <pre>
   * Output only. Statistics on completed and failed prediction instances.
   * </pre>
   *
   * <code>
   * .google.cloud.aiplatform.v1beta1.CompletionStats completion_stats = 14 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return Whether the completionStats field is set.
   */
  @java.lang.Override
  public boolean hasCompletionStats() {
    return completionStats_ != null;
  }
  /**
   *
   *
   * <pre>
   * Output only. Statistics on completed and failed prediction instances.
   * </pre>
   *
   * <code>
   * .google.cloud.aiplatform.v1beta1.CompletionStats completion_stats = 14 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return The completionStats.
   */
  @java.lang.Override
  public com.google.cloud.aiplatform.v1beta1.CompletionStats getCompletionStats() {
    return completionStats_ == null
        ? com.google.cloud.aiplatform.v1beta1.CompletionStats.getDefaultInstance()
        : completionStats_;
  }
  /**
   *
   *
   * <pre>
   * Output only. Statistics on completed and failed prediction instances.
   * </pre>
   *
   * <code>
   * .google.cloud.aiplatform.v1beta1.CompletionStats completion_stats = 14 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.aiplatform.v1beta1.CompletionStatsOrBuilder
      getCompletionStatsOrBuilder() {
    return getCompletionStats();
  }

  public static final int CREATE_TIME_FIELD_NUMBER = 15;
  private com.google.protobuf.Timestamp createTime_;
  /**
   *
   *
   * <pre>
   * Output only. Time when the BatchPredictionJob was created.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp create_time = 15 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return Whether the createTime field is set.
   */
  @java.lang.Override
  public boolean hasCreateTime() {
    return createTime_ != null;
  }
  /**
   *
   *
   * <pre>
   * Output only. Time when the BatchPredictionJob was created.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp create_time = 15 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return The createTime.
   */
  @java.lang.Override
  public com.google.protobuf.Timestamp getCreateTime() {
    return createTime_ == null ? com.google.protobuf.Timestamp.getDefaultInstance() : createTime_;
  }
  /**
   *
   *
   * <pre>
   * Output only. Time when the BatchPredictionJob was created.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp create_time = 15 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   */
  @java.lang.Override
  public com.google.protobuf.TimestampOrBuilder getCreateTimeOrBuilder() {
    return getCreateTime();
  }

  public static final int START_TIME_FIELD_NUMBER = 16;
  private com.google.protobuf.Timestamp startTime_;
  /**
   *
   *
   * <pre>
   * Output only. Time when the BatchPredictionJob for the first time entered the
   * `JOB_STATE_RUNNING` state.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp start_time = 16 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return Whether the startTime field is set.
   */
  @java.lang.Override
  public boolean hasStartTime() {
    return startTime_ != null;
  }
  /**
   *
   *
   * <pre>
   * Output only. Time when the BatchPredictionJob for the first time entered the
   * `JOB_STATE_RUNNING` state.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp start_time = 16 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return The startTime.
   */
  @java.lang.Override
  public com.google.protobuf.Timestamp getStartTime() {
    return startTime_ == null ? com.google.protobuf.Timestamp.getDefaultInstance() : startTime_;
  }
  /**
   *
   *
   * <pre>
   * Output only. Time when the BatchPredictionJob for the first time entered the
   * `JOB_STATE_RUNNING` state.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp start_time = 16 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   */
  @java.lang.Override
  public com.google.protobuf.TimestampOrBuilder getStartTimeOrBuilder() {
    return getStartTime();
  }

  public static final int END_TIME_FIELD_NUMBER = 17;
  private com.google.protobuf.Timestamp endTime_;
  /**
   *
   *
   * <pre>
   * Output only. Time when the BatchPredictionJob entered any of the following states:
   * `JOB_STATE_SUCCEEDED`, `JOB_STATE_FAILED`, `JOB_STATE_CANCELLED`.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp end_time = 17 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return Whether the endTime field is set.
   */
  @java.lang.Override
  public boolean hasEndTime() {
    return endTime_ != null;
  }
  /**
   *
   *
   * <pre>
   * Output only. Time when the BatchPredictionJob entered any of the following states:
   * `JOB_STATE_SUCCEEDED`, `JOB_STATE_FAILED`, `JOB_STATE_CANCELLED`.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp end_time = 17 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return The endTime.
   */
  @java.lang.Override
  public com.google.protobuf.Timestamp getEndTime() {
    return endTime_ == null ? com.google.protobuf.Timestamp.getDefaultInstance() : endTime_;
  }
  /**
   *
   *
   * <pre>
   * Output only. Time when the BatchPredictionJob entered any of the following states:
   * `JOB_STATE_SUCCEEDED`, `JOB_STATE_FAILED`, `JOB_STATE_CANCELLED`.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp end_time = 17 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   */
  @java.lang.Override
  public com.google.protobuf.TimestampOrBuilder getEndTimeOrBuilder() {
    return getEndTime();
  }

  public static final int UPDATE_TIME_FIELD_NUMBER = 18;
  private com.google.protobuf.Timestamp updateTime_;
  /**
   *
   *
   * <pre>
   * Output only. Time when the BatchPredictionJob was most recently updated.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp update_time = 18 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return Whether the updateTime field is set.
   */
  @java.lang.Override
  public boolean hasUpdateTime() {
    return updateTime_ != null;
  }
  /**
   *
   *
   * <pre>
   * Output only. Time when the BatchPredictionJob was most recently updated.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp update_time = 18 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return The updateTime.
   */
  @java.lang.Override
  public com.google.protobuf.Timestamp getUpdateTime() {
    return updateTime_ == null ? com.google.protobuf.Timestamp.getDefaultInstance() : updateTime_;
  }
  /**
   *
   *
   * <pre>
   * Output only. Time when the BatchPredictionJob was most recently updated.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp update_time = 18 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   */
  @java.lang.Override
  public com.google.protobuf.TimestampOrBuilder getUpdateTimeOrBuilder() {
    return getUpdateTime();
  }

  public static final int LABELS_FIELD_NUMBER = 19;

  private static final class LabelsDefaultEntryHolder {
    static final com.google.protobuf.MapEntry<java.lang.String, java.lang.String> defaultEntry =
        com.google.protobuf.MapEntry.<java.lang.String, java.lang.String>newDefaultInstance(
            com.google.cloud.aiplatform.v1beta1.BatchPredictionJobProto
                .internal_static_google_cloud_aiplatform_v1beta1_BatchPredictionJob_LabelsEntry_descriptor,
            com.google.protobuf.WireFormat.FieldType.STRING,
            "",
            com.google.protobuf.WireFormat.FieldType.STRING,
            "");
  }

  private com.google.protobuf.MapField<java.lang.String, java.lang.String> labels_;

  private com.google.protobuf.MapField<java.lang.String, java.lang.String> internalGetLabels() {
    if (labels_ == null) {
      return com.google.protobuf.MapField.emptyMapField(LabelsDefaultEntryHolder.defaultEntry);
    }
    return labels_;
  }

  public int getLabelsCount() {
    return internalGetLabels().getMap().size();
  }
  /**
   *
   *
   * <pre>
   * The labels with user-defined metadata to organize BatchPredictionJobs.
   * Label keys and values can be no longer than 64 characters
   * (Unicode codepoints), can only contain lowercase letters, numeric
   * characters, underscores and dashes. International characters are allowed.
   * See https://goo.gl/xmQnxf for more information and examples of labels.
   * </pre>
   *
   * <code>map&lt;string, string&gt; labels = 19;</code>
   */
  @java.lang.Override
  public boolean containsLabels(java.lang.String key) {
    if (key == null) {
      throw new java.lang.NullPointerException();
    }
    return internalGetLabels().getMap().containsKey(key);
  }
  /** Use {@link #getLabelsMap()} instead. */
  @java.lang.Override
  @java.lang.Deprecated
  public java.util.Map<java.lang.String, java.lang.String> getLabels() {
    return getLabelsMap();
  }
  /**
   *
   *
   * <pre>
   * The labels with user-defined metadata to organize BatchPredictionJobs.
   * Label keys and values can be no longer than 64 characters
   * (Unicode codepoints), can only contain lowercase letters, numeric
   * characters, underscores and dashes. International characters are allowed.
   * See https://goo.gl/xmQnxf for more information and examples of labels.
   * </pre>
   *
   * <code>map&lt;string, string&gt; labels = 19;</code>
   */
  @java.lang.Override
  public java.util.Map<java.lang.String, java.lang.String> getLabelsMap() {
    return internalGetLabels().getMap();
  }
  /**
   *
   *
   * <pre>
   * The labels with user-defined metadata to organize BatchPredictionJobs.
   * Label keys and values can be no longer than 64 characters
   * (Unicode codepoints), can only contain lowercase letters, numeric
   * characters, underscores and dashes. International characters are allowed.
   * See https://goo.gl/xmQnxf for more information and examples of labels.
   * </pre>
   *
   * <code>map&lt;string, string&gt; labels = 19;</code>
   */
  @java.lang.Override
  public java.lang.String getLabelsOrDefault(java.lang.String key, java.lang.String defaultValue) {
    if (key == null) {
      throw new java.lang.NullPointerException();
    }
    java.util.Map<java.lang.String, java.lang.String> map = internalGetLabels().getMap();
    return map.containsKey(key) ? map.get(key) : defaultValue;
  }
  /**
   *
   *
   * <pre>
   * The labels with user-defined metadata to organize BatchPredictionJobs.
   * Label keys and values can be no longer than 64 characters
   * (Unicode codepoints), can only contain lowercase letters, numeric
   * characters, underscores and dashes. International characters are allowed.
   * See https://goo.gl/xmQnxf for more information and examples of labels.
   * </pre>
   *
   * <code>map&lt;string, string&gt; labels = 19;</code>
   */
  @java.lang.Override
  public java.lang.String getLabelsOrThrow(java.lang.String key) {
    if (key == null) {
      throw new java.lang.NullPointerException();
    }
    java.util.Map<java.lang.String, java.lang.String> map = internalGetLabels().getMap();
    if (!map.containsKey(key)) {
      throw new java.lang.IllegalArgumentException();
    }
    return map.get(key);
  }

  public static final int ENCRYPTION_SPEC_FIELD_NUMBER = 24;
  private com.google.cloud.aiplatform.v1beta1.EncryptionSpec encryptionSpec_;
  /**
   *
   *
   * <pre>
   * Customer-managed encryption key options for a BatchPredictionJob. If this
   * is set, then all resources created by the BatchPredictionJob will be
   * encrypted with the provided encryption key.
   * </pre>
   *
   * <code>.google.cloud.aiplatform.v1beta1.EncryptionSpec encryption_spec = 24;</code>
   *
   * @return Whether the encryptionSpec field is set.
   */
  @java.lang.Override
  public boolean hasEncryptionSpec() {
    return encryptionSpec_ != null;
  }
  /**
   *
   *
   * <pre>
   * Customer-managed encryption key options for a BatchPredictionJob. If this
   * is set, then all resources created by the BatchPredictionJob will be
   * encrypted with the provided encryption key.
   * </pre>
   *
   * <code>.google.cloud.aiplatform.v1beta1.EncryptionSpec encryption_spec = 24;</code>
   *
   * @return The encryptionSpec.
   */
  @java.lang.Override
  public com.google.cloud.aiplatform.v1beta1.EncryptionSpec getEncryptionSpec() {
    return encryptionSpec_ == null
        ? com.google.cloud.aiplatform.v1beta1.EncryptionSpec.getDefaultInstance()
        : encryptionSpec_;
  }
  /**
   *
   *
   * <pre>
   * Customer-managed encryption key options for a BatchPredictionJob. If this
   * is set, then all resources created by the BatchPredictionJob will be
   * encrypted with the provided encryption key.
   * </pre>
   *
   * <code>.google.cloud.aiplatform.v1beta1.EncryptionSpec encryption_spec = 24;</code>
   */
  @java.lang.Override
  public com.google.cloud.aiplatform.v1beta1.EncryptionSpecOrBuilder getEncryptionSpecOrBuilder() {
    return getEncryptionSpec();
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    if (!getNameBytes().isEmpty()) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 1, name_);
    }
    if (!getDisplayNameBytes().isEmpty()) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 2, displayName_);
    }
    if (!getModelBytes().isEmpty()) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 3, model_);
    }
    if (inputConfig_ != null) {
      output.writeMessage(4, getInputConfig());
    }
    if (modelParameters_ != null) {
      output.writeMessage(5, getModelParameters());
    }
    if (outputConfig_ != null) {
      output.writeMessage(6, getOutputConfig());
    }
    if (dedicatedResources_ != null) {
      output.writeMessage(7, getDedicatedResources());
    }
    if (manualBatchTuningParameters_ != null) {
      output.writeMessage(8, getManualBatchTuningParameters());
    }
    if (outputInfo_ != null) {
      output.writeMessage(9, getOutputInfo());
    }
    if (state_ != com.google.cloud.aiplatform.v1beta1.JobState.JOB_STATE_UNSPECIFIED.getNumber()) {
      output.writeEnum(10, state_);
    }
    if (error_ != null) {
      output.writeMessage(11, getError());
    }
    for (int i = 0; i < partialFailures_.size(); i++) {
      output.writeMessage(12, partialFailures_.get(i));
    }
    if (resourcesConsumed_ != null) {
      output.writeMessage(13, getResourcesConsumed());
    }
    if (completionStats_ != null) {
      output.writeMessage(14, getCompletionStats());
    }
    if (createTime_ != null) {
      output.writeMessage(15, getCreateTime());
    }
    if (startTime_ != null) {
      output.writeMessage(16, getStartTime());
    }
    if (endTime_ != null) {
      output.writeMessage(17, getEndTime());
    }
    if (updateTime_ != null) {
      output.writeMessage(18, getUpdateTime());
    }
    com.google.protobuf.GeneratedMessageV3.serializeStringMapTo(
        output, internalGetLabels(), LabelsDefaultEntryHolder.defaultEntry, 19);
    if (generateExplanation_ != false) {
      output.writeBool(23, generateExplanation_);
    }
    if (encryptionSpec_ != null) {
      output.writeMessage(24, getEncryptionSpec());
    }
    if (explanationSpec_ != null) {
      output.writeMessage(25, getExplanationSpec());
    }
    unknownFields.writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    if (!getNameBytes().isEmpty()) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(1, name_);
    }
    if (!getDisplayNameBytes().isEmpty()) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(2, displayName_);
    }
    if (!getModelBytes().isEmpty()) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(3, model_);
    }
    if (inputConfig_ != null) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(4, getInputConfig());
    }
    if (modelParameters_ != null) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(5, getModelParameters());
    }
    if (outputConfig_ != null) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(6, getOutputConfig());
    }
    if (dedicatedResources_ != null) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(7, getDedicatedResources());
    }
    if (manualBatchTuningParameters_ != null) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(
              8, getManualBatchTuningParameters());
    }
    if (outputInfo_ != null) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(9, getOutputInfo());
    }
    if (state_ != com.google.cloud.aiplatform.v1beta1.JobState.JOB_STATE_UNSPECIFIED.getNumber()) {
      size += com.google.protobuf.CodedOutputStream.computeEnumSize(10, state_);
    }
    if (error_ != null) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(11, getError());
    }
    for (int i = 0; i < partialFailures_.size(); i++) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(12, partialFailures_.get(i));
    }
    if (resourcesConsumed_ != null) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(13, getResourcesConsumed());
    }
    if (completionStats_ != null) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(14, getCompletionStats());
    }
    if (createTime_ != null) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(15, getCreateTime());
    }
    if (startTime_ != null) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(16, getStartTime());
    }
    if (endTime_ != null) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(17, getEndTime());
    }
    if (updateTime_ != null) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(18, getUpdateTime());
    }
    for (java.util.Map.Entry<java.lang.String, java.lang.String> entry :
        internalGetLabels().getMap().entrySet()) {
      com.google.protobuf.MapEntry<java.lang.String, java.lang.String> labels__ =
          LabelsDefaultEntryHolder.defaultEntry
              .newBuilderForType()
              .setKey(entry.getKey())
              .setValue(entry.getValue())
              .build();
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(19, labels__);
    }
    if (generateExplanation_ != false) {
      size += com.google.protobuf.CodedOutputStream.computeBoolSize(23, generateExplanation_);
    }
    if (encryptionSpec_ != null) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(24, getEncryptionSpec());
    }
    if (explanationSpec_ != null) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(25, getExplanationSpec());
    }
    size += unknownFields.getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.cloud.aiplatform.v1beta1.BatchPredictionJob)) {
      return super.equals(obj);
    }
    com.google.cloud.aiplatform.v1beta1.BatchPredictionJob other =
        (com.google.cloud.aiplatform.v1beta1.BatchPredictionJob) obj;

    if (!getName().equals(other.getName())) return false;
    if (!getDisplayName().equals(other.getDisplayName())) return false;
    if (!getModel().equals(other.getModel())) return false;
    if (hasInputConfig() != other.hasInputConfig()) return false;
    if (hasInputConfig()) {
      if (!getInputConfig().equals(other.getInputConfig())) return false;
    }
    if (hasModelParameters() != other.hasModelParameters()) return false;
    if (hasModelParameters()) {
      if (!getModelParameters().equals(other.getModelParameters())) return false;
    }
    if (hasOutputConfig() != other.hasOutputConfig()) return false;
    if (hasOutputConfig()) {
      if (!getOutputConfig().equals(other.getOutputConfig())) return false;
    }
    if (hasDedicatedResources() != other.hasDedicatedResources()) return false;
    if (hasDedicatedResources()) {
      if (!getDedicatedResources().equals(other.getDedicatedResources())) return false;
    }
    if (hasManualBatchTuningParameters() != other.hasManualBatchTuningParameters()) return false;
    if (hasManualBatchTuningParameters()) {
      if (!getManualBatchTuningParameters().equals(other.getManualBatchTuningParameters()))
        return false;
    }
    if (getGenerateExplanation() != other.getGenerateExplanation()) return false;
    if (hasExplanationSpec() != other.hasExplanationSpec()) return false;
    if (hasExplanationSpec()) {
      if (!getExplanationSpec().equals(other.getExplanationSpec())) return false;
    }
    if (hasOutputInfo() != other.hasOutputInfo()) return false;
    if (hasOutputInfo()) {
      if (!getOutputInfo().equals(other.getOutputInfo())) return false;
    }
    if (state_ != other.state_) return false;
    if (hasError() != other.hasError()) return false;
    if (hasError()) {
      if (!getError().equals(other.getError())) return false;
    }
    if (!getPartialFailuresList().equals(other.getPartialFailuresList())) return false;
    if (hasResourcesConsumed() != other.hasResourcesConsumed()) return false;
    if (hasResourcesConsumed()) {
      if (!getResourcesConsumed().equals(other.getResourcesConsumed())) return false;
    }
    if (hasCompletionStats() != other.hasCompletionStats()) return false;
    if (hasCompletionStats()) {
      if (!getCompletionStats().equals(other.getCompletionStats())) return false;
    }
    if (hasCreateTime() != other.hasCreateTime()) return false;
    if (hasCreateTime()) {
      if (!getCreateTime().equals(other.getCreateTime())) return false;
    }
    if (hasStartTime() != other.hasStartTime()) return false;
    if (hasStartTime()) {
      if (!getStartTime().equals(other.getStartTime())) return false;
    }
    if (hasEndTime() != other.hasEndTime()) return false;
    if (hasEndTime()) {
      if (!getEndTime().equals(other.getEndTime())) return false;
    }
    if (hasUpdateTime() != other.hasUpdateTime()) return false;
    if (hasUpdateTime()) {
      if (!getUpdateTime().equals(other.getUpdateTime())) return false;
    }
    if (!internalGetLabels().equals(other.internalGetLabels())) return false;
    if (hasEncryptionSpec() != other.hasEncryptionSpec()) return false;
    if (hasEncryptionSpec()) {
      if (!getEncryptionSpec().equals(other.getEncryptionSpec())) return false;
    }
    if (!unknownFields.equals(other.unknownFields)) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    hash = (37 * hash) + NAME_FIELD_NUMBER;
    hash = (53 * hash) + getName().hashCode();
    hash = (37 * hash) + DISPLAY_NAME_FIELD_NUMBER;
    hash = (53 * hash) + getDisplayName().hashCode();
    hash = (37 * hash) + MODEL_FIELD_NUMBER;
    hash = (53 * hash) + getModel().hashCode();
    if (hasInputConfig()) {
      hash = (37 * hash) + INPUT_CONFIG_FIELD_NUMBER;
      hash = (53 * hash) + getInputConfig().hashCode();
    }
    if (hasModelParameters()) {
      hash = (37 * hash) + MODEL_PARAMETERS_FIELD_NUMBER;
      hash = (53 * hash) + getModelParameters().hashCode();
    }
    if (hasOutputConfig()) {
      hash = (37 * hash) + OUTPUT_CONFIG_FIELD_NUMBER;
      hash = (53 * hash) + getOutputConfig().hashCode();
    }
    if (hasDedicatedResources()) {
      hash = (37 * hash) + DEDICATED_RESOURCES_FIELD_NUMBER;
      hash = (53 * hash) + getDedicatedResources().hashCode();
    }
    if (hasManualBatchTuningParameters()) {
      hash = (37 * hash) + MANUAL_BATCH_TUNING_PARAMETERS_FIELD_NUMBER;
      hash = (53 * hash) + getManualBatchTuningParameters().hashCode();
    }
    hash = (37 * hash) + GENERATE_EXPLANATION_FIELD_NUMBER;
    hash = (53 * hash) + com.google.protobuf.Internal.hashBoolean(getGenerateExplanation());
    if (hasExplanationSpec()) {
      hash = (37 * hash) + EXPLANATION_SPEC_FIELD_NUMBER;
      hash = (53 * hash) + getExplanationSpec().hashCode();
    }
    if (hasOutputInfo()) {
      hash = (37 * hash) + OUTPUT_INFO_FIELD_NUMBER;
      hash = (53 * hash) + getOutputInfo().hashCode();
    }
    hash = (37 * hash) + STATE_FIELD_NUMBER;
    hash = (53 * hash) + state_;
    if (hasError()) {
      hash = (37 * hash) + ERROR_FIELD_NUMBER;
      hash = (53 * hash) + getError().hashCode();
    }
    if (getPartialFailuresCount() > 0) {
      hash = (37 * hash) + PARTIAL_FAILURES_FIELD_NUMBER;
      hash = (53 * hash) + getPartialFailuresList().hashCode();
    }
    if (hasResourcesConsumed()) {
      hash = (37 * hash) + RESOURCES_CONSUMED_FIELD_NUMBER;
      hash = (53 * hash) + getResourcesConsumed().hashCode();
    }
    if (hasCompletionStats()) {
      hash = (37 * hash) + COMPLETION_STATS_FIELD_NUMBER;
      hash = (53 * hash) + getCompletionStats().hashCode();
    }
    if (hasCreateTime()) {
      hash = (37 * hash) + CREATE_TIME_FIELD_NUMBER;
      hash = (53 * hash) + getCreateTime().hashCode();
    }
    if (hasStartTime()) {
      hash = (37 * hash) + START_TIME_FIELD_NUMBER;
      hash = (53 * hash) + getStartTime().hashCode();
    }
    if (hasEndTime()) {
      hash = (37 * hash) + END_TIME_FIELD_NUMBER;
      hash = (53 * hash) + getEndTime().hashCode();
    }
    if (hasUpdateTime()) {
      hash = (37 * hash) + UPDATE_TIME_FIELD_NUMBER;
      hash = (53 * hash) + getUpdateTime().hashCode();
    }
    if (!internalGetLabels().getMap().isEmpty()) {
      hash = (37 * hash) + LABELS_FIELD_NUMBER;
      hash = (53 * hash) + internalGetLabels().hashCode();
    }
    if (hasEncryptionSpec()) {
      hash = (37 * hash) + ENCRYPTION_SPEC_FIELD_NUMBER;
      hash = (53 * hash) + getEncryptionSpec().hashCode();
    }
    hash = (29 * hash) + unknownFields.hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.cloud.aiplatform.v1beta1.BatchPredictionJob parseFrom(
      java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.aiplatform.v1beta1.BatchPredictionJob parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.aiplatform.v1beta1.BatchPredictionJob parseFrom(
      com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.aiplatform.v1beta1.BatchPredictionJob parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.aiplatform.v1beta1.BatchPredictionJob parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.aiplatform.v1beta1.BatchPredictionJob parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.aiplatform.v1beta1.BatchPredictionJob parseFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.aiplatform.v1beta1.BatchPredictionJob parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.aiplatform.v1beta1.BatchPredictionJob parseDelimitedFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.cloud.aiplatform.v1beta1.BatchPredictionJob parseDelimitedFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.aiplatform.v1beta1.BatchPredictionJob parseFrom(
      com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.aiplatform.v1beta1.BatchPredictionJob parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(
      com.google.cloud.aiplatform.v1beta1.BatchPredictionJob prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }
  /**
   *
   *
   * <pre>
   * A job that uses a [Model][google.cloud.aiplatform.v1beta1.BatchPredictionJob.model] to produce predictions
   * on multiple [input instances][google.cloud.aiplatform.v1beta1.BatchPredictionJob.input_config]. If
   * predictions for significant portion of the instances fail, the job may finish
   * without attempting predictions for all remaining instances.
   * </pre>
   *
   * Protobuf type {@code google.cloud.aiplatform.v1beta1.BatchPredictionJob}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.cloud.aiplatform.v1beta1.BatchPredictionJob)
      com.google.cloud.aiplatform.v1beta1.BatchPredictionJobOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.aiplatform.v1beta1.BatchPredictionJobProto
          .internal_static_google_cloud_aiplatform_v1beta1_BatchPredictionJob_descriptor;
    }

    @SuppressWarnings({"rawtypes"})
    protected com.google.protobuf.MapField internalGetMapField(int number) {
      switch (number) {
        case 19:
          return internalGetLabels();
        default:
          throw new RuntimeException("Invalid map field number: " + number);
      }
    }

    @SuppressWarnings({"rawtypes"})
    protected com.google.protobuf.MapField internalGetMutableMapField(int number) {
      switch (number) {
        case 19:
          return internalGetMutableLabels();
        default:
          throw new RuntimeException("Invalid map field number: " + number);
      }
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.aiplatform.v1beta1.BatchPredictionJobProto
          .internal_static_google_cloud_aiplatform_v1beta1_BatchPredictionJob_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.aiplatform.v1beta1.BatchPredictionJob.class,
              com.google.cloud.aiplatform.v1beta1.BatchPredictionJob.Builder.class);
    }

    // Construct using com.google.cloud.aiplatform.v1beta1.BatchPredictionJob.newBuilder()
    private Builder() {
      maybeForceBuilderInitialization();
    }

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
      maybeForceBuilderInitialization();
    }

    private void maybeForceBuilderInitialization() {
      if (com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders) {
        getPartialFailuresFieldBuilder();
      }
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      name_ = "";

      displayName_ = "";

      model_ = "";

      if (inputConfigBuilder_ == null) {
        inputConfig_ = null;
      } else {
        inputConfig_ = null;
        inputConfigBuilder_ = null;
      }
      if (modelParametersBuilder_ == null) {
        modelParameters_ = null;
      } else {
        modelParameters_ = null;
        modelParametersBuilder_ = null;
      }
      if (outputConfigBuilder_ == null) {
        outputConfig_ = null;
      } else {
        outputConfig_ = null;
        outputConfigBuilder_ = null;
      }
      if (dedicatedResourcesBuilder_ == null) {
        dedicatedResources_ = null;
      } else {
        dedicatedResources_ = null;
        dedicatedResourcesBuilder_ = null;
      }
      if (manualBatchTuningParametersBuilder_ == null) {
        manualBatchTuningParameters_ = null;
      } else {
        manualBatchTuningParameters_ = null;
        manualBatchTuningParametersBuilder_ = null;
      }
      generateExplanation_ = false;

      if (explanationSpecBuilder_ == null) {
        explanationSpec_ = null;
      } else {
        explanationSpec_ = null;
        explanationSpecBuilder_ = null;
      }
      if (outputInfoBuilder_ == null) {
        outputInfo_ = null;
      } else {
        outputInfo_ = null;
        outputInfoBuilder_ = null;
      }
      state_ = 0;

      if (errorBuilder_ == null) {
        error_ = null;
      } else {
        error_ = null;
        errorBuilder_ = null;
      }
      if (partialFailuresBuilder_ == null) {
        partialFailures_ = java.util.Collections.emptyList();
        bitField0_ = (bitField0_ & ~0x00000001);
      } else {
        partialFailuresBuilder_.clear();
      }
      if (resourcesConsumedBuilder_ == null) {
        resourcesConsumed_ = null;
      } else {
        resourcesConsumed_ = null;
        resourcesConsumedBuilder_ = null;
      }
      if (completionStatsBuilder_ == null) {
        completionStats_ = null;
      } else {
        completionStats_ = null;
        completionStatsBuilder_ = null;
      }
      if (createTimeBuilder_ == null) {
        createTime_ = null;
      } else {
        createTime_ = null;
        createTimeBuilder_ = null;
      }
      if (startTimeBuilder_ == null) {
        startTime_ = null;
      } else {
        startTime_ = null;
        startTimeBuilder_ = null;
      }
      if (endTimeBuilder_ == null) {
        endTime_ = null;
      } else {
        endTime_ = null;
        endTimeBuilder_ = null;
      }
      if (updateTimeBuilder_ == null) {
        updateTime_ = null;
      } else {
        updateTime_ = null;
        updateTimeBuilder_ = null;
      }
      internalGetMutableLabels().clear();
      if (encryptionSpecBuilder_ == null) {
        encryptionSpec_ = null;
      } else {
        encryptionSpec_ = null;
        encryptionSpecBuilder_ = null;
      }
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.cloud.aiplatform.v1beta1.BatchPredictionJobProto
          .internal_static_google_cloud_aiplatform_v1beta1_BatchPredictionJob_descriptor;
    }

    @java.lang.Override
    public com.google.cloud.aiplatform.v1beta1.BatchPredictionJob getDefaultInstanceForType() {
      return com.google.cloud.aiplatform.v1beta1.BatchPredictionJob.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.cloud.aiplatform.v1beta1.BatchPredictionJob build() {
      com.google.cloud.aiplatform.v1beta1.BatchPredictionJob result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.cloud.aiplatform.v1beta1.BatchPredictionJob buildPartial() {
      com.google.cloud.aiplatform.v1beta1.BatchPredictionJob result =
          new com.google.cloud.aiplatform.v1beta1.BatchPredictionJob(this);
      int from_bitField0_ = bitField0_;
      result.name_ = name_;
      result.displayName_ = displayName_;
      result.model_ = model_;
      if (inputConfigBuilder_ == null) {
        result.inputConfig_ = inputConfig_;
      } else {
        result.inputConfig_ = inputConfigBuilder_.build();
      }
      if (modelParametersBuilder_ == null) {
        result.modelParameters_ = modelParameters_;
      } else {
        result.modelParameters_ = modelParametersBuilder_.build();
      }
      if (outputConfigBuilder_ == null) {
        result.outputConfig_ = outputConfig_;
      } else {
        result.outputConfig_ = outputConfigBuilder_.build();
      }
      if (dedicatedResourcesBuilder_ == null) {
        result.dedicatedResources_ = dedicatedResources_;
      } else {
        result.dedicatedResources_ = dedicatedResourcesBuilder_.build();
      }
      if (manualBatchTuningParametersBuilder_ == null) {
        result.manualBatchTuningParameters_ = manualBatchTuningParameters_;
      } else {
        result.manualBatchTuningParameters_ = manualBatchTuningParametersBuilder_.build();
      }
      result.generateExplanation_ = generateExplanation_;
      if (explanationSpecBuilder_ == null) {
        result.explanationSpec_ = explanationSpec_;
      } else {
        result.explanationSpec_ = explanationSpecBuilder_.build();
      }
      if (outputInfoBuilder_ == null) {
        result.outputInfo_ = outputInfo_;
      } else {
        result.outputInfo_ = outputInfoBuilder_.build();
      }
      result.state_ = state_;
      if (errorBuilder_ == null) {
        result.error_ = error_;
      } else {
        result.error_ = errorBuilder_.build();
      }
      if (partialFailuresBuilder_ == null) {
        if (((bitField0_ & 0x00000001) != 0)) {
          partialFailures_ = java.util.Collections.unmodifiableList(partialFailures_);
          bitField0_ = (bitField0_ & ~0x00000001);
        }
        result.partialFailures_ = partialFailures_;
      } else {
        result.partialFailures_ = partialFailuresBuilder_.build();
      }
      if (resourcesConsumedBuilder_ == null) {
        result.resourcesConsumed_ = resourcesConsumed_;
      } else {
        result.resourcesConsumed_ = resourcesConsumedBuilder_.build();
      }
      if (completionStatsBuilder_ == null) {
        result.completionStats_ = completionStats_;
      } else {
        result.completionStats_ = completionStatsBuilder_.build();
      }
      if (createTimeBuilder_ == null) {
        result.createTime_ = createTime_;
      } else {
        result.createTime_ = createTimeBuilder_.build();
      }
      if (startTimeBuilder_ == null) {
        result.startTime_ = startTime_;
      } else {
        result.startTime_ = startTimeBuilder_.build();
      }
      if (endTimeBuilder_ == null) {
        result.endTime_ = endTime_;
      } else {
        result.endTime_ = endTimeBuilder_.build();
      }
      if (updateTimeBuilder_ == null) {
        result.updateTime_ = updateTime_;
      } else {
        result.updateTime_ = updateTimeBuilder_.build();
      }
      result.labels_ = internalGetLabels();
      result.labels_.makeImmutable();
      if (encryptionSpecBuilder_ == null) {
        result.encryptionSpec_ = encryptionSpec_;
      } else {
        result.encryptionSpec_ = encryptionSpecBuilder_.build();
      }
      onBuilt();
      return result;
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.cloud.aiplatform.v1beta1.BatchPredictionJob) {
        return mergeFrom((com.google.cloud.aiplatform.v1beta1.BatchPredictionJob) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(com.google.cloud.aiplatform.v1beta1.BatchPredictionJob other) {
      if (other == com.google.cloud.aiplatform.v1beta1.BatchPredictionJob.getDefaultInstance())
        return this;
      if (!other.getName().isEmpty()) {
        name_ = other.name_;
        onChanged();
      }
      if (!other.getDisplayName().isEmpty()) {
        displayName_ = other.displayName_;
        onChanged();
      }
      if (!other.getModel().isEmpty()) {
        model_ = other.model_;
        onChanged();
      }
      if (other.hasInputConfig()) {
        mergeInputConfig(other.getInputConfig());
      }
      if (other.hasModelParameters()) {
        mergeModelParameters(other.getModelParameters());
      }
      if (other.hasOutputConfig()) {
        mergeOutputConfig(other.getOutputConfig());
      }
      if (other.hasDedicatedResources()) {
        mergeDedicatedResources(other.getDedicatedResources());
      }
      if (other.hasManualBatchTuningParameters()) {
        mergeManualBatchTuningParameters(other.getManualBatchTuningParameters());
      }
      if (other.getGenerateExplanation() != false) {
        setGenerateExplanation(other.getGenerateExplanation());
      }
      if (other.hasExplanationSpec()) {
        mergeExplanationSpec(other.getExplanationSpec());
      }
      if (other.hasOutputInfo()) {
        mergeOutputInfo(other.getOutputInfo());
      }
      if (other.state_ != 0) {
        setStateValue(other.getStateValue());
      }
      if (other.hasError()) {
        mergeError(other.getError());
      }
      if (partialFailuresBuilder_ == null) {
        if (!other.partialFailures_.isEmpty()) {
          if (partialFailures_.isEmpty()) {
            partialFailures_ = other.partialFailures_;
            bitField0_ = (bitField0_ & ~0x00000001);
          } else {
            ensurePartialFailuresIsMutable();
            partialFailures_.addAll(other.partialFailures_);
          }
          onChanged();
        }
      } else {
        if (!other.partialFailures_.isEmpty()) {
          if (partialFailuresBuilder_.isEmpty()) {
            partialFailuresBuilder_.dispose();
            partialFailuresBuilder_ = null;
            partialFailures_ = other.partialFailures_;
            bitField0_ = (bitField0_ & ~0x00000001);
            partialFailuresBuilder_ =
                com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders
                    ? getPartialFailuresFieldBuilder()
                    : null;
          } else {
            partialFailuresBuilder_.addAllMessages(other.partialFailures_);
          }
        }
      }
      if (other.hasResourcesConsumed()) {
        mergeResourcesConsumed(other.getResourcesConsumed());
      }
      if (other.hasCompletionStats()) {
        mergeCompletionStats(other.getCompletionStats());
      }
      if (other.hasCreateTime()) {
        mergeCreateTime(other.getCreateTime());
      }
      if (other.hasStartTime()) {
        mergeStartTime(other.getStartTime());
      }
      if (other.hasEndTime()) {
        mergeEndTime(other.getEndTime());
      }
      if (other.hasUpdateTime()) {
        mergeUpdateTime(other.getUpdateTime());
      }
      internalGetMutableLabels().mergeFrom(other.internalGetLabels());
      if (other.hasEncryptionSpec()) {
        mergeEncryptionSpec(other.getEncryptionSpec());
      }
      this.mergeUnknownFields(other.unknownFields);
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      com.google.cloud.aiplatform.v1beta1.BatchPredictionJob parsedMessage = null;
      try {
        parsedMessage = PARSER.parsePartialFrom(input, extensionRegistry);
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        parsedMessage =
            (com.google.cloud.aiplatform.v1beta1.BatchPredictionJob) e.getUnfinishedMessage();
        throw e.unwrapIOException();
      } finally {
        if (parsedMessage != null) {
          mergeFrom(parsedMessage);
        }
      }
      return this;
    }

    private int bitField0_;

    private java.lang.Object name_ = "";
    /**
     *
     *
     * <pre>
     * Output only. Resource name of the BatchPredictionJob.
     * </pre>
     *
     * <code>string name = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return The name.
     */
    public java.lang.String getName() {
      java.lang.Object ref = name_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        name_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. Resource name of the BatchPredictionJob.
     * </pre>
     *
     * <code>string name = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return The bytes for name.
     */
    public com.google.protobuf.ByteString getNameBytes() {
      java.lang.Object ref = name_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        name_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. Resource name of the BatchPredictionJob.
     * </pre>
     *
     * <code>string name = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @param value The name to set.
     * @return This builder for chaining.
     */
    public Builder setName(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }

      name_ = value;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Resource name of the BatchPredictionJob.
     * </pre>
     *
     * <code>string name = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearName() {

      name_ = getDefaultInstance().getName();
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Resource name of the BatchPredictionJob.
     * </pre>
     *
     * <code>string name = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @param value The bytes for name to set.
     * @return This builder for chaining.
     */
    public Builder setNameBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);

      name_ = value;
      onChanged();
      return this;
    }

    private java.lang.Object displayName_ = "";
    /**
     *
     *
     * <pre>
     * Required. The user-defined name of this BatchPredictionJob.
     * </pre>
     *
     * <code>string display_name = 2 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return The displayName.
     */
    public java.lang.String getDisplayName() {
      java.lang.Object ref = displayName_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        displayName_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Required. The user-defined name of this BatchPredictionJob.
     * </pre>
     *
     * <code>string display_name = 2 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return The bytes for displayName.
     */
    public com.google.protobuf.ByteString getDisplayNameBytes() {
      java.lang.Object ref = displayName_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        displayName_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Required. The user-defined name of this BatchPredictionJob.
     * </pre>
     *
     * <code>string display_name = 2 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @param value The displayName to set.
     * @return This builder for chaining.
     */
    public Builder setDisplayName(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }

      displayName_ = value;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. The user-defined name of this BatchPredictionJob.
     * </pre>
     *
     * <code>string display_name = 2 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearDisplayName() {

      displayName_ = getDefaultInstance().getDisplayName();
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. The user-defined name of this BatchPredictionJob.
     * </pre>
     *
     * <code>string display_name = 2 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @param value The bytes for displayName to set.
     * @return This builder for chaining.
     */
    public Builder setDisplayNameBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);

      displayName_ = value;
      onChanged();
      return this;
    }

    private java.lang.Object model_ = "";
    /**
     *
     *
     * <pre>
     * Required. The name of the Model that produces the predictions via this job,
     * must share the same ancestor Location.
     * Starting this job has no impact on any existing deployments of the Model
     * and their resources.
     * </pre>
     *
     * <code>
     * string model = 3 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @return The model.
     */
    public java.lang.String getModel() {
      java.lang.Object ref = model_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        model_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Required. The name of the Model that produces the predictions via this job,
     * must share the same ancestor Location.
     * Starting this job has no impact on any existing deployments of the Model
     * and their resources.
     * </pre>
     *
     * <code>
     * string model = 3 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @return The bytes for model.
     */
    public com.google.protobuf.ByteString getModelBytes() {
      java.lang.Object ref = model_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        model_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Required. The name of the Model that produces the predictions via this job,
     * must share the same ancestor Location.
     * Starting this job has no impact on any existing deployments of the Model
     * and their resources.
     * </pre>
     *
     * <code>
     * string model = 3 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @param value The model to set.
     * @return This builder for chaining.
     */
    public Builder setModel(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }

      model_ = value;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. The name of the Model that produces the predictions via this job,
     * must share the same ancestor Location.
     * Starting this job has no impact on any existing deployments of the Model
     * and their resources.
     * </pre>
     *
     * <code>
     * string model = 3 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @return This builder for chaining.
     */
    public Builder clearModel() {

      model_ = getDefaultInstance().getModel();
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. The name of the Model that produces the predictions via this job,
     * must share the same ancestor Location.
     * Starting this job has no impact on any existing deployments of the Model
     * and their resources.
     * </pre>
     *
     * <code>
     * string model = 3 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @param value The bytes for model to set.
     * @return This builder for chaining.
     */
    public Builder setModelBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);

      model_ = value;
      onChanged();
      return this;
    }

    private com.google.cloud.aiplatform.v1beta1.BatchPredictionJob.InputConfig inputConfig_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.aiplatform.v1beta1.BatchPredictionJob.InputConfig,
            com.google.cloud.aiplatform.v1beta1.BatchPredictionJob.InputConfig.Builder,
            com.google.cloud.aiplatform.v1beta1.BatchPredictionJob.InputConfigOrBuilder>
        inputConfigBuilder_;
    /**
     *
     *
     * <pre>
     * Required. Input configuration of the instances on which predictions are performed.
     * The schema of any single instance may be specified via
     * the [Model's][google.cloud.aiplatform.v1beta1.BatchPredictionJob.model]
     * [PredictSchemata's][google.cloud.aiplatform.v1beta1.Model.predict_schemata]
     * [instance_schema_uri][google.cloud.aiplatform.v1beta1.PredictSchemata.instance_schema_uri].
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.BatchPredictionJob.InputConfig input_config = 4 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     *
     * @return Whether the inputConfig field is set.
     */
    public boolean hasInputConfig() {
      return inputConfigBuilder_ != null || inputConfig_ != null;
    }
    /**
     *
     *
     * <pre>
     * Required. Input configuration of the instances on which predictions are performed.
     * The schema of any single instance may be specified via
     * the [Model's][google.cloud.aiplatform.v1beta1.BatchPredictionJob.model]
     * [PredictSchemata's][google.cloud.aiplatform.v1beta1.Model.predict_schemata]
     * [instance_schema_uri][google.cloud.aiplatform.v1beta1.PredictSchemata.instance_schema_uri].
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.BatchPredictionJob.InputConfig input_config = 4 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     *
     * @return The inputConfig.
     */
    public com.google.cloud.aiplatform.v1beta1.BatchPredictionJob.InputConfig getInputConfig() {
      if (inputConfigBuilder_ == null) {
        return inputConfig_ == null
            ? com.google.cloud.aiplatform.v1beta1.BatchPredictionJob.InputConfig
                .getDefaultInstance()
            : inputConfig_;
      } else {
        return inputConfigBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Required. Input configuration of the instances on which predictions are performed.
     * The schema of any single instance may be specified via
     * the [Model's][google.cloud.aiplatform.v1beta1.BatchPredictionJob.model]
     * [PredictSchemata's][google.cloud.aiplatform.v1beta1.Model.predict_schemata]
     * [instance_schema_uri][google.cloud.aiplatform.v1beta1.PredictSchemata.instance_schema_uri].
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.BatchPredictionJob.InputConfig input_config = 4 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public Builder setInputConfig(
        com.google.cloud.aiplatform.v1beta1.BatchPredictionJob.InputConfig value) {
      if (inputConfigBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        inputConfig_ = value;
        onChanged();
      } else {
        inputConfigBuilder_.setMessage(value);
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. Input configuration of the instances on which predictions are performed.
     * The schema of any single instance may be specified via
     * the [Model's][google.cloud.aiplatform.v1beta1.BatchPredictionJob.model]
     * [PredictSchemata's][google.cloud.aiplatform.v1beta1.Model.predict_schemata]
     * [instance_schema_uri][google.cloud.aiplatform.v1beta1.PredictSchemata.instance_schema_uri].
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.BatchPredictionJob.InputConfig input_config = 4 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public Builder setInputConfig(
        com.google.cloud.aiplatform.v1beta1.BatchPredictionJob.InputConfig.Builder
            builderForValue) {
      if (inputConfigBuilder_ == null) {
        inputConfig_ = builderForValue.build();
        onChanged();
      } else {
        inputConfigBuilder_.setMessage(builderForValue.build());
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. Input configuration of the instances on which predictions are performed.
     * The schema of any single instance may be specified via
     * the [Model's][google.cloud.aiplatform.v1beta1.BatchPredictionJob.model]
     * [PredictSchemata's][google.cloud.aiplatform.v1beta1.Model.predict_schemata]
     * [instance_schema_uri][google.cloud.aiplatform.v1beta1.PredictSchemata.instance_schema_uri].
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.BatchPredictionJob.InputConfig input_config = 4 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public Builder mergeInputConfig(
        com.google.cloud.aiplatform.v1beta1.BatchPredictionJob.InputConfig value) {
      if (inputConfigBuilder_ == null) {
        if (inputConfig_ != null) {
          inputConfig_ =
              com.google.cloud.aiplatform.v1beta1.BatchPredictionJob.InputConfig.newBuilder(
                      inputConfig_)
                  .mergeFrom(value)
                  .buildPartial();
        } else {
          inputConfig_ = value;
        }
        onChanged();
      } else {
        inputConfigBuilder_.mergeFrom(value);
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. Input configuration of the instances on which predictions are performed.
     * The schema of any single instance may be specified via
     * the [Model's][google.cloud.aiplatform.v1beta1.BatchPredictionJob.model]
     * [PredictSchemata's][google.cloud.aiplatform.v1beta1.Model.predict_schemata]
     * [instance_schema_uri][google.cloud.aiplatform.v1beta1.PredictSchemata.instance_schema_uri].
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.BatchPredictionJob.InputConfig input_config = 4 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public Builder clearInputConfig() {
      if (inputConfigBuilder_ == null) {
        inputConfig_ = null;
        onChanged();
      } else {
        inputConfig_ = null;
        inputConfigBuilder_ = null;
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. Input configuration of the instances on which predictions are performed.
     * The schema of any single instance may be specified via
     * the [Model's][google.cloud.aiplatform.v1beta1.BatchPredictionJob.model]
     * [PredictSchemata's][google.cloud.aiplatform.v1beta1.Model.predict_schemata]
     * [instance_schema_uri][google.cloud.aiplatform.v1beta1.PredictSchemata.instance_schema_uri].
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.BatchPredictionJob.InputConfig input_config = 4 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public com.google.cloud.aiplatform.v1beta1.BatchPredictionJob.InputConfig.Builder
        getInputConfigBuilder() {

      onChanged();
      return getInputConfigFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Required. Input configuration of the instances on which predictions are performed.
     * The schema of any single instance may be specified via
     * the [Model's][google.cloud.aiplatform.v1beta1.BatchPredictionJob.model]
     * [PredictSchemata's][google.cloud.aiplatform.v1beta1.Model.predict_schemata]
     * [instance_schema_uri][google.cloud.aiplatform.v1beta1.PredictSchemata.instance_schema_uri].
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.BatchPredictionJob.InputConfig input_config = 4 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public com.google.cloud.aiplatform.v1beta1.BatchPredictionJob.InputConfigOrBuilder
        getInputConfigOrBuilder() {
      if (inputConfigBuilder_ != null) {
        return inputConfigBuilder_.getMessageOrBuilder();
      } else {
        return inputConfig_ == null
            ? com.google.cloud.aiplatform.v1beta1.BatchPredictionJob.InputConfig
                .getDefaultInstance()
            : inputConfig_;
      }
    }
    /**
     *
     *
     * <pre>
     * Required. Input configuration of the instances on which predictions are performed.
     * The schema of any single instance may be specified via
     * the [Model's][google.cloud.aiplatform.v1beta1.BatchPredictionJob.model]
     * [PredictSchemata's][google.cloud.aiplatform.v1beta1.Model.predict_schemata]
     * [instance_schema_uri][google.cloud.aiplatform.v1beta1.PredictSchemata.instance_schema_uri].
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.BatchPredictionJob.InputConfig input_config = 4 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.aiplatform.v1beta1.BatchPredictionJob.InputConfig,
            com.google.cloud.aiplatform.v1beta1.BatchPredictionJob.InputConfig.Builder,
            com.google.cloud.aiplatform.v1beta1.BatchPredictionJob.InputConfigOrBuilder>
        getInputConfigFieldBuilder() {
      if (inputConfigBuilder_ == null) {
        inputConfigBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.aiplatform.v1beta1.BatchPredictionJob.InputConfig,
                com.google.cloud.aiplatform.v1beta1.BatchPredictionJob.InputConfig.Builder,
                com.google.cloud.aiplatform.v1beta1.BatchPredictionJob.InputConfigOrBuilder>(
                getInputConfig(), getParentForChildren(), isClean());
        inputConfig_ = null;
      }
      return inputConfigBuilder_;
    }

    private com.google.protobuf.Value modelParameters_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Value,
            com.google.protobuf.Value.Builder,
            com.google.protobuf.ValueOrBuilder>
        modelParametersBuilder_;
    /**
     *
     *
     * <pre>
     * The parameters that govern the predictions. The schema of the parameters
     * may be specified via the [Model's][google.cloud.aiplatform.v1beta1.BatchPredictionJob.model]
     * [PredictSchemata's][google.cloud.aiplatform.v1beta1.Model.predict_schemata]
     * [parameters_schema_uri][google.cloud.aiplatform.v1beta1.PredictSchemata.parameters_schema_uri].
     * </pre>
     *
     * <code>.google.protobuf.Value model_parameters = 5;</code>
     *
     * @return Whether the modelParameters field is set.
     */
    public boolean hasModelParameters() {
      return modelParametersBuilder_ != null || modelParameters_ != null;
    }
    /**
     *
     *
     * <pre>
     * The parameters that govern the predictions. The schema of the parameters
     * may be specified via the [Model's][google.cloud.aiplatform.v1beta1.BatchPredictionJob.model]
     * [PredictSchemata's][google.cloud.aiplatform.v1beta1.Model.predict_schemata]
     * [parameters_schema_uri][google.cloud.aiplatform.v1beta1.PredictSchemata.parameters_schema_uri].
     * </pre>
     *
     * <code>.google.protobuf.Value model_parameters = 5;</code>
     *
     * @return The modelParameters.
     */
    public com.google.protobuf.Value getModelParameters() {
      if (modelParametersBuilder_ == null) {
        return modelParameters_ == null
            ? com.google.protobuf.Value.getDefaultInstance()
            : modelParameters_;
      } else {
        return modelParametersBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * The parameters that govern the predictions. The schema of the parameters
     * may be specified via the [Model's][google.cloud.aiplatform.v1beta1.BatchPredictionJob.model]
     * [PredictSchemata's][google.cloud.aiplatform.v1beta1.Model.predict_schemata]
     * [parameters_schema_uri][google.cloud.aiplatform.v1beta1.PredictSchemata.parameters_schema_uri].
     * </pre>
     *
     * <code>.google.protobuf.Value model_parameters = 5;</code>
     */
    public Builder setModelParameters(com.google.protobuf.Value value) {
      if (modelParametersBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        modelParameters_ = value;
        onChanged();
      } else {
        modelParametersBuilder_.setMessage(value);
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * The parameters that govern the predictions. The schema of the parameters
     * may be specified via the [Model's][google.cloud.aiplatform.v1beta1.BatchPredictionJob.model]
     * [PredictSchemata's][google.cloud.aiplatform.v1beta1.Model.predict_schemata]
     * [parameters_schema_uri][google.cloud.aiplatform.v1beta1.PredictSchemata.parameters_schema_uri].
     * </pre>
     *
     * <code>.google.protobuf.Value model_parameters = 5;</code>
     */
    public Builder setModelParameters(com.google.protobuf.Value.Builder builderForValue) {
      if (modelParametersBuilder_ == null) {
        modelParameters_ = builderForValue.build();
        onChanged();
      } else {
        modelParametersBuilder_.setMessage(builderForValue.build());
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * The parameters that govern the predictions. The schema of the parameters
     * may be specified via the [Model's][google.cloud.aiplatform.v1beta1.BatchPredictionJob.model]
     * [PredictSchemata's][google.cloud.aiplatform.v1beta1.Model.predict_schemata]
     * [parameters_schema_uri][google.cloud.aiplatform.v1beta1.PredictSchemata.parameters_schema_uri].
     * </pre>
     *
     * <code>.google.protobuf.Value model_parameters = 5;</code>
     */
    public Builder mergeModelParameters(com.google.protobuf.Value value) {
      if (modelParametersBuilder_ == null) {
        if (modelParameters_ != null) {
          modelParameters_ =
              com.google.protobuf.Value.newBuilder(modelParameters_)
                  .mergeFrom(value)
                  .buildPartial();
        } else {
          modelParameters_ = value;
        }
        onChanged();
      } else {
        modelParametersBuilder_.mergeFrom(value);
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * The parameters that govern the predictions. The schema of the parameters
     * may be specified via the [Model's][google.cloud.aiplatform.v1beta1.BatchPredictionJob.model]
     * [PredictSchemata's][google.cloud.aiplatform.v1beta1.Model.predict_schemata]
     * [parameters_schema_uri][google.cloud.aiplatform.v1beta1.PredictSchemata.parameters_schema_uri].
     * </pre>
     *
     * <code>.google.protobuf.Value model_parameters = 5;</code>
     */
    public Builder clearModelParameters() {
      if (modelParametersBuilder_ == null) {
        modelParameters_ = null;
        onChanged();
      } else {
        modelParameters_ = null;
        modelParametersBuilder_ = null;
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * The parameters that govern the predictions. The schema of the parameters
     * may be specified via the [Model's][google.cloud.aiplatform.v1beta1.BatchPredictionJob.model]
     * [PredictSchemata's][google.cloud.aiplatform.v1beta1.Model.predict_schemata]
     * [parameters_schema_uri][google.cloud.aiplatform.v1beta1.PredictSchemata.parameters_schema_uri].
     * </pre>
     *
     * <code>.google.protobuf.Value model_parameters = 5;</code>
     */
    public com.google.protobuf.Value.Builder getModelParametersBuilder() {

      onChanged();
      return getModelParametersFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * The parameters that govern the predictions. The schema of the parameters
     * may be specified via the [Model's][google.cloud.aiplatform.v1beta1.BatchPredictionJob.model]
     * [PredictSchemata's][google.cloud.aiplatform.v1beta1.Model.predict_schemata]
     * [parameters_schema_uri][google.cloud.aiplatform.v1beta1.PredictSchemata.parameters_schema_uri].
     * </pre>
     *
     * <code>.google.protobuf.Value model_parameters = 5;</code>
     */
    public com.google.protobuf.ValueOrBuilder getModelParametersOrBuilder() {
      if (modelParametersBuilder_ != null) {
        return modelParametersBuilder_.getMessageOrBuilder();
      } else {
        return modelParameters_ == null
            ? com.google.protobuf.Value.getDefaultInstance()
            : modelParameters_;
      }
    }
    /**
     *
     *
     * <pre>
     * The parameters that govern the predictions. The schema of the parameters
     * may be specified via the [Model's][google.cloud.aiplatform.v1beta1.BatchPredictionJob.model]
     * [PredictSchemata's][google.cloud.aiplatform.v1beta1.Model.predict_schemata]
     * [parameters_schema_uri][google.cloud.aiplatform.v1beta1.PredictSchemata.parameters_schema_uri].
     * </pre>
     *
     * <code>.google.protobuf.Value model_parameters = 5;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Value,
            com.google.protobuf.Value.Builder,
            com.google.protobuf.ValueOrBuilder>
        getModelParametersFieldBuilder() {
      if (modelParametersBuilder_ == null) {
        modelParametersBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.protobuf.Value,
                com.google.protobuf.Value.Builder,
                com.google.protobuf.ValueOrBuilder>(
                getModelParameters(), getParentForChildren(), isClean());
        modelParameters_ = null;
      }
      return modelParametersBuilder_;
    }

    private com.google.cloud.aiplatform.v1beta1.BatchPredictionJob.OutputConfig outputConfig_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.aiplatform.v1beta1.BatchPredictionJob.OutputConfig,
            com.google.cloud.aiplatform.v1beta1.BatchPredictionJob.OutputConfig.Builder,
            com.google.cloud.aiplatform.v1beta1.BatchPredictionJob.OutputConfigOrBuilder>
        outputConfigBuilder_;
    /**
     *
     *
     * <pre>
     * Required. The Configuration specifying where output predictions should
     * be written.
     * The schema of any single prediction may be specified as a concatenation
     * of [Model's][google.cloud.aiplatform.v1beta1.BatchPredictionJob.model]
     * [PredictSchemata's][google.cloud.aiplatform.v1beta1.Model.predict_schemata]
     * [instance_schema_uri][google.cloud.aiplatform.v1beta1.PredictSchemata.instance_schema_uri]
     * and
     * [prediction_schema_uri][google.cloud.aiplatform.v1beta1.PredictSchemata.prediction_schema_uri].
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.BatchPredictionJob.OutputConfig output_config = 6 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     *
     * @return Whether the outputConfig field is set.
     */
    public boolean hasOutputConfig() {
      return outputConfigBuilder_ != null || outputConfig_ != null;
    }
    /**
     *
     *
     * <pre>
     * Required. The Configuration specifying where output predictions should
     * be written.
     * The schema of any single prediction may be specified as a concatenation
     * of [Model's][google.cloud.aiplatform.v1beta1.BatchPredictionJob.model]
     * [PredictSchemata's][google.cloud.aiplatform.v1beta1.Model.predict_schemata]
     * [instance_schema_uri][google.cloud.aiplatform.v1beta1.PredictSchemata.instance_schema_uri]
     * and
     * [prediction_schema_uri][google.cloud.aiplatform.v1beta1.PredictSchemata.prediction_schema_uri].
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.BatchPredictionJob.OutputConfig output_config = 6 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     *
     * @return The outputConfig.
     */
    public com.google.cloud.aiplatform.v1beta1.BatchPredictionJob.OutputConfig getOutputConfig() {
      if (outputConfigBuilder_ == null) {
        return outputConfig_ == null
            ? com.google.cloud.aiplatform.v1beta1.BatchPredictionJob.OutputConfig
                .getDefaultInstance()
            : outputConfig_;
      } else {
        return outputConfigBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Required. The Configuration specifying where output predictions should
     * be written.
     * The schema of any single prediction may be specified as a concatenation
     * of [Model's][google.cloud.aiplatform.v1beta1.BatchPredictionJob.model]
     * [PredictSchemata's][google.cloud.aiplatform.v1beta1.Model.predict_schemata]
     * [instance_schema_uri][google.cloud.aiplatform.v1beta1.PredictSchemata.instance_schema_uri]
     * and
     * [prediction_schema_uri][google.cloud.aiplatform.v1beta1.PredictSchemata.prediction_schema_uri].
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.BatchPredictionJob.OutputConfig output_config = 6 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public Builder setOutputConfig(
        com.google.cloud.aiplatform.v1beta1.BatchPredictionJob.OutputConfig value) {
      if (outputConfigBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        outputConfig_ = value;
        onChanged();
      } else {
        outputConfigBuilder_.setMessage(value);
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. The Configuration specifying where output predictions should
     * be written.
     * The schema of any single prediction may be specified as a concatenation
     * of [Model's][google.cloud.aiplatform.v1beta1.BatchPredictionJob.model]
     * [PredictSchemata's][google.cloud.aiplatform.v1beta1.Model.predict_schemata]
     * [instance_schema_uri][google.cloud.aiplatform.v1beta1.PredictSchemata.instance_schema_uri]
     * and
     * [prediction_schema_uri][google.cloud.aiplatform.v1beta1.PredictSchemata.prediction_schema_uri].
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.BatchPredictionJob.OutputConfig output_config = 6 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public Builder setOutputConfig(
        com.google.cloud.aiplatform.v1beta1.BatchPredictionJob.OutputConfig.Builder
            builderForValue) {
      if (outputConfigBuilder_ == null) {
        outputConfig_ = builderForValue.build();
        onChanged();
      } else {
        outputConfigBuilder_.setMessage(builderForValue.build());
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. The Configuration specifying where output predictions should
     * be written.
     * The schema of any single prediction may be specified as a concatenation
     * of [Model's][google.cloud.aiplatform.v1beta1.BatchPredictionJob.model]
     * [PredictSchemata's][google.cloud.aiplatform.v1beta1.Model.predict_schemata]
     * [instance_schema_uri][google.cloud.aiplatform.v1beta1.PredictSchemata.instance_schema_uri]
     * and
     * [prediction_schema_uri][google.cloud.aiplatform.v1beta1.PredictSchemata.prediction_schema_uri].
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.BatchPredictionJob.OutputConfig output_config = 6 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public Builder mergeOutputConfig(
        com.google.cloud.aiplatform.v1beta1.BatchPredictionJob.OutputConfig value) {
      if (outputConfigBuilder_ == null) {
        if (outputConfig_ != null) {
          outputConfig_ =
              com.google.cloud.aiplatform.v1beta1.BatchPredictionJob.OutputConfig.newBuilder(
                      outputConfig_)
                  .mergeFrom(value)
                  .buildPartial();
        } else {
          outputConfig_ = value;
        }
        onChanged();
      } else {
        outputConfigBuilder_.mergeFrom(value);
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. The Configuration specifying where output predictions should
     * be written.
     * The schema of any single prediction may be specified as a concatenation
     * of [Model's][google.cloud.aiplatform.v1beta1.BatchPredictionJob.model]
     * [PredictSchemata's][google.cloud.aiplatform.v1beta1.Model.predict_schemata]
     * [instance_schema_uri][google.cloud.aiplatform.v1beta1.PredictSchemata.instance_schema_uri]
     * and
     * [prediction_schema_uri][google.cloud.aiplatform.v1beta1.PredictSchemata.prediction_schema_uri].
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.BatchPredictionJob.OutputConfig output_config = 6 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public Builder clearOutputConfig() {
      if (outputConfigBuilder_ == null) {
        outputConfig_ = null;
        onChanged();
      } else {
        outputConfig_ = null;
        outputConfigBuilder_ = null;
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. The Configuration specifying where output predictions should
     * be written.
     * The schema of any single prediction may be specified as a concatenation
     * of [Model's][google.cloud.aiplatform.v1beta1.BatchPredictionJob.model]
     * [PredictSchemata's][google.cloud.aiplatform.v1beta1.Model.predict_schemata]
     * [instance_schema_uri][google.cloud.aiplatform.v1beta1.PredictSchemata.instance_schema_uri]
     * and
     * [prediction_schema_uri][google.cloud.aiplatform.v1beta1.PredictSchemata.prediction_schema_uri].
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.BatchPredictionJob.OutputConfig output_config = 6 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public com.google.cloud.aiplatform.v1beta1.BatchPredictionJob.OutputConfig.Builder
        getOutputConfigBuilder() {

      onChanged();
      return getOutputConfigFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Required. The Configuration specifying where output predictions should
     * be written.
     * The schema of any single prediction may be specified as a concatenation
     * of [Model's][google.cloud.aiplatform.v1beta1.BatchPredictionJob.model]
     * [PredictSchemata's][google.cloud.aiplatform.v1beta1.Model.predict_schemata]
     * [instance_schema_uri][google.cloud.aiplatform.v1beta1.PredictSchemata.instance_schema_uri]
     * and
     * [prediction_schema_uri][google.cloud.aiplatform.v1beta1.PredictSchemata.prediction_schema_uri].
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.BatchPredictionJob.OutputConfig output_config = 6 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public com.google.cloud.aiplatform.v1beta1.BatchPredictionJob.OutputConfigOrBuilder
        getOutputConfigOrBuilder() {
      if (outputConfigBuilder_ != null) {
        return outputConfigBuilder_.getMessageOrBuilder();
      } else {
        return outputConfig_ == null
            ? com.google.cloud.aiplatform.v1beta1.BatchPredictionJob.OutputConfig
                .getDefaultInstance()
            : outputConfig_;
      }
    }
    /**
     *
     *
     * <pre>
     * Required. The Configuration specifying where output predictions should
     * be written.
     * The schema of any single prediction may be specified as a concatenation
     * of [Model's][google.cloud.aiplatform.v1beta1.BatchPredictionJob.model]
     * [PredictSchemata's][google.cloud.aiplatform.v1beta1.Model.predict_schemata]
     * [instance_schema_uri][google.cloud.aiplatform.v1beta1.PredictSchemata.instance_schema_uri]
     * and
     * [prediction_schema_uri][google.cloud.aiplatform.v1beta1.PredictSchemata.prediction_schema_uri].
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.BatchPredictionJob.OutputConfig output_config = 6 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.aiplatform.v1beta1.BatchPredictionJob.OutputConfig,
            com.google.cloud.aiplatform.v1beta1.BatchPredictionJob.OutputConfig.Builder,
            com.google.cloud.aiplatform.v1beta1.BatchPredictionJob.OutputConfigOrBuilder>
        getOutputConfigFieldBuilder() {
      if (outputConfigBuilder_ == null) {
        outputConfigBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.aiplatform.v1beta1.BatchPredictionJob.OutputConfig,
                com.google.cloud.aiplatform.v1beta1.BatchPredictionJob.OutputConfig.Builder,
                com.google.cloud.aiplatform.v1beta1.BatchPredictionJob.OutputConfigOrBuilder>(
                getOutputConfig(), getParentForChildren(), isClean());
        outputConfig_ = null;
      }
      return outputConfigBuilder_;
    }

    private com.google.cloud.aiplatform.v1beta1.BatchDedicatedResources dedicatedResources_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.aiplatform.v1beta1.BatchDedicatedResources,
            com.google.cloud.aiplatform.v1beta1.BatchDedicatedResources.Builder,
            com.google.cloud.aiplatform.v1beta1.BatchDedicatedResourcesOrBuilder>
        dedicatedResourcesBuilder_;
    /**
     *
     *
     * <pre>
     * The config of resources used by the Model during the batch prediction. If
     * the Model [supports][google.cloud.aiplatform.v1beta1.Model.supported_deployment_resources_types]
     * DEDICATED_RESOURCES this config may be provided (and the job will use these
     * resources), if the Model doesn't support AUTOMATIC_RESOURCES, this config
     * must be provided.
     * </pre>
     *
     * <code>.google.cloud.aiplatform.v1beta1.BatchDedicatedResources dedicated_resources = 7;
     * </code>
     *
     * @return Whether the dedicatedResources field is set.
     */
    public boolean hasDedicatedResources() {
      return dedicatedResourcesBuilder_ != null || dedicatedResources_ != null;
    }
    /**
     *
     *
     * <pre>
     * The config of resources used by the Model during the batch prediction. If
     * the Model [supports][google.cloud.aiplatform.v1beta1.Model.supported_deployment_resources_types]
     * DEDICATED_RESOURCES this config may be provided (and the job will use these
     * resources), if the Model doesn't support AUTOMATIC_RESOURCES, this config
     * must be provided.
     * </pre>
     *
     * <code>.google.cloud.aiplatform.v1beta1.BatchDedicatedResources dedicated_resources = 7;
     * </code>
     *
     * @return The dedicatedResources.
     */
    public com.google.cloud.aiplatform.v1beta1.BatchDedicatedResources getDedicatedResources() {
      if (dedicatedResourcesBuilder_ == null) {
        return dedicatedResources_ == null
            ? com.google.cloud.aiplatform.v1beta1.BatchDedicatedResources.getDefaultInstance()
            : dedicatedResources_;
      } else {
        return dedicatedResourcesBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * The config of resources used by the Model during the batch prediction. If
     * the Model [supports][google.cloud.aiplatform.v1beta1.Model.supported_deployment_resources_types]
     * DEDICATED_RESOURCES this config may be provided (and the job will use these
     * resources), if the Model doesn't support AUTOMATIC_RESOURCES, this config
     * must be provided.
     * </pre>
     *
     * <code>.google.cloud.aiplatform.v1beta1.BatchDedicatedResources dedicated_resources = 7;
     * </code>
     */
    public Builder setDedicatedResources(
        com.google.cloud.aiplatform.v1beta1.BatchDedicatedResources value) {
      if (dedicatedResourcesBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        dedicatedResources_ = value;
        onChanged();
      } else {
        dedicatedResourcesBuilder_.setMessage(value);
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * The config of resources used by the Model during the batch prediction. If
     * the Model [supports][google.cloud.aiplatform.v1beta1.Model.supported_deployment_resources_types]
     * DEDICATED_RESOURCES this config may be provided (and the job will use these
     * resources), if the Model doesn't support AUTOMATIC_RESOURCES, this config
     * must be provided.
     * </pre>
     *
     * <code>.google.cloud.aiplatform.v1beta1.BatchDedicatedResources dedicated_resources = 7;
     * </code>
     */
    public Builder setDedicatedResources(
        com.google.cloud.aiplatform.v1beta1.BatchDedicatedResources.Builder builderForValue) {
      if (dedicatedResourcesBuilder_ == null) {
        dedicatedResources_ = builderForValue.build();
        onChanged();
      } else {
        dedicatedResourcesBuilder_.setMessage(builderForValue.build());
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * The config of resources used by the Model during the batch prediction. If
     * the Model [supports][google.cloud.aiplatform.v1beta1.Model.supported_deployment_resources_types]
     * DEDICATED_RESOURCES this config may be provided (and the job will use these
     * resources), if the Model doesn't support AUTOMATIC_RESOURCES, this config
     * must be provided.
     * </pre>
     *
     * <code>.google.cloud.aiplatform.v1beta1.BatchDedicatedResources dedicated_resources = 7;
     * </code>
     */
    public Builder mergeDedicatedResources(
        com.google.cloud.aiplatform.v1beta1.BatchDedicatedResources value) {
      if (dedicatedResourcesBuilder_ == null) {
        if (dedicatedResources_ != null) {
          dedicatedResources_ =
              com.google.cloud.aiplatform.v1beta1.BatchDedicatedResources.newBuilder(
                      dedicatedResources_)
                  .mergeFrom(value)
                  .buildPartial();
        } else {
          dedicatedResources_ = value;
        }
        onChanged();
      } else {
        dedicatedResourcesBuilder_.mergeFrom(value);
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * The config of resources used by the Model during the batch prediction. If
     * the Model [supports][google.cloud.aiplatform.v1beta1.Model.supported_deployment_resources_types]
     * DEDICATED_RESOURCES this config may be provided (and the job will use these
     * resources), if the Model doesn't support AUTOMATIC_RESOURCES, this config
     * must be provided.
     * </pre>
     *
     * <code>.google.cloud.aiplatform.v1beta1.BatchDedicatedResources dedicated_resources = 7;
     * </code>
     */
    public Builder clearDedicatedResources() {
      if (dedicatedResourcesBuilder_ == null) {
        dedicatedResources_ = null;
        onChanged();
      } else {
        dedicatedResources_ = null;
        dedicatedResourcesBuilder_ = null;
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * The config of resources used by the Model during the batch prediction. If
     * the Model [supports][google.cloud.aiplatform.v1beta1.Model.supported_deployment_resources_types]
     * DEDICATED_RESOURCES this config may be provided (and the job will use these
     * resources), if the Model doesn't support AUTOMATIC_RESOURCES, this config
     * must be provided.
     * </pre>
     *
     * <code>.google.cloud.aiplatform.v1beta1.BatchDedicatedResources dedicated_resources = 7;
     * </code>
     */
    public com.google.cloud.aiplatform.v1beta1.BatchDedicatedResources.Builder
        getDedicatedResourcesBuilder() {

      onChanged();
      return getDedicatedResourcesFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * The config of resources used by the Model during the batch prediction. If
     * the Model [supports][google.cloud.aiplatform.v1beta1.Model.supported_deployment_resources_types]
     * DEDICATED_RESOURCES this config may be provided (and the job will use these
     * resources), if the Model doesn't support AUTOMATIC_RESOURCES, this config
     * must be provided.
     * </pre>
     *
     * <code>.google.cloud.aiplatform.v1beta1.BatchDedicatedResources dedicated_resources = 7;
     * </code>
     */
    public com.google.cloud.aiplatform.v1beta1.BatchDedicatedResourcesOrBuilder
        getDedicatedResourcesOrBuilder() {
      if (dedicatedResourcesBuilder_ != null) {
        return dedicatedResourcesBuilder_.getMessageOrBuilder();
      } else {
        return dedicatedResources_ == null
            ? com.google.cloud.aiplatform.v1beta1.BatchDedicatedResources.getDefaultInstance()
            : dedicatedResources_;
      }
    }
    /**
     *
     *
     * <pre>
     * The config of resources used by the Model during the batch prediction. If
     * the Model [supports][google.cloud.aiplatform.v1beta1.Model.supported_deployment_resources_types]
     * DEDICATED_RESOURCES this config may be provided (and the job will use these
     * resources), if the Model doesn't support AUTOMATIC_RESOURCES, this config
     * must be provided.
     * </pre>
     *
     * <code>.google.cloud.aiplatform.v1beta1.BatchDedicatedResources dedicated_resources = 7;
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.aiplatform.v1beta1.BatchDedicatedResources,
            com.google.cloud.aiplatform.v1beta1.BatchDedicatedResources.Builder,
            com.google.cloud.aiplatform.v1beta1.BatchDedicatedResourcesOrBuilder>
        getDedicatedResourcesFieldBuilder() {
      if (dedicatedResourcesBuilder_ == null) {
        dedicatedResourcesBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.aiplatform.v1beta1.BatchDedicatedResources,
                com.google.cloud.aiplatform.v1beta1.BatchDedicatedResources.Builder,
                com.google.cloud.aiplatform.v1beta1.BatchDedicatedResourcesOrBuilder>(
                getDedicatedResources(), getParentForChildren(), isClean());
        dedicatedResources_ = null;
      }
      return dedicatedResourcesBuilder_;
    }

    private com.google.cloud.aiplatform.v1beta1.ManualBatchTuningParameters
        manualBatchTuningParameters_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.aiplatform.v1beta1.ManualBatchTuningParameters,
            com.google.cloud.aiplatform.v1beta1.ManualBatchTuningParameters.Builder,
            com.google.cloud.aiplatform.v1beta1.ManualBatchTuningParametersOrBuilder>
        manualBatchTuningParametersBuilder_;
    /**
     *
     *
     * <pre>
     * Immutable. Parameters configuring the batch behavior. Currently only applicable when
     * [dedicated_resources][google.cloud.aiplatform.v1beta1.BatchPredictionJob.dedicated_resources] are used (in other cases Vertex AI does
     * the tuning itself).
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.ManualBatchTuningParameters manual_batch_tuning_parameters = 8 [(.google.api.field_behavior) = IMMUTABLE];
     * </code>
     *
     * @return Whether the manualBatchTuningParameters field is set.
     */
    public boolean hasManualBatchTuningParameters() {
      return manualBatchTuningParametersBuilder_ != null || manualBatchTuningParameters_ != null;
    }
    /**
     *
     *
     * <pre>
     * Immutable. Parameters configuring the batch behavior. Currently only applicable when
     * [dedicated_resources][google.cloud.aiplatform.v1beta1.BatchPredictionJob.dedicated_resources] are used (in other cases Vertex AI does
     * the tuning itself).
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.ManualBatchTuningParameters manual_batch_tuning_parameters = 8 [(.google.api.field_behavior) = IMMUTABLE];
     * </code>
     *
     * @return The manualBatchTuningParameters.
     */
    public com.google.cloud.aiplatform.v1beta1.ManualBatchTuningParameters
        getManualBatchTuningParameters() {
      if (manualBatchTuningParametersBuilder_ == null) {
        return manualBatchTuningParameters_ == null
            ? com.google.cloud.aiplatform.v1beta1.ManualBatchTuningParameters.getDefaultInstance()
            : manualBatchTuningParameters_;
      } else {
        return manualBatchTuningParametersBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Immutable. Parameters configuring the batch behavior. Currently only applicable when
     * [dedicated_resources][google.cloud.aiplatform.v1beta1.BatchPredictionJob.dedicated_resources] are used (in other cases Vertex AI does
     * the tuning itself).
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.ManualBatchTuningParameters manual_batch_tuning_parameters = 8 [(.google.api.field_behavior) = IMMUTABLE];
     * </code>
     */
    public Builder setManualBatchTuningParameters(
        com.google.cloud.aiplatform.v1beta1.ManualBatchTuningParameters value) {
      if (manualBatchTuningParametersBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        manualBatchTuningParameters_ = value;
        onChanged();
      } else {
        manualBatchTuningParametersBuilder_.setMessage(value);
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * Immutable. Parameters configuring the batch behavior. Currently only applicable when
     * [dedicated_resources][google.cloud.aiplatform.v1beta1.BatchPredictionJob.dedicated_resources] are used (in other cases Vertex AI does
     * the tuning itself).
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.ManualBatchTuningParameters manual_batch_tuning_parameters = 8 [(.google.api.field_behavior) = IMMUTABLE];
     * </code>
     */
    public Builder setManualBatchTuningParameters(
        com.google.cloud.aiplatform.v1beta1.ManualBatchTuningParameters.Builder builderForValue) {
      if (manualBatchTuningParametersBuilder_ == null) {
        manualBatchTuningParameters_ = builderForValue.build();
        onChanged();
      } else {
        manualBatchTuningParametersBuilder_.setMessage(builderForValue.build());
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * Immutable. Parameters configuring the batch behavior. Currently only applicable when
     * [dedicated_resources][google.cloud.aiplatform.v1beta1.BatchPredictionJob.dedicated_resources] are used (in other cases Vertex AI does
     * the tuning itself).
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.ManualBatchTuningParameters manual_batch_tuning_parameters = 8 [(.google.api.field_behavior) = IMMUTABLE];
     * </code>
     */
    public Builder mergeManualBatchTuningParameters(
        com.google.cloud.aiplatform.v1beta1.ManualBatchTuningParameters value) {
      if (manualBatchTuningParametersBuilder_ == null) {
        if (manualBatchTuningParameters_ != null) {
          manualBatchTuningParameters_ =
              com.google.cloud.aiplatform.v1beta1.ManualBatchTuningParameters.newBuilder(
                      manualBatchTuningParameters_)
                  .mergeFrom(value)
                  .buildPartial();
        } else {
          manualBatchTuningParameters_ = value;
        }
        onChanged();
      } else {
        manualBatchTuningParametersBuilder_.mergeFrom(value);
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * Immutable. Parameters configuring the batch behavior. Currently only applicable when
     * [dedicated_resources][google.cloud.aiplatform.v1beta1.BatchPredictionJob.dedicated_resources] are used (in other cases Vertex AI does
     * the tuning itself).
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.ManualBatchTuningParameters manual_batch_tuning_parameters = 8 [(.google.api.field_behavior) = IMMUTABLE];
     * </code>
     */
    public Builder clearManualBatchTuningParameters() {
      if (manualBatchTuningParametersBuilder_ == null) {
        manualBatchTuningParameters_ = null;
        onChanged();
      } else {
        manualBatchTuningParameters_ = null;
        manualBatchTuningParametersBuilder_ = null;
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * Immutable. Parameters configuring the batch behavior. Currently only applicable when
     * [dedicated_resources][google.cloud.aiplatform.v1beta1.BatchPredictionJob.dedicated_resources] are used (in other cases Vertex AI does
     * the tuning itself).
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.ManualBatchTuningParameters manual_batch_tuning_parameters = 8 [(.google.api.field_behavior) = IMMUTABLE];
     * </code>
     */
    public com.google.cloud.aiplatform.v1beta1.ManualBatchTuningParameters.Builder
        getManualBatchTuningParametersBuilder() {

      onChanged();
      return getManualBatchTuningParametersFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Immutable. Parameters configuring the batch behavior. Currently only applicable when
     * [dedicated_resources][google.cloud.aiplatform.v1beta1.BatchPredictionJob.dedicated_resources] are used (in other cases Vertex AI does
     * the tuning itself).
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.ManualBatchTuningParameters manual_batch_tuning_parameters = 8 [(.google.api.field_behavior) = IMMUTABLE];
     * </code>
     */
    public com.google.cloud.aiplatform.v1beta1.ManualBatchTuningParametersOrBuilder
        getManualBatchTuningParametersOrBuilder() {
      if (manualBatchTuningParametersBuilder_ != null) {
        return manualBatchTuningParametersBuilder_.getMessageOrBuilder();
      } else {
        return manualBatchTuningParameters_ == null
            ? com.google.cloud.aiplatform.v1beta1.ManualBatchTuningParameters.getDefaultInstance()
            : manualBatchTuningParameters_;
      }
    }
    /**
     *
     *
     * <pre>
     * Immutable. Parameters configuring the batch behavior. Currently only applicable when
     * [dedicated_resources][google.cloud.aiplatform.v1beta1.BatchPredictionJob.dedicated_resources] are used (in other cases Vertex AI does
     * the tuning itself).
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.ManualBatchTuningParameters manual_batch_tuning_parameters = 8 [(.google.api.field_behavior) = IMMUTABLE];
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.aiplatform.v1beta1.ManualBatchTuningParameters,
            com.google.cloud.aiplatform.v1beta1.ManualBatchTuningParameters.Builder,
            com.google.cloud.aiplatform.v1beta1.ManualBatchTuningParametersOrBuilder>
        getManualBatchTuningParametersFieldBuilder() {
      if (manualBatchTuningParametersBuilder_ == null) {
        manualBatchTuningParametersBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.aiplatform.v1beta1.ManualBatchTuningParameters,
                com.google.cloud.aiplatform.v1beta1.ManualBatchTuningParameters.Builder,
                com.google.cloud.aiplatform.v1beta1.ManualBatchTuningParametersOrBuilder>(
                getManualBatchTuningParameters(), getParentForChildren(), isClean());
        manualBatchTuningParameters_ = null;
      }
      return manualBatchTuningParametersBuilder_;
    }

    private boolean generateExplanation_;
    /**
     *
     *
     * <pre>
     * Generate explanation with the batch prediction results.
     * When set to `true`, the batch prediction output changes based on the
     * `predictions_format` field of the
     * [BatchPredictionJob.output_config][google.cloud.aiplatform.v1beta1.BatchPredictionJob.output_config] object:
     *  * `bigquery`: output includes a column named `explanation`. The value
     *    is a struct that conforms to the [Explanation][google.cloud.aiplatform.v1beta1.Explanation] object.
     *  * `jsonl`: The JSON objects on each line include an additional entry
     *    keyed `explanation`. The value of the entry is a JSON object that
     *    conforms to the [Explanation][google.cloud.aiplatform.v1beta1.Explanation] object.
     *  * `csv`: Generating explanations for CSV format is not supported.
     * If this field is set to true, either the [Model.explanation_spec][google.cloud.aiplatform.v1beta1.Model.explanation_spec] or
     * [explanation_spec][google.cloud.aiplatform.v1beta1.BatchPredictionJob.explanation_spec] must be populated.
     * </pre>
     *
     * <code>bool generate_explanation = 23;</code>
     *
     * @return The generateExplanation.
     */
    @java.lang.Override
    public boolean getGenerateExplanation() {
      return generateExplanation_;
    }
    /**
     *
     *
     * <pre>
     * Generate explanation with the batch prediction results.
     * When set to `true`, the batch prediction output changes based on the
     * `predictions_format` field of the
     * [BatchPredictionJob.output_config][google.cloud.aiplatform.v1beta1.BatchPredictionJob.output_config] object:
     *  * `bigquery`: output includes a column named `explanation`. The value
     *    is a struct that conforms to the [Explanation][google.cloud.aiplatform.v1beta1.Explanation] object.
     *  * `jsonl`: The JSON objects on each line include an additional entry
     *    keyed `explanation`. The value of the entry is a JSON object that
     *    conforms to the [Explanation][google.cloud.aiplatform.v1beta1.Explanation] object.
     *  * `csv`: Generating explanations for CSV format is not supported.
     * If this field is set to true, either the [Model.explanation_spec][google.cloud.aiplatform.v1beta1.Model.explanation_spec] or
     * [explanation_spec][google.cloud.aiplatform.v1beta1.BatchPredictionJob.explanation_spec] must be populated.
     * </pre>
     *
     * <code>bool generate_explanation = 23;</code>
     *
     * @param value The generateExplanation to set.
     * @return This builder for chaining.
     */
    public Builder setGenerateExplanation(boolean value) {

      generateExplanation_ = value;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Generate explanation with the batch prediction results.
     * When set to `true`, the batch prediction output changes based on the
     * `predictions_format` field of the
     * [BatchPredictionJob.output_config][google.cloud.aiplatform.v1beta1.BatchPredictionJob.output_config] object:
     *  * `bigquery`: output includes a column named `explanation`. The value
     *    is a struct that conforms to the [Explanation][google.cloud.aiplatform.v1beta1.Explanation] object.
     *  * `jsonl`: The JSON objects on each line include an additional entry
     *    keyed `explanation`. The value of the entry is a JSON object that
     *    conforms to the [Explanation][google.cloud.aiplatform.v1beta1.Explanation] object.
     *  * `csv`: Generating explanations for CSV format is not supported.
     * If this field is set to true, either the [Model.explanation_spec][google.cloud.aiplatform.v1beta1.Model.explanation_spec] or
     * [explanation_spec][google.cloud.aiplatform.v1beta1.BatchPredictionJob.explanation_spec] must be populated.
     * </pre>
     *
     * <code>bool generate_explanation = 23;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearGenerateExplanation() {

      generateExplanation_ = false;
      onChanged();
      return this;
    }

    private com.google.cloud.aiplatform.v1beta1.ExplanationSpec explanationSpec_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.aiplatform.v1beta1.ExplanationSpec,
            com.google.cloud.aiplatform.v1beta1.ExplanationSpec.Builder,
            com.google.cloud.aiplatform.v1beta1.ExplanationSpecOrBuilder>
        explanationSpecBuilder_;
    /**
     *
     *
     * <pre>
     * Explanation configuration for this BatchPredictionJob. Can be
     * specified only if [generate_explanation][google.cloud.aiplatform.v1beta1.BatchPredictionJob.generate_explanation] is set to `true`.
     * This value overrides the value of [Model.explanation_spec][google.cloud.aiplatform.v1beta1.Model.explanation_spec]. All fields of
     * [explanation_spec][google.cloud.aiplatform.v1beta1.BatchPredictionJob.explanation_spec] are optional in the request. If a field of the
     * [explanation_spec][google.cloud.aiplatform.v1beta1.BatchPredictionJob.explanation_spec] object is not populated, the corresponding field of
     * the [Model.explanation_spec][google.cloud.aiplatform.v1beta1.Model.explanation_spec] object is inherited.
     * </pre>
     *
     * <code>.google.cloud.aiplatform.v1beta1.ExplanationSpec explanation_spec = 25;</code>
     *
     * @return Whether the explanationSpec field is set.
     */
    public boolean hasExplanationSpec() {
      return explanationSpecBuilder_ != null || explanationSpec_ != null;
    }
    /**
     *
     *
     * <pre>
     * Explanation configuration for this BatchPredictionJob. Can be
     * specified only if [generate_explanation][google.cloud.aiplatform.v1beta1.BatchPredictionJob.generate_explanation] is set to `true`.
     * This value overrides the value of [Model.explanation_spec][google.cloud.aiplatform.v1beta1.Model.explanation_spec]. All fields of
     * [explanation_spec][google.cloud.aiplatform.v1beta1.BatchPredictionJob.explanation_spec] are optional in the request. If a field of the
     * [explanation_spec][google.cloud.aiplatform.v1beta1.BatchPredictionJob.explanation_spec] object is not populated, the corresponding field of
     * the [Model.explanation_spec][google.cloud.aiplatform.v1beta1.Model.explanation_spec] object is inherited.
     * </pre>
     *
     * <code>.google.cloud.aiplatform.v1beta1.ExplanationSpec explanation_spec = 25;</code>
     *
     * @return The explanationSpec.
     */
    public com.google.cloud.aiplatform.v1beta1.ExplanationSpec getExplanationSpec() {
      if (explanationSpecBuilder_ == null) {
        return explanationSpec_ == null
            ? com.google.cloud.aiplatform.v1beta1.ExplanationSpec.getDefaultInstance()
            : explanationSpec_;
      } else {
        return explanationSpecBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Explanation configuration for this BatchPredictionJob. Can be
     * specified only if [generate_explanation][google.cloud.aiplatform.v1beta1.BatchPredictionJob.generate_explanation] is set to `true`.
     * This value overrides the value of [Model.explanation_spec][google.cloud.aiplatform.v1beta1.Model.explanation_spec]. All fields of
     * [explanation_spec][google.cloud.aiplatform.v1beta1.BatchPredictionJob.explanation_spec] are optional in the request. If a field of the
     * [explanation_spec][google.cloud.aiplatform.v1beta1.BatchPredictionJob.explanation_spec] object is not populated, the corresponding field of
     * the [Model.explanation_spec][google.cloud.aiplatform.v1beta1.Model.explanation_spec] object is inherited.
     * </pre>
     *
     * <code>.google.cloud.aiplatform.v1beta1.ExplanationSpec explanation_spec = 25;</code>
     */
    public Builder setExplanationSpec(com.google.cloud.aiplatform.v1beta1.ExplanationSpec value) {
      if (explanationSpecBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        explanationSpec_ = value;
        onChanged();
      } else {
        explanationSpecBuilder_.setMessage(value);
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * Explanation configuration for this BatchPredictionJob. Can be
     * specified only if [generate_explanation][google.cloud.aiplatform.v1beta1.BatchPredictionJob.generate_explanation] is set to `true`.
     * This value overrides the value of [Model.explanation_spec][google.cloud.aiplatform.v1beta1.Model.explanation_spec]. All fields of
     * [explanation_spec][google.cloud.aiplatform.v1beta1.BatchPredictionJob.explanation_spec] are optional in the request. If a field of the
     * [explanation_spec][google.cloud.aiplatform.v1beta1.BatchPredictionJob.explanation_spec] object is not populated, the corresponding field of
     * the [Model.explanation_spec][google.cloud.aiplatform.v1beta1.Model.explanation_spec] object is inherited.
     * </pre>
     *
     * <code>.google.cloud.aiplatform.v1beta1.ExplanationSpec explanation_spec = 25;</code>
     */
    public Builder setExplanationSpec(
        com.google.cloud.aiplatform.v1beta1.ExplanationSpec.Builder builderForValue) {
      if (explanationSpecBuilder_ == null) {
        explanationSpec_ = builderForValue.build();
        onChanged();
      } else {
        explanationSpecBuilder_.setMessage(builderForValue.build());
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * Explanation configuration for this BatchPredictionJob. Can be
     * specified only if [generate_explanation][google.cloud.aiplatform.v1beta1.BatchPredictionJob.generate_explanation] is set to `true`.
     * This value overrides the value of [Model.explanation_spec][google.cloud.aiplatform.v1beta1.Model.explanation_spec]. All fields of
     * [explanation_spec][google.cloud.aiplatform.v1beta1.BatchPredictionJob.explanation_spec] are optional in the request. If a field of the
     * [explanation_spec][google.cloud.aiplatform.v1beta1.BatchPredictionJob.explanation_spec] object is not populated, the corresponding field of
     * the [Model.explanation_spec][google.cloud.aiplatform.v1beta1.Model.explanation_spec] object is inherited.
     * </pre>
     *
     * <code>.google.cloud.aiplatform.v1beta1.ExplanationSpec explanation_spec = 25;</code>
     */
    public Builder mergeExplanationSpec(com.google.cloud.aiplatform.v1beta1.ExplanationSpec value) {
      if (explanationSpecBuilder_ == null) {
        if (explanationSpec_ != null) {
          explanationSpec_ =
              com.google.cloud.aiplatform.v1beta1.ExplanationSpec.newBuilder(explanationSpec_)
                  .mergeFrom(value)
                  .buildPartial();
        } else {
          explanationSpec_ = value;
        }
        onChanged();
      } else {
        explanationSpecBuilder_.mergeFrom(value);
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * Explanation configuration for this BatchPredictionJob. Can be
     * specified only if [generate_explanation][google.cloud.aiplatform.v1beta1.BatchPredictionJob.generate_explanation] is set to `true`.
     * This value overrides the value of [Model.explanation_spec][google.cloud.aiplatform.v1beta1.Model.explanation_spec]. All fields of
     * [explanation_spec][google.cloud.aiplatform.v1beta1.BatchPredictionJob.explanation_spec] are optional in the request. If a field of the
     * [explanation_spec][google.cloud.aiplatform.v1beta1.BatchPredictionJob.explanation_spec] object is not populated, the corresponding field of
     * the [Model.explanation_spec][google.cloud.aiplatform.v1beta1.Model.explanation_spec] object is inherited.
     * </pre>
     *
     * <code>.google.cloud.aiplatform.v1beta1.ExplanationSpec explanation_spec = 25;</code>
     */
    public Builder clearExplanationSpec() {
      if (explanationSpecBuilder_ == null) {
        explanationSpec_ = null;
        onChanged();
      } else {
        explanationSpec_ = null;
        explanationSpecBuilder_ = null;
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * Explanation configuration for this BatchPredictionJob. Can be
     * specified only if [generate_explanation][google.cloud.aiplatform.v1beta1.BatchPredictionJob.generate_explanation] is set to `true`.
     * This value overrides the value of [Model.explanation_spec][google.cloud.aiplatform.v1beta1.Model.explanation_spec]. All fields of
     * [explanation_spec][google.cloud.aiplatform.v1beta1.BatchPredictionJob.explanation_spec] are optional in the request. If a field of the
     * [explanation_spec][google.cloud.aiplatform.v1beta1.BatchPredictionJob.explanation_spec] object is not populated, the corresponding field of
     * the [Model.explanation_spec][google.cloud.aiplatform.v1beta1.Model.explanation_spec] object is inherited.
     * </pre>
     *
     * <code>.google.cloud.aiplatform.v1beta1.ExplanationSpec explanation_spec = 25;</code>
     */
    public com.google.cloud.aiplatform.v1beta1.ExplanationSpec.Builder getExplanationSpecBuilder() {

      onChanged();
      return getExplanationSpecFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Explanation configuration for this BatchPredictionJob. Can be
     * specified only if [generate_explanation][google.cloud.aiplatform.v1beta1.BatchPredictionJob.generate_explanation] is set to `true`.
     * This value overrides the value of [Model.explanation_spec][google.cloud.aiplatform.v1beta1.Model.explanation_spec]. All fields of
     * [explanation_spec][google.cloud.aiplatform.v1beta1.BatchPredictionJob.explanation_spec] are optional in the request. If a field of the
     * [explanation_spec][google.cloud.aiplatform.v1beta1.BatchPredictionJob.explanation_spec] object is not populated, the corresponding field of
     * the [Model.explanation_spec][google.cloud.aiplatform.v1beta1.Model.explanation_spec] object is inherited.
     * </pre>
     *
     * <code>.google.cloud.aiplatform.v1beta1.ExplanationSpec explanation_spec = 25;</code>
     */
    public com.google.cloud.aiplatform.v1beta1.ExplanationSpecOrBuilder
        getExplanationSpecOrBuilder() {
      if (explanationSpecBuilder_ != null) {
        return explanationSpecBuilder_.getMessageOrBuilder();
      } else {
        return explanationSpec_ == null
            ? com.google.cloud.aiplatform.v1beta1.ExplanationSpec.getDefaultInstance()
            : explanationSpec_;
      }
    }
    /**
     *
     *
     * <pre>
     * Explanation configuration for this BatchPredictionJob. Can be
     * specified only if [generate_explanation][google.cloud.aiplatform.v1beta1.BatchPredictionJob.generate_explanation] is set to `true`.
     * This value overrides the value of [Model.explanation_spec][google.cloud.aiplatform.v1beta1.Model.explanation_spec]. All fields of
     * [explanation_spec][google.cloud.aiplatform.v1beta1.BatchPredictionJob.explanation_spec] are optional in the request. If a field of the
     * [explanation_spec][google.cloud.aiplatform.v1beta1.BatchPredictionJob.explanation_spec] object is not populated, the corresponding field of
     * the [Model.explanation_spec][google.cloud.aiplatform.v1beta1.Model.explanation_spec] object is inherited.
     * </pre>
     *
     * <code>.google.cloud.aiplatform.v1beta1.ExplanationSpec explanation_spec = 25;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.aiplatform.v1beta1.ExplanationSpec,
            com.google.cloud.aiplatform.v1beta1.ExplanationSpec.Builder,
            com.google.cloud.aiplatform.v1beta1.ExplanationSpecOrBuilder>
        getExplanationSpecFieldBuilder() {
      if (explanationSpecBuilder_ == null) {
        explanationSpecBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.aiplatform.v1beta1.ExplanationSpec,
                com.google.cloud.aiplatform.v1beta1.ExplanationSpec.Builder,
                com.google.cloud.aiplatform.v1beta1.ExplanationSpecOrBuilder>(
                getExplanationSpec(), getParentForChildren(), isClean());
        explanationSpec_ = null;
      }
      return explanationSpecBuilder_;
    }

    private com.google.cloud.aiplatform.v1beta1.BatchPredictionJob.OutputInfo outputInfo_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.aiplatform.v1beta1.BatchPredictionJob.OutputInfo,
            com.google.cloud.aiplatform.v1beta1.BatchPredictionJob.OutputInfo.Builder,
            com.google.cloud.aiplatform.v1beta1.BatchPredictionJob.OutputInfoOrBuilder>
        outputInfoBuilder_;
    /**
     *
     *
     * <pre>
     * Output only. Information further describing the output of this job.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.BatchPredictionJob.OutputInfo output_info = 9 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return Whether the outputInfo field is set.
     */
    public boolean hasOutputInfo() {
      return outputInfoBuilder_ != null || outputInfo_ != null;
    }
    /**
     *
     *
     * <pre>
     * Output only. Information further describing the output of this job.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.BatchPredictionJob.OutputInfo output_info = 9 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return The outputInfo.
     */
    public com.google.cloud.aiplatform.v1beta1.BatchPredictionJob.OutputInfo getOutputInfo() {
      if (outputInfoBuilder_ == null) {
        return outputInfo_ == null
            ? com.google.cloud.aiplatform.v1beta1.BatchPredictionJob.OutputInfo.getDefaultInstance()
            : outputInfo_;
      } else {
        return outputInfoBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. Information further describing the output of this job.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.BatchPredictionJob.OutputInfo output_info = 9 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder setOutputInfo(
        com.google.cloud.aiplatform.v1beta1.BatchPredictionJob.OutputInfo value) {
      if (outputInfoBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        outputInfo_ = value;
        onChanged();
      } else {
        outputInfoBuilder_.setMessage(value);
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Information further describing the output of this job.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.BatchPredictionJob.OutputInfo output_info = 9 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder setOutputInfo(
        com.google.cloud.aiplatform.v1beta1.BatchPredictionJob.OutputInfo.Builder builderForValue) {
      if (outputInfoBuilder_ == null) {
        outputInfo_ = builderForValue.build();
        onChanged();
      } else {
        outputInfoBuilder_.setMessage(builderForValue.build());
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Information further describing the output of this job.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.BatchPredictionJob.OutputInfo output_info = 9 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder mergeOutputInfo(
        com.google.cloud.aiplatform.v1beta1.BatchPredictionJob.OutputInfo value) {
      if (outputInfoBuilder_ == null) {
        if (outputInfo_ != null) {
          outputInfo_ =
              com.google.cloud.aiplatform.v1beta1.BatchPredictionJob.OutputInfo.newBuilder(
                      outputInfo_)
                  .mergeFrom(value)
                  .buildPartial();
        } else {
          outputInfo_ = value;
        }
        onChanged();
      } else {
        outputInfoBuilder_.mergeFrom(value);
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Information further describing the output of this job.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.BatchPredictionJob.OutputInfo output_info = 9 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder clearOutputInfo() {
      if (outputInfoBuilder_ == null) {
        outputInfo_ = null;
        onChanged();
      } else {
        outputInfo_ = null;
        outputInfoBuilder_ = null;
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Information further describing the output of this job.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.BatchPredictionJob.OutputInfo output_info = 9 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.cloud.aiplatform.v1beta1.BatchPredictionJob.OutputInfo.Builder
        getOutputInfoBuilder() {

      onChanged();
      return getOutputInfoFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Output only. Information further describing the output of this job.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.BatchPredictionJob.OutputInfo output_info = 9 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.cloud.aiplatform.v1beta1.BatchPredictionJob.OutputInfoOrBuilder
        getOutputInfoOrBuilder() {
      if (outputInfoBuilder_ != null) {
        return outputInfoBuilder_.getMessageOrBuilder();
      } else {
        return outputInfo_ == null
            ? com.google.cloud.aiplatform.v1beta1.BatchPredictionJob.OutputInfo.getDefaultInstance()
            : outputInfo_;
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. Information further describing the output of this job.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.BatchPredictionJob.OutputInfo output_info = 9 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.aiplatform.v1beta1.BatchPredictionJob.OutputInfo,
            com.google.cloud.aiplatform.v1beta1.BatchPredictionJob.OutputInfo.Builder,
            com.google.cloud.aiplatform.v1beta1.BatchPredictionJob.OutputInfoOrBuilder>
        getOutputInfoFieldBuilder() {
      if (outputInfoBuilder_ == null) {
        outputInfoBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.aiplatform.v1beta1.BatchPredictionJob.OutputInfo,
                com.google.cloud.aiplatform.v1beta1.BatchPredictionJob.OutputInfo.Builder,
                com.google.cloud.aiplatform.v1beta1.BatchPredictionJob.OutputInfoOrBuilder>(
                getOutputInfo(), getParentForChildren(), isClean());
        outputInfo_ = null;
      }
      return outputInfoBuilder_;
    }

    private int state_ = 0;
    /**
     *
     *
     * <pre>
     * Output only. The detailed state of the job.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.JobState state = 10 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return The enum numeric value on the wire for state.
     */
    @java.lang.Override
    public int getStateValue() {
      return state_;
    }
    /**
     *
     *
     * <pre>
     * Output only. The detailed state of the job.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.JobState state = 10 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @param value The enum numeric value on the wire for state to set.
     * @return This builder for chaining.
     */
    public Builder setStateValue(int value) {

      state_ = value;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The detailed state of the job.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.JobState state = 10 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return The state.
     */
    @java.lang.Override
    public com.google.cloud.aiplatform.v1beta1.JobState getState() {
      @SuppressWarnings("deprecation")
      com.google.cloud.aiplatform.v1beta1.JobState result =
          com.google.cloud.aiplatform.v1beta1.JobState.valueOf(state_);
      return result == null ? com.google.cloud.aiplatform.v1beta1.JobState.UNRECOGNIZED : result;
    }
    /**
     *
     *
     * <pre>
     * Output only. The detailed state of the job.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.JobState state = 10 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @param value The state to set.
     * @return This builder for chaining.
     */
    public Builder setState(com.google.cloud.aiplatform.v1beta1.JobState value) {
      if (value == null) {
        throw new NullPointerException();
      }

      state_ = value.getNumber();
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The detailed state of the job.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.JobState state = 10 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return This builder for chaining.
     */
    public Builder clearState() {

      state_ = 0;
      onChanged();
      return this;
    }

    private com.google.rpc.Status error_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.rpc.Status, com.google.rpc.Status.Builder, com.google.rpc.StatusOrBuilder>
        errorBuilder_;
    /**
     *
     *
     * <pre>
     * Output only. Only populated when the job's state is JOB_STATE_FAILED or
     * JOB_STATE_CANCELLED.
     * </pre>
     *
     * <code>.google.rpc.Status error = 11 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return Whether the error field is set.
     */
    public boolean hasError() {
      return errorBuilder_ != null || error_ != null;
    }
    /**
     *
     *
     * <pre>
     * Output only. Only populated when the job's state is JOB_STATE_FAILED or
     * JOB_STATE_CANCELLED.
     * </pre>
     *
     * <code>.google.rpc.Status error = 11 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return The error.
     */
    public com.google.rpc.Status getError() {
      if (errorBuilder_ == null) {
        return error_ == null ? com.google.rpc.Status.getDefaultInstance() : error_;
      } else {
        return errorBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. Only populated when the job's state is JOB_STATE_FAILED or
     * JOB_STATE_CANCELLED.
     * </pre>
     *
     * <code>.google.rpc.Status error = 11 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     */
    public Builder setError(com.google.rpc.Status value) {
      if (errorBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        error_ = value;
        onChanged();
      } else {
        errorBuilder_.setMessage(value);
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Only populated when the job's state is JOB_STATE_FAILED or
     * JOB_STATE_CANCELLED.
     * </pre>
     *
     * <code>.google.rpc.Status error = 11 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     */
    public Builder setError(com.google.rpc.Status.Builder builderForValue) {
      if (errorBuilder_ == null) {
        error_ = builderForValue.build();
        onChanged();
      } else {
        errorBuilder_.setMessage(builderForValue.build());
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Only populated when the job's state is JOB_STATE_FAILED or
     * JOB_STATE_CANCELLED.
     * </pre>
     *
     * <code>.google.rpc.Status error = 11 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     */
    public Builder mergeError(com.google.rpc.Status value) {
      if (errorBuilder_ == null) {
        if (error_ != null) {
          error_ = com.google.rpc.Status.newBuilder(error_).mergeFrom(value).buildPartial();
        } else {
          error_ = value;
        }
        onChanged();
      } else {
        errorBuilder_.mergeFrom(value);
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Only populated when the job's state is JOB_STATE_FAILED or
     * JOB_STATE_CANCELLED.
     * </pre>
     *
     * <code>.google.rpc.Status error = 11 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     */
    public Builder clearError() {
      if (errorBuilder_ == null) {
        error_ = null;
        onChanged();
      } else {
        error_ = null;
        errorBuilder_ = null;
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Only populated when the job's state is JOB_STATE_FAILED or
     * JOB_STATE_CANCELLED.
     * </pre>
     *
     * <code>.google.rpc.Status error = 11 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     */
    public com.google.rpc.Status.Builder getErrorBuilder() {

      onChanged();
      return getErrorFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Output only. Only populated when the job's state is JOB_STATE_FAILED or
     * JOB_STATE_CANCELLED.
     * </pre>
     *
     * <code>.google.rpc.Status error = 11 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     */
    public com.google.rpc.StatusOrBuilder getErrorOrBuilder() {
      if (errorBuilder_ != null) {
        return errorBuilder_.getMessageOrBuilder();
      } else {
        return error_ == null ? com.google.rpc.Status.getDefaultInstance() : error_;
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. Only populated when the job's state is JOB_STATE_FAILED or
     * JOB_STATE_CANCELLED.
     * </pre>
     *
     * <code>.google.rpc.Status error = 11 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.rpc.Status, com.google.rpc.Status.Builder, com.google.rpc.StatusOrBuilder>
        getErrorFieldBuilder() {
      if (errorBuilder_ == null) {
        errorBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.rpc.Status,
                com.google.rpc.Status.Builder,
                com.google.rpc.StatusOrBuilder>(getError(), getParentForChildren(), isClean());
        error_ = null;
      }
      return errorBuilder_;
    }

    private java.util.List<com.google.rpc.Status> partialFailures_ =
        java.util.Collections.emptyList();

    private void ensurePartialFailuresIsMutable() {
      if (!((bitField0_ & 0x00000001) != 0)) {
        partialFailures_ = new java.util.ArrayList<com.google.rpc.Status>(partialFailures_);
        bitField0_ |= 0x00000001;
      }
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.rpc.Status, com.google.rpc.Status.Builder, com.google.rpc.StatusOrBuilder>
        partialFailuresBuilder_;

    /**
     *
     *
     * <pre>
     * Output only. Partial failures encountered.
     * For example, single files that can't be read.
     * This field never exceeds 20 entries.
     * Status details fields contain standard GCP error details.
     * </pre>
     *
     * <code>
     * repeated .google.rpc.Status partial_failures = 12 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public java.util.List<com.google.rpc.Status> getPartialFailuresList() {
      if (partialFailuresBuilder_ == null) {
        return java.util.Collections.unmodifiableList(partialFailures_);
      } else {
        return partialFailuresBuilder_.getMessageList();
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. Partial failures encountered.
     * For example, single files that can't be read.
     * This field never exceeds 20 entries.
     * Status details fields contain standard GCP error details.
     * </pre>
     *
     * <code>
     * repeated .google.rpc.Status partial_failures = 12 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public int getPartialFailuresCount() {
      if (partialFailuresBuilder_ == null) {
        return partialFailures_.size();
      } else {
        return partialFailuresBuilder_.getCount();
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. Partial failures encountered.
     * For example, single files that can't be read.
     * This field never exceeds 20 entries.
     * Status details fields contain standard GCP error details.
     * </pre>
     *
     * <code>
     * repeated .google.rpc.Status partial_failures = 12 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.rpc.Status getPartialFailures(int index) {
      if (partialFailuresBuilder_ == null) {
        return partialFailures_.get(index);
      } else {
        return partialFailuresBuilder_.getMessage(index);
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. Partial failures encountered.
     * For example, single files that can't be read.
     * This field never exceeds 20 entries.
     * Status details fields contain standard GCP error details.
     * </pre>
     *
     * <code>
     * repeated .google.rpc.Status partial_failures = 12 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder setPartialFailures(int index, com.google.rpc.Status value) {
      if (partialFailuresBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensurePartialFailuresIsMutable();
        partialFailures_.set(index, value);
        onChanged();
      } else {
        partialFailuresBuilder_.setMessage(index, value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Partial failures encountered.
     * For example, single files that can't be read.
     * This field never exceeds 20 entries.
     * Status details fields contain standard GCP error details.
     * </pre>
     *
     * <code>
     * repeated .google.rpc.Status partial_failures = 12 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder setPartialFailures(int index, com.google.rpc.Status.Builder builderForValue) {
      if (partialFailuresBuilder_ == null) {
        ensurePartialFailuresIsMutable();
        partialFailures_.set(index, builderForValue.build());
        onChanged();
      } else {
        partialFailuresBuilder_.setMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Partial failures encountered.
     * For example, single files that can't be read.
     * This field never exceeds 20 entries.
     * Status details fields contain standard GCP error details.
     * </pre>
     *
     * <code>
     * repeated .google.rpc.Status partial_failures = 12 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder addPartialFailures(com.google.rpc.Status value) {
      if (partialFailuresBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensurePartialFailuresIsMutable();
        partialFailures_.add(value);
        onChanged();
      } else {
        partialFailuresBuilder_.addMessage(value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Partial failures encountered.
     * For example, single files that can't be read.
     * This field never exceeds 20 entries.
     * Status details fields contain standard GCP error details.
     * </pre>
     *
     * <code>
     * repeated .google.rpc.Status partial_failures = 12 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder addPartialFailures(int index, com.google.rpc.Status value) {
      if (partialFailuresBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensurePartialFailuresIsMutable();
        partialFailures_.add(index, value);
        onChanged();
      } else {
        partialFailuresBuilder_.addMessage(index, value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Partial failures encountered.
     * For example, single files that can't be read.
     * This field never exceeds 20 entries.
     * Status details fields contain standard GCP error details.
     * </pre>
     *
     * <code>
     * repeated .google.rpc.Status partial_failures = 12 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder addPartialFailures(com.google.rpc.Status.Builder builderForValue) {
      if (partialFailuresBuilder_ == null) {
        ensurePartialFailuresIsMutable();
        partialFailures_.add(builderForValue.build());
        onChanged();
      } else {
        partialFailuresBuilder_.addMessage(builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Partial failures encountered.
     * For example, single files that can't be read.
     * This field never exceeds 20 entries.
     * Status details fields contain standard GCP error details.
     * </pre>
     *
     * <code>
     * repeated .google.rpc.Status partial_failures = 12 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder addPartialFailures(int index, com.google.rpc.Status.Builder builderForValue) {
      if (partialFailuresBuilder_ == null) {
        ensurePartialFailuresIsMutable();
        partialFailures_.add(index, builderForValue.build());
        onChanged();
      } else {
        partialFailuresBuilder_.addMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Partial failures encountered.
     * For example, single files that can't be read.
     * This field never exceeds 20 entries.
     * Status details fields contain standard GCP error details.
     * </pre>
     *
     * <code>
     * repeated .google.rpc.Status partial_failures = 12 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder addAllPartialFailures(
        java.lang.Iterable<? extends com.google.rpc.Status> values) {
      if (partialFailuresBuilder_ == null) {
        ensurePartialFailuresIsMutable();
        com.google.protobuf.AbstractMessageLite.Builder.addAll(values, partialFailures_);
        onChanged();
      } else {
        partialFailuresBuilder_.addAllMessages(values);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Partial failures encountered.
     * For example, single files that can't be read.
     * This field never exceeds 20 entries.
     * Status details fields contain standard GCP error details.
     * </pre>
     *
     * <code>
     * repeated .google.rpc.Status partial_failures = 12 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder clearPartialFailures() {
      if (partialFailuresBuilder_ == null) {
        partialFailures_ = java.util.Collections.emptyList();
        bitField0_ = (bitField0_ & ~0x00000001);
        onChanged();
      } else {
        partialFailuresBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Partial failures encountered.
     * For example, single files that can't be read.
     * This field never exceeds 20 entries.
     * Status details fields contain standard GCP error details.
     * </pre>
     *
     * <code>
     * repeated .google.rpc.Status partial_failures = 12 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder removePartialFailures(int index) {
      if (partialFailuresBuilder_ == null) {
        ensurePartialFailuresIsMutable();
        partialFailures_.remove(index);
        onChanged();
      } else {
        partialFailuresBuilder_.remove(index);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Partial failures encountered.
     * For example, single files that can't be read.
     * This field never exceeds 20 entries.
     * Status details fields contain standard GCP error details.
     * </pre>
     *
     * <code>
     * repeated .google.rpc.Status partial_failures = 12 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.rpc.Status.Builder getPartialFailuresBuilder(int index) {
      return getPartialFailuresFieldBuilder().getBuilder(index);
    }
    /**
     *
     *
     * <pre>
     * Output only. Partial failures encountered.
     * For example, single files that can't be read.
     * This field never exceeds 20 entries.
     * Status details fields contain standard GCP error details.
     * </pre>
     *
     * <code>
     * repeated .google.rpc.Status partial_failures = 12 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.rpc.StatusOrBuilder getPartialFailuresOrBuilder(int index) {
      if (partialFailuresBuilder_ == null) {
        return partialFailures_.get(index);
      } else {
        return partialFailuresBuilder_.getMessageOrBuilder(index);
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. Partial failures encountered.
     * For example, single files that can't be read.
     * This field never exceeds 20 entries.
     * Status details fields contain standard GCP error details.
     * </pre>
     *
     * <code>
     * repeated .google.rpc.Status partial_failures = 12 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public java.util.List<? extends com.google.rpc.StatusOrBuilder>
        getPartialFailuresOrBuilderList() {
      if (partialFailuresBuilder_ != null) {
        return partialFailuresBuilder_.getMessageOrBuilderList();
      } else {
        return java.util.Collections.unmodifiableList(partialFailures_);
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. Partial failures encountered.
     * For example, single files that can't be read.
     * This field never exceeds 20 entries.
     * Status details fields contain standard GCP error details.
     * </pre>
     *
     * <code>
     * repeated .google.rpc.Status partial_failures = 12 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.rpc.Status.Builder addPartialFailuresBuilder() {
      return getPartialFailuresFieldBuilder()
          .addBuilder(com.google.rpc.Status.getDefaultInstance());
    }
    /**
     *
     *
     * <pre>
     * Output only. Partial failures encountered.
     * For example, single files that can't be read.
     * This field never exceeds 20 entries.
     * Status details fields contain standard GCP error details.
     * </pre>
     *
     * <code>
     * repeated .google.rpc.Status partial_failures = 12 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.rpc.Status.Builder addPartialFailuresBuilder(int index) {
      return getPartialFailuresFieldBuilder()
          .addBuilder(index, com.google.rpc.Status.getDefaultInstance());
    }
    /**
     *
     *
     * <pre>
     * Output only. Partial failures encountered.
     * For example, single files that can't be read.
     * This field never exceeds 20 entries.
     * Status details fields contain standard GCP error details.
     * </pre>
     *
     * <code>
     * repeated .google.rpc.Status partial_failures = 12 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public java.util.List<com.google.rpc.Status.Builder> getPartialFailuresBuilderList() {
      return getPartialFailuresFieldBuilder().getBuilderList();
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.rpc.Status, com.google.rpc.Status.Builder, com.google.rpc.StatusOrBuilder>
        getPartialFailuresFieldBuilder() {
      if (partialFailuresBuilder_ == null) {
        partialFailuresBuilder_ =
            new com.google.protobuf.RepeatedFieldBuilderV3<
                com.google.rpc.Status,
                com.google.rpc.Status.Builder,
                com.google.rpc.StatusOrBuilder>(
                partialFailures_,
                ((bitField0_ & 0x00000001) != 0),
                getParentForChildren(),
                isClean());
        partialFailures_ = null;
      }
      return partialFailuresBuilder_;
    }

    private com.google.cloud.aiplatform.v1beta1.ResourcesConsumed resourcesConsumed_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.aiplatform.v1beta1.ResourcesConsumed,
            com.google.cloud.aiplatform.v1beta1.ResourcesConsumed.Builder,
            com.google.cloud.aiplatform.v1beta1.ResourcesConsumedOrBuilder>
        resourcesConsumedBuilder_;
    /**
     *
     *
     * <pre>
     * Output only. Information about resources that had been consumed by this job.
     * Provided in real time at best effort basis, as well as a final value
     * once the job completes.
     * Note: This field currently may be not populated for batch predictions that
     * use AutoML Models.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.ResourcesConsumed resources_consumed = 13 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return Whether the resourcesConsumed field is set.
     */
    public boolean hasResourcesConsumed() {
      return resourcesConsumedBuilder_ != null || resourcesConsumed_ != null;
    }
    /**
     *
     *
     * <pre>
     * Output only. Information about resources that had been consumed by this job.
     * Provided in real time at best effort basis, as well as a final value
     * once the job completes.
     * Note: This field currently may be not populated for batch predictions that
     * use AutoML Models.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.ResourcesConsumed resources_consumed = 13 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return The resourcesConsumed.
     */
    public com.google.cloud.aiplatform.v1beta1.ResourcesConsumed getResourcesConsumed() {
      if (resourcesConsumedBuilder_ == null) {
        return resourcesConsumed_ == null
            ? com.google.cloud.aiplatform.v1beta1.ResourcesConsumed.getDefaultInstance()
            : resourcesConsumed_;
      } else {
        return resourcesConsumedBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. Information about resources that had been consumed by this job.
     * Provided in real time at best effort basis, as well as a final value
     * once the job completes.
     * Note: This field currently may be not populated for batch predictions that
     * use AutoML Models.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.ResourcesConsumed resources_consumed = 13 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder setResourcesConsumed(
        com.google.cloud.aiplatform.v1beta1.ResourcesConsumed value) {
      if (resourcesConsumedBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        resourcesConsumed_ = value;
        onChanged();
      } else {
        resourcesConsumedBuilder_.setMessage(value);
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Information about resources that had been consumed by this job.
     * Provided in real time at best effort basis, as well as a final value
     * once the job completes.
     * Note: This field currently may be not populated for batch predictions that
     * use AutoML Models.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.ResourcesConsumed resources_consumed = 13 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder setResourcesConsumed(
        com.google.cloud.aiplatform.v1beta1.ResourcesConsumed.Builder builderForValue) {
      if (resourcesConsumedBuilder_ == null) {
        resourcesConsumed_ = builderForValue.build();
        onChanged();
      } else {
        resourcesConsumedBuilder_.setMessage(builderForValue.build());
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Information about resources that had been consumed by this job.
     * Provided in real time at best effort basis, as well as a final value
     * once the job completes.
     * Note: This field currently may be not populated for batch predictions that
     * use AutoML Models.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.ResourcesConsumed resources_consumed = 13 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder mergeResourcesConsumed(
        com.google.cloud.aiplatform.v1beta1.ResourcesConsumed value) {
      if (resourcesConsumedBuilder_ == null) {
        if (resourcesConsumed_ != null) {
          resourcesConsumed_ =
              com.google.cloud.aiplatform.v1beta1.ResourcesConsumed.newBuilder(resourcesConsumed_)
                  .mergeFrom(value)
                  .buildPartial();
        } else {
          resourcesConsumed_ = value;
        }
        onChanged();
      } else {
        resourcesConsumedBuilder_.mergeFrom(value);
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Information about resources that had been consumed by this job.
     * Provided in real time at best effort basis, as well as a final value
     * once the job completes.
     * Note: This field currently may be not populated for batch predictions that
     * use AutoML Models.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.ResourcesConsumed resources_consumed = 13 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder clearResourcesConsumed() {
      if (resourcesConsumedBuilder_ == null) {
        resourcesConsumed_ = null;
        onChanged();
      } else {
        resourcesConsumed_ = null;
        resourcesConsumedBuilder_ = null;
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Information about resources that had been consumed by this job.
     * Provided in real time at best effort basis, as well as a final value
     * once the job completes.
     * Note: This field currently may be not populated for batch predictions that
     * use AutoML Models.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.ResourcesConsumed resources_consumed = 13 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.cloud.aiplatform.v1beta1.ResourcesConsumed.Builder
        getResourcesConsumedBuilder() {

      onChanged();
      return getResourcesConsumedFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Output only. Information about resources that had been consumed by this job.
     * Provided in real time at best effort basis, as well as a final value
     * once the job completes.
     * Note: This field currently may be not populated for batch predictions that
     * use AutoML Models.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.ResourcesConsumed resources_consumed = 13 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.cloud.aiplatform.v1beta1.ResourcesConsumedOrBuilder
        getResourcesConsumedOrBuilder() {
      if (resourcesConsumedBuilder_ != null) {
        return resourcesConsumedBuilder_.getMessageOrBuilder();
      } else {
        return resourcesConsumed_ == null
            ? com.google.cloud.aiplatform.v1beta1.ResourcesConsumed.getDefaultInstance()
            : resourcesConsumed_;
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. Information about resources that had been consumed by this job.
     * Provided in real time at best effort basis, as well as a final value
     * once the job completes.
     * Note: This field currently may be not populated for batch predictions that
     * use AutoML Models.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.ResourcesConsumed resources_consumed = 13 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.aiplatform.v1beta1.ResourcesConsumed,
            com.google.cloud.aiplatform.v1beta1.ResourcesConsumed.Builder,
            com.google.cloud.aiplatform.v1beta1.ResourcesConsumedOrBuilder>
        getResourcesConsumedFieldBuilder() {
      if (resourcesConsumedBuilder_ == null) {
        resourcesConsumedBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.aiplatform.v1beta1.ResourcesConsumed,
                com.google.cloud.aiplatform.v1beta1.ResourcesConsumed.Builder,
                com.google.cloud.aiplatform.v1beta1.ResourcesConsumedOrBuilder>(
                getResourcesConsumed(), getParentForChildren(), isClean());
        resourcesConsumed_ = null;
      }
      return resourcesConsumedBuilder_;
    }

    private com.google.cloud.aiplatform.v1beta1.CompletionStats completionStats_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.aiplatform.v1beta1.CompletionStats,
            com.google.cloud.aiplatform.v1beta1.CompletionStats.Builder,
            com.google.cloud.aiplatform.v1beta1.CompletionStatsOrBuilder>
        completionStatsBuilder_;
    /**
     *
     *
     * <pre>
     * Output only. Statistics on completed and failed prediction instances.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.CompletionStats completion_stats = 14 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return Whether the completionStats field is set.
     */
    public boolean hasCompletionStats() {
      return completionStatsBuilder_ != null || completionStats_ != null;
    }
    /**
     *
     *
     * <pre>
     * Output only. Statistics on completed and failed prediction instances.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.CompletionStats completion_stats = 14 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return The completionStats.
     */
    public com.google.cloud.aiplatform.v1beta1.CompletionStats getCompletionStats() {
      if (completionStatsBuilder_ == null) {
        return completionStats_ == null
            ? com.google.cloud.aiplatform.v1beta1.CompletionStats.getDefaultInstance()
            : completionStats_;
      } else {
        return completionStatsBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. Statistics on completed and failed prediction instances.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.CompletionStats completion_stats = 14 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder setCompletionStats(com.google.cloud.aiplatform.v1beta1.CompletionStats value) {
      if (completionStatsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        completionStats_ = value;
        onChanged();
      } else {
        completionStatsBuilder_.setMessage(value);
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Statistics on completed and failed prediction instances.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.CompletionStats completion_stats = 14 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder setCompletionStats(
        com.google.cloud.aiplatform.v1beta1.CompletionStats.Builder builderForValue) {
      if (completionStatsBuilder_ == null) {
        completionStats_ = builderForValue.build();
        onChanged();
      } else {
        completionStatsBuilder_.setMessage(builderForValue.build());
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Statistics on completed and failed prediction instances.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.CompletionStats completion_stats = 14 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder mergeCompletionStats(com.google.cloud.aiplatform.v1beta1.CompletionStats value) {
      if (completionStatsBuilder_ == null) {
        if (completionStats_ != null) {
          completionStats_ =
              com.google.cloud.aiplatform.v1beta1.CompletionStats.newBuilder(completionStats_)
                  .mergeFrom(value)
                  .buildPartial();
        } else {
          completionStats_ = value;
        }
        onChanged();
      } else {
        completionStatsBuilder_.mergeFrom(value);
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Statistics on completed and failed prediction instances.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.CompletionStats completion_stats = 14 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder clearCompletionStats() {
      if (completionStatsBuilder_ == null) {
        completionStats_ = null;
        onChanged();
      } else {
        completionStats_ = null;
        completionStatsBuilder_ = null;
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Statistics on completed and failed prediction instances.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.CompletionStats completion_stats = 14 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.cloud.aiplatform.v1beta1.CompletionStats.Builder getCompletionStatsBuilder() {

      onChanged();
      return getCompletionStatsFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Output only. Statistics on completed and failed prediction instances.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.CompletionStats completion_stats = 14 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.cloud.aiplatform.v1beta1.CompletionStatsOrBuilder
        getCompletionStatsOrBuilder() {
      if (completionStatsBuilder_ != null) {
        return completionStatsBuilder_.getMessageOrBuilder();
      } else {
        return completionStats_ == null
            ? com.google.cloud.aiplatform.v1beta1.CompletionStats.getDefaultInstance()
            : completionStats_;
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. Statistics on completed and failed prediction instances.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.CompletionStats completion_stats = 14 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.aiplatform.v1beta1.CompletionStats,
            com.google.cloud.aiplatform.v1beta1.CompletionStats.Builder,
            com.google.cloud.aiplatform.v1beta1.CompletionStatsOrBuilder>
        getCompletionStatsFieldBuilder() {
      if (completionStatsBuilder_ == null) {
        completionStatsBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.aiplatform.v1beta1.CompletionStats,
                com.google.cloud.aiplatform.v1beta1.CompletionStats.Builder,
                com.google.cloud.aiplatform.v1beta1.CompletionStatsOrBuilder>(
                getCompletionStats(), getParentForChildren(), isClean());
        completionStats_ = null;
      }
      return completionStatsBuilder_;
    }

    private com.google.protobuf.Timestamp createTime_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Timestamp,
            com.google.protobuf.Timestamp.Builder,
            com.google.protobuf.TimestampOrBuilder>
        createTimeBuilder_;
    /**
     *
     *
     * <pre>
     * Output only. Time when the BatchPredictionJob was created.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp create_time = 15 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return Whether the createTime field is set.
     */
    public boolean hasCreateTime() {
      return createTimeBuilder_ != null || createTime_ != null;
    }
    /**
     *
     *
     * <pre>
     * Output only. Time when the BatchPredictionJob was created.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp create_time = 15 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return The createTime.
     */
    public com.google.protobuf.Timestamp getCreateTime() {
      if (createTimeBuilder_ == null) {
        return createTime_ == null
            ? com.google.protobuf.Timestamp.getDefaultInstance()
            : createTime_;
      } else {
        return createTimeBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. Time when the BatchPredictionJob was created.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp create_time = 15 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder setCreateTime(com.google.protobuf.Timestamp value) {
      if (createTimeBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        createTime_ = value;
        onChanged();
      } else {
        createTimeBuilder_.setMessage(value);
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Time when the BatchPredictionJob was created.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp create_time = 15 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder setCreateTime(com.google.protobuf.Timestamp.Builder builderForValue) {
      if (createTimeBuilder_ == null) {
        createTime_ = builderForValue.build();
        onChanged();
      } else {
        createTimeBuilder_.setMessage(builderForValue.build());
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Time when the BatchPredictionJob was created.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp create_time = 15 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder mergeCreateTime(com.google.protobuf.Timestamp value) {
      if (createTimeBuilder_ == null) {
        if (createTime_ != null) {
          createTime_ =
              com.google.protobuf.Timestamp.newBuilder(createTime_).mergeFrom(value).buildPartial();
        } else {
          createTime_ = value;
        }
        onChanged();
      } else {
        createTimeBuilder_.mergeFrom(value);
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Time when the BatchPredictionJob was created.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp create_time = 15 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder clearCreateTime() {
      if (createTimeBuilder_ == null) {
        createTime_ = null;
        onChanged();
      } else {
        createTime_ = null;
        createTimeBuilder_ = null;
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Time when the BatchPredictionJob was created.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp create_time = 15 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.protobuf.Timestamp.Builder getCreateTimeBuilder() {

      onChanged();
      return getCreateTimeFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Output only. Time when the BatchPredictionJob was created.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp create_time = 15 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.protobuf.TimestampOrBuilder getCreateTimeOrBuilder() {
      if (createTimeBuilder_ != null) {
        return createTimeBuilder_.getMessageOrBuilder();
      } else {
        return createTime_ == null
            ? com.google.protobuf.Timestamp.getDefaultInstance()
            : createTime_;
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. Time when the BatchPredictionJob was created.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp create_time = 15 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Timestamp,
            com.google.protobuf.Timestamp.Builder,
            com.google.protobuf.TimestampOrBuilder>
        getCreateTimeFieldBuilder() {
      if (createTimeBuilder_ == null) {
        createTimeBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.protobuf.Timestamp,
                com.google.protobuf.Timestamp.Builder,
                com.google.protobuf.TimestampOrBuilder>(
                getCreateTime(), getParentForChildren(), isClean());
        createTime_ = null;
      }
      return createTimeBuilder_;
    }

    private com.google.protobuf.Timestamp startTime_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Timestamp,
            com.google.protobuf.Timestamp.Builder,
            com.google.protobuf.TimestampOrBuilder>
        startTimeBuilder_;
    /**
     *
     *
     * <pre>
     * Output only. Time when the BatchPredictionJob for the first time entered the
     * `JOB_STATE_RUNNING` state.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp start_time = 16 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return Whether the startTime field is set.
     */
    public boolean hasStartTime() {
      return startTimeBuilder_ != null || startTime_ != null;
    }
    /**
     *
     *
     * <pre>
     * Output only. Time when the BatchPredictionJob for the first time entered the
     * `JOB_STATE_RUNNING` state.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp start_time = 16 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return The startTime.
     */
    public com.google.protobuf.Timestamp getStartTime() {
      if (startTimeBuilder_ == null) {
        return startTime_ == null ? com.google.protobuf.Timestamp.getDefaultInstance() : startTime_;
      } else {
        return startTimeBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. Time when the BatchPredictionJob for the first time entered the
     * `JOB_STATE_RUNNING` state.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp start_time = 16 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder setStartTime(com.google.protobuf.Timestamp value) {
      if (startTimeBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        startTime_ = value;
        onChanged();
      } else {
        startTimeBuilder_.setMessage(value);
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Time when the BatchPredictionJob for the first time entered the
     * `JOB_STATE_RUNNING` state.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp start_time = 16 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder setStartTime(com.google.protobuf.Timestamp.Builder builderForValue) {
      if (startTimeBuilder_ == null) {
        startTime_ = builderForValue.build();
        onChanged();
      } else {
        startTimeBuilder_.setMessage(builderForValue.build());
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Time when the BatchPredictionJob for the first time entered the
     * `JOB_STATE_RUNNING` state.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp start_time = 16 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder mergeStartTime(com.google.protobuf.Timestamp value) {
      if (startTimeBuilder_ == null) {
        if (startTime_ != null) {
          startTime_ =
              com.google.protobuf.Timestamp.newBuilder(startTime_).mergeFrom(value).buildPartial();
        } else {
          startTime_ = value;
        }
        onChanged();
      } else {
        startTimeBuilder_.mergeFrom(value);
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Time when the BatchPredictionJob for the first time entered the
     * `JOB_STATE_RUNNING` state.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp start_time = 16 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder clearStartTime() {
      if (startTimeBuilder_ == null) {
        startTime_ = null;
        onChanged();
      } else {
        startTime_ = null;
        startTimeBuilder_ = null;
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Time when the BatchPredictionJob for the first time entered the
     * `JOB_STATE_RUNNING` state.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp start_time = 16 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.protobuf.Timestamp.Builder getStartTimeBuilder() {

      onChanged();
      return getStartTimeFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Output only. Time when the BatchPredictionJob for the first time entered the
     * `JOB_STATE_RUNNING` state.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp start_time = 16 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.protobuf.TimestampOrBuilder getStartTimeOrBuilder() {
      if (startTimeBuilder_ != null) {
        return startTimeBuilder_.getMessageOrBuilder();
      } else {
        return startTime_ == null ? com.google.protobuf.Timestamp.getDefaultInstance() : startTime_;
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. Time when the BatchPredictionJob for the first time entered the
     * `JOB_STATE_RUNNING` state.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp start_time = 16 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Timestamp,
            com.google.protobuf.Timestamp.Builder,
            com.google.protobuf.TimestampOrBuilder>
        getStartTimeFieldBuilder() {
      if (startTimeBuilder_ == null) {
        startTimeBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.protobuf.Timestamp,
                com.google.protobuf.Timestamp.Builder,
                com.google.protobuf.TimestampOrBuilder>(
                getStartTime(), getParentForChildren(), isClean());
        startTime_ = null;
      }
      return startTimeBuilder_;
    }

    private com.google.protobuf.Timestamp endTime_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Timestamp,
            com.google.protobuf.Timestamp.Builder,
            com.google.protobuf.TimestampOrBuilder>
        endTimeBuilder_;
    /**
     *
     *
     * <pre>
     * Output only. Time when the BatchPredictionJob entered any of the following states:
     * `JOB_STATE_SUCCEEDED`, `JOB_STATE_FAILED`, `JOB_STATE_CANCELLED`.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp end_time = 17 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return Whether the endTime field is set.
     */
    public boolean hasEndTime() {
      return endTimeBuilder_ != null || endTime_ != null;
    }
    /**
     *
     *
     * <pre>
     * Output only. Time when the BatchPredictionJob entered any of the following states:
     * `JOB_STATE_SUCCEEDED`, `JOB_STATE_FAILED`, `JOB_STATE_CANCELLED`.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp end_time = 17 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return The endTime.
     */
    public com.google.protobuf.Timestamp getEndTime() {
      if (endTimeBuilder_ == null) {
        return endTime_ == null ? com.google.protobuf.Timestamp.getDefaultInstance() : endTime_;
      } else {
        return endTimeBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. Time when the BatchPredictionJob entered any of the following states:
     * `JOB_STATE_SUCCEEDED`, `JOB_STATE_FAILED`, `JOB_STATE_CANCELLED`.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp end_time = 17 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder setEndTime(com.google.protobuf.Timestamp value) {
      if (endTimeBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        endTime_ = value;
        onChanged();
      } else {
        endTimeBuilder_.setMessage(value);
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Time when the BatchPredictionJob entered any of the following states:
     * `JOB_STATE_SUCCEEDED`, `JOB_STATE_FAILED`, `JOB_STATE_CANCELLED`.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp end_time = 17 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder setEndTime(com.google.protobuf.Timestamp.Builder builderForValue) {
      if (endTimeBuilder_ == null) {
        endTime_ = builderForValue.build();
        onChanged();
      } else {
        endTimeBuilder_.setMessage(builderForValue.build());
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Time when the BatchPredictionJob entered any of the following states:
     * `JOB_STATE_SUCCEEDED`, `JOB_STATE_FAILED`, `JOB_STATE_CANCELLED`.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp end_time = 17 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder mergeEndTime(com.google.protobuf.Timestamp value) {
      if (endTimeBuilder_ == null) {
        if (endTime_ != null) {
          endTime_ =
              com.google.protobuf.Timestamp.newBuilder(endTime_).mergeFrom(value).buildPartial();
        } else {
          endTime_ = value;
        }
        onChanged();
      } else {
        endTimeBuilder_.mergeFrom(value);
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Time when the BatchPredictionJob entered any of the following states:
     * `JOB_STATE_SUCCEEDED`, `JOB_STATE_FAILED`, `JOB_STATE_CANCELLED`.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp end_time = 17 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder clearEndTime() {
      if (endTimeBuilder_ == null) {
        endTime_ = null;
        onChanged();
      } else {
        endTime_ = null;
        endTimeBuilder_ = null;
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Time when the BatchPredictionJob entered any of the following states:
     * `JOB_STATE_SUCCEEDED`, `JOB_STATE_FAILED`, `JOB_STATE_CANCELLED`.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp end_time = 17 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.protobuf.Timestamp.Builder getEndTimeBuilder() {

      onChanged();
      return getEndTimeFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Output only. Time when the BatchPredictionJob entered any of the following states:
     * `JOB_STATE_SUCCEEDED`, `JOB_STATE_FAILED`, `JOB_STATE_CANCELLED`.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp end_time = 17 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.protobuf.TimestampOrBuilder getEndTimeOrBuilder() {
      if (endTimeBuilder_ != null) {
        return endTimeBuilder_.getMessageOrBuilder();
      } else {
        return endTime_ == null ? com.google.protobuf.Timestamp.getDefaultInstance() : endTime_;
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. Time when the BatchPredictionJob entered any of the following states:
     * `JOB_STATE_SUCCEEDED`, `JOB_STATE_FAILED`, `JOB_STATE_CANCELLED`.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp end_time = 17 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Timestamp,
            com.google.protobuf.Timestamp.Builder,
            com.google.protobuf.TimestampOrBuilder>
        getEndTimeFieldBuilder() {
      if (endTimeBuilder_ == null) {
        endTimeBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.protobuf.Timestamp,
                com.google.protobuf.Timestamp.Builder,
                com.google.protobuf.TimestampOrBuilder>(
                getEndTime(), getParentForChildren(), isClean());
        endTime_ = null;
      }
      return endTimeBuilder_;
    }

    private com.google.protobuf.Timestamp updateTime_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Timestamp,
            com.google.protobuf.Timestamp.Builder,
            com.google.protobuf.TimestampOrBuilder>
        updateTimeBuilder_;
    /**
     *
     *
     * <pre>
     * Output only. Time when the BatchPredictionJob was most recently updated.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp update_time = 18 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return Whether the updateTime field is set.
     */
    public boolean hasUpdateTime() {
      return updateTimeBuilder_ != null || updateTime_ != null;
    }
    /**
     *
     *
     * <pre>
     * Output only. Time when the BatchPredictionJob was most recently updated.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp update_time = 18 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return The updateTime.
     */
    public com.google.protobuf.Timestamp getUpdateTime() {
      if (updateTimeBuilder_ == null) {
        return updateTime_ == null
            ? com.google.protobuf.Timestamp.getDefaultInstance()
            : updateTime_;
      } else {
        return updateTimeBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. Time when the BatchPredictionJob was most recently updated.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp update_time = 18 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder setUpdateTime(com.google.protobuf.Timestamp value) {
      if (updateTimeBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        updateTime_ = value;
        onChanged();
      } else {
        updateTimeBuilder_.setMessage(value);
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Time when the BatchPredictionJob was most recently updated.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp update_time = 18 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder setUpdateTime(com.google.protobuf.Timestamp.Builder builderForValue) {
      if (updateTimeBuilder_ == null) {
        updateTime_ = builderForValue.build();
        onChanged();
      } else {
        updateTimeBuilder_.setMessage(builderForValue.build());
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Time when the BatchPredictionJob was most recently updated.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp update_time = 18 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder mergeUpdateTime(com.google.protobuf.Timestamp value) {
      if (updateTimeBuilder_ == null) {
        if (updateTime_ != null) {
          updateTime_ =
              com.google.protobuf.Timestamp.newBuilder(updateTime_).mergeFrom(value).buildPartial();
        } else {
          updateTime_ = value;
        }
        onChanged();
      } else {
        updateTimeBuilder_.mergeFrom(value);
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Time when the BatchPredictionJob was most recently updated.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp update_time = 18 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder clearUpdateTime() {
      if (updateTimeBuilder_ == null) {
        updateTime_ = null;
        onChanged();
      } else {
        updateTime_ = null;
        updateTimeBuilder_ = null;
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Time when the BatchPredictionJob was most recently updated.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp update_time = 18 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.protobuf.Timestamp.Builder getUpdateTimeBuilder() {

      onChanged();
      return getUpdateTimeFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Output only. Time when the BatchPredictionJob was most recently updated.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp update_time = 18 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.protobuf.TimestampOrBuilder getUpdateTimeOrBuilder() {
      if (updateTimeBuilder_ != null) {
        return updateTimeBuilder_.getMessageOrBuilder();
      } else {
        return updateTime_ == null
            ? com.google.protobuf.Timestamp.getDefaultInstance()
            : updateTime_;
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. Time when the BatchPredictionJob was most recently updated.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp update_time = 18 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Timestamp,
            com.google.protobuf.Timestamp.Builder,
            com.google.protobuf.TimestampOrBuilder>
        getUpdateTimeFieldBuilder() {
      if (updateTimeBuilder_ == null) {
        updateTimeBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.protobuf.Timestamp,
                com.google.protobuf.Timestamp.Builder,
                com.google.protobuf.TimestampOrBuilder>(
                getUpdateTime(), getParentForChildren(), isClean());
        updateTime_ = null;
      }
      return updateTimeBuilder_;
    }

    private com.google.protobuf.MapField<java.lang.String, java.lang.String> labels_;

    private com.google.protobuf.MapField<java.lang.String, java.lang.String> internalGetLabels() {
      if (labels_ == null) {
        return com.google.protobuf.MapField.emptyMapField(LabelsDefaultEntryHolder.defaultEntry);
      }
      return labels_;
    }

    private com.google.protobuf.MapField<java.lang.String, java.lang.String>
        internalGetMutableLabels() {
      onChanged();
      ;
      if (labels_ == null) {
        labels_ = com.google.protobuf.MapField.newMapField(LabelsDefaultEntryHolder.defaultEntry);
      }
      if (!labels_.isMutable()) {
        labels_ = labels_.copy();
      }
      return labels_;
    }

    public int getLabelsCount() {
      return internalGetLabels().getMap().size();
    }
    /**
     *
     *
     * <pre>
     * The labels with user-defined metadata to organize BatchPredictionJobs.
     * Label keys and values can be no longer than 64 characters
     * (Unicode codepoints), can only contain lowercase letters, numeric
     * characters, underscores and dashes. International characters are allowed.
     * See https://goo.gl/xmQnxf for more information and examples of labels.
     * </pre>
     *
     * <code>map&lt;string, string&gt; labels = 19;</code>
     */
    @java.lang.Override
    public boolean containsLabels(java.lang.String key) {
      if (key == null) {
        throw new java.lang.NullPointerException();
      }
      return internalGetLabels().getMap().containsKey(key);
    }
    /** Use {@link #getLabelsMap()} instead. */
    @java.lang.Override
    @java.lang.Deprecated
    public java.util.Map<java.lang.String, java.lang.String> getLabels() {
      return getLabelsMap();
    }
    /**
     *
     *
     * <pre>
     * The labels with user-defined metadata to organize BatchPredictionJobs.
     * Label keys and values can be no longer than 64 characters
     * (Unicode codepoints), can only contain lowercase letters, numeric
     * characters, underscores and dashes. International characters are allowed.
     * See https://goo.gl/xmQnxf for more information and examples of labels.
     * </pre>
     *
     * <code>map&lt;string, string&gt; labels = 19;</code>
     */
    @java.lang.Override
    public java.util.Map<java.lang.String, java.lang.String> getLabelsMap() {
      return internalGetLabels().getMap();
    }
    /**
     *
     *
     * <pre>
     * The labels with user-defined metadata to organize BatchPredictionJobs.
     * Label keys and values can be no longer than 64 characters
     * (Unicode codepoints), can only contain lowercase letters, numeric
     * characters, underscores and dashes. International characters are allowed.
     * See https://goo.gl/xmQnxf for more information and examples of labels.
     * </pre>
     *
     * <code>map&lt;string, string&gt; labels = 19;</code>
     */
    @java.lang.Override
    public java.lang.String getLabelsOrDefault(
        java.lang.String key, java.lang.String defaultValue) {
      if (key == null) {
        throw new java.lang.NullPointerException();
      }
      java.util.Map<java.lang.String, java.lang.String> map = internalGetLabels().getMap();
      return map.containsKey(key) ? map.get(key) : defaultValue;
    }
    /**
     *
     *
     * <pre>
     * The labels with user-defined metadata to organize BatchPredictionJobs.
     * Label keys and values can be no longer than 64 characters
     * (Unicode codepoints), can only contain lowercase letters, numeric
     * characters, underscores and dashes. International characters are allowed.
     * See https://goo.gl/xmQnxf for more information and examples of labels.
     * </pre>
     *
     * <code>map&lt;string, string&gt; labels = 19;</code>
     */
    @java.lang.Override
    public java.lang.String getLabelsOrThrow(java.lang.String key) {
      if (key == null) {
        throw new java.lang.NullPointerException();
      }
      java.util.Map<java.lang.String, java.lang.String> map = internalGetLabels().getMap();
      if (!map.containsKey(key)) {
        throw new java.lang.IllegalArgumentException();
      }
      return map.get(key);
    }

    public Builder clearLabels() {
      internalGetMutableLabels().getMutableMap().clear();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The labels with user-defined metadata to organize BatchPredictionJobs.
     * Label keys and values can be no longer than 64 characters
     * (Unicode codepoints), can only contain lowercase letters, numeric
     * characters, underscores and dashes. International characters are allowed.
     * See https://goo.gl/xmQnxf for more information and examples of labels.
     * </pre>
     *
     * <code>map&lt;string, string&gt; labels = 19;</code>
     */
    public Builder removeLabels(java.lang.String key) {
      if (key == null) {
        throw new java.lang.NullPointerException();
      }
      internalGetMutableLabels().getMutableMap().remove(key);
      return this;
    }
    /** Use alternate mutation accessors instead. */
    @java.lang.Deprecated
    public java.util.Map<java.lang.String, java.lang.String> getMutableLabels() {
      return internalGetMutableLabels().getMutableMap();
    }
    /**
     *
     *
     * <pre>
     * The labels with user-defined metadata to organize BatchPredictionJobs.
     * Label keys and values can be no longer than 64 characters
     * (Unicode codepoints), can only contain lowercase letters, numeric
     * characters, underscores and dashes. International characters are allowed.
     * See https://goo.gl/xmQnxf for more information and examples of labels.
     * </pre>
     *
     * <code>map&lt;string, string&gt; labels = 19;</code>
     */
    public Builder putLabels(java.lang.String key, java.lang.String value) {
      if (key == null) {
        throw new java.lang.NullPointerException();
      }
      if (value == null) {
        throw new java.lang.NullPointerException();
      }
      internalGetMutableLabels().getMutableMap().put(key, value);
      return this;
    }
    /**
     *
     *
     * <pre>
     * The labels with user-defined metadata to organize BatchPredictionJobs.
     * Label keys and values can be no longer than 64 characters
     * (Unicode codepoints), can only contain lowercase letters, numeric
     * characters, underscores and dashes. International characters are allowed.
     * See https://goo.gl/xmQnxf for more information and examples of labels.
     * </pre>
     *
     * <code>map&lt;string, string&gt; labels = 19;</code>
     */
    public Builder putAllLabels(java.util.Map<java.lang.String, java.lang.String> values) {
      internalGetMutableLabels().getMutableMap().putAll(values);
      return this;
    }

    private com.google.cloud.aiplatform.v1beta1.EncryptionSpec encryptionSpec_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.aiplatform.v1beta1.EncryptionSpec,
            com.google.cloud.aiplatform.v1beta1.EncryptionSpec.Builder,
            com.google.cloud.aiplatform.v1beta1.EncryptionSpecOrBuilder>
        encryptionSpecBuilder_;
    /**
     *
     *
     * <pre>
     * Customer-managed encryption key options for a BatchPredictionJob. If this
     * is set, then all resources created by the BatchPredictionJob will be
     * encrypted with the provided encryption key.
     * </pre>
     *
     * <code>.google.cloud.aiplatform.v1beta1.EncryptionSpec encryption_spec = 24;</code>
     *
     * @return Whether the encryptionSpec field is set.
     */
    public boolean hasEncryptionSpec() {
      return encryptionSpecBuilder_ != null || encryptionSpec_ != null;
    }
    /**
     *
     *
     * <pre>
     * Customer-managed encryption key options for a BatchPredictionJob. If this
     * is set, then all resources created by the BatchPredictionJob will be
     * encrypted with the provided encryption key.
     * </pre>
     *
     * <code>.google.cloud.aiplatform.v1beta1.EncryptionSpec encryption_spec = 24;</code>
     *
     * @return The encryptionSpec.
     */
    public com.google.cloud.aiplatform.v1beta1.EncryptionSpec getEncryptionSpec() {
      if (encryptionSpecBuilder_ == null) {
        return encryptionSpec_ == null
            ? com.google.cloud.aiplatform.v1beta1.EncryptionSpec.getDefaultInstance()
            : encryptionSpec_;
      } else {
        return encryptionSpecBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Customer-managed encryption key options for a BatchPredictionJob. If this
     * is set, then all resources created by the BatchPredictionJob will be
     * encrypted with the provided encryption key.
     * </pre>
     *
     * <code>.google.cloud.aiplatform.v1beta1.EncryptionSpec encryption_spec = 24;</code>
     */
    public Builder setEncryptionSpec(com.google.cloud.aiplatform.v1beta1.EncryptionSpec value) {
      if (encryptionSpecBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        encryptionSpec_ = value;
        onChanged();
      } else {
        encryptionSpecBuilder_.setMessage(value);
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * Customer-managed encryption key options for a BatchPredictionJob. If this
     * is set, then all resources created by the BatchPredictionJob will be
     * encrypted with the provided encryption key.
     * </pre>
     *
     * <code>.google.cloud.aiplatform.v1beta1.EncryptionSpec encryption_spec = 24;</code>
     */
    public Builder setEncryptionSpec(
        com.google.cloud.aiplatform.v1beta1.EncryptionSpec.Builder builderForValue) {
      if (encryptionSpecBuilder_ == null) {
        encryptionSpec_ = builderForValue.build();
        onChanged();
      } else {
        encryptionSpecBuilder_.setMessage(builderForValue.build());
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * Customer-managed encryption key options for a BatchPredictionJob. If this
     * is set, then all resources created by the BatchPredictionJob will be
     * encrypted with the provided encryption key.
     * </pre>
     *
     * <code>.google.cloud.aiplatform.v1beta1.EncryptionSpec encryption_spec = 24;</code>
     */
    public Builder mergeEncryptionSpec(com.google.cloud.aiplatform.v1beta1.EncryptionSpec value) {
      if (encryptionSpecBuilder_ == null) {
        if (encryptionSpec_ != null) {
          encryptionSpec_ =
              com.google.cloud.aiplatform.v1beta1.EncryptionSpec.newBuilder(encryptionSpec_)
                  .mergeFrom(value)
                  .buildPartial();
        } else {
          encryptionSpec_ = value;
        }
        onChanged();
      } else {
        encryptionSpecBuilder_.mergeFrom(value);
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * Customer-managed encryption key options for a BatchPredictionJob. If this
     * is set, then all resources created by the BatchPredictionJob will be
     * encrypted with the provided encryption key.
     * </pre>
     *
     * <code>.google.cloud.aiplatform.v1beta1.EncryptionSpec encryption_spec = 24;</code>
     */
    public Builder clearEncryptionSpec() {
      if (encryptionSpecBuilder_ == null) {
        encryptionSpec_ = null;
        onChanged();
      } else {
        encryptionSpec_ = null;
        encryptionSpecBuilder_ = null;
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * Customer-managed encryption key options for a BatchPredictionJob. If this
     * is set, then all resources created by the BatchPredictionJob will be
     * encrypted with the provided encryption key.
     * </pre>
     *
     * <code>.google.cloud.aiplatform.v1beta1.EncryptionSpec encryption_spec = 24;</code>
     */
    public com.google.cloud.aiplatform.v1beta1.EncryptionSpec.Builder getEncryptionSpecBuilder() {

      onChanged();
      return getEncryptionSpecFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Customer-managed encryption key options for a BatchPredictionJob. If this
     * is set, then all resources created by the BatchPredictionJob will be
     * encrypted with the provided encryption key.
     * </pre>
     *
     * <code>.google.cloud.aiplatform.v1beta1.EncryptionSpec encryption_spec = 24;</code>
     */
    public com.google.cloud.aiplatform.v1beta1.EncryptionSpecOrBuilder
        getEncryptionSpecOrBuilder() {
      if (encryptionSpecBuilder_ != null) {
        return encryptionSpecBuilder_.getMessageOrBuilder();
      } else {
        return encryptionSpec_ == null
            ? com.google.cloud.aiplatform.v1beta1.EncryptionSpec.getDefaultInstance()
            : encryptionSpec_;
      }
    }
    /**
     *
     *
     * <pre>
     * Customer-managed encryption key options for a BatchPredictionJob. If this
     * is set, then all resources created by the BatchPredictionJob will be
     * encrypted with the provided encryption key.
     * </pre>
     *
     * <code>.google.cloud.aiplatform.v1beta1.EncryptionSpec encryption_spec = 24;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.aiplatform.v1beta1.EncryptionSpec,
            com.google.cloud.aiplatform.v1beta1.EncryptionSpec.Builder,
            com.google.cloud.aiplatform.v1beta1.EncryptionSpecOrBuilder>
        getEncryptionSpecFieldBuilder() {
      if (encryptionSpecBuilder_ == null) {
        encryptionSpecBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.aiplatform.v1beta1.EncryptionSpec,
                com.google.cloud.aiplatform.v1beta1.EncryptionSpec.Builder,
                com.google.cloud.aiplatform.v1beta1.EncryptionSpecOrBuilder>(
                getEncryptionSpec(), getParentForChildren(), isClean());
        encryptionSpec_ = null;
      }
      return encryptionSpecBuilder_;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.cloud.aiplatform.v1beta1.BatchPredictionJob)
  }

  // @@protoc_insertion_point(class_scope:google.cloud.aiplatform.v1beta1.BatchPredictionJob)
  private static final com.google.cloud.aiplatform.v1beta1.BatchPredictionJob DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.cloud.aiplatform.v1beta1.BatchPredictionJob();
  }

  public static com.google.cloud.aiplatform.v1beta1.BatchPredictionJob getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<BatchPredictionJob> PARSER =
      new com.google.protobuf.AbstractParser<BatchPredictionJob>() {
        @java.lang.Override
        public BatchPredictionJob parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          return new BatchPredictionJob(input, extensionRegistry);
        }
      };

  public static com.google.protobuf.Parser<BatchPredictionJob> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<BatchPredictionJob> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.cloud.aiplatform.v1beta1.BatchPredictionJob getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
