/*
 * Copyright 2020 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/cloud/aiplatform/v1beta1/feature.proto

package com.google.cloud.aiplatform.v1beta1;

/**
 *
 *
 * <pre>
 * Feature Metadata information that describes an attribute of an entity type.
 * For example, apple is an entity type, and color is a feature that describes
 * apple.
 * </pre>
 *
 * Protobuf type {@code google.cloud.aiplatform.v1beta1.Feature}
 */
public final class Feature extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.cloud.aiplatform.v1beta1.Feature)
    FeatureOrBuilder {
  private static final long serialVersionUID = 0L;
  // Use Feature.newBuilder() to construct.
  private Feature(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private Feature() {
    name_ = "";
    description_ = "";
    valueType_ = 0;
    etag_ = "";
    monitoringStats_ = java.util.Collections.emptyList();
  }

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new Feature();
  }

  @java.lang.Override
  public final com.google.protobuf.UnknownFieldSet getUnknownFields() {
    return this.unknownFields;
  }

  private Feature(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    this();
    if (extensionRegistry == null) {
      throw new java.lang.NullPointerException();
    }
    int mutable_bitField0_ = 0;
    com.google.protobuf.UnknownFieldSet.Builder unknownFields =
        com.google.protobuf.UnknownFieldSet.newBuilder();
    try {
      boolean done = false;
      while (!done) {
        int tag = input.readTag();
        switch (tag) {
          case 0:
            done = true;
            break;
          case 10:
            {
              java.lang.String s = input.readStringRequireUtf8();

              name_ = s;
              break;
            }
          case 18:
            {
              java.lang.String s = input.readStringRequireUtf8();

              description_ = s;
              break;
            }
          case 24:
            {
              int rawValue = input.readEnum();

              valueType_ = rawValue;
              break;
            }
          case 34:
            {
              com.google.protobuf.Timestamp.Builder subBuilder = null;
              if (createTime_ != null) {
                subBuilder = createTime_.toBuilder();
              }
              createTime_ =
                  input.readMessage(com.google.protobuf.Timestamp.parser(), extensionRegistry);
              if (subBuilder != null) {
                subBuilder.mergeFrom(createTime_);
                createTime_ = subBuilder.buildPartial();
              }

              break;
            }
          case 42:
            {
              com.google.protobuf.Timestamp.Builder subBuilder = null;
              if (updateTime_ != null) {
                subBuilder = updateTime_.toBuilder();
              }
              updateTime_ =
                  input.readMessage(com.google.protobuf.Timestamp.parser(), extensionRegistry);
              if (subBuilder != null) {
                subBuilder.mergeFrom(updateTime_);
                updateTime_ = subBuilder.buildPartial();
              }

              break;
            }
          case 50:
            {
              if (!((mutable_bitField0_ & 0x00000001) != 0)) {
                labels_ =
                    com.google.protobuf.MapField.newMapField(LabelsDefaultEntryHolder.defaultEntry);
                mutable_bitField0_ |= 0x00000001;
              }
              com.google.protobuf.MapEntry<java.lang.String, java.lang.String> labels__ =
                  input.readMessage(
                      LabelsDefaultEntryHolder.defaultEntry.getParserForType(), extensionRegistry);
              labels_.getMutableMap().put(labels__.getKey(), labels__.getValue());
              break;
            }
          case 58:
            {
              java.lang.String s = input.readStringRequireUtf8();

              etag_ = s;
              break;
            }
          case 74:
            {
              com.google.cloud.aiplatform.v1beta1.FeaturestoreMonitoringConfig.Builder subBuilder =
                  null;
              if (monitoringConfig_ != null) {
                subBuilder = monitoringConfig_.toBuilder();
              }
              monitoringConfig_ =
                  input.readMessage(
                      com.google.cloud.aiplatform.v1beta1.FeaturestoreMonitoringConfig.parser(),
                      extensionRegistry);
              if (subBuilder != null) {
                subBuilder.mergeFrom(monitoringConfig_);
                monitoringConfig_ = subBuilder.buildPartial();
              }

              break;
            }
          case 82:
            {
              if (!((mutable_bitField0_ & 0x00000002) != 0)) {
                monitoringStats_ =
                    new java.util.ArrayList<
                        com.google.cloud.aiplatform.v1beta1.FeatureStatsAnomaly>();
                mutable_bitField0_ |= 0x00000002;
              }
              monitoringStats_.add(
                  input.readMessage(
                      com.google.cloud.aiplatform.v1beta1.FeatureStatsAnomaly.parser(),
                      extensionRegistry));
              break;
            }
          default:
            {
              if (!parseUnknownField(input, unknownFields, extensionRegistry, tag)) {
                done = true;
              }
              break;
            }
        }
      }
    } catch (com.google.protobuf.InvalidProtocolBufferException e) {
      throw e.setUnfinishedMessage(this);
    } catch (java.io.IOException e) {
      throw new com.google.protobuf.InvalidProtocolBufferException(e).setUnfinishedMessage(this);
    } finally {
      if (((mutable_bitField0_ & 0x00000002) != 0)) {
        monitoringStats_ = java.util.Collections.unmodifiableList(monitoringStats_);
      }
      this.unknownFields = unknownFields.build();
      makeExtensionsImmutable();
    }
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.cloud.aiplatform.v1beta1.FeatureProto
        .internal_static_google_cloud_aiplatform_v1beta1_Feature_descriptor;
  }

  @SuppressWarnings({"rawtypes"})
  @java.lang.Override
  protected com.google.protobuf.MapField internalGetMapField(int number) {
    switch (number) {
      case 6:
        return internalGetLabels();
      default:
        throw new RuntimeException("Invalid map field number: " + number);
    }
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.cloud.aiplatform.v1beta1.FeatureProto
        .internal_static_google_cloud_aiplatform_v1beta1_Feature_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.cloud.aiplatform.v1beta1.Feature.class,
            com.google.cloud.aiplatform.v1beta1.Feature.Builder.class);
  }

  /**
   *
   *
   * <pre>
   * An enum representing the value type of a feature.
   * </pre>
   *
   * Protobuf enum {@code google.cloud.aiplatform.v1beta1.Feature.ValueType}
   */
  public enum ValueType implements com.google.protobuf.ProtocolMessageEnum {
    /**
     *
     *
     * <pre>
     * The value type is unspecified.
     * </pre>
     *
     * <code>VALUE_TYPE_UNSPECIFIED = 0;</code>
     */
    VALUE_TYPE_UNSPECIFIED(0),
    /**
     *
     *
     * <pre>
     * Used for Feature that is a boolean.
     * </pre>
     *
     * <code>BOOL = 1;</code>
     */
    BOOL(1),
    /**
     *
     *
     * <pre>
     * Used for Feature that is a list of boolean.
     * </pre>
     *
     * <code>BOOL_ARRAY = 2;</code>
     */
    BOOL_ARRAY(2),
    /**
     *
     *
     * <pre>
     * Used for Feature that is double.
     * </pre>
     *
     * <code>DOUBLE = 3;</code>
     */
    DOUBLE(3),
    /**
     *
     *
     * <pre>
     * Used for Feature that is a list of double.
     * </pre>
     *
     * <code>DOUBLE_ARRAY = 4;</code>
     */
    DOUBLE_ARRAY(4),
    /**
     *
     *
     * <pre>
     * Used for Feature that is INT64.
     * </pre>
     *
     * <code>INT64 = 9;</code>
     */
    INT64(9),
    /**
     *
     *
     * <pre>
     * Used for Feature that is a list of INT64.
     * </pre>
     *
     * <code>INT64_ARRAY = 10;</code>
     */
    INT64_ARRAY(10),
    /**
     *
     *
     * <pre>
     * Used for Feature that is string.
     * </pre>
     *
     * <code>STRING = 11;</code>
     */
    STRING(11),
    /**
     *
     *
     * <pre>
     * Used for Feature that is a list of String.
     * </pre>
     *
     * <code>STRING_ARRAY = 12;</code>
     */
    STRING_ARRAY(12),
    /**
     *
     *
     * <pre>
     * Used for Feature that is bytes.
     * </pre>
     *
     * <code>BYTES = 13;</code>
     */
    BYTES(13),
    UNRECOGNIZED(-1),
    ;

    /**
     *
     *
     * <pre>
     * The value type is unspecified.
     * </pre>
     *
     * <code>VALUE_TYPE_UNSPECIFIED = 0;</code>
     */
    public static final int VALUE_TYPE_UNSPECIFIED_VALUE = 0;
    /**
     *
     *
     * <pre>
     * Used for Feature that is a boolean.
     * </pre>
     *
     * <code>BOOL = 1;</code>
     */
    public static final int BOOL_VALUE = 1;
    /**
     *
     *
     * <pre>
     * Used for Feature that is a list of boolean.
     * </pre>
     *
     * <code>BOOL_ARRAY = 2;</code>
     */
    public static final int BOOL_ARRAY_VALUE = 2;
    /**
     *
     *
     * <pre>
     * Used for Feature that is double.
     * </pre>
     *
     * <code>DOUBLE = 3;</code>
     */
    public static final int DOUBLE_VALUE = 3;
    /**
     *
     *
     * <pre>
     * Used for Feature that is a list of double.
     * </pre>
     *
     * <code>DOUBLE_ARRAY = 4;</code>
     */
    public static final int DOUBLE_ARRAY_VALUE = 4;
    /**
     *
     *
     * <pre>
     * Used for Feature that is INT64.
     * </pre>
     *
     * <code>INT64 = 9;</code>
     */
    public static final int INT64_VALUE = 9;
    /**
     *
     *
     * <pre>
     * Used for Feature that is a list of INT64.
     * </pre>
     *
     * <code>INT64_ARRAY = 10;</code>
     */
    public static final int INT64_ARRAY_VALUE = 10;
    /**
     *
     *
     * <pre>
     * Used for Feature that is string.
     * </pre>
     *
     * <code>STRING = 11;</code>
     */
    public static final int STRING_VALUE = 11;
    /**
     *
     *
     * <pre>
     * Used for Feature that is a list of String.
     * </pre>
     *
     * <code>STRING_ARRAY = 12;</code>
     */
    public static final int STRING_ARRAY_VALUE = 12;
    /**
     *
     *
     * <pre>
     * Used for Feature that is bytes.
     * </pre>
     *
     * <code>BYTES = 13;</code>
     */
    public static final int BYTES_VALUE = 13;

    public final int getNumber() {
      if (this == UNRECOGNIZED) {
        throw new java.lang.IllegalArgumentException(
            "Can't get the number of an unknown enum value.");
      }
      return value;
    }

    /**
     * @param value The numeric wire value of the corresponding enum entry.
     * @return The enum associated with the given numeric wire value.
     * @deprecated Use {@link #forNumber(int)} instead.
     */
    @java.lang.Deprecated
    public static ValueType valueOf(int value) {
      return forNumber(value);
    }

    /**
     * @param value The numeric wire value of the corresponding enum entry.
     * @return The enum associated with the given numeric wire value.
     */
    public static ValueType forNumber(int value) {
      switch (value) {
        case 0:
          return VALUE_TYPE_UNSPECIFIED;
        case 1:
          return BOOL;
        case 2:
          return BOOL_ARRAY;
        case 3:
          return DOUBLE;
        case 4:
          return DOUBLE_ARRAY;
        case 9:
          return INT64;
        case 10:
          return INT64_ARRAY;
        case 11:
          return STRING;
        case 12:
          return STRING_ARRAY;
        case 13:
          return BYTES;
        default:
          return null;
      }
    }

    public static com.google.protobuf.Internal.EnumLiteMap<ValueType> internalGetValueMap() {
      return internalValueMap;
    }

    private static final com.google.protobuf.Internal.EnumLiteMap<ValueType> internalValueMap =
        new com.google.protobuf.Internal.EnumLiteMap<ValueType>() {
          public ValueType findValueByNumber(int number) {
            return ValueType.forNumber(number);
          }
        };

    public final com.google.protobuf.Descriptors.EnumValueDescriptor getValueDescriptor() {
      if (this == UNRECOGNIZED) {
        throw new java.lang.IllegalStateException(
            "Can't get the descriptor of an unrecognized enum value.");
      }
      return getDescriptor().getValues().get(ordinal());
    }

    public final com.google.protobuf.Descriptors.EnumDescriptor getDescriptorForType() {
      return getDescriptor();
    }

    public static final com.google.protobuf.Descriptors.EnumDescriptor getDescriptor() {
      return com.google.cloud.aiplatform.v1beta1.Feature.getDescriptor().getEnumTypes().get(0);
    }

    private static final ValueType[] VALUES = values();

    public static ValueType valueOf(com.google.protobuf.Descriptors.EnumValueDescriptor desc) {
      if (desc.getType() != getDescriptor()) {
        throw new java.lang.IllegalArgumentException("EnumValueDescriptor is not for this type.");
      }
      if (desc.getIndex() == -1) {
        return UNRECOGNIZED;
      }
      return VALUES[desc.getIndex()];
    }

    private final int value;

    private ValueType(int value) {
      this.value = value;
    }

    // @@protoc_insertion_point(enum_scope:google.cloud.aiplatform.v1beta1.Feature.ValueType)
  }

  public static final int NAME_FIELD_NUMBER = 1;
  private volatile java.lang.Object name_;
  /**
   *
   *
   * <pre>
   * Immutable. Name of the Feature.
   * Format:
   * `projects/{project}/locations/{location}/featurestores/{featurestore}/entityTypes/{entity_type}/features/{feature}`
   * The last part feature is assigned by the client. The feature can be up to
   * 64 characters long and can consist only of ASCII Latin letters A-Z and a-z,
   * underscore(_), and ASCII digits 0-9 starting with a letter. The value will
   * be unique given an entity type.
   * </pre>
   *
   * <code>string name = 1 [(.google.api.field_behavior) = IMMUTABLE];</code>
   *
   * @return The name.
   */
  @java.lang.Override
  public java.lang.String getName() {
    java.lang.Object ref = name_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      name_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Immutable. Name of the Feature.
   * Format:
   * `projects/{project}/locations/{location}/featurestores/{featurestore}/entityTypes/{entity_type}/features/{feature}`
   * The last part feature is assigned by the client. The feature can be up to
   * 64 characters long and can consist only of ASCII Latin letters A-Z and a-z,
   * underscore(_), and ASCII digits 0-9 starting with a letter. The value will
   * be unique given an entity type.
   * </pre>
   *
   * <code>string name = 1 [(.google.api.field_behavior) = IMMUTABLE];</code>
   *
   * @return The bytes for name.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getNameBytes() {
    java.lang.Object ref = name_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      name_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int DESCRIPTION_FIELD_NUMBER = 2;
  private volatile java.lang.Object description_;
  /**
   *
   *
   * <pre>
   * Description of the Feature.
   * </pre>
   *
   * <code>string description = 2;</code>
   *
   * @return The description.
   */
  @java.lang.Override
  public java.lang.String getDescription() {
    java.lang.Object ref = description_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      description_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Description of the Feature.
   * </pre>
   *
   * <code>string description = 2;</code>
   *
   * @return The bytes for description.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getDescriptionBytes() {
    java.lang.Object ref = description_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      description_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int VALUE_TYPE_FIELD_NUMBER = 3;
  private int valueType_;
  /**
   *
   *
   * <pre>
   * Required. Immutable. Type of Feature value.
   * </pre>
   *
   * <code>
   * .google.cloud.aiplatform.v1beta1.Feature.ValueType value_type = 3 [(.google.api.field_behavior) = REQUIRED, (.google.api.field_behavior) = IMMUTABLE];
   * </code>
   *
   * @return The enum numeric value on the wire for valueType.
   */
  @java.lang.Override
  public int getValueTypeValue() {
    return valueType_;
  }
  /**
   *
   *
   * <pre>
   * Required. Immutable. Type of Feature value.
   * </pre>
   *
   * <code>
   * .google.cloud.aiplatform.v1beta1.Feature.ValueType value_type = 3 [(.google.api.field_behavior) = REQUIRED, (.google.api.field_behavior) = IMMUTABLE];
   * </code>
   *
   * @return The valueType.
   */
  @java.lang.Override
  public com.google.cloud.aiplatform.v1beta1.Feature.ValueType getValueType() {
    @SuppressWarnings("deprecation")
    com.google.cloud.aiplatform.v1beta1.Feature.ValueType result =
        com.google.cloud.aiplatform.v1beta1.Feature.ValueType.valueOf(valueType_);
    return result == null
        ? com.google.cloud.aiplatform.v1beta1.Feature.ValueType.UNRECOGNIZED
        : result;
  }

  public static final int CREATE_TIME_FIELD_NUMBER = 4;
  private com.google.protobuf.Timestamp createTime_;
  /**
   *
   *
   * <pre>
   * Output only. Timestamp when this EntityType was created.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp create_time = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return Whether the createTime field is set.
   */
  @java.lang.Override
  public boolean hasCreateTime() {
    return createTime_ != null;
  }
  /**
   *
   *
   * <pre>
   * Output only. Timestamp when this EntityType was created.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp create_time = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return The createTime.
   */
  @java.lang.Override
  public com.google.protobuf.Timestamp getCreateTime() {
    return createTime_ == null ? com.google.protobuf.Timestamp.getDefaultInstance() : createTime_;
  }
  /**
   *
   *
   * <pre>
   * Output only. Timestamp when this EntityType was created.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp create_time = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   */
  @java.lang.Override
  public com.google.protobuf.TimestampOrBuilder getCreateTimeOrBuilder() {
    return getCreateTime();
  }

  public static final int UPDATE_TIME_FIELD_NUMBER = 5;
  private com.google.protobuf.Timestamp updateTime_;
  /**
   *
   *
   * <pre>
   * Output only. Timestamp when this EntityType was most recently updated.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp update_time = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return Whether the updateTime field is set.
   */
  @java.lang.Override
  public boolean hasUpdateTime() {
    return updateTime_ != null;
  }
  /**
   *
   *
   * <pre>
   * Output only. Timestamp when this EntityType was most recently updated.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp update_time = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return The updateTime.
   */
  @java.lang.Override
  public com.google.protobuf.Timestamp getUpdateTime() {
    return updateTime_ == null ? com.google.protobuf.Timestamp.getDefaultInstance() : updateTime_;
  }
  /**
   *
   *
   * <pre>
   * Output only. Timestamp when this EntityType was most recently updated.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp update_time = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   */
  @java.lang.Override
  public com.google.protobuf.TimestampOrBuilder getUpdateTimeOrBuilder() {
    return getUpdateTime();
  }

  public static final int LABELS_FIELD_NUMBER = 6;

  private static final class LabelsDefaultEntryHolder {
    static final com.google.protobuf.MapEntry<java.lang.String, java.lang.String> defaultEntry =
        com.google.protobuf.MapEntry.<java.lang.String, java.lang.String>newDefaultInstance(
            com.google.cloud.aiplatform.v1beta1.FeatureProto
                .internal_static_google_cloud_aiplatform_v1beta1_Feature_LabelsEntry_descriptor,
            com.google.protobuf.WireFormat.FieldType.STRING,
            "",
            com.google.protobuf.WireFormat.FieldType.STRING,
            "");
  }

  private com.google.protobuf.MapField<java.lang.String, java.lang.String> labels_;

  private com.google.protobuf.MapField<java.lang.String, java.lang.String> internalGetLabels() {
    if (labels_ == null) {
      return com.google.protobuf.MapField.emptyMapField(LabelsDefaultEntryHolder.defaultEntry);
    }
    return labels_;
  }

  public int getLabelsCount() {
    return internalGetLabels().getMap().size();
  }
  /**
   *
   *
   * <pre>
   * Optional. The labels with user-defined metadata to organize your Features.
   * Label keys and values can be no longer than 64 characters
   * (Unicode codepoints), can only contain lowercase letters, numeric
   * characters, underscores and dashes. International characters are allowed.
   * See https://goo.gl/xmQnxf for more information on and examples of labels.
   * No more than 64 user labels can be associated with one Feature (System
   * labels are excluded)."
   * System reserved label keys are prefixed with "aiplatform.googleapis.com/"
   * and are immutable.
   * </pre>
   *
   * <code>map&lt;string, string&gt; labels = 6 [(.google.api.field_behavior) = OPTIONAL];</code>
   */
  @java.lang.Override
  public boolean containsLabels(java.lang.String key) {
    if (key == null) {
      throw new java.lang.NullPointerException();
    }
    return internalGetLabels().getMap().containsKey(key);
  }
  /** Use {@link #getLabelsMap()} instead. */
  @java.lang.Override
  @java.lang.Deprecated
  public java.util.Map<java.lang.String, java.lang.String> getLabels() {
    return getLabelsMap();
  }
  /**
   *
   *
   * <pre>
   * Optional. The labels with user-defined metadata to organize your Features.
   * Label keys and values can be no longer than 64 characters
   * (Unicode codepoints), can only contain lowercase letters, numeric
   * characters, underscores and dashes. International characters are allowed.
   * See https://goo.gl/xmQnxf for more information on and examples of labels.
   * No more than 64 user labels can be associated with one Feature (System
   * labels are excluded)."
   * System reserved label keys are prefixed with "aiplatform.googleapis.com/"
   * and are immutable.
   * </pre>
   *
   * <code>map&lt;string, string&gt; labels = 6 [(.google.api.field_behavior) = OPTIONAL];</code>
   */
  @java.lang.Override
  public java.util.Map<java.lang.String, java.lang.String> getLabelsMap() {
    return internalGetLabels().getMap();
  }
  /**
   *
   *
   * <pre>
   * Optional. The labels with user-defined metadata to organize your Features.
   * Label keys and values can be no longer than 64 characters
   * (Unicode codepoints), can only contain lowercase letters, numeric
   * characters, underscores and dashes. International characters are allowed.
   * See https://goo.gl/xmQnxf for more information on and examples of labels.
   * No more than 64 user labels can be associated with one Feature (System
   * labels are excluded)."
   * System reserved label keys are prefixed with "aiplatform.googleapis.com/"
   * and are immutable.
   * </pre>
   *
   * <code>map&lt;string, string&gt; labels = 6 [(.google.api.field_behavior) = OPTIONAL];</code>
   */
  @java.lang.Override
  public java.lang.String getLabelsOrDefault(java.lang.String key, java.lang.String defaultValue) {
    if (key == null) {
      throw new java.lang.NullPointerException();
    }
    java.util.Map<java.lang.String, java.lang.String> map = internalGetLabels().getMap();
    return map.containsKey(key) ? map.get(key) : defaultValue;
  }
  /**
   *
   *
   * <pre>
   * Optional. The labels with user-defined metadata to organize your Features.
   * Label keys and values can be no longer than 64 characters
   * (Unicode codepoints), can only contain lowercase letters, numeric
   * characters, underscores and dashes. International characters are allowed.
   * See https://goo.gl/xmQnxf for more information on and examples of labels.
   * No more than 64 user labels can be associated with one Feature (System
   * labels are excluded)."
   * System reserved label keys are prefixed with "aiplatform.googleapis.com/"
   * and are immutable.
   * </pre>
   *
   * <code>map&lt;string, string&gt; labels = 6 [(.google.api.field_behavior) = OPTIONAL];</code>
   */
  @java.lang.Override
  public java.lang.String getLabelsOrThrow(java.lang.String key) {
    if (key == null) {
      throw new java.lang.NullPointerException();
    }
    java.util.Map<java.lang.String, java.lang.String> map = internalGetLabels().getMap();
    if (!map.containsKey(key)) {
      throw new java.lang.IllegalArgumentException();
    }
    return map.get(key);
  }

  public static final int ETAG_FIELD_NUMBER = 7;
  private volatile java.lang.Object etag_;
  /**
   *
   *
   * <pre>
   * Used to perform a consistent read-modify-write updates. If not set, a blind
   * "overwrite" update happens.
   * </pre>
   *
   * <code>string etag = 7;</code>
   *
   * @return The etag.
   */
  @java.lang.Override
  public java.lang.String getEtag() {
    java.lang.Object ref = etag_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      etag_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Used to perform a consistent read-modify-write updates. If not set, a blind
   * "overwrite" update happens.
   * </pre>
   *
   * <code>string etag = 7;</code>
   *
   * @return The bytes for etag.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getEtagBytes() {
    java.lang.Object ref = etag_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      etag_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int MONITORING_CONFIG_FIELD_NUMBER = 9;
  private com.google.cloud.aiplatform.v1beta1.FeaturestoreMonitoringConfig monitoringConfig_;
  /**
   *
   *
   * <pre>
   * Optional. The custom monitoring configuration for this Feature, if not set, use the
   * monitoring_config defined for the EntityType this Feature belongs to.
   * If this is populated with
   * [FeaturestoreMonitoringConfig.disabled][] = true, snapshot analysis
   * monitoring is disabled; if
   * [FeaturestoreMonitoringConfig.monitoring_interval][] specified, snapshot
   * analysis monitoring is enabled. Otherwise, snapshot analysis monitoring
   * config is same as the EntityType's this Feature belongs to.
   * </pre>
   *
   * <code>
   * .google.cloud.aiplatform.v1beta1.FeaturestoreMonitoringConfig monitoring_config = 9 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   *
   * @return Whether the monitoringConfig field is set.
   */
  @java.lang.Override
  public boolean hasMonitoringConfig() {
    return monitoringConfig_ != null;
  }
  /**
   *
   *
   * <pre>
   * Optional. The custom monitoring configuration for this Feature, if not set, use the
   * monitoring_config defined for the EntityType this Feature belongs to.
   * If this is populated with
   * [FeaturestoreMonitoringConfig.disabled][] = true, snapshot analysis
   * monitoring is disabled; if
   * [FeaturestoreMonitoringConfig.monitoring_interval][] specified, snapshot
   * analysis monitoring is enabled. Otherwise, snapshot analysis monitoring
   * config is same as the EntityType's this Feature belongs to.
   * </pre>
   *
   * <code>
   * .google.cloud.aiplatform.v1beta1.FeaturestoreMonitoringConfig monitoring_config = 9 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   *
   * @return The monitoringConfig.
   */
  @java.lang.Override
  public com.google.cloud.aiplatform.v1beta1.FeaturestoreMonitoringConfig getMonitoringConfig() {
    return monitoringConfig_ == null
        ? com.google.cloud.aiplatform.v1beta1.FeaturestoreMonitoringConfig.getDefaultInstance()
        : monitoringConfig_;
  }
  /**
   *
   *
   * <pre>
   * Optional. The custom monitoring configuration for this Feature, if not set, use the
   * monitoring_config defined for the EntityType this Feature belongs to.
   * If this is populated with
   * [FeaturestoreMonitoringConfig.disabled][] = true, snapshot analysis
   * monitoring is disabled; if
   * [FeaturestoreMonitoringConfig.monitoring_interval][] specified, snapshot
   * analysis monitoring is enabled. Otherwise, snapshot analysis monitoring
   * config is same as the EntityType's this Feature belongs to.
   * </pre>
   *
   * <code>
   * .google.cloud.aiplatform.v1beta1.FeaturestoreMonitoringConfig monitoring_config = 9 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.aiplatform.v1beta1.FeaturestoreMonitoringConfigOrBuilder
      getMonitoringConfigOrBuilder() {
    return getMonitoringConfig();
  }

  public static final int MONITORING_STATS_FIELD_NUMBER = 10;
  private java.util.List<com.google.cloud.aiplatform.v1beta1.FeatureStatsAnomaly> monitoringStats_;
  /**
   *
   *
   * <pre>
   * Output only. A list of historical [Snapshot
   * Analysis][google.cloud.aiplatform.master.FeaturestoreMonitoringConfig.SnapshotAnalysis]
   * stats requested by user, sorted by [FeatureStatsAnomaly.start_time][google.cloud.aiplatform.v1beta1.FeatureStatsAnomaly.start_time]
   * descending.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.aiplatform.v1beta1.FeatureStatsAnomaly monitoring_stats = 10 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   */
  @java.lang.Override
  public java.util.List<com.google.cloud.aiplatform.v1beta1.FeatureStatsAnomaly>
      getMonitoringStatsList() {
    return monitoringStats_;
  }
  /**
   *
   *
   * <pre>
   * Output only. A list of historical [Snapshot
   * Analysis][google.cloud.aiplatform.master.FeaturestoreMonitoringConfig.SnapshotAnalysis]
   * stats requested by user, sorted by [FeatureStatsAnomaly.start_time][google.cloud.aiplatform.v1beta1.FeatureStatsAnomaly.start_time]
   * descending.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.aiplatform.v1beta1.FeatureStatsAnomaly monitoring_stats = 10 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   */
  @java.lang.Override
  public java.util.List<? extends com.google.cloud.aiplatform.v1beta1.FeatureStatsAnomalyOrBuilder>
      getMonitoringStatsOrBuilderList() {
    return monitoringStats_;
  }
  /**
   *
   *
   * <pre>
   * Output only. A list of historical [Snapshot
   * Analysis][google.cloud.aiplatform.master.FeaturestoreMonitoringConfig.SnapshotAnalysis]
   * stats requested by user, sorted by [FeatureStatsAnomaly.start_time][google.cloud.aiplatform.v1beta1.FeatureStatsAnomaly.start_time]
   * descending.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.aiplatform.v1beta1.FeatureStatsAnomaly monitoring_stats = 10 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   */
  @java.lang.Override
  public int getMonitoringStatsCount() {
    return monitoringStats_.size();
  }
  /**
   *
   *
   * <pre>
   * Output only. A list of historical [Snapshot
   * Analysis][google.cloud.aiplatform.master.FeaturestoreMonitoringConfig.SnapshotAnalysis]
   * stats requested by user, sorted by [FeatureStatsAnomaly.start_time][google.cloud.aiplatform.v1beta1.FeatureStatsAnomaly.start_time]
   * descending.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.aiplatform.v1beta1.FeatureStatsAnomaly monitoring_stats = 10 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.aiplatform.v1beta1.FeatureStatsAnomaly getMonitoringStats(int index) {
    return monitoringStats_.get(index);
  }
  /**
   *
   *
   * <pre>
   * Output only. A list of historical [Snapshot
   * Analysis][google.cloud.aiplatform.master.FeaturestoreMonitoringConfig.SnapshotAnalysis]
   * stats requested by user, sorted by [FeatureStatsAnomaly.start_time][google.cloud.aiplatform.v1beta1.FeatureStatsAnomaly.start_time]
   * descending.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.aiplatform.v1beta1.FeatureStatsAnomaly monitoring_stats = 10 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.aiplatform.v1beta1.FeatureStatsAnomalyOrBuilder
      getMonitoringStatsOrBuilder(int index) {
    return monitoringStats_.get(index);
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    if (!getNameBytes().isEmpty()) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 1, name_);
    }
    if (!getDescriptionBytes().isEmpty()) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 2, description_);
    }
    if (valueType_
        != com.google.cloud.aiplatform.v1beta1.Feature.ValueType.VALUE_TYPE_UNSPECIFIED
            .getNumber()) {
      output.writeEnum(3, valueType_);
    }
    if (createTime_ != null) {
      output.writeMessage(4, getCreateTime());
    }
    if (updateTime_ != null) {
      output.writeMessage(5, getUpdateTime());
    }
    com.google.protobuf.GeneratedMessageV3.serializeStringMapTo(
        output, internalGetLabels(), LabelsDefaultEntryHolder.defaultEntry, 6);
    if (!getEtagBytes().isEmpty()) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 7, etag_);
    }
    if (monitoringConfig_ != null) {
      output.writeMessage(9, getMonitoringConfig());
    }
    for (int i = 0; i < monitoringStats_.size(); i++) {
      output.writeMessage(10, monitoringStats_.get(i));
    }
    unknownFields.writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    if (!getNameBytes().isEmpty()) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(1, name_);
    }
    if (!getDescriptionBytes().isEmpty()) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(2, description_);
    }
    if (valueType_
        != com.google.cloud.aiplatform.v1beta1.Feature.ValueType.VALUE_TYPE_UNSPECIFIED
            .getNumber()) {
      size += com.google.protobuf.CodedOutputStream.computeEnumSize(3, valueType_);
    }
    if (createTime_ != null) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(4, getCreateTime());
    }
    if (updateTime_ != null) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(5, getUpdateTime());
    }
    for (java.util.Map.Entry<java.lang.String, java.lang.String> entry :
        internalGetLabels().getMap().entrySet()) {
      com.google.protobuf.MapEntry<java.lang.String, java.lang.String> labels__ =
          LabelsDefaultEntryHolder.defaultEntry
              .newBuilderForType()
              .setKey(entry.getKey())
              .setValue(entry.getValue())
              .build();
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(6, labels__);
    }
    if (!getEtagBytes().isEmpty()) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(7, etag_);
    }
    if (monitoringConfig_ != null) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(9, getMonitoringConfig());
    }
    for (int i = 0; i < monitoringStats_.size(); i++) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(10, monitoringStats_.get(i));
    }
    size += unknownFields.getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.cloud.aiplatform.v1beta1.Feature)) {
      return super.equals(obj);
    }
    com.google.cloud.aiplatform.v1beta1.Feature other =
        (com.google.cloud.aiplatform.v1beta1.Feature) obj;

    if (!getName().equals(other.getName())) return false;
    if (!getDescription().equals(other.getDescription())) return false;
    if (valueType_ != other.valueType_) return false;
    if (hasCreateTime() != other.hasCreateTime()) return false;
    if (hasCreateTime()) {
      if (!getCreateTime().equals(other.getCreateTime())) return false;
    }
    if (hasUpdateTime() != other.hasUpdateTime()) return false;
    if (hasUpdateTime()) {
      if (!getUpdateTime().equals(other.getUpdateTime())) return false;
    }
    if (!internalGetLabels().equals(other.internalGetLabels())) return false;
    if (!getEtag().equals(other.getEtag())) return false;
    if (hasMonitoringConfig() != other.hasMonitoringConfig()) return false;
    if (hasMonitoringConfig()) {
      if (!getMonitoringConfig().equals(other.getMonitoringConfig())) return false;
    }
    if (!getMonitoringStatsList().equals(other.getMonitoringStatsList())) return false;
    if (!unknownFields.equals(other.unknownFields)) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    hash = (37 * hash) + NAME_FIELD_NUMBER;
    hash = (53 * hash) + getName().hashCode();
    hash = (37 * hash) + DESCRIPTION_FIELD_NUMBER;
    hash = (53 * hash) + getDescription().hashCode();
    hash = (37 * hash) + VALUE_TYPE_FIELD_NUMBER;
    hash = (53 * hash) + valueType_;
    if (hasCreateTime()) {
      hash = (37 * hash) + CREATE_TIME_FIELD_NUMBER;
      hash = (53 * hash) + getCreateTime().hashCode();
    }
    if (hasUpdateTime()) {
      hash = (37 * hash) + UPDATE_TIME_FIELD_NUMBER;
      hash = (53 * hash) + getUpdateTime().hashCode();
    }
    if (!internalGetLabels().getMap().isEmpty()) {
      hash = (37 * hash) + LABELS_FIELD_NUMBER;
      hash = (53 * hash) + internalGetLabels().hashCode();
    }
    hash = (37 * hash) + ETAG_FIELD_NUMBER;
    hash = (53 * hash) + getEtag().hashCode();
    if (hasMonitoringConfig()) {
      hash = (37 * hash) + MONITORING_CONFIG_FIELD_NUMBER;
      hash = (53 * hash) + getMonitoringConfig().hashCode();
    }
    if (getMonitoringStatsCount() > 0) {
      hash = (37 * hash) + MONITORING_STATS_FIELD_NUMBER;
      hash = (53 * hash) + getMonitoringStatsList().hashCode();
    }
    hash = (29 * hash) + unknownFields.hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.cloud.aiplatform.v1beta1.Feature parseFrom(java.nio.ByteBuffer data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.aiplatform.v1beta1.Feature parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.aiplatform.v1beta1.Feature parseFrom(
      com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.aiplatform.v1beta1.Feature parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.aiplatform.v1beta1.Feature parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.aiplatform.v1beta1.Feature parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.aiplatform.v1beta1.Feature parseFrom(java.io.InputStream input)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.aiplatform.v1beta1.Feature parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.aiplatform.v1beta1.Feature parseDelimitedFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.cloud.aiplatform.v1beta1.Feature parseDelimitedFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.aiplatform.v1beta1.Feature parseFrom(
      com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.aiplatform.v1beta1.Feature parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(com.google.cloud.aiplatform.v1beta1.Feature prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }
  /**
   *
   *
   * <pre>
   * Feature Metadata information that describes an attribute of an entity type.
   * For example, apple is an entity type, and color is a feature that describes
   * apple.
   * </pre>
   *
   * Protobuf type {@code google.cloud.aiplatform.v1beta1.Feature}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.cloud.aiplatform.v1beta1.Feature)
      com.google.cloud.aiplatform.v1beta1.FeatureOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.aiplatform.v1beta1.FeatureProto
          .internal_static_google_cloud_aiplatform_v1beta1_Feature_descriptor;
    }

    @SuppressWarnings({"rawtypes"})
    protected com.google.protobuf.MapField internalGetMapField(int number) {
      switch (number) {
        case 6:
          return internalGetLabels();
        default:
          throw new RuntimeException("Invalid map field number: " + number);
      }
    }

    @SuppressWarnings({"rawtypes"})
    protected com.google.protobuf.MapField internalGetMutableMapField(int number) {
      switch (number) {
        case 6:
          return internalGetMutableLabels();
        default:
          throw new RuntimeException("Invalid map field number: " + number);
      }
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.aiplatform.v1beta1.FeatureProto
          .internal_static_google_cloud_aiplatform_v1beta1_Feature_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.aiplatform.v1beta1.Feature.class,
              com.google.cloud.aiplatform.v1beta1.Feature.Builder.class);
    }

    // Construct using com.google.cloud.aiplatform.v1beta1.Feature.newBuilder()
    private Builder() {
      maybeForceBuilderInitialization();
    }

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
      maybeForceBuilderInitialization();
    }

    private void maybeForceBuilderInitialization() {
      if (com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders) {
        getMonitoringStatsFieldBuilder();
      }
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      name_ = "";

      description_ = "";

      valueType_ = 0;

      if (createTimeBuilder_ == null) {
        createTime_ = null;
      } else {
        createTime_ = null;
        createTimeBuilder_ = null;
      }
      if (updateTimeBuilder_ == null) {
        updateTime_ = null;
      } else {
        updateTime_ = null;
        updateTimeBuilder_ = null;
      }
      internalGetMutableLabels().clear();
      etag_ = "";

      if (monitoringConfigBuilder_ == null) {
        monitoringConfig_ = null;
      } else {
        monitoringConfig_ = null;
        monitoringConfigBuilder_ = null;
      }
      if (monitoringStatsBuilder_ == null) {
        monitoringStats_ = java.util.Collections.emptyList();
        bitField0_ = (bitField0_ & ~0x00000002);
      } else {
        monitoringStatsBuilder_.clear();
      }
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.cloud.aiplatform.v1beta1.FeatureProto
          .internal_static_google_cloud_aiplatform_v1beta1_Feature_descriptor;
    }

    @java.lang.Override
    public com.google.cloud.aiplatform.v1beta1.Feature getDefaultInstanceForType() {
      return com.google.cloud.aiplatform.v1beta1.Feature.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.cloud.aiplatform.v1beta1.Feature build() {
      com.google.cloud.aiplatform.v1beta1.Feature result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.cloud.aiplatform.v1beta1.Feature buildPartial() {
      com.google.cloud.aiplatform.v1beta1.Feature result =
          new com.google.cloud.aiplatform.v1beta1.Feature(this);
      int from_bitField0_ = bitField0_;
      result.name_ = name_;
      result.description_ = description_;
      result.valueType_ = valueType_;
      if (createTimeBuilder_ == null) {
        result.createTime_ = createTime_;
      } else {
        result.createTime_ = createTimeBuilder_.build();
      }
      if (updateTimeBuilder_ == null) {
        result.updateTime_ = updateTime_;
      } else {
        result.updateTime_ = updateTimeBuilder_.build();
      }
      result.labels_ = internalGetLabels();
      result.labels_.makeImmutable();
      result.etag_ = etag_;
      if (monitoringConfigBuilder_ == null) {
        result.monitoringConfig_ = monitoringConfig_;
      } else {
        result.monitoringConfig_ = monitoringConfigBuilder_.build();
      }
      if (monitoringStatsBuilder_ == null) {
        if (((bitField0_ & 0x00000002) != 0)) {
          monitoringStats_ = java.util.Collections.unmodifiableList(monitoringStats_);
          bitField0_ = (bitField0_ & ~0x00000002);
        }
        result.monitoringStats_ = monitoringStats_;
      } else {
        result.monitoringStats_ = monitoringStatsBuilder_.build();
      }
      onBuilt();
      return result;
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.cloud.aiplatform.v1beta1.Feature) {
        return mergeFrom((com.google.cloud.aiplatform.v1beta1.Feature) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(com.google.cloud.aiplatform.v1beta1.Feature other) {
      if (other == com.google.cloud.aiplatform.v1beta1.Feature.getDefaultInstance()) return this;
      if (!other.getName().isEmpty()) {
        name_ = other.name_;
        onChanged();
      }
      if (!other.getDescription().isEmpty()) {
        description_ = other.description_;
        onChanged();
      }
      if (other.valueType_ != 0) {
        setValueTypeValue(other.getValueTypeValue());
      }
      if (other.hasCreateTime()) {
        mergeCreateTime(other.getCreateTime());
      }
      if (other.hasUpdateTime()) {
        mergeUpdateTime(other.getUpdateTime());
      }
      internalGetMutableLabels().mergeFrom(other.internalGetLabels());
      if (!other.getEtag().isEmpty()) {
        etag_ = other.etag_;
        onChanged();
      }
      if (other.hasMonitoringConfig()) {
        mergeMonitoringConfig(other.getMonitoringConfig());
      }
      if (monitoringStatsBuilder_ == null) {
        if (!other.monitoringStats_.isEmpty()) {
          if (monitoringStats_.isEmpty()) {
            monitoringStats_ = other.monitoringStats_;
            bitField0_ = (bitField0_ & ~0x00000002);
          } else {
            ensureMonitoringStatsIsMutable();
            monitoringStats_.addAll(other.monitoringStats_);
          }
          onChanged();
        }
      } else {
        if (!other.monitoringStats_.isEmpty()) {
          if (monitoringStatsBuilder_.isEmpty()) {
            monitoringStatsBuilder_.dispose();
            monitoringStatsBuilder_ = null;
            monitoringStats_ = other.monitoringStats_;
            bitField0_ = (bitField0_ & ~0x00000002);
            monitoringStatsBuilder_ =
                com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders
                    ? getMonitoringStatsFieldBuilder()
                    : null;
          } else {
            monitoringStatsBuilder_.addAllMessages(other.monitoringStats_);
          }
        }
      }
      this.mergeUnknownFields(other.unknownFields);
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      com.google.cloud.aiplatform.v1beta1.Feature parsedMessage = null;
      try {
        parsedMessage = PARSER.parsePartialFrom(input, extensionRegistry);
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        parsedMessage = (com.google.cloud.aiplatform.v1beta1.Feature) e.getUnfinishedMessage();
        throw e.unwrapIOException();
      } finally {
        if (parsedMessage != null) {
          mergeFrom(parsedMessage);
        }
      }
      return this;
    }

    private int bitField0_;

    private java.lang.Object name_ = "";
    /**
     *
     *
     * <pre>
     * Immutable. Name of the Feature.
     * Format:
     * `projects/{project}/locations/{location}/featurestores/{featurestore}/entityTypes/{entity_type}/features/{feature}`
     * The last part feature is assigned by the client. The feature can be up to
     * 64 characters long and can consist only of ASCII Latin letters A-Z and a-z,
     * underscore(_), and ASCII digits 0-9 starting with a letter. The value will
     * be unique given an entity type.
     * </pre>
     *
     * <code>string name = 1 [(.google.api.field_behavior) = IMMUTABLE];</code>
     *
     * @return The name.
     */
    public java.lang.String getName() {
      java.lang.Object ref = name_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        name_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Immutable. Name of the Feature.
     * Format:
     * `projects/{project}/locations/{location}/featurestores/{featurestore}/entityTypes/{entity_type}/features/{feature}`
     * The last part feature is assigned by the client. The feature can be up to
     * 64 characters long and can consist only of ASCII Latin letters A-Z and a-z,
     * underscore(_), and ASCII digits 0-9 starting with a letter. The value will
     * be unique given an entity type.
     * </pre>
     *
     * <code>string name = 1 [(.google.api.field_behavior) = IMMUTABLE];</code>
     *
     * @return The bytes for name.
     */
    public com.google.protobuf.ByteString getNameBytes() {
      java.lang.Object ref = name_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        name_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Immutable. Name of the Feature.
     * Format:
     * `projects/{project}/locations/{location}/featurestores/{featurestore}/entityTypes/{entity_type}/features/{feature}`
     * The last part feature is assigned by the client. The feature can be up to
     * 64 characters long and can consist only of ASCII Latin letters A-Z and a-z,
     * underscore(_), and ASCII digits 0-9 starting with a letter. The value will
     * be unique given an entity type.
     * </pre>
     *
     * <code>string name = 1 [(.google.api.field_behavior) = IMMUTABLE];</code>
     *
     * @param value The name to set.
     * @return This builder for chaining.
     */
    public Builder setName(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }

      name_ = value;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Immutable. Name of the Feature.
     * Format:
     * `projects/{project}/locations/{location}/featurestores/{featurestore}/entityTypes/{entity_type}/features/{feature}`
     * The last part feature is assigned by the client. The feature can be up to
     * 64 characters long and can consist only of ASCII Latin letters A-Z and a-z,
     * underscore(_), and ASCII digits 0-9 starting with a letter. The value will
     * be unique given an entity type.
     * </pre>
     *
     * <code>string name = 1 [(.google.api.field_behavior) = IMMUTABLE];</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearName() {

      name_ = getDefaultInstance().getName();
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Immutable. Name of the Feature.
     * Format:
     * `projects/{project}/locations/{location}/featurestores/{featurestore}/entityTypes/{entity_type}/features/{feature}`
     * The last part feature is assigned by the client. The feature can be up to
     * 64 characters long and can consist only of ASCII Latin letters A-Z and a-z,
     * underscore(_), and ASCII digits 0-9 starting with a letter. The value will
     * be unique given an entity type.
     * </pre>
     *
     * <code>string name = 1 [(.google.api.field_behavior) = IMMUTABLE];</code>
     *
     * @param value The bytes for name to set.
     * @return This builder for chaining.
     */
    public Builder setNameBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);

      name_ = value;
      onChanged();
      return this;
    }

    private java.lang.Object description_ = "";
    /**
     *
     *
     * <pre>
     * Description of the Feature.
     * </pre>
     *
     * <code>string description = 2;</code>
     *
     * @return The description.
     */
    public java.lang.String getDescription() {
      java.lang.Object ref = description_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        description_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Description of the Feature.
     * </pre>
     *
     * <code>string description = 2;</code>
     *
     * @return The bytes for description.
     */
    public com.google.protobuf.ByteString getDescriptionBytes() {
      java.lang.Object ref = description_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        description_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Description of the Feature.
     * </pre>
     *
     * <code>string description = 2;</code>
     *
     * @param value The description to set.
     * @return This builder for chaining.
     */
    public Builder setDescription(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }

      description_ = value;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Description of the Feature.
     * </pre>
     *
     * <code>string description = 2;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearDescription() {

      description_ = getDefaultInstance().getDescription();
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Description of the Feature.
     * </pre>
     *
     * <code>string description = 2;</code>
     *
     * @param value The bytes for description to set.
     * @return This builder for chaining.
     */
    public Builder setDescriptionBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);

      description_ = value;
      onChanged();
      return this;
    }

    private int valueType_ = 0;
    /**
     *
     *
     * <pre>
     * Required. Immutable. Type of Feature value.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.Feature.ValueType value_type = 3 [(.google.api.field_behavior) = REQUIRED, (.google.api.field_behavior) = IMMUTABLE];
     * </code>
     *
     * @return The enum numeric value on the wire for valueType.
     */
    @java.lang.Override
    public int getValueTypeValue() {
      return valueType_;
    }
    /**
     *
     *
     * <pre>
     * Required. Immutable. Type of Feature value.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.Feature.ValueType value_type = 3 [(.google.api.field_behavior) = REQUIRED, (.google.api.field_behavior) = IMMUTABLE];
     * </code>
     *
     * @param value The enum numeric value on the wire for valueType to set.
     * @return This builder for chaining.
     */
    public Builder setValueTypeValue(int value) {

      valueType_ = value;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. Immutable. Type of Feature value.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.Feature.ValueType value_type = 3 [(.google.api.field_behavior) = REQUIRED, (.google.api.field_behavior) = IMMUTABLE];
     * </code>
     *
     * @return The valueType.
     */
    @java.lang.Override
    public com.google.cloud.aiplatform.v1beta1.Feature.ValueType getValueType() {
      @SuppressWarnings("deprecation")
      com.google.cloud.aiplatform.v1beta1.Feature.ValueType result =
          com.google.cloud.aiplatform.v1beta1.Feature.ValueType.valueOf(valueType_);
      return result == null
          ? com.google.cloud.aiplatform.v1beta1.Feature.ValueType.UNRECOGNIZED
          : result;
    }
    /**
     *
     *
     * <pre>
     * Required. Immutable. Type of Feature value.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.Feature.ValueType value_type = 3 [(.google.api.field_behavior) = REQUIRED, (.google.api.field_behavior) = IMMUTABLE];
     * </code>
     *
     * @param value The valueType to set.
     * @return This builder for chaining.
     */
    public Builder setValueType(com.google.cloud.aiplatform.v1beta1.Feature.ValueType value) {
      if (value == null) {
        throw new NullPointerException();
      }

      valueType_ = value.getNumber();
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. Immutable. Type of Feature value.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.Feature.ValueType value_type = 3 [(.google.api.field_behavior) = REQUIRED, (.google.api.field_behavior) = IMMUTABLE];
     * </code>
     *
     * @return This builder for chaining.
     */
    public Builder clearValueType() {

      valueType_ = 0;
      onChanged();
      return this;
    }

    private com.google.protobuf.Timestamp createTime_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Timestamp,
            com.google.protobuf.Timestamp.Builder,
            com.google.protobuf.TimestampOrBuilder>
        createTimeBuilder_;
    /**
     *
     *
     * <pre>
     * Output only. Timestamp when this EntityType was created.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp create_time = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return Whether the createTime field is set.
     */
    public boolean hasCreateTime() {
      return createTimeBuilder_ != null || createTime_ != null;
    }
    /**
     *
     *
     * <pre>
     * Output only. Timestamp when this EntityType was created.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp create_time = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return The createTime.
     */
    public com.google.protobuf.Timestamp getCreateTime() {
      if (createTimeBuilder_ == null) {
        return createTime_ == null
            ? com.google.protobuf.Timestamp.getDefaultInstance()
            : createTime_;
      } else {
        return createTimeBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. Timestamp when this EntityType was created.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp create_time = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder setCreateTime(com.google.protobuf.Timestamp value) {
      if (createTimeBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        createTime_ = value;
        onChanged();
      } else {
        createTimeBuilder_.setMessage(value);
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Timestamp when this EntityType was created.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp create_time = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder setCreateTime(com.google.protobuf.Timestamp.Builder builderForValue) {
      if (createTimeBuilder_ == null) {
        createTime_ = builderForValue.build();
        onChanged();
      } else {
        createTimeBuilder_.setMessage(builderForValue.build());
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Timestamp when this EntityType was created.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp create_time = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder mergeCreateTime(com.google.protobuf.Timestamp value) {
      if (createTimeBuilder_ == null) {
        if (createTime_ != null) {
          createTime_ =
              com.google.protobuf.Timestamp.newBuilder(createTime_).mergeFrom(value).buildPartial();
        } else {
          createTime_ = value;
        }
        onChanged();
      } else {
        createTimeBuilder_.mergeFrom(value);
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Timestamp when this EntityType was created.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp create_time = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder clearCreateTime() {
      if (createTimeBuilder_ == null) {
        createTime_ = null;
        onChanged();
      } else {
        createTime_ = null;
        createTimeBuilder_ = null;
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Timestamp when this EntityType was created.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp create_time = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.protobuf.Timestamp.Builder getCreateTimeBuilder() {

      onChanged();
      return getCreateTimeFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Output only. Timestamp when this EntityType was created.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp create_time = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.protobuf.TimestampOrBuilder getCreateTimeOrBuilder() {
      if (createTimeBuilder_ != null) {
        return createTimeBuilder_.getMessageOrBuilder();
      } else {
        return createTime_ == null
            ? com.google.protobuf.Timestamp.getDefaultInstance()
            : createTime_;
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. Timestamp when this EntityType was created.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp create_time = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Timestamp,
            com.google.protobuf.Timestamp.Builder,
            com.google.protobuf.TimestampOrBuilder>
        getCreateTimeFieldBuilder() {
      if (createTimeBuilder_ == null) {
        createTimeBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.protobuf.Timestamp,
                com.google.protobuf.Timestamp.Builder,
                com.google.protobuf.TimestampOrBuilder>(
                getCreateTime(), getParentForChildren(), isClean());
        createTime_ = null;
      }
      return createTimeBuilder_;
    }

    private com.google.protobuf.Timestamp updateTime_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Timestamp,
            com.google.protobuf.Timestamp.Builder,
            com.google.protobuf.TimestampOrBuilder>
        updateTimeBuilder_;
    /**
     *
     *
     * <pre>
     * Output only. Timestamp when this EntityType was most recently updated.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp update_time = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return Whether the updateTime field is set.
     */
    public boolean hasUpdateTime() {
      return updateTimeBuilder_ != null || updateTime_ != null;
    }
    /**
     *
     *
     * <pre>
     * Output only. Timestamp when this EntityType was most recently updated.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp update_time = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return The updateTime.
     */
    public com.google.protobuf.Timestamp getUpdateTime() {
      if (updateTimeBuilder_ == null) {
        return updateTime_ == null
            ? com.google.protobuf.Timestamp.getDefaultInstance()
            : updateTime_;
      } else {
        return updateTimeBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. Timestamp when this EntityType was most recently updated.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp update_time = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder setUpdateTime(com.google.protobuf.Timestamp value) {
      if (updateTimeBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        updateTime_ = value;
        onChanged();
      } else {
        updateTimeBuilder_.setMessage(value);
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Timestamp when this EntityType was most recently updated.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp update_time = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder setUpdateTime(com.google.protobuf.Timestamp.Builder builderForValue) {
      if (updateTimeBuilder_ == null) {
        updateTime_ = builderForValue.build();
        onChanged();
      } else {
        updateTimeBuilder_.setMessage(builderForValue.build());
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Timestamp when this EntityType was most recently updated.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp update_time = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder mergeUpdateTime(com.google.protobuf.Timestamp value) {
      if (updateTimeBuilder_ == null) {
        if (updateTime_ != null) {
          updateTime_ =
              com.google.protobuf.Timestamp.newBuilder(updateTime_).mergeFrom(value).buildPartial();
        } else {
          updateTime_ = value;
        }
        onChanged();
      } else {
        updateTimeBuilder_.mergeFrom(value);
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Timestamp when this EntityType was most recently updated.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp update_time = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder clearUpdateTime() {
      if (updateTimeBuilder_ == null) {
        updateTime_ = null;
        onChanged();
      } else {
        updateTime_ = null;
        updateTimeBuilder_ = null;
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Timestamp when this EntityType was most recently updated.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp update_time = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.protobuf.Timestamp.Builder getUpdateTimeBuilder() {

      onChanged();
      return getUpdateTimeFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Output only. Timestamp when this EntityType was most recently updated.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp update_time = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.protobuf.TimestampOrBuilder getUpdateTimeOrBuilder() {
      if (updateTimeBuilder_ != null) {
        return updateTimeBuilder_.getMessageOrBuilder();
      } else {
        return updateTime_ == null
            ? com.google.protobuf.Timestamp.getDefaultInstance()
            : updateTime_;
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. Timestamp when this EntityType was most recently updated.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp update_time = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Timestamp,
            com.google.protobuf.Timestamp.Builder,
            com.google.protobuf.TimestampOrBuilder>
        getUpdateTimeFieldBuilder() {
      if (updateTimeBuilder_ == null) {
        updateTimeBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.protobuf.Timestamp,
                com.google.protobuf.Timestamp.Builder,
                com.google.protobuf.TimestampOrBuilder>(
                getUpdateTime(), getParentForChildren(), isClean());
        updateTime_ = null;
      }
      return updateTimeBuilder_;
    }

    private com.google.protobuf.MapField<java.lang.String, java.lang.String> labels_;

    private com.google.protobuf.MapField<java.lang.String, java.lang.String> internalGetLabels() {
      if (labels_ == null) {
        return com.google.protobuf.MapField.emptyMapField(LabelsDefaultEntryHolder.defaultEntry);
      }
      return labels_;
    }

    private com.google.protobuf.MapField<java.lang.String, java.lang.String>
        internalGetMutableLabels() {
      onChanged();
      ;
      if (labels_ == null) {
        labels_ = com.google.protobuf.MapField.newMapField(LabelsDefaultEntryHolder.defaultEntry);
      }
      if (!labels_.isMutable()) {
        labels_ = labels_.copy();
      }
      return labels_;
    }

    public int getLabelsCount() {
      return internalGetLabels().getMap().size();
    }
    /**
     *
     *
     * <pre>
     * Optional. The labels with user-defined metadata to organize your Features.
     * Label keys and values can be no longer than 64 characters
     * (Unicode codepoints), can only contain lowercase letters, numeric
     * characters, underscores and dashes. International characters are allowed.
     * See https://goo.gl/xmQnxf for more information on and examples of labels.
     * No more than 64 user labels can be associated with one Feature (System
     * labels are excluded)."
     * System reserved label keys are prefixed with "aiplatform.googleapis.com/"
     * and are immutable.
     * </pre>
     *
     * <code>map&lt;string, string&gt; labels = 6 [(.google.api.field_behavior) = OPTIONAL];</code>
     */
    @java.lang.Override
    public boolean containsLabels(java.lang.String key) {
      if (key == null) {
        throw new java.lang.NullPointerException();
      }
      return internalGetLabels().getMap().containsKey(key);
    }
    /** Use {@link #getLabelsMap()} instead. */
    @java.lang.Override
    @java.lang.Deprecated
    public java.util.Map<java.lang.String, java.lang.String> getLabels() {
      return getLabelsMap();
    }
    /**
     *
     *
     * <pre>
     * Optional. The labels with user-defined metadata to organize your Features.
     * Label keys and values can be no longer than 64 characters
     * (Unicode codepoints), can only contain lowercase letters, numeric
     * characters, underscores and dashes. International characters are allowed.
     * See https://goo.gl/xmQnxf for more information on and examples of labels.
     * No more than 64 user labels can be associated with one Feature (System
     * labels are excluded)."
     * System reserved label keys are prefixed with "aiplatform.googleapis.com/"
     * and are immutable.
     * </pre>
     *
     * <code>map&lt;string, string&gt; labels = 6 [(.google.api.field_behavior) = OPTIONAL];</code>
     */
    @java.lang.Override
    public java.util.Map<java.lang.String, java.lang.String> getLabelsMap() {
      return internalGetLabels().getMap();
    }
    /**
     *
     *
     * <pre>
     * Optional. The labels with user-defined metadata to organize your Features.
     * Label keys and values can be no longer than 64 characters
     * (Unicode codepoints), can only contain lowercase letters, numeric
     * characters, underscores and dashes. International characters are allowed.
     * See https://goo.gl/xmQnxf for more information on and examples of labels.
     * No more than 64 user labels can be associated with one Feature (System
     * labels are excluded)."
     * System reserved label keys are prefixed with "aiplatform.googleapis.com/"
     * and are immutable.
     * </pre>
     *
     * <code>map&lt;string, string&gt; labels = 6 [(.google.api.field_behavior) = OPTIONAL];</code>
     */
    @java.lang.Override
    public java.lang.String getLabelsOrDefault(
        java.lang.String key, java.lang.String defaultValue) {
      if (key == null) {
        throw new java.lang.NullPointerException();
      }
      java.util.Map<java.lang.String, java.lang.String> map = internalGetLabels().getMap();
      return map.containsKey(key) ? map.get(key) : defaultValue;
    }
    /**
     *
     *
     * <pre>
     * Optional. The labels with user-defined metadata to organize your Features.
     * Label keys and values can be no longer than 64 characters
     * (Unicode codepoints), can only contain lowercase letters, numeric
     * characters, underscores and dashes. International characters are allowed.
     * See https://goo.gl/xmQnxf for more information on and examples of labels.
     * No more than 64 user labels can be associated with one Feature (System
     * labels are excluded)."
     * System reserved label keys are prefixed with "aiplatform.googleapis.com/"
     * and are immutable.
     * </pre>
     *
     * <code>map&lt;string, string&gt; labels = 6 [(.google.api.field_behavior) = OPTIONAL];</code>
     */
    @java.lang.Override
    public java.lang.String getLabelsOrThrow(java.lang.String key) {
      if (key == null) {
        throw new java.lang.NullPointerException();
      }
      java.util.Map<java.lang.String, java.lang.String> map = internalGetLabels().getMap();
      if (!map.containsKey(key)) {
        throw new java.lang.IllegalArgumentException();
      }
      return map.get(key);
    }

    public Builder clearLabels() {
      internalGetMutableLabels().getMutableMap().clear();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. The labels with user-defined metadata to organize your Features.
     * Label keys and values can be no longer than 64 characters
     * (Unicode codepoints), can only contain lowercase letters, numeric
     * characters, underscores and dashes. International characters are allowed.
     * See https://goo.gl/xmQnxf for more information on and examples of labels.
     * No more than 64 user labels can be associated with one Feature (System
     * labels are excluded)."
     * System reserved label keys are prefixed with "aiplatform.googleapis.com/"
     * and are immutable.
     * </pre>
     *
     * <code>map&lt;string, string&gt; labels = 6 [(.google.api.field_behavior) = OPTIONAL];</code>
     */
    public Builder removeLabels(java.lang.String key) {
      if (key == null) {
        throw new java.lang.NullPointerException();
      }
      internalGetMutableLabels().getMutableMap().remove(key);
      return this;
    }
    /** Use alternate mutation accessors instead. */
    @java.lang.Deprecated
    public java.util.Map<java.lang.String, java.lang.String> getMutableLabels() {
      return internalGetMutableLabels().getMutableMap();
    }
    /**
     *
     *
     * <pre>
     * Optional. The labels with user-defined metadata to organize your Features.
     * Label keys and values can be no longer than 64 characters
     * (Unicode codepoints), can only contain lowercase letters, numeric
     * characters, underscores and dashes. International characters are allowed.
     * See https://goo.gl/xmQnxf for more information on and examples of labels.
     * No more than 64 user labels can be associated with one Feature (System
     * labels are excluded)."
     * System reserved label keys are prefixed with "aiplatform.googleapis.com/"
     * and are immutable.
     * </pre>
     *
     * <code>map&lt;string, string&gt; labels = 6 [(.google.api.field_behavior) = OPTIONAL];</code>
     */
    public Builder putLabels(java.lang.String key, java.lang.String value) {
      if (key == null) {
        throw new java.lang.NullPointerException();
      }
      if (value == null) {
        throw new java.lang.NullPointerException();
      }
      internalGetMutableLabels().getMutableMap().put(key, value);
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. The labels with user-defined metadata to organize your Features.
     * Label keys and values can be no longer than 64 characters
     * (Unicode codepoints), can only contain lowercase letters, numeric
     * characters, underscores and dashes. International characters are allowed.
     * See https://goo.gl/xmQnxf for more information on and examples of labels.
     * No more than 64 user labels can be associated with one Feature (System
     * labels are excluded)."
     * System reserved label keys are prefixed with "aiplatform.googleapis.com/"
     * and are immutable.
     * </pre>
     *
     * <code>map&lt;string, string&gt; labels = 6 [(.google.api.field_behavior) = OPTIONAL];</code>
     */
    public Builder putAllLabels(java.util.Map<java.lang.String, java.lang.String> values) {
      internalGetMutableLabels().getMutableMap().putAll(values);
      return this;
    }

    private java.lang.Object etag_ = "";
    /**
     *
     *
     * <pre>
     * Used to perform a consistent read-modify-write updates. If not set, a blind
     * "overwrite" update happens.
     * </pre>
     *
     * <code>string etag = 7;</code>
     *
     * @return The etag.
     */
    public java.lang.String getEtag() {
      java.lang.Object ref = etag_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        etag_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Used to perform a consistent read-modify-write updates. If not set, a blind
     * "overwrite" update happens.
     * </pre>
     *
     * <code>string etag = 7;</code>
     *
     * @return The bytes for etag.
     */
    public com.google.protobuf.ByteString getEtagBytes() {
      java.lang.Object ref = etag_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        etag_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Used to perform a consistent read-modify-write updates. If not set, a blind
     * "overwrite" update happens.
     * </pre>
     *
     * <code>string etag = 7;</code>
     *
     * @param value The etag to set.
     * @return This builder for chaining.
     */
    public Builder setEtag(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }

      etag_ = value;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Used to perform a consistent read-modify-write updates. If not set, a blind
     * "overwrite" update happens.
     * </pre>
     *
     * <code>string etag = 7;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearEtag() {

      etag_ = getDefaultInstance().getEtag();
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Used to perform a consistent read-modify-write updates. If not set, a blind
     * "overwrite" update happens.
     * </pre>
     *
     * <code>string etag = 7;</code>
     *
     * @param value The bytes for etag to set.
     * @return This builder for chaining.
     */
    public Builder setEtagBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);

      etag_ = value;
      onChanged();
      return this;
    }

    private com.google.cloud.aiplatform.v1beta1.FeaturestoreMonitoringConfig monitoringConfig_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.aiplatform.v1beta1.FeaturestoreMonitoringConfig,
            com.google.cloud.aiplatform.v1beta1.FeaturestoreMonitoringConfig.Builder,
            com.google.cloud.aiplatform.v1beta1.FeaturestoreMonitoringConfigOrBuilder>
        monitoringConfigBuilder_;
    /**
     *
     *
     * <pre>
     * Optional. The custom monitoring configuration for this Feature, if not set, use the
     * monitoring_config defined for the EntityType this Feature belongs to.
     * If this is populated with
     * [FeaturestoreMonitoringConfig.disabled][] = true, snapshot analysis
     * monitoring is disabled; if
     * [FeaturestoreMonitoringConfig.monitoring_interval][] specified, snapshot
     * analysis monitoring is enabled. Otherwise, snapshot analysis monitoring
     * config is same as the EntityType's this Feature belongs to.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.FeaturestoreMonitoringConfig monitoring_config = 9 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return Whether the monitoringConfig field is set.
     */
    public boolean hasMonitoringConfig() {
      return monitoringConfigBuilder_ != null || monitoringConfig_ != null;
    }
    /**
     *
     *
     * <pre>
     * Optional. The custom monitoring configuration for this Feature, if not set, use the
     * monitoring_config defined for the EntityType this Feature belongs to.
     * If this is populated with
     * [FeaturestoreMonitoringConfig.disabled][] = true, snapshot analysis
     * monitoring is disabled; if
     * [FeaturestoreMonitoringConfig.monitoring_interval][] specified, snapshot
     * analysis monitoring is enabled. Otherwise, snapshot analysis monitoring
     * config is same as the EntityType's this Feature belongs to.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.FeaturestoreMonitoringConfig monitoring_config = 9 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return The monitoringConfig.
     */
    public com.google.cloud.aiplatform.v1beta1.FeaturestoreMonitoringConfig getMonitoringConfig() {
      if (monitoringConfigBuilder_ == null) {
        return monitoringConfig_ == null
            ? com.google.cloud.aiplatform.v1beta1.FeaturestoreMonitoringConfig.getDefaultInstance()
            : monitoringConfig_;
      } else {
        return monitoringConfigBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Optional. The custom monitoring configuration for this Feature, if not set, use the
     * monitoring_config defined for the EntityType this Feature belongs to.
     * If this is populated with
     * [FeaturestoreMonitoringConfig.disabled][] = true, snapshot analysis
     * monitoring is disabled; if
     * [FeaturestoreMonitoringConfig.monitoring_interval][] specified, snapshot
     * analysis monitoring is enabled. Otherwise, snapshot analysis monitoring
     * config is same as the EntityType's this Feature belongs to.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.FeaturestoreMonitoringConfig monitoring_config = 9 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder setMonitoringConfig(
        com.google.cloud.aiplatform.v1beta1.FeaturestoreMonitoringConfig value) {
      if (monitoringConfigBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        monitoringConfig_ = value;
        onChanged();
      } else {
        monitoringConfigBuilder_.setMessage(value);
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. The custom monitoring configuration for this Feature, if not set, use the
     * monitoring_config defined for the EntityType this Feature belongs to.
     * If this is populated with
     * [FeaturestoreMonitoringConfig.disabled][] = true, snapshot analysis
     * monitoring is disabled; if
     * [FeaturestoreMonitoringConfig.monitoring_interval][] specified, snapshot
     * analysis monitoring is enabled. Otherwise, snapshot analysis monitoring
     * config is same as the EntityType's this Feature belongs to.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.FeaturestoreMonitoringConfig monitoring_config = 9 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder setMonitoringConfig(
        com.google.cloud.aiplatform.v1beta1.FeaturestoreMonitoringConfig.Builder builderForValue) {
      if (monitoringConfigBuilder_ == null) {
        monitoringConfig_ = builderForValue.build();
        onChanged();
      } else {
        monitoringConfigBuilder_.setMessage(builderForValue.build());
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. The custom monitoring configuration for this Feature, if not set, use the
     * monitoring_config defined for the EntityType this Feature belongs to.
     * If this is populated with
     * [FeaturestoreMonitoringConfig.disabled][] = true, snapshot analysis
     * monitoring is disabled; if
     * [FeaturestoreMonitoringConfig.monitoring_interval][] specified, snapshot
     * analysis monitoring is enabled. Otherwise, snapshot analysis monitoring
     * config is same as the EntityType's this Feature belongs to.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.FeaturestoreMonitoringConfig monitoring_config = 9 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder mergeMonitoringConfig(
        com.google.cloud.aiplatform.v1beta1.FeaturestoreMonitoringConfig value) {
      if (monitoringConfigBuilder_ == null) {
        if (monitoringConfig_ != null) {
          monitoringConfig_ =
              com.google.cloud.aiplatform.v1beta1.FeaturestoreMonitoringConfig.newBuilder(
                      monitoringConfig_)
                  .mergeFrom(value)
                  .buildPartial();
        } else {
          monitoringConfig_ = value;
        }
        onChanged();
      } else {
        monitoringConfigBuilder_.mergeFrom(value);
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. The custom monitoring configuration for this Feature, if not set, use the
     * monitoring_config defined for the EntityType this Feature belongs to.
     * If this is populated with
     * [FeaturestoreMonitoringConfig.disabled][] = true, snapshot analysis
     * monitoring is disabled; if
     * [FeaturestoreMonitoringConfig.monitoring_interval][] specified, snapshot
     * analysis monitoring is enabled. Otherwise, snapshot analysis monitoring
     * config is same as the EntityType's this Feature belongs to.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.FeaturestoreMonitoringConfig monitoring_config = 9 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder clearMonitoringConfig() {
      if (monitoringConfigBuilder_ == null) {
        monitoringConfig_ = null;
        onChanged();
      } else {
        monitoringConfig_ = null;
        monitoringConfigBuilder_ = null;
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. The custom monitoring configuration for this Feature, if not set, use the
     * monitoring_config defined for the EntityType this Feature belongs to.
     * If this is populated with
     * [FeaturestoreMonitoringConfig.disabled][] = true, snapshot analysis
     * monitoring is disabled; if
     * [FeaturestoreMonitoringConfig.monitoring_interval][] specified, snapshot
     * analysis monitoring is enabled. Otherwise, snapshot analysis monitoring
     * config is same as the EntityType's this Feature belongs to.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.FeaturestoreMonitoringConfig monitoring_config = 9 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public com.google.cloud.aiplatform.v1beta1.FeaturestoreMonitoringConfig.Builder
        getMonitoringConfigBuilder() {

      onChanged();
      return getMonitoringConfigFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Optional. The custom monitoring configuration for this Feature, if not set, use the
     * monitoring_config defined for the EntityType this Feature belongs to.
     * If this is populated with
     * [FeaturestoreMonitoringConfig.disabled][] = true, snapshot analysis
     * monitoring is disabled; if
     * [FeaturestoreMonitoringConfig.monitoring_interval][] specified, snapshot
     * analysis monitoring is enabled. Otherwise, snapshot analysis monitoring
     * config is same as the EntityType's this Feature belongs to.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.FeaturestoreMonitoringConfig monitoring_config = 9 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public com.google.cloud.aiplatform.v1beta1.FeaturestoreMonitoringConfigOrBuilder
        getMonitoringConfigOrBuilder() {
      if (monitoringConfigBuilder_ != null) {
        return monitoringConfigBuilder_.getMessageOrBuilder();
      } else {
        return monitoringConfig_ == null
            ? com.google.cloud.aiplatform.v1beta1.FeaturestoreMonitoringConfig.getDefaultInstance()
            : monitoringConfig_;
      }
    }
    /**
     *
     *
     * <pre>
     * Optional. The custom monitoring configuration for this Feature, if not set, use the
     * monitoring_config defined for the EntityType this Feature belongs to.
     * If this is populated with
     * [FeaturestoreMonitoringConfig.disabled][] = true, snapshot analysis
     * monitoring is disabled; if
     * [FeaturestoreMonitoringConfig.monitoring_interval][] specified, snapshot
     * analysis monitoring is enabled. Otherwise, snapshot analysis monitoring
     * config is same as the EntityType's this Feature belongs to.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.FeaturestoreMonitoringConfig monitoring_config = 9 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.aiplatform.v1beta1.FeaturestoreMonitoringConfig,
            com.google.cloud.aiplatform.v1beta1.FeaturestoreMonitoringConfig.Builder,
            com.google.cloud.aiplatform.v1beta1.FeaturestoreMonitoringConfigOrBuilder>
        getMonitoringConfigFieldBuilder() {
      if (monitoringConfigBuilder_ == null) {
        monitoringConfigBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.aiplatform.v1beta1.FeaturestoreMonitoringConfig,
                com.google.cloud.aiplatform.v1beta1.FeaturestoreMonitoringConfig.Builder,
                com.google.cloud.aiplatform.v1beta1.FeaturestoreMonitoringConfigOrBuilder>(
                getMonitoringConfig(), getParentForChildren(), isClean());
        monitoringConfig_ = null;
      }
      return monitoringConfigBuilder_;
    }

    private java.util.List<com.google.cloud.aiplatform.v1beta1.FeatureStatsAnomaly>
        monitoringStats_ = java.util.Collections.emptyList();

    private void ensureMonitoringStatsIsMutable() {
      if (!((bitField0_ & 0x00000002) != 0)) {
        monitoringStats_ =
            new java.util.ArrayList<com.google.cloud.aiplatform.v1beta1.FeatureStatsAnomaly>(
                monitoringStats_);
        bitField0_ |= 0x00000002;
      }
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.cloud.aiplatform.v1beta1.FeatureStatsAnomaly,
            com.google.cloud.aiplatform.v1beta1.FeatureStatsAnomaly.Builder,
            com.google.cloud.aiplatform.v1beta1.FeatureStatsAnomalyOrBuilder>
        monitoringStatsBuilder_;

    /**
     *
     *
     * <pre>
     * Output only. A list of historical [Snapshot
     * Analysis][google.cloud.aiplatform.master.FeaturestoreMonitoringConfig.SnapshotAnalysis]
     * stats requested by user, sorted by [FeatureStatsAnomaly.start_time][google.cloud.aiplatform.v1beta1.FeatureStatsAnomaly.start_time]
     * descending.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.aiplatform.v1beta1.FeatureStatsAnomaly monitoring_stats = 10 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public java.util.List<com.google.cloud.aiplatform.v1beta1.FeatureStatsAnomaly>
        getMonitoringStatsList() {
      if (monitoringStatsBuilder_ == null) {
        return java.util.Collections.unmodifiableList(monitoringStats_);
      } else {
        return monitoringStatsBuilder_.getMessageList();
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. A list of historical [Snapshot
     * Analysis][google.cloud.aiplatform.master.FeaturestoreMonitoringConfig.SnapshotAnalysis]
     * stats requested by user, sorted by [FeatureStatsAnomaly.start_time][google.cloud.aiplatform.v1beta1.FeatureStatsAnomaly.start_time]
     * descending.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.aiplatform.v1beta1.FeatureStatsAnomaly monitoring_stats = 10 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public int getMonitoringStatsCount() {
      if (monitoringStatsBuilder_ == null) {
        return monitoringStats_.size();
      } else {
        return monitoringStatsBuilder_.getCount();
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. A list of historical [Snapshot
     * Analysis][google.cloud.aiplatform.master.FeaturestoreMonitoringConfig.SnapshotAnalysis]
     * stats requested by user, sorted by [FeatureStatsAnomaly.start_time][google.cloud.aiplatform.v1beta1.FeatureStatsAnomaly.start_time]
     * descending.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.aiplatform.v1beta1.FeatureStatsAnomaly monitoring_stats = 10 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.cloud.aiplatform.v1beta1.FeatureStatsAnomaly getMonitoringStats(int index) {
      if (monitoringStatsBuilder_ == null) {
        return monitoringStats_.get(index);
      } else {
        return monitoringStatsBuilder_.getMessage(index);
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. A list of historical [Snapshot
     * Analysis][google.cloud.aiplatform.master.FeaturestoreMonitoringConfig.SnapshotAnalysis]
     * stats requested by user, sorted by [FeatureStatsAnomaly.start_time][google.cloud.aiplatform.v1beta1.FeatureStatsAnomaly.start_time]
     * descending.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.aiplatform.v1beta1.FeatureStatsAnomaly monitoring_stats = 10 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder setMonitoringStats(
        int index, com.google.cloud.aiplatform.v1beta1.FeatureStatsAnomaly value) {
      if (monitoringStatsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureMonitoringStatsIsMutable();
        monitoringStats_.set(index, value);
        onChanged();
      } else {
        monitoringStatsBuilder_.setMessage(index, value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. A list of historical [Snapshot
     * Analysis][google.cloud.aiplatform.master.FeaturestoreMonitoringConfig.SnapshotAnalysis]
     * stats requested by user, sorted by [FeatureStatsAnomaly.start_time][google.cloud.aiplatform.v1beta1.FeatureStatsAnomaly.start_time]
     * descending.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.aiplatform.v1beta1.FeatureStatsAnomaly monitoring_stats = 10 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder setMonitoringStats(
        int index,
        com.google.cloud.aiplatform.v1beta1.FeatureStatsAnomaly.Builder builderForValue) {
      if (monitoringStatsBuilder_ == null) {
        ensureMonitoringStatsIsMutable();
        monitoringStats_.set(index, builderForValue.build());
        onChanged();
      } else {
        monitoringStatsBuilder_.setMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. A list of historical [Snapshot
     * Analysis][google.cloud.aiplatform.master.FeaturestoreMonitoringConfig.SnapshotAnalysis]
     * stats requested by user, sorted by [FeatureStatsAnomaly.start_time][google.cloud.aiplatform.v1beta1.FeatureStatsAnomaly.start_time]
     * descending.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.aiplatform.v1beta1.FeatureStatsAnomaly monitoring_stats = 10 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder addMonitoringStats(
        com.google.cloud.aiplatform.v1beta1.FeatureStatsAnomaly value) {
      if (monitoringStatsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureMonitoringStatsIsMutable();
        monitoringStats_.add(value);
        onChanged();
      } else {
        monitoringStatsBuilder_.addMessage(value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. A list of historical [Snapshot
     * Analysis][google.cloud.aiplatform.master.FeaturestoreMonitoringConfig.SnapshotAnalysis]
     * stats requested by user, sorted by [FeatureStatsAnomaly.start_time][google.cloud.aiplatform.v1beta1.FeatureStatsAnomaly.start_time]
     * descending.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.aiplatform.v1beta1.FeatureStatsAnomaly monitoring_stats = 10 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder addMonitoringStats(
        int index, com.google.cloud.aiplatform.v1beta1.FeatureStatsAnomaly value) {
      if (monitoringStatsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureMonitoringStatsIsMutable();
        monitoringStats_.add(index, value);
        onChanged();
      } else {
        monitoringStatsBuilder_.addMessage(index, value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. A list of historical [Snapshot
     * Analysis][google.cloud.aiplatform.master.FeaturestoreMonitoringConfig.SnapshotAnalysis]
     * stats requested by user, sorted by [FeatureStatsAnomaly.start_time][google.cloud.aiplatform.v1beta1.FeatureStatsAnomaly.start_time]
     * descending.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.aiplatform.v1beta1.FeatureStatsAnomaly monitoring_stats = 10 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder addMonitoringStats(
        com.google.cloud.aiplatform.v1beta1.FeatureStatsAnomaly.Builder builderForValue) {
      if (monitoringStatsBuilder_ == null) {
        ensureMonitoringStatsIsMutable();
        monitoringStats_.add(builderForValue.build());
        onChanged();
      } else {
        monitoringStatsBuilder_.addMessage(builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. A list of historical [Snapshot
     * Analysis][google.cloud.aiplatform.master.FeaturestoreMonitoringConfig.SnapshotAnalysis]
     * stats requested by user, sorted by [FeatureStatsAnomaly.start_time][google.cloud.aiplatform.v1beta1.FeatureStatsAnomaly.start_time]
     * descending.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.aiplatform.v1beta1.FeatureStatsAnomaly monitoring_stats = 10 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder addMonitoringStats(
        int index,
        com.google.cloud.aiplatform.v1beta1.FeatureStatsAnomaly.Builder builderForValue) {
      if (monitoringStatsBuilder_ == null) {
        ensureMonitoringStatsIsMutable();
        monitoringStats_.add(index, builderForValue.build());
        onChanged();
      } else {
        monitoringStatsBuilder_.addMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. A list of historical [Snapshot
     * Analysis][google.cloud.aiplatform.master.FeaturestoreMonitoringConfig.SnapshotAnalysis]
     * stats requested by user, sorted by [FeatureStatsAnomaly.start_time][google.cloud.aiplatform.v1beta1.FeatureStatsAnomaly.start_time]
     * descending.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.aiplatform.v1beta1.FeatureStatsAnomaly monitoring_stats = 10 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder addAllMonitoringStats(
        java.lang.Iterable<? extends com.google.cloud.aiplatform.v1beta1.FeatureStatsAnomaly>
            values) {
      if (monitoringStatsBuilder_ == null) {
        ensureMonitoringStatsIsMutable();
        com.google.protobuf.AbstractMessageLite.Builder.addAll(values, monitoringStats_);
        onChanged();
      } else {
        monitoringStatsBuilder_.addAllMessages(values);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. A list of historical [Snapshot
     * Analysis][google.cloud.aiplatform.master.FeaturestoreMonitoringConfig.SnapshotAnalysis]
     * stats requested by user, sorted by [FeatureStatsAnomaly.start_time][google.cloud.aiplatform.v1beta1.FeatureStatsAnomaly.start_time]
     * descending.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.aiplatform.v1beta1.FeatureStatsAnomaly monitoring_stats = 10 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder clearMonitoringStats() {
      if (monitoringStatsBuilder_ == null) {
        monitoringStats_ = java.util.Collections.emptyList();
        bitField0_ = (bitField0_ & ~0x00000002);
        onChanged();
      } else {
        monitoringStatsBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. A list of historical [Snapshot
     * Analysis][google.cloud.aiplatform.master.FeaturestoreMonitoringConfig.SnapshotAnalysis]
     * stats requested by user, sorted by [FeatureStatsAnomaly.start_time][google.cloud.aiplatform.v1beta1.FeatureStatsAnomaly.start_time]
     * descending.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.aiplatform.v1beta1.FeatureStatsAnomaly monitoring_stats = 10 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder removeMonitoringStats(int index) {
      if (monitoringStatsBuilder_ == null) {
        ensureMonitoringStatsIsMutable();
        monitoringStats_.remove(index);
        onChanged();
      } else {
        monitoringStatsBuilder_.remove(index);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. A list of historical [Snapshot
     * Analysis][google.cloud.aiplatform.master.FeaturestoreMonitoringConfig.SnapshotAnalysis]
     * stats requested by user, sorted by [FeatureStatsAnomaly.start_time][google.cloud.aiplatform.v1beta1.FeatureStatsAnomaly.start_time]
     * descending.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.aiplatform.v1beta1.FeatureStatsAnomaly monitoring_stats = 10 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.cloud.aiplatform.v1beta1.FeatureStatsAnomaly.Builder
        getMonitoringStatsBuilder(int index) {
      return getMonitoringStatsFieldBuilder().getBuilder(index);
    }
    /**
     *
     *
     * <pre>
     * Output only. A list of historical [Snapshot
     * Analysis][google.cloud.aiplatform.master.FeaturestoreMonitoringConfig.SnapshotAnalysis]
     * stats requested by user, sorted by [FeatureStatsAnomaly.start_time][google.cloud.aiplatform.v1beta1.FeatureStatsAnomaly.start_time]
     * descending.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.aiplatform.v1beta1.FeatureStatsAnomaly monitoring_stats = 10 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.cloud.aiplatform.v1beta1.FeatureStatsAnomalyOrBuilder
        getMonitoringStatsOrBuilder(int index) {
      if (monitoringStatsBuilder_ == null) {
        return monitoringStats_.get(index);
      } else {
        return monitoringStatsBuilder_.getMessageOrBuilder(index);
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. A list of historical [Snapshot
     * Analysis][google.cloud.aiplatform.master.FeaturestoreMonitoringConfig.SnapshotAnalysis]
     * stats requested by user, sorted by [FeatureStatsAnomaly.start_time][google.cloud.aiplatform.v1beta1.FeatureStatsAnomaly.start_time]
     * descending.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.aiplatform.v1beta1.FeatureStatsAnomaly monitoring_stats = 10 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public java.util.List<
            ? extends com.google.cloud.aiplatform.v1beta1.FeatureStatsAnomalyOrBuilder>
        getMonitoringStatsOrBuilderList() {
      if (monitoringStatsBuilder_ != null) {
        return monitoringStatsBuilder_.getMessageOrBuilderList();
      } else {
        return java.util.Collections.unmodifiableList(monitoringStats_);
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. A list of historical [Snapshot
     * Analysis][google.cloud.aiplatform.master.FeaturestoreMonitoringConfig.SnapshotAnalysis]
     * stats requested by user, sorted by [FeatureStatsAnomaly.start_time][google.cloud.aiplatform.v1beta1.FeatureStatsAnomaly.start_time]
     * descending.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.aiplatform.v1beta1.FeatureStatsAnomaly monitoring_stats = 10 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.cloud.aiplatform.v1beta1.FeatureStatsAnomaly.Builder
        addMonitoringStatsBuilder() {
      return getMonitoringStatsFieldBuilder()
          .addBuilder(com.google.cloud.aiplatform.v1beta1.FeatureStatsAnomaly.getDefaultInstance());
    }
    /**
     *
     *
     * <pre>
     * Output only. A list of historical [Snapshot
     * Analysis][google.cloud.aiplatform.master.FeaturestoreMonitoringConfig.SnapshotAnalysis]
     * stats requested by user, sorted by [FeatureStatsAnomaly.start_time][google.cloud.aiplatform.v1beta1.FeatureStatsAnomaly.start_time]
     * descending.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.aiplatform.v1beta1.FeatureStatsAnomaly monitoring_stats = 10 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.cloud.aiplatform.v1beta1.FeatureStatsAnomaly.Builder
        addMonitoringStatsBuilder(int index) {
      return getMonitoringStatsFieldBuilder()
          .addBuilder(
              index, com.google.cloud.aiplatform.v1beta1.FeatureStatsAnomaly.getDefaultInstance());
    }
    /**
     *
     *
     * <pre>
     * Output only. A list of historical [Snapshot
     * Analysis][google.cloud.aiplatform.master.FeaturestoreMonitoringConfig.SnapshotAnalysis]
     * stats requested by user, sorted by [FeatureStatsAnomaly.start_time][google.cloud.aiplatform.v1beta1.FeatureStatsAnomaly.start_time]
     * descending.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.aiplatform.v1beta1.FeatureStatsAnomaly monitoring_stats = 10 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public java.util.List<com.google.cloud.aiplatform.v1beta1.FeatureStatsAnomaly.Builder>
        getMonitoringStatsBuilderList() {
      return getMonitoringStatsFieldBuilder().getBuilderList();
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.cloud.aiplatform.v1beta1.FeatureStatsAnomaly,
            com.google.cloud.aiplatform.v1beta1.FeatureStatsAnomaly.Builder,
            com.google.cloud.aiplatform.v1beta1.FeatureStatsAnomalyOrBuilder>
        getMonitoringStatsFieldBuilder() {
      if (monitoringStatsBuilder_ == null) {
        monitoringStatsBuilder_ =
            new com.google.protobuf.RepeatedFieldBuilderV3<
                com.google.cloud.aiplatform.v1beta1.FeatureStatsAnomaly,
                com.google.cloud.aiplatform.v1beta1.FeatureStatsAnomaly.Builder,
                com.google.cloud.aiplatform.v1beta1.FeatureStatsAnomalyOrBuilder>(
                monitoringStats_,
                ((bitField0_ & 0x00000002) != 0),
                getParentForChildren(),
                isClean());
        monitoringStats_ = null;
      }
      return monitoringStatsBuilder_;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.cloud.aiplatform.v1beta1.Feature)
  }

  // @@protoc_insertion_point(class_scope:google.cloud.aiplatform.v1beta1.Feature)
  private static final com.google.cloud.aiplatform.v1beta1.Feature DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.cloud.aiplatform.v1beta1.Feature();
  }

  public static com.google.cloud.aiplatform.v1beta1.Feature getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<Feature> PARSER =
      new com.google.protobuf.AbstractParser<Feature>() {
        @java.lang.Override
        public Feature parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          return new Feature(input, extensionRegistry);
        }
      };

  public static com.google.protobuf.Parser<Feature> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<Feature> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.cloud.aiplatform.v1beta1.Feature getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
