/*
 * Copyright 2020 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/cloud/aiplatform/v1beta1/featurestore_monitoring.proto

package com.google.cloud.aiplatform.v1beta1;

/**
 *
 *
 * <pre>
 * Configuration of how features in Featurestore are monitored.
 * </pre>
 *
 * Protobuf type {@code google.cloud.aiplatform.v1beta1.FeaturestoreMonitoringConfig}
 */
public final class FeaturestoreMonitoringConfig extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.cloud.aiplatform.v1beta1.FeaturestoreMonitoringConfig)
    FeaturestoreMonitoringConfigOrBuilder {
  private static final long serialVersionUID = 0L;
  // Use FeaturestoreMonitoringConfig.newBuilder() to construct.
  private FeaturestoreMonitoringConfig(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private FeaturestoreMonitoringConfig() {}

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new FeaturestoreMonitoringConfig();
  }

  @java.lang.Override
  public final com.google.protobuf.UnknownFieldSet getUnknownFields() {
    return this.unknownFields;
  }

  private FeaturestoreMonitoringConfig(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    this();
    if (extensionRegistry == null) {
      throw new java.lang.NullPointerException();
    }
    com.google.protobuf.UnknownFieldSet.Builder unknownFields =
        com.google.protobuf.UnknownFieldSet.newBuilder();
    try {
      boolean done = false;
      while (!done) {
        int tag = input.readTag();
        switch (tag) {
          case 0:
            done = true;
            break;
          case 10:
            {
              com.google.cloud.aiplatform.v1beta1.FeaturestoreMonitoringConfig.SnapshotAnalysis
                      .Builder
                  subBuilder = null;
              if (snapshotAnalysis_ != null) {
                subBuilder = snapshotAnalysis_.toBuilder();
              }
              snapshotAnalysis_ =
                  input.readMessage(
                      com.google.cloud.aiplatform.v1beta1.FeaturestoreMonitoringConfig
                          .SnapshotAnalysis.parser(),
                      extensionRegistry);
              if (subBuilder != null) {
                subBuilder.mergeFrom(snapshotAnalysis_);
                snapshotAnalysis_ = subBuilder.buildPartial();
              }

              break;
            }
          default:
            {
              if (!parseUnknownField(input, unknownFields, extensionRegistry, tag)) {
                done = true;
              }
              break;
            }
        }
      }
    } catch (com.google.protobuf.InvalidProtocolBufferException e) {
      throw e.setUnfinishedMessage(this);
    } catch (java.io.IOException e) {
      throw new com.google.protobuf.InvalidProtocolBufferException(e).setUnfinishedMessage(this);
    } finally {
      this.unknownFields = unknownFields.build();
      makeExtensionsImmutable();
    }
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.cloud.aiplatform.v1beta1.FeaturestoreMonitoringProto
        .internal_static_google_cloud_aiplatform_v1beta1_FeaturestoreMonitoringConfig_descriptor;
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.cloud.aiplatform.v1beta1.FeaturestoreMonitoringProto
        .internal_static_google_cloud_aiplatform_v1beta1_FeaturestoreMonitoringConfig_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.cloud.aiplatform.v1beta1.FeaturestoreMonitoringConfig.class,
            com.google.cloud.aiplatform.v1beta1.FeaturestoreMonitoringConfig.Builder.class);
  }

  public interface SnapshotAnalysisOrBuilder
      extends
      // @@protoc_insertion_point(interface_extends:google.cloud.aiplatform.v1beta1.FeaturestoreMonitoringConfig.SnapshotAnalysis)
      com.google.protobuf.MessageOrBuilder {

    /**
     *
     *
     * <pre>
     * The monitoring schedule for snapshot analysis.
     * For EntityType-level config:
     *   unset / disabled = true indicates disabled by
     *   default for Features under it; otherwise by default enable snapshot
     *   analysis monitoring with monitoring_interval for Features under it.
     * Feature-level config:
     *   disabled = true indicates disabled regardless of the EntityType-level
     *   config; unset monitoring_interval indicates going with EntityType-level
     *   config; otherwise run snapshot analysis monitoring with
     *   monitoring_interval regardless of the EntityType-level config.
     * Explicitly Disable the snapshot analysis based monitoring.
     * </pre>
     *
     * <code>bool disabled = 1;</code>
     *
     * @return The disabled.
     */
    boolean getDisabled();

    /**
     *
     *
     * <pre>
     * Configuration of the snapshot analysis based monitoring pipeline running
     * interval. The value is rolled up to full day.
     * </pre>
     *
     * <code>.google.protobuf.Duration monitoring_interval = 2 [deprecated = true];</code>
     *
     * @return Whether the monitoringInterval field is set.
     */
    @java.lang.Deprecated
    boolean hasMonitoringInterval();
    /**
     *
     *
     * <pre>
     * Configuration of the snapshot analysis based monitoring pipeline running
     * interval. The value is rolled up to full day.
     * </pre>
     *
     * <code>.google.protobuf.Duration monitoring_interval = 2 [deprecated = true];</code>
     *
     * @return The monitoringInterval.
     */
    @java.lang.Deprecated
    com.google.protobuf.Duration getMonitoringInterval();
    /**
     *
     *
     * <pre>
     * Configuration of the snapshot analysis based monitoring pipeline running
     * interval. The value is rolled up to full day.
     * </pre>
     *
     * <code>.google.protobuf.Duration monitoring_interval = 2 [deprecated = true];</code>
     */
    @java.lang.Deprecated
    com.google.protobuf.DurationOrBuilder getMonitoringIntervalOrBuilder();

    /**
     *
     *
     * <pre>
     * Configuration of the snapshot analysis based monitoring pipeline
     * running interval. The value indicates number of days.
     * If both
     * [FeaturestoreMonitoringConfig.SnapshotAnalysis.monitoring_interval_days][google.cloud.aiplatform.v1beta1.FeaturestoreMonitoringConfig.SnapshotAnalysis.monitoring_interval_days]
     * and [FeaturestoreMonitoringConfig.SnapshotAnalysis.monitoring_interval][google.cloud.aiplatform.v1beta1.FeaturestoreMonitoringConfig.SnapshotAnalysis.monitoring_interval]
     * are set when creating/updating EntityTypes/Features,
     * [FeaturestoreMonitoringConfig.SnapshotAnalysis.monitoring_interval_days][google.cloud.aiplatform.v1beta1.FeaturestoreMonitoringConfig.SnapshotAnalysis.monitoring_interval_days]
     * will be used.
     * </pre>
     *
     * <code>int32 monitoring_interval_days = 3;</code>
     *
     * @return The monitoringIntervalDays.
     */
    int getMonitoringIntervalDays();
  }
  /**
   *
   *
   * <pre>
   * Configuration of the Featurestore's Snapshot Analysis Based Monitoring.
   * This type of analysis generates statistics for each Feature based on a
   * snapshot of the latest feature value of each entities every
   * monitoring_interval.
   * </pre>
   *
   * Protobuf type {@code
   * google.cloud.aiplatform.v1beta1.FeaturestoreMonitoringConfig.SnapshotAnalysis}
   */
  public static final class SnapshotAnalysis extends com.google.protobuf.GeneratedMessageV3
      implements
      // @@protoc_insertion_point(message_implements:google.cloud.aiplatform.v1beta1.FeaturestoreMonitoringConfig.SnapshotAnalysis)
      SnapshotAnalysisOrBuilder {
    private static final long serialVersionUID = 0L;
    // Use SnapshotAnalysis.newBuilder() to construct.
    private SnapshotAnalysis(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
      super(builder);
    }

    private SnapshotAnalysis() {}

    @java.lang.Override
    @SuppressWarnings({"unused"})
    protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
      return new SnapshotAnalysis();
    }

    @java.lang.Override
    public final com.google.protobuf.UnknownFieldSet getUnknownFields() {
      return this.unknownFields;
    }

    private SnapshotAnalysis(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      this();
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      com.google.protobuf.UnknownFieldSet.Builder unknownFields =
          com.google.protobuf.UnknownFieldSet.newBuilder();
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 8:
              {
                disabled_ = input.readBool();
                break;
              }
            case 18:
              {
                com.google.protobuf.Duration.Builder subBuilder = null;
                if (monitoringInterval_ != null) {
                  subBuilder = monitoringInterval_.toBuilder();
                }
                monitoringInterval_ =
                    input.readMessage(com.google.protobuf.Duration.parser(), extensionRegistry);
                if (subBuilder != null) {
                  subBuilder.mergeFrom(monitoringInterval_);
                  monitoringInterval_ = subBuilder.buildPartial();
                }

                break;
              }
            case 24:
              {
                monitoringIntervalDays_ = input.readInt32();
                break;
              }
            default:
              {
                if (!parseUnknownField(input, unknownFields, extensionRegistry, tag)) {
                  done = true;
                }
                break;
              }
          }
        }
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.setUnfinishedMessage(this);
      } catch (java.io.IOException e) {
        throw new com.google.protobuf.InvalidProtocolBufferException(e).setUnfinishedMessage(this);
      } finally {
        this.unknownFields = unknownFields.build();
        makeExtensionsImmutable();
      }
    }

    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.aiplatform.v1beta1.FeaturestoreMonitoringProto
          .internal_static_google_cloud_aiplatform_v1beta1_FeaturestoreMonitoringConfig_SnapshotAnalysis_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.aiplatform.v1beta1.FeaturestoreMonitoringProto
          .internal_static_google_cloud_aiplatform_v1beta1_FeaturestoreMonitoringConfig_SnapshotAnalysis_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.aiplatform.v1beta1.FeaturestoreMonitoringConfig.SnapshotAnalysis
                  .class,
              com.google.cloud.aiplatform.v1beta1.FeaturestoreMonitoringConfig.SnapshotAnalysis
                  .Builder.class);
    }

    public static final int DISABLED_FIELD_NUMBER = 1;
    private boolean disabled_;
    /**
     *
     *
     * <pre>
     * The monitoring schedule for snapshot analysis.
     * For EntityType-level config:
     *   unset / disabled = true indicates disabled by
     *   default for Features under it; otherwise by default enable snapshot
     *   analysis monitoring with monitoring_interval for Features under it.
     * Feature-level config:
     *   disabled = true indicates disabled regardless of the EntityType-level
     *   config; unset monitoring_interval indicates going with EntityType-level
     *   config; otherwise run snapshot analysis monitoring with
     *   monitoring_interval regardless of the EntityType-level config.
     * Explicitly Disable the snapshot analysis based monitoring.
     * </pre>
     *
     * <code>bool disabled = 1;</code>
     *
     * @return The disabled.
     */
    @java.lang.Override
    public boolean getDisabled() {
      return disabled_;
    }

    public static final int MONITORING_INTERVAL_FIELD_NUMBER = 2;
    private com.google.protobuf.Duration monitoringInterval_;
    /**
     *
     *
     * <pre>
     * Configuration of the snapshot analysis based monitoring pipeline running
     * interval. The value is rolled up to full day.
     * </pre>
     *
     * <code>.google.protobuf.Duration monitoring_interval = 2 [deprecated = true];</code>
     *
     * @return Whether the monitoringInterval field is set.
     */
    @java.lang.Override
    @java.lang.Deprecated
    public boolean hasMonitoringInterval() {
      return monitoringInterval_ != null;
    }
    /**
     *
     *
     * <pre>
     * Configuration of the snapshot analysis based monitoring pipeline running
     * interval. The value is rolled up to full day.
     * </pre>
     *
     * <code>.google.protobuf.Duration monitoring_interval = 2 [deprecated = true];</code>
     *
     * @return The monitoringInterval.
     */
    @java.lang.Override
    @java.lang.Deprecated
    public com.google.protobuf.Duration getMonitoringInterval() {
      return monitoringInterval_ == null
          ? com.google.protobuf.Duration.getDefaultInstance()
          : monitoringInterval_;
    }
    /**
     *
     *
     * <pre>
     * Configuration of the snapshot analysis based monitoring pipeline running
     * interval. The value is rolled up to full day.
     * </pre>
     *
     * <code>.google.protobuf.Duration monitoring_interval = 2 [deprecated = true];</code>
     */
    @java.lang.Override
    @java.lang.Deprecated
    public com.google.protobuf.DurationOrBuilder getMonitoringIntervalOrBuilder() {
      return getMonitoringInterval();
    }

    public static final int MONITORING_INTERVAL_DAYS_FIELD_NUMBER = 3;
    private int monitoringIntervalDays_;
    /**
     *
     *
     * <pre>
     * Configuration of the snapshot analysis based monitoring pipeline
     * running interval. The value indicates number of days.
     * If both
     * [FeaturestoreMonitoringConfig.SnapshotAnalysis.monitoring_interval_days][google.cloud.aiplatform.v1beta1.FeaturestoreMonitoringConfig.SnapshotAnalysis.monitoring_interval_days]
     * and [FeaturestoreMonitoringConfig.SnapshotAnalysis.monitoring_interval][google.cloud.aiplatform.v1beta1.FeaturestoreMonitoringConfig.SnapshotAnalysis.monitoring_interval]
     * are set when creating/updating EntityTypes/Features,
     * [FeaturestoreMonitoringConfig.SnapshotAnalysis.monitoring_interval_days][google.cloud.aiplatform.v1beta1.FeaturestoreMonitoringConfig.SnapshotAnalysis.monitoring_interval_days]
     * will be used.
     * </pre>
     *
     * <code>int32 monitoring_interval_days = 3;</code>
     *
     * @return The monitoringIntervalDays.
     */
    @java.lang.Override
    public int getMonitoringIntervalDays() {
      return monitoringIntervalDays_;
    }

    private byte memoizedIsInitialized = -1;

    @java.lang.Override
    public final boolean isInitialized() {
      byte isInitialized = memoizedIsInitialized;
      if (isInitialized == 1) return true;
      if (isInitialized == 0) return false;

      memoizedIsInitialized = 1;
      return true;
    }

    @java.lang.Override
    public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
      if (disabled_ != false) {
        output.writeBool(1, disabled_);
      }
      if (monitoringInterval_ != null) {
        output.writeMessage(2, getMonitoringInterval());
      }
      if (monitoringIntervalDays_ != 0) {
        output.writeInt32(3, monitoringIntervalDays_);
      }
      unknownFields.writeTo(output);
    }

    @java.lang.Override
    public int getSerializedSize() {
      int size = memoizedSize;
      if (size != -1) return size;

      size = 0;
      if (disabled_ != false) {
        size += com.google.protobuf.CodedOutputStream.computeBoolSize(1, disabled_);
      }
      if (monitoringInterval_ != null) {
        size +=
            com.google.protobuf.CodedOutputStream.computeMessageSize(2, getMonitoringInterval());
      }
      if (monitoringIntervalDays_ != 0) {
        size += com.google.protobuf.CodedOutputStream.computeInt32Size(3, monitoringIntervalDays_);
      }
      size += unknownFields.getSerializedSize();
      memoizedSize = size;
      return size;
    }

    @java.lang.Override
    public boolean equals(final java.lang.Object obj) {
      if (obj == this) {
        return true;
      }
      if (!(obj
          instanceof
          com.google.cloud.aiplatform.v1beta1.FeaturestoreMonitoringConfig.SnapshotAnalysis)) {
        return super.equals(obj);
      }
      com.google.cloud.aiplatform.v1beta1.FeaturestoreMonitoringConfig.SnapshotAnalysis other =
          (com.google.cloud.aiplatform.v1beta1.FeaturestoreMonitoringConfig.SnapshotAnalysis) obj;

      if (getDisabled() != other.getDisabled()) return false;
      if (hasMonitoringInterval() != other.hasMonitoringInterval()) return false;
      if (hasMonitoringInterval()) {
        if (!getMonitoringInterval().equals(other.getMonitoringInterval())) return false;
      }
      if (getMonitoringIntervalDays() != other.getMonitoringIntervalDays()) return false;
      if (!unknownFields.equals(other.unknownFields)) return false;
      return true;
    }

    @java.lang.Override
    public int hashCode() {
      if (memoizedHashCode != 0) {
        return memoizedHashCode;
      }
      int hash = 41;
      hash = (19 * hash) + getDescriptor().hashCode();
      hash = (37 * hash) + DISABLED_FIELD_NUMBER;
      hash = (53 * hash) + com.google.protobuf.Internal.hashBoolean(getDisabled());
      if (hasMonitoringInterval()) {
        hash = (37 * hash) + MONITORING_INTERVAL_FIELD_NUMBER;
        hash = (53 * hash) + getMonitoringInterval().hashCode();
      }
      hash = (37 * hash) + MONITORING_INTERVAL_DAYS_FIELD_NUMBER;
      hash = (53 * hash) + getMonitoringIntervalDays();
      hash = (29 * hash) + unknownFields.hashCode();
      memoizedHashCode = hash;
      return hash;
    }

    public static com.google.cloud.aiplatform.v1beta1.FeaturestoreMonitoringConfig.SnapshotAnalysis
        parseFrom(java.nio.ByteBuffer data)
            throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.aiplatform.v1beta1.FeaturestoreMonitoringConfig.SnapshotAnalysis
        parseFrom(
            java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.aiplatform.v1beta1.FeaturestoreMonitoringConfig.SnapshotAnalysis
        parseFrom(com.google.protobuf.ByteString data)
            throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.aiplatform.v1beta1.FeaturestoreMonitoringConfig.SnapshotAnalysis
        parseFrom(
            com.google.protobuf.ByteString data,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.aiplatform.v1beta1.FeaturestoreMonitoringConfig.SnapshotAnalysis
        parseFrom(byte[] data) throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.aiplatform.v1beta1.FeaturestoreMonitoringConfig.SnapshotAnalysis
        parseFrom(byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.aiplatform.v1beta1.FeaturestoreMonitoringConfig.SnapshotAnalysis
        parseFrom(java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.cloud.aiplatform.v1beta1.FeaturestoreMonitoringConfig.SnapshotAnalysis
        parseFrom(
            java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.cloud.aiplatform.v1beta1.FeaturestoreMonitoringConfig.SnapshotAnalysis
        parseDelimitedFrom(java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
    }

    public static com.google.cloud.aiplatform.v1beta1.FeaturestoreMonitoringConfig.SnapshotAnalysis
        parseDelimitedFrom(
            java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.cloud.aiplatform.v1beta1.FeaturestoreMonitoringConfig.SnapshotAnalysis
        parseFrom(com.google.protobuf.CodedInputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.cloud.aiplatform.v1beta1.FeaturestoreMonitoringConfig.SnapshotAnalysis
        parseFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    @java.lang.Override
    public Builder newBuilderForType() {
      return newBuilder();
    }

    public static Builder newBuilder() {
      return DEFAULT_INSTANCE.toBuilder();
    }

    public static Builder newBuilder(
        com.google.cloud.aiplatform.v1beta1.FeaturestoreMonitoringConfig.SnapshotAnalysis
            prototype) {
      return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }

    @java.lang.Override
    public Builder toBuilder() {
      return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
    }

    @java.lang.Override
    protected Builder newBuilderForType(
        com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      Builder builder = new Builder(parent);
      return builder;
    }
    /**
     *
     *
     * <pre>
     * Configuration of the Featurestore's Snapshot Analysis Based Monitoring.
     * This type of analysis generates statistics for each Feature based on a
     * snapshot of the latest feature value of each entities every
     * monitoring_interval.
     * </pre>
     *
     * Protobuf type {@code
     * google.cloud.aiplatform.v1beta1.FeaturestoreMonitoringConfig.SnapshotAnalysis}
     */
    public static final class Builder
        extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
        implements
        // @@protoc_insertion_point(builder_implements:google.cloud.aiplatform.v1beta1.FeaturestoreMonitoringConfig.SnapshotAnalysis)
        com.google.cloud.aiplatform.v1beta1.FeaturestoreMonitoringConfig.SnapshotAnalysisOrBuilder {
      public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
        return com.google.cloud.aiplatform.v1beta1.FeaturestoreMonitoringProto
            .internal_static_google_cloud_aiplatform_v1beta1_FeaturestoreMonitoringConfig_SnapshotAnalysis_descriptor;
      }

      @java.lang.Override
      protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return com.google.cloud.aiplatform.v1beta1.FeaturestoreMonitoringProto
            .internal_static_google_cloud_aiplatform_v1beta1_FeaturestoreMonitoringConfig_SnapshotAnalysis_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                com.google.cloud.aiplatform.v1beta1.FeaturestoreMonitoringConfig.SnapshotAnalysis
                    .class,
                com.google.cloud.aiplatform.v1beta1.FeaturestoreMonitoringConfig.SnapshotAnalysis
                    .Builder.class);
      }

      // Construct using
      // com.google.cloud.aiplatform.v1beta1.FeaturestoreMonitoringConfig.SnapshotAnalysis.newBuilder()
      private Builder() {
        maybeForceBuilderInitialization();
      }

      private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
        super(parent);
        maybeForceBuilderInitialization();
      }

      private void maybeForceBuilderInitialization() {
        if (com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders) {}
      }

      @java.lang.Override
      public Builder clear() {
        super.clear();
        disabled_ = false;

        if (monitoringIntervalBuilder_ == null) {
          monitoringInterval_ = null;
        } else {
          monitoringInterval_ = null;
          monitoringIntervalBuilder_ = null;
        }
        monitoringIntervalDays_ = 0;

        return this;
      }

      @java.lang.Override
      public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
        return com.google.cloud.aiplatform.v1beta1.FeaturestoreMonitoringProto
            .internal_static_google_cloud_aiplatform_v1beta1_FeaturestoreMonitoringConfig_SnapshotAnalysis_descriptor;
      }

      @java.lang.Override
      public com.google.cloud.aiplatform.v1beta1.FeaturestoreMonitoringConfig.SnapshotAnalysis
          getDefaultInstanceForType() {
        return com.google.cloud.aiplatform.v1beta1.FeaturestoreMonitoringConfig.SnapshotAnalysis
            .getDefaultInstance();
      }

      @java.lang.Override
      public com.google.cloud.aiplatform.v1beta1.FeaturestoreMonitoringConfig.SnapshotAnalysis
          build() {
        com.google.cloud.aiplatform.v1beta1.FeaturestoreMonitoringConfig.SnapshotAnalysis result =
            buildPartial();
        if (!result.isInitialized()) {
          throw newUninitializedMessageException(result);
        }
        return result;
      }

      @java.lang.Override
      public com.google.cloud.aiplatform.v1beta1.FeaturestoreMonitoringConfig.SnapshotAnalysis
          buildPartial() {
        com.google.cloud.aiplatform.v1beta1.FeaturestoreMonitoringConfig.SnapshotAnalysis result =
            new com.google.cloud.aiplatform.v1beta1.FeaturestoreMonitoringConfig.SnapshotAnalysis(
                this);
        result.disabled_ = disabled_;
        if (monitoringIntervalBuilder_ == null) {
          result.monitoringInterval_ = monitoringInterval_;
        } else {
          result.monitoringInterval_ = monitoringIntervalBuilder_.build();
        }
        result.monitoringIntervalDays_ = monitoringIntervalDays_;
        onBuilt();
        return result;
      }

      @java.lang.Override
      public Builder clone() {
        return super.clone();
      }

      @java.lang.Override
      public Builder setField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.setField(field, value);
      }

      @java.lang.Override
      public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
        return super.clearField(field);
      }

      @java.lang.Override
      public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
        return super.clearOneof(oneof);
      }

      @java.lang.Override
      public Builder setRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          int index,
          java.lang.Object value) {
        return super.setRepeatedField(field, index, value);
      }

      @java.lang.Override
      public Builder addRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.addRepeatedField(field, value);
      }

      @java.lang.Override
      public Builder mergeFrom(com.google.protobuf.Message other) {
        if (other
            instanceof
            com.google.cloud.aiplatform.v1beta1.FeaturestoreMonitoringConfig.SnapshotAnalysis) {
          return mergeFrom(
              (com.google.cloud.aiplatform.v1beta1.FeaturestoreMonitoringConfig.SnapshotAnalysis)
                  other);
        } else {
          super.mergeFrom(other);
          return this;
        }
      }

      public Builder mergeFrom(
          com.google.cloud.aiplatform.v1beta1.FeaturestoreMonitoringConfig.SnapshotAnalysis other) {
        if (other
            == com.google.cloud.aiplatform.v1beta1.FeaturestoreMonitoringConfig.SnapshotAnalysis
                .getDefaultInstance()) return this;
        if (other.getDisabled() != false) {
          setDisabled(other.getDisabled());
        }
        if (other.hasMonitoringInterval()) {
          mergeMonitoringInterval(other.getMonitoringInterval());
        }
        if (other.getMonitoringIntervalDays() != 0) {
          setMonitoringIntervalDays(other.getMonitoringIntervalDays());
        }
        this.mergeUnknownFields(other.unknownFields);
        onChanged();
        return this;
      }

      @java.lang.Override
      public final boolean isInitialized() {
        return true;
      }

      @java.lang.Override
      public Builder mergeFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        com.google.cloud.aiplatform.v1beta1.FeaturestoreMonitoringConfig.SnapshotAnalysis
            parsedMessage = null;
        try {
          parsedMessage = PARSER.parsePartialFrom(input, extensionRegistry);
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          parsedMessage =
              (com.google.cloud.aiplatform.v1beta1.FeaturestoreMonitoringConfig.SnapshotAnalysis)
                  e.getUnfinishedMessage();
          throw e.unwrapIOException();
        } finally {
          if (parsedMessage != null) {
            mergeFrom(parsedMessage);
          }
        }
        return this;
      }

      private boolean disabled_;
      /**
       *
       *
       * <pre>
       * The monitoring schedule for snapshot analysis.
       * For EntityType-level config:
       *   unset / disabled = true indicates disabled by
       *   default for Features under it; otherwise by default enable snapshot
       *   analysis monitoring with monitoring_interval for Features under it.
       * Feature-level config:
       *   disabled = true indicates disabled regardless of the EntityType-level
       *   config; unset monitoring_interval indicates going with EntityType-level
       *   config; otherwise run snapshot analysis monitoring with
       *   monitoring_interval regardless of the EntityType-level config.
       * Explicitly Disable the snapshot analysis based monitoring.
       * </pre>
       *
       * <code>bool disabled = 1;</code>
       *
       * @return The disabled.
       */
      @java.lang.Override
      public boolean getDisabled() {
        return disabled_;
      }
      /**
       *
       *
       * <pre>
       * The monitoring schedule for snapshot analysis.
       * For EntityType-level config:
       *   unset / disabled = true indicates disabled by
       *   default for Features under it; otherwise by default enable snapshot
       *   analysis monitoring with monitoring_interval for Features under it.
       * Feature-level config:
       *   disabled = true indicates disabled regardless of the EntityType-level
       *   config; unset monitoring_interval indicates going with EntityType-level
       *   config; otherwise run snapshot analysis monitoring with
       *   monitoring_interval regardless of the EntityType-level config.
       * Explicitly Disable the snapshot analysis based monitoring.
       * </pre>
       *
       * <code>bool disabled = 1;</code>
       *
       * @param value The disabled to set.
       * @return This builder for chaining.
       */
      public Builder setDisabled(boolean value) {

        disabled_ = value;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * The monitoring schedule for snapshot analysis.
       * For EntityType-level config:
       *   unset / disabled = true indicates disabled by
       *   default for Features under it; otherwise by default enable snapshot
       *   analysis monitoring with monitoring_interval for Features under it.
       * Feature-level config:
       *   disabled = true indicates disabled regardless of the EntityType-level
       *   config; unset monitoring_interval indicates going with EntityType-level
       *   config; otherwise run snapshot analysis monitoring with
       *   monitoring_interval regardless of the EntityType-level config.
       * Explicitly Disable the snapshot analysis based monitoring.
       * </pre>
       *
       * <code>bool disabled = 1;</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearDisabled() {

        disabled_ = false;
        onChanged();
        return this;
      }

      private com.google.protobuf.Duration monitoringInterval_;
      private com.google.protobuf.SingleFieldBuilderV3<
              com.google.protobuf.Duration,
              com.google.protobuf.Duration.Builder,
              com.google.protobuf.DurationOrBuilder>
          monitoringIntervalBuilder_;
      /**
       *
       *
       * <pre>
       * Configuration of the snapshot analysis based monitoring pipeline running
       * interval. The value is rolled up to full day.
       * </pre>
       *
       * <code>.google.protobuf.Duration monitoring_interval = 2 [deprecated = true];</code>
       *
       * @return Whether the monitoringInterval field is set.
       */
      @java.lang.Deprecated
      public boolean hasMonitoringInterval() {
        return monitoringIntervalBuilder_ != null || monitoringInterval_ != null;
      }
      /**
       *
       *
       * <pre>
       * Configuration of the snapshot analysis based monitoring pipeline running
       * interval. The value is rolled up to full day.
       * </pre>
       *
       * <code>.google.protobuf.Duration monitoring_interval = 2 [deprecated = true];</code>
       *
       * @return The monitoringInterval.
       */
      @java.lang.Deprecated
      public com.google.protobuf.Duration getMonitoringInterval() {
        if (monitoringIntervalBuilder_ == null) {
          return monitoringInterval_ == null
              ? com.google.protobuf.Duration.getDefaultInstance()
              : monitoringInterval_;
        } else {
          return monitoringIntervalBuilder_.getMessage();
        }
      }
      /**
       *
       *
       * <pre>
       * Configuration of the snapshot analysis based monitoring pipeline running
       * interval. The value is rolled up to full day.
       * </pre>
       *
       * <code>.google.protobuf.Duration monitoring_interval = 2 [deprecated = true];</code>
       */
      @java.lang.Deprecated
      public Builder setMonitoringInterval(com.google.protobuf.Duration value) {
        if (monitoringIntervalBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          monitoringInterval_ = value;
          onChanged();
        } else {
          monitoringIntervalBuilder_.setMessage(value);
        }

        return this;
      }
      /**
       *
       *
       * <pre>
       * Configuration of the snapshot analysis based monitoring pipeline running
       * interval. The value is rolled up to full day.
       * </pre>
       *
       * <code>.google.protobuf.Duration monitoring_interval = 2 [deprecated = true];</code>
       */
      @java.lang.Deprecated
      public Builder setMonitoringInterval(com.google.protobuf.Duration.Builder builderForValue) {
        if (monitoringIntervalBuilder_ == null) {
          monitoringInterval_ = builderForValue.build();
          onChanged();
        } else {
          monitoringIntervalBuilder_.setMessage(builderForValue.build());
        }

        return this;
      }
      /**
       *
       *
       * <pre>
       * Configuration of the snapshot analysis based monitoring pipeline running
       * interval. The value is rolled up to full day.
       * </pre>
       *
       * <code>.google.protobuf.Duration monitoring_interval = 2 [deprecated = true];</code>
       */
      @java.lang.Deprecated
      public Builder mergeMonitoringInterval(com.google.protobuf.Duration value) {
        if (monitoringIntervalBuilder_ == null) {
          if (monitoringInterval_ != null) {
            monitoringInterval_ =
                com.google.protobuf.Duration.newBuilder(monitoringInterval_)
                    .mergeFrom(value)
                    .buildPartial();
          } else {
            monitoringInterval_ = value;
          }
          onChanged();
        } else {
          monitoringIntervalBuilder_.mergeFrom(value);
        }

        return this;
      }
      /**
       *
       *
       * <pre>
       * Configuration of the snapshot analysis based monitoring pipeline running
       * interval. The value is rolled up to full day.
       * </pre>
       *
       * <code>.google.protobuf.Duration monitoring_interval = 2 [deprecated = true];</code>
       */
      @java.lang.Deprecated
      public Builder clearMonitoringInterval() {
        if (monitoringIntervalBuilder_ == null) {
          monitoringInterval_ = null;
          onChanged();
        } else {
          monitoringInterval_ = null;
          monitoringIntervalBuilder_ = null;
        }

        return this;
      }
      /**
       *
       *
       * <pre>
       * Configuration of the snapshot analysis based monitoring pipeline running
       * interval. The value is rolled up to full day.
       * </pre>
       *
       * <code>.google.protobuf.Duration monitoring_interval = 2 [deprecated = true];</code>
       */
      @java.lang.Deprecated
      public com.google.protobuf.Duration.Builder getMonitoringIntervalBuilder() {

        onChanged();
        return getMonitoringIntervalFieldBuilder().getBuilder();
      }
      /**
       *
       *
       * <pre>
       * Configuration of the snapshot analysis based monitoring pipeline running
       * interval. The value is rolled up to full day.
       * </pre>
       *
       * <code>.google.protobuf.Duration monitoring_interval = 2 [deprecated = true];</code>
       */
      @java.lang.Deprecated
      public com.google.protobuf.DurationOrBuilder getMonitoringIntervalOrBuilder() {
        if (monitoringIntervalBuilder_ != null) {
          return monitoringIntervalBuilder_.getMessageOrBuilder();
        } else {
          return monitoringInterval_ == null
              ? com.google.protobuf.Duration.getDefaultInstance()
              : monitoringInterval_;
        }
      }
      /**
       *
       *
       * <pre>
       * Configuration of the snapshot analysis based monitoring pipeline running
       * interval. The value is rolled up to full day.
       * </pre>
       *
       * <code>.google.protobuf.Duration monitoring_interval = 2 [deprecated = true];</code>
       */
      private com.google.protobuf.SingleFieldBuilderV3<
              com.google.protobuf.Duration,
              com.google.protobuf.Duration.Builder,
              com.google.protobuf.DurationOrBuilder>
          getMonitoringIntervalFieldBuilder() {
        if (monitoringIntervalBuilder_ == null) {
          monitoringIntervalBuilder_ =
              new com.google.protobuf.SingleFieldBuilderV3<
                  com.google.protobuf.Duration,
                  com.google.protobuf.Duration.Builder,
                  com.google.protobuf.DurationOrBuilder>(
                  getMonitoringInterval(), getParentForChildren(), isClean());
          monitoringInterval_ = null;
        }
        return monitoringIntervalBuilder_;
      }

      private int monitoringIntervalDays_;
      /**
       *
       *
       * <pre>
       * Configuration of the snapshot analysis based monitoring pipeline
       * running interval. The value indicates number of days.
       * If both
       * [FeaturestoreMonitoringConfig.SnapshotAnalysis.monitoring_interval_days][google.cloud.aiplatform.v1beta1.FeaturestoreMonitoringConfig.SnapshotAnalysis.monitoring_interval_days]
       * and [FeaturestoreMonitoringConfig.SnapshotAnalysis.monitoring_interval][google.cloud.aiplatform.v1beta1.FeaturestoreMonitoringConfig.SnapshotAnalysis.monitoring_interval]
       * are set when creating/updating EntityTypes/Features,
       * [FeaturestoreMonitoringConfig.SnapshotAnalysis.monitoring_interval_days][google.cloud.aiplatform.v1beta1.FeaturestoreMonitoringConfig.SnapshotAnalysis.monitoring_interval_days]
       * will be used.
       * </pre>
       *
       * <code>int32 monitoring_interval_days = 3;</code>
       *
       * @return The monitoringIntervalDays.
       */
      @java.lang.Override
      public int getMonitoringIntervalDays() {
        return monitoringIntervalDays_;
      }
      /**
       *
       *
       * <pre>
       * Configuration of the snapshot analysis based monitoring pipeline
       * running interval. The value indicates number of days.
       * If both
       * [FeaturestoreMonitoringConfig.SnapshotAnalysis.monitoring_interval_days][google.cloud.aiplatform.v1beta1.FeaturestoreMonitoringConfig.SnapshotAnalysis.monitoring_interval_days]
       * and [FeaturestoreMonitoringConfig.SnapshotAnalysis.monitoring_interval][google.cloud.aiplatform.v1beta1.FeaturestoreMonitoringConfig.SnapshotAnalysis.monitoring_interval]
       * are set when creating/updating EntityTypes/Features,
       * [FeaturestoreMonitoringConfig.SnapshotAnalysis.monitoring_interval_days][google.cloud.aiplatform.v1beta1.FeaturestoreMonitoringConfig.SnapshotAnalysis.monitoring_interval_days]
       * will be used.
       * </pre>
       *
       * <code>int32 monitoring_interval_days = 3;</code>
       *
       * @param value The monitoringIntervalDays to set.
       * @return This builder for chaining.
       */
      public Builder setMonitoringIntervalDays(int value) {

        monitoringIntervalDays_ = value;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Configuration of the snapshot analysis based monitoring pipeline
       * running interval. The value indicates number of days.
       * If both
       * [FeaturestoreMonitoringConfig.SnapshotAnalysis.monitoring_interval_days][google.cloud.aiplatform.v1beta1.FeaturestoreMonitoringConfig.SnapshotAnalysis.monitoring_interval_days]
       * and [FeaturestoreMonitoringConfig.SnapshotAnalysis.monitoring_interval][google.cloud.aiplatform.v1beta1.FeaturestoreMonitoringConfig.SnapshotAnalysis.monitoring_interval]
       * are set when creating/updating EntityTypes/Features,
       * [FeaturestoreMonitoringConfig.SnapshotAnalysis.monitoring_interval_days][google.cloud.aiplatform.v1beta1.FeaturestoreMonitoringConfig.SnapshotAnalysis.monitoring_interval_days]
       * will be used.
       * </pre>
       *
       * <code>int32 monitoring_interval_days = 3;</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearMonitoringIntervalDays() {

        monitoringIntervalDays_ = 0;
        onChanged();
        return this;
      }

      @java.lang.Override
      public final Builder setUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.setUnknownFields(unknownFields);
      }

      @java.lang.Override
      public final Builder mergeUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.mergeUnknownFields(unknownFields);
      }

      // @@protoc_insertion_point(builder_scope:google.cloud.aiplatform.v1beta1.FeaturestoreMonitoringConfig.SnapshotAnalysis)
    }

    // @@protoc_insertion_point(class_scope:google.cloud.aiplatform.v1beta1.FeaturestoreMonitoringConfig.SnapshotAnalysis)
    private static final com.google.cloud.aiplatform.v1beta1.FeaturestoreMonitoringConfig
            .SnapshotAnalysis
        DEFAULT_INSTANCE;

    static {
      DEFAULT_INSTANCE =
          new com.google.cloud.aiplatform.v1beta1.FeaturestoreMonitoringConfig.SnapshotAnalysis();
    }

    public static com.google.cloud.aiplatform.v1beta1.FeaturestoreMonitoringConfig.SnapshotAnalysis
        getDefaultInstance() {
      return DEFAULT_INSTANCE;
    }

    private static final com.google.protobuf.Parser<SnapshotAnalysis> PARSER =
        new com.google.protobuf.AbstractParser<SnapshotAnalysis>() {
          @java.lang.Override
          public SnapshotAnalysis parsePartialFrom(
              com.google.protobuf.CodedInputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
            return new SnapshotAnalysis(input, extensionRegistry);
          }
        };

    public static com.google.protobuf.Parser<SnapshotAnalysis> parser() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.protobuf.Parser<SnapshotAnalysis> getParserForType() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.cloud.aiplatform.v1beta1.FeaturestoreMonitoringConfig.SnapshotAnalysis
        getDefaultInstanceForType() {
      return DEFAULT_INSTANCE;
    }
  }

  public static final int SNAPSHOT_ANALYSIS_FIELD_NUMBER = 1;
  private com.google.cloud.aiplatform.v1beta1.FeaturestoreMonitoringConfig.SnapshotAnalysis
      snapshotAnalysis_;
  /**
   *
   *
   * <pre>
   * The config for Snapshot Analysis Based Feature Monitoring.
   * </pre>
   *
   * <code>
   * .google.cloud.aiplatform.v1beta1.FeaturestoreMonitoringConfig.SnapshotAnalysis snapshot_analysis = 1;
   * </code>
   *
   * @return Whether the snapshotAnalysis field is set.
   */
  @java.lang.Override
  public boolean hasSnapshotAnalysis() {
    return snapshotAnalysis_ != null;
  }
  /**
   *
   *
   * <pre>
   * The config for Snapshot Analysis Based Feature Monitoring.
   * </pre>
   *
   * <code>
   * .google.cloud.aiplatform.v1beta1.FeaturestoreMonitoringConfig.SnapshotAnalysis snapshot_analysis = 1;
   * </code>
   *
   * @return The snapshotAnalysis.
   */
  @java.lang.Override
  public com.google.cloud.aiplatform.v1beta1.FeaturestoreMonitoringConfig.SnapshotAnalysis
      getSnapshotAnalysis() {
    return snapshotAnalysis_ == null
        ? com.google.cloud.aiplatform.v1beta1.FeaturestoreMonitoringConfig.SnapshotAnalysis
            .getDefaultInstance()
        : snapshotAnalysis_;
  }
  /**
   *
   *
   * <pre>
   * The config for Snapshot Analysis Based Feature Monitoring.
   * </pre>
   *
   * <code>
   * .google.cloud.aiplatform.v1beta1.FeaturestoreMonitoringConfig.SnapshotAnalysis snapshot_analysis = 1;
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.aiplatform.v1beta1.FeaturestoreMonitoringConfig.SnapshotAnalysisOrBuilder
      getSnapshotAnalysisOrBuilder() {
    return getSnapshotAnalysis();
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    if (snapshotAnalysis_ != null) {
      output.writeMessage(1, getSnapshotAnalysis());
    }
    unknownFields.writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    if (snapshotAnalysis_ != null) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(1, getSnapshotAnalysis());
    }
    size += unknownFields.getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.cloud.aiplatform.v1beta1.FeaturestoreMonitoringConfig)) {
      return super.equals(obj);
    }
    com.google.cloud.aiplatform.v1beta1.FeaturestoreMonitoringConfig other =
        (com.google.cloud.aiplatform.v1beta1.FeaturestoreMonitoringConfig) obj;

    if (hasSnapshotAnalysis() != other.hasSnapshotAnalysis()) return false;
    if (hasSnapshotAnalysis()) {
      if (!getSnapshotAnalysis().equals(other.getSnapshotAnalysis())) return false;
    }
    if (!unknownFields.equals(other.unknownFields)) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    if (hasSnapshotAnalysis()) {
      hash = (37 * hash) + SNAPSHOT_ANALYSIS_FIELD_NUMBER;
      hash = (53 * hash) + getSnapshotAnalysis().hashCode();
    }
    hash = (29 * hash) + unknownFields.hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.cloud.aiplatform.v1beta1.FeaturestoreMonitoringConfig parseFrom(
      java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.aiplatform.v1beta1.FeaturestoreMonitoringConfig parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.aiplatform.v1beta1.FeaturestoreMonitoringConfig parseFrom(
      com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.aiplatform.v1beta1.FeaturestoreMonitoringConfig parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.aiplatform.v1beta1.FeaturestoreMonitoringConfig parseFrom(
      byte[] data) throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.aiplatform.v1beta1.FeaturestoreMonitoringConfig parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.aiplatform.v1beta1.FeaturestoreMonitoringConfig parseFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.aiplatform.v1beta1.FeaturestoreMonitoringConfig parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.aiplatform.v1beta1.FeaturestoreMonitoringConfig parseDelimitedFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.cloud.aiplatform.v1beta1.FeaturestoreMonitoringConfig parseDelimitedFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.aiplatform.v1beta1.FeaturestoreMonitoringConfig parseFrom(
      com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.aiplatform.v1beta1.FeaturestoreMonitoringConfig parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(
      com.google.cloud.aiplatform.v1beta1.FeaturestoreMonitoringConfig prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }
  /**
   *
   *
   * <pre>
   * Configuration of how features in Featurestore are monitored.
   * </pre>
   *
   * Protobuf type {@code google.cloud.aiplatform.v1beta1.FeaturestoreMonitoringConfig}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.cloud.aiplatform.v1beta1.FeaturestoreMonitoringConfig)
      com.google.cloud.aiplatform.v1beta1.FeaturestoreMonitoringConfigOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.aiplatform.v1beta1.FeaturestoreMonitoringProto
          .internal_static_google_cloud_aiplatform_v1beta1_FeaturestoreMonitoringConfig_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.aiplatform.v1beta1.FeaturestoreMonitoringProto
          .internal_static_google_cloud_aiplatform_v1beta1_FeaturestoreMonitoringConfig_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.aiplatform.v1beta1.FeaturestoreMonitoringConfig.class,
              com.google.cloud.aiplatform.v1beta1.FeaturestoreMonitoringConfig.Builder.class);
    }

    // Construct using com.google.cloud.aiplatform.v1beta1.FeaturestoreMonitoringConfig.newBuilder()
    private Builder() {
      maybeForceBuilderInitialization();
    }

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
      maybeForceBuilderInitialization();
    }

    private void maybeForceBuilderInitialization() {
      if (com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders) {}
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      if (snapshotAnalysisBuilder_ == null) {
        snapshotAnalysis_ = null;
      } else {
        snapshotAnalysis_ = null;
        snapshotAnalysisBuilder_ = null;
      }
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.cloud.aiplatform.v1beta1.FeaturestoreMonitoringProto
          .internal_static_google_cloud_aiplatform_v1beta1_FeaturestoreMonitoringConfig_descriptor;
    }

    @java.lang.Override
    public com.google.cloud.aiplatform.v1beta1.FeaturestoreMonitoringConfig
        getDefaultInstanceForType() {
      return com.google.cloud.aiplatform.v1beta1.FeaturestoreMonitoringConfig.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.cloud.aiplatform.v1beta1.FeaturestoreMonitoringConfig build() {
      com.google.cloud.aiplatform.v1beta1.FeaturestoreMonitoringConfig result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.cloud.aiplatform.v1beta1.FeaturestoreMonitoringConfig buildPartial() {
      com.google.cloud.aiplatform.v1beta1.FeaturestoreMonitoringConfig result =
          new com.google.cloud.aiplatform.v1beta1.FeaturestoreMonitoringConfig(this);
      if (snapshotAnalysisBuilder_ == null) {
        result.snapshotAnalysis_ = snapshotAnalysis_;
      } else {
        result.snapshotAnalysis_ = snapshotAnalysisBuilder_.build();
      }
      onBuilt();
      return result;
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.cloud.aiplatform.v1beta1.FeaturestoreMonitoringConfig) {
        return mergeFrom((com.google.cloud.aiplatform.v1beta1.FeaturestoreMonitoringConfig) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(
        com.google.cloud.aiplatform.v1beta1.FeaturestoreMonitoringConfig other) {
      if (other
          == com.google.cloud.aiplatform.v1beta1.FeaturestoreMonitoringConfig.getDefaultInstance())
        return this;
      if (other.hasSnapshotAnalysis()) {
        mergeSnapshotAnalysis(other.getSnapshotAnalysis());
      }
      this.mergeUnknownFields(other.unknownFields);
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      com.google.cloud.aiplatform.v1beta1.FeaturestoreMonitoringConfig parsedMessage = null;
      try {
        parsedMessage = PARSER.parsePartialFrom(input, extensionRegistry);
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        parsedMessage =
            (com.google.cloud.aiplatform.v1beta1.FeaturestoreMonitoringConfig)
                e.getUnfinishedMessage();
        throw e.unwrapIOException();
      } finally {
        if (parsedMessage != null) {
          mergeFrom(parsedMessage);
        }
      }
      return this;
    }

    private com.google.cloud.aiplatform.v1beta1.FeaturestoreMonitoringConfig.SnapshotAnalysis
        snapshotAnalysis_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.aiplatform.v1beta1.FeaturestoreMonitoringConfig.SnapshotAnalysis,
            com.google.cloud.aiplatform.v1beta1.FeaturestoreMonitoringConfig.SnapshotAnalysis
                .Builder,
            com.google.cloud.aiplatform.v1beta1.FeaturestoreMonitoringConfig
                .SnapshotAnalysisOrBuilder>
        snapshotAnalysisBuilder_;
    /**
     *
     *
     * <pre>
     * The config for Snapshot Analysis Based Feature Monitoring.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.FeaturestoreMonitoringConfig.SnapshotAnalysis snapshot_analysis = 1;
     * </code>
     *
     * @return Whether the snapshotAnalysis field is set.
     */
    public boolean hasSnapshotAnalysis() {
      return snapshotAnalysisBuilder_ != null || snapshotAnalysis_ != null;
    }
    /**
     *
     *
     * <pre>
     * The config for Snapshot Analysis Based Feature Monitoring.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.FeaturestoreMonitoringConfig.SnapshotAnalysis snapshot_analysis = 1;
     * </code>
     *
     * @return The snapshotAnalysis.
     */
    public com.google.cloud.aiplatform.v1beta1.FeaturestoreMonitoringConfig.SnapshotAnalysis
        getSnapshotAnalysis() {
      if (snapshotAnalysisBuilder_ == null) {
        return snapshotAnalysis_ == null
            ? com.google.cloud.aiplatform.v1beta1.FeaturestoreMonitoringConfig.SnapshotAnalysis
                .getDefaultInstance()
            : snapshotAnalysis_;
      } else {
        return snapshotAnalysisBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * The config for Snapshot Analysis Based Feature Monitoring.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.FeaturestoreMonitoringConfig.SnapshotAnalysis snapshot_analysis = 1;
     * </code>
     */
    public Builder setSnapshotAnalysis(
        com.google.cloud.aiplatform.v1beta1.FeaturestoreMonitoringConfig.SnapshotAnalysis value) {
      if (snapshotAnalysisBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        snapshotAnalysis_ = value;
        onChanged();
      } else {
        snapshotAnalysisBuilder_.setMessage(value);
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * The config for Snapshot Analysis Based Feature Monitoring.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.FeaturestoreMonitoringConfig.SnapshotAnalysis snapshot_analysis = 1;
     * </code>
     */
    public Builder setSnapshotAnalysis(
        com.google.cloud.aiplatform.v1beta1.FeaturestoreMonitoringConfig.SnapshotAnalysis.Builder
            builderForValue) {
      if (snapshotAnalysisBuilder_ == null) {
        snapshotAnalysis_ = builderForValue.build();
        onChanged();
      } else {
        snapshotAnalysisBuilder_.setMessage(builderForValue.build());
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * The config for Snapshot Analysis Based Feature Monitoring.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.FeaturestoreMonitoringConfig.SnapshotAnalysis snapshot_analysis = 1;
     * </code>
     */
    public Builder mergeSnapshotAnalysis(
        com.google.cloud.aiplatform.v1beta1.FeaturestoreMonitoringConfig.SnapshotAnalysis value) {
      if (snapshotAnalysisBuilder_ == null) {
        if (snapshotAnalysis_ != null) {
          snapshotAnalysis_ =
              com.google.cloud.aiplatform.v1beta1.FeaturestoreMonitoringConfig.SnapshotAnalysis
                  .newBuilder(snapshotAnalysis_)
                  .mergeFrom(value)
                  .buildPartial();
        } else {
          snapshotAnalysis_ = value;
        }
        onChanged();
      } else {
        snapshotAnalysisBuilder_.mergeFrom(value);
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * The config for Snapshot Analysis Based Feature Monitoring.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.FeaturestoreMonitoringConfig.SnapshotAnalysis snapshot_analysis = 1;
     * </code>
     */
    public Builder clearSnapshotAnalysis() {
      if (snapshotAnalysisBuilder_ == null) {
        snapshotAnalysis_ = null;
        onChanged();
      } else {
        snapshotAnalysis_ = null;
        snapshotAnalysisBuilder_ = null;
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * The config for Snapshot Analysis Based Feature Monitoring.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.FeaturestoreMonitoringConfig.SnapshotAnalysis snapshot_analysis = 1;
     * </code>
     */
    public com.google.cloud.aiplatform.v1beta1.FeaturestoreMonitoringConfig.SnapshotAnalysis.Builder
        getSnapshotAnalysisBuilder() {

      onChanged();
      return getSnapshotAnalysisFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * The config for Snapshot Analysis Based Feature Monitoring.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.FeaturestoreMonitoringConfig.SnapshotAnalysis snapshot_analysis = 1;
     * </code>
     */
    public com.google.cloud.aiplatform.v1beta1.FeaturestoreMonitoringConfig
            .SnapshotAnalysisOrBuilder
        getSnapshotAnalysisOrBuilder() {
      if (snapshotAnalysisBuilder_ != null) {
        return snapshotAnalysisBuilder_.getMessageOrBuilder();
      } else {
        return snapshotAnalysis_ == null
            ? com.google.cloud.aiplatform.v1beta1.FeaturestoreMonitoringConfig.SnapshotAnalysis
                .getDefaultInstance()
            : snapshotAnalysis_;
      }
    }
    /**
     *
     *
     * <pre>
     * The config for Snapshot Analysis Based Feature Monitoring.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.FeaturestoreMonitoringConfig.SnapshotAnalysis snapshot_analysis = 1;
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.aiplatform.v1beta1.FeaturestoreMonitoringConfig.SnapshotAnalysis,
            com.google.cloud.aiplatform.v1beta1.FeaturestoreMonitoringConfig.SnapshotAnalysis
                .Builder,
            com.google.cloud.aiplatform.v1beta1.FeaturestoreMonitoringConfig
                .SnapshotAnalysisOrBuilder>
        getSnapshotAnalysisFieldBuilder() {
      if (snapshotAnalysisBuilder_ == null) {
        snapshotAnalysisBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.aiplatform.v1beta1.FeaturestoreMonitoringConfig.SnapshotAnalysis,
                com.google.cloud.aiplatform.v1beta1.FeaturestoreMonitoringConfig.SnapshotAnalysis
                    .Builder,
                com.google.cloud.aiplatform.v1beta1.FeaturestoreMonitoringConfig
                    .SnapshotAnalysisOrBuilder>(
                getSnapshotAnalysis(), getParentForChildren(), isClean());
        snapshotAnalysis_ = null;
      }
      return snapshotAnalysisBuilder_;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.cloud.aiplatform.v1beta1.FeaturestoreMonitoringConfig)
  }

  // @@protoc_insertion_point(class_scope:google.cloud.aiplatform.v1beta1.FeaturestoreMonitoringConfig)
  private static final com.google.cloud.aiplatform.v1beta1.FeaturestoreMonitoringConfig
      DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.cloud.aiplatform.v1beta1.FeaturestoreMonitoringConfig();
  }

  public static com.google.cloud.aiplatform.v1beta1.FeaturestoreMonitoringConfig
      getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<FeaturestoreMonitoringConfig> PARSER =
      new com.google.protobuf.AbstractParser<FeaturestoreMonitoringConfig>() {
        @java.lang.Override
        public FeaturestoreMonitoringConfig parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          return new FeaturestoreMonitoringConfig(input, extensionRegistry);
        }
      };

  public static com.google.protobuf.Parser<FeaturestoreMonitoringConfig> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<FeaturestoreMonitoringConfig> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.cloud.aiplatform.v1beta1.FeaturestoreMonitoringConfig
      getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
