/*
 * Copyright 2020 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/cloud/aiplatform/v1beta1/training_pipeline.proto

package com.google.cloud.aiplatform.v1beta1;

/**
 *
 *
 * <pre>
 * Specifies Vertex AI owned input data to be used for training, and
 * possibly evaluating, the Model.
 * </pre>
 *
 * Protobuf type {@code google.cloud.aiplatform.v1beta1.InputDataConfig}
 */
public final class InputDataConfig extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.cloud.aiplatform.v1beta1.InputDataConfig)
    InputDataConfigOrBuilder {
  private static final long serialVersionUID = 0L;
  // Use InputDataConfig.newBuilder() to construct.
  private InputDataConfig(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private InputDataConfig() {
    datasetId_ = "";
    annotationsFilter_ = "";
    annotationSchemaUri_ = "";
  }

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new InputDataConfig();
  }

  @java.lang.Override
  public final com.google.protobuf.UnknownFieldSet getUnknownFields() {
    return this.unknownFields;
  }

  private InputDataConfig(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    this();
    if (extensionRegistry == null) {
      throw new java.lang.NullPointerException();
    }
    com.google.protobuf.UnknownFieldSet.Builder unknownFields =
        com.google.protobuf.UnknownFieldSet.newBuilder();
    try {
      boolean done = false;
      while (!done) {
        int tag = input.readTag();
        switch (tag) {
          case 0:
            done = true;
            break;
          case 10:
            {
              java.lang.String s = input.readStringRequireUtf8();

              datasetId_ = s;
              break;
            }
          case 18:
            {
              com.google.cloud.aiplatform.v1beta1.FractionSplit.Builder subBuilder = null;
              if (splitCase_ == 2) {
                subBuilder =
                    ((com.google.cloud.aiplatform.v1beta1.FractionSplit) split_).toBuilder();
              }
              split_ =
                  input.readMessage(
                      com.google.cloud.aiplatform.v1beta1.FractionSplit.parser(),
                      extensionRegistry);
              if (subBuilder != null) {
                subBuilder.mergeFrom((com.google.cloud.aiplatform.v1beta1.FractionSplit) split_);
                split_ = subBuilder.buildPartial();
              }
              splitCase_ = 2;
              break;
            }
          case 26:
            {
              com.google.cloud.aiplatform.v1beta1.FilterSplit.Builder subBuilder = null;
              if (splitCase_ == 3) {
                subBuilder = ((com.google.cloud.aiplatform.v1beta1.FilterSplit) split_).toBuilder();
              }
              split_ =
                  input.readMessage(
                      com.google.cloud.aiplatform.v1beta1.FilterSplit.parser(), extensionRegistry);
              if (subBuilder != null) {
                subBuilder.mergeFrom((com.google.cloud.aiplatform.v1beta1.FilterSplit) split_);
                split_ = subBuilder.buildPartial();
              }
              splitCase_ = 3;
              break;
            }
          case 34:
            {
              com.google.cloud.aiplatform.v1beta1.PredefinedSplit.Builder subBuilder = null;
              if (splitCase_ == 4) {
                subBuilder =
                    ((com.google.cloud.aiplatform.v1beta1.PredefinedSplit) split_).toBuilder();
              }
              split_ =
                  input.readMessage(
                      com.google.cloud.aiplatform.v1beta1.PredefinedSplit.parser(),
                      extensionRegistry);
              if (subBuilder != null) {
                subBuilder.mergeFrom((com.google.cloud.aiplatform.v1beta1.PredefinedSplit) split_);
                split_ = subBuilder.buildPartial();
              }
              splitCase_ = 4;
              break;
            }
          case 42:
            {
              com.google.cloud.aiplatform.v1beta1.TimestampSplit.Builder subBuilder = null;
              if (splitCase_ == 5) {
                subBuilder =
                    ((com.google.cloud.aiplatform.v1beta1.TimestampSplit) split_).toBuilder();
              }
              split_ =
                  input.readMessage(
                      com.google.cloud.aiplatform.v1beta1.TimestampSplit.parser(),
                      extensionRegistry);
              if (subBuilder != null) {
                subBuilder.mergeFrom((com.google.cloud.aiplatform.v1beta1.TimestampSplit) split_);
                split_ = subBuilder.buildPartial();
              }
              splitCase_ = 5;
              break;
            }
          case 50:
            {
              java.lang.String s = input.readStringRequireUtf8();

              annotationsFilter_ = s;
              break;
            }
          case 66:
            {
              com.google.cloud.aiplatform.v1beta1.GcsDestination.Builder subBuilder = null;
              if (destinationCase_ == 8) {
                subBuilder =
                    ((com.google.cloud.aiplatform.v1beta1.GcsDestination) destination_).toBuilder();
              }
              destination_ =
                  input.readMessage(
                      com.google.cloud.aiplatform.v1beta1.GcsDestination.parser(),
                      extensionRegistry);
              if (subBuilder != null) {
                subBuilder.mergeFrom(
                    (com.google.cloud.aiplatform.v1beta1.GcsDestination) destination_);
                destination_ = subBuilder.buildPartial();
              }
              destinationCase_ = 8;
              break;
            }
          case 74:
            {
              java.lang.String s = input.readStringRequireUtf8();

              annotationSchemaUri_ = s;
              break;
            }
          case 82:
            {
              com.google.cloud.aiplatform.v1beta1.BigQueryDestination.Builder subBuilder = null;
              if (destinationCase_ == 10) {
                subBuilder =
                    ((com.google.cloud.aiplatform.v1beta1.BigQueryDestination) destination_)
                        .toBuilder();
              }
              destination_ =
                  input.readMessage(
                      com.google.cloud.aiplatform.v1beta1.BigQueryDestination.parser(),
                      extensionRegistry);
              if (subBuilder != null) {
                subBuilder.mergeFrom(
                    (com.google.cloud.aiplatform.v1beta1.BigQueryDestination) destination_);
                destination_ = subBuilder.buildPartial();
              }
              destinationCase_ = 10;
              break;
            }
          default:
            {
              if (!parseUnknownField(input, unknownFields, extensionRegistry, tag)) {
                done = true;
              }
              break;
            }
        }
      }
    } catch (com.google.protobuf.InvalidProtocolBufferException e) {
      throw e.setUnfinishedMessage(this);
    } catch (java.io.IOException e) {
      throw new com.google.protobuf.InvalidProtocolBufferException(e).setUnfinishedMessage(this);
    } finally {
      this.unknownFields = unknownFields.build();
      makeExtensionsImmutable();
    }
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.cloud.aiplatform.v1beta1.TrainingPipelineProto
        .internal_static_google_cloud_aiplatform_v1beta1_InputDataConfig_descriptor;
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.cloud.aiplatform.v1beta1.TrainingPipelineProto
        .internal_static_google_cloud_aiplatform_v1beta1_InputDataConfig_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.cloud.aiplatform.v1beta1.InputDataConfig.class,
            com.google.cloud.aiplatform.v1beta1.InputDataConfig.Builder.class);
  }

  private int splitCase_ = 0;
  private java.lang.Object split_;

  public enum SplitCase
      implements
          com.google.protobuf.Internal.EnumLite,
          com.google.protobuf.AbstractMessage.InternalOneOfEnum {
    FRACTION_SPLIT(2),
    FILTER_SPLIT(3),
    PREDEFINED_SPLIT(4),
    TIMESTAMP_SPLIT(5),
    SPLIT_NOT_SET(0);
    private final int value;

    private SplitCase(int value) {
      this.value = value;
    }
    /**
     * @param value The number of the enum to look for.
     * @return The enum associated with the given number.
     * @deprecated Use {@link #forNumber(int)} instead.
     */
    @java.lang.Deprecated
    public static SplitCase valueOf(int value) {
      return forNumber(value);
    }

    public static SplitCase forNumber(int value) {
      switch (value) {
        case 2:
          return FRACTION_SPLIT;
        case 3:
          return FILTER_SPLIT;
        case 4:
          return PREDEFINED_SPLIT;
        case 5:
          return TIMESTAMP_SPLIT;
        case 0:
          return SPLIT_NOT_SET;
        default:
          return null;
      }
    }

    public int getNumber() {
      return this.value;
    }
  };

  public SplitCase getSplitCase() {
    return SplitCase.forNumber(splitCase_);
  }

  private int destinationCase_ = 0;
  private java.lang.Object destination_;

  public enum DestinationCase
      implements
          com.google.protobuf.Internal.EnumLite,
          com.google.protobuf.AbstractMessage.InternalOneOfEnum {
    GCS_DESTINATION(8),
    BIGQUERY_DESTINATION(10),
    DESTINATION_NOT_SET(0);
    private final int value;

    private DestinationCase(int value) {
      this.value = value;
    }
    /**
     * @param value The number of the enum to look for.
     * @return The enum associated with the given number.
     * @deprecated Use {@link #forNumber(int)} instead.
     */
    @java.lang.Deprecated
    public static DestinationCase valueOf(int value) {
      return forNumber(value);
    }

    public static DestinationCase forNumber(int value) {
      switch (value) {
        case 8:
          return GCS_DESTINATION;
        case 10:
          return BIGQUERY_DESTINATION;
        case 0:
          return DESTINATION_NOT_SET;
        default:
          return null;
      }
    }

    public int getNumber() {
      return this.value;
    }
  };

  public DestinationCase getDestinationCase() {
    return DestinationCase.forNumber(destinationCase_);
  }

  public static final int FRACTION_SPLIT_FIELD_NUMBER = 2;
  /**
   *
   *
   * <pre>
   * Split based on fractions defining the size of each set.
   * </pre>
   *
   * <code>.google.cloud.aiplatform.v1beta1.FractionSplit fraction_split = 2;</code>
   *
   * @return Whether the fractionSplit field is set.
   */
  @java.lang.Override
  public boolean hasFractionSplit() {
    return splitCase_ == 2;
  }
  /**
   *
   *
   * <pre>
   * Split based on fractions defining the size of each set.
   * </pre>
   *
   * <code>.google.cloud.aiplatform.v1beta1.FractionSplit fraction_split = 2;</code>
   *
   * @return The fractionSplit.
   */
  @java.lang.Override
  public com.google.cloud.aiplatform.v1beta1.FractionSplit getFractionSplit() {
    if (splitCase_ == 2) {
      return (com.google.cloud.aiplatform.v1beta1.FractionSplit) split_;
    }
    return com.google.cloud.aiplatform.v1beta1.FractionSplit.getDefaultInstance();
  }
  /**
   *
   *
   * <pre>
   * Split based on fractions defining the size of each set.
   * </pre>
   *
   * <code>.google.cloud.aiplatform.v1beta1.FractionSplit fraction_split = 2;</code>
   */
  @java.lang.Override
  public com.google.cloud.aiplatform.v1beta1.FractionSplitOrBuilder getFractionSplitOrBuilder() {
    if (splitCase_ == 2) {
      return (com.google.cloud.aiplatform.v1beta1.FractionSplit) split_;
    }
    return com.google.cloud.aiplatform.v1beta1.FractionSplit.getDefaultInstance();
  }

  public static final int FILTER_SPLIT_FIELD_NUMBER = 3;
  /**
   *
   *
   * <pre>
   * Split based on the provided filters for each set.
   * </pre>
   *
   * <code>.google.cloud.aiplatform.v1beta1.FilterSplit filter_split = 3;</code>
   *
   * @return Whether the filterSplit field is set.
   */
  @java.lang.Override
  public boolean hasFilterSplit() {
    return splitCase_ == 3;
  }
  /**
   *
   *
   * <pre>
   * Split based on the provided filters for each set.
   * </pre>
   *
   * <code>.google.cloud.aiplatform.v1beta1.FilterSplit filter_split = 3;</code>
   *
   * @return The filterSplit.
   */
  @java.lang.Override
  public com.google.cloud.aiplatform.v1beta1.FilterSplit getFilterSplit() {
    if (splitCase_ == 3) {
      return (com.google.cloud.aiplatform.v1beta1.FilterSplit) split_;
    }
    return com.google.cloud.aiplatform.v1beta1.FilterSplit.getDefaultInstance();
  }
  /**
   *
   *
   * <pre>
   * Split based on the provided filters for each set.
   * </pre>
   *
   * <code>.google.cloud.aiplatform.v1beta1.FilterSplit filter_split = 3;</code>
   */
  @java.lang.Override
  public com.google.cloud.aiplatform.v1beta1.FilterSplitOrBuilder getFilterSplitOrBuilder() {
    if (splitCase_ == 3) {
      return (com.google.cloud.aiplatform.v1beta1.FilterSplit) split_;
    }
    return com.google.cloud.aiplatform.v1beta1.FilterSplit.getDefaultInstance();
  }

  public static final int PREDEFINED_SPLIT_FIELD_NUMBER = 4;
  /**
   *
   *
   * <pre>
   * Supported only for tabular Datasets.
   * Split based on a predefined key.
   * </pre>
   *
   * <code>.google.cloud.aiplatform.v1beta1.PredefinedSplit predefined_split = 4;</code>
   *
   * @return Whether the predefinedSplit field is set.
   */
  @java.lang.Override
  public boolean hasPredefinedSplit() {
    return splitCase_ == 4;
  }
  /**
   *
   *
   * <pre>
   * Supported only for tabular Datasets.
   * Split based on a predefined key.
   * </pre>
   *
   * <code>.google.cloud.aiplatform.v1beta1.PredefinedSplit predefined_split = 4;</code>
   *
   * @return The predefinedSplit.
   */
  @java.lang.Override
  public com.google.cloud.aiplatform.v1beta1.PredefinedSplit getPredefinedSplit() {
    if (splitCase_ == 4) {
      return (com.google.cloud.aiplatform.v1beta1.PredefinedSplit) split_;
    }
    return com.google.cloud.aiplatform.v1beta1.PredefinedSplit.getDefaultInstance();
  }
  /**
   *
   *
   * <pre>
   * Supported only for tabular Datasets.
   * Split based on a predefined key.
   * </pre>
   *
   * <code>.google.cloud.aiplatform.v1beta1.PredefinedSplit predefined_split = 4;</code>
   */
  @java.lang.Override
  public com.google.cloud.aiplatform.v1beta1.PredefinedSplitOrBuilder
      getPredefinedSplitOrBuilder() {
    if (splitCase_ == 4) {
      return (com.google.cloud.aiplatform.v1beta1.PredefinedSplit) split_;
    }
    return com.google.cloud.aiplatform.v1beta1.PredefinedSplit.getDefaultInstance();
  }

  public static final int TIMESTAMP_SPLIT_FIELD_NUMBER = 5;
  /**
   *
   *
   * <pre>
   * Supported only for tabular Datasets.
   * Split based on the timestamp of the input data pieces.
   * </pre>
   *
   * <code>.google.cloud.aiplatform.v1beta1.TimestampSplit timestamp_split = 5;</code>
   *
   * @return Whether the timestampSplit field is set.
   */
  @java.lang.Override
  public boolean hasTimestampSplit() {
    return splitCase_ == 5;
  }
  /**
   *
   *
   * <pre>
   * Supported only for tabular Datasets.
   * Split based on the timestamp of the input data pieces.
   * </pre>
   *
   * <code>.google.cloud.aiplatform.v1beta1.TimestampSplit timestamp_split = 5;</code>
   *
   * @return The timestampSplit.
   */
  @java.lang.Override
  public com.google.cloud.aiplatform.v1beta1.TimestampSplit getTimestampSplit() {
    if (splitCase_ == 5) {
      return (com.google.cloud.aiplatform.v1beta1.TimestampSplit) split_;
    }
    return com.google.cloud.aiplatform.v1beta1.TimestampSplit.getDefaultInstance();
  }
  /**
   *
   *
   * <pre>
   * Supported only for tabular Datasets.
   * Split based on the timestamp of the input data pieces.
   * </pre>
   *
   * <code>.google.cloud.aiplatform.v1beta1.TimestampSplit timestamp_split = 5;</code>
   */
  @java.lang.Override
  public com.google.cloud.aiplatform.v1beta1.TimestampSplitOrBuilder getTimestampSplitOrBuilder() {
    if (splitCase_ == 5) {
      return (com.google.cloud.aiplatform.v1beta1.TimestampSplit) split_;
    }
    return com.google.cloud.aiplatform.v1beta1.TimestampSplit.getDefaultInstance();
  }

  public static final int GCS_DESTINATION_FIELD_NUMBER = 8;
  /**
   *
   *
   * <pre>
   * The Cloud Storage location where the training data is to be
   * written to. In the given directory a new directory is created with
   * name:
   * `dataset-&lt;dataset-id&gt;-&lt;annotation-type&gt;-&lt;timestamp-of-training-call&gt;`
   * where timestamp is in YYYY-MM-DDThh:mm:ss.sssZ ISO-8601 format.
   * All training input data is written into that directory.
   * The Vertex AI environment variables representing Cloud Storage
   * data URIs are represented in the Cloud Storage wildcard
   * format to support sharded data. e.g.: "gs://.../training-*.jsonl"
   * * AIP_DATA_FORMAT = "jsonl" for non-tabular data, "csv" for tabular data
   * * AIP_TRAINING_DATA_URI =
   * "gcs_destination/dataset-&lt;dataset-id&gt;-&lt;annotation-type&gt;-&lt;time&gt;/training-*.${AIP_DATA_FORMAT}"
   * * AIP_VALIDATION_DATA_URI =
   * "gcs_destination/dataset-&lt;dataset-id&gt;-&lt;annotation-type&gt;-&lt;time&gt;/validation-*.${AIP_DATA_FORMAT}"
   * * AIP_TEST_DATA_URI =
   * "gcs_destination/dataset-&lt;dataset-id&gt;-&lt;annotation-type&gt;-&lt;time&gt;/test-*.${AIP_DATA_FORMAT}"
   * </pre>
   *
   * <code>.google.cloud.aiplatform.v1beta1.GcsDestination gcs_destination = 8;</code>
   *
   * @return Whether the gcsDestination field is set.
   */
  @java.lang.Override
  public boolean hasGcsDestination() {
    return destinationCase_ == 8;
  }
  /**
   *
   *
   * <pre>
   * The Cloud Storage location where the training data is to be
   * written to. In the given directory a new directory is created with
   * name:
   * `dataset-&lt;dataset-id&gt;-&lt;annotation-type&gt;-&lt;timestamp-of-training-call&gt;`
   * where timestamp is in YYYY-MM-DDThh:mm:ss.sssZ ISO-8601 format.
   * All training input data is written into that directory.
   * The Vertex AI environment variables representing Cloud Storage
   * data URIs are represented in the Cloud Storage wildcard
   * format to support sharded data. e.g.: "gs://.../training-*.jsonl"
   * * AIP_DATA_FORMAT = "jsonl" for non-tabular data, "csv" for tabular data
   * * AIP_TRAINING_DATA_URI =
   * "gcs_destination/dataset-&lt;dataset-id&gt;-&lt;annotation-type&gt;-&lt;time&gt;/training-*.${AIP_DATA_FORMAT}"
   * * AIP_VALIDATION_DATA_URI =
   * "gcs_destination/dataset-&lt;dataset-id&gt;-&lt;annotation-type&gt;-&lt;time&gt;/validation-*.${AIP_DATA_FORMAT}"
   * * AIP_TEST_DATA_URI =
   * "gcs_destination/dataset-&lt;dataset-id&gt;-&lt;annotation-type&gt;-&lt;time&gt;/test-*.${AIP_DATA_FORMAT}"
   * </pre>
   *
   * <code>.google.cloud.aiplatform.v1beta1.GcsDestination gcs_destination = 8;</code>
   *
   * @return The gcsDestination.
   */
  @java.lang.Override
  public com.google.cloud.aiplatform.v1beta1.GcsDestination getGcsDestination() {
    if (destinationCase_ == 8) {
      return (com.google.cloud.aiplatform.v1beta1.GcsDestination) destination_;
    }
    return com.google.cloud.aiplatform.v1beta1.GcsDestination.getDefaultInstance();
  }
  /**
   *
   *
   * <pre>
   * The Cloud Storage location where the training data is to be
   * written to. In the given directory a new directory is created with
   * name:
   * `dataset-&lt;dataset-id&gt;-&lt;annotation-type&gt;-&lt;timestamp-of-training-call&gt;`
   * where timestamp is in YYYY-MM-DDThh:mm:ss.sssZ ISO-8601 format.
   * All training input data is written into that directory.
   * The Vertex AI environment variables representing Cloud Storage
   * data URIs are represented in the Cloud Storage wildcard
   * format to support sharded data. e.g.: "gs://.../training-*.jsonl"
   * * AIP_DATA_FORMAT = "jsonl" for non-tabular data, "csv" for tabular data
   * * AIP_TRAINING_DATA_URI =
   * "gcs_destination/dataset-&lt;dataset-id&gt;-&lt;annotation-type&gt;-&lt;time&gt;/training-*.${AIP_DATA_FORMAT}"
   * * AIP_VALIDATION_DATA_URI =
   * "gcs_destination/dataset-&lt;dataset-id&gt;-&lt;annotation-type&gt;-&lt;time&gt;/validation-*.${AIP_DATA_FORMAT}"
   * * AIP_TEST_DATA_URI =
   * "gcs_destination/dataset-&lt;dataset-id&gt;-&lt;annotation-type&gt;-&lt;time&gt;/test-*.${AIP_DATA_FORMAT}"
   * </pre>
   *
   * <code>.google.cloud.aiplatform.v1beta1.GcsDestination gcs_destination = 8;</code>
   */
  @java.lang.Override
  public com.google.cloud.aiplatform.v1beta1.GcsDestinationOrBuilder getGcsDestinationOrBuilder() {
    if (destinationCase_ == 8) {
      return (com.google.cloud.aiplatform.v1beta1.GcsDestination) destination_;
    }
    return com.google.cloud.aiplatform.v1beta1.GcsDestination.getDefaultInstance();
  }

  public static final int BIGQUERY_DESTINATION_FIELD_NUMBER = 10;
  /**
   *
   *
   * <pre>
   * Only applicable to custom training with tabular Dataset with BigQuery
   * source.
   * The BigQuery project location where the training data is to be written
   * to. In the given project a new dataset is created with name
   * `dataset_&lt;dataset-id&gt;_&lt;annotation-type&gt;_&lt;timestamp-of-training-call&gt;`
   * where timestamp is in YYYY_MM_DDThh_mm_ss_sssZ format. All training
   * input data is written into that dataset. In the dataset three
   * tables are created, `training`, `validation` and `test`.
   * * AIP_DATA_FORMAT = "bigquery".
   * * AIP_TRAINING_DATA_URI  =
   * "bigquery_destination.dataset_&lt;dataset-id&gt;_&lt;annotation-type&gt;_&lt;time&gt;.training"
   * * AIP_VALIDATION_DATA_URI =
   * "bigquery_destination.dataset_&lt;dataset-id&gt;_&lt;annotation-type&gt;_&lt;time&gt;.validation"
   * * AIP_TEST_DATA_URI =
   * "bigquery_destination.dataset_&lt;dataset-id&gt;_&lt;annotation-type&gt;_&lt;time&gt;.test"
   * </pre>
   *
   * <code>.google.cloud.aiplatform.v1beta1.BigQueryDestination bigquery_destination = 10;</code>
   *
   * @return Whether the bigqueryDestination field is set.
   */
  @java.lang.Override
  public boolean hasBigqueryDestination() {
    return destinationCase_ == 10;
  }
  /**
   *
   *
   * <pre>
   * Only applicable to custom training with tabular Dataset with BigQuery
   * source.
   * The BigQuery project location where the training data is to be written
   * to. In the given project a new dataset is created with name
   * `dataset_&lt;dataset-id&gt;_&lt;annotation-type&gt;_&lt;timestamp-of-training-call&gt;`
   * where timestamp is in YYYY_MM_DDThh_mm_ss_sssZ format. All training
   * input data is written into that dataset. In the dataset three
   * tables are created, `training`, `validation` and `test`.
   * * AIP_DATA_FORMAT = "bigquery".
   * * AIP_TRAINING_DATA_URI  =
   * "bigquery_destination.dataset_&lt;dataset-id&gt;_&lt;annotation-type&gt;_&lt;time&gt;.training"
   * * AIP_VALIDATION_DATA_URI =
   * "bigquery_destination.dataset_&lt;dataset-id&gt;_&lt;annotation-type&gt;_&lt;time&gt;.validation"
   * * AIP_TEST_DATA_URI =
   * "bigquery_destination.dataset_&lt;dataset-id&gt;_&lt;annotation-type&gt;_&lt;time&gt;.test"
   * </pre>
   *
   * <code>.google.cloud.aiplatform.v1beta1.BigQueryDestination bigquery_destination = 10;</code>
   *
   * @return The bigqueryDestination.
   */
  @java.lang.Override
  public com.google.cloud.aiplatform.v1beta1.BigQueryDestination getBigqueryDestination() {
    if (destinationCase_ == 10) {
      return (com.google.cloud.aiplatform.v1beta1.BigQueryDestination) destination_;
    }
    return com.google.cloud.aiplatform.v1beta1.BigQueryDestination.getDefaultInstance();
  }
  /**
   *
   *
   * <pre>
   * Only applicable to custom training with tabular Dataset with BigQuery
   * source.
   * The BigQuery project location where the training data is to be written
   * to. In the given project a new dataset is created with name
   * `dataset_&lt;dataset-id&gt;_&lt;annotation-type&gt;_&lt;timestamp-of-training-call&gt;`
   * where timestamp is in YYYY_MM_DDThh_mm_ss_sssZ format. All training
   * input data is written into that dataset. In the dataset three
   * tables are created, `training`, `validation` and `test`.
   * * AIP_DATA_FORMAT = "bigquery".
   * * AIP_TRAINING_DATA_URI  =
   * "bigquery_destination.dataset_&lt;dataset-id&gt;_&lt;annotation-type&gt;_&lt;time&gt;.training"
   * * AIP_VALIDATION_DATA_URI =
   * "bigquery_destination.dataset_&lt;dataset-id&gt;_&lt;annotation-type&gt;_&lt;time&gt;.validation"
   * * AIP_TEST_DATA_URI =
   * "bigquery_destination.dataset_&lt;dataset-id&gt;_&lt;annotation-type&gt;_&lt;time&gt;.test"
   * </pre>
   *
   * <code>.google.cloud.aiplatform.v1beta1.BigQueryDestination bigquery_destination = 10;</code>
   */
  @java.lang.Override
  public com.google.cloud.aiplatform.v1beta1.BigQueryDestinationOrBuilder
      getBigqueryDestinationOrBuilder() {
    if (destinationCase_ == 10) {
      return (com.google.cloud.aiplatform.v1beta1.BigQueryDestination) destination_;
    }
    return com.google.cloud.aiplatform.v1beta1.BigQueryDestination.getDefaultInstance();
  }

  public static final int DATASET_ID_FIELD_NUMBER = 1;
  private volatile java.lang.Object datasetId_;
  /**
   *
   *
   * <pre>
   * Required. The ID of the Dataset in the same Project and Location which data will be
   * used to train the Model. The Dataset must use schema compatible with
   * Model being trained, and what is compatible should be described in the
   * used TrainingPipeline's [training_task_definition]
   * [google.cloud.aiplatform.v1beta1.TrainingPipeline.training_task_definition].
   * For tabular Datasets, all their data is exported to training, to pick
   * and choose from.
   * </pre>
   *
   * <code>string dataset_id = 1 [(.google.api.field_behavior) = REQUIRED];</code>
   *
   * @return The datasetId.
   */
  @java.lang.Override
  public java.lang.String getDatasetId() {
    java.lang.Object ref = datasetId_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      datasetId_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Required. The ID of the Dataset in the same Project and Location which data will be
   * used to train the Model. The Dataset must use schema compatible with
   * Model being trained, and what is compatible should be described in the
   * used TrainingPipeline's [training_task_definition]
   * [google.cloud.aiplatform.v1beta1.TrainingPipeline.training_task_definition].
   * For tabular Datasets, all their data is exported to training, to pick
   * and choose from.
   * </pre>
   *
   * <code>string dataset_id = 1 [(.google.api.field_behavior) = REQUIRED];</code>
   *
   * @return The bytes for datasetId.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getDatasetIdBytes() {
    java.lang.Object ref = datasetId_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      datasetId_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int ANNOTATIONS_FILTER_FIELD_NUMBER = 6;
  private volatile java.lang.Object annotationsFilter_;
  /**
   *
   *
   * <pre>
   * Applicable only to Datasets that have DataItems and Annotations.
   * A filter on Annotations of the Dataset. Only Annotations that both
   * match this filter and belong to DataItems not ignored by the split method
   * are used in respectively training, validation or test role, depending on
   * the role of the DataItem they are on (for the auto-assigned that role is
   * decided by Vertex AI). A filter with same syntax as the one used in
   * [ListAnnotations][google.cloud.aiplatform.v1beta1.DatasetService.ListAnnotations] may be used, but note
   * here it filters across all Annotations of the Dataset, and not just within
   * a single DataItem.
   * </pre>
   *
   * <code>string annotations_filter = 6;</code>
   *
   * @return The annotationsFilter.
   */
  @java.lang.Override
  public java.lang.String getAnnotationsFilter() {
    java.lang.Object ref = annotationsFilter_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      annotationsFilter_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Applicable only to Datasets that have DataItems and Annotations.
   * A filter on Annotations of the Dataset. Only Annotations that both
   * match this filter and belong to DataItems not ignored by the split method
   * are used in respectively training, validation or test role, depending on
   * the role of the DataItem they are on (for the auto-assigned that role is
   * decided by Vertex AI). A filter with same syntax as the one used in
   * [ListAnnotations][google.cloud.aiplatform.v1beta1.DatasetService.ListAnnotations] may be used, but note
   * here it filters across all Annotations of the Dataset, and not just within
   * a single DataItem.
   * </pre>
   *
   * <code>string annotations_filter = 6;</code>
   *
   * @return The bytes for annotationsFilter.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getAnnotationsFilterBytes() {
    java.lang.Object ref = annotationsFilter_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      annotationsFilter_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int ANNOTATION_SCHEMA_URI_FIELD_NUMBER = 9;
  private volatile java.lang.Object annotationSchemaUri_;
  /**
   *
   *
   * <pre>
   * Applicable only to custom training with Datasets that have DataItems and
   * Annotations.
   * Cloud Storage URI that points to a YAML file describing the annotation
   * schema. The schema is defined as an OpenAPI 3.0.2 [Schema
   * Object](https://github.com/OAI/OpenAPI-Specification/blob/main/versions/3.0.2.md#schemaObject).
   * The schema files that can be used here are found in
   * gs://google-cloud-aiplatform/schema/dataset/annotation/ , note that the
   * chosen schema must be consistent with
   * [metadata][google.cloud.aiplatform.v1beta1.Dataset.metadata_schema_uri] of the Dataset specified by
   * [dataset_id][google.cloud.aiplatform.v1beta1.InputDataConfig.dataset_id].
   * Only Annotations that both match this schema and belong to DataItems not
   * ignored by the split method are used in respectively training, validation
   * or test role, depending on the role of the DataItem they are on.
   * When used in conjunction with [annotations_filter][google.cloud.aiplatform.v1beta1.InputDataConfig.annotations_filter], the Annotations used
   * for training are filtered by both [annotations_filter][google.cloud.aiplatform.v1beta1.InputDataConfig.annotations_filter] and
   * [annotation_schema_uri][google.cloud.aiplatform.v1beta1.InputDataConfig.annotation_schema_uri].
   * </pre>
   *
   * <code>string annotation_schema_uri = 9;</code>
   *
   * @return The annotationSchemaUri.
   */
  @java.lang.Override
  public java.lang.String getAnnotationSchemaUri() {
    java.lang.Object ref = annotationSchemaUri_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      annotationSchemaUri_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Applicable only to custom training with Datasets that have DataItems and
   * Annotations.
   * Cloud Storage URI that points to a YAML file describing the annotation
   * schema. The schema is defined as an OpenAPI 3.0.2 [Schema
   * Object](https://github.com/OAI/OpenAPI-Specification/blob/main/versions/3.0.2.md#schemaObject).
   * The schema files that can be used here are found in
   * gs://google-cloud-aiplatform/schema/dataset/annotation/ , note that the
   * chosen schema must be consistent with
   * [metadata][google.cloud.aiplatform.v1beta1.Dataset.metadata_schema_uri] of the Dataset specified by
   * [dataset_id][google.cloud.aiplatform.v1beta1.InputDataConfig.dataset_id].
   * Only Annotations that both match this schema and belong to DataItems not
   * ignored by the split method are used in respectively training, validation
   * or test role, depending on the role of the DataItem they are on.
   * When used in conjunction with [annotations_filter][google.cloud.aiplatform.v1beta1.InputDataConfig.annotations_filter], the Annotations used
   * for training are filtered by both [annotations_filter][google.cloud.aiplatform.v1beta1.InputDataConfig.annotations_filter] and
   * [annotation_schema_uri][google.cloud.aiplatform.v1beta1.InputDataConfig.annotation_schema_uri].
   * </pre>
   *
   * <code>string annotation_schema_uri = 9;</code>
   *
   * @return The bytes for annotationSchemaUri.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getAnnotationSchemaUriBytes() {
    java.lang.Object ref = annotationSchemaUri_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      annotationSchemaUri_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    if (!getDatasetIdBytes().isEmpty()) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 1, datasetId_);
    }
    if (splitCase_ == 2) {
      output.writeMessage(2, (com.google.cloud.aiplatform.v1beta1.FractionSplit) split_);
    }
    if (splitCase_ == 3) {
      output.writeMessage(3, (com.google.cloud.aiplatform.v1beta1.FilterSplit) split_);
    }
    if (splitCase_ == 4) {
      output.writeMessage(4, (com.google.cloud.aiplatform.v1beta1.PredefinedSplit) split_);
    }
    if (splitCase_ == 5) {
      output.writeMessage(5, (com.google.cloud.aiplatform.v1beta1.TimestampSplit) split_);
    }
    if (!getAnnotationsFilterBytes().isEmpty()) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 6, annotationsFilter_);
    }
    if (destinationCase_ == 8) {
      output.writeMessage(8, (com.google.cloud.aiplatform.v1beta1.GcsDestination) destination_);
    }
    if (!getAnnotationSchemaUriBytes().isEmpty()) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 9, annotationSchemaUri_);
    }
    if (destinationCase_ == 10) {
      output.writeMessage(
          10, (com.google.cloud.aiplatform.v1beta1.BigQueryDestination) destination_);
    }
    unknownFields.writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    if (!getDatasetIdBytes().isEmpty()) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(1, datasetId_);
    }
    if (splitCase_ == 2) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(
              2, (com.google.cloud.aiplatform.v1beta1.FractionSplit) split_);
    }
    if (splitCase_ == 3) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(
              3, (com.google.cloud.aiplatform.v1beta1.FilterSplit) split_);
    }
    if (splitCase_ == 4) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(
              4, (com.google.cloud.aiplatform.v1beta1.PredefinedSplit) split_);
    }
    if (splitCase_ == 5) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(
              5, (com.google.cloud.aiplatform.v1beta1.TimestampSplit) split_);
    }
    if (!getAnnotationsFilterBytes().isEmpty()) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(6, annotationsFilter_);
    }
    if (destinationCase_ == 8) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(
              8, (com.google.cloud.aiplatform.v1beta1.GcsDestination) destination_);
    }
    if (!getAnnotationSchemaUriBytes().isEmpty()) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(9, annotationSchemaUri_);
    }
    if (destinationCase_ == 10) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(
              10, (com.google.cloud.aiplatform.v1beta1.BigQueryDestination) destination_);
    }
    size += unknownFields.getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.cloud.aiplatform.v1beta1.InputDataConfig)) {
      return super.equals(obj);
    }
    com.google.cloud.aiplatform.v1beta1.InputDataConfig other =
        (com.google.cloud.aiplatform.v1beta1.InputDataConfig) obj;

    if (!getDatasetId().equals(other.getDatasetId())) return false;
    if (!getAnnotationsFilter().equals(other.getAnnotationsFilter())) return false;
    if (!getAnnotationSchemaUri().equals(other.getAnnotationSchemaUri())) return false;
    if (!getSplitCase().equals(other.getSplitCase())) return false;
    switch (splitCase_) {
      case 2:
        if (!getFractionSplit().equals(other.getFractionSplit())) return false;
        break;
      case 3:
        if (!getFilterSplit().equals(other.getFilterSplit())) return false;
        break;
      case 4:
        if (!getPredefinedSplit().equals(other.getPredefinedSplit())) return false;
        break;
      case 5:
        if (!getTimestampSplit().equals(other.getTimestampSplit())) return false;
        break;
      case 0:
      default:
    }
    if (!getDestinationCase().equals(other.getDestinationCase())) return false;
    switch (destinationCase_) {
      case 8:
        if (!getGcsDestination().equals(other.getGcsDestination())) return false;
        break;
      case 10:
        if (!getBigqueryDestination().equals(other.getBigqueryDestination())) return false;
        break;
      case 0:
      default:
    }
    if (!unknownFields.equals(other.unknownFields)) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    hash = (37 * hash) + DATASET_ID_FIELD_NUMBER;
    hash = (53 * hash) + getDatasetId().hashCode();
    hash = (37 * hash) + ANNOTATIONS_FILTER_FIELD_NUMBER;
    hash = (53 * hash) + getAnnotationsFilter().hashCode();
    hash = (37 * hash) + ANNOTATION_SCHEMA_URI_FIELD_NUMBER;
    hash = (53 * hash) + getAnnotationSchemaUri().hashCode();
    switch (splitCase_) {
      case 2:
        hash = (37 * hash) + FRACTION_SPLIT_FIELD_NUMBER;
        hash = (53 * hash) + getFractionSplit().hashCode();
        break;
      case 3:
        hash = (37 * hash) + FILTER_SPLIT_FIELD_NUMBER;
        hash = (53 * hash) + getFilterSplit().hashCode();
        break;
      case 4:
        hash = (37 * hash) + PREDEFINED_SPLIT_FIELD_NUMBER;
        hash = (53 * hash) + getPredefinedSplit().hashCode();
        break;
      case 5:
        hash = (37 * hash) + TIMESTAMP_SPLIT_FIELD_NUMBER;
        hash = (53 * hash) + getTimestampSplit().hashCode();
        break;
      case 0:
      default:
    }
    switch (destinationCase_) {
      case 8:
        hash = (37 * hash) + GCS_DESTINATION_FIELD_NUMBER;
        hash = (53 * hash) + getGcsDestination().hashCode();
        break;
      case 10:
        hash = (37 * hash) + BIGQUERY_DESTINATION_FIELD_NUMBER;
        hash = (53 * hash) + getBigqueryDestination().hashCode();
        break;
      case 0:
      default:
    }
    hash = (29 * hash) + unknownFields.hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.cloud.aiplatform.v1beta1.InputDataConfig parseFrom(
      java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.aiplatform.v1beta1.InputDataConfig parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.aiplatform.v1beta1.InputDataConfig parseFrom(
      com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.aiplatform.v1beta1.InputDataConfig parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.aiplatform.v1beta1.InputDataConfig parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.aiplatform.v1beta1.InputDataConfig parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.aiplatform.v1beta1.InputDataConfig parseFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.aiplatform.v1beta1.InputDataConfig parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.aiplatform.v1beta1.InputDataConfig parseDelimitedFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.cloud.aiplatform.v1beta1.InputDataConfig parseDelimitedFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.aiplatform.v1beta1.InputDataConfig parseFrom(
      com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.aiplatform.v1beta1.InputDataConfig parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(com.google.cloud.aiplatform.v1beta1.InputDataConfig prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }
  /**
   *
   *
   * <pre>
   * Specifies Vertex AI owned input data to be used for training, and
   * possibly evaluating, the Model.
   * </pre>
   *
   * Protobuf type {@code google.cloud.aiplatform.v1beta1.InputDataConfig}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.cloud.aiplatform.v1beta1.InputDataConfig)
      com.google.cloud.aiplatform.v1beta1.InputDataConfigOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.aiplatform.v1beta1.TrainingPipelineProto
          .internal_static_google_cloud_aiplatform_v1beta1_InputDataConfig_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.aiplatform.v1beta1.TrainingPipelineProto
          .internal_static_google_cloud_aiplatform_v1beta1_InputDataConfig_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.aiplatform.v1beta1.InputDataConfig.class,
              com.google.cloud.aiplatform.v1beta1.InputDataConfig.Builder.class);
    }

    // Construct using com.google.cloud.aiplatform.v1beta1.InputDataConfig.newBuilder()
    private Builder() {
      maybeForceBuilderInitialization();
    }

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
      maybeForceBuilderInitialization();
    }

    private void maybeForceBuilderInitialization() {
      if (com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders) {}
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      datasetId_ = "";

      annotationsFilter_ = "";

      annotationSchemaUri_ = "";

      splitCase_ = 0;
      split_ = null;
      destinationCase_ = 0;
      destination_ = null;
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.cloud.aiplatform.v1beta1.TrainingPipelineProto
          .internal_static_google_cloud_aiplatform_v1beta1_InputDataConfig_descriptor;
    }

    @java.lang.Override
    public com.google.cloud.aiplatform.v1beta1.InputDataConfig getDefaultInstanceForType() {
      return com.google.cloud.aiplatform.v1beta1.InputDataConfig.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.cloud.aiplatform.v1beta1.InputDataConfig build() {
      com.google.cloud.aiplatform.v1beta1.InputDataConfig result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.cloud.aiplatform.v1beta1.InputDataConfig buildPartial() {
      com.google.cloud.aiplatform.v1beta1.InputDataConfig result =
          new com.google.cloud.aiplatform.v1beta1.InputDataConfig(this);
      if (splitCase_ == 2) {
        if (fractionSplitBuilder_ == null) {
          result.split_ = split_;
        } else {
          result.split_ = fractionSplitBuilder_.build();
        }
      }
      if (splitCase_ == 3) {
        if (filterSplitBuilder_ == null) {
          result.split_ = split_;
        } else {
          result.split_ = filterSplitBuilder_.build();
        }
      }
      if (splitCase_ == 4) {
        if (predefinedSplitBuilder_ == null) {
          result.split_ = split_;
        } else {
          result.split_ = predefinedSplitBuilder_.build();
        }
      }
      if (splitCase_ == 5) {
        if (timestampSplitBuilder_ == null) {
          result.split_ = split_;
        } else {
          result.split_ = timestampSplitBuilder_.build();
        }
      }
      if (destinationCase_ == 8) {
        if (gcsDestinationBuilder_ == null) {
          result.destination_ = destination_;
        } else {
          result.destination_ = gcsDestinationBuilder_.build();
        }
      }
      if (destinationCase_ == 10) {
        if (bigqueryDestinationBuilder_ == null) {
          result.destination_ = destination_;
        } else {
          result.destination_ = bigqueryDestinationBuilder_.build();
        }
      }
      result.datasetId_ = datasetId_;
      result.annotationsFilter_ = annotationsFilter_;
      result.annotationSchemaUri_ = annotationSchemaUri_;
      result.splitCase_ = splitCase_;
      result.destinationCase_ = destinationCase_;
      onBuilt();
      return result;
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.cloud.aiplatform.v1beta1.InputDataConfig) {
        return mergeFrom((com.google.cloud.aiplatform.v1beta1.InputDataConfig) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(com.google.cloud.aiplatform.v1beta1.InputDataConfig other) {
      if (other == com.google.cloud.aiplatform.v1beta1.InputDataConfig.getDefaultInstance())
        return this;
      if (!other.getDatasetId().isEmpty()) {
        datasetId_ = other.datasetId_;
        onChanged();
      }
      if (!other.getAnnotationsFilter().isEmpty()) {
        annotationsFilter_ = other.annotationsFilter_;
        onChanged();
      }
      if (!other.getAnnotationSchemaUri().isEmpty()) {
        annotationSchemaUri_ = other.annotationSchemaUri_;
        onChanged();
      }
      switch (other.getSplitCase()) {
        case FRACTION_SPLIT:
          {
            mergeFractionSplit(other.getFractionSplit());
            break;
          }
        case FILTER_SPLIT:
          {
            mergeFilterSplit(other.getFilterSplit());
            break;
          }
        case PREDEFINED_SPLIT:
          {
            mergePredefinedSplit(other.getPredefinedSplit());
            break;
          }
        case TIMESTAMP_SPLIT:
          {
            mergeTimestampSplit(other.getTimestampSplit());
            break;
          }
        case SPLIT_NOT_SET:
          {
            break;
          }
      }
      switch (other.getDestinationCase()) {
        case GCS_DESTINATION:
          {
            mergeGcsDestination(other.getGcsDestination());
            break;
          }
        case BIGQUERY_DESTINATION:
          {
            mergeBigqueryDestination(other.getBigqueryDestination());
            break;
          }
        case DESTINATION_NOT_SET:
          {
            break;
          }
      }
      this.mergeUnknownFields(other.unknownFields);
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      com.google.cloud.aiplatform.v1beta1.InputDataConfig parsedMessage = null;
      try {
        parsedMessage = PARSER.parsePartialFrom(input, extensionRegistry);
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        parsedMessage =
            (com.google.cloud.aiplatform.v1beta1.InputDataConfig) e.getUnfinishedMessage();
        throw e.unwrapIOException();
      } finally {
        if (parsedMessage != null) {
          mergeFrom(parsedMessage);
        }
      }
      return this;
    }

    private int splitCase_ = 0;
    private java.lang.Object split_;

    public SplitCase getSplitCase() {
      return SplitCase.forNumber(splitCase_);
    }

    public Builder clearSplit() {
      splitCase_ = 0;
      split_ = null;
      onChanged();
      return this;
    }

    private int destinationCase_ = 0;
    private java.lang.Object destination_;

    public DestinationCase getDestinationCase() {
      return DestinationCase.forNumber(destinationCase_);
    }

    public Builder clearDestination() {
      destinationCase_ = 0;
      destination_ = null;
      onChanged();
      return this;
    }

    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.aiplatform.v1beta1.FractionSplit,
            com.google.cloud.aiplatform.v1beta1.FractionSplit.Builder,
            com.google.cloud.aiplatform.v1beta1.FractionSplitOrBuilder>
        fractionSplitBuilder_;
    /**
     *
     *
     * <pre>
     * Split based on fractions defining the size of each set.
     * </pre>
     *
     * <code>.google.cloud.aiplatform.v1beta1.FractionSplit fraction_split = 2;</code>
     *
     * @return Whether the fractionSplit field is set.
     */
    @java.lang.Override
    public boolean hasFractionSplit() {
      return splitCase_ == 2;
    }
    /**
     *
     *
     * <pre>
     * Split based on fractions defining the size of each set.
     * </pre>
     *
     * <code>.google.cloud.aiplatform.v1beta1.FractionSplit fraction_split = 2;</code>
     *
     * @return The fractionSplit.
     */
    @java.lang.Override
    public com.google.cloud.aiplatform.v1beta1.FractionSplit getFractionSplit() {
      if (fractionSplitBuilder_ == null) {
        if (splitCase_ == 2) {
          return (com.google.cloud.aiplatform.v1beta1.FractionSplit) split_;
        }
        return com.google.cloud.aiplatform.v1beta1.FractionSplit.getDefaultInstance();
      } else {
        if (splitCase_ == 2) {
          return fractionSplitBuilder_.getMessage();
        }
        return com.google.cloud.aiplatform.v1beta1.FractionSplit.getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * Split based on fractions defining the size of each set.
     * </pre>
     *
     * <code>.google.cloud.aiplatform.v1beta1.FractionSplit fraction_split = 2;</code>
     */
    public Builder setFractionSplit(com.google.cloud.aiplatform.v1beta1.FractionSplit value) {
      if (fractionSplitBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        split_ = value;
        onChanged();
      } else {
        fractionSplitBuilder_.setMessage(value);
      }
      splitCase_ = 2;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Split based on fractions defining the size of each set.
     * </pre>
     *
     * <code>.google.cloud.aiplatform.v1beta1.FractionSplit fraction_split = 2;</code>
     */
    public Builder setFractionSplit(
        com.google.cloud.aiplatform.v1beta1.FractionSplit.Builder builderForValue) {
      if (fractionSplitBuilder_ == null) {
        split_ = builderForValue.build();
        onChanged();
      } else {
        fractionSplitBuilder_.setMessage(builderForValue.build());
      }
      splitCase_ = 2;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Split based on fractions defining the size of each set.
     * </pre>
     *
     * <code>.google.cloud.aiplatform.v1beta1.FractionSplit fraction_split = 2;</code>
     */
    public Builder mergeFractionSplit(com.google.cloud.aiplatform.v1beta1.FractionSplit value) {
      if (fractionSplitBuilder_ == null) {
        if (splitCase_ == 2
            && split_ != com.google.cloud.aiplatform.v1beta1.FractionSplit.getDefaultInstance()) {
          split_ =
              com.google.cloud.aiplatform.v1beta1.FractionSplit.newBuilder(
                      (com.google.cloud.aiplatform.v1beta1.FractionSplit) split_)
                  .mergeFrom(value)
                  .buildPartial();
        } else {
          split_ = value;
        }
        onChanged();
      } else {
        if (splitCase_ == 2) {
          fractionSplitBuilder_.mergeFrom(value);
        }
        fractionSplitBuilder_.setMessage(value);
      }
      splitCase_ = 2;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Split based on fractions defining the size of each set.
     * </pre>
     *
     * <code>.google.cloud.aiplatform.v1beta1.FractionSplit fraction_split = 2;</code>
     */
    public Builder clearFractionSplit() {
      if (fractionSplitBuilder_ == null) {
        if (splitCase_ == 2) {
          splitCase_ = 0;
          split_ = null;
          onChanged();
        }
      } else {
        if (splitCase_ == 2) {
          splitCase_ = 0;
          split_ = null;
        }
        fractionSplitBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Split based on fractions defining the size of each set.
     * </pre>
     *
     * <code>.google.cloud.aiplatform.v1beta1.FractionSplit fraction_split = 2;</code>
     */
    public com.google.cloud.aiplatform.v1beta1.FractionSplit.Builder getFractionSplitBuilder() {
      return getFractionSplitFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Split based on fractions defining the size of each set.
     * </pre>
     *
     * <code>.google.cloud.aiplatform.v1beta1.FractionSplit fraction_split = 2;</code>
     */
    @java.lang.Override
    public com.google.cloud.aiplatform.v1beta1.FractionSplitOrBuilder getFractionSplitOrBuilder() {
      if ((splitCase_ == 2) && (fractionSplitBuilder_ != null)) {
        return fractionSplitBuilder_.getMessageOrBuilder();
      } else {
        if (splitCase_ == 2) {
          return (com.google.cloud.aiplatform.v1beta1.FractionSplit) split_;
        }
        return com.google.cloud.aiplatform.v1beta1.FractionSplit.getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * Split based on fractions defining the size of each set.
     * </pre>
     *
     * <code>.google.cloud.aiplatform.v1beta1.FractionSplit fraction_split = 2;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.aiplatform.v1beta1.FractionSplit,
            com.google.cloud.aiplatform.v1beta1.FractionSplit.Builder,
            com.google.cloud.aiplatform.v1beta1.FractionSplitOrBuilder>
        getFractionSplitFieldBuilder() {
      if (fractionSplitBuilder_ == null) {
        if (!(splitCase_ == 2)) {
          split_ = com.google.cloud.aiplatform.v1beta1.FractionSplit.getDefaultInstance();
        }
        fractionSplitBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.aiplatform.v1beta1.FractionSplit,
                com.google.cloud.aiplatform.v1beta1.FractionSplit.Builder,
                com.google.cloud.aiplatform.v1beta1.FractionSplitOrBuilder>(
                (com.google.cloud.aiplatform.v1beta1.FractionSplit) split_,
                getParentForChildren(),
                isClean());
        split_ = null;
      }
      splitCase_ = 2;
      onChanged();
      ;
      return fractionSplitBuilder_;
    }

    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.aiplatform.v1beta1.FilterSplit,
            com.google.cloud.aiplatform.v1beta1.FilterSplit.Builder,
            com.google.cloud.aiplatform.v1beta1.FilterSplitOrBuilder>
        filterSplitBuilder_;
    /**
     *
     *
     * <pre>
     * Split based on the provided filters for each set.
     * </pre>
     *
     * <code>.google.cloud.aiplatform.v1beta1.FilterSplit filter_split = 3;</code>
     *
     * @return Whether the filterSplit field is set.
     */
    @java.lang.Override
    public boolean hasFilterSplit() {
      return splitCase_ == 3;
    }
    /**
     *
     *
     * <pre>
     * Split based on the provided filters for each set.
     * </pre>
     *
     * <code>.google.cloud.aiplatform.v1beta1.FilterSplit filter_split = 3;</code>
     *
     * @return The filterSplit.
     */
    @java.lang.Override
    public com.google.cloud.aiplatform.v1beta1.FilterSplit getFilterSplit() {
      if (filterSplitBuilder_ == null) {
        if (splitCase_ == 3) {
          return (com.google.cloud.aiplatform.v1beta1.FilterSplit) split_;
        }
        return com.google.cloud.aiplatform.v1beta1.FilterSplit.getDefaultInstance();
      } else {
        if (splitCase_ == 3) {
          return filterSplitBuilder_.getMessage();
        }
        return com.google.cloud.aiplatform.v1beta1.FilterSplit.getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * Split based on the provided filters for each set.
     * </pre>
     *
     * <code>.google.cloud.aiplatform.v1beta1.FilterSplit filter_split = 3;</code>
     */
    public Builder setFilterSplit(com.google.cloud.aiplatform.v1beta1.FilterSplit value) {
      if (filterSplitBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        split_ = value;
        onChanged();
      } else {
        filterSplitBuilder_.setMessage(value);
      }
      splitCase_ = 3;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Split based on the provided filters for each set.
     * </pre>
     *
     * <code>.google.cloud.aiplatform.v1beta1.FilterSplit filter_split = 3;</code>
     */
    public Builder setFilterSplit(
        com.google.cloud.aiplatform.v1beta1.FilterSplit.Builder builderForValue) {
      if (filterSplitBuilder_ == null) {
        split_ = builderForValue.build();
        onChanged();
      } else {
        filterSplitBuilder_.setMessage(builderForValue.build());
      }
      splitCase_ = 3;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Split based on the provided filters for each set.
     * </pre>
     *
     * <code>.google.cloud.aiplatform.v1beta1.FilterSplit filter_split = 3;</code>
     */
    public Builder mergeFilterSplit(com.google.cloud.aiplatform.v1beta1.FilterSplit value) {
      if (filterSplitBuilder_ == null) {
        if (splitCase_ == 3
            && split_ != com.google.cloud.aiplatform.v1beta1.FilterSplit.getDefaultInstance()) {
          split_ =
              com.google.cloud.aiplatform.v1beta1.FilterSplit.newBuilder(
                      (com.google.cloud.aiplatform.v1beta1.FilterSplit) split_)
                  .mergeFrom(value)
                  .buildPartial();
        } else {
          split_ = value;
        }
        onChanged();
      } else {
        if (splitCase_ == 3) {
          filterSplitBuilder_.mergeFrom(value);
        }
        filterSplitBuilder_.setMessage(value);
      }
      splitCase_ = 3;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Split based on the provided filters for each set.
     * </pre>
     *
     * <code>.google.cloud.aiplatform.v1beta1.FilterSplit filter_split = 3;</code>
     */
    public Builder clearFilterSplit() {
      if (filterSplitBuilder_ == null) {
        if (splitCase_ == 3) {
          splitCase_ = 0;
          split_ = null;
          onChanged();
        }
      } else {
        if (splitCase_ == 3) {
          splitCase_ = 0;
          split_ = null;
        }
        filterSplitBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Split based on the provided filters for each set.
     * </pre>
     *
     * <code>.google.cloud.aiplatform.v1beta1.FilterSplit filter_split = 3;</code>
     */
    public com.google.cloud.aiplatform.v1beta1.FilterSplit.Builder getFilterSplitBuilder() {
      return getFilterSplitFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Split based on the provided filters for each set.
     * </pre>
     *
     * <code>.google.cloud.aiplatform.v1beta1.FilterSplit filter_split = 3;</code>
     */
    @java.lang.Override
    public com.google.cloud.aiplatform.v1beta1.FilterSplitOrBuilder getFilterSplitOrBuilder() {
      if ((splitCase_ == 3) && (filterSplitBuilder_ != null)) {
        return filterSplitBuilder_.getMessageOrBuilder();
      } else {
        if (splitCase_ == 3) {
          return (com.google.cloud.aiplatform.v1beta1.FilterSplit) split_;
        }
        return com.google.cloud.aiplatform.v1beta1.FilterSplit.getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * Split based on the provided filters for each set.
     * </pre>
     *
     * <code>.google.cloud.aiplatform.v1beta1.FilterSplit filter_split = 3;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.aiplatform.v1beta1.FilterSplit,
            com.google.cloud.aiplatform.v1beta1.FilterSplit.Builder,
            com.google.cloud.aiplatform.v1beta1.FilterSplitOrBuilder>
        getFilterSplitFieldBuilder() {
      if (filterSplitBuilder_ == null) {
        if (!(splitCase_ == 3)) {
          split_ = com.google.cloud.aiplatform.v1beta1.FilterSplit.getDefaultInstance();
        }
        filterSplitBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.aiplatform.v1beta1.FilterSplit,
                com.google.cloud.aiplatform.v1beta1.FilterSplit.Builder,
                com.google.cloud.aiplatform.v1beta1.FilterSplitOrBuilder>(
                (com.google.cloud.aiplatform.v1beta1.FilterSplit) split_,
                getParentForChildren(),
                isClean());
        split_ = null;
      }
      splitCase_ = 3;
      onChanged();
      ;
      return filterSplitBuilder_;
    }

    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.aiplatform.v1beta1.PredefinedSplit,
            com.google.cloud.aiplatform.v1beta1.PredefinedSplit.Builder,
            com.google.cloud.aiplatform.v1beta1.PredefinedSplitOrBuilder>
        predefinedSplitBuilder_;
    /**
     *
     *
     * <pre>
     * Supported only for tabular Datasets.
     * Split based on a predefined key.
     * </pre>
     *
     * <code>.google.cloud.aiplatform.v1beta1.PredefinedSplit predefined_split = 4;</code>
     *
     * @return Whether the predefinedSplit field is set.
     */
    @java.lang.Override
    public boolean hasPredefinedSplit() {
      return splitCase_ == 4;
    }
    /**
     *
     *
     * <pre>
     * Supported only for tabular Datasets.
     * Split based on a predefined key.
     * </pre>
     *
     * <code>.google.cloud.aiplatform.v1beta1.PredefinedSplit predefined_split = 4;</code>
     *
     * @return The predefinedSplit.
     */
    @java.lang.Override
    public com.google.cloud.aiplatform.v1beta1.PredefinedSplit getPredefinedSplit() {
      if (predefinedSplitBuilder_ == null) {
        if (splitCase_ == 4) {
          return (com.google.cloud.aiplatform.v1beta1.PredefinedSplit) split_;
        }
        return com.google.cloud.aiplatform.v1beta1.PredefinedSplit.getDefaultInstance();
      } else {
        if (splitCase_ == 4) {
          return predefinedSplitBuilder_.getMessage();
        }
        return com.google.cloud.aiplatform.v1beta1.PredefinedSplit.getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * Supported only for tabular Datasets.
     * Split based on a predefined key.
     * </pre>
     *
     * <code>.google.cloud.aiplatform.v1beta1.PredefinedSplit predefined_split = 4;</code>
     */
    public Builder setPredefinedSplit(com.google.cloud.aiplatform.v1beta1.PredefinedSplit value) {
      if (predefinedSplitBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        split_ = value;
        onChanged();
      } else {
        predefinedSplitBuilder_.setMessage(value);
      }
      splitCase_ = 4;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Supported only for tabular Datasets.
     * Split based on a predefined key.
     * </pre>
     *
     * <code>.google.cloud.aiplatform.v1beta1.PredefinedSplit predefined_split = 4;</code>
     */
    public Builder setPredefinedSplit(
        com.google.cloud.aiplatform.v1beta1.PredefinedSplit.Builder builderForValue) {
      if (predefinedSplitBuilder_ == null) {
        split_ = builderForValue.build();
        onChanged();
      } else {
        predefinedSplitBuilder_.setMessage(builderForValue.build());
      }
      splitCase_ = 4;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Supported only for tabular Datasets.
     * Split based on a predefined key.
     * </pre>
     *
     * <code>.google.cloud.aiplatform.v1beta1.PredefinedSplit predefined_split = 4;</code>
     */
    public Builder mergePredefinedSplit(com.google.cloud.aiplatform.v1beta1.PredefinedSplit value) {
      if (predefinedSplitBuilder_ == null) {
        if (splitCase_ == 4
            && split_ != com.google.cloud.aiplatform.v1beta1.PredefinedSplit.getDefaultInstance()) {
          split_ =
              com.google.cloud.aiplatform.v1beta1.PredefinedSplit.newBuilder(
                      (com.google.cloud.aiplatform.v1beta1.PredefinedSplit) split_)
                  .mergeFrom(value)
                  .buildPartial();
        } else {
          split_ = value;
        }
        onChanged();
      } else {
        if (splitCase_ == 4) {
          predefinedSplitBuilder_.mergeFrom(value);
        }
        predefinedSplitBuilder_.setMessage(value);
      }
      splitCase_ = 4;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Supported only for tabular Datasets.
     * Split based on a predefined key.
     * </pre>
     *
     * <code>.google.cloud.aiplatform.v1beta1.PredefinedSplit predefined_split = 4;</code>
     */
    public Builder clearPredefinedSplit() {
      if (predefinedSplitBuilder_ == null) {
        if (splitCase_ == 4) {
          splitCase_ = 0;
          split_ = null;
          onChanged();
        }
      } else {
        if (splitCase_ == 4) {
          splitCase_ = 0;
          split_ = null;
        }
        predefinedSplitBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Supported only for tabular Datasets.
     * Split based on a predefined key.
     * </pre>
     *
     * <code>.google.cloud.aiplatform.v1beta1.PredefinedSplit predefined_split = 4;</code>
     */
    public com.google.cloud.aiplatform.v1beta1.PredefinedSplit.Builder getPredefinedSplitBuilder() {
      return getPredefinedSplitFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Supported only for tabular Datasets.
     * Split based on a predefined key.
     * </pre>
     *
     * <code>.google.cloud.aiplatform.v1beta1.PredefinedSplit predefined_split = 4;</code>
     */
    @java.lang.Override
    public com.google.cloud.aiplatform.v1beta1.PredefinedSplitOrBuilder
        getPredefinedSplitOrBuilder() {
      if ((splitCase_ == 4) && (predefinedSplitBuilder_ != null)) {
        return predefinedSplitBuilder_.getMessageOrBuilder();
      } else {
        if (splitCase_ == 4) {
          return (com.google.cloud.aiplatform.v1beta1.PredefinedSplit) split_;
        }
        return com.google.cloud.aiplatform.v1beta1.PredefinedSplit.getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * Supported only for tabular Datasets.
     * Split based on a predefined key.
     * </pre>
     *
     * <code>.google.cloud.aiplatform.v1beta1.PredefinedSplit predefined_split = 4;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.aiplatform.v1beta1.PredefinedSplit,
            com.google.cloud.aiplatform.v1beta1.PredefinedSplit.Builder,
            com.google.cloud.aiplatform.v1beta1.PredefinedSplitOrBuilder>
        getPredefinedSplitFieldBuilder() {
      if (predefinedSplitBuilder_ == null) {
        if (!(splitCase_ == 4)) {
          split_ = com.google.cloud.aiplatform.v1beta1.PredefinedSplit.getDefaultInstance();
        }
        predefinedSplitBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.aiplatform.v1beta1.PredefinedSplit,
                com.google.cloud.aiplatform.v1beta1.PredefinedSplit.Builder,
                com.google.cloud.aiplatform.v1beta1.PredefinedSplitOrBuilder>(
                (com.google.cloud.aiplatform.v1beta1.PredefinedSplit) split_,
                getParentForChildren(),
                isClean());
        split_ = null;
      }
      splitCase_ = 4;
      onChanged();
      ;
      return predefinedSplitBuilder_;
    }

    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.aiplatform.v1beta1.TimestampSplit,
            com.google.cloud.aiplatform.v1beta1.TimestampSplit.Builder,
            com.google.cloud.aiplatform.v1beta1.TimestampSplitOrBuilder>
        timestampSplitBuilder_;
    /**
     *
     *
     * <pre>
     * Supported only for tabular Datasets.
     * Split based on the timestamp of the input data pieces.
     * </pre>
     *
     * <code>.google.cloud.aiplatform.v1beta1.TimestampSplit timestamp_split = 5;</code>
     *
     * @return Whether the timestampSplit field is set.
     */
    @java.lang.Override
    public boolean hasTimestampSplit() {
      return splitCase_ == 5;
    }
    /**
     *
     *
     * <pre>
     * Supported only for tabular Datasets.
     * Split based on the timestamp of the input data pieces.
     * </pre>
     *
     * <code>.google.cloud.aiplatform.v1beta1.TimestampSplit timestamp_split = 5;</code>
     *
     * @return The timestampSplit.
     */
    @java.lang.Override
    public com.google.cloud.aiplatform.v1beta1.TimestampSplit getTimestampSplit() {
      if (timestampSplitBuilder_ == null) {
        if (splitCase_ == 5) {
          return (com.google.cloud.aiplatform.v1beta1.TimestampSplit) split_;
        }
        return com.google.cloud.aiplatform.v1beta1.TimestampSplit.getDefaultInstance();
      } else {
        if (splitCase_ == 5) {
          return timestampSplitBuilder_.getMessage();
        }
        return com.google.cloud.aiplatform.v1beta1.TimestampSplit.getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * Supported only for tabular Datasets.
     * Split based on the timestamp of the input data pieces.
     * </pre>
     *
     * <code>.google.cloud.aiplatform.v1beta1.TimestampSplit timestamp_split = 5;</code>
     */
    public Builder setTimestampSplit(com.google.cloud.aiplatform.v1beta1.TimestampSplit value) {
      if (timestampSplitBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        split_ = value;
        onChanged();
      } else {
        timestampSplitBuilder_.setMessage(value);
      }
      splitCase_ = 5;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Supported only for tabular Datasets.
     * Split based on the timestamp of the input data pieces.
     * </pre>
     *
     * <code>.google.cloud.aiplatform.v1beta1.TimestampSplit timestamp_split = 5;</code>
     */
    public Builder setTimestampSplit(
        com.google.cloud.aiplatform.v1beta1.TimestampSplit.Builder builderForValue) {
      if (timestampSplitBuilder_ == null) {
        split_ = builderForValue.build();
        onChanged();
      } else {
        timestampSplitBuilder_.setMessage(builderForValue.build());
      }
      splitCase_ = 5;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Supported only for tabular Datasets.
     * Split based on the timestamp of the input data pieces.
     * </pre>
     *
     * <code>.google.cloud.aiplatform.v1beta1.TimestampSplit timestamp_split = 5;</code>
     */
    public Builder mergeTimestampSplit(com.google.cloud.aiplatform.v1beta1.TimestampSplit value) {
      if (timestampSplitBuilder_ == null) {
        if (splitCase_ == 5
            && split_ != com.google.cloud.aiplatform.v1beta1.TimestampSplit.getDefaultInstance()) {
          split_ =
              com.google.cloud.aiplatform.v1beta1.TimestampSplit.newBuilder(
                      (com.google.cloud.aiplatform.v1beta1.TimestampSplit) split_)
                  .mergeFrom(value)
                  .buildPartial();
        } else {
          split_ = value;
        }
        onChanged();
      } else {
        if (splitCase_ == 5) {
          timestampSplitBuilder_.mergeFrom(value);
        }
        timestampSplitBuilder_.setMessage(value);
      }
      splitCase_ = 5;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Supported only for tabular Datasets.
     * Split based on the timestamp of the input data pieces.
     * </pre>
     *
     * <code>.google.cloud.aiplatform.v1beta1.TimestampSplit timestamp_split = 5;</code>
     */
    public Builder clearTimestampSplit() {
      if (timestampSplitBuilder_ == null) {
        if (splitCase_ == 5) {
          splitCase_ = 0;
          split_ = null;
          onChanged();
        }
      } else {
        if (splitCase_ == 5) {
          splitCase_ = 0;
          split_ = null;
        }
        timestampSplitBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Supported only for tabular Datasets.
     * Split based on the timestamp of the input data pieces.
     * </pre>
     *
     * <code>.google.cloud.aiplatform.v1beta1.TimestampSplit timestamp_split = 5;</code>
     */
    public com.google.cloud.aiplatform.v1beta1.TimestampSplit.Builder getTimestampSplitBuilder() {
      return getTimestampSplitFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Supported only for tabular Datasets.
     * Split based on the timestamp of the input data pieces.
     * </pre>
     *
     * <code>.google.cloud.aiplatform.v1beta1.TimestampSplit timestamp_split = 5;</code>
     */
    @java.lang.Override
    public com.google.cloud.aiplatform.v1beta1.TimestampSplitOrBuilder
        getTimestampSplitOrBuilder() {
      if ((splitCase_ == 5) && (timestampSplitBuilder_ != null)) {
        return timestampSplitBuilder_.getMessageOrBuilder();
      } else {
        if (splitCase_ == 5) {
          return (com.google.cloud.aiplatform.v1beta1.TimestampSplit) split_;
        }
        return com.google.cloud.aiplatform.v1beta1.TimestampSplit.getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * Supported only for tabular Datasets.
     * Split based on the timestamp of the input data pieces.
     * </pre>
     *
     * <code>.google.cloud.aiplatform.v1beta1.TimestampSplit timestamp_split = 5;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.aiplatform.v1beta1.TimestampSplit,
            com.google.cloud.aiplatform.v1beta1.TimestampSplit.Builder,
            com.google.cloud.aiplatform.v1beta1.TimestampSplitOrBuilder>
        getTimestampSplitFieldBuilder() {
      if (timestampSplitBuilder_ == null) {
        if (!(splitCase_ == 5)) {
          split_ = com.google.cloud.aiplatform.v1beta1.TimestampSplit.getDefaultInstance();
        }
        timestampSplitBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.aiplatform.v1beta1.TimestampSplit,
                com.google.cloud.aiplatform.v1beta1.TimestampSplit.Builder,
                com.google.cloud.aiplatform.v1beta1.TimestampSplitOrBuilder>(
                (com.google.cloud.aiplatform.v1beta1.TimestampSplit) split_,
                getParentForChildren(),
                isClean());
        split_ = null;
      }
      splitCase_ = 5;
      onChanged();
      ;
      return timestampSplitBuilder_;
    }

    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.aiplatform.v1beta1.GcsDestination,
            com.google.cloud.aiplatform.v1beta1.GcsDestination.Builder,
            com.google.cloud.aiplatform.v1beta1.GcsDestinationOrBuilder>
        gcsDestinationBuilder_;
    /**
     *
     *
     * <pre>
     * The Cloud Storage location where the training data is to be
     * written to. In the given directory a new directory is created with
     * name:
     * `dataset-&lt;dataset-id&gt;-&lt;annotation-type&gt;-&lt;timestamp-of-training-call&gt;`
     * where timestamp is in YYYY-MM-DDThh:mm:ss.sssZ ISO-8601 format.
     * All training input data is written into that directory.
     * The Vertex AI environment variables representing Cloud Storage
     * data URIs are represented in the Cloud Storage wildcard
     * format to support sharded data. e.g.: "gs://.../training-*.jsonl"
     * * AIP_DATA_FORMAT = "jsonl" for non-tabular data, "csv" for tabular data
     * * AIP_TRAINING_DATA_URI =
     * "gcs_destination/dataset-&lt;dataset-id&gt;-&lt;annotation-type&gt;-&lt;time&gt;/training-*.${AIP_DATA_FORMAT}"
     * * AIP_VALIDATION_DATA_URI =
     * "gcs_destination/dataset-&lt;dataset-id&gt;-&lt;annotation-type&gt;-&lt;time&gt;/validation-*.${AIP_DATA_FORMAT}"
     * * AIP_TEST_DATA_URI =
     * "gcs_destination/dataset-&lt;dataset-id&gt;-&lt;annotation-type&gt;-&lt;time&gt;/test-*.${AIP_DATA_FORMAT}"
     * </pre>
     *
     * <code>.google.cloud.aiplatform.v1beta1.GcsDestination gcs_destination = 8;</code>
     *
     * @return Whether the gcsDestination field is set.
     */
    @java.lang.Override
    public boolean hasGcsDestination() {
      return destinationCase_ == 8;
    }
    /**
     *
     *
     * <pre>
     * The Cloud Storage location where the training data is to be
     * written to. In the given directory a new directory is created with
     * name:
     * `dataset-&lt;dataset-id&gt;-&lt;annotation-type&gt;-&lt;timestamp-of-training-call&gt;`
     * where timestamp is in YYYY-MM-DDThh:mm:ss.sssZ ISO-8601 format.
     * All training input data is written into that directory.
     * The Vertex AI environment variables representing Cloud Storage
     * data URIs are represented in the Cloud Storage wildcard
     * format to support sharded data. e.g.: "gs://.../training-*.jsonl"
     * * AIP_DATA_FORMAT = "jsonl" for non-tabular data, "csv" for tabular data
     * * AIP_TRAINING_DATA_URI =
     * "gcs_destination/dataset-&lt;dataset-id&gt;-&lt;annotation-type&gt;-&lt;time&gt;/training-*.${AIP_DATA_FORMAT}"
     * * AIP_VALIDATION_DATA_URI =
     * "gcs_destination/dataset-&lt;dataset-id&gt;-&lt;annotation-type&gt;-&lt;time&gt;/validation-*.${AIP_DATA_FORMAT}"
     * * AIP_TEST_DATA_URI =
     * "gcs_destination/dataset-&lt;dataset-id&gt;-&lt;annotation-type&gt;-&lt;time&gt;/test-*.${AIP_DATA_FORMAT}"
     * </pre>
     *
     * <code>.google.cloud.aiplatform.v1beta1.GcsDestination gcs_destination = 8;</code>
     *
     * @return The gcsDestination.
     */
    @java.lang.Override
    public com.google.cloud.aiplatform.v1beta1.GcsDestination getGcsDestination() {
      if (gcsDestinationBuilder_ == null) {
        if (destinationCase_ == 8) {
          return (com.google.cloud.aiplatform.v1beta1.GcsDestination) destination_;
        }
        return com.google.cloud.aiplatform.v1beta1.GcsDestination.getDefaultInstance();
      } else {
        if (destinationCase_ == 8) {
          return gcsDestinationBuilder_.getMessage();
        }
        return com.google.cloud.aiplatform.v1beta1.GcsDestination.getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * The Cloud Storage location where the training data is to be
     * written to. In the given directory a new directory is created with
     * name:
     * `dataset-&lt;dataset-id&gt;-&lt;annotation-type&gt;-&lt;timestamp-of-training-call&gt;`
     * where timestamp is in YYYY-MM-DDThh:mm:ss.sssZ ISO-8601 format.
     * All training input data is written into that directory.
     * The Vertex AI environment variables representing Cloud Storage
     * data URIs are represented in the Cloud Storage wildcard
     * format to support sharded data. e.g.: "gs://.../training-*.jsonl"
     * * AIP_DATA_FORMAT = "jsonl" for non-tabular data, "csv" for tabular data
     * * AIP_TRAINING_DATA_URI =
     * "gcs_destination/dataset-&lt;dataset-id&gt;-&lt;annotation-type&gt;-&lt;time&gt;/training-*.${AIP_DATA_FORMAT}"
     * * AIP_VALIDATION_DATA_URI =
     * "gcs_destination/dataset-&lt;dataset-id&gt;-&lt;annotation-type&gt;-&lt;time&gt;/validation-*.${AIP_DATA_FORMAT}"
     * * AIP_TEST_DATA_URI =
     * "gcs_destination/dataset-&lt;dataset-id&gt;-&lt;annotation-type&gt;-&lt;time&gt;/test-*.${AIP_DATA_FORMAT}"
     * </pre>
     *
     * <code>.google.cloud.aiplatform.v1beta1.GcsDestination gcs_destination = 8;</code>
     */
    public Builder setGcsDestination(com.google.cloud.aiplatform.v1beta1.GcsDestination value) {
      if (gcsDestinationBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        destination_ = value;
        onChanged();
      } else {
        gcsDestinationBuilder_.setMessage(value);
      }
      destinationCase_ = 8;
      return this;
    }
    /**
     *
     *
     * <pre>
     * The Cloud Storage location where the training data is to be
     * written to. In the given directory a new directory is created with
     * name:
     * `dataset-&lt;dataset-id&gt;-&lt;annotation-type&gt;-&lt;timestamp-of-training-call&gt;`
     * where timestamp is in YYYY-MM-DDThh:mm:ss.sssZ ISO-8601 format.
     * All training input data is written into that directory.
     * The Vertex AI environment variables representing Cloud Storage
     * data URIs are represented in the Cloud Storage wildcard
     * format to support sharded data. e.g.: "gs://.../training-*.jsonl"
     * * AIP_DATA_FORMAT = "jsonl" for non-tabular data, "csv" for tabular data
     * * AIP_TRAINING_DATA_URI =
     * "gcs_destination/dataset-&lt;dataset-id&gt;-&lt;annotation-type&gt;-&lt;time&gt;/training-*.${AIP_DATA_FORMAT}"
     * * AIP_VALIDATION_DATA_URI =
     * "gcs_destination/dataset-&lt;dataset-id&gt;-&lt;annotation-type&gt;-&lt;time&gt;/validation-*.${AIP_DATA_FORMAT}"
     * * AIP_TEST_DATA_URI =
     * "gcs_destination/dataset-&lt;dataset-id&gt;-&lt;annotation-type&gt;-&lt;time&gt;/test-*.${AIP_DATA_FORMAT}"
     * </pre>
     *
     * <code>.google.cloud.aiplatform.v1beta1.GcsDestination gcs_destination = 8;</code>
     */
    public Builder setGcsDestination(
        com.google.cloud.aiplatform.v1beta1.GcsDestination.Builder builderForValue) {
      if (gcsDestinationBuilder_ == null) {
        destination_ = builderForValue.build();
        onChanged();
      } else {
        gcsDestinationBuilder_.setMessage(builderForValue.build());
      }
      destinationCase_ = 8;
      return this;
    }
    /**
     *
     *
     * <pre>
     * The Cloud Storage location where the training data is to be
     * written to. In the given directory a new directory is created with
     * name:
     * `dataset-&lt;dataset-id&gt;-&lt;annotation-type&gt;-&lt;timestamp-of-training-call&gt;`
     * where timestamp is in YYYY-MM-DDThh:mm:ss.sssZ ISO-8601 format.
     * All training input data is written into that directory.
     * The Vertex AI environment variables representing Cloud Storage
     * data URIs are represented in the Cloud Storage wildcard
     * format to support sharded data. e.g.: "gs://.../training-*.jsonl"
     * * AIP_DATA_FORMAT = "jsonl" for non-tabular data, "csv" for tabular data
     * * AIP_TRAINING_DATA_URI =
     * "gcs_destination/dataset-&lt;dataset-id&gt;-&lt;annotation-type&gt;-&lt;time&gt;/training-*.${AIP_DATA_FORMAT}"
     * * AIP_VALIDATION_DATA_URI =
     * "gcs_destination/dataset-&lt;dataset-id&gt;-&lt;annotation-type&gt;-&lt;time&gt;/validation-*.${AIP_DATA_FORMAT}"
     * * AIP_TEST_DATA_URI =
     * "gcs_destination/dataset-&lt;dataset-id&gt;-&lt;annotation-type&gt;-&lt;time&gt;/test-*.${AIP_DATA_FORMAT}"
     * </pre>
     *
     * <code>.google.cloud.aiplatform.v1beta1.GcsDestination gcs_destination = 8;</code>
     */
    public Builder mergeGcsDestination(com.google.cloud.aiplatform.v1beta1.GcsDestination value) {
      if (gcsDestinationBuilder_ == null) {
        if (destinationCase_ == 8
            && destination_
                != com.google.cloud.aiplatform.v1beta1.GcsDestination.getDefaultInstance()) {
          destination_ =
              com.google.cloud.aiplatform.v1beta1.GcsDestination.newBuilder(
                      (com.google.cloud.aiplatform.v1beta1.GcsDestination) destination_)
                  .mergeFrom(value)
                  .buildPartial();
        } else {
          destination_ = value;
        }
        onChanged();
      } else {
        if (destinationCase_ == 8) {
          gcsDestinationBuilder_.mergeFrom(value);
        }
        gcsDestinationBuilder_.setMessage(value);
      }
      destinationCase_ = 8;
      return this;
    }
    /**
     *
     *
     * <pre>
     * The Cloud Storage location where the training data is to be
     * written to. In the given directory a new directory is created with
     * name:
     * `dataset-&lt;dataset-id&gt;-&lt;annotation-type&gt;-&lt;timestamp-of-training-call&gt;`
     * where timestamp is in YYYY-MM-DDThh:mm:ss.sssZ ISO-8601 format.
     * All training input data is written into that directory.
     * The Vertex AI environment variables representing Cloud Storage
     * data URIs are represented in the Cloud Storage wildcard
     * format to support sharded data. e.g.: "gs://.../training-*.jsonl"
     * * AIP_DATA_FORMAT = "jsonl" for non-tabular data, "csv" for tabular data
     * * AIP_TRAINING_DATA_URI =
     * "gcs_destination/dataset-&lt;dataset-id&gt;-&lt;annotation-type&gt;-&lt;time&gt;/training-*.${AIP_DATA_FORMAT}"
     * * AIP_VALIDATION_DATA_URI =
     * "gcs_destination/dataset-&lt;dataset-id&gt;-&lt;annotation-type&gt;-&lt;time&gt;/validation-*.${AIP_DATA_FORMAT}"
     * * AIP_TEST_DATA_URI =
     * "gcs_destination/dataset-&lt;dataset-id&gt;-&lt;annotation-type&gt;-&lt;time&gt;/test-*.${AIP_DATA_FORMAT}"
     * </pre>
     *
     * <code>.google.cloud.aiplatform.v1beta1.GcsDestination gcs_destination = 8;</code>
     */
    public Builder clearGcsDestination() {
      if (gcsDestinationBuilder_ == null) {
        if (destinationCase_ == 8) {
          destinationCase_ = 0;
          destination_ = null;
          onChanged();
        }
      } else {
        if (destinationCase_ == 8) {
          destinationCase_ = 0;
          destination_ = null;
        }
        gcsDestinationBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * The Cloud Storage location where the training data is to be
     * written to. In the given directory a new directory is created with
     * name:
     * `dataset-&lt;dataset-id&gt;-&lt;annotation-type&gt;-&lt;timestamp-of-training-call&gt;`
     * where timestamp is in YYYY-MM-DDThh:mm:ss.sssZ ISO-8601 format.
     * All training input data is written into that directory.
     * The Vertex AI environment variables representing Cloud Storage
     * data URIs are represented in the Cloud Storage wildcard
     * format to support sharded data. e.g.: "gs://.../training-*.jsonl"
     * * AIP_DATA_FORMAT = "jsonl" for non-tabular data, "csv" for tabular data
     * * AIP_TRAINING_DATA_URI =
     * "gcs_destination/dataset-&lt;dataset-id&gt;-&lt;annotation-type&gt;-&lt;time&gt;/training-*.${AIP_DATA_FORMAT}"
     * * AIP_VALIDATION_DATA_URI =
     * "gcs_destination/dataset-&lt;dataset-id&gt;-&lt;annotation-type&gt;-&lt;time&gt;/validation-*.${AIP_DATA_FORMAT}"
     * * AIP_TEST_DATA_URI =
     * "gcs_destination/dataset-&lt;dataset-id&gt;-&lt;annotation-type&gt;-&lt;time&gt;/test-*.${AIP_DATA_FORMAT}"
     * </pre>
     *
     * <code>.google.cloud.aiplatform.v1beta1.GcsDestination gcs_destination = 8;</code>
     */
    public com.google.cloud.aiplatform.v1beta1.GcsDestination.Builder getGcsDestinationBuilder() {
      return getGcsDestinationFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * The Cloud Storage location where the training data is to be
     * written to. In the given directory a new directory is created with
     * name:
     * `dataset-&lt;dataset-id&gt;-&lt;annotation-type&gt;-&lt;timestamp-of-training-call&gt;`
     * where timestamp is in YYYY-MM-DDThh:mm:ss.sssZ ISO-8601 format.
     * All training input data is written into that directory.
     * The Vertex AI environment variables representing Cloud Storage
     * data URIs are represented in the Cloud Storage wildcard
     * format to support sharded data. e.g.: "gs://.../training-*.jsonl"
     * * AIP_DATA_FORMAT = "jsonl" for non-tabular data, "csv" for tabular data
     * * AIP_TRAINING_DATA_URI =
     * "gcs_destination/dataset-&lt;dataset-id&gt;-&lt;annotation-type&gt;-&lt;time&gt;/training-*.${AIP_DATA_FORMAT}"
     * * AIP_VALIDATION_DATA_URI =
     * "gcs_destination/dataset-&lt;dataset-id&gt;-&lt;annotation-type&gt;-&lt;time&gt;/validation-*.${AIP_DATA_FORMAT}"
     * * AIP_TEST_DATA_URI =
     * "gcs_destination/dataset-&lt;dataset-id&gt;-&lt;annotation-type&gt;-&lt;time&gt;/test-*.${AIP_DATA_FORMAT}"
     * </pre>
     *
     * <code>.google.cloud.aiplatform.v1beta1.GcsDestination gcs_destination = 8;</code>
     */
    @java.lang.Override
    public com.google.cloud.aiplatform.v1beta1.GcsDestinationOrBuilder
        getGcsDestinationOrBuilder() {
      if ((destinationCase_ == 8) && (gcsDestinationBuilder_ != null)) {
        return gcsDestinationBuilder_.getMessageOrBuilder();
      } else {
        if (destinationCase_ == 8) {
          return (com.google.cloud.aiplatform.v1beta1.GcsDestination) destination_;
        }
        return com.google.cloud.aiplatform.v1beta1.GcsDestination.getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * The Cloud Storage location where the training data is to be
     * written to. In the given directory a new directory is created with
     * name:
     * `dataset-&lt;dataset-id&gt;-&lt;annotation-type&gt;-&lt;timestamp-of-training-call&gt;`
     * where timestamp is in YYYY-MM-DDThh:mm:ss.sssZ ISO-8601 format.
     * All training input data is written into that directory.
     * The Vertex AI environment variables representing Cloud Storage
     * data URIs are represented in the Cloud Storage wildcard
     * format to support sharded data. e.g.: "gs://.../training-*.jsonl"
     * * AIP_DATA_FORMAT = "jsonl" for non-tabular data, "csv" for tabular data
     * * AIP_TRAINING_DATA_URI =
     * "gcs_destination/dataset-&lt;dataset-id&gt;-&lt;annotation-type&gt;-&lt;time&gt;/training-*.${AIP_DATA_FORMAT}"
     * * AIP_VALIDATION_DATA_URI =
     * "gcs_destination/dataset-&lt;dataset-id&gt;-&lt;annotation-type&gt;-&lt;time&gt;/validation-*.${AIP_DATA_FORMAT}"
     * * AIP_TEST_DATA_URI =
     * "gcs_destination/dataset-&lt;dataset-id&gt;-&lt;annotation-type&gt;-&lt;time&gt;/test-*.${AIP_DATA_FORMAT}"
     * </pre>
     *
     * <code>.google.cloud.aiplatform.v1beta1.GcsDestination gcs_destination = 8;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.aiplatform.v1beta1.GcsDestination,
            com.google.cloud.aiplatform.v1beta1.GcsDestination.Builder,
            com.google.cloud.aiplatform.v1beta1.GcsDestinationOrBuilder>
        getGcsDestinationFieldBuilder() {
      if (gcsDestinationBuilder_ == null) {
        if (!(destinationCase_ == 8)) {
          destination_ = com.google.cloud.aiplatform.v1beta1.GcsDestination.getDefaultInstance();
        }
        gcsDestinationBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.aiplatform.v1beta1.GcsDestination,
                com.google.cloud.aiplatform.v1beta1.GcsDestination.Builder,
                com.google.cloud.aiplatform.v1beta1.GcsDestinationOrBuilder>(
                (com.google.cloud.aiplatform.v1beta1.GcsDestination) destination_,
                getParentForChildren(),
                isClean());
        destination_ = null;
      }
      destinationCase_ = 8;
      onChanged();
      ;
      return gcsDestinationBuilder_;
    }

    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.aiplatform.v1beta1.BigQueryDestination,
            com.google.cloud.aiplatform.v1beta1.BigQueryDestination.Builder,
            com.google.cloud.aiplatform.v1beta1.BigQueryDestinationOrBuilder>
        bigqueryDestinationBuilder_;
    /**
     *
     *
     * <pre>
     * Only applicable to custom training with tabular Dataset with BigQuery
     * source.
     * The BigQuery project location where the training data is to be written
     * to. In the given project a new dataset is created with name
     * `dataset_&lt;dataset-id&gt;_&lt;annotation-type&gt;_&lt;timestamp-of-training-call&gt;`
     * where timestamp is in YYYY_MM_DDThh_mm_ss_sssZ format. All training
     * input data is written into that dataset. In the dataset three
     * tables are created, `training`, `validation` and `test`.
     * * AIP_DATA_FORMAT = "bigquery".
     * * AIP_TRAINING_DATA_URI  =
     * "bigquery_destination.dataset_&lt;dataset-id&gt;_&lt;annotation-type&gt;_&lt;time&gt;.training"
     * * AIP_VALIDATION_DATA_URI =
     * "bigquery_destination.dataset_&lt;dataset-id&gt;_&lt;annotation-type&gt;_&lt;time&gt;.validation"
     * * AIP_TEST_DATA_URI =
     * "bigquery_destination.dataset_&lt;dataset-id&gt;_&lt;annotation-type&gt;_&lt;time&gt;.test"
     * </pre>
     *
     * <code>.google.cloud.aiplatform.v1beta1.BigQueryDestination bigquery_destination = 10;</code>
     *
     * @return Whether the bigqueryDestination field is set.
     */
    @java.lang.Override
    public boolean hasBigqueryDestination() {
      return destinationCase_ == 10;
    }
    /**
     *
     *
     * <pre>
     * Only applicable to custom training with tabular Dataset with BigQuery
     * source.
     * The BigQuery project location where the training data is to be written
     * to. In the given project a new dataset is created with name
     * `dataset_&lt;dataset-id&gt;_&lt;annotation-type&gt;_&lt;timestamp-of-training-call&gt;`
     * where timestamp is in YYYY_MM_DDThh_mm_ss_sssZ format. All training
     * input data is written into that dataset. In the dataset three
     * tables are created, `training`, `validation` and `test`.
     * * AIP_DATA_FORMAT = "bigquery".
     * * AIP_TRAINING_DATA_URI  =
     * "bigquery_destination.dataset_&lt;dataset-id&gt;_&lt;annotation-type&gt;_&lt;time&gt;.training"
     * * AIP_VALIDATION_DATA_URI =
     * "bigquery_destination.dataset_&lt;dataset-id&gt;_&lt;annotation-type&gt;_&lt;time&gt;.validation"
     * * AIP_TEST_DATA_URI =
     * "bigquery_destination.dataset_&lt;dataset-id&gt;_&lt;annotation-type&gt;_&lt;time&gt;.test"
     * </pre>
     *
     * <code>.google.cloud.aiplatform.v1beta1.BigQueryDestination bigquery_destination = 10;</code>
     *
     * @return The bigqueryDestination.
     */
    @java.lang.Override
    public com.google.cloud.aiplatform.v1beta1.BigQueryDestination getBigqueryDestination() {
      if (bigqueryDestinationBuilder_ == null) {
        if (destinationCase_ == 10) {
          return (com.google.cloud.aiplatform.v1beta1.BigQueryDestination) destination_;
        }
        return com.google.cloud.aiplatform.v1beta1.BigQueryDestination.getDefaultInstance();
      } else {
        if (destinationCase_ == 10) {
          return bigqueryDestinationBuilder_.getMessage();
        }
        return com.google.cloud.aiplatform.v1beta1.BigQueryDestination.getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * Only applicable to custom training with tabular Dataset with BigQuery
     * source.
     * The BigQuery project location where the training data is to be written
     * to. In the given project a new dataset is created with name
     * `dataset_&lt;dataset-id&gt;_&lt;annotation-type&gt;_&lt;timestamp-of-training-call&gt;`
     * where timestamp is in YYYY_MM_DDThh_mm_ss_sssZ format. All training
     * input data is written into that dataset. In the dataset three
     * tables are created, `training`, `validation` and `test`.
     * * AIP_DATA_FORMAT = "bigquery".
     * * AIP_TRAINING_DATA_URI  =
     * "bigquery_destination.dataset_&lt;dataset-id&gt;_&lt;annotation-type&gt;_&lt;time&gt;.training"
     * * AIP_VALIDATION_DATA_URI =
     * "bigquery_destination.dataset_&lt;dataset-id&gt;_&lt;annotation-type&gt;_&lt;time&gt;.validation"
     * * AIP_TEST_DATA_URI =
     * "bigquery_destination.dataset_&lt;dataset-id&gt;_&lt;annotation-type&gt;_&lt;time&gt;.test"
     * </pre>
     *
     * <code>.google.cloud.aiplatform.v1beta1.BigQueryDestination bigquery_destination = 10;</code>
     */
    public Builder setBigqueryDestination(
        com.google.cloud.aiplatform.v1beta1.BigQueryDestination value) {
      if (bigqueryDestinationBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        destination_ = value;
        onChanged();
      } else {
        bigqueryDestinationBuilder_.setMessage(value);
      }
      destinationCase_ = 10;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Only applicable to custom training with tabular Dataset with BigQuery
     * source.
     * The BigQuery project location where the training data is to be written
     * to. In the given project a new dataset is created with name
     * `dataset_&lt;dataset-id&gt;_&lt;annotation-type&gt;_&lt;timestamp-of-training-call&gt;`
     * where timestamp is in YYYY_MM_DDThh_mm_ss_sssZ format. All training
     * input data is written into that dataset. In the dataset three
     * tables are created, `training`, `validation` and `test`.
     * * AIP_DATA_FORMAT = "bigquery".
     * * AIP_TRAINING_DATA_URI  =
     * "bigquery_destination.dataset_&lt;dataset-id&gt;_&lt;annotation-type&gt;_&lt;time&gt;.training"
     * * AIP_VALIDATION_DATA_URI =
     * "bigquery_destination.dataset_&lt;dataset-id&gt;_&lt;annotation-type&gt;_&lt;time&gt;.validation"
     * * AIP_TEST_DATA_URI =
     * "bigquery_destination.dataset_&lt;dataset-id&gt;_&lt;annotation-type&gt;_&lt;time&gt;.test"
     * </pre>
     *
     * <code>.google.cloud.aiplatform.v1beta1.BigQueryDestination bigquery_destination = 10;</code>
     */
    public Builder setBigqueryDestination(
        com.google.cloud.aiplatform.v1beta1.BigQueryDestination.Builder builderForValue) {
      if (bigqueryDestinationBuilder_ == null) {
        destination_ = builderForValue.build();
        onChanged();
      } else {
        bigqueryDestinationBuilder_.setMessage(builderForValue.build());
      }
      destinationCase_ = 10;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Only applicable to custom training with tabular Dataset with BigQuery
     * source.
     * The BigQuery project location where the training data is to be written
     * to. In the given project a new dataset is created with name
     * `dataset_&lt;dataset-id&gt;_&lt;annotation-type&gt;_&lt;timestamp-of-training-call&gt;`
     * where timestamp is in YYYY_MM_DDThh_mm_ss_sssZ format. All training
     * input data is written into that dataset. In the dataset three
     * tables are created, `training`, `validation` and `test`.
     * * AIP_DATA_FORMAT = "bigquery".
     * * AIP_TRAINING_DATA_URI  =
     * "bigquery_destination.dataset_&lt;dataset-id&gt;_&lt;annotation-type&gt;_&lt;time&gt;.training"
     * * AIP_VALIDATION_DATA_URI =
     * "bigquery_destination.dataset_&lt;dataset-id&gt;_&lt;annotation-type&gt;_&lt;time&gt;.validation"
     * * AIP_TEST_DATA_URI =
     * "bigquery_destination.dataset_&lt;dataset-id&gt;_&lt;annotation-type&gt;_&lt;time&gt;.test"
     * </pre>
     *
     * <code>.google.cloud.aiplatform.v1beta1.BigQueryDestination bigquery_destination = 10;</code>
     */
    public Builder mergeBigqueryDestination(
        com.google.cloud.aiplatform.v1beta1.BigQueryDestination value) {
      if (bigqueryDestinationBuilder_ == null) {
        if (destinationCase_ == 10
            && destination_
                != com.google.cloud.aiplatform.v1beta1.BigQueryDestination.getDefaultInstance()) {
          destination_ =
              com.google.cloud.aiplatform.v1beta1.BigQueryDestination.newBuilder(
                      (com.google.cloud.aiplatform.v1beta1.BigQueryDestination) destination_)
                  .mergeFrom(value)
                  .buildPartial();
        } else {
          destination_ = value;
        }
        onChanged();
      } else {
        if (destinationCase_ == 10) {
          bigqueryDestinationBuilder_.mergeFrom(value);
        }
        bigqueryDestinationBuilder_.setMessage(value);
      }
      destinationCase_ = 10;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Only applicable to custom training with tabular Dataset with BigQuery
     * source.
     * The BigQuery project location where the training data is to be written
     * to. In the given project a new dataset is created with name
     * `dataset_&lt;dataset-id&gt;_&lt;annotation-type&gt;_&lt;timestamp-of-training-call&gt;`
     * where timestamp is in YYYY_MM_DDThh_mm_ss_sssZ format. All training
     * input data is written into that dataset. In the dataset three
     * tables are created, `training`, `validation` and `test`.
     * * AIP_DATA_FORMAT = "bigquery".
     * * AIP_TRAINING_DATA_URI  =
     * "bigquery_destination.dataset_&lt;dataset-id&gt;_&lt;annotation-type&gt;_&lt;time&gt;.training"
     * * AIP_VALIDATION_DATA_URI =
     * "bigquery_destination.dataset_&lt;dataset-id&gt;_&lt;annotation-type&gt;_&lt;time&gt;.validation"
     * * AIP_TEST_DATA_URI =
     * "bigquery_destination.dataset_&lt;dataset-id&gt;_&lt;annotation-type&gt;_&lt;time&gt;.test"
     * </pre>
     *
     * <code>.google.cloud.aiplatform.v1beta1.BigQueryDestination bigquery_destination = 10;</code>
     */
    public Builder clearBigqueryDestination() {
      if (bigqueryDestinationBuilder_ == null) {
        if (destinationCase_ == 10) {
          destinationCase_ = 0;
          destination_ = null;
          onChanged();
        }
      } else {
        if (destinationCase_ == 10) {
          destinationCase_ = 0;
          destination_ = null;
        }
        bigqueryDestinationBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Only applicable to custom training with tabular Dataset with BigQuery
     * source.
     * The BigQuery project location where the training data is to be written
     * to. In the given project a new dataset is created with name
     * `dataset_&lt;dataset-id&gt;_&lt;annotation-type&gt;_&lt;timestamp-of-training-call&gt;`
     * where timestamp is in YYYY_MM_DDThh_mm_ss_sssZ format. All training
     * input data is written into that dataset. In the dataset three
     * tables are created, `training`, `validation` and `test`.
     * * AIP_DATA_FORMAT = "bigquery".
     * * AIP_TRAINING_DATA_URI  =
     * "bigquery_destination.dataset_&lt;dataset-id&gt;_&lt;annotation-type&gt;_&lt;time&gt;.training"
     * * AIP_VALIDATION_DATA_URI =
     * "bigquery_destination.dataset_&lt;dataset-id&gt;_&lt;annotation-type&gt;_&lt;time&gt;.validation"
     * * AIP_TEST_DATA_URI =
     * "bigquery_destination.dataset_&lt;dataset-id&gt;_&lt;annotation-type&gt;_&lt;time&gt;.test"
     * </pre>
     *
     * <code>.google.cloud.aiplatform.v1beta1.BigQueryDestination bigquery_destination = 10;</code>
     */
    public com.google.cloud.aiplatform.v1beta1.BigQueryDestination.Builder
        getBigqueryDestinationBuilder() {
      return getBigqueryDestinationFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Only applicable to custom training with tabular Dataset with BigQuery
     * source.
     * The BigQuery project location where the training data is to be written
     * to. In the given project a new dataset is created with name
     * `dataset_&lt;dataset-id&gt;_&lt;annotation-type&gt;_&lt;timestamp-of-training-call&gt;`
     * where timestamp is in YYYY_MM_DDThh_mm_ss_sssZ format. All training
     * input data is written into that dataset. In the dataset three
     * tables are created, `training`, `validation` and `test`.
     * * AIP_DATA_FORMAT = "bigquery".
     * * AIP_TRAINING_DATA_URI  =
     * "bigquery_destination.dataset_&lt;dataset-id&gt;_&lt;annotation-type&gt;_&lt;time&gt;.training"
     * * AIP_VALIDATION_DATA_URI =
     * "bigquery_destination.dataset_&lt;dataset-id&gt;_&lt;annotation-type&gt;_&lt;time&gt;.validation"
     * * AIP_TEST_DATA_URI =
     * "bigquery_destination.dataset_&lt;dataset-id&gt;_&lt;annotation-type&gt;_&lt;time&gt;.test"
     * </pre>
     *
     * <code>.google.cloud.aiplatform.v1beta1.BigQueryDestination bigquery_destination = 10;</code>
     */
    @java.lang.Override
    public com.google.cloud.aiplatform.v1beta1.BigQueryDestinationOrBuilder
        getBigqueryDestinationOrBuilder() {
      if ((destinationCase_ == 10) && (bigqueryDestinationBuilder_ != null)) {
        return bigqueryDestinationBuilder_.getMessageOrBuilder();
      } else {
        if (destinationCase_ == 10) {
          return (com.google.cloud.aiplatform.v1beta1.BigQueryDestination) destination_;
        }
        return com.google.cloud.aiplatform.v1beta1.BigQueryDestination.getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * Only applicable to custom training with tabular Dataset with BigQuery
     * source.
     * The BigQuery project location where the training data is to be written
     * to. In the given project a new dataset is created with name
     * `dataset_&lt;dataset-id&gt;_&lt;annotation-type&gt;_&lt;timestamp-of-training-call&gt;`
     * where timestamp is in YYYY_MM_DDThh_mm_ss_sssZ format. All training
     * input data is written into that dataset. In the dataset three
     * tables are created, `training`, `validation` and `test`.
     * * AIP_DATA_FORMAT = "bigquery".
     * * AIP_TRAINING_DATA_URI  =
     * "bigquery_destination.dataset_&lt;dataset-id&gt;_&lt;annotation-type&gt;_&lt;time&gt;.training"
     * * AIP_VALIDATION_DATA_URI =
     * "bigquery_destination.dataset_&lt;dataset-id&gt;_&lt;annotation-type&gt;_&lt;time&gt;.validation"
     * * AIP_TEST_DATA_URI =
     * "bigquery_destination.dataset_&lt;dataset-id&gt;_&lt;annotation-type&gt;_&lt;time&gt;.test"
     * </pre>
     *
     * <code>.google.cloud.aiplatform.v1beta1.BigQueryDestination bigquery_destination = 10;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.aiplatform.v1beta1.BigQueryDestination,
            com.google.cloud.aiplatform.v1beta1.BigQueryDestination.Builder,
            com.google.cloud.aiplatform.v1beta1.BigQueryDestinationOrBuilder>
        getBigqueryDestinationFieldBuilder() {
      if (bigqueryDestinationBuilder_ == null) {
        if (!(destinationCase_ == 10)) {
          destination_ =
              com.google.cloud.aiplatform.v1beta1.BigQueryDestination.getDefaultInstance();
        }
        bigqueryDestinationBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.aiplatform.v1beta1.BigQueryDestination,
                com.google.cloud.aiplatform.v1beta1.BigQueryDestination.Builder,
                com.google.cloud.aiplatform.v1beta1.BigQueryDestinationOrBuilder>(
                (com.google.cloud.aiplatform.v1beta1.BigQueryDestination) destination_,
                getParentForChildren(),
                isClean());
        destination_ = null;
      }
      destinationCase_ = 10;
      onChanged();
      ;
      return bigqueryDestinationBuilder_;
    }

    private java.lang.Object datasetId_ = "";
    /**
     *
     *
     * <pre>
     * Required. The ID of the Dataset in the same Project and Location which data will be
     * used to train the Model. The Dataset must use schema compatible with
     * Model being trained, and what is compatible should be described in the
     * used TrainingPipeline's [training_task_definition]
     * [google.cloud.aiplatform.v1beta1.TrainingPipeline.training_task_definition].
     * For tabular Datasets, all their data is exported to training, to pick
     * and choose from.
     * </pre>
     *
     * <code>string dataset_id = 1 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return The datasetId.
     */
    public java.lang.String getDatasetId() {
      java.lang.Object ref = datasetId_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        datasetId_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Required. The ID of the Dataset in the same Project and Location which data will be
     * used to train the Model. The Dataset must use schema compatible with
     * Model being trained, and what is compatible should be described in the
     * used TrainingPipeline's [training_task_definition]
     * [google.cloud.aiplatform.v1beta1.TrainingPipeline.training_task_definition].
     * For tabular Datasets, all their data is exported to training, to pick
     * and choose from.
     * </pre>
     *
     * <code>string dataset_id = 1 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return The bytes for datasetId.
     */
    public com.google.protobuf.ByteString getDatasetIdBytes() {
      java.lang.Object ref = datasetId_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        datasetId_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Required. The ID of the Dataset in the same Project and Location which data will be
     * used to train the Model. The Dataset must use schema compatible with
     * Model being trained, and what is compatible should be described in the
     * used TrainingPipeline's [training_task_definition]
     * [google.cloud.aiplatform.v1beta1.TrainingPipeline.training_task_definition].
     * For tabular Datasets, all their data is exported to training, to pick
     * and choose from.
     * </pre>
     *
     * <code>string dataset_id = 1 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @param value The datasetId to set.
     * @return This builder for chaining.
     */
    public Builder setDatasetId(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }

      datasetId_ = value;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. The ID of the Dataset in the same Project and Location which data will be
     * used to train the Model. The Dataset must use schema compatible with
     * Model being trained, and what is compatible should be described in the
     * used TrainingPipeline's [training_task_definition]
     * [google.cloud.aiplatform.v1beta1.TrainingPipeline.training_task_definition].
     * For tabular Datasets, all their data is exported to training, to pick
     * and choose from.
     * </pre>
     *
     * <code>string dataset_id = 1 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearDatasetId() {

      datasetId_ = getDefaultInstance().getDatasetId();
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. The ID of the Dataset in the same Project and Location which data will be
     * used to train the Model. The Dataset must use schema compatible with
     * Model being trained, and what is compatible should be described in the
     * used TrainingPipeline's [training_task_definition]
     * [google.cloud.aiplatform.v1beta1.TrainingPipeline.training_task_definition].
     * For tabular Datasets, all their data is exported to training, to pick
     * and choose from.
     * </pre>
     *
     * <code>string dataset_id = 1 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @param value The bytes for datasetId to set.
     * @return This builder for chaining.
     */
    public Builder setDatasetIdBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);

      datasetId_ = value;
      onChanged();
      return this;
    }

    private java.lang.Object annotationsFilter_ = "";
    /**
     *
     *
     * <pre>
     * Applicable only to Datasets that have DataItems and Annotations.
     * A filter on Annotations of the Dataset. Only Annotations that both
     * match this filter and belong to DataItems not ignored by the split method
     * are used in respectively training, validation or test role, depending on
     * the role of the DataItem they are on (for the auto-assigned that role is
     * decided by Vertex AI). A filter with same syntax as the one used in
     * [ListAnnotations][google.cloud.aiplatform.v1beta1.DatasetService.ListAnnotations] may be used, but note
     * here it filters across all Annotations of the Dataset, and not just within
     * a single DataItem.
     * </pre>
     *
     * <code>string annotations_filter = 6;</code>
     *
     * @return The annotationsFilter.
     */
    public java.lang.String getAnnotationsFilter() {
      java.lang.Object ref = annotationsFilter_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        annotationsFilter_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Applicable only to Datasets that have DataItems and Annotations.
     * A filter on Annotations of the Dataset. Only Annotations that both
     * match this filter and belong to DataItems not ignored by the split method
     * are used in respectively training, validation or test role, depending on
     * the role of the DataItem they are on (for the auto-assigned that role is
     * decided by Vertex AI). A filter with same syntax as the one used in
     * [ListAnnotations][google.cloud.aiplatform.v1beta1.DatasetService.ListAnnotations] may be used, but note
     * here it filters across all Annotations of the Dataset, and not just within
     * a single DataItem.
     * </pre>
     *
     * <code>string annotations_filter = 6;</code>
     *
     * @return The bytes for annotationsFilter.
     */
    public com.google.protobuf.ByteString getAnnotationsFilterBytes() {
      java.lang.Object ref = annotationsFilter_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        annotationsFilter_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Applicable only to Datasets that have DataItems and Annotations.
     * A filter on Annotations of the Dataset. Only Annotations that both
     * match this filter and belong to DataItems not ignored by the split method
     * are used in respectively training, validation or test role, depending on
     * the role of the DataItem they are on (for the auto-assigned that role is
     * decided by Vertex AI). A filter with same syntax as the one used in
     * [ListAnnotations][google.cloud.aiplatform.v1beta1.DatasetService.ListAnnotations] may be used, but note
     * here it filters across all Annotations of the Dataset, and not just within
     * a single DataItem.
     * </pre>
     *
     * <code>string annotations_filter = 6;</code>
     *
     * @param value The annotationsFilter to set.
     * @return This builder for chaining.
     */
    public Builder setAnnotationsFilter(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }

      annotationsFilter_ = value;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Applicable only to Datasets that have DataItems and Annotations.
     * A filter on Annotations of the Dataset. Only Annotations that both
     * match this filter and belong to DataItems not ignored by the split method
     * are used in respectively training, validation or test role, depending on
     * the role of the DataItem they are on (for the auto-assigned that role is
     * decided by Vertex AI). A filter with same syntax as the one used in
     * [ListAnnotations][google.cloud.aiplatform.v1beta1.DatasetService.ListAnnotations] may be used, but note
     * here it filters across all Annotations of the Dataset, and not just within
     * a single DataItem.
     * </pre>
     *
     * <code>string annotations_filter = 6;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearAnnotationsFilter() {

      annotationsFilter_ = getDefaultInstance().getAnnotationsFilter();
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Applicable only to Datasets that have DataItems and Annotations.
     * A filter on Annotations of the Dataset. Only Annotations that both
     * match this filter and belong to DataItems not ignored by the split method
     * are used in respectively training, validation or test role, depending on
     * the role of the DataItem they are on (for the auto-assigned that role is
     * decided by Vertex AI). A filter with same syntax as the one used in
     * [ListAnnotations][google.cloud.aiplatform.v1beta1.DatasetService.ListAnnotations] may be used, but note
     * here it filters across all Annotations of the Dataset, and not just within
     * a single DataItem.
     * </pre>
     *
     * <code>string annotations_filter = 6;</code>
     *
     * @param value The bytes for annotationsFilter to set.
     * @return This builder for chaining.
     */
    public Builder setAnnotationsFilterBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);

      annotationsFilter_ = value;
      onChanged();
      return this;
    }

    private java.lang.Object annotationSchemaUri_ = "";
    /**
     *
     *
     * <pre>
     * Applicable only to custom training with Datasets that have DataItems and
     * Annotations.
     * Cloud Storage URI that points to a YAML file describing the annotation
     * schema. The schema is defined as an OpenAPI 3.0.2 [Schema
     * Object](https://github.com/OAI/OpenAPI-Specification/blob/main/versions/3.0.2.md#schemaObject).
     * The schema files that can be used here are found in
     * gs://google-cloud-aiplatform/schema/dataset/annotation/ , note that the
     * chosen schema must be consistent with
     * [metadata][google.cloud.aiplatform.v1beta1.Dataset.metadata_schema_uri] of the Dataset specified by
     * [dataset_id][google.cloud.aiplatform.v1beta1.InputDataConfig.dataset_id].
     * Only Annotations that both match this schema and belong to DataItems not
     * ignored by the split method are used in respectively training, validation
     * or test role, depending on the role of the DataItem they are on.
     * When used in conjunction with [annotations_filter][google.cloud.aiplatform.v1beta1.InputDataConfig.annotations_filter], the Annotations used
     * for training are filtered by both [annotations_filter][google.cloud.aiplatform.v1beta1.InputDataConfig.annotations_filter] and
     * [annotation_schema_uri][google.cloud.aiplatform.v1beta1.InputDataConfig.annotation_schema_uri].
     * </pre>
     *
     * <code>string annotation_schema_uri = 9;</code>
     *
     * @return The annotationSchemaUri.
     */
    public java.lang.String getAnnotationSchemaUri() {
      java.lang.Object ref = annotationSchemaUri_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        annotationSchemaUri_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Applicable only to custom training with Datasets that have DataItems and
     * Annotations.
     * Cloud Storage URI that points to a YAML file describing the annotation
     * schema. The schema is defined as an OpenAPI 3.0.2 [Schema
     * Object](https://github.com/OAI/OpenAPI-Specification/blob/main/versions/3.0.2.md#schemaObject).
     * The schema files that can be used here are found in
     * gs://google-cloud-aiplatform/schema/dataset/annotation/ , note that the
     * chosen schema must be consistent with
     * [metadata][google.cloud.aiplatform.v1beta1.Dataset.metadata_schema_uri] of the Dataset specified by
     * [dataset_id][google.cloud.aiplatform.v1beta1.InputDataConfig.dataset_id].
     * Only Annotations that both match this schema and belong to DataItems not
     * ignored by the split method are used in respectively training, validation
     * or test role, depending on the role of the DataItem they are on.
     * When used in conjunction with [annotations_filter][google.cloud.aiplatform.v1beta1.InputDataConfig.annotations_filter], the Annotations used
     * for training are filtered by both [annotations_filter][google.cloud.aiplatform.v1beta1.InputDataConfig.annotations_filter] and
     * [annotation_schema_uri][google.cloud.aiplatform.v1beta1.InputDataConfig.annotation_schema_uri].
     * </pre>
     *
     * <code>string annotation_schema_uri = 9;</code>
     *
     * @return The bytes for annotationSchemaUri.
     */
    public com.google.protobuf.ByteString getAnnotationSchemaUriBytes() {
      java.lang.Object ref = annotationSchemaUri_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        annotationSchemaUri_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Applicable only to custom training with Datasets that have DataItems and
     * Annotations.
     * Cloud Storage URI that points to a YAML file describing the annotation
     * schema. The schema is defined as an OpenAPI 3.0.2 [Schema
     * Object](https://github.com/OAI/OpenAPI-Specification/blob/main/versions/3.0.2.md#schemaObject).
     * The schema files that can be used here are found in
     * gs://google-cloud-aiplatform/schema/dataset/annotation/ , note that the
     * chosen schema must be consistent with
     * [metadata][google.cloud.aiplatform.v1beta1.Dataset.metadata_schema_uri] of the Dataset specified by
     * [dataset_id][google.cloud.aiplatform.v1beta1.InputDataConfig.dataset_id].
     * Only Annotations that both match this schema and belong to DataItems not
     * ignored by the split method are used in respectively training, validation
     * or test role, depending on the role of the DataItem they are on.
     * When used in conjunction with [annotations_filter][google.cloud.aiplatform.v1beta1.InputDataConfig.annotations_filter], the Annotations used
     * for training are filtered by both [annotations_filter][google.cloud.aiplatform.v1beta1.InputDataConfig.annotations_filter] and
     * [annotation_schema_uri][google.cloud.aiplatform.v1beta1.InputDataConfig.annotation_schema_uri].
     * </pre>
     *
     * <code>string annotation_schema_uri = 9;</code>
     *
     * @param value The annotationSchemaUri to set.
     * @return This builder for chaining.
     */
    public Builder setAnnotationSchemaUri(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }

      annotationSchemaUri_ = value;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Applicable only to custom training with Datasets that have DataItems and
     * Annotations.
     * Cloud Storage URI that points to a YAML file describing the annotation
     * schema. The schema is defined as an OpenAPI 3.0.2 [Schema
     * Object](https://github.com/OAI/OpenAPI-Specification/blob/main/versions/3.0.2.md#schemaObject).
     * The schema files that can be used here are found in
     * gs://google-cloud-aiplatform/schema/dataset/annotation/ , note that the
     * chosen schema must be consistent with
     * [metadata][google.cloud.aiplatform.v1beta1.Dataset.metadata_schema_uri] of the Dataset specified by
     * [dataset_id][google.cloud.aiplatform.v1beta1.InputDataConfig.dataset_id].
     * Only Annotations that both match this schema and belong to DataItems not
     * ignored by the split method are used in respectively training, validation
     * or test role, depending on the role of the DataItem they are on.
     * When used in conjunction with [annotations_filter][google.cloud.aiplatform.v1beta1.InputDataConfig.annotations_filter], the Annotations used
     * for training are filtered by both [annotations_filter][google.cloud.aiplatform.v1beta1.InputDataConfig.annotations_filter] and
     * [annotation_schema_uri][google.cloud.aiplatform.v1beta1.InputDataConfig.annotation_schema_uri].
     * </pre>
     *
     * <code>string annotation_schema_uri = 9;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearAnnotationSchemaUri() {

      annotationSchemaUri_ = getDefaultInstance().getAnnotationSchemaUri();
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Applicable only to custom training with Datasets that have DataItems and
     * Annotations.
     * Cloud Storage URI that points to a YAML file describing the annotation
     * schema. The schema is defined as an OpenAPI 3.0.2 [Schema
     * Object](https://github.com/OAI/OpenAPI-Specification/blob/main/versions/3.0.2.md#schemaObject).
     * The schema files that can be used here are found in
     * gs://google-cloud-aiplatform/schema/dataset/annotation/ , note that the
     * chosen schema must be consistent with
     * [metadata][google.cloud.aiplatform.v1beta1.Dataset.metadata_schema_uri] of the Dataset specified by
     * [dataset_id][google.cloud.aiplatform.v1beta1.InputDataConfig.dataset_id].
     * Only Annotations that both match this schema and belong to DataItems not
     * ignored by the split method are used in respectively training, validation
     * or test role, depending on the role of the DataItem they are on.
     * When used in conjunction with [annotations_filter][google.cloud.aiplatform.v1beta1.InputDataConfig.annotations_filter], the Annotations used
     * for training are filtered by both [annotations_filter][google.cloud.aiplatform.v1beta1.InputDataConfig.annotations_filter] and
     * [annotation_schema_uri][google.cloud.aiplatform.v1beta1.InputDataConfig.annotation_schema_uri].
     * </pre>
     *
     * <code>string annotation_schema_uri = 9;</code>
     *
     * @param value The bytes for annotationSchemaUri to set.
     * @return This builder for chaining.
     */
    public Builder setAnnotationSchemaUriBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);

      annotationSchemaUri_ = value;
      onChanged();
      return this;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.cloud.aiplatform.v1beta1.InputDataConfig)
  }

  // @@protoc_insertion_point(class_scope:google.cloud.aiplatform.v1beta1.InputDataConfig)
  private static final com.google.cloud.aiplatform.v1beta1.InputDataConfig DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.cloud.aiplatform.v1beta1.InputDataConfig();
  }

  public static com.google.cloud.aiplatform.v1beta1.InputDataConfig getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<InputDataConfig> PARSER =
      new com.google.protobuf.AbstractParser<InputDataConfig>() {
        @java.lang.Override
        public InputDataConfig parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          return new InputDataConfig(input, extensionRegistry);
        }
      };

  public static com.google.protobuf.Parser<InputDataConfig> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<InputDataConfig> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.cloud.aiplatform.v1beta1.InputDataConfig getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
