/*
 * Copyright 2020 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/cloud/aiplatform/v1beta1/pipeline_service.proto

package com.google.cloud.aiplatform.v1beta1;

public interface ListPipelineJobsRequestOrBuilder
    extends
    // @@protoc_insertion_point(interface_extends:google.cloud.aiplatform.v1beta1.ListPipelineJobsRequest)
    com.google.protobuf.MessageOrBuilder {

  /**
   *
   *
   * <pre>
   * Required. The resource name of the Location to list the PipelineJobs from.
   * Format: `projects/{project}/locations/{location}`
   * </pre>
   *
   * <code>
   * string parent = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
   * </code>
   *
   * @return The parent.
   */
  java.lang.String getParent();
  /**
   *
   *
   * <pre>
   * Required. The resource name of the Location to list the PipelineJobs from.
   * Format: `projects/{project}/locations/{location}`
   * </pre>
   *
   * <code>
   * string parent = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
   * </code>
   *
   * @return The bytes for parent.
   */
  com.google.protobuf.ByteString getParentBytes();

  /**
   *
   *
   * <pre>
   * Lists the PipelineJobs that match the filter expression. The following
   * fields are supported:
   * * `pipeline_name`: Supports `=` and `!=` comparisons.
   * * `create_time`: Supports `=`, `!=`, `&lt;`, `&gt;`, `&lt;=`, and `&gt;=` comparisons.
   *   Values must be in RFC 3339 format.
   * * `update_time`: Supports `=`, `!=`, `&lt;`, `&gt;`, `&lt;=`, and `&gt;=` comparisons.
   *   Values must be in RFC 3339 format.
   * * `end_time`: Supports `=`, `!=`, `&lt;`, `&gt;`, `&lt;=`, and `&gt;=` comparisons.
   *   Values must be in RFC 3339 format.
   * * `labels`: Supports key-value equality and key presence.
   * Filter expressions can be combined together using logical operators
   * (`AND` &amp; `OR`).
   * For example: `pipeline_name="test" AND create_time&gt;"2020-05-18T13:30:00Z"`.
   * The syntax to define filter expression is based on
   * https://google.aip.dev/160.
   * Examples:
   * * `create_time&gt;"2021-05-18T00:00:00Z" OR
   *   update_time&gt;"2020-05-18T00:00:00Z"` PipelineJobs created or updated
   *   after 2020-05-18 00:00:00 UTC.
   * * `labels.env = "prod"`
   *   PipelineJobs with label "env" set to "prod".
   * </pre>
   *
   * <code>string filter = 2;</code>
   *
   * @return The filter.
   */
  java.lang.String getFilter();
  /**
   *
   *
   * <pre>
   * Lists the PipelineJobs that match the filter expression. The following
   * fields are supported:
   * * `pipeline_name`: Supports `=` and `!=` comparisons.
   * * `create_time`: Supports `=`, `!=`, `&lt;`, `&gt;`, `&lt;=`, and `&gt;=` comparisons.
   *   Values must be in RFC 3339 format.
   * * `update_time`: Supports `=`, `!=`, `&lt;`, `&gt;`, `&lt;=`, and `&gt;=` comparisons.
   *   Values must be in RFC 3339 format.
   * * `end_time`: Supports `=`, `!=`, `&lt;`, `&gt;`, `&lt;=`, and `&gt;=` comparisons.
   *   Values must be in RFC 3339 format.
   * * `labels`: Supports key-value equality and key presence.
   * Filter expressions can be combined together using logical operators
   * (`AND` &amp; `OR`).
   * For example: `pipeline_name="test" AND create_time&gt;"2020-05-18T13:30:00Z"`.
   * The syntax to define filter expression is based on
   * https://google.aip.dev/160.
   * Examples:
   * * `create_time&gt;"2021-05-18T00:00:00Z" OR
   *   update_time&gt;"2020-05-18T00:00:00Z"` PipelineJobs created or updated
   *   after 2020-05-18 00:00:00 UTC.
   * * `labels.env = "prod"`
   *   PipelineJobs with label "env" set to "prod".
   * </pre>
   *
   * <code>string filter = 2;</code>
   *
   * @return The bytes for filter.
   */
  com.google.protobuf.ByteString getFilterBytes();

  /**
   *
   *
   * <pre>
   * The standard list page size.
   * </pre>
   *
   * <code>int32 page_size = 3;</code>
   *
   * @return The pageSize.
   */
  int getPageSize();

  /**
   *
   *
   * <pre>
   * The standard list page token.
   * Typically obtained via
   * [ListPipelineJobsResponse.next_page_token][google.cloud.aiplatform.v1beta1.ListPipelineJobsResponse.next_page_token] of the previous
   * [PipelineService.ListPipelineJobs][google.cloud.aiplatform.v1beta1.PipelineService.ListPipelineJobs] call.
   * </pre>
   *
   * <code>string page_token = 4;</code>
   *
   * @return The pageToken.
   */
  java.lang.String getPageToken();
  /**
   *
   *
   * <pre>
   * The standard list page token.
   * Typically obtained via
   * [ListPipelineJobsResponse.next_page_token][google.cloud.aiplatform.v1beta1.ListPipelineJobsResponse.next_page_token] of the previous
   * [PipelineService.ListPipelineJobs][google.cloud.aiplatform.v1beta1.PipelineService.ListPipelineJobs] call.
   * </pre>
   *
   * <code>string page_token = 4;</code>
   *
   * @return The bytes for pageToken.
   */
  com.google.protobuf.ByteString getPageTokenBytes();
}
