/*
 * Copyright 2020 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/cloud/aiplatform/v1beta1/migration_service.proto

package com.google.cloud.aiplatform.v1beta1;

/**
 *
 *
 * <pre>
 * Config of migrating one resource from automl.googleapis.com,
 * datalabeling.googleapis.com and ml.googleapis.com to Vertex AI.
 * </pre>
 *
 * Protobuf type {@code google.cloud.aiplatform.v1beta1.MigrateResourceRequest}
 */
public final class MigrateResourceRequest extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.cloud.aiplatform.v1beta1.MigrateResourceRequest)
    MigrateResourceRequestOrBuilder {
  private static final long serialVersionUID = 0L;
  // Use MigrateResourceRequest.newBuilder() to construct.
  private MigrateResourceRequest(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private MigrateResourceRequest() {}

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new MigrateResourceRequest();
  }

  @java.lang.Override
  public final com.google.protobuf.UnknownFieldSet getUnknownFields() {
    return this.unknownFields;
  }

  private MigrateResourceRequest(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    this();
    if (extensionRegistry == null) {
      throw new java.lang.NullPointerException();
    }
    com.google.protobuf.UnknownFieldSet.Builder unknownFields =
        com.google.protobuf.UnknownFieldSet.newBuilder();
    try {
      boolean done = false;
      while (!done) {
        int tag = input.readTag();
        switch (tag) {
          case 0:
            done = true;
            break;
          case 10:
            {
              com.google.cloud.aiplatform.v1beta1.MigrateResourceRequest
                      .MigrateMlEngineModelVersionConfig.Builder
                  subBuilder = null;
              if (requestCase_ == 1) {
                subBuilder =
                    ((com.google.cloud.aiplatform.v1beta1.MigrateResourceRequest
                                .MigrateMlEngineModelVersionConfig)
                            request_)
                        .toBuilder();
              }
              request_ =
                  input.readMessage(
                      com.google.cloud.aiplatform.v1beta1.MigrateResourceRequest
                          .MigrateMlEngineModelVersionConfig.parser(),
                      extensionRegistry);
              if (subBuilder != null) {
                subBuilder.mergeFrom(
                    (com.google.cloud.aiplatform.v1beta1.MigrateResourceRequest
                            .MigrateMlEngineModelVersionConfig)
                        request_);
                request_ = subBuilder.buildPartial();
              }
              requestCase_ = 1;
              break;
            }
          case 18:
            {
              com.google.cloud.aiplatform.v1beta1.MigrateResourceRequest.MigrateAutomlModelConfig
                      .Builder
                  subBuilder = null;
              if (requestCase_ == 2) {
                subBuilder =
                    ((com.google.cloud.aiplatform.v1beta1.MigrateResourceRequest
                                .MigrateAutomlModelConfig)
                            request_)
                        .toBuilder();
              }
              request_ =
                  input.readMessage(
                      com.google.cloud.aiplatform.v1beta1.MigrateResourceRequest
                          .MigrateAutomlModelConfig.parser(),
                      extensionRegistry);
              if (subBuilder != null) {
                subBuilder.mergeFrom(
                    (com.google.cloud.aiplatform.v1beta1.MigrateResourceRequest
                            .MigrateAutomlModelConfig)
                        request_);
                request_ = subBuilder.buildPartial();
              }
              requestCase_ = 2;
              break;
            }
          case 26:
            {
              com.google.cloud.aiplatform.v1beta1.MigrateResourceRequest.MigrateAutomlDatasetConfig
                      .Builder
                  subBuilder = null;
              if (requestCase_ == 3) {
                subBuilder =
                    ((com.google.cloud.aiplatform.v1beta1.MigrateResourceRequest
                                .MigrateAutomlDatasetConfig)
                            request_)
                        .toBuilder();
              }
              request_ =
                  input.readMessage(
                      com.google.cloud.aiplatform.v1beta1.MigrateResourceRequest
                          .MigrateAutomlDatasetConfig.parser(),
                      extensionRegistry);
              if (subBuilder != null) {
                subBuilder.mergeFrom(
                    (com.google.cloud.aiplatform.v1beta1.MigrateResourceRequest
                            .MigrateAutomlDatasetConfig)
                        request_);
                request_ = subBuilder.buildPartial();
              }
              requestCase_ = 3;
              break;
            }
          case 34:
            {
              com.google.cloud.aiplatform.v1beta1.MigrateResourceRequest
                      .MigrateDataLabelingDatasetConfig.Builder
                  subBuilder = null;
              if (requestCase_ == 4) {
                subBuilder =
                    ((com.google.cloud.aiplatform.v1beta1.MigrateResourceRequest
                                .MigrateDataLabelingDatasetConfig)
                            request_)
                        .toBuilder();
              }
              request_ =
                  input.readMessage(
                      com.google.cloud.aiplatform.v1beta1.MigrateResourceRequest
                          .MigrateDataLabelingDatasetConfig.parser(),
                      extensionRegistry);
              if (subBuilder != null) {
                subBuilder.mergeFrom(
                    (com.google.cloud.aiplatform.v1beta1.MigrateResourceRequest
                            .MigrateDataLabelingDatasetConfig)
                        request_);
                request_ = subBuilder.buildPartial();
              }
              requestCase_ = 4;
              break;
            }
          default:
            {
              if (!parseUnknownField(input, unknownFields, extensionRegistry, tag)) {
                done = true;
              }
              break;
            }
        }
      }
    } catch (com.google.protobuf.InvalidProtocolBufferException e) {
      throw e.setUnfinishedMessage(this);
    } catch (java.io.IOException e) {
      throw new com.google.protobuf.InvalidProtocolBufferException(e).setUnfinishedMessage(this);
    } finally {
      this.unknownFields = unknownFields.build();
      makeExtensionsImmutable();
    }
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.cloud.aiplatform.v1beta1.MigrationServiceProto
        .internal_static_google_cloud_aiplatform_v1beta1_MigrateResourceRequest_descriptor;
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.cloud.aiplatform.v1beta1.MigrationServiceProto
        .internal_static_google_cloud_aiplatform_v1beta1_MigrateResourceRequest_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.cloud.aiplatform.v1beta1.MigrateResourceRequest.class,
            com.google.cloud.aiplatform.v1beta1.MigrateResourceRequest.Builder.class);
  }

  public interface MigrateMlEngineModelVersionConfigOrBuilder
      extends
      // @@protoc_insertion_point(interface_extends:google.cloud.aiplatform.v1beta1.MigrateResourceRequest.MigrateMlEngineModelVersionConfig)
      com.google.protobuf.MessageOrBuilder {

    /**
     *
     *
     * <pre>
     * Required. The ml.googleapis.com endpoint that this model version should be migrated
     * from.
     * Example values:
     * * ml.googleapis.com
     * * us-centrall-ml.googleapis.com
     * * europe-west4-ml.googleapis.com
     * * asia-east1-ml.googleapis.com
     * </pre>
     *
     * <code>string endpoint = 1 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return The endpoint.
     */
    java.lang.String getEndpoint();
    /**
     *
     *
     * <pre>
     * Required. The ml.googleapis.com endpoint that this model version should be migrated
     * from.
     * Example values:
     * * ml.googleapis.com
     * * us-centrall-ml.googleapis.com
     * * europe-west4-ml.googleapis.com
     * * asia-east1-ml.googleapis.com
     * </pre>
     *
     * <code>string endpoint = 1 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return The bytes for endpoint.
     */
    com.google.protobuf.ByteString getEndpointBytes();

    /**
     *
     *
     * <pre>
     * Required. Full resource name of ml engine model version.
     * Format: `projects/{project}/models/{model}/versions/{version}`.
     * </pre>
     *
     * <code>
     * string model_version = 2 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @return The modelVersion.
     */
    java.lang.String getModelVersion();
    /**
     *
     *
     * <pre>
     * Required. Full resource name of ml engine model version.
     * Format: `projects/{project}/models/{model}/versions/{version}`.
     * </pre>
     *
     * <code>
     * string model_version = 2 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @return The bytes for modelVersion.
     */
    com.google.protobuf.ByteString getModelVersionBytes();

    /**
     *
     *
     * <pre>
     * Required. Display name of the model in Vertex AI.
     * System will pick a display name if unspecified.
     * </pre>
     *
     * <code>string model_display_name = 3 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return The modelDisplayName.
     */
    java.lang.String getModelDisplayName();
    /**
     *
     *
     * <pre>
     * Required. Display name of the model in Vertex AI.
     * System will pick a display name if unspecified.
     * </pre>
     *
     * <code>string model_display_name = 3 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return The bytes for modelDisplayName.
     */
    com.google.protobuf.ByteString getModelDisplayNameBytes();
  }
  /**
   *
   *
   * <pre>
   * Config for migrating version in ml.googleapis.com to Vertex AI's Model.
   * </pre>
   *
   * Protobuf type {@code
   * google.cloud.aiplatform.v1beta1.MigrateResourceRequest.MigrateMlEngineModelVersionConfig}
   */
  public static final class MigrateMlEngineModelVersionConfig
      extends com.google.protobuf.GeneratedMessageV3
      implements
      // @@protoc_insertion_point(message_implements:google.cloud.aiplatform.v1beta1.MigrateResourceRequest.MigrateMlEngineModelVersionConfig)
      MigrateMlEngineModelVersionConfigOrBuilder {
    private static final long serialVersionUID = 0L;
    // Use MigrateMlEngineModelVersionConfig.newBuilder() to construct.
    private MigrateMlEngineModelVersionConfig(
        com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
      super(builder);
    }

    private MigrateMlEngineModelVersionConfig() {
      endpoint_ = "";
      modelVersion_ = "";
      modelDisplayName_ = "";
    }

    @java.lang.Override
    @SuppressWarnings({"unused"})
    protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
      return new MigrateMlEngineModelVersionConfig();
    }

    @java.lang.Override
    public final com.google.protobuf.UnknownFieldSet getUnknownFields() {
      return this.unknownFields;
    }

    private MigrateMlEngineModelVersionConfig(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      this();
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      com.google.protobuf.UnknownFieldSet.Builder unknownFields =
          com.google.protobuf.UnknownFieldSet.newBuilder();
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 10:
              {
                java.lang.String s = input.readStringRequireUtf8();

                endpoint_ = s;
                break;
              }
            case 18:
              {
                java.lang.String s = input.readStringRequireUtf8();

                modelVersion_ = s;
                break;
              }
            case 26:
              {
                java.lang.String s = input.readStringRequireUtf8();

                modelDisplayName_ = s;
                break;
              }
            default:
              {
                if (!parseUnknownField(input, unknownFields, extensionRegistry, tag)) {
                  done = true;
                }
                break;
              }
          }
        }
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.setUnfinishedMessage(this);
      } catch (java.io.IOException e) {
        throw new com.google.protobuf.InvalidProtocolBufferException(e).setUnfinishedMessage(this);
      } finally {
        this.unknownFields = unknownFields.build();
        makeExtensionsImmutable();
      }
    }

    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.aiplatform.v1beta1.MigrationServiceProto
          .internal_static_google_cloud_aiplatform_v1beta1_MigrateResourceRequest_MigrateMlEngineModelVersionConfig_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.aiplatform.v1beta1.MigrationServiceProto
          .internal_static_google_cloud_aiplatform_v1beta1_MigrateResourceRequest_MigrateMlEngineModelVersionConfig_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.aiplatform.v1beta1.MigrateResourceRequest
                  .MigrateMlEngineModelVersionConfig.class,
              com.google.cloud.aiplatform.v1beta1.MigrateResourceRequest
                  .MigrateMlEngineModelVersionConfig.Builder.class);
    }

    public static final int ENDPOINT_FIELD_NUMBER = 1;
    private volatile java.lang.Object endpoint_;
    /**
     *
     *
     * <pre>
     * Required. The ml.googleapis.com endpoint that this model version should be migrated
     * from.
     * Example values:
     * * ml.googleapis.com
     * * us-centrall-ml.googleapis.com
     * * europe-west4-ml.googleapis.com
     * * asia-east1-ml.googleapis.com
     * </pre>
     *
     * <code>string endpoint = 1 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return The endpoint.
     */
    @java.lang.Override
    public java.lang.String getEndpoint() {
      java.lang.Object ref = endpoint_;
      if (ref instanceof java.lang.String) {
        return (java.lang.String) ref;
      } else {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        endpoint_ = s;
        return s;
      }
    }
    /**
     *
     *
     * <pre>
     * Required. The ml.googleapis.com endpoint that this model version should be migrated
     * from.
     * Example values:
     * * ml.googleapis.com
     * * us-centrall-ml.googleapis.com
     * * europe-west4-ml.googleapis.com
     * * asia-east1-ml.googleapis.com
     * </pre>
     *
     * <code>string endpoint = 1 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return The bytes for endpoint.
     */
    @java.lang.Override
    public com.google.protobuf.ByteString getEndpointBytes() {
      java.lang.Object ref = endpoint_;
      if (ref instanceof java.lang.String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        endpoint_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    public static final int MODEL_VERSION_FIELD_NUMBER = 2;
    private volatile java.lang.Object modelVersion_;
    /**
     *
     *
     * <pre>
     * Required. Full resource name of ml engine model version.
     * Format: `projects/{project}/models/{model}/versions/{version}`.
     * </pre>
     *
     * <code>
     * string model_version = 2 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @return The modelVersion.
     */
    @java.lang.Override
    public java.lang.String getModelVersion() {
      java.lang.Object ref = modelVersion_;
      if (ref instanceof java.lang.String) {
        return (java.lang.String) ref;
      } else {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        modelVersion_ = s;
        return s;
      }
    }
    /**
     *
     *
     * <pre>
     * Required. Full resource name of ml engine model version.
     * Format: `projects/{project}/models/{model}/versions/{version}`.
     * </pre>
     *
     * <code>
     * string model_version = 2 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @return The bytes for modelVersion.
     */
    @java.lang.Override
    public com.google.protobuf.ByteString getModelVersionBytes() {
      java.lang.Object ref = modelVersion_;
      if (ref instanceof java.lang.String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        modelVersion_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    public static final int MODEL_DISPLAY_NAME_FIELD_NUMBER = 3;
    private volatile java.lang.Object modelDisplayName_;
    /**
     *
     *
     * <pre>
     * Required. Display name of the model in Vertex AI.
     * System will pick a display name if unspecified.
     * </pre>
     *
     * <code>string model_display_name = 3 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return The modelDisplayName.
     */
    @java.lang.Override
    public java.lang.String getModelDisplayName() {
      java.lang.Object ref = modelDisplayName_;
      if (ref instanceof java.lang.String) {
        return (java.lang.String) ref;
      } else {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        modelDisplayName_ = s;
        return s;
      }
    }
    /**
     *
     *
     * <pre>
     * Required. Display name of the model in Vertex AI.
     * System will pick a display name if unspecified.
     * </pre>
     *
     * <code>string model_display_name = 3 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return The bytes for modelDisplayName.
     */
    @java.lang.Override
    public com.google.protobuf.ByteString getModelDisplayNameBytes() {
      java.lang.Object ref = modelDisplayName_;
      if (ref instanceof java.lang.String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        modelDisplayName_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    private byte memoizedIsInitialized = -1;

    @java.lang.Override
    public final boolean isInitialized() {
      byte isInitialized = memoizedIsInitialized;
      if (isInitialized == 1) return true;
      if (isInitialized == 0) return false;

      memoizedIsInitialized = 1;
      return true;
    }

    @java.lang.Override
    public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
      if (!getEndpointBytes().isEmpty()) {
        com.google.protobuf.GeneratedMessageV3.writeString(output, 1, endpoint_);
      }
      if (!getModelVersionBytes().isEmpty()) {
        com.google.protobuf.GeneratedMessageV3.writeString(output, 2, modelVersion_);
      }
      if (!getModelDisplayNameBytes().isEmpty()) {
        com.google.protobuf.GeneratedMessageV3.writeString(output, 3, modelDisplayName_);
      }
      unknownFields.writeTo(output);
    }

    @java.lang.Override
    public int getSerializedSize() {
      int size = memoizedSize;
      if (size != -1) return size;

      size = 0;
      if (!getEndpointBytes().isEmpty()) {
        size += com.google.protobuf.GeneratedMessageV3.computeStringSize(1, endpoint_);
      }
      if (!getModelVersionBytes().isEmpty()) {
        size += com.google.protobuf.GeneratedMessageV3.computeStringSize(2, modelVersion_);
      }
      if (!getModelDisplayNameBytes().isEmpty()) {
        size += com.google.protobuf.GeneratedMessageV3.computeStringSize(3, modelDisplayName_);
      }
      size += unknownFields.getSerializedSize();
      memoizedSize = size;
      return size;
    }

    @java.lang.Override
    public boolean equals(final java.lang.Object obj) {
      if (obj == this) {
        return true;
      }
      if (!(obj
          instanceof
          com.google.cloud.aiplatform.v1beta1.MigrateResourceRequest
              .MigrateMlEngineModelVersionConfig)) {
        return super.equals(obj);
      }
      com.google.cloud.aiplatform.v1beta1.MigrateResourceRequest.MigrateMlEngineModelVersionConfig
          other =
              (com.google.cloud.aiplatform.v1beta1.MigrateResourceRequest
                      .MigrateMlEngineModelVersionConfig)
                  obj;

      if (!getEndpoint().equals(other.getEndpoint())) return false;
      if (!getModelVersion().equals(other.getModelVersion())) return false;
      if (!getModelDisplayName().equals(other.getModelDisplayName())) return false;
      if (!unknownFields.equals(other.unknownFields)) return false;
      return true;
    }

    @java.lang.Override
    public int hashCode() {
      if (memoizedHashCode != 0) {
        return memoizedHashCode;
      }
      int hash = 41;
      hash = (19 * hash) + getDescriptor().hashCode();
      hash = (37 * hash) + ENDPOINT_FIELD_NUMBER;
      hash = (53 * hash) + getEndpoint().hashCode();
      hash = (37 * hash) + MODEL_VERSION_FIELD_NUMBER;
      hash = (53 * hash) + getModelVersion().hashCode();
      hash = (37 * hash) + MODEL_DISPLAY_NAME_FIELD_NUMBER;
      hash = (53 * hash) + getModelDisplayName().hashCode();
      hash = (29 * hash) + unknownFields.hashCode();
      memoizedHashCode = hash;
      return hash;
    }

    public static com.google.cloud.aiplatform.v1beta1.MigrateResourceRequest
            .MigrateMlEngineModelVersionConfig
        parseFrom(java.nio.ByteBuffer data)
            throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.aiplatform.v1beta1.MigrateResourceRequest
            .MigrateMlEngineModelVersionConfig
        parseFrom(
            java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.aiplatform.v1beta1.MigrateResourceRequest
            .MigrateMlEngineModelVersionConfig
        parseFrom(com.google.protobuf.ByteString data)
            throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.aiplatform.v1beta1.MigrateResourceRequest
            .MigrateMlEngineModelVersionConfig
        parseFrom(
            com.google.protobuf.ByteString data,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.aiplatform.v1beta1.MigrateResourceRequest
            .MigrateMlEngineModelVersionConfig
        parseFrom(byte[] data) throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.aiplatform.v1beta1.MigrateResourceRequest
            .MigrateMlEngineModelVersionConfig
        parseFrom(byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.aiplatform.v1beta1.MigrateResourceRequest
            .MigrateMlEngineModelVersionConfig
        parseFrom(java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.cloud.aiplatform.v1beta1.MigrateResourceRequest
            .MigrateMlEngineModelVersionConfig
        parseFrom(
            java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.cloud.aiplatform.v1beta1.MigrateResourceRequest
            .MigrateMlEngineModelVersionConfig
        parseDelimitedFrom(java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
    }

    public static com.google.cloud.aiplatform.v1beta1.MigrateResourceRequest
            .MigrateMlEngineModelVersionConfig
        parseDelimitedFrom(
            java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.cloud.aiplatform.v1beta1.MigrateResourceRequest
            .MigrateMlEngineModelVersionConfig
        parseFrom(com.google.protobuf.CodedInputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.cloud.aiplatform.v1beta1.MigrateResourceRequest
            .MigrateMlEngineModelVersionConfig
        parseFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    @java.lang.Override
    public Builder newBuilderForType() {
      return newBuilder();
    }

    public static Builder newBuilder() {
      return DEFAULT_INSTANCE.toBuilder();
    }

    public static Builder newBuilder(
        com.google.cloud.aiplatform.v1beta1.MigrateResourceRequest.MigrateMlEngineModelVersionConfig
            prototype) {
      return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }

    @java.lang.Override
    public Builder toBuilder() {
      return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
    }

    @java.lang.Override
    protected Builder newBuilderForType(
        com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      Builder builder = new Builder(parent);
      return builder;
    }
    /**
     *
     *
     * <pre>
     * Config for migrating version in ml.googleapis.com to Vertex AI's Model.
     * </pre>
     *
     * Protobuf type {@code
     * google.cloud.aiplatform.v1beta1.MigrateResourceRequest.MigrateMlEngineModelVersionConfig}
     */
    public static final class Builder
        extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
        implements
        // @@protoc_insertion_point(builder_implements:google.cloud.aiplatform.v1beta1.MigrateResourceRequest.MigrateMlEngineModelVersionConfig)
        com.google.cloud.aiplatform.v1beta1.MigrateResourceRequest
            .MigrateMlEngineModelVersionConfigOrBuilder {
      public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
        return com.google.cloud.aiplatform.v1beta1.MigrationServiceProto
            .internal_static_google_cloud_aiplatform_v1beta1_MigrateResourceRequest_MigrateMlEngineModelVersionConfig_descriptor;
      }

      @java.lang.Override
      protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return com.google.cloud.aiplatform.v1beta1.MigrationServiceProto
            .internal_static_google_cloud_aiplatform_v1beta1_MigrateResourceRequest_MigrateMlEngineModelVersionConfig_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                com.google.cloud.aiplatform.v1beta1.MigrateResourceRequest
                    .MigrateMlEngineModelVersionConfig.class,
                com.google.cloud.aiplatform.v1beta1.MigrateResourceRequest
                    .MigrateMlEngineModelVersionConfig.Builder.class);
      }

      // Construct using
      // com.google.cloud.aiplatform.v1beta1.MigrateResourceRequest.MigrateMlEngineModelVersionConfig.newBuilder()
      private Builder() {
        maybeForceBuilderInitialization();
      }

      private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
        super(parent);
        maybeForceBuilderInitialization();
      }

      private void maybeForceBuilderInitialization() {
        if (com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders) {}
      }

      @java.lang.Override
      public Builder clear() {
        super.clear();
        endpoint_ = "";

        modelVersion_ = "";

        modelDisplayName_ = "";

        return this;
      }

      @java.lang.Override
      public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
        return com.google.cloud.aiplatform.v1beta1.MigrationServiceProto
            .internal_static_google_cloud_aiplatform_v1beta1_MigrateResourceRequest_MigrateMlEngineModelVersionConfig_descriptor;
      }

      @java.lang.Override
      public com.google.cloud.aiplatform.v1beta1.MigrateResourceRequest
              .MigrateMlEngineModelVersionConfig
          getDefaultInstanceForType() {
        return com.google.cloud.aiplatform.v1beta1.MigrateResourceRequest
            .MigrateMlEngineModelVersionConfig.getDefaultInstance();
      }

      @java.lang.Override
      public com.google.cloud.aiplatform.v1beta1.MigrateResourceRequest
              .MigrateMlEngineModelVersionConfig
          build() {
        com.google.cloud.aiplatform.v1beta1.MigrateResourceRequest.MigrateMlEngineModelVersionConfig
            result = buildPartial();
        if (!result.isInitialized()) {
          throw newUninitializedMessageException(result);
        }
        return result;
      }

      @java.lang.Override
      public com.google.cloud.aiplatform.v1beta1.MigrateResourceRequest
              .MigrateMlEngineModelVersionConfig
          buildPartial() {
        com.google.cloud.aiplatform.v1beta1.MigrateResourceRequest.MigrateMlEngineModelVersionConfig
            result =
                new com.google.cloud.aiplatform.v1beta1.MigrateResourceRequest
                    .MigrateMlEngineModelVersionConfig(this);
        result.endpoint_ = endpoint_;
        result.modelVersion_ = modelVersion_;
        result.modelDisplayName_ = modelDisplayName_;
        onBuilt();
        return result;
      }

      @java.lang.Override
      public Builder clone() {
        return super.clone();
      }

      @java.lang.Override
      public Builder setField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.setField(field, value);
      }

      @java.lang.Override
      public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
        return super.clearField(field);
      }

      @java.lang.Override
      public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
        return super.clearOneof(oneof);
      }

      @java.lang.Override
      public Builder setRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          int index,
          java.lang.Object value) {
        return super.setRepeatedField(field, index, value);
      }

      @java.lang.Override
      public Builder addRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.addRepeatedField(field, value);
      }

      @java.lang.Override
      public Builder mergeFrom(com.google.protobuf.Message other) {
        if (other
            instanceof
            com.google.cloud.aiplatform.v1beta1.MigrateResourceRequest
                .MigrateMlEngineModelVersionConfig) {
          return mergeFrom(
              (com.google.cloud.aiplatform.v1beta1.MigrateResourceRequest
                      .MigrateMlEngineModelVersionConfig)
                  other);
        } else {
          super.mergeFrom(other);
          return this;
        }
      }

      public Builder mergeFrom(
          com.google.cloud.aiplatform.v1beta1.MigrateResourceRequest
                  .MigrateMlEngineModelVersionConfig
              other) {
        if (other
            == com.google.cloud.aiplatform.v1beta1.MigrateResourceRequest
                .MigrateMlEngineModelVersionConfig.getDefaultInstance()) return this;
        if (!other.getEndpoint().isEmpty()) {
          endpoint_ = other.endpoint_;
          onChanged();
        }
        if (!other.getModelVersion().isEmpty()) {
          modelVersion_ = other.modelVersion_;
          onChanged();
        }
        if (!other.getModelDisplayName().isEmpty()) {
          modelDisplayName_ = other.modelDisplayName_;
          onChanged();
        }
        this.mergeUnknownFields(other.unknownFields);
        onChanged();
        return this;
      }

      @java.lang.Override
      public final boolean isInitialized() {
        return true;
      }

      @java.lang.Override
      public Builder mergeFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        com.google.cloud.aiplatform.v1beta1.MigrateResourceRequest.MigrateMlEngineModelVersionConfig
            parsedMessage = null;
        try {
          parsedMessage = PARSER.parsePartialFrom(input, extensionRegistry);
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          parsedMessage =
              (com.google.cloud.aiplatform.v1beta1.MigrateResourceRequest
                      .MigrateMlEngineModelVersionConfig)
                  e.getUnfinishedMessage();
          throw e.unwrapIOException();
        } finally {
          if (parsedMessage != null) {
            mergeFrom(parsedMessage);
          }
        }
        return this;
      }

      private java.lang.Object endpoint_ = "";
      /**
       *
       *
       * <pre>
       * Required. The ml.googleapis.com endpoint that this model version should be migrated
       * from.
       * Example values:
       * * ml.googleapis.com
       * * us-centrall-ml.googleapis.com
       * * europe-west4-ml.googleapis.com
       * * asia-east1-ml.googleapis.com
       * </pre>
       *
       * <code>string endpoint = 1 [(.google.api.field_behavior) = REQUIRED];</code>
       *
       * @return The endpoint.
       */
      public java.lang.String getEndpoint() {
        java.lang.Object ref = endpoint_;
        if (!(ref instanceof java.lang.String)) {
          com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
          java.lang.String s = bs.toStringUtf8();
          endpoint_ = s;
          return s;
        } else {
          return (java.lang.String) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * Required. The ml.googleapis.com endpoint that this model version should be migrated
       * from.
       * Example values:
       * * ml.googleapis.com
       * * us-centrall-ml.googleapis.com
       * * europe-west4-ml.googleapis.com
       * * asia-east1-ml.googleapis.com
       * </pre>
       *
       * <code>string endpoint = 1 [(.google.api.field_behavior) = REQUIRED];</code>
       *
       * @return The bytes for endpoint.
       */
      public com.google.protobuf.ByteString getEndpointBytes() {
        java.lang.Object ref = endpoint_;
        if (ref instanceof String) {
          com.google.protobuf.ByteString b =
              com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
          endpoint_ = b;
          return b;
        } else {
          return (com.google.protobuf.ByteString) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * Required. The ml.googleapis.com endpoint that this model version should be migrated
       * from.
       * Example values:
       * * ml.googleapis.com
       * * us-centrall-ml.googleapis.com
       * * europe-west4-ml.googleapis.com
       * * asia-east1-ml.googleapis.com
       * </pre>
       *
       * <code>string endpoint = 1 [(.google.api.field_behavior) = REQUIRED];</code>
       *
       * @param value The endpoint to set.
       * @return This builder for chaining.
       */
      public Builder setEndpoint(java.lang.String value) {
        if (value == null) {
          throw new NullPointerException();
        }

        endpoint_ = value;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Required. The ml.googleapis.com endpoint that this model version should be migrated
       * from.
       * Example values:
       * * ml.googleapis.com
       * * us-centrall-ml.googleapis.com
       * * europe-west4-ml.googleapis.com
       * * asia-east1-ml.googleapis.com
       * </pre>
       *
       * <code>string endpoint = 1 [(.google.api.field_behavior) = REQUIRED];</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearEndpoint() {

        endpoint_ = getDefaultInstance().getEndpoint();
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Required. The ml.googleapis.com endpoint that this model version should be migrated
       * from.
       * Example values:
       * * ml.googleapis.com
       * * us-centrall-ml.googleapis.com
       * * europe-west4-ml.googleapis.com
       * * asia-east1-ml.googleapis.com
       * </pre>
       *
       * <code>string endpoint = 1 [(.google.api.field_behavior) = REQUIRED];</code>
       *
       * @param value The bytes for endpoint to set.
       * @return This builder for chaining.
       */
      public Builder setEndpointBytes(com.google.protobuf.ByteString value) {
        if (value == null) {
          throw new NullPointerException();
        }
        checkByteStringIsUtf8(value);

        endpoint_ = value;
        onChanged();
        return this;
      }

      private java.lang.Object modelVersion_ = "";
      /**
       *
       *
       * <pre>
       * Required. Full resource name of ml engine model version.
       * Format: `projects/{project}/models/{model}/versions/{version}`.
       * </pre>
       *
       * <code>
       * string model_version = 2 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
       * </code>
       *
       * @return The modelVersion.
       */
      public java.lang.String getModelVersion() {
        java.lang.Object ref = modelVersion_;
        if (!(ref instanceof java.lang.String)) {
          com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
          java.lang.String s = bs.toStringUtf8();
          modelVersion_ = s;
          return s;
        } else {
          return (java.lang.String) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * Required. Full resource name of ml engine model version.
       * Format: `projects/{project}/models/{model}/versions/{version}`.
       * </pre>
       *
       * <code>
       * string model_version = 2 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
       * </code>
       *
       * @return The bytes for modelVersion.
       */
      public com.google.protobuf.ByteString getModelVersionBytes() {
        java.lang.Object ref = modelVersion_;
        if (ref instanceof String) {
          com.google.protobuf.ByteString b =
              com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
          modelVersion_ = b;
          return b;
        } else {
          return (com.google.protobuf.ByteString) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * Required. Full resource name of ml engine model version.
       * Format: `projects/{project}/models/{model}/versions/{version}`.
       * </pre>
       *
       * <code>
       * string model_version = 2 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
       * </code>
       *
       * @param value The modelVersion to set.
       * @return This builder for chaining.
       */
      public Builder setModelVersion(java.lang.String value) {
        if (value == null) {
          throw new NullPointerException();
        }

        modelVersion_ = value;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Required. Full resource name of ml engine model version.
       * Format: `projects/{project}/models/{model}/versions/{version}`.
       * </pre>
       *
       * <code>
       * string model_version = 2 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
       * </code>
       *
       * @return This builder for chaining.
       */
      public Builder clearModelVersion() {

        modelVersion_ = getDefaultInstance().getModelVersion();
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Required. Full resource name of ml engine model version.
       * Format: `projects/{project}/models/{model}/versions/{version}`.
       * </pre>
       *
       * <code>
       * string model_version = 2 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
       * </code>
       *
       * @param value The bytes for modelVersion to set.
       * @return This builder for chaining.
       */
      public Builder setModelVersionBytes(com.google.protobuf.ByteString value) {
        if (value == null) {
          throw new NullPointerException();
        }
        checkByteStringIsUtf8(value);

        modelVersion_ = value;
        onChanged();
        return this;
      }

      private java.lang.Object modelDisplayName_ = "";
      /**
       *
       *
       * <pre>
       * Required. Display name of the model in Vertex AI.
       * System will pick a display name if unspecified.
       * </pre>
       *
       * <code>string model_display_name = 3 [(.google.api.field_behavior) = REQUIRED];</code>
       *
       * @return The modelDisplayName.
       */
      public java.lang.String getModelDisplayName() {
        java.lang.Object ref = modelDisplayName_;
        if (!(ref instanceof java.lang.String)) {
          com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
          java.lang.String s = bs.toStringUtf8();
          modelDisplayName_ = s;
          return s;
        } else {
          return (java.lang.String) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * Required. Display name of the model in Vertex AI.
       * System will pick a display name if unspecified.
       * </pre>
       *
       * <code>string model_display_name = 3 [(.google.api.field_behavior) = REQUIRED];</code>
       *
       * @return The bytes for modelDisplayName.
       */
      public com.google.protobuf.ByteString getModelDisplayNameBytes() {
        java.lang.Object ref = modelDisplayName_;
        if (ref instanceof String) {
          com.google.protobuf.ByteString b =
              com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
          modelDisplayName_ = b;
          return b;
        } else {
          return (com.google.protobuf.ByteString) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * Required. Display name of the model in Vertex AI.
       * System will pick a display name if unspecified.
       * </pre>
       *
       * <code>string model_display_name = 3 [(.google.api.field_behavior) = REQUIRED];</code>
       *
       * @param value The modelDisplayName to set.
       * @return This builder for chaining.
       */
      public Builder setModelDisplayName(java.lang.String value) {
        if (value == null) {
          throw new NullPointerException();
        }

        modelDisplayName_ = value;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Required. Display name of the model in Vertex AI.
       * System will pick a display name if unspecified.
       * </pre>
       *
       * <code>string model_display_name = 3 [(.google.api.field_behavior) = REQUIRED];</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearModelDisplayName() {

        modelDisplayName_ = getDefaultInstance().getModelDisplayName();
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Required. Display name of the model in Vertex AI.
       * System will pick a display name if unspecified.
       * </pre>
       *
       * <code>string model_display_name = 3 [(.google.api.field_behavior) = REQUIRED];</code>
       *
       * @param value The bytes for modelDisplayName to set.
       * @return This builder for chaining.
       */
      public Builder setModelDisplayNameBytes(com.google.protobuf.ByteString value) {
        if (value == null) {
          throw new NullPointerException();
        }
        checkByteStringIsUtf8(value);

        modelDisplayName_ = value;
        onChanged();
        return this;
      }

      @java.lang.Override
      public final Builder setUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.setUnknownFields(unknownFields);
      }

      @java.lang.Override
      public final Builder mergeUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.mergeUnknownFields(unknownFields);
      }

      // @@protoc_insertion_point(builder_scope:google.cloud.aiplatform.v1beta1.MigrateResourceRequest.MigrateMlEngineModelVersionConfig)
    }

    // @@protoc_insertion_point(class_scope:google.cloud.aiplatform.v1beta1.MigrateResourceRequest.MigrateMlEngineModelVersionConfig)
    private static final com.google.cloud.aiplatform.v1beta1.MigrateResourceRequest
            .MigrateMlEngineModelVersionConfig
        DEFAULT_INSTANCE;

    static {
      DEFAULT_INSTANCE =
          new com.google.cloud.aiplatform.v1beta1.MigrateResourceRequest
              .MigrateMlEngineModelVersionConfig();
    }

    public static com.google.cloud.aiplatform.v1beta1.MigrateResourceRequest
            .MigrateMlEngineModelVersionConfig
        getDefaultInstance() {
      return DEFAULT_INSTANCE;
    }

    private static final com.google.protobuf.Parser<MigrateMlEngineModelVersionConfig> PARSER =
        new com.google.protobuf.AbstractParser<MigrateMlEngineModelVersionConfig>() {
          @java.lang.Override
          public MigrateMlEngineModelVersionConfig parsePartialFrom(
              com.google.protobuf.CodedInputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
            return new MigrateMlEngineModelVersionConfig(input, extensionRegistry);
          }
        };

    public static com.google.protobuf.Parser<MigrateMlEngineModelVersionConfig> parser() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.protobuf.Parser<MigrateMlEngineModelVersionConfig> getParserForType() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.cloud.aiplatform.v1beta1.MigrateResourceRequest
            .MigrateMlEngineModelVersionConfig
        getDefaultInstanceForType() {
      return DEFAULT_INSTANCE;
    }
  }

  public interface MigrateAutomlModelConfigOrBuilder
      extends
      // @@protoc_insertion_point(interface_extends:google.cloud.aiplatform.v1beta1.MigrateResourceRequest.MigrateAutomlModelConfig)
      com.google.protobuf.MessageOrBuilder {

    /**
     *
     *
     * <pre>
     * Required. Full resource name of automl Model.
     * Format:
     * `projects/{project}/locations/{location}/models/{model}`.
     * </pre>
     *
     * <code>
     * string model = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @return The model.
     */
    java.lang.String getModel();
    /**
     *
     *
     * <pre>
     * Required. Full resource name of automl Model.
     * Format:
     * `projects/{project}/locations/{location}/models/{model}`.
     * </pre>
     *
     * <code>
     * string model = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @return The bytes for model.
     */
    com.google.protobuf.ByteString getModelBytes();

    /**
     *
     *
     * <pre>
     * Optional. Display name of the model in Vertex AI.
     * System will pick a display name if unspecified.
     * </pre>
     *
     * <code>string model_display_name = 2 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return The modelDisplayName.
     */
    java.lang.String getModelDisplayName();
    /**
     *
     *
     * <pre>
     * Optional. Display name of the model in Vertex AI.
     * System will pick a display name if unspecified.
     * </pre>
     *
     * <code>string model_display_name = 2 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return The bytes for modelDisplayName.
     */
    com.google.protobuf.ByteString getModelDisplayNameBytes();
  }
  /**
   *
   *
   * <pre>
   * Config for migrating Model in automl.googleapis.com to Vertex AI's Model.
   * </pre>
   *
   * Protobuf type {@code
   * google.cloud.aiplatform.v1beta1.MigrateResourceRequest.MigrateAutomlModelConfig}
   */
  public static final class MigrateAutomlModelConfig extends com.google.protobuf.GeneratedMessageV3
      implements
      // @@protoc_insertion_point(message_implements:google.cloud.aiplatform.v1beta1.MigrateResourceRequest.MigrateAutomlModelConfig)
      MigrateAutomlModelConfigOrBuilder {
    private static final long serialVersionUID = 0L;
    // Use MigrateAutomlModelConfig.newBuilder() to construct.
    private MigrateAutomlModelConfig(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
      super(builder);
    }

    private MigrateAutomlModelConfig() {
      model_ = "";
      modelDisplayName_ = "";
    }

    @java.lang.Override
    @SuppressWarnings({"unused"})
    protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
      return new MigrateAutomlModelConfig();
    }

    @java.lang.Override
    public final com.google.protobuf.UnknownFieldSet getUnknownFields() {
      return this.unknownFields;
    }

    private MigrateAutomlModelConfig(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      this();
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      com.google.protobuf.UnknownFieldSet.Builder unknownFields =
          com.google.protobuf.UnknownFieldSet.newBuilder();
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 10:
              {
                java.lang.String s = input.readStringRequireUtf8();

                model_ = s;
                break;
              }
            case 18:
              {
                java.lang.String s = input.readStringRequireUtf8();

                modelDisplayName_ = s;
                break;
              }
            default:
              {
                if (!parseUnknownField(input, unknownFields, extensionRegistry, tag)) {
                  done = true;
                }
                break;
              }
          }
        }
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.setUnfinishedMessage(this);
      } catch (java.io.IOException e) {
        throw new com.google.protobuf.InvalidProtocolBufferException(e).setUnfinishedMessage(this);
      } finally {
        this.unknownFields = unknownFields.build();
        makeExtensionsImmutable();
      }
    }

    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.aiplatform.v1beta1.MigrationServiceProto
          .internal_static_google_cloud_aiplatform_v1beta1_MigrateResourceRequest_MigrateAutomlModelConfig_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.aiplatform.v1beta1.MigrationServiceProto
          .internal_static_google_cloud_aiplatform_v1beta1_MigrateResourceRequest_MigrateAutomlModelConfig_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.aiplatform.v1beta1.MigrateResourceRequest.MigrateAutomlModelConfig
                  .class,
              com.google.cloud.aiplatform.v1beta1.MigrateResourceRequest.MigrateAutomlModelConfig
                  .Builder.class);
    }

    public static final int MODEL_FIELD_NUMBER = 1;
    private volatile java.lang.Object model_;
    /**
     *
     *
     * <pre>
     * Required. Full resource name of automl Model.
     * Format:
     * `projects/{project}/locations/{location}/models/{model}`.
     * </pre>
     *
     * <code>
     * string model = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @return The model.
     */
    @java.lang.Override
    public java.lang.String getModel() {
      java.lang.Object ref = model_;
      if (ref instanceof java.lang.String) {
        return (java.lang.String) ref;
      } else {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        model_ = s;
        return s;
      }
    }
    /**
     *
     *
     * <pre>
     * Required. Full resource name of automl Model.
     * Format:
     * `projects/{project}/locations/{location}/models/{model}`.
     * </pre>
     *
     * <code>
     * string model = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @return The bytes for model.
     */
    @java.lang.Override
    public com.google.protobuf.ByteString getModelBytes() {
      java.lang.Object ref = model_;
      if (ref instanceof java.lang.String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        model_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    public static final int MODEL_DISPLAY_NAME_FIELD_NUMBER = 2;
    private volatile java.lang.Object modelDisplayName_;
    /**
     *
     *
     * <pre>
     * Optional. Display name of the model in Vertex AI.
     * System will pick a display name if unspecified.
     * </pre>
     *
     * <code>string model_display_name = 2 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return The modelDisplayName.
     */
    @java.lang.Override
    public java.lang.String getModelDisplayName() {
      java.lang.Object ref = modelDisplayName_;
      if (ref instanceof java.lang.String) {
        return (java.lang.String) ref;
      } else {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        modelDisplayName_ = s;
        return s;
      }
    }
    /**
     *
     *
     * <pre>
     * Optional. Display name of the model in Vertex AI.
     * System will pick a display name if unspecified.
     * </pre>
     *
     * <code>string model_display_name = 2 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return The bytes for modelDisplayName.
     */
    @java.lang.Override
    public com.google.protobuf.ByteString getModelDisplayNameBytes() {
      java.lang.Object ref = modelDisplayName_;
      if (ref instanceof java.lang.String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        modelDisplayName_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    private byte memoizedIsInitialized = -1;

    @java.lang.Override
    public final boolean isInitialized() {
      byte isInitialized = memoizedIsInitialized;
      if (isInitialized == 1) return true;
      if (isInitialized == 0) return false;

      memoizedIsInitialized = 1;
      return true;
    }

    @java.lang.Override
    public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
      if (!getModelBytes().isEmpty()) {
        com.google.protobuf.GeneratedMessageV3.writeString(output, 1, model_);
      }
      if (!getModelDisplayNameBytes().isEmpty()) {
        com.google.protobuf.GeneratedMessageV3.writeString(output, 2, modelDisplayName_);
      }
      unknownFields.writeTo(output);
    }

    @java.lang.Override
    public int getSerializedSize() {
      int size = memoizedSize;
      if (size != -1) return size;

      size = 0;
      if (!getModelBytes().isEmpty()) {
        size += com.google.protobuf.GeneratedMessageV3.computeStringSize(1, model_);
      }
      if (!getModelDisplayNameBytes().isEmpty()) {
        size += com.google.protobuf.GeneratedMessageV3.computeStringSize(2, modelDisplayName_);
      }
      size += unknownFields.getSerializedSize();
      memoizedSize = size;
      return size;
    }

    @java.lang.Override
    public boolean equals(final java.lang.Object obj) {
      if (obj == this) {
        return true;
      }
      if (!(obj
          instanceof
          com.google.cloud.aiplatform.v1beta1.MigrateResourceRequest.MigrateAutomlModelConfig)) {
        return super.equals(obj);
      }
      com.google.cloud.aiplatform.v1beta1.MigrateResourceRequest.MigrateAutomlModelConfig other =
          (com.google.cloud.aiplatform.v1beta1.MigrateResourceRequest.MigrateAutomlModelConfig) obj;

      if (!getModel().equals(other.getModel())) return false;
      if (!getModelDisplayName().equals(other.getModelDisplayName())) return false;
      if (!unknownFields.equals(other.unknownFields)) return false;
      return true;
    }

    @java.lang.Override
    public int hashCode() {
      if (memoizedHashCode != 0) {
        return memoizedHashCode;
      }
      int hash = 41;
      hash = (19 * hash) + getDescriptor().hashCode();
      hash = (37 * hash) + MODEL_FIELD_NUMBER;
      hash = (53 * hash) + getModel().hashCode();
      hash = (37 * hash) + MODEL_DISPLAY_NAME_FIELD_NUMBER;
      hash = (53 * hash) + getModelDisplayName().hashCode();
      hash = (29 * hash) + unknownFields.hashCode();
      memoizedHashCode = hash;
      return hash;
    }

    public static com.google.cloud.aiplatform.v1beta1.MigrateResourceRequest
            .MigrateAutomlModelConfig
        parseFrom(java.nio.ByteBuffer data)
            throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.aiplatform.v1beta1.MigrateResourceRequest
            .MigrateAutomlModelConfig
        parseFrom(
            java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.aiplatform.v1beta1.MigrateResourceRequest
            .MigrateAutomlModelConfig
        parseFrom(com.google.protobuf.ByteString data)
            throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.aiplatform.v1beta1.MigrateResourceRequest
            .MigrateAutomlModelConfig
        parseFrom(
            com.google.protobuf.ByteString data,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.aiplatform.v1beta1.MigrateResourceRequest
            .MigrateAutomlModelConfig
        parseFrom(byte[] data) throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.aiplatform.v1beta1.MigrateResourceRequest
            .MigrateAutomlModelConfig
        parseFrom(byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.aiplatform.v1beta1.MigrateResourceRequest
            .MigrateAutomlModelConfig
        parseFrom(java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.cloud.aiplatform.v1beta1.MigrateResourceRequest
            .MigrateAutomlModelConfig
        parseFrom(
            java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.cloud.aiplatform.v1beta1.MigrateResourceRequest
            .MigrateAutomlModelConfig
        parseDelimitedFrom(java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
    }

    public static com.google.cloud.aiplatform.v1beta1.MigrateResourceRequest
            .MigrateAutomlModelConfig
        parseDelimitedFrom(
            java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.cloud.aiplatform.v1beta1.MigrateResourceRequest
            .MigrateAutomlModelConfig
        parseFrom(com.google.protobuf.CodedInputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.cloud.aiplatform.v1beta1.MigrateResourceRequest
            .MigrateAutomlModelConfig
        parseFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    @java.lang.Override
    public Builder newBuilderForType() {
      return newBuilder();
    }

    public static Builder newBuilder() {
      return DEFAULT_INSTANCE.toBuilder();
    }

    public static Builder newBuilder(
        com.google.cloud.aiplatform.v1beta1.MigrateResourceRequest.MigrateAutomlModelConfig
            prototype) {
      return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }

    @java.lang.Override
    public Builder toBuilder() {
      return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
    }

    @java.lang.Override
    protected Builder newBuilderForType(
        com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      Builder builder = new Builder(parent);
      return builder;
    }
    /**
     *
     *
     * <pre>
     * Config for migrating Model in automl.googleapis.com to Vertex AI's Model.
     * </pre>
     *
     * Protobuf type {@code
     * google.cloud.aiplatform.v1beta1.MigrateResourceRequest.MigrateAutomlModelConfig}
     */
    public static final class Builder
        extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
        implements
        // @@protoc_insertion_point(builder_implements:google.cloud.aiplatform.v1beta1.MigrateResourceRequest.MigrateAutomlModelConfig)
        com.google.cloud.aiplatform.v1beta1.MigrateResourceRequest
            .MigrateAutomlModelConfigOrBuilder {
      public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
        return com.google.cloud.aiplatform.v1beta1.MigrationServiceProto
            .internal_static_google_cloud_aiplatform_v1beta1_MigrateResourceRequest_MigrateAutomlModelConfig_descriptor;
      }

      @java.lang.Override
      protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return com.google.cloud.aiplatform.v1beta1.MigrationServiceProto
            .internal_static_google_cloud_aiplatform_v1beta1_MigrateResourceRequest_MigrateAutomlModelConfig_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                com.google.cloud.aiplatform.v1beta1.MigrateResourceRequest.MigrateAutomlModelConfig
                    .class,
                com.google.cloud.aiplatform.v1beta1.MigrateResourceRequest.MigrateAutomlModelConfig
                    .Builder.class);
      }

      // Construct using
      // com.google.cloud.aiplatform.v1beta1.MigrateResourceRequest.MigrateAutomlModelConfig.newBuilder()
      private Builder() {
        maybeForceBuilderInitialization();
      }

      private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
        super(parent);
        maybeForceBuilderInitialization();
      }

      private void maybeForceBuilderInitialization() {
        if (com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders) {}
      }

      @java.lang.Override
      public Builder clear() {
        super.clear();
        model_ = "";

        modelDisplayName_ = "";

        return this;
      }

      @java.lang.Override
      public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
        return com.google.cloud.aiplatform.v1beta1.MigrationServiceProto
            .internal_static_google_cloud_aiplatform_v1beta1_MigrateResourceRequest_MigrateAutomlModelConfig_descriptor;
      }

      @java.lang.Override
      public com.google.cloud.aiplatform.v1beta1.MigrateResourceRequest.MigrateAutomlModelConfig
          getDefaultInstanceForType() {
        return com.google.cloud.aiplatform.v1beta1.MigrateResourceRequest.MigrateAutomlModelConfig
            .getDefaultInstance();
      }

      @java.lang.Override
      public com.google.cloud.aiplatform.v1beta1.MigrateResourceRequest.MigrateAutomlModelConfig
          build() {
        com.google.cloud.aiplatform.v1beta1.MigrateResourceRequest.MigrateAutomlModelConfig result =
            buildPartial();
        if (!result.isInitialized()) {
          throw newUninitializedMessageException(result);
        }
        return result;
      }

      @java.lang.Override
      public com.google.cloud.aiplatform.v1beta1.MigrateResourceRequest.MigrateAutomlModelConfig
          buildPartial() {
        com.google.cloud.aiplatform.v1beta1.MigrateResourceRequest.MigrateAutomlModelConfig result =
            new com.google.cloud.aiplatform.v1beta1.MigrateResourceRequest.MigrateAutomlModelConfig(
                this);
        result.model_ = model_;
        result.modelDisplayName_ = modelDisplayName_;
        onBuilt();
        return result;
      }

      @java.lang.Override
      public Builder clone() {
        return super.clone();
      }

      @java.lang.Override
      public Builder setField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.setField(field, value);
      }

      @java.lang.Override
      public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
        return super.clearField(field);
      }

      @java.lang.Override
      public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
        return super.clearOneof(oneof);
      }

      @java.lang.Override
      public Builder setRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          int index,
          java.lang.Object value) {
        return super.setRepeatedField(field, index, value);
      }

      @java.lang.Override
      public Builder addRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.addRepeatedField(field, value);
      }

      @java.lang.Override
      public Builder mergeFrom(com.google.protobuf.Message other) {
        if (other
            instanceof
            com.google.cloud.aiplatform.v1beta1.MigrateResourceRequest.MigrateAutomlModelConfig) {
          return mergeFrom(
              (com.google.cloud.aiplatform.v1beta1.MigrateResourceRequest.MigrateAutomlModelConfig)
                  other);
        } else {
          super.mergeFrom(other);
          return this;
        }
      }

      public Builder mergeFrom(
          com.google.cloud.aiplatform.v1beta1.MigrateResourceRequest.MigrateAutomlModelConfig
              other) {
        if (other
            == com.google.cloud.aiplatform.v1beta1.MigrateResourceRequest.MigrateAutomlModelConfig
                .getDefaultInstance()) return this;
        if (!other.getModel().isEmpty()) {
          model_ = other.model_;
          onChanged();
        }
        if (!other.getModelDisplayName().isEmpty()) {
          modelDisplayName_ = other.modelDisplayName_;
          onChanged();
        }
        this.mergeUnknownFields(other.unknownFields);
        onChanged();
        return this;
      }

      @java.lang.Override
      public final boolean isInitialized() {
        return true;
      }

      @java.lang.Override
      public Builder mergeFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        com.google.cloud.aiplatform.v1beta1.MigrateResourceRequest.MigrateAutomlModelConfig
            parsedMessage = null;
        try {
          parsedMessage = PARSER.parsePartialFrom(input, extensionRegistry);
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          parsedMessage =
              (com.google.cloud.aiplatform.v1beta1.MigrateResourceRequest.MigrateAutomlModelConfig)
                  e.getUnfinishedMessage();
          throw e.unwrapIOException();
        } finally {
          if (parsedMessage != null) {
            mergeFrom(parsedMessage);
          }
        }
        return this;
      }

      private java.lang.Object model_ = "";
      /**
       *
       *
       * <pre>
       * Required. Full resource name of automl Model.
       * Format:
       * `projects/{project}/locations/{location}/models/{model}`.
       * </pre>
       *
       * <code>
       * string model = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
       * </code>
       *
       * @return The model.
       */
      public java.lang.String getModel() {
        java.lang.Object ref = model_;
        if (!(ref instanceof java.lang.String)) {
          com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
          java.lang.String s = bs.toStringUtf8();
          model_ = s;
          return s;
        } else {
          return (java.lang.String) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * Required. Full resource name of automl Model.
       * Format:
       * `projects/{project}/locations/{location}/models/{model}`.
       * </pre>
       *
       * <code>
       * string model = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
       * </code>
       *
       * @return The bytes for model.
       */
      public com.google.protobuf.ByteString getModelBytes() {
        java.lang.Object ref = model_;
        if (ref instanceof String) {
          com.google.protobuf.ByteString b =
              com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
          model_ = b;
          return b;
        } else {
          return (com.google.protobuf.ByteString) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * Required. Full resource name of automl Model.
       * Format:
       * `projects/{project}/locations/{location}/models/{model}`.
       * </pre>
       *
       * <code>
       * string model = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
       * </code>
       *
       * @param value The model to set.
       * @return This builder for chaining.
       */
      public Builder setModel(java.lang.String value) {
        if (value == null) {
          throw new NullPointerException();
        }

        model_ = value;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Required. Full resource name of automl Model.
       * Format:
       * `projects/{project}/locations/{location}/models/{model}`.
       * </pre>
       *
       * <code>
       * string model = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
       * </code>
       *
       * @return This builder for chaining.
       */
      public Builder clearModel() {

        model_ = getDefaultInstance().getModel();
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Required. Full resource name of automl Model.
       * Format:
       * `projects/{project}/locations/{location}/models/{model}`.
       * </pre>
       *
       * <code>
       * string model = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
       * </code>
       *
       * @param value The bytes for model to set.
       * @return This builder for chaining.
       */
      public Builder setModelBytes(com.google.protobuf.ByteString value) {
        if (value == null) {
          throw new NullPointerException();
        }
        checkByteStringIsUtf8(value);

        model_ = value;
        onChanged();
        return this;
      }

      private java.lang.Object modelDisplayName_ = "";
      /**
       *
       *
       * <pre>
       * Optional. Display name of the model in Vertex AI.
       * System will pick a display name if unspecified.
       * </pre>
       *
       * <code>string model_display_name = 2 [(.google.api.field_behavior) = OPTIONAL];</code>
       *
       * @return The modelDisplayName.
       */
      public java.lang.String getModelDisplayName() {
        java.lang.Object ref = modelDisplayName_;
        if (!(ref instanceof java.lang.String)) {
          com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
          java.lang.String s = bs.toStringUtf8();
          modelDisplayName_ = s;
          return s;
        } else {
          return (java.lang.String) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * Optional. Display name of the model in Vertex AI.
       * System will pick a display name if unspecified.
       * </pre>
       *
       * <code>string model_display_name = 2 [(.google.api.field_behavior) = OPTIONAL];</code>
       *
       * @return The bytes for modelDisplayName.
       */
      public com.google.protobuf.ByteString getModelDisplayNameBytes() {
        java.lang.Object ref = modelDisplayName_;
        if (ref instanceof String) {
          com.google.protobuf.ByteString b =
              com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
          modelDisplayName_ = b;
          return b;
        } else {
          return (com.google.protobuf.ByteString) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * Optional. Display name of the model in Vertex AI.
       * System will pick a display name if unspecified.
       * </pre>
       *
       * <code>string model_display_name = 2 [(.google.api.field_behavior) = OPTIONAL];</code>
       *
       * @param value The modelDisplayName to set.
       * @return This builder for chaining.
       */
      public Builder setModelDisplayName(java.lang.String value) {
        if (value == null) {
          throw new NullPointerException();
        }

        modelDisplayName_ = value;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Optional. Display name of the model in Vertex AI.
       * System will pick a display name if unspecified.
       * </pre>
       *
       * <code>string model_display_name = 2 [(.google.api.field_behavior) = OPTIONAL];</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearModelDisplayName() {

        modelDisplayName_ = getDefaultInstance().getModelDisplayName();
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Optional. Display name of the model in Vertex AI.
       * System will pick a display name if unspecified.
       * </pre>
       *
       * <code>string model_display_name = 2 [(.google.api.field_behavior) = OPTIONAL];</code>
       *
       * @param value The bytes for modelDisplayName to set.
       * @return This builder for chaining.
       */
      public Builder setModelDisplayNameBytes(com.google.protobuf.ByteString value) {
        if (value == null) {
          throw new NullPointerException();
        }
        checkByteStringIsUtf8(value);

        modelDisplayName_ = value;
        onChanged();
        return this;
      }

      @java.lang.Override
      public final Builder setUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.setUnknownFields(unknownFields);
      }

      @java.lang.Override
      public final Builder mergeUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.mergeUnknownFields(unknownFields);
      }

      // @@protoc_insertion_point(builder_scope:google.cloud.aiplatform.v1beta1.MigrateResourceRequest.MigrateAutomlModelConfig)
    }

    // @@protoc_insertion_point(class_scope:google.cloud.aiplatform.v1beta1.MigrateResourceRequest.MigrateAutomlModelConfig)
    private static final com.google.cloud.aiplatform.v1beta1.MigrateResourceRequest
            .MigrateAutomlModelConfig
        DEFAULT_INSTANCE;

    static {
      DEFAULT_INSTANCE =
          new com.google.cloud.aiplatform.v1beta1.MigrateResourceRequest.MigrateAutomlModelConfig();
    }

    public static com.google.cloud.aiplatform.v1beta1.MigrateResourceRequest
            .MigrateAutomlModelConfig
        getDefaultInstance() {
      return DEFAULT_INSTANCE;
    }

    private static final com.google.protobuf.Parser<MigrateAutomlModelConfig> PARSER =
        new com.google.protobuf.AbstractParser<MigrateAutomlModelConfig>() {
          @java.lang.Override
          public MigrateAutomlModelConfig parsePartialFrom(
              com.google.protobuf.CodedInputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
            return new MigrateAutomlModelConfig(input, extensionRegistry);
          }
        };

    public static com.google.protobuf.Parser<MigrateAutomlModelConfig> parser() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.protobuf.Parser<MigrateAutomlModelConfig> getParserForType() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.cloud.aiplatform.v1beta1.MigrateResourceRequest.MigrateAutomlModelConfig
        getDefaultInstanceForType() {
      return DEFAULT_INSTANCE;
    }
  }

  public interface MigrateAutomlDatasetConfigOrBuilder
      extends
      // @@protoc_insertion_point(interface_extends:google.cloud.aiplatform.v1beta1.MigrateResourceRequest.MigrateAutomlDatasetConfig)
      com.google.protobuf.MessageOrBuilder {

    /**
     *
     *
     * <pre>
     * Required. Full resource name of automl Dataset.
     * Format:
     * `projects/{project}/locations/{location}/datasets/{dataset}`.
     * </pre>
     *
     * <code>
     * string dataset = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @return The dataset.
     */
    java.lang.String getDataset();
    /**
     *
     *
     * <pre>
     * Required. Full resource name of automl Dataset.
     * Format:
     * `projects/{project}/locations/{location}/datasets/{dataset}`.
     * </pre>
     *
     * <code>
     * string dataset = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @return The bytes for dataset.
     */
    com.google.protobuf.ByteString getDatasetBytes();

    /**
     *
     *
     * <pre>
     * Required. Display name of the Dataset in Vertex AI.
     * System will pick a display name if unspecified.
     * </pre>
     *
     * <code>string dataset_display_name = 2 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return The datasetDisplayName.
     */
    java.lang.String getDatasetDisplayName();
    /**
     *
     *
     * <pre>
     * Required. Display name of the Dataset in Vertex AI.
     * System will pick a display name if unspecified.
     * </pre>
     *
     * <code>string dataset_display_name = 2 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return The bytes for datasetDisplayName.
     */
    com.google.protobuf.ByteString getDatasetDisplayNameBytes();
  }
  /**
   *
   *
   * <pre>
   * Config for migrating Dataset in automl.googleapis.com to Vertex AI's
   * Dataset.
   * </pre>
   *
   * Protobuf type {@code
   * google.cloud.aiplatform.v1beta1.MigrateResourceRequest.MigrateAutomlDatasetConfig}
   */
  public static final class MigrateAutomlDatasetConfig
      extends com.google.protobuf.GeneratedMessageV3
      implements
      // @@protoc_insertion_point(message_implements:google.cloud.aiplatform.v1beta1.MigrateResourceRequest.MigrateAutomlDatasetConfig)
      MigrateAutomlDatasetConfigOrBuilder {
    private static final long serialVersionUID = 0L;
    // Use MigrateAutomlDatasetConfig.newBuilder() to construct.
    private MigrateAutomlDatasetConfig(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
      super(builder);
    }

    private MigrateAutomlDatasetConfig() {
      dataset_ = "";
      datasetDisplayName_ = "";
    }

    @java.lang.Override
    @SuppressWarnings({"unused"})
    protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
      return new MigrateAutomlDatasetConfig();
    }

    @java.lang.Override
    public final com.google.protobuf.UnknownFieldSet getUnknownFields() {
      return this.unknownFields;
    }

    private MigrateAutomlDatasetConfig(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      this();
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      com.google.protobuf.UnknownFieldSet.Builder unknownFields =
          com.google.protobuf.UnknownFieldSet.newBuilder();
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 10:
              {
                java.lang.String s = input.readStringRequireUtf8();

                dataset_ = s;
                break;
              }
            case 18:
              {
                java.lang.String s = input.readStringRequireUtf8();

                datasetDisplayName_ = s;
                break;
              }
            default:
              {
                if (!parseUnknownField(input, unknownFields, extensionRegistry, tag)) {
                  done = true;
                }
                break;
              }
          }
        }
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.setUnfinishedMessage(this);
      } catch (java.io.IOException e) {
        throw new com.google.protobuf.InvalidProtocolBufferException(e).setUnfinishedMessage(this);
      } finally {
        this.unknownFields = unknownFields.build();
        makeExtensionsImmutable();
      }
    }

    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.aiplatform.v1beta1.MigrationServiceProto
          .internal_static_google_cloud_aiplatform_v1beta1_MigrateResourceRequest_MigrateAutomlDatasetConfig_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.aiplatform.v1beta1.MigrationServiceProto
          .internal_static_google_cloud_aiplatform_v1beta1_MigrateResourceRequest_MigrateAutomlDatasetConfig_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.aiplatform.v1beta1.MigrateResourceRequest.MigrateAutomlDatasetConfig
                  .class,
              com.google.cloud.aiplatform.v1beta1.MigrateResourceRequest.MigrateAutomlDatasetConfig
                  .Builder.class);
    }

    public static final int DATASET_FIELD_NUMBER = 1;
    private volatile java.lang.Object dataset_;
    /**
     *
     *
     * <pre>
     * Required. Full resource name of automl Dataset.
     * Format:
     * `projects/{project}/locations/{location}/datasets/{dataset}`.
     * </pre>
     *
     * <code>
     * string dataset = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @return The dataset.
     */
    @java.lang.Override
    public java.lang.String getDataset() {
      java.lang.Object ref = dataset_;
      if (ref instanceof java.lang.String) {
        return (java.lang.String) ref;
      } else {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        dataset_ = s;
        return s;
      }
    }
    /**
     *
     *
     * <pre>
     * Required. Full resource name of automl Dataset.
     * Format:
     * `projects/{project}/locations/{location}/datasets/{dataset}`.
     * </pre>
     *
     * <code>
     * string dataset = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @return The bytes for dataset.
     */
    @java.lang.Override
    public com.google.protobuf.ByteString getDatasetBytes() {
      java.lang.Object ref = dataset_;
      if (ref instanceof java.lang.String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        dataset_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    public static final int DATASET_DISPLAY_NAME_FIELD_NUMBER = 2;
    private volatile java.lang.Object datasetDisplayName_;
    /**
     *
     *
     * <pre>
     * Required. Display name of the Dataset in Vertex AI.
     * System will pick a display name if unspecified.
     * </pre>
     *
     * <code>string dataset_display_name = 2 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return The datasetDisplayName.
     */
    @java.lang.Override
    public java.lang.String getDatasetDisplayName() {
      java.lang.Object ref = datasetDisplayName_;
      if (ref instanceof java.lang.String) {
        return (java.lang.String) ref;
      } else {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        datasetDisplayName_ = s;
        return s;
      }
    }
    /**
     *
     *
     * <pre>
     * Required. Display name of the Dataset in Vertex AI.
     * System will pick a display name if unspecified.
     * </pre>
     *
     * <code>string dataset_display_name = 2 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return The bytes for datasetDisplayName.
     */
    @java.lang.Override
    public com.google.protobuf.ByteString getDatasetDisplayNameBytes() {
      java.lang.Object ref = datasetDisplayName_;
      if (ref instanceof java.lang.String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        datasetDisplayName_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    private byte memoizedIsInitialized = -1;

    @java.lang.Override
    public final boolean isInitialized() {
      byte isInitialized = memoizedIsInitialized;
      if (isInitialized == 1) return true;
      if (isInitialized == 0) return false;

      memoizedIsInitialized = 1;
      return true;
    }

    @java.lang.Override
    public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
      if (!getDatasetBytes().isEmpty()) {
        com.google.protobuf.GeneratedMessageV3.writeString(output, 1, dataset_);
      }
      if (!getDatasetDisplayNameBytes().isEmpty()) {
        com.google.protobuf.GeneratedMessageV3.writeString(output, 2, datasetDisplayName_);
      }
      unknownFields.writeTo(output);
    }

    @java.lang.Override
    public int getSerializedSize() {
      int size = memoizedSize;
      if (size != -1) return size;

      size = 0;
      if (!getDatasetBytes().isEmpty()) {
        size += com.google.protobuf.GeneratedMessageV3.computeStringSize(1, dataset_);
      }
      if (!getDatasetDisplayNameBytes().isEmpty()) {
        size += com.google.protobuf.GeneratedMessageV3.computeStringSize(2, datasetDisplayName_);
      }
      size += unknownFields.getSerializedSize();
      memoizedSize = size;
      return size;
    }

    @java.lang.Override
    public boolean equals(final java.lang.Object obj) {
      if (obj == this) {
        return true;
      }
      if (!(obj
          instanceof
          com.google.cloud.aiplatform.v1beta1.MigrateResourceRequest.MigrateAutomlDatasetConfig)) {
        return super.equals(obj);
      }
      com.google.cloud.aiplatform.v1beta1.MigrateResourceRequest.MigrateAutomlDatasetConfig other =
          (com.google.cloud.aiplatform.v1beta1.MigrateResourceRequest.MigrateAutomlDatasetConfig)
              obj;

      if (!getDataset().equals(other.getDataset())) return false;
      if (!getDatasetDisplayName().equals(other.getDatasetDisplayName())) return false;
      if (!unknownFields.equals(other.unknownFields)) return false;
      return true;
    }

    @java.lang.Override
    public int hashCode() {
      if (memoizedHashCode != 0) {
        return memoizedHashCode;
      }
      int hash = 41;
      hash = (19 * hash) + getDescriptor().hashCode();
      hash = (37 * hash) + DATASET_FIELD_NUMBER;
      hash = (53 * hash) + getDataset().hashCode();
      hash = (37 * hash) + DATASET_DISPLAY_NAME_FIELD_NUMBER;
      hash = (53 * hash) + getDatasetDisplayName().hashCode();
      hash = (29 * hash) + unknownFields.hashCode();
      memoizedHashCode = hash;
      return hash;
    }

    public static com.google.cloud.aiplatform.v1beta1.MigrateResourceRequest
            .MigrateAutomlDatasetConfig
        parseFrom(java.nio.ByteBuffer data)
            throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.aiplatform.v1beta1.MigrateResourceRequest
            .MigrateAutomlDatasetConfig
        parseFrom(
            java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.aiplatform.v1beta1.MigrateResourceRequest
            .MigrateAutomlDatasetConfig
        parseFrom(com.google.protobuf.ByteString data)
            throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.aiplatform.v1beta1.MigrateResourceRequest
            .MigrateAutomlDatasetConfig
        parseFrom(
            com.google.protobuf.ByteString data,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.aiplatform.v1beta1.MigrateResourceRequest
            .MigrateAutomlDatasetConfig
        parseFrom(byte[] data) throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.aiplatform.v1beta1.MigrateResourceRequest
            .MigrateAutomlDatasetConfig
        parseFrom(byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.aiplatform.v1beta1.MigrateResourceRequest
            .MigrateAutomlDatasetConfig
        parseFrom(java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.cloud.aiplatform.v1beta1.MigrateResourceRequest
            .MigrateAutomlDatasetConfig
        parseFrom(
            java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.cloud.aiplatform.v1beta1.MigrateResourceRequest
            .MigrateAutomlDatasetConfig
        parseDelimitedFrom(java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
    }

    public static com.google.cloud.aiplatform.v1beta1.MigrateResourceRequest
            .MigrateAutomlDatasetConfig
        parseDelimitedFrom(
            java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.cloud.aiplatform.v1beta1.MigrateResourceRequest
            .MigrateAutomlDatasetConfig
        parseFrom(com.google.protobuf.CodedInputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.cloud.aiplatform.v1beta1.MigrateResourceRequest
            .MigrateAutomlDatasetConfig
        parseFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    @java.lang.Override
    public Builder newBuilderForType() {
      return newBuilder();
    }

    public static Builder newBuilder() {
      return DEFAULT_INSTANCE.toBuilder();
    }

    public static Builder newBuilder(
        com.google.cloud.aiplatform.v1beta1.MigrateResourceRequest.MigrateAutomlDatasetConfig
            prototype) {
      return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }

    @java.lang.Override
    public Builder toBuilder() {
      return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
    }

    @java.lang.Override
    protected Builder newBuilderForType(
        com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      Builder builder = new Builder(parent);
      return builder;
    }
    /**
     *
     *
     * <pre>
     * Config for migrating Dataset in automl.googleapis.com to Vertex AI's
     * Dataset.
     * </pre>
     *
     * Protobuf type {@code
     * google.cloud.aiplatform.v1beta1.MigrateResourceRequest.MigrateAutomlDatasetConfig}
     */
    public static final class Builder
        extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
        implements
        // @@protoc_insertion_point(builder_implements:google.cloud.aiplatform.v1beta1.MigrateResourceRequest.MigrateAutomlDatasetConfig)
        com.google.cloud.aiplatform.v1beta1.MigrateResourceRequest
            .MigrateAutomlDatasetConfigOrBuilder {
      public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
        return com.google.cloud.aiplatform.v1beta1.MigrationServiceProto
            .internal_static_google_cloud_aiplatform_v1beta1_MigrateResourceRequest_MigrateAutomlDatasetConfig_descriptor;
      }

      @java.lang.Override
      protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return com.google.cloud.aiplatform.v1beta1.MigrationServiceProto
            .internal_static_google_cloud_aiplatform_v1beta1_MigrateResourceRequest_MigrateAutomlDatasetConfig_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                com.google.cloud.aiplatform.v1beta1.MigrateResourceRequest
                    .MigrateAutomlDatasetConfig.class,
                com.google.cloud.aiplatform.v1beta1.MigrateResourceRequest
                    .MigrateAutomlDatasetConfig.Builder.class);
      }

      // Construct using
      // com.google.cloud.aiplatform.v1beta1.MigrateResourceRequest.MigrateAutomlDatasetConfig.newBuilder()
      private Builder() {
        maybeForceBuilderInitialization();
      }

      private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
        super(parent);
        maybeForceBuilderInitialization();
      }

      private void maybeForceBuilderInitialization() {
        if (com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders) {}
      }

      @java.lang.Override
      public Builder clear() {
        super.clear();
        dataset_ = "";

        datasetDisplayName_ = "";

        return this;
      }

      @java.lang.Override
      public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
        return com.google.cloud.aiplatform.v1beta1.MigrationServiceProto
            .internal_static_google_cloud_aiplatform_v1beta1_MigrateResourceRequest_MigrateAutomlDatasetConfig_descriptor;
      }

      @java.lang.Override
      public com.google.cloud.aiplatform.v1beta1.MigrateResourceRequest.MigrateAutomlDatasetConfig
          getDefaultInstanceForType() {
        return com.google.cloud.aiplatform.v1beta1.MigrateResourceRequest.MigrateAutomlDatasetConfig
            .getDefaultInstance();
      }

      @java.lang.Override
      public com.google.cloud.aiplatform.v1beta1.MigrateResourceRequest.MigrateAutomlDatasetConfig
          build() {
        com.google.cloud.aiplatform.v1beta1.MigrateResourceRequest.MigrateAutomlDatasetConfig
            result = buildPartial();
        if (!result.isInitialized()) {
          throw newUninitializedMessageException(result);
        }
        return result;
      }

      @java.lang.Override
      public com.google.cloud.aiplatform.v1beta1.MigrateResourceRequest.MigrateAutomlDatasetConfig
          buildPartial() {
        com.google.cloud.aiplatform.v1beta1.MigrateResourceRequest.MigrateAutomlDatasetConfig
            result =
                new com.google.cloud.aiplatform.v1beta1.MigrateResourceRequest
                    .MigrateAutomlDatasetConfig(this);
        result.dataset_ = dataset_;
        result.datasetDisplayName_ = datasetDisplayName_;
        onBuilt();
        return result;
      }

      @java.lang.Override
      public Builder clone() {
        return super.clone();
      }

      @java.lang.Override
      public Builder setField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.setField(field, value);
      }

      @java.lang.Override
      public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
        return super.clearField(field);
      }

      @java.lang.Override
      public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
        return super.clearOneof(oneof);
      }

      @java.lang.Override
      public Builder setRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          int index,
          java.lang.Object value) {
        return super.setRepeatedField(field, index, value);
      }

      @java.lang.Override
      public Builder addRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.addRepeatedField(field, value);
      }

      @java.lang.Override
      public Builder mergeFrom(com.google.protobuf.Message other) {
        if (other
            instanceof
            com.google.cloud.aiplatform.v1beta1.MigrateResourceRequest.MigrateAutomlDatasetConfig) {
          return mergeFrom(
              (com.google.cloud.aiplatform.v1beta1.MigrateResourceRequest
                      .MigrateAutomlDatasetConfig)
                  other);
        } else {
          super.mergeFrom(other);
          return this;
        }
      }

      public Builder mergeFrom(
          com.google.cloud.aiplatform.v1beta1.MigrateResourceRequest.MigrateAutomlDatasetConfig
              other) {
        if (other
            == com.google.cloud.aiplatform.v1beta1.MigrateResourceRequest.MigrateAutomlDatasetConfig
                .getDefaultInstance()) return this;
        if (!other.getDataset().isEmpty()) {
          dataset_ = other.dataset_;
          onChanged();
        }
        if (!other.getDatasetDisplayName().isEmpty()) {
          datasetDisplayName_ = other.datasetDisplayName_;
          onChanged();
        }
        this.mergeUnknownFields(other.unknownFields);
        onChanged();
        return this;
      }

      @java.lang.Override
      public final boolean isInitialized() {
        return true;
      }

      @java.lang.Override
      public Builder mergeFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        com.google.cloud.aiplatform.v1beta1.MigrateResourceRequest.MigrateAutomlDatasetConfig
            parsedMessage = null;
        try {
          parsedMessage = PARSER.parsePartialFrom(input, extensionRegistry);
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          parsedMessage =
              (com.google.cloud.aiplatform.v1beta1.MigrateResourceRequest
                      .MigrateAutomlDatasetConfig)
                  e.getUnfinishedMessage();
          throw e.unwrapIOException();
        } finally {
          if (parsedMessage != null) {
            mergeFrom(parsedMessage);
          }
        }
        return this;
      }

      private java.lang.Object dataset_ = "";
      /**
       *
       *
       * <pre>
       * Required. Full resource name of automl Dataset.
       * Format:
       * `projects/{project}/locations/{location}/datasets/{dataset}`.
       * </pre>
       *
       * <code>
       * string dataset = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
       * </code>
       *
       * @return The dataset.
       */
      public java.lang.String getDataset() {
        java.lang.Object ref = dataset_;
        if (!(ref instanceof java.lang.String)) {
          com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
          java.lang.String s = bs.toStringUtf8();
          dataset_ = s;
          return s;
        } else {
          return (java.lang.String) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * Required. Full resource name of automl Dataset.
       * Format:
       * `projects/{project}/locations/{location}/datasets/{dataset}`.
       * </pre>
       *
       * <code>
       * string dataset = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
       * </code>
       *
       * @return The bytes for dataset.
       */
      public com.google.protobuf.ByteString getDatasetBytes() {
        java.lang.Object ref = dataset_;
        if (ref instanceof String) {
          com.google.protobuf.ByteString b =
              com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
          dataset_ = b;
          return b;
        } else {
          return (com.google.protobuf.ByteString) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * Required. Full resource name of automl Dataset.
       * Format:
       * `projects/{project}/locations/{location}/datasets/{dataset}`.
       * </pre>
       *
       * <code>
       * string dataset = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
       * </code>
       *
       * @param value The dataset to set.
       * @return This builder for chaining.
       */
      public Builder setDataset(java.lang.String value) {
        if (value == null) {
          throw new NullPointerException();
        }

        dataset_ = value;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Required. Full resource name of automl Dataset.
       * Format:
       * `projects/{project}/locations/{location}/datasets/{dataset}`.
       * </pre>
       *
       * <code>
       * string dataset = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
       * </code>
       *
       * @return This builder for chaining.
       */
      public Builder clearDataset() {

        dataset_ = getDefaultInstance().getDataset();
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Required. Full resource name of automl Dataset.
       * Format:
       * `projects/{project}/locations/{location}/datasets/{dataset}`.
       * </pre>
       *
       * <code>
       * string dataset = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
       * </code>
       *
       * @param value The bytes for dataset to set.
       * @return This builder for chaining.
       */
      public Builder setDatasetBytes(com.google.protobuf.ByteString value) {
        if (value == null) {
          throw new NullPointerException();
        }
        checkByteStringIsUtf8(value);

        dataset_ = value;
        onChanged();
        return this;
      }

      private java.lang.Object datasetDisplayName_ = "";
      /**
       *
       *
       * <pre>
       * Required. Display name of the Dataset in Vertex AI.
       * System will pick a display name if unspecified.
       * </pre>
       *
       * <code>string dataset_display_name = 2 [(.google.api.field_behavior) = REQUIRED];</code>
       *
       * @return The datasetDisplayName.
       */
      public java.lang.String getDatasetDisplayName() {
        java.lang.Object ref = datasetDisplayName_;
        if (!(ref instanceof java.lang.String)) {
          com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
          java.lang.String s = bs.toStringUtf8();
          datasetDisplayName_ = s;
          return s;
        } else {
          return (java.lang.String) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * Required. Display name of the Dataset in Vertex AI.
       * System will pick a display name if unspecified.
       * </pre>
       *
       * <code>string dataset_display_name = 2 [(.google.api.field_behavior) = REQUIRED];</code>
       *
       * @return The bytes for datasetDisplayName.
       */
      public com.google.protobuf.ByteString getDatasetDisplayNameBytes() {
        java.lang.Object ref = datasetDisplayName_;
        if (ref instanceof String) {
          com.google.protobuf.ByteString b =
              com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
          datasetDisplayName_ = b;
          return b;
        } else {
          return (com.google.protobuf.ByteString) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * Required. Display name of the Dataset in Vertex AI.
       * System will pick a display name if unspecified.
       * </pre>
       *
       * <code>string dataset_display_name = 2 [(.google.api.field_behavior) = REQUIRED];</code>
       *
       * @param value The datasetDisplayName to set.
       * @return This builder for chaining.
       */
      public Builder setDatasetDisplayName(java.lang.String value) {
        if (value == null) {
          throw new NullPointerException();
        }

        datasetDisplayName_ = value;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Required. Display name of the Dataset in Vertex AI.
       * System will pick a display name if unspecified.
       * </pre>
       *
       * <code>string dataset_display_name = 2 [(.google.api.field_behavior) = REQUIRED];</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearDatasetDisplayName() {

        datasetDisplayName_ = getDefaultInstance().getDatasetDisplayName();
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Required. Display name of the Dataset in Vertex AI.
       * System will pick a display name if unspecified.
       * </pre>
       *
       * <code>string dataset_display_name = 2 [(.google.api.field_behavior) = REQUIRED];</code>
       *
       * @param value The bytes for datasetDisplayName to set.
       * @return This builder for chaining.
       */
      public Builder setDatasetDisplayNameBytes(com.google.protobuf.ByteString value) {
        if (value == null) {
          throw new NullPointerException();
        }
        checkByteStringIsUtf8(value);

        datasetDisplayName_ = value;
        onChanged();
        return this;
      }

      @java.lang.Override
      public final Builder setUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.setUnknownFields(unknownFields);
      }

      @java.lang.Override
      public final Builder mergeUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.mergeUnknownFields(unknownFields);
      }

      // @@protoc_insertion_point(builder_scope:google.cloud.aiplatform.v1beta1.MigrateResourceRequest.MigrateAutomlDatasetConfig)
    }

    // @@protoc_insertion_point(class_scope:google.cloud.aiplatform.v1beta1.MigrateResourceRequest.MigrateAutomlDatasetConfig)
    private static final com.google.cloud.aiplatform.v1beta1.MigrateResourceRequest
            .MigrateAutomlDatasetConfig
        DEFAULT_INSTANCE;

    static {
      DEFAULT_INSTANCE =
          new com.google.cloud.aiplatform.v1beta1.MigrateResourceRequest
              .MigrateAutomlDatasetConfig();
    }

    public static com.google.cloud.aiplatform.v1beta1.MigrateResourceRequest
            .MigrateAutomlDatasetConfig
        getDefaultInstance() {
      return DEFAULT_INSTANCE;
    }

    private static final com.google.protobuf.Parser<MigrateAutomlDatasetConfig> PARSER =
        new com.google.protobuf.AbstractParser<MigrateAutomlDatasetConfig>() {
          @java.lang.Override
          public MigrateAutomlDatasetConfig parsePartialFrom(
              com.google.protobuf.CodedInputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
            return new MigrateAutomlDatasetConfig(input, extensionRegistry);
          }
        };

    public static com.google.protobuf.Parser<MigrateAutomlDatasetConfig> parser() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.protobuf.Parser<MigrateAutomlDatasetConfig> getParserForType() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.cloud.aiplatform.v1beta1.MigrateResourceRequest.MigrateAutomlDatasetConfig
        getDefaultInstanceForType() {
      return DEFAULT_INSTANCE;
    }
  }

  public interface MigrateDataLabelingDatasetConfigOrBuilder
      extends
      // @@protoc_insertion_point(interface_extends:google.cloud.aiplatform.v1beta1.MigrateResourceRequest.MigrateDataLabelingDatasetConfig)
      com.google.protobuf.MessageOrBuilder {

    /**
     *
     *
     * <pre>
     * Required. Full resource name of data labeling Dataset.
     * Format:
     * `projects/{project}/datasets/{dataset}`.
     * </pre>
     *
     * <code>
     * string dataset = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @return The dataset.
     */
    java.lang.String getDataset();
    /**
     *
     *
     * <pre>
     * Required. Full resource name of data labeling Dataset.
     * Format:
     * `projects/{project}/datasets/{dataset}`.
     * </pre>
     *
     * <code>
     * string dataset = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @return The bytes for dataset.
     */
    com.google.protobuf.ByteString getDatasetBytes();

    /**
     *
     *
     * <pre>
     * Optional. Display name of the Dataset in Vertex AI.
     * System will pick a display name if unspecified.
     * </pre>
     *
     * <code>string dataset_display_name = 2 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return The datasetDisplayName.
     */
    java.lang.String getDatasetDisplayName();
    /**
     *
     *
     * <pre>
     * Optional. Display name of the Dataset in Vertex AI.
     * System will pick a display name if unspecified.
     * </pre>
     *
     * <code>string dataset_display_name = 2 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return The bytes for datasetDisplayName.
     */
    com.google.protobuf.ByteString getDatasetDisplayNameBytes();

    /**
     *
     *
     * <pre>
     * Optional. Configs for migrating AnnotatedDataset in datalabeling.googleapis.com to
     * Vertex AI's SavedQuery. The specified AnnotatedDatasets have to belong
     * to the datalabeling Dataset.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.aiplatform.v1beta1.MigrateResourceRequest.MigrateDataLabelingDatasetConfig.MigrateDataLabelingAnnotatedDatasetConfig migrate_data_labeling_annotated_dataset_configs = 3 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    java.util.List<
            com.google.cloud.aiplatform.v1beta1.MigrateResourceRequest
                .MigrateDataLabelingDatasetConfig.MigrateDataLabelingAnnotatedDatasetConfig>
        getMigrateDataLabelingAnnotatedDatasetConfigsList();
    /**
     *
     *
     * <pre>
     * Optional. Configs for migrating AnnotatedDataset in datalabeling.googleapis.com to
     * Vertex AI's SavedQuery. The specified AnnotatedDatasets have to belong
     * to the datalabeling Dataset.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.aiplatform.v1beta1.MigrateResourceRequest.MigrateDataLabelingDatasetConfig.MigrateDataLabelingAnnotatedDatasetConfig migrate_data_labeling_annotated_dataset_configs = 3 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    com.google.cloud.aiplatform.v1beta1.MigrateResourceRequest.MigrateDataLabelingDatasetConfig
            .MigrateDataLabelingAnnotatedDatasetConfig
        getMigrateDataLabelingAnnotatedDatasetConfigs(int index);
    /**
     *
     *
     * <pre>
     * Optional. Configs for migrating AnnotatedDataset in datalabeling.googleapis.com to
     * Vertex AI's SavedQuery. The specified AnnotatedDatasets have to belong
     * to the datalabeling Dataset.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.aiplatform.v1beta1.MigrateResourceRequest.MigrateDataLabelingDatasetConfig.MigrateDataLabelingAnnotatedDatasetConfig migrate_data_labeling_annotated_dataset_configs = 3 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    int getMigrateDataLabelingAnnotatedDatasetConfigsCount();
    /**
     *
     *
     * <pre>
     * Optional. Configs for migrating AnnotatedDataset in datalabeling.googleapis.com to
     * Vertex AI's SavedQuery. The specified AnnotatedDatasets have to belong
     * to the datalabeling Dataset.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.aiplatform.v1beta1.MigrateResourceRequest.MigrateDataLabelingDatasetConfig.MigrateDataLabelingAnnotatedDatasetConfig migrate_data_labeling_annotated_dataset_configs = 3 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    java.util.List<
            ? extends
                com.google.cloud.aiplatform.v1beta1.MigrateResourceRequest
                    .MigrateDataLabelingDatasetConfig
                    .MigrateDataLabelingAnnotatedDatasetConfigOrBuilder>
        getMigrateDataLabelingAnnotatedDatasetConfigsOrBuilderList();
    /**
     *
     *
     * <pre>
     * Optional. Configs for migrating AnnotatedDataset in datalabeling.googleapis.com to
     * Vertex AI's SavedQuery. The specified AnnotatedDatasets have to belong
     * to the datalabeling Dataset.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.aiplatform.v1beta1.MigrateResourceRequest.MigrateDataLabelingDatasetConfig.MigrateDataLabelingAnnotatedDatasetConfig migrate_data_labeling_annotated_dataset_configs = 3 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    com.google.cloud.aiplatform.v1beta1.MigrateResourceRequest.MigrateDataLabelingDatasetConfig
            .MigrateDataLabelingAnnotatedDatasetConfigOrBuilder
        getMigrateDataLabelingAnnotatedDatasetConfigsOrBuilder(int index);
  }
  /**
   *
   *
   * <pre>
   * Config for migrating Dataset in datalabeling.googleapis.com to Vertex
   * AI's Dataset.
   * </pre>
   *
   * Protobuf type {@code
   * google.cloud.aiplatform.v1beta1.MigrateResourceRequest.MigrateDataLabelingDatasetConfig}
   */
  public static final class MigrateDataLabelingDatasetConfig
      extends com.google.protobuf.GeneratedMessageV3
      implements
      // @@protoc_insertion_point(message_implements:google.cloud.aiplatform.v1beta1.MigrateResourceRequest.MigrateDataLabelingDatasetConfig)
      MigrateDataLabelingDatasetConfigOrBuilder {
    private static final long serialVersionUID = 0L;
    // Use MigrateDataLabelingDatasetConfig.newBuilder() to construct.
    private MigrateDataLabelingDatasetConfig(
        com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
      super(builder);
    }

    private MigrateDataLabelingDatasetConfig() {
      dataset_ = "";
      datasetDisplayName_ = "";
      migrateDataLabelingAnnotatedDatasetConfigs_ = java.util.Collections.emptyList();
    }

    @java.lang.Override
    @SuppressWarnings({"unused"})
    protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
      return new MigrateDataLabelingDatasetConfig();
    }

    @java.lang.Override
    public final com.google.protobuf.UnknownFieldSet getUnknownFields() {
      return this.unknownFields;
    }

    private MigrateDataLabelingDatasetConfig(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      this();
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      int mutable_bitField0_ = 0;
      com.google.protobuf.UnknownFieldSet.Builder unknownFields =
          com.google.protobuf.UnknownFieldSet.newBuilder();
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 10:
              {
                java.lang.String s = input.readStringRequireUtf8();

                dataset_ = s;
                break;
              }
            case 18:
              {
                java.lang.String s = input.readStringRequireUtf8();

                datasetDisplayName_ = s;
                break;
              }
            case 26:
              {
                if (!((mutable_bitField0_ & 0x00000001) != 0)) {
                  migrateDataLabelingAnnotatedDatasetConfigs_ =
                      new java.util.ArrayList<
                          com.google.cloud.aiplatform.v1beta1.MigrateResourceRequest
                              .MigrateDataLabelingDatasetConfig
                              .MigrateDataLabelingAnnotatedDatasetConfig>();
                  mutable_bitField0_ |= 0x00000001;
                }
                migrateDataLabelingAnnotatedDatasetConfigs_.add(
                    input.readMessage(
                        com.google.cloud.aiplatform.v1beta1.MigrateResourceRequest
                            .MigrateDataLabelingDatasetConfig
                            .MigrateDataLabelingAnnotatedDatasetConfig.parser(),
                        extensionRegistry));
                break;
              }
            default:
              {
                if (!parseUnknownField(input, unknownFields, extensionRegistry, tag)) {
                  done = true;
                }
                break;
              }
          }
        }
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.setUnfinishedMessage(this);
      } catch (java.io.IOException e) {
        throw new com.google.protobuf.InvalidProtocolBufferException(e).setUnfinishedMessage(this);
      } finally {
        if (((mutable_bitField0_ & 0x00000001) != 0)) {
          migrateDataLabelingAnnotatedDatasetConfigs_ =
              java.util.Collections.unmodifiableList(migrateDataLabelingAnnotatedDatasetConfigs_);
        }
        this.unknownFields = unknownFields.build();
        makeExtensionsImmutable();
      }
    }

    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.aiplatform.v1beta1.MigrationServiceProto
          .internal_static_google_cloud_aiplatform_v1beta1_MigrateResourceRequest_MigrateDataLabelingDatasetConfig_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.aiplatform.v1beta1.MigrationServiceProto
          .internal_static_google_cloud_aiplatform_v1beta1_MigrateResourceRequest_MigrateDataLabelingDatasetConfig_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.aiplatform.v1beta1.MigrateResourceRequest
                  .MigrateDataLabelingDatasetConfig.class,
              com.google.cloud.aiplatform.v1beta1.MigrateResourceRequest
                  .MigrateDataLabelingDatasetConfig.Builder.class);
    }

    public interface MigrateDataLabelingAnnotatedDatasetConfigOrBuilder
        extends
        // @@protoc_insertion_point(interface_extends:google.cloud.aiplatform.v1beta1.MigrateResourceRequest.MigrateDataLabelingDatasetConfig.MigrateDataLabelingAnnotatedDatasetConfig)
        com.google.protobuf.MessageOrBuilder {

      /**
       *
       *
       * <pre>
       * Required. Full resource name of data labeling AnnotatedDataset.
       * Format:
       * `projects/{project}/datasets/{dataset}/annotatedDatasets/{annotated_dataset}`.
       * </pre>
       *
       * <code>
       * string annotated_dataset = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
       * </code>
       *
       * @return The annotatedDataset.
       */
      java.lang.String getAnnotatedDataset();
      /**
       *
       *
       * <pre>
       * Required. Full resource name of data labeling AnnotatedDataset.
       * Format:
       * `projects/{project}/datasets/{dataset}/annotatedDatasets/{annotated_dataset}`.
       * </pre>
       *
       * <code>
       * string annotated_dataset = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
       * </code>
       *
       * @return The bytes for annotatedDataset.
       */
      com.google.protobuf.ByteString getAnnotatedDatasetBytes();
    }
    /**
     *
     *
     * <pre>
     * Config for migrating AnnotatedDataset in datalabeling.googleapis.com to
     * Vertex AI's SavedQuery.
     * </pre>
     *
     * Protobuf type {@code
     * google.cloud.aiplatform.v1beta1.MigrateResourceRequest.MigrateDataLabelingDatasetConfig.MigrateDataLabelingAnnotatedDatasetConfig}
     */
    public static final class MigrateDataLabelingAnnotatedDatasetConfig
        extends com.google.protobuf.GeneratedMessageV3
        implements
        // @@protoc_insertion_point(message_implements:google.cloud.aiplatform.v1beta1.MigrateResourceRequest.MigrateDataLabelingDatasetConfig.MigrateDataLabelingAnnotatedDatasetConfig)
        MigrateDataLabelingAnnotatedDatasetConfigOrBuilder {
      private static final long serialVersionUID = 0L;
      // Use MigrateDataLabelingAnnotatedDatasetConfig.newBuilder() to construct.
      private MigrateDataLabelingAnnotatedDatasetConfig(
          com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
        super(builder);
      }

      private MigrateDataLabelingAnnotatedDatasetConfig() {
        annotatedDataset_ = "";
      }

      @java.lang.Override
      @SuppressWarnings({"unused"})
      protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
        return new MigrateDataLabelingAnnotatedDatasetConfig();
      }

      @java.lang.Override
      public final com.google.protobuf.UnknownFieldSet getUnknownFields() {
        return this.unknownFields;
      }

      private MigrateDataLabelingAnnotatedDatasetConfig(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws com.google.protobuf.InvalidProtocolBufferException {
        this();
        if (extensionRegistry == null) {
          throw new java.lang.NullPointerException();
        }
        com.google.protobuf.UnknownFieldSet.Builder unknownFields =
            com.google.protobuf.UnknownFieldSet.newBuilder();
        try {
          boolean done = false;
          while (!done) {
            int tag = input.readTag();
            switch (tag) {
              case 0:
                done = true;
                break;
              case 10:
                {
                  java.lang.String s = input.readStringRequireUtf8();

                  annotatedDataset_ = s;
                  break;
                }
              default:
                {
                  if (!parseUnknownField(input, unknownFields, extensionRegistry, tag)) {
                    done = true;
                  }
                  break;
                }
            }
          }
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          throw e.setUnfinishedMessage(this);
        } catch (java.io.IOException e) {
          throw new com.google.protobuf.InvalidProtocolBufferException(e)
              .setUnfinishedMessage(this);
        } finally {
          this.unknownFields = unknownFields.build();
          makeExtensionsImmutable();
        }
      }

      public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
        return com.google.cloud.aiplatform.v1beta1.MigrationServiceProto
            .internal_static_google_cloud_aiplatform_v1beta1_MigrateResourceRequest_MigrateDataLabelingDatasetConfig_MigrateDataLabelingAnnotatedDatasetConfig_descriptor;
      }

      @java.lang.Override
      protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return com.google.cloud.aiplatform.v1beta1.MigrationServiceProto
            .internal_static_google_cloud_aiplatform_v1beta1_MigrateResourceRequest_MigrateDataLabelingDatasetConfig_MigrateDataLabelingAnnotatedDatasetConfig_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                com.google.cloud.aiplatform.v1beta1.MigrateResourceRequest
                    .MigrateDataLabelingDatasetConfig.MigrateDataLabelingAnnotatedDatasetConfig
                    .class,
                com.google.cloud.aiplatform.v1beta1.MigrateResourceRequest
                    .MigrateDataLabelingDatasetConfig.MigrateDataLabelingAnnotatedDatasetConfig
                    .Builder.class);
      }

      public static final int ANNOTATED_DATASET_FIELD_NUMBER = 1;
      private volatile java.lang.Object annotatedDataset_;
      /**
       *
       *
       * <pre>
       * Required. Full resource name of data labeling AnnotatedDataset.
       * Format:
       * `projects/{project}/datasets/{dataset}/annotatedDatasets/{annotated_dataset}`.
       * </pre>
       *
       * <code>
       * string annotated_dataset = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
       * </code>
       *
       * @return The annotatedDataset.
       */
      @java.lang.Override
      public java.lang.String getAnnotatedDataset() {
        java.lang.Object ref = annotatedDataset_;
        if (ref instanceof java.lang.String) {
          return (java.lang.String) ref;
        } else {
          com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
          java.lang.String s = bs.toStringUtf8();
          annotatedDataset_ = s;
          return s;
        }
      }
      /**
       *
       *
       * <pre>
       * Required. Full resource name of data labeling AnnotatedDataset.
       * Format:
       * `projects/{project}/datasets/{dataset}/annotatedDatasets/{annotated_dataset}`.
       * </pre>
       *
       * <code>
       * string annotated_dataset = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
       * </code>
       *
       * @return The bytes for annotatedDataset.
       */
      @java.lang.Override
      public com.google.protobuf.ByteString getAnnotatedDatasetBytes() {
        java.lang.Object ref = annotatedDataset_;
        if (ref instanceof java.lang.String) {
          com.google.protobuf.ByteString b =
              com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
          annotatedDataset_ = b;
          return b;
        } else {
          return (com.google.protobuf.ByteString) ref;
        }
      }

      private byte memoizedIsInitialized = -1;

      @java.lang.Override
      public final boolean isInitialized() {
        byte isInitialized = memoizedIsInitialized;
        if (isInitialized == 1) return true;
        if (isInitialized == 0) return false;

        memoizedIsInitialized = 1;
        return true;
      }

      @java.lang.Override
      public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
        if (!getAnnotatedDatasetBytes().isEmpty()) {
          com.google.protobuf.GeneratedMessageV3.writeString(output, 1, annotatedDataset_);
        }
        unknownFields.writeTo(output);
      }

      @java.lang.Override
      public int getSerializedSize() {
        int size = memoizedSize;
        if (size != -1) return size;

        size = 0;
        if (!getAnnotatedDatasetBytes().isEmpty()) {
          size += com.google.protobuf.GeneratedMessageV3.computeStringSize(1, annotatedDataset_);
        }
        size += unknownFields.getSerializedSize();
        memoizedSize = size;
        return size;
      }

      @java.lang.Override
      public boolean equals(final java.lang.Object obj) {
        if (obj == this) {
          return true;
        }
        if (!(obj
            instanceof
            com.google.cloud.aiplatform.v1beta1.MigrateResourceRequest
                .MigrateDataLabelingDatasetConfig.MigrateDataLabelingAnnotatedDatasetConfig)) {
          return super.equals(obj);
        }
        com.google.cloud.aiplatform.v1beta1.MigrateResourceRequest.MigrateDataLabelingDatasetConfig
                .MigrateDataLabelingAnnotatedDatasetConfig
            other =
                (com.google.cloud.aiplatform.v1beta1.MigrateResourceRequest
                        .MigrateDataLabelingDatasetConfig.MigrateDataLabelingAnnotatedDatasetConfig)
                    obj;

        if (!getAnnotatedDataset().equals(other.getAnnotatedDataset())) return false;
        if (!unknownFields.equals(other.unknownFields)) return false;
        return true;
      }

      @java.lang.Override
      public int hashCode() {
        if (memoizedHashCode != 0) {
          return memoizedHashCode;
        }
        int hash = 41;
        hash = (19 * hash) + getDescriptor().hashCode();
        hash = (37 * hash) + ANNOTATED_DATASET_FIELD_NUMBER;
        hash = (53 * hash) + getAnnotatedDataset().hashCode();
        hash = (29 * hash) + unknownFields.hashCode();
        memoizedHashCode = hash;
        return hash;
      }

      public static com.google.cloud.aiplatform.v1beta1.MigrateResourceRequest
              .MigrateDataLabelingDatasetConfig.MigrateDataLabelingAnnotatedDatasetConfig
          parseFrom(java.nio.ByteBuffer data)
              throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data);
      }

      public static com.google.cloud.aiplatform.v1beta1.MigrateResourceRequest
              .MigrateDataLabelingDatasetConfig.MigrateDataLabelingAnnotatedDatasetConfig
          parseFrom(
              java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data, extensionRegistry);
      }

      public static com.google.cloud.aiplatform.v1beta1.MigrateResourceRequest
              .MigrateDataLabelingDatasetConfig.MigrateDataLabelingAnnotatedDatasetConfig
          parseFrom(com.google.protobuf.ByteString data)
              throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data);
      }

      public static com.google.cloud.aiplatform.v1beta1.MigrateResourceRequest
              .MigrateDataLabelingDatasetConfig.MigrateDataLabelingAnnotatedDatasetConfig
          parseFrom(
              com.google.protobuf.ByteString data,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data, extensionRegistry);
      }

      public static com.google.cloud.aiplatform.v1beta1.MigrateResourceRequest
              .MigrateDataLabelingDatasetConfig.MigrateDataLabelingAnnotatedDatasetConfig
          parseFrom(byte[] data) throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data);
      }

      public static com.google.cloud.aiplatform.v1beta1.MigrateResourceRequest
              .MigrateDataLabelingDatasetConfig.MigrateDataLabelingAnnotatedDatasetConfig
          parseFrom(byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data, extensionRegistry);
      }

      public static com.google.cloud.aiplatform.v1beta1.MigrateResourceRequest
              .MigrateDataLabelingDatasetConfig.MigrateDataLabelingAnnotatedDatasetConfig
          parseFrom(java.io.InputStream input) throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
      }

      public static com.google.cloud.aiplatform.v1beta1.MigrateResourceRequest
              .MigrateDataLabelingDatasetConfig.MigrateDataLabelingAnnotatedDatasetConfig
          parseFrom(
              java.io.InputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
            PARSER, input, extensionRegistry);
      }

      public static com.google.cloud.aiplatform.v1beta1.MigrateResourceRequest
              .MigrateDataLabelingDatasetConfig.MigrateDataLabelingAnnotatedDatasetConfig
          parseDelimitedFrom(java.io.InputStream input) throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
      }

      public static com.google.cloud.aiplatform.v1beta1.MigrateResourceRequest
              .MigrateDataLabelingDatasetConfig.MigrateDataLabelingAnnotatedDatasetConfig
          parseDelimitedFrom(
              java.io.InputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
            PARSER, input, extensionRegistry);
      }

      public static com.google.cloud.aiplatform.v1beta1.MigrateResourceRequest
              .MigrateDataLabelingDatasetConfig.MigrateDataLabelingAnnotatedDatasetConfig
          parseFrom(com.google.protobuf.CodedInputStream input) throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
      }

      public static com.google.cloud.aiplatform.v1beta1.MigrateResourceRequest
              .MigrateDataLabelingDatasetConfig.MigrateDataLabelingAnnotatedDatasetConfig
          parseFrom(
              com.google.protobuf.CodedInputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
            PARSER, input, extensionRegistry);
      }

      @java.lang.Override
      public Builder newBuilderForType() {
        return newBuilder();
      }

      public static Builder newBuilder() {
        return DEFAULT_INSTANCE.toBuilder();
      }

      public static Builder newBuilder(
          com.google.cloud.aiplatform.v1beta1.MigrateResourceRequest
                  .MigrateDataLabelingDatasetConfig.MigrateDataLabelingAnnotatedDatasetConfig
              prototype) {
        return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
      }

      @java.lang.Override
      public Builder toBuilder() {
        return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
      }

      @java.lang.Override
      protected Builder newBuilderForType(
          com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
        Builder builder = new Builder(parent);
        return builder;
      }
      /**
       *
       *
       * <pre>
       * Config for migrating AnnotatedDataset in datalabeling.googleapis.com to
       * Vertex AI's SavedQuery.
       * </pre>
       *
       * Protobuf type {@code
       * google.cloud.aiplatform.v1beta1.MigrateResourceRequest.MigrateDataLabelingDatasetConfig.MigrateDataLabelingAnnotatedDatasetConfig}
       */
      public static final class Builder
          extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
          implements
          // @@protoc_insertion_point(builder_implements:google.cloud.aiplatform.v1beta1.MigrateResourceRequest.MigrateDataLabelingDatasetConfig.MigrateDataLabelingAnnotatedDatasetConfig)
          com.google.cloud.aiplatform.v1beta1.MigrateResourceRequest
              .MigrateDataLabelingDatasetConfig.MigrateDataLabelingAnnotatedDatasetConfigOrBuilder {
        public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
          return com.google.cloud.aiplatform.v1beta1.MigrationServiceProto
              .internal_static_google_cloud_aiplatform_v1beta1_MigrateResourceRequest_MigrateDataLabelingDatasetConfig_MigrateDataLabelingAnnotatedDatasetConfig_descriptor;
        }

        @java.lang.Override
        protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
            internalGetFieldAccessorTable() {
          return com.google.cloud.aiplatform.v1beta1.MigrationServiceProto
              .internal_static_google_cloud_aiplatform_v1beta1_MigrateResourceRequest_MigrateDataLabelingDatasetConfig_MigrateDataLabelingAnnotatedDatasetConfig_fieldAccessorTable
              .ensureFieldAccessorsInitialized(
                  com.google.cloud.aiplatform.v1beta1.MigrateResourceRequest
                      .MigrateDataLabelingDatasetConfig.MigrateDataLabelingAnnotatedDatasetConfig
                      .class,
                  com.google.cloud.aiplatform.v1beta1.MigrateResourceRequest
                      .MigrateDataLabelingDatasetConfig.MigrateDataLabelingAnnotatedDatasetConfig
                      .Builder.class);
        }

        // Construct using
        // com.google.cloud.aiplatform.v1beta1.MigrateResourceRequest.MigrateDataLabelingDatasetConfig.MigrateDataLabelingAnnotatedDatasetConfig.newBuilder()
        private Builder() {
          maybeForceBuilderInitialization();
        }

        private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
          super(parent);
          maybeForceBuilderInitialization();
        }

        private void maybeForceBuilderInitialization() {
          if (com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders) {}
        }

        @java.lang.Override
        public Builder clear() {
          super.clear();
          annotatedDataset_ = "";

          return this;
        }

        @java.lang.Override
        public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
          return com.google.cloud.aiplatform.v1beta1.MigrationServiceProto
              .internal_static_google_cloud_aiplatform_v1beta1_MigrateResourceRequest_MigrateDataLabelingDatasetConfig_MigrateDataLabelingAnnotatedDatasetConfig_descriptor;
        }

        @java.lang.Override
        public com.google.cloud.aiplatform.v1beta1.MigrateResourceRequest
                .MigrateDataLabelingDatasetConfig.MigrateDataLabelingAnnotatedDatasetConfig
            getDefaultInstanceForType() {
          return com.google.cloud.aiplatform.v1beta1.MigrateResourceRequest
              .MigrateDataLabelingDatasetConfig.MigrateDataLabelingAnnotatedDatasetConfig
              .getDefaultInstance();
        }

        @java.lang.Override
        public com.google.cloud.aiplatform.v1beta1.MigrateResourceRequest
                .MigrateDataLabelingDatasetConfig.MigrateDataLabelingAnnotatedDatasetConfig
            build() {
          com.google.cloud.aiplatform.v1beta1.MigrateResourceRequest
                  .MigrateDataLabelingDatasetConfig.MigrateDataLabelingAnnotatedDatasetConfig
              result = buildPartial();
          if (!result.isInitialized()) {
            throw newUninitializedMessageException(result);
          }
          return result;
        }

        @java.lang.Override
        public com.google.cloud.aiplatform.v1beta1.MigrateResourceRequest
                .MigrateDataLabelingDatasetConfig.MigrateDataLabelingAnnotatedDatasetConfig
            buildPartial() {
          com.google.cloud.aiplatform.v1beta1.MigrateResourceRequest
                  .MigrateDataLabelingDatasetConfig.MigrateDataLabelingAnnotatedDatasetConfig
              result =
                  new com.google.cloud.aiplatform.v1beta1.MigrateResourceRequest
                      .MigrateDataLabelingDatasetConfig.MigrateDataLabelingAnnotatedDatasetConfig(
                      this);
          result.annotatedDataset_ = annotatedDataset_;
          onBuilt();
          return result;
        }

        @java.lang.Override
        public Builder clone() {
          return super.clone();
        }

        @java.lang.Override
        public Builder setField(
            com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
          return super.setField(field, value);
        }

        @java.lang.Override
        public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
          return super.clearField(field);
        }

        @java.lang.Override
        public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
          return super.clearOneof(oneof);
        }

        @java.lang.Override
        public Builder setRepeatedField(
            com.google.protobuf.Descriptors.FieldDescriptor field,
            int index,
            java.lang.Object value) {
          return super.setRepeatedField(field, index, value);
        }

        @java.lang.Override
        public Builder addRepeatedField(
            com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
          return super.addRepeatedField(field, value);
        }

        @java.lang.Override
        public Builder mergeFrom(com.google.protobuf.Message other) {
          if (other
              instanceof
              com.google.cloud.aiplatform.v1beta1.MigrateResourceRequest
                  .MigrateDataLabelingDatasetConfig.MigrateDataLabelingAnnotatedDatasetConfig) {
            return mergeFrom(
                (com.google.cloud.aiplatform.v1beta1.MigrateResourceRequest
                        .MigrateDataLabelingDatasetConfig.MigrateDataLabelingAnnotatedDatasetConfig)
                    other);
          } else {
            super.mergeFrom(other);
            return this;
          }
        }

        public Builder mergeFrom(
            com.google.cloud.aiplatform.v1beta1.MigrateResourceRequest
                    .MigrateDataLabelingDatasetConfig.MigrateDataLabelingAnnotatedDatasetConfig
                other) {
          if (other
              == com.google.cloud.aiplatform.v1beta1.MigrateResourceRequest
                  .MigrateDataLabelingDatasetConfig.MigrateDataLabelingAnnotatedDatasetConfig
                  .getDefaultInstance()) return this;
          if (!other.getAnnotatedDataset().isEmpty()) {
            annotatedDataset_ = other.annotatedDataset_;
            onChanged();
          }
          this.mergeUnknownFields(other.unknownFields);
          onChanged();
          return this;
        }

        @java.lang.Override
        public final boolean isInitialized() {
          return true;
        }

        @java.lang.Override
        public Builder mergeFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws java.io.IOException {
          com.google.cloud.aiplatform.v1beta1.MigrateResourceRequest
                  .MigrateDataLabelingDatasetConfig.MigrateDataLabelingAnnotatedDatasetConfig
              parsedMessage = null;
          try {
            parsedMessage = PARSER.parsePartialFrom(input, extensionRegistry);
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            parsedMessage =
                (com.google.cloud.aiplatform.v1beta1.MigrateResourceRequest
                        .MigrateDataLabelingDatasetConfig.MigrateDataLabelingAnnotatedDatasetConfig)
                    e.getUnfinishedMessage();
            throw e.unwrapIOException();
          } finally {
            if (parsedMessage != null) {
              mergeFrom(parsedMessage);
            }
          }
          return this;
        }

        private java.lang.Object annotatedDataset_ = "";
        /**
         *
         *
         * <pre>
         * Required. Full resource name of data labeling AnnotatedDataset.
         * Format:
         * `projects/{project}/datasets/{dataset}/annotatedDatasets/{annotated_dataset}`.
         * </pre>
         *
         * <code>
         * string annotated_dataset = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
         * </code>
         *
         * @return The annotatedDataset.
         */
        public java.lang.String getAnnotatedDataset() {
          java.lang.Object ref = annotatedDataset_;
          if (!(ref instanceof java.lang.String)) {
            com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
            java.lang.String s = bs.toStringUtf8();
            annotatedDataset_ = s;
            return s;
          } else {
            return (java.lang.String) ref;
          }
        }
        /**
         *
         *
         * <pre>
         * Required. Full resource name of data labeling AnnotatedDataset.
         * Format:
         * `projects/{project}/datasets/{dataset}/annotatedDatasets/{annotated_dataset}`.
         * </pre>
         *
         * <code>
         * string annotated_dataset = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
         * </code>
         *
         * @return The bytes for annotatedDataset.
         */
        public com.google.protobuf.ByteString getAnnotatedDatasetBytes() {
          java.lang.Object ref = annotatedDataset_;
          if (ref instanceof String) {
            com.google.protobuf.ByteString b =
                com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
            annotatedDataset_ = b;
            return b;
          } else {
            return (com.google.protobuf.ByteString) ref;
          }
        }
        /**
         *
         *
         * <pre>
         * Required. Full resource name of data labeling AnnotatedDataset.
         * Format:
         * `projects/{project}/datasets/{dataset}/annotatedDatasets/{annotated_dataset}`.
         * </pre>
         *
         * <code>
         * string annotated_dataset = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
         * </code>
         *
         * @param value The annotatedDataset to set.
         * @return This builder for chaining.
         */
        public Builder setAnnotatedDataset(java.lang.String value) {
          if (value == null) {
            throw new NullPointerException();
          }

          annotatedDataset_ = value;
          onChanged();
          return this;
        }
        /**
         *
         *
         * <pre>
         * Required. Full resource name of data labeling AnnotatedDataset.
         * Format:
         * `projects/{project}/datasets/{dataset}/annotatedDatasets/{annotated_dataset}`.
         * </pre>
         *
         * <code>
         * string annotated_dataset = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
         * </code>
         *
         * @return This builder for chaining.
         */
        public Builder clearAnnotatedDataset() {

          annotatedDataset_ = getDefaultInstance().getAnnotatedDataset();
          onChanged();
          return this;
        }
        /**
         *
         *
         * <pre>
         * Required. Full resource name of data labeling AnnotatedDataset.
         * Format:
         * `projects/{project}/datasets/{dataset}/annotatedDatasets/{annotated_dataset}`.
         * </pre>
         *
         * <code>
         * string annotated_dataset = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
         * </code>
         *
         * @param value The bytes for annotatedDataset to set.
         * @return This builder for chaining.
         */
        public Builder setAnnotatedDatasetBytes(com.google.protobuf.ByteString value) {
          if (value == null) {
            throw new NullPointerException();
          }
          checkByteStringIsUtf8(value);

          annotatedDataset_ = value;
          onChanged();
          return this;
        }

        @java.lang.Override
        public final Builder setUnknownFields(
            final com.google.protobuf.UnknownFieldSet unknownFields) {
          return super.setUnknownFields(unknownFields);
        }

        @java.lang.Override
        public final Builder mergeUnknownFields(
            final com.google.protobuf.UnknownFieldSet unknownFields) {
          return super.mergeUnknownFields(unknownFields);
        }

        // @@protoc_insertion_point(builder_scope:google.cloud.aiplatform.v1beta1.MigrateResourceRequest.MigrateDataLabelingDatasetConfig.MigrateDataLabelingAnnotatedDatasetConfig)
      }

      // @@protoc_insertion_point(class_scope:google.cloud.aiplatform.v1beta1.MigrateResourceRequest.MigrateDataLabelingDatasetConfig.MigrateDataLabelingAnnotatedDatasetConfig)
      private static final com.google.cloud.aiplatform.v1beta1.MigrateResourceRequest
              .MigrateDataLabelingDatasetConfig.MigrateDataLabelingAnnotatedDatasetConfig
          DEFAULT_INSTANCE;

      static {
        DEFAULT_INSTANCE =
            new com.google.cloud.aiplatform.v1beta1.MigrateResourceRequest
                .MigrateDataLabelingDatasetConfig.MigrateDataLabelingAnnotatedDatasetConfig();
      }

      public static com.google.cloud.aiplatform.v1beta1.MigrateResourceRequest
              .MigrateDataLabelingDatasetConfig.MigrateDataLabelingAnnotatedDatasetConfig
          getDefaultInstance() {
        return DEFAULT_INSTANCE;
      }

      private static final com.google.protobuf.Parser<MigrateDataLabelingAnnotatedDatasetConfig>
          PARSER =
              new com.google.protobuf.AbstractParser<MigrateDataLabelingAnnotatedDatasetConfig>() {
                @java.lang.Override
                public MigrateDataLabelingAnnotatedDatasetConfig parsePartialFrom(
                    com.google.protobuf.CodedInputStream input,
                    com.google.protobuf.ExtensionRegistryLite extensionRegistry)
                    throws com.google.protobuf.InvalidProtocolBufferException {
                  return new MigrateDataLabelingAnnotatedDatasetConfig(input, extensionRegistry);
                }
              };

      public static com.google.protobuf.Parser<MigrateDataLabelingAnnotatedDatasetConfig> parser() {
        return PARSER;
      }

      @java.lang.Override
      public com.google.protobuf.Parser<MigrateDataLabelingAnnotatedDatasetConfig>
          getParserForType() {
        return PARSER;
      }

      @java.lang.Override
      public com.google.cloud.aiplatform.v1beta1.MigrateResourceRequest
              .MigrateDataLabelingDatasetConfig.MigrateDataLabelingAnnotatedDatasetConfig
          getDefaultInstanceForType() {
        return DEFAULT_INSTANCE;
      }
    }

    public static final int DATASET_FIELD_NUMBER = 1;
    private volatile java.lang.Object dataset_;
    /**
     *
     *
     * <pre>
     * Required. Full resource name of data labeling Dataset.
     * Format:
     * `projects/{project}/datasets/{dataset}`.
     * </pre>
     *
     * <code>
     * string dataset = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @return The dataset.
     */
    @java.lang.Override
    public java.lang.String getDataset() {
      java.lang.Object ref = dataset_;
      if (ref instanceof java.lang.String) {
        return (java.lang.String) ref;
      } else {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        dataset_ = s;
        return s;
      }
    }
    /**
     *
     *
     * <pre>
     * Required. Full resource name of data labeling Dataset.
     * Format:
     * `projects/{project}/datasets/{dataset}`.
     * </pre>
     *
     * <code>
     * string dataset = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @return The bytes for dataset.
     */
    @java.lang.Override
    public com.google.protobuf.ByteString getDatasetBytes() {
      java.lang.Object ref = dataset_;
      if (ref instanceof java.lang.String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        dataset_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    public static final int DATASET_DISPLAY_NAME_FIELD_NUMBER = 2;
    private volatile java.lang.Object datasetDisplayName_;
    /**
     *
     *
     * <pre>
     * Optional. Display name of the Dataset in Vertex AI.
     * System will pick a display name if unspecified.
     * </pre>
     *
     * <code>string dataset_display_name = 2 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return The datasetDisplayName.
     */
    @java.lang.Override
    public java.lang.String getDatasetDisplayName() {
      java.lang.Object ref = datasetDisplayName_;
      if (ref instanceof java.lang.String) {
        return (java.lang.String) ref;
      } else {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        datasetDisplayName_ = s;
        return s;
      }
    }
    /**
     *
     *
     * <pre>
     * Optional. Display name of the Dataset in Vertex AI.
     * System will pick a display name if unspecified.
     * </pre>
     *
     * <code>string dataset_display_name = 2 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return The bytes for datasetDisplayName.
     */
    @java.lang.Override
    public com.google.protobuf.ByteString getDatasetDisplayNameBytes() {
      java.lang.Object ref = datasetDisplayName_;
      if (ref instanceof java.lang.String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        datasetDisplayName_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    public static final int MIGRATE_DATA_LABELING_ANNOTATED_DATASET_CONFIGS_FIELD_NUMBER = 3;
    private java.util.List<
            com.google.cloud.aiplatform.v1beta1.MigrateResourceRequest
                .MigrateDataLabelingDatasetConfig.MigrateDataLabelingAnnotatedDatasetConfig>
        migrateDataLabelingAnnotatedDatasetConfigs_;
    /**
     *
     *
     * <pre>
     * Optional. Configs for migrating AnnotatedDataset in datalabeling.googleapis.com to
     * Vertex AI's SavedQuery. The specified AnnotatedDatasets have to belong
     * to the datalabeling Dataset.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.aiplatform.v1beta1.MigrateResourceRequest.MigrateDataLabelingDatasetConfig.MigrateDataLabelingAnnotatedDatasetConfig migrate_data_labeling_annotated_dataset_configs = 3 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    @java.lang.Override
    public java.util.List<
            com.google.cloud.aiplatform.v1beta1.MigrateResourceRequest
                .MigrateDataLabelingDatasetConfig.MigrateDataLabelingAnnotatedDatasetConfig>
        getMigrateDataLabelingAnnotatedDatasetConfigsList() {
      return migrateDataLabelingAnnotatedDatasetConfigs_;
    }
    /**
     *
     *
     * <pre>
     * Optional. Configs for migrating AnnotatedDataset in datalabeling.googleapis.com to
     * Vertex AI's SavedQuery. The specified AnnotatedDatasets have to belong
     * to the datalabeling Dataset.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.aiplatform.v1beta1.MigrateResourceRequest.MigrateDataLabelingDatasetConfig.MigrateDataLabelingAnnotatedDatasetConfig migrate_data_labeling_annotated_dataset_configs = 3 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    @java.lang.Override
    public java.util.List<
            ? extends
                com.google.cloud.aiplatform.v1beta1.MigrateResourceRequest
                    .MigrateDataLabelingDatasetConfig
                    .MigrateDataLabelingAnnotatedDatasetConfigOrBuilder>
        getMigrateDataLabelingAnnotatedDatasetConfigsOrBuilderList() {
      return migrateDataLabelingAnnotatedDatasetConfigs_;
    }
    /**
     *
     *
     * <pre>
     * Optional. Configs for migrating AnnotatedDataset in datalabeling.googleapis.com to
     * Vertex AI's SavedQuery. The specified AnnotatedDatasets have to belong
     * to the datalabeling Dataset.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.aiplatform.v1beta1.MigrateResourceRequest.MigrateDataLabelingDatasetConfig.MigrateDataLabelingAnnotatedDatasetConfig migrate_data_labeling_annotated_dataset_configs = 3 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    @java.lang.Override
    public int getMigrateDataLabelingAnnotatedDatasetConfigsCount() {
      return migrateDataLabelingAnnotatedDatasetConfigs_.size();
    }
    /**
     *
     *
     * <pre>
     * Optional. Configs for migrating AnnotatedDataset in datalabeling.googleapis.com to
     * Vertex AI's SavedQuery. The specified AnnotatedDatasets have to belong
     * to the datalabeling Dataset.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.aiplatform.v1beta1.MigrateResourceRequest.MigrateDataLabelingDatasetConfig.MigrateDataLabelingAnnotatedDatasetConfig migrate_data_labeling_annotated_dataset_configs = 3 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    @java.lang.Override
    public com.google.cloud.aiplatform.v1beta1.MigrateResourceRequest
            .MigrateDataLabelingDatasetConfig.MigrateDataLabelingAnnotatedDatasetConfig
        getMigrateDataLabelingAnnotatedDatasetConfigs(int index) {
      return migrateDataLabelingAnnotatedDatasetConfigs_.get(index);
    }
    /**
     *
     *
     * <pre>
     * Optional. Configs for migrating AnnotatedDataset in datalabeling.googleapis.com to
     * Vertex AI's SavedQuery. The specified AnnotatedDatasets have to belong
     * to the datalabeling Dataset.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.aiplatform.v1beta1.MigrateResourceRequest.MigrateDataLabelingDatasetConfig.MigrateDataLabelingAnnotatedDatasetConfig migrate_data_labeling_annotated_dataset_configs = 3 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    @java.lang.Override
    public com.google.cloud.aiplatform.v1beta1.MigrateResourceRequest
            .MigrateDataLabelingDatasetConfig.MigrateDataLabelingAnnotatedDatasetConfigOrBuilder
        getMigrateDataLabelingAnnotatedDatasetConfigsOrBuilder(int index) {
      return migrateDataLabelingAnnotatedDatasetConfigs_.get(index);
    }

    private byte memoizedIsInitialized = -1;

    @java.lang.Override
    public final boolean isInitialized() {
      byte isInitialized = memoizedIsInitialized;
      if (isInitialized == 1) return true;
      if (isInitialized == 0) return false;

      memoizedIsInitialized = 1;
      return true;
    }

    @java.lang.Override
    public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
      if (!getDatasetBytes().isEmpty()) {
        com.google.protobuf.GeneratedMessageV3.writeString(output, 1, dataset_);
      }
      if (!getDatasetDisplayNameBytes().isEmpty()) {
        com.google.protobuf.GeneratedMessageV3.writeString(output, 2, datasetDisplayName_);
      }
      for (int i = 0; i < migrateDataLabelingAnnotatedDatasetConfigs_.size(); i++) {
        output.writeMessage(3, migrateDataLabelingAnnotatedDatasetConfigs_.get(i));
      }
      unknownFields.writeTo(output);
    }

    @java.lang.Override
    public int getSerializedSize() {
      int size = memoizedSize;
      if (size != -1) return size;

      size = 0;
      if (!getDatasetBytes().isEmpty()) {
        size += com.google.protobuf.GeneratedMessageV3.computeStringSize(1, dataset_);
      }
      if (!getDatasetDisplayNameBytes().isEmpty()) {
        size += com.google.protobuf.GeneratedMessageV3.computeStringSize(2, datasetDisplayName_);
      }
      for (int i = 0; i < migrateDataLabelingAnnotatedDatasetConfigs_.size(); i++) {
        size +=
            com.google.protobuf.CodedOutputStream.computeMessageSize(
                3, migrateDataLabelingAnnotatedDatasetConfigs_.get(i));
      }
      size += unknownFields.getSerializedSize();
      memoizedSize = size;
      return size;
    }

    @java.lang.Override
    public boolean equals(final java.lang.Object obj) {
      if (obj == this) {
        return true;
      }
      if (!(obj
          instanceof
          com.google.cloud.aiplatform.v1beta1.MigrateResourceRequest
              .MigrateDataLabelingDatasetConfig)) {
        return super.equals(obj);
      }
      com.google.cloud.aiplatform.v1beta1.MigrateResourceRequest.MigrateDataLabelingDatasetConfig
          other =
              (com.google.cloud.aiplatform.v1beta1.MigrateResourceRequest
                      .MigrateDataLabelingDatasetConfig)
                  obj;

      if (!getDataset().equals(other.getDataset())) return false;
      if (!getDatasetDisplayName().equals(other.getDatasetDisplayName())) return false;
      if (!getMigrateDataLabelingAnnotatedDatasetConfigsList()
          .equals(other.getMigrateDataLabelingAnnotatedDatasetConfigsList())) return false;
      if (!unknownFields.equals(other.unknownFields)) return false;
      return true;
    }

    @java.lang.Override
    public int hashCode() {
      if (memoizedHashCode != 0) {
        return memoizedHashCode;
      }
      int hash = 41;
      hash = (19 * hash) + getDescriptor().hashCode();
      hash = (37 * hash) + DATASET_FIELD_NUMBER;
      hash = (53 * hash) + getDataset().hashCode();
      hash = (37 * hash) + DATASET_DISPLAY_NAME_FIELD_NUMBER;
      hash = (53 * hash) + getDatasetDisplayName().hashCode();
      if (getMigrateDataLabelingAnnotatedDatasetConfigsCount() > 0) {
        hash = (37 * hash) + MIGRATE_DATA_LABELING_ANNOTATED_DATASET_CONFIGS_FIELD_NUMBER;
        hash = (53 * hash) + getMigrateDataLabelingAnnotatedDatasetConfigsList().hashCode();
      }
      hash = (29 * hash) + unknownFields.hashCode();
      memoizedHashCode = hash;
      return hash;
    }

    public static com.google.cloud.aiplatform.v1beta1.MigrateResourceRequest
            .MigrateDataLabelingDatasetConfig
        parseFrom(java.nio.ByteBuffer data)
            throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.aiplatform.v1beta1.MigrateResourceRequest
            .MigrateDataLabelingDatasetConfig
        parseFrom(
            java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.aiplatform.v1beta1.MigrateResourceRequest
            .MigrateDataLabelingDatasetConfig
        parseFrom(com.google.protobuf.ByteString data)
            throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.aiplatform.v1beta1.MigrateResourceRequest
            .MigrateDataLabelingDatasetConfig
        parseFrom(
            com.google.protobuf.ByteString data,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.aiplatform.v1beta1.MigrateResourceRequest
            .MigrateDataLabelingDatasetConfig
        parseFrom(byte[] data) throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.aiplatform.v1beta1.MigrateResourceRequest
            .MigrateDataLabelingDatasetConfig
        parseFrom(byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.aiplatform.v1beta1.MigrateResourceRequest
            .MigrateDataLabelingDatasetConfig
        parseFrom(java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.cloud.aiplatform.v1beta1.MigrateResourceRequest
            .MigrateDataLabelingDatasetConfig
        parseFrom(
            java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.cloud.aiplatform.v1beta1.MigrateResourceRequest
            .MigrateDataLabelingDatasetConfig
        parseDelimitedFrom(java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
    }

    public static com.google.cloud.aiplatform.v1beta1.MigrateResourceRequest
            .MigrateDataLabelingDatasetConfig
        parseDelimitedFrom(
            java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.cloud.aiplatform.v1beta1.MigrateResourceRequest
            .MigrateDataLabelingDatasetConfig
        parseFrom(com.google.protobuf.CodedInputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.cloud.aiplatform.v1beta1.MigrateResourceRequest
            .MigrateDataLabelingDatasetConfig
        parseFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    @java.lang.Override
    public Builder newBuilderForType() {
      return newBuilder();
    }

    public static Builder newBuilder() {
      return DEFAULT_INSTANCE.toBuilder();
    }

    public static Builder newBuilder(
        com.google.cloud.aiplatform.v1beta1.MigrateResourceRequest.MigrateDataLabelingDatasetConfig
            prototype) {
      return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }

    @java.lang.Override
    public Builder toBuilder() {
      return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
    }

    @java.lang.Override
    protected Builder newBuilderForType(
        com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      Builder builder = new Builder(parent);
      return builder;
    }
    /**
     *
     *
     * <pre>
     * Config for migrating Dataset in datalabeling.googleapis.com to Vertex
     * AI's Dataset.
     * </pre>
     *
     * Protobuf type {@code
     * google.cloud.aiplatform.v1beta1.MigrateResourceRequest.MigrateDataLabelingDatasetConfig}
     */
    public static final class Builder
        extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
        implements
        // @@protoc_insertion_point(builder_implements:google.cloud.aiplatform.v1beta1.MigrateResourceRequest.MigrateDataLabelingDatasetConfig)
        com.google.cloud.aiplatform.v1beta1.MigrateResourceRequest
            .MigrateDataLabelingDatasetConfigOrBuilder {
      public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
        return com.google.cloud.aiplatform.v1beta1.MigrationServiceProto
            .internal_static_google_cloud_aiplatform_v1beta1_MigrateResourceRequest_MigrateDataLabelingDatasetConfig_descriptor;
      }

      @java.lang.Override
      protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return com.google.cloud.aiplatform.v1beta1.MigrationServiceProto
            .internal_static_google_cloud_aiplatform_v1beta1_MigrateResourceRequest_MigrateDataLabelingDatasetConfig_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                com.google.cloud.aiplatform.v1beta1.MigrateResourceRequest
                    .MigrateDataLabelingDatasetConfig.class,
                com.google.cloud.aiplatform.v1beta1.MigrateResourceRequest
                    .MigrateDataLabelingDatasetConfig.Builder.class);
      }

      // Construct using
      // com.google.cloud.aiplatform.v1beta1.MigrateResourceRequest.MigrateDataLabelingDatasetConfig.newBuilder()
      private Builder() {
        maybeForceBuilderInitialization();
      }

      private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
        super(parent);
        maybeForceBuilderInitialization();
      }

      private void maybeForceBuilderInitialization() {
        if (com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders) {
          getMigrateDataLabelingAnnotatedDatasetConfigsFieldBuilder();
        }
      }

      @java.lang.Override
      public Builder clear() {
        super.clear();
        dataset_ = "";

        datasetDisplayName_ = "";

        if (migrateDataLabelingAnnotatedDatasetConfigsBuilder_ == null) {
          migrateDataLabelingAnnotatedDatasetConfigs_ = java.util.Collections.emptyList();
          bitField0_ = (bitField0_ & ~0x00000001);
        } else {
          migrateDataLabelingAnnotatedDatasetConfigsBuilder_.clear();
        }
        return this;
      }

      @java.lang.Override
      public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
        return com.google.cloud.aiplatform.v1beta1.MigrationServiceProto
            .internal_static_google_cloud_aiplatform_v1beta1_MigrateResourceRequest_MigrateDataLabelingDatasetConfig_descriptor;
      }

      @java.lang.Override
      public com.google.cloud.aiplatform.v1beta1.MigrateResourceRequest
              .MigrateDataLabelingDatasetConfig
          getDefaultInstanceForType() {
        return com.google.cloud.aiplatform.v1beta1.MigrateResourceRequest
            .MigrateDataLabelingDatasetConfig.getDefaultInstance();
      }

      @java.lang.Override
      public com.google.cloud.aiplatform.v1beta1.MigrateResourceRequest
              .MigrateDataLabelingDatasetConfig
          build() {
        com.google.cloud.aiplatform.v1beta1.MigrateResourceRequest.MigrateDataLabelingDatasetConfig
            result = buildPartial();
        if (!result.isInitialized()) {
          throw newUninitializedMessageException(result);
        }
        return result;
      }

      @java.lang.Override
      public com.google.cloud.aiplatform.v1beta1.MigrateResourceRequest
              .MigrateDataLabelingDatasetConfig
          buildPartial() {
        com.google.cloud.aiplatform.v1beta1.MigrateResourceRequest.MigrateDataLabelingDatasetConfig
            result =
                new com.google.cloud.aiplatform.v1beta1.MigrateResourceRequest
                    .MigrateDataLabelingDatasetConfig(this);
        int from_bitField0_ = bitField0_;
        result.dataset_ = dataset_;
        result.datasetDisplayName_ = datasetDisplayName_;
        if (migrateDataLabelingAnnotatedDatasetConfigsBuilder_ == null) {
          if (((bitField0_ & 0x00000001) != 0)) {
            migrateDataLabelingAnnotatedDatasetConfigs_ =
                java.util.Collections.unmodifiableList(migrateDataLabelingAnnotatedDatasetConfigs_);
            bitField0_ = (bitField0_ & ~0x00000001);
          }
          result.migrateDataLabelingAnnotatedDatasetConfigs_ =
              migrateDataLabelingAnnotatedDatasetConfigs_;
        } else {
          result.migrateDataLabelingAnnotatedDatasetConfigs_ =
              migrateDataLabelingAnnotatedDatasetConfigsBuilder_.build();
        }
        onBuilt();
        return result;
      }

      @java.lang.Override
      public Builder clone() {
        return super.clone();
      }

      @java.lang.Override
      public Builder setField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.setField(field, value);
      }

      @java.lang.Override
      public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
        return super.clearField(field);
      }

      @java.lang.Override
      public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
        return super.clearOneof(oneof);
      }

      @java.lang.Override
      public Builder setRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          int index,
          java.lang.Object value) {
        return super.setRepeatedField(field, index, value);
      }

      @java.lang.Override
      public Builder addRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.addRepeatedField(field, value);
      }

      @java.lang.Override
      public Builder mergeFrom(com.google.protobuf.Message other) {
        if (other
            instanceof
            com.google.cloud.aiplatform.v1beta1.MigrateResourceRequest
                .MigrateDataLabelingDatasetConfig) {
          return mergeFrom(
              (com.google.cloud.aiplatform.v1beta1.MigrateResourceRequest
                      .MigrateDataLabelingDatasetConfig)
                  other);
        } else {
          super.mergeFrom(other);
          return this;
        }
      }

      public Builder mergeFrom(
          com.google.cloud.aiplatform.v1beta1.MigrateResourceRequest
                  .MigrateDataLabelingDatasetConfig
              other) {
        if (other
            == com.google.cloud.aiplatform.v1beta1.MigrateResourceRequest
                .MigrateDataLabelingDatasetConfig.getDefaultInstance()) return this;
        if (!other.getDataset().isEmpty()) {
          dataset_ = other.dataset_;
          onChanged();
        }
        if (!other.getDatasetDisplayName().isEmpty()) {
          datasetDisplayName_ = other.datasetDisplayName_;
          onChanged();
        }
        if (migrateDataLabelingAnnotatedDatasetConfigsBuilder_ == null) {
          if (!other.migrateDataLabelingAnnotatedDatasetConfigs_.isEmpty()) {
            if (migrateDataLabelingAnnotatedDatasetConfigs_.isEmpty()) {
              migrateDataLabelingAnnotatedDatasetConfigs_ =
                  other.migrateDataLabelingAnnotatedDatasetConfigs_;
              bitField0_ = (bitField0_ & ~0x00000001);
            } else {
              ensureMigrateDataLabelingAnnotatedDatasetConfigsIsMutable();
              migrateDataLabelingAnnotatedDatasetConfigs_.addAll(
                  other.migrateDataLabelingAnnotatedDatasetConfigs_);
            }
            onChanged();
          }
        } else {
          if (!other.migrateDataLabelingAnnotatedDatasetConfigs_.isEmpty()) {
            if (migrateDataLabelingAnnotatedDatasetConfigsBuilder_.isEmpty()) {
              migrateDataLabelingAnnotatedDatasetConfigsBuilder_.dispose();
              migrateDataLabelingAnnotatedDatasetConfigsBuilder_ = null;
              migrateDataLabelingAnnotatedDatasetConfigs_ =
                  other.migrateDataLabelingAnnotatedDatasetConfigs_;
              bitField0_ = (bitField0_ & ~0x00000001);
              migrateDataLabelingAnnotatedDatasetConfigsBuilder_ =
                  com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders
                      ? getMigrateDataLabelingAnnotatedDatasetConfigsFieldBuilder()
                      : null;
            } else {
              migrateDataLabelingAnnotatedDatasetConfigsBuilder_.addAllMessages(
                  other.migrateDataLabelingAnnotatedDatasetConfigs_);
            }
          }
        }
        this.mergeUnknownFields(other.unknownFields);
        onChanged();
        return this;
      }

      @java.lang.Override
      public final boolean isInitialized() {
        return true;
      }

      @java.lang.Override
      public Builder mergeFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        com.google.cloud.aiplatform.v1beta1.MigrateResourceRequest.MigrateDataLabelingDatasetConfig
            parsedMessage = null;
        try {
          parsedMessage = PARSER.parsePartialFrom(input, extensionRegistry);
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          parsedMessage =
              (com.google.cloud.aiplatform.v1beta1.MigrateResourceRequest
                      .MigrateDataLabelingDatasetConfig)
                  e.getUnfinishedMessage();
          throw e.unwrapIOException();
        } finally {
          if (parsedMessage != null) {
            mergeFrom(parsedMessage);
          }
        }
        return this;
      }

      private int bitField0_;

      private java.lang.Object dataset_ = "";
      /**
       *
       *
       * <pre>
       * Required. Full resource name of data labeling Dataset.
       * Format:
       * `projects/{project}/datasets/{dataset}`.
       * </pre>
       *
       * <code>
       * string dataset = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
       * </code>
       *
       * @return The dataset.
       */
      public java.lang.String getDataset() {
        java.lang.Object ref = dataset_;
        if (!(ref instanceof java.lang.String)) {
          com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
          java.lang.String s = bs.toStringUtf8();
          dataset_ = s;
          return s;
        } else {
          return (java.lang.String) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * Required. Full resource name of data labeling Dataset.
       * Format:
       * `projects/{project}/datasets/{dataset}`.
       * </pre>
       *
       * <code>
       * string dataset = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
       * </code>
       *
       * @return The bytes for dataset.
       */
      public com.google.protobuf.ByteString getDatasetBytes() {
        java.lang.Object ref = dataset_;
        if (ref instanceof String) {
          com.google.protobuf.ByteString b =
              com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
          dataset_ = b;
          return b;
        } else {
          return (com.google.protobuf.ByteString) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * Required. Full resource name of data labeling Dataset.
       * Format:
       * `projects/{project}/datasets/{dataset}`.
       * </pre>
       *
       * <code>
       * string dataset = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
       * </code>
       *
       * @param value The dataset to set.
       * @return This builder for chaining.
       */
      public Builder setDataset(java.lang.String value) {
        if (value == null) {
          throw new NullPointerException();
        }

        dataset_ = value;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Required. Full resource name of data labeling Dataset.
       * Format:
       * `projects/{project}/datasets/{dataset}`.
       * </pre>
       *
       * <code>
       * string dataset = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
       * </code>
       *
       * @return This builder for chaining.
       */
      public Builder clearDataset() {

        dataset_ = getDefaultInstance().getDataset();
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Required. Full resource name of data labeling Dataset.
       * Format:
       * `projects/{project}/datasets/{dataset}`.
       * </pre>
       *
       * <code>
       * string dataset = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
       * </code>
       *
       * @param value The bytes for dataset to set.
       * @return This builder for chaining.
       */
      public Builder setDatasetBytes(com.google.protobuf.ByteString value) {
        if (value == null) {
          throw new NullPointerException();
        }
        checkByteStringIsUtf8(value);

        dataset_ = value;
        onChanged();
        return this;
      }

      private java.lang.Object datasetDisplayName_ = "";
      /**
       *
       *
       * <pre>
       * Optional. Display name of the Dataset in Vertex AI.
       * System will pick a display name if unspecified.
       * </pre>
       *
       * <code>string dataset_display_name = 2 [(.google.api.field_behavior) = OPTIONAL];</code>
       *
       * @return The datasetDisplayName.
       */
      public java.lang.String getDatasetDisplayName() {
        java.lang.Object ref = datasetDisplayName_;
        if (!(ref instanceof java.lang.String)) {
          com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
          java.lang.String s = bs.toStringUtf8();
          datasetDisplayName_ = s;
          return s;
        } else {
          return (java.lang.String) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * Optional. Display name of the Dataset in Vertex AI.
       * System will pick a display name if unspecified.
       * </pre>
       *
       * <code>string dataset_display_name = 2 [(.google.api.field_behavior) = OPTIONAL];</code>
       *
       * @return The bytes for datasetDisplayName.
       */
      public com.google.protobuf.ByteString getDatasetDisplayNameBytes() {
        java.lang.Object ref = datasetDisplayName_;
        if (ref instanceof String) {
          com.google.protobuf.ByteString b =
              com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
          datasetDisplayName_ = b;
          return b;
        } else {
          return (com.google.protobuf.ByteString) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * Optional. Display name of the Dataset in Vertex AI.
       * System will pick a display name if unspecified.
       * </pre>
       *
       * <code>string dataset_display_name = 2 [(.google.api.field_behavior) = OPTIONAL];</code>
       *
       * @param value The datasetDisplayName to set.
       * @return This builder for chaining.
       */
      public Builder setDatasetDisplayName(java.lang.String value) {
        if (value == null) {
          throw new NullPointerException();
        }

        datasetDisplayName_ = value;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Optional. Display name of the Dataset in Vertex AI.
       * System will pick a display name if unspecified.
       * </pre>
       *
       * <code>string dataset_display_name = 2 [(.google.api.field_behavior) = OPTIONAL];</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearDatasetDisplayName() {

        datasetDisplayName_ = getDefaultInstance().getDatasetDisplayName();
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Optional. Display name of the Dataset in Vertex AI.
       * System will pick a display name if unspecified.
       * </pre>
       *
       * <code>string dataset_display_name = 2 [(.google.api.field_behavior) = OPTIONAL];</code>
       *
       * @param value The bytes for datasetDisplayName to set.
       * @return This builder for chaining.
       */
      public Builder setDatasetDisplayNameBytes(com.google.protobuf.ByteString value) {
        if (value == null) {
          throw new NullPointerException();
        }
        checkByteStringIsUtf8(value);

        datasetDisplayName_ = value;
        onChanged();
        return this;
      }

      private java.util.List<
              com.google.cloud.aiplatform.v1beta1.MigrateResourceRequest
                  .MigrateDataLabelingDatasetConfig.MigrateDataLabelingAnnotatedDatasetConfig>
          migrateDataLabelingAnnotatedDatasetConfigs_ = java.util.Collections.emptyList();

      private void ensureMigrateDataLabelingAnnotatedDatasetConfigsIsMutable() {
        if (!((bitField0_ & 0x00000001) != 0)) {
          migrateDataLabelingAnnotatedDatasetConfigs_ =
              new java.util.ArrayList<
                  com.google.cloud.aiplatform.v1beta1.MigrateResourceRequest
                      .MigrateDataLabelingDatasetConfig.MigrateDataLabelingAnnotatedDatasetConfig>(
                  migrateDataLabelingAnnotatedDatasetConfigs_);
          bitField0_ |= 0x00000001;
        }
      }

      private com.google.protobuf.RepeatedFieldBuilderV3<
              com.google.cloud.aiplatform.v1beta1.MigrateResourceRequest
                  .MigrateDataLabelingDatasetConfig.MigrateDataLabelingAnnotatedDatasetConfig,
              com.google.cloud.aiplatform.v1beta1.MigrateResourceRequest
                  .MigrateDataLabelingDatasetConfig.MigrateDataLabelingAnnotatedDatasetConfig
                  .Builder,
              com.google.cloud.aiplatform.v1beta1.MigrateResourceRequest
                  .MigrateDataLabelingDatasetConfig
                  .MigrateDataLabelingAnnotatedDatasetConfigOrBuilder>
          migrateDataLabelingAnnotatedDatasetConfigsBuilder_;

      /**
       *
       *
       * <pre>
       * Optional. Configs for migrating AnnotatedDataset in datalabeling.googleapis.com to
       * Vertex AI's SavedQuery. The specified AnnotatedDatasets have to belong
       * to the datalabeling Dataset.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.aiplatform.v1beta1.MigrateResourceRequest.MigrateDataLabelingDatasetConfig.MigrateDataLabelingAnnotatedDatasetConfig migrate_data_labeling_annotated_dataset_configs = 3 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       */
      public java.util.List<
              com.google.cloud.aiplatform.v1beta1.MigrateResourceRequest
                  .MigrateDataLabelingDatasetConfig.MigrateDataLabelingAnnotatedDatasetConfig>
          getMigrateDataLabelingAnnotatedDatasetConfigsList() {
        if (migrateDataLabelingAnnotatedDatasetConfigsBuilder_ == null) {
          return java.util.Collections.unmodifiableList(
              migrateDataLabelingAnnotatedDatasetConfigs_);
        } else {
          return migrateDataLabelingAnnotatedDatasetConfigsBuilder_.getMessageList();
        }
      }
      /**
       *
       *
       * <pre>
       * Optional. Configs for migrating AnnotatedDataset in datalabeling.googleapis.com to
       * Vertex AI's SavedQuery. The specified AnnotatedDatasets have to belong
       * to the datalabeling Dataset.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.aiplatform.v1beta1.MigrateResourceRequest.MigrateDataLabelingDatasetConfig.MigrateDataLabelingAnnotatedDatasetConfig migrate_data_labeling_annotated_dataset_configs = 3 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       */
      public int getMigrateDataLabelingAnnotatedDatasetConfigsCount() {
        if (migrateDataLabelingAnnotatedDatasetConfigsBuilder_ == null) {
          return migrateDataLabelingAnnotatedDatasetConfigs_.size();
        } else {
          return migrateDataLabelingAnnotatedDatasetConfigsBuilder_.getCount();
        }
      }
      /**
       *
       *
       * <pre>
       * Optional. Configs for migrating AnnotatedDataset in datalabeling.googleapis.com to
       * Vertex AI's SavedQuery. The specified AnnotatedDatasets have to belong
       * to the datalabeling Dataset.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.aiplatform.v1beta1.MigrateResourceRequest.MigrateDataLabelingDatasetConfig.MigrateDataLabelingAnnotatedDatasetConfig migrate_data_labeling_annotated_dataset_configs = 3 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       */
      public com.google.cloud.aiplatform.v1beta1.MigrateResourceRequest
              .MigrateDataLabelingDatasetConfig.MigrateDataLabelingAnnotatedDatasetConfig
          getMigrateDataLabelingAnnotatedDatasetConfigs(int index) {
        if (migrateDataLabelingAnnotatedDatasetConfigsBuilder_ == null) {
          return migrateDataLabelingAnnotatedDatasetConfigs_.get(index);
        } else {
          return migrateDataLabelingAnnotatedDatasetConfigsBuilder_.getMessage(index);
        }
      }
      /**
       *
       *
       * <pre>
       * Optional. Configs for migrating AnnotatedDataset in datalabeling.googleapis.com to
       * Vertex AI's SavedQuery. The specified AnnotatedDatasets have to belong
       * to the datalabeling Dataset.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.aiplatform.v1beta1.MigrateResourceRequest.MigrateDataLabelingDatasetConfig.MigrateDataLabelingAnnotatedDatasetConfig migrate_data_labeling_annotated_dataset_configs = 3 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       */
      public Builder setMigrateDataLabelingAnnotatedDatasetConfigs(
          int index,
          com.google.cloud.aiplatform.v1beta1.MigrateResourceRequest
                  .MigrateDataLabelingDatasetConfig.MigrateDataLabelingAnnotatedDatasetConfig
              value) {
        if (migrateDataLabelingAnnotatedDatasetConfigsBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          ensureMigrateDataLabelingAnnotatedDatasetConfigsIsMutable();
          migrateDataLabelingAnnotatedDatasetConfigs_.set(index, value);
          onChanged();
        } else {
          migrateDataLabelingAnnotatedDatasetConfigsBuilder_.setMessage(index, value);
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * Optional. Configs for migrating AnnotatedDataset in datalabeling.googleapis.com to
       * Vertex AI's SavedQuery. The specified AnnotatedDatasets have to belong
       * to the datalabeling Dataset.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.aiplatform.v1beta1.MigrateResourceRequest.MigrateDataLabelingDatasetConfig.MigrateDataLabelingAnnotatedDatasetConfig migrate_data_labeling_annotated_dataset_configs = 3 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       */
      public Builder setMigrateDataLabelingAnnotatedDatasetConfigs(
          int index,
          com.google.cloud.aiplatform.v1beta1.MigrateResourceRequest
                  .MigrateDataLabelingDatasetConfig.MigrateDataLabelingAnnotatedDatasetConfig
                  .Builder
              builderForValue) {
        if (migrateDataLabelingAnnotatedDatasetConfigsBuilder_ == null) {
          ensureMigrateDataLabelingAnnotatedDatasetConfigsIsMutable();
          migrateDataLabelingAnnotatedDatasetConfigs_.set(index, builderForValue.build());
          onChanged();
        } else {
          migrateDataLabelingAnnotatedDatasetConfigsBuilder_.setMessage(
              index, builderForValue.build());
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * Optional. Configs for migrating AnnotatedDataset in datalabeling.googleapis.com to
       * Vertex AI's SavedQuery. The specified AnnotatedDatasets have to belong
       * to the datalabeling Dataset.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.aiplatform.v1beta1.MigrateResourceRequest.MigrateDataLabelingDatasetConfig.MigrateDataLabelingAnnotatedDatasetConfig migrate_data_labeling_annotated_dataset_configs = 3 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       */
      public Builder addMigrateDataLabelingAnnotatedDatasetConfigs(
          com.google.cloud.aiplatform.v1beta1.MigrateResourceRequest
                  .MigrateDataLabelingDatasetConfig.MigrateDataLabelingAnnotatedDatasetConfig
              value) {
        if (migrateDataLabelingAnnotatedDatasetConfigsBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          ensureMigrateDataLabelingAnnotatedDatasetConfigsIsMutable();
          migrateDataLabelingAnnotatedDatasetConfigs_.add(value);
          onChanged();
        } else {
          migrateDataLabelingAnnotatedDatasetConfigsBuilder_.addMessage(value);
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * Optional. Configs for migrating AnnotatedDataset in datalabeling.googleapis.com to
       * Vertex AI's SavedQuery. The specified AnnotatedDatasets have to belong
       * to the datalabeling Dataset.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.aiplatform.v1beta1.MigrateResourceRequest.MigrateDataLabelingDatasetConfig.MigrateDataLabelingAnnotatedDatasetConfig migrate_data_labeling_annotated_dataset_configs = 3 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       */
      public Builder addMigrateDataLabelingAnnotatedDatasetConfigs(
          int index,
          com.google.cloud.aiplatform.v1beta1.MigrateResourceRequest
                  .MigrateDataLabelingDatasetConfig.MigrateDataLabelingAnnotatedDatasetConfig
              value) {
        if (migrateDataLabelingAnnotatedDatasetConfigsBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          ensureMigrateDataLabelingAnnotatedDatasetConfigsIsMutable();
          migrateDataLabelingAnnotatedDatasetConfigs_.add(index, value);
          onChanged();
        } else {
          migrateDataLabelingAnnotatedDatasetConfigsBuilder_.addMessage(index, value);
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * Optional. Configs for migrating AnnotatedDataset in datalabeling.googleapis.com to
       * Vertex AI's SavedQuery. The specified AnnotatedDatasets have to belong
       * to the datalabeling Dataset.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.aiplatform.v1beta1.MigrateResourceRequest.MigrateDataLabelingDatasetConfig.MigrateDataLabelingAnnotatedDatasetConfig migrate_data_labeling_annotated_dataset_configs = 3 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       */
      public Builder addMigrateDataLabelingAnnotatedDatasetConfigs(
          com.google.cloud.aiplatform.v1beta1.MigrateResourceRequest
                  .MigrateDataLabelingDatasetConfig.MigrateDataLabelingAnnotatedDatasetConfig
                  .Builder
              builderForValue) {
        if (migrateDataLabelingAnnotatedDatasetConfigsBuilder_ == null) {
          ensureMigrateDataLabelingAnnotatedDatasetConfigsIsMutable();
          migrateDataLabelingAnnotatedDatasetConfigs_.add(builderForValue.build());
          onChanged();
        } else {
          migrateDataLabelingAnnotatedDatasetConfigsBuilder_.addMessage(builderForValue.build());
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * Optional. Configs for migrating AnnotatedDataset in datalabeling.googleapis.com to
       * Vertex AI's SavedQuery. The specified AnnotatedDatasets have to belong
       * to the datalabeling Dataset.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.aiplatform.v1beta1.MigrateResourceRequest.MigrateDataLabelingDatasetConfig.MigrateDataLabelingAnnotatedDatasetConfig migrate_data_labeling_annotated_dataset_configs = 3 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       */
      public Builder addMigrateDataLabelingAnnotatedDatasetConfigs(
          int index,
          com.google.cloud.aiplatform.v1beta1.MigrateResourceRequest
                  .MigrateDataLabelingDatasetConfig.MigrateDataLabelingAnnotatedDatasetConfig
                  .Builder
              builderForValue) {
        if (migrateDataLabelingAnnotatedDatasetConfigsBuilder_ == null) {
          ensureMigrateDataLabelingAnnotatedDatasetConfigsIsMutable();
          migrateDataLabelingAnnotatedDatasetConfigs_.add(index, builderForValue.build());
          onChanged();
        } else {
          migrateDataLabelingAnnotatedDatasetConfigsBuilder_.addMessage(
              index, builderForValue.build());
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * Optional. Configs for migrating AnnotatedDataset in datalabeling.googleapis.com to
       * Vertex AI's SavedQuery. The specified AnnotatedDatasets have to belong
       * to the datalabeling Dataset.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.aiplatform.v1beta1.MigrateResourceRequest.MigrateDataLabelingDatasetConfig.MigrateDataLabelingAnnotatedDatasetConfig migrate_data_labeling_annotated_dataset_configs = 3 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       */
      public Builder addAllMigrateDataLabelingAnnotatedDatasetConfigs(
          java.lang.Iterable<
                  ? extends
                      com.google.cloud.aiplatform.v1beta1.MigrateResourceRequest
                          .MigrateDataLabelingDatasetConfig
                          .MigrateDataLabelingAnnotatedDatasetConfig>
              values) {
        if (migrateDataLabelingAnnotatedDatasetConfigsBuilder_ == null) {
          ensureMigrateDataLabelingAnnotatedDatasetConfigsIsMutable();
          com.google.protobuf.AbstractMessageLite.Builder.addAll(
              values, migrateDataLabelingAnnotatedDatasetConfigs_);
          onChanged();
        } else {
          migrateDataLabelingAnnotatedDatasetConfigsBuilder_.addAllMessages(values);
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * Optional. Configs for migrating AnnotatedDataset in datalabeling.googleapis.com to
       * Vertex AI's SavedQuery. The specified AnnotatedDatasets have to belong
       * to the datalabeling Dataset.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.aiplatform.v1beta1.MigrateResourceRequest.MigrateDataLabelingDatasetConfig.MigrateDataLabelingAnnotatedDatasetConfig migrate_data_labeling_annotated_dataset_configs = 3 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       */
      public Builder clearMigrateDataLabelingAnnotatedDatasetConfigs() {
        if (migrateDataLabelingAnnotatedDatasetConfigsBuilder_ == null) {
          migrateDataLabelingAnnotatedDatasetConfigs_ = java.util.Collections.emptyList();
          bitField0_ = (bitField0_ & ~0x00000001);
          onChanged();
        } else {
          migrateDataLabelingAnnotatedDatasetConfigsBuilder_.clear();
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * Optional. Configs for migrating AnnotatedDataset in datalabeling.googleapis.com to
       * Vertex AI's SavedQuery. The specified AnnotatedDatasets have to belong
       * to the datalabeling Dataset.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.aiplatform.v1beta1.MigrateResourceRequest.MigrateDataLabelingDatasetConfig.MigrateDataLabelingAnnotatedDatasetConfig migrate_data_labeling_annotated_dataset_configs = 3 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       */
      public Builder removeMigrateDataLabelingAnnotatedDatasetConfigs(int index) {
        if (migrateDataLabelingAnnotatedDatasetConfigsBuilder_ == null) {
          ensureMigrateDataLabelingAnnotatedDatasetConfigsIsMutable();
          migrateDataLabelingAnnotatedDatasetConfigs_.remove(index);
          onChanged();
        } else {
          migrateDataLabelingAnnotatedDatasetConfigsBuilder_.remove(index);
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * Optional. Configs for migrating AnnotatedDataset in datalabeling.googleapis.com to
       * Vertex AI's SavedQuery. The specified AnnotatedDatasets have to belong
       * to the datalabeling Dataset.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.aiplatform.v1beta1.MigrateResourceRequest.MigrateDataLabelingDatasetConfig.MigrateDataLabelingAnnotatedDatasetConfig migrate_data_labeling_annotated_dataset_configs = 3 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       */
      public com.google.cloud.aiplatform.v1beta1.MigrateResourceRequest
              .MigrateDataLabelingDatasetConfig.MigrateDataLabelingAnnotatedDatasetConfig.Builder
          getMigrateDataLabelingAnnotatedDatasetConfigsBuilder(int index) {
        return getMigrateDataLabelingAnnotatedDatasetConfigsFieldBuilder().getBuilder(index);
      }
      /**
       *
       *
       * <pre>
       * Optional. Configs for migrating AnnotatedDataset in datalabeling.googleapis.com to
       * Vertex AI's SavedQuery. The specified AnnotatedDatasets have to belong
       * to the datalabeling Dataset.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.aiplatform.v1beta1.MigrateResourceRequest.MigrateDataLabelingDatasetConfig.MigrateDataLabelingAnnotatedDatasetConfig migrate_data_labeling_annotated_dataset_configs = 3 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       */
      public com.google.cloud.aiplatform.v1beta1.MigrateResourceRequest
              .MigrateDataLabelingDatasetConfig.MigrateDataLabelingAnnotatedDatasetConfigOrBuilder
          getMigrateDataLabelingAnnotatedDatasetConfigsOrBuilder(int index) {
        if (migrateDataLabelingAnnotatedDatasetConfigsBuilder_ == null) {
          return migrateDataLabelingAnnotatedDatasetConfigs_.get(index);
        } else {
          return migrateDataLabelingAnnotatedDatasetConfigsBuilder_.getMessageOrBuilder(index);
        }
      }
      /**
       *
       *
       * <pre>
       * Optional. Configs for migrating AnnotatedDataset in datalabeling.googleapis.com to
       * Vertex AI's SavedQuery. The specified AnnotatedDatasets have to belong
       * to the datalabeling Dataset.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.aiplatform.v1beta1.MigrateResourceRequest.MigrateDataLabelingDatasetConfig.MigrateDataLabelingAnnotatedDatasetConfig migrate_data_labeling_annotated_dataset_configs = 3 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       */
      public java.util.List<
              ? extends
                  com.google.cloud.aiplatform.v1beta1.MigrateResourceRequest
                      .MigrateDataLabelingDatasetConfig
                      .MigrateDataLabelingAnnotatedDatasetConfigOrBuilder>
          getMigrateDataLabelingAnnotatedDatasetConfigsOrBuilderList() {
        if (migrateDataLabelingAnnotatedDatasetConfigsBuilder_ != null) {
          return migrateDataLabelingAnnotatedDatasetConfigsBuilder_.getMessageOrBuilderList();
        } else {
          return java.util.Collections.unmodifiableList(
              migrateDataLabelingAnnotatedDatasetConfigs_);
        }
      }
      /**
       *
       *
       * <pre>
       * Optional. Configs for migrating AnnotatedDataset in datalabeling.googleapis.com to
       * Vertex AI's SavedQuery. The specified AnnotatedDatasets have to belong
       * to the datalabeling Dataset.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.aiplatform.v1beta1.MigrateResourceRequest.MigrateDataLabelingDatasetConfig.MigrateDataLabelingAnnotatedDatasetConfig migrate_data_labeling_annotated_dataset_configs = 3 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       */
      public com.google.cloud.aiplatform.v1beta1.MigrateResourceRequest
              .MigrateDataLabelingDatasetConfig.MigrateDataLabelingAnnotatedDatasetConfig.Builder
          addMigrateDataLabelingAnnotatedDatasetConfigsBuilder() {
        return getMigrateDataLabelingAnnotatedDatasetConfigsFieldBuilder()
            .addBuilder(
                com.google.cloud.aiplatform.v1beta1.MigrateResourceRequest
                    .MigrateDataLabelingDatasetConfig.MigrateDataLabelingAnnotatedDatasetConfig
                    .getDefaultInstance());
      }
      /**
       *
       *
       * <pre>
       * Optional. Configs for migrating AnnotatedDataset in datalabeling.googleapis.com to
       * Vertex AI's SavedQuery. The specified AnnotatedDatasets have to belong
       * to the datalabeling Dataset.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.aiplatform.v1beta1.MigrateResourceRequest.MigrateDataLabelingDatasetConfig.MigrateDataLabelingAnnotatedDatasetConfig migrate_data_labeling_annotated_dataset_configs = 3 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       */
      public com.google.cloud.aiplatform.v1beta1.MigrateResourceRequest
              .MigrateDataLabelingDatasetConfig.MigrateDataLabelingAnnotatedDatasetConfig.Builder
          addMigrateDataLabelingAnnotatedDatasetConfigsBuilder(int index) {
        return getMigrateDataLabelingAnnotatedDatasetConfigsFieldBuilder()
            .addBuilder(
                index,
                com.google.cloud.aiplatform.v1beta1.MigrateResourceRequest
                    .MigrateDataLabelingDatasetConfig.MigrateDataLabelingAnnotatedDatasetConfig
                    .getDefaultInstance());
      }
      /**
       *
       *
       * <pre>
       * Optional. Configs for migrating AnnotatedDataset in datalabeling.googleapis.com to
       * Vertex AI's SavedQuery. The specified AnnotatedDatasets have to belong
       * to the datalabeling Dataset.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.aiplatform.v1beta1.MigrateResourceRequest.MigrateDataLabelingDatasetConfig.MigrateDataLabelingAnnotatedDatasetConfig migrate_data_labeling_annotated_dataset_configs = 3 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       */
      public java.util.List<
              com.google.cloud.aiplatform.v1beta1.MigrateResourceRequest
                  .MigrateDataLabelingDatasetConfig.MigrateDataLabelingAnnotatedDatasetConfig
                  .Builder>
          getMigrateDataLabelingAnnotatedDatasetConfigsBuilderList() {
        return getMigrateDataLabelingAnnotatedDatasetConfigsFieldBuilder().getBuilderList();
      }

      private com.google.protobuf.RepeatedFieldBuilderV3<
              com.google.cloud.aiplatform.v1beta1.MigrateResourceRequest
                  .MigrateDataLabelingDatasetConfig.MigrateDataLabelingAnnotatedDatasetConfig,
              com.google.cloud.aiplatform.v1beta1.MigrateResourceRequest
                  .MigrateDataLabelingDatasetConfig.MigrateDataLabelingAnnotatedDatasetConfig
                  .Builder,
              com.google.cloud.aiplatform.v1beta1.MigrateResourceRequest
                  .MigrateDataLabelingDatasetConfig
                  .MigrateDataLabelingAnnotatedDatasetConfigOrBuilder>
          getMigrateDataLabelingAnnotatedDatasetConfigsFieldBuilder() {
        if (migrateDataLabelingAnnotatedDatasetConfigsBuilder_ == null) {
          migrateDataLabelingAnnotatedDatasetConfigsBuilder_ =
              new com.google.protobuf.RepeatedFieldBuilderV3<
                  com.google.cloud.aiplatform.v1beta1.MigrateResourceRequest
                      .MigrateDataLabelingDatasetConfig.MigrateDataLabelingAnnotatedDatasetConfig,
                  com.google.cloud.aiplatform.v1beta1.MigrateResourceRequest
                      .MigrateDataLabelingDatasetConfig.MigrateDataLabelingAnnotatedDatasetConfig
                      .Builder,
                  com.google.cloud.aiplatform.v1beta1.MigrateResourceRequest
                      .MigrateDataLabelingDatasetConfig
                      .MigrateDataLabelingAnnotatedDatasetConfigOrBuilder>(
                  migrateDataLabelingAnnotatedDatasetConfigs_,
                  ((bitField0_ & 0x00000001) != 0),
                  getParentForChildren(),
                  isClean());
          migrateDataLabelingAnnotatedDatasetConfigs_ = null;
        }
        return migrateDataLabelingAnnotatedDatasetConfigsBuilder_;
      }

      @java.lang.Override
      public final Builder setUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.setUnknownFields(unknownFields);
      }

      @java.lang.Override
      public final Builder mergeUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.mergeUnknownFields(unknownFields);
      }

      // @@protoc_insertion_point(builder_scope:google.cloud.aiplatform.v1beta1.MigrateResourceRequest.MigrateDataLabelingDatasetConfig)
    }

    // @@protoc_insertion_point(class_scope:google.cloud.aiplatform.v1beta1.MigrateResourceRequest.MigrateDataLabelingDatasetConfig)
    private static final com.google.cloud.aiplatform.v1beta1.MigrateResourceRequest
            .MigrateDataLabelingDatasetConfig
        DEFAULT_INSTANCE;

    static {
      DEFAULT_INSTANCE =
          new com.google.cloud.aiplatform.v1beta1.MigrateResourceRequest
              .MigrateDataLabelingDatasetConfig();
    }

    public static com.google.cloud.aiplatform.v1beta1.MigrateResourceRequest
            .MigrateDataLabelingDatasetConfig
        getDefaultInstance() {
      return DEFAULT_INSTANCE;
    }

    private static final com.google.protobuf.Parser<MigrateDataLabelingDatasetConfig> PARSER =
        new com.google.protobuf.AbstractParser<MigrateDataLabelingDatasetConfig>() {
          @java.lang.Override
          public MigrateDataLabelingDatasetConfig parsePartialFrom(
              com.google.protobuf.CodedInputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
            return new MigrateDataLabelingDatasetConfig(input, extensionRegistry);
          }
        };

    public static com.google.protobuf.Parser<MigrateDataLabelingDatasetConfig> parser() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.protobuf.Parser<MigrateDataLabelingDatasetConfig> getParserForType() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.cloud.aiplatform.v1beta1.MigrateResourceRequest
            .MigrateDataLabelingDatasetConfig
        getDefaultInstanceForType() {
      return DEFAULT_INSTANCE;
    }
  }

  private int requestCase_ = 0;
  private java.lang.Object request_;

  public enum RequestCase
      implements
          com.google.protobuf.Internal.EnumLite,
          com.google.protobuf.AbstractMessage.InternalOneOfEnum {
    MIGRATE_ML_ENGINE_MODEL_VERSION_CONFIG(1),
    MIGRATE_AUTOML_MODEL_CONFIG(2),
    MIGRATE_AUTOML_DATASET_CONFIG(3),
    MIGRATE_DATA_LABELING_DATASET_CONFIG(4),
    REQUEST_NOT_SET(0);
    private final int value;

    private RequestCase(int value) {
      this.value = value;
    }
    /**
     * @param value The number of the enum to look for.
     * @return The enum associated with the given number.
     * @deprecated Use {@link #forNumber(int)} instead.
     */
    @java.lang.Deprecated
    public static RequestCase valueOf(int value) {
      return forNumber(value);
    }

    public static RequestCase forNumber(int value) {
      switch (value) {
        case 1:
          return MIGRATE_ML_ENGINE_MODEL_VERSION_CONFIG;
        case 2:
          return MIGRATE_AUTOML_MODEL_CONFIG;
        case 3:
          return MIGRATE_AUTOML_DATASET_CONFIG;
        case 4:
          return MIGRATE_DATA_LABELING_DATASET_CONFIG;
        case 0:
          return REQUEST_NOT_SET;
        default:
          return null;
      }
    }

    public int getNumber() {
      return this.value;
    }
  };

  public RequestCase getRequestCase() {
    return RequestCase.forNumber(requestCase_);
  }

  public static final int MIGRATE_ML_ENGINE_MODEL_VERSION_CONFIG_FIELD_NUMBER = 1;
  /**
   *
   *
   * <pre>
   * Config for migrating Version in ml.googleapis.com to Vertex AI's Model.
   * </pre>
   *
   * <code>
   * .google.cloud.aiplatform.v1beta1.MigrateResourceRequest.MigrateMlEngineModelVersionConfig migrate_ml_engine_model_version_config = 1;
   * </code>
   *
   * @return Whether the migrateMlEngineModelVersionConfig field is set.
   */
  @java.lang.Override
  public boolean hasMigrateMlEngineModelVersionConfig() {
    return requestCase_ == 1;
  }
  /**
   *
   *
   * <pre>
   * Config for migrating Version in ml.googleapis.com to Vertex AI's Model.
   * </pre>
   *
   * <code>
   * .google.cloud.aiplatform.v1beta1.MigrateResourceRequest.MigrateMlEngineModelVersionConfig migrate_ml_engine_model_version_config = 1;
   * </code>
   *
   * @return The migrateMlEngineModelVersionConfig.
   */
  @java.lang.Override
  public com.google.cloud.aiplatform.v1beta1.MigrateResourceRequest
          .MigrateMlEngineModelVersionConfig
      getMigrateMlEngineModelVersionConfig() {
    if (requestCase_ == 1) {
      return (com.google.cloud.aiplatform.v1beta1.MigrateResourceRequest
              .MigrateMlEngineModelVersionConfig)
          request_;
    }
    return com.google.cloud.aiplatform.v1beta1.MigrateResourceRequest
        .MigrateMlEngineModelVersionConfig.getDefaultInstance();
  }
  /**
   *
   *
   * <pre>
   * Config for migrating Version in ml.googleapis.com to Vertex AI's Model.
   * </pre>
   *
   * <code>
   * .google.cloud.aiplatform.v1beta1.MigrateResourceRequest.MigrateMlEngineModelVersionConfig migrate_ml_engine_model_version_config = 1;
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.aiplatform.v1beta1.MigrateResourceRequest
          .MigrateMlEngineModelVersionConfigOrBuilder
      getMigrateMlEngineModelVersionConfigOrBuilder() {
    if (requestCase_ == 1) {
      return (com.google.cloud.aiplatform.v1beta1.MigrateResourceRequest
              .MigrateMlEngineModelVersionConfig)
          request_;
    }
    return com.google.cloud.aiplatform.v1beta1.MigrateResourceRequest
        .MigrateMlEngineModelVersionConfig.getDefaultInstance();
  }

  public static final int MIGRATE_AUTOML_MODEL_CONFIG_FIELD_NUMBER = 2;
  /**
   *
   *
   * <pre>
   * Config for migrating Model in automl.googleapis.com to Vertex AI's
   * Model.
   * </pre>
   *
   * <code>
   * .google.cloud.aiplatform.v1beta1.MigrateResourceRequest.MigrateAutomlModelConfig migrate_automl_model_config = 2;
   * </code>
   *
   * @return Whether the migrateAutomlModelConfig field is set.
   */
  @java.lang.Override
  public boolean hasMigrateAutomlModelConfig() {
    return requestCase_ == 2;
  }
  /**
   *
   *
   * <pre>
   * Config for migrating Model in automl.googleapis.com to Vertex AI's
   * Model.
   * </pre>
   *
   * <code>
   * .google.cloud.aiplatform.v1beta1.MigrateResourceRequest.MigrateAutomlModelConfig migrate_automl_model_config = 2;
   * </code>
   *
   * @return The migrateAutomlModelConfig.
   */
  @java.lang.Override
  public com.google.cloud.aiplatform.v1beta1.MigrateResourceRequest.MigrateAutomlModelConfig
      getMigrateAutomlModelConfig() {
    if (requestCase_ == 2) {
      return (com.google.cloud.aiplatform.v1beta1.MigrateResourceRequest.MigrateAutomlModelConfig)
          request_;
    }
    return com.google.cloud.aiplatform.v1beta1.MigrateResourceRequest.MigrateAutomlModelConfig
        .getDefaultInstance();
  }
  /**
   *
   *
   * <pre>
   * Config for migrating Model in automl.googleapis.com to Vertex AI's
   * Model.
   * </pre>
   *
   * <code>
   * .google.cloud.aiplatform.v1beta1.MigrateResourceRequest.MigrateAutomlModelConfig migrate_automl_model_config = 2;
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.aiplatform.v1beta1.MigrateResourceRequest
          .MigrateAutomlModelConfigOrBuilder
      getMigrateAutomlModelConfigOrBuilder() {
    if (requestCase_ == 2) {
      return (com.google.cloud.aiplatform.v1beta1.MigrateResourceRequest.MigrateAutomlModelConfig)
          request_;
    }
    return com.google.cloud.aiplatform.v1beta1.MigrateResourceRequest.MigrateAutomlModelConfig
        .getDefaultInstance();
  }

  public static final int MIGRATE_AUTOML_DATASET_CONFIG_FIELD_NUMBER = 3;
  /**
   *
   *
   * <pre>
   * Config for migrating Dataset in automl.googleapis.com to Vertex AI's
   * Dataset.
   * </pre>
   *
   * <code>
   * .google.cloud.aiplatform.v1beta1.MigrateResourceRequest.MigrateAutomlDatasetConfig migrate_automl_dataset_config = 3;
   * </code>
   *
   * @return Whether the migrateAutomlDatasetConfig field is set.
   */
  @java.lang.Override
  public boolean hasMigrateAutomlDatasetConfig() {
    return requestCase_ == 3;
  }
  /**
   *
   *
   * <pre>
   * Config for migrating Dataset in automl.googleapis.com to Vertex AI's
   * Dataset.
   * </pre>
   *
   * <code>
   * .google.cloud.aiplatform.v1beta1.MigrateResourceRequest.MigrateAutomlDatasetConfig migrate_automl_dataset_config = 3;
   * </code>
   *
   * @return The migrateAutomlDatasetConfig.
   */
  @java.lang.Override
  public com.google.cloud.aiplatform.v1beta1.MigrateResourceRequest.MigrateAutomlDatasetConfig
      getMigrateAutomlDatasetConfig() {
    if (requestCase_ == 3) {
      return (com.google.cloud.aiplatform.v1beta1.MigrateResourceRequest.MigrateAutomlDatasetConfig)
          request_;
    }
    return com.google.cloud.aiplatform.v1beta1.MigrateResourceRequest.MigrateAutomlDatasetConfig
        .getDefaultInstance();
  }
  /**
   *
   *
   * <pre>
   * Config for migrating Dataset in automl.googleapis.com to Vertex AI's
   * Dataset.
   * </pre>
   *
   * <code>
   * .google.cloud.aiplatform.v1beta1.MigrateResourceRequest.MigrateAutomlDatasetConfig migrate_automl_dataset_config = 3;
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.aiplatform.v1beta1.MigrateResourceRequest
          .MigrateAutomlDatasetConfigOrBuilder
      getMigrateAutomlDatasetConfigOrBuilder() {
    if (requestCase_ == 3) {
      return (com.google.cloud.aiplatform.v1beta1.MigrateResourceRequest.MigrateAutomlDatasetConfig)
          request_;
    }
    return com.google.cloud.aiplatform.v1beta1.MigrateResourceRequest.MigrateAutomlDatasetConfig
        .getDefaultInstance();
  }

  public static final int MIGRATE_DATA_LABELING_DATASET_CONFIG_FIELD_NUMBER = 4;
  /**
   *
   *
   * <pre>
   * Config for migrating Dataset in datalabeling.googleapis.com to
   * Vertex AI's Dataset.
   * </pre>
   *
   * <code>
   * .google.cloud.aiplatform.v1beta1.MigrateResourceRequest.MigrateDataLabelingDatasetConfig migrate_data_labeling_dataset_config = 4;
   * </code>
   *
   * @return Whether the migrateDataLabelingDatasetConfig field is set.
   */
  @java.lang.Override
  public boolean hasMigrateDataLabelingDatasetConfig() {
    return requestCase_ == 4;
  }
  /**
   *
   *
   * <pre>
   * Config for migrating Dataset in datalabeling.googleapis.com to
   * Vertex AI's Dataset.
   * </pre>
   *
   * <code>
   * .google.cloud.aiplatform.v1beta1.MigrateResourceRequest.MigrateDataLabelingDatasetConfig migrate_data_labeling_dataset_config = 4;
   * </code>
   *
   * @return The migrateDataLabelingDatasetConfig.
   */
  @java.lang.Override
  public com.google.cloud.aiplatform.v1beta1.MigrateResourceRequest.MigrateDataLabelingDatasetConfig
      getMigrateDataLabelingDatasetConfig() {
    if (requestCase_ == 4) {
      return (com.google.cloud.aiplatform.v1beta1.MigrateResourceRequest
              .MigrateDataLabelingDatasetConfig)
          request_;
    }
    return com.google.cloud.aiplatform.v1beta1.MigrateResourceRequest
        .MigrateDataLabelingDatasetConfig.getDefaultInstance();
  }
  /**
   *
   *
   * <pre>
   * Config for migrating Dataset in datalabeling.googleapis.com to
   * Vertex AI's Dataset.
   * </pre>
   *
   * <code>
   * .google.cloud.aiplatform.v1beta1.MigrateResourceRequest.MigrateDataLabelingDatasetConfig migrate_data_labeling_dataset_config = 4;
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.aiplatform.v1beta1.MigrateResourceRequest
          .MigrateDataLabelingDatasetConfigOrBuilder
      getMigrateDataLabelingDatasetConfigOrBuilder() {
    if (requestCase_ == 4) {
      return (com.google.cloud.aiplatform.v1beta1.MigrateResourceRequest
              .MigrateDataLabelingDatasetConfig)
          request_;
    }
    return com.google.cloud.aiplatform.v1beta1.MigrateResourceRequest
        .MigrateDataLabelingDatasetConfig.getDefaultInstance();
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    if (requestCase_ == 1) {
      output.writeMessage(
          1,
          (com.google.cloud.aiplatform.v1beta1.MigrateResourceRequest
                  .MigrateMlEngineModelVersionConfig)
              request_);
    }
    if (requestCase_ == 2) {
      output.writeMessage(
          2,
          (com.google.cloud.aiplatform.v1beta1.MigrateResourceRequest.MigrateAutomlModelConfig)
              request_);
    }
    if (requestCase_ == 3) {
      output.writeMessage(
          3,
          (com.google.cloud.aiplatform.v1beta1.MigrateResourceRequest.MigrateAutomlDatasetConfig)
              request_);
    }
    if (requestCase_ == 4) {
      output.writeMessage(
          4,
          (com.google.cloud.aiplatform.v1beta1.MigrateResourceRequest
                  .MigrateDataLabelingDatasetConfig)
              request_);
    }
    unknownFields.writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    if (requestCase_ == 1) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(
              1,
              (com.google.cloud.aiplatform.v1beta1.MigrateResourceRequest
                      .MigrateMlEngineModelVersionConfig)
                  request_);
    }
    if (requestCase_ == 2) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(
              2,
              (com.google.cloud.aiplatform.v1beta1.MigrateResourceRequest.MigrateAutomlModelConfig)
                  request_);
    }
    if (requestCase_ == 3) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(
              3,
              (com.google.cloud.aiplatform.v1beta1.MigrateResourceRequest
                      .MigrateAutomlDatasetConfig)
                  request_);
    }
    if (requestCase_ == 4) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(
              4,
              (com.google.cloud.aiplatform.v1beta1.MigrateResourceRequest
                      .MigrateDataLabelingDatasetConfig)
                  request_);
    }
    size += unknownFields.getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.cloud.aiplatform.v1beta1.MigrateResourceRequest)) {
      return super.equals(obj);
    }
    com.google.cloud.aiplatform.v1beta1.MigrateResourceRequest other =
        (com.google.cloud.aiplatform.v1beta1.MigrateResourceRequest) obj;

    if (!getRequestCase().equals(other.getRequestCase())) return false;
    switch (requestCase_) {
      case 1:
        if (!getMigrateMlEngineModelVersionConfig()
            .equals(other.getMigrateMlEngineModelVersionConfig())) return false;
        break;
      case 2:
        if (!getMigrateAutomlModelConfig().equals(other.getMigrateAutomlModelConfig()))
          return false;
        break;
      case 3:
        if (!getMigrateAutomlDatasetConfig().equals(other.getMigrateAutomlDatasetConfig()))
          return false;
        break;
      case 4:
        if (!getMigrateDataLabelingDatasetConfig()
            .equals(other.getMigrateDataLabelingDatasetConfig())) return false;
        break;
      case 0:
      default:
    }
    if (!unknownFields.equals(other.unknownFields)) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    switch (requestCase_) {
      case 1:
        hash = (37 * hash) + MIGRATE_ML_ENGINE_MODEL_VERSION_CONFIG_FIELD_NUMBER;
        hash = (53 * hash) + getMigrateMlEngineModelVersionConfig().hashCode();
        break;
      case 2:
        hash = (37 * hash) + MIGRATE_AUTOML_MODEL_CONFIG_FIELD_NUMBER;
        hash = (53 * hash) + getMigrateAutomlModelConfig().hashCode();
        break;
      case 3:
        hash = (37 * hash) + MIGRATE_AUTOML_DATASET_CONFIG_FIELD_NUMBER;
        hash = (53 * hash) + getMigrateAutomlDatasetConfig().hashCode();
        break;
      case 4:
        hash = (37 * hash) + MIGRATE_DATA_LABELING_DATASET_CONFIG_FIELD_NUMBER;
        hash = (53 * hash) + getMigrateDataLabelingDatasetConfig().hashCode();
        break;
      case 0:
      default:
    }
    hash = (29 * hash) + unknownFields.hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.cloud.aiplatform.v1beta1.MigrateResourceRequest parseFrom(
      java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.aiplatform.v1beta1.MigrateResourceRequest parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.aiplatform.v1beta1.MigrateResourceRequest parseFrom(
      com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.aiplatform.v1beta1.MigrateResourceRequest parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.aiplatform.v1beta1.MigrateResourceRequest parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.aiplatform.v1beta1.MigrateResourceRequest parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.aiplatform.v1beta1.MigrateResourceRequest parseFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.aiplatform.v1beta1.MigrateResourceRequest parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.aiplatform.v1beta1.MigrateResourceRequest parseDelimitedFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.cloud.aiplatform.v1beta1.MigrateResourceRequest parseDelimitedFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.aiplatform.v1beta1.MigrateResourceRequest parseFrom(
      com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.aiplatform.v1beta1.MigrateResourceRequest parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(
      com.google.cloud.aiplatform.v1beta1.MigrateResourceRequest prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }
  /**
   *
   *
   * <pre>
   * Config of migrating one resource from automl.googleapis.com,
   * datalabeling.googleapis.com and ml.googleapis.com to Vertex AI.
   * </pre>
   *
   * Protobuf type {@code google.cloud.aiplatform.v1beta1.MigrateResourceRequest}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.cloud.aiplatform.v1beta1.MigrateResourceRequest)
      com.google.cloud.aiplatform.v1beta1.MigrateResourceRequestOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.aiplatform.v1beta1.MigrationServiceProto
          .internal_static_google_cloud_aiplatform_v1beta1_MigrateResourceRequest_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.aiplatform.v1beta1.MigrationServiceProto
          .internal_static_google_cloud_aiplatform_v1beta1_MigrateResourceRequest_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.aiplatform.v1beta1.MigrateResourceRequest.class,
              com.google.cloud.aiplatform.v1beta1.MigrateResourceRequest.Builder.class);
    }

    // Construct using com.google.cloud.aiplatform.v1beta1.MigrateResourceRequest.newBuilder()
    private Builder() {
      maybeForceBuilderInitialization();
    }

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
      maybeForceBuilderInitialization();
    }

    private void maybeForceBuilderInitialization() {
      if (com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders) {}
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      requestCase_ = 0;
      request_ = null;
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.cloud.aiplatform.v1beta1.MigrationServiceProto
          .internal_static_google_cloud_aiplatform_v1beta1_MigrateResourceRequest_descriptor;
    }

    @java.lang.Override
    public com.google.cloud.aiplatform.v1beta1.MigrateResourceRequest getDefaultInstanceForType() {
      return com.google.cloud.aiplatform.v1beta1.MigrateResourceRequest.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.cloud.aiplatform.v1beta1.MigrateResourceRequest build() {
      com.google.cloud.aiplatform.v1beta1.MigrateResourceRequest result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.cloud.aiplatform.v1beta1.MigrateResourceRequest buildPartial() {
      com.google.cloud.aiplatform.v1beta1.MigrateResourceRequest result =
          new com.google.cloud.aiplatform.v1beta1.MigrateResourceRequest(this);
      if (requestCase_ == 1) {
        if (migrateMlEngineModelVersionConfigBuilder_ == null) {
          result.request_ = request_;
        } else {
          result.request_ = migrateMlEngineModelVersionConfigBuilder_.build();
        }
      }
      if (requestCase_ == 2) {
        if (migrateAutomlModelConfigBuilder_ == null) {
          result.request_ = request_;
        } else {
          result.request_ = migrateAutomlModelConfigBuilder_.build();
        }
      }
      if (requestCase_ == 3) {
        if (migrateAutomlDatasetConfigBuilder_ == null) {
          result.request_ = request_;
        } else {
          result.request_ = migrateAutomlDatasetConfigBuilder_.build();
        }
      }
      if (requestCase_ == 4) {
        if (migrateDataLabelingDatasetConfigBuilder_ == null) {
          result.request_ = request_;
        } else {
          result.request_ = migrateDataLabelingDatasetConfigBuilder_.build();
        }
      }
      result.requestCase_ = requestCase_;
      onBuilt();
      return result;
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.cloud.aiplatform.v1beta1.MigrateResourceRequest) {
        return mergeFrom((com.google.cloud.aiplatform.v1beta1.MigrateResourceRequest) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(com.google.cloud.aiplatform.v1beta1.MigrateResourceRequest other) {
      if (other == com.google.cloud.aiplatform.v1beta1.MigrateResourceRequest.getDefaultInstance())
        return this;
      switch (other.getRequestCase()) {
        case MIGRATE_ML_ENGINE_MODEL_VERSION_CONFIG:
          {
            mergeMigrateMlEngineModelVersionConfig(other.getMigrateMlEngineModelVersionConfig());
            break;
          }
        case MIGRATE_AUTOML_MODEL_CONFIG:
          {
            mergeMigrateAutomlModelConfig(other.getMigrateAutomlModelConfig());
            break;
          }
        case MIGRATE_AUTOML_DATASET_CONFIG:
          {
            mergeMigrateAutomlDatasetConfig(other.getMigrateAutomlDatasetConfig());
            break;
          }
        case MIGRATE_DATA_LABELING_DATASET_CONFIG:
          {
            mergeMigrateDataLabelingDatasetConfig(other.getMigrateDataLabelingDatasetConfig());
            break;
          }
        case REQUEST_NOT_SET:
          {
            break;
          }
      }
      this.mergeUnknownFields(other.unknownFields);
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      com.google.cloud.aiplatform.v1beta1.MigrateResourceRequest parsedMessage = null;
      try {
        parsedMessage = PARSER.parsePartialFrom(input, extensionRegistry);
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        parsedMessage =
            (com.google.cloud.aiplatform.v1beta1.MigrateResourceRequest) e.getUnfinishedMessage();
        throw e.unwrapIOException();
      } finally {
        if (parsedMessage != null) {
          mergeFrom(parsedMessage);
        }
      }
      return this;
    }

    private int requestCase_ = 0;
    private java.lang.Object request_;

    public RequestCase getRequestCase() {
      return RequestCase.forNumber(requestCase_);
    }

    public Builder clearRequest() {
      requestCase_ = 0;
      request_ = null;
      onChanged();
      return this;
    }

    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.aiplatform.v1beta1.MigrateResourceRequest
                .MigrateMlEngineModelVersionConfig,
            com.google.cloud.aiplatform.v1beta1.MigrateResourceRequest
                .MigrateMlEngineModelVersionConfig.Builder,
            com.google.cloud.aiplatform.v1beta1.MigrateResourceRequest
                .MigrateMlEngineModelVersionConfigOrBuilder>
        migrateMlEngineModelVersionConfigBuilder_;
    /**
     *
     *
     * <pre>
     * Config for migrating Version in ml.googleapis.com to Vertex AI's Model.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.MigrateResourceRequest.MigrateMlEngineModelVersionConfig migrate_ml_engine_model_version_config = 1;
     * </code>
     *
     * @return Whether the migrateMlEngineModelVersionConfig field is set.
     */
    @java.lang.Override
    public boolean hasMigrateMlEngineModelVersionConfig() {
      return requestCase_ == 1;
    }
    /**
     *
     *
     * <pre>
     * Config for migrating Version in ml.googleapis.com to Vertex AI's Model.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.MigrateResourceRequest.MigrateMlEngineModelVersionConfig migrate_ml_engine_model_version_config = 1;
     * </code>
     *
     * @return The migrateMlEngineModelVersionConfig.
     */
    @java.lang.Override
    public com.google.cloud.aiplatform.v1beta1.MigrateResourceRequest
            .MigrateMlEngineModelVersionConfig
        getMigrateMlEngineModelVersionConfig() {
      if (migrateMlEngineModelVersionConfigBuilder_ == null) {
        if (requestCase_ == 1) {
          return (com.google.cloud.aiplatform.v1beta1.MigrateResourceRequest
                  .MigrateMlEngineModelVersionConfig)
              request_;
        }
        return com.google.cloud.aiplatform.v1beta1.MigrateResourceRequest
            .MigrateMlEngineModelVersionConfig.getDefaultInstance();
      } else {
        if (requestCase_ == 1) {
          return migrateMlEngineModelVersionConfigBuilder_.getMessage();
        }
        return com.google.cloud.aiplatform.v1beta1.MigrateResourceRequest
            .MigrateMlEngineModelVersionConfig.getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * Config for migrating Version in ml.googleapis.com to Vertex AI's Model.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.MigrateResourceRequest.MigrateMlEngineModelVersionConfig migrate_ml_engine_model_version_config = 1;
     * </code>
     */
    public Builder setMigrateMlEngineModelVersionConfig(
        com.google.cloud.aiplatform.v1beta1.MigrateResourceRequest.MigrateMlEngineModelVersionConfig
            value) {
      if (migrateMlEngineModelVersionConfigBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        request_ = value;
        onChanged();
      } else {
        migrateMlEngineModelVersionConfigBuilder_.setMessage(value);
      }
      requestCase_ = 1;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Config for migrating Version in ml.googleapis.com to Vertex AI's Model.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.MigrateResourceRequest.MigrateMlEngineModelVersionConfig migrate_ml_engine_model_version_config = 1;
     * </code>
     */
    public Builder setMigrateMlEngineModelVersionConfig(
        com.google.cloud.aiplatform.v1beta1.MigrateResourceRequest.MigrateMlEngineModelVersionConfig
                .Builder
            builderForValue) {
      if (migrateMlEngineModelVersionConfigBuilder_ == null) {
        request_ = builderForValue.build();
        onChanged();
      } else {
        migrateMlEngineModelVersionConfigBuilder_.setMessage(builderForValue.build());
      }
      requestCase_ = 1;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Config for migrating Version in ml.googleapis.com to Vertex AI's Model.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.MigrateResourceRequest.MigrateMlEngineModelVersionConfig migrate_ml_engine_model_version_config = 1;
     * </code>
     */
    public Builder mergeMigrateMlEngineModelVersionConfig(
        com.google.cloud.aiplatform.v1beta1.MigrateResourceRequest.MigrateMlEngineModelVersionConfig
            value) {
      if (migrateMlEngineModelVersionConfigBuilder_ == null) {
        if (requestCase_ == 1
            && request_
                != com.google.cloud.aiplatform.v1beta1.MigrateResourceRequest
                    .MigrateMlEngineModelVersionConfig.getDefaultInstance()) {
          request_ =
              com.google.cloud.aiplatform.v1beta1.MigrateResourceRequest
                  .MigrateMlEngineModelVersionConfig.newBuilder(
                      (com.google.cloud.aiplatform.v1beta1.MigrateResourceRequest
                              .MigrateMlEngineModelVersionConfig)
                          request_)
                  .mergeFrom(value)
                  .buildPartial();
        } else {
          request_ = value;
        }
        onChanged();
      } else {
        if (requestCase_ == 1) {
          migrateMlEngineModelVersionConfigBuilder_.mergeFrom(value);
        }
        migrateMlEngineModelVersionConfigBuilder_.setMessage(value);
      }
      requestCase_ = 1;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Config for migrating Version in ml.googleapis.com to Vertex AI's Model.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.MigrateResourceRequest.MigrateMlEngineModelVersionConfig migrate_ml_engine_model_version_config = 1;
     * </code>
     */
    public Builder clearMigrateMlEngineModelVersionConfig() {
      if (migrateMlEngineModelVersionConfigBuilder_ == null) {
        if (requestCase_ == 1) {
          requestCase_ = 0;
          request_ = null;
          onChanged();
        }
      } else {
        if (requestCase_ == 1) {
          requestCase_ = 0;
          request_ = null;
        }
        migrateMlEngineModelVersionConfigBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Config for migrating Version in ml.googleapis.com to Vertex AI's Model.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.MigrateResourceRequest.MigrateMlEngineModelVersionConfig migrate_ml_engine_model_version_config = 1;
     * </code>
     */
    public com.google.cloud.aiplatform.v1beta1.MigrateResourceRequest
            .MigrateMlEngineModelVersionConfig.Builder
        getMigrateMlEngineModelVersionConfigBuilder() {
      return getMigrateMlEngineModelVersionConfigFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Config for migrating Version in ml.googleapis.com to Vertex AI's Model.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.MigrateResourceRequest.MigrateMlEngineModelVersionConfig migrate_ml_engine_model_version_config = 1;
     * </code>
     */
    @java.lang.Override
    public com.google.cloud.aiplatform.v1beta1.MigrateResourceRequest
            .MigrateMlEngineModelVersionConfigOrBuilder
        getMigrateMlEngineModelVersionConfigOrBuilder() {
      if ((requestCase_ == 1) && (migrateMlEngineModelVersionConfigBuilder_ != null)) {
        return migrateMlEngineModelVersionConfigBuilder_.getMessageOrBuilder();
      } else {
        if (requestCase_ == 1) {
          return (com.google.cloud.aiplatform.v1beta1.MigrateResourceRequest
                  .MigrateMlEngineModelVersionConfig)
              request_;
        }
        return com.google.cloud.aiplatform.v1beta1.MigrateResourceRequest
            .MigrateMlEngineModelVersionConfig.getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * Config for migrating Version in ml.googleapis.com to Vertex AI's Model.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.MigrateResourceRequest.MigrateMlEngineModelVersionConfig migrate_ml_engine_model_version_config = 1;
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.aiplatform.v1beta1.MigrateResourceRequest
                .MigrateMlEngineModelVersionConfig,
            com.google.cloud.aiplatform.v1beta1.MigrateResourceRequest
                .MigrateMlEngineModelVersionConfig.Builder,
            com.google.cloud.aiplatform.v1beta1.MigrateResourceRequest
                .MigrateMlEngineModelVersionConfigOrBuilder>
        getMigrateMlEngineModelVersionConfigFieldBuilder() {
      if (migrateMlEngineModelVersionConfigBuilder_ == null) {
        if (!(requestCase_ == 1)) {
          request_ =
              com.google.cloud.aiplatform.v1beta1.MigrateResourceRequest
                  .MigrateMlEngineModelVersionConfig.getDefaultInstance();
        }
        migrateMlEngineModelVersionConfigBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.aiplatform.v1beta1.MigrateResourceRequest
                    .MigrateMlEngineModelVersionConfig,
                com.google.cloud.aiplatform.v1beta1.MigrateResourceRequest
                    .MigrateMlEngineModelVersionConfig.Builder,
                com.google.cloud.aiplatform.v1beta1.MigrateResourceRequest
                    .MigrateMlEngineModelVersionConfigOrBuilder>(
                (com.google.cloud.aiplatform.v1beta1.MigrateResourceRequest
                        .MigrateMlEngineModelVersionConfig)
                    request_,
                getParentForChildren(),
                isClean());
        request_ = null;
      }
      requestCase_ = 1;
      onChanged();
      ;
      return migrateMlEngineModelVersionConfigBuilder_;
    }

    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.aiplatform.v1beta1.MigrateResourceRequest.MigrateAutomlModelConfig,
            com.google.cloud.aiplatform.v1beta1.MigrateResourceRequest.MigrateAutomlModelConfig
                .Builder,
            com.google.cloud.aiplatform.v1beta1.MigrateResourceRequest
                .MigrateAutomlModelConfigOrBuilder>
        migrateAutomlModelConfigBuilder_;
    /**
     *
     *
     * <pre>
     * Config for migrating Model in automl.googleapis.com to Vertex AI's
     * Model.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.MigrateResourceRequest.MigrateAutomlModelConfig migrate_automl_model_config = 2;
     * </code>
     *
     * @return Whether the migrateAutomlModelConfig field is set.
     */
    @java.lang.Override
    public boolean hasMigrateAutomlModelConfig() {
      return requestCase_ == 2;
    }
    /**
     *
     *
     * <pre>
     * Config for migrating Model in automl.googleapis.com to Vertex AI's
     * Model.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.MigrateResourceRequest.MigrateAutomlModelConfig migrate_automl_model_config = 2;
     * </code>
     *
     * @return The migrateAutomlModelConfig.
     */
    @java.lang.Override
    public com.google.cloud.aiplatform.v1beta1.MigrateResourceRequest.MigrateAutomlModelConfig
        getMigrateAutomlModelConfig() {
      if (migrateAutomlModelConfigBuilder_ == null) {
        if (requestCase_ == 2) {
          return (com.google.cloud.aiplatform.v1beta1.MigrateResourceRequest
                  .MigrateAutomlModelConfig)
              request_;
        }
        return com.google.cloud.aiplatform.v1beta1.MigrateResourceRequest.MigrateAutomlModelConfig
            .getDefaultInstance();
      } else {
        if (requestCase_ == 2) {
          return migrateAutomlModelConfigBuilder_.getMessage();
        }
        return com.google.cloud.aiplatform.v1beta1.MigrateResourceRequest.MigrateAutomlModelConfig
            .getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * Config for migrating Model in automl.googleapis.com to Vertex AI's
     * Model.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.MigrateResourceRequest.MigrateAutomlModelConfig migrate_automl_model_config = 2;
     * </code>
     */
    public Builder setMigrateAutomlModelConfig(
        com.google.cloud.aiplatform.v1beta1.MigrateResourceRequest.MigrateAutomlModelConfig value) {
      if (migrateAutomlModelConfigBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        request_ = value;
        onChanged();
      } else {
        migrateAutomlModelConfigBuilder_.setMessage(value);
      }
      requestCase_ = 2;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Config for migrating Model in automl.googleapis.com to Vertex AI's
     * Model.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.MigrateResourceRequest.MigrateAutomlModelConfig migrate_automl_model_config = 2;
     * </code>
     */
    public Builder setMigrateAutomlModelConfig(
        com.google.cloud.aiplatform.v1beta1.MigrateResourceRequest.MigrateAutomlModelConfig.Builder
            builderForValue) {
      if (migrateAutomlModelConfigBuilder_ == null) {
        request_ = builderForValue.build();
        onChanged();
      } else {
        migrateAutomlModelConfigBuilder_.setMessage(builderForValue.build());
      }
      requestCase_ = 2;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Config for migrating Model in automl.googleapis.com to Vertex AI's
     * Model.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.MigrateResourceRequest.MigrateAutomlModelConfig migrate_automl_model_config = 2;
     * </code>
     */
    public Builder mergeMigrateAutomlModelConfig(
        com.google.cloud.aiplatform.v1beta1.MigrateResourceRequest.MigrateAutomlModelConfig value) {
      if (migrateAutomlModelConfigBuilder_ == null) {
        if (requestCase_ == 2
            && request_
                != com.google.cloud.aiplatform.v1beta1.MigrateResourceRequest
                    .MigrateAutomlModelConfig.getDefaultInstance()) {
          request_ =
              com.google.cloud.aiplatform.v1beta1.MigrateResourceRequest.MigrateAutomlModelConfig
                  .newBuilder(
                      (com.google.cloud.aiplatform.v1beta1.MigrateResourceRequest
                              .MigrateAutomlModelConfig)
                          request_)
                  .mergeFrom(value)
                  .buildPartial();
        } else {
          request_ = value;
        }
        onChanged();
      } else {
        if (requestCase_ == 2) {
          migrateAutomlModelConfigBuilder_.mergeFrom(value);
        }
        migrateAutomlModelConfigBuilder_.setMessage(value);
      }
      requestCase_ = 2;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Config for migrating Model in automl.googleapis.com to Vertex AI's
     * Model.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.MigrateResourceRequest.MigrateAutomlModelConfig migrate_automl_model_config = 2;
     * </code>
     */
    public Builder clearMigrateAutomlModelConfig() {
      if (migrateAutomlModelConfigBuilder_ == null) {
        if (requestCase_ == 2) {
          requestCase_ = 0;
          request_ = null;
          onChanged();
        }
      } else {
        if (requestCase_ == 2) {
          requestCase_ = 0;
          request_ = null;
        }
        migrateAutomlModelConfigBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Config for migrating Model in automl.googleapis.com to Vertex AI's
     * Model.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.MigrateResourceRequest.MigrateAutomlModelConfig migrate_automl_model_config = 2;
     * </code>
     */
    public com.google.cloud.aiplatform.v1beta1.MigrateResourceRequest.MigrateAutomlModelConfig
            .Builder
        getMigrateAutomlModelConfigBuilder() {
      return getMigrateAutomlModelConfigFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Config for migrating Model in automl.googleapis.com to Vertex AI's
     * Model.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.MigrateResourceRequest.MigrateAutomlModelConfig migrate_automl_model_config = 2;
     * </code>
     */
    @java.lang.Override
    public com.google.cloud.aiplatform.v1beta1.MigrateResourceRequest
            .MigrateAutomlModelConfigOrBuilder
        getMigrateAutomlModelConfigOrBuilder() {
      if ((requestCase_ == 2) && (migrateAutomlModelConfigBuilder_ != null)) {
        return migrateAutomlModelConfigBuilder_.getMessageOrBuilder();
      } else {
        if (requestCase_ == 2) {
          return (com.google.cloud.aiplatform.v1beta1.MigrateResourceRequest
                  .MigrateAutomlModelConfig)
              request_;
        }
        return com.google.cloud.aiplatform.v1beta1.MigrateResourceRequest.MigrateAutomlModelConfig
            .getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * Config for migrating Model in automl.googleapis.com to Vertex AI's
     * Model.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.MigrateResourceRequest.MigrateAutomlModelConfig migrate_automl_model_config = 2;
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.aiplatform.v1beta1.MigrateResourceRequest.MigrateAutomlModelConfig,
            com.google.cloud.aiplatform.v1beta1.MigrateResourceRequest.MigrateAutomlModelConfig
                .Builder,
            com.google.cloud.aiplatform.v1beta1.MigrateResourceRequest
                .MigrateAutomlModelConfigOrBuilder>
        getMigrateAutomlModelConfigFieldBuilder() {
      if (migrateAutomlModelConfigBuilder_ == null) {
        if (!(requestCase_ == 2)) {
          request_ =
              com.google.cloud.aiplatform.v1beta1.MigrateResourceRequest.MigrateAutomlModelConfig
                  .getDefaultInstance();
        }
        migrateAutomlModelConfigBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.aiplatform.v1beta1.MigrateResourceRequest.MigrateAutomlModelConfig,
                com.google.cloud.aiplatform.v1beta1.MigrateResourceRequest.MigrateAutomlModelConfig
                    .Builder,
                com.google.cloud.aiplatform.v1beta1.MigrateResourceRequest
                    .MigrateAutomlModelConfigOrBuilder>(
                (com.google.cloud.aiplatform.v1beta1.MigrateResourceRequest
                        .MigrateAutomlModelConfig)
                    request_,
                getParentForChildren(),
                isClean());
        request_ = null;
      }
      requestCase_ = 2;
      onChanged();
      ;
      return migrateAutomlModelConfigBuilder_;
    }

    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.aiplatform.v1beta1.MigrateResourceRequest.MigrateAutomlDatasetConfig,
            com.google.cloud.aiplatform.v1beta1.MigrateResourceRequest.MigrateAutomlDatasetConfig
                .Builder,
            com.google.cloud.aiplatform.v1beta1.MigrateResourceRequest
                .MigrateAutomlDatasetConfigOrBuilder>
        migrateAutomlDatasetConfigBuilder_;
    /**
     *
     *
     * <pre>
     * Config for migrating Dataset in automl.googleapis.com to Vertex AI's
     * Dataset.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.MigrateResourceRequest.MigrateAutomlDatasetConfig migrate_automl_dataset_config = 3;
     * </code>
     *
     * @return Whether the migrateAutomlDatasetConfig field is set.
     */
    @java.lang.Override
    public boolean hasMigrateAutomlDatasetConfig() {
      return requestCase_ == 3;
    }
    /**
     *
     *
     * <pre>
     * Config for migrating Dataset in automl.googleapis.com to Vertex AI's
     * Dataset.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.MigrateResourceRequest.MigrateAutomlDatasetConfig migrate_automl_dataset_config = 3;
     * </code>
     *
     * @return The migrateAutomlDatasetConfig.
     */
    @java.lang.Override
    public com.google.cloud.aiplatform.v1beta1.MigrateResourceRequest.MigrateAutomlDatasetConfig
        getMigrateAutomlDatasetConfig() {
      if (migrateAutomlDatasetConfigBuilder_ == null) {
        if (requestCase_ == 3) {
          return (com.google.cloud.aiplatform.v1beta1.MigrateResourceRequest
                  .MigrateAutomlDatasetConfig)
              request_;
        }
        return com.google.cloud.aiplatform.v1beta1.MigrateResourceRequest.MigrateAutomlDatasetConfig
            .getDefaultInstance();
      } else {
        if (requestCase_ == 3) {
          return migrateAutomlDatasetConfigBuilder_.getMessage();
        }
        return com.google.cloud.aiplatform.v1beta1.MigrateResourceRequest.MigrateAutomlDatasetConfig
            .getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * Config for migrating Dataset in automl.googleapis.com to Vertex AI's
     * Dataset.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.MigrateResourceRequest.MigrateAutomlDatasetConfig migrate_automl_dataset_config = 3;
     * </code>
     */
    public Builder setMigrateAutomlDatasetConfig(
        com.google.cloud.aiplatform.v1beta1.MigrateResourceRequest.MigrateAutomlDatasetConfig
            value) {
      if (migrateAutomlDatasetConfigBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        request_ = value;
        onChanged();
      } else {
        migrateAutomlDatasetConfigBuilder_.setMessage(value);
      }
      requestCase_ = 3;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Config for migrating Dataset in automl.googleapis.com to Vertex AI's
     * Dataset.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.MigrateResourceRequest.MigrateAutomlDatasetConfig migrate_automl_dataset_config = 3;
     * </code>
     */
    public Builder setMigrateAutomlDatasetConfig(
        com.google.cloud.aiplatform.v1beta1.MigrateResourceRequest.MigrateAutomlDatasetConfig
                .Builder
            builderForValue) {
      if (migrateAutomlDatasetConfigBuilder_ == null) {
        request_ = builderForValue.build();
        onChanged();
      } else {
        migrateAutomlDatasetConfigBuilder_.setMessage(builderForValue.build());
      }
      requestCase_ = 3;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Config for migrating Dataset in automl.googleapis.com to Vertex AI's
     * Dataset.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.MigrateResourceRequest.MigrateAutomlDatasetConfig migrate_automl_dataset_config = 3;
     * </code>
     */
    public Builder mergeMigrateAutomlDatasetConfig(
        com.google.cloud.aiplatform.v1beta1.MigrateResourceRequest.MigrateAutomlDatasetConfig
            value) {
      if (migrateAutomlDatasetConfigBuilder_ == null) {
        if (requestCase_ == 3
            && request_
                != com.google.cloud.aiplatform.v1beta1.MigrateResourceRequest
                    .MigrateAutomlDatasetConfig.getDefaultInstance()) {
          request_ =
              com.google.cloud.aiplatform.v1beta1.MigrateResourceRequest.MigrateAutomlDatasetConfig
                  .newBuilder(
                      (com.google.cloud.aiplatform.v1beta1.MigrateResourceRequest
                              .MigrateAutomlDatasetConfig)
                          request_)
                  .mergeFrom(value)
                  .buildPartial();
        } else {
          request_ = value;
        }
        onChanged();
      } else {
        if (requestCase_ == 3) {
          migrateAutomlDatasetConfigBuilder_.mergeFrom(value);
        }
        migrateAutomlDatasetConfigBuilder_.setMessage(value);
      }
      requestCase_ = 3;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Config for migrating Dataset in automl.googleapis.com to Vertex AI's
     * Dataset.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.MigrateResourceRequest.MigrateAutomlDatasetConfig migrate_automl_dataset_config = 3;
     * </code>
     */
    public Builder clearMigrateAutomlDatasetConfig() {
      if (migrateAutomlDatasetConfigBuilder_ == null) {
        if (requestCase_ == 3) {
          requestCase_ = 0;
          request_ = null;
          onChanged();
        }
      } else {
        if (requestCase_ == 3) {
          requestCase_ = 0;
          request_ = null;
        }
        migrateAutomlDatasetConfigBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Config for migrating Dataset in automl.googleapis.com to Vertex AI's
     * Dataset.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.MigrateResourceRequest.MigrateAutomlDatasetConfig migrate_automl_dataset_config = 3;
     * </code>
     */
    public com.google.cloud.aiplatform.v1beta1.MigrateResourceRequest.MigrateAutomlDatasetConfig
            .Builder
        getMigrateAutomlDatasetConfigBuilder() {
      return getMigrateAutomlDatasetConfigFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Config for migrating Dataset in automl.googleapis.com to Vertex AI's
     * Dataset.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.MigrateResourceRequest.MigrateAutomlDatasetConfig migrate_automl_dataset_config = 3;
     * </code>
     */
    @java.lang.Override
    public com.google.cloud.aiplatform.v1beta1.MigrateResourceRequest
            .MigrateAutomlDatasetConfigOrBuilder
        getMigrateAutomlDatasetConfigOrBuilder() {
      if ((requestCase_ == 3) && (migrateAutomlDatasetConfigBuilder_ != null)) {
        return migrateAutomlDatasetConfigBuilder_.getMessageOrBuilder();
      } else {
        if (requestCase_ == 3) {
          return (com.google.cloud.aiplatform.v1beta1.MigrateResourceRequest
                  .MigrateAutomlDatasetConfig)
              request_;
        }
        return com.google.cloud.aiplatform.v1beta1.MigrateResourceRequest.MigrateAutomlDatasetConfig
            .getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * Config for migrating Dataset in automl.googleapis.com to Vertex AI's
     * Dataset.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.MigrateResourceRequest.MigrateAutomlDatasetConfig migrate_automl_dataset_config = 3;
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.aiplatform.v1beta1.MigrateResourceRequest.MigrateAutomlDatasetConfig,
            com.google.cloud.aiplatform.v1beta1.MigrateResourceRequest.MigrateAutomlDatasetConfig
                .Builder,
            com.google.cloud.aiplatform.v1beta1.MigrateResourceRequest
                .MigrateAutomlDatasetConfigOrBuilder>
        getMigrateAutomlDatasetConfigFieldBuilder() {
      if (migrateAutomlDatasetConfigBuilder_ == null) {
        if (!(requestCase_ == 3)) {
          request_ =
              com.google.cloud.aiplatform.v1beta1.MigrateResourceRequest.MigrateAutomlDatasetConfig
                  .getDefaultInstance();
        }
        migrateAutomlDatasetConfigBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.aiplatform.v1beta1.MigrateResourceRequest
                    .MigrateAutomlDatasetConfig,
                com.google.cloud.aiplatform.v1beta1.MigrateResourceRequest
                    .MigrateAutomlDatasetConfig.Builder,
                com.google.cloud.aiplatform.v1beta1.MigrateResourceRequest
                    .MigrateAutomlDatasetConfigOrBuilder>(
                (com.google.cloud.aiplatform.v1beta1.MigrateResourceRequest
                        .MigrateAutomlDatasetConfig)
                    request_,
                getParentForChildren(),
                isClean());
        request_ = null;
      }
      requestCase_ = 3;
      onChanged();
      ;
      return migrateAutomlDatasetConfigBuilder_;
    }

    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.aiplatform.v1beta1.MigrateResourceRequest
                .MigrateDataLabelingDatasetConfig,
            com.google.cloud.aiplatform.v1beta1.MigrateResourceRequest
                .MigrateDataLabelingDatasetConfig.Builder,
            com.google.cloud.aiplatform.v1beta1.MigrateResourceRequest
                .MigrateDataLabelingDatasetConfigOrBuilder>
        migrateDataLabelingDatasetConfigBuilder_;
    /**
     *
     *
     * <pre>
     * Config for migrating Dataset in datalabeling.googleapis.com to
     * Vertex AI's Dataset.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.MigrateResourceRequest.MigrateDataLabelingDatasetConfig migrate_data_labeling_dataset_config = 4;
     * </code>
     *
     * @return Whether the migrateDataLabelingDatasetConfig field is set.
     */
    @java.lang.Override
    public boolean hasMigrateDataLabelingDatasetConfig() {
      return requestCase_ == 4;
    }
    /**
     *
     *
     * <pre>
     * Config for migrating Dataset in datalabeling.googleapis.com to
     * Vertex AI's Dataset.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.MigrateResourceRequest.MigrateDataLabelingDatasetConfig migrate_data_labeling_dataset_config = 4;
     * </code>
     *
     * @return The migrateDataLabelingDatasetConfig.
     */
    @java.lang.Override
    public com.google.cloud.aiplatform.v1beta1.MigrateResourceRequest
            .MigrateDataLabelingDatasetConfig
        getMigrateDataLabelingDatasetConfig() {
      if (migrateDataLabelingDatasetConfigBuilder_ == null) {
        if (requestCase_ == 4) {
          return (com.google.cloud.aiplatform.v1beta1.MigrateResourceRequest
                  .MigrateDataLabelingDatasetConfig)
              request_;
        }
        return com.google.cloud.aiplatform.v1beta1.MigrateResourceRequest
            .MigrateDataLabelingDatasetConfig.getDefaultInstance();
      } else {
        if (requestCase_ == 4) {
          return migrateDataLabelingDatasetConfigBuilder_.getMessage();
        }
        return com.google.cloud.aiplatform.v1beta1.MigrateResourceRequest
            .MigrateDataLabelingDatasetConfig.getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * Config for migrating Dataset in datalabeling.googleapis.com to
     * Vertex AI's Dataset.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.MigrateResourceRequest.MigrateDataLabelingDatasetConfig migrate_data_labeling_dataset_config = 4;
     * </code>
     */
    public Builder setMigrateDataLabelingDatasetConfig(
        com.google.cloud.aiplatform.v1beta1.MigrateResourceRequest.MigrateDataLabelingDatasetConfig
            value) {
      if (migrateDataLabelingDatasetConfigBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        request_ = value;
        onChanged();
      } else {
        migrateDataLabelingDatasetConfigBuilder_.setMessage(value);
      }
      requestCase_ = 4;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Config for migrating Dataset in datalabeling.googleapis.com to
     * Vertex AI's Dataset.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.MigrateResourceRequest.MigrateDataLabelingDatasetConfig migrate_data_labeling_dataset_config = 4;
     * </code>
     */
    public Builder setMigrateDataLabelingDatasetConfig(
        com.google.cloud.aiplatform.v1beta1.MigrateResourceRequest.MigrateDataLabelingDatasetConfig
                .Builder
            builderForValue) {
      if (migrateDataLabelingDatasetConfigBuilder_ == null) {
        request_ = builderForValue.build();
        onChanged();
      } else {
        migrateDataLabelingDatasetConfigBuilder_.setMessage(builderForValue.build());
      }
      requestCase_ = 4;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Config for migrating Dataset in datalabeling.googleapis.com to
     * Vertex AI's Dataset.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.MigrateResourceRequest.MigrateDataLabelingDatasetConfig migrate_data_labeling_dataset_config = 4;
     * </code>
     */
    public Builder mergeMigrateDataLabelingDatasetConfig(
        com.google.cloud.aiplatform.v1beta1.MigrateResourceRequest.MigrateDataLabelingDatasetConfig
            value) {
      if (migrateDataLabelingDatasetConfigBuilder_ == null) {
        if (requestCase_ == 4
            && request_
                != com.google.cloud.aiplatform.v1beta1.MigrateResourceRequest
                    .MigrateDataLabelingDatasetConfig.getDefaultInstance()) {
          request_ =
              com.google.cloud.aiplatform.v1beta1.MigrateResourceRequest
                  .MigrateDataLabelingDatasetConfig.newBuilder(
                      (com.google.cloud.aiplatform.v1beta1.MigrateResourceRequest
                              .MigrateDataLabelingDatasetConfig)
                          request_)
                  .mergeFrom(value)
                  .buildPartial();
        } else {
          request_ = value;
        }
        onChanged();
      } else {
        if (requestCase_ == 4) {
          migrateDataLabelingDatasetConfigBuilder_.mergeFrom(value);
        }
        migrateDataLabelingDatasetConfigBuilder_.setMessage(value);
      }
      requestCase_ = 4;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Config for migrating Dataset in datalabeling.googleapis.com to
     * Vertex AI's Dataset.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.MigrateResourceRequest.MigrateDataLabelingDatasetConfig migrate_data_labeling_dataset_config = 4;
     * </code>
     */
    public Builder clearMigrateDataLabelingDatasetConfig() {
      if (migrateDataLabelingDatasetConfigBuilder_ == null) {
        if (requestCase_ == 4) {
          requestCase_ = 0;
          request_ = null;
          onChanged();
        }
      } else {
        if (requestCase_ == 4) {
          requestCase_ = 0;
          request_ = null;
        }
        migrateDataLabelingDatasetConfigBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Config for migrating Dataset in datalabeling.googleapis.com to
     * Vertex AI's Dataset.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.MigrateResourceRequest.MigrateDataLabelingDatasetConfig migrate_data_labeling_dataset_config = 4;
     * </code>
     */
    public com.google.cloud.aiplatform.v1beta1.MigrateResourceRequest
            .MigrateDataLabelingDatasetConfig.Builder
        getMigrateDataLabelingDatasetConfigBuilder() {
      return getMigrateDataLabelingDatasetConfigFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Config for migrating Dataset in datalabeling.googleapis.com to
     * Vertex AI's Dataset.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.MigrateResourceRequest.MigrateDataLabelingDatasetConfig migrate_data_labeling_dataset_config = 4;
     * </code>
     */
    @java.lang.Override
    public com.google.cloud.aiplatform.v1beta1.MigrateResourceRequest
            .MigrateDataLabelingDatasetConfigOrBuilder
        getMigrateDataLabelingDatasetConfigOrBuilder() {
      if ((requestCase_ == 4) && (migrateDataLabelingDatasetConfigBuilder_ != null)) {
        return migrateDataLabelingDatasetConfigBuilder_.getMessageOrBuilder();
      } else {
        if (requestCase_ == 4) {
          return (com.google.cloud.aiplatform.v1beta1.MigrateResourceRequest
                  .MigrateDataLabelingDatasetConfig)
              request_;
        }
        return com.google.cloud.aiplatform.v1beta1.MigrateResourceRequest
            .MigrateDataLabelingDatasetConfig.getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * Config for migrating Dataset in datalabeling.googleapis.com to
     * Vertex AI's Dataset.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.MigrateResourceRequest.MigrateDataLabelingDatasetConfig migrate_data_labeling_dataset_config = 4;
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.aiplatform.v1beta1.MigrateResourceRequest
                .MigrateDataLabelingDatasetConfig,
            com.google.cloud.aiplatform.v1beta1.MigrateResourceRequest
                .MigrateDataLabelingDatasetConfig.Builder,
            com.google.cloud.aiplatform.v1beta1.MigrateResourceRequest
                .MigrateDataLabelingDatasetConfigOrBuilder>
        getMigrateDataLabelingDatasetConfigFieldBuilder() {
      if (migrateDataLabelingDatasetConfigBuilder_ == null) {
        if (!(requestCase_ == 4)) {
          request_ =
              com.google.cloud.aiplatform.v1beta1.MigrateResourceRequest
                  .MigrateDataLabelingDatasetConfig.getDefaultInstance();
        }
        migrateDataLabelingDatasetConfigBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.aiplatform.v1beta1.MigrateResourceRequest
                    .MigrateDataLabelingDatasetConfig,
                com.google.cloud.aiplatform.v1beta1.MigrateResourceRequest
                    .MigrateDataLabelingDatasetConfig.Builder,
                com.google.cloud.aiplatform.v1beta1.MigrateResourceRequest
                    .MigrateDataLabelingDatasetConfigOrBuilder>(
                (com.google.cloud.aiplatform.v1beta1.MigrateResourceRequest
                        .MigrateDataLabelingDatasetConfig)
                    request_,
                getParentForChildren(),
                isClean());
        request_ = null;
      }
      requestCase_ = 4;
      onChanged();
      ;
      return migrateDataLabelingDatasetConfigBuilder_;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.cloud.aiplatform.v1beta1.MigrateResourceRequest)
  }

  // @@protoc_insertion_point(class_scope:google.cloud.aiplatform.v1beta1.MigrateResourceRequest)
  private static final com.google.cloud.aiplatform.v1beta1.MigrateResourceRequest DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.cloud.aiplatform.v1beta1.MigrateResourceRequest();
  }

  public static com.google.cloud.aiplatform.v1beta1.MigrateResourceRequest getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<MigrateResourceRequest> PARSER =
      new com.google.protobuf.AbstractParser<MigrateResourceRequest>() {
        @java.lang.Override
        public MigrateResourceRequest parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          return new MigrateResourceRequest(input, extensionRegistry);
        }
      };

  public static com.google.protobuf.Parser<MigrateResourceRequest> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<MigrateResourceRequest> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.cloud.aiplatform.v1beta1.MigrateResourceRequest getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
