/*
 * Copyright 2020 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/cloud/aiplatform/v1beta1/model.proto

package com.google.cloud.aiplatform.v1beta1;

/**
 *
 *
 * <pre>
 * Specification of a container for serving predictions. Some fields in this
 * message correspond to fields in the [Kubernetes Container v1 core
 * specification](https://v1-18.docs.kubernetes.io/docs/reference/generated/kubernetes-api/v1.18/#container-v1-core).
 * </pre>
 *
 * Protobuf type {@code google.cloud.aiplatform.v1beta1.ModelContainerSpec}
 */
public final class ModelContainerSpec extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.cloud.aiplatform.v1beta1.ModelContainerSpec)
    ModelContainerSpecOrBuilder {
  private static final long serialVersionUID = 0L;
  // Use ModelContainerSpec.newBuilder() to construct.
  private ModelContainerSpec(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private ModelContainerSpec() {
    imageUri_ = "";
    command_ = com.google.protobuf.LazyStringArrayList.EMPTY;
    args_ = com.google.protobuf.LazyStringArrayList.EMPTY;
    env_ = java.util.Collections.emptyList();
    ports_ = java.util.Collections.emptyList();
    predictRoute_ = "";
    healthRoute_ = "";
  }

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new ModelContainerSpec();
  }

  @java.lang.Override
  public final com.google.protobuf.UnknownFieldSet getUnknownFields() {
    return this.unknownFields;
  }

  private ModelContainerSpec(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    this();
    if (extensionRegistry == null) {
      throw new java.lang.NullPointerException();
    }
    int mutable_bitField0_ = 0;
    com.google.protobuf.UnknownFieldSet.Builder unknownFields =
        com.google.protobuf.UnknownFieldSet.newBuilder();
    try {
      boolean done = false;
      while (!done) {
        int tag = input.readTag();
        switch (tag) {
          case 0:
            done = true;
            break;
          case 10:
            {
              java.lang.String s = input.readStringRequireUtf8();

              imageUri_ = s;
              break;
            }
          case 18:
            {
              java.lang.String s = input.readStringRequireUtf8();
              if (!((mutable_bitField0_ & 0x00000001) != 0)) {
                command_ = new com.google.protobuf.LazyStringArrayList();
                mutable_bitField0_ |= 0x00000001;
              }
              command_.add(s);
              break;
            }
          case 26:
            {
              java.lang.String s = input.readStringRequireUtf8();
              if (!((mutable_bitField0_ & 0x00000002) != 0)) {
                args_ = new com.google.protobuf.LazyStringArrayList();
                mutable_bitField0_ |= 0x00000002;
              }
              args_.add(s);
              break;
            }
          case 34:
            {
              if (!((mutable_bitField0_ & 0x00000004) != 0)) {
                env_ = new java.util.ArrayList<com.google.cloud.aiplatform.v1beta1.EnvVar>();
                mutable_bitField0_ |= 0x00000004;
              }
              env_.add(
                  input.readMessage(
                      com.google.cloud.aiplatform.v1beta1.EnvVar.parser(), extensionRegistry));
              break;
            }
          case 42:
            {
              if (!((mutable_bitField0_ & 0x00000008) != 0)) {
                ports_ = new java.util.ArrayList<com.google.cloud.aiplatform.v1beta1.Port>();
                mutable_bitField0_ |= 0x00000008;
              }
              ports_.add(
                  input.readMessage(
                      com.google.cloud.aiplatform.v1beta1.Port.parser(), extensionRegistry));
              break;
            }
          case 50:
            {
              java.lang.String s = input.readStringRequireUtf8();

              predictRoute_ = s;
              break;
            }
          case 58:
            {
              java.lang.String s = input.readStringRequireUtf8();

              healthRoute_ = s;
              break;
            }
          default:
            {
              if (!parseUnknownField(input, unknownFields, extensionRegistry, tag)) {
                done = true;
              }
              break;
            }
        }
      }
    } catch (com.google.protobuf.InvalidProtocolBufferException e) {
      throw e.setUnfinishedMessage(this);
    } catch (java.io.IOException e) {
      throw new com.google.protobuf.InvalidProtocolBufferException(e).setUnfinishedMessage(this);
    } finally {
      if (((mutable_bitField0_ & 0x00000001) != 0)) {
        command_ = command_.getUnmodifiableView();
      }
      if (((mutable_bitField0_ & 0x00000002) != 0)) {
        args_ = args_.getUnmodifiableView();
      }
      if (((mutable_bitField0_ & 0x00000004) != 0)) {
        env_ = java.util.Collections.unmodifiableList(env_);
      }
      if (((mutable_bitField0_ & 0x00000008) != 0)) {
        ports_ = java.util.Collections.unmodifiableList(ports_);
      }
      this.unknownFields = unknownFields.build();
      makeExtensionsImmutable();
    }
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.cloud.aiplatform.v1beta1.ModelProto
        .internal_static_google_cloud_aiplatform_v1beta1_ModelContainerSpec_descriptor;
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.cloud.aiplatform.v1beta1.ModelProto
        .internal_static_google_cloud_aiplatform_v1beta1_ModelContainerSpec_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.cloud.aiplatform.v1beta1.ModelContainerSpec.class,
            com.google.cloud.aiplatform.v1beta1.ModelContainerSpec.Builder.class);
  }

  public static final int IMAGE_URI_FIELD_NUMBER = 1;
  private volatile java.lang.Object imageUri_;
  /**
   *
   *
   * <pre>
   * Required. Immutable. URI of the Docker image to be used as the custom container for serving
   * predictions. This URI must identify an image in Artifact Registry or
   * Container Registry. Learn more about the [container publishing
   * requirements](https://cloud.google.com/vertex-ai/docs/predictions/custom-container-requirements#publishing),
   * including permissions requirements for the Vertex AI Service Agent.
   * The container image is ingested upon [ModelService.UploadModel][google.cloud.aiplatform.v1beta1.ModelService.UploadModel], stored
   * internally, and this original path is afterwards not used.
   * To learn about the requirements for the Docker image itself, see
   * [Custom container
   * requirements](https://cloud.google.com/vertex-ai/docs/predictions/custom-container-requirements#).
   * You can use the URI to one of Vertex AI's [pre-built container images for
   * prediction](https://cloud.google.com/vertex-ai/docs/predictions/pre-built-containers)
   * in this field.
   * </pre>
   *
   * <code>
   * string image_uri = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.field_behavior) = IMMUTABLE];
   * </code>
   *
   * @return The imageUri.
   */
  @java.lang.Override
  public java.lang.String getImageUri() {
    java.lang.Object ref = imageUri_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      imageUri_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Required. Immutable. URI of the Docker image to be used as the custom container for serving
   * predictions. This URI must identify an image in Artifact Registry or
   * Container Registry. Learn more about the [container publishing
   * requirements](https://cloud.google.com/vertex-ai/docs/predictions/custom-container-requirements#publishing),
   * including permissions requirements for the Vertex AI Service Agent.
   * The container image is ingested upon [ModelService.UploadModel][google.cloud.aiplatform.v1beta1.ModelService.UploadModel], stored
   * internally, and this original path is afterwards not used.
   * To learn about the requirements for the Docker image itself, see
   * [Custom container
   * requirements](https://cloud.google.com/vertex-ai/docs/predictions/custom-container-requirements#).
   * You can use the URI to one of Vertex AI's [pre-built container images for
   * prediction](https://cloud.google.com/vertex-ai/docs/predictions/pre-built-containers)
   * in this field.
   * </pre>
   *
   * <code>
   * string image_uri = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.field_behavior) = IMMUTABLE];
   * </code>
   *
   * @return The bytes for imageUri.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getImageUriBytes() {
    java.lang.Object ref = imageUri_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      imageUri_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int COMMAND_FIELD_NUMBER = 2;
  private com.google.protobuf.LazyStringList command_;
  /**
   *
   *
   * <pre>
   * Immutable. Specifies the command that runs when the container starts. This overrides
   * the container's
   * [ENTRYPOINT](https://docs.docker.com/engine/reference/builder/#entrypoint).
   * Specify this field as an array of executable and arguments, similar to a
   * Docker `ENTRYPOINT`'s "exec" form, not its "shell" form.
   * If you do not specify this field, then the container's `ENTRYPOINT` runs,
   * in conjunction with the [args][google.cloud.aiplatform.v1beta1.ModelContainerSpec.args] field or the
   * container's [`CMD`](https://docs.docker.com/engine/reference/builder/#cmd),
   * if either exists. If this field is not specified and the container does not
   * have an `ENTRYPOINT`, then refer to the Docker documentation about [how
   * `CMD` and `ENTRYPOINT`
   * interact](https://docs.docker.com/engine/reference/builder/#understand-how-cmd-and-entrypoint-interact).
   * If you specify this field, then you can also specify the `args` field to
   * provide additional arguments for this command. However, if you specify this
   * field, then the container's `CMD` is ignored. See the
   * [Kubernetes documentation about how the
   * `command` and `args` fields interact with a container's `ENTRYPOINT` and
   * `CMD`](https://kubernetes.io/docs/tasks/inject-data-application/define-command-argument-container/#notes).
   * In this field, you can reference [environment variables set by Vertex
   * AI](https://cloud.google.com/vertex-ai/docs/predictions/custom-container-requirements#aip-variables)
   * and environment variables set in the [env][google.cloud.aiplatform.v1beta1.ModelContainerSpec.env] field.
   * You cannot reference environment variables set in the Docker image. In
   * order for environment variables to be expanded, reference them by using the
   * following syntax:
   * &lt;code&gt;$(&lt;var&gt;VARIABLE_NAME&lt;/var&gt;)&lt;/code&gt;
   * Note that this differs from Bash variable expansion, which does not use
   * parentheses. If a variable cannot be resolved, the reference in the input
   * string is used unchanged. To avoid variable expansion, you can escape this
   * syntax with `$$`; for example:
   * &lt;code&gt;$$(&lt;var&gt;VARIABLE_NAME&lt;/var&gt;)&lt;/code&gt;
   * This field corresponds to the `command` field of the Kubernetes Containers
   * [v1 core
   * API](https://v1-18.docs.kubernetes.io/docs/reference/generated/kubernetes-api/v1.18/#container-v1-core).
   * </pre>
   *
   * <code>repeated string command = 2 [(.google.api.field_behavior) = IMMUTABLE];</code>
   *
   * @return A list containing the command.
   */
  public com.google.protobuf.ProtocolStringList getCommandList() {
    return command_;
  }
  /**
   *
   *
   * <pre>
   * Immutable. Specifies the command that runs when the container starts. This overrides
   * the container's
   * [ENTRYPOINT](https://docs.docker.com/engine/reference/builder/#entrypoint).
   * Specify this field as an array of executable and arguments, similar to a
   * Docker `ENTRYPOINT`'s "exec" form, not its "shell" form.
   * If you do not specify this field, then the container's `ENTRYPOINT` runs,
   * in conjunction with the [args][google.cloud.aiplatform.v1beta1.ModelContainerSpec.args] field or the
   * container's [`CMD`](https://docs.docker.com/engine/reference/builder/#cmd),
   * if either exists. If this field is not specified and the container does not
   * have an `ENTRYPOINT`, then refer to the Docker documentation about [how
   * `CMD` and `ENTRYPOINT`
   * interact](https://docs.docker.com/engine/reference/builder/#understand-how-cmd-and-entrypoint-interact).
   * If you specify this field, then you can also specify the `args` field to
   * provide additional arguments for this command. However, if you specify this
   * field, then the container's `CMD` is ignored. See the
   * [Kubernetes documentation about how the
   * `command` and `args` fields interact with a container's `ENTRYPOINT` and
   * `CMD`](https://kubernetes.io/docs/tasks/inject-data-application/define-command-argument-container/#notes).
   * In this field, you can reference [environment variables set by Vertex
   * AI](https://cloud.google.com/vertex-ai/docs/predictions/custom-container-requirements#aip-variables)
   * and environment variables set in the [env][google.cloud.aiplatform.v1beta1.ModelContainerSpec.env] field.
   * You cannot reference environment variables set in the Docker image. In
   * order for environment variables to be expanded, reference them by using the
   * following syntax:
   * &lt;code&gt;$(&lt;var&gt;VARIABLE_NAME&lt;/var&gt;)&lt;/code&gt;
   * Note that this differs from Bash variable expansion, which does not use
   * parentheses. If a variable cannot be resolved, the reference in the input
   * string is used unchanged. To avoid variable expansion, you can escape this
   * syntax with `$$`; for example:
   * &lt;code&gt;$$(&lt;var&gt;VARIABLE_NAME&lt;/var&gt;)&lt;/code&gt;
   * This field corresponds to the `command` field of the Kubernetes Containers
   * [v1 core
   * API](https://v1-18.docs.kubernetes.io/docs/reference/generated/kubernetes-api/v1.18/#container-v1-core).
   * </pre>
   *
   * <code>repeated string command = 2 [(.google.api.field_behavior) = IMMUTABLE];</code>
   *
   * @return The count of command.
   */
  public int getCommandCount() {
    return command_.size();
  }
  /**
   *
   *
   * <pre>
   * Immutable. Specifies the command that runs when the container starts. This overrides
   * the container's
   * [ENTRYPOINT](https://docs.docker.com/engine/reference/builder/#entrypoint).
   * Specify this field as an array of executable and arguments, similar to a
   * Docker `ENTRYPOINT`'s "exec" form, not its "shell" form.
   * If you do not specify this field, then the container's `ENTRYPOINT` runs,
   * in conjunction with the [args][google.cloud.aiplatform.v1beta1.ModelContainerSpec.args] field or the
   * container's [`CMD`](https://docs.docker.com/engine/reference/builder/#cmd),
   * if either exists. If this field is not specified and the container does not
   * have an `ENTRYPOINT`, then refer to the Docker documentation about [how
   * `CMD` and `ENTRYPOINT`
   * interact](https://docs.docker.com/engine/reference/builder/#understand-how-cmd-and-entrypoint-interact).
   * If you specify this field, then you can also specify the `args` field to
   * provide additional arguments for this command. However, if you specify this
   * field, then the container's `CMD` is ignored. See the
   * [Kubernetes documentation about how the
   * `command` and `args` fields interact with a container's `ENTRYPOINT` and
   * `CMD`](https://kubernetes.io/docs/tasks/inject-data-application/define-command-argument-container/#notes).
   * In this field, you can reference [environment variables set by Vertex
   * AI](https://cloud.google.com/vertex-ai/docs/predictions/custom-container-requirements#aip-variables)
   * and environment variables set in the [env][google.cloud.aiplatform.v1beta1.ModelContainerSpec.env] field.
   * You cannot reference environment variables set in the Docker image. In
   * order for environment variables to be expanded, reference them by using the
   * following syntax:
   * &lt;code&gt;$(&lt;var&gt;VARIABLE_NAME&lt;/var&gt;)&lt;/code&gt;
   * Note that this differs from Bash variable expansion, which does not use
   * parentheses. If a variable cannot be resolved, the reference in the input
   * string is used unchanged. To avoid variable expansion, you can escape this
   * syntax with `$$`; for example:
   * &lt;code&gt;$$(&lt;var&gt;VARIABLE_NAME&lt;/var&gt;)&lt;/code&gt;
   * This field corresponds to the `command` field of the Kubernetes Containers
   * [v1 core
   * API](https://v1-18.docs.kubernetes.io/docs/reference/generated/kubernetes-api/v1.18/#container-v1-core).
   * </pre>
   *
   * <code>repeated string command = 2 [(.google.api.field_behavior) = IMMUTABLE];</code>
   *
   * @param index The index of the element to return.
   * @return The command at the given index.
   */
  public java.lang.String getCommand(int index) {
    return command_.get(index);
  }
  /**
   *
   *
   * <pre>
   * Immutable. Specifies the command that runs when the container starts. This overrides
   * the container's
   * [ENTRYPOINT](https://docs.docker.com/engine/reference/builder/#entrypoint).
   * Specify this field as an array of executable and arguments, similar to a
   * Docker `ENTRYPOINT`'s "exec" form, not its "shell" form.
   * If you do not specify this field, then the container's `ENTRYPOINT` runs,
   * in conjunction with the [args][google.cloud.aiplatform.v1beta1.ModelContainerSpec.args] field or the
   * container's [`CMD`](https://docs.docker.com/engine/reference/builder/#cmd),
   * if either exists. If this field is not specified and the container does not
   * have an `ENTRYPOINT`, then refer to the Docker documentation about [how
   * `CMD` and `ENTRYPOINT`
   * interact](https://docs.docker.com/engine/reference/builder/#understand-how-cmd-and-entrypoint-interact).
   * If you specify this field, then you can also specify the `args` field to
   * provide additional arguments for this command. However, if you specify this
   * field, then the container's `CMD` is ignored. See the
   * [Kubernetes documentation about how the
   * `command` and `args` fields interact with a container's `ENTRYPOINT` and
   * `CMD`](https://kubernetes.io/docs/tasks/inject-data-application/define-command-argument-container/#notes).
   * In this field, you can reference [environment variables set by Vertex
   * AI](https://cloud.google.com/vertex-ai/docs/predictions/custom-container-requirements#aip-variables)
   * and environment variables set in the [env][google.cloud.aiplatform.v1beta1.ModelContainerSpec.env] field.
   * You cannot reference environment variables set in the Docker image. In
   * order for environment variables to be expanded, reference them by using the
   * following syntax:
   * &lt;code&gt;$(&lt;var&gt;VARIABLE_NAME&lt;/var&gt;)&lt;/code&gt;
   * Note that this differs from Bash variable expansion, which does not use
   * parentheses. If a variable cannot be resolved, the reference in the input
   * string is used unchanged. To avoid variable expansion, you can escape this
   * syntax with `$$`; for example:
   * &lt;code&gt;$$(&lt;var&gt;VARIABLE_NAME&lt;/var&gt;)&lt;/code&gt;
   * This field corresponds to the `command` field of the Kubernetes Containers
   * [v1 core
   * API](https://v1-18.docs.kubernetes.io/docs/reference/generated/kubernetes-api/v1.18/#container-v1-core).
   * </pre>
   *
   * <code>repeated string command = 2 [(.google.api.field_behavior) = IMMUTABLE];</code>
   *
   * @param index The index of the value to return.
   * @return The bytes of the command at the given index.
   */
  public com.google.protobuf.ByteString getCommandBytes(int index) {
    return command_.getByteString(index);
  }

  public static final int ARGS_FIELD_NUMBER = 3;
  private com.google.protobuf.LazyStringList args_;
  /**
   *
   *
   * <pre>
   * Immutable. Specifies arguments for the command that runs when the container starts.
   * This overrides the container's
   * [`CMD`](https://docs.docker.com/engine/reference/builder/#cmd). Specify
   * this field as an array of executable and arguments, similar to a Docker
   * `CMD`'s "default parameters" form.
   * If you don't specify this field but do specify the
   * [command][google.cloud.aiplatform.v1beta1.ModelContainerSpec.command] field, then the command from the
   * `command` field runs without any additional arguments. See the
   * [Kubernetes documentation about how the
   * `command` and `args` fields interact with a container's `ENTRYPOINT` and
   * `CMD`](https://kubernetes.io/docs/tasks/inject-data-application/define-command-argument-container/#notes).
   * If you don't specify this field and don't specify the `command` field,
   * then the container's
   * [`ENTRYPOINT`](https://docs.docker.com/engine/reference/builder/#cmd) and
   * `CMD` determine what runs based on their default behavior. See the Docker
   * documentation about [how `CMD` and `ENTRYPOINT`
   * interact](https://docs.docker.com/engine/reference/builder/#understand-how-cmd-and-entrypoint-interact).
   * In this field, you can reference [environment variables
   * set by Vertex
   * AI](https://cloud.google.com/vertex-ai/docs/predictions/custom-container-requirements#aip-variables)
   * and environment variables set in the [env][google.cloud.aiplatform.v1beta1.ModelContainerSpec.env] field.
   * You cannot reference environment variables set in the Docker image. In
   * order for environment variables to be expanded, reference them by using the
   * following syntax:
   * &lt;code&gt;$(&lt;var&gt;VARIABLE_NAME&lt;/var&gt;)&lt;/code&gt;
   * Note that this differs from Bash variable expansion, which does not use
   * parentheses. If a variable cannot be resolved, the reference in the input
   * string is used unchanged. To avoid variable expansion, you can escape this
   * syntax with `$$`; for example:
   * &lt;code&gt;$$(&lt;var&gt;VARIABLE_NAME&lt;/var&gt;)&lt;/code&gt;
   * This field corresponds to the `args` field of the Kubernetes Containers
   * [v1 core
   * API](https://v1-18.docs.kubernetes.io/docs/reference/generated/kubernetes-api/v1.18/#container-v1-core).
   * </pre>
   *
   * <code>repeated string args = 3 [(.google.api.field_behavior) = IMMUTABLE];</code>
   *
   * @return A list containing the args.
   */
  public com.google.protobuf.ProtocolStringList getArgsList() {
    return args_;
  }
  /**
   *
   *
   * <pre>
   * Immutable. Specifies arguments for the command that runs when the container starts.
   * This overrides the container's
   * [`CMD`](https://docs.docker.com/engine/reference/builder/#cmd). Specify
   * this field as an array of executable and arguments, similar to a Docker
   * `CMD`'s "default parameters" form.
   * If you don't specify this field but do specify the
   * [command][google.cloud.aiplatform.v1beta1.ModelContainerSpec.command] field, then the command from the
   * `command` field runs without any additional arguments. See the
   * [Kubernetes documentation about how the
   * `command` and `args` fields interact with a container's `ENTRYPOINT` and
   * `CMD`](https://kubernetes.io/docs/tasks/inject-data-application/define-command-argument-container/#notes).
   * If you don't specify this field and don't specify the `command` field,
   * then the container's
   * [`ENTRYPOINT`](https://docs.docker.com/engine/reference/builder/#cmd) and
   * `CMD` determine what runs based on their default behavior. See the Docker
   * documentation about [how `CMD` and `ENTRYPOINT`
   * interact](https://docs.docker.com/engine/reference/builder/#understand-how-cmd-and-entrypoint-interact).
   * In this field, you can reference [environment variables
   * set by Vertex
   * AI](https://cloud.google.com/vertex-ai/docs/predictions/custom-container-requirements#aip-variables)
   * and environment variables set in the [env][google.cloud.aiplatform.v1beta1.ModelContainerSpec.env] field.
   * You cannot reference environment variables set in the Docker image. In
   * order for environment variables to be expanded, reference them by using the
   * following syntax:
   * &lt;code&gt;$(&lt;var&gt;VARIABLE_NAME&lt;/var&gt;)&lt;/code&gt;
   * Note that this differs from Bash variable expansion, which does not use
   * parentheses. If a variable cannot be resolved, the reference in the input
   * string is used unchanged. To avoid variable expansion, you can escape this
   * syntax with `$$`; for example:
   * &lt;code&gt;$$(&lt;var&gt;VARIABLE_NAME&lt;/var&gt;)&lt;/code&gt;
   * This field corresponds to the `args` field of the Kubernetes Containers
   * [v1 core
   * API](https://v1-18.docs.kubernetes.io/docs/reference/generated/kubernetes-api/v1.18/#container-v1-core).
   * </pre>
   *
   * <code>repeated string args = 3 [(.google.api.field_behavior) = IMMUTABLE];</code>
   *
   * @return The count of args.
   */
  public int getArgsCount() {
    return args_.size();
  }
  /**
   *
   *
   * <pre>
   * Immutable. Specifies arguments for the command that runs when the container starts.
   * This overrides the container's
   * [`CMD`](https://docs.docker.com/engine/reference/builder/#cmd). Specify
   * this field as an array of executable and arguments, similar to a Docker
   * `CMD`'s "default parameters" form.
   * If you don't specify this field but do specify the
   * [command][google.cloud.aiplatform.v1beta1.ModelContainerSpec.command] field, then the command from the
   * `command` field runs without any additional arguments. See the
   * [Kubernetes documentation about how the
   * `command` and `args` fields interact with a container's `ENTRYPOINT` and
   * `CMD`](https://kubernetes.io/docs/tasks/inject-data-application/define-command-argument-container/#notes).
   * If you don't specify this field and don't specify the `command` field,
   * then the container's
   * [`ENTRYPOINT`](https://docs.docker.com/engine/reference/builder/#cmd) and
   * `CMD` determine what runs based on their default behavior. See the Docker
   * documentation about [how `CMD` and `ENTRYPOINT`
   * interact](https://docs.docker.com/engine/reference/builder/#understand-how-cmd-and-entrypoint-interact).
   * In this field, you can reference [environment variables
   * set by Vertex
   * AI](https://cloud.google.com/vertex-ai/docs/predictions/custom-container-requirements#aip-variables)
   * and environment variables set in the [env][google.cloud.aiplatform.v1beta1.ModelContainerSpec.env] field.
   * You cannot reference environment variables set in the Docker image. In
   * order for environment variables to be expanded, reference them by using the
   * following syntax:
   * &lt;code&gt;$(&lt;var&gt;VARIABLE_NAME&lt;/var&gt;)&lt;/code&gt;
   * Note that this differs from Bash variable expansion, which does not use
   * parentheses. If a variable cannot be resolved, the reference in the input
   * string is used unchanged. To avoid variable expansion, you can escape this
   * syntax with `$$`; for example:
   * &lt;code&gt;$$(&lt;var&gt;VARIABLE_NAME&lt;/var&gt;)&lt;/code&gt;
   * This field corresponds to the `args` field of the Kubernetes Containers
   * [v1 core
   * API](https://v1-18.docs.kubernetes.io/docs/reference/generated/kubernetes-api/v1.18/#container-v1-core).
   * </pre>
   *
   * <code>repeated string args = 3 [(.google.api.field_behavior) = IMMUTABLE];</code>
   *
   * @param index The index of the element to return.
   * @return The args at the given index.
   */
  public java.lang.String getArgs(int index) {
    return args_.get(index);
  }
  /**
   *
   *
   * <pre>
   * Immutable. Specifies arguments for the command that runs when the container starts.
   * This overrides the container's
   * [`CMD`](https://docs.docker.com/engine/reference/builder/#cmd). Specify
   * this field as an array of executable and arguments, similar to a Docker
   * `CMD`'s "default parameters" form.
   * If you don't specify this field but do specify the
   * [command][google.cloud.aiplatform.v1beta1.ModelContainerSpec.command] field, then the command from the
   * `command` field runs without any additional arguments. See the
   * [Kubernetes documentation about how the
   * `command` and `args` fields interact with a container's `ENTRYPOINT` and
   * `CMD`](https://kubernetes.io/docs/tasks/inject-data-application/define-command-argument-container/#notes).
   * If you don't specify this field and don't specify the `command` field,
   * then the container's
   * [`ENTRYPOINT`](https://docs.docker.com/engine/reference/builder/#cmd) and
   * `CMD` determine what runs based on their default behavior. See the Docker
   * documentation about [how `CMD` and `ENTRYPOINT`
   * interact](https://docs.docker.com/engine/reference/builder/#understand-how-cmd-and-entrypoint-interact).
   * In this field, you can reference [environment variables
   * set by Vertex
   * AI](https://cloud.google.com/vertex-ai/docs/predictions/custom-container-requirements#aip-variables)
   * and environment variables set in the [env][google.cloud.aiplatform.v1beta1.ModelContainerSpec.env] field.
   * You cannot reference environment variables set in the Docker image. In
   * order for environment variables to be expanded, reference them by using the
   * following syntax:
   * &lt;code&gt;$(&lt;var&gt;VARIABLE_NAME&lt;/var&gt;)&lt;/code&gt;
   * Note that this differs from Bash variable expansion, which does not use
   * parentheses. If a variable cannot be resolved, the reference in the input
   * string is used unchanged. To avoid variable expansion, you can escape this
   * syntax with `$$`; for example:
   * &lt;code&gt;$$(&lt;var&gt;VARIABLE_NAME&lt;/var&gt;)&lt;/code&gt;
   * This field corresponds to the `args` field of the Kubernetes Containers
   * [v1 core
   * API](https://v1-18.docs.kubernetes.io/docs/reference/generated/kubernetes-api/v1.18/#container-v1-core).
   * </pre>
   *
   * <code>repeated string args = 3 [(.google.api.field_behavior) = IMMUTABLE];</code>
   *
   * @param index The index of the value to return.
   * @return The bytes of the args at the given index.
   */
  public com.google.protobuf.ByteString getArgsBytes(int index) {
    return args_.getByteString(index);
  }

  public static final int ENV_FIELD_NUMBER = 4;
  private java.util.List<com.google.cloud.aiplatform.v1beta1.EnvVar> env_;
  /**
   *
   *
   * <pre>
   * Immutable. List of environment variables to set in the container. After the container
   * starts running, code running in the container can read these environment
   * variables.
   * Additionally, the [command][google.cloud.aiplatform.v1beta1.ModelContainerSpec.command] and
   * [args][google.cloud.aiplatform.v1beta1.ModelContainerSpec.args] fields can reference these variables. Later
   * entries in this list can also reference earlier entries. For example, the
   * following example sets the variable `VAR_2` to have the value `foo bar`:
   * ```json
   * [
   *   {
   *     "name": "VAR_1",
   *     "value": "foo"
   *   },
   *   {
   *     "name": "VAR_2",
   *     "value": "$(VAR_1) bar"
   *   }
   * ]
   * ```
   * If you switch the order of the variables in the example, then the expansion
   * does not occur.
   * This field corresponds to the `env` field of the Kubernetes Containers
   * [v1 core
   * API](https://v1-18.docs.kubernetes.io/docs/reference/generated/kubernetes-api/v1.18/#container-v1-core).
   * </pre>
   *
   * <code>
   * repeated .google.cloud.aiplatform.v1beta1.EnvVar env = 4 [(.google.api.field_behavior) = IMMUTABLE];
   * </code>
   */
  @java.lang.Override
  public java.util.List<com.google.cloud.aiplatform.v1beta1.EnvVar> getEnvList() {
    return env_;
  }
  /**
   *
   *
   * <pre>
   * Immutable. List of environment variables to set in the container. After the container
   * starts running, code running in the container can read these environment
   * variables.
   * Additionally, the [command][google.cloud.aiplatform.v1beta1.ModelContainerSpec.command] and
   * [args][google.cloud.aiplatform.v1beta1.ModelContainerSpec.args] fields can reference these variables. Later
   * entries in this list can also reference earlier entries. For example, the
   * following example sets the variable `VAR_2` to have the value `foo bar`:
   * ```json
   * [
   *   {
   *     "name": "VAR_1",
   *     "value": "foo"
   *   },
   *   {
   *     "name": "VAR_2",
   *     "value": "$(VAR_1) bar"
   *   }
   * ]
   * ```
   * If you switch the order of the variables in the example, then the expansion
   * does not occur.
   * This field corresponds to the `env` field of the Kubernetes Containers
   * [v1 core
   * API](https://v1-18.docs.kubernetes.io/docs/reference/generated/kubernetes-api/v1.18/#container-v1-core).
   * </pre>
   *
   * <code>
   * repeated .google.cloud.aiplatform.v1beta1.EnvVar env = 4 [(.google.api.field_behavior) = IMMUTABLE];
   * </code>
   */
  @java.lang.Override
  public java.util.List<? extends com.google.cloud.aiplatform.v1beta1.EnvVarOrBuilder>
      getEnvOrBuilderList() {
    return env_;
  }
  /**
   *
   *
   * <pre>
   * Immutable. List of environment variables to set in the container. After the container
   * starts running, code running in the container can read these environment
   * variables.
   * Additionally, the [command][google.cloud.aiplatform.v1beta1.ModelContainerSpec.command] and
   * [args][google.cloud.aiplatform.v1beta1.ModelContainerSpec.args] fields can reference these variables. Later
   * entries in this list can also reference earlier entries. For example, the
   * following example sets the variable `VAR_2` to have the value `foo bar`:
   * ```json
   * [
   *   {
   *     "name": "VAR_1",
   *     "value": "foo"
   *   },
   *   {
   *     "name": "VAR_2",
   *     "value": "$(VAR_1) bar"
   *   }
   * ]
   * ```
   * If you switch the order of the variables in the example, then the expansion
   * does not occur.
   * This field corresponds to the `env` field of the Kubernetes Containers
   * [v1 core
   * API](https://v1-18.docs.kubernetes.io/docs/reference/generated/kubernetes-api/v1.18/#container-v1-core).
   * </pre>
   *
   * <code>
   * repeated .google.cloud.aiplatform.v1beta1.EnvVar env = 4 [(.google.api.field_behavior) = IMMUTABLE];
   * </code>
   */
  @java.lang.Override
  public int getEnvCount() {
    return env_.size();
  }
  /**
   *
   *
   * <pre>
   * Immutable. List of environment variables to set in the container. After the container
   * starts running, code running in the container can read these environment
   * variables.
   * Additionally, the [command][google.cloud.aiplatform.v1beta1.ModelContainerSpec.command] and
   * [args][google.cloud.aiplatform.v1beta1.ModelContainerSpec.args] fields can reference these variables. Later
   * entries in this list can also reference earlier entries. For example, the
   * following example sets the variable `VAR_2` to have the value `foo bar`:
   * ```json
   * [
   *   {
   *     "name": "VAR_1",
   *     "value": "foo"
   *   },
   *   {
   *     "name": "VAR_2",
   *     "value": "$(VAR_1) bar"
   *   }
   * ]
   * ```
   * If you switch the order of the variables in the example, then the expansion
   * does not occur.
   * This field corresponds to the `env` field of the Kubernetes Containers
   * [v1 core
   * API](https://v1-18.docs.kubernetes.io/docs/reference/generated/kubernetes-api/v1.18/#container-v1-core).
   * </pre>
   *
   * <code>
   * repeated .google.cloud.aiplatform.v1beta1.EnvVar env = 4 [(.google.api.field_behavior) = IMMUTABLE];
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.aiplatform.v1beta1.EnvVar getEnv(int index) {
    return env_.get(index);
  }
  /**
   *
   *
   * <pre>
   * Immutable. List of environment variables to set in the container. After the container
   * starts running, code running in the container can read these environment
   * variables.
   * Additionally, the [command][google.cloud.aiplatform.v1beta1.ModelContainerSpec.command] and
   * [args][google.cloud.aiplatform.v1beta1.ModelContainerSpec.args] fields can reference these variables. Later
   * entries in this list can also reference earlier entries. For example, the
   * following example sets the variable `VAR_2` to have the value `foo bar`:
   * ```json
   * [
   *   {
   *     "name": "VAR_1",
   *     "value": "foo"
   *   },
   *   {
   *     "name": "VAR_2",
   *     "value": "$(VAR_1) bar"
   *   }
   * ]
   * ```
   * If you switch the order of the variables in the example, then the expansion
   * does not occur.
   * This field corresponds to the `env` field of the Kubernetes Containers
   * [v1 core
   * API](https://v1-18.docs.kubernetes.io/docs/reference/generated/kubernetes-api/v1.18/#container-v1-core).
   * </pre>
   *
   * <code>
   * repeated .google.cloud.aiplatform.v1beta1.EnvVar env = 4 [(.google.api.field_behavior) = IMMUTABLE];
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.aiplatform.v1beta1.EnvVarOrBuilder getEnvOrBuilder(int index) {
    return env_.get(index);
  }

  public static final int PORTS_FIELD_NUMBER = 5;
  private java.util.List<com.google.cloud.aiplatform.v1beta1.Port> ports_;
  /**
   *
   *
   * <pre>
   * Immutable. List of ports to expose from the container. Vertex AI sends any
   * prediction requests that it receives to the first port on this list. Vertex
   * AI also sends
   * [liveness and health
   * checks](https://cloud.google.com/vertex-ai/docs/predictions/custom-container-requirements#liveness)
   * to this port.
   * If you do not specify this field, it defaults to following value:
   * ```json
   * [
   *   {
   *     "containerPort": 8080
   *   }
   * ]
   * ```
   * Vertex AI does not use ports other than the first one listed. This field
   * corresponds to the `ports` field of the Kubernetes Containers
   * [v1 core
   * API](https://v1-18.docs.kubernetes.io/docs/reference/generated/kubernetes-api/v1.18/#container-v1-core).
   * </pre>
   *
   * <code>
   * repeated .google.cloud.aiplatform.v1beta1.Port ports = 5 [(.google.api.field_behavior) = IMMUTABLE];
   * </code>
   */
  @java.lang.Override
  public java.util.List<com.google.cloud.aiplatform.v1beta1.Port> getPortsList() {
    return ports_;
  }
  /**
   *
   *
   * <pre>
   * Immutable. List of ports to expose from the container. Vertex AI sends any
   * prediction requests that it receives to the first port on this list. Vertex
   * AI also sends
   * [liveness and health
   * checks](https://cloud.google.com/vertex-ai/docs/predictions/custom-container-requirements#liveness)
   * to this port.
   * If you do not specify this field, it defaults to following value:
   * ```json
   * [
   *   {
   *     "containerPort": 8080
   *   }
   * ]
   * ```
   * Vertex AI does not use ports other than the first one listed. This field
   * corresponds to the `ports` field of the Kubernetes Containers
   * [v1 core
   * API](https://v1-18.docs.kubernetes.io/docs/reference/generated/kubernetes-api/v1.18/#container-v1-core).
   * </pre>
   *
   * <code>
   * repeated .google.cloud.aiplatform.v1beta1.Port ports = 5 [(.google.api.field_behavior) = IMMUTABLE];
   * </code>
   */
  @java.lang.Override
  public java.util.List<? extends com.google.cloud.aiplatform.v1beta1.PortOrBuilder>
      getPortsOrBuilderList() {
    return ports_;
  }
  /**
   *
   *
   * <pre>
   * Immutable. List of ports to expose from the container. Vertex AI sends any
   * prediction requests that it receives to the first port on this list. Vertex
   * AI also sends
   * [liveness and health
   * checks](https://cloud.google.com/vertex-ai/docs/predictions/custom-container-requirements#liveness)
   * to this port.
   * If you do not specify this field, it defaults to following value:
   * ```json
   * [
   *   {
   *     "containerPort": 8080
   *   }
   * ]
   * ```
   * Vertex AI does not use ports other than the first one listed. This field
   * corresponds to the `ports` field of the Kubernetes Containers
   * [v1 core
   * API](https://v1-18.docs.kubernetes.io/docs/reference/generated/kubernetes-api/v1.18/#container-v1-core).
   * </pre>
   *
   * <code>
   * repeated .google.cloud.aiplatform.v1beta1.Port ports = 5 [(.google.api.field_behavior) = IMMUTABLE];
   * </code>
   */
  @java.lang.Override
  public int getPortsCount() {
    return ports_.size();
  }
  /**
   *
   *
   * <pre>
   * Immutable. List of ports to expose from the container. Vertex AI sends any
   * prediction requests that it receives to the first port on this list. Vertex
   * AI also sends
   * [liveness and health
   * checks](https://cloud.google.com/vertex-ai/docs/predictions/custom-container-requirements#liveness)
   * to this port.
   * If you do not specify this field, it defaults to following value:
   * ```json
   * [
   *   {
   *     "containerPort": 8080
   *   }
   * ]
   * ```
   * Vertex AI does not use ports other than the first one listed. This field
   * corresponds to the `ports` field of the Kubernetes Containers
   * [v1 core
   * API](https://v1-18.docs.kubernetes.io/docs/reference/generated/kubernetes-api/v1.18/#container-v1-core).
   * </pre>
   *
   * <code>
   * repeated .google.cloud.aiplatform.v1beta1.Port ports = 5 [(.google.api.field_behavior) = IMMUTABLE];
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.aiplatform.v1beta1.Port getPorts(int index) {
    return ports_.get(index);
  }
  /**
   *
   *
   * <pre>
   * Immutable. List of ports to expose from the container. Vertex AI sends any
   * prediction requests that it receives to the first port on this list. Vertex
   * AI also sends
   * [liveness and health
   * checks](https://cloud.google.com/vertex-ai/docs/predictions/custom-container-requirements#liveness)
   * to this port.
   * If you do not specify this field, it defaults to following value:
   * ```json
   * [
   *   {
   *     "containerPort": 8080
   *   }
   * ]
   * ```
   * Vertex AI does not use ports other than the first one listed. This field
   * corresponds to the `ports` field of the Kubernetes Containers
   * [v1 core
   * API](https://v1-18.docs.kubernetes.io/docs/reference/generated/kubernetes-api/v1.18/#container-v1-core).
   * </pre>
   *
   * <code>
   * repeated .google.cloud.aiplatform.v1beta1.Port ports = 5 [(.google.api.field_behavior) = IMMUTABLE];
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.aiplatform.v1beta1.PortOrBuilder getPortsOrBuilder(int index) {
    return ports_.get(index);
  }

  public static final int PREDICT_ROUTE_FIELD_NUMBER = 6;
  private volatile java.lang.Object predictRoute_;
  /**
   *
   *
   * <pre>
   * Immutable. HTTP path on the container to send prediction requests to. Vertex AI
   * forwards requests sent using
   * [projects.locations.endpoints.predict][google.cloud.aiplatform.v1beta1.PredictionService.Predict] to this
   * path on the container's IP address and port. Vertex AI then returns the
   * container's response in the API response.
   * For example, if you set this field to `/foo`, then when Vertex AI
   * receives a prediction request, it forwards the request body in a POST
   * request to the `/foo` path on the port of your container specified by the
   * first value of this `ModelContainerSpec`'s
   * [ports][google.cloud.aiplatform.v1beta1.ModelContainerSpec.ports] field.
   * If you don't specify this field, it defaults to the following value when
   * you [deploy this Model to an Endpoint][google.cloud.aiplatform.v1beta1.EndpointService.DeployModel]:
   * &lt;code&gt;/v1/endpoints/&lt;var&gt;ENDPOINT&lt;/var&gt;/deployedModels/&lt;var&gt;DEPLOYED_MODEL&lt;/var&gt;:predict&lt;/code&gt;
   * The placeholders in this value are replaced as follows:
   * * &lt;var&gt;ENDPOINT&lt;/var&gt;: The last segment (following `endpoints/`)of the
   *   Endpoint.name][] field of the Endpoint where this Model has been
   *   deployed. (Vertex AI makes this value available to your container code
   *   as the [`AIP_ENDPOINT_ID` environment
   *  variable](https://cloud.google.com/vertex-ai/docs/predictions/custom-container-requirements#aip-variables).)
   * * &lt;var&gt;DEPLOYED_MODEL&lt;/var&gt;: [DeployedModel.id][google.cloud.aiplatform.v1beta1.DeployedModel.id] of the `DeployedModel`.
   *   (Vertex AI makes this value available to your container code
   *   as the [`AIP_DEPLOYED_MODEL_ID` environment
   *   variable](https://cloud.google.com/vertex-ai/docs/predictions/custom-container-requirements#aip-variables).)
   * </pre>
   *
   * <code>string predict_route = 6 [(.google.api.field_behavior) = IMMUTABLE];</code>
   *
   * @return The predictRoute.
   */
  @java.lang.Override
  public java.lang.String getPredictRoute() {
    java.lang.Object ref = predictRoute_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      predictRoute_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Immutable. HTTP path on the container to send prediction requests to. Vertex AI
   * forwards requests sent using
   * [projects.locations.endpoints.predict][google.cloud.aiplatform.v1beta1.PredictionService.Predict] to this
   * path on the container's IP address and port. Vertex AI then returns the
   * container's response in the API response.
   * For example, if you set this field to `/foo`, then when Vertex AI
   * receives a prediction request, it forwards the request body in a POST
   * request to the `/foo` path on the port of your container specified by the
   * first value of this `ModelContainerSpec`'s
   * [ports][google.cloud.aiplatform.v1beta1.ModelContainerSpec.ports] field.
   * If you don't specify this field, it defaults to the following value when
   * you [deploy this Model to an Endpoint][google.cloud.aiplatform.v1beta1.EndpointService.DeployModel]:
   * &lt;code&gt;/v1/endpoints/&lt;var&gt;ENDPOINT&lt;/var&gt;/deployedModels/&lt;var&gt;DEPLOYED_MODEL&lt;/var&gt;:predict&lt;/code&gt;
   * The placeholders in this value are replaced as follows:
   * * &lt;var&gt;ENDPOINT&lt;/var&gt;: The last segment (following `endpoints/`)of the
   *   Endpoint.name][] field of the Endpoint where this Model has been
   *   deployed. (Vertex AI makes this value available to your container code
   *   as the [`AIP_ENDPOINT_ID` environment
   *  variable](https://cloud.google.com/vertex-ai/docs/predictions/custom-container-requirements#aip-variables).)
   * * &lt;var&gt;DEPLOYED_MODEL&lt;/var&gt;: [DeployedModel.id][google.cloud.aiplatform.v1beta1.DeployedModel.id] of the `DeployedModel`.
   *   (Vertex AI makes this value available to your container code
   *   as the [`AIP_DEPLOYED_MODEL_ID` environment
   *   variable](https://cloud.google.com/vertex-ai/docs/predictions/custom-container-requirements#aip-variables).)
   * </pre>
   *
   * <code>string predict_route = 6 [(.google.api.field_behavior) = IMMUTABLE];</code>
   *
   * @return The bytes for predictRoute.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getPredictRouteBytes() {
    java.lang.Object ref = predictRoute_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      predictRoute_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int HEALTH_ROUTE_FIELD_NUMBER = 7;
  private volatile java.lang.Object healthRoute_;
  /**
   *
   *
   * <pre>
   * Immutable. HTTP path on the container to send health checks to. Vertex AI
   * intermittently sends GET requests to this path on the container's IP
   * address and port to check that the container is healthy. Read more about
   * [health
   * checks](https://cloud.google.com/vertex-ai/docs/predictions/custom-container-requirements#health).
   * For example, if you set this field to `/bar`, then Vertex AI
   * intermittently sends a GET request to the `/bar` path on the port of your
   * container specified by the first value of this `ModelContainerSpec`'s
   * [ports][google.cloud.aiplatform.v1beta1.ModelContainerSpec.ports] field.
   * If you don't specify this field, it defaults to the following value when
   * you [deploy this Model to an Endpoint][google.cloud.aiplatform.v1beta1.EndpointService.DeployModel]:
   * &lt;code&gt;/v1/endpoints/&lt;var&gt;ENDPOINT&lt;/var&gt;/deployedModels/&lt;var&gt;DEPLOYED_MODEL&lt;/var&gt;:predict&lt;/code&gt;
   * The placeholders in this value are replaced as follows:
   * * &lt;var&gt;ENDPOINT&lt;/var&gt;: The last segment (following `endpoints/`)of the
   *   Endpoint.name][] field of the Endpoint where this Model has been
   *   deployed. (Vertex AI makes this value available to your container code
   *   as the [`AIP_ENDPOINT_ID` environment
   *   variable](https://cloud.google.com/vertex-ai/docs/predictions/custom-container-requirements#aip-variables).)
   * * &lt;var&gt;DEPLOYED_MODEL&lt;/var&gt;: [DeployedModel.id][google.cloud.aiplatform.v1beta1.DeployedModel.id] of the `DeployedModel`.
   *   (Vertex AI makes this value available to your container code as the
   *   [`AIP_DEPLOYED_MODEL_ID` environment
   *   variable](https://cloud.google.com/vertex-ai/docs/predictions/custom-container-requirements#aip-variables).)
   * </pre>
   *
   * <code>string health_route = 7 [(.google.api.field_behavior) = IMMUTABLE];</code>
   *
   * @return The healthRoute.
   */
  @java.lang.Override
  public java.lang.String getHealthRoute() {
    java.lang.Object ref = healthRoute_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      healthRoute_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Immutable. HTTP path on the container to send health checks to. Vertex AI
   * intermittently sends GET requests to this path on the container's IP
   * address and port to check that the container is healthy. Read more about
   * [health
   * checks](https://cloud.google.com/vertex-ai/docs/predictions/custom-container-requirements#health).
   * For example, if you set this field to `/bar`, then Vertex AI
   * intermittently sends a GET request to the `/bar` path on the port of your
   * container specified by the first value of this `ModelContainerSpec`'s
   * [ports][google.cloud.aiplatform.v1beta1.ModelContainerSpec.ports] field.
   * If you don't specify this field, it defaults to the following value when
   * you [deploy this Model to an Endpoint][google.cloud.aiplatform.v1beta1.EndpointService.DeployModel]:
   * &lt;code&gt;/v1/endpoints/&lt;var&gt;ENDPOINT&lt;/var&gt;/deployedModels/&lt;var&gt;DEPLOYED_MODEL&lt;/var&gt;:predict&lt;/code&gt;
   * The placeholders in this value are replaced as follows:
   * * &lt;var&gt;ENDPOINT&lt;/var&gt;: The last segment (following `endpoints/`)of the
   *   Endpoint.name][] field of the Endpoint where this Model has been
   *   deployed. (Vertex AI makes this value available to your container code
   *   as the [`AIP_ENDPOINT_ID` environment
   *   variable](https://cloud.google.com/vertex-ai/docs/predictions/custom-container-requirements#aip-variables).)
   * * &lt;var&gt;DEPLOYED_MODEL&lt;/var&gt;: [DeployedModel.id][google.cloud.aiplatform.v1beta1.DeployedModel.id] of the `DeployedModel`.
   *   (Vertex AI makes this value available to your container code as the
   *   [`AIP_DEPLOYED_MODEL_ID` environment
   *   variable](https://cloud.google.com/vertex-ai/docs/predictions/custom-container-requirements#aip-variables).)
   * </pre>
   *
   * <code>string health_route = 7 [(.google.api.field_behavior) = IMMUTABLE];</code>
   *
   * @return The bytes for healthRoute.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getHealthRouteBytes() {
    java.lang.Object ref = healthRoute_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      healthRoute_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    if (!getImageUriBytes().isEmpty()) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 1, imageUri_);
    }
    for (int i = 0; i < command_.size(); i++) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 2, command_.getRaw(i));
    }
    for (int i = 0; i < args_.size(); i++) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 3, args_.getRaw(i));
    }
    for (int i = 0; i < env_.size(); i++) {
      output.writeMessage(4, env_.get(i));
    }
    for (int i = 0; i < ports_.size(); i++) {
      output.writeMessage(5, ports_.get(i));
    }
    if (!getPredictRouteBytes().isEmpty()) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 6, predictRoute_);
    }
    if (!getHealthRouteBytes().isEmpty()) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 7, healthRoute_);
    }
    unknownFields.writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    if (!getImageUriBytes().isEmpty()) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(1, imageUri_);
    }
    {
      int dataSize = 0;
      for (int i = 0; i < command_.size(); i++) {
        dataSize += computeStringSizeNoTag(command_.getRaw(i));
      }
      size += dataSize;
      size += 1 * getCommandList().size();
    }
    {
      int dataSize = 0;
      for (int i = 0; i < args_.size(); i++) {
        dataSize += computeStringSizeNoTag(args_.getRaw(i));
      }
      size += dataSize;
      size += 1 * getArgsList().size();
    }
    for (int i = 0; i < env_.size(); i++) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(4, env_.get(i));
    }
    for (int i = 0; i < ports_.size(); i++) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(5, ports_.get(i));
    }
    if (!getPredictRouteBytes().isEmpty()) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(6, predictRoute_);
    }
    if (!getHealthRouteBytes().isEmpty()) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(7, healthRoute_);
    }
    size += unknownFields.getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.cloud.aiplatform.v1beta1.ModelContainerSpec)) {
      return super.equals(obj);
    }
    com.google.cloud.aiplatform.v1beta1.ModelContainerSpec other =
        (com.google.cloud.aiplatform.v1beta1.ModelContainerSpec) obj;

    if (!getImageUri().equals(other.getImageUri())) return false;
    if (!getCommandList().equals(other.getCommandList())) return false;
    if (!getArgsList().equals(other.getArgsList())) return false;
    if (!getEnvList().equals(other.getEnvList())) return false;
    if (!getPortsList().equals(other.getPortsList())) return false;
    if (!getPredictRoute().equals(other.getPredictRoute())) return false;
    if (!getHealthRoute().equals(other.getHealthRoute())) return false;
    if (!unknownFields.equals(other.unknownFields)) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    hash = (37 * hash) + IMAGE_URI_FIELD_NUMBER;
    hash = (53 * hash) + getImageUri().hashCode();
    if (getCommandCount() > 0) {
      hash = (37 * hash) + COMMAND_FIELD_NUMBER;
      hash = (53 * hash) + getCommandList().hashCode();
    }
    if (getArgsCount() > 0) {
      hash = (37 * hash) + ARGS_FIELD_NUMBER;
      hash = (53 * hash) + getArgsList().hashCode();
    }
    if (getEnvCount() > 0) {
      hash = (37 * hash) + ENV_FIELD_NUMBER;
      hash = (53 * hash) + getEnvList().hashCode();
    }
    if (getPortsCount() > 0) {
      hash = (37 * hash) + PORTS_FIELD_NUMBER;
      hash = (53 * hash) + getPortsList().hashCode();
    }
    hash = (37 * hash) + PREDICT_ROUTE_FIELD_NUMBER;
    hash = (53 * hash) + getPredictRoute().hashCode();
    hash = (37 * hash) + HEALTH_ROUTE_FIELD_NUMBER;
    hash = (53 * hash) + getHealthRoute().hashCode();
    hash = (29 * hash) + unknownFields.hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.cloud.aiplatform.v1beta1.ModelContainerSpec parseFrom(
      java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.aiplatform.v1beta1.ModelContainerSpec parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.aiplatform.v1beta1.ModelContainerSpec parseFrom(
      com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.aiplatform.v1beta1.ModelContainerSpec parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.aiplatform.v1beta1.ModelContainerSpec parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.aiplatform.v1beta1.ModelContainerSpec parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.aiplatform.v1beta1.ModelContainerSpec parseFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.aiplatform.v1beta1.ModelContainerSpec parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.aiplatform.v1beta1.ModelContainerSpec parseDelimitedFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.cloud.aiplatform.v1beta1.ModelContainerSpec parseDelimitedFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.aiplatform.v1beta1.ModelContainerSpec parseFrom(
      com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.aiplatform.v1beta1.ModelContainerSpec parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(
      com.google.cloud.aiplatform.v1beta1.ModelContainerSpec prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }
  /**
   *
   *
   * <pre>
   * Specification of a container for serving predictions. Some fields in this
   * message correspond to fields in the [Kubernetes Container v1 core
   * specification](https://v1-18.docs.kubernetes.io/docs/reference/generated/kubernetes-api/v1.18/#container-v1-core).
   * </pre>
   *
   * Protobuf type {@code google.cloud.aiplatform.v1beta1.ModelContainerSpec}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.cloud.aiplatform.v1beta1.ModelContainerSpec)
      com.google.cloud.aiplatform.v1beta1.ModelContainerSpecOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.aiplatform.v1beta1.ModelProto
          .internal_static_google_cloud_aiplatform_v1beta1_ModelContainerSpec_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.aiplatform.v1beta1.ModelProto
          .internal_static_google_cloud_aiplatform_v1beta1_ModelContainerSpec_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.aiplatform.v1beta1.ModelContainerSpec.class,
              com.google.cloud.aiplatform.v1beta1.ModelContainerSpec.Builder.class);
    }

    // Construct using com.google.cloud.aiplatform.v1beta1.ModelContainerSpec.newBuilder()
    private Builder() {
      maybeForceBuilderInitialization();
    }

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
      maybeForceBuilderInitialization();
    }

    private void maybeForceBuilderInitialization() {
      if (com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders) {
        getEnvFieldBuilder();
        getPortsFieldBuilder();
      }
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      imageUri_ = "";

      command_ = com.google.protobuf.LazyStringArrayList.EMPTY;
      bitField0_ = (bitField0_ & ~0x00000001);
      args_ = com.google.protobuf.LazyStringArrayList.EMPTY;
      bitField0_ = (bitField0_ & ~0x00000002);
      if (envBuilder_ == null) {
        env_ = java.util.Collections.emptyList();
        bitField0_ = (bitField0_ & ~0x00000004);
      } else {
        envBuilder_.clear();
      }
      if (portsBuilder_ == null) {
        ports_ = java.util.Collections.emptyList();
        bitField0_ = (bitField0_ & ~0x00000008);
      } else {
        portsBuilder_.clear();
      }
      predictRoute_ = "";

      healthRoute_ = "";

      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.cloud.aiplatform.v1beta1.ModelProto
          .internal_static_google_cloud_aiplatform_v1beta1_ModelContainerSpec_descriptor;
    }

    @java.lang.Override
    public com.google.cloud.aiplatform.v1beta1.ModelContainerSpec getDefaultInstanceForType() {
      return com.google.cloud.aiplatform.v1beta1.ModelContainerSpec.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.cloud.aiplatform.v1beta1.ModelContainerSpec build() {
      com.google.cloud.aiplatform.v1beta1.ModelContainerSpec result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.cloud.aiplatform.v1beta1.ModelContainerSpec buildPartial() {
      com.google.cloud.aiplatform.v1beta1.ModelContainerSpec result =
          new com.google.cloud.aiplatform.v1beta1.ModelContainerSpec(this);
      int from_bitField0_ = bitField0_;
      result.imageUri_ = imageUri_;
      if (((bitField0_ & 0x00000001) != 0)) {
        command_ = command_.getUnmodifiableView();
        bitField0_ = (bitField0_ & ~0x00000001);
      }
      result.command_ = command_;
      if (((bitField0_ & 0x00000002) != 0)) {
        args_ = args_.getUnmodifiableView();
        bitField0_ = (bitField0_ & ~0x00000002);
      }
      result.args_ = args_;
      if (envBuilder_ == null) {
        if (((bitField0_ & 0x00000004) != 0)) {
          env_ = java.util.Collections.unmodifiableList(env_);
          bitField0_ = (bitField0_ & ~0x00000004);
        }
        result.env_ = env_;
      } else {
        result.env_ = envBuilder_.build();
      }
      if (portsBuilder_ == null) {
        if (((bitField0_ & 0x00000008) != 0)) {
          ports_ = java.util.Collections.unmodifiableList(ports_);
          bitField0_ = (bitField0_ & ~0x00000008);
        }
        result.ports_ = ports_;
      } else {
        result.ports_ = portsBuilder_.build();
      }
      result.predictRoute_ = predictRoute_;
      result.healthRoute_ = healthRoute_;
      onBuilt();
      return result;
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.cloud.aiplatform.v1beta1.ModelContainerSpec) {
        return mergeFrom((com.google.cloud.aiplatform.v1beta1.ModelContainerSpec) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(com.google.cloud.aiplatform.v1beta1.ModelContainerSpec other) {
      if (other == com.google.cloud.aiplatform.v1beta1.ModelContainerSpec.getDefaultInstance())
        return this;
      if (!other.getImageUri().isEmpty()) {
        imageUri_ = other.imageUri_;
        onChanged();
      }
      if (!other.command_.isEmpty()) {
        if (command_.isEmpty()) {
          command_ = other.command_;
          bitField0_ = (bitField0_ & ~0x00000001);
        } else {
          ensureCommandIsMutable();
          command_.addAll(other.command_);
        }
        onChanged();
      }
      if (!other.args_.isEmpty()) {
        if (args_.isEmpty()) {
          args_ = other.args_;
          bitField0_ = (bitField0_ & ~0x00000002);
        } else {
          ensureArgsIsMutable();
          args_.addAll(other.args_);
        }
        onChanged();
      }
      if (envBuilder_ == null) {
        if (!other.env_.isEmpty()) {
          if (env_.isEmpty()) {
            env_ = other.env_;
            bitField0_ = (bitField0_ & ~0x00000004);
          } else {
            ensureEnvIsMutable();
            env_.addAll(other.env_);
          }
          onChanged();
        }
      } else {
        if (!other.env_.isEmpty()) {
          if (envBuilder_.isEmpty()) {
            envBuilder_.dispose();
            envBuilder_ = null;
            env_ = other.env_;
            bitField0_ = (bitField0_ & ~0x00000004);
            envBuilder_ =
                com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders
                    ? getEnvFieldBuilder()
                    : null;
          } else {
            envBuilder_.addAllMessages(other.env_);
          }
        }
      }
      if (portsBuilder_ == null) {
        if (!other.ports_.isEmpty()) {
          if (ports_.isEmpty()) {
            ports_ = other.ports_;
            bitField0_ = (bitField0_ & ~0x00000008);
          } else {
            ensurePortsIsMutable();
            ports_.addAll(other.ports_);
          }
          onChanged();
        }
      } else {
        if (!other.ports_.isEmpty()) {
          if (portsBuilder_.isEmpty()) {
            portsBuilder_.dispose();
            portsBuilder_ = null;
            ports_ = other.ports_;
            bitField0_ = (bitField0_ & ~0x00000008);
            portsBuilder_ =
                com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders
                    ? getPortsFieldBuilder()
                    : null;
          } else {
            portsBuilder_.addAllMessages(other.ports_);
          }
        }
      }
      if (!other.getPredictRoute().isEmpty()) {
        predictRoute_ = other.predictRoute_;
        onChanged();
      }
      if (!other.getHealthRoute().isEmpty()) {
        healthRoute_ = other.healthRoute_;
        onChanged();
      }
      this.mergeUnknownFields(other.unknownFields);
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      com.google.cloud.aiplatform.v1beta1.ModelContainerSpec parsedMessage = null;
      try {
        parsedMessage = PARSER.parsePartialFrom(input, extensionRegistry);
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        parsedMessage =
            (com.google.cloud.aiplatform.v1beta1.ModelContainerSpec) e.getUnfinishedMessage();
        throw e.unwrapIOException();
      } finally {
        if (parsedMessage != null) {
          mergeFrom(parsedMessage);
        }
      }
      return this;
    }

    private int bitField0_;

    private java.lang.Object imageUri_ = "";
    /**
     *
     *
     * <pre>
     * Required. Immutable. URI of the Docker image to be used as the custom container for serving
     * predictions. This URI must identify an image in Artifact Registry or
     * Container Registry. Learn more about the [container publishing
     * requirements](https://cloud.google.com/vertex-ai/docs/predictions/custom-container-requirements#publishing),
     * including permissions requirements for the Vertex AI Service Agent.
     * The container image is ingested upon [ModelService.UploadModel][google.cloud.aiplatform.v1beta1.ModelService.UploadModel], stored
     * internally, and this original path is afterwards not used.
     * To learn about the requirements for the Docker image itself, see
     * [Custom container
     * requirements](https://cloud.google.com/vertex-ai/docs/predictions/custom-container-requirements#).
     * You can use the URI to one of Vertex AI's [pre-built container images for
     * prediction](https://cloud.google.com/vertex-ai/docs/predictions/pre-built-containers)
     * in this field.
     * </pre>
     *
     * <code>
     * string image_uri = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.field_behavior) = IMMUTABLE];
     * </code>
     *
     * @return The imageUri.
     */
    public java.lang.String getImageUri() {
      java.lang.Object ref = imageUri_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        imageUri_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Required. Immutable. URI of the Docker image to be used as the custom container for serving
     * predictions. This URI must identify an image in Artifact Registry or
     * Container Registry. Learn more about the [container publishing
     * requirements](https://cloud.google.com/vertex-ai/docs/predictions/custom-container-requirements#publishing),
     * including permissions requirements for the Vertex AI Service Agent.
     * The container image is ingested upon [ModelService.UploadModel][google.cloud.aiplatform.v1beta1.ModelService.UploadModel], stored
     * internally, and this original path is afterwards not used.
     * To learn about the requirements for the Docker image itself, see
     * [Custom container
     * requirements](https://cloud.google.com/vertex-ai/docs/predictions/custom-container-requirements#).
     * You can use the URI to one of Vertex AI's [pre-built container images for
     * prediction](https://cloud.google.com/vertex-ai/docs/predictions/pre-built-containers)
     * in this field.
     * </pre>
     *
     * <code>
     * string image_uri = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.field_behavior) = IMMUTABLE];
     * </code>
     *
     * @return The bytes for imageUri.
     */
    public com.google.protobuf.ByteString getImageUriBytes() {
      java.lang.Object ref = imageUri_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        imageUri_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Required. Immutable. URI of the Docker image to be used as the custom container for serving
     * predictions. This URI must identify an image in Artifact Registry or
     * Container Registry. Learn more about the [container publishing
     * requirements](https://cloud.google.com/vertex-ai/docs/predictions/custom-container-requirements#publishing),
     * including permissions requirements for the Vertex AI Service Agent.
     * The container image is ingested upon [ModelService.UploadModel][google.cloud.aiplatform.v1beta1.ModelService.UploadModel], stored
     * internally, and this original path is afterwards not used.
     * To learn about the requirements for the Docker image itself, see
     * [Custom container
     * requirements](https://cloud.google.com/vertex-ai/docs/predictions/custom-container-requirements#).
     * You can use the URI to one of Vertex AI's [pre-built container images for
     * prediction](https://cloud.google.com/vertex-ai/docs/predictions/pre-built-containers)
     * in this field.
     * </pre>
     *
     * <code>
     * string image_uri = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.field_behavior) = IMMUTABLE];
     * </code>
     *
     * @param value The imageUri to set.
     * @return This builder for chaining.
     */
    public Builder setImageUri(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }

      imageUri_ = value;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. Immutable. URI of the Docker image to be used as the custom container for serving
     * predictions. This URI must identify an image in Artifact Registry or
     * Container Registry. Learn more about the [container publishing
     * requirements](https://cloud.google.com/vertex-ai/docs/predictions/custom-container-requirements#publishing),
     * including permissions requirements for the Vertex AI Service Agent.
     * The container image is ingested upon [ModelService.UploadModel][google.cloud.aiplatform.v1beta1.ModelService.UploadModel], stored
     * internally, and this original path is afterwards not used.
     * To learn about the requirements for the Docker image itself, see
     * [Custom container
     * requirements](https://cloud.google.com/vertex-ai/docs/predictions/custom-container-requirements#).
     * You can use the URI to one of Vertex AI's [pre-built container images for
     * prediction](https://cloud.google.com/vertex-ai/docs/predictions/pre-built-containers)
     * in this field.
     * </pre>
     *
     * <code>
     * string image_uri = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.field_behavior) = IMMUTABLE];
     * </code>
     *
     * @return This builder for chaining.
     */
    public Builder clearImageUri() {

      imageUri_ = getDefaultInstance().getImageUri();
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. Immutable. URI of the Docker image to be used as the custom container for serving
     * predictions. This URI must identify an image in Artifact Registry or
     * Container Registry. Learn more about the [container publishing
     * requirements](https://cloud.google.com/vertex-ai/docs/predictions/custom-container-requirements#publishing),
     * including permissions requirements for the Vertex AI Service Agent.
     * The container image is ingested upon [ModelService.UploadModel][google.cloud.aiplatform.v1beta1.ModelService.UploadModel], stored
     * internally, and this original path is afterwards not used.
     * To learn about the requirements for the Docker image itself, see
     * [Custom container
     * requirements](https://cloud.google.com/vertex-ai/docs/predictions/custom-container-requirements#).
     * You can use the URI to one of Vertex AI's [pre-built container images for
     * prediction](https://cloud.google.com/vertex-ai/docs/predictions/pre-built-containers)
     * in this field.
     * </pre>
     *
     * <code>
     * string image_uri = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.field_behavior) = IMMUTABLE];
     * </code>
     *
     * @param value The bytes for imageUri to set.
     * @return This builder for chaining.
     */
    public Builder setImageUriBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);

      imageUri_ = value;
      onChanged();
      return this;
    }

    private com.google.protobuf.LazyStringList command_ =
        com.google.protobuf.LazyStringArrayList.EMPTY;

    private void ensureCommandIsMutable() {
      if (!((bitField0_ & 0x00000001) != 0)) {
        command_ = new com.google.protobuf.LazyStringArrayList(command_);
        bitField0_ |= 0x00000001;
      }
    }
    /**
     *
     *
     * <pre>
     * Immutable. Specifies the command that runs when the container starts. This overrides
     * the container's
     * [ENTRYPOINT](https://docs.docker.com/engine/reference/builder/#entrypoint).
     * Specify this field as an array of executable and arguments, similar to a
     * Docker `ENTRYPOINT`'s "exec" form, not its "shell" form.
     * If you do not specify this field, then the container's `ENTRYPOINT` runs,
     * in conjunction with the [args][google.cloud.aiplatform.v1beta1.ModelContainerSpec.args] field or the
     * container's [`CMD`](https://docs.docker.com/engine/reference/builder/#cmd),
     * if either exists. If this field is not specified and the container does not
     * have an `ENTRYPOINT`, then refer to the Docker documentation about [how
     * `CMD` and `ENTRYPOINT`
     * interact](https://docs.docker.com/engine/reference/builder/#understand-how-cmd-and-entrypoint-interact).
     * If you specify this field, then you can also specify the `args` field to
     * provide additional arguments for this command. However, if you specify this
     * field, then the container's `CMD` is ignored. See the
     * [Kubernetes documentation about how the
     * `command` and `args` fields interact with a container's `ENTRYPOINT` and
     * `CMD`](https://kubernetes.io/docs/tasks/inject-data-application/define-command-argument-container/#notes).
     * In this field, you can reference [environment variables set by Vertex
     * AI](https://cloud.google.com/vertex-ai/docs/predictions/custom-container-requirements#aip-variables)
     * and environment variables set in the [env][google.cloud.aiplatform.v1beta1.ModelContainerSpec.env] field.
     * You cannot reference environment variables set in the Docker image. In
     * order for environment variables to be expanded, reference them by using the
     * following syntax:
     * &lt;code&gt;$(&lt;var&gt;VARIABLE_NAME&lt;/var&gt;)&lt;/code&gt;
     * Note that this differs from Bash variable expansion, which does not use
     * parentheses. If a variable cannot be resolved, the reference in the input
     * string is used unchanged. To avoid variable expansion, you can escape this
     * syntax with `$$`; for example:
     * &lt;code&gt;$$(&lt;var&gt;VARIABLE_NAME&lt;/var&gt;)&lt;/code&gt;
     * This field corresponds to the `command` field of the Kubernetes Containers
     * [v1 core
     * API](https://v1-18.docs.kubernetes.io/docs/reference/generated/kubernetes-api/v1.18/#container-v1-core).
     * </pre>
     *
     * <code>repeated string command = 2 [(.google.api.field_behavior) = IMMUTABLE];</code>
     *
     * @return A list containing the command.
     */
    public com.google.protobuf.ProtocolStringList getCommandList() {
      return command_.getUnmodifiableView();
    }
    /**
     *
     *
     * <pre>
     * Immutable. Specifies the command that runs when the container starts. This overrides
     * the container's
     * [ENTRYPOINT](https://docs.docker.com/engine/reference/builder/#entrypoint).
     * Specify this field as an array of executable and arguments, similar to a
     * Docker `ENTRYPOINT`'s "exec" form, not its "shell" form.
     * If you do not specify this field, then the container's `ENTRYPOINT` runs,
     * in conjunction with the [args][google.cloud.aiplatform.v1beta1.ModelContainerSpec.args] field or the
     * container's [`CMD`](https://docs.docker.com/engine/reference/builder/#cmd),
     * if either exists. If this field is not specified and the container does not
     * have an `ENTRYPOINT`, then refer to the Docker documentation about [how
     * `CMD` and `ENTRYPOINT`
     * interact](https://docs.docker.com/engine/reference/builder/#understand-how-cmd-and-entrypoint-interact).
     * If you specify this field, then you can also specify the `args` field to
     * provide additional arguments for this command. However, if you specify this
     * field, then the container's `CMD` is ignored. See the
     * [Kubernetes documentation about how the
     * `command` and `args` fields interact with a container's `ENTRYPOINT` and
     * `CMD`](https://kubernetes.io/docs/tasks/inject-data-application/define-command-argument-container/#notes).
     * In this field, you can reference [environment variables set by Vertex
     * AI](https://cloud.google.com/vertex-ai/docs/predictions/custom-container-requirements#aip-variables)
     * and environment variables set in the [env][google.cloud.aiplatform.v1beta1.ModelContainerSpec.env] field.
     * You cannot reference environment variables set in the Docker image. In
     * order for environment variables to be expanded, reference them by using the
     * following syntax:
     * &lt;code&gt;$(&lt;var&gt;VARIABLE_NAME&lt;/var&gt;)&lt;/code&gt;
     * Note that this differs from Bash variable expansion, which does not use
     * parentheses. If a variable cannot be resolved, the reference in the input
     * string is used unchanged. To avoid variable expansion, you can escape this
     * syntax with `$$`; for example:
     * &lt;code&gt;$$(&lt;var&gt;VARIABLE_NAME&lt;/var&gt;)&lt;/code&gt;
     * This field corresponds to the `command` field of the Kubernetes Containers
     * [v1 core
     * API](https://v1-18.docs.kubernetes.io/docs/reference/generated/kubernetes-api/v1.18/#container-v1-core).
     * </pre>
     *
     * <code>repeated string command = 2 [(.google.api.field_behavior) = IMMUTABLE];</code>
     *
     * @return The count of command.
     */
    public int getCommandCount() {
      return command_.size();
    }
    /**
     *
     *
     * <pre>
     * Immutable. Specifies the command that runs when the container starts. This overrides
     * the container's
     * [ENTRYPOINT](https://docs.docker.com/engine/reference/builder/#entrypoint).
     * Specify this field as an array of executable and arguments, similar to a
     * Docker `ENTRYPOINT`'s "exec" form, not its "shell" form.
     * If you do not specify this field, then the container's `ENTRYPOINT` runs,
     * in conjunction with the [args][google.cloud.aiplatform.v1beta1.ModelContainerSpec.args] field or the
     * container's [`CMD`](https://docs.docker.com/engine/reference/builder/#cmd),
     * if either exists. If this field is not specified and the container does not
     * have an `ENTRYPOINT`, then refer to the Docker documentation about [how
     * `CMD` and `ENTRYPOINT`
     * interact](https://docs.docker.com/engine/reference/builder/#understand-how-cmd-and-entrypoint-interact).
     * If you specify this field, then you can also specify the `args` field to
     * provide additional arguments for this command. However, if you specify this
     * field, then the container's `CMD` is ignored. See the
     * [Kubernetes documentation about how the
     * `command` and `args` fields interact with a container's `ENTRYPOINT` and
     * `CMD`](https://kubernetes.io/docs/tasks/inject-data-application/define-command-argument-container/#notes).
     * In this field, you can reference [environment variables set by Vertex
     * AI](https://cloud.google.com/vertex-ai/docs/predictions/custom-container-requirements#aip-variables)
     * and environment variables set in the [env][google.cloud.aiplatform.v1beta1.ModelContainerSpec.env] field.
     * You cannot reference environment variables set in the Docker image. In
     * order for environment variables to be expanded, reference them by using the
     * following syntax:
     * &lt;code&gt;$(&lt;var&gt;VARIABLE_NAME&lt;/var&gt;)&lt;/code&gt;
     * Note that this differs from Bash variable expansion, which does not use
     * parentheses. If a variable cannot be resolved, the reference in the input
     * string is used unchanged. To avoid variable expansion, you can escape this
     * syntax with `$$`; for example:
     * &lt;code&gt;$$(&lt;var&gt;VARIABLE_NAME&lt;/var&gt;)&lt;/code&gt;
     * This field corresponds to the `command` field of the Kubernetes Containers
     * [v1 core
     * API](https://v1-18.docs.kubernetes.io/docs/reference/generated/kubernetes-api/v1.18/#container-v1-core).
     * </pre>
     *
     * <code>repeated string command = 2 [(.google.api.field_behavior) = IMMUTABLE];</code>
     *
     * @param index The index of the element to return.
     * @return The command at the given index.
     */
    public java.lang.String getCommand(int index) {
      return command_.get(index);
    }
    /**
     *
     *
     * <pre>
     * Immutable. Specifies the command that runs when the container starts. This overrides
     * the container's
     * [ENTRYPOINT](https://docs.docker.com/engine/reference/builder/#entrypoint).
     * Specify this field as an array of executable and arguments, similar to a
     * Docker `ENTRYPOINT`'s "exec" form, not its "shell" form.
     * If you do not specify this field, then the container's `ENTRYPOINT` runs,
     * in conjunction with the [args][google.cloud.aiplatform.v1beta1.ModelContainerSpec.args] field or the
     * container's [`CMD`](https://docs.docker.com/engine/reference/builder/#cmd),
     * if either exists. If this field is not specified and the container does not
     * have an `ENTRYPOINT`, then refer to the Docker documentation about [how
     * `CMD` and `ENTRYPOINT`
     * interact](https://docs.docker.com/engine/reference/builder/#understand-how-cmd-and-entrypoint-interact).
     * If you specify this field, then you can also specify the `args` field to
     * provide additional arguments for this command. However, if you specify this
     * field, then the container's `CMD` is ignored. See the
     * [Kubernetes documentation about how the
     * `command` and `args` fields interact with a container's `ENTRYPOINT` and
     * `CMD`](https://kubernetes.io/docs/tasks/inject-data-application/define-command-argument-container/#notes).
     * In this field, you can reference [environment variables set by Vertex
     * AI](https://cloud.google.com/vertex-ai/docs/predictions/custom-container-requirements#aip-variables)
     * and environment variables set in the [env][google.cloud.aiplatform.v1beta1.ModelContainerSpec.env] field.
     * You cannot reference environment variables set in the Docker image. In
     * order for environment variables to be expanded, reference them by using the
     * following syntax:
     * &lt;code&gt;$(&lt;var&gt;VARIABLE_NAME&lt;/var&gt;)&lt;/code&gt;
     * Note that this differs from Bash variable expansion, which does not use
     * parentheses. If a variable cannot be resolved, the reference in the input
     * string is used unchanged. To avoid variable expansion, you can escape this
     * syntax with `$$`; for example:
     * &lt;code&gt;$$(&lt;var&gt;VARIABLE_NAME&lt;/var&gt;)&lt;/code&gt;
     * This field corresponds to the `command` field of the Kubernetes Containers
     * [v1 core
     * API](https://v1-18.docs.kubernetes.io/docs/reference/generated/kubernetes-api/v1.18/#container-v1-core).
     * </pre>
     *
     * <code>repeated string command = 2 [(.google.api.field_behavior) = IMMUTABLE];</code>
     *
     * @param index The index of the value to return.
     * @return The bytes of the command at the given index.
     */
    public com.google.protobuf.ByteString getCommandBytes(int index) {
      return command_.getByteString(index);
    }
    /**
     *
     *
     * <pre>
     * Immutable. Specifies the command that runs when the container starts. This overrides
     * the container's
     * [ENTRYPOINT](https://docs.docker.com/engine/reference/builder/#entrypoint).
     * Specify this field as an array of executable and arguments, similar to a
     * Docker `ENTRYPOINT`'s "exec" form, not its "shell" form.
     * If you do not specify this field, then the container's `ENTRYPOINT` runs,
     * in conjunction with the [args][google.cloud.aiplatform.v1beta1.ModelContainerSpec.args] field or the
     * container's [`CMD`](https://docs.docker.com/engine/reference/builder/#cmd),
     * if either exists. If this field is not specified and the container does not
     * have an `ENTRYPOINT`, then refer to the Docker documentation about [how
     * `CMD` and `ENTRYPOINT`
     * interact](https://docs.docker.com/engine/reference/builder/#understand-how-cmd-and-entrypoint-interact).
     * If you specify this field, then you can also specify the `args` field to
     * provide additional arguments for this command. However, if you specify this
     * field, then the container's `CMD` is ignored. See the
     * [Kubernetes documentation about how the
     * `command` and `args` fields interact with a container's `ENTRYPOINT` and
     * `CMD`](https://kubernetes.io/docs/tasks/inject-data-application/define-command-argument-container/#notes).
     * In this field, you can reference [environment variables set by Vertex
     * AI](https://cloud.google.com/vertex-ai/docs/predictions/custom-container-requirements#aip-variables)
     * and environment variables set in the [env][google.cloud.aiplatform.v1beta1.ModelContainerSpec.env] field.
     * You cannot reference environment variables set in the Docker image. In
     * order for environment variables to be expanded, reference them by using the
     * following syntax:
     * &lt;code&gt;$(&lt;var&gt;VARIABLE_NAME&lt;/var&gt;)&lt;/code&gt;
     * Note that this differs from Bash variable expansion, which does not use
     * parentheses. If a variable cannot be resolved, the reference in the input
     * string is used unchanged. To avoid variable expansion, you can escape this
     * syntax with `$$`; for example:
     * &lt;code&gt;$$(&lt;var&gt;VARIABLE_NAME&lt;/var&gt;)&lt;/code&gt;
     * This field corresponds to the `command` field of the Kubernetes Containers
     * [v1 core
     * API](https://v1-18.docs.kubernetes.io/docs/reference/generated/kubernetes-api/v1.18/#container-v1-core).
     * </pre>
     *
     * <code>repeated string command = 2 [(.google.api.field_behavior) = IMMUTABLE];</code>
     *
     * @param index The index to set the value at.
     * @param value The command to set.
     * @return This builder for chaining.
     */
    public Builder setCommand(int index, java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      ensureCommandIsMutable();
      command_.set(index, value);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Immutable. Specifies the command that runs when the container starts. This overrides
     * the container's
     * [ENTRYPOINT](https://docs.docker.com/engine/reference/builder/#entrypoint).
     * Specify this field as an array of executable and arguments, similar to a
     * Docker `ENTRYPOINT`'s "exec" form, not its "shell" form.
     * If you do not specify this field, then the container's `ENTRYPOINT` runs,
     * in conjunction with the [args][google.cloud.aiplatform.v1beta1.ModelContainerSpec.args] field or the
     * container's [`CMD`](https://docs.docker.com/engine/reference/builder/#cmd),
     * if either exists. If this field is not specified and the container does not
     * have an `ENTRYPOINT`, then refer to the Docker documentation about [how
     * `CMD` and `ENTRYPOINT`
     * interact](https://docs.docker.com/engine/reference/builder/#understand-how-cmd-and-entrypoint-interact).
     * If you specify this field, then you can also specify the `args` field to
     * provide additional arguments for this command. However, if you specify this
     * field, then the container's `CMD` is ignored. See the
     * [Kubernetes documentation about how the
     * `command` and `args` fields interact with a container's `ENTRYPOINT` and
     * `CMD`](https://kubernetes.io/docs/tasks/inject-data-application/define-command-argument-container/#notes).
     * In this field, you can reference [environment variables set by Vertex
     * AI](https://cloud.google.com/vertex-ai/docs/predictions/custom-container-requirements#aip-variables)
     * and environment variables set in the [env][google.cloud.aiplatform.v1beta1.ModelContainerSpec.env] field.
     * You cannot reference environment variables set in the Docker image. In
     * order for environment variables to be expanded, reference them by using the
     * following syntax:
     * &lt;code&gt;$(&lt;var&gt;VARIABLE_NAME&lt;/var&gt;)&lt;/code&gt;
     * Note that this differs from Bash variable expansion, which does not use
     * parentheses. If a variable cannot be resolved, the reference in the input
     * string is used unchanged. To avoid variable expansion, you can escape this
     * syntax with `$$`; for example:
     * &lt;code&gt;$$(&lt;var&gt;VARIABLE_NAME&lt;/var&gt;)&lt;/code&gt;
     * This field corresponds to the `command` field of the Kubernetes Containers
     * [v1 core
     * API](https://v1-18.docs.kubernetes.io/docs/reference/generated/kubernetes-api/v1.18/#container-v1-core).
     * </pre>
     *
     * <code>repeated string command = 2 [(.google.api.field_behavior) = IMMUTABLE];</code>
     *
     * @param value The command to add.
     * @return This builder for chaining.
     */
    public Builder addCommand(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      ensureCommandIsMutable();
      command_.add(value);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Immutable. Specifies the command that runs when the container starts. This overrides
     * the container's
     * [ENTRYPOINT](https://docs.docker.com/engine/reference/builder/#entrypoint).
     * Specify this field as an array of executable and arguments, similar to a
     * Docker `ENTRYPOINT`'s "exec" form, not its "shell" form.
     * If you do not specify this field, then the container's `ENTRYPOINT` runs,
     * in conjunction with the [args][google.cloud.aiplatform.v1beta1.ModelContainerSpec.args] field or the
     * container's [`CMD`](https://docs.docker.com/engine/reference/builder/#cmd),
     * if either exists. If this field is not specified and the container does not
     * have an `ENTRYPOINT`, then refer to the Docker documentation about [how
     * `CMD` and `ENTRYPOINT`
     * interact](https://docs.docker.com/engine/reference/builder/#understand-how-cmd-and-entrypoint-interact).
     * If you specify this field, then you can also specify the `args` field to
     * provide additional arguments for this command. However, if you specify this
     * field, then the container's `CMD` is ignored. See the
     * [Kubernetes documentation about how the
     * `command` and `args` fields interact with a container's `ENTRYPOINT` and
     * `CMD`](https://kubernetes.io/docs/tasks/inject-data-application/define-command-argument-container/#notes).
     * In this field, you can reference [environment variables set by Vertex
     * AI](https://cloud.google.com/vertex-ai/docs/predictions/custom-container-requirements#aip-variables)
     * and environment variables set in the [env][google.cloud.aiplatform.v1beta1.ModelContainerSpec.env] field.
     * You cannot reference environment variables set in the Docker image. In
     * order for environment variables to be expanded, reference them by using the
     * following syntax:
     * &lt;code&gt;$(&lt;var&gt;VARIABLE_NAME&lt;/var&gt;)&lt;/code&gt;
     * Note that this differs from Bash variable expansion, which does not use
     * parentheses. If a variable cannot be resolved, the reference in the input
     * string is used unchanged. To avoid variable expansion, you can escape this
     * syntax with `$$`; for example:
     * &lt;code&gt;$$(&lt;var&gt;VARIABLE_NAME&lt;/var&gt;)&lt;/code&gt;
     * This field corresponds to the `command` field of the Kubernetes Containers
     * [v1 core
     * API](https://v1-18.docs.kubernetes.io/docs/reference/generated/kubernetes-api/v1.18/#container-v1-core).
     * </pre>
     *
     * <code>repeated string command = 2 [(.google.api.field_behavior) = IMMUTABLE];</code>
     *
     * @param values The command to add.
     * @return This builder for chaining.
     */
    public Builder addAllCommand(java.lang.Iterable<java.lang.String> values) {
      ensureCommandIsMutable();
      com.google.protobuf.AbstractMessageLite.Builder.addAll(values, command_);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Immutable. Specifies the command that runs when the container starts. This overrides
     * the container's
     * [ENTRYPOINT](https://docs.docker.com/engine/reference/builder/#entrypoint).
     * Specify this field as an array of executable and arguments, similar to a
     * Docker `ENTRYPOINT`'s "exec" form, not its "shell" form.
     * If you do not specify this field, then the container's `ENTRYPOINT` runs,
     * in conjunction with the [args][google.cloud.aiplatform.v1beta1.ModelContainerSpec.args] field or the
     * container's [`CMD`](https://docs.docker.com/engine/reference/builder/#cmd),
     * if either exists. If this field is not specified and the container does not
     * have an `ENTRYPOINT`, then refer to the Docker documentation about [how
     * `CMD` and `ENTRYPOINT`
     * interact](https://docs.docker.com/engine/reference/builder/#understand-how-cmd-and-entrypoint-interact).
     * If you specify this field, then you can also specify the `args` field to
     * provide additional arguments for this command. However, if you specify this
     * field, then the container's `CMD` is ignored. See the
     * [Kubernetes documentation about how the
     * `command` and `args` fields interact with a container's `ENTRYPOINT` and
     * `CMD`](https://kubernetes.io/docs/tasks/inject-data-application/define-command-argument-container/#notes).
     * In this field, you can reference [environment variables set by Vertex
     * AI](https://cloud.google.com/vertex-ai/docs/predictions/custom-container-requirements#aip-variables)
     * and environment variables set in the [env][google.cloud.aiplatform.v1beta1.ModelContainerSpec.env] field.
     * You cannot reference environment variables set in the Docker image. In
     * order for environment variables to be expanded, reference them by using the
     * following syntax:
     * &lt;code&gt;$(&lt;var&gt;VARIABLE_NAME&lt;/var&gt;)&lt;/code&gt;
     * Note that this differs from Bash variable expansion, which does not use
     * parentheses. If a variable cannot be resolved, the reference in the input
     * string is used unchanged. To avoid variable expansion, you can escape this
     * syntax with `$$`; for example:
     * &lt;code&gt;$$(&lt;var&gt;VARIABLE_NAME&lt;/var&gt;)&lt;/code&gt;
     * This field corresponds to the `command` field of the Kubernetes Containers
     * [v1 core
     * API](https://v1-18.docs.kubernetes.io/docs/reference/generated/kubernetes-api/v1.18/#container-v1-core).
     * </pre>
     *
     * <code>repeated string command = 2 [(.google.api.field_behavior) = IMMUTABLE];</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearCommand() {
      command_ = com.google.protobuf.LazyStringArrayList.EMPTY;
      bitField0_ = (bitField0_ & ~0x00000001);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Immutable. Specifies the command that runs when the container starts. This overrides
     * the container's
     * [ENTRYPOINT](https://docs.docker.com/engine/reference/builder/#entrypoint).
     * Specify this field as an array of executable and arguments, similar to a
     * Docker `ENTRYPOINT`'s "exec" form, not its "shell" form.
     * If you do not specify this field, then the container's `ENTRYPOINT` runs,
     * in conjunction with the [args][google.cloud.aiplatform.v1beta1.ModelContainerSpec.args] field or the
     * container's [`CMD`](https://docs.docker.com/engine/reference/builder/#cmd),
     * if either exists. If this field is not specified and the container does not
     * have an `ENTRYPOINT`, then refer to the Docker documentation about [how
     * `CMD` and `ENTRYPOINT`
     * interact](https://docs.docker.com/engine/reference/builder/#understand-how-cmd-and-entrypoint-interact).
     * If you specify this field, then you can also specify the `args` field to
     * provide additional arguments for this command. However, if you specify this
     * field, then the container's `CMD` is ignored. See the
     * [Kubernetes documentation about how the
     * `command` and `args` fields interact with a container's `ENTRYPOINT` and
     * `CMD`](https://kubernetes.io/docs/tasks/inject-data-application/define-command-argument-container/#notes).
     * In this field, you can reference [environment variables set by Vertex
     * AI](https://cloud.google.com/vertex-ai/docs/predictions/custom-container-requirements#aip-variables)
     * and environment variables set in the [env][google.cloud.aiplatform.v1beta1.ModelContainerSpec.env] field.
     * You cannot reference environment variables set in the Docker image. In
     * order for environment variables to be expanded, reference them by using the
     * following syntax:
     * &lt;code&gt;$(&lt;var&gt;VARIABLE_NAME&lt;/var&gt;)&lt;/code&gt;
     * Note that this differs from Bash variable expansion, which does not use
     * parentheses. If a variable cannot be resolved, the reference in the input
     * string is used unchanged. To avoid variable expansion, you can escape this
     * syntax with `$$`; for example:
     * &lt;code&gt;$$(&lt;var&gt;VARIABLE_NAME&lt;/var&gt;)&lt;/code&gt;
     * This field corresponds to the `command` field of the Kubernetes Containers
     * [v1 core
     * API](https://v1-18.docs.kubernetes.io/docs/reference/generated/kubernetes-api/v1.18/#container-v1-core).
     * </pre>
     *
     * <code>repeated string command = 2 [(.google.api.field_behavior) = IMMUTABLE];</code>
     *
     * @param value The bytes of the command to add.
     * @return This builder for chaining.
     */
    public Builder addCommandBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      ensureCommandIsMutable();
      command_.add(value);
      onChanged();
      return this;
    }

    private com.google.protobuf.LazyStringList args_ =
        com.google.protobuf.LazyStringArrayList.EMPTY;

    private void ensureArgsIsMutable() {
      if (!((bitField0_ & 0x00000002) != 0)) {
        args_ = new com.google.protobuf.LazyStringArrayList(args_);
        bitField0_ |= 0x00000002;
      }
    }
    /**
     *
     *
     * <pre>
     * Immutable. Specifies arguments for the command that runs when the container starts.
     * This overrides the container's
     * [`CMD`](https://docs.docker.com/engine/reference/builder/#cmd). Specify
     * this field as an array of executable and arguments, similar to a Docker
     * `CMD`'s "default parameters" form.
     * If you don't specify this field but do specify the
     * [command][google.cloud.aiplatform.v1beta1.ModelContainerSpec.command] field, then the command from the
     * `command` field runs without any additional arguments. See the
     * [Kubernetes documentation about how the
     * `command` and `args` fields interact with a container's `ENTRYPOINT` and
     * `CMD`](https://kubernetes.io/docs/tasks/inject-data-application/define-command-argument-container/#notes).
     * If you don't specify this field and don't specify the `command` field,
     * then the container's
     * [`ENTRYPOINT`](https://docs.docker.com/engine/reference/builder/#cmd) and
     * `CMD` determine what runs based on their default behavior. See the Docker
     * documentation about [how `CMD` and `ENTRYPOINT`
     * interact](https://docs.docker.com/engine/reference/builder/#understand-how-cmd-and-entrypoint-interact).
     * In this field, you can reference [environment variables
     * set by Vertex
     * AI](https://cloud.google.com/vertex-ai/docs/predictions/custom-container-requirements#aip-variables)
     * and environment variables set in the [env][google.cloud.aiplatform.v1beta1.ModelContainerSpec.env] field.
     * You cannot reference environment variables set in the Docker image. In
     * order for environment variables to be expanded, reference them by using the
     * following syntax:
     * &lt;code&gt;$(&lt;var&gt;VARIABLE_NAME&lt;/var&gt;)&lt;/code&gt;
     * Note that this differs from Bash variable expansion, which does not use
     * parentheses. If a variable cannot be resolved, the reference in the input
     * string is used unchanged. To avoid variable expansion, you can escape this
     * syntax with `$$`; for example:
     * &lt;code&gt;$$(&lt;var&gt;VARIABLE_NAME&lt;/var&gt;)&lt;/code&gt;
     * This field corresponds to the `args` field of the Kubernetes Containers
     * [v1 core
     * API](https://v1-18.docs.kubernetes.io/docs/reference/generated/kubernetes-api/v1.18/#container-v1-core).
     * </pre>
     *
     * <code>repeated string args = 3 [(.google.api.field_behavior) = IMMUTABLE];</code>
     *
     * @return A list containing the args.
     */
    public com.google.protobuf.ProtocolStringList getArgsList() {
      return args_.getUnmodifiableView();
    }
    /**
     *
     *
     * <pre>
     * Immutable. Specifies arguments for the command that runs when the container starts.
     * This overrides the container's
     * [`CMD`](https://docs.docker.com/engine/reference/builder/#cmd). Specify
     * this field as an array of executable and arguments, similar to a Docker
     * `CMD`'s "default parameters" form.
     * If you don't specify this field but do specify the
     * [command][google.cloud.aiplatform.v1beta1.ModelContainerSpec.command] field, then the command from the
     * `command` field runs without any additional arguments. See the
     * [Kubernetes documentation about how the
     * `command` and `args` fields interact with a container's `ENTRYPOINT` and
     * `CMD`](https://kubernetes.io/docs/tasks/inject-data-application/define-command-argument-container/#notes).
     * If you don't specify this field and don't specify the `command` field,
     * then the container's
     * [`ENTRYPOINT`](https://docs.docker.com/engine/reference/builder/#cmd) and
     * `CMD` determine what runs based on their default behavior. See the Docker
     * documentation about [how `CMD` and `ENTRYPOINT`
     * interact](https://docs.docker.com/engine/reference/builder/#understand-how-cmd-and-entrypoint-interact).
     * In this field, you can reference [environment variables
     * set by Vertex
     * AI](https://cloud.google.com/vertex-ai/docs/predictions/custom-container-requirements#aip-variables)
     * and environment variables set in the [env][google.cloud.aiplatform.v1beta1.ModelContainerSpec.env] field.
     * You cannot reference environment variables set in the Docker image. In
     * order for environment variables to be expanded, reference them by using the
     * following syntax:
     * &lt;code&gt;$(&lt;var&gt;VARIABLE_NAME&lt;/var&gt;)&lt;/code&gt;
     * Note that this differs from Bash variable expansion, which does not use
     * parentheses. If a variable cannot be resolved, the reference in the input
     * string is used unchanged. To avoid variable expansion, you can escape this
     * syntax with `$$`; for example:
     * &lt;code&gt;$$(&lt;var&gt;VARIABLE_NAME&lt;/var&gt;)&lt;/code&gt;
     * This field corresponds to the `args` field of the Kubernetes Containers
     * [v1 core
     * API](https://v1-18.docs.kubernetes.io/docs/reference/generated/kubernetes-api/v1.18/#container-v1-core).
     * </pre>
     *
     * <code>repeated string args = 3 [(.google.api.field_behavior) = IMMUTABLE];</code>
     *
     * @return The count of args.
     */
    public int getArgsCount() {
      return args_.size();
    }
    /**
     *
     *
     * <pre>
     * Immutable. Specifies arguments for the command that runs when the container starts.
     * This overrides the container's
     * [`CMD`](https://docs.docker.com/engine/reference/builder/#cmd). Specify
     * this field as an array of executable and arguments, similar to a Docker
     * `CMD`'s "default parameters" form.
     * If you don't specify this field but do specify the
     * [command][google.cloud.aiplatform.v1beta1.ModelContainerSpec.command] field, then the command from the
     * `command` field runs without any additional arguments. See the
     * [Kubernetes documentation about how the
     * `command` and `args` fields interact with a container's `ENTRYPOINT` and
     * `CMD`](https://kubernetes.io/docs/tasks/inject-data-application/define-command-argument-container/#notes).
     * If you don't specify this field and don't specify the `command` field,
     * then the container's
     * [`ENTRYPOINT`](https://docs.docker.com/engine/reference/builder/#cmd) and
     * `CMD` determine what runs based on their default behavior. See the Docker
     * documentation about [how `CMD` and `ENTRYPOINT`
     * interact](https://docs.docker.com/engine/reference/builder/#understand-how-cmd-and-entrypoint-interact).
     * In this field, you can reference [environment variables
     * set by Vertex
     * AI](https://cloud.google.com/vertex-ai/docs/predictions/custom-container-requirements#aip-variables)
     * and environment variables set in the [env][google.cloud.aiplatform.v1beta1.ModelContainerSpec.env] field.
     * You cannot reference environment variables set in the Docker image. In
     * order for environment variables to be expanded, reference them by using the
     * following syntax:
     * &lt;code&gt;$(&lt;var&gt;VARIABLE_NAME&lt;/var&gt;)&lt;/code&gt;
     * Note that this differs from Bash variable expansion, which does not use
     * parentheses. If a variable cannot be resolved, the reference in the input
     * string is used unchanged. To avoid variable expansion, you can escape this
     * syntax with `$$`; for example:
     * &lt;code&gt;$$(&lt;var&gt;VARIABLE_NAME&lt;/var&gt;)&lt;/code&gt;
     * This field corresponds to the `args` field of the Kubernetes Containers
     * [v1 core
     * API](https://v1-18.docs.kubernetes.io/docs/reference/generated/kubernetes-api/v1.18/#container-v1-core).
     * </pre>
     *
     * <code>repeated string args = 3 [(.google.api.field_behavior) = IMMUTABLE];</code>
     *
     * @param index The index of the element to return.
     * @return The args at the given index.
     */
    public java.lang.String getArgs(int index) {
      return args_.get(index);
    }
    /**
     *
     *
     * <pre>
     * Immutable. Specifies arguments for the command that runs when the container starts.
     * This overrides the container's
     * [`CMD`](https://docs.docker.com/engine/reference/builder/#cmd). Specify
     * this field as an array of executable and arguments, similar to a Docker
     * `CMD`'s "default parameters" form.
     * If you don't specify this field but do specify the
     * [command][google.cloud.aiplatform.v1beta1.ModelContainerSpec.command] field, then the command from the
     * `command` field runs without any additional arguments. See the
     * [Kubernetes documentation about how the
     * `command` and `args` fields interact with a container's `ENTRYPOINT` and
     * `CMD`](https://kubernetes.io/docs/tasks/inject-data-application/define-command-argument-container/#notes).
     * If you don't specify this field and don't specify the `command` field,
     * then the container's
     * [`ENTRYPOINT`](https://docs.docker.com/engine/reference/builder/#cmd) and
     * `CMD` determine what runs based on their default behavior. See the Docker
     * documentation about [how `CMD` and `ENTRYPOINT`
     * interact](https://docs.docker.com/engine/reference/builder/#understand-how-cmd-and-entrypoint-interact).
     * In this field, you can reference [environment variables
     * set by Vertex
     * AI](https://cloud.google.com/vertex-ai/docs/predictions/custom-container-requirements#aip-variables)
     * and environment variables set in the [env][google.cloud.aiplatform.v1beta1.ModelContainerSpec.env] field.
     * You cannot reference environment variables set in the Docker image. In
     * order for environment variables to be expanded, reference them by using the
     * following syntax:
     * &lt;code&gt;$(&lt;var&gt;VARIABLE_NAME&lt;/var&gt;)&lt;/code&gt;
     * Note that this differs from Bash variable expansion, which does not use
     * parentheses. If a variable cannot be resolved, the reference in the input
     * string is used unchanged. To avoid variable expansion, you can escape this
     * syntax with `$$`; for example:
     * &lt;code&gt;$$(&lt;var&gt;VARIABLE_NAME&lt;/var&gt;)&lt;/code&gt;
     * This field corresponds to the `args` field of the Kubernetes Containers
     * [v1 core
     * API](https://v1-18.docs.kubernetes.io/docs/reference/generated/kubernetes-api/v1.18/#container-v1-core).
     * </pre>
     *
     * <code>repeated string args = 3 [(.google.api.field_behavior) = IMMUTABLE];</code>
     *
     * @param index The index of the value to return.
     * @return The bytes of the args at the given index.
     */
    public com.google.protobuf.ByteString getArgsBytes(int index) {
      return args_.getByteString(index);
    }
    /**
     *
     *
     * <pre>
     * Immutable. Specifies arguments for the command that runs when the container starts.
     * This overrides the container's
     * [`CMD`](https://docs.docker.com/engine/reference/builder/#cmd). Specify
     * this field as an array of executable and arguments, similar to a Docker
     * `CMD`'s "default parameters" form.
     * If you don't specify this field but do specify the
     * [command][google.cloud.aiplatform.v1beta1.ModelContainerSpec.command] field, then the command from the
     * `command` field runs without any additional arguments. See the
     * [Kubernetes documentation about how the
     * `command` and `args` fields interact with a container's `ENTRYPOINT` and
     * `CMD`](https://kubernetes.io/docs/tasks/inject-data-application/define-command-argument-container/#notes).
     * If you don't specify this field and don't specify the `command` field,
     * then the container's
     * [`ENTRYPOINT`](https://docs.docker.com/engine/reference/builder/#cmd) and
     * `CMD` determine what runs based on their default behavior. See the Docker
     * documentation about [how `CMD` and `ENTRYPOINT`
     * interact](https://docs.docker.com/engine/reference/builder/#understand-how-cmd-and-entrypoint-interact).
     * In this field, you can reference [environment variables
     * set by Vertex
     * AI](https://cloud.google.com/vertex-ai/docs/predictions/custom-container-requirements#aip-variables)
     * and environment variables set in the [env][google.cloud.aiplatform.v1beta1.ModelContainerSpec.env] field.
     * You cannot reference environment variables set in the Docker image. In
     * order for environment variables to be expanded, reference them by using the
     * following syntax:
     * &lt;code&gt;$(&lt;var&gt;VARIABLE_NAME&lt;/var&gt;)&lt;/code&gt;
     * Note that this differs from Bash variable expansion, which does not use
     * parentheses. If a variable cannot be resolved, the reference in the input
     * string is used unchanged. To avoid variable expansion, you can escape this
     * syntax with `$$`; for example:
     * &lt;code&gt;$$(&lt;var&gt;VARIABLE_NAME&lt;/var&gt;)&lt;/code&gt;
     * This field corresponds to the `args` field of the Kubernetes Containers
     * [v1 core
     * API](https://v1-18.docs.kubernetes.io/docs/reference/generated/kubernetes-api/v1.18/#container-v1-core).
     * </pre>
     *
     * <code>repeated string args = 3 [(.google.api.field_behavior) = IMMUTABLE];</code>
     *
     * @param index The index to set the value at.
     * @param value The args to set.
     * @return This builder for chaining.
     */
    public Builder setArgs(int index, java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      ensureArgsIsMutable();
      args_.set(index, value);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Immutable. Specifies arguments for the command that runs when the container starts.
     * This overrides the container's
     * [`CMD`](https://docs.docker.com/engine/reference/builder/#cmd). Specify
     * this field as an array of executable and arguments, similar to a Docker
     * `CMD`'s "default parameters" form.
     * If you don't specify this field but do specify the
     * [command][google.cloud.aiplatform.v1beta1.ModelContainerSpec.command] field, then the command from the
     * `command` field runs without any additional arguments. See the
     * [Kubernetes documentation about how the
     * `command` and `args` fields interact with a container's `ENTRYPOINT` and
     * `CMD`](https://kubernetes.io/docs/tasks/inject-data-application/define-command-argument-container/#notes).
     * If you don't specify this field and don't specify the `command` field,
     * then the container's
     * [`ENTRYPOINT`](https://docs.docker.com/engine/reference/builder/#cmd) and
     * `CMD` determine what runs based on their default behavior. See the Docker
     * documentation about [how `CMD` and `ENTRYPOINT`
     * interact](https://docs.docker.com/engine/reference/builder/#understand-how-cmd-and-entrypoint-interact).
     * In this field, you can reference [environment variables
     * set by Vertex
     * AI](https://cloud.google.com/vertex-ai/docs/predictions/custom-container-requirements#aip-variables)
     * and environment variables set in the [env][google.cloud.aiplatform.v1beta1.ModelContainerSpec.env] field.
     * You cannot reference environment variables set in the Docker image. In
     * order for environment variables to be expanded, reference them by using the
     * following syntax:
     * &lt;code&gt;$(&lt;var&gt;VARIABLE_NAME&lt;/var&gt;)&lt;/code&gt;
     * Note that this differs from Bash variable expansion, which does not use
     * parentheses. If a variable cannot be resolved, the reference in the input
     * string is used unchanged. To avoid variable expansion, you can escape this
     * syntax with `$$`; for example:
     * &lt;code&gt;$$(&lt;var&gt;VARIABLE_NAME&lt;/var&gt;)&lt;/code&gt;
     * This field corresponds to the `args` field of the Kubernetes Containers
     * [v1 core
     * API](https://v1-18.docs.kubernetes.io/docs/reference/generated/kubernetes-api/v1.18/#container-v1-core).
     * </pre>
     *
     * <code>repeated string args = 3 [(.google.api.field_behavior) = IMMUTABLE];</code>
     *
     * @param value The args to add.
     * @return This builder for chaining.
     */
    public Builder addArgs(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      ensureArgsIsMutable();
      args_.add(value);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Immutable. Specifies arguments for the command that runs when the container starts.
     * This overrides the container's
     * [`CMD`](https://docs.docker.com/engine/reference/builder/#cmd). Specify
     * this field as an array of executable and arguments, similar to a Docker
     * `CMD`'s "default parameters" form.
     * If you don't specify this field but do specify the
     * [command][google.cloud.aiplatform.v1beta1.ModelContainerSpec.command] field, then the command from the
     * `command` field runs without any additional arguments. See the
     * [Kubernetes documentation about how the
     * `command` and `args` fields interact with a container's `ENTRYPOINT` and
     * `CMD`](https://kubernetes.io/docs/tasks/inject-data-application/define-command-argument-container/#notes).
     * If you don't specify this field and don't specify the `command` field,
     * then the container's
     * [`ENTRYPOINT`](https://docs.docker.com/engine/reference/builder/#cmd) and
     * `CMD` determine what runs based on their default behavior. See the Docker
     * documentation about [how `CMD` and `ENTRYPOINT`
     * interact](https://docs.docker.com/engine/reference/builder/#understand-how-cmd-and-entrypoint-interact).
     * In this field, you can reference [environment variables
     * set by Vertex
     * AI](https://cloud.google.com/vertex-ai/docs/predictions/custom-container-requirements#aip-variables)
     * and environment variables set in the [env][google.cloud.aiplatform.v1beta1.ModelContainerSpec.env] field.
     * You cannot reference environment variables set in the Docker image. In
     * order for environment variables to be expanded, reference them by using the
     * following syntax:
     * &lt;code&gt;$(&lt;var&gt;VARIABLE_NAME&lt;/var&gt;)&lt;/code&gt;
     * Note that this differs from Bash variable expansion, which does not use
     * parentheses. If a variable cannot be resolved, the reference in the input
     * string is used unchanged. To avoid variable expansion, you can escape this
     * syntax with `$$`; for example:
     * &lt;code&gt;$$(&lt;var&gt;VARIABLE_NAME&lt;/var&gt;)&lt;/code&gt;
     * This field corresponds to the `args` field of the Kubernetes Containers
     * [v1 core
     * API](https://v1-18.docs.kubernetes.io/docs/reference/generated/kubernetes-api/v1.18/#container-v1-core).
     * </pre>
     *
     * <code>repeated string args = 3 [(.google.api.field_behavior) = IMMUTABLE];</code>
     *
     * @param values The args to add.
     * @return This builder for chaining.
     */
    public Builder addAllArgs(java.lang.Iterable<java.lang.String> values) {
      ensureArgsIsMutable();
      com.google.protobuf.AbstractMessageLite.Builder.addAll(values, args_);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Immutable. Specifies arguments for the command that runs when the container starts.
     * This overrides the container's
     * [`CMD`](https://docs.docker.com/engine/reference/builder/#cmd). Specify
     * this field as an array of executable and arguments, similar to a Docker
     * `CMD`'s "default parameters" form.
     * If you don't specify this field but do specify the
     * [command][google.cloud.aiplatform.v1beta1.ModelContainerSpec.command] field, then the command from the
     * `command` field runs without any additional arguments. See the
     * [Kubernetes documentation about how the
     * `command` and `args` fields interact with a container's `ENTRYPOINT` and
     * `CMD`](https://kubernetes.io/docs/tasks/inject-data-application/define-command-argument-container/#notes).
     * If you don't specify this field and don't specify the `command` field,
     * then the container's
     * [`ENTRYPOINT`](https://docs.docker.com/engine/reference/builder/#cmd) and
     * `CMD` determine what runs based on their default behavior. See the Docker
     * documentation about [how `CMD` and `ENTRYPOINT`
     * interact](https://docs.docker.com/engine/reference/builder/#understand-how-cmd-and-entrypoint-interact).
     * In this field, you can reference [environment variables
     * set by Vertex
     * AI](https://cloud.google.com/vertex-ai/docs/predictions/custom-container-requirements#aip-variables)
     * and environment variables set in the [env][google.cloud.aiplatform.v1beta1.ModelContainerSpec.env] field.
     * You cannot reference environment variables set in the Docker image. In
     * order for environment variables to be expanded, reference them by using the
     * following syntax:
     * &lt;code&gt;$(&lt;var&gt;VARIABLE_NAME&lt;/var&gt;)&lt;/code&gt;
     * Note that this differs from Bash variable expansion, which does not use
     * parentheses. If a variable cannot be resolved, the reference in the input
     * string is used unchanged. To avoid variable expansion, you can escape this
     * syntax with `$$`; for example:
     * &lt;code&gt;$$(&lt;var&gt;VARIABLE_NAME&lt;/var&gt;)&lt;/code&gt;
     * This field corresponds to the `args` field of the Kubernetes Containers
     * [v1 core
     * API](https://v1-18.docs.kubernetes.io/docs/reference/generated/kubernetes-api/v1.18/#container-v1-core).
     * </pre>
     *
     * <code>repeated string args = 3 [(.google.api.field_behavior) = IMMUTABLE];</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearArgs() {
      args_ = com.google.protobuf.LazyStringArrayList.EMPTY;
      bitField0_ = (bitField0_ & ~0x00000002);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Immutable. Specifies arguments for the command that runs when the container starts.
     * This overrides the container's
     * [`CMD`](https://docs.docker.com/engine/reference/builder/#cmd). Specify
     * this field as an array of executable and arguments, similar to a Docker
     * `CMD`'s "default parameters" form.
     * If you don't specify this field but do specify the
     * [command][google.cloud.aiplatform.v1beta1.ModelContainerSpec.command] field, then the command from the
     * `command` field runs without any additional arguments. See the
     * [Kubernetes documentation about how the
     * `command` and `args` fields interact with a container's `ENTRYPOINT` and
     * `CMD`](https://kubernetes.io/docs/tasks/inject-data-application/define-command-argument-container/#notes).
     * If you don't specify this field and don't specify the `command` field,
     * then the container's
     * [`ENTRYPOINT`](https://docs.docker.com/engine/reference/builder/#cmd) and
     * `CMD` determine what runs based on their default behavior. See the Docker
     * documentation about [how `CMD` and `ENTRYPOINT`
     * interact](https://docs.docker.com/engine/reference/builder/#understand-how-cmd-and-entrypoint-interact).
     * In this field, you can reference [environment variables
     * set by Vertex
     * AI](https://cloud.google.com/vertex-ai/docs/predictions/custom-container-requirements#aip-variables)
     * and environment variables set in the [env][google.cloud.aiplatform.v1beta1.ModelContainerSpec.env] field.
     * You cannot reference environment variables set in the Docker image. In
     * order for environment variables to be expanded, reference them by using the
     * following syntax:
     * &lt;code&gt;$(&lt;var&gt;VARIABLE_NAME&lt;/var&gt;)&lt;/code&gt;
     * Note that this differs from Bash variable expansion, which does not use
     * parentheses. If a variable cannot be resolved, the reference in the input
     * string is used unchanged. To avoid variable expansion, you can escape this
     * syntax with `$$`; for example:
     * &lt;code&gt;$$(&lt;var&gt;VARIABLE_NAME&lt;/var&gt;)&lt;/code&gt;
     * This field corresponds to the `args` field of the Kubernetes Containers
     * [v1 core
     * API](https://v1-18.docs.kubernetes.io/docs/reference/generated/kubernetes-api/v1.18/#container-v1-core).
     * </pre>
     *
     * <code>repeated string args = 3 [(.google.api.field_behavior) = IMMUTABLE];</code>
     *
     * @param value The bytes of the args to add.
     * @return This builder for chaining.
     */
    public Builder addArgsBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      ensureArgsIsMutable();
      args_.add(value);
      onChanged();
      return this;
    }

    private java.util.List<com.google.cloud.aiplatform.v1beta1.EnvVar> env_ =
        java.util.Collections.emptyList();

    private void ensureEnvIsMutable() {
      if (!((bitField0_ & 0x00000004) != 0)) {
        env_ = new java.util.ArrayList<com.google.cloud.aiplatform.v1beta1.EnvVar>(env_);
        bitField0_ |= 0x00000004;
      }
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.cloud.aiplatform.v1beta1.EnvVar,
            com.google.cloud.aiplatform.v1beta1.EnvVar.Builder,
            com.google.cloud.aiplatform.v1beta1.EnvVarOrBuilder>
        envBuilder_;

    /**
     *
     *
     * <pre>
     * Immutable. List of environment variables to set in the container. After the container
     * starts running, code running in the container can read these environment
     * variables.
     * Additionally, the [command][google.cloud.aiplatform.v1beta1.ModelContainerSpec.command] and
     * [args][google.cloud.aiplatform.v1beta1.ModelContainerSpec.args] fields can reference these variables. Later
     * entries in this list can also reference earlier entries. For example, the
     * following example sets the variable `VAR_2` to have the value `foo bar`:
     * ```json
     * [
     *   {
     *     "name": "VAR_1",
     *     "value": "foo"
     *   },
     *   {
     *     "name": "VAR_2",
     *     "value": "$(VAR_1) bar"
     *   }
     * ]
     * ```
     * If you switch the order of the variables in the example, then the expansion
     * does not occur.
     * This field corresponds to the `env` field of the Kubernetes Containers
     * [v1 core
     * API](https://v1-18.docs.kubernetes.io/docs/reference/generated/kubernetes-api/v1.18/#container-v1-core).
     * </pre>
     *
     * <code>
     * repeated .google.cloud.aiplatform.v1beta1.EnvVar env = 4 [(.google.api.field_behavior) = IMMUTABLE];
     * </code>
     */
    public java.util.List<com.google.cloud.aiplatform.v1beta1.EnvVar> getEnvList() {
      if (envBuilder_ == null) {
        return java.util.Collections.unmodifiableList(env_);
      } else {
        return envBuilder_.getMessageList();
      }
    }
    /**
     *
     *
     * <pre>
     * Immutable. List of environment variables to set in the container. After the container
     * starts running, code running in the container can read these environment
     * variables.
     * Additionally, the [command][google.cloud.aiplatform.v1beta1.ModelContainerSpec.command] and
     * [args][google.cloud.aiplatform.v1beta1.ModelContainerSpec.args] fields can reference these variables. Later
     * entries in this list can also reference earlier entries. For example, the
     * following example sets the variable `VAR_2` to have the value `foo bar`:
     * ```json
     * [
     *   {
     *     "name": "VAR_1",
     *     "value": "foo"
     *   },
     *   {
     *     "name": "VAR_2",
     *     "value": "$(VAR_1) bar"
     *   }
     * ]
     * ```
     * If you switch the order of the variables in the example, then the expansion
     * does not occur.
     * This field corresponds to the `env` field of the Kubernetes Containers
     * [v1 core
     * API](https://v1-18.docs.kubernetes.io/docs/reference/generated/kubernetes-api/v1.18/#container-v1-core).
     * </pre>
     *
     * <code>
     * repeated .google.cloud.aiplatform.v1beta1.EnvVar env = 4 [(.google.api.field_behavior) = IMMUTABLE];
     * </code>
     */
    public int getEnvCount() {
      if (envBuilder_ == null) {
        return env_.size();
      } else {
        return envBuilder_.getCount();
      }
    }
    /**
     *
     *
     * <pre>
     * Immutable. List of environment variables to set in the container. After the container
     * starts running, code running in the container can read these environment
     * variables.
     * Additionally, the [command][google.cloud.aiplatform.v1beta1.ModelContainerSpec.command] and
     * [args][google.cloud.aiplatform.v1beta1.ModelContainerSpec.args] fields can reference these variables. Later
     * entries in this list can also reference earlier entries. For example, the
     * following example sets the variable `VAR_2` to have the value `foo bar`:
     * ```json
     * [
     *   {
     *     "name": "VAR_1",
     *     "value": "foo"
     *   },
     *   {
     *     "name": "VAR_2",
     *     "value": "$(VAR_1) bar"
     *   }
     * ]
     * ```
     * If you switch the order of the variables in the example, then the expansion
     * does not occur.
     * This field corresponds to the `env` field of the Kubernetes Containers
     * [v1 core
     * API](https://v1-18.docs.kubernetes.io/docs/reference/generated/kubernetes-api/v1.18/#container-v1-core).
     * </pre>
     *
     * <code>
     * repeated .google.cloud.aiplatform.v1beta1.EnvVar env = 4 [(.google.api.field_behavior) = IMMUTABLE];
     * </code>
     */
    public com.google.cloud.aiplatform.v1beta1.EnvVar getEnv(int index) {
      if (envBuilder_ == null) {
        return env_.get(index);
      } else {
        return envBuilder_.getMessage(index);
      }
    }
    /**
     *
     *
     * <pre>
     * Immutable. List of environment variables to set in the container. After the container
     * starts running, code running in the container can read these environment
     * variables.
     * Additionally, the [command][google.cloud.aiplatform.v1beta1.ModelContainerSpec.command] and
     * [args][google.cloud.aiplatform.v1beta1.ModelContainerSpec.args] fields can reference these variables. Later
     * entries in this list can also reference earlier entries. For example, the
     * following example sets the variable `VAR_2` to have the value `foo bar`:
     * ```json
     * [
     *   {
     *     "name": "VAR_1",
     *     "value": "foo"
     *   },
     *   {
     *     "name": "VAR_2",
     *     "value": "$(VAR_1) bar"
     *   }
     * ]
     * ```
     * If you switch the order of the variables in the example, then the expansion
     * does not occur.
     * This field corresponds to the `env` field of the Kubernetes Containers
     * [v1 core
     * API](https://v1-18.docs.kubernetes.io/docs/reference/generated/kubernetes-api/v1.18/#container-v1-core).
     * </pre>
     *
     * <code>
     * repeated .google.cloud.aiplatform.v1beta1.EnvVar env = 4 [(.google.api.field_behavior) = IMMUTABLE];
     * </code>
     */
    public Builder setEnv(int index, com.google.cloud.aiplatform.v1beta1.EnvVar value) {
      if (envBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureEnvIsMutable();
        env_.set(index, value);
        onChanged();
      } else {
        envBuilder_.setMessage(index, value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Immutable. List of environment variables to set in the container. After the container
     * starts running, code running in the container can read these environment
     * variables.
     * Additionally, the [command][google.cloud.aiplatform.v1beta1.ModelContainerSpec.command] and
     * [args][google.cloud.aiplatform.v1beta1.ModelContainerSpec.args] fields can reference these variables. Later
     * entries in this list can also reference earlier entries. For example, the
     * following example sets the variable `VAR_2` to have the value `foo bar`:
     * ```json
     * [
     *   {
     *     "name": "VAR_1",
     *     "value": "foo"
     *   },
     *   {
     *     "name": "VAR_2",
     *     "value": "$(VAR_1) bar"
     *   }
     * ]
     * ```
     * If you switch the order of the variables in the example, then the expansion
     * does not occur.
     * This field corresponds to the `env` field of the Kubernetes Containers
     * [v1 core
     * API](https://v1-18.docs.kubernetes.io/docs/reference/generated/kubernetes-api/v1.18/#container-v1-core).
     * </pre>
     *
     * <code>
     * repeated .google.cloud.aiplatform.v1beta1.EnvVar env = 4 [(.google.api.field_behavior) = IMMUTABLE];
     * </code>
     */
    public Builder setEnv(
        int index, com.google.cloud.aiplatform.v1beta1.EnvVar.Builder builderForValue) {
      if (envBuilder_ == null) {
        ensureEnvIsMutable();
        env_.set(index, builderForValue.build());
        onChanged();
      } else {
        envBuilder_.setMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Immutable. List of environment variables to set in the container. After the container
     * starts running, code running in the container can read these environment
     * variables.
     * Additionally, the [command][google.cloud.aiplatform.v1beta1.ModelContainerSpec.command] and
     * [args][google.cloud.aiplatform.v1beta1.ModelContainerSpec.args] fields can reference these variables. Later
     * entries in this list can also reference earlier entries. For example, the
     * following example sets the variable `VAR_2` to have the value `foo bar`:
     * ```json
     * [
     *   {
     *     "name": "VAR_1",
     *     "value": "foo"
     *   },
     *   {
     *     "name": "VAR_2",
     *     "value": "$(VAR_1) bar"
     *   }
     * ]
     * ```
     * If you switch the order of the variables in the example, then the expansion
     * does not occur.
     * This field corresponds to the `env` field of the Kubernetes Containers
     * [v1 core
     * API](https://v1-18.docs.kubernetes.io/docs/reference/generated/kubernetes-api/v1.18/#container-v1-core).
     * </pre>
     *
     * <code>
     * repeated .google.cloud.aiplatform.v1beta1.EnvVar env = 4 [(.google.api.field_behavior) = IMMUTABLE];
     * </code>
     */
    public Builder addEnv(com.google.cloud.aiplatform.v1beta1.EnvVar value) {
      if (envBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureEnvIsMutable();
        env_.add(value);
        onChanged();
      } else {
        envBuilder_.addMessage(value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Immutable. List of environment variables to set in the container. After the container
     * starts running, code running in the container can read these environment
     * variables.
     * Additionally, the [command][google.cloud.aiplatform.v1beta1.ModelContainerSpec.command] and
     * [args][google.cloud.aiplatform.v1beta1.ModelContainerSpec.args] fields can reference these variables. Later
     * entries in this list can also reference earlier entries. For example, the
     * following example sets the variable `VAR_2` to have the value `foo bar`:
     * ```json
     * [
     *   {
     *     "name": "VAR_1",
     *     "value": "foo"
     *   },
     *   {
     *     "name": "VAR_2",
     *     "value": "$(VAR_1) bar"
     *   }
     * ]
     * ```
     * If you switch the order of the variables in the example, then the expansion
     * does not occur.
     * This field corresponds to the `env` field of the Kubernetes Containers
     * [v1 core
     * API](https://v1-18.docs.kubernetes.io/docs/reference/generated/kubernetes-api/v1.18/#container-v1-core).
     * </pre>
     *
     * <code>
     * repeated .google.cloud.aiplatform.v1beta1.EnvVar env = 4 [(.google.api.field_behavior) = IMMUTABLE];
     * </code>
     */
    public Builder addEnv(int index, com.google.cloud.aiplatform.v1beta1.EnvVar value) {
      if (envBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureEnvIsMutable();
        env_.add(index, value);
        onChanged();
      } else {
        envBuilder_.addMessage(index, value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Immutable. List of environment variables to set in the container. After the container
     * starts running, code running in the container can read these environment
     * variables.
     * Additionally, the [command][google.cloud.aiplatform.v1beta1.ModelContainerSpec.command] and
     * [args][google.cloud.aiplatform.v1beta1.ModelContainerSpec.args] fields can reference these variables. Later
     * entries in this list can also reference earlier entries. For example, the
     * following example sets the variable `VAR_2` to have the value `foo bar`:
     * ```json
     * [
     *   {
     *     "name": "VAR_1",
     *     "value": "foo"
     *   },
     *   {
     *     "name": "VAR_2",
     *     "value": "$(VAR_1) bar"
     *   }
     * ]
     * ```
     * If you switch the order of the variables in the example, then the expansion
     * does not occur.
     * This field corresponds to the `env` field of the Kubernetes Containers
     * [v1 core
     * API](https://v1-18.docs.kubernetes.io/docs/reference/generated/kubernetes-api/v1.18/#container-v1-core).
     * </pre>
     *
     * <code>
     * repeated .google.cloud.aiplatform.v1beta1.EnvVar env = 4 [(.google.api.field_behavior) = IMMUTABLE];
     * </code>
     */
    public Builder addEnv(com.google.cloud.aiplatform.v1beta1.EnvVar.Builder builderForValue) {
      if (envBuilder_ == null) {
        ensureEnvIsMutable();
        env_.add(builderForValue.build());
        onChanged();
      } else {
        envBuilder_.addMessage(builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Immutable. List of environment variables to set in the container. After the container
     * starts running, code running in the container can read these environment
     * variables.
     * Additionally, the [command][google.cloud.aiplatform.v1beta1.ModelContainerSpec.command] and
     * [args][google.cloud.aiplatform.v1beta1.ModelContainerSpec.args] fields can reference these variables. Later
     * entries in this list can also reference earlier entries. For example, the
     * following example sets the variable `VAR_2` to have the value `foo bar`:
     * ```json
     * [
     *   {
     *     "name": "VAR_1",
     *     "value": "foo"
     *   },
     *   {
     *     "name": "VAR_2",
     *     "value": "$(VAR_1) bar"
     *   }
     * ]
     * ```
     * If you switch the order of the variables in the example, then the expansion
     * does not occur.
     * This field corresponds to the `env` field of the Kubernetes Containers
     * [v1 core
     * API](https://v1-18.docs.kubernetes.io/docs/reference/generated/kubernetes-api/v1.18/#container-v1-core).
     * </pre>
     *
     * <code>
     * repeated .google.cloud.aiplatform.v1beta1.EnvVar env = 4 [(.google.api.field_behavior) = IMMUTABLE];
     * </code>
     */
    public Builder addEnv(
        int index, com.google.cloud.aiplatform.v1beta1.EnvVar.Builder builderForValue) {
      if (envBuilder_ == null) {
        ensureEnvIsMutable();
        env_.add(index, builderForValue.build());
        onChanged();
      } else {
        envBuilder_.addMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Immutable. List of environment variables to set in the container. After the container
     * starts running, code running in the container can read these environment
     * variables.
     * Additionally, the [command][google.cloud.aiplatform.v1beta1.ModelContainerSpec.command] and
     * [args][google.cloud.aiplatform.v1beta1.ModelContainerSpec.args] fields can reference these variables. Later
     * entries in this list can also reference earlier entries. For example, the
     * following example sets the variable `VAR_2` to have the value `foo bar`:
     * ```json
     * [
     *   {
     *     "name": "VAR_1",
     *     "value": "foo"
     *   },
     *   {
     *     "name": "VAR_2",
     *     "value": "$(VAR_1) bar"
     *   }
     * ]
     * ```
     * If you switch the order of the variables in the example, then the expansion
     * does not occur.
     * This field corresponds to the `env` field of the Kubernetes Containers
     * [v1 core
     * API](https://v1-18.docs.kubernetes.io/docs/reference/generated/kubernetes-api/v1.18/#container-v1-core).
     * </pre>
     *
     * <code>
     * repeated .google.cloud.aiplatform.v1beta1.EnvVar env = 4 [(.google.api.field_behavior) = IMMUTABLE];
     * </code>
     */
    public Builder addAllEnv(
        java.lang.Iterable<? extends com.google.cloud.aiplatform.v1beta1.EnvVar> values) {
      if (envBuilder_ == null) {
        ensureEnvIsMutable();
        com.google.protobuf.AbstractMessageLite.Builder.addAll(values, env_);
        onChanged();
      } else {
        envBuilder_.addAllMessages(values);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Immutable. List of environment variables to set in the container. After the container
     * starts running, code running in the container can read these environment
     * variables.
     * Additionally, the [command][google.cloud.aiplatform.v1beta1.ModelContainerSpec.command] and
     * [args][google.cloud.aiplatform.v1beta1.ModelContainerSpec.args] fields can reference these variables. Later
     * entries in this list can also reference earlier entries. For example, the
     * following example sets the variable `VAR_2` to have the value `foo bar`:
     * ```json
     * [
     *   {
     *     "name": "VAR_1",
     *     "value": "foo"
     *   },
     *   {
     *     "name": "VAR_2",
     *     "value": "$(VAR_1) bar"
     *   }
     * ]
     * ```
     * If you switch the order of the variables in the example, then the expansion
     * does not occur.
     * This field corresponds to the `env` field of the Kubernetes Containers
     * [v1 core
     * API](https://v1-18.docs.kubernetes.io/docs/reference/generated/kubernetes-api/v1.18/#container-v1-core).
     * </pre>
     *
     * <code>
     * repeated .google.cloud.aiplatform.v1beta1.EnvVar env = 4 [(.google.api.field_behavior) = IMMUTABLE];
     * </code>
     */
    public Builder clearEnv() {
      if (envBuilder_ == null) {
        env_ = java.util.Collections.emptyList();
        bitField0_ = (bitField0_ & ~0x00000004);
        onChanged();
      } else {
        envBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Immutable. List of environment variables to set in the container. After the container
     * starts running, code running in the container can read these environment
     * variables.
     * Additionally, the [command][google.cloud.aiplatform.v1beta1.ModelContainerSpec.command] and
     * [args][google.cloud.aiplatform.v1beta1.ModelContainerSpec.args] fields can reference these variables. Later
     * entries in this list can also reference earlier entries. For example, the
     * following example sets the variable `VAR_2` to have the value `foo bar`:
     * ```json
     * [
     *   {
     *     "name": "VAR_1",
     *     "value": "foo"
     *   },
     *   {
     *     "name": "VAR_2",
     *     "value": "$(VAR_1) bar"
     *   }
     * ]
     * ```
     * If you switch the order of the variables in the example, then the expansion
     * does not occur.
     * This field corresponds to the `env` field of the Kubernetes Containers
     * [v1 core
     * API](https://v1-18.docs.kubernetes.io/docs/reference/generated/kubernetes-api/v1.18/#container-v1-core).
     * </pre>
     *
     * <code>
     * repeated .google.cloud.aiplatform.v1beta1.EnvVar env = 4 [(.google.api.field_behavior) = IMMUTABLE];
     * </code>
     */
    public Builder removeEnv(int index) {
      if (envBuilder_ == null) {
        ensureEnvIsMutable();
        env_.remove(index);
        onChanged();
      } else {
        envBuilder_.remove(index);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Immutable. List of environment variables to set in the container. After the container
     * starts running, code running in the container can read these environment
     * variables.
     * Additionally, the [command][google.cloud.aiplatform.v1beta1.ModelContainerSpec.command] and
     * [args][google.cloud.aiplatform.v1beta1.ModelContainerSpec.args] fields can reference these variables. Later
     * entries in this list can also reference earlier entries. For example, the
     * following example sets the variable `VAR_2` to have the value `foo bar`:
     * ```json
     * [
     *   {
     *     "name": "VAR_1",
     *     "value": "foo"
     *   },
     *   {
     *     "name": "VAR_2",
     *     "value": "$(VAR_1) bar"
     *   }
     * ]
     * ```
     * If you switch the order of the variables in the example, then the expansion
     * does not occur.
     * This field corresponds to the `env` field of the Kubernetes Containers
     * [v1 core
     * API](https://v1-18.docs.kubernetes.io/docs/reference/generated/kubernetes-api/v1.18/#container-v1-core).
     * </pre>
     *
     * <code>
     * repeated .google.cloud.aiplatform.v1beta1.EnvVar env = 4 [(.google.api.field_behavior) = IMMUTABLE];
     * </code>
     */
    public com.google.cloud.aiplatform.v1beta1.EnvVar.Builder getEnvBuilder(int index) {
      return getEnvFieldBuilder().getBuilder(index);
    }
    /**
     *
     *
     * <pre>
     * Immutable. List of environment variables to set in the container. After the container
     * starts running, code running in the container can read these environment
     * variables.
     * Additionally, the [command][google.cloud.aiplatform.v1beta1.ModelContainerSpec.command] and
     * [args][google.cloud.aiplatform.v1beta1.ModelContainerSpec.args] fields can reference these variables. Later
     * entries in this list can also reference earlier entries. For example, the
     * following example sets the variable `VAR_2` to have the value `foo bar`:
     * ```json
     * [
     *   {
     *     "name": "VAR_1",
     *     "value": "foo"
     *   },
     *   {
     *     "name": "VAR_2",
     *     "value": "$(VAR_1) bar"
     *   }
     * ]
     * ```
     * If you switch the order of the variables in the example, then the expansion
     * does not occur.
     * This field corresponds to the `env` field of the Kubernetes Containers
     * [v1 core
     * API](https://v1-18.docs.kubernetes.io/docs/reference/generated/kubernetes-api/v1.18/#container-v1-core).
     * </pre>
     *
     * <code>
     * repeated .google.cloud.aiplatform.v1beta1.EnvVar env = 4 [(.google.api.field_behavior) = IMMUTABLE];
     * </code>
     */
    public com.google.cloud.aiplatform.v1beta1.EnvVarOrBuilder getEnvOrBuilder(int index) {
      if (envBuilder_ == null) {
        return env_.get(index);
      } else {
        return envBuilder_.getMessageOrBuilder(index);
      }
    }
    /**
     *
     *
     * <pre>
     * Immutable. List of environment variables to set in the container. After the container
     * starts running, code running in the container can read these environment
     * variables.
     * Additionally, the [command][google.cloud.aiplatform.v1beta1.ModelContainerSpec.command] and
     * [args][google.cloud.aiplatform.v1beta1.ModelContainerSpec.args] fields can reference these variables. Later
     * entries in this list can also reference earlier entries. For example, the
     * following example sets the variable `VAR_2` to have the value `foo bar`:
     * ```json
     * [
     *   {
     *     "name": "VAR_1",
     *     "value": "foo"
     *   },
     *   {
     *     "name": "VAR_2",
     *     "value": "$(VAR_1) bar"
     *   }
     * ]
     * ```
     * If you switch the order of the variables in the example, then the expansion
     * does not occur.
     * This field corresponds to the `env` field of the Kubernetes Containers
     * [v1 core
     * API](https://v1-18.docs.kubernetes.io/docs/reference/generated/kubernetes-api/v1.18/#container-v1-core).
     * </pre>
     *
     * <code>
     * repeated .google.cloud.aiplatform.v1beta1.EnvVar env = 4 [(.google.api.field_behavior) = IMMUTABLE];
     * </code>
     */
    public java.util.List<? extends com.google.cloud.aiplatform.v1beta1.EnvVarOrBuilder>
        getEnvOrBuilderList() {
      if (envBuilder_ != null) {
        return envBuilder_.getMessageOrBuilderList();
      } else {
        return java.util.Collections.unmodifiableList(env_);
      }
    }
    /**
     *
     *
     * <pre>
     * Immutable. List of environment variables to set in the container. After the container
     * starts running, code running in the container can read these environment
     * variables.
     * Additionally, the [command][google.cloud.aiplatform.v1beta1.ModelContainerSpec.command] and
     * [args][google.cloud.aiplatform.v1beta1.ModelContainerSpec.args] fields can reference these variables. Later
     * entries in this list can also reference earlier entries. For example, the
     * following example sets the variable `VAR_2` to have the value `foo bar`:
     * ```json
     * [
     *   {
     *     "name": "VAR_1",
     *     "value": "foo"
     *   },
     *   {
     *     "name": "VAR_2",
     *     "value": "$(VAR_1) bar"
     *   }
     * ]
     * ```
     * If you switch the order of the variables in the example, then the expansion
     * does not occur.
     * This field corresponds to the `env` field of the Kubernetes Containers
     * [v1 core
     * API](https://v1-18.docs.kubernetes.io/docs/reference/generated/kubernetes-api/v1.18/#container-v1-core).
     * </pre>
     *
     * <code>
     * repeated .google.cloud.aiplatform.v1beta1.EnvVar env = 4 [(.google.api.field_behavior) = IMMUTABLE];
     * </code>
     */
    public com.google.cloud.aiplatform.v1beta1.EnvVar.Builder addEnvBuilder() {
      return getEnvFieldBuilder()
          .addBuilder(com.google.cloud.aiplatform.v1beta1.EnvVar.getDefaultInstance());
    }
    /**
     *
     *
     * <pre>
     * Immutable. List of environment variables to set in the container. After the container
     * starts running, code running in the container can read these environment
     * variables.
     * Additionally, the [command][google.cloud.aiplatform.v1beta1.ModelContainerSpec.command] and
     * [args][google.cloud.aiplatform.v1beta1.ModelContainerSpec.args] fields can reference these variables. Later
     * entries in this list can also reference earlier entries. For example, the
     * following example sets the variable `VAR_2` to have the value `foo bar`:
     * ```json
     * [
     *   {
     *     "name": "VAR_1",
     *     "value": "foo"
     *   },
     *   {
     *     "name": "VAR_2",
     *     "value": "$(VAR_1) bar"
     *   }
     * ]
     * ```
     * If you switch the order of the variables in the example, then the expansion
     * does not occur.
     * This field corresponds to the `env` field of the Kubernetes Containers
     * [v1 core
     * API](https://v1-18.docs.kubernetes.io/docs/reference/generated/kubernetes-api/v1.18/#container-v1-core).
     * </pre>
     *
     * <code>
     * repeated .google.cloud.aiplatform.v1beta1.EnvVar env = 4 [(.google.api.field_behavior) = IMMUTABLE];
     * </code>
     */
    public com.google.cloud.aiplatform.v1beta1.EnvVar.Builder addEnvBuilder(int index) {
      return getEnvFieldBuilder()
          .addBuilder(index, com.google.cloud.aiplatform.v1beta1.EnvVar.getDefaultInstance());
    }
    /**
     *
     *
     * <pre>
     * Immutable. List of environment variables to set in the container. After the container
     * starts running, code running in the container can read these environment
     * variables.
     * Additionally, the [command][google.cloud.aiplatform.v1beta1.ModelContainerSpec.command] and
     * [args][google.cloud.aiplatform.v1beta1.ModelContainerSpec.args] fields can reference these variables. Later
     * entries in this list can also reference earlier entries. For example, the
     * following example sets the variable `VAR_2` to have the value `foo bar`:
     * ```json
     * [
     *   {
     *     "name": "VAR_1",
     *     "value": "foo"
     *   },
     *   {
     *     "name": "VAR_2",
     *     "value": "$(VAR_1) bar"
     *   }
     * ]
     * ```
     * If you switch the order of the variables in the example, then the expansion
     * does not occur.
     * This field corresponds to the `env` field of the Kubernetes Containers
     * [v1 core
     * API](https://v1-18.docs.kubernetes.io/docs/reference/generated/kubernetes-api/v1.18/#container-v1-core).
     * </pre>
     *
     * <code>
     * repeated .google.cloud.aiplatform.v1beta1.EnvVar env = 4 [(.google.api.field_behavior) = IMMUTABLE];
     * </code>
     */
    public java.util.List<com.google.cloud.aiplatform.v1beta1.EnvVar.Builder> getEnvBuilderList() {
      return getEnvFieldBuilder().getBuilderList();
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.cloud.aiplatform.v1beta1.EnvVar,
            com.google.cloud.aiplatform.v1beta1.EnvVar.Builder,
            com.google.cloud.aiplatform.v1beta1.EnvVarOrBuilder>
        getEnvFieldBuilder() {
      if (envBuilder_ == null) {
        envBuilder_ =
            new com.google.protobuf.RepeatedFieldBuilderV3<
                com.google.cloud.aiplatform.v1beta1.EnvVar,
                com.google.cloud.aiplatform.v1beta1.EnvVar.Builder,
                com.google.cloud.aiplatform.v1beta1.EnvVarOrBuilder>(
                env_, ((bitField0_ & 0x00000004) != 0), getParentForChildren(), isClean());
        env_ = null;
      }
      return envBuilder_;
    }

    private java.util.List<com.google.cloud.aiplatform.v1beta1.Port> ports_ =
        java.util.Collections.emptyList();

    private void ensurePortsIsMutable() {
      if (!((bitField0_ & 0x00000008) != 0)) {
        ports_ = new java.util.ArrayList<com.google.cloud.aiplatform.v1beta1.Port>(ports_);
        bitField0_ |= 0x00000008;
      }
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.cloud.aiplatform.v1beta1.Port,
            com.google.cloud.aiplatform.v1beta1.Port.Builder,
            com.google.cloud.aiplatform.v1beta1.PortOrBuilder>
        portsBuilder_;

    /**
     *
     *
     * <pre>
     * Immutable. List of ports to expose from the container. Vertex AI sends any
     * prediction requests that it receives to the first port on this list. Vertex
     * AI also sends
     * [liveness and health
     * checks](https://cloud.google.com/vertex-ai/docs/predictions/custom-container-requirements#liveness)
     * to this port.
     * If you do not specify this field, it defaults to following value:
     * ```json
     * [
     *   {
     *     "containerPort": 8080
     *   }
     * ]
     * ```
     * Vertex AI does not use ports other than the first one listed. This field
     * corresponds to the `ports` field of the Kubernetes Containers
     * [v1 core
     * API](https://v1-18.docs.kubernetes.io/docs/reference/generated/kubernetes-api/v1.18/#container-v1-core).
     * </pre>
     *
     * <code>
     * repeated .google.cloud.aiplatform.v1beta1.Port ports = 5 [(.google.api.field_behavior) = IMMUTABLE];
     * </code>
     */
    public java.util.List<com.google.cloud.aiplatform.v1beta1.Port> getPortsList() {
      if (portsBuilder_ == null) {
        return java.util.Collections.unmodifiableList(ports_);
      } else {
        return portsBuilder_.getMessageList();
      }
    }
    /**
     *
     *
     * <pre>
     * Immutable. List of ports to expose from the container. Vertex AI sends any
     * prediction requests that it receives to the first port on this list. Vertex
     * AI also sends
     * [liveness and health
     * checks](https://cloud.google.com/vertex-ai/docs/predictions/custom-container-requirements#liveness)
     * to this port.
     * If you do not specify this field, it defaults to following value:
     * ```json
     * [
     *   {
     *     "containerPort": 8080
     *   }
     * ]
     * ```
     * Vertex AI does not use ports other than the first one listed. This field
     * corresponds to the `ports` field of the Kubernetes Containers
     * [v1 core
     * API](https://v1-18.docs.kubernetes.io/docs/reference/generated/kubernetes-api/v1.18/#container-v1-core).
     * </pre>
     *
     * <code>
     * repeated .google.cloud.aiplatform.v1beta1.Port ports = 5 [(.google.api.field_behavior) = IMMUTABLE];
     * </code>
     */
    public int getPortsCount() {
      if (portsBuilder_ == null) {
        return ports_.size();
      } else {
        return portsBuilder_.getCount();
      }
    }
    /**
     *
     *
     * <pre>
     * Immutable. List of ports to expose from the container. Vertex AI sends any
     * prediction requests that it receives to the first port on this list. Vertex
     * AI also sends
     * [liveness and health
     * checks](https://cloud.google.com/vertex-ai/docs/predictions/custom-container-requirements#liveness)
     * to this port.
     * If you do not specify this field, it defaults to following value:
     * ```json
     * [
     *   {
     *     "containerPort": 8080
     *   }
     * ]
     * ```
     * Vertex AI does not use ports other than the first one listed. This field
     * corresponds to the `ports` field of the Kubernetes Containers
     * [v1 core
     * API](https://v1-18.docs.kubernetes.io/docs/reference/generated/kubernetes-api/v1.18/#container-v1-core).
     * </pre>
     *
     * <code>
     * repeated .google.cloud.aiplatform.v1beta1.Port ports = 5 [(.google.api.field_behavior) = IMMUTABLE];
     * </code>
     */
    public com.google.cloud.aiplatform.v1beta1.Port getPorts(int index) {
      if (portsBuilder_ == null) {
        return ports_.get(index);
      } else {
        return portsBuilder_.getMessage(index);
      }
    }
    /**
     *
     *
     * <pre>
     * Immutable. List of ports to expose from the container. Vertex AI sends any
     * prediction requests that it receives to the first port on this list. Vertex
     * AI also sends
     * [liveness and health
     * checks](https://cloud.google.com/vertex-ai/docs/predictions/custom-container-requirements#liveness)
     * to this port.
     * If you do not specify this field, it defaults to following value:
     * ```json
     * [
     *   {
     *     "containerPort": 8080
     *   }
     * ]
     * ```
     * Vertex AI does not use ports other than the first one listed. This field
     * corresponds to the `ports` field of the Kubernetes Containers
     * [v1 core
     * API](https://v1-18.docs.kubernetes.io/docs/reference/generated/kubernetes-api/v1.18/#container-v1-core).
     * </pre>
     *
     * <code>
     * repeated .google.cloud.aiplatform.v1beta1.Port ports = 5 [(.google.api.field_behavior) = IMMUTABLE];
     * </code>
     */
    public Builder setPorts(int index, com.google.cloud.aiplatform.v1beta1.Port value) {
      if (portsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensurePortsIsMutable();
        ports_.set(index, value);
        onChanged();
      } else {
        portsBuilder_.setMessage(index, value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Immutable. List of ports to expose from the container. Vertex AI sends any
     * prediction requests that it receives to the first port on this list. Vertex
     * AI also sends
     * [liveness and health
     * checks](https://cloud.google.com/vertex-ai/docs/predictions/custom-container-requirements#liveness)
     * to this port.
     * If you do not specify this field, it defaults to following value:
     * ```json
     * [
     *   {
     *     "containerPort": 8080
     *   }
     * ]
     * ```
     * Vertex AI does not use ports other than the first one listed. This field
     * corresponds to the `ports` field of the Kubernetes Containers
     * [v1 core
     * API](https://v1-18.docs.kubernetes.io/docs/reference/generated/kubernetes-api/v1.18/#container-v1-core).
     * </pre>
     *
     * <code>
     * repeated .google.cloud.aiplatform.v1beta1.Port ports = 5 [(.google.api.field_behavior) = IMMUTABLE];
     * </code>
     */
    public Builder setPorts(
        int index, com.google.cloud.aiplatform.v1beta1.Port.Builder builderForValue) {
      if (portsBuilder_ == null) {
        ensurePortsIsMutable();
        ports_.set(index, builderForValue.build());
        onChanged();
      } else {
        portsBuilder_.setMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Immutable. List of ports to expose from the container. Vertex AI sends any
     * prediction requests that it receives to the first port on this list. Vertex
     * AI also sends
     * [liveness and health
     * checks](https://cloud.google.com/vertex-ai/docs/predictions/custom-container-requirements#liveness)
     * to this port.
     * If you do not specify this field, it defaults to following value:
     * ```json
     * [
     *   {
     *     "containerPort": 8080
     *   }
     * ]
     * ```
     * Vertex AI does not use ports other than the first one listed. This field
     * corresponds to the `ports` field of the Kubernetes Containers
     * [v1 core
     * API](https://v1-18.docs.kubernetes.io/docs/reference/generated/kubernetes-api/v1.18/#container-v1-core).
     * </pre>
     *
     * <code>
     * repeated .google.cloud.aiplatform.v1beta1.Port ports = 5 [(.google.api.field_behavior) = IMMUTABLE];
     * </code>
     */
    public Builder addPorts(com.google.cloud.aiplatform.v1beta1.Port value) {
      if (portsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensurePortsIsMutable();
        ports_.add(value);
        onChanged();
      } else {
        portsBuilder_.addMessage(value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Immutable. List of ports to expose from the container. Vertex AI sends any
     * prediction requests that it receives to the first port on this list. Vertex
     * AI also sends
     * [liveness and health
     * checks](https://cloud.google.com/vertex-ai/docs/predictions/custom-container-requirements#liveness)
     * to this port.
     * If you do not specify this field, it defaults to following value:
     * ```json
     * [
     *   {
     *     "containerPort": 8080
     *   }
     * ]
     * ```
     * Vertex AI does not use ports other than the first one listed. This field
     * corresponds to the `ports` field of the Kubernetes Containers
     * [v1 core
     * API](https://v1-18.docs.kubernetes.io/docs/reference/generated/kubernetes-api/v1.18/#container-v1-core).
     * </pre>
     *
     * <code>
     * repeated .google.cloud.aiplatform.v1beta1.Port ports = 5 [(.google.api.field_behavior) = IMMUTABLE];
     * </code>
     */
    public Builder addPorts(int index, com.google.cloud.aiplatform.v1beta1.Port value) {
      if (portsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensurePortsIsMutable();
        ports_.add(index, value);
        onChanged();
      } else {
        portsBuilder_.addMessage(index, value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Immutable. List of ports to expose from the container. Vertex AI sends any
     * prediction requests that it receives to the first port on this list. Vertex
     * AI also sends
     * [liveness and health
     * checks](https://cloud.google.com/vertex-ai/docs/predictions/custom-container-requirements#liveness)
     * to this port.
     * If you do not specify this field, it defaults to following value:
     * ```json
     * [
     *   {
     *     "containerPort": 8080
     *   }
     * ]
     * ```
     * Vertex AI does not use ports other than the first one listed. This field
     * corresponds to the `ports` field of the Kubernetes Containers
     * [v1 core
     * API](https://v1-18.docs.kubernetes.io/docs/reference/generated/kubernetes-api/v1.18/#container-v1-core).
     * </pre>
     *
     * <code>
     * repeated .google.cloud.aiplatform.v1beta1.Port ports = 5 [(.google.api.field_behavior) = IMMUTABLE];
     * </code>
     */
    public Builder addPorts(com.google.cloud.aiplatform.v1beta1.Port.Builder builderForValue) {
      if (portsBuilder_ == null) {
        ensurePortsIsMutable();
        ports_.add(builderForValue.build());
        onChanged();
      } else {
        portsBuilder_.addMessage(builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Immutable. List of ports to expose from the container. Vertex AI sends any
     * prediction requests that it receives to the first port on this list. Vertex
     * AI also sends
     * [liveness and health
     * checks](https://cloud.google.com/vertex-ai/docs/predictions/custom-container-requirements#liveness)
     * to this port.
     * If you do not specify this field, it defaults to following value:
     * ```json
     * [
     *   {
     *     "containerPort": 8080
     *   }
     * ]
     * ```
     * Vertex AI does not use ports other than the first one listed. This field
     * corresponds to the `ports` field of the Kubernetes Containers
     * [v1 core
     * API](https://v1-18.docs.kubernetes.io/docs/reference/generated/kubernetes-api/v1.18/#container-v1-core).
     * </pre>
     *
     * <code>
     * repeated .google.cloud.aiplatform.v1beta1.Port ports = 5 [(.google.api.field_behavior) = IMMUTABLE];
     * </code>
     */
    public Builder addPorts(
        int index, com.google.cloud.aiplatform.v1beta1.Port.Builder builderForValue) {
      if (portsBuilder_ == null) {
        ensurePortsIsMutable();
        ports_.add(index, builderForValue.build());
        onChanged();
      } else {
        portsBuilder_.addMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Immutable. List of ports to expose from the container. Vertex AI sends any
     * prediction requests that it receives to the first port on this list. Vertex
     * AI also sends
     * [liveness and health
     * checks](https://cloud.google.com/vertex-ai/docs/predictions/custom-container-requirements#liveness)
     * to this port.
     * If you do not specify this field, it defaults to following value:
     * ```json
     * [
     *   {
     *     "containerPort": 8080
     *   }
     * ]
     * ```
     * Vertex AI does not use ports other than the first one listed. This field
     * corresponds to the `ports` field of the Kubernetes Containers
     * [v1 core
     * API](https://v1-18.docs.kubernetes.io/docs/reference/generated/kubernetes-api/v1.18/#container-v1-core).
     * </pre>
     *
     * <code>
     * repeated .google.cloud.aiplatform.v1beta1.Port ports = 5 [(.google.api.field_behavior) = IMMUTABLE];
     * </code>
     */
    public Builder addAllPorts(
        java.lang.Iterable<? extends com.google.cloud.aiplatform.v1beta1.Port> values) {
      if (portsBuilder_ == null) {
        ensurePortsIsMutable();
        com.google.protobuf.AbstractMessageLite.Builder.addAll(values, ports_);
        onChanged();
      } else {
        portsBuilder_.addAllMessages(values);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Immutable. List of ports to expose from the container. Vertex AI sends any
     * prediction requests that it receives to the first port on this list. Vertex
     * AI also sends
     * [liveness and health
     * checks](https://cloud.google.com/vertex-ai/docs/predictions/custom-container-requirements#liveness)
     * to this port.
     * If you do not specify this field, it defaults to following value:
     * ```json
     * [
     *   {
     *     "containerPort": 8080
     *   }
     * ]
     * ```
     * Vertex AI does not use ports other than the first one listed. This field
     * corresponds to the `ports` field of the Kubernetes Containers
     * [v1 core
     * API](https://v1-18.docs.kubernetes.io/docs/reference/generated/kubernetes-api/v1.18/#container-v1-core).
     * </pre>
     *
     * <code>
     * repeated .google.cloud.aiplatform.v1beta1.Port ports = 5 [(.google.api.field_behavior) = IMMUTABLE];
     * </code>
     */
    public Builder clearPorts() {
      if (portsBuilder_ == null) {
        ports_ = java.util.Collections.emptyList();
        bitField0_ = (bitField0_ & ~0x00000008);
        onChanged();
      } else {
        portsBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Immutable. List of ports to expose from the container. Vertex AI sends any
     * prediction requests that it receives to the first port on this list. Vertex
     * AI also sends
     * [liveness and health
     * checks](https://cloud.google.com/vertex-ai/docs/predictions/custom-container-requirements#liveness)
     * to this port.
     * If you do not specify this field, it defaults to following value:
     * ```json
     * [
     *   {
     *     "containerPort": 8080
     *   }
     * ]
     * ```
     * Vertex AI does not use ports other than the first one listed. This field
     * corresponds to the `ports` field of the Kubernetes Containers
     * [v1 core
     * API](https://v1-18.docs.kubernetes.io/docs/reference/generated/kubernetes-api/v1.18/#container-v1-core).
     * </pre>
     *
     * <code>
     * repeated .google.cloud.aiplatform.v1beta1.Port ports = 5 [(.google.api.field_behavior) = IMMUTABLE];
     * </code>
     */
    public Builder removePorts(int index) {
      if (portsBuilder_ == null) {
        ensurePortsIsMutable();
        ports_.remove(index);
        onChanged();
      } else {
        portsBuilder_.remove(index);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Immutable. List of ports to expose from the container. Vertex AI sends any
     * prediction requests that it receives to the first port on this list. Vertex
     * AI also sends
     * [liveness and health
     * checks](https://cloud.google.com/vertex-ai/docs/predictions/custom-container-requirements#liveness)
     * to this port.
     * If you do not specify this field, it defaults to following value:
     * ```json
     * [
     *   {
     *     "containerPort": 8080
     *   }
     * ]
     * ```
     * Vertex AI does not use ports other than the first one listed. This field
     * corresponds to the `ports` field of the Kubernetes Containers
     * [v1 core
     * API](https://v1-18.docs.kubernetes.io/docs/reference/generated/kubernetes-api/v1.18/#container-v1-core).
     * </pre>
     *
     * <code>
     * repeated .google.cloud.aiplatform.v1beta1.Port ports = 5 [(.google.api.field_behavior) = IMMUTABLE];
     * </code>
     */
    public com.google.cloud.aiplatform.v1beta1.Port.Builder getPortsBuilder(int index) {
      return getPortsFieldBuilder().getBuilder(index);
    }
    /**
     *
     *
     * <pre>
     * Immutable. List of ports to expose from the container. Vertex AI sends any
     * prediction requests that it receives to the first port on this list. Vertex
     * AI also sends
     * [liveness and health
     * checks](https://cloud.google.com/vertex-ai/docs/predictions/custom-container-requirements#liveness)
     * to this port.
     * If you do not specify this field, it defaults to following value:
     * ```json
     * [
     *   {
     *     "containerPort": 8080
     *   }
     * ]
     * ```
     * Vertex AI does not use ports other than the first one listed. This field
     * corresponds to the `ports` field of the Kubernetes Containers
     * [v1 core
     * API](https://v1-18.docs.kubernetes.io/docs/reference/generated/kubernetes-api/v1.18/#container-v1-core).
     * </pre>
     *
     * <code>
     * repeated .google.cloud.aiplatform.v1beta1.Port ports = 5 [(.google.api.field_behavior) = IMMUTABLE];
     * </code>
     */
    public com.google.cloud.aiplatform.v1beta1.PortOrBuilder getPortsOrBuilder(int index) {
      if (portsBuilder_ == null) {
        return ports_.get(index);
      } else {
        return portsBuilder_.getMessageOrBuilder(index);
      }
    }
    /**
     *
     *
     * <pre>
     * Immutable. List of ports to expose from the container. Vertex AI sends any
     * prediction requests that it receives to the first port on this list. Vertex
     * AI also sends
     * [liveness and health
     * checks](https://cloud.google.com/vertex-ai/docs/predictions/custom-container-requirements#liveness)
     * to this port.
     * If you do not specify this field, it defaults to following value:
     * ```json
     * [
     *   {
     *     "containerPort": 8080
     *   }
     * ]
     * ```
     * Vertex AI does not use ports other than the first one listed. This field
     * corresponds to the `ports` field of the Kubernetes Containers
     * [v1 core
     * API](https://v1-18.docs.kubernetes.io/docs/reference/generated/kubernetes-api/v1.18/#container-v1-core).
     * </pre>
     *
     * <code>
     * repeated .google.cloud.aiplatform.v1beta1.Port ports = 5 [(.google.api.field_behavior) = IMMUTABLE];
     * </code>
     */
    public java.util.List<? extends com.google.cloud.aiplatform.v1beta1.PortOrBuilder>
        getPortsOrBuilderList() {
      if (portsBuilder_ != null) {
        return portsBuilder_.getMessageOrBuilderList();
      } else {
        return java.util.Collections.unmodifiableList(ports_);
      }
    }
    /**
     *
     *
     * <pre>
     * Immutable. List of ports to expose from the container. Vertex AI sends any
     * prediction requests that it receives to the first port on this list. Vertex
     * AI also sends
     * [liveness and health
     * checks](https://cloud.google.com/vertex-ai/docs/predictions/custom-container-requirements#liveness)
     * to this port.
     * If you do not specify this field, it defaults to following value:
     * ```json
     * [
     *   {
     *     "containerPort": 8080
     *   }
     * ]
     * ```
     * Vertex AI does not use ports other than the first one listed. This field
     * corresponds to the `ports` field of the Kubernetes Containers
     * [v1 core
     * API](https://v1-18.docs.kubernetes.io/docs/reference/generated/kubernetes-api/v1.18/#container-v1-core).
     * </pre>
     *
     * <code>
     * repeated .google.cloud.aiplatform.v1beta1.Port ports = 5 [(.google.api.field_behavior) = IMMUTABLE];
     * </code>
     */
    public com.google.cloud.aiplatform.v1beta1.Port.Builder addPortsBuilder() {
      return getPortsFieldBuilder()
          .addBuilder(com.google.cloud.aiplatform.v1beta1.Port.getDefaultInstance());
    }
    /**
     *
     *
     * <pre>
     * Immutable. List of ports to expose from the container. Vertex AI sends any
     * prediction requests that it receives to the first port on this list. Vertex
     * AI also sends
     * [liveness and health
     * checks](https://cloud.google.com/vertex-ai/docs/predictions/custom-container-requirements#liveness)
     * to this port.
     * If you do not specify this field, it defaults to following value:
     * ```json
     * [
     *   {
     *     "containerPort": 8080
     *   }
     * ]
     * ```
     * Vertex AI does not use ports other than the first one listed. This field
     * corresponds to the `ports` field of the Kubernetes Containers
     * [v1 core
     * API](https://v1-18.docs.kubernetes.io/docs/reference/generated/kubernetes-api/v1.18/#container-v1-core).
     * </pre>
     *
     * <code>
     * repeated .google.cloud.aiplatform.v1beta1.Port ports = 5 [(.google.api.field_behavior) = IMMUTABLE];
     * </code>
     */
    public com.google.cloud.aiplatform.v1beta1.Port.Builder addPortsBuilder(int index) {
      return getPortsFieldBuilder()
          .addBuilder(index, com.google.cloud.aiplatform.v1beta1.Port.getDefaultInstance());
    }
    /**
     *
     *
     * <pre>
     * Immutable. List of ports to expose from the container. Vertex AI sends any
     * prediction requests that it receives to the first port on this list. Vertex
     * AI also sends
     * [liveness and health
     * checks](https://cloud.google.com/vertex-ai/docs/predictions/custom-container-requirements#liveness)
     * to this port.
     * If you do not specify this field, it defaults to following value:
     * ```json
     * [
     *   {
     *     "containerPort": 8080
     *   }
     * ]
     * ```
     * Vertex AI does not use ports other than the first one listed. This field
     * corresponds to the `ports` field of the Kubernetes Containers
     * [v1 core
     * API](https://v1-18.docs.kubernetes.io/docs/reference/generated/kubernetes-api/v1.18/#container-v1-core).
     * </pre>
     *
     * <code>
     * repeated .google.cloud.aiplatform.v1beta1.Port ports = 5 [(.google.api.field_behavior) = IMMUTABLE];
     * </code>
     */
    public java.util.List<com.google.cloud.aiplatform.v1beta1.Port.Builder> getPortsBuilderList() {
      return getPortsFieldBuilder().getBuilderList();
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.cloud.aiplatform.v1beta1.Port,
            com.google.cloud.aiplatform.v1beta1.Port.Builder,
            com.google.cloud.aiplatform.v1beta1.PortOrBuilder>
        getPortsFieldBuilder() {
      if (portsBuilder_ == null) {
        portsBuilder_ =
            new com.google.protobuf.RepeatedFieldBuilderV3<
                com.google.cloud.aiplatform.v1beta1.Port,
                com.google.cloud.aiplatform.v1beta1.Port.Builder,
                com.google.cloud.aiplatform.v1beta1.PortOrBuilder>(
                ports_, ((bitField0_ & 0x00000008) != 0), getParentForChildren(), isClean());
        ports_ = null;
      }
      return portsBuilder_;
    }

    private java.lang.Object predictRoute_ = "";
    /**
     *
     *
     * <pre>
     * Immutable. HTTP path on the container to send prediction requests to. Vertex AI
     * forwards requests sent using
     * [projects.locations.endpoints.predict][google.cloud.aiplatform.v1beta1.PredictionService.Predict] to this
     * path on the container's IP address and port. Vertex AI then returns the
     * container's response in the API response.
     * For example, if you set this field to `/foo`, then when Vertex AI
     * receives a prediction request, it forwards the request body in a POST
     * request to the `/foo` path on the port of your container specified by the
     * first value of this `ModelContainerSpec`'s
     * [ports][google.cloud.aiplatform.v1beta1.ModelContainerSpec.ports] field.
     * If you don't specify this field, it defaults to the following value when
     * you [deploy this Model to an Endpoint][google.cloud.aiplatform.v1beta1.EndpointService.DeployModel]:
     * &lt;code&gt;/v1/endpoints/&lt;var&gt;ENDPOINT&lt;/var&gt;/deployedModels/&lt;var&gt;DEPLOYED_MODEL&lt;/var&gt;:predict&lt;/code&gt;
     * The placeholders in this value are replaced as follows:
     * * &lt;var&gt;ENDPOINT&lt;/var&gt;: The last segment (following `endpoints/`)of the
     *   Endpoint.name][] field of the Endpoint where this Model has been
     *   deployed. (Vertex AI makes this value available to your container code
     *   as the [`AIP_ENDPOINT_ID` environment
     *  variable](https://cloud.google.com/vertex-ai/docs/predictions/custom-container-requirements#aip-variables).)
     * * &lt;var&gt;DEPLOYED_MODEL&lt;/var&gt;: [DeployedModel.id][google.cloud.aiplatform.v1beta1.DeployedModel.id] of the `DeployedModel`.
     *   (Vertex AI makes this value available to your container code
     *   as the [`AIP_DEPLOYED_MODEL_ID` environment
     *   variable](https://cloud.google.com/vertex-ai/docs/predictions/custom-container-requirements#aip-variables).)
     * </pre>
     *
     * <code>string predict_route = 6 [(.google.api.field_behavior) = IMMUTABLE];</code>
     *
     * @return The predictRoute.
     */
    public java.lang.String getPredictRoute() {
      java.lang.Object ref = predictRoute_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        predictRoute_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Immutable. HTTP path on the container to send prediction requests to. Vertex AI
     * forwards requests sent using
     * [projects.locations.endpoints.predict][google.cloud.aiplatform.v1beta1.PredictionService.Predict] to this
     * path on the container's IP address and port. Vertex AI then returns the
     * container's response in the API response.
     * For example, if you set this field to `/foo`, then when Vertex AI
     * receives a prediction request, it forwards the request body in a POST
     * request to the `/foo` path on the port of your container specified by the
     * first value of this `ModelContainerSpec`'s
     * [ports][google.cloud.aiplatform.v1beta1.ModelContainerSpec.ports] field.
     * If you don't specify this field, it defaults to the following value when
     * you [deploy this Model to an Endpoint][google.cloud.aiplatform.v1beta1.EndpointService.DeployModel]:
     * &lt;code&gt;/v1/endpoints/&lt;var&gt;ENDPOINT&lt;/var&gt;/deployedModels/&lt;var&gt;DEPLOYED_MODEL&lt;/var&gt;:predict&lt;/code&gt;
     * The placeholders in this value are replaced as follows:
     * * &lt;var&gt;ENDPOINT&lt;/var&gt;: The last segment (following `endpoints/`)of the
     *   Endpoint.name][] field of the Endpoint where this Model has been
     *   deployed. (Vertex AI makes this value available to your container code
     *   as the [`AIP_ENDPOINT_ID` environment
     *  variable](https://cloud.google.com/vertex-ai/docs/predictions/custom-container-requirements#aip-variables).)
     * * &lt;var&gt;DEPLOYED_MODEL&lt;/var&gt;: [DeployedModel.id][google.cloud.aiplatform.v1beta1.DeployedModel.id] of the `DeployedModel`.
     *   (Vertex AI makes this value available to your container code
     *   as the [`AIP_DEPLOYED_MODEL_ID` environment
     *   variable](https://cloud.google.com/vertex-ai/docs/predictions/custom-container-requirements#aip-variables).)
     * </pre>
     *
     * <code>string predict_route = 6 [(.google.api.field_behavior) = IMMUTABLE];</code>
     *
     * @return The bytes for predictRoute.
     */
    public com.google.protobuf.ByteString getPredictRouteBytes() {
      java.lang.Object ref = predictRoute_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        predictRoute_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Immutable. HTTP path on the container to send prediction requests to. Vertex AI
     * forwards requests sent using
     * [projects.locations.endpoints.predict][google.cloud.aiplatform.v1beta1.PredictionService.Predict] to this
     * path on the container's IP address and port. Vertex AI then returns the
     * container's response in the API response.
     * For example, if you set this field to `/foo`, then when Vertex AI
     * receives a prediction request, it forwards the request body in a POST
     * request to the `/foo` path on the port of your container specified by the
     * first value of this `ModelContainerSpec`'s
     * [ports][google.cloud.aiplatform.v1beta1.ModelContainerSpec.ports] field.
     * If you don't specify this field, it defaults to the following value when
     * you [deploy this Model to an Endpoint][google.cloud.aiplatform.v1beta1.EndpointService.DeployModel]:
     * &lt;code&gt;/v1/endpoints/&lt;var&gt;ENDPOINT&lt;/var&gt;/deployedModels/&lt;var&gt;DEPLOYED_MODEL&lt;/var&gt;:predict&lt;/code&gt;
     * The placeholders in this value are replaced as follows:
     * * &lt;var&gt;ENDPOINT&lt;/var&gt;: The last segment (following `endpoints/`)of the
     *   Endpoint.name][] field of the Endpoint where this Model has been
     *   deployed. (Vertex AI makes this value available to your container code
     *   as the [`AIP_ENDPOINT_ID` environment
     *  variable](https://cloud.google.com/vertex-ai/docs/predictions/custom-container-requirements#aip-variables).)
     * * &lt;var&gt;DEPLOYED_MODEL&lt;/var&gt;: [DeployedModel.id][google.cloud.aiplatform.v1beta1.DeployedModel.id] of the `DeployedModel`.
     *   (Vertex AI makes this value available to your container code
     *   as the [`AIP_DEPLOYED_MODEL_ID` environment
     *   variable](https://cloud.google.com/vertex-ai/docs/predictions/custom-container-requirements#aip-variables).)
     * </pre>
     *
     * <code>string predict_route = 6 [(.google.api.field_behavior) = IMMUTABLE];</code>
     *
     * @param value The predictRoute to set.
     * @return This builder for chaining.
     */
    public Builder setPredictRoute(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }

      predictRoute_ = value;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Immutable. HTTP path on the container to send prediction requests to. Vertex AI
     * forwards requests sent using
     * [projects.locations.endpoints.predict][google.cloud.aiplatform.v1beta1.PredictionService.Predict] to this
     * path on the container's IP address and port. Vertex AI then returns the
     * container's response in the API response.
     * For example, if you set this field to `/foo`, then when Vertex AI
     * receives a prediction request, it forwards the request body in a POST
     * request to the `/foo` path on the port of your container specified by the
     * first value of this `ModelContainerSpec`'s
     * [ports][google.cloud.aiplatform.v1beta1.ModelContainerSpec.ports] field.
     * If you don't specify this field, it defaults to the following value when
     * you [deploy this Model to an Endpoint][google.cloud.aiplatform.v1beta1.EndpointService.DeployModel]:
     * &lt;code&gt;/v1/endpoints/&lt;var&gt;ENDPOINT&lt;/var&gt;/deployedModels/&lt;var&gt;DEPLOYED_MODEL&lt;/var&gt;:predict&lt;/code&gt;
     * The placeholders in this value are replaced as follows:
     * * &lt;var&gt;ENDPOINT&lt;/var&gt;: The last segment (following `endpoints/`)of the
     *   Endpoint.name][] field of the Endpoint where this Model has been
     *   deployed. (Vertex AI makes this value available to your container code
     *   as the [`AIP_ENDPOINT_ID` environment
     *  variable](https://cloud.google.com/vertex-ai/docs/predictions/custom-container-requirements#aip-variables).)
     * * &lt;var&gt;DEPLOYED_MODEL&lt;/var&gt;: [DeployedModel.id][google.cloud.aiplatform.v1beta1.DeployedModel.id] of the `DeployedModel`.
     *   (Vertex AI makes this value available to your container code
     *   as the [`AIP_DEPLOYED_MODEL_ID` environment
     *   variable](https://cloud.google.com/vertex-ai/docs/predictions/custom-container-requirements#aip-variables).)
     * </pre>
     *
     * <code>string predict_route = 6 [(.google.api.field_behavior) = IMMUTABLE];</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearPredictRoute() {

      predictRoute_ = getDefaultInstance().getPredictRoute();
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Immutable. HTTP path on the container to send prediction requests to. Vertex AI
     * forwards requests sent using
     * [projects.locations.endpoints.predict][google.cloud.aiplatform.v1beta1.PredictionService.Predict] to this
     * path on the container's IP address and port. Vertex AI then returns the
     * container's response in the API response.
     * For example, if you set this field to `/foo`, then when Vertex AI
     * receives a prediction request, it forwards the request body in a POST
     * request to the `/foo` path on the port of your container specified by the
     * first value of this `ModelContainerSpec`'s
     * [ports][google.cloud.aiplatform.v1beta1.ModelContainerSpec.ports] field.
     * If you don't specify this field, it defaults to the following value when
     * you [deploy this Model to an Endpoint][google.cloud.aiplatform.v1beta1.EndpointService.DeployModel]:
     * &lt;code&gt;/v1/endpoints/&lt;var&gt;ENDPOINT&lt;/var&gt;/deployedModels/&lt;var&gt;DEPLOYED_MODEL&lt;/var&gt;:predict&lt;/code&gt;
     * The placeholders in this value are replaced as follows:
     * * &lt;var&gt;ENDPOINT&lt;/var&gt;: The last segment (following `endpoints/`)of the
     *   Endpoint.name][] field of the Endpoint where this Model has been
     *   deployed. (Vertex AI makes this value available to your container code
     *   as the [`AIP_ENDPOINT_ID` environment
     *  variable](https://cloud.google.com/vertex-ai/docs/predictions/custom-container-requirements#aip-variables).)
     * * &lt;var&gt;DEPLOYED_MODEL&lt;/var&gt;: [DeployedModel.id][google.cloud.aiplatform.v1beta1.DeployedModel.id] of the `DeployedModel`.
     *   (Vertex AI makes this value available to your container code
     *   as the [`AIP_DEPLOYED_MODEL_ID` environment
     *   variable](https://cloud.google.com/vertex-ai/docs/predictions/custom-container-requirements#aip-variables).)
     * </pre>
     *
     * <code>string predict_route = 6 [(.google.api.field_behavior) = IMMUTABLE];</code>
     *
     * @param value The bytes for predictRoute to set.
     * @return This builder for chaining.
     */
    public Builder setPredictRouteBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);

      predictRoute_ = value;
      onChanged();
      return this;
    }

    private java.lang.Object healthRoute_ = "";
    /**
     *
     *
     * <pre>
     * Immutable. HTTP path on the container to send health checks to. Vertex AI
     * intermittently sends GET requests to this path on the container's IP
     * address and port to check that the container is healthy. Read more about
     * [health
     * checks](https://cloud.google.com/vertex-ai/docs/predictions/custom-container-requirements#health).
     * For example, if you set this field to `/bar`, then Vertex AI
     * intermittently sends a GET request to the `/bar` path on the port of your
     * container specified by the first value of this `ModelContainerSpec`'s
     * [ports][google.cloud.aiplatform.v1beta1.ModelContainerSpec.ports] field.
     * If you don't specify this field, it defaults to the following value when
     * you [deploy this Model to an Endpoint][google.cloud.aiplatform.v1beta1.EndpointService.DeployModel]:
     * &lt;code&gt;/v1/endpoints/&lt;var&gt;ENDPOINT&lt;/var&gt;/deployedModels/&lt;var&gt;DEPLOYED_MODEL&lt;/var&gt;:predict&lt;/code&gt;
     * The placeholders in this value are replaced as follows:
     * * &lt;var&gt;ENDPOINT&lt;/var&gt;: The last segment (following `endpoints/`)of the
     *   Endpoint.name][] field of the Endpoint where this Model has been
     *   deployed. (Vertex AI makes this value available to your container code
     *   as the [`AIP_ENDPOINT_ID` environment
     *   variable](https://cloud.google.com/vertex-ai/docs/predictions/custom-container-requirements#aip-variables).)
     * * &lt;var&gt;DEPLOYED_MODEL&lt;/var&gt;: [DeployedModel.id][google.cloud.aiplatform.v1beta1.DeployedModel.id] of the `DeployedModel`.
     *   (Vertex AI makes this value available to your container code as the
     *   [`AIP_DEPLOYED_MODEL_ID` environment
     *   variable](https://cloud.google.com/vertex-ai/docs/predictions/custom-container-requirements#aip-variables).)
     * </pre>
     *
     * <code>string health_route = 7 [(.google.api.field_behavior) = IMMUTABLE];</code>
     *
     * @return The healthRoute.
     */
    public java.lang.String getHealthRoute() {
      java.lang.Object ref = healthRoute_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        healthRoute_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Immutable. HTTP path on the container to send health checks to. Vertex AI
     * intermittently sends GET requests to this path on the container's IP
     * address and port to check that the container is healthy. Read more about
     * [health
     * checks](https://cloud.google.com/vertex-ai/docs/predictions/custom-container-requirements#health).
     * For example, if you set this field to `/bar`, then Vertex AI
     * intermittently sends a GET request to the `/bar` path on the port of your
     * container specified by the first value of this `ModelContainerSpec`'s
     * [ports][google.cloud.aiplatform.v1beta1.ModelContainerSpec.ports] field.
     * If you don't specify this field, it defaults to the following value when
     * you [deploy this Model to an Endpoint][google.cloud.aiplatform.v1beta1.EndpointService.DeployModel]:
     * &lt;code&gt;/v1/endpoints/&lt;var&gt;ENDPOINT&lt;/var&gt;/deployedModels/&lt;var&gt;DEPLOYED_MODEL&lt;/var&gt;:predict&lt;/code&gt;
     * The placeholders in this value are replaced as follows:
     * * &lt;var&gt;ENDPOINT&lt;/var&gt;: The last segment (following `endpoints/`)of the
     *   Endpoint.name][] field of the Endpoint where this Model has been
     *   deployed. (Vertex AI makes this value available to your container code
     *   as the [`AIP_ENDPOINT_ID` environment
     *   variable](https://cloud.google.com/vertex-ai/docs/predictions/custom-container-requirements#aip-variables).)
     * * &lt;var&gt;DEPLOYED_MODEL&lt;/var&gt;: [DeployedModel.id][google.cloud.aiplatform.v1beta1.DeployedModel.id] of the `DeployedModel`.
     *   (Vertex AI makes this value available to your container code as the
     *   [`AIP_DEPLOYED_MODEL_ID` environment
     *   variable](https://cloud.google.com/vertex-ai/docs/predictions/custom-container-requirements#aip-variables).)
     * </pre>
     *
     * <code>string health_route = 7 [(.google.api.field_behavior) = IMMUTABLE];</code>
     *
     * @return The bytes for healthRoute.
     */
    public com.google.protobuf.ByteString getHealthRouteBytes() {
      java.lang.Object ref = healthRoute_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        healthRoute_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Immutable. HTTP path on the container to send health checks to. Vertex AI
     * intermittently sends GET requests to this path on the container's IP
     * address and port to check that the container is healthy. Read more about
     * [health
     * checks](https://cloud.google.com/vertex-ai/docs/predictions/custom-container-requirements#health).
     * For example, if you set this field to `/bar`, then Vertex AI
     * intermittently sends a GET request to the `/bar` path on the port of your
     * container specified by the first value of this `ModelContainerSpec`'s
     * [ports][google.cloud.aiplatform.v1beta1.ModelContainerSpec.ports] field.
     * If you don't specify this field, it defaults to the following value when
     * you [deploy this Model to an Endpoint][google.cloud.aiplatform.v1beta1.EndpointService.DeployModel]:
     * &lt;code&gt;/v1/endpoints/&lt;var&gt;ENDPOINT&lt;/var&gt;/deployedModels/&lt;var&gt;DEPLOYED_MODEL&lt;/var&gt;:predict&lt;/code&gt;
     * The placeholders in this value are replaced as follows:
     * * &lt;var&gt;ENDPOINT&lt;/var&gt;: The last segment (following `endpoints/`)of the
     *   Endpoint.name][] field of the Endpoint where this Model has been
     *   deployed. (Vertex AI makes this value available to your container code
     *   as the [`AIP_ENDPOINT_ID` environment
     *   variable](https://cloud.google.com/vertex-ai/docs/predictions/custom-container-requirements#aip-variables).)
     * * &lt;var&gt;DEPLOYED_MODEL&lt;/var&gt;: [DeployedModel.id][google.cloud.aiplatform.v1beta1.DeployedModel.id] of the `DeployedModel`.
     *   (Vertex AI makes this value available to your container code as the
     *   [`AIP_DEPLOYED_MODEL_ID` environment
     *   variable](https://cloud.google.com/vertex-ai/docs/predictions/custom-container-requirements#aip-variables).)
     * </pre>
     *
     * <code>string health_route = 7 [(.google.api.field_behavior) = IMMUTABLE];</code>
     *
     * @param value The healthRoute to set.
     * @return This builder for chaining.
     */
    public Builder setHealthRoute(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }

      healthRoute_ = value;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Immutable. HTTP path on the container to send health checks to. Vertex AI
     * intermittently sends GET requests to this path on the container's IP
     * address and port to check that the container is healthy. Read more about
     * [health
     * checks](https://cloud.google.com/vertex-ai/docs/predictions/custom-container-requirements#health).
     * For example, if you set this field to `/bar`, then Vertex AI
     * intermittently sends a GET request to the `/bar` path on the port of your
     * container specified by the first value of this `ModelContainerSpec`'s
     * [ports][google.cloud.aiplatform.v1beta1.ModelContainerSpec.ports] field.
     * If you don't specify this field, it defaults to the following value when
     * you [deploy this Model to an Endpoint][google.cloud.aiplatform.v1beta1.EndpointService.DeployModel]:
     * &lt;code&gt;/v1/endpoints/&lt;var&gt;ENDPOINT&lt;/var&gt;/deployedModels/&lt;var&gt;DEPLOYED_MODEL&lt;/var&gt;:predict&lt;/code&gt;
     * The placeholders in this value are replaced as follows:
     * * &lt;var&gt;ENDPOINT&lt;/var&gt;: The last segment (following `endpoints/`)of the
     *   Endpoint.name][] field of the Endpoint where this Model has been
     *   deployed. (Vertex AI makes this value available to your container code
     *   as the [`AIP_ENDPOINT_ID` environment
     *   variable](https://cloud.google.com/vertex-ai/docs/predictions/custom-container-requirements#aip-variables).)
     * * &lt;var&gt;DEPLOYED_MODEL&lt;/var&gt;: [DeployedModel.id][google.cloud.aiplatform.v1beta1.DeployedModel.id] of the `DeployedModel`.
     *   (Vertex AI makes this value available to your container code as the
     *   [`AIP_DEPLOYED_MODEL_ID` environment
     *   variable](https://cloud.google.com/vertex-ai/docs/predictions/custom-container-requirements#aip-variables).)
     * </pre>
     *
     * <code>string health_route = 7 [(.google.api.field_behavior) = IMMUTABLE];</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearHealthRoute() {

      healthRoute_ = getDefaultInstance().getHealthRoute();
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Immutable. HTTP path on the container to send health checks to. Vertex AI
     * intermittently sends GET requests to this path on the container's IP
     * address and port to check that the container is healthy. Read more about
     * [health
     * checks](https://cloud.google.com/vertex-ai/docs/predictions/custom-container-requirements#health).
     * For example, if you set this field to `/bar`, then Vertex AI
     * intermittently sends a GET request to the `/bar` path on the port of your
     * container specified by the first value of this `ModelContainerSpec`'s
     * [ports][google.cloud.aiplatform.v1beta1.ModelContainerSpec.ports] field.
     * If you don't specify this field, it defaults to the following value when
     * you [deploy this Model to an Endpoint][google.cloud.aiplatform.v1beta1.EndpointService.DeployModel]:
     * &lt;code&gt;/v1/endpoints/&lt;var&gt;ENDPOINT&lt;/var&gt;/deployedModels/&lt;var&gt;DEPLOYED_MODEL&lt;/var&gt;:predict&lt;/code&gt;
     * The placeholders in this value are replaced as follows:
     * * &lt;var&gt;ENDPOINT&lt;/var&gt;: The last segment (following `endpoints/`)of the
     *   Endpoint.name][] field of the Endpoint where this Model has been
     *   deployed. (Vertex AI makes this value available to your container code
     *   as the [`AIP_ENDPOINT_ID` environment
     *   variable](https://cloud.google.com/vertex-ai/docs/predictions/custom-container-requirements#aip-variables).)
     * * &lt;var&gt;DEPLOYED_MODEL&lt;/var&gt;: [DeployedModel.id][google.cloud.aiplatform.v1beta1.DeployedModel.id] of the `DeployedModel`.
     *   (Vertex AI makes this value available to your container code as the
     *   [`AIP_DEPLOYED_MODEL_ID` environment
     *   variable](https://cloud.google.com/vertex-ai/docs/predictions/custom-container-requirements#aip-variables).)
     * </pre>
     *
     * <code>string health_route = 7 [(.google.api.field_behavior) = IMMUTABLE];</code>
     *
     * @param value The bytes for healthRoute to set.
     * @return This builder for chaining.
     */
    public Builder setHealthRouteBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);

      healthRoute_ = value;
      onChanged();
      return this;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.cloud.aiplatform.v1beta1.ModelContainerSpec)
  }

  // @@protoc_insertion_point(class_scope:google.cloud.aiplatform.v1beta1.ModelContainerSpec)
  private static final com.google.cloud.aiplatform.v1beta1.ModelContainerSpec DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.cloud.aiplatform.v1beta1.ModelContainerSpec();
  }

  public static com.google.cloud.aiplatform.v1beta1.ModelContainerSpec getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<ModelContainerSpec> PARSER =
      new com.google.protobuf.AbstractParser<ModelContainerSpec>() {
        @java.lang.Override
        public ModelContainerSpec parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          return new ModelContainerSpec(input, extensionRegistry);
        }
      };

  public static com.google.protobuf.Parser<ModelContainerSpec> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<ModelContainerSpec> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.cloud.aiplatform.v1beta1.ModelContainerSpec getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
