/*
 * Copyright 2020 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/cloud/aiplatform/v1beta1/model_deployment_monitoring_job.proto

package com.google.cloud.aiplatform.v1beta1;

/**
 *
 *
 * <pre>
 * Represents a job that runs periodically to monitor the deployed models in an
 * endpoint. It will analyze the logged training &amp; prediction data to detect any
 * abnormal behaviors.
 * </pre>
 *
 * Protobuf type {@code google.cloud.aiplatform.v1beta1.ModelDeploymentMonitoringJob}
 */
public final class ModelDeploymentMonitoringJob extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.cloud.aiplatform.v1beta1.ModelDeploymentMonitoringJob)
    ModelDeploymentMonitoringJobOrBuilder {
  private static final long serialVersionUID = 0L;
  // Use ModelDeploymentMonitoringJob.newBuilder() to construct.
  private ModelDeploymentMonitoringJob(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private ModelDeploymentMonitoringJob() {
    name_ = "";
    displayName_ = "";
    endpoint_ = "";
    state_ = 0;
    scheduleState_ = 0;
    modelDeploymentMonitoringObjectiveConfigs_ = java.util.Collections.emptyList();
    predictInstanceSchemaUri_ = "";
    analysisInstanceSchemaUri_ = "";
    bigqueryTables_ = java.util.Collections.emptyList();
  }

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new ModelDeploymentMonitoringJob();
  }

  @java.lang.Override
  public final com.google.protobuf.UnknownFieldSet getUnknownFields() {
    return this.unknownFields;
  }

  private ModelDeploymentMonitoringJob(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    this();
    if (extensionRegistry == null) {
      throw new java.lang.NullPointerException();
    }
    int mutable_bitField0_ = 0;
    com.google.protobuf.UnknownFieldSet.Builder unknownFields =
        com.google.protobuf.UnknownFieldSet.newBuilder();
    try {
      boolean done = false;
      while (!done) {
        int tag = input.readTag();
        switch (tag) {
          case 0:
            done = true;
            break;
          case 10:
            {
              java.lang.String s = input.readStringRequireUtf8();

              name_ = s;
              break;
            }
          case 18:
            {
              java.lang.String s = input.readStringRequireUtf8();

              displayName_ = s;
              break;
            }
          case 26:
            {
              java.lang.String s = input.readStringRequireUtf8();

              endpoint_ = s;
              break;
            }
          case 32:
            {
              int rawValue = input.readEnum();

              state_ = rawValue;
              break;
            }
          case 40:
            {
              int rawValue = input.readEnum();

              scheduleState_ = rawValue;
              break;
            }
          case 50:
            {
              if (!((mutable_bitField0_ & 0x00000001) != 0)) {
                modelDeploymentMonitoringObjectiveConfigs_ =
                    new java.util.ArrayList<
                        com.google.cloud.aiplatform.v1beta1
                            .ModelDeploymentMonitoringObjectiveConfig>();
                mutable_bitField0_ |= 0x00000001;
              }
              modelDeploymentMonitoringObjectiveConfigs_.add(
                  input.readMessage(
                      com.google.cloud.aiplatform.v1beta1.ModelDeploymentMonitoringObjectiveConfig
                          .parser(),
                      extensionRegistry));
              break;
            }
          case 58:
            {
              com.google.cloud.aiplatform.v1beta1.ModelDeploymentMonitoringScheduleConfig.Builder
                  subBuilder = null;
              if (modelDeploymentMonitoringScheduleConfig_ != null) {
                subBuilder = modelDeploymentMonitoringScheduleConfig_.toBuilder();
              }
              modelDeploymentMonitoringScheduleConfig_ =
                  input.readMessage(
                      com.google.cloud.aiplatform.v1beta1.ModelDeploymentMonitoringScheduleConfig
                          .parser(),
                      extensionRegistry);
              if (subBuilder != null) {
                subBuilder.mergeFrom(modelDeploymentMonitoringScheduleConfig_);
                modelDeploymentMonitoringScheduleConfig_ = subBuilder.buildPartial();
              }

              break;
            }
          case 66:
            {
              com.google.cloud.aiplatform.v1beta1.SamplingStrategy.Builder subBuilder = null;
              if (loggingSamplingStrategy_ != null) {
                subBuilder = loggingSamplingStrategy_.toBuilder();
              }
              loggingSamplingStrategy_ =
                  input.readMessage(
                      com.google.cloud.aiplatform.v1beta1.SamplingStrategy.parser(),
                      extensionRegistry);
              if (subBuilder != null) {
                subBuilder.mergeFrom(loggingSamplingStrategy_);
                loggingSamplingStrategy_ = subBuilder.buildPartial();
              }

              break;
            }
          case 74:
            {
              java.lang.String s = input.readStringRequireUtf8();

              predictInstanceSchemaUri_ = s;
              break;
            }
          case 82:
            {
              if (!((mutable_bitField0_ & 0x00000002) != 0)) {
                bigqueryTables_ =
                    new java.util.ArrayList<
                        com.google.cloud.aiplatform.v1beta1
                            .ModelDeploymentMonitoringBigQueryTable>();
                mutable_bitField0_ |= 0x00000002;
              }
              bigqueryTables_.add(
                  input.readMessage(
                      com.google.cloud.aiplatform.v1beta1.ModelDeploymentMonitoringBigQueryTable
                          .parser(),
                      extensionRegistry));
              break;
            }
          case 90:
            {
              if (!((mutable_bitField0_ & 0x00000004) != 0)) {
                labels_ =
                    com.google.protobuf.MapField.newMapField(LabelsDefaultEntryHolder.defaultEntry);
                mutable_bitField0_ |= 0x00000004;
              }
              com.google.protobuf.MapEntry<java.lang.String, java.lang.String> labels__ =
                  input.readMessage(
                      LabelsDefaultEntryHolder.defaultEntry.getParserForType(), extensionRegistry);
              labels_.getMutableMap().put(labels__.getKey(), labels__.getValue());
              break;
            }
          case 98:
            {
              com.google.protobuf.Timestamp.Builder subBuilder = null;
              if (createTime_ != null) {
                subBuilder = createTime_.toBuilder();
              }
              createTime_ =
                  input.readMessage(com.google.protobuf.Timestamp.parser(), extensionRegistry);
              if (subBuilder != null) {
                subBuilder.mergeFrom(createTime_);
                createTime_ = subBuilder.buildPartial();
              }

              break;
            }
          case 106:
            {
              com.google.protobuf.Timestamp.Builder subBuilder = null;
              if (updateTime_ != null) {
                subBuilder = updateTime_.toBuilder();
              }
              updateTime_ =
                  input.readMessage(com.google.protobuf.Timestamp.parser(), extensionRegistry);
              if (subBuilder != null) {
                subBuilder.mergeFrom(updateTime_);
                updateTime_ = subBuilder.buildPartial();
              }

              break;
            }
          case 114:
            {
              com.google.protobuf.Timestamp.Builder subBuilder = null;
              if (nextScheduleTime_ != null) {
                subBuilder = nextScheduleTime_.toBuilder();
              }
              nextScheduleTime_ =
                  input.readMessage(com.google.protobuf.Timestamp.parser(), extensionRegistry);
              if (subBuilder != null) {
                subBuilder.mergeFrom(nextScheduleTime_);
                nextScheduleTime_ = subBuilder.buildPartial();
              }

              break;
            }
          case 122:
            {
              com.google.cloud.aiplatform.v1beta1.ModelMonitoringAlertConfig.Builder subBuilder =
                  null;
              if (modelMonitoringAlertConfig_ != null) {
                subBuilder = modelMonitoringAlertConfig_.toBuilder();
              }
              modelMonitoringAlertConfig_ =
                  input.readMessage(
                      com.google.cloud.aiplatform.v1beta1.ModelMonitoringAlertConfig.parser(),
                      extensionRegistry);
              if (subBuilder != null) {
                subBuilder.mergeFrom(modelMonitoringAlertConfig_);
                modelMonitoringAlertConfig_ = subBuilder.buildPartial();
              }

              break;
            }
          case 130:
            {
              java.lang.String s = input.readStringRequireUtf8();

              analysisInstanceSchemaUri_ = s;
              break;
            }
          case 138:
            {
              com.google.protobuf.Duration.Builder subBuilder = null;
              if (logTtl_ != null) {
                subBuilder = logTtl_.toBuilder();
              }
              logTtl_ = input.readMessage(com.google.protobuf.Duration.parser(), extensionRegistry);
              if (subBuilder != null) {
                subBuilder.mergeFrom(logTtl_);
                logTtl_ = subBuilder.buildPartial();
              }

              break;
            }
          case 154:
            {
              com.google.protobuf.Value.Builder subBuilder = null;
              if (samplePredictInstance_ != null) {
                subBuilder = samplePredictInstance_.toBuilder();
              }
              samplePredictInstance_ =
                  input.readMessage(com.google.protobuf.Value.parser(), extensionRegistry);
              if (subBuilder != null) {
                subBuilder.mergeFrom(samplePredictInstance_);
                samplePredictInstance_ = subBuilder.buildPartial();
              }

              break;
            }
          case 162:
            {
              com.google.cloud.aiplatform.v1beta1.GcsDestination.Builder subBuilder = null;
              if (statsAnomaliesBaseDirectory_ != null) {
                subBuilder = statsAnomaliesBaseDirectory_.toBuilder();
              }
              statsAnomaliesBaseDirectory_ =
                  input.readMessage(
                      com.google.cloud.aiplatform.v1beta1.GcsDestination.parser(),
                      extensionRegistry);
              if (subBuilder != null) {
                subBuilder.mergeFrom(statsAnomaliesBaseDirectory_);
                statsAnomaliesBaseDirectory_ = subBuilder.buildPartial();
              }

              break;
            }
          case 170:
            {
              com.google.cloud.aiplatform.v1beta1.EncryptionSpec.Builder subBuilder = null;
              if (encryptionSpec_ != null) {
                subBuilder = encryptionSpec_.toBuilder();
              }
              encryptionSpec_ =
                  input.readMessage(
                      com.google.cloud.aiplatform.v1beta1.EncryptionSpec.parser(),
                      extensionRegistry);
              if (subBuilder != null) {
                subBuilder.mergeFrom(encryptionSpec_);
                encryptionSpec_ = subBuilder.buildPartial();
              }

              break;
            }
          case 186:
            {
              com.google.rpc.Status.Builder subBuilder = null;
              if (error_ != null) {
                subBuilder = error_.toBuilder();
              }
              error_ = input.readMessage(com.google.rpc.Status.parser(), extensionRegistry);
              if (subBuilder != null) {
                subBuilder.mergeFrom(error_);
                error_ = subBuilder.buildPartial();
              }

              break;
            }
          default:
            {
              if (!parseUnknownField(input, unknownFields, extensionRegistry, tag)) {
                done = true;
              }
              break;
            }
        }
      }
    } catch (com.google.protobuf.InvalidProtocolBufferException e) {
      throw e.setUnfinishedMessage(this);
    } catch (java.io.IOException e) {
      throw new com.google.protobuf.InvalidProtocolBufferException(e).setUnfinishedMessage(this);
    } finally {
      if (((mutable_bitField0_ & 0x00000001) != 0)) {
        modelDeploymentMonitoringObjectiveConfigs_ =
            java.util.Collections.unmodifiableList(modelDeploymentMonitoringObjectiveConfigs_);
      }
      if (((mutable_bitField0_ & 0x00000002) != 0)) {
        bigqueryTables_ = java.util.Collections.unmodifiableList(bigqueryTables_);
      }
      this.unknownFields = unknownFields.build();
      makeExtensionsImmutable();
    }
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.cloud.aiplatform.v1beta1.ModelDeploymentMonitoringJobProto
        .internal_static_google_cloud_aiplatform_v1beta1_ModelDeploymentMonitoringJob_descriptor;
  }

  @SuppressWarnings({"rawtypes"})
  @java.lang.Override
  protected com.google.protobuf.MapField internalGetMapField(int number) {
    switch (number) {
      case 11:
        return internalGetLabels();
      default:
        throw new RuntimeException("Invalid map field number: " + number);
    }
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.cloud.aiplatform.v1beta1.ModelDeploymentMonitoringJobProto
        .internal_static_google_cloud_aiplatform_v1beta1_ModelDeploymentMonitoringJob_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.cloud.aiplatform.v1beta1.ModelDeploymentMonitoringJob.class,
            com.google.cloud.aiplatform.v1beta1.ModelDeploymentMonitoringJob.Builder.class);
  }

  /**
   *
   *
   * <pre>
   * The state to Specify the monitoring pipeline.
   * </pre>
   *
   * Protobuf enum {@code
   * google.cloud.aiplatform.v1beta1.ModelDeploymentMonitoringJob.MonitoringScheduleState}
   */
  public enum MonitoringScheduleState implements com.google.protobuf.ProtocolMessageEnum {
    /**
     *
     *
     * <pre>
     * Unspecified state.
     * </pre>
     *
     * <code>MONITORING_SCHEDULE_STATE_UNSPECIFIED = 0;</code>
     */
    MONITORING_SCHEDULE_STATE_UNSPECIFIED(0),
    /**
     *
     *
     * <pre>
     * The pipeline is picked up and wait to run.
     * </pre>
     *
     * <code>PENDING = 1;</code>
     */
    PENDING(1),
    /**
     *
     *
     * <pre>
     * The pipeline is offline and will be scheduled for next run.
     * </pre>
     *
     * <code>OFFLINE = 2;</code>
     */
    OFFLINE(2),
    /**
     *
     *
     * <pre>
     * The pipeline is running.
     * </pre>
     *
     * <code>RUNNING = 3;</code>
     */
    RUNNING(3),
    UNRECOGNIZED(-1),
    ;

    /**
     *
     *
     * <pre>
     * Unspecified state.
     * </pre>
     *
     * <code>MONITORING_SCHEDULE_STATE_UNSPECIFIED = 0;</code>
     */
    public static final int MONITORING_SCHEDULE_STATE_UNSPECIFIED_VALUE = 0;
    /**
     *
     *
     * <pre>
     * The pipeline is picked up and wait to run.
     * </pre>
     *
     * <code>PENDING = 1;</code>
     */
    public static final int PENDING_VALUE = 1;
    /**
     *
     *
     * <pre>
     * The pipeline is offline and will be scheduled for next run.
     * </pre>
     *
     * <code>OFFLINE = 2;</code>
     */
    public static final int OFFLINE_VALUE = 2;
    /**
     *
     *
     * <pre>
     * The pipeline is running.
     * </pre>
     *
     * <code>RUNNING = 3;</code>
     */
    public static final int RUNNING_VALUE = 3;

    public final int getNumber() {
      if (this == UNRECOGNIZED) {
        throw new java.lang.IllegalArgumentException(
            "Can't get the number of an unknown enum value.");
      }
      return value;
    }

    /**
     * @param value The numeric wire value of the corresponding enum entry.
     * @return The enum associated with the given numeric wire value.
     * @deprecated Use {@link #forNumber(int)} instead.
     */
    @java.lang.Deprecated
    public static MonitoringScheduleState valueOf(int value) {
      return forNumber(value);
    }

    /**
     * @param value The numeric wire value of the corresponding enum entry.
     * @return The enum associated with the given numeric wire value.
     */
    public static MonitoringScheduleState forNumber(int value) {
      switch (value) {
        case 0:
          return MONITORING_SCHEDULE_STATE_UNSPECIFIED;
        case 1:
          return PENDING;
        case 2:
          return OFFLINE;
        case 3:
          return RUNNING;
        default:
          return null;
      }
    }

    public static com.google.protobuf.Internal.EnumLiteMap<MonitoringScheduleState>
        internalGetValueMap() {
      return internalValueMap;
    }

    private static final com.google.protobuf.Internal.EnumLiteMap<MonitoringScheduleState>
        internalValueMap =
            new com.google.protobuf.Internal.EnumLiteMap<MonitoringScheduleState>() {
              public MonitoringScheduleState findValueByNumber(int number) {
                return MonitoringScheduleState.forNumber(number);
              }
            };

    public final com.google.protobuf.Descriptors.EnumValueDescriptor getValueDescriptor() {
      if (this == UNRECOGNIZED) {
        throw new java.lang.IllegalStateException(
            "Can't get the descriptor of an unrecognized enum value.");
      }
      return getDescriptor().getValues().get(ordinal());
    }

    public final com.google.protobuf.Descriptors.EnumDescriptor getDescriptorForType() {
      return getDescriptor();
    }

    public static final com.google.protobuf.Descriptors.EnumDescriptor getDescriptor() {
      return com.google.cloud.aiplatform.v1beta1.ModelDeploymentMonitoringJob.getDescriptor()
          .getEnumTypes()
          .get(0);
    }

    private static final MonitoringScheduleState[] VALUES = values();

    public static MonitoringScheduleState valueOf(
        com.google.protobuf.Descriptors.EnumValueDescriptor desc) {
      if (desc.getType() != getDescriptor()) {
        throw new java.lang.IllegalArgumentException("EnumValueDescriptor is not for this type.");
      }
      if (desc.getIndex() == -1) {
        return UNRECOGNIZED;
      }
      return VALUES[desc.getIndex()];
    }

    private final int value;

    private MonitoringScheduleState(int value) {
      this.value = value;
    }

    // @@protoc_insertion_point(enum_scope:google.cloud.aiplatform.v1beta1.ModelDeploymentMonitoringJob.MonitoringScheduleState)
  }

  public static final int NAME_FIELD_NUMBER = 1;
  private volatile java.lang.Object name_;
  /**
   *
   *
   * <pre>
   * Output only. Resource name of a ModelDeploymentMonitoringJob.
   * </pre>
   *
   * <code>string name = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
   *
   * @return The name.
   */
  @java.lang.Override
  public java.lang.String getName() {
    java.lang.Object ref = name_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      name_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Output only. Resource name of a ModelDeploymentMonitoringJob.
   * </pre>
   *
   * <code>string name = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
   *
   * @return The bytes for name.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getNameBytes() {
    java.lang.Object ref = name_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      name_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int DISPLAY_NAME_FIELD_NUMBER = 2;
  private volatile java.lang.Object displayName_;
  /**
   *
   *
   * <pre>
   * Required. The user-defined name of the ModelDeploymentMonitoringJob.
   * The name can be up to 128 characters long and can be consist of any UTF-8
   * characters.
   * Display name of a ModelDeploymentMonitoringJob.
   * </pre>
   *
   * <code>string display_name = 2 [(.google.api.field_behavior) = REQUIRED];</code>
   *
   * @return The displayName.
   */
  @java.lang.Override
  public java.lang.String getDisplayName() {
    java.lang.Object ref = displayName_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      displayName_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Required. The user-defined name of the ModelDeploymentMonitoringJob.
   * The name can be up to 128 characters long and can be consist of any UTF-8
   * characters.
   * Display name of a ModelDeploymentMonitoringJob.
   * </pre>
   *
   * <code>string display_name = 2 [(.google.api.field_behavior) = REQUIRED];</code>
   *
   * @return The bytes for displayName.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getDisplayNameBytes() {
    java.lang.Object ref = displayName_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      displayName_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int ENDPOINT_FIELD_NUMBER = 3;
  private volatile java.lang.Object endpoint_;
  /**
   *
   *
   * <pre>
   * Required. Endpoint resource name.
   * Format: `projects/{project}/locations/{location}/endpoints/{endpoint}`
   * </pre>
   *
   * <code>
   * string endpoint = 3 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
   * </code>
   *
   * @return The endpoint.
   */
  @java.lang.Override
  public java.lang.String getEndpoint() {
    java.lang.Object ref = endpoint_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      endpoint_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Required. Endpoint resource name.
   * Format: `projects/{project}/locations/{location}/endpoints/{endpoint}`
   * </pre>
   *
   * <code>
   * string endpoint = 3 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
   * </code>
   *
   * @return The bytes for endpoint.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getEndpointBytes() {
    java.lang.Object ref = endpoint_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      endpoint_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int STATE_FIELD_NUMBER = 4;
  private int state_;
  /**
   *
   *
   * <pre>
   * Output only. The detailed state of the monitoring job.
   * When the job is still creating, the state will be 'PENDING'.
   * Once the job is successfully created, the state will be 'RUNNING'.
   * Pause the job, the state will be 'PAUSED'.
   * Resume the job, the state will return to 'RUNNING'.
   * </pre>
   *
   * <code>
   * .google.cloud.aiplatform.v1beta1.JobState state = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return The enum numeric value on the wire for state.
   */
  @java.lang.Override
  public int getStateValue() {
    return state_;
  }
  /**
   *
   *
   * <pre>
   * Output only. The detailed state of the monitoring job.
   * When the job is still creating, the state will be 'PENDING'.
   * Once the job is successfully created, the state will be 'RUNNING'.
   * Pause the job, the state will be 'PAUSED'.
   * Resume the job, the state will return to 'RUNNING'.
   * </pre>
   *
   * <code>
   * .google.cloud.aiplatform.v1beta1.JobState state = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return The state.
   */
  @java.lang.Override
  public com.google.cloud.aiplatform.v1beta1.JobState getState() {
    @SuppressWarnings("deprecation")
    com.google.cloud.aiplatform.v1beta1.JobState result =
        com.google.cloud.aiplatform.v1beta1.JobState.valueOf(state_);
    return result == null ? com.google.cloud.aiplatform.v1beta1.JobState.UNRECOGNIZED : result;
  }

  public static final int SCHEDULE_STATE_FIELD_NUMBER = 5;
  private int scheduleState_;
  /**
   *
   *
   * <pre>
   * Output only. Schedule state when the monitoring job is in Running state.
   * </pre>
   *
   * <code>
   * .google.cloud.aiplatform.v1beta1.ModelDeploymentMonitoringJob.MonitoringScheduleState schedule_state = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return The enum numeric value on the wire for scheduleState.
   */
  @java.lang.Override
  public int getScheduleStateValue() {
    return scheduleState_;
  }
  /**
   *
   *
   * <pre>
   * Output only. Schedule state when the monitoring job is in Running state.
   * </pre>
   *
   * <code>
   * .google.cloud.aiplatform.v1beta1.ModelDeploymentMonitoringJob.MonitoringScheduleState schedule_state = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return The scheduleState.
   */
  @java.lang.Override
  public com.google.cloud.aiplatform.v1beta1.ModelDeploymentMonitoringJob.MonitoringScheduleState
      getScheduleState() {
    @SuppressWarnings("deprecation")
    com.google.cloud.aiplatform.v1beta1.ModelDeploymentMonitoringJob.MonitoringScheduleState
        result =
            com.google.cloud.aiplatform.v1beta1.ModelDeploymentMonitoringJob.MonitoringScheduleState
                .valueOf(scheduleState_);
    return result == null
        ? com.google.cloud.aiplatform.v1beta1.ModelDeploymentMonitoringJob.MonitoringScheduleState
            .UNRECOGNIZED
        : result;
  }

  public static final int MODEL_DEPLOYMENT_MONITORING_OBJECTIVE_CONFIGS_FIELD_NUMBER = 6;
  private java.util.List<
          com.google.cloud.aiplatform.v1beta1.ModelDeploymentMonitoringObjectiveConfig>
      modelDeploymentMonitoringObjectiveConfigs_;
  /**
   *
   *
   * <pre>
   * Required. The config for monitoring objectives. This is a per DeployedModel config.
   * Each DeployedModel needs to be configured separately.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.aiplatform.v1beta1.ModelDeploymentMonitoringObjectiveConfig model_deployment_monitoring_objective_configs = 6 [(.google.api.field_behavior) = REQUIRED];
   * </code>
   */
  @java.lang.Override
  public java.util.List<
          com.google.cloud.aiplatform.v1beta1.ModelDeploymentMonitoringObjectiveConfig>
      getModelDeploymentMonitoringObjectiveConfigsList() {
    return modelDeploymentMonitoringObjectiveConfigs_;
  }
  /**
   *
   *
   * <pre>
   * Required. The config for monitoring objectives. This is a per DeployedModel config.
   * Each DeployedModel needs to be configured separately.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.aiplatform.v1beta1.ModelDeploymentMonitoringObjectiveConfig model_deployment_monitoring_objective_configs = 6 [(.google.api.field_behavior) = REQUIRED];
   * </code>
   */
  @java.lang.Override
  public java.util.List<
          ? extends
              com.google.cloud.aiplatform.v1beta1.ModelDeploymentMonitoringObjectiveConfigOrBuilder>
      getModelDeploymentMonitoringObjectiveConfigsOrBuilderList() {
    return modelDeploymentMonitoringObjectiveConfigs_;
  }
  /**
   *
   *
   * <pre>
   * Required. The config for monitoring objectives. This is a per DeployedModel config.
   * Each DeployedModel needs to be configured separately.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.aiplatform.v1beta1.ModelDeploymentMonitoringObjectiveConfig model_deployment_monitoring_objective_configs = 6 [(.google.api.field_behavior) = REQUIRED];
   * </code>
   */
  @java.lang.Override
  public int getModelDeploymentMonitoringObjectiveConfigsCount() {
    return modelDeploymentMonitoringObjectiveConfigs_.size();
  }
  /**
   *
   *
   * <pre>
   * Required. The config for monitoring objectives. This is a per DeployedModel config.
   * Each DeployedModel needs to be configured separately.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.aiplatform.v1beta1.ModelDeploymentMonitoringObjectiveConfig model_deployment_monitoring_objective_configs = 6 [(.google.api.field_behavior) = REQUIRED];
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.aiplatform.v1beta1.ModelDeploymentMonitoringObjectiveConfig
      getModelDeploymentMonitoringObjectiveConfigs(int index) {
    return modelDeploymentMonitoringObjectiveConfigs_.get(index);
  }
  /**
   *
   *
   * <pre>
   * Required. The config for monitoring objectives. This is a per DeployedModel config.
   * Each DeployedModel needs to be configured separately.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.aiplatform.v1beta1.ModelDeploymentMonitoringObjectiveConfig model_deployment_monitoring_objective_configs = 6 [(.google.api.field_behavior) = REQUIRED];
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.aiplatform.v1beta1.ModelDeploymentMonitoringObjectiveConfigOrBuilder
      getModelDeploymentMonitoringObjectiveConfigsOrBuilder(int index) {
    return modelDeploymentMonitoringObjectiveConfigs_.get(index);
  }

  public static final int MODEL_DEPLOYMENT_MONITORING_SCHEDULE_CONFIG_FIELD_NUMBER = 7;
  private com.google.cloud.aiplatform.v1beta1.ModelDeploymentMonitoringScheduleConfig
      modelDeploymentMonitoringScheduleConfig_;
  /**
   *
   *
   * <pre>
   * Required. Schedule config for running the monitoring job.
   * </pre>
   *
   * <code>
   * .google.cloud.aiplatform.v1beta1.ModelDeploymentMonitoringScheduleConfig model_deployment_monitoring_schedule_config = 7 [(.google.api.field_behavior) = REQUIRED];
   * </code>
   *
   * @return Whether the modelDeploymentMonitoringScheduleConfig field is set.
   */
  @java.lang.Override
  public boolean hasModelDeploymentMonitoringScheduleConfig() {
    return modelDeploymentMonitoringScheduleConfig_ != null;
  }
  /**
   *
   *
   * <pre>
   * Required. Schedule config for running the monitoring job.
   * </pre>
   *
   * <code>
   * .google.cloud.aiplatform.v1beta1.ModelDeploymentMonitoringScheduleConfig model_deployment_monitoring_schedule_config = 7 [(.google.api.field_behavior) = REQUIRED];
   * </code>
   *
   * @return The modelDeploymentMonitoringScheduleConfig.
   */
  @java.lang.Override
  public com.google.cloud.aiplatform.v1beta1.ModelDeploymentMonitoringScheduleConfig
      getModelDeploymentMonitoringScheduleConfig() {
    return modelDeploymentMonitoringScheduleConfig_ == null
        ? com.google.cloud.aiplatform.v1beta1.ModelDeploymentMonitoringScheduleConfig
            .getDefaultInstance()
        : modelDeploymentMonitoringScheduleConfig_;
  }
  /**
   *
   *
   * <pre>
   * Required. Schedule config for running the monitoring job.
   * </pre>
   *
   * <code>
   * .google.cloud.aiplatform.v1beta1.ModelDeploymentMonitoringScheduleConfig model_deployment_monitoring_schedule_config = 7 [(.google.api.field_behavior) = REQUIRED];
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.aiplatform.v1beta1.ModelDeploymentMonitoringScheduleConfigOrBuilder
      getModelDeploymentMonitoringScheduleConfigOrBuilder() {
    return getModelDeploymentMonitoringScheduleConfig();
  }

  public static final int LOGGING_SAMPLING_STRATEGY_FIELD_NUMBER = 8;
  private com.google.cloud.aiplatform.v1beta1.SamplingStrategy loggingSamplingStrategy_;
  /**
   *
   *
   * <pre>
   * Required. Sample Strategy for logging.
   * </pre>
   *
   * <code>
   * .google.cloud.aiplatform.v1beta1.SamplingStrategy logging_sampling_strategy = 8 [(.google.api.field_behavior) = REQUIRED];
   * </code>
   *
   * @return Whether the loggingSamplingStrategy field is set.
   */
  @java.lang.Override
  public boolean hasLoggingSamplingStrategy() {
    return loggingSamplingStrategy_ != null;
  }
  /**
   *
   *
   * <pre>
   * Required. Sample Strategy for logging.
   * </pre>
   *
   * <code>
   * .google.cloud.aiplatform.v1beta1.SamplingStrategy logging_sampling_strategy = 8 [(.google.api.field_behavior) = REQUIRED];
   * </code>
   *
   * @return The loggingSamplingStrategy.
   */
  @java.lang.Override
  public com.google.cloud.aiplatform.v1beta1.SamplingStrategy getLoggingSamplingStrategy() {
    return loggingSamplingStrategy_ == null
        ? com.google.cloud.aiplatform.v1beta1.SamplingStrategy.getDefaultInstance()
        : loggingSamplingStrategy_;
  }
  /**
   *
   *
   * <pre>
   * Required. Sample Strategy for logging.
   * </pre>
   *
   * <code>
   * .google.cloud.aiplatform.v1beta1.SamplingStrategy logging_sampling_strategy = 8 [(.google.api.field_behavior) = REQUIRED];
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.aiplatform.v1beta1.SamplingStrategyOrBuilder
      getLoggingSamplingStrategyOrBuilder() {
    return getLoggingSamplingStrategy();
  }

  public static final int MODEL_MONITORING_ALERT_CONFIG_FIELD_NUMBER = 15;
  private com.google.cloud.aiplatform.v1beta1.ModelMonitoringAlertConfig
      modelMonitoringAlertConfig_;
  /**
   *
   *
   * <pre>
   * Alert config for model monitoring.
   * </pre>
   *
   * <code>
   * .google.cloud.aiplatform.v1beta1.ModelMonitoringAlertConfig model_monitoring_alert_config = 15;
   * </code>
   *
   * @return Whether the modelMonitoringAlertConfig field is set.
   */
  @java.lang.Override
  public boolean hasModelMonitoringAlertConfig() {
    return modelMonitoringAlertConfig_ != null;
  }
  /**
   *
   *
   * <pre>
   * Alert config for model monitoring.
   * </pre>
   *
   * <code>
   * .google.cloud.aiplatform.v1beta1.ModelMonitoringAlertConfig model_monitoring_alert_config = 15;
   * </code>
   *
   * @return The modelMonitoringAlertConfig.
   */
  @java.lang.Override
  public com.google.cloud.aiplatform.v1beta1.ModelMonitoringAlertConfig
      getModelMonitoringAlertConfig() {
    return modelMonitoringAlertConfig_ == null
        ? com.google.cloud.aiplatform.v1beta1.ModelMonitoringAlertConfig.getDefaultInstance()
        : modelMonitoringAlertConfig_;
  }
  /**
   *
   *
   * <pre>
   * Alert config for model monitoring.
   * </pre>
   *
   * <code>
   * .google.cloud.aiplatform.v1beta1.ModelMonitoringAlertConfig model_monitoring_alert_config = 15;
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.aiplatform.v1beta1.ModelMonitoringAlertConfigOrBuilder
      getModelMonitoringAlertConfigOrBuilder() {
    return getModelMonitoringAlertConfig();
  }

  public static final int PREDICT_INSTANCE_SCHEMA_URI_FIELD_NUMBER = 9;
  private volatile java.lang.Object predictInstanceSchemaUri_;
  /**
   *
   *
   * <pre>
   * YAML schema file uri describing the format of a single instance,
   * which are given to format this Endpoint's prediction (and explanation).
   * If not set, we will generate predict schema from collected predict
   * requests.
   * </pre>
   *
   * <code>string predict_instance_schema_uri = 9;</code>
   *
   * @return The predictInstanceSchemaUri.
   */
  @java.lang.Override
  public java.lang.String getPredictInstanceSchemaUri() {
    java.lang.Object ref = predictInstanceSchemaUri_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      predictInstanceSchemaUri_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * YAML schema file uri describing the format of a single instance,
   * which are given to format this Endpoint's prediction (and explanation).
   * If not set, we will generate predict schema from collected predict
   * requests.
   * </pre>
   *
   * <code>string predict_instance_schema_uri = 9;</code>
   *
   * @return The bytes for predictInstanceSchemaUri.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getPredictInstanceSchemaUriBytes() {
    java.lang.Object ref = predictInstanceSchemaUri_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      predictInstanceSchemaUri_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int SAMPLE_PREDICT_INSTANCE_FIELD_NUMBER = 19;
  private com.google.protobuf.Value samplePredictInstance_;
  /**
   *
   *
   * <pre>
   * Sample Predict instance, same format as [PredictRequest.instances][google.cloud.aiplatform.v1beta1.PredictRequest.instances],
   * this can be set as a replacement of
   * [ModelDeploymentMonitoringJob.predict_instance_schema_uri][google.cloud.aiplatform.v1beta1.ModelDeploymentMonitoringJob.predict_instance_schema_uri]. If not set,
   * we will generate predict schema from collected predict requests.
   * </pre>
   *
   * <code>.google.protobuf.Value sample_predict_instance = 19;</code>
   *
   * @return Whether the samplePredictInstance field is set.
   */
  @java.lang.Override
  public boolean hasSamplePredictInstance() {
    return samplePredictInstance_ != null;
  }
  /**
   *
   *
   * <pre>
   * Sample Predict instance, same format as [PredictRequest.instances][google.cloud.aiplatform.v1beta1.PredictRequest.instances],
   * this can be set as a replacement of
   * [ModelDeploymentMonitoringJob.predict_instance_schema_uri][google.cloud.aiplatform.v1beta1.ModelDeploymentMonitoringJob.predict_instance_schema_uri]. If not set,
   * we will generate predict schema from collected predict requests.
   * </pre>
   *
   * <code>.google.protobuf.Value sample_predict_instance = 19;</code>
   *
   * @return The samplePredictInstance.
   */
  @java.lang.Override
  public com.google.protobuf.Value getSamplePredictInstance() {
    return samplePredictInstance_ == null
        ? com.google.protobuf.Value.getDefaultInstance()
        : samplePredictInstance_;
  }
  /**
   *
   *
   * <pre>
   * Sample Predict instance, same format as [PredictRequest.instances][google.cloud.aiplatform.v1beta1.PredictRequest.instances],
   * this can be set as a replacement of
   * [ModelDeploymentMonitoringJob.predict_instance_schema_uri][google.cloud.aiplatform.v1beta1.ModelDeploymentMonitoringJob.predict_instance_schema_uri]. If not set,
   * we will generate predict schema from collected predict requests.
   * </pre>
   *
   * <code>.google.protobuf.Value sample_predict_instance = 19;</code>
   */
  @java.lang.Override
  public com.google.protobuf.ValueOrBuilder getSamplePredictInstanceOrBuilder() {
    return getSamplePredictInstance();
  }

  public static final int ANALYSIS_INSTANCE_SCHEMA_URI_FIELD_NUMBER = 16;
  private volatile java.lang.Object analysisInstanceSchemaUri_;
  /**
   *
   *
   * <pre>
   * YAML schema file uri describing the format of a single instance that you
   * want Tensorflow Data Validation (TFDV) to analyze.
   * If this field is empty, all the feature data types are inferred from
   * [predict_instance_schema_uri][google.cloud.aiplatform.v1beta1.ModelDeploymentMonitoringJob.predict_instance_schema_uri],
   * meaning that TFDV will use the data in the exact format(data type) as
   * prediction request/response.
   * If there are any data type differences between predict instance and TFDV
   * instance, this field can be used to override the schema.
   * For models trained with Vertex AI, this field must be set as all the
   * fields in predict instance formatted as string.
   * </pre>
   *
   * <code>string analysis_instance_schema_uri = 16;</code>
   *
   * @return The analysisInstanceSchemaUri.
   */
  @java.lang.Override
  public java.lang.String getAnalysisInstanceSchemaUri() {
    java.lang.Object ref = analysisInstanceSchemaUri_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      analysisInstanceSchemaUri_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * YAML schema file uri describing the format of a single instance that you
   * want Tensorflow Data Validation (TFDV) to analyze.
   * If this field is empty, all the feature data types are inferred from
   * [predict_instance_schema_uri][google.cloud.aiplatform.v1beta1.ModelDeploymentMonitoringJob.predict_instance_schema_uri],
   * meaning that TFDV will use the data in the exact format(data type) as
   * prediction request/response.
   * If there are any data type differences between predict instance and TFDV
   * instance, this field can be used to override the schema.
   * For models trained with Vertex AI, this field must be set as all the
   * fields in predict instance formatted as string.
   * </pre>
   *
   * <code>string analysis_instance_schema_uri = 16;</code>
   *
   * @return The bytes for analysisInstanceSchemaUri.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getAnalysisInstanceSchemaUriBytes() {
    java.lang.Object ref = analysisInstanceSchemaUri_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      analysisInstanceSchemaUri_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int BIGQUERY_TABLES_FIELD_NUMBER = 10;
  private java.util.List<com.google.cloud.aiplatform.v1beta1.ModelDeploymentMonitoringBigQueryTable>
      bigqueryTables_;
  /**
   *
   *
   * <pre>
   * Output only. The created bigquery tables for the job under customer project. Customer
   * could do their own query &amp; analysis. There could be 4 log tables in
   * maximum:
   * 1. Training data logging predict request/response
   * 2. Serving data logging predict request/response
   * </pre>
   *
   * <code>
   * repeated .google.cloud.aiplatform.v1beta1.ModelDeploymentMonitoringBigQueryTable bigquery_tables = 10 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   */
  @java.lang.Override
  public java.util.List<com.google.cloud.aiplatform.v1beta1.ModelDeploymentMonitoringBigQueryTable>
      getBigqueryTablesList() {
    return bigqueryTables_;
  }
  /**
   *
   *
   * <pre>
   * Output only. The created bigquery tables for the job under customer project. Customer
   * could do their own query &amp; analysis. There could be 4 log tables in
   * maximum:
   * 1. Training data logging predict request/response
   * 2. Serving data logging predict request/response
   * </pre>
   *
   * <code>
   * repeated .google.cloud.aiplatform.v1beta1.ModelDeploymentMonitoringBigQueryTable bigquery_tables = 10 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   */
  @java.lang.Override
  public java.util.List<
          ? extends
              com.google.cloud.aiplatform.v1beta1.ModelDeploymentMonitoringBigQueryTableOrBuilder>
      getBigqueryTablesOrBuilderList() {
    return bigqueryTables_;
  }
  /**
   *
   *
   * <pre>
   * Output only. The created bigquery tables for the job under customer project. Customer
   * could do their own query &amp; analysis. There could be 4 log tables in
   * maximum:
   * 1. Training data logging predict request/response
   * 2. Serving data logging predict request/response
   * </pre>
   *
   * <code>
   * repeated .google.cloud.aiplatform.v1beta1.ModelDeploymentMonitoringBigQueryTable bigquery_tables = 10 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   */
  @java.lang.Override
  public int getBigqueryTablesCount() {
    return bigqueryTables_.size();
  }
  /**
   *
   *
   * <pre>
   * Output only. The created bigquery tables for the job under customer project. Customer
   * could do their own query &amp; analysis. There could be 4 log tables in
   * maximum:
   * 1. Training data logging predict request/response
   * 2. Serving data logging predict request/response
   * </pre>
   *
   * <code>
   * repeated .google.cloud.aiplatform.v1beta1.ModelDeploymentMonitoringBigQueryTable bigquery_tables = 10 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.aiplatform.v1beta1.ModelDeploymentMonitoringBigQueryTable
      getBigqueryTables(int index) {
    return bigqueryTables_.get(index);
  }
  /**
   *
   *
   * <pre>
   * Output only. The created bigquery tables for the job under customer project. Customer
   * could do their own query &amp; analysis. There could be 4 log tables in
   * maximum:
   * 1. Training data logging predict request/response
   * 2. Serving data logging predict request/response
   * </pre>
   *
   * <code>
   * repeated .google.cloud.aiplatform.v1beta1.ModelDeploymentMonitoringBigQueryTable bigquery_tables = 10 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.aiplatform.v1beta1.ModelDeploymentMonitoringBigQueryTableOrBuilder
      getBigqueryTablesOrBuilder(int index) {
    return bigqueryTables_.get(index);
  }

  public static final int LOG_TTL_FIELD_NUMBER = 17;
  private com.google.protobuf.Duration logTtl_;
  /**
   *
   *
   * <pre>
   * The TTL of BigQuery tables in user projects which stores logs.
   * A day is the basic unit of the TTL and we take the ceil of TTL/86400(a
   * day). e.g. { second: 3600} indicates ttl = 1 day.
   * </pre>
   *
   * <code>.google.protobuf.Duration log_ttl = 17;</code>
   *
   * @return Whether the logTtl field is set.
   */
  @java.lang.Override
  public boolean hasLogTtl() {
    return logTtl_ != null;
  }
  /**
   *
   *
   * <pre>
   * The TTL of BigQuery tables in user projects which stores logs.
   * A day is the basic unit of the TTL and we take the ceil of TTL/86400(a
   * day). e.g. { second: 3600} indicates ttl = 1 day.
   * </pre>
   *
   * <code>.google.protobuf.Duration log_ttl = 17;</code>
   *
   * @return The logTtl.
   */
  @java.lang.Override
  public com.google.protobuf.Duration getLogTtl() {
    return logTtl_ == null ? com.google.protobuf.Duration.getDefaultInstance() : logTtl_;
  }
  /**
   *
   *
   * <pre>
   * The TTL of BigQuery tables in user projects which stores logs.
   * A day is the basic unit of the TTL and we take the ceil of TTL/86400(a
   * day). e.g. { second: 3600} indicates ttl = 1 day.
   * </pre>
   *
   * <code>.google.protobuf.Duration log_ttl = 17;</code>
   */
  @java.lang.Override
  public com.google.protobuf.DurationOrBuilder getLogTtlOrBuilder() {
    return getLogTtl();
  }

  public static final int LABELS_FIELD_NUMBER = 11;

  private static final class LabelsDefaultEntryHolder {
    static final com.google.protobuf.MapEntry<java.lang.String, java.lang.String> defaultEntry =
        com.google.protobuf.MapEntry.<java.lang.String, java.lang.String>newDefaultInstance(
            com.google.cloud.aiplatform.v1beta1.ModelDeploymentMonitoringJobProto
                .internal_static_google_cloud_aiplatform_v1beta1_ModelDeploymentMonitoringJob_LabelsEntry_descriptor,
            com.google.protobuf.WireFormat.FieldType.STRING,
            "",
            com.google.protobuf.WireFormat.FieldType.STRING,
            "");
  }

  private com.google.protobuf.MapField<java.lang.String, java.lang.String> labels_;

  private com.google.protobuf.MapField<java.lang.String, java.lang.String> internalGetLabels() {
    if (labels_ == null) {
      return com.google.protobuf.MapField.emptyMapField(LabelsDefaultEntryHolder.defaultEntry);
    }
    return labels_;
  }

  public int getLabelsCount() {
    return internalGetLabels().getMap().size();
  }
  /**
   *
   *
   * <pre>
   * The labels with user-defined metadata to organize your
   * ModelDeploymentMonitoringJob.
   * Label keys and values can be no longer than 64 characters
   * (Unicode codepoints), can only contain lowercase letters, numeric
   * characters, underscores and dashes. International characters are allowed.
   * See https://goo.gl/xmQnxf for more information and examples of labels.
   * </pre>
   *
   * <code>map&lt;string, string&gt; labels = 11;</code>
   */
  @java.lang.Override
  public boolean containsLabels(java.lang.String key) {
    if (key == null) {
      throw new java.lang.NullPointerException();
    }
    return internalGetLabels().getMap().containsKey(key);
  }
  /** Use {@link #getLabelsMap()} instead. */
  @java.lang.Override
  @java.lang.Deprecated
  public java.util.Map<java.lang.String, java.lang.String> getLabels() {
    return getLabelsMap();
  }
  /**
   *
   *
   * <pre>
   * The labels with user-defined metadata to organize your
   * ModelDeploymentMonitoringJob.
   * Label keys and values can be no longer than 64 characters
   * (Unicode codepoints), can only contain lowercase letters, numeric
   * characters, underscores and dashes. International characters are allowed.
   * See https://goo.gl/xmQnxf for more information and examples of labels.
   * </pre>
   *
   * <code>map&lt;string, string&gt; labels = 11;</code>
   */
  @java.lang.Override
  public java.util.Map<java.lang.String, java.lang.String> getLabelsMap() {
    return internalGetLabels().getMap();
  }
  /**
   *
   *
   * <pre>
   * The labels with user-defined metadata to organize your
   * ModelDeploymentMonitoringJob.
   * Label keys and values can be no longer than 64 characters
   * (Unicode codepoints), can only contain lowercase letters, numeric
   * characters, underscores and dashes. International characters are allowed.
   * See https://goo.gl/xmQnxf for more information and examples of labels.
   * </pre>
   *
   * <code>map&lt;string, string&gt; labels = 11;</code>
   */
  @java.lang.Override
  public java.lang.String getLabelsOrDefault(java.lang.String key, java.lang.String defaultValue) {
    if (key == null) {
      throw new java.lang.NullPointerException();
    }
    java.util.Map<java.lang.String, java.lang.String> map = internalGetLabels().getMap();
    return map.containsKey(key) ? map.get(key) : defaultValue;
  }
  /**
   *
   *
   * <pre>
   * The labels with user-defined metadata to organize your
   * ModelDeploymentMonitoringJob.
   * Label keys and values can be no longer than 64 characters
   * (Unicode codepoints), can only contain lowercase letters, numeric
   * characters, underscores and dashes. International characters are allowed.
   * See https://goo.gl/xmQnxf for more information and examples of labels.
   * </pre>
   *
   * <code>map&lt;string, string&gt; labels = 11;</code>
   */
  @java.lang.Override
  public java.lang.String getLabelsOrThrow(java.lang.String key) {
    if (key == null) {
      throw new java.lang.NullPointerException();
    }
    java.util.Map<java.lang.String, java.lang.String> map = internalGetLabels().getMap();
    if (!map.containsKey(key)) {
      throw new java.lang.IllegalArgumentException();
    }
    return map.get(key);
  }

  public static final int CREATE_TIME_FIELD_NUMBER = 12;
  private com.google.protobuf.Timestamp createTime_;
  /**
   *
   *
   * <pre>
   * Output only. Timestamp when this ModelDeploymentMonitoringJob was created.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp create_time = 12 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return Whether the createTime field is set.
   */
  @java.lang.Override
  public boolean hasCreateTime() {
    return createTime_ != null;
  }
  /**
   *
   *
   * <pre>
   * Output only. Timestamp when this ModelDeploymentMonitoringJob was created.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp create_time = 12 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return The createTime.
   */
  @java.lang.Override
  public com.google.protobuf.Timestamp getCreateTime() {
    return createTime_ == null ? com.google.protobuf.Timestamp.getDefaultInstance() : createTime_;
  }
  /**
   *
   *
   * <pre>
   * Output only. Timestamp when this ModelDeploymentMonitoringJob was created.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp create_time = 12 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   */
  @java.lang.Override
  public com.google.protobuf.TimestampOrBuilder getCreateTimeOrBuilder() {
    return getCreateTime();
  }

  public static final int UPDATE_TIME_FIELD_NUMBER = 13;
  private com.google.protobuf.Timestamp updateTime_;
  /**
   *
   *
   * <pre>
   * Output only. Timestamp when this ModelDeploymentMonitoringJob was updated most recently.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp update_time = 13 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return Whether the updateTime field is set.
   */
  @java.lang.Override
  public boolean hasUpdateTime() {
    return updateTime_ != null;
  }
  /**
   *
   *
   * <pre>
   * Output only. Timestamp when this ModelDeploymentMonitoringJob was updated most recently.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp update_time = 13 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return The updateTime.
   */
  @java.lang.Override
  public com.google.protobuf.Timestamp getUpdateTime() {
    return updateTime_ == null ? com.google.protobuf.Timestamp.getDefaultInstance() : updateTime_;
  }
  /**
   *
   *
   * <pre>
   * Output only. Timestamp when this ModelDeploymentMonitoringJob was updated most recently.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp update_time = 13 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   */
  @java.lang.Override
  public com.google.protobuf.TimestampOrBuilder getUpdateTimeOrBuilder() {
    return getUpdateTime();
  }

  public static final int NEXT_SCHEDULE_TIME_FIELD_NUMBER = 14;
  private com.google.protobuf.Timestamp nextScheduleTime_;
  /**
   *
   *
   * <pre>
   * Output only. Timestamp when this monitoring pipeline will be scheduled to run for the
   * next round.
   * </pre>
   *
   * <code>
   * .google.protobuf.Timestamp next_schedule_time = 14 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return Whether the nextScheduleTime field is set.
   */
  @java.lang.Override
  public boolean hasNextScheduleTime() {
    return nextScheduleTime_ != null;
  }
  /**
   *
   *
   * <pre>
   * Output only. Timestamp when this monitoring pipeline will be scheduled to run for the
   * next round.
   * </pre>
   *
   * <code>
   * .google.protobuf.Timestamp next_schedule_time = 14 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return The nextScheduleTime.
   */
  @java.lang.Override
  public com.google.protobuf.Timestamp getNextScheduleTime() {
    return nextScheduleTime_ == null
        ? com.google.protobuf.Timestamp.getDefaultInstance()
        : nextScheduleTime_;
  }
  /**
   *
   *
   * <pre>
   * Output only. Timestamp when this monitoring pipeline will be scheduled to run for the
   * next round.
   * </pre>
   *
   * <code>
   * .google.protobuf.Timestamp next_schedule_time = 14 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   */
  @java.lang.Override
  public com.google.protobuf.TimestampOrBuilder getNextScheduleTimeOrBuilder() {
    return getNextScheduleTime();
  }

  public static final int STATS_ANOMALIES_BASE_DIRECTORY_FIELD_NUMBER = 20;
  private com.google.cloud.aiplatform.v1beta1.GcsDestination statsAnomaliesBaseDirectory_;
  /**
   *
   *
   * <pre>
   * Stats anomalies base folder path.
   * </pre>
   *
   * <code>.google.cloud.aiplatform.v1beta1.GcsDestination stats_anomalies_base_directory = 20;
   * </code>
   *
   * @return Whether the statsAnomaliesBaseDirectory field is set.
   */
  @java.lang.Override
  public boolean hasStatsAnomaliesBaseDirectory() {
    return statsAnomaliesBaseDirectory_ != null;
  }
  /**
   *
   *
   * <pre>
   * Stats anomalies base folder path.
   * </pre>
   *
   * <code>.google.cloud.aiplatform.v1beta1.GcsDestination stats_anomalies_base_directory = 20;
   * </code>
   *
   * @return The statsAnomaliesBaseDirectory.
   */
  @java.lang.Override
  public com.google.cloud.aiplatform.v1beta1.GcsDestination getStatsAnomaliesBaseDirectory() {
    return statsAnomaliesBaseDirectory_ == null
        ? com.google.cloud.aiplatform.v1beta1.GcsDestination.getDefaultInstance()
        : statsAnomaliesBaseDirectory_;
  }
  /**
   *
   *
   * <pre>
   * Stats anomalies base folder path.
   * </pre>
   *
   * <code>.google.cloud.aiplatform.v1beta1.GcsDestination stats_anomalies_base_directory = 20;
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.aiplatform.v1beta1.GcsDestinationOrBuilder
      getStatsAnomaliesBaseDirectoryOrBuilder() {
    return getStatsAnomaliesBaseDirectory();
  }

  public static final int ENCRYPTION_SPEC_FIELD_NUMBER = 21;
  private com.google.cloud.aiplatform.v1beta1.EncryptionSpec encryptionSpec_;
  /**
   *
   *
   * <pre>
   * Customer-managed encryption key spec for a ModelDeploymentMonitoringJob. If
   * set, this ModelDeploymentMonitoringJob and all sub-resources of this
   * ModelDeploymentMonitoringJob will be secured by this key.
   * </pre>
   *
   * <code>.google.cloud.aiplatform.v1beta1.EncryptionSpec encryption_spec = 21;</code>
   *
   * @return Whether the encryptionSpec field is set.
   */
  @java.lang.Override
  public boolean hasEncryptionSpec() {
    return encryptionSpec_ != null;
  }
  /**
   *
   *
   * <pre>
   * Customer-managed encryption key spec for a ModelDeploymentMonitoringJob. If
   * set, this ModelDeploymentMonitoringJob and all sub-resources of this
   * ModelDeploymentMonitoringJob will be secured by this key.
   * </pre>
   *
   * <code>.google.cloud.aiplatform.v1beta1.EncryptionSpec encryption_spec = 21;</code>
   *
   * @return The encryptionSpec.
   */
  @java.lang.Override
  public com.google.cloud.aiplatform.v1beta1.EncryptionSpec getEncryptionSpec() {
    return encryptionSpec_ == null
        ? com.google.cloud.aiplatform.v1beta1.EncryptionSpec.getDefaultInstance()
        : encryptionSpec_;
  }
  /**
   *
   *
   * <pre>
   * Customer-managed encryption key spec for a ModelDeploymentMonitoringJob. If
   * set, this ModelDeploymentMonitoringJob and all sub-resources of this
   * ModelDeploymentMonitoringJob will be secured by this key.
   * </pre>
   *
   * <code>.google.cloud.aiplatform.v1beta1.EncryptionSpec encryption_spec = 21;</code>
   */
  @java.lang.Override
  public com.google.cloud.aiplatform.v1beta1.EncryptionSpecOrBuilder getEncryptionSpecOrBuilder() {
    return getEncryptionSpec();
  }

  public static final int ERROR_FIELD_NUMBER = 23;
  private com.google.rpc.Status error_;
  /**
   *
   *
   * <pre>
   * Output only. Only populated when the job's state is `JOB_STATE_FAILED` or
   * `JOB_STATE_CANCELLED`.
   * </pre>
   *
   * <code>.google.rpc.Status error = 23 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
   *
   * @return Whether the error field is set.
   */
  @java.lang.Override
  public boolean hasError() {
    return error_ != null;
  }
  /**
   *
   *
   * <pre>
   * Output only. Only populated when the job's state is `JOB_STATE_FAILED` or
   * `JOB_STATE_CANCELLED`.
   * </pre>
   *
   * <code>.google.rpc.Status error = 23 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
   *
   * @return The error.
   */
  @java.lang.Override
  public com.google.rpc.Status getError() {
    return error_ == null ? com.google.rpc.Status.getDefaultInstance() : error_;
  }
  /**
   *
   *
   * <pre>
   * Output only. Only populated when the job's state is `JOB_STATE_FAILED` or
   * `JOB_STATE_CANCELLED`.
   * </pre>
   *
   * <code>.google.rpc.Status error = 23 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
   */
  @java.lang.Override
  public com.google.rpc.StatusOrBuilder getErrorOrBuilder() {
    return getError();
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    if (!getNameBytes().isEmpty()) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 1, name_);
    }
    if (!getDisplayNameBytes().isEmpty()) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 2, displayName_);
    }
    if (!getEndpointBytes().isEmpty()) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 3, endpoint_);
    }
    if (state_ != com.google.cloud.aiplatform.v1beta1.JobState.JOB_STATE_UNSPECIFIED.getNumber()) {
      output.writeEnum(4, state_);
    }
    if (scheduleState_
        != com.google.cloud.aiplatform.v1beta1.ModelDeploymentMonitoringJob.MonitoringScheduleState
            .MONITORING_SCHEDULE_STATE_UNSPECIFIED
            .getNumber()) {
      output.writeEnum(5, scheduleState_);
    }
    for (int i = 0; i < modelDeploymentMonitoringObjectiveConfigs_.size(); i++) {
      output.writeMessage(6, modelDeploymentMonitoringObjectiveConfigs_.get(i));
    }
    if (modelDeploymentMonitoringScheduleConfig_ != null) {
      output.writeMessage(7, getModelDeploymentMonitoringScheduleConfig());
    }
    if (loggingSamplingStrategy_ != null) {
      output.writeMessage(8, getLoggingSamplingStrategy());
    }
    if (!getPredictInstanceSchemaUriBytes().isEmpty()) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 9, predictInstanceSchemaUri_);
    }
    for (int i = 0; i < bigqueryTables_.size(); i++) {
      output.writeMessage(10, bigqueryTables_.get(i));
    }
    com.google.protobuf.GeneratedMessageV3.serializeStringMapTo(
        output, internalGetLabels(), LabelsDefaultEntryHolder.defaultEntry, 11);
    if (createTime_ != null) {
      output.writeMessage(12, getCreateTime());
    }
    if (updateTime_ != null) {
      output.writeMessage(13, getUpdateTime());
    }
    if (nextScheduleTime_ != null) {
      output.writeMessage(14, getNextScheduleTime());
    }
    if (modelMonitoringAlertConfig_ != null) {
      output.writeMessage(15, getModelMonitoringAlertConfig());
    }
    if (!getAnalysisInstanceSchemaUriBytes().isEmpty()) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 16, analysisInstanceSchemaUri_);
    }
    if (logTtl_ != null) {
      output.writeMessage(17, getLogTtl());
    }
    if (samplePredictInstance_ != null) {
      output.writeMessage(19, getSamplePredictInstance());
    }
    if (statsAnomaliesBaseDirectory_ != null) {
      output.writeMessage(20, getStatsAnomaliesBaseDirectory());
    }
    if (encryptionSpec_ != null) {
      output.writeMessage(21, getEncryptionSpec());
    }
    if (error_ != null) {
      output.writeMessage(23, getError());
    }
    unknownFields.writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    if (!getNameBytes().isEmpty()) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(1, name_);
    }
    if (!getDisplayNameBytes().isEmpty()) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(2, displayName_);
    }
    if (!getEndpointBytes().isEmpty()) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(3, endpoint_);
    }
    if (state_ != com.google.cloud.aiplatform.v1beta1.JobState.JOB_STATE_UNSPECIFIED.getNumber()) {
      size += com.google.protobuf.CodedOutputStream.computeEnumSize(4, state_);
    }
    if (scheduleState_
        != com.google.cloud.aiplatform.v1beta1.ModelDeploymentMonitoringJob.MonitoringScheduleState
            .MONITORING_SCHEDULE_STATE_UNSPECIFIED
            .getNumber()) {
      size += com.google.protobuf.CodedOutputStream.computeEnumSize(5, scheduleState_);
    }
    for (int i = 0; i < modelDeploymentMonitoringObjectiveConfigs_.size(); i++) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(
              6, modelDeploymentMonitoringObjectiveConfigs_.get(i));
    }
    if (modelDeploymentMonitoringScheduleConfig_ != null) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(
              7, getModelDeploymentMonitoringScheduleConfig());
    }
    if (loggingSamplingStrategy_ != null) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(8, getLoggingSamplingStrategy());
    }
    if (!getPredictInstanceSchemaUriBytes().isEmpty()) {
      size +=
          com.google.protobuf.GeneratedMessageV3.computeStringSize(9, predictInstanceSchemaUri_);
    }
    for (int i = 0; i < bigqueryTables_.size(); i++) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(10, bigqueryTables_.get(i));
    }
    for (java.util.Map.Entry<java.lang.String, java.lang.String> entry :
        internalGetLabels().getMap().entrySet()) {
      com.google.protobuf.MapEntry<java.lang.String, java.lang.String> labels__ =
          LabelsDefaultEntryHolder.defaultEntry
              .newBuilderForType()
              .setKey(entry.getKey())
              .setValue(entry.getValue())
              .build();
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(11, labels__);
    }
    if (createTime_ != null) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(12, getCreateTime());
    }
    if (updateTime_ != null) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(13, getUpdateTime());
    }
    if (nextScheduleTime_ != null) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(14, getNextScheduleTime());
    }
    if (modelMonitoringAlertConfig_ != null) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(
              15, getModelMonitoringAlertConfig());
    }
    if (!getAnalysisInstanceSchemaUriBytes().isEmpty()) {
      size +=
          com.google.protobuf.GeneratedMessageV3.computeStringSize(16, analysisInstanceSchemaUri_);
    }
    if (logTtl_ != null) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(17, getLogTtl());
    }
    if (samplePredictInstance_ != null) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(19, getSamplePredictInstance());
    }
    if (statsAnomaliesBaseDirectory_ != null) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(
              20, getStatsAnomaliesBaseDirectory());
    }
    if (encryptionSpec_ != null) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(21, getEncryptionSpec());
    }
    if (error_ != null) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(23, getError());
    }
    size += unknownFields.getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.cloud.aiplatform.v1beta1.ModelDeploymentMonitoringJob)) {
      return super.equals(obj);
    }
    com.google.cloud.aiplatform.v1beta1.ModelDeploymentMonitoringJob other =
        (com.google.cloud.aiplatform.v1beta1.ModelDeploymentMonitoringJob) obj;

    if (!getName().equals(other.getName())) return false;
    if (!getDisplayName().equals(other.getDisplayName())) return false;
    if (!getEndpoint().equals(other.getEndpoint())) return false;
    if (state_ != other.state_) return false;
    if (scheduleState_ != other.scheduleState_) return false;
    if (!getModelDeploymentMonitoringObjectiveConfigsList()
        .equals(other.getModelDeploymentMonitoringObjectiveConfigsList())) return false;
    if (hasModelDeploymentMonitoringScheduleConfig()
        != other.hasModelDeploymentMonitoringScheduleConfig()) return false;
    if (hasModelDeploymentMonitoringScheduleConfig()) {
      if (!getModelDeploymentMonitoringScheduleConfig()
          .equals(other.getModelDeploymentMonitoringScheduleConfig())) return false;
    }
    if (hasLoggingSamplingStrategy() != other.hasLoggingSamplingStrategy()) return false;
    if (hasLoggingSamplingStrategy()) {
      if (!getLoggingSamplingStrategy().equals(other.getLoggingSamplingStrategy())) return false;
    }
    if (hasModelMonitoringAlertConfig() != other.hasModelMonitoringAlertConfig()) return false;
    if (hasModelMonitoringAlertConfig()) {
      if (!getModelMonitoringAlertConfig().equals(other.getModelMonitoringAlertConfig()))
        return false;
    }
    if (!getPredictInstanceSchemaUri().equals(other.getPredictInstanceSchemaUri())) return false;
    if (hasSamplePredictInstance() != other.hasSamplePredictInstance()) return false;
    if (hasSamplePredictInstance()) {
      if (!getSamplePredictInstance().equals(other.getSamplePredictInstance())) return false;
    }
    if (!getAnalysisInstanceSchemaUri().equals(other.getAnalysisInstanceSchemaUri())) return false;
    if (!getBigqueryTablesList().equals(other.getBigqueryTablesList())) return false;
    if (hasLogTtl() != other.hasLogTtl()) return false;
    if (hasLogTtl()) {
      if (!getLogTtl().equals(other.getLogTtl())) return false;
    }
    if (!internalGetLabels().equals(other.internalGetLabels())) return false;
    if (hasCreateTime() != other.hasCreateTime()) return false;
    if (hasCreateTime()) {
      if (!getCreateTime().equals(other.getCreateTime())) return false;
    }
    if (hasUpdateTime() != other.hasUpdateTime()) return false;
    if (hasUpdateTime()) {
      if (!getUpdateTime().equals(other.getUpdateTime())) return false;
    }
    if (hasNextScheduleTime() != other.hasNextScheduleTime()) return false;
    if (hasNextScheduleTime()) {
      if (!getNextScheduleTime().equals(other.getNextScheduleTime())) return false;
    }
    if (hasStatsAnomaliesBaseDirectory() != other.hasStatsAnomaliesBaseDirectory()) return false;
    if (hasStatsAnomaliesBaseDirectory()) {
      if (!getStatsAnomaliesBaseDirectory().equals(other.getStatsAnomaliesBaseDirectory()))
        return false;
    }
    if (hasEncryptionSpec() != other.hasEncryptionSpec()) return false;
    if (hasEncryptionSpec()) {
      if (!getEncryptionSpec().equals(other.getEncryptionSpec())) return false;
    }
    if (hasError() != other.hasError()) return false;
    if (hasError()) {
      if (!getError().equals(other.getError())) return false;
    }
    if (!unknownFields.equals(other.unknownFields)) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    hash = (37 * hash) + NAME_FIELD_NUMBER;
    hash = (53 * hash) + getName().hashCode();
    hash = (37 * hash) + DISPLAY_NAME_FIELD_NUMBER;
    hash = (53 * hash) + getDisplayName().hashCode();
    hash = (37 * hash) + ENDPOINT_FIELD_NUMBER;
    hash = (53 * hash) + getEndpoint().hashCode();
    hash = (37 * hash) + STATE_FIELD_NUMBER;
    hash = (53 * hash) + state_;
    hash = (37 * hash) + SCHEDULE_STATE_FIELD_NUMBER;
    hash = (53 * hash) + scheduleState_;
    if (getModelDeploymentMonitoringObjectiveConfigsCount() > 0) {
      hash = (37 * hash) + MODEL_DEPLOYMENT_MONITORING_OBJECTIVE_CONFIGS_FIELD_NUMBER;
      hash = (53 * hash) + getModelDeploymentMonitoringObjectiveConfigsList().hashCode();
    }
    if (hasModelDeploymentMonitoringScheduleConfig()) {
      hash = (37 * hash) + MODEL_DEPLOYMENT_MONITORING_SCHEDULE_CONFIG_FIELD_NUMBER;
      hash = (53 * hash) + getModelDeploymentMonitoringScheduleConfig().hashCode();
    }
    if (hasLoggingSamplingStrategy()) {
      hash = (37 * hash) + LOGGING_SAMPLING_STRATEGY_FIELD_NUMBER;
      hash = (53 * hash) + getLoggingSamplingStrategy().hashCode();
    }
    if (hasModelMonitoringAlertConfig()) {
      hash = (37 * hash) + MODEL_MONITORING_ALERT_CONFIG_FIELD_NUMBER;
      hash = (53 * hash) + getModelMonitoringAlertConfig().hashCode();
    }
    hash = (37 * hash) + PREDICT_INSTANCE_SCHEMA_URI_FIELD_NUMBER;
    hash = (53 * hash) + getPredictInstanceSchemaUri().hashCode();
    if (hasSamplePredictInstance()) {
      hash = (37 * hash) + SAMPLE_PREDICT_INSTANCE_FIELD_NUMBER;
      hash = (53 * hash) + getSamplePredictInstance().hashCode();
    }
    hash = (37 * hash) + ANALYSIS_INSTANCE_SCHEMA_URI_FIELD_NUMBER;
    hash = (53 * hash) + getAnalysisInstanceSchemaUri().hashCode();
    if (getBigqueryTablesCount() > 0) {
      hash = (37 * hash) + BIGQUERY_TABLES_FIELD_NUMBER;
      hash = (53 * hash) + getBigqueryTablesList().hashCode();
    }
    if (hasLogTtl()) {
      hash = (37 * hash) + LOG_TTL_FIELD_NUMBER;
      hash = (53 * hash) + getLogTtl().hashCode();
    }
    if (!internalGetLabels().getMap().isEmpty()) {
      hash = (37 * hash) + LABELS_FIELD_NUMBER;
      hash = (53 * hash) + internalGetLabels().hashCode();
    }
    if (hasCreateTime()) {
      hash = (37 * hash) + CREATE_TIME_FIELD_NUMBER;
      hash = (53 * hash) + getCreateTime().hashCode();
    }
    if (hasUpdateTime()) {
      hash = (37 * hash) + UPDATE_TIME_FIELD_NUMBER;
      hash = (53 * hash) + getUpdateTime().hashCode();
    }
    if (hasNextScheduleTime()) {
      hash = (37 * hash) + NEXT_SCHEDULE_TIME_FIELD_NUMBER;
      hash = (53 * hash) + getNextScheduleTime().hashCode();
    }
    if (hasStatsAnomaliesBaseDirectory()) {
      hash = (37 * hash) + STATS_ANOMALIES_BASE_DIRECTORY_FIELD_NUMBER;
      hash = (53 * hash) + getStatsAnomaliesBaseDirectory().hashCode();
    }
    if (hasEncryptionSpec()) {
      hash = (37 * hash) + ENCRYPTION_SPEC_FIELD_NUMBER;
      hash = (53 * hash) + getEncryptionSpec().hashCode();
    }
    if (hasError()) {
      hash = (37 * hash) + ERROR_FIELD_NUMBER;
      hash = (53 * hash) + getError().hashCode();
    }
    hash = (29 * hash) + unknownFields.hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.cloud.aiplatform.v1beta1.ModelDeploymentMonitoringJob parseFrom(
      java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.aiplatform.v1beta1.ModelDeploymentMonitoringJob parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.aiplatform.v1beta1.ModelDeploymentMonitoringJob parseFrom(
      com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.aiplatform.v1beta1.ModelDeploymentMonitoringJob parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.aiplatform.v1beta1.ModelDeploymentMonitoringJob parseFrom(
      byte[] data) throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.aiplatform.v1beta1.ModelDeploymentMonitoringJob parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.aiplatform.v1beta1.ModelDeploymentMonitoringJob parseFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.aiplatform.v1beta1.ModelDeploymentMonitoringJob parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.aiplatform.v1beta1.ModelDeploymentMonitoringJob parseDelimitedFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.cloud.aiplatform.v1beta1.ModelDeploymentMonitoringJob parseDelimitedFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.aiplatform.v1beta1.ModelDeploymentMonitoringJob parseFrom(
      com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.aiplatform.v1beta1.ModelDeploymentMonitoringJob parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(
      com.google.cloud.aiplatform.v1beta1.ModelDeploymentMonitoringJob prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }
  /**
   *
   *
   * <pre>
   * Represents a job that runs periodically to monitor the deployed models in an
   * endpoint. It will analyze the logged training &amp; prediction data to detect any
   * abnormal behaviors.
   * </pre>
   *
   * Protobuf type {@code google.cloud.aiplatform.v1beta1.ModelDeploymentMonitoringJob}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.cloud.aiplatform.v1beta1.ModelDeploymentMonitoringJob)
      com.google.cloud.aiplatform.v1beta1.ModelDeploymentMonitoringJobOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.aiplatform.v1beta1.ModelDeploymentMonitoringJobProto
          .internal_static_google_cloud_aiplatform_v1beta1_ModelDeploymentMonitoringJob_descriptor;
    }

    @SuppressWarnings({"rawtypes"})
    protected com.google.protobuf.MapField internalGetMapField(int number) {
      switch (number) {
        case 11:
          return internalGetLabels();
        default:
          throw new RuntimeException("Invalid map field number: " + number);
      }
    }

    @SuppressWarnings({"rawtypes"})
    protected com.google.protobuf.MapField internalGetMutableMapField(int number) {
      switch (number) {
        case 11:
          return internalGetMutableLabels();
        default:
          throw new RuntimeException("Invalid map field number: " + number);
      }
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.aiplatform.v1beta1.ModelDeploymentMonitoringJobProto
          .internal_static_google_cloud_aiplatform_v1beta1_ModelDeploymentMonitoringJob_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.aiplatform.v1beta1.ModelDeploymentMonitoringJob.class,
              com.google.cloud.aiplatform.v1beta1.ModelDeploymentMonitoringJob.Builder.class);
    }

    // Construct using com.google.cloud.aiplatform.v1beta1.ModelDeploymentMonitoringJob.newBuilder()
    private Builder() {
      maybeForceBuilderInitialization();
    }

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
      maybeForceBuilderInitialization();
    }

    private void maybeForceBuilderInitialization() {
      if (com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders) {
        getModelDeploymentMonitoringObjectiveConfigsFieldBuilder();
        getBigqueryTablesFieldBuilder();
      }
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      name_ = "";

      displayName_ = "";

      endpoint_ = "";

      state_ = 0;

      scheduleState_ = 0;

      if (modelDeploymentMonitoringObjectiveConfigsBuilder_ == null) {
        modelDeploymentMonitoringObjectiveConfigs_ = java.util.Collections.emptyList();
        bitField0_ = (bitField0_ & ~0x00000001);
      } else {
        modelDeploymentMonitoringObjectiveConfigsBuilder_.clear();
      }
      if (modelDeploymentMonitoringScheduleConfigBuilder_ == null) {
        modelDeploymentMonitoringScheduleConfig_ = null;
      } else {
        modelDeploymentMonitoringScheduleConfig_ = null;
        modelDeploymentMonitoringScheduleConfigBuilder_ = null;
      }
      if (loggingSamplingStrategyBuilder_ == null) {
        loggingSamplingStrategy_ = null;
      } else {
        loggingSamplingStrategy_ = null;
        loggingSamplingStrategyBuilder_ = null;
      }
      if (modelMonitoringAlertConfigBuilder_ == null) {
        modelMonitoringAlertConfig_ = null;
      } else {
        modelMonitoringAlertConfig_ = null;
        modelMonitoringAlertConfigBuilder_ = null;
      }
      predictInstanceSchemaUri_ = "";

      if (samplePredictInstanceBuilder_ == null) {
        samplePredictInstance_ = null;
      } else {
        samplePredictInstance_ = null;
        samplePredictInstanceBuilder_ = null;
      }
      analysisInstanceSchemaUri_ = "";

      if (bigqueryTablesBuilder_ == null) {
        bigqueryTables_ = java.util.Collections.emptyList();
        bitField0_ = (bitField0_ & ~0x00000002);
      } else {
        bigqueryTablesBuilder_.clear();
      }
      if (logTtlBuilder_ == null) {
        logTtl_ = null;
      } else {
        logTtl_ = null;
        logTtlBuilder_ = null;
      }
      internalGetMutableLabels().clear();
      if (createTimeBuilder_ == null) {
        createTime_ = null;
      } else {
        createTime_ = null;
        createTimeBuilder_ = null;
      }
      if (updateTimeBuilder_ == null) {
        updateTime_ = null;
      } else {
        updateTime_ = null;
        updateTimeBuilder_ = null;
      }
      if (nextScheduleTimeBuilder_ == null) {
        nextScheduleTime_ = null;
      } else {
        nextScheduleTime_ = null;
        nextScheduleTimeBuilder_ = null;
      }
      if (statsAnomaliesBaseDirectoryBuilder_ == null) {
        statsAnomaliesBaseDirectory_ = null;
      } else {
        statsAnomaliesBaseDirectory_ = null;
        statsAnomaliesBaseDirectoryBuilder_ = null;
      }
      if (encryptionSpecBuilder_ == null) {
        encryptionSpec_ = null;
      } else {
        encryptionSpec_ = null;
        encryptionSpecBuilder_ = null;
      }
      if (errorBuilder_ == null) {
        error_ = null;
      } else {
        error_ = null;
        errorBuilder_ = null;
      }
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.cloud.aiplatform.v1beta1.ModelDeploymentMonitoringJobProto
          .internal_static_google_cloud_aiplatform_v1beta1_ModelDeploymentMonitoringJob_descriptor;
    }

    @java.lang.Override
    public com.google.cloud.aiplatform.v1beta1.ModelDeploymentMonitoringJob
        getDefaultInstanceForType() {
      return com.google.cloud.aiplatform.v1beta1.ModelDeploymentMonitoringJob.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.cloud.aiplatform.v1beta1.ModelDeploymentMonitoringJob build() {
      com.google.cloud.aiplatform.v1beta1.ModelDeploymentMonitoringJob result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.cloud.aiplatform.v1beta1.ModelDeploymentMonitoringJob buildPartial() {
      com.google.cloud.aiplatform.v1beta1.ModelDeploymentMonitoringJob result =
          new com.google.cloud.aiplatform.v1beta1.ModelDeploymentMonitoringJob(this);
      int from_bitField0_ = bitField0_;
      result.name_ = name_;
      result.displayName_ = displayName_;
      result.endpoint_ = endpoint_;
      result.state_ = state_;
      result.scheduleState_ = scheduleState_;
      if (modelDeploymentMonitoringObjectiveConfigsBuilder_ == null) {
        if (((bitField0_ & 0x00000001) != 0)) {
          modelDeploymentMonitoringObjectiveConfigs_ =
              java.util.Collections.unmodifiableList(modelDeploymentMonitoringObjectiveConfigs_);
          bitField0_ = (bitField0_ & ~0x00000001);
        }
        result.modelDeploymentMonitoringObjectiveConfigs_ =
            modelDeploymentMonitoringObjectiveConfigs_;
      } else {
        result.modelDeploymentMonitoringObjectiveConfigs_ =
            modelDeploymentMonitoringObjectiveConfigsBuilder_.build();
      }
      if (modelDeploymentMonitoringScheduleConfigBuilder_ == null) {
        result.modelDeploymentMonitoringScheduleConfig_ = modelDeploymentMonitoringScheduleConfig_;
      } else {
        result.modelDeploymentMonitoringScheduleConfig_ =
            modelDeploymentMonitoringScheduleConfigBuilder_.build();
      }
      if (loggingSamplingStrategyBuilder_ == null) {
        result.loggingSamplingStrategy_ = loggingSamplingStrategy_;
      } else {
        result.loggingSamplingStrategy_ = loggingSamplingStrategyBuilder_.build();
      }
      if (modelMonitoringAlertConfigBuilder_ == null) {
        result.modelMonitoringAlertConfig_ = modelMonitoringAlertConfig_;
      } else {
        result.modelMonitoringAlertConfig_ = modelMonitoringAlertConfigBuilder_.build();
      }
      result.predictInstanceSchemaUri_ = predictInstanceSchemaUri_;
      if (samplePredictInstanceBuilder_ == null) {
        result.samplePredictInstance_ = samplePredictInstance_;
      } else {
        result.samplePredictInstance_ = samplePredictInstanceBuilder_.build();
      }
      result.analysisInstanceSchemaUri_ = analysisInstanceSchemaUri_;
      if (bigqueryTablesBuilder_ == null) {
        if (((bitField0_ & 0x00000002) != 0)) {
          bigqueryTables_ = java.util.Collections.unmodifiableList(bigqueryTables_);
          bitField0_ = (bitField0_ & ~0x00000002);
        }
        result.bigqueryTables_ = bigqueryTables_;
      } else {
        result.bigqueryTables_ = bigqueryTablesBuilder_.build();
      }
      if (logTtlBuilder_ == null) {
        result.logTtl_ = logTtl_;
      } else {
        result.logTtl_ = logTtlBuilder_.build();
      }
      result.labels_ = internalGetLabels();
      result.labels_.makeImmutable();
      if (createTimeBuilder_ == null) {
        result.createTime_ = createTime_;
      } else {
        result.createTime_ = createTimeBuilder_.build();
      }
      if (updateTimeBuilder_ == null) {
        result.updateTime_ = updateTime_;
      } else {
        result.updateTime_ = updateTimeBuilder_.build();
      }
      if (nextScheduleTimeBuilder_ == null) {
        result.nextScheduleTime_ = nextScheduleTime_;
      } else {
        result.nextScheduleTime_ = nextScheduleTimeBuilder_.build();
      }
      if (statsAnomaliesBaseDirectoryBuilder_ == null) {
        result.statsAnomaliesBaseDirectory_ = statsAnomaliesBaseDirectory_;
      } else {
        result.statsAnomaliesBaseDirectory_ = statsAnomaliesBaseDirectoryBuilder_.build();
      }
      if (encryptionSpecBuilder_ == null) {
        result.encryptionSpec_ = encryptionSpec_;
      } else {
        result.encryptionSpec_ = encryptionSpecBuilder_.build();
      }
      if (errorBuilder_ == null) {
        result.error_ = error_;
      } else {
        result.error_ = errorBuilder_.build();
      }
      onBuilt();
      return result;
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.cloud.aiplatform.v1beta1.ModelDeploymentMonitoringJob) {
        return mergeFrom((com.google.cloud.aiplatform.v1beta1.ModelDeploymentMonitoringJob) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(
        com.google.cloud.aiplatform.v1beta1.ModelDeploymentMonitoringJob other) {
      if (other
          == com.google.cloud.aiplatform.v1beta1.ModelDeploymentMonitoringJob.getDefaultInstance())
        return this;
      if (!other.getName().isEmpty()) {
        name_ = other.name_;
        onChanged();
      }
      if (!other.getDisplayName().isEmpty()) {
        displayName_ = other.displayName_;
        onChanged();
      }
      if (!other.getEndpoint().isEmpty()) {
        endpoint_ = other.endpoint_;
        onChanged();
      }
      if (other.state_ != 0) {
        setStateValue(other.getStateValue());
      }
      if (other.scheduleState_ != 0) {
        setScheduleStateValue(other.getScheduleStateValue());
      }
      if (modelDeploymentMonitoringObjectiveConfigsBuilder_ == null) {
        if (!other.modelDeploymentMonitoringObjectiveConfigs_.isEmpty()) {
          if (modelDeploymentMonitoringObjectiveConfigs_.isEmpty()) {
            modelDeploymentMonitoringObjectiveConfigs_ =
                other.modelDeploymentMonitoringObjectiveConfigs_;
            bitField0_ = (bitField0_ & ~0x00000001);
          } else {
            ensureModelDeploymentMonitoringObjectiveConfigsIsMutable();
            modelDeploymentMonitoringObjectiveConfigs_.addAll(
                other.modelDeploymentMonitoringObjectiveConfigs_);
          }
          onChanged();
        }
      } else {
        if (!other.modelDeploymentMonitoringObjectiveConfigs_.isEmpty()) {
          if (modelDeploymentMonitoringObjectiveConfigsBuilder_.isEmpty()) {
            modelDeploymentMonitoringObjectiveConfigsBuilder_.dispose();
            modelDeploymentMonitoringObjectiveConfigsBuilder_ = null;
            modelDeploymentMonitoringObjectiveConfigs_ =
                other.modelDeploymentMonitoringObjectiveConfigs_;
            bitField0_ = (bitField0_ & ~0x00000001);
            modelDeploymentMonitoringObjectiveConfigsBuilder_ =
                com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders
                    ? getModelDeploymentMonitoringObjectiveConfigsFieldBuilder()
                    : null;
          } else {
            modelDeploymentMonitoringObjectiveConfigsBuilder_.addAllMessages(
                other.modelDeploymentMonitoringObjectiveConfigs_);
          }
        }
      }
      if (other.hasModelDeploymentMonitoringScheduleConfig()) {
        mergeModelDeploymentMonitoringScheduleConfig(
            other.getModelDeploymentMonitoringScheduleConfig());
      }
      if (other.hasLoggingSamplingStrategy()) {
        mergeLoggingSamplingStrategy(other.getLoggingSamplingStrategy());
      }
      if (other.hasModelMonitoringAlertConfig()) {
        mergeModelMonitoringAlertConfig(other.getModelMonitoringAlertConfig());
      }
      if (!other.getPredictInstanceSchemaUri().isEmpty()) {
        predictInstanceSchemaUri_ = other.predictInstanceSchemaUri_;
        onChanged();
      }
      if (other.hasSamplePredictInstance()) {
        mergeSamplePredictInstance(other.getSamplePredictInstance());
      }
      if (!other.getAnalysisInstanceSchemaUri().isEmpty()) {
        analysisInstanceSchemaUri_ = other.analysisInstanceSchemaUri_;
        onChanged();
      }
      if (bigqueryTablesBuilder_ == null) {
        if (!other.bigqueryTables_.isEmpty()) {
          if (bigqueryTables_.isEmpty()) {
            bigqueryTables_ = other.bigqueryTables_;
            bitField0_ = (bitField0_ & ~0x00000002);
          } else {
            ensureBigqueryTablesIsMutable();
            bigqueryTables_.addAll(other.bigqueryTables_);
          }
          onChanged();
        }
      } else {
        if (!other.bigqueryTables_.isEmpty()) {
          if (bigqueryTablesBuilder_.isEmpty()) {
            bigqueryTablesBuilder_.dispose();
            bigqueryTablesBuilder_ = null;
            bigqueryTables_ = other.bigqueryTables_;
            bitField0_ = (bitField0_ & ~0x00000002);
            bigqueryTablesBuilder_ =
                com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders
                    ? getBigqueryTablesFieldBuilder()
                    : null;
          } else {
            bigqueryTablesBuilder_.addAllMessages(other.bigqueryTables_);
          }
        }
      }
      if (other.hasLogTtl()) {
        mergeLogTtl(other.getLogTtl());
      }
      internalGetMutableLabels().mergeFrom(other.internalGetLabels());
      if (other.hasCreateTime()) {
        mergeCreateTime(other.getCreateTime());
      }
      if (other.hasUpdateTime()) {
        mergeUpdateTime(other.getUpdateTime());
      }
      if (other.hasNextScheduleTime()) {
        mergeNextScheduleTime(other.getNextScheduleTime());
      }
      if (other.hasStatsAnomaliesBaseDirectory()) {
        mergeStatsAnomaliesBaseDirectory(other.getStatsAnomaliesBaseDirectory());
      }
      if (other.hasEncryptionSpec()) {
        mergeEncryptionSpec(other.getEncryptionSpec());
      }
      if (other.hasError()) {
        mergeError(other.getError());
      }
      this.mergeUnknownFields(other.unknownFields);
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      com.google.cloud.aiplatform.v1beta1.ModelDeploymentMonitoringJob parsedMessage = null;
      try {
        parsedMessage = PARSER.parsePartialFrom(input, extensionRegistry);
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        parsedMessage =
            (com.google.cloud.aiplatform.v1beta1.ModelDeploymentMonitoringJob)
                e.getUnfinishedMessage();
        throw e.unwrapIOException();
      } finally {
        if (parsedMessage != null) {
          mergeFrom(parsedMessage);
        }
      }
      return this;
    }

    private int bitField0_;

    private java.lang.Object name_ = "";
    /**
     *
     *
     * <pre>
     * Output only. Resource name of a ModelDeploymentMonitoringJob.
     * </pre>
     *
     * <code>string name = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return The name.
     */
    public java.lang.String getName() {
      java.lang.Object ref = name_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        name_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. Resource name of a ModelDeploymentMonitoringJob.
     * </pre>
     *
     * <code>string name = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return The bytes for name.
     */
    public com.google.protobuf.ByteString getNameBytes() {
      java.lang.Object ref = name_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        name_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. Resource name of a ModelDeploymentMonitoringJob.
     * </pre>
     *
     * <code>string name = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @param value The name to set.
     * @return This builder for chaining.
     */
    public Builder setName(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }

      name_ = value;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Resource name of a ModelDeploymentMonitoringJob.
     * </pre>
     *
     * <code>string name = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearName() {

      name_ = getDefaultInstance().getName();
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Resource name of a ModelDeploymentMonitoringJob.
     * </pre>
     *
     * <code>string name = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @param value The bytes for name to set.
     * @return This builder for chaining.
     */
    public Builder setNameBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);

      name_ = value;
      onChanged();
      return this;
    }

    private java.lang.Object displayName_ = "";
    /**
     *
     *
     * <pre>
     * Required. The user-defined name of the ModelDeploymentMonitoringJob.
     * The name can be up to 128 characters long and can be consist of any UTF-8
     * characters.
     * Display name of a ModelDeploymentMonitoringJob.
     * </pre>
     *
     * <code>string display_name = 2 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return The displayName.
     */
    public java.lang.String getDisplayName() {
      java.lang.Object ref = displayName_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        displayName_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Required. The user-defined name of the ModelDeploymentMonitoringJob.
     * The name can be up to 128 characters long and can be consist of any UTF-8
     * characters.
     * Display name of a ModelDeploymentMonitoringJob.
     * </pre>
     *
     * <code>string display_name = 2 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return The bytes for displayName.
     */
    public com.google.protobuf.ByteString getDisplayNameBytes() {
      java.lang.Object ref = displayName_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        displayName_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Required. The user-defined name of the ModelDeploymentMonitoringJob.
     * The name can be up to 128 characters long and can be consist of any UTF-8
     * characters.
     * Display name of a ModelDeploymentMonitoringJob.
     * </pre>
     *
     * <code>string display_name = 2 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @param value The displayName to set.
     * @return This builder for chaining.
     */
    public Builder setDisplayName(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }

      displayName_ = value;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. The user-defined name of the ModelDeploymentMonitoringJob.
     * The name can be up to 128 characters long and can be consist of any UTF-8
     * characters.
     * Display name of a ModelDeploymentMonitoringJob.
     * </pre>
     *
     * <code>string display_name = 2 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearDisplayName() {

      displayName_ = getDefaultInstance().getDisplayName();
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. The user-defined name of the ModelDeploymentMonitoringJob.
     * The name can be up to 128 characters long and can be consist of any UTF-8
     * characters.
     * Display name of a ModelDeploymentMonitoringJob.
     * </pre>
     *
     * <code>string display_name = 2 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @param value The bytes for displayName to set.
     * @return This builder for chaining.
     */
    public Builder setDisplayNameBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);

      displayName_ = value;
      onChanged();
      return this;
    }

    private java.lang.Object endpoint_ = "";
    /**
     *
     *
     * <pre>
     * Required. Endpoint resource name.
     * Format: `projects/{project}/locations/{location}/endpoints/{endpoint}`
     * </pre>
     *
     * <code>
     * string endpoint = 3 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @return The endpoint.
     */
    public java.lang.String getEndpoint() {
      java.lang.Object ref = endpoint_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        endpoint_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Required. Endpoint resource name.
     * Format: `projects/{project}/locations/{location}/endpoints/{endpoint}`
     * </pre>
     *
     * <code>
     * string endpoint = 3 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @return The bytes for endpoint.
     */
    public com.google.protobuf.ByteString getEndpointBytes() {
      java.lang.Object ref = endpoint_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        endpoint_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Required. Endpoint resource name.
     * Format: `projects/{project}/locations/{location}/endpoints/{endpoint}`
     * </pre>
     *
     * <code>
     * string endpoint = 3 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @param value The endpoint to set.
     * @return This builder for chaining.
     */
    public Builder setEndpoint(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }

      endpoint_ = value;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. Endpoint resource name.
     * Format: `projects/{project}/locations/{location}/endpoints/{endpoint}`
     * </pre>
     *
     * <code>
     * string endpoint = 3 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @return This builder for chaining.
     */
    public Builder clearEndpoint() {

      endpoint_ = getDefaultInstance().getEndpoint();
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. Endpoint resource name.
     * Format: `projects/{project}/locations/{location}/endpoints/{endpoint}`
     * </pre>
     *
     * <code>
     * string endpoint = 3 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @param value The bytes for endpoint to set.
     * @return This builder for chaining.
     */
    public Builder setEndpointBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);

      endpoint_ = value;
      onChanged();
      return this;
    }

    private int state_ = 0;
    /**
     *
     *
     * <pre>
     * Output only. The detailed state of the monitoring job.
     * When the job is still creating, the state will be 'PENDING'.
     * Once the job is successfully created, the state will be 'RUNNING'.
     * Pause the job, the state will be 'PAUSED'.
     * Resume the job, the state will return to 'RUNNING'.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.JobState state = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return The enum numeric value on the wire for state.
     */
    @java.lang.Override
    public int getStateValue() {
      return state_;
    }
    /**
     *
     *
     * <pre>
     * Output only. The detailed state of the monitoring job.
     * When the job is still creating, the state will be 'PENDING'.
     * Once the job is successfully created, the state will be 'RUNNING'.
     * Pause the job, the state will be 'PAUSED'.
     * Resume the job, the state will return to 'RUNNING'.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.JobState state = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @param value The enum numeric value on the wire for state to set.
     * @return This builder for chaining.
     */
    public Builder setStateValue(int value) {

      state_ = value;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The detailed state of the monitoring job.
     * When the job is still creating, the state will be 'PENDING'.
     * Once the job is successfully created, the state will be 'RUNNING'.
     * Pause the job, the state will be 'PAUSED'.
     * Resume the job, the state will return to 'RUNNING'.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.JobState state = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return The state.
     */
    @java.lang.Override
    public com.google.cloud.aiplatform.v1beta1.JobState getState() {
      @SuppressWarnings("deprecation")
      com.google.cloud.aiplatform.v1beta1.JobState result =
          com.google.cloud.aiplatform.v1beta1.JobState.valueOf(state_);
      return result == null ? com.google.cloud.aiplatform.v1beta1.JobState.UNRECOGNIZED : result;
    }
    /**
     *
     *
     * <pre>
     * Output only. The detailed state of the monitoring job.
     * When the job is still creating, the state will be 'PENDING'.
     * Once the job is successfully created, the state will be 'RUNNING'.
     * Pause the job, the state will be 'PAUSED'.
     * Resume the job, the state will return to 'RUNNING'.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.JobState state = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @param value The state to set.
     * @return This builder for chaining.
     */
    public Builder setState(com.google.cloud.aiplatform.v1beta1.JobState value) {
      if (value == null) {
        throw new NullPointerException();
      }

      state_ = value.getNumber();
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The detailed state of the monitoring job.
     * When the job is still creating, the state will be 'PENDING'.
     * Once the job is successfully created, the state will be 'RUNNING'.
     * Pause the job, the state will be 'PAUSED'.
     * Resume the job, the state will return to 'RUNNING'.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.JobState state = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return This builder for chaining.
     */
    public Builder clearState() {

      state_ = 0;
      onChanged();
      return this;
    }

    private int scheduleState_ = 0;
    /**
     *
     *
     * <pre>
     * Output only. Schedule state when the monitoring job is in Running state.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.ModelDeploymentMonitoringJob.MonitoringScheduleState schedule_state = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return The enum numeric value on the wire for scheduleState.
     */
    @java.lang.Override
    public int getScheduleStateValue() {
      return scheduleState_;
    }
    /**
     *
     *
     * <pre>
     * Output only. Schedule state when the monitoring job is in Running state.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.ModelDeploymentMonitoringJob.MonitoringScheduleState schedule_state = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @param value The enum numeric value on the wire for scheduleState to set.
     * @return This builder for chaining.
     */
    public Builder setScheduleStateValue(int value) {

      scheduleState_ = value;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Schedule state when the monitoring job is in Running state.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.ModelDeploymentMonitoringJob.MonitoringScheduleState schedule_state = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return The scheduleState.
     */
    @java.lang.Override
    public com.google.cloud.aiplatform.v1beta1.ModelDeploymentMonitoringJob.MonitoringScheduleState
        getScheduleState() {
      @SuppressWarnings("deprecation")
      com.google.cloud.aiplatform.v1beta1.ModelDeploymentMonitoringJob.MonitoringScheduleState
          result =
              com.google.cloud.aiplatform.v1beta1.ModelDeploymentMonitoringJob
                  .MonitoringScheduleState.valueOf(scheduleState_);
      return result == null
          ? com.google.cloud.aiplatform.v1beta1.ModelDeploymentMonitoringJob.MonitoringScheduleState
              .UNRECOGNIZED
          : result;
    }
    /**
     *
     *
     * <pre>
     * Output only. Schedule state when the monitoring job is in Running state.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.ModelDeploymentMonitoringJob.MonitoringScheduleState schedule_state = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @param value The scheduleState to set.
     * @return This builder for chaining.
     */
    public Builder setScheduleState(
        com.google.cloud.aiplatform.v1beta1.ModelDeploymentMonitoringJob.MonitoringScheduleState
            value) {
      if (value == null) {
        throw new NullPointerException();
      }

      scheduleState_ = value.getNumber();
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Schedule state when the monitoring job is in Running state.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.ModelDeploymentMonitoringJob.MonitoringScheduleState schedule_state = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return This builder for chaining.
     */
    public Builder clearScheduleState() {

      scheduleState_ = 0;
      onChanged();
      return this;
    }

    private java.util.List<
            com.google.cloud.aiplatform.v1beta1.ModelDeploymentMonitoringObjectiveConfig>
        modelDeploymentMonitoringObjectiveConfigs_ = java.util.Collections.emptyList();

    private void ensureModelDeploymentMonitoringObjectiveConfigsIsMutable() {
      if (!((bitField0_ & 0x00000001) != 0)) {
        modelDeploymentMonitoringObjectiveConfigs_ =
            new java.util.ArrayList<
                com.google.cloud.aiplatform.v1beta1.ModelDeploymentMonitoringObjectiveConfig>(
                modelDeploymentMonitoringObjectiveConfigs_);
        bitField0_ |= 0x00000001;
      }
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.cloud.aiplatform.v1beta1.ModelDeploymentMonitoringObjectiveConfig,
            com.google.cloud.aiplatform.v1beta1.ModelDeploymentMonitoringObjectiveConfig.Builder,
            com.google.cloud.aiplatform.v1beta1.ModelDeploymentMonitoringObjectiveConfigOrBuilder>
        modelDeploymentMonitoringObjectiveConfigsBuilder_;

    /**
     *
     *
     * <pre>
     * Required. The config for monitoring objectives. This is a per DeployedModel config.
     * Each DeployedModel needs to be configured separately.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.aiplatform.v1beta1.ModelDeploymentMonitoringObjectiveConfig model_deployment_monitoring_objective_configs = 6 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public java.util.List<
            com.google.cloud.aiplatform.v1beta1.ModelDeploymentMonitoringObjectiveConfig>
        getModelDeploymentMonitoringObjectiveConfigsList() {
      if (modelDeploymentMonitoringObjectiveConfigsBuilder_ == null) {
        return java.util.Collections.unmodifiableList(modelDeploymentMonitoringObjectiveConfigs_);
      } else {
        return modelDeploymentMonitoringObjectiveConfigsBuilder_.getMessageList();
      }
    }
    /**
     *
     *
     * <pre>
     * Required. The config for monitoring objectives. This is a per DeployedModel config.
     * Each DeployedModel needs to be configured separately.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.aiplatform.v1beta1.ModelDeploymentMonitoringObjectiveConfig model_deployment_monitoring_objective_configs = 6 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public int getModelDeploymentMonitoringObjectiveConfigsCount() {
      if (modelDeploymentMonitoringObjectiveConfigsBuilder_ == null) {
        return modelDeploymentMonitoringObjectiveConfigs_.size();
      } else {
        return modelDeploymentMonitoringObjectiveConfigsBuilder_.getCount();
      }
    }
    /**
     *
     *
     * <pre>
     * Required. The config for monitoring objectives. This is a per DeployedModel config.
     * Each DeployedModel needs to be configured separately.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.aiplatform.v1beta1.ModelDeploymentMonitoringObjectiveConfig model_deployment_monitoring_objective_configs = 6 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public com.google.cloud.aiplatform.v1beta1.ModelDeploymentMonitoringObjectiveConfig
        getModelDeploymentMonitoringObjectiveConfigs(int index) {
      if (modelDeploymentMonitoringObjectiveConfigsBuilder_ == null) {
        return modelDeploymentMonitoringObjectiveConfigs_.get(index);
      } else {
        return modelDeploymentMonitoringObjectiveConfigsBuilder_.getMessage(index);
      }
    }
    /**
     *
     *
     * <pre>
     * Required. The config for monitoring objectives. This is a per DeployedModel config.
     * Each DeployedModel needs to be configured separately.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.aiplatform.v1beta1.ModelDeploymentMonitoringObjectiveConfig model_deployment_monitoring_objective_configs = 6 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public Builder setModelDeploymentMonitoringObjectiveConfigs(
        int index,
        com.google.cloud.aiplatform.v1beta1.ModelDeploymentMonitoringObjectiveConfig value) {
      if (modelDeploymentMonitoringObjectiveConfigsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureModelDeploymentMonitoringObjectiveConfigsIsMutable();
        modelDeploymentMonitoringObjectiveConfigs_.set(index, value);
        onChanged();
      } else {
        modelDeploymentMonitoringObjectiveConfigsBuilder_.setMessage(index, value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. The config for monitoring objectives. This is a per DeployedModel config.
     * Each DeployedModel needs to be configured separately.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.aiplatform.v1beta1.ModelDeploymentMonitoringObjectiveConfig model_deployment_monitoring_objective_configs = 6 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public Builder setModelDeploymentMonitoringObjectiveConfigs(
        int index,
        com.google.cloud.aiplatform.v1beta1.ModelDeploymentMonitoringObjectiveConfig.Builder
            builderForValue) {
      if (modelDeploymentMonitoringObjectiveConfigsBuilder_ == null) {
        ensureModelDeploymentMonitoringObjectiveConfigsIsMutable();
        modelDeploymentMonitoringObjectiveConfigs_.set(index, builderForValue.build());
        onChanged();
      } else {
        modelDeploymentMonitoringObjectiveConfigsBuilder_.setMessage(
            index, builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. The config for monitoring objectives. This is a per DeployedModel config.
     * Each DeployedModel needs to be configured separately.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.aiplatform.v1beta1.ModelDeploymentMonitoringObjectiveConfig model_deployment_monitoring_objective_configs = 6 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public Builder addModelDeploymentMonitoringObjectiveConfigs(
        com.google.cloud.aiplatform.v1beta1.ModelDeploymentMonitoringObjectiveConfig value) {
      if (modelDeploymentMonitoringObjectiveConfigsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureModelDeploymentMonitoringObjectiveConfigsIsMutable();
        modelDeploymentMonitoringObjectiveConfigs_.add(value);
        onChanged();
      } else {
        modelDeploymentMonitoringObjectiveConfigsBuilder_.addMessage(value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. The config for monitoring objectives. This is a per DeployedModel config.
     * Each DeployedModel needs to be configured separately.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.aiplatform.v1beta1.ModelDeploymentMonitoringObjectiveConfig model_deployment_monitoring_objective_configs = 6 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public Builder addModelDeploymentMonitoringObjectiveConfigs(
        int index,
        com.google.cloud.aiplatform.v1beta1.ModelDeploymentMonitoringObjectiveConfig value) {
      if (modelDeploymentMonitoringObjectiveConfigsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureModelDeploymentMonitoringObjectiveConfigsIsMutable();
        modelDeploymentMonitoringObjectiveConfigs_.add(index, value);
        onChanged();
      } else {
        modelDeploymentMonitoringObjectiveConfigsBuilder_.addMessage(index, value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. The config for monitoring objectives. This is a per DeployedModel config.
     * Each DeployedModel needs to be configured separately.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.aiplatform.v1beta1.ModelDeploymentMonitoringObjectiveConfig model_deployment_monitoring_objective_configs = 6 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public Builder addModelDeploymentMonitoringObjectiveConfigs(
        com.google.cloud.aiplatform.v1beta1.ModelDeploymentMonitoringObjectiveConfig.Builder
            builderForValue) {
      if (modelDeploymentMonitoringObjectiveConfigsBuilder_ == null) {
        ensureModelDeploymentMonitoringObjectiveConfigsIsMutable();
        modelDeploymentMonitoringObjectiveConfigs_.add(builderForValue.build());
        onChanged();
      } else {
        modelDeploymentMonitoringObjectiveConfigsBuilder_.addMessage(builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. The config for monitoring objectives. This is a per DeployedModel config.
     * Each DeployedModel needs to be configured separately.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.aiplatform.v1beta1.ModelDeploymentMonitoringObjectiveConfig model_deployment_monitoring_objective_configs = 6 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public Builder addModelDeploymentMonitoringObjectiveConfigs(
        int index,
        com.google.cloud.aiplatform.v1beta1.ModelDeploymentMonitoringObjectiveConfig.Builder
            builderForValue) {
      if (modelDeploymentMonitoringObjectiveConfigsBuilder_ == null) {
        ensureModelDeploymentMonitoringObjectiveConfigsIsMutable();
        modelDeploymentMonitoringObjectiveConfigs_.add(index, builderForValue.build());
        onChanged();
      } else {
        modelDeploymentMonitoringObjectiveConfigsBuilder_.addMessage(
            index, builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. The config for monitoring objectives. This is a per DeployedModel config.
     * Each DeployedModel needs to be configured separately.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.aiplatform.v1beta1.ModelDeploymentMonitoringObjectiveConfig model_deployment_monitoring_objective_configs = 6 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public Builder addAllModelDeploymentMonitoringObjectiveConfigs(
        java.lang.Iterable<
                ? extends
                    com.google.cloud.aiplatform.v1beta1.ModelDeploymentMonitoringObjectiveConfig>
            values) {
      if (modelDeploymentMonitoringObjectiveConfigsBuilder_ == null) {
        ensureModelDeploymentMonitoringObjectiveConfigsIsMutable();
        com.google.protobuf.AbstractMessageLite.Builder.addAll(
            values, modelDeploymentMonitoringObjectiveConfigs_);
        onChanged();
      } else {
        modelDeploymentMonitoringObjectiveConfigsBuilder_.addAllMessages(values);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. The config for monitoring objectives. This is a per DeployedModel config.
     * Each DeployedModel needs to be configured separately.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.aiplatform.v1beta1.ModelDeploymentMonitoringObjectiveConfig model_deployment_monitoring_objective_configs = 6 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public Builder clearModelDeploymentMonitoringObjectiveConfigs() {
      if (modelDeploymentMonitoringObjectiveConfigsBuilder_ == null) {
        modelDeploymentMonitoringObjectiveConfigs_ = java.util.Collections.emptyList();
        bitField0_ = (bitField0_ & ~0x00000001);
        onChanged();
      } else {
        modelDeploymentMonitoringObjectiveConfigsBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. The config for monitoring objectives. This is a per DeployedModel config.
     * Each DeployedModel needs to be configured separately.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.aiplatform.v1beta1.ModelDeploymentMonitoringObjectiveConfig model_deployment_monitoring_objective_configs = 6 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public Builder removeModelDeploymentMonitoringObjectiveConfigs(int index) {
      if (modelDeploymentMonitoringObjectiveConfigsBuilder_ == null) {
        ensureModelDeploymentMonitoringObjectiveConfigsIsMutable();
        modelDeploymentMonitoringObjectiveConfigs_.remove(index);
        onChanged();
      } else {
        modelDeploymentMonitoringObjectiveConfigsBuilder_.remove(index);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. The config for monitoring objectives. This is a per DeployedModel config.
     * Each DeployedModel needs to be configured separately.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.aiplatform.v1beta1.ModelDeploymentMonitoringObjectiveConfig model_deployment_monitoring_objective_configs = 6 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public com.google.cloud.aiplatform.v1beta1.ModelDeploymentMonitoringObjectiveConfig.Builder
        getModelDeploymentMonitoringObjectiveConfigsBuilder(int index) {
      return getModelDeploymentMonitoringObjectiveConfigsFieldBuilder().getBuilder(index);
    }
    /**
     *
     *
     * <pre>
     * Required. The config for monitoring objectives. This is a per DeployedModel config.
     * Each DeployedModel needs to be configured separately.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.aiplatform.v1beta1.ModelDeploymentMonitoringObjectiveConfig model_deployment_monitoring_objective_configs = 6 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public com.google.cloud.aiplatform.v1beta1.ModelDeploymentMonitoringObjectiveConfigOrBuilder
        getModelDeploymentMonitoringObjectiveConfigsOrBuilder(int index) {
      if (modelDeploymentMonitoringObjectiveConfigsBuilder_ == null) {
        return modelDeploymentMonitoringObjectiveConfigs_.get(index);
      } else {
        return modelDeploymentMonitoringObjectiveConfigsBuilder_.getMessageOrBuilder(index);
      }
    }
    /**
     *
     *
     * <pre>
     * Required. The config for monitoring objectives. This is a per DeployedModel config.
     * Each DeployedModel needs to be configured separately.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.aiplatform.v1beta1.ModelDeploymentMonitoringObjectiveConfig model_deployment_monitoring_objective_configs = 6 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public java.util.List<
            ? extends
                com.google.cloud.aiplatform.v1beta1
                    .ModelDeploymentMonitoringObjectiveConfigOrBuilder>
        getModelDeploymentMonitoringObjectiveConfigsOrBuilderList() {
      if (modelDeploymentMonitoringObjectiveConfigsBuilder_ != null) {
        return modelDeploymentMonitoringObjectiveConfigsBuilder_.getMessageOrBuilderList();
      } else {
        return java.util.Collections.unmodifiableList(modelDeploymentMonitoringObjectiveConfigs_);
      }
    }
    /**
     *
     *
     * <pre>
     * Required. The config for monitoring objectives. This is a per DeployedModel config.
     * Each DeployedModel needs to be configured separately.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.aiplatform.v1beta1.ModelDeploymentMonitoringObjectiveConfig model_deployment_monitoring_objective_configs = 6 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public com.google.cloud.aiplatform.v1beta1.ModelDeploymentMonitoringObjectiveConfig.Builder
        addModelDeploymentMonitoringObjectiveConfigsBuilder() {
      return getModelDeploymentMonitoringObjectiveConfigsFieldBuilder()
          .addBuilder(
              com.google.cloud.aiplatform.v1beta1.ModelDeploymentMonitoringObjectiveConfig
                  .getDefaultInstance());
    }
    /**
     *
     *
     * <pre>
     * Required. The config for monitoring objectives. This is a per DeployedModel config.
     * Each DeployedModel needs to be configured separately.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.aiplatform.v1beta1.ModelDeploymentMonitoringObjectiveConfig model_deployment_monitoring_objective_configs = 6 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public com.google.cloud.aiplatform.v1beta1.ModelDeploymentMonitoringObjectiveConfig.Builder
        addModelDeploymentMonitoringObjectiveConfigsBuilder(int index) {
      return getModelDeploymentMonitoringObjectiveConfigsFieldBuilder()
          .addBuilder(
              index,
              com.google.cloud.aiplatform.v1beta1.ModelDeploymentMonitoringObjectiveConfig
                  .getDefaultInstance());
    }
    /**
     *
     *
     * <pre>
     * Required. The config for monitoring objectives. This is a per DeployedModel config.
     * Each DeployedModel needs to be configured separately.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.aiplatform.v1beta1.ModelDeploymentMonitoringObjectiveConfig model_deployment_monitoring_objective_configs = 6 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public java.util.List<
            com.google.cloud.aiplatform.v1beta1.ModelDeploymentMonitoringObjectiveConfig.Builder>
        getModelDeploymentMonitoringObjectiveConfigsBuilderList() {
      return getModelDeploymentMonitoringObjectiveConfigsFieldBuilder().getBuilderList();
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.cloud.aiplatform.v1beta1.ModelDeploymentMonitoringObjectiveConfig,
            com.google.cloud.aiplatform.v1beta1.ModelDeploymentMonitoringObjectiveConfig.Builder,
            com.google.cloud.aiplatform.v1beta1.ModelDeploymentMonitoringObjectiveConfigOrBuilder>
        getModelDeploymentMonitoringObjectiveConfigsFieldBuilder() {
      if (modelDeploymentMonitoringObjectiveConfigsBuilder_ == null) {
        modelDeploymentMonitoringObjectiveConfigsBuilder_ =
            new com.google.protobuf.RepeatedFieldBuilderV3<
                com.google.cloud.aiplatform.v1beta1.ModelDeploymentMonitoringObjectiveConfig,
                com.google.cloud.aiplatform.v1beta1.ModelDeploymentMonitoringObjectiveConfig
                    .Builder,
                com.google.cloud.aiplatform.v1beta1
                    .ModelDeploymentMonitoringObjectiveConfigOrBuilder>(
                modelDeploymentMonitoringObjectiveConfigs_,
                ((bitField0_ & 0x00000001) != 0),
                getParentForChildren(),
                isClean());
        modelDeploymentMonitoringObjectiveConfigs_ = null;
      }
      return modelDeploymentMonitoringObjectiveConfigsBuilder_;
    }

    private com.google.cloud.aiplatform.v1beta1.ModelDeploymentMonitoringScheduleConfig
        modelDeploymentMonitoringScheduleConfig_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.aiplatform.v1beta1.ModelDeploymentMonitoringScheduleConfig,
            com.google.cloud.aiplatform.v1beta1.ModelDeploymentMonitoringScheduleConfig.Builder,
            com.google.cloud.aiplatform.v1beta1.ModelDeploymentMonitoringScheduleConfigOrBuilder>
        modelDeploymentMonitoringScheduleConfigBuilder_;
    /**
     *
     *
     * <pre>
     * Required. Schedule config for running the monitoring job.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.ModelDeploymentMonitoringScheduleConfig model_deployment_monitoring_schedule_config = 7 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     *
     * @return Whether the modelDeploymentMonitoringScheduleConfig field is set.
     */
    public boolean hasModelDeploymentMonitoringScheduleConfig() {
      return modelDeploymentMonitoringScheduleConfigBuilder_ != null
          || modelDeploymentMonitoringScheduleConfig_ != null;
    }
    /**
     *
     *
     * <pre>
     * Required. Schedule config for running the monitoring job.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.ModelDeploymentMonitoringScheduleConfig model_deployment_monitoring_schedule_config = 7 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     *
     * @return The modelDeploymentMonitoringScheduleConfig.
     */
    public com.google.cloud.aiplatform.v1beta1.ModelDeploymentMonitoringScheduleConfig
        getModelDeploymentMonitoringScheduleConfig() {
      if (modelDeploymentMonitoringScheduleConfigBuilder_ == null) {
        return modelDeploymentMonitoringScheduleConfig_ == null
            ? com.google.cloud.aiplatform.v1beta1.ModelDeploymentMonitoringScheduleConfig
                .getDefaultInstance()
            : modelDeploymentMonitoringScheduleConfig_;
      } else {
        return modelDeploymentMonitoringScheduleConfigBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Required. Schedule config for running the monitoring job.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.ModelDeploymentMonitoringScheduleConfig model_deployment_monitoring_schedule_config = 7 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public Builder setModelDeploymentMonitoringScheduleConfig(
        com.google.cloud.aiplatform.v1beta1.ModelDeploymentMonitoringScheduleConfig value) {
      if (modelDeploymentMonitoringScheduleConfigBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        modelDeploymentMonitoringScheduleConfig_ = value;
        onChanged();
      } else {
        modelDeploymentMonitoringScheduleConfigBuilder_.setMessage(value);
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. Schedule config for running the monitoring job.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.ModelDeploymentMonitoringScheduleConfig model_deployment_monitoring_schedule_config = 7 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public Builder setModelDeploymentMonitoringScheduleConfig(
        com.google.cloud.aiplatform.v1beta1.ModelDeploymentMonitoringScheduleConfig.Builder
            builderForValue) {
      if (modelDeploymentMonitoringScheduleConfigBuilder_ == null) {
        modelDeploymentMonitoringScheduleConfig_ = builderForValue.build();
        onChanged();
      } else {
        modelDeploymentMonitoringScheduleConfigBuilder_.setMessage(builderForValue.build());
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. Schedule config for running the monitoring job.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.ModelDeploymentMonitoringScheduleConfig model_deployment_monitoring_schedule_config = 7 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public Builder mergeModelDeploymentMonitoringScheduleConfig(
        com.google.cloud.aiplatform.v1beta1.ModelDeploymentMonitoringScheduleConfig value) {
      if (modelDeploymentMonitoringScheduleConfigBuilder_ == null) {
        if (modelDeploymentMonitoringScheduleConfig_ != null) {
          modelDeploymentMonitoringScheduleConfig_ =
              com.google.cloud.aiplatform.v1beta1.ModelDeploymentMonitoringScheduleConfig
                  .newBuilder(modelDeploymentMonitoringScheduleConfig_)
                  .mergeFrom(value)
                  .buildPartial();
        } else {
          modelDeploymentMonitoringScheduleConfig_ = value;
        }
        onChanged();
      } else {
        modelDeploymentMonitoringScheduleConfigBuilder_.mergeFrom(value);
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. Schedule config for running the monitoring job.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.ModelDeploymentMonitoringScheduleConfig model_deployment_monitoring_schedule_config = 7 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public Builder clearModelDeploymentMonitoringScheduleConfig() {
      if (modelDeploymentMonitoringScheduleConfigBuilder_ == null) {
        modelDeploymentMonitoringScheduleConfig_ = null;
        onChanged();
      } else {
        modelDeploymentMonitoringScheduleConfig_ = null;
        modelDeploymentMonitoringScheduleConfigBuilder_ = null;
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. Schedule config for running the monitoring job.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.ModelDeploymentMonitoringScheduleConfig model_deployment_monitoring_schedule_config = 7 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public com.google.cloud.aiplatform.v1beta1.ModelDeploymentMonitoringScheduleConfig.Builder
        getModelDeploymentMonitoringScheduleConfigBuilder() {

      onChanged();
      return getModelDeploymentMonitoringScheduleConfigFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Required. Schedule config for running the monitoring job.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.ModelDeploymentMonitoringScheduleConfig model_deployment_monitoring_schedule_config = 7 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public com.google.cloud.aiplatform.v1beta1.ModelDeploymentMonitoringScheduleConfigOrBuilder
        getModelDeploymentMonitoringScheduleConfigOrBuilder() {
      if (modelDeploymentMonitoringScheduleConfigBuilder_ != null) {
        return modelDeploymentMonitoringScheduleConfigBuilder_.getMessageOrBuilder();
      } else {
        return modelDeploymentMonitoringScheduleConfig_ == null
            ? com.google.cloud.aiplatform.v1beta1.ModelDeploymentMonitoringScheduleConfig
                .getDefaultInstance()
            : modelDeploymentMonitoringScheduleConfig_;
      }
    }
    /**
     *
     *
     * <pre>
     * Required. Schedule config for running the monitoring job.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.ModelDeploymentMonitoringScheduleConfig model_deployment_monitoring_schedule_config = 7 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.aiplatform.v1beta1.ModelDeploymentMonitoringScheduleConfig,
            com.google.cloud.aiplatform.v1beta1.ModelDeploymentMonitoringScheduleConfig.Builder,
            com.google.cloud.aiplatform.v1beta1.ModelDeploymentMonitoringScheduleConfigOrBuilder>
        getModelDeploymentMonitoringScheduleConfigFieldBuilder() {
      if (modelDeploymentMonitoringScheduleConfigBuilder_ == null) {
        modelDeploymentMonitoringScheduleConfigBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.aiplatform.v1beta1.ModelDeploymentMonitoringScheduleConfig,
                com.google.cloud.aiplatform.v1beta1.ModelDeploymentMonitoringScheduleConfig.Builder,
                com.google.cloud.aiplatform.v1beta1
                    .ModelDeploymentMonitoringScheduleConfigOrBuilder>(
                getModelDeploymentMonitoringScheduleConfig(), getParentForChildren(), isClean());
        modelDeploymentMonitoringScheduleConfig_ = null;
      }
      return modelDeploymentMonitoringScheduleConfigBuilder_;
    }

    private com.google.cloud.aiplatform.v1beta1.SamplingStrategy loggingSamplingStrategy_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.aiplatform.v1beta1.SamplingStrategy,
            com.google.cloud.aiplatform.v1beta1.SamplingStrategy.Builder,
            com.google.cloud.aiplatform.v1beta1.SamplingStrategyOrBuilder>
        loggingSamplingStrategyBuilder_;
    /**
     *
     *
     * <pre>
     * Required. Sample Strategy for logging.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.SamplingStrategy logging_sampling_strategy = 8 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     *
     * @return Whether the loggingSamplingStrategy field is set.
     */
    public boolean hasLoggingSamplingStrategy() {
      return loggingSamplingStrategyBuilder_ != null || loggingSamplingStrategy_ != null;
    }
    /**
     *
     *
     * <pre>
     * Required. Sample Strategy for logging.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.SamplingStrategy logging_sampling_strategy = 8 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     *
     * @return The loggingSamplingStrategy.
     */
    public com.google.cloud.aiplatform.v1beta1.SamplingStrategy getLoggingSamplingStrategy() {
      if (loggingSamplingStrategyBuilder_ == null) {
        return loggingSamplingStrategy_ == null
            ? com.google.cloud.aiplatform.v1beta1.SamplingStrategy.getDefaultInstance()
            : loggingSamplingStrategy_;
      } else {
        return loggingSamplingStrategyBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Required. Sample Strategy for logging.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.SamplingStrategy logging_sampling_strategy = 8 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public Builder setLoggingSamplingStrategy(
        com.google.cloud.aiplatform.v1beta1.SamplingStrategy value) {
      if (loggingSamplingStrategyBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        loggingSamplingStrategy_ = value;
        onChanged();
      } else {
        loggingSamplingStrategyBuilder_.setMessage(value);
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. Sample Strategy for logging.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.SamplingStrategy logging_sampling_strategy = 8 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public Builder setLoggingSamplingStrategy(
        com.google.cloud.aiplatform.v1beta1.SamplingStrategy.Builder builderForValue) {
      if (loggingSamplingStrategyBuilder_ == null) {
        loggingSamplingStrategy_ = builderForValue.build();
        onChanged();
      } else {
        loggingSamplingStrategyBuilder_.setMessage(builderForValue.build());
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. Sample Strategy for logging.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.SamplingStrategy logging_sampling_strategy = 8 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public Builder mergeLoggingSamplingStrategy(
        com.google.cloud.aiplatform.v1beta1.SamplingStrategy value) {
      if (loggingSamplingStrategyBuilder_ == null) {
        if (loggingSamplingStrategy_ != null) {
          loggingSamplingStrategy_ =
              com.google.cloud.aiplatform.v1beta1.SamplingStrategy.newBuilder(
                      loggingSamplingStrategy_)
                  .mergeFrom(value)
                  .buildPartial();
        } else {
          loggingSamplingStrategy_ = value;
        }
        onChanged();
      } else {
        loggingSamplingStrategyBuilder_.mergeFrom(value);
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. Sample Strategy for logging.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.SamplingStrategy logging_sampling_strategy = 8 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public Builder clearLoggingSamplingStrategy() {
      if (loggingSamplingStrategyBuilder_ == null) {
        loggingSamplingStrategy_ = null;
        onChanged();
      } else {
        loggingSamplingStrategy_ = null;
        loggingSamplingStrategyBuilder_ = null;
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. Sample Strategy for logging.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.SamplingStrategy logging_sampling_strategy = 8 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public com.google.cloud.aiplatform.v1beta1.SamplingStrategy.Builder
        getLoggingSamplingStrategyBuilder() {

      onChanged();
      return getLoggingSamplingStrategyFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Required. Sample Strategy for logging.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.SamplingStrategy logging_sampling_strategy = 8 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public com.google.cloud.aiplatform.v1beta1.SamplingStrategyOrBuilder
        getLoggingSamplingStrategyOrBuilder() {
      if (loggingSamplingStrategyBuilder_ != null) {
        return loggingSamplingStrategyBuilder_.getMessageOrBuilder();
      } else {
        return loggingSamplingStrategy_ == null
            ? com.google.cloud.aiplatform.v1beta1.SamplingStrategy.getDefaultInstance()
            : loggingSamplingStrategy_;
      }
    }
    /**
     *
     *
     * <pre>
     * Required. Sample Strategy for logging.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.SamplingStrategy logging_sampling_strategy = 8 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.aiplatform.v1beta1.SamplingStrategy,
            com.google.cloud.aiplatform.v1beta1.SamplingStrategy.Builder,
            com.google.cloud.aiplatform.v1beta1.SamplingStrategyOrBuilder>
        getLoggingSamplingStrategyFieldBuilder() {
      if (loggingSamplingStrategyBuilder_ == null) {
        loggingSamplingStrategyBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.aiplatform.v1beta1.SamplingStrategy,
                com.google.cloud.aiplatform.v1beta1.SamplingStrategy.Builder,
                com.google.cloud.aiplatform.v1beta1.SamplingStrategyOrBuilder>(
                getLoggingSamplingStrategy(), getParentForChildren(), isClean());
        loggingSamplingStrategy_ = null;
      }
      return loggingSamplingStrategyBuilder_;
    }

    private com.google.cloud.aiplatform.v1beta1.ModelMonitoringAlertConfig
        modelMonitoringAlertConfig_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.aiplatform.v1beta1.ModelMonitoringAlertConfig,
            com.google.cloud.aiplatform.v1beta1.ModelMonitoringAlertConfig.Builder,
            com.google.cloud.aiplatform.v1beta1.ModelMonitoringAlertConfigOrBuilder>
        modelMonitoringAlertConfigBuilder_;
    /**
     *
     *
     * <pre>
     * Alert config for model monitoring.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.ModelMonitoringAlertConfig model_monitoring_alert_config = 15;
     * </code>
     *
     * @return Whether the modelMonitoringAlertConfig field is set.
     */
    public boolean hasModelMonitoringAlertConfig() {
      return modelMonitoringAlertConfigBuilder_ != null || modelMonitoringAlertConfig_ != null;
    }
    /**
     *
     *
     * <pre>
     * Alert config for model monitoring.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.ModelMonitoringAlertConfig model_monitoring_alert_config = 15;
     * </code>
     *
     * @return The modelMonitoringAlertConfig.
     */
    public com.google.cloud.aiplatform.v1beta1.ModelMonitoringAlertConfig
        getModelMonitoringAlertConfig() {
      if (modelMonitoringAlertConfigBuilder_ == null) {
        return modelMonitoringAlertConfig_ == null
            ? com.google.cloud.aiplatform.v1beta1.ModelMonitoringAlertConfig.getDefaultInstance()
            : modelMonitoringAlertConfig_;
      } else {
        return modelMonitoringAlertConfigBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Alert config for model monitoring.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.ModelMonitoringAlertConfig model_monitoring_alert_config = 15;
     * </code>
     */
    public Builder setModelMonitoringAlertConfig(
        com.google.cloud.aiplatform.v1beta1.ModelMonitoringAlertConfig value) {
      if (modelMonitoringAlertConfigBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        modelMonitoringAlertConfig_ = value;
        onChanged();
      } else {
        modelMonitoringAlertConfigBuilder_.setMessage(value);
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * Alert config for model monitoring.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.ModelMonitoringAlertConfig model_monitoring_alert_config = 15;
     * </code>
     */
    public Builder setModelMonitoringAlertConfig(
        com.google.cloud.aiplatform.v1beta1.ModelMonitoringAlertConfig.Builder builderForValue) {
      if (modelMonitoringAlertConfigBuilder_ == null) {
        modelMonitoringAlertConfig_ = builderForValue.build();
        onChanged();
      } else {
        modelMonitoringAlertConfigBuilder_.setMessage(builderForValue.build());
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * Alert config for model monitoring.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.ModelMonitoringAlertConfig model_monitoring_alert_config = 15;
     * </code>
     */
    public Builder mergeModelMonitoringAlertConfig(
        com.google.cloud.aiplatform.v1beta1.ModelMonitoringAlertConfig value) {
      if (modelMonitoringAlertConfigBuilder_ == null) {
        if (modelMonitoringAlertConfig_ != null) {
          modelMonitoringAlertConfig_ =
              com.google.cloud.aiplatform.v1beta1.ModelMonitoringAlertConfig.newBuilder(
                      modelMonitoringAlertConfig_)
                  .mergeFrom(value)
                  .buildPartial();
        } else {
          modelMonitoringAlertConfig_ = value;
        }
        onChanged();
      } else {
        modelMonitoringAlertConfigBuilder_.mergeFrom(value);
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * Alert config for model monitoring.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.ModelMonitoringAlertConfig model_monitoring_alert_config = 15;
     * </code>
     */
    public Builder clearModelMonitoringAlertConfig() {
      if (modelMonitoringAlertConfigBuilder_ == null) {
        modelMonitoringAlertConfig_ = null;
        onChanged();
      } else {
        modelMonitoringAlertConfig_ = null;
        modelMonitoringAlertConfigBuilder_ = null;
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * Alert config for model monitoring.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.ModelMonitoringAlertConfig model_monitoring_alert_config = 15;
     * </code>
     */
    public com.google.cloud.aiplatform.v1beta1.ModelMonitoringAlertConfig.Builder
        getModelMonitoringAlertConfigBuilder() {

      onChanged();
      return getModelMonitoringAlertConfigFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Alert config for model monitoring.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.ModelMonitoringAlertConfig model_monitoring_alert_config = 15;
     * </code>
     */
    public com.google.cloud.aiplatform.v1beta1.ModelMonitoringAlertConfigOrBuilder
        getModelMonitoringAlertConfigOrBuilder() {
      if (modelMonitoringAlertConfigBuilder_ != null) {
        return modelMonitoringAlertConfigBuilder_.getMessageOrBuilder();
      } else {
        return modelMonitoringAlertConfig_ == null
            ? com.google.cloud.aiplatform.v1beta1.ModelMonitoringAlertConfig.getDefaultInstance()
            : modelMonitoringAlertConfig_;
      }
    }
    /**
     *
     *
     * <pre>
     * Alert config for model monitoring.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.ModelMonitoringAlertConfig model_monitoring_alert_config = 15;
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.aiplatform.v1beta1.ModelMonitoringAlertConfig,
            com.google.cloud.aiplatform.v1beta1.ModelMonitoringAlertConfig.Builder,
            com.google.cloud.aiplatform.v1beta1.ModelMonitoringAlertConfigOrBuilder>
        getModelMonitoringAlertConfigFieldBuilder() {
      if (modelMonitoringAlertConfigBuilder_ == null) {
        modelMonitoringAlertConfigBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.aiplatform.v1beta1.ModelMonitoringAlertConfig,
                com.google.cloud.aiplatform.v1beta1.ModelMonitoringAlertConfig.Builder,
                com.google.cloud.aiplatform.v1beta1.ModelMonitoringAlertConfigOrBuilder>(
                getModelMonitoringAlertConfig(), getParentForChildren(), isClean());
        modelMonitoringAlertConfig_ = null;
      }
      return modelMonitoringAlertConfigBuilder_;
    }

    private java.lang.Object predictInstanceSchemaUri_ = "";
    /**
     *
     *
     * <pre>
     * YAML schema file uri describing the format of a single instance,
     * which are given to format this Endpoint's prediction (and explanation).
     * If not set, we will generate predict schema from collected predict
     * requests.
     * </pre>
     *
     * <code>string predict_instance_schema_uri = 9;</code>
     *
     * @return The predictInstanceSchemaUri.
     */
    public java.lang.String getPredictInstanceSchemaUri() {
      java.lang.Object ref = predictInstanceSchemaUri_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        predictInstanceSchemaUri_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * YAML schema file uri describing the format of a single instance,
     * which are given to format this Endpoint's prediction (and explanation).
     * If not set, we will generate predict schema from collected predict
     * requests.
     * </pre>
     *
     * <code>string predict_instance_schema_uri = 9;</code>
     *
     * @return The bytes for predictInstanceSchemaUri.
     */
    public com.google.protobuf.ByteString getPredictInstanceSchemaUriBytes() {
      java.lang.Object ref = predictInstanceSchemaUri_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        predictInstanceSchemaUri_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * YAML schema file uri describing the format of a single instance,
     * which are given to format this Endpoint's prediction (and explanation).
     * If not set, we will generate predict schema from collected predict
     * requests.
     * </pre>
     *
     * <code>string predict_instance_schema_uri = 9;</code>
     *
     * @param value The predictInstanceSchemaUri to set.
     * @return This builder for chaining.
     */
    public Builder setPredictInstanceSchemaUri(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }

      predictInstanceSchemaUri_ = value;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * YAML schema file uri describing the format of a single instance,
     * which are given to format this Endpoint's prediction (and explanation).
     * If not set, we will generate predict schema from collected predict
     * requests.
     * </pre>
     *
     * <code>string predict_instance_schema_uri = 9;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearPredictInstanceSchemaUri() {

      predictInstanceSchemaUri_ = getDefaultInstance().getPredictInstanceSchemaUri();
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * YAML schema file uri describing the format of a single instance,
     * which are given to format this Endpoint's prediction (and explanation).
     * If not set, we will generate predict schema from collected predict
     * requests.
     * </pre>
     *
     * <code>string predict_instance_schema_uri = 9;</code>
     *
     * @param value The bytes for predictInstanceSchemaUri to set.
     * @return This builder for chaining.
     */
    public Builder setPredictInstanceSchemaUriBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);

      predictInstanceSchemaUri_ = value;
      onChanged();
      return this;
    }

    private com.google.protobuf.Value samplePredictInstance_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Value,
            com.google.protobuf.Value.Builder,
            com.google.protobuf.ValueOrBuilder>
        samplePredictInstanceBuilder_;
    /**
     *
     *
     * <pre>
     * Sample Predict instance, same format as [PredictRequest.instances][google.cloud.aiplatform.v1beta1.PredictRequest.instances],
     * this can be set as a replacement of
     * [ModelDeploymentMonitoringJob.predict_instance_schema_uri][google.cloud.aiplatform.v1beta1.ModelDeploymentMonitoringJob.predict_instance_schema_uri]. If not set,
     * we will generate predict schema from collected predict requests.
     * </pre>
     *
     * <code>.google.protobuf.Value sample_predict_instance = 19;</code>
     *
     * @return Whether the samplePredictInstance field is set.
     */
    public boolean hasSamplePredictInstance() {
      return samplePredictInstanceBuilder_ != null || samplePredictInstance_ != null;
    }
    /**
     *
     *
     * <pre>
     * Sample Predict instance, same format as [PredictRequest.instances][google.cloud.aiplatform.v1beta1.PredictRequest.instances],
     * this can be set as a replacement of
     * [ModelDeploymentMonitoringJob.predict_instance_schema_uri][google.cloud.aiplatform.v1beta1.ModelDeploymentMonitoringJob.predict_instance_schema_uri]. If not set,
     * we will generate predict schema from collected predict requests.
     * </pre>
     *
     * <code>.google.protobuf.Value sample_predict_instance = 19;</code>
     *
     * @return The samplePredictInstance.
     */
    public com.google.protobuf.Value getSamplePredictInstance() {
      if (samplePredictInstanceBuilder_ == null) {
        return samplePredictInstance_ == null
            ? com.google.protobuf.Value.getDefaultInstance()
            : samplePredictInstance_;
      } else {
        return samplePredictInstanceBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Sample Predict instance, same format as [PredictRequest.instances][google.cloud.aiplatform.v1beta1.PredictRequest.instances],
     * this can be set as a replacement of
     * [ModelDeploymentMonitoringJob.predict_instance_schema_uri][google.cloud.aiplatform.v1beta1.ModelDeploymentMonitoringJob.predict_instance_schema_uri]. If not set,
     * we will generate predict schema from collected predict requests.
     * </pre>
     *
     * <code>.google.protobuf.Value sample_predict_instance = 19;</code>
     */
    public Builder setSamplePredictInstance(com.google.protobuf.Value value) {
      if (samplePredictInstanceBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        samplePredictInstance_ = value;
        onChanged();
      } else {
        samplePredictInstanceBuilder_.setMessage(value);
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * Sample Predict instance, same format as [PredictRequest.instances][google.cloud.aiplatform.v1beta1.PredictRequest.instances],
     * this can be set as a replacement of
     * [ModelDeploymentMonitoringJob.predict_instance_schema_uri][google.cloud.aiplatform.v1beta1.ModelDeploymentMonitoringJob.predict_instance_schema_uri]. If not set,
     * we will generate predict schema from collected predict requests.
     * </pre>
     *
     * <code>.google.protobuf.Value sample_predict_instance = 19;</code>
     */
    public Builder setSamplePredictInstance(com.google.protobuf.Value.Builder builderForValue) {
      if (samplePredictInstanceBuilder_ == null) {
        samplePredictInstance_ = builderForValue.build();
        onChanged();
      } else {
        samplePredictInstanceBuilder_.setMessage(builderForValue.build());
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * Sample Predict instance, same format as [PredictRequest.instances][google.cloud.aiplatform.v1beta1.PredictRequest.instances],
     * this can be set as a replacement of
     * [ModelDeploymentMonitoringJob.predict_instance_schema_uri][google.cloud.aiplatform.v1beta1.ModelDeploymentMonitoringJob.predict_instance_schema_uri]. If not set,
     * we will generate predict schema from collected predict requests.
     * </pre>
     *
     * <code>.google.protobuf.Value sample_predict_instance = 19;</code>
     */
    public Builder mergeSamplePredictInstance(com.google.protobuf.Value value) {
      if (samplePredictInstanceBuilder_ == null) {
        if (samplePredictInstance_ != null) {
          samplePredictInstance_ =
              com.google.protobuf.Value.newBuilder(samplePredictInstance_)
                  .mergeFrom(value)
                  .buildPartial();
        } else {
          samplePredictInstance_ = value;
        }
        onChanged();
      } else {
        samplePredictInstanceBuilder_.mergeFrom(value);
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * Sample Predict instance, same format as [PredictRequest.instances][google.cloud.aiplatform.v1beta1.PredictRequest.instances],
     * this can be set as a replacement of
     * [ModelDeploymentMonitoringJob.predict_instance_schema_uri][google.cloud.aiplatform.v1beta1.ModelDeploymentMonitoringJob.predict_instance_schema_uri]. If not set,
     * we will generate predict schema from collected predict requests.
     * </pre>
     *
     * <code>.google.protobuf.Value sample_predict_instance = 19;</code>
     */
    public Builder clearSamplePredictInstance() {
      if (samplePredictInstanceBuilder_ == null) {
        samplePredictInstance_ = null;
        onChanged();
      } else {
        samplePredictInstance_ = null;
        samplePredictInstanceBuilder_ = null;
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * Sample Predict instance, same format as [PredictRequest.instances][google.cloud.aiplatform.v1beta1.PredictRequest.instances],
     * this can be set as a replacement of
     * [ModelDeploymentMonitoringJob.predict_instance_schema_uri][google.cloud.aiplatform.v1beta1.ModelDeploymentMonitoringJob.predict_instance_schema_uri]. If not set,
     * we will generate predict schema from collected predict requests.
     * </pre>
     *
     * <code>.google.protobuf.Value sample_predict_instance = 19;</code>
     */
    public com.google.protobuf.Value.Builder getSamplePredictInstanceBuilder() {

      onChanged();
      return getSamplePredictInstanceFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Sample Predict instance, same format as [PredictRequest.instances][google.cloud.aiplatform.v1beta1.PredictRequest.instances],
     * this can be set as a replacement of
     * [ModelDeploymentMonitoringJob.predict_instance_schema_uri][google.cloud.aiplatform.v1beta1.ModelDeploymentMonitoringJob.predict_instance_schema_uri]. If not set,
     * we will generate predict schema from collected predict requests.
     * </pre>
     *
     * <code>.google.protobuf.Value sample_predict_instance = 19;</code>
     */
    public com.google.protobuf.ValueOrBuilder getSamplePredictInstanceOrBuilder() {
      if (samplePredictInstanceBuilder_ != null) {
        return samplePredictInstanceBuilder_.getMessageOrBuilder();
      } else {
        return samplePredictInstance_ == null
            ? com.google.protobuf.Value.getDefaultInstance()
            : samplePredictInstance_;
      }
    }
    /**
     *
     *
     * <pre>
     * Sample Predict instance, same format as [PredictRequest.instances][google.cloud.aiplatform.v1beta1.PredictRequest.instances],
     * this can be set as a replacement of
     * [ModelDeploymentMonitoringJob.predict_instance_schema_uri][google.cloud.aiplatform.v1beta1.ModelDeploymentMonitoringJob.predict_instance_schema_uri]. If not set,
     * we will generate predict schema from collected predict requests.
     * </pre>
     *
     * <code>.google.protobuf.Value sample_predict_instance = 19;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Value,
            com.google.protobuf.Value.Builder,
            com.google.protobuf.ValueOrBuilder>
        getSamplePredictInstanceFieldBuilder() {
      if (samplePredictInstanceBuilder_ == null) {
        samplePredictInstanceBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.protobuf.Value,
                com.google.protobuf.Value.Builder,
                com.google.protobuf.ValueOrBuilder>(
                getSamplePredictInstance(), getParentForChildren(), isClean());
        samplePredictInstance_ = null;
      }
      return samplePredictInstanceBuilder_;
    }

    private java.lang.Object analysisInstanceSchemaUri_ = "";
    /**
     *
     *
     * <pre>
     * YAML schema file uri describing the format of a single instance that you
     * want Tensorflow Data Validation (TFDV) to analyze.
     * If this field is empty, all the feature data types are inferred from
     * [predict_instance_schema_uri][google.cloud.aiplatform.v1beta1.ModelDeploymentMonitoringJob.predict_instance_schema_uri],
     * meaning that TFDV will use the data in the exact format(data type) as
     * prediction request/response.
     * If there are any data type differences between predict instance and TFDV
     * instance, this field can be used to override the schema.
     * For models trained with Vertex AI, this field must be set as all the
     * fields in predict instance formatted as string.
     * </pre>
     *
     * <code>string analysis_instance_schema_uri = 16;</code>
     *
     * @return The analysisInstanceSchemaUri.
     */
    public java.lang.String getAnalysisInstanceSchemaUri() {
      java.lang.Object ref = analysisInstanceSchemaUri_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        analysisInstanceSchemaUri_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * YAML schema file uri describing the format of a single instance that you
     * want Tensorflow Data Validation (TFDV) to analyze.
     * If this field is empty, all the feature data types are inferred from
     * [predict_instance_schema_uri][google.cloud.aiplatform.v1beta1.ModelDeploymentMonitoringJob.predict_instance_schema_uri],
     * meaning that TFDV will use the data in the exact format(data type) as
     * prediction request/response.
     * If there are any data type differences between predict instance and TFDV
     * instance, this field can be used to override the schema.
     * For models trained with Vertex AI, this field must be set as all the
     * fields in predict instance formatted as string.
     * </pre>
     *
     * <code>string analysis_instance_schema_uri = 16;</code>
     *
     * @return The bytes for analysisInstanceSchemaUri.
     */
    public com.google.protobuf.ByteString getAnalysisInstanceSchemaUriBytes() {
      java.lang.Object ref = analysisInstanceSchemaUri_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        analysisInstanceSchemaUri_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * YAML schema file uri describing the format of a single instance that you
     * want Tensorflow Data Validation (TFDV) to analyze.
     * If this field is empty, all the feature data types are inferred from
     * [predict_instance_schema_uri][google.cloud.aiplatform.v1beta1.ModelDeploymentMonitoringJob.predict_instance_schema_uri],
     * meaning that TFDV will use the data in the exact format(data type) as
     * prediction request/response.
     * If there are any data type differences between predict instance and TFDV
     * instance, this field can be used to override the schema.
     * For models trained with Vertex AI, this field must be set as all the
     * fields in predict instance formatted as string.
     * </pre>
     *
     * <code>string analysis_instance_schema_uri = 16;</code>
     *
     * @param value The analysisInstanceSchemaUri to set.
     * @return This builder for chaining.
     */
    public Builder setAnalysisInstanceSchemaUri(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }

      analysisInstanceSchemaUri_ = value;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * YAML schema file uri describing the format of a single instance that you
     * want Tensorflow Data Validation (TFDV) to analyze.
     * If this field is empty, all the feature data types are inferred from
     * [predict_instance_schema_uri][google.cloud.aiplatform.v1beta1.ModelDeploymentMonitoringJob.predict_instance_schema_uri],
     * meaning that TFDV will use the data in the exact format(data type) as
     * prediction request/response.
     * If there are any data type differences between predict instance and TFDV
     * instance, this field can be used to override the schema.
     * For models trained with Vertex AI, this field must be set as all the
     * fields in predict instance formatted as string.
     * </pre>
     *
     * <code>string analysis_instance_schema_uri = 16;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearAnalysisInstanceSchemaUri() {

      analysisInstanceSchemaUri_ = getDefaultInstance().getAnalysisInstanceSchemaUri();
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * YAML schema file uri describing the format of a single instance that you
     * want Tensorflow Data Validation (TFDV) to analyze.
     * If this field is empty, all the feature data types are inferred from
     * [predict_instance_schema_uri][google.cloud.aiplatform.v1beta1.ModelDeploymentMonitoringJob.predict_instance_schema_uri],
     * meaning that TFDV will use the data in the exact format(data type) as
     * prediction request/response.
     * If there are any data type differences between predict instance and TFDV
     * instance, this field can be used to override the schema.
     * For models trained with Vertex AI, this field must be set as all the
     * fields in predict instance formatted as string.
     * </pre>
     *
     * <code>string analysis_instance_schema_uri = 16;</code>
     *
     * @param value The bytes for analysisInstanceSchemaUri to set.
     * @return This builder for chaining.
     */
    public Builder setAnalysisInstanceSchemaUriBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);

      analysisInstanceSchemaUri_ = value;
      onChanged();
      return this;
    }

    private java.util.List<
            com.google.cloud.aiplatform.v1beta1.ModelDeploymentMonitoringBigQueryTable>
        bigqueryTables_ = java.util.Collections.emptyList();

    private void ensureBigqueryTablesIsMutable() {
      if (!((bitField0_ & 0x00000002) != 0)) {
        bigqueryTables_ =
            new java.util.ArrayList<
                com.google.cloud.aiplatform.v1beta1.ModelDeploymentMonitoringBigQueryTable>(
                bigqueryTables_);
        bitField0_ |= 0x00000002;
      }
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.cloud.aiplatform.v1beta1.ModelDeploymentMonitoringBigQueryTable,
            com.google.cloud.aiplatform.v1beta1.ModelDeploymentMonitoringBigQueryTable.Builder,
            com.google.cloud.aiplatform.v1beta1.ModelDeploymentMonitoringBigQueryTableOrBuilder>
        bigqueryTablesBuilder_;

    /**
     *
     *
     * <pre>
     * Output only. The created bigquery tables for the job under customer project. Customer
     * could do their own query &amp; analysis. There could be 4 log tables in
     * maximum:
     * 1. Training data logging predict request/response
     * 2. Serving data logging predict request/response
     * </pre>
     *
     * <code>
     * repeated .google.cloud.aiplatform.v1beta1.ModelDeploymentMonitoringBigQueryTable bigquery_tables = 10 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public java.util.List<
            com.google.cloud.aiplatform.v1beta1.ModelDeploymentMonitoringBigQueryTable>
        getBigqueryTablesList() {
      if (bigqueryTablesBuilder_ == null) {
        return java.util.Collections.unmodifiableList(bigqueryTables_);
      } else {
        return bigqueryTablesBuilder_.getMessageList();
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. The created bigquery tables for the job under customer project. Customer
     * could do their own query &amp; analysis. There could be 4 log tables in
     * maximum:
     * 1. Training data logging predict request/response
     * 2. Serving data logging predict request/response
     * </pre>
     *
     * <code>
     * repeated .google.cloud.aiplatform.v1beta1.ModelDeploymentMonitoringBigQueryTable bigquery_tables = 10 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public int getBigqueryTablesCount() {
      if (bigqueryTablesBuilder_ == null) {
        return bigqueryTables_.size();
      } else {
        return bigqueryTablesBuilder_.getCount();
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. The created bigquery tables for the job under customer project. Customer
     * could do their own query &amp; analysis. There could be 4 log tables in
     * maximum:
     * 1. Training data logging predict request/response
     * 2. Serving data logging predict request/response
     * </pre>
     *
     * <code>
     * repeated .google.cloud.aiplatform.v1beta1.ModelDeploymentMonitoringBigQueryTable bigquery_tables = 10 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.cloud.aiplatform.v1beta1.ModelDeploymentMonitoringBigQueryTable
        getBigqueryTables(int index) {
      if (bigqueryTablesBuilder_ == null) {
        return bigqueryTables_.get(index);
      } else {
        return bigqueryTablesBuilder_.getMessage(index);
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. The created bigquery tables for the job under customer project. Customer
     * could do their own query &amp; analysis. There could be 4 log tables in
     * maximum:
     * 1. Training data logging predict request/response
     * 2. Serving data logging predict request/response
     * </pre>
     *
     * <code>
     * repeated .google.cloud.aiplatform.v1beta1.ModelDeploymentMonitoringBigQueryTable bigquery_tables = 10 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder setBigqueryTables(
        int index,
        com.google.cloud.aiplatform.v1beta1.ModelDeploymentMonitoringBigQueryTable value) {
      if (bigqueryTablesBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureBigqueryTablesIsMutable();
        bigqueryTables_.set(index, value);
        onChanged();
      } else {
        bigqueryTablesBuilder_.setMessage(index, value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The created bigquery tables for the job under customer project. Customer
     * could do their own query &amp; analysis. There could be 4 log tables in
     * maximum:
     * 1. Training data logging predict request/response
     * 2. Serving data logging predict request/response
     * </pre>
     *
     * <code>
     * repeated .google.cloud.aiplatform.v1beta1.ModelDeploymentMonitoringBigQueryTable bigquery_tables = 10 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder setBigqueryTables(
        int index,
        com.google.cloud.aiplatform.v1beta1.ModelDeploymentMonitoringBigQueryTable.Builder
            builderForValue) {
      if (bigqueryTablesBuilder_ == null) {
        ensureBigqueryTablesIsMutable();
        bigqueryTables_.set(index, builderForValue.build());
        onChanged();
      } else {
        bigqueryTablesBuilder_.setMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The created bigquery tables for the job under customer project. Customer
     * could do their own query &amp; analysis. There could be 4 log tables in
     * maximum:
     * 1. Training data logging predict request/response
     * 2. Serving data logging predict request/response
     * </pre>
     *
     * <code>
     * repeated .google.cloud.aiplatform.v1beta1.ModelDeploymentMonitoringBigQueryTable bigquery_tables = 10 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder addBigqueryTables(
        com.google.cloud.aiplatform.v1beta1.ModelDeploymentMonitoringBigQueryTable value) {
      if (bigqueryTablesBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureBigqueryTablesIsMutable();
        bigqueryTables_.add(value);
        onChanged();
      } else {
        bigqueryTablesBuilder_.addMessage(value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The created bigquery tables for the job under customer project. Customer
     * could do their own query &amp; analysis. There could be 4 log tables in
     * maximum:
     * 1. Training data logging predict request/response
     * 2. Serving data logging predict request/response
     * </pre>
     *
     * <code>
     * repeated .google.cloud.aiplatform.v1beta1.ModelDeploymentMonitoringBigQueryTable bigquery_tables = 10 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder addBigqueryTables(
        int index,
        com.google.cloud.aiplatform.v1beta1.ModelDeploymentMonitoringBigQueryTable value) {
      if (bigqueryTablesBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureBigqueryTablesIsMutable();
        bigqueryTables_.add(index, value);
        onChanged();
      } else {
        bigqueryTablesBuilder_.addMessage(index, value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The created bigquery tables for the job under customer project. Customer
     * could do their own query &amp; analysis. There could be 4 log tables in
     * maximum:
     * 1. Training data logging predict request/response
     * 2. Serving data logging predict request/response
     * </pre>
     *
     * <code>
     * repeated .google.cloud.aiplatform.v1beta1.ModelDeploymentMonitoringBigQueryTable bigquery_tables = 10 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder addBigqueryTables(
        com.google.cloud.aiplatform.v1beta1.ModelDeploymentMonitoringBigQueryTable.Builder
            builderForValue) {
      if (bigqueryTablesBuilder_ == null) {
        ensureBigqueryTablesIsMutable();
        bigqueryTables_.add(builderForValue.build());
        onChanged();
      } else {
        bigqueryTablesBuilder_.addMessage(builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The created bigquery tables for the job under customer project. Customer
     * could do their own query &amp; analysis. There could be 4 log tables in
     * maximum:
     * 1. Training data logging predict request/response
     * 2. Serving data logging predict request/response
     * </pre>
     *
     * <code>
     * repeated .google.cloud.aiplatform.v1beta1.ModelDeploymentMonitoringBigQueryTable bigquery_tables = 10 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder addBigqueryTables(
        int index,
        com.google.cloud.aiplatform.v1beta1.ModelDeploymentMonitoringBigQueryTable.Builder
            builderForValue) {
      if (bigqueryTablesBuilder_ == null) {
        ensureBigqueryTablesIsMutable();
        bigqueryTables_.add(index, builderForValue.build());
        onChanged();
      } else {
        bigqueryTablesBuilder_.addMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The created bigquery tables for the job under customer project. Customer
     * could do their own query &amp; analysis. There could be 4 log tables in
     * maximum:
     * 1. Training data logging predict request/response
     * 2. Serving data logging predict request/response
     * </pre>
     *
     * <code>
     * repeated .google.cloud.aiplatform.v1beta1.ModelDeploymentMonitoringBigQueryTable bigquery_tables = 10 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder addAllBigqueryTables(
        java.lang.Iterable<
                ? extends
                    com.google.cloud.aiplatform.v1beta1.ModelDeploymentMonitoringBigQueryTable>
            values) {
      if (bigqueryTablesBuilder_ == null) {
        ensureBigqueryTablesIsMutable();
        com.google.protobuf.AbstractMessageLite.Builder.addAll(values, bigqueryTables_);
        onChanged();
      } else {
        bigqueryTablesBuilder_.addAllMessages(values);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The created bigquery tables for the job under customer project. Customer
     * could do their own query &amp; analysis. There could be 4 log tables in
     * maximum:
     * 1. Training data logging predict request/response
     * 2. Serving data logging predict request/response
     * </pre>
     *
     * <code>
     * repeated .google.cloud.aiplatform.v1beta1.ModelDeploymentMonitoringBigQueryTable bigquery_tables = 10 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder clearBigqueryTables() {
      if (bigqueryTablesBuilder_ == null) {
        bigqueryTables_ = java.util.Collections.emptyList();
        bitField0_ = (bitField0_ & ~0x00000002);
        onChanged();
      } else {
        bigqueryTablesBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The created bigquery tables for the job under customer project. Customer
     * could do their own query &amp; analysis. There could be 4 log tables in
     * maximum:
     * 1. Training data logging predict request/response
     * 2. Serving data logging predict request/response
     * </pre>
     *
     * <code>
     * repeated .google.cloud.aiplatform.v1beta1.ModelDeploymentMonitoringBigQueryTable bigquery_tables = 10 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder removeBigqueryTables(int index) {
      if (bigqueryTablesBuilder_ == null) {
        ensureBigqueryTablesIsMutable();
        bigqueryTables_.remove(index);
        onChanged();
      } else {
        bigqueryTablesBuilder_.remove(index);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The created bigquery tables for the job under customer project. Customer
     * could do their own query &amp; analysis. There could be 4 log tables in
     * maximum:
     * 1. Training data logging predict request/response
     * 2. Serving data logging predict request/response
     * </pre>
     *
     * <code>
     * repeated .google.cloud.aiplatform.v1beta1.ModelDeploymentMonitoringBigQueryTable bigquery_tables = 10 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.cloud.aiplatform.v1beta1.ModelDeploymentMonitoringBigQueryTable.Builder
        getBigqueryTablesBuilder(int index) {
      return getBigqueryTablesFieldBuilder().getBuilder(index);
    }
    /**
     *
     *
     * <pre>
     * Output only. The created bigquery tables for the job under customer project. Customer
     * could do their own query &amp; analysis. There could be 4 log tables in
     * maximum:
     * 1. Training data logging predict request/response
     * 2. Serving data logging predict request/response
     * </pre>
     *
     * <code>
     * repeated .google.cloud.aiplatform.v1beta1.ModelDeploymentMonitoringBigQueryTable bigquery_tables = 10 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.cloud.aiplatform.v1beta1.ModelDeploymentMonitoringBigQueryTableOrBuilder
        getBigqueryTablesOrBuilder(int index) {
      if (bigqueryTablesBuilder_ == null) {
        return bigqueryTables_.get(index);
      } else {
        return bigqueryTablesBuilder_.getMessageOrBuilder(index);
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. The created bigquery tables for the job under customer project. Customer
     * could do their own query &amp; analysis. There could be 4 log tables in
     * maximum:
     * 1. Training data logging predict request/response
     * 2. Serving data logging predict request/response
     * </pre>
     *
     * <code>
     * repeated .google.cloud.aiplatform.v1beta1.ModelDeploymentMonitoringBigQueryTable bigquery_tables = 10 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public java.util.List<
            ? extends
                com.google.cloud.aiplatform.v1beta1.ModelDeploymentMonitoringBigQueryTableOrBuilder>
        getBigqueryTablesOrBuilderList() {
      if (bigqueryTablesBuilder_ != null) {
        return bigqueryTablesBuilder_.getMessageOrBuilderList();
      } else {
        return java.util.Collections.unmodifiableList(bigqueryTables_);
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. The created bigquery tables for the job under customer project. Customer
     * could do their own query &amp; analysis. There could be 4 log tables in
     * maximum:
     * 1. Training data logging predict request/response
     * 2. Serving data logging predict request/response
     * </pre>
     *
     * <code>
     * repeated .google.cloud.aiplatform.v1beta1.ModelDeploymentMonitoringBigQueryTable bigquery_tables = 10 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.cloud.aiplatform.v1beta1.ModelDeploymentMonitoringBigQueryTable.Builder
        addBigqueryTablesBuilder() {
      return getBigqueryTablesFieldBuilder()
          .addBuilder(
              com.google.cloud.aiplatform.v1beta1.ModelDeploymentMonitoringBigQueryTable
                  .getDefaultInstance());
    }
    /**
     *
     *
     * <pre>
     * Output only. The created bigquery tables for the job under customer project. Customer
     * could do their own query &amp; analysis. There could be 4 log tables in
     * maximum:
     * 1. Training data logging predict request/response
     * 2. Serving data logging predict request/response
     * </pre>
     *
     * <code>
     * repeated .google.cloud.aiplatform.v1beta1.ModelDeploymentMonitoringBigQueryTable bigquery_tables = 10 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.cloud.aiplatform.v1beta1.ModelDeploymentMonitoringBigQueryTable.Builder
        addBigqueryTablesBuilder(int index) {
      return getBigqueryTablesFieldBuilder()
          .addBuilder(
              index,
              com.google.cloud.aiplatform.v1beta1.ModelDeploymentMonitoringBigQueryTable
                  .getDefaultInstance());
    }
    /**
     *
     *
     * <pre>
     * Output only. The created bigquery tables for the job under customer project. Customer
     * could do their own query &amp; analysis. There could be 4 log tables in
     * maximum:
     * 1. Training data logging predict request/response
     * 2. Serving data logging predict request/response
     * </pre>
     *
     * <code>
     * repeated .google.cloud.aiplatform.v1beta1.ModelDeploymentMonitoringBigQueryTable bigquery_tables = 10 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public java.util.List<
            com.google.cloud.aiplatform.v1beta1.ModelDeploymentMonitoringBigQueryTable.Builder>
        getBigqueryTablesBuilderList() {
      return getBigqueryTablesFieldBuilder().getBuilderList();
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.cloud.aiplatform.v1beta1.ModelDeploymentMonitoringBigQueryTable,
            com.google.cloud.aiplatform.v1beta1.ModelDeploymentMonitoringBigQueryTable.Builder,
            com.google.cloud.aiplatform.v1beta1.ModelDeploymentMonitoringBigQueryTableOrBuilder>
        getBigqueryTablesFieldBuilder() {
      if (bigqueryTablesBuilder_ == null) {
        bigqueryTablesBuilder_ =
            new com.google.protobuf.RepeatedFieldBuilderV3<
                com.google.cloud.aiplatform.v1beta1.ModelDeploymentMonitoringBigQueryTable,
                com.google.cloud.aiplatform.v1beta1.ModelDeploymentMonitoringBigQueryTable.Builder,
                com.google.cloud.aiplatform.v1beta1
                    .ModelDeploymentMonitoringBigQueryTableOrBuilder>(
                bigqueryTables_,
                ((bitField0_ & 0x00000002) != 0),
                getParentForChildren(),
                isClean());
        bigqueryTables_ = null;
      }
      return bigqueryTablesBuilder_;
    }

    private com.google.protobuf.Duration logTtl_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Duration,
            com.google.protobuf.Duration.Builder,
            com.google.protobuf.DurationOrBuilder>
        logTtlBuilder_;
    /**
     *
     *
     * <pre>
     * The TTL of BigQuery tables in user projects which stores logs.
     * A day is the basic unit of the TTL and we take the ceil of TTL/86400(a
     * day). e.g. { second: 3600} indicates ttl = 1 day.
     * </pre>
     *
     * <code>.google.protobuf.Duration log_ttl = 17;</code>
     *
     * @return Whether the logTtl field is set.
     */
    public boolean hasLogTtl() {
      return logTtlBuilder_ != null || logTtl_ != null;
    }
    /**
     *
     *
     * <pre>
     * The TTL of BigQuery tables in user projects which stores logs.
     * A day is the basic unit of the TTL and we take the ceil of TTL/86400(a
     * day). e.g. { second: 3600} indicates ttl = 1 day.
     * </pre>
     *
     * <code>.google.protobuf.Duration log_ttl = 17;</code>
     *
     * @return The logTtl.
     */
    public com.google.protobuf.Duration getLogTtl() {
      if (logTtlBuilder_ == null) {
        return logTtl_ == null ? com.google.protobuf.Duration.getDefaultInstance() : logTtl_;
      } else {
        return logTtlBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * The TTL of BigQuery tables in user projects which stores logs.
     * A day is the basic unit of the TTL and we take the ceil of TTL/86400(a
     * day). e.g. { second: 3600} indicates ttl = 1 day.
     * </pre>
     *
     * <code>.google.protobuf.Duration log_ttl = 17;</code>
     */
    public Builder setLogTtl(com.google.protobuf.Duration value) {
      if (logTtlBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        logTtl_ = value;
        onChanged();
      } else {
        logTtlBuilder_.setMessage(value);
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * The TTL of BigQuery tables in user projects which stores logs.
     * A day is the basic unit of the TTL and we take the ceil of TTL/86400(a
     * day). e.g. { second: 3600} indicates ttl = 1 day.
     * </pre>
     *
     * <code>.google.protobuf.Duration log_ttl = 17;</code>
     */
    public Builder setLogTtl(com.google.protobuf.Duration.Builder builderForValue) {
      if (logTtlBuilder_ == null) {
        logTtl_ = builderForValue.build();
        onChanged();
      } else {
        logTtlBuilder_.setMessage(builderForValue.build());
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * The TTL of BigQuery tables in user projects which stores logs.
     * A day is the basic unit of the TTL and we take the ceil of TTL/86400(a
     * day). e.g. { second: 3600} indicates ttl = 1 day.
     * </pre>
     *
     * <code>.google.protobuf.Duration log_ttl = 17;</code>
     */
    public Builder mergeLogTtl(com.google.protobuf.Duration value) {
      if (logTtlBuilder_ == null) {
        if (logTtl_ != null) {
          logTtl_ =
              com.google.protobuf.Duration.newBuilder(logTtl_).mergeFrom(value).buildPartial();
        } else {
          logTtl_ = value;
        }
        onChanged();
      } else {
        logTtlBuilder_.mergeFrom(value);
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * The TTL of BigQuery tables in user projects which stores logs.
     * A day is the basic unit of the TTL and we take the ceil of TTL/86400(a
     * day). e.g. { second: 3600} indicates ttl = 1 day.
     * </pre>
     *
     * <code>.google.protobuf.Duration log_ttl = 17;</code>
     */
    public Builder clearLogTtl() {
      if (logTtlBuilder_ == null) {
        logTtl_ = null;
        onChanged();
      } else {
        logTtl_ = null;
        logTtlBuilder_ = null;
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * The TTL of BigQuery tables in user projects which stores logs.
     * A day is the basic unit of the TTL and we take the ceil of TTL/86400(a
     * day). e.g. { second: 3600} indicates ttl = 1 day.
     * </pre>
     *
     * <code>.google.protobuf.Duration log_ttl = 17;</code>
     */
    public com.google.protobuf.Duration.Builder getLogTtlBuilder() {

      onChanged();
      return getLogTtlFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * The TTL of BigQuery tables in user projects which stores logs.
     * A day is the basic unit of the TTL and we take the ceil of TTL/86400(a
     * day). e.g. { second: 3600} indicates ttl = 1 day.
     * </pre>
     *
     * <code>.google.protobuf.Duration log_ttl = 17;</code>
     */
    public com.google.protobuf.DurationOrBuilder getLogTtlOrBuilder() {
      if (logTtlBuilder_ != null) {
        return logTtlBuilder_.getMessageOrBuilder();
      } else {
        return logTtl_ == null ? com.google.protobuf.Duration.getDefaultInstance() : logTtl_;
      }
    }
    /**
     *
     *
     * <pre>
     * The TTL of BigQuery tables in user projects which stores logs.
     * A day is the basic unit of the TTL and we take the ceil of TTL/86400(a
     * day). e.g. { second: 3600} indicates ttl = 1 day.
     * </pre>
     *
     * <code>.google.protobuf.Duration log_ttl = 17;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Duration,
            com.google.protobuf.Duration.Builder,
            com.google.protobuf.DurationOrBuilder>
        getLogTtlFieldBuilder() {
      if (logTtlBuilder_ == null) {
        logTtlBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.protobuf.Duration,
                com.google.protobuf.Duration.Builder,
                com.google.protobuf.DurationOrBuilder>(
                getLogTtl(), getParentForChildren(), isClean());
        logTtl_ = null;
      }
      return logTtlBuilder_;
    }

    private com.google.protobuf.MapField<java.lang.String, java.lang.String> labels_;

    private com.google.protobuf.MapField<java.lang.String, java.lang.String> internalGetLabels() {
      if (labels_ == null) {
        return com.google.protobuf.MapField.emptyMapField(LabelsDefaultEntryHolder.defaultEntry);
      }
      return labels_;
    }

    private com.google.protobuf.MapField<java.lang.String, java.lang.String>
        internalGetMutableLabels() {
      onChanged();
      ;
      if (labels_ == null) {
        labels_ = com.google.protobuf.MapField.newMapField(LabelsDefaultEntryHolder.defaultEntry);
      }
      if (!labels_.isMutable()) {
        labels_ = labels_.copy();
      }
      return labels_;
    }

    public int getLabelsCount() {
      return internalGetLabels().getMap().size();
    }
    /**
     *
     *
     * <pre>
     * The labels with user-defined metadata to organize your
     * ModelDeploymentMonitoringJob.
     * Label keys and values can be no longer than 64 characters
     * (Unicode codepoints), can only contain lowercase letters, numeric
     * characters, underscores and dashes. International characters are allowed.
     * See https://goo.gl/xmQnxf for more information and examples of labels.
     * </pre>
     *
     * <code>map&lt;string, string&gt; labels = 11;</code>
     */
    @java.lang.Override
    public boolean containsLabels(java.lang.String key) {
      if (key == null) {
        throw new java.lang.NullPointerException();
      }
      return internalGetLabels().getMap().containsKey(key);
    }
    /** Use {@link #getLabelsMap()} instead. */
    @java.lang.Override
    @java.lang.Deprecated
    public java.util.Map<java.lang.String, java.lang.String> getLabels() {
      return getLabelsMap();
    }
    /**
     *
     *
     * <pre>
     * The labels with user-defined metadata to organize your
     * ModelDeploymentMonitoringJob.
     * Label keys and values can be no longer than 64 characters
     * (Unicode codepoints), can only contain lowercase letters, numeric
     * characters, underscores and dashes. International characters are allowed.
     * See https://goo.gl/xmQnxf for more information and examples of labels.
     * </pre>
     *
     * <code>map&lt;string, string&gt; labels = 11;</code>
     */
    @java.lang.Override
    public java.util.Map<java.lang.String, java.lang.String> getLabelsMap() {
      return internalGetLabels().getMap();
    }
    /**
     *
     *
     * <pre>
     * The labels with user-defined metadata to organize your
     * ModelDeploymentMonitoringJob.
     * Label keys and values can be no longer than 64 characters
     * (Unicode codepoints), can only contain lowercase letters, numeric
     * characters, underscores and dashes. International characters are allowed.
     * See https://goo.gl/xmQnxf for more information and examples of labels.
     * </pre>
     *
     * <code>map&lt;string, string&gt; labels = 11;</code>
     */
    @java.lang.Override
    public java.lang.String getLabelsOrDefault(
        java.lang.String key, java.lang.String defaultValue) {
      if (key == null) {
        throw new java.lang.NullPointerException();
      }
      java.util.Map<java.lang.String, java.lang.String> map = internalGetLabels().getMap();
      return map.containsKey(key) ? map.get(key) : defaultValue;
    }
    /**
     *
     *
     * <pre>
     * The labels with user-defined metadata to organize your
     * ModelDeploymentMonitoringJob.
     * Label keys and values can be no longer than 64 characters
     * (Unicode codepoints), can only contain lowercase letters, numeric
     * characters, underscores and dashes. International characters are allowed.
     * See https://goo.gl/xmQnxf for more information and examples of labels.
     * </pre>
     *
     * <code>map&lt;string, string&gt; labels = 11;</code>
     */
    @java.lang.Override
    public java.lang.String getLabelsOrThrow(java.lang.String key) {
      if (key == null) {
        throw new java.lang.NullPointerException();
      }
      java.util.Map<java.lang.String, java.lang.String> map = internalGetLabels().getMap();
      if (!map.containsKey(key)) {
        throw new java.lang.IllegalArgumentException();
      }
      return map.get(key);
    }

    public Builder clearLabels() {
      internalGetMutableLabels().getMutableMap().clear();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The labels with user-defined metadata to organize your
     * ModelDeploymentMonitoringJob.
     * Label keys and values can be no longer than 64 characters
     * (Unicode codepoints), can only contain lowercase letters, numeric
     * characters, underscores and dashes. International characters are allowed.
     * See https://goo.gl/xmQnxf for more information and examples of labels.
     * </pre>
     *
     * <code>map&lt;string, string&gt; labels = 11;</code>
     */
    public Builder removeLabels(java.lang.String key) {
      if (key == null) {
        throw new java.lang.NullPointerException();
      }
      internalGetMutableLabels().getMutableMap().remove(key);
      return this;
    }
    /** Use alternate mutation accessors instead. */
    @java.lang.Deprecated
    public java.util.Map<java.lang.String, java.lang.String> getMutableLabels() {
      return internalGetMutableLabels().getMutableMap();
    }
    /**
     *
     *
     * <pre>
     * The labels with user-defined metadata to organize your
     * ModelDeploymentMonitoringJob.
     * Label keys and values can be no longer than 64 characters
     * (Unicode codepoints), can only contain lowercase letters, numeric
     * characters, underscores and dashes. International characters are allowed.
     * See https://goo.gl/xmQnxf for more information and examples of labels.
     * </pre>
     *
     * <code>map&lt;string, string&gt; labels = 11;</code>
     */
    public Builder putLabels(java.lang.String key, java.lang.String value) {
      if (key == null) {
        throw new java.lang.NullPointerException();
      }
      if (value == null) {
        throw new java.lang.NullPointerException();
      }
      internalGetMutableLabels().getMutableMap().put(key, value);
      return this;
    }
    /**
     *
     *
     * <pre>
     * The labels with user-defined metadata to organize your
     * ModelDeploymentMonitoringJob.
     * Label keys and values can be no longer than 64 characters
     * (Unicode codepoints), can only contain lowercase letters, numeric
     * characters, underscores and dashes. International characters are allowed.
     * See https://goo.gl/xmQnxf for more information and examples of labels.
     * </pre>
     *
     * <code>map&lt;string, string&gt; labels = 11;</code>
     */
    public Builder putAllLabels(java.util.Map<java.lang.String, java.lang.String> values) {
      internalGetMutableLabels().getMutableMap().putAll(values);
      return this;
    }

    private com.google.protobuf.Timestamp createTime_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Timestamp,
            com.google.protobuf.Timestamp.Builder,
            com.google.protobuf.TimestampOrBuilder>
        createTimeBuilder_;
    /**
     *
     *
     * <pre>
     * Output only. Timestamp when this ModelDeploymentMonitoringJob was created.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp create_time = 12 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return Whether the createTime field is set.
     */
    public boolean hasCreateTime() {
      return createTimeBuilder_ != null || createTime_ != null;
    }
    /**
     *
     *
     * <pre>
     * Output only. Timestamp when this ModelDeploymentMonitoringJob was created.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp create_time = 12 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return The createTime.
     */
    public com.google.protobuf.Timestamp getCreateTime() {
      if (createTimeBuilder_ == null) {
        return createTime_ == null
            ? com.google.protobuf.Timestamp.getDefaultInstance()
            : createTime_;
      } else {
        return createTimeBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. Timestamp when this ModelDeploymentMonitoringJob was created.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp create_time = 12 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder setCreateTime(com.google.protobuf.Timestamp value) {
      if (createTimeBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        createTime_ = value;
        onChanged();
      } else {
        createTimeBuilder_.setMessage(value);
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Timestamp when this ModelDeploymentMonitoringJob was created.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp create_time = 12 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder setCreateTime(com.google.protobuf.Timestamp.Builder builderForValue) {
      if (createTimeBuilder_ == null) {
        createTime_ = builderForValue.build();
        onChanged();
      } else {
        createTimeBuilder_.setMessage(builderForValue.build());
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Timestamp when this ModelDeploymentMonitoringJob was created.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp create_time = 12 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder mergeCreateTime(com.google.protobuf.Timestamp value) {
      if (createTimeBuilder_ == null) {
        if (createTime_ != null) {
          createTime_ =
              com.google.protobuf.Timestamp.newBuilder(createTime_).mergeFrom(value).buildPartial();
        } else {
          createTime_ = value;
        }
        onChanged();
      } else {
        createTimeBuilder_.mergeFrom(value);
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Timestamp when this ModelDeploymentMonitoringJob was created.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp create_time = 12 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder clearCreateTime() {
      if (createTimeBuilder_ == null) {
        createTime_ = null;
        onChanged();
      } else {
        createTime_ = null;
        createTimeBuilder_ = null;
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Timestamp when this ModelDeploymentMonitoringJob was created.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp create_time = 12 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.protobuf.Timestamp.Builder getCreateTimeBuilder() {

      onChanged();
      return getCreateTimeFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Output only. Timestamp when this ModelDeploymentMonitoringJob was created.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp create_time = 12 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.protobuf.TimestampOrBuilder getCreateTimeOrBuilder() {
      if (createTimeBuilder_ != null) {
        return createTimeBuilder_.getMessageOrBuilder();
      } else {
        return createTime_ == null
            ? com.google.protobuf.Timestamp.getDefaultInstance()
            : createTime_;
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. Timestamp when this ModelDeploymentMonitoringJob was created.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp create_time = 12 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Timestamp,
            com.google.protobuf.Timestamp.Builder,
            com.google.protobuf.TimestampOrBuilder>
        getCreateTimeFieldBuilder() {
      if (createTimeBuilder_ == null) {
        createTimeBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.protobuf.Timestamp,
                com.google.protobuf.Timestamp.Builder,
                com.google.protobuf.TimestampOrBuilder>(
                getCreateTime(), getParentForChildren(), isClean());
        createTime_ = null;
      }
      return createTimeBuilder_;
    }

    private com.google.protobuf.Timestamp updateTime_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Timestamp,
            com.google.protobuf.Timestamp.Builder,
            com.google.protobuf.TimestampOrBuilder>
        updateTimeBuilder_;
    /**
     *
     *
     * <pre>
     * Output only. Timestamp when this ModelDeploymentMonitoringJob was updated most recently.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp update_time = 13 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return Whether the updateTime field is set.
     */
    public boolean hasUpdateTime() {
      return updateTimeBuilder_ != null || updateTime_ != null;
    }
    /**
     *
     *
     * <pre>
     * Output only. Timestamp when this ModelDeploymentMonitoringJob was updated most recently.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp update_time = 13 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return The updateTime.
     */
    public com.google.protobuf.Timestamp getUpdateTime() {
      if (updateTimeBuilder_ == null) {
        return updateTime_ == null
            ? com.google.protobuf.Timestamp.getDefaultInstance()
            : updateTime_;
      } else {
        return updateTimeBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. Timestamp when this ModelDeploymentMonitoringJob was updated most recently.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp update_time = 13 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder setUpdateTime(com.google.protobuf.Timestamp value) {
      if (updateTimeBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        updateTime_ = value;
        onChanged();
      } else {
        updateTimeBuilder_.setMessage(value);
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Timestamp when this ModelDeploymentMonitoringJob was updated most recently.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp update_time = 13 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder setUpdateTime(com.google.protobuf.Timestamp.Builder builderForValue) {
      if (updateTimeBuilder_ == null) {
        updateTime_ = builderForValue.build();
        onChanged();
      } else {
        updateTimeBuilder_.setMessage(builderForValue.build());
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Timestamp when this ModelDeploymentMonitoringJob was updated most recently.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp update_time = 13 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder mergeUpdateTime(com.google.protobuf.Timestamp value) {
      if (updateTimeBuilder_ == null) {
        if (updateTime_ != null) {
          updateTime_ =
              com.google.protobuf.Timestamp.newBuilder(updateTime_).mergeFrom(value).buildPartial();
        } else {
          updateTime_ = value;
        }
        onChanged();
      } else {
        updateTimeBuilder_.mergeFrom(value);
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Timestamp when this ModelDeploymentMonitoringJob was updated most recently.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp update_time = 13 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder clearUpdateTime() {
      if (updateTimeBuilder_ == null) {
        updateTime_ = null;
        onChanged();
      } else {
        updateTime_ = null;
        updateTimeBuilder_ = null;
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Timestamp when this ModelDeploymentMonitoringJob was updated most recently.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp update_time = 13 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.protobuf.Timestamp.Builder getUpdateTimeBuilder() {

      onChanged();
      return getUpdateTimeFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Output only. Timestamp when this ModelDeploymentMonitoringJob was updated most recently.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp update_time = 13 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.protobuf.TimestampOrBuilder getUpdateTimeOrBuilder() {
      if (updateTimeBuilder_ != null) {
        return updateTimeBuilder_.getMessageOrBuilder();
      } else {
        return updateTime_ == null
            ? com.google.protobuf.Timestamp.getDefaultInstance()
            : updateTime_;
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. Timestamp when this ModelDeploymentMonitoringJob was updated most recently.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp update_time = 13 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Timestamp,
            com.google.protobuf.Timestamp.Builder,
            com.google.protobuf.TimestampOrBuilder>
        getUpdateTimeFieldBuilder() {
      if (updateTimeBuilder_ == null) {
        updateTimeBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.protobuf.Timestamp,
                com.google.protobuf.Timestamp.Builder,
                com.google.protobuf.TimestampOrBuilder>(
                getUpdateTime(), getParentForChildren(), isClean());
        updateTime_ = null;
      }
      return updateTimeBuilder_;
    }

    private com.google.protobuf.Timestamp nextScheduleTime_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Timestamp,
            com.google.protobuf.Timestamp.Builder,
            com.google.protobuf.TimestampOrBuilder>
        nextScheduleTimeBuilder_;
    /**
     *
     *
     * <pre>
     * Output only. Timestamp when this monitoring pipeline will be scheduled to run for the
     * next round.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp next_schedule_time = 14 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return Whether the nextScheduleTime field is set.
     */
    public boolean hasNextScheduleTime() {
      return nextScheduleTimeBuilder_ != null || nextScheduleTime_ != null;
    }
    /**
     *
     *
     * <pre>
     * Output only. Timestamp when this monitoring pipeline will be scheduled to run for the
     * next round.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp next_schedule_time = 14 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return The nextScheduleTime.
     */
    public com.google.protobuf.Timestamp getNextScheduleTime() {
      if (nextScheduleTimeBuilder_ == null) {
        return nextScheduleTime_ == null
            ? com.google.protobuf.Timestamp.getDefaultInstance()
            : nextScheduleTime_;
      } else {
        return nextScheduleTimeBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. Timestamp when this monitoring pipeline will be scheduled to run for the
     * next round.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp next_schedule_time = 14 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder setNextScheduleTime(com.google.protobuf.Timestamp value) {
      if (nextScheduleTimeBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        nextScheduleTime_ = value;
        onChanged();
      } else {
        nextScheduleTimeBuilder_.setMessage(value);
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Timestamp when this monitoring pipeline will be scheduled to run for the
     * next round.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp next_schedule_time = 14 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder setNextScheduleTime(com.google.protobuf.Timestamp.Builder builderForValue) {
      if (nextScheduleTimeBuilder_ == null) {
        nextScheduleTime_ = builderForValue.build();
        onChanged();
      } else {
        nextScheduleTimeBuilder_.setMessage(builderForValue.build());
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Timestamp when this monitoring pipeline will be scheduled to run for the
     * next round.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp next_schedule_time = 14 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder mergeNextScheduleTime(com.google.protobuf.Timestamp value) {
      if (nextScheduleTimeBuilder_ == null) {
        if (nextScheduleTime_ != null) {
          nextScheduleTime_ =
              com.google.protobuf.Timestamp.newBuilder(nextScheduleTime_)
                  .mergeFrom(value)
                  .buildPartial();
        } else {
          nextScheduleTime_ = value;
        }
        onChanged();
      } else {
        nextScheduleTimeBuilder_.mergeFrom(value);
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Timestamp when this monitoring pipeline will be scheduled to run for the
     * next round.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp next_schedule_time = 14 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder clearNextScheduleTime() {
      if (nextScheduleTimeBuilder_ == null) {
        nextScheduleTime_ = null;
        onChanged();
      } else {
        nextScheduleTime_ = null;
        nextScheduleTimeBuilder_ = null;
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Timestamp when this monitoring pipeline will be scheduled to run for the
     * next round.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp next_schedule_time = 14 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.protobuf.Timestamp.Builder getNextScheduleTimeBuilder() {

      onChanged();
      return getNextScheduleTimeFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Output only. Timestamp when this monitoring pipeline will be scheduled to run for the
     * next round.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp next_schedule_time = 14 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.protobuf.TimestampOrBuilder getNextScheduleTimeOrBuilder() {
      if (nextScheduleTimeBuilder_ != null) {
        return nextScheduleTimeBuilder_.getMessageOrBuilder();
      } else {
        return nextScheduleTime_ == null
            ? com.google.protobuf.Timestamp.getDefaultInstance()
            : nextScheduleTime_;
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. Timestamp when this monitoring pipeline will be scheduled to run for the
     * next round.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp next_schedule_time = 14 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Timestamp,
            com.google.protobuf.Timestamp.Builder,
            com.google.protobuf.TimestampOrBuilder>
        getNextScheduleTimeFieldBuilder() {
      if (nextScheduleTimeBuilder_ == null) {
        nextScheduleTimeBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.protobuf.Timestamp,
                com.google.protobuf.Timestamp.Builder,
                com.google.protobuf.TimestampOrBuilder>(
                getNextScheduleTime(), getParentForChildren(), isClean());
        nextScheduleTime_ = null;
      }
      return nextScheduleTimeBuilder_;
    }

    private com.google.cloud.aiplatform.v1beta1.GcsDestination statsAnomaliesBaseDirectory_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.aiplatform.v1beta1.GcsDestination,
            com.google.cloud.aiplatform.v1beta1.GcsDestination.Builder,
            com.google.cloud.aiplatform.v1beta1.GcsDestinationOrBuilder>
        statsAnomaliesBaseDirectoryBuilder_;
    /**
     *
     *
     * <pre>
     * Stats anomalies base folder path.
     * </pre>
     *
     * <code>.google.cloud.aiplatform.v1beta1.GcsDestination stats_anomalies_base_directory = 20;
     * </code>
     *
     * @return Whether the statsAnomaliesBaseDirectory field is set.
     */
    public boolean hasStatsAnomaliesBaseDirectory() {
      return statsAnomaliesBaseDirectoryBuilder_ != null || statsAnomaliesBaseDirectory_ != null;
    }
    /**
     *
     *
     * <pre>
     * Stats anomalies base folder path.
     * </pre>
     *
     * <code>.google.cloud.aiplatform.v1beta1.GcsDestination stats_anomalies_base_directory = 20;
     * </code>
     *
     * @return The statsAnomaliesBaseDirectory.
     */
    public com.google.cloud.aiplatform.v1beta1.GcsDestination getStatsAnomaliesBaseDirectory() {
      if (statsAnomaliesBaseDirectoryBuilder_ == null) {
        return statsAnomaliesBaseDirectory_ == null
            ? com.google.cloud.aiplatform.v1beta1.GcsDestination.getDefaultInstance()
            : statsAnomaliesBaseDirectory_;
      } else {
        return statsAnomaliesBaseDirectoryBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Stats anomalies base folder path.
     * </pre>
     *
     * <code>.google.cloud.aiplatform.v1beta1.GcsDestination stats_anomalies_base_directory = 20;
     * </code>
     */
    public Builder setStatsAnomaliesBaseDirectory(
        com.google.cloud.aiplatform.v1beta1.GcsDestination value) {
      if (statsAnomaliesBaseDirectoryBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        statsAnomaliesBaseDirectory_ = value;
        onChanged();
      } else {
        statsAnomaliesBaseDirectoryBuilder_.setMessage(value);
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * Stats anomalies base folder path.
     * </pre>
     *
     * <code>.google.cloud.aiplatform.v1beta1.GcsDestination stats_anomalies_base_directory = 20;
     * </code>
     */
    public Builder setStatsAnomaliesBaseDirectory(
        com.google.cloud.aiplatform.v1beta1.GcsDestination.Builder builderForValue) {
      if (statsAnomaliesBaseDirectoryBuilder_ == null) {
        statsAnomaliesBaseDirectory_ = builderForValue.build();
        onChanged();
      } else {
        statsAnomaliesBaseDirectoryBuilder_.setMessage(builderForValue.build());
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * Stats anomalies base folder path.
     * </pre>
     *
     * <code>.google.cloud.aiplatform.v1beta1.GcsDestination stats_anomalies_base_directory = 20;
     * </code>
     */
    public Builder mergeStatsAnomaliesBaseDirectory(
        com.google.cloud.aiplatform.v1beta1.GcsDestination value) {
      if (statsAnomaliesBaseDirectoryBuilder_ == null) {
        if (statsAnomaliesBaseDirectory_ != null) {
          statsAnomaliesBaseDirectory_ =
              com.google.cloud.aiplatform.v1beta1.GcsDestination.newBuilder(
                      statsAnomaliesBaseDirectory_)
                  .mergeFrom(value)
                  .buildPartial();
        } else {
          statsAnomaliesBaseDirectory_ = value;
        }
        onChanged();
      } else {
        statsAnomaliesBaseDirectoryBuilder_.mergeFrom(value);
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * Stats anomalies base folder path.
     * </pre>
     *
     * <code>.google.cloud.aiplatform.v1beta1.GcsDestination stats_anomalies_base_directory = 20;
     * </code>
     */
    public Builder clearStatsAnomaliesBaseDirectory() {
      if (statsAnomaliesBaseDirectoryBuilder_ == null) {
        statsAnomaliesBaseDirectory_ = null;
        onChanged();
      } else {
        statsAnomaliesBaseDirectory_ = null;
        statsAnomaliesBaseDirectoryBuilder_ = null;
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * Stats anomalies base folder path.
     * </pre>
     *
     * <code>.google.cloud.aiplatform.v1beta1.GcsDestination stats_anomalies_base_directory = 20;
     * </code>
     */
    public com.google.cloud.aiplatform.v1beta1.GcsDestination.Builder
        getStatsAnomaliesBaseDirectoryBuilder() {

      onChanged();
      return getStatsAnomaliesBaseDirectoryFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Stats anomalies base folder path.
     * </pre>
     *
     * <code>.google.cloud.aiplatform.v1beta1.GcsDestination stats_anomalies_base_directory = 20;
     * </code>
     */
    public com.google.cloud.aiplatform.v1beta1.GcsDestinationOrBuilder
        getStatsAnomaliesBaseDirectoryOrBuilder() {
      if (statsAnomaliesBaseDirectoryBuilder_ != null) {
        return statsAnomaliesBaseDirectoryBuilder_.getMessageOrBuilder();
      } else {
        return statsAnomaliesBaseDirectory_ == null
            ? com.google.cloud.aiplatform.v1beta1.GcsDestination.getDefaultInstance()
            : statsAnomaliesBaseDirectory_;
      }
    }
    /**
     *
     *
     * <pre>
     * Stats anomalies base folder path.
     * </pre>
     *
     * <code>.google.cloud.aiplatform.v1beta1.GcsDestination stats_anomalies_base_directory = 20;
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.aiplatform.v1beta1.GcsDestination,
            com.google.cloud.aiplatform.v1beta1.GcsDestination.Builder,
            com.google.cloud.aiplatform.v1beta1.GcsDestinationOrBuilder>
        getStatsAnomaliesBaseDirectoryFieldBuilder() {
      if (statsAnomaliesBaseDirectoryBuilder_ == null) {
        statsAnomaliesBaseDirectoryBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.aiplatform.v1beta1.GcsDestination,
                com.google.cloud.aiplatform.v1beta1.GcsDestination.Builder,
                com.google.cloud.aiplatform.v1beta1.GcsDestinationOrBuilder>(
                getStatsAnomaliesBaseDirectory(), getParentForChildren(), isClean());
        statsAnomaliesBaseDirectory_ = null;
      }
      return statsAnomaliesBaseDirectoryBuilder_;
    }

    private com.google.cloud.aiplatform.v1beta1.EncryptionSpec encryptionSpec_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.aiplatform.v1beta1.EncryptionSpec,
            com.google.cloud.aiplatform.v1beta1.EncryptionSpec.Builder,
            com.google.cloud.aiplatform.v1beta1.EncryptionSpecOrBuilder>
        encryptionSpecBuilder_;
    /**
     *
     *
     * <pre>
     * Customer-managed encryption key spec for a ModelDeploymentMonitoringJob. If
     * set, this ModelDeploymentMonitoringJob and all sub-resources of this
     * ModelDeploymentMonitoringJob will be secured by this key.
     * </pre>
     *
     * <code>.google.cloud.aiplatform.v1beta1.EncryptionSpec encryption_spec = 21;</code>
     *
     * @return Whether the encryptionSpec field is set.
     */
    public boolean hasEncryptionSpec() {
      return encryptionSpecBuilder_ != null || encryptionSpec_ != null;
    }
    /**
     *
     *
     * <pre>
     * Customer-managed encryption key spec for a ModelDeploymentMonitoringJob. If
     * set, this ModelDeploymentMonitoringJob and all sub-resources of this
     * ModelDeploymentMonitoringJob will be secured by this key.
     * </pre>
     *
     * <code>.google.cloud.aiplatform.v1beta1.EncryptionSpec encryption_spec = 21;</code>
     *
     * @return The encryptionSpec.
     */
    public com.google.cloud.aiplatform.v1beta1.EncryptionSpec getEncryptionSpec() {
      if (encryptionSpecBuilder_ == null) {
        return encryptionSpec_ == null
            ? com.google.cloud.aiplatform.v1beta1.EncryptionSpec.getDefaultInstance()
            : encryptionSpec_;
      } else {
        return encryptionSpecBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Customer-managed encryption key spec for a ModelDeploymentMonitoringJob. If
     * set, this ModelDeploymentMonitoringJob and all sub-resources of this
     * ModelDeploymentMonitoringJob will be secured by this key.
     * </pre>
     *
     * <code>.google.cloud.aiplatform.v1beta1.EncryptionSpec encryption_spec = 21;</code>
     */
    public Builder setEncryptionSpec(com.google.cloud.aiplatform.v1beta1.EncryptionSpec value) {
      if (encryptionSpecBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        encryptionSpec_ = value;
        onChanged();
      } else {
        encryptionSpecBuilder_.setMessage(value);
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * Customer-managed encryption key spec for a ModelDeploymentMonitoringJob. If
     * set, this ModelDeploymentMonitoringJob and all sub-resources of this
     * ModelDeploymentMonitoringJob will be secured by this key.
     * </pre>
     *
     * <code>.google.cloud.aiplatform.v1beta1.EncryptionSpec encryption_spec = 21;</code>
     */
    public Builder setEncryptionSpec(
        com.google.cloud.aiplatform.v1beta1.EncryptionSpec.Builder builderForValue) {
      if (encryptionSpecBuilder_ == null) {
        encryptionSpec_ = builderForValue.build();
        onChanged();
      } else {
        encryptionSpecBuilder_.setMessage(builderForValue.build());
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * Customer-managed encryption key spec for a ModelDeploymentMonitoringJob. If
     * set, this ModelDeploymentMonitoringJob and all sub-resources of this
     * ModelDeploymentMonitoringJob will be secured by this key.
     * </pre>
     *
     * <code>.google.cloud.aiplatform.v1beta1.EncryptionSpec encryption_spec = 21;</code>
     */
    public Builder mergeEncryptionSpec(com.google.cloud.aiplatform.v1beta1.EncryptionSpec value) {
      if (encryptionSpecBuilder_ == null) {
        if (encryptionSpec_ != null) {
          encryptionSpec_ =
              com.google.cloud.aiplatform.v1beta1.EncryptionSpec.newBuilder(encryptionSpec_)
                  .mergeFrom(value)
                  .buildPartial();
        } else {
          encryptionSpec_ = value;
        }
        onChanged();
      } else {
        encryptionSpecBuilder_.mergeFrom(value);
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * Customer-managed encryption key spec for a ModelDeploymentMonitoringJob. If
     * set, this ModelDeploymentMonitoringJob and all sub-resources of this
     * ModelDeploymentMonitoringJob will be secured by this key.
     * </pre>
     *
     * <code>.google.cloud.aiplatform.v1beta1.EncryptionSpec encryption_spec = 21;</code>
     */
    public Builder clearEncryptionSpec() {
      if (encryptionSpecBuilder_ == null) {
        encryptionSpec_ = null;
        onChanged();
      } else {
        encryptionSpec_ = null;
        encryptionSpecBuilder_ = null;
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * Customer-managed encryption key spec for a ModelDeploymentMonitoringJob. If
     * set, this ModelDeploymentMonitoringJob and all sub-resources of this
     * ModelDeploymentMonitoringJob will be secured by this key.
     * </pre>
     *
     * <code>.google.cloud.aiplatform.v1beta1.EncryptionSpec encryption_spec = 21;</code>
     */
    public com.google.cloud.aiplatform.v1beta1.EncryptionSpec.Builder getEncryptionSpecBuilder() {

      onChanged();
      return getEncryptionSpecFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Customer-managed encryption key spec for a ModelDeploymentMonitoringJob. If
     * set, this ModelDeploymentMonitoringJob and all sub-resources of this
     * ModelDeploymentMonitoringJob will be secured by this key.
     * </pre>
     *
     * <code>.google.cloud.aiplatform.v1beta1.EncryptionSpec encryption_spec = 21;</code>
     */
    public com.google.cloud.aiplatform.v1beta1.EncryptionSpecOrBuilder
        getEncryptionSpecOrBuilder() {
      if (encryptionSpecBuilder_ != null) {
        return encryptionSpecBuilder_.getMessageOrBuilder();
      } else {
        return encryptionSpec_ == null
            ? com.google.cloud.aiplatform.v1beta1.EncryptionSpec.getDefaultInstance()
            : encryptionSpec_;
      }
    }
    /**
     *
     *
     * <pre>
     * Customer-managed encryption key spec for a ModelDeploymentMonitoringJob. If
     * set, this ModelDeploymentMonitoringJob and all sub-resources of this
     * ModelDeploymentMonitoringJob will be secured by this key.
     * </pre>
     *
     * <code>.google.cloud.aiplatform.v1beta1.EncryptionSpec encryption_spec = 21;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.aiplatform.v1beta1.EncryptionSpec,
            com.google.cloud.aiplatform.v1beta1.EncryptionSpec.Builder,
            com.google.cloud.aiplatform.v1beta1.EncryptionSpecOrBuilder>
        getEncryptionSpecFieldBuilder() {
      if (encryptionSpecBuilder_ == null) {
        encryptionSpecBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.aiplatform.v1beta1.EncryptionSpec,
                com.google.cloud.aiplatform.v1beta1.EncryptionSpec.Builder,
                com.google.cloud.aiplatform.v1beta1.EncryptionSpecOrBuilder>(
                getEncryptionSpec(), getParentForChildren(), isClean());
        encryptionSpec_ = null;
      }
      return encryptionSpecBuilder_;
    }

    private com.google.rpc.Status error_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.rpc.Status, com.google.rpc.Status.Builder, com.google.rpc.StatusOrBuilder>
        errorBuilder_;
    /**
     *
     *
     * <pre>
     * Output only. Only populated when the job's state is `JOB_STATE_FAILED` or
     * `JOB_STATE_CANCELLED`.
     * </pre>
     *
     * <code>.google.rpc.Status error = 23 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return Whether the error field is set.
     */
    public boolean hasError() {
      return errorBuilder_ != null || error_ != null;
    }
    /**
     *
     *
     * <pre>
     * Output only. Only populated when the job's state is `JOB_STATE_FAILED` or
     * `JOB_STATE_CANCELLED`.
     * </pre>
     *
     * <code>.google.rpc.Status error = 23 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return The error.
     */
    public com.google.rpc.Status getError() {
      if (errorBuilder_ == null) {
        return error_ == null ? com.google.rpc.Status.getDefaultInstance() : error_;
      } else {
        return errorBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. Only populated when the job's state is `JOB_STATE_FAILED` or
     * `JOB_STATE_CANCELLED`.
     * </pre>
     *
     * <code>.google.rpc.Status error = 23 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     */
    public Builder setError(com.google.rpc.Status value) {
      if (errorBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        error_ = value;
        onChanged();
      } else {
        errorBuilder_.setMessage(value);
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Only populated when the job's state is `JOB_STATE_FAILED` or
     * `JOB_STATE_CANCELLED`.
     * </pre>
     *
     * <code>.google.rpc.Status error = 23 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     */
    public Builder setError(com.google.rpc.Status.Builder builderForValue) {
      if (errorBuilder_ == null) {
        error_ = builderForValue.build();
        onChanged();
      } else {
        errorBuilder_.setMessage(builderForValue.build());
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Only populated when the job's state is `JOB_STATE_FAILED` or
     * `JOB_STATE_CANCELLED`.
     * </pre>
     *
     * <code>.google.rpc.Status error = 23 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     */
    public Builder mergeError(com.google.rpc.Status value) {
      if (errorBuilder_ == null) {
        if (error_ != null) {
          error_ = com.google.rpc.Status.newBuilder(error_).mergeFrom(value).buildPartial();
        } else {
          error_ = value;
        }
        onChanged();
      } else {
        errorBuilder_.mergeFrom(value);
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Only populated when the job's state is `JOB_STATE_FAILED` or
     * `JOB_STATE_CANCELLED`.
     * </pre>
     *
     * <code>.google.rpc.Status error = 23 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     */
    public Builder clearError() {
      if (errorBuilder_ == null) {
        error_ = null;
        onChanged();
      } else {
        error_ = null;
        errorBuilder_ = null;
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Only populated when the job's state is `JOB_STATE_FAILED` or
     * `JOB_STATE_CANCELLED`.
     * </pre>
     *
     * <code>.google.rpc.Status error = 23 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     */
    public com.google.rpc.Status.Builder getErrorBuilder() {

      onChanged();
      return getErrorFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Output only. Only populated when the job's state is `JOB_STATE_FAILED` or
     * `JOB_STATE_CANCELLED`.
     * </pre>
     *
     * <code>.google.rpc.Status error = 23 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     */
    public com.google.rpc.StatusOrBuilder getErrorOrBuilder() {
      if (errorBuilder_ != null) {
        return errorBuilder_.getMessageOrBuilder();
      } else {
        return error_ == null ? com.google.rpc.Status.getDefaultInstance() : error_;
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. Only populated when the job's state is `JOB_STATE_FAILED` or
     * `JOB_STATE_CANCELLED`.
     * </pre>
     *
     * <code>.google.rpc.Status error = 23 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.rpc.Status, com.google.rpc.Status.Builder, com.google.rpc.StatusOrBuilder>
        getErrorFieldBuilder() {
      if (errorBuilder_ == null) {
        errorBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.rpc.Status,
                com.google.rpc.Status.Builder,
                com.google.rpc.StatusOrBuilder>(getError(), getParentForChildren(), isClean());
        error_ = null;
      }
      return errorBuilder_;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.cloud.aiplatform.v1beta1.ModelDeploymentMonitoringJob)
  }

  // @@protoc_insertion_point(class_scope:google.cloud.aiplatform.v1beta1.ModelDeploymentMonitoringJob)
  private static final com.google.cloud.aiplatform.v1beta1.ModelDeploymentMonitoringJob
      DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.cloud.aiplatform.v1beta1.ModelDeploymentMonitoringJob();
  }

  public static com.google.cloud.aiplatform.v1beta1.ModelDeploymentMonitoringJob
      getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<ModelDeploymentMonitoringJob> PARSER =
      new com.google.protobuf.AbstractParser<ModelDeploymentMonitoringJob>() {
        @java.lang.Override
        public ModelDeploymentMonitoringJob parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          return new ModelDeploymentMonitoringJob(input, extensionRegistry);
        }
      };

  public static com.google.protobuf.Parser<ModelDeploymentMonitoringJob> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<ModelDeploymentMonitoringJob> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.cloud.aiplatform.v1beta1.ModelDeploymentMonitoringJob
      getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
