/*
 * Copyright 2020 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/cloud/aiplatform/v1beta1/prediction_service.proto

package com.google.cloud.aiplatform.v1beta1;

/**
 *
 *
 * <pre>
 * Response message for [PredictionService.Predict][google.cloud.aiplatform.v1beta1.PredictionService.Predict].
 * </pre>
 *
 * Protobuf type {@code google.cloud.aiplatform.v1beta1.PredictResponse}
 */
public final class PredictResponse extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.cloud.aiplatform.v1beta1.PredictResponse)
    PredictResponseOrBuilder {
  private static final long serialVersionUID = 0L;
  // Use PredictResponse.newBuilder() to construct.
  private PredictResponse(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private PredictResponse() {
    predictions_ = java.util.Collections.emptyList();
    deployedModelId_ = "";
  }

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new PredictResponse();
  }

  @java.lang.Override
  public final com.google.protobuf.UnknownFieldSet getUnknownFields() {
    return this.unknownFields;
  }

  private PredictResponse(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    this();
    if (extensionRegistry == null) {
      throw new java.lang.NullPointerException();
    }
    int mutable_bitField0_ = 0;
    com.google.protobuf.UnknownFieldSet.Builder unknownFields =
        com.google.protobuf.UnknownFieldSet.newBuilder();
    try {
      boolean done = false;
      while (!done) {
        int tag = input.readTag();
        switch (tag) {
          case 0:
            done = true;
            break;
          case 10:
            {
              if (!((mutable_bitField0_ & 0x00000001) != 0)) {
                predictions_ = new java.util.ArrayList<com.google.protobuf.Value>();
                mutable_bitField0_ |= 0x00000001;
              }
              predictions_.add(
                  input.readMessage(com.google.protobuf.Value.parser(), extensionRegistry));
              break;
            }
          case 18:
            {
              java.lang.String s = input.readStringRequireUtf8();

              deployedModelId_ = s;
              break;
            }
          default:
            {
              if (!parseUnknownField(input, unknownFields, extensionRegistry, tag)) {
                done = true;
              }
              break;
            }
        }
      }
    } catch (com.google.protobuf.InvalidProtocolBufferException e) {
      throw e.setUnfinishedMessage(this);
    } catch (java.io.IOException e) {
      throw new com.google.protobuf.InvalidProtocolBufferException(e).setUnfinishedMessage(this);
    } finally {
      if (((mutable_bitField0_ & 0x00000001) != 0)) {
        predictions_ = java.util.Collections.unmodifiableList(predictions_);
      }
      this.unknownFields = unknownFields.build();
      makeExtensionsImmutable();
    }
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.cloud.aiplatform.v1beta1.PredictionServiceProto
        .internal_static_google_cloud_aiplatform_v1beta1_PredictResponse_descriptor;
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.cloud.aiplatform.v1beta1.PredictionServiceProto
        .internal_static_google_cloud_aiplatform_v1beta1_PredictResponse_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.cloud.aiplatform.v1beta1.PredictResponse.class,
            com.google.cloud.aiplatform.v1beta1.PredictResponse.Builder.class);
  }

  public static final int PREDICTIONS_FIELD_NUMBER = 1;
  private java.util.List<com.google.protobuf.Value> predictions_;
  /**
   *
   *
   * <pre>
   * The predictions that are the output of the predictions call.
   * The schema of any single prediction may be specified via Endpoint's
   * DeployedModels' [Model's ][google.cloud.aiplatform.v1beta1.DeployedModel.model]
   * [PredictSchemata's][google.cloud.aiplatform.v1beta1.Model.predict_schemata]
   * [prediction_schema_uri][google.cloud.aiplatform.v1beta1.PredictSchemata.prediction_schema_uri].
   * </pre>
   *
   * <code>repeated .google.protobuf.Value predictions = 1;</code>
   */
  @java.lang.Override
  public java.util.List<com.google.protobuf.Value> getPredictionsList() {
    return predictions_;
  }
  /**
   *
   *
   * <pre>
   * The predictions that are the output of the predictions call.
   * The schema of any single prediction may be specified via Endpoint's
   * DeployedModels' [Model's ][google.cloud.aiplatform.v1beta1.DeployedModel.model]
   * [PredictSchemata's][google.cloud.aiplatform.v1beta1.Model.predict_schemata]
   * [prediction_schema_uri][google.cloud.aiplatform.v1beta1.PredictSchemata.prediction_schema_uri].
   * </pre>
   *
   * <code>repeated .google.protobuf.Value predictions = 1;</code>
   */
  @java.lang.Override
  public java.util.List<? extends com.google.protobuf.ValueOrBuilder>
      getPredictionsOrBuilderList() {
    return predictions_;
  }
  /**
   *
   *
   * <pre>
   * The predictions that are the output of the predictions call.
   * The schema of any single prediction may be specified via Endpoint's
   * DeployedModels' [Model's ][google.cloud.aiplatform.v1beta1.DeployedModel.model]
   * [PredictSchemata's][google.cloud.aiplatform.v1beta1.Model.predict_schemata]
   * [prediction_schema_uri][google.cloud.aiplatform.v1beta1.PredictSchemata.prediction_schema_uri].
   * </pre>
   *
   * <code>repeated .google.protobuf.Value predictions = 1;</code>
   */
  @java.lang.Override
  public int getPredictionsCount() {
    return predictions_.size();
  }
  /**
   *
   *
   * <pre>
   * The predictions that are the output of the predictions call.
   * The schema of any single prediction may be specified via Endpoint's
   * DeployedModels' [Model's ][google.cloud.aiplatform.v1beta1.DeployedModel.model]
   * [PredictSchemata's][google.cloud.aiplatform.v1beta1.Model.predict_schemata]
   * [prediction_schema_uri][google.cloud.aiplatform.v1beta1.PredictSchemata.prediction_schema_uri].
   * </pre>
   *
   * <code>repeated .google.protobuf.Value predictions = 1;</code>
   */
  @java.lang.Override
  public com.google.protobuf.Value getPredictions(int index) {
    return predictions_.get(index);
  }
  /**
   *
   *
   * <pre>
   * The predictions that are the output of the predictions call.
   * The schema of any single prediction may be specified via Endpoint's
   * DeployedModels' [Model's ][google.cloud.aiplatform.v1beta1.DeployedModel.model]
   * [PredictSchemata's][google.cloud.aiplatform.v1beta1.Model.predict_schemata]
   * [prediction_schema_uri][google.cloud.aiplatform.v1beta1.PredictSchemata.prediction_schema_uri].
   * </pre>
   *
   * <code>repeated .google.protobuf.Value predictions = 1;</code>
   */
  @java.lang.Override
  public com.google.protobuf.ValueOrBuilder getPredictionsOrBuilder(int index) {
    return predictions_.get(index);
  }

  public static final int DEPLOYED_MODEL_ID_FIELD_NUMBER = 2;
  private volatile java.lang.Object deployedModelId_;
  /**
   *
   *
   * <pre>
   * ID of the Endpoint's DeployedModel that served this prediction.
   * </pre>
   *
   * <code>string deployed_model_id = 2;</code>
   *
   * @return The deployedModelId.
   */
  @java.lang.Override
  public java.lang.String getDeployedModelId() {
    java.lang.Object ref = deployedModelId_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      deployedModelId_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * ID of the Endpoint's DeployedModel that served this prediction.
   * </pre>
   *
   * <code>string deployed_model_id = 2;</code>
   *
   * @return The bytes for deployedModelId.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getDeployedModelIdBytes() {
    java.lang.Object ref = deployedModelId_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      deployedModelId_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    for (int i = 0; i < predictions_.size(); i++) {
      output.writeMessage(1, predictions_.get(i));
    }
    if (!getDeployedModelIdBytes().isEmpty()) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 2, deployedModelId_);
    }
    unknownFields.writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    for (int i = 0; i < predictions_.size(); i++) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(1, predictions_.get(i));
    }
    if (!getDeployedModelIdBytes().isEmpty()) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(2, deployedModelId_);
    }
    size += unknownFields.getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.cloud.aiplatform.v1beta1.PredictResponse)) {
      return super.equals(obj);
    }
    com.google.cloud.aiplatform.v1beta1.PredictResponse other =
        (com.google.cloud.aiplatform.v1beta1.PredictResponse) obj;

    if (!getPredictionsList().equals(other.getPredictionsList())) return false;
    if (!getDeployedModelId().equals(other.getDeployedModelId())) return false;
    if (!unknownFields.equals(other.unknownFields)) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    if (getPredictionsCount() > 0) {
      hash = (37 * hash) + PREDICTIONS_FIELD_NUMBER;
      hash = (53 * hash) + getPredictionsList().hashCode();
    }
    hash = (37 * hash) + DEPLOYED_MODEL_ID_FIELD_NUMBER;
    hash = (53 * hash) + getDeployedModelId().hashCode();
    hash = (29 * hash) + unknownFields.hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.cloud.aiplatform.v1beta1.PredictResponse parseFrom(
      java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.aiplatform.v1beta1.PredictResponse parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.aiplatform.v1beta1.PredictResponse parseFrom(
      com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.aiplatform.v1beta1.PredictResponse parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.aiplatform.v1beta1.PredictResponse parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.aiplatform.v1beta1.PredictResponse parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.aiplatform.v1beta1.PredictResponse parseFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.aiplatform.v1beta1.PredictResponse parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.aiplatform.v1beta1.PredictResponse parseDelimitedFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.cloud.aiplatform.v1beta1.PredictResponse parseDelimitedFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.aiplatform.v1beta1.PredictResponse parseFrom(
      com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.aiplatform.v1beta1.PredictResponse parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(com.google.cloud.aiplatform.v1beta1.PredictResponse prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }
  /**
   *
   *
   * <pre>
   * Response message for [PredictionService.Predict][google.cloud.aiplatform.v1beta1.PredictionService.Predict].
   * </pre>
   *
   * Protobuf type {@code google.cloud.aiplatform.v1beta1.PredictResponse}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.cloud.aiplatform.v1beta1.PredictResponse)
      com.google.cloud.aiplatform.v1beta1.PredictResponseOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.aiplatform.v1beta1.PredictionServiceProto
          .internal_static_google_cloud_aiplatform_v1beta1_PredictResponse_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.aiplatform.v1beta1.PredictionServiceProto
          .internal_static_google_cloud_aiplatform_v1beta1_PredictResponse_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.aiplatform.v1beta1.PredictResponse.class,
              com.google.cloud.aiplatform.v1beta1.PredictResponse.Builder.class);
    }

    // Construct using com.google.cloud.aiplatform.v1beta1.PredictResponse.newBuilder()
    private Builder() {
      maybeForceBuilderInitialization();
    }

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
      maybeForceBuilderInitialization();
    }

    private void maybeForceBuilderInitialization() {
      if (com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders) {
        getPredictionsFieldBuilder();
      }
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      if (predictionsBuilder_ == null) {
        predictions_ = java.util.Collections.emptyList();
        bitField0_ = (bitField0_ & ~0x00000001);
      } else {
        predictionsBuilder_.clear();
      }
      deployedModelId_ = "";

      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.cloud.aiplatform.v1beta1.PredictionServiceProto
          .internal_static_google_cloud_aiplatform_v1beta1_PredictResponse_descriptor;
    }

    @java.lang.Override
    public com.google.cloud.aiplatform.v1beta1.PredictResponse getDefaultInstanceForType() {
      return com.google.cloud.aiplatform.v1beta1.PredictResponse.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.cloud.aiplatform.v1beta1.PredictResponse build() {
      com.google.cloud.aiplatform.v1beta1.PredictResponse result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.cloud.aiplatform.v1beta1.PredictResponse buildPartial() {
      com.google.cloud.aiplatform.v1beta1.PredictResponse result =
          new com.google.cloud.aiplatform.v1beta1.PredictResponse(this);
      int from_bitField0_ = bitField0_;
      if (predictionsBuilder_ == null) {
        if (((bitField0_ & 0x00000001) != 0)) {
          predictions_ = java.util.Collections.unmodifiableList(predictions_);
          bitField0_ = (bitField0_ & ~0x00000001);
        }
        result.predictions_ = predictions_;
      } else {
        result.predictions_ = predictionsBuilder_.build();
      }
      result.deployedModelId_ = deployedModelId_;
      onBuilt();
      return result;
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.cloud.aiplatform.v1beta1.PredictResponse) {
        return mergeFrom((com.google.cloud.aiplatform.v1beta1.PredictResponse) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(com.google.cloud.aiplatform.v1beta1.PredictResponse other) {
      if (other == com.google.cloud.aiplatform.v1beta1.PredictResponse.getDefaultInstance())
        return this;
      if (predictionsBuilder_ == null) {
        if (!other.predictions_.isEmpty()) {
          if (predictions_.isEmpty()) {
            predictions_ = other.predictions_;
            bitField0_ = (bitField0_ & ~0x00000001);
          } else {
            ensurePredictionsIsMutable();
            predictions_.addAll(other.predictions_);
          }
          onChanged();
        }
      } else {
        if (!other.predictions_.isEmpty()) {
          if (predictionsBuilder_.isEmpty()) {
            predictionsBuilder_.dispose();
            predictionsBuilder_ = null;
            predictions_ = other.predictions_;
            bitField0_ = (bitField0_ & ~0x00000001);
            predictionsBuilder_ =
                com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders
                    ? getPredictionsFieldBuilder()
                    : null;
          } else {
            predictionsBuilder_.addAllMessages(other.predictions_);
          }
        }
      }
      if (!other.getDeployedModelId().isEmpty()) {
        deployedModelId_ = other.deployedModelId_;
        onChanged();
      }
      this.mergeUnknownFields(other.unknownFields);
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      com.google.cloud.aiplatform.v1beta1.PredictResponse parsedMessage = null;
      try {
        parsedMessage = PARSER.parsePartialFrom(input, extensionRegistry);
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        parsedMessage =
            (com.google.cloud.aiplatform.v1beta1.PredictResponse) e.getUnfinishedMessage();
        throw e.unwrapIOException();
      } finally {
        if (parsedMessage != null) {
          mergeFrom(parsedMessage);
        }
      }
      return this;
    }

    private int bitField0_;

    private java.util.List<com.google.protobuf.Value> predictions_ =
        java.util.Collections.emptyList();

    private void ensurePredictionsIsMutable() {
      if (!((bitField0_ & 0x00000001) != 0)) {
        predictions_ = new java.util.ArrayList<com.google.protobuf.Value>(predictions_);
        bitField0_ |= 0x00000001;
      }
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.protobuf.Value,
            com.google.protobuf.Value.Builder,
            com.google.protobuf.ValueOrBuilder>
        predictionsBuilder_;

    /**
     *
     *
     * <pre>
     * The predictions that are the output of the predictions call.
     * The schema of any single prediction may be specified via Endpoint's
     * DeployedModels' [Model's ][google.cloud.aiplatform.v1beta1.DeployedModel.model]
     * [PredictSchemata's][google.cloud.aiplatform.v1beta1.Model.predict_schemata]
     * [prediction_schema_uri][google.cloud.aiplatform.v1beta1.PredictSchemata.prediction_schema_uri].
     * </pre>
     *
     * <code>repeated .google.protobuf.Value predictions = 1;</code>
     */
    public java.util.List<com.google.protobuf.Value> getPredictionsList() {
      if (predictionsBuilder_ == null) {
        return java.util.Collections.unmodifiableList(predictions_);
      } else {
        return predictionsBuilder_.getMessageList();
      }
    }
    /**
     *
     *
     * <pre>
     * The predictions that are the output of the predictions call.
     * The schema of any single prediction may be specified via Endpoint's
     * DeployedModels' [Model's ][google.cloud.aiplatform.v1beta1.DeployedModel.model]
     * [PredictSchemata's][google.cloud.aiplatform.v1beta1.Model.predict_schemata]
     * [prediction_schema_uri][google.cloud.aiplatform.v1beta1.PredictSchemata.prediction_schema_uri].
     * </pre>
     *
     * <code>repeated .google.protobuf.Value predictions = 1;</code>
     */
    public int getPredictionsCount() {
      if (predictionsBuilder_ == null) {
        return predictions_.size();
      } else {
        return predictionsBuilder_.getCount();
      }
    }
    /**
     *
     *
     * <pre>
     * The predictions that are the output of the predictions call.
     * The schema of any single prediction may be specified via Endpoint's
     * DeployedModels' [Model's ][google.cloud.aiplatform.v1beta1.DeployedModel.model]
     * [PredictSchemata's][google.cloud.aiplatform.v1beta1.Model.predict_schemata]
     * [prediction_schema_uri][google.cloud.aiplatform.v1beta1.PredictSchemata.prediction_schema_uri].
     * </pre>
     *
     * <code>repeated .google.protobuf.Value predictions = 1;</code>
     */
    public com.google.protobuf.Value getPredictions(int index) {
      if (predictionsBuilder_ == null) {
        return predictions_.get(index);
      } else {
        return predictionsBuilder_.getMessage(index);
      }
    }
    /**
     *
     *
     * <pre>
     * The predictions that are the output of the predictions call.
     * The schema of any single prediction may be specified via Endpoint's
     * DeployedModels' [Model's ][google.cloud.aiplatform.v1beta1.DeployedModel.model]
     * [PredictSchemata's][google.cloud.aiplatform.v1beta1.Model.predict_schemata]
     * [prediction_schema_uri][google.cloud.aiplatform.v1beta1.PredictSchemata.prediction_schema_uri].
     * </pre>
     *
     * <code>repeated .google.protobuf.Value predictions = 1;</code>
     */
    public Builder setPredictions(int index, com.google.protobuf.Value value) {
      if (predictionsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensurePredictionsIsMutable();
        predictions_.set(index, value);
        onChanged();
      } else {
        predictionsBuilder_.setMessage(index, value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * The predictions that are the output of the predictions call.
     * The schema of any single prediction may be specified via Endpoint's
     * DeployedModels' [Model's ][google.cloud.aiplatform.v1beta1.DeployedModel.model]
     * [PredictSchemata's][google.cloud.aiplatform.v1beta1.Model.predict_schemata]
     * [prediction_schema_uri][google.cloud.aiplatform.v1beta1.PredictSchemata.prediction_schema_uri].
     * </pre>
     *
     * <code>repeated .google.protobuf.Value predictions = 1;</code>
     */
    public Builder setPredictions(int index, com.google.protobuf.Value.Builder builderForValue) {
      if (predictionsBuilder_ == null) {
        ensurePredictionsIsMutable();
        predictions_.set(index, builderForValue.build());
        onChanged();
      } else {
        predictionsBuilder_.setMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * The predictions that are the output of the predictions call.
     * The schema of any single prediction may be specified via Endpoint's
     * DeployedModels' [Model's ][google.cloud.aiplatform.v1beta1.DeployedModel.model]
     * [PredictSchemata's][google.cloud.aiplatform.v1beta1.Model.predict_schemata]
     * [prediction_schema_uri][google.cloud.aiplatform.v1beta1.PredictSchemata.prediction_schema_uri].
     * </pre>
     *
     * <code>repeated .google.protobuf.Value predictions = 1;</code>
     */
    public Builder addPredictions(com.google.protobuf.Value value) {
      if (predictionsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensurePredictionsIsMutable();
        predictions_.add(value);
        onChanged();
      } else {
        predictionsBuilder_.addMessage(value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * The predictions that are the output of the predictions call.
     * The schema of any single prediction may be specified via Endpoint's
     * DeployedModels' [Model's ][google.cloud.aiplatform.v1beta1.DeployedModel.model]
     * [PredictSchemata's][google.cloud.aiplatform.v1beta1.Model.predict_schemata]
     * [prediction_schema_uri][google.cloud.aiplatform.v1beta1.PredictSchemata.prediction_schema_uri].
     * </pre>
     *
     * <code>repeated .google.protobuf.Value predictions = 1;</code>
     */
    public Builder addPredictions(int index, com.google.protobuf.Value value) {
      if (predictionsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensurePredictionsIsMutable();
        predictions_.add(index, value);
        onChanged();
      } else {
        predictionsBuilder_.addMessage(index, value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * The predictions that are the output of the predictions call.
     * The schema of any single prediction may be specified via Endpoint's
     * DeployedModels' [Model's ][google.cloud.aiplatform.v1beta1.DeployedModel.model]
     * [PredictSchemata's][google.cloud.aiplatform.v1beta1.Model.predict_schemata]
     * [prediction_schema_uri][google.cloud.aiplatform.v1beta1.PredictSchemata.prediction_schema_uri].
     * </pre>
     *
     * <code>repeated .google.protobuf.Value predictions = 1;</code>
     */
    public Builder addPredictions(com.google.protobuf.Value.Builder builderForValue) {
      if (predictionsBuilder_ == null) {
        ensurePredictionsIsMutable();
        predictions_.add(builderForValue.build());
        onChanged();
      } else {
        predictionsBuilder_.addMessage(builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * The predictions that are the output of the predictions call.
     * The schema of any single prediction may be specified via Endpoint's
     * DeployedModels' [Model's ][google.cloud.aiplatform.v1beta1.DeployedModel.model]
     * [PredictSchemata's][google.cloud.aiplatform.v1beta1.Model.predict_schemata]
     * [prediction_schema_uri][google.cloud.aiplatform.v1beta1.PredictSchemata.prediction_schema_uri].
     * </pre>
     *
     * <code>repeated .google.protobuf.Value predictions = 1;</code>
     */
    public Builder addPredictions(int index, com.google.protobuf.Value.Builder builderForValue) {
      if (predictionsBuilder_ == null) {
        ensurePredictionsIsMutable();
        predictions_.add(index, builderForValue.build());
        onChanged();
      } else {
        predictionsBuilder_.addMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * The predictions that are the output of the predictions call.
     * The schema of any single prediction may be specified via Endpoint's
     * DeployedModels' [Model's ][google.cloud.aiplatform.v1beta1.DeployedModel.model]
     * [PredictSchemata's][google.cloud.aiplatform.v1beta1.Model.predict_schemata]
     * [prediction_schema_uri][google.cloud.aiplatform.v1beta1.PredictSchemata.prediction_schema_uri].
     * </pre>
     *
     * <code>repeated .google.protobuf.Value predictions = 1;</code>
     */
    public Builder addAllPredictions(
        java.lang.Iterable<? extends com.google.protobuf.Value> values) {
      if (predictionsBuilder_ == null) {
        ensurePredictionsIsMutable();
        com.google.protobuf.AbstractMessageLite.Builder.addAll(values, predictions_);
        onChanged();
      } else {
        predictionsBuilder_.addAllMessages(values);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * The predictions that are the output of the predictions call.
     * The schema of any single prediction may be specified via Endpoint's
     * DeployedModels' [Model's ][google.cloud.aiplatform.v1beta1.DeployedModel.model]
     * [PredictSchemata's][google.cloud.aiplatform.v1beta1.Model.predict_schemata]
     * [prediction_schema_uri][google.cloud.aiplatform.v1beta1.PredictSchemata.prediction_schema_uri].
     * </pre>
     *
     * <code>repeated .google.protobuf.Value predictions = 1;</code>
     */
    public Builder clearPredictions() {
      if (predictionsBuilder_ == null) {
        predictions_ = java.util.Collections.emptyList();
        bitField0_ = (bitField0_ & ~0x00000001);
        onChanged();
      } else {
        predictionsBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * The predictions that are the output of the predictions call.
     * The schema of any single prediction may be specified via Endpoint's
     * DeployedModels' [Model's ][google.cloud.aiplatform.v1beta1.DeployedModel.model]
     * [PredictSchemata's][google.cloud.aiplatform.v1beta1.Model.predict_schemata]
     * [prediction_schema_uri][google.cloud.aiplatform.v1beta1.PredictSchemata.prediction_schema_uri].
     * </pre>
     *
     * <code>repeated .google.protobuf.Value predictions = 1;</code>
     */
    public Builder removePredictions(int index) {
      if (predictionsBuilder_ == null) {
        ensurePredictionsIsMutable();
        predictions_.remove(index);
        onChanged();
      } else {
        predictionsBuilder_.remove(index);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * The predictions that are the output of the predictions call.
     * The schema of any single prediction may be specified via Endpoint's
     * DeployedModels' [Model's ][google.cloud.aiplatform.v1beta1.DeployedModel.model]
     * [PredictSchemata's][google.cloud.aiplatform.v1beta1.Model.predict_schemata]
     * [prediction_schema_uri][google.cloud.aiplatform.v1beta1.PredictSchemata.prediction_schema_uri].
     * </pre>
     *
     * <code>repeated .google.protobuf.Value predictions = 1;</code>
     */
    public com.google.protobuf.Value.Builder getPredictionsBuilder(int index) {
      return getPredictionsFieldBuilder().getBuilder(index);
    }
    /**
     *
     *
     * <pre>
     * The predictions that are the output of the predictions call.
     * The schema of any single prediction may be specified via Endpoint's
     * DeployedModels' [Model's ][google.cloud.aiplatform.v1beta1.DeployedModel.model]
     * [PredictSchemata's][google.cloud.aiplatform.v1beta1.Model.predict_schemata]
     * [prediction_schema_uri][google.cloud.aiplatform.v1beta1.PredictSchemata.prediction_schema_uri].
     * </pre>
     *
     * <code>repeated .google.protobuf.Value predictions = 1;</code>
     */
    public com.google.protobuf.ValueOrBuilder getPredictionsOrBuilder(int index) {
      if (predictionsBuilder_ == null) {
        return predictions_.get(index);
      } else {
        return predictionsBuilder_.getMessageOrBuilder(index);
      }
    }
    /**
     *
     *
     * <pre>
     * The predictions that are the output of the predictions call.
     * The schema of any single prediction may be specified via Endpoint's
     * DeployedModels' [Model's ][google.cloud.aiplatform.v1beta1.DeployedModel.model]
     * [PredictSchemata's][google.cloud.aiplatform.v1beta1.Model.predict_schemata]
     * [prediction_schema_uri][google.cloud.aiplatform.v1beta1.PredictSchemata.prediction_schema_uri].
     * </pre>
     *
     * <code>repeated .google.protobuf.Value predictions = 1;</code>
     */
    public java.util.List<? extends com.google.protobuf.ValueOrBuilder>
        getPredictionsOrBuilderList() {
      if (predictionsBuilder_ != null) {
        return predictionsBuilder_.getMessageOrBuilderList();
      } else {
        return java.util.Collections.unmodifiableList(predictions_);
      }
    }
    /**
     *
     *
     * <pre>
     * The predictions that are the output of the predictions call.
     * The schema of any single prediction may be specified via Endpoint's
     * DeployedModels' [Model's ][google.cloud.aiplatform.v1beta1.DeployedModel.model]
     * [PredictSchemata's][google.cloud.aiplatform.v1beta1.Model.predict_schemata]
     * [prediction_schema_uri][google.cloud.aiplatform.v1beta1.PredictSchemata.prediction_schema_uri].
     * </pre>
     *
     * <code>repeated .google.protobuf.Value predictions = 1;</code>
     */
    public com.google.protobuf.Value.Builder addPredictionsBuilder() {
      return getPredictionsFieldBuilder()
          .addBuilder(com.google.protobuf.Value.getDefaultInstance());
    }
    /**
     *
     *
     * <pre>
     * The predictions that are the output of the predictions call.
     * The schema of any single prediction may be specified via Endpoint's
     * DeployedModels' [Model's ][google.cloud.aiplatform.v1beta1.DeployedModel.model]
     * [PredictSchemata's][google.cloud.aiplatform.v1beta1.Model.predict_schemata]
     * [prediction_schema_uri][google.cloud.aiplatform.v1beta1.PredictSchemata.prediction_schema_uri].
     * </pre>
     *
     * <code>repeated .google.protobuf.Value predictions = 1;</code>
     */
    public com.google.protobuf.Value.Builder addPredictionsBuilder(int index) {
      return getPredictionsFieldBuilder()
          .addBuilder(index, com.google.protobuf.Value.getDefaultInstance());
    }
    /**
     *
     *
     * <pre>
     * The predictions that are the output of the predictions call.
     * The schema of any single prediction may be specified via Endpoint's
     * DeployedModels' [Model's ][google.cloud.aiplatform.v1beta1.DeployedModel.model]
     * [PredictSchemata's][google.cloud.aiplatform.v1beta1.Model.predict_schemata]
     * [prediction_schema_uri][google.cloud.aiplatform.v1beta1.PredictSchemata.prediction_schema_uri].
     * </pre>
     *
     * <code>repeated .google.protobuf.Value predictions = 1;</code>
     */
    public java.util.List<com.google.protobuf.Value.Builder> getPredictionsBuilderList() {
      return getPredictionsFieldBuilder().getBuilderList();
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.protobuf.Value,
            com.google.protobuf.Value.Builder,
            com.google.protobuf.ValueOrBuilder>
        getPredictionsFieldBuilder() {
      if (predictionsBuilder_ == null) {
        predictionsBuilder_ =
            new com.google.protobuf.RepeatedFieldBuilderV3<
                com.google.protobuf.Value,
                com.google.protobuf.Value.Builder,
                com.google.protobuf.ValueOrBuilder>(
                predictions_, ((bitField0_ & 0x00000001) != 0), getParentForChildren(), isClean());
        predictions_ = null;
      }
      return predictionsBuilder_;
    }

    private java.lang.Object deployedModelId_ = "";
    /**
     *
     *
     * <pre>
     * ID of the Endpoint's DeployedModel that served this prediction.
     * </pre>
     *
     * <code>string deployed_model_id = 2;</code>
     *
     * @return The deployedModelId.
     */
    public java.lang.String getDeployedModelId() {
      java.lang.Object ref = deployedModelId_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        deployedModelId_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * ID of the Endpoint's DeployedModel that served this prediction.
     * </pre>
     *
     * <code>string deployed_model_id = 2;</code>
     *
     * @return The bytes for deployedModelId.
     */
    public com.google.protobuf.ByteString getDeployedModelIdBytes() {
      java.lang.Object ref = deployedModelId_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        deployedModelId_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * ID of the Endpoint's DeployedModel that served this prediction.
     * </pre>
     *
     * <code>string deployed_model_id = 2;</code>
     *
     * @param value The deployedModelId to set.
     * @return This builder for chaining.
     */
    public Builder setDeployedModelId(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }

      deployedModelId_ = value;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * ID of the Endpoint's DeployedModel that served this prediction.
     * </pre>
     *
     * <code>string deployed_model_id = 2;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearDeployedModelId() {

      deployedModelId_ = getDefaultInstance().getDeployedModelId();
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * ID of the Endpoint's DeployedModel that served this prediction.
     * </pre>
     *
     * <code>string deployed_model_id = 2;</code>
     *
     * @param value The bytes for deployedModelId to set.
     * @return This builder for chaining.
     */
    public Builder setDeployedModelIdBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);

      deployedModelId_ = value;
      onChanged();
      return this;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.cloud.aiplatform.v1beta1.PredictResponse)
  }

  // @@protoc_insertion_point(class_scope:google.cloud.aiplatform.v1beta1.PredictResponse)
  private static final com.google.cloud.aiplatform.v1beta1.PredictResponse DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.cloud.aiplatform.v1beta1.PredictResponse();
  }

  public static com.google.cloud.aiplatform.v1beta1.PredictResponse getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<PredictResponse> PARSER =
      new com.google.protobuf.AbstractParser<PredictResponse>() {
        @java.lang.Override
        public PredictResponse parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          return new PredictResponse(input, extensionRegistry);
        }
      };

  public static com.google.protobuf.Parser<PredictResponse> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<PredictResponse> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.cloud.aiplatform.v1beta1.PredictResponse getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
