/*
 * Copyright 2020 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/cloud/aiplatform/v1beta1/custom_job.proto

package com.google.cloud.aiplatform.v1beta1;

/**
 *
 *
 * <pre>
 * The spec of a Python packaged code.
 * </pre>
 *
 * Protobuf type {@code google.cloud.aiplatform.v1beta1.PythonPackageSpec}
 */
public final class PythonPackageSpec extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.cloud.aiplatform.v1beta1.PythonPackageSpec)
    PythonPackageSpecOrBuilder {
  private static final long serialVersionUID = 0L;
  // Use PythonPackageSpec.newBuilder() to construct.
  private PythonPackageSpec(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private PythonPackageSpec() {
    executorImageUri_ = "";
    packageUris_ = com.google.protobuf.LazyStringArrayList.EMPTY;
    pythonModule_ = "";
    args_ = com.google.protobuf.LazyStringArrayList.EMPTY;
  }

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new PythonPackageSpec();
  }

  @java.lang.Override
  public final com.google.protobuf.UnknownFieldSet getUnknownFields() {
    return this.unknownFields;
  }

  private PythonPackageSpec(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    this();
    if (extensionRegistry == null) {
      throw new java.lang.NullPointerException();
    }
    int mutable_bitField0_ = 0;
    com.google.protobuf.UnknownFieldSet.Builder unknownFields =
        com.google.protobuf.UnknownFieldSet.newBuilder();
    try {
      boolean done = false;
      while (!done) {
        int tag = input.readTag();
        switch (tag) {
          case 0:
            done = true;
            break;
          case 10:
            {
              java.lang.String s = input.readStringRequireUtf8();

              executorImageUri_ = s;
              break;
            }
          case 18:
            {
              java.lang.String s = input.readStringRequireUtf8();
              if (!((mutable_bitField0_ & 0x00000001) != 0)) {
                packageUris_ = new com.google.protobuf.LazyStringArrayList();
                mutable_bitField0_ |= 0x00000001;
              }
              packageUris_.add(s);
              break;
            }
          case 26:
            {
              java.lang.String s = input.readStringRequireUtf8();

              pythonModule_ = s;
              break;
            }
          case 34:
            {
              java.lang.String s = input.readStringRequireUtf8();
              if (!((mutable_bitField0_ & 0x00000002) != 0)) {
                args_ = new com.google.protobuf.LazyStringArrayList();
                mutable_bitField0_ |= 0x00000002;
              }
              args_.add(s);
              break;
            }
          default:
            {
              if (!parseUnknownField(input, unknownFields, extensionRegistry, tag)) {
                done = true;
              }
              break;
            }
        }
      }
    } catch (com.google.protobuf.InvalidProtocolBufferException e) {
      throw e.setUnfinishedMessage(this);
    } catch (java.io.IOException e) {
      throw new com.google.protobuf.InvalidProtocolBufferException(e).setUnfinishedMessage(this);
    } finally {
      if (((mutable_bitField0_ & 0x00000001) != 0)) {
        packageUris_ = packageUris_.getUnmodifiableView();
      }
      if (((mutable_bitField0_ & 0x00000002) != 0)) {
        args_ = args_.getUnmodifiableView();
      }
      this.unknownFields = unknownFields.build();
      makeExtensionsImmutable();
    }
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.cloud.aiplatform.v1beta1.CustomJobProto
        .internal_static_google_cloud_aiplatform_v1beta1_PythonPackageSpec_descriptor;
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.cloud.aiplatform.v1beta1.CustomJobProto
        .internal_static_google_cloud_aiplatform_v1beta1_PythonPackageSpec_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.cloud.aiplatform.v1beta1.PythonPackageSpec.class,
            com.google.cloud.aiplatform.v1beta1.PythonPackageSpec.Builder.class);
  }

  public static final int EXECUTOR_IMAGE_URI_FIELD_NUMBER = 1;
  private volatile java.lang.Object executorImageUri_;
  /**
   *
   *
   * <pre>
   * Required. The URI of a container image in Artifact Registry that will run the
   * provided Python package. Vertex AI provides a wide range of executor
   * images with pre-installed packages to meet users' various use cases. See
   * the list of [pre-built containers for
   * training](https://cloud.google.com/vertex-ai/docs/training/pre-built-containers).
   * You must use an image from this list.
   * </pre>
   *
   * <code>string executor_image_uri = 1 [(.google.api.field_behavior) = REQUIRED];</code>
   *
   * @return The executorImageUri.
   */
  @java.lang.Override
  public java.lang.String getExecutorImageUri() {
    java.lang.Object ref = executorImageUri_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      executorImageUri_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Required. The URI of a container image in Artifact Registry that will run the
   * provided Python package. Vertex AI provides a wide range of executor
   * images with pre-installed packages to meet users' various use cases. See
   * the list of [pre-built containers for
   * training](https://cloud.google.com/vertex-ai/docs/training/pre-built-containers).
   * You must use an image from this list.
   * </pre>
   *
   * <code>string executor_image_uri = 1 [(.google.api.field_behavior) = REQUIRED];</code>
   *
   * @return The bytes for executorImageUri.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getExecutorImageUriBytes() {
    java.lang.Object ref = executorImageUri_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      executorImageUri_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int PACKAGE_URIS_FIELD_NUMBER = 2;
  private com.google.protobuf.LazyStringList packageUris_;
  /**
   *
   *
   * <pre>
   * Required. The Google Cloud Storage location of the Python package files which are
   * the training program and its dependent packages.
   * The maximum number of package URIs is 100.
   * </pre>
   *
   * <code>repeated string package_uris = 2 [(.google.api.field_behavior) = REQUIRED];</code>
   *
   * @return A list containing the packageUris.
   */
  public com.google.protobuf.ProtocolStringList getPackageUrisList() {
    return packageUris_;
  }
  /**
   *
   *
   * <pre>
   * Required. The Google Cloud Storage location of the Python package files which are
   * the training program and its dependent packages.
   * The maximum number of package URIs is 100.
   * </pre>
   *
   * <code>repeated string package_uris = 2 [(.google.api.field_behavior) = REQUIRED];</code>
   *
   * @return The count of packageUris.
   */
  public int getPackageUrisCount() {
    return packageUris_.size();
  }
  /**
   *
   *
   * <pre>
   * Required. The Google Cloud Storage location of the Python package files which are
   * the training program and its dependent packages.
   * The maximum number of package URIs is 100.
   * </pre>
   *
   * <code>repeated string package_uris = 2 [(.google.api.field_behavior) = REQUIRED];</code>
   *
   * @param index The index of the element to return.
   * @return The packageUris at the given index.
   */
  public java.lang.String getPackageUris(int index) {
    return packageUris_.get(index);
  }
  /**
   *
   *
   * <pre>
   * Required. The Google Cloud Storage location of the Python package files which are
   * the training program and its dependent packages.
   * The maximum number of package URIs is 100.
   * </pre>
   *
   * <code>repeated string package_uris = 2 [(.google.api.field_behavior) = REQUIRED];</code>
   *
   * @param index The index of the value to return.
   * @return The bytes of the packageUris at the given index.
   */
  public com.google.protobuf.ByteString getPackageUrisBytes(int index) {
    return packageUris_.getByteString(index);
  }

  public static final int PYTHON_MODULE_FIELD_NUMBER = 3;
  private volatile java.lang.Object pythonModule_;
  /**
   *
   *
   * <pre>
   * Required. The Python module name to run after installing the packages.
   * </pre>
   *
   * <code>string python_module = 3 [(.google.api.field_behavior) = REQUIRED];</code>
   *
   * @return The pythonModule.
   */
  @java.lang.Override
  public java.lang.String getPythonModule() {
    java.lang.Object ref = pythonModule_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      pythonModule_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Required. The Python module name to run after installing the packages.
   * </pre>
   *
   * <code>string python_module = 3 [(.google.api.field_behavior) = REQUIRED];</code>
   *
   * @return The bytes for pythonModule.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getPythonModuleBytes() {
    java.lang.Object ref = pythonModule_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      pythonModule_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int ARGS_FIELD_NUMBER = 4;
  private com.google.protobuf.LazyStringList args_;
  /**
   *
   *
   * <pre>
   * Command line arguments to be passed to the Python task.
   * </pre>
   *
   * <code>repeated string args = 4;</code>
   *
   * @return A list containing the args.
   */
  public com.google.protobuf.ProtocolStringList getArgsList() {
    return args_;
  }
  /**
   *
   *
   * <pre>
   * Command line arguments to be passed to the Python task.
   * </pre>
   *
   * <code>repeated string args = 4;</code>
   *
   * @return The count of args.
   */
  public int getArgsCount() {
    return args_.size();
  }
  /**
   *
   *
   * <pre>
   * Command line arguments to be passed to the Python task.
   * </pre>
   *
   * <code>repeated string args = 4;</code>
   *
   * @param index The index of the element to return.
   * @return The args at the given index.
   */
  public java.lang.String getArgs(int index) {
    return args_.get(index);
  }
  /**
   *
   *
   * <pre>
   * Command line arguments to be passed to the Python task.
   * </pre>
   *
   * <code>repeated string args = 4;</code>
   *
   * @param index The index of the value to return.
   * @return The bytes of the args at the given index.
   */
  public com.google.protobuf.ByteString getArgsBytes(int index) {
    return args_.getByteString(index);
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    if (!getExecutorImageUriBytes().isEmpty()) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 1, executorImageUri_);
    }
    for (int i = 0; i < packageUris_.size(); i++) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 2, packageUris_.getRaw(i));
    }
    if (!getPythonModuleBytes().isEmpty()) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 3, pythonModule_);
    }
    for (int i = 0; i < args_.size(); i++) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 4, args_.getRaw(i));
    }
    unknownFields.writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    if (!getExecutorImageUriBytes().isEmpty()) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(1, executorImageUri_);
    }
    {
      int dataSize = 0;
      for (int i = 0; i < packageUris_.size(); i++) {
        dataSize += computeStringSizeNoTag(packageUris_.getRaw(i));
      }
      size += dataSize;
      size += 1 * getPackageUrisList().size();
    }
    if (!getPythonModuleBytes().isEmpty()) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(3, pythonModule_);
    }
    {
      int dataSize = 0;
      for (int i = 0; i < args_.size(); i++) {
        dataSize += computeStringSizeNoTag(args_.getRaw(i));
      }
      size += dataSize;
      size += 1 * getArgsList().size();
    }
    size += unknownFields.getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.cloud.aiplatform.v1beta1.PythonPackageSpec)) {
      return super.equals(obj);
    }
    com.google.cloud.aiplatform.v1beta1.PythonPackageSpec other =
        (com.google.cloud.aiplatform.v1beta1.PythonPackageSpec) obj;

    if (!getExecutorImageUri().equals(other.getExecutorImageUri())) return false;
    if (!getPackageUrisList().equals(other.getPackageUrisList())) return false;
    if (!getPythonModule().equals(other.getPythonModule())) return false;
    if (!getArgsList().equals(other.getArgsList())) return false;
    if (!unknownFields.equals(other.unknownFields)) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    hash = (37 * hash) + EXECUTOR_IMAGE_URI_FIELD_NUMBER;
    hash = (53 * hash) + getExecutorImageUri().hashCode();
    if (getPackageUrisCount() > 0) {
      hash = (37 * hash) + PACKAGE_URIS_FIELD_NUMBER;
      hash = (53 * hash) + getPackageUrisList().hashCode();
    }
    hash = (37 * hash) + PYTHON_MODULE_FIELD_NUMBER;
    hash = (53 * hash) + getPythonModule().hashCode();
    if (getArgsCount() > 0) {
      hash = (37 * hash) + ARGS_FIELD_NUMBER;
      hash = (53 * hash) + getArgsList().hashCode();
    }
    hash = (29 * hash) + unknownFields.hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.cloud.aiplatform.v1beta1.PythonPackageSpec parseFrom(
      java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.aiplatform.v1beta1.PythonPackageSpec parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.aiplatform.v1beta1.PythonPackageSpec parseFrom(
      com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.aiplatform.v1beta1.PythonPackageSpec parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.aiplatform.v1beta1.PythonPackageSpec parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.aiplatform.v1beta1.PythonPackageSpec parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.aiplatform.v1beta1.PythonPackageSpec parseFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.aiplatform.v1beta1.PythonPackageSpec parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.aiplatform.v1beta1.PythonPackageSpec parseDelimitedFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.cloud.aiplatform.v1beta1.PythonPackageSpec parseDelimitedFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.aiplatform.v1beta1.PythonPackageSpec parseFrom(
      com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.aiplatform.v1beta1.PythonPackageSpec parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(
      com.google.cloud.aiplatform.v1beta1.PythonPackageSpec prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }
  /**
   *
   *
   * <pre>
   * The spec of a Python packaged code.
   * </pre>
   *
   * Protobuf type {@code google.cloud.aiplatform.v1beta1.PythonPackageSpec}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.cloud.aiplatform.v1beta1.PythonPackageSpec)
      com.google.cloud.aiplatform.v1beta1.PythonPackageSpecOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.aiplatform.v1beta1.CustomJobProto
          .internal_static_google_cloud_aiplatform_v1beta1_PythonPackageSpec_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.aiplatform.v1beta1.CustomJobProto
          .internal_static_google_cloud_aiplatform_v1beta1_PythonPackageSpec_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.aiplatform.v1beta1.PythonPackageSpec.class,
              com.google.cloud.aiplatform.v1beta1.PythonPackageSpec.Builder.class);
    }

    // Construct using com.google.cloud.aiplatform.v1beta1.PythonPackageSpec.newBuilder()
    private Builder() {
      maybeForceBuilderInitialization();
    }

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
      maybeForceBuilderInitialization();
    }

    private void maybeForceBuilderInitialization() {
      if (com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders) {}
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      executorImageUri_ = "";

      packageUris_ = com.google.protobuf.LazyStringArrayList.EMPTY;
      bitField0_ = (bitField0_ & ~0x00000001);
      pythonModule_ = "";

      args_ = com.google.protobuf.LazyStringArrayList.EMPTY;
      bitField0_ = (bitField0_ & ~0x00000002);
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.cloud.aiplatform.v1beta1.CustomJobProto
          .internal_static_google_cloud_aiplatform_v1beta1_PythonPackageSpec_descriptor;
    }

    @java.lang.Override
    public com.google.cloud.aiplatform.v1beta1.PythonPackageSpec getDefaultInstanceForType() {
      return com.google.cloud.aiplatform.v1beta1.PythonPackageSpec.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.cloud.aiplatform.v1beta1.PythonPackageSpec build() {
      com.google.cloud.aiplatform.v1beta1.PythonPackageSpec result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.cloud.aiplatform.v1beta1.PythonPackageSpec buildPartial() {
      com.google.cloud.aiplatform.v1beta1.PythonPackageSpec result =
          new com.google.cloud.aiplatform.v1beta1.PythonPackageSpec(this);
      int from_bitField0_ = bitField0_;
      result.executorImageUri_ = executorImageUri_;
      if (((bitField0_ & 0x00000001) != 0)) {
        packageUris_ = packageUris_.getUnmodifiableView();
        bitField0_ = (bitField0_ & ~0x00000001);
      }
      result.packageUris_ = packageUris_;
      result.pythonModule_ = pythonModule_;
      if (((bitField0_ & 0x00000002) != 0)) {
        args_ = args_.getUnmodifiableView();
        bitField0_ = (bitField0_ & ~0x00000002);
      }
      result.args_ = args_;
      onBuilt();
      return result;
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.cloud.aiplatform.v1beta1.PythonPackageSpec) {
        return mergeFrom((com.google.cloud.aiplatform.v1beta1.PythonPackageSpec) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(com.google.cloud.aiplatform.v1beta1.PythonPackageSpec other) {
      if (other == com.google.cloud.aiplatform.v1beta1.PythonPackageSpec.getDefaultInstance())
        return this;
      if (!other.getExecutorImageUri().isEmpty()) {
        executorImageUri_ = other.executorImageUri_;
        onChanged();
      }
      if (!other.packageUris_.isEmpty()) {
        if (packageUris_.isEmpty()) {
          packageUris_ = other.packageUris_;
          bitField0_ = (bitField0_ & ~0x00000001);
        } else {
          ensurePackageUrisIsMutable();
          packageUris_.addAll(other.packageUris_);
        }
        onChanged();
      }
      if (!other.getPythonModule().isEmpty()) {
        pythonModule_ = other.pythonModule_;
        onChanged();
      }
      if (!other.args_.isEmpty()) {
        if (args_.isEmpty()) {
          args_ = other.args_;
          bitField0_ = (bitField0_ & ~0x00000002);
        } else {
          ensureArgsIsMutable();
          args_.addAll(other.args_);
        }
        onChanged();
      }
      this.mergeUnknownFields(other.unknownFields);
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      com.google.cloud.aiplatform.v1beta1.PythonPackageSpec parsedMessage = null;
      try {
        parsedMessage = PARSER.parsePartialFrom(input, extensionRegistry);
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        parsedMessage =
            (com.google.cloud.aiplatform.v1beta1.PythonPackageSpec) e.getUnfinishedMessage();
        throw e.unwrapIOException();
      } finally {
        if (parsedMessage != null) {
          mergeFrom(parsedMessage);
        }
      }
      return this;
    }

    private int bitField0_;

    private java.lang.Object executorImageUri_ = "";
    /**
     *
     *
     * <pre>
     * Required. The URI of a container image in Artifact Registry that will run the
     * provided Python package. Vertex AI provides a wide range of executor
     * images with pre-installed packages to meet users' various use cases. See
     * the list of [pre-built containers for
     * training](https://cloud.google.com/vertex-ai/docs/training/pre-built-containers).
     * You must use an image from this list.
     * </pre>
     *
     * <code>string executor_image_uri = 1 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return The executorImageUri.
     */
    public java.lang.String getExecutorImageUri() {
      java.lang.Object ref = executorImageUri_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        executorImageUri_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Required. The URI of a container image in Artifact Registry that will run the
     * provided Python package. Vertex AI provides a wide range of executor
     * images with pre-installed packages to meet users' various use cases. See
     * the list of [pre-built containers for
     * training](https://cloud.google.com/vertex-ai/docs/training/pre-built-containers).
     * You must use an image from this list.
     * </pre>
     *
     * <code>string executor_image_uri = 1 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return The bytes for executorImageUri.
     */
    public com.google.protobuf.ByteString getExecutorImageUriBytes() {
      java.lang.Object ref = executorImageUri_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        executorImageUri_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Required. The URI of a container image in Artifact Registry that will run the
     * provided Python package. Vertex AI provides a wide range of executor
     * images with pre-installed packages to meet users' various use cases. See
     * the list of [pre-built containers for
     * training](https://cloud.google.com/vertex-ai/docs/training/pre-built-containers).
     * You must use an image from this list.
     * </pre>
     *
     * <code>string executor_image_uri = 1 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @param value The executorImageUri to set.
     * @return This builder for chaining.
     */
    public Builder setExecutorImageUri(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }

      executorImageUri_ = value;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. The URI of a container image in Artifact Registry that will run the
     * provided Python package. Vertex AI provides a wide range of executor
     * images with pre-installed packages to meet users' various use cases. See
     * the list of [pre-built containers for
     * training](https://cloud.google.com/vertex-ai/docs/training/pre-built-containers).
     * You must use an image from this list.
     * </pre>
     *
     * <code>string executor_image_uri = 1 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearExecutorImageUri() {

      executorImageUri_ = getDefaultInstance().getExecutorImageUri();
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. The URI of a container image in Artifact Registry that will run the
     * provided Python package. Vertex AI provides a wide range of executor
     * images with pre-installed packages to meet users' various use cases. See
     * the list of [pre-built containers for
     * training](https://cloud.google.com/vertex-ai/docs/training/pre-built-containers).
     * You must use an image from this list.
     * </pre>
     *
     * <code>string executor_image_uri = 1 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @param value The bytes for executorImageUri to set.
     * @return This builder for chaining.
     */
    public Builder setExecutorImageUriBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);

      executorImageUri_ = value;
      onChanged();
      return this;
    }

    private com.google.protobuf.LazyStringList packageUris_ =
        com.google.protobuf.LazyStringArrayList.EMPTY;

    private void ensurePackageUrisIsMutable() {
      if (!((bitField0_ & 0x00000001) != 0)) {
        packageUris_ = new com.google.protobuf.LazyStringArrayList(packageUris_);
        bitField0_ |= 0x00000001;
      }
    }
    /**
     *
     *
     * <pre>
     * Required. The Google Cloud Storage location of the Python package files which are
     * the training program and its dependent packages.
     * The maximum number of package URIs is 100.
     * </pre>
     *
     * <code>repeated string package_uris = 2 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return A list containing the packageUris.
     */
    public com.google.protobuf.ProtocolStringList getPackageUrisList() {
      return packageUris_.getUnmodifiableView();
    }
    /**
     *
     *
     * <pre>
     * Required. The Google Cloud Storage location of the Python package files which are
     * the training program and its dependent packages.
     * The maximum number of package URIs is 100.
     * </pre>
     *
     * <code>repeated string package_uris = 2 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return The count of packageUris.
     */
    public int getPackageUrisCount() {
      return packageUris_.size();
    }
    /**
     *
     *
     * <pre>
     * Required. The Google Cloud Storage location of the Python package files which are
     * the training program and its dependent packages.
     * The maximum number of package URIs is 100.
     * </pre>
     *
     * <code>repeated string package_uris = 2 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @param index The index of the element to return.
     * @return The packageUris at the given index.
     */
    public java.lang.String getPackageUris(int index) {
      return packageUris_.get(index);
    }
    /**
     *
     *
     * <pre>
     * Required. The Google Cloud Storage location of the Python package files which are
     * the training program and its dependent packages.
     * The maximum number of package URIs is 100.
     * </pre>
     *
     * <code>repeated string package_uris = 2 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @param index The index of the value to return.
     * @return The bytes of the packageUris at the given index.
     */
    public com.google.protobuf.ByteString getPackageUrisBytes(int index) {
      return packageUris_.getByteString(index);
    }
    /**
     *
     *
     * <pre>
     * Required. The Google Cloud Storage location of the Python package files which are
     * the training program and its dependent packages.
     * The maximum number of package URIs is 100.
     * </pre>
     *
     * <code>repeated string package_uris = 2 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @param index The index to set the value at.
     * @param value The packageUris to set.
     * @return This builder for chaining.
     */
    public Builder setPackageUris(int index, java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      ensurePackageUrisIsMutable();
      packageUris_.set(index, value);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. The Google Cloud Storage location of the Python package files which are
     * the training program and its dependent packages.
     * The maximum number of package URIs is 100.
     * </pre>
     *
     * <code>repeated string package_uris = 2 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @param value The packageUris to add.
     * @return This builder for chaining.
     */
    public Builder addPackageUris(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      ensurePackageUrisIsMutable();
      packageUris_.add(value);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. The Google Cloud Storage location of the Python package files which are
     * the training program and its dependent packages.
     * The maximum number of package URIs is 100.
     * </pre>
     *
     * <code>repeated string package_uris = 2 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @param values The packageUris to add.
     * @return This builder for chaining.
     */
    public Builder addAllPackageUris(java.lang.Iterable<java.lang.String> values) {
      ensurePackageUrisIsMutable();
      com.google.protobuf.AbstractMessageLite.Builder.addAll(values, packageUris_);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. The Google Cloud Storage location of the Python package files which are
     * the training program and its dependent packages.
     * The maximum number of package URIs is 100.
     * </pre>
     *
     * <code>repeated string package_uris = 2 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearPackageUris() {
      packageUris_ = com.google.protobuf.LazyStringArrayList.EMPTY;
      bitField0_ = (bitField0_ & ~0x00000001);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. The Google Cloud Storage location of the Python package files which are
     * the training program and its dependent packages.
     * The maximum number of package URIs is 100.
     * </pre>
     *
     * <code>repeated string package_uris = 2 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @param value The bytes of the packageUris to add.
     * @return This builder for chaining.
     */
    public Builder addPackageUrisBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      ensurePackageUrisIsMutable();
      packageUris_.add(value);
      onChanged();
      return this;
    }

    private java.lang.Object pythonModule_ = "";
    /**
     *
     *
     * <pre>
     * Required. The Python module name to run after installing the packages.
     * </pre>
     *
     * <code>string python_module = 3 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return The pythonModule.
     */
    public java.lang.String getPythonModule() {
      java.lang.Object ref = pythonModule_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        pythonModule_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Required. The Python module name to run after installing the packages.
     * </pre>
     *
     * <code>string python_module = 3 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return The bytes for pythonModule.
     */
    public com.google.protobuf.ByteString getPythonModuleBytes() {
      java.lang.Object ref = pythonModule_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        pythonModule_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Required. The Python module name to run after installing the packages.
     * </pre>
     *
     * <code>string python_module = 3 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @param value The pythonModule to set.
     * @return This builder for chaining.
     */
    public Builder setPythonModule(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }

      pythonModule_ = value;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. The Python module name to run after installing the packages.
     * </pre>
     *
     * <code>string python_module = 3 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearPythonModule() {

      pythonModule_ = getDefaultInstance().getPythonModule();
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. The Python module name to run after installing the packages.
     * </pre>
     *
     * <code>string python_module = 3 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @param value The bytes for pythonModule to set.
     * @return This builder for chaining.
     */
    public Builder setPythonModuleBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);

      pythonModule_ = value;
      onChanged();
      return this;
    }

    private com.google.protobuf.LazyStringList args_ =
        com.google.protobuf.LazyStringArrayList.EMPTY;

    private void ensureArgsIsMutable() {
      if (!((bitField0_ & 0x00000002) != 0)) {
        args_ = new com.google.protobuf.LazyStringArrayList(args_);
        bitField0_ |= 0x00000002;
      }
    }
    /**
     *
     *
     * <pre>
     * Command line arguments to be passed to the Python task.
     * </pre>
     *
     * <code>repeated string args = 4;</code>
     *
     * @return A list containing the args.
     */
    public com.google.protobuf.ProtocolStringList getArgsList() {
      return args_.getUnmodifiableView();
    }
    /**
     *
     *
     * <pre>
     * Command line arguments to be passed to the Python task.
     * </pre>
     *
     * <code>repeated string args = 4;</code>
     *
     * @return The count of args.
     */
    public int getArgsCount() {
      return args_.size();
    }
    /**
     *
     *
     * <pre>
     * Command line arguments to be passed to the Python task.
     * </pre>
     *
     * <code>repeated string args = 4;</code>
     *
     * @param index The index of the element to return.
     * @return The args at the given index.
     */
    public java.lang.String getArgs(int index) {
      return args_.get(index);
    }
    /**
     *
     *
     * <pre>
     * Command line arguments to be passed to the Python task.
     * </pre>
     *
     * <code>repeated string args = 4;</code>
     *
     * @param index The index of the value to return.
     * @return The bytes of the args at the given index.
     */
    public com.google.protobuf.ByteString getArgsBytes(int index) {
      return args_.getByteString(index);
    }
    /**
     *
     *
     * <pre>
     * Command line arguments to be passed to the Python task.
     * </pre>
     *
     * <code>repeated string args = 4;</code>
     *
     * @param index The index to set the value at.
     * @param value The args to set.
     * @return This builder for chaining.
     */
    public Builder setArgs(int index, java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      ensureArgsIsMutable();
      args_.set(index, value);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Command line arguments to be passed to the Python task.
     * </pre>
     *
     * <code>repeated string args = 4;</code>
     *
     * @param value The args to add.
     * @return This builder for chaining.
     */
    public Builder addArgs(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      ensureArgsIsMutable();
      args_.add(value);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Command line arguments to be passed to the Python task.
     * </pre>
     *
     * <code>repeated string args = 4;</code>
     *
     * @param values The args to add.
     * @return This builder for chaining.
     */
    public Builder addAllArgs(java.lang.Iterable<java.lang.String> values) {
      ensureArgsIsMutable();
      com.google.protobuf.AbstractMessageLite.Builder.addAll(values, args_);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Command line arguments to be passed to the Python task.
     * </pre>
     *
     * <code>repeated string args = 4;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearArgs() {
      args_ = com.google.protobuf.LazyStringArrayList.EMPTY;
      bitField0_ = (bitField0_ & ~0x00000002);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Command line arguments to be passed to the Python task.
     * </pre>
     *
     * <code>repeated string args = 4;</code>
     *
     * @param value The bytes of the args to add.
     * @return This builder for chaining.
     */
    public Builder addArgsBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      ensureArgsIsMutable();
      args_.add(value);
      onChanged();
      return this;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.cloud.aiplatform.v1beta1.PythonPackageSpec)
  }

  // @@protoc_insertion_point(class_scope:google.cloud.aiplatform.v1beta1.PythonPackageSpec)
  private static final com.google.cloud.aiplatform.v1beta1.PythonPackageSpec DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.cloud.aiplatform.v1beta1.PythonPackageSpec();
  }

  public static com.google.cloud.aiplatform.v1beta1.PythonPackageSpec getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<PythonPackageSpec> PARSER =
      new com.google.protobuf.AbstractParser<PythonPackageSpec>() {
        @java.lang.Override
        public PythonPackageSpec parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          return new PythonPackageSpec(input, extensionRegistry);
        }
      };

  public static com.google.protobuf.Parser<PythonPackageSpec> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<PythonPackageSpec> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.cloud.aiplatform.v1beta1.PythonPackageSpec getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
