/*
 * Copyright 2020 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/cloud/aiplatform/v1beta1/job_service.proto

package com.google.cloud.aiplatform.v1beta1;

/**
 *
 *
 * <pre>
 * Request message for
 * [JobService.SearchModelDeploymentMonitoringStatsAnomalies][google.cloud.aiplatform.v1beta1.JobService.SearchModelDeploymentMonitoringStatsAnomalies].
 * </pre>
 *
 * Protobuf type {@code
 * google.cloud.aiplatform.v1beta1.SearchModelDeploymentMonitoringStatsAnomaliesRequest}
 */
public final class SearchModelDeploymentMonitoringStatsAnomaliesRequest
    extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.cloud.aiplatform.v1beta1.SearchModelDeploymentMonitoringStatsAnomaliesRequest)
    SearchModelDeploymentMonitoringStatsAnomaliesRequestOrBuilder {
  private static final long serialVersionUID = 0L;
  // Use SearchModelDeploymentMonitoringStatsAnomaliesRequest.newBuilder() to construct.
  private SearchModelDeploymentMonitoringStatsAnomaliesRequest(
      com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private SearchModelDeploymentMonitoringStatsAnomaliesRequest() {
    modelDeploymentMonitoringJob_ = "";
    deployedModelId_ = "";
    featureDisplayName_ = "";
    objectives_ = java.util.Collections.emptyList();
    pageToken_ = "";
  }

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new SearchModelDeploymentMonitoringStatsAnomaliesRequest();
  }

  @java.lang.Override
  public final com.google.protobuf.UnknownFieldSet getUnknownFields() {
    return this.unknownFields;
  }

  private SearchModelDeploymentMonitoringStatsAnomaliesRequest(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    this();
    if (extensionRegistry == null) {
      throw new java.lang.NullPointerException();
    }
    int mutable_bitField0_ = 0;
    com.google.protobuf.UnknownFieldSet.Builder unknownFields =
        com.google.protobuf.UnknownFieldSet.newBuilder();
    try {
      boolean done = false;
      while (!done) {
        int tag = input.readTag();
        switch (tag) {
          case 0:
            done = true;
            break;
          case 10:
            {
              java.lang.String s = input.readStringRequireUtf8();

              modelDeploymentMonitoringJob_ = s;
              break;
            }
          case 18:
            {
              java.lang.String s = input.readStringRequireUtf8();

              deployedModelId_ = s;
              break;
            }
          case 26:
            {
              java.lang.String s = input.readStringRequireUtf8();

              featureDisplayName_ = s;
              break;
            }
          case 34:
            {
              if (!((mutable_bitField0_ & 0x00000001) != 0)) {
                objectives_ =
                    new java.util.ArrayList<
                        com.google.cloud.aiplatform.v1beta1
                            .SearchModelDeploymentMonitoringStatsAnomaliesRequest
                            .StatsAnomaliesObjective>();
                mutable_bitField0_ |= 0x00000001;
              }
              objectives_.add(
                  input.readMessage(
                      com.google.cloud.aiplatform.v1beta1
                          .SearchModelDeploymentMonitoringStatsAnomaliesRequest
                          .StatsAnomaliesObjective.parser(),
                      extensionRegistry));
              break;
            }
          case 40:
            {
              pageSize_ = input.readInt32();
              break;
            }
          case 50:
            {
              java.lang.String s = input.readStringRequireUtf8();

              pageToken_ = s;
              break;
            }
          case 58:
            {
              com.google.protobuf.Timestamp.Builder subBuilder = null;
              if (startTime_ != null) {
                subBuilder = startTime_.toBuilder();
              }
              startTime_ =
                  input.readMessage(com.google.protobuf.Timestamp.parser(), extensionRegistry);
              if (subBuilder != null) {
                subBuilder.mergeFrom(startTime_);
                startTime_ = subBuilder.buildPartial();
              }

              break;
            }
          case 66:
            {
              com.google.protobuf.Timestamp.Builder subBuilder = null;
              if (endTime_ != null) {
                subBuilder = endTime_.toBuilder();
              }
              endTime_ =
                  input.readMessage(com.google.protobuf.Timestamp.parser(), extensionRegistry);
              if (subBuilder != null) {
                subBuilder.mergeFrom(endTime_);
                endTime_ = subBuilder.buildPartial();
              }

              break;
            }
          default:
            {
              if (!parseUnknownField(input, unknownFields, extensionRegistry, tag)) {
                done = true;
              }
              break;
            }
        }
      }
    } catch (com.google.protobuf.InvalidProtocolBufferException e) {
      throw e.setUnfinishedMessage(this);
    } catch (java.io.IOException e) {
      throw new com.google.protobuf.InvalidProtocolBufferException(e).setUnfinishedMessage(this);
    } finally {
      if (((mutable_bitField0_ & 0x00000001) != 0)) {
        objectives_ = java.util.Collections.unmodifiableList(objectives_);
      }
      this.unknownFields = unknownFields.build();
      makeExtensionsImmutable();
    }
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.cloud.aiplatform.v1beta1.JobServiceProto
        .internal_static_google_cloud_aiplatform_v1beta1_SearchModelDeploymentMonitoringStatsAnomaliesRequest_descriptor;
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.cloud.aiplatform.v1beta1.JobServiceProto
        .internal_static_google_cloud_aiplatform_v1beta1_SearchModelDeploymentMonitoringStatsAnomaliesRequest_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.cloud.aiplatform.v1beta1.SearchModelDeploymentMonitoringStatsAnomaliesRequest
                .class,
            com.google.cloud.aiplatform.v1beta1.SearchModelDeploymentMonitoringStatsAnomaliesRequest
                .Builder.class);
  }

  public interface StatsAnomaliesObjectiveOrBuilder
      extends
      // @@protoc_insertion_point(interface_extends:google.cloud.aiplatform.v1beta1.SearchModelDeploymentMonitoringStatsAnomaliesRequest.StatsAnomaliesObjective)
      com.google.protobuf.MessageOrBuilder {

    /**
     * <code>.google.cloud.aiplatform.v1beta1.ModelDeploymentMonitoringObjectiveType type = 1;
     * </code>
     *
     * @return The enum numeric value on the wire for type.
     */
    int getTypeValue();
    /**
     * <code>.google.cloud.aiplatform.v1beta1.ModelDeploymentMonitoringObjectiveType type = 1;
     * </code>
     *
     * @return The type.
     */
    com.google.cloud.aiplatform.v1beta1.ModelDeploymentMonitoringObjectiveType getType();

    /**
     *
     *
     * <pre>
     * If set, all attribution scores between
     * [SearchModelDeploymentMonitoringStatsAnomaliesRequest.start_time][google.cloud.aiplatform.v1beta1.SearchModelDeploymentMonitoringStatsAnomaliesRequest.start_time] and
     * [SearchModelDeploymentMonitoringStatsAnomaliesRequest.end_time][google.cloud.aiplatform.v1beta1.SearchModelDeploymentMonitoringStatsAnomaliesRequest.end_time] are
     * fetched, and page token doesn't take affect in this case.
     * Only used to retrieve attribution score for the top Features which has
     * the highest attribution score in the latest monitoring run.
     * </pre>
     *
     * <code>int32 top_feature_count = 4;</code>
     *
     * @return The topFeatureCount.
     */
    int getTopFeatureCount();
  }
  /**
   *
   *
   * <pre>
   * Stats requested for specific objective.
   * </pre>
   *
   * Protobuf type {@code
   * google.cloud.aiplatform.v1beta1.SearchModelDeploymentMonitoringStatsAnomaliesRequest.StatsAnomaliesObjective}
   */
  public static final class StatsAnomaliesObjective extends com.google.protobuf.GeneratedMessageV3
      implements
      // @@protoc_insertion_point(message_implements:google.cloud.aiplatform.v1beta1.SearchModelDeploymentMonitoringStatsAnomaliesRequest.StatsAnomaliesObjective)
      StatsAnomaliesObjectiveOrBuilder {
    private static final long serialVersionUID = 0L;
    // Use StatsAnomaliesObjective.newBuilder() to construct.
    private StatsAnomaliesObjective(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
      super(builder);
    }

    private StatsAnomaliesObjective() {
      type_ = 0;
    }

    @java.lang.Override
    @SuppressWarnings({"unused"})
    protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
      return new StatsAnomaliesObjective();
    }

    @java.lang.Override
    public final com.google.protobuf.UnknownFieldSet getUnknownFields() {
      return this.unknownFields;
    }

    private StatsAnomaliesObjective(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      this();
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      com.google.protobuf.UnknownFieldSet.Builder unknownFields =
          com.google.protobuf.UnknownFieldSet.newBuilder();
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 8:
              {
                int rawValue = input.readEnum();

                type_ = rawValue;
                break;
              }
            case 32:
              {
                topFeatureCount_ = input.readInt32();
                break;
              }
            default:
              {
                if (!parseUnknownField(input, unknownFields, extensionRegistry, tag)) {
                  done = true;
                }
                break;
              }
          }
        }
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.setUnfinishedMessage(this);
      } catch (java.io.IOException e) {
        throw new com.google.protobuf.InvalidProtocolBufferException(e).setUnfinishedMessage(this);
      } finally {
        this.unknownFields = unknownFields.build();
        makeExtensionsImmutable();
      }
    }

    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.aiplatform.v1beta1.JobServiceProto
          .internal_static_google_cloud_aiplatform_v1beta1_SearchModelDeploymentMonitoringStatsAnomaliesRequest_StatsAnomaliesObjective_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.aiplatform.v1beta1.JobServiceProto
          .internal_static_google_cloud_aiplatform_v1beta1_SearchModelDeploymentMonitoringStatsAnomaliesRequest_StatsAnomaliesObjective_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.aiplatform.v1beta1
                  .SearchModelDeploymentMonitoringStatsAnomaliesRequest.StatsAnomaliesObjective
                  .class,
              com.google.cloud.aiplatform.v1beta1
                  .SearchModelDeploymentMonitoringStatsAnomaliesRequest.StatsAnomaliesObjective
                  .Builder.class);
    }

    public static final int TYPE_FIELD_NUMBER = 1;
    private int type_;
    /**
     * <code>.google.cloud.aiplatform.v1beta1.ModelDeploymentMonitoringObjectiveType type = 1;
     * </code>
     *
     * @return The enum numeric value on the wire for type.
     */
    @java.lang.Override
    public int getTypeValue() {
      return type_;
    }
    /**
     * <code>.google.cloud.aiplatform.v1beta1.ModelDeploymentMonitoringObjectiveType type = 1;
     * </code>
     *
     * @return The type.
     */
    @java.lang.Override
    public com.google.cloud.aiplatform.v1beta1.ModelDeploymentMonitoringObjectiveType getType() {
      @SuppressWarnings("deprecation")
      com.google.cloud.aiplatform.v1beta1.ModelDeploymentMonitoringObjectiveType result =
          com.google.cloud.aiplatform.v1beta1.ModelDeploymentMonitoringObjectiveType.valueOf(type_);
      return result == null
          ? com.google.cloud.aiplatform.v1beta1.ModelDeploymentMonitoringObjectiveType.UNRECOGNIZED
          : result;
    }

    public static final int TOP_FEATURE_COUNT_FIELD_NUMBER = 4;
    private int topFeatureCount_;
    /**
     *
     *
     * <pre>
     * If set, all attribution scores between
     * [SearchModelDeploymentMonitoringStatsAnomaliesRequest.start_time][google.cloud.aiplatform.v1beta1.SearchModelDeploymentMonitoringStatsAnomaliesRequest.start_time] and
     * [SearchModelDeploymentMonitoringStatsAnomaliesRequest.end_time][google.cloud.aiplatform.v1beta1.SearchModelDeploymentMonitoringStatsAnomaliesRequest.end_time] are
     * fetched, and page token doesn't take affect in this case.
     * Only used to retrieve attribution score for the top Features which has
     * the highest attribution score in the latest monitoring run.
     * </pre>
     *
     * <code>int32 top_feature_count = 4;</code>
     *
     * @return The topFeatureCount.
     */
    @java.lang.Override
    public int getTopFeatureCount() {
      return topFeatureCount_;
    }

    private byte memoizedIsInitialized = -1;

    @java.lang.Override
    public final boolean isInitialized() {
      byte isInitialized = memoizedIsInitialized;
      if (isInitialized == 1) return true;
      if (isInitialized == 0) return false;

      memoizedIsInitialized = 1;
      return true;
    }

    @java.lang.Override
    public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
      if (type_
          != com.google.cloud.aiplatform.v1beta1.ModelDeploymentMonitoringObjectiveType
              .MODEL_DEPLOYMENT_MONITORING_OBJECTIVE_TYPE_UNSPECIFIED
              .getNumber()) {
        output.writeEnum(1, type_);
      }
      if (topFeatureCount_ != 0) {
        output.writeInt32(4, topFeatureCount_);
      }
      unknownFields.writeTo(output);
    }

    @java.lang.Override
    public int getSerializedSize() {
      int size = memoizedSize;
      if (size != -1) return size;

      size = 0;
      if (type_
          != com.google.cloud.aiplatform.v1beta1.ModelDeploymentMonitoringObjectiveType
              .MODEL_DEPLOYMENT_MONITORING_OBJECTIVE_TYPE_UNSPECIFIED
              .getNumber()) {
        size += com.google.protobuf.CodedOutputStream.computeEnumSize(1, type_);
      }
      if (topFeatureCount_ != 0) {
        size += com.google.protobuf.CodedOutputStream.computeInt32Size(4, topFeatureCount_);
      }
      size += unknownFields.getSerializedSize();
      memoizedSize = size;
      return size;
    }

    @java.lang.Override
    public boolean equals(final java.lang.Object obj) {
      if (obj == this) {
        return true;
      }
      if (!(obj
          instanceof
          com.google.cloud.aiplatform.v1beta1.SearchModelDeploymentMonitoringStatsAnomaliesRequest
              .StatsAnomaliesObjective)) {
        return super.equals(obj);
      }
      com.google.cloud.aiplatform.v1beta1.SearchModelDeploymentMonitoringStatsAnomaliesRequest
              .StatsAnomaliesObjective
          other =
              (com.google.cloud.aiplatform.v1beta1
                      .SearchModelDeploymentMonitoringStatsAnomaliesRequest.StatsAnomaliesObjective)
                  obj;

      if (type_ != other.type_) return false;
      if (getTopFeatureCount() != other.getTopFeatureCount()) return false;
      if (!unknownFields.equals(other.unknownFields)) return false;
      return true;
    }

    @java.lang.Override
    public int hashCode() {
      if (memoizedHashCode != 0) {
        return memoizedHashCode;
      }
      int hash = 41;
      hash = (19 * hash) + getDescriptor().hashCode();
      hash = (37 * hash) + TYPE_FIELD_NUMBER;
      hash = (53 * hash) + type_;
      hash = (37 * hash) + TOP_FEATURE_COUNT_FIELD_NUMBER;
      hash = (53 * hash) + getTopFeatureCount();
      hash = (29 * hash) + unknownFields.hashCode();
      memoizedHashCode = hash;
      return hash;
    }

    public static com.google.cloud.aiplatform.v1beta1
            .SearchModelDeploymentMonitoringStatsAnomaliesRequest.StatsAnomaliesObjective
        parseFrom(java.nio.ByteBuffer data)
            throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.aiplatform.v1beta1
            .SearchModelDeploymentMonitoringStatsAnomaliesRequest.StatsAnomaliesObjective
        parseFrom(
            java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.aiplatform.v1beta1
            .SearchModelDeploymentMonitoringStatsAnomaliesRequest.StatsAnomaliesObjective
        parseFrom(com.google.protobuf.ByteString data)
            throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.aiplatform.v1beta1
            .SearchModelDeploymentMonitoringStatsAnomaliesRequest.StatsAnomaliesObjective
        parseFrom(
            com.google.protobuf.ByteString data,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.aiplatform.v1beta1
            .SearchModelDeploymentMonitoringStatsAnomaliesRequest.StatsAnomaliesObjective
        parseFrom(byte[] data) throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.aiplatform.v1beta1
            .SearchModelDeploymentMonitoringStatsAnomaliesRequest.StatsAnomaliesObjective
        parseFrom(byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.aiplatform.v1beta1
            .SearchModelDeploymentMonitoringStatsAnomaliesRequest.StatsAnomaliesObjective
        parseFrom(java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.cloud.aiplatform.v1beta1
            .SearchModelDeploymentMonitoringStatsAnomaliesRequest.StatsAnomaliesObjective
        parseFrom(
            java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.cloud.aiplatform.v1beta1
            .SearchModelDeploymentMonitoringStatsAnomaliesRequest.StatsAnomaliesObjective
        parseDelimitedFrom(java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
    }

    public static com.google.cloud.aiplatform.v1beta1
            .SearchModelDeploymentMonitoringStatsAnomaliesRequest.StatsAnomaliesObjective
        parseDelimitedFrom(
            java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.cloud.aiplatform.v1beta1
            .SearchModelDeploymentMonitoringStatsAnomaliesRequest.StatsAnomaliesObjective
        parseFrom(com.google.protobuf.CodedInputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.cloud.aiplatform.v1beta1
            .SearchModelDeploymentMonitoringStatsAnomaliesRequest.StatsAnomaliesObjective
        parseFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    @java.lang.Override
    public Builder newBuilderForType() {
      return newBuilder();
    }

    public static Builder newBuilder() {
      return DEFAULT_INSTANCE.toBuilder();
    }

    public static Builder newBuilder(
        com.google.cloud.aiplatform.v1beta1.SearchModelDeploymentMonitoringStatsAnomaliesRequest
                .StatsAnomaliesObjective
            prototype) {
      return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }

    @java.lang.Override
    public Builder toBuilder() {
      return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
    }

    @java.lang.Override
    protected Builder newBuilderForType(
        com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      Builder builder = new Builder(parent);
      return builder;
    }
    /**
     *
     *
     * <pre>
     * Stats requested for specific objective.
     * </pre>
     *
     * Protobuf type {@code
     * google.cloud.aiplatform.v1beta1.SearchModelDeploymentMonitoringStatsAnomaliesRequest.StatsAnomaliesObjective}
     */
    public static final class Builder
        extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
        implements
        // @@protoc_insertion_point(builder_implements:google.cloud.aiplatform.v1beta1.SearchModelDeploymentMonitoringStatsAnomaliesRequest.StatsAnomaliesObjective)
        com.google.cloud.aiplatform.v1beta1.SearchModelDeploymentMonitoringStatsAnomaliesRequest
            .StatsAnomaliesObjectiveOrBuilder {
      public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
        return com.google.cloud.aiplatform.v1beta1.JobServiceProto
            .internal_static_google_cloud_aiplatform_v1beta1_SearchModelDeploymentMonitoringStatsAnomaliesRequest_StatsAnomaliesObjective_descriptor;
      }

      @java.lang.Override
      protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return com.google.cloud.aiplatform.v1beta1.JobServiceProto
            .internal_static_google_cloud_aiplatform_v1beta1_SearchModelDeploymentMonitoringStatsAnomaliesRequest_StatsAnomaliesObjective_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                com.google.cloud.aiplatform.v1beta1
                    .SearchModelDeploymentMonitoringStatsAnomaliesRequest.StatsAnomaliesObjective
                    .class,
                com.google.cloud.aiplatform.v1beta1
                    .SearchModelDeploymentMonitoringStatsAnomaliesRequest.StatsAnomaliesObjective
                    .Builder.class);
      }

      // Construct using
      // com.google.cloud.aiplatform.v1beta1.SearchModelDeploymentMonitoringStatsAnomaliesRequest.StatsAnomaliesObjective.newBuilder()
      private Builder() {
        maybeForceBuilderInitialization();
      }

      private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
        super(parent);
        maybeForceBuilderInitialization();
      }

      private void maybeForceBuilderInitialization() {
        if (com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders) {}
      }

      @java.lang.Override
      public Builder clear() {
        super.clear();
        type_ = 0;

        topFeatureCount_ = 0;

        return this;
      }

      @java.lang.Override
      public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
        return com.google.cloud.aiplatform.v1beta1.JobServiceProto
            .internal_static_google_cloud_aiplatform_v1beta1_SearchModelDeploymentMonitoringStatsAnomaliesRequest_StatsAnomaliesObjective_descriptor;
      }

      @java.lang.Override
      public com.google.cloud.aiplatform.v1beta1
              .SearchModelDeploymentMonitoringStatsAnomaliesRequest.StatsAnomaliesObjective
          getDefaultInstanceForType() {
        return com.google.cloud.aiplatform.v1beta1
            .SearchModelDeploymentMonitoringStatsAnomaliesRequest.StatsAnomaliesObjective
            .getDefaultInstance();
      }

      @java.lang.Override
      public com.google.cloud.aiplatform.v1beta1
              .SearchModelDeploymentMonitoringStatsAnomaliesRequest.StatsAnomaliesObjective
          build() {
        com.google.cloud.aiplatform.v1beta1.SearchModelDeploymentMonitoringStatsAnomaliesRequest
                .StatsAnomaliesObjective
            result = buildPartial();
        if (!result.isInitialized()) {
          throw newUninitializedMessageException(result);
        }
        return result;
      }

      @java.lang.Override
      public com.google.cloud.aiplatform.v1beta1
              .SearchModelDeploymentMonitoringStatsAnomaliesRequest.StatsAnomaliesObjective
          buildPartial() {
        com.google.cloud.aiplatform.v1beta1.SearchModelDeploymentMonitoringStatsAnomaliesRequest
                .StatsAnomaliesObjective
            result =
                new com.google.cloud.aiplatform.v1beta1
                    .SearchModelDeploymentMonitoringStatsAnomaliesRequest.StatsAnomaliesObjective(
                    this);
        result.type_ = type_;
        result.topFeatureCount_ = topFeatureCount_;
        onBuilt();
        return result;
      }

      @java.lang.Override
      public Builder clone() {
        return super.clone();
      }

      @java.lang.Override
      public Builder setField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.setField(field, value);
      }

      @java.lang.Override
      public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
        return super.clearField(field);
      }

      @java.lang.Override
      public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
        return super.clearOneof(oneof);
      }

      @java.lang.Override
      public Builder setRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          int index,
          java.lang.Object value) {
        return super.setRepeatedField(field, index, value);
      }

      @java.lang.Override
      public Builder addRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.addRepeatedField(field, value);
      }

      @java.lang.Override
      public Builder mergeFrom(com.google.protobuf.Message other) {
        if (other
            instanceof
            com.google.cloud.aiplatform.v1beta1.SearchModelDeploymentMonitoringStatsAnomaliesRequest
                .StatsAnomaliesObjective) {
          return mergeFrom(
              (com.google.cloud.aiplatform.v1beta1
                      .SearchModelDeploymentMonitoringStatsAnomaliesRequest.StatsAnomaliesObjective)
                  other);
        } else {
          super.mergeFrom(other);
          return this;
        }
      }

      public Builder mergeFrom(
          com.google.cloud.aiplatform.v1beta1.SearchModelDeploymentMonitoringStatsAnomaliesRequest
                  .StatsAnomaliesObjective
              other) {
        if (other
            == com.google.cloud.aiplatform.v1beta1
                .SearchModelDeploymentMonitoringStatsAnomaliesRequest.StatsAnomaliesObjective
                .getDefaultInstance()) return this;
        if (other.type_ != 0) {
          setTypeValue(other.getTypeValue());
        }
        if (other.getTopFeatureCount() != 0) {
          setTopFeatureCount(other.getTopFeatureCount());
        }
        this.mergeUnknownFields(other.unknownFields);
        onChanged();
        return this;
      }

      @java.lang.Override
      public final boolean isInitialized() {
        return true;
      }

      @java.lang.Override
      public Builder mergeFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        com.google.cloud.aiplatform.v1beta1.SearchModelDeploymentMonitoringStatsAnomaliesRequest
                .StatsAnomaliesObjective
            parsedMessage = null;
        try {
          parsedMessage = PARSER.parsePartialFrom(input, extensionRegistry);
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          parsedMessage =
              (com.google.cloud.aiplatform.v1beta1
                      .SearchModelDeploymentMonitoringStatsAnomaliesRequest.StatsAnomaliesObjective)
                  e.getUnfinishedMessage();
          throw e.unwrapIOException();
        } finally {
          if (parsedMessage != null) {
            mergeFrom(parsedMessage);
          }
        }
        return this;
      }

      private int type_ = 0;
      /**
       * <code>.google.cloud.aiplatform.v1beta1.ModelDeploymentMonitoringObjectiveType type = 1;
       * </code>
       *
       * @return The enum numeric value on the wire for type.
       */
      @java.lang.Override
      public int getTypeValue() {
        return type_;
      }
      /**
       * <code>.google.cloud.aiplatform.v1beta1.ModelDeploymentMonitoringObjectiveType type = 1;
       * </code>
       *
       * @param value The enum numeric value on the wire for type to set.
       * @return This builder for chaining.
       */
      public Builder setTypeValue(int value) {

        type_ = value;
        onChanged();
        return this;
      }
      /**
       * <code>.google.cloud.aiplatform.v1beta1.ModelDeploymentMonitoringObjectiveType type = 1;
       * </code>
       *
       * @return The type.
       */
      @java.lang.Override
      public com.google.cloud.aiplatform.v1beta1.ModelDeploymentMonitoringObjectiveType getType() {
        @SuppressWarnings("deprecation")
        com.google.cloud.aiplatform.v1beta1.ModelDeploymentMonitoringObjectiveType result =
            com.google.cloud.aiplatform.v1beta1.ModelDeploymentMonitoringObjectiveType.valueOf(
                type_);
        return result == null
            ? com.google.cloud.aiplatform.v1beta1.ModelDeploymentMonitoringObjectiveType
                .UNRECOGNIZED
            : result;
      }
      /**
       * <code>.google.cloud.aiplatform.v1beta1.ModelDeploymentMonitoringObjectiveType type = 1;
       * </code>
       *
       * @param value The type to set.
       * @return This builder for chaining.
       */
      public Builder setType(
          com.google.cloud.aiplatform.v1beta1.ModelDeploymentMonitoringObjectiveType value) {
        if (value == null) {
          throw new NullPointerException();
        }

        type_ = value.getNumber();
        onChanged();
        return this;
      }
      /**
       * <code>.google.cloud.aiplatform.v1beta1.ModelDeploymentMonitoringObjectiveType type = 1;
       * </code>
       *
       * @return This builder for chaining.
       */
      public Builder clearType() {

        type_ = 0;
        onChanged();
        return this;
      }

      private int topFeatureCount_;
      /**
       *
       *
       * <pre>
       * If set, all attribution scores between
       * [SearchModelDeploymentMonitoringStatsAnomaliesRequest.start_time][google.cloud.aiplatform.v1beta1.SearchModelDeploymentMonitoringStatsAnomaliesRequest.start_time] and
       * [SearchModelDeploymentMonitoringStatsAnomaliesRequest.end_time][google.cloud.aiplatform.v1beta1.SearchModelDeploymentMonitoringStatsAnomaliesRequest.end_time] are
       * fetched, and page token doesn't take affect in this case.
       * Only used to retrieve attribution score for the top Features which has
       * the highest attribution score in the latest monitoring run.
       * </pre>
       *
       * <code>int32 top_feature_count = 4;</code>
       *
       * @return The topFeatureCount.
       */
      @java.lang.Override
      public int getTopFeatureCount() {
        return topFeatureCount_;
      }
      /**
       *
       *
       * <pre>
       * If set, all attribution scores between
       * [SearchModelDeploymentMonitoringStatsAnomaliesRequest.start_time][google.cloud.aiplatform.v1beta1.SearchModelDeploymentMonitoringStatsAnomaliesRequest.start_time] and
       * [SearchModelDeploymentMonitoringStatsAnomaliesRequest.end_time][google.cloud.aiplatform.v1beta1.SearchModelDeploymentMonitoringStatsAnomaliesRequest.end_time] are
       * fetched, and page token doesn't take affect in this case.
       * Only used to retrieve attribution score for the top Features which has
       * the highest attribution score in the latest monitoring run.
       * </pre>
       *
       * <code>int32 top_feature_count = 4;</code>
       *
       * @param value The topFeatureCount to set.
       * @return This builder for chaining.
       */
      public Builder setTopFeatureCount(int value) {

        topFeatureCount_ = value;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * If set, all attribution scores between
       * [SearchModelDeploymentMonitoringStatsAnomaliesRequest.start_time][google.cloud.aiplatform.v1beta1.SearchModelDeploymentMonitoringStatsAnomaliesRequest.start_time] and
       * [SearchModelDeploymentMonitoringStatsAnomaliesRequest.end_time][google.cloud.aiplatform.v1beta1.SearchModelDeploymentMonitoringStatsAnomaliesRequest.end_time] are
       * fetched, and page token doesn't take affect in this case.
       * Only used to retrieve attribution score for the top Features which has
       * the highest attribution score in the latest monitoring run.
       * </pre>
       *
       * <code>int32 top_feature_count = 4;</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearTopFeatureCount() {

        topFeatureCount_ = 0;
        onChanged();
        return this;
      }

      @java.lang.Override
      public final Builder setUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.setUnknownFields(unknownFields);
      }

      @java.lang.Override
      public final Builder mergeUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.mergeUnknownFields(unknownFields);
      }

      // @@protoc_insertion_point(builder_scope:google.cloud.aiplatform.v1beta1.SearchModelDeploymentMonitoringStatsAnomaliesRequest.StatsAnomaliesObjective)
    }

    // @@protoc_insertion_point(class_scope:google.cloud.aiplatform.v1beta1.SearchModelDeploymentMonitoringStatsAnomaliesRequest.StatsAnomaliesObjective)
    private static final com.google.cloud.aiplatform.v1beta1
            .SearchModelDeploymentMonitoringStatsAnomaliesRequest.StatsAnomaliesObjective
        DEFAULT_INSTANCE;

    static {
      DEFAULT_INSTANCE =
          new com.google.cloud.aiplatform.v1beta1
              .SearchModelDeploymentMonitoringStatsAnomaliesRequest.StatsAnomaliesObjective();
    }

    public static com.google.cloud.aiplatform.v1beta1
            .SearchModelDeploymentMonitoringStatsAnomaliesRequest.StatsAnomaliesObjective
        getDefaultInstance() {
      return DEFAULT_INSTANCE;
    }

    private static final com.google.protobuf.Parser<StatsAnomaliesObjective> PARSER =
        new com.google.protobuf.AbstractParser<StatsAnomaliesObjective>() {
          @java.lang.Override
          public StatsAnomaliesObjective parsePartialFrom(
              com.google.protobuf.CodedInputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
            return new StatsAnomaliesObjective(input, extensionRegistry);
          }
        };

    public static com.google.protobuf.Parser<StatsAnomaliesObjective> parser() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.protobuf.Parser<StatsAnomaliesObjective> getParserForType() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.cloud.aiplatform.v1beta1.SearchModelDeploymentMonitoringStatsAnomaliesRequest
            .StatsAnomaliesObjective
        getDefaultInstanceForType() {
      return DEFAULT_INSTANCE;
    }
  }

  public static final int MODEL_DEPLOYMENT_MONITORING_JOB_FIELD_NUMBER = 1;
  private volatile java.lang.Object modelDeploymentMonitoringJob_;
  /**
   *
   *
   * <pre>
   * Required. ModelDeploymentMonitoring Job resource name.
   * Format:
   * `projects/{project}/locations/{location}/modelDeploymentMonitoringJobs/{model_deployment_monitoring_job}
   * </pre>
   *
   * <code>
   * string model_deployment_monitoring_job = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
   * </code>
   *
   * @return The modelDeploymentMonitoringJob.
   */
  @java.lang.Override
  public java.lang.String getModelDeploymentMonitoringJob() {
    java.lang.Object ref = modelDeploymentMonitoringJob_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      modelDeploymentMonitoringJob_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Required. ModelDeploymentMonitoring Job resource name.
   * Format:
   * `projects/{project}/locations/{location}/modelDeploymentMonitoringJobs/{model_deployment_monitoring_job}
   * </pre>
   *
   * <code>
   * string model_deployment_monitoring_job = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
   * </code>
   *
   * @return The bytes for modelDeploymentMonitoringJob.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getModelDeploymentMonitoringJobBytes() {
    java.lang.Object ref = modelDeploymentMonitoringJob_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      modelDeploymentMonitoringJob_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int DEPLOYED_MODEL_ID_FIELD_NUMBER = 2;
  private volatile java.lang.Object deployedModelId_;
  /**
   *
   *
   * <pre>
   * Required. The DeployedModel ID of the
   * [google.cloud.aiplatform.master.ModelDeploymentMonitoringObjectiveConfig.deployed_model_id].
   * </pre>
   *
   * <code>string deployed_model_id = 2 [(.google.api.field_behavior) = REQUIRED];</code>
   *
   * @return The deployedModelId.
   */
  @java.lang.Override
  public java.lang.String getDeployedModelId() {
    java.lang.Object ref = deployedModelId_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      deployedModelId_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Required. The DeployedModel ID of the
   * [google.cloud.aiplatform.master.ModelDeploymentMonitoringObjectiveConfig.deployed_model_id].
   * </pre>
   *
   * <code>string deployed_model_id = 2 [(.google.api.field_behavior) = REQUIRED];</code>
   *
   * @return The bytes for deployedModelId.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getDeployedModelIdBytes() {
    java.lang.Object ref = deployedModelId_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      deployedModelId_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int FEATURE_DISPLAY_NAME_FIELD_NUMBER = 3;
  private volatile java.lang.Object featureDisplayName_;
  /**
   *
   *
   * <pre>
   * The feature display name. If specified, only return the stats belonging to
   * this feature. Format:
   * [ModelMonitoringStatsAnomalies.FeatureHistoricStatsAnomalies.feature_display_name][google.cloud.aiplatform.v1beta1.ModelMonitoringStatsAnomalies.FeatureHistoricStatsAnomalies.feature_display_name],
   * example: "user_destination".
   * </pre>
   *
   * <code>string feature_display_name = 3;</code>
   *
   * @return The featureDisplayName.
   */
  @java.lang.Override
  public java.lang.String getFeatureDisplayName() {
    java.lang.Object ref = featureDisplayName_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      featureDisplayName_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * The feature display name. If specified, only return the stats belonging to
   * this feature. Format:
   * [ModelMonitoringStatsAnomalies.FeatureHistoricStatsAnomalies.feature_display_name][google.cloud.aiplatform.v1beta1.ModelMonitoringStatsAnomalies.FeatureHistoricStatsAnomalies.feature_display_name],
   * example: "user_destination".
   * </pre>
   *
   * <code>string feature_display_name = 3;</code>
   *
   * @return The bytes for featureDisplayName.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getFeatureDisplayNameBytes() {
    java.lang.Object ref = featureDisplayName_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      featureDisplayName_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int OBJECTIVES_FIELD_NUMBER = 4;
  private java.util.List<
          com.google.cloud.aiplatform.v1beta1.SearchModelDeploymentMonitoringStatsAnomaliesRequest
              .StatsAnomaliesObjective>
      objectives_;
  /**
   *
   *
   * <pre>
   * Required. Objectives of the stats to retrieve.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.aiplatform.v1beta1.SearchModelDeploymentMonitoringStatsAnomaliesRequest.StatsAnomaliesObjective objectives = 4 [(.google.api.field_behavior) = REQUIRED];
   * </code>
   */
  @java.lang.Override
  public java.util.List<
          com.google.cloud.aiplatform.v1beta1.SearchModelDeploymentMonitoringStatsAnomaliesRequest
              .StatsAnomaliesObjective>
      getObjectivesList() {
    return objectives_;
  }
  /**
   *
   *
   * <pre>
   * Required. Objectives of the stats to retrieve.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.aiplatform.v1beta1.SearchModelDeploymentMonitoringStatsAnomaliesRequest.StatsAnomaliesObjective objectives = 4 [(.google.api.field_behavior) = REQUIRED];
   * </code>
   */
  @java.lang.Override
  public java.util.List<
          ? extends
              com.google.cloud.aiplatform.v1beta1
                  .SearchModelDeploymentMonitoringStatsAnomaliesRequest
                  .StatsAnomaliesObjectiveOrBuilder>
      getObjectivesOrBuilderList() {
    return objectives_;
  }
  /**
   *
   *
   * <pre>
   * Required. Objectives of the stats to retrieve.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.aiplatform.v1beta1.SearchModelDeploymentMonitoringStatsAnomaliesRequest.StatsAnomaliesObjective objectives = 4 [(.google.api.field_behavior) = REQUIRED];
   * </code>
   */
  @java.lang.Override
  public int getObjectivesCount() {
    return objectives_.size();
  }
  /**
   *
   *
   * <pre>
   * Required. Objectives of the stats to retrieve.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.aiplatform.v1beta1.SearchModelDeploymentMonitoringStatsAnomaliesRequest.StatsAnomaliesObjective objectives = 4 [(.google.api.field_behavior) = REQUIRED];
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.aiplatform.v1beta1.SearchModelDeploymentMonitoringStatsAnomaliesRequest
          .StatsAnomaliesObjective
      getObjectives(int index) {
    return objectives_.get(index);
  }
  /**
   *
   *
   * <pre>
   * Required. Objectives of the stats to retrieve.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.aiplatform.v1beta1.SearchModelDeploymentMonitoringStatsAnomaliesRequest.StatsAnomaliesObjective objectives = 4 [(.google.api.field_behavior) = REQUIRED];
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.aiplatform.v1beta1.SearchModelDeploymentMonitoringStatsAnomaliesRequest
          .StatsAnomaliesObjectiveOrBuilder
      getObjectivesOrBuilder(int index) {
    return objectives_.get(index);
  }

  public static final int PAGE_SIZE_FIELD_NUMBER = 5;
  private int pageSize_;
  /**
   *
   *
   * <pre>
   * The standard list page size.
   * </pre>
   *
   * <code>int32 page_size = 5;</code>
   *
   * @return The pageSize.
   */
  @java.lang.Override
  public int getPageSize() {
    return pageSize_;
  }

  public static final int PAGE_TOKEN_FIELD_NUMBER = 6;
  private volatile java.lang.Object pageToken_;
  /**
   *
   *
   * <pre>
   * A page token received from a previous
   * [JobService.SearchModelDeploymentMonitoringStatsAnomalies][google.cloud.aiplatform.v1beta1.JobService.SearchModelDeploymentMonitoringStatsAnomalies]
   * call.
   * </pre>
   *
   * <code>string page_token = 6;</code>
   *
   * @return The pageToken.
   */
  @java.lang.Override
  public java.lang.String getPageToken() {
    java.lang.Object ref = pageToken_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      pageToken_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * A page token received from a previous
   * [JobService.SearchModelDeploymentMonitoringStatsAnomalies][google.cloud.aiplatform.v1beta1.JobService.SearchModelDeploymentMonitoringStatsAnomalies]
   * call.
   * </pre>
   *
   * <code>string page_token = 6;</code>
   *
   * @return The bytes for pageToken.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getPageTokenBytes() {
    java.lang.Object ref = pageToken_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      pageToken_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int START_TIME_FIELD_NUMBER = 7;
  private com.google.protobuf.Timestamp startTime_;
  /**
   *
   *
   * <pre>
   * The earliest timestamp of stats being generated.
   * If not set, indicates fetching stats till the earliest possible one.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp start_time = 7;</code>
   *
   * @return Whether the startTime field is set.
   */
  @java.lang.Override
  public boolean hasStartTime() {
    return startTime_ != null;
  }
  /**
   *
   *
   * <pre>
   * The earliest timestamp of stats being generated.
   * If not set, indicates fetching stats till the earliest possible one.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp start_time = 7;</code>
   *
   * @return The startTime.
   */
  @java.lang.Override
  public com.google.protobuf.Timestamp getStartTime() {
    return startTime_ == null ? com.google.protobuf.Timestamp.getDefaultInstance() : startTime_;
  }
  /**
   *
   *
   * <pre>
   * The earliest timestamp of stats being generated.
   * If not set, indicates fetching stats till the earliest possible one.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp start_time = 7;</code>
   */
  @java.lang.Override
  public com.google.protobuf.TimestampOrBuilder getStartTimeOrBuilder() {
    return getStartTime();
  }

  public static final int END_TIME_FIELD_NUMBER = 8;
  private com.google.protobuf.Timestamp endTime_;
  /**
   *
   *
   * <pre>
   * The latest timestamp of stats being generated.
   * If not set, indicates feching stats till the latest possible one.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp end_time = 8;</code>
   *
   * @return Whether the endTime field is set.
   */
  @java.lang.Override
  public boolean hasEndTime() {
    return endTime_ != null;
  }
  /**
   *
   *
   * <pre>
   * The latest timestamp of stats being generated.
   * If not set, indicates feching stats till the latest possible one.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp end_time = 8;</code>
   *
   * @return The endTime.
   */
  @java.lang.Override
  public com.google.protobuf.Timestamp getEndTime() {
    return endTime_ == null ? com.google.protobuf.Timestamp.getDefaultInstance() : endTime_;
  }
  /**
   *
   *
   * <pre>
   * The latest timestamp of stats being generated.
   * If not set, indicates feching stats till the latest possible one.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp end_time = 8;</code>
   */
  @java.lang.Override
  public com.google.protobuf.TimestampOrBuilder getEndTimeOrBuilder() {
    return getEndTime();
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    if (!getModelDeploymentMonitoringJobBytes().isEmpty()) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 1, modelDeploymentMonitoringJob_);
    }
    if (!getDeployedModelIdBytes().isEmpty()) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 2, deployedModelId_);
    }
    if (!getFeatureDisplayNameBytes().isEmpty()) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 3, featureDisplayName_);
    }
    for (int i = 0; i < objectives_.size(); i++) {
      output.writeMessage(4, objectives_.get(i));
    }
    if (pageSize_ != 0) {
      output.writeInt32(5, pageSize_);
    }
    if (!getPageTokenBytes().isEmpty()) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 6, pageToken_);
    }
    if (startTime_ != null) {
      output.writeMessage(7, getStartTime());
    }
    if (endTime_ != null) {
      output.writeMessage(8, getEndTime());
    }
    unknownFields.writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    if (!getModelDeploymentMonitoringJobBytes().isEmpty()) {
      size +=
          com.google.protobuf.GeneratedMessageV3.computeStringSize(
              1, modelDeploymentMonitoringJob_);
    }
    if (!getDeployedModelIdBytes().isEmpty()) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(2, deployedModelId_);
    }
    if (!getFeatureDisplayNameBytes().isEmpty()) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(3, featureDisplayName_);
    }
    for (int i = 0; i < objectives_.size(); i++) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(4, objectives_.get(i));
    }
    if (pageSize_ != 0) {
      size += com.google.protobuf.CodedOutputStream.computeInt32Size(5, pageSize_);
    }
    if (!getPageTokenBytes().isEmpty()) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(6, pageToken_);
    }
    if (startTime_ != null) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(7, getStartTime());
    }
    if (endTime_ != null) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(8, getEndTime());
    }
    size += unknownFields.getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj
        instanceof
        com.google.cloud.aiplatform.v1beta1.SearchModelDeploymentMonitoringStatsAnomaliesRequest)) {
      return super.equals(obj);
    }
    com.google.cloud.aiplatform.v1beta1.SearchModelDeploymentMonitoringStatsAnomaliesRequest other =
        (com.google.cloud.aiplatform.v1beta1.SearchModelDeploymentMonitoringStatsAnomaliesRequest)
            obj;

    if (!getModelDeploymentMonitoringJob().equals(other.getModelDeploymentMonitoringJob()))
      return false;
    if (!getDeployedModelId().equals(other.getDeployedModelId())) return false;
    if (!getFeatureDisplayName().equals(other.getFeatureDisplayName())) return false;
    if (!getObjectivesList().equals(other.getObjectivesList())) return false;
    if (getPageSize() != other.getPageSize()) return false;
    if (!getPageToken().equals(other.getPageToken())) return false;
    if (hasStartTime() != other.hasStartTime()) return false;
    if (hasStartTime()) {
      if (!getStartTime().equals(other.getStartTime())) return false;
    }
    if (hasEndTime() != other.hasEndTime()) return false;
    if (hasEndTime()) {
      if (!getEndTime().equals(other.getEndTime())) return false;
    }
    if (!unknownFields.equals(other.unknownFields)) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    hash = (37 * hash) + MODEL_DEPLOYMENT_MONITORING_JOB_FIELD_NUMBER;
    hash = (53 * hash) + getModelDeploymentMonitoringJob().hashCode();
    hash = (37 * hash) + DEPLOYED_MODEL_ID_FIELD_NUMBER;
    hash = (53 * hash) + getDeployedModelId().hashCode();
    hash = (37 * hash) + FEATURE_DISPLAY_NAME_FIELD_NUMBER;
    hash = (53 * hash) + getFeatureDisplayName().hashCode();
    if (getObjectivesCount() > 0) {
      hash = (37 * hash) + OBJECTIVES_FIELD_NUMBER;
      hash = (53 * hash) + getObjectivesList().hashCode();
    }
    hash = (37 * hash) + PAGE_SIZE_FIELD_NUMBER;
    hash = (53 * hash) + getPageSize();
    hash = (37 * hash) + PAGE_TOKEN_FIELD_NUMBER;
    hash = (53 * hash) + getPageToken().hashCode();
    if (hasStartTime()) {
      hash = (37 * hash) + START_TIME_FIELD_NUMBER;
      hash = (53 * hash) + getStartTime().hashCode();
    }
    if (hasEndTime()) {
      hash = (37 * hash) + END_TIME_FIELD_NUMBER;
      hash = (53 * hash) + getEndTime().hashCode();
    }
    hash = (29 * hash) + unknownFields.hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.cloud.aiplatform.v1beta1
          .SearchModelDeploymentMonitoringStatsAnomaliesRequest
      parseFrom(java.nio.ByteBuffer data)
          throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.aiplatform.v1beta1
          .SearchModelDeploymentMonitoringStatsAnomaliesRequest
      parseFrom(
          java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.aiplatform.v1beta1
          .SearchModelDeploymentMonitoringStatsAnomaliesRequest
      parseFrom(com.google.protobuf.ByteString data)
          throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.aiplatform.v1beta1
          .SearchModelDeploymentMonitoringStatsAnomaliesRequest
      parseFrom(
          com.google.protobuf.ByteString data,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.aiplatform.v1beta1
          .SearchModelDeploymentMonitoringStatsAnomaliesRequest
      parseFrom(byte[] data) throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.aiplatform.v1beta1
          .SearchModelDeploymentMonitoringStatsAnomaliesRequest
      parseFrom(byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.aiplatform.v1beta1
          .SearchModelDeploymentMonitoringStatsAnomaliesRequest
      parseFrom(java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.aiplatform.v1beta1
          .SearchModelDeploymentMonitoringStatsAnomaliesRequest
      parseFrom(
          java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.aiplatform.v1beta1
          .SearchModelDeploymentMonitoringStatsAnomaliesRequest
      parseDelimitedFrom(java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.cloud.aiplatform.v1beta1
          .SearchModelDeploymentMonitoringStatsAnomaliesRequest
      parseDelimitedFrom(
          java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.aiplatform.v1beta1
          .SearchModelDeploymentMonitoringStatsAnomaliesRequest
      parseFrom(com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.aiplatform.v1beta1
          .SearchModelDeploymentMonitoringStatsAnomaliesRequest
      parseFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(
      com.google.cloud.aiplatform.v1beta1.SearchModelDeploymentMonitoringStatsAnomaliesRequest
          prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }
  /**
   *
   *
   * <pre>
   * Request message for
   * [JobService.SearchModelDeploymentMonitoringStatsAnomalies][google.cloud.aiplatform.v1beta1.JobService.SearchModelDeploymentMonitoringStatsAnomalies].
   * </pre>
   *
   * Protobuf type {@code
   * google.cloud.aiplatform.v1beta1.SearchModelDeploymentMonitoringStatsAnomaliesRequest}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.cloud.aiplatform.v1beta1.SearchModelDeploymentMonitoringStatsAnomaliesRequest)
      com.google.cloud.aiplatform.v1beta1
          .SearchModelDeploymentMonitoringStatsAnomaliesRequestOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.aiplatform.v1beta1.JobServiceProto
          .internal_static_google_cloud_aiplatform_v1beta1_SearchModelDeploymentMonitoringStatsAnomaliesRequest_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.aiplatform.v1beta1.JobServiceProto
          .internal_static_google_cloud_aiplatform_v1beta1_SearchModelDeploymentMonitoringStatsAnomaliesRequest_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.aiplatform.v1beta1
                  .SearchModelDeploymentMonitoringStatsAnomaliesRequest.class,
              com.google.cloud.aiplatform.v1beta1
                  .SearchModelDeploymentMonitoringStatsAnomaliesRequest.Builder.class);
    }

    // Construct using
    // com.google.cloud.aiplatform.v1beta1.SearchModelDeploymentMonitoringStatsAnomaliesRequest.newBuilder()
    private Builder() {
      maybeForceBuilderInitialization();
    }

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
      maybeForceBuilderInitialization();
    }

    private void maybeForceBuilderInitialization() {
      if (com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders) {
        getObjectivesFieldBuilder();
      }
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      modelDeploymentMonitoringJob_ = "";

      deployedModelId_ = "";

      featureDisplayName_ = "";

      if (objectivesBuilder_ == null) {
        objectives_ = java.util.Collections.emptyList();
        bitField0_ = (bitField0_ & ~0x00000001);
      } else {
        objectivesBuilder_.clear();
      }
      pageSize_ = 0;

      pageToken_ = "";

      if (startTimeBuilder_ == null) {
        startTime_ = null;
      } else {
        startTime_ = null;
        startTimeBuilder_ = null;
      }
      if (endTimeBuilder_ == null) {
        endTime_ = null;
      } else {
        endTime_ = null;
        endTimeBuilder_ = null;
      }
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.cloud.aiplatform.v1beta1.JobServiceProto
          .internal_static_google_cloud_aiplatform_v1beta1_SearchModelDeploymentMonitoringStatsAnomaliesRequest_descriptor;
    }

    @java.lang.Override
    public com.google.cloud.aiplatform.v1beta1.SearchModelDeploymentMonitoringStatsAnomaliesRequest
        getDefaultInstanceForType() {
      return com.google.cloud.aiplatform.v1beta1
          .SearchModelDeploymentMonitoringStatsAnomaliesRequest.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.cloud.aiplatform.v1beta1.SearchModelDeploymentMonitoringStatsAnomaliesRequest
        build() {
      com.google.cloud.aiplatform.v1beta1.SearchModelDeploymentMonitoringStatsAnomaliesRequest
          result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.cloud.aiplatform.v1beta1.SearchModelDeploymentMonitoringStatsAnomaliesRequest
        buildPartial() {
      com.google.cloud.aiplatform.v1beta1.SearchModelDeploymentMonitoringStatsAnomaliesRequest
          result =
              new com.google.cloud.aiplatform.v1beta1
                  .SearchModelDeploymentMonitoringStatsAnomaliesRequest(this);
      int from_bitField0_ = bitField0_;
      result.modelDeploymentMonitoringJob_ = modelDeploymentMonitoringJob_;
      result.deployedModelId_ = deployedModelId_;
      result.featureDisplayName_ = featureDisplayName_;
      if (objectivesBuilder_ == null) {
        if (((bitField0_ & 0x00000001) != 0)) {
          objectives_ = java.util.Collections.unmodifiableList(objectives_);
          bitField0_ = (bitField0_ & ~0x00000001);
        }
        result.objectives_ = objectives_;
      } else {
        result.objectives_ = objectivesBuilder_.build();
      }
      result.pageSize_ = pageSize_;
      result.pageToken_ = pageToken_;
      if (startTimeBuilder_ == null) {
        result.startTime_ = startTime_;
      } else {
        result.startTime_ = startTimeBuilder_.build();
      }
      if (endTimeBuilder_ == null) {
        result.endTime_ = endTime_;
      } else {
        result.endTime_ = endTimeBuilder_.build();
      }
      onBuilt();
      return result;
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other
          instanceof
          com.google.cloud.aiplatform.v1beta1
              .SearchModelDeploymentMonitoringStatsAnomaliesRequest) {
        return mergeFrom(
            (com.google.cloud.aiplatform.v1beta1
                    .SearchModelDeploymentMonitoringStatsAnomaliesRequest)
                other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(
        com.google.cloud.aiplatform.v1beta1.SearchModelDeploymentMonitoringStatsAnomaliesRequest
            other) {
      if (other
          == com.google.cloud.aiplatform.v1beta1
              .SearchModelDeploymentMonitoringStatsAnomaliesRequest.getDefaultInstance())
        return this;
      if (!other.getModelDeploymentMonitoringJob().isEmpty()) {
        modelDeploymentMonitoringJob_ = other.modelDeploymentMonitoringJob_;
        onChanged();
      }
      if (!other.getDeployedModelId().isEmpty()) {
        deployedModelId_ = other.deployedModelId_;
        onChanged();
      }
      if (!other.getFeatureDisplayName().isEmpty()) {
        featureDisplayName_ = other.featureDisplayName_;
        onChanged();
      }
      if (objectivesBuilder_ == null) {
        if (!other.objectives_.isEmpty()) {
          if (objectives_.isEmpty()) {
            objectives_ = other.objectives_;
            bitField0_ = (bitField0_ & ~0x00000001);
          } else {
            ensureObjectivesIsMutable();
            objectives_.addAll(other.objectives_);
          }
          onChanged();
        }
      } else {
        if (!other.objectives_.isEmpty()) {
          if (objectivesBuilder_.isEmpty()) {
            objectivesBuilder_.dispose();
            objectivesBuilder_ = null;
            objectives_ = other.objectives_;
            bitField0_ = (bitField0_ & ~0x00000001);
            objectivesBuilder_ =
                com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders
                    ? getObjectivesFieldBuilder()
                    : null;
          } else {
            objectivesBuilder_.addAllMessages(other.objectives_);
          }
        }
      }
      if (other.getPageSize() != 0) {
        setPageSize(other.getPageSize());
      }
      if (!other.getPageToken().isEmpty()) {
        pageToken_ = other.pageToken_;
        onChanged();
      }
      if (other.hasStartTime()) {
        mergeStartTime(other.getStartTime());
      }
      if (other.hasEndTime()) {
        mergeEndTime(other.getEndTime());
      }
      this.mergeUnknownFields(other.unknownFields);
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      com.google.cloud.aiplatform.v1beta1.SearchModelDeploymentMonitoringStatsAnomaliesRequest
          parsedMessage = null;
      try {
        parsedMessage = PARSER.parsePartialFrom(input, extensionRegistry);
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        parsedMessage =
            (com.google.cloud.aiplatform.v1beta1
                    .SearchModelDeploymentMonitoringStatsAnomaliesRequest)
                e.getUnfinishedMessage();
        throw e.unwrapIOException();
      } finally {
        if (parsedMessage != null) {
          mergeFrom(parsedMessage);
        }
      }
      return this;
    }

    private int bitField0_;

    private java.lang.Object modelDeploymentMonitoringJob_ = "";
    /**
     *
     *
     * <pre>
     * Required. ModelDeploymentMonitoring Job resource name.
     * Format:
     * `projects/{project}/locations/{location}/modelDeploymentMonitoringJobs/{model_deployment_monitoring_job}
     * </pre>
     *
     * <code>
     * string model_deployment_monitoring_job = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @return The modelDeploymentMonitoringJob.
     */
    public java.lang.String getModelDeploymentMonitoringJob() {
      java.lang.Object ref = modelDeploymentMonitoringJob_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        modelDeploymentMonitoringJob_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Required. ModelDeploymentMonitoring Job resource name.
     * Format:
     * `projects/{project}/locations/{location}/modelDeploymentMonitoringJobs/{model_deployment_monitoring_job}
     * </pre>
     *
     * <code>
     * string model_deployment_monitoring_job = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @return The bytes for modelDeploymentMonitoringJob.
     */
    public com.google.protobuf.ByteString getModelDeploymentMonitoringJobBytes() {
      java.lang.Object ref = modelDeploymentMonitoringJob_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        modelDeploymentMonitoringJob_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Required. ModelDeploymentMonitoring Job resource name.
     * Format:
     * `projects/{project}/locations/{location}/modelDeploymentMonitoringJobs/{model_deployment_monitoring_job}
     * </pre>
     *
     * <code>
     * string model_deployment_monitoring_job = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @param value The modelDeploymentMonitoringJob to set.
     * @return This builder for chaining.
     */
    public Builder setModelDeploymentMonitoringJob(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }

      modelDeploymentMonitoringJob_ = value;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. ModelDeploymentMonitoring Job resource name.
     * Format:
     * `projects/{project}/locations/{location}/modelDeploymentMonitoringJobs/{model_deployment_monitoring_job}
     * </pre>
     *
     * <code>
     * string model_deployment_monitoring_job = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @return This builder for chaining.
     */
    public Builder clearModelDeploymentMonitoringJob() {

      modelDeploymentMonitoringJob_ = getDefaultInstance().getModelDeploymentMonitoringJob();
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. ModelDeploymentMonitoring Job resource name.
     * Format:
     * `projects/{project}/locations/{location}/modelDeploymentMonitoringJobs/{model_deployment_monitoring_job}
     * </pre>
     *
     * <code>
     * string model_deployment_monitoring_job = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @param value The bytes for modelDeploymentMonitoringJob to set.
     * @return This builder for chaining.
     */
    public Builder setModelDeploymentMonitoringJobBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);

      modelDeploymentMonitoringJob_ = value;
      onChanged();
      return this;
    }

    private java.lang.Object deployedModelId_ = "";
    /**
     *
     *
     * <pre>
     * Required. The DeployedModel ID of the
     * [google.cloud.aiplatform.master.ModelDeploymentMonitoringObjectiveConfig.deployed_model_id].
     * </pre>
     *
     * <code>string deployed_model_id = 2 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return The deployedModelId.
     */
    public java.lang.String getDeployedModelId() {
      java.lang.Object ref = deployedModelId_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        deployedModelId_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Required. The DeployedModel ID of the
     * [google.cloud.aiplatform.master.ModelDeploymentMonitoringObjectiveConfig.deployed_model_id].
     * </pre>
     *
     * <code>string deployed_model_id = 2 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return The bytes for deployedModelId.
     */
    public com.google.protobuf.ByteString getDeployedModelIdBytes() {
      java.lang.Object ref = deployedModelId_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        deployedModelId_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Required. The DeployedModel ID of the
     * [google.cloud.aiplatform.master.ModelDeploymentMonitoringObjectiveConfig.deployed_model_id].
     * </pre>
     *
     * <code>string deployed_model_id = 2 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @param value The deployedModelId to set.
     * @return This builder for chaining.
     */
    public Builder setDeployedModelId(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }

      deployedModelId_ = value;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. The DeployedModel ID of the
     * [google.cloud.aiplatform.master.ModelDeploymentMonitoringObjectiveConfig.deployed_model_id].
     * </pre>
     *
     * <code>string deployed_model_id = 2 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearDeployedModelId() {

      deployedModelId_ = getDefaultInstance().getDeployedModelId();
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. The DeployedModel ID of the
     * [google.cloud.aiplatform.master.ModelDeploymentMonitoringObjectiveConfig.deployed_model_id].
     * </pre>
     *
     * <code>string deployed_model_id = 2 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @param value The bytes for deployedModelId to set.
     * @return This builder for chaining.
     */
    public Builder setDeployedModelIdBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);

      deployedModelId_ = value;
      onChanged();
      return this;
    }

    private java.lang.Object featureDisplayName_ = "";
    /**
     *
     *
     * <pre>
     * The feature display name. If specified, only return the stats belonging to
     * this feature. Format:
     * [ModelMonitoringStatsAnomalies.FeatureHistoricStatsAnomalies.feature_display_name][google.cloud.aiplatform.v1beta1.ModelMonitoringStatsAnomalies.FeatureHistoricStatsAnomalies.feature_display_name],
     * example: "user_destination".
     * </pre>
     *
     * <code>string feature_display_name = 3;</code>
     *
     * @return The featureDisplayName.
     */
    public java.lang.String getFeatureDisplayName() {
      java.lang.Object ref = featureDisplayName_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        featureDisplayName_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * The feature display name. If specified, only return the stats belonging to
     * this feature. Format:
     * [ModelMonitoringStatsAnomalies.FeatureHistoricStatsAnomalies.feature_display_name][google.cloud.aiplatform.v1beta1.ModelMonitoringStatsAnomalies.FeatureHistoricStatsAnomalies.feature_display_name],
     * example: "user_destination".
     * </pre>
     *
     * <code>string feature_display_name = 3;</code>
     *
     * @return The bytes for featureDisplayName.
     */
    public com.google.protobuf.ByteString getFeatureDisplayNameBytes() {
      java.lang.Object ref = featureDisplayName_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        featureDisplayName_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * The feature display name. If specified, only return the stats belonging to
     * this feature. Format:
     * [ModelMonitoringStatsAnomalies.FeatureHistoricStatsAnomalies.feature_display_name][google.cloud.aiplatform.v1beta1.ModelMonitoringStatsAnomalies.FeatureHistoricStatsAnomalies.feature_display_name],
     * example: "user_destination".
     * </pre>
     *
     * <code>string feature_display_name = 3;</code>
     *
     * @param value The featureDisplayName to set.
     * @return This builder for chaining.
     */
    public Builder setFeatureDisplayName(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }

      featureDisplayName_ = value;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The feature display name. If specified, only return the stats belonging to
     * this feature. Format:
     * [ModelMonitoringStatsAnomalies.FeatureHistoricStatsAnomalies.feature_display_name][google.cloud.aiplatform.v1beta1.ModelMonitoringStatsAnomalies.FeatureHistoricStatsAnomalies.feature_display_name],
     * example: "user_destination".
     * </pre>
     *
     * <code>string feature_display_name = 3;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearFeatureDisplayName() {

      featureDisplayName_ = getDefaultInstance().getFeatureDisplayName();
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The feature display name. If specified, only return the stats belonging to
     * this feature. Format:
     * [ModelMonitoringStatsAnomalies.FeatureHistoricStatsAnomalies.feature_display_name][google.cloud.aiplatform.v1beta1.ModelMonitoringStatsAnomalies.FeatureHistoricStatsAnomalies.feature_display_name],
     * example: "user_destination".
     * </pre>
     *
     * <code>string feature_display_name = 3;</code>
     *
     * @param value The bytes for featureDisplayName to set.
     * @return This builder for chaining.
     */
    public Builder setFeatureDisplayNameBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);

      featureDisplayName_ = value;
      onChanged();
      return this;
    }

    private java.util.List<
            com.google.cloud.aiplatform.v1beta1.SearchModelDeploymentMonitoringStatsAnomaliesRequest
                .StatsAnomaliesObjective>
        objectives_ = java.util.Collections.emptyList();

    private void ensureObjectivesIsMutable() {
      if (!((bitField0_ & 0x00000001) != 0)) {
        objectives_ =
            new java.util.ArrayList<
                com.google.cloud.aiplatform.v1beta1
                    .SearchModelDeploymentMonitoringStatsAnomaliesRequest.StatsAnomaliesObjective>(
                objectives_);
        bitField0_ |= 0x00000001;
      }
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.cloud.aiplatform.v1beta1.SearchModelDeploymentMonitoringStatsAnomaliesRequest
                .StatsAnomaliesObjective,
            com.google.cloud.aiplatform.v1beta1.SearchModelDeploymentMonitoringStatsAnomaliesRequest
                .StatsAnomaliesObjective.Builder,
            com.google.cloud.aiplatform.v1beta1.SearchModelDeploymentMonitoringStatsAnomaliesRequest
                .StatsAnomaliesObjectiveOrBuilder>
        objectivesBuilder_;

    /**
     *
     *
     * <pre>
     * Required. Objectives of the stats to retrieve.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.aiplatform.v1beta1.SearchModelDeploymentMonitoringStatsAnomaliesRequest.StatsAnomaliesObjective objectives = 4 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public java.util.List<
            com.google.cloud.aiplatform.v1beta1.SearchModelDeploymentMonitoringStatsAnomaliesRequest
                .StatsAnomaliesObjective>
        getObjectivesList() {
      if (objectivesBuilder_ == null) {
        return java.util.Collections.unmodifiableList(objectives_);
      } else {
        return objectivesBuilder_.getMessageList();
      }
    }
    /**
     *
     *
     * <pre>
     * Required. Objectives of the stats to retrieve.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.aiplatform.v1beta1.SearchModelDeploymentMonitoringStatsAnomaliesRequest.StatsAnomaliesObjective objectives = 4 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public int getObjectivesCount() {
      if (objectivesBuilder_ == null) {
        return objectives_.size();
      } else {
        return objectivesBuilder_.getCount();
      }
    }
    /**
     *
     *
     * <pre>
     * Required. Objectives of the stats to retrieve.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.aiplatform.v1beta1.SearchModelDeploymentMonitoringStatsAnomaliesRequest.StatsAnomaliesObjective objectives = 4 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public com.google.cloud.aiplatform.v1beta1.SearchModelDeploymentMonitoringStatsAnomaliesRequest
            .StatsAnomaliesObjective
        getObjectives(int index) {
      if (objectivesBuilder_ == null) {
        return objectives_.get(index);
      } else {
        return objectivesBuilder_.getMessage(index);
      }
    }
    /**
     *
     *
     * <pre>
     * Required. Objectives of the stats to retrieve.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.aiplatform.v1beta1.SearchModelDeploymentMonitoringStatsAnomaliesRequest.StatsAnomaliesObjective objectives = 4 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public Builder setObjectives(
        int index,
        com.google.cloud.aiplatform.v1beta1.SearchModelDeploymentMonitoringStatsAnomaliesRequest
                .StatsAnomaliesObjective
            value) {
      if (objectivesBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureObjectivesIsMutable();
        objectives_.set(index, value);
        onChanged();
      } else {
        objectivesBuilder_.setMessage(index, value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. Objectives of the stats to retrieve.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.aiplatform.v1beta1.SearchModelDeploymentMonitoringStatsAnomaliesRequest.StatsAnomaliesObjective objectives = 4 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public Builder setObjectives(
        int index,
        com.google.cloud.aiplatform.v1beta1.SearchModelDeploymentMonitoringStatsAnomaliesRequest
                .StatsAnomaliesObjective.Builder
            builderForValue) {
      if (objectivesBuilder_ == null) {
        ensureObjectivesIsMutable();
        objectives_.set(index, builderForValue.build());
        onChanged();
      } else {
        objectivesBuilder_.setMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. Objectives of the stats to retrieve.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.aiplatform.v1beta1.SearchModelDeploymentMonitoringStatsAnomaliesRequest.StatsAnomaliesObjective objectives = 4 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public Builder addObjectives(
        com.google.cloud.aiplatform.v1beta1.SearchModelDeploymentMonitoringStatsAnomaliesRequest
                .StatsAnomaliesObjective
            value) {
      if (objectivesBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureObjectivesIsMutable();
        objectives_.add(value);
        onChanged();
      } else {
        objectivesBuilder_.addMessage(value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. Objectives of the stats to retrieve.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.aiplatform.v1beta1.SearchModelDeploymentMonitoringStatsAnomaliesRequest.StatsAnomaliesObjective objectives = 4 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public Builder addObjectives(
        int index,
        com.google.cloud.aiplatform.v1beta1.SearchModelDeploymentMonitoringStatsAnomaliesRequest
                .StatsAnomaliesObjective
            value) {
      if (objectivesBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureObjectivesIsMutable();
        objectives_.add(index, value);
        onChanged();
      } else {
        objectivesBuilder_.addMessage(index, value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. Objectives of the stats to retrieve.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.aiplatform.v1beta1.SearchModelDeploymentMonitoringStatsAnomaliesRequest.StatsAnomaliesObjective objectives = 4 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public Builder addObjectives(
        com.google.cloud.aiplatform.v1beta1.SearchModelDeploymentMonitoringStatsAnomaliesRequest
                .StatsAnomaliesObjective.Builder
            builderForValue) {
      if (objectivesBuilder_ == null) {
        ensureObjectivesIsMutable();
        objectives_.add(builderForValue.build());
        onChanged();
      } else {
        objectivesBuilder_.addMessage(builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. Objectives of the stats to retrieve.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.aiplatform.v1beta1.SearchModelDeploymentMonitoringStatsAnomaliesRequest.StatsAnomaliesObjective objectives = 4 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public Builder addObjectives(
        int index,
        com.google.cloud.aiplatform.v1beta1.SearchModelDeploymentMonitoringStatsAnomaliesRequest
                .StatsAnomaliesObjective.Builder
            builderForValue) {
      if (objectivesBuilder_ == null) {
        ensureObjectivesIsMutable();
        objectives_.add(index, builderForValue.build());
        onChanged();
      } else {
        objectivesBuilder_.addMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. Objectives of the stats to retrieve.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.aiplatform.v1beta1.SearchModelDeploymentMonitoringStatsAnomaliesRequest.StatsAnomaliesObjective objectives = 4 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public Builder addAllObjectives(
        java.lang.Iterable<
                ? extends
                    com.google.cloud.aiplatform.v1beta1
                        .SearchModelDeploymentMonitoringStatsAnomaliesRequest
                        .StatsAnomaliesObjective>
            values) {
      if (objectivesBuilder_ == null) {
        ensureObjectivesIsMutable();
        com.google.protobuf.AbstractMessageLite.Builder.addAll(values, objectives_);
        onChanged();
      } else {
        objectivesBuilder_.addAllMessages(values);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. Objectives of the stats to retrieve.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.aiplatform.v1beta1.SearchModelDeploymentMonitoringStatsAnomaliesRequest.StatsAnomaliesObjective objectives = 4 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public Builder clearObjectives() {
      if (objectivesBuilder_ == null) {
        objectives_ = java.util.Collections.emptyList();
        bitField0_ = (bitField0_ & ~0x00000001);
        onChanged();
      } else {
        objectivesBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. Objectives of the stats to retrieve.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.aiplatform.v1beta1.SearchModelDeploymentMonitoringStatsAnomaliesRequest.StatsAnomaliesObjective objectives = 4 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public Builder removeObjectives(int index) {
      if (objectivesBuilder_ == null) {
        ensureObjectivesIsMutable();
        objectives_.remove(index);
        onChanged();
      } else {
        objectivesBuilder_.remove(index);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. Objectives of the stats to retrieve.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.aiplatform.v1beta1.SearchModelDeploymentMonitoringStatsAnomaliesRequest.StatsAnomaliesObjective objectives = 4 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public com.google.cloud.aiplatform.v1beta1.SearchModelDeploymentMonitoringStatsAnomaliesRequest
            .StatsAnomaliesObjective.Builder
        getObjectivesBuilder(int index) {
      return getObjectivesFieldBuilder().getBuilder(index);
    }
    /**
     *
     *
     * <pre>
     * Required. Objectives of the stats to retrieve.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.aiplatform.v1beta1.SearchModelDeploymentMonitoringStatsAnomaliesRequest.StatsAnomaliesObjective objectives = 4 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public com.google.cloud.aiplatform.v1beta1.SearchModelDeploymentMonitoringStatsAnomaliesRequest
            .StatsAnomaliesObjectiveOrBuilder
        getObjectivesOrBuilder(int index) {
      if (objectivesBuilder_ == null) {
        return objectives_.get(index);
      } else {
        return objectivesBuilder_.getMessageOrBuilder(index);
      }
    }
    /**
     *
     *
     * <pre>
     * Required. Objectives of the stats to retrieve.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.aiplatform.v1beta1.SearchModelDeploymentMonitoringStatsAnomaliesRequest.StatsAnomaliesObjective objectives = 4 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public java.util.List<
            ? extends
                com.google.cloud.aiplatform.v1beta1
                    .SearchModelDeploymentMonitoringStatsAnomaliesRequest
                    .StatsAnomaliesObjectiveOrBuilder>
        getObjectivesOrBuilderList() {
      if (objectivesBuilder_ != null) {
        return objectivesBuilder_.getMessageOrBuilderList();
      } else {
        return java.util.Collections.unmodifiableList(objectives_);
      }
    }
    /**
     *
     *
     * <pre>
     * Required. Objectives of the stats to retrieve.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.aiplatform.v1beta1.SearchModelDeploymentMonitoringStatsAnomaliesRequest.StatsAnomaliesObjective objectives = 4 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public com.google.cloud.aiplatform.v1beta1.SearchModelDeploymentMonitoringStatsAnomaliesRequest
            .StatsAnomaliesObjective.Builder
        addObjectivesBuilder() {
      return getObjectivesFieldBuilder()
          .addBuilder(
              com.google.cloud.aiplatform.v1beta1
                  .SearchModelDeploymentMonitoringStatsAnomaliesRequest.StatsAnomaliesObjective
                  .getDefaultInstance());
    }
    /**
     *
     *
     * <pre>
     * Required. Objectives of the stats to retrieve.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.aiplatform.v1beta1.SearchModelDeploymentMonitoringStatsAnomaliesRequest.StatsAnomaliesObjective objectives = 4 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public com.google.cloud.aiplatform.v1beta1.SearchModelDeploymentMonitoringStatsAnomaliesRequest
            .StatsAnomaliesObjective.Builder
        addObjectivesBuilder(int index) {
      return getObjectivesFieldBuilder()
          .addBuilder(
              index,
              com.google.cloud.aiplatform.v1beta1
                  .SearchModelDeploymentMonitoringStatsAnomaliesRequest.StatsAnomaliesObjective
                  .getDefaultInstance());
    }
    /**
     *
     *
     * <pre>
     * Required. Objectives of the stats to retrieve.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.aiplatform.v1beta1.SearchModelDeploymentMonitoringStatsAnomaliesRequest.StatsAnomaliesObjective objectives = 4 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public java.util.List<
            com.google.cloud.aiplatform.v1beta1.SearchModelDeploymentMonitoringStatsAnomaliesRequest
                .StatsAnomaliesObjective.Builder>
        getObjectivesBuilderList() {
      return getObjectivesFieldBuilder().getBuilderList();
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.cloud.aiplatform.v1beta1.SearchModelDeploymentMonitoringStatsAnomaliesRequest
                .StatsAnomaliesObjective,
            com.google.cloud.aiplatform.v1beta1.SearchModelDeploymentMonitoringStatsAnomaliesRequest
                .StatsAnomaliesObjective.Builder,
            com.google.cloud.aiplatform.v1beta1.SearchModelDeploymentMonitoringStatsAnomaliesRequest
                .StatsAnomaliesObjectiveOrBuilder>
        getObjectivesFieldBuilder() {
      if (objectivesBuilder_ == null) {
        objectivesBuilder_ =
            new com.google.protobuf.RepeatedFieldBuilderV3<
                com.google.cloud.aiplatform.v1beta1
                    .SearchModelDeploymentMonitoringStatsAnomaliesRequest.StatsAnomaliesObjective,
                com.google.cloud.aiplatform.v1beta1
                    .SearchModelDeploymentMonitoringStatsAnomaliesRequest.StatsAnomaliesObjective
                    .Builder,
                com.google.cloud.aiplatform.v1beta1
                    .SearchModelDeploymentMonitoringStatsAnomaliesRequest
                    .StatsAnomaliesObjectiveOrBuilder>(
                objectives_, ((bitField0_ & 0x00000001) != 0), getParentForChildren(), isClean());
        objectives_ = null;
      }
      return objectivesBuilder_;
    }

    private int pageSize_;
    /**
     *
     *
     * <pre>
     * The standard list page size.
     * </pre>
     *
     * <code>int32 page_size = 5;</code>
     *
     * @return The pageSize.
     */
    @java.lang.Override
    public int getPageSize() {
      return pageSize_;
    }
    /**
     *
     *
     * <pre>
     * The standard list page size.
     * </pre>
     *
     * <code>int32 page_size = 5;</code>
     *
     * @param value The pageSize to set.
     * @return This builder for chaining.
     */
    public Builder setPageSize(int value) {

      pageSize_ = value;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The standard list page size.
     * </pre>
     *
     * <code>int32 page_size = 5;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearPageSize() {

      pageSize_ = 0;
      onChanged();
      return this;
    }

    private java.lang.Object pageToken_ = "";
    /**
     *
     *
     * <pre>
     * A page token received from a previous
     * [JobService.SearchModelDeploymentMonitoringStatsAnomalies][google.cloud.aiplatform.v1beta1.JobService.SearchModelDeploymentMonitoringStatsAnomalies]
     * call.
     * </pre>
     *
     * <code>string page_token = 6;</code>
     *
     * @return The pageToken.
     */
    public java.lang.String getPageToken() {
      java.lang.Object ref = pageToken_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        pageToken_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * A page token received from a previous
     * [JobService.SearchModelDeploymentMonitoringStatsAnomalies][google.cloud.aiplatform.v1beta1.JobService.SearchModelDeploymentMonitoringStatsAnomalies]
     * call.
     * </pre>
     *
     * <code>string page_token = 6;</code>
     *
     * @return The bytes for pageToken.
     */
    public com.google.protobuf.ByteString getPageTokenBytes() {
      java.lang.Object ref = pageToken_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        pageToken_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * A page token received from a previous
     * [JobService.SearchModelDeploymentMonitoringStatsAnomalies][google.cloud.aiplatform.v1beta1.JobService.SearchModelDeploymentMonitoringStatsAnomalies]
     * call.
     * </pre>
     *
     * <code>string page_token = 6;</code>
     *
     * @param value The pageToken to set.
     * @return This builder for chaining.
     */
    public Builder setPageToken(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }

      pageToken_ = value;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * A page token received from a previous
     * [JobService.SearchModelDeploymentMonitoringStatsAnomalies][google.cloud.aiplatform.v1beta1.JobService.SearchModelDeploymentMonitoringStatsAnomalies]
     * call.
     * </pre>
     *
     * <code>string page_token = 6;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearPageToken() {

      pageToken_ = getDefaultInstance().getPageToken();
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * A page token received from a previous
     * [JobService.SearchModelDeploymentMonitoringStatsAnomalies][google.cloud.aiplatform.v1beta1.JobService.SearchModelDeploymentMonitoringStatsAnomalies]
     * call.
     * </pre>
     *
     * <code>string page_token = 6;</code>
     *
     * @param value The bytes for pageToken to set.
     * @return This builder for chaining.
     */
    public Builder setPageTokenBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);

      pageToken_ = value;
      onChanged();
      return this;
    }

    private com.google.protobuf.Timestamp startTime_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Timestamp,
            com.google.protobuf.Timestamp.Builder,
            com.google.protobuf.TimestampOrBuilder>
        startTimeBuilder_;
    /**
     *
     *
     * <pre>
     * The earliest timestamp of stats being generated.
     * If not set, indicates fetching stats till the earliest possible one.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp start_time = 7;</code>
     *
     * @return Whether the startTime field is set.
     */
    public boolean hasStartTime() {
      return startTimeBuilder_ != null || startTime_ != null;
    }
    /**
     *
     *
     * <pre>
     * The earliest timestamp of stats being generated.
     * If not set, indicates fetching stats till the earliest possible one.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp start_time = 7;</code>
     *
     * @return The startTime.
     */
    public com.google.protobuf.Timestamp getStartTime() {
      if (startTimeBuilder_ == null) {
        return startTime_ == null ? com.google.protobuf.Timestamp.getDefaultInstance() : startTime_;
      } else {
        return startTimeBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * The earliest timestamp of stats being generated.
     * If not set, indicates fetching stats till the earliest possible one.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp start_time = 7;</code>
     */
    public Builder setStartTime(com.google.protobuf.Timestamp value) {
      if (startTimeBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        startTime_ = value;
        onChanged();
      } else {
        startTimeBuilder_.setMessage(value);
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * The earliest timestamp of stats being generated.
     * If not set, indicates fetching stats till the earliest possible one.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp start_time = 7;</code>
     */
    public Builder setStartTime(com.google.protobuf.Timestamp.Builder builderForValue) {
      if (startTimeBuilder_ == null) {
        startTime_ = builderForValue.build();
        onChanged();
      } else {
        startTimeBuilder_.setMessage(builderForValue.build());
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * The earliest timestamp of stats being generated.
     * If not set, indicates fetching stats till the earliest possible one.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp start_time = 7;</code>
     */
    public Builder mergeStartTime(com.google.protobuf.Timestamp value) {
      if (startTimeBuilder_ == null) {
        if (startTime_ != null) {
          startTime_ =
              com.google.protobuf.Timestamp.newBuilder(startTime_).mergeFrom(value).buildPartial();
        } else {
          startTime_ = value;
        }
        onChanged();
      } else {
        startTimeBuilder_.mergeFrom(value);
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * The earliest timestamp of stats being generated.
     * If not set, indicates fetching stats till the earliest possible one.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp start_time = 7;</code>
     */
    public Builder clearStartTime() {
      if (startTimeBuilder_ == null) {
        startTime_ = null;
        onChanged();
      } else {
        startTime_ = null;
        startTimeBuilder_ = null;
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * The earliest timestamp of stats being generated.
     * If not set, indicates fetching stats till the earliest possible one.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp start_time = 7;</code>
     */
    public com.google.protobuf.Timestamp.Builder getStartTimeBuilder() {

      onChanged();
      return getStartTimeFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * The earliest timestamp of stats being generated.
     * If not set, indicates fetching stats till the earliest possible one.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp start_time = 7;</code>
     */
    public com.google.protobuf.TimestampOrBuilder getStartTimeOrBuilder() {
      if (startTimeBuilder_ != null) {
        return startTimeBuilder_.getMessageOrBuilder();
      } else {
        return startTime_ == null ? com.google.protobuf.Timestamp.getDefaultInstance() : startTime_;
      }
    }
    /**
     *
     *
     * <pre>
     * The earliest timestamp of stats being generated.
     * If not set, indicates fetching stats till the earliest possible one.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp start_time = 7;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Timestamp,
            com.google.protobuf.Timestamp.Builder,
            com.google.protobuf.TimestampOrBuilder>
        getStartTimeFieldBuilder() {
      if (startTimeBuilder_ == null) {
        startTimeBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.protobuf.Timestamp,
                com.google.protobuf.Timestamp.Builder,
                com.google.protobuf.TimestampOrBuilder>(
                getStartTime(), getParentForChildren(), isClean());
        startTime_ = null;
      }
      return startTimeBuilder_;
    }

    private com.google.protobuf.Timestamp endTime_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Timestamp,
            com.google.protobuf.Timestamp.Builder,
            com.google.protobuf.TimestampOrBuilder>
        endTimeBuilder_;
    /**
     *
     *
     * <pre>
     * The latest timestamp of stats being generated.
     * If not set, indicates feching stats till the latest possible one.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp end_time = 8;</code>
     *
     * @return Whether the endTime field is set.
     */
    public boolean hasEndTime() {
      return endTimeBuilder_ != null || endTime_ != null;
    }
    /**
     *
     *
     * <pre>
     * The latest timestamp of stats being generated.
     * If not set, indicates feching stats till the latest possible one.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp end_time = 8;</code>
     *
     * @return The endTime.
     */
    public com.google.protobuf.Timestamp getEndTime() {
      if (endTimeBuilder_ == null) {
        return endTime_ == null ? com.google.protobuf.Timestamp.getDefaultInstance() : endTime_;
      } else {
        return endTimeBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * The latest timestamp of stats being generated.
     * If not set, indicates feching stats till the latest possible one.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp end_time = 8;</code>
     */
    public Builder setEndTime(com.google.protobuf.Timestamp value) {
      if (endTimeBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        endTime_ = value;
        onChanged();
      } else {
        endTimeBuilder_.setMessage(value);
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * The latest timestamp of stats being generated.
     * If not set, indicates feching stats till the latest possible one.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp end_time = 8;</code>
     */
    public Builder setEndTime(com.google.protobuf.Timestamp.Builder builderForValue) {
      if (endTimeBuilder_ == null) {
        endTime_ = builderForValue.build();
        onChanged();
      } else {
        endTimeBuilder_.setMessage(builderForValue.build());
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * The latest timestamp of stats being generated.
     * If not set, indicates feching stats till the latest possible one.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp end_time = 8;</code>
     */
    public Builder mergeEndTime(com.google.protobuf.Timestamp value) {
      if (endTimeBuilder_ == null) {
        if (endTime_ != null) {
          endTime_ =
              com.google.protobuf.Timestamp.newBuilder(endTime_).mergeFrom(value).buildPartial();
        } else {
          endTime_ = value;
        }
        onChanged();
      } else {
        endTimeBuilder_.mergeFrom(value);
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * The latest timestamp of stats being generated.
     * If not set, indicates feching stats till the latest possible one.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp end_time = 8;</code>
     */
    public Builder clearEndTime() {
      if (endTimeBuilder_ == null) {
        endTime_ = null;
        onChanged();
      } else {
        endTime_ = null;
        endTimeBuilder_ = null;
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * The latest timestamp of stats being generated.
     * If not set, indicates feching stats till the latest possible one.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp end_time = 8;</code>
     */
    public com.google.protobuf.Timestamp.Builder getEndTimeBuilder() {

      onChanged();
      return getEndTimeFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * The latest timestamp of stats being generated.
     * If not set, indicates feching stats till the latest possible one.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp end_time = 8;</code>
     */
    public com.google.protobuf.TimestampOrBuilder getEndTimeOrBuilder() {
      if (endTimeBuilder_ != null) {
        return endTimeBuilder_.getMessageOrBuilder();
      } else {
        return endTime_ == null ? com.google.protobuf.Timestamp.getDefaultInstance() : endTime_;
      }
    }
    /**
     *
     *
     * <pre>
     * The latest timestamp of stats being generated.
     * If not set, indicates feching stats till the latest possible one.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp end_time = 8;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Timestamp,
            com.google.protobuf.Timestamp.Builder,
            com.google.protobuf.TimestampOrBuilder>
        getEndTimeFieldBuilder() {
      if (endTimeBuilder_ == null) {
        endTimeBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.protobuf.Timestamp,
                com.google.protobuf.Timestamp.Builder,
                com.google.protobuf.TimestampOrBuilder>(
                getEndTime(), getParentForChildren(), isClean());
        endTime_ = null;
      }
      return endTimeBuilder_;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.cloud.aiplatform.v1beta1.SearchModelDeploymentMonitoringStatsAnomaliesRequest)
  }

  // @@protoc_insertion_point(class_scope:google.cloud.aiplatform.v1beta1.SearchModelDeploymentMonitoringStatsAnomaliesRequest)
  private static final com.google.cloud.aiplatform.v1beta1
          .SearchModelDeploymentMonitoringStatsAnomaliesRequest
      DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE =
        new com.google.cloud.aiplatform.v1beta1
            .SearchModelDeploymentMonitoringStatsAnomaliesRequest();
  }

  public static com.google.cloud.aiplatform.v1beta1
          .SearchModelDeploymentMonitoringStatsAnomaliesRequest
      getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<
          SearchModelDeploymentMonitoringStatsAnomaliesRequest>
      PARSER =
          new com.google.protobuf.AbstractParser<
              SearchModelDeploymentMonitoringStatsAnomaliesRequest>() {
            @java.lang.Override
            public SearchModelDeploymentMonitoringStatsAnomaliesRequest parsePartialFrom(
                com.google.protobuf.CodedInputStream input,
                com.google.protobuf.ExtensionRegistryLite extensionRegistry)
                throws com.google.protobuf.InvalidProtocolBufferException {
              return new SearchModelDeploymentMonitoringStatsAnomaliesRequest(
                  input, extensionRegistry);
            }
          };

  public static com.google.protobuf.Parser<SearchModelDeploymentMonitoringStatsAnomaliesRequest>
      parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<SearchModelDeploymentMonitoringStatsAnomaliesRequest>
      getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.cloud.aiplatform.v1beta1.SearchModelDeploymentMonitoringStatsAnomaliesRequest
      getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
