/*
 * Copyright 2020 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/cloud/aiplatform/v1beta1/specialist_pool.proto

package com.google.cloud.aiplatform.v1beta1;

/**
 *
 *
 * <pre>
 * SpecialistPool represents customers' own workforce to work on their data
 * labeling jobs. It includes a group of specialist managers and workers.
 * Managers are responsible for managing the workers in this pool as well as
 * customers' data labeling jobs associated with this pool. Customers create
 * specialist pool as well as start data labeling jobs on Cloud, managers and
 * workers handle the jobs using CrowdCompute console.
 * </pre>
 *
 * Protobuf type {@code google.cloud.aiplatform.v1beta1.SpecialistPool}
 */
public final class SpecialistPool extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.cloud.aiplatform.v1beta1.SpecialistPool)
    SpecialistPoolOrBuilder {
  private static final long serialVersionUID = 0L;
  // Use SpecialistPool.newBuilder() to construct.
  private SpecialistPool(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private SpecialistPool() {
    name_ = "";
    displayName_ = "";
    specialistManagerEmails_ = com.google.protobuf.LazyStringArrayList.EMPTY;
    pendingDataLabelingJobs_ = com.google.protobuf.LazyStringArrayList.EMPTY;
  }

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new SpecialistPool();
  }

  @java.lang.Override
  public final com.google.protobuf.UnknownFieldSet getUnknownFields() {
    return this.unknownFields;
  }

  private SpecialistPool(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    this();
    if (extensionRegistry == null) {
      throw new java.lang.NullPointerException();
    }
    int mutable_bitField0_ = 0;
    com.google.protobuf.UnknownFieldSet.Builder unknownFields =
        com.google.protobuf.UnknownFieldSet.newBuilder();
    try {
      boolean done = false;
      while (!done) {
        int tag = input.readTag();
        switch (tag) {
          case 0:
            done = true;
            break;
          case 10:
            {
              java.lang.String s = input.readStringRequireUtf8();

              name_ = s;
              break;
            }
          case 18:
            {
              java.lang.String s = input.readStringRequireUtf8();

              displayName_ = s;
              break;
            }
          case 24:
            {
              specialistManagersCount_ = input.readInt32();
              break;
            }
          case 34:
            {
              java.lang.String s = input.readStringRequireUtf8();
              if (!((mutable_bitField0_ & 0x00000001) != 0)) {
                specialistManagerEmails_ = new com.google.protobuf.LazyStringArrayList();
                mutable_bitField0_ |= 0x00000001;
              }
              specialistManagerEmails_.add(s);
              break;
            }
          case 42:
            {
              java.lang.String s = input.readStringRequireUtf8();
              if (!((mutable_bitField0_ & 0x00000002) != 0)) {
                pendingDataLabelingJobs_ = new com.google.protobuf.LazyStringArrayList();
                mutable_bitField0_ |= 0x00000002;
              }
              pendingDataLabelingJobs_.add(s);
              break;
            }
          default:
            {
              if (!parseUnknownField(input, unknownFields, extensionRegistry, tag)) {
                done = true;
              }
              break;
            }
        }
      }
    } catch (com.google.protobuf.InvalidProtocolBufferException e) {
      throw e.setUnfinishedMessage(this);
    } catch (java.io.IOException e) {
      throw new com.google.protobuf.InvalidProtocolBufferException(e).setUnfinishedMessage(this);
    } finally {
      if (((mutable_bitField0_ & 0x00000001) != 0)) {
        specialistManagerEmails_ = specialistManagerEmails_.getUnmodifiableView();
      }
      if (((mutable_bitField0_ & 0x00000002) != 0)) {
        pendingDataLabelingJobs_ = pendingDataLabelingJobs_.getUnmodifiableView();
      }
      this.unknownFields = unknownFields.build();
      makeExtensionsImmutable();
    }
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.cloud.aiplatform.v1beta1.SpecialistPoolProto
        .internal_static_google_cloud_aiplatform_v1beta1_SpecialistPool_descriptor;
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.cloud.aiplatform.v1beta1.SpecialistPoolProto
        .internal_static_google_cloud_aiplatform_v1beta1_SpecialistPool_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.cloud.aiplatform.v1beta1.SpecialistPool.class,
            com.google.cloud.aiplatform.v1beta1.SpecialistPool.Builder.class);
  }

  public static final int NAME_FIELD_NUMBER = 1;
  private volatile java.lang.Object name_;
  /**
   *
   *
   * <pre>
   * Required. The resource name of the SpecialistPool.
   * </pre>
   *
   * <code>string name = 1 [(.google.api.field_behavior) = REQUIRED];</code>
   *
   * @return The name.
   */
  @java.lang.Override
  public java.lang.String getName() {
    java.lang.Object ref = name_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      name_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Required. The resource name of the SpecialistPool.
   * </pre>
   *
   * <code>string name = 1 [(.google.api.field_behavior) = REQUIRED];</code>
   *
   * @return The bytes for name.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getNameBytes() {
    java.lang.Object ref = name_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      name_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int DISPLAY_NAME_FIELD_NUMBER = 2;
  private volatile java.lang.Object displayName_;
  /**
   *
   *
   * <pre>
   * Required. The user-defined name of the SpecialistPool.
   * The name can be up to 128 characters long and can be consist of any UTF-8
   * characters.
   * This field should be unique on project-level.
   * </pre>
   *
   * <code>string display_name = 2 [(.google.api.field_behavior) = REQUIRED];</code>
   *
   * @return The displayName.
   */
  @java.lang.Override
  public java.lang.String getDisplayName() {
    java.lang.Object ref = displayName_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      displayName_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Required. The user-defined name of the SpecialistPool.
   * The name can be up to 128 characters long and can be consist of any UTF-8
   * characters.
   * This field should be unique on project-level.
   * </pre>
   *
   * <code>string display_name = 2 [(.google.api.field_behavior) = REQUIRED];</code>
   *
   * @return The bytes for displayName.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getDisplayNameBytes() {
    java.lang.Object ref = displayName_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      displayName_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int SPECIALIST_MANAGERS_COUNT_FIELD_NUMBER = 3;
  private int specialistManagersCount_;
  /**
   *
   *
   * <pre>
   * Output only. The number of managers in this SpecialistPool.
   * </pre>
   *
   * <code>int32 specialist_managers_count = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
   *
   * @return The specialistManagersCount.
   */
  @java.lang.Override
  public int getSpecialistManagersCount() {
    return specialistManagersCount_;
  }

  public static final int SPECIALIST_MANAGER_EMAILS_FIELD_NUMBER = 4;
  private com.google.protobuf.LazyStringList specialistManagerEmails_;
  /**
   *
   *
   * <pre>
   * The email addresses of the managers in the SpecialistPool.
   * </pre>
   *
   * <code>repeated string specialist_manager_emails = 4;</code>
   *
   * @return A list containing the specialistManagerEmails.
   */
  public com.google.protobuf.ProtocolStringList getSpecialistManagerEmailsList() {
    return specialistManagerEmails_;
  }
  /**
   *
   *
   * <pre>
   * The email addresses of the managers in the SpecialistPool.
   * </pre>
   *
   * <code>repeated string specialist_manager_emails = 4;</code>
   *
   * @return The count of specialistManagerEmails.
   */
  public int getSpecialistManagerEmailsCount() {
    return specialistManagerEmails_.size();
  }
  /**
   *
   *
   * <pre>
   * The email addresses of the managers in the SpecialistPool.
   * </pre>
   *
   * <code>repeated string specialist_manager_emails = 4;</code>
   *
   * @param index The index of the element to return.
   * @return The specialistManagerEmails at the given index.
   */
  public java.lang.String getSpecialistManagerEmails(int index) {
    return specialistManagerEmails_.get(index);
  }
  /**
   *
   *
   * <pre>
   * The email addresses of the managers in the SpecialistPool.
   * </pre>
   *
   * <code>repeated string specialist_manager_emails = 4;</code>
   *
   * @param index The index of the value to return.
   * @return The bytes of the specialistManagerEmails at the given index.
   */
  public com.google.protobuf.ByteString getSpecialistManagerEmailsBytes(int index) {
    return specialistManagerEmails_.getByteString(index);
  }

  public static final int PENDING_DATA_LABELING_JOBS_FIELD_NUMBER = 5;
  private com.google.protobuf.LazyStringList pendingDataLabelingJobs_;
  /**
   *
   *
   * <pre>
   * Output only. The resource name of the pending data labeling jobs.
   * </pre>
   *
   * <code>
   * repeated string pending_data_labeling_jobs = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return A list containing the pendingDataLabelingJobs.
   */
  public com.google.protobuf.ProtocolStringList getPendingDataLabelingJobsList() {
    return pendingDataLabelingJobs_;
  }
  /**
   *
   *
   * <pre>
   * Output only. The resource name of the pending data labeling jobs.
   * </pre>
   *
   * <code>
   * repeated string pending_data_labeling_jobs = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return The count of pendingDataLabelingJobs.
   */
  public int getPendingDataLabelingJobsCount() {
    return pendingDataLabelingJobs_.size();
  }
  /**
   *
   *
   * <pre>
   * Output only. The resource name of the pending data labeling jobs.
   * </pre>
   *
   * <code>
   * repeated string pending_data_labeling_jobs = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @param index The index of the element to return.
   * @return The pendingDataLabelingJobs at the given index.
   */
  public java.lang.String getPendingDataLabelingJobs(int index) {
    return pendingDataLabelingJobs_.get(index);
  }
  /**
   *
   *
   * <pre>
   * Output only. The resource name of the pending data labeling jobs.
   * </pre>
   *
   * <code>
   * repeated string pending_data_labeling_jobs = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @param index The index of the value to return.
   * @return The bytes of the pendingDataLabelingJobs at the given index.
   */
  public com.google.protobuf.ByteString getPendingDataLabelingJobsBytes(int index) {
    return pendingDataLabelingJobs_.getByteString(index);
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    if (!getNameBytes().isEmpty()) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 1, name_);
    }
    if (!getDisplayNameBytes().isEmpty()) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 2, displayName_);
    }
    if (specialistManagersCount_ != 0) {
      output.writeInt32(3, specialistManagersCount_);
    }
    for (int i = 0; i < specialistManagerEmails_.size(); i++) {
      com.google.protobuf.GeneratedMessageV3.writeString(
          output, 4, specialistManagerEmails_.getRaw(i));
    }
    for (int i = 0; i < pendingDataLabelingJobs_.size(); i++) {
      com.google.protobuf.GeneratedMessageV3.writeString(
          output, 5, pendingDataLabelingJobs_.getRaw(i));
    }
    unknownFields.writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    if (!getNameBytes().isEmpty()) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(1, name_);
    }
    if (!getDisplayNameBytes().isEmpty()) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(2, displayName_);
    }
    if (specialistManagersCount_ != 0) {
      size += com.google.protobuf.CodedOutputStream.computeInt32Size(3, specialistManagersCount_);
    }
    {
      int dataSize = 0;
      for (int i = 0; i < specialistManagerEmails_.size(); i++) {
        dataSize += computeStringSizeNoTag(specialistManagerEmails_.getRaw(i));
      }
      size += dataSize;
      size += 1 * getSpecialistManagerEmailsList().size();
    }
    {
      int dataSize = 0;
      for (int i = 0; i < pendingDataLabelingJobs_.size(); i++) {
        dataSize += computeStringSizeNoTag(pendingDataLabelingJobs_.getRaw(i));
      }
      size += dataSize;
      size += 1 * getPendingDataLabelingJobsList().size();
    }
    size += unknownFields.getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.cloud.aiplatform.v1beta1.SpecialistPool)) {
      return super.equals(obj);
    }
    com.google.cloud.aiplatform.v1beta1.SpecialistPool other =
        (com.google.cloud.aiplatform.v1beta1.SpecialistPool) obj;

    if (!getName().equals(other.getName())) return false;
    if (!getDisplayName().equals(other.getDisplayName())) return false;
    if (getSpecialistManagersCount() != other.getSpecialistManagersCount()) return false;
    if (!getSpecialistManagerEmailsList().equals(other.getSpecialistManagerEmailsList()))
      return false;
    if (!getPendingDataLabelingJobsList().equals(other.getPendingDataLabelingJobsList()))
      return false;
    if (!unknownFields.equals(other.unknownFields)) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    hash = (37 * hash) + NAME_FIELD_NUMBER;
    hash = (53 * hash) + getName().hashCode();
    hash = (37 * hash) + DISPLAY_NAME_FIELD_NUMBER;
    hash = (53 * hash) + getDisplayName().hashCode();
    hash = (37 * hash) + SPECIALIST_MANAGERS_COUNT_FIELD_NUMBER;
    hash = (53 * hash) + getSpecialistManagersCount();
    if (getSpecialistManagerEmailsCount() > 0) {
      hash = (37 * hash) + SPECIALIST_MANAGER_EMAILS_FIELD_NUMBER;
      hash = (53 * hash) + getSpecialistManagerEmailsList().hashCode();
    }
    if (getPendingDataLabelingJobsCount() > 0) {
      hash = (37 * hash) + PENDING_DATA_LABELING_JOBS_FIELD_NUMBER;
      hash = (53 * hash) + getPendingDataLabelingJobsList().hashCode();
    }
    hash = (29 * hash) + unknownFields.hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.cloud.aiplatform.v1beta1.SpecialistPool parseFrom(
      java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.aiplatform.v1beta1.SpecialistPool parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.aiplatform.v1beta1.SpecialistPool parseFrom(
      com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.aiplatform.v1beta1.SpecialistPool parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.aiplatform.v1beta1.SpecialistPool parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.aiplatform.v1beta1.SpecialistPool parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.aiplatform.v1beta1.SpecialistPool parseFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.aiplatform.v1beta1.SpecialistPool parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.aiplatform.v1beta1.SpecialistPool parseDelimitedFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.cloud.aiplatform.v1beta1.SpecialistPool parseDelimitedFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.aiplatform.v1beta1.SpecialistPool parseFrom(
      com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.aiplatform.v1beta1.SpecialistPool parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(com.google.cloud.aiplatform.v1beta1.SpecialistPool prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }
  /**
   *
   *
   * <pre>
   * SpecialistPool represents customers' own workforce to work on their data
   * labeling jobs. It includes a group of specialist managers and workers.
   * Managers are responsible for managing the workers in this pool as well as
   * customers' data labeling jobs associated with this pool. Customers create
   * specialist pool as well as start data labeling jobs on Cloud, managers and
   * workers handle the jobs using CrowdCompute console.
   * </pre>
   *
   * Protobuf type {@code google.cloud.aiplatform.v1beta1.SpecialistPool}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.cloud.aiplatform.v1beta1.SpecialistPool)
      com.google.cloud.aiplatform.v1beta1.SpecialistPoolOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.aiplatform.v1beta1.SpecialistPoolProto
          .internal_static_google_cloud_aiplatform_v1beta1_SpecialistPool_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.aiplatform.v1beta1.SpecialistPoolProto
          .internal_static_google_cloud_aiplatform_v1beta1_SpecialistPool_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.aiplatform.v1beta1.SpecialistPool.class,
              com.google.cloud.aiplatform.v1beta1.SpecialistPool.Builder.class);
    }

    // Construct using com.google.cloud.aiplatform.v1beta1.SpecialistPool.newBuilder()
    private Builder() {
      maybeForceBuilderInitialization();
    }

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
      maybeForceBuilderInitialization();
    }

    private void maybeForceBuilderInitialization() {
      if (com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders) {}
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      name_ = "";

      displayName_ = "";

      specialistManagersCount_ = 0;

      specialistManagerEmails_ = com.google.protobuf.LazyStringArrayList.EMPTY;
      bitField0_ = (bitField0_ & ~0x00000001);
      pendingDataLabelingJobs_ = com.google.protobuf.LazyStringArrayList.EMPTY;
      bitField0_ = (bitField0_ & ~0x00000002);
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.cloud.aiplatform.v1beta1.SpecialistPoolProto
          .internal_static_google_cloud_aiplatform_v1beta1_SpecialistPool_descriptor;
    }

    @java.lang.Override
    public com.google.cloud.aiplatform.v1beta1.SpecialistPool getDefaultInstanceForType() {
      return com.google.cloud.aiplatform.v1beta1.SpecialistPool.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.cloud.aiplatform.v1beta1.SpecialistPool build() {
      com.google.cloud.aiplatform.v1beta1.SpecialistPool result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.cloud.aiplatform.v1beta1.SpecialistPool buildPartial() {
      com.google.cloud.aiplatform.v1beta1.SpecialistPool result =
          new com.google.cloud.aiplatform.v1beta1.SpecialistPool(this);
      int from_bitField0_ = bitField0_;
      result.name_ = name_;
      result.displayName_ = displayName_;
      result.specialistManagersCount_ = specialistManagersCount_;
      if (((bitField0_ & 0x00000001) != 0)) {
        specialistManagerEmails_ = specialistManagerEmails_.getUnmodifiableView();
        bitField0_ = (bitField0_ & ~0x00000001);
      }
      result.specialistManagerEmails_ = specialistManagerEmails_;
      if (((bitField0_ & 0x00000002) != 0)) {
        pendingDataLabelingJobs_ = pendingDataLabelingJobs_.getUnmodifiableView();
        bitField0_ = (bitField0_ & ~0x00000002);
      }
      result.pendingDataLabelingJobs_ = pendingDataLabelingJobs_;
      onBuilt();
      return result;
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.cloud.aiplatform.v1beta1.SpecialistPool) {
        return mergeFrom((com.google.cloud.aiplatform.v1beta1.SpecialistPool) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(com.google.cloud.aiplatform.v1beta1.SpecialistPool other) {
      if (other == com.google.cloud.aiplatform.v1beta1.SpecialistPool.getDefaultInstance())
        return this;
      if (!other.getName().isEmpty()) {
        name_ = other.name_;
        onChanged();
      }
      if (!other.getDisplayName().isEmpty()) {
        displayName_ = other.displayName_;
        onChanged();
      }
      if (other.getSpecialistManagersCount() != 0) {
        setSpecialistManagersCount(other.getSpecialistManagersCount());
      }
      if (!other.specialistManagerEmails_.isEmpty()) {
        if (specialistManagerEmails_.isEmpty()) {
          specialistManagerEmails_ = other.specialistManagerEmails_;
          bitField0_ = (bitField0_ & ~0x00000001);
        } else {
          ensureSpecialistManagerEmailsIsMutable();
          specialistManagerEmails_.addAll(other.specialistManagerEmails_);
        }
        onChanged();
      }
      if (!other.pendingDataLabelingJobs_.isEmpty()) {
        if (pendingDataLabelingJobs_.isEmpty()) {
          pendingDataLabelingJobs_ = other.pendingDataLabelingJobs_;
          bitField0_ = (bitField0_ & ~0x00000002);
        } else {
          ensurePendingDataLabelingJobsIsMutable();
          pendingDataLabelingJobs_.addAll(other.pendingDataLabelingJobs_);
        }
        onChanged();
      }
      this.mergeUnknownFields(other.unknownFields);
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      com.google.cloud.aiplatform.v1beta1.SpecialistPool parsedMessage = null;
      try {
        parsedMessage = PARSER.parsePartialFrom(input, extensionRegistry);
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        parsedMessage =
            (com.google.cloud.aiplatform.v1beta1.SpecialistPool) e.getUnfinishedMessage();
        throw e.unwrapIOException();
      } finally {
        if (parsedMessage != null) {
          mergeFrom(parsedMessage);
        }
      }
      return this;
    }

    private int bitField0_;

    private java.lang.Object name_ = "";
    /**
     *
     *
     * <pre>
     * Required. The resource name of the SpecialistPool.
     * </pre>
     *
     * <code>string name = 1 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return The name.
     */
    public java.lang.String getName() {
      java.lang.Object ref = name_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        name_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Required. The resource name of the SpecialistPool.
     * </pre>
     *
     * <code>string name = 1 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return The bytes for name.
     */
    public com.google.protobuf.ByteString getNameBytes() {
      java.lang.Object ref = name_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        name_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Required. The resource name of the SpecialistPool.
     * </pre>
     *
     * <code>string name = 1 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @param value The name to set.
     * @return This builder for chaining.
     */
    public Builder setName(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }

      name_ = value;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. The resource name of the SpecialistPool.
     * </pre>
     *
     * <code>string name = 1 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearName() {

      name_ = getDefaultInstance().getName();
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. The resource name of the SpecialistPool.
     * </pre>
     *
     * <code>string name = 1 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @param value The bytes for name to set.
     * @return This builder for chaining.
     */
    public Builder setNameBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);

      name_ = value;
      onChanged();
      return this;
    }

    private java.lang.Object displayName_ = "";
    /**
     *
     *
     * <pre>
     * Required. The user-defined name of the SpecialistPool.
     * The name can be up to 128 characters long and can be consist of any UTF-8
     * characters.
     * This field should be unique on project-level.
     * </pre>
     *
     * <code>string display_name = 2 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return The displayName.
     */
    public java.lang.String getDisplayName() {
      java.lang.Object ref = displayName_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        displayName_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Required. The user-defined name of the SpecialistPool.
     * The name can be up to 128 characters long and can be consist of any UTF-8
     * characters.
     * This field should be unique on project-level.
     * </pre>
     *
     * <code>string display_name = 2 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return The bytes for displayName.
     */
    public com.google.protobuf.ByteString getDisplayNameBytes() {
      java.lang.Object ref = displayName_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        displayName_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Required. The user-defined name of the SpecialistPool.
     * The name can be up to 128 characters long and can be consist of any UTF-8
     * characters.
     * This field should be unique on project-level.
     * </pre>
     *
     * <code>string display_name = 2 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @param value The displayName to set.
     * @return This builder for chaining.
     */
    public Builder setDisplayName(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }

      displayName_ = value;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. The user-defined name of the SpecialistPool.
     * The name can be up to 128 characters long and can be consist of any UTF-8
     * characters.
     * This field should be unique on project-level.
     * </pre>
     *
     * <code>string display_name = 2 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearDisplayName() {

      displayName_ = getDefaultInstance().getDisplayName();
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. The user-defined name of the SpecialistPool.
     * The name can be up to 128 characters long and can be consist of any UTF-8
     * characters.
     * This field should be unique on project-level.
     * </pre>
     *
     * <code>string display_name = 2 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @param value The bytes for displayName to set.
     * @return This builder for chaining.
     */
    public Builder setDisplayNameBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);

      displayName_ = value;
      onChanged();
      return this;
    }

    private int specialistManagersCount_;
    /**
     *
     *
     * <pre>
     * Output only. The number of managers in this SpecialistPool.
     * </pre>
     *
     * <code>int32 specialist_managers_count = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return The specialistManagersCount.
     */
    @java.lang.Override
    public int getSpecialistManagersCount() {
      return specialistManagersCount_;
    }
    /**
     *
     *
     * <pre>
     * Output only. The number of managers in this SpecialistPool.
     * </pre>
     *
     * <code>int32 specialist_managers_count = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @param value The specialistManagersCount to set.
     * @return This builder for chaining.
     */
    public Builder setSpecialistManagersCount(int value) {

      specialistManagersCount_ = value;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The number of managers in this SpecialistPool.
     * </pre>
     *
     * <code>int32 specialist_managers_count = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return This builder for chaining.
     */
    public Builder clearSpecialistManagersCount() {

      specialistManagersCount_ = 0;
      onChanged();
      return this;
    }

    private com.google.protobuf.LazyStringList specialistManagerEmails_ =
        com.google.protobuf.LazyStringArrayList.EMPTY;

    private void ensureSpecialistManagerEmailsIsMutable() {
      if (!((bitField0_ & 0x00000001) != 0)) {
        specialistManagerEmails_ =
            new com.google.protobuf.LazyStringArrayList(specialistManagerEmails_);
        bitField0_ |= 0x00000001;
      }
    }
    /**
     *
     *
     * <pre>
     * The email addresses of the managers in the SpecialistPool.
     * </pre>
     *
     * <code>repeated string specialist_manager_emails = 4;</code>
     *
     * @return A list containing the specialistManagerEmails.
     */
    public com.google.protobuf.ProtocolStringList getSpecialistManagerEmailsList() {
      return specialistManagerEmails_.getUnmodifiableView();
    }
    /**
     *
     *
     * <pre>
     * The email addresses of the managers in the SpecialistPool.
     * </pre>
     *
     * <code>repeated string specialist_manager_emails = 4;</code>
     *
     * @return The count of specialistManagerEmails.
     */
    public int getSpecialistManagerEmailsCount() {
      return specialistManagerEmails_.size();
    }
    /**
     *
     *
     * <pre>
     * The email addresses of the managers in the SpecialistPool.
     * </pre>
     *
     * <code>repeated string specialist_manager_emails = 4;</code>
     *
     * @param index The index of the element to return.
     * @return The specialistManagerEmails at the given index.
     */
    public java.lang.String getSpecialistManagerEmails(int index) {
      return specialistManagerEmails_.get(index);
    }
    /**
     *
     *
     * <pre>
     * The email addresses of the managers in the SpecialistPool.
     * </pre>
     *
     * <code>repeated string specialist_manager_emails = 4;</code>
     *
     * @param index The index of the value to return.
     * @return The bytes of the specialistManagerEmails at the given index.
     */
    public com.google.protobuf.ByteString getSpecialistManagerEmailsBytes(int index) {
      return specialistManagerEmails_.getByteString(index);
    }
    /**
     *
     *
     * <pre>
     * The email addresses of the managers in the SpecialistPool.
     * </pre>
     *
     * <code>repeated string specialist_manager_emails = 4;</code>
     *
     * @param index The index to set the value at.
     * @param value The specialistManagerEmails to set.
     * @return This builder for chaining.
     */
    public Builder setSpecialistManagerEmails(int index, java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      ensureSpecialistManagerEmailsIsMutable();
      specialistManagerEmails_.set(index, value);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The email addresses of the managers in the SpecialistPool.
     * </pre>
     *
     * <code>repeated string specialist_manager_emails = 4;</code>
     *
     * @param value The specialistManagerEmails to add.
     * @return This builder for chaining.
     */
    public Builder addSpecialistManagerEmails(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      ensureSpecialistManagerEmailsIsMutable();
      specialistManagerEmails_.add(value);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The email addresses of the managers in the SpecialistPool.
     * </pre>
     *
     * <code>repeated string specialist_manager_emails = 4;</code>
     *
     * @param values The specialistManagerEmails to add.
     * @return This builder for chaining.
     */
    public Builder addAllSpecialistManagerEmails(java.lang.Iterable<java.lang.String> values) {
      ensureSpecialistManagerEmailsIsMutable();
      com.google.protobuf.AbstractMessageLite.Builder.addAll(values, specialistManagerEmails_);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The email addresses of the managers in the SpecialistPool.
     * </pre>
     *
     * <code>repeated string specialist_manager_emails = 4;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearSpecialistManagerEmails() {
      specialistManagerEmails_ = com.google.protobuf.LazyStringArrayList.EMPTY;
      bitField0_ = (bitField0_ & ~0x00000001);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The email addresses of the managers in the SpecialistPool.
     * </pre>
     *
     * <code>repeated string specialist_manager_emails = 4;</code>
     *
     * @param value The bytes of the specialistManagerEmails to add.
     * @return This builder for chaining.
     */
    public Builder addSpecialistManagerEmailsBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      ensureSpecialistManagerEmailsIsMutable();
      specialistManagerEmails_.add(value);
      onChanged();
      return this;
    }

    private com.google.protobuf.LazyStringList pendingDataLabelingJobs_ =
        com.google.protobuf.LazyStringArrayList.EMPTY;

    private void ensurePendingDataLabelingJobsIsMutable() {
      if (!((bitField0_ & 0x00000002) != 0)) {
        pendingDataLabelingJobs_ =
            new com.google.protobuf.LazyStringArrayList(pendingDataLabelingJobs_);
        bitField0_ |= 0x00000002;
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. The resource name of the pending data labeling jobs.
     * </pre>
     *
     * <code>
     * repeated string pending_data_labeling_jobs = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return A list containing the pendingDataLabelingJobs.
     */
    public com.google.protobuf.ProtocolStringList getPendingDataLabelingJobsList() {
      return pendingDataLabelingJobs_.getUnmodifiableView();
    }
    /**
     *
     *
     * <pre>
     * Output only. The resource name of the pending data labeling jobs.
     * </pre>
     *
     * <code>
     * repeated string pending_data_labeling_jobs = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return The count of pendingDataLabelingJobs.
     */
    public int getPendingDataLabelingJobsCount() {
      return pendingDataLabelingJobs_.size();
    }
    /**
     *
     *
     * <pre>
     * Output only. The resource name of the pending data labeling jobs.
     * </pre>
     *
     * <code>
     * repeated string pending_data_labeling_jobs = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @param index The index of the element to return.
     * @return The pendingDataLabelingJobs at the given index.
     */
    public java.lang.String getPendingDataLabelingJobs(int index) {
      return pendingDataLabelingJobs_.get(index);
    }
    /**
     *
     *
     * <pre>
     * Output only. The resource name of the pending data labeling jobs.
     * </pre>
     *
     * <code>
     * repeated string pending_data_labeling_jobs = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @param index The index of the value to return.
     * @return The bytes of the pendingDataLabelingJobs at the given index.
     */
    public com.google.protobuf.ByteString getPendingDataLabelingJobsBytes(int index) {
      return pendingDataLabelingJobs_.getByteString(index);
    }
    /**
     *
     *
     * <pre>
     * Output only. The resource name of the pending data labeling jobs.
     * </pre>
     *
     * <code>
     * repeated string pending_data_labeling_jobs = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @param index The index to set the value at.
     * @param value The pendingDataLabelingJobs to set.
     * @return This builder for chaining.
     */
    public Builder setPendingDataLabelingJobs(int index, java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      ensurePendingDataLabelingJobsIsMutable();
      pendingDataLabelingJobs_.set(index, value);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The resource name of the pending data labeling jobs.
     * </pre>
     *
     * <code>
     * repeated string pending_data_labeling_jobs = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @param value The pendingDataLabelingJobs to add.
     * @return This builder for chaining.
     */
    public Builder addPendingDataLabelingJobs(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      ensurePendingDataLabelingJobsIsMutable();
      pendingDataLabelingJobs_.add(value);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The resource name of the pending data labeling jobs.
     * </pre>
     *
     * <code>
     * repeated string pending_data_labeling_jobs = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @param values The pendingDataLabelingJobs to add.
     * @return This builder for chaining.
     */
    public Builder addAllPendingDataLabelingJobs(java.lang.Iterable<java.lang.String> values) {
      ensurePendingDataLabelingJobsIsMutable();
      com.google.protobuf.AbstractMessageLite.Builder.addAll(values, pendingDataLabelingJobs_);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The resource name of the pending data labeling jobs.
     * </pre>
     *
     * <code>
     * repeated string pending_data_labeling_jobs = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return This builder for chaining.
     */
    public Builder clearPendingDataLabelingJobs() {
      pendingDataLabelingJobs_ = com.google.protobuf.LazyStringArrayList.EMPTY;
      bitField0_ = (bitField0_ & ~0x00000002);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The resource name of the pending data labeling jobs.
     * </pre>
     *
     * <code>
     * repeated string pending_data_labeling_jobs = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @param value The bytes of the pendingDataLabelingJobs to add.
     * @return This builder for chaining.
     */
    public Builder addPendingDataLabelingJobsBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      ensurePendingDataLabelingJobsIsMutable();
      pendingDataLabelingJobs_.add(value);
      onChanged();
      return this;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.cloud.aiplatform.v1beta1.SpecialistPool)
  }

  // @@protoc_insertion_point(class_scope:google.cloud.aiplatform.v1beta1.SpecialistPool)
  private static final com.google.cloud.aiplatform.v1beta1.SpecialistPool DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.cloud.aiplatform.v1beta1.SpecialistPool();
  }

  public static com.google.cloud.aiplatform.v1beta1.SpecialistPool getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<SpecialistPool> PARSER =
      new com.google.protobuf.AbstractParser<SpecialistPool>() {
        @java.lang.Override
        public SpecialistPool parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          return new SpecialistPool(input, extensionRegistry);
        }
      };

  public static com.google.protobuf.Parser<SpecialistPool> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<SpecialistPool> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.cloud.aiplatform.v1beta1.SpecialistPool getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
