/*
 * Copyright 2020 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/cloud/aiplatform/v1beta1/study.proto

package com.google.cloud.aiplatform.v1beta1;

/**
 *
 *
 * <pre>
 * Represents specification of a Study.
 * </pre>
 *
 * Protobuf type {@code google.cloud.aiplatform.v1beta1.StudySpec}
 */
public final class StudySpec extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.cloud.aiplatform.v1beta1.StudySpec)
    StudySpecOrBuilder {
  private static final long serialVersionUID = 0L;
  // Use StudySpec.newBuilder() to construct.
  private StudySpec(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private StudySpec() {
    metrics_ = java.util.Collections.emptyList();
    parameters_ = java.util.Collections.emptyList();
    algorithm_ = 0;
    observationNoise_ = 0;
    measurementSelectionType_ = 0;
  }

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new StudySpec();
  }

  @java.lang.Override
  public final com.google.protobuf.UnknownFieldSet getUnknownFields() {
    return this.unknownFields;
  }

  private StudySpec(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    this();
    if (extensionRegistry == null) {
      throw new java.lang.NullPointerException();
    }
    int mutable_bitField0_ = 0;
    com.google.protobuf.UnknownFieldSet.Builder unknownFields =
        com.google.protobuf.UnknownFieldSet.newBuilder();
    try {
      boolean done = false;
      while (!done) {
        int tag = input.readTag();
        switch (tag) {
          case 0:
            done = true;
            break;
          case 10:
            {
              if (!((mutable_bitField0_ & 0x00000001) != 0)) {
                metrics_ =
                    new java.util.ArrayList<
                        com.google.cloud.aiplatform.v1beta1.StudySpec.MetricSpec>();
                mutable_bitField0_ |= 0x00000001;
              }
              metrics_.add(
                  input.readMessage(
                      com.google.cloud.aiplatform.v1beta1.StudySpec.MetricSpec.parser(),
                      extensionRegistry));
              break;
            }
          case 18:
            {
              if (!((mutable_bitField0_ & 0x00000002) != 0)) {
                parameters_ =
                    new java.util.ArrayList<
                        com.google.cloud.aiplatform.v1beta1.StudySpec.ParameterSpec>();
                mutable_bitField0_ |= 0x00000002;
              }
              parameters_.add(
                  input.readMessage(
                      com.google.cloud.aiplatform.v1beta1.StudySpec.ParameterSpec.parser(),
                      extensionRegistry));
              break;
            }
          case 24:
            {
              int rawValue = input.readEnum();

              algorithm_ = rawValue;
              break;
            }
          case 34:
            {
              com.google.cloud.aiplatform.v1beta1.StudySpec.DecayCurveAutomatedStoppingSpec.Builder
                  subBuilder = null;
              if (automatedStoppingSpecCase_ == 4) {
                subBuilder =
                    ((com.google.cloud.aiplatform.v1beta1.StudySpec.DecayCurveAutomatedStoppingSpec)
                            automatedStoppingSpec_)
                        .toBuilder();
              }
              automatedStoppingSpec_ =
                  input.readMessage(
                      com.google.cloud.aiplatform.v1beta1.StudySpec.DecayCurveAutomatedStoppingSpec
                          .parser(),
                      extensionRegistry);
              if (subBuilder != null) {
                subBuilder.mergeFrom(
                    (com.google.cloud.aiplatform.v1beta1.StudySpec.DecayCurveAutomatedStoppingSpec)
                        automatedStoppingSpec_);
                automatedStoppingSpec_ = subBuilder.buildPartial();
              }
              automatedStoppingSpecCase_ = 4;
              break;
            }
          case 42:
            {
              com.google.cloud.aiplatform.v1beta1.StudySpec.MedianAutomatedStoppingSpec.Builder
                  subBuilder = null;
              if (automatedStoppingSpecCase_ == 5) {
                subBuilder =
                    ((com.google.cloud.aiplatform.v1beta1.StudySpec.MedianAutomatedStoppingSpec)
                            automatedStoppingSpec_)
                        .toBuilder();
              }
              automatedStoppingSpec_ =
                  input.readMessage(
                      com.google.cloud.aiplatform.v1beta1.StudySpec.MedianAutomatedStoppingSpec
                          .parser(),
                      extensionRegistry);
              if (subBuilder != null) {
                subBuilder.mergeFrom(
                    (com.google.cloud.aiplatform.v1beta1.StudySpec.MedianAutomatedStoppingSpec)
                        automatedStoppingSpec_);
                automatedStoppingSpec_ = subBuilder.buildPartial();
              }
              automatedStoppingSpecCase_ = 5;
              break;
            }
          case 48:
            {
              int rawValue = input.readEnum();

              observationNoise_ = rawValue;
              break;
            }
          case 56:
            {
              int rawValue = input.readEnum();

              measurementSelectionType_ = rawValue;
              break;
            }
          case 66:
            {
              com.google.cloud.aiplatform.v1beta1.StudySpec.ConvexStopConfig.Builder subBuilder =
                  null;
              if (automatedStoppingSpecCase_ == 8) {
                subBuilder =
                    ((com.google.cloud.aiplatform.v1beta1.StudySpec.ConvexStopConfig)
                            automatedStoppingSpec_)
                        .toBuilder();
              }
              automatedStoppingSpec_ =
                  input.readMessage(
                      com.google.cloud.aiplatform.v1beta1.StudySpec.ConvexStopConfig.parser(),
                      extensionRegistry);
              if (subBuilder != null) {
                subBuilder.mergeFrom(
                    (com.google.cloud.aiplatform.v1beta1.StudySpec.ConvexStopConfig)
                        automatedStoppingSpec_);
                automatedStoppingSpec_ = subBuilder.buildPartial();
              }
              automatedStoppingSpecCase_ = 8;
              break;
            }
          default:
            {
              if (!parseUnknownField(input, unknownFields, extensionRegistry, tag)) {
                done = true;
              }
              break;
            }
        }
      }
    } catch (com.google.protobuf.InvalidProtocolBufferException e) {
      throw e.setUnfinishedMessage(this);
    } catch (java.io.IOException e) {
      throw new com.google.protobuf.InvalidProtocolBufferException(e).setUnfinishedMessage(this);
    } finally {
      if (((mutable_bitField0_ & 0x00000001) != 0)) {
        metrics_ = java.util.Collections.unmodifiableList(metrics_);
      }
      if (((mutable_bitField0_ & 0x00000002) != 0)) {
        parameters_ = java.util.Collections.unmodifiableList(parameters_);
      }
      this.unknownFields = unknownFields.build();
      makeExtensionsImmutable();
    }
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.cloud.aiplatform.v1beta1.StudyProto
        .internal_static_google_cloud_aiplatform_v1beta1_StudySpec_descriptor;
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.cloud.aiplatform.v1beta1.StudyProto
        .internal_static_google_cloud_aiplatform_v1beta1_StudySpec_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.cloud.aiplatform.v1beta1.StudySpec.class,
            com.google.cloud.aiplatform.v1beta1.StudySpec.Builder.class);
  }

  /**
   *
   *
   * <pre>
   * The available search algorithms for the Study.
   * </pre>
   *
   * Protobuf enum {@code google.cloud.aiplatform.v1beta1.StudySpec.Algorithm}
   */
  public enum Algorithm implements com.google.protobuf.ProtocolMessageEnum {
    /**
     *
     *
     * <pre>
     * The default algorithm used by Vertex AI for [hyperparameter
     * tuning](https://cloud.google.com/vertex-ai/docs/training/hyperparameter-tuning-overview)
     * and [Vertex Vizier](https://cloud.google.com/vertex-ai/docs/vizier).
     * </pre>
     *
     * <code>ALGORITHM_UNSPECIFIED = 0;</code>
     */
    ALGORITHM_UNSPECIFIED(0),
    /**
     *
     *
     * <pre>
     * Simple grid search within the feasible space. To use grid search,
     * all parameters must be `INTEGER`, `CATEGORICAL`, or `DISCRETE`.
     * </pre>
     *
     * <code>GRID_SEARCH = 2;</code>
     */
    GRID_SEARCH(2),
    /**
     *
     *
     * <pre>
     * Simple random search within the feasible space.
     * </pre>
     *
     * <code>RANDOM_SEARCH = 3;</code>
     */
    RANDOM_SEARCH(3),
    UNRECOGNIZED(-1),
    ;

    /**
     *
     *
     * <pre>
     * The default algorithm used by Vertex AI for [hyperparameter
     * tuning](https://cloud.google.com/vertex-ai/docs/training/hyperparameter-tuning-overview)
     * and [Vertex Vizier](https://cloud.google.com/vertex-ai/docs/vizier).
     * </pre>
     *
     * <code>ALGORITHM_UNSPECIFIED = 0;</code>
     */
    public static final int ALGORITHM_UNSPECIFIED_VALUE = 0;
    /**
     *
     *
     * <pre>
     * Simple grid search within the feasible space. To use grid search,
     * all parameters must be `INTEGER`, `CATEGORICAL`, or `DISCRETE`.
     * </pre>
     *
     * <code>GRID_SEARCH = 2;</code>
     */
    public static final int GRID_SEARCH_VALUE = 2;
    /**
     *
     *
     * <pre>
     * Simple random search within the feasible space.
     * </pre>
     *
     * <code>RANDOM_SEARCH = 3;</code>
     */
    public static final int RANDOM_SEARCH_VALUE = 3;

    public final int getNumber() {
      if (this == UNRECOGNIZED) {
        throw new java.lang.IllegalArgumentException(
            "Can't get the number of an unknown enum value.");
      }
      return value;
    }

    /**
     * @param value The numeric wire value of the corresponding enum entry.
     * @return The enum associated with the given numeric wire value.
     * @deprecated Use {@link #forNumber(int)} instead.
     */
    @java.lang.Deprecated
    public static Algorithm valueOf(int value) {
      return forNumber(value);
    }

    /**
     * @param value The numeric wire value of the corresponding enum entry.
     * @return The enum associated with the given numeric wire value.
     */
    public static Algorithm forNumber(int value) {
      switch (value) {
        case 0:
          return ALGORITHM_UNSPECIFIED;
        case 2:
          return GRID_SEARCH;
        case 3:
          return RANDOM_SEARCH;
        default:
          return null;
      }
    }

    public static com.google.protobuf.Internal.EnumLiteMap<Algorithm> internalGetValueMap() {
      return internalValueMap;
    }

    private static final com.google.protobuf.Internal.EnumLiteMap<Algorithm> internalValueMap =
        new com.google.protobuf.Internal.EnumLiteMap<Algorithm>() {
          public Algorithm findValueByNumber(int number) {
            return Algorithm.forNumber(number);
          }
        };

    public final com.google.protobuf.Descriptors.EnumValueDescriptor getValueDescriptor() {
      if (this == UNRECOGNIZED) {
        throw new java.lang.IllegalStateException(
            "Can't get the descriptor of an unrecognized enum value.");
      }
      return getDescriptor().getValues().get(ordinal());
    }

    public final com.google.protobuf.Descriptors.EnumDescriptor getDescriptorForType() {
      return getDescriptor();
    }

    public static final com.google.protobuf.Descriptors.EnumDescriptor getDescriptor() {
      return com.google.cloud.aiplatform.v1beta1.StudySpec.getDescriptor().getEnumTypes().get(0);
    }

    private static final Algorithm[] VALUES = values();

    public static Algorithm valueOf(com.google.protobuf.Descriptors.EnumValueDescriptor desc) {
      if (desc.getType() != getDescriptor()) {
        throw new java.lang.IllegalArgumentException("EnumValueDescriptor is not for this type.");
      }
      if (desc.getIndex() == -1) {
        return UNRECOGNIZED;
      }
      return VALUES[desc.getIndex()];
    }

    private final int value;

    private Algorithm(int value) {
      this.value = value;
    }

    // @@protoc_insertion_point(enum_scope:google.cloud.aiplatform.v1beta1.StudySpec.Algorithm)
  }

  /**
   *
   *
   * <pre>
   * Describes the noise level of the repeated observations.
   * "Noisy" means that the repeated observations with the same Trial parameters
   * may lead to different metric evaluations.
   * </pre>
   *
   * Protobuf enum {@code google.cloud.aiplatform.v1beta1.StudySpec.ObservationNoise}
   */
  public enum ObservationNoise implements com.google.protobuf.ProtocolMessageEnum {
    /**
     *
     *
     * <pre>
     * The default noise level chosen by Vertex AI.
     * </pre>
     *
     * <code>OBSERVATION_NOISE_UNSPECIFIED = 0;</code>
     */
    OBSERVATION_NOISE_UNSPECIFIED(0),
    /**
     *
     *
     * <pre>
     * Vertex AI assumes that the objective function is (nearly)
     * perfectly reproducible, and will never repeat the same Trial
     * parameters.
     * </pre>
     *
     * <code>LOW = 1;</code>
     */
    LOW(1),
    /**
     *
     *
     * <pre>
     * Vertex AI will estimate the amount of noise in metric
     * evaluations, it may repeat the same Trial parameters more than once.
     * </pre>
     *
     * <code>HIGH = 2;</code>
     */
    HIGH(2),
    UNRECOGNIZED(-1),
    ;

    /**
     *
     *
     * <pre>
     * The default noise level chosen by Vertex AI.
     * </pre>
     *
     * <code>OBSERVATION_NOISE_UNSPECIFIED = 0;</code>
     */
    public static final int OBSERVATION_NOISE_UNSPECIFIED_VALUE = 0;
    /**
     *
     *
     * <pre>
     * Vertex AI assumes that the objective function is (nearly)
     * perfectly reproducible, and will never repeat the same Trial
     * parameters.
     * </pre>
     *
     * <code>LOW = 1;</code>
     */
    public static final int LOW_VALUE = 1;
    /**
     *
     *
     * <pre>
     * Vertex AI will estimate the amount of noise in metric
     * evaluations, it may repeat the same Trial parameters more than once.
     * </pre>
     *
     * <code>HIGH = 2;</code>
     */
    public static final int HIGH_VALUE = 2;

    public final int getNumber() {
      if (this == UNRECOGNIZED) {
        throw new java.lang.IllegalArgumentException(
            "Can't get the number of an unknown enum value.");
      }
      return value;
    }

    /**
     * @param value The numeric wire value of the corresponding enum entry.
     * @return The enum associated with the given numeric wire value.
     * @deprecated Use {@link #forNumber(int)} instead.
     */
    @java.lang.Deprecated
    public static ObservationNoise valueOf(int value) {
      return forNumber(value);
    }

    /**
     * @param value The numeric wire value of the corresponding enum entry.
     * @return The enum associated with the given numeric wire value.
     */
    public static ObservationNoise forNumber(int value) {
      switch (value) {
        case 0:
          return OBSERVATION_NOISE_UNSPECIFIED;
        case 1:
          return LOW;
        case 2:
          return HIGH;
        default:
          return null;
      }
    }

    public static com.google.protobuf.Internal.EnumLiteMap<ObservationNoise> internalGetValueMap() {
      return internalValueMap;
    }

    private static final com.google.protobuf.Internal.EnumLiteMap<ObservationNoise>
        internalValueMap =
            new com.google.protobuf.Internal.EnumLiteMap<ObservationNoise>() {
              public ObservationNoise findValueByNumber(int number) {
                return ObservationNoise.forNumber(number);
              }
            };

    public final com.google.protobuf.Descriptors.EnumValueDescriptor getValueDescriptor() {
      if (this == UNRECOGNIZED) {
        throw new java.lang.IllegalStateException(
            "Can't get the descriptor of an unrecognized enum value.");
      }
      return getDescriptor().getValues().get(ordinal());
    }

    public final com.google.protobuf.Descriptors.EnumDescriptor getDescriptorForType() {
      return getDescriptor();
    }

    public static final com.google.protobuf.Descriptors.EnumDescriptor getDescriptor() {
      return com.google.cloud.aiplatform.v1beta1.StudySpec.getDescriptor().getEnumTypes().get(1);
    }

    private static final ObservationNoise[] VALUES = values();

    public static ObservationNoise valueOf(
        com.google.protobuf.Descriptors.EnumValueDescriptor desc) {
      if (desc.getType() != getDescriptor()) {
        throw new java.lang.IllegalArgumentException("EnumValueDescriptor is not for this type.");
      }
      if (desc.getIndex() == -1) {
        return UNRECOGNIZED;
      }
      return VALUES[desc.getIndex()];
    }

    private final int value;

    private ObservationNoise(int value) {
      this.value = value;
    }

    // @@protoc_insertion_point(enum_scope:google.cloud.aiplatform.v1beta1.StudySpec.ObservationNoise)
  }

  /**
   *
   *
   * <pre>
   * This indicates which measurement to use if/when the service automatically
   * selects the final measurement from previously reported intermediate
   * measurements. Choose this based on two considerations:
   *  A) Do you expect your measurements to monotonically improve?
   *     If so, choose LAST_MEASUREMENT. On the other hand, if you're in a
   *     situation where your system can "over-train" and you expect the
   *     performance to get better for a while but then start declining,
   *     choose BEST_MEASUREMENT.
   *  B) Are your measurements significantly noisy and/or irreproducible?
   *     If so, BEST_MEASUREMENT will tend to be over-optimistic, and it
   *     may be better to choose LAST_MEASUREMENT.
   *  If both or neither of (A) and (B) apply, it doesn't matter which
   *  selection type is chosen.
   * </pre>
   *
   * Protobuf enum {@code google.cloud.aiplatform.v1beta1.StudySpec.MeasurementSelectionType}
   */
  public enum MeasurementSelectionType implements com.google.protobuf.ProtocolMessageEnum {
    /**
     *
     *
     * <pre>
     * Will be treated as LAST_MEASUREMENT.
     * </pre>
     *
     * <code>MEASUREMENT_SELECTION_TYPE_UNSPECIFIED = 0;</code>
     */
    MEASUREMENT_SELECTION_TYPE_UNSPECIFIED(0),
    /**
     *
     *
     * <pre>
     * Use the last measurement reported.
     * </pre>
     *
     * <code>LAST_MEASUREMENT = 1;</code>
     */
    LAST_MEASUREMENT(1),
    /**
     *
     *
     * <pre>
     * Use the best measurement reported.
     * </pre>
     *
     * <code>BEST_MEASUREMENT = 2;</code>
     */
    BEST_MEASUREMENT(2),
    UNRECOGNIZED(-1),
    ;

    /**
     *
     *
     * <pre>
     * Will be treated as LAST_MEASUREMENT.
     * </pre>
     *
     * <code>MEASUREMENT_SELECTION_TYPE_UNSPECIFIED = 0;</code>
     */
    public static final int MEASUREMENT_SELECTION_TYPE_UNSPECIFIED_VALUE = 0;
    /**
     *
     *
     * <pre>
     * Use the last measurement reported.
     * </pre>
     *
     * <code>LAST_MEASUREMENT = 1;</code>
     */
    public static final int LAST_MEASUREMENT_VALUE = 1;
    /**
     *
     *
     * <pre>
     * Use the best measurement reported.
     * </pre>
     *
     * <code>BEST_MEASUREMENT = 2;</code>
     */
    public static final int BEST_MEASUREMENT_VALUE = 2;

    public final int getNumber() {
      if (this == UNRECOGNIZED) {
        throw new java.lang.IllegalArgumentException(
            "Can't get the number of an unknown enum value.");
      }
      return value;
    }

    /**
     * @param value The numeric wire value of the corresponding enum entry.
     * @return The enum associated with the given numeric wire value.
     * @deprecated Use {@link #forNumber(int)} instead.
     */
    @java.lang.Deprecated
    public static MeasurementSelectionType valueOf(int value) {
      return forNumber(value);
    }

    /**
     * @param value The numeric wire value of the corresponding enum entry.
     * @return The enum associated with the given numeric wire value.
     */
    public static MeasurementSelectionType forNumber(int value) {
      switch (value) {
        case 0:
          return MEASUREMENT_SELECTION_TYPE_UNSPECIFIED;
        case 1:
          return LAST_MEASUREMENT;
        case 2:
          return BEST_MEASUREMENT;
        default:
          return null;
      }
    }

    public static com.google.protobuf.Internal.EnumLiteMap<MeasurementSelectionType>
        internalGetValueMap() {
      return internalValueMap;
    }

    private static final com.google.protobuf.Internal.EnumLiteMap<MeasurementSelectionType>
        internalValueMap =
            new com.google.protobuf.Internal.EnumLiteMap<MeasurementSelectionType>() {
              public MeasurementSelectionType findValueByNumber(int number) {
                return MeasurementSelectionType.forNumber(number);
              }
            };

    public final com.google.protobuf.Descriptors.EnumValueDescriptor getValueDescriptor() {
      if (this == UNRECOGNIZED) {
        throw new java.lang.IllegalStateException(
            "Can't get the descriptor of an unrecognized enum value.");
      }
      return getDescriptor().getValues().get(ordinal());
    }

    public final com.google.protobuf.Descriptors.EnumDescriptor getDescriptorForType() {
      return getDescriptor();
    }

    public static final com.google.protobuf.Descriptors.EnumDescriptor getDescriptor() {
      return com.google.cloud.aiplatform.v1beta1.StudySpec.getDescriptor().getEnumTypes().get(2);
    }

    private static final MeasurementSelectionType[] VALUES = values();

    public static MeasurementSelectionType valueOf(
        com.google.protobuf.Descriptors.EnumValueDescriptor desc) {
      if (desc.getType() != getDescriptor()) {
        throw new java.lang.IllegalArgumentException("EnumValueDescriptor is not for this type.");
      }
      if (desc.getIndex() == -1) {
        return UNRECOGNIZED;
      }
      return VALUES[desc.getIndex()];
    }

    private final int value;

    private MeasurementSelectionType(int value) {
      this.value = value;
    }

    // @@protoc_insertion_point(enum_scope:google.cloud.aiplatform.v1beta1.StudySpec.MeasurementSelectionType)
  }

  public interface MetricSpecOrBuilder
      extends
      // @@protoc_insertion_point(interface_extends:google.cloud.aiplatform.v1beta1.StudySpec.MetricSpec)
      com.google.protobuf.MessageOrBuilder {

    /**
     *
     *
     * <pre>
     * Required. The ID of the metric. Must not contain whitespaces and must be unique
     * amongst all MetricSpecs.
     * </pre>
     *
     * <code>string metric_id = 1 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return The metricId.
     */
    java.lang.String getMetricId();
    /**
     *
     *
     * <pre>
     * Required. The ID of the metric. Must not contain whitespaces and must be unique
     * amongst all MetricSpecs.
     * </pre>
     *
     * <code>string metric_id = 1 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return The bytes for metricId.
     */
    com.google.protobuf.ByteString getMetricIdBytes();

    /**
     *
     *
     * <pre>
     * Required. The optimization goal of the metric.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.StudySpec.MetricSpec.GoalType goal = 2 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     *
     * @return The enum numeric value on the wire for goal.
     */
    int getGoalValue();
    /**
     *
     *
     * <pre>
     * Required. The optimization goal of the metric.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.StudySpec.MetricSpec.GoalType goal = 2 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     *
     * @return The goal.
     */
    com.google.cloud.aiplatform.v1beta1.StudySpec.MetricSpec.GoalType getGoal();
  }
  /**
   *
   *
   * <pre>
   * Represents a metric to optimize.
   * </pre>
   *
   * Protobuf type {@code google.cloud.aiplatform.v1beta1.StudySpec.MetricSpec}
   */
  public static final class MetricSpec extends com.google.protobuf.GeneratedMessageV3
      implements
      // @@protoc_insertion_point(message_implements:google.cloud.aiplatform.v1beta1.StudySpec.MetricSpec)
      MetricSpecOrBuilder {
    private static final long serialVersionUID = 0L;
    // Use MetricSpec.newBuilder() to construct.
    private MetricSpec(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
      super(builder);
    }

    private MetricSpec() {
      metricId_ = "";
      goal_ = 0;
    }

    @java.lang.Override
    @SuppressWarnings({"unused"})
    protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
      return new MetricSpec();
    }

    @java.lang.Override
    public final com.google.protobuf.UnknownFieldSet getUnknownFields() {
      return this.unknownFields;
    }

    private MetricSpec(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      this();
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      com.google.protobuf.UnknownFieldSet.Builder unknownFields =
          com.google.protobuf.UnknownFieldSet.newBuilder();
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 10:
              {
                java.lang.String s = input.readStringRequireUtf8();

                metricId_ = s;
                break;
              }
            case 16:
              {
                int rawValue = input.readEnum();

                goal_ = rawValue;
                break;
              }
            default:
              {
                if (!parseUnknownField(input, unknownFields, extensionRegistry, tag)) {
                  done = true;
                }
                break;
              }
          }
        }
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.setUnfinishedMessage(this);
      } catch (java.io.IOException e) {
        throw new com.google.protobuf.InvalidProtocolBufferException(e).setUnfinishedMessage(this);
      } finally {
        this.unknownFields = unknownFields.build();
        makeExtensionsImmutable();
      }
    }

    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.aiplatform.v1beta1.StudyProto
          .internal_static_google_cloud_aiplatform_v1beta1_StudySpec_MetricSpec_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.aiplatform.v1beta1.StudyProto
          .internal_static_google_cloud_aiplatform_v1beta1_StudySpec_MetricSpec_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.aiplatform.v1beta1.StudySpec.MetricSpec.class,
              com.google.cloud.aiplatform.v1beta1.StudySpec.MetricSpec.Builder.class);
    }

    /**
     *
     *
     * <pre>
     * The available types of optimization goals.
     * </pre>
     *
     * Protobuf enum {@code google.cloud.aiplatform.v1beta1.StudySpec.MetricSpec.GoalType}
     */
    public enum GoalType implements com.google.protobuf.ProtocolMessageEnum {
      /**
       *
       *
       * <pre>
       * Goal Type will default to maximize.
       * </pre>
       *
       * <code>GOAL_TYPE_UNSPECIFIED = 0;</code>
       */
      GOAL_TYPE_UNSPECIFIED(0),
      /**
       *
       *
       * <pre>
       * Maximize the goal metric.
       * </pre>
       *
       * <code>MAXIMIZE = 1;</code>
       */
      MAXIMIZE(1),
      /**
       *
       *
       * <pre>
       * Minimize the goal metric.
       * </pre>
       *
       * <code>MINIMIZE = 2;</code>
       */
      MINIMIZE(2),
      UNRECOGNIZED(-1),
      ;

      /**
       *
       *
       * <pre>
       * Goal Type will default to maximize.
       * </pre>
       *
       * <code>GOAL_TYPE_UNSPECIFIED = 0;</code>
       */
      public static final int GOAL_TYPE_UNSPECIFIED_VALUE = 0;
      /**
       *
       *
       * <pre>
       * Maximize the goal metric.
       * </pre>
       *
       * <code>MAXIMIZE = 1;</code>
       */
      public static final int MAXIMIZE_VALUE = 1;
      /**
       *
       *
       * <pre>
       * Minimize the goal metric.
       * </pre>
       *
       * <code>MINIMIZE = 2;</code>
       */
      public static final int MINIMIZE_VALUE = 2;

      public final int getNumber() {
        if (this == UNRECOGNIZED) {
          throw new java.lang.IllegalArgumentException(
              "Can't get the number of an unknown enum value.");
        }
        return value;
      }

      /**
       * @param value The numeric wire value of the corresponding enum entry.
       * @return The enum associated with the given numeric wire value.
       * @deprecated Use {@link #forNumber(int)} instead.
       */
      @java.lang.Deprecated
      public static GoalType valueOf(int value) {
        return forNumber(value);
      }

      /**
       * @param value The numeric wire value of the corresponding enum entry.
       * @return The enum associated with the given numeric wire value.
       */
      public static GoalType forNumber(int value) {
        switch (value) {
          case 0:
            return GOAL_TYPE_UNSPECIFIED;
          case 1:
            return MAXIMIZE;
          case 2:
            return MINIMIZE;
          default:
            return null;
        }
      }

      public static com.google.protobuf.Internal.EnumLiteMap<GoalType> internalGetValueMap() {
        return internalValueMap;
      }

      private static final com.google.protobuf.Internal.EnumLiteMap<GoalType> internalValueMap =
          new com.google.protobuf.Internal.EnumLiteMap<GoalType>() {
            public GoalType findValueByNumber(int number) {
              return GoalType.forNumber(number);
            }
          };

      public final com.google.protobuf.Descriptors.EnumValueDescriptor getValueDescriptor() {
        if (this == UNRECOGNIZED) {
          throw new java.lang.IllegalStateException(
              "Can't get the descriptor of an unrecognized enum value.");
        }
        return getDescriptor().getValues().get(ordinal());
      }

      public final com.google.protobuf.Descriptors.EnumDescriptor getDescriptorForType() {
        return getDescriptor();
      }

      public static final com.google.protobuf.Descriptors.EnumDescriptor getDescriptor() {
        return com.google.cloud.aiplatform.v1beta1.StudySpec.MetricSpec.getDescriptor()
            .getEnumTypes()
            .get(0);
      }

      private static final GoalType[] VALUES = values();

      public static GoalType valueOf(com.google.protobuf.Descriptors.EnumValueDescriptor desc) {
        if (desc.getType() != getDescriptor()) {
          throw new java.lang.IllegalArgumentException("EnumValueDescriptor is not for this type.");
        }
        if (desc.getIndex() == -1) {
          return UNRECOGNIZED;
        }
        return VALUES[desc.getIndex()];
      }

      private final int value;

      private GoalType(int value) {
        this.value = value;
      }

      // @@protoc_insertion_point(enum_scope:google.cloud.aiplatform.v1beta1.StudySpec.MetricSpec.GoalType)
    }

    public static final int METRIC_ID_FIELD_NUMBER = 1;
    private volatile java.lang.Object metricId_;
    /**
     *
     *
     * <pre>
     * Required. The ID of the metric. Must not contain whitespaces and must be unique
     * amongst all MetricSpecs.
     * </pre>
     *
     * <code>string metric_id = 1 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return The metricId.
     */
    @java.lang.Override
    public java.lang.String getMetricId() {
      java.lang.Object ref = metricId_;
      if (ref instanceof java.lang.String) {
        return (java.lang.String) ref;
      } else {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        metricId_ = s;
        return s;
      }
    }
    /**
     *
     *
     * <pre>
     * Required. The ID of the metric. Must not contain whitespaces and must be unique
     * amongst all MetricSpecs.
     * </pre>
     *
     * <code>string metric_id = 1 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return The bytes for metricId.
     */
    @java.lang.Override
    public com.google.protobuf.ByteString getMetricIdBytes() {
      java.lang.Object ref = metricId_;
      if (ref instanceof java.lang.String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        metricId_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    public static final int GOAL_FIELD_NUMBER = 2;
    private int goal_;
    /**
     *
     *
     * <pre>
     * Required. The optimization goal of the metric.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.StudySpec.MetricSpec.GoalType goal = 2 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     *
     * @return The enum numeric value on the wire for goal.
     */
    @java.lang.Override
    public int getGoalValue() {
      return goal_;
    }
    /**
     *
     *
     * <pre>
     * Required. The optimization goal of the metric.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.StudySpec.MetricSpec.GoalType goal = 2 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     *
     * @return The goal.
     */
    @java.lang.Override
    public com.google.cloud.aiplatform.v1beta1.StudySpec.MetricSpec.GoalType getGoal() {
      @SuppressWarnings("deprecation")
      com.google.cloud.aiplatform.v1beta1.StudySpec.MetricSpec.GoalType result =
          com.google.cloud.aiplatform.v1beta1.StudySpec.MetricSpec.GoalType.valueOf(goal_);
      return result == null
          ? com.google.cloud.aiplatform.v1beta1.StudySpec.MetricSpec.GoalType.UNRECOGNIZED
          : result;
    }

    private byte memoizedIsInitialized = -1;

    @java.lang.Override
    public final boolean isInitialized() {
      byte isInitialized = memoizedIsInitialized;
      if (isInitialized == 1) return true;
      if (isInitialized == 0) return false;

      memoizedIsInitialized = 1;
      return true;
    }

    @java.lang.Override
    public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
      if (!getMetricIdBytes().isEmpty()) {
        com.google.protobuf.GeneratedMessageV3.writeString(output, 1, metricId_);
      }
      if (goal_
          != com.google.cloud.aiplatform.v1beta1.StudySpec.MetricSpec.GoalType.GOAL_TYPE_UNSPECIFIED
              .getNumber()) {
        output.writeEnum(2, goal_);
      }
      unknownFields.writeTo(output);
    }

    @java.lang.Override
    public int getSerializedSize() {
      int size = memoizedSize;
      if (size != -1) return size;

      size = 0;
      if (!getMetricIdBytes().isEmpty()) {
        size += com.google.protobuf.GeneratedMessageV3.computeStringSize(1, metricId_);
      }
      if (goal_
          != com.google.cloud.aiplatform.v1beta1.StudySpec.MetricSpec.GoalType.GOAL_TYPE_UNSPECIFIED
              .getNumber()) {
        size += com.google.protobuf.CodedOutputStream.computeEnumSize(2, goal_);
      }
      size += unknownFields.getSerializedSize();
      memoizedSize = size;
      return size;
    }

    @java.lang.Override
    public boolean equals(final java.lang.Object obj) {
      if (obj == this) {
        return true;
      }
      if (!(obj instanceof com.google.cloud.aiplatform.v1beta1.StudySpec.MetricSpec)) {
        return super.equals(obj);
      }
      com.google.cloud.aiplatform.v1beta1.StudySpec.MetricSpec other =
          (com.google.cloud.aiplatform.v1beta1.StudySpec.MetricSpec) obj;

      if (!getMetricId().equals(other.getMetricId())) return false;
      if (goal_ != other.goal_) return false;
      if (!unknownFields.equals(other.unknownFields)) return false;
      return true;
    }

    @java.lang.Override
    public int hashCode() {
      if (memoizedHashCode != 0) {
        return memoizedHashCode;
      }
      int hash = 41;
      hash = (19 * hash) + getDescriptor().hashCode();
      hash = (37 * hash) + METRIC_ID_FIELD_NUMBER;
      hash = (53 * hash) + getMetricId().hashCode();
      hash = (37 * hash) + GOAL_FIELD_NUMBER;
      hash = (53 * hash) + goal_;
      hash = (29 * hash) + unknownFields.hashCode();
      memoizedHashCode = hash;
      return hash;
    }

    public static com.google.cloud.aiplatform.v1beta1.StudySpec.MetricSpec parseFrom(
        java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.aiplatform.v1beta1.StudySpec.MetricSpec parseFrom(
        java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.aiplatform.v1beta1.StudySpec.MetricSpec parseFrom(
        com.google.protobuf.ByteString data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.aiplatform.v1beta1.StudySpec.MetricSpec parseFrom(
        com.google.protobuf.ByteString data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.aiplatform.v1beta1.StudySpec.MetricSpec parseFrom(byte[] data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.aiplatform.v1beta1.StudySpec.MetricSpec parseFrom(
        byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.aiplatform.v1beta1.StudySpec.MetricSpec parseFrom(
        java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.cloud.aiplatform.v1beta1.StudySpec.MetricSpec parseFrom(
        java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.cloud.aiplatform.v1beta1.StudySpec.MetricSpec parseDelimitedFrom(
        java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
    }

    public static com.google.cloud.aiplatform.v1beta1.StudySpec.MetricSpec parseDelimitedFrom(
        java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.cloud.aiplatform.v1beta1.StudySpec.MetricSpec parseFrom(
        com.google.protobuf.CodedInputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.cloud.aiplatform.v1beta1.StudySpec.MetricSpec parseFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    @java.lang.Override
    public Builder newBuilderForType() {
      return newBuilder();
    }

    public static Builder newBuilder() {
      return DEFAULT_INSTANCE.toBuilder();
    }

    public static Builder newBuilder(
        com.google.cloud.aiplatform.v1beta1.StudySpec.MetricSpec prototype) {
      return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }

    @java.lang.Override
    public Builder toBuilder() {
      return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
    }

    @java.lang.Override
    protected Builder newBuilderForType(
        com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      Builder builder = new Builder(parent);
      return builder;
    }
    /**
     *
     *
     * <pre>
     * Represents a metric to optimize.
     * </pre>
     *
     * Protobuf type {@code google.cloud.aiplatform.v1beta1.StudySpec.MetricSpec}
     */
    public static final class Builder
        extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
        implements
        // @@protoc_insertion_point(builder_implements:google.cloud.aiplatform.v1beta1.StudySpec.MetricSpec)
        com.google.cloud.aiplatform.v1beta1.StudySpec.MetricSpecOrBuilder {
      public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
        return com.google.cloud.aiplatform.v1beta1.StudyProto
            .internal_static_google_cloud_aiplatform_v1beta1_StudySpec_MetricSpec_descriptor;
      }

      @java.lang.Override
      protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return com.google.cloud.aiplatform.v1beta1.StudyProto
            .internal_static_google_cloud_aiplatform_v1beta1_StudySpec_MetricSpec_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                com.google.cloud.aiplatform.v1beta1.StudySpec.MetricSpec.class,
                com.google.cloud.aiplatform.v1beta1.StudySpec.MetricSpec.Builder.class);
      }

      // Construct using com.google.cloud.aiplatform.v1beta1.StudySpec.MetricSpec.newBuilder()
      private Builder() {
        maybeForceBuilderInitialization();
      }

      private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
        super(parent);
        maybeForceBuilderInitialization();
      }

      private void maybeForceBuilderInitialization() {
        if (com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders) {}
      }

      @java.lang.Override
      public Builder clear() {
        super.clear();
        metricId_ = "";

        goal_ = 0;

        return this;
      }

      @java.lang.Override
      public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
        return com.google.cloud.aiplatform.v1beta1.StudyProto
            .internal_static_google_cloud_aiplatform_v1beta1_StudySpec_MetricSpec_descriptor;
      }

      @java.lang.Override
      public com.google.cloud.aiplatform.v1beta1.StudySpec.MetricSpec getDefaultInstanceForType() {
        return com.google.cloud.aiplatform.v1beta1.StudySpec.MetricSpec.getDefaultInstance();
      }

      @java.lang.Override
      public com.google.cloud.aiplatform.v1beta1.StudySpec.MetricSpec build() {
        com.google.cloud.aiplatform.v1beta1.StudySpec.MetricSpec result = buildPartial();
        if (!result.isInitialized()) {
          throw newUninitializedMessageException(result);
        }
        return result;
      }

      @java.lang.Override
      public com.google.cloud.aiplatform.v1beta1.StudySpec.MetricSpec buildPartial() {
        com.google.cloud.aiplatform.v1beta1.StudySpec.MetricSpec result =
            new com.google.cloud.aiplatform.v1beta1.StudySpec.MetricSpec(this);
        result.metricId_ = metricId_;
        result.goal_ = goal_;
        onBuilt();
        return result;
      }

      @java.lang.Override
      public Builder clone() {
        return super.clone();
      }

      @java.lang.Override
      public Builder setField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.setField(field, value);
      }

      @java.lang.Override
      public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
        return super.clearField(field);
      }

      @java.lang.Override
      public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
        return super.clearOneof(oneof);
      }

      @java.lang.Override
      public Builder setRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          int index,
          java.lang.Object value) {
        return super.setRepeatedField(field, index, value);
      }

      @java.lang.Override
      public Builder addRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.addRepeatedField(field, value);
      }

      @java.lang.Override
      public Builder mergeFrom(com.google.protobuf.Message other) {
        if (other instanceof com.google.cloud.aiplatform.v1beta1.StudySpec.MetricSpec) {
          return mergeFrom((com.google.cloud.aiplatform.v1beta1.StudySpec.MetricSpec) other);
        } else {
          super.mergeFrom(other);
          return this;
        }
      }

      public Builder mergeFrom(com.google.cloud.aiplatform.v1beta1.StudySpec.MetricSpec other) {
        if (other == com.google.cloud.aiplatform.v1beta1.StudySpec.MetricSpec.getDefaultInstance())
          return this;
        if (!other.getMetricId().isEmpty()) {
          metricId_ = other.metricId_;
          onChanged();
        }
        if (other.goal_ != 0) {
          setGoalValue(other.getGoalValue());
        }
        this.mergeUnknownFields(other.unknownFields);
        onChanged();
        return this;
      }

      @java.lang.Override
      public final boolean isInitialized() {
        return true;
      }

      @java.lang.Override
      public Builder mergeFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        com.google.cloud.aiplatform.v1beta1.StudySpec.MetricSpec parsedMessage = null;
        try {
          parsedMessage = PARSER.parsePartialFrom(input, extensionRegistry);
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          parsedMessage =
              (com.google.cloud.aiplatform.v1beta1.StudySpec.MetricSpec) e.getUnfinishedMessage();
          throw e.unwrapIOException();
        } finally {
          if (parsedMessage != null) {
            mergeFrom(parsedMessage);
          }
        }
        return this;
      }

      private java.lang.Object metricId_ = "";
      /**
       *
       *
       * <pre>
       * Required. The ID of the metric. Must not contain whitespaces and must be unique
       * amongst all MetricSpecs.
       * </pre>
       *
       * <code>string metric_id = 1 [(.google.api.field_behavior) = REQUIRED];</code>
       *
       * @return The metricId.
       */
      public java.lang.String getMetricId() {
        java.lang.Object ref = metricId_;
        if (!(ref instanceof java.lang.String)) {
          com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
          java.lang.String s = bs.toStringUtf8();
          metricId_ = s;
          return s;
        } else {
          return (java.lang.String) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * Required. The ID of the metric. Must not contain whitespaces and must be unique
       * amongst all MetricSpecs.
       * </pre>
       *
       * <code>string metric_id = 1 [(.google.api.field_behavior) = REQUIRED];</code>
       *
       * @return The bytes for metricId.
       */
      public com.google.protobuf.ByteString getMetricIdBytes() {
        java.lang.Object ref = metricId_;
        if (ref instanceof String) {
          com.google.protobuf.ByteString b =
              com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
          metricId_ = b;
          return b;
        } else {
          return (com.google.protobuf.ByteString) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * Required. The ID of the metric. Must not contain whitespaces and must be unique
       * amongst all MetricSpecs.
       * </pre>
       *
       * <code>string metric_id = 1 [(.google.api.field_behavior) = REQUIRED];</code>
       *
       * @param value The metricId to set.
       * @return This builder for chaining.
       */
      public Builder setMetricId(java.lang.String value) {
        if (value == null) {
          throw new NullPointerException();
        }

        metricId_ = value;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Required. The ID of the metric. Must not contain whitespaces and must be unique
       * amongst all MetricSpecs.
       * </pre>
       *
       * <code>string metric_id = 1 [(.google.api.field_behavior) = REQUIRED];</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearMetricId() {

        metricId_ = getDefaultInstance().getMetricId();
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Required. The ID of the metric. Must not contain whitespaces and must be unique
       * amongst all MetricSpecs.
       * </pre>
       *
       * <code>string metric_id = 1 [(.google.api.field_behavior) = REQUIRED];</code>
       *
       * @param value The bytes for metricId to set.
       * @return This builder for chaining.
       */
      public Builder setMetricIdBytes(com.google.protobuf.ByteString value) {
        if (value == null) {
          throw new NullPointerException();
        }
        checkByteStringIsUtf8(value);

        metricId_ = value;
        onChanged();
        return this;
      }

      private int goal_ = 0;
      /**
       *
       *
       * <pre>
       * Required. The optimization goal of the metric.
       * </pre>
       *
       * <code>
       * .google.cloud.aiplatform.v1beta1.StudySpec.MetricSpec.GoalType goal = 2 [(.google.api.field_behavior) = REQUIRED];
       * </code>
       *
       * @return The enum numeric value on the wire for goal.
       */
      @java.lang.Override
      public int getGoalValue() {
        return goal_;
      }
      /**
       *
       *
       * <pre>
       * Required. The optimization goal of the metric.
       * </pre>
       *
       * <code>
       * .google.cloud.aiplatform.v1beta1.StudySpec.MetricSpec.GoalType goal = 2 [(.google.api.field_behavior) = REQUIRED];
       * </code>
       *
       * @param value The enum numeric value on the wire for goal to set.
       * @return This builder for chaining.
       */
      public Builder setGoalValue(int value) {

        goal_ = value;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Required. The optimization goal of the metric.
       * </pre>
       *
       * <code>
       * .google.cloud.aiplatform.v1beta1.StudySpec.MetricSpec.GoalType goal = 2 [(.google.api.field_behavior) = REQUIRED];
       * </code>
       *
       * @return The goal.
       */
      @java.lang.Override
      public com.google.cloud.aiplatform.v1beta1.StudySpec.MetricSpec.GoalType getGoal() {
        @SuppressWarnings("deprecation")
        com.google.cloud.aiplatform.v1beta1.StudySpec.MetricSpec.GoalType result =
            com.google.cloud.aiplatform.v1beta1.StudySpec.MetricSpec.GoalType.valueOf(goal_);
        return result == null
            ? com.google.cloud.aiplatform.v1beta1.StudySpec.MetricSpec.GoalType.UNRECOGNIZED
            : result;
      }
      /**
       *
       *
       * <pre>
       * Required. The optimization goal of the metric.
       * </pre>
       *
       * <code>
       * .google.cloud.aiplatform.v1beta1.StudySpec.MetricSpec.GoalType goal = 2 [(.google.api.field_behavior) = REQUIRED];
       * </code>
       *
       * @param value The goal to set.
       * @return This builder for chaining.
       */
      public Builder setGoal(
          com.google.cloud.aiplatform.v1beta1.StudySpec.MetricSpec.GoalType value) {
        if (value == null) {
          throw new NullPointerException();
        }

        goal_ = value.getNumber();
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Required. The optimization goal of the metric.
       * </pre>
       *
       * <code>
       * .google.cloud.aiplatform.v1beta1.StudySpec.MetricSpec.GoalType goal = 2 [(.google.api.field_behavior) = REQUIRED];
       * </code>
       *
       * @return This builder for chaining.
       */
      public Builder clearGoal() {

        goal_ = 0;
        onChanged();
        return this;
      }

      @java.lang.Override
      public final Builder setUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.setUnknownFields(unknownFields);
      }

      @java.lang.Override
      public final Builder mergeUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.mergeUnknownFields(unknownFields);
      }

      // @@protoc_insertion_point(builder_scope:google.cloud.aiplatform.v1beta1.StudySpec.MetricSpec)
    }

    // @@protoc_insertion_point(class_scope:google.cloud.aiplatform.v1beta1.StudySpec.MetricSpec)
    private static final com.google.cloud.aiplatform.v1beta1.StudySpec.MetricSpec DEFAULT_INSTANCE;

    static {
      DEFAULT_INSTANCE = new com.google.cloud.aiplatform.v1beta1.StudySpec.MetricSpec();
    }

    public static com.google.cloud.aiplatform.v1beta1.StudySpec.MetricSpec getDefaultInstance() {
      return DEFAULT_INSTANCE;
    }

    private static final com.google.protobuf.Parser<MetricSpec> PARSER =
        new com.google.protobuf.AbstractParser<MetricSpec>() {
          @java.lang.Override
          public MetricSpec parsePartialFrom(
              com.google.protobuf.CodedInputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
            return new MetricSpec(input, extensionRegistry);
          }
        };

    public static com.google.protobuf.Parser<MetricSpec> parser() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.protobuf.Parser<MetricSpec> getParserForType() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.cloud.aiplatform.v1beta1.StudySpec.MetricSpec getDefaultInstanceForType() {
      return DEFAULT_INSTANCE;
    }
  }

  public interface ParameterSpecOrBuilder
      extends
      // @@protoc_insertion_point(interface_extends:google.cloud.aiplatform.v1beta1.StudySpec.ParameterSpec)
      com.google.protobuf.MessageOrBuilder {

    /**
     *
     *
     * <pre>
     * The value spec for a 'DOUBLE' parameter.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.StudySpec.ParameterSpec.DoubleValueSpec double_value_spec = 2;
     * </code>
     *
     * @return Whether the doubleValueSpec field is set.
     */
    boolean hasDoubleValueSpec();
    /**
     *
     *
     * <pre>
     * The value spec for a 'DOUBLE' parameter.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.StudySpec.ParameterSpec.DoubleValueSpec double_value_spec = 2;
     * </code>
     *
     * @return The doubleValueSpec.
     */
    com.google.cloud.aiplatform.v1beta1.StudySpec.ParameterSpec.DoubleValueSpec
        getDoubleValueSpec();
    /**
     *
     *
     * <pre>
     * The value spec for a 'DOUBLE' parameter.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.StudySpec.ParameterSpec.DoubleValueSpec double_value_spec = 2;
     * </code>
     */
    com.google.cloud.aiplatform.v1beta1.StudySpec.ParameterSpec.DoubleValueSpecOrBuilder
        getDoubleValueSpecOrBuilder();

    /**
     *
     *
     * <pre>
     * The value spec for an 'INTEGER' parameter.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.StudySpec.ParameterSpec.IntegerValueSpec integer_value_spec = 3;
     * </code>
     *
     * @return Whether the integerValueSpec field is set.
     */
    boolean hasIntegerValueSpec();
    /**
     *
     *
     * <pre>
     * The value spec for an 'INTEGER' parameter.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.StudySpec.ParameterSpec.IntegerValueSpec integer_value_spec = 3;
     * </code>
     *
     * @return The integerValueSpec.
     */
    com.google.cloud.aiplatform.v1beta1.StudySpec.ParameterSpec.IntegerValueSpec
        getIntegerValueSpec();
    /**
     *
     *
     * <pre>
     * The value spec for an 'INTEGER' parameter.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.StudySpec.ParameterSpec.IntegerValueSpec integer_value_spec = 3;
     * </code>
     */
    com.google.cloud.aiplatform.v1beta1.StudySpec.ParameterSpec.IntegerValueSpecOrBuilder
        getIntegerValueSpecOrBuilder();

    /**
     *
     *
     * <pre>
     * The value spec for a 'CATEGORICAL' parameter.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.StudySpec.ParameterSpec.CategoricalValueSpec categorical_value_spec = 4;
     * </code>
     *
     * @return Whether the categoricalValueSpec field is set.
     */
    boolean hasCategoricalValueSpec();
    /**
     *
     *
     * <pre>
     * The value spec for a 'CATEGORICAL' parameter.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.StudySpec.ParameterSpec.CategoricalValueSpec categorical_value_spec = 4;
     * </code>
     *
     * @return The categoricalValueSpec.
     */
    com.google.cloud.aiplatform.v1beta1.StudySpec.ParameterSpec.CategoricalValueSpec
        getCategoricalValueSpec();
    /**
     *
     *
     * <pre>
     * The value spec for a 'CATEGORICAL' parameter.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.StudySpec.ParameterSpec.CategoricalValueSpec categorical_value_spec = 4;
     * </code>
     */
    com.google.cloud.aiplatform.v1beta1.StudySpec.ParameterSpec.CategoricalValueSpecOrBuilder
        getCategoricalValueSpecOrBuilder();

    /**
     *
     *
     * <pre>
     * The value spec for a 'DISCRETE' parameter.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.StudySpec.ParameterSpec.DiscreteValueSpec discrete_value_spec = 5;
     * </code>
     *
     * @return Whether the discreteValueSpec field is set.
     */
    boolean hasDiscreteValueSpec();
    /**
     *
     *
     * <pre>
     * The value spec for a 'DISCRETE' parameter.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.StudySpec.ParameterSpec.DiscreteValueSpec discrete_value_spec = 5;
     * </code>
     *
     * @return The discreteValueSpec.
     */
    com.google.cloud.aiplatform.v1beta1.StudySpec.ParameterSpec.DiscreteValueSpec
        getDiscreteValueSpec();
    /**
     *
     *
     * <pre>
     * The value spec for a 'DISCRETE' parameter.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.StudySpec.ParameterSpec.DiscreteValueSpec discrete_value_spec = 5;
     * </code>
     */
    com.google.cloud.aiplatform.v1beta1.StudySpec.ParameterSpec.DiscreteValueSpecOrBuilder
        getDiscreteValueSpecOrBuilder();

    /**
     *
     *
     * <pre>
     * Required. The ID of the parameter. Must not contain whitespaces and must be unique
     * amongst all ParameterSpecs.
     * </pre>
     *
     * <code>string parameter_id = 1 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return The parameterId.
     */
    java.lang.String getParameterId();
    /**
     *
     *
     * <pre>
     * Required. The ID of the parameter. Must not contain whitespaces and must be unique
     * amongst all ParameterSpecs.
     * </pre>
     *
     * <code>string parameter_id = 1 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return The bytes for parameterId.
     */
    com.google.protobuf.ByteString getParameterIdBytes();

    /**
     *
     *
     * <pre>
     * How the parameter should be scaled.
     * Leave unset for `CATEGORICAL` parameters.
     * </pre>
     *
     * <code>.google.cloud.aiplatform.v1beta1.StudySpec.ParameterSpec.ScaleType scale_type = 6;
     * </code>
     *
     * @return The enum numeric value on the wire for scaleType.
     */
    int getScaleTypeValue();
    /**
     *
     *
     * <pre>
     * How the parameter should be scaled.
     * Leave unset for `CATEGORICAL` parameters.
     * </pre>
     *
     * <code>.google.cloud.aiplatform.v1beta1.StudySpec.ParameterSpec.ScaleType scale_type = 6;
     * </code>
     *
     * @return The scaleType.
     */
    com.google.cloud.aiplatform.v1beta1.StudySpec.ParameterSpec.ScaleType getScaleType();

    /**
     *
     *
     * <pre>
     * A conditional parameter node is active if the parameter's value matches
     * the conditional node's parent_value_condition.
     * If two items in conditional_parameter_specs have the same name, they
     * must have disjoint parent_value_condition.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.aiplatform.v1beta1.StudySpec.ParameterSpec.ConditionalParameterSpec conditional_parameter_specs = 10;
     * </code>
     */
    java.util.List<
            com.google.cloud.aiplatform.v1beta1.StudySpec.ParameterSpec.ConditionalParameterSpec>
        getConditionalParameterSpecsList();
    /**
     *
     *
     * <pre>
     * A conditional parameter node is active if the parameter's value matches
     * the conditional node's parent_value_condition.
     * If two items in conditional_parameter_specs have the same name, they
     * must have disjoint parent_value_condition.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.aiplatform.v1beta1.StudySpec.ParameterSpec.ConditionalParameterSpec conditional_parameter_specs = 10;
     * </code>
     */
    com.google.cloud.aiplatform.v1beta1.StudySpec.ParameterSpec.ConditionalParameterSpec
        getConditionalParameterSpecs(int index);
    /**
     *
     *
     * <pre>
     * A conditional parameter node is active if the parameter's value matches
     * the conditional node's parent_value_condition.
     * If two items in conditional_parameter_specs have the same name, they
     * must have disjoint parent_value_condition.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.aiplatform.v1beta1.StudySpec.ParameterSpec.ConditionalParameterSpec conditional_parameter_specs = 10;
     * </code>
     */
    int getConditionalParameterSpecsCount();
    /**
     *
     *
     * <pre>
     * A conditional parameter node is active if the parameter's value matches
     * the conditional node's parent_value_condition.
     * If two items in conditional_parameter_specs have the same name, they
     * must have disjoint parent_value_condition.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.aiplatform.v1beta1.StudySpec.ParameterSpec.ConditionalParameterSpec conditional_parameter_specs = 10;
     * </code>
     */
    java.util.List<
            ? extends
                com.google.cloud.aiplatform.v1beta1.StudySpec.ParameterSpec
                    .ConditionalParameterSpecOrBuilder>
        getConditionalParameterSpecsOrBuilderList();
    /**
     *
     *
     * <pre>
     * A conditional parameter node is active if the parameter's value matches
     * the conditional node's parent_value_condition.
     * If two items in conditional_parameter_specs have the same name, they
     * must have disjoint parent_value_condition.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.aiplatform.v1beta1.StudySpec.ParameterSpec.ConditionalParameterSpec conditional_parameter_specs = 10;
     * </code>
     */
    com.google.cloud.aiplatform.v1beta1.StudySpec.ParameterSpec.ConditionalParameterSpecOrBuilder
        getConditionalParameterSpecsOrBuilder(int index);

    public com.google.cloud.aiplatform.v1beta1.StudySpec.ParameterSpec.ParameterValueSpecCase
        getParameterValueSpecCase();
  }
  /**
   *
   *
   * <pre>
   * Represents a single parameter to optimize.
   * </pre>
   *
   * Protobuf type {@code google.cloud.aiplatform.v1beta1.StudySpec.ParameterSpec}
   */
  public static final class ParameterSpec extends com.google.protobuf.GeneratedMessageV3
      implements
      // @@protoc_insertion_point(message_implements:google.cloud.aiplatform.v1beta1.StudySpec.ParameterSpec)
      ParameterSpecOrBuilder {
    private static final long serialVersionUID = 0L;
    // Use ParameterSpec.newBuilder() to construct.
    private ParameterSpec(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
      super(builder);
    }

    private ParameterSpec() {
      parameterId_ = "";
      scaleType_ = 0;
      conditionalParameterSpecs_ = java.util.Collections.emptyList();
    }

    @java.lang.Override
    @SuppressWarnings({"unused"})
    protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
      return new ParameterSpec();
    }

    @java.lang.Override
    public final com.google.protobuf.UnknownFieldSet getUnknownFields() {
      return this.unknownFields;
    }

    private ParameterSpec(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      this();
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      int mutable_bitField0_ = 0;
      com.google.protobuf.UnknownFieldSet.Builder unknownFields =
          com.google.protobuf.UnknownFieldSet.newBuilder();
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 10:
              {
                java.lang.String s = input.readStringRequireUtf8();

                parameterId_ = s;
                break;
              }
            case 18:
              {
                com.google.cloud.aiplatform.v1beta1.StudySpec.ParameterSpec.DoubleValueSpec.Builder
                    subBuilder = null;
                if (parameterValueSpecCase_ == 2) {
                  subBuilder =
                      ((com.google.cloud.aiplatform.v1beta1.StudySpec.ParameterSpec.DoubleValueSpec)
                              parameterValueSpec_)
                          .toBuilder();
                }
                parameterValueSpec_ =
                    input.readMessage(
                        com.google.cloud.aiplatform.v1beta1.StudySpec.ParameterSpec.DoubleValueSpec
                            .parser(),
                        extensionRegistry);
                if (subBuilder != null) {
                  subBuilder.mergeFrom(
                      (com.google.cloud.aiplatform.v1beta1.StudySpec.ParameterSpec.DoubleValueSpec)
                          parameterValueSpec_);
                  parameterValueSpec_ = subBuilder.buildPartial();
                }
                parameterValueSpecCase_ = 2;
                break;
              }
            case 26:
              {
                com.google.cloud.aiplatform.v1beta1.StudySpec.ParameterSpec.IntegerValueSpec.Builder
                    subBuilder = null;
                if (parameterValueSpecCase_ == 3) {
                  subBuilder =
                      ((com.google.cloud.aiplatform.v1beta1.StudySpec.ParameterSpec
                                  .IntegerValueSpec)
                              parameterValueSpec_)
                          .toBuilder();
                }
                parameterValueSpec_ =
                    input.readMessage(
                        com.google.cloud.aiplatform.v1beta1.StudySpec.ParameterSpec.IntegerValueSpec
                            .parser(),
                        extensionRegistry);
                if (subBuilder != null) {
                  subBuilder.mergeFrom(
                      (com.google.cloud.aiplatform.v1beta1.StudySpec.ParameterSpec.IntegerValueSpec)
                          parameterValueSpec_);
                  parameterValueSpec_ = subBuilder.buildPartial();
                }
                parameterValueSpecCase_ = 3;
                break;
              }
            case 34:
              {
                com.google.cloud.aiplatform.v1beta1.StudySpec.ParameterSpec.CategoricalValueSpec
                        .Builder
                    subBuilder = null;
                if (parameterValueSpecCase_ == 4) {
                  subBuilder =
                      ((com.google.cloud.aiplatform.v1beta1.StudySpec.ParameterSpec
                                  .CategoricalValueSpec)
                              parameterValueSpec_)
                          .toBuilder();
                }
                parameterValueSpec_ =
                    input.readMessage(
                        com.google.cloud.aiplatform.v1beta1.StudySpec.ParameterSpec
                            .CategoricalValueSpec.parser(),
                        extensionRegistry);
                if (subBuilder != null) {
                  subBuilder.mergeFrom(
                      (com.google.cloud.aiplatform.v1beta1.StudySpec.ParameterSpec
                              .CategoricalValueSpec)
                          parameterValueSpec_);
                  parameterValueSpec_ = subBuilder.buildPartial();
                }
                parameterValueSpecCase_ = 4;
                break;
              }
            case 42:
              {
                com.google.cloud.aiplatform.v1beta1.StudySpec.ParameterSpec.DiscreteValueSpec
                        .Builder
                    subBuilder = null;
                if (parameterValueSpecCase_ == 5) {
                  subBuilder =
                      ((com.google.cloud.aiplatform.v1beta1.StudySpec.ParameterSpec
                                  .DiscreteValueSpec)
                              parameterValueSpec_)
                          .toBuilder();
                }
                parameterValueSpec_ =
                    input.readMessage(
                        com.google.cloud.aiplatform.v1beta1.StudySpec.ParameterSpec
                            .DiscreteValueSpec.parser(),
                        extensionRegistry);
                if (subBuilder != null) {
                  subBuilder.mergeFrom(
                      (com.google.cloud.aiplatform.v1beta1.StudySpec.ParameterSpec
                              .DiscreteValueSpec)
                          parameterValueSpec_);
                  parameterValueSpec_ = subBuilder.buildPartial();
                }
                parameterValueSpecCase_ = 5;
                break;
              }
            case 48:
              {
                int rawValue = input.readEnum();

                scaleType_ = rawValue;
                break;
              }
            case 82:
              {
                if (!((mutable_bitField0_ & 0x00000001) != 0)) {
                  conditionalParameterSpecs_ =
                      new java.util.ArrayList<
                          com.google.cloud.aiplatform.v1beta1.StudySpec.ParameterSpec
                              .ConditionalParameterSpec>();
                  mutable_bitField0_ |= 0x00000001;
                }
                conditionalParameterSpecs_.add(
                    input.readMessage(
                        com.google.cloud.aiplatform.v1beta1.StudySpec.ParameterSpec
                            .ConditionalParameterSpec.parser(),
                        extensionRegistry));
                break;
              }
            default:
              {
                if (!parseUnknownField(input, unknownFields, extensionRegistry, tag)) {
                  done = true;
                }
                break;
              }
          }
        }
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.setUnfinishedMessage(this);
      } catch (java.io.IOException e) {
        throw new com.google.protobuf.InvalidProtocolBufferException(e).setUnfinishedMessage(this);
      } finally {
        if (((mutable_bitField0_ & 0x00000001) != 0)) {
          conditionalParameterSpecs_ =
              java.util.Collections.unmodifiableList(conditionalParameterSpecs_);
        }
        this.unknownFields = unknownFields.build();
        makeExtensionsImmutable();
      }
    }

    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.aiplatform.v1beta1.StudyProto
          .internal_static_google_cloud_aiplatform_v1beta1_StudySpec_ParameterSpec_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.aiplatform.v1beta1.StudyProto
          .internal_static_google_cloud_aiplatform_v1beta1_StudySpec_ParameterSpec_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.aiplatform.v1beta1.StudySpec.ParameterSpec.class,
              com.google.cloud.aiplatform.v1beta1.StudySpec.ParameterSpec.Builder.class);
    }

    /**
     *
     *
     * <pre>
     * The type of scaling that should be applied to this parameter.
     * </pre>
     *
     * Protobuf enum {@code google.cloud.aiplatform.v1beta1.StudySpec.ParameterSpec.ScaleType}
     */
    public enum ScaleType implements com.google.protobuf.ProtocolMessageEnum {
      /**
       *
       *
       * <pre>
       * By default, no scaling is applied.
       * </pre>
       *
       * <code>SCALE_TYPE_UNSPECIFIED = 0;</code>
       */
      SCALE_TYPE_UNSPECIFIED(0),
      /**
       *
       *
       * <pre>
       * Scales the feasible space to (0, 1) linearly.
       * </pre>
       *
       * <code>UNIT_LINEAR_SCALE = 1;</code>
       */
      UNIT_LINEAR_SCALE(1),
      /**
       *
       *
       * <pre>
       * Scales the feasible space logarithmically to (0, 1). The entire
       * feasible space must be strictly positive.
       * </pre>
       *
       * <code>UNIT_LOG_SCALE = 2;</code>
       */
      UNIT_LOG_SCALE(2),
      /**
       *
       *
       * <pre>
       * Scales the feasible space "reverse" logarithmically to (0, 1). The
       * result is that values close to the top of the feasible space are spread
       * out more than points near the bottom. The entire feasible space must be
       * strictly positive.
       * </pre>
       *
       * <code>UNIT_REVERSE_LOG_SCALE = 3;</code>
       */
      UNIT_REVERSE_LOG_SCALE(3),
      UNRECOGNIZED(-1),
      ;

      /**
       *
       *
       * <pre>
       * By default, no scaling is applied.
       * </pre>
       *
       * <code>SCALE_TYPE_UNSPECIFIED = 0;</code>
       */
      public static final int SCALE_TYPE_UNSPECIFIED_VALUE = 0;
      /**
       *
       *
       * <pre>
       * Scales the feasible space to (0, 1) linearly.
       * </pre>
       *
       * <code>UNIT_LINEAR_SCALE = 1;</code>
       */
      public static final int UNIT_LINEAR_SCALE_VALUE = 1;
      /**
       *
       *
       * <pre>
       * Scales the feasible space logarithmically to (0, 1). The entire
       * feasible space must be strictly positive.
       * </pre>
       *
       * <code>UNIT_LOG_SCALE = 2;</code>
       */
      public static final int UNIT_LOG_SCALE_VALUE = 2;
      /**
       *
       *
       * <pre>
       * Scales the feasible space "reverse" logarithmically to (0, 1). The
       * result is that values close to the top of the feasible space are spread
       * out more than points near the bottom. The entire feasible space must be
       * strictly positive.
       * </pre>
       *
       * <code>UNIT_REVERSE_LOG_SCALE = 3;</code>
       */
      public static final int UNIT_REVERSE_LOG_SCALE_VALUE = 3;

      public final int getNumber() {
        if (this == UNRECOGNIZED) {
          throw new java.lang.IllegalArgumentException(
              "Can't get the number of an unknown enum value.");
        }
        return value;
      }

      /**
       * @param value The numeric wire value of the corresponding enum entry.
       * @return The enum associated with the given numeric wire value.
       * @deprecated Use {@link #forNumber(int)} instead.
       */
      @java.lang.Deprecated
      public static ScaleType valueOf(int value) {
        return forNumber(value);
      }

      /**
       * @param value The numeric wire value of the corresponding enum entry.
       * @return The enum associated with the given numeric wire value.
       */
      public static ScaleType forNumber(int value) {
        switch (value) {
          case 0:
            return SCALE_TYPE_UNSPECIFIED;
          case 1:
            return UNIT_LINEAR_SCALE;
          case 2:
            return UNIT_LOG_SCALE;
          case 3:
            return UNIT_REVERSE_LOG_SCALE;
          default:
            return null;
        }
      }

      public static com.google.protobuf.Internal.EnumLiteMap<ScaleType> internalGetValueMap() {
        return internalValueMap;
      }

      private static final com.google.protobuf.Internal.EnumLiteMap<ScaleType> internalValueMap =
          new com.google.protobuf.Internal.EnumLiteMap<ScaleType>() {
            public ScaleType findValueByNumber(int number) {
              return ScaleType.forNumber(number);
            }
          };

      public final com.google.protobuf.Descriptors.EnumValueDescriptor getValueDescriptor() {
        if (this == UNRECOGNIZED) {
          throw new java.lang.IllegalStateException(
              "Can't get the descriptor of an unrecognized enum value.");
        }
        return getDescriptor().getValues().get(ordinal());
      }

      public final com.google.protobuf.Descriptors.EnumDescriptor getDescriptorForType() {
        return getDescriptor();
      }

      public static final com.google.protobuf.Descriptors.EnumDescriptor getDescriptor() {
        return com.google.cloud.aiplatform.v1beta1.StudySpec.ParameterSpec.getDescriptor()
            .getEnumTypes()
            .get(0);
      }

      private static final ScaleType[] VALUES = values();

      public static ScaleType valueOf(com.google.protobuf.Descriptors.EnumValueDescriptor desc) {
        if (desc.getType() != getDescriptor()) {
          throw new java.lang.IllegalArgumentException("EnumValueDescriptor is not for this type.");
        }
        if (desc.getIndex() == -1) {
          return UNRECOGNIZED;
        }
        return VALUES[desc.getIndex()];
      }

      private final int value;

      private ScaleType(int value) {
        this.value = value;
      }

      // @@protoc_insertion_point(enum_scope:google.cloud.aiplatform.v1beta1.StudySpec.ParameterSpec.ScaleType)
    }

    public interface DoubleValueSpecOrBuilder
        extends
        // @@protoc_insertion_point(interface_extends:google.cloud.aiplatform.v1beta1.StudySpec.ParameterSpec.DoubleValueSpec)
        com.google.protobuf.MessageOrBuilder {

      /**
       *
       *
       * <pre>
       * Required. Inclusive minimum value of the parameter.
       * </pre>
       *
       * <code>double min_value = 1 [(.google.api.field_behavior) = REQUIRED];</code>
       *
       * @return The minValue.
       */
      double getMinValue();

      /**
       *
       *
       * <pre>
       * Required. Inclusive maximum value of the parameter.
       * </pre>
       *
       * <code>double max_value = 2 [(.google.api.field_behavior) = REQUIRED];</code>
       *
       * @return The maxValue.
       */
      double getMaxValue();

      /**
       *
       *
       * <pre>
       * A default value for a `DOUBLE` parameter that is assumed to be a
       * relatively good starting point.  Unset value signals that there is no
       * offered starting point.
       * Currently only supported by the Vizier service. Not supported by
       * HyperparamterTuningJob or TrainingPipeline.
       * </pre>
       *
       * <code>double default_value = 4;</code>
       *
       * @return Whether the defaultValue field is set.
       */
      boolean hasDefaultValue();
      /**
       *
       *
       * <pre>
       * A default value for a `DOUBLE` parameter that is assumed to be a
       * relatively good starting point.  Unset value signals that there is no
       * offered starting point.
       * Currently only supported by the Vizier service. Not supported by
       * HyperparamterTuningJob or TrainingPipeline.
       * </pre>
       *
       * <code>double default_value = 4;</code>
       *
       * @return The defaultValue.
       */
      double getDefaultValue();
    }
    /**
     *
     *
     * <pre>
     * Value specification for a parameter in `DOUBLE` type.
     * </pre>
     *
     * Protobuf type {@code google.cloud.aiplatform.v1beta1.StudySpec.ParameterSpec.DoubleValueSpec}
     */
    public static final class DoubleValueSpec extends com.google.protobuf.GeneratedMessageV3
        implements
        // @@protoc_insertion_point(message_implements:google.cloud.aiplatform.v1beta1.StudySpec.ParameterSpec.DoubleValueSpec)
        DoubleValueSpecOrBuilder {
      private static final long serialVersionUID = 0L;
      // Use DoubleValueSpec.newBuilder() to construct.
      private DoubleValueSpec(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
        super(builder);
      }

      private DoubleValueSpec() {}

      @java.lang.Override
      @SuppressWarnings({"unused"})
      protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
        return new DoubleValueSpec();
      }

      @java.lang.Override
      public final com.google.protobuf.UnknownFieldSet getUnknownFields() {
        return this.unknownFields;
      }

      private DoubleValueSpec(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws com.google.protobuf.InvalidProtocolBufferException {
        this();
        if (extensionRegistry == null) {
          throw new java.lang.NullPointerException();
        }
        int mutable_bitField0_ = 0;
        com.google.protobuf.UnknownFieldSet.Builder unknownFields =
            com.google.protobuf.UnknownFieldSet.newBuilder();
        try {
          boolean done = false;
          while (!done) {
            int tag = input.readTag();
            switch (tag) {
              case 0:
                done = true;
                break;
              case 9:
                {
                  minValue_ = input.readDouble();
                  break;
                }
              case 17:
                {
                  maxValue_ = input.readDouble();
                  break;
                }
              case 33:
                {
                  bitField0_ |= 0x00000001;
                  defaultValue_ = input.readDouble();
                  break;
                }
              default:
                {
                  if (!parseUnknownField(input, unknownFields, extensionRegistry, tag)) {
                    done = true;
                  }
                  break;
                }
            }
          }
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          throw e.setUnfinishedMessage(this);
        } catch (java.io.IOException e) {
          throw new com.google.protobuf.InvalidProtocolBufferException(e)
              .setUnfinishedMessage(this);
        } finally {
          this.unknownFields = unknownFields.build();
          makeExtensionsImmutable();
        }
      }

      public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
        return com.google.cloud.aiplatform.v1beta1.StudyProto
            .internal_static_google_cloud_aiplatform_v1beta1_StudySpec_ParameterSpec_DoubleValueSpec_descriptor;
      }

      @java.lang.Override
      protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return com.google.cloud.aiplatform.v1beta1.StudyProto
            .internal_static_google_cloud_aiplatform_v1beta1_StudySpec_ParameterSpec_DoubleValueSpec_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                com.google.cloud.aiplatform.v1beta1.StudySpec.ParameterSpec.DoubleValueSpec.class,
                com.google.cloud.aiplatform.v1beta1.StudySpec.ParameterSpec.DoubleValueSpec.Builder
                    .class);
      }

      private int bitField0_;
      public static final int MIN_VALUE_FIELD_NUMBER = 1;
      private double minValue_;
      /**
       *
       *
       * <pre>
       * Required. Inclusive minimum value of the parameter.
       * </pre>
       *
       * <code>double min_value = 1 [(.google.api.field_behavior) = REQUIRED];</code>
       *
       * @return The minValue.
       */
      @java.lang.Override
      public double getMinValue() {
        return minValue_;
      }

      public static final int MAX_VALUE_FIELD_NUMBER = 2;
      private double maxValue_;
      /**
       *
       *
       * <pre>
       * Required. Inclusive maximum value of the parameter.
       * </pre>
       *
       * <code>double max_value = 2 [(.google.api.field_behavior) = REQUIRED];</code>
       *
       * @return The maxValue.
       */
      @java.lang.Override
      public double getMaxValue() {
        return maxValue_;
      }

      public static final int DEFAULT_VALUE_FIELD_NUMBER = 4;
      private double defaultValue_;
      /**
       *
       *
       * <pre>
       * A default value for a `DOUBLE` parameter that is assumed to be a
       * relatively good starting point.  Unset value signals that there is no
       * offered starting point.
       * Currently only supported by the Vizier service. Not supported by
       * HyperparamterTuningJob or TrainingPipeline.
       * </pre>
       *
       * <code>double default_value = 4;</code>
       *
       * @return Whether the defaultValue field is set.
       */
      @java.lang.Override
      public boolean hasDefaultValue() {
        return ((bitField0_ & 0x00000001) != 0);
      }
      /**
       *
       *
       * <pre>
       * A default value for a `DOUBLE` parameter that is assumed to be a
       * relatively good starting point.  Unset value signals that there is no
       * offered starting point.
       * Currently only supported by the Vizier service. Not supported by
       * HyperparamterTuningJob or TrainingPipeline.
       * </pre>
       *
       * <code>double default_value = 4;</code>
       *
       * @return The defaultValue.
       */
      @java.lang.Override
      public double getDefaultValue() {
        return defaultValue_;
      }

      private byte memoizedIsInitialized = -1;

      @java.lang.Override
      public final boolean isInitialized() {
        byte isInitialized = memoizedIsInitialized;
        if (isInitialized == 1) return true;
        if (isInitialized == 0) return false;

        memoizedIsInitialized = 1;
        return true;
      }

      @java.lang.Override
      public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
        if (minValue_ != 0D) {
          output.writeDouble(1, minValue_);
        }
        if (maxValue_ != 0D) {
          output.writeDouble(2, maxValue_);
        }
        if (((bitField0_ & 0x00000001) != 0)) {
          output.writeDouble(4, defaultValue_);
        }
        unknownFields.writeTo(output);
      }

      @java.lang.Override
      public int getSerializedSize() {
        int size = memoizedSize;
        if (size != -1) return size;

        size = 0;
        if (minValue_ != 0D) {
          size += com.google.protobuf.CodedOutputStream.computeDoubleSize(1, minValue_);
        }
        if (maxValue_ != 0D) {
          size += com.google.protobuf.CodedOutputStream.computeDoubleSize(2, maxValue_);
        }
        if (((bitField0_ & 0x00000001) != 0)) {
          size += com.google.protobuf.CodedOutputStream.computeDoubleSize(4, defaultValue_);
        }
        size += unknownFields.getSerializedSize();
        memoizedSize = size;
        return size;
      }

      @java.lang.Override
      public boolean equals(final java.lang.Object obj) {
        if (obj == this) {
          return true;
        }
        if (!(obj
            instanceof
            com.google.cloud.aiplatform.v1beta1.StudySpec.ParameterSpec.DoubleValueSpec)) {
          return super.equals(obj);
        }
        com.google.cloud.aiplatform.v1beta1.StudySpec.ParameterSpec.DoubleValueSpec other =
            (com.google.cloud.aiplatform.v1beta1.StudySpec.ParameterSpec.DoubleValueSpec) obj;

        if (java.lang.Double.doubleToLongBits(getMinValue())
            != java.lang.Double.doubleToLongBits(other.getMinValue())) return false;
        if (java.lang.Double.doubleToLongBits(getMaxValue())
            != java.lang.Double.doubleToLongBits(other.getMaxValue())) return false;
        if (hasDefaultValue() != other.hasDefaultValue()) return false;
        if (hasDefaultValue()) {
          if (java.lang.Double.doubleToLongBits(getDefaultValue())
              != java.lang.Double.doubleToLongBits(other.getDefaultValue())) return false;
        }
        if (!unknownFields.equals(other.unknownFields)) return false;
        return true;
      }

      @java.lang.Override
      public int hashCode() {
        if (memoizedHashCode != 0) {
          return memoizedHashCode;
        }
        int hash = 41;
        hash = (19 * hash) + getDescriptor().hashCode();
        hash = (37 * hash) + MIN_VALUE_FIELD_NUMBER;
        hash =
            (53 * hash)
                + com.google.protobuf.Internal.hashLong(
                    java.lang.Double.doubleToLongBits(getMinValue()));
        hash = (37 * hash) + MAX_VALUE_FIELD_NUMBER;
        hash =
            (53 * hash)
                + com.google.protobuf.Internal.hashLong(
                    java.lang.Double.doubleToLongBits(getMaxValue()));
        if (hasDefaultValue()) {
          hash = (37 * hash) + DEFAULT_VALUE_FIELD_NUMBER;
          hash =
              (53 * hash)
                  + com.google.protobuf.Internal.hashLong(
                      java.lang.Double.doubleToLongBits(getDefaultValue()));
        }
        hash = (29 * hash) + unknownFields.hashCode();
        memoizedHashCode = hash;
        return hash;
      }

      public static com.google.cloud.aiplatform.v1beta1.StudySpec.ParameterSpec.DoubleValueSpec
          parseFrom(java.nio.ByteBuffer data)
              throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data);
      }

      public static com.google.cloud.aiplatform.v1beta1.StudySpec.ParameterSpec.DoubleValueSpec
          parseFrom(
              java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data, extensionRegistry);
      }

      public static com.google.cloud.aiplatform.v1beta1.StudySpec.ParameterSpec.DoubleValueSpec
          parseFrom(com.google.protobuf.ByteString data)
              throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data);
      }

      public static com.google.cloud.aiplatform.v1beta1.StudySpec.ParameterSpec.DoubleValueSpec
          parseFrom(
              com.google.protobuf.ByteString data,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data, extensionRegistry);
      }

      public static com.google.cloud.aiplatform.v1beta1.StudySpec.ParameterSpec.DoubleValueSpec
          parseFrom(byte[] data) throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data);
      }

      public static com.google.cloud.aiplatform.v1beta1.StudySpec.ParameterSpec.DoubleValueSpec
          parseFrom(byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data, extensionRegistry);
      }

      public static com.google.cloud.aiplatform.v1beta1.StudySpec.ParameterSpec.DoubleValueSpec
          parseFrom(java.io.InputStream input) throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
      }

      public static com.google.cloud.aiplatform.v1beta1.StudySpec.ParameterSpec.DoubleValueSpec
          parseFrom(
              java.io.InputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
            PARSER, input, extensionRegistry);
      }

      public static com.google.cloud.aiplatform.v1beta1.StudySpec.ParameterSpec.DoubleValueSpec
          parseDelimitedFrom(java.io.InputStream input) throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
      }

      public static com.google.cloud.aiplatform.v1beta1.StudySpec.ParameterSpec.DoubleValueSpec
          parseDelimitedFrom(
              java.io.InputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
            PARSER, input, extensionRegistry);
      }

      public static com.google.cloud.aiplatform.v1beta1.StudySpec.ParameterSpec.DoubleValueSpec
          parseFrom(com.google.protobuf.CodedInputStream input) throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
      }

      public static com.google.cloud.aiplatform.v1beta1.StudySpec.ParameterSpec.DoubleValueSpec
          parseFrom(
              com.google.protobuf.CodedInputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
            PARSER, input, extensionRegistry);
      }

      @java.lang.Override
      public Builder newBuilderForType() {
        return newBuilder();
      }

      public static Builder newBuilder() {
        return DEFAULT_INSTANCE.toBuilder();
      }

      public static Builder newBuilder(
          com.google.cloud.aiplatform.v1beta1.StudySpec.ParameterSpec.DoubleValueSpec prototype) {
        return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
      }

      @java.lang.Override
      public Builder toBuilder() {
        return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
      }

      @java.lang.Override
      protected Builder newBuilderForType(
          com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
        Builder builder = new Builder(parent);
        return builder;
      }
      /**
       *
       *
       * <pre>
       * Value specification for a parameter in `DOUBLE` type.
       * </pre>
       *
       * Protobuf type {@code
       * google.cloud.aiplatform.v1beta1.StudySpec.ParameterSpec.DoubleValueSpec}
       */
      public static final class Builder
          extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
          implements
          // @@protoc_insertion_point(builder_implements:google.cloud.aiplatform.v1beta1.StudySpec.ParameterSpec.DoubleValueSpec)
          com.google.cloud.aiplatform.v1beta1.StudySpec.ParameterSpec.DoubleValueSpecOrBuilder {
        public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
          return com.google.cloud.aiplatform.v1beta1.StudyProto
              .internal_static_google_cloud_aiplatform_v1beta1_StudySpec_ParameterSpec_DoubleValueSpec_descriptor;
        }

        @java.lang.Override
        protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
            internalGetFieldAccessorTable() {
          return com.google.cloud.aiplatform.v1beta1.StudyProto
              .internal_static_google_cloud_aiplatform_v1beta1_StudySpec_ParameterSpec_DoubleValueSpec_fieldAccessorTable
              .ensureFieldAccessorsInitialized(
                  com.google.cloud.aiplatform.v1beta1.StudySpec.ParameterSpec.DoubleValueSpec.class,
                  com.google.cloud.aiplatform.v1beta1.StudySpec.ParameterSpec.DoubleValueSpec
                      .Builder.class);
        }

        // Construct using
        // com.google.cloud.aiplatform.v1beta1.StudySpec.ParameterSpec.DoubleValueSpec.newBuilder()
        private Builder() {
          maybeForceBuilderInitialization();
        }

        private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
          super(parent);
          maybeForceBuilderInitialization();
        }

        private void maybeForceBuilderInitialization() {
          if (com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders) {}
        }

        @java.lang.Override
        public Builder clear() {
          super.clear();
          minValue_ = 0D;

          maxValue_ = 0D;

          defaultValue_ = 0D;
          bitField0_ = (bitField0_ & ~0x00000001);
          return this;
        }

        @java.lang.Override
        public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
          return com.google.cloud.aiplatform.v1beta1.StudyProto
              .internal_static_google_cloud_aiplatform_v1beta1_StudySpec_ParameterSpec_DoubleValueSpec_descriptor;
        }

        @java.lang.Override
        public com.google.cloud.aiplatform.v1beta1.StudySpec.ParameterSpec.DoubleValueSpec
            getDefaultInstanceForType() {
          return com.google.cloud.aiplatform.v1beta1.StudySpec.ParameterSpec.DoubleValueSpec
              .getDefaultInstance();
        }

        @java.lang.Override
        public com.google.cloud.aiplatform.v1beta1.StudySpec.ParameterSpec.DoubleValueSpec build() {
          com.google.cloud.aiplatform.v1beta1.StudySpec.ParameterSpec.DoubleValueSpec result =
              buildPartial();
          if (!result.isInitialized()) {
            throw newUninitializedMessageException(result);
          }
          return result;
        }

        @java.lang.Override
        public com.google.cloud.aiplatform.v1beta1.StudySpec.ParameterSpec.DoubleValueSpec
            buildPartial() {
          com.google.cloud.aiplatform.v1beta1.StudySpec.ParameterSpec.DoubleValueSpec result =
              new com.google.cloud.aiplatform.v1beta1.StudySpec.ParameterSpec.DoubleValueSpec(this);
          int from_bitField0_ = bitField0_;
          int to_bitField0_ = 0;
          result.minValue_ = minValue_;
          result.maxValue_ = maxValue_;
          if (((from_bitField0_ & 0x00000001) != 0)) {
            result.defaultValue_ = defaultValue_;
            to_bitField0_ |= 0x00000001;
          }
          result.bitField0_ = to_bitField0_;
          onBuilt();
          return result;
        }

        @java.lang.Override
        public Builder clone() {
          return super.clone();
        }

        @java.lang.Override
        public Builder setField(
            com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
          return super.setField(field, value);
        }

        @java.lang.Override
        public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
          return super.clearField(field);
        }

        @java.lang.Override
        public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
          return super.clearOneof(oneof);
        }

        @java.lang.Override
        public Builder setRepeatedField(
            com.google.protobuf.Descriptors.FieldDescriptor field,
            int index,
            java.lang.Object value) {
          return super.setRepeatedField(field, index, value);
        }

        @java.lang.Override
        public Builder addRepeatedField(
            com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
          return super.addRepeatedField(field, value);
        }

        @java.lang.Override
        public Builder mergeFrom(com.google.protobuf.Message other) {
          if (other
              instanceof
              com.google.cloud.aiplatform.v1beta1.StudySpec.ParameterSpec.DoubleValueSpec) {
            return mergeFrom(
                (com.google.cloud.aiplatform.v1beta1.StudySpec.ParameterSpec.DoubleValueSpec)
                    other);
          } else {
            super.mergeFrom(other);
            return this;
          }
        }

        public Builder mergeFrom(
            com.google.cloud.aiplatform.v1beta1.StudySpec.ParameterSpec.DoubleValueSpec other) {
          if (other
              == com.google.cloud.aiplatform.v1beta1.StudySpec.ParameterSpec.DoubleValueSpec
                  .getDefaultInstance()) return this;
          if (other.getMinValue() != 0D) {
            setMinValue(other.getMinValue());
          }
          if (other.getMaxValue() != 0D) {
            setMaxValue(other.getMaxValue());
          }
          if (other.hasDefaultValue()) {
            setDefaultValue(other.getDefaultValue());
          }
          this.mergeUnknownFields(other.unknownFields);
          onChanged();
          return this;
        }

        @java.lang.Override
        public final boolean isInitialized() {
          return true;
        }

        @java.lang.Override
        public Builder mergeFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws java.io.IOException {
          com.google.cloud.aiplatform.v1beta1.StudySpec.ParameterSpec.DoubleValueSpec
              parsedMessage = null;
          try {
            parsedMessage = PARSER.parsePartialFrom(input, extensionRegistry);
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            parsedMessage =
                (com.google.cloud.aiplatform.v1beta1.StudySpec.ParameterSpec.DoubleValueSpec)
                    e.getUnfinishedMessage();
            throw e.unwrapIOException();
          } finally {
            if (parsedMessage != null) {
              mergeFrom(parsedMessage);
            }
          }
          return this;
        }

        private int bitField0_;

        private double minValue_;
        /**
         *
         *
         * <pre>
         * Required. Inclusive minimum value of the parameter.
         * </pre>
         *
         * <code>double min_value = 1 [(.google.api.field_behavior) = REQUIRED];</code>
         *
         * @return The minValue.
         */
        @java.lang.Override
        public double getMinValue() {
          return minValue_;
        }
        /**
         *
         *
         * <pre>
         * Required. Inclusive minimum value of the parameter.
         * </pre>
         *
         * <code>double min_value = 1 [(.google.api.field_behavior) = REQUIRED];</code>
         *
         * @param value The minValue to set.
         * @return This builder for chaining.
         */
        public Builder setMinValue(double value) {

          minValue_ = value;
          onChanged();
          return this;
        }
        /**
         *
         *
         * <pre>
         * Required. Inclusive minimum value of the parameter.
         * </pre>
         *
         * <code>double min_value = 1 [(.google.api.field_behavior) = REQUIRED];</code>
         *
         * @return This builder for chaining.
         */
        public Builder clearMinValue() {

          minValue_ = 0D;
          onChanged();
          return this;
        }

        private double maxValue_;
        /**
         *
         *
         * <pre>
         * Required. Inclusive maximum value of the parameter.
         * </pre>
         *
         * <code>double max_value = 2 [(.google.api.field_behavior) = REQUIRED];</code>
         *
         * @return The maxValue.
         */
        @java.lang.Override
        public double getMaxValue() {
          return maxValue_;
        }
        /**
         *
         *
         * <pre>
         * Required. Inclusive maximum value of the parameter.
         * </pre>
         *
         * <code>double max_value = 2 [(.google.api.field_behavior) = REQUIRED];</code>
         *
         * @param value The maxValue to set.
         * @return This builder for chaining.
         */
        public Builder setMaxValue(double value) {

          maxValue_ = value;
          onChanged();
          return this;
        }
        /**
         *
         *
         * <pre>
         * Required. Inclusive maximum value of the parameter.
         * </pre>
         *
         * <code>double max_value = 2 [(.google.api.field_behavior) = REQUIRED];</code>
         *
         * @return This builder for chaining.
         */
        public Builder clearMaxValue() {

          maxValue_ = 0D;
          onChanged();
          return this;
        }

        private double defaultValue_;
        /**
         *
         *
         * <pre>
         * A default value for a `DOUBLE` parameter that is assumed to be a
         * relatively good starting point.  Unset value signals that there is no
         * offered starting point.
         * Currently only supported by the Vizier service. Not supported by
         * HyperparamterTuningJob or TrainingPipeline.
         * </pre>
         *
         * <code>double default_value = 4;</code>
         *
         * @return Whether the defaultValue field is set.
         */
        @java.lang.Override
        public boolean hasDefaultValue() {
          return ((bitField0_ & 0x00000001) != 0);
        }
        /**
         *
         *
         * <pre>
         * A default value for a `DOUBLE` parameter that is assumed to be a
         * relatively good starting point.  Unset value signals that there is no
         * offered starting point.
         * Currently only supported by the Vizier service. Not supported by
         * HyperparamterTuningJob or TrainingPipeline.
         * </pre>
         *
         * <code>double default_value = 4;</code>
         *
         * @return The defaultValue.
         */
        @java.lang.Override
        public double getDefaultValue() {
          return defaultValue_;
        }
        /**
         *
         *
         * <pre>
         * A default value for a `DOUBLE` parameter that is assumed to be a
         * relatively good starting point.  Unset value signals that there is no
         * offered starting point.
         * Currently only supported by the Vizier service. Not supported by
         * HyperparamterTuningJob or TrainingPipeline.
         * </pre>
         *
         * <code>double default_value = 4;</code>
         *
         * @param value The defaultValue to set.
         * @return This builder for chaining.
         */
        public Builder setDefaultValue(double value) {
          bitField0_ |= 0x00000001;
          defaultValue_ = value;
          onChanged();
          return this;
        }
        /**
         *
         *
         * <pre>
         * A default value for a `DOUBLE` parameter that is assumed to be a
         * relatively good starting point.  Unset value signals that there is no
         * offered starting point.
         * Currently only supported by the Vizier service. Not supported by
         * HyperparamterTuningJob or TrainingPipeline.
         * </pre>
         *
         * <code>double default_value = 4;</code>
         *
         * @return This builder for chaining.
         */
        public Builder clearDefaultValue() {
          bitField0_ = (bitField0_ & ~0x00000001);
          defaultValue_ = 0D;
          onChanged();
          return this;
        }

        @java.lang.Override
        public final Builder setUnknownFields(
            final com.google.protobuf.UnknownFieldSet unknownFields) {
          return super.setUnknownFields(unknownFields);
        }

        @java.lang.Override
        public final Builder mergeUnknownFields(
            final com.google.protobuf.UnknownFieldSet unknownFields) {
          return super.mergeUnknownFields(unknownFields);
        }

        // @@protoc_insertion_point(builder_scope:google.cloud.aiplatform.v1beta1.StudySpec.ParameterSpec.DoubleValueSpec)
      }

      // @@protoc_insertion_point(class_scope:google.cloud.aiplatform.v1beta1.StudySpec.ParameterSpec.DoubleValueSpec)
      private static final com.google.cloud.aiplatform.v1beta1.StudySpec.ParameterSpec
              .DoubleValueSpec
          DEFAULT_INSTANCE;

      static {
        DEFAULT_INSTANCE =
            new com.google.cloud.aiplatform.v1beta1.StudySpec.ParameterSpec.DoubleValueSpec();
      }

      public static com.google.cloud.aiplatform.v1beta1.StudySpec.ParameterSpec.DoubleValueSpec
          getDefaultInstance() {
        return DEFAULT_INSTANCE;
      }

      private static final com.google.protobuf.Parser<DoubleValueSpec> PARSER =
          new com.google.protobuf.AbstractParser<DoubleValueSpec>() {
            @java.lang.Override
            public DoubleValueSpec parsePartialFrom(
                com.google.protobuf.CodedInputStream input,
                com.google.protobuf.ExtensionRegistryLite extensionRegistry)
                throws com.google.protobuf.InvalidProtocolBufferException {
              return new DoubleValueSpec(input, extensionRegistry);
            }
          };

      public static com.google.protobuf.Parser<DoubleValueSpec> parser() {
        return PARSER;
      }

      @java.lang.Override
      public com.google.protobuf.Parser<DoubleValueSpec> getParserForType() {
        return PARSER;
      }

      @java.lang.Override
      public com.google.cloud.aiplatform.v1beta1.StudySpec.ParameterSpec.DoubleValueSpec
          getDefaultInstanceForType() {
        return DEFAULT_INSTANCE;
      }
    }

    public interface IntegerValueSpecOrBuilder
        extends
        // @@protoc_insertion_point(interface_extends:google.cloud.aiplatform.v1beta1.StudySpec.ParameterSpec.IntegerValueSpec)
        com.google.protobuf.MessageOrBuilder {

      /**
       *
       *
       * <pre>
       * Required. Inclusive minimum value of the parameter.
       * </pre>
       *
       * <code>int64 min_value = 1 [(.google.api.field_behavior) = REQUIRED];</code>
       *
       * @return The minValue.
       */
      long getMinValue();

      /**
       *
       *
       * <pre>
       * Required. Inclusive maximum value of the parameter.
       * </pre>
       *
       * <code>int64 max_value = 2 [(.google.api.field_behavior) = REQUIRED];</code>
       *
       * @return The maxValue.
       */
      long getMaxValue();

      /**
       *
       *
       * <pre>
       * A default value for an `INTEGER` parameter that is assumed to be a
       * relatively good starting point.  Unset value signals that there is no
       * offered starting point.
       * Currently only supported by the Vizier service. Not supported by
       * HyperparamterTuningJob or TrainingPipeline.
       * </pre>
       *
       * <code>int64 default_value = 4;</code>
       *
       * @return Whether the defaultValue field is set.
       */
      boolean hasDefaultValue();
      /**
       *
       *
       * <pre>
       * A default value for an `INTEGER` parameter that is assumed to be a
       * relatively good starting point.  Unset value signals that there is no
       * offered starting point.
       * Currently only supported by the Vizier service. Not supported by
       * HyperparamterTuningJob or TrainingPipeline.
       * </pre>
       *
       * <code>int64 default_value = 4;</code>
       *
       * @return The defaultValue.
       */
      long getDefaultValue();
    }
    /**
     *
     *
     * <pre>
     * Value specification for a parameter in `INTEGER` type.
     * </pre>
     *
     * Protobuf type {@code
     * google.cloud.aiplatform.v1beta1.StudySpec.ParameterSpec.IntegerValueSpec}
     */
    public static final class IntegerValueSpec extends com.google.protobuf.GeneratedMessageV3
        implements
        // @@protoc_insertion_point(message_implements:google.cloud.aiplatform.v1beta1.StudySpec.ParameterSpec.IntegerValueSpec)
        IntegerValueSpecOrBuilder {
      private static final long serialVersionUID = 0L;
      // Use IntegerValueSpec.newBuilder() to construct.
      private IntegerValueSpec(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
        super(builder);
      }

      private IntegerValueSpec() {}

      @java.lang.Override
      @SuppressWarnings({"unused"})
      protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
        return new IntegerValueSpec();
      }

      @java.lang.Override
      public final com.google.protobuf.UnknownFieldSet getUnknownFields() {
        return this.unknownFields;
      }

      private IntegerValueSpec(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws com.google.protobuf.InvalidProtocolBufferException {
        this();
        if (extensionRegistry == null) {
          throw new java.lang.NullPointerException();
        }
        int mutable_bitField0_ = 0;
        com.google.protobuf.UnknownFieldSet.Builder unknownFields =
            com.google.protobuf.UnknownFieldSet.newBuilder();
        try {
          boolean done = false;
          while (!done) {
            int tag = input.readTag();
            switch (tag) {
              case 0:
                done = true;
                break;
              case 8:
                {
                  minValue_ = input.readInt64();
                  break;
                }
              case 16:
                {
                  maxValue_ = input.readInt64();
                  break;
                }
              case 32:
                {
                  bitField0_ |= 0x00000001;
                  defaultValue_ = input.readInt64();
                  break;
                }
              default:
                {
                  if (!parseUnknownField(input, unknownFields, extensionRegistry, tag)) {
                    done = true;
                  }
                  break;
                }
            }
          }
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          throw e.setUnfinishedMessage(this);
        } catch (java.io.IOException e) {
          throw new com.google.protobuf.InvalidProtocolBufferException(e)
              .setUnfinishedMessage(this);
        } finally {
          this.unknownFields = unknownFields.build();
          makeExtensionsImmutable();
        }
      }

      public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
        return com.google.cloud.aiplatform.v1beta1.StudyProto
            .internal_static_google_cloud_aiplatform_v1beta1_StudySpec_ParameterSpec_IntegerValueSpec_descriptor;
      }

      @java.lang.Override
      protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return com.google.cloud.aiplatform.v1beta1.StudyProto
            .internal_static_google_cloud_aiplatform_v1beta1_StudySpec_ParameterSpec_IntegerValueSpec_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                com.google.cloud.aiplatform.v1beta1.StudySpec.ParameterSpec.IntegerValueSpec.class,
                com.google.cloud.aiplatform.v1beta1.StudySpec.ParameterSpec.IntegerValueSpec.Builder
                    .class);
      }

      private int bitField0_;
      public static final int MIN_VALUE_FIELD_NUMBER = 1;
      private long minValue_;
      /**
       *
       *
       * <pre>
       * Required. Inclusive minimum value of the parameter.
       * </pre>
       *
       * <code>int64 min_value = 1 [(.google.api.field_behavior) = REQUIRED];</code>
       *
       * @return The minValue.
       */
      @java.lang.Override
      public long getMinValue() {
        return minValue_;
      }

      public static final int MAX_VALUE_FIELD_NUMBER = 2;
      private long maxValue_;
      /**
       *
       *
       * <pre>
       * Required. Inclusive maximum value of the parameter.
       * </pre>
       *
       * <code>int64 max_value = 2 [(.google.api.field_behavior) = REQUIRED];</code>
       *
       * @return The maxValue.
       */
      @java.lang.Override
      public long getMaxValue() {
        return maxValue_;
      }

      public static final int DEFAULT_VALUE_FIELD_NUMBER = 4;
      private long defaultValue_;
      /**
       *
       *
       * <pre>
       * A default value for an `INTEGER` parameter that is assumed to be a
       * relatively good starting point.  Unset value signals that there is no
       * offered starting point.
       * Currently only supported by the Vizier service. Not supported by
       * HyperparamterTuningJob or TrainingPipeline.
       * </pre>
       *
       * <code>int64 default_value = 4;</code>
       *
       * @return Whether the defaultValue field is set.
       */
      @java.lang.Override
      public boolean hasDefaultValue() {
        return ((bitField0_ & 0x00000001) != 0);
      }
      /**
       *
       *
       * <pre>
       * A default value for an `INTEGER` parameter that is assumed to be a
       * relatively good starting point.  Unset value signals that there is no
       * offered starting point.
       * Currently only supported by the Vizier service. Not supported by
       * HyperparamterTuningJob or TrainingPipeline.
       * </pre>
       *
       * <code>int64 default_value = 4;</code>
       *
       * @return The defaultValue.
       */
      @java.lang.Override
      public long getDefaultValue() {
        return defaultValue_;
      }

      private byte memoizedIsInitialized = -1;

      @java.lang.Override
      public final boolean isInitialized() {
        byte isInitialized = memoizedIsInitialized;
        if (isInitialized == 1) return true;
        if (isInitialized == 0) return false;

        memoizedIsInitialized = 1;
        return true;
      }

      @java.lang.Override
      public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
        if (minValue_ != 0L) {
          output.writeInt64(1, minValue_);
        }
        if (maxValue_ != 0L) {
          output.writeInt64(2, maxValue_);
        }
        if (((bitField0_ & 0x00000001) != 0)) {
          output.writeInt64(4, defaultValue_);
        }
        unknownFields.writeTo(output);
      }

      @java.lang.Override
      public int getSerializedSize() {
        int size = memoizedSize;
        if (size != -1) return size;

        size = 0;
        if (minValue_ != 0L) {
          size += com.google.protobuf.CodedOutputStream.computeInt64Size(1, minValue_);
        }
        if (maxValue_ != 0L) {
          size += com.google.protobuf.CodedOutputStream.computeInt64Size(2, maxValue_);
        }
        if (((bitField0_ & 0x00000001) != 0)) {
          size += com.google.protobuf.CodedOutputStream.computeInt64Size(4, defaultValue_);
        }
        size += unknownFields.getSerializedSize();
        memoizedSize = size;
        return size;
      }

      @java.lang.Override
      public boolean equals(final java.lang.Object obj) {
        if (obj == this) {
          return true;
        }
        if (!(obj
            instanceof
            com.google.cloud.aiplatform.v1beta1.StudySpec.ParameterSpec.IntegerValueSpec)) {
          return super.equals(obj);
        }
        com.google.cloud.aiplatform.v1beta1.StudySpec.ParameterSpec.IntegerValueSpec other =
            (com.google.cloud.aiplatform.v1beta1.StudySpec.ParameterSpec.IntegerValueSpec) obj;

        if (getMinValue() != other.getMinValue()) return false;
        if (getMaxValue() != other.getMaxValue()) return false;
        if (hasDefaultValue() != other.hasDefaultValue()) return false;
        if (hasDefaultValue()) {
          if (getDefaultValue() != other.getDefaultValue()) return false;
        }
        if (!unknownFields.equals(other.unknownFields)) return false;
        return true;
      }

      @java.lang.Override
      public int hashCode() {
        if (memoizedHashCode != 0) {
          return memoizedHashCode;
        }
        int hash = 41;
        hash = (19 * hash) + getDescriptor().hashCode();
        hash = (37 * hash) + MIN_VALUE_FIELD_NUMBER;
        hash = (53 * hash) + com.google.protobuf.Internal.hashLong(getMinValue());
        hash = (37 * hash) + MAX_VALUE_FIELD_NUMBER;
        hash = (53 * hash) + com.google.protobuf.Internal.hashLong(getMaxValue());
        if (hasDefaultValue()) {
          hash = (37 * hash) + DEFAULT_VALUE_FIELD_NUMBER;
          hash = (53 * hash) + com.google.protobuf.Internal.hashLong(getDefaultValue());
        }
        hash = (29 * hash) + unknownFields.hashCode();
        memoizedHashCode = hash;
        return hash;
      }

      public static com.google.cloud.aiplatform.v1beta1.StudySpec.ParameterSpec.IntegerValueSpec
          parseFrom(java.nio.ByteBuffer data)
              throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data);
      }

      public static com.google.cloud.aiplatform.v1beta1.StudySpec.ParameterSpec.IntegerValueSpec
          parseFrom(
              java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data, extensionRegistry);
      }

      public static com.google.cloud.aiplatform.v1beta1.StudySpec.ParameterSpec.IntegerValueSpec
          parseFrom(com.google.protobuf.ByteString data)
              throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data);
      }

      public static com.google.cloud.aiplatform.v1beta1.StudySpec.ParameterSpec.IntegerValueSpec
          parseFrom(
              com.google.protobuf.ByteString data,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data, extensionRegistry);
      }

      public static com.google.cloud.aiplatform.v1beta1.StudySpec.ParameterSpec.IntegerValueSpec
          parseFrom(byte[] data) throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data);
      }

      public static com.google.cloud.aiplatform.v1beta1.StudySpec.ParameterSpec.IntegerValueSpec
          parseFrom(byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data, extensionRegistry);
      }

      public static com.google.cloud.aiplatform.v1beta1.StudySpec.ParameterSpec.IntegerValueSpec
          parseFrom(java.io.InputStream input) throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
      }

      public static com.google.cloud.aiplatform.v1beta1.StudySpec.ParameterSpec.IntegerValueSpec
          parseFrom(
              java.io.InputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
            PARSER, input, extensionRegistry);
      }

      public static com.google.cloud.aiplatform.v1beta1.StudySpec.ParameterSpec.IntegerValueSpec
          parseDelimitedFrom(java.io.InputStream input) throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
      }

      public static com.google.cloud.aiplatform.v1beta1.StudySpec.ParameterSpec.IntegerValueSpec
          parseDelimitedFrom(
              java.io.InputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
            PARSER, input, extensionRegistry);
      }

      public static com.google.cloud.aiplatform.v1beta1.StudySpec.ParameterSpec.IntegerValueSpec
          parseFrom(com.google.protobuf.CodedInputStream input) throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
      }

      public static com.google.cloud.aiplatform.v1beta1.StudySpec.ParameterSpec.IntegerValueSpec
          parseFrom(
              com.google.protobuf.CodedInputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
            PARSER, input, extensionRegistry);
      }

      @java.lang.Override
      public Builder newBuilderForType() {
        return newBuilder();
      }

      public static Builder newBuilder() {
        return DEFAULT_INSTANCE.toBuilder();
      }

      public static Builder newBuilder(
          com.google.cloud.aiplatform.v1beta1.StudySpec.ParameterSpec.IntegerValueSpec prototype) {
        return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
      }

      @java.lang.Override
      public Builder toBuilder() {
        return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
      }

      @java.lang.Override
      protected Builder newBuilderForType(
          com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
        Builder builder = new Builder(parent);
        return builder;
      }
      /**
       *
       *
       * <pre>
       * Value specification for a parameter in `INTEGER` type.
       * </pre>
       *
       * Protobuf type {@code
       * google.cloud.aiplatform.v1beta1.StudySpec.ParameterSpec.IntegerValueSpec}
       */
      public static final class Builder
          extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
          implements
          // @@protoc_insertion_point(builder_implements:google.cloud.aiplatform.v1beta1.StudySpec.ParameterSpec.IntegerValueSpec)
          com.google.cloud.aiplatform.v1beta1.StudySpec.ParameterSpec.IntegerValueSpecOrBuilder {
        public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
          return com.google.cloud.aiplatform.v1beta1.StudyProto
              .internal_static_google_cloud_aiplatform_v1beta1_StudySpec_ParameterSpec_IntegerValueSpec_descriptor;
        }

        @java.lang.Override
        protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
            internalGetFieldAccessorTable() {
          return com.google.cloud.aiplatform.v1beta1.StudyProto
              .internal_static_google_cloud_aiplatform_v1beta1_StudySpec_ParameterSpec_IntegerValueSpec_fieldAccessorTable
              .ensureFieldAccessorsInitialized(
                  com.google.cloud.aiplatform.v1beta1.StudySpec.ParameterSpec.IntegerValueSpec
                      .class,
                  com.google.cloud.aiplatform.v1beta1.StudySpec.ParameterSpec.IntegerValueSpec
                      .Builder.class);
        }

        // Construct using
        // com.google.cloud.aiplatform.v1beta1.StudySpec.ParameterSpec.IntegerValueSpec.newBuilder()
        private Builder() {
          maybeForceBuilderInitialization();
        }

        private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
          super(parent);
          maybeForceBuilderInitialization();
        }

        private void maybeForceBuilderInitialization() {
          if (com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders) {}
        }

        @java.lang.Override
        public Builder clear() {
          super.clear();
          minValue_ = 0L;

          maxValue_ = 0L;

          defaultValue_ = 0L;
          bitField0_ = (bitField0_ & ~0x00000001);
          return this;
        }

        @java.lang.Override
        public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
          return com.google.cloud.aiplatform.v1beta1.StudyProto
              .internal_static_google_cloud_aiplatform_v1beta1_StudySpec_ParameterSpec_IntegerValueSpec_descriptor;
        }

        @java.lang.Override
        public com.google.cloud.aiplatform.v1beta1.StudySpec.ParameterSpec.IntegerValueSpec
            getDefaultInstanceForType() {
          return com.google.cloud.aiplatform.v1beta1.StudySpec.ParameterSpec.IntegerValueSpec
              .getDefaultInstance();
        }

        @java.lang.Override
        public com.google.cloud.aiplatform.v1beta1.StudySpec.ParameterSpec.IntegerValueSpec
            build() {
          com.google.cloud.aiplatform.v1beta1.StudySpec.ParameterSpec.IntegerValueSpec result =
              buildPartial();
          if (!result.isInitialized()) {
            throw newUninitializedMessageException(result);
          }
          return result;
        }

        @java.lang.Override
        public com.google.cloud.aiplatform.v1beta1.StudySpec.ParameterSpec.IntegerValueSpec
            buildPartial() {
          com.google.cloud.aiplatform.v1beta1.StudySpec.ParameterSpec.IntegerValueSpec result =
              new com.google.cloud.aiplatform.v1beta1.StudySpec.ParameterSpec.IntegerValueSpec(
                  this);
          int from_bitField0_ = bitField0_;
          int to_bitField0_ = 0;
          result.minValue_ = minValue_;
          result.maxValue_ = maxValue_;
          if (((from_bitField0_ & 0x00000001) != 0)) {
            result.defaultValue_ = defaultValue_;
            to_bitField0_ |= 0x00000001;
          }
          result.bitField0_ = to_bitField0_;
          onBuilt();
          return result;
        }

        @java.lang.Override
        public Builder clone() {
          return super.clone();
        }

        @java.lang.Override
        public Builder setField(
            com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
          return super.setField(field, value);
        }

        @java.lang.Override
        public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
          return super.clearField(field);
        }

        @java.lang.Override
        public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
          return super.clearOneof(oneof);
        }

        @java.lang.Override
        public Builder setRepeatedField(
            com.google.protobuf.Descriptors.FieldDescriptor field,
            int index,
            java.lang.Object value) {
          return super.setRepeatedField(field, index, value);
        }

        @java.lang.Override
        public Builder addRepeatedField(
            com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
          return super.addRepeatedField(field, value);
        }

        @java.lang.Override
        public Builder mergeFrom(com.google.protobuf.Message other) {
          if (other
              instanceof
              com.google.cloud.aiplatform.v1beta1.StudySpec.ParameterSpec.IntegerValueSpec) {
            return mergeFrom(
                (com.google.cloud.aiplatform.v1beta1.StudySpec.ParameterSpec.IntegerValueSpec)
                    other);
          } else {
            super.mergeFrom(other);
            return this;
          }
        }

        public Builder mergeFrom(
            com.google.cloud.aiplatform.v1beta1.StudySpec.ParameterSpec.IntegerValueSpec other) {
          if (other
              == com.google.cloud.aiplatform.v1beta1.StudySpec.ParameterSpec.IntegerValueSpec
                  .getDefaultInstance()) return this;
          if (other.getMinValue() != 0L) {
            setMinValue(other.getMinValue());
          }
          if (other.getMaxValue() != 0L) {
            setMaxValue(other.getMaxValue());
          }
          if (other.hasDefaultValue()) {
            setDefaultValue(other.getDefaultValue());
          }
          this.mergeUnknownFields(other.unknownFields);
          onChanged();
          return this;
        }

        @java.lang.Override
        public final boolean isInitialized() {
          return true;
        }

        @java.lang.Override
        public Builder mergeFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws java.io.IOException {
          com.google.cloud.aiplatform.v1beta1.StudySpec.ParameterSpec.IntegerValueSpec
              parsedMessage = null;
          try {
            parsedMessage = PARSER.parsePartialFrom(input, extensionRegistry);
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            parsedMessage =
                (com.google.cloud.aiplatform.v1beta1.StudySpec.ParameterSpec.IntegerValueSpec)
                    e.getUnfinishedMessage();
            throw e.unwrapIOException();
          } finally {
            if (parsedMessage != null) {
              mergeFrom(parsedMessage);
            }
          }
          return this;
        }

        private int bitField0_;

        private long minValue_;
        /**
         *
         *
         * <pre>
         * Required. Inclusive minimum value of the parameter.
         * </pre>
         *
         * <code>int64 min_value = 1 [(.google.api.field_behavior) = REQUIRED];</code>
         *
         * @return The minValue.
         */
        @java.lang.Override
        public long getMinValue() {
          return minValue_;
        }
        /**
         *
         *
         * <pre>
         * Required. Inclusive minimum value of the parameter.
         * </pre>
         *
         * <code>int64 min_value = 1 [(.google.api.field_behavior) = REQUIRED];</code>
         *
         * @param value The minValue to set.
         * @return This builder for chaining.
         */
        public Builder setMinValue(long value) {

          minValue_ = value;
          onChanged();
          return this;
        }
        /**
         *
         *
         * <pre>
         * Required. Inclusive minimum value of the parameter.
         * </pre>
         *
         * <code>int64 min_value = 1 [(.google.api.field_behavior) = REQUIRED];</code>
         *
         * @return This builder for chaining.
         */
        public Builder clearMinValue() {

          minValue_ = 0L;
          onChanged();
          return this;
        }

        private long maxValue_;
        /**
         *
         *
         * <pre>
         * Required. Inclusive maximum value of the parameter.
         * </pre>
         *
         * <code>int64 max_value = 2 [(.google.api.field_behavior) = REQUIRED];</code>
         *
         * @return The maxValue.
         */
        @java.lang.Override
        public long getMaxValue() {
          return maxValue_;
        }
        /**
         *
         *
         * <pre>
         * Required. Inclusive maximum value of the parameter.
         * </pre>
         *
         * <code>int64 max_value = 2 [(.google.api.field_behavior) = REQUIRED];</code>
         *
         * @param value The maxValue to set.
         * @return This builder for chaining.
         */
        public Builder setMaxValue(long value) {

          maxValue_ = value;
          onChanged();
          return this;
        }
        /**
         *
         *
         * <pre>
         * Required. Inclusive maximum value of the parameter.
         * </pre>
         *
         * <code>int64 max_value = 2 [(.google.api.field_behavior) = REQUIRED];</code>
         *
         * @return This builder for chaining.
         */
        public Builder clearMaxValue() {

          maxValue_ = 0L;
          onChanged();
          return this;
        }

        private long defaultValue_;
        /**
         *
         *
         * <pre>
         * A default value for an `INTEGER` parameter that is assumed to be a
         * relatively good starting point.  Unset value signals that there is no
         * offered starting point.
         * Currently only supported by the Vizier service. Not supported by
         * HyperparamterTuningJob or TrainingPipeline.
         * </pre>
         *
         * <code>int64 default_value = 4;</code>
         *
         * @return Whether the defaultValue field is set.
         */
        @java.lang.Override
        public boolean hasDefaultValue() {
          return ((bitField0_ & 0x00000001) != 0);
        }
        /**
         *
         *
         * <pre>
         * A default value for an `INTEGER` parameter that is assumed to be a
         * relatively good starting point.  Unset value signals that there is no
         * offered starting point.
         * Currently only supported by the Vizier service. Not supported by
         * HyperparamterTuningJob or TrainingPipeline.
         * </pre>
         *
         * <code>int64 default_value = 4;</code>
         *
         * @return The defaultValue.
         */
        @java.lang.Override
        public long getDefaultValue() {
          return defaultValue_;
        }
        /**
         *
         *
         * <pre>
         * A default value for an `INTEGER` parameter that is assumed to be a
         * relatively good starting point.  Unset value signals that there is no
         * offered starting point.
         * Currently only supported by the Vizier service. Not supported by
         * HyperparamterTuningJob or TrainingPipeline.
         * </pre>
         *
         * <code>int64 default_value = 4;</code>
         *
         * @param value The defaultValue to set.
         * @return This builder for chaining.
         */
        public Builder setDefaultValue(long value) {
          bitField0_ |= 0x00000001;
          defaultValue_ = value;
          onChanged();
          return this;
        }
        /**
         *
         *
         * <pre>
         * A default value for an `INTEGER` parameter that is assumed to be a
         * relatively good starting point.  Unset value signals that there is no
         * offered starting point.
         * Currently only supported by the Vizier service. Not supported by
         * HyperparamterTuningJob or TrainingPipeline.
         * </pre>
         *
         * <code>int64 default_value = 4;</code>
         *
         * @return This builder for chaining.
         */
        public Builder clearDefaultValue() {
          bitField0_ = (bitField0_ & ~0x00000001);
          defaultValue_ = 0L;
          onChanged();
          return this;
        }

        @java.lang.Override
        public final Builder setUnknownFields(
            final com.google.protobuf.UnknownFieldSet unknownFields) {
          return super.setUnknownFields(unknownFields);
        }

        @java.lang.Override
        public final Builder mergeUnknownFields(
            final com.google.protobuf.UnknownFieldSet unknownFields) {
          return super.mergeUnknownFields(unknownFields);
        }

        // @@protoc_insertion_point(builder_scope:google.cloud.aiplatform.v1beta1.StudySpec.ParameterSpec.IntegerValueSpec)
      }

      // @@protoc_insertion_point(class_scope:google.cloud.aiplatform.v1beta1.StudySpec.ParameterSpec.IntegerValueSpec)
      private static final com.google.cloud.aiplatform.v1beta1.StudySpec.ParameterSpec
              .IntegerValueSpec
          DEFAULT_INSTANCE;

      static {
        DEFAULT_INSTANCE =
            new com.google.cloud.aiplatform.v1beta1.StudySpec.ParameterSpec.IntegerValueSpec();
      }

      public static com.google.cloud.aiplatform.v1beta1.StudySpec.ParameterSpec.IntegerValueSpec
          getDefaultInstance() {
        return DEFAULT_INSTANCE;
      }

      private static final com.google.protobuf.Parser<IntegerValueSpec> PARSER =
          new com.google.protobuf.AbstractParser<IntegerValueSpec>() {
            @java.lang.Override
            public IntegerValueSpec parsePartialFrom(
                com.google.protobuf.CodedInputStream input,
                com.google.protobuf.ExtensionRegistryLite extensionRegistry)
                throws com.google.protobuf.InvalidProtocolBufferException {
              return new IntegerValueSpec(input, extensionRegistry);
            }
          };

      public static com.google.protobuf.Parser<IntegerValueSpec> parser() {
        return PARSER;
      }

      @java.lang.Override
      public com.google.protobuf.Parser<IntegerValueSpec> getParserForType() {
        return PARSER;
      }

      @java.lang.Override
      public com.google.cloud.aiplatform.v1beta1.StudySpec.ParameterSpec.IntegerValueSpec
          getDefaultInstanceForType() {
        return DEFAULT_INSTANCE;
      }
    }

    public interface CategoricalValueSpecOrBuilder
        extends
        // @@protoc_insertion_point(interface_extends:google.cloud.aiplatform.v1beta1.StudySpec.ParameterSpec.CategoricalValueSpec)
        com.google.protobuf.MessageOrBuilder {

      /**
       *
       *
       * <pre>
       * Required. The list of possible categories.
       * </pre>
       *
       * <code>repeated string values = 1 [(.google.api.field_behavior) = REQUIRED];</code>
       *
       * @return A list containing the values.
       */
      java.util.List<java.lang.String> getValuesList();
      /**
       *
       *
       * <pre>
       * Required. The list of possible categories.
       * </pre>
       *
       * <code>repeated string values = 1 [(.google.api.field_behavior) = REQUIRED];</code>
       *
       * @return The count of values.
       */
      int getValuesCount();
      /**
       *
       *
       * <pre>
       * Required. The list of possible categories.
       * </pre>
       *
       * <code>repeated string values = 1 [(.google.api.field_behavior) = REQUIRED];</code>
       *
       * @param index The index of the element to return.
       * @return The values at the given index.
       */
      java.lang.String getValues(int index);
      /**
       *
       *
       * <pre>
       * Required. The list of possible categories.
       * </pre>
       *
       * <code>repeated string values = 1 [(.google.api.field_behavior) = REQUIRED];</code>
       *
       * @param index The index of the value to return.
       * @return The bytes of the values at the given index.
       */
      com.google.protobuf.ByteString getValuesBytes(int index);

      /**
       *
       *
       * <pre>
       * A default value for a `CATEGORICAL` parameter that is assumed to be a
       * relatively good starting point.  Unset value signals that there is no
       * offered starting point.
       * Currently only supported by the Vizier service. Not supported by
       * HyperparamterTuningJob or TrainingPipeline.
       * </pre>
       *
       * <code>string default_value = 3;</code>
       *
       * @return Whether the defaultValue field is set.
       */
      boolean hasDefaultValue();
      /**
       *
       *
       * <pre>
       * A default value for a `CATEGORICAL` parameter that is assumed to be a
       * relatively good starting point.  Unset value signals that there is no
       * offered starting point.
       * Currently only supported by the Vizier service. Not supported by
       * HyperparamterTuningJob or TrainingPipeline.
       * </pre>
       *
       * <code>string default_value = 3;</code>
       *
       * @return The defaultValue.
       */
      java.lang.String getDefaultValue();
      /**
       *
       *
       * <pre>
       * A default value for a `CATEGORICAL` parameter that is assumed to be a
       * relatively good starting point.  Unset value signals that there is no
       * offered starting point.
       * Currently only supported by the Vizier service. Not supported by
       * HyperparamterTuningJob or TrainingPipeline.
       * </pre>
       *
       * <code>string default_value = 3;</code>
       *
       * @return The bytes for defaultValue.
       */
      com.google.protobuf.ByteString getDefaultValueBytes();
    }
    /**
     *
     *
     * <pre>
     * Value specification for a parameter in `CATEGORICAL` type.
     * </pre>
     *
     * Protobuf type {@code
     * google.cloud.aiplatform.v1beta1.StudySpec.ParameterSpec.CategoricalValueSpec}
     */
    public static final class CategoricalValueSpec extends com.google.protobuf.GeneratedMessageV3
        implements
        // @@protoc_insertion_point(message_implements:google.cloud.aiplatform.v1beta1.StudySpec.ParameterSpec.CategoricalValueSpec)
        CategoricalValueSpecOrBuilder {
      private static final long serialVersionUID = 0L;
      // Use CategoricalValueSpec.newBuilder() to construct.
      private CategoricalValueSpec(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
        super(builder);
      }

      private CategoricalValueSpec() {
        values_ = com.google.protobuf.LazyStringArrayList.EMPTY;
        defaultValue_ = "";
      }

      @java.lang.Override
      @SuppressWarnings({"unused"})
      protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
        return new CategoricalValueSpec();
      }

      @java.lang.Override
      public final com.google.protobuf.UnknownFieldSet getUnknownFields() {
        return this.unknownFields;
      }

      private CategoricalValueSpec(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws com.google.protobuf.InvalidProtocolBufferException {
        this();
        if (extensionRegistry == null) {
          throw new java.lang.NullPointerException();
        }
        int mutable_bitField0_ = 0;
        com.google.protobuf.UnknownFieldSet.Builder unknownFields =
            com.google.protobuf.UnknownFieldSet.newBuilder();
        try {
          boolean done = false;
          while (!done) {
            int tag = input.readTag();
            switch (tag) {
              case 0:
                done = true;
                break;
              case 10:
                {
                  java.lang.String s = input.readStringRequireUtf8();
                  if (!((mutable_bitField0_ & 0x00000001) != 0)) {
                    values_ = new com.google.protobuf.LazyStringArrayList();
                    mutable_bitField0_ |= 0x00000001;
                  }
                  values_.add(s);
                  break;
                }
              case 26:
                {
                  java.lang.String s = input.readStringRequireUtf8();
                  bitField0_ |= 0x00000001;
                  defaultValue_ = s;
                  break;
                }
              default:
                {
                  if (!parseUnknownField(input, unknownFields, extensionRegistry, tag)) {
                    done = true;
                  }
                  break;
                }
            }
          }
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          throw e.setUnfinishedMessage(this);
        } catch (java.io.IOException e) {
          throw new com.google.protobuf.InvalidProtocolBufferException(e)
              .setUnfinishedMessage(this);
        } finally {
          if (((mutable_bitField0_ & 0x00000001) != 0)) {
            values_ = values_.getUnmodifiableView();
          }
          this.unknownFields = unknownFields.build();
          makeExtensionsImmutable();
        }
      }

      public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
        return com.google.cloud.aiplatform.v1beta1.StudyProto
            .internal_static_google_cloud_aiplatform_v1beta1_StudySpec_ParameterSpec_CategoricalValueSpec_descriptor;
      }

      @java.lang.Override
      protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return com.google.cloud.aiplatform.v1beta1.StudyProto
            .internal_static_google_cloud_aiplatform_v1beta1_StudySpec_ParameterSpec_CategoricalValueSpec_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                com.google.cloud.aiplatform.v1beta1.StudySpec.ParameterSpec.CategoricalValueSpec
                    .class,
                com.google.cloud.aiplatform.v1beta1.StudySpec.ParameterSpec.CategoricalValueSpec
                    .Builder.class);
      }

      private int bitField0_;
      public static final int VALUES_FIELD_NUMBER = 1;
      private com.google.protobuf.LazyStringList values_;
      /**
       *
       *
       * <pre>
       * Required. The list of possible categories.
       * </pre>
       *
       * <code>repeated string values = 1 [(.google.api.field_behavior) = REQUIRED];</code>
       *
       * @return A list containing the values.
       */
      public com.google.protobuf.ProtocolStringList getValuesList() {
        return values_;
      }
      /**
       *
       *
       * <pre>
       * Required. The list of possible categories.
       * </pre>
       *
       * <code>repeated string values = 1 [(.google.api.field_behavior) = REQUIRED];</code>
       *
       * @return The count of values.
       */
      public int getValuesCount() {
        return values_.size();
      }
      /**
       *
       *
       * <pre>
       * Required. The list of possible categories.
       * </pre>
       *
       * <code>repeated string values = 1 [(.google.api.field_behavior) = REQUIRED];</code>
       *
       * @param index The index of the element to return.
       * @return The values at the given index.
       */
      public java.lang.String getValues(int index) {
        return values_.get(index);
      }
      /**
       *
       *
       * <pre>
       * Required. The list of possible categories.
       * </pre>
       *
       * <code>repeated string values = 1 [(.google.api.field_behavior) = REQUIRED];</code>
       *
       * @param index The index of the value to return.
       * @return The bytes of the values at the given index.
       */
      public com.google.protobuf.ByteString getValuesBytes(int index) {
        return values_.getByteString(index);
      }

      public static final int DEFAULT_VALUE_FIELD_NUMBER = 3;
      private volatile java.lang.Object defaultValue_;
      /**
       *
       *
       * <pre>
       * A default value for a `CATEGORICAL` parameter that is assumed to be a
       * relatively good starting point.  Unset value signals that there is no
       * offered starting point.
       * Currently only supported by the Vizier service. Not supported by
       * HyperparamterTuningJob or TrainingPipeline.
       * </pre>
       *
       * <code>string default_value = 3;</code>
       *
       * @return Whether the defaultValue field is set.
       */
      @java.lang.Override
      public boolean hasDefaultValue() {
        return ((bitField0_ & 0x00000001) != 0);
      }
      /**
       *
       *
       * <pre>
       * A default value for a `CATEGORICAL` parameter that is assumed to be a
       * relatively good starting point.  Unset value signals that there is no
       * offered starting point.
       * Currently only supported by the Vizier service. Not supported by
       * HyperparamterTuningJob or TrainingPipeline.
       * </pre>
       *
       * <code>string default_value = 3;</code>
       *
       * @return The defaultValue.
       */
      @java.lang.Override
      public java.lang.String getDefaultValue() {
        java.lang.Object ref = defaultValue_;
        if (ref instanceof java.lang.String) {
          return (java.lang.String) ref;
        } else {
          com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
          java.lang.String s = bs.toStringUtf8();
          defaultValue_ = s;
          return s;
        }
      }
      /**
       *
       *
       * <pre>
       * A default value for a `CATEGORICAL` parameter that is assumed to be a
       * relatively good starting point.  Unset value signals that there is no
       * offered starting point.
       * Currently only supported by the Vizier service. Not supported by
       * HyperparamterTuningJob or TrainingPipeline.
       * </pre>
       *
       * <code>string default_value = 3;</code>
       *
       * @return The bytes for defaultValue.
       */
      @java.lang.Override
      public com.google.protobuf.ByteString getDefaultValueBytes() {
        java.lang.Object ref = defaultValue_;
        if (ref instanceof java.lang.String) {
          com.google.protobuf.ByteString b =
              com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
          defaultValue_ = b;
          return b;
        } else {
          return (com.google.protobuf.ByteString) ref;
        }
      }

      private byte memoizedIsInitialized = -1;

      @java.lang.Override
      public final boolean isInitialized() {
        byte isInitialized = memoizedIsInitialized;
        if (isInitialized == 1) return true;
        if (isInitialized == 0) return false;

        memoizedIsInitialized = 1;
        return true;
      }

      @java.lang.Override
      public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
        for (int i = 0; i < values_.size(); i++) {
          com.google.protobuf.GeneratedMessageV3.writeString(output, 1, values_.getRaw(i));
        }
        if (((bitField0_ & 0x00000001) != 0)) {
          com.google.protobuf.GeneratedMessageV3.writeString(output, 3, defaultValue_);
        }
        unknownFields.writeTo(output);
      }

      @java.lang.Override
      public int getSerializedSize() {
        int size = memoizedSize;
        if (size != -1) return size;

        size = 0;
        {
          int dataSize = 0;
          for (int i = 0; i < values_.size(); i++) {
            dataSize += computeStringSizeNoTag(values_.getRaw(i));
          }
          size += dataSize;
          size += 1 * getValuesList().size();
        }
        if (((bitField0_ & 0x00000001) != 0)) {
          size += com.google.protobuf.GeneratedMessageV3.computeStringSize(3, defaultValue_);
        }
        size += unknownFields.getSerializedSize();
        memoizedSize = size;
        return size;
      }

      @java.lang.Override
      public boolean equals(final java.lang.Object obj) {
        if (obj == this) {
          return true;
        }
        if (!(obj
            instanceof
            com.google.cloud.aiplatform.v1beta1.StudySpec.ParameterSpec.CategoricalValueSpec)) {
          return super.equals(obj);
        }
        com.google.cloud.aiplatform.v1beta1.StudySpec.ParameterSpec.CategoricalValueSpec other =
            (com.google.cloud.aiplatform.v1beta1.StudySpec.ParameterSpec.CategoricalValueSpec) obj;

        if (!getValuesList().equals(other.getValuesList())) return false;
        if (hasDefaultValue() != other.hasDefaultValue()) return false;
        if (hasDefaultValue()) {
          if (!getDefaultValue().equals(other.getDefaultValue())) return false;
        }
        if (!unknownFields.equals(other.unknownFields)) return false;
        return true;
      }

      @java.lang.Override
      public int hashCode() {
        if (memoizedHashCode != 0) {
          return memoizedHashCode;
        }
        int hash = 41;
        hash = (19 * hash) + getDescriptor().hashCode();
        if (getValuesCount() > 0) {
          hash = (37 * hash) + VALUES_FIELD_NUMBER;
          hash = (53 * hash) + getValuesList().hashCode();
        }
        if (hasDefaultValue()) {
          hash = (37 * hash) + DEFAULT_VALUE_FIELD_NUMBER;
          hash = (53 * hash) + getDefaultValue().hashCode();
        }
        hash = (29 * hash) + unknownFields.hashCode();
        memoizedHashCode = hash;
        return hash;
      }

      public static com.google.cloud.aiplatform.v1beta1.StudySpec.ParameterSpec.CategoricalValueSpec
          parseFrom(java.nio.ByteBuffer data)
              throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data);
      }

      public static com.google.cloud.aiplatform.v1beta1.StudySpec.ParameterSpec.CategoricalValueSpec
          parseFrom(
              java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data, extensionRegistry);
      }

      public static com.google.cloud.aiplatform.v1beta1.StudySpec.ParameterSpec.CategoricalValueSpec
          parseFrom(com.google.protobuf.ByteString data)
              throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data);
      }

      public static com.google.cloud.aiplatform.v1beta1.StudySpec.ParameterSpec.CategoricalValueSpec
          parseFrom(
              com.google.protobuf.ByteString data,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data, extensionRegistry);
      }

      public static com.google.cloud.aiplatform.v1beta1.StudySpec.ParameterSpec.CategoricalValueSpec
          parseFrom(byte[] data) throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data);
      }

      public static com.google.cloud.aiplatform.v1beta1.StudySpec.ParameterSpec.CategoricalValueSpec
          parseFrom(byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data, extensionRegistry);
      }

      public static com.google.cloud.aiplatform.v1beta1.StudySpec.ParameterSpec.CategoricalValueSpec
          parseFrom(java.io.InputStream input) throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
      }

      public static com.google.cloud.aiplatform.v1beta1.StudySpec.ParameterSpec.CategoricalValueSpec
          parseFrom(
              java.io.InputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
            PARSER, input, extensionRegistry);
      }

      public static com.google.cloud.aiplatform.v1beta1.StudySpec.ParameterSpec.CategoricalValueSpec
          parseDelimitedFrom(java.io.InputStream input) throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
      }

      public static com.google.cloud.aiplatform.v1beta1.StudySpec.ParameterSpec.CategoricalValueSpec
          parseDelimitedFrom(
              java.io.InputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
            PARSER, input, extensionRegistry);
      }

      public static com.google.cloud.aiplatform.v1beta1.StudySpec.ParameterSpec.CategoricalValueSpec
          parseFrom(com.google.protobuf.CodedInputStream input) throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
      }

      public static com.google.cloud.aiplatform.v1beta1.StudySpec.ParameterSpec.CategoricalValueSpec
          parseFrom(
              com.google.protobuf.CodedInputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
            PARSER, input, extensionRegistry);
      }

      @java.lang.Override
      public Builder newBuilderForType() {
        return newBuilder();
      }

      public static Builder newBuilder() {
        return DEFAULT_INSTANCE.toBuilder();
      }

      public static Builder newBuilder(
          com.google.cloud.aiplatform.v1beta1.StudySpec.ParameterSpec.CategoricalValueSpec
              prototype) {
        return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
      }

      @java.lang.Override
      public Builder toBuilder() {
        return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
      }

      @java.lang.Override
      protected Builder newBuilderForType(
          com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
        Builder builder = new Builder(parent);
        return builder;
      }
      /**
       *
       *
       * <pre>
       * Value specification for a parameter in `CATEGORICAL` type.
       * </pre>
       *
       * Protobuf type {@code
       * google.cloud.aiplatform.v1beta1.StudySpec.ParameterSpec.CategoricalValueSpec}
       */
      public static final class Builder
          extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
          implements
          // @@protoc_insertion_point(builder_implements:google.cloud.aiplatform.v1beta1.StudySpec.ParameterSpec.CategoricalValueSpec)
          com.google.cloud.aiplatform.v1beta1.StudySpec.ParameterSpec
              .CategoricalValueSpecOrBuilder {
        public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
          return com.google.cloud.aiplatform.v1beta1.StudyProto
              .internal_static_google_cloud_aiplatform_v1beta1_StudySpec_ParameterSpec_CategoricalValueSpec_descriptor;
        }

        @java.lang.Override
        protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
            internalGetFieldAccessorTable() {
          return com.google.cloud.aiplatform.v1beta1.StudyProto
              .internal_static_google_cloud_aiplatform_v1beta1_StudySpec_ParameterSpec_CategoricalValueSpec_fieldAccessorTable
              .ensureFieldAccessorsInitialized(
                  com.google.cloud.aiplatform.v1beta1.StudySpec.ParameterSpec.CategoricalValueSpec
                      .class,
                  com.google.cloud.aiplatform.v1beta1.StudySpec.ParameterSpec.CategoricalValueSpec
                      .Builder.class);
        }

        // Construct using
        // com.google.cloud.aiplatform.v1beta1.StudySpec.ParameterSpec.CategoricalValueSpec.newBuilder()
        private Builder() {
          maybeForceBuilderInitialization();
        }

        private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
          super(parent);
          maybeForceBuilderInitialization();
        }

        private void maybeForceBuilderInitialization() {
          if (com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders) {}
        }

        @java.lang.Override
        public Builder clear() {
          super.clear();
          values_ = com.google.protobuf.LazyStringArrayList.EMPTY;
          bitField0_ = (bitField0_ & ~0x00000001);
          defaultValue_ = "";
          bitField0_ = (bitField0_ & ~0x00000002);
          return this;
        }

        @java.lang.Override
        public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
          return com.google.cloud.aiplatform.v1beta1.StudyProto
              .internal_static_google_cloud_aiplatform_v1beta1_StudySpec_ParameterSpec_CategoricalValueSpec_descriptor;
        }

        @java.lang.Override
        public com.google.cloud.aiplatform.v1beta1.StudySpec.ParameterSpec.CategoricalValueSpec
            getDefaultInstanceForType() {
          return com.google.cloud.aiplatform.v1beta1.StudySpec.ParameterSpec.CategoricalValueSpec
              .getDefaultInstance();
        }

        @java.lang.Override
        public com.google.cloud.aiplatform.v1beta1.StudySpec.ParameterSpec.CategoricalValueSpec
            build() {
          com.google.cloud.aiplatform.v1beta1.StudySpec.ParameterSpec.CategoricalValueSpec result =
              buildPartial();
          if (!result.isInitialized()) {
            throw newUninitializedMessageException(result);
          }
          return result;
        }

        @java.lang.Override
        public com.google.cloud.aiplatform.v1beta1.StudySpec.ParameterSpec.CategoricalValueSpec
            buildPartial() {
          com.google.cloud.aiplatform.v1beta1.StudySpec.ParameterSpec.CategoricalValueSpec result =
              new com.google.cloud.aiplatform.v1beta1.StudySpec.ParameterSpec.CategoricalValueSpec(
                  this);
          int from_bitField0_ = bitField0_;
          int to_bitField0_ = 0;
          if (((bitField0_ & 0x00000001) != 0)) {
            values_ = values_.getUnmodifiableView();
            bitField0_ = (bitField0_ & ~0x00000001);
          }
          result.values_ = values_;
          if (((from_bitField0_ & 0x00000002) != 0)) {
            to_bitField0_ |= 0x00000001;
          }
          result.defaultValue_ = defaultValue_;
          result.bitField0_ = to_bitField0_;
          onBuilt();
          return result;
        }

        @java.lang.Override
        public Builder clone() {
          return super.clone();
        }

        @java.lang.Override
        public Builder setField(
            com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
          return super.setField(field, value);
        }

        @java.lang.Override
        public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
          return super.clearField(field);
        }

        @java.lang.Override
        public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
          return super.clearOneof(oneof);
        }

        @java.lang.Override
        public Builder setRepeatedField(
            com.google.protobuf.Descriptors.FieldDescriptor field,
            int index,
            java.lang.Object value) {
          return super.setRepeatedField(field, index, value);
        }

        @java.lang.Override
        public Builder addRepeatedField(
            com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
          return super.addRepeatedField(field, value);
        }

        @java.lang.Override
        public Builder mergeFrom(com.google.protobuf.Message other) {
          if (other
              instanceof
              com.google.cloud.aiplatform.v1beta1.StudySpec.ParameterSpec.CategoricalValueSpec) {
            return mergeFrom(
                (com.google.cloud.aiplatform.v1beta1.StudySpec.ParameterSpec.CategoricalValueSpec)
                    other);
          } else {
            super.mergeFrom(other);
            return this;
          }
        }

        public Builder mergeFrom(
            com.google.cloud.aiplatform.v1beta1.StudySpec.ParameterSpec.CategoricalValueSpec
                other) {
          if (other
              == com.google.cloud.aiplatform.v1beta1.StudySpec.ParameterSpec.CategoricalValueSpec
                  .getDefaultInstance()) return this;
          if (!other.values_.isEmpty()) {
            if (values_.isEmpty()) {
              values_ = other.values_;
              bitField0_ = (bitField0_ & ~0x00000001);
            } else {
              ensureValuesIsMutable();
              values_.addAll(other.values_);
            }
            onChanged();
          }
          if (other.hasDefaultValue()) {
            bitField0_ |= 0x00000002;
            defaultValue_ = other.defaultValue_;
            onChanged();
          }
          this.mergeUnknownFields(other.unknownFields);
          onChanged();
          return this;
        }

        @java.lang.Override
        public final boolean isInitialized() {
          return true;
        }

        @java.lang.Override
        public Builder mergeFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws java.io.IOException {
          com.google.cloud.aiplatform.v1beta1.StudySpec.ParameterSpec.CategoricalValueSpec
              parsedMessage = null;
          try {
            parsedMessage = PARSER.parsePartialFrom(input, extensionRegistry);
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            parsedMessage =
                (com.google.cloud.aiplatform.v1beta1.StudySpec.ParameterSpec.CategoricalValueSpec)
                    e.getUnfinishedMessage();
            throw e.unwrapIOException();
          } finally {
            if (parsedMessage != null) {
              mergeFrom(parsedMessage);
            }
          }
          return this;
        }

        private int bitField0_;

        private com.google.protobuf.LazyStringList values_ =
            com.google.protobuf.LazyStringArrayList.EMPTY;

        private void ensureValuesIsMutable() {
          if (!((bitField0_ & 0x00000001) != 0)) {
            values_ = new com.google.protobuf.LazyStringArrayList(values_);
            bitField0_ |= 0x00000001;
          }
        }
        /**
         *
         *
         * <pre>
         * Required. The list of possible categories.
         * </pre>
         *
         * <code>repeated string values = 1 [(.google.api.field_behavior) = REQUIRED];</code>
         *
         * @return A list containing the values.
         */
        public com.google.protobuf.ProtocolStringList getValuesList() {
          return values_.getUnmodifiableView();
        }
        /**
         *
         *
         * <pre>
         * Required. The list of possible categories.
         * </pre>
         *
         * <code>repeated string values = 1 [(.google.api.field_behavior) = REQUIRED];</code>
         *
         * @return The count of values.
         */
        public int getValuesCount() {
          return values_.size();
        }
        /**
         *
         *
         * <pre>
         * Required. The list of possible categories.
         * </pre>
         *
         * <code>repeated string values = 1 [(.google.api.field_behavior) = REQUIRED];</code>
         *
         * @param index The index of the element to return.
         * @return The values at the given index.
         */
        public java.lang.String getValues(int index) {
          return values_.get(index);
        }
        /**
         *
         *
         * <pre>
         * Required. The list of possible categories.
         * </pre>
         *
         * <code>repeated string values = 1 [(.google.api.field_behavior) = REQUIRED];</code>
         *
         * @param index The index of the value to return.
         * @return The bytes of the values at the given index.
         */
        public com.google.protobuf.ByteString getValuesBytes(int index) {
          return values_.getByteString(index);
        }
        /**
         *
         *
         * <pre>
         * Required. The list of possible categories.
         * </pre>
         *
         * <code>repeated string values = 1 [(.google.api.field_behavior) = REQUIRED];</code>
         *
         * @param index The index to set the value at.
         * @param value The values to set.
         * @return This builder for chaining.
         */
        public Builder setValues(int index, java.lang.String value) {
          if (value == null) {
            throw new NullPointerException();
          }
          ensureValuesIsMutable();
          values_.set(index, value);
          onChanged();
          return this;
        }
        /**
         *
         *
         * <pre>
         * Required. The list of possible categories.
         * </pre>
         *
         * <code>repeated string values = 1 [(.google.api.field_behavior) = REQUIRED];</code>
         *
         * @param value The values to add.
         * @return This builder for chaining.
         */
        public Builder addValues(java.lang.String value) {
          if (value == null) {
            throw new NullPointerException();
          }
          ensureValuesIsMutable();
          values_.add(value);
          onChanged();
          return this;
        }
        /**
         *
         *
         * <pre>
         * Required. The list of possible categories.
         * </pre>
         *
         * <code>repeated string values = 1 [(.google.api.field_behavior) = REQUIRED];</code>
         *
         * @param values The values to add.
         * @return This builder for chaining.
         */
        public Builder addAllValues(java.lang.Iterable<java.lang.String> values) {
          ensureValuesIsMutable();
          com.google.protobuf.AbstractMessageLite.Builder.addAll(values, values_);
          onChanged();
          return this;
        }
        /**
         *
         *
         * <pre>
         * Required. The list of possible categories.
         * </pre>
         *
         * <code>repeated string values = 1 [(.google.api.field_behavior) = REQUIRED];</code>
         *
         * @return This builder for chaining.
         */
        public Builder clearValues() {
          values_ = com.google.protobuf.LazyStringArrayList.EMPTY;
          bitField0_ = (bitField0_ & ~0x00000001);
          onChanged();
          return this;
        }
        /**
         *
         *
         * <pre>
         * Required. The list of possible categories.
         * </pre>
         *
         * <code>repeated string values = 1 [(.google.api.field_behavior) = REQUIRED];</code>
         *
         * @param value The bytes of the values to add.
         * @return This builder for chaining.
         */
        public Builder addValuesBytes(com.google.protobuf.ByteString value) {
          if (value == null) {
            throw new NullPointerException();
          }
          checkByteStringIsUtf8(value);
          ensureValuesIsMutable();
          values_.add(value);
          onChanged();
          return this;
        }

        private java.lang.Object defaultValue_ = "";
        /**
         *
         *
         * <pre>
         * A default value for a `CATEGORICAL` parameter that is assumed to be a
         * relatively good starting point.  Unset value signals that there is no
         * offered starting point.
         * Currently only supported by the Vizier service. Not supported by
         * HyperparamterTuningJob or TrainingPipeline.
         * </pre>
         *
         * <code>string default_value = 3;</code>
         *
         * @return Whether the defaultValue field is set.
         */
        public boolean hasDefaultValue() {
          return ((bitField0_ & 0x00000002) != 0);
        }
        /**
         *
         *
         * <pre>
         * A default value for a `CATEGORICAL` parameter that is assumed to be a
         * relatively good starting point.  Unset value signals that there is no
         * offered starting point.
         * Currently only supported by the Vizier service. Not supported by
         * HyperparamterTuningJob or TrainingPipeline.
         * </pre>
         *
         * <code>string default_value = 3;</code>
         *
         * @return The defaultValue.
         */
        public java.lang.String getDefaultValue() {
          java.lang.Object ref = defaultValue_;
          if (!(ref instanceof java.lang.String)) {
            com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
            java.lang.String s = bs.toStringUtf8();
            defaultValue_ = s;
            return s;
          } else {
            return (java.lang.String) ref;
          }
        }
        /**
         *
         *
         * <pre>
         * A default value for a `CATEGORICAL` parameter that is assumed to be a
         * relatively good starting point.  Unset value signals that there is no
         * offered starting point.
         * Currently only supported by the Vizier service. Not supported by
         * HyperparamterTuningJob or TrainingPipeline.
         * </pre>
         *
         * <code>string default_value = 3;</code>
         *
         * @return The bytes for defaultValue.
         */
        public com.google.protobuf.ByteString getDefaultValueBytes() {
          java.lang.Object ref = defaultValue_;
          if (ref instanceof String) {
            com.google.protobuf.ByteString b =
                com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
            defaultValue_ = b;
            return b;
          } else {
            return (com.google.protobuf.ByteString) ref;
          }
        }
        /**
         *
         *
         * <pre>
         * A default value for a `CATEGORICAL` parameter that is assumed to be a
         * relatively good starting point.  Unset value signals that there is no
         * offered starting point.
         * Currently only supported by the Vizier service. Not supported by
         * HyperparamterTuningJob or TrainingPipeline.
         * </pre>
         *
         * <code>string default_value = 3;</code>
         *
         * @param value The defaultValue to set.
         * @return This builder for chaining.
         */
        public Builder setDefaultValue(java.lang.String value) {
          if (value == null) {
            throw new NullPointerException();
          }
          bitField0_ |= 0x00000002;
          defaultValue_ = value;
          onChanged();
          return this;
        }
        /**
         *
         *
         * <pre>
         * A default value for a `CATEGORICAL` parameter that is assumed to be a
         * relatively good starting point.  Unset value signals that there is no
         * offered starting point.
         * Currently only supported by the Vizier service. Not supported by
         * HyperparamterTuningJob or TrainingPipeline.
         * </pre>
         *
         * <code>string default_value = 3;</code>
         *
         * @return This builder for chaining.
         */
        public Builder clearDefaultValue() {
          bitField0_ = (bitField0_ & ~0x00000002);
          defaultValue_ = getDefaultInstance().getDefaultValue();
          onChanged();
          return this;
        }
        /**
         *
         *
         * <pre>
         * A default value for a `CATEGORICAL` parameter that is assumed to be a
         * relatively good starting point.  Unset value signals that there is no
         * offered starting point.
         * Currently only supported by the Vizier service. Not supported by
         * HyperparamterTuningJob or TrainingPipeline.
         * </pre>
         *
         * <code>string default_value = 3;</code>
         *
         * @param value The bytes for defaultValue to set.
         * @return This builder for chaining.
         */
        public Builder setDefaultValueBytes(com.google.protobuf.ByteString value) {
          if (value == null) {
            throw new NullPointerException();
          }
          checkByteStringIsUtf8(value);
          bitField0_ |= 0x00000002;
          defaultValue_ = value;
          onChanged();
          return this;
        }

        @java.lang.Override
        public final Builder setUnknownFields(
            final com.google.protobuf.UnknownFieldSet unknownFields) {
          return super.setUnknownFields(unknownFields);
        }

        @java.lang.Override
        public final Builder mergeUnknownFields(
            final com.google.protobuf.UnknownFieldSet unknownFields) {
          return super.mergeUnknownFields(unknownFields);
        }

        // @@protoc_insertion_point(builder_scope:google.cloud.aiplatform.v1beta1.StudySpec.ParameterSpec.CategoricalValueSpec)
      }

      // @@protoc_insertion_point(class_scope:google.cloud.aiplatform.v1beta1.StudySpec.ParameterSpec.CategoricalValueSpec)
      private static final com.google.cloud.aiplatform.v1beta1.StudySpec.ParameterSpec
              .CategoricalValueSpec
          DEFAULT_INSTANCE;

      static {
        DEFAULT_INSTANCE =
            new com.google.cloud.aiplatform.v1beta1.StudySpec.ParameterSpec.CategoricalValueSpec();
      }

      public static com.google.cloud.aiplatform.v1beta1.StudySpec.ParameterSpec.CategoricalValueSpec
          getDefaultInstance() {
        return DEFAULT_INSTANCE;
      }

      private static final com.google.protobuf.Parser<CategoricalValueSpec> PARSER =
          new com.google.protobuf.AbstractParser<CategoricalValueSpec>() {
            @java.lang.Override
            public CategoricalValueSpec parsePartialFrom(
                com.google.protobuf.CodedInputStream input,
                com.google.protobuf.ExtensionRegistryLite extensionRegistry)
                throws com.google.protobuf.InvalidProtocolBufferException {
              return new CategoricalValueSpec(input, extensionRegistry);
            }
          };

      public static com.google.protobuf.Parser<CategoricalValueSpec> parser() {
        return PARSER;
      }

      @java.lang.Override
      public com.google.protobuf.Parser<CategoricalValueSpec> getParserForType() {
        return PARSER;
      }

      @java.lang.Override
      public com.google.cloud.aiplatform.v1beta1.StudySpec.ParameterSpec.CategoricalValueSpec
          getDefaultInstanceForType() {
        return DEFAULT_INSTANCE;
      }
    }

    public interface DiscreteValueSpecOrBuilder
        extends
        // @@protoc_insertion_point(interface_extends:google.cloud.aiplatform.v1beta1.StudySpec.ParameterSpec.DiscreteValueSpec)
        com.google.protobuf.MessageOrBuilder {

      /**
       *
       *
       * <pre>
       * Required. A list of possible values.
       * The list should be in increasing order and at least 1e-10 apart.
       * For instance, this parameter might have possible settings of 1.5, 2.5,
       * and 4.0. This list should not contain more than 1,000 values.
       * </pre>
       *
       * <code>repeated double values = 1 [(.google.api.field_behavior) = REQUIRED];</code>
       *
       * @return A list containing the values.
       */
      java.util.List<java.lang.Double> getValuesList();
      /**
       *
       *
       * <pre>
       * Required. A list of possible values.
       * The list should be in increasing order and at least 1e-10 apart.
       * For instance, this parameter might have possible settings of 1.5, 2.5,
       * and 4.0. This list should not contain more than 1,000 values.
       * </pre>
       *
       * <code>repeated double values = 1 [(.google.api.field_behavior) = REQUIRED];</code>
       *
       * @return The count of values.
       */
      int getValuesCount();
      /**
       *
       *
       * <pre>
       * Required. A list of possible values.
       * The list should be in increasing order and at least 1e-10 apart.
       * For instance, this parameter might have possible settings of 1.5, 2.5,
       * and 4.0. This list should not contain more than 1,000 values.
       * </pre>
       *
       * <code>repeated double values = 1 [(.google.api.field_behavior) = REQUIRED];</code>
       *
       * @param index The index of the element to return.
       * @return The values at the given index.
       */
      double getValues(int index);

      /**
       *
       *
       * <pre>
       * A default value for a `DISCRETE` parameter that is assumed to be a
       * relatively good starting point.  Unset value signals that there is no
       * offered starting point.  It automatically rounds to the
       * nearest feasible discrete point.
       * Currently only supported by the Vizier service. Not supported by
       * HyperparamterTuningJob or TrainingPipeline.
       * </pre>
       *
       * <code>double default_value = 3;</code>
       *
       * @return Whether the defaultValue field is set.
       */
      boolean hasDefaultValue();
      /**
       *
       *
       * <pre>
       * A default value for a `DISCRETE` parameter that is assumed to be a
       * relatively good starting point.  Unset value signals that there is no
       * offered starting point.  It automatically rounds to the
       * nearest feasible discrete point.
       * Currently only supported by the Vizier service. Not supported by
       * HyperparamterTuningJob or TrainingPipeline.
       * </pre>
       *
       * <code>double default_value = 3;</code>
       *
       * @return The defaultValue.
       */
      double getDefaultValue();
    }
    /**
     *
     *
     * <pre>
     * Value specification for a parameter in `DISCRETE` type.
     * </pre>
     *
     * Protobuf type {@code
     * google.cloud.aiplatform.v1beta1.StudySpec.ParameterSpec.DiscreteValueSpec}
     */
    public static final class DiscreteValueSpec extends com.google.protobuf.GeneratedMessageV3
        implements
        // @@protoc_insertion_point(message_implements:google.cloud.aiplatform.v1beta1.StudySpec.ParameterSpec.DiscreteValueSpec)
        DiscreteValueSpecOrBuilder {
      private static final long serialVersionUID = 0L;
      // Use DiscreteValueSpec.newBuilder() to construct.
      private DiscreteValueSpec(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
        super(builder);
      }

      private DiscreteValueSpec() {
        values_ = emptyDoubleList();
      }

      @java.lang.Override
      @SuppressWarnings({"unused"})
      protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
        return new DiscreteValueSpec();
      }

      @java.lang.Override
      public final com.google.protobuf.UnknownFieldSet getUnknownFields() {
        return this.unknownFields;
      }

      private DiscreteValueSpec(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws com.google.protobuf.InvalidProtocolBufferException {
        this();
        if (extensionRegistry == null) {
          throw new java.lang.NullPointerException();
        }
        int mutable_bitField0_ = 0;
        com.google.protobuf.UnknownFieldSet.Builder unknownFields =
            com.google.protobuf.UnknownFieldSet.newBuilder();
        try {
          boolean done = false;
          while (!done) {
            int tag = input.readTag();
            switch (tag) {
              case 0:
                done = true;
                break;
              case 9:
                {
                  if (!((mutable_bitField0_ & 0x00000001) != 0)) {
                    values_ = newDoubleList();
                    mutable_bitField0_ |= 0x00000001;
                  }
                  values_.addDouble(input.readDouble());
                  break;
                }
              case 10:
                {
                  int length = input.readRawVarint32();
                  int limit = input.pushLimit(length);
                  if (!((mutable_bitField0_ & 0x00000001) != 0) && input.getBytesUntilLimit() > 0) {
                    values_ = newDoubleList();
                    mutable_bitField0_ |= 0x00000001;
                  }
                  while (input.getBytesUntilLimit() > 0) {
                    values_.addDouble(input.readDouble());
                  }
                  input.popLimit(limit);
                  break;
                }
              case 25:
                {
                  bitField0_ |= 0x00000001;
                  defaultValue_ = input.readDouble();
                  break;
                }
              default:
                {
                  if (!parseUnknownField(input, unknownFields, extensionRegistry, tag)) {
                    done = true;
                  }
                  break;
                }
            }
          }
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          throw e.setUnfinishedMessage(this);
        } catch (java.io.IOException e) {
          throw new com.google.protobuf.InvalidProtocolBufferException(e)
              .setUnfinishedMessage(this);
        } finally {
          if (((mutable_bitField0_ & 0x00000001) != 0)) {
            values_.makeImmutable(); // C
          }
          this.unknownFields = unknownFields.build();
          makeExtensionsImmutable();
        }
      }

      public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
        return com.google.cloud.aiplatform.v1beta1.StudyProto
            .internal_static_google_cloud_aiplatform_v1beta1_StudySpec_ParameterSpec_DiscreteValueSpec_descriptor;
      }

      @java.lang.Override
      protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return com.google.cloud.aiplatform.v1beta1.StudyProto
            .internal_static_google_cloud_aiplatform_v1beta1_StudySpec_ParameterSpec_DiscreteValueSpec_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                com.google.cloud.aiplatform.v1beta1.StudySpec.ParameterSpec.DiscreteValueSpec.class,
                com.google.cloud.aiplatform.v1beta1.StudySpec.ParameterSpec.DiscreteValueSpec
                    .Builder.class);
      }

      private int bitField0_;
      public static final int VALUES_FIELD_NUMBER = 1;
      private com.google.protobuf.Internal.DoubleList values_;
      /**
       *
       *
       * <pre>
       * Required. A list of possible values.
       * The list should be in increasing order and at least 1e-10 apart.
       * For instance, this parameter might have possible settings of 1.5, 2.5,
       * and 4.0. This list should not contain more than 1,000 values.
       * </pre>
       *
       * <code>repeated double values = 1 [(.google.api.field_behavior) = REQUIRED];</code>
       *
       * @return A list containing the values.
       */
      @java.lang.Override
      public java.util.List<java.lang.Double> getValuesList() {
        return values_;
      }
      /**
       *
       *
       * <pre>
       * Required. A list of possible values.
       * The list should be in increasing order and at least 1e-10 apart.
       * For instance, this parameter might have possible settings of 1.5, 2.5,
       * and 4.0. This list should not contain more than 1,000 values.
       * </pre>
       *
       * <code>repeated double values = 1 [(.google.api.field_behavior) = REQUIRED];</code>
       *
       * @return The count of values.
       */
      public int getValuesCount() {
        return values_.size();
      }
      /**
       *
       *
       * <pre>
       * Required. A list of possible values.
       * The list should be in increasing order and at least 1e-10 apart.
       * For instance, this parameter might have possible settings of 1.5, 2.5,
       * and 4.0. This list should not contain more than 1,000 values.
       * </pre>
       *
       * <code>repeated double values = 1 [(.google.api.field_behavior) = REQUIRED];</code>
       *
       * @param index The index of the element to return.
       * @return The values at the given index.
       */
      public double getValues(int index) {
        return values_.getDouble(index);
      }

      private int valuesMemoizedSerializedSize = -1;

      public static final int DEFAULT_VALUE_FIELD_NUMBER = 3;
      private double defaultValue_;
      /**
       *
       *
       * <pre>
       * A default value for a `DISCRETE` parameter that is assumed to be a
       * relatively good starting point.  Unset value signals that there is no
       * offered starting point.  It automatically rounds to the
       * nearest feasible discrete point.
       * Currently only supported by the Vizier service. Not supported by
       * HyperparamterTuningJob or TrainingPipeline.
       * </pre>
       *
       * <code>double default_value = 3;</code>
       *
       * @return Whether the defaultValue field is set.
       */
      @java.lang.Override
      public boolean hasDefaultValue() {
        return ((bitField0_ & 0x00000001) != 0);
      }
      /**
       *
       *
       * <pre>
       * A default value for a `DISCRETE` parameter that is assumed to be a
       * relatively good starting point.  Unset value signals that there is no
       * offered starting point.  It automatically rounds to the
       * nearest feasible discrete point.
       * Currently only supported by the Vizier service. Not supported by
       * HyperparamterTuningJob or TrainingPipeline.
       * </pre>
       *
       * <code>double default_value = 3;</code>
       *
       * @return The defaultValue.
       */
      @java.lang.Override
      public double getDefaultValue() {
        return defaultValue_;
      }

      private byte memoizedIsInitialized = -1;

      @java.lang.Override
      public final boolean isInitialized() {
        byte isInitialized = memoizedIsInitialized;
        if (isInitialized == 1) return true;
        if (isInitialized == 0) return false;

        memoizedIsInitialized = 1;
        return true;
      }

      @java.lang.Override
      public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
        getSerializedSize();
        if (getValuesList().size() > 0) {
          output.writeUInt32NoTag(10);
          output.writeUInt32NoTag(valuesMemoizedSerializedSize);
        }
        for (int i = 0; i < values_.size(); i++) {
          output.writeDoubleNoTag(values_.getDouble(i));
        }
        if (((bitField0_ & 0x00000001) != 0)) {
          output.writeDouble(3, defaultValue_);
        }
        unknownFields.writeTo(output);
      }

      @java.lang.Override
      public int getSerializedSize() {
        int size = memoizedSize;
        if (size != -1) return size;

        size = 0;
        {
          int dataSize = 0;
          dataSize = 8 * getValuesList().size();
          size += dataSize;
          if (!getValuesList().isEmpty()) {
            size += 1;
            size += com.google.protobuf.CodedOutputStream.computeInt32SizeNoTag(dataSize);
          }
          valuesMemoizedSerializedSize = dataSize;
        }
        if (((bitField0_ & 0x00000001) != 0)) {
          size += com.google.protobuf.CodedOutputStream.computeDoubleSize(3, defaultValue_);
        }
        size += unknownFields.getSerializedSize();
        memoizedSize = size;
        return size;
      }

      @java.lang.Override
      public boolean equals(final java.lang.Object obj) {
        if (obj == this) {
          return true;
        }
        if (!(obj
            instanceof
            com.google.cloud.aiplatform.v1beta1.StudySpec.ParameterSpec.DiscreteValueSpec)) {
          return super.equals(obj);
        }
        com.google.cloud.aiplatform.v1beta1.StudySpec.ParameterSpec.DiscreteValueSpec other =
            (com.google.cloud.aiplatform.v1beta1.StudySpec.ParameterSpec.DiscreteValueSpec) obj;

        if (!getValuesList().equals(other.getValuesList())) return false;
        if (hasDefaultValue() != other.hasDefaultValue()) return false;
        if (hasDefaultValue()) {
          if (java.lang.Double.doubleToLongBits(getDefaultValue())
              != java.lang.Double.doubleToLongBits(other.getDefaultValue())) return false;
        }
        if (!unknownFields.equals(other.unknownFields)) return false;
        return true;
      }

      @java.lang.Override
      public int hashCode() {
        if (memoizedHashCode != 0) {
          return memoizedHashCode;
        }
        int hash = 41;
        hash = (19 * hash) + getDescriptor().hashCode();
        if (getValuesCount() > 0) {
          hash = (37 * hash) + VALUES_FIELD_NUMBER;
          hash = (53 * hash) + getValuesList().hashCode();
        }
        if (hasDefaultValue()) {
          hash = (37 * hash) + DEFAULT_VALUE_FIELD_NUMBER;
          hash =
              (53 * hash)
                  + com.google.protobuf.Internal.hashLong(
                      java.lang.Double.doubleToLongBits(getDefaultValue()));
        }
        hash = (29 * hash) + unknownFields.hashCode();
        memoizedHashCode = hash;
        return hash;
      }

      public static com.google.cloud.aiplatform.v1beta1.StudySpec.ParameterSpec.DiscreteValueSpec
          parseFrom(java.nio.ByteBuffer data)
              throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data);
      }

      public static com.google.cloud.aiplatform.v1beta1.StudySpec.ParameterSpec.DiscreteValueSpec
          parseFrom(
              java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data, extensionRegistry);
      }

      public static com.google.cloud.aiplatform.v1beta1.StudySpec.ParameterSpec.DiscreteValueSpec
          parseFrom(com.google.protobuf.ByteString data)
              throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data);
      }

      public static com.google.cloud.aiplatform.v1beta1.StudySpec.ParameterSpec.DiscreteValueSpec
          parseFrom(
              com.google.protobuf.ByteString data,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data, extensionRegistry);
      }

      public static com.google.cloud.aiplatform.v1beta1.StudySpec.ParameterSpec.DiscreteValueSpec
          parseFrom(byte[] data) throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data);
      }

      public static com.google.cloud.aiplatform.v1beta1.StudySpec.ParameterSpec.DiscreteValueSpec
          parseFrom(byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data, extensionRegistry);
      }

      public static com.google.cloud.aiplatform.v1beta1.StudySpec.ParameterSpec.DiscreteValueSpec
          parseFrom(java.io.InputStream input) throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
      }

      public static com.google.cloud.aiplatform.v1beta1.StudySpec.ParameterSpec.DiscreteValueSpec
          parseFrom(
              java.io.InputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
            PARSER, input, extensionRegistry);
      }

      public static com.google.cloud.aiplatform.v1beta1.StudySpec.ParameterSpec.DiscreteValueSpec
          parseDelimitedFrom(java.io.InputStream input) throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
      }

      public static com.google.cloud.aiplatform.v1beta1.StudySpec.ParameterSpec.DiscreteValueSpec
          parseDelimitedFrom(
              java.io.InputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
            PARSER, input, extensionRegistry);
      }

      public static com.google.cloud.aiplatform.v1beta1.StudySpec.ParameterSpec.DiscreteValueSpec
          parseFrom(com.google.protobuf.CodedInputStream input) throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
      }

      public static com.google.cloud.aiplatform.v1beta1.StudySpec.ParameterSpec.DiscreteValueSpec
          parseFrom(
              com.google.protobuf.CodedInputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
            PARSER, input, extensionRegistry);
      }

      @java.lang.Override
      public Builder newBuilderForType() {
        return newBuilder();
      }

      public static Builder newBuilder() {
        return DEFAULT_INSTANCE.toBuilder();
      }

      public static Builder newBuilder(
          com.google.cloud.aiplatform.v1beta1.StudySpec.ParameterSpec.DiscreteValueSpec prototype) {
        return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
      }

      @java.lang.Override
      public Builder toBuilder() {
        return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
      }

      @java.lang.Override
      protected Builder newBuilderForType(
          com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
        Builder builder = new Builder(parent);
        return builder;
      }
      /**
       *
       *
       * <pre>
       * Value specification for a parameter in `DISCRETE` type.
       * </pre>
       *
       * Protobuf type {@code
       * google.cloud.aiplatform.v1beta1.StudySpec.ParameterSpec.DiscreteValueSpec}
       */
      public static final class Builder
          extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
          implements
          // @@protoc_insertion_point(builder_implements:google.cloud.aiplatform.v1beta1.StudySpec.ParameterSpec.DiscreteValueSpec)
          com.google.cloud.aiplatform.v1beta1.StudySpec.ParameterSpec.DiscreteValueSpecOrBuilder {
        public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
          return com.google.cloud.aiplatform.v1beta1.StudyProto
              .internal_static_google_cloud_aiplatform_v1beta1_StudySpec_ParameterSpec_DiscreteValueSpec_descriptor;
        }

        @java.lang.Override
        protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
            internalGetFieldAccessorTable() {
          return com.google.cloud.aiplatform.v1beta1.StudyProto
              .internal_static_google_cloud_aiplatform_v1beta1_StudySpec_ParameterSpec_DiscreteValueSpec_fieldAccessorTable
              .ensureFieldAccessorsInitialized(
                  com.google.cloud.aiplatform.v1beta1.StudySpec.ParameterSpec.DiscreteValueSpec
                      .class,
                  com.google.cloud.aiplatform.v1beta1.StudySpec.ParameterSpec.DiscreteValueSpec
                      .Builder.class);
        }

        // Construct using
        // com.google.cloud.aiplatform.v1beta1.StudySpec.ParameterSpec.DiscreteValueSpec.newBuilder()
        private Builder() {
          maybeForceBuilderInitialization();
        }

        private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
          super(parent);
          maybeForceBuilderInitialization();
        }

        private void maybeForceBuilderInitialization() {
          if (com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders) {}
        }

        @java.lang.Override
        public Builder clear() {
          super.clear();
          values_ = emptyDoubleList();
          bitField0_ = (bitField0_ & ~0x00000001);
          defaultValue_ = 0D;
          bitField0_ = (bitField0_ & ~0x00000002);
          return this;
        }

        @java.lang.Override
        public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
          return com.google.cloud.aiplatform.v1beta1.StudyProto
              .internal_static_google_cloud_aiplatform_v1beta1_StudySpec_ParameterSpec_DiscreteValueSpec_descriptor;
        }

        @java.lang.Override
        public com.google.cloud.aiplatform.v1beta1.StudySpec.ParameterSpec.DiscreteValueSpec
            getDefaultInstanceForType() {
          return com.google.cloud.aiplatform.v1beta1.StudySpec.ParameterSpec.DiscreteValueSpec
              .getDefaultInstance();
        }

        @java.lang.Override
        public com.google.cloud.aiplatform.v1beta1.StudySpec.ParameterSpec.DiscreteValueSpec
            build() {
          com.google.cloud.aiplatform.v1beta1.StudySpec.ParameterSpec.DiscreteValueSpec result =
              buildPartial();
          if (!result.isInitialized()) {
            throw newUninitializedMessageException(result);
          }
          return result;
        }

        @java.lang.Override
        public com.google.cloud.aiplatform.v1beta1.StudySpec.ParameterSpec.DiscreteValueSpec
            buildPartial() {
          com.google.cloud.aiplatform.v1beta1.StudySpec.ParameterSpec.DiscreteValueSpec result =
              new com.google.cloud.aiplatform.v1beta1.StudySpec.ParameterSpec.DiscreteValueSpec(
                  this);
          int from_bitField0_ = bitField0_;
          int to_bitField0_ = 0;
          if (((bitField0_ & 0x00000001) != 0)) {
            values_.makeImmutable();
            bitField0_ = (bitField0_ & ~0x00000001);
          }
          result.values_ = values_;
          if (((from_bitField0_ & 0x00000002) != 0)) {
            result.defaultValue_ = defaultValue_;
            to_bitField0_ |= 0x00000001;
          }
          result.bitField0_ = to_bitField0_;
          onBuilt();
          return result;
        }

        @java.lang.Override
        public Builder clone() {
          return super.clone();
        }

        @java.lang.Override
        public Builder setField(
            com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
          return super.setField(field, value);
        }

        @java.lang.Override
        public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
          return super.clearField(field);
        }

        @java.lang.Override
        public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
          return super.clearOneof(oneof);
        }

        @java.lang.Override
        public Builder setRepeatedField(
            com.google.protobuf.Descriptors.FieldDescriptor field,
            int index,
            java.lang.Object value) {
          return super.setRepeatedField(field, index, value);
        }

        @java.lang.Override
        public Builder addRepeatedField(
            com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
          return super.addRepeatedField(field, value);
        }

        @java.lang.Override
        public Builder mergeFrom(com.google.protobuf.Message other) {
          if (other
              instanceof
              com.google.cloud.aiplatform.v1beta1.StudySpec.ParameterSpec.DiscreteValueSpec) {
            return mergeFrom(
                (com.google.cloud.aiplatform.v1beta1.StudySpec.ParameterSpec.DiscreteValueSpec)
                    other);
          } else {
            super.mergeFrom(other);
            return this;
          }
        }

        public Builder mergeFrom(
            com.google.cloud.aiplatform.v1beta1.StudySpec.ParameterSpec.DiscreteValueSpec other) {
          if (other
              == com.google.cloud.aiplatform.v1beta1.StudySpec.ParameterSpec.DiscreteValueSpec
                  .getDefaultInstance()) return this;
          if (!other.values_.isEmpty()) {
            if (values_.isEmpty()) {
              values_ = other.values_;
              bitField0_ = (bitField0_ & ~0x00000001);
            } else {
              ensureValuesIsMutable();
              values_.addAll(other.values_);
            }
            onChanged();
          }
          if (other.hasDefaultValue()) {
            setDefaultValue(other.getDefaultValue());
          }
          this.mergeUnknownFields(other.unknownFields);
          onChanged();
          return this;
        }

        @java.lang.Override
        public final boolean isInitialized() {
          return true;
        }

        @java.lang.Override
        public Builder mergeFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws java.io.IOException {
          com.google.cloud.aiplatform.v1beta1.StudySpec.ParameterSpec.DiscreteValueSpec
              parsedMessage = null;
          try {
            parsedMessage = PARSER.parsePartialFrom(input, extensionRegistry);
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            parsedMessage =
                (com.google.cloud.aiplatform.v1beta1.StudySpec.ParameterSpec.DiscreteValueSpec)
                    e.getUnfinishedMessage();
            throw e.unwrapIOException();
          } finally {
            if (parsedMessage != null) {
              mergeFrom(parsedMessage);
            }
          }
          return this;
        }

        private int bitField0_;

        private com.google.protobuf.Internal.DoubleList values_ = emptyDoubleList();

        private void ensureValuesIsMutable() {
          if (!((bitField0_ & 0x00000001) != 0)) {
            values_ = mutableCopy(values_);
            bitField0_ |= 0x00000001;
          }
        }
        /**
         *
         *
         * <pre>
         * Required. A list of possible values.
         * The list should be in increasing order and at least 1e-10 apart.
         * For instance, this parameter might have possible settings of 1.5, 2.5,
         * and 4.0. This list should not contain more than 1,000 values.
         * </pre>
         *
         * <code>repeated double values = 1 [(.google.api.field_behavior) = REQUIRED];</code>
         *
         * @return A list containing the values.
         */
        public java.util.List<java.lang.Double> getValuesList() {
          return ((bitField0_ & 0x00000001) != 0)
              ? java.util.Collections.unmodifiableList(values_)
              : values_;
        }
        /**
         *
         *
         * <pre>
         * Required. A list of possible values.
         * The list should be in increasing order and at least 1e-10 apart.
         * For instance, this parameter might have possible settings of 1.5, 2.5,
         * and 4.0. This list should not contain more than 1,000 values.
         * </pre>
         *
         * <code>repeated double values = 1 [(.google.api.field_behavior) = REQUIRED];</code>
         *
         * @return The count of values.
         */
        public int getValuesCount() {
          return values_.size();
        }
        /**
         *
         *
         * <pre>
         * Required. A list of possible values.
         * The list should be in increasing order and at least 1e-10 apart.
         * For instance, this parameter might have possible settings of 1.5, 2.5,
         * and 4.0. This list should not contain more than 1,000 values.
         * </pre>
         *
         * <code>repeated double values = 1 [(.google.api.field_behavior) = REQUIRED];</code>
         *
         * @param index The index of the element to return.
         * @return The values at the given index.
         */
        public double getValues(int index) {
          return values_.getDouble(index);
        }
        /**
         *
         *
         * <pre>
         * Required. A list of possible values.
         * The list should be in increasing order and at least 1e-10 apart.
         * For instance, this parameter might have possible settings of 1.5, 2.5,
         * and 4.0. This list should not contain more than 1,000 values.
         * </pre>
         *
         * <code>repeated double values = 1 [(.google.api.field_behavior) = REQUIRED];</code>
         *
         * @param index The index to set the value at.
         * @param value The values to set.
         * @return This builder for chaining.
         */
        public Builder setValues(int index, double value) {
          ensureValuesIsMutable();
          values_.setDouble(index, value);
          onChanged();
          return this;
        }
        /**
         *
         *
         * <pre>
         * Required. A list of possible values.
         * The list should be in increasing order and at least 1e-10 apart.
         * For instance, this parameter might have possible settings of 1.5, 2.5,
         * and 4.0. This list should not contain more than 1,000 values.
         * </pre>
         *
         * <code>repeated double values = 1 [(.google.api.field_behavior) = REQUIRED];</code>
         *
         * @param value The values to add.
         * @return This builder for chaining.
         */
        public Builder addValues(double value) {
          ensureValuesIsMutable();
          values_.addDouble(value);
          onChanged();
          return this;
        }
        /**
         *
         *
         * <pre>
         * Required. A list of possible values.
         * The list should be in increasing order and at least 1e-10 apart.
         * For instance, this parameter might have possible settings of 1.5, 2.5,
         * and 4.0. This list should not contain more than 1,000 values.
         * </pre>
         *
         * <code>repeated double values = 1 [(.google.api.field_behavior) = REQUIRED];</code>
         *
         * @param values The values to add.
         * @return This builder for chaining.
         */
        public Builder addAllValues(java.lang.Iterable<? extends java.lang.Double> values) {
          ensureValuesIsMutable();
          com.google.protobuf.AbstractMessageLite.Builder.addAll(values, values_);
          onChanged();
          return this;
        }
        /**
         *
         *
         * <pre>
         * Required. A list of possible values.
         * The list should be in increasing order and at least 1e-10 apart.
         * For instance, this parameter might have possible settings of 1.5, 2.5,
         * and 4.0. This list should not contain more than 1,000 values.
         * </pre>
         *
         * <code>repeated double values = 1 [(.google.api.field_behavior) = REQUIRED];</code>
         *
         * @return This builder for chaining.
         */
        public Builder clearValues() {
          values_ = emptyDoubleList();
          bitField0_ = (bitField0_ & ~0x00000001);
          onChanged();
          return this;
        }

        private double defaultValue_;
        /**
         *
         *
         * <pre>
         * A default value for a `DISCRETE` parameter that is assumed to be a
         * relatively good starting point.  Unset value signals that there is no
         * offered starting point.  It automatically rounds to the
         * nearest feasible discrete point.
         * Currently only supported by the Vizier service. Not supported by
         * HyperparamterTuningJob or TrainingPipeline.
         * </pre>
         *
         * <code>double default_value = 3;</code>
         *
         * @return Whether the defaultValue field is set.
         */
        @java.lang.Override
        public boolean hasDefaultValue() {
          return ((bitField0_ & 0x00000002) != 0);
        }
        /**
         *
         *
         * <pre>
         * A default value for a `DISCRETE` parameter that is assumed to be a
         * relatively good starting point.  Unset value signals that there is no
         * offered starting point.  It automatically rounds to the
         * nearest feasible discrete point.
         * Currently only supported by the Vizier service. Not supported by
         * HyperparamterTuningJob or TrainingPipeline.
         * </pre>
         *
         * <code>double default_value = 3;</code>
         *
         * @return The defaultValue.
         */
        @java.lang.Override
        public double getDefaultValue() {
          return defaultValue_;
        }
        /**
         *
         *
         * <pre>
         * A default value for a `DISCRETE` parameter that is assumed to be a
         * relatively good starting point.  Unset value signals that there is no
         * offered starting point.  It automatically rounds to the
         * nearest feasible discrete point.
         * Currently only supported by the Vizier service. Not supported by
         * HyperparamterTuningJob or TrainingPipeline.
         * </pre>
         *
         * <code>double default_value = 3;</code>
         *
         * @param value The defaultValue to set.
         * @return This builder for chaining.
         */
        public Builder setDefaultValue(double value) {
          bitField0_ |= 0x00000002;
          defaultValue_ = value;
          onChanged();
          return this;
        }
        /**
         *
         *
         * <pre>
         * A default value for a `DISCRETE` parameter that is assumed to be a
         * relatively good starting point.  Unset value signals that there is no
         * offered starting point.  It automatically rounds to the
         * nearest feasible discrete point.
         * Currently only supported by the Vizier service. Not supported by
         * HyperparamterTuningJob or TrainingPipeline.
         * </pre>
         *
         * <code>double default_value = 3;</code>
         *
         * @return This builder for chaining.
         */
        public Builder clearDefaultValue() {
          bitField0_ = (bitField0_ & ~0x00000002);
          defaultValue_ = 0D;
          onChanged();
          return this;
        }

        @java.lang.Override
        public final Builder setUnknownFields(
            final com.google.protobuf.UnknownFieldSet unknownFields) {
          return super.setUnknownFields(unknownFields);
        }

        @java.lang.Override
        public final Builder mergeUnknownFields(
            final com.google.protobuf.UnknownFieldSet unknownFields) {
          return super.mergeUnknownFields(unknownFields);
        }

        // @@protoc_insertion_point(builder_scope:google.cloud.aiplatform.v1beta1.StudySpec.ParameterSpec.DiscreteValueSpec)
      }

      // @@protoc_insertion_point(class_scope:google.cloud.aiplatform.v1beta1.StudySpec.ParameterSpec.DiscreteValueSpec)
      private static final com.google.cloud.aiplatform.v1beta1.StudySpec.ParameterSpec
              .DiscreteValueSpec
          DEFAULT_INSTANCE;

      static {
        DEFAULT_INSTANCE =
            new com.google.cloud.aiplatform.v1beta1.StudySpec.ParameterSpec.DiscreteValueSpec();
      }

      public static com.google.cloud.aiplatform.v1beta1.StudySpec.ParameterSpec.DiscreteValueSpec
          getDefaultInstance() {
        return DEFAULT_INSTANCE;
      }

      private static final com.google.protobuf.Parser<DiscreteValueSpec> PARSER =
          new com.google.protobuf.AbstractParser<DiscreteValueSpec>() {
            @java.lang.Override
            public DiscreteValueSpec parsePartialFrom(
                com.google.protobuf.CodedInputStream input,
                com.google.protobuf.ExtensionRegistryLite extensionRegistry)
                throws com.google.protobuf.InvalidProtocolBufferException {
              return new DiscreteValueSpec(input, extensionRegistry);
            }
          };

      public static com.google.protobuf.Parser<DiscreteValueSpec> parser() {
        return PARSER;
      }

      @java.lang.Override
      public com.google.protobuf.Parser<DiscreteValueSpec> getParserForType() {
        return PARSER;
      }

      @java.lang.Override
      public com.google.cloud.aiplatform.v1beta1.StudySpec.ParameterSpec.DiscreteValueSpec
          getDefaultInstanceForType() {
        return DEFAULT_INSTANCE;
      }
    }

    public interface ConditionalParameterSpecOrBuilder
        extends
        // @@protoc_insertion_point(interface_extends:google.cloud.aiplatform.v1beta1.StudySpec.ParameterSpec.ConditionalParameterSpec)
        com.google.protobuf.MessageOrBuilder {

      /**
       *
       *
       * <pre>
       * The spec for matching values from a parent parameter of
       * `DISCRETE` type.
       * </pre>
       *
       * <code>
       * .google.cloud.aiplatform.v1beta1.StudySpec.ParameterSpec.ConditionalParameterSpec.DiscreteValueCondition parent_discrete_values = 2;
       * </code>
       *
       * @return Whether the parentDiscreteValues field is set.
       */
      boolean hasParentDiscreteValues();
      /**
       *
       *
       * <pre>
       * The spec for matching values from a parent parameter of
       * `DISCRETE` type.
       * </pre>
       *
       * <code>
       * .google.cloud.aiplatform.v1beta1.StudySpec.ParameterSpec.ConditionalParameterSpec.DiscreteValueCondition parent_discrete_values = 2;
       * </code>
       *
       * @return The parentDiscreteValues.
       */
      com.google.cloud.aiplatform.v1beta1.StudySpec.ParameterSpec.ConditionalParameterSpec
              .DiscreteValueCondition
          getParentDiscreteValues();
      /**
       *
       *
       * <pre>
       * The spec for matching values from a parent parameter of
       * `DISCRETE` type.
       * </pre>
       *
       * <code>
       * .google.cloud.aiplatform.v1beta1.StudySpec.ParameterSpec.ConditionalParameterSpec.DiscreteValueCondition parent_discrete_values = 2;
       * </code>
       */
      com.google.cloud.aiplatform.v1beta1.StudySpec.ParameterSpec.ConditionalParameterSpec
              .DiscreteValueConditionOrBuilder
          getParentDiscreteValuesOrBuilder();

      /**
       *
       *
       * <pre>
       * The spec for matching values from a parent parameter of `INTEGER`
       * type.
       * </pre>
       *
       * <code>
       * .google.cloud.aiplatform.v1beta1.StudySpec.ParameterSpec.ConditionalParameterSpec.IntValueCondition parent_int_values = 3;
       * </code>
       *
       * @return Whether the parentIntValues field is set.
       */
      boolean hasParentIntValues();
      /**
       *
       *
       * <pre>
       * The spec for matching values from a parent parameter of `INTEGER`
       * type.
       * </pre>
       *
       * <code>
       * .google.cloud.aiplatform.v1beta1.StudySpec.ParameterSpec.ConditionalParameterSpec.IntValueCondition parent_int_values = 3;
       * </code>
       *
       * @return The parentIntValues.
       */
      com.google.cloud.aiplatform.v1beta1.StudySpec.ParameterSpec.ConditionalParameterSpec
              .IntValueCondition
          getParentIntValues();
      /**
       *
       *
       * <pre>
       * The spec for matching values from a parent parameter of `INTEGER`
       * type.
       * </pre>
       *
       * <code>
       * .google.cloud.aiplatform.v1beta1.StudySpec.ParameterSpec.ConditionalParameterSpec.IntValueCondition parent_int_values = 3;
       * </code>
       */
      com.google.cloud.aiplatform.v1beta1.StudySpec.ParameterSpec.ConditionalParameterSpec
              .IntValueConditionOrBuilder
          getParentIntValuesOrBuilder();

      /**
       *
       *
       * <pre>
       * The spec for matching values from a parent parameter of
       * `CATEGORICAL` type.
       * </pre>
       *
       * <code>
       * .google.cloud.aiplatform.v1beta1.StudySpec.ParameterSpec.ConditionalParameterSpec.CategoricalValueCondition parent_categorical_values = 4;
       * </code>
       *
       * @return Whether the parentCategoricalValues field is set.
       */
      boolean hasParentCategoricalValues();
      /**
       *
       *
       * <pre>
       * The spec for matching values from a parent parameter of
       * `CATEGORICAL` type.
       * </pre>
       *
       * <code>
       * .google.cloud.aiplatform.v1beta1.StudySpec.ParameterSpec.ConditionalParameterSpec.CategoricalValueCondition parent_categorical_values = 4;
       * </code>
       *
       * @return The parentCategoricalValues.
       */
      com.google.cloud.aiplatform.v1beta1.StudySpec.ParameterSpec.ConditionalParameterSpec
              .CategoricalValueCondition
          getParentCategoricalValues();
      /**
       *
       *
       * <pre>
       * The spec for matching values from a parent parameter of
       * `CATEGORICAL` type.
       * </pre>
       *
       * <code>
       * .google.cloud.aiplatform.v1beta1.StudySpec.ParameterSpec.ConditionalParameterSpec.CategoricalValueCondition parent_categorical_values = 4;
       * </code>
       */
      com.google.cloud.aiplatform.v1beta1.StudySpec.ParameterSpec.ConditionalParameterSpec
              .CategoricalValueConditionOrBuilder
          getParentCategoricalValuesOrBuilder();

      /**
       *
       *
       * <pre>
       * Required. The spec for a conditional parameter.
       * </pre>
       *
       * <code>
       * .google.cloud.aiplatform.v1beta1.StudySpec.ParameterSpec parameter_spec = 1 [(.google.api.field_behavior) = REQUIRED];
       * </code>
       *
       * @return Whether the parameterSpec field is set.
       */
      boolean hasParameterSpec();
      /**
       *
       *
       * <pre>
       * Required. The spec for a conditional parameter.
       * </pre>
       *
       * <code>
       * .google.cloud.aiplatform.v1beta1.StudySpec.ParameterSpec parameter_spec = 1 [(.google.api.field_behavior) = REQUIRED];
       * </code>
       *
       * @return The parameterSpec.
       */
      com.google.cloud.aiplatform.v1beta1.StudySpec.ParameterSpec getParameterSpec();
      /**
       *
       *
       * <pre>
       * Required. The spec for a conditional parameter.
       * </pre>
       *
       * <code>
       * .google.cloud.aiplatform.v1beta1.StudySpec.ParameterSpec parameter_spec = 1 [(.google.api.field_behavior) = REQUIRED];
       * </code>
       */
      com.google.cloud.aiplatform.v1beta1.StudySpec.ParameterSpecOrBuilder
          getParameterSpecOrBuilder();

      public com.google.cloud.aiplatform.v1beta1.StudySpec.ParameterSpec.ConditionalParameterSpec
              .ParentValueConditionCase
          getParentValueConditionCase();
    }
    /**
     *
     *
     * <pre>
     * Represents a parameter spec with condition from its parent parameter.
     * </pre>
     *
     * Protobuf type {@code
     * google.cloud.aiplatform.v1beta1.StudySpec.ParameterSpec.ConditionalParameterSpec}
     */
    public static final class ConditionalParameterSpec
        extends com.google.protobuf.GeneratedMessageV3
        implements
        // @@protoc_insertion_point(message_implements:google.cloud.aiplatform.v1beta1.StudySpec.ParameterSpec.ConditionalParameterSpec)
        ConditionalParameterSpecOrBuilder {
      private static final long serialVersionUID = 0L;
      // Use ConditionalParameterSpec.newBuilder() to construct.
      private ConditionalParameterSpec(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
        super(builder);
      }

      private ConditionalParameterSpec() {}

      @java.lang.Override
      @SuppressWarnings({"unused"})
      protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
        return new ConditionalParameterSpec();
      }

      @java.lang.Override
      public final com.google.protobuf.UnknownFieldSet getUnknownFields() {
        return this.unknownFields;
      }

      private ConditionalParameterSpec(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws com.google.protobuf.InvalidProtocolBufferException {
        this();
        if (extensionRegistry == null) {
          throw new java.lang.NullPointerException();
        }
        com.google.protobuf.UnknownFieldSet.Builder unknownFields =
            com.google.protobuf.UnknownFieldSet.newBuilder();
        try {
          boolean done = false;
          while (!done) {
            int tag = input.readTag();
            switch (tag) {
              case 0:
                done = true;
                break;
              case 10:
                {
                  com.google.cloud.aiplatform.v1beta1.StudySpec.ParameterSpec.Builder subBuilder =
                      null;
                  if (parameterSpec_ != null) {
                    subBuilder = parameterSpec_.toBuilder();
                  }
                  parameterSpec_ =
                      input.readMessage(
                          com.google.cloud.aiplatform.v1beta1.StudySpec.ParameterSpec.parser(),
                          extensionRegistry);
                  if (subBuilder != null) {
                    subBuilder.mergeFrom(parameterSpec_);
                    parameterSpec_ = subBuilder.buildPartial();
                  }

                  break;
                }
              case 18:
                {
                  com.google.cloud.aiplatform.v1beta1.StudySpec.ParameterSpec
                          .ConditionalParameterSpec.DiscreteValueCondition.Builder
                      subBuilder = null;
                  if (parentValueConditionCase_ == 2) {
                    subBuilder =
                        ((com.google.cloud.aiplatform.v1beta1.StudySpec.ParameterSpec
                                    .ConditionalParameterSpec.DiscreteValueCondition)
                                parentValueCondition_)
                            .toBuilder();
                  }
                  parentValueCondition_ =
                      input.readMessage(
                          com.google.cloud.aiplatform.v1beta1.StudySpec.ParameterSpec
                              .ConditionalParameterSpec.DiscreteValueCondition.parser(),
                          extensionRegistry);
                  if (subBuilder != null) {
                    subBuilder.mergeFrom(
                        (com.google.cloud.aiplatform.v1beta1.StudySpec.ParameterSpec
                                .ConditionalParameterSpec.DiscreteValueCondition)
                            parentValueCondition_);
                    parentValueCondition_ = subBuilder.buildPartial();
                  }
                  parentValueConditionCase_ = 2;
                  break;
                }
              case 26:
                {
                  com.google.cloud.aiplatform.v1beta1.StudySpec.ParameterSpec
                          .ConditionalParameterSpec.IntValueCondition.Builder
                      subBuilder = null;
                  if (parentValueConditionCase_ == 3) {
                    subBuilder =
                        ((com.google.cloud.aiplatform.v1beta1.StudySpec.ParameterSpec
                                    .ConditionalParameterSpec.IntValueCondition)
                                parentValueCondition_)
                            .toBuilder();
                  }
                  parentValueCondition_ =
                      input.readMessage(
                          com.google.cloud.aiplatform.v1beta1.StudySpec.ParameterSpec
                              .ConditionalParameterSpec.IntValueCondition.parser(),
                          extensionRegistry);
                  if (subBuilder != null) {
                    subBuilder.mergeFrom(
                        (com.google.cloud.aiplatform.v1beta1.StudySpec.ParameterSpec
                                .ConditionalParameterSpec.IntValueCondition)
                            parentValueCondition_);
                    parentValueCondition_ = subBuilder.buildPartial();
                  }
                  parentValueConditionCase_ = 3;
                  break;
                }
              case 34:
                {
                  com.google.cloud.aiplatform.v1beta1.StudySpec.ParameterSpec
                          .ConditionalParameterSpec.CategoricalValueCondition.Builder
                      subBuilder = null;
                  if (parentValueConditionCase_ == 4) {
                    subBuilder =
                        ((com.google.cloud.aiplatform.v1beta1.StudySpec.ParameterSpec
                                    .ConditionalParameterSpec.CategoricalValueCondition)
                                parentValueCondition_)
                            .toBuilder();
                  }
                  parentValueCondition_ =
                      input.readMessage(
                          com.google.cloud.aiplatform.v1beta1.StudySpec.ParameterSpec
                              .ConditionalParameterSpec.CategoricalValueCondition.parser(),
                          extensionRegistry);
                  if (subBuilder != null) {
                    subBuilder.mergeFrom(
                        (com.google.cloud.aiplatform.v1beta1.StudySpec.ParameterSpec
                                .ConditionalParameterSpec.CategoricalValueCondition)
                            parentValueCondition_);
                    parentValueCondition_ = subBuilder.buildPartial();
                  }
                  parentValueConditionCase_ = 4;
                  break;
                }
              default:
                {
                  if (!parseUnknownField(input, unknownFields, extensionRegistry, tag)) {
                    done = true;
                  }
                  break;
                }
            }
          }
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          throw e.setUnfinishedMessage(this);
        } catch (java.io.IOException e) {
          throw new com.google.protobuf.InvalidProtocolBufferException(e)
              .setUnfinishedMessage(this);
        } finally {
          this.unknownFields = unknownFields.build();
          makeExtensionsImmutable();
        }
      }

      public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
        return com.google.cloud.aiplatform.v1beta1.StudyProto
            .internal_static_google_cloud_aiplatform_v1beta1_StudySpec_ParameterSpec_ConditionalParameterSpec_descriptor;
      }

      @java.lang.Override
      protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return com.google.cloud.aiplatform.v1beta1.StudyProto
            .internal_static_google_cloud_aiplatform_v1beta1_StudySpec_ParameterSpec_ConditionalParameterSpec_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                com.google.cloud.aiplatform.v1beta1.StudySpec.ParameterSpec.ConditionalParameterSpec
                    .class,
                com.google.cloud.aiplatform.v1beta1.StudySpec.ParameterSpec.ConditionalParameterSpec
                    .Builder.class);
      }

      public interface DiscreteValueConditionOrBuilder
          extends
          // @@protoc_insertion_point(interface_extends:google.cloud.aiplatform.v1beta1.StudySpec.ParameterSpec.ConditionalParameterSpec.DiscreteValueCondition)
          com.google.protobuf.MessageOrBuilder {

        /**
         *
         *
         * <pre>
         * Required. Matches values of the parent parameter of 'DISCRETE' type.
         * All values must exist in `discrete_value_spec` of parent parameter.
         * The Epsilon of the value matching is 1e-10.
         * </pre>
         *
         * <code>repeated double values = 1 [(.google.api.field_behavior) = REQUIRED];</code>
         *
         * @return A list containing the values.
         */
        java.util.List<java.lang.Double> getValuesList();
        /**
         *
         *
         * <pre>
         * Required. Matches values of the parent parameter of 'DISCRETE' type.
         * All values must exist in `discrete_value_spec` of parent parameter.
         * The Epsilon of the value matching is 1e-10.
         * </pre>
         *
         * <code>repeated double values = 1 [(.google.api.field_behavior) = REQUIRED];</code>
         *
         * @return The count of values.
         */
        int getValuesCount();
        /**
         *
         *
         * <pre>
         * Required. Matches values of the parent parameter of 'DISCRETE' type.
         * All values must exist in `discrete_value_spec` of parent parameter.
         * The Epsilon of the value matching is 1e-10.
         * </pre>
         *
         * <code>repeated double values = 1 [(.google.api.field_behavior) = REQUIRED];</code>
         *
         * @param index The index of the element to return.
         * @return The values at the given index.
         */
        double getValues(int index);
      }
      /**
       *
       *
       * <pre>
       * Represents the spec to match discrete values from parent parameter.
       * </pre>
       *
       * Protobuf type {@code
       * google.cloud.aiplatform.v1beta1.StudySpec.ParameterSpec.ConditionalParameterSpec.DiscreteValueCondition}
       */
      public static final class DiscreteValueCondition
          extends com.google.protobuf.GeneratedMessageV3
          implements
          // @@protoc_insertion_point(message_implements:google.cloud.aiplatform.v1beta1.StudySpec.ParameterSpec.ConditionalParameterSpec.DiscreteValueCondition)
          DiscreteValueConditionOrBuilder {
        private static final long serialVersionUID = 0L;
        // Use DiscreteValueCondition.newBuilder() to construct.
        private DiscreteValueCondition(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
          super(builder);
        }

        private DiscreteValueCondition() {
          values_ = emptyDoubleList();
        }

        @java.lang.Override
        @SuppressWarnings({"unused"})
        protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
          return new DiscreteValueCondition();
        }

        @java.lang.Override
        public final com.google.protobuf.UnknownFieldSet getUnknownFields() {
          return this.unknownFields;
        }

        private DiscreteValueCondition(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          this();
          if (extensionRegistry == null) {
            throw new java.lang.NullPointerException();
          }
          int mutable_bitField0_ = 0;
          com.google.protobuf.UnknownFieldSet.Builder unknownFields =
              com.google.protobuf.UnknownFieldSet.newBuilder();
          try {
            boolean done = false;
            while (!done) {
              int tag = input.readTag();
              switch (tag) {
                case 0:
                  done = true;
                  break;
                case 9:
                  {
                    if (!((mutable_bitField0_ & 0x00000001) != 0)) {
                      values_ = newDoubleList();
                      mutable_bitField0_ |= 0x00000001;
                    }
                    values_.addDouble(input.readDouble());
                    break;
                  }
                case 10:
                  {
                    int length = input.readRawVarint32();
                    int limit = input.pushLimit(length);
                    if (!((mutable_bitField0_ & 0x00000001) != 0)
                        && input.getBytesUntilLimit() > 0) {
                      values_ = newDoubleList();
                      mutable_bitField0_ |= 0x00000001;
                    }
                    while (input.getBytesUntilLimit() > 0) {
                      values_.addDouble(input.readDouble());
                    }
                    input.popLimit(limit);
                    break;
                  }
                default:
                  {
                    if (!parseUnknownField(input, unknownFields, extensionRegistry, tag)) {
                      done = true;
                    }
                    break;
                  }
              }
            }
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.setUnfinishedMessage(this);
          } catch (java.io.IOException e) {
            throw new com.google.protobuf.InvalidProtocolBufferException(e)
                .setUnfinishedMessage(this);
          } finally {
            if (((mutable_bitField0_ & 0x00000001) != 0)) {
              values_.makeImmutable(); // C
            }
            this.unknownFields = unknownFields.build();
            makeExtensionsImmutable();
          }
        }

        public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
          return com.google.cloud.aiplatform.v1beta1.StudyProto
              .internal_static_google_cloud_aiplatform_v1beta1_StudySpec_ParameterSpec_ConditionalParameterSpec_DiscreteValueCondition_descriptor;
        }

        @java.lang.Override
        protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
            internalGetFieldAccessorTable() {
          return com.google.cloud.aiplatform.v1beta1.StudyProto
              .internal_static_google_cloud_aiplatform_v1beta1_StudySpec_ParameterSpec_ConditionalParameterSpec_DiscreteValueCondition_fieldAccessorTable
              .ensureFieldAccessorsInitialized(
                  com.google.cloud.aiplatform.v1beta1.StudySpec.ParameterSpec
                      .ConditionalParameterSpec.DiscreteValueCondition.class,
                  com.google.cloud.aiplatform.v1beta1.StudySpec.ParameterSpec
                      .ConditionalParameterSpec.DiscreteValueCondition.Builder.class);
        }

        public static final int VALUES_FIELD_NUMBER = 1;
        private com.google.protobuf.Internal.DoubleList values_;
        /**
         *
         *
         * <pre>
         * Required. Matches values of the parent parameter of 'DISCRETE' type.
         * All values must exist in `discrete_value_spec` of parent parameter.
         * The Epsilon of the value matching is 1e-10.
         * </pre>
         *
         * <code>repeated double values = 1 [(.google.api.field_behavior) = REQUIRED];</code>
         *
         * @return A list containing the values.
         */
        @java.lang.Override
        public java.util.List<java.lang.Double> getValuesList() {
          return values_;
        }
        /**
         *
         *
         * <pre>
         * Required. Matches values of the parent parameter of 'DISCRETE' type.
         * All values must exist in `discrete_value_spec` of parent parameter.
         * The Epsilon of the value matching is 1e-10.
         * </pre>
         *
         * <code>repeated double values = 1 [(.google.api.field_behavior) = REQUIRED];</code>
         *
         * @return The count of values.
         */
        public int getValuesCount() {
          return values_.size();
        }
        /**
         *
         *
         * <pre>
         * Required. Matches values of the parent parameter of 'DISCRETE' type.
         * All values must exist in `discrete_value_spec` of parent parameter.
         * The Epsilon of the value matching is 1e-10.
         * </pre>
         *
         * <code>repeated double values = 1 [(.google.api.field_behavior) = REQUIRED];</code>
         *
         * @param index The index of the element to return.
         * @return The values at the given index.
         */
        public double getValues(int index) {
          return values_.getDouble(index);
        }

        private int valuesMemoizedSerializedSize = -1;

        private byte memoizedIsInitialized = -1;

        @java.lang.Override
        public final boolean isInitialized() {
          byte isInitialized = memoizedIsInitialized;
          if (isInitialized == 1) return true;
          if (isInitialized == 0) return false;

          memoizedIsInitialized = 1;
          return true;
        }

        @java.lang.Override
        public void writeTo(com.google.protobuf.CodedOutputStream output)
            throws java.io.IOException {
          getSerializedSize();
          if (getValuesList().size() > 0) {
            output.writeUInt32NoTag(10);
            output.writeUInt32NoTag(valuesMemoizedSerializedSize);
          }
          for (int i = 0; i < values_.size(); i++) {
            output.writeDoubleNoTag(values_.getDouble(i));
          }
          unknownFields.writeTo(output);
        }

        @java.lang.Override
        public int getSerializedSize() {
          int size = memoizedSize;
          if (size != -1) return size;

          size = 0;
          {
            int dataSize = 0;
            dataSize = 8 * getValuesList().size();
            size += dataSize;
            if (!getValuesList().isEmpty()) {
              size += 1;
              size += com.google.protobuf.CodedOutputStream.computeInt32SizeNoTag(dataSize);
            }
            valuesMemoizedSerializedSize = dataSize;
          }
          size += unknownFields.getSerializedSize();
          memoizedSize = size;
          return size;
        }

        @java.lang.Override
        public boolean equals(final java.lang.Object obj) {
          if (obj == this) {
            return true;
          }
          if (!(obj
              instanceof
              com.google.cloud.aiplatform.v1beta1.StudySpec.ParameterSpec.ConditionalParameterSpec
                  .DiscreteValueCondition)) {
            return super.equals(obj);
          }
          com.google.cloud.aiplatform.v1beta1.StudySpec.ParameterSpec.ConditionalParameterSpec
                  .DiscreteValueCondition
              other =
                  (com.google.cloud.aiplatform.v1beta1.StudySpec.ParameterSpec
                          .ConditionalParameterSpec.DiscreteValueCondition)
                      obj;

          if (!getValuesList().equals(other.getValuesList())) return false;
          if (!unknownFields.equals(other.unknownFields)) return false;
          return true;
        }

        @java.lang.Override
        public int hashCode() {
          if (memoizedHashCode != 0) {
            return memoizedHashCode;
          }
          int hash = 41;
          hash = (19 * hash) + getDescriptor().hashCode();
          if (getValuesCount() > 0) {
            hash = (37 * hash) + VALUES_FIELD_NUMBER;
            hash = (53 * hash) + getValuesList().hashCode();
          }
          hash = (29 * hash) + unknownFields.hashCode();
          memoizedHashCode = hash;
          return hash;
        }

        public static com.google.cloud.aiplatform.v1beta1.StudySpec.ParameterSpec
                .ConditionalParameterSpec.DiscreteValueCondition
            parseFrom(java.nio.ByteBuffer data)
                throws com.google.protobuf.InvalidProtocolBufferException {
          return PARSER.parseFrom(data);
        }

        public static com.google.cloud.aiplatform.v1beta1.StudySpec.ParameterSpec
                .ConditionalParameterSpec.DiscreteValueCondition
            parseFrom(
                java.nio.ByteBuffer data,
                com.google.protobuf.ExtensionRegistryLite extensionRegistry)
                throws com.google.protobuf.InvalidProtocolBufferException {
          return PARSER.parseFrom(data, extensionRegistry);
        }

        public static com.google.cloud.aiplatform.v1beta1.StudySpec.ParameterSpec
                .ConditionalParameterSpec.DiscreteValueCondition
            parseFrom(com.google.protobuf.ByteString data)
                throws com.google.protobuf.InvalidProtocolBufferException {
          return PARSER.parseFrom(data);
        }

        public static com.google.cloud.aiplatform.v1beta1.StudySpec.ParameterSpec
                .ConditionalParameterSpec.DiscreteValueCondition
            parseFrom(
                com.google.protobuf.ByteString data,
                com.google.protobuf.ExtensionRegistryLite extensionRegistry)
                throws com.google.protobuf.InvalidProtocolBufferException {
          return PARSER.parseFrom(data, extensionRegistry);
        }

        public static com.google.cloud.aiplatform.v1beta1.StudySpec.ParameterSpec
                .ConditionalParameterSpec.DiscreteValueCondition
            parseFrom(byte[] data) throws com.google.protobuf.InvalidProtocolBufferException {
          return PARSER.parseFrom(data);
        }

        public static com.google.cloud.aiplatform.v1beta1.StudySpec.ParameterSpec
                .ConditionalParameterSpec.DiscreteValueCondition
            parseFrom(byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
                throws com.google.protobuf.InvalidProtocolBufferException {
          return PARSER.parseFrom(data, extensionRegistry);
        }

        public static com.google.cloud.aiplatform.v1beta1.StudySpec.ParameterSpec
                .ConditionalParameterSpec.DiscreteValueCondition
            parseFrom(java.io.InputStream input) throws java.io.IOException {
          return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
        }

        public static com.google.cloud.aiplatform.v1beta1.StudySpec.ParameterSpec
                .ConditionalParameterSpec.DiscreteValueCondition
            parseFrom(
                java.io.InputStream input,
                com.google.protobuf.ExtensionRegistryLite extensionRegistry)
                throws java.io.IOException {
          return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
              PARSER, input, extensionRegistry);
        }

        public static com.google.cloud.aiplatform.v1beta1.StudySpec.ParameterSpec
                .ConditionalParameterSpec.DiscreteValueCondition
            parseDelimitedFrom(java.io.InputStream input) throws java.io.IOException {
          return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
              PARSER, input);
        }

        public static com.google.cloud.aiplatform.v1beta1.StudySpec.ParameterSpec
                .ConditionalParameterSpec.DiscreteValueCondition
            parseDelimitedFrom(
                java.io.InputStream input,
                com.google.protobuf.ExtensionRegistryLite extensionRegistry)
                throws java.io.IOException {
          return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
              PARSER, input, extensionRegistry);
        }

        public static com.google.cloud.aiplatform.v1beta1.StudySpec.ParameterSpec
                .ConditionalParameterSpec.DiscreteValueCondition
            parseFrom(com.google.protobuf.CodedInputStream input) throws java.io.IOException {
          return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
        }

        public static com.google.cloud.aiplatform.v1beta1.StudySpec.ParameterSpec
                .ConditionalParameterSpec.DiscreteValueCondition
            parseFrom(
                com.google.protobuf.CodedInputStream input,
                com.google.protobuf.ExtensionRegistryLite extensionRegistry)
                throws java.io.IOException {
          return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
              PARSER, input, extensionRegistry);
        }

        @java.lang.Override
        public Builder newBuilderForType() {
          return newBuilder();
        }

        public static Builder newBuilder() {
          return DEFAULT_INSTANCE.toBuilder();
        }

        public static Builder newBuilder(
            com.google.cloud.aiplatform.v1beta1.StudySpec.ParameterSpec.ConditionalParameterSpec
                    .DiscreteValueCondition
                prototype) {
          return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
        }

        @java.lang.Override
        public Builder toBuilder() {
          return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
        }

        @java.lang.Override
        protected Builder newBuilderForType(
            com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
          Builder builder = new Builder(parent);
          return builder;
        }
        /**
         *
         *
         * <pre>
         * Represents the spec to match discrete values from parent parameter.
         * </pre>
         *
         * Protobuf type {@code
         * google.cloud.aiplatform.v1beta1.StudySpec.ParameterSpec.ConditionalParameterSpec.DiscreteValueCondition}
         */
        public static final class Builder
            extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
            implements
            // @@protoc_insertion_point(builder_implements:google.cloud.aiplatform.v1beta1.StudySpec.ParameterSpec.ConditionalParameterSpec.DiscreteValueCondition)
            com.google.cloud.aiplatform.v1beta1.StudySpec.ParameterSpec.ConditionalParameterSpec
                .DiscreteValueConditionOrBuilder {
          public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
            return com.google.cloud.aiplatform.v1beta1.StudyProto
                .internal_static_google_cloud_aiplatform_v1beta1_StudySpec_ParameterSpec_ConditionalParameterSpec_DiscreteValueCondition_descriptor;
          }

          @java.lang.Override
          protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
              internalGetFieldAccessorTable() {
            return com.google.cloud.aiplatform.v1beta1.StudyProto
                .internal_static_google_cloud_aiplatform_v1beta1_StudySpec_ParameterSpec_ConditionalParameterSpec_DiscreteValueCondition_fieldAccessorTable
                .ensureFieldAccessorsInitialized(
                    com.google.cloud.aiplatform.v1beta1.StudySpec.ParameterSpec
                        .ConditionalParameterSpec.DiscreteValueCondition.class,
                    com.google.cloud.aiplatform.v1beta1.StudySpec.ParameterSpec
                        .ConditionalParameterSpec.DiscreteValueCondition.Builder.class);
          }

          // Construct using
          // com.google.cloud.aiplatform.v1beta1.StudySpec.ParameterSpec.ConditionalParameterSpec.DiscreteValueCondition.newBuilder()
          private Builder() {
            maybeForceBuilderInitialization();
          }

          private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
            super(parent);
            maybeForceBuilderInitialization();
          }

          private void maybeForceBuilderInitialization() {
            if (com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders) {}
          }

          @java.lang.Override
          public Builder clear() {
            super.clear();
            values_ = emptyDoubleList();
            bitField0_ = (bitField0_ & ~0x00000001);
            return this;
          }

          @java.lang.Override
          public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
            return com.google.cloud.aiplatform.v1beta1.StudyProto
                .internal_static_google_cloud_aiplatform_v1beta1_StudySpec_ParameterSpec_ConditionalParameterSpec_DiscreteValueCondition_descriptor;
          }

          @java.lang.Override
          public com.google.cloud.aiplatform.v1beta1.StudySpec.ParameterSpec
                  .ConditionalParameterSpec.DiscreteValueCondition
              getDefaultInstanceForType() {
            return com.google.cloud.aiplatform.v1beta1.StudySpec.ParameterSpec
                .ConditionalParameterSpec.DiscreteValueCondition.getDefaultInstance();
          }

          @java.lang.Override
          public com.google.cloud.aiplatform.v1beta1.StudySpec.ParameterSpec
                  .ConditionalParameterSpec.DiscreteValueCondition
              build() {
            com.google.cloud.aiplatform.v1beta1.StudySpec.ParameterSpec.ConditionalParameterSpec
                    .DiscreteValueCondition
                result = buildPartial();
            if (!result.isInitialized()) {
              throw newUninitializedMessageException(result);
            }
            return result;
          }

          @java.lang.Override
          public com.google.cloud.aiplatform.v1beta1.StudySpec.ParameterSpec
                  .ConditionalParameterSpec.DiscreteValueCondition
              buildPartial() {
            com.google.cloud.aiplatform.v1beta1.StudySpec.ParameterSpec.ConditionalParameterSpec
                    .DiscreteValueCondition
                result =
                    new com.google.cloud.aiplatform.v1beta1.StudySpec.ParameterSpec
                        .ConditionalParameterSpec.DiscreteValueCondition(this);
            int from_bitField0_ = bitField0_;
            if (((bitField0_ & 0x00000001) != 0)) {
              values_.makeImmutable();
              bitField0_ = (bitField0_ & ~0x00000001);
            }
            result.values_ = values_;
            onBuilt();
            return result;
          }

          @java.lang.Override
          public Builder clone() {
            return super.clone();
          }

          @java.lang.Override
          public Builder setField(
              com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
            return super.setField(field, value);
          }

          @java.lang.Override
          public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
            return super.clearField(field);
          }

          @java.lang.Override
          public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
            return super.clearOneof(oneof);
          }

          @java.lang.Override
          public Builder setRepeatedField(
              com.google.protobuf.Descriptors.FieldDescriptor field,
              int index,
              java.lang.Object value) {
            return super.setRepeatedField(field, index, value);
          }

          @java.lang.Override
          public Builder addRepeatedField(
              com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
            return super.addRepeatedField(field, value);
          }

          @java.lang.Override
          public Builder mergeFrom(com.google.protobuf.Message other) {
            if (other
                instanceof
                com.google.cloud.aiplatform.v1beta1.StudySpec.ParameterSpec.ConditionalParameterSpec
                    .DiscreteValueCondition) {
              return mergeFrom(
                  (com.google.cloud.aiplatform.v1beta1.StudySpec.ParameterSpec
                          .ConditionalParameterSpec.DiscreteValueCondition)
                      other);
            } else {
              super.mergeFrom(other);
              return this;
            }
          }

          public Builder mergeFrom(
              com.google.cloud.aiplatform.v1beta1.StudySpec.ParameterSpec.ConditionalParameterSpec
                      .DiscreteValueCondition
                  other) {
            if (other
                == com.google.cloud.aiplatform.v1beta1.StudySpec.ParameterSpec
                    .ConditionalParameterSpec.DiscreteValueCondition.getDefaultInstance())
              return this;
            if (!other.values_.isEmpty()) {
              if (values_.isEmpty()) {
                values_ = other.values_;
                bitField0_ = (bitField0_ & ~0x00000001);
              } else {
                ensureValuesIsMutable();
                values_.addAll(other.values_);
              }
              onChanged();
            }
            this.mergeUnknownFields(other.unknownFields);
            onChanged();
            return this;
          }

          @java.lang.Override
          public final boolean isInitialized() {
            return true;
          }

          @java.lang.Override
          public Builder mergeFrom(
              com.google.protobuf.CodedInputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws java.io.IOException {
            com.google.cloud.aiplatform.v1beta1.StudySpec.ParameterSpec.ConditionalParameterSpec
                    .DiscreteValueCondition
                parsedMessage = null;
            try {
              parsedMessage = PARSER.parsePartialFrom(input, extensionRegistry);
            } catch (com.google.protobuf.InvalidProtocolBufferException e) {
              parsedMessage =
                  (com.google.cloud.aiplatform.v1beta1.StudySpec.ParameterSpec
                          .ConditionalParameterSpec.DiscreteValueCondition)
                      e.getUnfinishedMessage();
              throw e.unwrapIOException();
            } finally {
              if (parsedMessage != null) {
                mergeFrom(parsedMessage);
              }
            }
            return this;
          }

          private int bitField0_;

          private com.google.protobuf.Internal.DoubleList values_ = emptyDoubleList();

          private void ensureValuesIsMutable() {
            if (!((bitField0_ & 0x00000001) != 0)) {
              values_ = mutableCopy(values_);
              bitField0_ |= 0x00000001;
            }
          }
          /**
           *
           *
           * <pre>
           * Required. Matches values of the parent parameter of 'DISCRETE' type.
           * All values must exist in `discrete_value_spec` of parent parameter.
           * The Epsilon of the value matching is 1e-10.
           * </pre>
           *
           * <code>repeated double values = 1 [(.google.api.field_behavior) = REQUIRED];</code>
           *
           * @return A list containing the values.
           */
          public java.util.List<java.lang.Double> getValuesList() {
            return ((bitField0_ & 0x00000001) != 0)
                ? java.util.Collections.unmodifiableList(values_)
                : values_;
          }
          /**
           *
           *
           * <pre>
           * Required. Matches values of the parent parameter of 'DISCRETE' type.
           * All values must exist in `discrete_value_spec` of parent parameter.
           * The Epsilon of the value matching is 1e-10.
           * </pre>
           *
           * <code>repeated double values = 1 [(.google.api.field_behavior) = REQUIRED];</code>
           *
           * @return The count of values.
           */
          public int getValuesCount() {
            return values_.size();
          }
          /**
           *
           *
           * <pre>
           * Required. Matches values of the parent parameter of 'DISCRETE' type.
           * All values must exist in `discrete_value_spec` of parent parameter.
           * The Epsilon of the value matching is 1e-10.
           * </pre>
           *
           * <code>repeated double values = 1 [(.google.api.field_behavior) = REQUIRED];</code>
           *
           * @param index The index of the element to return.
           * @return The values at the given index.
           */
          public double getValues(int index) {
            return values_.getDouble(index);
          }
          /**
           *
           *
           * <pre>
           * Required. Matches values of the parent parameter of 'DISCRETE' type.
           * All values must exist in `discrete_value_spec` of parent parameter.
           * The Epsilon of the value matching is 1e-10.
           * </pre>
           *
           * <code>repeated double values = 1 [(.google.api.field_behavior) = REQUIRED];</code>
           *
           * @param index The index to set the value at.
           * @param value The values to set.
           * @return This builder for chaining.
           */
          public Builder setValues(int index, double value) {
            ensureValuesIsMutable();
            values_.setDouble(index, value);
            onChanged();
            return this;
          }
          /**
           *
           *
           * <pre>
           * Required. Matches values of the parent parameter of 'DISCRETE' type.
           * All values must exist in `discrete_value_spec` of parent parameter.
           * The Epsilon of the value matching is 1e-10.
           * </pre>
           *
           * <code>repeated double values = 1 [(.google.api.field_behavior) = REQUIRED];</code>
           *
           * @param value The values to add.
           * @return This builder for chaining.
           */
          public Builder addValues(double value) {
            ensureValuesIsMutable();
            values_.addDouble(value);
            onChanged();
            return this;
          }
          /**
           *
           *
           * <pre>
           * Required. Matches values of the parent parameter of 'DISCRETE' type.
           * All values must exist in `discrete_value_spec` of parent parameter.
           * The Epsilon of the value matching is 1e-10.
           * </pre>
           *
           * <code>repeated double values = 1 [(.google.api.field_behavior) = REQUIRED];</code>
           *
           * @param values The values to add.
           * @return This builder for chaining.
           */
          public Builder addAllValues(java.lang.Iterable<? extends java.lang.Double> values) {
            ensureValuesIsMutable();
            com.google.protobuf.AbstractMessageLite.Builder.addAll(values, values_);
            onChanged();
            return this;
          }
          /**
           *
           *
           * <pre>
           * Required. Matches values of the parent parameter of 'DISCRETE' type.
           * All values must exist in `discrete_value_spec` of parent parameter.
           * The Epsilon of the value matching is 1e-10.
           * </pre>
           *
           * <code>repeated double values = 1 [(.google.api.field_behavior) = REQUIRED];</code>
           *
           * @return This builder for chaining.
           */
          public Builder clearValues() {
            values_ = emptyDoubleList();
            bitField0_ = (bitField0_ & ~0x00000001);
            onChanged();
            return this;
          }

          @java.lang.Override
          public final Builder setUnknownFields(
              final com.google.protobuf.UnknownFieldSet unknownFields) {
            return super.setUnknownFields(unknownFields);
          }

          @java.lang.Override
          public final Builder mergeUnknownFields(
              final com.google.protobuf.UnknownFieldSet unknownFields) {
            return super.mergeUnknownFields(unknownFields);
          }

          // @@protoc_insertion_point(builder_scope:google.cloud.aiplatform.v1beta1.StudySpec.ParameterSpec.ConditionalParameterSpec.DiscreteValueCondition)
        }

        // @@protoc_insertion_point(class_scope:google.cloud.aiplatform.v1beta1.StudySpec.ParameterSpec.ConditionalParameterSpec.DiscreteValueCondition)
        private static final com.google.cloud.aiplatform.v1beta1.StudySpec.ParameterSpec
                .ConditionalParameterSpec.DiscreteValueCondition
            DEFAULT_INSTANCE;

        static {
          DEFAULT_INSTANCE =
              new com.google.cloud.aiplatform.v1beta1.StudySpec.ParameterSpec
                  .ConditionalParameterSpec.DiscreteValueCondition();
        }

        public static com.google.cloud.aiplatform.v1beta1.StudySpec.ParameterSpec
                .ConditionalParameterSpec.DiscreteValueCondition
            getDefaultInstance() {
          return DEFAULT_INSTANCE;
        }

        private static final com.google.protobuf.Parser<DiscreteValueCondition> PARSER =
            new com.google.protobuf.AbstractParser<DiscreteValueCondition>() {
              @java.lang.Override
              public DiscreteValueCondition parsePartialFrom(
                  com.google.protobuf.CodedInputStream input,
                  com.google.protobuf.ExtensionRegistryLite extensionRegistry)
                  throws com.google.protobuf.InvalidProtocolBufferException {
                return new DiscreteValueCondition(input, extensionRegistry);
              }
            };

        public static com.google.protobuf.Parser<DiscreteValueCondition> parser() {
          return PARSER;
        }

        @java.lang.Override
        public com.google.protobuf.Parser<DiscreteValueCondition> getParserForType() {
          return PARSER;
        }

        @java.lang.Override
        public com.google.cloud.aiplatform.v1beta1.StudySpec.ParameterSpec.ConditionalParameterSpec
                .DiscreteValueCondition
            getDefaultInstanceForType() {
          return DEFAULT_INSTANCE;
        }
      }

      public interface IntValueConditionOrBuilder
          extends
          // @@protoc_insertion_point(interface_extends:google.cloud.aiplatform.v1beta1.StudySpec.ParameterSpec.ConditionalParameterSpec.IntValueCondition)
          com.google.protobuf.MessageOrBuilder {

        /**
         *
         *
         * <pre>
         * Required. Matches values of the parent parameter of 'INTEGER' type.
         * All values must lie in `integer_value_spec` of parent parameter.
         * </pre>
         *
         * <code>repeated int64 values = 1 [(.google.api.field_behavior) = REQUIRED];</code>
         *
         * @return A list containing the values.
         */
        java.util.List<java.lang.Long> getValuesList();
        /**
         *
         *
         * <pre>
         * Required. Matches values of the parent parameter of 'INTEGER' type.
         * All values must lie in `integer_value_spec` of parent parameter.
         * </pre>
         *
         * <code>repeated int64 values = 1 [(.google.api.field_behavior) = REQUIRED];</code>
         *
         * @return The count of values.
         */
        int getValuesCount();
        /**
         *
         *
         * <pre>
         * Required. Matches values of the parent parameter of 'INTEGER' type.
         * All values must lie in `integer_value_spec` of parent parameter.
         * </pre>
         *
         * <code>repeated int64 values = 1 [(.google.api.field_behavior) = REQUIRED];</code>
         *
         * @param index The index of the element to return.
         * @return The values at the given index.
         */
        long getValues(int index);
      }
      /**
       *
       *
       * <pre>
       * Represents the spec to match integer values from parent parameter.
       * </pre>
       *
       * Protobuf type {@code
       * google.cloud.aiplatform.v1beta1.StudySpec.ParameterSpec.ConditionalParameterSpec.IntValueCondition}
       */
      public static final class IntValueCondition extends com.google.protobuf.GeneratedMessageV3
          implements
          // @@protoc_insertion_point(message_implements:google.cloud.aiplatform.v1beta1.StudySpec.ParameterSpec.ConditionalParameterSpec.IntValueCondition)
          IntValueConditionOrBuilder {
        private static final long serialVersionUID = 0L;
        // Use IntValueCondition.newBuilder() to construct.
        private IntValueCondition(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
          super(builder);
        }

        private IntValueCondition() {
          values_ = emptyLongList();
        }

        @java.lang.Override
        @SuppressWarnings({"unused"})
        protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
          return new IntValueCondition();
        }

        @java.lang.Override
        public final com.google.protobuf.UnknownFieldSet getUnknownFields() {
          return this.unknownFields;
        }

        private IntValueCondition(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          this();
          if (extensionRegistry == null) {
            throw new java.lang.NullPointerException();
          }
          int mutable_bitField0_ = 0;
          com.google.protobuf.UnknownFieldSet.Builder unknownFields =
              com.google.protobuf.UnknownFieldSet.newBuilder();
          try {
            boolean done = false;
            while (!done) {
              int tag = input.readTag();
              switch (tag) {
                case 0:
                  done = true;
                  break;
                case 8:
                  {
                    if (!((mutable_bitField0_ & 0x00000001) != 0)) {
                      values_ = newLongList();
                      mutable_bitField0_ |= 0x00000001;
                    }
                    values_.addLong(input.readInt64());
                    break;
                  }
                case 10:
                  {
                    int length = input.readRawVarint32();
                    int limit = input.pushLimit(length);
                    if (!((mutable_bitField0_ & 0x00000001) != 0)
                        && input.getBytesUntilLimit() > 0) {
                      values_ = newLongList();
                      mutable_bitField0_ |= 0x00000001;
                    }
                    while (input.getBytesUntilLimit() > 0) {
                      values_.addLong(input.readInt64());
                    }
                    input.popLimit(limit);
                    break;
                  }
                default:
                  {
                    if (!parseUnknownField(input, unknownFields, extensionRegistry, tag)) {
                      done = true;
                    }
                    break;
                  }
              }
            }
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.setUnfinishedMessage(this);
          } catch (java.io.IOException e) {
            throw new com.google.protobuf.InvalidProtocolBufferException(e)
                .setUnfinishedMessage(this);
          } finally {
            if (((mutable_bitField0_ & 0x00000001) != 0)) {
              values_.makeImmutable(); // C
            }
            this.unknownFields = unknownFields.build();
            makeExtensionsImmutable();
          }
        }

        public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
          return com.google.cloud.aiplatform.v1beta1.StudyProto
              .internal_static_google_cloud_aiplatform_v1beta1_StudySpec_ParameterSpec_ConditionalParameterSpec_IntValueCondition_descriptor;
        }

        @java.lang.Override
        protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
            internalGetFieldAccessorTable() {
          return com.google.cloud.aiplatform.v1beta1.StudyProto
              .internal_static_google_cloud_aiplatform_v1beta1_StudySpec_ParameterSpec_ConditionalParameterSpec_IntValueCondition_fieldAccessorTable
              .ensureFieldAccessorsInitialized(
                  com.google.cloud.aiplatform.v1beta1.StudySpec.ParameterSpec
                      .ConditionalParameterSpec.IntValueCondition.class,
                  com.google.cloud.aiplatform.v1beta1.StudySpec.ParameterSpec
                      .ConditionalParameterSpec.IntValueCondition.Builder.class);
        }

        public static final int VALUES_FIELD_NUMBER = 1;
        private com.google.protobuf.Internal.LongList values_;
        /**
         *
         *
         * <pre>
         * Required. Matches values of the parent parameter of 'INTEGER' type.
         * All values must lie in `integer_value_spec` of parent parameter.
         * </pre>
         *
         * <code>repeated int64 values = 1 [(.google.api.field_behavior) = REQUIRED];</code>
         *
         * @return A list containing the values.
         */
        @java.lang.Override
        public java.util.List<java.lang.Long> getValuesList() {
          return values_;
        }
        /**
         *
         *
         * <pre>
         * Required. Matches values of the parent parameter of 'INTEGER' type.
         * All values must lie in `integer_value_spec` of parent parameter.
         * </pre>
         *
         * <code>repeated int64 values = 1 [(.google.api.field_behavior) = REQUIRED];</code>
         *
         * @return The count of values.
         */
        public int getValuesCount() {
          return values_.size();
        }
        /**
         *
         *
         * <pre>
         * Required. Matches values of the parent parameter of 'INTEGER' type.
         * All values must lie in `integer_value_spec` of parent parameter.
         * </pre>
         *
         * <code>repeated int64 values = 1 [(.google.api.field_behavior) = REQUIRED];</code>
         *
         * @param index The index of the element to return.
         * @return The values at the given index.
         */
        public long getValues(int index) {
          return values_.getLong(index);
        }

        private int valuesMemoizedSerializedSize = -1;

        private byte memoizedIsInitialized = -1;

        @java.lang.Override
        public final boolean isInitialized() {
          byte isInitialized = memoizedIsInitialized;
          if (isInitialized == 1) return true;
          if (isInitialized == 0) return false;

          memoizedIsInitialized = 1;
          return true;
        }

        @java.lang.Override
        public void writeTo(com.google.protobuf.CodedOutputStream output)
            throws java.io.IOException {
          getSerializedSize();
          if (getValuesList().size() > 0) {
            output.writeUInt32NoTag(10);
            output.writeUInt32NoTag(valuesMemoizedSerializedSize);
          }
          for (int i = 0; i < values_.size(); i++) {
            output.writeInt64NoTag(values_.getLong(i));
          }
          unknownFields.writeTo(output);
        }

        @java.lang.Override
        public int getSerializedSize() {
          int size = memoizedSize;
          if (size != -1) return size;

          size = 0;
          {
            int dataSize = 0;
            for (int i = 0; i < values_.size(); i++) {
              dataSize +=
                  com.google.protobuf.CodedOutputStream.computeInt64SizeNoTag(values_.getLong(i));
            }
            size += dataSize;
            if (!getValuesList().isEmpty()) {
              size += 1;
              size += com.google.protobuf.CodedOutputStream.computeInt32SizeNoTag(dataSize);
            }
            valuesMemoizedSerializedSize = dataSize;
          }
          size += unknownFields.getSerializedSize();
          memoizedSize = size;
          return size;
        }

        @java.lang.Override
        public boolean equals(final java.lang.Object obj) {
          if (obj == this) {
            return true;
          }
          if (!(obj
              instanceof
              com.google.cloud.aiplatform.v1beta1.StudySpec.ParameterSpec.ConditionalParameterSpec
                  .IntValueCondition)) {
            return super.equals(obj);
          }
          com.google.cloud.aiplatform.v1beta1.StudySpec.ParameterSpec.ConditionalParameterSpec
                  .IntValueCondition
              other =
                  (com.google.cloud.aiplatform.v1beta1.StudySpec.ParameterSpec
                          .ConditionalParameterSpec.IntValueCondition)
                      obj;

          if (!getValuesList().equals(other.getValuesList())) return false;
          if (!unknownFields.equals(other.unknownFields)) return false;
          return true;
        }

        @java.lang.Override
        public int hashCode() {
          if (memoizedHashCode != 0) {
            return memoizedHashCode;
          }
          int hash = 41;
          hash = (19 * hash) + getDescriptor().hashCode();
          if (getValuesCount() > 0) {
            hash = (37 * hash) + VALUES_FIELD_NUMBER;
            hash = (53 * hash) + getValuesList().hashCode();
          }
          hash = (29 * hash) + unknownFields.hashCode();
          memoizedHashCode = hash;
          return hash;
        }

        public static com.google.cloud.aiplatform.v1beta1.StudySpec.ParameterSpec
                .ConditionalParameterSpec.IntValueCondition
            parseFrom(java.nio.ByteBuffer data)
                throws com.google.protobuf.InvalidProtocolBufferException {
          return PARSER.parseFrom(data);
        }

        public static com.google.cloud.aiplatform.v1beta1.StudySpec.ParameterSpec
                .ConditionalParameterSpec.IntValueCondition
            parseFrom(
                java.nio.ByteBuffer data,
                com.google.protobuf.ExtensionRegistryLite extensionRegistry)
                throws com.google.protobuf.InvalidProtocolBufferException {
          return PARSER.parseFrom(data, extensionRegistry);
        }

        public static com.google.cloud.aiplatform.v1beta1.StudySpec.ParameterSpec
                .ConditionalParameterSpec.IntValueCondition
            parseFrom(com.google.protobuf.ByteString data)
                throws com.google.protobuf.InvalidProtocolBufferException {
          return PARSER.parseFrom(data);
        }

        public static com.google.cloud.aiplatform.v1beta1.StudySpec.ParameterSpec
                .ConditionalParameterSpec.IntValueCondition
            parseFrom(
                com.google.protobuf.ByteString data,
                com.google.protobuf.ExtensionRegistryLite extensionRegistry)
                throws com.google.protobuf.InvalidProtocolBufferException {
          return PARSER.parseFrom(data, extensionRegistry);
        }

        public static com.google.cloud.aiplatform.v1beta1.StudySpec.ParameterSpec
                .ConditionalParameterSpec.IntValueCondition
            parseFrom(byte[] data) throws com.google.protobuf.InvalidProtocolBufferException {
          return PARSER.parseFrom(data);
        }

        public static com.google.cloud.aiplatform.v1beta1.StudySpec.ParameterSpec
                .ConditionalParameterSpec.IntValueCondition
            parseFrom(byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
                throws com.google.protobuf.InvalidProtocolBufferException {
          return PARSER.parseFrom(data, extensionRegistry);
        }

        public static com.google.cloud.aiplatform.v1beta1.StudySpec.ParameterSpec
                .ConditionalParameterSpec.IntValueCondition
            parseFrom(java.io.InputStream input) throws java.io.IOException {
          return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
        }

        public static com.google.cloud.aiplatform.v1beta1.StudySpec.ParameterSpec
                .ConditionalParameterSpec.IntValueCondition
            parseFrom(
                java.io.InputStream input,
                com.google.protobuf.ExtensionRegistryLite extensionRegistry)
                throws java.io.IOException {
          return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
              PARSER, input, extensionRegistry);
        }

        public static com.google.cloud.aiplatform.v1beta1.StudySpec.ParameterSpec
                .ConditionalParameterSpec.IntValueCondition
            parseDelimitedFrom(java.io.InputStream input) throws java.io.IOException {
          return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
              PARSER, input);
        }

        public static com.google.cloud.aiplatform.v1beta1.StudySpec.ParameterSpec
                .ConditionalParameterSpec.IntValueCondition
            parseDelimitedFrom(
                java.io.InputStream input,
                com.google.protobuf.ExtensionRegistryLite extensionRegistry)
                throws java.io.IOException {
          return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
              PARSER, input, extensionRegistry);
        }

        public static com.google.cloud.aiplatform.v1beta1.StudySpec.ParameterSpec
                .ConditionalParameterSpec.IntValueCondition
            parseFrom(com.google.protobuf.CodedInputStream input) throws java.io.IOException {
          return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
        }

        public static com.google.cloud.aiplatform.v1beta1.StudySpec.ParameterSpec
                .ConditionalParameterSpec.IntValueCondition
            parseFrom(
                com.google.protobuf.CodedInputStream input,
                com.google.protobuf.ExtensionRegistryLite extensionRegistry)
                throws java.io.IOException {
          return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
              PARSER, input, extensionRegistry);
        }

        @java.lang.Override
        public Builder newBuilderForType() {
          return newBuilder();
        }

        public static Builder newBuilder() {
          return DEFAULT_INSTANCE.toBuilder();
        }

        public static Builder newBuilder(
            com.google.cloud.aiplatform.v1beta1.StudySpec.ParameterSpec.ConditionalParameterSpec
                    .IntValueCondition
                prototype) {
          return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
        }

        @java.lang.Override
        public Builder toBuilder() {
          return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
        }

        @java.lang.Override
        protected Builder newBuilderForType(
            com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
          Builder builder = new Builder(parent);
          return builder;
        }
        /**
         *
         *
         * <pre>
         * Represents the spec to match integer values from parent parameter.
         * </pre>
         *
         * Protobuf type {@code
         * google.cloud.aiplatform.v1beta1.StudySpec.ParameterSpec.ConditionalParameterSpec.IntValueCondition}
         */
        public static final class Builder
            extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
            implements
            // @@protoc_insertion_point(builder_implements:google.cloud.aiplatform.v1beta1.StudySpec.ParameterSpec.ConditionalParameterSpec.IntValueCondition)
            com.google.cloud.aiplatform.v1beta1.StudySpec.ParameterSpec.ConditionalParameterSpec
                .IntValueConditionOrBuilder {
          public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
            return com.google.cloud.aiplatform.v1beta1.StudyProto
                .internal_static_google_cloud_aiplatform_v1beta1_StudySpec_ParameterSpec_ConditionalParameterSpec_IntValueCondition_descriptor;
          }

          @java.lang.Override
          protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
              internalGetFieldAccessorTable() {
            return com.google.cloud.aiplatform.v1beta1.StudyProto
                .internal_static_google_cloud_aiplatform_v1beta1_StudySpec_ParameterSpec_ConditionalParameterSpec_IntValueCondition_fieldAccessorTable
                .ensureFieldAccessorsInitialized(
                    com.google.cloud.aiplatform.v1beta1.StudySpec.ParameterSpec
                        .ConditionalParameterSpec.IntValueCondition.class,
                    com.google.cloud.aiplatform.v1beta1.StudySpec.ParameterSpec
                        .ConditionalParameterSpec.IntValueCondition.Builder.class);
          }

          // Construct using
          // com.google.cloud.aiplatform.v1beta1.StudySpec.ParameterSpec.ConditionalParameterSpec.IntValueCondition.newBuilder()
          private Builder() {
            maybeForceBuilderInitialization();
          }

          private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
            super(parent);
            maybeForceBuilderInitialization();
          }

          private void maybeForceBuilderInitialization() {
            if (com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders) {}
          }

          @java.lang.Override
          public Builder clear() {
            super.clear();
            values_ = emptyLongList();
            bitField0_ = (bitField0_ & ~0x00000001);
            return this;
          }

          @java.lang.Override
          public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
            return com.google.cloud.aiplatform.v1beta1.StudyProto
                .internal_static_google_cloud_aiplatform_v1beta1_StudySpec_ParameterSpec_ConditionalParameterSpec_IntValueCondition_descriptor;
          }

          @java.lang.Override
          public com.google.cloud.aiplatform.v1beta1.StudySpec.ParameterSpec
                  .ConditionalParameterSpec.IntValueCondition
              getDefaultInstanceForType() {
            return com.google.cloud.aiplatform.v1beta1.StudySpec.ParameterSpec
                .ConditionalParameterSpec.IntValueCondition.getDefaultInstance();
          }

          @java.lang.Override
          public com.google.cloud.aiplatform.v1beta1.StudySpec.ParameterSpec
                  .ConditionalParameterSpec.IntValueCondition
              build() {
            com.google.cloud.aiplatform.v1beta1.StudySpec.ParameterSpec.ConditionalParameterSpec
                    .IntValueCondition
                result = buildPartial();
            if (!result.isInitialized()) {
              throw newUninitializedMessageException(result);
            }
            return result;
          }

          @java.lang.Override
          public com.google.cloud.aiplatform.v1beta1.StudySpec.ParameterSpec
                  .ConditionalParameterSpec.IntValueCondition
              buildPartial() {
            com.google.cloud.aiplatform.v1beta1.StudySpec.ParameterSpec.ConditionalParameterSpec
                    .IntValueCondition
                result =
                    new com.google.cloud.aiplatform.v1beta1.StudySpec.ParameterSpec
                        .ConditionalParameterSpec.IntValueCondition(this);
            int from_bitField0_ = bitField0_;
            if (((bitField0_ & 0x00000001) != 0)) {
              values_.makeImmutable();
              bitField0_ = (bitField0_ & ~0x00000001);
            }
            result.values_ = values_;
            onBuilt();
            return result;
          }

          @java.lang.Override
          public Builder clone() {
            return super.clone();
          }

          @java.lang.Override
          public Builder setField(
              com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
            return super.setField(field, value);
          }

          @java.lang.Override
          public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
            return super.clearField(field);
          }

          @java.lang.Override
          public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
            return super.clearOneof(oneof);
          }

          @java.lang.Override
          public Builder setRepeatedField(
              com.google.protobuf.Descriptors.FieldDescriptor field,
              int index,
              java.lang.Object value) {
            return super.setRepeatedField(field, index, value);
          }

          @java.lang.Override
          public Builder addRepeatedField(
              com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
            return super.addRepeatedField(field, value);
          }

          @java.lang.Override
          public Builder mergeFrom(com.google.protobuf.Message other) {
            if (other
                instanceof
                com.google.cloud.aiplatform.v1beta1.StudySpec.ParameterSpec.ConditionalParameterSpec
                    .IntValueCondition) {
              return mergeFrom(
                  (com.google.cloud.aiplatform.v1beta1.StudySpec.ParameterSpec
                          .ConditionalParameterSpec.IntValueCondition)
                      other);
            } else {
              super.mergeFrom(other);
              return this;
            }
          }

          public Builder mergeFrom(
              com.google.cloud.aiplatform.v1beta1.StudySpec.ParameterSpec.ConditionalParameterSpec
                      .IntValueCondition
                  other) {
            if (other
                == com.google.cloud.aiplatform.v1beta1.StudySpec.ParameterSpec
                    .ConditionalParameterSpec.IntValueCondition.getDefaultInstance()) return this;
            if (!other.values_.isEmpty()) {
              if (values_.isEmpty()) {
                values_ = other.values_;
                bitField0_ = (bitField0_ & ~0x00000001);
              } else {
                ensureValuesIsMutable();
                values_.addAll(other.values_);
              }
              onChanged();
            }
            this.mergeUnknownFields(other.unknownFields);
            onChanged();
            return this;
          }

          @java.lang.Override
          public final boolean isInitialized() {
            return true;
          }

          @java.lang.Override
          public Builder mergeFrom(
              com.google.protobuf.CodedInputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws java.io.IOException {
            com.google.cloud.aiplatform.v1beta1.StudySpec.ParameterSpec.ConditionalParameterSpec
                    .IntValueCondition
                parsedMessage = null;
            try {
              parsedMessage = PARSER.parsePartialFrom(input, extensionRegistry);
            } catch (com.google.protobuf.InvalidProtocolBufferException e) {
              parsedMessage =
                  (com.google.cloud.aiplatform.v1beta1.StudySpec.ParameterSpec
                          .ConditionalParameterSpec.IntValueCondition)
                      e.getUnfinishedMessage();
              throw e.unwrapIOException();
            } finally {
              if (parsedMessage != null) {
                mergeFrom(parsedMessage);
              }
            }
            return this;
          }

          private int bitField0_;

          private com.google.protobuf.Internal.LongList values_ = emptyLongList();

          private void ensureValuesIsMutable() {
            if (!((bitField0_ & 0x00000001) != 0)) {
              values_ = mutableCopy(values_);
              bitField0_ |= 0x00000001;
            }
          }
          /**
           *
           *
           * <pre>
           * Required. Matches values of the parent parameter of 'INTEGER' type.
           * All values must lie in `integer_value_spec` of parent parameter.
           * </pre>
           *
           * <code>repeated int64 values = 1 [(.google.api.field_behavior) = REQUIRED];</code>
           *
           * @return A list containing the values.
           */
          public java.util.List<java.lang.Long> getValuesList() {
            return ((bitField0_ & 0x00000001) != 0)
                ? java.util.Collections.unmodifiableList(values_)
                : values_;
          }
          /**
           *
           *
           * <pre>
           * Required. Matches values of the parent parameter of 'INTEGER' type.
           * All values must lie in `integer_value_spec` of parent parameter.
           * </pre>
           *
           * <code>repeated int64 values = 1 [(.google.api.field_behavior) = REQUIRED];</code>
           *
           * @return The count of values.
           */
          public int getValuesCount() {
            return values_.size();
          }
          /**
           *
           *
           * <pre>
           * Required. Matches values of the parent parameter of 'INTEGER' type.
           * All values must lie in `integer_value_spec` of parent parameter.
           * </pre>
           *
           * <code>repeated int64 values = 1 [(.google.api.field_behavior) = REQUIRED];</code>
           *
           * @param index The index of the element to return.
           * @return The values at the given index.
           */
          public long getValues(int index) {
            return values_.getLong(index);
          }
          /**
           *
           *
           * <pre>
           * Required. Matches values of the parent parameter of 'INTEGER' type.
           * All values must lie in `integer_value_spec` of parent parameter.
           * </pre>
           *
           * <code>repeated int64 values = 1 [(.google.api.field_behavior) = REQUIRED];</code>
           *
           * @param index The index to set the value at.
           * @param value The values to set.
           * @return This builder for chaining.
           */
          public Builder setValues(int index, long value) {
            ensureValuesIsMutable();
            values_.setLong(index, value);
            onChanged();
            return this;
          }
          /**
           *
           *
           * <pre>
           * Required. Matches values of the parent parameter of 'INTEGER' type.
           * All values must lie in `integer_value_spec` of parent parameter.
           * </pre>
           *
           * <code>repeated int64 values = 1 [(.google.api.field_behavior) = REQUIRED];</code>
           *
           * @param value The values to add.
           * @return This builder for chaining.
           */
          public Builder addValues(long value) {
            ensureValuesIsMutable();
            values_.addLong(value);
            onChanged();
            return this;
          }
          /**
           *
           *
           * <pre>
           * Required. Matches values of the parent parameter of 'INTEGER' type.
           * All values must lie in `integer_value_spec` of parent parameter.
           * </pre>
           *
           * <code>repeated int64 values = 1 [(.google.api.field_behavior) = REQUIRED];</code>
           *
           * @param values The values to add.
           * @return This builder for chaining.
           */
          public Builder addAllValues(java.lang.Iterable<? extends java.lang.Long> values) {
            ensureValuesIsMutable();
            com.google.protobuf.AbstractMessageLite.Builder.addAll(values, values_);
            onChanged();
            return this;
          }
          /**
           *
           *
           * <pre>
           * Required. Matches values of the parent parameter of 'INTEGER' type.
           * All values must lie in `integer_value_spec` of parent parameter.
           * </pre>
           *
           * <code>repeated int64 values = 1 [(.google.api.field_behavior) = REQUIRED];</code>
           *
           * @return This builder for chaining.
           */
          public Builder clearValues() {
            values_ = emptyLongList();
            bitField0_ = (bitField0_ & ~0x00000001);
            onChanged();
            return this;
          }

          @java.lang.Override
          public final Builder setUnknownFields(
              final com.google.protobuf.UnknownFieldSet unknownFields) {
            return super.setUnknownFields(unknownFields);
          }

          @java.lang.Override
          public final Builder mergeUnknownFields(
              final com.google.protobuf.UnknownFieldSet unknownFields) {
            return super.mergeUnknownFields(unknownFields);
          }

          // @@protoc_insertion_point(builder_scope:google.cloud.aiplatform.v1beta1.StudySpec.ParameterSpec.ConditionalParameterSpec.IntValueCondition)
        }

        // @@protoc_insertion_point(class_scope:google.cloud.aiplatform.v1beta1.StudySpec.ParameterSpec.ConditionalParameterSpec.IntValueCondition)
        private static final com.google.cloud.aiplatform.v1beta1.StudySpec.ParameterSpec
                .ConditionalParameterSpec.IntValueCondition
            DEFAULT_INSTANCE;

        static {
          DEFAULT_INSTANCE =
              new com.google.cloud.aiplatform.v1beta1.StudySpec.ParameterSpec
                  .ConditionalParameterSpec.IntValueCondition();
        }

        public static com.google.cloud.aiplatform.v1beta1.StudySpec.ParameterSpec
                .ConditionalParameterSpec.IntValueCondition
            getDefaultInstance() {
          return DEFAULT_INSTANCE;
        }

        private static final com.google.protobuf.Parser<IntValueCondition> PARSER =
            new com.google.protobuf.AbstractParser<IntValueCondition>() {
              @java.lang.Override
              public IntValueCondition parsePartialFrom(
                  com.google.protobuf.CodedInputStream input,
                  com.google.protobuf.ExtensionRegistryLite extensionRegistry)
                  throws com.google.protobuf.InvalidProtocolBufferException {
                return new IntValueCondition(input, extensionRegistry);
              }
            };

        public static com.google.protobuf.Parser<IntValueCondition> parser() {
          return PARSER;
        }

        @java.lang.Override
        public com.google.protobuf.Parser<IntValueCondition> getParserForType() {
          return PARSER;
        }

        @java.lang.Override
        public com.google.cloud.aiplatform.v1beta1.StudySpec.ParameterSpec.ConditionalParameterSpec
                .IntValueCondition
            getDefaultInstanceForType() {
          return DEFAULT_INSTANCE;
        }
      }

      public interface CategoricalValueConditionOrBuilder
          extends
          // @@protoc_insertion_point(interface_extends:google.cloud.aiplatform.v1beta1.StudySpec.ParameterSpec.ConditionalParameterSpec.CategoricalValueCondition)
          com.google.protobuf.MessageOrBuilder {

        /**
         *
         *
         * <pre>
         * Required. Matches values of the parent parameter of 'CATEGORICAL' type.
         * All values must exist in `categorical_value_spec` of parent
         * parameter.
         * </pre>
         *
         * <code>repeated string values = 1 [(.google.api.field_behavior) = REQUIRED];</code>
         *
         * @return A list containing the values.
         */
        java.util.List<java.lang.String> getValuesList();
        /**
         *
         *
         * <pre>
         * Required. Matches values of the parent parameter of 'CATEGORICAL' type.
         * All values must exist in `categorical_value_spec` of parent
         * parameter.
         * </pre>
         *
         * <code>repeated string values = 1 [(.google.api.field_behavior) = REQUIRED];</code>
         *
         * @return The count of values.
         */
        int getValuesCount();
        /**
         *
         *
         * <pre>
         * Required. Matches values of the parent parameter of 'CATEGORICAL' type.
         * All values must exist in `categorical_value_spec` of parent
         * parameter.
         * </pre>
         *
         * <code>repeated string values = 1 [(.google.api.field_behavior) = REQUIRED];</code>
         *
         * @param index The index of the element to return.
         * @return The values at the given index.
         */
        java.lang.String getValues(int index);
        /**
         *
         *
         * <pre>
         * Required. Matches values of the parent parameter of 'CATEGORICAL' type.
         * All values must exist in `categorical_value_spec` of parent
         * parameter.
         * </pre>
         *
         * <code>repeated string values = 1 [(.google.api.field_behavior) = REQUIRED];</code>
         *
         * @param index The index of the value to return.
         * @return The bytes of the values at the given index.
         */
        com.google.protobuf.ByteString getValuesBytes(int index);
      }
      /**
       *
       *
       * <pre>
       * Represents the spec to match categorical values from parent parameter.
       * </pre>
       *
       * Protobuf type {@code
       * google.cloud.aiplatform.v1beta1.StudySpec.ParameterSpec.ConditionalParameterSpec.CategoricalValueCondition}
       */
      public static final class CategoricalValueCondition
          extends com.google.protobuf.GeneratedMessageV3
          implements
          // @@protoc_insertion_point(message_implements:google.cloud.aiplatform.v1beta1.StudySpec.ParameterSpec.ConditionalParameterSpec.CategoricalValueCondition)
          CategoricalValueConditionOrBuilder {
        private static final long serialVersionUID = 0L;
        // Use CategoricalValueCondition.newBuilder() to construct.
        private CategoricalValueCondition(
            com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
          super(builder);
        }

        private CategoricalValueCondition() {
          values_ = com.google.protobuf.LazyStringArrayList.EMPTY;
        }

        @java.lang.Override
        @SuppressWarnings({"unused"})
        protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
          return new CategoricalValueCondition();
        }

        @java.lang.Override
        public final com.google.protobuf.UnknownFieldSet getUnknownFields() {
          return this.unknownFields;
        }

        private CategoricalValueCondition(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          this();
          if (extensionRegistry == null) {
            throw new java.lang.NullPointerException();
          }
          int mutable_bitField0_ = 0;
          com.google.protobuf.UnknownFieldSet.Builder unknownFields =
              com.google.protobuf.UnknownFieldSet.newBuilder();
          try {
            boolean done = false;
            while (!done) {
              int tag = input.readTag();
              switch (tag) {
                case 0:
                  done = true;
                  break;
                case 10:
                  {
                    java.lang.String s = input.readStringRequireUtf8();
                    if (!((mutable_bitField0_ & 0x00000001) != 0)) {
                      values_ = new com.google.protobuf.LazyStringArrayList();
                      mutable_bitField0_ |= 0x00000001;
                    }
                    values_.add(s);
                    break;
                  }
                default:
                  {
                    if (!parseUnknownField(input, unknownFields, extensionRegistry, tag)) {
                      done = true;
                    }
                    break;
                  }
              }
            }
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.setUnfinishedMessage(this);
          } catch (java.io.IOException e) {
            throw new com.google.protobuf.InvalidProtocolBufferException(e)
                .setUnfinishedMessage(this);
          } finally {
            if (((mutable_bitField0_ & 0x00000001) != 0)) {
              values_ = values_.getUnmodifiableView();
            }
            this.unknownFields = unknownFields.build();
            makeExtensionsImmutable();
          }
        }

        public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
          return com.google.cloud.aiplatform.v1beta1.StudyProto
              .internal_static_google_cloud_aiplatform_v1beta1_StudySpec_ParameterSpec_ConditionalParameterSpec_CategoricalValueCondition_descriptor;
        }

        @java.lang.Override
        protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
            internalGetFieldAccessorTable() {
          return com.google.cloud.aiplatform.v1beta1.StudyProto
              .internal_static_google_cloud_aiplatform_v1beta1_StudySpec_ParameterSpec_ConditionalParameterSpec_CategoricalValueCondition_fieldAccessorTable
              .ensureFieldAccessorsInitialized(
                  com.google.cloud.aiplatform.v1beta1.StudySpec.ParameterSpec
                      .ConditionalParameterSpec.CategoricalValueCondition.class,
                  com.google.cloud.aiplatform.v1beta1.StudySpec.ParameterSpec
                      .ConditionalParameterSpec.CategoricalValueCondition.Builder.class);
        }

        public static final int VALUES_FIELD_NUMBER = 1;
        private com.google.protobuf.LazyStringList values_;
        /**
         *
         *
         * <pre>
         * Required. Matches values of the parent parameter of 'CATEGORICAL' type.
         * All values must exist in `categorical_value_spec` of parent
         * parameter.
         * </pre>
         *
         * <code>repeated string values = 1 [(.google.api.field_behavior) = REQUIRED];</code>
         *
         * @return A list containing the values.
         */
        public com.google.protobuf.ProtocolStringList getValuesList() {
          return values_;
        }
        /**
         *
         *
         * <pre>
         * Required. Matches values of the parent parameter of 'CATEGORICAL' type.
         * All values must exist in `categorical_value_spec` of parent
         * parameter.
         * </pre>
         *
         * <code>repeated string values = 1 [(.google.api.field_behavior) = REQUIRED];</code>
         *
         * @return The count of values.
         */
        public int getValuesCount() {
          return values_.size();
        }
        /**
         *
         *
         * <pre>
         * Required. Matches values of the parent parameter of 'CATEGORICAL' type.
         * All values must exist in `categorical_value_spec` of parent
         * parameter.
         * </pre>
         *
         * <code>repeated string values = 1 [(.google.api.field_behavior) = REQUIRED];</code>
         *
         * @param index The index of the element to return.
         * @return The values at the given index.
         */
        public java.lang.String getValues(int index) {
          return values_.get(index);
        }
        /**
         *
         *
         * <pre>
         * Required. Matches values of the parent parameter of 'CATEGORICAL' type.
         * All values must exist in `categorical_value_spec` of parent
         * parameter.
         * </pre>
         *
         * <code>repeated string values = 1 [(.google.api.field_behavior) = REQUIRED];</code>
         *
         * @param index The index of the value to return.
         * @return The bytes of the values at the given index.
         */
        public com.google.protobuf.ByteString getValuesBytes(int index) {
          return values_.getByteString(index);
        }

        private byte memoizedIsInitialized = -1;

        @java.lang.Override
        public final boolean isInitialized() {
          byte isInitialized = memoizedIsInitialized;
          if (isInitialized == 1) return true;
          if (isInitialized == 0) return false;

          memoizedIsInitialized = 1;
          return true;
        }

        @java.lang.Override
        public void writeTo(com.google.protobuf.CodedOutputStream output)
            throws java.io.IOException {
          for (int i = 0; i < values_.size(); i++) {
            com.google.protobuf.GeneratedMessageV3.writeString(output, 1, values_.getRaw(i));
          }
          unknownFields.writeTo(output);
        }

        @java.lang.Override
        public int getSerializedSize() {
          int size = memoizedSize;
          if (size != -1) return size;

          size = 0;
          {
            int dataSize = 0;
            for (int i = 0; i < values_.size(); i++) {
              dataSize += computeStringSizeNoTag(values_.getRaw(i));
            }
            size += dataSize;
            size += 1 * getValuesList().size();
          }
          size += unknownFields.getSerializedSize();
          memoizedSize = size;
          return size;
        }

        @java.lang.Override
        public boolean equals(final java.lang.Object obj) {
          if (obj == this) {
            return true;
          }
          if (!(obj
              instanceof
              com.google.cloud.aiplatform.v1beta1.StudySpec.ParameterSpec.ConditionalParameterSpec
                  .CategoricalValueCondition)) {
            return super.equals(obj);
          }
          com.google.cloud.aiplatform.v1beta1.StudySpec.ParameterSpec.ConditionalParameterSpec
                  .CategoricalValueCondition
              other =
                  (com.google.cloud.aiplatform.v1beta1.StudySpec.ParameterSpec
                          .ConditionalParameterSpec.CategoricalValueCondition)
                      obj;

          if (!getValuesList().equals(other.getValuesList())) return false;
          if (!unknownFields.equals(other.unknownFields)) return false;
          return true;
        }

        @java.lang.Override
        public int hashCode() {
          if (memoizedHashCode != 0) {
            return memoizedHashCode;
          }
          int hash = 41;
          hash = (19 * hash) + getDescriptor().hashCode();
          if (getValuesCount() > 0) {
            hash = (37 * hash) + VALUES_FIELD_NUMBER;
            hash = (53 * hash) + getValuesList().hashCode();
          }
          hash = (29 * hash) + unknownFields.hashCode();
          memoizedHashCode = hash;
          return hash;
        }

        public static com.google.cloud.aiplatform.v1beta1.StudySpec.ParameterSpec
                .ConditionalParameterSpec.CategoricalValueCondition
            parseFrom(java.nio.ByteBuffer data)
                throws com.google.protobuf.InvalidProtocolBufferException {
          return PARSER.parseFrom(data);
        }

        public static com.google.cloud.aiplatform.v1beta1.StudySpec.ParameterSpec
                .ConditionalParameterSpec.CategoricalValueCondition
            parseFrom(
                java.nio.ByteBuffer data,
                com.google.protobuf.ExtensionRegistryLite extensionRegistry)
                throws com.google.protobuf.InvalidProtocolBufferException {
          return PARSER.parseFrom(data, extensionRegistry);
        }

        public static com.google.cloud.aiplatform.v1beta1.StudySpec.ParameterSpec
                .ConditionalParameterSpec.CategoricalValueCondition
            parseFrom(com.google.protobuf.ByteString data)
                throws com.google.protobuf.InvalidProtocolBufferException {
          return PARSER.parseFrom(data);
        }

        public static com.google.cloud.aiplatform.v1beta1.StudySpec.ParameterSpec
                .ConditionalParameterSpec.CategoricalValueCondition
            parseFrom(
                com.google.protobuf.ByteString data,
                com.google.protobuf.ExtensionRegistryLite extensionRegistry)
                throws com.google.protobuf.InvalidProtocolBufferException {
          return PARSER.parseFrom(data, extensionRegistry);
        }

        public static com.google.cloud.aiplatform.v1beta1.StudySpec.ParameterSpec
                .ConditionalParameterSpec.CategoricalValueCondition
            parseFrom(byte[] data) throws com.google.protobuf.InvalidProtocolBufferException {
          return PARSER.parseFrom(data);
        }

        public static com.google.cloud.aiplatform.v1beta1.StudySpec.ParameterSpec
                .ConditionalParameterSpec.CategoricalValueCondition
            parseFrom(byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
                throws com.google.protobuf.InvalidProtocolBufferException {
          return PARSER.parseFrom(data, extensionRegistry);
        }

        public static com.google.cloud.aiplatform.v1beta1.StudySpec.ParameterSpec
                .ConditionalParameterSpec.CategoricalValueCondition
            parseFrom(java.io.InputStream input) throws java.io.IOException {
          return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
        }

        public static com.google.cloud.aiplatform.v1beta1.StudySpec.ParameterSpec
                .ConditionalParameterSpec.CategoricalValueCondition
            parseFrom(
                java.io.InputStream input,
                com.google.protobuf.ExtensionRegistryLite extensionRegistry)
                throws java.io.IOException {
          return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
              PARSER, input, extensionRegistry);
        }

        public static com.google.cloud.aiplatform.v1beta1.StudySpec.ParameterSpec
                .ConditionalParameterSpec.CategoricalValueCondition
            parseDelimitedFrom(java.io.InputStream input) throws java.io.IOException {
          return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
              PARSER, input);
        }

        public static com.google.cloud.aiplatform.v1beta1.StudySpec.ParameterSpec
                .ConditionalParameterSpec.CategoricalValueCondition
            parseDelimitedFrom(
                java.io.InputStream input,
                com.google.protobuf.ExtensionRegistryLite extensionRegistry)
                throws java.io.IOException {
          return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
              PARSER, input, extensionRegistry);
        }

        public static com.google.cloud.aiplatform.v1beta1.StudySpec.ParameterSpec
                .ConditionalParameterSpec.CategoricalValueCondition
            parseFrom(com.google.protobuf.CodedInputStream input) throws java.io.IOException {
          return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
        }

        public static com.google.cloud.aiplatform.v1beta1.StudySpec.ParameterSpec
                .ConditionalParameterSpec.CategoricalValueCondition
            parseFrom(
                com.google.protobuf.CodedInputStream input,
                com.google.protobuf.ExtensionRegistryLite extensionRegistry)
                throws java.io.IOException {
          return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
              PARSER, input, extensionRegistry);
        }

        @java.lang.Override
        public Builder newBuilderForType() {
          return newBuilder();
        }

        public static Builder newBuilder() {
          return DEFAULT_INSTANCE.toBuilder();
        }

        public static Builder newBuilder(
            com.google.cloud.aiplatform.v1beta1.StudySpec.ParameterSpec.ConditionalParameterSpec
                    .CategoricalValueCondition
                prototype) {
          return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
        }

        @java.lang.Override
        public Builder toBuilder() {
          return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
        }

        @java.lang.Override
        protected Builder newBuilderForType(
            com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
          Builder builder = new Builder(parent);
          return builder;
        }
        /**
         *
         *
         * <pre>
         * Represents the spec to match categorical values from parent parameter.
         * </pre>
         *
         * Protobuf type {@code
         * google.cloud.aiplatform.v1beta1.StudySpec.ParameterSpec.ConditionalParameterSpec.CategoricalValueCondition}
         */
        public static final class Builder
            extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
            implements
            // @@protoc_insertion_point(builder_implements:google.cloud.aiplatform.v1beta1.StudySpec.ParameterSpec.ConditionalParameterSpec.CategoricalValueCondition)
            com.google.cloud.aiplatform.v1beta1.StudySpec.ParameterSpec.ConditionalParameterSpec
                .CategoricalValueConditionOrBuilder {
          public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
            return com.google.cloud.aiplatform.v1beta1.StudyProto
                .internal_static_google_cloud_aiplatform_v1beta1_StudySpec_ParameterSpec_ConditionalParameterSpec_CategoricalValueCondition_descriptor;
          }

          @java.lang.Override
          protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
              internalGetFieldAccessorTable() {
            return com.google.cloud.aiplatform.v1beta1.StudyProto
                .internal_static_google_cloud_aiplatform_v1beta1_StudySpec_ParameterSpec_ConditionalParameterSpec_CategoricalValueCondition_fieldAccessorTable
                .ensureFieldAccessorsInitialized(
                    com.google.cloud.aiplatform.v1beta1.StudySpec.ParameterSpec
                        .ConditionalParameterSpec.CategoricalValueCondition.class,
                    com.google.cloud.aiplatform.v1beta1.StudySpec.ParameterSpec
                        .ConditionalParameterSpec.CategoricalValueCondition.Builder.class);
          }

          // Construct using
          // com.google.cloud.aiplatform.v1beta1.StudySpec.ParameterSpec.ConditionalParameterSpec.CategoricalValueCondition.newBuilder()
          private Builder() {
            maybeForceBuilderInitialization();
          }

          private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
            super(parent);
            maybeForceBuilderInitialization();
          }

          private void maybeForceBuilderInitialization() {
            if (com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders) {}
          }

          @java.lang.Override
          public Builder clear() {
            super.clear();
            values_ = com.google.protobuf.LazyStringArrayList.EMPTY;
            bitField0_ = (bitField0_ & ~0x00000001);
            return this;
          }

          @java.lang.Override
          public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
            return com.google.cloud.aiplatform.v1beta1.StudyProto
                .internal_static_google_cloud_aiplatform_v1beta1_StudySpec_ParameterSpec_ConditionalParameterSpec_CategoricalValueCondition_descriptor;
          }

          @java.lang.Override
          public com.google.cloud.aiplatform.v1beta1.StudySpec.ParameterSpec
                  .ConditionalParameterSpec.CategoricalValueCondition
              getDefaultInstanceForType() {
            return com.google.cloud.aiplatform.v1beta1.StudySpec.ParameterSpec
                .ConditionalParameterSpec.CategoricalValueCondition.getDefaultInstance();
          }

          @java.lang.Override
          public com.google.cloud.aiplatform.v1beta1.StudySpec.ParameterSpec
                  .ConditionalParameterSpec.CategoricalValueCondition
              build() {
            com.google.cloud.aiplatform.v1beta1.StudySpec.ParameterSpec.ConditionalParameterSpec
                    .CategoricalValueCondition
                result = buildPartial();
            if (!result.isInitialized()) {
              throw newUninitializedMessageException(result);
            }
            return result;
          }

          @java.lang.Override
          public com.google.cloud.aiplatform.v1beta1.StudySpec.ParameterSpec
                  .ConditionalParameterSpec.CategoricalValueCondition
              buildPartial() {
            com.google.cloud.aiplatform.v1beta1.StudySpec.ParameterSpec.ConditionalParameterSpec
                    .CategoricalValueCondition
                result =
                    new com.google.cloud.aiplatform.v1beta1.StudySpec.ParameterSpec
                        .ConditionalParameterSpec.CategoricalValueCondition(this);
            int from_bitField0_ = bitField0_;
            if (((bitField0_ & 0x00000001) != 0)) {
              values_ = values_.getUnmodifiableView();
              bitField0_ = (bitField0_ & ~0x00000001);
            }
            result.values_ = values_;
            onBuilt();
            return result;
          }

          @java.lang.Override
          public Builder clone() {
            return super.clone();
          }

          @java.lang.Override
          public Builder setField(
              com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
            return super.setField(field, value);
          }

          @java.lang.Override
          public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
            return super.clearField(field);
          }

          @java.lang.Override
          public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
            return super.clearOneof(oneof);
          }

          @java.lang.Override
          public Builder setRepeatedField(
              com.google.protobuf.Descriptors.FieldDescriptor field,
              int index,
              java.lang.Object value) {
            return super.setRepeatedField(field, index, value);
          }

          @java.lang.Override
          public Builder addRepeatedField(
              com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
            return super.addRepeatedField(field, value);
          }

          @java.lang.Override
          public Builder mergeFrom(com.google.protobuf.Message other) {
            if (other
                instanceof
                com.google.cloud.aiplatform.v1beta1.StudySpec.ParameterSpec.ConditionalParameterSpec
                    .CategoricalValueCondition) {
              return mergeFrom(
                  (com.google.cloud.aiplatform.v1beta1.StudySpec.ParameterSpec
                          .ConditionalParameterSpec.CategoricalValueCondition)
                      other);
            } else {
              super.mergeFrom(other);
              return this;
            }
          }

          public Builder mergeFrom(
              com.google.cloud.aiplatform.v1beta1.StudySpec.ParameterSpec.ConditionalParameterSpec
                      .CategoricalValueCondition
                  other) {
            if (other
                == com.google.cloud.aiplatform.v1beta1.StudySpec.ParameterSpec
                    .ConditionalParameterSpec.CategoricalValueCondition.getDefaultInstance())
              return this;
            if (!other.values_.isEmpty()) {
              if (values_.isEmpty()) {
                values_ = other.values_;
                bitField0_ = (bitField0_ & ~0x00000001);
              } else {
                ensureValuesIsMutable();
                values_.addAll(other.values_);
              }
              onChanged();
            }
            this.mergeUnknownFields(other.unknownFields);
            onChanged();
            return this;
          }

          @java.lang.Override
          public final boolean isInitialized() {
            return true;
          }

          @java.lang.Override
          public Builder mergeFrom(
              com.google.protobuf.CodedInputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws java.io.IOException {
            com.google.cloud.aiplatform.v1beta1.StudySpec.ParameterSpec.ConditionalParameterSpec
                    .CategoricalValueCondition
                parsedMessage = null;
            try {
              parsedMessage = PARSER.parsePartialFrom(input, extensionRegistry);
            } catch (com.google.protobuf.InvalidProtocolBufferException e) {
              parsedMessage =
                  (com.google.cloud.aiplatform.v1beta1.StudySpec.ParameterSpec
                          .ConditionalParameterSpec.CategoricalValueCondition)
                      e.getUnfinishedMessage();
              throw e.unwrapIOException();
            } finally {
              if (parsedMessage != null) {
                mergeFrom(parsedMessage);
              }
            }
            return this;
          }

          private int bitField0_;

          private com.google.protobuf.LazyStringList values_ =
              com.google.protobuf.LazyStringArrayList.EMPTY;

          private void ensureValuesIsMutable() {
            if (!((bitField0_ & 0x00000001) != 0)) {
              values_ = new com.google.protobuf.LazyStringArrayList(values_);
              bitField0_ |= 0x00000001;
            }
          }
          /**
           *
           *
           * <pre>
           * Required. Matches values of the parent parameter of 'CATEGORICAL' type.
           * All values must exist in `categorical_value_spec` of parent
           * parameter.
           * </pre>
           *
           * <code>repeated string values = 1 [(.google.api.field_behavior) = REQUIRED];</code>
           *
           * @return A list containing the values.
           */
          public com.google.protobuf.ProtocolStringList getValuesList() {
            return values_.getUnmodifiableView();
          }
          /**
           *
           *
           * <pre>
           * Required. Matches values of the parent parameter of 'CATEGORICAL' type.
           * All values must exist in `categorical_value_spec` of parent
           * parameter.
           * </pre>
           *
           * <code>repeated string values = 1 [(.google.api.field_behavior) = REQUIRED];</code>
           *
           * @return The count of values.
           */
          public int getValuesCount() {
            return values_.size();
          }
          /**
           *
           *
           * <pre>
           * Required. Matches values of the parent parameter of 'CATEGORICAL' type.
           * All values must exist in `categorical_value_spec` of parent
           * parameter.
           * </pre>
           *
           * <code>repeated string values = 1 [(.google.api.field_behavior) = REQUIRED];</code>
           *
           * @param index The index of the element to return.
           * @return The values at the given index.
           */
          public java.lang.String getValues(int index) {
            return values_.get(index);
          }
          /**
           *
           *
           * <pre>
           * Required. Matches values of the parent parameter of 'CATEGORICAL' type.
           * All values must exist in `categorical_value_spec` of parent
           * parameter.
           * </pre>
           *
           * <code>repeated string values = 1 [(.google.api.field_behavior) = REQUIRED];</code>
           *
           * @param index The index of the value to return.
           * @return The bytes of the values at the given index.
           */
          public com.google.protobuf.ByteString getValuesBytes(int index) {
            return values_.getByteString(index);
          }
          /**
           *
           *
           * <pre>
           * Required. Matches values of the parent parameter of 'CATEGORICAL' type.
           * All values must exist in `categorical_value_spec` of parent
           * parameter.
           * </pre>
           *
           * <code>repeated string values = 1 [(.google.api.field_behavior) = REQUIRED];</code>
           *
           * @param index The index to set the value at.
           * @param value The values to set.
           * @return This builder for chaining.
           */
          public Builder setValues(int index, java.lang.String value) {
            if (value == null) {
              throw new NullPointerException();
            }
            ensureValuesIsMutable();
            values_.set(index, value);
            onChanged();
            return this;
          }
          /**
           *
           *
           * <pre>
           * Required. Matches values of the parent parameter of 'CATEGORICAL' type.
           * All values must exist in `categorical_value_spec` of parent
           * parameter.
           * </pre>
           *
           * <code>repeated string values = 1 [(.google.api.field_behavior) = REQUIRED];</code>
           *
           * @param value The values to add.
           * @return This builder for chaining.
           */
          public Builder addValues(java.lang.String value) {
            if (value == null) {
              throw new NullPointerException();
            }
            ensureValuesIsMutable();
            values_.add(value);
            onChanged();
            return this;
          }
          /**
           *
           *
           * <pre>
           * Required. Matches values of the parent parameter of 'CATEGORICAL' type.
           * All values must exist in `categorical_value_spec` of parent
           * parameter.
           * </pre>
           *
           * <code>repeated string values = 1 [(.google.api.field_behavior) = REQUIRED];</code>
           *
           * @param values The values to add.
           * @return This builder for chaining.
           */
          public Builder addAllValues(java.lang.Iterable<java.lang.String> values) {
            ensureValuesIsMutable();
            com.google.protobuf.AbstractMessageLite.Builder.addAll(values, values_);
            onChanged();
            return this;
          }
          /**
           *
           *
           * <pre>
           * Required. Matches values of the parent parameter of 'CATEGORICAL' type.
           * All values must exist in `categorical_value_spec` of parent
           * parameter.
           * </pre>
           *
           * <code>repeated string values = 1 [(.google.api.field_behavior) = REQUIRED];</code>
           *
           * @return This builder for chaining.
           */
          public Builder clearValues() {
            values_ = com.google.protobuf.LazyStringArrayList.EMPTY;
            bitField0_ = (bitField0_ & ~0x00000001);
            onChanged();
            return this;
          }
          /**
           *
           *
           * <pre>
           * Required. Matches values of the parent parameter of 'CATEGORICAL' type.
           * All values must exist in `categorical_value_spec` of parent
           * parameter.
           * </pre>
           *
           * <code>repeated string values = 1 [(.google.api.field_behavior) = REQUIRED];</code>
           *
           * @param value The bytes of the values to add.
           * @return This builder for chaining.
           */
          public Builder addValuesBytes(com.google.protobuf.ByteString value) {
            if (value == null) {
              throw new NullPointerException();
            }
            checkByteStringIsUtf8(value);
            ensureValuesIsMutable();
            values_.add(value);
            onChanged();
            return this;
          }

          @java.lang.Override
          public final Builder setUnknownFields(
              final com.google.protobuf.UnknownFieldSet unknownFields) {
            return super.setUnknownFields(unknownFields);
          }

          @java.lang.Override
          public final Builder mergeUnknownFields(
              final com.google.protobuf.UnknownFieldSet unknownFields) {
            return super.mergeUnknownFields(unknownFields);
          }

          // @@protoc_insertion_point(builder_scope:google.cloud.aiplatform.v1beta1.StudySpec.ParameterSpec.ConditionalParameterSpec.CategoricalValueCondition)
        }

        // @@protoc_insertion_point(class_scope:google.cloud.aiplatform.v1beta1.StudySpec.ParameterSpec.ConditionalParameterSpec.CategoricalValueCondition)
        private static final com.google.cloud.aiplatform.v1beta1.StudySpec.ParameterSpec
                .ConditionalParameterSpec.CategoricalValueCondition
            DEFAULT_INSTANCE;

        static {
          DEFAULT_INSTANCE =
              new com.google.cloud.aiplatform.v1beta1.StudySpec.ParameterSpec
                  .ConditionalParameterSpec.CategoricalValueCondition();
        }

        public static com.google.cloud.aiplatform.v1beta1.StudySpec.ParameterSpec
                .ConditionalParameterSpec.CategoricalValueCondition
            getDefaultInstance() {
          return DEFAULT_INSTANCE;
        }

        private static final com.google.protobuf.Parser<CategoricalValueCondition> PARSER =
            new com.google.protobuf.AbstractParser<CategoricalValueCondition>() {
              @java.lang.Override
              public CategoricalValueCondition parsePartialFrom(
                  com.google.protobuf.CodedInputStream input,
                  com.google.protobuf.ExtensionRegistryLite extensionRegistry)
                  throws com.google.protobuf.InvalidProtocolBufferException {
                return new CategoricalValueCondition(input, extensionRegistry);
              }
            };

        public static com.google.protobuf.Parser<CategoricalValueCondition> parser() {
          return PARSER;
        }

        @java.lang.Override
        public com.google.protobuf.Parser<CategoricalValueCondition> getParserForType() {
          return PARSER;
        }

        @java.lang.Override
        public com.google.cloud.aiplatform.v1beta1.StudySpec.ParameterSpec.ConditionalParameterSpec
                .CategoricalValueCondition
            getDefaultInstanceForType() {
          return DEFAULT_INSTANCE;
        }
      }

      private int parentValueConditionCase_ = 0;
      private java.lang.Object parentValueCondition_;

      public enum ParentValueConditionCase
          implements
              com.google.protobuf.Internal.EnumLite,
              com.google.protobuf.AbstractMessage.InternalOneOfEnum {
        PARENT_DISCRETE_VALUES(2),
        PARENT_INT_VALUES(3),
        PARENT_CATEGORICAL_VALUES(4),
        PARENTVALUECONDITION_NOT_SET(0);
        private final int value;

        private ParentValueConditionCase(int value) {
          this.value = value;
        }
        /**
         * @param value The number of the enum to look for.
         * @return The enum associated with the given number.
         * @deprecated Use {@link #forNumber(int)} instead.
         */
        @java.lang.Deprecated
        public static ParentValueConditionCase valueOf(int value) {
          return forNumber(value);
        }

        public static ParentValueConditionCase forNumber(int value) {
          switch (value) {
            case 2:
              return PARENT_DISCRETE_VALUES;
            case 3:
              return PARENT_INT_VALUES;
            case 4:
              return PARENT_CATEGORICAL_VALUES;
            case 0:
              return PARENTVALUECONDITION_NOT_SET;
            default:
              return null;
          }
        }

        public int getNumber() {
          return this.value;
        }
      };

      public ParentValueConditionCase getParentValueConditionCase() {
        return ParentValueConditionCase.forNumber(parentValueConditionCase_);
      }

      public static final int PARENT_DISCRETE_VALUES_FIELD_NUMBER = 2;
      /**
       *
       *
       * <pre>
       * The spec for matching values from a parent parameter of
       * `DISCRETE` type.
       * </pre>
       *
       * <code>
       * .google.cloud.aiplatform.v1beta1.StudySpec.ParameterSpec.ConditionalParameterSpec.DiscreteValueCondition parent_discrete_values = 2;
       * </code>
       *
       * @return Whether the parentDiscreteValues field is set.
       */
      @java.lang.Override
      public boolean hasParentDiscreteValues() {
        return parentValueConditionCase_ == 2;
      }
      /**
       *
       *
       * <pre>
       * The spec for matching values from a parent parameter of
       * `DISCRETE` type.
       * </pre>
       *
       * <code>
       * .google.cloud.aiplatform.v1beta1.StudySpec.ParameterSpec.ConditionalParameterSpec.DiscreteValueCondition parent_discrete_values = 2;
       * </code>
       *
       * @return The parentDiscreteValues.
       */
      @java.lang.Override
      public com.google.cloud.aiplatform.v1beta1.StudySpec.ParameterSpec.ConditionalParameterSpec
              .DiscreteValueCondition
          getParentDiscreteValues() {
        if (parentValueConditionCase_ == 2) {
          return (com.google.cloud.aiplatform.v1beta1.StudySpec.ParameterSpec
                  .ConditionalParameterSpec.DiscreteValueCondition)
              parentValueCondition_;
        }
        return com.google.cloud.aiplatform.v1beta1.StudySpec.ParameterSpec.ConditionalParameterSpec
            .DiscreteValueCondition.getDefaultInstance();
      }
      /**
       *
       *
       * <pre>
       * The spec for matching values from a parent parameter of
       * `DISCRETE` type.
       * </pre>
       *
       * <code>
       * .google.cloud.aiplatform.v1beta1.StudySpec.ParameterSpec.ConditionalParameterSpec.DiscreteValueCondition parent_discrete_values = 2;
       * </code>
       */
      @java.lang.Override
      public com.google.cloud.aiplatform.v1beta1.StudySpec.ParameterSpec.ConditionalParameterSpec
              .DiscreteValueConditionOrBuilder
          getParentDiscreteValuesOrBuilder() {
        if (parentValueConditionCase_ == 2) {
          return (com.google.cloud.aiplatform.v1beta1.StudySpec.ParameterSpec
                  .ConditionalParameterSpec.DiscreteValueCondition)
              parentValueCondition_;
        }
        return com.google.cloud.aiplatform.v1beta1.StudySpec.ParameterSpec.ConditionalParameterSpec
            .DiscreteValueCondition.getDefaultInstance();
      }

      public static final int PARENT_INT_VALUES_FIELD_NUMBER = 3;
      /**
       *
       *
       * <pre>
       * The spec for matching values from a parent parameter of `INTEGER`
       * type.
       * </pre>
       *
       * <code>
       * .google.cloud.aiplatform.v1beta1.StudySpec.ParameterSpec.ConditionalParameterSpec.IntValueCondition parent_int_values = 3;
       * </code>
       *
       * @return Whether the parentIntValues field is set.
       */
      @java.lang.Override
      public boolean hasParentIntValues() {
        return parentValueConditionCase_ == 3;
      }
      /**
       *
       *
       * <pre>
       * The spec for matching values from a parent parameter of `INTEGER`
       * type.
       * </pre>
       *
       * <code>
       * .google.cloud.aiplatform.v1beta1.StudySpec.ParameterSpec.ConditionalParameterSpec.IntValueCondition parent_int_values = 3;
       * </code>
       *
       * @return The parentIntValues.
       */
      @java.lang.Override
      public com.google.cloud.aiplatform.v1beta1.StudySpec.ParameterSpec.ConditionalParameterSpec
              .IntValueCondition
          getParentIntValues() {
        if (parentValueConditionCase_ == 3) {
          return (com.google.cloud.aiplatform.v1beta1.StudySpec.ParameterSpec
                  .ConditionalParameterSpec.IntValueCondition)
              parentValueCondition_;
        }
        return com.google.cloud.aiplatform.v1beta1.StudySpec.ParameterSpec.ConditionalParameterSpec
            .IntValueCondition.getDefaultInstance();
      }
      /**
       *
       *
       * <pre>
       * The spec for matching values from a parent parameter of `INTEGER`
       * type.
       * </pre>
       *
       * <code>
       * .google.cloud.aiplatform.v1beta1.StudySpec.ParameterSpec.ConditionalParameterSpec.IntValueCondition parent_int_values = 3;
       * </code>
       */
      @java.lang.Override
      public com.google.cloud.aiplatform.v1beta1.StudySpec.ParameterSpec.ConditionalParameterSpec
              .IntValueConditionOrBuilder
          getParentIntValuesOrBuilder() {
        if (parentValueConditionCase_ == 3) {
          return (com.google.cloud.aiplatform.v1beta1.StudySpec.ParameterSpec
                  .ConditionalParameterSpec.IntValueCondition)
              parentValueCondition_;
        }
        return com.google.cloud.aiplatform.v1beta1.StudySpec.ParameterSpec.ConditionalParameterSpec
            .IntValueCondition.getDefaultInstance();
      }

      public static final int PARENT_CATEGORICAL_VALUES_FIELD_NUMBER = 4;
      /**
       *
       *
       * <pre>
       * The spec for matching values from a parent parameter of
       * `CATEGORICAL` type.
       * </pre>
       *
       * <code>
       * .google.cloud.aiplatform.v1beta1.StudySpec.ParameterSpec.ConditionalParameterSpec.CategoricalValueCondition parent_categorical_values = 4;
       * </code>
       *
       * @return Whether the parentCategoricalValues field is set.
       */
      @java.lang.Override
      public boolean hasParentCategoricalValues() {
        return parentValueConditionCase_ == 4;
      }
      /**
       *
       *
       * <pre>
       * The spec for matching values from a parent parameter of
       * `CATEGORICAL` type.
       * </pre>
       *
       * <code>
       * .google.cloud.aiplatform.v1beta1.StudySpec.ParameterSpec.ConditionalParameterSpec.CategoricalValueCondition parent_categorical_values = 4;
       * </code>
       *
       * @return The parentCategoricalValues.
       */
      @java.lang.Override
      public com.google.cloud.aiplatform.v1beta1.StudySpec.ParameterSpec.ConditionalParameterSpec
              .CategoricalValueCondition
          getParentCategoricalValues() {
        if (parentValueConditionCase_ == 4) {
          return (com.google.cloud.aiplatform.v1beta1.StudySpec.ParameterSpec
                  .ConditionalParameterSpec.CategoricalValueCondition)
              parentValueCondition_;
        }
        return com.google.cloud.aiplatform.v1beta1.StudySpec.ParameterSpec.ConditionalParameterSpec
            .CategoricalValueCondition.getDefaultInstance();
      }
      /**
       *
       *
       * <pre>
       * The spec for matching values from a parent parameter of
       * `CATEGORICAL` type.
       * </pre>
       *
       * <code>
       * .google.cloud.aiplatform.v1beta1.StudySpec.ParameterSpec.ConditionalParameterSpec.CategoricalValueCondition parent_categorical_values = 4;
       * </code>
       */
      @java.lang.Override
      public com.google.cloud.aiplatform.v1beta1.StudySpec.ParameterSpec.ConditionalParameterSpec
              .CategoricalValueConditionOrBuilder
          getParentCategoricalValuesOrBuilder() {
        if (parentValueConditionCase_ == 4) {
          return (com.google.cloud.aiplatform.v1beta1.StudySpec.ParameterSpec
                  .ConditionalParameterSpec.CategoricalValueCondition)
              parentValueCondition_;
        }
        return com.google.cloud.aiplatform.v1beta1.StudySpec.ParameterSpec.ConditionalParameterSpec
            .CategoricalValueCondition.getDefaultInstance();
      }

      public static final int PARAMETER_SPEC_FIELD_NUMBER = 1;
      private com.google.cloud.aiplatform.v1beta1.StudySpec.ParameterSpec parameterSpec_;
      /**
       *
       *
       * <pre>
       * Required. The spec for a conditional parameter.
       * </pre>
       *
       * <code>
       * .google.cloud.aiplatform.v1beta1.StudySpec.ParameterSpec parameter_spec = 1 [(.google.api.field_behavior) = REQUIRED];
       * </code>
       *
       * @return Whether the parameterSpec field is set.
       */
      @java.lang.Override
      public boolean hasParameterSpec() {
        return parameterSpec_ != null;
      }
      /**
       *
       *
       * <pre>
       * Required. The spec for a conditional parameter.
       * </pre>
       *
       * <code>
       * .google.cloud.aiplatform.v1beta1.StudySpec.ParameterSpec parameter_spec = 1 [(.google.api.field_behavior) = REQUIRED];
       * </code>
       *
       * @return The parameterSpec.
       */
      @java.lang.Override
      public com.google.cloud.aiplatform.v1beta1.StudySpec.ParameterSpec getParameterSpec() {
        return parameterSpec_ == null
            ? com.google.cloud.aiplatform.v1beta1.StudySpec.ParameterSpec.getDefaultInstance()
            : parameterSpec_;
      }
      /**
       *
       *
       * <pre>
       * Required. The spec for a conditional parameter.
       * </pre>
       *
       * <code>
       * .google.cloud.aiplatform.v1beta1.StudySpec.ParameterSpec parameter_spec = 1 [(.google.api.field_behavior) = REQUIRED];
       * </code>
       */
      @java.lang.Override
      public com.google.cloud.aiplatform.v1beta1.StudySpec.ParameterSpecOrBuilder
          getParameterSpecOrBuilder() {
        return getParameterSpec();
      }

      private byte memoizedIsInitialized = -1;

      @java.lang.Override
      public final boolean isInitialized() {
        byte isInitialized = memoizedIsInitialized;
        if (isInitialized == 1) return true;
        if (isInitialized == 0) return false;

        memoizedIsInitialized = 1;
        return true;
      }

      @java.lang.Override
      public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
        if (parameterSpec_ != null) {
          output.writeMessage(1, getParameterSpec());
        }
        if (parentValueConditionCase_ == 2) {
          output.writeMessage(
              2,
              (com.google.cloud.aiplatform.v1beta1.StudySpec.ParameterSpec.ConditionalParameterSpec
                      .DiscreteValueCondition)
                  parentValueCondition_);
        }
        if (parentValueConditionCase_ == 3) {
          output.writeMessage(
              3,
              (com.google.cloud.aiplatform.v1beta1.StudySpec.ParameterSpec.ConditionalParameterSpec
                      .IntValueCondition)
                  parentValueCondition_);
        }
        if (parentValueConditionCase_ == 4) {
          output.writeMessage(
              4,
              (com.google.cloud.aiplatform.v1beta1.StudySpec.ParameterSpec.ConditionalParameterSpec
                      .CategoricalValueCondition)
                  parentValueCondition_);
        }
        unknownFields.writeTo(output);
      }

      @java.lang.Override
      public int getSerializedSize() {
        int size = memoizedSize;
        if (size != -1) return size;

        size = 0;
        if (parameterSpec_ != null) {
          size += com.google.protobuf.CodedOutputStream.computeMessageSize(1, getParameterSpec());
        }
        if (parentValueConditionCase_ == 2) {
          size +=
              com.google.protobuf.CodedOutputStream.computeMessageSize(
                  2,
                  (com.google.cloud.aiplatform.v1beta1.StudySpec.ParameterSpec
                          .ConditionalParameterSpec.DiscreteValueCondition)
                      parentValueCondition_);
        }
        if (parentValueConditionCase_ == 3) {
          size +=
              com.google.protobuf.CodedOutputStream.computeMessageSize(
                  3,
                  (com.google.cloud.aiplatform.v1beta1.StudySpec.ParameterSpec
                          .ConditionalParameterSpec.IntValueCondition)
                      parentValueCondition_);
        }
        if (parentValueConditionCase_ == 4) {
          size +=
              com.google.protobuf.CodedOutputStream.computeMessageSize(
                  4,
                  (com.google.cloud.aiplatform.v1beta1.StudySpec.ParameterSpec
                          .ConditionalParameterSpec.CategoricalValueCondition)
                      parentValueCondition_);
        }
        size += unknownFields.getSerializedSize();
        memoizedSize = size;
        return size;
      }

      @java.lang.Override
      public boolean equals(final java.lang.Object obj) {
        if (obj == this) {
          return true;
        }
        if (!(obj
            instanceof
            com.google.cloud.aiplatform.v1beta1.StudySpec.ParameterSpec.ConditionalParameterSpec)) {
          return super.equals(obj);
        }
        com.google.cloud.aiplatform.v1beta1.StudySpec.ParameterSpec.ConditionalParameterSpec other =
            (com.google.cloud.aiplatform.v1beta1.StudySpec.ParameterSpec.ConditionalParameterSpec)
                obj;

        if (hasParameterSpec() != other.hasParameterSpec()) return false;
        if (hasParameterSpec()) {
          if (!getParameterSpec().equals(other.getParameterSpec())) return false;
        }
        if (!getParentValueConditionCase().equals(other.getParentValueConditionCase()))
          return false;
        switch (parentValueConditionCase_) {
          case 2:
            if (!getParentDiscreteValues().equals(other.getParentDiscreteValues())) return false;
            break;
          case 3:
            if (!getParentIntValues().equals(other.getParentIntValues())) return false;
            break;
          case 4:
            if (!getParentCategoricalValues().equals(other.getParentCategoricalValues()))
              return false;
            break;
          case 0:
          default:
        }
        if (!unknownFields.equals(other.unknownFields)) return false;
        return true;
      }

      @java.lang.Override
      public int hashCode() {
        if (memoizedHashCode != 0) {
          return memoizedHashCode;
        }
        int hash = 41;
        hash = (19 * hash) + getDescriptor().hashCode();
        if (hasParameterSpec()) {
          hash = (37 * hash) + PARAMETER_SPEC_FIELD_NUMBER;
          hash = (53 * hash) + getParameterSpec().hashCode();
        }
        switch (parentValueConditionCase_) {
          case 2:
            hash = (37 * hash) + PARENT_DISCRETE_VALUES_FIELD_NUMBER;
            hash = (53 * hash) + getParentDiscreteValues().hashCode();
            break;
          case 3:
            hash = (37 * hash) + PARENT_INT_VALUES_FIELD_NUMBER;
            hash = (53 * hash) + getParentIntValues().hashCode();
            break;
          case 4:
            hash = (37 * hash) + PARENT_CATEGORICAL_VALUES_FIELD_NUMBER;
            hash = (53 * hash) + getParentCategoricalValues().hashCode();
            break;
          case 0:
          default:
        }
        hash = (29 * hash) + unknownFields.hashCode();
        memoizedHashCode = hash;
        return hash;
      }

      public static com.google.cloud.aiplatform.v1beta1.StudySpec.ParameterSpec
              .ConditionalParameterSpec
          parseFrom(java.nio.ByteBuffer data)
              throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data);
      }

      public static com.google.cloud.aiplatform.v1beta1.StudySpec.ParameterSpec
              .ConditionalParameterSpec
          parseFrom(
              java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data, extensionRegistry);
      }

      public static com.google.cloud.aiplatform.v1beta1.StudySpec.ParameterSpec
              .ConditionalParameterSpec
          parseFrom(com.google.protobuf.ByteString data)
              throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data);
      }

      public static com.google.cloud.aiplatform.v1beta1.StudySpec.ParameterSpec
              .ConditionalParameterSpec
          parseFrom(
              com.google.protobuf.ByteString data,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data, extensionRegistry);
      }

      public static com.google.cloud.aiplatform.v1beta1.StudySpec.ParameterSpec
              .ConditionalParameterSpec
          parseFrom(byte[] data) throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data);
      }

      public static com.google.cloud.aiplatform.v1beta1.StudySpec.ParameterSpec
              .ConditionalParameterSpec
          parseFrom(byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data, extensionRegistry);
      }

      public static com.google.cloud.aiplatform.v1beta1.StudySpec.ParameterSpec
              .ConditionalParameterSpec
          parseFrom(java.io.InputStream input) throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
      }

      public static com.google.cloud.aiplatform.v1beta1.StudySpec.ParameterSpec
              .ConditionalParameterSpec
          parseFrom(
              java.io.InputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
            PARSER, input, extensionRegistry);
      }

      public static com.google.cloud.aiplatform.v1beta1.StudySpec.ParameterSpec
              .ConditionalParameterSpec
          parseDelimitedFrom(java.io.InputStream input) throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
      }

      public static com.google.cloud.aiplatform.v1beta1.StudySpec.ParameterSpec
              .ConditionalParameterSpec
          parseDelimitedFrom(
              java.io.InputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
            PARSER, input, extensionRegistry);
      }

      public static com.google.cloud.aiplatform.v1beta1.StudySpec.ParameterSpec
              .ConditionalParameterSpec
          parseFrom(com.google.protobuf.CodedInputStream input) throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
      }

      public static com.google.cloud.aiplatform.v1beta1.StudySpec.ParameterSpec
              .ConditionalParameterSpec
          parseFrom(
              com.google.protobuf.CodedInputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
            PARSER, input, extensionRegistry);
      }

      @java.lang.Override
      public Builder newBuilderForType() {
        return newBuilder();
      }

      public static Builder newBuilder() {
        return DEFAULT_INSTANCE.toBuilder();
      }

      public static Builder newBuilder(
          com.google.cloud.aiplatform.v1beta1.StudySpec.ParameterSpec.ConditionalParameterSpec
              prototype) {
        return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
      }

      @java.lang.Override
      public Builder toBuilder() {
        return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
      }

      @java.lang.Override
      protected Builder newBuilderForType(
          com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
        Builder builder = new Builder(parent);
        return builder;
      }
      /**
       *
       *
       * <pre>
       * Represents a parameter spec with condition from its parent parameter.
       * </pre>
       *
       * Protobuf type {@code
       * google.cloud.aiplatform.v1beta1.StudySpec.ParameterSpec.ConditionalParameterSpec}
       */
      public static final class Builder
          extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
          implements
          // @@protoc_insertion_point(builder_implements:google.cloud.aiplatform.v1beta1.StudySpec.ParameterSpec.ConditionalParameterSpec)
          com.google.cloud.aiplatform.v1beta1.StudySpec.ParameterSpec
              .ConditionalParameterSpecOrBuilder {
        public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
          return com.google.cloud.aiplatform.v1beta1.StudyProto
              .internal_static_google_cloud_aiplatform_v1beta1_StudySpec_ParameterSpec_ConditionalParameterSpec_descriptor;
        }

        @java.lang.Override
        protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
            internalGetFieldAccessorTable() {
          return com.google.cloud.aiplatform.v1beta1.StudyProto
              .internal_static_google_cloud_aiplatform_v1beta1_StudySpec_ParameterSpec_ConditionalParameterSpec_fieldAccessorTable
              .ensureFieldAccessorsInitialized(
                  com.google.cloud.aiplatform.v1beta1.StudySpec.ParameterSpec
                      .ConditionalParameterSpec.class,
                  com.google.cloud.aiplatform.v1beta1.StudySpec.ParameterSpec
                      .ConditionalParameterSpec.Builder.class);
        }

        // Construct using
        // com.google.cloud.aiplatform.v1beta1.StudySpec.ParameterSpec.ConditionalParameterSpec.newBuilder()
        private Builder() {
          maybeForceBuilderInitialization();
        }

        private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
          super(parent);
          maybeForceBuilderInitialization();
        }

        private void maybeForceBuilderInitialization() {
          if (com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders) {}
        }

        @java.lang.Override
        public Builder clear() {
          super.clear();
          if (parameterSpecBuilder_ == null) {
            parameterSpec_ = null;
          } else {
            parameterSpec_ = null;
            parameterSpecBuilder_ = null;
          }
          parentValueConditionCase_ = 0;
          parentValueCondition_ = null;
          return this;
        }

        @java.lang.Override
        public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
          return com.google.cloud.aiplatform.v1beta1.StudyProto
              .internal_static_google_cloud_aiplatform_v1beta1_StudySpec_ParameterSpec_ConditionalParameterSpec_descriptor;
        }

        @java.lang.Override
        public com.google.cloud.aiplatform.v1beta1.StudySpec.ParameterSpec.ConditionalParameterSpec
            getDefaultInstanceForType() {
          return com.google.cloud.aiplatform.v1beta1.StudySpec.ParameterSpec
              .ConditionalParameterSpec.getDefaultInstance();
        }

        @java.lang.Override
        public com.google.cloud.aiplatform.v1beta1.StudySpec.ParameterSpec.ConditionalParameterSpec
            build() {
          com.google.cloud.aiplatform.v1beta1.StudySpec.ParameterSpec.ConditionalParameterSpec
              result = buildPartial();
          if (!result.isInitialized()) {
            throw newUninitializedMessageException(result);
          }
          return result;
        }

        @java.lang.Override
        public com.google.cloud.aiplatform.v1beta1.StudySpec.ParameterSpec.ConditionalParameterSpec
            buildPartial() {
          com.google.cloud.aiplatform.v1beta1.StudySpec.ParameterSpec.ConditionalParameterSpec
              result =
                  new com.google.cloud.aiplatform.v1beta1.StudySpec.ParameterSpec
                      .ConditionalParameterSpec(this);
          if (parentValueConditionCase_ == 2) {
            if (parentDiscreteValuesBuilder_ == null) {
              result.parentValueCondition_ = parentValueCondition_;
            } else {
              result.parentValueCondition_ = parentDiscreteValuesBuilder_.build();
            }
          }
          if (parentValueConditionCase_ == 3) {
            if (parentIntValuesBuilder_ == null) {
              result.parentValueCondition_ = parentValueCondition_;
            } else {
              result.parentValueCondition_ = parentIntValuesBuilder_.build();
            }
          }
          if (parentValueConditionCase_ == 4) {
            if (parentCategoricalValuesBuilder_ == null) {
              result.parentValueCondition_ = parentValueCondition_;
            } else {
              result.parentValueCondition_ = parentCategoricalValuesBuilder_.build();
            }
          }
          if (parameterSpecBuilder_ == null) {
            result.parameterSpec_ = parameterSpec_;
          } else {
            result.parameterSpec_ = parameterSpecBuilder_.build();
          }
          result.parentValueConditionCase_ = parentValueConditionCase_;
          onBuilt();
          return result;
        }

        @java.lang.Override
        public Builder clone() {
          return super.clone();
        }

        @java.lang.Override
        public Builder setField(
            com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
          return super.setField(field, value);
        }

        @java.lang.Override
        public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
          return super.clearField(field);
        }

        @java.lang.Override
        public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
          return super.clearOneof(oneof);
        }

        @java.lang.Override
        public Builder setRepeatedField(
            com.google.protobuf.Descriptors.FieldDescriptor field,
            int index,
            java.lang.Object value) {
          return super.setRepeatedField(field, index, value);
        }

        @java.lang.Override
        public Builder addRepeatedField(
            com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
          return super.addRepeatedField(field, value);
        }

        @java.lang.Override
        public Builder mergeFrom(com.google.protobuf.Message other) {
          if (other
              instanceof
              com.google.cloud.aiplatform.v1beta1.StudySpec.ParameterSpec
                  .ConditionalParameterSpec) {
            return mergeFrom(
                (com.google.cloud.aiplatform.v1beta1.StudySpec.ParameterSpec
                        .ConditionalParameterSpec)
                    other);
          } else {
            super.mergeFrom(other);
            return this;
          }
        }

        public Builder mergeFrom(
            com.google.cloud.aiplatform.v1beta1.StudySpec.ParameterSpec.ConditionalParameterSpec
                other) {
          if (other
              == com.google.cloud.aiplatform.v1beta1.StudySpec.ParameterSpec
                  .ConditionalParameterSpec.getDefaultInstance()) return this;
          if (other.hasParameterSpec()) {
            mergeParameterSpec(other.getParameterSpec());
          }
          switch (other.getParentValueConditionCase()) {
            case PARENT_DISCRETE_VALUES:
              {
                mergeParentDiscreteValues(other.getParentDiscreteValues());
                break;
              }
            case PARENT_INT_VALUES:
              {
                mergeParentIntValues(other.getParentIntValues());
                break;
              }
            case PARENT_CATEGORICAL_VALUES:
              {
                mergeParentCategoricalValues(other.getParentCategoricalValues());
                break;
              }
            case PARENTVALUECONDITION_NOT_SET:
              {
                break;
              }
          }
          this.mergeUnknownFields(other.unknownFields);
          onChanged();
          return this;
        }

        @java.lang.Override
        public final boolean isInitialized() {
          return true;
        }

        @java.lang.Override
        public Builder mergeFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws java.io.IOException {
          com.google.cloud.aiplatform.v1beta1.StudySpec.ParameterSpec.ConditionalParameterSpec
              parsedMessage = null;
          try {
            parsedMessage = PARSER.parsePartialFrom(input, extensionRegistry);
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            parsedMessage =
                (com.google.cloud.aiplatform.v1beta1.StudySpec.ParameterSpec
                        .ConditionalParameterSpec)
                    e.getUnfinishedMessage();
            throw e.unwrapIOException();
          } finally {
            if (parsedMessage != null) {
              mergeFrom(parsedMessage);
            }
          }
          return this;
        }

        private int parentValueConditionCase_ = 0;
        private java.lang.Object parentValueCondition_;

        public ParentValueConditionCase getParentValueConditionCase() {
          return ParentValueConditionCase.forNumber(parentValueConditionCase_);
        }

        public Builder clearParentValueCondition() {
          parentValueConditionCase_ = 0;
          parentValueCondition_ = null;
          onChanged();
          return this;
        }

        private com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.aiplatform.v1beta1.StudySpec.ParameterSpec.ConditionalParameterSpec
                    .DiscreteValueCondition,
                com.google.cloud.aiplatform.v1beta1.StudySpec.ParameterSpec.ConditionalParameterSpec
                    .DiscreteValueCondition.Builder,
                com.google.cloud.aiplatform.v1beta1.StudySpec.ParameterSpec.ConditionalParameterSpec
                    .DiscreteValueConditionOrBuilder>
            parentDiscreteValuesBuilder_;
        /**
         *
         *
         * <pre>
         * The spec for matching values from a parent parameter of
         * `DISCRETE` type.
         * </pre>
         *
         * <code>
         * .google.cloud.aiplatform.v1beta1.StudySpec.ParameterSpec.ConditionalParameterSpec.DiscreteValueCondition parent_discrete_values = 2;
         * </code>
         *
         * @return Whether the parentDiscreteValues field is set.
         */
        @java.lang.Override
        public boolean hasParentDiscreteValues() {
          return parentValueConditionCase_ == 2;
        }
        /**
         *
         *
         * <pre>
         * The spec for matching values from a parent parameter of
         * `DISCRETE` type.
         * </pre>
         *
         * <code>
         * .google.cloud.aiplatform.v1beta1.StudySpec.ParameterSpec.ConditionalParameterSpec.DiscreteValueCondition parent_discrete_values = 2;
         * </code>
         *
         * @return The parentDiscreteValues.
         */
        @java.lang.Override
        public com.google.cloud.aiplatform.v1beta1.StudySpec.ParameterSpec.ConditionalParameterSpec
                .DiscreteValueCondition
            getParentDiscreteValues() {
          if (parentDiscreteValuesBuilder_ == null) {
            if (parentValueConditionCase_ == 2) {
              return (com.google.cloud.aiplatform.v1beta1.StudySpec.ParameterSpec
                      .ConditionalParameterSpec.DiscreteValueCondition)
                  parentValueCondition_;
            }
            return com.google.cloud.aiplatform.v1beta1.StudySpec.ParameterSpec
                .ConditionalParameterSpec.DiscreteValueCondition.getDefaultInstance();
          } else {
            if (parentValueConditionCase_ == 2) {
              return parentDiscreteValuesBuilder_.getMessage();
            }
            return com.google.cloud.aiplatform.v1beta1.StudySpec.ParameterSpec
                .ConditionalParameterSpec.DiscreteValueCondition.getDefaultInstance();
          }
        }
        /**
         *
         *
         * <pre>
         * The spec for matching values from a parent parameter of
         * `DISCRETE` type.
         * </pre>
         *
         * <code>
         * .google.cloud.aiplatform.v1beta1.StudySpec.ParameterSpec.ConditionalParameterSpec.DiscreteValueCondition parent_discrete_values = 2;
         * </code>
         */
        public Builder setParentDiscreteValues(
            com.google.cloud.aiplatform.v1beta1.StudySpec.ParameterSpec.ConditionalParameterSpec
                    .DiscreteValueCondition
                value) {
          if (parentDiscreteValuesBuilder_ == null) {
            if (value == null) {
              throw new NullPointerException();
            }
            parentValueCondition_ = value;
            onChanged();
          } else {
            parentDiscreteValuesBuilder_.setMessage(value);
          }
          parentValueConditionCase_ = 2;
          return this;
        }
        /**
         *
         *
         * <pre>
         * The spec for matching values from a parent parameter of
         * `DISCRETE` type.
         * </pre>
         *
         * <code>
         * .google.cloud.aiplatform.v1beta1.StudySpec.ParameterSpec.ConditionalParameterSpec.DiscreteValueCondition parent_discrete_values = 2;
         * </code>
         */
        public Builder setParentDiscreteValues(
            com.google.cloud.aiplatform.v1beta1.StudySpec.ParameterSpec.ConditionalParameterSpec
                    .DiscreteValueCondition.Builder
                builderForValue) {
          if (parentDiscreteValuesBuilder_ == null) {
            parentValueCondition_ = builderForValue.build();
            onChanged();
          } else {
            parentDiscreteValuesBuilder_.setMessage(builderForValue.build());
          }
          parentValueConditionCase_ = 2;
          return this;
        }
        /**
         *
         *
         * <pre>
         * The spec for matching values from a parent parameter of
         * `DISCRETE` type.
         * </pre>
         *
         * <code>
         * .google.cloud.aiplatform.v1beta1.StudySpec.ParameterSpec.ConditionalParameterSpec.DiscreteValueCondition parent_discrete_values = 2;
         * </code>
         */
        public Builder mergeParentDiscreteValues(
            com.google.cloud.aiplatform.v1beta1.StudySpec.ParameterSpec.ConditionalParameterSpec
                    .DiscreteValueCondition
                value) {
          if (parentDiscreteValuesBuilder_ == null) {
            if (parentValueConditionCase_ == 2
                && parentValueCondition_
                    != com.google.cloud.aiplatform.v1beta1.StudySpec.ParameterSpec
                        .ConditionalParameterSpec.DiscreteValueCondition.getDefaultInstance()) {
              parentValueCondition_ =
                  com.google.cloud.aiplatform.v1beta1.StudySpec.ParameterSpec
                      .ConditionalParameterSpec.DiscreteValueCondition.newBuilder(
                          (com.google.cloud.aiplatform.v1beta1.StudySpec.ParameterSpec
                                  .ConditionalParameterSpec.DiscreteValueCondition)
                              parentValueCondition_)
                      .mergeFrom(value)
                      .buildPartial();
            } else {
              parentValueCondition_ = value;
            }
            onChanged();
          } else {
            if (parentValueConditionCase_ == 2) {
              parentDiscreteValuesBuilder_.mergeFrom(value);
            }
            parentDiscreteValuesBuilder_.setMessage(value);
          }
          parentValueConditionCase_ = 2;
          return this;
        }
        /**
         *
         *
         * <pre>
         * The spec for matching values from a parent parameter of
         * `DISCRETE` type.
         * </pre>
         *
         * <code>
         * .google.cloud.aiplatform.v1beta1.StudySpec.ParameterSpec.ConditionalParameterSpec.DiscreteValueCondition parent_discrete_values = 2;
         * </code>
         */
        public Builder clearParentDiscreteValues() {
          if (parentDiscreteValuesBuilder_ == null) {
            if (parentValueConditionCase_ == 2) {
              parentValueConditionCase_ = 0;
              parentValueCondition_ = null;
              onChanged();
            }
          } else {
            if (parentValueConditionCase_ == 2) {
              parentValueConditionCase_ = 0;
              parentValueCondition_ = null;
            }
            parentDiscreteValuesBuilder_.clear();
          }
          return this;
        }
        /**
         *
         *
         * <pre>
         * The spec for matching values from a parent parameter of
         * `DISCRETE` type.
         * </pre>
         *
         * <code>
         * .google.cloud.aiplatform.v1beta1.StudySpec.ParameterSpec.ConditionalParameterSpec.DiscreteValueCondition parent_discrete_values = 2;
         * </code>
         */
        public com.google.cloud.aiplatform.v1beta1.StudySpec.ParameterSpec.ConditionalParameterSpec
                .DiscreteValueCondition.Builder
            getParentDiscreteValuesBuilder() {
          return getParentDiscreteValuesFieldBuilder().getBuilder();
        }
        /**
         *
         *
         * <pre>
         * The spec for matching values from a parent parameter of
         * `DISCRETE` type.
         * </pre>
         *
         * <code>
         * .google.cloud.aiplatform.v1beta1.StudySpec.ParameterSpec.ConditionalParameterSpec.DiscreteValueCondition parent_discrete_values = 2;
         * </code>
         */
        @java.lang.Override
        public com.google.cloud.aiplatform.v1beta1.StudySpec.ParameterSpec.ConditionalParameterSpec
                .DiscreteValueConditionOrBuilder
            getParentDiscreteValuesOrBuilder() {
          if ((parentValueConditionCase_ == 2) && (parentDiscreteValuesBuilder_ != null)) {
            return parentDiscreteValuesBuilder_.getMessageOrBuilder();
          } else {
            if (parentValueConditionCase_ == 2) {
              return (com.google.cloud.aiplatform.v1beta1.StudySpec.ParameterSpec
                      .ConditionalParameterSpec.DiscreteValueCondition)
                  parentValueCondition_;
            }
            return com.google.cloud.aiplatform.v1beta1.StudySpec.ParameterSpec
                .ConditionalParameterSpec.DiscreteValueCondition.getDefaultInstance();
          }
        }
        /**
         *
         *
         * <pre>
         * The spec for matching values from a parent parameter of
         * `DISCRETE` type.
         * </pre>
         *
         * <code>
         * .google.cloud.aiplatform.v1beta1.StudySpec.ParameterSpec.ConditionalParameterSpec.DiscreteValueCondition parent_discrete_values = 2;
         * </code>
         */
        private com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.aiplatform.v1beta1.StudySpec.ParameterSpec.ConditionalParameterSpec
                    .DiscreteValueCondition,
                com.google.cloud.aiplatform.v1beta1.StudySpec.ParameterSpec.ConditionalParameterSpec
                    .DiscreteValueCondition.Builder,
                com.google.cloud.aiplatform.v1beta1.StudySpec.ParameterSpec.ConditionalParameterSpec
                    .DiscreteValueConditionOrBuilder>
            getParentDiscreteValuesFieldBuilder() {
          if (parentDiscreteValuesBuilder_ == null) {
            if (!(parentValueConditionCase_ == 2)) {
              parentValueCondition_ =
                  com.google.cloud.aiplatform.v1beta1.StudySpec.ParameterSpec
                      .ConditionalParameterSpec.DiscreteValueCondition.getDefaultInstance();
            }
            parentDiscreteValuesBuilder_ =
                new com.google.protobuf.SingleFieldBuilderV3<
                    com.google.cloud.aiplatform.v1beta1.StudySpec.ParameterSpec
                        .ConditionalParameterSpec.DiscreteValueCondition,
                    com.google.cloud.aiplatform.v1beta1.StudySpec.ParameterSpec
                        .ConditionalParameterSpec.DiscreteValueCondition.Builder,
                    com.google.cloud.aiplatform.v1beta1.StudySpec.ParameterSpec
                        .ConditionalParameterSpec.DiscreteValueConditionOrBuilder>(
                    (com.google.cloud.aiplatform.v1beta1.StudySpec.ParameterSpec
                            .ConditionalParameterSpec.DiscreteValueCondition)
                        parentValueCondition_,
                    getParentForChildren(),
                    isClean());
            parentValueCondition_ = null;
          }
          parentValueConditionCase_ = 2;
          onChanged();
          ;
          return parentDiscreteValuesBuilder_;
        }

        private com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.aiplatform.v1beta1.StudySpec.ParameterSpec.ConditionalParameterSpec
                    .IntValueCondition,
                com.google.cloud.aiplatform.v1beta1.StudySpec.ParameterSpec.ConditionalParameterSpec
                    .IntValueCondition.Builder,
                com.google.cloud.aiplatform.v1beta1.StudySpec.ParameterSpec.ConditionalParameterSpec
                    .IntValueConditionOrBuilder>
            parentIntValuesBuilder_;
        /**
         *
         *
         * <pre>
         * The spec for matching values from a parent parameter of `INTEGER`
         * type.
         * </pre>
         *
         * <code>
         * .google.cloud.aiplatform.v1beta1.StudySpec.ParameterSpec.ConditionalParameterSpec.IntValueCondition parent_int_values = 3;
         * </code>
         *
         * @return Whether the parentIntValues field is set.
         */
        @java.lang.Override
        public boolean hasParentIntValues() {
          return parentValueConditionCase_ == 3;
        }
        /**
         *
         *
         * <pre>
         * The spec for matching values from a parent parameter of `INTEGER`
         * type.
         * </pre>
         *
         * <code>
         * .google.cloud.aiplatform.v1beta1.StudySpec.ParameterSpec.ConditionalParameterSpec.IntValueCondition parent_int_values = 3;
         * </code>
         *
         * @return The parentIntValues.
         */
        @java.lang.Override
        public com.google.cloud.aiplatform.v1beta1.StudySpec.ParameterSpec.ConditionalParameterSpec
                .IntValueCondition
            getParentIntValues() {
          if (parentIntValuesBuilder_ == null) {
            if (parentValueConditionCase_ == 3) {
              return (com.google.cloud.aiplatform.v1beta1.StudySpec.ParameterSpec
                      .ConditionalParameterSpec.IntValueCondition)
                  parentValueCondition_;
            }
            return com.google.cloud.aiplatform.v1beta1.StudySpec.ParameterSpec
                .ConditionalParameterSpec.IntValueCondition.getDefaultInstance();
          } else {
            if (parentValueConditionCase_ == 3) {
              return parentIntValuesBuilder_.getMessage();
            }
            return com.google.cloud.aiplatform.v1beta1.StudySpec.ParameterSpec
                .ConditionalParameterSpec.IntValueCondition.getDefaultInstance();
          }
        }
        /**
         *
         *
         * <pre>
         * The spec for matching values from a parent parameter of `INTEGER`
         * type.
         * </pre>
         *
         * <code>
         * .google.cloud.aiplatform.v1beta1.StudySpec.ParameterSpec.ConditionalParameterSpec.IntValueCondition parent_int_values = 3;
         * </code>
         */
        public Builder setParentIntValues(
            com.google.cloud.aiplatform.v1beta1.StudySpec.ParameterSpec.ConditionalParameterSpec
                    .IntValueCondition
                value) {
          if (parentIntValuesBuilder_ == null) {
            if (value == null) {
              throw new NullPointerException();
            }
            parentValueCondition_ = value;
            onChanged();
          } else {
            parentIntValuesBuilder_.setMessage(value);
          }
          parentValueConditionCase_ = 3;
          return this;
        }
        /**
         *
         *
         * <pre>
         * The spec for matching values from a parent parameter of `INTEGER`
         * type.
         * </pre>
         *
         * <code>
         * .google.cloud.aiplatform.v1beta1.StudySpec.ParameterSpec.ConditionalParameterSpec.IntValueCondition parent_int_values = 3;
         * </code>
         */
        public Builder setParentIntValues(
            com.google.cloud.aiplatform.v1beta1.StudySpec.ParameterSpec.ConditionalParameterSpec
                    .IntValueCondition.Builder
                builderForValue) {
          if (parentIntValuesBuilder_ == null) {
            parentValueCondition_ = builderForValue.build();
            onChanged();
          } else {
            parentIntValuesBuilder_.setMessage(builderForValue.build());
          }
          parentValueConditionCase_ = 3;
          return this;
        }
        /**
         *
         *
         * <pre>
         * The spec for matching values from a parent parameter of `INTEGER`
         * type.
         * </pre>
         *
         * <code>
         * .google.cloud.aiplatform.v1beta1.StudySpec.ParameterSpec.ConditionalParameterSpec.IntValueCondition parent_int_values = 3;
         * </code>
         */
        public Builder mergeParentIntValues(
            com.google.cloud.aiplatform.v1beta1.StudySpec.ParameterSpec.ConditionalParameterSpec
                    .IntValueCondition
                value) {
          if (parentIntValuesBuilder_ == null) {
            if (parentValueConditionCase_ == 3
                && parentValueCondition_
                    != com.google.cloud.aiplatform.v1beta1.StudySpec.ParameterSpec
                        .ConditionalParameterSpec.IntValueCondition.getDefaultInstance()) {
              parentValueCondition_ =
                  com.google.cloud.aiplatform.v1beta1.StudySpec.ParameterSpec
                      .ConditionalParameterSpec.IntValueCondition.newBuilder(
                          (com.google.cloud.aiplatform.v1beta1.StudySpec.ParameterSpec
                                  .ConditionalParameterSpec.IntValueCondition)
                              parentValueCondition_)
                      .mergeFrom(value)
                      .buildPartial();
            } else {
              parentValueCondition_ = value;
            }
            onChanged();
          } else {
            if (parentValueConditionCase_ == 3) {
              parentIntValuesBuilder_.mergeFrom(value);
            }
            parentIntValuesBuilder_.setMessage(value);
          }
          parentValueConditionCase_ = 3;
          return this;
        }
        /**
         *
         *
         * <pre>
         * The spec for matching values from a parent parameter of `INTEGER`
         * type.
         * </pre>
         *
         * <code>
         * .google.cloud.aiplatform.v1beta1.StudySpec.ParameterSpec.ConditionalParameterSpec.IntValueCondition parent_int_values = 3;
         * </code>
         */
        public Builder clearParentIntValues() {
          if (parentIntValuesBuilder_ == null) {
            if (parentValueConditionCase_ == 3) {
              parentValueConditionCase_ = 0;
              parentValueCondition_ = null;
              onChanged();
            }
          } else {
            if (parentValueConditionCase_ == 3) {
              parentValueConditionCase_ = 0;
              parentValueCondition_ = null;
            }
            parentIntValuesBuilder_.clear();
          }
          return this;
        }
        /**
         *
         *
         * <pre>
         * The spec for matching values from a parent parameter of `INTEGER`
         * type.
         * </pre>
         *
         * <code>
         * .google.cloud.aiplatform.v1beta1.StudySpec.ParameterSpec.ConditionalParameterSpec.IntValueCondition parent_int_values = 3;
         * </code>
         */
        public com.google.cloud.aiplatform.v1beta1.StudySpec.ParameterSpec.ConditionalParameterSpec
                .IntValueCondition.Builder
            getParentIntValuesBuilder() {
          return getParentIntValuesFieldBuilder().getBuilder();
        }
        /**
         *
         *
         * <pre>
         * The spec for matching values from a parent parameter of `INTEGER`
         * type.
         * </pre>
         *
         * <code>
         * .google.cloud.aiplatform.v1beta1.StudySpec.ParameterSpec.ConditionalParameterSpec.IntValueCondition parent_int_values = 3;
         * </code>
         */
        @java.lang.Override
        public com.google.cloud.aiplatform.v1beta1.StudySpec.ParameterSpec.ConditionalParameterSpec
                .IntValueConditionOrBuilder
            getParentIntValuesOrBuilder() {
          if ((parentValueConditionCase_ == 3) && (parentIntValuesBuilder_ != null)) {
            return parentIntValuesBuilder_.getMessageOrBuilder();
          } else {
            if (parentValueConditionCase_ == 3) {
              return (com.google.cloud.aiplatform.v1beta1.StudySpec.ParameterSpec
                      .ConditionalParameterSpec.IntValueCondition)
                  parentValueCondition_;
            }
            return com.google.cloud.aiplatform.v1beta1.StudySpec.ParameterSpec
                .ConditionalParameterSpec.IntValueCondition.getDefaultInstance();
          }
        }
        /**
         *
         *
         * <pre>
         * The spec for matching values from a parent parameter of `INTEGER`
         * type.
         * </pre>
         *
         * <code>
         * .google.cloud.aiplatform.v1beta1.StudySpec.ParameterSpec.ConditionalParameterSpec.IntValueCondition parent_int_values = 3;
         * </code>
         */
        private com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.aiplatform.v1beta1.StudySpec.ParameterSpec.ConditionalParameterSpec
                    .IntValueCondition,
                com.google.cloud.aiplatform.v1beta1.StudySpec.ParameterSpec.ConditionalParameterSpec
                    .IntValueCondition.Builder,
                com.google.cloud.aiplatform.v1beta1.StudySpec.ParameterSpec.ConditionalParameterSpec
                    .IntValueConditionOrBuilder>
            getParentIntValuesFieldBuilder() {
          if (parentIntValuesBuilder_ == null) {
            if (!(parentValueConditionCase_ == 3)) {
              parentValueCondition_ =
                  com.google.cloud.aiplatform.v1beta1.StudySpec.ParameterSpec
                      .ConditionalParameterSpec.IntValueCondition.getDefaultInstance();
            }
            parentIntValuesBuilder_ =
                new com.google.protobuf.SingleFieldBuilderV3<
                    com.google.cloud.aiplatform.v1beta1.StudySpec.ParameterSpec
                        .ConditionalParameterSpec.IntValueCondition,
                    com.google.cloud.aiplatform.v1beta1.StudySpec.ParameterSpec
                        .ConditionalParameterSpec.IntValueCondition.Builder,
                    com.google.cloud.aiplatform.v1beta1.StudySpec.ParameterSpec
                        .ConditionalParameterSpec.IntValueConditionOrBuilder>(
                    (com.google.cloud.aiplatform.v1beta1.StudySpec.ParameterSpec
                            .ConditionalParameterSpec.IntValueCondition)
                        parentValueCondition_,
                    getParentForChildren(),
                    isClean());
            parentValueCondition_ = null;
          }
          parentValueConditionCase_ = 3;
          onChanged();
          ;
          return parentIntValuesBuilder_;
        }

        private com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.aiplatform.v1beta1.StudySpec.ParameterSpec.ConditionalParameterSpec
                    .CategoricalValueCondition,
                com.google.cloud.aiplatform.v1beta1.StudySpec.ParameterSpec.ConditionalParameterSpec
                    .CategoricalValueCondition.Builder,
                com.google.cloud.aiplatform.v1beta1.StudySpec.ParameterSpec.ConditionalParameterSpec
                    .CategoricalValueConditionOrBuilder>
            parentCategoricalValuesBuilder_;
        /**
         *
         *
         * <pre>
         * The spec for matching values from a parent parameter of
         * `CATEGORICAL` type.
         * </pre>
         *
         * <code>
         * .google.cloud.aiplatform.v1beta1.StudySpec.ParameterSpec.ConditionalParameterSpec.CategoricalValueCondition parent_categorical_values = 4;
         * </code>
         *
         * @return Whether the parentCategoricalValues field is set.
         */
        @java.lang.Override
        public boolean hasParentCategoricalValues() {
          return parentValueConditionCase_ == 4;
        }
        /**
         *
         *
         * <pre>
         * The spec for matching values from a parent parameter of
         * `CATEGORICAL` type.
         * </pre>
         *
         * <code>
         * .google.cloud.aiplatform.v1beta1.StudySpec.ParameterSpec.ConditionalParameterSpec.CategoricalValueCondition parent_categorical_values = 4;
         * </code>
         *
         * @return The parentCategoricalValues.
         */
        @java.lang.Override
        public com.google.cloud.aiplatform.v1beta1.StudySpec.ParameterSpec.ConditionalParameterSpec
                .CategoricalValueCondition
            getParentCategoricalValues() {
          if (parentCategoricalValuesBuilder_ == null) {
            if (parentValueConditionCase_ == 4) {
              return (com.google.cloud.aiplatform.v1beta1.StudySpec.ParameterSpec
                      .ConditionalParameterSpec.CategoricalValueCondition)
                  parentValueCondition_;
            }
            return com.google.cloud.aiplatform.v1beta1.StudySpec.ParameterSpec
                .ConditionalParameterSpec.CategoricalValueCondition.getDefaultInstance();
          } else {
            if (parentValueConditionCase_ == 4) {
              return parentCategoricalValuesBuilder_.getMessage();
            }
            return com.google.cloud.aiplatform.v1beta1.StudySpec.ParameterSpec
                .ConditionalParameterSpec.CategoricalValueCondition.getDefaultInstance();
          }
        }
        /**
         *
         *
         * <pre>
         * The spec for matching values from a parent parameter of
         * `CATEGORICAL` type.
         * </pre>
         *
         * <code>
         * .google.cloud.aiplatform.v1beta1.StudySpec.ParameterSpec.ConditionalParameterSpec.CategoricalValueCondition parent_categorical_values = 4;
         * </code>
         */
        public Builder setParentCategoricalValues(
            com.google.cloud.aiplatform.v1beta1.StudySpec.ParameterSpec.ConditionalParameterSpec
                    .CategoricalValueCondition
                value) {
          if (parentCategoricalValuesBuilder_ == null) {
            if (value == null) {
              throw new NullPointerException();
            }
            parentValueCondition_ = value;
            onChanged();
          } else {
            parentCategoricalValuesBuilder_.setMessage(value);
          }
          parentValueConditionCase_ = 4;
          return this;
        }
        /**
         *
         *
         * <pre>
         * The spec for matching values from a parent parameter of
         * `CATEGORICAL` type.
         * </pre>
         *
         * <code>
         * .google.cloud.aiplatform.v1beta1.StudySpec.ParameterSpec.ConditionalParameterSpec.CategoricalValueCondition parent_categorical_values = 4;
         * </code>
         */
        public Builder setParentCategoricalValues(
            com.google.cloud.aiplatform.v1beta1.StudySpec.ParameterSpec.ConditionalParameterSpec
                    .CategoricalValueCondition.Builder
                builderForValue) {
          if (parentCategoricalValuesBuilder_ == null) {
            parentValueCondition_ = builderForValue.build();
            onChanged();
          } else {
            parentCategoricalValuesBuilder_.setMessage(builderForValue.build());
          }
          parentValueConditionCase_ = 4;
          return this;
        }
        /**
         *
         *
         * <pre>
         * The spec for matching values from a parent parameter of
         * `CATEGORICAL` type.
         * </pre>
         *
         * <code>
         * .google.cloud.aiplatform.v1beta1.StudySpec.ParameterSpec.ConditionalParameterSpec.CategoricalValueCondition parent_categorical_values = 4;
         * </code>
         */
        public Builder mergeParentCategoricalValues(
            com.google.cloud.aiplatform.v1beta1.StudySpec.ParameterSpec.ConditionalParameterSpec
                    .CategoricalValueCondition
                value) {
          if (parentCategoricalValuesBuilder_ == null) {
            if (parentValueConditionCase_ == 4
                && parentValueCondition_
                    != com.google.cloud.aiplatform.v1beta1.StudySpec.ParameterSpec
                        .ConditionalParameterSpec.CategoricalValueCondition.getDefaultInstance()) {
              parentValueCondition_ =
                  com.google.cloud.aiplatform.v1beta1.StudySpec.ParameterSpec
                      .ConditionalParameterSpec.CategoricalValueCondition.newBuilder(
                          (com.google.cloud.aiplatform.v1beta1.StudySpec.ParameterSpec
                                  .ConditionalParameterSpec.CategoricalValueCondition)
                              parentValueCondition_)
                      .mergeFrom(value)
                      .buildPartial();
            } else {
              parentValueCondition_ = value;
            }
            onChanged();
          } else {
            if (parentValueConditionCase_ == 4) {
              parentCategoricalValuesBuilder_.mergeFrom(value);
            }
            parentCategoricalValuesBuilder_.setMessage(value);
          }
          parentValueConditionCase_ = 4;
          return this;
        }
        /**
         *
         *
         * <pre>
         * The spec for matching values from a parent parameter of
         * `CATEGORICAL` type.
         * </pre>
         *
         * <code>
         * .google.cloud.aiplatform.v1beta1.StudySpec.ParameterSpec.ConditionalParameterSpec.CategoricalValueCondition parent_categorical_values = 4;
         * </code>
         */
        public Builder clearParentCategoricalValues() {
          if (parentCategoricalValuesBuilder_ == null) {
            if (parentValueConditionCase_ == 4) {
              parentValueConditionCase_ = 0;
              parentValueCondition_ = null;
              onChanged();
            }
          } else {
            if (parentValueConditionCase_ == 4) {
              parentValueConditionCase_ = 0;
              parentValueCondition_ = null;
            }
            parentCategoricalValuesBuilder_.clear();
          }
          return this;
        }
        /**
         *
         *
         * <pre>
         * The spec for matching values from a parent parameter of
         * `CATEGORICAL` type.
         * </pre>
         *
         * <code>
         * .google.cloud.aiplatform.v1beta1.StudySpec.ParameterSpec.ConditionalParameterSpec.CategoricalValueCondition parent_categorical_values = 4;
         * </code>
         */
        public com.google.cloud.aiplatform.v1beta1.StudySpec.ParameterSpec.ConditionalParameterSpec
                .CategoricalValueCondition.Builder
            getParentCategoricalValuesBuilder() {
          return getParentCategoricalValuesFieldBuilder().getBuilder();
        }
        /**
         *
         *
         * <pre>
         * The spec for matching values from a parent parameter of
         * `CATEGORICAL` type.
         * </pre>
         *
         * <code>
         * .google.cloud.aiplatform.v1beta1.StudySpec.ParameterSpec.ConditionalParameterSpec.CategoricalValueCondition parent_categorical_values = 4;
         * </code>
         */
        @java.lang.Override
        public com.google.cloud.aiplatform.v1beta1.StudySpec.ParameterSpec.ConditionalParameterSpec
                .CategoricalValueConditionOrBuilder
            getParentCategoricalValuesOrBuilder() {
          if ((parentValueConditionCase_ == 4) && (parentCategoricalValuesBuilder_ != null)) {
            return parentCategoricalValuesBuilder_.getMessageOrBuilder();
          } else {
            if (parentValueConditionCase_ == 4) {
              return (com.google.cloud.aiplatform.v1beta1.StudySpec.ParameterSpec
                      .ConditionalParameterSpec.CategoricalValueCondition)
                  parentValueCondition_;
            }
            return com.google.cloud.aiplatform.v1beta1.StudySpec.ParameterSpec
                .ConditionalParameterSpec.CategoricalValueCondition.getDefaultInstance();
          }
        }
        /**
         *
         *
         * <pre>
         * The spec for matching values from a parent parameter of
         * `CATEGORICAL` type.
         * </pre>
         *
         * <code>
         * .google.cloud.aiplatform.v1beta1.StudySpec.ParameterSpec.ConditionalParameterSpec.CategoricalValueCondition parent_categorical_values = 4;
         * </code>
         */
        private com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.aiplatform.v1beta1.StudySpec.ParameterSpec.ConditionalParameterSpec
                    .CategoricalValueCondition,
                com.google.cloud.aiplatform.v1beta1.StudySpec.ParameterSpec.ConditionalParameterSpec
                    .CategoricalValueCondition.Builder,
                com.google.cloud.aiplatform.v1beta1.StudySpec.ParameterSpec.ConditionalParameterSpec
                    .CategoricalValueConditionOrBuilder>
            getParentCategoricalValuesFieldBuilder() {
          if (parentCategoricalValuesBuilder_ == null) {
            if (!(parentValueConditionCase_ == 4)) {
              parentValueCondition_ =
                  com.google.cloud.aiplatform.v1beta1.StudySpec.ParameterSpec
                      .ConditionalParameterSpec.CategoricalValueCondition.getDefaultInstance();
            }
            parentCategoricalValuesBuilder_ =
                new com.google.protobuf.SingleFieldBuilderV3<
                    com.google.cloud.aiplatform.v1beta1.StudySpec.ParameterSpec
                        .ConditionalParameterSpec.CategoricalValueCondition,
                    com.google.cloud.aiplatform.v1beta1.StudySpec.ParameterSpec
                        .ConditionalParameterSpec.CategoricalValueCondition.Builder,
                    com.google.cloud.aiplatform.v1beta1.StudySpec.ParameterSpec
                        .ConditionalParameterSpec.CategoricalValueConditionOrBuilder>(
                    (com.google.cloud.aiplatform.v1beta1.StudySpec.ParameterSpec
                            .ConditionalParameterSpec.CategoricalValueCondition)
                        parentValueCondition_,
                    getParentForChildren(),
                    isClean());
            parentValueCondition_ = null;
          }
          parentValueConditionCase_ = 4;
          onChanged();
          ;
          return parentCategoricalValuesBuilder_;
        }

        private com.google.cloud.aiplatform.v1beta1.StudySpec.ParameterSpec parameterSpec_;
        private com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.aiplatform.v1beta1.StudySpec.ParameterSpec,
                com.google.cloud.aiplatform.v1beta1.StudySpec.ParameterSpec.Builder,
                com.google.cloud.aiplatform.v1beta1.StudySpec.ParameterSpecOrBuilder>
            parameterSpecBuilder_;
        /**
         *
         *
         * <pre>
         * Required. The spec for a conditional parameter.
         * </pre>
         *
         * <code>
         * .google.cloud.aiplatform.v1beta1.StudySpec.ParameterSpec parameter_spec = 1 [(.google.api.field_behavior) = REQUIRED];
         * </code>
         *
         * @return Whether the parameterSpec field is set.
         */
        public boolean hasParameterSpec() {
          return parameterSpecBuilder_ != null || parameterSpec_ != null;
        }
        /**
         *
         *
         * <pre>
         * Required. The spec for a conditional parameter.
         * </pre>
         *
         * <code>
         * .google.cloud.aiplatform.v1beta1.StudySpec.ParameterSpec parameter_spec = 1 [(.google.api.field_behavior) = REQUIRED];
         * </code>
         *
         * @return The parameterSpec.
         */
        public com.google.cloud.aiplatform.v1beta1.StudySpec.ParameterSpec getParameterSpec() {
          if (parameterSpecBuilder_ == null) {
            return parameterSpec_ == null
                ? com.google.cloud.aiplatform.v1beta1.StudySpec.ParameterSpec.getDefaultInstance()
                : parameterSpec_;
          } else {
            return parameterSpecBuilder_.getMessage();
          }
        }
        /**
         *
         *
         * <pre>
         * Required. The spec for a conditional parameter.
         * </pre>
         *
         * <code>
         * .google.cloud.aiplatform.v1beta1.StudySpec.ParameterSpec parameter_spec = 1 [(.google.api.field_behavior) = REQUIRED];
         * </code>
         */
        public Builder setParameterSpec(
            com.google.cloud.aiplatform.v1beta1.StudySpec.ParameterSpec value) {
          if (parameterSpecBuilder_ == null) {
            if (value == null) {
              throw new NullPointerException();
            }
            parameterSpec_ = value;
            onChanged();
          } else {
            parameterSpecBuilder_.setMessage(value);
          }

          return this;
        }
        /**
         *
         *
         * <pre>
         * Required. The spec for a conditional parameter.
         * </pre>
         *
         * <code>
         * .google.cloud.aiplatform.v1beta1.StudySpec.ParameterSpec parameter_spec = 1 [(.google.api.field_behavior) = REQUIRED];
         * </code>
         */
        public Builder setParameterSpec(
            com.google.cloud.aiplatform.v1beta1.StudySpec.ParameterSpec.Builder builderForValue) {
          if (parameterSpecBuilder_ == null) {
            parameterSpec_ = builderForValue.build();
            onChanged();
          } else {
            parameterSpecBuilder_.setMessage(builderForValue.build());
          }

          return this;
        }
        /**
         *
         *
         * <pre>
         * Required. The spec for a conditional parameter.
         * </pre>
         *
         * <code>
         * .google.cloud.aiplatform.v1beta1.StudySpec.ParameterSpec parameter_spec = 1 [(.google.api.field_behavior) = REQUIRED];
         * </code>
         */
        public Builder mergeParameterSpec(
            com.google.cloud.aiplatform.v1beta1.StudySpec.ParameterSpec value) {
          if (parameterSpecBuilder_ == null) {
            if (parameterSpec_ != null) {
              parameterSpec_ =
                  com.google.cloud.aiplatform.v1beta1.StudySpec.ParameterSpec.newBuilder(
                          parameterSpec_)
                      .mergeFrom(value)
                      .buildPartial();
            } else {
              parameterSpec_ = value;
            }
            onChanged();
          } else {
            parameterSpecBuilder_.mergeFrom(value);
          }

          return this;
        }
        /**
         *
         *
         * <pre>
         * Required. The spec for a conditional parameter.
         * </pre>
         *
         * <code>
         * .google.cloud.aiplatform.v1beta1.StudySpec.ParameterSpec parameter_spec = 1 [(.google.api.field_behavior) = REQUIRED];
         * </code>
         */
        public Builder clearParameterSpec() {
          if (parameterSpecBuilder_ == null) {
            parameterSpec_ = null;
            onChanged();
          } else {
            parameterSpec_ = null;
            parameterSpecBuilder_ = null;
          }

          return this;
        }
        /**
         *
         *
         * <pre>
         * Required. The spec for a conditional parameter.
         * </pre>
         *
         * <code>
         * .google.cloud.aiplatform.v1beta1.StudySpec.ParameterSpec parameter_spec = 1 [(.google.api.field_behavior) = REQUIRED];
         * </code>
         */
        public com.google.cloud.aiplatform.v1beta1.StudySpec.ParameterSpec.Builder
            getParameterSpecBuilder() {

          onChanged();
          return getParameterSpecFieldBuilder().getBuilder();
        }
        /**
         *
         *
         * <pre>
         * Required. The spec for a conditional parameter.
         * </pre>
         *
         * <code>
         * .google.cloud.aiplatform.v1beta1.StudySpec.ParameterSpec parameter_spec = 1 [(.google.api.field_behavior) = REQUIRED];
         * </code>
         */
        public com.google.cloud.aiplatform.v1beta1.StudySpec.ParameterSpecOrBuilder
            getParameterSpecOrBuilder() {
          if (parameterSpecBuilder_ != null) {
            return parameterSpecBuilder_.getMessageOrBuilder();
          } else {
            return parameterSpec_ == null
                ? com.google.cloud.aiplatform.v1beta1.StudySpec.ParameterSpec.getDefaultInstance()
                : parameterSpec_;
          }
        }
        /**
         *
         *
         * <pre>
         * Required. The spec for a conditional parameter.
         * </pre>
         *
         * <code>
         * .google.cloud.aiplatform.v1beta1.StudySpec.ParameterSpec parameter_spec = 1 [(.google.api.field_behavior) = REQUIRED];
         * </code>
         */
        private com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.aiplatform.v1beta1.StudySpec.ParameterSpec,
                com.google.cloud.aiplatform.v1beta1.StudySpec.ParameterSpec.Builder,
                com.google.cloud.aiplatform.v1beta1.StudySpec.ParameterSpecOrBuilder>
            getParameterSpecFieldBuilder() {
          if (parameterSpecBuilder_ == null) {
            parameterSpecBuilder_ =
                new com.google.protobuf.SingleFieldBuilderV3<
                    com.google.cloud.aiplatform.v1beta1.StudySpec.ParameterSpec,
                    com.google.cloud.aiplatform.v1beta1.StudySpec.ParameterSpec.Builder,
                    com.google.cloud.aiplatform.v1beta1.StudySpec.ParameterSpecOrBuilder>(
                    getParameterSpec(), getParentForChildren(), isClean());
            parameterSpec_ = null;
          }
          return parameterSpecBuilder_;
        }

        @java.lang.Override
        public final Builder setUnknownFields(
            final com.google.protobuf.UnknownFieldSet unknownFields) {
          return super.setUnknownFields(unknownFields);
        }

        @java.lang.Override
        public final Builder mergeUnknownFields(
            final com.google.protobuf.UnknownFieldSet unknownFields) {
          return super.mergeUnknownFields(unknownFields);
        }

        // @@protoc_insertion_point(builder_scope:google.cloud.aiplatform.v1beta1.StudySpec.ParameterSpec.ConditionalParameterSpec)
      }

      // @@protoc_insertion_point(class_scope:google.cloud.aiplatform.v1beta1.StudySpec.ParameterSpec.ConditionalParameterSpec)
      private static final com.google.cloud.aiplatform.v1beta1.StudySpec.ParameterSpec
              .ConditionalParameterSpec
          DEFAULT_INSTANCE;

      static {
        DEFAULT_INSTANCE =
            new com.google.cloud.aiplatform.v1beta1.StudySpec.ParameterSpec
                .ConditionalParameterSpec();
      }

      public static com.google.cloud.aiplatform.v1beta1.StudySpec.ParameterSpec
              .ConditionalParameterSpec
          getDefaultInstance() {
        return DEFAULT_INSTANCE;
      }

      private static final com.google.protobuf.Parser<ConditionalParameterSpec> PARSER =
          new com.google.protobuf.AbstractParser<ConditionalParameterSpec>() {
            @java.lang.Override
            public ConditionalParameterSpec parsePartialFrom(
                com.google.protobuf.CodedInputStream input,
                com.google.protobuf.ExtensionRegistryLite extensionRegistry)
                throws com.google.protobuf.InvalidProtocolBufferException {
              return new ConditionalParameterSpec(input, extensionRegistry);
            }
          };

      public static com.google.protobuf.Parser<ConditionalParameterSpec> parser() {
        return PARSER;
      }

      @java.lang.Override
      public com.google.protobuf.Parser<ConditionalParameterSpec> getParserForType() {
        return PARSER;
      }

      @java.lang.Override
      public com.google.cloud.aiplatform.v1beta1.StudySpec.ParameterSpec.ConditionalParameterSpec
          getDefaultInstanceForType() {
        return DEFAULT_INSTANCE;
      }
    }

    private int parameterValueSpecCase_ = 0;
    private java.lang.Object parameterValueSpec_;

    public enum ParameterValueSpecCase
        implements
            com.google.protobuf.Internal.EnumLite,
            com.google.protobuf.AbstractMessage.InternalOneOfEnum {
      DOUBLE_VALUE_SPEC(2),
      INTEGER_VALUE_SPEC(3),
      CATEGORICAL_VALUE_SPEC(4),
      DISCRETE_VALUE_SPEC(5),
      PARAMETERVALUESPEC_NOT_SET(0);
      private final int value;

      private ParameterValueSpecCase(int value) {
        this.value = value;
      }
      /**
       * @param value The number of the enum to look for.
       * @return The enum associated with the given number.
       * @deprecated Use {@link #forNumber(int)} instead.
       */
      @java.lang.Deprecated
      public static ParameterValueSpecCase valueOf(int value) {
        return forNumber(value);
      }

      public static ParameterValueSpecCase forNumber(int value) {
        switch (value) {
          case 2:
            return DOUBLE_VALUE_SPEC;
          case 3:
            return INTEGER_VALUE_SPEC;
          case 4:
            return CATEGORICAL_VALUE_SPEC;
          case 5:
            return DISCRETE_VALUE_SPEC;
          case 0:
            return PARAMETERVALUESPEC_NOT_SET;
          default:
            return null;
        }
      }

      public int getNumber() {
        return this.value;
      }
    };

    public ParameterValueSpecCase getParameterValueSpecCase() {
      return ParameterValueSpecCase.forNumber(parameterValueSpecCase_);
    }

    public static final int DOUBLE_VALUE_SPEC_FIELD_NUMBER = 2;
    /**
     *
     *
     * <pre>
     * The value spec for a 'DOUBLE' parameter.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.StudySpec.ParameterSpec.DoubleValueSpec double_value_spec = 2;
     * </code>
     *
     * @return Whether the doubleValueSpec field is set.
     */
    @java.lang.Override
    public boolean hasDoubleValueSpec() {
      return parameterValueSpecCase_ == 2;
    }
    /**
     *
     *
     * <pre>
     * The value spec for a 'DOUBLE' parameter.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.StudySpec.ParameterSpec.DoubleValueSpec double_value_spec = 2;
     * </code>
     *
     * @return The doubleValueSpec.
     */
    @java.lang.Override
    public com.google.cloud.aiplatform.v1beta1.StudySpec.ParameterSpec.DoubleValueSpec
        getDoubleValueSpec() {
      if (parameterValueSpecCase_ == 2) {
        return (com.google.cloud.aiplatform.v1beta1.StudySpec.ParameterSpec.DoubleValueSpec)
            parameterValueSpec_;
      }
      return com.google.cloud.aiplatform.v1beta1.StudySpec.ParameterSpec.DoubleValueSpec
          .getDefaultInstance();
    }
    /**
     *
     *
     * <pre>
     * The value spec for a 'DOUBLE' parameter.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.StudySpec.ParameterSpec.DoubleValueSpec double_value_spec = 2;
     * </code>
     */
    @java.lang.Override
    public com.google.cloud.aiplatform.v1beta1.StudySpec.ParameterSpec.DoubleValueSpecOrBuilder
        getDoubleValueSpecOrBuilder() {
      if (parameterValueSpecCase_ == 2) {
        return (com.google.cloud.aiplatform.v1beta1.StudySpec.ParameterSpec.DoubleValueSpec)
            parameterValueSpec_;
      }
      return com.google.cloud.aiplatform.v1beta1.StudySpec.ParameterSpec.DoubleValueSpec
          .getDefaultInstance();
    }

    public static final int INTEGER_VALUE_SPEC_FIELD_NUMBER = 3;
    /**
     *
     *
     * <pre>
     * The value spec for an 'INTEGER' parameter.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.StudySpec.ParameterSpec.IntegerValueSpec integer_value_spec = 3;
     * </code>
     *
     * @return Whether the integerValueSpec field is set.
     */
    @java.lang.Override
    public boolean hasIntegerValueSpec() {
      return parameterValueSpecCase_ == 3;
    }
    /**
     *
     *
     * <pre>
     * The value spec for an 'INTEGER' parameter.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.StudySpec.ParameterSpec.IntegerValueSpec integer_value_spec = 3;
     * </code>
     *
     * @return The integerValueSpec.
     */
    @java.lang.Override
    public com.google.cloud.aiplatform.v1beta1.StudySpec.ParameterSpec.IntegerValueSpec
        getIntegerValueSpec() {
      if (parameterValueSpecCase_ == 3) {
        return (com.google.cloud.aiplatform.v1beta1.StudySpec.ParameterSpec.IntegerValueSpec)
            parameterValueSpec_;
      }
      return com.google.cloud.aiplatform.v1beta1.StudySpec.ParameterSpec.IntegerValueSpec
          .getDefaultInstance();
    }
    /**
     *
     *
     * <pre>
     * The value spec for an 'INTEGER' parameter.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.StudySpec.ParameterSpec.IntegerValueSpec integer_value_spec = 3;
     * </code>
     */
    @java.lang.Override
    public com.google.cloud.aiplatform.v1beta1.StudySpec.ParameterSpec.IntegerValueSpecOrBuilder
        getIntegerValueSpecOrBuilder() {
      if (parameterValueSpecCase_ == 3) {
        return (com.google.cloud.aiplatform.v1beta1.StudySpec.ParameterSpec.IntegerValueSpec)
            parameterValueSpec_;
      }
      return com.google.cloud.aiplatform.v1beta1.StudySpec.ParameterSpec.IntegerValueSpec
          .getDefaultInstance();
    }

    public static final int CATEGORICAL_VALUE_SPEC_FIELD_NUMBER = 4;
    /**
     *
     *
     * <pre>
     * The value spec for a 'CATEGORICAL' parameter.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.StudySpec.ParameterSpec.CategoricalValueSpec categorical_value_spec = 4;
     * </code>
     *
     * @return Whether the categoricalValueSpec field is set.
     */
    @java.lang.Override
    public boolean hasCategoricalValueSpec() {
      return parameterValueSpecCase_ == 4;
    }
    /**
     *
     *
     * <pre>
     * The value spec for a 'CATEGORICAL' parameter.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.StudySpec.ParameterSpec.CategoricalValueSpec categorical_value_spec = 4;
     * </code>
     *
     * @return The categoricalValueSpec.
     */
    @java.lang.Override
    public com.google.cloud.aiplatform.v1beta1.StudySpec.ParameterSpec.CategoricalValueSpec
        getCategoricalValueSpec() {
      if (parameterValueSpecCase_ == 4) {
        return (com.google.cloud.aiplatform.v1beta1.StudySpec.ParameterSpec.CategoricalValueSpec)
            parameterValueSpec_;
      }
      return com.google.cloud.aiplatform.v1beta1.StudySpec.ParameterSpec.CategoricalValueSpec
          .getDefaultInstance();
    }
    /**
     *
     *
     * <pre>
     * The value spec for a 'CATEGORICAL' parameter.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.StudySpec.ParameterSpec.CategoricalValueSpec categorical_value_spec = 4;
     * </code>
     */
    @java.lang.Override
    public com.google.cloud.aiplatform.v1beta1.StudySpec.ParameterSpec.CategoricalValueSpecOrBuilder
        getCategoricalValueSpecOrBuilder() {
      if (parameterValueSpecCase_ == 4) {
        return (com.google.cloud.aiplatform.v1beta1.StudySpec.ParameterSpec.CategoricalValueSpec)
            parameterValueSpec_;
      }
      return com.google.cloud.aiplatform.v1beta1.StudySpec.ParameterSpec.CategoricalValueSpec
          .getDefaultInstance();
    }

    public static final int DISCRETE_VALUE_SPEC_FIELD_NUMBER = 5;
    /**
     *
     *
     * <pre>
     * The value spec for a 'DISCRETE' parameter.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.StudySpec.ParameterSpec.DiscreteValueSpec discrete_value_spec = 5;
     * </code>
     *
     * @return Whether the discreteValueSpec field is set.
     */
    @java.lang.Override
    public boolean hasDiscreteValueSpec() {
      return parameterValueSpecCase_ == 5;
    }
    /**
     *
     *
     * <pre>
     * The value spec for a 'DISCRETE' parameter.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.StudySpec.ParameterSpec.DiscreteValueSpec discrete_value_spec = 5;
     * </code>
     *
     * @return The discreteValueSpec.
     */
    @java.lang.Override
    public com.google.cloud.aiplatform.v1beta1.StudySpec.ParameterSpec.DiscreteValueSpec
        getDiscreteValueSpec() {
      if (parameterValueSpecCase_ == 5) {
        return (com.google.cloud.aiplatform.v1beta1.StudySpec.ParameterSpec.DiscreteValueSpec)
            parameterValueSpec_;
      }
      return com.google.cloud.aiplatform.v1beta1.StudySpec.ParameterSpec.DiscreteValueSpec
          .getDefaultInstance();
    }
    /**
     *
     *
     * <pre>
     * The value spec for a 'DISCRETE' parameter.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.StudySpec.ParameterSpec.DiscreteValueSpec discrete_value_spec = 5;
     * </code>
     */
    @java.lang.Override
    public com.google.cloud.aiplatform.v1beta1.StudySpec.ParameterSpec.DiscreteValueSpecOrBuilder
        getDiscreteValueSpecOrBuilder() {
      if (parameterValueSpecCase_ == 5) {
        return (com.google.cloud.aiplatform.v1beta1.StudySpec.ParameterSpec.DiscreteValueSpec)
            parameterValueSpec_;
      }
      return com.google.cloud.aiplatform.v1beta1.StudySpec.ParameterSpec.DiscreteValueSpec
          .getDefaultInstance();
    }

    public static final int PARAMETER_ID_FIELD_NUMBER = 1;
    private volatile java.lang.Object parameterId_;
    /**
     *
     *
     * <pre>
     * Required. The ID of the parameter. Must not contain whitespaces and must be unique
     * amongst all ParameterSpecs.
     * </pre>
     *
     * <code>string parameter_id = 1 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return The parameterId.
     */
    @java.lang.Override
    public java.lang.String getParameterId() {
      java.lang.Object ref = parameterId_;
      if (ref instanceof java.lang.String) {
        return (java.lang.String) ref;
      } else {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        parameterId_ = s;
        return s;
      }
    }
    /**
     *
     *
     * <pre>
     * Required. The ID of the parameter. Must not contain whitespaces and must be unique
     * amongst all ParameterSpecs.
     * </pre>
     *
     * <code>string parameter_id = 1 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return The bytes for parameterId.
     */
    @java.lang.Override
    public com.google.protobuf.ByteString getParameterIdBytes() {
      java.lang.Object ref = parameterId_;
      if (ref instanceof java.lang.String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        parameterId_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    public static final int SCALE_TYPE_FIELD_NUMBER = 6;
    private int scaleType_;
    /**
     *
     *
     * <pre>
     * How the parameter should be scaled.
     * Leave unset for `CATEGORICAL` parameters.
     * </pre>
     *
     * <code>.google.cloud.aiplatform.v1beta1.StudySpec.ParameterSpec.ScaleType scale_type = 6;
     * </code>
     *
     * @return The enum numeric value on the wire for scaleType.
     */
    @java.lang.Override
    public int getScaleTypeValue() {
      return scaleType_;
    }
    /**
     *
     *
     * <pre>
     * How the parameter should be scaled.
     * Leave unset for `CATEGORICAL` parameters.
     * </pre>
     *
     * <code>.google.cloud.aiplatform.v1beta1.StudySpec.ParameterSpec.ScaleType scale_type = 6;
     * </code>
     *
     * @return The scaleType.
     */
    @java.lang.Override
    public com.google.cloud.aiplatform.v1beta1.StudySpec.ParameterSpec.ScaleType getScaleType() {
      @SuppressWarnings("deprecation")
      com.google.cloud.aiplatform.v1beta1.StudySpec.ParameterSpec.ScaleType result =
          com.google.cloud.aiplatform.v1beta1.StudySpec.ParameterSpec.ScaleType.valueOf(scaleType_);
      return result == null
          ? com.google.cloud.aiplatform.v1beta1.StudySpec.ParameterSpec.ScaleType.UNRECOGNIZED
          : result;
    }

    public static final int CONDITIONAL_PARAMETER_SPECS_FIELD_NUMBER = 10;
    private java.util.List<
            com.google.cloud.aiplatform.v1beta1.StudySpec.ParameterSpec.ConditionalParameterSpec>
        conditionalParameterSpecs_;
    /**
     *
     *
     * <pre>
     * A conditional parameter node is active if the parameter's value matches
     * the conditional node's parent_value_condition.
     * If two items in conditional_parameter_specs have the same name, they
     * must have disjoint parent_value_condition.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.aiplatform.v1beta1.StudySpec.ParameterSpec.ConditionalParameterSpec conditional_parameter_specs = 10;
     * </code>
     */
    @java.lang.Override
    public java.util.List<
            com.google.cloud.aiplatform.v1beta1.StudySpec.ParameterSpec.ConditionalParameterSpec>
        getConditionalParameterSpecsList() {
      return conditionalParameterSpecs_;
    }
    /**
     *
     *
     * <pre>
     * A conditional parameter node is active if the parameter's value matches
     * the conditional node's parent_value_condition.
     * If two items in conditional_parameter_specs have the same name, they
     * must have disjoint parent_value_condition.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.aiplatform.v1beta1.StudySpec.ParameterSpec.ConditionalParameterSpec conditional_parameter_specs = 10;
     * </code>
     */
    @java.lang.Override
    public java.util.List<
            ? extends
                com.google.cloud.aiplatform.v1beta1.StudySpec.ParameterSpec
                    .ConditionalParameterSpecOrBuilder>
        getConditionalParameterSpecsOrBuilderList() {
      return conditionalParameterSpecs_;
    }
    /**
     *
     *
     * <pre>
     * A conditional parameter node is active if the parameter's value matches
     * the conditional node's parent_value_condition.
     * If two items in conditional_parameter_specs have the same name, they
     * must have disjoint parent_value_condition.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.aiplatform.v1beta1.StudySpec.ParameterSpec.ConditionalParameterSpec conditional_parameter_specs = 10;
     * </code>
     */
    @java.lang.Override
    public int getConditionalParameterSpecsCount() {
      return conditionalParameterSpecs_.size();
    }
    /**
     *
     *
     * <pre>
     * A conditional parameter node is active if the parameter's value matches
     * the conditional node's parent_value_condition.
     * If two items in conditional_parameter_specs have the same name, they
     * must have disjoint parent_value_condition.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.aiplatform.v1beta1.StudySpec.ParameterSpec.ConditionalParameterSpec conditional_parameter_specs = 10;
     * </code>
     */
    @java.lang.Override
    public com.google.cloud.aiplatform.v1beta1.StudySpec.ParameterSpec.ConditionalParameterSpec
        getConditionalParameterSpecs(int index) {
      return conditionalParameterSpecs_.get(index);
    }
    /**
     *
     *
     * <pre>
     * A conditional parameter node is active if the parameter's value matches
     * the conditional node's parent_value_condition.
     * If two items in conditional_parameter_specs have the same name, they
     * must have disjoint parent_value_condition.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.aiplatform.v1beta1.StudySpec.ParameterSpec.ConditionalParameterSpec conditional_parameter_specs = 10;
     * </code>
     */
    @java.lang.Override
    public com.google.cloud.aiplatform.v1beta1.StudySpec.ParameterSpec
            .ConditionalParameterSpecOrBuilder
        getConditionalParameterSpecsOrBuilder(int index) {
      return conditionalParameterSpecs_.get(index);
    }

    private byte memoizedIsInitialized = -1;

    @java.lang.Override
    public final boolean isInitialized() {
      byte isInitialized = memoizedIsInitialized;
      if (isInitialized == 1) return true;
      if (isInitialized == 0) return false;

      memoizedIsInitialized = 1;
      return true;
    }

    @java.lang.Override
    public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
      if (!getParameterIdBytes().isEmpty()) {
        com.google.protobuf.GeneratedMessageV3.writeString(output, 1, parameterId_);
      }
      if (parameterValueSpecCase_ == 2) {
        output.writeMessage(
            2,
            (com.google.cloud.aiplatform.v1beta1.StudySpec.ParameterSpec.DoubleValueSpec)
                parameterValueSpec_);
      }
      if (parameterValueSpecCase_ == 3) {
        output.writeMessage(
            3,
            (com.google.cloud.aiplatform.v1beta1.StudySpec.ParameterSpec.IntegerValueSpec)
                parameterValueSpec_);
      }
      if (parameterValueSpecCase_ == 4) {
        output.writeMessage(
            4,
            (com.google.cloud.aiplatform.v1beta1.StudySpec.ParameterSpec.CategoricalValueSpec)
                parameterValueSpec_);
      }
      if (parameterValueSpecCase_ == 5) {
        output.writeMessage(
            5,
            (com.google.cloud.aiplatform.v1beta1.StudySpec.ParameterSpec.DiscreteValueSpec)
                parameterValueSpec_);
      }
      if (scaleType_
          != com.google.cloud.aiplatform.v1beta1.StudySpec.ParameterSpec.ScaleType
              .SCALE_TYPE_UNSPECIFIED
              .getNumber()) {
        output.writeEnum(6, scaleType_);
      }
      for (int i = 0; i < conditionalParameterSpecs_.size(); i++) {
        output.writeMessage(10, conditionalParameterSpecs_.get(i));
      }
      unknownFields.writeTo(output);
    }

    @java.lang.Override
    public int getSerializedSize() {
      int size = memoizedSize;
      if (size != -1) return size;

      size = 0;
      if (!getParameterIdBytes().isEmpty()) {
        size += com.google.protobuf.GeneratedMessageV3.computeStringSize(1, parameterId_);
      }
      if (parameterValueSpecCase_ == 2) {
        size +=
            com.google.protobuf.CodedOutputStream.computeMessageSize(
                2,
                (com.google.cloud.aiplatform.v1beta1.StudySpec.ParameterSpec.DoubleValueSpec)
                    parameterValueSpec_);
      }
      if (parameterValueSpecCase_ == 3) {
        size +=
            com.google.protobuf.CodedOutputStream.computeMessageSize(
                3,
                (com.google.cloud.aiplatform.v1beta1.StudySpec.ParameterSpec.IntegerValueSpec)
                    parameterValueSpec_);
      }
      if (parameterValueSpecCase_ == 4) {
        size +=
            com.google.protobuf.CodedOutputStream.computeMessageSize(
                4,
                (com.google.cloud.aiplatform.v1beta1.StudySpec.ParameterSpec.CategoricalValueSpec)
                    parameterValueSpec_);
      }
      if (parameterValueSpecCase_ == 5) {
        size +=
            com.google.protobuf.CodedOutputStream.computeMessageSize(
                5,
                (com.google.cloud.aiplatform.v1beta1.StudySpec.ParameterSpec.DiscreteValueSpec)
                    parameterValueSpec_);
      }
      if (scaleType_
          != com.google.cloud.aiplatform.v1beta1.StudySpec.ParameterSpec.ScaleType
              .SCALE_TYPE_UNSPECIFIED
              .getNumber()) {
        size += com.google.protobuf.CodedOutputStream.computeEnumSize(6, scaleType_);
      }
      for (int i = 0; i < conditionalParameterSpecs_.size(); i++) {
        size +=
            com.google.protobuf.CodedOutputStream.computeMessageSize(
                10, conditionalParameterSpecs_.get(i));
      }
      size += unknownFields.getSerializedSize();
      memoizedSize = size;
      return size;
    }

    @java.lang.Override
    public boolean equals(final java.lang.Object obj) {
      if (obj == this) {
        return true;
      }
      if (!(obj instanceof com.google.cloud.aiplatform.v1beta1.StudySpec.ParameterSpec)) {
        return super.equals(obj);
      }
      com.google.cloud.aiplatform.v1beta1.StudySpec.ParameterSpec other =
          (com.google.cloud.aiplatform.v1beta1.StudySpec.ParameterSpec) obj;

      if (!getParameterId().equals(other.getParameterId())) return false;
      if (scaleType_ != other.scaleType_) return false;
      if (!getConditionalParameterSpecsList().equals(other.getConditionalParameterSpecsList()))
        return false;
      if (!getParameterValueSpecCase().equals(other.getParameterValueSpecCase())) return false;
      switch (parameterValueSpecCase_) {
        case 2:
          if (!getDoubleValueSpec().equals(other.getDoubleValueSpec())) return false;
          break;
        case 3:
          if (!getIntegerValueSpec().equals(other.getIntegerValueSpec())) return false;
          break;
        case 4:
          if (!getCategoricalValueSpec().equals(other.getCategoricalValueSpec())) return false;
          break;
        case 5:
          if (!getDiscreteValueSpec().equals(other.getDiscreteValueSpec())) return false;
          break;
        case 0:
        default:
      }
      if (!unknownFields.equals(other.unknownFields)) return false;
      return true;
    }

    @java.lang.Override
    public int hashCode() {
      if (memoizedHashCode != 0) {
        return memoizedHashCode;
      }
      int hash = 41;
      hash = (19 * hash) + getDescriptor().hashCode();
      hash = (37 * hash) + PARAMETER_ID_FIELD_NUMBER;
      hash = (53 * hash) + getParameterId().hashCode();
      hash = (37 * hash) + SCALE_TYPE_FIELD_NUMBER;
      hash = (53 * hash) + scaleType_;
      if (getConditionalParameterSpecsCount() > 0) {
        hash = (37 * hash) + CONDITIONAL_PARAMETER_SPECS_FIELD_NUMBER;
        hash = (53 * hash) + getConditionalParameterSpecsList().hashCode();
      }
      switch (parameterValueSpecCase_) {
        case 2:
          hash = (37 * hash) + DOUBLE_VALUE_SPEC_FIELD_NUMBER;
          hash = (53 * hash) + getDoubleValueSpec().hashCode();
          break;
        case 3:
          hash = (37 * hash) + INTEGER_VALUE_SPEC_FIELD_NUMBER;
          hash = (53 * hash) + getIntegerValueSpec().hashCode();
          break;
        case 4:
          hash = (37 * hash) + CATEGORICAL_VALUE_SPEC_FIELD_NUMBER;
          hash = (53 * hash) + getCategoricalValueSpec().hashCode();
          break;
        case 5:
          hash = (37 * hash) + DISCRETE_VALUE_SPEC_FIELD_NUMBER;
          hash = (53 * hash) + getDiscreteValueSpec().hashCode();
          break;
        case 0:
        default:
      }
      hash = (29 * hash) + unknownFields.hashCode();
      memoizedHashCode = hash;
      return hash;
    }

    public static com.google.cloud.aiplatform.v1beta1.StudySpec.ParameterSpec parseFrom(
        java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.aiplatform.v1beta1.StudySpec.ParameterSpec parseFrom(
        java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.aiplatform.v1beta1.StudySpec.ParameterSpec parseFrom(
        com.google.protobuf.ByteString data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.aiplatform.v1beta1.StudySpec.ParameterSpec parseFrom(
        com.google.protobuf.ByteString data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.aiplatform.v1beta1.StudySpec.ParameterSpec parseFrom(byte[] data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.aiplatform.v1beta1.StudySpec.ParameterSpec parseFrom(
        byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.aiplatform.v1beta1.StudySpec.ParameterSpec parseFrom(
        java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.cloud.aiplatform.v1beta1.StudySpec.ParameterSpec parseFrom(
        java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.cloud.aiplatform.v1beta1.StudySpec.ParameterSpec parseDelimitedFrom(
        java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
    }

    public static com.google.cloud.aiplatform.v1beta1.StudySpec.ParameterSpec parseDelimitedFrom(
        java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.cloud.aiplatform.v1beta1.StudySpec.ParameterSpec parseFrom(
        com.google.protobuf.CodedInputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.cloud.aiplatform.v1beta1.StudySpec.ParameterSpec parseFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    @java.lang.Override
    public Builder newBuilderForType() {
      return newBuilder();
    }

    public static Builder newBuilder() {
      return DEFAULT_INSTANCE.toBuilder();
    }

    public static Builder newBuilder(
        com.google.cloud.aiplatform.v1beta1.StudySpec.ParameterSpec prototype) {
      return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }

    @java.lang.Override
    public Builder toBuilder() {
      return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
    }

    @java.lang.Override
    protected Builder newBuilderForType(
        com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      Builder builder = new Builder(parent);
      return builder;
    }
    /**
     *
     *
     * <pre>
     * Represents a single parameter to optimize.
     * </pre>
     *
     * Protobuf type {@code google.cloud.aiplatform.v1beta1.StudySpec.ParameterSpec}
     */
    public static final class Builder
        extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
        implements
        // @@protoc_insertion_point(builder_implements:google.cloud.aiplatform.v1beta1.StudySpec.ParameterSpec)
        com.google.cloud.aiplatform.v1beta1.StudySpec.ParameterSpecOrBuilder {
      public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
        return com.google.cloud.aiplatform.v1beta1.StudyProto
            .internal_static_google_cloud_aiplatform_v1beta1_StudySpec_ParameterSpec_descriptor;
      }

      @java.lang.Override
      protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return com.google.cloud.aiplatform.v1beta1.StudyProto
            .internal_static_google_cloud_aiplatform_v1beta1_StudySpec_ParameterSpec_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                com.google.cloud.aiplatform.v1beta1.StudySpec.ParameterSpec.class,
                com.google.cloud.aiplatform.v1beta1.StudySpec.ParameterSpec.Builder.class);
      }

      // Construct using com.google.cloud.aiplatform.v1beta1.StudySpec.ParameterSpec.newBuilder()
      private Builder() {
        maybeForceBuilderInitialization();
      }

      private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
        super(parent);
        maybeForceBuilderInitialization();
      }

      private void maybeForceBuilderInitialization() {
        if (com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders) {
          getConditionalParameterSpecsFieldBuilder();
        }
      }

      @java.lang.Override
      public Builder clear() {
        super.clear();
        parameterId_ = "";

        scaleType_ = 0;

        if (conditionalParameterSpecsBuilder_ == null) {
          conditionalParameterSpecs_ = java.util.Collections.emptyList();
          bitField0_ = (bitField0_ & ~0x00000001);
        } else {
          conditionalParameterSpecsBuilder_.clear();
        }
        parameterValueSpecCase_ = 0;
        parameterValueSpec_ = null;
        return this;
      }

      @java.lang.Override
      public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
        return com.google.cloud.aiplatform.v1beta1.StudyProto
            .internal_static_google_cloud_aiplatform_v1beta1_StudySpec_ParameterSpec_descriptor;
      }

      @java.lang.Override
      public com.google.cloud.aiplatform.v1beta1.StudySpec.ParameterSpec
          getDefaultInstanceForType() {
        return com.google.cloud.aiplatform.v1beta1.StudySpec.ParameterSpec.getDefaultInstance();
      }

      @java.lang.Override
      public com.google.cloud.aiplatform.v1beta1.StudySpec.ParameterSpec build() {
        com.google.cloud.aiplatform.v1beta1.StudySpec.ParameterSpec result = buildPartial();
        if (!result.isInitialized()) {
          throw newUninitializedMessageException(result);
        }
        return result;
      }

      @java.lang.Override
      public com.google.cloud.aiplatform.v1beta1.StudySpec.ParameterSpec buildPartial() {
        com.google.cloud.aiplatform.v1beta1.StudySpec.ParameterSpec result =
            new com.google.cloud.aiplatform.v1beta1.StudySpec.ParameterSpec(this);
        int from_bitField0_ = bitField0_;
        if (parameterValueSpecCase_ == 2) {
          if (doubleValueSpecBuilder_ == null) {
            result.parameterValueSpec_ = parameterValueSpec_;
          } else {
            result.parameterValueSpec_ = doubleValueSpecBuilder_.build();
          }
        }
        if (parameterValueSpecCase_ == 3) {
          if (integerValueSpecBuilder_ == null) {
            result.parameterValueSpec_ = parameterValueSpec_;
          } else {
            result.parameterValueSpec_ = integerValueSpecBuilder_.build();
          }
        }
        if (parameterValueSpecCase_ == 4) {
          if (categoricalValueSpecBuilder_ == null) {
            result.parameterValueSpec_ = parameterValueSpec_;
          } else {
            result.parameterValueSpec_ = categoricalValueSpecBuilder_.build();
          }
        }
        if (parameterValueSpecCase_ == 5) {
          if (discreteValueSpecBuilder_ == null) {
            result.parameterValueSpec_ = parameterValueSpec_;
          } else {
            result.parameterValueSpec_ = discreteValueSpecBuilder_.build();
          }
        }
        result.parameterId_ = parameterId_;
        result.scaleType_ = scaleType_;
        if (conditionalParameterSpecsBuilder_ == null) {
          if (((bitField0_ & 0x00000001) != 0)) {
            conditionalParameterSpecs_ =
                java.util.Collections.unmodifiableList(conditionalParameterSpecs_);
            bitField0_ = (bitField0_ & ~0x00000001);
          }
          result.conditionalParameterSpecs_ = conditionalParameterSpecs_;
        } else {
          result.conditionalParameterSpecs_ = conditionalParameterSpecsBuilder_.build();
        }
        result.parameterValueSpecCase_ = parameterValueSpecCase_;
        onBuilt();
        return result;
      }

      @java.lang.Override
      public Builder clone() {
        return super.clone();
      }

      @java.lang.Override
      public Builder setField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.setField(field, value);
      }

      @java.lang.Override
      public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
        return super.clearField(field);
      }

      @java.lang.Override
      public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
        return super.clearOneof(oneof);
      }

      @java.lang.Override
      public Builder setRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          int index,
          java.lang.Object value) {
        return super.setRepeatedField(field, index, value);
      }

      @java.lang.Override
      public Builder addRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.addRepeatedField(field, value);
      }

      @java.lang.Override
      public Builder mergeFrom(com.google.protobuf.Message other) {
        if (other instanceof com.google.cloud.aiplatform.v1beta1.StudySpec.ParameterSpec) {
          return mergeFrom((com.google.cloud.aiplatform.v1beta1.StudySpec.ParameterSpec) other);
        } else {
          super.mergeFrom(other);
          return this;
        }
      }

      public Builder mergeFrom(com.google.cloud.aiplatform.v1beta1.StudySpec.ParameterSpec other) {
        if (other
            == com.google.cloud.aiplatform.v1beta1.StudySpec.ParameterSpec.getDefaultInstance())
          return this;
        if (!other.getParameterId().isEmpty()) {
          parameterId_ = other.parameterId_;
          onChanged();
        }
        if (other.scaleType_ != 0) {
          setScaleTypeValue(other.getScaleTypeValue());
        }
        if (conditionalParameterSpecsBuilder_ == null) {
          if (!other.conditionalParameterSpecs_.isEmpty()) {
            if (conditionalParameterSpecs_.isEmpty()) {
              conditionalParameterSpecs_ = other.conditionalParameterSpecs_;
              bitField0_ = (bitField0_ & ~0x00000001);
            } else {
              ensureConditionalParameterSpecsIsMutable();
              conditionalParameterSpecs_.addAll(other.conditionalParameterSpecs_);
            }
            onChanged();
          }
        } else {
          if (!other.conditionalParameterSpecs_.isEmpty()) {
            if (conditionalParameterSpecsBuilder_.isEmpty()) {
              conditionalParameterSpecsBuilder_.dispose();
              conditionalParameterSpecsBuilder_ = null;
              conditionalParameterSpecs_ = other.conditionalParameterSpecs_;
              bitField0_ = (bitField0_ & ~0x00000001);
              conditionalParameterSpecsBuilder_ =
                  com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders
                      ? getConditionalParameterSpecsFieldBuilder()
                      : null;
            } else {
              conditionalParameterSpecsBuilder_.addAllMessages(other.conditionalParameterSpecs_);
            }
          }
        }
        switch (other.getParameterValueSpecCase()) {
          case DOUBLE_VALUE_SPEC:
            {
              mergeDoubleValueSpec(other.getDoubleValueSpec());
              break;
            }
          case INTEGER_VALUE_SPEC:
            {
              mergeIntegerValueSpec(other.getIntegerValueSpec());
              break;
            }
          case CATEGORICAL_VALUE_SPEC:
            {
              mergeCategoricalValueSpec(other.getCategoricalValueSpec());
              break;
            }
          case DISCRETE_VALUE_SPEC:
            {
              mergeDiscreteValueSpec(other.getDiscreteValueSpec());
              break;
            }
          case PARAMETERVALUESPEC_NOT_SET:
            {
              break;
            }
        }
        this.mergeUnknownFields(other.unknownFields);
        onChanged();
        return this;
      }

      @java.lang.Override
      public final boolean isInitialized() {
        return true;
      }

      @java.lang.Override
      public Builder mergeFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        com.google.cloud.aiplatform.v1beta1.StudySpec.ParameterSpec parsedMessage = null;
        try {
          parsedMessage = PARSER.parsePartialFrom(input, extensionRegistry);
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          parsedMessage =
              (com.google.cloud.aiplatform.v1beta1.StudySpec.ParameterSpec)
                  e.getUnfinishedMessage();
          throw e.unwrapIOException();
        } finally {
          if (parsedMessage != null) {
            mergeFrom(parsedMessage);
          }
        }
        return this;
      }

      private int parameterValueSpecCase_ = 0;
      private java.lang.Object parameterValueSpec_;

      public ParameterValueSpecCase getParameterValueSpecCase() {
        return ParameterValueSpecCase.forNumber(parameterValueSpecCase_);
      }

      public Builder clearParameterValueSpec() {
        parameterValueSpecCase_ = 0;
        parameterValueSpec_ = null;
        onChanged();
        return this;
      }

      private int bitField0_;

      private com.google.protobuf.SingleFieldBuilderV3<
              com.google.cloud.aiplatform.v1beta1.StudySpec.ParameterSpec.DoubleValueSpec,
              com.google.cloud.aiplatform.v1beta1.StudySpec.ParameterSpec.DoubleValueSpec.Builder,
              com.google.cloud.aiplatform.v1beta1.StudySpec.ParameterSpec.DoubleValueSpecOrBuilder>
          doubleValueSpecBuilder_;
      /**
       *
       *
       * <pre>
       * The value spec for a 'DOUBLE' parameter.
       * </pre>
       *
       * <code>
       * .google.cloud.aiplatform.v1beta1.StudySpec.ParameterSpec.DoubleValueSpec double_value_spec = 2;
       * </code>
       *
       * @return Whether the doubleValueSpec field is set.
       */
      @java.lang.Override
      public boolean hasDoubleValueSpec() {
        return parameterValueSpecCase_ == 2;
      }
      /**
       *
       *
       * <pre>
       * The value spec for a 'DOUBLE' parameter.
       * </pre>
       *
       * <code>
       * .google.cloud.aiplatform.v1beta1.StudySpec.ParameterSpec.DoubleValueSpec double_value_spec = 2;
       * </code>
       *
       * @return The doubleValueSpec.
       */
      @java.lang.Override
      public com.google.cloud.aiplatform.v1beta1.StudySpec.ParameterSpec.DoubleValueSpec
          getDoubleValueSpec() {
        if (doubleValueSpecBuilder_ == null) {
          if (parameterValueSpecCase_ == 2) {
            return (com.google.cloud.aiplatform.v1beta1.StudySpec.ParameterSpec.DoubleValueSpec)
                parameterValueSpec_;
          }
          return com.google.cloud.aiplatform.v1beta1.StudySpec.ParameterSpec.DoubleValueSpec
              .getDefaultInstance();
        } else {
          if (parameterValueSpecCase_ == 2) {
            return doubleValueSpecBuilder_.getMessage();
          }
          return com.google.cloud.aiplatform.v1beta1.StudySpec.ParameterSpec.DoubleValueSpec
              .getDefaultInstance();
        }
      }
      /**
       *
       *
       * <pre>
       * The value spec for a 'DOUBLE' parameter.
       * </pre>
       *
       * <code>
       * .google.cloud.aiplatform.v1beta1.StudySpec.ParameterSpec.DoubleValueSpec double_value_spec = 2;
       * </code>
       */
      public Builder setDoubleValueSpec(
          com.google.cloud.aiplatform.v1beta1.StudySpec.ParameterSpec.DoubleValueSpec value) {
        if (doubleValueSpecBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          parameterValueSpec_ = value;
          onChanged();
        } else {
          doubleValueSpecBuilder_.setMessage(value);
        }
        parameterValueSpecCase_ = 2;
        return this;
      }
      /**
       *
       *
       * <pre>
       * The value spec for a 'DOUBLE' parameter.
       * </pre>
       *
       * <code>
       * .google.cloud.aiplatform.v1beta1.StudySpec.ParameterSpec.DoubleValueSpec double_value_spec = 2;
       * </code>
       */
      public Builder setDoubleValueSpec(
          com.google.cloud.aiplatform.v1beta1.StudySpec.ParameterSpec.DoubleValueSpec.Builder
              builderForValue) {
        if (doubleValueSpecBuilder_ == null) {
          parameterValueSpec_ = builderForValue.build();
          onChanged();
        } else {
          doubleValueSpecBuilder_.setMessage(builderForValue.build());
        }
        parameterValueSpecCase_ = 2;
        return this;
      }
      /**
       *
       *
       * <pre>
       * The value spec for a 'DOUBLE' parameter.
       * </pre>
       *
       * <code>
       * .google.cloud.aiplatform.v1beta1.StudySpec.ParameterSpec.DoubleValueSpec double_value_spec = 2;
       * </code>
       */
      public Builder mergeDoubleValueSpec(
          com.google.cloud.aiplatform.v1beta1.StudySpec.ParameterSpec.DoubleValueSpec value) {
        if (doubleValueSpecBuilder_ == null) {
          if (parameterValueSpecCase_ == 2
              && parameterValueSpec_
                  != com.google.cloud.aiplatform.v1beta1.StudySpec.ParameterSpec.DoubleValueSpec
                      .getDefaultInstance()) {
            parameterValueSpec_ =
                com.google.cloud.aiplatform.v1beta1.StudySpec.ParameterSpec.DoubleValueSpec
                    .newBuilder(
                        (com.google.cloud.aiplatform.v1beta1.StudySpec.ParameterSpec
                                .DoubleValueSpec)
                            parameterValueSpec_)
                    .mergeFrom(value)
                    .buildPartial();
          } else {
            parameterValueSpec_ = value;
          }
          onChanged();
        } else {
          if (parameterValueSpecCase_ == 2) {
            doubleValueSpecBuilder_.mergeFrom(value);
          }
          doubleValueSpecBuilder_.setMessage(value);
        }
        parameterValueSpecCase_ = 2;
        return this;
      }
      /**
       *
       *
       * <pre>
       * The value spec for a 'DOUBLE' parameter.
       * </pre>
       *
       * <code>
       * .google.cloud.aiplatform.v1beta1.StudySpec.ParameterSpec.DoubleValueSpec double_value_spec = 2;
       * </code>
       */
      public Builder clearDoubleValueSpec() {
        if (doubleValueSpecBuilder_ == null) {
          if (parameterValueSpecCase_ == 2) {
            parameterValueSpecCase_ = 0;
            parameterValueSpec_ = null;
            onChanged();
          }
        } else {
          if (parameterValueSpecCase_ == 2) {
            parameterValueSpecCase_ = 0;
            parameterValueSpec_ = null;
          }
          doubleValueSpecBuilder_.clear();
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * The value spec for a 'DOUBLE' parameter.
       * </pre>
       *
       * <code>
       * .google.cloud.aiplatform.v1beta1.StudySpec.ParameterSpec.DoubleValueSpec double_value_spec = 2;
       * </code>
       */
      public com.google.cloud.aiplatform.v1beta1.StudySpec.ParameterSpec.DoubleValueSpec.Builder
          getDoubleValueSpecBuilder() {
        return getDoubleValueSpecFieldBuilder().getBuilder();
      }
      /**
       *
       *
       * <pre>
       * The value spec for a 'DOUBLE' parameter.
       * </pre>
       *
       * <code>
       * .google.cloud.aiplatform.v1beta1.StudySpec.ParameterSpec.DoubleValueSpec double_value_spec = 2;
       * </code>
       */
      @java.lang.Override
      public com.google.cloud.aiplatform.v1beta1.StudySpec.ParameterSpec.DoubleValueSpecOrBuilder
          getDoubleValueSpecOrBuilder() {
        if ((parameterValueSpecCase_ == 2) && (doubleValueSpecBuilder_ != null)) {
          return doubleValueSpecBuilder_.getMessageOrBuilder();
        } else {
          if (parameterValueSpecCase_ == 2) {
            return (com.google.cloud.aiplatform.v1beta1.StudySpec.ParameterSpec.DoubleValueSpec)
                parameterValueSpec_;
          }
          return com.google.cloud.aiplatform.v1beta1.StudySpec.ParameterSpec.DoubleValueSpec
              .getDefaultInstance();
        }
      }
      /**
       *
       *
       * <pre>
       * The value spec for a 'DOUBLE' parameter.
       * </pre>
       *
       * <code>
       * .google.cloud.aiplatform.v1beta1.StudySpec.ParameterSpec.DoubleValueSpec double_value_spec = 2;
       * </code>
       */
      private com.google.protobuf.SingleFieldBuilderV3<
              com.google.cloud.aiplatform.v1beta1.StudySpec.ParameterSpec.DoubleValueSpec,
              com.google.cloud.aiplatform.v1beta1.StudySpec.ParameterSpec.DoubleValueSpec.Builder,
              com.google.cloud.aiplatform.v1beta1.StudySpec.ParameterSpec.DoubleValueSpecOrBuilder>
          getDoubleValueSpecFieldBuilder() {
        if (doubleValueSpecBuilder_ == null) {
          if (!(parameterValueSpecCase_ == 2)) {
            parameterValueSpec_ =
                com.google.cloud.aiplatform.v1beta1.StudySpec.ParameterSpec.DoubleValueSpec
                    .getDefaultInstance();
          }
          doubleValueSpecBuilder_ =
              new com.google.protobuf.SingleFieldBuilderV3<
                  com.google.cloud.aiplatform.v1beta1.StudySpec.ParameterSpec.DoubleValueSpec,
                  com.google.cloud.aiplatform.v1beta1.StudySpec.ParameterSpec.DoubleValueSpec
                      .Builder,
                  com.google.cloud.aiplatform.v1beta1.StudySpec.ParameterSpec
                      .DoubleValueSpecOrBuilder>(
                  (com.google.cloud.aiplatform.v1beta1.StudySpec.ParameterSpec.DoubleValueSpec)
                      parameterValueSpec_,
                  getParentForChildren(),
                  isClean());
          parameterValueSpec_ = null;
        }
        parameterValueSpecCase_ = 2;
        onChanged();
        ;
        return doubleValueSpecBuilder_;
      }

      private com.google.protobuf.SingleFieldBuilderV3<
              com.google.cloud.aiplatform.v1beta1.StudySpec.ParameterSpec.IntegerValueSpec,
              com.google.cloud.aiplatform.v1beta1.StudySpec.ParameterSpec.IntegerValueSpec.Builder,
              com.google.cloud.aiplatform.v1beta1.StudySpec.ParameterSpec.IntegerValueSpecOrBuilder>
          integerValueSpecBuilder_;
      /**
       *
       *
       * <pre>
       * The value spec for an 'INTEGER' parameter.
       * </pre>
       *
       * <code>
       * .google.cloud.aiplatform.v1beta1.StudySpec.ParameterSpec.IntegerValueSpec integer_value_spec = 3;
       * </code>
       *
       * @return Whether the integerValueSpec field is set.
       */
      @java.lang.Override
      public boolean hasIntegerValueSpec() {
        return parameterValueSpecCase_ == 3;
      }
      /**
       *
       *
       * <pre>
       * The value spec for an 'INTEGER' parameter.
       * </pre>
       *
       * <code>
       * .google.cloud.aiplatform.v1beta1.StudySpec.ParameterSpec.IntegerValueSpec integer_value_spec = 3;
       * </code>
       *
       * @return The integerValueSpec.
       */
      @java.lang.Override
      public com.google.cloud.aiplatform.v1beta1.StudySpec.ParameterSpec.IntegerValueSpec
          getIntegerValueSpec() {
        if (integerValueSpecBuilder_ == null) {
          if (parameterValueSpecCase_ == 3) {
            return (com.google.cloud.aiplatform.v1beta1.StudySpec.ParameterSpec.IntegerValueSpec)
                parameterValueSpec_;
          }
          return com.google.cloud.aiplatform.v1beta1.StudySpec.ParameterSpec.IntegerValueSpec
              .getDefaultInstance();
        } else {
          if (parameterValueSpecCase_ == 3) {
            return integerValueSpecBuilder_.getMessage();
          }
          return com.google.cloud.aiplatform.v1beta1.StudySpec.ParameterSpec.IntegerValueSpec
              .getDefaultInstance();
        }
      }
      /**
       *
       *
       * <pre>
       * The value spec for an 'INTEGER' parameter.
       * </pre>
       *
       * <code>
       * .google.cloud.aiplatform.v1beta1.StudySpec.ParameterSpec.IntegerValueSpec integer_value_spec = 3;
       * </code>
       */
      public Builder setIntegerValueSpec(
          com.google.cloud.aiplatform.v1beta1.StudySpec.ParameterSpec.IntegerValueSpec value) {
        if (integerValueSpecBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          parameterValueSpec_ = value;
          onChanged();
        } else {
          integerValueSpecBuilder_.setMessage(value);
        }
        parameterValueSpecCase_ = 3;
        return this;
      }
      /**
       *
       *
       * <pre>
       * The value spec for an 'INTEGER' parameter.
       * </pre>
       *
       * <code>
       * .google.cloud.aiplatform.v1beta1.StudySpec.ParameterSpec.IntegerValueSpec integer_value_spec = 3;
       * </code>
       */
      public Builder setIntegerValueSpec(
          com.google.cloud.aiplatform.v1beta1.StudySpec.ParameterSpec.IntegerValueSpec.Builder
              builderForValue) {
        if (integerValueSpecBuilder_ == null) {
          parameterValueSpec_ = builderForValue.build();
          onChanged();
        } else {
          integerValueSpecBuilder_.setMessage(builderForValue.build());
        }
        parameterValueSpecCase_ = 3;
        return this;
      }
      /**
       *
       *
       * <pre>
       * The value spec for an 'INTEGER' parameter.
       * </pre>
       *
       * <code>
       * .google.cloud.aiplatform.v1beta1.StudySpec.ParameterSpec.IntegerValueSpec integer_value_spec = 3;
       * </code>
       */
      public Builder mergeIntegerValueSpec(
          com.google.cloud.aiplatform.v1beta1.StudySpec.ParameterSpec.IntegerValueSpec value) {
        if (integerValueSpecBuilder_ == null) {
          if (parameterValueSpecCase_ == 3
              && parameterValueSpec_
                  != com.google.cloud.aiplatform.v1beta1.StudySpec.ParameterSpec.IntegerValueSpec
                      .getDefaultInstance()) {
            parameterValueSpec_ =
                com.google.cloud.aiplatform.v1beta1.StudySpec.ParameterSpec.IntegerValueSpec
                    .newBuilder(
                        (com.google.cloud.aiplatform.v1beta1.StudySpec.ParameterSpec
                                .IntegerValueSpec)
                            parameterValueSpec_)
                    .mergeFrom(value)
                    .buildPartial();
          } else {
            parameterValueSpec_ = value;
          }
          onChanged();
        } else {
          if (parameterValueSpecCase_ == 3) {
            integerValueSpecBuilder_.mergeFrom(value);
          }
          integerValueSpecBuilder_.setMessage(value);
        }
        parameterValueSpecCase_ = 3;
        return this;
      }
      /**
       *
       *
       * <pre>
       * The value spec for an 'INTEGER' parameter.
       * </pre>
       *
       * <code>
       * .google.cloud.aiplatform.v1beta1.StudySpec.ParameterSpec.IntegerValueSpec integer_value_spec = 3;
       * </code>
       */
      public Builder clearIntegerValueSpec() {
        if (integerValueSpecBuilder_ == null) {
          if (parameterValueSpecCase_ == 3) {
            parameterValueSpecCase_ = 0;
            parameterValueSpec_ = null;
            onChanged();
          }
        } else {
          if (parameterValueSpecCase_ == 3) {
            parameterValueSpecCase_ = 0;
            parameterValueSpec_ = null;
          }
          integerValueSpecBuilder_.clear();
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * The value spec for an 'INTEGER' parameter.
       * </pre>
       *
       * <code>
       * .google.cloud.aiplatform.v1beta1.StudySpec.ParameterSpec.IntegerValueSpec integer_value_spec = 3;
       * </code>
       */
      public com.google.cloud.aiplatform.v1beta1.StudySpec.ParameterSpec.IntegerValueSpec.Builder
          getIntegerValueSpecBuilder() {
        return getIntegerValueSpecFieldBuilder().getBuilder();
      }
      /**
       *
       *
       * <pre>
       * The value spec for an 'INTEGER' parameter.
       * </pre>
       *
       * <code>
       * .google.cloud.aiplatform.v1beta1.StudySpec.ParameterSpec.IntegerValueSpec integer_value_spec = 3;
       * </code>
       */
      @java.lang.Override
      public com.google.cloud.aiplatform.v1beta1.StudySpec.ParameterSpec.IntegerValueSpecOrBuilder
          getIntegerValueSpecOrBuilder() {
        if ((parameterValueSpecCase_ == 3) && (integerValueSpecBuilder_ != null)) {
          return integerValueSpecBuilder_.getMessageOrBuilder();
        } else {
          if (parameterValueSpecCase_ == 3) {
            return (com.google.cloud.aiplatform.v1beta1.StudySpec.ParameterSpec.IntegerValueSpec)
                parameterValueSpec_;
          }
          return com.google.cloud.aiplatform.v1beta1.StudySpec.ParameterSpec.IntegerValueSpec
              .getDefaultInstance();
        }
      }
      /**
       *
       *
       * <pre>
       * The value spec for an 'INTEGER' parameter.
       * </pre>
       *
       * <code>
       * .google.cloud.aiplatform.v1beta1.StudySpec.ParameterSpec.IntegerValueSpec integer_value_spec = 3;
       * </code>
       */
      private com.google.protobuf.SingleFieldBuilderV3<
              com.google.cloud.aiplatform.v1beta1.StudySpec.ParameterSpec.IntegerValueSpec,
              com.google.cloud.aiplatform.v1beta1.StudySpec.ParameterSpec.IntegerValueSpec.Builder,
              com.google.cloud.aiplatform.v1beta1.StudySpec.ParameterSpec.IntegerValueSpecOrBuilder>
          getIntegerValueSpecFieldBuilder() {
        if (integerValueSpecBuilder_ == null) {
          if (!(parameterValueSpecCase_ == 3)) {
            parameterValueSpec_ =
                com.google.cloud.aiplatform.v1beta1.StudySpec.ParameterSpec.IntegerValueSpec
                    .getDefaultInstance();
          }
          integerValueSpecBuilder_ =
              new com.google.protobuf.SingleFieldBuilderV3<
                  com.google.cloud.aiplatform.v1beta1.StudySpec.ParameterSpec.IntegerValueSpec,
                  com.google.cloud.aiplatform.v1beta1.StudySpec.ParameterSpec.IntegerValueSpec
                      .Builder,
                  com.google.cloud.aiplatform.v1beta1.StudySpec.ParameterSpec
                      .IntegerValueSpecOrBuilder>(
                  (com.google.cloud.aiplatform.v1beta1.StudySpec.ParameterSpec.IntegerValueSpec)
                      parameterValueSpec_,
                  getParentForChildren(),
                  isClean());
          parameterValueSpec_ = null;
        }
        parameterValueSpecCase_ = 3;
        onChanged();
        ;
        return integerValueSpecBuilder_;
      }

      private com.google.protobuf.SingleFieldBuilderV3<
              com.google.cloud.aiplatform.v1beta1.StudySpec.ParameterSpec.CategoricalValueSpec,
              com.google.cloud.aiplatform.v1beta1.StudySpec.ParameterSpec.CategoricalValueSpec
                  .Builder,
              com.google.cloud.aiplatform.v1beta1.StudySpec.ParameterSpec
                  .CategoricalValueSpecOrBuilder>
          categoricalValueSpecBuilder_;
      /**
       *
       *
       * <pre>
       * The value spec for a 'CATEGORICAL' parameter.
       * </pre>
       *
       * <code>
       * .google.cloud.aiplatform.v1beta1.StudySpec.ParameterSpec.CategoricalValueSpec categorical_value_spec = 4;
       * </code>
       *
       * @return Whether the categoricalValueSpec field is set.
       */
      @java.lang.Override
      public boolean hasCategoricalValueSpec() {
        return parameterValueSpecCase_ == 4;
      }
      /**
       *
       *
       * <pre>
       * The value spec for a 'CATEGORICAL' parameter.
       * </pre>
       *
       * <code>
       * .google.cloud.aiplatform.v1beta1.StudySpec.ParameterSpec.CategoricalValueSpec categorical_value_spec = 4;
       * </code>
       *
       * @return The categoricalValueSpec.
       */
      @java.lang.Override
      public com.google.cloud.aiplatform.v1beta1.StudySpec.ParameterSpec.CategoricalValueSpec
          getCategoricalValueSpec() {
        if (categoricalValueSpecBuilder_ == null) {
          if (parameterValueSpecCase_ == 4) {
            return (com.google.cloud.aiplatform.v1beta1.StudySpec.ParameterSpec
                    .CategoricalValueSpec)
                parameterValueSpec_;
          }
          return com.google.cloud.aiplatform.v1beta1.StudySpec.ParameterSpec.CategoricalValueSpec
              .getDefaultInstance();
        } else {
          if (parameterValueSpecCase_ == 4) {
            return categoricalValueSpecBuilder_.getMessage();
          }
          return com.google.cloud.aiplatform.v1beta1.StudySpec.ParameterSpec.CategoricalValueSpec
              .getDefaultInstance();
        }
      }
      /**
       *
       *
       * <pre>
       * The value spec for a 'CATEGORICAL' parameter.
       * </pre>
       *
       * <code>
       * .google.cloud.aiplatform.v1beta1.StudySpec.ParameterSpec.CategoricalValueSpec categorical_value_spec = 4;
       * </code>
       */
      public Builder setCategoricalValueSpec(
          com.google.cloud.aiplatform.v1beta1.StudySpec.ParameterSpec.CategoricalValueSpec value) {
        if (categoricalValueSpecBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          parameterValueSpec_ = value;
          onChanged();
        } else {
          categoricalValueSpecBuilder_.setMessage(value);
        }
        parameterValueSpecCase_ = 4;
        return this;
      }
      /**
       *
       *
       * <pre>
       * The value spec for a 'CATEGORICAL' parameter.
       * </pre>
       *
       * <code>
       * .google.cloud.aiplatform.v1beta1.StudySpec.ParameterSpec.CategoricalValueSpec categorical_value_spec = 4;
       * </code>
       */
      public Builder setCategoricalValueSpec(
          com.google.cloud.aiplatform.v1beta1.StudySpec.ParameterSpec.CategoricalValueSpec.Builder
              builderForValue) {
        if (categoricalValueSpecBuilder_ == null) {
          parameterValueSpec_ = builderForValue.build();
          onChanged();
        } else {
          categoricalValueSpecBuilder_.setMessage(builderForValue.build());
        }
        parameterValueSpecCase_ = 4;
        return this;
      }
      /**
       *
       *
       * <pre>
       * The value spec for a 'CATEGORICAL' parameter.
       * </pre>
       *
       * <code>
       * .google.cloud.aiplatform.v1beta1.StudySpec.ParameterSpec.CategoricalValueSpec categorical_value_spec = 4;
       * </code>
       */
      public Builder mergeCategoricalValueSpec(
          com.google.cloud.aiplatform.v1beta1.StudySpec.ParameterSpec.CategoricalValueSpec value) {
        if (categoricalValueSpecBuilder_ == null) {
          if (parameterValueSpecCase_ == 4
              && parameterValueSpec_
                  != com.google.cloud.aiplatform.v1beta1.StudySpec.ParameterSpec
                      .CategoricalValueSpec.getDefaultInstance()) {
            parameterValueSpec_ =
                com.google.cloud.aiplatform.v1beta1.StudySpec.ParameterSpec.CategoricalValueSpec
                    .newBuilder(
                        (com.google.cloud.aiplatform.v1beta1.StudySpec.ParameterSpec
                                .CategoricalValueSpec)
                            parameterValueSpec_)
                    .mergeFrom(value)
                    .buildPartial();
          } else {
            parameterValueSpec_ = value;
          }
          onChanged();
        } else {
          if (parameterValueSpecCase_ == 4) {
            categoricalValueSpecBuilder_.mergeFrom(value);
          }
          categoricalValueSpecBuilder_.setMessage(value);
        }
        parameterValueSpecCase_ = 4;
        return this;
      }
      /**
       *
       *
       * <pre>
       * The value spec for a 'CATEGORICAL' parameter.
       * </pre>
       *
       * <code>
       * .google.cloud.aiplatform.v1beta1.StudySpec.ParameterSpec.CategoricalValueSpec categorical_value_spec = 4;
       * </code>
       */
      public Builder clearCategoricalValueSpec() {
        if (categoricalValueSpecBuilder_ == null) {
          if (parameterValueSpecCase_ == 4) {
            parameterValueSpecCase_ = 0;
            parameterValueSpec_ = null;
            onChanged();
          }
        } else {
          if (parameterValueSpecCase_ == 4) {
            parameterValueSpecCase_ = 0;
            parameterValueSpec_ = null;
          }
          categoricalValueSpecBuilder_.clear();
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * The value spec for a 'CATEGORICAL' parameter.
       * </pre>
       *
       * <code>
       * .google.cloud.aiplatform.v1beta1.StudySpec.ParameterSpec.CategoricalValueSpec categorical_value_spec = 4;
       * </code>
       */
      public com.google.cloud.aiplatform.v1beta1.StudySpec.ParameterSpec.CategoricalValueSpec
              .Builder
          getCategoricalValueSpecBuilder() {
        return getCategoricalValueSpecFieldBuilder().getBuilder();
      }
      /**
       *
       *
       * <pre>
       * The value spec for a 'CATEGORICAL' parameter.
       * </pre>
       *
       * <code>
       * .google.cloud.aiplatform.v1beta1.StudySpec.ParameterSpec.CategoricalValueSpec categorical_value_spec = 4;
       * </code>
       */
      @java.lang.Override
      public com.google.cloud.aiplatform.v1beta1.StudySpec.ParameterSpec
              .CategoricalValueSpecOrBuilder
          getCategoricalValueSpecOrBuilder() {
        if ((parameterValueSpecCase_ == 4) && (categoricalValueSpecBuilder_ != null)) {
          return categoricalValueSpecBuilder_.getMessageOrBuilder();
        } else {
          if (parameterValueSpecCase_ == 4) {
            return (com.google.cloud.aiplatform.v1beta1.StudySpec.ParameterSpec
                    .CategoricalValueSpec)
                parameterValueSpec_;
          }
          return com.google.cloud.aiplatform.v1beta1.StudySpec.ParameterSpec.CategoricalValueSpec
              .getDefaultInstance();
        }
      }
      /**
       *
       *
       * <pre>
       * The value spec for a 'CATEGORICAL' parameter.
       * </pre>
       *
       * <code>
       * .google.cloud.aiplatform.v1beta1.StudySpec.ParameterSpec.CategoricalValueSpec categorical_value_spec = 4;
       * </code>
       */
      private com.google.protobuf.SingleFieldBuilderV3<
              com.google.cloud.aiplatform.v1beta1.StudySpec.ParameterSpec.CategoricalValueSpec,
              com.google.cloud.aiplatform.v1beta1.StudySpec.ParameterSpec.CategoricalValueSpec
                  .Builder,
              com.google.cloud.aiplatform.v1beta1.StudySpec.ParameterSpec
                  .CategoricalValueSpecOrBuilder>
          getCategoricalValueSpecFieldBuilder() {
        if (categoricalValueSpecBuilder_ == null) {
          if (!(parameterValueSpecCase_ == 4)) {
            parameterValueSpec_ =
                com.google.cloud.aiplatform.v1beta1.StudySpec.ParameterSpec.CategoricalValueSpec
                    .getDefaultInstance();
          }
          categoricalValueSpecBuilder_ =
              new com.google.protobuf.SingleFieldBuilderV3<
                  com.google.cloud.aiplatform.v1beta1.StudySpec.ParameterSpec.CategoricalValueSpec,
                  com.google.cloud.aiplatform.v1beta1.StudySpec.ParameterSpec.CategoricalValueSpec
                      .Builder,
                  com.google.cloud.aiplatform.v1beta1.StudySpec.ParameterSpec
                      .CategoricalValueSpecOrBuilder>(
                  (com.google.cloud.aiplatform.v1beta1.StudySpec.ParameterSpec.CategoricalValueSpec)
                      parameterValueSpec_,
                  getParentForChildren(),
                  isClean());
          parameterValueSpec_ = null;
        }
        parameterValueSpecCase_ = 4;
        onChanged();
        ;
        return categoricalValueSpecBuilder_;
      }

      private com.google.protobuf.SingleFieldBuilderV3<
              com.google.cloud.aiplatform.v1beta1.StudySpec.ParameterSpec.DiscreteValueSpec,
              com.google.cloud.aiplatform.v1beta1.StudySpec.ParameterSpec.DiscreteValueSpec.Builder,
              com.google.cloud.aiplatform.v1beta1.StudySpec.ParameterSpec
                  .DiscreteValueSpecOrBuilder>
          discreteValueSpecBuilder_;
      /**
       *
       *
       * <pre>
       * The value spec for a 'DISCRETE' parameter.
       * </pre>
       *
       * <code>
       * .google.cloud.aiplatform.v1beta1.StudySpec.ParameterSpec.DiscreteValueSpec discrete_value_spec = 5;
       * </code>
       *
       * @return Whether the discreteValueSpec field is set.
       */
      @java.lang.Override
      public boolean hasDiscreteValueSpec() {
        return parameterValueSpecCase_ == 5;
      }
      /**
       *
       *
       * <pre>
       * The value spec for a 'DISCRETE' parameter.
       * </pre>
       *
       * <code>
       * .google.cloud.aiplatform.v1beta1.StudySpec.ParameterSpec.DiscreteValueSpec discrete_value_spec = 5;
       * </code>
       *
       * @return The discreteValueSpec.
       */
      @java.lang.Override
      public com.google.cloud.aiplatform.v1beta1.StudySpec.ParameterSpec.DiscreteValueSpec
          getDiscreteValueSpec() {
        if (discreteValueSpecBuilder_ == null) {
          if (parameterValueSpecCase_ == 5) {
            return (com.google.cloud.aiplatform.v1beta1.StudySpec.ParameterSpec.DiscreteValueSpec)
                parameterValueSpec_;
          }
          return com.google.cloud.aiplatform.v1beta1.StudySpec.ParameterSpec.DiscreteValueSpec
              .getDefaultInstance();
        } else {
          if (parameterValueSpecCase_ == 5) {
            return discreteValueSpecBuilder_.getMessage();
          }
          return com.google.cloud.aiplatform.v1beta1.StudySpec.ParameterSpec.DiscreteValueSpec
              .getDefaultInstance();
        }
      }
      /**
       *
       *
       * <pre>
       * The value spec for a 'DISCRETE' parameter.
       * </pre>
       *
       * <code>
       * .google.cloud.aiplatform.v1beta1.StudySpec.ParameterSpec.DiscreteValueSpec discrete_value_spec = 5;
       * </code>
       */
      public Builder setDiscreteValueSpec(
          com.google.cloud.aiplatform.v1beta1.StudySpec.ParameterSpec.DiscreteValueSpec value) {
        if (discreteValueSpecBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          parameterValueSpec_ = value;
          onChanged();
        } else {
          discreteValueSpecBuilder_.setMessage(value);
        }
        parameterValueSpecCase_ = 5;
        return this;
      }
      /**
       *
       *
       * <pre>
       * The value spec for a 'DISCRETE' parameter.
       * </pre>
       *
       * <code>
       * .google.cloud.aiplatform.v1beta1.StudySpec.ParameterSpec.DiscreteValueSpec discrete_value_spec = 5;
       * </code>
       */
      public Builder setDiscreteValueSpec(
          com.google.cloud.aiplatform.v1beta1.StudySpec.ParameterSpec.DiscreteValueSpec.Builder
              builderForValue) {
        if (discreteValueSpecBuilder_ == null) {
          parameterValueSpec_ = builderForValue.build();
          onChanged();
        } else {
          discreteValueSpecBuilder_.setMessage(builderForValue.build());
        }
        parameterValueSpecCase_ = 5;
        return this;
      }
      /**
       *
       *
       * <pre>
       * The value spec for a 'DISCRETE' parameter.
       * </pre>
       *
       * <code>
       * .google.cloud.aiplatform.v1beta1.StudySpec.ParameterSpec.DiscreteValueSpec discrete_value_spec = 5;
       * </code>
       */
      public Builder mergeDiscreteValueSpec(
          com.google.cloud.aiplatform.v1beta1.StudySpec.ParameterSpec.DiscreteValueSpec value) {
        if (discreteValueSpecBuilder_ == null) {
          if (parameterValueSpecCase_ == 5
              && parameterValueSpec_
                  != com.google.cloud.aiplatform.v1beta1.StudySpec.ParameterSpec.DiscreteValueSpec
                      .getDefaultInstance()) {
            parameterValueSpec_ =
                com.google.cloud.aiplatform.v1beta1.StudySpec.ParameterSpec.DiscreteValueSpec
                    .newBuilder(
                        (com.google.cloud.aiplatform.v1beta1.StudySpec.ParameterSpec
                                .DiscreteValueSpec)
                            parameterValueSpec_)
                    .mergeFrom(value)
                    .buildPartial();
          } else {
            parameterValueSpec_ = value;
          }
          onChanged();
        } else {
          if (parameterValueSpecCase_ == 5) {
            discreteValueSpecBuilder_.mergeFrom(value);
          }
          discreteValueSpecBuilder_.setMessage(value);
        }
        parameterValueSpecCase_ = 5;
        return this;
      }
      /**
       *
       *
       * <pre>
       * The value spec for a 'DISCRETE' parameter.
       * </pre>
       *
       * <code>
       * .google.cloud.aiplatform.v1beta1.StudySpec.ParameterSpec.DiscreteValueSpec discrete_value_spec = 5;
       * </code>
       */
      public Builder clearDiscreteValueSpec() {
        if (discreteValueSpecBuilder_ == null) {
          if (parameterValueSpecCase_ == 5) {
            parameterValueSpecCase_ = 0;
            parameterValueSpec_ = null;
            onChanged();
          }
        } else {
          if (parameterValueSpecCase_ == 5) {
            parameterValueSpecCase_ = 0;
            parameterValueSpec_ = null;
          }
          discreteValueSpecBuilder_.clear();
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * The value spec for a 'DISCRETE' parameter.
       * </pre>
       *
       * <code>
       * .google.cloud.aiplatform.v1beta1.StudySpec.ParameterSpec.DiscreteValueSpec discrete_value_spec = 5;
       * </code>
       */
      public com.google.cloud.aiplatform.v1beta1.StudySpec.ParameterSpec.DiscreteValueSpec.Builder
          getDiscreteValueSpecBuilder() {
        return getDiscreteValueSpecFieldBuilder().getBuilder();
      }
      /**
       *
       *
       * <pre>
       * The value spec for a 'DISCRETE' parameter.
       * </pre>
       *
       * <code>
       * .google.cloud.aiplatform.v1beta1.StudySpec.ParameterSpec.DiscreteValueSpec discrete_value_spec = 5;
       * </code>
       */
      @java.lang.Override
      public com.google.cloud.aiplatform.v1beta1.StudySpec.ParameterSpec.DiscreteValueSpecOrBuilder
          getDiscreteValueSpecOrBuilder() {
        if ((parameterValueSpecCase_ == 5) && (discreteValueSpecBuilder_ != null)) {
          return discreteValueSpecBuilder_.getMessageOrBuilder();
        } else {
          if (parameterValueSpecCase_ == 5) {
            return (com.google.cloud.aiplatform.v1beta1.StudySpec.ParameterSpec.DiscreteValueSpec)
                parameterValueSpec_;
          }
          return com.google.cloud.aiplatform.v1beta1.StudySpec.ParameterSpec.DiscreteValueSpec
              .getDefaultInstance();
        }
      }
      /**
       *
       *
       * <pre>
       * The value spec for a 'DISCRETE' parameter.
       * </pre>
       *
       * <code>
       * .google.cloud.aiplatform.v1beta1.StudySpec.ParameterSpec.DiscreteValueSpec discrete_value_spec = 5;
       * </code>
       */
      private com.google.protobuf.SingleFieldBuilderV3<
              com.google.cloud.aiplatform.v1beta1.StudySpec.ParameterSpec.DiscreteValueSpec,
              com.google.cloud.aiplatform.v1beta1.StudySpec.ParameterSpec.DiscreteValueSpec.Builder,
              com.google.cloud.aiplatform.v1beta1.StudySpec.ParameterSpec
                  .DiscreteValueSpecOrBuilder>
          getDiscreteValueSpecFieldBuilder() {
        if (discreteValueSpecBuilder_ == null) {
          if (!(parameterValueSpecCase_ == 5)) {
            parameterValueSpec_ =
                com.google.cloud.aiplatform.v1beta1.StudySpec.ParameterSpec.DiscreteValueSpec
                    .getDefaultInstance();
          }
          discreteValueSpecBuilder_ =
              new com.google.protobuf.SingleFieldBuilderV3<
                  com.google.cloud.aiplatform.v1beta1.StudySpec.ParameterSpec.DiscreteValueSpec,
                  com.google.cloud.aiplatform.v1beta1.StudySpec.ParameterSpec.DiscreteValueSpec
                      .Builder,
                  com.google.cloud.aiplatform.v1beta1.StudySpec.ParameterSpec
                      .DiscreteValueSpecOrBuilder>(
                  (com.google.cloud.aiplatform.v1beta1.StudySpec.ParameterSpec.DiscreteValueSpec)
                      parameterValueSpec_,
                  getParentForChildren(),
                  isClean());
          parameterValueSpec_ = null;
        }
        parameterValueSpecCase_ = 5;
        onChanged();
        ;
        return discreteValueSpecBuilder_;
      }

      private java.lang.Object parameterId_ = "";
      /**
       *
       *
       * <pre>
       * Required. The ID of the parameter. Must not contain whitespaces and must be unique
       * amongst all ParameterSpecs.
       * </pre>
       *
       * <code>string parameter_id = 1 [(.google.api.field_behavior) = REQUIRED];</code>
       *
       * @return The parameterId.
       */
      public java.lang.String getParameterId() {
        java.lang.Object ref = parameterId_;
        if (!(ref instanceof java.lang.String)) {
          com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
          java.lang.String s = bs.toStringUtf8();
          parameterId_ = s;
          return s;
        } else {
          return (java.lang.String) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * Required. The ID of the parameter. Must not contain whitespaces and must be unique
       * amongst all ParameterSpecs.
       * </pre>
       *
       * <code>string parameter_id = 1 [(.google.api.field_behavior) = REQUIRED];</code>
       *
       * @return The bytes for parameterId.
       */
      public com.google.protobuf.ByteString getParameterIdBytes() {
        java.lang.Object ref = parameterId_;
        if (ref instanceof String) {
          com.google.protobuf.ByteString b =
              com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
          parameterId_ = b;
          return b;
        } else {
          return (com.google.protobuf.ByteString) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * Required. The ID of the parameter. Must not contain whitespaces and must be unique
       * amongst all ParameterSpecs.
       * </pre>
       *
       * <code>string parameter_id = 1 [(.google.api.field_behavior) = REQUIRED];</code>
       *
       * @param value The parameterId to set.
       * @return This builder for chaining.
       */
      public Builder setParameterId(java.lang.String value) {
        if (value == null) {
          throw new NullPointerException();
        }

        parameterId_ = value;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Required. The ID of the parameter. Must not contain whitespaces and must be unique
       * amongst all ParameterSpecs.
       * </pre>
       *
       * <code>string parameter_id = 1 [(.google.api.field_behavior) = REQUIRED];</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearParameterId() {

        parameterId_ = getDefaultInstance().getParameterId();
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Required. The ID of the parameter. Must not contain whitespaces and must be unique
       * amongst all ParameterSpecs.
       * </pre>
       *
       * <code>string parameter_id = 1 [(.google.api.field_behavior) = REQUIRED];</code>
       *
       * @param value The bytes for parameterId to set.
       * @return This builder for chaining.
       */
      public Builder setParameterIdBytes(com.google.protobuf.ByteString value) {
        if (value == null) {
          throw new NullPointerException();
        }
        checkByteStringIsUtf8(value);

        parameterId_ = value;
        onChanged();
        return this;
      }

      private int scaleType_ = 0;
      /**
       *
       *
       * <pre>
       * How the parameter should be scaled.
       * Leave unset for `CATEGORICAL` parameters.
       * </pre>
       *
       * <code>.google.cloud.aiplatform.v1beta1.StudySpec.ParameterSpec.ScaleType scale_type = 6;
       * </code>
       *
       * @return The enum numeric value on the wire for scaleType.
       */
      @java.lang.Override
      public int getScaleTypeValue() {
        return scaleType_;
      }
      /**
       *
       *
       * <pre>
       * How the parameter should be scaled.
       * Leave unset for `CATEGORICAL` parameters.
       * </pre>
       *
       * <code>.google.cloud.aiplatform.v1beta1.StudySpec.ParameterSpec.ScaleType scale_type = 6;
       * </code>
       *
       * @param value The enum numeric value on the wire for scaleType to set.
       * @return This builder for chaining.
       */
      public Builder setScaleTypeValue(int value) {

        scaleType_ = value;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * How the parameter should be scaled.
       * Leave unset for `CATEGORICAL` parameters.
       * </pre>
       *
       * <code>.google.cloud.aiplatform.v1beta1.StudySpec.ParameterSpec.ScaleType scale_type = 6;
       * </code>
       *
       * @return The scaleType.
       */
      @java.lang.Override
      public com.google.cloud.aiplatform.v1beta1.StudySpec.ParameterSpec.ScaleType getScaleType() {
        @SuppressWarnings("deprecation")
        com.google.cloud.aiplatform.v1beta1.StudySpec.ParameterSpec.ScaleType result =
            com.google.cloud.aiplatform.v1beta1.StudySpec.ParameterSpec.ScaleType.valueOf(
                scaleType_);
        return result == null
            ? com.google.cloud.aiplatform.v1beta1.StudySpec.ParameterSpec.ScaleType.UNRECOGNIZED
            : result;
      }
      /**
       *
       *
       * <pre>
       * How the parameter should be scaled.
       * Leave unset for `CATEGORICAL` parameters.
       * </pre>
       *
       * <code>.google.cloud.aiplatform.v1beta1.StudySpec.ParameterSpec.ScaleType scale_type = 6;
       * </code>
       *
       * @param value The scaleType to set.
       * @return This builder for chaining.
       */
      public Builder setScaleType(
          com.google.cloud.aiplatform.v1beta1.StudySpec.ParameterSpec.ScaleType value) {
        if (value == null) {
          throw new NullPointerException();
        }

        scaleType_ = value.getNumber();
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * How the parameter should be scaled.
       * Leave unset for `CATEGORICAL` parameters.
       * </pre>
       *
       * <code>.google.cloud.aiplatform.v1beta1.StudySpec.ParameterSpec.ScaleType scale_type = 6;
       * </code>
       *
       * @return This builder for chaining.
       */
      public Builder clearScaleType() {

        scaleType_ = 0;
        onChanged();
        return this;
      }

      private java.util.List<
              com.google.cloud.aiplatform.v1beta1.StudySpec.ParameterSpec.ConditionalParameterSpec>
          conditionalParameterSpecs_ = java.util.Collections.emptyList();

      private void ensureConditionalParameterSpecsIsMutable() {
        if (!((bitField0_ & 0x00000001) != 0)) {
          conditionalParameterSpecs_ =
              new java.util.ArrayList<
                  com.google.cloud.aiplatform.v1beta1.StudySpec.ParameterSpec
                      .ConditionalParameterSpec>(conditionalParameterSpecs_);
          bitField0_ |= 0x00000001;
        }
      }

      private com.google.protobuf.RepeatedFieldBuilderV3<
              com.google.cloud.aiplatform.v1beta1.StudySpec.ParameterSpec.ConditionalParameterSpec,
              com.google.cloud.aiplatform.v1beta1.StudySpec.ParameterSpec.ConditionalParameterSpec
                  .Builder,
              com.google.cloud.aiplatform.v1beta1.StudySpec.ParameterSpec
                  .ConditionalParameterSpecOrBuilder>
          conditionalParameterSpecsBuilder_;

      /**
       *
       *
       * <pre>
       * A conditional parameter node is active if the parameter's value matches
       * the conditional node's parent_value_condition.
       * If two items in conditional_parameter_specs have the same name, they
       * must have disjoint parent_value_condition.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.aiplatform.v1beta1.StudySpec.ParameterSpec.ConditionalParameterSpec conditional_parameter_specs = 10;
       * </code>
       */
      public java.util.List<
              com.google.cloud.aiplatform.v1beta1.StudySpec.ParameterSpec.ConditionalParameterSpec>
          getConditionalParameterSpecsList() {
        if (conditionalParameterSpecsBuilder_ == null) {
          return java.util.Collections.unmodifiableList(conditionalParameterSpecs_);
        } else {
          return conditionalParameterSpecsBuilder_.getMessageList();
        }
      }
      /**
       *
       *
       * <pre>
       * A conditional parameter node is active if the parameter's value matches
       * the conditional node's parent_value_condition.
       * If two items in conditional_parameter_specs have the same name, they
       * must have disjoint parent_value_condition.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.aiplatform.v1beta1.StudySpec.ParameterSpec.ConditionalParameterSpec conditional_parameter_specs = 10;
       * </code>
       */
      public int getConditionalParameterSpecsCount() {
        if (conditionalParameterSpecsBuilder_ == null) {
          return conditionalParameterSpecs_.size();
        } else {
          return conditionalParameterSpecsBuilder_.getCount();
        }
      }
      /**
       *
       *
       * <pre>
       * A conditional parameter node is active if the parameter's value matches
       * the conditional node's parent_value_condition.
       * If two items in conditional_parameter_specs have the same name, they
       * must have disjoint parent_value_condition.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.aiplatform.v1beta1.StudySpec.ParameterSpec.ConditionalParameterSpec conditional_parameter_specs = 10;
       * </code>
       */
      public com.google.cloud.aiplatform.v1beta1.StudySpec.ParameterSpec.ConditionalParameterSpec
          getConditionalParameterSpecs(int index) {
        if (conditionalParameterSpecsBuilder_ == null) {
          return conditionalParameterSpecs_.get(index);
        } else {
          return conditionalParameterSpecsBuilder_.getMessage(index);
        }
      }
      /**
       *
       *
       * <pre>
       * A conditional parameter node is active if the parameter's value matches
       * the conditional node's parent_value_condition.
       * If two items in conditional_parameter_specs have the same name, they
       * must have disjoint parent_value_condition.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.aiplatform.v1beta1.StudySpec.ParameterSpec.ConditionalParameterSpec conditional_parameter_specs = 10;
       * </code>
       */
      public Builder setConditionalParameterSpecs(
          int index,
          com.google.cloud.aiplatform.v1beta1.StudySpec.ParameterSpec.ConditionalParameterSpec
              value) {
        if (conditionalParameterSpecsBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          ensureConditionalParameterSpecsIsMutable();
          conditionalParameterSpecs_.set(index, value);
          onChanged();
        } else {
          conditionalParameterSpecsBuilder_.setMessage(index, value);
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * A conditional parameter node is active if the parameter's value matches
       * the conditional node's parent_value_condition.
       * If two items in conditional_parameter_specs have the same name, they
       * must have disjoint parent_value_condition.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.aiplatform.v1beta1.StudySpec.ParameterSpec.ConditionalParameterSpec conditional_parameter_specs = 10;
       * </code>
       */
      public Builder setConditionalParameterSpecs(
          int index,
          com.google.cloud.aiplatform.v1beta1.StudySpec.ParameterSpec.ConditionalParameterSpec
                  .Builder
              builderForValue) {
        if (conditionalParameterSpecsBuilder_ == null) {
          ensureConditionalParameterSpecsIsMutable();
          conditionalParameterSpecs_.set(index, builderForValue.build());
          onChanged();
        } else {
          conditionalParameterSpecsBuilder_.setMessage(index, builderForValue.build());
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * A conditional parameter node is active if the parameter's value matches
       * the conditional node's parent_value_condition.
       * If two items in conditional_parameter_specs have the same name, they
       * must have disjoint parent_value_condition.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.aiplatform.v1beta1.StudySpec.ParameterSpec.ConditionalParameterSpec conditional_parameter_specs = 10;
       * </code>
       */
      public Builder addConditionalParameterSpecs(
          com.google.cloud.aiplatform.v1beta1.StudySpec.ParameterSpec.ConditionalParameterSpec
              value) {
        if (conditionalParameterSpecsBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          ensureConditionalParameterSpecsIsMutable();
          conditionalParameterSpecs_.add(value);
          onChanged();
        } else {
          conditionalParameterSpecsBuilder_.addMessage(value);
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * A conditional parameter node is active if the parameter's value matches
       * the conditional node's parent_value_condition.
       * If two items in conditional_parameter_specs have the same name, they
       * must have disjoint parent_value_condition.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.aiplatform.v1beta1.StudySpec.ParameterSpec.ConditionalParameterSpec conditional_parameter_specs = 10;
       * </code>
       */
      public Builder addConditionalParameterSpecs(
          int index,
          com.google.cloud.aiplatform.v1beta1.StudySpec.ParameterSpec.ConditionalParameterSpec
              value) {
        if (conditionalParameterSpecsBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          ensureConditionalParameterSpecsIsMutable();
          conditionalParameterSpecs_.add(index, value);
          onChanged();
        } else {
          conditionalParameterSpecsBuilder_.addMessage(index, value);
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * A conditional parameter node is active if the parameter's value matches
       * the conditional node's parent_value_condition.
       * If two items in conditional_parameter_specs have the same name, they
       * must have disjoint parent_value_condition.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.aiplatform.v1beta1.StudySpec.ParameterSpec.ConditionalParameterSpec conditional_parameter_specs = 10;
       * </code>
       */
      public Builder addConditionalParameterSpecs(
          com.google.cloud.aiplatform.v1beta1.StudySpec.ParameterSpec.ConditionalParameterSpec
                  .Builder
              builderForValue) {
        if (conditionalParameterSpecsBuilder_ == null) {
          ensureConditionalParameterSpecsIsMutable();
          conditionalParameterSpecs_.add(builderForValue.build());
          onChanged();
        } else {
          conditionalParameterSpecsBuilder_.addMessage(builderForValue.build());
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * A conditional parameter node is active if the parameter's value matches
       * the conditional node's parent_value_condition.
       * If two items in conditional_parameter_specs have the same name, they
       * must have disjoint parent_value_condition.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.aiplatform.v1beta1.StudySpec.ParameterSpec.ConditionalParameterSpec conditional_parameter_specs = 10;
       * </code>
       */
      public Builder addConditionalParameterSpecs(
          int index,
          com.google.cloud.aiplatform.v1beta1.StudySpec.ParameterSpec.ConditionalParameterSpec
                  .Builder
              builderForValue) {
        if (conditionalParameterSpecsBuilder_ == null) {
          ensureConditionalParameterSpecsIsMutable();
          conditionalParameterSpecs_.add(index, builderForValue.build());
          onChanged();
        } else {
          conditionalParameterSpecsBuilder_.addMessage(index, builderForValue.build());
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * A conditional parameter node is active if the parameter's value matches
       * the conditional node's parent_value_condition.
       * If two items in conditional_parameter_specs have the same name, they
       * must have disjoint parent_value_condition.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.aiplatform.v1beta1.StudySpec.ParameterSpec.ConditionalParameterSpec conditional_parameter_specs = 10;
       * </code>
       */
      public Builder addAllConditionalParameterSpecs(
          java.lang.Iterable<
                  ? extends
                      com.google.cloud.aiplatform.v1beta1.StudySpec.ParameterSpec
                          .ConditionalParameterSpec>
              values) {
        if (conditionalParameterSpecsBuilder_ == null) {
          ensureConditionalParameterSpecsIsMutable();
          com.google.protobuf.AbstractMessageLite.Builder.addAll(
              values, conditionalParameterSpecs_);
          onChanged();
        } else {
          conditionalParameterSpecsBuilder_.addAllMessages(values);
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * A conditional parameter node is active if the parameter's value matches
       * the conditional node's parent_value_condition.
       * If two items in conditional_parameter_specs have the same name, they
       * must have disjoint parent_value_condition.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.aiplatform.v1beta1.StudySpec.ParameterSpec.ConditionalParameterSpec conditional_parameter_specs = 10;
       * </code>
       */
      public Builder clearConditionalParameterSpecs() {
        if (conditionalParameterSpecsBuilder_ == null) {
          conditionalParameterSpecs_ = java.util.Collections.emptyList();
          bitField0_ = (bitField0_ & ~0x00000001);
          onChanged();
        } else {
          conditionalParameterSpecsBuilder_.clear();
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * A conditional parameter node is active if the parameter's value matches
       * the conditional node's parent_value_condition.
       * If two items in conditional_parameter_specs have the same name, they
       * must have disjoint parent_value_condition.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.aiplatform.v1beta1.StudySpec.ParameterSpec.ConditionalParameterSpec conditional_parameter_specs = 10;
       * </code>
       */
      public Builder removeConditionalParameterSpecs(int index) {
        if (conditionalParameterSpecsBuilder_ == null) {
          ensureConditionalParameterSpecsIsMutable();
          conditionalParameterSpecs_.remove(index);
          onChanged();
        } else {
          conditionalParameterSpecsBuilder_.remove(index);
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * A conditional parameter node is active if the parameter's value matches
       * the conditional node's parent_value_condition.
       * If two items in conditional_parameter_specs have the same name, they
       * must have disjoint parent_value_condition.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.aiplatform.v1beta1.StudySpec.ParameterSpec.ConditionalParameterSpec conditional_parameter_specs = 10;
       * </code>
       */
      public com.google.cloud.aiplatform.v1beta1.StudySpec.ParameterSpec.ConditionalParameterSpec
              .Builder
          getConditionalParameterSpecsBuilder(int index) {
        return getConditionalParameterSpecsFieldBuilder().getBuilder(index);
      }
      /**
       *
       *
       * <pre>
       * A conditional parameter node is active if the parameter's value matches
       * the conditional node's parent_value_condition.
       * If two items in conditional_parameter_specs have the same name, they
       * must have disjoint parent_value_condition.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.aiplatform.v1beta1.StudySpec.ParameterSpec.ConditionalParameterSpec conditional_parameter_specs = 10;
       * </code>
       */
      public com.google.cloud.aiplatform.v1beta1.StudySpec.ParameterSpec
              .ConditionalParameterSpecOrBuilder
          getConditionalParameterSpecsOrBuilder(int index) {
        if (conditionalParameterSpecsBuilder_ == null) {
          return conditionalParameterSpecs_.get(index);
        } else {
          return conditionalParameterSpecsBuilder_.getMessageOrBuilder(index);
        }
      }
      /**
       *
       *
       * <pre>
       * A conditional parameter node is active if the parameter's value matches
       * the conditional node's parent_value_condition.
       * If two items in conditional_parameter_specs have the same name, they
       * must have disjoint parent_value_condition.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.aiplatform.v1beta1.StudySpec.ParameterSpec.ConditionalParameterSpec conditional_parameter_specs = 10;
       * </code>
       */
      public java.util.List<
              ? extends
                  com.google.cloud.aiplatform.v1beta1.StudySpec.ParameterSpec
                      .ConditionalParameterSpecOrBuilder>
          getConditionalParameterSpecsOrBuilderList() {
        if (conditionalParameterSpecsBuilder_ != null) {
          return conditionalParameterSpecsBuilder_.getMessageOrBuilderList();
        } else {
          return java.util.Collections.unmodifiableList(conditionalParameterSpecs_);
        }
      }
      /**
       *
       *
       * <pre>
       * A conditional parameter node is active if the parameter's value matches
       * the conditional node's parent_value_condition.
       * If two items in conditional_parameter_specs have the same name, they
       * must have disjoint parent_value_condition.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.aiplatform.v1beta1.StudySpec.ParameterSpec.ConditionalParameterSpec conditional_parameter_specs = 10;
       * </code>
       */
      public com.google.cloud.aiplatform.v1beta1.StudySpec.ParameterSpec.ConditionalParameterSpec
              .Builder
          addConditionalParameterSpecsBuilder() {
        return getConditionalParameterSpecsFieldBuilder()
            .addBuilder(
                com.google.cloud.aiplatform.v1beta1.StudySpec.ParameterSpec.ConditionalParameterSpec
                    .getDefaultInstance());
      }
      /**
       *
       *
       * <pre>
       * A conditional parameter node is active if the parameter's value matches
       * the conditional node's parent_value_condition.
       * If two items in conditional_parameter_specs have the same name, they
       * must have disjoint parent_value_condition.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.aiplatform.v1beta1.StudySpec.ParameterSpec.ConditionalParameterSpec conditional_parameter_specs = 10;
       * </code>
       */
      public com.google.cloud.aiplatform.v1beta1.StudySpec.ParameterSpec.ConditionalParameterSpec
              .Builder
          addConditionalParameterSpecsBuilder(int index) {
        return getConditionalParameterSpecsFieldBuilder()
            .addBuilder(
                index,
                com.google.cloud.aiplatform.v1beta1.StudySpec.ParameterSpec.ConditionalParameterSpec
                    .getDefaultInstance());
      }
      /**
       *
       *
       * <pre>
       * A conditional parameter node is active if the parameter's value matches
       * the conditional node's parent_value_condition.
       * If two items in conditional_parameter_specs have the same name, they
       * must have disjoint parent_value_condition.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.aiplatform.v1beta1.StudySpec.ParameterSpec.ConditionalParameterSpec conditional_parameter_specs = 10;
       * </code>
       */
      public java.util.List<
              com.google.cloud.aiplatform.v1beta1.StudySpec.ParameterSpec.ConditionalParameterSpec
                  .Builder>
          getConditionalParameterSpecsBuilderList() {
        return getConditionalParameterSpecsFieldBuilder().getBuilderList();
      }

      private com.google.protobuf.RepeatedFieldBuilderV3<
              com.google.cloud.aiplatform.v1beta1.StudySpec.ParameterSpec.ConditionalParameterSpec,
              com.google.cloud.aiplatform.v1beta1.StudySpec.ParameterSpec.ConditionalParameterSpec
                  .Builder,
              com.google.cloud.aiplatform.v1beta1.StudySpec.ParameterSpec
                  .ConditionalParameterSpecOrBuilder>
          getConditionalParameterSpecsFieldBuilder() {
        if (conditionalParameterSpecsBuilder_ == null) {
          conditionalParameterSpecsBuilder_ =
              new com.google.protobuf.RepeatedFieldBuilderV3<
                  com.google.cloud.aiplatform.v1beta1.StudySpec.ParameterSpec
                      .ConditionalParameterSpec,
                  com.google.cloud.aiplatform.v1beta1.StudySpec.ParameterSpec
                      .ConditionalParameterSpec.Builder,
                  com.google.cloud.aiplatform.v1beta1.StudySpec.ParameterSpec
                      .ConditionalParameterSpecOrBuilder>(
                  conditionalParameterSpecs_,
                  ((bitField0_ & 0x00000001) != 0),
                  getParentForChildren(),
                  isClean());
          conditionalParameterSpecs_ = null;
        }
        return conditionalParameterSpecsBuilder_;
      }

      @java.lang.Override
      public final Builder setUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.setUnknownFields(unknownFields);
      }

      @java.lang.Override
      public final Builder mergeUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.mergeUnknownFields(unknownFields);
      }

      // @@protoc_insertion_point(builder_scope:google.cloud.aiplatform.v1beta1.StudySpec.ParameterSpec)
    }

    // @@protoc_insertion_point(class_scope:google.cloud.aiplatform.v1beta1.StudySpec.ParameterSpec)
    private static final com.google.cloud.aiplatform.v1beta1.StudySpec.ParameterSpec
        DEFAULT_INSTANCE;

    static {
      DEFAULT_INSTANCE = new com.google.cloud.aiplatform.v1beta1.StudySpec.ParameterSpec();
    }

    public static com.google.cloud.aiplatform.v1beta1.StudySpec.ParameterSpec getDefaultInstance() {
      return DEFAULT_INSTANCE;
    }

    private static final com.google.protobuf.Parser<ParameterSpec> PARSER =
        new com.google.protobuf.AbstractParser<ParameterSpec>() {
          @java.lang.Override
          public ParameterSpec parsePartialFrom(
              com.google.protobuf.CodedInputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
            return new ParameterSpec(input, extensionRegistry);
          }
        };

    public static com.google.protobuf.Parser<ParameterSpec> parser() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.protobuf.Parser<ParameterSpec> getParserForType() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.cloud.aiplatform.v1beta1.StudySpec.ParameterSpec getDefaultInstanceForType() {
      return DEFAULT_INSTANCE;
    }
  }

  public interface DecayCurveAutomatedStoppingSpecOrBuilder
      extends
      // @@protoc_insertion_point(interface_extends:google.cloud.aiplatform.v1beta1.StudySpec.DecayCurveAutomatedStoppingSpec)
      com.google.protobuf.MessageOrBuilder {

    /**
     *
     *
     * <pre>
     * True if [Measurement.elapsed_duration][google.cloud.aiplatform.v1beta1.Measurement.elapsed_duration] is used as the x-axis of each
     * Trials Decay Curve. Otherwise, [Measurement.step_count][google.cloud.aiplatform.v1beta1.Measurement.step_count] will be used
     * as the x-axis.
     * </pre>
     *
     * <code>bool use_elapsed_duration = 1;</code>
     *
     * @return The useElapsedDuration.
     */
    boolean getUseElapsedDuration();
  }
  /**
   *
   *
   * <pre>
   * The decay curve automated stopping rule builds a Gaussian Process
   * Regressor to predict the final objective value of a Trial based on the
   * already completed Trials and the intermediate measurements of the current
   * Trial. Early stopping is requested for the current Trial if there is very
   * low probability to exceed the optimal value found so far.
   * </pre>
   *
   * Protobuf type {@code google.cloud.aiplatform.v1beta1.StudySpec.DecayCurveAutomatedStoppingSpec}
   */
  public static final class DecayCurveAutomatedStoppingSpec
      extends com.google.protobuf.GeneratedMessageV3
      implements
      // @@protoc_insertion_point(message_implements:google.cloud.aiplatform.v1beta1.StudySpec.DecayCurveAutomatedStoppingSpec)
      DecayCurveAutomatedStoppingSpecOrBuilder {
    private static final long serialVersionUID = 0L;
    // Use DecayCurveAutomatedStoppingSpec.newBuilder() to construct.
    private DecayCurveAutomatedStoppingSpec(
        com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
      super(builder);
    }

    private DecayCurveAutomatedStoppingSpec() {}

    @java.lang.Override
    @SuppressWarnings({"unused"})
    protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
      return new DecayCurveAutomatedStoppingSpec();
    }

    @java.lang.Override
    public final com.google.protobuf.UnknownFieldSet getUnknownFields() {
      return this.unknownFields;
    }

    private DecayCurveAutomatedStoppingSpec(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      this();
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      com.google.protobuf.UnknownFieldSet.Builder unknownFields =
          com.google.protobuf.UnknownFieldSet.newBuilder();
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 8:
              {
                useElapsedDuration_ = input.readBool();
                break;
              }
            default:
              {
                if (!parseUnknownField(input, unknownFields, extensionRegistry, tag)) {
                  done = true;
                }
                break;
              }
          }
        }
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.setUnfinishedMessage(this);
      } catch (java.io.IOException e) {
        throw new com.google.protobuf.InvalidProtocolBufferException(e).setUnfinishedMessage(this);
      } finally {
        this.unknownFields = unknownFields.build();
        makeExtensionsImmutable();
      }
    }

    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.aiplatform.v1beta1.StudyProto
          .internal_static_google_cloud_aiplatform_v1beta1_StudySpec_DecayCurveAutomatedStoppingSpec_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.aiplatform.v1beta1.StudyProto
          .internal_static_google_cloud_aiplatform_v1beta1_StudySpec_DecayCurveAutomatedStoppingSpec_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.aiplatform.v1beta1.StudySpec.DecayCurveAutomatedStoppingSpec.class,
              com.google.cloud.aiplatform.v1beta1.StudySpec.DecayCurveAutomatedStoppingSpec.Builder
                  .class);
    }

    public static final int USE_ELAPSED_DURATION_FIELD_NUMBER = 1;
    private boolean useElapsedDuration_;
    /**
     *
     *
     * <pre>
     * True if [Measurement.elapsed_duration][google.cloud.aiplatform.v1beta1.Measurement.elapsed_duration] is used as the x-axis of each
     * Trials Decay Curve. Otherwise, [Measurement.step_count][google.cloud.aiplatform.v1beta1.Measurement.step_count] will be used
     * as the x-axis.
     * </pre>
     *
     * <code>bool use_elapsed_duration = 1;</code>
     *
     * @return The useElapsedDuration.
     */
    @java.lang.Override
    public boolean getUseElapsedDuration() {
      return useElapsedDuration_;
    }

    private byte memoizedIsInitialized = -1;

    @java.lang.Override
    public final boolean isInitialized() {
      byte isInitialized = memoizedIsInitialized;
      if (isInitialized == 1) return true;
      if (isInitialized == 0) return false;

      memoizedIsInitialized = 1;
      return true;
    }

    @java.lang.Override
    public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
      if (useElapsedDuration_ != false) {
        output.writeBool(1, useElapsedDuration_);
      }
      unknownFields.writeTo(output);
    }

    @java.lang.Override
    public int getSerializedSize() {
      int size = memoizedSize;
      if (size != -1) return size;

      size = 0;
      if (useElapsedDuration_ != false) {
        size += com.google.protobuf.CodedOutputStream.computeBoolSize(1, useElapsedDuration_);
      }
      size += unknownFields.getSerializedSize();
      memoizedSize = size;
      return size;
    }

    @java.lang.Override
    public boolean equals(final java.lang.Object obj) {
      if (obj == this) {
        return true;
      }
      if (!(obj
          instanceof
          com.google.cloud.aiplatform.v1beta1.StudySpec.DecayCurveAutomatedStoppingSpec)) {
        return super.equals(obj);
      }
      com.google.cloud.aiplatform.v1beta1.StudySpec.DecayCurveAutomatedStoppingSpec other =
          (com.google.cloud.aiplatform.v1beta1.StudySpec.DecayCurveAutomatedStoppingSpec) obj;

      if (getUseElapsedDuration() != other.getUseElapsedDuration()) return false;
      if (!unknownFields.equals(other.unknownFields)) return false;
      return true;
    }

    @java.lang.Override
    public int hashCode() {
      if (memoizedHashCode != 0) {
        return memoizedHashCode;
      }
      int hash = 41;
      hash = (19 * hash) + getDescriptor().hashCode();
      hash = (37 * hash) + USE_ELAPSED_DURATION_FIELD_NUMBER;
      hash = (53 * hash) + com.google.protobuf.Internal.hashBoolean(getUseElapsedDuration());
      hash = (29 * hash) + unknownFields.hashCode();
      memoizedHashCode = hash;
      return hash;
    }

    public static com.google.cloud.aiplatform.v1beta1.StudySpec.DecayCurveAutomatedStoppingSpec
        parseFrom(java.nio.ByteBuffer data)
            throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.aiplatform.v1beta1.StudySpec.DecayCurveAutomatedStoppingSpec
        parseFrom(
            java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.aiplatform.v1beta1.StudySpec.DecayCurveAutomatedStoppingSpec
        parseFrom(com.google.protobuf.ByteString data)
            throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.aiplatform.v1beta1.StudySpec.DecayCurveAutomatedStoppingSpec
        parseFrom(
            com.google.protobuf.ByteString data,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.aiplatform.v1beta1.StudySpec.DecayCurveAutomatedStoppingSpec
        parseFrom(byte[] data) throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.aiplatform.v1beta1.StudySpec.DecayCurveAutomatedStoppingSpec
        parseFrom(byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.aiplatform.v1beta1.StudySpec.DecayCurveAutomatedStoppingSpec
        parseFrom(java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.cloud.aiplatform.v1beta1.StudySpec.DecayCurveAutomatedStoppingSpec
        parseFrom(
            java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.cloud.aiplatform.v1beta1.StudySpec.DecayCurveAutomatedStoppingSpec
        parseDelimitedFrom(java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
    }

    public static com.google.cloud.aiplatform.v1beta1.StudySpec.DecayCurveAutomatedStoppingSpec
        parseDelimitedFrom(
            java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.cloud.aiplatform.v1beta1.StudySpec.DecayCurveAutomatedStoppingSpec
        parseFrom(com.google.protobuf.CodedInputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.cloud.aiplatform.v1beta1.StudySpec.DecayCurveAutomatedStoppingSpec
        parseFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    @java.lang.Override
    public Builder newBuilderForType() {
      return newBuilder();
    }

    public static Builder newBuilder() {
      return DEFAULT_INSTANCE.toBuilder();
    }

    public static Builder newBuilder(
        com.google.cloud.aiplatform.v1beta1.StudySpec.DecayCurveAutomatedStoppingSpec prototype) {
      return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }

    @java.lang.Override
    public Builder toBuilder() {
      return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
    }

    @java.lang.Override
    protected Builder newBuilderForType(
        com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      Builder builder = new Builder(parent);
      return builder;
    }
    /**
     *
     *
     * <pre>
     * The decay curve automated stopping rule builds a Gaussian Process
     * Regressor to predict the final objective value of a Trial based on the
     * already completed Trials and the intermediate measurements of the current
     * Trial. Early stopping is requested for the current Trial if there is very
     * low probability to exceed the optimal value found so far.
     * </pre>
     *
     * Protobuf type {@code
     * google.cloud.aiplatform.v1beta1.StudySpec.DecayCurveAutomatedStoppingSpec}
     */
    public static final class Builder
        extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
        implements
        // @@protoc_insertion_point(builder_implements:google.cloud.aiplatform.v1beta1.StudySpec.DecayCurveAutomatedStoppingSpec)
        com.google.cloud.aiplatform.v1beta1.StudySpec.DecayCurveAutomatedStoppingSpecOrBuilder {
      public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
        return com.google.cloud.aiplatform.v1beta1.StudyProto
            .internal_static_google_cloud_aiplatform_v1beta1_StudySpec_DecayCurveAutomatedStoppingSpec_descriptor;
      }

      @java.lang.Override
      protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return com.google.cloud.aiplatform.v1beta1.StudyProto
            .internal_static_google_cloud_aiplatform_v1beta1_StudySpec_DecayCurveAutomatedStoppingSpec_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                com.google.cloud.aiplatform.v1beta1.StudySpec.DecayCurveAutomatedStoppingSpec.class,
                com.google.cloud.aiplatform.v1beta1.StudySpec.DecayCurveAutomatedStoppingSpec
                    .Builder.class);
      }

      // Construct using
      // com.google.cloud.aiplatform.v1beta1.StudySpec.DecayCurveAutomatedStoppingSpec.newBuilder()
      private Builder() {
        maybeForceBuilderInitialization();
      }

      private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
        super(parent);
        maybeForceBuilderInitialization();
      }

      private void maybeForceBuilderInitialization() {
        if (com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders) {}
      }

      @java.lang.Override
      public Builder clear() {
        super.clear();
        useElapsedDuration_ = false;

        return this;
      }

      @java.lang.Override
      public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
        return com.google.cloud.aiplatform.v1beta1.StudyProto
            .internal_static_google_cloud_aiplatform_v1beta1_StudySpec_DecayCurveAutomatedStoppingSpec_descriptor;
      }

      @java.lang.Override
      public com.google.cloud.aiplatform.v1beta1.StudySpec.DecayCurveAutomatedStoppingSpec
          getDefaultInstanceForType() {
        return com.google.cloud.aiplatform.v1beta1.StudySpec.DecayCurveAutomatedStoppingSpec
            .getDefaultInstance();
      }

      @java.lang.Override
      public com.google.cloud.aiplatform.v1beta1.StudySpec.DecayCurveAutomatedStoppingSpec build() {
        com.google.cloud.aiplatform.v1beta1.StudySpec.DecayCurveAutomatedStoppingSpec result =
            buildPartial();
        if (!result.isInitialized()) {
          throw newUninitializedMessageException(result);
        }
        return result;
      }

      @java.lang.Override
      public com.google.cloud.aiplatform.v1beta1.StudySpec.DecayCurveAutomatedStoppingSpec
          buildPartial() {
        com.google.cloud.aiplatform.v1beta1.StudySpec.DecayCurveAutomatedStoppingSpec result =
            new com.google.cloud.aiplatform.v1beta1.StudySpec.DecayCurveAutomatedStoppingSpec(this);
        result.useElapsedDuration_ = useElapsedDuration_;
        onBuilt();
        return result;
      }

      @java.lang.Override
      public Builder clone() {
        return super.clone();
      }

      @java.lang.Override
      public Builder setField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.setField(field, value);
      }

      @java.lang.Override
      public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
        return super.clearField(field);
      }

      @java.lang.Override
      public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
        return super.clearOneof(oneof);
      }

      @java.lang.Override
      public Builder setRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          int index,
          java.lang.Object value) {
        return super.setRepeatedField(field, index, value);
      }

      @java.lang.Override
      public Builder addRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.addRepeatedField(field, value);
      }

      @java.lang.Override
      public Builder mergeFrom(com.google.protobuf.Message other) {
        if (other
            instanceof
            com.google.cloud.aiplatform.v1beta1.StudySpec.DecayCurveAutomatedStoppingSpec) {
          return mergeFrom(
              (com.google.cloud.aiplatform.v1beta1.StudySpec.DecayCurveAutomatedStoppingSpec)
                  other);
        } else {
          super.mergeFrom(other);
          return this;
        }
      }

      public Builder mergeFrom(
          com.google.cloud.aiplatform.v1beta1.StudySpec.DecayCurveAutomatedStoppingSpec other) {
        if (other
            == com.google.cloud.aiplatform.v1beta1.StudySpec.DecayCurveAutomatedStoppingSpec
                .getDefaultInstance()) return this;
        if (other.getUseElapsedDuration() != false) {
          setUseElapsedDuration(other.getUseElapsedDuration());
        }
        this.mergeUnknownFields(other.unknownFields);
        onChanged();
        return this;
      }

      @java.lang.Override
      public final boolean isInitialized() {
        return true;
      }

      @java.lang.Override
      public Builder mergeFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        com.google.cloud.aiplatform.v1beta1.StudySpec.DecayCurveAutomatedStoppingSpec
            parsedMessage = null;
        try {
          parsedMessage = PARSER.parsePartialFrom(input, extensionRegistry);
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          parsedMessage =
              (com.google.cloud.aiplatform.v1beta1.StudySpec.DecayCurveAutomatedStoppingSpec)
                  e.getUnfinishedMessage();
          throw e.unwrapIOException();
        } finally {
          if (parsedMessage != null) {
            mergeFrom(parsedMessage);
          }
        }
        return this;
      }

      private boolean useElapsedDuration_;
      /**
       *
       *
       * <pre>
       * True if [Measurement.elapsed_duration][google.cloud.aiplatform.v1beta1.Measurement.elapsed_duration] is used as the x-axis of each
       * Trials Decay Curve. Otherwise, [Measurement.step_count][google.cloud.aiplatform.v1beta1.Measurement.step_count] will be used
       * as the x-axis.
       * </pre>
       *
       * <code>bool use_elapsed_duration = 1;</code>
       *
       * @return The useElapsedDuration.
       */
      @java.lang.Override
      public boolean getUseElapsedDuration() {
        return useElapsedDuration_;
      }
      /**
       *
       *
       * <pre>
       * True if [Measurement.elapsed_duration][google.cloud.aiplatform.v1beta1.Measurement.elapsed_duration] is used as the x-axis of each
       * Trials Decay Curve. Otherwise, [Measurement.step_count][google.cloud.aiplatform.v1beta1.Measurement.step_count] will be used
       * as the x-axis.
       * </pre>
       *
       * <code>bool use_elapsed_duration = 1;</code>
       *
       * @param value The useElapsedDuration to set.
       * @return This builder for chaining.
       */
      public Builder setUseElapsedDuration(boolean value) {

        useElapsedDuration_ = value;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * True if [Measurement.elapsed_duration][google.cloud.aiplatform.v1beta1.Measurement.elapsed_duration] is used as the x-axis of each
       * Trials Decay Curve. Otherwise, [Measurement.step_count][google.cloud.aiplatform.v1beta1.Measurement.step_count] will be used
       * as the x-axis.
       * </pre>
       *
       * <code>bool use_elapsed_duration = 1;</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearUseElapsedDuration() {

        useElapsedDuration_ = false;
        onChanged();
        return this;
      }

      @java.lang.Override
      public final Builder setUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.setUnknownFields(unknownFields);
      }

      @java.lang.Override
      public final Builder mergeUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.mergeUnknownFields(unknownFields);
      }

      // @@protoc_insertion_point(builder_scope:google.cloud.aiplatform.v1beta1.StudySpec.DecayCurveAutomatedStoppingSpec)
    }

    // @@protoc_insertion_point(class_scope:google.cloud.aiplatform.v1beta1.StudySpec.DecayCurveAutomatedStoppingSpec)
    private static final com.google.cloud.aiplatform.v1beta1.StudySpec
            .DecayCurveAutomatedStoppingSpec
        DEFAULT_INSTANCE;

    static {
      DEFAULT_INSTANCE =
          new com.google.cloud.aiplatform.v1beta1.StudySpec.DecayCurveAutomatedStoppingSpec();
    }

    public static com.google.cloud.aiplatform.v1beta1.StudySpec.DecayCurveAutomatedStoppingSpec
        getDefaultInstance() {
      return DEFAULT_INSTANCE;
    }

    private static final com.google.protobuf.Parser<DecayCurveAutomatedStoppingSpec> PARSER =
        new com.google.protobuf.AbstractParser<DecayCurveAutomatedStoppingSpec>() {
          @java.lang.Override
          public DecayCurveAutomatedStoppingSpec parsePartialFrom(
              com.google.protobuf.CodedInputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
            return new DecayCurveAutomatedStoppingSpec(input, extensionRegistry);
          }
        };

    public static com.google.protobuf.Parser<DecayCurveAutomatedStoppingSpec> parser() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.protobuf.Parser<DecayCurveAutomatedStoppingSpec> getParserForType() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.cloud.aiplatform.v1beta1.StudySpec.DecayCurveAutomatedStoppingSpec
        getDefaultInstanceForType() {
      return DEFAULT_INSTANCE;
    }
  }

  public interface MedianAutomatedStoppingSpecOrBuilder
      extends
      // @@protoc_insertion_point(interface_extends:google.cloud.aiplatform.v1beta1.StudySpec.MedianAutomatedStoppingSpec)
      com.google.protobuf.MessageOrBuilder {

    /**
     *
     *
     * <pre>
     * True if median automated stopping rule applies on
     * [Measurement.elapsed_duration][google.cloud.aiplatform.v1beta1.Measurement.elapsed_duration]. It means that elapsed_duration
     * field of latest measurement of current Trial is used to compute median
     * objective value for each completed Trials.
     * </pre>
     *
     * <code>bool use_elapsed_duration = 1;</code>
     *
     * @return The useElapsedDuration.
     */
    boolean getUseElapsedDuration();
  }
  /**
   *
   *
   * <pre>
   * The median automated stopping rule stops a pending Trial if the Trial's
   * best objective_value is strictly below the median 'performance' of all
   * completed Trials reported up to the Trial's last measurement.
   * Currently, 'performance' refers to the running average of the objective
   * values reported by the Trial in each measurement.
   * </pre>
   *
   * Protobuf type {@code google.cloud.aiplatform.v1beta1.StudySpec.MedianAutomatedStoppingSpec}
   */
  public static final class MedianAutomatedStoppingSpec
      extends com.google.protobuf.GeneratedMessageV3
      implements
      // @@protoc_insertion_point(message_implements:google.cloud.aiplatform.v1beta1.StudySpec.MedianAutomatedStoppingSpec)
      MedianAutomatedStoppingSpecOrBuilder {
    private static final long serialVersionUID = 0L;
    // Use MedianAutomatedStoppingSpec.newBuilder() to construct.
    private MedianAutomatedStoppingSpec(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
      super(builder);
    }

    private MedianAutomatedStoppingSpec() {}

    @java.lang.Override
    @SuppressWarnings({"unused"})
    protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
      return new MedianAutomatedStoppingSpec();
    }

    @java.lang.Override
    public final com.google.protobuf.UnknownFieldSet getUnknownFields() {
      return this.unknownFields;
    }

    private MedianAutomatedStoppingSpec(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      this();
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      com.google.protobuf.UnknownFieldSet.Builder unknownFields =
          com.google.protobuf.UnknownFieldSet.newBuilder();
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 8:
              {
                useElapsedDuration_ = input.readBool();
                break;
              }
            default:
              {
                if (!parseUnknownField(input, unknownFields, extensionRegistry, tag)) {
                  done = true;
                }
                break;
              }
          }
        }
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.setUnfinishedMessage(this);
      } catch (java.io.IOException e) {
        throw new com.google.protobuf.InvalidProtocolBufferException(e).setUnfinishedMessage(this);
      } finally {
        this.unknownFields = unknownFields.build();
        makeExtensionsImmutable();
      }
    }

    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.aiplatform.v1beta1.StudyProto
          .internal_static_google_cloud_aiplatform_v1beta1_StudySpec_MedianAutomatedStoppingSpec_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.aiplatform.v1beta1.StudyProto
          .internal_static_google_cloud_aiplatform_v1beta1_StudySpec_MedianAutomatedStoppingSpec_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.aiplatform.v1beta1.StudySpec.MedianAutomatedStoppingSpec.class,
              com.google.cloud.aiplatform.v1beta1.StudySpec.MedianAutomatedStoppingSpec.Builder
                  .class);
    }

    public static final int USE_ELAPSED_DURATION_FIELD_NUMBER = 1;
    private boolean useElapsedDuration_;
    /**
     *
     *
     * <pre>
     * True if median automated stopping rule applies on
     * [Measurement.elapsed_duration][google.cloud.aiplatform.v1beta1.Measurement.elapsed_duration]. It means that elapsed_duration
     * field of latest measurement of current Trial is used to compute median
     * objective value for each completed Trials.
     * </pre>
     *
     * <code>bool use_elapsed_duration = 1;</code>
     *
     * @return The useElapsedDuration.
     */
    @java.lang.Override
    public boolean getUseElapsedDuration() {
      return useElapsedDuration_;
    }

    private byte memoizedIsInitialized = -1;

    @java.lang.Override
    public final boolean isInitialized() {
      byte isInitialized = memoizedIsInitialized;
      if (isInitialized == 1) return true;
      if (isInitialized == 0) return false;

      memoizedIsInitialized = 1;
      return true;
    }

    @java.lang.Override
    public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
      if (useElapsedDuration_ != false) {
        output.writeBool(1, useElapsedDuration_);
      }
      unknownFields.writeTo(output);
    }

    @java.lang.Override
    public int getSerializedSize() {
      int size = memoizedSize;
      if (size != -1) return size;

      size = 0;
      if (useElapsedDuration_ != false) {
        size += com.google.protobuf.CodedOutputStream.computeBoolSize(1, useElapsedDuration_);
      }
      size += unknownFields.getSerializedSize();
      memoizedSize = size;
      return size;
    }

    @java.lang.Override
    public boolean equals(final java.lang.Object obj) {
      if (obj == this) {
        return true;
      }
      if (!(obj
          instanceof com.google.cloud.aiplatform.v1beta1.StudySpec.MedianAutomatedStoppingSpec)) {
        return super.equals(obj);
      }
      com.google.cloud.aiplatform.v1beta1.StudySpec.MedianAutomatedStoppingSpec other =
          (com.google.cloud.aiplatform.v1beta1.StudySpec.MedianAutomatedStoppingSpec) obj;

      if (getUseElapsedDuration() != other.getUseElapsedDuration()) return false;
      if (!unknownFields.equals(other.unknownFields)) return false;
      return true;
    }

    @java.lang.Override
    public int hashCode() {
      if (memoizedHashCode != 0) {
        return memoizedHashCode;
      }
      int hash = 41;
      hash = (19 * hash) + getDescriptor().hashCode();
      hash = (37 * hash) + USE_ELAPSED_DURATION_FIELD_NUMBER;
      hash = (53 * hash) + com.google.protobuf.Internal.hashBoolean(getUseElapsedDuration());
      hash = (29 * hash) + unknownFields.hashCode();
      memoizedHashCode = hash;
      return hash;
    }

    public static com.google.cloud.aiplatform.v1beta1.StudySpec.MedianAutomatedStoppingSpec
        parseFrom(java.nio.ByteBuffer data)
            throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.aiplatform.v1beta1.StudySpec.MedianAutomatedStoppingSpec
        parseFrom(
            java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.aiplatform.v1beta1.StudySpec.MedianAutomatedStoppingSpec
        parseFrom(com.google.protobuf.ByteString data)
            throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.aiplatform.v1beta1.StudySpec.MedianAutomatedStoppingSpec
        parseFrom(
            com.google.protobuf.ByteString data,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.aiplatform.v1beta1.StudySpec.MedianAutomatedStoppingSpec
        parseFrom(byte[] data) throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.aiplatform.v1beta1.StudySpec.MedianAutomatedStoppingSpec
        parseFrom(byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.aiplatform.v1beta1.StudySpec.MedianAutomatedStoppingSpec
        parseFrom(java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.cloud.aiplatform.v1beta1.StudySpec.MedianAutomatedStoppingSpec
        parseFrom(
            java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.cloud.aiplatform.v1beta1.StudySpec.MedianAutomatedStoppingSpec
        parseDelimitedFrom(java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
    }

    public static com.google.cloud.aiplatform.v1beta1.StudySpec.MedianAutomatedStoppingSpec
        parseDelimitedFrom(
            java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.cloud.aiplatform.v1beta1.StudySpec.MedianAutomatedStoppingSpec
        parseFrom(com.google.protobuf.CodedInputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.cloud.aiplatform.v1beta1.StudySpec.MedianAutomatedStoppingSpec
        parseFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    @java.lang.Override
    public Builder newBuilderForType() {
      return newBuilder();
    }

    public static Builder newBuilder() {
      return DEFAULT_INSTANCE.toBuilder();
    }

    public static Builder newBuilder(
        com.google.cloud.aiplatform.v1beta1.StudySpec.MedianAutomatedStoppingSpec prototype) {
      return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }

    @java.lang.Override
    public Builder toBuilder() {
      return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
    }

    @java.lang.Override
    protected Builder newBuilderForType(
        com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      Builder builder = new Builder(parent);
      return builder;
    }
    /**
     *
     *
     * <pre>
     * The median automated stopping rule stops a pending Trial if the Trial's
     * best objective_value is strictly below the median 'performance' of all
     * completed Trials reported up to the Trial's last measurement.
     * Currently, 'performance' refers to the running average of the objective
     * values reported by the Trial in each measurement.
     * </pre>
     *
     * Protobuf type {@code google.cloud.aiplatform.v1beta1.StudySpec.MedianAutomatedStoppingSpec}
     */
    public static final class Builder
        extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
        implements
        // @@protoc_insertion_point(builder_implements:google.cloud.aiplatform.v1beta1.StudySpec.MedianAutomatedStoppingSpec)
        com.google.cloud.aiplatform.v1beta1.StudySpec.MedianAutomatedStoppingSpecOrBuilder {
      public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
        return com.google.cloud.aiplatform.v1beta1.StudyProto
            .internal_static_google_cloud_aiplatform_v1beta1_StudySpec_MedianAutomatedStoppingSpec_descriptor;
      }

      @java.lang.Override
      protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return com.google.cloud.aiplatform.v1beta1.StudyProto
            .internal_static_google_cloud_aiplatform_v1beta1_StudySpec_MedianAutomatedStoppingSpec_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                com.google.cloud.aiplatform.v1beta1.StudySpec.MedianAutomatedStoppingSpec.class,
                com.google.cloud.aiplatform.v1beta1.StudySpec.MedianAutomatedStoppingSpec.Builder
                    .class);
      }

      // Construct using
      // com.google.cloud.aiplatform.v1beta1.StudySpec.MedianAutomatedStoppingSpec.newBuilder()
      private Builder() {
        maybeForceBuilderInitialization();
      }

      private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
        super(parent);
        maybeForceBuilderInitialization();
      }

      private void maybeForceBuilderInitialization() {
        if (com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders) {}
      }

      @java.lang.Override
      public Builder clear() {
        super.clear();
        useElapsedDuration_ = false;

        return this;
      }

      @java.lang.Override
      public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
        return com.google.cloud.aiplatform.v1beta1.StudyProto
            .internal_static_google_cloud_aiplatform_v1beta1_StudySpec_MedianAutomatedStoppingSpec_descriptor;
      }

      @java.lang.Override
      public com.google.cloud.aiplatform.v1beta1.StudySpec.MedianAutomatedStoppingSpec
          getDefaultInstanceForType() {
        return com.google.cloud.aiplatform.v1beta1.StudySpec.MedianAutomatedStoppingSpec
            .getDefaultInstance();
      }

      @java.lang.Override
      public com.google.cloud.aiplatform.v1beta1.StudySpec.MedianAutomatedStoppingSpec build() {
        com.google.cloud.aiplatform.v1beta1.StudySpec.MedianAutomatedStoppingSpec result =
            buildPartial();
        if (!result.isInitialized()) {
          throw newUninitializedMessageException(result);
        }
        return result;
      }

      @java.lang.Override
      public com.google.cloud.aiplatform.v1beta1.StudySpec.MedianAutomatedStoppingSpec
          buildPartial() {
        com.google.cloud.aiplatform.v1beta1.StudySpec.MedianAutomatedStoppingSpec result =
            new com.google.cloud.aiplatform.v1beta1.StudySpec.MedianAutomatedStoppingSpec(this);
        result.useElapsedDuration_ = useElapsedDuration_;
        onBuilt();
        return result;
      }

      @java.lang.Override
      public Builder clone() {
        return super.clone();
      }

      @java.lang.Override
      public Builder setField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.setField(field, value);
      }

      @java.lang.Override
      public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
        return super.clearField(field);
      }

      @java.lang.Override
      public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
        return super.clearOneof(oneof);
      }

      @java.lang.Override
      public Builder setRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          int index,
          java.lang.Object value) {
        return super.setRepeatedField(field, index, value);
      }

      @java.lang.Override
      public Builder addRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.addRepeatedField(field, value);
      }

      @java.lang.Override
      public Builder mergeFrom(com.google.protobuf.Message other) {
        if (other
            instanceof com.google.cloud.aiplatform.v1beta1.StudySpec.MedianAutomatedStoppingSpec) {
          return mergeFrom(
              (com.google.cloud.aiplatform.v1beta1.StudySpec.MedianAutomatedStoppingSpec) other);
        } else {
          super.mergeFrom(other);
          return this;
        }
      }

      public Builder mergeFrom(
          com.google.cloud.aiplatform.v1beta1.StudySpec.MedianAutomatedStoppingSpec other) {
        if (other
            == com.google.cloud.aiplatform.v1beta1.StudySpec.MedianAutomatedStoppingSpec
                .getDefaultInstance()) return this;
        if (other.getUseElapsedDuration() != false) {
          setUseElapsedDuration(other.getUseElapsedDuration());
        }
        this.mergeUnknownFields(other.unknownFields);
        onChanged();
        return this;
      }

      @java.lang.Override
      public final boolean isInitialized() {
        return true;
      }

      @java.lang.Override
      public Builder mergeFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        com.google.cloud.aiplatform.v1beta1.StudySpec.MedianAutomatedStoppingSpec parsedMessage =
            null;
        try {
          parsedMessage = PARSER.parsePartialFrom(input, extensionRegistry);
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          parsedMessage =
              (com.google.cloud.aiplatform.v1beta1.StudySpec.MedianAutomatedStoppingSpec)
                  e.getUnfinishedMessage();
          throw e.unwrapIOException();
        } finally {
          if (parsedMessage != null) {
            mergeFrom(parsedMessage);
          }
        }
        return this;
      }

      private boolean useElapsedDuration_;
      /**
       *
       *
       * <pre>
       * True if median automated stopping rule applies on
       * [Measurement.elapsed_duration][google.cloud.aiplatform.v1beta1.Measurement.elapsed_duration]. It means that elapsed_duration
       * field of latest measurement of current Trial is used to compute median
       * objective value for each completed Trials.
       * </pre>
       *
       * <code>bool use_elapsed_duration = 1;</code>
       *
       * @return The useElapsedDuration.
       */
      @java.lang.Override
      public boolean getUseElapsedDuration() {
        return useElapsedDuration_;
      }
      /**
       *
       *
       * <pre>
       * True if median automated stopping rule applies on
       * [Measurement.elapsed_duration][google.cloud.aiplatform.v1beta1.Measurement.elapsed_duration]. It means that elapsed_duration
       * field of latest measurement of current Trial is used to compute median
       * objective value for each completed Trials.
       * </pre>
       *
       * <code>bool use_elapsed_duration = 1;</code>
       *
       * @param value The useElapsedDuration to set.
       * @return This builder for chaining.
       */
      public Builder setUseElapsedDuration(boolean value) {

        useElapsedDuration_ = value;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * True if median automated stopping rule applies on
       * [Measurement.elapsed_duration][google.cloud.aiplatform.v1beta1.Measurement.elapsed_duration]. It means that elapsed_duration
       * field of latest measurement of current Trial is used to compute median
       * objective value for each completed Trials.
       * </pre>
       *
       * <code>bool use_elapsed_duration = 1;</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearUseElapsedDuration() {

        useElapsedDuration_ = false;
        onChanged();
        return this;
      }

      @java.lang.Override
      public final Builder setUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.setUnknownFields(unknownFields);
      }

      @java.lang.Override
      public final Builder mergeUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.mergeUnknownFields(unknownFields);
      }

      // @@protoc_insertion_point(builder_scope:google.cloud.aiplatform.v1beta1.StudySpec.MedianAutomatedStoppingSpec)
    }

    // @@protoc_insertion_point(class_scope:google.cloud.aiplatform.v1beta1.StudySpec.MedianAutomatedStoppingSpec)
    private static final com.google.cloud.aiplatform.v1beta1.StudySpec.MedianAutomatedStoppingSpec
        DEFAULT_INSTANCE;

    static {
      DEFAULT_INSTANCE =
          new com.google.cloud.aiplatform.v1beta1.StudySpec.MedianAutomatedStoppingSpec();
    }

    public static com.google.cloud.aiplatform.v1beta1.StudySpec.MedianAutomatedStoppingSpec
        getDefaultInstance() {
      return DEFAULT_INSTANCE;
    }

    private static final com.google.protobuf.Parser<MedianAutomatedStoppingSpec> PARSER =
        new com.google.protobuf.AbstractParser<MedianAutomatedStoppingSpec>() {
          @java.lang.Override
          public MedianAutomatedStoppingSpec parsePartialFrom(
              com.google.protobuf.CodedInputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
            return new MedianAutomatedStoppingSpec(input, extensionRegistry);
          }
        };

    public static com.google.protobuf.Parser<MedianAutomatedStoppingSpec> parser() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.protobuf.Parser<MedianAutomatedStoppingSpec> getParserForType() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.cloud.aiplatform.v1beta1.StudySpec.MedianAutomatedStoppingSpec
        getDefaultInstanceForType() {
      return DEFAULT_INSTANCE;
    }
  }

  @java.lang.Deprecated
  public interface ConvexStopConfigOrBuilder
      extends
      // @@protoc_insertion_point(interface_extends:google.cloud.aiplatform.v1beta1.StudySpec.ConvexStopConfig)
      com.google.protobuf.MessageOrBuilder {

    /**
     *
     *
     * <pre>
     * Steps used in predicting the final objective for early stopped trials. In
     * general, it's set to be the same as the defined steps in training /
     * tuning. When use_steps is false, this field is set to the maximum elapsed
     * seconds.
     * </pre>
     *
     * <code>int64 max_num_steps = 1;</code>
     *
     * @return The maxNumSteps.
     */
    long getMaxNumSteps();

    /**
     *
     *
     * <pre>
     * Minimum number of steps for a trial to complete. Trials which do not have
     * a measurement with num_steps &gt; min_num_steps won't be considered for
     * early stopping. It's ok to set it to 0, and a trial can be early stopped
     * at any stage. By default, min_num_steps is set to be one-tenth of the
     * max_num_steps.
     * When use_steps is false, this field is set to the minimum elapsed
     * seconds.
     * </pre>
     *
     * <code>int64 min_num_steps = 2;</code>
     *
     * @return The minNumSteps.
     */
    long getMinNumSteps();

    /**
     *
     *
     * <pre>
     * The number of Trial measurements used in autoregressive model for
     * value prediction. A trial won't be considered early stopping if has fewer
     * measurement points.
     * </pre>
     *
     * <code>int64 autoregressive_order = 3;</code>
     *
     * @return The autoregressiveOrder.
     */
    long getAutoregressiveOrder();

    /**
     *
     *
     * <pre>
     * The hyper-parameter name used in the tuning job that stands for learning
     * rate. Leave it blank if learning rate is not in a parameter in tuning.
     * The learning_rate is used to estimate the objective value of the ongoing
     * trial.
     * </pre>
     *
     * <code>string learning_rate_parameter_name = 4;</code>
     *
     * @return The learningRateParameterName.
     */
    java.lang.String getLearningRateParameterName();
    /**
     *
     *
     * <pre>
     * The hyper-parameter name used in the tuning job that stands for learning
     * rate. Leave it blank if learning rate is not in a parameter in tuning.
     * The learning_rate is used to estimate the objective value of the ongoing
     * trial.
     * </pre>
     *
     * <code>string learning_rate_parameter_name = 4;</code>
     *
     * @return The bytes for learningRateParameterName.
     */
    com.google.protobuf.ByteString getLearningRateParameterNameBytes();

    /**
     *
     *
     * <pre>
     * This bool determines whether or not the rule is applied based on
     * elapsed_secs or steps. If use_seconds==false, the early stopping decision
     * is made according to the predicted objective values according to the
     * target steps. If use_seconds==true, elapsed_secs is used instead of
     * steps. Also, in this case, the parameters max_num_steps and min_num_steps
     * are overloaded to contain max_elapsed_seconds and min_elapsed_seconds.
     * </pre>
     *
     * <code>bool use_seconds = 5;</code>
     *
     * @return The useSeconds.
     */
    boolean getUseSeconds();
  }
  /**
   *
   *
   * <pre>
   * Configuration for ConvexStopPolicy.
   * </pre>
   *
   * Protobuf type {@code google.cloud.aiplatform.v1beta1.StudySpec.ConvexStopConfig}
   */
  @java.lang.Deprecated
  public static final class ConvexStopConfig extends com.google.protobuf.GeneratedMessageV3
      implements
      // @@protoc_insertion_point(message_implements:google.cloud.aiplatform.v1beta1.StudySpec.ConvexStopConfig)
      ConvexStopConfigOrBuilder {
    private static final long serialVersionUID = 0L;
    // Use ConvexStopConfig.newBuilder() to construct.
    private ConvexStopConfig(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
      super(builder);
    }

    private ConvexStopConfig() {
      learningRateParameterName_ = "";
    }

    @java.lang.Override
    @SuppressWarnings({"unused"})
    protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
      return new ConvexStopConfig();
    }

    @java.lang.Override
    public final com.google.protobuf.UnknownFieldSet getUnknownFields() {
      return this.unknownFields;
    }

    private ConvexStopConfig(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      this();
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      com.google.protobuf.UnknownFieldSet.Builder unknownFields =
          com.google.protobuf.UnknownFieldSet.newBuilder();
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 8:
              {
                maxNumSteps_ = input.readInt64();
                break;
              }
            case 16:
              {
                minNumSteps_ = input.readInt64();
                break;
              }
            case 24:
              {
                autoregressiveOrder_ = input.readInt64();
                break;
              }
            case 34:
              {
                java.lang.String s = input.readStringRequireUtf8();

                learningRateParameterName_ = s;
                break;
              }
            case 40:
              {
                useSeconds_ = input.readBool();
                break;
              }
            default:
              {
                if (!parseUnknownField(input, unknownFields, extensionRegistry, tag)) {
                  done = true;
                }
                break;
              }
          }
        }
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.setUnfinishedMessage(this);
      } catch (java.io.IOException e) {
        throw new com.google.protobuf.InvalidProtocolBufferException(e).setUnfinishedMessage(this);
      } finally {
        this.unknownFields = unknownFields.build();
        makeExtensionsImmutable();
      }
    }

    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.aiplatform.v1beta1.StudyProto
          .internal_static_google_cloud_aiplatform_v1beta1_StudySpec_ConvexStopConfig_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.aiplatform.v1beta1.StudyProto
          .internal_static_google_cloud_aiplatform_v1beta1_StudySpec_ConvexStopConfig_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.aiplatform.v1beta1.StudySpec.ConvexStopConfig.class,
              com.google.cloud.aiplatform.v1beta1.StudySpec.ConvexStopConfig.Builder.class);
    }

    public static final int MAX_NUM_STEPS_FIELD_NUMBER = 1;
    private long maxNumSteps_;
    /**
     *
     *
     * <pre>
     * Steps used in predicting the final objective for early stopped trials. In
     * general, it's set to be the same as the defined steps in training /
     * tuning. When use_steps is false, this field is set to the maximum elapsed
     * seconds.
     * </pre>
     *
     * <code>int64 max_num_steps = 1;</code>
     *
     * @return The maxNumSteps.
     */
    @java.lang.Override
    public long getMaxNumSteps() {
      return maxNumSteps_;
    }

    public static final int MIN_NUM_STEPS_FIELD_NUMBER = 2;
    private long minNumSteps_;
    /**
     *
     *
     * <pre>
     * Minimum number of steps for a trial to complete. Trials which do not have
     * a measurement with num_steps &gt; min_num_steps won't be considered for
     * early stopping. It's ok to set it to 0, and a trial can be early stopped
     * at any stage. By default, min_num_steps is set to be one-tenth of the
     * max_num_steps.
     * When use_steps is false, this field is set to the minimum elapsed
     * seconds.
     * </pre>
     *
     * <code>int64 min_num_steps = 2;</code>
     *
     * @return The minNumSteps.
     */
    @java.lang.Override
    public long getMinNumSteps() {
      return minNumSteps_;
    }

    public static final int AUTOREGRESSIVE_ORDER_FIELD_NUMBER = 3;
    private long autoregressiveOrder_;
    /**
     *
     *
     * <pre>
     * The number of Trial measurements used in autoregressive model for
     * value prediction. A trial won't be considered early stopping if has fewer
     * measurement points.
     * </pre>
     *
     * <code>int64 autoregressive_order = 3;</code>
     *
     * @return The autoregressiveOrder.
     */
    @java.lang.Override
    public long getAutoregressiveOrder() {
      return autoregressiveOrder_;
    }

    public static final int LEARNING_RATE_PARAMETER_NAME_FIELD_NUMBER = 4;
    private volatile java.lang.Object learningRateParameterName_;
    /**
     *
     *
     * <pre>
     * The hyper-parameter name used in the tuning job that stands for learning
     * rate. Leave it blank if learning rate is not in a parameter in tuning.
     * The learning_rate is used to estimate the objective value of the ongoing
     * trial.
     * </pre>
     *
     * <code>string learning_rate_parameter_name = 4;</code>
     *
     * @return The learningRateParameterName.
     */
    @java.lang.Override
    public java.lang.String getLearningRateParameterName() {
      java.lang.Object ref = learningRateParameterName_;
      if (ref instanceof java.lang.String) {
        return (java.lang.String) ref;
      } else {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        learningRateParameterName_ = s;
        return s;
      }
    }
    /**
     *
     *
     * <pre>
     * The hyper-parameter name used in the tuning job that stands for learning
     * rate. Leave it blank if learning rate is not in a parameter in tuning.
     * The learning_rate is used to estimate the objective value of the ongoing
     * trial.
     * </pre>
     *
     * <code>string learning_rate_parameter_name = 4;</code>
     *
     * @return The bytes for learningRateParameterName.
     */
    @java.lang.Override
    public com.google.protobuf.ByteString getLearningRateParameterNameBytes() {
      java.lang.Object ref = learningRateParameterName_;
      if (ref instanceof java.lang.String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        learningRateParameterName_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    public static final int USE_SECONDS_FIELD_NUMBER = 5;
    private boolean useSeconds_;
    /**
     *
     *
     * <pre>
     * This bool determines whether or not the rule is applied based on
     * elapsed_secs or steps. If use_seconds==false, the early stopping decision
     * is made according to the predicted objective values according to the
     * target steps. If use_seconds==true, elapsed_secs is used instead of
     * steps. Also, in this case, the parameters max_num_steps and min_num_steps
     * are overloaded to contain max_elapsed_seconds and min_elapsed_seconds.
     * </pre>
     *
     * <code>bool use_seconds = 5;</code>
     *
     * @return The useSeconds.
     */
    @java.lang.Override
    public boolean getUseSeconds() {
      return useSeconds_;
    }

    private byte memoizedIsInitialized = -1;

    @java.lang.Override
    public final boolean isInitialized() {
      byte isInitialized = memoizedIsInitialized;
      if (isInitialized == 1) return true;
      if (isInitialized == 0) return false;

      memoizedIsInitialized = 1;
      return true;
    }

    @java.lang.Override
    public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
      if (maxNumSteps_ != 0L) {
        output.writeInt64(1, maxNumSteps_);
      }
      if (minNumSteps_ != 0L) {
        output.writeInt64(2, minNumSteps_);
      }
      if (autoregressiveOrder_ != 0L) {
        output.writeInt64(3, autoregressiveOrder_);
      }
      if (!getLearningRateParameterNameBytes().isEmpty()) {
        com.google.protobuf.GeneratedMessageV3.writeString(output, 4, learningRateParameterName_);
      }
      if (useSeconds_ != false) {
        output.writeBool(5, useSeconds_);
      }
      unknownFields.writeTo(output);
    }

    @java.lang.Override
    public int getSerializedSize() {
      int size = memoizedSize;
      if (size != -1) return size;

      size = 0;
      if (maxNumSteps_ != 0L) {
        size += com.google.protobuf.CodedOutputStream.computeInt64Size(1, maxNumSteps_);
      }
      if (minNumSteps_ != 0L) {
        size += com.google.protobuf.CodedOutputStream.computeInt64Size(2, minNumSteps_);
      }
      if (autoregressiveOrder_ != 0L) {
        size += com.google.protobuf.CodedOutputStream.computeInt64Size(3, autoregressiveOrder_);
      }
      if (!getLearningRateParameterNameBytes().isEmpty()) {
        size +=
            com.google.protobuf.GeneratedMessageV3.computeStringSize(4, learningRateParameterName_);
      }
      if (useSeconds_ != false) {
        size += com.google.protobuf.CodedOutputStream.computeBoolSize(5, useSeconds_);
      }
      size += unknownFields.getSerializedSize();
      memoizedSize = size;
      return size;
    }

    @java.lang.Override
    public boolean equals(final java.lang.Object obj) {
      if (obj == this) {
        return true;
      }
      if (!(obj instanceof com.google.cloud.aiplatform.v1beta1.StudySpec.ConvexStopConfig)) {
        return super.equals(obj);
      }
      com.google.cloud.aiplatform.v1beta1.StudySpec.ConvexStopConfig other =
          (com.google.cloud.aiplatform.v1beta1.StudySpec.ConvexStopConfig) obj;

      if (getMaxNumSteps() != other.getMaxNumSteps()) return false;
      if (getMinNumSteps() != other.getMinNumSteps()) return false;
      if (getAutoregressiveOrder() != other.getAutoregressiveOrder()) return false;
      if (!getLearningRateParameterName().equals(other.getLearningRateParameterName()))
        return false;
      if (getUseSeconds() != other.getUseSeconds()) return false;
      if (!unknownFields.equals(other.unknownFields)) return false;
      return true;
    }

    @java.lang.Override
    public int hashCode() {
      if (memoizedHashCode != 0) {
        return memoizedHashCode;
      }
      int hash = 41;
      hash = (19 * hash) + getDescriptor().hashCode();
      hash = (37 * hash) + MAX_NUM_STEPS_FIELD_NUMBER;
      hash = (53 * hash) + com.google.protobuf.Internal.hashLong(getMaxNumSteps());
      hash = (37 * hash) + MIN_NUM_STEPS_FIELD_NUMBER;
      hash = (53 * hash) + com.google.protobuf.Internal.hashLong(getMinNumSteps());
      hash = (37 * hash) + AUTOREGRESSIVE_ORDER_FIELD_NUMBER;
      hash = (53 * hash) + com.google.protobuf.Internal.hashLong(getAutoregressiveOrder());
      hash = (37 * hash) + LEARNING_RATE_PARAMETER_NAME_FIELD_NUMBER;
      hash = (53 * hash) + getLearningRateParameterName().hashCode();
      hash = (37 * hash) + USE_SECONDS_FIELD_NUMBER;
      hash = (53 * hash) + com.google.protobuf.Internal.hashBoolean(getUseSeconds());
      hash = (29 * hash) + unknownFields.hashCode();
      memoizedHashCode = hash;
      return hash;
    }

    public static com.google.cloud.aiplatform.v1beta1.StudySpec.ConvexStopConfig parseFrom(
        java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.aiplatform.v1beta1.StudySpec.ConvexStopConfig parseFrom(
        java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.aiplatform.v1beta1.StudySpec.ConvexStopConfig parseFrom(
        com.google.protobuf.ByteString data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.aiplatform.v1beta1.StudySpec.ConvexStopConfig parseFrom(
        com.google.protobuf.ByteString data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.aiplatform.v1beta1.StudySpec.ConvexStopConfig parseFrom(
        byte[] data) throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.aiplatform.v1beta1.StudySpec.ConvexStopConfig parseFrom(
        byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.aiplatform.v1beta1.StudySpec.ConvexStopConfig parseFrom(
        java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.cloud.aiplatform.v1beta1.StudySpec.ConvexStopConfig parseFrom(
        java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.cloud.aiplatform.v1beta1.StudySpec.ConvexStopConfig parseDelimitedFrom(
        java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
    }

    public static com.google.cloud.aiplatform.v1beta1.StudySpec.ConvexStopConfig parseDelimitedFrom(
        java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.cloud.aiplatform.v1beta1.StudySpec.ConvexStopConfig parseFrom(
        com.google.protobuf.CodedInputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.cloud.aiplatform.v1beta1.StudySpec.ConvexStopConfig parseFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    @java.lang.Override
    public Builder newBuilderForType() {
      return newBuilder();
    }

    public static Builder newBuilder() {
      return DEFAULT_INSTANCE.toBuilder();
    }

    public static Builder newBuilder(
        com.google.cloud.aiplatform.v1beta1.StudySpec.ConvexStopConfig prototype) {
      return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }

    @java.lang.Override
    public Builder toBuilder() {
      return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
    }

    @java.lang.Override
    protected Builder newBuilderForType(
        com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      Builder builder = new Builder(parent);
      return builder;
    }
    /**
     *
     *
     * <pre>
     * Configuration for ConvexStopPolicy.
     * </pre>
     *
     * Protobuf type {@code google.cloud.aiplatform.v1beta1.StudySpec.ConvexStopConfig}
     */
    public static final class Builder
        extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
        implements
        // @@protoc_insertion_point(builder_implements:google.cloud.aiplatform.v1beta1.StudySpec.ConvexStopConfig)
        com.google.cloud.aiplatform.v1beta1.StudySpec.ConvexStopConfigOrBuilder {
      public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
        return com.google.cloud.aiplatform.v1beta1.StudyProto
            .internal_static_google_cloud_aiplatform_v1beta1_StudySpec_ConvexStopConfig_descriptor;
      }

      @java.lang.Override
      protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return com.google.cloud.aiplatform.v1beta1.StudyProto
            .internal_static_google_cloud_aiplatform_v1beta1_StudySpec_ConvexStopConfig_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                com.google.cloud.aiplatform.v1beta1.StudySpec.ConvexStopConfig.class,
                com.google.cloud.aiplatform.v1beta1.StudySpec.ConvexStopConfig.Builder.class);
      }

      // Construct using com.google.cloud.aiplatform.v1beta1.StudySpec.ConvexStopConfig.newBuilder()
      private Builder() {
        maybeForceBuilderInitialization();
      }

      private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
        super(parent);
        maybeForceBuilderInitialization();
      }

      private void maybeForceBuilderInitialization() {
        if (com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders) {}
      }

      @java.lang.Override
      public Builder clear() {
        super.clear();
        maxNumSteps_ = 0L;

        minNumSteps_ = 0L;

        autoregressiveOrder_ = 0L;

        learningRateParameterName_ = "";

        useSeconds_ = false;

        return this;
      }

      @java.lang.Override
      public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
        return com.google.cloud.aiplatform.v1beta1.StudyProto
            .internal_static_google_cloud_aiplatform_v1beta1_StudySpec_ConvexStopConfig_descriptor;
      }

      @java.lang.Override
      public com.google.cloud.aiplatform.v1beta1.StudySpec.ConvexStopConfig
          getDefaultInstanceForType() {
        return com.google.cloud.aiplatform.v1beta1.StudySpec.ConvexStopConfig.getDefaultInstance();
      }

      @java.lang.Override
      public com.google.cloud.aiplatform.v1beta1.StudySpec.ConvexStopConfig build() {
        com.google.cloud.aiplatform.v1beta1.StudySpec.ConvexStopConfig result = buildPartial();
        if (!result.isInitialized()) {
          throw newUninitializedMessageException(result);
        }
        return result;
      }

      @java.lang.Override
      public com.google.cloud.aiplatform.v1beta1.StudySpec.ConvexStopConfig buildPartial() {
        com.google.cloud.aiplatform.v1beta1.StudySpec.ConvexStopConfig result =
            new com.google.cloud.aiplatform.v1beta1.StudySpec.ConvexStopConfig(this);
        result.maxNumSteps_ = maxNumSteps_;
        result.minNumSteps_ = minNumSteps_;
        result.autoregressiveOrder_ = autoregressiveOrder_;
        result.learningRateParameterName_ = learningRateParameterName_;
        result.useSeconds_ = useSeconds_;
        onBuilt();
        return result;
      }

      @java.lang.Override
      public Builder clone() {
        return super.clone();
      }

      @java.lang.Override
      public Builder setField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.setField(field, value);
      }

      @java.lang.Override
      public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
        return super.clearField(field);
      }

      @java.lang.Override
      public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
        return super.clearOneof(oneof);
      }

      @java.lang.Override
      public Builder setRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          int index,
          java.lang.Object value) {
        return super.setRepeatedField(field, index, value);
      }

      @java.lang.Override
      public Builder addRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.addRepeatedField(field, value);
      }

      @java.lang.Override
      public Builder mergeFrom(com.google.protobuf.Message other) {
        if (other instanceof com.google.cloud.aiplatform.v1beta1.StudySpec.ConvexStopConfig) {
          return mergeFrom((com.google.cloud.aiplatform.v1beta1.StudySpec.ConvexStopConfig) other);
        } else {
          super.mergeFrom(other);
          return this;
        }
      }

      public Builder mergeFrom(
          com.google.cloud.aiplatform.v1beta1.StudySpec.ConvexStopConfig other) {
        if (other
            == com.google.cloud.aiplatform.v1beta1.StudySpec.ConvexStopConfig.getDefaultInstance())
          return this;
        if (other.getMaxNumSteps() != 0L) {
          setMaxNumSteps(other.getMaxNumSteps());
        }
        if (other.getMinNumSteps() != 0L) {
          setMinNumSteps(other.getMinNumSteps());
        }
        if (other.getAutoregressiveOrder() != 0L) {
          setAutoregressiveOrder(other.getAutoregressiveOrder());
        }
        if (!other.getLearningRateParameterName().isEmpty()) {
          learningRateParameterName_ = other.learningRateParameterName_;
          onChanged();
        }
        if (other.getUseSeconds() != false) {
          setUseSeconds(other.getUseSeconds());
        }
        this.mergeUnknownFields(other.unknownFields);
        onChanged();
        return this;
      }

      @java.lang.Override
      public final boolean isInitialized() {
        return true;
      }

      @java.lang.Override
      public Builder mergeFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        com.google.cloud.aiplatform.v1beta1.StudySpec.ConvexStopConfig parsedMessage = null;
        try {
          parsedMessage = PARSER.parsePartialFrom(input, extensionRegistry);
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          parsedMessage =
              (com.google.cloud.aiplatform.v1beta1.StudySpec.ConvexStopConfig)
                  e.getUnfinishedMessage();
          throw e.unwrapIOException();
        } finally {
          if (parsedMessage != null) {
            mergeFrom(parsedMessage);
          }
        }
        return this;
      }

      private long maxNumSteps_;
      /**
       *
       *
       * <pre>
       * Steps used in predicting the final objective for early stopped trials. In
       * general, it's set to be the same as the defined steps in training /
       * tuning. When use_steps is false, this field is set to the maximum elapsed
       * seconds.
       * </pre>
       *
       * <code>int64 max_num_steps = 1;</code>
       *
       * @return The maxNumSteps.
       */
      @java.lang.Override
      public long getMaxNumSteps() {
        return maxNumSteps_;
      }
      /**
       *
       *
       * <pre>
       * Steps used in predicting the final objective for early stopped trials. In
       * general, it's set to be the same as the defined steps in training /
       * tuning. When use_steps is false, this field is set to the maximum elapsed
       * seconds.
       * </pre>
       *
       * <code>int64 max_num_steps = 1;</code>
       *
       * @param value The maxNumSteps to set.
       * @return This builder for chaining.
       */
      public Builder setMaxNumSteps(long value) {

        maxNumSteps_ = value;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Steps used in predicting the final objective for early stopped trials. In
       * general, it's set to be the same as the defined steps in training /
       * tuning. When use_steps is false, this field is set to the maximum elapsed
       * seconds.
       * </pre>
       *
       * <code>int64 max_num_steps = 1;</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearMaxNumSteps() {

        maxNumSteps_ = 0L;
        onChanged();
        return this;
      }

      private long minNumSteps_;
      /**
       *
       *
       * <pre>
       * Minimum number of steps for a trial to complete. Trials which do not have
       * a measurement with num_steps &gt; min_num_steps won't be considered for
       * early stopping. It's ok to set it to 0, and a trial can be early stopped
       * at any stage. By default, min_num_steps is set to be one-tenth of the
       * max_num_steps.
       * When use_steps is false, this field is set to the minimum elapsed
       * seconds.
       * </pre>
       *
       * <code>int64 min_num_steps = 2;</code>
       *
       * @return The minNumSteps.
       */
      @java.lang.Override
      public long getMinNumSteps() {
        return minNumSteps_;
      }
      /**
       *
       *
       * <pre>
       * Minimum number of steps for a trial to complete. Trials which do not have
       * a measurement with num_steps &gt; min_num_steps won't be considered for
       * early stopping. It's ok to set it to 0, and a trial can be early stopped
       * at any stage. By default, min_num_steps is set to be one-tenth of the
       * max_num_steps.
       * When use_steps is false, this field is set to the minimum elapsed
       * seconds.
       * </pre>
       *
       * <code>int64 min_num_steps = 2;</code>
       *
       * @param value The minNumSteps to set.
       * @return This builder for chaining.
       */
      public Builder setMinNumSteps(long value) {

        minNumSteps_ = value;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Minimum number of steps for a trial to complete. Trials which do not have
       * a measurement with num_steps &gt; min_num_steps won't be considered for
       * early stopping. It's ok to set it to 0, and a trial can be early stopped
       * at any stage. By default, min_num_steps is set to be one-tenth of the
       * max_num_steps.
       * When use_steps is false, this field is set to the minimum elapsed
       * seconds.
       * </pre>
       *
       * <code>int64 min_num_steps = 2;</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearMinNumSteps() {

        minNumSteps_ = 0L;
        onChanged();
        return this;
      }

      private long autoregressiveOrder_;
      /**
       *
       *
       * <pre>
       * The number of Trial measurements used in autoregressive model for
       * value prediction. A trial won't be considered early stopping if has fewer
       * measurement points.
       * </pre>
       *
       * <code>int64 autoregressive_order = 3;</code>
       *
       * @return The autoregressiveOrder.
       */
      @java.lang.Override
      public long getAutoregressiveOrder() {
        return autoregressiveOrder_;
      }
      /**
       *
       *
       * <pre>
       * The number of Trial measurements used in autoregressive model for
       * value prediction. A trial won't be considered early stopping if has fewer
       * measurement points.
       * </pre>
       *
       * <code>int64 autoregressive_order = 3;</code>
       *
       * @param value The autoregressiveOrder to set.
       * @return This builder for chaining.
       */
      public Builder setAutoregressiveOrder(long value) {

        autoregressiveOrder_ = value;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * The number of Trial measurements used in autoregressive model for
       * value prediction. A trial won't be considered early stopping if has fewer
       * measurement points.
       * </pre>
       *
       * <code>int64 autoregressive_order = 3;</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearAutoregressiveOrder() {

        autoregressiveOrder_ = 0L;
        onChanged();
        return this;
      }

      private java.lang.Object learningRateParameterName_ = "";
      /**
       *
       *
       * <pre>
       * The hyper-parameter name used in the tuning job that stands for learning
       * rate. Leave it blank if learning rate is not in a parameter in tuning.
       * The learning_rate is used to estimate the objective value of the ongoing
       * trial.
       * </pre>
       *
       * <code>string learning_rate_parameter_name = 4;</code>
       *
       * @return The learningRateParameterName.
       */
      public java.lang.String getLearningRateParameterName() {
        java.lang.Object ref = learningRateParameterName_;
        if (!(ref instanceof java.lang.String)) {
          com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
          java.lang.String s = bs.toStringUtf8();
          learningRateParameterName_ = s;
          return s;
        } else {
          return (java.lang.String) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * The hyper-parameter name used in the tuning job that stands for learning
       * rate. Leave it blank if learning rate is not in a parameter in tuning.
       * The learning_rate is used to estimate the objective value of the ongoing
       * trial.
       * </pre>
       *
       * <code>string learning_rate_parameter_name = 4;</code>
       *
       * @return The bytes for learningRateParameterName.
       */
      public com.google.protobuf.ByteString getLearningRateParameterNameBytes() {
        java.lang.Object ref = learningRateParameterName_;
        if (ref instanceof String) {
          com.google.protobuf.ByteString b =
              com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
          learningRateParameterName_ = b;
          return b;
        } else {
          return (com.google.protobuf.ByteString) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * The hyper-parameter name used in the tuning job that stands for learning
       * rate. Leave it blank if learning rate is not in a parameter in tuning.
       * The learning_rate is used to estimate the objective value of the ongoing
       * trial.
       * </pre>
       *
       * <code>string learning_rate_parameter_name = 4;</code>
       *
       * @param value The learningRateParameterName to set.
       * @return This builder for chaining.
       */
      public Builder setLearningRateParameterName(java.lang.String value) {
        if (value == null) {
          throw new NullPointerException();
        }

        learningRateParameterName_ = value;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * The hyper-parameter name used in the tuning job that stands for learning
       * rate. Leave it blank if learning rate is not in a parameter in tuning.
       * The learning_rate is used to estimate the objective value of the ongoing
       * trial.
       * </pre>
       *
       * <code>string learning_rate_parameter_name = 4;</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearLearningRateParameterName() {

        learningRateParameterName_ = getDefaultInstance().getLearningRateParameterName();
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * The hyper-parameter name used in the tuning job that stands for learning
       * rate. Leave it blank if learning rate is not in a parameter in tuning.
       * The learning_rate is used to estimate the objective value of the ongoing
       * trial.
       * </pre>
       *
       * <code>string learning_rate_parameter_name = 4;</code>
       *
       * @param value The bytes for learningRateParameterName to set.
       * @return This builder for chaining.
       */
      public Builder setLearningRateParameterNameBytes(com.google.protobuf.ByteString value) {
        if (value == null) {
          throw new NullPointerException();
        }
        checkByteStringIsUtf8(value);

        learningRateParameterName_ = value;
        onChanged();
        return this;
      }

      private boolean useSeconds_;
      /**
       *
       *
       * <pre>
       * This bool determines whether or not the rule is applied based on
       * elapsed_secs or steps. If use_seconds==false, the early stopping decision
       * is made according to the predicted objective values according to the
       * target steps. If use_seconds==true, elapsed_secs is used instead of
       * steps. Also, in this case, the parameters max_num_steps and min_num_steps
       * are overloaded to contain max_elapsed_seconds and min_elapsed_seconds.
       * </pre>
       *
       * <code>bool use_seconds = 5;</code>
       *
       * @return The useSeconds.
       */
      @java.lang.Override
      public boolean getUseSeconds() {
        return useSeconds_;
      }
      /**
       *
       *
       * <pre>
       * This bool determines whether or not the rule is applied based on
       * elapsed_secs or steps. If use_seconds==false, the early stopping decision
       * is made according to the predicted objective values according to the
       * target steps. If use_seconds==true, elapsed_secs is used instead of
       * steps. Also, in this case, the parameters max_num_steps and min_num_steps
       * are overloaded to contain max_elapsed_seconds and min_elapsed_seconds.
       * </pre>
       *
       * <code>bool use_seconds = 5;</code>
       *
       * @param value The useSeconds to set.
       * @return This builder for chaining.
       */
      public Builder setUseSeconds(boolean value) {

        useSeconds_ = value;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * This bool determines whether or not the rule is applied based on
       * elapsed_secs or steps. If use_seconds==false, the early stopping decision
       * is made according to the predicted objective values according to the
       * target steps. If use_seconds==true, elapsed_secs is used instead of
       * steps. Also, in this case, the parameters max_num_steps and min_num_steps
       * are overloaded to contain max_elapsed_seconds and min_elapsed_seconds.
       * </pre>
       *
       * <code>bool use_seconds = 5;</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearUseSeconds() {

        useSeconds_ = false;
        onChanged();
        return this;
      }

      @java.lang.Override
      public final Builder setUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.setUnknownFields(unknownFields);
      }

      @java.lang.Override
      public final Builder mergeUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.mergeUnknownFields(unknownFields);
      }

      // @@protoc_insertion_point(builder_scope:google.cloud.aiplatform.v1beta1.StudySpec.ConvexStopConfig)
    }

    // @@protoc_insertion_point(class_scope:google.cloud.aiplatform.v1beta1.StudySpec.ConvexStopConfig)
    private static final com.google.cloud.aiplatform.v1beta1.StudySpec.ConvexStopConfig
        DEFAULT_INSTANCE;

    static {
      DEFAULT_INSTANCE = new com.google.cloud.aiplatform.v1beta1.StudySpec.ConvexStopConfig();
    }

    public static com.google.cloud.aiplatform.v1beta1.StudySpec.ConvexStopConfig
        getDefaultInstance() {
      return DEFAULT_INSTANCE;
    }

    private static final com.google.protobuf.Parser<ConvexStopConfig> PARSER =
        new com.google.protobuf.AbstractParser<ConvexStopConfig>() {
          @java.lang.Override
          public ConvexStopConfig parsePartialFrom(
              com.google.protobuf.CodedInputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
            return new ConvexStopConfig(input, extensionRegistry);
          }
        };

    public static com.google.protobuf.Parser<ConvexStopConfig> parser() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.protobuf.Parser<ConvexStopConfig> getParserForType() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.cloud.aiplatform.v1beta1.StudySpec.ConvexStopConfig
        getDefaultInstanceForType() {
      return DEFAULT_INSTANCE;
    }
  }

  private int automatedStoppingSpecCase_ = 0;
  private java.lang.Object automatedStoppingSpec_;

  public enum AutomatedStoppingSpecCase
      implements
          com.google.protobuf.Internal.EnumLite,
          com.google.protobuf.AbstractMessage.InternalOneOfEnum {
    DECAY_CURVE_STOPPING_SPEC(4),
    MEDIAN_AUTOMATED_STOPPING_SPEC(5),
    @java.lang.Deprecated
    CONVEX_STOP_CONFIG(8),
    AUTOMATEDSTOPPINGSPEC_NOT_SET(0);
    private final int value;

    private AutomatedStoppingSpecCase(int value) {
      this.value = value;
    }
    /**
     * @param value The number of the enum to look for.
     * @return The enum associated with the given number.
     * @deprecated Use {@link #forNumber(int)} instead.
     */
    @java.lang.Deprecated
    public static AutomatedStoppingSpecCase valueOf(int value) {
      return forNumber(value);
    }

    public static AutomatedStoppingSpecCase forNumber(int value) {
      switch (value) {
        case 4:
          return DECAY_CURVE_STOPPING_SPEC;
        case 5:
          return MEDIAN_AUTOMATED_STOPPING_SPEC;
        case 8:
          return CONVEX_STOP_CONFIG;
        case 0:
          return AUTOMATEDSTOPPINGSPEC_NOT_SET;
        default:
          return null;
      }
    }

    public int getNumber() {
      return this.value;
    }
  };

  public AutomatedStoppingSpecCase getAutomatedStoppingSpecCase() {
    return AutomatedStoppingSpecCase.forNumber(automatedStoppingSpecCase_);
  }

  public static final int DECAY_CURVE_STOPPING_SPEC_FIELD_NUMBER = 4;
  /**
   *
   *
   * <pre>
   * The automated early stopping spec using decay curve rule.
   * </pre>
   *
   * <code>
   * .google.cloud.aiplatform.v1beta1.StudySpec.DecayCurveAutomatedStoppingSpec decay_curve_stopping_spec = 4;
   * </code>
   *
   * @return Whether the decayCurveStoppingSpec field is set.
   */
  @java.lang.Override
  public boolean hasDecayCurveStoppingSpec() {
    return automatedStoppingSpecCase_ == 4;
  }
  /**
   *
   *
   * <pre>
   * The automated early stopping spec using decay curve rule.
   * </pre>
   *
   * <code>
   * .google.cloud.aiplatform.v1beta1.StudySpec.DecayCurveAutomatedStoppingSpec decay_curve_stopping_spec = 4;
   * </code>
   *
   * @return The decayCurveStoppingSpec.
   */
  @java.lang.Override
  public com.google.cloud.aiplatform.v1beta1.StudySpec.DecayCurveAutomatedStoppingSpec
      getDecayCurveStoppingSpec() {
    if (automatedStoppingSpecCase_ == 4) {
      return (com.google.cloud.aiplatform.v1beta1.StudySpec.DecayCurveAutomatedStoppingSpec)
          automatedStoppingSpec_;
    }
    return com.google.cloud.aiplatform.v1beta1.StudySpec.DecayCurveAutomatedStoppingSpec
        .getDefaultInstance();
  }
  /**
   *
   *
   * <pre>
   * The automated early stopping spec using decay curve rule.
   * </pre>
   *
   * <code>
   * .google.cloud.aiplatform.v1beta1.StudySpec.DecayCurveAutomatedStoppingSpec decay_curve_stopping_spec = 4;
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.aiplatform.v1beta1.StudySpec.DecayCurveAutomatedStoppingSpecOrBuilder
      getDecayCurveStoppingSpecOrBuilder() {
    if (automatedStoppingSpecCase_ == 4) {
      return (com.google.cloud.aiplatform.v1beta1.StudySpec.DecayCurveAutomatedStoppingSpec)
          automatedStoppingSpec_;
    }
    return com.google.cloud.aiplatform.v1beta1.StudySpec.DecayCurveAutomatedStoppingSpec
        .getDefaultInstance();
  }

  public static final int MEDIAN_AUTOMATED_STOPPING_SPEC_FIELD_NUMBER = 5;
  /**
   *
   *
   * <pre>
   * The automated early stopping spec using median rule.
   * </pre>
   *
   * <code>
   * .google.cloud.aiplatform.v1beta1.StudySpec.MedianAutomatedStoppingSpec median_automated_stopping_spec = 5;
   * </code>
   *
   * @return Whether the medianAutomatedStoppingSpec field is set.
   */
  @java.lang.Override
  public boolean hasMedianAutomatedStoppingSpec() {
    return automatedStoppingSpecCase_ == 5;
  }
  /**
   *
   *
   * <pre>
   * The automated early stopping spec using median rule.
   * </pre>
   *
   * <code>
   * .google.cloud.aiplatform.v1beta1.StudySpec.MedianAutomatedStoppingSpec median_automated_stopping_spec = 5;
   * </code>
   *
   * @return The medianAutomatedStoppingSpec.
   */
  @java.lang.Override
  public com.google.cloud.aiplatform.v1beta1.StudySpec.MedianAutomatedStoppingSpec
      getMedianAutomatedStoppingSpec() {
    if (automatedStoppingSpecCase_ == 5) {
      return (com.google.cloud.aiplatform.v1beta1.StudySpec.MedianAutomatedStoppingSpec)
          automatedStoppingSpec_;
    }
    return com.google.cloud.aiplatform.v1beta1.StudySpec.MedianAutomatedStoppingSpec
        .getDefaultInstance();
  }
  /**
   *
   *
   * <pre>
   * The automated early stopping spec using median rule.
   * </pre>
   *
   * <code>
   * .google.cloud.aiplatform.v1beta1.StudySpec.MedianAutomatedStoppingSpec median_automated_stopping_spec = 5;
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.aiplatform.v1beta1.StudySpec.MedianAutomatedStoppingSpecOrBuilder
      getMedianAutomatedStoppingSpecOrBuilder() {
    if (automatedStoppingSpecCase_ == 5) {
      return (com.google.cloud.aiplatform.v1beta1.StudySpec.MedianAutomatedStoppingSpec)
          automatedStoppingSpec_;
    }
    return com.google.cloud.aiplatform.v1beta1.StudySpec.MedianAutomatedStoppingSpec
        .getDefaultInstance();
  }

  public static final int CONVEX_STOP_CONFIG_FIELD_NUMBER = 8;
  /**
   *
   *
   * <pre>
   * Deprecated.
   * The automated early stopping using convex stopping rule.
   * </pre>
   *
   * <code>
   * .google.cloud.aiplatform.v1beta1.StudySpec.ConvexStopConfig convex_stop_config = 8 [deprecated = true];
   * </code>
   *
   * @return Whether the convexStopConfig field is set.
   */
  @java.lang.Override
  @java.lang.Deprecated
  public boolean hasConvexStopConfig() {
    return automatedStoppingSpecCase_ == 8;
  }
  /**
   *
   *
   * <pre>
   * Deprecated.
   * The automated early stopping using convex stopping rule.
   * </pre>
   *
   * <code>
   * .google.cloud.aiplatform.v1beta1.StudySpec.ConvexStopConfig convex_stop_config = 8 [deprecated = true];
   * </code>
   *
   * @return The convexStopConfig.
   */
  @java.lang.Override
  @java.lang.Deprecated
  public com.google.cloud.aiplatform.v1beta1.StudySpec.ConvexStopConfig getConvexStopConfig() {
    if (automatedStoppingSpecCase_ == 8) {
      return (com.google.cloud.aiplatform.v1beta1.StudySpec.ConvexStopConfig)
          automatedStoppingSpec_;
    }
    return com.google.cloud.aiplatform.v1beta1.StudySpec.ConvexStopConfig.getDefaultInstance();
  }
  /**
   *
   *
   * <pre>
   * Deprecated.
   * The automated early stopping using convex stopping rule.
   * </pre>
   *
   * <code>
   * .google.cloud.aiplatform.v1beta1.StudySpec.ConvexStopConfig convex_stop_config = 8 [deprecated = true];
   * </code>
   */
  @java.lang.Override
  @java.lang.Deprecated
  public com.google.cloud.aiplatform.v1beta1.StudySpec.ConvexStopConfigOrBuilder
      getConvexStopConfigOrBuilder() {
    if (automatedStoppingSpecCase_ == 8) {
      return (com.google.cloud.aiplatform.v1beta1.StudySpec.ConvexStopConfig)
          automatedStoppingSpec_;
    }
    return com.google.cloud.aiplatform.v1beta1.StudySpec.ConvexStopConfig.getDefaultInstance();
  }

  public static final int METRICS_FIELD_NUMBER = 1;
  private java.util.List<com.google.cloud.aiplatform.v1beta1.StudySpec.MetricSpec> metrics_;
  /**
   *
   *
   * <pre>
   * Required. Metric specs for the Study.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.aiplatform.v1beta1.StudySpec.MetricSpec metrics = 1 [(.google.api.field_behavior) = REQUIRED];
   * </code>
   */
  @java.lang.Override
  public java.util.List<com.google.cloud.aiplatform.v1beta1.StudySpec.MetricSpec> getMetricsList() {
    return metrics_;
  }
  /**
   *
   *
   * <pre>
   * Required. Metric specs for the Study.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.aiplatform.v1beta1.StudySpec.MetricSpec metrics = 1 [(.google.api.field_behavior) = REQUIRED];
   * </code>
   */
  @java.lang.Override
  public java.util.List<? extends com.google.cloud.aiplatform.v1beta1.StudySpec.MetricSpecOrBuilder>
      getMetricsOrBuilderList() {
    return metrics_;
  }
  /**
   *
   *
   * <pre>
   * Required. Metric specs for the Study.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.aiplatform.v1beta1.StudySpec.MetricSpec metrics = 1 [(.google.api.field_behavior) = REQUIRED];
   * </code>
   */
  @java.lang.Override
  public int getMetricsCount() {
    return metrics_.size();
  }
  /**
   *
   *
   * <pre>
   * Required. Metric specs for the Study.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.aiplatform.v1beta1.StudySpec.MetricSpec metrics = 1 [(.google.api.field_behavior) = REQUIRED];
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.aiplatform.v1beta1.StudySpec.MetricSpec getMetrics(int index) {
    return metrics_.get(index);
  }
  /**
   *
   *
   * <pre>
   * Required. Metric specs for the Study.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.aiplatform.v1beta1.StudySpec.MetricSpec metrics = 1 [(.google.api.field_behavior) = REQUIRED];
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.aiplatform.v1beta1.StudySpec.MetricSpecOrBuilder getMetricsOrBuilder(
      int index) {
    return metrics_.get(index);
  }

  public static final int PARAMETERS_FIELD_NUMBER = 2;
  private java.util.List<com.google.cloud.aiplatform.v1beta1.StudySpec.ParameterSpec> parameters_;
  /**
   *
   *
   * <pre>
   * Required. The set of parameters to tune.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.aiplatform.v1beta1.StudySpec.ParameterSpec parameters = 2 [(.google.api.field_behavior) = REQUIRED];
   * </code>
   */
  @java.lang.Override
  public java.util.List<com.google.cloud.aiplatform.v1beta1.StudySpec.ParameterSpec>
      getParametersList() {
    return parameters_;
  }
  /**
   *
   *
   * <pre>
   * Required. The set of parameters to tune.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.aiplatform.v1beta1.StudySpec.ParameterSpec parameters = 2 [(.google.api.field_behavior) = REQUIRED];
   * </code>
   */
  @java.lang.Override
  public java.util.List<
          ? extends com.google.cloud.aiplatform.v1beta1.StudySpec.ParameterSpecOrBuilder>
      getParametersOrBuilderList() {
    return parameters_;
  }
  /**
   *
   *
   * <pre>
   * Required. The set of parameters to tune.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.aiplatform.v1beta1.StudySpec.ParameterSpec parameters = 2 [(.google.api.field_behavior) = REQUIRED];
   * </code>
   */
  @java.lang.Override
  public int getParametersCount() {
    return parameters_.size();
  }
  /**
   *
   *
   * <pre>
   * Required. The set of parameters to tune.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.aiplatform.v1beta1.StudySpec.ParameterSpec parameters = 2 [(.google.api.field_behavior) = REQUIRED];
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.aiplatform.v1beta1.StudySpec.ParameterSpec getParameters(int index) {
    return parameters_.get(index);
  }
  /**
   *
   *
   * <pre>
   * Required. The set of parameters to tune.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.aiplatform.v1beta1.StudySpec.ParameterSpec parameters = 2 [(.google.api.field_behavior) = REQUIRED];
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.aiplatform.v1beta1.StudySpec.ParameterSpecOrBuilder
      getParametersOrBuilder(int index) {
    return parameters_.get(index);
  }

  public static final int ALGORITHM_FIELD_NUMBER = 3;
  private int algorithm_;
  /**
   *
   *
   * <pre>
   * The search algorithm specified for the Study.
   * </pre>
   *
   * <code>.google.cloud.aiplatform.v1beta1.StudySpec.Algorithm algorithm = 3;</code>
   *
   * @return The enum numeric value on the wire for algorithm.
   */
  @java.lang.Override
  public int getAlgorithmValue() {
    return algorithm_;
  }
  /**
   *
   *
   * <pre>
   * The search algorithm specified for the Study.
   * </pre>
   *
   * <code>.google.cloud.aiplatform.v1beta1.StudySpec.Algorithm algorithm = 3;</code>
   *
   * @return The algorithm.
   */
  @java.lang.Override
  public com.google.cloud.aiplatform.v1beta1.StudySpec.Algorithm getAlgorithm() {
    @SuppressWarnings("deprecation")
    com.google.cloud.aiplatform.v1beta1.StudySpec.Algorithm result =
        com.google.cloud.aiplatform.v1beta1.StudySpec.Algorithm.valueOf(algorithm_);
    return result == null
        ? com.google.cloud.aiplatform.v1beta1.StudySpec.Algorithm.UNRECOGNIZED
        : result;
  }

  public static final int OBSERVATION_NOISE_FIELD_NUMBER = 6;
  private int observationNoise_;
  /**
   *
   *
   * <pre>
   * The observation noise level of the study.
   * Currently only supported by the Vizier service. Not supported by
   * HyperparamterTuningJob or TrainingPipeline.
   * </pre>
   *
   * <code>.google.cloud.aiplatform.v1beta1.StudySpec.ObservationNoise observation_noise = 6;</code>
   *
   * @return The enum numeric value on the wire for observationNoise.
   */
  @java.lang.Override
  public int getObservationNoiseValue() {
    return observationNoise_;
  }
  /**
   *
   *
   * <pre>
   * The observation noise level of the study.
   * Currently only supported by the Vizier service. Not supported by
   * HyperparamterTuningJob or TrainingPipeline.
   * </pre>
   *
   * <code>.google.cloud.aiplatform.v1beta1.StudySpec.ObservationNoise observation_noise = 6;</code>
   *
   * @return The observationNoise.
   */
  @java.lang.Override
  public com.google.cloud.aiplatform.v1beta1.StudySpec.ObservationNoise getObservationNoise() {
    @SuppressWarnings("deprecation")
    com.google.cloud.aiplatform.v1beta1.StudySpec.ObservationNoise result =
        com.google.cloud.aiplatform.v1beta1.StudySpec.ObservationNoise.valueOf(observationNoise_);
    return result == null
        ? com.google.cloud.aiplatform.v1beta1.StudySpec.ObservationNoise.UNRECOGNIZED
        : result;
  }

  public static final int MEASUREMENT_SELECTION_TYPE_FIELD_NUMBER = 7;
  private int measurementSelectionType_;
  /**
   *
   *
   * <pre>
   * Describe which measurement selection type will be used
   * </pre>
   *
   * <code>
   * .google.cloud.aiplatform.v1beta1.StudySpec.MeasurementSelectionType measurement_selection_type = 7;
   * </code>
   *
   * @return The enum numeric value on the wire for measurementSelectionType.
   */
  @java.lang.Override
  public int getMeasurementSelectionTypeValue() {
    return measurementSelectionType_;
  }
  /**
   *
   *
   * <pre>
   * Describe which measurement selection type will be used
   * </pre>
   *
   * <code>
   * .google.cloud.aiplatform.v1beta1.StudySpec.MeasurementSelectionType measurement_selection_type = 7;
   * </code>
   *
   * @return The measurementSelectionType.
   */
  @java.lang.Override
  public com.google.cloud.aiplatform.v1beta1.StudySpec.MeasurementSelectionType
      getMeasurementSelectionType() {
    @SuppressWarnings("deprecation")
    com.google.cloud.aiplatform.v1beta1.StudySpec.MeasurementSelectionType result =
        com.google.cloud.aiplatform.v1beta1.StudySpec.MeasurementSelectionType.valueOf(
            measurementSelectionType_);
    return result == null
        ? com.google.cloud.aiplatform.v1beta1.StudySpec.MeasurementSelectionType.UNRECOGNIZED
        : result;
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    for (int i = 0; i < metrics_.size(); i++) {
      output.writeMessage(1, metrics_.get(i));
    }
    for (int i = 0; i < parameters_.size(); i++) {
      output.writeMessage(2, parameters_.get(i));
    }
    if (algorithm_
        != com.google.cloud.aiplatform.v1beta1.StudySpec.Algorithm.ALGORITHM_UNSPECIFIED
            .getNumber()) {
      output.writeEnum(3, algorithm_);
    }
    if (automatedStoppingSpecCase_ == 4) {
      output.writeMessage(
          4,
          (com.google.cloud.aiplatform.v1beta1.StudySpec.DecayCurveAutomatedStoppingSpec)
              automatedStoppingSpec_);
    }
    if (automatedStoppingSpecCase_ == 5) {
      output.writeMessage(
          5,
          (com.google.cloud.aiplatform.v1beta1.StudySpec.MedianAutomatedStoppingSpec)
              automatedStoppingSpec_);
    }
    if (observationNoise_
        != com.google.cloud.aiplatform.v1beta1.StudySpec.ObservationNoise
            .OBSERVATION_NOISE_UNSPECIFIED
            .getNumber()) {
      output.writeEnum(6, observationNoise_);
    }
    if (measurementSelectionType_
        != com.google.cloud.aiplatform.v1beta1.StudySpec.MeasurementSelectionType
            .MEASUREMENT_SELECTION_TYPE_UNSPECIFIED
            .getNumber()) {
      output.writeEnum(7, measurementSelectionType_);
    }
    if (automatedStoppingSpecCase_ == 8) {
      output.writeMessage(
          8,
          (com.google.cloud.aiplatform.v1beta1.StudySpec.ConvexStopConfig) automatedStoppingSpec_);
    }
    unknownFields.writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    for (int i = 0; i < metrics_.size(); i++) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(1, metrics_.get(i));
    }
    for (int i = 0; i < parameters_.size(); i++) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(2, parameters_.get(i));
    }
    if (algorithm_
        != com.google.cloud.aiplatform.v1beta1.StudySpec.Algorithm.ALGORITHM_UNSPECIFIED
            .getNumber()) {
      size += com.google.protobuf.CodedOutputStream.computeEnumSize(3, algorithm_);
    }
    if (automatedStoppingSpecCase_ == 4) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(
              4,
              (com.google.cloud.aiplatform.v1beta1.StudySpec.DecayCurveAutomatedStoppingSpec)
                  automatedStoppingSpec_);
    }
    if (automatedStoppingSpecCase_ == 5) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(
              5,
              (com.google.cloud.aiplatform.v1beta1.StudySpec.MedianAutomatedStoppingSpec)
                  automatedStoppingSpec_);
    }
    if (observationNoise_
        != com.google.cloud.aiplatform.v1beta1.StudySpec.ObservationNoise
            .OBSERVATION_NOISE_UNSPECIFIED
            .getNumber()) {
      size += com.google.protobuf.CodedOutputStream.computeEnumSize(6, observationNoise_);
    }
    if (measurementSelectionType_
        != com.google.cloud.aiplatform.v1beta1.StudySpec.MeasurementSelectionType
            .MEASUREMENT_SELECTION_TYPE_UNSPECIFIED
            .getNumber()) {
      size += com.google.protobuf.CodedOutputStream.computeEnumSize(7, measurementSelectionType_);
    }
    if (automatedStoppingSpecCase_ == 8) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(
              8,
              (com.google.cloud.aiplatform.v1beta1.StudySpec.ConvexStopConfig)
                  automatedStoppingSpec_);
    }
    size += unknownFields.getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.cloud.aiplatform.v1beta1.StudySpec)) {
      return super.equals(obj);
    }
    com.google.cloud.aiplatform.v1beta1.StudySpec other =
        (com.google.cloud.aiplatform.v1beta1.StudySpec) obj;

    if (!getMetricsList().equals(other.getMetricsList())) return false;
    if (!getParametersList().equals(other.getParametersList())) return false;
    if (algorithm_ != other.algorithm_) return false;
    if (observationNoise_ != other.observationNoise_) return false;
    if (measurementSelectionType_ != other.measurementSelectionType_) return false;
    if (!getAutomatedStoppingSpecCase().equals(other.getAutomatedStoppingSpecCase())) return false;
    switch (automatedStoppingSpecCase_) {
      case 4:
        if (!getDecayCurveStoppingSpec().equals(other.getDecayCurveStoppingSpec())) return false;
        break;
      case 5:
        if (!getMedianAutomatedStoppingSpec().equals(other.getMedianAutomatedStoppingSpec()))
          return false;
        break;
      case 8:
        if (!getConvexStopConfig().equals(other.getConvexStopConfig())) return false;
        break;
      case 0:
      default:
    }
    if (!unknownFields.equals(other.unknownFields)) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    if (getMetricsCount() > 0) {
      hash = (37 * hash) + METRICS_FIELD_NUMBER;
      hash = (53 * hash) + getMetricsList().hashCode();
    }
    if (getParametersCount() > 0) {
      hash = (37 * hash) + PARAMETERS_FIELD_NUMBER;
      hash = (53 * hash) + getParametersList().hashCode();
    }
    hash = (37 * hash) + ALGORITHM_FIELD_NUMBER;
    hash = (53 * hash) + algorithm_;
    hash = (37 * hash) + OBSERVATION_NOISE_FIELD_NUMBER;
    hash = (53 * hash) + observationNoise_;
    hash = (37 * hash) + MEASUREMENT_SELECTION_TYPE_FIELD_NUMBER;
    hash = (53 * hash) + measurementSelectionType_;
    switch (automatedStoppingSpecCase_) {
      case 4:
        hash = (37 * hash) + DECAY_CURVE_STOPPING_SPEC_FIELD_NUMBER;
        hash = (53 * hash) + getDecayCurveStoppingSpec().hashCode();
        break;
      case 5:
        hash = (37 * hash) + MEDIAN_AUTOMATED_STOPPING_SPEC_FIELD_NUMBER;
        hash = (53 * hash) + getMedianAutomatedStoppingSpec().hashCode();
        break;
      case 8:
        hash = (37 * hash) + CONVEX_STOP_CONFIG_FIELD_NUMBER;
        hash = (53 * hash) + getConvexStopConfig().hashCode();
        break;
      case 0:
      default:
    }
    hash = (29 * hash) + unknownFields.hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.cloud.aiplatform.v1beta1.StudySpec parseFrom(java.nio.ByteBuffer data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.aiplatform.v1beta1.StudySpec parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.aiplatform.v1beta1.StudySpec parseFrom(
      com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.aiplatform.v1beta1.StudySpec parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.aiplatform.v1beta1.StudySpec parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.aiplatform.v1beta1.StudySpec parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.aiplatform.v1beta1.StudySpec parseFrom(java.io.InputStream input)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.aiplatform.v1beta1.StudySpec parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.aiplatform.v1beta1.StudySpec parseDelimitedFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.cloud.aiplatform.v1beta1.StudySpec parseDelimitedFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.aiplatform.v1beta1.StudySpec parseFrom(
      com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.aiplatform.v1beta1.StudySpec parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(com.google.cloud.aiplatform.v1beta1.StudySpec prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }
  /**
   *
   *
   * <pre>
   * Represents specification of a Study.
   * </pre>
   *
   * Protobuf type {@code google.cloud.aiplatform.v1beta1.StudySpec}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.cloud.aiplatform.v1beta1.StudySpec)
      com.google.cloud.aiplatform.v1beta1.StudySpecOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.aiplatform.v1beta1.StudyProto
          .internal_static_google_cloud_aiplatform_v1beta1_StudySpec_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.aiplatform.v1beta1.StudyProto
          .internal_static_google_cloud_aiplatform_v1beta1_StudySpec_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.aiplatform.v1beta1.StudySpec.class,
              com.google.cloud.aiplatform.v1beta1.StudySpec.Builder.class);
    }

    // Construct using com.google.cloud.aiplatform.v1beta1.StudySpec.newBuilder()
    private Builder() {
      maybeForceBuilderInitialization();
    }

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
      maybeForceBuilderInitialization();
    }

    private void maybeForceBuilderInitialization() {
      if (com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders) {
        getMetricsFieldBuilder();
        getParametersFieldBuilder();
      }
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      if (metricsBuilder_ == null) {
        metrics_ = java.util.Collections.emptyList();
        bitField0_ = (bitField0_ & ~0x00000001);
      } else {
        metricsBuilder_.clear();
      }
      if (parametersBuilder_ == null) {
        parameters_ = java.util.Collections.emptyList();
        bitField0_ = (bitField0_ & ~0x00000002);
      } else {
        parametersBuilder_.clear();
      }
      algorithm_ = 0;

      observationNoise_ = 0;

      measurementSelectionType_ = 0;

      automatedStoppingSpecCase_ = 0;
      automatedStoppingSpec_ = null;
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.cloud.aiplatform.v1beta1.StudyProto
          .internal_static_google_cloud_aiplatform_v1beta1_StudySpec_descriptor;
    }

    @java.lang.Override
    public com.google.cloud.aiplatform.v1beta1.StudySpec getDefaultInstanceForType() {
      return com.google.cloud.aiplatform.v1beta1.StudySpec.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.cloud.aiplatform.v1beta1.StudySpec build() {
      com.google.cloud.aiplatform.v1beta1.StudySpec result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.cloud.aiplatform.v1beta1.StudySpec buildPartial() {
      com.google.cloud.aiplatform.v1beta1.StudySpec result =
          new com.google.cloud.aiplatform.v1beta1.StudySpec(this);
      int from_bitField0_ = bitField0_;
      if (automatedStoppingSpecCase_ == 4) {
        if (decayCurveStoppingSpecBuilder_ == null) {
          result.automatedStoppingSpec_ = automatedStoppingSpec_;
        } else {
          result.automatedStoppingSpec_ = decayCurveStoppingSpecBuilder_.build();
        }
      }
      if (automatedStoppingSpecCase_ == 5) {
        if (medianAutomatedStoppingSpecBuilder_ == null) {
          result.automatedStoppingSpec_ = automatedStoppingSpec_;
        } else {
          result.automatedStoppingSpec_ = medianAutomatedStoppingSpecBuilder_.build();
        }
      }
      if (automatedStoppingSpecCase_ == 8) {
        if (convexStopConfigBuilder_ == null) {
          result.automatedStoppingSpec_ = automatedStoppingSpec_;
        } else {
          result.automatedStoppingSpec_ = convexStopConfigBuilder_.build();
        }
      }
      if (metricsBuilder_ == null) {
        if (((bitField0_ & 0x00000001) != 0)) {
          metrics_ = java.util.Collections.unmodifiableList(metrics_);
          bitField0_ = (bitField0_ & ~0x00000001);
        }
        result.metrics_ = metrics_;
      } else {
        result.metrics_ = metricsBuilder_.build();
      }
      if (parametersBuilder_ == null) {
        if (((bitField0_ & 0x00000002) != 0)) {
          parameters_ = java.util.Collections.unmodifiableList(parameters_);
          bitField0_ = (bitField0_ & ~0x00000002);
        }
        result.parameters_ = parameters_;
      } else {
        result.parameters_ = parametersBuilder_.build();
      }
      result.algorithm_ = algorithm_;
      result.observationNoise_ = observationNoise_;
      result.measurementSelectionType_ = measurementSelectionType_;
      result.automatedStoppingSpecCase_ = automatedStoppingSpecCase_;
      onBuilt();
      return result;
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.cloud.aiplatform.v1beta1.StudySpec) {
        return mergeFrom((com.google.cloud.aiplatform.v1beta1.StudySpec) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(com.google.cloud.aiplatform.v1beta1.StudySpec other) {
      if (other == com.google.cloud.aiplatform.v1beta1.StudySpec.getDefaultInstance()) return this;
      if (metricsBuilder_ == null) {
        if (!other.metrics_.isEmpty()) {
          if (metrics_.isEmpty()) {
            metrics_ = other.metrics_;
            bitField0_ = (bitField0_ & ~0x00000001);
          } else {
            ensureMetricsIsMutable();
            metrics_.addAll(other.metrics_);
          }
          onChanged();
        }
      } else {
        if (!other.metrics_.isEmpty()) {
          if (metricsBuilder_.isEmpty()) {
            metricsBuilder_.dispose();
            metricsBuilder_ = null;
            metrics_ = other.metrics_;
            bitField0_ = (bitField0_ & ~0x00000001);
            metricsBuilder_ =
                com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders
                    ? getMetricsFieldBuilder()
                    : null;
          } else {
            metricsBuilder_.addAllMessages(other.metrics_);
          }
        }
      }
      if (parametersBuilder_ == null) {
        if (!other.parameters_.isEmpty()) {
          if (parameters_.isEmpty()) {
            parameters_ = other.parameters_;
            bitField0_ = (bitField0_ & ~0x00000002);
          } else {
            ensureParametersIsMutable();
            parameters_.addAll(other.parameters_);
          }
          onChanged();
        }
      } else {
        if (!other.parameters_.isEmpty()) {
          if (parametersBuilder_.isEmpty()) {
            parametersBuilder_.dispose();
            parametersBuilder_ = null;
            parameters_ = other.parameters_;
            bitField0_ = (bitField0_ & ~0x00000002);
            parametersBuilder_ =
                com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders
                    ? getParametersFieldBuilder()
                    : null;
          } else {
            parametersBuilder_.addAllMessages(other.parameters_);
          }
        }
      }
      if (other.algorithm_ != 0) {
        setAlgorithmValue(other.getAlgorithmValue());
      }
      if (other.observationNoise_ != 0) {
        setObservationNoiseValue(other.getObservationNoiseValue());
      }
      if (other.measurementSelectionType_ != 0) {
        setMeasurementSelectionTypeValue(other.getMeasurementSelectionTypeValue());
      }
      switch (other.getAutomatedStoppingSpecCase()) {
        case DECAY_CURVE_STOPPING_SPEC:
          {
            mergeDecayCurveStoppingSpec(other.getDecayCurveStoppingSpec());
            break;
          }
        case MEDIAN_AUTOMATED_STOPPING_SPEC:
          {
            mergeMedianAutomatedStoppingSpec(other.getMedianAutomatedStoppingSpec());
            break;
          }
        case CONVEX_STOP_CONFIG:
          {
            mergeConvexStopConfig(other.getConvexStopConfig());
            break;
          }
        case AUTOMATEDSTOPPINGSPEC_NOT_SET:
          {
            break;
          }
      }
      this.mergeUnknownFields(other.unknownFields);
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      com.google.cloud.aiplatform.v1beta1.StudySpec parsedMessage = null;
      try {
        parsedMessage = PARSER.parsePartialFrom(input, extensionRegistry);
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        parsedMessage = (com.google.cloud.aiplatform.v1beta1.StudySpec) e.getUnfinishedMessage();
        throw e.unwrapIOException();
      } finally {
        if (parsedMessage != null) {
          mergeFrom(parsedMessage);
        }
      }
      return this;
    }

    private int automatedStoppingSpecCase_ = 0;
    private java.lang.Object automatedStoppingSpec_;

    public AutomatedStoppingSpecCase getAutomatedStoppingSpecCase() {
      return AutomatedStoppingSpecCase.forNumber(automatedStoppingSpecCase_);
    }

    public Builder clearAutomatedStoppingSpec() {
      automatedStoppingSpecCase_ = 0;
      automatedStoppingSpec_ = null;
      onChanged();
      return this;
    }

    private int bitField0_;

    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.aiplatform.v1beta1.StudySpec.DecayCurveAutomatedStoppingSpec,
            com.google.cloud.aiplatform.v1beta1.StudySpec.DecayCurveAutomatedStoppingSpec.Builder,
            com.google.cloud.aiplatform.v1beta1.StudySpec.DecayCurveAutomatedStoppingSpecOrBuilder>
        decayCurveStoppingSpecBuilder_;
    /**
     *
     *
     * <pre>
     * The automated early stopping spec using decay curve rule.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.StudySpec.DecayCurveAutomatedStoppingSpec decay_curve_stopping_spec = 4;
     * </code>
     *
     * @return Whether the decayCurveStoppingSpec field is set.
     */
    @java.lang.Override
    public boolean hasDecayCurveStoppingSpec() {
      return automatedStoppingSpecCase_ == 4;
    }
    /**
     *
     *
     * <pre>
     * The automated early stopping spec using decay curve rule.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.StudySpec.DecayCurveAutomatedStoppingSpec decay_curve_stopping_spec = 4;
     * </code>
     *
     * @return The decayCurveStoppingSpec.
     */
    @java.lang.Override
    public com.google.cloud.aiplatform.v1beta1.StudySpec.DecayCurveAutomatedStoppingSpec
        getDecayCurveStoppingSpec() {
      if (decayCurveStoppingSpecBuilder_ == null) {
        if (automatedStoppingSpecCase_ == 4) {
          return (com.google.cloud.aiplatform.v1beta1.StudySpec.DecayCurveAutomatedStoppingSpec)
              automatedStoppingSpec_;
        }
        return com.google.cloud.aiplatform.v1beta1.StudySpec.DecayCurveAutomatedStoppingSpec
            .getDefaultInstance();
      } else {
        if (automatedStoppingSpecCase_ == 4) {
          return decayCurveStoppingSpecBuilder_.getMessage();
        }
        return com.google.cloud.aiplatform.v1beta1.StudySpec.DecayCurveAutomatedStoppingSpec
            .getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * The automated early stopping spec using decay curve rule.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.StudySpec.DecayCurveAutomatedStoppingSpec decay_curve_stopping_spec = 4;
     * </code>
     */
    public Builder setDecayCurveStoppingSpec(
        com.google.cloud.aiplatform.v1beta1.StudySpec.DecayCurveAutomatedStoppingSpec value) {
      if (decayCurveStoppingSpecBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        automatedStoppingSpec_ = value;
        onChanged();
      } else {
        decayCurveStoppingSpecBuilder_.setMessage(value);
      }
      automatedStoppingSpecCase_ = 4;
      return this;
    }
    /**
     *
     *
     * <pre>
     * The automated early stopping spec using decay curve rule.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.StudySpec.DecayCurveAutomatedStoppingSpec decay_curve_stopping_spec = 4;
     * </code>
     */
    public Builder setDecayCurveStoppingSpec(
        com.google.cloud.aiplatform.v1beta1.StudySpec.DecayCurveAutomatedStoppingSpec.Builder
            builderForValue) {
      if (decayCurveStoppingSpecBuilder_ == null) {
        automatedStoppingSpec_ = builderForValue.build();
        onChanged();
      } else {
        decayCurveStoppingSpecBuilder_.setMessage(builderForValue.build());
      }
      automatedStoppingSpecCase_ = 4;
      return this;
    }
    /**
     *
     *
     * <pre>
     * The automated early stopping spec using decay curve rule.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.StudySpec.DecayCurveAutomatedStoppingSpec decay_curve_stopping_spec = 4;
     * </code>
     */
    public Builder mergeDecayCurveStoppingSpec(
        com.google.cloud.aiplatform.v1beta1.StudySpec.DecayCurveAutomatedStoppingSpec value) {
      if (decayCurveStoppingSpecBuilder_ == null) {
        if (automatedStoppingSpecCase_ == 4
            && automatedStoppingSpec_
                != com.google.cloud.aiplatform.v1beta1.StudySpec.DecayCurveAutomatedStoppingSpec
                    .getDefaultInstance()) {
          automatedStoppingSpec_ =
              com.google.cloud.aiplatform.v1beta1.StudySpec.DecayCurveAutomatedStoppingSpec
                  .newBuilder(
                      (com.google.cloud.aiplatform.v1beta1.StudySpec
                              .DecayCurveAutomatedStoppingSpec)
                          automatedStoppingSpec_)
                  .mergeFrom(value)
                  .buildPartial();
        } else {
          automatedStoppingSpec_ = value;
        }
        onChanged();
      } else {
        if (automatedStoppingSpecCase_ == 4) {
          decayCurveStoppingSpecBuilder_.mergeFrom(value);
        }
        decayCurveStoppingSpecBuilder_.setMessage(value);
      }
      automatedStoppingSpecCase_ = 4;
      return this;
    }
    /**
     *
     *
     * <pre>
     * The automated early stopping spec using decay curve rule.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.StudySpec.DecayCurveAutomatedStoppingSpec decay_curve_stopping_spec = 4;
     * </code>
     */
    public Builder clearDecayCurveStoppingSpec() {
      if (decayCurveStoppingSpecBuilder_ == null) {
        if (automatedStoppingSpecCase_ == 4) {
          automatedStoppingSpecCase_ = 0;
          automatedStoppingSpec_ = null;
          onChanged();
        }
      } else {
        if (automatedStoppingSpecCase_ == 4) {
          automatedStoppingSpecCase_ = 0;
          automatedStoppingSpec_ = null;
        }
        decayCurveStoppingSpecBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * The automated early stopping spec using decay curve rule.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.StudySpec.DecayCurveAutomatedStoppingSpec decay_curve_stopping_spec = 4;
     * </code>
     */
    public com.google.cloud.aiplatform.v1beta1.StudySpec.DecayCurveAutomatedStoppingSpec.Builder
        getDecayCurveStoppingSpecBuilder() {
      return getDecayCurveStoppingSpecFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * The automated early stopping spec using decay curve rule.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.StudySpec.DecayCurveAutomatedStoppingSpec decay_curve_stopping_spec = 4;
     * </code>
     */
    @java.lang.Override
    public com.google.cloud.aiplatform.v1beta1.StudySpec.DecayCurveAutomatedStoppingSpecOrBuilder
        getDecayCurveStoppingSpecOrBuilder() {
      if ((automatedStoppingSpecCase_ == 4) && (decayCurveStoppingSpecBuilder_ != null)) {
        return decayCurveStoppingSpecBuilder_.getMessageOrBuilder();
      } else {
        if (automatedStoppingSpecCase_ == 4) {
          return (com.google.cloud.aiplatform.v1beta1.StudySpec.DecayCurveAutomatedStoppingSpec)
              automatedStoppingSpec_;
        }
        return com.google.cloud.aiplatform.v1beta1.StudySpec.DecayCurveAutomatedStoppingSpec
            .getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * The automated early stopping spec using decay curve rule.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.StudySpec.DecayCurveAutomatedStoppingSpec decay_curve_stopping_spec = 4;
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.aiplatform.v1beta1.StudySpec.DecayCurveAutomatedStoppingSpec,
            com.google.cloud.aiplatform.v1beta1.StudySpec.DecayCurveAutomatedStoppingSpec.Builder,
            com.google.cloud.aiplatform.v1beta1.StudySpec.DecayCurveAutomatedStoppingSpecOrBuilder>
        getDecayCurveStoppingSpecFieldBuilder() {
      if (decayCurveStoppingSpecBuilder_ == null) {
        if (!(automatedStoppingSpecCase_ == 4)) {
          automatedStoppingSpec_ =
              com.google.cloud.aiplatform.v1beta1.StudySpec.DecayCurveAutomatedStoppingSpec
                  .getDefaultInstance();
        }
        decayCurveStoppingSpecBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.aiplatform.v1beta1.StudySpec.DecayCurveAutomatedStoppingSpec,
                com.google.cloud.aiplatform.v1beta1.StudySpec.DecayCurveAutomatedStoppingSpec
                    .Builder,
                com.google.cloud.aiplatform.v1beta1.StudySpec
                    .DecayCurveAutomatedStoppingSpecOrBuilder>(
                (com.google.cloud.aiplatform.v1beta1.StudySpec.DecayCurveAutomatedStoppingSpec)
                    automatedStoppingSpec_,
                getParentForChildren(),
                isClean());
        automatedStoppingSpec_ = null;
      }
      automatedStoppingSpecCase_ = 4;
      onChanged();
      ;
      return decayCurveStoppingSpecBuilder_;
    }

    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.aiplatform.v1beta1.StudySpec.MedianAutomatedStoppingSpec,
            com.google.cloud.aiplatform.v1beta1.StudySpec.MedianAutomatedStoppingSpec.Builder,
            com.google.cloud.aiplatform.v1beta1.StudySpec.MedianAutomatedStoppingSpecOrBuilder>
        medianAutomatedStoppingSpecBuilder_;
    /**
     *
     *
     * <pre>
     * The automated early stopping spec using median rule.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.StudySpec.MedianAutomatedStoppingSpec median_automated_stopping_spec = 5;
     * </code>
     *
     * @return Whether the medianAutomatedStoppingSpec field is set.
     */
    @java.lang.Override
    public boolean hasMedianAutomatedStoppingSpec() {
      return automatedStoppingSpecCase_ == 5;
    }
    /**
     *
     *
     * <pre>
     * The automated early stopping spec using median rule.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.StudySpec.MedianAutomatedStoppingSpec median_automated_stopping_spec = 5;
     * </code>
     *
     * @return The medianAutomatedStoppingSpec.
     */
    @java.lang.Override
    public com.google.cloud.aiplatform.v1beta1.StudySpec.MedianAutomatedStoppingSpec
        getMedianAutomatedStoppingSpec() {
      if (medianAutomatedStoppingSpecBuilder_ == null) {
        if (automatedStoppingSpecCase_ == 5) {
          return (com.google.cloud.aiplatform.v1beta1.StudySpec.MedianAutomatedStoppingSpec)
              automatedStoppingSpec_;
        }
        return com.google.cloud.aiplatform.v1beta1.StudySpec.MedianAutomatedStoppingSpec
            .getDefaultInstance();
      } else {
        if (automatedStoppingSpecCase_ == 5) {
          return medianAutomatedStoppingSpecBuilder_.getMessage();
        }
        return com.google.cloud.aiplatform.v1beta1.StudySpec.MedianAutomatedStoppingSpec
            .getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * The automated early stopping spec using median rule.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.StudySpec.MedianAutomatedStoppingSpec median_automated_stopping_spec = 5;
     * </code>
     */
    public Builder setMedianAutomatedStoppingSpec(
        com.google.cloud.aiplatform.v1beta1.StudySpec.MedianAutomatedStoppingSpec value) {
      if (medianAutomatedStoppingSpecBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        automatedStoppingSpec_ = value;
        onChanged();
      } else {
        medianAutomatedStoppingSpecBuilder_.setMessage(value);
      }
      automatedStoppingSpecCase_ = 5;
      return this;
    }
    /**
     *
     *
     * <pre>
     * The automated early stopping spec using median rule.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.StudySpec.MedianAutomatedStoppingSpec median_automated_stopping_spec = 5;
     * </code>
     */
    public Builder setMedianAutomatedStoppingSpec(
        com.google.cloud.aiplatform.v1beta1.StudySpec.MedianAutomatedStoppingSpec.Builder
            builderForValue) {
      if (medianAutomatedStoppingSpecBuilder_ == null) {
        automatedStoppingSpec_ = builderForValue.build();
        onChanged();
      } else {
        medianAutomatedStoppingSpecBuilder_.setMessage(builderForValue.build());
      }
      automatedStoppingSpecCase_ = 5;
      return this;
    }
    /**
     *
     *
     * <pre>
     * The automated early stopping spec using median rule.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.StudySpec.MedianAutomatedStoppingSpec median_automated_stopping_spec = 5;
     * </code>
     */
    public Builder mergeMedianAutomatedStoppingSpec(
        com.google.cloud.aiplatform.v1beta1.StudySpec.MedianAutomatedStoppingSpec value) {
      if (medianAutomatedStoppingSpecBuilder_ == null) {
        if (automatedStoppingSpecCase_ == 5
            && automatedStoppingSpec_
                != com.google.cloud.aiplatform.v1beta1.StudySpec.MedianAutomatedStoppingSpec
                    .getDefaultInstance()) {
          automatedStoppingSpec_ =
              com.google.cloud.aiplatform.v1beta1.StudySpec.MedianAutomatedStoppingSpec.newBuilder(
                      (com.google.cloud.aiplatform.v1beta1.StudySpec.MedianAutomatedStoppingSpec)
                          automatedStoppingSpec_)
                  .mergeFrom(value)
                  .buildPartial();
        } else {
          automatedStoppingSpec_ = value;
        }
        onChanged();
      } else {
        if (automatedStoppingSpecCase_ == 5) {
          medianAutomatedStoppingSpecBuilder_.mergeFrom(value);
        }
        medianAutomatedStoppingSpecBuilder_.setMessage(value);
      }
      automatedStoppingSpecCase_ = 5;
      return this;
    }
    /**
     *
     *
     * <pre>
     * The automated early stopping spec using median rule.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.StudySpec.MedianAutomatedStoppingSpec median_automated_stopping_spec = 5;
     * </code>
     */
    public Builder clearMedianAutomatedStoppingSpec() {
      if (medianAutomatedStoppingSpecBuilder_ == null) {
        if (automatedStoppingSpecCase_ == 5) {
          automatedStoppingSpecCase_ = 0;
          automatedStoppingSpec_ = null;
          onChanged();
        }
      } else {
        if (automatedStoppingSpecCase_ == 5) {
          automatedStoppingSpecCase_ = 0;
          automatedStoppingSpec_ = null;
        }
        medianAutomatedStoppingSpecBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * The automated early stopping spec using median rule.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.StudySpec.MedianAutomatedStoppingSpec median_automated_stopping_spec = 5;
     * </code>
     */
    public com.google.cloud.aiplatform.v1beta1.StudySpec.MedianAutomatedStoppingSpec.Builder
        getMedianAutomatedStoppingSpecBuilder() {
      return getMedianAutomatedStoppingSpecFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * The automated early stopping spec using median rule.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.StudySpec.MedianAutomatedStoppingSpec median_automated_stopping_spec = 5;
     * </code>
     */
    @java.lang.Override
    public com.google.cloud.aiplatform.v1beta1.StudySpec.MedianAutomatedStoppingSpecOrBuilder
        getMedianAutomatedStoppingSpecOrBuilder() {
      if ((automatedStoppingSpecCase_ == 5) && (medianAutomatedStoppingSpecBuilder_ != null)) {
        return medianAutomatedStoppingSpecBuilder_.getMessageOrBuilder();
      } else {
        if (automatedStoppingSpecCase_ == 5) {
          return (com.google.cloud.aiplatform.v1beta1.StudySpec.MedianAutomatedStoppingSpec)
              automatedStoppingSpec_;
        }
        return com.google.cloud.aiplatform.v1beta1.StudySpec.MedianAutomatedStoppingSpec
            .getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * The automated early stopping spec using median rule.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.StudySpec.MedianAutomatedStoppingSpec median_automated_stopping_spec = 5;
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.aiplatform.v1beta1.StudySpec.MedianAutomatedStoppingSpec,
            com.google.cloud.aiplatform.v1beta1.StudySpec.MedianAutomatedStoppingSpec.Builder,
            com.google.cloud.aiplatform.v1beta1.StudySpec.MedianAutomatedStoppingSpecOrBuilder>
        getMedianAutomatedStoppingSpecFieldBuilder() {
      if (medianAutomatedStoppingSpecBuilder_ == null) {
        if (!(automatedStoppingSpecCase_ == 5)) {
          automatedStoppingSpec_ =
              com.google.cloud.aiplatform.v1beta1.StudySpec.MedianAutomatedStoppingSpec
                  .getDefaultInstance();
        }
        medianAutomatedStoppingSpecBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.aiplatform.v1beta1.StudySpec.MedianAutomatedStoppingSpec,
                com.google.cloud.aiplatform.v1beta1.StudySpec.MedianAutomatedStoppingSpec.Builder,
                com.google.cloud.aiplatform.v1beta1.StudySpec.MedianAutomatedStoppingSpecOrBuilder>(
                (com.google.cloud.aiplatform.v1beta1.StudySpec.MedianAutomatedStoppingSpec)
                    automatedStoppingSpec_,
                getParentForChildren(),
                isClean());
        automatedStoppingSpec_ = null;
      }
      automatedStoppingSpecCase_ = 5;
      onChanged();
      ;
      return medianAutomatedStoppingSpecBuilder_;
    }

    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.aiplatform.v1beta1.StudySpec.ConvexStopConfig,
            com.google.cloud.aiplatform.v1beta1.StudySpec.ConvexStopConfig.Builder,
            com.google.cloud.aiplatform.v1beta1.StudySpec.ConvexStopConfigOrBuilder>
        convexStopConfigBuilder_;
    /**
     *
     *
     * <pre>
     * Deprecated.
     * The automated early stopping using convex stopping rule.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.StudySpec.ConvexStopConfig convex_stop_config = 8 [deprecated = true];
     * </code>
     *
     * @return Whether the convexStopConfig field is set.
     */
    @java.lang.Override
    @java.lang.Deprecated
    public boolean hasConvexStopConfig() {
      return automatedStoppingSpecCase_ == 8;
    }
    /**
     *
     *
     * <pre>
     * Deprecated.
     * The automated early stopping using convex stopping rule.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.StudySpec.ConvexStopConfig convex_stop_config = 8 [deprecated = true];
     * </code>
     *
     * @return The convexStopConfig.
     */
    @java.lang.Override
    @java.lang.Deprecated
    public com.google.cloud.aiplatform.v1beta1.StudySpec.ConvexStopConfig getConvexStopConfig() {
      if (convexStopConfigBuilder_ == null) {
        if (automatedStoppingSpecCase_ == 8) {
          return (com.google.cloud.aiplatform.v1beta1.StudySpec.ConvexStopConfig)
              automatedStoppingSpec_;
        }
        return com.google.cloud.aiplatform.v1beta1.StudySpec.ConvexStopConfig.getDefaultInstance();
      } else {
        if (automatedStoppingSpecCase_ == 8) {
          return convexStopConfigBuilder_.getMessage();
        }
        return com.google.cloud.aiplatform.v1beta1.StudySpec.ConvexStopConfig.getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * Deprecated.
     * The automated early stopping using convex stopping rule.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.StudySpec.ConvexStopConfig convex_stop_config = 8 [deprecated = true];
     * </code>
     */
    @java.lang.Deprecated
    public Builder setConvexStopConfig(
        com.google.cloud.aiplatform.v1beta1.StudySpec.ConvexStopConfig value) {
      if (convexStopConfigBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        automatedStoppingSpec_ = value;
        onChanged();
      } else {
        convexStopConfigBuilder_.setMessage(value);
      }
      automatedStoppingSpecCase_ = 8;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Deprecated.
     * The automated early stopping using convex stopping rule.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.StudySpec.ConvexStopConfig convex_stop_config = 8 [deprecated = true];
     * </code>
     */
    @java.lang.Deprecated
    public Builder setConvexStopConfig(
        com.google.cloud.aiplatform.v1beta1.StudySpec.ConvexStopConfig.Builder builderForValue) {
      if (convexStopConfigBuilder_ == null) {
        automatedStoppingSpec_ = builderForValue.build();
        onChanged();
      } else {
        convexStopConfigBuilder_.setMessage(builderForValue.build());
      }
      automatedStoppingSpecCase_ = 8;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Deprecated.
     * The automated early stopping using convex stopping rule.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.StudySpec.ConvexStopConfig convex_stop_config = 8 [deprecated = true];
     * </code>
     */
    @java.lang.Deprecated
    public Builder mergeConvexStopConfig(
        com.google.cloud.aiplatform.v1beta1.StudySpec.ConvexStopConfig value) {
      if (convexStopConfigBuilder_ == null) {
        if (automatedStoppingSpecCase_ == 8
            && automatedStoppingSpec_
                != com.google.cloud.aiplatform.v1beta1.StudySpec.ConvexStopConfig
                    .getDefaultInstance()) {
          automatedStoppingSpec_ =
              com.google.cloud.aiplatform.v1beta1.StudySpec.ConvexStopConfig.newBuilder(
                      (com.google.cloud.aiplatform.v1beta1.StudySpec.ConvexStopConfig)
                          automatedStoppingSpec_)
                  .mergeFrom(value)
                  .buildPartial();
        } else {
          automatedStoppingSpec_ = value;
        }
        onChanged();
      } else {
        if (automatedStoppingSpecCase_ == 8) {
          convexStopConfigBuilder_.mergeFrom(value);
        }
        convexStopConfigBuilder_.setMessage(value);
      }
      automatedStoppingSpecCase_ = 8;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Deprecated.
     * The automated early stopping using convex stopping rule.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.StudySpec.ConvexStopConfig convex_stop_config = 8 [deprecated = true];
     * </code>
     */
    @java.lang.Deprecated
    public Builder clearConvexStopConfig() {
      if (convexStopConfigBuilder_ == null) {
        if (automatedStoppingSpecCase_ == 8) {
          automatedStoppingSpecCase_ = 0;
          automatedStoppingSpec_ = null;
          onChanged();
        }
      } else {
        if (automatedStoppingSpecCase_ == 8) {
          automatedStoppingSpecCase_ = 0;
          automatedStoppingSpec_ = null;
        }
        convexStopConfigBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Deprecated.
     * The automated early stopping using convex stopping rule.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.StudySpec.ConvexStopConfig convex_stop_config = 8 [deprecated = true];
     * </code>
     */
    @java.lang.Deprecated
    public com.google.cloud.aiplatform.v1beta1.StudySpec.ConvexStopConfig.Builder
        getConvexStopConfigBuilder() {
      return getConvexStopConfigFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Deprecated.
     * The automated early stopping using convex stopping rule.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.StudySpec.ConvexStopConfig convex_stop_config = 8 [deprecated = true];
     * </code>
     */
    @java.lang.Override
    @java.lang.Deprecated
    public com.google.cloud.aiplatform.v1beta1.StudySpec.ConvexStopConfigOrBuilder
        getConvexStopConfigOrBuilder() {
      if ((automatedStoppingSpecCase_ == 8) && (convexStopConfigBuilder_ != null)) {
        return convexStopConfigBuilder_.getMessageOrBuilder();
      } else {
        if (automatedStoppingSpecCase_ == 8) {
          return (com.google.cloud.aiplatform.v1beta1.StudySpec.ConvexStopConfig)
              automatedStoppingSpec_;
        }
        return com.google.cloud.aiplatform.v1beta1.StudySpec.ConvexStopConfig.getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * Deprecated.
     * The automated early stopping using convex stopping rule.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.StudySpec.ConvexStopConfig convex_stop_config = 8 [deprecated = true];
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.aiplatform.v1beta1.StudySpec.ConvexStopConfig,
            com.google.cloud.aiplatform.v1beta1.StudySpec.ConvexStopConfig.Builder,
            com.google.cloud.aiplatform.v1beta1.StudySpec.ConvexStopConfigOrBuilder>
        getConvexStopConfigFieldBuilder() {
      if (convexStopConfigBuilder_ == null) {
        if (!(automatedStoppingSpecCase_ == 8)) {
          automatedStoppingSpec_ =
              com.google.cloud.aiplatform.v1beta1.StudySpec.ConvexStopConfig.getDefaultInstance();
        }
        convexStopConfigBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.aiplatform.v1beta1.StudySpec.ConvexStopConfig,
                com.google.cloud.aiplatform.v1beta1.StudySpec.ConvexStopConfig.Builder,
                com.google.cloud.aiplatform.v1beta1.StudySpec.ConvexStopConfigOrBuilder>(
                (com.google.cloud.aiplatform.v1beta1.StudySpec.ConvexStopConfig)
                    automatedStoppingSpec_,
                getParentForChildren(),
                isClean());
        automatedStoppingSpec_ = null;
      }
      automatedStoppingSpecCase_ = 8;
      onChanged();
      ;
      return convexStopConfigBuilder_;
    }

    private java.util.List<com.google.cloud.aiplatform.v1beta1.StudySpec.MetricSpec> metrics_ =
        java.util.Collections.emptyList();

    private void ensureMetricsIsMutable() {
      if (!((bitField0_ & 0x00000001) != 0)) {
        metrics_ =
            new java.util.ArrayList<com.google.cloud.aiplatform.v1beta1.StudySpec.MetricSpec>(
                metrics_);
        bitField0_ |= 0x00000001;
      }
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.cloud.aiplatform.v1beta1.StudySpec.MetricSpec,
            com.google.cloud.aiplatform.v1beta1.StudySpec.MetricSpec.Builder,
            com.google.cloud.aiplatform.v1beta1.StudySpec.MetricSpecOrBuilder>
        metricsBuilder_;

    /**
     *
     *
     * <pre>
     * Required. Metric specs for the Study.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.aiplatform.v1beta1.StudySpec.MetricSpec metrics = 1 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public java.util.List<com.google.cloud.aiplatform.v1beta1.StudySpec.MetricSpec>
        getMetricsList() {
      if (metricsBuilder_ == null) {
        return java.util.Collections.unmodifiableList(metrics_);
      } else {
        return metricsBuilder_.getMessageList();
      }
    }
    /**
     *
     *
     * <pre>
     * Required. Metric specs for the Study.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.aiplatform.v1beta1.StudySpec.MetricSpec metrics = 1 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public int getMetricsCount() {
      if (metricsBuilder_ == null) {
        return metrics_.size();
      } else {
        return metricsBuilder_.getCount();
      }
    }
    /**
     *
     *
     * <pre>
     * Required. Metric specs for the Study.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.aiplatform.v1beta1.StudySpec.MetricSpec metrics = 1 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public com.google.cloud.aiplatform.v1beta1.StudySpec.MetricSpec getMetrics(int index) {
      if (metricsBuilder_ == null) {
        return metrics_.get(index);
      } else {
        return metricsBuilder_.getMessage(index);
      }
    }
    /**
     *
     *
     * <pre>
     * Required. Metric specs for the Study.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.aiplatform.v1beta1.StudySpec.MetricSpec metrics = 1 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public Builder setMetrics(
        int index, com.google.cloud.aiplatform.v1beta1.StudySpec.MetricSpec value) {
      if (metricsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureMetricsIsMutable();
        metrics_.set(index, value);
        onChanged();
      } else {
        metricsBuilder_.setMessage(index, value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. Metric specs for the Study.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.aiplatform.v1beta1.StudySpec.MetricSpec metrics = 1 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public Builder setMetrics(
        int index,
        com.google.cloud.aiplatform.v1beta1.StudySpec.MetricSpec.Builder builderForValue) {
      if (metricsBuilder_ == null) {
        ensureMetricsIsMutable();
        metrics_.set(index, builderForValue.build());
        onChanged();
      } else {
        metricsBuilder_.setMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. Metric specs for the Study.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.aiplatform.v1beta1.StudySpec.MetricSpec metrics = 1 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public Builder addMetrics(com.google.cloud.aiplatform.v1beta1.StudySpec.MetricSpec value) {
      if (metricsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureMetricsIsMutable();
        metrics_.add(value);
        onChanged();
      } else {
        metricsBuilder_.addMessage(value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. Metric specs for the Study.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.aiplatform.v1beta1.StudySpec.MetricSpec metrics = 1 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public Builder addMetrics(
        int index, com.google.cloud.aiplatform.v1beta1.StudySpec.MetricSpec value) {
      if (metricsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureMetricsIsMutable();
        metrics_.add(index, value);
        onChanged();
      } else {
        metricsBuilder_.addMessage(index, value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. Metric specs for the Study.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.aiplatform.v1beta1.StudySpec.MetricSpec metrics = 1 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public Builder addMetrics(
        com.google.cloud.aiplatform.v1beta1.StudySpec.MetricSpec.Builder builderForValue) {
      if (metricsBuilder_ == null) {
        ensureMetricsIsMutable();
        metrics_.add(builderForValue.build());
        onChanged();
      } else {
        metricsBuilder_.addMessage(builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. Metric specs for the Study.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.aiplatform.v1beta1.StudySpec.MetricSpec metrics = 1 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public Builder addMetrics(
        int index,
        com.google.cloud.aiplatform.v1beta1.StudySpec.MetricSpec.Builder builderForValue) {
      if (metricsBuilder_ == null) {
        ensureMetricsIsMutable();
        metrics_.add(index, builderForValue.build());
        onChanged();
      } else {
        metricsBuilder_.addMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. Metric specs for the Study.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.aiplatform.v1beta1.StudySpec.MetricSpec metrics = 1 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public Builder addAllMetrics(
        java.lang.Iterable<? extends com.google.cloud.aiplatform.v1beta1.StudySpec.MetricSpec>
            values) {
      if (metricsBuilder_ == null) {
        ensureMetricsIsMutable();
        com.google.protobuf.AbstractMessageLite.Builder.addAll(values, metrics_);
        onChanged();
      } else {
        metricsBuilder_.addAllMessages(values);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. Metric specs for the Study.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.aiplatform.v1beta1.StudySpec.MetricSpec metrics = 1 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public Builder clearMetrics() {
      if (metricsBuilder_ == null) {
        metrics_ = java.util.Collections.emptyList();
        bitField0_ = (bitField0_ & ~0x00000001);
        onChanged();
      } else {
        metricsBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. Metric specs for the Study.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.aiplatform.v1beta1.StudySpec.MetricSpec metrics = 1 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public Builder removeMetrics(int index) {
      if (metricsBuilder_ == null) {
        ensureMetricsIsMutable();
        metrics_.remove(index);
        onChanged();
      } else {
        metricsBuilder_.remove(index);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. Metric specs for the Study.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.aiplatform.v1beta1.StudySpec.MetricSpec metrics = 1 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public com.google.cloud.aiplatform.v1beta1.StudySpec.MetricSpec.Builder getMetricsBuilder(
        int index) {
      return getMetricsFieldBuilder().getBuilder(index);
    }
    /**
     *
     *
     * <pre>
     * Required. Metric specs for the Study.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.aiplatform.v1beta1.StudySpec.MetricSpec metrics = 1 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public com.google.cloud.aiplatform.v1beta1.StudySpec.MetricSpecOrBuilder getMetricsOrBuilder(
        int index) {
      if (metricsBuilder_ == null) {
        return metrics_.get(index);
      } else {
        return metricsBuilder_.getMessageOrBuilder(index);
      }
    }
    /**
     *
     *
     * <pre>
     * Required. Metric specs for the Study.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.aiplatform.v1beta1.StudySpec.MetricSpec metrics = 1 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public java.util.List<
            ? extends com.google.cloud.aiplatform.v1beta1.StudySpec.MetricSpecOrBuilder>
        getMetricsOrBuilderList() {
      if (metricsBuilder_ != null) {
        return metricsBuilder_.getMessageOrBuilderList();
      } else {
        return java.util.Collections.unmodifiableList(metrics_);
      }
    }
    /**
     *
     *
     * <pre>
     * Required. Metric specs for the Study.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.aiplatform.v1beta1.StudySpec.MetricSpec metrics = 1 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public com.google.cloud.aiplatform.v1beta1.StudySpec.MetricSpec.Builder addMetricsBuilder() {
      return getMetricsFieldBuilder()
          .addBuilder(
              com.google.cloud.aiplatform.v1beta1.StudySpec.MetricSpec.getDefaultInstance());
    }
    /**
     *
     *
     * <pre>
     * Required. Metric specs for the Study.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.aiplatform.v1beta1.StudySpec.MetricSpec metrics = 1 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public com.google.cloud.aiplatform.v1beta1.StudySpec.MetricSpec.Builder addMetricsBuilder(
        int index) {
      return getMetricsFieldBuilder()
          .addBuilder(
              index, com.google.cloud.aiplatform.v1beta1.StudySpec.MetricSpec.getDefaultInstance());
    }
    /**
     *
     *
     * <pre>
     * Required. Metric specs for the Study.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.aiplatform.v1beta1.StudySpec.MetricSpec metrics = 1 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public java.util.List<com.google.cloud.aiplatform.v1beta1.StudySpec.MetricSpec.Builder>
        getMetricsBuilderList() {
      return getMetricsFieldBuilder().getBuilderList();
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.cloud.aiplatform.v1beta1.StudySpec.MetricSpec,
            com.google.cloud.aiplatform.v1beta1.StudySpec.MetricSpec.Builder,
            com.google.cloud.aiplatform.v1beta1.StudySpec.MetricSpecOrBuilder>
        getMetricsFieldBuilder() {
      if (metricsBuilder_ == null) {
        metricsBuilder_ =
            new com.google.protobuf.RepeatedFieldBuilderV3<
                com.google.cloud.aiplatform.v1beta1.StudySpec.MetricSpec,
                com.google.cloud.aiplatform.v1beta1.StudySpec.MetricSpec.Builder,
                com.google.cloud.aiplatform.v1beta1.StudySpec.MetricSpecOrBuilder>(
                metrics_, ((bitField0_ & 0x00000001) != 0), getParentForChildren(), isClean());
        metrics_ = null;
      }
      return metricsBuilder_;
    }

    private java.util.List<com.google.cloud.aiplatform.v1beta1.StudySpec.ParameterSpec>
        parameters_ = java.util.Collections.emptyList();

    private void ensureParametersIsMutable() {
      if (!((bitField0_ & 0x00000002) != 0)) {
        parameters_ =
            new java.util.ArrayList<com.google.cloud.aiplatform.v1beta1.StudySpec.ParameterSpec>(
                parameters_);
        bitField0_ |= 0x00000002;
      }
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.cloud.aiplatform.v1beta1.StudySpec.ParameterSpec,
            com.google.cloud.aiplatform.v1beta1.StudySpec.ParameterSpec.Builder,
            com.google.cloud.aiplatform.v1beta1.StudySpec.ParameterSpecOrBuilder>
        parametersBuilder_;

    /**
     *
     *
     * <pre>
     * Required. The set of parameters to tune.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.aiplatform.v1beta1.StudySpec.ParameterSpec parameters = 2 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public java.util.List<com.google.cloud.aiplatform.v1beta1.StudySpec.ParameterSpec>
        getParametersList() {
      if (parametersBuilder_ == null) {
        return java.util.Collections.unmodifiableList(parameters_);
      } else {
        return parametersBuilder_.getMessageList();
      }
    }
    /**
     *
     *
     * <pre>
     * Required. The set of parameters to tune.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.aiplatform.v1beta1.StudySpec.ParameterSpec parameters = 2 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public int getParametersCount() {
      if (parametersBuilder_ == null) {
        return parameters_.size();
      } else {
        return parametersBuilder_.getCount();
      }
    }
    /**
     *
     *
     * <pre>
     * Required. The set of parameters to tune.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.aiplatform.v1beta1.StudySpec.ParameterSpec parameters = 2 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public com.google.cloud.aiplatform.v1beta1.StudySpec.ParameterSpec getParameters(int index) {
      if (parametersBuilder_ == null) {
        return parameters_.get(index);
      } else {
        return parametersBuilder_.getMessage(index);
      }
    }
    /**
     *
     *
     * <pre>
     * Required. The set of parameters to tune.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.aiplatform.v1beta1.StudySpec.ParameterSpec parameters = 2 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public Builder setParameters(
        int index, com.google.cloud.aiplatform.v1beta1.StudySpec.ParameterSpec value) {
      if (parametersBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureParametersIsMutable();
        parameters_.set(index, value);
        onChanged();
      } else {
        parametersBuilder_.setMessage(index, value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. The set of parameters to tune.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.aiplatform.v1beta1.StudySpec.ParameterSpec parameters = 2 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public Builder setParameters(
        int index,
        com.google.cloud.aiplatform.v1beta1.StudySpec.ParameterSpec.Builder builderForValue) {
      if (parametersBuilder_ == null) {
        ensureParametersIsMutable();
        parameters_.set(index, builderForValue.build());
        onChanged();
      } else {
        parametersBuilder_.setMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. The set of parameters to tune.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.aiplatform.v1beta1.StudySpec.ParameterSpec parameters = 2 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public Builder addParameters(
        com.google.cloud.aiplatform.v1beta1.StudySpec.ParameterSpec value) {
      if (parametersBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureParametersIsMutable();
        parameters_.add(value);
        onChanged();
      } else {
        parametersBuilder_.addMessage(value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. The set of parameters to tune.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.aiplatform.v1beta1.StudySpec.ParameterSpec parameters = 2 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public Builder addParameters(
        int index, com.google.cloud.aiplatform.v1beta1.StudySpec.ParameterSpec value) {
      if (parametersBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureParametersIsMutable();
        parameters_.add(index, value);
        onChanged();
      } else {
        parametersBuilder_.addMessage(index, value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. The set of parameters to tune.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.aiplatform.v1beta1.StudySpec.ParameterSpec parameters = 2 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public Builder addParameters(
        com.google.cloud.aiplatform.v1beta1.StudySpec.ParameterSpec.Builder builderForValue) {
      if (parametersBuilder_ == null) {
        ensureParametersIsMutable();
        parameters_.add(builderForValue.build());
        onChanged();
      } else {
        parametersBuilder_.addMessage(builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. The set of parameters to tune.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.aiplatform.v1beta1.StudySpec.ParameterSpec parameters = 2 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public Builder addParameters(
        int index,
        com.google.cloud.aiplatform.v1beta1.StudySpec.ParameterSpec.Builder builderForValue) {
      if (parametersBuilder_ == null) {
        ensureParametersIsMutable();
        parameters_.add(index, builderForValue.build());
        onChanged();
      } else {
        parametersBuilder_.addMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. The set of parameters to tune.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.aiplatform.v1beta1.StudySpec.ParameterSpec parameters = 2 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public Builder addAllParameters(
        java.lang.Iterable<? extends com.google.cloud.aiplatform.v1beta1.StudySpec.ParameterSpec>
            values) {
      if (parametersBuilder_ == null) {
        ensureParametersIsMutable();
        com.google.protobuf.AbstractMessageLite.Builder.addAll(values, parameters_);
        onChanged();
      } else {
        parametersBuilder_.addAllMessages(values);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. The set of parameters to tune.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.aiplatform.v1beta1.StudySpec.ParameterSpec parameters = 2 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public Builder clearParameters() {
      if (parametersBuilder_ == null) {
        parameters_ = java.util.Collections.emptyList();
        bitField0_ = (bitField0_ & ~0x00000002);
        onChanged();
      } else {
        parametersBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. The set of parameters to tune.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.aiplatform.v1beta1.StudySpec.ParameterSpec parameters = 2 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public Builder removeParameters(int index) {
      if (parametersBuilder_ == null) {
        ensureParametersIsMutable();
        parameters_.remove(index);
        onChanged();
      } else {
        parametersBuilder_.remove(index);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. The set of parameters to tune.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.aiplatform.v1beta1.StudySpec.ParameterSpec parameters = 2 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public com.google.cloud.aiplatform.v1beta1.StudySpec.ParameterSpec.Builder getParametersBuilder(
        int index) {
      return getParametersFieldBuilder().getBuilder(index);
    }
    /**
     *
     *
     * <pre>
     * Required. The set of parameters to tune.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.aiplatform.v1beta1.StudySpec.ParameterSpec parameters = 2 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public com.google.cloud.aiplatform.v1beta1.StudySpec.ParameterSpecOrBuilder
        getParametersOrBuilder(int index) {
      if (parametersBuilder_ == null) {
        return parameters_.get(index);
      } else {
        return parametersBuilder_.getMessageOrBuilder(index);
      }
    }
    /**
     *
     *
     * <pre>
     * Required. The set of parameters to tune.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.aiplatform.v1beta1.StudySpec.ParameterSpec parameters = 2 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public java.util.List<
            ? extends com.google.cloud.aiplatform.v1beta1.StudySpec.ParameterSpecOrBuilder>
        getParametersOrBuilderList() {
      if (parametersBuilder_ != null) {
        return parametersBuilder_.getMessageOrBuilderList();
      } else {
        return java.util.Collections.unmodifiableList(parameters_);
      }
    }
    /**
     *
     *
     * <pre>
     * Required. The set of parameters to tune.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.aiplatform.v1beta1.StudySpec.ParameterSpec parameters = 2 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public com.google.cloud.aiplatform.v1beta1.StudySpec.ParameterSpec.Builder
        addParametersBuilder() {
      return getParametersFieldBuilder()
          .addBuilder(
              com.google.cloud.aiplatform.v1beta1.StudySpec.ParameterSpec.getDefaultInstance());
    }
    /**
     *
     *
     * <pre>
     * Required. The set of parameters to tune.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.aiplatform.v1beta1.StudySpec.ParameterSpec parameters = 2 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public com.google.cloud.aiplatform.v1beta1.StudySpec.ParameterSpec.Builder addParametersBuilder(
        int index) {
      return getParametersFieldBuilder()
          .addBuilder(
              index,
              com.google.cloud.aiplatform.v1beta1.StudySpec.ParameterSpec.getDefaultInstance());
    }
    /**
     *
     *
     * <pre>
     * Required. The set of parameters to tune.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.aiplatform.v1beta1.StudySpec.ParameterSpec parameters = 2 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public java.util.List<com.google.cloud.aiplatform.v1beta1.StudySpec.ParameterSpec.Builder>
        getParametersBuilderList() {
      return getParametersFieldBuilder().getBuilderList();
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.cloud.aiplatform.v1beta1.StudySpec.ParameterSpec,
            com.google.cloud.aiplatform.v1beta1.StudySpec.ParameterSpec.Builder,
            com.google.cloud.aiplatform.v1beta1.StudySpec.ParameterSpecOrBuilder>
        getParametersFieldBuilder() {
      if (parametersBuilder_ == null) {
        parametersBuilder_ =
            new com.google.protobuf.RepeatedFieldBuilderV3<
                com.google.cloud.aiplatform.v1beta1.StudySpec.ParameterSpec,
                com.google.cloud.aiplatform.v1beta1.StudySpec.ParameterSpec.Builder,
                com.google.cloud.aiplatform.v1beta1.StudySpec.ParameterSpecOrBuilder>(
                parameters_, ((bitField0_ & 0x00000002) != 0), getParentForChildren(), isClean());
        parameters_ = null;
      }
      return parametersBuilder_;
    }

    private int algorithm_ = 0;
    /**
     *
     *
     * <pre>
     * The search algorithm specified for the Study.
     * </pre>
     *
     * <code>.google.cloud.aiplatform.v1beta1.StudySpec.Algorithm algorithm = 3;</code>
     *
     * @return The enum numeric value on the wire for algorithm.
     */
    @java.lang.Override
    public int getAlgorithmValue() {
      return algorithm_;
    }
    /**
     *
     *
     * <pre>
     * The search algorithm specified for the Study.
     * </pre>
     *
     * <code>.google.cloud.aiplatform.v1beta1.StudySpec.Algorithm algorithm = 3;</code>
     *
     * @param value The enum numeric value on the wire for algorithm to set.
     * @return This builder for chaining.
     */
    public Builder setAlgorithmValue(int value) {

      algorithm_ = value;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The search algorithm specified for the Study.
     * </pre>
     *
     * <code>.google.cloud.aiplatform.v1beta1.StudySpec.Algorithm algorithm = 3;</code>
     *
     * @return The algorithm.
     */
    @java.lang.Override
    public com.google.cloud.aiplatform.v1beta1.StudySpec.Algorithm getAlgorithm() {
      @SuppressWarnings("deprecation")
      com.google.cloud.aiplatform.v1beta1.StudySpec.Algorithm result =
          com.google.cloud.aiplatform.v1beta1.StudySpec.Algorithm.valueOf(algorithm_);
      return result == null
          ? com.google.cloud.aiplatform.v1beta1.StudySpec.Algorithm.UNRECOGNIZED
          : result;
    }
    /**
     *
     *
     * <pre>
     * The search algorithm specified for the Study.
     * </pre>
     *
     * <code>.google.cloud.aiplatform.v1beta1.StudySpec.Algorithm algorithm = 3;</code>
     *
     * @param value The algorithm to set.
     * @return This builder for chaining.
     */
    public Builder setAlgorithm(com.google.cloud.aiplatform.v1beta1.StudySpec.Algorithm value) {
      if (value == null) {
        throw new NullPointerException();
      }

      algorithm_ = value.getNumber();
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The search algorithm specified for the Study.
     * </pre>
     *
     * <code>.google.cloud.aiplatform.v1beta1.StudySpec.Algorithm algorithm = 3;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearAlgorithm() {

      algorithm_ = 0;
      onChanged();
      return this;
    }

    private int observationNoise_ = 0;
    /**
     *
     *
     * <pre>
     * The observation noise level of the study.
     * Currently only supported by the Vizier service. Not supported by
     * HyperparamterTuningJob or TrainingPipeline.
     * </pre>
     *
     * <code>.google.cloud.aiplatform.v1beta1.StudySpec.ObservationNoise observation_noise = 6;
     * </code>
     *
     * @return The enum numeric value on the wire for observationNoise.
     */
    @java.lang.Override
    public int getObservationNoiseValue() {
      return observationNoise_;
    }
    /**
     *
     *
     * <pre>
     * The observation noise level of the study.
     * Currently only supported by the Vizier service. Not supported by
     * HyperparamterTuningJob or TrainingPipeline.
     * </pre>
     *
     * <code>.google.cloud.aiplatform.v1beta1.StudySpec.ObservationNoise observation_noise = 6;
     * </code>
     *
     * @param value The enum numeric value on the wire for observationNoise to set.
     * @return This builder for chaining.
     */
    public Builder setObservationNoiseValue(int value) {

      observationNoise_ = value;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The observation noise level of the study.
     * Currently only supported by the Vizier service. Not supported by
     * HyperparamterTuningJob or TrainingPipeline.
     * </pre>
     *
     * <code>.google.cloud.aiplatform.v1beta1.StudySpec.ObservationNoise observation_noise = 6;
     * </code>
     *
     * @return The observationNoise.
     */
    @java.lang.Override
    public com.google.cloud.aiplatform.v1beta1.StudySpec.ObservationNoise getObservationNoise() {
      @SuppressWarnings("deprecation")
      com.google.cloud.aiplatform.v1beta1.StudySpec.ObservationNoise result =
          com.google.cloud.aiplatform.v1beta1.StudySpec.ObservationNoise.valueOf(observationNoise_);
      return result == null
          ? com.google.cloud.aiplatform.v1beta1.StudySpec.ObservationNoise.UNRECOGNIZED
          : result;
    }
    /**
     *
     *
     * <pre>
     * The observation noise level of the study.
     * Currently only supported by the Vizier service. Not supported by
     * HyperparamterTuningJob or TrainingPipeline.
     * </pre>
     *
     * <code>.google.cloud.aiplatform.v1beta1.StudySpec.ObservationNoise observation_noise = 6;
     * </code>
     *
     * @param value The observationNoise to set.
     * @return This builder for chaining.
     */
    public Builder setObservationNoise(
        com.google.cloud.aiplatform.v1beta1.StudySpec.ObservationNoise value) {
      if (value == null) {
        throw new NullPointerException();
      }

      observationNoise_ = value.getNumber();
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The observation noise level of the study.
     * Currently only supported by the Vizier service. Not supported by
     * HyperparamterTuningJob or TrainingPipeline.
     * </pre>
     *
     * <code>.google.cloud.aiplatform.v1beta1.StudySpec.ObservationNoise observation_noise = 6;
     * </code>
     *
     * @return This builder for chaining.
     */
    public Builder clearObservationNoise() {

      observationNoise_ = 0;
      onChanged();
      return this;
    }

    private int measurementSelectionType_ = 0;
    /**
     *
     *
     * <pre>
     * Describe which measurement selection type will be used
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.StudySpec.MeasurementSelectionType measurement_selection_type = 7;
     * </code>
     *
     * @return The enum numeric value on the wire for measurementSelectionType.
     */
    @java.lang.Override
    public int getMeasurementSelectionTypeValue() {
      return measurementSelectionType_;
    }
    /**
     *
     *
     * <pre>
     * Describe which measurement selection type will be used
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.StudySpec.MeasurementSelectionType measurement_selection_type = 7;
     * </code>
     *
     * @param value The enum numeric value on the wire for measurementSelectionType to set.
     * @return This builder for chaining.
     */
    public Builder setMeasurementSelectionTypeValue(int value) {

      measurementSelectionType_ = value;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Describe which measurement selection type will be used
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.StudySpec.MeasurementSelectionType measurement_selection_type = 7;
     * </code>
     *
     * @return The measurementSelectionType.
     */
    @java.lang.Override
    public com.google.cloud.aiplatform.v1beta1.StudySpec.MeasurementSelectionType
        getMeasurementSelectionType() {
      @SuppressWarnings("deprecation")
      com.google.cloud.aiplatform.v1beta1.StudySpec.MeasurementSelectionType result =
          com.google.cloud.aiplatform.v1beta1.StudySpec.MeasurementSelectionType.valueOf(
              measurementSelectionType_);
      return result == null
          ? com.google.cloud.aiplatform.v1beta1.StudySpec.MeasurementSelectionType.UNRECOGNIZED
          : result;
    }
    /**
     *
     *
     * <pre>
     * Describe which measurement selection type will be used
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.StudySpec.MeasurementSelectionType measurement_selection_type = 7;
     * </code>
     *
     * @param value The measurementSelectionType to set.
     * @return This builder for chaining.
     */
    public Builder setMeasurementSelectionType(
        com.google.cloud.aiplatform.v1beta1.StudySpec.MeasurementSelectionType value) {
      if (value == null) {
        throw new NullPointerException();
      }

      measurementSelectionType_ = value.getNumber();
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Describe which measurement selection type will be used
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.StudySpec.MeasurementSelectionType measurement_selection_type = 7;
     * </code>
     *
     * @return This builder for chaining.
     */
    public Builder clearMeasurementSelectionType() {

      measurementSelectionType_ = 0;
      onChanged();
      return this;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.cloud.aiplatform.v1beta1.StudySpec)
  }

  // @@protoc_insertion_point(class_scope:google.cloud.aiplatform.v1beta1.StudySpec)
  private static final com.google.cloud.aiplatform.v1beta1.StudySpec DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.cloud.aiplatform.v1beta1.StudySpec();
  }

  public static com.google.cloud.aiplatform.v1beta1.StudySpec getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<StudySpec> PARSER =
      new com.google.protobuf.AbstractParser<StudySpec>() {
        @java.lang.Override
        public StudySpec parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          return new StudySpec(input, extensionRegistry);
        }
      };

  public static com.google.protobuf.Parser<StudySpec> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<StudySpec> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.cloud.aiplatform.v1beta1.StudySpec getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
