/*
 * Copyright 2020 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/cloud/aiplatform/v1beta1/custom_job.proto

package com.google.cloud.aiplatform.v1beta1;

/**
 *
 *
 * <pre>
 * Represents the spec of a worker pool in a job.
 * </pre>
 *
 * Protobuf type {@code google.cloud.aiplatform.v1beta1.WorkerPoolSpec}
 */
public final class WorkerPoolSpec extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.cloud.aiplatform.v1beta1.WorkerPoolSpec)
    WorkerPoolSpecOrBuilder {
  private static final long serialVersionUID = 0L;
  // Use WorkerPoolSpec.newBuilder() to construct.
  private WorkerPoolSpec(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private WorkerPoolSpec() {}

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new WorkerPoolSpec();
  }

  @java.lang.Override
  public final com.google.protobuf.UnknownFieldSet getUnknownFields() {
    return this.unknownFields;
  }

  private WorkerPoolSpec(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    this();
    if (extensionRegistry == null) {
      throw new java.lang.NullPointerException();
    }
    com.google.protobuf.UnknownFieldSet.Builder unknownFields =
        com.google.protobuf.UnknownFieldSet.newBuilder();
    try {
      boolean done = false;
      while (!done) {
        int tag = input.readTag();
        switch (tag) {
          case 0:
            done = true;
            break;
          case 10:
            {
              com.google.cloud.aiplatform.v1beta1.MachineSpec.Builder subBuilder = null;
              if (machineSpec_ != null) {
                subBuilder = machineSpec_.toBuilder();
              }
              machineSpec_ =
                  input.readMessage(
                      com.google.cloud.aiplatform.v1beta1.MachineSpec.parser(), extensionRegistry);
              if (subBuilder != null) {
                subBuilder.mergeFrom(machineSpec_);
                machineSpec_ = subBuilder.buildPartial();
              }

              break;
            }
          case 16:
            {
              replicaCount_ = input.readInt64();
              break;
            }
          case 42:
            {
              com.google.cloud.aiplatform.v1beta1.DiskSpec.Builder subBuilder = null;
              if (diskSpec_ != null) {
                subBuilder = diskSpec_.toBuilder();
              }
              diskSpec_ =
                  input.readMessage(
                      com.google.cloud.aiplatform.v1beta1.DiskSpec.parser(), extensionRegistry);
              if (subBuilder != null) {
                subBuilder.mergeFrom(diskSpec_);
                diskSpec_ = subBuilder.buildPartial();
              }

              break;
            }
          case 50:
            {
              com.google.cloud.aiplatform.v1beta1.ContainerSpec.Builder subBuilder = null;
              if (taskCase_ == 6) {
                subBuilder =
                    ((com.google.cloud.aiplatform.v1beta1.ContainerSpec) task_).toBuilder();
              }
              task_ =
                  input.readMessage(
                      com.google.cloud.aiplatform.v1beta1.ContainerSpec.parser(),
                      extensionRegistry);
              if (subBuilder != null) {
                subBuilder.mergeFrom((com.google.cloud.aiplatform.v1beta1.ContainerSpec) task_);
                task_ = subBuilder.buildPartial();
              }
              taskCase_ = 6;
              break;
            }
          case 58:
            {
              com.google.cloud.aiplatform.v1beta1.PythonPackageSpec.Builder subBuilder = null;
              if (taskCase_ == 7) {
                subBuilder =
                    ((com.google.cloud.aiplatform.v1beta1.PythonPackageSpec) task_).toBuilder();
              }
              task_ =
                  input.readMessage(
                      com.google.cloud.aiplatform.v1beta1.PythonPackageSpec.parser(),
                      extensionRegistry);
              if (subBuilder != null) {
                subBuilder.mergeFrom((com.google.cloud.aiplatform.v1beta1.PythonPackageSpec) task_);
                task_ = subBuilder.buildPartial();
              }
              taskCase_ = 7;
              break;
            }
          default:
            {
              if (!parseUnknownField(input, unknownFields, extensionRegistry, tag)) {
                done = true;
              }
              break;
            }
        }
      }
    } catch (com.google.protobuf.InvalidProtocolBufferException e) {
      throw e.setUnfinishedMessage(this);
    } catch (java.io.IOException e) {
      throw new com.google.protobuf.InvalidProtocolBufferException(e).setUnfinishedMessage(this);
    } finally {
      this.unknownFields = unknownFields.build();
      makeExtensionsImmutable();
    }
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.cloud.aiplatform.v1beta1.CustomJobProto
        .internal_static_google_cloud_aiplatform_v1beta1_WorkerPoolSpec_descriptor;
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.cloud.aiplatform.v1beta1.CustomJobProto
        .internal_static_google_cloud_aiplatform_v1beta1_WorkerPoolSpec_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.cloud.aiplatform.v1beta1.WorkerPoolSpec.class,
            com.google.cloud.aiplatform.v1beta1.WorkerPoolSpec.Builder.class);
  }

  private int taskCase_ = 0;
  private java.lang.Object task_;

  public enum TaskCase
      implements
          com.google.protobuf.Internal.EnumLite,
          com.google.protobuf.AbstractMessage.InternalOneOfEnum {
    CONTAINER_SPEC(6),
    PYTHON_PACKAGE_SPEC(7),
    TASK_NOT_SET(0);
    private final int value;

    private TaskCase(int value) {
      this.value = value;
    }
    /**
     * @param value The number of the enum to look for.
     * @return The enum associated with the given number.
     * @deprecated Use {@link #forNumber(int)} instead.
     */
    @java.lang.Deprecated
    public static TaskCase valueOf(int value) {
      return forNumber(value);
    }

    public static TaskCase forNumber(int value) {
      switch (value) {
        case 6:
          return CONTAINER_SPEC;
        case 7:
          return PYTHON_PACKAGE_SPEC;
        case 0:
          return TASK_NOT_SET;
        default:
          return null;
      }
    }

    public int getNumber() {
      return this.value;
    }
  };

  public TaskCase getTaskCase() {
    return TaskCase.forNumber(taskCase_);
  }

  public static final int CONTAINER_SPEC_FIELD_NUMBER = 6;
  /**
   *
   *
   * <pre>
   * The custom container task.
   * </pre>
   *
   * <code>.google.cloud.aiplatform.v1beta1.ContainerSpec container_spec = 6;</code>
   *
   * @return Whether the containerSpec field is set.
   */
  @java.lang.Override
  public boolean hasContainerSpec() {
    return taskCase_ == 6;
  }
  /**
   *
   *
   * <pre>
   * The custom container task.
   * </pre>
   *
   * <code>.google.cloud.aiplatform.v1beta1.ContainerSpec container_spec = 6;</code>
   *
   * @return The containerSpec.
   */
  @java.lang.Override
  public com.google.cloud.aiplatform.v1beta1.ContainerSpec getContainerSpec() {
    if (taskCase_ == 6) {
      return (com.google.cloud.aiplatform.v1beta1.ContainerSpec) task_;
    }
    return com.google.cloud.aiplatform.v1beta1.ContainerSpec.getDefaultInstance();
  }
  /**
   *
   *
   * <pre>
   * The custom container task.
   * </pre>
   *
   * <code>.google.cloud.aiplatform.v1beta1.ContainerSpec container_spec = 6;</code>
   */
  @java.lang.Override
  public com.google.cloud.aiplatform.v1beta1.ContainerSpecOrBuilder getContainerSpecOrBuilder() {
    if (taskCase_ == 6) {
      return (com.google.cloud.aiplatform.v1beta1.ContainerSpec) task_;
    }
    return com.google.cloud.aiplatform.v1beta1.ContainerSpec.getDefaultInstance();
  }

  public static final int PYTHON_PACKAGE_SPEC_FIELD_NUMBER = 7;
  /**
   *
   *
   * <pre>
   * The Python packaged task.
   * </pre>
   *
   * <code>.google.cloud.aiplatform.v1beta1.PythonPackageSpec python_package_spec = 7;</code>
   *
   * @return Whether the pythonPackageSpec field is set.
   */
  @java.lang.Override
  public boolean hasPythonPackageSpec() {
    return taskCase_ == 7;
  }
  /**
   *
   *
   * <pre>
   * The Python packaged task.
   * </pre>
   *
   * <code>.google.cloud.aiplatform.v1beta1.PythonPackageSpec python_package_spec = 7;</code>
   *
   * @return The pythonPackageSpec.
   */
  @java.lang.Override
  public com.google.cloud.aiplatform.v1beta1.PythonPackageSpec getPythonPackageSpec() {
    if (taskCase_ == 7) {
      return (com.google.cloud.aiplatform.v1beta1.PythonPackageSpec) task_;
    }
    return com.google.cloud.aiplatform.v1beta1.PythonPackageSpec.getDefaultInstance();
  }
  /**
   *
   *
   * <pre>
   * The Python packaged task.
   * </pre>
   *
   * <code>.google.cloud.aiplatform.v1beta1.PythonPackageSpec python_package_spec = 7;</code>
   */
  @java.lang.Override
  public com.google.cloud.aiplatform.v1beta1.PythonPackageSpecOrBuilder
      getPythonPackageSpecOrBuilder() {
    if (taskCase_ == 7) {
      return (com.google.cloud.aiplatform.v1beta1.PythonPackageSpec) task_;
    }
    return com.google.cloud.aiplatform.v1beta1.PythonPackageSpec.getDefaultInstance();
  }

  public static final int MACHINE_SPEC_FIELD_NUMBER = 1;
  private com.google.cloud.aiplatform.v1beta1.MachineSpec machineSpec_;
  /**
   *
   *
   * <pre>
   * Optional. Immutable. The specification of a single machine.
   * </pre>
   *
   * <code>
   * .google.cloud.aiplatform.v1beta1.MachineSpec machine_spec = 1 [(.google.api.field_behavior) = OPTIONAL, (.google.api.field_behavior) = IMMUTABLE];
   * </code>
   *
   * @return Whether the machineSpec field is set.
   */
  @java.lang.Override
  public boolean hasMachineSpec() {
    return machineSpec_ != null;
  }
  /**
   *
   *
   * <pre>
   * Optional. Immutable. The specification of a single machine.
   * </pre>
   *
   * <code>
   * .google.cloud.aiplatform.v1beta1.MachineSpec machine_spec = 1 [(.google.api.field_behavior) = OPTIONAL, (.google.api.field_behavior) = IMMUTABLE];
   * </code>
   *
   * @return The machineSpec.
   */
  @java.lang.Override
  public com.google.cloud.aiplatform.v1beta1.MachineSpec getMachineSpec() {
    return machineSpec_ == null
        ? com.google.cloud.aiplatform.v1beta1.MachineSpec.getDefaultInstance()
        : machineSpec_;
  }
  /**
   *
   *
   * <pre>
   * Optional. Immutable. The specification of a single machine.
   * </pre>
   *
   * <code>
   * .google.cloud.aiplatform.v1beta1.MachineSpec machine_spec = 1 [(.google.api.field_behavior) = OPTIONAL, (.google.api.field_behavior) = IMMUTABLE];
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.aiplatform.v1beta1.MachineSpecOrBuilder getMachineSpecOrBuilder() {
    return getMachineSpec();
  }

  public static final int REPLICA_COUNT_FIELD_NUMBER = 2;
  private long replicaCount_;
  /**
   *
   *
   * <pre>
   * Optional. The number of worker replicas to use for this worker pool.
   * </pre>
   *
   * <code>int64 replica_count = 2 [(.google.api.field_behavior) = OPTIONAL];</code>
   *
   * @return The replicaCount.
   */
  @java.lang.Override
  public long getReplicaCount() {
    return replicaCount_;
  }

  public static final int DISK_SPEC_FIELD_NUMBER = 5;
  private com.google.cloud.aiplatform.v1beta1.DiskSpec diskSpec_;
  /**
   *
   *
   * <pre>
   * Disk spec.
   * </pre>
   *
   * <code>.google.cloud.aiplatform.v1beta1.DiskSpec disk_spec = 5;</code>
   *
   * @return Whether the diskSpec field is set.
   */
  @java.lang.Override
  public boolean hasDiskSpec() {
    return diskSpec_ != null;
  }
  /**
   *
   *
   * <pre>
   * Disk spec.
   * </pre>
   *
   * <code>.google.cloud.aiplatform.v1beta1.DiskSpec disk_spec = 5;</code>
   *
   * @return The diskSpec.
   */
  @java.lang.Override
  public com.google.cloud.aiplatform.v1beta1.DiskSpec getDiskSpec() {
    return diskSpec_ == null
        ? com.google.cloud.aiplatform.v1beta1.DiskSpec.getDefaultInstance()
        : diskSpec_;
  }
  /**
   *
   *
   * <pre>
   * Disk spec.
   * </pre>
   *
   * <code>.google.cloud.aiplatform.v1beta1.DiskSpec disk_spec = 5;</code>
   */
  @java.lang.Override
  public com.google.cloud.aiplatform.v1beta1.DiskSpecOrBuilder getDiskSpecOrBuilder() {
    return getDiskSpec();
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    if (machineSpec_ != null) {
      output.writeMessage(1, getMachineSpec());
    }
    if (replicaCount_ != 0L) {
      output.writeInt64(2, replicaCount_);
    }
    if (diskSpec_ != null) {
      output.writeMessage(5, getDiskSpec());
    }
    if (taskCase_ == 6) {
      output.writeMessage(6, (com.google.cloud.aiplatform.v1beta1.ContainerSpec) task_);
    }
    if (taskCase_ == 7) {
      output.writeMessage(7, (com.google.cloud.aiplatform.v1beta1.PythonPackageSpec) task_);
    }
    unknownFields.writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    if (machineSpec_ != null) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(1, getMachineSpec());
    }
    if (replicaCount_ != 0L) {
      size += com.google.protobuf.CodedOutputStream.computeInt64Size(2, replicaCount_);
    }
    if (diskSpec_ != null) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(5, getDiskSpec());
    }
    if (taskCase_ == 6) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(
              6, (com.google.cloud.aiplatform.v1beta1.ContainerSpec) task_);
    }
    if (taskCase_ == 7) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(
              7, (com.google.cloud.aiplatform.v1beta1.PythonPackageSpec) task_);
    }
    size += unknownFields.getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.cloud.aiplatform.v1beta1.WorkerPoolSpec)) {
      return super.equals(obj);
    }
    com.google.cloud.aiplatform.v1beta1.WorkerPoolSpec other =
        (com.google.cloud.aiplatform.v1beta1.WorkerPoolSpec) obj;

    if (hasMachineSpec() != other.hasMachineSpec()) return false;
    if (hasMachineSpec()) {
      if (!getMachineSpec().equals(other.getMachineSpec())) return false;
    }
    if (getReplicaCount() != other.getReplicaCount()) return false;
    if (hasDiskSpec() != other.hasDiskSpec()) return false;
    if (hasDiskSpec()) {
      if (!getDiskSpec().equals(other.getDiskSpec())) return false;
    }
    if (!getTaskCase().equals(other.getTaskCase())) return false;
    switch (taskCase_) {
      case 6:
        if (!getContainerSpec().equals(other.getContainerSpec())) return false;
        break;
      case 7:
        if (!getPythonPackageSpec().equals(other.getPythonPackageSpec())) return false;
        break;
      case 0:
      default:
    }
    if (!unknownFields.equals(other.unknownFields)) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    if (hasMachineSpec()) {
      hash = (37 * hash) + MACHINE_SPEC_FIELD_NUMBER;
      hash = (53 * hash) + getMachineSpec().hashCode();
    }
    hash = (37 * hash) + REPLICA_COUNT_FIELD_NUMBER;
    hash = (53 * hash) + com.google.protobuf.Internal.hashLong(getReplicaCount());
    if (hasDiskSpec()) {
      hash = (37 * hash) + DISK_SPEC_FIELD_NUMBER;
      hash = (53 * hash) + getDiskSpec().hashCode();
    }
    switch (taskCase_) {
      case 6:
        hash = (37 * hash) + CONTAINER_SPEC_FIELD_NUMBER;
        hash = (53 * hash) + getContainerSpec().hashCode();
        break;
      case 7:
        hash = (37 * hash) + PYTHON_PACKAGE_SPEC_FIELD_NUMBER;
        hash = (53 * hash) + getPythonPackageSpec().hashCode();
        break;
      case 0:
      default:
    }
    hash = (29 * hash) + unknownFields.hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.cloud.aiplatform.v1beta1.WorkerPoolSpec parseFrom(
      java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.aiplatform.v1beta1.WorkerPoolSpec parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.aiplatform.v1beta1.WorkerPoolSpec parseFrom(
      com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.aiplatform.v1beta1.WorkerPoolSpec parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.aiplatform.v1beta1.WorkerPoolSpec parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.aiplatform.v1beta1.WorkerPoolSpec parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.aiplatform.v1beta1.WorkerPoolSpec parseFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.aiplatform.v1beta1.WorkerPoolSpec parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.aiplatform.v1beta1.WorkerPoolSpec parseDelimitedFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.cloud.aiplatform.v1beta1.WorkerPoolSpec parseDelimitedFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.aiplatform.v1beta1.WorkerPoolSpec parseFrom(
      com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.aiplatform.v1beta1.WorkerPoolSpec parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(com.google.cloud.aiplatform.v1beta1.WorkerPoolSpec prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }
  /**
   *
   *
   * <pre>
   * Represents the spec of a worker pool in a job.
   * </pre>
   *
   * Protobuf type {@code google.cloud.aiplatform.v1beta1.WorkerPoolSpec}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.cloud.aiplatform.v1beta1.WorkerPoolSpec)
      com.google.cloud.aiplatform.v1beta1.WorkerPoolSpecOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.aiplatform.v1beta1.CustomJobProto
          .internal_static_google_cloud_aiplatform_v1beta1_WorkerPoolSpec_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.aiplatform.v1beta1.CustomJobProto
          .internal_static_google_cloud_aiplatform_v1beta1_WorkerPoolSpec_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.aiplatform.v1beta1.WorkerPoolSpec.class,
              com.google.cloud.aiplatform.v1beta1.WorkerPoolSpec.Builder.class);
    }

    // Construct using com.google.cloud.aiplatform.v1beta1.WorkerPoolSpec.newBuilder()
    private Builder() {
      maybeForceBuilderInitialization();
    }

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
      maybeForceBuilderInitialization();
    }

    private void maybeForceBuilderInitialization() {
      if (com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders) {}
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      if (machineSpecBuilder_ == null) {
        machineSpec_ = null;
      } else {
        machineSpec_ = null;
        machineSpecBuilder_ = null;
      }
      replicaCount_ = 0L;

      if (diskSpecBuilder_ == null) {
        diskSpec_ = null;
      } else {
        diskSpec_ = null;
        diskSpecBuilder_ = null;
      }
      taskCase_ = 0;
      task_ = null;
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.cloud.aiplatform.v1beta1.CustomJobProto
          .internal_static_google_cloud_aiplatform_v1beta1_WorkerPoolSpec_descriptor;
    }

    @java.lang.Override
    public com.google.cloud.aiplatform.v1beta1.WorkerPoolSpec getDefaultInstanceForType() {
      return com.google.cloud.aiplatform.v1beta1.WorkerPoolSpec.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.cloud.aiplatform.v1beta1.WorkerPoolSpec build() {
      com.google.cloud.aiplatform.v1beta1.WorkerPoolSpec result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.cloud.aiplatform.v1beta1.WorkerPoolSpec buildPartial() {
      com.google.cloud.aiplatform.v1beta1.WorkerPoolSpec result =
          new com.google.cloud.aiplatform.v1beta1.WorkerPoolSpec(this);
      if (taskCase_ == 6) {
        if (containerSpecBuilder_ == null) {
          result.task_ = task_;
        } else {
          result.task_ = containerSpecBuilder_.build();
        }
      }
      if (taskCase_ == 7) {
        if (pythonPackageSpecBuilder_ == null) {
          result.task_ = task_;
        } else {
          result.task_ = pythonPackageSpecBuilder_.build();
        }
      }
      if (machineSpecBuilder_ == null) {
        result.machineSpec_ = machineSpec_;
      } else {
        result.machineSpec_ = machineSpecBuilder_.build();
      }
      result.replicaCount_ = replicaCount_;
      if (diskSpecBuilder_ == null) {
        result.diskSpec_ = diskSpec_;
      } else {
        result.diskSpec_ = diskSpecBuilder_.build();
      }
      result.taskCase_ = taskCase_;
      onBuilt();
      return result;
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.cloud.aiplatform.v1beta1.WorkerPoolSpec) {
        return mergeFrom((com.google.cloud.aiplatform.v1beta1.WorkerPoolSpec) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(com.google.cloud.aiplatform.v1beta1.WorkerPoolSpec other) {
      if (other == com.google.cloud.aiplatform.v1beta1.WorkerPoolSpec.getDefaultInstance())
        return this;
      if (other.hasMachineSpec()) {
        mergeMachineSpec(other.getMachineSpec());
      }
      if (other.getReplicaCount() != 0L) {
        setReplicaCount(other.getReplicaCount());
      }
      if (other.hasDiskSpec()) {
        mergeDiskSpec(other.getDiskSpec());
      }
      switch (other.getTaskCase()) {
        case CONTAINER_SPEC:
          {
            mergeContainerSpec(other.getContainerSpec());
            break;
          }
        case PYTHON_PACKAGE_SPEC:
          {
            mergePythonPackageSpec(other.getPythonPackageSpec());
            break;
          }
        case TASK_NOT_SET:
          {
            break;
          }
      }
      this.mergeUnknownFields(other.unknownFields);
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      com.google.cloud.aiplatform.v1beta1.WorkerPoolSpec parsedMessage = null;
      try {
        parsedMessage = PARSER.parsePartialFrom(input, extensionRegistry);
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        parsedMessage =
            (com.google.cloud.aiplatform.v1beta1.WorkerPoolSpec) e.getUnfinishedMessage();
        throw e.unwrapIOException();
      } finally {
        if (parsedMessage != null) {
          mergeFrom(parsedMessage);
        }
      }
      return this;
    }

    private int taskCase_ = 0;
    private java.lang.Object task_;

    public TaskCase getTaskCase() {
      return TaskCase.forNumber(taskCase_);
    }

    public Builder clearTask() {
      taskCase_ = 0;
      task_ = null;
      onChanged();
      return this;
    }

    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.aiplatform.v1beta1.ContainerSpec,
            com.google.cloud.aiplatform.v1beta1.ContainerSpec.Builder,
            com.google.cloud.aiplatform.v1beta1.ContainerSpecOrBuilder>
        containerSpecBuilder_;
    /**
     *
     *
     * <pre>
     * The custom container task.
     * </pre>
     *
     * <code>.google.cloud.aiplatform.v1beta1.ContainerSpec container_spec = 6;</code>
     *
     * @return Whether the containerSpec field is set.
     */
    @java.lang.Override
    public boolean hasContainerSpec() {
      return taskCase_ == 6;
    }
    /**
     *
     *
     * <pre>
     * The custom container task.
     * </pre>
     *
     * <code>.google.cloud.aiplatform.v1beta1.ContainerSpec container_spec = 6;</code>
     *
     * @return The containerSpec.
     */
    @java.lang.Override
    public com.google.cloud.aiplatform.v1beta1.ContainerSpec getContainerSpec() {
      if (containerSpecBuilder_ == null) {
        if (taskCase_ == 6) {
          return (com.google.cloud.aiplatform.v1beta1.ContainerSpec) task_;
        }
        return com.google.cloud.aiplatform.v1beta1.ContainerSpec.getDefaultInstance();
      } else {
        if (taskCase_ == 6) {
          return containerSpecBuilder_.getMessage();
        }
        return com.google.cloud.aiplatform.v1beta1.ContainerSpec.getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * The custom container task.
     * </pre>
     *
     * <code>.google.cloud.aiplatform.v1beta1.ContainerSpec container_spec = 6;</code>
     */
    public Builder setContainerSpec(com.google.cloud.aiplatform.v1beta1.ContainerSpec value) {
      if (containerSpecBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        task_ = value;
        onChanged();
      } else {
        containerSpecBuilder_.setMessage(value);
      }
      taskCase_ = 6;
      return this;
    }
    /**
     *
     *
     * <pre>
     * The custom container task.
     * </pre>
     *
     * <code>.google.cloud.aiplatform.v1beta1.ContainerSpec container_spec = 6;</code>
     */
    public Builder setContainerSpec(
        com.google.cloud.aiplatform.v1beta1.ContainerSpec.Builder builderForValue) {
      if (containerSpecBuilder_ == null) {
        task_ = builderForValue.build();
        onChanged();
      } else {
        containerSpecBuilder_.setMessage(builderForValue.build());
      }
      taskCase_ = 6;
      return this;
    }
    /**
     *
     *
     * <pre>
     * The custom container task.
     * </pre>
     *
     * <code>.google.cloud.aiplatform.v1beta1.ContainerSpec container_spec = 6;</code>
     */
    public Builder mergeContainerSpec(com.google.cloud.aiplatform.v1beta1.ContainerSpec value) {
      if (containerSpecBuilder_ == null) {
        if (taskCase_ == 6
            && task_ != com.google.cloud.aiplatform.v1beta1.ContainerSpec.getDefaultInstance()) {
          task_ =
              com.google.cloud.aiplatform.v1beta1.ContainerSpec.newBuilder(
                      (com.google.cloud.aiplatform.v1beta1.ContainerSpec) task_)
                  .mergeFrom(value)
                  .buildPartial();
        } else {
          task_ = value;
        }
        onChanged();
      } else {
        if (taskCase_ == 6) {
          containerSpecBuilder_.mergeFrom(value);
        }
        containerSpecBuilder_.setMessage(value);
      }
      taskCase_ = 6;
      return this;
    }
    /**
     *
     *
     * <pre>
     * The custom container task.
     * </pre>
     *
     * <code>.google.cloud.aiplatform.v1beta1.ContainerSpec container_spec = 6;</code>
     */
    public Builder clearContainerSpec() {
      if (containerSpecBuilder_ == null) {
        if (taskCase_ == 6) {
          taskCase_ = 0;
          task_ = null;
          onChanged();
        }
      } else {
        if (taskCase_ == 6) {
          taskCase_ = 0;
          task_ = null;
        }
        containerSpecBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * The custom container task.
     * </pre>
     *
     * <code>.google.cloud.aiplatform.v1beta1.ContainerSpec container_spec = 6;</code>
     */
    public com.google.cloud.aiplatform.v1beta1.ContainerSpec.Builder getContainerSpecBuilder() {
      return getContainerSpecFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * The custom container task.
     * </pre>
     *
     * <code>.google.cloud.aiplatform.v1beta1.ContainerSpec container_spec = 6;</code>
     */
    @java.lang.Override
    public com.google.cloud.aiplatform.v1beta1.ContainerSpecOrBuilder getContainerSpecOrBuilder() {
      if ((taskCase_ == 6) && (containerSpecBuilder_ != null)) {
        return containerSpecBuilder_.getMessageOrBuilder();
      } else {
        if (taskCase_ == 6) {
          return (com.google.cloud.aiplatform.v1beta1.ContainerSpec) task_;
        }
        return com.google.cloud.aiplatform.v1beta1.ContainerSpec.getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * The custom container task.
     * </pre>
     *
     * <code>.google.cloud.aiplatform.v1beta1.ContainerSpec container_spec = 6;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.aiplatform.v1beta1.ContainerSpec,
            com.google.cloud.aiplatform.v1beta1.ContainerSpec.Builder,
            com.google.cloud.aiplatform.v1beta1.ContainerSpecOrBuilder>
        getContainerSpecFieldBuilder() {
      if (containerSpecBuilder_ == null) {
        if (!(taskCase_ == 6)) {
          task_ = com.google.cloud.aiplatform.v1beta1.ContainerSpec.getDefaultInstance();
        }
        containerSpecBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.aiplatform.v1beta1.ContainerSpec,
                com.google.cloud.aiplatform.v1beta1.ContainerSpec.Builder,
                com.google.cloud.aiplatform.v1beta1.ContainerSpecOrBuilder>(
                (com.google.cloud.aiplatform.v1beta1.ContainerSpec) task_,
                getParentForChildren(),
                isClean());
        task_ = null;
      }
      taskCase_ = 6;
      onChanged();
      ;
      return containerSpecBuilder_;
    }

    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.aiplatform.v1beta1.PythonPackageSpec,
            com.google.cloud.aiplatform.v1beta1.PythonPackageSpec.Builder,
            com.google.cloud.aiplatform.v1beta1.PythonPackageSpecOrBuilder>
        pythonPackageSpecBuilder_;
    /**
     *
     *
     * <pre>
     * The Python packaged task.
     * </pre>
     *
     * <code>.google.cloud.aiplatform.v1beta1.PythonPackageSpec python_package_spec = 7;</code>
     *
     * @return Whether the pythonPackageSpec field is set.
     */
    @java.lang.Override
    public boolean hasPythonPackageSpec() {
      return taskCase_ == 7;
    }
    /**
     *
     *
     * <pre>
     * The Python packaged task.
     * </pre>
     *
     * <code>.google.cloud.aiplatform.v1beta1.PythonPackageSpec python_package_spec = 7;</code>
     *
     * @return The pythonPackageSpec.
     */
    @java.lang.Override
    public com.google.cloud.aiplatform.v1beta1.PythonPackageSpec getPythonPackageSpec() {
      if (pythonPackageSpecBuilder_ == null) {
        if (taskCase_ == 7) {
          return (com.google.cloud.aiplatform.v1beta1.PythonPackageSpec) task_;
        }
        return com.google.cloud.aiplatform.v1beta1.PythonPackageSpec.getDefaultInstance();
      } else {
        if (taskCase_ == 7) {
          return pythonPackageSpecBuilder_.getMessage();
        }
        return com.google.cloud.aiplatform.v1beta1.PythonPackageSpec.getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * The Python packaged task.
     * </pre>
     *
     * <code>.google.cloud.aiplatform.v1beta1.PythonPackageSpec python_package_spec = 7;</code>
     */
    public Builder setPythonPackageSpec(
        com.google.cloud.aiplatform.v1beta1.PythonPackageSpec value) {
      if (pythonPackageSpecBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        task_ = value;
        onChanged();
      } else {
        pythonPackageSpecBuilder_.setMessage(value);
      }
      taskCase_ = 7;
      return this;
    }
    /**
     *
     *
     * <pre>
     * The Python packaged task.
     * </pre>
     *
     * <code>.google.cloud.aiplatform.v1beta1.PythonPackageSpec python_package_spec = 7;</code>
     */
    public Builder setPythonPackageSpec(
        com.google.cloud.aiplatform.v1beta1.PythonPackageSpec.Builder builderForValue) {
      if (pythonPackageSpecBuilder_ == null) {
        task_ = builderForValue.build();
        onChanged();
      } else {
        pythonPackageSpecBuilder_.setMessage(builderForValue.build());
      }
      taskCase_ = 7;
      return this;
    }
    /**
     *
     *
     * <pre>
     * The Python packaged task.
     * </pre>
     *
     * <code>.google.cloud.aiplatform.v1beta1.PythonPackageSpec python_package_spec = 7;</code>
     */
    public Builder mergePythonPackageSpec(
        com.google.cloud.aiplatform.v1beta1.PythonPackageSpec value) {
      if (pythonPackageSpecBuilder_ == null) {
        if (taskCase_ == 7
            && task_
                != com.google.cloud.aiplatform.v1beta1.PythonPackageSpec.getDefaultInstance()) {
          task_ =
              com.google.cloud.aiplatform.v1beta1.PythonPackageSpec.newBuilder(
                      (com.google.cloud.aiplatform.v1beta1.PythonPackageSpec) task_)
                  .mergeFrom(value)
                  .buildPartial();
        } else {
          task_ = value;
        }
        onChanged();
      } else {
        if (taskCase_ == 7) {
          pythonPackageSpecBuilder_.mergeFrom(value);
        }
        pythonPackageSpecBuilder_.setMessage(value);
      }
      taskCase_ = 7;
      return this;
    }
    /**
     *
     *
     * <pre>
     * The Python packaged task.
     * </pre>
     *
     * <code>.google.cloud.aiplatform.v1beta1.PythonPackageSpec python_package_spec = 7;</code>
     */
    public Builder clearPythonPackageSpec() {
      if (pythonPackageSpecBuilder_ == null) {
        if (taskCase_ == 7) {
          taskCase_ = 0;
          task_ = null;
          onChanged();
        }
      } else {
        if (taskCase_ == 7) {
          taskCase_ = 0;
          task_ = null;
        }
        pythonPackageSpecBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * The Python packaged task.
     * </pre>
     *
     * <code>.google.cloud.aiplatform.v1beta1.PythonPackageSpec python_package_spec = 7;</code>
     */
    public com.google.cloud.aiplatform.v1beta1.PythonPackageSpec.Builder
        getPythonPackageSpecBuilder() {
      return getPythonPackageSpecFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * The Python packaged task.
     * </pre>
     *
     * <code>.google.cloud.aiplatform.v1beta1.PythonPackageSpec python_package_spec = 7;</code>
     */
    @java.lang.Override
    public com.google.cloud.aiplatform.v1beta1.PythonPackageSpecOrBuilder
        getPythonPackageSpecOrBuilder() {
      if ((taskCase_ == 7) && (pythonPackageSpecBuilder_ != null)) {
        return pythonPackageSpecBuilder_.getMessageOrBuilder();
      } else {
        if (taskCase_ == 7) {
          return (com.google.cloud.aiplatform.v1beta1.PythonPackageSpec) task_;
        }
        return com.google.cloud.aiplatform.v1beta1.PythonPackageSpec.getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * The Python packaged task.
     * </pre>
     *
     * <code>.google.cloud.aiplatform.v1beta1.PythonPackageSpec python_package_spec = 7;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.aiplatform.v1beta1.PythonPackageSpec,
            com.google.cloud.aiplatform.v1beta1.PythonPackageSpec.Builder,
            com.google.cloud.aiplatform.v1beta1.PythonPackageSpecOrBuilder>
        getPythonPackageSpecFieldBuilder() {
      if (pythonPackageSpecBuilder_ == null) {
        if (!(taskCase_ == 7)) {
          task_ = com.google.cloud.aiplatform.v1beta1.PythonPackageSpec.getDefaultInstance();
        }
        pythonPackageSpecBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.aiplatform.v1beta1.PythonPackageSpec,
                com.google.cloud.aiplatform.v1beta1.PythonPackageSpec.Builder,
                com.google.cloud.aiplatform.v1beta1.PythonPackageSpecOrBuilder>(
                (com.google.cloud.aiplatform.v1beta1.PythonPackageSpec) task_,
                getParentForChildren(),
                isClean());
        task_ = null;
      }
      taskCase_ = 7;
      onChanged();
      ;
      return pythonPackageSpecBuilder_;
    }

    private com.google.cloud.aiplatform.v1beta1.MachineSpec machineSpec_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.aiplatform.v1beta1.MachineSpec,
            com.google.cloud.aiplatform.v1beta1.MachineSpec.Builder,
            com.google.cloud.aiplatform.v1beta1.MachineSpecOrBuilder>
        machineSpecBuilder_;
    /**
     *
     *
     * <pre>
     * Optional. Immutable. The specification of a single machine.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.MachineSpec machine_spec = 1 [(.google.api.field_behavior) = OPTIONAL, (.google.api.field_behavior) = IMMUTABLE];
     * </code>
     *
     * @return Whether the machineSpec field is set.
     */
    public boolean hasMachineSpec() {
      return machineSpecBuilder_ != null || machineSpec_ != null;
    }
    /**
     *
     *
     * <pre>
     * Optional. Immutable. The specification of a single machine.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.MachineSpec machine_spec = 1 [(.google.api.field_behavior) = OPTIONAL, (.google.api.field_behavior) = IMMUTABLE];
     * </code>
     *
     * @return The machineSpec.
     */
    public com.google.cloud.aiplatform.v1beta1.MachineSpec getMachineSpec() {
      if (machineSpecBuilder_ == null) {
        return machineSpec_ == null
            ? com.google.cloud.aiplatform.v1beta1.MachineSpec.getDefaultInstance()
            : machineSpec_;
      } else {
        return machineSpecBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Optional. Immutable. The specification of a single machine.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.MachineSpec machine_spec = 1 [(.google.api.field_behavior) = OPTIONAL, (.google.api.field_behavior) = IMMUTABLE];
     * </code>
     */
    public Builder setMachineSpec(com.google.cloud.aiplatform.v1beta1.MachineSpec value) {
      if (machineSpecBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        machineSpec_ = value;
        onChanged();
      } else {
        machineSpecBuilder_.setMessage(value);
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. Immutable. The specification of a single machine.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.MachineSpec machine_spec = 1 [(.google.api.field_behavior) = OPTIONAL, (.google.api.field_behavior) = IMMUTABLE];
     * </code>
     */
    public Builder setMachineSpec(
        com.google.cloud.aiplatform.v1beta1.MachineSpec.Builder builderForValue) {
      if (machineSpecBuilder_ == null) {
        machineSpec_ = builderForValue.build();
        onChanged();
      } else {
        machineSpecBuilder_.setMessage(builderForValue.build());
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. Immutable. The specification of a single machine.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.MachineSpec machine_spec = 1 [(.google.api.field_behavior) = OPTIONAL, (.google.api.field_behavior) = IMMUTABLE];
     * </code>
     */
    public Builder mergeMachineSpec(com.google.cloud.aiplatform.v1beta1.MachineSpec value) {
      if (machineSpecBuilder_ == null) {
        if (machineSpec_ != null) {
          machineSpec_ =
              com.google.cloud.aiplatform.v1beta1.MachineSpec.newBuilder(machineSpec_)
                  .mergeFrom(value)
                  .buildPartial();
        } else {
          machineSpec_ = value;
        }
        onChanged();
      } else {
        machineSpecBuilder_.mergeFrom(value);
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. Immutable. The specification of a single machine.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.MachineSpec machine_spec = 1 [(.google.api.field_behavior) = OPTIONAL, (.google.api.field_behavior) = IMMUTABLE];
     * </code>
     */
    public Builder clearMachineSpec() {
      if (machineSpecBuilder_ == null) {
        machineSpec_ = null;
        onChanged();
      } else {
        machineSpec_ = null;
        machineSpecBuilder_ = null;
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. Immutable. The specification of a single machine.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.MachineSpec machine_spec = 1 [(.google.api.field_behavior) = OPTIONAL, (.google.api.field_behavior) = IMMUTABLE];
     * </code>
     */
    public com.google.cloud.aiplatform.v1beta1.MachineSpec.Builder getMachineSpecBuilder() {

      onChanged();
      return getMachineSpecFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Optional. Immutable. The specification of a single machine.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.MachineSpec machine_spec = 1 [(.google.api.field_behavior) = OPTIONAL, (.google.api.field_behavior) = IMMUTABLE];
     * </code>
     */
    public com.google.cloud.aiplatform.v1beta1.MachineSpecOrBuilder getMachineSpecOrBuilder() {
      if (machineSpecBuilder_ != null) {
        return machineSpecBuilder_.getMessageOrBuilder();
      } else {
        return machineSpec_ == null
            ? com.google.cloud.aiplatform.v1beta1.MachineSpec.getDefaultInstance()
            : machineSpec_;
      }
    }
    /**
     *
     *
     * <pre>
     * Optional. Immutable. The specification of a single machine.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.MachineSpec machine_spec = 1 [(.google.api.field_behavior) = OPTIONAL, (.google.api.field_behavior) = IMMUTABLE];
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.aiplatform.v1beta1.MachineSpec,
            com.google.cloud.aiplatform.v1beta1.MachineSpec.Builder,
            com.google.cloud.aiplatform.v1beta1.MachineSpecOrBuilder>
        getMachineSpecFieldBuilder() {
      if (machineSpecBuilder_ == null) {
        machineSpecBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.aiplatform.v1beta1.MachineSpec,
                com.google.cloud.aiplatform.v1beta1.MachineSpec.Builder,
                com.google.cloud.aiplatform.v1beta1.MachineSpecOrBuilder>(
                getMachineSpec(), getParentForChildren(), isClean());
        machineSpec_ = null;
      }
      return machineSpecBuilder_;
    }

    private long replicaCount_;
    /**
     *
     *
     * <pre>
     * Optional. The number of worker replicas to use for this worker pool.
     * </pre>
     *
     * <code>int64 replica_count = 2 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return The replicaCount.
     */
    @java.lang.Override
    public long getReplicaCount() {
      return replicaCount_;
    }
    /**
     *
     *
     * <pre>
     * Optional. The number of worker replicas to use for this worker pool.
     * </pre>
     *
     * <code>int64 replica_count = 2 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @param value The replicaCount to set.
     * @return This builder for chaining.
     */
    public Builder setReplicaCount(long value) {

      replicaCount_ = value;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. The number of worker replicas to use for this worker pool.
     * </pre>
     *
     * <code>int64 replica_count = 2 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearReplicaCount() {

      replicaCount_ = 0L;
      onChanged();
      return this;
    }

    private com.google.cloud.aiplatform.v1beta1.DiskSpec diskSpec_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.aiplatform.v1beta1.DiskSpec,
            com.google.cloud.aiplatform.v1beta1.DiskSpec.Builder,
            com.google.cloud.aiplatform.v1beta1.DiskSpecOrBuilder>
        diskSpecBuilder_;
    /**
     *
     *
     * <pre>
     * Disk spec.
     * </pre>
     *
     * <code>.google.cloud.aiplatform.v1beta1.DiskSpec disk_spec = 5;</code>
     *
     * @return Whether the diskSpec field is set.
     */
    public boolean hasDiskSpec() {
      return diskSpecBuilder_ != null || diskSpec_ != null;
    }
    /**
     *
     *
     * <pre>
     * Disk spec.
     * </pre>
     *
     * <code>.google.cloud.aiplatform.v1beta1.DiskSpec disk_spec = 5;</code>
     *
     * @return The diskSpec.
     */
    public com.google.cloud.aiplatform.v1beta1.DiskSpec getDiskSpec() {
      if (diskSpecBuilder_ == null) {
        return diskSpec_ == null
            ? com.google.cloud.aiplatform.v1beta1.DiskSpec.getDefaultInstance()
            : diskSpec_;
      } else {
        return diskSpecBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Disk spec.
     * </pre>
     *
     * <code>.google.cloud.aiplatform.v1beta1.DiskSpec disk_spec = 5;</code>
     */
    public Builder setDiskSpec(com.google.cloud.aiplatform.v1beta1.DiskSpec value) {
      if (diskSpecBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        diskSpec_ = value;
        onChanged();
      } else {
        diskSpecBuilder_.setMessage(value);
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * Disk spec.
     * </pre>
     *
     * <code>.google.cloud.aiplatform.v1beta1.DiskSpec disk_spec = 5;</code>
     */
    public Builder setDiskSpec(
        com.google.cloud.aiplatform.v1beta1.DiskSpec.Builder builderForValue) {
      if (diskSpecBuilder_ == null) {
        diskSpec_ = builderForValue.build();
        onChanged();
      } else {
        diskSpecBuilder_.setMessage(builderForValue.build());
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * Disk spec.
     * </pre>
     *
     * <code>.google.cloud.aiplatform.v1beta1.DiskSpec disk_spec = 5;</code>
     */
    public Builder mergeDiskSpec(com.google.cloud.aiplatform.v1beta1.DiskSpec value) {
      if (diskSpecBuilder_ == null) {
        if (diskSpec_ != null) {
          diskSpec_ =
              com.google.cloud.aiplatform.v1beta1.DiskSpec.newBuilder(diskSpec_)
                  .mergeFrom(value)
                  .buildPartial();
        } else {
          diskSpec_ = value;
        }
        onChanged();
      } else {
        diskSpecBuilder_.mergeFrom(value);
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * Disk spec.
     * </pre>
     *
     * <code>.google.cloud.aiplatform.v1beta1.DiskSpec disk_spec = 5;</code>
     */
    public Builder clearDiskSpec() {
      if (diskSpecBuilder_ == null) {
        diskSpec_ = null;
        onChanged();
      } else {
        diskSpec_ = null;
        diskSpecBuilder_ = null;
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * Disk spec.
     * </pre>
     *
     * <code>.google.cloud.aiplatform.v1beta1.DiskSpec disk_spec = 5;</code>
     */
    public com.google.cloud.aiplatform.v1beta1.DiskSpec.Builder getDiskSpecBuilder() {

      onChanged();
      return getDiskSpecFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Disk spec.
     * </pre>
     *
     * <code>.google.cloud.aiplatform.v1beta1.DiskSpec disk_spec = 5;</code>
     */
    public com.google.cloud.aiplatform.v1beta1.DiskSpecOrBuilder getDiskSpecOrBuilder() {
      if (diskSpecBuilder_ != null) {
        return diskSpecBuilder_.getMessageOrBuilder();
      } else {
        return diskSpec_ == null
            ? com.google.cloud.aiplatform.v1beta1.DiskSpec.getDefaultInstance()
            : diskSpec_;
      }
    }
    /**
     *
     *
     * <pre>
     * Disk spec.
     * </pre>
     *
     * <code>.google.cloud.aiplatform.v1beta1.DiskSpec disk_spec = 5;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.aiplatform.v1beta1.DiskSpec,
            com.google.cloud.aiplatform.v1beta1.DiskSpec.Builder,
            com.google.cloud.aiplatform.v1beta1.DiskSpecOrBuilder>
        getDiskSpecFieldBuilder() {
      if (diskSpecBuilder_ == null) {
        diskSpecBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.aiplatform.v1beta1.DiskSpec,
                com.google.cloud.aiplatform.v1beta1.DiskSpec.Builder,
                com.google.cloud.aiplatform.v1beta1.DiskSpecOrBuilder>(
                getDiskSpec(), getParentForChildren(), isClean());
        diskSpec_ = null;
      }
      return diskSpecBuilder_;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.cloud.aiplatform.v1beta1.WorkerPoolSpec)
  }

  // @@protoc_insertion_point(class_scope:google.cloud.aiplatform.v1beta1.WorkerPoolSpec)
  private static final com.google.cloud.aiplatform.v1beta1.WorkerPoolSpec DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.cloud.aiplatform.v1beta1.WorkerPoolSpec();
  }

  public static com.google.cloud.aiplatform.v1beta1.WorkerPoolSpec getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<WorkerPoolSpec> PARSER =
      new com.google.protobuf.AbstractParser<WorkerPoolSpec>() {
        @java.lang.Override
        public WorkerPoolSpec parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          return new WorkerPoolSpec(input, extensionRegistry);
        }
      };

  public static com.google.protobuf.Parser<WorkerPoolSpec> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<WorkerPoolSpec> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.cloud.aiplatform.v1beta1.WorkerPoolSpec getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
