/*
 * Copyright 2024 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/cloud/aiplatform/v1beta1/extension.proto

// Protobuf Java Version: 3.25.5
package com.google.cloud.aiplatform.v1beta1;

/**
 *
 *
 * <pre>
 * Auth configuration to run the extension.
 * </pre>
 *
 * Protobuf type {@code google.cloud.aiplatform.v1beta1.AuthConfig}
 */
public final class AuthConfig extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.cloud.aiplatform.v1beta1.AuthConfig)
    AuthConfigOrBuilder {
  private static final long serialVersionUID = 0L;
  // Use AuthConfig.newBuilder() to construct.
  private AuthConfig(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private AuthConfig() {
    authType_ = 0;
  }

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new AuthConfig();
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.cloud.aiplatform.v1beta1.ExtensionProto
        .internal_static_google_cloud_aiplatform_v1beta1_AuthConfig_descriptor;
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.cloud.aiplatform.v1beta1.ExtensionProto
        .internal_static_google_cloud_aiplatform_v1beta1_AuthConfig_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.cloud.aiplatform.v1beta1.AuthConfig.class,
            com.google.cloud.aiplatform.v1beta1.AuthConfig.Builder.class);
  }

  public interface ApiKeyConfigOrBuilder
      extends
      // @@protoc_insertion_point(interface_extends:google.cloud.aiplatform.v1beta1.AuthConfig.ApiKeyConfig)
      com.google.protobuf.MessageOrBuilder {

    /**
     *
     *
     * <pre>
     * Required. The parameter name of the API key.
     * E.g. If the API request is "https://example.com/act?api_key=&lt;API KEY&gt;",
     * "api_key" would be the parameter name.
     * </pre>
     *
     * <code>string name = 1 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return The name.
     */
    java.lang.String getName();
    /**
     *
     *
     * <pre>
     * Required. The parameter name of the API key.
     * E.g. If the API request is "https://example.com/act?api_key=&lt;API KEY&gt;",
     * "api_key" would be the parameter name.
     * </pre>
     *
     * <code>string name = 1 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return The bytes for name.
     */
    com.google.protobuf.ByteString getNameBytes();

    /**
     *
     *
     * <pre>
     * Required. The name of the SecretManager secret version resource storing
     * the API key. Format:
     * `projects/{project}/secrets/{secrete}/versions/{version}`
     *
     * - If specified, the `secretmanager.versions.access` permission should be
     * granted to Vertex AI Extension Service Agent
     * (https://cloud.google.com/vertex-ai/docs/general/access-control#service-agents)
     * on the specified resource.
     * </pre>
     *
     * <code>
     * string api_key_secret = 2 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @return The apiKeySecret.
     */
    java.lang.String getApiKeySecret();
    /**
     *
     *
     * <pre>
     * Required. The name of the SecretManager secret version resource storing
     * the API key. Format:
     * `projects/{project}/secrets/{secrete}/versions/{version}`
     *
     * - If specified, the `secretmanager.versions.access` permission should be
     * granted to Vertex AI Extension Service Agent
     * (https://cloud.google.com/vertex-ai/docs/general/access-control#service-agents)
     * on the specified resource.
     * </pre>
     *
     * <code>
     * string api_key_secret = 2 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @return The bytes for apiKeySecret.
     */
    com.google.protobuf.ByteString getApiKeySecretBytes();

    /**
     *
     *
     * <pre>
     * Required. The location of the API key.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.HttpElementLocation http_element_location = 3 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     *
     * @return The enum numeric value on the wire for httpElementLocation.
     */
    int getHttpElementLocationValue();
    /**
     *
     *
     * <pre>
     * Required. The location of the API key.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.HttpElementLocation http_element_location = 3 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     *
     * @return The httpElementLocation.
     */
    com.google.cloud.aiplatform.v1beta1.HttpElementLocation getHttpElementLocation();
  }
  /**
   *
   *
   * <pre>
   * Config for authentication with API key.
   * </pre>
   *
   * Protobuf type {@code google.cloud.aiplatform.v1beta1.AuthConfig.ApiKeyConfig}
   */
  public static final class ApiKeyConfig extends com.google.protobuf.GeneratedMessageV3
      implements
      // @@protoc_insertion_point(message_implements:google.cloud.aiplatform.v1beta1.AuthConfig.ApiKeyConfig)
      ApiKeyConfigOrBuilder {
    private static final long serialVersionUID = 0L;
    // Use ApiKeyConfig.newBuilder() to construct.
    private ApiKeyConfig(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
      super(builder);
    }

    private ApiKeyConfig() {
      name_ = "";
      apiKeySecret_ = "";
      httpElementLocation_ = 0;
    }

    @java.lang.Override
    @SuppressWarnings({"unused"})
    protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
      return new ApiKeyConfig();
    }

    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.aiplatform.v1beta1.ExtensionProto
          .internal_static_google_cloud_aiplatform_v1beta1_AuthConfig_ApiKeyConfig_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.aiplatform.v1beta1.ExtensionProto
          .internal_static_google_cloud_aiplatform_v1beta1_AuthConfig_ApiKeyConfig_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.aiplatform.v1beta1.AuthConfig.ApiKeyConfig.class,
              com.google.cloud.aiplatform.v1beta1.AuthConfig.ApiKeyConfig.Builder.class);
    }

    public static final int NAME_FIELD_NUMBER = 1;

    @SuppressWarnings("serial")
    private volatile java.lang.Object name_ = "";
    /**
     *
     *
     * <pre>
     * Required. The parameter name of the API key.
     * E.g. If the API request is "https://example.com/act?api_key=&lt;API KEY&gt;",
     * "api_key" would be the parameter name.
     * </pre>
     *
     * <code>string name = 1 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return The name.
     */
    @java.lang.Override
    public java.lang.String getName() {
      java.lang.Object ref = name_;
      if (ref instanceof java.lang.String) {
        return (java.lang.String) ref;
      } else {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        name_ = s;
        return s;
      }
    }
    /**
     *
     *
     * <pre>
     * Required. The parameter name of the API key.
     * E.g. If the API request is "https://example.com/act?api_key=&lt;API KEY&gt;",
     * "api_key" would be the parameter name.
     * </pre>
     *
     * <code>string name = 1 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return The bytes for name.
     */
    @java.lang.Override
    public com.google.protobuf.ByteString getNameBytes() {
      java.lang.Object ref = name_;
      if (ref instanceof java.lang.String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        name_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    public static final int API_KEY_SECRET_FIELD_NUMBER = 2;

    @SuppressWarnings("serial")
    private volatile java.lang.Object apiKeySecret_ = "";
    /**
     *
     *
     * <pre>
     * Required. The name of the SecretManager secret version resource storing
     * the API key. Format:
     * `projects/{project}/secrets/{secrete}/versions/{version}`
     *
     * - If specified, the `secretmanager.versions.access` permission should be
     * granted to Vertex AI Extension Service Agent
     * (https://cloud.google.com/vertex-ai/docs/general/access-control#service-agents)
     * on the specified resource.
     * </pre>
     *
     * <code>
     * string api_key_secret = 2 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @return The apiKeySecret.
     */
    @java.lang.Override
    public java.lang.String getApiKeySecret() {
      java.lang.Object ref = apiKeySecret_;
      if (ref instanceof java.lang.String) {
        return (java.lang.String) ref;
      } else {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        apiKeySecret_ = s;
        return s;
      }
    }
    /**
     *
     *
     * <pre>
     * Required. The name of the SecretManager secret version resource storing
     * the API key. Format:
     * `projects/{project}/secrets/{secrete}/versions/{version}`
     *
     * - If specified, the `secretmanager.versions.access` permission should be
     * granted to Vertex AI Extension Service Agent
     * (https://cloud.google.com/vertex-ai/docs/general/access-control#service-agents)
     * on the specified resource.
     * </pre>
     *
     * <code>
     * string api_key_secret = 2 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @return The bytes for apiKeySecret.
     */
    @java.lang.Override
    public com.google.protobuf.ByteString getApiKeySecretBytes() {
      java.lang.Object ref = apiKeySecret_;
      if (ref instanceof java.lang.String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        apiKeySecret_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    public static final int HTTP_ELEMENT_LOCATION_FIELD_NUMBER = 3;
    private int httpElementLocation_ = 0;
    /**
     *
     *
     * <pre>
     * Required. The location of the API key.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.HttpElementLocation http_element_location = 3 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     *
     * @return The enum numeric value on the wire for httpElementLocation.
     */
    @java.lang.Override
    public int getHttpElementLocationValue() {
      return httpElementLocation_;
    }
    /**
     *
     *
     * <pre>
     * Required. The location of the API key.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.HttpElementLocation http_element_location = 3 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     *
     * @return The httpElementLocation.
     */
    @java.lang.Override
    public com.google.cloud.aiplatform.v1beta1.HttpElementLocation getHttpElementLocation() {
      com.google.cloud.aiplatform.v1beta1.HttpElementLocation result =
          com.google.cloud.aiplatform.v1beta1.HttpElementLocation.forNumber(httpElementLocation_);
      return result == null
          ? com.google.cloud.aiplatform.v1beta1.HttpElementLocation.UNRECOGNIZED
          : result;
    }

    private byte memoizedIsInitialized = -1;

    @java.lang.Override
    public final boolean isInitialized() {
      byte isInitialized = memoizedIsInitialized;
      if (isInitialized == 1) return true;
      if (isInitialized == 0) return false;

      memoizedIsInitialized = 1;
      return true;
    }

    @java.lang.Override
    public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(name_)) {
        com.google.protobuf.GeneratedMessageV3.writeString(output, 1, name_);
      }
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(apiKeySecret_)) {
        com.google.protobuf.GeneratedMessageV3.writeString(output, 2, apiKeySecret_);
      }
      if (httpElementLocation_
          != com.google.cloud.aiplatform.v1beta1.HttpElementLocation.HTTP_IN_UNSPECIFIED
              .getNumber()) {
        output.writeEnum(3, httpElementLocation_);
      }
      getUnknownFields().writeTo(output);
    }

    @java.lang.Override
    public int getSerializedSize() {
      int size = memoizedSize;
      if (size != -1) return size;

      size = 0;
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(name_)) {
        size += com.google.protobuf.GeneratedMessageV3.computeStringSize(1, name_);
      }
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(apiKeySecret_)) {
        size += com.google.protobuf.GeneratedMessageV3.computeStringSize(2, apiKeySecret_);
      }
      if (httpElementLocation_
          != com.google.cloud.aiplatform.v1beta1.HttpElementLocation.HTTP_IN_UNSPECIFIED
              .getNumber()) {
        size += com.google.protobuf.CodedOutputStream.computeEnumSize(3, httpElementLocation_);
      }
      size += getUnknownFields().getSerializedSize();
      memoizedSize = size;
      return size;
    }

    @java.lang.Override
    public boolean equals(final java.lang.Object obj) {
      if (obj == this) {
        return true;
      }
      if (!(obj instanceof com.google.cloud.aiplatform.v1beta1.AuthConfig.ApiKeyConfig)) {
        return super.equals(obj);
      }
      com.google.cloud.aiplatform.v1beta1.AuthConfig.ApiKeyConfig other =
          (com.google.cloud.aiplatform.v1beta1.AuthConfig.ApiKeyConfig) obj;

      if (!getName().equals(other.getName())) return false;
      if (!getApiKeySecret().equals(other.getApiKeySecret())) return false;
      if (httpElementLocation_ != other.httpElementLocation_) return false;
      if (!getUnknownFields().equals(other.getUnknownFields())) return false;
      return true;
    }

    @java.lang.Override
    public int hashCode() {
      if (memoizedHashCode != 0) {
        return memoizedHashCode;
      }
      int hash = 41;
      hash = (19 * hash) + getDescriptor().hashCode();
      hash = (37 * hash) + NAME_FIELD_NUMBER;
      hash = (53 * hash) + getName().hashCode();
      hash = (37 * hash) + API_KEY_SECRET_FIELD_NUMBER;
      hash = (53 * hash) + getApiKeySecret().hashCode();
      hash = (37 * hash) + HTTP_ELEMENT_LOCATION_FIELD_NUMBER;
      hash = (53 * hash) + httpElementLocation_;
      hash = (29 * hash) + getUnknownFields().hashCode();
      memoizedHashCode = hash;
      return hash;
    }

    public static com.google.cloud.aiplatform.v1beta1.AuthConfig.ApiKeyConfig parseFrom(
        java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.aiplatform.v1beta1.AuthConfig.ApiKeyConfig parseFrom(
        java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.aiplatform.v1beta1.AuthConfig.ApiKeyConfig parseFrom(
        com.google.protobuf.ByteString data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.aiplatform.v1beta1.AuthConfig.ApiKeyConfig parseFrom(
        com.google.protobuf.ByteString data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.aiplatform.v1beta1.AuthConfig.ApiKeyConfig parseFrom(byte[] data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.aiplatform.v1beta1.AuthConfig.ApiKeyConfig parseFrom(
        byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.aiplatform.v1beta1.AuthConfig.ApiKeyConfig parseFrom(
        java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.cloud.aiplatform.v1beta1.AuthConfig.ApiKeyConfig parseFrom(
        java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.cloud.aiplatform.v1beta1.AuthConfig.ApiKeyConfig parseDelimitedFrom(
        java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
    }

    public static com.google.cloud.aiplatform.v1beta1.AuthConfig.ApiKeyConfig parseDelimitedFrom(
        java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.cloud.aiplatform.v1beta1.AuthConfig.ApiKeyConfig parseFrom(
        com.google.protobuf.CodedInputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.cloud.aiplatform.v1beta1.AuthConfig.ApiKeyConfig parseFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    @java.lang.Override
    public Builder newBuilderForType() {
      return newBuilder();
    }

    public static Builder newBuilder() {
      return DEFAULT_INSTANCE.toBuilder();
    }

    public static Builder newBuilder(
        com.google.cloud.aiplatform.v1beta1.AuthConfig.ApiKeyConfig prototype) {
      return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }

    @java.lang.Override
    public Builder toBuilder() {
      return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
    }

    @java.lang.Override
    protected Builder newBuilderForType(
        com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      Builder builder = new Builder(parent);
      return builder;
    }
    /**
     *
     *
     * <pre>
     * Config for authentication with API key.
     * </pre>
     *
     * Protobuf type {@code google.cloud.aiplatform.v1beta1.AuthConfig.ApiKeyConfig}
     */
    public static final class Builder
        extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
        implements
        // @@protoc_insertion_point(builder_implements:google.cloud.aiplatform.v1beta1.AuthConfig.ApiKeyConfig)
        com.google.cloud.aiplatform.v1beta1.AuthConfig.ApiKeyConfigOrBuilder {
      public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
        return com.google.cloud.aiplatform.v1beta1.ExtensionProto
            .internal_static_google_cloud_aiplatform_v1beta1_AuthConfig_ApiKeyConfig_descriptor;
      }

      @java.lang.Override
      protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return com.google.cloud.aiplatform.v1beta1.ExtensionProto
            .internal_static_google_cloud_aiplatform_v1beta1_AuthConfig_ApiKeyConfig_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                com.google.cloud.aiplatform.v1beta1.AuthConfig.ApiKeyConfig.class,
                com.google.cloud.aiplatform.v1beta1.AuthConfig.ApiKeyConfig.Builder.class);
      }

      // Construct using com.google.cloud.aiplatform.v1beta1.AuthConfig.ApiKeyConfig.newBuilder()
      private Builder() {}

      private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
        super(parent);
      }

      @java.lang.Override
      public Builder clear() {
        super.clear();
        bitField0_ = 0;
        name_ = "";
        apiKeySecret_ = "";
        httpElementLocation_ = 0;
        return this;
      }

      @java.lang.Override
      public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
        return com.google.cloud.aiplatform.v1beta1.ExtensionProto
            .internal_static_google_cloud_aiplatform_v1beta1_AuthConfig_ApiKeyConfig_descriptor;
      }

      @java.lang.Override
      public com.google.cloud.aiplatform.v1beta1.AuthConfig.ApiKeyConfig
          getDefaultInstanceForType() {
        return com.google.cloud.aiplatform.v1beta1.AuthConfig.ApiKeyConfig.getDefaultInstance();
      }

      @java.lang.Override
      public com.google.cloud.aiplatform.v1beta1.AuthConfig.ApiKeyConfig build() {
        com.google.cloud.aiplatform.v1beta1.AuthConfig.ApiKeyConfig result = buildPartial();
        if (!result.isInitialized()) {
          throw newUninitializedMessageException(result);
        }
        return result;
      }

      @java.lang.Override
      public com.google.cloud.aiplatform.v1beta1.AuthConfig.ApiKeyConfig buildPartial() {
        com.google.cloud.aiplatform.v1beta1.AuthConfig.ApiKeyConfig result =
            new com.google.cloud.aiplatform.v1beta1.AuthConfig.ApiKeyConfig(this);
        if (bitField0_ != 0) {
          buildPartial0(result);
        }
        onBuilt();
        return result;
      }

      private void buildPartial0(
          com.google.cloud.aiplatform.v1beta1.AuthConfig.ApiKeyConfig result) {
        int from_bitField0_ = bitField0_;
        if (((from_bitField0_ & 0x00000001) != 0)) {
          result.name_ = name_;
        }
        if (((from_bitField0_ & 0x00000002) != 0)) {
          result.apiKeySecret_ = apiKeySecret_;
        }
        if (((from_bitField0_ & 0x00000004) != 0)) {
          result.httpElementLocation_ = httpElementLocation_;
        }
      }

      @java.lang.Override
      public Builder clone() {
        return super.clone();
      }

      @java.lang.Override
      public Builder setField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.setField(field, value);
      }

      @java.lang.Override
      public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
        return super.clearField(field);
      }

      @java.lang.Override
      public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
        return super.clearOneof(oneof);
      }

      @java.lang.Override
      public Builder setRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          int index,
          java.lang.Object value) {
        return super.setRepeatedField(field, index, value);
      }

      @java.lang.Override
      public Builder addRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.addRepeatedField(field, value);
      }

      @java.lang.Override
      public Builder mergeFrom(com.google.protobuf.Message other) {
        if (other instanceof com.google.cloud.aiplatform.v1beta1.AuthConfig.ApiKeyConfig) {
          return mergeFrom((com.google.cloud.aiplatform.v1beta1.AuthConfig.ApiKeyConfig) other);
        } else {
          super.mergeFrom(other);
          return this;
        }
      }

      public Builder mergeFrom(com.google.cloud.aiplatform.v1beta1.AuthConfig.ApiKeyConfig other) {
        if (other
            == com.google.cloud.aiplatform.v1beta1.AuthConfig.ApiKeyConfig.getDefaultInstance())
          return this;
        if (!other.getName().isEmpty()) {
          name_ = other.name_;
          bitField0_ |= 0x00000001;
          onChanged();
        }
        if (!other.getApiKeySecret().isEmpty()) {
          apiKeySecret_ = other.apiKeySecret_;
          bitField0_ |= 0x00000002;
          onChanged();
        }
        if (other.httpElementLocation_ != 0) {
          setHttpElementLocationValue(other.getHttpElementLocationValue());
        }
        this.mergeUnknownFields(other.getUnknownFields());
        onChanged();
        return this;
      }

      @java.lang.Override
      public final boolean isInitialized() {
        return true;
      }

      @java.lang.Override
      public Builder mergeFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        if (extensionRegistry == null) {
          throw new java.lang.NullPointerException();
        }
        try {
          boolean done = false;
          while (!done) {
            int tag = input.readTag();
            switch (tag) {
              case 0:
                done = true;
                break;
              case 10:
                {
                  name_ = input.readStringRequireUtf8();
                  bitField0_ |= 0x00000001;
                  break;
                } // case 10
              case 18:
                {
                  apiKeySecret_ = input.readStringRequireUtf8();
                  bitField0_ |= 0x00000002;
                  break;
                } // case 18
              case 24:
                {
                  httpElementLocation_ = input.readEnum();
                  bitField0_ |= 0x00000004;
                  break;
                } // case 24
              default:
                {
                  if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                    done = true; // was an endgroup tag
                  }
                  break;
                } // default:
            } // switch (tag)
          } // while (!done)
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          throw e.unwrapIOException();
        } finally {
          onChanged();
        } // finally
        return this;
      }

      private int bitField0_;

      private java.lang.Object name_ = "";
      /**
       *
       *
       * <pre>
       * Required. The parameter name of the API key.
       * E.g. If the API request is "https://example.com/act?api_key=&lt;API KEY&gt;",
       * "api_key" would be the parameter name.
       * </pre>
       *
       * <code>string name = 1 [(.google.api.field_behavior) = REQUIRED];</code>
       *
       * @return The name.
       */
      public java.lang.String getName() {
        java.lang.Object ref = name_;
        if (!(ref instanceof java.lang.String)) {
          com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
          java.lang.String s = bs.toStringUtf8();
          name_ = s;
          return s;
        } else {
          return (java.lang.String) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * Required. The parameter name of the API key.
       * E.g. If the API request is "https://example.com/act?api_key=&lt;API KEY&gt;",
       * "api_key" would be the parameter name.
       * </pre>
       *
       * <code>string name = 1 [(.google.api.field_behavior) = REQUIRED];</code>
       *
       * @return The bytes for name.
       */
      public com.google.protobuf.ByteString getNameBytes() {
        java.lang.Object ref = name_;
        if (ref instanceof String) {
          com.google.protobuf.ByteString b =
              com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
          name_ = b;
          return b;
        } else {
          return (com.google.protobuf.ByteString) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * Required. The parameter name of the API key.
       * E.g. If the API request is "https://example.com/act?api_key=&lt;API KEY&gt;",
       * "api_key" would be the parameter name.
       * </pre>
       *
       * <code>string name = 1 [(.google.api.field_behavior) = REQUIRED];</code>
       *
       * @param value The name to set.
       * @return This builder for chaining.
       */
      public Builder setName(java.lang.String value) {
        if (value == null) {
          throw new NullPointerException();
        }
        name_ = value;
        bitField0_ |= 0x00000001;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Required. The parameter name of the API key.
       * E.g. If the API request is "https://example.com/act?api_key=&lt;API KEY&gt;",
       * "api_key" would be the parameter name.
       * </pre>
       *
       * <code>string name = 1 [(.google.api.field_behavior) = REQUIRED];</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearName() {
        name_ = getDefaultInstance().getName();
        bitField0_ = (bitField0_ & ~0x00000001);
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Required. The parameter name of the API key.
       * E.g. If the API request is "https://example.com/act?api_key=&lt;API KEY&gt;",
       * "api_key" would be the parameter name.
       * </pre>
       *
       * <code>string name = 1 [(.google.api.field_behavior) = REQUIRED];</code>
       *
       * @param value The bytes for name to set.
       * @return This builder for chaining.
       */
      public Builder setNameBytes(com.google.protobuf.ByteString value) {
        if (value == null) {
          throw new NullPointerException();
        }
        checkByteStringIsUtf8(value);
        name_ = value;
        bitField0_ |= 0x00000001;
        onChanged();
        return this;
      }

      private java.lang.Object apiKeySecret_ = "";
      /**
       *
       *
       * <pre>
       * Required. The name of the SecretManager secret version resource storing
       * the API key. Format:
       * `projects/{project}/secrets/{secrete}/versions/{version}`
       *
       * - If specified, the `secretmanager.versions.access` permission should be
       * granted to Vertex AI Extension Service Agent
       * (https://cloud.google.com/vertex-ai/docs/general/access-control#service-agents)
       * on the specified resource.
       * </pre>
       *
       * <code>
       * string api_key_secret = 2 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
       * </code>
       *
       * @return The apiKeySecret.
       */
      public java.lang.String getApiKeySecret() {
        java.lang.Object ref = apiKeySecret_;
        if (!(ref instanceof java.lang.String)) {
          com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
          java.lang.String s = bs.toStringUtf8();
          apiKeySecret_ = s;
          return s;
        } else {
          return (java.lang.String) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * Required. The name of the SecretManager secret version resource storing
       * the API key. Format:
       * `projects/{project}/secrets/{secrete}/versions/{version}`
       *
       * - If specified, the `secretmanager.versions.access` permission should be
       * granted to Vertex AI Extension Service Agent
       * (https://cloud.google.com/vertex-ai/docs/general/access-control#service-agents)
       * on the specified resource.
       * </pre>
       *
       * <code>
       * string api_key_secret = 2 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
       * </code>
       *
       * @return The bytes for apiKeySecret.
       */
      public com.google.protobuf.ByteString getApiKeySecretBytes() {
        java.lang.Object ref = apiKeySecret_;
        if (ref instanceof String) {
          com.google.protobuf.ByteString b =
              com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
          apiKeySecret_ = b;
          return b;
        } else {
          return (com.google.protobuf.ByteString) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * Required. The name of the SecretManager secret version resource storing
       * the API key. Format:
       * `projects/{project}/secrets/{secrete}/versions/{version}`
       *
       * - If specified, the `secretmanager.versions.access` permission should be
       * granted to Vertex AI Extension Service Agent
       * (https://cloud.google.com/vertex-ai/docs/general/access-control#service-agents)
       * on the specified resource.
       * </pre>
       *
       * <code>
       * string api_key_secret = 2 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
       * </code>
       *
       * @param value The apiKeySecret to set.
       * @return This builder for chaining.
       */
      public Builder setApiKeySecret(java.lang.String value) {
        if (value == null) {
          throw new NullPointerException();
        }
        apiKeySecret_ = value;
        bitField0_ |= 0x00000002;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Required. The name of the SecretManager secret version resource storing
       * the API key. Format:
       * `projects/{project}/secrets/{secrete}/versions/{version}`
       *
       * - If specified, the `secretmanager.versions.access` permission should be
       * granted to Vertex AI Extension Service Agent
       * (https://cloud.google.com/vertex-ai/docs/general/access-control#service-agents)
       * on the specified resource.
       * </pre>
       *
       * <code>
       * string api_key_secret = 2 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
       * </code>
       *
       * @return This builder for chaining.
       */
      public Builder clearApiKeySecret() {
        apiKeySecret_ = getDefaultInstance().getApiKeySecret();
        bitField0_ = (bitField0_ & ~0x00000002);
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Required. The name of the SecretManager secret version resource storing
       * the API key. Format:
       * `projects/{project}/secrets/{secrete}/versions/{version}`
       *
       * - If specified, the `secretmanager.versions.access` permission should be
       * granted to Vertex AI Extension Service Agent
       * (https://cloud.google.com/vertex-ai/docs/general/access-control#service-agents)
       * on the specified resource.
       * </pre>
       *
       * <code>
       * string api_key_secret = 2 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
       * </code>
       *
       * @param value The bytes for apiKeySecret to set.
       * @return This builder for chaining.
       */
      public Builder setApiKeySecretBytes(com.google.protobuf.ByteString value) {
        if (value == null) {
          throw new NullPointerException();
        }
        checkByteStringIsUtf8(value);
        apiKeySecret_ = value;
        bitField0_ |= 0x00000002;
        onChanged();
        return this;
      }

      private int httpElementLocation_ = 0;
      /**
       *
       *
       * <pre>
       * Required. The location of the API key.
       * </pre>
       *
       * <code>
       * .google.cloud.aiplatform.v1beta1.HttpElementLocation http_element_location = 3 [(.google.api.field_behavior) = REQUIRED];
       * </code>
       *
       * @return The enum numeric value on the wire for httpElementLocation.
       */
      @java.lang.Override
      public int getHttpElementLocationValue() {
        return httpElementLocation_;
      }
      /**
       *
       *
       * <pre>
       * Required. The location of the API key.
       * </pre>
       *
       * <code>
       * .google.cloud.aiplatform.v1beta1.HttpElementLocation http_element_location = 3 [(.google.api.field_behavior) = REQUIRED];
       * </code>
       *
       * @param value The enum numeric value on the wire for httpElementLocation to set.
       * @return This builder for chaining.
       */
      public Builder setHttpElementLocationValue(int value) {
        httpElementLocation_ = value;
        bitField0_ |= 0x00000004;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Required. The location of the API key.
       * </pre>
       *
       * <code>
       * .google.cloud.aiplatform.v1beta1.HttpElementLocation http_element_location = 3 [(.google.api.field_behavior) = REQUIRED];
       * </code>
       *
       * @return The httpElementLocation.
       */
      @java.lang.Override
      public com.google.cloud.aiplatform.v1beta1.HttpElementLocation getHttpElementLocation() {
        com.google.cloud.aiplatform.v1beta1.HttpElementLocation result =
            com.google.cloud.aiplatform.v1beta1.HttpElementLocation.forNumber(httpElementLocation_);
        return result == null
            ? com.google.cloud.aiplatform.v1beta1.HttpElementLocation.UNRECOGNIZED
            : result;
      }
      /**
       *
       *
       * <pre>
       * Required. The location of the API key.
       * </pre>
       *
       * <code>
       * .google.cloud.aiplatform.v1beta1.HttpElementLocation http_element_location = 3 [(.google.api.field_behavior) = REQUIRED];
       * </code>
       *
       * @param value The httpElementLocation to set.
       * @return This builder for chaining.
       */
      public Builder setHttpElementLocation(
          com.google.cloud.aiplatform.v1beta1.HttpElementLocation value) {
        if (value == null) {
          throw new NullPointerException();
        }
        bitField0_ |= 0x00000004;
        httpElementLocation_ = value.getNumber();
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Required. The location of the API key.
       * </pre>
       *
       * <code>
       * .google.cloud.aiplatform.v1beta1.HttpElementLocation http_element_location = 3 [(.google.api.field_behavior) = REQUIRED];
       * </code>
       *
       * @return This builder for chaining.
       */
      public Builder clearHttpElementLocation() {
        bitField0_ = (bitField0_ & ~0x00000004);
        httpElementLocation_ = 0;
        onChanged();
        return this;
      }

      @java.lang.Override
      public final Builder setUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.setUnknownFields(unknownFields);
      }

      @java.lang.Override
      public final Builder mergeUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.mergeUnknownFields(unknownFields);
      }

      // @@protoc_insertion_point(builder_scope:google.cloud.aiplatform.v1beta1.AuthConfig.ApiKeyConfig)
    }

    // @@protoc_insertion_point(class_scope:google.cloud.aiplatform.v1beta1.AuthConfig.ApiKeyConfig)
    private static final com.google.cloud.aiplatform.v1beta1.AuthConfig.ApiKeyConfig
        DEFAULT_INSTANCE;

    static {
      DEFAULT_INSTANCE = new com.google.cloud.aiplatform.v1beta1.AuthConfig.ApiKeyConfig();
    }

    public static com.google.cloud.aiplatform.v1beta1.AuthConfig.ApiKeyConfig getDefaultInstance() {
      return DEFAULT_INSTANCE;
    }

    private static final com.google.protobuf.Parser<ApiKeyConfig> PARSER =
        new com.google.protobuf.AbstractParser<ApiKeyConfig>() {
          @java.lang.Override
          public ApiKeyConfig parsePartialFrom(
              com.google.protobuf.CodedInputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
            Builder builder = newBuilder();
            try {
              builder.mergeFrom(input, extensionRegistry);
            } catch (com.google.protobuf.InvalidProtocolBufferException e) {
              throw e.setUnfinishedMessage(builder.buildPartial());
            } catch (com.google.protobuf.UninitializedMessageException e) {
              throw e.asInvalidProtocolBufferException()
                  .setUnfinishedMessage(builder.buildPartial());
            } catch (java.io.IOException e) {
              throw new com.google.protobuf.InvalidProtocolBufferException(e)
                  .setUnfinishedMessage(builder.buildPartial());
            }
            return builder.buildPartial();
          }
        };

    public static com.google.protobuf.Parser<ApiKeyConfig> parser() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.protobuf.Parser<ApiKeyConfig> getParserForType() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.cloud.aiplatform.v1beta1.AuthConfig.ApiKeyConfig getDefaultInstanceForType() {
      return DEFAULT_INSTANCE;
    }
  }

  public interface HttpBasicAuthConfigOrBuilder
      extends
      // @@protoc_insertion_point(interface_extends:google.cloud.aiplatform.v1beta1.AuthConfig.HttpBasicAuthConfig)
      com.google.protobuf.MessageOrBuilder {

    /**
     *
     *
     * <pre>
     * Required. The name of the SecretManager secret version resource storing
     * the base64 encoded credentials. Format:
     * `projects/{project}/secrets/{secrete}/versions/{version}`
     *
     * - If specified, the `secretmanager.versions.access` permission should be
     * granted to Vertex AI Extension Service Agent
     * (https://cloud.google.com/vertex-ai/docs/general/access-control#service-agents)
     * on the specified resource.
     * </pre>
     *
     * <code>
     * string credential_secret = 2 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @return The credentialSecret.
     */
    java.lang.String getCredentialSecret();
    /**
     *
     *
     * <pre>
     * Required. The name of the SecretManager secret version resource storing
     * the base64 encoded credentials. Format:
     * `projects/{project}/secrets/{secrete}/versions/{version}`
     *
     * - If specified, the `secretmanager.versions.access` permission should be
     * granted to Vertex AI Extension Service Agent
     * (https://cloud.google.com/vertex-ai/docs/general/access-control#service-agents)
     * on the specified resource.
     * </pre>
     *
     * <code>
     * string credential_secret = 2 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @return The bytes for credentialSecret.
     */
    com.google.protobuf.ByteString getCredentialSecretBytes();
  }
  /**
   *
   *
   * <pre>
   * Config for HTTP Basic Authentication.
   * </pre>
   *
   * Protobuf type {@code google.cloud.aiplatform.v1beta1.AuthConfig.HttpBasicAuthConfig}
   */
  public static final class HttpBasicAuthConfig extends com.google.protobuf.GeneratedMessageV3
      implements
      // @@protoc_insertion_point(message_implements:google.cloud.aiplatform.v1beta1.AuthConfig.HttpBasicAuthConfig)
      HttpBasicAuthConfigOrBuilder {
    private static final long serialVersionUID = 0L;
    // Use HttpBasicAuthConfig.newBuilder() to construct.
    private HttpBasicAuthConfig(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
      super(builder);
    }

    private HttpBasicAuthConfig() {
      credentialSecret_ = "";
    }

    @java.lang.Override
    @SuppressWarnings({"unused"})
    protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
      return new HttpBasicAuthConfig();
    }

    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.aiplatform.v1beta1.ExtensionProto
          .internal_static_google_cloud_aiplatform_v1beta1_AuthConfig_HttpBasicAuthConfig_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.aiplatform.v1beta1.ExtensionProto
          .internal_static_google_cloud_aiplatform_v1beta1_AuthConfig_HttpBasicAuthConfig_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.aiplatform.v1beta1.AuthConfig.HttpBasicAuthConfig.class,
              com.google.cloud.aiplatform.v1beta1.AuthConfig.HttpBasicAuthConfig.Builder.class);
    }

    public static final int CREDENTIAL_SECRET_FIELD_NUMBER = 2;

    @SuppressWarnings("serial")
    private volatile java.lang.Object credentialSecret_ = "";
    /**
     *
     *
     * <pre>
     * Required. The name of the SecretManager secret version resource storing
     * the base64 encoded credentials. Format:
     * `projects/{project}/secrets/{secrete}/versions/{version}`
     *
     * - If specified, the `secretmanager.versions.access` permission should be
     * granted to Vertex AI Extension Service Agent
     * (https://cloud.google.com/vertex-ai/docs/general/access-control#service-agents)
     * on the specified resource.
     * </pre>
     *
     * <code>
     * string credential_secret = 2 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @return The credentialSecret.
     */
    @java.lang.Override
    public java.lang.String getCredentialSecret() {
      java.lang.Object ref = credentialSecret_;
      if (ref instanceof java.lang.String) {
        return (java.lang.String) ref;
      } else {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        credentialSecret_ = s;
        return s;
      }
    }
    /**
     *
     *
     * <pre>
     * Required. The name of the SecretManager secret version resource storing
     * the base64 encoded credentials. Format:
     * `projects/{project}/secrets/{secrete}/versions/{version}`
     *
     * - If specified, the `secretmanager.versions.access` permission should be
     * granted to Vertex AI Extension Service Agent
     * (https://cloud.google.com/vertex-ai/docs/general/access-control#service-agents)
     * on the specified resource.
     * </pre>
     *
     * <code>
     * string credential_secret = 2 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @return The bytes for credentialSecret.
     */
    @java.lang.Override
    public com.google.protobuf.ByteString getCredentialSecretBytes() {
      java.lang.Object ref = credentialSecret_;
      if (ref instanceof java.lang.String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        credentialSecret_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    private byte memoizedIsInitialized = -1;

    @java.lang.Override
    public final boolean isInitialized() {
      byte isInitialized = memoizedIsInitialized;
      if (isInitialized == 1) return true;
      if (isInitialized == 0) return false;

      memoizedIsInitialized = 1;
      return true;
    }

    @java.lang.Override
    public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(credentialSecret_)) {
        com.google.protobuf.GeneratedMessageV3.writeString(output, 2, credentialSecret_);
      }
      getUnknownFields().writeTo(output);
    }

    @java.lang.Override
    public int getSerializedSize() {
      int size = memoizedSize;
      if (size != -1) return size;

      size = 0;
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(credentialSecret_)) {
        size += com.google.protobuf.GeneratedMessageV3.computeStringSize(2, credentialSecret_);
      }
      size += getUnknownFields().getSerializedSize();
      memoizedSize = size;
      return size;
    }

    @java.lang.Override
    public boolean equals(final java.lang.Object obj) {
      if (obj == this) {
        return true;
      }
      if (!(obj instanceof com.google.cloud.aiplatform.v1beta1.AuthConfig.HttpBasicAuthConfig)) {
        return super.equals(obj);
      }
      com.google.cloud.aiplatform.v1beta1.AuthConfig.HttpBasicAuthConfig other =
          (com.google.cloud.aiplatform.v1beta1.AuthConfig.HttpBasicAuthConfig) obj;

      if (!getCredentialSecret().equals(other.getCredentialSecret())) return false;
      if (!getUnknownFields().equals(other.getUnknownFields())) return false;
      return true;
    }

    @java.lang.Override
    public int hashCode() {
      if (memoizedHashCode != 0) {
        return memoizedHashCode;
      }
      int hash = 41;
      hash = (19 * hash) + getDescriptor().hashCode();
      hash = (37 * hash) + CREDENTIAL_SECRET_FIELD_NUMBER;
      hash = (53 * hash) + getCredentialSecret().hashCode();
      hash = (29 * hash) + getUnknownFields().hashCode();
      memoizedHashCode = hash;
      return hash;
    }

    public static com.google.cloud.aiplatform.v1beta1.AuthConfig.HttpBasicAuthConfig parseFrom(
        java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.aiplatform.v1beta1.AuthConfig.HttpBasicAuthConfig parseFrom(
        java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.aiplatform.v1beta1.AuthConfig.HttpBasicAuthConfig parseFrom(
        com.google.protobuf.ByteString data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.aiplatform.v1beta1.AuthConfig.HttpBasicAuthConfig parseFrom(
        com.google.protobuf.ByteString data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.aiplatform.v1beta1.AuthConfig.HttpBasicAuthConfig parseFrom(
        byte[] data) throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.aiplatform.v1beta1.AuthConfig.HttpBasicAuthConfig parseFrom(
        byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.aiplatform.v1beta1.AuthConfig.HttpBasicAuthConfig parseFrom(
        java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.cloud.aiplatform.v1beta1.AuthConfig.HttpBasicAuthConfig parseFrom(
        java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.cloud.aiplatform.v1beta1.AuthConfig.HttpBasicAuthConfig
        parseDelimitedFrom(java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
    }

    public static com.google.cloud.aiplatform.v1beta1.AuthConfig.HttpBasicAuthConfig
        parseDelimitedFrom(
            java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.cloud.aiplatform.v1beta1.AuthConfig.HttpBasicAuthConfig parseFrom(
        com.google.protobuf.CodedInputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.cloud.aiplatform.v1beta1.AuthConfig.HttpBasicAuthConfig parseFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    @java.lang.Override
    public Builder newBuilderForType() {
      return newBuilder();
    }

    public static Builder newBuilder() {
      return DEFAULT_INSTANCE.toBuilder();
    }

    public static Builder newBuilder(
        com.google.cloud.aiplatform.v1beta1.AuthConfig.HttpBasicAuthConfig prototype) {
      return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }

    @java.lang.Override
    public Builder toBuilder() {
      return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
    }

    @java.lang.Override
    protected Builder newBuilderForType(
        com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      Builder builder = new Builder(parent);
      return builder;
    }
    /**
     *
     *
     * <pre>
     * Config for HTTP Basic Authentication.
     * </pre>
     *
     * Protobuf type {@code google.cloud.aiplatform.v1beta1.AuthConfig.HttpBasicAuthConfig}
     */
    public static final class Builder
        extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
        implements
        // @@protoc_insertion_point(builder_implements:google.cloud.aiplatform.v1beta1.AuthConfig.HttpBasicAuthConfig)
        com.google.cloud.aiplatform.v1beta1.AuthConfig.HttpBasicAuthConfigOrBuilder {
      public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
        return com.google.cloud.aiplatform.v1beta1.ExtensionProto
            .internal_static_google_cloud_aiplatform_v1beta1_AuthConfig_HttpBasicAuthConfig_descriptor;
      }

      @java.lang.Override
      protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return com.google.cloud.aiplatform.v1beta1.ExtensionProto
            .internal_static_google_cloud_aiplatform_v1beta1_AuthConfig_HttpBasicAuthConfig_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                com.google.cloud.aiplatform.v1beta1.AuthConfig.HttpBasicAuthConfig.class,
                com.google.cloud.aiplatform.v1beta1.AuthConfig.HttpBasicAuthConfig.Builder.class);
      }

      // Construct using
      // com.google.cloud.aiplatform.v1beta1.AuthConfig.HttpBasicAuthConfig.newBuilder()
      private Builder() {}

      private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
        super(parent);
      }

      @java.lang.Override
      public Builder clear() {
        super.clear();
        bitField0_ = 0;
        credentialSecret_ = "";
        return this;
      }

      @java.lang.Override
      public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
        return com.google.cloud.aiplatform.v1beta1.ExtensionProto
            .internal_static_google_cloud_aiplatform_v1beta1_AuthConfig_HttpBasicAuthConfig_descriptor;
      }

      @java.lang.Override
      public com.google.cloud.aiplatform.v1beta1.AuthConfig.HttpBasicAuthConfig
          getDefaultInstanceForType() {
        return com.google.cloud.aiplatform.v1beta1.AuthConfig.HttpBasicAuthConfig
            .getDefaultInstance();
      }

      @java.lang.Override
      public com.google.cloud.aiplatform.v1beta1.AuthConfig.HttpBasicAuthConfig build() {
        com.google.cloud.aiplatform.v1beta1.AuthConfig.HttpBasicAuthConfig result = buildPartial();
        if (!result.isInitialized()) {
          throw newUninitializedMessageException(result);
        }
        return result;
      }

      @java.lang.Override
      public com.google.cloud.aiplatform.v1beta1.AuthConfig.HttpBasicAuthConfig buildPartial() {
        com.google.cloud.aiplatform.v1beta1.AuthConfig.HttpBasicAuthConfig result =
            new com.google.cloud.aiplatform.v1beta1.AuthConfig.HttpBasicAuthConfig(this);
        if (bitField0_ != 0) {
          buildPartial0(result);
        }
        onBuilt();
        return result;
      }

      private void buildPartial0(
          com.google.cloud.aiplatform.v1beta1.AuthConfig.HttpBasicAuthConfig result) {
        int from_bitField0_ = bitField0_;
        if (((from_bitField0_ & 0x00000001) != 0)) {
          result.credentialSecret_ = credentialSecret_;
        }
      }

      @java.lang.Override
      public Builder clone() {
        return super.clone();
      }

      @java.lang.Override
      public Builder setField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.setField(field, value);
      }

      @java.lang.Override
      public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
        return super.clearField(field);
      }

      @java.lang.Override
      public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
        return super.clearOneof(oneof);
      }

      @java.lang.Override
      public Builder setRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          int index,
          java.lang.Object value) {
        return super.setRepeatedField(field, index, value);
      }

      @java.lang.Override
      public Builder addRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.addRepeatedField(field, value);
      }

      @java.lang.Override
      public Builder mergeFrom(com.google.protobuf.Message other) {
        if (other instanceof com.google.cloud.aiplatform.v1beta1.AuthConfig.HttpBasicAuthConfig) {
          return mergeFrom(
              (com.google.cloud.aiplatform.v1beta1.AuthConfig.HttpBasicAuthConfig) other);
        } else {
          super.mergeFrom(other);
          return this;
        }
      }

      public Builder mergeFrom(
          com.google.cloud.aiplatform.v1beta1.AuthConfig.HttpBasicAuthConfig other) {
        if (other
            == com.google.cloud.aiplatform.v1beta1.AuthConfig.HttpBasicAuthConfig
                .getDefaultInstance()) return this;
        if (!other.getCredentialSecret().isEmpty()) {
          credentialSecret_ = other.credentialSecret_;
          bitField0_ |= 0x00000001;
          onChanged();
        }
        this.mergeUnknownFields(other.getUnknownFields());
        onChanged();
        return this;
      }

      @java.lang.Override
      public final boolean isInitialized() {
        return true;
      }

      @java.lang.Override
      public Builder mergeFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        if (extensionRegistry == null) {
          throw new java.lang.NullPointerException();
        }
        try {
          boolean done = false;
          while (!done) {
            int tag = input.readTag();
            switch (tag) {
              case 0:
                done = true;
                break;
              case 18:
                {
                  credentialSecret_ = input.readStringRequireUtf8();
                  bitField0_ |= 0x00000001;
                  break;
                } // case 18
              default:
                {
                  if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                    done = true; // was an endgroup tag
                  }
                  break;
                } // default:
            } // switch (tag)
          } // while (!done)
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          throw e.unwrapIOException();
        } finally {
          onChanged();
        } // finally
        return this;
      }

      private int bitField0_;

      private java.lang.Object credentialSecret_ = "";
      /**
       *
       *
       * <pre>
       * Required. The name of the SecretManager secret version resource storing
       * the base64 encoded credentials. Format:
       * `projects/{project}/secrets/{secrete}/versions/{version}`
       *
       * - If specified, the `secretmanager.versions.access` permission should be
       * granted to Vertex AI Extension Service Agent
       * (https://cloud.google.com/vertex-ai/docs/general/access-control#service-agents)
       * on the specified resource.
       * </pre>
       *
       * <code>
       * string credential_secret = 2 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
       * </code>
       *
       * @return The credentialSecret.
       */
      public java.lang.String getCredentialSecret() {
        java.lang.Object ref = credentialSecret_;
        if (!(ref instanceof java.lang.String)) {
          com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
          java.lang.String s = bs.toStringUtf8();
          credentialSecret_ = s;
          return s;
        } else {
          return (java.lang.String) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * Required. The name of the SecretManager secret version resource storing
       * the base64 encoded credentials. Format:
       * `projects/{project}/secrets/{secrete}/versions/{version}`
       *
       * - If specified, the `secretmanager.versions.access` permission should be
       * granted to Vertex AI Extension Service Agent
       * (https://cloud.google.com/vertex-ai/docs/general/access-control#service-agents)
       * on the specified resource.
       * </pre>
       *
       * <code>
       * string credential_secret = 2 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
       * </code>
       *
       * @return The bytes for credentialSecret.
       */
      public com.google.protobuf.ByteString getCredentialSecretBytes() {
        java.lang.Object ref = credentialSecret_;
        if (ref instanceof String) {
          com.google.protobuf.ByteString b =
              com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
          credentialSecret_ = b;
          return b;
        } else {
          return (com.google.protobuf.ByteString) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * Required. The name of the SecretManager secret version resource storing
       * the base64 encoded credentials. Format:
       * `projects/{project}/secrets/{secrete}/versions/{version}`
       *
       * - If specified, the `secretmanager.versions.access` permission should be
       * granted to Vertex AI Extension Service Agent
       * (https://cloud.google.com/vertex-ai/docs/general/access-control#service-agents)
       * on the specified resource.
       * </pre>
       *
       * <code>
       * string credential_secret = 2 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
       * </code>
       *
       * @param value The credentialSecret to set.
       * @return This builder for chaining.
       */
      public Builder setCredentialSecret(java.lang.String value) {
        if (value == null) {
          throw new NullPointerException();
        }
        credentialSecret_ = value;
        bitField0_ |= 0x00000001;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Required. The name of the SecretManager secret version resource storing
       * the base64 encoded credentials. Format:
       * `projects/{project}/secrets/{secrete}/versions/{version}`
       *
       * - If specified, the `secretmanager.versions.access` permission should be
       * granted to Vertex AI Extension Service Agent
       * (https://cloud.google.com/vertex-ai/docs/general/access-control#service-agents)
       * on the specified resource.
       * </pre>
       *
       * <code>
       * string credential_secret = 2 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
       * </code>
       *
       * @return This builder for chaining.
       */
      public Builder clearCredentialSecret() {
        credentialSecret_ = getDefaultInstance().getCredentialSecret();
        bitField0_ = (bitField0_ & ~0x00000001);
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Required. The name of the SecretManager secret version resource storing
       * the base64 encoded credentials. Format:
       * `projects/{project}/secrets/{secrete}/versions/{version}`
       *
       * - If specified, the `secretmanager.versions.access` permission should be
       * granted to Vertex AI Extension Service Agent
       * (https://cloud.google.com/vertex-ai/docs/general/access-control#service-agents)
       * on the specified resource.
       * </pre>
       *
       * <code>
       * string credential_secret = 2 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
       * </code>
       *
       * @param value The bytes for credentialSecret to set.
       * @return This builder for chaining.
       */
      public Builder setCredentialSecretBytes(com.google.protobuf.ByteString value) {
        if (value == null) {
          throw new NullPointerException();
        }
        checkByteStringIsUtf8(value);
        credentialSecret_ = value;
        bitField0_ |= 0x00000001;
        onChanged();
        return this;
      }

      @java.lang.Override
      public final Builder setUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.setUnknownFields(unknownFields);
      }

      @java.lang.Override
      public final Builder mergeUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.mergeUnknownFields(unknownFields);
      }

      // @@protoc_insertion_point(builder_scope:google.cloud.aiplatform.v1beta1.AuthConfig.HttpBasicAuthConfig)
    }

    // @@protoc_insertion_point(class_scope:google.cloud.aiplatform.v1beta1.AuthConfig.HttpBasicAuthConfig)
    private static final com.google.cloud.aiplatform.v1beta1.AuthConfig.HttpBasicAuthConfig
        DEFAULT_INSTANCE;

    static {
      DEFAULT_INSTANCE = new com.google.cloud.aiplatform.v1beta1.AuthConfig.HttpBasicAuthConfig();
    }

    public static com.google.cloud.aiplatform.v1beta1.AuthConfig.HttpBasicAuthConfig
        getDefaultInstance() {
      return DEFAULT_INSTANCE;
    }

    private static final com.google.protobuf.Parser<HttpBasicAuthConfig> PARSER =
        new com.google.protobuf.AbstractParser<HttpBasicAuthConfig>() {
          @java.lang.Override
          public HttpBasicAuthConfig parsePartialFrom(
              com.google.protobuf.CodedInputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
            Builder builder = newBuilder();
            try {
              builder.mergeFrom(input, extensionRegistry);
            } catch (com.google.protobuf.InvalidProtocolBufferException e) {
              throw e.setUnfinishedMessage(builder.buildPartial());
            } catch (com.google.protobuf.UninitializedMessageException e) {
              throw e.asInvalidProtocolBufferException()
                  .setUnfinishedMessage(builder.buildPartial());
            } catch (java.io.IOException e) {
              throw new com.google.protobuf.InvalidProtocolBufferException(e)
                  .setUnfinishedMessage(builder.buildPartial());
            }
            return builder.buildPartial();
          }
        };

    public static com.google.protobuf.Parser<HttpBasicAuthConfig> parser() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.protobuf.Parser<HttpBasicAuthConfig> getParserForType() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.cloud.aiplatform.v1beta1.AuthConfig.HttpBasicAuthConfig
        getDefaultInstanceForType() {
      return DEFAULT_INSTANCE;
    }
  }

  public interface GoogleServiceAccountConfigOrBuilder
      extends
      // @@protoc_insertion_point(interface_extends:google.cloud.aiplatform.v1beta1.AuthConfig.GoogleServiceAccountConfig)
      com.google.protobuf.MessageOrBuilder {

    /**
     *
     *
     * <pre>
     * Optional. The service account that the extension execution service runs
     * as.
     *
     * - If the service account is specified,
     * the `iam.serviceAccounts.getAccessToken` permission should be granted to
     * Vertex AI Extension Service Agent
     * (https://cloud.google.com/vertex-ai/docs/general/access-control#service-agents)
     * on the specified service account.
     *
     * - If not specified, the Vertex AI Extension Service Agent
     * will be used to execute the Extension.
     * </pre>
     *
     * <code>string service_account = 1 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return The serviceAccount.
     */
    java.lang.String getServiceAccount();
    /**
     *
     *
     * <pre>
     * Optional. The service account that the extension execution service runs
     * as.
     *
     * - If the service account is specified,
     * the `iam.serviceAccounts.getAccessToken` permission should be granted to
     * Vertex AI Extension Service Agent
     * (https://cloud.google.com/vertex-ai/docs/general/access-control#service-agents)
     * on the specified service account.
     *
     * - If not specified, the Vertex AI Extension Service Agent
     * will be used to execute the Extension.
     * </pre>
     *
     * <code>string service_account = 1 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return The bytes for serviceAccount.
     */
    com.google.protobuf.ByteString getServiceAccountBytes();
  }
  /**
   *
   *
   * <pre>
   * Config for Google Service Account Authentication.
   * </pre>
   *
   * Protobuf type {@code google.cloud.aiplatform.v1beta1.AuthConfig.GoogleServiceAccountConfig}
   */
  public static final class GoogleServiceAccountConfig
      extends com.google.protobuf.GeneratedMessageV3
      implements
      // @@protoc_insertion_point(message_implements:google.cloud.aiplatform.v1beta1.AuthConfig.GoogleServiceAccountConfig)
      GoogleServiceAccountConfigOrBuilder {
    private static final long serialVersionUID = 0L;
    // Use GoogleServiceAccountConfig.newBuilder() to construct.
    private GoogleServiceAccountConfig(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
      super(builder);
    }

    private GoogleServiceAccountConfig() {
      serviceAccount_ = "";
    }

    @java.lang.Override
    @SuppressWarnings({"unused"})
    protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
      return new GoogleServiceAccountConfig();
    }

    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.aiplatform.v1beta1.ExtensionProto
          .internal_static_google_cloud_aiplatform_v1beta1_AuthConfig_GoogleServiceAccountConfig_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.aiplatform.v1beta1.ExtensionProto
          .internal_static_google_cloud_aiplatform_v1beta1_AuthConfig_GoogleServiceAccountConfig_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.aiplatform.v1beta1.AuthConfig.GoogleServiceAccountConfig.class,
              com.google.cloud.aiplatform.v1beta1.AuthConfig.GoogleServiceAccountConfig.Builder
                  .class);
    }

    public static final int SERVICE_ACCOUNT_FIELD_NUMBER = 1;

    @SuppressWarnings("serial")
    private volatile java.lang.Object serviceAccount_ = "";
    /**
     *
     *
     * <pre>
     * Optional. The service account that the extension execution service runs
     * as.
     *
     * - If the service account is specified,
     * the `iam.serviceAccounts.getAccessToken` permission should be granted to
     * Vertex AI Extension Service Agent
     * (https://cloud.google.com/vertex-ai/docs/general/access-control#service-agents)
     * on the specified service account.
     *
     * - If not specified, the Vertex AI Extension Service Agent
     * will be used to execute the Extension.
     * </pre>
     *
     * <code>string service_account = 1 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return The serviceAccount.
     */
    @java.lang.Override
    public java.lang.String getServiceAccount() {
      java.lang.Object ref = serviceAccount_;
      if (ref instanceof java.lang.String) {
        return (java.lang.String) ref;
      } else {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        serviceAccount_ = s;
        return s;
      }
    }
    /**
     *
     *
     * <pre>
     * Optional. The service account that the extension execution service runs
     * as.
     *
     * - If the service account is specified,
     * the `iam.serviceAccounts.getAccessToken` permission should be granted to
     * Vertex AI Extension Service Agent
     * (https://cloud.google.com/vertex-ai/docs/general/access-control#service-agents)
     * on the specified service account.
     *
     * - If not specified, the Vertex AI Extension Service Agent
     * will be used to execute the Extension.
     * </pre>
     *
     * <code>string service_account = 1 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return The bytes for serviceAccount.
     */
    @java.lang.Override
    public com.google.protobuf.ByteString getServiceAccountBytes() {
      java.lang.Object ref = serviceAccount_;
      if (ref instanceof java.lang.String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        serviceAccount_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    private byte memoizedIsInitialized = -1;

    @java.lang.Override
    public final boolean isInitialized() {
      byte isInitialized = memoizedIsInitialized;
      if (isInitialized == 1) return true;
      if (isInitialized == 0) return false;

      memoizedIsInitialized = 1;
      return true;
    }

    @java.lang.Override
    public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(serviceAccount_)) {
        com.google.protobuf.GeneratedMessageV3.writeString(output, 1, serviceAccount_);
      }
      getUnknownFields().writeTo(output);
    }

    @java.lang.Override
    public int getSerializedSize() {
      int size = memoizedSize;
      if (size != -1) return size;

      size = 0;
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(serviceAccount_)) {
        size += com.google.protobuf.GeneratedMessageV3.computeStringSize(1, serviceAccount_);
      }
      size += getUnknownFields().getSerializedSize();
      memoizedSize = size;
      return size;
    }

    @java.lang.Override
    public boolean equals(final java.lang.Object obj) {
      if (obj == this) {
        return true;
      }
      if (!(obj
          instanceof com.google.cloud.aiplatform.v1beta1.AuthConfig.GoogleServiceAccountConfig)) {
        return super.equals(obj);
      }
      com.google.cloud.aiplatform.v1beta1.AuthConfig.GoogleServiceAccountConfig other =
          (com.google.cloud.aiplatform.v1beta1.AuthConfig.GoogleServiceAccountConfig) obj;

      if (!getServiceAccount().equals(other.getServiceAccount())) return false;
      if (!getUnknownFields().equals(other.getUnknownFields())) return false;
      return true;
    }

    @java.lang.Override
    public int hashCode() {
      if (memoizedHashCode != 0) {
        return memoizedHashCode;
      }
      int hash = 41;
      hash = (19 * hash) + getDescriptor().hashCode();
      hash = (37 * hash) + SERVICE_ACCOUNT_FIELD_NUMBER;
      hash = (53 * hash) + getServiceAccount().hashCode();
      hash = (29 * hash) + getUnknownFields().hashCode();
      memoizedHashCode = hash;
      return hash;
    }

    public static com.google.cloud.aiplatform.v1beta1.AuthConfig.GoogleServiceAccountConfig
        parseFrom(java.nio.ByteBuffer data)
            throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.aiplatform.v1beta1.AuthConfig.GoogleServiceAccountConfig
        parseFrom(
            java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.aiplatform.v1beta1.AuthConfig.GoogleServiceAccountConfig
        parseFrom(com.google.protobuf.ByteString data)
            throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.aiplatform.v1beta1.AuthConfig.GoogleServiceAccountConfig
        parseFrom(
            com.google.protobuf.ByteString data,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.aiplatform.v1beta1.AuthConfig.GoogleServiceAccountConfig
        parseFrom(byte[] data) throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.aiplatform.v1beta1.AuthConfig.GoogleServiceAccountConfig
        parseFrom(byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.aiplatform.v1beta1.AuthConfig.GoogleServiceAccountConfig
        parseFrom(java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.cloud.aiplatform.v1beta1.AuthConfig.GoogleServiceAccountConfig
        parseFrom(
            java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.cloud.aiplatform.v1beta1.AuthConfig.GoogleServiceAccountConfig
        parseDelimitedFrom(java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
    }

    public static com.google.cloud.aiplatform.v1beta1.AuthConfig.GoogleServiceAccountConfig
        parseDelimitedFrom(
            java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.cloud.aiplatform.v1beta1.AuthConfig.GoogleServiceAccountConfig
        parseFrom(com.google.protobuf.CodedInputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.cloud.aiplatform.v1beta1.AuthConfig.GoogleServiceAccountConfig
        parseFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    @java.lang.Override
    public Builder newBuilderForType() {
      return newBuilder();
    }

    public static Builder newBuilder() {
      return DEFAULT_INSTANCE.toBuilder();
    }

    public static Builder newBuilder(
        com.google.cloud.aiplatform.v1beta1.AuthConfig.GoogleServiceAccountConfig prototype) {
      return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }

    @java.lang.Override
    public Builder toBuilder() {
      return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
    }

    @java.lang.Override
    protected Builder newBuilderForType(
        com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      Builder builder = new Builder(parent);
      return builder;
    }
    /**
     *
     *
     * <pre>
     * Config for Google Service Account Authentication.
     * </pre>
     *
     * Protobuf type {@code google.cloud.aiplatform.v1beta1.AuthConfig.GoogleServiceAccountConfig}
     */
    public static final class Builder
        extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
        implements
        // @@protoc_insertion_point(builder_implements:google.cloud.aiplatform.v1beta1.AuthConfig.GoogleServiceAccountConfig)
        com.google.cloud.aiplatform.v1beta1.AuthConfig.GoogleServiceAccountConfigOrBuilder {
      public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
        return com.google.cloud.aiplatform.v1beta1.ExtensionProto
            .internal_static_google_cloud_aiplatform_v1beta1_AuthConfig_GoogleServiceAccountConfig_descriptor;
      }

      @java.lang.Override
      protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return com.google.cloud.aiplatform.v1beta1.ExtensionProto
            .internal_static_google_cloud_aiplatform_v1beta1_AuthConfig_GoogleServiceAccountConfig_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                com.google.cloud.aiplatform.v1beta1.AuthConfig.GoogleServiceAccountConfig.class,
                com.google.cloud.aiplatform.v1beta1.AuthConfig.GoogleServiceAccountConfig.Builder
                    .class);
      }

      // Construct using
      // com.google.cloud.aiplatform.v1beta1.AuthConfig.GoogleServiceAccountConfig.newBuilder()
      private Builder() {}

      private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
        super(parent);
      }

      @java.lang.Override
      public Builder clear() {
        super.clear();
        bitField0_ = 0;
        serviceAccount_ = "";
        return this;
      }

      @java.lang.Override
      public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
        return com.google.cloud.aiplatform.v1beta1.ExtensionProto
            .internal_static_google_cloud_aiplatform_v1beta1_AuthConfig_GoogleServiceAccountConfig_descriptor;
      }

      @java.lang.Override
      public com.google.cloud.aiplatform.v1beta1.AuthConfig.GoogleServiceAccountConfig
          getDefaultInstanceForType() {
        return com.google.cloud.aiplatform.v1beta1.AuthConfig.GoogleServiceAccountConfig
            .getDefaultInstance();
      }

      @java.lang.Override
      public com.google.cloud.aiplatform.v1beta1.AuthConfig.GoogleServiceAccountConfig build() {
        com.google.cloud.aiplatform.v1beta1.AuthConfig.GoogleServiceAccountConfig result =
            buildPartial();
        if (!result.isInitialized()) {
          throw newUninitializedMessageException(result);
        }
        return result;
      }

      @java.lang.Override
      public com.google.cloud.aiplatform.v1beta1.AuthConfig.GoogleServiceAccountConfig
          buildPartial() {
        com.google.cloud.aiplatform.v1beta1.AuthConfig.GoogleServiceAccountConfig result =
            new com.google.cloud.aiplatform.v1beta1.AuthConfig.GoogleServiceAccountConfig(this);
        if (bitField0_ != 0) {
          buildPartial0(result);
        }
        onBuilt();
        return result;
      }

      private void buildPartial0(
          com.google.cloud.aiplatform.v1beta1.AuthConfig.GoogleServiceAccountConfig result) {
        int from_bitField0_ = bitField0_;
        if (((from_bitField0_ & 0x00000001) != 0)) {
          result.serviceAccount_ = serviceAccount_;
        }
      }

      @java.lang.Override
      public Builder clone() {
        return super.clone();
      }

      @java.lang.Override
      public Builder setField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.setField(field, value);
      }

      @java.lang.Override
      public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
        return super.clearField(field);
      }

      @java.lang.Override
      public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
        return super.clearOneof(oneof);
      }

      @java.lang.Override
      public Builder setRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          int index,
          java.lang.Object value) {
        return super.setRepeatedField(field, index, value);
      }

      @java.lang.Override
      public Builder addRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.addRepeatedField(field, value);
      }

      @java.lang.Override
      public Builder mergeFrom(com.google.protobuf.Message other) {
        if (other
            instanceof com.google.cloud.aiplatform.v1beta1.AuthConfig.GoogleServiceAccountConfig) {
          return mergeFrom(
              (com.google.cloud.aiplatform.v1beta1.AuthConfig.GoogleServiceAccountConfig) other);
        } else {
          super.mergeFrom(other);
          return this;
        }
      }

      public Builder mergeFrom(
          com.google.cloud.aiplatform.v1beta1.AuthConfig.GoogleServiceAccountConfig other) {
        if (other
            == com.google.cloud.aiplatform.v1beta1.AuthConfig.GoogleServiceAccountConfig
                .getDefaultInstance()) return this;
        if (!other.getServiceAccount().isEmpty()) {
          serviceAccount_ = other.serviceAccount_;
          bitField0_ |= 0x00000001;
          onChanged();
        }
        this.mergeUnknownFields(other.getUnknownFields());
        onChanged();
        return this;
      }

      @java.lang.Override
      public final boolean isInitialized() {
        return true;
      }

      @java.lang.Override
      public Builder mergeFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        if (extensionRegistry == null) {
          throw new java.lang.NullPointerException();
        }
        try {
          boolean done = false;
          while (!done) {
            int tag = input.readTag();
            switch (tag) {
              case 0:
                done = true;
                break;
              case 10:
                {
                  serviceAccount_ = input.readStringRequireUtf8();
                  bitField0_ |= 0x00000001;
                  break;
                } // case 10
              default:
                {
                  if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                    done = true; // was an endgroup tag
                  }
                  break;
                } // default:
            } // switch (tag)
          } // while (!done)
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          throw e.unwrapIOException();
        } finally {
          onChanged();
        } // finally
        return this;
      }

      private int bitField0_;

      private java.lang.Object serviceAccount_ = "";
      /**
       *
       *
       * <pre>
       * Optional. The service account that the extension execution service runs
       * as.
       *
       * - If the service account is specified,
       * the `iam.serviceAccounts.getAccessToken` permission should be granted to
       * Vertex AI Extension Service Agent
       * (https://cloud.google.com/vertex-ai/docs/general/access-control#service-agents)
       * on the specified service account.
       *
       * - If not specified, the Vertex AI Extension Service Agent
       * will be used to execute the Extension.
       * </pre>
       *
       * <code>string service_account = 1 [(.google.api.field_behavior) = OPTIONAL];</code>
       *
       * @return The serviceAccount.
       */
      public java.lang.String getServiceAccount() {
        java.lang.Object ref = serviceAccount_;
        if (!(ref instanceof java.lang.String)) {
          com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
          java.lang.String s = bs.toStringUtf8();
          serviceAccount_ = s;
          return s;
        } else {
          return (java.lang.String) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * Optional. The service account that the extension execution service runs
       * as.
       *
       * - If the service account is specified,
       * the `iam.serviceAccounts.getAccessToken` permission should be granted to
       * Vertex AI Extension Service Agent
       * (https://cloud.google.com/vertex-ai/docs/general/access-control#service-agents)
       * on the specified service account.
       *
       * - If not specified, the Vertex AI Extension Service Agent
       * will be used to execute the Extension.
       * </pre>
       *
       * <code>string service_account = 1 [(.google.api.field_behavior) = OPTIONAL];</code>
       *
       * @return The bytes for serviceAccount.
       */
      public com.google.protobuf.ByteString getServiceAccountBytes() {
        java.lang.Object ref = serviceAccount_;
        if (ref instanceof String) {
          com.google.protobuf.ByteString b =
              com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
          serviceAccount_ = b;
          return b;
        } else {
          return (com.google.protobuf.ByteString) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * Optional. The service account that the extension execution service runs
       * as.
       *
       * - If the service account is specified,
       * the `iam.serviceAccounts.getAccessToken` permission should be granted to
       * Vertex AI Extension Service Agent
       * (https://cloud.google.com/vertex-ai/docs/general/access-control#service-agents)
       * on the specified service account.
       *
       * - If not specified, the Vertex AI Extension Service Agent
       * will be used to execute the Extension.
       * </pre>
       *
       * <code>string service_account = 1 [(.google.api.field_behavior) = OPTIONAL];</code>
       *
       * @param value The serviceAccount to set.
       * @return This builder for chaining.
       */
      public Builder setServiceAccount(java.lang.String value) {
        if (value == null) {
          throw new NullPointerException();
        }
        serviceAccount_ = value;
        bitField0_ |= 0x00000001;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Optional. The service account that the extension execution service runs
       * as.
       *
       * - If the service account is specified,
       * the `iam.serviceAccounts.getAccessToken` permission should be granted to
       * Vertex AI Extension Service Agent
       * (https://cloud.google.com/vertex-ai/docs/general/access-control#service-agents)
       * on the specified service account.
       *
       * - If not specified, the Vertex AI Extension Service Agent
       * will be used to execute the Extension.
       * </pre>
       *
       * <code>string service_account = 1 [(.google.api.field_behavior) = OPTIONAL];</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearServiceAccount() {
        serviceAccount_ = getDefaultInstance().getServiceAccount();
        bitField0_ = (bitField0_ & ~0x00000001);
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Optional. The service account that the extension execution service runs
       * as.
       *
       * - If the service account is specified,
       * the `iam.serviceAccounts.getAccessToken` permission should be granted to
       * Vertex AI Extension Service Agent
       * (https://cloud.google.com/vertex-ai/docs/general/access-control#service-agents)
       * on the specified service account.
       *
       * - If not specified, the Vertex AI Extension Service Agent
       * will be used to execute the Extension.
       * </pre>
       *
       * <code>string service_account = 1 [(.google.api.field_behavior) = OPTIONAL];</code>
       *
       * @param value The bytes for serviceAccount to set.
       * @return This builder for chaining.
       */
      public Builder setServiceAccountBytes(com.google.protobuf.ByteString value) {
        if (value == null) {
          throw new NullPointerException();
        }
        checkByteStringIsUtf8(value);
        serviceAccount_ = value;
        bitField0_ |= 0x00000001;
        onChanged();
        return this;
      }

      @java.lang.Override
      public final Builder setUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.setUnknownFields(unknownFields);
      }

      @java.lang.Override
      public final Builder mergeUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.mergeUnknownFields(unknownFields);
      }

      // @@protoc_insertion_point(builder_scope:google.cloud.aiplatform.v1beta1.AuthConfig.GoogleServiceAccountConfig)
    }

    // @@protoc_insertion_point(class_scope:google.cloud.aiplatform.v1beta1.AuthConfig.GoogleServiceAccountConfig)
    private static final com.google.cloud.aiplatform.v1beta1.AuthConfig.GoogleServiceAccountConfig
        DEFAULT_INSTANCE;

    static {
      DEFAULT_INSTANCE =
          new com.google.cloud.aiplatform.v1beta1.AuthConfig.GoogleServiceAccountConfig();
    }

    public static com.google.cloud.aiplatform.v1beta1.AuthConfig.GoogleServiceAccountConfig
        getDefaultInstance() {
      return DEFAULT_INSTANCE;
    }

    private static final com.google.protobuf.Parser<GoogleServiceAccountConfig> PARSER =
        new com.google.protobuf.AbstractParser<GoogleServiceAccountConfig>() {
          @java.lang.Override
          public GoogleServiceAccountConfig parsePartialFrom(
              com.google.protobuf.CodedInputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
            Builder builder = newBuilder();
            try {
              builder.mergeFrom(input, extensionRegistry);
            } catch (com.google.protobuf.InvalidProtocolBufferException e) {
              throw e.setUnfinishedMessage(builder.buildPartial());
            } catch (com.google.protobuf.UninitializedMessageException e) {
              throw e.asInvalidProtocolBufferException()
                  .setUnfinishedMessage(builder.buildPartial());
            } catch (java.io.IOException e) {
              throw new com.google.protobuf.InvalidProtocolBufferException(e)
                  .setUnfinishedMessage(builder.buildPartial());
            }
            return builder.buildPartial();
          }
        };

    public static com.google.protobuf.Parser<GoogleServiceAccountConfig> parser() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.protobuf.Parser<GoogleServiceAccountConfig> getParserForType() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.cloud.aiplatform.v1beta1.AuthConfig.GoogleServiceAccountConfig
        getDefaultInstanceForType() {
      return DEFAULT_INSTANCE;
    }
  }

  public interface OauthConfigOrBuilder
      extends
      // @@protoc_insertion_point(interface_extends:google.cloud.aiplatform.v1beta1.AuthConfig.OauthConfig)
      com.google.protobuf.MessageOrBuilder {

    /**
     *
     *
     * <pre>
     * Access token for extension endpoint.
     * Only used to propagate token from
     * [[ExecuteExtensionRequest.runtime_auth_config]] at request time.
     * </pre>
     *
     * <code>string access_token = 1;</code>
     *
     * @return Whether the accessToken field is set.
     */
    boolean hasAccessToken();
    /**
     *
     *
     * <pre>
     * Access token for extension endpoint.
     * Only used to propagate token from
     * [[ExecuteExtensionRequest.runtime_auth_config]] at request time.
     * </pre>
     *
     * <code>string access_token = 1;</code>
     *
     * @return The accessToken.
     */
    java.lang.String getAccessToken();
    /**
     *
     *
     * <pre>
     * Access token for extension endpoint.
     * Only used to propagate token from
     * [[ExecuteExtensionRequest.runtime_auth_config]] at request time.
     * </pre>
     *
     * <code>string access_token = 1;</code>
     *
     * @return The bytes for accessToken.
     */
    com.google.protobuf.ByteString getAccessTokenBytes();

    /**
     *
     *
     * <pre>
     * The service account used to generate access tokens for executing the
     * Extension.
     *
     * - If the service account is specified,
     * the `iam.serviceAccounts.getAccessToken` permission should be granted
     * to Vertex AI Extension Service Agent
     * (https://cloud.google.com/vertex-ai/docs/general/access-control#service-agents)
     * on the provided service account.
     * </pre>
     *
     * <code>string service_account = 2;</code>
     *
     * @return Whether the serviceAccount field is set.
     */
    boolean hasServiceAccount();
    /**
     *
     *
     * <pre>
     * The service account used to generate access tokens for executing the
     * Extension.
     *
     * - If the service account is specified,
     * the `iam.serviceAccounts.getAccessToken` permission should be granted
     * to Vertex AI Extension Service Agent
     * (https://cloud.google.com/vertex-ai/docs/general/access-control#service-agents)
     * on the provided service account.
     * </pre>
     *
     * <code>string service_account = 2;</code>
     *
     * @return The serviceAccount.
     */
    java.lang.String getServiceAccount();
    /**
     *
     *
     * <pre>
     * The service account used to generate access tokens for executing the
     * Extension.
     *
     * - If the service account is specified,
     * the `iam.serviceAccounts.getAccessToken` permission should be granted
     * to Vertex AI Extension Service Agent
     * (https://cloud.google.com/vertex-ai/docs/general/access-control#service-agents)
     * on the provided service account.
     * </pre>
     *
     * <code>string service_account = 2;</code>
     *
     * @return The bytes for serviceAccount.
     */
    com.google.protobuf.ByteString getServiceAccountBytes();

    com.google.cloud.aiplatform.v1beta1.AuthConfig.OauthConfig.OauthConfigCase getOauthConfigCase();
  }
  /**
   *
   *
   * <pre>
   * Config for user oauth.
   * </pre>
   *
   * Protobuf type {@code google.cloud.aiplatform.v1beta1.AuthConfig.OauthConfig}
   */
  public static final class OauthConfig extends com.google.protobuf.GeneratedMessageV3
      implements
      // @@protoc_insertion_point(message_implements:google.cloud.aiplatform.v1beta1.AuthConfig.OauthConfig)
      OauthConfigOrBuilder {
    private static final long serialVersionUID = 0L;
    // Use OauthConfig.newBuilder() to construct.
    private OauthConfig(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
      super(builder);
    }

    private OauthConfig() {}

    @java.lang.Override
    @SuppressWarnings({"unused"})
    protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
      return new OauthConfig();
    }

    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.aiplatform.v1beta1.ExtensionProto
          .internal_static_google_cloud_aiplatform_v1beta1_AuthConfig_OauthConfig_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.aiplatform.v1beta1.ExtensionProto
          .internal_static_google_cloud_aiplatform_v1beta1_AuthConfig_OauthConfig_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.aiplatform.v1beta1.AuthConfig.OauthConfig.class,
              com.google.cloud.aiplatform.v1beta1.AuthConfig.OauthConfig.Builder.class);
    }

    private int oauthConfigCase_ = 0;

    @SuppressWarnings("serial")
    private java.lang.Object oauthConfig_;

    public enum OauthConfigCase
        implements
            com.google.protobuf.Internal.EnumLite,
            com.google.protobuf.AbstractMessage.InternalOneOfEnum {
      ACCESS_TOKEN(1),
      SERVICE_ACCOUNT(2),
      OAUTHCONFIG_NOT_SET(0);
      private final int value;

      private OauthConfigCase(int value) {
        this.value = value;
      }
      /**
       * @param value The number of the enum to look for.
       * @return The enum associated with the given number.
       * @deprecated Use {@link #forNumber(int)} instead.
       */
      @java.lang.Deprecated
      public static OauthConfigCase valueOf(int value) {
        return forNumber(value);
      }

      public static OauthConfigCase forNumber(int value) {
        switch (value) {
          case 1:
            return ACCESS_TOKEN;
          case 2:
            return SERVICE_ACCOUNT;
          case 0:
            return OAUTHCONFIG_NOT_SET;
          default:
            return null;
        }
      }

      public int getNumber() {
        return this.value;
      }
    };

    public OauthConfigCase getOauthConfigCase() {
      return OauthConfigCase.forNumber(oauthConfigCase_);
    }

    public static final int ACCESS_TOKEN_FIELD_NUMBER = 1;
    /**
     *
     *
     * <pre>
     * Access token for extension endpoint.
     * Only used to propagate token from
     * [[ExecuteExtensionRequest.runtime_auth_config]] at request time.
     * </pre>
     *
     * <code>string access_token = 1;</code>
     *
     * @return Whether the accessToken field is set.
     */
    public boolean hasAccessToken() {
      return oauthConfigCase_ == 1;
    }
    /**
     *
     *
     * <pre>
     * Access token for extension endpoint.
     * Only used to propagate token from
     * [[ExecuteExtensionRequest.runtime_auth_config]] at request time.
     * </pre>
     *
     * <code>string access_token = 1;</code>
     *
     * @return The accessToken.
     */
    public java.lang.String getAccessToken() {
      java.lang.Object ref = "";
      if (oauthConfigCase_ == 1) {
        ref = oauthConfig_;
      }
      if (ref instanceof java.lang.String) {
        return (java.lang.String) ref;
      } else {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        if (oauthConfigCase_ == 1) {
          oauthConfig_ = s;
        }
        return s;
      }
    }
    /**
     *
     *
     * <pre>
     * Access token for extension endpoint.
     * Only used to propagate token from
     * [[ExecuteExtensionRequest.runtime_auth_config]] at request time.
     * </pre>
     *
     * <code>string access_token = 1;</code>
     *
     * @return The bytes for accessToken.
     */
    public com.google.protobuf.ByteString getAccessTokenBytes() {
      java.lang.Object ref = "";
      if (oauthConfigCase_ == 1) {
        ref = oauthConfig_;
      }
      if (ref instanceof java.lang.String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        if (oauthConfigCase_ == 1) {
          oauthConfig_ = b;
        }
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    public static final int SERVICE_ACCOUNT_FIELD_NUMBER = 2;
    /**
     *
     *
     * <pre>
     * The service account used to generate access tokens for executing the
     * Extension.
     *
     * - If the service account is specified,
     * the `iam.serviceAccounts.getAccessToken` permission should be granted
     * to Vertex AI Extension Service Agent
     * (https://cloud.google.com/vertex-ai/docs/general/access-control#service-agents)
     * on the provided service account.
     * </pre>
     *
     * <code>string service_account = 2;</code>
     *
     * @return Whether the serviceAccount field is set.
     */
    public boolean hasServiceAccount() {
      return oauthConfigCase_ == 2;
    }
    /**
     *
     *
     * <pre>
     * The service account used to generate access tokens for executing the
     * Extension.
     *
     * - If the service account is specified,
     * the `iam.serviceAccounts.getAccessToken` permission should be granted
     * to Vertex AI Extension Service Agent
     * (https://cloud.google.com/vertex-ai/docs/general/access-control#service-agents)
     * on the provided service account.
     * </pre>
     *
     * <code>string service_account = 2;</code>
     *
     * @return The serviceAccount.
     */
    public java.lang.String getServiceAccount() {
      java.lang.Object ref = "";
      if (oauthConfigCase_ == 2) {
        ref = oauthConfig_;
      }
      if (ref instanceof java.lang.String) {
        return (java.lang.String) ref;
      } else {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        if (oauthConfigCase_ == 2) {
          oauthConfig_ = s;
        }
        return s;
      }
    }
    /**
     *
     *
     * <pre>
     * The service account used to generate access tokens for executing the
     * Extension.
     *
     * - If the service account is specified,
     * the `iam.serviceAccounts.getAccessToken` permission should be granted
     * to Vertex AI Extension Service Agent
     * (https://cloud.google.com/vertex-ai/docs/general/access-control#service-agents)
     * on the provided service account.
     * </pre>
     *
     * <code>string service_account = 2;</code>
     *
     * @return The bytes for serviceAccount.
     */
    public com.google.protobuf.ByteString getServiceAccountBytes() {
      java.lang.Object ref = "";
      if (oauthConfigCase_ == 2) {
        ref = oauthConfig_;
      }
      if (ref instanceof java.lang.String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        if (oauthConfigCase_ == 2) {
          oauthConfig_ = b;
        }
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    private byte memoizedIsInitialized = -1;

    @java.lang.Override
    public final boolean isInitialized() {
      byte isInitialized = memoizedIsInitialized;
      if (isInitialized == 1) return true;
      if (isInitialized == 0) return false;

      memoizedIsInitialized = 1;
      return true;
    }

    @java.lang.Override
    public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
      if (oauthConfigCase_ == 1) {
        com.google.protobuf.GeneratedMessageV3.writeString(output, 1, oauthConfig_);
      }
      if (oauthConfigCase_ == 2) {
        com.google.protobuf.GeneratedMessageV3.writeString(output, 2, oauthConfig_);
      }
      getUnknownFields().writeTo(output);
    }

    @java.lang.Override
    public int getSerializedSize() {
      int size = memoizedSize;
      if (size != -1) return size;

      size = 0;
      if (oauthConfigCase_ == 1) {
        size += com.google.protobuf.GeneratedMessageV3.computeStringSize(1, oauthConfig_);
      }
      if (oauthConfigCase_ == 2) {
        size += com.google.protobuf.GeneratedMessageV3.computeStringSize(2, oauthConfig_);
      }
      size += getUnknownFields().getSerializedSize();
      memoizedSize = size;
      return size;
    }

    @java.lang.Override
    public boolean equals(final java.lang.Object obj) {
      if (obj == this) {
        return true;
      }
      if (!(obj instanceof com.google.cloud.aiplatform.v1beta1.AuthConfig.OauthConfig)) {
        return super.equals(obj);
      }
      com.google.cloud.aiplatform.v1beta1.AuthConfig.OauthConfig other =
          (com.google.cloud.aiplatform.v1beta1.AuthConfig.OauthConfig) obj;

      if (!getOauthConfigCase().equals(other.getOauthConfigCase())) return false;
      switch (oauthConfigCase_) {
        case 1:
          if (!getAccessToken().equals(other.getAccessToken())) return false;
          break;
        case 2:
          if (!getServiceAccount().equals(other.getServiceAccount())) return false;
          break;
        case 0:
        default:
      }
      if (!getUnknownFields().equals(other.getUnknownFields())) return false;
      return true;
    }

    @java.lang.Override
    public int hashCode() {
      if (memoizedHashCode != 0) {
        return memoizedHashCode;
      }
      int hash = 41;
      hash = (19 * hash) + getDescriptor().hashCode();
      switch (oauthConfigCase_) {
        case 1:
          hash = (37 * hash) + ACCESS_TOKEN_FIELD_NUMBER;
          hash = (53 * hash) + getAccessToken().hashCode();
          break;
        case 2:
          hash = (37 * hash) + SERVICE_ACCOUNT_FIELD_NUMBER;
          hash = (53 * hash) + getServiceAccount().hashCode();
          break;
        case 0:
        default:
      }
      hash = (29 * hash) + getUnknownFields().hashCode();
      memoizedHashCode = hash;
      return hash;
    }

    public static com.google.cloud.aiplatform.v1beta1.AuthConfig.OauthConfig parseFrom(
        java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.aiplatform.v1beta1.AuthConfig.OauthConfig parseFrom(
        java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.aiplatform.v1beta1.AuthConfig.OauthConfig parseFrom(
        com.google.protobuf.ByteString data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.aiplatform.v1beta1.AuthConfig.OauthConfig parseFrom(
        com.google.protobuf.ByteString data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.aiplatform.v1beta1.AuthConfig.OauthConfig parseFrom(byte[] data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.aiplatform.v1beta1.AuthConfig.OauthConfig parseFrom(
        byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.aiplatform.v1beta1.AuthConfig.OauthConfig parseFrom(
        java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.cloud.aiplatform.v1beta1.AuthConfig.OauthConfig parseFrom(
        java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.cloud.aiplatform.v1beta1.AuthConfig.OauthConfig parseDelimitedFrom(
        java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
    }

    public static com.google.cloud.aiplatform.v1beta1.AuthConfig.OauthConfig parseDelimitedFrom(
        java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.cloud.aiplatform.v1beta1.AuthConfig.OauthConfig parseFrom(
        com.google.protobuf.CodedInputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.cloud.aiplatform.v1beta1.AuthConfig.OauthConfig parseFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    @java.lang.Override
    public Builder newBuilderForType() {
      return newBuilder();
    }

    public static Builder newBuilder() {
      return DEFAULT_INSTANCE.toBuilder();
    }

    public static Builder newBuilder(
        com.google.cloud.aiplatform.v1beta1.AuthConfig.OauthConfig prototype) {
      return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }

    @java.lang.Override
    public Builder toBuilder() {
      return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
    }

    @java.lang.Override
    protected Builder newBuilderForType(
        com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      Builder builder = new Builder(parent);
      return builder;
    }
    /**
     *
     *
     * <pre>
     * Config for user oauth.
     * </pre>
     *
     * Protobuf type {@code google.cloud.aiplatform.v1beta1.AuthConfig.OauthConfig}
     */
    public static final class Builder
        extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
        implements
        // @@protoc_insertion_point(builder_implements:google.cloud.aiplatform.v1beta1.AuthConfig.OauthConfig)
        com.google.cloud.aiplatform.v1beta1.AuthConfig.OauthConfigOrBuilder {
      public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
        return com.google.cloud.aiplatform.v1beta1.ExtensionProto
            .internal_static_google_cloud_aiplatform_v1beta1_AuthConfig_OauthConfig_descriptor;
      }

      @java.lang.Override
      protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return com.google.cloud.aiplatform.v1beta1.ExtensionProto
            .internal_static_google_cloud_aiplatform_v1beta1_AuthConfig_OauthConfig_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                com.google.cloud.aiplatform.v1beta1.AuthConfig.OauthConfig.class,
                com.google.cloud.aiplatform.v1beta1.AuthConfig.OauthConfig.Builder.class);
      }

      // Construct using com.google.cloud.aiplatform.v1beta1.AuthConfig.OauthConfig.newBuilder()
      private Builder() {}

      private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
        super(parent);
      }

      @java.lang.Override
      public Builder clear() {
        super.clear();
        bitField0_ = 0;
        oauthConfigCase_ = 0;
        oauthConfig_ = null;
        return this;
      }

      @java.lang.Override
      public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
        return com.google.cloud.aiplatform.v1beta1.ExtensionProto
            .internal_static_google_cloud_aiplatform_v1beta1_AuthConfig_OauthConfig_descriptor;
      }

      @java.lang.Override
      public com.google.cloud.aiplatform.v1beta1.AuthConfig.OauthConfig
          getDefaultInstanceForType() {
        return com.google.cloud.aiplatform.v1beta1.AuthConfig.OauthConfig.getDefaultInstance();
      }

      @java.lang.Override
      public com.google.cloud.aiplatform.v1beta1.AuthConfig.OauthConfig build() {
        com.google.cloud.aiplatform.v1beta1.AuthConfig.OauthConfig result = buildPartial();
        if (!result.isInitialized()) {
          throw newUninitializedMessageException(result);
        }
        return result;
      }

      @java.lang.Override
      public com.google.cloud.aiplatform.v1beta1.AuthConfig.OauthConfig buildPartial() {
        com.google.cloud.aiplatform.v1beta1.AuthConfig.OauthConfig result =
            new com.google.cloud.aiplatform.v1beta1.AuthConfig.OauthConfig(this);
        if (bitField0_ != 0) {
          buildPartial0(result);
        }
        buildPartialOneofs(result);
        onBuilt();
        return result;
      }

      private void buildPartial0(
          com.google.cloud.aiplatform.v1beta1.AuthConfig.OauthConfig result) {
        int from_bitField0_ = bitField0_;
      }

      private void buildPartialOneofs(
          com.google.cloud.aiplatform.v1beta1.AuthConfig.OauthConfig result) {
        result.oauthConfigCase_ = oauthConfigCase_;
        result.oauthConfig_ = this.oauthConfig_;
      }

      @java.lang.Override
      public Builder clone() {
        return super.clone();
      }

      @java.lang.Override
      public Builder setField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.setField(field, value);
      }

      @java.lang.Override
      public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
        return super.clearField(field);
      }

      @java.lang.Override
      public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
        return super.clearOneof(oneof);
      }

      @java.lang.Override
      public Builder setRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          int index,
          java.lang.Object value) {
        return super.setRepeatedField(field, index, value);
      }

      @java.lang.Override
      public Builder addRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.addRepeatedField(field, value);
      }

      @java.lang.Override
      public Builder mergeFrom(com.google.protobuf.Message other) {
        if (other instanceof com.google.cloud.aiplatform.v1beta1.AuthConfig.OauthConfig) {
          return mergeFrom((com.google.cloud.aiplatform.v1beta1.AuthConfig.OauthConfig) other);
        } else {
          super.mergeFrom(other);
          return this;
        }
      }

      public Builder mergeFrom(com.google.cloud.aiplatform.v1beta1.AuthConfig.OauthConfig other) {
        if (other
            == com.google.cloud.aiplatform.v1beta1.AuthConfig.OauthConfig.getDefaultInstance())
          return this;
        switch (other.getOauthConfigCase()) {
          case ACCESS_TOKEN:
            {
              oauthConfigCase_ = 1;
              oauthConfig_ = other.oauthConfig_;
              onChanged();
              break;
            }
          case SERVICE_ACCOUNT:
            {
              oauthConfigCase_ = 2;
              oauthConfig_ = other.oauthConfig_;
              onChanged();
              break;
            }
          case OAUTHCONFIG_NOT_SET:
            {
              break;
            }
        }
        this.mergeUnknownFields(other.getUnknownFields());
        onChanged();
        return this;
      }

      @java.lang.Override
      public final boolean isInitialized() {
        return true;
      }

      @java.lang.Override
      public Builder mergeFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        if (extensionRegistry == null) {
          throw new java.lang.NullPointerException();
        }
        try {
          boolean done = false;
          while (!done) {
            int tag = input.readTag();
            switch (tag) {
              case 0:
                done = true;
                break;
              case 10:
                {
                  java.lang.String s = input.readStringRequireUtf8();
                  oauthConfigCase_ = 1;
                  oauthConfig_ = s;
                  break;
                } // case 10
              case 18:
                {
                  java.lang.String s = input.readStringRequireUtf8();
                  oauthConfigCase_ = 2;
                  oauthConfig_ = s;
                  break;
                } // case 18
              default:
                {
                  if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                    done = true; // was an endgroup tag
                  }
                  break;
                } // default:
            } // switch (tag)
          } // while (!done)
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          throw e.unwrapIOException();
        } finally {
          onChanged();
        } // finally
        return this;
      }

      private int oauthConfigCase_ = 0;
      private java.lang.Object oauthConfig_;

      public OauthConfigCase getOauthConfigCase() {
        return OauthConfigCase.forNumber(oauthConfigCase_);
      }

      public Builder clearOauthConfig() {
        oauthConfigCase_ = 0;
        oauthConfig_ = null;
        onChanged();
        return this;
      }

      private int bitField0_;

      /**
       *
       *
       * <pre>
       * Access token for extension endpoint.
       * Only used to propagate token from
       * [[ExecuteExtensionRequest.runtime_auth_config]] at request time.
       * </pre>
       *
       * <code>string access_token = 1;</code>
       *
       * @return Whether the accessToken field is set.
       */
      @java.lang.Override
      public boolean hasAccessToken() {
        return oauthConfigCase_ == 1;
      }
      /**
       *
       *
       * <pre>
       * Access token for extension endpoint.
       * Only used to propagate token from
       * [[ExecuteExtensionRequest.runtime_auth_config]] at request time.
       * </pre>
       *
       * <code>string access_token = 1;</code>
       *
       * @return The accessToken.
       */
      @java.lang.Override
      public java.lang.String getAccessToken() {
        java.lang.Object ref = "";
        if (oauthConfigCase_ == 1) {
          ref = oauthConfig_;
        }
        if (!(ref instanceof java.lang.String)) {
          com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
          java.lang.String s = bs.toStringUtf8();
          if (oauthConfigCase_ == 1) {
            oauthConfig_ = s;
          }
          return s;
        } else {
          return (java.lang.String) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * Access token for extension endpoint.
       * Only used to propagate token from
       * [[ExecuteExtensionRequest.runtime_auth_config]] at request time.
       * </pre>
       *
       * <code>string access_token = 1;</code>
       *
       * @return The bytes for accessToken.
       */
      @java.lang.Override
      public com.google.protobuf.ByteString getAccessTokenBytes() {
        java.lang.Object ref = "";
        if (oauthConfigCase_ == 1) {
          ref = oauthConfig_;
        }
        if (ref instanceof String) {
          com.google.protobuf.ByteString b =
              com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
          if (oauthConfigCase_ == 1) {
            oauthConfig_ = b;
          }
          return b;
        } else {
          return (com.google.protobuf.ByteString) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * Access token for extension endpoint.
       * Only used to propagate token from
       * [[ExecuteExtensionRequest.runtime_auth_config]] at request time.
       * </pre>
       *
       * <code>string access_token = 1;</code>
       *
       * @param value The accessToken to set.
       * @return This builder for chaining.
       */
      public Builder setAccessToken(java.lang.String value) {
        if (value == null) {
          throw new NullPointerException();
        }
        oauthConfigCase_ = 1;
        oauthConfig_ = value;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Access token for extension endpoint.
       * Only used to propagate token from
       * [[ExecuteExtensionRequest.runtime_auth_config]] at request time.
       * </pre>
       *
       * <code>string access_token = 1;</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearAccessToken() {
        if (oauthConfigCase_ == 1) {
          oauthConfigCase_ = 0;
          oauthConfig_ = null;
          onChanged();
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * Access token for extension endpoint.
       * Only used to propagate token from
       * [[ExecuteExtensionRequest.runtime_auth_config]] at request time.
       * </pre>
       *
       * <code>string access_token = 1;</code>
       *
       * @param value The bytes for accessToken to set.
       * @return This builder for chaining.
       */
      public Builder setAccessTokenBytes(com.google.protobuf.ByteString value) {
        if (value == null) {
          throw new NullPointerException();
        }
        checkByteStringIsUtf8(value);
        oauthConfigCase_ = 1;
        oauthConfig_ = value;
        onChanged();
        return this;
      }

      /**
       *
       *
       * <pre>
       * The service account used to generate access tokens for executing the
       * Extension.
       *
       * - If the service account is specified,
       * the `iam.serviceAccounts.getAccessToken` permission should be granted
       * to Vertex AI Extension Service Agent
       * (https://cloud.google.com/vertex-ai/docs/general/access-control#service-agents)
       * on the provided service account.
       * </pre>
       *
       * <code>string service_account = 2;</code>
       *
       * @return Whether the serviceAccount field is set.
       */
      @java.lang.Override
      public boolean hasServiceAccount() {
        return oauthConfigCase_ == 2;
      }
      /**
       *
       *
       * <pre>
       * The service account used to generate access tokens for executing the
       * Extension.
       *
       * - If the service account is specified,
       * the `iam.serviceAccounts.getAccessToken` permission should be granted
       * to Vertex AI Extension Service Agent
       * (https://cloud.google.com/vertex-ai/docs/general/access-control#service-agents)
       * on the provided service account.
       * </pre>
       *
       * <code>string service_account = 2;</code>
       *
       * @return The serviceAccount.
       */
      @java.lang.Override
      public java.lang.String getServiceAccount() {
        java.lang.Object ref = "";
        if (oauthConfigCase_ == 2) {
          ref = oauthConfig_;
        }
        if (!(ref instanceof java.lang.String)) {
          com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
          java.lang.String s = bs.toStringUtf8();
          if (oauthConfigCase_ == 2) {
            oauthConfig_ = s;
          }
          return s;
        } else {
          return (java.lang.String) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * The service account used to generate access tokens for executing the
       * Extension.
       *
       * - If the service account is specified,
       * the `iam.serviceAccounts.getAccessToken` permission should be granted
       * to Vertex AI Extension Service Agent
       * (https://cloud.google.com/vertex-ai/docs/general/access-control#service-agents)
       * on the provided service account.
       * </pre>
       *
       * <code>string service_account = 2;</code>
       *
       * @return The bytes for serviceAccount.
       */
      @java.lang.Override
      public com.google.protobuf.ByteString getServiceAccountBytes() {
        java.lang.Object ref = "";
        if (oauthConfigCase_ == 2) {
          ref = oauthConfig_;
        }
        if (ref instanceof String) {
          com.google.protobuf.ByteString b =
              com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
          if (oauthConfigCase_ == 2) {
            oauthConfig_ = b;
          }
          return b;
        } else {
          return (com.google.protobuf.ByteString) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * The service account used to generate access tokens for executing the
       * Extension.
       *
       * - If the service account is specified,
       * the `iam.serviceAccounts.getAccessToken` permission should be granted
       * to Vertex AI Extension Service Agent
       * (https://cloud.google.com/vertex-ai/docs/general/access-control#service-agents)
       * on the provided service account.
       * </pre>
       *
       * <code>string service_account = 2;</code>
       *
       * @param value The serviceAccount to set.
       * @return This builder for chaining.
       */
      public Builder setServiceAccount(java.lang.String value) {
        if (value == null) {
          throw new NullPointerException();
        }
        oauthConfigCase_ = 2;
        oauthConfig_ = value;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * The service account used to generate access tokens for executing the
       * Extension.
       *
       * - If the service account is specified,
       * the `iam.serviceAccounts.getAccessToken` permission should be granted
       * to Vertex AI Extension Service Agent
       * (https://cloud.google.com/vertex-ai/docs/general/access-control#service-agents)
       * on the provided service account.
       * </pre>
       *
       * <code>string service_account = 2;</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearServiceAccount() {
        if (oauthConfigCase_ == 2) {
          oauthConfigCase_ = 0;
          oauthConfig_ = null;
          onChanged();
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * The service account used to generate access tokens for executing the
       * Extension.
       *
       * - If the service account is specified,
       * the `iam.serviceAccounts.getAccessToken` permission should be granted
       * to Vertex AI Extension Service Agent
       * (https://cloud.google.com/vertex-ai/docs/general/access-control#service-agents)
       * on the provided service account.
       * </pre>
       *
       * <code>string service_account = 2;</code>
       *
       * @param value The bytes for serviceAccount to set.
       * @return This builder for chaining.
       */
      public Builder setServiceAccountBytes(com.google.protobuf.ByteString value) {
        if (value == null) {
          throw new NullPointerException();
        }
        checkByteStringIsUtf8(value);
        oauthConfigCase_ = 2;
        oauthConfig_ = value;
        onChanged();
        return this;
      }

      @java.lang.Override
      public final Builder setUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.setUnknownFields(unknownFields);
      }

      @java.lang.Override
      public final Builder mergeUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.mergeUnknownFields(unknownFields);
      }

      // @@protoc_insertion_point(builder_scope:google.cloud.aiplatform.v1beta1.AuthConfig.OauthConfig)
    }

    // @@protoc_insertion_point(class_scope:google.cloud.aiplatform.v1beta1.AuthConfig.OauthConfig)
    private static final com.google.cloud.aiplatform.v1beta1.AuthConfig.OauthConfig
        DEFAULT_INSTANCE;

    static {
      DEFAULT_INSTANCE = new com.google.cloud.aiplatform.v1beta1.AuthConfig.OauthConfig();
    }

    public static com.google.cloud.aiplatform.v1beta1.AuthConfig.OauthConfig getDefaultInstance() {
      return DEFAULT_INSTANCE;
    }

    private static final com.google.protobuf.Parser<OauthConfig> PARSER =
        new com.google.protobuf.AbstractParser<OauthConfig>() {
          @java.lang.Override
          public OauthConfig parsePartialFrom(
              com.google.protobuf.CodedInputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
            Builder builder = newBuilder();
            try {
              builder.mergeFrom(input, extensionRegistry);
            } catch (com.google.protobuf.InvalidProtocolBufferException e) {
              throw e.setUnfinishedMessage(builder.buildPartial());
            } catch (com.google.protobuf.UninitializedMessageException e) {
              throw e.asInvalidProtocolBufferException()
                  .setUnfinishedMessage(builder.buildPartial());
            } catch (java.io.IOException e) {
              throw new com.google.protobuf.InvalidProtocolBufferException(e)
                  .setUnfinishedMessage(builder.buildPartial());
            }
            return builder.buildPartial();
          }
        };

    public static com.google.protobuf.Parser<OauthConfig> parser() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.protobuf.Parser<OauthConfig> getParserForType() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.cloud.aiplatform.v1beta1.AuthConfig.OauthConfig getDefaultInstanceForType() {
      return DEFAULT_INSTANCE;
    }
  }

  public interface OidcConfigOrBuilder
      extends
      // @@protoc_insertion_point(interface_extends:google.cloud.aiplatform.v1beta1.AuthConfig.OidcConfig)
      com.google.protobuf.MessageOrBuilder {

    /**
     *
     *
     * <pre>
     * OpenID Connect formatted ID token for extension endpoint.
     * Only used to propagate token from
     * [[ExecuteExtensionRequest.runtime_auth_config]] at request time.
     * </pre>
     *
     * <code>string id_token = 1;</code>
     *
     * @return Whether the idToken field is set.
     */
    boolean hasIdToken();
    /**
     *
     *
     * <pre>
     * OpenID Connect formatted ID token for extension endpoint.
     * Only used to propagate token from
     * [[ExecuteExtensionRequest.runtime_auth_config]] at request time.
     * </pre>
     *
     * <code>string id_token = 1;</code>
     *
     * @return The idToken.
     */
    java.lang.String getIdToken();
    /**
     *
     *
     * <pre>
     * OpenID Connect formatted ID token for extension endpoint.
     * Only used to propagate token from
     * [[ExecuteExtensionRequest.runtime_auth_config]] at request time.
     * </pre>
     *
     * <code>string id_token = 1;</code>
     *
     * @return The bytes for idToken.
     */
    com.google.protobuf.ByteString getIdTokenBytes();

    /**
     *
     *
     * <pre>
     * The service account used to generate an OpenID Connect
     * (OIDC)-compatible JWT token signed by the Google OIDC Provider
     * (accounts.google.com) for extension endpoint
     * (https://cloud.google.com/iam/docs/create-short-lived-credentials-direct#sa-credentials-oidc).
     *
     * - The audience for the token will be set to the URL in the server url
     * defined in the OpenApi spec.
     *
     * - If the service account is provided, the service account should grant
     * `iam.serviceAccounts.getOpenIdToken` permission to Vertex AI Extension
     * Service Agent
     * (https://cloud.google.com/vertex-ai/docs/general/access-control#service-agents).
     * </pre>
     *
     * <code>string service_account = 2;</code>
     *
     * @return Whether the serviceAccount field is set.
     */
    boolean hasServiceAccount();
    /**
     *
     *
     * <pre>
     * The service account used to generate an OpenID Connect
     * (OIDC)-compatible JWT token signed by the Google OIDC Provider
     * (accounts.google.com) for extension endpoint
     * (https://cloud.google.com/iam/docs/create-short-lived-credentials-direct#sa-credentials-oidc).
     *
     * - The audience for the token will be set to the URL in the server url
     * defined in the OpenApi spec.
     *
     * - If the service account is provided, the service account should grant
     * `iam.serviceAccounts.getOpenIdToken` permission to Vertex AI Extension
     * Service Agent
     * (https://cloud.google.com/vertex-ai/docs/general/access-control#service-agents).
     * </pre>
     *
     * <code>string service_account = 2;</code>
     *
     * @return The serviceAccount.
     */
    java.lang.String getServiceAccount();
    /**
     *
     *
     * <pre>
     * The service account used to generate an OpenID Connect
     * (OIDC)-compatible JWT token signed by the Google OIDC Provider
     * (accounts.google.com) for extension endpoint
     * (https://cloud.google.com/iam/docs/create-short-lived-credentials-direct#sa-credentials-oidc).
     *
     * - The audience for the token will be set to the URL in the server url
     * defined in the OpenApi spec.
     *
     * - If the service account is provided, the service account should grant
     * `iam.serviceAccounts.getOpenIdToken` permission to Vertex AI Extension
     * Service Agent
     * (https://cloud.google.com/vertex-ai/docs/general/access-control#service-agents).
     * </pre>
     *
     * <code>string service_account = 2;</code>
     *
     * @return The bytes for serviceAccount.
     */
    com.google.protobuf.ByteString getServiceAccountBytes();

    com.google.cloud.aiplatform.v1beta1.AuthConfig.OidcConfig.OidcConfigCase getOidcConfigCase();
  }
  /**
   *
   *
   * <pre>
   * Config for user OIDC auth.
   * </pre>
   *
   * Protobuf type {@code google.cloud.aiplatform.v1beta1.AuthConfig.OidcConfig}
   */
  public static final class OidcConfig extends com.google.protobuf.GeneratedMessageV3
      implements
      // @@protoc_insertion_point(message_implements:google.cloud.aiplatform.v1beta1.AuthConfig.OidcConfig)
      OidcConfigOrBuilder {
    private static final long serialVersionUID = 0L;
    // Use OidcConfig.newBuilder() to construct.
    private OidcConfig(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
      super(builder);
    }

    private OidcConfig() {}

    @java.lang.Override
    @SuppressWarnings({"unused"})
    protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
      return new OidcConfig();
    }

    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.aiplatform.v1beta1.ExtensionProto
          .internal_static_google_cloud_aiplatform_v1beta1_AuthConfig_OidcConfig_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.aiplatform.v1beta1.ExtensionProto
          .internal_static_google_cloud_aiplatform_v1beta1_AuthConfig_OidcConfig_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.aiplatform.v1beta1.AuthConfig.OidcConfig.class,
              com.google.cloud.aiplatform.v1beta1.AuthConfig.OidcConfig.Builder.class);
    }

    private int oidcConfigCase_ = 0;

    @SuppressWarnings("serial")
    private java.lang.Object oidcConfig_;

    public enum OidcConfigCase
        implements
            com.google.protobuf.Internal.EnumLite,
            com.google.protobuf.AbstractMessage.InternalOneOfEnum {
      ID_TOKEN(1),
      SERVICE_ACCOUNT(2),
      OIDCCONFIG_NOT_SET(0);
      private final int value;

      private OidcConfigCase(int value) {
        this.value = value;
      }
      /**
       * @param value The number of the enum to look for.
       * @return The enum associated with the given number.
       * @deprecated Use {@link #forNumber(int)} instead.
       */
      @java.lang.Deprecated
      public static OidcConfigCase valueOf(int value) {
        return forNumber(value);
      }

      public static OidcConfigCase forNumber(int value) {
        switch (value) {
          case 1:
            return ID_TOKEN;
          case 2:
            return SERVICE_ACCOUNT;
          case 0:
            return OIDCCONFIG_NOT_SET;
          default:
            return null;
        }
      }

      public int getNumber() {
        return this.value;
      }
    };

    public OidcConfigCase getOidcConfigCase() {
      return OidcConfigCase.forNumber(oidcConfigCase_);
    }

    public static final int ID_TOKEN_FIELD_NUMBER = 1;
    /**
     *
     *
     * <pre>
     * OpenID Connect formatted ID token for extension endpoint.
     * Only used to propagate token from
     * [[ExecuteExtensionRequest.runtime_auth_config]] at request time.
     * </pre>
     *
     * <code>string id_token = 1;</code>
     *
     * @return Whether the idToken field is set.
     */
    public boolean hasIdToken() {
      return oidcConfigCase_ == 1;
    }
    /**
     *
     *
     * <pre>
     * OpenID Connect formatted ID token for extension endpoint.
     * Only used to propagate token from
     * [[ExecuteExtensionRequest.runtime_auth_config]] at request time.
     * </pre>
     *
     * <code>string id_token = 1;</code>
     *
     * @return The idToken.
     */
    public java.lang.String getIdToken() {
      java.lang.Object ref = "";
      if (oidcConfigCase_ == 1) {
        ref = oidcConfig_;
      }
      if (ref instanceof java.lang.String) {
        return (java.lang.String) ref;
      } else {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        if (oidcConfigCase_ == 1) {
          oidcConfig_ = s;
        }
        return s;
      }
    }
    /**
     *
     *
     * <pre>
     * OpenID Connect formatted ID token for extension endpoint.
     * Only used to propagate token from
     * [[ExecuteExtensionRequest.runtime_auth_config]] at request time.
     * </pre>
     *
     * <code>string id_token = 1;</code>
     *
     * @return The bytes for idToken.
     */
    public com.google.protobuf.ByteString getIdTokenBytes() {
      java.lang.Object ref = "";
      if (oidcConfigCase_ == 1) {
        ref = oidcConfig_;
      }
      if (ref instanceof java.lang.String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        if (oidcConfigCase_ == 1) {
          oidcConfig_ = b;
        }
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    public static final int SERVICE_ACCOUNT_FIELD_NUMBER = 2;
    /**
     *
     *
     * <pre>
     * The service account used to generate an OpenID Connect
     * (OIDC)-compatible JWT token signed by the Google OIDC Provider
     * (accounts.google.com) for extension endpoint
     * (https://cloud.google.com/iam/docs/create-short-lived-credentials-direct#sa-credentials-oidc).
     *
     * - The audience for the token will be set to the URL in the server url
     * defined in the OpenApi spec.
     *
     * - If the service account is provided, the service account should grant
     * `iam.serviceAccounts.getOpenIdToken` permission to Vertex AI Extension
     * Service Agent
     * (https://cloud.google.com/vertex-ai/docs/general/access-control#service-agents).
     * </pre>
     *
     * <code>string service_account = 2;</code>
     *
     * @return Whether the serviceAccount field is set.
     */
    public boolean hasServiceAccount() {
      return oidcConfigCase_ == 2;
    }
    /**
     *
     *
     * <pre>
     * The service account used to generate an OpenID Connect
     * (OIDC)-compatible JWT token signed by the Google OIDC Provider
     * (accounts.google.com) for extension endpoint
     * (https://cloud.google.com/iam/docs/create-short-lived-credentials-direct#sa-credentials-oidc).
     *
     * - The audience for the token will be set to the URL in the server url
     * defined in the OpenApi spec.
     *
     * - If the service account is provided, the service account should grant
     * `iam.serviceAccounts.getOpenIdToken` permission to Vertex AI Extension
     * Service Agent
     * (https://cloud.google.com/vertex-ai/docs/general/access-control#service-agents).
     * </pre>
     *
     * <code>string service_account = 2;</code>
     *
     * @return The serviceAccount.
     */
    public java.lang.String getServiceAccount() {
      java.lang.Object ref = "";
      if (oidcConfigCase_ == 2) {
        ref = oidcConfig_;
      }
      if (ref instanceof java.lang.String) {
        return (java.lang.String) ref;
      } else {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        if (oidcConfigCase_ == 2) {
          oidcConfig_ = s;
        }
        return s;
      }
    }
    /**
     *
     *
     * <pre>
     * The service account used to generate an OpenID Connect
     * (OIDC)-compatible JWT token signed by the Google OIDC Provider
     * (accounts.google.com) for extension endpoint
     * (https://cloud.google.com/iam/docs/create-short-lived-credentials-direct#sa-credentials-oidc).
     *
     * - The audience for the token will be set to the URL in the server url
     * defined in the OpenApi spec.
     *
     * - If the service account is provided, the service account should grant
     * `iam.serviceAccounts.getOpenIdToken` permission to Vertex AI Extension
     * Service Agent
     * (https://cloud.google.com/vertex-ai/docs/general/access-control#service-agents).
     * </pre>
     *
     * <code>string service_account = 2;</code>
     *
     * @return The bytes for serviceAccount.
     */
    public com.google.protobuf.ByteString getServiceAccountBytes() {
      java.lang.Object ref = "";
      if (oidcConfigCase_ == 2) {
        ref = oidcConfig_;
      }
      if (ref instanceof java.lang.String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        if (oidcConfigCase_ == 2) {
          oidcConfig_ = b;
        }
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    private byte memoizedIsInitialized = -1;

    @java.lang.Override
    public final boolean isInitialized() {
      byte isInitialized = memoizedIsInitialized;
      if (isInitialized == 1) return true;
      if (isInitialized == 0) return false;

      memoizedIsInitialized = 1;
      return true;
    }

    @java.lang.Override
    public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
      if (oidcConfigCase_ == 1) {
        com.google.protobuf.GeneratedMessageV3.writeString(output, 1, oidcConfig_);
      }
      if (oidcConfigCase_ == 2) {
        com.google.protobuf.GeneratedMessageV3.writeString(output, 2, oidcConfig_);
      }
      getUnknownFields().writeTo(output);
    }

    @java.lang.Override
    public int getSerializedSize() {
      int size = memoizedSize;
      if (size != -1) return size;

      size = 0;
      if (oidcConfigCase_ == 1) {
        size += com.google.protobuf.GeneratedMessageV3.computeStringSize(1, oidcConfig_);
      }
      if (oidcConfigCase_ == 2) {
        size += com.google.protobuf.GeneratedMessageV3.computeStringSize(2, oidcConfig_);
      }
      size += getUnknownFields().getSerializedSize();
      memoizedSize = size;
      return size;
    }

    @java.lang.Override
    public boolean equals(final java.lang.Object obj) {
      if (obj == this) {
        return true;
      }
      if (!(obj instanceof com.google.cloud.aiplatform.v1beta1.AuthConfig.OidcConfig)) {
        return super.equals(obj);
      }
      com.google.cloud.aiplatform.v1beta1.AuthConfig.OidcConfig other =
          (com.google.cloud.aiplatform.v1beta1.AuthConfig.OidcConfig) obj;

      if (!getOidcConfigCase().equals(other.getOidcConfigCase())) return false;
      switch (oidcConfigCase_) {
        case 1:
          if (!getIdToken().equals(other.getIdToken())) return false;
          break;
        case 2:
          if (!getServiceAccount().equals(other.getServiceAccount())) return false;
          break;
        case 0:
        default:
      }
      if (!getUnknownFields().equals(other.getUnknownFields())) return false;
      return true;
    }

    @java.lang.Override
    public int hashCode() {
      if (memoizedHashCode != 0) {
        return memoizedHashCode;
      }
      int hash = 41;
      hash = (19 * hash) + getDescriptor().hashCode();
      switch (oidcConfigCase_) {
        case 1:
          hash = (37 * hash) + ID_TOKEN_FIELD_NUMBER;
          hash = (53 * hash) + getIdToken().hashCode();
          break;
        case 2:
          hash = (37 * hash) + SERVICE_ACCOUNT_FIELD_NUMBER;
          hash = (53 * hash) + getServiceAccount().hashCode();
          break;
        case 0:
        default:
      }
      hash = (29 * hash) + getUnknownFields().hashCode();
      memoizedHashCode = hash;
      return hash;
    }

    public static com.google.cloud.aiplatform.v1beta1.AuthConfig.OidcConfig parseFrom(
        java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.aiplatform.v1beta1.AuthConfig.OidcConfig parseFrom(
        java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.aiplatform.v1beta1.AuthConfig.OidcConfig parseFrom(
        com.google.protobuf.ByteString data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.aiplatform.v1beta1.AuthConfig.OidcConfig parseFrom(
        com.google.protobuf.ByteString data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.aiplatform.v1beta1.AuthConfig.OidcConfig parseFrom(byte[] data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.aiplatform.v1beta1.AuthConfig.OidcConfig parseFrom(
        byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.aiplatform.v1beta1.AuthConfig.OidcConfig parseFrom(
        java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.cloud.aiplatform.v1beta1.AuthConfig.OidcConfig parseFrom(
        java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.cloud.aiplatform.v1beta1.AuthConfig.OidcConfig parseDelimitedFrom(
        java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
    }

    public static com.google.cloud.aiplatform.v1beta1.AuthConfig.OidcConfig parseDelimitedFrom(
        java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.cloud.aiplatform.v1beta1.AuthConfig.OidcConfig parseFrom(
        com.google.protobuf.CodedInputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.cloud.aiplatform.v1beta1.AuthConfig.OidcConfig parseFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    @java.lang.Override
    public Builder newBuilderForType() {
      return newBuilder();
    }

    public static Builder newBuilder() {
      return DEFAULT_INSTANCE.toBuilder();
    }

    public static Builder newBuilder(
        com.google.cloud.aiplatform.v1beta1.AuthConfig.OidcConfig prototype) {
      return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }

    @java.lang.Override
    public Builder toBuilder() {
      return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
    }

    @java.lang.Override
    protected Builder newBuilderForType(
        com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      Builder builder = new Builder(parent);
      return builder;
    }
    /**
     *
     *
     * <pre>
     * Config for user OIDC auth.
     * </pre>
     *
     * Protobuf type {@code google.cloud.aiplatform.v1beta1.AuthConfig.OidcConfig}
     */
    public static final class Builder
        extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
        implements
        // @@protoc_insertion_point(builder_implements:google.cloud.aiplatform.v1beta1.AuthConfig.OidcConfig)
        com.google.cloud.aiplatform.v1beta1.AuthConfig.OidcConfigOrBuilder {
      public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
        return com.google.cloud.aiplatform.v1beta1.ExtensionProto
            .internal_static_google_cloud_aiplatform_v1beta1_AuthConfig_OidcConfig_descriptor;
      }

      @java.lang.Override
      protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return com.google.cloud.aiplatform.v1beta1.ExtensionProto
            .internal_static_google_cloud_aiplatform_v1beta1_AuthConfig_OidcConfig_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                com.google.cloud.aiplatform.v1beta1.AuthConfig.OidcConfig.class,
                com.google.cloud.aiplatform.v1beta1.AuthConfig.OidcConfig.Builder.class);
      }

      // Construct using com.google.cloud.aiplatform.v1beta1.AuthConfig.OidcConfig.newBuilder()
      private Builder() {}

      private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
        super(parent);
      }

      @java.lang.Override
      public Builder clear() {
        super.clear();
        bitField0_ = 0;
        oidcConfigCase_ = 0;
        oidcConfig_ = null;
        return this;
      }

      @java.lang.Override
      public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
        return com.google.cloud.aiplatform.v1beta1.ExtensionProto
            .internal_static_google_cloud_aiplatform_v1beta1_AuthConfig_OidcConfig_descriptor;
      }

      @java.lang.Override
      public com.google.cloud.aiplatform.v1beta1.AuthConfig.OidcConfig getDefaultInstanceForType() {
        return com.google.cloud.aiplatform.v1beta1.AuthConfig.OidcConfig.getDefaultInstance();
      }

      @java.lang.Override
      public com.google.cloud.aiplatform.v1beta1.AuthConfig.OidcConfig build() {
        com.google.cloud.aiplatform.v1beta1.AuthConfig.OidcConfig result = buildPartial();
        if (!result.isInitialized()) {
          throw newUninitializedMessageException(result);
        }
        return result;
      }

      @java.lang.Override
      public com.google.cloud.aiplatform.v1beta1.AuthConfig.OidcConfig buildPartial() {
        com.google.cloud.aiplatform.v1beta1.AuthConfig.OidcConfig result =
            new com.google.cloud.aiplatform.v1beta1.AuthConfig.OidcConfig(this);
        if (bitField0_ != 0) {
          buildPartial0(result);
        }
        buildPartialOneofs(result);
        onBuilt();
        return result;
      }

      private void buildPartial0(com.google.cloud.aiplatform.v1beta1.AuthConfig.OidcConfig result) {
        int from_bitField0_ = bitField0_;
      }

      private void buildPartialOneofs(
          com.google.cloud.aiplatform.v1beta1.AuthConfig.OidcConfig result) {
        result.oidcConfigCase_ = oidcConfigCase_;
        result.oidcConfig_ = this.oidcConfig_;
      }

      @java.lang.Override
      public Builder clone() {
        return super.clone();
      }

      @java.lang.Override
      public Builder setField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.setField(field, value);
      }

      @java.lang.Override
      public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
        return super.clearField(field);
      }

      @java.lang.Override
      public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
        return super.clearOneof(oneof);
      }

      @java.lang.Override
      public Builder setRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          int index,
          java.lang.Object value) {
        return super.setRepeatedField(field, index, value);
      }

      @java.lang.Override
      public Builder addRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.addRepeatedField(field, value);
      }

      @java.lang.Override
      public Builder mergeFrom(com.google.protobuf.Message other) {
        if (other instanceof com.google.cloud.aiplatform.v1beta1.AuthConfig.OidcConfig) {
          return mergeFrom((com.google.cloud.aiplatform.v1beta1.AuthConfig.OidcConfig) other);
        } else {
          super.mergeFrom(other);
          return this;
        }
      }

      public Builder mergeFrom(com.google.cloud.aiplatform.v1beta1.AuthConfig.OidcConfig other) {
        if (other == com.google.cloud.aiplatform.v1beta1.AuthConfig.OidcConfig.getDefaultInstance())
          return this;
        switch (other.getOidcConfigCase()) {
          case ID_TOKEN:
            {
              oidcConfigCase_ = 1;
              oidcConfig_ = other.oidcConfig_;
              onChanged();
              break;
            }
          case SERVICE_ACCOUNT:
            {
              oidcConfigCase_ = 2;
              oidcConfig_ = other.oidcConfig_;
              onChanged();
              break;
            }
          case OIDCCONFIG_NOT_SET:
            {
              break;
            }
        }
        this.mergeUnknownFields(other.getUnknownFields());
        onChanged();
        return this;
      }

      @java.lang.Override
      public final boolean isInitialized() {
        return true;
      }

      @java.lang.Override
      public Builder mergeFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        if (extensionRegistry == null) {
          throw new java.lang.NullPointerException();
        }
        try {
          boolean done = false;
          while (!done) {
            int tag = input.readTag();
            switch (tag) {
              case 0:
                done = true;
                break;
              case 10:
                {
                  java.lang.String s = input.readStringRequireUtf8();
                  oidcConfigCase_ = 1;
                  oidcConfig_ = s;
                  break;
                } // case 10
              case 18:
                {
                  java.lang.String s = input.readStringRequireUtf8();
                  oidcConfigCase_ = 2;
                  oidcConfig_ = s;
                  break;
                } // case 18
              default:
                {
                  if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                    done = true; // was an endgroup tag
                  }
                  break;
                } // default:
            } // switch (tag)
          } // while (!done)
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          throw e.unwrapIOException();
        } finally {
          onChanged();
        } // finally
        return this;
      }

      private int oidcConfigCase_ = 0;
      private java.lang.Object oidcConfig_;

      public OidcConfigCase getOidcConfigCase() {
        return OidcConfigCase.forNumber(oidcConfigCase_);
      }

      public Builder clearOidcConfig() {
        oidcConfigCase_ = 0;
        oidcConfig_ = null;
        onChanged();
        return this;
      }

      private int bitField0_;

      /**
       *
       *
       * <pre>
       * OpenID Connect formatted ID token for extension endpoint.
       * Only used to propagate token from
       * [[ExecuteExtensionRequest.runtime_auth_config]] at request time.
       * </pre>
       *
       * <code>string id_token = 1;</code>
       *
       * @return Whether the idToken field is set.
       */
      @java.lang.Override
      public boolean hasIdToken() {
        return oidcConfigCase_ == 1;
      }
      /**
       *
       *
       * <pre>
       * OpenID Connect formatted ID token for extension endpoint.
       * Only used to propagate token from
       * [[ExecuteExtensionRequest.runtime_auth_config]] at request time.
       * </pre>
       *
       * <code>string id_token = 1;</code>
       *
       * @return The idToken.
       */
      @java.lang.Override
      public java.lang.String getIdToken() {
        java.lang.Object ref = "";
        if (oidcConfigCase_ == 1) {
          ref = oidcConfig_;
        }
        if (!(ref instanceof java.lang.String)) {
          com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
          java.lang.String s = bs.toStringUtf8();
          if (oidcConfigCase_ == 1) {
            oidcConfig_ = s;
          }
          return s;
        } else {
          return (java.lang.String) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * OpenID Connect formatted ID token for extension endpoint.
       * Only used to propagate token from
       * [[ExecuteExtensionRequest.runtime_auth_config]] at request time.
       * </pre>
       *
       * <code>string id_token = 1;</code>
       *
       * @return The bytes for idToken.
       */
      @java.lang.Override
      public com.google.protobuf.ByteString getIdTokenBytes() {
        java.lang.Object ref = "";
        if (oidcConfigCase_ == 1) {
          ref = oidcConfig_;
        }
        if (ref instanceof String) {
          com.google.protobuf.ByteString b =
              com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
          if (oidcConfigCase_ == 1) {
            oidcConfig_ = b;
          }
          return b;
        } else {
          return (com.google.protobuf.ByteString) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * OpenID Connect formatted ID token for extension endpoint.
       * Only used to propagate token from
       * [[ExecuteExtensionRequest.runtime_auth_config]] at request time.
       * </pre>
       *
       * <code>string id_token = 1;</code>
       *
       * @param value The idToken to set.
       * @return This builder for chaining.
       */
      public Builder setIdToken(java.lang.String value) {
        if (value == null) {
          throw new NullPointerException();
        }
        oidcConfigCase_ = 1;
        oidcConfig_ = value;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * OpenID Connect formatted ID token for extension endpoint.
       * Only used to propagate token from
       * [[ExecuteExtensionRequest.runtime_auth_config]] at request time.
       * </pre>
       *
       * <code>string id_token = 1;</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearIdToken() {
        if (oidcConfigCase_ == 1) {
          oidcConfigCase_ = 0;
          oidcConfig_ = null;
          onChanged();
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * OpenID Connect formatted ID token for extension endpoint.
       * Only used to propagate token from
       * [[ExecuteExtensionRequest.runtime_auth_config]] at request time.
       * </pre>
       *
       * <code>string id_token = 1;</code>
       *
       * @param value The bytes for idToken to set.
       * @return This builder for chaining.
       */
      public Builder setIdTokenBytes(com.google.protobuf.ByteString value) {
        if (value == null) {
          throw new NullPointerException();
        }
        checkByteStringIsUtf8(value);
        oidcConfigCase_ = 1;
        oidcConfig_ = value;
        onChanged();
        return this;
      }

      /**
       *
       *
       * <pre>
       * The service account used to generate an OpenID Connect
       * (OIDC)-compatible JWT token signed by the Google OIDC Provider
       * (accounts.google.com) for extension endpoint
       * (https://cloud.google.com/iam/docs/create-short-lived-credentials-direct#sa-credentials-oidc).
       *
       * - The audience for the token will be set to the URL in the server url
       * defined in the OpenApi spec.
       *
       * - If the service account is provided, the service account should grant
       * `iam.serviceAccounts.getOpenIdToken` permission to Vertex AI Extension
       * Service Agent
       * (https://cloud.google.com/vertex-ai/docs/general/access-control#service-agents).
       * </pre>
       *
       * <code>string service_account = 2;</code>
       *
       * @return Whether the serviceAccount field is set.
       */
      @java.lang.Override
      public boolean hasServiceAccount() {
        return oidcConfigCase_ == 2;
      }
      /**
       *
       *
       * <pre>
       * The service account used to generate an OpenID Connect
       * (OIDC)-compatible JWT token signed by the Google OIDC Provider
       * (accounts.google.com) for extension endpoint
       * (https://cloud.google.com/iam/docs/create-short-lived-credentials-direct#sa-credentials-oidc).
       *
       * - The audience for the token will be set to the URL in the server url
       * defined in the OpenApi spec.
       *
       * - If the service account is provided, the service account should grant
       * `iam.serviceAccounts.getOpenIdToken` permission to Vertex AI Extension
       * Service Agent
       * (https://cloud.google.com/vertex-ai/docs/general/access-control#service-agents).
       * </pre>
       *
       * <code>string service_account = 2;</code>
       *
       * @return The serviceAccount.
       */
      @java.lang.Override
      public java.lang.String getServiceAccount() {
        java.lang.Object ref = "";
        if (oidcConfigCase_ == 2) {
          ref = oidcConfig_;
        }
        if (!(ref instanceof java.lang.String)) {
          com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
          java.lang.String s = bs.toStringUtf8();
          if (oidcConfigCase_ == 2) {
            oidcConfig_ = s;
          }
          return s;
        } else {
          return (java.lang.String) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * The service account used to generate an OpenID Connect
       * (OIDC)-compatible JWT token signed by the Google OIDC Provider
       * (accounts.google.com) for extension endpoint
       * (https://cloud.google.com/iam/docs/create-short-lived-credentials-direct#sa-credentials-oidc).
       *
       * - The audience for the token will be set to the URL in the server url
       * defined in the OpenApi spec.
       *
       * - If the service account is provided, the service account should grant
       * `iam.serviceAccounts.getOpenIdToken` permission to Vertex AI Extension
       * Service Agent
       * (https://cloud.google.com/vertex-ai/docs/general/access-control#service-agents).
       * </pre>
       *
       * <code>string service_account = 2;</code>
       *
       * @return The bytes for serviceAccount.
       */
      @java.lang.Override
      public com.google.protobuf.ByteString getServiceAccountBytes() {
        java.lang.Object ref = "";
        if (oidcConfigCase_ == 2) {
          ref = oidcConfig_;
        }
        if (ref instanceof String) {
          com.google.protobuf.ByteString b =
              com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
          if (oidcConfigCase_ == 2) {
            oidcConfig_ = b;
          }
          return b;
        } else {
          return (com.google.protobuf.ByteString) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * The service account used to generate an OpenID Connect
       * (OIDC)-compatible JWT token signed by the Google OIDC Provider
       * (accounts.google.com) for extension endpoint
       * (https://cloud.google.com/iam/docs/create-short-lived-credentials-direct#sa-credentials-oidc).
       *
       * - The audience for the token will be set to the URL in the server url
       * defined in the OpenApi spec.
       *
       * - If the service account is provided, the service account should grant
       * `iam.serviceAccounts.getOpenIdToken` permission to Vertex AI Extension
       * Service Agent
       * (https://cloud.google.com/vertex-ai/docs/general/access-control#service-agents).
       * </pre>
       *
       * <code>string service_account = 2;</code>
       *
       * @param value The serviceAccount to set.
       * @return This builder for chaining.
       */
      public Builder setServiceAccount(java.lang.String value) {
        if (value == null) {
          throw new NullPointerException();
        }
        oidcConfigCase_ = 2;
        oidcConfig_ = value;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * The service account used to generate an OpenID Connect
       * (OIDC)-compatible JWT token signed by the Google OIDC Provider
       * (accounts.google.com) for extension endpoint
       * (https://cloud.google.com/iam/docs/create-short-lived-credentials-direct#sa-credentials-oidc).
       *
       * - The audience for the token will be set to the URL in the server url
       * defined in the OpenApi spec.
       *
       * - If the service account is provided, the service account should grant
       * `iam.serviceAccounts.getOpenIdToken` permission to Vertex AI Extension
       * Service Agent
       * (https://cloud.google.com/vertex-ai/docs/general/access-control#service-agents).
       * </pre>
       *
       * <code>string service_account = 2;</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearServiceAccount() {
        if (oidcConfigCase_ == 2) {
          oidcConfigCase_ = 0;
          oidcConfig_ = null;
          onChanged();
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * The service account used to generate an OpenID Connect
       * (OIDC)-compatible JWT token signed by the Google OIDC Provider
       * (accounts.google.com) for extension endpoint
       * (https://cloud.google.com/iam/docs/create-short-lived-credentials-direct#sa-credentials-oidc).
       *
       * - The audience for the token will be set to the URL in the server url
       * defined in the OpenApi spec.
       *
       * - If the service account is provided, the service account should grant
       * `iam.serviceAccounts.getOpenIdToken` permission to Vertex AI Extension
       * Service Agent
       * (https://cloud.google.com/vertex-ai/docs/general/access-control#service-agents).
       * </pre>
       *
       * <code>string service_account = 2;</code>
       *
       * @param value The bytes for serviceAccount to set.
       * @return This builder for chaining.
       */
      public Builder setServiceAccountBytes(com.google.protobuf.ByteString value) {
        if (value == null) {
          throw new NullPointerException();
        }
        checkByteStringIsUtf8(value);
        oidcConfigCase_ = 2;
        oidcConfig_ = value;
        onChanged();
        return this;
      }

      @java.lang.Override
      public final Builder setUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.setUnknownFields(unknownFields);
      }

      @java.lang.Override
      public final Builder mergeUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.mergeUnknownFields(unknownFields);
      }

      // @@protoc_insertion_point(builder_scope:google.cloud.aiplatform.v1beta1.AuthConfig.OidcConfig)
    }

    // @@protoc_insertion_point(class_scope:google.cloud.aiplatform.v1beta1.AuthConfig.OidcConfig)
    private static final com.google.cloud.aiplatform.v1beta1.AuthConfig.OidcConfig DEFAULT_INSTANCE;

    static {
      DEFAULT_INSTANCE = new com.google.cloud.aiplatform.v1beta1.AuthConfig.OidcConfig();
    }

    public static com.google.cloud.aiplatform.v1beta1.AuthConfig.OidcConfig getDefaultInstance() {
      return DEFAULT_INSTANCE;
    }

    private static final com.google.protobuf.Parser<OidcConfig> PARSER =
        new com.google.protobuf.AbstractParser<OidcConfig>() {
          @java.lang.Override
          public OidcConfig parsePartialFrom(
              com.google.protobuf.CodedInputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
            Builder builder = newBuilder();
            try {
              builder.mergeFrom(input, extensionRegistry);
            } catch (com.google.protobuf.InvalidProtocolBufferException e) {
              throw e.setUnfinishedMessage(builder.buildPartial());
            } catch (com.google.protobuf.UninitializedMessageException e) {
              throw e.asInvalidProtocolBufferException()
                  .setUnfinishedMessage(builder.buildPartial());
            } catch (java.io.IOException e) {
              throw new com.google.protobuf.InvalidProtocolBufferException(e)
                  .setUnfinishedMessage(builder.buildPartial());
            }
            return builder.buildPartial();
          }
        };

    public static com.google.protobuf.Parser<OidcConfig> parser() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.protobuf.Parser<OidcConfig> getParserForType() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.cloud.aiplatform.v1beta1.AuthConfig.OidcConfig getDefaultInstanceForType() {
      return DEFAULT_INSTANCE;
    }
  }

  private int authConfigCase_ = 0;

  @SuppressWarnings("serial")
  private java.lang.Object authConfig_;

  public enum AuthConfigCase
      implements
          com.google.protobuf.Internal.EnumLite,
          com.google.protobuf.AbstractMessage.InternalOneOfEnum {
    API_KEY_CONFIG(2),
    HTTP_BASIC_AUTH_CONFIG(3),
    GOOGLE_SERVICE_ACCOUNT_CONFIG(4),
    OAUTH_CONFIG(5),
    OIDC_CONFIG(7),
    AUTHCONFIG_NOT_SET(0);
    private final int value;

    private AuthConfigCase(int value) {
      this.value = value;
    }
    /**
     * @param value The number of the enum to look for.
     * @return The enum associated with the given number.
     * @deprecated Use {@link #forNumber(int)} instead.
     */
    @java.lang.Deprecated
    public static AuthConfigCase valueOf(int value) {
      return forNumber(value);
    }

    public static AuthConfigCase forNumber(int value) {
      switch (value) {
        case 2:
          return API_KEY_CONFIG;
        case 3:
          return HTTP_BASIC_AUTH_CONFIG;
        case 4:
          return GOOGLE_SERVICE_ACCOUNT_CONFIG;
        case 5:
          return OAUTH_CONFIG;
        case 7:
          return OIDC_CONFIG;
        case 0:
          return AUTHCONFIG_NOT_SET;
        default:
          return null;
      }
    }

    public int getNumber() {
      return this.value;
    }
  };

  public AuthConfigCase getAuthConfigCase() {
    return AuthConfigCase.forNumber(authConfigCase_);
  }

  public static final int API_KEY_CONFIG_FIELD_NUMBER = 2;
  /**
   *
   *
   * <pre>
   * Config for API key auth.
   * </pre>
   *
   * <code>.google.cloud.aiplatform.v1beta1.AuthConfig.ApiKeyConfig api_key_config = 2;</code>
   *
   * @return Whether the apiKeyConfig field is set.
   */
  @java.lang.Override
  public boolean hasApiKeyConfig() {
    return authConfigCase_ == 2;
  }
  /**
   *
   *
   * <pre>
   * Config for API key auth.
   * </pre>
   *
   * <code>.google.cloud.aiplatform.v1beta1.AuthConfig.ApiKeyConfig api_key_config = 2;</code>
   *
   * @return The apiKeyConfig.
   */
  @java.lang.Override
  public com.google.cloud.aiplatform.v1beta1.AuthConfig.ApiKeyConfig getApiKeyConfig() {
    if (authConfigCase_ == 2) {
      return (com.google.cloud.aiplatform.v1beta1.AuthConfig.ApiKeyConfig) authConfig_;
    }
    return com.google.cloud.aiplatform.v1beta1.AuthConfig.ApiKeyConfig.getDefaultInstance();
  }
  /**
   *
   *
   * <pre>
   * Config for API key auth.
   * </pre>
   *
   * <code>.google.cloud.aiplatform.v1beta1.AuthConfig.ApiKeyConfig api_key_config = 2;</code>
   */
  @java.lang.Override
  public com.google.cloud.aiplatform.v1beta1.AuthConfig.ApiKeyConfigOrBuilder
      getApiKeyConfigOrBuilder() {
    if (authConfigCase_ == 2) {
      return (com.google.cloud.aiplatform.v1beta1.AuthConfig.ApiKeyConfig) authConfig_;
    }
    return com.google.cloud.aiplatform.v1beta1.AuthConfig.ApiKeyConfig.getDefaultInstance();
  }

  public static final int HTTP_BASIC_AUTH_CONFIG_FIELD_NUMBER = 3;
  /**
   *
   *
   * <pre>
   * Config for HTTP Basic auth.
   * </pre>
   *
   * <code>
   * .google.cloud.aiplatform.v1beta1.AuthConfig.HttpBasicAuthConfig http_basic_auth_config = 3;
   * </code>
   *
   * @return Whether the httpBasicAuthConfig field is set.
   */
  @java.lang.Override
  public boolean hasHttpBasicAuthConfig() {
    return authConfigCase_ == 3;
  }
  /**
   *
   *
   * <pre>
   * Config for HTTP Basic auth.
   * </pre>
   *
   * <code>
   * .google.cloud.aiplatform.v1beta1.AuthConfig.HttpBasicAuthConfig http_basic_auth_config = 3;
   * </code>
   *
   * @return The httpBasicAuthConfig.
   */
  @java.lang.Override
  public com.google.cloud.aiplatform.v1beta1.AuthConfig.HttpBasicAuthConfig
      getHttpBasicAuthConfig() {
    if (authConfigCase_ == 3) {
      return (com.google.cloud.aiplatform.v1beta1.AuthConfig.HttpBasicAuthConfig) authConfig_;
    }
    return com.google.cloud.aiplatform.v1beta1.AuthConfig.HttpBasicAuthConfig.getDefaultInstance();
  }
  /**
   *
   *
   * <pre>
   * Config for HTTP Basic auth.
   * </pre>
   *
   * <code>
   * .google.cloud.aiplatform.v1beta1.AuthConfig.HttpBasicAuthConfig http_basic_auth_config = 3;
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.aiplatform.v1beta1.AuthConfig.HttpBasicAuthConfigOrBuilder
      getHttpBasicAuthConfigOrBuilder() {
    if (authConfigCase_ == 3) {
      return (com.google.cloud.aiplatform.v1beta1.AuthConfig.HttpBasicAuthConfig) authConfig_;
    }
    return com.google.cloud.aiplatform.v1beta1.AuthConfig.HttpBasicAuthConfig.getDefaultInstance();
  }

  public static final int GOOGLE_SERVICE_ACCOUNT_CONFIG_FIELD_NUMBER = 4;
  /**
   *
   *
   * <pre>
   * Config for Google Service Account auth.
   * </pre>
   *
   * <code>
   * .google.cloud.aiplatform.v1beta1.AuthConfig.GoogleServiceAccountConfig google_service_account_config = 4;
   * </code>
   *
   * @return Whether the googleServiceAccountConfig field is set.
   */
  @java.lang.Override
  public boolean hasGoogleServiceAccountConfig() {
    return authConfigCase_ == 4;
  }
  /**
   *
   *
   * <pre>
   * Config for Google Service Account auth.
   * </pre>
   *
   * <code>
   * .google.cloud.aiplatform.v1beta1.AuthConfig.GoogleServiceAccountConfig google_service_account_config = 4;
   * </code>
   *
   * @return The googleServiceAccountConfig.
   */
  @java.lang.Override
  public com.google.cloud.aiplatform.v1beta1.AuthConfig.GoogleServiceAccountConfig
      getGoogleServiceAccountConfig() {
    if (authConfigCase_ == 4) {
      return (com.google.cloud.aiplatform.v1beta1.AuthConfig.GoogleServiceAccountConfig)
          authConfig_;
    }
    return com.google.cloud.aiplatform.v1beta1.AuthConfig.GoogleServiceAccountConfig
        .getDefaultInstance();
  }
  /**
   *
   *
   * <pre>
   * Config for Google Service Account auth.
   * </pre>
   *
   * <code>
   * .google.cloud.aiplatform.v1beta1.AuthConfig.GoogleServiceAccountConfig google_service_account_config = 4;
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.aiplatform.v1beta1.AuthConfig.GoogleServiceAccountConfigOrBuilder
      getGoogleServiceAccountConfigOrBuilder() {
    if (authConfigCase_ == 4) {
      return (com.google.cloud.aiplatform.v1beta1.AuthConfig.GoogleServiceAccountConfig)
          authConfig_;
    }
    return com.google.cloud.aiplatform.v1beta1.AuthConfig.GoogleServiceAccountConfig
        .getDefaultInstance();
  }

  public static final int OAUTH_CONFIG_FIELD_NUMBER = 5;
  /**
   *
   *
   * <pre>
   * Config for user oauth.
   * </pre>
   *
   * <code>.google.cloud.aiplatform.v1beta1.AuthConfig.OauthConfig oauth_config = 5;</code>
   *
   * @return Whether the oauthConfig field is set.
   */
  @java.lang.Override
  public boolean hasOauthConfig() {
    return authConfigCase_ == 5;
  }
  /**
   *
   *
   * <pre>
   * Config for user oauth.
   * </pre>
   *
   * <code>.google.cloud.aiplatform.v1beta1.AuthConfig.OauthConfig oauth_config = 5;</code>
   *
   * @return The oauthConfig.
   */
  @java.lang.Override
  public com.google.cloud.aiplatform.v1beta1.AuthConfig.OauthConfig getOauthConfig() {
    if (authConfigCase_ == 5) {
      return (com.google.cloud.aiplatform.v1beta1.AuthConfig.OauthConfig) authConfig_;
    }
    return com.google.cloud.aiplatform.v1beta1.AuthConfig.OauthConfig.getDefaultInstance();
  }
  /**
   *
   *
   * <pre>
   * Config for user oauth.
   * </pre>
   *
   * <code>.google.cloud.aiplatform.v1beta1.AuthConfig.OauthConfig oauth_config = 5;</code>
   */
  @java.lang.Override
  public com.google.cloud.aiplatform.v1beta1.AuthConfig.OauthConfigOrBuilder
      getOauthConfigOrBuilder() {
    if (authConfigCase_ == 5) {
      return (com.google.cloud.aiplatform.v1beta1.AuthConfig.OauthConfig) authConfig_;
    }
    return com.google.cloud.aiplatform.v1beta1.AuthConfig.OauthConfig.getDefaultInstance();
  }

  public static final int OIDC_CONFIG_FIELD_NUMBER = 7;
  /**
   *
   *
   * <pre>
   * Config for user OIDC auth.
   * </pre>
   *
   * <code>.google.cloud.aiplatform.v1beta1.AuthConfig.OidcConfig oidc_config = 7;</code>
   *
   * @return Whether the oidcConfig field is set.
   */
  @java.lang.Override
  public boolean hasOidcConfig() {
    return authConfigCase_ == 7;
  }
  /**
   *
   *
   * <pre>
   * Config for user OIDC auth.
   * </pre>
   *
   * <code>.google.cloud.aiplatform.v1beta1.AuthConfig.OidcConfig oidc_config = 7;</code>
   *
   * @return The oidcConfig.
   */
  @java.lang.Override
  public com.google.cloud.aiplatform.v1beta1.AuthConfig.OidcConfig getOidcConfig() {
    if (authConfigCase_ == 7) {
      return (com.google.cloud.aiplatform.v1beta1.AuthConfig.OidcConfig) authConfig_;
    }
    return com.google.cloud.aiplatform.v1beta1.AuthConfig.OidcConfig.getDefaultInstance();
  }
  /**
   *
   *
   * <pre>
   * Config for user OIDC auth.
   * </pre>
   *
   * <code>.google.cloud.aiplatform.v1beta1.AuthConfig.OidcConfig oidc_config = 7;</code>
   */
  @java.lang.Override
  public com.google.cloud.aiplatform.v1beta1.AuthConfig.OidcConfigOrBuilder
      getOidcConfigOrBuilder() {
    if (authConfigCase_ == 7) {
      return (com.google.cloud.aiplatform.v1beta1.AuthConfig.OidcConfig) authConfig_;
    }
    return com.google.cloud.aiplatform.v1beta1.AuthConfig.OidcConfig.getDefaultInstance();
  }

  public static final int AUTH_TYPE_FIELD_NUMBER = 101;
  private int authType_ = 0;
  /**
   *
   *
   * <pre>
   * Type of auth scheme.
   * </pre>
   *
   * <code>.google.cloud.aiplatform.v1beta1.AuthType auth_type = 101;</code>
   *
   * @return The enum numeric value on the wire for authType.
   */
  @java.lang.Override
  public int getAuthTypeValue() {
    return authType_;
  }
  /**
   *
   *
   * <pre>
   * Type of auth scheme.
   * </pre>
   *
   * <code>.google.cloud.aiplatform.v1beta1.AuthType auth_type = 101;</code>
   *
   * @return The authType.
   */
  @java.lang.Override
  public com.google.cloud.aiplatform.v1beta1.AuthType getAuthType() {
    com.google.cloud.aiplatform.v1beta1.AuthType result =
        com.google.cloud.aiplatform.v1beta1.AuthType.forNumber(authType_);
    return result == null ? com.google.cloud.aiplatform.v1beta1.AuthType.UNRECOGNIZED : result;
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    if (authConfigCase_ == 2) {
      output.writeMessage(
          2, (com.google.cloud.aiplatform.v1beta1.AuthConfig.ApiKeyConfig) authConfig_);
    }
    if (authConfigCase_ == 3) {
      output.writeMessage(
          3, (com.google.cloud.aiplatform.v1beta1.AuthConfig.HttpBasicAuthConfig) authConfig_);
    }
    if (authConfigCase_ == 4) {
      output.writeMessage(
          4,
          (com.google.cloud.aiplatform.v1beta1.AuthConfig.GoogleServiceAccountConfig) authConfig_);
    }
    if (authConfigCase_ == 5) {
      output.writeMessage(
          5, (com.google.cloud.aiplatform.v1beta1.AuthConfig.OauthConfig) authConfig_);
    }
    if (authConfigCase_ == 7) {
      output.writeMessage(
          7, (com.google.cloud.aiplatform.v1beta1.AuthConfig.OidcConfig) authConfig_);
    }
    if (authType_
        != com.google.cloud.aiplatform.v1beta1.AuthType.AUTH_TYPE_UNSPECIFIED.getNumber()) {
      output.writeEnum(101, authType_);
    }
    getUnknownFields().writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    if (authConfigCase_ == 2) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(
              2, (com.google.cloud.aiplatform.v1beta1.AuthConfig.ApiKeyConfig) authConfig_);
    }
    if (authConfigCase_ == 3) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(
              3, (com.google.cloud.aiplatform.v1beta1.AuthConfig.HttpBasicAuthConfig) authConfig_);
    }
    if (authConfigCase_ == 4) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(
              4,
              (com.google.cloud.aiplatform.v1beta1.AuthConfig.GoogleServiceAccountConfig)
                  authConfig_);
    }
    if (authConfigCase_ == 5) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(
              5, (com.google.cloud.aiplatform.v1beta1.AuthConfig.OauthConfig) authConfig_);
    }
    if (authConfigCase_ == 7) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(
              7, (com.google.cloud.aiplatform.v1beta1.AuthConfig.OidcConfig) authConfig_);
    }
    if (authType_
        != com.google.cloud.aiplatform.v1beta1.AuthType.AUTH_TYPE_UNSPECIFIED.getNumber()) {
      size += com.google.protobuf.CodedOutputStream.computeEnumSize(101, authType_);
    }
    size += getUnknownFields().getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.cloud.aiplatform.v1beta1.AuthConfig)) {
      return super.equals(obj);
    }
    com.google.cloud.aiplatform.v1beta1.AuthConfig other =
        (com.google.cloud.aiplatform.v1beta1.AuthConfig) obj;

    if (authType_ != other.authType_) return false;
    if (!getAuthConfigCase().equals(other.getAuthConfigCase())) return false;
    switch (authConfigCase_) {
      case 2:
        if (!getApiKeyConfig().equals(other.getApiKeyConfig())) return false;
        break;
      case 3:
        if (!getHttpBasicAuthConfig().equals(other.getHttpBasicAuthConfig())) return false;
        break;
      case 4:
        if (!getGoogleServiceAccountConfig().equals(other.getGoogleServiceAccountConfig()))
          return false;
        break;
      case 5:
        if (!getOauthConfig().equals(other.getOauthConfig())) return false;
        break;
      case 7:
        if (!getOidcConfig().equals(other.getOidcConfig())) return false;
        break;
      case 0:
      default:
    }
    if (!getUnknownFields().equals(other.getUnknownFields())) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    hash = (37 * hash) + AUTH_TYPE_FIELD_NUMBER;
    hash = (53 * hash) + authType_;
    switch (authConfigCase_) {
      case 2:
        hash = (37 * hash) + API_KEY_CONFIG_FIELD_NUMBER;
        hash = (53 * hash) + getApiKeyConfig().hashCode();
        break;
      case 3:
        hash = (37 * hash) + HTTP_BASIC_AUTH_CONFIG_FIELD_NUMBER;
        hash = (53 * hash) + getHttpBasicAuthConfig().hashCode();
        break;
      case 4:
        hash = (37 * hash) + GOOGLE_SERVICE_ACCOUNT_CONFIG_FIELD_NUMBER;
        hash = (53 * hash) + getGoogleServiceAccountConfig().hashCode();
        break;
      case 5:
        hash = (37 * hash) + OAUTH_CONFIG_FIELD_NUMBER;
        hash = (53 * hash) + getOauthConfig().hashCode();
        break;
      case 7:
        hash = (37 * hash) + OIDC_CONFIG_FIELD_NUMBER;
        hash = (53 * hash) + getOidcConfig().hashCode();
        break;
      case 0:
      default:
    }
    hash = (29 * hash) + getUnknownFields().hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.cloud.aiplatform.v1beta1.AuthConfig parseFrom(java.nio.ByteBuffer data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.aiplatform.v1beta1.AuthConfig parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.aiplatform.v1beta1.AuthConfig parseFrom(
      com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.aiplatform.v1beta1.AuthConfig parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.aiplatform.v1beta1.AuthConfig parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.aiplatform.v1beta1.AuthConfig parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.aiplatform.v1beta1.AuthConfig parseFrom(java.io.InputStream input)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.aiplatform.v1beta1.AuthConfig parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.aiplatform.v1beta1.AuthConfig parseDelimitedFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.cloud.aiplatform.v1beta1.AuthConfig parseDelimitedFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.aiplatform.v1beta1.AuthConfig parseFrom(
      com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.aiplatform.v1beta1.AuthConfig parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(com.google.cloud.aiplatform.v1beta1.AuthConfig prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }
  /**
   *
   *
   * <pre>
   * Auth configuration to run the extension.
   * </pre>
   *
   * Protobuf type {@code google.cloud.aiplatform.v1beta1.AuthConfig}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.cloud.aiplatform.v1beta1.AuthConfig)
      com.google.cloud.aiplatform.v1beta1.AuthConfigOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.aiplatform.v1beta1.ExtensionProto
          .internal_static_google_cloud_aiplatform_v1beta1_AuthConfig_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.aiplatform.v1beta1.ExtensionProto
          .internal_static_google_cloud_aiplatform_v1beta1_AuthConfig_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.aiplatform.v1beta1.AuthConfig.class,
              com.google.cloud.aiplatform.v1beta1.AuthConfig.Builder.class);
    }

    // Construct using com.google.cloud.aiplatform.v1beta1.AuthConfig.newBuilder()
    private Builder() {}

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      bitField0_ = 0;
      if (apiKeyConfigBuilder_ != null) {
        apiKeyConfigBuilder_.clear();
      }
      if (httpBasicAuthConfigBuilder_ != null) {
        httpBasicAuthConfigBuilder_.clear();
      }
      if (googleServiceAccountConfigBuilder_ != null) {
        googleServiceAccountConfigBuilder_.clear();
      }
      if (oauthConfigBuilder_ != null) {
        oauthConfigBuilder_.clear();
      }
      if (oidcConfigBuilder_ != null) {
        oidcConfigBuilder_.clear();
      }
      authType_ = 0;
      authConfigCase_ = 0;
      authConfig_ = null;
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.cloud.aiplatform.v1beta1.ExtensionProto
          .internal_static_google_cloud_aiplatform_v1beta1_AuthConfig_descriptor;
    }

    @java.lang.Override
    public com.google.cloud.aiplatform.v1beta1.AuthConfig getDefaultInstanceForType() {
      return com.google.cloud.aiplatform.v1beta1.AuthConfig.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.cloud.aiplatform.v1beta1.AuthConfig build() {
      com.google.cloud.aiplatform.v1beta1.AuthConfig result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.cloud.aiplatform.v1beta1.AuthConfig buildPartial() {
      com.google.cloud.aiplatform.v1beta1.AuthConfig result =
          new com.google.cloud.aiplatform.v1beta1.AuthConfig(this);
      if (bitField0_ != 0) {
        buildPartial0(result);
      }
      buildPartialOneofs(result);
      onBuilt();
      return result;
    }

    private void buildPartial0(com.google.cloud.aiplatform.v1beta1.AuthConfig result) {
      int from_bitField0_ = bitField0_;
      if (((from_bitField0_ & 0x00000020) != 0)) {
        result.authType_ = authType_;
      }
    }

    private void buildPartialOneofs(com.google.cloud.aiplatform.v1beta1.AuthConfig result) {
      result.authConfigCase_ = authConfigCase_;
      result.authConfig_ = this.authConfig_;
      if (authConfigCase_ == 2 && apiKeyConfigBuilder_ != null) {
        result.authConfig_ = apiKeyConfigBuilder_.build();
      }
      if (authConfigCase_ == 3 && httpBasicAuthConfigBuilder_ != null) {
        result.authConfig_ = httpBasicAuthConfigBuilder_.build();
      }
      if (authConfigCase_ == 4 && googleServiceAccountConfigBuilder_ != null) {
        result.authConfig_ = googleServiceAccountConfigBuilder_.build();
      }
      if (authConfigCase_ == 5 && oauthConfigBuilder_ != null) {
        result.authConfig_ = oauthConfigBuilder_.build();
      }
      if (authConfigCase_ == 7 && oidcConfigBuilder_ != null) {
        result.authConfig_ = oidcConfigBuilder_.build();
      }
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.cloud.aiplatform.v1beta1.AuthConfig) {
        return mergeFrom((com.google.cloud.aiplatform.v1beta1.AuthConfig) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(com.google.cloud.aiplatform.v1beta1.AuthConfig other) {
      if (other == com.google.cloud.aiplatform.v1beta1.AuthConfig.getDefaultInstance()) return this;
      if (other.authType_ != 0) {
        setAuthTypeValue(other.getAuthTypeValue());
      }
      switch (other.getAuthConfigCase()) {
        case API_KEY_CONFIG:
          {
            mergeApiKeyConfig(other.getApiKeyConfig());
            break;
          }
        case HTTP_BASIC_AUTH_CONFIG:
          {
            mergeHttpBasicAuthConfig(other.getHttpBasicAuthConfig());
            break;
          }
        case GOOGLE_SERVICE_ACCOUNT_CONFIG:
          {
            mergeGoogleServiceAccountConfig(other.getGoogleServiceAccountConfig());
            break;
          }
        case OAUTH_CONFIG:
          {
            mergeOauthConfig(other.getOauthConfig());
            break;
          }
        case OIDC_CONFIG:
          {
            mergeOidcConfig(other.getOidcConfig());
            break;
          }
        case AUTHCONFIG_NOT_SET:
          {
            break;
          }
      }
      this.mergeUnknownFields(other.getUnknownFields());
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 18:
              {
                input.readMessage(getApiKeyConfigFieldBuilder().getBuilder(), extensionRegistry);
                authConfigCase_ = 2;
                break;
              } // case 18
            case 26:
              {
                input.readMessage(
                    getHttpBasicAuthConfigFieldBuilder().getBuilder(), extensionRegistry);
                authConfigCase_ = 3;
                break;
              } // case 26
            case 34:
              {
                input.readMessage(
                    getGoogleServiceAccountConfigFieldBuilder().getBuilder(), extensionRegistry);
                authConfigCase_ = 4;
                break;
              } // case 34
            case 42:
              {
                input.readMessage(getOauthConfigFieldBuilder().getBuilder(), extensionRegistry);
                authConfigCase_ = 5;
                break;
              } // case 42
            case 58:
              {
                input.readMessage(getOidcConfigFieldBuilder().getBuilder(), extensionRegistry);
                authConfigCase_ = 7;
                break;
              } // case 58
            case 808:
              {
                authType_ = input.readEnum();
                bitField0_ |= 0x00000020;
                break;
              } // case 808
            default:
              {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
          } // switch (tag)
        } // while (!done)
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.unwrapIOException();
      } finally {
        onChanged();
      } // finally
      return this;
    }

    private int authConfigCase_ = 0;
    private java.lang.Object authConfig_;

    public AuthConfigCase getAuthConfigCase() {
      return AuthConfigCase.forNumber(authConfigCase_);
    }

    public Builder clearAuthConfig() {
      authConfigCase_ = 0;
      authConfig_ = null;
      onChanged();
      return this;
    }

    private int bitField0_;

    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.aiplatform.v1beta1.AuthConfig.ApiKeyConfig,
            com.google.cloud.aiplatform.v1beta1.AuthConfig.ApiKeyConfig.Builder,
            com.google.cloud.aiplatform.v1beta1.AuthConfig.ApiKeyConfigOrBuilder>
        apiKeyConfigBuilder_;
    /**
     *
     *
     * <pre>
     * Config for API key auth.
     * </pre>
     *
     * <code>.google.cloud.aiplatform.v1beta1.AuthConfig.ApiKeyConfig api_key_config = 2;</code>
     *
     * @return Whether the apiKeyConfig field is set.
     */
    @java.lang.Override
    public boolean hasApiKeyConfig() {
      return authConfigCase_ == 2;
    }
    /**
     *
     *
     * <pre>
     * Config for API key auth.
     * </pre>
     *
     * <code>.google.cloud.aiplatform.v1beta1.AuthConfig.ApiKeyConfig api_key_config = 2;</code>
     *
     * @return The apiKeyConfig.
     */
    @java.lang.Override
    public com.google.cloud.aiplatform.v1beta1.AuthConfig.ApiKeyConfig getApiKeyConfig() {
      if (apiKeyConfigBuilder_ == null) {
        if (authConfigCase_ == 2) {
          return (com.google.cloud.aiplatform.v1beta1.AuthConfig.ApiKeyConfig) authConfig_;
        }
        return com.google.cloud.aiplatform.v1beta1.AuthConfig.ApiKeyConfig.getDefaultInstance();
      } else {
        if (authConfigCase_ == 2) {
          return apiKeyConfigBuilder_.getMessage();
        }
        return com.google.cloud.aiplatform.v1beta1.AuthConfig.ApiKeyConfig.getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * Config for API key auth.
     * </pre>
     *
     * <code>.google.cloud.aiplatform.v1beta1.AuthConfig.ApiKeyConfig api_key_config = 2;</code>
     */
    public Builder setApiKeyConfig(
        com.google.cloud.aiplatform.v1beta1.AuthConfig.ApiKeyConfig value) {
      if (apiKeyConfigBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        authConfig_ = value;
        onChanged();
      } else {
        apiKeyConfigBuilder_.setMessage(value);
      }
      authConfigCase_ = 2;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Config for API key auth.
     * </pre>
     *
     * <code>.google.cloud.aiplatform.v1beta1.AuthConfig.ApiKeyConfig api_key_config = 2;</code>
     */
    public Builder setApiKeyConfig(
        com.google.cloud.aiplatform.v1beta1.AuthConfig.ApiKeyConfig.Builder builderForValue) {
      if (apiKeyConfigBuilder_ == null) {
        authConfig_ = builderForValue.build();
        onChanged();
      } else {
        apiKeyConfigBuilder_.setMessage(builderForValue.build());
      }
      authConfigCase_ = 2;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Config for API key auth.
     * </pre>
     *
     * <code>.google.cloud.aiplatform.v1beta1.AuthConfig.ApiKeyConfig api_key_config = 2;</code>
     */
    public Builder mergeApiKeyConfig(
        com.google.cloud.aiplatform.v1beta1.AuthConfig.ApiKeyConfig value) {
      if (apiKeyConfigBuilder_ == null) {
        if (authConfigCase_ == 2
            && authConfig_
                != com.google.cloud.aiplatform.v1beta1.AuthConfig.ApiKeyConfig
                    .getDefaultInstance()) {
          authConfig_ =
              com.google.cloud.aiplatform.v1beta1.AuthConfig.ApiKeyConfig.newBuilder(
                      (com.google.cloud.aiplatform.v1beta1.AuthConfig.ApiKeyConfig) authConfig_)
                  .mergeFrom(value)
                  .buildPartial();
        } else {
          authConfig_ = value;
        }
        onChanged();
      } else {
        if (authConfigCase_ == 2) {
          apiKeyConfigBuilder_.mergeFrom(value);
        } else {
          apiKeyConfigBuilder_.setMessage(value);
        }
      }
      authConfigCase_ = 2;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Config for API key auth.
     * </pre>
     *
     * <code>.google.cloud.aiplatform.v1beta1.AuthConfig.ApiKeyConfig api_key_config = 2;</code>
     */
    public Builder clearApiKeyConfig() {
      if (apiKeyConfigBuilder_ == null) {
        if (authConfigCase_ == 2) {
          authConfigCase_ = 0;
          authConfig_ = null;
          onChanged();
        }
      } else {
        if (authConfigCase_ == 2) {
          authConfigCase_ = 0;
          authConfig_ = null;
        }
        apiKeyConfigBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Config for API key auth.
     * </pre>
     *
     * <code>.google.cloud.aiplatform.v1beta1.AuthConfig.ApiKeyConfig api_key_config = 2;</code>
     */
    public com.google.cloud.aiplatform.v1beta1.AuthConfig.ApiKeyConfig.Builder
        getApiKeyConfigBuilder() {
      return getApiKeyConfigFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Config for API key auth.
     * </pre>
     *
     * <code>.google.cloud.aiplatform.v1beta1.AuthConfig.ApiKeyConfig api_key_config = 2;</code>
     */
    @java.lang.Override
    public com.google.cloud.aiplatform.v1beta1.AuthConfig.ApiKeyConfigOrBuilder
        getApiKeyConfigOrBuilder() {
      if ((authConfigCase_ == 2) && (apiKeyConfigBuilder_ != null)) {
        return apiKeyConfigBuilder_.getMessageOrBuilder();
      } else {
        if (authConfigCase_ == 2) {
          return (com.google.cloud.aiplatform.v1beta1.AuthConfig.ApiKeyConfig) authConfig_;
        }
        return com.google.cloud.aiplatform.v1beta1.AuthConfig.ApiKeyConfig.getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * Config for API key auth.
     * </pre>
     *
     * <code>.google.cloud.aiplatform.v1beta1.AuthConfig.ApiKeyConfig api_key_config = 2;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.aiplatform.v1beta1.AuthConfig.ApiKeyConfig,
            com.google.cloud.aiplatform.v1beta1.AuthConfig.ApiKeyConfig.Builder,
            com.google.cloud.aiplatform.v1beta1.AuthConfig.ApiKeyConfigOrBuilder>
        getApiKeyConfigFieldBuilder() {
      if (apiKeyConfigBuilder_ == null) {
        if (!(authConfigCase_ == 2)) {
          authConfig_ =
              com.google.cloud.aiplatform.v1beta1.AuthConfig.ApiKeyConfig.getDefaultInstance();
        }
        apiKeyConfigBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.aiplatform.v1beta1.AuthConfig.ApiKeyConfig,
                com.google.cloud.aiplatform.v1beta1.AuthConfig.ApiKeyConfig.Builder,
                com.google.cloud.aiplatform.v1beta1.AuthConfig.ApiKeyConfigOrBuilder>(
                (com.google.cloud.aiplatform.v1beta1.AuthConfig.ApiKeyConfig) authConfig_,
                getParentForChildren(),
                isClean());
        authConfig_ = null;
      }
      authConfigCase_ = 2;
      onChanged();
      return apiKeyConfigBuilder_;
    }

    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.aiplatform.v1beta1.AuthConfig.HttpBasicAuthConfig,
            com.google.cloud.aiplatform.v1beta1.AuthConfig.HttpBasicAuthConfig.Builder,
            com.google.cloud.aiplatform.v1beta1.AuthConfig.HttpBasicAuthConfigOrBuilder>
        httpBasicAuthConfigBuilder_;
    /**
     *
     *
     * <pre>
     * Config for HTTP Basic auth.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.AuthConfig.HttpBasicAuthConfig http_basic_auth_config = 3;
     * </code>
     *
     * @return Whether the httpBasicAuthConfig field is set.
     */
    @java.lang.Override
    public boolean hasHttpBasicAuthConfig() {
      return authConfigCase_ == 3;
    }
    /**
     *
     *
     * <pre>
     * Config for HTTP Basic auth.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.AuthConfig.HttpBasicAuthConfig http_basic_auth_config = 3;
     * </code>
     *
     * @return The httpBasicAuthConfig.
     */
    @java.lang.Override
    public com.google.cloud.aiplatform.v1beta1.AuthConfig.HttpBasicAuthConfig
        getHttpBasicAuthConfig() {
      if (httpBasicAuthConfigBuilder_ == null) {
        if (authConfigCase_ == 3) {
          return (com.google.cloud.aiplatform.v1beta1.AuthConfig.HttpBasicAuthConfig) authConfig_;
        }
        return com.google.cloud.aiplatform.v1beta1.AuthConfig.HttpBasicAuthConfig
            .getDefaultInstance();
      } else {
        if (authConfigCase_ == 3) {
          return httpBasicAuthConfigBuilder_.getMessage();
        }
        return com.google.cloud.aiplatform.v1beta1.AuthConfig.HttpBasicAuthConfig
            .getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * Config for HTTP Basic auth.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.AuthConfig.HttpBasicAuthConfig http_basic_auth_config = 3;
     * </code>
     */
    public Builder setHttpBasicAuthConfig(
        com.google.cloud.aiplatform.v1beta1.AuthConfig.HttpBasicAuthConfig value) {
      if (httpBasicAuthConfigBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        authConfig_ = value;
        onChanged();
      } else {
        httpBasicAuthConfigBuilder_.setMessage(value);
      }
      authConfigCase_ = 3;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Config for HTTP Basic auth.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.AuthConfig.HttpBasicAuthConfig http_basic_auth_config = 3;
     * </code>
     */
    public Builder setHttpBasicAuthConfig(
        com.google.cloud.aiplatform.v1beta1.AuthConfig.HttpBasicAuthConfig.Builder
            builderForValue) {
      if (httpBasicAuthConfigBuilder_ == null) {
        authConfig_ = builderForValue.build();
        onChanged();
      } else {
        httpBasicAuthConfigBuilder_.setMessage(builderForValue.build());
      }
      authConfigCase_ = 3;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Config for HTTP Basic auth.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.AuthConfig.HttpBasicAuthConfig http_basic_auth_config = 3;
     * </code>
     */
    public Builder mergeHttpBasicAuthConfig(
        com.google.cloud.aiplatform.v1beta1.AuthConfig.HttpBasicAuthConfig value) {
      if (httpBasicAuthConfigBuilder_ == null) {
        if (authConfigCase_ == 3
            && authConfig_
                != com.google.cloud.aiplatform.v1beta1.AuthConfig.HttpBasicAuthConfig
                    .getDefaultInstance()) {
          authConfig_ =
              com.google.cloud.aiplatform.v1beta1.AuthConfig.HttpBasicAuthConfig.newBuilder(
                      (com.google.cloud.aiplatform.v1beta1.AuthConfig.HttpBasicAuthConfig)
                          authConfig_)
                  .mergeFrom(value)
                  .buildPartial();
        } else {
          authConfig_ = value;
        }
        onChanged();
      } else {
        if (authConfigCase_ == 3) {
          httpBasicAuthConfigBuilder_.mergeFrom(value);
        } else {
          httpBasicAuthConfigBuilder_.setMessage(value);
        }
      }
      authConfigCase_ = 3;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Config for HTTP Basic auth.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.AuthConfig.HttpBasicAuthConfig http_basic_auth_config = 3;
     * </code>
     */
    public Builder clearHttpBasicAuthConfig() {
      if (httpBasicAuthConfigBuilder_ == null) {
        if (authConfigCase_ == 3) {
          authConfigCase_ = 0;
          authConfig_ = null;
          onChanged();
        }
      } else {
        if (authConfigCase_ == 3) {
          authConfigCase_ = 0;
          authConfig_ = null;
        }
        httpBasicAuthConfigBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Config for HTTP Basic auth.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.AuthConfig.HttpBasicAuthConfig http_basic_auth_config = 3;
     * </code>
     */
    public com.google.cloud.aiplatform.v1beta1.AuthConfig.HttpBasicAuthConfig.Builder
        getHttpBasicAuthConfigBuilder() {
      return getHttpBasicAuthConfigFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Config for HTTP Basic auth.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.AuthConfig.HttpBasicAuthConfig http_basic_auth_config = 3;
     * </code>
     */
    @java.lang.Override
    public com.google.cloud.aiplatform.v1beta1.AuthConfig.HttpBasicAuthConfigOrBuilder
        getHttpBasicAuthConfigOrBuilder() {
      if ((authConfigCase_ == 3) && (httpBasicAuthConfigBuilder_ != null)) {
        return httpBasicAuthConfigBuilder_.getMessageOrBuilder();
      } else {
        if (authConfigCase_ == 3) {
          return (com.google.cloud.aiplatform.v1beta1.AuthConfig.HttpBasicAuthConfig) authConfig_;
        }
        return com.google.cloud.aiplatform.v1beta1.AuthConfig.HttpBasicAuthConfig
            .getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * Config for HTTP Basic auth.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.AuthConfig.HttpBasicAuthConfig http_basic_auth_config = 3;
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.aiplatform.v1beta1.AuthConfig.HttpBasicAuthConfig,
            com.google.cloud.aiplatform.v1beta1.AuthConfig.HttpBasicAuthConfig.Builder,
            com.google.cloud.aiplatform.v1beta1.AuthConfig.HttpBasicAuthConfigOrBuilder>
        getHttpBasicAuthConfigFieldBuilder() {
      if (httpBasicAuthConfigBuilder_ == null) {
        if (!(authConfigCase_ == 3)) {
          authConfig_ =
              com.google.cloud.aiplatform.v1beta1.AuthConfig.HttpBasicAuthConfig
                  .getDefaultInstance();
        }
        httpBasicAuthConfigBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.aiplatform.v1beta1.AuthConfig.HttpBasicAuthConfig,
                com.google.cloud.aiplatform.v1beta1.AuthConfig.HttpBasicAuthConfig.Builder,
                com.google.cloud.aiplatform.v1beta1.AuthConfig.HttpBasicAuthConfigOrBuilder>(
                (com.google.cloud.aiplatform.v1beta1.AuthConfig.HttpBasicAuthConfig) authConfig_,
                getParentForChildren(),
                isClean());
        authConfig_ = null;
      }
      authConfigCase_ = 3;
      onChanged();
      return httpBasicAuthConfigBuilder_;
    }

    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.aiplatform.v1beta1.AuthConfig.GoogleServiceAccountConfig,
            com.google.cloud.aiplatform.v1beta1.AuthConfig.GoogleServiceAccountConfig.Builder,
            com.google.cloud.aiplatform.v1beta1.AuthConfig.GoogleServiceAccountConfigOrBuilder>
        googleServiceAccountConfigBuilder_;
    /**
     *
     *
     * <pre>
     * Config for Google Service Account auth.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.AuthConfig.GoogleServiceAccountConfig google_service_account_config = 4;
     * </code>
     *
     * @return Whether the googleServiceAccountConfig field is set.
     */
    @java.lang.Override
    public boolean hasGoogleServiceAccountConfig() {
      return authConfigCase_ == 4;
    }
    /**
     *
     *
     * <pre>
     * Config for Google Service Account auth.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.AuthConfig.GoogleServiceAccountConfig google_service_account_config = 4;
     * </code>
     *
     * @return The googleServiceAccountConfig.
     */
    @java.lang.Override
    public com.google.cloud.aiplatform.v1beta1.AuthConfig.GoogleServiceAccountConfig
        getGoogleServiceAccountConfig() {
      if (googleServiceAccountConfigBuilder_ == null) {
        if (authConfigCase_ == 4) {
          return (com.google.cloud.aiplatform.v1beta1.AuthConfig.GoogleServiceAccountConfig)
              authConfig_;
        }
        return com.google.cloud.aiplatform.v1beta1.AuthConfig.GoogleServiceAccountConfig
            .getDefaultInstance();
      } else {
        if (authConfigCase_ == 4) {
          return googleServiceAccountConfigBuilder_.getMessage();
        }
        return com.google.cloud.aiplatform.v1beta1.AuthConfig.GoogleServiceAccountConfig
            .getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * Config for Google Service Account auth.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.AuthConfig.GoogleServiceAccountConfig google_service_account_config = 4;
     * </code>
     */
    public Builder setGoogleServiceAccountConfig(
        com.google.cloud.aiplatform.v1beta1.AuthConfig.GoogleServiceAccountConfig value) {
      if (googleServiceAccountConfigBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        authConfig_ = value;
        onChanged();
      } else {
        googleServiceAccountConfigBuilder_.setMessage(value);
      }
      authConfigCase_ = 4;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Config for Google Service Account auth.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.AuthConfig.GoogleServiceAccountConfig google_service_account_config = 4;
     * </code>
     */
    public Builder setGoogleServiceAccountConfig(
        com.google.cloud.aiplatform.v1beta1.AuthConfig.GoogleServiceAccountConfig.Builder
            builderForValue) {
      if (googleServiceAccountConfigBuilder_ == null) {
        authConfig_ = builderForValue.build();
        onChanged();
      } else {
        googleServiceAccountConfigBuilder_.setMessage(builderForValue.build());
      }
      authConfigCase_ = 4;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Config for Google Service Account auth.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.AuthConfig.GoogleServiceAccountConfig google_service_account_config = 4;
     * </code>
     */
    public Builder mergeGoogleServiceAccountConfig(
        com.google.cloud.aiplatform.v1beta1.AuthConfig.GoogleServiceAccountConfig value) {
      if (googleServiceAccountConfigBuilder_ == null) {
        if (authConfigCase_ == 4
            && authConfig_
                != com.google.cloud.aiplatform.v1beta1.AuthConfig.GoogleServiceAccountConfig
                    .getDefaultInstance()) {
          authConfig_ =
              com.google.cloud.aiplatform.v1beta1.AuthConfig.GoogleServiceAccountConfig.newBuilder(
                      (com.google.cloud.aiplatform.v1beta1.AuthConfig.GoogleServiceAccountConfig)
                          authConfig_)
                  .mergeFrom(value)
                  .buildPartial();
        } else {
          authConfig_ = value;
        }
        onChanged();
      } else {
        if (authConfigCase_ == 4) {
          googleServiceAccountConfigBuilder_.mergeFrom(value);
        } else {
          googleServiceAccountConfigBuilder_.setMessage(value);
        }
      }
      authConfigCase_ = 4;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Config for Google Service Account auth.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.AuthConfig.GoogleServiceAccountConfig google_service_account_config = 4;
     * </code>
     */
    public Builder clearGoogleServiceAccountConfig() {
      if (googleServiceAccountConfigBuilder_ == null) {
        if (authConfigCase_ == 4) {
          authConfigCase_ = 0;
          authConfig_ = null;
          onChanged();
        }
      } else {
        if (authConfigCase_ == 4) {
          authConfigCase_ = 0;
          authConfig_ = null;
        }
        googleServiceAccountConfigBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Config for Google Service Account auth.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.AuthConfig.GoogleServiceAccountConfig google_service_account_config = 4;
     * </code>
     */
    public com.google.cloud.aiplatform.v1beta1.AuthConfig.GoogleServiceAccountConfig.Builder
        getGoogleServiceAccountConfigBuilder() {
      return getGoogleServiceAccountConfigFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Config for Google Service Account auth.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.AuthConfig.GoogleServiceAccountConfig google_service_account_config = 4;
     * </code>
     */
    @java.lang.Override
    public com.google.cloud.aiplatform.v1beta1.AuthConfig.GoogleServiceAccountConfigOrBuilder
        getGoogleServiceAccountConfigOrBuilder() {
      if ((authConfigCase_ == 4) && (googleServiceAccountConfigBuilder_ != null)) {
        return googleServiceAccountConfigBuilder_.getMessageOrBuilder();
      } else {
        if (authConfigCase_ == 4) {
          return (com.google.cloud.aiplatform.v1beta1.AuthConfig.GoogleServiceAccountConfig)
              authConfig_;
        }
        return com.google.cloud.aiplatform.v1beta1.AuthConfig.GoogleServiceAccountConfig
            .getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * Config for Google Service Account auth.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.AuthConfig.GoogleServiceAccountConfig google_service_account_config = 4;
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.aiplatform.v1beta1.AuthConfig.GoogleServiceAccountConfig,
            com.google.cloud.aiplatform.v1beta1.AuthConfig.GoogleServiceAccountConfig.Builder,
            com.google.cloud.aiplatform.v1beta1.AuthConfig.GoogleServiceAccountConfigOrBuilder>
        getGoogleServiceAccountConfigFieldBuilder() {
      if (googleServiceAccountConfigBuilder_ == null) {
        if (!(authConfigCase_ == 4)) {
          authConfig_ =
              com.google.cloud.aiplatform.v1beta1.AuthConfig.GoogleServiceAccountConfig
                  .getDefaultInstance();
        }
        googleServiceAccountConfigBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.aiplatform.v1beta1.AuthConfig.GoogleServiceAccountConfig,
                com.google.cloud.aiplatform.v1beta1.AuthConfig.GoogleServiceAccountConfig.Builder,
                com.google.cloud.aiplatform.v1beta1.AuthConfig.GoogleServiceAccountConfigOrBuilder>(
                (com.google.cloud.aiplatform.v1beta1.AuthConfig.GoogleServiceAccountConfig)
                    authConfig_,
                getParentForChildren(),
                isClean());
        authConfig_ = null;
      }
      authConfigCase_ = 4;
      onChanged();
      return googleServiceAccountConfigBuilder_;
    }

    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.aiplatform.v1beta1.AuthConfig.OauthConfig,
            com.google.cloud.aiplatform.v1beta1.AuthConfig.OauthConfig.Builder,
            com.google.cloud.aiplatform.v1beta1.AuthConfig.OauthConfigOrBuilder>
        oauthConfigBuilder_;
    /**
     *
     *
     * <pre>
     * Config for user oauth.
     * </pre>
     *
     * <code>.google.cloud.aiplatform.v1beta1.AuthConfig.OauthConfig oauth_config = 5;</code>
     *
     * @return Whether the oauthConfig field is set.
     */
    @java.lang.Override
    public boolean hasOauthConfig() {
      return authConfigCase_ == 5;
    }
    /**
     *
     *
     * <pre>
     * Config for user oauth.
     * </pre>
     *
     * <code>.google.cloud.aiplatform.v1beta1.AuthConfig.OauthConfig oauth_config = 5;</code>
     *
     * @return The oauthConfig.
     */
    @java.lang.Override
    public com.google.cloud.aiplatform.v1beta1.AuthConfig.OauthConfig getOauthConfig() {
      if (oauthConfigBuilder_ == null) {
        if (authConfigCase_ == 5) {
          return (com.google.cloud.aiplatform.v1beta1.AuthConfig.OauthConfig) authConfig_;
        }
        return com.google.cloud.aiplatform.v1beta1.AuthConfig.OauthConfig.getDefaultInstance();
      } else {
        if (authConfigCase_ == 5) {
          return oauthConfigBuilder_.getMessage();
        }
        return com.google.cloud.aiplatform.v1beta1.AuthConfig.OauthConfig.getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * Config for user oauth.
     * </pre>
     *
     * <code>.google.cloud.aiplatform.v1beta1.AuthConfig.OauthConfig oauth_config = 5;</code>
     */
    public Builder setOauthConfig(
        com.google.cloud.aiplatform.v1beta1.AuthConfig.OauthConfig value) {
      if (oauthConfigBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        authConfig_ = value;
        onChanged();
      } else {
        oauthConfigBuilder_.setMessage(value);
      }
      authConfigCase_ = 5;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Config for user oauth.
     * </pre>
     *
     * <code>.google.cloud.aiplatform.v1beta1.AuthConfig.OauthConfig oauth_config = 5;</code>
     */
    public Builder setOauthConfig(
        com.google.cloud.aiplatform.v1beta1.AuthConfig.OauthConfig.Builder builderForValue) {
      if (oauthConfigBuilder_ == null) {
        authConfig_ = builderForValue.build();
        onChanged();
      } else {
        oauthConfigBuilder_.setMessage(builderForValue.build());
      }
      authConfigCase_ = 5;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Config for user oauth.
     * </pre>
     *
     * <code>.google.cloud.aiplatform.v1beta1.AuthConfig.OauthConfig oauth_config = 5;</code>
     */
    public Builder mergeOauthConfig(
        com.google.cloud.aiplatform.v1beta1.AuthConfig.OauthConfig value) {
      if (oauthConfigBuilder_ == null) {
        if (authConfigCase_ == 5
            && authConfig_
                != com.google.cloud.aiplatform.v1beta1.AuthConfig.OauthConfig
                    .getDefaultInstance()) {
          authConfig_ =
              com.google.cloud.aiplatform.v1beta1.AuthConfig.OauthConfig.newBuilder(
                      (com.google.cloud.aiplatform.v1beta1.AuthConfig.OauthConfig) authConfig_)
                  .mergeFrom(value)
                  .buildPartial();
        } else {
          authConfig_ = value;
        }
        onChanged();
      } else {
        if (authConfigCase_ == 5) {
          oauthConfigBuilder_.mergeFrom(value);
        } else {
          oauthConfigBuilder_.setMessage(value);
        }
      }
      authConfigCase_ = 5;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Config for user oauth.
     * </pre>
     *
     * <code>.google.cloud.aiplatform.v1beta1.AuthConfig.OauthConfig oauth_config = 5;</code>
     */
    public Builder clearOauthConfig() {
      if (oauthConfigBuilder_ == null) {
        if (authConfigCase_ == 5) {
          authConfigCase_ = 0;
          authConfig_ = null;
          onChanged();
        }
      } else {
        if (authConfigCase_ == 5) {
          authConfigCase_ = 0;
          authConfig_ = null;
        }
        oauthConfigBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Config for user oauth.
     * </pre>
     *
     * <code>.google.cloud.aiplatform.v1beta1.AuthConfig.OauthConfig oauth_config = 5;</code>
     */
    public com.google.cloud.aiplatform.v1beta1.AuthConfig.OauthConfig.Builder
        getOauthConfigBuilder() {
      return getOauthConfigFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Config for user oauth.
     * </pre>
     *
     * <code>.google.cloud.aiplatform.v1beta1.AuthConfig.OauthConfig oauth_config = 5;</code>
     */
    @java.lang.Override
    public com.google.cloud.aiplatform.v1beta1.AuthConfig.OauthConfigOrBuilder
        getOauthConfigOrBuilder() {
      if ((authConfigCase_ == 5) && (oauthConfigBuilder_ != null)) {
        return oauthConfigBuilder_.getMessageOrBuilder();
      } else {
        if (authConfigCase_ == 5) {
          return (com.google.cloud.aiplatform.v1beta1.AuthConfig.OauthConfig) authConfig_;
        }
        return com.google.cloud.aiplatform.v1beta1.AuthConfig.OauthConfig.getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * Config for user oauth.
     * </pre>
     *
     * <code>.google.cloud.aiplatform.v1beta1.AuthConfig.OauthConfig oauth_config = 5;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.aiplatform.v1beta1.AuthConfig.OauthConfig,
            com.google.cloud.aiplatform.v1beta1.AuthConfig.OauthConfig.Builder,
            com.google.cloud.aiplatform.v1beta1.AuthConfig.OauthConfigOrBuilder>
        getOauthConfigFieldBuilder() {
      if (oauthConfigBuilder_ == null) {
        if (!(authConfigCase_ == 5)) {
          authConfig_ =
              com.google.cloud.aiplatform.v1beta1.AuthConfig.OauthConfig.getDefaultInstance();
        }
        oauthConfigBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.aiplatform.v1beta1.AuthConfig.OauthConfig,
                com.google.cloud.aiplatform.v1beta1.AuthConfig.OauthConfig.Builder,
                com.google.cloud.aiplatform.v1beta1.AuthConfig.OauthConfigOrBuilder>(
                (com.google.cloud.aiplatform.v1beta1.AuthConfig.OauthConfig) authConfig_,
                getParentForChildren(),
                isClean());
        authConfig_ = null;
      }
      authConfigCase_ = 5;
      onChanged();
      return oauthConfigBuilder_;
    }

    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.aiplatform.v1beta1.AuthConfig.OidcConfig,
            com.google.cloud.aiplatform.v1beta1.AuthConfig.OidcConfig.Builder,
            com.google.cloud.aiplatform.v1beta1.AuthConfig.OidcConfigOrBuilder>
        oidcConfigBuilder_;
    /**
     *
     *
     * <pre>
     * Config for user OIDC auth.
     * </pre>
     *
     * <code>.google.cloud.aiplatform.v1beta1.AuthConfig.OidcConfig oidc_config = 7;</code>
     *
     * @return Whether the oidcConfig field is set.
     */
    @java.lang.Override
    public boolean hasOidcConfig() {
      return authConfigCase_ == 7;
    }
    /**
     *
     *
     * <pre>
     * Config for user OIDC auth.
     * </pre>
     *
     * <code>.google.cloud.aiplatform.v1beta1.AuthConfig.OidcConfig oidc_config = 7;</code>
     *
     * @return The oidcConfig.
     */
    @java.lang.Override
    public com.google.cloud.aiplatform.v1beta1.AuthConfig.OidcConfig getOidcConfig() {
      if (oidcConfigBuilder_ == null) {
        if (authConfigCase_ == 7) {
          return (com.google.cloud.aiplatform.v1beta1.AuthConfig.OidcConfig) authConfig_;
        }
        return com.google.cloud.aiplatform.v1beta1.AuthConfig.OidcConfig.getDefaultInstance();
      } else {
        if (authConfigCase_ == 7) {
          return oidcConfigBuilder_.getMessage();
        }
        return com.google.cloud.aiplatform.v1beta1.AuthConfig.OidcConfig.getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * Config for user OIDC auth.
     * </pre>
     *
     * <code>.google.cloud.aiplatform.v1beta1.AuthConfig.OidcConfig oidc_config = 7;</code>
     */
    public Builder setOidcConfig(com.google.cloud.aiplatform.v1beta1.AuthConfig.OidcConfig value) {
      if (oidcConfigBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        authConfig_ = value;
        onChanged();
      } else {
        oidcConfigBuilder_.setMessage(value);
      }
      authConfigCase_ = 7;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Config for user OIDC auth.
     * </pre>
     *
     * <code>.google.cloud.aiplatform.v1beta1.AuthConfig.OidcConfig oidc_config = 7;</code>
     */
    public Builder setOidcConfig(
        com.google.cloud.aiplatform.v1beta1.AuthConfig.OidcConfig.Builder builderForValue) {
      if (oidcConfigBuilder_ == null) {
        authConfig_ = builderForValue.build();
        onChanged();
      } else {
        oidcConfigBuilder_.setMessage(builderForValue.build());
      }
      authConfigCase_ = 7;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Config for user OIDC auth.
     * </pre>
     *
     * <code>.google.cloud.aiplatform.v1beta1.AuthConfig.OidcConfig oidc_config = 7;</code>
     */
    public Builder mergeOidcConfig(
        com.google.cloud.aiplatform.v1beta1.AuthConfig.OidcConfig value) {
      if (oidcConfigBuilder_ == null) {
        if (authConfigCase_ == 7
            && authConfig_
                != com.google.cloud.aiplatform.v1beta1.AuthConfig.OidcConfig.getDefaultInstance()) {
          authConfig_ =
              com.google.cloud.aiplatform.v1beta1.AuthConfig.OidcConfig.newBuilder(
                      (com.google.cloud.aiplatform.v1beta1.AuthConfig.OidcConfig) authConfig_)
                  .mergeFrom(value)
                  .buildPartial();
        } else {
          authConfig_ = value;
        }
        onChanged();
      } else {
        if (authConfigCase_ == 7) {
          oidcConfigBuilder_.mergeFrom(value);
        } else {
          oidcConfigBuilder_.setMessage(value);
        }
      }
      authConfigCase_ = 7;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Config for user OIDC auth.
     * </pre>
     *
     * <code>.google.cloud.aiplatform.v1beta1.AuthConfig.OidcConfig oidc_config = 7;</code>
     */
    public Builder clearOidcConfig() {
      if (oidcConfigBuilder_ == null) {
        if (authConfigCase_ == 7) {
          authConfigCase_ = 0;
          authConfig_ = null;
          onChanged();
        }
      } else {
        if (authConfigCase_ == 7) {
          authConfigCase_ = 0;
          authConfig_ = null;
        }
        oidcConfigBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Config for user OIDC auth.
     * </pre>
     *
     * <code>.google.cloud.aiplatform.v1beta1.AuthConfig.OidcConfig oidc_config = 7;</code>
     */
    public com.google.cloud.aiplatform.v1beta1.AuthConfig.OidcConfig.Builder
        getOidcConfigBuilder() {
      return getOidcConfigFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Config for user OIDC auth.
     * </pre>
     *
     * <code>.google.cloud.aiplatform.v1beta1.AuthConfig.OidcConfig oidc_config = 7;</code>
     */
    @java.lang.Override
    public com.google.cloud.aiplatform.v1beta1.AuthConfig.OidcConfigOrBuilder
        getOidcConfigOrBuilder() {
      if ((authConfigCase_ == 7) && (oidcConfigBuilder_ != null)) {
        return oidcConfigBuilder_.getMessageOrBuilder();
      } else {
        if (authConfigCase_ == 7) {
          return (com.google.cloud.aiplatform.v1beta1.AuthConfig.OidcConfig) authConfig_;
        }
        return com.google.cloud.aiplatform.v1beta1.AuthConfig.OidcConfig.getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * Config for user OIDC auth.
     * </pre>
     *
     * <code>.google.cloud.aiplatform.v1beta1.AuthConfig.OidcConfig oidc_config = 7;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.aiplatform.v1beta1.AuthConfig.OidcConfig,
            com.google.cloud.aiplatform.v1beta1.AuthConfig.OidcConfig.Builder,
            com.google.cloud.aiplatform.v1beta1.AuthConfig.OidcConfigOrBuilder>
        getOidcConfigFieldBuilder() {
      if (oidcConfigBuilder_ == null) {
        if (!(authConfigCase_ == 7)) {
          authConfig_ =
              com.google.cloud.aiplatform.v1beta1.AuthConfig.OidcConfig.getDefaultInstance();
        }
        oidcConfigBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.aiplatform.v1beta1.AuthConfig.OidcConfig,
                com.google.cloud.aiplatform.v1beta1.AuthConfig.OidcConfig.Builder,
                com.google.cloud.aiplatform.v1beta1.AuthConfig.OidcConfigOrBuilder>(
                (com.google.cloud.aiplatform.v1beta1.AuthConfig.OidcConfig) authConfig_,
                getParentForChildren(),
                isClean());
        authConfig_ = null;
      }
      authConfigCase_ = 7;
      onChanged();
      return oidcConfigBuilder_;
    }

    private int authType_ = 0;
    /**
     *
     *
     * <pre>
     * Type of auth scheme.
     * </pre>
     *
     * <code>.google.cloud.aiplatform.v1beta1.AuthType auth_type = 101;</code>
     *
     * @return The enum numeric value on the wire for authType.
     */
    @java.lang.Override
    public int getAuthTypeValue() {
      return authType_;
    }
    /**
     *
     *
     * <pre>
     * Type of auth scheme.
     * </pre>
     *
     * <code>.google.cloud.aiplatform.v1beta1.AuthType auth_type = 101;</code>
     *
     * @param value The enum numeric value on the wire for authType to set.
     * @return This builder for chaining.
     */
    public Builder setAuthTypeValue(int value) {
      authType_ = value;
      bitField0_ |= 0x00000020;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Type of auth scheme.
     * </pre>
     *
     * <code>.google.cloud.aiplatform.v1beta1.AuthType auth_type = 101;</code>
     *
     * @return The authType.
     */
    @java.lang.Override
    public com.google.cloud.aiplatform.v1beta1.AuthType getAuthType() {
      com.google.cloud.aiplatform.v1beta1.AuthType result =
          com.google.cloud.aiplatform.v1beta1.AuthType.forNumber(authType_);
      return result == null ? com.google.cloud.aiplatform.v1beta1.AuthType.UNRECOGNIZED : result;
    }
    /**
     *
     *
     * <pre>
     * Type of auth scheme.
     * </pre>
     *
     * <code>.google.cloud.aiplatform.v1beta1.AuthType auth_type = 101;</code>
     *
     * @param value The authType to set.
     * @return This builder for chaining.
     */
    public Builder setAuthType(com.google.cloud.aiplatform.v1beta1.AuthType value) {
      if (value == null) {
        throw new NullPointerException();
      }
      bitField0_ |= 0x00000020;
      authType_ = value.getNumber();
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Type of auth scheme.
     * </pre>
     *
     * <code>.google.cloud.aiplatform.v1beta1.AuthType auth_type = 101;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearAuthType() {
      bitField0_ = (bitField0_ & ~0x00000020);
      authType_ = 0;
      onChanged();
      return this;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.cloud.aiplatform.v1beta1.AuthConfig)
  }

  // @@protoc_insertion_point(class_scope:google.cloud.aiplatform.v1beta1.AuthConfig)
  private static final com.google.cloud.aiplatform.v1beta1.AuthConfig DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.cloud.aiplatform.v1beta1.AuthConfig();
  }

  public static com.google.cloud.aiplatform.v1beta1.AuthConfig getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<AuthConfig> PARSER =
      new com.google.protobuf.AbstractParser<AuthConfig>() {
        @java.lang.Override
        public AuthConfig parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          Builder builder = newBuilder();
          try {
            builder.mergeFrom(input, extensionRegistry);
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.setUnfinishedMessage(builder.buildPartial());
          } catch (com.google.protobuf.UninitializedMessageException e) {
            throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
          } catch (java.io.IOException e) {
            throw new com.google.protobuf.InvalidProtocolBufferException(e)
                .setUnfinishedMessage(builder.buildPartial());
          }
          return builder.buildPartial();
        }
      };

  public static com.google.protobuf.Parser<AuthConfig> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<AuthConfig> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.cloud.aiplatform.v1beta1.AuthConfig getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
