/*
 * Copyright 2024 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/cloud/aiplatform/v1beta1/feature_monitor.proto

// Protobuf Java Version: 3.25.5
package com.google.cloud.aiplatform.v1beta1;

/**
 *
 *
 * <pre>
 * Feature selection configuration for the FeatureMonitor.
 * </pre>
 *
 * Protobuf type {@code google.cloud.aiplatform.v1beta1.FeatureSelectionConfig}
 */
public final class FeatureSelectionConfig extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.cloud.aiplatform.v1beta1.FeatureSelectionConfig)
    FeatureSelectionConfigOrBuilder {
  private static final long serialVersionUID = 0L;
  // Use FeatureSelectionConfig.newBuilder() to construct.
  private FeatureSelectionConfig(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private FeatureSelectionConfig() {
    featureConfigs_ = java.util.Collections.emptyList();
  }

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new FeatureSelectionConfig();
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.cloud.aiplatform.v1beta1.FeatureMonitorProto
        .internal_static_google_cloud_aiplatform_v1beta1_FeatureSelectionConfig_descriptor;
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.cloud.aiplatform.v1beta1.FeatureMonitorProto
        .internal_static_google_cloud_aiplatform_v1beta1_FeatureSelectionConfig_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.cloud.aiplatform.v1beta1.FeatureSelectionConfig.class,
            com.google.cloud.aiplatform.v1beta1.FeatureSelectionConfig.Builder.class);
  }

  public interface FeatureConfigOrBuilder
      extends
      // @@protoc_insertion_point(interface_extends:google.cloud.aiplatform.v1beta1.FeatureSelectionConfig.FeatureConfig)
      com.google.protobuf.MessageOrBuilder {

    /**
     *
     *
     * <pre>
     * Required. The ID of the feature resource. Final component of the
     * Feature's resource name.
     * </pre>
     *
     * <code>string feature_id = 1 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return The featureId.
     */
    java.lang.String getFeatureId();
    /**
     *
     *
     * <pre>
     * Required. The ID of the feature resource. Final component of the
     * Feature's resource name.
     * </pre>
     *
     * <code>string feature_id = 1 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return The bytes for featureId.
     */
    com.google.protobuf.ByteString getFeatureIdBytes();

    /**
     *
     *
     * <pre>
     * Optional. Drift threshold. If calculated difference with baseline data
     * larger than threshold, it will be considered as the feature has drift. If
     * not present, the threshold will be default to 0.3.
     * </pre>
     *
     * <code>double drift_threshold = 2 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return The driftThreshold.
     */
    double getDriftThreshold();
  }
  /**
   *
   *
   * <pre>
   * Feature configuration.
   * </pre>
   *
   * Protobuf type {@code google.cloud.aiplatform.v1beta1.FeatureSelectionConfig.FeatureConfig}
   */
  public static final class FeatureConfig extends com.google.protobuf.GeneratedMessageV3
      implements
      // @@protoc_insertion_point(message_implements:google.cloud.aiplatform.v1beta1.FeatureSelectionConfig.FeatureConfig)
      FeatureConfigOrBuilder {
    private static final long serialVersionUID = 0L;
    // Use FeatureConfig.newBuilder() to construct.
    private FeatureConfig(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
      super(builder);
    }

    private FeatureConfig() {
      featureId_ = "";
    }

    @java.lang.Override
    @SuppressWarnings({"unused"})
    protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
      return new FeatureConfig();
    }

    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.aiplatform.v1beta1.FeatureMonitorProto
          .internal_static_google_cloud_aiplatform_v1beta1_FeatureSelectionConfig_FeatureConfig_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.aiplatform.v1beta1.FeatureMonitorProto
          .internal_static_google_cloud_aiplatform_v1beta1_FeatureSelectionConfig_FeatureConfig_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.aiplatform.v1beta1.FeatureSelectionConfig.FeatureConfig.class,
              com.google.cloud.aiplatform.v1beta1.FeatureSelectionConfig.FeatureConfig.Builder
                  .class);
    }

    public static final int FEATURE_ID_FIELD_NUMBER = 1;

    @SuppressWarnings("serial")
    private volatile java.lang.Object featureId_ = "";
    /**
     *
     *
     * <pre>
     * Required. The ID of the feature resource. Final component of the
     * Feature's resource name.
     * </pre>
     *
     * <code>string feature_id = 1 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return The featureId.
     */
    @java.lang.Override
    public java.lang.String getFeatureId() {
      java.lang.Object ref = featureId_;
      if (ref instanceof java.lang.String) {
        return (java.lang.String) ref;
      } else {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        featureId_ = s;
        return s;
      }
    }
    /**
     *
     *
     * <pre>
     * Required. The ID of the feature resource. Final component of the
     * Feature's resource name.
     * </pre>
     *
     * <code>string feature_id = 1 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return The bytes for featureId.
     */
    @java.lang.Override
    public com.google.protobuf.ByteString getFeatureIdBytes() {
      java.lang.Object ref = featureId_;
      if (ref instanceof java.lang.String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        featureId_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    public static final int DRIFT_THRESHOLD_FIELD_NUMBER = 2;
    private double driftThreshold_ = 0D;
    /**
     *
     *
     * <pre>
     * Optional. Drift threshold. If calculated difference with baseline data
     * larger than threshold, it will be considered as the feature has drift. If
     * not present, the threshold will be default to 0.3.
     * </pre>
     *
     * <code>double drift_threshold = 2 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return The driftThreshold.
     */
    @java.lang.Override
    public double getDriftThreshold() {
      return driftThreshold_;
    }

    private byte memoizedIsInitialized = -1;

    @java.lang.Override
    public final boolean isInitialized() {
      byte isInitialized = memoizedIsInitialized;
      if (isInitialized == 1) return true;
      if (isInitialized == 0) return false;

      memoizedIsInitialized = 1;
      return true;
    }

    @java.lang.Override
    public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(featureId_)) {
        com.google.protobuf.GeneratedMessageV3.writeString(output, 1, featureId_);
      }
      if (java.lang.Double.doubleToRawLongBits(driftThreshold_) != 0) {
        output.writeDouble(2, driftThreshold_);
      }
      getUnknownFields().writeTo(output);
    }

    @java.lang.Override
    public int getSerializedSize() {
      int size = memoizedSize;
      if (size != -1) return size;

      size = 0;
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(featureId_)) {
        size += com.google.protobuf.GeneratedMessageV3.computeStringSize(1, featureId_);
      }
      if (java.lang.Double.doubleToRawLongBits(driftThreshold_) != 0) {
        size += com.google.protobuf.CodedOutputStream.computeDoubleSize(2, driftThreshold_);
      }
      size += getUnknownFields().getSerializedSize();
      memoizedSize = size;
      return size;
    }

    @java.lang.Override
    public boolean equals(final java.lang.Object obj) {
      if (obj == this) {
        return true;
      }
      if (!(obj
          instanceof com.google.cloud.aiplatform.v1beta1.FeatureSelectionConfig.FeatureConfig)) {
        return super.equals(obj);
      }
      com.google.cloud.aiplatform.v1beta1.FeatureSelectionConfig.FeatureConfig other =
          (com.google.cloud.aiplatform.v1beta1.FeatureSelectionConfig.FeatureConfig) obj;

      if (!getFeatureId().equals(other.getFeatureId())) return false;
      if (java.lang.Double.doubleToLongBits(getDriftThreshold())
          != java.lang.Double.doubleToLongBits(other.getDriftThreshold())) return false;
      if (!getUnknownFields().equals(other.getUnknownFields())) return false;
      return true;
    }

    @java.lang.Override
    public int hashCode() {
      if (memoizedHashCode != 0) {
        return memoizedHashCode;
      }
      int hash = 41;
      hash = (19 * hash) + getDescriptor().hashCode();
      hash = (37 * hash) + FEATURE_ID_FIELD_NUMBER;
      hash = (53 * hash) + getFeatureId().hashCode();
      hash = (37 * hash) + DRIFT_THRESHOLD_FIELD_NUMBER;
      hash =
          (53 * hash)
              + com.google.protobuf.Internal.hashLong(
                  java.lang.Double.doubleToLongBits(getDriftThreshold()));
      hash = (29 * hash) + getUnknownFields().hashCode();
      memoizedHashCode = hash;
      return hash;
    }

    public static com.google.cloud.aiplatform.v1beta1.FeatureSelectionConfig.FeatureConfig
        parseFrom(java.nio.ByteBuffer data)
            throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.aiplatform.v1beta1.FeatureSelectionConfig.FeatureConfig
        parseFrom(
            java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.aiplatform.v1beta1.FeatureSelectionConfig.FeatureConfig
        parseFrom(com.google.protobuf.ByteString data)
            throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.aiplatform.v1beta1.FeatureSelectionConfig.FeatureConfig
        parseFrom(
            com.google.protobuf.ByteString data,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.aiplatform.v1beta1.FeatureSelectionConfig.FeatureConfig
        parseFrom(byte[] data) throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.aiplatform.v1beta1.FeatureSelectionConfig.FeatureConfig
        parseFrom(byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.aiplatform.v1beta1.FeatureSelectionConfig.FeatureConfig
        parseFrom(java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.cloud.aiplatform.v1beta1.FeatureSelectionConfig.FeatureConfig
        parseFrom(
            java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.cloud.aiplatform.v1beta1.FeatureSelectionConfig.FeatureConfig
        parseDelimitedFrom(java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
    }

    public static com.google.cloud.aiplatform.v1beta1.FeatureSelectionConfig.FeatureConfig
        parseDelimitedFrom(
            java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.cloud.aiplatform.v1beta1.FeatureSelectionConfig.FeatureConfig
        parseFrom(com.google.protobuf.CodedInputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.cloud.aiplatform.v1beta1.FeatureSelectionConfig.FeatureConfig
        parseFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    @java.lang.Override
    public Builder newBuilderForType() {
      return newBuilder();
    }

    public static Builder newBuilder() {
      return DEFAULT_INSTANCE.toBuilder();
    }

    public static Builder newBuilder(
        com.google.cloud.aiplatform.v1beta1.FeatureSelectionConfig.FeatureConfig prototype) {
      return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }

    @java.lang.Override
    public Builder toBuilder() {
      return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
    }

    @java.lang.Override
    protected Builder newBuilderForType(
        com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      Builder builder = new Builder(parent);
      return builder;
    }
    /**
     *
     *
     * <pre>
     * Feature configuration.
     * </pre>
     *
     * Protobuf type {@code google.cloud.aiplatform.v1beta1.FeatureSelectionConfig.FeatureConfig}
     */
    public static final class Builder
        extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
        implements
        // @@protoc_insertion_point(builder_implements:google.cloud.aiplatform.v1beta1.FeatureSelectionConfig.FeatureConfig)
        com.google.cloud.aiplatform.v1beta1.FeatureSelectionConfig.FeatureConfigOrBuilder {
      public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
        return com.google.cloud.aiplatform.v1beta1.FeatureMonitorProto
            .internal_static_google_cloud_aiplatform_v1beta1_FeatureSelectionConfig_FeatureConfig_descriptor;
      }

      @java.lang.Override
      protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return com.google.cloud.aiplatform.v1beta1.FeatureMonitorProto
            .internal_static_google_cloud_aiplatform_v1beta1_FeatureSelectionConfig_FeatureConfig_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                com.google.cloud.aiplatform.v1beta1.FeatureSelectionConfig.FeatureConfig.class,
                com.google.cloud.aiplatform.v1beta1.FeatureSelectionConfig.FeatureConfig.Builder
                    .class);
      }

      // Construct using
      // com.google.cloud.aiplatform.v1beta1.FeatureSelectionConfig.FeatureConfig.newBuilder()
      private Builder() {}

      private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
        super(parent);
      }

      @java.lang.Override
      public Builder clear() {
        super.clear();
        bitField0_ = 0;
        featureId_ = "";
        driftThreshold_ = 0D;
        return this;
      }

      @java.lang.Override
      public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
        return com.google.cloud.aiplatform.v1beta1.FeatureMonitorProto
            .internal_static_google_cloud_aiplatform_v1beta1_FeatureSelectionConfig_FeatureConfig_descriptor;
      }

      @java.lang.Override
      public com.google.cloud.aiplatform.v1beta1.FeatureSelectionConfig.FeatureConfig
          getDefaultInstanceForType() {
        return com.google.cloud.aiplatform.v1beta1.FeatureSelectionConfig.FeatureConfig
            .getDefaultInstance();
      }

      @java.lang.Override
      public com.google.cloud.aiplatform.v1beta1.FeatureSelectionConfig.FeatureConfig build() {
        com.google.cloud.aiplatform.v1beta1.FeatureSelectionConfig.FeatureConfig result =
            buildPartial();
        if (!result.isInitialized()) {
          throw newUninitializedMessageException(result);
        }
        return result;
      }

      @java.lang.Override
      public com.google.cloud.aiplatform.v1beta1.FeatureSelectionConfig.FeatureConfig
          buildPartial() {
        com.google.cloud.aiplatform.v1beta1.FeatureSelectionConfig.FeatureConfig result =
            new com.google.cloud.aiplatform.v1beta1.FeatureSelectionConfig.FeatureConfig(this);
        if (bitField0_ != 0) {
          buildPartial0(result);
        }
        onBuilt();
        return result;
      }

      private void buildPartial0(
          com.google.cloud.aiplatform.v1beta1.FeatureSelectionConfig.FeatureConfig result) {
        int from_bitField0_ = bitField0_;
        if (((from_bitField0_ & 0x00000001) != 0)) {
          result.featureId_ = featureId_;
        }
        if (((from_bitField0_ & 0x00000002) != 0)) {
          result.driftThreshold_ = driftThreshold_;
        }
      }

      @java.lang.Override
      public Builder clone() {
        return super.clone();
      }

      @java.lang.Override
      public Builder setField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.setField(field, value);
      }

      @java.lang.Override
      public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
        return super.clearField(field);
      }

      @java.lang.Override
      public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
        return super.clearOneof(oneof);
      }

      @java.lang.Override
      public Builder setRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          int index,
          java.lang.Object value) {
        return super.setRepeatedField(field, index, value);
      }

      @java.lang.Override
      public Builder addRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.addRepeatedField(field, value);
      }

      @java.lang.Override
      public Builder mergeFrom(com.google.protobuf.Message other) {
        if (other
            instanceof com.google.cloud.aiplatform.v1beta1.FeatureSelectionConfig.FeatureConfig) {
          return mergeFrom(
              (com.google.cloud.aiplatform.v1beta1.FeatureSelectionConfig.FeatureConfig) other);
        } else {
          super.mergeFrom(other);
          return this;
        }
      }

      public Builder mergeFrom(
          com.google.cloud.aiplatform.v1beta1.FeatureSelectionConfig.FeatureConfig other) {
        if (other
            == com.google.cloud.aiplatform.v1beta1.FeatureSelectionConfig.FeatureConfig
                .getDefaultInstance()) return this;
        if (!other.getFeatureId().isEmpty()) {
          featureId_ = other.featureId_;
          bitField0_ |= 0x00000001;
          onChanged();
        }
        if (other.getDriftThreshold() != 0D) {
          setDriftThreshold(other.getDriftThreshold());
        }
        this.mergeUnknownFields(other.getUnknownFields());
        onChanged();
        return this;
      }

      @java.lang.Override
      public final boolean isInitialized() {
        return true;
      }

      @java.lang.Override
      public Builder mergeFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        if (extensionRegistry == null) {
          throw new java.lang.NullPointerException();
        }
        try {
          boolean done = false;
          while (!done) {
            int tag = input.readTag();
            switch (tag) {
              case 0:
                done = true;
                break;
              case 10:
                {
                  featureId_ = input.readStringRequireUtf8();
                  bitField0_ |= 0x00000001;
                  break;
                } // case 10
              case 17:
                {
                  driftThreshold_ = input.readDouble();
                  bitField0_ |= 0x00000002;
                  break;
                } // case 17
              default:
                {
                  if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                    done = true; // was an endgroup tag
                  }
                  break;
                } // default:
            } // switch (tag)
          } // while (!done)
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          throw e.unwrapIOException();
        } finally {
          onChanged();
        } // finally
        return this;
      }

      private int bitField0_;

      private java.lang.Object featureId_ = "";
      /**
       *
       *
       * <pre>
       * Required. The ID of the feature resource. Final component of the
       * Feature's resource name.
       * </pre>
       *
       * <code>string feature_id = 1 [(.google.api.field_behavior) = REQUIRED];</code>
       *
       * @return The featureId.
       */
      public java.lang.String getFeatureId() {
        java.lang.Object ref = featureId_;
        if (!(ref instanceof java.lang.String)) {
          com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
          java.lang.String s = bs.toStringUtf8();
          featureId_ = s;
          return s;
        } else {
          return (java.lang.String) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * Required. The ID of the feature resource. Final component of the
       * Feature's resource name.
       * </pre>
       *
       * <code>string feature_id = 1 [(.google.api.field_behavior) = REQUIRED];</code>
       *
       * @return The bytes for featureId.
       */
      public com.google.protobuf.ByteString getFeatureIdBytes() {
        java.lang.Object ref = featureId_;
        if (ref instanceof String) {
          com.google.protobuf.ByteString b =
              com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
          featureId_ = b;
          return b;
        } else {
          return (com.google.protobuf.ByteString) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * Required. The ID of the feature resource. Final component of the
       * Feature's resource name.
       * </pre>
       *
       * <code>string feature_id = 1 [(.google.api.field_behavior) = REQUIRED];</code>
       *
       * @param value The featureId to set.
       * @return This builder for chaining.
       */
      public Builder setFeatureId(java.lang.String value) {
        if (value == null) {
          throw new NullPointerException();
        }
        featureId_ = value;
        bitField0_ |= 0x00000001;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Required. The ID of the feature resource. Final component of the
       * Feature's resource name.
       * </pre>
       *
       * <code>string feature_id = 1 [(.google.api.field_behavior) = REQUIRED];</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearFeatureId() {
        featureId_ = getDefaultInstance().getFeatureId();
        bitField0_ = (bitField0_ & ~0x00000001);
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Required. The ID of the feature resource. Final component of the
       * Feature's resource name.
       * </pre>
       *
       * <code>string feature_id = 1 [(.google.api.field_behavior) = REQUIRED];</code>
       *
       * @param value The bytes for featureId to set.
       * @return This builder for chaining.
       */
      public Builder setFeatureIdBytes(com.google.protobuf.ByteString value) {
        if (value == null) {
          throw new NullPointerException();
        }
        checkByteStringIsUtf8(value);
        featureId_ = value;
        bitField0_ |= 0x00000001;
        onChanged();
        return this;
      }

      private double driftThreshold_;
      /**
       *
       *
       * <pre>
       * Optional. Drift threshold. If calculated difference with baseline data
       * larger than threshold, it will be considered as the feature has drift. If
       * not present, the threshold will be default to 0.3.
       * </pre>
       *
       * <code>double drift_threshold = 2 [(.google.api.field_behavior) = OPTIONAL];</code>
       *
       * @return The driftThreshold.
       */
      @java.lang.Override
      public double getDriftThreshold() {
        return driftThreshold_;
      }
      /**
       *
       *
       * <pre>
       * Optional. Drift threshold. If calculated difference with baseline data
       * larger than threshold, it will be considered as the feature has drift. If
       * not present, the threshold will be default to 0.3.
       * </pre>
       *
       * <code>double drift_threshold = 2 [(.google.api.field_behavior) = OPTIONAL];</code>
       *
       * @param value The driftThreshold to set.
       * @return This builder for chaining.
       */
      public Builder setDriftThreshold(double value) {

        driftThreshold_ = value;
        bitField0_ |= 0x00000002;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Optional. Drift threshold. If calculated difference with baseline data
       * larger than threshold, it will be considered as the feature has drift. If
       * not present, the threshold will be default to 0.3.
       * </pre>
       *
       * <code>double drift_threshold = 2 [(.google.api.field_behavior) = OPTIONAL];</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearDriftThreshold() {
        bitField0_ = (bitField0_ & ~0x00000002);
        driftThreshold_ = 0D;
        onChanged();
        return this;
      }

      @java.lang.Override
      public final Builder setUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.setUnknownFields(unknownFields);
      }

      @java.lang.Override
      public final Builder mergeUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.mergeUnknownFields(unknownFields);
      }

      // @@protoc_insertion_point(builder_scope:google.cloud.aiplatform.v1beta1.FeatureSelectionConfig.FeatureConfig)
    }

    // @@protoc_insertion_point(class_scope:google.cloud.aiplatform.v1beta1.FeatureSelectionConfig.FeatureConfig)
    private static final com.google.cloud.aiplatform.v1beta1.FeatureSelectionConfig.FeatureConfig
        DEFAULT_INSTANCE;

    static {
      DEFAULT_INSTANCE =
          new com.google.cloud.aiplatform.v1beta1.FeatureSelectionConfig.FeatureConfig();
    }

    public static com.google.cloud.aiplatform.v1beta1.FeatureSelectionConfig.FeatureConfig
        getDefaultInstance() {
      return DEFAULT_INSTANCE;
    }

    private static final com.google.protobuf.Parser<FeatureConfig> PARSER =
        new com.google.protobuf.AbstractParser<FeatureConfig>() {
          @java.lang.Override
          public FeatureConfig parsePartialFrom(
              com.google.protobuf.CodedInputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
            Builder builder = newBuilder();
            try {
              builder.mergeFrom(input, extensionRegistry);
            } catch (com.google.protobuf.InvalidProtocolBufferException e) {
              throw e.setUnfinishedMessage(builder.buildPartial());
            } catch (com.google.protobuf.UninitializedMessageException e) {
              throw e.asInvalidProtocolBufferException()
                  .setUnfinishedMessage(builder.buildPartial());
            } catch (java.io.IOException e) {
              throw new com.google.protobuf.InvalidProtocolBufferException(e)
                  .setUnfinishedMessage(builder.buildPartial());
            }
            return builder.buildPartial();
          }
        };

    public static com.google.protobuf.Parser<FeatureConfig> parser() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.protobuf.Parser<FeatureConfig> getParserForType() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.cloud.aiplatform.v1beta1.FeatureSelectionConfig.FeatureConfig
        getDefaultInstanceForType() {
      return DEFAULT_INSTANCE;
    }
  }

  public static final int FEATURE_CONFIGS_FIELD_NUMBER = 1;

  @SuppressWarnings("serial")
  private java.util.List<com.google.cloud.aiplatform.v1beta1.FeatureSelectionConfig.FeatureConfig>
      featureConfigs_;
  /**
   *
   *
   * <pre>
   * Optional. A list of features to be monitored and each feature's drift
   * threshold.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.aiplatform.v1beta1.FeatureSelectionConfig.FeatureConfig feature_configs = 1 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   */
  @java.lang.Override
  public java.util.List<com.google.cloud.aiplatform.v1beta1.FeatureSelectionConfig.FeatureConfig>
      getFeatureConfigsList() {
    return featureConfigs_;
  }
  /**
   *
   *
   * <pre>
   * Optional. A list of features to be monitored and each feature's drift
   * threshold.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.aiplatform.v1beta1.FeatureSelectionConfig.FeatureConfig feature_configs = 1 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   */
  @java.lang.Override
  public java.util.List<
          ? extends
              com.google.cloud.aiplatform.v1beta1.FeatureSelectionConfig.FeatureConfigOrBuilder>
      getFeatureConfigsOrBuilderList() {
    return featureConfigs_;
  }
  /**
   *
   *
   * <pre>
   * Optional. A list of features to be monitored and each feature's drift
   * threshold.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.aiplatform.v1beta1.FeatureSelectionConfig.FeatureConfig feature_configs = 1 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   */
  @java.lang.Override
  public int getFeatureConfigsCount() {
    return featureConfigs_.size();
  }
  /**
   *
   *
   * <pre>
   * Optional. A list of features to be monitored and each feature's drift
   * threshold.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.aiplatform.v1beta1.FeatureSelectionConfig.FeatureConfig feature_configs = 1 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.aiplatform.v1beta1.FeatureSelectionConfig.FeatureConfig getFeatureConfigs(
      int index) {
    return featureConfigs_.get(index);
  }
  /**
   *
   *
   * <pre>
   * Optional. A list of features to be monitored and each feature's drift
   * threshold.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.aiplatform.v1beta1.FeatureSelectionConfig.FeatureConfig feature_configs = 1 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.aiplatform.v1beta1.FeatureSelectionConfig.FeatureConfigOrBuilder
      getFeatureConfigsOrBuilder(int index) {
    return featureConfigs_.get(index);
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    for (int i = 0; i < featureConfigs_.size(); i++) {
      output.writeMessage(1, featureConfigs_.get(i));
    }
    getUnknownFields().writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    for (int i = 0; i < featureConfigs_.size(); i++) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(1, featureConfigs_.get(i));
    }
    size += getUnknownFields().getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.cloud.aiplatform.v1beta1.FeatureSelectionConfig)) {
      return super.equals(obj);
    }
    com.google.cloud.aiplatform.v1beta1.FeatureSelectionConfig other =
        (com.google.cloud.aiplatform.v1beta1.FeatureSelectionConfig) obj;

    if (!getFeatureConfigsList().equals(other.getFeatureConfigsList())) return false;
    if (!getUnknownFields().equals(other.getUnknownFields())) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    if (getFeatureConfigsCount() > 0) {
      hash = (37 * hash) + FEATURE_CONFIGS_FIELD_NUMBER;
      hash = (53 * hash) + getFeatureConfigsList().hashCode();
    }
    hash = (29 * hash) + getUnknownFields().hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.cloud.aiplatform.v1beta1.FeatureSelectionConfig parseFrom(
      java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.aiplatform.v1beta1.FeatureSelectionConfig parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.aiplatform.v1beta1.FeatureSelectionConfig parseFrom(
      com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.aiplatform.v1beta1.FeatureSelectionConfig parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.aiplatform.v1beta1.FeatureSelectionConfig parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.aiplatform.v1beta1.FeatureSelectionConfig parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.aiplatform.v1beta1.FeatureSelectionConfig parseFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.aiplatform.v1beta1.FeatureSelectionConfig parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.aiplatform.v1beta1.FeatureSelectionConfig parseDelimitedFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.cloud.aiplatform.v1beta1.FeatureSelectionConfig parseDelimitedFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.aiplatform.v1beta1.FeatureSelectionConfig parseFrom(
      com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.aiplatform.v1beta1.FeatureSelectionConfig parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(
      com.google.cloud.aiplatform.v1beta1.FeatureSelectionConfig prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }
  /**
   *
   *
   * <pre>
   * Feature selection configuration for the FeatureMonitor.
   * </pre>
   *
   * Protobuf type {@code google.cloud.aiplatform.v1beta1.FeatureSelectionConfig}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.cloud.aiplatform.v1beta1.FeatureSelectionConfig)
      com.google.cloud.aiplatform.v1beta1.FeatureSelectionConfigOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.aiplatform.v1beta1.FeatureMonitorProto
          .internal_static_google_cloud_aiplatform_v1beta1_FeatureSelectionConfig_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.aiplatform.v1beta1.FeatureMonitorProto
          .internal_static_google_cloud_aiplatform_v1beta1_FeatureSelectionConfig_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.aiplatform.v1beta1.FeatureSelectionConfig.class,
              com.google.cloud.aiplatform.v1beta1.FeatureSelectionConfig.Builder.class);
    }

    // Construct using com.google.cloud.aiplatform.v1beta1.FeatureSelectionConfig.newBuilder()
    private Builder() {}

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      bitField0_ = 0;
      if (featureConfigsBuilder_ == null) {
        featureConfigs_ = java.util.Collections.emptyList();
      } else {
        featureConfigs_ = null;
        featureConfigsBuilder_.clear();
      }
      bitField0_ = (bitField0_ & ~0x00000001);
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.cloud.aiplatform.v1beta1.FeatureMonitorProto
          .internal_static_google_cloud_aiplatform_v1beta1_FeatureSelectionConfig_descriptor;
    }

    @java.lang.Override
    public com.google.cloud.aiplatform.v1beta1.FeatureSelectionConfig getDefaultInstanceForType() {
      return com.google.cloud.aiplatform.v1beta1.FeatureSelectionConfig.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.cloud.aiplatform.v1beta1.FeatureSelectionConfig build() {
      com.google.cloud.aiplatform.v1beta1.FeatureSelectionConfig result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.cloud.aiplatform.v1beta1.FeatureSelectionConfig buildPartial() {
      com.google.cloud.aiplatform.v1beta1.FeatureSelectionConfig result =
          new com.google.cloud.aiplatform.v1beta1.FeatureSelectionConfig(this);
      buildPartialRepeatedFields(result);
      if (bitField0_ != 0) {
        buildPartial0(result);
      }
      onBuilt();
      return result;
    }

    private void buildPartialRepeatedFields(
        com.google.cloud.aiplatform.v1beta1.FeatureSelectionConfig result) {
      if (featureConfigsBuilder_ == null) {
        if (((bitField0_ & 0x00000001) != 0)) {
          featureConfigs_ = java.util.Collections.unmodifiableList(featureConfigs_);
          bitField0_ = (bitField0_ & ~0x00000001);
        }
        result.featureConfigs_ = featureConfigs_;
      } else {
        result.featureConfigs_ = featureConfigsBuilder_.build();
      }
    }

    private void buildPartial0(com.google.cloud.aiplatform.v1beta1.FeatureSelectionConfig result) {
      int from_bitField0_ = bitField0_;
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.cloud.aiplatform.v1beta1.FeatureSelectionConfig) {
        return mergeFrom((com.google.cloud.aiplatform.v1beta1.FeatureSelectionConfig) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(com.google.cloud.aiplatform.v1beta1.FeatureSelectionConfig other) {
      if (other == com.google.cloud.aiplatform.v1beta1.FeatureSelectionConfig.getDefaultInstance())
        return this;
      if (featureConfigsBuilder_ == null) {
        if (!other.featureConfigs_.isEmpty()) {
          if (featureConfigs_.isEmpty()) {
            featureConfigs_ = other.featureConfigs_;
            bitField0_ = (bitField0_ & ~0x00000001);
          } else {
            ensureFeatureConfigsIsMutable();
            featureConfigs_.addAll(other.featureConfigs_);
          }
          onChanged();
        }
      } else {
        if (!other.featureConfigs_.isEmpty()) {
          if (featureConfigsBuilder_.isEmpty()) {
            featureConfigsBuilder_.dispose();
            featureConfigsBuilder_ = null;
            featureConfigs_ = other.featureConfigs_;
            bitField0_ = (bitField0_ & ~0x00000001);
            featureConfigsBuilder_ =
                com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders
                    ? getFeatureConfigsFieldBuilder()
                    : null;
          } else {
            featureConfigsBuilder_.addAllMessages(other.featureConfigs_);
          }
        }
      }
      this.mergeUnknownFields(other.getUnknownFields());
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 10:
              {
                com.google.cloud.aiplatform.v1beta1.FeatureSelectionConfig.FeatureConfig m =
                    input.readMessage(
                        com.google.cloud.aiplatform.v1beta1.FeatureSelectionConfig.FeatureConfig
                            .parser(),
                        extensionRegistry);
                if (featureConfigsBuilder_ == null) {
                  ensureFeatureConfigsIsMutable();
                  featureConfigs_.add(m);
                } else {
                  featureConfigsBuilder_.addMessage(m);
                }
                break;
              } // case 10
            default:
              {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
          } // switch (tag)
        } // while (!done)
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.unwrapIOException();
      } finally {
        onChanged();
      } // finally
      return this;
    }

    private int bitField0_;

    private java.util.List<com.google.cloud.aiplatform.v1beta1.FeatureSelectionConfig.FeatureConfig>
        featureConfigs_ = java.util.Collections.emptyList();

    private void ensureFeatureConfigsIsMutable() {
      if (!((bitField0_ & 0x00000001) != 0)) {
        featureConfigs_ =
            new java.util.ArrayList<
                com.google.cloud.aiplatform.v1beta1.FeatureSelectionConfig.FeatureConfig>(
                featureConfigs_);
        bitField0_ |= 0x00000001;
      }
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.cloud.aiplatform.v1beta1.FeatureSelectionConfig.FeatureConfig,
            com.google.cloud.aiplatform.v1beta1.FeatureSelectionConfig.FeatureConfig.Builder,
            com.google.cloud.aiplatform.v1beta1.FeatureSelectionConfig.FeatureConfigOrBuilder>
        featureConfigsBuilder_;

    /**
     *
     *
     * <pre>
     * Optional. A list of features to be monitored and each feature's drift
     * threshold.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.aiplatform.v1beta1.FeatureSelectionConfig.FeatureConfig feature_configs = 1 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public java.util.List<com.google.cloud.aiplatform.v1beta1.FeatureSelectionConfig.FeatureConfig>
        getFeatureConfigsList() {
      if (featureConfigsBuilder_ == null) {
        return java.util.Collections.unmodifiableList(featureConfigs_);
      } else {
        return featureConfigsBuilder_.getMessageList();
      }
    }
    /**
     *
     *
     * <pre>
     * Optional. A list of features to be monitored and each feature's drift
     * threshold.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.aiplatform.v1beta1.FeatureSelectionConfig.FeatureConfig feature_configs = 1 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public int getFeatureConfigsCount() {
      if (featureConfigsBuilder_ == null) {
        return featureConfigs_.size();
      } else {
        return featureConfigsBuilder_.getCount();
      }
    }
    /**
     *
     *
     * <pre>
     * Optional. A list of features to be monitored and each feature's drift
     * threshold.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.aiplatform.v1beta1.FeatureSelectionConfig.FeatureConfig feature_configs = 1 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public com.google.cloud.aiplatform.v1beta1.FeatureSelectionConfig.FeatureConfig
        getFeatureConfigs(int index) {
      if (featureConfigsBuilder_ == null) {
        return featureConfigs_.get(index);
      } else {
        return featureConfigsBuilder_.getMessage(index);
      }
    }
    /**
     *
     *
     * <pre>
     * Optional. A list of features to be monitored and each feature's drift
     * threshold.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.aiplatform.v1beta1.FeatureSelectionConfig.FeatureConfig feature_configs = 1 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder setFeatureConfigs(
        int index, com.google.cloud.aiplatform.v1beta1.FeatureSelectionConfig.FeatureConfig value) {
      if (featureConfigsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureFeatureConfigsIsMutable();
        featureConfigs_.set(index, value);
        onChanged();
      } else {
        featureConfigsBuilder_.setMessage(index, value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. A list of features to be monitored and each feature's drift
     * threshold.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.aiplatform.v1beta1.FeatureSelectionConfig.FeatureConfig feature_configs = 1 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder setFeatureConfigs(
        int index,
        com.google.cloud.aiplatform.v1beta1.FeatureSelectionConfig.FeatureConfig.Builder
            builderForValue) {
      if (featureConfigsBuilder_ == null) {
        ensureFeatureConfigsIsMutable();
        featureConfigs_.set(index, builderForValue.build());
        onChanged();
      } else {
        featureConfigsBuilder_.setMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. A list of features to be monitored and each feature's drift
     * threshold.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.aiplatform.v1beta1.FeatureSelectionConfig.FeatureConfig feature_configs = 1 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder addFeatureConfigs(
        com.google.cloud.aiplatform.v1beta1.FeatureSelectionConfig.FeatureConfig value) {
      if (featureConfigsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureFeatureConfigsIsMutable();
        featureConfigs_.add(value);
        onChanged();
      } else {
        featureConfigsBuilder_.addMessage(value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. A list of features to be monitored and each feature's drift
     * threshold.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.aiplatform.v1beta1.FeatureSelectionConfig.FeatureConfig feature_configs = 1 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder addFeatureConfigs(
        int index, com.google.cloud.aiplatform.v1beta1.FeatureSelectionConfig.FeatureConfig value) {
      if (featureConfigsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureFeatureConfigsIsMutable();
        featureConfigs_.add(index, value);
        onChanged();
      } else {
        featureConfigsBuilder_.addMessage(index, value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. A list of features to be monitored and each feature's drift
     * threshold.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.aiplatform.v1beta1.FeatureSelectionConfig.FeatureConfig feature_configs = 1 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder addFeatureConfigs(
        com.google.cloud.aiplatform.v1beta1.FeatureSelectionConfig.FeatureConfig.Builder
            builderForValue) {
      if (featureConfigsBuilder_ == null) {
        ensureFeatureConfigsIsMutable();
        featureConfigs_.add(builderForValue.build());
        onChanged();
      } else {
        featureConfigsBuilder_.addMessage(builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. A list of features to be monitored and each feature's drift
     * threshold.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.aiplatform.v1beta1.FeatureSelectionConfig.FeatureConfig feature_configs = 1 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder addFeatureConfigs(
        int index,
        com.google.cloud.aiplatform.v1beta1.FeatureSelectionConfig.FeatureConfig.Builder
            builderForValue) {
      if (featureConfigsBuilder_ == null) {
        ensureFeatureConfigsIsMutable();
        featureConfigs_.add(index, builderForValue.build());
        onChanged();
      } else {
        featureConfigsBuilder_.addMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. A list of features to be monitored and each feature's drift
     * threshold.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.aiplatform.v1beta1.FeatureSelectionConfig.FeatureConfig feature_configs = 1 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder addAllFeatureConfigs(
        java.lang.Iterable<
                ? extends com.google.cloud.aiplatform.v1beta1.FeatureSelectionConfig.FeatureConfig>
            values) {
      if (featureConfigsBuilder_ == null) {
        ensureFeatureConfigsIsMutable();
        com.google.protobuf.AbstractMessageLite.Builder.addAll(values, featureConfigs_);
        onChanged();
      } else {
        featureConfigsBuilder_.addAllMessages(values);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. A list of features to be monitored and each feature's drift
     * threshold.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.aiplatform.v1beta1.FeatureSelectionConfig.FeatureConfig feature_configs = 1 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder clearFeatureConfigs() {
      if (featureConfigsBuilder_ == null) {
        featureConfigs_ = java.util.Collections.emptyList();
        bitField0_ = (bitField0_ & ~0x00000001);
        onChanged();
      } else {
        featureConfigsBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. A list of features to be monitored and each feature's drift
     * threshold.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.aiplatform.v1beta1.FeatureSelectionConfig.FeatureConfig feature_configs = 1 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder removeFeatureConfigs(int index) {
      if (featureConfigsBuilder_ == null) {
        ensureFeatureConfigsIsMutable();
        featureConfigs_.remove(index);
        onChanged();
      } else {
        featureConfigsBuilder_.remove(index);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. A list of features to be monitored and each feature's drift
     * threshold.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.aiplatform.v1beta1.FeatureSelectionConfig.FeatureConfig feature_configs = 1 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public com.google.cloud.aiplatform.v1beta1.FeatureSelectionConfig.FeatureConfig.Builder
        getFeatureConfigsBuilder(int index) {
      return getFeatureConfigsFieldBuilder().getBuilder(index);
    }
    /**
     *
     *
     * <pre>
     * Optional. A list of features to be monitored and each feature's drift
     * threshold.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.aiplatform.v1beta1.FeatureSelectionConfig.FeatureConfig feature_configs = 1 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public com.google.cloud.aiplatform.v1beta1.FeatureSelectionConfig.FeatureConfigOrBuilder
        getFeatureConfigsOrBuilder(int index) {
      if (featureConfigsBuilder_ == null) {
        return featureConfigs_.get(index);
      } else {
        return featureConfigsBuilder_.getMessageOrBuilder(index);
      }
    }
    /**
     *
     *
     * <pre>
     * Optional. A list of features to be monitored and each feature's drift
     * threshold.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.aiplatform.v1beta1.FeatureSelectionConfig.FeatureConfig feature_configs = 1 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public java.util.List<
            ? extends
                com.google.cloud.aiplatform.v1beta1.FeatureSelectionConfig.FeatureConfigOrBuilder>
        getFeatureConfigsOrBuilderList() {
      if (featureConfigsBuilder_ != null) {
        return featureConfigsBuilder_.getMessageOrBuilderList();
      } else {
        return java.util.Collections.unmodifiableList(featureConfigs_);
      }
    }
    /**
     *
     *
     * <pre>
     * Optional. A list of features to be monitored and each feature's drift
     * threshold.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.aiplatform.v1beta1.FeatureSelectionConfig.FeatureConfig feature_configs = 1 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public com.google.cloud.aiplatform.v1beta1.FeatureSelectionConfig.FeatureConfig.Builder
        addFeatureConfigsBuilder() {
      return getFeatureConfigsFieldBuilder()
          .addBuilder(
              com.google.cloud.aiplatform.v1beta1.FeatureSelectionConfig.FeatureConfig
                  .getDefaultInstance());
    }
    /**
     *
     *
     * <pre>
     * Optional. A list of features to be monitored and each feature's drift
     * threshold.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.aiplatform.v1beta1.FeatureSelectionConfig.FeatureConfig feature_configs = 1 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public com.google.cloud.aiplatform.v1beta1.FeatureSelectionConfig.FeatureConfig.Builder
        addFeatureConfigsBuilder(int index) {
      return getFeatureConfigsFieldBuilder()
          .addBuilder(
              index,
              com.google.cloud.aiplatform.v1beta1.FeatureSelectionConfig.FeatureConfig
                  .getDefaultInstance());
    }
    /**
     *
     *
     * <pre>
     * Optional. A list of features to be monitored and each feature's drift
     * threshold.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.aiplatform.v1beta1.FeatureSelectionConfig.FeatureConfig feature_configs = 1 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public java.util.List<
            com.google.cloud.aiplatform.v1beta1.FeatureSelectionConfig.FeatureConfig.Builder>
        getFeatureConfigsBuilderList() {
      return getFeatureConfigsFieldBuilder().getBuilderList();
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.cloud.aiplatform.v1beta1.FeatureSelectionConfig.FeatureConfig,
            com.google.cloud.aiplatform.v1beta1.FeatureSelectionConfig.FeatureConfig.Builder,
            com.google.cloud.aiplatform.v1beta1.FeatureSelectionConfig.FeatureConfigOrBuilder>
        getFeatureConfigsFieldBuilder() {
      if (featureConfigsBuilder_ == null) {
        featureConfigsBuilder_ =
            new com.google.protobuf.RepeatedFieldBuilderV3<
                com.google.cloud.aiplatform.v1beta1.FeatureSelectionConfig.FeatureConfig,
                com.google.cloud.aiplatform.v1beta1.FeatureSelectionConfig.FeatureConfig.Builder,
                com.google.cloud.aiplatform.v1beta1.FeatureSelectionConfig.FeatureConfigOrBuilder>(
                featureConfigs_,
                ((bitField0_ & 0x00000001) != 0),
                getParentForChildren(),
                isClean());
        featureConfigs_ = null;
      }
      return featureConfigsBuilder_;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.cloud.aiplatform.v1beta1.FeatureSelectionConfig)
  }

  // @@protoc_insertion_point(class_scope:google.cloud.aiplatform.v1beta1.FeatureSelectionConfig)
  private static final com.google.cloud.aiplatform.v1beta1.FeatureSelectionConfig DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.cloud.aiplatform.v1beta1.FeatureSelectionConfig();
  }

  public static com.google.cloud.aiplatform.v1beta1.FeatureSelectionConfig getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<FeatureSelectionConfig> PARSER =
      new com.google.protobuf.AbstractParser<FeatureSelectionConfig>() {
        @java.lang.Override
        public FeatureSelectionConfig parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          Builder builder = newBuilder();
          try {
            builder.mergeFrom(input, extensionRegistry);
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.setUnfinishedMessage(builder.buildPartial());
          } catch (com.google.protobuf.UninitializedMessageException e) {
            throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
          } catch (java.io.IOException e) {
            throw new com.google.protobuf.InvalidProtocolBufferException(e)
                .setUnfinishedMessage(builder.buildPartial());
          }
          return builder.buildPartial();
        }
      };

  public static com.google.protobuf.Parser<FeatureSelectionConfig> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<FeatureSelectionConfig> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.cloud.aiplatform.v1beta1.FeatureSelectionConfig getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
