/*
 * Copyright 2024 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/cloud/aiplatform/v1beta1/feature_online_store_service.proto

// Protobuf Java Version: 3.25.5
package com.google.cloud.aiplatform.v1beta1;

/**
 *
 *
 * <pre>
 * Lookup key for a feature view.
 * </pre>
 *
 * Protobuf type {@code google.cloud.aiplatform.v1beta1.FeatureViewDataKey}
 */
public final class FeatureViewDataKey extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.cloud.aiplatform.v1beta1.FeatureViewDataKey)
    FeatureViewDataKeyOrBuilder {
  private static final long serialVersionUID = 0L;
  // Use FeatureViewDataKey.newBuilder() to construct.
  private FeatureViewDataKey(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private FeatureViewDataKey() {}

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new FeatureViewDataKey();
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.cloud.aiplatform.v1beta1.FeatureOnlineStoreServiceProto
        .internal_static_google_cloud_aiplatform_v1beta1_FeatureViewDataKey_descriptor;
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.cloud.aiplatform.v1beta1.FeatureOnlineStoreServiceProto
        .internal_static_google_cloud_aiplatform_v1beta1_FeatureViewDataKey_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.cloud.aiplatform.v1beta1.FeatureViewDataKey.class,
            com.google.cloud.aiplatform.v1beta1.FeatureViewDataKey.Builder.class);
  }

  public interface CompositeKeyOrBuilder
      extends
      // @@protoc_insertion_point(interface_extends:google.cloud.aiplatform.v1beta1.FeatureViewDataKey.CompositeKey)
      com.google.protobuf.MessageOrBuilder {

    /**
     *
     *
     * <pre>
     * Parts to construct Entity ID. Should match with the same ID columns as
     * defined in FeatureView in the same order.
     * </pre>
     *
     * <code>repeated string parts = 1;</code>
     *
     * @return A list containing the parts.
     */
    java.util.List<java.lang.String> getPartsList();
    /**
     *
     *
     * <pre>
     * Parts to construct Entity ID. Should match with the same ID columns as
     * defined in FeatureView in the same order.
     * </pre>
     *
     * <code>repeated string parts = 1;</code>
     *
     * @return The count of parts.
     */
    int getPartsCount();
    /**
     *
     *
     * <pre>
     * Parts to construct Entity ID. Should match with the same ID columns as
     * defined in FeatureView in the same order.
     * </pre>
     *
     * <code>repeated string parts = 1;</code>
     *
     * @param index The index of the element to return.
     * @return The parts at the given index.
     */
    java.lang.String getParts(int index);
    /**
     *
     *
     * <pre>
     * Parts to construct Entity ID. Should match with the same ID columns as
     * defined in FeatureView in the same order.
     * </pre>
     *
     * <code>repeated string parts = 1;</code>
     *
     * @param index The index of the value to return.
     * @return The bytes of the parts at the given index.
     */
    com.google.protobuf.ByteString getPartsBytes(int index);
  }
  /**
   *
   *
   * <pre>
   * ID that is comprised from several parts (columns).
   * </pre>
   *
   * Protobuf type {@code google.cloud.aiplatform.v1beta1.FeatureViewDataKey.CompositeKey}
   */
  public static final class CompositeKey extends com.google.protobuf.GeneratedMessageV3
      implements
      // @@protoc_insertion_point(message_implements:google.cloud.aiplatform.v1beta1.FeatureViewDataKey.CompositeKey)
      CompositeKeyOrBuilder {
    private static final long serialVersionUID = 0L;
    // Use CompositeKey.newBuilder() to construct.
    private CompositeKey(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
      super(builder);
    }

    private CompositeKey() {
      parts_ = com.google.protobuf.LazyStringArrayList.emptyList();
    }

    @java.lang.Override
    @SuppressWarnings({"unused"})
    protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
      return new CompositeKey();
    }

    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.aiplatform.v1beta1.FeatureOnlineStoreServiceProto
          .internal_static_google_cloud_aiplatform_v1beta1_FeatureViewDataKey_CompositeKey_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.aiplatform.v1beta1.FeatureOnlineStoreServiceProto
          .internal_static_google_cloud_aiplatform_v1beta1_FeatureViewDataKey_CompositeKey_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.aiplatform.v1beta1.FeatureViewDataKey.CompositeKey.class,
              com.google.cloud.aiplatform.v1beta1.FeatureViewDataKey.CompositeKey.Builder.class);
    }

    public static final int PARTS_FIELD_NUMBER = 1;

    @SuppressWarnings("serial")
    private com.google.protobuf.LazyStringArrayList parts_ =
        com.google.protobuf.LazyStringArrayList.emptyList();
    /**
     *
     *
     * <pre>
     * Parts to construct Entity ID. Should match with the same ID columns as
     * defined in FeatureView in the same order.
     * </pre>
     *
     * <code>repeated string parts = 1;</code>
     *
     * @return A list containing the parts.
     */
    public com.google.protobuf.ProtocolStringList getPartsList() {
      return parts_;
    }
    /**
     *
     *
     * <pre>
     * Parts to construct Entity ID. Should match with the same ID columns as
     * defined in FeatureView in the same order.
     * </pre>
     *
     * <code>repeated string parts = 1;</code>
     *
     * @return The count of parts.
     */
    public int getPartsCount() {
      return parts_.size();
    }
    /**
     *
     *
     * <pre>
     * Parts to construct Entity ID. Should match with the same ID columns as
     * defined in FeatureView in the same order.
     * </pre>
     *
     * <code>repeated string parts = 1;</code>
     *
     * @param index The index of the element to return.
     * @return The parts at the given index.
     */
    public java.lang.String getParts(int index) {
      return parts_.get(index);
    }
    /**
     *
     *
     * <pre>
     * Parts to construct Entity ID. Should match with the same ID columns as
     * defined in FeatureView in the same order.
     * </pre>
     *
     * <code>repeated string parts = 1;</code>
     *
     * @param index The index of the value to return.
     * @return The bytes of the parts at the given index.
     */
    public com.google.protobuf.ByteString getPartsBytes(int index) {
      return parts_.getByteString(index);
    }

    private byte memoizedIsInitialized = -1;

    @java.lang.Override
    public final boolean isInitialized() {
      byte isInitialized = memoizedIsInitialized;
      if (isInitialized == 1) return true;
      if (isInitialized == 0) return false;

      memoizedIsInitialized = 1;
      return true;
    }

    @java.lang.Override
    public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
      for (int i = 0; i < parts_.size(); i++) {
        com.google.protobuf.GeneratedMessageV3.writeString(output, 1, parts_.getRaw(i));
      }
      getUnknownFields().writeTo(output);
    }

    @java.lang.Override
    public int getSerializedSize() {
      int size = memoizedSize;
      if (size != -1) return size;

      size = 0;
      {
        int dataSize = 0;
        for (int i = 0; i < parts_.size(); i++) {
          dataSize += computeStringSizeNoTag(parts_.getRaw(i));
        }
        size += dataSize;
        size += 1 * getPartsList().size();
      }
      size += getUnknownFields().getSerializedSize();
      memoizedSize = size;
      return size;
    }

    @java.lang.Override
    public boolean equals(final java.lang.Object obj) {
      if (obj == this) {
        return true;
      }
      if (!(obj instanceof com.google.cloud.aiplatform.v1beta1.FeatureViewDataKey.CompositeKey)) {
        return super.equals(obj);
      }
      com.google.cloud.aiplatform.v1beta1.FeatureViewDataKey.CompositeKey other =
          (com.google.cloud.aiplatform.v1beta1.FeatureViewDataKey.CompositeKey) obj;

      if (!getPartsList().equals(other.getPartsList())) return false;
      if (!getUnknownFields().equals(other.getUnknownFields())) return false;
      return true;
    }

    @java.lang.Override
    public int hashCode() {
      if (memoizedHashCode != 0) {
        return memoizedHashCode;
      }
      int hash = 41;
      hash = (19 * hash) + getDescriptor().hashCode();
      if (getPartsCount() > 0) {
        hash = (37 * hash) + PARTS_FIELD_NUMBER;
        hash = (53 * hash) + getPartsList().hashCode();
      }
      hash = (29 * hash) + getUnknownFields().hashCode();
      memoizedHashCode = hash;
      return hash;
    }

    public static com.google.cloud.aiplatform.v1beta1.FeatureViewDataKey.CompositeKey parseFrom(
        java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.aiplatform.v1beta1.FeatureViewDataKey.CompositeKey parseFrom(
        java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.aiplatform.v1beta1.FeatureViewDataKey.CompositeKey parseFrom(
        com.google.protobuf.ByteString data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.aiplatform.v1beta1.FeatureViewDataKey.CompositeKey parseFrom(
        com.google.protobuf.ByteString data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.aiplatform.v1beta1.FeatureViewDataKey.CompositeKey parseFrom(
        byte[] data) throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.aiplatform.v1beta1.FeatureViewDataKey.CompositeKey parseFrom(
        byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.aiplatform.v1beta1.FeatureViewDataKey.CompositeKey parseFrom(
        java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.cloud.aiplatform.v1beta1.FeatureViewDataKey.CompositeKey parseFrom(
        java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.cloud.aiplatform.v1beta1.FeatureViewDataKey.CompositeKey
        parseDelimitedFrom(java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
    }

    public static com.google.cloud.aiplatform.v1beta1.FeatureViewDataKey.CompositeKey
        parseDelimitedFrom(
            java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.cloud.aiplatform.v1beta1.FeatureViewDataKey.CompositeKey parseFrom(
        com.google.protobuf.CodedInputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.cloud.aiplatform.v1beta1.FeatureViewDataKey.CompositeKey parseFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    @java.lang.Override
    public Builder newBuilderForType() {
      return newBuilder();
    }

    public static Builder newBuilder() {
      return DEFAULT_INSTANCE.toBuilder();
    }

    public static Builder newBuilder(
        com.google.cloud.aiplatform.v1beta1.FeatureViewDataKey.CompositeKey prototype) {
      return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }

    @java.lang.Override
    public Builder toBuilder() {
      return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
    }

    @java.lang.Override
    protected Builder newBuilderForType(
        com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      Builder builder = new Builder(parent);
      return builder;
    }
    /**
     *
     *
     * <pre>
     * ID that is comprised from several parts (columns).
     * </pre>
     *
     * Protobuf type {@code google.cloud.aiplatform.v1beta1.FeatureViewDataKey.CompositeKey}
     */
    public static final class Builder
        extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
        implements
        // @@protoc_insertion_point(builder_implements:google.cloud.aiplatform.v1beta1.FeatureViewDataKey.CompositeKey)
        com.google.cloud.aiplatform.v1beta1.FeatureViewDataKey.CompositeKeyOrBuilder {
      public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
        return com.google.cloud.aiplatform.v1beta1.FeatureOnlineStoreServiceProto
            .internal_static_google_cloud_aiplatform_v1beta1_FeatureViewDataKey_CompositeKey_descriptor;
      }

      @java.lang.Override
      protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return com.google.cloud.aiplatform.v1beta1.FeatureOnlineStoreServiceProto
            .internal_static_google_cloud_aiplatform_v1beta1_FeatureViewDataKey_CompositeKey_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                com.google.cloud.aiplatform.v1beta1.FeatureViewDataKey.CompositeKey.class,
                com.google.cloud.aiplatform.v1beta1.FeatureViewDataKey.CompositeKey.Builder.class);
      }

      // Construct using
      // com.google.cloud.aiplatform.v1beta1.FeatureViewDataKey.CompositeKey.newBuilder()
      private Builder() {}

      private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
        super(parent);
      }

      @java.lang.Override
      public Builder clear() {
        super.clear();
        bitField0_ = 0;
        parts_ = com.google.protobuf.LazyStringArrayList.emptyList();
        return this;
      }

      @java.lang.Override
      public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
        return com.google.cloud.aiplatform.v1beta1.FeatureOnlineStoreServiceProto
            .internal_static_google_cloud_aiplatform_v1beta1_FeatureViewDataKey_CompositeKey_descriptor;
      }

      @java.lang.Override
      public com.google.cloud.aiplatform.v1beta1.FeatureViewDataKey.CompositeKey
          getDefaultInstanceForType() {
        return com.google.cloud.aiplatform.v1beta1.FeatureViewDataKey.CompositeKey
            .getDefaultInstance();
      }

      @java.lang.Override
      public com.google.cloud.aiplatform.v1beta1.FeatureViewDataKey.CompositeKey build() {
        com.google.cloud.aiplatform.v1beta1.FeatureViewDataKey.CompositeKey result = buildPartial();
        if (!result.isInitialized()) {
          throw newUninitializedMessageException(result);
        }
        return result;
      }

      @java.lang.Override
      public com.google.cloud.aiplatform.v1beta1.FeatureViewDataKey.CompositeKey buildPartial() {
        com.google.cloud.aiplatform.v1beta1.FeatureViewDataKey.CompositeKey result =
            new com.google.cloud.aiplatform.v1beta1.FeatureViewDataKey.CompositeKey(this);
        if (bitField0_ != 0) {
          buildPartial0(result);
        }
        onBuilt();
        return result;
      }

      private void buildPartial0(
          com.google.cloud.aiplatform.v1beta1.FeatureViewDataKey.CompositeKey result) {
        int from_bitField0_ = bitField0_;
        if (((from_bitField0_ & 0x00000001) != 0)) {
          parts_.makeImmutable();
          result.parts_ = parts_;
        }
      }

      @java.lang.Override
      public Builder clone() {
        return super.clone();
      }

      @java.lang.Override
      public Builder setField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.setField(field, value);
      }

      @java.lang.Override
      public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
        return super.clearField(field);
      }

      @java.lang.Override
      public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
        return super.clearOneof(oneof);
      }

      @java.lang.Override
      public Builder setRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          int index,
          java.lang.Object value) {
        return super.setRepeatedField(field, index, value);
      }

      @java.lang.Override
      public Builder addRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.addRepeatedField(field, value);
      }

      @java.lang.Override
      public Builder mergeFrom(com.google.protobuf.Message other) {
        if (other instanceof com.google.cloud.aiplatform.v1beta1.FeatureViewDataKey.CompositeKey) {
          return mergeFrom(
              (com.google.cloud.aiplatform.v1beta1.FeatureViewDataKey.CompositeKey) other);
        } else {
          super.mergeFrom(other);
          return this;
        }
      }

      public Builder mergeFrom(
          com.google.cloud.aiplatform.v1beta1.FeatureViewDataKey.CompositeKey other) {
        if (other
            == com.google.cloud.aiplatform.v1beta1.FeatureViewDataKey.CompositeKey
                .getDefaultInstance()) return this;
        if (!other.parts_.isEmpty()) {
          if (parts_.isEmpty()) {
            parts_ = other.parts_;
            bitField0_ |= 0x00000001;
          } else {
            ensurePartsIsMutable();
            parts_.addAll(other.parts_);
          }
          onChanged();
        }
        this.mergeUnknownFields(other.getUnknownFields());
        onChanged();
        return this;
      }

      @java.lang.Override
      public final boolean isInitialized() {
        return true;
      }

      @java.lang.Override
      public Builder mergeFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        if (extensionRegistry == null) {
          throw new java.lang.NullPointerException();
        }
        try {
          boolean done = false;
          while (!done) {
            int tag = input.readTag();
            switch (tag) {
              case 0:
                done = true;
                break;
              case 10:
                {
                  java.lang.String s = input.readStringRequireUtf8();
                  ensurePartsIsMutable();
                  parts_.add(s);
                  break;
                } // case 10
              default:
                {
                  if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                    done = true; // was an endgroup tag
                  }
                  break;
                } // default:
            } // switch (tag)
          } // while (!done)
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          throw e.unwrapIOException();
        } finally {
          onChanged();
        } // finally
        return this;
      }

      private int bitField0_;

      private com.google.protobuf.LazyStringArrayList parts_ =
          com.google.protobuf.LazyStringArrayList.emptyList();

      private void ensurePartsIsMutable() {
        if (!parts_.isModifiable()) {
          parts_ = new com.google.protobuf.LazyStringArrayList(parts_);
        }
        bitField0_ |= 0x00000001;
      }
      /**
       *
       *
       * <pre>
       * Parts to construct Entity ID. Should match with the same ID columns as
       * defined in FeatureView in the same order.
       * </pre>
       *
       * <code>repeated string parts = 1;</code>
       *
       * @return A list containing the parts.
       */
      public com.google.protobuf.ProtocolStringList getPartsList() {
        parts_.makeImmutable();
        return parts_;
      }
      /**
       *
       *
       * <pre>
       * Parts to construct Entity ID. Should match with the same ID columns as
       * defined in FeatureView in the same order.
       * </pre>
       *
       * <code>repeated string parts = 1;</code>
       *
       * @return The count of parts.
       */
      public int getPartsCount() {
        return parts_.size();
      }
      /**
       *
       *
       * <pre>
       * Parts to construct Entity ID. Should match with the same ID columns as
       * defined in FeatureView in the same order.
       * </pre>
       *
       * <code>repeated string parts = 1;</code>
       *
       * @param index The index of the element to return.
       * @return The parts at the given index.
       */
      public java.lang.String getParts(int index) {
        return parts_.get(index);
      }
      /**
       *
       *
       * <pre>
       * Parts to construct Entity ID. Should match with the same ID columns as
       * defined in FeatureView in the same order.
       * </pre>
       *
       * <code>repeated string parts = 1;</code>
       *
       * @param index The index of the value to return.
       * @return The bytes of the parts at the given index.
       */
      public com.google.protobuf.ByteString getPartsBytes(int index) {
        return parts_.getByteString(index);
      }
      /**
       *
       *
       * <pre>
       * Parts to construct Entity ID. Should match with the same ID columns as
       * defined in FeatureView in the same order.
       * </pre>
       *
       * <code>repeated string parts = 1;</code>
       *
       * @param index The index to set the value at.
       * @param value The parts to set.
       * @return This builder for chaining.
       */
      public Builder setParts(int index, java.lang.String value) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensurePartsIsMutable();
        parts_.set(index, value);
        bitField0_ |= 0x00000001;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Parts to construct Entity ID. Should match with the same ID columns as
       * defined in FeatureView in the same order.
       * </pre>
       *
       * <code>repeated string parts = 1;</code>
       *
       * @param value The parts to add.
       * @return This builder for chaining.
       */
      public Builder addParts(java.lang.String value) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensurePartsIsMutable();
        parts_.add(value);
        bitField0_ |= 0x00000001;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Parts to construct Entity ID. Should match with the same ID columns as
       * defined in FeatureView in the same order.
       * </pre>
       *
       * <code>repeated string parts = 1;</code>
       *
       * @param values The parts to add.
       * @return This builder for chaining.
       */
      public Builder addAllParts(java.lang.Iterable<java.lang.String> values) {
        ensurePartsIsMutable();
        com.google.protobuf.AbstractMessageLite.Builder.addAll(values, parts_);
        bitField0_ |= 0x00000001;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Parts to construct Entity ID. Should match with the same ID columns as
       * defined in FeatureView in the same order.
       * </pre>
       *
       * <code>repeated string parts = 1;</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearParts() {
        parts_ = com.google.protobuf.LazyStringArrayList.emptyList();
        bitField0_ = (bitField0_ & ~0x00000001);
        ;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Parts to construct Entity ID. Should match with the same ID columns as
       * defined in FeatureView in the same order.
       * </pre>
       *
       * <code>repeated string parts = 1;</code>
       *
       * @param value The bytes of the parts to add.
       * @return This builder for chaining.
       */
      public Builder addPartsBytes(com.google.protobuf.ByteString value) {
        if (value == null) {
          throw new NullPointerException();
        }
        checkByteStringIsUtf8(value);
        ensurePartsIsMutable();
        parts_.add(value);
        bitField0_ |= 0x00000001;
        onChanged();
        return this;
      }

      @java.lang.Override
      public final Builder setUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.setUnknownFields(unknownFields);
      }

      @java.lang.Override
      public final Builder mergeUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.mergeUnknownFields(unknownFields);
      }

      // @@protoc_insertion_point(builder_scope:google.cloud.aiplatform.v1beta1.FeatureViewDataKey.CompositeKey)
    }

    // @@protoc_insertion_point(class_scope:google.cloud.aiplatform.v1beta1.FeatureViewDataKey.CompositeKey)
    private static final com.google.cloud.aiplatform.v1beta1.FeatureViewDataKey.CompositeKey
        DEFAULT_INSTANCE;

    static {
      DEFAULT_INSTANCE = new com.google.cloud.aiplatform.v1beta1.FeatureViewDataKey.CompositeKey();
    }

    public static com.google.cloud.aiplatform.v1beta1.FeatureViewDataKey.CompositeKey
        getDefaultInstance() {
      return DEFAULT_INSTANCE;
    }

    private static final com.google.protobuf.Parser<CompositeKey> PARSER =
        new com.google.protobuf.AbstractParser<CompositeKey>() {
          @java.lang.Override
          public CompositeKey parsePartialFrom(
              com.google.protobuf.CodedInputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
            Builder builder = newBuilder();
            try {
              builder.mergeFrom(input, extensionRegistry);
            } catch (com.google.protobuf.InvalidProtocolBufferException e) {
              throw e.setUnfinishedMessage(builder.buildPartial());
            } catch (com.google.protobuf.UninitializedMessageException e) {
              throw e.asInvalidProtocolBufferException()
                  .setUnfinishedMessage(builder.buildPartial());
            } catch (java.io.IOException e) {
              throw new com.google.protobuf.InvalidProtocolBufferException(e)
                  .setUnfinishedMessage(builder.buildPartial());
            }
            return builder.buildPartial();
          }
        };

    public static com.google.protobuf.Parser<CompositeKey> parser() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.protobuf.Parser<CompositeKey> getParserForType() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.cloud.aiplatform.v1beta1.FeatureViewDataKey.CompositeKey
        getDefaultInstanceForType() {
      return DEFAULT_INSTANCE;
    }
  }

  private int keyOneofCase_ = 0;

  @SuppressWarnings("serial")
  private java.lang.Object keyOneof_;

  public enum KeyOneofCase
      implements
          com.google.protobuf.Internal.EnumLite,
          com.google.protobuf.AbstractMessage.InternalOneOfEnum {
    KEY(1),
    COMPOSITE_KEY(2),
    KEYONEOF_NOT_SET(0);
    private final int value;

    private KeyOneofCase(int value) {
      this.value = value;
    }
    /**
     * @param value The number of the enum to look for.
     * @return The enum associated with the given number.
     * @deprecated Use {@link #forNumber(int)} instead.
     */
    @java.lang.Deprecated
    public static KeyOneofCase valueOf(int value) {
      return forNumber(value);
    }

    public static KeyOneofCase forNumber(int value) {
      switch (value) {
        case 1:
          return KEY;
        case 2:
          return COMPOSITE_KEY;
        case 0:
          return KEYONEOF_NOT_SET;
        default:
          return null;
      }
    }

    public int getNumber() {
      return this.value;
    }
  };

  public KeyOneofCase getKeyOneofCase() {
    return KeyOneofCase.forNumber(keyOneofCase_);
  }

  public static final int KEY_FIELD_NUMBER = 1;
  /**
   *
   *
   * <pre>
   * String key to use for lookup.
   * </pre>
   *
   * <code>string key = 1;</code>
   *
   * @return Whether the key field is set.
   */
  public boolean hasKey() {
    return keyOneofCase_ == 1;
  }
  /**
   *
   *
   * <pre>
   * String key to use for lookup.
   * </pre>
   *
   * <code>string key = 1;</code>
   *
   * @return The key.
   */
  public java.lang.String getKey() {
    java.lang.Object ref = "";
    if (keyOneofCase_ == 1) {
      ref = keyOneof_;
    }
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      if (keyOneofCase_ == 1) {
        keyOneof_ = s;
      }
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * String key to use for lookup.
   * </pre>
   *
   * <code>string key = 1;</code>
   *
   * @return The bytes for key.
   */
  public com.google.protobuf.ByteString getKeyBytes() {
    java.lang.Object ref = "";
    if (keyOneofCase_ == 1) {
      ref = keyOneof_;
    }
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      if (keyOneofCase_ == 1) {
        keyOneof_ = b;
      }
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int COMPOSITE_KEY_FIELD_NUMBER = 2;
  /**
   *
   *
   * <pre>
   * The actual Entity ID will be composed from this struct. This should match
   * with the way ID is defined in the FeatureView spec.
   * </pre>
   *
   * <code>.google.cloud.aiplatform.v1beta1.FeatureViewDataKey.CompositeKey composite_key = 2;
   * </code>
   *
   * @return Whether the compositeKey field is set.
   */
  @java.lang.Override
  public boolean hasCompositeKey() {
    return keyOneofCase_ == 2;
  }
  /**
   *
   *
   * <pre>
   * The actual Entity ID will be composed from this struct. This should match
   * with the way ID is defined in the FeatureView spec.
   * </pre>
   *
   * <code>.google.cloud.aiplatform.v1beta1.FeatureViewDataKey.CompositeKey composite_key = 2;
   * </code>
   *
   * @return The compositeKey.
   */
  @java.lang.Override
  public com.google.cloud.aiplatform.v1beta1.FeatureViewDataKey.CompositeKey getCompositeKey() {
    if (keyOneofCase_ == 2) {
      return (com.google.cloud.aiplatform.v1beta1.FeatureViewDataKey.CompositeKey) keyOneof_;
    }
    return com.google.cloud.aiplatform.v1beta1.FeatureViewDataKey.CompositeKey.getDefaultInstance();
  }
  /**
   *
   *
   * <pre>
   * The actual Entity ID will be composed from this struct. This should match
   * with the way ID is defined in the FeatureView spec.
   * </pre>
   *
   * <code>.google.cloud.aiplatform.v1beta1.FeatureViewDataKey.CompositeKey composite_key = 2;
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.aiplatform.v1beta1.FeatureViewDataKey.CompositeKeyOrBuilder
      getCompositeKeyOrBuilder() {
    if (keyOneofCase_ == 2) {
      return (com.google.cloud.aiplatform.v1beta1.FeatureViewDataKey.CompositeKey) keyOneof_;
    }
    return com.google.cloud.aiplatform.v1beta1.FeatureViewDataKey.CompositeKey.getDefaultInstance();
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    if (keyOneofCase_ == 1) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 1, keyOneof_);
    }
    if (keyOneofCase_ == 2) {
      output.writeMessage(
          2, (com.google.cloud.aiplatform.v1beta1.FeatureViewDataKey.CompositeKey) keyOneof_);
    }
    getUnknownFields().writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    if (keyOneofCase_ == 1) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(1, keyOneof_);
    }
    if (keyOneofCase_ == 2) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(
              2, (com.google.cloud.aiplatform.v1beta1.FeatureViewDataKey.CompositeKey) keyOneof_);
    }
    size += getUnknownFields().getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.cloud.aiplatform.v1beta1.FeatureViewDataKey)) {
      return super.equals(obj);
    }
    com.google.cloud.aiplatform.v1beta1.FeatureViewDataKey other =
        (com.google.cloud.aiplatform.v1beta1.FeatureViewDataKey) obj;

    if (!getKeyOneofCase().equals(other.getKeyOneofCase())) return false;
    switch (keyOneofCase_) {
      case 1:
        if (!getKey().equals(other.getKey())) return false;
        break;
      case 2:
        if (!getCompositeKey().equals(other.getCompositeKey())) return false;
        break;
      case 0:
      default:
    }
    if (!getUnknownFields().equals(other.getUnknownFields())) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    switch (keyOneofCase_) {
      case 1:
        hash = (37 * hash) + KEY_FIELD_NUMBER;
        hash = (53 * hash) + getKey().hashCode();
        break;
      case 2:
        hash = (37 * hash) + COMPOSITE_KEY_FIELD_NUMBER;
        hash = (53 * hash) + getCompositeKey().hashCode();
        break;
      case 0:
      default:
    }
    hash = (29 * hash) + getUnknownFields().hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.cloud.aiplatform.v1beta1.FeatureViewDataKey parseFrom(
      java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.aiplatform.v1beta1.FeatureViewDataKey parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.aiplatform.v1beta1.FeatureViewDataKey parseFrom(
      com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.aiplatform.v1beta1.FeatureViewDataKey parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.aiplatform.v1beta1.FeatureViewDataKey parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.aiplatform.v1beta1.FeatureViewDataKey parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.aiplatform.v1beta1.FeatureViewDataKey parseFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.aiplatform.v1beta1.FeatureViewDataKey parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.aiplatform.v1beta1.FeatureViewDataKey parseDelimitedFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.cloud.aiplatform.v1beta1.FeatureViewDataKey parseDelimitedFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.aiplatform.v1beta1.FeatureViewDataKey parseFrom(
      com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.aiplatform.v1beta1.FeatureViewDataKey parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(
      com.google.cloud.aiplatform.v1beta1.FeatureViewDataKey prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }
  /**
   *
   *
   * <pre>
   * Lookup key for a feature view.
   * </pre>
   *
   * Protobuf type {@code google.cloud.aiplatform.v1beta1.FeatureViewDataKey}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.cloud.aiplatform.v1beta1.FeatureViewDataKey)
      com.google.cloud.aiplatform.v1beta1.FeatureViewDataKeyOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.aiplatform.v1beta1.FeatureOnlineStoreServiceProto
          .internal_static_google_cloud_aiplatform_v1beta1_FeatureViewDataKey_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.aiplatform.v1beta1.FeatureOnlineStoreServiceProto
          .internal_static_google_cloud_aiplatform_v1beta1_FeatureViewDataKey_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.aiplatform.v1beta1.FeatureViewDataKey.class,
              com.google.cloud.aiplatform.v1beta1.FeatureViewDataKey.Builder.class);
    }

    // Construct using com.google.cloud.aiplatform.v1beta1.FeatureViewDataKey.newBuilder()
    private Builder() {}

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      bitField0_ = 0;
      if (compositeKeyBuilder_ != null) {
        compositeKeyBuilder_.clear();
      }
      keyOneofCase_ = 0;
      keyOneof_ = null;
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.cloud.aiplatform.v1beta1.FeatureOnlineStoreServiceProto
          .internal_static_google_cloud_aiplatform_v1beta1_FeatureViewDataKey_descriptor;
    }

    @java.lang.Override
    public com.google.cloud.aiplatform.v1beta1.FeatureViewDataKey getDefaultInstanceForType() {
      return com.google.cloud.aiplatform.v1beta1.FeatureViewDataKey.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.cloud.aiplatform.v1beta1.FeatureViewDataKey build() {
      com.google.cloud.aiplatform.v1beta1.FeatureViewDataKey result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.cloud.aiplatform.v1beta1.FeatureViewDataKey buildPartial() {
      com.google.cloud.aiplatform.v1beta1.FeatureViewDataKey result =
          new com.google.cloud.aiplatform.v1beta1.FeatureViewDataKey(this);
      if (bitField0_ != 0) {
        buildPartial0(result);
      }
      buildPartialOneofs(result);
      onBuilt();
      return result;
    }

    private void buildPartial0(com.google.cloud.aiplatform.v1beta1.FeatureViewDataKey result) {
      int from_bitField0_ = bitField0_;
    }

    private void buildPartialOneofs(com.google.cloud.aiplatform.v1beta1.FeatureViewDataKey result) {
      result.keyOneofCase_ = keyOneofCase_;
      result.keyOneof_ = this.keyOneof_;
      if (keyOneofCase_ == 2 && compositeKeyBuilder_ != null) {
        result.keyOneof_ = compositeKeyBuilder_.build();
      }
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.cloud.aiplatform.v1beta1.FeatureViewDataKey) {
        return mergeFrom((com.google.cloud.aiplatform.v1beta1.FeatureViewDataKey) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(com.google.cloud.aiplatform.v1beta1.FeatureViewDataKey other) {
      if (other == com.google.cloud.aiplatform.v1beta1.FeatureViewDataKey.getDefaultInstance())
        return this;
      switch (other.getKeyOneofCase()) {
        case KEY:
          {
            keyOneofCase_ = 1;
            keyOneof_ = other.keyOneof_;
            onChanged();
            break;
          }
        case COMPOSITE_KEY:
          {
            mergeCompositeKey(other.getCompositeKey());
            break;
          }
        case KEYONEOF_NOT_SET:
          {
            break;
          }
      }
      this.mergeUnknownFields(other.getUnknownFields());
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 10:
              {
                java.lang.String s = input.readStringRequireUtf8();
                keyOneofCase_ = 1;
                keyOneof_ = s;
                break;
              } // case 10
            case 18:
              {
                input.readMessage(getCompositeKeyFieldBuilder().getBuilder(), extensionRegistry);
                keyOneofCase_ = 2;
                break;
              } // case 18
            default:
              {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
          } // switch (tag)
        } // while (!done)
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.unwrapIOException();
      } finally {
        onChanged();
      } // finally
      return this;
    }

    private int keyOneofCase_ = 0;
    private java.lang.Object keyOneof_;

    public KeyOneofCase getKeyOneofCase() {
      return KeyOneofCase.forNumber(keyOneofCase_);
    }

    public Builder clearKeyOneof() {
      keyOneofCase_ = 0;
      keyOneof_ = null;
      onChanged();
      return this;
    }

    private int bitField0_;

    /**
     *
     *
     * <pre>
     * String key to use for lookup.
     * </pre>
     *
     * <code>string key = 1;</code>
     *
     * @return Whether the key field is set.
     */
    @java.lang.Override
    public boolean hasKey() {
      return keyOneofCase_ == 1;
    }
    /**
     *
     *
     * <pre>
     * String key to use for lookup.
     * </pre>
     *
     * <code>string key = 1;</code>
     *
     * @return The key.
     */
    @java.lang.Override
    public java.lang.String getKey() {
      java.lang.Object ref = "";
      if (keyOneofCase_ == 1) {
        ref = keyOneof_;
      }
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        if (keyOneofCase_ == 1) {
          keyOneof_ = s;
        }
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * String key to use for lookup.
     * </pre>
     *
     * <code>string key = 1;</code>
     *
     * @return The bytes for key.
     */
    @java.lang.Override
    public com.google.protobuf.ByteString getKeyBytes() {
      java.lang.Object ref = "";
      if (keyOneofCase_ == 1) {
        ref = keyOneof_;
      }
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        if (keyOneofCase_ == 1) {
          keyOneof_ = b;
        }
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * String key to use for lookup.
     * </pre>
     *
     * <code>string key = 1;</code>
     *
     * @param value The key to set.
     * @return This builder for chaining.
     */
    public Builder setKey(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      keyOneofCase_ = 1;
      keyOneof_ = value;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * String key to use for lookup.
     * </pre>
     *
     * <code>string key = 1;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearKey() {
      if (keyOneofCase_ == 1) {
        keyOneofCase_ = 0;
        keyOneof_ = null;
        onChanged();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * String key to use for lookup.
     * </pre>
     *
     * <code>string key = 1;</code>
     *
     * @param value The bytes for key to set.
     * @return This builder for chaining.
     */
    public Builder setKeyBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      keyOneofCase_ = 1;
      keyOneof_ = value;
      onChanged();
      return this;
    }

    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.aiplatform.v1beta1.FeatureViewDataKey.CompositeKey,
            com.google.cloud.aiplatform.v1beta1.FeatureViewDataKey.CompositeKey.Builder,
            com.google.cloud.aiplatform.v1beta1.FeatureViewDataKey.CompositeKeyOrBuilder>
        compositeKeyBuilder_;
    /**
     *
     *
     * <pre>
     * The actual Entity ID will be composed from this struct. This should match
     * with the way ID is defined in the FeatureView spec.
     * </pre>
     *
     * <code>.google.cloud.aiplatform.v1beta1.FeatureViewDataKey.CompositeKey composite_key = 2;
     * </code>
     *
     * @return Whether the compositeKey field is set.
     */
    @java.lang.Override
    public boolean hasCompositeKey() {
      return keyOneofCase_ == 2;
    }
    /**
     *
     *
     * <pre>
     * The actual Entity ID will be composed from this struct. This should match
     * with the way ID is defined in the FeatureView spec.
     * </pre>
     *
     * <code>.google.cloud.aiplatform.v1beta1.FeatureViewDataKey.CompositeKey composite_key = 2;
     * </code>
     *
     * @return The compositeKey.
     */
    @java.lang.Override
    public com.google.cloud.aiplatform.v1beta1.FeatureViewDataKey.CompositeKey getCompositeKey() {
      if (compositeKeyBuilder_ == null) {
        if (keyOneofCase_ == 2) {
          return (com.google.cloud.aiplatform.v1beta1.FeatureViewDataKey.CompositeKey) keyOneof_;
        }
        return com.google.cloud.aiplatform.v1beta1.FeatureViewDataKey.CompositeKey
            .getDefaultInstance();
      } else {
        if (keyOneofCase_ == 2) {
          return compositeKeyBuilder_.getMessage();
        }
        return com.google.cloud.aiplatform.v1beta1.FeatureViewDataKey.CompositeKey
            .getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * The actual Entity ID will be composed from this struct. This should match
     * with the way ID is defined in the FeatureView spec.
     * </pre>
     *
     * <code>.google.cloud.aiplatform.v1beta1.FeatureViewDataKey.CompositeKey composite_key = 2;
     * </code>
     */
    public Builder setCompositeKey(
        com.google.cloud.aiplatform.v1beta1.FeatureViewDataKey.CompositeKey value) {
      if (compositeKeyBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        keyOneof_ = value;
        onChanged();
      } else {
        compositeKeyBuilder_.setMessage(value);
      }
      keyOneofCase_ = 2;
      return this;
    }
    /**
     *
     *
     * <pre>
     * The actual Entity ID will be composed from this struct. This should match
     * with the way ID is defined in the FeatureView spec.
     * </pre>
     *
     * <code>.google.cloud.aiplatform.v1beta1.FeatureViewDataKey.CompositeKey composite_key = 2;
     * </code>
     */
    public Builder setCompositeKey(
        com.google.cloud.aiplatform.v1beta1.FeatureViewDataKey.CompositeKey.Builder
            builderForValue) {
      if (compositeKeyBuilder_ == null) {
        keyOneof_ = builderForValue.build();
        onChanged();
      } else {
        compositeKeyBuilder_.setMessage(builderForValue.build());
      }
      keyOneofCase_ = 2;
      return this;
    }
    /**
     *
     *
     * <pre>
     * The actual Entity ID will be composed from this struct. This should match
     * with the way ID is defined in the FeatureView spec.
     * </pre>
     *
     * <code>.google.cloud.aiplatform.v1beta1.FeatureViewDataKey.CompositeKey composite_key = 2;
     * </code>
     */
    public Builder mergeCompositeKey(
        com.google.cloud.aiplatform.v1beta1.FeatureViewDataKey.CompositeKey value) {
      if (compositeKeyBuilder_ == null) {
        if (keyOneofCase_ == 2
            && keyOneof_
                != com.google.cloud.aiplatform.v1beta1.FeatureViewDataKey.CompositeKey
                    .getDefaultInstance()) {
          keyOneof_ =
              com.google.cloud.aiplatform.v1beta1.FeatureViewDataKey.CompositeKey.newBuilder(
                      (com.google.cloud.aiplatform.v1beta1.FeatureViewDataKey.CompositeKey)
                          keyOneof_)
                  .mergeFrom(value)
                  .buildPartial();
        } else {
          keyOneof_ = value;
        }
        onChanged();
      } else {
        if (keyOneofCase_ == 2) {
          compositeKeyBuilder_.mergeFrom(value);
        } else {
          compositeKeyBuilder_.setMessage(value);
        }
      }
      keyOneofCase_ = 2;
      return this;
    }
    /**
     *
     *
     * <pre>
     * The actual Entity ID will be composed from this struct. This should match
     * with the way ID is defined in the FeatureView spec.
     * </pre>
     *
     * <code>.google.cloud.aiplatform.v1beta1.FeatureViewDataKey.CompositeKey composite_key = 2;
     * </code>
     */
    public Builder clearCompositeKey() {
      if (compositeKeyBuilder_ == null) {
        if (keyOneofCase_ == 2) {
          keyOneofCase_ = 0;
          keyOneof_ = null;
          onChanged();
        }
      } else {
        if (keyOneofCase_ == 2) {
          keyOneofCase_ = 0;
          keyOneof_ = null;
        }
        compositeKeyBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * The actual Entity ID will be composed from this struct. This should match
     * with the way ID is defined in the FeatureView spec.
     * </pre>
     *
     * <code>.google.cloud.aiplatform.v1beta1.FeatureViewDataKey.CompositeKey composite_key = 2;
     * </code>
     */
    public com.google.cloud.aiplatform.v1beta1.FeatureViewDataKey.CompositeKey.Builder
        getCompositeKeyBuilder() {
      return getCompositeKeyFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * The actual Entity ID will be composed from this struct. This should match
     * with the way ID is defined in the FeatureView spec.
     * </pre>
     *
     * <code>.google.cloud.aiplatform.v1beta1.FeatureViewDataKey.CompositeKey composite_key = 2;
     * </code>
     */
    @java.lang.Override
    public com.google.cloud.aiplatform.v1beta1.FeatureViewDataKey.CompositeKeyOrBuilder
        getCompositeKeyOrBuilder() {
      if ((keyOneofCase_ == 2) && (compositeKeyBuilder_ != null)) {
        return compositeKeyBuilder_.getMessageOrBuilder();
      } else {
        if (keyOneofCase_ == 2) {
          return (com.google.cloud.aiplatform.v1beta1.FeatureViewDataKey.CompositeKey) keyOneof_;
        }
        return com.google.cloud.aiplatform.v1beta1.FeatureViewDataKey.CompositeKey
            .getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * The actual Entity ID will be composed from this struct. This should match
     * with the way ID is defined in the FeatureView spec.
     * </pre>
     *
     * <code>.google.cloud.aiplatform.v1beta1.FeatureViewDataKey.CompositeKey composite_key = 2;
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.aiplatform.v1beta1.FeatureViewDataKey.CompositeKey,
            com.google.cloud.aiplatform.v1beta1.FeatureViewDataKey.CompositeKey.Builder,
            com.google.cloud.aiplatform.v1beta1.FeatureViewDataKey.CompositeKeyOrBuilder>
        getCompositeKeyFieldBuilder() {
      if (compositeKeyBuilder_ == null) {
        if (!(keyOneofCase_ == 2)) {
          keyOneof_ =
              com.google.cloud.aiplatform.v1beta1.FeatureViewDataKey.CompositeKey
                  .getDefaultInstance();
        }
        compositeKeyBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.aiplatform.v1beta1.FeatureViewDataKey.CompositeKey,
                com.google.cloud.aiplatform.v1beta1.FeatureViewDataKey.CompositeKey.Builder,
                com.google.cloud.aiplatform.v1beta1.FeatureViewDataKey.CompositeKeyOrBuilder>(
                (com.google.cloud.aiplatform.v1beta1.FeatureViewDataKey.CompositeKey) keyOneof_,
                getParentForChildren(),
                isClean());
        keyOneof_ = null;
      }
      keyOneofCase_ = 2;
      onChanged();
      return compositeKeyBuilder_;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.cloud.aiplatform.v1beta1.FeatureViewDataKey)
  }

  // @@protoc_insertion_point(class_scope:google.cloud.aiplatform.v1beta1.FeatureViewDataKey)
  private static final com.google.cloud.aiplatform.v1beta1.FeatureViewDataKey DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.cloud.aiplatform.v1beta1.FeatureViewDataKey();
  }

  public static com.google.cloud.aiplatform.v1beta1.FeatureViewDataKey getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<FeatureViewDataKey> PARSER =
      new com.google.protobuf.AbstractParser<FeatureViewDataKey>() {
        @java.lang.Override
        public FeatureViewDataKey parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          Builder builder = newBuilder();
          try {
            builder.mergeFrom(input, extensionRegistry);
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.setUnfinishedMessage(builder.buildPartial());
          } catch (com.google.protobuf.UninitializedMessageException e) {
            throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
          } catch (java.io.IOException e) {
            throw new com.google.protobuf.InvalidProtocolBufferException(e)
                .setUnfinishedMessage(builder.buildPartial());
          }
          return builder.buildPartial();
        }
      };

  public static com.google.protobuf.Parser<FeatureViewDataKey> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<FeatureViewDataKey> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.cloud.aiplatform.v1beta1.FeatureViewDataKey getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
