/*
 * Copyright 2024 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/cloud/aiplatform/v1beta1/model_monitoring_stats.proto

// Protobuf Java Version: 3.25.5
package com.google.cloud.aiplatform.v1beta1;

/**
 *
 *
 * <pre>
 * A collection of data points that describes the time-varying values of a
 * tabular metric.
 * </pre>
 *
 * Protobuf type {@code google.cloud.aiplatform.v1beta1.ModelMonitoringTabularStats}
 */
public final class ModelMonitoringTabularStats extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.cloud.aiplatform.v1beta1.ModelMonitoringTabularStats)
    ModelMonitoringTabularStatsOrBuilder {
  private static final long serialVersionUID = 0L;
  // Use ModelMonitoringTabularStats.newBuilder() to construct.
  private ModelMonitoringTabularStats(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private ModelMonitoringTabularStats() {
    statsName_ = "";
    objectiveType_ = "";
    dataPoints_ = java.util.Collections.emptyList();
  }

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new ModelMonitoringTabularStats();
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.cloud.aiplatform.v1beta1.ModelMonitoringStatsProto
        .internal_static_google_cloud_aiplatform_v1beta1_ModelMonitoringTabularStats_descriptor;
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.cloud.aiplatform.v1beta1.ModelMonitoringStatsProto
        .internal_static_google_cloud_aiplatform_v1beta1_ModelMonitoringTabularStats_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.cloud.aiplatform.v1beta1.ModelMonitoringTabularStats.class,
            com.google.cloud.aiplatform.v1beta1.ModelMonitoringTabularStats.Builder.class);
  }

  public static final int STATS_NAME_FIELD_NUMBER = 1;

  @SuppressWarnings("serial")
  private volatile java.lang.Object statsName_ = "";
  /**
   *
   *
   * <pre>
   * The stats name.
   * </pre>
   *
   * <code>string stats_name = 1;</code>
   *
   * @return The statsName.
   */
  @java.lang.Override
  public java.lang.String getStatsName() {
    java.lang.Object ref = statsName_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      statsName_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * The stats name.
   * </pre>
   *
   * <code>string stats_name = 1;</code>
   *
   * @return The bytes for statsName.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getStatsNameBytes() {
    java.lang.Object ref = statsName_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      statsName_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int OBJECTIVE_TYPE_FIELD_NUMBER = 2;

  @SuppressWarnings("serial")
  private volatile java.lang.Object objectiveType_ = "";
  /**
   *
   *
   * <pre>
   * One of the supported monitoring objectives:
   * `raw-feature-drift`
   * `prediction-output-drift`
   * `feature-attribution`
   * </pre>
   *
   * <code>string objective_type = 2;</code>
   *
   * @return The objectiveType.
   */
  @java.lang.Override
  public java.lang.String getObjectiveType() {
    java.lang.Object ref = objectiveType_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      objectiveType_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * One of the supported monitoring objectives:
   * `raw-feature-drift`
   * `prediction-output-drift`
   * `feature-attribution`
   * </pre>
   *
   * <code>string objective_type = 2;</code>
   *
   * @return The bytes for objectiveType.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getObjectiveTypeBytes() {
    java.lang.Object ref = objectiveType_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      objectiveType_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int DATA_POINTS_FIELD_NUMBER = 3;

  @SuppressWarnings("serial")
  private java.util.List<com.google.cloud.aiplatform.v1beta1.ModelMonitoringStatsDataPoint>
      dataPoints_;
  /**
   *
   *
   * <pre>
   * The data points of this time series. When listing time series, points are
   * returned in reverse time order.
   * </pre>
   *
   * <code>repeated .google.cloud.aiplatform.v1beta1.ModelMonitoringStatsDataPoint data_points = 3;
   * </code>
   */
  @java.lang.Override
  public java.util.List<com.google.cloud.aiplatform.v1beta1.ModelMonitoringStatsDataPoint>
      getDataPointsList() {
    return dataPoints_;
  }
  /**
   *
   *
   * <pre>
   * The data points of this time series. When listing time series, points are
   * returned in reverse time order.
   * </pre>
   *
   * <code>repeated .google.cloud.aiplatform.v1beta1.ModelMonitoringStatsDataPoint data_points = 3;
   * </code>
   */
  @java.lang.Override
  public java.util.List<
          ? extends com.google.cloud.aiplatform.v1beta1.ModelMonitoringStatsDataPointOrBuilder>
      getDataPointsOrBuilderList() {
    return dataPoints_;
  }
  /**
   *
   *
   * <pre>
   * The data points of this time series. When listing time series, points are
   * returned in reverse time order.
   * </pre>
   *
   * <code>repeated .google.cloud.aiplatform.v1beta1.ModelMonitoringStatsDataPoint data_points = 3;
   * </code>
   */
  @java.lang.Override
  public int getDataPointsCount() {
    return dataPoints_.size();
  }
  /**
   *
   *
   * <pre>
   * The data points of this time series. When listing time series, points are
   * returned in reverse time order.
   * </pre>
   *
   * <code>repeated .google.cloud.aiplatform.v1beta1.ModelMonitoringStatsDataPoint data_points = 3;
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.aiplatform.v1beta1.ModelMonitoringStatsDataPoint getDataPoints(
      int index) {
    return dataPoints_.get(index);
  }
  /**
   *
   *
   * <pre>
   * The data points of this time series. When listing time series, points are
   * returned in reverse time order.
   * </pre>
   *
   * <code>repeated .google.cloud.aiplatform.v1beta1.ModelMonitoringStatsDataPoint data_points = 3;
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.aiplatform.v1beta1.ModelMonitoringStatsDataPointOrBuilder
      getDataPointsOrBuilder(int index) {
    return dataPoints_.get(index);
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(statsName_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 1, statsName_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(objectiveType_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 2, objectiveType_);
    }
    for (int i = 0; i < dataPoints_.size(); i++) {
      output.writeMessage(3, dataPoints_.get(i));
    }
    getUnknownFields().writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(statsName_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(1, statsName_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(objectiveType_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(2, objectiveType_);
    }
    for (int i = 0; i < dataPoints_.size(); i++) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(3, dataPoints_.get(i));
    }
    size += getUnknownFields().getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.cloud.aiplatform.v1beta1.ModelMonitoringTabularStats)) {
      return super.equals(obj);
    }
    com.google.cloud.aiplatform.v1beta1.ModelMonitoringTabularStats other =
        (com.google.cloud.aiplatform.v1beta1.ModelMonitoringTabularStats) obj;

    if (!getStatsName().equals(other.getStatsName())) return false;
    if (!getObjectiveType().equals(other.getObjectiveType())) return false;
    if (!getDataPointsList().equals(other.getDataPointsList())) return false;
    if (!getUnknownFields().equals(other.getUnknownFields())) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    hash = (37 * hash) + STATS_NAME_FIELD_NUMBER;
    hash = (53 * hash) + getStatsName().hashCode();
    hash = (37 * hash) + OBJECTIVE_TYPE_FIELD_NUMBER;
    hash = (53 * hash) + getObjectiveType().hashCode();
    if (getDataPointsCount() > 0) {
      hash = (37 * hash) + DATA_POINTS_FIELD_NUMBER;
      hash = (53 * hash) + getDataPointsList().hashCode();
    }
    hash = (29 * hash) + getUnknownFields().hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.cloud.aiplatform.v1beta1.ModelMonitoringTabularStats parseFrom(
      java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.aiplatform.v1beta1.ModelMonitoringTabularStats parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.aiplatform.v1beta1.ModelMonitoringTabularStats parseFrom(
      com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.aiplatform.v1beta1.ModelMonitoringTabularStats parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.aiplatform.v1beta1.ModelMonitoringTabularStats parseFrom(
      byte[] data) throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.aiplatform.v1beta1.ModelMonitoringTabularStats parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.aiplatform.v1beta1.ModelMonitoringTabularStats parseFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.aiplatform.v1beta1.ModelMonitoringTabularStats parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.aiplatform.v1beta1.ModelMonitoringTabularStats parseDelimitedFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.cloud.aiplatform.v1beta1.ModelMonitoringTabularStats parseDelimitedFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.aiplatform.v1beta1.ModelMonitoringTabularStats parseFrom(
      com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.aiplatform.v1beta1.ModelMonitoringTabularStats parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(
      com.google.cloud.aiplatform.v1beta1.ModelMonitoringTabularStats prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }
  /**
   *
   *
   * <pre>
   * A collection of data points that describes the time-varying values of a
   * tabular metric.
   * </pre>
   *
   * Protobuf type {@code google.cloud.aiplatform.v1beta1.ModelMonitoringTabularStats}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.cloud.aiplatform.v1beta1.ModelMonitoringTabularStats)
      com.google.cloud.aiplatform.v1beta1.ModelMonitoringTabularStatsOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.aiplatform.v1beta1.ModelMonitoringStatsProto
          .internal_static_google_cloud_aiplatform_v1beta1_ModelMonitoringTabularStats_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.aiplatform.v1beta1.ModelMonitoringStatsProto
          .internal_static_google_cloud_aiplatform_v1beta1_ModelMonitoringTabularStats_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.aiplatform.v1beta1.ModelMonitoringTabularStats.class,
              com.google.cloud.aiplatform.v1beta1.ModelMonitoringTabularStats.Builder.class);
    }

    // Construct using com.google.cloud.aiplatform.v1beta1.ModelMonitoringTabularStats.newBuilder()
    private Builder() {}

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      bitField0_ = 0;
      statsName_ = "";
      objectiveType_ = "";
      if (dataPointsBuilder_ == null) {
        dataPoints_ = java.util.Collections.emptyList();
      } else {
        dataPoints_ = null;
        dataPointsBuilder_.clear();
      }
      bitField0_ = (bitField0_ & ~0x00000004);
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.cloud.aiplatform.v1beta1.ModelMonitoringStatsProto
          .internal_static_google_cloud_aiplatform_v1beta1_ModelMonitoringTabularStats_descriptor;
    }

    @java.lang.Override
    public com.google.cloud.aiplatform.v1beta1.ModelMonitoringTabularStats
        getDefaultInstanceForType() {
      return com.google.cloud.aiplatform.v1beta1.ModelMonitoringTabularStats.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.cloud.aiplatform.v1beta1.ModelMonitoringTabularStats build() {
      com.google.cloud.aiplatform.v1beta1.ModelMonitoringTabularStats result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.cloud.aiplatform.v1beta1.ModelMonitoringTabularStats buildPartial() {
      com.google.cloud.aiplatform.v1beta1.ModelMonitoringTabularStats result =
          new com.google.cloud.aiplatform.v1beta1.ModelMonitoringTabularStats(this);
      buildPartialRepeatedFields(result);
      if (bitField0_ != 0) {
        buildPartial0(result);
      }
      onBuilt();
      return result;
    }

    private void buildPartialRepeatedFields(
        com.google.cloud.aiplatform.v1beta1.ModelMonitoringTabularStats result) {
      if (dataPointsBuilder_ == null) {
        if (((bitField0_ & 0x00000004) != 0)) {
          dataPoints_ = java.util.Collections.unmodifiableList(dataPoints_);
          bitField0_ = (bitField0_ & ~0x00000004);
        }
        result.dataPoints_ = dataPoints_;
      } else {
        result.dataPoints_ = dataPointsBuilder_.build();
      }
    }

    private void buildPartial0(
        com.google.cloud.aiplatform.v1beta1.ModelMonitoringTabularStats result) {
      int from_bitField0_ = bitField0_;
      if (((from_bitField0_ & 0x00000001) != 0)) {
        result.statsName_ = statsName_;
      }
      if (((from_bitField0_ & 0x00000002) != 0)) {
        result.objectiveType_ = objectiveType_;
      }
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.cloud.aiplatform.v1beta1.ModelMonitoringTabularStats) {
        return mergeFrom((com.google.cloud.aiplatform.v1beta1.ModelMonitoringTabularStats) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(
        com.google.cloud.aiplatform.v1beta1.ModelMonitoringTabularStats other) {
      if (other
          == com.google.cloud.aiplatform.v1beta1.ModelMonitoringTabularStats.getDefaultInstance())
        return this;
      if (!other.getStatsName().isEmpty()) {
        statsName_ = other.statsName_;
        bitField0_ |= 0x00000001;
        onChanged();
      }
      if (!other.getObjectiveType().isEmpty()) {
        objectiveType_ = other.objectiveType_;
        bitField0_ |= 0x00000002;
        onChanged();
      }
      if (dataPointsBuilder_ == null) {
        if (!other.dataPoints_.isEmpty()) {
          if (dataPoints_.isEmpty()) {
            dataPoints_ = other.dataPoints_;
            bitField0_ = (bitField0_ & ~0x00000004);
          } else {
            ensureDataPointsIsMutable();
            dataPoints_.addAll(other.dataPoints_);
          }
          onChanged();
        }
      } else {
        if (!other.dataPoints_.isEmpty()) {
          if (dataPointsBuilder_.isEmpty()) {
            dataPointsBuilder_.dispose();
            dataPointsBuilder_ = null;
            dataPoints_ = other.dataPoints_;
            bitField0_ = (bitField0_ & ~0x00000004);
            dataPointsBuilder_ =
                com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders
                    ? getDataPointsFieldBuilder()
                    : null;
          } else {
            dataPointsBuilder_.addAllMessages(other.dataPoints_);
          }
        }
      }
      this.mergeUnknownFields(other.getUnknownFields());
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 10:
              {
                statsName_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000001;
                break;
              } // case 10
            case 18:
              {
                objectiveType_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000002;
                break;
              } // case 18
            case 26:
              {
                com.google.cloud.aiplatform.v1beta1.ModelMonitoringStatsDataPoint m =
                    input.readMessage(
                        com.google.cloud.aiplatform.v1beta1.ModelMonitoringStatsDataPoint.parser(),
                        extensionRegistry);
                if (dataPointsBuilder_ == null) {
                  ensureDataPointsIsMutable();
                  dataPoints_.add(m);
                } else {
                  dataPointsBuilder_.addMessage(m);
                }
                break;
              } // case 26
            default:
              {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
          } // switch (tag)
        } // while (!done)
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.unwrapIOException();
      } finally {
        onChanged();
      } // finally
      return this;
    }

    private int bitField0_;

    private java.lang.Object statsName_ = "";
    /**
     *
     *
     * <pre>
     * The stats name.
     * </pre>
     *
     * <code>string stats_name = 1;</code>
     *
     * @return The statsName.
     */
    public java.lang.String getStatsName() {
      java.lang.Object ref = statsName_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        statsName_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * The stats name.
     * </pre>
     *
     * <code>string stats_name = 1;</code>
     *
     * @return The bytes for statsName.
     */
    public com.google.protobuf.ByteString getStatsNameBytes() {
      java.lang.Object ref = statsName_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        statsName_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * The stats name.
     * </pre>
     *
     * <code>string stats_name = 1;</code>
     *
     * @param value The statsName to set.
     * @return This builder for chaining.
     */
    public Builder setStatsName(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      statsName_ = value;
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The stats name.
     * </pre>
     *
     * <code>string stats_name = 1;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearStatsName() {
      statsName_ = getDefaultInstance().getStatsName();
      bitField0_ = (bitField0_ & ~0x00000001);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The stats name.
     * </pre>
     *
     * <code>string stats_name = 1;</code>
     *
     * @param value The bytes for statsName to set.
     * @return This builder for chaining.
     */
    public Builder setStatsNameBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      statsName_ = value;
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }

    private java.lang.Object objectiveType_ = "";
    /**
     *
     *
     * <pre>
     * One of the supported monitoring objectives:
     * `raw-feature-drift`
     * `prediction-output-drift`
     * `feature-attribution`
     * </pre>
     *
     * <code>string objective_type = 2;</code>
     *
     * @return The objectiveType.
     */
    public java.lang.String getObjectiveType() {
      java.lang.Object ref = objectiveType_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        objectiveType_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * One of the supported monitoring objectives:
     * `raw-feature-drift`
     * `prediction-output-drift`
     * `feature-attribution`
     * </pre>
     *
     * <code>string objective_type = 2;</code>
     *
     * @return The bytes for objectiveType.
     */
    public com.google.protobuf.ByteString getObjectiveTypeBytes() {
      java.lang.Object ref = objectiveType_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        objectiveType_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * One of the supported monitoring objectives:
     * `raw-feature-drift`
     * `prediction-output-drift`
     * `feature-attribution`
     * </pre>
     *
     * <code>string objective_type = 2;</code>
     *
     * @param value The objectiveType to set.
     * @return This builder for chaining.
     */
    public Builder setObjectiveType(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      objectiveType_ = value;
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * One of the supported monitoring objectives:
     * `raw-feature-drift`
     * `prediction-output-drift`
     * `feature-attribution`
     * </pre>
     *
     * <code>string objective_type = 2;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearObjectiveType() {
      objectiveType_ = getDefaultInstance().getObjectiveType();
      bitField0_ = (bitField0_ & ~0x00000002);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * One of the supported monitoring objectives:
     * `raw-feature-drift`
     * `prediction-output-drift`
     * `feature-attribution`
     * </pre>
     *
     * <code>string objective_type = 2;</code>
     *
     * @param value The bytes for objectiveType to set.
     * @return This builder for chaining.
     */
    public Builder setObjectiveTypeBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      objectiveType_ = value;
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }

    private java.util.List<com.google.cloud.aiplatform.v1beta1.ModelMonitoringStatsDataPoint>
        dataPoints_ = java.util.Collections.emptyList();

    private void ensureDataPointsIsMutable() {
      if (!((bitField0_ & 0x00000004) != 0)) {
        dataPoints_ =
            new java.util.ArrayList<
                com.google.cloud.aiplatform.v1beta1.ModelMonitoringStatsDataPoint>(dataPoints_);
        bitField0_ |= 0x00000004;
      }
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.cloud.aiplatform.v1beta1.ModelMonitoringStatsDataPoint,
            com.google.cloud.aiplatform.v1beta1.ModelMonitoringStatsDataPoint.Builder,
            com.google.cloud.aiplatform.v1beta1.ModelMonitoringStatsDataPointOrBuilder>
        dataPointsBuilder_;

    /**
     *
     *
     * <pre>
     * The data points of this time series. When listing time series, points are
     * returned in reverse time order.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.aiplatform.v1beta1.ModelMonitoringStatsDataPoint data_points = 3;
     * </code>
     */
    public java.util.List<com.google.cloud.aiplatform.v1beta1.ModelMonitoringStatsDataPoint>
        getDataPointsList() {
      if (dataPointsBuilder_ == null) {
        return java.util.Collections.unmodifiableList(dataPoints_);
      } else {
        return dataPointsBuilder_.getMessageList();
      }
    }
    /**
     *
     *
     * <pre>
     * The data points of this time series. When listing time series, points are
     * returned in reverse time order.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.aiplatform.v1beta1.ModelMonitoringStatsDataPoint data_points = 3;
     * </code>
     */
    public int getDataPointsCount() {
      if (dataPointsBuilder_ == null) {
        return dataPoints_.size();
      } else {
        return dataPointsBuilder_.getCount();
      }
    }
    /**
     *
     *
     * <pre>
     * The data points of this time series. When listing time series, points are
     * returned in reverse time order.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.aiplatform.v1beta1.ModelMonitoringStatsDataPoint data_points = 3;
     * </code>
     */
    public com.google.cloud.aiplatform.v1beta1.ModelMonitoringStatsDataPoint getDataPoints(
        int index) {
      if (dataPointsBuilder_ == null) {
        return dataPoints_.get(index);
      } else {
        return dataPointsBuilder_.getMessage(index);
      }
    }
    /**
     *
     *
     * <pre>
     * The data points of this time series. When listing time series, points are
     * returned in reverse time order.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.aiplatform.v1beta1.ModelMonitoringStatsDataPoint data_points = 3;
     * </code>
     */
    public Builder setDataPoints(
        int index, com.google.cloud.aiplatform.v1beta1.ModelMonitoringStatsDataPoint value) {
      if (dataPointsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureDataPointsIsMutable();
        dataPoints_.set(index, value);
        onChanged();
      } else {
        dataPointsBuilder_.setMessage(index, value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * The data points of this time series. When listing time series, points are
     * returned in reverse time order.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.aiplatform.v1beta1.ModelMonitoringStatsDataPoint data_points = 3;
     * </code>
     */
    public Builder setDataPoints(
        int index,
        com.google.cloud.aiplatform.v1beta1.ModelMonitoringStatsDataPoint.Builder builderForValue) {
      if (dataPointsBuilder_ == null) {
        ensureDataPointsIsMutable();
        dataPoints_.set(index, builderForValue.build());
        onChanged();
      } else {
        dataPointsBuilder_.setMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * The data points of this time series. When listing time series, points are
     * returned in reverse time order.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.aiplatform.v1beta1.ModelMonitoringStatsDataPoint data_points = 3;
     * </code>
     */
    public Builder addDataPoints(
        com.google.cloud.aiplatform.v1beta1.ModelMonitoringStatsDataPoint value) {
      if (dataPointsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureDataPointsIsMutable();
        dataPoints_.add(value);
        onChanged();
      } else {
        dataPointsBuilder_.addMessage(value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * The data points of this time series. When listing time series, points are
     * returned in reverse time order.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.aiplatform.v1beta1.ModelMonitoringStatsDataPoint data_points = 3;
     * </code>
     */
    public Builder addDataPoints(
        int index, com.google.cloud.aiplatform.v1beta1.ModelMonitoringStatsDataPoint value) {
      if (dataPointsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureDataPointsIsMutable();
        dataPoints_.add(index, value);
        onChanged();
      } else {
        dataPointsBuilder_.addMessage(index, value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * The data points of this time series. When listing time series, points are
     * returned in reverse time order.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.aiplatform.v1beta1.ModelMonitoringStatsDataPoint data_points = 3;
     * </code>
     */
    public Builder addDataPoints(
        com.google.cloud.aiplatform.v1beta1.ModelMonitoringStatsDataPoint.Builder builderForValue) {
      if (dataPointsBuilder_ == null) {
        ensureDataPointsIsMutable();
        dataPoints_.add(builderForValue.build());
        onChanged();
      } else {
        dataPointsBuilder_.addMessage(builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * The data points of this time series. When listing time series, points are
     * returned in reverse time order.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.aiplatform.v1beta1.ModelMonitoringStatsDataPoint data_points = 3;
     * </code>
     */
    public Builder addDataPoints(
        int index,
        com.google.cloud.aiplatform.v1beta1.ModelMonitoringStatsDataPoint.Builder builderForValue) {
      if (dataPointsBuilder_ == null) {
        ensureDataPointsIsMutable();
        dataPoints_.add(index, builderForValue.build());
        onChanged();
      } else {
        dataPointsBuilder_.addMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * The data points of this time series. When listing time series, points are
     * returned in reverse time order.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.aiplatform.v1beta1.ModelMonitoringStatsDataPoint data_points = 3;
     * </code>
     */
    public Builder addAllDataPoints(
        java.lang.Iterable<
                ? extends com.google.cloud.aiplatform.v1beta1.ModelMonitoringStatsDataPoint>
            values) {
      if (dataPointsBuilder_ == null) {
        ensureDataPointsIsMutable();
        com.google.protobuf.AbstractMessageLite.Builder.addAll(values, dataPoints_);
        onChanged();
      } else {
        dataPointsBuilder_.addAllMessages(values);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * The data points of this time series. When listing time series, points are
     * returned in reverse time order.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.aiplatform.v1beta1.ModelMonitoringStatsDataPoint data_points = 3;
     * </code>
     */
    public Builder clearDataPoints() {
      if (dataPointsBuilder_ == null) {
        dataPoints_ = java.util.Collections.emptyList();
        bitField0_ = (bitField0_ & ~0x00000004);
        onChanged();
      } else {
        dataPointsBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * The data points of this time series. When listing time series, points are
     * returned in reverse time order.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.aiplatform.v1beta1.ModelMonitoringStatsDataPoint data_points = 3;
     * </code>
     */
    public Builder removeDataPoints(int index) {
      if (dataPointsBuilder_ == null) {
        ensureDataPointsIsMutable();
        dataPoints_.remove(index);
        onChanged();
      } else {
        dataPointsBuilder_.remove(index);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * The data points of this time series. When listing time series, points are
     * returned in reverse time order.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.aiplatform.v1beta1.ModelMonitoringStatsDataPoint data_points = 3;
     * </code>
     */
    public com.google.cloud.aiplatform.v1beta1.ModelMonitoringStatsDataPoint.Builder
        getDataPointsBuilder(int index) {
      return getDataPointsFieldBuilder().getBuilder(index);
    }
    /**
     *
     *
     * <pre>
     * The data points of this time series. When listing time series, points are
     * returned in reverse time order.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.aiplatform.v1beta1.ModelMonitoringStatsDataPoint data_points = 3;
     * </code>
     */
    public com.google.cloud.aiplatform.v1beta1.ModelMonitoringStatsDataPointOrBuilder
        getDataPointsOrBuilder(int index) {
      if (dataPointsBuilder_ == null) {
        return dataPoints_.get(index);
      } else {
        return dataPointsBuilder_.getMessageOrBuilder(index);
      }
    }
    /**
     *
     *
     * <pre>
     * The data points of this time series. When listing time series, points are
     * returned in reverse time order.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.aiplatform.v1beta1.ModelMonitoringStatsDataPoint data_points = 3;
     * </code>
     */
    public java.util.List<
            ? extends com.google.cloud.aiplatform.v1beta1.ModelMonitoringStatsDataPointOrBuilder>
        getDataPointsOrBuilderList() {
      if (dataPointsBuilder_ != null) {
        return dataPointsBuilder_.getMessageOrBuilderList();
      } else {
        return java.util.Collections.unmodifiableList(dataPoints_);
      }
    }
    /**
     *
     *
     * <pre>
     * The data points of this time series. When listing time series, points are
     * returned in reverse time order.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.aiplatform.v1beta1.ModelMonitoringStatsDataPoint data_points = 3;
     * </code>
     */
    public com.google.cloud.aiplatform.v1beta1.ModelMonitoringStatsDataPoint.Builder
        addDataPointsBuilder() {
      return getDataPointsFieldBuilder()
          .addBuilder(
              com.google.cloud.aiplatform.v1beta1.ModelMonitoringStatsDataPoint
                  .getDefaultInstance());
    }
    /**
     *
     *
     * <pre>
     * The data points of this time series. When listing time series, points are
     * returned in reverse time order.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.aiplatform.v1beta1.ModelMonitoringStatsDataPoint data_points = 3;
     * </code>
     */
    public com.google.cloud.aiplatform.v1beta1.ModelMonitoringStatsDataPoint.Builder
        addDataPointsBuilder(int index) {
      return getDataPointsFieldBuilder()
          .addBuilder(
              index,
              com.google.cloud.aiplatform.v1beta1.ModelMonitoringStatsDataPoint
                  .getDefaultInstance());
    }
    /**
     *
     *
     * <pre>
     * The data points of this time series. When listing time series, points are
     * returned in reverse time order.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.aiplatform.v1beta1.ModelMonitoringStatsDataPoint data_points = 3;
     * </code>
     */
    public java.util.List<com.google.cloud.aiplatform.v1beta1.ModelMonitoringStatsDataPoint.Builder>
        getDataPointsBuilderList() {
      return getDataPointsFieldBuilder().getBuilderList();
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.cloud.aiplatform.v1beta1.ModelMonitoringStatsDataPoint,
            com.google.cloud.aiplatform.v1beta1.ModelMonitoringStatsDataPoint.Builder,
            com.google.cloud.aiplatform.v1beta1.ModelMonitoringStatsDataPointOrBuilder>
        getDataPointsFieldBuilder() {
      if (dataPointsBuilder_ == null) {
        dataPointsBuilder_ =
            new com.google.protobuf.RepeatedFieldBuilderV3<
                com.google.cloud.aiplatform.v1beta1.ModelMonitoringStatsDataPoint,
                com.google.cloud.aiplatform.v1beta1.ModelMonitoringStatsDataPoint.Builder,
                com.google.cloud.aiplatform.v1beta1.ModelMonitoringStatsDataPointOrBuilder>(
                dataPoints_, ((bitField0_ & 0x00000004) != 0), getParentForChildren(), isClean());
        dataPoints_ = null;
      }
      return dataPointsBuilder_;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.cloud.aiplatform.v1beta1.ModelMonitoringTabularStats)
  }

  // @@protoc_insertion_point(class_scope:google.cloud.aiplatform.v1beta1.ModelMonitoringTabularStats)
  private static final com.google.cloud.aiplatform.v1beta1.ModelMonitoringTabularStats
      DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.cloud.aiplatform.v1beta1.ModelMonitoringTabularStats();
  }

  public static com.google.cloud.aiplatform.v1beta1.ModelMonitoringTabularStats
      getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<ModelMonitoringTabularStats> PARSER =
      new com.google.protobuf.AbstractParser<ModelMonitoringTabularStats>() {
        @java.lang.Override
        public ModelMonitoringTabularStats parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          Builder builder = newBuilder();
          try {
            builder.mergeFrom(input, extensionRegistry);
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.setUnfinishedMessage(builder.buildPartial());
          } catch (com.google.protobuf.UninitializedMessageException e) {
            throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
          } catch (java.io.IOException e) {
            throw new com.google.protobuf.InvalidProtocolBufferException(e)
                .setUnfinishedMessage(builder.buildPartial());
          }
          return builder.buildPartial();
        }
      };

  public static com.google.protobuf.Parser<ModelMonitoringTabularStats> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<ModelMonitoringTabularStats> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.cloud.aiplatform.v1beta1.ModelMonitoringTabularStats
      getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
