/*
 * Copyright 2024 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/cloud/aiplatform/v1beta1/notebook_execution_job.proto

// Protobuf Java Version: 3.25.5
package com.google.cloud.aiplatform.v1beta1;

/**
 *
 *
 * <pre>
 * NotebookExecutionJob represents an instance of a notebook execution.
 * </pre>
 *
 * Protobuf type {@code google.cloud.aiplatform.v1beta1.NotebookExecutionJob}
 */
public final class NotebookExecutionJob extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.cloud.aiplatform.v1beta1.NotebookExecutionJob)
    NotebookExecutionJobOrBuilder {
  private static final long serialVersionUID = 0L;
  // Use NotebookExecutionJob.newBuilder() to construct.
  private NotebookExecutionJob(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private NotebookExecutionJob() {
    name_ = "";
    displayName_ = "";
    scheduleResourceName_ = "";
    jobState_ = 0;
  }

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new NotebookExecutionJob();
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.cloud.aiplatform.v1beta1.NotebookExecutionJobProto
        .internal_static_google_cloud_aiplatform_v1beta1_NotebookExecutionJob_descriptor;
  }

  @SuppressWarnings({"rawtypes"})
  @java.lang.Override
  protected com.google.protobuf.MapFieldReflectionAccessor internalGetMapFieldReflection(
      int number) {
    switch (number) {
      case 19:
        return internalGetLabels();
      default:
        throw new RuntimeException("Invalid map field number: " + number);
    }
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.cloud.aiplatform.v1beta1.NotebookExecutionJobProto
        .internal_static_google_cloud_aiplatform_v1beta1_NotebookExecutionJob_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.cloud.aiplatform.v1beta1.NotebookExecutionJob.class,
            com.google.cloud.aiplatform.v1beta1.NotebookExecutionJob.Builder.class);
  }

  public interface DataformRepositorySourceOrBuilder
      extends
      // @@protoc_insertion_point(interface_extends:google.cloud.aiplatform.v1beta1.NotebookExecutionJob.DataformRepositorySource)
      com.google.protobuf.MessageOrBuilder {

    /**
     *
     *
     * <pre>
     * The resource name of the Dataform Repository. Format:
     * `projects/{project_id}/locations/{location}/repositories/{repository_id}`
     * </pre>
     *
     * <code>string dataform_repository_resource_name = 1;</code>
     *
     * @return The dataformRepositoryResourceName.
     */
    java.lang.String getDataformRepositoryResourceName();
    /**
     *
     *
     * <pre>
     * The resource name of the Dataform Repository. Format:
     * `projects/{project_id}/locations/{location}/repositories/{repository_id}`
     * </pre>
     *
     * <code>string dataform_repository_resource_name = 1;</code>
     *
     * @return The bytes for dataformRepositoryResourceName.
     */
    com.google.protobuf.ByteString getDataformRepositoryResourceNameBytes();

    /**
     *
     *
     * <pre>
     * The commit SHA to read repository with. If unset, the file will be read
     * at HEAD.
     * </pre>
     *
     * <code>string commit_sha = 2;</code>
     *
     * @return The commitSha.
     */
    java.lang.String getCommitSha();
    /**
     *
     *
     * <pre>
     * The commit SHA to read repository with. If unset, the file will be read
     * at HEAD.
     * </pre>
     *
     * <code>string commit_sha = 2;</code>
     *
     * @return The bytes for commitSha.
     */
    com.google.protobuf.ByteString getCommitShaBytes();
  }
  /**
   *
   *
   * <pre>
   * The Dataform Repository containing the input notebook.
   * </pre>
   *
   * Protobuf type {@code
   * google.cloud.aiplatform.v1beta1.NotebookExecutionJob.DataformRepositorySource}
   */
  public static final class DataformRepositorySource extends com.google.protobuf.GeneratedMessageV3
      implements
      // @@protoc_insertion_point(message_implements:google.cloud.aiplatform.v1beta1.NotebookExecutionJob.DataformRepositorySource)
      DataformRepositorySourceOrBuilder {
    private static final long serialVersionUID = 0L;
    // Use DataformRepositorySource.newBuilder() to construct.
    private DataformRepositorySource(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
      super(builder);
    }

    private DataformRepositorySource() {
      dataformRepositoryResourceName_ = "";
      commitSha_ = "";
    }

    @java.lang.Override
    @SuppressWarnings({"unused"})
    protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
      return new DataformRepositorySource();
    }

    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.aiplatform.v1beta1.NotebookExecutionJobProto
          .internal_static_google_cloud_aiplatform_v1beta1_NotebookExecutionJob_DataformRepositorySource_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.aiplatform.v1beta1.NotebookExecutionJobProto
          .internal_static_google_cloud_aiplatform_v1beta1_NotebookExecutionJob_DataformRepositorySource_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.aiplatform.v1beta1.NotebookExecutionJob.DataformRepositorySource
                  .class,
              com.google.cloud.aiplatform.v1beta1.NotebookExecutionJob.DataformRepositorySource
                  .Builder.class);
    }

    public static final int DATAFORM_REPOSITORY_RESOURCE_NAME_FIELD_NUMBER = 1;

    @SuppressWarnings("serial")
    private volatile java.lang.Object dataformRepositoryResourceName_ = "";
    /**
     *
     *
     * <pre>
     * The resource name of the Dataform Repository. Format:
     * `projects/{project_id}/locations/{location}/repositories/{repository_id}`
     * </pre>
     *
     * <code>string dataform_repository_resource_name = 1;</code>
     *
     * @return The dataformRepositoryResourceName.
     */
    @java.lang.Override
    public java.lang.String getDataformRepositoryResourceName() {
      java.lang.Object ref = dataformRepositoryResourceName_;
      if (ref instanceof java.lang.String) {
        return (java.lang.String) ref;
      } else {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        dataformRepositoryResourceName_ = s;
        return s;
      }
    }
    /**
     *
     *
     * <pre>
     * The resource name of the Dataform Repository. Format:
     * `projects/{project_id}/locations/{location}/repositories/{repository_id}`
     * </pre>
     *
     * <code>string dataform_repository_resource_name = 1;</code>
     *
     * @return The bytes for dataformRepositoryResourceName.
     */
    @java.lang.Override
    public com.google.protobuf.ByteString getDataformRepositoryResourceNameBytes() {
      java.lang.Object ref = dataformRepositoryResourceName_;
      if (ref instanceof java.lang.String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        dataformRepositoryResourceName_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    public static final int COMMIT_SHA_FIELD_NUMBER = 2;

    @SuppressWarnings("serial")
    private volatile java.lang.Object commitSha_ = "";
    /**
     *
     *
     * <pre>
     * The commit SHA to read repository with. If unset, the file will be read
     * at HEAD.
     * </pre>
     *
     * <code>string commit_sha = 2;</code>
     *
     * @return The commitSha.
     */
    @java.lang.Override
    public java.lang.String getCommitSha() {
      java.lang.Object ref = commitSha_;
      if (ref instanceof java.lang.String) {
        return (java.lang.String) ref;
      } else {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        commitSha_ = s;
        return s;
      }
    }
    /**
     *
     *
     * <pre>
     * The commit SHA to read repository with. If unset, the file will be read
     * at HEAD.
     * </pre>
     *
     * <code>string commit_sha = 2;</code>
     *
     * @return The bytes for commitSha.
     */
    @java.lang.Override
    public com.google.protobuf.ByteString getCommitShaBytes() {
      java.lang.Object ref = commitSha_;
      if (ref instanceof java.lang.String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        commitSha_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    private byte memoizedIsInitialized = -1;

    @java.lang.Override
    public final boolean isInitialized() {
      byte isInitialized = memoizedIsInitialized;
      if (isInitialized == 1) return true;
      if (isInitialized == 0) return false;

      memoizedIsInitialized = 1;
      return true;
    }

    @java.lang.Override
    public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(dataformRepositoryResourceName_)) {
        com.google.protobuf.GeneratedMessageV3.writeString(
            output, 1, dataformRepositoryResourceName_);
      }
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(commitSha_)) {
        com.google.protobuf.GeneratedMessageV3.writeString(output, 2, commitSha_);
      }
      getUnknownFields().writeTo(output);
    }

    @java.lang.Override
    public int getSerializedSize() {
      int size = memoizedSize;
      if (size != -1) return size;

      size = 0;
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(dataformRepositoryResourceName_)) {
        size +=
            com.google.protobuf.GeneratedMessageV3.computeStringSize(
                1, dataformRepositoryResourceName_);
      }
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(commitSha_)) {
        size += com.google.protobuf.GeneratedMessageV3.computeStringSize(2, commitSha_);
      }
      size += getUnknownFields().getSerializedSize();
      memoizedSize = size;
      return size;
    }

    @java.lang.Override
    public boolean equals(final java.lang.Object obj) {
      if (obj == this) {
        return true;
      }
      if (!(obj
          instanceof
          com.google.cloud.aiplatform.v1beta1.NotebookExecutionJob.DataformRepositorySource)) {
        return super.equals(obj);
      }
      com.google.cloud.aiplatform.v1beta1.NotebookExecutionJob.DataformRepositorySource other =
          (com.google.cloud.aiplatform.v1beta1.NotebookExecutionJob.DataformRepositorySource) obj;

      if (!getDataformRepositoryResourceName().equals(other.getDataformRepositoryResourceName()))
        return false;
      if (!getCommitSha().equals(other.getCommitSha())) return false;
      if (!getUnknownFields().equals(other.getUnknownFields())) return false;
      return true;
    }

    @java.lang.Override
    public int hashCode() {
      if (memoizedHashCode != 0) {
        return memoizedHashCode;
      }
      int hash = 41;
      hash = (19 * hash) + getDescriptor().hashCode();
      hash = (37 * hash) + DATAFORM_REPOSITORY_RESOURCE_NAME_FIELD_NUMBER;
      hash = (53 * hash) + getDataformRepositoryResourceName().hashCode();
      hash = (37 * hash) + COMMIT_SHA_FIELD_NUMBER;
      hash = (53 * hash) + getCommitSha().hashCode();
      hash = (29 * hash) + getUnknownFields().hashCode();
      memoizedHashCode = hash;
      return hash;
    }

    public static com.google.cloud.aiplatform.v1beta1.NotebookExecutionJob.DataformRepositorySource
        parseFrom(java.nio.ByteBuffer data)
            throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.aiplatform.v1beta1.NotebookExecutionJob.DataformRepositorySource
        parseFrom(
            java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.aiplatform.v1beta1.NotebookExecutionJob.DataformRepositorySource
        parseFrom(com.google.protobuf.ByteString data)
            throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.aiplatform.v1beta1.NotebookExecutionJob.DataformRepositorySource
        parseFrom(
            com.google.protobuf.ByteString data,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.aiplatform.v1beta1.NotebookExecutionJob.DataformRepositorySource
        parseFrom(byte[] data) throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.aiplatform.v1beta1.NotebookExecutionJob.DataformRepositorySource
        parseFrom(byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.aiplatform.v1beta1.NotebookExecutionJob.DataformRepositorySource
        parseFrom(java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.cloud.aiplatform.v1beta1.NotebookExecutionJob.DataformRepositorySource
        parseFrom(
            java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.cloud.aiplatform.v1beta1.NotebookExecutionJob.DataformRepositorySource
        parseDelimitedFrom(java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
    }

    public static com.google.cloud.aiplatform.v1beta1.NotebookExecutionJob.DataformRepositorySource
        parseDelimitedFrom(
            java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.cloud.aiplatform.v1beta1.NotebookExecutionJob.DataformRepositorySource
        parseFrom(com.google.protobuf.CodedInputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.cloud.aiplatform.v1beta1.NotebookExecutionJob.DataformRepositorySource
        parseFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    @java.lang.Override
    public Builder newBuilderForType() {
      return newBuilder();
    }

    public static Builder newBuilder() {
      return DEFAULT_INSTANCE.toBuilder();
    }

    public static Builder newBuilder(
        com.google.cloud.aiplatform.v1beta1.NotebookExecutionJob.DataformRepositorySource
            prototype) {
      return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }

    @java.lang.Override
    public Builder toBuilder() {
      return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
    }

    @java.lang.Override
    protected Builder newBuilderForType(
        com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      Builder builder = new Builder(parent);
      return builder;
    }
    /**
     *
     *
     * <pre>
     * The Dataform Repository containing the input notebook.
     * </pre>
     *
     * Protobuf type {@code
     * google.cloud.aiplatform.v1beta1.NotebookExecutionJob.DataformRepositorySource}
     */
    public static final class Builder
        extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
        implements
        // @@protoc_insertion_point(builder_implements:google.cloud.aiplatform.v1beta1.NotebookExecutionJob.DataformRepositorySource)
        com.google.cloud.aiplatform.v1beta1.NotebookExecutionJob.DataformRepositorySourceOrBuilder {
      public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
        return com.google.cloud.aiplatform.v1beta1.NotebookExecutionJobProto
            .internal_static_google_cloud_aiplatform_v1beta1_NotebookExecutionJob_DataformRepositorySource_descriptor;
      }

      @java.lang.Override
      protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return com.google.cloud.aiplatform.v1beta1.NotebookExecutionJobProto
            .internal_static_google_cloud_aiplatform_v1beta1_NotebookExecutionJob_DataformRepositorySource_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                com.google.cloud.aiplatform.v1beta1.NotebookExecutionJob.DataformRepositorySource
                    .class,
                com.google.cloud.aiplatform.v1beta1.NotebookExecutionJob.DataformRepositorySource
                    .Builder.class);
      }

      // Construct using
      // com.google.cloud.aiplatform.v1beta1.NotebookExecutionJob.DataformRepositorySource.newBuilder()
      private Builder() {}

      private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
        super(parent);
      }

      @java.lang.Override
      public Builder clear() {
        super.clear();
        bitField0_ = 0;
        dataformRepositoryResourceName_ = "";
        commitSha_ = "";
        return this;
      }

      @java.lang.Override
      public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
        return com.google.cloud.aiplatform.v1beta1.NotebookExecutionJobProto
            .internal_static_google_cloud_aiplatform_v1beta1_NotebookExecutionJob_DataformRepositorySource_descriptor;
      }

      @java.lang.Override
      public com.google.cloud.aiplatform.v1beta1.NotebookExecutionJob.DataformRepositorySource
          getDefaultInstanceForType() {
        return com.google.cloud.aiplatform.v1beta1.NotebookExecutionJob.DataformRepositorySource
            .getDefaultInstance();
      }

      @java.lang.Override
      public com.google.cloud.aiplatform.v1beta1.NotebookExecutionJob.DataformRepositorySource
          build() {
        com.google.cloud.aiplatform.v1beta1.NotebookExecutionJob.DataformRepositorySource result =
            buildPartial();
        if (!result.isInitialized()) {
          throw newUninitializedMessageException(result);
        }
        return result;
      }

      @java.lang.Override
      public com.google.cloud.aiplatform.v1beta1.NotebookExecutionJob.DataformRepositorySource
          buildPartial() {
        com.google.cloud.aiplatform.v1beta1.NotebookExecutionJob.DataformRepositorySource result =
            new com.google.cloud.aiplatform.v1beta1.NotebookExecutionJob.DataformRepositorySource(
                this);
        if (bitField0_ != 0) {
          buildPartial0(result);
        }
        onBuilt();
        return result;
      }

      private void buildPartial0(
          com.google.cloud.aiplatform.v1beta1.NotebookExecutionJob.DataformRepositorySource
              result) {
        int from_bitField0_ = bitField0_;
        if (((from_bitField0_ & 0x00000001) != 0)) {
          result.dataformRepositoryResourceName_ = dataformRepositoryResourceName_;
        }
        if (((from_bitField0_ & 0x00000002) != 0)) {
          result.commitSha_ = commitSha_;
        }
      }

      @java.lang.Override
      public Builder clone() {
        return super.clone();
      }

      @java.lang.Override
      public Builder setField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.setField(field, value);
      }

      @java.lang.Override
      public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
        return super.clearField(field);
      }

      @java.lang.Override
      public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
        return super.clearOneof(oneof);
      }

      @java.lang.Override
      public Builder setRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          int index,
          java.lang.Object value) {
        return super.setRepeatedField(field, index, value);
      }

      @java.lang.Override
      public Builder addRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.addRepeatedField(field, value);
      }

      @java.lang.Override
      public Builder mergeFrom(com.google.protobuf.Message other) {
        if (other
            instanceof
            com.google.cloud.aiplatform.v1beta1.NotebookExecutionJob.DataformRepositorySource) {
          return mergeFrom(
              (com.google.cloud.aiplatform.v1beta1.NotebookExecutionJob.DataformRepositorySource)
                  other);
        } else {
          super.mergeFrom(other);
          return this;
        }
      }

      public Builder mergeFrom(
          com.google.cloud.aiplatform.v1beta1.NotebookExecutionJob.DataformRepositorySource other) {
        if (other
            == com.google.cloud.aiplatform.v1beta1.NotebookExecutionJob.DataformRepositorySource
                .getDefaultInstance()) return this;
        if (!other.getDataformRepositoryResourceName().isEmpty()) {
          dataformRepositoryResourceName_ = other.dataformRepositoryResourceName_;
          bitField0_ |= 0x00000001;
          onChanged();
        }
        if (!other.getCommitSha().isEmpty()) {
          commitSha_ = other.commitSha_;
          bitField0_ |= 0x00000002;
          onChanged();
        }
        this.mergeUnknownFields(other.getUnknownFields());
        onChanged();
        return this;
      }

      @java.lang.Override
      public final boolean isInitialized() {
        return true;
      }

      @java.lang.Override
      public Builder mergeFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        if (extensionRegistry == null) {
          throw new java.lang.NullPointerException();
        }
        try {
          boolean done = false;
          while (!done) {
            int tag = input.readTag();
            switch (tag) {
              case 0:
                done = true;
                break;
              case 10:
                {
                  dataformRepositoryResourceName_ = input.readStringRequireUtf8();
                  bitField0_ |= 0x00000001;
                  break;
                } // case 10
              case 18:
                {
                  commitSha_ = input.readStringRequireUtf8();
                  bitField0_ |= 0x00000002;
                  break;
                } // case 18
              default:
                {
                  if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                    done = true; // was an endgroup tag
                  }
                  break;
                } // default:
            } // switch (tag)
          } // while (!done)
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          throw e.unwrapIOException();
        } finally {
          onChanged();
        } // finally
        return this;
      }

      private int bitField0_;

      private java.lang.Object dataformRepositoryResourceName_ = "";
      /**
       *
       *
       * <pre>
       * The resource name of the Dataform Repository. Format:
       * `projects/{project_id}/locations/{location}/repositories/{repository_id}`
       * </pre>
       *
       * <code>string dataform_repository_resource_name = 1;</code>
       *
       * @return The dataformRepositoryResourceName.
       */
      public java.lang.String getDataformRepositoryResourceName() {
        java.lang.Object ref = dataformRepositoryResourceName_;
        if (!(ref instanceof java.lang.String)) {
          com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
          java.lang.String s = bs.toStringUtf8();
          dataformRepositoryResourceName_ = s;
          return s;
        } else {
          return (java.lang.String) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * The resource name of the Dataform Repository. Format:
       * `projects/{project_id}/locations/{location}/repositories/{repository_id}`
       * </pre>
       *
       * <code>string dataform_repository_resource_name = 1;</code>
       *
       * @return The bytes for dataformRepositoryResourceName.
       */
      public com.google.protobuf.ByteString getDataformRepositoryResourceNameBytes() {
        java.lang.Object ref = dataformRepositoryResourceName_;
        if (ref instanceof String) {
          com.google.protobuf.ByteString b =
              com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
          dataformRepositoryResourceName_ = b;
          return b;
        } else {
          return (com.google.protobuf.ByteString) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * The resource name of the Dataform Repository. Format:
       * `projects/{project_id}/locations/{location}/repositories/{repository_id}`
       * </pre>
       *
       * <code>string dataform_repository_resource_name = 1;</code>
       *
       * @param value The dataformRepositoryResourceName to set.
       * @return This builder for chaining.
       */
      public Builder setDataformRepositoryResourceName(java.lang.String value) {
        if (value == null) {
          throw new NullPointerException();
        }
        dataformRepositoryResourceName_ = value;
        bitField0_ |= 0x00000001;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * The resource name of the Dataform Repository. Format:
       * `projects/{project_id}/locations/{location}/repositories/{repository_id}`
       * </pre>
       *
       * <code>string dataform_repository_resource_name = 1;</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearDataformRepositoryResourceName() {
        dataformRepositoryResourceName_ = getDefaultInstance().getDataformRepositoryResourceName();
        bitField0_ = (bitField0_ & ~0x00000001);
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * The resource name of the Dataform Repository. Format:
       * `projects/{project_id}/locations/{location}/repositories/{repository_id}`
       * </pre>
       *
       * <code>string dataform_repository_resource_name = 1;</code>
       *
       * @param value The bytes for dataformRepositoryResourceName to set.
       * @return This builder for chaining.
       */
      public Builder setDataformRepositoryResourceNameBytes(com.google.protobuf.ByteString value) {
        if (value == null) {
          throw new NullPointerException();
        }
        checkByteStringIsUtf8(value);
        dataformRepositoryResourceName_ = value;
        bitField0_ |= 0x00000001;
        onChanged();
        return this;
      }

      private java.lang.Object commitSha_ = "";
      /**
       *
       *
       * <pre>
       * The commit SHA to read repository with. If unset, the file will be read
       * at HEAD.
       * </pre>
       *
       * <code>string commit_sha = 2;</code>
       *
       * @return The commitSha.
       */
      public java.lang.String getCommitSha() {
        java.lang.Object ref = commitSha_;
        if (!(ref instanceof java.lang.String)) {
          com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
          java.lang.String s = bs.toStringUtf8();
          commitSha_ = s;
          return s;
        } else {
          return (java.lang.String) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * The commit SHA to read repository with. If unset, the file will be read
       * at HEAD.
       * </pre>
       *
       * <code>string commit_sha = 2;</code>
       *
       * @return The bytes for commitSha.
       */
      public com.google.protobuf.ByteString getCommitShaBytes() {
        java.lang.Object ref = commitSha_;
        if (ref instanceof String) {
          com.google.protobuf.ByteString b =
              com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
          commitSha_ = b;
          return b;
        } else {
          return (com.google.protobuf.ByteString) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * The commit SHA to read repository with. If unset, the file will be read
       * at HEAD.
       * </pre>
       *
       * <code>string commit_sha = 2;</code>
       *
       * @param value The commitSha to set.
       * @return This builder for chaining.
       */
      public Builder setCommitSha(java.lang.String value) {
        if (value == null) {
          throw new NullPointerException();
        }
        commitSha_ = value;
        bitField0_ |= 0x00000002;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * The commit SHA to read repository with. If unset, the file will be read
       * at HEAD.
       * </pre>
       *
       * <code>string commit_sha = 2;</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearCommitSha() {
        commitSha_ = getDefaultInstance().getCommitSha();
        bitField0_ = (bitField0_ & ~0x00000002);
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * The commit SHA to read repository with. If unset, the file will be read
       * at HEAD.
       * </pre>
       *
       * <code>string commit_sha = 2;</code>
       *
       * @param value The bytes for commitSha to set.
       * @return This builder for chaining.
       */
      public Builder setCommitShaBytes(com.google.protobuf.ByteString value) {
        if (value == null) {
          throw new NullPointerException();
        }
        checkByteStringIsUtf8(value);
        commitSha_ = value;
        bitField0_ |= 0x00000002;
        onChanged();
        return this;
      }

      @java.lang.Override
      public final Builder setUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.setUnknownFields(unknownFields);
      }

      @java.lang.Override
      public final Builder mergeUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.mergeUnknownFields(unknownFields);
      }

      // @@protoc_insertion_point(builder_scope:google.cloud.aiplatform.v1beta1.NotebookExecutionJob.DataformRepositorySource)
    }

    // @@protoc_insertion_point(class_scope:google.cloud.aiplatform.v1beta1.NotebookExecutionJob.DataformRepositorySource)
    private static final com.google.cloud.aiplatform.v1beta1.NotebookExecutionJob
            .DataformRepositorySource
        DEFAULT_INSTANCE;

    static {
      DEFAULT_INSTANCE =
          new com.google.cloud.aiplatform.v1beta1.NotebookExecutionJob.DataformRepositorySource();
    }

    public static com.google.cloud.aiplatform.v1beta1.NotebookExecutionJob.DataformRepositorySource
        getDefaultInstance() {
      return DEFAULT_INSTANCE;
    }

    private static final com.google.protobuf.Parser<DataformRepositorySource> PARSER =
        new com.google.protobuf.AbstractParser<DataformRepositorySource>() {
          @java.lang.Override
          public DataformRepositorySource parsePartialFrom(
              com.google.protobuf.CodedInputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
            Builder builder = newBuilder();
            try {
              builder.mergeFrom(input, extensionRegistry);
            } catch (com.google.protobuf.InvalidProtocolBufferException e) {
              throw e.setUnfinishedMessage(builder.buildPartial());
            } catch (com.google.protobuf.UninitializedMessageException e) {
              throw e.asInvalidProtocolBufferException()
                  .setUnfinishedMessage(builder.buildPartial());
            } catch (java.io.IOException e) {
              throw new com.google.protobuf.InvalidProtocolBufferException(e)
                  .setUnfinishedMessage(builder.buildPartial());
            }
            return builder.buildPartial();
          }
        };

    public static com.google.protobuf.Parser<DataformRepositorySource> parser() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.protobuf.Parser<DataformRepositorySource> getParserForType() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.cloud.aiplatform.v1beta1.NotebookExecutionJob.DataformRepositorySource
        getDefaultInstanceForType() {
      return DEFAULT_INSTANCE;
    }
  }

  public interface GcsNotebookSourceOrBuilder
      extends
      // @@protoc_insertion_point(interface_extends:google.cloud.aiplatform.v1beta1.NotebookExecutionJob.GcsNotebookSource)
      com.google.protobuf.MessageOrBuilder {

    /**
     *
     *
     * <pre>
     * The Cloud Storage uri pointing to the ipynb file. Format:
     * `gs://bucket/notebook_file.ipynb`
     * </pre>
     *
     * <code>string uri = 1;</code>
     *
     * @return The uri.
     */
    java.lang.String getUri();
    /**
     *
     *
     * <pre>
     * The Cloud Storage uri pointing to the ipynb file. Format:
     * `gs://bucket/notebook_file.ipynb`
     * </pre>
     *
     * <code>string uri = 1;</code>
     *
     * @return The bytes for uri.
     */
    com.google.protobuf.ByteString getUriBytes();

    /**
     *
     *
     * <pre>
     * The version of the Cloud Storage object to read. If unset, the current
     * version of the object is read. See
     * https://cloud.google.com/storage/docs/metadata#generation-number.
     * </pre>
     *
     * <code>string generation = 2;</code>
     *
     * @return The generation.
     */
    java.lang.String getGeneration();
    /**
     *
     *
     * <pre>
     * The version of the Cloud Storage object to read. If unset, the current
     * version of the object is read. See
     * https://cloud.google.com/storage/docs/metadata#generation-number.
     * </pre>
     *
     * <code>string generation = 2;</code>
     *
     * @return The bytes for generation.
     */
    com.google.protobuf.ByteString getGenerationBytes();
  }
  /**
   *
   *
   * <pre>
   * The Cloud Storage uri for the input notebook.
   * </pre>
   *
   * Protobuf type {@code google.cloud.aiplatform.v1beta1.NotebookExecutionJob.GcsNotebookSource}
   */
  public static final class GcsNotebookSource extends com.google.protobuf.GeneratedMessageV3
      implements
      // @@protoc_insertion_point(message_implements:google.cloud.aiplatform.v1beta1.NotebookExecutionJob.GcsNotebookSource)
      GcsNotebookSourceOrBuilder {
    private static final long serialVersionUID = 0L;
    // Use GcsNotebookSource.newBuilder() to construct.
    private GcsNotebookSource(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
      super(builder);
    }

    private GcsNotebookSource() {
      uri_ = "";
      generation_ = "";
    }

    @java.lang.Override
    @SuppressWarnings({"unused"})
    protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
      return new GcsNotebookSource();
    }

    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.aiplatform.v1beta1.NotebookExecutionJobProto
          .internal_static_google_cloud_aiplatform_v1beta1_NotebookExecutionJob_GcsNotebookSource_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.aiplatform.v1beta1.NotebookExecutionJobProto
          .internal_static_google_cloud_aiplatform_v1beta1_NotebookExecutionJob_GcsNotebookSource_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.aiplatform.v1beta1.NotebookExecutionJob.GcsNotebookSource.class,
              com.google.cloud.aiplatform.v1beta1.NotebookExecutionJob.GcsNotebookSource.Builder
                  .class);
    }

    public static final int URI_FIELD_NUMBER = 1;

    @SuppressWarnings("serial")
    private volatile java.lang.Object uri_ = "";
    /**
     *
     *
     * <pre>
     * The Cloud Storage uri pointing to the ipynb file. Format:
     * `gs://bucket/notebook_file.ipynb`
     * </pre>
     *
     * <code>string uri = 1;</code>
     *
     * @return The uri.
     */
    @java.lang.Override
    public java.lang.String getUri() {
      java.lang.Object ref = uri_;
      if (ref instanceof java.lang.String) {
        return (java.lang.String) ref;
      } else {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        uri_ = s;
        return s;
      }
    }
    /**
     *
     *
     * <pre>
     * The Cloud Storage uri pointing to the ipynb file. Format:
     * `gs://bucket/notebook_file.ipynb`
     * </pre>
     *
     * <code>string uri = 1;</code>
     *
     * @return The bytes for uri.
     */
    @java.lang.Override
    public com.google.protobuf.ByteString getUriBytes() {
      java.lang.Object ref = uri_;
      if (ref instanceof java.lang.String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        uri_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    public static final int GENERATION_FIELD_NUMBER = 2;

    @SuppressWarnings("serial")
    private volatile java.lang.Object generation_ = "";
    /**
     *
     *
     * <pre>
     * The version of the Cloud Storage object to read. If unset, the current
     * version of the object is read. See
     * https://cloud.google.com/storage/docs/metadata#generation-number.
     * </pre>
     *
     * <code>string generation = 2;</code>
     *
     * @return The generation.
     */
    @java.lang.Override
    public java.lang.String getGeneration() {
      java.lang.Object ref = generation_;
      if (ref instanceof java.lang.String) {
        return (java.lang.String) ref;
      } else {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        generation_ = s;
        return s;
      }
    }
    /**
     *
     *
     * <pre>
     * The version of the Cloud Storage object to read. If unset, the current
     * version of the object is read. See
     * https://cloud.google.com/storage/docs/metadata#generation-number.
     * </pre>
     *
     * <code>string generation = 2;</code>
     *
     * @return The bytes for generation.
     */
    @java.lang.Override
    public com.google.protobuf.ByteString getGenerationBytes() {
      java.lang.Object ref = generation_;
      if (ref instanceof java.lang.String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        generation_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    private byte memoizedIsInitialized = -1;

    @java.lang.Override
    public final boolean isInitialized() {
      byte isInitialized = memoizedIsInitialized;
      if (isInitialized == 1) return true;
      if (isInitialized == 0) return false;

      memoizedIsInitialized = 1;
      return true;
    }

    @java.lang.Override
    public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(uri_)) {
        com.google.protobuf.GeneratedMessageV3.writeString(output, 1, uri_);
      }
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(generation_)) {
        com.google.protobuf.GeneratedMessageV3.writeString(output, 2, generation_);
      }
      getUnknownFields().writeTo(output);
    }

    @java.lang.Override
    public int getSerializedSize() {
      int size = memoizedSize;
      if (size != -1) return size;

      size = 0;
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(uri_)) {
        size += com.google.protobuf.GeneratedMessageV3.computeStringSize(1, uri_);
      }
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(generation_)) {
        size += com.google.protobuf.GeneratedMessageV3.computeStringSize(2, generation_);
      }
      size += getUnknownFields().getSerializedSize();
      memoizedSize = size;
      return size;
    }

    @java.lang.Override
    public boolean equals(final java.lang.Object obj) {
      if (obj == this) {
        return true;
      }
      if (!(obj
          instanceof com.google.cloud.aiplatform.v1beta1.NotebookExecutionJob.GcsNotebookSource)) {
        return super.equals(obj);
      }
      com.google.cloud.aiplatform.v1beta1.NotebookExecutionJob.GcsNotebookSource other =
          (com.google.cloud.aiplatform.v1beta1.NotebookExecutionJob.GcsNotebookSource) obj;

      if (!getUri().equals(other.getUri())) return false;
      if (!getGeneration().equals(other.getGeneration())) return false;
      if (!getUnknownFields().equals(other.getUnknownFields())) return false;
      return true;
    }

    @java.lang.Override
    public int hashCode() {
      if (memoizedHashCode != 0) {
        return memoizedHashCode;
      }
      int hash = 41;
      hash = (19 * hash) + getDescriptor().hashCode();
      hash = (37 * hash) + URI_FIELD_NUMBER;
      hash = (53 * hash) + getUri().hashCode();
      hash = (37 * hash) + GENERATION_FIELD_NUMBER;
      hash = (53 * hash) + getGeneration().hashCode();
      hash = (29 * hash) + getUnknownFields().hashCode();
      memoizedHashCode = hash;
      return hash;
    }

    public static com.google.cloud.aiplatform.v1beta1.NotebookExecutionJob.GcsNotebookSource
        parseFrom(java.nio.ByteBuffer data)
            throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.aiplatform.v1beta1.NotebookExecutionJob.GcsNotebookSource
        parseFrom(
            java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.aiplatform.v1beta1.NotebookExecutionJob.GcsNotebookSource
        parseFrom(com.google.protobuf.ByteString data)
            throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.aiplatform.v1beta1.NotebookExecutionJob.GcsNotebookSource
        parseFrom(
            com.google.protobuf.ByteString data,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.aiplatform.v1beta1.NotebookExecutionJob.GcsNotebookSource
        parseFrom(byte[] data) throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.aiplatform.v1beta1.NotebookExecutionJob.GcsNotebookSource
        parseFrom(byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.aiplatform.v1beta1.NotebookExecutionJob.GcsNotebookSource
        parseFrom(java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.cloud.aiplatform.v1beta1.NotebookExecutionJob.GcsNotebookSource
        parseFrom(
            java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.cloud.aiplatform.v1beta1.NotebookExecutionJob.GcsNotebookSource
        parseDelimitedFrom(java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
    }

    public static com.google.cloud.aiplatform.v1beta1.NotebookExecutionJob.GcsNotebookSource
        parseDelimitedFrom(
            java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.cloud.aiplatform.v1beta1.NotebookExecutionJob.GcsNotebookSource
        parseFrom(com.google.protobuf.CodedInputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.cloud.aiplatform.v1beta1.NotebookExecutionJob.GcsNotebookSource
        parseFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    @java.lang.Override
    public Builder newBuilderForType() {
      return newBuilder();
    }

    public static Builder newBuilder() {
      return DEFAULT_INSTANCE.toBuilder();
    }

    public static Builder newBuilder(
        com.google.cloud.aiplatform.v1beta1.NotebookExecutionJob.GcsNotebookSource prototype) {
      return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }

    @java.lang.Override
    public Builder toBuilder() {
      return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
    }

    @java.lang.Override
    protected Builder newBuilderForType(
        com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      Builder builder = new Builder(parent);
      return builder;
    }
    /**
     *
     *
     * <pre>
     * The Cloud Storage uri for the input notebook.
     * </pre>
     *
     * Protobuf type {@code google.cloud.aiplatform.v1beta1.NotebookExecutionJob.GcsNotebookSource}
     */
    public static final class Builder
        extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
        implements
        // @@protoc_insertion_point(builder_implements:google.cloud.aiplatform.v1beta1.NotebookExecutionJob.GcsNotebookSource)
        com.google.cloud.aiplatform.v1beta1.NotebookExecutionJob.GcsNotebookSourceOrBuilder {
      public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
        return com.google.cloud.aiplatform.v1beta1.NotebookExecutionJobProto
            .internal_static_google_cloud_aiplatform_v1beta1_NotebookExecutionJob_GcsNotebookSource_descriptor;
      }

      @java.lang.Override
      protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return com.google.cloud.aiplatform.v1beta1.NotebookExecutionJobProto
            .internal_static_google_cloud_aiplatform_v1beta1_NotebookExecutionJob_GcsNotebookSource_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                com.google.cloud.aiplatform.v1beta1.NotebookExecutionJob.GcsNotebookSource.class,
                com.google.cloud.aiplatform.v1beta1.NotebookExecutionJob.GcsNotebookSource.Builder
                    .class);
      }

      // Construct using
      // com.google.cloud.aiplatform.v1beta1.NotebookExecutionJob.GcsNotebookSource.newBuilder()
      private Builder() {}

      private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
        super(parent);
      }

      @java.lang.Override
      public Builder clear() {
        super.clear();
        bitField0_ = 0;
        uri_ = "";
        generation_ = "";
        return this;
      }

      @java.lang.Override
      public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
        return com.google.cloud.aiplatform.v1beta1.NotebookExecutionJobProto
            .internal_static_google_cloud_aiplatform_v1beta1_NotebookExecutionJob_GcsNotebookSource_descriptor;
      }

      @java.lang.Override
      public com.google.cloud.aiplatform.v1beta1.NotebookExecutionJob.GcsNotebookSource
          getDefaultInstanceForType() {
        return com.google.cloud.aiplatform.v1beta1.NotebookExecutionJob.GcsNotebookSource
            .getDefaultInstance();
      }

      @java.lang.Override
      public com.google.cloud.aiplatform.v1beta1.NotebookExecutionJob.GcsNotebookSource build() {
        com.google.cloud.aiplatform.v1beta1.NotebookExecutionJob.GcsNotebookSource result =
            buildPartial();
        if (!result.isInitialized()) {
          throw newUninitializedMessageException(result);
        }
        return result;
      }

      @java.lang.Override
      public com.google.cloud.aiplatform.v1beta1.NotebookExecutionJob.GcsNotebookSource
          buildPartial() {
        com.google.cloud.aiplatform.v1beta1.NotebookExecutionJob.GcsNotebookSource result =
            new com.google.cloud.aiplatform.v1beta1.NotebookExecutionJob.GcsNotebookSource(this);
        if (bitField0_ != 0) {
          buildPartial0(result);
        }
        onBuilt();
        return result;
      }

      private void buildPartial0(
          com.google.cloud.aiplatform.v1beta1.NotebookExecutionJob.GcsNotebookSource result) {
        int from_bitField0_ = bitField0_;
        if (((from_bitField0_ & 0x00000001) != 0)) {
          result.uri_ = uri_;
        }
        if (((from_bitField0_ & 0x00000002) != 0)) {
          result.generation_ = generation_;
        }
      }

      @java.lang.Override
      public Builder clone() {
        return super.clone();
      }

      @java.lang.Override
      public Builder setField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.setField(field, value);
      }

      @java.lang.Override
      public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
        return super.clearField(field);
      }

      @java.lang.Override
      public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
        return super.clearOneof(oneof);
      }

      @java.lang.Override
      public Builder setRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          int index,
          java.lang.Object value) {
        return super.setRepeatedField(field, index, value);
      }

      @java.lang.Override
      public Builder addRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.addRepeatedField(field, value);
      }

      @java.lang.Override
      public Builder mergeFrom(com.google.protobuf.Message other) {
        if (other
            instanceof com.google.cloud.aiplatform.v1beta1.NotebookExecutionJob.GcsNotebookSource) {
          return mergeFrom(
              (com.google.cloud.aiplatform.v1beta1.NotebookExecutionJob.GcsNotebookSource) other);
        } else {
          super.mergeFrom(other);
          return this;
        }
      }

      public Builder mergeFrom(
          com.google.cloud.aiplatform.v1beta1.NotebookExecutionJob.GcsNotebookSource other) {
        if (other
            == com.google.cloud.aiplatform.v1beta1.NotebookExecutionJob.GcsNotebookSource
                .getDefaultInstance()) return this;
        if (!other.getUri().isEmpty()) {
          uri_ = other.uri_;
          bitField0_ |= 0x00000001;
          onChanged();
        }
        if (!other.getGeneration().isEmpty()) {
          generation_ = other.generation_;
          bitField0_ |= 0x00000002;
          onChanged();
        }
        this.mergeUnknownFields(other.getUnknownFields());
        onChanged();
        return this;
      }

      @java.lang.Override
      public final boolean isInitialized() {
        return true;
      }

      @java.lang.Override
      public Builder mergeFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        if (extensionRegistry == null) {
          throw new java.lang.NullPointerException();
        }
        try {
          boolean done = false;
          while (!done) {
            int tag = input.readTag();
            switch (tag) {
              case 0:
                done = true;
                break;
              case 10:
                {
                  uri_ = input.readStringRequireUtf8();
                  bitField0_ |= 0x00000001;
                  break;
                } // case 10
              case 18:
                {
                  generation_ = input.readStringRequireUtf8();
                  bitField0_ |= 0x00000002;
                  break;
                } // case 18
              default:
                {
                  if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                    done = true; // was an endgroup tag
                  }
                  break;
                } // default:
            } // switch (tag)
          } // while (!done)
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          throw e.unwrapIOException();
        } finally {
          onChanged();
        } // finally
        return this;
      }

      private int bitField0_;

      private java.lang.Object uri_ = "";
      /**
       *
       *
       * <pre>
       * The Cloud Storage uri pointing to the ipynb file. Format:
       * `gs://bucket/notebook_file.ipynb`
       * </pre>
       *
       * <code>string uri = 1;</code>
       *
       * @return The uri.
       */
      public java.lang.String getUri() {
        java.lang.Object ref = uri_;
        if (!(ref instanceof java.lang.String)) {
          com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
          java.lang.String s = bs.toStringUtf8();
          uri_ = s;
          return s;
        } else {
          return (java.lang.String) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * The Cloud Storage uri pointing to the ipynb file. Format:
       * `gs://bucket/notebook_file.ipynb`
       * </pre>
       *
       * <code>string uri = 1;</code>
       *
       * @return The bytes for uri.
       */
      public com.google.protobuf.ByteString getUriBytes() {
        java.lang.Object ref = uri_;
        if (ref instanceof String) {
          com.google.protobuf.ByteString b =
              com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
          uri_ = b;
          return b;
        } else {
          return (com.google.protobuf.ByteString) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * The Cloud Storage uri pointing to the ipynb file. Format:
       * `gs://bucket/notebook_file.ipynb`
       * </pre>
       *
       * <code>string uri = 1;</code>
       *
       * @param value The uri to set.
       * @return This builder for chaining.
       */
      public Builder setUri(java.lang.String value) {
        if (value == null) {
          throw new NullPointerException();
        }
        uri_ = value;
        bitField0_ |= 0x00000001;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * The Cloud Storage uri pointing to the ipynb file. Format:
       * `gs://bucket/notebook_file.ipynb`
       * </pre>
       *
       * <code>string uri = 1;</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearUri() {
        uri_ = getDefaultInstance().getUri();
        bitField0_ = (bitField0_ & ~0x00000001);
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * The Cloud Storage uri pointing to the ipynb file. Format:
       * `gs://bucket/notebook_file.ipynb`
       * </pre>
       *
       * <code>string uri = 1;</code>
       *
       * @param value The bytes for uri to set.
       * @return This builder for chaining.
       */
      public Builder setUriBytes(com.google.protobuf.ByteString value) {
        if (value == null) {
          throw new NullPointerException();
        }
        checkByteStringIsUtf8(value);
        uri_ = value;
        bitField0_ |= 0x00000001;
        onChanged();
        return this;
      }

      private java.lang.Object generation_ = "";
      /**
       *
       *
       * <pre>
       * The version of the Cloud Storage object to read. If unset, the current
       * version of the object is read. See
       * https://cloud.google.com/storage/docs/metadata#generation-number.
       * </pre>
       *
       * <code>string generation = 2;</code>
       *
       * @return The generation.
       */
      public java.lang.String getGeneration() {
        java.lang.Object ref = generation_;
        if (!(ref instanceof java.lang.String)) {
          com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
          java.lang.String s = bs.toStringUtf8();
          generation_ = s;
          return s;
        } else {
          return (java.lang.String) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * The version of the Cloud Storage object to read. If unset, the current
       * version of the object is read. See
       * https://cloud.google.com/storage/docs/metadata#generation-number.
       * </pre>
       *
       * <code>string generation = 2;</code>
       *
       * @return The bytes for generation.
       */
      public com.google.protobuf.ByteString getGenerationBytes() {
        java.lang.Object ref = generation_;
        if (ref instanceof String) {
          com.google.protobuf.ByteString b =
              com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
          generation_ = b;
          return b;
        } else {
          return (com.google.protobuf.ByteString) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * The version of the Cloud Storage object to read. If unset, the current
       * version of the object is read. See
       * https://cloud.google.com/storage/docs/metadata#generation-number.
       * </pre>
       *
       * <code>string generation = 2;</code>
       *
       * @param value The generation to set.
       * @return This builder for chaining.
       */
      public Builder setGeneration(java.lang.String value) {
        if (value == null) {
          throw new NullPointerException();
        }
        generation_ = value;
        bitField0_ |= 0x00000002;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * The version of the Cloud Storage object to read. If unset, the current
       * version of the object is read. See
       * https://cloud.google.com/storage/docs/metadata#generation-number.
       * </pre>
       *
       * <code>string generation = 2;</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearGeneration() {
        generation_ = getDefaultInstance().getGeneration();
        bitField0_ = (bitField0_ & ~0x00000002);
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * The version of the Cloud Storage object to read. If unset, the current
       * version of the object is read. See
       * https://cloud.google.com/storage/docs/metadata#generation-number.
       * </pre>
       *
       * <code>string generation = 2;</code>
       *
       * @param value The bytes for generation to set.
       * @return This builder for chaining.
       */
      public Builder setGenerationBytes(com.google.protobuf.ByteString value) {
        if (value == null) {
          throw new NullPointerException();
        }
        checkByteStringIsUtf8(value);
        generation_ = value;
        bitField0_ |= 0x00000002;
        onChanged();
        return this;
      }

      @java.lang.Override
      public final Builder setUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.setUnknownFields(unknownFields);
      }

      @java.lang.Override
      public final Builder mergeUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.mergeUnknownFields(unknownFields);
      }

      // @@protoc_insertion_point(builder_scope:google.cloud.aiplatform.v1beta1.NotebookExecutionJob.GcsNotebookSource)
    }

    // @@protoc_insertion_point(class_scope:google.cloud.aiplatform.v1beta1.NotebookExecutionJob.GcsNotebookSource)
    private static final com.google.cloud.aiplatform.v1beta1.NotebookExecutionJob.GcsNotebookSource
        DEFAULT_INSTANCE;

    static {
      DEFAULT_INSTANCE =
          new com.google.cloud.aiplatform.v1beta1.NotebookExecutionJob.GcsNotebookSource();
    }

    public static com.google.cloud.aiplatform.v1beta1.NotebookExecutionJob.GcsNotebookSource
        getDefaultInstance() {
      return DEFAULT_INSTANCE;
    }

    private static final com.google.protobuf.Parser<GcsNotebookSource> PARSER =
        new com.google.protobuf.AbstractParser<GcsNotebookSource>() {
          @java.lang.Override
          public GcsNotebookSource parsePartialFrom(
              com.google.protobuf.CodedInputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
            Builder builder = newBuilder();
            try {
              builder.mergeFrom(input, extensionRegistry);
            } catch (com.google.protobuf.InvalidProtocolBufferException e) {
              throw e.setUnfinishedMessage(builder.buildPartial());
            } catch (com.google.protobuf.UninitializedMessageException e) {
              throw e.asInvalidProtocolBufferException()
                  .setUnfinishedMessage(builder.buildPartial());
            } catch (java.io.IOException e) {
              throw new com.google.protobuf.InvalidProtocolBufferException(e)
                  .setUnfinishedMessage(builder.buildPartial());
            }
            return builder.buildPartial();
          }
        };

    public static com.google.protobuf.Parser<GcsNotebookSource> parser() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.protobuf.Parser<GcsNotebookSource> getParserForType() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.cloud.aiplatform.v1beta1.NotebookExecutionJob.GcsNotebookSource
        getDefaultInstanceForType() {
      return DEFAULT_INSTANCE;
    }
  }

  public interface DirectNotebookSourceOrBuilder
      extends
      // @@protoc_insertion_point(interface_extends:google.cloud.aiplatform.v1beta1.NotebookExecutionJob.DirectNotebookSource)
      com.google.protobuf.MessageOrBuilder {

    /**
     *
     *
     * <pre>
     * The base64-encoded contents of the input notebook file.
     * </pre>
     *
     * <code>bytes content = 1;</code>
     *
     * @return The content.
     */
    com.google.protobuf.ByteString getContent();
  }
  /**
   *
   *
   * <pre>
   * The content of the input notebook in ipynb format.
   * </pre>
   *
   * Protobuf type {@code google.cloud.aiplatform.v1beta1.NotebookExecutionJob.DirectNotebookSource}
   */
  public static final class DirectNotebookSource extends com.google.protobuf.GeneratedMessageV3
      implements
      // @@protoc_insertion_point(message_implements:google.cloud.aiplatform.v1beta1.NotebookExecutionJob.DirectNotebookSource)
      DirectNotebookSourceOrBuilder {
    private static final long serialVersionUID = 0L;
    // Use DirectNotebookSource.newBuilder() to construct.
    private DirectNotebookSource(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
      super(builder);
    }

    private DirectNotebookSource() {
      content_ = com.google.protobuf.ByteString.EMPTY;
    }

    @java.lang.Override
    @SuppressWarnings({"unused"})
    protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
      return new DirectNotebookSource();
    }

    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.aiplatform.v1beta1.NotebookExecutionJobProto
          .internal_static_google_cloud_aiplatform_v1beta1_NotebookExecutionJob_DirectNotebookSource_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.aiplatform.v1beta1.NotebookExecutionJobProto
          .internal_static_google_cloud_aiplatform_v1beta1_NotebookExecutionJob_DirectNotebookSource_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.aiplatform.v1beta1.NotebookExecutionJob.DirectNotebookSource.class,
              com.google.cloud.aiplatform.v1beta1.NotebookExecutionJob.DirectNotebookSource.Builder
                  .class);
    }

    public static final int CONTENT_FIELD_NUMBER = 1;
    private com.google.protobuf.ByteString content_ = com.google.protobuf.ByteString.EMPTY;
    /**
     *
     *
     * <pre>
     * The base64-encoded contents of the input notebook file.
     * </pre>
     *
     * <code>bytes content = 1;</code>
     *
     * @return The content.
     */
    @java.lang.Override
    public com.google.protobuf.ByteString getContent() {
      return content_;
    }

    private byte memoizedIsInitialized = -1;

    @java.lang.Override
    public final boolean isInitialized() {
      byte isInitialized = memoizedIsInitialized;
      if (isInitialized == 1) return true;
      if (isInitialized == 0) return false;

      memoizedIsInitialized = 1;
      return true;
    }

    @java.lang.Override
    public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
      if (!content_.isEmpty()) {
        output.writeBytes(1, content_);
      }
      getUnknownFields().writeTo(output);
    }

    @java.lang.Override
    public int getSerializedSize() {
      int size = memoizedSize;
      if (size != -1) return size;

      size = 0;
      if (!content_.isEmpty()) {
        size += com.google.protobuf.CodedOutputStream.computeBytesSize(1, content_);
      }
      size += getUnknownFields().getSerializedSize();
      memoizedSize = size;
      return size;
    }

    @java.lang.Override
    public boolean equals(final java.lang.Object obj) {
      if (obj == this) {
        return true;
      }
      if (!(obj
          instanceof
          com.google.cloud.aiplatform.v1beta1.NotebookExecutionJob.DirectNotebookSource)) {
        return super.equals(obj);
      }
      com.google.cloud.aiplatform.v1beta1.NotebookExecutionJob.DirectNotebookSource other =
          (com.google.cloud.aiplatform.v1beta1.NotebookExecutionJob.DirectNotebookSource) obj;

      if (!getContent().equals(other.getContent())) return false;
      if (!getUnknownFields().equals(other.getUnknownFields())) return false;
      return true;
    }

    @java.lang.Override
    public int hashCode() {
      if (memoizedHashCode != 0) {
        return memoizedHashCode;
      }
      int hash = 41;
      hash = (19 * hash) + getDescriptor().hashCode();
      hash = (37 * hash) + CONTENT_FIELD_NUMBER;
      hash = (53 * hash) + getContent().hashCode();
      hash = (29 * hash) + getUnknownFields().hashCode();
      memoizedHashCode = hash;
      return hash;
    }

    public static com.google.cloud.aiplatform.v1beta1.NotebookExecutionJob.DirectNotebookSource
        parseFrom(java.nio.ByteBuffer data)
            throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.aiplatform.v1beta1.NotebookExecutionJob.DirectNotebookSource
        parseFrom(
            java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.aiplatform.v1beta1.NotebookExecutionJob.DirectNotebookSource
        parseFrom(com.google.protobuf.ByteString data)
            throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.aiplatform.v1beta1.NotebookExecutionJob.DirectNotebookSource
        parseFrom(
            com.google.protobuf.ByteString data,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.aiplatform.v1beta1.NotebookExecutionJob.DirectNotebookSource
        parseFrom(byte[] data) throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.aiplatform.v1beta1.NotebookExecutionJob.DirectNotebookSource
        parseFrom(byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.aiplatform.v1beta1.NotebookExecutionJob.DirectNotebookSource
        parseFrom(java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.cloud.aiplatform.v1beta1.NotebookExecutionJob.DirectNotebookSource
        parseFrom(
            java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.cloud.aiplatform.v1beta1.NotebookExecutionJob.DirectNotebookSource
        parseDelimitedFrom(java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
    }

    public static com.google.cloud.aiplatform.v1beta1.NotebookExecutionJob.DirectNotebookSource
        parseDelimitedFrom(
            java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.cloud.aiplatform.v1beta1.NotebookExecutionJob.DirectNotebookSource
        parseFrom(com.google.protobuf.CodedInputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.cloud.aiplatform.v1beta1.NotebookExecutionJob.DirectNotebookSource
        parseFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    @java.lang.Override
    public Builder newBuilderForType() {
      return newBuilder();
    }

    public static Builder newBuilder() {
      return DEFAULT_INSTANCE.toBuilder();
    }

    public static Builder newBuilder(
        com.google.cloud.aiplatform.v1beta1.NotebookExecutionJob.DirectNotebookSource prototype) {
      return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }

    @java.lang.Override
    public Builder toBuilder() {
      return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
    }

    @java.lang.Override
    protected Builder newBuilderForType(
        com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      Builder builder = new Builder(parent);
      return builder;
    }
    /**
     *
     *
     * <pre>
     * The content of the input notebook in ipynb format.
     * </pre>
     *
     * Protobuf type {@code
     * google.cloud.aiplatform.v1beta1.NotebookExecutionJob.DirectNotebookSource}
     */
    public static final class Builder
        extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
        implements
        // @@protoc_insertion_point(builder_implements:google.cloud.aiplatform.v1beta1.NotebookExecutionJob.DirectNotebookSource)
        com.google.cloud.aiplatform.v1beta1.NotebookExecutionJob.DirectNotebookSourceOrBuilder {
      public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
        return com.google.cloud.aiplatform.v1beta1.NotebookExecutionJobProto
            .internal_static_google_cloud_aiplatform_v1beta1_NotebookExecutionJob_DirectNotebookSource_descriptor;
      }

      @java.lang.Override
      protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return com.google.cloud.aiplatform.v1beta1.NotebookExecutionJobProto
            .internal_static_google_cloud_aiplatform_v1beta1_NotebookExecutionJob_DirectNotebookSource_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                com.google.cloud.aiplatform.v1beta1.NotebookExecutionJob.DirectNotebookSource.class,
                com.google.cloud.aiplatform.v1beta1.NotebookExecutionJob.DirectNotebookSource
                    .Builder.class);
      }

      // Construct using
      // com.google.cloud.aiplatform.v1beta1.NotebookExecutionJob.DirectNotebookSource.newBuilder()
      private Builder() {}

      private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
        super(parent);
      }

      @java.lang.Override
      public Builder clear() {
        super.clear();
        bitField0_ = 0;
        content_ = com.google.protobuf.ByteString.EMPTY;
        return this;
      }

      @java.lang.Override
      public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
        return com.google.cloud.aiplatform.v1beta1.NotebookExecutionJobProto
            .internal_static_google_cloud_aiplatform_v1beta1_NotebookExecutionJob_DirectNotebookSource_descriptor;
      }

      @java.lang.Override
      public com.google.cloud.aiplatform.v1beta1.NotebookExecutionJob.DirectNotebookSource
          getDefaultInstanceForType() {
        return com.google.cloud.aiplatform.v1beta1.NotebookExecutionJob.DirectNotebookSource
            .getDefaultInstance();
      }

      @java.lang.Override
      public com.google.cloud.aiplatform.v1beta1.NotebookExecutionJob.DirectNotebookSource build() {
        com.google.cloud.aiplatform.v1beta1.NotebookExecutionJob.DirectNotebookSource result =
            buildPartial();
        if (!result.isInitialized()) {
          throw newUninitializedMessageException(result);
        }
        return result;
      }

      @java.lang.Override
      public com.google.cloud.aiplatform.v1beta1.NotebookExecutionJob.DirectNotebookSource
          buildPartial() {
        com.google.cloud.aiplatform.v1beta1.NotebookExecutionJob.DirectNotebookSource result =
            new com.google.cloud.aiplatform.v1beta1.NotebookExecutionJob.DirectNotebookSource(this);
        if (bitField0_ != 0) {
          buildPartial0(result);
        }
        onBuilt();
        return result;
      }

      private void buildPartial0(
          com.google.cloud.aiplatform.v1beta1.NotebookExecutionJob.DirectNotebookSource result) {
        int from_bitField0_ = bitField0_;
        if (((from_bitField0_ & 0x00000001) != 0)) {
          result.content_ = content_;
        }
      }

      @java.lang.Override
      public Builder clone() {
        return super.clone();
      }

      @java.lang.Override
      public Builder setField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.setField(field, value);
      }

      @java.lang.Override
      public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
        return super.clearField(field);
      }

      @java.lang.Override
      public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
        return super.clearOneof(oneof);
      }

      @java.lang.Override
      public Builder setRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          int index,
          java.lang.Object value) {
        return super.setRepeatedField(field, index, value);
      }

      @java.lang.Override
      public Builder addRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.addRepeatedField(field, value);
      }

      @java.lang.Override
      public Builder mergeFrom(com.google.protobuf.Message other) {
        if (other
            instanceof
            com.google.cloud.aiplatform.v1beta1.NotebookExecutionJob.DirectNotebookSource) {
          return mergeFrom(
              (com.google.cloud.aiplatform.v1beta1.NotebookExecutionJob.DirectNotebookSource)
                  other);
        } else {
          super.mergeFrom(other);
          return this;
        }
      }

      public Builder mergeFrom(
          com.google.cloud.aiplatform.v1beta1.NotebookExecutionJob.DirectNotebookSource other) {
        if (other
            == com.google.cloud.aiplatform.v1beta1.NotebookExecutionJob.DirectNotebookSource
                .getDefaultInstance()) return this;
        if (other.getContent() != com.google.protobuf.ByteString.EMPTY) {
          setContent(other.getContent());
        }
        this.mergeUnknownFields(other.getUnknownFields());
        onChanged();
        return this;
      }

      @java.lang.Override
      public final boolean isInitialized() {
        return true;
      }

      @java.lang.Override
      public Builder mergeFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        if (extensionRegistry == null) {
          throw new java.lang.NullPointerException();
        }
        try {
          boolean done = false;
          while (!done) {
            int tag = input.readTag();
            switch (tag) {
              case 0:
                done = true;
                break;
              case 10:
                {
                  content_ = input.readBytes();
                  bitField0_ |= 0x00000001;
                  break;
                } // case 10
              default:
                {
                  if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                    done = true; // was an endgroup tag
                  }
                  break;
                } // default:
            } // switch (tag)
          } // while (!done)
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          throw e.unwrapIOException();
        } finally {
          onChanged();
        } // finally
        return this;
      }

      private int bitField0_;

      private com.google.protobuf.ByteString content_ = com.google.protobuf.ByteString.EMPTY;
      /**
       *
       *
       * <pre>
       * The base64-encoded contents of the input notebook file.
       * </pre>
       *
       * <code>bytes content = 1;</code>
       *
       * @return The content.
       */
      @java.lang.Override
      public com.google.protobuf.ByteString getContent() {
        return content_;
      }
      /**
       *
       *
       * <pre>
       * The base64-encoded contents of the input notebook file.
       * </pre>
       *
       * <code>bytes content = 1;</code>
       *
       * @param value The content to set.
       * @return This builder for chaining.
       */
      public Builder setContent(com.google.protobuf.ByteString value) {
        if (value == null) {
          throw new NullPointerException();
        }
        content_ = value;
        bitField0_ |= 0x00000001;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * The base64-encoded contents of the input notebook file.
       * </pre>
       *
       * <code>bytes content = 1;</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearContent() {
        bitField0_ = (bitField0_ & ~0x00000001);
        content_ = getDefaultInstance().getContent();
        onChanged();
        return this;
      }

      @java.lang.Override
      public final Builder setUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.setUnknownFields(unknownFields);
      }

      @java.lang.Override
      public final Builder mergeUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.mergeUnknownFields(unknownFields);
      }

      // @@protoc_insertion_point(builder_scope:google.cloud.aiplatform.v1beta1.NotebookExecutionJob.DirectNotebookSource)
    }

    // @@protoc_insertion_point(class_scope:google.cloud.aiplatform.v1beta1.NotebookExecutionJob.DirectNotebookSource)
    private static final com.google.cloud.aiplatform.v1beta1.NotebookExecutionJob
            .DirectNotebookSource
        DEFAULT_INSTANCE;

    static {
      DEFAULT_INSTANCE =
          new com.google.cloud.aiplatform.v1beta1.NotebookExecutionJob.DirectNotebookSource();
    }

    public static com.google.cloud.aiplatform.v1beta1.NotebookExecutionJob.DirectNotebookSource
        getDefaultInstance() {
      return DEFAULT_INSTANCE;
    }

    private static final com.google.protobuf.Parser<DirectNotebookSource> PARSER =
        new com.google.protobuf.AbstractParser<DirectNotebookSource>() {
          @java.lang.Override
          public DirectNotebookSource parsePartialFrom(
              com.google.protobuf.CodedInputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
            Builder builder = newBuilder();
            try {
              builder.mergeFrom(input, extensionRegistry);
            } catch (com.google.protobuf.InvalidProtocolBufferException e) {
              throw e.setUnfinishedMessage(builder.buildPartial());
            } catch (com.google.protobuf.UninitializedMessageException e) {
              throw e.asInvalidProtocolBufferException()
                  .setUnfinishedMessage(builder.buildPartial());
            } catch (java.io.IOException e) {
              throw new com.google.protobuf.InvalidProtocolBufferException(e)
                  .setUnfinishedMessage(builder.buildPartial());
            }
            return builder.buildPartial();
          }
        };

    public static com.google.protobuf.Parser<DirectNotebookSource> parser() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.protobuf.Parser<DirectNotebookSource> getParserForType() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.cloud.aiplatform.v1beta1.NotebookExecutionJob.DirectNotebookSource
        getDefaultInstanceForType() {
      return DEFAULT_INSTANCE;
    }
  }

  private int bitField0_;
  private int notebookSourceCase_ = 0;

  @SuppressWarnings("serial")
  private java.lang.Object notebookSource_;

  public enum NotebookSourceCase
      implements
          com.google.protobuf.Internal.EnumLite,
          com.google.protobuf.AbstractMessage.InternalOneOfEnum {
    DATAFORM_REPOSITORY_SOURCE(3),
    GCS_NOTEBOOK_SOURCE(4),
    DIRECT_NOTEBOOK_SOURCE(17),
    NOTEBOOKSOURCE_NOT_SET(0);
    private final int value;

    private NotebookSourceCase(int value) {
      this.value = value;
    }
    /**
     * @param value The number of the enum to look for.
     * @return The enum associated with the given number.
     * @deprecated Use {@link #forNumber(int)} instead.
     */
    @java.lang.Deprecated
    public static NotebookSourceCase valueOf(int value) {
      return forNumber(value);
    }

    public static NotebookSourceCase forNumber(int value) {
      switch (value) {
        case 3:
          return DATAFORM_REPOSITORY_SOURCE;
        case 4:
          return GCS_NOTEBOOK_SOURCE;
        case 17:
          return DIRECT_NOTEBOOK_SOURCE;
        case 0:
          return NOTEBOOKSOURCE_NOT_SET;
        default:
          return null;
      }
    }

    public int getNumber() {
      return this.value;
    }
  };

  public NotebookSourceCase getNotebookSourceCase() {
    return NotebookSourceCase.forNumber(notebookSourceCase_);
  }

  private int environmentSpecCase_ = 0;

  @SuppressWarnings("serial")
  private java.lang.Object environmentSpec_;

  public enum EnvironmentSpecCase
      implements
          com.google.protobuf.Internal.EnumLite,
          com.google.protobuf.AbstractMessage.InternalOneOfEnum {
    NOTEBOOK_RUNTIME_TEMPLATE_RESOURCE_NAME(14),
    ENVIRONMENTSPEC_NOT_SET(0);
    private final int value;

    private EnvironmentSpecCase(int value) {
      this.value = value;
    }
    /**
     * @param value The number of the enum to look for.
     * @return The enum associated with the given number.
     * @deprecated Use {@link #forNumber(int)} instead.
     */
    @java.lang.Deprecated
    public static EnvironmentSpecCase valueOf(int value) {
      return forNumber(value);
    }

    public static EnvironmentSpecCase forNumber(int value) {
      switch (value) {
        case 14:
          return NOTEBOOK_RUNTIME_TEMPLATE_RESOURCE_NAME;
        case 0:
          return ENVIRONMENTSPEC_NOT_SET;
        default:
          return null;
      }
    }

    public int getNumber() {
      return this.value;
    }
  };

  public EnvironmentSpecCase getEnvironmentSpecCase() {
    return EnvironmentSpecCase.forNumber(environmentSpecCase_);
  }

  private int executionSinkCase_ = 0;

  @SuppressWarnings("serial")
  private java.lang.Object executionSink_;

  public enum ExecutionSinkCase
      implements
          com.google.protobuf.Internal.EnumLite,
          com.google.protobuf.AbstractMessage.InternalOneOfEnum {
    GCS_OUTPUT_URI(8),
    EXECUTIONSINK_NOT_SET(0);
    private final int value;

    private ExecutionSinkCase(int value) {
      this.value = value;
    }
    /**
     * @param value The number of the enum to look for.
     * @return The enum associated with the given number.
     * @deprecated Use {@link #forNumber(int)} instead.
     */
    @java.lang.Deprecated
    public static ExecutionSinkCase valueOf(int value) {
      return forNumber(value);
    }

    public static ExecutionSinkCase forNumber(int value) {
      switch (value) {
        case 8:
          return GCS_OUTPUT_URI;
        case 0:
          return EXECUTIONSINK_NOT_SET;
        default:
          return null;
      }
    }

    public int getNumber() {
      return this.value;
    }
  };

  public ExecutionSinkCase getExecutionSinkCase() {
    return ExecutionSinkCase.forNumber(executionSinkCase_);
  }

  private int executionIdentityCase_ = 0;

  @SuppressWarnings("serial")
  private java.lang.Object executionIdentity_;

  public enum ExecutionIdentityCase
      implements
          com.google.protobuf.Internal.EnumLite,
          com.google.protobuf.AbstractMessage.InternalOneOfEnum {
    EXECUTION_USER(9),
    SERVICE_ACCOUNT(18),
    EXECUTIONIDENTITY_NOT_SET(0);
    private final int value;

    private ExecutionIdentityCase(int value) {
      this.value = value;
    }
    /**
     * @param value The number of the enum to look for.
     * @return The enum associated with the given number.
     * @deprecated Use {@link #forNumber(int)} instead.
     */
    @java.lang.Deprecated
    public static ExecutionIdentityCase valueOf(int value) {
      return forNumber(value);
    }

    public static ExecutionIdentityCase forNumber(int value) {
      switch (value) {
        case 9:
          return EXECUTION_USER;
        case 18:
          return SERVICE_ACCOUNT;
        case 0:
          return EXECUTIONIDENTITY_NOT_SET;
        default:
          return null;
      }
    }

    public int getNumber() {
      return this.value;
    }
  };

  public ExecutionIdentityCase getExecutionIdentityCase() {
    return ExecutionIdentityCase.forNumber(executionIdentityCase_);
  }

  public static final int DATAFORM_REPOSITORY_SOURCE_FIELD_NUMBER = 3;
  /**
   *
   *
   * <pre>
   * The Dataform Repository pointing to a single file notebook repository.
   * </pre>
   *
   * <code>
   * .google.cloud.aiplatform.v1beta1.NotebookExecutionJob.DataformRepositorySource dataform_repository_source = 3;
   * </code>
   *
   * @return Whether the dataformRepositorySource field is set.
   */
  @java.lang.Override
  public boolean hasDataformRepositorySource() {
    return notebookSourceCase_ == 3;
  }
  /**
   *
   *
   * <pre>
   * The Dataform Repository pointing to a single file notebook repository.
   * </pre>
   *
   * <code>
   * .google.cloud.aiplatform.v1beta1.NotebookExecutionJob.DataformRepositorySource dataform_repository_source = 3;
   * </code>
   *
   * @return The dataformRepositorySource.
   */
  @java.lang.Override
  public com.google.cloud.aiplatform.v1beta1.NotebookExecutionJob.DataformRepositorySource
      getDataformRepositorySource() {
    if (notebookSourceCase_ == 3) {
      return (com.google.cloud.aiplatform.v1beta1.NotebookExecutionJob.DataformRepositorySource)
          notebookSource_;
    }
    return com.google.cloud.aiplatform.v1beta1.NotebookExecutionJob.DataformRepositorySource
        .getDefaultInstance();
  }
  /**
   *
   *
   * <pre>
   * The Dataform Repository pointing to a single file notebook repository.
   * </pre>
   *
   * <code>
   * .google.cloud.aiplatform.v1beta1.NotebookExecutionJob.DataformRepositorySource dataform_repository_source = 3;
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.aiplatform.v1beta1.NotebookExecutionJob.DataformRepositorySourceOrBuilder
      getDataformRepositorySourceOrBuilder() {
    if (notebookSourceCase_ == 3) {
      return (com.google.cloud.aiplatform.v1beta1.NotebookExecutionJob.DataformRepositorySource)
          notebookSource_;
    }
    return com.google.cloud.aiplatform.v1beta1.NotebookExecutionJob.DataformRepositorySource
        .getDefaultInstance();
  }

  public static final int GCS_NOTEBOOK_SOURCE_FIELD_NUMBER = 4;
  /**
   *
   *
   * <pre>
   * The Cloud Storage url pointing to the ipynb file. Format:
   * `gs://bucket/notebook_file.ipynb`
   * </pre>
   *
   * <code>
   * .google.cloud.aiplatform.v1beta1.NotebookExecutionJob.GcsNotebookSource gcs_notebook_source = 4;
   * </code>
   *
   * @return Whether the gcsNotebookSource field is set.
   */
  @java.lang.Override
  public boolean hasGcsNotebookSource() {
    return notebookSourceCase_ == 4;
  }
  /**
   *
   *
   * <pre>
   * The Cloud Storage url pointing to the ipynb file. Format:
   * `gs://bucket/notebook_file.ipynb`
   * </pre>
   *
   * <code>
   * .google.cloud.aiplatform.v1beta1.NotebookExecutionJob.GcsNotebookSource gcs_notebook_source = 4;
   * </code>
   *
   * @return The gcsNotebookSource.
   */
  @java.lang.Override
  public com.google.cloud.aiplatform.v1beta1.NotebookExecutionJob.GcsNotebookSource
      getGcsNotebookSource() {
    if (notebookSourceCase_ == 4) {
      return (com.google.cloud.aiplatform.v1beta1.NotebookExecutionJob.GcsNotebookSource)
          notebookSource_;
    }
    return com.google.cloud.aiplatform.v1beta1.NotebookExecutionJob.GcsNotebookSource
        .getDefaultInstance();
  }
  /**
   *
   *
   * <pre>
   * The Cloud Storage url pointing to the ipynb file. Format:
   * `gs://bucket/notebook_file.ipynb`
   * </pre>
   *
   * <code>
   * .google.cloud.aiplatform.v1beta1.NotebookExecutionJob.GcsNotebookSource gcs_notebook_source = 4;
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.aiplatform.v1beta1.NotebookExecutionJob.GcsNotebookSourceOrBuilder
      getGcsNotebookSourceOrBuilder() {
    if (notebookSourceCase_ == 4) {
      return (com.google.cloud.aiplatform.v1beta1.NotebookExecutionJob.GcsNotebookSource)
          notebookSource_;
    }
    return com.google.cloud.aiplatform.v1beta1.NotebookExecutionJob.GcsNotebookSource
        .getDefaultInstance();
  }

  public static final int DIRECT_NOTEBOOK_SOURCE_FIELD_NUMBER = 17;
  /**
   *
   *
   * <pre>
   * The contents of an input notebook file.
   * </pre>
   *
   * <code>
   * .google.cloud.aiplatform.v1beta1.NotebookExecutionJob.DirectNotebookSource direct_notebook_source = 17;
   * </code>
   *
   * @return Whether the directNotebookSource field is set.
   */
  @java.lang.Override
  public boolean hasDirectNotebookSource() {
    return notebookSourceCase_ == 17;
  }
  /**
   *
   *
   * <pre>
   * The contents of an input notebook file.
   * </pre>
   *
   * <code>
   * .google.cloud.aiplatform.v1beta1.NotebookExecutionJob.DirectNotebookSource direct_notebook_source = 17;
   * </code>
   *
   * @return The directNotebookSource.
   */
  @java.lang.Override
  public com.google.cloud.aiplatform.v1beta1.NotebookExecutionJob.DirectNotebookSource
      getDirectNotebookSource() {
    if (notebookSourceCase_ == 17) {
      return (com.google.cloud.aiplatform.v1beta1.NotebookExecutionJob.DirectNotebookSource)
          notebookSource_;
    }
    return com.google.cloud.aiplatform.v1beta1.NotebookExecutionJob.DirectNotebookSource
        .getDefaultInstance();
  }
  /**
   *
   *
   * <pre>
   * The contents of an input notebook file.
   * </pre>
   *
   * <code>
   * .google.cloud.aiplatform.v1beta1.NotebookExecutionJob.DirectNotebookSource direct_notebook_source = 17;
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.aiplatform.v1beta1.NotebookExecutionJob.DirectNotebookSourceOrBuilder
      getDirectNotebookSourceOrBuilder() {
    if (notebookSourceCase_ == 17) {
      return (com.google.cloud.aiplatform.v1beta1.NotebookExecutionJob.DirectNotebookSource)
          notebookSource_;
    }
    return com.google.cloud.aiplatform.v1beta1.NotebookExecutionJob.DirectNotebookSource
        .getDefaultInstance();
  }

  public static final int NOTEBOOK_RUNTIME_TEMPLATE_RESOURCE_NAME_FIELD_NUMBER = 14;
  /**
   *
   *
   * <pre>
   * The NotebookRuntimeTemplate to source compute configuration from.
   * </pre>
   *
   * <code>
   * string notebook_runtime_template_resource_name = 14 [(.google.api.resource_reference) = { ... }
   * </code>
   *
   * @return Whether the notebookRuntimeTemplateResourceName field is set.
   */
  public boolean hasNotebookRuntimeTemplateResourceName() {
    return environmentSpecCase_ == 14;
  }
  /**
   *
   *
   * <pre>
   * The NotebookRuntimeTemplate to source compute configuration from.
   * </pre>
   *
   * <code>
   * string notebook_runtime_template_resource_name = 14 [(.google.api.resource_reference) = { ... }
   * </code>
   *
   * @return The notebookRuntimeTemplateResourceName.
   */
  public java.lang.String getNotebookRuntimeTemplateResourceName() {
    java.lang.Object ref = "";
    if (environmentSpecCase_ == 14) {
      ref = environmentSpec_;
    }
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      if (environmentSpecCase_ == 14) {
        environmentSpec_ = s;
      }
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * The NotebookRuntimeTemplate to source compute configuration from.
   * </pre>
   *
   * <code>
   * string notebook_runtime_template_resource_name = 14 [(.google.api.resource_reference) = { ... }
   * </code>
   *
   * @return The bytes for notebookRuntimeTemplateResourceName.
   */
  public com.google.protobuf.ByteString getNotebookRuntimeTemplateResourceNameBytes() {
    java.lang.Object ref = "";
    if (environmentSpecCase_ == 14) {
      ref = environmentSpec_;
    }
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      if (environmentSpecCase_ == 14) {
        environmentSpec_ = b;
      }
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int GCS_OUTPUT_URI_FIELD_NUMBER = 8;
  /**
   *
   *
   * <pre>
   * The Cloud Storage location to upload the result to. Format:
   * `gs://bucket-name`
   * </pre>
   *
   * <code>string gcs_output_uri = 8;</code>
   *
   * @return Whether the gcsOutputUri field is set.
   */
  public boolean hasGcsOutputUri() {
    return executionSinkCase_ == 8;
  }
  /**
   *
   *
   * <pre>
   * The Cloud Storage location to upload the result to. Format:
   * `gs://bucket-name`
   * </pre>
   *
   * <code>string gcs_output_uri = 8;</code>
   *
   * @return The gcsOutputUri.
   */
  public java.lang.String getGcsOutputUri() {
    java.lang.Object ref = "";
    if (executionSinkCase_ == 8) {
      ref = executionSink_;
    }
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      if (executionSinkCase_ == 8) {
        executionSink_ = s;
      }
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * The Cloud Storage location to upload the result to. Format:
   * `gs://bucket-name`
   * </pre>
   *
   * <code>string gcs_output_uri = 8;</code>
   *
   * @return The bytes for gcsOutputUri.
   */
  public com.google.protobuf.ByteString getGcsOutputUriBytes() {
    java.lang.Object ref = "";
    if (executionSinkCase_ == 8) {
      ref = executionSink_;
    }
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      if (executionSinkCase_ == 8) {
        executionSink_ = b;
      }
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int EXECUTION_USER_FIELD_NUMBER = 9;
  /**
   *
   *
   * <pre>
   * The user email to run the execution as. Only supported by Colab runtimes.
   * </pre>
   *
   * <code>string execution_user = 9;</code>
   *
   * @return Whether the executionUser field is set.
   */
  public boolean hasExecutionUser() {
    return executionIdentityCase_ == 9;
  }
  /**
   *
   *
   * <pre>
   * The user email to run the execution as. Only supported by Colab runtimes.
   * </pre>
   *
   * <code>string execution_user = 9;</code>
   *
   * @return The executionUser.
   */
  public java.lang.String getExecutionUser() {
    java.lang.Object ref = "";
    if (executionIdentityCase_ == 9) {
      ref = executionIdentity_;
    }
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      if (executionIdentityCase_ == 9) {
        executionIdentity_ = s;
      }
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * The user email to run the execution as. Only supported by Colab runtimes.
   * </pre>
   *
   * <code>string execution_user = 9;</code>
   *
   * @return The bytes for executionUser.
   */
  public com.google.protobuf.ByteString getExecutionUserBytes() {
    java.lang.Object ref = "";
    if (executionIdentityCase_ == 9) {
      ref = executionIdentity_;
    }
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      if (executionIdentityCase_ == 9) {
        executionIdentity_ = b;
      }
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int SERVICE_ACCOUNT_FIELD_NUMBER = 18;
  /**
   *
   *
   * <pre>
   * The service account to run the execution as.
   * </pre>
   *
   * <code>string service_account = 18;</code>
   *
   * @return Whether the serviceAccount field is set.
   */
  public boolean hasServiceAccount() {
    return executionIdentityCase_ == 18;
  }
  /**
   *
   *
   * <pre>
   * The service account to run the execution as.
   * </pre>
   *
   * <code>string service_account = 18;</code>
   *
   * @return The serviceAccount.
   */
  public java.lang.String getServiceAccount() {
    java.lang.Object ref = "";
    if (executionIdentityCase_ == 18) {
      ref = executionIdentity_;
    }
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      if (executionIdentityCase_ == 18) {
        executionIdentity_ = s;
      }
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * The service account to run the execution as.
   * </pre>
   *
   * <code>string service_account = 18;</code>
   *
   * @return The bytes for serviceAccount.
   */
  public com.google.protobuf.ByteString getServiceAccountBytes() {
    java.lang.Object ref = "";
    if (executionIdentityCase_ == 18) {
      ref = executionIdentity_;
    }
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      if (executionIdentityCase_ == 18) {
        executionIdentity_ = b;
      }
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int NAME_FIELD_NUMBER = 1;

  @SuppressWarnings("serial")
  private volatile java.lang.Object name_ = "";
  /**
   *
   *
   * <pre>
   * Output only. The resource name of this NotebookExecutionJob. Format:
   * `projects/{project_id}/locations/{location}/notebookExecutionJobs/{job_id}`
   * </pre>
   *
   * <code>string name = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
   *
   * @return The name.
   */
  @java.lang.Override
  public java.lang.String getName() {
    java.lang.Object ref = name_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      name_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Output only. The resource name of this NotebookExecutionJob. Format:
   * `projects/{project_id}/locations/{location}/notebookExecutionJobs/{job_id}`
   * </pre>
   *
   * <code>string name = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
   *
   * @return The bytes for name.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getNameBytes() {
    java.lang.Object ref = name_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      name_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int DISPLAY_NAME_FIELD_NUMBER = 2;

  @SuppressWarnings("serial")
  private volatile java.lang.Object displayName_ = "";
  /**
   *
   *
   * <pre>
   * The display name of the NotebookExecutionJob. The name can be up to 128
   * characters long and can consist of any UTF-8 characters.
   * </pre>
   *
   * <code>string display_name = 2;</code>
   *
   * @return The displayName.
   */
  @java.lang.Override
  public java.lang.String getDisplayName() {
    java.lang.Object ref = displayName_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      displayName_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * The display name of the NotebookExecutionJob. The name can be up to 128
   * characters long and can consist of any UTF-8 characters.
   * </pre>
   *
   * <code>string display_name = 2;</code>
   *
   * @return The bytes for displayName.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getDisplayNameBytes() {
    java.lang.Object ref = displayName_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      displayName_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int EXECUTION_TIMEOUT_FIELD_NUMBER = 5;
  private com.google.protobuf.Duration executionTimeout_;
  /**
   *
   *
   * <pre>
   * Max running time of the execution job in seconds (default 86400s / 24 hrs).
   * </pre>
   *
   * <code>.google.protobuf.Duration execution_timeout = 5;</code>
   *
   * @return Whether the executionTimeout field is set.
   */
  @java.lang.Override
  public boolean hasExecutionTimeout() {
    return ((bitField0_ & 0x00000001) != 0);
  }
  /**
   *
   *
   * <pre>
   * Max running time of the execution job in seconds (default 86400s / 24 hrs).
   * </pre>
   *
   * <code>.google.protobuf.Duration execution_timeout = 5;</code>
   *
   * @return The executionTimeout.
   */
  @java.lang.Override
  public com.google.protobuf.Duration getExecutionTimeout() {
    return executionTimeout_ == null
        ? com.google.protobuf.Duration.getDefaultInstance()
        : executionTimeout_;
  }
  /**
   *
   *
   * <pre>
   * Max running time of the execution job in seconds (default 86400s / 24 hrs).
   * </pre>
   *
   * <code>.google.protobuf.Duration execution_timeout = 5;</code>
   */
  @java.lang.Override
  public com.google.protobuf.DurationOrBuilder getExecutionTimeoutOrBuilder() {
    return executionTimeout_ == null
        ? com.google.protobuf.Duration.getDefaultInstance()
        : executionTimeout_;
  }

  public static final int SCHEDULE_RESOURCE_NAME_FIELD_NUMBER = 6;

  @SuppressWarnings("serial")
  private volatile java.lang.Object scheduleResourceName_ = "";
  /**
   *
   *
   * <pre>
   * Output only. The Schedule resource name if this job is triggered by one.
   * Format:
   * `projects/{project_id}/locations/{location}/schedules/{schedule_id}`
   * </pre>
   *
   * <code>
   * string schedule_resource_name = 6 [(.google.api.field_behavior) = OUTPUT_ONLY, (.google.api.resource_reference) = { ... }
   * </code>
   *
   * @return The scheduleResourceName.
   */
  @java.lang.Override
  public java.lang.String getScheduleResourceName() {
    java.lang.Object ref = scheduleResourceName_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      scheduleResourceName_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Output only. The Schedule resource name if this job is triggered by one.
   * Format:
   * `projects/{project_id}/locations/{location}/schedules/{schedule_id}`
   * </pre>
   *
   * <code>
   * string schedule_resource_name = 6 [(.google.api.field_behavior) = OUTPUT_ONLY, (.google.api.resource_reference) = { ... }
   * </code>
   *
   * @return The bytes for scheduleResourceName.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getScheduleResourceNameBytes() {
    java.lang.Object ref = scheduleResourceName_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      scheduleResourceName_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int JOB_STATE_FIELD_NUMBER = 10;
  private int jobState_ = 0;
  /**
   *
   *
   * <pre>
   * Output only. The state of the NotebookExecutionJob.
   * </pre>
   *
   * <code>
   * .google.cloud.aiplatform.v1beta1.JobState job_state = 10 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return The enum numeric value on the wire for jobState.
   */
  @java.lang.Override
  public int getJobStateValue() {
    return jobState_;
  }
  /**
   *
   *
   * <pre>
   * Output only. The state of the NotebookExecutionJob.
   * </pre>
   *
   * <code>
   * .google.cloud.aiplatform.v1beta1.JobState job_state = 10 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return The jobState.
   */
  @java.lang.Override
  public com.google.cloud.aiplatform.v1beta1.JobState getJobState() {
    com.google.cloud.aiplatform.v1beta1.JobState result =
        com.google.cloud.aiplatform.v1beta1.JobState.forNumber(jobState_);
    return result == null ? com.google.cloud.aiplatform.v1beta1.JobState.UNRECOGNIZED : result;
  }

  public static final int STATUS_FIELD_NUMBER = 11;
  private com.google.rpc.Status status_;
  /**
   *
   *
   * <pre>
   * Output only. Populated when the NotebookExecutionJob is completed. When
   * there is an error during notebook execution, the error details are
   * populated.
   * </pre>
   *
   * <code>.google.rpc.Status status = 11 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
   *
   * @return Whether the status field is set.
   */
  @java.lang.Override
  public boolean hasStatus() {
    return ((bitField0_ & 0x00000002) != 0);
  }
  /**
   *
   *
   * <pre>
   * Output only. Populated when the NotebookExecutionJob is completed. When
   * there is an error during notebook execution, the error details are
   * populated.
   * </pre>
   *
   * <code>.google.rpc.Status status = 11 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
   *
   * @return The status.
   */
  @java.lang.Override
  public com.google.rpc.Status getStatus() {
    return status_ == null ? com.google.rpc.Status.getDefaultInstance() : status_;
  }
  /**
   *
   *
   * <pre>
   * Output only. Populated when the NotebookExecutionJob is completed. When
   * there is an error during notebook execution, the error details are
   * populated.
   * </pre>
   *
   * <code>.google.rpc.Status status = 11 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
   */
  @java.lang.Override
  public com.google.rpc.StatusOrBuilder getStatusOrBuilder() {
    return status_ == null ? com.google.rpc.Status.getDefaultInstance() : status_;
  }

  public static final int CREATE_TIME_FIELD_NUMBER = 12;
  private com.google.protobuf.Timestamp createTime_;
  /**
   *
   *
   * <pre>
   * Output only. Timestamp when this NotebookExecutionJob was created.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp create_time = 12 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return Whether the createTime field is set.
   */
  @java.lang.Override
  public boolean hasCreateTime() {
    return ((bitField0_ & 0x00000004) != 0);
  }
  /**
   *
   *
   * <pre>
   * Output only. Timestamp when this NotebookExecutionJob was created.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp create_time = 12 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return The createTime.
   */
  @java.lang.Override
  public com.google.protobuf.Timestamp getCreateTime() {
    return createTime_ == null ? com.google.protobuf.Timestamp.getDefaultInstance() : createTime_;
  }
  /**
   *
   *
   * <pre>
   * Output only. Timestamp when this NotebookExecutionJob was created.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp create_time = 12 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   */
  @java.lang.Override
  public com.google.protobuf.TimestampOrBuilder getCreateTimeOrBuilder() {
    return createTime_ == null ? com.google.protobuf.Timestamp.getDefaultInstance() : createTime_;
  }

  public static final int UPDATE_TIME_FIELD_NUMBER = 13;
  private com.google.protobuf.Timestamp updateTime_;
  /**
   *
   *
   * <pre>
   * Output only. Timestamp when this NotebookExecutionJob was most recently
   * updated.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp update_time = 13 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return Whether the updateTime field is set.
   */
  @java.lang.Override
  public boolean hasUpdateTime() {
    return ((bitField0_ & 0x00000008) != 0);
  }
  /**
   *
   *
   * <pre>
   * Output only. Timestamp when this NotebookExecutionJob was most recently
   * updated.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp update_time = 13 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return The updateTime.
   */
  @java.lang.Override
  public com.google.protobuf.Timestamp getUpdateTime() {
    return updateTime_ == null ? com.google.protobuf.Timestamp.getDefaultInstance() : updateTime_;
  }
  /**
   *
   *
   * <pre>
   * Output only. Timestamp when this NotebookExecutionJob was most recently
   * updated.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp update_time = 13 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   */
  @java.lang.Override
  public com.google.protobuf.TimestampOrBuilder getUpdateTimeOrBuilder() {
    return updateTime_ == null ? com.google.protobuf.Timestamp.getDefaultInstance() : updateTime_;
  }

  public static final int LABELS_FIELD_NUMBER = 19;

  private static final class LabelsDefaultEntryHolder {
    static final com.google.protobuf.MapEntry<java.lang.String, java.lang.String> defaultEntry =
        com.google.protobuf.MapEntry.<java.lang.String, java.lang.String>newDefaultInstance(
            com.google.cloud.aiplatform.v1beta1.NotebookExecutionJobProto
                .internal_static_google_cloud_aiplatform_v1beta1_NotebookExecutionJob_LabelsEntry_descriptor,
            com.google.protobuf.WireFormat.FieldType.STRING,
            "",
            com.google.protobuf.WireFormat.FieldType.STRING,
            "");
  }

  @SuppressWarnings("serial")
  private com.google.protobuf.MapField<java.lang.String, java.lang.String> labels_;

  private com.google.protobuf.MapField<java.lang.String, java.lang.String> internalGetLabels() {
    if (labels_ == null) {
      return com.google.protobuf.MapField.emptyMapField(LabelsDefaultEntryHolder.defaultEntry);
    }
    return labels_;
  }

  public int getLabelsCount() {
    return internalGetLabels().getMap().size();
  }
  /**
   *
   *
   * <pre>
   * The labels with user-defined metadata to organize NotebookExecutionJobs.
   *
   * Label keys and values can be no longer than 64 characters
   * (Unicode codepoints), can only contain lowercase letters, numeric
   * characters, underscores and dashes. International characters are allowed.
   *
   * See https://goo.gl/xmQnxf for more information and examples of labels.
   * System reserved label keys are prefixed with "aiplatform.googleapis.com/"
   * and are immutable.
   * </pre>
   *
   * <code>map&lt;string, string&gt; labels = 19;</code>
   */
  @java.lang.Override
  public boolean containsLabels(java.lang.String key) {
    if (key == null) {
      throw new NullPointerException("map key");
    }
    return internalGetLabels().getMap().containsKey(key);
  }
  /** Use {@link #getLabelsMap()} instead. */
  @java.lang.Override
  @java.lang.Deprecated
  public java.util.Map<java.lang.String, java.lang.String> getLabels() {
    return getLabelsMap();
  }
  /**
   *
   *
   * <pre>
   * The labels with user-defined metadata to organize NotebookExecutionJobs.
   *
   * Label keys and values can be no longer than 64 characters
   * (Unicode codepoints), can only contain lowercase letters, numeric
   * characters, underscores and dashes. International characters are allowed.
   *
   * See https://goo.gl/xmQnxf for more information and examples of labels.
   * System reserved label keys are prefixed with "aiplatform.googleapis.com/"
   * and are immutable.
   * </pre>
   *
   * <code>map&lt;string, string&gt; labels = 19;</code>
   */
  @java.lang.Override
  public java.util.Map<java.lang.String, java.lang.String> getLabelsMap() {
    return internalGetLabels().getMap();
  }
  /**
   *
   *
   * <pre>
   * The labels with user-defined metadata to organize NotebookExecutionJobs.
   *
   * Label keys and values can be no longer than 64 characters
   * (Unicode codepoints), can only contain lowercase letters, numeric
   * characters, underscores and dashes. International characters are allowed.
   *
   * See https://goo.gl/xmQnxf for more information and examples of labels.
   * System reserved label keys are prefixed with "aiplatform.googleapis.com/"
   * and are immutable.
   * </pre>
   *
   * <code>map&lt;string, string&gt; labels = 19;</code>
   */
  @java.lang.Override
  public /* nullable */ java.lang.String getLabelsOrDefault(
      java.lang.String key,
      /* nullable */
      java.lang.String defaultValue) {
    if (key == null) {
      throw new NullPointerException("map key");
    }
    java.util.Map<java.lang.String, java.lang.String> map = internalGetLabels().getMap();
    return map.containsKey(key) ? map.get(key) : defaultValue;
  }
  /**
   *
   *
   * <pre>
   * The labels with user-defined metadata to organize NotebookExecutionJobs.
   *
   * Label keys and values can be no longer than 64 characters
   * (Unicode codepoints), can only contain lowercase letters, numeric
   * characters, underscores and dashes. International characters are allowed.
   *
   * See https://goo.gl/xmQnxf for more information and examples of labels.
   * System reserved label keys are prefixed with "aiplatform.googleapis.com/"
   * and are immutable.
   * </pre>
   *
   * <code>map&lt;string, string&gt; labels = 19;</code>
   */
  @java.lang.Override
  public java.lang.String getLabelsOrThrow(java.lang.String key) {
    if (key == null) {
      throw new NullPointerException("map key");
    }
    java.util.Map<java.lang.String, java.lang.String> map = internalGetLabels().getMap();
    if (!map.containsKey(key)) {
      throw new java.lang.IllegalArgumentException();
    }
    return map.get(key);
  }

  public static final int ENCRYPTION_SPEC_FIELD_NUMBER = 22;
  private com.google.cloud.aiplatform.v1beta1.EncryptionSpec encryptionSpec_;
  /**
   *
   *
   * <pre>
   * Customer-managed encryption key spec for the notebook execution job.
   * This field is auto-populated if the
   * [NotebookService.NotebookRuntimeTemplate][] has an encryption spec.
   * </pre>
   *
   * <code>.google.cloud.aiplatform.v1beta1.EncryptionSpec encryption_spec = 22;</code>
   *
   * @return Whether the encryptionSpec field is set.
   */
  @java.lang.Override
  public boolean hasEncryptionSpec() {
    return ((bitField0_ & 0x00000010) != 0);
  }
  /**
   *
   *
   * <pre>
   * Customer-managed encryption key spec for the notebook execution job.
   * This field is auto-populated if the
   * [NotebookService.NotebookRuntimeTemplate][] has an encryption spec.
   * </pre>
   *
   * <code>.google.cloud.aiplatform.v1beta1.EncryptionSpec encryption_spec = 22;</code>
   *
   * @return The encryptionSpec.
   */
  @java.lang.Override
  public com.google.cloud.aiplatform.v1beta1.EncryptionSpec getEncryptionSpec() {
    return encryptionSpec_ == null
        ? com.google.cloud.aiplatform.v1beta1.EncryptionSpec.getDefaultInstance()
        : encryptionSpec_;
  }
  /**
   *
   *
   * <pre>
   * Customer-managed encryption key spec for the notebook execution job.
   * This field is auto-populated if the
   * [NotebookService.NotebookRuntimeTemplate][] has an encryption spec.
   * </pre>
   *
   * <code>.google.cloud.aiplatform.v1beta1.EncryptionSpec encryption_spec = 22;</code>
   */
  @java.lang.Override
  public com.google.cloud.aiplatform.v1beta1.EncryptionSpecOrBuilder getEncryptionSpecOrBuilder() {
    return encryptionSpec_ == null
        ? com.google.cloud.aiplatform.v1beta1.EncryptionSpec.getDefaultInstance()
        : encryptionSpec_;
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(name_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 1, name_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(displayName_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 2, displayName_);
    }
    if (notebookSourceCase_ == 3) {
      output.writeMessage(
          3,
          (com.google.cloud.aiplatform.v1beta1.NotebookExecutionJob.DataformRepositorySource)
              notebookSource_);
    }
    if (notebookSourceCase_ == 4) {
      output.writeMessage(
          4,
          (com.google.cloud.aiplatform.v1beta1.NotebookExecutionJob.GcsNotebookSource)
              notebookSource_);
    }
    if (((bitField0_ & 0x00000001) != 0)) {
      output.writeMessage(5, getExecutionTimeout());
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(scheduleResourceName_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 6, scheduleResourceName_);
    }
    if (executionSinkCase_ == 8) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 8, executionSink_);
    }
    if (executionIdentityCase_ == 9) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 9, executionIdentity_);
    }
    if (jobState_
        != com.google.cloud.aiplatform.v1beta1.JobState.JOB_STATE_UNSPECIFIED.getNumber()) {
      output.writeEnum(10, jobState_);
    }
    if (((bitField0_ & 0x00000002) != 0)) {
      output.writeMessage(11, getStatus());
    }
    if (((bitField0_ & 0x00000004) != 0)) {
      output.writeMessage(12, getCreateTime());
    }
    if (((bitField0_ & 0x00000008) != 0)) {
      output.writeMessage(13, getUpdateTime());
    }
    if (environmentSpecCase_ == 14) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 14, environmentSpec_);
    }
    if (notebookSourceCase_ == 17) {
      output.writeMessage(
          17,
          (com.google.cloud.aiplatform.v1beta1.NotebookExecutionJob.DirectNotebookSource)
              notebookSource_);
    }
    if (executionIdentityCase_ == 18) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 18, executionIdentity_);
    }
    com.google.protobuf.GeneratedMessageV3.serializeStringMapTo(
        output, internalGetLabels(), LabelsDefaultEntryHolder.defaultEntry, 19);
    if (((bitField0_ & 0x00000010) != 0)) {
      output.writeMessage(22, getEncryptionSpec());
    }
    getUnknownFields().writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(name_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(1, name_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(displayName_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(2, displayName_);
    }
    if (notebookSourceCase_ == 3) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(
              3,
              (com.google.cloud.aiplatform.v1beta1.NotebookExecutionJob.DataformRepositorySource)
                  notebookSource_);
    }
    if (notebookSourceCase_ == 4) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(
              4,
              (com.google.cloud.aiplatform.v1beta1.NotebookExecutionJob.GcsNotebookSource)
                  notebookSource_);
    }
    if (((bitField0_ & 0x00000001) != 0)) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(5, getExecutionTimeout());
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(scheduleResourceName_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(6, scheduleResourceName_);
    }
    if (executionSinkCase_ == 8) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(8, executionSink_);
    }
    if (executionIdentityCase_ == 9) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(9, executionIdentity_);
    }
    if (jobState_
        != com.google.cloud.aiplatform.v1beta1.JobState.JOB_STATE_UNSPECIFIED.getNumber()) {
      size += com.google.protobuf.CodedOutputStream.computeEnumSize(10, jobState_);
    }
    if (((bitField0_ & 0x00000002) != 0)) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(11, getStatus());
    }
    if (((bitField0_ & 0x00000004) != 0)) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(12, getCreateTime());
    }
    if (((bitField0_ & 0x00000008) != 0)) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(13, getUpdateTime());
    }
    if (environmentSpecCase_ == 14) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(14, environmentSpec_);
    }
    if (notebookSourceCase_ == 17) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(
              17,
              (com.google.cloud.aiplatform.v1beta1.NotebookExecutionJob.DirectNotebookSource)
                  notebookSource_);
    }
    if (executionIdentityCase_ == 18) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(18, executionIdentity_);
    }
    for (java.util.Map.Entry<java.lang.String, java.lang.String> entry :
        internalGetLabels().getMap().entrySet()) {
      com.google.protobuf.MapEntry<java.lang.String, java.lang.String> labels__ =
          LabelsDefaultEntryHolder.defaultEntry
              .newBuilderForType()
              .setKey(entry.getKey())
              .setValue(entry.getValue())
              .build();
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(19, labels__);
    }
    if (((bitField0_ & 0x00000010) != 0)) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(22, getEncryptionSpec());
    }
    size += getUnknownFields().getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.cloud.aiplatform.v1beta1.NotebookExecutionJob)) {
      return super.equals(obj);
    }
    com.google.cloud.aiplatform.v1beta1.NotebookExecutionJob other =
        (com.google.cloud.aiplatform.v1beta1.NotebookExecutionJob) obj;

    if (!getName().equals(other.getName())) return false;
    if (!getDisplayName().equals(other.getDisplayName())) return false;
    if (hasExecutionTimeout() != other.hasExecutionTimeout()) return false;
    if (hasExecutionTimeout()) {
      if (!getExecutionTimeout().equals(other.getExecutionTimeout())) return false;
    }
    if (!getScheduleResourceName().equals(other.getScheduleResourceName())) return false;
    if (jobState_ != other.jobState_) return false;
    if (hasStatus() != other.hasStatus()) return false;
    if (hasStatus()) {
      if (!getStatus().equals(other.getStatus())) return false;
    }
    if (hasCreateTime() != other.hasCreateTime()) return false;
    if (hasCreateTime()) {
      if (!getCreateTime().equals(other.getCreateTime())) return false;
    }
    if (hasUpdateTime() != other.hasUpdateTime()) return false;
    if (hasUpdateTime()) {
      if (!getUpdateTime().equals(other.getUpdateTime())) return false;
    }
    if (!internalGetLabels().equals(other.internalGetLabels())) return false;
    if (hasEncryptionSpec() != other.hasEncryptionSpec()) return false;
    if (hasEncryptionSpec()) {
      if (!getEncryptionSpec().equals(other.getEncryptionSpec())) return false;
    }
    if (!getNotebookSourceCase().equals(other.getNotebookSourceCase())) return false;
    switch (notebookSourceCase_) {
      case 3:
        if (!getDataformRepositorySource().equals(other.getDataformRepositorySource()))
          return false;
        break;
      case 4:
        if (!getGcsNotebookSource().equals(other.getGcsNotebookSource())) return false;
        break;
      case 17:
        if (!getDirectNotebookSource().equals(other.getDirectNotebookSource())) return false;
        break;
      case 0:
      default:
    }
    if (!getEnvironmentSpecCase().equals(other.getEnvironmentSpecCase())) return false;
    switch (environmentSpecCase_) {
      case 14:
        if (!getNotebookRuntimeTemplateResourceName()
            .equals(other.getNotebookRuntimeTemplateResourceName())) return false;
        break;
      case 0:
      default:
    }
    if (!getExecutionSinkCase().equals(other.getExecutionSinkCase())) return false;
    switch (executionSinkCase_) {
      case 8:
        if (!getGcsOutputUri().equals(other.getGcsOutputUri())) return false;
        break;
      case 0:
      default:
    }
    if (!getExecutionIdentityCase().equals(other.getExecutionIdentityCase())) return false;
    switch (executionIdentityCase_) {
      case 9:
        if (!getExecutionUser().equals(other.getExecutionUser())) return false;
        break;
      case 18:
        if (!getServiceAccount().equals(other.getServiceAccount())) return false;
        break;
      case 0:
      default:
    }
    if (!getUnknownFields().equals(other.getUnknownFields())) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    hash = (37 * hash) + NAME_FIELD_NUMBER;
    hash = (53 * hash) + getName().hashCode();
    hash = (37 * hash) + DISPLAY_NAME_FIELD_NUMBER;
    hash = (53 * hash) + getDisplayName().hashCode();
    if (hasExecutionTimeout()) {
      hash = (37 * hash) + EXECUTION_TIMEOUT_FIELD_NUMBER;
      hash = (53 * hash) + getExecutionTimeout().hashCode();
    }
    hash = (37 * hash) + SCHEDULE_RESOURCE_NAME_FIELD_NUMBER;
    hash = (53 * hash) + getScheduleResourceName().hashCode();
    hash = (37 * hash) + JOB_STATE_FIELD_NUMBER;
    hash = (53 * hash) + jobState_;
    if (hasStatus()) {
      hash = (37 * hash) + STATUS_FIELD_NUMBER;
      hash = (53 * hash) + getStatus().hashCode();
    }
    if (hasCreateTime()) {
      hash = (37 * hash) + CREATE_TIME_FIELD_NUMBER;
      hash = (53 * hash) + getCreateTime().hashCode();
    }
    if (hasUpdateTime()) {
      hash = (37 * hash) + UPDATE_TIME_FIELD_NUMBER;
      hash = (53 * hash) + getUpdateTime().hashCode();
    }
    if (!internalGetLabels().getMap().isEmpty()) {
      hash = (37 * hash) + LABELS_FIELD_NUMBER;
      hash = (53 * hash) + internalGetLabels().hashCode();
    }
    if (hasEncryptionSpec()) {
      hash = (37 * hash) + ENCRYPTION_SPEC_FIELD_NUMBER;
      hash = (53 * hash) + getEncryptionSpec().hashCode();
    }
    switch (notebookSourceCase_) {
      case 3:
        hash = (37 * hash) + DATAFORM_REPOSITORY_SOURCE_FIELD_NUMBER;
        hash = (53 * hash) + getDataformRepositorySource().hashCode();
        break;
      case 4:
        hash = (37 * hash) + GCS_NOTEBOOK_SOURCE_FIELD_NUMBER;
        hash = (53 * hash) + getGcsNotebookSource().hashCode();
        break;
      case 17:
        hash = (37 * hash) + DIRECT_NOTEBOOK_SOURCE_FIELD_NUMBER;
        hash = (53 * hash) + getDirectNotebookSource().hashCode();
        break;
      case 0:
      default:
    }
    switch (environmentSpecCase_) {
      case 14:
        hash = (37 * hash) + NOTEBOOK_RUNTIME_TEMPLATE_RESOURCE_NAME_FIELD_NUMBER;
        hash = (53 * hash) + getNotebookRuntimeTemplateResourceName().hashCode();
        break;
      case 0:
      default:
    }
    switch (executionSinkCase_) {
      case 8:
        hash = (37 * hash) + GCS_OUTPUT_URI_FIELD_NUMBER;
        hash = (53 * hash) + getGcsOutputUri().hashCode();
        break;
      case 0:
      default:
    }
    switch (executionIdentityCase_) {
      case 9:
        hash = (37 * hash) + EXECUTION_USER_FIELD_NUMBER;
        hash = (53 * hash) + getExecutionUser().hashCode();
        break;
      case 18:
        hash = (37 * hash) + SERVICE_ACCOUNT_FIELD_NUMBER;
        hash = (53 * hash) + getServiceAccount().hashCode();
        break;
      case 0:
      default:
    }
    hash = (29 * hash) + getUnknownFields().hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.cloud.aiplatform.v1beta1.NotebookExecutionJob parseFrom(
      java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.aiplatform.v1beta1.NotebookExecutionJob parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.aiplatform.v1beta1.NotebookExecutionJob parseFrom(
      com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.aiplatform.v1beta1.NotebookExecutionJob parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.aiplatform.v1beta1.NotebookExecutionJob parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.aiplatform.v1beta1.NotebookExecutionJob parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.aiplatform.v1beta1.NotebookExecutionJob parseFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.aiplatform.v1beta1.NotebookExecutionJob parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.aiplatform.v1beta1.NotebookExecutionJob parseDelimitedFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.cloud.aiplatform.v1beta1.NotebookExecutionJob parseDelimitedFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.aiplatform.v1beta1.NotebookExecutionJob parseFrom(
      com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.aiplatform.v1beta1.NotebookExecutionJob parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(
      com.google.cloud.aiplatform.v1beta1.NotebookExecutionJob prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }
  /**
   *
   *
   * <pre>
   * NotebookExecutionJob represents an instance of a notebook execution.
   * </pre>
   *
   * Protobuf type {@code google.cloud.aiplatform.v1beta1.NotebookExecutionJob}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.cloud.aiplatform.v1beta1.NotebookExecutionJob)
      com.google.cloud.aiplatform.v1beta1.NotebookExecutionJobOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.aiplatform.v1beta1.NotebookExecutionJobProto
          .internal_static_google_cloud_aiplatform_v1beta1_NotebookExecutionJob_descriptor;
    }

    @SuppressWarnings({"rawtypes"})
    protected com.google.protobuf.MapFieldReflectionAccessor internalGetMapFieldReflection(
        int number) {
      switch (number) {
        case 19:
          return internalGetLabels();
        default:
          throw new RuntimeException("Invalid map field number: " + number);
      }
    }

    @SuppressWarnings({"rawtypes"})
    protected com.google.protobuf.MapFieldReflectionAccessor internalGetMutableMapFieldReflection(
        int number) {
      switch (number) {
        case 19:
          return internalGetMutableLabels();
        default:
          throw new RuntimeException("Invalid map field number: " + number);
      }
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.aiplatform.v1beta1.NotebookExecutionJobProto
          .internal_static_google_cloud_aiplatform_v1beta1_NotebookExecutionJob_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.aiplatform.v1beta1.NotebookExecutionJob.class,
              com.google.cloud.aiplatform.v1beta1.NotebookExecutionJob.Builder.class);
    }

    // Construct using com.google.cloud.aiplatform.v1beta1.NotebookExecutionJob.newBuilder()
    private Builder() {
      maybeForceBuilderInitialization();
    }

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
      maybeForceBuilderInitialization();
    }

    private void maybeForceBuilderInitialization() {
      if (com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders) {
        getExecutionTimeoutFieldBuilder();
        getStatusFieldBuilder();
        getCreateTimeFieldBuilder();
        getUpdateTimeFieldBuilder();
        getEncryptionSpecFieldBuilder();
      }
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      bitField0_ = 0;
      if (dataformRepositorySourceBuilder_ != null) {
        dataformRepositorySourceBuilder_.clear();
      }
      if (gcsNotebookSourceBuilder_ != null) {
        gcsNotebookSourceBuilder_.clear();
      }
      if (directNotebookSourceBuilder_ != null) {
        directNotebookSourceBuilder_.clear();
      }
      name_ = "";
      displayName_ = "";
      executionTimeout_ = null;
      if (executionTimeoutBuilder_ != null) {
        executionTimeoutBuilder_.dispose();
        executionTimeoutBuilder_ = null;
      }
      scheduleResourceName_ = "";
      jobState_ = 0;
      status_ = null;
      if (statusBuilder_ != null) {
        statusBuilder_.dispose();
        statusBuilder_ = null;
      }
      createTime_ = null;
      if (createTimeBuilder_ != null) {
        createTimeBuilder_.dispose();
        createTimeBuilder_ = null;
      }
      updateTime_ = null;
      if (updateTimeBuilder_ != null) {
        updateTimeBuilder_.dispose();
        updateTimeBuilder_ = null;
      }
      internalGetMutableLabels().clear();
      encryptionSpec_ = null;
      if (encryptionSpecBuilder_ != null) {
        encryptionSpecBuilder_.dispose();
        encryptionSpecBuilder_ = null;
      }
      notebookSourceCase_ = 0;
      notebookSource_ = null;
      environmentSpecCase_ = 0;
      environmentSpec_ = null;
      executionSinkCase_ = 0;
      executionSink_ = null;
      executionIdentityCase_ = 0;
      executionIdentity_ = null;
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.cloud.aiplatform.v1beta1.NotebookExecutionJobProto
          .internal_static_google_cloud_aiplatform_v1beta1_NotebookExecutionJob_descriptor;
    }

    @java.lang.Override
    public com.google.cloud.aiplatform.v1beta1.NotebookExecutionJob getDefaultInstanceForType() {
      return com.google.cloud.aiplatform.v1beta1.NotebookExecutionJob.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.cloud.aiplatform.v1beta1.NotebookExecutionJob build() {
      com.google.cloud.aiplatform.v1beta1.NotebookExecutionJob result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.cloud.aiplatform.v1beta1.NotebookExecutionJob buildPartial() {
      com.google.cloud.aiplatform.v1beta1.NotebookExecutionJob result =
          new com.google.cloud.aiplatform.v1beta1.NotebookExecutionJob(this);
      if (bitField0_ != 0) {
        buildPartial0(result);
      }
      buildPartialOneofs(result);
      onBuilt();
      return result;
    }

    private void buildPartial0(com.google.cloud.aiplatform.v1beta1.NotebookExecutionJob result) {
      int from_bitField0_ = bitField0_;
      if (((from_bitField0_ & 0x00000080) != 0)) {
        result.name_ = name_;
      }
      if (((from_bitField0_ & 0x00000100) != 0)) {
        result.displayName_ = displayName_;
      }
      int to_bitField0_ = 0;
      if (((from_bitField0_ & 0x00000200) != 0)) {
        result.executionTimeout_ =
            executionTimeoutBuilder_ == null ? executionTimeout_ : executionTimeoutBuilder_.build();
        to_bitField0_ |= 0x00000001;
      }
      if (((from_bitField0_ & 0x00000400) != 0)) {
        result.scheduleResourceName_ = scheduleResourceName_;
      }
      if (((from_bitField0_ & 0x00000800) != 0)) {
        result.jobState_ = jobState_;
      }
      if (((from_bitField0_ & 0x00001000) != 0)) {
        result.status_ = statusBuilder_ == null ? status_ : statusBuilder_.build();
        to_bitField0_ |= 0x00000002;
      }
      if (((from_bitField0_ & 0x00002000) != 0)) {
        result.createTime_ = createTimeBuilder_ == null ? createTime_ : createTimeBuilder_.build();
        to_bitField0_ |= 0x00000004;
      }
      if (((from_bitField0_ & 0x00004000) != 0)) {
        result.updateTime_ = updateTimeBuilder_ == null ? updateTime_ : updateTimeBuilder_.build();
        to_bitField0_ |= 0x00000008;
      }
      if (((from_bitField0_ & 0x00008000) != 0)) {
        result.labels_ = internalGetLabels();
        result.labels_.makeImmutable();
      }
      if (((from_bitField0_ & 0x00010000) != 0)) {
        result.encryptionSpec_ =
            encryptionSpecBuilder_ == null ? encryptionSpec_ : encryptionSpecBuilder_.build();
        to_bitField0_ |= 0x00000010;
      }
      result.bitField0_ |= to_bitField0_;
    }

    private void buildPartialOneofs(
        com.google.cloud.aiplatform.v1beta1.NotebookExecutionJob result) {
      result.notebookSourceCase_ = notebookSourceCase_;
      result.notebookSource_ = this.notebookSource_;
      if (notebookSourceCase_ == 3 && dataformRepositorySourceBuilder_ != null) {
        result.notebookSource_ = dataformRepositorySourceBuilder_.build();
      }
      if (notebookSourceCase_ == 4 && gcsNotebookSourceBuilder_ != null) {
        result.notebookSource_ = gcsNotebookSourceBuilder_.build();
      }
      if (notebookSourceCase_ == 17 && directNotebookSourceBuilder_ != null) {
        result.notebookSource_ = directNotebookSourceBuilder_.build();
      }
      result.environmentSpecCase_ = environmentSpecCase_;
      result.environmentSpec_ = this.environmentSpec_;
      result.executionSinkCase_ = executionSinkCase_;
      result.executionSink_ = this.executionSink_;
      result.executionIdentityCase_ = executionIdentityCase_;
      result.executionIdentity_ = this.executionIdentity_;
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.cloud.aiplatform.v1beta1.NotebookExecutionJob) {
        return mergeFrom((com.google.cloud.aiplatform.v1beta1.NotebookExecutionJob) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(com.google.cloud.aiplatform.v1beta1.NotebookExecutionJob other) {
      if (other == com.google.cloud.aiplatform.v1beta1.NotebookExecutionJob.getDefaultInstance())
        return this;
      if (!other.getName().isEmpty()) {
        name_ = other.name_;
        bitField0_ |= 0x00000080;
        onChanged();
      }
      if (!other.getDisplayName().isEmpty()) {
        displayName_ = other.displayName_;
        bitField0_ |= 0x00000100;
        onChanged();
      }
      if (other.hasExecutionTimeout()) {
        mergeExecutionTimeout(other.getExecutionTimeout());
      }
      if (!other.getScheduleResourceName().isEmpty()) {
        scheduleResourceName_ = other.scheduleResourceName_;
        bitField0_ |= 0x00000400;
        onChanged();
      }
      if (other.jobState_ != 0) {
        setJobStateValue(other.getJobStateValue());
      }
      if (other.hasStatus()) {
        mergeStatus(other.getStatus());
      }
      if (other.hasCreateTime()) {
        mergeCreateTime(other.getCreateTime());
      }
      if (other.hasUpdateTime()) {
        mergeUpdateTime(other.getUpdateTime());
      }
      internalGetMutableLabels().mergeFrom(other.internalGetLabels());
      bitField0_ |= 0x00008000;
      if (other.hasEncryptionSpec()) {
        mergeEncryptionSpec(other.getEncryptionSpec());
      }
      switch (other.getNotebookSourceCase()) {
        case DATAFORM_REPOSITORY_SOURCE:
          {
            mergeDataformRepositorySource(other.getDataformRepositorySource());
            break;
          }
        case GCS_NOTEBOOK_SOURCE:
          {
            mergeGcsNotebookSource(other.getGcsNotebookSource());
            break;
          }
        case DIRECT_NOTEBOOK_SOURCE:
          {
            mergeDirectNotebookSource(other.getDirectNotebookSource());
            break;
          }
        case NOTEBOOKSOURCE_NOT_SET:
          {
            break;
          }
      }
      switch (other.getEnvironmentSpecCase()) {
        case NOTEBOOK_RUNTIME_TEMPLATE_RESOURCE_NAME:
          {
            environmentSpecCase_ = 14;
            environmentSpec_ = other.environmentSpec_;
            onChanged();
            break;
          }
        case ENVIRONMENTSPEC_NOT_SET:
          {
            break;
          }
      }
      switch (other.getExecutionSinkCase()) {
        case GCS_OUTPUT_URI:
          {
            executionSinkCase_ = 8;
            executionSink_ = other.executionSink_;
            onChanged();
            break;
          }
        case EXECUTIONSINK_NOT_SET:
          {
            break;
          }
      }
      switch (other.getExecutionIdentityCase()) {
        case EXECUTION_USER:
          {
            executionIdentityCase_ = 9;
            executionIdentity_ = other.executionIdentity_;
            onChanged();
            break;
          }
        case SERVICE_ACCOUNT:
          {
            executionIdentityCase_ = 18;
            executionIdentity_ = other.executionIdentity_;
            onChanged();
            break;
          }
        case EXECUTIONIDENTITY_NOT_SET:
          {
            break;
          }
      }
      this.mergeUnknownFields(other.getUnknownFields());
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 10:
              {
                name_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000080;
                break;
              } // case 10
            case 18:
              {
                displayName_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000100;
                break;
              } // case 18
            case 26:
              {
                input.readMessage(
                    getDataformRepositorySourceFieldBuilder().getBuilder(), extensionRegistry);
                notebookSourceCase_ = 3;
                break;
              } // case 26
            case 34:
              {
                input.readMessage(
                    getGcsNotebookSourceFieldBuilder().getBuilder(), extensionRegistry);
                notebookSourceCase_ = 4;
                break;
              } // case 34
            case 42:
              {
                input.readMessage(
                    getExecutionTimeoutFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000200;
                break;
              } // case 42
            case 50:
              {
                scheduleResourceName_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000400;
                break;
              } // case 50
            case 66:
              {
                java.lang.String s = input.readStringRequireUtf8();
                executionSinkCase_ = 8;
                executionSink_ = s;
                break;
              } // case 66
            case 74:
              {
                java.lang.String s = input.readStringRequireUtf8();
                executionIdentityCase_ = 9;
                executionIdentity_ = s;
                break;
              } // case 74
            case 80:
              {
                jobState_ = input.readEnum();
                bitField0_ |= 0x00000800;
                break;
              } // case 80
            case 90:
              {
                input.readMessage(getStatusFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00001000;
                break;
              } // case 90
            case 98:
              {
                input.readMessage(getCreateTimeFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00002000;
                break;
              } // case 98
            case 106:
              {
                input.readMessage(getUpdateTimeFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00004000;
                break;
              } // case 106
            case 114:
              {
                java.lang.String s = input.readStringRequireUtf8();
                environmentSpecCase_ = 14;
                environmentSpec_ = s;
                break;
              } // case 114
            case 138:
              {
                input.readMessage(
                    getDirectNotebookSourceFieldBuilder().getBuilder(), extensionRegistry);
                notebookSourceCase_ = 17;
                break;
              } // case 138
            case 146:
              {
                java.lang.String s = input.readStringRequireUtf8();
                executionIdentityCase_ = 18;
                executionIdentity_ = s;
                break;
              } // case 146
            case 154:
              {
                com.google.protobuf.MapEntry<java.lang.String, java.lang.String> labels__ =
                    input.readMessage(
                        LabelsDefaultEntryHolder.defaultEntry.getParserForType(),
                        extensionRegistry);
                internalGetMutableLabels()
                    .getMutableMap()
                    .put(labels__.getKey(), labels__.getValue());
                bitField0_ |= 0x00008000;
                break;
              } // case 154
            case 178:
              {
                input.readMessage(getEncryptionSpecFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00010000;
                break;
              } // case 178
            default:
              {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
          } // switch (tag)
        } // while (!done)
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.unwrapIOException();
      } finally {
        onChanged();
      } // finally
      return this;
    }

    private int notebookSourceCase_ = 0;
    private java.lang.Object notebookSource_;

    public NotebookSourceCase getNotebookSourceCase() {
      return NotebookSourceCase.forNumber(notebookSourceCase_);
    }

    public Builder clearNotebookSource() {
      notebookSourceCase_ = 0;
      notebookSource_ = null;
      onChanged();
      return this;
    }

    private int environmentSpecCase_ = 0;
    private java.lang.Object environmentSpec_;

    public EnvironmentSpecCase getEnvironmentSpecCase() {
      return EnvironmentSpecCase.forNumber(environmentSpecCase_);
    }

    public Builder clearEnvironmentSpec() {
      environmentSpecCase_ = 0;
      environmentSpec_ = null;
      onChanged();
      return this;
    }

    private int executionSinkCase_ = 0;
    private java.lang.Object executionSink_;

    public ExecutionSinkCase getExecutionSinkCase() {
      return ExecutionSinkCase.forNumber(executionSinkCase_);
    }

    public Builder clearExecutionSink() {
      executionSinkCase_ = 0;
      executionSink_ = null;
      onChanged();
      return this;
    }

    private int executionIdentityCase_ = 0;
    private java.lang.Object executionIdentity_;

    public ExecutionIdentityCase getExecutionIdentityCase() {
      return ExecutionIdentityCase.forNumber(executionIdentityCase_);
    }

    public Builder clearExecutionIdentity() {
      executionIdentityCase_ = 0;
      executionIdentity_ = null;
      onChanged();
      return this;
    }

    private int bitField0_;

    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.aiplatform.v1beta1.NotebookExecutionJob.DataformRepositorySource,
            com.google.cloud.aiplatform.v1beta1.NotebookExecutionJob.DataformRepositorySource
                .Builder,
            com.google.cloud.aiplatform.v1beta1.NotebookExecutionJob
                .DataformRepositorySourceOrBuilder>
        dataformRepositorySourceBuilder_;
    /**
     *
     *
     * <pre>
     * The Dataform Repository pointing to a single file notebook repository.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.NotebookExecutionJob.DataformRepositorySource dataform_repository_source = 3;
     * </code>
     *
     * @return Whether the dataformRepositorySource field is set.
     */
    @java.lang.Override
    public boolean hasDataformRepositorySource() {
      return notebookSourceCase_ == 3;
    }
    /**
     *
     *
     * <pre>
     * The Dataform Repository pointing to a single file notebook repository.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.NotebookExecutionJob.DataformRepositorySource dataform_repository_source = 3;
     * </code>
     *
     * @return The dataformRepositorySource.
     */
    @java.lang.Override
    public com.google.cloud.aiplatform.v1beta1.NotebookExecutionJob.DataformRepositorySource
        getDataformRepositorySource() {
      if (dataformRepositorySourceBuilder_ == null) {
        if (notebookSourceCase_ == 3) {
          return (com.google.cloud.aiplatform.v1beta1.NotebookExecutionJob.DataformRepositorySource)
              notebookSource_;
        }
        return com.google.cloud.aiplatform.v1beta1.NotebookExecutionJob.DataformRepositorySource
            .getDefaultInstance();
      } else {
        if (notebookSourceCase_ == 3) {
          return dataformRepositorySourceBuilder_.getMessage();
        }
        return com.google.cloud.aiplatform.v1beta1.NotebookExecutionJob.DataformRepositorySource
            .getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * The Dataform Repository pointing to a single file notebook repository.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.NotebookExecutionJob.DataformRepositorySource dataform_repository_source = 3;
     * </code>
     */
    public Builder setDataformRepositorySource(
        com.google.cloud.aiplatform.v1beta1.NotebookExecutionJob.DataformRepositorySource value) {
      if (dataformRepositorySourceBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        notebookSource_ = value;
        onChanged();
      } else {
        dataformRepositorySourceBuilder_.setMessage(value);
      }
      notebookSourceCase_ = 3;
      return this;
    }
    /**
     *
     *
     * <pre>
     * The Dataform Repository pointing to a single file notebook repository.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.NotebookExecutionJob.DataformRepositorySource dataform_repository_source = 3;
     * </code>
     */
    public Builder setDataformRepositorySource(
        com.google.cloud.aiplatform.v1beta1.NotebookExecutionJob.DataformRepositorySource.Builder
            builderForValue) {
      if (dataformRepositorySourceBuilder_ == null) {
        notebookSource_ = builderForValue.build();
        onChanged();
      } else {
        dataformRepositorySourceBuilder_.setMessage(builderForValue.build());
      }
      notebookSourceCase_ = 3;
      return this;
    }
    /**
     *
     *
     * <pre>
     * The Dataform Repository pointing to a single file notebook repository.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.NotebookExecutionJob.DataformRepositorySource dataform_repository_source = 3;
     * </code>
     */
    public Builder mergeDataformRepositorySource(
        com.google.cloud.aiplatform.v1beta1.NotebookExecutionJob.DataformRepositorySource value) {
      if (dataformRepositorySourceBuilder_ == null) {
        if (notebookSourceCase_ == 3
            && notebookSource_
                != com.google.cloud.aiplatform.v1beta1.NotebookExecutionJob.DataformRepositorySource
                    .getDefaultInstance()) {
          notebookSource_ =
              com.google.cloud.aiplatform.v1beta1.NotebookExecutionJob.DataformRepositorySource
                  .newBuilder(
                      (com.google.cloud.aiplatform.v1beta1.NotebookExecutionJob
                              .DataformRepositorySource)
                          notebookSource_)
                  .mergeFrom(value)
                  .buildPartial();
        } else {
          notebookSource_ = value;
        }
        onChanged();
      } else {
        if (notebookSourceCase_ == 3) {
          dataformRepositorySourceBuilder_.mergeFrom(value);
        } else {
          dataformRepositorySourceBuilder_.setMessage(value);
        }
      }
      notebookSourceCase_ = 3;
      return this;
    }
    /**
     *
     *
     * <pre>
     * The Dataform Repository pointing to a single file notebook repository.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.NotebookExecutionJob.DataformRepositorySource dataform_repository_source = 3;
     * </code>
     */
    public Builder clearDataformRepositorySource() {
      if (dataformRepositorySourceBuilder_ == null) {
        if (notebookSourceCase_ == 3) {
          notebookSourceCase_ = 0;
          notebookSource_ = null;
          onChanged();
        }
      } else {
        if (notebookSourceCase_ == 3) {
          notebookSourceCase_ = 0;
          notebookSource_ = null;
        }
        dataformRepositorySourceBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * The Dataform Repository pointing to a single file notebook repository.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.NotebookExecutionJob.DataformRepositorySource dataform_repository_source = 3;
     * </code>
     */
    public com.google.cloud.aiplatform.v1beta1.NotebookExecutionJob.DataformRepositorySource.Builder
        getDataformRepositorySourceBuilder() {
      return getDataformRepositorySourceFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * The Dataform Repository pointing to a single file notebook repository.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.NotebookExecutionJob.DataformRepositorySource dataform_repository_source = 3;
     * </code>
     */
    @java.lang.Override
    public com.google.cloud.aiplatform.v1beta1.NotebookExecutionJob
            .DataformRepositorySourceOrBuilder
        getDataformRepositorySourceOrBuilder() {
      if ((notebookSourceCase_ == 3) && (dataformRepositorySourceBuilder_ != null)) {
        return dataformRepositorySourceBuilder_.getMessageOrBuilder();
      } else {
        if (notebookSourceCase_ == 3) {
          return (com.google.cloud.aiplatform.v1beta1.NotebookExecutionJob.DataformRepositorySource)
              notebookSource_;
        }
        return com.google.cloud.aiplatform.v1beta1.NotebookExecutionJob.DataformRepositorySource
            .getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * The Dataform Repository pointing to a single file notebook repository.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.NotebookExecutionJob.DataformRepositorySource dataform_repository_source = 3;
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.aiplatform.v1beta1.NotebookExecutionJob.DataformRepositorySource,
            com.google.cloud.aiplatform.v1beta1.NotebookExecutionJob.DataformRepositorySource
                .Builder,
            com.google.cloud.aiplatform.v1beta1.NotebookExecutionJob
                .DataformRepositorySourceOrBuilder>
        getDataformRepositorySourceFieldBuilder() {
      if (dataformRepositorySourceBuilder_ == null) {
        if (!(notebookSourceCase_ == 3)) {
          notebookSource_ =
              com.google.cloud.aiplatform.v1beta1.NotebookExecutionJob.DataformRepositorySource
                  .getDefaultInstance();
        }
        dataformRepositorySourceBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.aiplatform.v1beta1.NotebookExecutionJob.DataformRepositorySource,
                com.google.cloud.aiplatform.v1beta1.NotebookExecutionJob.DataformRepositorySource
                    .Builder,
                com.google.cloud.aiplatform.v1beta1.NotebookExecutionJob
                    .DataformRepositorySourceOrBuilder>(
                (com.google.cloud.aiplatform.v1beta1.NotebookExecutionJob.DataformRepositorySource)
                    notebookSource_,
                getParentForChildren(),
                isClean());
        notebookSource_ = null;
      }
      notebookSourceCase_ = 3;
      onChanged();
      return dataformRepositorySourceBuilder_;
    }

    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.aiplatform.v1beta1.NotebookExecutionJob.GcsNotebookSource,
            com.google.cloud.aiplatform.v1beta1.NotebookExecutionJob.GcsNotebookSource.Builder,
            com.google.cloud.aiplatform.v1beta1.NotebookExecutionJob.GcsNotebookSourceOrBuilder>
        gcsNotebookSourceBuilder_;
    /**
     *
     *
     * <pre>
     * The Cloud Storage url pointing to the ipynb file. Format:
     * `gs://bucket/notebook_file.ipynb`
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.NotebookExecutionJob.GcsNotebookSource gcs_notebook_source = 4;
     * </code>
     *
     * @return Whether the gcsNotebookSource field is set.
     */
    @java.lang.Override
    public boolean hasGcsNotebookSource() {
      return notebookSourceCase_ == 4;
    }
    /**
     *
     *
     * <pre>
     * The Cloud Storage url pointing to the ipynb file. Format:
     * `gs://bucket/notebook_file.ipynb`
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.NotebookExecutionJob.GcsNotebookSource gcs_notebook_source = 4;
     * </code>
     *
     * @return The gcsNotebookSource.
     */
    @java.lang.Override
    public com.google.cloud.aiplatform.v1beta1.NotebookExecutionJob.GcsNotebookSource
        getGcsNotebookSource() {
      if (gcsNotebookSourceBuilder_ == null) {
        if (notebookSourceCase_ == 4) {
          return (com.google.cloud.aiplatform.v1beta1.NotebookExecutionJob.GcsNotebookSource)
              notebookSource_;
        }
        return com.google.cloud.aiplatform.v1beta1.NotebookExecutionJob.GcsNotebookSource
            .getDefaultInstance();
      } else {
        if (notebookSourceCase_ == 4) {
          return gcsNotebookSourceBuilder_.getMessage();
        }
        return com.google.cloud.aiplatform.v1beta1.NotebookExecutionJob.GcsNotebookSource
            .getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * The Cloud Storage url pointing to the ipynb file. Format:
     * `gs://bucket/notebook_file.ipynb`
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.NotebookExecutionJob.GcsNotebookSource gcs_notebook_source = 4;
     * </code>
     */
    public Builder setGcsNotebookSource(
        com.google.cloud.aiplatform.v1beta1.NotebookExecutionJob.GcsNotebookSource value) {
      if (gcsNotebookSourceBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        notebookSource_ = value;
        onChanged();
      } else {
        gcsNotebookSourceBuilder_.setMessage(value);
      }
      notebookSourceCase_ = 4;
      return this;
    }
    /**
     *
     *
     * <pre>
     * The Cloud Storage url pointing to the ipynb file. Format:
     * `gs://bucket/notebook_file.ipynb`
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.NotebookExecutionJob.GcsNotebookSource gcs_notebook_source = 4;
     * </code>
     */
    public Builder setGcsNotebookSource(
        com.google.cloud.aiplatform.v1beta1.NotebookExecutionJob.GcsNotebookSource.Builder
            builderForValue) {
      if (gcsNotebookSourceBuilder_ == null) {
        notebookSource_ = builderForValue.build();
        onChanged();
      } else {
        gcsNotebookSourceBuilder_.setMessage(builderForValue.build());
      }
      notebookSourceCase_ = 4;
      return this;
    }
    /**
     *
     *
     * <pre>
     * The Cloud Storage url pointing to the ipynb file. Format:
     * `gs://bucket/notebook_file.ipynb`
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.NotebookExecutionJob.GcsNotebookSource gcs_notebook_source = 4;
     * </code>
     */
    public Builder mergeGcsNotebookSource(
        com.google.cloud.aiplatform.v1beta1.NotebookExecutionJob.GcsNotebookSource value) {
      if (gcsNotebookSourceBuilder_ == null) {
        if (notebookSourceCase_ == 4
            && notebookSource_
                != com.google.cloud.aiplatform.v1beta1.NotebookExecutionJob.GcsNotebookSource
                    .getDefaultInstance()) {
          notebookSource_ =
              com.google.cloud.aiplatform.v1beta1.NotebookExecutionJob.GcsNotebookSource.newBuilder(
                      (com.google.cloud.aiplatform.v1beta1.NotebookExecutionJob.GcsNotebookSource)
                          notebookSource_)
                  .mergeFrom(value)
                  .buildPartial();
        } else {
          notebookSource_ = value;
        }
        onChanged();
      } else {
        if (notebookSourceCase_ == 4) {
          gcsNotebookSourceBuilder_.mergeFrom(value);
        } else {
          gcsNotebookSourceBuilder_.setMessage(value);
        }
      }
      notebookSourceCase_ = 4;
      return this;
    }
    /**
     *
     *
     * <pre>
     * The Cloud Storage url pointing to the ipynb file. Format:
     * `gs://bucket/notebook_file.ipynb`
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.NotebookExecutionJob.GcsNotebookSource gcs_notebook_source = 4;
     * </code>
     */
    public Builder clearGcsNotebookSource() {
      if (gcsNotebookSourceBuilder_ == null) {
        if (notebookSourceCase_ == 4) {
          notebookSourceCase_ = 0;
          notebookSource_ = null;
          onChanged();
        }
      } else {
        if (notebookSourceCase_ == 4) {
          notebookSourceCase_ = 0;
          notebookSource_ = null;
        }
        gcsNotebookSourceBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * The Cloud Storage url pointing to the ipynb file. Format:
     * `gs://bucket/notebook_file.ipynb`
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.NotebookExecutionJob.GcsNotebookSource gcs_notebook_source = 4;
     * </code>
     */
    public com.google.cloud.aiplatform.v1beta1.NotebookExecutionJob.GcsNotebookSource.Builder
        getGcsNotebookSourceBuilder() {
      return getGcsNotebookSourceFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * The Cloud Storage url pointing to the ipynb file. Format:
     * `gs://bucket/notebook_file.ipynb`
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.NotebookExecutionJob.GcsNotebookSource gcs_notebook_source = 4;
     * </code>
     */
    @java.lang.Override
    public com.google.cloud.aiplatform.v1beta1.NotebookExecutionJob.GcsNotebookSourceOrBuilder
        getGcsNotebookSourceOrBuilder() {
      if ((notebookSourceCase_ == 4) && (gcsNotebookSourceBuilder_ != null)) {
        return gcsNotebookSourceBuilder_.getMessageOrBuilder();
      } else {
        if (notebookSourceCase_ == 4) {
          return (com.google.cloud.aiplatform.v1beta1.NotebookExecutionJob.GcsNotebookSource)
              notebookSource_;
        }
        return com.google.cloud.aiplatform.v1beta1.NotebookExecutionJob.GcsNotebookSource
            .getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * The Cloud Storage url pointing to the ipynb file. Format:
     * `gs://bucket/notebook_file.ipynb`
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.NotebookExecutionJob.GcsNotebookSource gcs_notebook_source = 4;
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.aiplatform.v1beta1.NotebookExecutionJob.GcsNotebookSource,
            com.google.cloud.aiplatform.v1beta1.NotebookExecutionJob.GcsNotebookSource.Builder,
            com.google.cloud.aiplatform.v1beta1.NotebookExecutionJob.GcsNotebookSourceOrBuilder>
        getGcsNotebookSourceFieldBuilder() {
      if (gcsNotebookSourceBuilder_ == null) {
        if (!(notebookSourceCase_ == 4)) {
          notebookSource_ =
              com.google.cloud.aiplatform.v1beta1.NotebookExecutionJob.GcsNotebookSource
                  .getDefaultInstance();
        }
        gcsNotebookSourceBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.aiplatform.v1beta1.NotebookExecutionJob.GcsNotebookSource,
                com.google.cloud.aiplatform.v1beta1.NotebookExecutionJob.GcsNotebookSource.Builder,
                com.google.cloud.aiplatform.v1beta1.NotebookExecutionJob
                    .GcsNotebookSourceOrBuilder>(
                (com.google.cloud.aiplatform.v1beta1.NotebookExecutionJob.GcsNotebookSource)
                    notebookSource_,
                getParentForChildren(),
                isClean());
        notebookSource_ = null;
      }
      notebookSourceCase_ = 4;
      onChanged();
      return gcsNotebookSourceBuilder_;
    }

    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.aiplatform.v1beta1.NotebookExecutionJob.DirectNotebookSource,
            com.google.cloud.aiplatform.v1beta1.NotebookExecutionJob.DirectNotebookSource.Builder,
            com.google.cloud.aiplatform.v1beta1.NotebookExecutionJob.DirectNotebookSourceOrBuilder>
        directNotebookSourceBuilder_;
    /**
     *
     *
     * <pre>
     * The contents of an input notebook file.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.NotebookExecutionJob.DirectNotebookSource direct_notebook_source = 17;
     * </code>
     *
     * @return Whether the directNotebookSource field is set.
     */
    @java.lang.Override
    public boolean hasDirectNotebookSource() {
      return notebookSourceCase_ == 17;
    }
    /**
     *
     *
     * <pre>
     * The contents of an input notebook file.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.NotebookExecutionJob.DirectNotebookSource direct_notebook_source = 17;
     * </code>
     *
     * @return The directNotebookSource.
     */
    @java.lang.Override
    public com.google.cloud.aiplatform.v1beta1.NotebookExecutionJob.DirectNotebookSource
        getDirectNotebookSource() {
      if (directNotebookSourceBuilder_ == null) {
        if (notebookSourceCase_ == 17) {
          return (com.google.cloud.aiplatform.v1beta1.NotebookExecutionJob.DirectNotebookSource)
              notebookSource_;
        }
        return com.google.cloud.aiplatform.v1beta1.NotebookExecutionJob.DirectNotebookSource
            .getDefaultInstance();
      } else {
        if (notebookSourceCase_ == 17) {
          return directNotebookSourceBuilder_.getMessage();
        }
        return com.google.cloud.aiplatform.v1beta1.NotebookExecutionJob.DirectNotebookSource
            .getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * The contents of an input notebook file.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.NotebookExecutionJob.DirectNotebookSource direct_notebook_source = 17;
     * </code>
     */
    public Builder setDirectNotebookSource(
        com.google.cloud.aiplatform.v1beta1.NotebookExecutionJob.DirectNotebookSource value) {
      if (directNotebookSourceBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        notebookSource_ = value;
        onChanged();
      } else {
        directNotebookSourceBuilder_.setMessage(value);
      }
      notebookSourceCase_ = 17;
      return this;
    }
    /**
     *
     *
     * <pre>
     * The contents of an input notebook file.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.NotebookExecutionJob.DirectNotebookSource direct_notebook_source = 17;
     * </code>
     */
    public Builder setDirectNotebookSource(
        com.google.cloud.aiplatform.v1beta1.NotebookExecutionJob.DirectNotebookSource.Builder
            builderForValue) {
      if (directNotebookSourceBuilder_ == null) {
        notebookSource_ = builderForValue.build();
        onChanged();
      } else {
        directNotebookSourceBuilder_.setMessage(builderForValue.build());
      }
      notebookSourceCase_ = 17;
      return this;
    }
    /**
     *
     *
     * <pre>
     * The contents of an input notebook file.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.NotebookExecutionJob.DirectNotebookSource direct_notebook_source = 17;
     * </code>
     */
    public Builder mergeDirectNotebookSource(
        com.google.cloud.aiplatform.v1beta1.NotebookExecutionJob.DirectNotebookSource value) {
      if (directNotebookSourceBuilder_ == null) {
        if (notebookSourceCase_ == 17
            && notebookSource_
                != com.google.cloud.aiplatform.v1beta1.NotebookExecutionJob.DirectNotebookSource
                    .getDefaultInstance()) {
          notebookSource_ =
              com.google.cloud.aiplatform.v1beta1.NotebookExecutionJob.DirectNotebookSource
                  .newBuilder(
                      (com.google.cloud.aiplatform.v1beta1.NotebookExecutionJob
                              .DirectNotebookSource)
                          notebookSource_)
                  .mergeFrom(value)
                  .buildPartial();
        } else {
          notebookSource_ = value;
        }
        onChanged();
      } else {
        if (notebookSourceCase_ == 17) {
          directNotebookSourceBuilder_.mergeFrom(value);
        } else {
          directNotebookSourceBuilder_.setMessage(value);
        }
      }
      notebookSourceCase_ = 17;
      return this;
    }
    /**
     *
     *
     * <pre>
     * The contents of an input notebook file.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.NotebookExecutionJob.DirectNotebookSource direct_notebook_source = 17;
     * </code>
     */
    public Builder clearDirectNotebookSource() {
      if (directNotebookSourceBuilder_ == null) {
        if (notebookSourceCase_ == 17) {
          notebookSourceCase_ = 0;
          notebookSource_ = null;
          onChanged();
        }
      } else {
        if (notebookSourceCase_ == 17) {
          notebookSourceCase_ = 0;
          notebookSource_ = null;
        }
        directNotebookSourceBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * The contents of an input notebook file.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.NotebookExecutionJob.DirectNotebookSource direct_notebook_source = 17;
     * </code>
     */
    public com.google.cloud.aiplatform.v1beta1.NotebookExecutionJob.DirectNotebookSource.Builder
        getDirectNotebookSourceBuilder() {
      return getDirectNotebookSourceFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * The contents of an input notebook file.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.NotebookExecutionJob.DirectNotebookSource direct_notebook_source = 17;
     * </code>
     */
    @java.lang.Override
    public com.google.cloud.aiplatform.v1beta1.NotebookExecutionJob.DirectNotebookSourceOrBuilder
        getDirectNotebookSourceOrBuilder() {
      if ((notebookSourceCase_ == 17) && (directNotebookSourceBuilder_ != null)) {
        return directNotebookSourceBuilder_.getMessageOrBuilder();
      } else {
        if (notebookSourceCase_ == 17) {
          return (com.google.cloud.aiplatform.v1beta1.NotebookExecutionJob.DirectNotebookSource)
              notebookSource_;
        }
        return com.google.cloud.aiplatform.v1beta1.NotebookExecutionJob.DirectNotebookSource
            .getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * The contents of an input notebook file.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.NotebookExecutionJob.DirectNotebookSource direct_notebook_source = 17;
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.aiplatform.v1beta1.NotebookExecutionJob.DirectNotebookSource,
            com.google.cloud.aiplatform.v1beta1.NotebookExecutionJob.DirectNotebookSource.Builder,
            com.google.cloud.aiplatform.v1beta1.NotebookExecutionJob.DirectNotebookSourceOrBuilder>
        getDirectNotebookSourceFieldBuilder() {
      if (directNotebookSourceBuilder_ == null) {
        if (!(notebookSourceCase_ == 17)) {
          notebookSource_ =
              com.google.cloud.aiplatform.v1beta1.NotebookExecutionJob.DirectNotebookSource
                  .getDefaultInstance();
        }
        directNotebookSourceBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.aiplatform.v1beta1.NotebookExecutionJob.DirectNotebookSource,
                com.google.cloud.aiplatform.v1beta1.NotebookExecutionJob.DirectNotebookSource
                    .Builder,
                com.google.cloud.aiplatform.v1beta1.NotebookExecutionJob
                    .DirectNotebookSourceOrBuilder>(
                (com.google.cloud.aiplatform.v1beta1.NotebookExecutionJob.DirectNotebookSource)
                    notebookSource_,
                getParentForChildren(),
                isClean());
        notebookSource_ = null;
      }
      notebookSourceCase_ = 17;
      onChanged();
      return directNotebookSourceBuilder_;
    }

    /**
     *
     *
     * <pre>
     * The NotebookRuntimeTemplate to source compute configuration from.
     * </pre>
     *
     * <code>
     * string notebook_runtime_template_resource_name = 14 [(.google.api.resource_reference) = { ... }
     * </code>
     *
     * @return Whether the notebookRuntimeTemplateResourceName field is set.
     */
    @java.lang.Override
    public boolean hasNotebookRuntimeTemplateResourceName() {
      return environmentSpecCase_ == 14;
    }
    /**
     *
     *
     * <pre>
     * The NotebookRuntimeTemplate to source compute configuration from.
     * </pre>
     *
     * <code>
     * string notebook_runtime_template_resource_name = 14 [(.google.api.resource_reference) = { ... }
     * </code>
     *
     * @return The notebookRuntimeTemplateResourceName.
     */
    @java.lang.Override
    public java.lang.String getNotebookRuntimeTemplateResourceName() {
      java.lang.Object ref = "";
      if (environmentSpecCase_ == 14) {
        ref = environmentSpec_;
      }
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        if (environmentSpecCase_ == 14) {
          environmentSpec_ = s;
        }
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * The NotebookRuntimeTemplate to source compute configuration from.
     * </pre>
     *
     * <code>
     * string notebook_runtime_template_resource_name = 14 [(.google.api.resource_reference) = { ... }
     * </code>
     *
     * @return The bytes for notebookRuntimeTemplateResourceName.
     */
    @java.lang.Override
    public com.google.protobuf.ByteString getNotebookRuntimeTemplateResourceNameBytes() {
      java.lang.Object ref = "";
      if (environmentSpecCase_ == 14) {
        ref = environmentSpec_;
      }
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        if (environmentSpecCase_ == 14) {
          environmentSpec_ = b;
        }
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * The NotebookRuntimeTemplate to source compute configuration from.
     * </pre>
     *
     * <code>
     * string notebook_runtime_template_resource_name = 14 [(.google.api.resource_reference) = { ... }
     * </code>
     *
     * @param value The notebookRuntimeTemplateResourceName to set.
     * @return This builder for chaining.
     */
    public Builder setNotebookRuntimeTemplateResourceName(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      environmentSpecCase_ = 14;
      environmentSpec_ = value;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The NotebookRuntimeTemplate to source compute configuration from.
     * </pre>
     *
     * <code>
     * string notebook_runtime_template_resource_name = 14 [(.google.api.resource_reference) = { ... }
     * </code>
     *
     * @return This builder for chaining.
     */
    public Builder clearNotebookRuntimeTemplateResourceName() {
      if (environmentSpecCase_ == 14) {
        environmentSpecCase_ = 0;
        environmentSpec_ = null;
        onChanged();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * The NotebookRuntimeTemplate to source compute configuration from.
     * </pre>
     *
     * <code>
     * string notebook_runtime_template_resource_name = 14 [(.google.api.resource_reference) = { ... }
     * </code>
     *
     * @param value The bytes for notebookRuntimeTemplateResourceName to set.
     * @return This builder for chaining.
     */
    public Builder setNotebookRuntimeTemplateResourceNameBytes(
        com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      environmentSpecCase_ = 14;
      environmentSpec_ = value;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * The Cloud Storage location to upload the result to. Format:
     * `gs://bucket-name`
     * </pre>
     *
     * <code>string gcs_output_uri = 8;</code>
     *
     * @return Whether the gcsOutputUri field is set.
     */
    @java.lang.Override
    public boolean hasGcsOutputUri() {
      return executionSinkCase_ == 8;
    }
    /**
     *
     *
     * <pre>
     * The Cloud Storage location to upload the result to. Format:
     * `gs://bucket-name`
     * </pre>
     *
     * <code>string gcs_output_uri = 8;</code>
     *
     * @return The gcsOutputUri.
     */
    @java.lang.Override
    public java.lang.String getGcsOutputUri() {
      java.lang.Object ref = "";
      if (executionSinkCase_ == 8) {
        ref = executionSink_;
      }
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        if (executionSinkCase_ == 8) {
          executionSink_ = s;
        }
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * The Cloud Storage location to upload the result to. Format:
     * `gs://bucket-name`
     * </pre>
     *
     * <code>string gcs_output_uri = 8;</code>
     *
     * @return The bytes for gcsOutputUri.
     */
    @java.lang.Override
    public com.google.protobuf.ByteString getGcsOutputUriBytes() {
      java.lang.Object ref = "";
      if (executionSinkCase_ == 8) {
        ref = executionSink_;
      }
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        if (executionSinkCase_ == 8) {
          executionSink_ = b;
        }
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * The Cloud Storage location to upload the result to. Format:
     * `gs://bucket-name`
     * </pre>
     *
     * <code>string gcs_output_uri = 8;</code>
     *
     * @param value The gcsOutputUri to set.
     * @return This builder for chaining.
     */
    public Builder setGcsOutputUri(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      executionSinkCase_ = 8;
      executionSink_ = value;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The Cloud Storage location to upload the result to. Format:
     * `gs://bucket-name`
     * </pre>
     *
     * <code>string gcs_output_uri = 8;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearGcsOutputUri() {
      if (executionSinkCase_ == 8) {
        executionSinkCase_ = 0;
        executionSink_ = null;
        onChanged();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * The Cloud Storage location to upload the result to. Format:
     * `gs://bucket-name`
     * </pre>
     *
     * <code>string gcs_output_uri = 8;</code>
     *
     * @param value The bytes for gcsOutputUri to set.
     * @return This builder for chaining.
     */
    public Builder setGcsOutputUriBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      executionSinkCase_ = 8;
      executionSink_ = value;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * The user email to run the execution as. Only supported by Colab runtimes.
     * </pre>
     *
     * <code>string execution_user = 9;</code>
     *
     * @return Whether the executionUser field is set.
     */
    @java.lang.Override
    public boolean hasExecutionUser() {
      return executionIdentityCase_ == 9;
    }
    /**
     *
     *
     * <pre>
     * The user email to run the execution as. Only supported by Colab runtimes.
     * </pre>
     *
     * <code>string execution_user = 9;</code>
     *
     * @return The executionUser.
     */
    @java.lang.Override
    public java.lang.String getExecutionUser() {
      java.lang.Object ref = "";
      if (executionIdentityCase_ == 9) {
        ref = executionIdentity_;
      }
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        if (executionIdentityCase_ == 9) {
          executionIdentity_ = s;
        }
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * The user email to run the execution as. Only supported by Colab runtimes.
     * </pre>
     *
     * <code>string execution_user = 9;</code>
     *
     * @return The bytes for executionUser.
     */
    @java.lang.Override
    public com.google.protobuf.ByteString getExecutionUserBytes() {
      java.lang.Object ref = "";
      if (executionIdentityCase_ == 9) {
        ref = executionIdentity_;
      }
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        if (executionIdentityCase_ == 9) {
          executionIdentity_ = b;
        }
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * The user email to run the execution as. Only supported by Colab runtimes.
     * </pre>
     *
     * <code>string execution_user = 9;</code>
     *
     * @param value The executionUser to set.
     * @return This builder for chaining.
     */
    public Builder setExecutionUser(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      executionIdentityCase_ = 9;
      executionIdentity_ = value;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The user email to run the execution as. Only supported by Colab runtimes.
     * </pre>
     *
     * <code>string execution_user = 9;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearExecutionUser() {
      if (executionIdentityCase_ == 9) {
        executionIdentityCase_ = 0;
        executionIdentity_ = null;
        onChanged();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * The user email to run the execution as. Only supported by Colab runtimes.
     * </pre>
     *
     * <code>string execution_user = 9;</code>
     *
     * @param value The bytes for executionUser to set.
     * @return This builder for chaining.
     */
    public Builder setExecutionUserBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      executionIdentityCase_ = 9;
      executionIdentity_ = value;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * The service account to run the execution as.
     * </pre>
     *
     * <code>string service_account = 18;</code>
     *
     * @return Whether the serviceAccount field is set.
     */
    @java.lang.Override
    public boolean hasServiceAccount() {
      return executionIdentityCase_ == 18;
    }
    /**
     *
     *
     * <pre>
     * The service account to run the execution as.
     * </pre>
     *
     * <code>string service_account = 18;</code>
     *
     * @return The serviceAccount.
     */
    @java.lang.Override
    public java.lang.String getServiceAccount() {
      java.lang.Object ref = "";
      if (executionIdentityCase_ == 18) {
        ref = executionIdentity_;
      }
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        if (executionIdentityCase_ == 18) {
          executionIdentity_ = s;
        }
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * The service account to run the execution as.
     * </pre>
     *
     * <code>string service_account = 18;</code>
     *
     * @return The bytes for serviceAccount.
     */
    @java.lang.Override
    public com.google.protobuf.ByteString getServiceAccountBytes() {
      java.lang.Object ref = "";
      if (executionIdentityCase_ == 18) {
        ref = executionIdentity_;
      }
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        if (executionIdentityCase_ == 18) {
          executionIdentity_ = b;
        }
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * The service account to run the execution as.
     * </pre>
     *
     * <code>string service_account = 18;</code>
     *
     * @param value The serviceAccount to set.
     * @return This builder for chaining.
     */
    public Builder setServiceAccount(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      executionIdentityCase_ = 18;
      executionIdentity_ = value;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The service account to run the execution as.
     * </pre>
     *
     * <code>string service_account = 18;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearServiceAccount() {
      if (executionIdentityCase_ == 18) {
        executionIdentityCase_ = 0;
        executionIdentity_ = null;
        onChanged();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * The service account to run the execution as.
     * </pre>
     *
     * <code>string service_account = 18;</code>
     *
     * @param value The bytes for serviceAccount to set.
     * @return This builder for chaining.
     */
    public Builder setServiceAccountBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      executionIdentityCase_ = 18;
      executionIdentity_ = value;
      onChanged();
      return this;
    }

    private java.lang.Object name_ = "";
    /**
     *
     *
     * <pre>
     * Output only. The resource name of this NotebookExecutionJob. Format:
     * `projects/{project_id}/locations/{location}/notebookExecutionJobs/{job_id}`
     * </pre>
     *
     * <code>string name = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return The name.
     */
    public java.lang.String getName() {
      java.lang.Object ref = name_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        name_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. The resource name of this NotebookExecutionJob. Format:
     * `projects/{project_id}/locations/{location}/notebookExecutionJobs/{job_id}`
     * </pre>
     *
     * <code>string name = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return The bytes for name.
     */
    public com.google.protobuf.ByteString getNameBytes() {
      java.lang.Object ref = name_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        name_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. The resource name of this NotebookExecutionJob. Format:
     * `projects/{project_id}/locations/{location}/notebookExecutionJobs/{job_id}`
     * </pre>
     *
     * <code>string name = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @param value The name to set.
     * @return This builder for chaining.
     */
    public Builder setName(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      name_ = value;
      bitField0_ |= 0x00000080;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The resource name of this NotebookExecutionJob. Format:
     * `projects/{project_id}/locations/{location}/notebookExecutionJobs/{job_id}`
     * </pre>
     *
     * <code>string name = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearName() {
      name_ = getDefaultInstance().getName();
      bitField0_ = (bitField0_ & ~0x00000080);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The resource name of this NotebookExecutionJob. Format:
     * `projects/{project_id}/locations/{location}/notebookExecutionJobs/{job_id}`
     * </pre>
     *
     * <code>string name = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @param value The bytes for name to set.
     * @return This builder for chaining.
     */
    public Builder setNameBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      name_ = value;
      bitField0_ |= 0x00000080;
      onChanged();
      return this;
    }

    private java.lang.Object displayName_ = "";
    /**
     *
     *
     * <pre>
     * The display name of the NotebookExecutionJob. The name can be up to 128
     * characters long and can consist of any UTF-8 characters.
     * </pre>
     *
     * <code>string display_name = 2;</code>
     *
     * @return The displayName.
     */
    public java.lang.String getDisplayName() {
      java.lang.Object ref = displayName_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        displayName_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * The display name of the NotebookExecutionJob. The name can be up to 128
     * characters long and can consist of any UTF-8 characters.
     * </pre>
     *
     * <code>string display_name = 2;</code>
     *
     * @return The bytes for displayName.
     */
    public com.google.protobuf.ByteString getDisplayNameBytes() {
      java.lang.Object ref = displayName_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        displayName_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * The display name of the NotebookExecutionJob. The name can be up to 128
     * characters long and can consist of any UTF-8 characters.
     * </pre>
     *
     * <code>string display_name = 2;</code>
     *
     * @param value The displayName to set.
     * @return This builder for chaining.
     */
    public Builder setDisplayName(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      displayName_ = value;
      bitField0_ |= 0x00000100;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The display name of the NotebookExecutionJob. The name can be up to 128
     * characters long and can consist of any UTF-8 characters.
     * </pre>
     *
     * <code>string display_name = 2;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearDisplayName() {
      displayName_ = getDefaultInstance().getDisplayName();
      bitField0_ = (bitField0_ & ~0x00000100);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The display name of the NotebookExecutionJob. The name can be up to 128
     * characters long and can consist of any UTF-8 characters.
     * </pre>
     *
     * <code>string display_name = 2;</code>
     *
     * @param value The bytes for displayName to set.
     * @return This builder for chaining.
     */
    public Builder setDisplayNameBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      displayName_ = value;
      bitField0_ |= 0x00000100;
      onChanged();
      return this;
    }

    private com.google.protobuf.Duration executionTimeout_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Duration,
            com.google.protobuf.Duration.Builder,
            com.google.protobuf.DurationOrBuilder>
        executionTimeoutBuilder_;
    /**
     *
     *
     * <pre>
     * Max running time of the execution job in seconds (default 86400s / 24 hrs).
     * </pre>
     *
     * <code>.google.protobuf.Duration execution_timeout = 5;</code>
     *
     * @return Whether the executionTimeout field is set.
     */
    public boolean hasExecutionTimeout() {
      return ((bitField0_ & 0x00000200) != 0);
    }
    /**
     *
     *
     * <pre>
     * Max running time of the execution job in seconds (default 86400s / 24 hrs).
     * </pre>
     *
     * <code>.google.protobuf.Duration execution_timeout = 5;</code>
     *
     * @return The executionTimeout.
     */
    public com.google.protobuf.Duration getExecutionTimeout() {
      if (executionTimeoutBuilder_ == null) {
        return executionTimeout_ == null
            ? com.google.protobuf.Duration.getDefaultInstance()
            : executionTimeout_;
      } else {
        return executionTimeoutBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Max running time of the execution job in seconds (default 86400s / 24 hrs).
     * </pre>
     *
     * <code>.google.protobuf.Duration execution_timeout = 5;</code>
     */
    public Builder setExecutionTimeout(com.google.protobuf.Duration value) {
      if (executionTimeoutBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        executionTimeout_ = value;
      } else {
        executionTimeoutBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000200;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Max running time of the execution job in seconds (default 86400s / 24 hrs).
     * </pre>
     *
     * <code>.google.protobuf.Duration execution_timeout = 5;</code>
     */
    public Builder setExecutionTimeout(com.google.protobuf.Duration.Builder builderForValue) {
      if (executionTimeoutBuilder_ == null) {
        executionTimeout_ = builderForValue.build();
      } else {
        executionTimeoutBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000200;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Max running time of the execution job in seconds (default 86400s / 24 hrs).
     * </pre>
     *
     * <code>.google.protobuf.Duration execution_timeout = 5;</code>
     */
    public Builder mergeExecutionTimeout(com.google.protobuf.Duration value) {
      if (executionTimeoutBuilder_ == null) {
        if (((bitField0_ & 0x00000200) != 0)
            && executionTimeout_ != null
            && executionTimeout_ != com.google.protobuf.Duration.getDefaultInstance()) {
          getExecutionTimeoutBuilder().mergeFrom(value);
        } else {
          executionTimeout_ = value;
        }
      } else {
        executionTimeoutBuilder_.mergeFrom(value);
      }
      if (executionTimeout_ != null) {
        bitField0_ |= 0x00000200;
        onChanged();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Max running time of the execution job in seconds (default 86400s / 24 hrs).
     * </pre>
     *
     * <code>.google.protobuf.Duration execution_timeout = 5;</code>
     */
    public Builder clearExecutionTimeout() {
      bitField0_ = (bitField0_ & ~0x00000200);
      executionTimeout_ = null;
      if (executionTimeoutBuilder_ != null) {
        executionTimeoutBuilder_.dispose();
        executionTimeoutBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Max running time of the execution job in seconds (default 86400s / 24 hrs).
     * </pre>
     *
     * <code>.google.protobuf.Duration execution_timeout = 5;</code>
     */
    public com.google.protobuf.Duration.Builder getExecutionTimeoutBuilder() {
      bitField0_ |= 0x00000200;
      onChanged();
      return getExecutionTimeoutFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Max running time of the execution job in seconds (default 86400s / 24 hrs).
     * </pre>
     *
     * <code>.google.protobuf.Duration execution_timeout = 5;</code>
     */
    public com.google.protobuf.DurationOrBuilder getExecutionTimeoutOrBuilder() {
      if (executionTimeoutBuilder_ != null) {
        return executionTimeoutBuilder_.getMessageOrBuilder();
      } else {
        return executionTimeout_ == null
            ? com.google.protobuf.Duration.getDefaultInstance()
            : executionTimeout_;
      }
    }
    /**
     *
     *
     * <pre>
     * Max running time of the execution job in seconds (default 86400s / 24 hrs).
     * </pre>
     *
     * <code>.google.protobuf.Duration execution_timeout = 5;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Duration,
            com.google.protobuf.Duration.Builder,
            com.google.protobuf.DurationOrBuilder>
        getExecutionTimeoutFieldBuilder() {
      if (executionTimeoutBuilder_ == null) {
        executionTimeoutBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.protobuf.Duration,
                com.google.protobuf.Duration.Builder,
                com.google.protobuf.DurationOrBuilder>(
                getExecutionTimeout(), getParentForChildren(), isClean());
        executionTimeout_ = null;
      }
      return executionTimeoutBuilder_;
    }

    private java.lang.Object scheduleResourceName_ = "";
    /**
     *
     *
     * <pre>
     * Output only. The Schedule resource name if this job is triggered by one.
     * Format:
     * `projects/{project_id}/locations/{location}/schedules/{schedule_id}`
     * </pre>
     *
     * <code>
     * string schedule_resource_name = 6 [(.google.api.field_behavior) = OUTPUT_ONLY, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @return The scheduleResourceName.
     */
    public java.lang.String getScheduleResourceName() {
      java.lang.Object ref = scheduleResourceName_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        scheduleResourceName_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. The Schedule resource name if this job is triggered by one.
     * Format:
     * `projects/{project_id}/locations/{location}/schedules/{schedule_id}`
     * </pre>
     *
     * <code>
     * string schedule_resource_name = 6 [(.google.api.field_behavior) = OUTPUT_ONLY, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @return The bytes for scheduleResourceName.
     */
    public com.google.protobuf.ByteString getScheduleResourceNameBytes() {
      java.lang.Object ref = scheduleResourceName_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        scheduleResourceName_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. The Schedule resource name if this job is triggered by one.
     * Format:
     * `projects/{project_id}/locations/{location}/schedules/{schedule_id}`
     * </pre>
     *
     * <code>
     * string schedule_resource_name = 6 [(.google.api.field_behavior) = OUTPUT_ONLY, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @param value The scheduleResourceName to set.
     * @return This builder for chaining.
     */
    public Builder setScheduleResourceName(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      scheduleResourceName_ = value;
      bitField0_ |= 0x00000400;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The Schedule resource name if this job is triggered by one.
     * Format:
     * `projects/{project_id}/locations/{location}/schedules/{schedule_id}`
     * </pre>
     *
     * <code>
     * string schedule_resource_name = 6 [(.google.api.field_behavior) = OUTPUT_ONLY, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @return This builder for chaining.
     */
    public Builder clearScheduleResourceName() {
      scheduleResourceName_ = getDefaultInstance().getScheduleResourceName();
      bitField0_ = (bitField0_ & ~0x00000400);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The Schedule resource name if this job is triggered by one.
     * Format:
     * `projects/{project_id}/locations/{location}/schedules/{schedule_id}`
     * </pre>
     *
     * <code>
     * string schedule_resource_name = 6 [(.google.api.field_behavior) = OUTPUT_ONLY, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @param value The bytes for scheduleResourceName to set.
     * @return This builder for chaining.
     */
    public Builder setScheduleResourceNameBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      scheduleResourceName_ = value;
      bitField0_ |= 0x00000400;
      onChanged();
      return this;
    }

    private int jobState_ = 0;
    /**
     *
     *
     * <pre>
     * Output only. The state of the NotebookExecutionJob.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.JobState job_state = 10 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return The enum numeric value on the wire for jobState.
     */
    @java.lang.Override
    public int getJobStateValue() {
      return jobState_;
    }
    /**
     *
     *
     * <pre>
     * Output only. The state of the NotebookExecutionJob.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.JobState job_state = 10 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @param value The enum numeric value on the wire for jobState to set.
     * @return This builder for chaining.
     */
    public Builder setJobStateValue(int value) {
      jobState_ = value;
      bitField0_ |= 0x00000800;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The state of the NotebookExecutionJob.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.JobState job_state = 10 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return The jobState.
     */
    @java.lang.Override
    public com.google.cloud.aiplatform.v1beta1.JobState getJobState() {
      com.google.cloud.aiplatform.v1beta1.JobState result =
          com.google.cloud.aiplatform.v1beta1.JobState.forNumber(jobState_);
      return result == null ? com.google.cloud.aiplatform.v1beta1.JobState.UNRECOGNIZED : result;
    }
    /**
     *
     *
     * <pre>
     * Output only. The state of the NotebookExecutionJob.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.JobState job_state = 10 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @param value The jobState to set.
     * @return This builder for chaining.
     */
    public Builder setJobState(com.google.cloud.aiplatform.v1beta1.JobState value) {
      if (value == null) {
        throw new NullPointerException();
      }
      bitField0_ |= 0x00000800;
      jobState_ = value.getNumber();
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The state of the NotebookExecutionJob.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.JobState job_state = 10 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return This builder for chaining.
     */
    public Builder clearJobState() {
      bitField0_ = (bitField0_ & ~0x00000800);
      jobState_ = 0;
      onChanged();
      return this;
    }

    private com.google.rpc.Status status_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.rpc.Status, com.google.rpc.Status.Builder, com.google.rpc.StatusOrBuilder>
        statusBuilder_;
    /**
     *
     *
     * <pre>
     * Output only. Populated when the NotebookExecutionJob is completed. When
     * there is an error during notebook execution, the error details are
     * populated.
     * </pre>
     *
     * <code>.google.rpc.Status status = 11 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return Whether the status field is set.
     */
    public boolean hasStatus() {
      return ((bitField0_ & 0x00001000) != 0);
    }
    /**
     *
     *
     * <pre>
     * Output only. Populated when the NotebookExecutionJob is completed. When
     * there is an error during notebook execution, the error details are
     * populated.
     * </pre>
     *
     * <code>.google.rpc.Status status = 11 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return The status.
     */
    public com.google.rpc.Status getStatus() {
      if (statusBuilder_ == null) {
        return status_ == null ? com.google.rpc.Status.getDefaultInstance() : status_;
      } else {
        return statusBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. Populated when the NotebookExecutionJob is completed. When
     * there is an error during notebook execution, the error details are
     * populated.
     * </pre>
     *
     * <code>.google.rpc.Status status = 11 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     */
    public Builder setStatus(com.google.rpc.Status value) {
      if (statusBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        status_ = value;
      } else {
        statusBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00001000;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Populated when the NotebookExecutionJob is completed. When
     * there is an error during notebook execution, the error details are
     * populated.
     * </pre>
     *
     * <code>.google.rpc.Status status = 11 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     */
    public Builder setStatus(com.google.rpc.Status.Builder builderForValue) {
      if (statusBuilder_ == null) {
        status_ = builderForValue.build();
      } else {
        statusBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00001000;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Populated when the NotebookExecutionJob is completed. When
     * there is an error during notebook execution, the error details are
     * populated.
     * </pre>
     *
     * <code>.google.rpc.Status status = 11 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     */
    public Builder mergeStatus(com.google.rpc.Status value) {
      if (statusBuilder_ == null) {
        if (((bitField0_ & 0x00001000) != 0)
            && status_ != null
            && status_ != com.google.rpc.Status.getDefaultInstance()) {
          getStatusBuilder().mergeFrom(value);
        } else {
          status_ = value;
        }
      } else {
        statusBuilder_.mergeFrom(value);
      }
      if (status_ != null) {
        bitField0_ |= 0x00001000;
        onChanged();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Populated when the NotebookExecutionJob is completed. When
     * there is an error during notebook execution, the error details are
     * populated.
     * </pre>
     *
     * <code>.google.rpc.Status status = 11 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     */
    public Builder clearStatus() {
      bitField0_ = (bitField0_ & ~0x00001000);
      status_ = null;
      if (statusBuilder_ != null) {
        statusBuilder_.dispose();
        statusBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Populated when the NotebookExecutionJob is completed. When
     * there is an error during notebook execution, the error details are
     * populated.
     * </pre>
     *
     * <code>.google.rpc.Status status = 11 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     */
    public com.google.rpc.Status.Builder getStatusBuilder() {
      bitField0_ |= 0x00001000;
      onChanged();
      return getStatusFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Output only. Populated when the NotebookExecutionJob is completed. When
     * there is an error during notebook execution, the error details are
     * populated.
     * </pre>
     *
     * <code>.google.rpc.Status status = 11 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     */
    public com.google.rpc.StatusOrBuilder getStatusOrBuilder() {
      if (statusBuilder_ != null) {
        return statusBuilder_.getMessageOrBuilder();
      } else {
        return status_ == null ? com.google.rpc.Status.getDefaultInstance() : status_;
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. Populated when the NotebookExecutionJob is completed. When
     * there is an error during notebook execution, the error details are
     * populated.
     * </pre>
     *
     * <code>.google.rpc.Status status = 11 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.rpc.Status, com.google.rpc.Status.Builder, com.google.rpc.StatusOrBuilder>
        getStatusFieldBuilder() {
      if (statusBuilder_ == null) {
        statusBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.rpc.Status,
                com.google.rpc.Status.Builder,
                com.google.rpc.StatusOrBuilder>(getStatus(), getParentForChildren(), isClean());
        status_ = null;
      }
      return statusBuilder_;
    }

    private com.google.protobuf.Timestamp createTime_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Timestamp,
            com.google.protobuf.Timestamp.Builder,
            com.google.protobuf.TimestampOrBuilder>
        createTimeBuilder_;
    /**
     *
     *
     * <pre>
     * Output only. Timestamp when this NotebookExecutionJob was created.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp create_time = 12 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return Whether the createTime field is set.
     */
    public boolean hasCreateTime() {
      return ((bitField0_ & 0x00002000) != 0);
    }
    /**
     *
     *
     * <pre>
     * Output only. Timestamp when this NotebookExecutionJob was created.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp create_time = 12 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return The createTime.
     */
    public com.google.protobuf.Timestamp getCreateTime() {
      if (createTimeBuilder_ == null) {
        return createTime_ == null
            ? com.google.protobuf.Timestamp.getDefaultInstance()
            : createTime_;
      } else {
        return createTimeBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. Timestamp when this NotebookExecutionJob was created.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp create_time = 12 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder setCreateTime(com.google.protobuf.Timestamp value) {
      if (createTimeBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        createTime_ = value;
      } else {
        createTimeBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00002000;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Timestamp when this NotebookExecutionJob was created.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp create_time = 12 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder setCreateTime(com.google.protobuf.Timestamp.Builder builderForValue) {
      if (createTimeBuilder_ == null) {
        createTime_ = builderForValue.build();
      } else {
        createTimeBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00002000;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Timestamp when this NotebookExecutionJob was created.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp create_time = 12 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder mergeCreateTime(com.google.protobuf.Timestamp value) {
      if (createTimeBuilder_ == null) {
        if (((bitField0_ & 0x00002000) != 0)
            && createTime_ != null
            && createTime_ != com.google.protobuf.Timestamp.getDefaultInstance()) {
          getCreateTimeBuilder().mergeFrom(value);
        } else {
          createTime_ = value;
        }
      } else {
        createTimeBuilder_.mergeFrom(value);
      }
      if (createTime_ != null) {
        bitField0_ |= 0x00002000;
        onChanged();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Timestamp when this NotebookExecutionJob was created.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp create_time = 12 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder clearCreateTime() {
      bitField0_ = (bitField0_ & ~0x00002000);
      createTime_ = null;
      if (createTimeBuilder_ != null) {
        createTimeBuilder_.dispose();
        createTimeBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Timestamp when this NotebookExecutionJob was created.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp create_time = 12 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.protobuf.Timestamp.Builder getCreateTimeBuilder() {
      bitField0_ |= 0x00002000;
      onChanged();
      return getCreateTimeFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Output only. Timestamp when this NotebookExecutionJob was created.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp create_time = 12 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.protobuf.TimestampOrBuilder getCreateTimeOrBuilder() {
      if (createTimeBuilder_ != null) {
        return createTimeBuilder_.getMessageOrBuilder();
      } else {
        return createTime_ == null
            ? com.google.protobuf.Timestamp.getDefaultInstance()
            : createTime_;
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. Timestamp when this NotebookExecutionJob was created.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp create_time = 12 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Timestamp,
            com.google.protobuf.Timestamp.Builder,
            com.google.protobuf.TimestampOrBuilder>
        getCreateTimeFieldBuilder() {
      if (createTimeBuilder_ == null) {
        createTimeBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.protobuf.Timestamp,
                com.google.protobuf.Timestamp.Builder,
                com.google.protobuf.TimestampOrBuilder>(
                getCreateTime(), getParentForChildren(), isClean());
        createTime_ = null;
      }
      return createTimeBuilder_;
    }

    private com.google.protobuf.Timestamp updateTime_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Timestamp,
            com.google.protobuf.Timestamp.Builder,
            com.google.protobuf.TimestampOrBuilder>
        updateTimeBuilder_;
    /**
     *
     *
     * <pre>
     * Output only. Timestamp when this NotebookExecutionJob was most recently
     * updated.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp update_time = 13 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return Whether the updateTime field is set.
     */
    public boolean hasUpdateTime() {
      return ((bitField0_ & 0x00004000) != 0);
    }
    /**
     *
     *
     * <pre>
     * Output only. Timestamp when this NotebookExecutionJob was most recently
     * updated.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp update_time = 13 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return The updateTime.
     */
    public com.google.protobuf.Timestamp getUpdateTime() {
      if (updateTimeBuilder_ == null) {
        return updateTime_ == null
            ? com.google.protobuf.Timestamp.getDefaultInstance()
            : updateTime_;
      } else {
        return updateTimeBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. Timestamp when this NotebookExecutionJob was most recently
     * updated.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp update_time = 13 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder setUpdateTime(com.google.protobuf.Timestamp value) {
      if (updateTimeBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        updateTime_ = value;
      } else {
        updateTimeBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00004000;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Timestamp when this NotebookExecutionJob was most recently
     * updated.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp update_time = 13 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder setUpdateTime(com.google.protobuf.Timestamp.Builder builderForValue) {
      if (updateTimeBuilder_ == null) {
        updateTime_ = builderForValue.build();
      } else {
        updateTimeBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00004000;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Timestamp when this NotebookExecutionJob was most recently
     * updated.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp update_time = 13 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder mergeUpdateTime(com.google.protobuf.Timestamp value) {
      if (updateTimeBuilder_ == null) {
        if (((bitField0_ & 0x00004000) != 0)
            && updateTime_ != null
            && updateTime_ != com.google.protobuf.Timestamp.getDefaultInstance()) {
          getUpdateTimeBuilder().mergeFrom(value);
        } else {
          updateTime_ = value;
        }
      } else {
        updateTimeBuilder_.mergeFrom(value);
      }
      if (updateTime_ != null) {
        bitField0_ |= 0x00004000;
        onChanged();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Timestamp when this NotebookExecutionJob was most recently
     * updated.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp update_time = 13 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder clearUpdateTime() {
      bitField0_ = (bitField0_ & ~0x00004000);
      updateTime_ = null;
      if (updateTimeBuilder_ != null) {
        updateTimeBuilder_.dispose();
        updateTimeBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Timestamp when this NotebookExecutionJob was most recently
     * updated.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp update_time = 13 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.protobuf.Timestamp.Builder getUpdateTimeBuilder() {
      bitField0_ |= 0x00004000;
      onChanged();
      return getUpdateTimeFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Output only. Timestamp when this NotebookExecutionJob was most recently
     * updated.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp update_time = 13 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.protobuf.TimestampOrBuilder getUpdateTimeOrBuilder() {
      if (updateTimeBuilder_ != null) {
        return updateTimeBuilder_.getMessageOrBuilder();
      } else {
        return updateTime_ == null
            ? com.google.protobuf.Timestamp.getDefaultInstance()
            : updateTime_;
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. Timestamp when this NotebookExecutionJob was most recently
     * updated.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp update_time = 13 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Timestamp,
            com.google.protobuf.Timestamp.Builder,
            com.google.protobuf.TimestampOrBuilder>
        getUpdateTimeFieldBuilder() {
      if (updateTimeBuilder_ == null) {
        updateTimeBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.protobuf.Timestamp,
                com.google.protobuf.Timestamp.Builder,
                com.google.protobuf.TimestampOrBuilder>(
                getUpdateTime(), getParentForChildren(), isClean());
        updateTime_ = null;
      }
      return updateTimeBuilder_;
    }

    private com.google.protobuf.MapField<java.lang.String, java.lang.String> labels_;

    private com.google.protobuf.MapField<java.lang.String, java.lang.String> internalGetLabels() {
      if (labels_ == null) {
        return com.google.protobuf.MapField.emptyMapField(LabelsDefaultEntryHolder.defaultEntry);
      }
      return labels_;
    }

    private com.google.protobuf.MapField<java.lang.String, java.lang.String>
        internalGetMutableLabels() {
      if (labels_ == null) {
        labels_ = com.google.protobuf.MapField.newMapField(LabelsDefaultEntryHolder.defaultEntry);
      }
      if (!labels_.isMutable()) {
        labels_ = labels_.copy();
      }
      bitField0_ |= 0x00008000;
      onChanged();
      return labels_;
    }

    public int getLabelsCount() {
      return internalGetLabels().getMap().size();
    }
    /**
     *
     *
     * <pre>
     * The labels with user-defined metadata to organize NotebookExecutionJobs.
     *
     * Label keys and values can be no longer than 64 characters
     * (Unicode codepoints), can only contain lowercase letters, numeric
     * characters, underscores and dashes. International characters are allowed.
     *
     * See https://goo.gl/xmQnxf for more information and examples of labels.
     * System reserved label keys are prefixed with "aiplatform.googleapis.com/"
     * and are immutable.
     * </pre>
     *
     * <code>map&lt;string, string&gt; labels = 19;</code>
     */
    @java.lang.Override
    public boolean containsLabels(java.lang.String key) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      return internalGetLabels().getMap().containsKey(key);
    }
    /** Use {@link #getLabelsMap()} instead. */
    @java.lang.Override
    @java.lang.Deprecated
    public java.util.Map<java.lang.String, java.lang.String> getLabels() {
      return getLabelsMap();
    }
    /**
     *
     *
     * <pre>
     * The labels with user-defined metadata to organize NotebookExecutionJobs.
     *
     * Label keys and values can be no longer than 64 characters
     * (Unicode codepoints), can only contain lowercase letters, numeric
     * characters, underscores and dashes. International characters are allowed.
     *
     * See https://goo.gl/xmQnxf for more information and examples of labels.
     * System reserved label keys are prefixed with "aiplatform.googleapis.com/"
     * and are immutable.
     * </pre>
     *
     * <code>map&lt;string, string&gt; labels = 19;</code>
     */
    @java.lang.Override
    public java.util.Map<java.lang.String, java.lang.String> getLabelsMap() {
      return internalGetLabels().getMap();
    }
    /**
     *
     *
     * <pre>
     * The labels with user-defined metadata to organize NotebookExecutionJobs.
     *
     * Label keys and values can be no longer than 64 characters
     * (Unicode codepoints), can only contain lowercase letters, numeric
     * characters, underscores and dashes. International characters are allowed.
     *
     * See https://goo.gl/xmQnxf for more information and examples of labels.
     * System reserved label keys are prefixed with "aiplatform.googleapis.com/"
     * and are immutable.
     * </pre>
     *
     * <code>map&lt;string, string&gt; labels = 19;</code>
     */
    @java.lang.Override
    public /* nullable */ java.lang.String getLabelsOrDefault(
        java.lang.String key,
        /* nullable */
        java.lang.String defaultValue) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      java.util.Map<java.lang.String, java.lang.String> map = internalGetLabels().getMap();
      return map.containsKey(key) ? map.get(key) : defaultValue;
    }
    /**
     *
     *
     * <pre>
     * The labels with user-defined metadata to organize NotebookExecutionJobs.
     *
     * Label keys and values can be no longer than 64 characters
     * (Unicode codepoints), can only contain lowercase letters, numeric
     * characters, underscores and dashes. International characters are allowed.
     *
     * See https://goo.gl/xmQnxf for more information and examples of labels.
     * System reserved label keys are prefixed with "aiplatform.googleapis.com/"
     * and are immutable.
     * </pre>
     *
     * <code>map&lt;string, string&gt; labels = 19;</code>
     */
    @java.lang.Override
    public java.lang.String getLabelsOrThrow(java.lang.String key) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      java.util.Map<java.lang.String, java.lang.String> map = internalGetLabels().getMap();
      if (!map.containsKey(key)) {
        throw new java.lang.IllegalArgumentException();
      }
      return map.get(key);
    }

    public Builder clearLabels() {
      bitField0_ = (bitField0_ & ~0x00008000);
      internalGetMutableLabels().getMutableMap().clear();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The labels with user-defined metadata to organize NotebookExecutionJobs.
     *
     * Label keys and values can be no longer than 64 characters
     * (Unicode codepoints), can only contain lowercase letters, numeric
     * characters, underscores and dashes. International characters are allowed.
     *
     * See https://goo.gl/xmQnxf for more information and examples of labels.
     * System reserved label keys are prefixed with "aiplatform.googleapis.com/"
     * and are immutable.
     * </pre>
     *
     * <code>map&lt;string, string&gt; labels = 19;</code>
     */
    public Builder removeLabels(java.lang.String key) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      internalGetMutableLabels().getMutableMap().remove(key);
      return this;
    }
    /** Use alternate mutation accessors instead. */
    @java.lang.Deprecated
    public java.util.Map<java.lang.String, java.lang.String> getMutableLabels() {
      bitField0_ |= 0x00008000;
      return internalGetMutableLabels().getMutableMap();
    }
    /**
     *
     *
     * <pre>
     * The labels with user-defined metadata to organize NotebookExecutionJobs.
     *
     * Label keys and values can be no longer than 64 characters
     * (Unicode codepoints), can only contain lowercase letters, numeric
     * characters, underscores and dashes. International characters are allowed.
     *
     * See https://goo.gl/xmQnxf for more information and examples of labels.
     * System reserved label keys are prefixed with "aiplatform.googleapis.com/"
     * and are immutable.
     * </pre>
     *
     * <code>map&lt;string, string&gt; labels = 19;</code>
     */
    public Builder putLabels(java.lang.String key, java.lang.String value) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      if (value == null) {
        throw new NullPointerException("map value");
      }
      internalGetMutableLabels().getMutableMap().put(key, value);
      bitField0_ |= 0x00008000;
      return this;
    }
    /**
     *
     *
     * <pre>
     * The labels with user-defined metadata to organize NotebookExecutionJobs.
     *
     * Label keys and values can be no longer than 64 characters
     * (Unicode codepoints), can only contain lowercase letters, numeric
     * characters, underscores and dashes. International characters are allowed.
     *
     * See https://goo.gl/xmQnxf for more information and examples of labels.
     * System reserved label keys are prefixed with "aiplatform.googleapis.com/"
     * and are immutable.
     * </pre>
     *
     * <code>map&lt;string, string&gt; labels = 19;</code>
     */
    public Builder putAllLabels(java.util.Map<java.lang.String, java.lang.String> values) {
      internalGetMutableLabels().getMutableMap().putAll(values);
      bitField0_ |= 0x00008000;
      return this;
    }

    private com.google.cloud.aiplatform.v1beta1.EncryptionSpec encryptionSpec_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.aiplatform.v1beta1.EncryptionSpec,
            com.google.cloud.aiplatform.v1beta1.EncryptionSpec.Builder,
            com.google.cloud.aiplatform.v1beta1.EncryptionSpecOrBuilder>
        encryptionSpecBuilder_;
    /**
     *
     *
     * <pre>
     * Customer-managed encryption key spec for the notebook execution job.
     * This field is auto-populated if the
     * [NotebookService.NotebookRuntimeTemplate][] has an encryption spec.
     * </pre>
     *
     * <code>.google.cloud.aiplatform.v1beta1.EncryptionSpec encryption_spec = 22;</code>
     *
     * @return Whether the encryptionSpec field is set.
     */
    public boolean hasEncryptionSpec() {
      return ((bitField0_ & 0x00010000) != 0);
    }
    /**
     *
     *
     * <pre>
     * Customer-managed encryption key spec for the notebook execution job.
     * This field is auto-populated if the
     * [NotebookService.NotebookRuntimeTemplate][] has an encryption spec.
     * </pre>
     *
     * <code>.google.cloud.aiplatform.v1beta1.EncryptionSpec encryption_spec = 22;</code>
     *
     * @return The encryptionSpec.
     */
    public com.google.cloud.aiplatform.v1beta1.EncryptionSpec getEncryptionSpec() {
      if (encryptionSpecBuilder_ == null) {
        return encryptionSpec_ == null
            ? com.google.cloud.aiplatform.v1beta1.EncryptionSpec.getDefaultInstance()
            : encryptionSpec_;
      } else {
        return encryptionSpecBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Customer-managed encryption key spec for the notebook execution job.
     * This field is auto-populated if the
     * [NotebookService.NotebookRuntimeTemplate][] has an encryption spec.
     * </pre>
     *
     * <code>.google.cloud.aiplatform.v1beta1.EncryptionSpec encryption_spec = 22;</code>
     */
    public Builder setEncryptionSpec(com.google.cloud.aiplatform.v1beta1.EncryptionSpec value) {
      if (encryptionSpecBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        encryptionSpec_ = value;
      } else {
        encryptionSpecBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00010000;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Customer-managed encryption key spec for the notebook execution job.
     * This field is auto-populated if the
     * [NotebookService.NotebookRuntimeTemplate][] has an encryption spec.
     * </pre>
     *
     * <code>.google.cloud.aiplatform.v1beta1.EncryptionSpec encryption_spec = 22;</code>
     */
    public Builder setEncryptionSpec(
        com.google.cloud.aiplatform.v1beta1.EncryptionSpec.Builder builderForValue) {
      if (encryptionSpecBuilder_ == null) {
        encryptionSpec_ = builderForValue.build();
      } else {
        encryptionSpecBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00010000;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Customer-managed encryption key spec for the notebook execution job.
     * This field is auto-populated if the
     * [NotebookService.NotebookRuntimeTemplate][] has an encryption spec.
     * </pre>
     *
     * <code>.google.cloud.aiplatform.v1beta1.EncryptionSpec encryption_spec = 22;</code>
     */
    public Builder mergeEncryptionSpec(com.google.cloud.aiplatform.v1beta1.EncryptionSpec value) {
      if (encryptionSpecBuilder_ == null) {
        if (((bitField0_ & 0x00010000) != 0)
            && encryptionSpec_ != null
            && encryptionSpec_
                != com.google.cloud.aiplatform.v1beta1.EncryptionSpec.getDefaultInstance()) {
          getEncryptionSpecBuilder().mergeFrom(value);
        } else {
          encryptionSpec_ = value;
        }
      } else {
        encryptionSpecBuilder_.mergeFrom(value);
      }
      if (encryptionSpec_ != null) {
        bitField0_ |= 0x00010000;
        onChanged();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Customer-managed encryption key spec for the notebook execution job.
     * This field is auto-populated if the
     * [NotebookService.NotebookRuntimeTemplate][] has an encryption spec.
     * </pre>
     *
     * <code>.google.cloud.aiplatform.v1beta1.EncryptionSpec encryption_spec = 22;</code>
     */
    public Builder clearEncryptionSpec() {
      bitField0_ = (bitField0_ & ~0x00010000);
      encryptionSpec_ = null;
      if (encryptionSpecBuilder_ != null) {
        encryptionSpecBuilder_.dispose();
        encryptionSpecBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Customer-managed encryption key spec for the notebook execution job.
     * This field is auto-populated if the
     * [NotebookService.NotebookRuntimeTemplate][] has an encryption spec.
     * </pre>
     *
     * <code>.google.cloud.aiplatform.v1beta1.EncryptionSpec encryption_spec = 22;</code>
     */
    public com.google.cloud.aiplatform.v1beta1.EncryptionSpec.Builder getEncryptionSpecBuilder() {
      bitField0_ |= 0x00010000;
      onChanged();
      return getEncryptionSpecFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Customer-managed encryption key spec for the notebook execution job.
     * This field is auto-populated if the
     * [NotebookService.NotebookRuntimeTemplate][] has an encryption spec.
     * </pre>
     *
     * <code>.google.cloud.aiplatform.v1beta1.EncryptionSpec encryption_spec = 22;</code>
     */
    public com.google.cloud.aiplatform.v1beta1.EncryptionSpecOrBuilder
        getEncryptionSpecOrBuilder() {
      if (encryptionSpecBuilder_ != null) {
        return encryptionSpecBuilder_.getMessageOrBuilder();
      } else {
        return encryptionSpec_ == null
            ? com.google.cloud.aiplatform.v1beta1.EncryptionSpec.getDefaultInstance()
            : encryptionSpec_;
      }
    }
    /**
     *
     *
     * <pre>
     * Customer-managed encryption key spec for the notebook execution job.
     * This field is auto-populated if the
     * [NotebookService.NotebookRuntimeTemplate][] has an encryption spec.
     * </pre>
     *
     * <code>.google.cloud.aiplatform.v1beta1.EncryptionSpec encryption_spec = 22;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.aiplatform.v1beta1.EncryptionSpec,
            com.google.cloud.aiplatform.v1beta1.EncryptionSpec.Builder,
            com.google.cloud.aiplatform.v1beta1.EncryptionSpecOrBuilder>
        getEncryptionSpecFieldBuilder() {
      if (encryptionSpecBuilder_ == null) {
        encryptionSpecBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.aiplatform.v1beta1.EncryptionSpec,
                com.google.cloud.aiplatform.v1beta1.EncryptionSpec.Builder,
                com.google.cloud.aiplatform.v1beta1.EncryptionSpecOrBuilder>(
                getEncryptionSpec(), getParentForChildren(), isClean());
        encryptionSpec_ = null;
      }
      return encryptionSpecBuilder_;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.cloud.aiplatform.v1beta1.NotebookExecutionJob)
  }

  // @@protoc_insertion_point(class_scope:google.cloud.aiplatform.v1beta1.NotebookExecutionJob)
  private static final com.google.cloud.aiplatform.v1beta1.NotebookExecutionJob DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.cloud.aiplatform.v1beta1.NotebookExecutionJob();
  }

  public static com.google.cloud.aiplatform.v1beta1.NotebookExecutionJob getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<NotebookExecutionJob> PARSER =
      new com.google.protobuf.AbstractParser<NotebookExecutionJob>() {
        @java.lang.Override
        public NotebookExecutionJob parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          Builder builder = newBuilder();
          try {
            builder.mergeFrom(input, extensionRegistry);
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.setUnfinishedMessage(builder.buildPartial());
          } catch (com.google.protobuf.UninitializedMessageException e) {
            throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
          } catch (java.io.IOException e) {
            throw new com.google.protobuf.InvalidProtocolBufferException(e)
                .setUnfinishedMessage(builder.buildPartial());
          }
          return builder.buildPartial();
        }
      };

  public static com.google.protobuf.Parser<NotebookExecutionJob> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<NotebookExecutionJob> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.cloud.aiplatform.v1beta1.NotebookExecutionJob getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
