/*
 * Copyright 2024 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/cloud/aiplatform/v1beta1/pipeline_job.proto

// Protobuf Java Version: 3.25.5
package com.google.cloud.aiplatform.v1beta1;

/**
 *
 *
 * <pre>
 * User provided rerun config to submit a rerun pipelinejob. This includes
 * 1. Which task to rerun
 * 2. User override input parameters and artifacts.
 * </pre>
 *
 * Protobuf type {@code google.cloud.aiplatform.v1beta1.PipelineTaskRerunConfig}
 */
public final class PipelineTaskRerunConfig extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.cloud.aiplatform.v1beta1.PipelineTaskRerunConfig)
    PipelineTaskRerunConfigOrBuilder {
  private static final long serialVersionUID = 0L;
  // Use PipelineTaskRerunConfig.newBuilder() to construct.
  private PipelineTaskRerunConfig(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private PipelineTaskRerunConfig() {
    taskName_ = "";
  }

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new PipelineTaskRerunConfig();
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.cloud.aiplatform.v1beta1.Pipeline
        .internal_static_google_cloud_aiplatform_v1beta1_PipelineTaskRerunConfig_descriptor;
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.cloud.aiplatform.v1beta1.Pipeline
        .internal_static_google_cloud_aiplatform_v1beta1_PipelineTaskRerunConfig_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.cloud.aiplatform.v1beta1.PipelineTaskRerunConfig.class,
            com.google.cloud.aiplatform.v1beta1.PipelineTaskRerunConfig.Builder.class);
  }

  public interface ArtifactListOrBuilder
      extends
      // @@protoc_insertion_point(interface_extends:google.cloud.aiplatform.v1beta1.PipelineTaskRerunConfig.ArtifactList)
      com.google.protobuf.MessageOrBuilder {

    /**
     *
     *
     * <pre>
     * Optional. A list of artifact metadata.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.aiplatform.v1beta1.RuntimeArtifact artifacts = 1 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    java.util.List<com.google.cloud.aiplatform.v1beta1.RuntimeArtifact> getArtifactsList();
    /**
     *
     *
     * <pre>
     * Optional. A list of artifact metadata.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.aiplatform.v1beta1.RuntimeArtifact artifacts = 1 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    com.google.cloud.aiplatform.v1beta1.RuntimeArtifact getArtifacts(int index);
    /**
     *
     *
     * <pre>
     * Optional. A list of artifact metadata.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.aiplatform.v1beta1.RuntimeArtifact artifacts = 1 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    int getArtifactsCount();
    /**
     *
     *
     * <pre>
     * Optional. A list of artifact metadata.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.aiplatform.v1beta1.RuntimeArtifact artifacts = 1 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    java.util.List<? extends com.google.cloud.aiplatform.v1beta1.RuntimeArtifactOrBuilder>
        getArtifactsOrBuilderList();
    /**
     *
     *
     * <pre>
     * Optional. A list of artifact metadata.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.aiplatform.v1beta1.RuntimeArtifact artifacts = 1 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    com.google.cloud.aiplatform.v1beta1.RuntimeArtifactOrBuilder getArtifactsOrBuilder(int index);
  }
  /**
   *
   *
   * <pre>
   * A list of artifact metadata.
   * </pre>
   *
   * Protobuf type {@code google.cloud.aiplatform.v1beta1.PipelineTaskRerunConfig.ArtifactList}
   */
  public static final class ArtifactList extends com.google.protobuf.GeneratedMessageV3
      implements
      // @@protoc_insertion_point(message_implements:google.cloud.aiplatform.v1beta1.PipelineTaskRerunConfig.ArtifactList)
      ArtifactListOrBuilder {
    private static final long serialVersionUID = 0L;
    // Use ArtifactList.newBuilder() to construct.
    private ArtifactList(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
      super(builder);
    }

    private ArtifactList() {
      artifacts_ = java.util.Collections.emptyList();
    }

    @java.lang.Override
    @SuppressWarnings({"unused"})
    protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
      return new ArtifactList();
    }

    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.aiplatform.v1beta1.Pipeline
          .internal_static_google_cloud_aiplatform_v1beta1_PipelineTaskRerunConfig_ArtifactList_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.aiplatform.v1beta1.Pipeline
          .internal_static_google_cloud_aiplatform_v1beta1_PipelineTaskRerunConfig_ArtifactList_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.aiplatform.v1beta1.PipelineTaskRerunConfig.ArtifactList.class,
              com.google.cloud.aiplatform.v1beta1.PipelineTaskRerunConfig.ArtifactList.Builder
                  .class);
    }

    public static final int ARTIFACTS_FIELD_NUMBER = 1;

    @SuppressWarnings("serial")
    private java.util.List<com.google.cloud.aiplatform.v1beta1.RuntimeArtifact> artifacts_;
    /**
     *
     *
     * <pre>
     * Optional. A list of artifact metadata.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.aiplatform.v1beta1.RuntimeArtifact artifacts = 1 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    @java.lang.Override
    public java.util.List<com.google.cloud.aiplatform.v1beta1.RuntimeArtifact> getArtifactsList() {
      return artifacts_;
    }
    /**
     *
     *
     * <pre>
     * Optional. A list of artifact metadata.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.aiplatform.v1beta1.RuntimeArtifact artifacts = 1 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    @java.lang.Override
    public java.util.List<? extends com.google.cloud.aiplatform.v1beta1.RuntimeArtifactOrBuilder>
        getArtifactsOrBuilderList() {
      return artifacts_;
    }
    /**
     *
     *
     * <pre>
     * Optional. A list of artifact metadata.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.aiplatform.v1beta1.RuntimeArtifact artifacts = 1 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    @java.lang.Override
    public int getArtifactsCount() {
      return artifacts_.size();
    }
    /**
     *
     *
     * <pre>
     * Optional. A list of artifact metadata.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.aiplatform.v1beta1.RuntimeArtifact artifacts = 1 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    @java.lang.Override
    public com.google.cloud.aiplatform.v1beta1.RuntimeArtifact getArtifacts(int index) {
      return artifacts_.get(index);
    }
    /**
     *
     *
     * <pre>
     * Optional. A list of artifact metadata.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.aiplatform.v1beta1.RuntimeArtifact artifacts = 1 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    @java.lang.Override
    public com.google.cloud.aiplatform.v1beta1.RuntimeArtifactOrBuilder getArtifactsOrBuilder(
        int index) {
      return artifacts_.get(index);
    }

    private byte memoizedIsInitialized = -1;

    @java.lang.Override
    public final boolean isInitialized() {
      byte isInitialized = memoizedIsInitialized;
      if (isInitialized == 1) return true;
      if (isInitialized == 0) return false;

      memoizedIsInitialized = 1;
      return true;
    }

    @java.lang.Override
    public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
      for (int i = 0; i < artifacts_.size(); i++) {
        output.writeMessage(1, artifacts_.get(i));
      }
      getUnknownFields().writeTo(output);
    }

    @java.lang.Override
    public int getSerializedSize() {
      int size = memoizedSize;
      if (size != -1) return size;

      size = 0;
      for (int i = 0; i < artifacts_.size(); i++) {
        size += com.google.protobuf.CodedOutputStream.computeMessageSize(1, artifacts_.get(i));
      }
      size += getUnknownFields().getSerializedSize();
      memoizedSize = size;
      return size;
    }

    @java.lang.Override
    public boolean equals(final java.lang.Object obj) {
      if (obj == this) {
        return true;
      }
      if (!(obj
          instanceof com.google.cloud.aiplatform.v1beta1.PipelineTaskRerunConfig.ArtifactList)) {
        return super.equals(obj);
      }
      com.google.cloud.aiplatform.v1beta1.PipelineTaskRerunConfig.ArtifactList other =
          (com.google.cloud.aiplatform.v1beta1.PipelineTaskRerunConfig.ArtifactList) obj;

      if (!getArtifactsList().equals(other.getArtifactsList())) return false;
      if (!getUnknownFields().equals(other.getUnknownFields())) return false;
      return true;
    }

    @java.lang.Override
    public int hashCode() {
      if (memoizedHashCode != 0) {
        return memoizedHashCode;
      }
      int hash = 41;
      hash = (19 * hash) + getDescriptor().hashCode();
      if (getArtifactsCount() > 0) {
        hash = (37 * hash) + ARTIFACTS_FIELD_NUMBER;
        hash = (53 * hash) + getArtifactsList().hashCode();
      }
      hash = (29 * hash) + getUnknownFields().hashCode();
      memoizedHashCode = hash;
      return hash;
    }

    public static com.google.cloud.aiplatform.v1beta1.PipelineTaskRerunConfig.ArtifactList
        parseFrom(java.nio.ByteBuffer data)
            throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.aiplatform.v1beta1.PipelineTaskRerunConfig.ArtifactList
        parseFrom(
            java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.aiplatform.v1beta1.PipelineTaskRerunConfig.ArtifactList
        parseFrom(com.google.protobuf.ByteString data)
            throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.aiplatform.v1beta1.PipelineTaskRerunConfig.ArtifactList
        parseFrom(
            com.google.protobuf.ByteString data,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.aiplatform.v1beta1.PipelineTaskRerunConfig.ArtifactList
        parseFrom(byte[] data) throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.aiplatform.v1beta1.PipelineTaskRerunConfig.ArtifactList
        parseFrom(byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.aiplatform.v1beta1.PipelineTaskRerunConfig.ArtifactList
        parseFrom(java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.cloud.aiplatform.v1beta1.PipelineTaskRerunConfig.ArtifactList
        parseFrom(
            java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.cloud.aiplatform.v1beta1.PipelineTaskRerunConfig.ArtifactList
        parseDelimitedFrom(java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
    }

    public static com.google.cloud.aiplatform.v1beta1.PipelineTaskRerunConfig.ArtifactList
        parseDelimitedFrom(
            java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.cloud.aiplatform.v1beta1.PipelineTaskRerunConfig.ArtifactList
        parseFrom(com.google.protobuf.CodedInputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.cloud.aiplatform.v1beta1.PipelineTaskRerunConfig.ArtifactList
        parseFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    @java.lang.Override
    public Builder newBuilderForType() {
      return newBuilder();
    }

    public static Builder newBuilder() {
      return DEFAULT_INSTANCE.toBuilder();
    }

    public static Builder newBuilder(
        com.google.cloud.aiplatform.v1beta1.PipelineTaskRerunConfig.ArtifactList prototype) {
      return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }

    @java.lang.Override
    public Builder toBuilder() {
      return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
    }

    @java.lang.Override
    protected Builder newBuilderForType(
        com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      Builder builder = new Builder(parent);
      return builder;
    }
    /**
     *
     *
     * <pre>
     * A list of artifact metadata.
     * </pre>
     *
     * Protobuf type {@code google.cloud.aiplatform.v1beta1.PipelineTaskRerunConfig.ArtifactList}
     */
    public static final class Builder
        extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
        implements
        // @@protoc_insertion_point(builder_implements:google.cloud.aiplatform.v1beta1.PipelineTaskRerunConfig.ArtifactList)
        com.google.cloud.aiplatform.v1beta1.PipelineTaskRerunConfig.ArtifactListOrBuilder {
      public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
        return com.google.cloud.aiplatform.v1beta1.Pipeline
            .internal_static_google_cloud_aiplatform_v1beta1_PipelineTaskRerunConfig_ArtifactList_descriptor;
      }

      @java.lang.Override
      protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return com.google.cloud.aiplatform.v1beta1.Pipeline
            .internal_static_google_cloud_aiplatform_v1beta1_PipelineTaskRerunConfig_ArtifactList_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                com.google.cloud.aiplatform.v1beta1.PipelineTaskRerunConfig.ArtifactList.class,
                com.google.cloud.aiplatform.v1beta1.PipelineTaskRerunConfig.ArtifactList.Builder
                    .class);
      }

      // Construct using
      // com.google.cloud.aiplatform.v1beta1.PipelineTaskRerunConfig.ArtifactList.newBuilder()
      private Builder() {}

      private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
        super(parent);
      }

      @java.lang.Override
      public Builder clear() {
        super.clear();
        bitField0_ = 0;
        if (artifactsBuilder_ == null) {
          artifacts_ = java.util.Collections.emptyList();
        } else {
          artifacts_ = null;
          artifactsBuilder_.clear();
        }
        bitField0_ = (bitField0_ & ~0x00000001);
        return this;
      }

      @java.lang.Override
      public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
        return com.google.cloud.aiplatform.v1beta1.Pipeline
            .internal_static_google_cloud_aiplatform_v1beta1_PipelineTaskRerunConfig_ArtifactList_descriptor;
      }

      @java.lang.Override
      public com.google.cloud.aiplatform.v1beta1.PipelineTaskRerunConfig.ArtifactList
          getDefaultInstanceForType() {
        return com.google.cloud.aiplatform.v1beta1.PipelineTaskRerunConfig.ArtifactList
            .getDefaultInstance();
      }

      @java.lang.Override
      public com.google.cloud.aiplatform.v1beta1.PipelineTaskRerunConfig.ArtifactList build() {
        com.google.cloud.aiplatform.v1beta1.PipelineTaskRerunConfig.ArtifactList result =
            buildPartial();
        if (!result.isInitialized()) {
          throw newUninitializedMessageException(result);
        }
        return result;
      }

      @java.lang.Override
      public com.google.cloud.aiplatform.v1beta1.PipelineTaskRerunConfig.ArtifactList
          buildPartial() {
        com.google.cloud.aiplatform.v1beta1.PipelineTaskRerunConfig.ArtifactList result =
            new com.google.cloud.aiplatform.v1beta1.PipelineTaskRerunConfig.ArtifactList(this);
        buildPartialRepeatedFields(result);
        if (bitField0_ != 0) {
          buildPartial0(result);
        }
        onBuilt();
        return result;
      }

      private void buildPartialRepeatedFields(
          com.google.cloud.aiplatform.v1beta1.PipelineTaskRerunConfig.ArtifactList result) {
        if (artifactsBuilder_ == null) {
          if (((bitField0_ & 0x00000001) != 0)) {
            artifacts_ = java.util.Collections.unmodifiableList(artifacts_);
            bitField0_ = (bitField0_ & ~0x00000001);
          }
          result.artifacts_ = artifacts_;
        } else {
          result.artifacts_ = artifactsBuilder_.build();
        }
      }

      private void buildPartial0(
          com.google.cloud.aiplatform.v1beta1.PipelineTaskRerunConfig.ArtifactList result) {
        int from_bitField0_ = bitField0_;
      }

      @java.lang.Override
      public Builder clone() {
        return super.clone();
      }

      @java.lang.Override
      public Builder setField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.setField(field, value);
      }

      @java.lang.Override
      public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
        return super.clearField(field);
      }

      @java.lang.Override
      public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
        return super.clearOneof(oneof);
      }

      @java.lang.Override
      public Builder setRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          int index,
          java.lang.Object value) {
        return super.setRepeatedField(field, index, value);
      }

      @java.lang.Override
      public Builder addRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.addRepeatedField(field, value);
      }

      @java.lang.Override
      public Builder mergeFrom(com.google.protobuf.Message other) {
        if (other
            instanceof com.google.cloud.aiplatform.v1beta1.PipelineTaskRerunConfig.ArtifactList) {
          return mergeFrom(
              (com.google.cloud.aiplatform.v1beta1.PipelineTaskRerunConfig.ArtifactList) other);
        } else {
          super.mergeFrom(other);
          return this;
        }
      }

      public Builder mergeFrom(
          com.google.cloud.aiplatform.v1beta1.PipelineTaskRerunConfig.ArtifactList other) {
        if (other
            == com.google.cloud.aiplatform.v1beta1.PipelineTaskRerunConfig.ArtifactList
                .getDefaultInstance()) return this;
        if (artifactsBuilder_ == null) {
          if (!other.artifacts_.isEmpty()) {
            if (artifacts_.isEmpty()) {
              artifacts_ = other.artifacts_;
              bitField0_ = (bitField0_ & ~0x00000001);
            } else {
              ensureArtifactsIsMutable();
              artifacts_.addAll(other.artifacts_);
            }
            onChanged();
          }
        } else {
          if (!other.artifacts_.isEmpty()) {
            if (artifactsBuilder_.isEmpty()) {
              artifactsBuilder_.dispose();
              artifactsBuilder_ = null;
              artifacts_ = other.artifacts_;
              bitField0_ = (bitField0_ & ~0x00000001);
              artifactsBuilder_ =
                  com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders
                      ? getArtifactsFieldBuilder()
                      : null;
            } else {
              artifactsBuilder_.addAllMessages(other.artifacts_);
            }
          }
        }
        this.mergeUnknownFields(other.getUnknownFields());
        onChanged();
        return this;
      }

      @java.lang.Override
      public final boolean isInitialized() {
        return true;
      }

      @java.lang.Override
      public Builder mergeFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        if (extensionRegistry == null) {
          throw new java.lang.NullPointerException();
        }
        try {
          boolean done = false;
          while (!done) {
            int tag = input.readTag();
            switch (tag) {
              case 0:
                done = true;
                break;
              case 10:
                {
                  com.google.cloud.aiplatform.v1beta1.RuntimeArtifact m =
                      input.readMessage(
                          com.google.cloud.aiplatform.v1beta1.RuntimeArtifact.parser(),
                          extensionRegistry);
                  if (artifactsBuilder_ == null) {
                    ensureArtifactsIsMutable();
                    artifacts_.add(m);
                  } else {
                    artifactsBuilder_.addMessage(m);
                  }
                  break;
                } // case 10
              default:
                {
                  if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                    done = true; // was an endgroup tag
                  }
                  break;
                } // default:
            } // switch (tag)
          } // while (!done)
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          throw e.unwrapIOException();
        } finally {
          onChanged();
        } // finally
        return this;
      }

      private int bitField0_;

      private java.util.List<com.google.cloud.aiplatform.v1beta1.RuntimeArtifact> artifacts_ =
          java.util.Collections.emptyList();

      private void ensureArtifactsIsMutable() {
        if (!((bitField0_ & 0x00000001) != 0)) {
          artifacts_ =
              new java.util.ArrayList<com.google.cloud.aiplatform.v1beta1.RuntimeArtifact>(
                  artifacts_);
          bitField0_ |= 0x00000001;
        }
      }

      private com.google.protobuf.RepeatedFieldBuilderV3<
              com.google.cloud.aiplatform.v1beta1.RuntimeArtifact,
              com.google.cloud.aiplatform.v1beta1.RuntimeArtifact.Builder,
              com.google.cloud.aiplatform.v1beta1.RuntimeArtifactOrBuilder>
          artifactsBuilder_;

      /**
       *
       *
       * <pre>
       * Optional. A list of artifact metadata.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.aiplatform.v1beta1.RuntimeArtifact artifacts = 1 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       */
      public java.util.List<com.google.cloud.aiplatform.v1beta1.RuntimeArtifact>
          getArtifactsList() {
        if (artifactsBuilder_ == null) {
          return java.util.Collections.unmodifiableList(artifacts_);
        } else {
          return artifactsBuilder_.getMessageList();
        }
      }
      /**
       *
       *
       * <pre>
       * Optional. A list of artifact metadata.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.aiplatform.v1beta1.RuntimeArtifact artifacts = 1 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       */
      public int getArtifactsCount() {
        if (artifactsBuilder_ == null) {
          return artifacts_.size();
        } else {
          return artifactsBuilder_.getCount();
        }
      }
      /**
       *
       *
       * <pre>
       * Optional. A list of artifact metadata.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.aiplatform.v1beta1.RuntimeArtifact artifacts = 1 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       */
      public com.google.cloud.aiplatform.v1beta1.RuntimeArtifact getArtifacts(int index) {
        if (artifactsBuilder_ == null) {
          return artifacts_.get(index);
        } else {
          return artifactsBuilder_.getMessage(index);
        }
      }
      /**
       *
       *
       * <pre>
       * Optional. A list of artifact metadata.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.aiplatform.v1beta1.RuntimeArtifact artifacts = 1 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       */
      public Builder setArtifacts(
          int index, com.google.cloud.aiplatform.v1beta1.RuntimeArtifact value) {
        if (artifactsBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          ensureArtifactsIsMutable();
          artifacts_.set(index, value);
          onChanged();
        } else {
          artifactsBuilder_.setMessage(index, value);
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * Optional. A list of artifact metadata.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.aiplatform.v1beta1.RuntimeArtifact artifacts = 1 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       */
      public Builder setArtifacts(
          int index, com.google.cloud.aiplatform.v1beta1.RuntimeArtifact.Builder builderForValue) {
        if (artifactsBuilder_ == null) {
          ensureArtifactsIsMutable();
          artifacts_.set(index, builderForValue.build());
          onChanged();
        } else {
          artifactsBuilder_.setMessage(index, builderForValue.build());
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * Optional. A list of artifact metadata.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.aiplatform.v1beta1.RuntimeArtifact artifacts = 1 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       */
      public Builder addArtifacts(com.google.cloud.aiplatform.v1beta1.RuntimeArtifact value) {
        if (artifactsBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          ensureArtifactsIsMutable();
          artifacts_.add(value);
          onChanged();
        } else {
          artifactsBuilder_.addMessage(value);
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * Optional. A list of artifact metadata.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.aiplatform.v1beta1.RuntimeArtifact artifacts = 1 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       */
      public Builder addArtifacts(
          int index, com.google.cloud.aiplatform.v1beta1.RuntimeArtifact value) {
        if (artifactsBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          ensureArtifactsIsMutable();
          artifacts_.add(index, value);
          onChanged();
        } else {
          artifactsBuilder_.addMessage(index, value);
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * Optional. A list of artifact metadata.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.aiplatform.v1beta1.RuntimeArtifact artifacts = 1 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       */
      public Builder addArtifacts(
          com.google.cloud.aiplatform.v1beta1.RuntimeArtifact.Builder builderForValue) {
        if (artifactsBuilder_ == null) {
          ensureArtifactsIsMutable();
          artifacts_.add(builderForValue.build());
          onChanged();
        } else {
          artifactsBuilder_.addMessage(builderForValue.build());
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * Optional. A list of artifact metadata.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.aiplatform.v1beta1.RuntimeArtifact artifacts = 1 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       */
      public Builder addArtifacts(
          int index, com.google.cloud.aiplatform.v1beta1.RuntimeArtifact.Builder builderForValue) {
        if (artifactsBuilder_ == null) {
          ensureArtifactsIsMutable();
          artifacts_.add(index, builderForValue.build());
          onChanged();
        } else {
          artifactsBuilder_.addMessage(index, builderForValue.build());
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * Optional. A list of artifact metadata.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.aiplatform.v1beta1.RuntimeArtifact artifacts = 1 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       */
      public Builder addAllArtifacts(
          java.lang.Iterable<? extends com.google.cloud.aiplatform.v1beta1.RuntimeArtifact>
              values) {
        if (artifactsBuilder_ == null) {
          ensureArtifactsIsMutable();
          com.google.protobuf.AbstractMessageLite.Builder.addAll(values, artifacts_);
          onChanged();
        } else {
          artifactsBuilder_.addAllMessages(values);
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * Optional. A list of artifact metadata.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.aiplatform.v1beta1.RuntimeArtifact artifacts = 1 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       */
      public Builder clearArtifacts() {
        if (artifactsBuilder_ == null) {
          artifacts_ = java.util.Collections.emptyList();
          bitField0_ = (bitField0_ & ~0x00000001);
          onChanged();
        } else {
          artifactsBuilder_.clear();
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * Optional. A list of artifact metadata.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.aiplatform.v1beta1.RuntimeArtifact artifacts = 1 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       */
      public Builder removeArtifacts(int index) {
        if (artifactsBuilder_ == null) {
          ensureArtifactsIsMutable();
          artifacts_.remove(index);
          onChanged();
        } else {
          artifactsBuilder_.remove(index);
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * Optional. A list of artifact metadata.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.aiplatform.v1beta1.RuntimeArtifact artifacts = 1 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       */
      public com.google.cloud.aiplatform.v1beta1.RuntimeArtifact.Builder getArtifactsBuilder(
          int index) {
        return getArtifactsFieldBuilder().getBuilder(index);
      }
      /**
       *
       *
       * <pre>
       * Optional. A list of artifact metadata.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.aiplatform.v1beta1.RuntimeArtifact artifacts = 1 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       */
      public com.google.cloud.aiplatform.v1beta1.RuntimeArtifactOrBuilder getArtifactsOrBuilder(
          int index) {
        if (artifactsBuilder_ == null) {
          return artifacts_.get(index);
        } else {
          return artifactsBuilder_.getMessageOrBuilder(index);
        }
      }
      /**
       *
       *
       * <pre>
       * Optional. A list of artifact metadata.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.aiplatform.v1beta1.RuntimeArtifact artifacts = 1 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       */
      public java.util.List<? extends com.google.cloud.aiplatform.v1beta1.RuntimeArtifactOrBuilder>
          getArtifactsOrBuilderList() {
        if (artifactsBuilder_ != null) {
          return artifactsBuilder_.getMessageOrBuilderList();
        } else {
          return java.util.Collections.unmodifiableList(artifacts_);
        }
      }
      /**
       *
       *
       * <pre>
       * Optional. A list of artifact metadata.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.aiplatform.v1beta1.RuntimeArtifact artifacts = 1 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       */
      public com.google.cloud.aiplatform.v1beta1.RuntimeArtifact.Builder addArtifactsBuilder() {
        return getArtifactsFieldBuilder()
            .addBuilder(com.google.cloud.aiplatform.v1beta1.RuntimeArtifact.getDefaultInstance());
      }
      /**
       *
       *
       * <pre>
       * Optional. A list of artifact metadata.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.aiplatform.v1beta1.RuntimeArtifact artifacts = 1 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       */
      public com.google.cloud.aiplatform.v1beta1.RuntimeArtifact.Builder addArtifactsBuilder(
          int index) {
        return getArtifactsFieldBuilder()
            .addBuilder(
                index, com.google.cloud.aiplatform.v1beta1.RuntimeArtifact.getDefaultInstance());
      }
      /**
       *
       *
       * <pre>
       * Optional. A list of artifact metadata.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.aiplatform.v1beta1.RuntimeArtifact artifacts = 1 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       */
      public java.util.List<com.google.cloud.aiplatform.v1beta1.RuntimeArtifact.Builder>
          getArtifactsBuilderList() {
        return getArtifactsFieldBuilder().getBuilderList();
      }

      private com.google.protobuf.RepeatedFieldBuilderV3<
              com.google.cloud.aiplatform.v1beta1.RuntimeArtifact,
              com.google.cloud.aiplatform.v1beta1.RuntimeArtifact.Builder,
              com.google.cloud.aiplatform.v1beta1.RuntimeArtifactOrBuilder>
          getArtifactsFieldBuilder() {
        if (artifactsBuilder_ == null) {
          artifactsBuilder_ =
              new com.google.protobuf.RepeatedFieldBuilderV3<
                  com.google.cloud.aiplatform.v1beta1.RuntimeArtifact,
                  com.google.cloud.aiplatform.v1beta1.RuntimeArtifact.Builder,
                  com.google.cloud.aiplatform.v1beta1.RuntimeArtifactOrBuilder>(
                  artifacts_, ((bitField0_ & 0x00000001) != 0), getParentForChildren(), isClean());
          artifacts_ = null;
        }
        return artifactsBuilder_;
      }

      @java.lang.Override
      public final Builder setUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.setUnknownFields(unknownFields);
      }

      @java.lang.Override
      public final Builder mergeUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.mergeUnknownFields(unknownFields);
      }

      // @@protoc_insertion_point(builder_scope:google.cloud.aiplatform.v1beta1.PipelineTaskRerunConfig.ArtifactList)
    }

    // @@protoc_insertion_point(class_scope:google.cloud.aiplatform.v1beta1.PipelineTaskRerunConfig.ArtifactList)
    private static final com.google.cloud.aiplatform.v1beta1.PipelineTaskRerunConfig.ArtifactList
        DEFAULT_INSTANCE;

    static {
      DEFAULT_INSTANCE =
          new com.google.cloud.aiplatform.v1beta1.PipelineTaskRerunConfig.ArtifactList();
    }

    public static com.google.cloud.aiplatform.v1beta1.PipelineTaskRerunConfig.ArtifactList
        getDefaultInstance() {
      return DEFAULT_INSTANCE;
    }

    private static final com.google.protobuf.Parser<ArtifactList> PARSER =
        new com.google.protobuf.AbstractParser<ArtifactList>() {
          @java.lang.Override
          public ArtifactList parsePartialFrom(
              com.google.protobuf.CodedInputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
            Builder builder = newBuilder();
            try {
              builder.mergeFrom(input, extensionRegistry);
            } catch (com.google.protobuf.InvalidProtocolBufferException e) {
              throw e.setUnfinishedMessage(builder.buildPartial());
            } catch (com.google.protobuf.UninitializedMessageException e) {
              throw e.asInvalidProtocolBufferException()
                  .setUnfinishedMessage(builder.buildPartial());
            } catch (java.io.IOException e) {
              throw new com.google.protobuf.InvalidProtocolBufferException(e)
                  .setUnfinishedMessage(builder.buildPartial());
            }
            return builder.buildPartial();
          }
        };

    public static com.google.protobuf.Parser<ArtifactList> parser() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.protobuf.Parser<ArtifactList> getParserForType() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.cloud.aiplatform.v1beta1.PipelineTaskRerunConfig.ArtifactList
        getDefaultInstanceForType() {
      return DEFAULT_INSTANCE;
    }
  }

  public interface InputsOrBuilder
      extends
      // @@protoc_insertion_point(interface_extends:google.cloud.aiplatform.v1beta1.PipelineTaskRerunConfig.Inputs)
      com.google.protobuf.MessageOrBuilder {

    /**
     *
     *
     * <pre>
     * Optional. Input artifacts.
     * </pre>
     *
     * <code>
     * map&lt;string, .google.cloud.aiplatform.v1beta1.PipelineTaskRerunConfig.ArtifactList&gt; artifacts = 1 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    int getArtifactsCount();
    /**
     *
     *
     * <pre>
     * Optional. Input artifacts.
     * </pre>
     *
     * <code>
     * map&lt;string, .google.cloud.aiplatform.v1beta1.PipelineTaskRerunConfig.ArtifactList&gt; artifacts = 1 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    boolean containsArtifacts(java.lang.String key);
    /** Use {@link #getArtifactsMap()} instead. */
    @java.lang.Deprecated
    java.util.Map<
            java.lang.String,
            com.google.cloud.aiplatform.v1beta1.PipelineTaskRerunConfig.ArtifactList>
        getArtifacts();
    /**
     *
     *
     * <pre>
     * Optional. Input artifacts.
     * </pre>
     *
     * <code>
     * map&lt;string, .google.cloud.aiplatform.v1beta1.PipelineTaskRerunConfig.ArtifactList&gt; artifacts = 1 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    java.util.Map<
            java.lang.String,
            com.google.cloud.aiplatform.v1beta1.PipelineTaskRerunConfig.ArtifactList>
        getArtifactsMap();
    /**
     *
     *
     * <pre>
     * Optional. Input artifacts.
     * </pre>
     *
     * <code>
     * map&lt;string, .google.cloud.aiplatform.v1beta1.PipelineTaskRerunConfig.ArtifactList&gt; artifacts = 1 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    /* nullable */
    com.google.cloud.aiplatform.v1beta1.PipelineTaskRerunConfig.ArtifactList getArtifactsOrDefault(
        java.lang.String key,
        /* nullable */
        com.google.cloud.aiplatform.v1beta1.PipelineTaskRerunConfig.ArtifactList defaultValue);
    /**
     *
     *
     * <pre>
     * Optional. Input artifacts.
     * </pre>
     *
     * <code>
     * map&lt;string, .google.cloud.aiplatform.v1beta1.PipelineTaskRerunConfig.ArtifactList&gt; artifacts = 1 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    com.google.cloud.aiplatform.v1beta1.PipelineTaskRerunConfig.ArtifactList getArtifactsOrThrow(
        java.lang.String key);

    /**
     *
     *
     * <pre>
     * Optional. Input parameters.
     * </pre>
     *
     * <code>
     * map&lt;string, .google.protobuf.Value&gt; parameter_values = 2 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    int getParameterValuesCount();
    /**
     *
     *
     * <pre>
     * Optional. Input parameters.
     * </pre>
     *
     * <code>
     * map&lt;string, .google.protobuf.Value&gt; parameter_values = 2 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    boolean containsParameterValues(java.lang.String key);
    /** Use {@link #getParameterValuesMap()} instead. */
    @java.lang.Deprecated
    java.util.Map<java.lang.String, com.google.protobuf.Value> getParameterValues();
    /**
     *
     *
     * <pre>
     * Optional. Input parameters.
     * </pre>
     *
     * <code>
     * map&lt;string, .google.protobuf.Value&gt; parameter_values = 2 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    java.util.Map<java.lang.String, com.google.protobuf.Value> getParameterValuesMap();
    /**
     *
     *
     * <pre>
     * Optional. Input parameters.
     * </pre>
     *
     * <code>
     * map&lt;string, .google.protobuf.Value&gt; parameter_values = 2 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    /* nullable */
    com.google.protobuf.Value getParameterValuesOrDefault(
        java.lang.String key,
        /* nullable */
        com.google.protobuf.Value defaultValue);
    /**
     *
     *
     * <pre>
     * Optional. Input parameters.
     * </pre>
     *
     * <code>
     * map&lt;string, .google.protobuf.Value&gt; parameter_values = 2 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    com.google.protobuf.Value getParameterValuesOrThrow(java.lang.String key);
  }
  /**
   *
   *
   * <pre>
   * Runtime inputs data of the task.
   * </pre>
   *
   * Protobuf type {@code google.cloud.aiplatform.v1beta1.PipelineTaskRerunConfig.Inputs}
   */
  public static final class Inputs extends com.google.protobuf.GeneratedMessageV3
      implements
      // @@protoc_insertion_point(message_implements:google.cloud.aiplatform.v1beta1.PipelineTaskRerunConfig.Inputs)
      InputsOrBuilder {
    private static final long serialVersionUID = 0L;
    // Use Inputs.newBuilder() to construct.
    private Inputs(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
      super(builder);
    }

    private Inputs() {}

    @java.lang.Override
    @SuppressWarnings({"unused"})
    protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
      return new Inputs();
    }

    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.aiplatform.v1beta1.Pipeline
          .internal_static_google_cloud_aiplatform_v1beta1_PipelineTaskRerunConfig_Inputs_descriptor;
    }

    @SuppressWarnings({"rawtypes"})
    @java.lang.Override
    protected com.google.protobuf.MapFieldReflectionAccessor internalGetMapFieldReflection(
        int number) {
      switch (number) {
        case 1:
          return internalGetArtifacts();
        case 2:
          return internalGetParameterValues();
        default:
          throw new RuntimeException("Invalid map field number: " + number);
      }
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.aiplatform.v1beta1.Pipeline
          .internal_static_google_cloud_aiplatform_v1beta1_PipelineTaskRerunConfig_Inputs_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.aiplatform.v1beta1.PipelineTaskRerunConfig.Inputs.class,
              com.google.cloud.aiplatform.v1beta1.PipelineTaskRerunConfig.Inputs.Builder.class);
    }

    public static final int ARTIFACTS_FIELD_NUMBER = 1;

    private static final class ArtifactsDefaultEntryHolder {
      static final com.google.protobuf.MapEntry<
              java.lang.String,
              com.google.cloud.aiplatform.v1beta1.PipelineTaskRerunConfig.ArtifactList>
          defaultEntry =
              com.google.protobuf.MapEntry
                  .<java.lang.String,
                      com.google.cloud.aiplatform.v1beta1.PipelineTaskRerunConfig.ArtifactList>
                      newDefaultInstance(
                          com.google.cloud.aiplatform.v1beta1.Pipeline
                              .internal_static_google_cloud_aiplatform_v1beta1_PipelineTaskRerunConfig_Inputs_ArtifactsEntry_descriptor,
                          com.google.protobuf.WireFormat.FieldType.STRING,
                          "",
                          com.google.protobuf.WireFormat.FieldType.MESSAGE,
                          com.google.cloud.aiplatform.v1beta1.PipelineTaskRerunConfig.ArtifactList
                              .getDefaultInstance());
    }

    @SuppressWarnings("serial")
    private com.google.protobuf.MapField<
            java.lang.String,
            com.google.cloud.aiplatform.v1beta1.PipelineTaskRerunConfig.ArtifactList>
        artifacts_;

    private com.google.protobuf.MapField<
            java.lang.String,
            com.google.cloud.aiplatform.v1beta1.PipelineTaskRerunConfig.ArtifactList>
        internalGetArtifacts() {
      if (artifacts_ == null) {
        return com.google.protobuf.MapField.emptyMapField(ArtifactsDefaultEntryHolder.defaultEntry);
      }
      return artifacts_;
    }

    public int getArtifactsCount() {
      return internalGetArtifacts().getMap().size();
    }
    /**
     *
     *
     * <pre>
     * Optional. Input artifacts.
     * </pre>
     *
     * <code>
     * map&lt;string, .google.cloud.aiplatform.v1beta1.PipelineTaskRerunConfig.ArtifactList&gt; artifacts = 1 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    @java.lang.Override
    public boolean containsArtifacts(java.lang.String key) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      return internalGetArtifacts().getMap().containsKey(key);
    }
    /** Use {@link #getArtifactsMap()} instead. */
    @java.lang.Override
    @java.lang.Deprecated
    public java.util.Map<
            java.lang.String,
            com.google.cloud.aiplatform.v1beta1.PipelineTaskRerunConfig.ArtifactList>
        getArtifacts() {
      return getArtifactsMap();
    }
    /**
     *
     *
     * <pre>
     * Optional. Input artifacts.
     * </pre>
     *
     * <code>
     * map&lt;string, .google.cloud.aiplatform.v1beta1.PipelineTaskRerunConfig.ArtifactList&gt; artifacts = 1 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    @java.lang.Override
    public java.util.Map<
            java.lang.String,
            com.google.cloud.aiplatform.v1beta1.PipelineTaskRerunConfig.ArtifactList>
        getArtifactsMap() {
      return internalGetArtifacts().getMap();
    }
    /**
     *
     *
     * <pre>
     * Optional. Input artifacts.
     * </pre>
     *
     * <code>
     * map&lt;string, .google.cloud.aiplatform.v1beta1.PipelineTaskRerunConfig.ArtifactList&gt; artifacts = 1 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    @java.lang.Override
    public /* nullable */ com.google.cloud.aiplatform.v1beta1.PipelineTaskRerunConfig.ArtifactList
        getArtifactsOrDefault(
            java.lang.String key,
            /* nullable */
            com.google.cloud.aiplatform.v1beta1.PipelineTaskRerunConfig.ArtifactList defaultValue) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      java.util.Map<
              java.lang.String,
              com.google.cloud.aiplatform.v1beta1.PipelineTaskRerunConfig.ArtifactList>
          map = internalGetArtifacts().getMap();
      return map.containsKey(key) ? map.get(key) : defaultValue;
    }
    /**
     *
     *
     * <pre>
     * Optional. Input artifacts.
     * </pre>
     *
     * <code>
     * map&lt;string, .google.cloud.aiplatform.v1beta1.PipelineTaskRerunConfig.ArtifactList&gt; artifacts = 1 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    @java.lang.Override
    public com.google.cloud.aiplatform.v1beta1.PipelineTaskRerunConfig.ArtifactList
        getArtifactsOrThrow(java.lang.String key) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      java.util.Map<
              java.lang.String,
              com.google.cloud.aiplatform.v1beta1.PipelineTaskRerunConfig.ArtifactList>
          map = internalGetArtifacts().getMap();
      if (!map.containsKey(key)) {
        throw new java.lang.IllegalArgumentException();
      }
      return map.get(key);
    }

    public static final int PARAMETER_VALUES_FIELD_NUMBER = 2;

    private static final class ParameterValuesDefaultEntryHolder {
      static final com.google.protobuf.MapEntry<java.lang.String, com.google.protobuf.Value>
          defaultEntry =
              com.google.protobuf.MapEntry
                  .<java.lang.String, com.google.protobuf.Value>newDefaultInstance(
                      com.google.cloud.aiplatform.v1beta1.Pipeline
                          .internal_static_google_cloud_aiplatform_v1beta1_PipelineTaskRerunConfig_Inputs_ParameterValuesEntry_descriptor,
                      com.google.protobuf.WireFormat.FieldType.STRING,
                      "",
                      com.google.protobuf.WireFormat.FieldType.MESSAGE,
                      com.google.protobuf.Value.getDefaultInstance());
    }

    @SuppressWarnings("serial")
    private com.google.protobuf.MapField<java.lang.String, com.google.protobuf.Value>
        parameterValues_;

    private com.google.protobuf.MapField<java.lang.String, com.google.protobuf.Value>
        internalGetParameterValues() {
      if (parameterValues_ == null) {
        return com.google.protobuf.MapField.emptyMapField(
            ParameterValuesDefaultEntryHolder.defaultEntry);
      }
      return parameterValues_;
    }

    public int getParameterValuesCount() {
      return internalGetParameterValues().getMap().size();
    }
    /**
     *
     *
     * <pre>
     * Optional. Input parameters.
     * </pre>
     *
     * <code>
     * map&lt;string, .google.protobuf.Value&gt; parameter_values = 2 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    @java.lang.Override
    public boolean containsParameterValues(java.lang.String key) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      return internalGetParameterValues().getMap().containsKey(key);
    }
    /** Use {@link #getParameterValuesMap()} instead. */
    @java.lang.Override
    @java.lang.Deprecated
    public java.util.Map<java.lang.String, com.google.protobuf.Value> getParameterValues() {
      return getParameterValuesMap();
    }
    /**
     *
     *
     * <pre>
     * Optional. Input parameters.
     * </pre>
     *
     * <code>
     * map&lt;string, .google.protobuf.Value&gt; parameter_values = 2 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    @java.lang.Override
    public java.util.Map<java.lang.String, com.google.protobuf.Value> getParameterValuesMap() {
      return internalGetParameterValues().getMap();
    }
    /**
     *
     *
     * <pre>
     * Optional. Input parameters.
     * </pre>
     *
     * <code>
     * map&lt;string, .google.protobuf.Value&gt; parameter_values = 2 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    @java.lang.Override
    public /* nullable */ com.google.protobuf.Value getParameterValuesOrDefault(
        java.lang.String key,
        /* nullable */
        com.google.protobuf.Value defaultValue) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      java.util.Map<java.lang.String, com.google.protobuf.Value> map =
          internalGetParameterValues().getMap();
      return map.containsKey(key) ? map.get(key) : defaultValue;
    }
    /**
     *
     *
     * <pre>
     * Optional. Input parameters.
     * </pre>
     *
     * <code>
     * map&lt;string, .google.protobuf.Value&gt; parameter_values = 2 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    @java.lang.Override
    public com.google.protobuf.Value getParameterValuesOrThrow(java.lang.String key) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      java.util.Map<java.lang.String, com.google.protobuf.Value> map =
          internalGetParameterValues().getMap();
      if (!map.containsKey(key)) {
        throw new java.lang.IllegalArgumentException();
      }
      return map.get(key);
    }

    private byte memoizedIsInitialized = -1;

    @java.lang.Override
    public final boolean isInitialized() {
      byte isInitialized = memoizedIsInitialized;
      if (isInitialized == 1) return true;
      if (isInitialized == 0) return false;

      memoizedIsInitialized = 1;
      return true;
    }

    @java.lang.Override
    public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
      com.google.protobuf.GeneratedMessageV3.serializeStringMapTo(
          output, internalGetArtifacts(), ArtifactsDefaultEntryHolder.defaultEntry, 1);
      com.google.protobuf.GeneratedMessageV3.serializeStringMapTo(
          output, internalGetParameterValues(), ParameterValuesDefaultEntryHolder.defaultEntry, 2);
      getUnknownFields().writeTo(output);
    }

    @java.lang.Override
    public int getSerializedSize() {
      int size = memoizedSize;
      if (size != -1) return size;

      size = 0;
      for (java.util.Map.Entry<
              java.lang.String,
              com.google.cloud.aiplatform.v1beta1.PipelineTaskRerunConfig.ArtifactList>
          entry : internalGetArtifacts().getMap().entrySet()) {
        com.google.protobuf.MapEntry<
                java.lang.String,
                com.google.cloud.aiplatform.v1beta1.PipelineTaskRerunConfig.ArtifactList>
            artifacts__ =
                ArtifactsDefaultEntryHolder.defaultEntry
                    .newBuilderForType()
                    .setKey(entry.getKey())
                    .setValue(entry.getValue())
                    .build();
        size += com.google.protobuf.CodedOutputStream.computeMessageSize(1, artifacts__);
      }
      for (java.util.Map.Entry<java.lang.String, com.google.protobuf.Value> entry :
          internalGetParameterValues().getMap().entrySet()) {
        com.google.protobuf.MapEntry<java.lang.String, com.google.protobuf.Value>
            parameterValues__ =
                ParameterValuesDefaultEntryHolder.defaultEntry
                    .newBuilderForType()
                    .setKey(entry.getKey())
                    .setValue(entry.getValue())
                    .build();
        size += com.google.protobuf.CodedOutputStream.computeMessageSize(2, parameterValues__);
      }
      size += getUnknownFields().getSerializedSize();
      memoizedSize = size;
      return size;
    }

    @java.lang.Override
    public boolean equals(final java.lang.Object obj) {
      if (obj == this) {
        return true;
      }
      if (!(obj instanceof com.google.cloud.aiplatform.v1beta1.PipelineTaskRerunConfig.Inputs)) {
        return super.equals(obj);
      }
      com.google.cloud.aiplatform.v1beta1.PipelineTaskRerunConfig.Inputs other =
          (com.google.cloud.aiplatform.v1beta1.PipelineTaskRerunConfig.Inputs) obj;

      if (!internalGetArtifacts().equals(other.internalGetArtifacts())) return false;
      if (!internalGetParameterValues().equals(other.internalGetParameterValues())) return false;
      if (!getUnknownFields().equals(other.getUnknownFields())) return false;
      return true;
    }

    @java.lang.Override
    public int hashCode() {
      if (memoizedHashCode != 0) {
        return memoizedHashCode;
      }
      int hash = 41;
      hash = (19 * hash) + getDescriptor().hashCode();
      if (!internalGetArtifacts().getMap().isEmpty()) {
        hash = (37 * hash) + ARTIFACTS_FIELD_NUMBER;
        hash = (53 * hash) + internalGetArtifacts().hashCode();
      }
      if (!internalGetParameterValues().getMap().isEmpty()) {
        hash = (37 * hash) + PARAMETER_VALUES_FIELD_NUMBER;
        hash = (53 * hash) + internalGetParameterValues().hashCode();
      }
      hash = (29 * hash) + getUnknownFields().hashCode();
      memoizedHashCode = hash;
      return hash;
    }

    public static com.google.cloud.aiplatform.v1beta1.PipelineTaskRerunConfig.Inputs parseFrom(
        java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.aiplatform.v1beta1.PipelineTaskRerunConfig.Inputs parseFrom(
        java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.aiplatform.v1beta1.PipelineTaskRerunConfig.Inputs parseFrom(
        com.google.protobuf.ByteString data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.aiplatform.v1beta1.PipelineTaskRerunConfig.Inputs parseFrom(
        com.google.protobuf.ByteString data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.aiplatform.v1beta1.PipelineTaskRerunConfig.Inputs parseFrom(
        byte[] data) throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.aiplatform.v1beta1.PipelineTaskRerunConfig.Inputs parseFrom(
        byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.aiplatform.v1beta1.PipelineTaskRerunConfig.Inputs parseFrom(
        java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.cloud.aiplatform.v1beta1.PipelineTaskRerunConfig.Inputs parseFrom(
        java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.cloud.aiplatform.v1beta1.PipelineTaskRerunConfig.Inputs
        parseDelimitedFrom(java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
    }

    public static com.google.cloud.aiplatform.v1beta1.PipelineTaskRerunConfig.Inputs
        parseDelimitedFrom(
            java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.cloud.aiplatform.v1beta1.PipelineTaskRerunConfig.Inputs parseFrom(
        com.google.protobuf.CodedInputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.cloud.aiplatform.v1beta1.PipelineTaskRerunConfig.Inputs parseFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    @java.lang.Override
    public Builder newBuilderForType() {
      return newBuilder();
    }

    public static Builder newBuilder() {
      return DEFAULT_INSTANCE.toBuilder();
    }

    public static Builder newBuilder(
        com.google.cloud.aiplatform.v1beta1.PipelineTaskRerunConfig.Inputs prototype) {
      return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }

    @java.lang.Override
    public Builder toBuilder() {
      return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
    }

    @java.lang.Override
    protected Builder newBuilderForType(
        com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      Builder builder = new Builder(parent);
      return builder;
    }
    /**
     *
     *
     * <pre>
     * Runtime inputs data of the task.
     * </pre>
     *
     * Protobuf type {@code google.cloud.aiplatform.v1beta1.PipelineTaskRerunConfig.Inputs}
     */
    public static final class Builder
        extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
        implements
        // @@protoc_insertion_point(builder_implements:google.cloud.aiplatform.v1beta1.PipelineTaskRerunConfig.Inputs)
        com.google.cloud.aiplatform.v1beta1.PipelineTaskRerunConfig.InputsOrBuilder {
      public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
        return com.google.cloud.aiplatform.v1beta1.Pipeline
            .internal_static_google_cloud_aiplatform_v1beta1_PipelineTaskRerunConfig_Inputs_descriptor;
      }

      @SuppressWarnings({"rawtypes"})
      protected com.google.protobuf.MapFieldReflectionAccessor internalGetMapFieldReflection(
          int number) {
        switch (number) {
          case 1:
            return internalGetArtifacts();
          case 2:
            return internalGetParameterValues();
          default:
            throw new RuntimeException("Invalid map field number: " + number);
        }
      }

      @SuppressWarnings({"rawtypes"})
      protected com.google.protobuf.MapFieldReflectionAccessor internalGetMutableMapFieldReflection(
          int number) {
        switch (number) {
          case 1:
            return internalGetMutableArtifacts();
          case 2:
            return internalGetMutableParameterValues();
          default:
            throw new RuntimeException("Invalid map field number: " + number);
        }
      }

      @java.lang.Override
      protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return com.google.cloud.aiplatform.v1beta1.Pipeline
            .internal_static_google_cloud_aiplatform_v1beta1_PipelineTaskRerunConfig_Inputs_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                com.google.cloud.aiplatform.v1beta1.PipelineTaskRerunConfig.Inputs.class,
                com.google.cloud.aiplatform.v1beta1.PipelineTaskRerunConfig.Inputs.Builder.class);
      }

      // Construct using
      // com.google.cloud.aiplatform.v1beta1.PipelineTaskRerunConfig.Inputs.newBuilder()
      private Builder() {}

      private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
        super(parent);
      }

      @java.lang.Override
      public Builder clear() {
        super.clear();
        bitField0_ = 0;
        internalGetMutableArtifacts().clear();
        internalGetMutableParameterValues().clear();
        return this;
      }

      @java.lang.Override
      public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
        return com.google.cloud.aiplatform.v1beta1.Pipeline
            .internal_static_google_cloud_aiplatform_v1beta1_PipelineTaskRerunConfig_Inputs_descriptor;
      }

      @java.lang.Override
      public com.google.cloud.aiplatform.v1beta1.PipelineTaskRerunConfig.Inputs
          getDefaultInstanceForType() {
        return com.google.cloud.aiplatform.v1beta1.PipelineTaskRerunConfig.Inputs
            .getDefaultInstance();
      }

      @java.lang.Override
      public com.google.cloud.aiplatform.v1beta1.PipelineTaskRerunConfig.Inputs build() {
        com.google.cloud.aiplatform.v1beta1.PipelineTaskRerunConfig.Inputs result = buildPartial();
        if (!result.isInitialized()) {
          throw newUninitializedMessageException(result);
        }
        return result;
      }

      @java.lang.Override
      public com.google.cloud.aiplatform.v1beta1.PipelineTaskRerunConfig.Inputs buildPartial() {
        com.google.cloud.aiplatform.v1beta1.PipelineTaskRerunConfig.Inputs result =
            new com.google.cloud.aiplatform.v1beta1.PipelineTaskRerunConfig.Inputs(this);
        if (bitField0_ != 0) {
          buildPartial0(result);
        }
        onBuilt();
        return result;
      }

      private void buildPartial0(
          com.google.cloud.aiplatform.v1beta1.PipelineTaskRerunConfig.Inputs result) {
        int from_bitField0_ = bitField0_;
        if (((from_bitField0_ & 0x00000001) != 0)) {
          result.artifacts_ =
              internalGetArtifacts().build(ArtifactsDefaultEntryHolder.defaultEntry);
        }
        if (((from_bitField0_ & 0x00000002) != 0)) {
          result.parameterValues_ =
              internalGetParameterValues().build(ParameterValuesDefaultEntryHolder.defaultEntry);
        }
      }

      @java.lang.Override
      public Builder clone() {
        return super.clone();
      }

      @java.lang.Override
      public Builder setField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.setField(field, value);
      }

      @java.lang.Override
      public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
        return super.clearField(field);
      }

      @java.lang.Override
      public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
        return super.clearOneof(oneof);
      }

      @java.lang.Override
      public Builder setRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          int index,
          java.lang.Object value) {
        return super.setRepeatedField(field, index, value);
      }

      @java.lang.Override
      public Builder addRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.addRepeatedField(field, value);
      }

      @java.lang.Override
      public Builder mergeFrom(com.google.protobuf.Message other) {
        if (other instanceof com.google.cloud.aiplatform.v1beta1.PipelineTaskRerunConfig.Inputs) {
          return mergeFrom(
              (com.google.cloud.aiplatform.v1beta1.PipelineTaskRerunConfig.Inputs) other);
        } else {
          super.mergeFrom(other);
          return this;
        }
      }

      public Builder mergeFrom(
          com.google.cloud.aiplatform.v1beta1.PipelineTaskRerunConfig.Inputs other) {
        if (other
            == com.google.cloud.aiplatform.v1beta1.PipelineTaskRerunConfig.Inputs
                .getDefaultInstance()) return this;
        internalGetMutableArtifacts().mergeFrom(other.internalGetArtifacts());
        bitField0_ |= 0x00000001;
        internalGetMutableParameterValues().mergeFrom(other.internalGetParameterValues());
        bitField0_ |= 0x00000002;
        this.mergeUnknownFields(other.getUnknownFields());
        onChanged();
        return this;
      }

      @java.lang.Override
      public final boolean isInitialized() {
        return true;
      }

      @java.lang.Override
      public Builder mergeFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        if (extensionRegistry == null) {
          throw new java.lang.NullPointerException();
        }
        try {
          boolean done = false;
          while (!done) {
            int tag = input.readTag();
            switch (tag) {
              case 0:
                done = true;
                break;
              case 10:
                {
                  com.google.protobuf.MapEntry<
                          java.lang.String,
                          com.google.cloud.aiplatform.v1beta1.PipelineTaskRerunConfig.ArtifactList>
                      artifacts__ =
                          input.readMessage(
                              ArtifactsDefaultEntryHolder.defaultEntry.getParserForType(),
                              extensionRegistry);
                  internalGetMutableArtifacts()
                      .ensureBuilderMap()
                      .put(artifacts__.getKey(), artifacts__.getValue());
                  bitField0_ |= 0x00000001;
                  break;
                } // case 10
              case 18:
                {
                  com.google.protobuf.MapEntry<java.lang.String, com.google.protobuf.Value>
                      parameterValues__ =
                          input.readMessage(
                              ParameterValuesDefaultEntryHolder.defaultEntry.getParserForType(),
                              extensionRegistry);
                  internalGetMutableParameterValues()
                      .ensureBuilderMap()
                      .put(parameterValues__.getKey(), parameterValues__.getValue());
                  bitField0_ |= 0x00000002;
                  break;
                } // case 18
              default:
                {
                  if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                    done = true; // was an endgroup tag
                  }
                  break;
                } // default:
            } // switch (tag)
          } // while (!done)
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          throw e.unwrapIOException();
        } finally {
          onChanged();
        } // finally
        return this;
      }

      private int bitField0_;

      private static final class ArtifactsConverter
          implements com.google.protobuf.MapFieldBuilder.Converter<
              java.lang.String,
              com.google.cloud.aiplatform.v1beta1.PipelineTaskRerunConfig.ArtifactListOrBuilder,
              com.google.cloud.aiplatform.v1beta1.PipelineTaskRerunConfig.ArtifactList> {
        @java.lang.Override
        public com.google.cloud.aiplatform.v1beta1.PipelineTaskRerunConfig.ArtifactList build(
            com.google.cloud.aiplatform.v1beta1.PipelineTaskRerunConfig.ArtifactListOrBuilder val) {
          if (val
              instanceof com.google.cloud.aiplatform.v1beta1.PipelineTaskRerunConfig.ArtifactList) {
            return (com.google.cloud.aiplatform.v1beta1.PipelineTaskRerunConfig.ArtifactList) val;
          }
          return ((com.google.cloud.aiplatform.v1beta1.PipelineTaskRerunConfig.ArtifactList.Builder)
                  val)
              .build();
        }

        @java.lang.Override
        public com.google.protobuf.MapEntry<
                java.lang.String,
                com.google.cloud.aiplatform.v1beta1.PipelineTaskRerunConfig.ArtifactList>
            defaultEntry() {
          return ArtifactsDefaultEntryHolder.defaultEntry;
        }
      };

      private static final ArtifactsConverter artifactsConverter = new ArtifactsConverter();

      private com.google.protobuf.MapFieldBuilder<
              java.lang.String,
              com.google.cloud.aiplatform.v1beta1.PipelineTaskRerunConfig.ArtifactListOrBuilder,
              com.google.cloud.aiplatform.v1beta1.PipelineTaskRerunConfig.ArtifactList,
              com.google.cloud.aiplatform.v1beta1.PipelineTaskRerunConfig.ArtifactList.Builder>
          artifacts_;

      private com.google.protobuf.MapFieldBuilder<
              java.lang.String,
              com.google.cloud.aiplatform.v1beta1.PipelineTaskRerunConfig.ArtifactListOrBuilder,
              com.google.cloud.aiplatform.v1beta1.PipelineTaskRerunConfig.ArtifactList,
              com.google.cloud.aiplatform.v1beta1.PipelineTaskRerunConfig.ArtifactList.Builder>
          internalGetArtifacts() {
        if (artifacts_ == null) {
          return new com.google.protobuf.MapFieldBuilder<>(artifactsConverter);
        }
        return artifacts_;
      }

      private com.google.protobuf.MapFieldBuilder<
              java.lang.String,
              com.google.cloud.aiplatform.v1beta1.PipelineTaskRerunConfig.ArtifactListOrBuilder,
              com.google.cloud.aiplatform.v1beta1.PipelineTaskRerunConfig.ArtifactList,
              com.google.cloud.aiplatform.v1beta1.PipelineTaskRerunConfig.ArtifactList.Builder>
          internalGetMutableArtifacts() {
        if (artifacts_ == null) {
          artifacts_ = new com.google.protobuf.MapFieldBuilder<>(artifactsConverter);
        }
        bitField0_ |= 0x00000001;
        onChanged();
        return artifacts_;
      }

      public int getArtifactsCount() {
        return internalGetArtifacts().ensureBuilderMap().size();
      }
      /**
       *
       *
       * <pre>
       * Optional. Input artifacts.
       * </pre>
       *
       * <code>
       * map&lt;string, .google.cloud.aiplatform.v1beta1.PipelineTaskRerunConfig.ArtifactList&gt; artifacts = 1 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       */
      @java.lang.Override
      public boolean containsArtifacts(java.lang.String key) {
        if (key == null) {
          throw new NullPointerException("map key");
        }
        return internalGetArtifacts().ensureBuilderMap().containsKey(key);
      }
      /** Use {@link #getArtifactsMap()} instead. */
      @java.lang.Override
      @java.lang.Deprecated
      public java.util.Map<
              java.lang.String,
              com.google.cloud.aiplatform.v1beta1.PipelineTaskRerunConfig.ArtifactList>
          getArtifacts() {
        return getArtifactsMap();
      }
      /**
       *
       *
       * <pre>
       * Optional. Input artifacts.
       * </pre>
       *
       * <code>
       * map&lt;string, .google.cloud.aiplatform.v1beta1.PipelineTaskRerunConfig.ArtifactList&gt; artifacts = 1 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       */
      @java.lang.Override
      public java.util.Map<
              java.lang.String,
              com.google.cloud.aiplatform.v1beta1.PipelineTaskRerunConfig.ArtifactList>
          getArtifactsMap() {
        return internalGetArtifacts().getImmutableMap();
      }
      /**
       *
       *
       * <pre>
       * Optional. Input artifacts.
       * </pre>
       *
       * <code>
       * map&lt;string, .google.cloud.aiplatform.v1beta1.PipelineTaskRerunConfig.ArtifactList&gt; artifacts = 1 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       */
      @java.lang.Override
      public /* nullable */ com.google.cloud.aiplatform.v1beta1.PipelineTaskRerunConfig.ArtifactList
          getArtifactsOrDefault(
              java.lang.String key,
              /* nullable */
              com.google.cloud.aiplatform.v1beta1.PipelineTaskRerunConfig.ArtifactList
                  defaultValue) {
        if (key == null) {
          throw new NullPointerException("map key");
        }
        java.util.Map<
                java.lang.String,
                com.google.cloud.aiplatform.v1beta1.PipelineTaskRerunConfig.ArtifactListOrBuilder>
            map = internalGetMutableArtifacts().ensureBuilderMap();
        return map.containsKey(key) ? artifactsConverter.build(map.get(key)) : defaultValue;
      }
      /**
       *
       *
       * <pre>
       * Optional. Input artifacts.
       * </pre>
       *
       * <code>
       * map&lt;string, .google.cloud.aiplatform.v1beta1.PipelineTaskRerunConfig.ArtifactList&gt; artifacts = 1 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       */
      @java.lang.Override
      public com.google.cloud.aiplatform.v1beta1.PipelineTaskRerunConfig.ArtifactList
          getArtifactsOrThrow(java.lang.String key) {
        if (key == null) {
          throw new NullPointerException("map key");
        }
        java.util.Map<
                java.lang.String,
                com.google.cloud.aiplatform.v1beta1.PipelineTaskRerunConfig.ArtifactListOrBuilder>
            map = internalGetMutableArtifacts().ensureBuilderMap();
        if (!map.containsKey(key)) {
          throw new java.lang.IllegalArgumentException();
        }
        return artifactsConverter.build(map.get(key));
      }

      public Builder clearArtifacts() {
        bitField0_ = (bitField0_ & ~0x00000001);
        internalGetMutableArtifacts().clear();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Optional. Input artifacts.
       * </pre>
       *
       * <code>
       * map&lt;string, .google.cloud.aiplatform.v1beta1.PipelineTaskRerunConfig.ArtifactList&gt; artifacts = 1 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       */
      public Builder removeArtifacts(java.lang.String key) {
        if (key == null) {
          throw new NullPointerException("map key");
        }
        internalGetMutableArtifacts().ensureBuilderMap().remove(key);
        return this;
      }
      /** Use alternate mutation accessors instead. */
      @java.lang.Deprecated
      public java.util.Map<
              java.lang.String,
              com.google.cloud.aiplatform.v1beta1.PipelineTaskRerunConfig.ArtifactList>
          getMutableArtifacts() {
        bitField0_ |= 0x00000001;
        return internalGetMutableArtifacts().ensureMessageMap();
      }
      /**
       *
       *
       * <pre>
       * Optional. Input artifacts.
       * </pre>
       *
       * <code>
       * map&lt;string, .google.cloud.aiplatform.v1beta1.PipelineTaskRerunConfig.ArtifactList&gt; artifacts = 1 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       */
      public Builder putArtifacts(
          java.lang.String key,
          com.google.cloud.aiplatform.v1beta1.PipelineTaskRerunConfig.ArtifactList value) {
        if (key == null) {
          throw new NullPointerException("map key");
        }
        if (value == null) {
          throw new NullPointerException("map value");
        }
        internalGetMutableArtifacts().ensureBuilderMap().put(key, value);
        bitField0_ |= 0x00000001;
        return this;
      }
      /**
       *
       *
       * <pre>
       * Optional. Input artifacts.
       * </pre>
       *
       * <code>
       * map&lt;string, .google.cloud.aiplatform.v1beta1.PipelineTaskRerunConfig.ArtifactList&gt; artifacts = 1 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       */
      public Builder putAllArtifacts(
          java.util.Map<
                  java.lang.String,
                  com.google.cloud.aiplatform.v1beta1.PipelineTaskRerunConfig.ArtifactList>
              values) {
        for (java.util.Map.Entry<
                java.lang.String,
                com.google.cloud.aiplatform.v1beta1.PipelineTaskRerunConfig.ArtifactList>
            e : values.entrySet()) {
          if (e.getKey() == null || e.getValue() == null) {
            throw new NullPointerException();
          }
        }
        internalGetMutableArtifacts().ensureBuilderMap().putAll(values);
        bitField0_ |= 0x00000001;
        return this;
      }
      /**
       *
       *
       * <pre>
       * Optional. Input artifacts.
       * </pre>
       *
       * <code>
       * map&lt;string, .google.cloud.aiplatform.v1beta1.PipelineTaskRerunConfig.ArtifactList&gt; artifacts = 1 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       */
      public com.google.cloud.aiplatform.v1beta1.PipelineTaskRerunConfig.ArtifactList.Builder
          putArtifactsBuilderIfAbsent(java.lang.String key) {
        java.util.Map<
                java.lang.String,
                com.google.cloud.aiplatform.v1beta1.PipelineTaskRerunConfig.ArtifactListOrBuilder>
            builderMap = internalGetMutableArtifacts().ensureBuilderMap();
        com.google.cloud.aiplatform.v1beta1.PipelineTaskRerunConfig.ArtifactListOrBuilder entry =
            builderMap.get(key);
        if (entry == null) {
          entry =
              com.google.cloud.aiplatform.v1beta1.PipelineTaskRerunConfig.ArtifactList.newBuilder();
          builderMap.put(key, entry);
        }
        if (entry
            instanceof com.google.cloud.aiplatform.v1beta1.PipelineTaskRerunConfig.ArtifactList) {
          entry =
              ((com.google.cloud.aiplatform.v1beta1.PipelineTaskRerunConfig.ArtifactList) entry)
                  .toBuilder();
          builderMap.put(key, entry);
        }
        return (com.google.cloud.aiplatform.v1beta1.PipelineTaskRerunConfig.ArtifactList.Builder)
            entry;
      }

      private static final class ParameterValuesConverter
          implements com.google.protobuf.MapFieldBuilder.Converter<
              java.lang.String, com.google.protobuf.ValueOrBuilder, com.google.protobuf.Value> {
        @java.lang.Override
        public com.google.protobuf.Value build(com.google.protobuf.ValueOrBuilder val) {
          if (val instanceof com.google.protobuf.Value) {
            return (com.google.protobuf.Value) val;
          }
          return ((com.google.protobuf.Value.Builder) val).build();
        }

        @java.lang.Override
        public com.google.protobuf.MapEntry<java.lang.String, com.google.protobuf.Value>
            defaultEntry() {
          return ParameterValuesDefaultEntryHolder.defaultEntry;
        }
      };

      private static final ParameterValuesConverter parameterValuesConverter =
          new ParameterValuesConverter();

      private com.google.protobuf.MapFieldBuilder<
              java.lang.String,
              com.google.protobuf.ValueOrBuilder,
              com.google.protobuf.Value,
              com.google.protobuf.Value.Builder>
          parameterValues_;

      private com.google.protobuf.MapFieldBuilder<
              java.lang.String,
              com.google.protobuf.ValueOrBuilder,
              com.google.protobuf.Value,
              com.google.protobuf.Value.Builder>
          internalGetParameterValues() {
        if (parameterValues_ == null) {
          return new com.google.protobuf.MapFieldBuilder<>(parameterValuesConverter);
        }
        return parameterValues_;
      }

      private com.google.protobuf.MapFieldBuilder<
              java.lang.String,
              com.google.protobuf.ValueOrBuilder,
              com.google.protobuf.Value,
              com.google.protobuf.Value.Builder>
          internalGetMutableParameterValues() {
        if (parameterValues_ == null) {
          parameterValues_ = new com.google.protobuf.MapFieldBuilder<>(parameterValuesConverter);
        }
        bitField0_ |= 0x00000002;
        onChanged();
        return parameterValues_;
      }

      public int getParameterValuesCount() {
        return internalGetParameterValues().ensureBuilderMap().size();
      }
      /**
       *
       *
       * <pre>
       * Optional. Input parameters.
       * </pre>
       *
       * <code>
       * map&lt;string, .google.protobuf.Value&gt; parameter_values = 2 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       */
      @java.lang.Override
      public boolean containsParameterValues(java.lang.String key) {
        if (key == null) {
          throw new NullPointerException("map key");
        }
        return internalGetParameterValues().ensureBuilderMap().containsKey(key);
      }
      /** Use {@link #getParameterValuesMap()} instead. */
      @java.lang.Override
      @java.lang.Deprecated
      public java.util.Map<java.lang.String, com.google.protobuf.Value> getParameterValues() {
        return getParameterValuesMap();
      }
      /**
       *
       *
       * <pre>
       * Optional. Input parameters.
       * </pre>
       *
       * <code>
       * map&lt;string, .google.protobuf.Value&gt; parameter_values = 2 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       */
      @java.lang.Override
      public java.util.Map<java.lang.String, com.google.protobuf.Value> getParameterValuesMap() {
        return internalGetParameterValues().getImmutableMap();
      }
      /**
       *
       *
       * <pre>
       * Optional. Input parameters.
       * </pre>
       *
       * <code>
       * map&lt;string, .google.protobuf.Value&gt; parameter_values = 2 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       */
      @java.lang.Override
      public /* nullable */ com.google.protobuf.Value getParameterValuesOrDefault(
          java.lang.String key,
          /* nullable */
          com.google.protobuf.Value defaultValue) {
        if (key == null) {
          throw new NullPointerException("map key");
        }
        java.util.Map<java.lang.String, com.google.protobuf.ValueOrBuilder> map =
            internalGetMutableParameterValues().ensureBuilderMap();
        return map.containsKey(key) ? parameterValuesConverter.build(map.get(key)) : defaultValue;
      }
      /**
       *
       *
       * <pre>
       * Optional. Input parameters.
       * </pre>
       *
       * <code>
       * map&lt;string, .google.protobuf.Value&gt; parameter_values = 2 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       */
      @java.lang.Override
      public com.google.protobuf.Value getParameterValuesOrThrow(java.lang.String key) {
        if (key == null) {
          throw new NullPointerException("map key");
        }
        java.util.Map<java.lang.String, com.google.protobuf.ValueOrBuilder> map =
            internalGetMutableParameterValues().ensureBuilderMap();
        if (!map.containsKey(key)) {
          throw new java.lang.IllegalArgumentException();
        }
        return parameterValuesConverter.build(map.get(key));
      }

      public Builder clearParameterValues() {
        bitField0_ = (bitField0_ & ~0x00000002);
        internalGetMutableParameterValues().clear();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Optional. Input parameters.
       * </pre>
       *
       * <code>
       * map&lt;string, .google.protobuf.Value&gt; parameter_values = 2 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       */
      public Builder removeParameterValues(java.lang.String key) {
        if (key == null) {
          throw new NullPointerException("map key");
        }
        internalGetMutableParameterValues().ensureBuilderMap().remove(key);
        return this;
      }
      /** Use alternate mutation accessors instead. */
      @java.lang.Deprecated
      public java.util.Map<java.lang.String, com.google.protobuf.Value>
          getMutableParameterValues() {
        bitField0_ |= 0x00000002;
        return internalGetMutableParameterValues().ensureMessageMap();
      }
      /**
       *
       *
       * <pre>
       * Optional. Input parameters.
       * </pre>
       *
       * <code>
       * map&lt;string, .google.protobuf.Value&gt; parameter_values = 2 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       */
      public Builder putParameterValues(java.lang.String key, com.google.protobuf.Value value) {
        if (key == null) {
          throw new NullPointerException("map key");
        }
        if (value == null) {
          throw new NullPointerException("map value");
        }
        internalGetMutableParameterValues().ensureBuilderMap().put(key, value);
        bitField0_ |= 0x00000002;
        return this;
      }
      /**
       *
       *
       * <pre>
       * Optional. Input parameters.
       * </pre>
       *
       * <code>
       * map&lt;string, .google.protobuf.Value&gt; parameter_values = 2 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       */
      public Builder putAllParameterValues(
          java.util.Map<java.lang.String, com.google.protobuf.Value> values) {
        for (java.util.Map.Entry<java.lang.String, com.google.protobuf.Value> e :
            values.entrySet()) {
          if (e.getKey() == null || e.getValue() == null) {
            throw new NullPointerException();
          }
        }
        internalGetMutableParameterValues().ensureBuilderMap().putAll(values);
        bitField0_ |= 0x00000002;
        return this;
      }
      /**
       *
       *
       * <pre>
       * Optional. Input parameters.
       * </pre>
       *
       * <code>
       * map&lt;string, .google.protobuf.Value&gt; parameter_values = 2 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       */
      public com.google.protobuf.Value.Builder putParameterValuesBuilderIfAbsent(
          java.lang.String key) {
        java.util.Map<java.lang.String, com.google.protobuf.ValueOrBuilder> builderMap =
            internalGetMutableParameterValues().ensureBuilderMap();
        com.google.protobuf.ValueOrBuilder entry = builderMap.get(key);
        if (entry == null) {
          entry = com.google.protobuf.Value.newBuilder();
          builderMap.put(key, entry);
        }
        if (entry instanceof com.google.protobuf.Value) {
          entry = ((com.google.protobuf.Value) entry).toBuilder();
          builderMap.put(key, entry);
        }
        return (com.google.protobuf.Value.Builder) entry;
      }

      @java.lang.Override
      public final Builder setUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.setUnknownFields(unknownFields);
      }

      @java.lang.Override
      public final Builder mergeUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.mergeUnknownFields(unknownFields);
      }

      // @@protoc_insertion_point(builder_scope:google.cloud.aiplatform.v1beta1.PipelineTaskRerunConfig.Inputs)
    }

    // @@protoc_insertion_point(class_scope:google.cloud.aiplatform.v1beta1.PipelineTaskRerunConfig.Inputs)
    private static final com.google.cloud.aiplatform.v1beta1.PipelineTaskRerunConfig.Inputs
        DEFAULT_INSTANCE;

    static {
      DEFAULT_INSTANCE = new com.google.cloud.aiplatform.v1beta1.PipelineTaskRerunConfig.Inputs();
    }

    public static com.google.cloud.aiplatform.v1beta1.PipelineTaskRerunConfig.Inputs
        getDefaultInstance() {
      return DEFAULT_INSTANCE;
    }

    private static final com.google.protobuf.Parser<Inputs> PARSER =
        new com.google.protobuf.AbstractParser<Inputs>() {
          @java.lang.Override
          public Inputs parsePartialFrom(
              com.google.protobuf.CodedInputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
            Builder builder = newBuilder();
            try {
              builder.mergeFrom(input, extensionRegistry);
            } catch (com.google.protobuf.InvalidProtocolBufferException e) {
              throw e.setUnfinishedMessage(builder.buildPartial());
            } catch (com.google.protobuf.UninitializedMessageException e) {
              throw e.asInvalidProtocolBufferException()
                  .setUnfinishedMessage(builder.buildPartial());
            } catch (java.io.IOException e) {
              throw new com.google.protobuf.InvalidProtocolBufferException(e)
                  .setUnfinishedMessage(builder.buildPartial());
            }
            return builder.buildPartial();
          }
        };

    public static com.google.protobuf.Parser<Inputs> parser() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.protobuf.Parser<Inputs> getParserForType() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.cloud.aiplatform.v1beta1.PipelineTaskRerunConfig.Inputs
        getDefaultInstanceForType() {
      return DEFAULT_INSTANCE;
    }
  }

  private int bitField0_;
  public static final int TASK_ID_FIELD_NUMBER = 1;
  private long taskId_ = 0L;
  /**
   *
   *
   * <pre>
   * Optional. The system generated ID of the task. Retrieved from original run.
   * </pre>
   *
   * <code>int64 task_id = 1 [(.google.api.field_behavior) = OPTIONAL];</code>
   *
   * @return The taskId.
   */
  @java.lang.Override
  public long getTaskId() {
    return taskId_;
  }

  public static final int TASK_NAME_FIELD_NUMBER = 2;

  @SuppressWarnings("serial")
  private volatile java.lang.Object taskName_ = "";
  /**
   *
   *
   * <pre>
   * Optional. The name of the task.
   * </pre>
   *
   * <code>string task_name = 2 [(.google.api.field_behavior) = OPTIONAL];</code>
   *
   * @return The taskName.
   */
  @java.lang.Override
  public java.lang.String getTaskName() {
    java.lang.Object ref = taskName_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      taskName_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Optional. The name of the task.
   * </pre>
   *
   * <code>string task_name = 2 [(.google.api.field_behavior) = OPTIONAL];</code>
   *
   * @return The bytes for taskName.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getTaskNameBytes() {
    java.lang.Object ref = taskName_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      taskName_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int INPUTS_FIELD_NUMBER = 3;
  private com.google.cloud.aiplatform.v1beta1.PipelineTaskRerunConfig.Inputs inputs_;
  /**
   *
   *
   * <pre>
   * Optional. The runtime input of the task overridden by the user.
   * </pre>
   *
   * <code>
   * .google.cloud.aiplatform.v1beta1.PipelineTaskRerunConfig.Inputs inputs = 3 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   *
   * @return Whether the inputs field is set.
   */
  @java.lang.Override
  public boolean hasInputs() {
    return ((bitField0_ & 0x00000001) != 0);
  }
  /**
   *
   *
   * <pre>
   * Optional. The runtime input of the task overridden by the user.
   * </pre>
   *
   * <code>
   * .google.cloud.aiplatform.v1beta1.PipelineTaskRerunConfig.Inputs inputs = 3 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   *
   * @return The inputs.
   */
  @java.lang.Override
  public com.google.cloud.aiplatform.v1beta1.PipelineTaskRerunConfig.Inputs getInputs() {
    return inputs_ == null
        ? com.google.cloud.aiplatform.v1beta1.PipelineTaskRerunConfig.Inputs.getDefaultInstance()
        : inputs_;
  }
  /**
   *
   *
   * <pre>
   * Optional. The runtime input of the task overridden by the user.
   * </pre>
   *
   * <code>
   * .google.cloud.aiplatform.v1beta1.PipelineTaskRerunConfig.Inputs inputs = 3 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.aiplatform.v1beta1.PipelineTaskRerunConfig.InputsOrBuilder
      getInputsOrBuilder() {
    return inputs_ == null
        ? com.google.cloud.aiplatform.v1beta1.PipelineTaskRerunConfig.Inputs.getDefaultInstance()
        : inputs_;
  }

  public static final int SKIP_TASK_FIELD_NUMBER = 4;
  private boolean skipTask_ = false;
  /**
   *
   *
   * <pre>
   * Optional. Whether to skip this task. Default value is False.
   * </pre>
   *
   * <code>bool skip_task = 4 [(.google.api.field_behavior) = OPTIONAL];</code>
   *
   * @return The skipTask.
   */
  @java.lang.Override
  public boolean getSkipTask() {
    return skipTask_;
  }

  public static final int SKIP_DOWNSTREAM_TASKS_FIELD_NUMBER = 5;
  private boolean skipDownstreamTasks_ = false;
  /**
   *
   *
   * <pre>
   * Optional. Whether to skip downstream tasks. Default value is False.
   * </pre>
   *
   * <code>bool skip_downstream_tasks = 5 [(.google.api.field_behavior) = OPTIONAL];</code>
   *
   * @return The skipDownstreamTasks.
   */
  @java.lang.Override
  public boolean getSkipDownstreamTasks() {
    return skipDownstreamTasks_;
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    if (taskId_ != 0L) {
      output.writeInt64(1, taskId_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(taskName_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 2, taskName_);
    }
    if (((bitField0_ & 0x00000001) != 0)) {
      output.writeMessage(3, getInputs());
    }
    if (skipTask_ != false) {
      output.writeBool(4, skipTask_);
    }
    if (skipDownstreamTasks_ != false) {
      output.writeBool(5, skipDownstreamTasks_);
    }
    getUnknownFields().writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    if (taskId_ != 0L) {
      size += com.google.protobuf.CodedOutputStream.computeInt64Size(1, taskId_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(taskName_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(2, taskName_);
    }
    if (((bitField0_ & 0x00000001) != 0)) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(3, getInputs());
    }
    if (skipTask_ != false) {
      size += com.google.protobuf.CodedOutputStream.computeBoolSize(4, skipTask_);
    }
    if (skipDownstreamTasks_ != false) {
      size += com.google.protobuf.CodedOutputStream.computeBoolSize(5, skipDownstreamTasks_);
    }
    size += getUnknownFields().getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.cloud.aiplatform.v1beta1.PipelineTaskRerunConfig)) {
      return super.equals(obj);
    }
    com.google.cloud.aiplatform.v1beta1.PipelineTaskRerunConfig other =
        (com.google.cloud.aiplatform.v1beta1.PipelineTaskRerunConfig) obj;

    if (getTaskId() != other.getTaskId()) return false;
    if (!getTaskName().equals(other.getTaskName())) return false;
    if (hasInputs() != other.hasInputs()) return false;
    if (hasInputs()) {
      if (!getInputs().equals(other.getInputs())) return false;
    }
    if (getSkipTask() != other.getSkipTask()) return false;
    if (getSkipDownstreamTasks() != other.getSkipDownstreamTasks()) return false;
    if (!getUnknownFields().equals(other.getUnknownFields())) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    hash = (37 * hash) + TASK_ID_FIELD_NUMBER;
    hash = (53 * hash) + com.google.protobuf.Internal.hashLong(getTaskId());
    hash = (37 * hash) + TASK_NAME_FIELD_NUMBER;
    hash = (53 * hash) + getTaskName().hashCode();
    if (hasInputs()) {
      hash = (37 * hash) + INPUTS_FIELD_NUMBER;
      hash = (53 * hash) + getInputs().hashCode();
    }
    hash = (37 * hash) + SKIP_TASK_FIELD_NUMBER;
    hash = (53 * hash) + com.google.protobuf.Internal.hashBoolean(getSkipTask());
    hash = (37 * hash) + SKIP_DOWNSTREAM_TASKS_FIELD_NUMBER;
    hash = (53 * hash) + com.google.protobuf.Internal.hashBoolean(getSkipDownstreamTasks());
    hash = (29 * hash) + getUnknownFields().hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.cloud.aiplatform.v1beta1.PipelineTaskRerunConfig parseFrom(
      java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.aiplatform.v1beta1.PipelineTaskRerunConfig parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.aiplatform.v1beta1.PipelineTaskRerunConfig parseFrom(
      com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.aiplatform.v1beta1.PipelineTaskRerunConfig parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.aiplatform.v1beta1.PipelineTaskRerunConfig parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.aiplatform.v1beta1.PipelineTaskRerunConfig parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.aiplatform.v1beta1.PipelineTaskRerunConfig parseFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.aiplatform.v1beta1.PipelineTaskRerunConfig parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.aiplatform.v1beta1.PipelineTaskRerunConfig parseDelimitedFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.cloud.aiplatform.v1beta1.PipelineTaskRerunConfig parseDelimitedFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.aiplatform.v1beta1.PipelineTaskRerunConfig parseFrom(
      com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.aiplatform.v1beta1.PipelineTaskRerunConfig parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(
      com.google.cloud.aiplatform.v1beta1.PipelineTaskRerunConfig prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }
  /**
   *
   *
   * <pre>
   * User provided rerun config to submit a rerun pipelinejob. This includes
   * 1. Which task to rerun
   * 2. User override input parameters and artifacts.
   * </pre>
   *
   * Protobuf type {@code google.cloud.aiplatform.v1beta1.PipelineTaskRerunConfig}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.cloud.aiplatform.v1beta1.PipelineTaskRerunConfig)
      com.google.cloud.aiplatform.v1beta1.PipelineTaskRerunConfigOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.aiplatform.v1beta1.Pipeline
          .internal_static_google_cloud_aiplatform_v1beta1_PipelineTaskRerunConfig_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.aiplatform.v1beta1.Pipeline
          .internal_static_google_cloud_aiplatform_v1beta1_PipelineTaskRerunConfig_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.aiplatform.v1beta1.PipelineTaskRerunConfig.class,
              com.google.cloud.aiplatform.v1beta1.PipelineTaskRerunConfig.Builder.class);
    }

    // Construct using com.google.cloud.aiplatform.v1beta1.PipelineTaskRerunConfig.newBuilder()
    private Builder() {
      maybeForceBuilderInitialization();
    }

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
      maybeForceBuilderInitialization();
    }

    private void maybeForceBuilderInitialization() {
      if (com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders) {
        getInputsFieldBuilder();
      }
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      bitField0_ = 0;
      taskId_ = 0L;
      taskName_ = "";
      inputs_ = null;
      if (inputsBuilder_ != null) {
        inputsBuilder_.dispose();
        inputsBuilder_ = null;
      }
      skipTask_ = false;
      skipDownstreamTasks_ = false;
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.cloud.aiplatform.v1beta1.Pipeline
          .internal_static_google_cloud_aiplatform_v1beta1_PipelineTaskRerunConfig_descriptor;
    }

    @java.lang.Override
    public com.google.cloud.aiplatform.v1beta1.PipelineTaskRerunConfig getDefaultInstanceForType() {
      return com.google.cloud.aiplatform.v1beta1.PipelineTaskRerunConfig.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.cloud.aiplatform.v1beta1.PipelineTaskRerunConfig build() {
      com.google.cloud.aiplatform.v1beta1.PipelineTaskRerunConfig result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.cloud.aiplatform.v1beta1.PipelineTaskRerunConfig buildPartial() {
      com.google.cloud.aiplatform.v1beta1.PipelineTaskRerunConfig result =
          new com.google.cloud.aiplatform.v1beta1.PipelineTaskRerunConfig(this);
      if (bitField0_ != 0) {
        buildPartial0(result);
      }
      onBuilt();
      return result;
    }

    private void buildPartial0(com.google.cloud.aiplatform.v1beta1.PipelineTaskRerunConfig result) {
      int from_bitField0_ = bitField0_;
      if (((from_bitField0_ & 0x00000001) != 0)) {
        result.taskId_ = taskId_;
      }
      if (((from_bitField0_ & 0x00000002) != 0)) {
        result.taskName_ = taskName_;
      }
      int to_bitField0_ = 0;
      if (((from_bitField0_ & 0x00000004) != 0)) {
        result.inputs_ = inputsBuilder_ == null ? inputs_ : inputsBuilder_.build();
        to_bitField0_ |= 0x00000001;
      }
      if (((from_bitField0_ & 0x00000008) != 0)) {
        result.skipTask_ = skipTask_;
      }
      if (((from_bitField0_ & 0x00000010) != 0)) {
        result.skipDownstreamTasks_ = skipDownstreamTasks_;
      }
      result.bitField0_ |= to_bitField0_;
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.cloud.aiplatform.v1beta1.PipelineTaskRerunConfig) {
        return mergeFrom((com.google.cloud.aiplatform.v1beta1.PipelineTaskRerunConfig) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(com.google.cloud.aiplatform.v1beta1.PipelineTaskRerunConfig other) {
      if (other == com.google.cloud.aiplatform.v1beta1.PipelineTaskRerunConfig.getDefaultInstance())
        return this;
      if (other.getTaskId() != 0L) {
        setTaskId(other.getTaskId());
      }
      if (!other.getTaskName().isEmpty()) {
        taskName_ = other.taskName_;
        bitField0_ |= 0x00000002;
        onChanged();
      }
      if (other.hasInputs()) {
        mergeInputs(other.getInputs());
      }
      if (other.getSkipTask() != false) {
        setSkipTask(other.getSkipTask());
      }
      if (other.getSkipDownstreamTasks() != false) {
        setSkipDownstreamTasks(other.getSkipDownstreamTasks());
      }
      this.mergeUnknownFields(other.getUnknownFields());
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 8:
              {
                taskId_ = input.readInt64();
                bitField0_ |= 0x00000001;
                break;
              } // case 8
            case 18:
              {
                taskName_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000002;
                break;
              } // case 18
            case 26:
              {
                input.readMessage(getInputsFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000004;
                break;
              } // case 26
            case 32:
              {
                skipTask_ = input.readBool();
                bitField0_ |= 0x00000008;
                break;
              } // case 32
            case 40:
              {
                skipDownstreamTasks_ = input.readBool();
                bitField0_ |= 0x00000010;
                break;
              } // case 40
            default:
              {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
          } // switch (tag)
        } // while (!done)
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.unwrapIOException();
      } finally {
        onChanged();
      } // finally
      return this;
    }

    private int bitField0_;

    private long taskId_;
    /**
     *
     *
     * <pre>
     * Optional. The system generated ID of the task. Retrieved from original run.
     * </pre>
     *
     * <code>int64 task_id = 1 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return The taskId.
     */
    @java.lang.Override
    public long getTaskId() {
      return taskId_;
    }
    /**
     *
     *
     * <pre>
     * Optional. The system generated ID of the task. Retrieved from original run.
     * </pre>
     *
     * <code>int64 task_id = 1 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @param value The taskId to set.
     * @return This builder for chaining.
     */
    public Builder setTaskId(long value) {

      taskId_ = value;
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. The system generated ID of the task. Retrieved from original run.
     * </pre>
     *
     * <code>int64 task_id = 1 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearTaskId() {
      bitField0_ = (bitField0_ & ~0x00000001);
      taskId_ = 0L;
      onChanged();
      return this;
    }

    private java.lang.Object taskName_ = "";
    /**
     *
     *
     * <pre>
     * Optional. The name of the task.
     * </pre>
     *
     * <code>string task_name = 2 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return The taskName.
     */
    public java.lang.String getTaskName() {
      java.lang.Object ref = taskName_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        taskName_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Optional. The name of the task.
     * </pre>
     *
     * <code>string task_name = 2 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return The bytes for taskName.
     */
    public com.google.protobuf.ByteString getTaskNameBytes() {
      java.lang.Object ref = taskName_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        taskName_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Optional. The name of the task.
     * </pre>
     *
     * <code>string task_name = 2 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @param value The taskName to set.
     * @return This builder for chaining.
     */
    public Builder setTaskName(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      taskName_ = value;
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. The name of the task.
     * </pre>
     *
     * <code>string task_name = 2 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearTaskName() {
      taskName_ = getDefaultInstance().getTaskName();
      bitField0_ = (bitField0_ & ~0x00000002);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. The name of the task.
     * </pre>
     *
     * <code>string task_name = 2 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @param value The bytes for taskName to set.
     * @return This builder for chaining.
     */
    public Builder setTaskNameBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      taskName_ = value;
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }

    private com.google.cloud.aiplatform.v1beta1.PipelineTaskRerunConfig.Inputs inputs_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.aiplatform.v1beta1.PipelineTaskRerunConfig.Inputs,
            com.google.cloud.aiplatform.v1beta1.PipelineTaskRerunConfig.Inputs.Builder,
            com.google.cloud.aiplatform.v1beta1.PipelineTaskRerunConfig.InputsOrBuilder>
        inputsBuilder_;
    /**
     *
     *
     * <pre>
     * Optional. The runtime input of the task overridden by the user.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.PipelineTaskRerunConfig.Inputs inputs = 3 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return Whether the inputs field is set.
     */
    public boolean hasInputs() {
      return ((bitField0_ & 0x00000004) != 0);
    }
    /**
     *
     *
     * <pre>
     * Optional. The runtime input of the task overridden by the user.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.PipelineTaskRerunConfig.Inputs inputs = 3 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return The inputs.
     */
    public com.google.cloud.aiplatform.v1beta1.PipelineTaskRerunConfig.Inputs getInputs() {
      if (inputsBuilder_ == null) {
        return inputs_ == null
            ? com.google.cloud.aiplatform.v1beta1.PipelineTaskRerunConfig.Inputs
                .getDefaultInstance()
            : inputs_;
      } else {
        return inputsBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Optional. The runtime input of the task overridden by the user.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.PipelineTaskRerunConfig.Inputs inputs = 3 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder setInputs(
        com.google.cloud.aiplatform.v1beta1.PipelineTaskRerunConfig.Inputs value) {
      if (inputsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        inputs_ = value;
      } else {
        inputsBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. The runtime input of the task overridden by the user.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.PipelineTaskRerunConfig.Inputs inputs = 3 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder setInputs(
        com.google.cloud.aiplatform.v1beta1.PipelineTaskRerunConfig.Inputs.Builder
            builderForValue) {
      if (inputsBuilder_ == null) {
        inputs_ = builderForValue.build();
      } else {
        inputsBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. The runtime input of the task overridden by the user.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.PipelineTaskRerunConfig.Inputs inputs = 3 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder mergeInputs(
        com.google.cloud.aiplatform.v1beta1.PipelineTaskRerunConfig.Inputs value) {
      if (inputsBuilder_ == null) {
        if (((bitField0_ & 0x00000004) != 0)
            && inputs_ != null
            && inputs_
                != com.google.cloud.aiplatform.v1beta1.PipelineTaskRerunConfig.Inputs
                    .getDefaultInstance()) {
          getInputsBuilder().mergeFrom(value);
        } else {
          inputs_ = value;
        }
      } else {
        inputsBuilder_.mergeFrom(value);
      }
      if (inputs_ != null) {
        bitField0_ |= 0x00000004;
        onChanged();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. The runtime input of the task overridden by the user.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.PipelineTaskRerunConfig.Inputs inputs = 3 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder clearInputs() {
      bitField0_ = (bitField0_ & ~0x00000004);
      inputs_ = null;
      if (inputsBuilder_ != null) {
        inputsBuilder_.dispose();
        inputsBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. The runtime input of the task overridden by the user.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.PipelineTaskRerunConfig.Inputs inputs = 3 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public com.google.cloud.aiplatform.v1beta1.PipelineTaskRerunConfig.Inputs.Builder
        getInputsBuilder() {
      bitField0_ |= 0x00000004;
      onChanged();
      return getInputsFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Optional. The runtime input of the task overridden by the user.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.PipelineTaskRerunConfig.Inputs inputs = 3 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public com.google.cloud.aiplatform.v1beta1.PipelineTaskRerunConfig.InputsOrBuilder
        getInputsOrBuilder() {
      if (inputsBuilder_ != null) {
        return inputsBuilder_.getMessageOrBuilder();
      } else {
        return inputs_ == null
            ? com.google.cloud.aiplatform.v1beta1.PipelineTaskRerunConfig.Inputs
                .getDefaultInstance()
            : inputs_;
      }
    }
    /**
     *
     *
     * <pre>
     * Optional. The runtime input of the task overridden by the user.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.PipelineTaskRerunConfig.Inputs inputs = 3 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.aiplatform.v1beta1.PipelineTaskRerunConfig.Inputs,
            com.google.cloud.aiplatform.v1beta1.PipelineTaskRerunConfig.Inputs.Builder,
            com.google.cloud.aiplatform.v1beta1.PipelineTaskRerunConfig.InputsOrBuilder>
        getInputsFieldBuilder() {
      if (inputsBuilder_ == null) {
        inputsBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.aiplatform.v1beta1.PipelineTaskRerunConfig.Inputs,
                com.google.cloud.aiplatform.v1beta1.PipelineTaskRerunConfig.Inputs.Builder,
                com.google.cloud.aiplatform.v1beta1.PipelineTaskRerunConfig.InputsOrBuilder>(
                getInputs(), getParentForChildren(), isClean());
        inputs_ = null;
      }
      return inputsBuilder_;
    }

    private boolean skipTask_;
    /**
     *
     *
     * <pre>
     * Optional. Whether to skip this task. Default value is False.
     * </pre>
     *
     * <code>bool skip_task = 4 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return The skipTask.
     */
    @java.lang.Override
    public boolean getSkipTask() {
      return skipTask_;
    }
    /**
     *
     *
     * <pre>
     * Optional. Whether to skip this task. Default value is False.
     * </pre>
     *
     * <code>bool skip_task = 4 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @param value The skipTask to set.
     * @return This builder for chaining.
     */
    public Builder setSkipTask(boolean value) {

      skipTask_ = value;
      bitField0_ |= 0x00000008;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. Whether to skip this task. Default value is False.
     * </pre>
     *
     * <code>bool skip_task = 4 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearSkipTask() {
      bitField0_ = (bitField0_ & ~0x00000008);
      skipTask_ = false;
      onChanged();
      return this;
    }

    private boolean skipDownstreamTasks_;
    /**
     *
     *
     * <pre>
     * Optional. Whether to skip downstream tasks. Default value is False.
     * </pre>
     *
     * <code>bool skip_downstream_tasks = 5 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return The skipDownstreamTasks.
     */
    @java.lang.Override
    public boolean getSkipDownstreamTasks() {
      return skipDownstreamTasks_;
    }
    /**
     *
     *
     * <pre>
     * Optional. Whether to skip downstream tasks. Default value is False.
     * </pre>
     *
     * <code>bool skip_downstream_tasks = 5 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @param value The skipDownstreamTasks to set.
     * @return This builder for chaining.
     */
    public Builder setSkipDownstreamTasks(boolean value) {

      skipDownstreamTasks_ = value;
      bitField0_ |= 0x00000010;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. Whether to skip downstream tasks. Default value is False.
     * </pre>
     *
     * <code>bool skip_downstream_tasks = 5 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearSkipDownstreamTasks() {
      bitField0_ = (bitField0_ & ~0x00000010);
      skipDownstreamTasks_ = false;
      onChanged();
      return this;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.cloud.aiplatform.v1beta1.PipelineTaskRerunConfig)
  }

  // @@protoc_insertion_point(class_scope:google.cloud.aiplatform.v1beta1.PipelineTaskRerunConfig)
  private static final com.google.cloud.aiplatform.v1beta1.PipelineTaskRerunConfig DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.cloud.aiplatform.v1beta1.PipelineTaskRerunConfig();
  }

  public static com.google.cloud.aiplatform.v1beta1.PipelineTaskRerunConfig getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<PipelineTaskRerunConfig> PARSER =
      new com.google.protobuf.AbstractParser<PipelineTaskRerunConfig>() {
        @java.lang.Override
        public PipelineTaskRerunConfig parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          Builder builder = newBuilder();
          try {
            builder.mergeFrom(input, extensionRegistry);
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.setUnfinishedMessage(builder.buildPartial());
          } catch (com.google.protobuf.UninitializedMessageException e) {
            throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
          } catch (java.io.IOException e) {
            throw new com.google.protobuf.InvalidProtocolBufferException(e)
                .setUnfinishedMessage(builder.buildPartial());
          }
          return builder.buildPartial();
        }
      };

  public static com.google.protobuf.Parser<PipelineTaskRerunConfig> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<PipelineTaskRerunConfig> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.cloud.aiplatform.v1beta1.PipelineTaskRerunConfig getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
