/*
 * Copyright 2024 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/cloud/aiplatform/v1beta1/extension.proto

// Protobuf Java Version: 3.25.5
package com.google.cloud.aiplatform.v1beta1;

/**
 *
 *
 * <pre>
 * Extensions are tools for large language models to access external data, run
 * computations, etc.
 * </pre>
 *
 * Protobuf type {@code google.cloud.aiplatform.v1beta1.Extension}
 */
public final class Extension extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.cloud.aiplatform.v1beta1.Extension)
    ExtensionOrBuilder {
  private static final long serialVersionUID = 0L;
  // Use Extension.newBuilder() to construct.
  private Extension(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private Extension() {
    name_ = "";
    displayName_ = "";
    description_ = "";
    etag_ = "";
    extensionOperations_ = java.util.Collections.emptyList();
    toolUseExamples_ = java.util.Collections.emptyList();
  }

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new Extension();
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.cloud.aiplatform.v1beta1.ExtensionProto
        .internal_static_google_cloud_aiplatform_v1beta1_Extension_descriptor;
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.cloud.aiplatform.v1beta1.ExtensionProto
        .internal_static_google_cloud_aiplatform_v1beta1_Extension_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.cloud.aiplatform.v1beta1.Extension.class,
            com.google.cloud.aiplatform.v1beta1.Extension.Builder.class);
  }

  private int bitField0_;
  public static final int NAME_FIELD_NUMBER = 1;

  @SuppressWarnings("serial")
  private volatile java.lang.Object name_ = "";
  /**
   *
   *
   * <pre>
   * Identifier. The resource name of the Extension.
   * </pre>
   *
   * <code>string name = 1 [(.google.api.field_behavior) = IDENTIFIER];</code>
   *
   * @return The name.
   */
  @java.lang.Override
  public java.lang.String getName() {
    java.lang.Object ref = name_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      name_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Identifier. The resource name of the Extension.
   * </pre>
   *
   * <code>string name = 1 [(.google.api.field_behavior) = IDENTIFIER];</code>
   *
   * @return The bytes for name.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getNameBytes() {
    java.lang.Object ref = name_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      name_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int DISPLAY_NAME_FIELD_NUMBER = 3;

  @SuppressWarnings("serial")
  private volatile java.lang.Object displayName_ = "";
  /**
   *
   *
   * <pre>
   * Required. The display name of the Extension.
   * The name can be up to 128 characters long and can consist of any UTF-8
   * characters.
   * </pre>
   *
   * <code>string display_name = 3 [(.google.api.field_behavior) = REQUIRED];</code>
   *
   * @return The displayName.
   */
  @java.lang.Override
  public java.lang.String getDisplayName() {
    java.lang.Object ref = displayName_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      displayName_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Required. The display name of the Extension.
   * The name can be up to 128 characters long and can consist of any UTF-8
   * characters.
   * </pre>
   *
   * <code>string display_name = 3 [(.google.api.field_behavior) = REQUIRED];</code>
   *
   * @return The bytes for displayName.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getDisplayNameBytes() {
    java.lang.Object ref = displayName_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      displayName_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int DESCRIPTION_FIELD_NUMBER = 4;

  @SuppressWarnings("serial")
  private volatile java.lang.Object description_ = "";
  /**
   *
   *
   * <pre>
   * Optional. The description of the Extension.
   * </pre>
   *
   * <code>string description = 4 [(.google.api.field_behavior) = OPTIONAL];</code>
   *
   * @return The description.
   */
  @java.lang.Override
  public java.lang.String getDescription() {
    java.lang.Object ref = description_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      description_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Optional. The description of the Extension.
   * </pre>
   *
   * <code>string description = 4 [(.google.api.field_behavior) = OPTIONAL];</code>
   *
   * @return The bytes for description.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getDescriptionBytes() {
    java.lang.Object ref = description_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      description_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int CREATE_TIME_FIELD_NUMBER = 5;
  private com.google.protobuf.Timestamp createTime_;
  /**
   *
   *
   * <pre>
   * Output only. Timestamp when this Extension was created.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp create_time = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return Whether the createTime field is set.
   */
  @java.lang.Override
  public boolean hasCreateTime() {
    return ((bitField0_ & 0x00000001) != 0);
  }
  /**
   *
   *
   * <pre>
   * Output only. Timestamp when this Extension was created.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp create_time = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return The createTime.
   */
  @java.lang.Override
  public com.google.protobuf.Timestamp getCreateTime() {
    return createTime_ == null ? com.google.protobuf.Timestamp.getDefaultInstance() : createTime_;
  }
  /**
   *
   *
   * <pre>
   * Output only. Timestamp when this Extension was created.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp create_time = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   */
  @java.lang.Override
  public com.google.protobuf.TimestampOrBuilder getCreateTimeOrBuilder() {
    return createTime_ == null ? com.google.protobuf.Timestamp.getDefaultInstance() : createTime_;
  }

  public static final int UPDATE_TIME_FIELD_NUMBER = 6;
  private com.google.protobuf.Timestamp updateTime_;
  /**
   *
   *
   * <pre>
   * Output only. Timestamp when this Extension was most recently updated.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp update_time = 6 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return Whether the updateTime field is set.
   */
  @java.lang.Override
  public boolean hasUpdateTime() {
    return ((bitField0_ & 0x00000002) != 0);
  }
  /**
   *
   *
   * <pre>
   * Output only. Timestamp when this Extension was most recently updated.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp update_time = 6 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return The updateTime.
   */
  @java.lang.Override
  public com.google.protobuf.Timestamp getUpdateTime() {
    return updateTime_ == null ? com.google.protobuf.Timestamp.getDefaultInstance() : updateTime_;
  }
  /**
   *
   *
   * <pre>
   * Output only. Timestamp when this Extension was most recently updated.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp update_time = 6 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   */
  @java.lang.Override
  public com.google.protobuf.TimestampOrBuilder getUpdateTimeOrBuilder() {
    return updateTime_ == null ? com.google.protobuf.Timestamp.getDefaultInstance() : updateTime_;
  }

  public static final int ETAG_FIELD_NUMBER = 7;

  @SuppressWarnings("serial")
  private volatile java.lang.Object etag_ = "";
  /**
   *
   *
   * <pre>
   * Optional. Used to perform consistent read-modify-write updates. If not set,
   * a blind "overwrite" update happens.
   * </pre>
   *
   * <code>string etag = 7 [(.google.api.field_behavior) = OPTIONAL];</code>
   *
   * @return The etag.
   */
  @java.lang.Override
  public java.lang.String getEtag() {
    java.lang.Object ref = etag_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      etag_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Optional. Used to perform consistent read-modify-write updates. If not set,
   * a blind "overwrite" update happens.
   * </pre>
   *
   * <code>string etag = 7 [(.google.api.field_behavior) = OPTIONAL];</code>
   *
   * @return The bytes for etag.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getEtagBytes() {
    java.lang.Object ref = etag_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      etag_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int MANIFEST_FIELD_NUMBER = 9;
  private com.google.cloud.aiplatform.v1beta1.ExtensionManifest manifest_;
  /**
   *
   *
   * <pre>
   * Required. Manifest of the Extension.
   * </pre>
   *
   * <code>
   * .google.cloud.aiplatform.v1beta1.ExtensionManifest manifest = 9 [(.google.api.field_behavior) = REQUIRED];
   * </code>
   *
   * @return Whether the manifest field is set.
   */
  @java.lang.Override
  public boolean hasManifest() {
    return ((bitField0_ & 0x00000004) != 0);
  }
  /**
   *
   *
   * <pre>
   * Required. Manifest of the Extension.
   * </pre>
   *
   * <code>
   * .google.cloud.aiplatform.v1beta1.ExtensionManifest manifest = 9 [(.google.api.field_behavior) = REQUIRED];
   * </code>
   *
   * @return The manifest.
   */
  @java.lang.Override
  public com.google.cloud.aiplatform.v1beta1.ExtensionManifest getManifest() {
    return manifest_ == null
        ? com.google.cloud.aiplatform.v1beta1.ExtensionManifest.getDefaultInstance()
        : manifest_;
  }
  /**
   *
   *
   * <pre>
   * Required. Manifest of the Extension.
   * </pre>
   *
   * <code>
   * .google.cloud.aiplatform.v1beta1.ExtensionManifest manifest = 9 [(.google.api.field_behavior) = REQUIRED];
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.aiplatform.v1beta1.ExtensionManifestOrBuilder getManifestOrBuilder() {
    return manifest_ == null
        ? com.google.cloud.aiplatform.v1beta1.ExtensionManifest.getDefaultInstance()
        : manifest_;
  }

  public static final int EXTENSION_OPERATIONS_FIELD_NUMBER = 11;

  @SuppressWarnings("serial")
  private java.util.List<com.google.cloud.aiplatform.v1beta1.ExtensionOperation>
      extensionOperations_;
  /**
   *
   *
   * <pre>
   * Output only. Supported operations.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.aiplatform.v1beta1.ExtensionOperation extension_operations = 11 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   */
  @java.lang.Override
  public java.util.List<com.google.cloud.aiplatform.v1beta1.ExtensionOperation>
      getExtensionOperationsList() {
    return extensionOperations_;
  }
  /**
   *
   *
   * <pre>
   * Output only. Supported operations.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.aiplatform.v1beta1.ExtensionOperation extension_operations = 11 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   */
  @java.lang.Override
  public java.util.List<? extends com.google.cloud.aiplatform.v1beta1.ExtensionOperationOrBuilder>
      getExtensionOperationsOrBuilderList() {
    return extensionOperations_;
  }
  /**
   *
   *
   * <pre>
   * Output only. Supported operations.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.aiplatform.v1beta1.ExtensionOperation extension_operations = 11 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   */
  @java.lang.Override
  public int getExtensionOperationsCount() {
    return extensionOperations_.size();
  }
  /**
   *
   *
   * <pre>
   * Output only. Supported operations.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.aiplatform.v1beta1.ExtensionOperation extension_operations = 11 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.aiplatform.v1beta1.ExtensionOperation getExtensionOperations(int index) {
    return extensionOperations_.get(index);
  }
  /**
   *
   *
   * <pre>
   * Output only. Supported operations.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.aiplatform.v1beta1.ExtensionOperation extension_operations = 11 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.aiplatform.v1beta1.ExtensionOperationOrBuilder
      getExtensionOperationsOrBuilder(int index) {
    return extensionOperations_.get(index);
  }

  public static final int RUNTIME_CONFIG_FIELD_NUMBER = 13;
  private com.google.cloud.aiplatform.v1beta1.RuntimeConfig runtimeConfig_;
  /**
   *
   *
   * <pre>
   * Optional. Runtime config controlling the runtime behavior of this
   * Extension.
   * </pre>
   *
   * <code>
   * .google.cloud.aiplatform.v1beta1.RuntimeConfig runtime_config = 13 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   *
   * @return Whether the runtimeConfig field is set.
   */
  @java.lang.Override
  public boolean hasRuntimeConfig() {
    return ((bitField0_ & 0x00000008) != 0);
  }
  /**
   *
   *
   * <pre>
   * Optional. Runtime config controlling the runtime behavior of this
   * Extension.
   * </pre>
   *
   * <code>
   * .google.cloud.aiplatform.v1beta1.RuntimeConfig runtime_config = 13 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   *
   * @return The runtimeConfig.
   */
  @java.lang.Override
  public com.google.cloud.aiplatform.v1beta1.RuntimeConfig getRuntimeConfig() {
    return runtimeConfig_ == null
        ? com.google.cloud.aiplatform.v1beta1.RuntimeConfig.getDefaultInstance()
        : runtimeConfig_;
  }
  /**
   *
   *
   * <pre>
   * Optional. Runtime config controlling the runtime behavior of this
   * Extension.
   * </pre>
   *
   * <code>
   * .google.cloud.aiplatform.v1beta1.RuntimeConfig runtime_config = 13 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.aiplatform.v1beta1.RuntimeConfigOrBuilder getRuntimeConfigOrBuilder() {
    return runtimeConfig_ == null
        ? com.google.cloud.aiplatform.v1beta1.RuntimeConfig.getDefaultInstance()
        : runtimeConfig_;
  }

  public static final int TOOL_USE_EXAMPLES_FIELD_NUMBER = 15;

  @SuppressWarnings("serial")
  private java.util.List<com.google.cloud.aiplatform.v1beta1.ToolUseExample> toolUseExamples_;
  /**
   *
   *
   * <pre>
   * Optional. Examples to illustrate the usage of the extension as a tool.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.aiplatform.v1beta1.ToolUseExample tool_use_examples = 15 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   */
  @java.lang.Override
  public java.util.List<com.google.cloud.aiplatform.v1beta1.ToolUseExample>
      getToolUseExamplesList() {
    return toolUseExamples_;
  }
  /**
   *
   *
   * <pre>
   * Optional. Examples to illustrate the usage of the extension as a tool.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.aiplatform.v1beta1.ToolUseExample tool_use_examples = 15 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   */
  @java.lang.Override
  public java.util.List<? extends com.google.cloud.aiplatform.v1beta1.ToolUseExampleOrBuilder>
      getToolUseExamplesOrBuilderList() {
    return toolUseExamples_;
  }
  /**
   *
   *
   * <pre>
   * Optional. Examples to illustrate the usage of the extension as a tool.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.aiplatform.v1beta1.ToolUseExample tool_use_examples = 15 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   */
  @java.lang.Override
  public int getToolUseExamplesCount() {
    return toolUseExamples_.size();
  }
  /**
   *
   *
   * <pre>
   * Optional. Examples to illustrate the usage of the extension as a tool.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.aiplatform.v1beta1.ToolUseExample tool_use_examples = 15 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.aiplatform.v1beta1.ToolUseExample getToolUseExamples(int index) {
    return toolUseExamples_.get(index);
  }
  /**
   *
   *
   * <pre>
   * Optional. Examples to illustrate the usage of the extension as a tool.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.aiplatform.v1beta1.ToolUseExample tool_use_examples = 15 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.aiplatform.v1beta1.ToolUseExampleOrBuilder getToolUseExamplesOrBuilder(
      int index) {
    return toolUseExamples_.get(index);
  }

  public static final int PRIVATE_SERVICE_CONNECT_CONFIG_FIELD_NUMBER = 16;
  private com.google.cloud.aiplatform.v1beta1.ExtensionPrivateServiceConnectConfig
      privateServiceConnectConfig_;
  /**
   *
   *
   * <pre>
   * Optional. The PrivateServiceConnect config for the extension.
   * If specified, the service endpoints associated with the
   * Extension should be registered with private network access in the provided
   * Service Directory
   * (https://cloud.google.com/service-directory/docs/configuring-private-network-access).
   *
   * If the service contains more than one endpoint with a network, the service
   * will arbitrarilty choose one of the endpoints to use for extension
   * execution.
   * </pre>
   *
   * <code>
   * .google.cloud.aiplatform.v1beta1.ExtensionPrivateServiceConnectConfig private_service_connect_config = 16 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   *
   * @return Whether the privateServiceConnectConfig field is set.
   */
  @java.lang.Override
  public boolean hasPrivateServiceConnectConfig() {
    return ((bitField0_ & 0x00000010) != 0);
  }
  /**
   *
   *
   * <pre>
   * Optional. The PrivateServiceConnect config for the extension.
   * If specified, the service endpoints associated with the
   * Extension should be registered with private network access in the provided
   * Service Directory
   * (https://cloud.google.com/service-directory/docs/configuring-private-network-access).
   *
   * If the service contains more than one endpoint with a network, the service
   * will arbitrarilty choose one of the endpoints to use for extension
   * execution.
   * </pre>
   *
   * <code>
   * .google.cloud.aiplatform.v1beta1.ExtensionPrivateServiceConnectConfig private_service_connect_config = 16 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   *
   * @return The privateServiceConnectConfig.
   */
  @java.lang.Override
  public com.google.cloud.aiplatform.v1beta1.ExtensionPrivateServiceConnectConfig
      getPrivateServiceConnectConfig() {
    return privateServiceConnectConfig_ == null
        ? com.google.cloud.aiplatform.v1beta1.ExtensionPrivateServiceConnectConfig
            .getDefaultInstance()
        : privateServiceConnectConfig_;
  }
  /**
   *
   *
   * <pre>
   * Optional. The PrivateServiceConnect config for the extension.
   * If specified, the service endpoints associated with the
   * Extension should be registered with private network access in the provided
   * Service Directory
   * (https://cloud.google.com/service-directory/docs/configuring-private-network-access).
   *
   * If the service contains more than one endpoint with a network, the service
   * will arbitrarilty choose one of the endpoints to use for extension
   * execution.
   * </pre>
   *
   * <code>
   * .google.cloud.aiplatform.v1beta1.ExtensionPrivateServiceConnectConfig private_service_connect_config = 16 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.aiplatform.v1beta1.ExtensionPrivateServiceConnectConfigOrBuilder
      getPrivateServiceConnectConfigOrBuilder() {
    return privateServiceConnectConfig_ == null
        ? com.google.cloud.aiplatform.v1beta1.ExtensionPrivateServiceConnectConfig
            .getDefaultInstance()
        : privateServiceConnectConfig_;
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(name_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 1, name_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(displayName_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 3, displayName_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(description_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 4, description_);
    }
    if (((bitField0_ & 0x00000001) != 0)) {
      output.writeMessage(5, getCreateTime());
    }
    if (((bitField0_ & 0x00000002) != 0)) {
      output.writeMessage(6, getUpdateTime());
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(etag_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 7, etag_);
    }
    if (((bitField0_ & 0x00000004) != 0)) {
      output.writeMessage(9, getManifest());
    }
    for (int i = 0; i < extensionOperations_.size(); i++) {
      output.writeMessage(11, extensionOperations_.get(i));
    }
    if (((bitField0_ & 0x00000008) != 0)) {
      output.writeMessage(13, getRuntimeConfig());
    }
    for (int i = 0; i < toolUseExamples_.size(); i++) {
      output.writeMessage(15, toolUseExamples_.get(i));
    }
    if (((bitField0_ & 0x00000010) != 0)) {
      output.writeMessage(16, getPrivateServiceConnectConfig());
    }
    getUnknownFields().writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(name_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(1, name_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(displayName_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(3, displayName_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(description_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(4, description_);
    }
    if (((bitField0_ & 0x00000001) != 0)) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(5, getCreateTime());
    }
    if (((bitField0_ & 0x00000002) != 0)) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(6, getUpdateTime());
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(etag_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(7, etag_);
    }
    if (((bitField0_ & 0x00000004) != 0)) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(9, getManifest());
    }
    for (int i = 0; i < extensionOperations_.size(); i++) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(11, extensionOperations_.get(i));
    }
    if (((bitField0_ & 0x00000008) != 0)) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(13, getRuntimeConfig());
    }
    for (int i = 0; i < toolUseExamples_.size(); i++) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(15, toolUseExamples_.get(i));
    }
    if (((bitField0_ & 0x00000010) != 0)) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(
              16, getPrivateServiceConnectConfig());
    }
    size += getUnknownFields().getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.cloud.aiplatform.v1beta1.Extension)) {
      return super.equals(obj);
    }
    com.google.cloud.aiplatform.v1beta1.Extension other =
        (com.google.cloud.aiplatform.v1beta1.Extension) obj;

    if (!getName().equals(other.getName())) return false;
    if (!getDisplayName().equals(other.getDisplayName())) return false;
    if (!getDescription().equals(other.getDescription())) return false;
    if (hasCreateTime() != other.hasCreateTime()) return false;
    if (hasCreateTime()) {
      if (!getCreateTime().equals(other.getCreateTime())) return false;
    }
    if (hasUpdateTime() != other.hasUpdateTime()) return false;
    if (hasUpdateTime()) {
      if (!getUpdateTime().equals(other.getUpdateTime())) return false;
    }
    if (!getEtag().equals(other.getEtag())) return false;
    if (hasManifest() != other.hasManifest()) return false;
    if (hasManifest()) {
      if (!getManifest().equals(other.getManifest())) return false;
    }
    if (!getExtensionOperationsList().equals(other.getExtensionOperationsList())) return false;
    if (hasRuntimeConfig() != other.hasRuntimeConfig()) return false;
    if (hasRuntimeConfig()) {
      if (!getRuntimeConfig().equals(other.getRuntimeConfig())) return false;
    }
    if (!getToolUseExamplesList().equals(other.getToolUseExamplesList())) return false;
    if (hasPrivateServiceConnectConfig() != other.hasPrivateServiceConnectConfig()) return false;
    if (hasPrivateServiceConnectConfig()) {
      if (!getPrivateServiceConnectConfig().equals(other.getPrivateServiceConnectConfig()))
        return false;
    }
    if (!getUnknownFields().equals(other.getUnknownFields())) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    hash = (37 * hash) + NAME_FIELD_NUMBER;
    hash = (53 * hash) + getName().hashCode();
    hash = (37 * hash) + DISPLAY_NAME_FIELD_NUMBER;
    hash = (53 * hash) + getDisplayName().hashCode();
    hash = (37 * hash) + DESCRIPTION_FIELD_NUMBER;
    hash = (53 * hash) + getDescription().hashCode();
    if (hasCreateTime()) {
      hash = (37 * hash) + CREATE_TIME_FIELD_NUMBER;
      hash = (53 * hash) + getCreateTime().hashCode();
    }
    if (hasUpdateTime()) {
      hash = (37 * hash) + UPDATE_TIME_FIELD_NUMBER;
      hash = (53 * hash) + getUpdateTime().hashCode();
    }
    hash = (37 * hash) + ETAG_FIELD_NUMBER;
    hash = (53 * hash) + getEtag().hashCode();
    if (hasManifest()) {
      hash = (37 * hash) + MANIFEST_FIELD_NUMBER;
      hash = (53 * hash) + getManifest().hashCode();
    }
    if (getExtensionOperationsCount() > 0) {
      hash = (37 * hash) + EXTENSION_OPERATIONS_FIELD_NUMBER;
      hash = (53 * hash) + getExtensionOperationsList().hashCode();
    }
    if (hasRuntimeConfig()) {
      hash = (37 * hash) + RUNTIME_CONFIG_FIELD_NUMBER;
      hash = (53 * hash) + getRuntimeConfig().hashCode();
    }
    if (getToolUseExamplesCount() > 0) {
      hash = (37 * hash) + TOOL_USE_EXAMPLES_FIELD_NUMBER;
      hash = (53 * hash) + getToolUseExamplesList().hashCode();
    }
    if (hasPrivateServiceConnectConfig()) {
      hash = (37 * hash) + PRIVATE_SERVICE_CONNECT_CONFIG_FIELD_NUMBER;
      hash = (53 * hash) + getPrivateServiceConnectConfig().hashCode();
    }
    hash = (29 * hash) + getUnknownFields().hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.cloud.aiplatform.v1beta1.Extension parseFrom(java.nio.ByteBuffer data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.aiplatform.v1beta1.Extension parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.aiplatform.v1beta1.Extension parseFrom(
      com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.aiplatform.v1beta1.Extension parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.aiplatform.v1beta1.Extension parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.aiplatform.v1beta1.Extension parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.aiplatform.v1beta1.Extension parseFrom(java.io.InputStream input)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.aiplatform.v1beta1.Extension parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.aiplatform.v1beta1.Extension parseDelimitedFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.cloud.aiplatform.v1beta1.Extension parseDelimitedFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.aiplatform.v1beta1.Extension parseFrom(
      com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.aiplatform.v1beta1.Extension parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(com.google.cloud.aiplatform.v1beta1.Extension prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }
  /**
   *
   *
   * <pre>
   * Extensions are tools for large language models to access external data, run
   * computations, etc.
   * </pre>
   *
   * Protobuf type {@code google.cloud.aiplatform.v1beta1.Extension}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.cloud.aiplatform.v1beta1.Extension)
      com.google.cloud.aiplatform.v1beta1.ExtensionOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.aiplatform.v1beta1.ExtensionProto
          .internal_static_google_cloud_aiplatform_v1beta1_Extension_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.aiplatform.v1beta1.ExtensionProto
          .internal_static_google_cloud_aiplatform_v1beta1_Extension_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.aiplatform.v1beta1.Extension.class,
              com.google.cloud.aiplatform.v1beta1.Extension.Builder.class);
    }

    // Construct using com.google.cloud.aiplatform.v1beta1.Extension.newBuilder()
    private Builder() {
      maybeForceBuilderInitialization();
    }

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
      maybeForceBuilderInitialization();
    }

    private void maybeForceBuilderInitialization() {
      if (com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders) {
        getCreateTimeFieldBuilder();
        getUpdateTimeFieldBuilder();
        getManifestFieldBuilder();
        getExtensionOperationsFieldBuilder();
        getRuntimeConfigFieldBuilder();
        getToolUseExamplesFieldBuilder();
        getPrivateServiceConnectConfigFieldBuilder();
      }
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      bitField0_ = 0;
      name_ = "";
      displayName_ = "";
      description_ = "";
      createTime_ = null;
      if (createTimeBuilder_ != null) {
        createTimeBuilder_.dispose();
        createTimeBuilder_ = null;
      }
      updateTime_ = null;
      if (updateTimeBuilder_ != null) {
        updateTimeBuilder_.dispose();
        updateTimeBuilder_ = null;
      }
      etag_ = "";
      manifest_ = null;
      if (manifestBuilder_ != null) {
        manifestBuilder_.dispose();
        manifestBuilder_ = null;
      }
      if (extensionOperationsBuilder_ == null) {
        extensionOperations_ = java.util.Collections.emptyList();
      } else {
        extensionOperations_ = null;
        extensionOperationsBuilder_.clear();
      }
      bitField0_ = (bitField0_ & ~0x00000080);
      runtimeConfig_ = null;
      if (runtimeConfigBuilder_ != null) {
        runtimeConfigBuilder_.dispose();
        runtimeConfigBuilder_ = null;
      }
      if (toolUseExamplesBuilder_ == null) {
        toolUseExamples_ = java.util.Collections.emptyList();
      } else {
        toolUseExamples_ = null;
        toolUseExamplesBuilder_.clear();
      }
      bitField0_ = (bitField0_ & ~0x00000200);
      privateServiceConnectConfig_ = null;
      if (privateServiceConnectConfigBuilder_ != null) {
        privateServiceConnectConfigBuilder_.dispose();
        privateServiceConnectConfigBuilder_ = null;
      }
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.cloud.aiplatform.v1beta1.ExtensionProto
          .internal_static_google_cloud_aiplatform_v1beta1_Extension_descriptor;
    }

    @java.lang.Override
    public com.google.cloud.aiplatform.v1beta1.Extension getDefaultInstanceForType() {
      return com.google.cloud.aiplatform.v1beta1.Extension.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.cloud.aiplatform.v1beta1.Extension build() {
      com.google.cloud.aiplatform.v1beta1.Extension result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.cloud.aiplatform.v1beta1.Extension buildPartial() {
      com.google.cloud.aiplatform.v1beta1.Extension result =
          new com.google.cloud.aiplatform.v1beta1.Extension(this);
      buildPartialRepeatedFields(result);
      if (bitField0_ != 0) {
        buildPartial0(result);
      }
      onBuilt();
      return result;
    }

    private void buildPartialRepeatedFields(com.google.cloud.aiplatform.v1beta1.Extension result) {
      if (extensionOperationsBuilder_ == null) {
        if (((bitField0_ & 0x00000080) != 0)) {
          extensionOperations_ = java.util.Collections.unmodifiableList(extensionOperations_);
          bitField0_ = (bitField0_ & ~0x00000080);
        }
        result.extensionOperations_ = extensionOperations_;
      } else {
        result.extensionOperations_ = extensionOperationsBuilder_.build();
      }
      if (toolUseExamplesBuilder_ == null) {
        if (((bitField0_ & 0x00000200) != 0)) {
          toolUseExamples_ = java.util.Collections.unmodifiableList(toolUseExamples_);
          bitField0_ = (bitField0_ & ~0x00000200);
        }
        result.toolUseExamples_ = toolUseExamples_;
      } else {
        result.toolUseExamples_ = toolUseExamplesBuilder_.build();
      }
    }

    private void buildPartial0(com.google.cloud.aiplatform.v1beta1.Extension result) {
      int from_bitField0_ = bitField0_;
      if (((from_bitField0_ & 0x00000001) != 0)) {
        result.name_ = name_;
      }
      if (((from_bitField0_ & 0x00000002) != 0)) {
        result.displayName_ = displayName_;
      }
      if (((from_bitField0_ & 0x00000004) != 0)) {
        result.description_ = description_;
      }
      int to_bitField0_ = 0;
      if (((from_bitField0_ & 0x00000008) != 0)) {
        result.createTime_ = createTimeBuilder_ == null ? createTime_ : createTimeBuilder_.build();
        to_bitField0_ |= 0x00000001;
      }
      if (((from_bitField0_ & 0x00000010) != 0)) {
        result.updateTime_ = updateTimeBuilder_ == null ? updateTime_ : updateTimeBuilder_.build();
        to_bitField0_ |= 0x00000002;
      }
      if (((from_bitField0_ & 0x00000020) != 0)) {
        result.etag_ = etag_;
      }
      if (((from_bitField0_ & 0x00000040) != 0)) {
        result.manifest_ = manifestBuilder_ == null ? manifest_ : manifestBuilder_.build();
        to_bitField0_ |= 0x00000004;
      }
      if (((from_bitField0_ & 0x00000100) != 0)) {
        result.runtimeConfig_ =
            runtimeConfigBuilder_ == null ? runtimeConfig_ : runtimeConfigBuilder_.build();
        to_bitField0_ |= 0x00000008;
      }
      if (((from_bitField0_ & 0x00000400) != 0)) {
        result.privateServiceConnectConfig_ =
            privateServiceConnectConfigBuilder_ == null
                ? privateServiceConnectConfig_
                : privateServiceConnectConfigBuilder_.build();
        to_bitField0_ |= 0x00000010;
      }
      result.bitField0_ |= to_bitField0_;
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.cloud.aiplatform.v1beta1.Extension) {
        return mergeFrom((com.google.cloud.aiplatform.v1beta1.Extension) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(com.google.cloud.aiplatform.v1beta1.Extension other) {
      if (other == com.google.cloud.aiplatform.v1beta1.Extension.getDefaultInstance()) return this;
      if (!other.getName().isEmpty()) {
        name_ = other.name_;
        bitField0_ |= 0x00000001;
        onChanged();
      }
      if (!other.getDisplayName().isEmpty()) {
        displayName_ = other.displayName_;
        bitField0_ |= 0x00000002;
        onChanged();
      }
      if (!other.getDescription().isEmpty()) {
        description_ = other.description_;
        bitField0_ |= 0x00000004;
        onChanged();
      }
      if (other.hasCreateTime()) {
        mergeCreateTime(other.getCreateTime());
      }
      if (other.hasUpdateTime()) {
        mergeUpdateTime(other.getUpdateTime());
      }
      if (!other.getEtag().isEmpty()) {
        etag_ = other.etag_;
        bitField0_ |= 0x00000020;
        onChanged();
      }
      if (other.hasManifest()) {
        mergeManifest(other.getManifest());
      }
      if (extensionOperationsBuilder_ == null) {
        if (!other.extensionOperations_.isEmpty()) {
          if (extensionOperations_.isEmpty()) {
            extensionOperations_ = other.extensionOperations_;
            bitField0_ = (bitField0_ & ~0x00000080);
          } else {
            ensureExtensionOperationsIsMutable();
            extensionOperations_.addAll(other.extensionOperations_);
          }
          onChanged();
        }
      } else {
        if (!other.extensionOperations_.isEmpty()) {
          if (extensionOperationsBuilder_.isEmpty()) {
            extensionOperationsBuilder_.dispose();
            extensionOperationsBuilder_ = null;
            extensionOperations_ = other.extensionOperations_;
            bitField0_ = (bitField0_ & ~0x00000080);
            extensionOperationsBuilder_ =
                com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders
                    ? getExtensionOperationsFieldBuilder()
                    : null;
          } else {
            extensionOperationsBuilder_.addAllMessages(other.extensionOperations_);
          }
        }
      }
      if (other.hasRuntimeConfig()) {
        mergeRuntimeConfig(other.getRuntimeConfig());
      }
      if (toolUseExamplesBuilder_ == null) {
        if (!other.toolUseExamples_.isEmpty()) {
          if (toolUseExamples_.isEmpty()) {
            toolUseExamples_ = other.toolUseExamples_;
            bitField0_ = (bitField0_ & ~0x00000200);
          } else {
            ensureToolUseExamplesIsMutable();
            toolUseExamples_.addAll(other.toolUseExamples_);
          }
          onChanged();
        }
      } else {
        if (!other.toolUseExamples_.isEmpty()) {
          if (toolUseExamplesBuilder_.isEmpty()) {
            toolUseExamplesBuilder_.dispose();
            toolUseExamplesBuilder_ = null;
            toolUseExamples_ = other.toolUseExamples_;
            bitField0_ = (bitField0_ & ~0x00000200);
            toolUseExamplesBuilder_ =
                com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders
                    ? getToolUseExamplesFieldBuilder()
                    : null;
          } else {
            toolUseExamplesBuilder_.addAllMessages(other.toolUseExamples_);
          }
        }
      }
      if (other.hasPrivateServiceConnectConfig()) {
        mergePrivateServiceConnectConfig(other.getPrivateServiceConnectConfig());
      }
      this.mergeUnknownFields(other.getUnknownFields());
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 10:
              {
                name_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000001;
                break;
              } // case 10
            case 26:
              {
                displayName_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000002;
                break;
              } // case 26
            case 34:
              {
                description_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000004;
                break;
              } // case 34
            case 42:
              {
                input.readMessage(getCreateTimeFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000008;
                break;
              } // case 42
            case 50:
              {
                input.readMessage(getUpdateTimeFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000010;
                break;
              } // case 50
            case 58:
              {
                etag_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000020;
                break;
              } // case 58
            case 74:
              {
                input.readMessage(getManifestFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000040;
                break;
              } // case 74
            case 90:
              {
                com.google.cloud.aiplatform.v1beta1.ExtensionOperation m =
                    input.readMessage(
                        com.google.cloud.aiplatform.v1beta1.ExtensionOperation.parser(),
                        extensionRegistry);
                if (extensionOperationsBuilder_ == null) {
                  ensureExtensionOperationsIsMutable();
                  extensionOperations_.add(m);
                } else {
                  extensionOperationsBuilder_.addMessage(m);
                }
                break;
              } // case 90
            case 106:
              {
                input.readMessage(getRuntimeConfigFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000100;
                break;
              } // case 106
            case 122:
              {
                com.google.cloud.aiplatform.v1beta1.ToolUseExample m =
                    input.readMessage(
                        com.google.cloud.aiplatform.v1beta1.ToolUseExample.parser(),
                        extensionRegistry);
                if (toolUseExamplesBuilder_ == null) {
                  ensureToolUseExamplesIsMutable();
                  toolUseExamples_.add(m);
                } else {
                  toolUseExamplesBuilder_.addMessage(m);
                }
                break;
              } // case 122
            case 130:
              {
                input.readMessage(
                    getPrivateServiceConnectConfigFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000400;
                break;
              } // case 130
            default:
              {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
          } // switch (tag)
        } // while (!done)
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.unwrapIOException();
      } finally {
        onChanged();
      } // finally
      return this;
    }

    private int bitField0_;

    private java.lang.Object name_ = "";
    /**
     *
     *
     * <pre>
     * Identifier. The resource name of the Extension.
     * </pre>
     *
     * <code>string name = 1 [(.google.api.field_behavior) = IDENTIFIER];</code>
     *
     * @return The name.
     */
    public java.lang.String getName() {
      java.lang.Object ref = name_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        name_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Identifier. The resource name of the Extension.
     * </pre>
     *
     * <code>string name = 1 [(.google.api.field_behavior) = IDENTIFIER];</code>
     *
     * @return The bytes for name.
     */
    public com.google.protobuf.ByteString getNameBytes() {
      java.lang.Object ref = name_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        name_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Identifier. The resource name of the Extension.
     * </pre>
     *
     * <code>string name = 1 [(.google.api.field_behavior) = IDENTIFIER];</code>
     *
     * @param value The name to set.
     * @return This builder for chaining.
     */
    public Builder setName(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      name_ = value;
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Identifier. The resource name of the Extension.
     * </pre>
     *
     * <code>string name = 1 [(.google.api.field_behavior) = IDENTIFIER];</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearName() {
      name_ = getDefaultInstance().getName();
      bitField0_ = (bitField0_ & ~0x00000001);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Identifier. The resource name of the Extension.
     * </pre>
     *
     * <code>string name = 1 [(.google.api.field_behavior) = IDENTIFIER];</code>
     *
     * @param value The bytes for name to set.
     * @return This builder for chaining.
     */
    public Builder setNameBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      name_ = value;
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }

    private java.lang.Object displayName_ = "";
    /**
     *
     *
     * <pre>
     * Required. The display name of the Extension.
     * The name can be up to 128 characters long and can consist of any UTF-8
     * characters.
     * </pre>
     *
     * <code>string display_name = 3 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return The displayName.
     */
    public java.lang.String getDisplayName() {
      java.lang.Object ref = displayName_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        displayName_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Required. The display name of the Extension.
     * The name can be up to 128 characters long and can consist of any UTF-8
     * characters.
     * </pre>
     *
     * <code>string display_name = 3 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return The bytes for displayName.
     */
    public com.google.protobuf.ByteString getDisplayNameBytes() {
      java.lang.Object ref = displayName_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        displayName_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Required. The display name of the Extension.
     * The name can be up to 128 characters long and can consist of any UTF-8
     * characters.
     * </pre>
     *
     * <code>string display_name = 3 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @param value The displayName to set.
     * @return This builder for chaining.
     */
    public Builder setDisplayName(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      displayName_ = value;
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. The display name of the Extension.
     * The name can be up to 128 characters long and can consist of any UTF-8
     * characters.
     * </pre>
     *
     * <code>string display_name = 3 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearDisplayName() {
      displayName_ = getDefaultInstance().getDisplayName();
      bitField0_ = (bitField0_ & ~0x00000002);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. The display name of the Extension.
     * The name can be up to 128 characters long and can consist of any UTF-8
     * characters.
     * </pre>
     *
     * <code>string display_name = 3 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @param value The bytes for displayName to set.
     * @return This builder for chaining.
     */
    public Builder setDisplayNameBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      displayName_ = value;
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }

    private java.lang.Object description_ = "";
    /**
     *
     *
     * <pre>
     * Optional. The description of the Extension.
     * </pre>
     *
     * <code>string description = 4 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return The description.
     */
    public java.lang.String getDescription() {
      java.lang.Object ref = description_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        description_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Optional. The description of the Extension.
     * </pre>
     *
     * <code>string description = 4 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return The bytes for description.
     */
    public com.google.protobuf.ByteString getDescriptionBytes() {
      java.lang.Object ref = description_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        description_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Optional. The description of the Extension.
     * </pre>
     *
     * <code>string description = 4 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @param value The description to set.
     * @return This builder for chaining.
     */
    public Builder setDescription(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      description_ = value;
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. The description of the Extension.
     * </pre>
     *
     * <code>string description = 4 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearDescription() {
      description_ = getDefaultInstance().getDescription();
      bitField0_ = (bitField0_ & ~0x00000004);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. The description of the Extension.
     * </pre>
     *
     * <code>string description = 4 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @param value The bytes for description to set.
     * @return This builder for chaining.
     */
    public Builder setDescriptionBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      description_ = value;
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }

    private com.google.protobuf.Timestamp createTime_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Timestamp,
            com.google.protobuf.Timestamp.Builder,
            com.google.protobuf.TimestampOrBuilder>
        createTimeBuilder_;
    /**
     *
     *
     * <pre>
     * Output only. Timestamp when this Extension was created.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp create_time = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return Whether the createTime field is set.
     */
    public boolean hasCreateTime() {
      return ((bitField0_ & 0x00000008) != 0);
    }
    /**
     *
     *
     * <pre>
     * Output only. Timestamp when this Extension was created.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp create_time = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return The createTime.
     */
    public com.google.protobuf.Timestamp getCreateTime() {
      if (createTimeBuilder_ == null) {
        return createTime_ == null
            ? com.google.protobuf.Timestamp.getDefaultInstance()
            : createTime_;
      } else {
        return createTimeBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. Timestamp when this Extension was created.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp create_time = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder setCreateTime(com.google.protobuf.Timestamp value) {
      if (createTimeBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        createTime_ = value;
      } else {
        createTimeBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000008;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Timestamp when this Extension was created.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp create_time = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder setCreateTime(com.google.protobuf.Timestamp.Builder builderForValue) {
      if (createTimeBuilder_ == null) {
        createTime_ = builderForValue.build();
      } else {
        createTimeBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000008;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Timestamp when this Extension was created.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp create_time = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder mergeCreateTime(com.google.protobuf.Timestamp value) {
      if (createTimeBuilder_ == null) {
        if (((bitField0_ & 0x00000008) != 0)
            && createTime_ != null
            && createTime_ != com.google.protobuf.Timestamp.getDefaultInstance()) {
          getCreateTimeBuilder().mergeFrom(value);
        } else {
          createTime_ = value;
        }
      } else {
        createTimeBuilder_.mergeFrom(value);
      }
      if (createTime_ != null) {
        bitField0_ |= 0x00000008;
        onChanged();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Timestamp when this Extension was created.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp create_time = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder clearCreateTime() {
      bitField0_ = (bitField0_ & ~0x00000008);
      createTime_ = null;
      if (createTimeBuilder_ != null) {
        createTimeBuilder_.dispose();
        createTimeBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Timestamp when this Extension was created.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp create_time = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.protobuf.Timestamp.Builder getCreateTimeBuilder() {
      bitField0_ |= 0x00000008;
      onChanged();
      return getCreateTimeFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Output only. Timestamp when this Extension was created.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp create_time = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.protobuf.TimestampOrBuilder getCreateTimeOrBuilder() {
      if (createTimeBuilder_ != null) {
        return createTimeBuilder_.getMessageOrBuilder();
      } else {
        return createTime_ == null
            ? com.google.protobuf.Timestamp.getDefaultInstance()
            : createTime_;
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. Timestamp when this Extension was created.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp create_time = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Timestamp,
            com.google.protobuf.Timestamp.Builder,
            com.google.protobuf.TimestampOrBuilder>
        getCreateTimeFieldBuilder() {
      if (createTimeBuilder_ == null) {
        createTimeBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.protobuf.Timestamp,
                com.google.protobuf.Timestamp.Builder,
                com.google.protobuf.TimestampOrBuilder>(
                getCreateTime(), getParentForChildren(), isClean());
        createTime_ = null;
      }
      return createTimeBuilder_;
    }

    private com.google.protobuf.Timestamp updateTime_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Timestamp,
            com.google.protobuf.Timestamp.Builder,
            com.google.protobuf.TimestampOrBuilder>
        updateTimeBuilder_;
    /**
     *
     *
     * <pre>
     * Output only. Timestamp when this Extension was most recently updated.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp update_time = 6 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return Whether the updateTime field is set.
     */
    public boolean hasUpdateTime() {
      return ((bitField0_ & 0x00000010) != 0);
    }
    /**
     *
     *
     * <pre>
     * Output only. Timestamp when this Extension was most recently updated.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp update_time = 6 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return The updateTime.
     */
    public com.google.protobuf.Timestamp getUpdateTime() {
      if (updateTimeBuilder_ == null) {
        return updateTime_ == null
            ? com.google.protobuf.Timestamp.getDefaultInstance()
            : updateTime_;
      } else {
        return updateTimeBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. Timestamp when this Extension was most recently updated.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp update_time = 6 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder setUpdateTime(com.google.protobuf.Timestamp value) {
      if (updateTimeBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        updateTime_ = value;
      } else {
        updateTimeBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000010;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Timestamp when this Extension was most recently updated.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp update_time = 6 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder setUpdateTime(com.google.protobuf.Timestamp.Builder builderForValue) {
      if (updateTimeBuilder_ == null) {
        updateTime_ = builderForValue.build();
      } else {
        updateTimeBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000010;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Timestamp when this Extension was most recently updated.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp update_time = 6 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder mergeUpdateTime(com.google.protobuf.Timestamp value) {
      if (updateTimeBuilder_ == null) {
        if (((bitField0_ & 0x00000010) != 0)
            && updateTime_ != null
            && updateTime_ != com.google.protobuf.Timestamp.getDefaultInstance()) {
          getUpdateTimeBuilder().mergeFrom(value);
        } else {
          updateTime_ = value;
        }
      } else {
        updateTimeBuilder_.mergeFrom(value);
      }
      if (updateTime_ != null) {
        bitField0_ |= 0x00000010;
        onChanged();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Timestamp when this Extension was most recently updated.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp update_time = 6 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder clearUpdateTime() {
      bitField0_ = (bitField0_ & ~0x00000010);
      updateTime_ = null;
      if (updateTimeBuilder_ != null) {
        updateTimeBuilder_.dispose();
        updateTimeBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Timestamp when this Extension was most recently updated.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp update_time = 6 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.protobuf.Timestamp.Builder getUpdateTimeBuilder() {
      bitField0_ |= 0x00000010;
      onChanged();
      return getUpdateTimeFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Output only. Timestamp when this Extension was most recently updated.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp update_time = 6 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.protobuf.TimestampOrBuilder getUpdateTimeOrBuilder() {
      if (updateTimeBuilder_ != null) {
        return updateTimeBuilder_.getMessageOrBuilder();
      } else {
        return updateTime_ == null
            ? com.google.protobuf.Timestamp.getDefaultInstance()
            : updateTime_;
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. Timestamp when this Extension was most recently updated.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp update_time = 6 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Timestamp,
            com.google.protobuf.Timestamp.Builder,
            com.google.protobuf.TimestampOrBuilder>
        getUpdateTimeFieldBuilder() {
      if (updateTimeBuilder_ == null) {
        updateTimeBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.protobuf.Timestamp,
                com.google.protobuf.Timestamp.Builder,
                com.google.protobuf.TimestampOrBuilder>(
                getUpdateTime(), getParentForChildren(), isClean());
        updateTime_ = null;
      }
      return updateTimeBuilder_;
    }

    private java.lang.Object etag_ = "";
    /**
     *
     *
     * <pre>
     * Optional. Used to perform consistent read-modify-write updates. If not set,
     * a blind "overwrite" update happens.
     * </pre>
     *
     * <code>string etag = 7 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return The etag.
     */
    public java.lang.String getEtag() {
      java.lang.Object ref = etag_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        etag_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Optional. Used to perform consistent read-modify-write updates. If not set,
     * a blind "overwrite" update happens.
     * </pre>
     *
     * <code>string etag = 7 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return The bytes for etag.
     */
    public com.google.protobuf.ByteString getEtagBytes() {
      java.lang.Object ref = etag_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        etag_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Optional. Used to perform consistent read-modify-write updates. If not set,
     * a blind "overwrite" update happens.
     * </pre>
     *
     * <code>string etag = 7 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @param value The etag to set.
     * @return This builder for chaining.
     */
    public Builder setEtag(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      etag_ = value;
      bitField0_ |= 0x00000020;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. Used to perform consistent read-modify-write updates. If not set,
     * a blind "overwrite" update happens.
     * </pre>
     *
     * <code>string etag = 7 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearEtag() {
      etag_ = getDefaultInstance().getEtag();
      bitField0_ = (bitField0_ & ~0x00000020);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. Used to perform consistent read-modify-write updates. If not set,
     * a blind "overwrite" update happens.
     * </pre>
     *
     * <code>string etag = 7 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @param value The bytes for etag to set.
     * @return This builder for chaining.
     */
    public Builder setEtagBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      etag_ = value;
      bitField0_ |= 0x00000020;
      onChanged();
      return this;
    }

    private com.google.cloud.aiplatform.v1beta1.ExtensionManifest manifest_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.aiplatform.v1beta1.ExtensionManifest,
            com.google.cloud.aiplatform.v1beta1.ExtensionManifest.Builder,
            com.google.cloud.aiplatform.v1beta1.ExtensionManifestOrBuilder>
        manifestBuilder_;
    /**
     *
     *
     * <pre>
     * Required. Manifest of the Extension.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.ExtensionManifest manifest = 9 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     *
     * @return Whether the manifest field is set.
     */
    public boolean hasManifest() {
      return ((bitField0_ & 0x00000040) != 0);
    }
    /**
     *
     *
     * <pre>
     * Required. Manifest of the Extension.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.ExtensionManifest manifest = 9 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     *
     * @return The manifest.
     */
    public com.google.cloud.aiplatform.v1beta1.ExtensionManifest getManifest() {
      if (manifestBuilder_ == null) {
        return manifest_ == null
            ? com.google.cloud.aiplatform.v1beta1.ExtensionManifest.getDefaultInstance()
            : manifest_;
      } else {
        return manifestBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Required. Manifest of the Extension.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.ExtensionManifest manifest = 9 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public Builder setManifest(com.google.cloud.aiplatform.v1beta1.ExtensionManifest value) {
      if (manifestBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        manifest_ = value;
      } else {
        manifestBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000040;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. Manifest of the Extension.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.ExtensionManifest manifest = 9 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public Builder setManifest(
        com.google.cloud.aiplatform.v1beta1.ExtensionManifest.Builder builderForValue) {
      if (manifestBuilder_ == null) {
        manifest_ = builderForValue.build();
      } else {
        manifestBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000040;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. Manifest of the Extension.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.ExtensionManifest manifest = 9 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public Builder mergeManifest(com.google.cloud.aiplatform.v1beta1.ExtensionManifest value) {
      if (manifestBuilder_ == null) {
        if (((bitField0_ & 0x00000040) != 0)
            && manifest_ != null
            && manifest_
                != com.google.cloud.aiplatform.v1beta1.ExtensionManifest.getDefaultInstance()) {
          getManifestBuilder().mergeFrom(value);
        } else {
          manifest_ = value;
        }
      } else {
        manifestBuilder_.mergeFrom(value);
      }
      if (manifest_ != null) {
        bitField0_ |= 0x00000040;
        onChanged();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. Manifest of the Extension.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.ExtensionManifest manifest = 9 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public Builder clearManifest() {
      bitField0_ = (bitField0_ & ~0x00000040);
      manifest_ = null;
      if (manifestBuilder_ != null) {
        manifestBuilder_.dispose();
        manifestBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. Manifest of the Extension.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.ExtensionManifest manifest = 9 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public com.google.cloud.aiplatform.v1beta1.ExtensionManifest.Builder getManifestBuilder() {
      bitField0_ |= 0x00000040;
      onChanged();
      return getManifestFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Required. Manifest of the Extension.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.ExtensionManifest manifest = 9 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public com.google.cloud.aiplatform.v1beta1.ExtensionManifestOrBuilder getManifestOrBuilder() {
      if (manifestBuilder_ != null) {
        return manifestBuilder_.getMessageOrBuilder();
      } else {
        return manifest_ == null
            ? com.google.cloud.aiplatform.v1beta1.ExtensionManifest.getDefaultInstance()
            : manifest_;
      }
    }
    /**
     *
     *
     * <pre>
     * Required. Manifest of the Extension.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.ExtensionManifest manifest = 9 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.aiplatform.v1beta1.ExtensionManifest,
            com.google.cloud.aiplatform.v1beta1.ExtensionManifest.Builder,
            com.google.cloud.aiplatform.v1beta1.ExtensionManifestOrBuilder>
        getManifestFieldBuilder() {
      if (manifestBuilder_ == null) {
        manifestBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.aiplatform.v1beta1.ExtensionManifest,
                com.google.cloud.aiplatform.v1beta1.ExtensionManifest.Builder,
                com.google.cloud.aiplatform.v1beta1.ExtensionManifestOrBuilder>(
                getManifest(), getParentForChildren(), isClean());
        manifest_ = null;
      }
      return manifestBuilder_;
    }

    private java.util.List<com.google.cloud.aiplatform.v1beta1.ExtensionOperation>
        extensionOperations_ = java.util.Collections.emptyList();

    private void ensureExtensionOperationsIsMutable() {
      if (!((bitField0_ & 0x00000080) != 0)) {
        extensionOperations_ =
            new java.util.ArrayList<com.google.cloud.aiplatform.v1beta1.ExtensionOperation>(
                extensionOperations_);
        bitField0_ |= 0x00000080;
      }
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.cloud.aiplatform.v1beta1.ExtensionOperation,
            com.google.cloud.aiplatform.v1beta1.ExtensionOperation.Builder,
            com.google.cloud.aiplatform.v1beta1.ExtensionOperationOrBuilder>
        extensionOperationsBuilder_;

    /**
     *
     *
     * <pre>
     * Output only. Supported operations.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.aiplatform.v1beta1.ExtensionOperation extension_operations = 11 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public java.util.List<com.google.cloud.aiplatform.v1beta1.ExtensionOperation>
        getExtensionOperationsList() {
      if (extensionOperationsBuilder_ == null) {
        return java.util.Collections.unmodifiableList(extensionOperations_);
      } else {
        return extensionOperationsBuilder_.getMessageList();
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. Supported operations.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.aiplatform.v1beta1.ExtensionOperation extension_operations = 11 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public int getExtensionOperationsCount() {
      if (extensionOperationsBuilder_ == null) {
        return extensionOperations_.size();
      } else {
        return extensionOperationsBuilder_.getCount();
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. Supported operations.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.aiplatform.v1beta1.ExtensionOperation extension_operations = 11 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.cloud.aiplatform.v1beta1.ExtensionOperation getExtensionOperations(
        int index) {
      if (extensionOperationsBuilder_ == null) {
        return extensionOperations_.get(index);
      } else {
        return extensionOperationsBuilder_.getMessage(index);
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. Supported operations.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.aiplatform.v1beta1.ExtensionOperation extension_operations = 11 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder setExtensionOperations(
        int index, com.google.cloud.aiplatform.v1beta1.ExtensionOperation value) {
      if (extensionOperationsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureExtensionOperationsIsMutable();
        extensionOperations_.set(index, value);
        onChanged();
      } else {
        extensionOperationsBuilder_.setMessage(index, value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Supported operations.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.aiplatform.v1beta1.ExtensionOperation extension_operations = 11 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder setExtensionOperations(
        int index, com.google.cloud.aiplatform.v1beta1.ExtensionOperation.Builder builderForValue) {
      if (extensionOperationsBuilder_ == null) {
        ensureExtensionOperationsIsMutable();
        extensionOperations_.set(index, builderForValue.build());
        onChanged();
      } else {
        extensionOperationsBuilder_.setMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Supported operations.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.aiplatform.v1beta1.ExtensionOperation extension_operations = 11 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder addExtensionOperations(
        com.google.cloud.aiplatform.v1beta1.ExtensionOperation value) {
      if (extensionOperationsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureExtensionOperationsIsMutable();
        extensionOperations_.add(value);
        onChanged();
      } else {
        extensionOperationsBuilder_.addMessage(value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Supported operations.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.aiplatform.v1beta1.ExtensionOperation extension_operations = 11 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder addExtensionOperations(
        int index, com.google.cloud.aiplatform.v1beta1.ExtensionOperation value) {
      if (extensionOperationsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureExtensionOperationsIsMutable();
        extensionOperations_.add(index, value);
        onChanged();
      } else {
        extensionOperationsBuilder_.addMessage(index, value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Supported operations.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.aiplatform.v1beta1.ExtensionOperation extension_operations = 11 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder addExtensionOperations(
        com.google.cloud.aiplatform.v1beta1.ExtensionOperation.Builder builderForValue) {
      if (extensionOperationsBuilder_ == null) {
        ensureExtensionOperationsIsMutable();
        extensionOperations_.add(builderForValue.build());
        onChanged();
      } else {
        extensionOperationsBuilder_.addMessage(builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Supported operations.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.aiplatform.v1beta1.ExtensionOperation extension_operations = 11 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder addExtensionOperations(
        int index, com.google.cloud.aiplatform.v1beta1.ExtensionOperation.Builder builderForValue) {
      if (extensionOperationsBuilder_ == null) {
        ensureExtensionOperationsIsMutable();
        extensionOperations_.add(index, builderForValue.build());
        onChanged();
      } else {
        extensionOperationsBuilder_.addMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Supported operations.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.aiplatform.v1beta1.ExtensionOperation extension_operations = 11 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder addAllExtensionOperations(
        java.lang.Iterable<? extends com.google.cloud.aiplatform.v1beta1.ExtensionOperation>
            values) {
      if (extensionOperationsBuilder_ == null) {
        ensureExtensionOperationsIsMutable();
        com.google.protobuf.AbstractMessageLite.Builder.addAll(values, extensionOperations_);
        onChanged();
      } else {
        extensionOperationsBuilder_.addAllMessages(values);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Supported operations.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.aiplatform.v1beta1.ExtensionOperation extension_operations = 11 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder clearExtensionOperations() {
      if (extensionOperationsBuilder_ == null) {
        extensionOperations_ = java.util.Collections.emptyList();
        bitField0_ = (bitField0_ & ~0x00000080);
        onChanged();
      } else {
        extensionOperationsBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Supported operations.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.aiplatform.v1beta1.ExtensionOperation extension_operations = 11 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder removeExtensionOperations(int index) {
      if (extensionOperationsBuilder_ == null) {
        ensureExtensionOperationsIsMutable();
        extensionOperations_.remove(index);
        onChanged();
      } else {
        extensionOperationsBuilder_.remove(index);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Supported operations.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.aiplatform.v1beta1.ExtensionOperation extension_operations = 11 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.cloud.aiplatform.v1beta1.ExtensionOperation.Builder
        getExtensionOperationsBuilder(int index) {
      return getExtensionOperationsFieldBuilder().getBuilder(index);
    }
    /**
     *
     *
     * <pre>
     * Output only. Supported operations.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.aiplatform.v1beta1.ExtensionOperation extension_operations = 11 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.cloud.aiplatform.v1beta1.ExtensionOperationOrBuilder
        getExtensionOperationsOrBuilder(int index) {
      if (extensionOperationsBuilder_ == null) {
        return extensionOperations_.get(index);
      } else {
        return extensionOperationsBuilder_.getMessageOrBuilder(index);
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. Supported operations.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.aiplatform.v1beta1.ExtensionOperation extension_operations = 11 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public java.util.List<? extends com.google.cloud.aiplatform.v1beta1.ExtensionOperationOrBuilder>
        getExtensionOperationsOrBuilderList() {
      if (extensionOperationsBuilder_ != null) {
        return extensionOperationsBuilder_.getMessageOrBuilderList();
      } else {
        return java.util.Collections.unmodifiableList(extensionOperations_);
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. Supported operations.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.aiplatform.v1beta1.ExtensionOperation extension_operations = 11 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.cloud.aiplatform.v1beta1.ExtensionOperation.Builder
        addExtensionOperationsBuilder() {
      return getExtensionOperationsFieldBuilder()
          .addBuilder(com.google.cloud.aiplatform.v1beta1.ExtensionOperation.getDefaultInstance());
    }
    /**
     *
     *
     * <pre>
     * Output only. Supported operations.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.aiplatform.v1beta1.ExtensionOperation extension_operations = 11 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.cloud.aiplatform.v1beta1.ExtensionOperation.Builder
        addExtensionOperationsBuilder(int index) {
      return getExtensionOperationsFieldBuilder()
          .addBuilder(
              index, com.google.cloud.aiplatform.v1beta1.ExtensionOperation.getDefaultInstance());
    }
    /**
     *
     *
     * <pre>
     * Output only. Supported operations.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.aiplatform.v1beta1.ExtensionOperation extension_operations = 11 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public java.util.List<com.google.cloud.aiplatform.v1beta1.ExtensionOperation.Builder>
        getExtensionOperationsBuilderList() {
      return getExtensionOperationsFieldBuilder().getBuilderList();
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.cloud.aiplatform.v1beta1.ExtensionOperation,
            com.google.cloud.aiplatform.v1beta1.ExtensionOperation.Builder,
            com.google.cloud.aiplatform.v1beta1.ExtensionOperationOrBuilder>
        getExtensionOperationsFieldBuilder() {
      if (extensionOperationsBuilder_ == null) {
        extensionOperationsBuilder_ =
            new com.google.protobuf.RepeatedFieldBuilderV3<
                com.google.cloud.aiplatform.v1beta1.ExtensionOperation,
                com.google.cloud.aiplatform.v1beta1.ExtensionOperation.Builder,
                com.google.cloud.aiplatform.v1beta1.ExtensionOperationOrBuilder>(
                extensionOperations_,
                ((bitField0_ & 0x00000080) != 0),
                getParentForChildren(),
                isClean());
        extensionOperations_ = null;
      }
      return extensionOperationsBuilder_;
    }

    private com.google.cloud.aiplatform.v1beta1.RuntimeConfig runtimeConfig_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.aiplatform.v1beta1.RuntimeConfig,
            com.google.cloud.aiplatform.v1beta1.RuntimeConfig.Builder,
            com.google.cloud.aiplatform.v1beta1.RuntimeConfigOrBuilder>
        runtimeConfigBuilder_;
    /**
     *
     *
     * <pre>
     * Optional. Runtime config controlling the runtime behavior of this
     * Extension.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.RuntimeConfig runtime_config = 13 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return Whether the runtimeConfig field is set.
     */
    public boolean hasRuntimeConfig() {
      return ((bitField0_ & 0x00000100) != 0);
    }
    /**
     *
     *
     * <pre>
     * Optional. Runtime config controlling the runtime behavior of this
     * Extension.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.RuntimeConfig runtime_config = 13 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return The runtimeConfig.
     */
    public com.google.cloud.aiplatform.v1beta1.RuntimeConfig getRuntimeConfig() {
      if (runtimeConfigBuilder_ == null) {
        return runtimeConfig_ == null
            ? com.google.cloud.aiplatform.v1beta1.RuntimeConfig.getDefaultInstance()
            : runtimeConfig_;
      } else {
        return runtimeConfigBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Optional. Runtime config controlling the runtime behavior of this
     * Extension.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.RuntimeConfig runtime_config = 13 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder setRuntimeConfig(com.google.cloud.aiplatform.v1beta1.RuntimeConfig value) {
      if (runtimeConfigBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        runtimeConfig_ = value;
      } else {
        runtimeConfigBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000100;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. Runtime config controlling the runtime behavior of this
     * Extension.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.RuntimeConfig runtime_config = 13 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder setRuntimeConfig(
        com.google.cloud.aiplatform.v1beta1.RuntimeConfig.Builder builderForValue) {
      if (runtimeConfigBuilder_ == null) {
        runtimeConfig_ = builderForValue.build();
      } else {
        runtimeConfigBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000100;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. Runtime config controlling the runtime behavior of this
     * Extension.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.RuntimeConfig runtime_config = 13 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder mergeRuntimeConfig(com.google.cloud.aiplatform.v1beta1.RuntimeConfig value) {
      if (runtimeConfigBuilder_ == null) {
        if (((bitField0_ & 0x00000100) != 0)
            && runtimeConfig_ != null
            && runtimeConfig_
                != com.google.cloud.aiplatform.v1beta1.RuntimeConfig.getDefaultInstance()) {
          getRuntimeConfigBuilder().mergeFrom(value);
        } else {
          runtimeConfig_ = value;
        }
      } else {
        runtimeConfigBuilder_.mergeFrom(value);
      }
      if (runtimeConfig_ != null) {
        bitField0_ |= 0x00000100;
        onChanged();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. Runtime config controlling the runtime behavior of this
     * Extension.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.RuntimeConfig runtime_config = 13 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder clearRuntimeConfig() {
      bitField0_ = (bitField0_ & ~0x00000100);
      runtimeConfig_ = null;
      if (runtimeConfigBuilder_ != null) {
        runtimeConfigBuilder_.dispose();
        runtimeConfigBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. Runtime config controlling the runtime behavior of this
     * Extension.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.RuntimeConfig runtime_config = 13 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public com.google.cloud.aiplatform.v1beta1.RuntimeConfig.Builder getRuntimeConfigBuilder() {
      bitField0_ |= 0x00000100;
      onChanged();
      return getRuntimeConfigFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Optional. Runtime config controlling the runtime behavior of this
     * Extension.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.RuntimeConfig runtime_config = 13 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public com.google.cloud.aiplatform.v1beta1.RuntimeConfigOrBuilder getRuntimeConfigOrBuilder() {
      if (runtimeConfigBuilder_ != null) {
        return runtimeConfigBuilder_.getMessageOrBuilder();
      } else {
        return runtimeConfig_ == null
            ? com.google.cloud.aiplatform.v1beta1.RuntimeConfig.getDefaultInstance()
            : runtimeConfig_;
      }
    }
    /**
     *
     *
     * <pre>
     * Optional. Runtime config controlling the runtime behavior of this
     * Extension.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.RuntimeConfig runtime_config = 13 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.aiplatform.v1beta1.RuntimeConfig,
            com.google.cloud.aiplatform.v1beta1.RuntimeConfig.Builder,
            com.google.cloud.aiplatform.v1beta1.RuntimeConfigOrBuilder>
        getRuntimeConfigFieldBuilder() {
      if (runtimeConfigBuilder_ == null) {
        runtimeConfigBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.aiplatform.v1beta1.RuntimeConfig,
                com.google.cloud.aiplatform.v1beta1.RuntimeConfig.Builder,
                com.google.cloud.aiplatform.v1beta1.RuntimeConfigOrBuilder>(
                getRuntimeConfig(), getParentForChildren(), isClean());
        runtimeConfig_ = null;
      }
      return runtimeConfigBuilder_;
    }

    private java.util.List<com.google.cloud.aiplatform.v1beta1.ToolUseExample> toolUseExamples_ =
        java.util.Collections.emptyList();

    private void ensureToolUseExamplesIsMutable() {
      if (!((bitField0_ & 0x00000200) != 0)) {
        toolUseExamples_ =
            new java.util.ArrayList<com.google.cloud.aiplatform.v1beta1.ToolUseExample>(
                toolUseExamples_);
        bitField0_ |= 0x00000200;
      }
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.cloud.aiplatform.v1beta1.ToolUseExample,
            com.google.cloud.aiplatform.v1beta1.ToolUseExample.Builder,
            com.google.cloud.aiplatform.v1beta1.ToolUseExampleOrBuilder>
        toolUseExamplesBuilder_;

    /**
     *
     *
     * <pre>
     * Optional. Examples to illustrate the usage of the extension as a tool.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.aiplatform.v1beta1.ToolUseExample tool_use_examples = 15 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public java.util.List<com.google.cloud.aiplatform.v1beta1.ToolUseExample>
        getToolUseExamplesList() {
      if (toolUseExamplesBuilder_ == null) {
        return java.util.Collections.unmodifiableList(toolUseExamples_);
      } else {
        return toolUseExamplesBuilder_.getMessageList();
      }
    }
    /**
     *
     *
     * <pre>
     * Optional. Examples to illustrate the usage of the extension as a tool.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.aiplatform.v1beta1.ToolUseExample tool_use_examples = 15 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public int getToolUseExamplesCount() {
      if (toolUseExamplesBuilder_ == null) {
        return toolUseExamples_.size();
      } else {
        return toolUseExamplesBuilder_.getCount();
      }
    }
    /**
     *
     *
     * <pre>
     * Optional. Examples to illustrate the usage of the extension as a tool.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.aiplatform.v1beta1.ToolUseExample tool_use_examples = 15 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public com.google.cloud.aiplatform.v1beta1.ToolUseExample getToolUseExamples(int index) {
      if (toolUseExamplesBuilder_ == null) {
        return toolUseExamples_.get(index);
      } else {
        return toolUseExamplesBuilder_.getMessage(index);
      }
    }
    /**
     *
     *
     * <pre>
     * Optional. Examples to illustrate the usage of the extension as a tool.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.aiplatform.v1beta1.ToolUseExample tool_use_examples = 15 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder setToolUseExamples(
        int index, com.google.cloud.aiplatform.v1beta1.ToolUseExample value) {
      if (toolUseExamplesBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureToolUseExamplesIsMutable();
        toolUseExamples_.set(index, value);
        onChanged();
      } else {
        toolUseExamplesBuilder_.setMessage(index, value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. Examples to illustrate the usage of the extension as a tool.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.aiplatform.v1beta1.ToolUseExample tool_use_examples = 15 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder setToolUseExamples(
        int index, com.google.cloud.aiplatform.v1beta1.ToolUseExample.Builder builderForValue) {
      if (toolUseExamplesBuilder_ == null) {
        ensureToolUseExamplesIsMutable();
        toolUseExamples_.set(index, builderForValue.build());
        onChanged();
      } else {
        toolUseExamplesBuilder_.setMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. Examples to illustrate the usage of the extension as a tool.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.aiplatform.v1beta1.ToolUseExample tool_use_examples = 15 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder addToolUseExamples(com.google.cloud.aiplatform.v1beta1.ToolUseExample value) {
      if (toolUseExamplesBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureToolUseExamplesIsMutable();
        toolUseExamples_.add(value);
        onChanged();
      } else {
        toolUseExamplesBuilder_.addMessage(value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. Examples to illustrate the usage of the extension as a tool.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.aiplatform.v1beta1.ToolUseExample tool_use_examples = 15 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder addToolUseExamples(
        int index, com.google.cloud.aiplatform.v1beta1.ToolUseExample value) {
      if (toolUseExamplesBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureToolUseExamplesIsMutable();
        toolUseExamples_.add(index, value);
        onChanged();
      } else {
        toolUseExamplesBuilder_.addMessage(index, value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. Examples to illustrate the usage of the extension as a tool.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.aiplatform.v1beta1.ToolUseExample tool_use_examples = 15 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder addToolUseExamples(
        com.google.cloud.aiplatform.v1beta1.ToolUseExample.Builder builderForValue) {
      if (toolUseExamplesBuilder_ == null) {
        ensureToolUseExamplesIsMutable();
        toolUseExamples_.add(builderForValue.build());
        onChanged();
      } else {
        toolUseExamplesBuilder_.addMessage(builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. Examples to illustrate the usage of the extension as a tool.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.aiplatform.v1beta1.ToolUseExample tool_use_examples = 15 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder addToolUseExamples(
        int index, com.google.cloud.aiplatform.v1beta1.ToolUseExample.Builder builderForValue) {
      if (toolUseExamplesBuilder_ == null) {
        ensureToolUseExamplesIsMutable();
        toolUseExamples_.add(index, builderForValue.build());
        onChanged();
      } else {
        toolUseExamplesBuilder_.addMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. Examples to illustrate the usage of the extension as a tool.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.aiplatform.v1beta1.ToolUseExample tool_use_examples = 15 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder addAllToolUseExamples(
        java.lang.Iterable<? extends com.google.cloud.aiplatform.v1beta1.ToolUseExample> values) {
      if (toolUseExamplesBuilder_ == null) {
        ensureToolUseExamplesIsMutable();
        com.google.protobuf.AbstractMessageLite.Builder.addAll(values, toolUseExamples_);
        onChanged();
      } else {
        toolUseExamplesBuilder_.addAllMessages(values);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. Examples to illustrate the usage of the extension as a tool.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.aiplatform.v1beta1.ToolUseExample tool_use_examples = 15 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder clearToolUseExamples() {
      if (toolUseExamplesBuilder_ == null) {
        toolUseExamples_ = java.util.Collections.emptyList();
        bitField0_ = (bitField0_ & ~0x00000200);
        onChanged();
      } else {
        toolUseExamplesBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. Examples to illustrate the usage of the extension as a tool.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.aiplatform.v1beta1.ToolUseExample tool_use_examples = 15 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder removeToolUseExamples(int index) {
      if (toolUseExamplesBuilder_ == null) {
        ensureToolUseExamplesIsMutable();
        toolUseExamples_.remove(index);
        onChanged();
      } else {
        toolUseExamplesBuilder_.remove(index);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. Examples to illustrate the usage of the extension as a tool.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.aiplatform.v1beta1.ToolUseExample tool_use_examples = 15 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public com.google.cloud.aiplatform.v1beta1.ToolUseExample.Builder getToolUseExamplesBuilder(
        int index) {
      return getToolUseExamplesFieldBuilder().getBuilder(index);
    }
    /**
     *
     *
     * <pre>
     * Optional. Examples to illustrate the usage of the extension as a tool.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.aiplatform.v1beta1.ToolUseExample tool_use_examples = 15 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public com.google.cloud.aiplatform.v1beta1.ToolUseExampleOrBuilder getToolUseExamplesOrBuilder(
        int index) {
      if (toolUseExamplesBuilder_ == null) {
        return toolUseExamples_.get(index);
      } else {
        return toolUseExamplesBuilder_.getMessageOrBuilder(index);
      }
    }
    /**
     *
     *
     * <pre>
     * Optional. Examples to illustrate the usage of the extension as a tool.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.aiplatform.v1beta1.ToolUseExample tool_use_examples = 15 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public java.util.List<? extends com.google.cloud.aiplatform.v1beta1.ToolUseExampleOrBuilder>
        getToolUseExamplesOrBuilderList() {
      if (toolUseExamplesBuilder_ != null) {
        return toolUseExamplesBuilder_.getMessageOrBuilderList();
      } else {
        return java.util.Collections.unmodifiableList(toolUseExamples_);
      }
    }
    /**
     *
     *
     * <pre>
     * Optional. Examples to illustrate the usage of the extension as a tool.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.aiplatform.v1beta1.ToolUseExample tool_use_examples = 15 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public com.google.cloud.aiplatform.v1beta1.ToolUseExample.Builder addToolUseExamplesBuilder() {
      return getToolUseExamplesFieldBuilder()
          .addBuilder(com.google.cloud.aiplatform.v1beta1.ToolUseExample.getDefaultInstance());
    }
    /**
     *
     *
     * <pre>
     * Optional. Examples to illustrate the usage of the extension as a tool.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.aiplatform.v1beta1.ToolUseExample tool_use_examples = 15 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public com.google.cloud.aiplatform.v1beta1.ToolUseExample.Builder addToolUseExamplesBuilder(
        int index) {
      return getToolUseExamplesFieldBuilder()
          .addBuilder(
              index, com.google.cloud.aiplatform.v1beta1.ToolUseExample.getDefaultInstance());
    }
    /**
     *
     *
     * <pre>
     * Optional. Examples to illustrate the usage of the extension as a tool.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.aiplatform.v1beta1.ToolUseExample tool_use_examples = 15 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public java.util.List<com.google.cloud.aiplatform.v1beta1.ToolUseExample.Builder>
        getToolUseExamplesBuilderList() {
      return getToolUseExamplesFieldBuilder().getBuilderList();
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.cloud.aiplatform.v1beta1.ToolUseExample,
            com.google.cloud.aiplatform.v1beta1.ToolUseExample.Builder,
            com.google.cloud.aiplatform.v1beta1.ToolUseExampleOrBuilder>
        getToolUseExamplesFieldBuilder() {
      if (toolUseExamplesBuilder_ == null) {
        toolUseExamplesBuilder_ =
            new com.google.protobuf.RepeatedFieldBuilderV3<
                com.google.cloud.aiplatform.v1beta1.ToolUseExample,
                com.google.cloud.aiplatform.v1beta1.ToolUseExample.Builder,
                com.google.cloud.aiplatform.v1beta1.ToolUseExampleOrBuilder>(
                toolUseExamples_,
                ((bitField0_ & 0x00000200) != 0),
                getParentForChildren(),
                isClean());
        toolUseExamples_ = null;
      }
      return toolUseExamplesBuilder_;
    }

    private com.google.cloud.aiplatform.v1beta1.ExtensionPrivateServiceConnectConfig
        privateServiceConnectConfig_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.aiplatform.v1beta1.ExtensionPrivateServiceConnectConfig,
            com.google.cloud.aiplatform.v1beta1.ExtensionPrivateServiceConnectConfig.Builder,
            com.google.cloud.aiplatform.v1beta1.ExtensionPrivateServiceConnectConfigOrBuilder>
        privateServiceConnectConfigBuilder_;
    /**
     *
     *
     * <pre>
     * Optional. The PrivateServiceConnect config for the extension.
     * If specified, the service endpoints associated with the
     * Extension should be registered with private network access in the provided
     * Service Directory
     * (https://cloud.google.com/service-directory/docs/configuring-private-network-access).
     *
     * If the service contains more than one endpoint with a network, the service
     * will arbitrarilty choose one of the endpoints to use for extension
     * execution.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.ExtensionPrivateServiceConnectConfig private_service_connect_config = 16 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return Whether the privateServiceConnectConfig field is set.
     */
    public boolean hasPrivateServiceConnectConfig() {
      return ((bitField0_ & 0x00000400) != 0);
    }
    /**
     *
     *
     * <pre>
     * Optional. The PrivateServiceConnect config for the extension.
     * If specified, the service endpoints associated with the
     * Extension should be registered with private network access in the provided
     * Service Directory
     * (https://cloud.google.com/service-directory/docs/configuring-private-network-access).
     *
     * If the service contains more than one endpoint with a network, the service
     * will arbitrarilty choose one of the endpoints to use for extension
     * execution.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.ExtensionPrivateServiceConnectConfig private_service_connect_config = 16 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return The privateServiceConnectConfig.
     */
    public com.google.cloud.aiplatform.v1beta1.ExtensionPrivateServiceConnectConfig
        getPrivateServiceConnectConfig() {
      if (privateServiceConnectConfigBuilder_ == null) {
        return privateServiceConnectConfig_ == null
            ? com.google.cloud.aiplatform.v1beta1.ExtensionPrivateServiceConnectConfig
                .getDefaultInstance()
            : privateServiceConnectConfig_;
      } else {
        return privateServiceConnectConfigBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Optional. The PrivateServiceConnect config for the extension.
     * If specified, the service endpoints associated with the
     * Extension should be registered with private network access in the provided
     * Service Directory
     * (https://cloud.google.com/service-directory/docs/configuring-private-network-access).
     *
     * If the service contains more than one endpoint with a network, the service
     * will arbitrarilty choose one of the endpoints to use for extension
     * execution.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.ExtensionPrivateServiceConnectConfig private_service_connect_config = 16 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder setPrivateServiceConnectConfig(
        com.google.cloud.aiplatform.v1beta1.ExtensionPrivateServiceConnectConfig value) {
      if (privateServiceConnectConfigBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        privateServiceConnectConfig_ = value;
      } else {
        privateServiceConnectConfigBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000400;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. The PrivateServiceConnect config for the extension.
     * If specified, the service endpoints associated with the
     * Extension should be registered with private network access in the provided
     * Service Directory
     * (https://cloud.google.com/service-directory/docs/configuring-private-network-access).
     *
     * If the service contains more than one endpoint with a network, the service
     * will arbitrarilty choose one of the endpoints to use for extension
     * execution.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.ExtensionPrivateServiceConnectConfig private_service_connect_config = 16 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder setPrivateServiceConnectConfig(
        com.google.cloud.aiplatform.v1beta1.ExtensionPrivateServiceConnectConfig.Builder
            builderForValue) {
      if (privateServiceConnectConfigBuilder_ == null) {
        privateServiceConnectConfig_ = builderForValue.build();
      } else {
        privateServiceConnectConfigBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000400;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. The PrivateServiceConnect config for the extension.
     * If specified, the service endpoints associated with the
     * Extension should be registered with private network access in the provided
     * Service Directory
     * (https://cloud.google.com/service-directory/docs/configuring-private-network-access).
     *
     * If the service contains more than one endpoint with a network, the service
     * will arbitrarilty choose one of the endpoints to use for extension
     * execution.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.ExtensionPrivateServiceConnectConfig private_service_connect_config = 16 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder mergePrivateServiceConnectConfig(
        com.google.cloud.aiplatform.v1beta1.ExtensionPrivateServiceConnectConfig value) {
      if (privateServiceConnectConfigBuilder_ == null) {
        if (((bitField0_ & 0x00000400) != 0)
            && privateServiceConnectConfig_ != null
            && privateServiceConnectConfig_
                != com.google.cloud.aiplatform.v1beta1.ExtensionPrivateServiceConnectConfig
                    .getDefaultInstance()) {
          getPrivateServiceConnectConfigBuilder().mergeFrom(value);
        } else {
          privateServiceConnectConfig_ = value;
        }
      } else {
        privateServiceConnectConfigBuilder_.mergeFrom(value);
      }
      if (privateServiceConnectConfig_ != null) {
        bitField0_ |= 0x00000400;
        onChanged();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. The PrivateServiceConnect config for the extension.
     * If specified, the service endpoints associated with the
     * Extension should be registered with private network access in the provided
     * Service Directory
     * (https://cloud.google.com/service-directory/docs/configuring-private-network-access).
     *
     * If the service contains more than one endpoint with a network, the service
     * will arbitrarilty choose one of the endpoints to use for extension
     * execution.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.ExtensionPrivateServiceConnectConfig private_service_connect_config = 16 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder clearPrivateServiceConnectConfig() {
      bitField0_ = (bitField0_ & ~0x00000400);
      privateServiceConnectConfig_ = null;
      if (privateServiceConnectConfigBuilder_ != null) {
        privateServiceConnectConfigBuilder_.dispose();
        privateServiceConnectConfigBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. The PrivateServiceConnect config for the extension.
     * If specified, the service endpoints associated with the
     * Extension should be registered with private network access in the provided
     * Service Directory
     * (https://cloud.google.com/service-directory/docs/configuring-private-network-access).
     *
     * If the service contains more than one endpoint with a network, the service
     * will arbitrarilty choose one of the endpoints to use for extension
     * execution.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.ExtensionPrivateServiceConnectConfig private_service_connect_config = 16 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public com.google.cloud.aiplatform.v1beta1.ExtensionPrivateServiceConnectConfig.Builder
        getPrivateServiceConnectConfigBuilder() {
      bitField0_ |= 0x00000400;
      onChanged();
      return getPrivateServiceConnectConfigFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Optional. The PrivateServiceConnect config for the extension.
     * If specified, the service endpoints associated with the
     * Extension should be registered with private network access in the provided
     * Service Directory
     * (https://cloud.google.com/service-directory/docs/configuring-private-network-access).
     *
     * If the service contains more than one endpoint with a network, the service
     * will arbitrarilty choose one of the endpoints to use for extension
     * execution.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.ExtensionPrivateServiceConnectConfig private_service_connect_config = 16 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public com.google.cloud.aiplatform.v1beta1.ExtensionPrivateServiceConnectConfigOrBuilder
        getPrivateServiceConnectConfigOrBuilder() {
      if (privateServiceConnectConfigBuilder_ != null) {
        return privateServiceConnectConfigBuilder_.getMessageOrBuilder();
      } else {
        return privateServiceConnectConfig_ == null
            ? com.google.cloud.aiplatform.v1beta1.ExtensionPrivateServiceConnectConfig
                .getDefaultInstance()
            : privateServiceConnectConfig_;
      }
    }
    /**
     *
     *
     * <pre>
     * Optional. The PrivateServiceConnect config for the extension.
     * If specified, the service endpoints associated with the
     * Extension should be registered with private network access in the provided
     * Service Directory
     * (https://cloud.google.com/service-directory/docs/configuring-private-network-access).
     *
     * If the service contains more than one endpoint with a network, the service
     * will arbitrarilty choose one of the endpoints to use for extension
     * execution.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.ExtensionPrivateServiceConnectConfig private_service_connect_config = 16 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.aiplatform.v1beta1.ExtensionPrivateServiceConnectConfig,
            com.google.cloud.aiplatform.v1beta1.ExtensionPrivateServiceConnectConfig.Builder,
            com.google.cloud.aiplatform.v1beta1.ExtensionPrivateServiceConnectConfigOrBuilder>
        getPrivateServiceConnectConfigFieldBuilder() {
      if (privateServiceConnectConfigBuilder_ == null) {
        privateServiceConnectConfigBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.aiplatform.v1beta1.ExtensionPrivateServiceConnectConfig,
                com.google.cloud.aiplatform.v1beta1.ExtensionPrivateServiceConnectConfig.Builder,
                com.google.cloud.aiplatform.v1beta1.ExtensionPrivateServiceConnectConfigOrBuilder>(
                getPrivateServiceConnectConfig(), getParentForChildren(), isClean());
        privateServiceConnectConfig_ = null;
      }
      return privateServiceConnectConfigBuilder_;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.cloud.aiplatform.v1beta1.Extension)
  }

  // @@protoc_insertion_point(class_scope:google.cloud.aiplatform.v1beta1.Extension)
  private static final com.google.cloud.aiplatform.v1beta1.Extension DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.cloud.aiplatform.v1beta1.Extension();
  }

  public static com.google.cloud.aiplatform.v1beta1.Extension getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<Extension> PARSER =
      new com.google.protobuf.AbstractParser<Extension>() {
        @java.lang.Override
        public Extension parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          Builder builder = newBuilder();
          try {
            builder.mergeFrom(input, extensionRegistry);
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.setUnfinishedMessage(builder.buildPartial());
          } catch (com.google.protobuf.UninitializedMessageException e) {
            throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
          } catch (java.io.IOException e) {
            throw new com.google.protobuf.InvalidProtocolBufferException(e)
                .setUnfinishedMessage(builder.buildPartial());
          }
          return builder.buildPartial();
        }
      };

  public static com.google.protobuf.Parser<Extension> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<Extension> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.cloud.aiplatform.v1beta1.Extension getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
