/*
 * Copyright 2024 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/cloud/aiplatform/v1beta1/content.proto

// Protobuf Java Version: 3.25.5
package com.google.cloud.aiplatform.v1beta1;

/**
 *
 *
 * <pre>
 * Metadata returned to client when grounding is enabled.
 * </pre>
 *
 * Protobuf type {@code google.cloud.aiplatform.v1beta1.GroundingMetadata}
 */
public final class GroundingMetadata extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.cloud.aiplatform.v1beta1.GroundingMetadata)
    GroundingMetadataOrBuilder {
  private static final long serialVersionUID = 0L;
  // Use GroundingMetadata.newBuilder() to construct.
  private GroundingMetadata(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private GroundingMetadata() {
    webSearchQueries_ = com.google.protobuf.LazyStringArrayList.emptyList();
    retrievalQueries_ = com.google.protobuf.LazyStringArrayList.emptyList();
    groundingChunks_ = java.util.Collections.emptyList();
    groundingSupports_ = java.util.Collections.emptyList();
  }

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new GroundingMetadata();
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.cloud.aiplatform.v1beta1.ContentProto
        .internal_static_google_cloud_aiplatform_v1beta1_GroundingMetadata_descriptor;
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.cloud.aiplatform.v1beta1.ContentProto
        .internal_static_google_cloud_aiplatform_v1beta1_GroundingMetadata_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.cloud.aiplatform.v1beta1.GroundingMetadata.class,
            com.google.cloud.aiplatform.v1beta1.GroundingMetadata.Builder.class);
  }

  private int bitField0_;
  public static final int WEB_SEARCH_QUERIES_FIELD_NUMBER = 1;

  @SuppressWarnings("serial")
  private com.google.protobuf.LazyStringArrayList webSearchQueries_ =
      com.google.protobuf.LazyStringArrayList.emptyList();
  /**
   *
   *
   * <pre>
   * Optional. Web search queries for the following-up web search.
   * </pre>
   *
   * <code>repeated string web_search_queries = 1 [(.google.api.field_behavior) = OPTIONAL];</code>
   *
   * @return A list containing the webSearchQueries.
   */
  public com.google.protobuf.ProtocolStringList getWebSearchQueriesList() {
    return webSearchQueries_;
  }
  /**
   *
   *
   * <pre>
   * Optional. Web search queries for the following-up web search.
   * </pre>
   *
   * <code>repeated string web_search_queries = 1 [(.google.api.field_behavior) = OPTIONAL];</code>
   *
   * @return The count of webSearchQueries.
   */
  public int getWebSearchQueriesCount() {
    return webSearchQueries_.size();
  }
  /**
   *
   *
   * <pre>
   * Optional. Web search queries for the following-up web search.
   * </pre>
   *
   * <code>repeated string web_search_queries = 1 [(.google.api.field_behavior) = OPTIONAL];</code>
   *
   * @param index The index of the element to return.
   * @return The webSearchQueries at the given index.
   */
  public java.lang.String getWebSearchQueries(int index) {
    return webSearchQueries_.get(index);
  }
  /**
   *
   *
   * <pre>
   * Optional. Web search queries for the following-up web search.
   * </pre>
   *
   * <code>repeated string web_search_queries = 1 [(.google.api.field_behavior) = OPTIONAL];</code>
   *
   * @param index The index of the value to return.
   * @return The bytes of the webSearchQueries at the given index.
   */
  public com.google.protobuf.ByteString getWebSearchQueriesBytes(int index) {
    return webSearchQueries_.getByteString(index);
  }

  public static final int SEARCH_ENTRY_POINT_FIELD_NUMBER = 4;
  private com.google.cloud.aiplatform.v1beta1.SearchEntryPoint searchEntryPoint_;
  /**
   *
   *
   * <pre>
   * Optional. Google search entry for the following-up web searches.
   * </pre>
   *
   * <code>
   * optional .google.cloud.aiplatform.v1beta1.SearchEntryPoint search_entry_point = 4 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   *
   * @return Whether the searchEntryPoint field is set.
   */
  @java.lang.Override
  public boolean hasSearchEntryPoint() {
    return ((bitField0_ & 0x00000001) != 0);
  }
  /**
   *
   *
   * <pre>
   * Optional. Google search entry for the following-up web searches.
   * </pre>
   *
   * <code>
   * optional .google.cloud.aiplatform.v1beta1.SearchEntryPoint search_entry_point = 4 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   *
   * @return The searchEntryPoint.
   */
  @java.lang.Override
  public com.google.cloud.aiplatform.v1beta1.SearchEntryPoint getSearchEntryPoint() {
    return searchEntryPoint_ == null
        ? com.google.cloud.aiplatform.v1beta1.SearchEntryPoint.getDefaultInstance()
        : searchEntryPoint_;
  }
  /**
   *
   *
   * <pre>
   * Optional. Google search entry for the following-up web searches.
   * </pre>
   *
   * <code>
   * optional .google.cloud.aiplatform.v1beta1.SearchEntryPoint search_entry_point = 4 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.aiplatform.v1beta1.SearchEntryPointOrBuilder
      getSearchEntryPointOrBuilder() {
    return searchEntryPoint_ == null
        ? com.google.cloud.aiplatform.v1beta1.SearchEntryPoint.getDefaultInstance()
        : searchEntryPoint_;
  }

  public static final int RETRIEVAL_QUERIES_FIELD_NUMBER = 3;

  @SuppressWarnings("serial")
  private com.google.protobuf.LazyStringArrayList retrievalQueries_ =
      com.google.protobuf.LazyStringArrayList.emptyList();
  /**
   *
   *
   * <pre>
   * Optional. Queries executed by the retrieval tools.
   * </pre>
   *
   * <code>repeated string retrieval_queries = 3 [(.google.api.field_behavior) = OPTIONAL];</code>
   *
   * @return A list containing the retrievalQueries.
   */
  public com.google.protobuf.ProtocolStringList getRetrievalQueriesList() {
    return retrievalQueries_;
  }
  /**
   *
   *
   * <pre>
   * Optional. Queries executed by the retrieval tools.
   * </pre>
   *
   * <code>repeated string retrieval_queries = 3 [(.google.api.field_behavior) = OPTIONAL];</code>
   *
   * @return The count of retrievalQueries.
   */
  public int getRetrievalQueriesCount() {
    return retrievalQueries_.size();
  }
  /**
   *
   *
   * <pre>
   * Optional. Queries executed by the retrieval tools.
   * </pre>
   *
   * <code>repeated string retrieval_queries = 3 [(.google.api.field_behavior) = OPTIONAL];</code>
   *
   * @param index The index of the element to return.
   * @return The retrievalQueries at the given index.
   */
  public java.lang.String getRetrievalQueries(int index) {
    return retrievalQueries_.get(index);
  }
  /**
   *
   *
   * <pre>
   * Optional. Queries executed by the retrieval tools.
   * </pre>
   *
   * <code>repeated string retrieval_queries = 3 [(.google.api.field_behavior) = OPTIONAL];</code>
   *
   * @param index The index of the value to return.
   * @return The bytes of the retrievalQueries at the given index.
   */
  public com.google.protobuf.ByteString getRetrievalQueriesBytes(int index) {
    return retrievalQueries_.getByteString(index);
  }

  public static final int GROUNDING_CHUNKS_FIELD_NUMBER = 5;

  @SuppressWarnings("serial")
  private java.util.List<com.google.cloud.aiplatform.v1beta1.GroundingChunk> groundingChunks_;
  /**
   *
   *
   * <pre>
   * List of supporting references retrieved from specified grounding source.
   * </pre>
   *
   * <code>repeated .google.cloud.aiplatform.v1beta1.GroundingChunk grounding_chunks = 5;</code>
   */
  @java.lang.Override
  public java.util.List<com.google.cloud.aiplatform.v1beta1.GroundingChunk>
      getGroundingChunksList() {
    return groundingChunks_;
  }
  /**
   *
   *
   * <pre>
   * List of supporting references retrieved from specified grounding source.
   * </pre>
   *
   * <code>repeated .google.cloud.aiplatform.v1beta1.GroundingChunk grounding_chunks = 5;</code>
   */
  @java.lang.Override
  public java.util.List<? extends com.google.cloud.aiplatform.v1beta1.GroundingChunkOrBuilder>
      getGroundingChunksOrBuilderList() {
    return groundingChunks_;
  }
  /**
   *
   *
   * <pre>
   * List of supporting references retrieved from specified grounding source.
   * </pre>
   *
   * <code>repeated .google.cloud.aiplatform.v1beta1.GroundingChunk grounding_chunks = 5;</code>
   */
  @java.lang.Override
  public int getGroundingChunksCount() {
    return groundingChunks_.size();
  }
  /**
   *
   *
   * <pre>
   * List of supporting references retrieved from specified grounding source.
   * </pre>
   *
   * <code>repeated .google.cloud.aiplatform.v1beta1.GroundingChunk grounding_chunks = 5;</code>
   */
  @java.lang.Override
  public com.google.cloud.aiplatform.v1beta1.GroundingChunk getGroundingChunks(int index) {
    return groundingChunks_.get(index);
  }
  /**
   *
   *
   * <pre>
   * List of supporting references retrieved from specified grounding source.
   * </pre>
   *
   * <code>repeated .google.cloud.aiplatform.v1beta1.GroundingChunk grounding_chunks = 5;</code>
   */
  @java.lang.Override
  public com.google.cloud.aiplatform.v1beta1.GroundingChunkOrBuilder getGroundingChunksOrBuilder(
      int index) {
    return groundingChunks_.get(index);
  }

  public static final int GROUNDING_SUPPORTS_FIELD_NUMBER = 6;

  @SuppressWarnings("serial")
  private java.util.List<com.google.cloud.aiplatform.v1beta1.GroundingSupport> groundingSupports_;
  /**
   *
   *
   * <pre>
   * Optional. List of grounding support.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.aiplatform.v1beta1.GroundingSupport grounding_supports = 6 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   */
  @java.lang.Override
  public java.util.List<com.google.cloud.aiplatform.v1beta1.GroundingSupport>
      getGroundingSupportsList() {
    return groundingSupports_;
  }
  /**
   *
   *
   * <pre>
   * Optional. List of grounding support.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.aiplatform.v1beta1.GroundingSupport grounding_supports = 6 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   */
  @java.lang.Override
  public java.util.List<? extends com.google.cloud.aiplatform.v1beta1.GroundingSupportOrBuilder>
      getGroundingSupportsOrBuilderList() {
    return groundingSupports_;
  }
  /**
   *
   *
   * <pre>
   * Optional. List of grounding support.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.aiplatform.v1beta1.GroundingSupport grounding_supports = 6 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   */
  @java.lang.Override
  public int getGroundingSupportsCount() {
    return groundingSupports_.size();
  }
  /**
   *
   *
   * <pre>
   * Optional. List of grounding support.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.aiplatform.v1beta1.GroundingSupport grounding_supports = 6 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.aiplatform.v1beta1.GroundingSupport getGroundingSupports(int index) {
    return groundingSupports_.get(index);
  }
  /**
   *
   *
   * <pre>
   * Optional. List of grounding support.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.aiplatform.v1beta1.GroundingSupport grounding_supports = 6 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.aiplatform.v1beta1.GroundingSupportOrBuilder
      getGroundingSupportsOrBuilder(int index) {
    return groundingSupports_.get(index);
  }

  public static final int RETRIEVAL_METADATA_FIELD_NUMBER = 7;
  private com.google.cloud.aiplatform.v1beta1.RetrievalMetadata retrievalMetadata_;
  /**
   *
   *
   * <pre>
   * Optional. Output only. Retrieval metadata.
   * </pre>
   *
   * <code>
   * optional .google.cloud.aiplatform.v1beta1.RetrievalMetadata retrieval_metadata = 7 [(.google.api.field_behavior) = OPTIONAL, (.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return Whether the retrievalMetadata field is set.
   */
  @java.lang.Override
  public boolean hasRetrievalMetadata() {
    return ((bitField0_ & 0x00000002) != 0);
  }
  /**
   *
   *
   * <pre>
   * Optional. Output only. Retrieval metadata.
   * </pre>
   *
   * <code>
   * optional .google.cloud.aiplatform.v1beta1.RetrievalMetadata retrieval_metadata = 7 [(.google.api.field_behavior) = OPTIONAL, (.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return The retrievalMetadata.
   */
  @java.lang.Override
  public com.google.cloud.aiplatform.v1beta1.RetrievalMetadata getRetrievalMetadata() {
    return retrievalMetadata_ == null
        ? com.google.cloud.aiplatform.v1beta1.RetrievalMetadata.getDefaultInstance()
        : retrievalMetadata_;
  }
  /**
   *
   *
   * <pre>
   * Optional. Output only. Retrieval metadata.
   * </pre>
   *
   * <code>
   * optional .google.cloud.aiplatform.v1beta1.RetrievalMetadata retrieval_metadata = 7 [(.google.api.field_behavior) = OPTIONAL, (.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.aiplatform.v1beta1.RetrievalMetadataOrBuilder
      getRetrievalMetadataOrBuilder() {
    return retrievalMetadata_ == null
        ? com.google.cloud.aiplatform.v1beta1.RetrievalMetadata.getDefaultInstance()
        : retrievalMetadata_;
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    for (int i = 0; i < webSearchQueries_.size(); i++) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 1, webSearchQueries_.getRaw(i));
    }
    for (int i = 0; i < retrievalQueries_.size(); i++) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 3, retrievalQueries_.getRaw(i));
    }
    if (((bitField0_ & 0x00000001) != 0)) {
      output.writeMessage(4, getSearchEntryPoint());
    }
    for (int i = 0; i < groundingChunks_.size(); i++) {
      output.writeMessage(5, groundingChunks_.get(i));
    }
    for (int i = 0; i < groundingSupports_.size(); i++) {
      output.writeMessage(6, groundingSupports_.get(i));
    }
    if (((bitField0_ & 0x00000002) != 0)) {
      output.writeMessage(7, getRetrievalMetadata());
    }
    getUnknownFields().writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    {
      int dataSize = 0;
      for (int i = 0; i < webSearchQueries_.size(); i++) {
        dataSize += computeStringSizeNoTag(webSearchQueries_.getRaw(i));
      }
      size += dataSize;
      size += 1 * getWebSearchQueriesList().size();
    }
    {
      int dataSize = 0;
      for (int i = 0; i < retrievalQueries_.size(); i++) {
        dataSize += computeStringSizeNoTag(retrievalQueries_.getRaw(i));
      }
      size += dataSize;
      size += 1 * getRetrievalQueriesList().size();
    }
    if (((bitField0_ & 0x00000001) != 0)) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(4, getSearchEntryPoint());
    }
    for (int i = 0; i < groundingChunks_.size(); i++) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(5, groundingChunks_.get(i));
    }
    for (int i = 0; i < groundingSupports_.size(); i++) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(6, groundingSupports_.get(i));
    }
    if (((bitField0_ & 0x00000002) != 0)) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(7, getRetrievalMetadata());
    }
    size += getUnknownFields().getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.cloud.aiplatform.v1beta1.GroundingMetadata)) {
      return super.equals(obj);
    }
    com.google.cloud.aiplatform.v1beta1.GroundingMetadata other =
        (com.google.cloud.aiplatform.v1beta1.GroundingMetadata) obj;

    if (!getWebSearchQueriesList().equals(other.getWebSearchQueriesList())) return false;
    if (hasSearchEntryPoint() != other.hasSearchEntryPoint()) return false;
    if (hasSearchEntryPoint()) {
      if (!getSearchEntryPoint().equals(other.getSearchEntryPoint())) return false;
    }
    if (!getRetrievalQueriesList().equals(other.getRetrievalQueriesList())) return false;
    if (!getGroundingChunksList().equals(other.getGroundingChunksList())) return false;
    if (!getGroundingSupportsList().equals(other.getGroundingSupportsList())) return false;
    if (hasRetrievalMetadata() != other.hasRetrievalMetadata()) return false;
    if (hasRetrievalMetadata()) {
      if (!getRetrievalMetadata().equals(other.getRetrievalMetadata())) return false;
    }
    if (!getUnknownFields().equals(other.getUnknownFields())) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    if (getWebSearchQueriesCount() > 0) {
      hash = (37 * hash) + WEB_SEARCH_QUERIES_FIELD_NUMBER;
      hash = (53 * hash) + getWebSearchQueriesList().hashCode();
    }
    if (hasSearchEntryPoint()) {
      hash = (37 * hash) + SEARCH_ENTRY_POINT_FIELD_NUMBER;
      hash = (53 * hash) + getSearchEntryPoint().hashCode();
    }
    if (getRetrievalQueriesCount() > 0) {
      hash = (37 * hash) + RETRIEVAL_QUERIES_FIELD_NUMBER;
      hash = (53 * hash) + getRetrievalQueriesList().hashCode();
    }
    if (getGroundingChunksCount() > 0) {
      hash = (37 * hash) + GROUNDING_CHUNKS_FIELD_NUMBER;
      hash = (53 * hash) + getGroundingChunksList().hashCode();
    }
    if (getGroundingSupportsCount() > 0) {
      hash = (37 * hash) + GROUNDING_SUPPORTS_FIELD_NUMBER;
      hash = (53 * hash) + getGroundingSupportsList().hashCode();
    }
    if (hasRetrievalMetadata()) {
      hash = (37 * hash) + RETRIEVAL_METADATA_FIELD_NUMBER;
      hash = (53 * hash) + getRetrievalMetadata().hashCode();
    }
    hash = (29 * hash) + getUnknownFields().hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.cloud.aiplatform.v1beta1.GroundingMetadata parseFrom(
      java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.aiplatform.v1beta1.GroundingMetadata parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.aiplatform.v1beta1.GroundingMetadata parseFrom(
      com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.aiplatform.v1beta1.GroundingMetadata parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.aiplatform.v1beta1.GroundingMetadata parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.aiplatform.v1beta1.GroundingMetadata parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.aiplatform.v1beta1.GroundingMetadata parseFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.aiplatform.v1beta1.GroundingMetadata parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.aiplatform.v1beta1.GroundingMetadata parseDelimitedFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.cloud.aiplatform.v1beta1.GroundingMetadata parseDelimitedFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.aiplatform.v1beta1.GroundingMetadata parseFrom(
      com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.aiplatform.v1beta1.GroundingMetadata parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(
      com.google.cloud.aiplatform.v1beta1.GroundingMetadata prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }
  /**
   *
   *
   * <pre>
   * Metadata returned to client when grounding is enabled.
   * </pre>
   *
   * Protobuf type {@code google.cloud.aiplatform.v1beta1.GroundingMetadata}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.cloud.aiplatform.v1beta1.GroundingMetadata)
      com.google.cloud.aiplatform.v1beta1.GroundingMetadataOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.aiplatform.v1beta1.ContentProto
          .internal_static_google_cloud_aiplatform_v1beta1_GroundingMetadata_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.aiplatform.v1beta1.ContentProto
          .internal_static_google_cloud_aiplatform_v1beta1_GroundingMetadata_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.aiplatform.v1beta1.GroundingMetadata.class,
              com.google.cloud.aiplatform.v1beta1.GroundingMetadata.Builder.class);
    }

    // Construct using com.google.cloud.aiplatform.v1beta1.GroundingMetadata.newBuilder()
    private Builder() {
      maybeForceBuilderInitialization();
    }

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
      maybeForceBuilderInitialization();
    }

    private void maybeForceBuilderInitialization() {
      if (com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders) {
        getSearchEntryPointFieldBuilder();
        getGroundingChunksFieldBuilder();
        getGroundingSupportsFieldBuilder();
        getRetrievalMetadataFieldBuilder();
      }
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      bitField0_ = 0;
      webSearchQueries_ = com.google.protobuf.LazyStringArrayList.emptyList();
      searchEntryPoint_ = null;
      if (searchEntryPointBuilder_ != null) {
        searchEntryPointBuilder_.dispose();
        searchEntryPointBuilder_ = null;
      }
      retrievalQueries_ = com.google.protobuf.LazyStringArrayList.emptyList();
      if (groundingChunksBuilder_ == null) {
        groundingChunks_ = java.util.Collections.emptyList();
      } else {
        groundingChunks_ = null;
        groundingChunksBuilder_.clear();
      }
      bitField0_ = (bitField0_ & ~0x00000008);
      if (groundingSupportsBuilder_ == null) {
        groundingSupports_ = java.util.Collections.emptyList();
      } else {
        groundingSupports_ = null;
        groundingSupportsBuilder_.clear();
      }
      bitField0_ = (bitField0_ & ~0x00000010);
      retrievalMetadata_ = null;
      if (retrievalMetadataBuilder_ != null) {
        retrievalMetadataBuilder_.dispose();
        retrievalMetadataBuilder_ = null;
      }
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.cloud.aiplatform.v1beta1.ContentProto
          .internal_static_google_cloud_aiplatform_v1beta1_GroundingMetadata_descriptor;
    }

    @java.lang.Override
    public com.google.cloud.aiplatform.v1beta1.GroundingMetadata getDefaultInstanceForType() {
      return com.google.cloud.aiplatform.v1beta1.GroundingMetadata.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.cloud.aiplatform.v1beta1.GroundingMetadata build() {
      com.google.cloud.aiplatform.v1beta1.GroundingMetadata result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.cloud.aiplatform.v1beta1.GroundingMetadata buildPartial() {
      com.google.cloud.aiplatform.v1beta1.GroundingMetadata result =
          new com.google.cloud.aiplatform.v1beta1.GroundingMetadata(this);
      buildPartialRepeatedFields(result);
      if (bitField0_ != 0) {
        buildPartial0(result);
      }
      onBuilt();
      return result;
    }

    private void buildPartialRepeatedFields(
        com.google.cloud.aiplatform.v1beta1.GroundingMetadata result) {
      if (groundingChunksBuilder_ == null) {
        if (((bitField0_ & 0x00000008) != 0)) {
          groundingChunks_ = java.util.Collections.unmodifiableList(groundingChunks_);
          bitField0_ = (bitField0_ & ~0x00000008);
        }
        result.groundingChunks_ = groundingChunks_;
      } else {
        result.groundingChunks_ = groundingChunksBuilder_.build();
      }
      if (groundingSupportsBuilder_ == null) {
        if (((bitField0_ & 0x00000010) != 0)) {
          groundingSupports_ = java.util.Collections.unmodifiableList(groundingSupports_);
          bitField0_ = (bitField0_ & ~0x00000010);
        }
        result.groundingSupports_ = groundingSupports_;
      } else {
        result.groundingSupports_ = groundingSupportsBuilder_.build();
      }
    }

    private void buildPartial0(com.google.cloud.aiplatform.v1beta1.GroundingMetadata result) {
      int from_bitField0_ = bitField0_;
      if (((from_bitField0_ & 0x00000001) != 0)) {
        webSearchQueries_.makeImmutable();
        result.webSearchQueries_ = webSearchQueries_;
      }
      int to_bitField0_ = 0;
      if (((from_bitField0_ & 0x00000002) != 0)) {
        result.searchEntryPoint_ =
            searchEntryPointBuilder_ == null ? searchEntryPoint_ : searchEntryPointBuilder_.build();
        to_bitField0_ |= 0x00000001;
      }
      if (((from_bitField0_ & 0x00000004) != 0)) {
        retrievalQueries_.makeImmutable();
        result.retrievalQueries_ = retrievalQueries_;
      }
      if (((from_bitField0_ & 0x00000020) != 0)) {
        result.retrievalMetadata_ =
            retrievalMetadataBuilder_ == null
                ? retrievalMetadata_
                : retrievalMetadataBuilder_.build();
        to_bitField0_ |= 0x00000002;
      }
      result.bitField0_ |= to_bitField0_;
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.cloud.aiplatform.v1beta1.GroundingMetadata) {
        return mergeFrom((com.google.cloud.aiplatform.v1beta1.GroundingMetadata) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(com.google.cloud.aiplatform.v1beta1.GroundingMetadata other) {
      if (other == com.google.cloud.aiplatform.v1beta1.GroundingMetadata.getDefaultInstance())
        return this;
      if (!other.webSearchQueries_.isEmpty()) {
        if (webSearchQueries_.isEmpty()) {
          webSearchQueries_ = other.webSearchQueries_;
          bitField0_ |= 0x00000001;
        } else {
          ensureWebSearchQueriesIsMutable();
          webSearchQueries_.addAll(other.webSearchQueries_);
        }
        onChanged();
      }
      if (other.hasSearchEntryPoint()) {
        mergeSearchEntryPoint(other.getSearchEntryPoint());
      }
      if (!other.retrievalQueries_.isEmpty()) {
        if (retrievalQueries_.isEmpty()) {
          retrievalQueries_ = other.retrievalQueries_;
          bitField0_ |= 0x00000004;
        } else {
          ensureRetrievalQueriesIsMutable();
          retrievalQueries_.addAll(other.retrievalQueries_);
        }
        onChanged();
      }
      if (groundingChunksBuilder_ == null) {
        if (!other.groundingChunks_.isEmpty()) {
          if (groundingChunks_.isEmpty()) {
            groundingChunks_ = other.groundingChunks_;
            bitField0_ = (bitField0_ & ~0x00000008);
          } else {
            ensureGroundingChunksIsMutable();
            groundingChunks_.addAll(other.groundingChunks_);
          }
          onChanged();
        }
      } else {
        if (!other.groundingChunks_.isEmpty()) {
          if (groundingChunksBuilder_.isEmpty()) {
            groundingChunksBuilder_.dispose();
            groundingChunksBuilder_ = null;
            groundingChunks_ = other.groundingChunks_;
            bitField0_ = (bitField0_ & ~0x00000008);
            groundingChunksBuilder_ =
                com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders
                    ? getGroundingChunksFieldBuilder()
                    : null;
          } else {
            groundingChunksBuilder_.addAllMessages(other.groundingChunks_);
          }
        }
      }
      if (groundingSupportsBuilder_ == null) {
        if (!other.groundingSupports_.isEmpty()) {
          if (groundingSupports_.isEmpty()) {
            groundingSupports_ = other.groundingSupports_;
            bitField0_ = (bitField0_ & ~0x00000010);
          } else {
            ensureGroundingSupportsIsMutable();
            groundingSupports_.addAll(other.groundingSupports_);
          }
          onChanged();
        }
      } else {
        if (!other.groundingSupports_.isEmpty()) {
          if (groundingSupportsBuilder_.isEmpty()) {
            groundingSupportsBuilder_.dispose();
            groundingSupportsBuilder_ = null;
            groundingSupports_ = other.groundingSupports_;
            bitField0_ = (bitField0_ & ~0x00000010);
            groundingSupportsBuilder_ =
                com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders
                    ? getGroundingSupportsFieldBuilder()
                    : null;
          } else {
            groundingSupportsBuilder_.addAllMessages(other.groundingSupports_);
          }
        }
      }
      if (other.hasRetrievalMetadata()) {
        mergeRetrievalMetadata(other.getRetrievalMetadata());
      }
      this.mergeUnknownFields(other.getUnknownFields());
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 10:
              {
                java.lang.String s = input.readStringRequireUtf8();
                ensureWebSearchQueriesIsMutable();
                webSearchQueries_.add(s);
                break;
              } // case 10
            case 26:
              {
                java.lang.String s = input.readStringRequireUtf8();
                ensureRetrievalQueriesIsMutable();
                retrievalQueries_.add(s);
                break;
              } // case 26
            case 34:
              {
                input.readMessage(
                    getSearchEntryPointFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000002;
                break;
              } // case 34
            case 42:
              {
                com.google.cloud.aiplatform.v1beta1.GroundingChunk m =
                    input.readMessage(
                        com.google.cloud.aiplatform.v1beta1.GroundingChunk.parser(),
                        extensionRegistry);
                if (groundingChunksBuilder_ == null) {
                  ensureGroundingChunksIsMutable();
                  groundingChunks_.add(m);
                } else {
                  groundingChunksBuilder_.addMessage(m);
                }
                break;
              } // case 42
            case 50:
              {
                com.google.cloud.aiplatform.v1beta1.GroundingSupport m =
                    input.readMessage(
                        com.google.cloud.aiplatform.v1beta1.GroundingSupport.parser(),
                        extensionRegistry);
                if (groundingSupportsBuilder_ == null) {
                  ensureGroundingSupportsIsMutable();
                  groundingSupports_.add(m);
                } else {
                  groundingSupportsBuilder_.addMessage(m);
                }
                break;
              } // case 50
            case 58:
              {
                input.readMessage(
                    getRetrievalMetadataFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000020;
                break;
              } // case 58
            default:
              {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
          } // switch (tag)
        } // while (!done)
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.unwrapIOException();
      } finally {
        onChanged();
      } // finally
      return this;
    }

    private int bitField0_;

    private com.google.protobuf.LazyStringArrayList webSearchQueries_ =
        com.google.protobuf.LazyStringArrayList.emptyList();

    private void ensureWebSearchQueriesIsMutable() {
      if (!webSearchQueries_.isModifiable()) {
        webSearchQueries_ = new com.google.protobuf.LazyStringArrayList(webSearchQueries_);
      }
      bitField0_ |= 0x00000001;
    }
    /**
     *
     *
     * <pre>
     * Optional. Web search queries for the following-up web search.
     * </pre>
     *
     * <code>repeated string web_search_queries = 1 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return A list containing the webSearchQueries.
     */
    public com.google.protobuf.ProtocolStringList getWebSearchQueriesList() {
      webSearchQueries_.makeImmutable();
      return webSearchQueries_;
    }
    /**
     *
     *
     * <pre>
     * Optional. Web search queries for the following-up web search.
     * </pre>
     *
     * <code>repeated string web_search_queries = 1 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return The count of webSearchQueries.
     */
    public int getWebSearchQueriesCount() {
      return webSearchQueries_.size();
    }
    /**
     *
     *
     * <pre>
     * Optional. Web search queries for the following-up web search.
     * </pre>
     *
     * <code>repeated string web_search_queries = 1 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @param index The index of the element to return.
     * @return The webSearchQueries at the given index.
     */
    public java.lang.String getWebSearchQueries(int index) {
      return webSearchQueries_.get(index);
    }
    /**
     *
     *
     * <pre>
     * Optional. Web search queries for the following-up web search.
     * </pre>
     *
     * <code>repeated string web_search_queries = 1 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @param index The index of the value to return.
     * @return The bytes of the webSearchQueries at the given index.
     */
    public com.google.protobuf.ByteString getWebSearchQueriesBytes(int index) {
      return webSearchQueries_.getByteString(index);
    }
    /**
     *
     *
     * <pre>
     * Optional. Web search queries for the following-up web search.
     * </pre>
     *
     * <code>repeated string web_search_queries = 1 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @param index The index to set the value at.
     * @param value The webSearchQueries to set.
     * @return This builder for chaining.
     */
    public Builder setWebSearchQueries(int index, java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      ensureWebSearchQueriesIsMutable();
      webSearchQueries_.set(index, value);
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. Web search queries for the following-up web search.
     * </pre>
     *
     * <code>repeated string web_search_queries = 1 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @param value The webSearchQueries to add.
     * @return This builder for chaining.
     */
    public Builder addWebSearchQueries(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      ensureWebSearchQueriesIsMutable();
      webSearchQueries_.add(value);
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. Web search queries for the following-up web search.
     * </pre>
     *
     * <code>repeated string web_search_queries = 1 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @param values The webSearchQueries to add.
     * @return This builder for chaining.
     */
    public Builder addAllWebSearchQueries(java.lang.Iterable<java.lang.String> values) {
      ensureWebSearchQueriesIsMutable();
      com.google.protobuf.AbstractMessageLite.Builder.addAll(values, webSearchQueries_);
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. Web search queries for the following-up web search.
     * </pre>
     *
     * <code>repeated string web_search_queries = 1 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return This builder for chaining.
     */
    public Builder clearWebSearchQueries() {
      webSearchQueries_ = com.google.protobuf.LazyStringArrayList.emptyList();
      bitField0_ = (bitField0_ & ~0x00000001);
      ;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. Web search queries for the following-up web search.
     * </pre>
     *
     * <code>repeated string web_search_queries = 1 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @param value The bytes of the webSearchQueries to add.
     * @return This builder for chaining.
     */
    public Builder addWebSearchQueriesBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      ensureWebSearchQueriesIsMutable();
      webSearchQueries_.add(value);
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }

    private com.google.cloud.aiplatform.v1beta1.SearchEntryPoint searchEntryPoint_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.aiplatform.v1beta1.SearchEntryPoint,
            com.google.cloud.aiplatform.v1beta1.SearchEntryPoint.Builder,
            com.google.cloud.aiplatform.v1beta1.SearchEntryPointOrBuilder>
        searchEntryPointBuilder_;
    /**
     *
     *
     * <pre>
     * Optional. Google search entry for the following-up web searches.
     * </pre>
     *
     * <code>
     * optional .google.cloud.aiplatform.v1beta1.SearchEntryPoint search_entry_point = 4 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return Whether the searchEntryPoint field is set.
     */
    public boolean hasSearchEntryPoint() {
      return ((bitField0_ & 0x00000002) != 0);
    }
    /**
     *
     *
     * <pre>
     * Optional. Google search entry for the following-up web searches.
     * </pre>
     *
     * <code>
     * optional .google.cloud.aiplatform.v1beta1.SearchEntryPoint search_entry_point = 4 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return The searchEntryPoint.
     */
    public com.google.cloud.aiplatform.v1beta1.SearchEntryPoint getSearchEntryPoint() {
      if (searchEntryPointBuilder_ == null) {
        return searchEntryPoint_ == null
            ? com.google.cloud.aiplatform.v1beta1.SearchEntryPoint.getDefaultInstance()
            : searchEntryPoint_;
      } else {
        return searchEntryPointBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Optional. Google search entry for the following-up web searches.
     * </pre>
     *
     * <code>
     * optional .google.cloud.aiplatform.v1beta1.SearchEntryPoint search_entry_point = 4 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder setSearchEntryPoint(com.google.cloud.aiplatform.v1beta1.SearchEntryPoint value) {
      if (searchEntryPointBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        searchEntryPoint_ = value;
      } else {
        searchEntryPointBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. Google search entry for the following-up web searches.
     * </pre>
     *
     * <code>
     * optional .google.cloud.aiplatform.v1beta1.SearchEntryPoint search_entry_point = 4 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder setSearchEntryPoint(
        com.google.cloud.aiplatform.v1beta1.SearchEntryPoint.Builder builderForValue) {
      if (searchEntryPointBuilder_ == null) {
        searchEntryPoint_ = builderForValue.build();
      } else {
        searchEntryPointBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. Google search entry for the following-up web searches.
     * </pre>
     *
     * <code>
     * optional .google.cloud.aiplatform.v1beta1.SearchEntryPoint search_entry_point = 4 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder mergeSearchEntryPoint(
        com.google.cloud.aiplatform.v1beta1.SearchEntryPoint value) {
      if (searchEntryPointBuilder_ == null) {
        if (((bitField0_ & 0x00000002) != 0)
            && searchEntryPoint_ != null
            && searchEntryPoint_
                != com.google.cloud.aiplatform.v1beta1.SearchEntryPoint.getDefaultInstance()) {
          getSearchEntryPointBuilder().mergeFrom(value);
        } else {
          searchEntryPoint_ = value;
        }
      } else {
        searchEntryPointBuilder_.mergeFrom(value);
      }
      if (searchEntryPoint_ != null) {
        bitField0_ |= 0x00000002;
        onChanged();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. Google search entry for the following-up web searches.
     * </pre>
     *
     * <code>
     * optional .google.cloud.aiplatform.v1beta1.SearchEntryPoint search_entry_point = 4 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder clearSearchEntryPoint() {
      bitField0_ = (bitField0_ & ~0x00000002);
      searchEntryPoint_ = null;
      if (searchEntryPointBuilder_ != null) {
        searchEntryPointBuilder_.dispose();
        searchEntryPointBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. Google search entry for the following-up web searches.
     * </pre>
     *
     * <code>
     * optional .google.cloud.aiplatform.v1beta1.SearchEntryPoint search_entry_point = 4 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public com.google.cloud.aiplatform.v1beta1.SearchEntryPoint.Builder
        getSearchEntryPointBuilder() {
      bitField0_ |= 0x00000002;
      onChanged();
      return getSearchEntryPointFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Optional. Google search entry for the following-up web searches.
     * </pre>
     *
     * <code>
     * optional .google.cloud.aiplatform.v1beta1.SearchEntryPoint search_entry_point = 4 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public com.google.cloud.aiplatform.v1beta1.SearchEntryPointOrBuilder
        getSearchEntryPointOrBuilder() {
      if (searchEntryPointBuilder_ != null) {
        return searchEntryPointBuilder_.getMessageOrBuilder();
      } else {
        return searchEntryPoint_ == null
            ? com.google.cloud.aiplatform.v1beta1.SearchEntryPoint.getDefaultInstance()
            : searchEntryPoint_;
      }
    }
    /**
     *
     *
     * <pre>
     * Optional. Google search entry for the following-up web searches.
     * </pre>
     *
     * <code>
     * optional .google.cloud.aiplatform.v1beta1.SearchEntryPoint search_entry_point = 4 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.aiplatform.v1beta1.SearchEntryPoint,
            com.google.cloud.aiplatform.v1beta1.SearchEntryPoint.Builder,
            com.google.cloud.aiplatform.v1beta1.SearchEntryPointOrBuilder>
        getSearchEntryPointFieldBuilder() {
      if (searchEntryPointBuilder_ == null) {
        searchEntryPointBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.aiplatform.v1beta1.SearchEntryPoint,
                com.google.cloud.aiplatform.v1beta1.SearchEntryPoint.Builder,
                com.google.cloud.aiplatform.v1beta1.SearchEntryPointOrBuilder>(
                getSearchEntryPoint(), getParentForChildren(), isClean());
        searchEntryPoint_ = null;
      }
      return searchEntryPointBuilder_;
    }

    private com.google.protobuf.LazyStringArrayList retrievalQueries_ =
        com.google.protobuf.LazyStringArrayList.emptyList();

    private void ensureRetrievalQueriesIsMutable() {
      if (!retrievalQueries_.isModifiable()) {
        retrievalQueries_ = new com.google.protobuf.LazyStringArrayList(retrievalQueries_);
      }
      bitField0_ |= 0x00000004;
    }
    /**
     *
     *
     * <pre>
     * Optional. Queries executed by the retrieval tools.
     * </pre>
     *
     * <code>repeated string retrieval_queries = 3 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return A list containing the retrievalQueries.
     */
    public com.google.protobuf.ProtocolStringList getRetrievalQueriesList() {
      retrievalQueries_.makeImmutable();
      return retrievalQueries_;
    }
    /**
     *
     *
     * <pre>
     * Optional. Queries executed by the retrieval tools.
     * </pre>
     *
     * <code>repeated string retrieval_queries = 3 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return The count of retrievalQueries.
     */
    public int getRetrievalQueriesCount() {
      return retrievalQueries_.size();
    }
    /**
     *
     *
     * <pre>
     * Optional. Queries executed by the retrieval tools.
     * </pre>
     *
     * <code>repeated string retrieval_queries = 3 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @param index The index of the element to return.
     * @return The retrievalQueries at the given index.
     */
    public java.lang.String getRetrievalQueries(int index) {
      return retrievalQueries_.get(index);
    }
    /**
     *
     *
     * <pre>
     * Optional. Queries executed by the retrieval tools.
     * </pre>
     *
     * <code>repeated string retrieval_queries = 3 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @param index The index of the value to return.
     * @return The bytes of the retrievalQueries at the given index.
     */
    public com.google.protobuf.ByteString getRetrievalQueriesBytes(int index) {
      return retrievalQueries_.getByteString(index);
    }
    /**
     *
     *
     * <pre>
     * Optional. Queries executed by the retrieval tools.
     * </pre>
     *
     * <code>repeated string retrieval_queries = 3 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @param index The index to set the value at.
     * @param value The retrievalQueries to set.
     * @return This builder for chaining.
     */
    public Builder setRetrievalQueries(int index, java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      ensureRetrievalQueriesIsMutable();
      retrievalQueries_.set(index, value);
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. Queries executed by the retrieval tools.
     * </pre>
     *
     * <code>repeated string retrieval_queries = 3 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @param value The retrievalQueries to add.
     * @return This builder for chaining.
     */
    public Builder addRetrievalQueries(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      ensureRetrievalQueriesIsMutable();
      retrievalQueries_.add(value);
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. Queries executed by the retrieval tools.
     * </pre>
     *
     * <code>repeated string retrieval_queries = 3 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @param values The retrievalQueries to add.
     * @return This builder for chaining.
     */
    public Builder addAllRetrievalQueries(java.lang.Iterable<java.lang.String> values) {
      ensureRetrievalQueriesIsMutable();
      com.google.protobuf.AbstractMessageLite.Builder.addAll(values, retrievalQueries_);
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. Queries executed by the retrieval tools.
     * </pre>
     *
     * <code>repeated string retrieval_queries = 3 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearRetrievalQueries() {
      retrievalQueries_ = com.google.protobuf.LazyStringArrayList.emptyList();
      bitField0_ = (bitField0_ & ~0x00000004);
      ;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. Queries executed by the retrieval tools.
     * </pre>
     *
     * <code>repeated string retrieval_queries = 3 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @param value The bytes of the retrievalQueries to add.
     * @return This builder for chaining.
     */
    public Builder addRetrievalQueriesBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      ensureRetrievalQueriesIsMutable();
      retrievalQueries_.add(value);
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }

    private java.util.List<com.google.cloud.aiplatform.v1beta1.GroundingChunk> groundingChunks_ =
        java.util.Collections.emptyList();

    private void ensureGroundingChunksIsMutable() {
      if (!((bitField0_ & 0x00000008) != 0)) {
        groundingChunks_ =
            new java.util.ArrayList<com.google.cloud.aiplatform.v1beta1.GroundingChunk>(
                groundingChunks_);
        bitField0_ |= 0x00000008;
      }
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.cloud.aiplatform.v1beta1.GroundingChunk,
            com.google.cloud.aiplatform.v1beta1.GroundingChunk.Builder,
            com.google.cloud.aiplatform.v1beta1.GroundingChunkOrBuilder>
        groundingChunksBuilder_;

    /**
     *
     *
     * <pre>
     * List of supporting references retrieved from specified grounding source.
     * </pre>
     *
     * <code>repeated .google.cloud.aiplatform.v1beta1.GroundingChunk grounding_chunks = 5;</code>
     */
    public java.util.List<com.google.cloud.aiplatform.v1beta1.GroundingChunk>
        getGroundingChunksList() {
      if (groundingChunksBuilder_ == null) {
        return java.util.Collections.unmodifiableList(groundingChunks_);
      } else {
        return groundingChunksBuilder_.getMessageList();
      }
    }
    /**
     *
     *
     * <pre>
     * List of supporting references retrieved from specified grounding source.
     * </pre>
     *
     * <code>repeated .google.cloud.aiplatform.v1beta1.GroundingChunk grounding_chunks = 5;</code>
     */
    public int getGroundingChunksCount() {
      if (groundingChunksBuilder_ == null) {
        return groundingChunks_.size();
      } else {
        return groundingChunksBuilder_.getCount();
      }
    }
    /**
     *
     *
     * <pre>
     * List of supporting references retrieved from specified grounding source.
     * </pre>
     *
     * <code>repeated .google.cloud.aiplatform.v1beta1.GroundingChunk grounding_chunks = 5;</code>
     */
    public com.google.cloud.aiplatform.v1beta1.GroundingChunk getGroundingChunks(int index) {
      if (groundingChunksBuilder_ == null) {
        return groundingChunks_.get(index);
      } else {
        return groundingChunksBuilder_.getMessage(index);
      }
    }
    /**
     *
     *
     * <pre>
     * List of supporting references retrieved from specified grounding source.
     * </pre>
     *
     * <code>repeated .google.cloud.aiplatform.v1beta1.GroundingChunk grounding_chunks = 5;</code>
     */
    public Builder setGroundingChunks(
        int index, com.google.cloud.aiplatform.v1beta1.GroundingChunk value) {
      if (groundingChunksBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureGroundingChunksIsMutable();
        groundingChunks_.set(index, value);
        onChanged();
      } else {
        groundingChunksBuilder_.setMessage(index, value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * List of supporting references retrieved from specified grounding source.
     * </pre>
     *
     * <code>repeated .google.cloud.aiplatform.v1beta1.GroundingChunk grounding_chunks = 5;</code>
     */
    public Builder setGroundingChunks(
        int index, com.google.cloud.aiplatform.v1beta1.GroundingChunk.Builder builderForValue) {
      if (groundingChunksBuilder_ == null) {
        ensureGroundingChunksIsMutable();
        groundingChunks_.set(index, builderForValue.build());
        onChanged();
      } else {
        groundingChunksBuilder_.setMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * List of supporting references retrieved from specified grounding source.
     * </pre>
     *
     * <code>repeated .google.cloud.aiplatform.v1beta1.GroundingChunk grounding_chunks = 5;</code>
     */
    public Builder addGroundingChunks(com.google.cloud.aiplatform.v1beta1.GroundingChunk value) {
      if (groundingChunksBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureGroundingChunksIsMutable();
        groundingChunks_.add(value);
        onChanged();
      } else {
        groundingChunksBuilder_.addMessage(value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * List of supporting references retrieved from specified grounding source.
     * </pre>
     *
     * <code>repeated .google.cloud.aiplatform.v1beta1.GroundingChunk grounding_chunks = 5;</code>
     */
    public Builder addGroundingChunks(
        int index, com.google.cloud.aiplatform.v1beta1.GroundingChunk value) {
      if (groundingChunksBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureGroundingChunksIsMutable();
        groundingChunks_.add(index, value);
        onChanged();
      } else {
        groundingChunksBuilder_.addMessage(index, value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * List of supporting references retrieved from specified grounding source.
     * </pre>
     *
     * <code>repeated .google.cloud.aiplatform.v1beta1.GroundingChunk grounding_chunks = 5;</code>
     */
    public Builder addGroundingChunks(
        com.google.cloud.aiplatform.v1beta1.GroundingChunk.Builder builderForValue) {
      if (groundingChunksBuilder_ == null) {
        ensureGroundingChunksIsMutable();
        groundingChunks_.add(builderForValue.build());
        onChanged();
      } else {
        groundingChunksBuilder_.addMessage(builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * List of supporting references retrieved from specified grounding source.
     * </pre>
     *
     * <code>repeated .google.cloud.aiplatform.v1beta1.GroundingChunk grounding_chunks = 5;</code>
     */
    public Builder addGroundingChunks(
        int index, com.google.cloud.aiplatform.v1beta1.GroundingChunk.Builder builderForValue) {
      if (groundingChunksBuilder_ == null) {
        ensureGroundingChunksIsMutable();
        groundingChunks_.add(index, builderForValue.build());
        onChanged();
      } else {
        groundingChunksBuilder_.addMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * List of supporting references retrieved from specified grounding source.
     * </pre>
     *
     * <code>repeated .google.cloud.aiplatform.v1beta1.GroundingChunk grounding_chunks = 5;</code>
     */
    public Builder addAllGroundingChunks(
        java.lang.Iterable<? extends com.google.cloud.aiplatform.v1beta1.GroundingChunk> values) {
      if (groundingChunksBuilder_ == null) {
        ensureGroundingChunksIsMutable();
        com.google.protobuf.AbstractMessageLite.Builder.addAll(values, groundingChunks_);
        onChanged();
      } else {
        groundingChunksBuilder_.addAllMessages(values);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * List of supporting references retrieved from specified grounding source.
     * </pre>
     *
     * <code>repeated .google.cloud.aiplatform.v1beta1.GroundingChunk grounding_chunks = 5;</code>
     */
    public Builder clearGroundingChunks() {
      if (groundingChunksBuilder_ == null) {
        groundingChunks_ = java.util.Collections.emptyList();
        bitField0_ = (bitField0_ & ~0x00000008);
        onChanged();
      } else {
        groundingChunksBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * List of supporting references retrieved from specified grounding source.
     * </pre>
     *
     * <code>repeated .google.cloud.aiplatform.v1beta1.GroundingChunk grounding_chunks = 5;</code>
     */
    public Builder removeGroundingChunks(int index) {
      if (groundingChunksBuilder_ == null) {
        ensureGroundingChunksIsMutable();
        groundingChunks_.remove(index);
        onChanged();
      } else {
        groundingChunksBuilder_.remove(index);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * List of supporting references retrieved from specified grounding source.
     * </pre>
     *
     * <code>repeated .google.cloud.aiplatform.v1beta1.GroundingChunk grounding_chunks = 5;</code>
     */
    public com.google.cloud.aiplatform.v1beta1.GroundingChunk.Builder getGroundingChunksBuilder(
        int index) {
      return getGroundingChunksFieldBuilder().getBuilder(index);
    }
    /**
     *
     *
     * <pre>
     * List of supporting references retrieved from specified grounding source.
     * </pre>
     *
     * <code>repeated .google.cloud.aiplatform.v1beta1.GroundingChunk grounding_chunks = 5;</code>
     */
    public com.google.cloud.aiplatform.v1beta1.GroundingChunkOrBuilder getGroundingChunksOrBuilder(
        int index) {
      if (groundingChunksBuilder_ == null) {
        return groundingChunks_.get(index);
      } else {
        return groundingChunksBuilder_.getMessageOrBuilder(index);
      }
    }
    /**
     *
     *
     * <pre>
     * List of supporting references retrieved from specified grounding source.
     * </pre>
     *
     * <code>repeated .google.cloud.aiplatform.v1beta1.GroundingChunk grounding_chunks = 5;</code>
     */
    public java.util.List<? extends com.google.cloud.aiplatform.v1beta1.GroundingChunkOrBuilder>
        getGroundingChunksOrBuilderList() {
      if (groundingChunksBuilder_ != null) {
        return groundingChunksBuilder_.getMessageOrBuilderList();
      } else {
        return java.util.Collections.unmodifiableList(groundingChunks_);
      }
    }
    /**
     *
     *
     * <pre>
     * List of supporting references retrieved from specified grounding source.
     * </pre>
     *
     * <code>repeated .google.cloud.aiplatform.v1beta1.GroundingChunk grounding_chunks = 5;</code>
     */
    public com.google.cloud.aiplatform.v1beta1.GroundingChunk.Builder addGroundingChunksBuilder() {
      return getGroundingChunksFieldBuilder()
          .addBuilder(com.google.cloud.aiplatform.v1beta1.GroundingChunk.getDefaultInstance());
    }
    /**
     *
     *
     * <pre>
     * List of supporting references retrieved from specified grounding source.
     * </pre>
     *
     * <code>repeated .google.cloud.aiplatform.v1beta1.GroundingChunk grounding_chunks = 5;</code>
     */
    public com.google.cloud.aiplatform.v1beta1.GroundingChunk.Builder addGroundingChunksBuilder(
        int index) {
      return getGroundingChunksFieldBuilder()
          .addBuilder(
              index, com.google.cloud.aiplatform.v1beta1.GroundingChunk.getDefaultInstance());
    }
    /**
     *
     *
     * <pre>
     * List of supporting references retrieved from specified grounding source.
     * </pre>
     *
     * <code>repeated .google.cloud.aiplatform.v1beta1.GroundingChunk grounding_chunks = 5;</code>
     */
    public java.util.List<com.google.cloud.aiplatform.v1beta1.GroundingChunk.Builder>
        getGroundingChunksBuilderList() {
      return getGroundingChunksFieldBuilder().getBuilderList();
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.cloud.aiplatform.v1beta1.GroundingChunk,
            com.google.cloud.aiplatform.v1beta1.GroundingChunk.Builder,
            com.google.cloud.aiplatform.v1beta1.GroundingChunkOrBuilder>
        getGroundingChunksFieldBuilder() {
      if (groundingChunksBuilder_ == null) {
        groundingChunksBuilder_ =
            new com.google.protobuf.RepeatedFieldBuilderV3<
                com.google.cloud.aiplatform.v1beta1.GroundingChunk,
                com.google.cloud.aiplatform.v1beta1.GroundingChunk.Builder,
                com.google.cloud.aiplatform.v1beta1.GroundingChunkOrBuilder>(
                groundingChunks_,
                ((bitField0_ & 0x00000008) != 0),
                getParentForChildren(),
                isClean());
        groundingChunks_ = null;
      }
      return groundingChunksBuilder_;
    }

    private java.util.List<com.google.cloud.aiplatform.v1beta1.GroundingSupport>
        groundingSupports_ = java.util.Collections.emptyList();

    private void ensureGroundingSupportsIsMutable() {
      if (!((bitField0_ & 0x00000010) != 0)) {
        groundingSupports_ =
            new java.util.ArrayList<com.google.cloud.aiplatform.v1beta1.GroundingSupport>(
                groundingSupports_);
        bitField0_ |= 0x00000010;
      }
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.cloud.aiplatform.v1beta1.GroundingSupport,
            com.google.cloud.aiplatform.v1beta1.GroundingSupport.Builder,
            com.google.cloud.aiplatform.v1beta1.GroundingSupportOrBuilder>
        groundingSupportsBuilder_;

    /**
     *
     *
     * <pre>
     * Optional. List of grounding support.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.aiplatform.v1beta1.GroundingSupport grounding_supports = 6 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public java.util.List<com.google.cloud.aiplatform.v1beta1.GroundingSupport>
        getGroundingSupportsList() {
      if (groundingSupportsBuilder_ == null) {
        return java.util.Collections.unmodifiableList(groundingSupports_);
      } else {
        return groundingSupportsBuilder_.getMessageList();
      }
    }
    /**
     *
     *
     * <pre>
     * Optional. List of grounding support.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.aiplatform.v1beta1.GroundingSupport grounding_supports = 6 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public int getGroundingSupportsCount() {
      if (groundingSupportsBuilder_ == null) {
        return groundingSupports_.size();
      } else {
        return groundingSupportsBuilder_.getCount();
      }
    }
    /**
     *
     *
     * <pre>
     * Optional. List of grounding support.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.aiplatform.v1beta1.GroundingSupport grounding_supports = 6 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public com.google.cloud.aiplatform.v1beta1.GroundingSupport getGroundingSupports(int index) {
      if (groundingSupportsBuilder_ == null) {
        return groundingSupports_.get(index);
      } else {
        return groundingSupportsBuilder_.getMessage(index);
      }
    }
    /**
     *
     *
     * <pre>
     * Optional. List of grounding support.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.aiplatform.v1beta1.GroundingSupport grounding_supports = 6 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder setGroundingSupports(
        int index, com.google.cloud.aiplatform.v1beta1.GroundingSupport value) {
      if (groundingSupportsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureGroundingSupportsIsMutable();
        groundingSupports_.set(index, value);
        onChanged();
      } else {
        groundingSupportsBuilder_.setMessage(index, value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. List of grounding support.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.aiplatform.v1beta1.GroundingSupport grounding_supports = 6 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder setGroundingSupports(
        int index, com.google.cloud.aiplatform.v1beta1.GroundingSupport.Builder builderForValue) {
      if (groundingSupportsBuilder_ == null) {
        ensureGroundingSupportsIsMutable();
        groundingSupports_.set(index, builderForValue.build());
        onChanged();
      } else {
        groundingSupportsBuilder_.setMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. List of grounding support.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.aiplatform.v1beta1.GroundingSupport grounding_supports = 6 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder addGroundingSupports(
        com.google.cloud.aiplatform.v1beta1.GroundingSupport value) {
      if (groundingSupportsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureGroundingSupportsIsMutable();
        groundingSupports_.add(value);
        onChanged();
      } else {
        groundingSupportsBuilder_.addMessage(value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. List of grounding support.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.aiplatform.v1beta1.GroundingSupport grounding_supports = 6 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder addGroundingSupports(
        int index, com.google.cloud.aiplatform.v1beta1.GroundingSupport value) {
      if (groundingSupportsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureGroundingSupportsIsMutable();
        groundingSupports_.add(index, value);
        onChanged();
      } else {
        groundingSupportsBuilder_.addMessage(index, value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. List of grounding support.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.aiplatform.v1beta1.GroundingSupport grounding_supports = 6 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder addGroundingSupports(
        com.google.cloud.aiplatform.v1beta1.GroundingSupport.Builder builderForValue) {
      if (groundingSupportsBuilder_ == null) {
        ensureGroundingSupportsIsMutable();
        groundingSupports_.add(builderForValue.build());
        onChanged();
      } else {
        groundingSupportsBuilder_.addMessage(builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. List of grounding support.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.aiplatform.v1beta1.GroundingSupport grounding_supports = 6 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder addGroundingSupports(
        int index, com.google.cloud.aiplatform.v1beta1.GroundingSupport.Builder builderForValue) {
      if (groundingSupportsBuilder_ == null) {
        ensureGroundingSupportsIsMutable();
        groundingSupports_.add(index, builderForValue.build());
        onChanged();
      } else {
        groundingSupportsBuilder_.addMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. List of grounding support.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.aiplatform.v1beta1.GroundingSupport grounding_supports = 6 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder addAllGroundingSupports(
        java.lang.Iterable<? extends com.google.cloud.aiplatform.v1beta1.GroundingSupport> values) {
      if (groundingSupportsBuilder_ == null) {
        ensureGroundingSupportsIsMutable();
        com.google.protobuf.AbstractMessageLite.Builder.addAll(values, groundingSupports_);
        onChanged();
      } else {
        groundingSupportsBuilder_.addAllMessages(values);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. List of grounding support.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.aiplatform.v1beta1.GroundingSupport grounding_supports = 6 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder clearGroundingSupports() {
      if (groundingSupportsBuilder_ == null) {
        groundingSupports_ = java.util.Collections.emptyList();
        bitField0_ = (bitField0_ & ~0x00000010);
        onChanged();
      } else {
        groundingSupportsBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. List of grounding support.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.aiplatform.v1beta1.GroundingSupport grounding_supports = 6 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder removeGroundingSupports(int index) {
      if (groundingSupportsBuilder_ == null) {
        ensureGroundingSupportsIsMutable();
        groundingSupports_.remove(index);
        onChanged();
      } else {
        groundingSupportsBuilder_.remove(index);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. List of grounding support.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.aiplatform.v1beta1.GroundingSupport grounding_supports = 6 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public com.google.cloud.aiplatform.v1beta1.GroundingSupport.Builder getGroundingSupportsBuilder(
        int index) {
      return getGroundingSupportsFieldBuilder().getBuilder(index);
    }
    /**
     *
     *
     * <pre>
     * Optional. List of grounding support.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.aiplatform.v1beta1.GroundingSupport grounding_supports = 6 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public com.google.cloud.aiplatform.v1beta1.GroundingSupportOrBuilder
        getGroundingSupportsOrBuilder(int index) {
      if (groundingSupportsBuilder_ == null) {
        return groundingSupports_.get(index);
      } else {
        return groundingSupportsBuilder_.getMessageOrBuilder(index);
      }
    }
    /**
     *
     *
     * <pre>
     * Optional. List of grounding support.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.aiplatform.v1beta1.GroundingSupport grounding_supports = 6 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public java.util.List<? extends com.google.cloud.aiplatform.v1beta1.GroundingSupportOrBuilder>
        getGroundingSupportsOrBuilderList() {
      if (groundingSupportsBuilder_ != null) {
        return groundingSupportsBuilder_.getMessageOrBuilderList();
      } else {
        return java.util.Collections.unmodifiableList(groundingSupports_);
      }
    }
    /**
     *
     *
     * <pre>
     * Optional. List of grounding support.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.aiplatform.v1beta1.GroundingSupport grounding_supports = 6 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public com.google.cloud.aiplatform.v1beta1.GroundingSupport.Builder
        addGroundingSupportsBuilder() {
      return getGroundingSupportsFieldBuilder()
          .addBuilder(com.google.cloud.aiplatform.v1beta1.GroundingSupport.getDefaultInstance());
    }
    /**
     *
     *
     * <pre>
     * Optional. List of grounding support.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.aiplatform.v1beta1.GroundingSupport grounding_supports = 6 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public com.google.cloud.aiplatform.v1beta1.GroundingSupport.Builder addGroundingSupportsBuilder(
        int index) {
      return getGroundingSupportsFieldBuilder()
          .addBuilder(
              index, com.google.cloud.aiplatform.v1beta1.GroundingSupport.getDefaultInstance());
    }
    /**
     *
     *
     * <pre>
     * Optional. List of grounding support.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.aiplatform.v1beta1.GroundingSupport grounding_supports = 6 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public java.util.List<com.google.cloud.aiplatform.v1beta1.GroundingSupport.Builder>
        getGroundingSupportsBuilderList() {
      return getGroundingSupportsFieldBuilder().getBuilderList();
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.cloud.aiplatform.v1beta1.GroundingSupport,
            com.google.cloud.aiplatform.v1beta1.GroundingSupport.Builder,
            com.google.cloud.aiplatform.v1beta1.GroundingSupportOrBuilder>
        getGroundingSupportsFieldBuilder() {
      if (groundingSupportsBuilder_ == null) {
        groundingSupportsBuilder_ =
            new com.google.protobuf.RepeatedFieldBuilderV3<
                com.google.cloud.aiplatform.v1beta1.GroundingSupport,
                com.google.cloud.aiplatform.v1beta1.GroundingSupport.Builder,
                com.google.cloud.aiplatform.v1beta1.GroundingSupportOrBuilder>(
                groundingSupports_,
                ((bitField0_ & 0x00000010) != 0),
                getParentForChildren(),
                isClean());
        groundingSupports_ = null;
      }
      return groundingSupportsBuilder_;
    }

    private com.google.cloud.aiplatform.v1beta1.RetrievalMetadata retrievalMetadata_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.aiplatform.v1beta1.RetrievalMetadata,
            com.google.cloud.aiplatform.v1beta1.RetrievalMetadata.Builder,
            com.google.cloud.aiplatform.v1beta1.RetrievalMetadataOrBuilder>
        retrievalMetadataBuilder_;
    /**
     *
     *
     * <pre>
     * Optional. Output only. Retrieval metadata.
     * </pre>
     *
     * <code>
     * optional .google.cloud.aiplatform.v1beta1.RetrievalMetadata retrieval_metadata = 7 [(.google.api.field_behavior) = OPTIONAL, (.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return Whether the retrievalMetadata field is set.
     */
    public boolean hasRetrievalMetadata() {
      return ((bitField0_ & 0x00000020) != 0);
    }
    /**
     *
     *
     * <pre>
     * Optional. Output only. Retrieval metadata.
     * </pre>
     *
     * <code>
     * optional .google.cloud.aiplatform.v1beta1.RetrievalMetadata retrieval_metadata = 7 [(.google.api.field_behavior) = OPTIONAL, (.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return The retrievalMetadata.
     */
    public com.google.cloud.aiplatform.v1beta1.RetrievalMetadata getRetrievalMetadata() {
      if (retrievalMetadataBuilder_ == null) {
        return retrievalMetadata_ == null
            ? com.google.cloud.aiplatform.v1beta1.RetrievalMetadata.getDefaultInstance()
            : retrievalMetadata_;
      } else {
        return retrievalMetadataBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Optional. Output only. Retrieval metadata.
     * </pre>
     *
     * <code>
     * optional .google.cloud.aiplatform.v1beta1.RetrievalMetadata retrieval_metadata = 7 [(.google.api.field_behavior) = OPTIONAL, (.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder setRetrievalMetadata(
        com.google.cloud.aiplatform.v1beta1.RetrievalMetadata value) {
      if (retrievalMetadataBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        retrievalMetadata_ = value;
      } else {
        retrievalMetadataBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000020;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. Output only. Retrieval metadata.
     * </pre>
     *
     * <code>
     * optional .google.cloud.aiplatform.v1beta1.RetrievalMetadata retrieval_metadata = 7 [(.google.api.field_behavior) = OPTIONAL, (.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder setRetrievalMetadata(
        com.google.cloud.aiplatform.v1beta1.RetrievalMetadata.Builder builderForValue) {
      if (retrievalMetadataBuilder_ == null) {
        retrievalMetadata_ = builderForValue.build();
      } else {
        retrievalMetadataBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000020;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. Output only. Retrieval metadata.
     * </pre>
     *
     * <code>
     * optional .google.cloud.aiplatform.v1beta1.RetrievalMetadata retrieval_metadata = 7 [(.google.api.field_behavior) = OPTIONAL, (.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder mergeRetrievalMetadata(
        com.google.cloud.aiplatform.v1beta1.RetrievalMetadata value) {
      if (retrievalMetadataBuilder_ == null) {
        if (((bitField0_ & 0x00000020) != 0)
            && retrievalMetadata_ != null
            && retrievalMetadata_
                != com.google.cloud.aiplatform.v1beta1.RetrievalMetadata.getDefaultInstance()) {
          getRetrievalMetadataBuilder().mergeFrom(value);
        } else {
          retrievalMetadata_ = value;
        }
      } else {
        retrievalMetadataBuilder_.mergeFrom(value);
      }
      if (retrievalMetadata_ != null) {
        bitField0_ |= 0x00000020;
        onChanged();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. Output only. Retrieval metadata.
     * </pre>
     *
     * <code>
     * optional .google.cloud.aiplatform.v1beta1.RetrievalMetadata retrieval_metadata = 7 [(.google.api.field_behavior) = OPTIONAL, (.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder clearRetrievalMetadata() {
      bitField0_ = (bitField0_ & ~0x00000020);
      retrievalMetadata_ = null;
      if (retrievalMetadataBuilder_ != null) {
        retrievalMetadataBuilder_.dispose();
        retrievalMetadataBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. Output only. Retrieval metadata.
     * </pre>
     *
     * <code>
     * optional .google.cloud.aiplatform.v1beta1.RetrievalMetadata retrieval_metadata = 7 [(.google.api.field_behavior) = OPTIONAL, (.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.cloud.aiplatform.v1beta1.RetrievalMetadata.Builder
        getRetrievalMetadataBuilder() {
      bitField0_ |= 0x00000020;
      onChanged();
      return getRetrievalMetadataFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Optional. Output only. Retrieval metadata.
     * </pre>
     *
     * <code>
     * optional .google.cloud.aiplatform.v1beta1.RetrievalMetadata retrieval_metadata = 7 [(.google.api.field_behavior) = OPTIONAL, (.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.cloud.aiplatform.v1beta1.RetrievalMetadataOrBuilder
        getRetrievalMetadataOrBuilder() {
      if (retrievalMetadataBuilder_ != null) {
        return retrievalMetadataBuilder_.getMessageOrBuilder();
      } else {
        return retrievalMetadata_ == null
            ? com.google.cloud.aiplatform.v1beta1.RetrievalMetadata.getDefaultInstance()
            : retrievalMetadata_;
      }
    }
    /**
     *
     *
     * <pre>
     * Optional. Output only. Retrieval metadata.
     * </pre>
     *
     * <code>
     * optional .google.cloud.aiplatform.v1beta1.RetrievalMetadata retrieval_metadata = 7 [(.google.api.field_behavior) = OPTIONAL, (.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.aiplatform.v1beta1.RetrievalMetadata,
            com.google.cloud.aiplatform.v1beta1.RetrievalMetadata.Builder,
            com.google.cloud.aiplatform.v1beta1.RetrievalMetadataOrBuilder>
        getRetrievalMetadataFieldBuilder() {
      if (retrievalMetadataBuilder_ == null) {
        retrievalMetadataBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.aiplatform.v1beta1.RetrievalMetadata,
                com.google.cloud.aiplatform.v1beta1.RetrievalMetadata.Builder,
                com.google.cloud.aiplatform.v1beta1.RetrievalMetadataOrBuilder>(
                getRetrievalMetadata(), getParentForChildren(), isClean());
        retrievalMetadata_ = null;
      }
      return retrievalMetadataBuilder_;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.cloud.aiplatform.v1beta1.GroundingMetadata)
  }

  // @@protoc_insertion_point(class_scope:google.cloud.aiplatform.v1beta1.GroundingMetadata)
  private static final com.google.cloud.aiplatform.v1beta1.GroundingMetadata DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.cloud.aiplatform.v1beta1.GroundingMetadata();
  }

  public static com.google.cloud.aiplatform.v1beta1.GroundingMetadata getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<GroundingMetadata> PARSER =
      new com.google.protobuf.AbstractParser<GroundingMetadata>() {
        @java.lang.Override
        public GroundingMetadata parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          Builder builder = newBuilder();
          try {
            builder.mergeFrom(input, extensionRegistry);
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.setUnfinishedMessage(builder.buildPartial());
          } catch (com.google.protobuf.UninitializedMessageException e) {
            throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
          } catch (java.io.IOException e) {
            throw new com.google.protobuf.InvalidProtocolBufferException(e)
                .setUnfinishedMessage(builder.buildPartial());
          }
          return builder.buildPartial();
        }
      };

  public static com.google.protobuf.Parser<GroundingMetadata> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<GroundingMetadata> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.cloud.aiplatform.v1beta1.GroundingMetadata getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
