/*
 * Copyright 2024 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/cloud/aiplatform/v1beta1/model_monitoring_alert.proto

// Protobuf Java Version: 3.25.5
package com.google.cloud.aiplatform.v1beta1;

/**
 *
 *
 * <pre>
 * Represents a single model monitoring anomaly.
 * </pre>
 *
 * Protobuf type {@code google.cloud.aiplatform.v1beta1.ModelMonitoringAnomaly}
 */
public final class ModelMonitoringAnomaly extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.cloud.aiplatform.v1beta1.ModelMonitoringAnomaly)
    ModelMonitoringAnomalyOrBuilder {
  private static final long serialVersionUID = 0L;
  // Use ModelMonitoringAnomaly.newBuilder() to construct.
  private ModelMonitoringAnomaly(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private ModelMonitoringAnomaly() {
    modelMonitoringJob_ = "";
    algorithm_ = "";
  }

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new ModelMonitoringAnomaly();
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.cloud.aiplatform.v1beta1.ModelMonitoringAlertProto
        .internal_static_google_cloud_aiplatform_v1beta1_ModelMonitoringAnomaly_descriptor;
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.cloud.aiplatform.v1beta1.ModelMonitoringAlertProto
        .internal_static_google_cloud_aiplatform_v1beta1_ModelMonitoringAnomaly_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.cloud.aiplatform.v1beta1.ModelMonitoringAnomaly.class,
            com.google.cloud.aiplatform.v1beta1.ModelMonitoringAnomaly.Builder.class);
  }

  public interface TabularAnomalyOrBuilder
      extends
      // @@protoc_insertion_point(interface_extends:google.cloud.aiplatform.v1beta1.ModelMonitoringAnomaly.TabularAnomaly)
      com.google.protobuf.MessageOrBuilder {

    /**
     *
     *
     * <pre>
     * Additional anomaly information. e.g. Google Cloud Storage uri.
     * </pre>
     *
     * <code>string anomaly_uri = 1;</code>
     *
     * @return The anomalyUri.
     */
    java.lang.String getAnomalyUri();
    /**
     *
     *
     * <pre>
     * Additional anomaly information. e.g. Google Cloud Storage uri.
     * </pre>
     *
     * <code>string anomaly_uri = 1;</code>
     *
     * @return The bytes for anomalyUri.
     */
    com.google.protobuf.ByteString getAnomalyUriBytes();

    /**
     *
     *
     * <pre>
     * Overview of this anomaly.
     * </pre>
     *
     * <code>string summary = 2;</code>
     *
     * @return The summary.
     */
    java.lang.String getSummary();
    /**
     *
     *
     * <pre>
     * Overview of this anomaly.
     * </pre>
     *
     * <code>string summary = 2;</code>
     *
     * @return The bytes for summary.
     */
    com.google.protobuf.ByteString getSummaryBytes();

    /**
     *
     *
     * <pre>
     * Anomaly body.
     * </pre>
     *
     * <code>.google.protobuf.Value anomaly = 3;</code>
     *
     * @return Whether the anomaly field is set.
     */
    boolean hasAnomaly();
    /**
     *
     *
     * <pre>
     * Anomaly body.
     * </pre>
     *
     * <code>.google.protobuf.Value anomaly = 3;</code>
     *
     * @return The anomaly.
     */
    com.google.protobuf.Value getAnomaly();
    /**
     *
     *
     * <pre>
     * Anomaly body.
     * </pre>
     *
     * <code>.google.protobuf.Value anomaly = 3;</code>
     */
    com.google.protobuf.ValueOrBuilder getAnomalyOrBuilder();

    /**
     *
     *
     * <pre>
     * The time the anomaly was triggered.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp trigger_time = 4;</code>
     *
     * @return Whether the triggerTime field is set.
     */
    boolean hasTriggerTime();
    /**
     *
     *
     * <pre>
     * The time the anomaly was triggered.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp trigger_time = 4;</code>
     *
     * @return The triggerTime.
     */
    com.google.protobuf.Timestamp getTriggerTime();
    /**
     *
     *
     * <pre>
     * The time the anomaly was triggered.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp trigger_time = 4;</code>
     */
    com.google.protobuf.TimestampOrBuilder getTriggerTimeOrBuilder();

    /**
     *
     *
     * <pre>
     * The alert condition associated with this anomaly.
     * </pre>
     *
     * <code>.google.cloud.aiplatform.v1beta1.ModelMonitoringAlertCondition condition = 5;</code>
     *
     * @return Whether the condition field is set.
     */
    boolean hasCondition();
    /**
     *
     *
     * <pre>
     * The alert condition associated with this anomaly.
     * </pre>
     *
     * <code>.google.cloud.aiplatform.v1beta1.ModelMonitoringAlertCondition condition = 5;</code>
     *
     * @return The condition.
     */
    com.google.cloud.aiplatform.v1beta1.ModelMonitoringAlertCondition getCondition();
    /**
     *
     *
     * <pre>
     * The alert condition associated with this anomaly.
     * </pre>
     *
     * <code>.google.cloud.aiplatform.v1beta1.ModelMonitoringAlertCondition condition = 5;</code>
     */
    com.google.cloud.aiplatform.v1beta1.ModelMonitoringAlertConditionOrBuilder
        getConditionOrBuilder();
  }
  /**
   *
   *
   * <pre>
   * Tabular anomaly details.
   * </pre>
   *
   * Protobuf type {@code google.cloud.aiplatform.v1beta1.ModelMonitoringAnomaly.TabularAnomaly}
   */
  public static final class TabularAnomaly extends com.google.protobuf.GeneratedMessageV3
      implements
      // @@protoc_insertion_point(message_implements:google.cloud.aiplatform.v1beta1.ModelMonitoringAnomaly.TabularAnomaly)
      TabularAnomalyOrBuilder {
    private static final long serialVersionUID = 0L;
    // Use TabularAnomaly.newBuilder() to construct.
    private TabularAnomaly(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
      super(builder);
    }

    private TabularAnomaly() {
      anomalyUri_ = "";
      summary_ = "";
    }

    @java.lang.Override
    @SuppressWarnings({"unused"})
    protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
      return new TabularAnomaly();
    }

    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.aiplatform.v1beta1.ModelMonitoringAlertProto
          .internal_static_google_cloud_aiplatform_v1beta1_ModelMonitoringAnomaly_TabularAnomaly_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.aiplatform.v1beta1.ModelMonitoringAlertProto
          .internal_static_google_cloud_aiplatform_v1beta1_ModelMonitoringAnomaly_TabularAnomaly_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.aiplatform.v1beta1.ModelMonitoringAnomaly.TabularAnomaly.class,
              com.google.cloud.aiplatform.v1beta1.ModelMonitoringAnomaly.TabularAnomaly.Builder
                  .class);
    }

    private int bitField0_;
    public static final int ANOMALY_URI_FIELD_NUMBER = 1;

    @SuppressWarnings("serial")
    private volatile java.lang.Object anomalyUri_ = "";
    /**
     *
     *
     * <pre>
     * Additional anomaly information. e.g. Google Cloud Storage uri.
     * </pre>
     *
     * <code>string anomaly_uri = 1;</code>
     *
     * @return The anomalyUri.
     */
    @java.lang.Override
    public java.lang.String getAnomalyUri() {
      java.lang.Object ref = anomalyUri_;
      if (ref instanceof java.lang.String) {
        return (java.lang.String) ref;
      } else {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        anomalyUri_ = s;
        return s;
      }
    }
    /**
     *
     *
     * <pre>
     * Additional anomaly information. e.g. Google Cloud Storage uri.
     * </pre>
     *
     * <code>string anomaly_uri = 1;</code>
     *
     * @return The bytes for anomalyUri.
     */
    @java.lang.Override
    public com.google.protobuf.ByteString getAnomalyUriBytes() {
      java.lang.Object ref = anomalyUri_;
      if (ref instanceof java.lang.String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        anomalyUri_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    public static final int SUMMARY_FIELD_NUMBER = 2;

    @SuppressWarnings("serial")
    private volatile java.lang.Object summary_ = "";
    /**
     *
     *
     * <pre>
     * Overview of this anomaly.
     * </pre>
     *
     * <code>string summary = 2;</code>
     *
     * @return The summary.
     */
    @java.lang.Override
    public java.lang.String getSummary() {
      java.lang.Object ref = summary_;
      if (ref instanceof java.lang.String) {
        return (java.lang.String) ref;
      } else {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        summary_ = s;
        return s;
      }
    }
    /**
     *
     *
     * <pre>
     * Overview of this anomaly.
     * </pre>
     *
     * <code>string summary = 2;</code>
     *
     * @return The bytes for summary.
     */
    @java.lang.Override
    public com.google.protobuf.ByteString getSummaryBytes() {
      java.lang.Object ref = summary_;
      if (ref instanceof java.lang.String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        summary_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    public static final int ANOMALY_FIELD_NUMBER = 3;
    private com.google.protobuf.Value anomaly_;
    /**
     *
     *
     * <pre>
     * Anomaly body.
     * </pre>
     *
     * <code>.google.protobuf.Value anomaly = 3;</code>
     *
     * @return Whether the anomaly field is set.
     */
    @java.lang.Override
    public boolean hasAnomaly() {
      return ((bitField0_ & 0x00000001) != 0);
    }
    /**
     *
     *
     * <pre>
     * Anomaly body.
     * </pre>
     *
     * <code>.google.protobuf.Value anomaly = 3;</code>
     *
     * @return The anomaly.
     */
    @java.lang.Override
    public com.google.protobuf.Value getAnomaly() {
      return anomaly_ == null ? com.google.protobuf.Value.getDefaultInstance() : anomaly_;
    }
    /**
     *
     *
     * <pre>
     * Anomaly body.
     * </pre>
     *
     * <code>.google.protobuf.Value anomaly = 3;</code>
     */
    @java.lang.Override
    public com.google.protobuf.ValueOrBuilder getAnomalyOrBuilder() {
      return anomaly_ == null ? com.google.protobuf.Value.getDefaultInstance() : anomaly_;
    }

    public static final int TRIGGER_TIME_FIELD_NUMBER = 4;
    private com.google.protobuf.Timestamp triggerTime_;
    /**
     *
     *
     * <pre>
     * The time the anomaly was triggered.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp trigger_time = 4;</code>
     *
     * @return Whether the triggerTime field is set.
     */
    @java.lang.Override
    public boolean hasTriggerTime() {
      return ((bitField0_ & 0x00000002) != 0);
    }
    /**
     *
     *
     * <pre>
     * The time the anomaly was triggered.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp trigger_time = 4;</code>
     *
     * @return The triggerTime.
     */
    @java.lang.Override
    public com.google.protobuf.Timestamp getTriggerTime() {
      return triggerTime_ == null
          ? com.google.protobuf.Timestamp.getDefaultInstance()
          : triggerTime_;
    }
    /**
     *
     *
     * <pre>
     * The time the anomaly was triggered.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp trigger_time = 4;</code>
     */
    @java.lang.Override
    public com.google.protobuf.TimestampOrBuilder getTriggerTimeOrBuilder() {
      return triggerTime_ == null
          ? com.google.protobuf.Timestamp.getDefaultInstance()
          : triggerTime_;
    }

    public static final int CONDITION_FIELD_NUMBER = 5;
    private com.google.cloud.aiplatform.v1beta1.ModelMonitoringAlertCondition condition_;
    /**
     *
     *
     * <pre>
     * The alert condition associated with this anomaly.
     * </pre>
     *
     * <code>.google.cloud.aiplatform.v1beta1.ModelMonitoringAlertCondition condition = 5;</code>
     *
     * @return Whether the condition field is set.
     */
    @java.lang.Override
    public boolean hasCondition() {
      return ((bitField0_ & 0x00000004) != 0);
    }
    /**
     *
     *
     * <pre>
     * The alert condition associated with this anomaly.
     * </pre>
     *
     * <code>.google.cloud.aiplatform.v1beta1.ModelMonitoringAlertCondition condition = 5;</code>
     *
     * @return The condition.
     */
    @java.lang.Override
    public com.google.cloud.aiplatform.v1beta1.ModelMonitoringAlertCondition getCondition() {
      return condition_ == null
          ? com.google.cloud.aiplatform.v1beta1.ModelMonitoringAlertCondition.getDefaultInstance()
          : condition_;
    }
    /**
     *
     *
     * <pre>
     * The alert condition associated with this anomaly.
     * </pre>
     *
     * <code>.google.cloud.aiplatform.v1beta1.ModelMonitoringAlertCondition condition = 5;</code>
     */
    @java.lang.Override
    public com.google.cloud.aiplatform.v1beta1.ModelMonitoringAlertConditionOrBuilder
        getConditionOrBuilder() {
      return condition_ == null
          ? com.google.cloud.aiplatform.v1beta1.ModelMonitoringAlertCondition.getDefaultInstance()
          : condition_;
    }

    private byte memoizedIsInitialized = -1;

    @java.lang.Override
    public final boolean isInitialized() {
      byte isInitialized = memoizedIsInitialized;
      if (isInitialized == 1) return true;
      if (isInitialized == 0) return false;

      memoizedIsInitialized = 1;
      return true;
    }

    @java.lang.Override
    public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(anomalyUri_)) {
        com.google.protobuf.GeneratedMessageV3.writeString(output, 1, anomalyUri_);
      }
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(summary_)) {
        com.google.protobuf.GeneratedMessageV3.writeString(output, 2, summary_);
      }
      if (((bitField0_ & 0x00000001) != 0)) {
        output.writeMessage(3, getAnomaly());
      }
      if (((bitField0_ & 0x00000002) != 0)) {
        output.writeMessage(4, getTriggerTime());
      }
      if (((bitField0_ & 0x00000004) != 0)) {
        output.writeMessage(5, getCondition());
      }
      getUnknownFields().writeTo(output);
    }

    @java.lang.Override
    public int getSerializedSize() {
      int size = memoizedSize;
      if (size != -1) return size;

      size = 0;
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(anomalyUri_)) {
        size += com.google.protobuf.GeneratedMessageV3.computeStringSize(1, anomalyUri_);
      }
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(summary_)) {
        size += com.google.protobuf.GeneratedMessageV3.computeStringSize(2, summary_);
      }
      if (((bitField0_ & 0x00000001) != 0)) {
        size += com.google.protobuf.CodedOutputStream.computeMessageSize(3, getAnomaly());
      }
      if (((bitField0_ & 0x00000002) != 0)) {
        size += com.google.protobuf.CodedOutputStream.computeMessageSize(4, getTriggerTime());
      }
      if (((bitField0_ & 0x00000004) != 0)) {
        size += com.google.protobuf.CodedOutputStream.computeMessageSize(5, getCondition());
      }
      size += getUnknownFields().getSerializedSize();
      memoizedSize = size;
      return size;
    }

    @java.lang.Override
    public boolean equals(final java.lang.Object obj) {
      if (obj == this) {
        return true;
      }
      if (!(obj
          instanceof com.google.cloud.aiplatform.v1beta1.ModelMonitoringAnomaly.TabularAnomaly)) {
        return super.equals(obj);
      }
      com.google.cloud.aiplatform.v1beta1.ModelMonitoringAnomaly.TabularAnomaly other =
          (com.google.cloud.aiplatform.v1beta1.ModelMonitoringAnomaly.TabularAnomaly) obj;

      if (!getAnomalyUri().equals(other.getAnomalyUri())) return false;
      if (!getSummary().equals(other.getSummary())) return false;
      if (hasAnomaly() != other.hasAnomaly()) return false;
      if (hasAnomaly()) {
        if (!getAnomaly().equals(other.getAnomaly())) return false;
      }
      if (hasTriggerTime() != other.hasTriggerTime()) return false;
      if (hasTriggerTime()) {
        if (!getTriggerTime().equals(other.getTriggerTime())) return false;
      }
      if (hasCondition() != other.hasCondition()) return false;
      if (hasCondition()) {
        if (!getCondition().equals(other.getCondition())) return false;
      }
      if (!getUnknownFields().equals(other.getUnknownFields())) return false;
      return true;
    }

    @java.lang.Override
    public int hashCode() {
      if (memoizedHashCode != 0) {
        return memoizedHashCode;
      }
      int hash = 41;
      hash = (19 * hash) + getDescriptor().hashCode();
      hash = (37 * hash) + ANOMALY_URI_FIELD_NUMBER;
      hash = (53 * hash) + getAnomalyUri().hashCode();
      hash = (37 * hash) + SUMMARY_FIELD_NUMBER;
      hash = (53 * hash) + getSummary().hashCode();
      if (hasAnomaly()) {
        hash = (37 * hash) + ANOMALY_FIELD_NUMBER;
        hash = (53 * hash) + getAnomaly().hashCode();
      }
      if (hasTriggerTime()) {
        hash = (37 * hash) + TRIGGER_TIME_FIELD_NUMBER;
        hash = (53 * hash) + getTriggerTime().hashCode();
      }
      if (hasCondition()) {
        hash = (37 * hash) + CONDITION_FIELD_NUMBER;
        hash = (53 * hash) + getCondition().hashCode();
      }
      hash = (29 * hash) + getUnknownFields().hashCode();
      memoizedHashCode = hash;
      return hash;
    }

    public static com.google.cloud.aiplatform.v1beta1.ModelMonitoringAnomaly.TabularAnomaly
        parseFrom(java.nio.ByteBuffer data)
            throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.aiplatform.v1beta1.ModelMonitoringAnomaly.TabularAnomaly
        parseFrom(
            java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.aiplatform.v1beta1.ModelMonitoringAnomaly.TabularAnomaly
        parseFrom(com.google.protobuf.ByteString data)
            throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.aiplatform.v1beta1.ModelMonitoringAnomaly.TabularAnomaly
        parseFrom(
            com.google.protobuf.ByteString data,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.aiplatform.v1beta1.ModelMonitoringAnomaly.TabularAnomaly
        parseFrom(byte[] data) throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.aiplatform.v1beta1.ModelMonitoringAnomaly.TabularAnomaly
        parseFrom(byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.aiplatform.v1beta1.ModelMonitoringAnomaly.TabularAnomaly
        parseFrom(java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.cloud.aiplatform.v1beta1.ModelMonitoringAnomaly.TabularAnomaly
        parseFrom(
            java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.cloud.aiplatform.v1beta1.ModelMonitoringAnomaly.TabularAnomaly
        parseDelimitedFrom(java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
    }

    public static com.google.cloud.aiplatform.v1beta1.ModelMonitoringAnomaly.TabularAnomaly
        parseDelimitedFrom(
            java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.cloud.aiplatform.v1beta1.ModelMonitoringAnomaly.TabularAnomaly
        parseFrom(com.google.protobuf.CodedInputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.cloud.aiplatform.v1beta1.ModelMonitoringAnomaly.TabularAnomaly
        parseFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    @java.lang.Override
    public Builder newBuilderForType() {
      return newBuilder();
    }

    public static Builder newBuilder() {
      return DEFAULT_INSTANCE.toBuilder();
    }

    public static Builder newBuilder(
        com.google.cloud.aiplatform.v1beta1.ModelMonitoringAnomaly.TabularAnomaly prototype) {
      return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }

    @java.lang.Override
    public Builder toBuilder() {
      return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
    }

    @java.lang.Override
    protected Builder newBuilderForType(
        com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      Builder builder = new Builder(parent);
      return builder;
    }
    /**
     *
     *
     * <pre>
     * Tabular anomaly details.
     * </pre>
     *
     * Protobuf type {@code google.cloud.aiplatform.v1beta1.ModelMonitoringAnomaly.TabularAnomaly}
     */
    public static final class Builder
        extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
        implements
        // @@protoc_insertion_point(builder_implements:google.cloud.aiplatform.v1beta1.ModelMonitoringAnomaly.TabularAnomaly)
        com.google.cloud.aiplatform.v1beta1.ModelMonitoringAnomaly.TabularAnomalyOrBuilder {
      public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
        return com.google.cloud.aiplatform.v1beta1.ModelMonitoringAlertProto
            .internal_static_google_cloud_aiplatform_v1beta1_ModelMonitoringAnomaly_TabularAnomaly_descriptor;
      }

      @java.lang.Override
      protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return com.google.cloud.aiplatform.v1beta1.ModelMonitoringAlertProto
            .internal_static_google_cloud_aiplatform_v1beta1_ModelMonitoringAnomaly_TabularAnomaly_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                com.google.cloud.aiplatform.v1beta1.ModelMonitoringAnomaly.TabularAnomaly.class,
                com.google.cloud.aiplatform.v1beta1.ModelMonitoringAnomaly.TabularAnomaly.Builder
                    .class);
      }

      // Construct using
      // com.google.cloud.aiplatform.v1beta1.ModelMonitoringAnomaly.TabularAnomaly.newBuilder()
      private Builder() {
        maybeForceBuilderInitialization();
      }

      private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
        super(parent);
        maybeForceBuilderInitialization();
      }

      private void maybeForceBuilderInitialization() {
        if (com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders) {
          getAnomalyFieldBuilder();
          getTriggerTimeFieldBuilder();
          getConditionFieldBuilder();
        }
      }

      @java.lang.Override
      public Builder clear() {
        super.clear();
        bitField0_ = 0;
        anomalyUri_ = "";
        summary_ = "";
        anomaly_ = null;
        if (anomalyBuilder_ != null) {
          anomalyBuilder_.dispose();
          anomalyBuilder_ = null;
        }
        triggerTime_ = null;
        if (triggerTimeBuilder_ != null) {
          triggerTimeBuilder_.dispose();
          triggerTimeBuilder_ = null;
        }
        condition_ = null;
        if (conditionBuilder_ != null) {
          conditionBuilder_.dispose();
          conditionBuilder_ = null;
        }
        return this;
      }

      @java.lang.Override
      public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
        return com.google.cloud.aiplatform.v1beta1.ModelMonitoringAlertProto
            .internal_static_google_cloud_aiplatform_v1beta1_ModelMonitoringAnomaly_TabularAnomaly_descriptor;
      }

      @java.lang.Override
      public com.google.cloud.aiplatform.v1beta1.ModelMonitoringAnomaly.TabularAnomaly
          getDefaultInstanceForType() {
        return com.google.cloud.aiplatform.v1beta1.ModelMonitoringAnomaly.TabularAnomaly
            .getDefaultInstance();
      }

      @java.lang.Override
      public com.google.cloud.aiplatform.v1beta1.ModelMonitoringAnomaly.TabularAnomaly build() {
        com.google.cloud.aiplatform.v1beta1.ModelMonitoringAnomaly.TabularAnomaly result =
            buildPartial();
        if (!result.isInitialized()) {
          throw newUninitializedMessageException(result);
        }
        return result;
      }

      @java.lang.Override
      public com.google.cloud.aiplatform.v1beta1.ModelMonitoringAnomaly.TabularAnomaly
          buildPartial() {
        com.google.cloud.aiplatform.v1beta1.ModelMonitoringAnomaly.TabularAnomaly result =
            new com.google.cloud.aiplatform.v1beta1.ModelMonitoringAnomaly.TabularAnomaly(this);
        if (bitField0_ != 0) {
          buildPartial0(result);
        }
        onBuilt();
        return result;
      }

      private void buildPartial0(
          com.google.cloud.aiplatform.v1beta1.ModelMonitoringAnomaly.TabularAnomaly result) {
        int from_bitField0_ = bitField0_;
        if (((from_bitField0_ & 0x00000001) != 0)) {
          result.anomalyUri_ = anomalyUri_;
        }
        if (((from_bitField0_ & 0x00000002) != 0)) {
          result.summary_ = summary_;
        }
        int to_bitField0_ = 0;
        if (((from_bitField0_ & 0x00000004) != 0)) {
          result.anomaly_ = anomalyBuilder_ == null ? anomaly_ : anomalyBuilder_.build();
          to_bitField0_ |= 0x00000001;
        }
        if (((from_bitField0_ & 0x00000008) != 0)) {
          result.triggerTime_ =
              triggerTimeBuilder_ == null ? triggerTime_ : triggerTimeBuilder_.build();
          to_bitField0_ |= 0x00000002;
        }
        if (((from_bitField0_ & 0x00000010) != 0)) {
          result.condition_ = conditionBuilder_ == null ? condition_ : conditionBuilder_.build();
          to_bitField0_ |= 0x00000004;
        }
        result.bitField0_ |= to_bitField0_;
      }

      @java.lang.Override
      public Builder clone() {
        return super.clone();
      }

      @java.lang.Override
      public Builder setField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.setField(field, value);
      }

      @java.lang.Override
      public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
        return super.clearField(field);
      }

      @java.lang.Override
      public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
        return super.clearOneof(oneof);
      }

      @java.lang.Override
      public Builder setRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          int index,
          java.lang.Object value) {
        return super.setRepeatedField(field, index, value);
      }

      @java.lang.Override
      public Builder addRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.addRepeatedField(field, value);
      }

      @java.lang.Override
      public Builder mergeFrom(com.google.protobuf.Message other) {
        if (other
            instanceof com.google.cloud.aiplatform.v1beta1.ModelMonitoringAnomaly.TabularAnomaly) {
          return mergeFrom(
              (com.google.cloud.aiplatform.v1beta1.ModelMonitoringAnomaly.TabularAnomaly) other);
        } else {
          super.mergeFrom(other);
          return this;
        }
      }

      public Builder mergeFrom(
          com.google.cloud.aiplatform.v1beta1.ModelMonitoringAnomaly.TabularAnomaly other) {
        if (other
            == com.google.cloud.aiplatform.v1beta1.ModelMonitoringAnomaly.TabularAnomaly
                .getDefaultInstance()) return this;
        if (!other.getAnomalyUri().isEmpty()) {
          anomalyUri_ = other.anomalyUri_;
          bitField0_ |= 0x00000001;
          onChanged();
        }
        if (!other.getSummary().isEmpty()) {
          summary_ = other.summary_;
          bitField0_ |= 0x00000002;
          onChanged();
        }
        if (other.hasAnomaly()) {
          mergeAnomaly(other.getAnomaly());
        }
        if (other.hasTriggerTime()) {
          mergeTriggerTime(other.getTriggerTime());
        }
        if (other.hasCondition()) {
          mergeCondition(other.getCondition());
        }
        this.mergeUnknownFields(other.getUnknownFields());
        onChanged();
        return this;
      }

      @java.lang.Override
      public final boolean isInitialized() {
        return true;
      }

      @java.lang.Override
      public Builder mergeFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        if (extensionRegistry == null) {
          throw new java.lang.NullPointerException();
        }
        try {
          boolean done = false;
          while (!done) {
            int tag = input.readTag();
            switch (tag) {
              case 0:
                done = true;
                break;
              case 10:
                {
                  anomalyUri_ = input.readStringRequireUtf8();
                  bitField0_ |= 0x00000001;
                  break;
                } // case 10
              case 18:
                {
                  summary_ = input.readStringRequireUtf8();
                  bitField0_ |= 0x00000002;
                  break;
                } // case 18
              case 26:
                {
                  input.readMessage(getAnomalyFieldBuilder().getBuilder(), extensionRegistry);
                  bitField0_ |= 0x00000004;
                  break;
                } // case 26
              case 34:
                {
                  input.readMessage(getTriggerTimeFieldBuilder().getBuilder(), extensionRegistry);
                  bitField0_ |= 0x00000008;
                  break;
                } // case 34
              case 42:
                {
                  input.readMessage(getConditionFieldBuilder().getBuilder(), extensionRegistry);
                  bitField0_ |= 0x00000010;
                  break;
                } // case 42
              default:
                {
                  if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                    done = true; // was an endgroup tag
                  }
                  break;
                } // default:
            } // switch (tag)
          } // while (!done)
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          throw e.unwrapIOException();
        } finally {
          onChanged();
        } // finally
        return this;
      }

      private int bitField0_;

      private java.lang.Object anomalyUri_ = "";
      /**
       *
       *
       * <pre>
       * Additional anomaly information. e.g. Google Cloud Storage uri.
       * </pre>
       *
       * <code>string anomaly_uri = 1;</code>
       *
       * @return The anomalyUri.
       */
      public java.lang.String getAnomalyUri() {
        java.lang.Object ref = anomalyUri_;
        if (!(ref instanceof java.lang.String)) {
          com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
          java.lang.String s = bs.toStringUtf8();
          anomalyUri_ = s;
          return s;
        } else {
          return (java.lang.String) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * Additional anomaly information. e.g. Google Cloud Storage uri.
       * </pre>
       *
       * <code>string anomaly_uri = 1;</code>
       *
       * @return The bytes for anomalyUri.
       */
      public com.google.protobuf.ByteString getAnomalyUriBytes() {
        java.lang.Object ref = anomalyUri_;
        if (ref instanceof String) {
          com.google.protobuf.ByteString b =
              com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
          anomalyUri_ = b;
          return b;
        } else {
          return (com.google.protobuf.ByteString) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * Additional anomaly information. e.g. Google Cloud Storage uri.
       * </pre>
       *
       * <code>string anomaly_uri = 1;</code>
       *
       * @param value The anomalyUri to set.
       * @return This builder for chaining.
       */
      public Builder setAnomalyUri(java.lang.String value) {
        if (value == null) {
          throw new NullPointerException();
        }
        anomalyUri_ = value;
        bitField0_ |= 0x00000001;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Additional anomaly information. e.g. Google Cloud Storage uri.
       * </pre>
       *
       * <code>string anomaly_uri = 1;</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearAnomalyUri() {
        anomalyUri_ = getDefaultInstance().getAnomalyUri();
        bitField0_ = (bitField0_ & ~0x00000001);
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Additional anomaly information. e.g. Google Cloud Storage uri.
       * </pre>
       *
       * <code>string anomaly_uri = 1;</code>
       *
       * @param value The bytes for anomalyUri to set.
       * @return This builder for chaining.
       */
      public Builder setAnomalyUriBytes(com.google.protobuf.ByteString value) {
        if (value == null) {
          throw new NullPointerException();
        }
        checkByteStringIsUtf8(value);
        anomalyUri_ = value;
        bitField0_ |= 0x00000001;
        onChanged();
        return this;
      }

      private java.lang.Object summary_ = "";
      /**
       *
       *
       * <pre>
       * Overview of this anomaly.
       * </pre>
       *
       * <code>string summary = 2;</code>
       *
       * @return The summary.
       */
      public java.lang.String getSummary() {
        java.lang.Object ref = summary_;
        if (!(ref instanceof java.lang.String)) {
          com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
          java.lang.String s = bs.toStringUtf8();
          summary_ = s;
          return s;
        } else {
          return (java.lang.String) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * Overview of this anomaly.
       * </pre>
       *
       * <code>string summary = 2;</code>
       *
       * @return The bytes for summary.
       */
      public com.google.protobuf.ByteString getSummaryBytes() {
        java.lang.Object ref = summary_;
        if (ref instanceof String) {
          com.google.protobuf.ByteString b =
              com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
          summary_ = b;
          return b;
        } else {
          return (com.google.protobuf.ByteString) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * Overview of this anomaly.
       * </pre>
       *
       * <code>string summary = 2;</code>
       *
       * @param value The summary to set.
       * @return This builder for chaining.
       */
      public Builder setSummary(java.lang.String value) {
        if (value == null) {
          throw new NullPointerException();
        }
        summary_ = value;
        bitField0_ |= 0x00000002;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Overview of this anomaly.
       * </pre>
       *
       * <code>string summary = 2;</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearSummary() {
        summary_ = getDefaultInstance().getSummary();
        bitField0_ = (bitField0_ & ~0x00000002);
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Overview of this anomaly.
       * </pre>
       *
       * <code>string summary = 2;</code>
       *
       * @param value The bytes for summary to set.
       * @return This builder for chaining.
       */
      public Builder setSummaryBytes(com.google.protobuf.ByteString value) {
        if (value == null) {
          throw new NullPointerException();
        }
        checkByteStringIsUtf8(value);
        summary_ = value;
        bitField0_ |= 0x00000002;
        onChanged();
        return this;
      }

      private com.google.protobuf.Value anomaly_;
      private com.google.protobuf.SingleFieldBuilderV3<
              com.google.protobuf.Value,
              com.google.protobuf.Value.Builder,
              com.google.protobuf.ValueOrBuilder>
          anomalyBuilder_;
      /**
       *
       *
       * <pre>
       * Anomaly body.
       * </pre>
       *
       * <code>.google.protobuf.Value anomaly = 3;</code>
       *
       * @return Whether the anomaly field is set.
       */
      public boolean hasAnomaly() {
        return ((bitField0_ & 0x00000004) != 0);
      }
      /**
       *
       *
       * <pre>
       * Anomaly body.
       * </pre>
       *
       * <code>.google.protobuf.Value anomaly = 3;</code>
       *
       * @return The anomaly.
       */
      public com.google.protobuf.Value getAnomaly() {
        if (anomalyBuilder_ == null) {
          return anomaly_ == null ? com.google.protobuf.Value.getDefaultInstance() : anomaly_;
        } else {
          return anomalyBuilder_.getMessage();
        }
      }
      /**
       *
       *
       * <pre>
       * Anomaly body.
       * </pre>
       *
       * <code>.google.protobuf.Value anomaly = 3;</code>
       */
      public Builder setAnomaly(com.google.protobuf.Value value) {
        if (anomalyBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          anomaly_ = value;
        } else {
          anomalyBuilder_.setMessage(value);
        }
        bitField0_ |= 0x00000004;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Anomaly body.
       * </pre>
       *
       * <code>.google.protobuf.Value anomaly = 3;</code>
       */
      public Builder setAnomaly(com.google.protobuf.Value.Builder builderForValue) {
        if (anomalyBuilder_ == null) {
          anomaly_ = builderForValue.build();
        } else {
          anomalyBuilder_.setMessage(builderForValue.build());
        }
        bitField0_ |= 0x00000004;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Anomaly body.
       * </pre>
       *
       * <code>.google.protobuf.Value anomaly = 3;</code>
       */
      public Builder mergeAnomaly(com.google.protobuf.Value value) {
        if (anomalyBuilder_ == null) {
          if (((bitField0_ & 0x00000004) != 0)
              && anomaly_ != null
              && anomaly_ != com.google.protobuf.Value.getDefaultInstance()) {
            getAnomalyBuilder().mergeFrom(value);
          } else {
            anomaly_ = value;
          }
        } else {
          anomalyBuilder_.mergeFrom(value);
        }
        if (anomaly_ != null) {
          bitField0_ |= 0x00000004;
          onChanged();
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * Anomaly body.
       * </pre>
       *
       * <code>.google.protobuf.Value anomaly = 3;</code>
       */
      public Builder clearAnomaly() {
        bitField0_ = (bitField0_ & ~0x00000004);
        anomaly_ = null;
        if (anomalyBuilder_ != null) {
          anomalyBuilder_.dispose();
          anomalyBuilder_ = null;
        }
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Anomaly body.
       * </pre>
       *
       * <code>.google.protobuf.Value anomaly = 3;</code>
       */
      public com.google.protobuf.Value.Builder getAnomalyBuilder() {
        bitField0_ |= 0x00000004;
        onChanged();
        return getAnomalyFieldBuilder().getBuilder();
      }
      /**
       *
       *
       * <pre>
       * Anomaly body.
       * </pre>
       *
       * <code>.google.protobuf.Value anomaly = 3;</code>
       */
      public com.google.protobuf.ValueOrBuilder getAnomalyOrBuilder() {
        if (anomalyBuilder_ != null) {
          return anomalyBuilder_.getMessageOrBuilder();
        } else {
          return anomaly_ == null ? com.google.protobuf.Value.getDefaultInstance() : anomaly_;
        }
      }
      /**
       *
       *
       * <pre>
       * Anomaly body.
       * </pre>
       *
       * <code>.google.protobuf.Value anomaly = 3;</code>
       */
      private com.google.protobuf.SingleFieldBuilderV3<
              com.google.protobuf.Value,
              com.google.protobuf.Value.Builder,
              com.google.protobuf.ValueOrBuilder>
          getAnomalyFieldBuilder() {
        if (anomalyBuilder_ == null) {
          anomalyBuilder_ =
              new com.google.protobuf.SingleFieldBuilderV3<
                  com.google.protobuf.Value,
                  com.google.protobuf.Value.Builder,
                  com.google.protobuf.ValueOrBuilder>(
                  getAnomaly(), getParentForChildren(), isClean());
          anomaly_ = null;
        }
        return anomalyBuilder_;
      }

      private com.google.protobuf.Timestamp triggerTime_;
      private com.google.protobuf.SingleFieldBuilderV3<
              com.google.protobuf.Timestamp,
              com.google.protobuf.Timestamp.Builder,
              com.google.protobuf.TimestampOrBuilder>
          triggerTimeBuilder_;
      /**
       *
       *
       * <pre>
       * The time the anomaly was triggered.
       * </pre>
       *
       * <code>.google.protobuf.Timestamp trigger_time = 4;</code>
       *
       * @return Whether the triggerTime field is set.
       */
      public boolean hasTriggerTime() {
        return ((bitField0_ & 0x00000008) != 0);
      }
      /**
       *
       *
       * <pre>
       * The time the anomaly was triggered.
       * </pre>
       *
       * <code>.google.protobuf.Timestamp trigger_time = 4;</code>
       *
       * @return The triggerTime.
       */
      public com.google.protobuf.Timestamp getTriggerTime() {
        if (triggerTimeBuilder_ == null) {
          return triggerTime_ == null
              ? com.google.protobuf.Timestamp.getDefaultInstance()
              : triggerTime_;
        } else {
          return triggerTimeBuilder_.getMessage();
        }
      }
      /**
       *
       *
       * <pre>
       * The time the anomaly was triggered.
       * </pre>
       *
       * <code>.google.protobuf.Timestamp trigger_time = 4;</code>
       */
      public Builder setTriggerTime(com.google.protobuf.Timestamp value) {
        if (triggerTimeBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          triggerTime_ = value;
        } else {
          triggerTimeBuilder_.setMessage(value);
        }
        bitField0_ |= 0x00000008;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * The time the anomaly was triggered.
       * </pre>
       *
       * <code>.google.protobuf.Timestamp trigger_time = 4;</code>
       */
      public Builder setTriggerTime(com.google.protobuf.Timestamp.Builder builderForValue) {
        if (triggerTimeBuilder_ == null) {
          triggerTime_ = builderForValue.build();
        } else {
          triggerTimeBuilder_.setMessage(builderForValue.build());
        }
        bitField0_ |= 0x00000008;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * The time the anomaly was triggered.
       * </pre>
       *
       * <code>.google.protobuf.Timestamp trigger_time = 4;</code>
       */
      public Builder mergeTriggerTime(com.google.protobuf.Timestamp value) {
        if (triggerTimeBuilder_ == null) {
          if (((bitField0_ & 0x00000008) != 0)
              && triggerTime_ != null
              && triggerTime_ != com.google.protobuf.Timestamp.getDefaultInstance()) {
            getTriggerTimeBuilder().mergeFrom(value);
          } else {
            triggerTime_ = value;
          }
        } else {
          triggerTimeBuilder_.mergeFrom(value);
        }
        if (triggerTime_ != null) {
          bitField0_ |= 0x00000008;
          onChanged();
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * The time the anomaly was triggered.
       * </pre>
       *
       * <code>.google.protobuf.Timestamp trigger_time = 4;</code>
       */
      public Builder clearTriggerTime() {
        bitField0_ = (bitField0_ & ~0x00000008);
        triggerTime_ = null;
        if (triggerTimeBuilder_ != null) {
          triggerTimeBuilder_.dispose();
          triggerTimeBuilder_ = null;
        }
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * The time the anomaly was triggered.
       * </pre>
       *
       * <code>.google.protobuf.Timestamp trigger_time = 4;</code>
       */
      public com.google.protobuf.Timestamp.Builder getTriggerTimeBuilder() {
        bitField0_ |= 0x00000008;
        onChanged();
        return getTriggerTimeFieldBuilder().getBuilder();
      }
      /**
       *
       *
       * <pre>
       * The time the anomaly was triggered.
       * </pre>
       *
       * <code>.google.protobuf.Timestamp trigger_time = 4;</code>
       */
      public com.google.protobuf.TimestampOrBuilder getTriggerTimeOrBuilder() {
        if (triggerTimeBuilder_ != null) {
          return triggerTimeBuilder_.getMessageOrBuilder();
        } else {
          return triggerTime_ == null
              ? com.google.protobuf.Timestamp.getDefaultInstance()
              : triggerTime_;
        }
      }
      /**
       *
       *
       * <pre>
       * The time the anomaly was triggered.
       * </pre>
       *
       * <code>.google.protobuf.Timestamp trigger_time = 4;</code>
       */
      private com.google.protobuf.SingleFieldBuilderV3<
              com.google.protobuf.Timestamp,
              com.google.protobuf.Timestamp.Builder,
              com.google.protobuf.TimestampOrBuilder>
          getTriggerTimeFieldBuilder() {
        if (triggerTimeBuilder_ == null) {
          triggerTimeBuilder_ =
              new com.google.protobuf.SingleFieldBuilderV3<
                  com.google.protobuf.Timestamp,
                  com.google.protobuf.Timestamp.Builder,
                  com.google.protobuf.TimestampOrBuilder>(
                  getTriggerTime(), getParentForChildren(), isClean());
          triggerTime_ = null;
        }
        return triggerTimeBuilder_;
      }

      private com.google.cloud.aiplatform.v1beta1.ModelMonitoringAlertCondition condition_;
      private com.google.protobuf.SingleFieldBuilderV3<
              com.google.cloud.aiplatform.v1beta1.ModelMonitoringAlertCondition,
              com.google.cloud.aiplatform.v1beta1.ModelMonitoringAlertCondition.Builder,
              com.google.cloud.aiplatform.v1beta1.ModelMonitoringAlertConditionOrBuilder>
          conditionBuilder_;
      /**
       *
       *
       * <pre>
       * The alert condition associated with this anomaly.
       * </pre>
       *
       * <code>.google.cloud.aiplatform.v1beta1.ModelMonitoringAlertCondition condition = 5;</code>
       *
       * @return Whether the condition field is set.
       */
      public boolean hasCondition() {
        return ((bitField0_ & 0x00000010) != 0);
      }
      /**
       *
       *
       * <pre>
       * The alert condition associated with this anomaly.
       * </pre>
       *
       * <code>.google.cloud.aiplatform.v1beta1.ModelMonitoringAlertCondition condition = 5;</code>
       *
       * @return The condition.
       */
      public com.google.cloud.aiplatform.v1beta1.ModelMonitoringAlertCondition getCondition() {
        if (conditionBuilder_ == null) {
          return condition_ == null
              ? com.google.cloud.aiplatform.v1beta1.ModelMonitoringAlertCondition
                  .getDefaultInstance()
              : condition_;
        } else {
          return conditionBuilder_.getMessage();
        }
      }
      /**
       *
       *
       * <pre>
       * The alert condition associated with this anomaly.
       * </pre>
       *
       * <code>.google.cloud.aiplatform.v1beta1.ModelMonitoringAlertCondition condition = 5;</code>
       */
      public Builder setCondition(
          com.google.cloud.aiplatform.v1beta1.ModelMonitoringAlertCondition value) {
        if (conditionBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          condition_ = value;
        } else {
          conditionBuilder_.setMessage(value);
        }
        bitField0_ |= 0x00000010;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * The alert condition associated with this anomaly.
       * </pre>
       *
       * <code>.google.cloud.aiplatform.v1beta1.ModelMonitoringAlertCondition condition = 5;</code>
       */
      public Builder setCondition(
          com.google.cloud.aiplatform.v1beta1.ModelMonitoringAlertCondition.Builder
              builderForValue) {
        if (conditionBuilder_ == null) {
          condition_ = builderForValue.build();
        } else {
          conditionBuilder_.setMessage(builderForValue.build());
        }
        bitField0_ |= 0x00000010;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * The alert condition associated with this anomaly.
       * </pre>
       *
       * <code>.google.cloud.aiplatform.v1beta1.ModelMonitoringAlertCondition condition = 5;</code>
       */
      public Builder mergeCondition(
          com.google.cloud.aiplatform.v1beta1.ModelMonitoringAlertCondition value) {
        if (conditionBuilder_ == null) {
          if (((bitField0_ & 0x00000010) != 0)
              && condition_ != null
              && condition_
                  != com.google.cloud.aiplatform.v1beta1.ModelMonitoringAlertCondition
                      .getDefaultInstance()) {
            getConditionBuilder().mergeFrom(value);
          } else {
            condition_ = value;
          }
        } else {
          conditionBuilder_.mergeFrom(value);
        }
        if (condition_ != null) {
          bitField0_ |= 0x00000010;
          onChanged();
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * The alert condition associated with this anomaly.
       * </pre>
       *
       * <code>.google.cloud.aiplatform.v1beta1.ModelMonitoringAlertCondition condition = 5;</code>
       */
      public Builder clearCondition() {
        bitField0_ = (bitField0_ & ~0x00000010);
        condition_ = null;
        if (conditionBuilder_ != null) {
          conditionBuilder_.dispose();
          conditionBuilder_ = null;
        }
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * The alert condition associated with this anomaly.
       * </pre>
       *
       * <code>.google.cloud.aiplatform.v1beta1.ModelMonitoringAlertCondition condition = 5;</code>
       */
      public com.google.cloud.aiplatform.v1beta1.ModelMonitoringAlertCondition.Builder
          getConditionBuilder() {
        bitField0_ |= 0x00000010;
        onChanged();
        return getConditionFieldBuilder().getBuilder();
      }
      /**
       *
       *
       * <pre>
       * The alert condition associated with this anomaly.
       * </pre>
       *
       * <code>.google.cloud.aiplatform.v1beta1.ModelMonitoringAlertCondition condition = 5;</code>
       */
      public com.google.cloud.aiplatform.v1beta1.ModelMonitoringAlertConditionOrBuilder
          getConditionOrBuilder() {
        if (conditionBuilder_ != null) {
          return conditionBuilder_.getMessageOrBuilder();
        } else {
          return condition_ == null
              ? com.google.cloud.aiplatform.v1beta1.ModelMonitoringAlertCondition
                  .getDefaultInstance()
              : condition_;
        }
      }
      /**
       *
       *
       * <pre>
       * The alert condition associated with this anomaly.
       * </pre>
       *
       * <code>.google.cloud.aiplatform.v1beta1.ModelMonitoringAlertCondition condition = 5;</code>
       */
      private com.google.protobuf.SingleFieldBuilderV3<
              com.google.cloud.aiplatform.v1beta1.ModelMonitoringAlertCondition,
              com.google.cloud.aiplatform.v1beta1.ModelMonitoringAlertCondition.Builder,
              com.google.cloud.aiplatform.v1beta1.ModelMonitoringAlertConditionOrBuilder>
          getConditionFieldBuilder() {
        if (conditionBuilder_ == null) {
          conditionBuilder_ =
              new com.google.protobuf.SingleFieldBuilderV3<
                  com.google.cloud.aiplatform.v1beta1.ModelMonitoringAlertCondition,
                  com.google.cloud.aiplatform.v1beta1.ModelMonitoringAlertCondition.Builder,
                  com.google.cloud.aiplatform.v1beta1.ModelMonitoringAlertConditionOrBuilder>(
                  getCondition(), getParentForChildren(), isClean());
          condition_ = null;
        }
        return conditionBuilder_;
      }

      @java.lang.Override
      public final Builder setUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.setUnknownFields(unknownFields);
      }

      @java.lang.Override
      public final Builder mergeUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.mergeUnknownFields(unknownFields);
      }

      // @@protoc_insertion_point(builder_scope:google.cloud.aiplatform.v1beta1.ModelMonitoringAnomaly.TabularAnomaly)
    }

    // @@protoc_insertion_point(class_scope:google.cloud.aiplatform.v1beta1.ModelMonitoringAnomaly.TabularAnomaly)
    private static final com.google.cloud.aiplatform.v1beta1.ModelMonitoringAnomaly.TabularAnomaly
        DEFAULT_INSTANCE;

    static {
      DEFAULT_INSTANCE =
          new com.google.cloud.aiplatform.v1beta1.ModelMonitoringAnomaly.TabularAnomaly();
    }

    public static com.google.cloud.aiplatform.v1beta1.ModelMonitoringAnomaly.TabularAnomaly
        getDefaultInstance() {
      return DEFAULT_INSTANCE;
    }

    private static final com.google.protobuf.Parser<TabularAnomaly> PARSER =
        new com.google.protobuf.AbstractParser<TabularAnomaly>() {
          @java.lang.Override
          public TabularAnomaly parsePartialFrom(
              com.google.protobuf.CodedInputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
            Builder builder = newBuilder();
            try {
              builder.mergeFrom(input, extensionRegistry);
            } catch (com.google.protobuf.InvalidProtocolBufferException e) {
              throw e.setUnfinishedMessage(builder.buildPartial());
            } catch (com.google.protobuf.UninitializedMessageException e) {
              throw e.asInvalidProtocolBufferException()
                  .setUnfinishedMessage(builder.buildPartial());
            } catch (java.io.IOException e) {
              throw new com.google.protobuf.InvalidProtocolBufferException(e)
                  .setUnfinishedMessage(builder.buildPartial());
            }
            return builder.buildPartial();
          }
        };

    public static com.google.protobuf.Parser<TabularAnomaly> parser() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.protobuf.Parser<TabularAnomaly> getParserForType() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.cloud.aiplatform.v1beta1.ModelMonitoringAnomaly.TabularAnomaly
        getDefaultInstanceForType() {
      return DEFAULT_INSTANCE;
    }
  }

  private int anomalyCase_ = 0;

  @SuppressWarnings("serial")
  private java.lang.Object anomaly_;

  public enum AnomalyCase
      implements
          com.google.protobuf.Internal.EnumLite,
          com.google.protobuf.AbstractMessage.InternalOneOfEnum {
    TABULAR_ANOMALY(1),
    ANOMALY_NOT_SET(0);
    private final int value;

    private AnomalyCase(int value) {
      this.value = value;
    }
    /**
     * @param value The number of the enum to look for.
     * @return The enum associated with the given number.
     * @deprecated Use {@link #forNumber(int)} instead.
     */
    @java.lang.Deprecated
    public static AnomalyCase valueOf(int value) {
      return forNumber(value);
    }

    public static AnomalyCase forNumber(int value) {
      switch (value) {
        case 1:
          return TABULAR_ANOMALY;
        case 0:
          return ANOMALY_NOT_SET;
        default:
          return null;
      }
    }

    public int getNumber() {
      return this.value;
    }
  };

  public AnomalyCase getAnomalyCase() {
    return AnomalyCase.forNumber(anomalyCase_);
  }

  public static final int TABULAR_ANOMALY_FIELD_NUMBER = 1;
  /**
   *
   *
   * <pre>
   * Tabular anomaly.
   * </pre>
   *
   * <code>
   * .google.cloud.aiplatform.v1beta1.ModelMonitoringAnomaly.TabularAnomaly tabular_anomaly = 1;
   * </code>
   *
   * @return Whether the tabularAnomaly field is set.
   */
  @java.lang.Override
  public boolean hasTabularAnomaly() {
    return anomalyCase_ == 1;
  }
  /**
   *
   *
   * <pre>
   * Tabular anomaly.
   * </pre>
   *
   * <code>
   * .google.cloud.aiplatform.v1beta1.ModelMonitoringAnomaly.TabularAnomaly tabular_anomaly = 1;
   * </code>
   *
   * @return The tabularAnomaly.
   */
  @java.lang.Override
  public com.google.cloud.aiplatform.v1beta1.ModelMonitoringAnomaly.TabularAnomaly
      getTabularAnomaly() {
    if (anomalyCase_ == 1) {
      return (com.google.cloud.aiplatform.v1beta1.ModelMonitoringAnomaly.TabularAnomaly) anomaly_;
    }
    return com.google.cloud.aiplatform.v1beta1.ModelMonitoringAnomaly.TabularAnomaly
        .getDefaultInstance();
  }
  /**
   *
   *
   * <pre>
   * Tabular anomaly.
   * </pre>
   *
   * <code>
   * .google.cloud.aiplatform.v1beta1.ModelMonitoringAnomaly.TabularAnomaly tabular_anomaly = 1;
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.aiplatform.v1beta1.ModelMonitoringAnomaly.TabularAnomalyOrBuilder
      getTabularAnomalyOrBuilder() {
    if (anomalyCase_ == 1) {
      return (com.google.cloud.aiplatform.v1beta1.ModelMonitoringAnomaly.TabularAnomaly) anomaly_;
    }
    return com.google.cloud.aiplatform.v1beta1.ModelMonitoringAnomaly.TabularAnomaly
        .getDefaultInstance();
  }

  public static final int MODEL_MONITORING_JOB_FIELD_NUMBER = 2;

  @SuppressWarnings("serial")
  private volatile java.lang.Object modelMonitoringJob_ = "";
  /**
   *
   *
   * <pre>
   * Model monitoring job resource name.
   * </pre>
   *
   * <code>string model_monitoring_job = 2;</code>
   *
   * @return The modelMonitoringJob.
   */
  @java.lang.Override
  public java.lang.String getModelMonitoringJob() {
    java.lang.Object ref = modelMonitoringJob_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      modelMonitoringJob_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Model monitoring job resource name.
   * </pre>
   *
   * <code>string model_monitoring_job = 2;</code>
   *
   * @return The bytes for modelMonitoringJob.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getModelMonitoringJobBytes() {
    java.lang.Object ref = modelMonitoringJob_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      modelMonitoringJob_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int ALGORITHM_FIELD_NUMBER = 3;

  @SuppressWarnings("serial")
  private volatile java.lang.Object algorithm_ = "";
  /**
   *
   *
   * <pre>
   * Algorithm used to calculated the metrics, eg: jensen_shannon_divergence,
   * l_infinity.
   * </pre>
   *
   * <code>string algorithm = 3;</code>
   *
   * @return The algorithm.
   */
  @java.lang.Override
  public java.lang.String getAlgorithm() {
    java.lang.Object ref = algorithm_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      algorithm_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Algorithm used to calculated the metrics, eg: jensen_shannon_divergence,
   * l_infinity.
   * </pre>
   *
   * <code>string algorithm = 3;</code>
   *
   * @return The bytes for algorithm.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getAlgorithmBytes() {
    java.lang.Object ref = algorithm_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      algorithm_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    if (anomalyCase_ == 1) {
      output.writeMessage(
          1, (com.google.cloud.aiplatform.v1beta1.ModelMonitoringAnomaly.TabularAnomaly) anomaly_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(modelMonitoringJob_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 2, modelMonitoringJob_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(algorithm_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 3, algorithm_);
    }
    getUnknownFields().writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    if (anomalyCase_ == 1) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(
              1,
              (com.google.cloud.aiplatform.v1beta1.ModelMonitoringAnomaly.TabularAnomaly) anomaly_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(modelMonitoringJob_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(2, modelMonitoringJob_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(algorithm_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(3, algorithm_);
    }
    size += getUnknownFields().getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.cloud.aiplatform.v1beta1.ModelMonitoringAnomaly)) {
      return super.equals(obj);
    }
    com.google.cloud.aiplatform.v1beta1.ModelMonitoringAnomaly other =
        (com.google.cloud.aiplatform.v1beta1.ModelMonitoringAnomaly) obj;

    if (!getModelMonitoringJob().equals(other.getModelMonitoringJob())) return false;
    if (!getAlgorithm().equals(other.getAlgorithm())) return false;
    if (!getAnomalyCase().equals(other.getAnomalyCase())) return false;
    switch (anomalyCase_) {
      case 1:
        if (!getTabularAnomaly().equals(other.getTabularAnomaly())) return false;
        break;
      case 0:
      default:
    }
    if (!getUnknownFields().equals(other.getUnknownFields())) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    hash = (37 * hash) + MODEL_MONITORING_JOB_FIELD_NUMBER;
    hash = (53 * hash) + getModelMonitoringJob().hashCode();
    hash = (37 * hash) + ALGORITHM_FIELD_NUMBER;
    hash = (53 * hash) + getAlgorithm().hashCode();
    switch (anomalyCase_) {
      case 1:
        hash = (37 * hash) + TABULAR_ANOMALY_FIELD_NUMBER;
        hash = (53 * hash) + getTabularAnomaly().hashCode();
        break;
      case 0:
      default:
    }
    hash = (29 * hash) + getUnknownFields().hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.cloud.aiplatform.v1beta1.ModelMonitoringAnomaly parseFrom(
      java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.aiplatform.v1beta1.ModelMonitoringAnomaly parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.aiplatform.v1beta1.ModelMonitoringAnomaly parseFrom(
      com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.aiplatform.v1beta1.ModelMonitoringAnomaly parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.aiplatform.v1beta1.ModelMonitoringAnomaly parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.aiplatform.v1beta1.ModelMonitoringAnomaly parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.aiplatform.v1beta1.ModelMonitoringAnomaly parseFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.aiplatform.v1beta1.ModelMonitoringAnomaly parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.aiplatform.v1beta1.ModelMonitoringAnomaly parseDelimitedFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.cloud.aiplatform.v1beta1.ModelMonitoringAnomaly parseDelimitedFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.aiplatform.v1beta1.ModelMonitoringAnomaly parseFrom(
      com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.aiplatform.v1beta1.ModelMonitoringAnomaly parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(
      com.google.cloud.aiplatform.v1beta1.ModelMonitoringAnomaly prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }
  /**
   *
   *
   * <pre>
   * Represents a single model monitoring anomaly.
   * </pre>
   *
   * Protobuf type {@code google.cloud.aiplatform.v1beta1.ModelMonitoringAnomaly}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.cloud.aiplatform.v1beta1.ModelMonitoringAnomaly)
      com.google.cloud.aiplatform.v1beta1.ModelMonitoringAnomalyOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.aiplatform.v1beta1.ModelMonitoringAlertProto
          .internal_static_google_cloud_aiplatform_v1beta1_ModelMonitoringAnomaly_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.aiplatform.v1beta1.ModelMonitoringAlertProto
          .internal_static_google_cloud_aiplatform_v1beta1_ModelMonitoringAnomaly_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.aiplatform.v1beta1.ModelMonitoringAnomaly.class,
              com.google.cloud.aiplatform.v1beta1.ModelMonitoringAnomaly.Builder.class);
    }

    // Construct using com.google.cloud.aiplatform.v1beta1.ModelMonitoringAnomaly.newBuilder()
    private Builder() {}

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      bitField0_ = 0;
      if (tabularAnomalyBuilder_ != null) {
        tabularAnomalyBuilder_.clear();
      }
      modelMonitoringJob_ = "";
      algorithm_ = "";
      anomalyCase_ = 0;
      anomaly_ = null;
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.cloud.aiplatform.v1beta1.ModelMonitoringAlertProto
          .internal_static_google_cloud_aiplatform_v1beta1_ModelMonitoringAnomaly_descriptor;
    }

    @java.lang.Override
    public com.google.cloud.aiplatform.v1beta1.ModelMonitoringAnomaly getDefaultInstanceForType() {
      return com.google.cloud.aiplatform.v1beta1.ModelMonitoringAnomaly.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.cloud.aiplatform.v1beta1.ModelMonitoringAnomaly build() {
      com.google.cloud.aiplatform.v1beta1.ModelMonitoringAnomaly result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.cloud.aiplatform.v1beta1.ModelMonitoringAnomaly buildPartial() {
      com.google.cloud.aiplatform.v1beta1.ModelMonitoringAnomaly result =
          new com.google.cloud.aiplatform.v1beta1.ModelMonitoringAnomaly(this);
      if (bitField0_ != 0) {
        buildPartial0(result);
      }
      buildPartialOneofs(result);
      onBuilt();
      return result;
    }

    private void buildPartial0(com.google.cloud.aiplatform.v1beta1.ModelMonitoringAnomaly result) {
      int from_bitField0_ = bitField0_;
      if (((from_bitField0_ & 0x00000002) != 0)) {
        result.modelMonitoringJob_ = modelMonitoringJob_;
      }
      if (((from_bitField0_ & 0x00000004) != 0)) {
        result.algorithm_ = algorithm_;
      }
    }

    private void buildPartialOneofs(
        com.google.cloud.aiplatform.v1beta1.ModelMonitoringAnomaly result) {
      result.anomalyCase_ = anomalyCase_;
      result.anomaly_ = this.anomaly_;
      if (anomalyCase_ == 1 && tabularAnomalyBuilder_ != null) {
        result.anomaly_ = tabularAnomalyBuilder_.build();
      }
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.cloud.aiplatform.v1beta1.ModelMonitoringAnomaly) {
        return mergeFrom((com.google.cloud.aiplatform.v1beta1.ModelMonitoringAnomaly) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(com.google.cloud.aiplatform.v1beta1.ModelMonitoringAnomaly other) {
      if (other == com.google.cloud.aiplatform.v1beta1.ModelMonitoringAnomaly.getDefaultInstance())
        return this;
      if (!other.getModelMonitoringJob().isEmpty()) {
        modelMonitoringJob_ = other.modelMonitoringJob_;
        bitField0_ |= 0x00000002;
        onChanged();
      }
      if (!other.getAlgorithm().isEmpty()) {
        algorithm_ = other.algorithm_;
        bitField0_ |= 0x00000004;
        onChanged();
      }
      switch (other.getAnomalyCase()) {
        case TABULAR_ANOMALY:
          {
            mergeTabularAnomaly(other.getTabularAnomaly());
            break;
          }
        case ANOMALY_NOT_SET:
          {
            break;
          }
      }
      this.mergeUnknownFields(other.getUnknownFields());
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 10:
              {
                input.readMessage(getTabularAnomalyFieldBuilder().getBuilder(), extensionRegistry);
                anomalyCase_ = 1;
                break;
              } // case 10
            case 18:
              {
                modelMonitoringJob_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000002;
                break;
              } // case 18
            case 26:
              {
                algorithm_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000004;
                break;
              } // case 26
            default:
              {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
          } // switch (tag)
        } // while (!done)
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.unwrapIOException();
      } finally {
        onChanged();
      } // finally
      return this;
    }

    private int anomalyCase_ = 0;
    private java.lang.Object anomaly_;

    public AnomalyCase getAnomalyCase() {
      return AnomalyCase.forNumber(anomalyCase_);
    }

    public Builder clearAnomaly() {
      anomalyCase_ = 0;
      anomaly_ = null;
      onChanged();
      return this;
    }

    private int bitField0_;

    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.aiplatform.v1beta1.ModelMonitoringAnomaly.TabularAnomaly,
            com.google.cloud.aiplatform.v1beta1.ModelMonitoringAnomaly.TabularAnomaly.Builder,
            com.google.cloud.aiplatform.v1beta1.ModelMonitoringAnomaly.TabularAnomalyOrBuilder>
        tabularAnomalyBuilder_;
    /**
     *
     *
     * <pre>
     * Tabular anomaly.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.ModelMonitoringAnomaly.TabularAnomaly tabular_anomaly = 1;
     * </code>
     *
     * @return Whether the tabularAnomaly field is set.
     */
    @java.lang.Override
    public boolean hasTabularAnomaly() {
      return anomalyCase_ == 1;
    }
    /**
     *
     *
     * <pre>
     * Tabular anomaly.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.ModelMonitoringAnomaly.TabularAnomaly tabular_anomaly = 1;
     * </code>
     *
     * @return The tabularAnomaly.
     */
    @java.lang.Override
    public com.google.cloud.aiplatform.v1beta1.ModelMonitoringAnomaly.TabularAnomaly
        getTabularAnomaly() {
      if (tabularAnomalyBuilder_ == null) {
        if (anomalyCase_ == 1) {
          return (com.google.cloud.aiplatform.v1beta1.ModelMonitoringAnomaly.TabularAnomaly)
              anomaly_;
        }
        return com.google.cloud.aiplatform.v1beta1.ModelMonitoringAnomaly.TabularAnomaly
            .getDefaultInstance();
      } else {
        if (anomalyCase_ == 1) {
          return tabularAnomalyBuilder_.getMessage();
        }
        return com.google.cloud.aiplatform.v1beta1.ModelMonitoringAnomaly.TabularAnomaly
            .getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * Tabular anomaly.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.ModelMonitoringAnomaly.TabularAnomaly tabular_anomaly = 1;
     * </code>
     */
    public Builder setTabularAnomaly(
        com.google.cloud.aiplatform.v1beta1.ModelMonitoringAnomaly.TabularAnomaly value) {
      if (tabularAnomalyBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        anomaly_ = value;
        onChanged();
      } else {
        tabularAnomalyBuilder_.setMessage(value);
      }
      anomalyCase_ = 1;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Tabular anomaly.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.ModelMonitoringAnomaly.TabularAnomaly tabular_anomaly = 1;
     * </code>
     */
    public Builder setTabularAnomaly(
        com.google.cloud.aiplatform.v1beta1.ModelMonitoringAnomaly.TabularAnomaly.Builder
            builderForValue) {
      if (tabularAnomalyBuilder_ == null) {
        anomaly_ = builderForValue.build();
        onChanged();
      } else {
        tabularAnomalyBuilder_.setMessage(builderForValue.build());
      }
      anomalyCase_ = 1;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Tabular anomaly.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.ModelMonitoringAnomaly.TabularAnomaly tabular_anomaly = 1;
     * </code>
     */
    public Builder mergeTabularAnomaly(
        com.google.cloud.aiplatform.v1beta1.ModelMonitoringAnomaly.TabularAnomaly value) {
      if (tabularAnomalyBuilder_ == null) {
        if (anomalyCase_ == 1
            && anomaly_
                != com.google.cloud.aiplatform.v1beta1.ModelMonitoringAnomaly.TabularAnomaly
                    .getDefaultInstance()) {
          anomaly_ =
              com.google.cloud.aiplatform.v1beta1.ModelMonitoringAnomaly.TabularAnomaly.newBuilder(
                      (com.google.cloud.aiplatform.v1beta1.ModelMonitoringAnomaly.TabularAnomaly)
                          anomaly_)
                  .mergeFrom(value)
                  .buildPartial();
        } else {
          anomaly_ = value;
        }
        onChanged();
      } else {
        if (anomalyCase_ == 1) {
          tabularAnomalyBuilder_.mergeFrom(value);
        } else {
          tabularAnomalyBuilder_.setMessage(value);
        }
      }
      anomalyCase_ = 1;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Tabular anomaly.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.ModelMonitoringAnomaly.TabularAnomaly tabular_anomaly = 1;
     * </code>
     */
    public Builder clearTabularAnomaly() {
      if (tabularAnomalyBuilder_ == null) {
        if (anomalyCase_ == 1) {
          anomalyCase_ = 0;
          anomaly_ = null;
          onChanged();
        }
      } else {
        if (anomalyCase_ == 1) {
          anomalyCase_ = 0;
          anomaly_ = null;
        }
        tabularAnomalyBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Tabular anomaly.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.ModelMonitoringAnomaly.TabularAnomaly tabular_anomaly = 1;
     * </code>
     */
    public com.google.cloud.aiplatform.v1beta1.ModelMonitoringAnomaly.TabularAnomaly.Builder
        getTabularAnomalyBuilder() {
      return getTabularAnomalyFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Tabular anomaly.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.ModelMonitoringAnomaly.TabularAnomaly tabular_anomaly = 1;
     * </code>
     */
    @java.lang.Override
    public com.google.cloud.aiplatform.v1beta1.ModelMonitoringAnomaly.TabularAnomalyOrBuilder
        getTabularAnomalyOrBuilder() {
      if ((anomalyCase_ == 1) && (tabularAnomalyBuilder_ != null)) {
        return tabularAnomalyBuilder_.getMessageOrBuilder();
      } else {
        if (anomalyCase_ == 1) {
          return (com.google.cloud.aiplatform.v1beta1.ModelMonitoringAnomaly.TabularAnomaly)
              anomaly_;
        }
        return com.google.cloud.aiplatform.v1beta1.ModelMonitoringAnomaly.TabularAnomaly
            .getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * Tabular anomaly.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.ModelMonitoringAnomaly.TabularAnomaly tabular_anomaly = 1;
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.aiplatform.v1beta1.ModelMonitoringAnomaly.TabularAnomaly,
            com.google.cloud.aiplatform.v1beta1.ModelMonitoringAnomaly.TabularAnomaly.Builder,
            com.google.cloud.aiplatform.v1beta1.ModelMonitoringAnomaly.TabularAnomalyOrBuilder>
        getTabularAnomalyFieldBuilder() {
      if (tabularAnomalyBuilder_ == null) {
        if (!(anomalyCase_ == 1)) {
          anomaly_ =
              com.google.cloud.aiplatform.v1beta1.ModelMonitoringAnomaly.TabularAnomaly
                  .getDefaultInstance();
        }
        tabularAnomalyBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.aiplatform.v1beta1.ModelMonitoringAnomaly.TabularAnomaly,
                com.google.cloud.aiplatform.v1beta1.ModelMonitoringAnomaly.TabularAnomaly.Builder,
                com.google.cloud.aiplatform.v1beta1.ModelMonitoringAnomaly.TabularAnomalyOrBuilder>(
                (com.google.cloud.aiplatform.v1beta1.ModelMonitoringAnomaly.TabularAnomaly)
                    anomaly_,
                getParentForChildren(),
                isClean());
        anomaly_ = null;
      }
      anomalyCase_ = 1;
      onChanged();
      return tabularAnomalyBuilder_;
    }

    private java.lang.Object modelMonitoringJob_ = "";
    /**
     *
     *
     * <pre>
     * Model monitoring job resource name.
     * </pre>
     *
     * <code>string model_monitoring_job = 2;</code>
     *
     * @return The modelMonitoringJob.
     */
    public java.lang.String getModelMonitoringJob() {
      java.lang.Object ref = modelMonitoringJob_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        modelMonitoringJob_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Model monitoring job resource name.
     * </pre>
     *
     * <code>string model_monitoring_job = 2;</code>
     *
     * @return The bytes for modelMonitoringJob.
     */
    public com.google.protobuf.ByteString getModelMonitoringJobBytes() {
      java.lang.Object ref = modelMonitoringJob_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        modelMonitoringJob_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Model monitoring job resource name.
     * </pre>
     *
     * <code>string model_monitoring_job = 2;</code>
     *
     * @param value The modelMonitoringJob to set.
     * @return This builder for chaining.
     */
    public Builder setModelMonitoringJob(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      modelMonitoringJob_ = value;
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Model monitoring job resource name.
     * </pre>
     *
     * <code>string model_monitoring_job = 2;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearModelMonitoringJob() {
      modelMonitoringJob_ = getDefaultInstance().getModelMonitoringJob();
      bitField0_ = (bitField0_ & ~0x00000002);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Model monitoring job resource name.
     * </pre>
     *
     * <code>string model_monitoring_job = 2;</code>
     *
     * @param value The bytes for modelMonitoringJob to set.
     * @return This builder for chaining.
     */
    public Builder setModelMonitoringJobBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      modelMonitoringJob_ = value;
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }

    private java.lang.Object algorithm_ = "";
    /**
     *
     *
     * <pre>
     * Algorithm used to calculated the metrics, eg: jensen_shannon_divergence,
     * l_infinity.
     * </pre>
     *
     * <code>string algorithm = 3;</code>
     *
     * @return The algorithm.
     */
    public java.lang.String getAlgorithm() {
      java.lang.Object ref = algorithm_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        algorithm_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Algorithm used to calculated the metrics, eg: jensen_shannon_divergence,
     * l_infinity.
     * </pre>
     *
     * <code>string algorithm = 3;</code>
     *
     * @return The bytes for algorithm.
     */
    public com.google.protobuf.ByteString getAlgorithmBytes() {
      java.lang.Object ref = algorithm_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        algorithm_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Algorithm used to calculated the metrics, eg: jensen_shannon_divergence,
     * l_infinity.
     * </pre>
     *
     * <code>string algorithm = 3;</code>
     *
     * @param value The algorithm to set.
     * @return This builder for chaining.
     */
    public Builder setAlgorithm(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      algorithm_ = value;
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Algorithm used to calculated the metrics, eg: jensen_shannon_divergence,
     * l_infinity.
     * </pre>
     *
     * <code>string algorithm = 3;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearAlgorithm() {
      algorithm_ = getDefaultInstance().getAlgorithm();
      bitField0_ = (bitField0_ & ~0x00000004);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Algorithm used to calculated the metrics, eg: jensen_shannon_divergence,
     * l_infinity.
     * </pre>
     *
     * <code>string algorithm = 3;</code>
     *
     * @param value The bytes for algorithm to set.
     * @return This builder for chaining.
     */
    public Builder setAlgorithmBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      algorithm_ = value;
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.cloud.aiplatform.v1beta1.ModelMonitoringAnomaly)
  }

  // @@protoc_insertion_point(class_scope:google.cloud.aiplatform.v1beta1.ModelMonitoringAnomaly)
  private static final com.google.cloud.aiplatform.v1beta1.ModelMonitoringAnomaly DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.cloud.aiplatform.v1beta1.ModelMonitoringAnomaly();
  }

  public static com.google.cloud.aiplatform.v1beta1.ModelMonitoringAnomaly getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<ModelMonitoringAnomaly> PARSER =
      new com.google.protobuf.AbstractParser<ModelMonitoringAnomaly>() {
        @java.lang.Override
        public ModelMonitoringAnomaly parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          Builder builder = newBuilder();
          try {
            builder.mergeFrom(input, extensionRegistry);
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.setUnfinishedMessage(builder.buildPartial());
          } catch (com.google.protobuf.UninitializedMessageException e) {
            throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
          } catch (java.io.IOException e) {
            throw new com.google.protobuf.InvalidProtocolBufferException(e)
                .setUnfinishedMessage(builder.buildPartial());
          }
          return builder.buildPartial();
        }
      };

  public static com.google.protobuf.Parser<ModelMonitoringAnomaly> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<ModelMonitoringAnomaly> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.cloud.aiplatform.v1beta1.ModelMonitoringAnomaly getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
