/*
 * Copyright 2024 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/cloud/aiplatform/v1beta1/model_monitoring_spec.proto

// Protobuf Java Version: 3.25.5
package com.google.cloud.aiplatform.v1beta1;

/**
 *
 *
 * <pre>
 * Model monitoring data input spec.
 * </pre>
 *
 * Protobuf type {@code google.cloud.aiplatform.v1beta1.ModelMonitoringInput}
 */
public final class ModelMonitoringInput extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.cloud.aiplatform.v1beta1.ModelMonitoringInput)
    ModelMonitoringInputOrBuilder {
  private static final long serialVersionUID = 0L;
  // Use ModelMonitoringInput.newBuilder() to construct.
  private ModelMonitoringInput(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private ModelMonitoringInput() {}

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new ModelMonitoringInput();
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.cloud.aiplatform.v1beta1.ModelMonitoringSpecProto
        .internal_static_google_cloud_aiplatform_v1beta1_ModelMonitoringInput_descriptor;
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.cloud.aiplatform.v1beta1.ModelMonitoringSpecProto
        .internal_static_google_cloud_aiplatform_v1beta1_ModelMonitoringInput_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.cloud.aiplatform.v1beta1.ModelMonitoringInput.class,
            com.google.cloud.aiplatform.v1beta1.ModelMonitoringInput.Builder.class);
  }

  public interface ModelMonitoringDatasetOrBuilder
      extends
      // @@protoc_insertion_point(interface_extends:google.cloud.aiplatform.v1beta1.ModelMonitoringInput.ModelMonitoringDataset)
      com.google.protobuf.MessageOrBuilder {

    /**
     *
     *
     * <pre>
     * Resource name of the Vertex AI managed dataset.
     * </pre>
     *
     * <code>string vertex_dataset = 1 [(.google.api.resource_reference) = { ... }</code>
     *
     * @return Whether the vertexDataset field is set.
     */
    boolean hasVertexDataset();
    /**
     *
     *
     * <pre>
     * Resource name of the Vertex AI managed dataset.
     * </pre>
     *
     * <code>string vertex_dataset = 1 [(.google.api.resource_reference) = { ... }</code>
     *
     * @return The vertexDataset.
     */
    java.lang.String getVertexDataset();
    /**
     *
     *
     * <pre>
     * Resource name of the Vertex AI managed dataset.
     * </pre>
     *
     * <code>string vertex_dataset = 1 [(.google.api.resource_reference) = { ... }</code>
     *
     * @return The bytes for vertexDataset.
     */
    com.google.protobuf.ByteString getVertexDatasetBytes();

    /**
     *
     *
     * <pre>
     * Google Cloud Storage data source.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.ModelMonitoringInput.ModelMonitoringDataset.ModelMonitoringGcsSource gcs_source = 2;
     * </code>
     *
     * @return Whether the gcsSource field is set.
     */
    boolean hasGcsSource();
    /**
     *
     *
     * <pre>
     * Google Cloud Storage data source.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.ModelMonitoringInput.ModelMonitoringDataset.ModelMonitoringGcsSource gcs_source = 2;
     * </code>
     *
     * @return The gcsSource.
     */
    com.google.cloud.aiplatform.v1beta1.ModelMonitoringInput.ModelMonitoringDataset
            .ModelMonitoringGcsSource
        getGcsSource();
    /**
     *
     *
     * <pre>
     * Google Cloud Storage data source.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.ModelMonitoringInput.ModelMonitoringDataset.ModelMonitoringGcsSource gcs_source = 2;
     * </code>
     */
    com.google.cloud.aiplatform.v1beta1.ModelMonitoringInput.ModelMonitoringDataset
            .ModelMonitoringGcsSourceOrBuilder
        getGcsSourceOrBuilder();

    /**
     *
     *
     * <pre>
     * BigQuery data source.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.ModelMonitoringInput.ModelMonitoringDataset.ModelMonitoringBigQuerySource bigquery_source = 6;
     * </code>
     *
     * @return Whether the bigquerySource field is set.
     */
    boolean hasBigquerySource();
    /**
     *
     *
     * <pre>
     * BigQuery data source.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.ModelMonitoringInput.ModelMonitoringDataset.ModelMonitoringBigQuerySource bigquery_source = 6;
     * </code>
     *
     * @return The bigquerySource.
     */
    com.google.cloud.aiplatform.v1beta1.ModelMonitoringInput.ModelMonitoringDataset
            .ModelMonitoringBigQuerySource
        getBigquerySource();
    /**
     *
     *
     * <pre>
     * BigQuery data source.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.ModelMonitoringInput.ModelMonitoringDataset.ModelMonitoringBigQuerySource bigquery_source = 6;
     * </code>
     */
    com.google.cloud.aiplatform.v1beta1.ModelMonitoringInput.ModelMonitoringDataset
            .ModelMonitoringBigQuerySourceOrBuilder
        getBigquerySourceOrBuilder();

    /**
     *
     *
     * <pre>
     * The timestamp field. Usually for serving data.
     * </pre>
     *
     * <code>string timestamp_field = 7;</code>
     *
     * @return The timestampField.
     */
    java.lang.String getTimestampField();
    /**
     *
     *
     * <pre>
     * The timestamp field. Usually for serving data.
     * </pre>
     *
     * <code>string timestamp_field = 7;</code>
     *
     * @return The bytes for timestampField.
     */
    com.google.protobuf.ByteString getTimestampFieldBytes();

    com.google.cloud.aiplatform.v1beta1.ModelMonitoringInput.ModelMonitoringDataset.DataLocationCase
        getDataLocationCase();
  }
  /**
   *
   *
   * <pre>
   * Input dataset spec.
   * </pre>
   *
   * Protobuf type {@code
   * google.cloud.aiplatform.v1beta1.ModelMonitoringInput.ModelMonitoringDataset}
   */
  public static final class ModelMonitoringDataset extends com.google.protobuf.GeneratedMessageV3
      implements
      // @@protoc_insertion_point(message_implements:google.cloud.aiplatform.v1beta1.ModelMonitoringInput.ModelMonitoringDataset)
      ModelMonitoringDatasetOrBuilder {
    private static final long serialVersionUID = 0L;
    // Use ModelMonitoringDataset.newBuilder() to construct.
    private ModelMonitoringDataset(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
      super(builder);
    }

    private ModelMonitoringDataset() {
      timestampField_ = "";
    }

    @java.lang.Override
    @SuppressWarnings({"unused"})
    protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
      return new ModelMonitoringDataset();
    }

    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.aiplatform.v1beta1.ModelMonitoringSpecProto
          .internal_static_google_cloud_aiplatform_v1beta1_ModelMonitoringInput_ModelMonitoringDataset_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.aiplatform.v1beta1.ModelMonitoringSpecProto
          .internal_static_google_cloud_aiplatform_v1beta1_ModelMonitoringInput_ModelMonitoringDataset_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.aiplatform.v1beta1.ModelMonitoringInput.ModelMonitoringDataset.class,
              com.google.cloud.aiplatform.v1beta1.ModelMonitoringInput.ModelMonitoringDataset
                  .Builder.class);
    }

    public interface ModelMonitoringGcsSourceOrBuilder
        extends
        // @@protoc_insertion_point(interface_extends:google.cloud.aiplatform.v1beta1.ModelMonitoringInput.ModelMonitoringDataset.ModelMonitoringGcsSource)
        com.google.protobuf.MessageOrBuilder {

      /**
       *
       *
       * <pre>
       * Google Cloud Storage URI to the input file(s). May contain
       * wildcards. For more information on wildcards, see
       * https://cloud.google.com/storage/docs/gsutil/addlhelp/WildcardNames.
       * </pre>
       *
       * <code>string gcs_uri = 1;</code>
       *
       * @return The gcsUri.
       */
      java.lang.String getGcsUri();
      /**
       *
       *
       * <pre>
       * Google Cloud Storage URI to the input file(s). May contain
       * wildcards. For more information on wildcards, see
       * https://cloud.google.com/storage/docs/gsutil/addlhelp/WildcardNames.
       * </pre>
       *
       * <code>string gcs_uri = 1;</code>
       *
       * @return The bytes for gcsUri.
       */
      com.google.protobuf.ByteString getGcsUriBytes();

      /**
       *
       *
       * <pre>
       * Data format of the dataset.
       * </pre>
       *
       * <code>
       * .google.cloud.aiplatform.v1beta1.ModelMonitoringInput.ModelMonitoringDataset.ModelMonitoringGcsSource.DataFormat format = 2;
       * </code>
       *
       * @return The enum numeric value on the wire for format.
       */
      int getFormatValue();
      /**
       *
       *
       * <pre>
       * Data format of the dataset.
       * </pre>
       *
       * <code>
       * .google.cloud.aiplatform.v1beta1.ModelMonitoringInput.ModelMonitoringDataset.ModelMonitoringGcsSource.DataFormat format = 2;
       * </code>
       *
       * @return The format.
       */
      com.google.cloud.aiplatform.v1beta1.ModelMonitoringInput.ModelMonitoringDataset
              .ModelMonitoringGcsSource.DataFormat
          getFormat();
    }
    /**
     *
     *
     * <pre>
     * Dataset spec for data stored in Google Cloud Storage.
     * </pre>
     *
     * Protobuf type {@code
     * google.cloud.aiplatform.v1beta1.ModelMonitoringInput.ModelMonitoringDataset.ModelMonitoringGcsSource}
     */
    public static final class ModelMonitoringGcsSource
        extends com.google.protobuf.GeneratedMessageV3
        implements
        // @@protoc_insertion_point(message_implements:google.cloud.aiplatform.v1beta1.ModelMonitoringInput.ModelMonitoringDataset.ModelMonitoringGcsSource)
        ModelMonitoringGcsSourceOrBuilder {
      private static final long serialVersionUID = 0L;
      // Use ModelMonitoringGcsSource.newBuilder() to construct.
      private ModelMonitoringGcsSource(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
        super(builder);
      }

      private ModelMonitoringGcsSource() {
        gcsUri_ = "";
        format_ = 0;
      }

      @java.lang.Override
      @SuppressWarnings({"unused"})
      protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
        return new ModelMonitoringGcsSource();
      }

      public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
        return com.google.cloud.aiplatform.v1beta1.ModelMonitoringSpecProto
            .internal_static_google_cloud_aiplatform_v1beta1_ModelMonitoringInput_ModelMonitoringDataset_ModelMonitoringGcsSource_descriptor;
      }

      @java.lang.Override
      protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return com.google.cloud.aiplatform.v1beta1.ModelMonitoringSpecProto
            .internal_static_google_cloud_aiplatform_v1beta1_ModelMonitoringInput_ModelMonitoringDataset_ModelMonitoringGcsSource_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                com.google.cloud.aiplatform.v1beta1.ModelMonitoringInput.ModelMonitoringDataset
                    .ModelMonitoringGcsSource.class,
                com.google.cloud.aiplatform.v1beta1.ModelMonitoringInput.ModelMonitoringDataset
                    .ModelMonitoringGcsSource.Builder.class);
      }

      /**
       *
       *
       * <pre>
       * Supported data format.
       * </pre>
       *
       * Protobuf enum {@code
       * google.cloud.aiplatform.v1beta1.ModelMonitoringInput.ModelMonitoringDataset.ModelMonitoringGcsSource.DataFormat}
       */
      public enum DataFormat implements com.google.protobuf.ProtocolMessageEnum {
        /**
         *
         *
         * <pre>
         * Data format unspecified, used when this field is unset.
         * </pre>
         *
         * <code>DATA_FORMAT_UNSPECIFIED = 0;</code>
         */
        DATA_FORMAT_UNSPECIFIED(0),
        /**
         *
         *
         * <pre>
         * CSV files.
         * </pre>
         *
         * <code>CSV = 1;</code>
         */
        CSV(1),
        /**
         *
         *
         * <pre>
         * TfRecord files
         * </pre>
         *
         * <code>TF_RECORD = 2;</code>
         */
        TF_RECORD(2),
        /**
         *
         *
         * <pre>
         * JsonL files.
         * </pre>
         *
         * <code>JSONL = 3;</code>
         */
        JSONL(3),
        UNRECOGNIZED(-1),
        ;

        /**
         *
         *
         * <pre>
         * Data format unspecified, used when this field is unset.
         * </pre>
         *
         * <code>DATA_FORMAT_UNSPECIFIED = 0;</code>
         */
        public static final int DATA_FORMAT_UNSPECIFIED_VALUE = 0;
        /**
         *
         *
         * <pre>
         * CSV files.
         * </pre>
         *
         * <code>CSV = 1;</code>
         */
        public static final int CSV_VALUE = 1;
        /**
         *
         *
         * <pre>
         * TfRecord files
         * </pre>
         *
         * <code>TF_RECORD = 2;</code>
         */
        public static final int TF_RECORD_VALUE = 2;
        /**
         *
         *
         * <pre>
         * JsonL files.
         * </pre>
         *
         * <code>JSONL = 3;</code>
         */
        public static final int JSONL_VALUE = 3;

        public final int getNumber() {
          if (this == UNRECOGNIZED) {
            throw new java.lang.IllegalArgumentException(
                "Can't get the number of an unknown enum value.");
          }
          return value;
        }

        /**
         * @param value The numeric wire value of the corresponding enum entry.
         * @return The enum associated with the given numeric wire value.
         * @deprecated Use {@link #forNumber(int)} instead.
         */
        @java.lang.Deprecated
        public static DataFormat valueOf(int value) {
          return forNumber(value);
        }

        /**
         * @param value The numeric wire value of the corresponding enum entry.
         * @return The enum associated with the given numeric wire value.
         */
        public static DataFormat forNumber(int value) {
          switch (value) {
            case 0:
              return DATA_FORMAT_UNSPECIFIED;
            case 1:
              return CSV;
            case 2:
              return TF_RECORD;
            case 3:
              return JSONL;
            default:
              return null;
          }
        }

        public static com.google.protobuf.Internal.EnumLiteMap<DataFormat> internalGetValueMap() {
          return internalValueMap;
        }

        private static final com.google.protobuf.Internal.EnumLiteMap<DataFormat> internalValueMap =
            new com.google.protobuf.Internal.EnumLiteMap<DataFormat>() {
              public DataFormat findValueByNumber(int number) {
                return DataFormat.forNumber(number);
              }
            };

        public final com.google.protobuf.Descriptors.EnumValueDescriptor getValueDescriptor() {
          if (this == UNRECOGNIZED) {
            throw new java.lang.IllegalStateException(
                "Can't get the descriptor of an unrecognized enum value.");
          }
          return getDescriptor().getValues().get(ordinal());
        }

        public final com.google.protobuf.Descriptors.EnumDescriptor getDescriptorForType() {
          return getDescriptor();
        }

        public static final com.google.protobuf.Descriptors.EnumDescriptor getDescriptor() {
          return com.google.cloud.aiplatform.v1beta1.ModelMonitoringInput.ModelMonitoringDataset
              .ModelMonitoringGcsSource.getDescriptor()
              .getEnumTypes()
              .get(0);
        }

        private static final DataFormat[] VALUES = values();

        public static DataFormat valueOf(com.google.protobuf.Descriptors.EnumValueDescriptor desc) {
          if (desc.getType() != getDescriptor()) {
            throw new java.lang.IllegalArgumentException(
                "EnumValueDescriptor is not for this type.");
          }
          if (desc.getIndex() == -1) {
            return UNRECOGNIZED;
          }
          return VALUES[desc.getIndex()];
        }

        private final int value;

        private DataFormat(int value) {
          this.value = value;
        }

        // @@protoc_insertion_point(enum_scope:google.cloud.aiplatform.v1beta1.ModelMonitoringInput.ModelMonitoringDataset.ModelMonitoringGcsSource.DataFormat)
      }

      public static final int GCS_URI_FIELD_NUMBER = 1;

      @SuppressWarnings("serial")
      private volatile java.lang.Object gcsUri_ = "";
      /**
       *
       *
       * <pre>
       * Google Cloud Storage URI to the input file(s). May contain
       * wildcards. For more information on wildcards, see
       * https://cloud.google.com/storage/docs/gsutil/addlhelp/WildcardNames.
       * </pre>
       *
       * <code>string gcs_uri = 1;</code>
       *
       * @return The gcsUri.
       */
      @java.lang.Override
      public java.lang.String getGcsUri() {
        java.lang.Object ref = gcsUri_;
        if (ref instanceof java.lang.String) {
          return (java.lang.String) ref;
        } else {
          com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
          java.lang.String s = bs.toStringUtf8();
          gcsUri_ = s;
          return s;
        }
      }
      /**
       *
       *
       * <pre>
       * Google Cloud Storage URI to the input file(s). May contain
       * wildcards. For more information on wildcards, see
       * https://cloud.google.com/storage/docs/gsutil/addlhelp/WildcardNames.
       * </pre>
       *
       * <code>string gcs_uri = 1;</code>
       *
       * @return The bytes for gcsUri.
       */
      @java.lang.Override
      public com.google.protobuf.ByteString getGcsUriBytes() {
        java.lang.Object ref = gcsUri_;
        if (ref instanceof java.lang.String) {
          com.google.protobuf.ByteString b =
              com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
          gcsUri_ = b;
          return b;
        } else {
          return (com.google.protobuf.ByteString) ref;
        }
      }

      public static final int FORMAT_FIELD_NUMBER = 2;
      private int format_ = 0;
      /**
       *
       *
       * <pre>
       * Data format of the dataset.
       * </pre>
       *
       * <code>
       * .google.cloud.aiplatform.v1beta1.ModelMonitoringInput.ModelMonitoringDataset.ModelMonitoringGcsSource.DataFormat format = 2;
       * </code>
       *
       * @return The enum numeric value on the wire for format.
       */
      @java.lang.Override
      public int getFormatValue() {
        return format_;
      }
      /**
       *
       *
       * <pre>
       * Data format of the dataset.
       * </pre>
       *
       * <code>
       * .google.cloud.aiplatform.v1beta1.ModelMonitoringInput.ModelMonitoringDataset.ModelMonitoringGcsSource.DataFormat format = 2;
       * </code>
       *
       * @return The format.
       */
      @java.lang.Override
      public com.google.cloud.aiplatform.v1beta1.ModelMonitoringInput.ModelMonitoringDataset
              .ModelMonitoringGcsSource.DataFormat
          getFormat() {
        com.google.cloud.aiplatform.v1beta1.ModelMonitoringInput.ModelMonitoringDataset
                .ModelMonitoringGcsSource.DataFormat
            result =
                com.google.cloud.aiplatform.v1beta1.ModelMonitoringInput.ModelMonitoringDataset
                    .ModelMonitoringGcsSource.DataFormat.forNumber(format_);
        return result == null
            ? com.google.cloud.aiplatform.v1beta1.ModelMonitoringInput.ModelMonitoringDataset
                .ModelMonitoringGcsSource.DataFormat.UNRECOGNIZED
            : result;
      }

      private byte memoizedIsInitialized = -1;

      @java.lang.Override
      public final boolean isInitialized() {
        byte isInitialized = memoizedIsInitialized;
        if (isInitialized == 1) return true;
        if (isInitialized == 0) return false;

        memoizedIsInitialized = 1;
        return true;
      }

      @java.lang.Override
      public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
        if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(gcsUri_)) {
          com.google.protobuf.GeneratedMessageV3.writeString(output, 1, gcsUri_);
        }
        if (format_
            != com.google.cloud.aiplatform.v1beta1.ModelMonitoringInput.ModelMonitoringDataset
                .ModelMonitoringGcsSource.DataFormat.DATA_FORMAT_UNSPECIFIED
                .getNumber()) {
          output.writeEnum(2, format_);
        }
        getUnknownFields().writeTo(output);
      }

      @java.lang.Override
      public int getSerializedSize() {
        int size = memoizedSize;
        if (size != -1) return size;

        size = 0;
        if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(gcsUri_)) {
          size += com.google.protobuf.GeneratedMessageV3.computeStringSize(1, gcsUri_);
        }
        if (format_
            != com.google.cloud.aiplatform.v1beta1.ModelMonitoringInput.ModelMonitoringDataset
                .ModelMonitoringGcsSource.DataFormat.DATA_FORMAT_UNSPECIFIED
                .getNumber()) {
          size += com.google.protobuf.CodedOutputStream.computeEnumSize(2, format_);
        }
        size += getUnknownFields().getSerializedSize();
        memoizedSize = size;
        return size;
      }

      @java.lang.Override
      public boolean equals(final java.lang.Object obj) {
        if (obj == this) {
          return true;
        }
        if (!(obj
            instanceof
            com.google.cloud.aiplatform.v1beta1.ModelMonitoringInput.ModelMonitoringDataset
                .ModelMonitoringGcsSource)) {
          return super.equals(obj);
        }
        com.google.cloud.aiplatform.v1beta1.ModelMonitoringInput.ModelMonitoringDataset
                .ModelMonitoringGcsSource
            other =
                (com.google.cloud.aiplatform.v1beta1.ModelMonitoringInput.ModelMonitoringDataset
                        .ModelMonitoringGcsSource)
                    obj;

        if (!getGcsUri().equals(other.getGcsUri())) return false;
        if (format_ != other.format_) return false;
        if (!getUnknownFields().equals(other.getUnknownFields())) return false;
        return true;
      }

      @java.lang.Override
      public int hashCode() {
        if (memoizedHashCode != 0) {
          return memoizedHashCode;
        }
        int hash = 41;
        hash = (19 * hash) + getDescriptor().hashCode();
        hash = (37 * hash) + GCS_URI_FIELD_NUMBER;
        hash = (53 * hash) + getGcsUri().hashCode();
        hash = (37 * hash) + FORMAT_FIELD_NUMBER;
        hash = (53 * hash) + format_;
        hash = (29 * hash) + getUnknownFields().hashCode();
        memoizedHashCode = hash;
        return hash;
      }

      public static com.google.cloud.aiplatform.v1beta1.ModelMonitoringInput.ModelMonitoringDataset
              .ModelMonitoringGcsSource
          parseFrom(java.nio.ByteBuffer data)
              throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data);
      }

      public static com.google.cloud.aiplatform.v1beta1.ModelMonitoringInput.ModelMonitoringDataset
              .ModelMonitoringGcsSource
          parseFrom(
              java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data, extensionRegistry);
      }

      public static com.google.cloud.aiplatform.v1beta1.ModelMonitoringInput.ModelMonitoringDataset
              .ModelMonitoringGcsSource
          parseFrom(com.google.protobuf.ByteString data)
              throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data);
      }

      public static com.google.cloud.aiplatform.v1beta1.ModelMonitoringInput.ModelMonitoringDataset
              .ModelMonitoringGcsSource
          parseFrom(
              com.google.protobuf.ByteString data,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data, extensionRegistry);
      }

      public static com.google.cloud.aiplatform.v1beta1.ModelMonitoringInput.ModelMonitoringDataset
              .ModelMonitoringGcsSource
          parseFrom(byte[] data) throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data);
      }

      public static com.google.cloud.aiplatform.v1beta1.ModelMonitoringInput.ModelMonitoringDataset
              .ModelMonitoringGcsSource
          parseFrom(byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data, extensionRegistry);
      }

      public static com.google.cloud.aiplatform.v1beta1.ModelMonitoringInput.ModelMonitoringDataset
              .ModelMonitoringGcsSource
          parseFrom(java.io.InputStream input) throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
      }

      public static com.google.cloud.aiplatform.v1beta1.ModelMonitoringInput.ModelMonitoringDataset
              .ModelMonitoringGcsSource
          parseFrom(
              java.io.InputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
            PARSER, input, extensionRegistry);
      }

      public static com.google.cloud.aiplatform.v1beta1.ModelMonitoringInput.ModelMonitoringDataset
              .ModelMonitoringGcsSource
          parseDelimitedFrom(java.io.InputStream input) throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
      }

      public static com.google.cloud.aiplatform.v1beta1.ModelMonitoringInput.ModelMonitoringDataset
              .ModelMonitoringGcsSource
          parseDelimitedFrom(
              java.io.InputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
            PARSER, input, extensionRegistry);
      }

      public static com.google.cloud.aiplatform.v1beta1.ModelMonitoringInput.ModelMonitoringDataset
              .ModelMonitoringGcsSource
          parseFrom(com.google.protobuf.CodedInputStream input) throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
      }

      public static com.google.cloud.aiplatform.v1beta1.ModelMonitoringInput.ModelMonitoringDataset
              .ModelMonitoringGcsSource
          parseFrom(
              com.google.protobuf.CodedInputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
            PARSER, input, extensionRegistry);
      }

      @java.lang.Override
      public Builder newBuilderForType() {
        return newBuilder();
      }

      public static Builder newBuilder() {
        return DEFAULT_INSTANCE.toBuilder();
      }

      public static Builder newBuilder(
          com.google.cloud.aiplatform.v1beta1.ModelMonitoringInput.ModelMonitoringDataset
                  .ModelMonitoringGcsSource
              prototype) {
        return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
      }

      @java.lang.Override
      public Builder toBuilder() {
        return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
      }

      @java.lang.Override
      protected Builder newBuilderForType(
          com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
        Builder builder = new Builder(parent);
        return builder;
      }
      /**
       *
       *
       * <pre>
       * Dataset spec for data stored in Google Cloud Storage.
       * </pre>
       *
       * Protobuf type {@code
       * google.cloud.aiplatform.v1beta1.ModelMonitoringInput.ModelMonitoringDataset.ModelMonitoringGcsSource}
       */
      public static final class Builder
          extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
          implements
          // @@protoc_insertion_point(builder_implements:google.cloud.aiplatform.v1beta1.ModelMonitoringInput.ModelMonitoringDataset.ModelMonitoringGcsSource)
          com.google.cloud.aiplatform.v1beta1.ModelMonitoringInput.ModelMonitoringDataset
              .ModelMonitoringGcsSourceOrBuilder {
        public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
          return com.google.cloud.aiplatform.v1beta1.ModelMonitoringSpecProto
              .internal_static_google_cloud_aiplatform_v1beta1_ModelMonitoringInput_ModelMonitoringDataset_ModelMonitoringGcsSource_descriptor;
        }

        @java.lang.Override
        protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
            internalGetFieldAccessorTable() {
          return com.google.cloud.aiplatform.v1beta1.ModelMonitoringSpecProto
              .internal_static_google_cloud_aiplatform_v1beta1_ModelMonitoringInput_ModelMonitoringDataset_ModelMonitoringGcsSource_fieldAccessorTable
              .ensureFieldAccessorsInitialized(
                  com.google.cloud.aiplatform.v1beta1.ModelMonitoringInput.ModelMonitoringDataset
                      .ModelMonitoringGcsSource.class,
                  com.google.cloud.aiplatform.v1beta1.ModelMonitoringInput.ModelMonitoringDataset
                      .ModelMonitoringGcsSource.Builder.class);
        }

        // Construct using
        // com.google.cloud.aiplatform.v1beta1.ModelMonitoringInput.ModelMonitoringDataset.ModelMonitoringGcsSource.newBuilder()
        private Builder() {}

        private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
          super(parent);
        }

        @java.lang.Override
        public Builder clear() {
          super.clear();
          bitField0_ = 0;
          gcsUri_ = "";
          format_ = 0;
          return this;
        }

        @java.lang.Override
        public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
          return com.google.cloud.aiplatform.v1beta1.ModelMonitoringSpecProto
              .internal_static_google_cloud_aiplatform_v1beta1_ModelMonitoringInput_ModelMonitoringDataset_ModelMonitoringGcsSource_descriptor;
        }

        @java.lang.Override
        public com.google.cloud.aiplatform.v1beta1.ModelMonitoringInput.ModelMonitoringDataset
                .ModelMonitoringGcsSource
            getDefaultInstanceForType() {
          return com.google.cloud.aiplatform.v1beta1.ModelMonitoringInput.ModelMonitoringDataset
              .ModelMonitoringGcsSource.getDefaultInstance();
        }

        @java.lang.Override
        public com.google.cloud.aiplatform.v1beta1.ModelMonitoringInput.ModelMonitoringDataset
                .ModelMonitoringGcsSource
            build() {
          com.google.cloud.aiplatform.v1beta1.ModelMonitoringInput.ModelMonitoringDataset
                  .ModelMonitoringGcsSource
              result = buildPartial();
          if (!result.isInitialized()) {
            throw newUninitializedMessageException(result);
          }
          return result;
        }

        @java.lang.Override
        public com.google.cloud.aiplatform.v1beta1.ModelMonitoringInput.ModelMonitoringDataset
                .ModelMonitoringGcsSource
            buildPartial() {
          com.google.cloud.aiplatform.v1beta1.ModelMonitoringInput.ModelMonitoringDataset
                  .ModelMonitoringGcsSource
              result =
                  new com.google.cloud.aiplatform.v1beta1.ModelMonitoringInput
                      .ModelMonitoringDataset.ModelMonitoringGcsSource(this);
          if (bitField0_ != 0) {
            buildPartial0(result);
          }
          onBuilt();
          return result;
        }

        private void buildPartial0(
            com.google.cloud.aiplatform.v1beta1.ModelMonitoringInput.ModelMonitoringDataset
                    .ModelMonitoringGcsSource
                result) {
          int from_bitField0_ = bitField0_;
          if (((from_bitField0_ & 0x00000001) != 0)) {
            result.gcsUri_ = gcsUri_;
          }
          if (((from_bitField0_ & 0x00000002) != 0)) {
            result.format_ = format_;
          }
        }

        @java.lang.Override
        public Builder clone() {
          return super.clone();
        }

        @java.lang.Override
        public Builder setField(
            com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
          return super.setField(field, value);
        }

        @java.lang.Override
        public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
          return super.clearField(field);
        }

        @java.lang.Override
        public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
          return super.clearOneof(oneof);
        }

        @java.lang.Override
        public Builder setRepeatedField(
            com.google.protobuf.Descriptors.FieldDescriptor field,
            int index,
            java.lang.Object value) {
          return super.setRepeatedField(field, index, value);
        }

        @java.lang.Override
        public Builder addRepeatedField(
            com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
          return super.addRepeatedField(field, value);
        }

        @java.lang.Override
        public Builder mergeFrom(com.google.protobuf.Message other) {
          if (other
              instanceof
              com.google.cloud.aiplatform.v1beta1.ModelMonitoringInput.ModelMonitoringDataset
                  .ModelMonitoringGcsSource) {
            return mergeFrom(
                (com.google.cloud.aiplatform.v1beta1.ModelMonitoringInput.ModelMonitoringDataset
                        .ModelMonitoringGcsSource)
                    other);
          } else {
            super.mergeFrom(other);
            return this;
          }
        }

        public Builder mergeFrom(
            com.google.cloud.aiplatform.v1beta1.ModelMonitoringInput.ModelMonitoringDataset
                    .ModelMonitoringGcsSource
                other) {
          if (other
              == com.google.cloud.aiplatform.v1beta1.ModelMonitoringInput.ModelMonitoringDataset
                  .ModelMonitoringGcsSource.getDefaultInstance()) return this;
          if (!other.getGcsUri().isEmpty()) {
            gcsUri_ = other.gcsUri_;
            bitField0_ |= 0x00000001;
            onChanged();
          }
          if (other.format_ != 0) {
            setFormatValue(other.getFormatValue());
          }
          this.mergeUnknownFields(other.getUnknownFields());
          onChanged();
          return this;
        }

        @java.lang.Override
        public final boolean isInitialized() {
          return true;
        }

        @java.lang.Override
        public Builder mergeFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws java.io.IOException {
          if (extensionRegistry == null) {
            throw new java.lang.NullPointerException();
          }
          try {
            boolean done = false;
            while (!done) {
              int tag = input.readTag();
              switch (tag) {
                case 0:
                  done = true;
                  break;
                case 10:
                  {
                    gcsUri_ = input.readStringRequireUtf8();
                    bitField0_ |= 0x00000001;
                    break;
                  } // case 10
                case 16:
                  {
                    format_ = input.readEnum();
                    bitField0_ |= 0x00000002;
                    break;
                  } // case 16
                default:
                  {
                    if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                      done = true; // was an endgroup tag
                    }
                    break;
                  } // default:
              } // switch (tag)
            } // while (!done)
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.unwrapIOException();
          } finally {
            onChanged();
          } // finally
          return this;
        }

        private int bitField0_;

        private java.lang.Object gcsUri_ = "";
        /**
         *
         *
         * <pre>
         * Google Cloud Storage URI to the input file(s). May contain
         * wildcards. For more information on wildcards, see
         * https://cloud.google.com/storage/docs/gsutil/addlhelp/WildcardNames.
         * </pre>
         *
         * <code>string gcs_uri = 1;</code>
         *
         * @return The gcsUri.
         */
        public java.lang.String getGcsUri() {
          java.lang.Object ref = gcsUri_;
          if (!(ref instanceof java.lang.String)) {
            com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
            java.lang.String s = bs.toStringUtf8();
            gcsUri_ = s;
            return s;
          } else {
            return (java.lang.String) ref;
          }
        }
        /**
         *
         *
         * <pre>
         * Google Cloud Storage URI to the input file(s). May contain
         * wildcards. For more information on wildcards, see
         * https://cloud.google.com/storage/docs/gsutil/addlhelp/WildcardNames.
         * </pre>
         *
         * <code>string gcs_uri = 1;</code>
         *
         * @return The bytes for gcsUri.
         */
        public com.google.protobuf.ByteString getGcsUriBytes() {
          java.lang.Object ref = gcsUri_;
          if (ref instanceof String) {
            com.google.protobuf.ByteString b =
                com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
            gcsUri_ = b;
            return b;
          } else {
            return (com.google.protobuf.ByteString) ref;
          }
        }
        /**
         *
         *
         * <pre>
         * Google Cloud Storage URI to the input file(s). May contain
         * wildcards. For more information on wildcards, see
         * https://cloud.google.com/storage/docs/gsutil/addlhelp/WildcardNames.
         * </pre>
         *
         * <code>string gcs_uri = 1;</code>
         *
         * @param value The gcsUri to set.
         * @return This builder for chaining.
         */
        public Builder setGcsUri(java.lang.String value) {
          if (value == null) {
            throw new NullPointerException();
          }
          gcsUri_ = value;
          bitField0_ |= 0x00000001;
          onChanged();
          return this;
        }
        /**
         *
         *
         * <pre>
         * Google Cloud Storage URI to the input file(s). May contain
         * wildcards. For more information on wildcards, see
         * https://cloud.google.com/storage/docs/gsutil/addlhelp/WildcardNames.
         * </pre>
         *
         * <code>string gcs_uri = 1;</code>
         *
         * @return This builder for chaining.
         */
        public Builder clearGcsUri() {
          gcsUri_ = getDefaultInstance().getGcsUri();
          bitField0_ = (bitField0_ & ~0x00000001);
          onChanged();
          return this;
        }
        /**
         *
         *
         * <pre>
         * Google Cloud Storage URI to the input file(s). May contain
         * wildcards. For more information on wildcards, see
         * https://cloud.google.com/storage/docs/gsutil/addlhelp/WildcardNames.
         * </pre>
         *
         * <code>string gcs_uri = 1;</code>
         *
         * @param value The bytes for gcsUri to set.
         * @return This builder for chaining.
         */
        public Builder setGcsUriBytes(com.google.protobuf.ByteString value) {
          if (value == null) {
            throw new NullPointerException();
          }
          checkByteStringIsUtf8(value);
          gcsUri_ = value;
          bitField0_ |= 0x00000001;
          onChanged();
          return this;
        }

        private int format_ = 0;
        /**
         *
         *
         * <pre>
         * Data format of the dataset.
         * </pre>
         *
         * <code>
         * .google.cloud.aiplatform.v1beta1.ModelMonitoringInput.ModelMonitoringDataset.ModelMonitoringGcsSource.DataFormat format = 2;
         * </code>
         *
         * @return The enum numeric value on the wire for format.
         */
        @java.lang.Override
        public int getFormatValue() {
          return format_;
        }
        /**
         *
         *
         * <pre>
         * Data format of the dataset.
         * </pre>
         *
         * <code>
         * .google.cloud.aiplatform.v1beta1.ModelMonitoringInput.ModelMonitoringDataset.ModelMonitoringGcsSource.DataFormat format = 2;
         * </code>
         *
         * @param value The enum numeric value on the wire for format to set.
         * @return This builder for chaining.
         */
        public Builder setFormatValue(int value) {
          format_ = value;
          bitField0_ |= 0x00000002;
          onChanged();
          return this;
        }
        /**
         *
         *
         * <pre>
         * Data format of the dataset.
         * </pre>
         *
         * <code>
         * .google.cloud.aiplatform.v1beta1.ModelMonitoringInput.ModelMonitoringDataset.ModelMonitoringGcsSource.DataFormat format = 2;
         * </code>
         *
         * @return The format.
         */
        @java.lang.Override
        public com.google.cloud.aiplatform.v1beta1.ModelMonitoringInput.ModelMonitoringDataset
                .ModelMonitoringGcsSource.DataFormat
            getFormat() {
          com.google.cloud.aiplatform.v1beta1.ModelMonitoringInput.ModelMonitoringDataset
                  .ModelMonitoringGcsSource.DataFormat
              result =
                  com.google.cloud.aiplatform.v1beta1.ModelMonitoringInput.ModelMonitoringDataset
                      .ModelMonitoringGcsSource.DataFormat.forNumber(format_);
          return result == null
              ? com.google.cloud.aiplatform.v1beta1.ModelMonitoringInput.ModelMonitoringDataset
                  .ModelMonitoringGcsSource.DataFormat.UNRECOGNIZED
              : result;
        }
        /**
         *
         *
         * <pre>
         * Data format of the dataset.
         * </pre>
         *
         * <code>
         * .google.cloud.aiplatform.v1beta1.ModelMonitoringInput.ModelMonitoringDataset.ModelMonitoringGcsSource.DataFormat format = 2;
         * </code>
         *
         * @param value The format to set.
         * @return This builder for chaining.
         */
        public Builder setFormat(
            com.google.cloud.aiplatform.v1beta1.ModelMonitoringInput.ModelMonitoringDataset
                    .ModelMonitoringGcsSource.DataFormat
                value) {
          if (value == null) {
            throw new NullPointerException();
          }
          bitField0_ |= 0x00000002;
          format_ = value.getNumber();
          onChanged();
          return this;
        }
        /**
         *
         *
         * <pre>
         * Data format of the dataset.
         * </pre>
         *
         * <code>
         * .google.cloud.aiplatform.v1beta1.ModelMonitoringInput.ModelMonitoringDataset.ModelMonitoringGcsSource.DataFormat format = 2;
         * </code>
         *
         * @return This builder for chaining.
         */
        public Builder clearFormat() {
          bitField0_ = (bitField0_ & ~0x00000002);
          format_ = 0;
          onChanged();
          return this;
        }

        @java.lang.Override
        public final Builder setUnknownFields(
            final com.google.protobuf.UnknownFieldSet unknownFields) {
          return super.setUnknownFields(unknownFields);
        }

        @java.lang.Override
        public final Builder mergeUnknownFields(
            final com.google.protobuf.UnknownFieldSet unknownFields) {
          return super.mergeUnknownFields(unknownFields);
        }

        // @@protoc_insertion_point(builder_scope:google.cloud.aiplatform.v1beta1.ModelMonitoringInput.ModelMonitoringDataset.ModelMonitoringGcsSource)
      }

      // @@protoc_insertion_point(class_scope:google.cloud.aiplatform.v1beta1.ModelMonitoringInput.ModelMonitoringDataset.ModelMonitoringGcsSource)
      private static final com.google.cloud.aiplatform.v1beta1.ModelMonitoringInput
              .ModelMonitoringDataset.ModelMonitoringGcsSource
          DEFAULT_INSTANCE;

      static {
        DEFAULT_INSTANCE =
            new com.google.cloud.aiplatform.v1beta1.ModelMonitoringInput.ModelMonitoringDataset
                .ModelMonitoringGcsSource();
      }

      public static com.google.cloud.aiplatform.v1beta1.ModelMonitoringInput.ModelMonitoringDataset
              .ModelMonitoringGcsSource
          getDefaultInstance() {
        return DEFAULT_INSTANCE;
      }

      private static final com.google.protobuf.Parser<ModelMonitoringGcsSource> PARSER =
          new com.google.protobuf.AbstractParser<ModelMonitoringGcsSource>() {
            @java.lang.Override
            public ModelMonitoringGcsSource parsePartialFrom(
                com.google.protobuf.CodedInputStream input,
                com.google.protobuf.ExtensionRegistryLite extensionRegistry)
                throws com.google.protobuf.InvalidProtocolBufferException {
              Builder builder = newBuilder();
              try {
                builder.mergeFrom(input, extensionRegistry);
              } catch (com.google.protobuf.InvalidProtocolBufferException e) {
                throw e.setUnfinishedMessage(builder.buildPartial());
              } catch (com.google.protobuf.UninitializedMessageException e) {
                throw e.asInvalidProtocolBufferException()
                    .setUnfinishedMessage(builder.buildPartial());
              } catch (java.io.IOException e) {
                throw new com.google.protobuf.InvalidProtocolBufferException(e)
                    .setUnfinishedMessage(builder.buildPartial());
              }
              return builder.buildPartial();
            }
          };

      public static com.google.protobuf.Parser<ModelMonitoringGcsSource> parser() {
        return PARSER;
      }

      @java.lang.Override
      public com.google.protobuf.Parser<ModelMonitoringGcsSource> getParserForType() {
        return PARSER;
      }

      @java.lang.Override
      public com.google.cloud.aiplatform.v1beta1.ModelMonitoringInput.ModelMonitoringDataset
              .ModelMonitoringGcsSource
          getDefaultInstanceForType() {
        return DEFAULT_INSTANCE;
      }
    }

    public interface ModelMonitoringBigQuerySourceOrBuilder
        extends
        // @@protoc_insertion_point(interface_extends:google.cloud.aiplatform.v1beta1.ModelMonitoringInput.ModelMonitoringDataset.ModelMonitoringBigQuerySource)
        com.google.protobuf.MessageOrBuilder {

      /**
       *
       *
       * <pre>
       * BigQuery URI to a table, up to 2000 characters long. All the columns
       * in the table will be selected. Accepted forms:
       *
       * *  BigQuery path. For example:
       * `bq://projectId.bqDatasetId.bqTableId`.
       * </pre>
       *
       * <code>string table_uri = 1;</code>
       *
       * @return Whether the tableUri field is set.
       */
      boolean hasTableUri();
      /**
       *
       *
       * <pre>
       * BigQuery URI to a table, up to 2000 characters long. All the columns
       * in the table will be selected. Accepted forms:
       *
       * *  BigQuery path. For example:
       * `bq://projectId.bqDatasetId.bqTableId`.
       * </pre>
       *
       * <code>string table_uri = 1;</code>
       *
       * @return The tableUri.
       */
      java.lang.String getTableUri();
      /**
       *
       *
       * <pre>
       * BigQuery URI to a table, up to 2000 characters long. All the columns
       * in the table will be selected. Accepted forms:
       *
       * *  BigQuery path. For example:
       * `bq://projectId.bqDatasetId.bqTableId`.
       * </pre>
       *
       * <code>string table_uri = 1;</code>
       *
       * @return The bytes for tableUri.
       */
      com.google.protobuf.ByteString getTableUriBytes();

      /**
       *
       *
       * <pre>
       * Standard SQL to be used instead of the `table_uri`.
       * </pre>
       *
       * <code>string query = 2;</code>
       *
       * @return Whether the query field is set.
       */
      boolean hasQuery();
      /**
       *
       *
       * <pre>
       * Standard SQL to be used instead of the `table_uri`.
       * </pre>
       *
       * <code>string query = 2;</code>
       *
       * @return The query.
       */
      java.lang.String getQuery();
      /**
       *
       *
       * <pre>
       * Standard SQL to be used instead of the `table_uri`.
       * </pre>
       *
       * <code>string query = 2;</code>
       *
       * @return The bytes for query.
       */
      com.google.protobuf.ByteString getQueryBytes();

      com.google.cloud.aiplatform.v1beta1.ModelMonitoringInput.ModelMonitoringDataset
              .ModelMonitoringBigQuerySource.ConnectionCase
          getConnectionCase();
    }
    /**
     *
     *
     * <pre>
     * Dataset spec for data sotred in BigQuery.
     * </pre>
     *
     * Protobuf type {@code
     * google.cloud.aiplatform.v1beta1.ModelMonitoringInput.ModelMonitoringDataset.ModelMonitoringBigQuerySource}
     */
    public static final class ModelMonitoringBigQuerySource
        extends com.google.protobuf.GeneratedMessageV3
        implements
        // @@protoc_insertion_point(message_implements:google.cloud.aiplatform.v1beta1.ModelMonitoringInput.ModelMonitoringDataset.ModelMonitoringBigQuerySource)
        ModelMonitoringBigQuerySourceOrBuilder {
      private static final long serialVersionUID = 0L;
      // Use ModelMonitoringBigQuerySource.newBuilder() to construct.
      private ModelMonitoringBigQuerySource(
          com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
        super(builder);
      }

      private ModelMonitoringBigQuerySource() {}

      @java.lang.Override
      @SuppressWarnings({"unused"})
      protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
        return new ModelMonitoringBigQuerySource();
      }

      public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
        return com.google.cloud.aiplatform.v1beta1.ModelMonitoringSpecProto
            .internal_static_google_cloud_aiplatform_v1beta1_ModelMonitoringInput_ModelMonitoringDataset_ModelMonitoringBigQuerySource_descriptor;
      }

      @java.lang.Override
      protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return com.google.cloud.aiplatform.v1beta1.ModelMonitoringSpecProto
            .internal_static_google_cloud_aiplatform_v1beta1_ModelMonitoringInput_ModelMonitoringDataset_ModelMonitoringBigQuerySource_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                com.google.cloud.aiplatform.v1beta1.ModelMonitoringInput.ModelMonitoringDataset
                    .ModelMonitoringBigQuerySource.class,
                com.google.cloud.aiplatform.v1beta1.ModelMonitoringInput.ModelMonitoringDataset
                    .ModelMonitoringBigQuerySource.Builder.class);
      }

      private int connectionCase_ = 0;

      @SuppressWarnings("serial")
      private java.lang.Object connection_;

      public enum ConnectionCase
          implements
              com.google.protobuf.Internal.EnumLite,
              com.google.protobuf.AbstractMessage.InternalOneOfEnum {
        TABLE_URI(1),
        QUERY(2),
        CONNECTION_NOT_SET(0);
        private final int value;

        private ConnectionCase(int value) {
          this.value = value;
        }
        /**
         * @param value The number of the enum to look for.
         * @return The enum associated with the given number.
         * @deprecated Use {@link #forNumber(int)} instead.
         */
        @java.lang.Deprecated
        public static ConnectionCase valueOf(int value) {
          return forNumber(value);
        }

        public static ConnectionCase forNumber(int value) {
          switch (value) {
            case 1:
              return TABLE_URI;
            case 2:
              return QUERY;
            case 0:
              return CONNECTION_NOT_SET;
            default:
              return null;
          }
        }

        public int getNumber() {
          return this.value;
        }
      };

      public ConnectionCase getConnectionCase() {
        return ConnectionCase.forNumber(connectionCase_);
      }

      public static final int TABLE_URI_FIELD_NUMBER = 1;
      /**
       *
       *
       * <pre>
       * BigQuery URI to a table, up to 2000 characters long. All the columns
       * in the table will be selected. Accepted forms:
       *
       * *  BigQuery path. For example:
       * `bq://projectId.bqDatasetId.bqTableId`.
       * </pre>
       *
       * <code>string table_uri = 1;</code>
       *
       * @return Whether the tableUri field is set.
       */
      public boolean hasTableUri() {
        return connectionCase_ == 1;
      }
      /**
       *
       *
       * <pre>
       * BigQuery URI to a table, up to 2000 characters long. All the columns
       * in the table will be selected. Accepted forms:
       *
       * *  BigQuery path. For example:
       * `bq://projectId.bqDatasetId.bqTableId`.
       * </pre>
       *
       * <code>string table_uri = 1;</code>
       *
       * @return The tableUri.
       */
      public java.lang.String getTableUri() {
        java.lang.Object ref = "";
        if (connectionCase_ == 1) {
          ref = connection_;
        }
        if (ref instanceof java.lang.String) {
          return (java.lang.String) ref;
        } else {
          com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
          java.lang.String s = bs.toStringUtf8();
          if (connectionCase_ == 1) {
            connection_ = s;
          }
          return s;
        }
      }
      /**
       *
       *
       * <pre>
       * BigQuery URI to a table, up to 2000 characters long. All the columns
       * in the table will be selected. Accepted forms:
       *
       * *  BigQuery path. For example:
       * `bq://projectId.bqDatasetId.bqTableId`.
       * </pre>
       *
       * <code>string table_uri = 1;</code>
       *
       * @return The bytes for tableUri.
       */
      public com.google.protobuf.ByteString getTableUriBytes() {
        java.lang.Object ref = "";
        if (connectionCase_ == 1) {
          ref = connection_;
        }
        if (ref instanceof java.lang.String) {
          com.google.protobuf.ByteString b =
              com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
          if (connectionCase_ == 1) {
            connection_ = b;
          }
          return b;
        } else {
          return (com.google.protobuf.ByteString) ref;
        }
      }

      public static final int QUERY_FIELD_NUMBER = 2;
      /**
       *
       *
       * <pre>
       * Standard SQL to be used instead of the `table_uri`.
       * </pre>
       *
       * <code>string query = 2;</code>
       *
       * @return Whether the query field is set.
       */
      public boolean hasQuery() {
        return connectionCase_ == 2;
      }
      /**
       *
       *
       * <pre>
       * Standard SQL to be used instead of the `table_uri`.
       * </pre>
       *
       * <code>string query = 2;</code>
       *
       * @return The query.
       */
      public java.lang.String getQuery() {
        java.lang.Object ref = "";
        if (connectionCase_ == 2) {
          ref = connection_;
        }
        if (ref instanceof java.lang.String) {
          return (java.lang.String) ref;
        } else {
          com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
          java.lang.String s = bs.toStringUtf8();
          if (connectionCase_ == 2) {
            connection_ = s;
          }
          return s;
        }
      }
      /**
       *
       *
       * <pre>
       * Standard SQL to be used instead of the `table_uri`.
       * </pre>
       *
       * <code>string query = 2;</code>
       *
       * @return The bytes for query.
       */
      public com.google.protobuf.ByteString getQueryBytes() {
        java.lang.Object ref = "";
        if (connectionCase_ == 2) {
          ref = connection_;
        }
        if (ref instanceof java.lang.String) {
          com.google.protobuf.ByteString b =
              com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
          if (connectionCase_ == 2) {
            connection_ = b;
          }
          return b;
        } else {
          return (com.google.protobuf.ByteString) ref;
        }
      }

      private byte memoizedIsInitialized = -1;

      @java.lang.Override
      public final boolean isInitialized() {
        byte isInitialized = memoizedIsInitialized;
        if (isInitialized == 1) return true;
        if (isInitialized == 0) return false;

        memoizedIsInitialized = 1;
        return true;
      }

      @java.lang.Override
      public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
        if (connectionCase_ == 1) {
          com.google.protobuf.GeneratedMessageV3.writeString(output, 1, connection_);
        }
        if (connectionCase_ == 2) {
          com.google.protobuf.GeneratedMessageV3.writeString(output, 2, connection_);
        }
        getUnknownFields().writeTo(output);
      }

      @java.lang.Override
      public int getSerializedSize() {
        int size = memoizedSize;
        if (size != -1) return size;

        size = 0;
        if (connectionCase_ == 1) {
          size += com.google.protobuf.GeneratedMessageV3.computeStringSize(1, connection_);
        }
        if (connectionCase_ == 2) {
          size += com.google.protobuf.GeneratedMessageV3.computeStringSize(2, connection_);
        }
        size += getUnknownFields().getSerializedSize();
        memoizedSize = size;
        return size;
      }

      @java.lang.Override
      public boolean equals(final java.lang.Object obj) {
        if (obj == this) {
          return true;
        }
        if (!(obj
            instanceof
            com.google.cloud.aiplatform.v1beta1.ModelMonitoringInput.ModelMonitoringDataset
                .ModelMonitoringBigQuerySource)) {
          return super.equals(obj);
        }
        com.google.cloud.aiplatform.v1beta1.ModelMonitoringInput.ModelMonitoringDataset
                .ModelMonitoringBigQuerySource
            other =
                (com.google.cloud.aiplatform.v1beta1.ModelMonitoringInput.ModelMonitoringDataset
                        .ModelMonitoringBigQuerySource)
                    obj;

        if (!getConnectionCase().equals(other.getConnectionCase())) return false;
        switch (connectionCase_) {
          case 1:
            if (!getTableUri().equals(other.getTableUri())) return false;
            break;
          case 2:
            if (!getQuery().equals(other.getQuery())) return false;
            break;
          case 0:
          default:
        }
        if (!getUnknownFields().equals(other.getUnknownFields())) return false;
        return true;
      }

      @java.lang.Override
      public int hashCode() {
        if (memoizedHashCode != 0) {
          return memoizedHashCode;
        }
        int hash = 41;
        hash = (19 * hash) + getDescriptor().hashCode();
        switch (connectionCase_) {
          case 1:
            hash = (37 * hash) + TABLE_URI_FIELD_NUMBER;
            hash = (53 * hash) + getTableUri().hashCode();
            break;
          case 2:
            hash = (37 * hash) + QUERY_FIELD_NUMBER;
            hash = (53 * hash) + getQuery().hashCode();
            break;
          case 0:
          default:
        }
        hash = (29 * hash) + getUnknownFields().hashCode();
        memoizedHashCode = hash;
        return hash;
      }

      public static com.google.cloud.aiplatform.v1beta1.ModelMonitoringInput.ModelMonitoringDataset
              .ModelMonitoringBigQuerySource
          parseFrom(java.nio.ByteBuffer data)
              throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data);
      }

      public static com.google.cloud.aiplatform.v1beta1.ModelMonitoringInput.ModelMonitoringDataset
              .ModelMonitoringBigQuerySource
          parseFrom(
              java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data, extensionRegistry);
      }

      public static com.google.cloud.aiplatform.v1beta1.ModelMonitoringInput.ModelMonitoringDataset
              .ModelMonitoringBigQuerySource
          parseFrom(com.google.protobuf.ByteString data)
              throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data);
      }

      public static com.google.cloud.aiplatform.v1beta1.ModelMonitoringInput.ModelMonitoringDataset
              .ModelMonitoringBigQuerySource
          parseFrom(
              com.google.protobuf.ByteString data,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data, extensionRegistry);
      }

      public static com.google.cloud.aiplatform.v1beta1.ModelMonitoringInput.ModelMonitoringDataset
              .ModelMonitoringBigQuerySource
          parseFrom(byte[] data) throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data);
      }

      public static com.google.cloud.aiplatform.v1beta1.ModelMonitoringInput.ModelMonitoringDataset
              .ModelMonitoringBigQuerySource
          parseFrom(byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data, extensionRegistry);
      }

      public static com.google.cloud.aiplatform.v1beta1.ModelMonitoringInput.ModelMonitoringDataset
              .ModelMonitoringBigQuerySource
          parseFrom(java.io.InputStream input) throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
      }

      public static com.google.cloud.aiplatform.v1beta1.ModelMonitoringInput.ModelMonitoringDataset
              .ModelMonitoringBigQuerySource
          parseFrom(
              java.io.InputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
            PARSER, input, extensionRegistry);
      }

      public static com.google.cloud.aiplatform.v1beta1.ModelMonitoringInput.ModelMonitoringDataset
              .ModelMonitoringBigQuerySource
          parseDelimitedFrom(java.io.InputStream input) throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
      }

      public static com.google.cloud.aiplatform.v1beta1.ModelMonitoringInput.ModelMonitoringDataset
              .ModelMonitoringBigQuerySource
          parseDelimitedFrom(
              java.io.InputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
            PARSER, input, extensionRegistry);
      }

      public static com.google.cloud.aiplatform.v1beta1.ModelMonitoringInput.ModelMonitoringDataset
              .ModelMonitoringBigQuerySource
          parseFrom(com.google.protobuf.CodedInputStream input) throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
      }

      public static com.google.cloud.aiplatform.v1beta1.ModelMonitoringInput.ModelMonitoringDataset
              .ModelMonitoringBigQuerySource
          parseFrom(
              com.google.protobuf.CodedInputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
            PARSER, input, extensionRegistry);
      }

      @java.lang.Override
      public Builder newBuilderForType() {
        return newBuilder();
      }

      public static Builder newBuilder() {
        return DEFAULT_INSTANCE.toBuilder();
      }

      public static Builder newBuilder(
          com.google.cloud.aiplatform.v1beta1.ModelMonitoringInput.ModelMonitoringDataset
                  .ModelMonitoringBigQuerySource
              prototype) {
        return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
      }

      @java.lang.Override
      public Builder toBuilder() {
        return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
      }

      @java.lang.Override
      protected Builder newBuilderForType(
          com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
        Builder builder = new Builder(parent);
        return builder;
      }
      /**
       *
       *
       * <pre>
       * Dataset spec for data sotred in BigQuery.
       * </pre>
       *
       * Protobuf type {@code
       * google.cloud.aiplatform.v1beta1.ModelMonitoringInput.ModelMonitoringDataset.ModelMonitoringBigQuerySource}
       */
      public static final class Builder
          extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
          implements
          // @@protoc_insertion_point(builder_implements:google.cloud.aiplatform.v1beta1.ModelMonitoringInput.ModelMonitoringDataset.ModelMonitoringBigQuerySource)
          com.google.cloud.aiplatform.v1beta1.ModelMonitoringInput.ModelMonitoringDataset
              .ModelMonitoringBigQuerySourceOrBuilder {
        public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
          return com.google.cloud.aiplatform.v1beta1.ModelMonitoringSpecProto
              .internal_static_google_cloud_aiplatform_v1beta1_ModelMonitoringInput_ModelMonitoringDataset_ModelMonitoringBigQuerySource_descriptor;
        }

        @java.lang.Override
        protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
            internalGetFieldAccessorTable() {
          return com.google.cloud.aiplatform.v1beta1.ModelMonitoringSpecProto
              .internal_static_google_cloud_aiplatform_v1beta1_ModelMonitoringInput_ModelMonitoringDataset_ModelMonitoringBigQuerySource_fieldAccessorTable
              .ensureFieldAccessorsInitialized(
                  com.google.cloud.aiplatform.v1beta1.ModelMonitoringInput.ModelMonitoringDataset
                      .ModelMonitoringBigQuerySource.class,
                  com.google.cloud.aiplatform.v1beta1.ModelMonitoringInput.ModelMonitoringDataset
                      .ModelMonitoringBigQuerySource.Builder.class);
        }

        // Construct using
        // com.google.cloud.aiplatform.v1beta1.ModelMonitoringInput.ModelMonitoringDataset.ModelMonitoringBigQuerySource.newBuilder()
        private Builder() {}

        private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
          super(parent);
        }

        @java.lang.Override
        public Builder clear() {
          super.clear();
          bitField0_ = 0;
          connectionCase_ = 0;
          connection_ = null;
          return this;
        }

        @java.lang.Override
        public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
          return com.google.cloud.aiplatform.v1beta1.ModelMonitoringSpecProto
              .internal_static_google_cloud_aiplatform_v1beta1_ModelMonitoringInput_ModelMonitoringDataset_ModelMonitoringBigQuerySource_descriptor;
        }

        @java.lang.Override
        public com.google.cloud.aiplatform.v1beta1.ModelMonitoringInput.ModelMonitoringDataset
                .ModelMonitoringBigQuerySource
            getDefaultInstanceForType() {
          return com.google.cloud.aiplatform.v1beta1.ModelMonitoringInput.ModelMonitoringDataset
              .ModelMonitoringBigQuerySource.getDefaultInstance();
        }

        @java.lang.Override
        public com.google.cloud.aiplatform.v1beta1.ModelMonitoringInput.ModelMonitoringDataset
                .ModelMonitoringBigQuerySource
            build() {
          com.google.cloud.aiplatform.v1beta1.ModelMonitoringInput.ModelMonitoringDataset
                  .ModelMonitoringBigQuerySource
              result = buildPartial();
          if (!result.isInitialized()) {
            throw newUninitializedMessageException(result);
          }
          return result;
        }

        @java.lang.Override
        public com.google.cloud.aiplatform.v1beta1.ModelMonitoringInput.ModelMonitoringDataset
                .ModelMonitoringBigQuerySource
            buildPartial() {
          com.google.cloud.aiplatform.v1beta1.ModelMonitoringInput.ModelMonitoringDataset
                  .ModelMonitoringBigQuerySource
              result =
                  new com.google.cloud.aiplatform.v1beta1.ModelMonitoringInput
                      .ModelMonitoringDataset.ModelMonitoringBigQuerySource(this);
          if (bitField0_ != 0) {
            buildPartial0(result);
          }
          buildPartialOneofs(result);
          onBuilt();
          return result;
        }

        private void buildPartial0(
            com.google.cloud.aiplatform.v1beta1.ModelMonitoringInput.ModelMonitoringDataset
                    .ModelMonitoringBigQuerySource
                result) {
          int from_bitField0_ = bitField0_;
        }

        private void buildPartialOneofs(
            com.google.cloud.aiplatform.v1beta1.ModelMonitoringInput.ModelMonitoringDataset
                    .ModelMonitoringBigQuerySource
                result) {
          result.connectionCase_ = connectionCase_;
          result.connection_ = this.connection_;
        }

        @java.lang.Override
        public Builder clone() {
          return super.clone();
        }

        @java.lang.Override
        public Builder setField(
            com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
          return super.setField(field, value);
        }

        @java.lang.Override
        public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
          return super.clearField(field);
        }

        @java.lang.Override
        public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
          return super.clearOneof(oneof);
        }

        @java.lang.Override
        public Builder setRepeatedField(
            com.google.protobuf.Descriptors.FieldDescriptor field,
            int index,
            java.lang.Object value) {
          return super.setRepeatedField(field, index, value);
        }

        @java.lang.Override
        public Builder addRepeatedField(
            com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
          return super.addRepeatedField(field, value);
        }

        @java.lang.Override
        public Builder mergeFrom(com.google.protobuf.Message other) {
          if (other
              instanceof
              com.google.cloud.aiplatform.v1beta1.ModelMonitoringInput.ModelMonitoringDataset
                  .ModelMonitoringBigQuerySource) {
            return mergeFrom(
                (com.google.cloud.aiplatform.v1beta1.ModelMonitoringInput.ModelMonitoringDataset
                        .ModelMonitoringBigQuerySource)
                    other);
          } else {
            super.mergeFrom(other);
            return this;
          }
        }

        public Builder mergeFrom(
            com.google.cloud.aiplatform.v1beta1.ModelMonitoringInput.ModelMonitoringDataset
                    .ModelMonitoringBigQuerySource
                other) {
          if (other
              == com.google.cloud.aiplatform.v1beta1.ModelMonitoringInput.ModelMonitoringDataset
                  .ModelMonitoringBigQuerySource.getDefaultInstance()) return this;
          switch (other.getConnectionCase()) {
            case TABLE_URI:
              {
                connectionCase_ = 1;
                connection_ = other.connection_;
                onChanged();
                break;
              }
            case QUERY:
              {
                connectionCase_ = 2;
                connection_ = other.connection_;
                onChanged();
                break;
              }
            case CONNECTION_NOT_SET:
              {
                break;
              }
          }
          this.mergeUnknownFields(other.getUnknownFields());
          onChanged();
          return this;
        }

        @java.lang.Override
        public final boolean isInitialized() {
          return true;
        }

        @java.lang.Override
        public Builder mergeFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws java.io.IOException {
          if (extensionRegistry == null) {
            throw new java.lang.NullPointerException();
          }
          try {
            boolean done = false;
            while (!done) {
              int tag = input.readTag();
              switch (tag) {
                case 0:
                  done = true;
                  break;
                case 10:
                  {
                    java.lang.String s = input.readStringRequireUtf8();
                    connectionCase_ = 1;
                    connection_ = s;
                    break;
                  } // case 10
                case 18:
                  {
                    java.lang.String s = input.readStringRequireUtf8();
                    connectionCase_ = 2;
                    connection_ = s;
                    break;
                  } // case 18
                default:
                  {
                    if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                      done = true; // was an endgroup tag
                    }
                    break;
                  } // default:
              } // switch (tag)
            } // while (!done)
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.unwrapIOException();
          } finally {
            onChanged();
          } // finally
          return this;
        }

        private int connectionCase_ = 0;
        private java.lang.Object connection_;

        public ConnectionCase getConnectionCase() {
          return ConnectionCase.forNumber(connectionCase_);
        }

        public Builder clearConnection() {
          connectionCase_ = 0;
          connection_ = null;
          onChanged();
          return this;
        }

        private int bitField0_;

        /**
         *
         *
         * <pre>
         * BigQuery URI to a table, up to 2000 characters long. All the columns
         * in the table will be selected. Accepted forms:
         *
         * *  BigQuery path. For example:
         * `bq://projectId.bqDatasetId.bqTableId`.
         * </pre>
         *
         * <code>string table_uri = 1;</code>
         *
         * @return Whether the tableUri field is set.
         */
        @java.lang.Override
        public boolean hasTableUri() {
          return connectionCase_ == 1;
        }
        /**
         *
         *
         * <pre>
         * BigQuery URI to a table, up to 2000 characters long. All the columns
         * in the table will be selected. Accepted forms:
         *
         * *  BigQuery path. For example:
         * `bq://projectId.bqDatasetId.bqTableId`.
         * </pre>
         *
         * <code>string table_uri = 1;</code>
         *
         * @return The tableUri.
         */
        @java.lang.Override
        public java.lang.String getTableUri() {
          java.lang.Object ref = "";
          if (connectionCase_ == 1) {
            ref = connection_;
          }
          if (!(ref instanceof java.lang.String)) {
            com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
            java.lang.String s = bs.toStringUtf8();
            if (connectionCase_ == 1) {
              connection_ = s;
            }
            return s;
          } else {
            return (java.lang.String) ref;
          }
        }
        /**
         *
         *
         * <pre>
         * BigQuery URI to a table, up to 2000 characters long. All the columns
         * in the table will be selected. Accepted forms:
         *
         * *  BigQuery path. For example:
         * `bq://projectId.bqDatasetId.bqTableId`.
         * </pre>
         *
         * <code>string table_uri = 1;</code>
         *
         * @return The bytes for tableUri.
         */
        @java.lang.Override
        public com.google.protobuf.ByteString getTableUriBytes() {
          java.lang.Object ref = "";
          if (connectionCase_ == 1) {
            ref = connection_;
          }
          if (ref instanceof String) {
            com.google.protobuf.ByteString b =
                com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
            if (connectionCase_ == 1) {
              connection_ = b;
            }
            return b;
          } else {
            return (com.google.protobuf.ByteString) ref;
          }
        }
        /**
         *
         *
         * <pre>
         * BigQuery URI to a table, up to 2000 characters long. All the columns
         * in the table will be selected. Accepted forms:
         *
         * *  BigQuery path. For example:
         * `bq://projectId.bqDatasetId.bqTableId`.
         * </pre>
         *
         * <code>string table_uri = 1;</code>
         *
         * @param value The tableUri to set.
         * @return This builder for chaining.
         */
        public Builder setTableUri(java.lang.String value) {
          if (value == null) {
            throw new NullPointerException();
          }
          connectionCase_ = 1;
          connection_ = value;
          onChanged();
          return this;
        }
        /**
         *
         *
         * <pre>
         * BigQuery URI to a table, up to 2000 characters long. All the columns
         * in the table will be selected. Accepted forms:
         *
         * *  BigQuery path. For example:
         * `bq://projectId.bqDatasetId.bqTableId`.
         * </pre>
         *
         * <code>string table_uri = 1;</code>
         *
         * @return This builder for chaining.
         */
        public Builder clearTableUri() {
          if (connectionCase_ == 1) {
            connectionCase_ = 0;
            connection_ = null;
            onChanged();
          }
          return this;
        }
        /**
         *
         *
         * <pre>
         * BigQuery URI to a table, up to 2000 characters long. All the columns
         * in the table will be selected. Accepted forms:
         *
         * *  BigQuery path. For example:
         * `bq://projectId.bqDatasetId.bqTableId`.
         * </pre>
         *
         * <code>string table_uri = 1;</code>
         *
         * @param value The bytes for tableUri to set.
         * @return This builder for chaining.
         */
        public Builder setTableUriBytes(com.google.protobuf.ByteString value) {
          if (value == null) {
            throw new NullPointerException();
          }
          checkByteStringIsUtf8(value);
          connectionCase_ = 1;
          connection_ = value;
          onChanged();
          return this;
        }

        /**
         *
         *
         * <pre>
         * Standard SQL to be used instead of the `table_uri`.
         * </pre>
         *
         * <code>string query = 2;</code>
         *
         * @return Whether the query field is set.
         */
        @java.lang.Override
        public boolean hasQuery() {
          return connectionCase_ == 2;
        }
        /**
         *
         *
         * <pre>
         * Standard SQL to be used instead of the `table_uri`.
         * </pre>
         *
         * <code>string query = 2;</code>
         *
         * @return The query.
         */
        @java.lang.Override
        public java.lang.String getQuery() {
          java.lang.Object ref = "";
          if (connectionCase_ == 2) {
            ref = connection_;
          }
          if (!(ref instanceof java.lang.String)) {
            com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
            java.lang.String s = bs.toStringUtf8();
            if (connectionCase_ == 2) {
              connection_ = s;
            }
            return s;
          } else {
            return (java.lang.String) ref;
          }
        }
        /**
         *
         *
         * <pre>
         * Standard SQL to be used instead of the `table_uri`.
         * </pre>
         *
         * <code>string query = 2;</code>
         *
         * @return The bytes for query.
         */
        @java.lang.Override
        public com.google.protobuf.ByteString getQueryBytes() {
          java.lang.Object ref = "";
          if (connectionCase_ == 2) {
            ref = connection_;
          }
          if (ref instanceof String) {
            com.google.protobuf.ByteString b =
                com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
            if (connectionCase_ == 2) {
              connection_ = b;
            }
            return b;
          } else {
            return (com.google.protobuf.ByteString) ref;
          }
        }
        /**
         *
         *
         * <pre>
         * Standard SQL to be used instead of the `table_uri`.
         * </pre>
         *
         * <code>string query = 2;</code>
         *
         * @param value The query to set.
         * @return This builder for chaining.
         */
        public Builder setQuery(java.lang.String value) {
          if (value == null) {
            throw new NullPointerException();
          }
          connectionCase_ = 2;
          connection_ = value;
          onChanged();
          return this;
        }
        /**
         *
         *
         * <pre>
         * Standard SQL to be used instead of the `table_uri`.
         * </pre>
         *
         * <code>string query = 2;</code>
         *
         * @return This builder for chaining.
         */
        public Builder clearQuery() {
          if (connectionCase_ == 2) {
            connectionCase_ = 0;
            connection_ = null;
            onChanged();
          }
          return this;
        }
        /**
         *
         *
         * <pre>
         * Standard SQL to be used instead of the `table_uri`.
         * </pre>
         *
         * <code>string query = 2;</code>
         *
         * @param value The bytes for query to set.
         * @return This builder for chaining.
         */
        public Builder setQueryBytes(com.google.protobuf.ByteString value) {
          if (value == null) {
            throw new NullPointerException();
          }
          checkByteStringIsUtf8(value);
          connectionCase_ = 2;
          connection_ = value;
          onChanged();
          return this;
        }

        @java.lang.Override
        public final Builder setUnknownFields(
            final com.google.protobuf.UnknownFieldSet unknownFields) {
          return super.setUnknownFields(unknownFields);
        }

        @java.lang.Override
        public final Builder mergeUnknownFields(
            final com.google.protobuf.UnknownFieldSet unknownFields) {
          return super.mergeUnknownFields(unknownFields);
        }

        // @@protoc_insertion_point(builder_scope:google.cloud.aiplatform.v1beta1.ModelMonitoringInput.ModelMonitoringDataset.ModelMonitoringBigQuerySource)
      }

      // @@protoc_insertion_point(class_scope:google.cloud.aiplatform.v1beta1.ModelMonitoringInput.ModelMonitoringDataset.ModelMonitoringBigQuerySource)
      private static final com.google.cloud.aiplatform.v1beta1.ModelMonitoringInput
              .ModelMonitoringDataset.ModelMonitoringBigQuerySource
          DEFAULT_INSTANCE;

      static {
        DEFAULT_INSTANCE =
            new com.google.cloud.aiplatform.v1beta1.ModelMonitoringInput.ModelMonitoringDataset
                .ModelMonitoringBigQuerySource();
      }

      public static com.google.cloud.aiplatform.v1beta1.ModelMonitoringInput.ModelMonitoringDataset
              .ModelMonitoringBigQuerySource
          getDefaultInstance() {
        return DEFAULT_INSTANCE;
      }

      private static final com.google.protobuf.Parser<ModelMonitoringBigQuerySource> PARSER =
          new com.google.protobuf.AbstractParser<ModelMonitoringBigQuerySource>() {
            @java.lang.Override
            public ModelMonitoringBigQuerySource parsePartialFrom(
                com.google.protobuf.CodedInputStream input,
                com.google.protobuf.ExtensionRegistryLite extensionRegistry)
                throws com.google.protobuf.InvalidProtocolBufferException {
              Builder builder = newBuilder();
              try {
                builder.mergeFrom(input, extensionRegistry);
              } catch (com.google.protobuf.InvalidProtocolBufferException e) {
                throw e.setUnfinishedMessage(builder.buildPartial());
              } catch (com.google.protobuf.UninitializedMessageException e) {
                throw e.asInvalidProtocolBufferException()
                    .setUnfinishedMessage(builder.buildPartial());
              } catch (java.io.IOException e) {
                throw new com.google.protobuf.InvalidProtocolBufferException(e)
                    .setUnfinishedMessage(builder.buildPartial());
              }
              return builder.buildPartial();
            }
          };

      public static com.google.protobuf.Parser<ModelMonitoringBigQuerySource> parser() {
        return PARSER;
      }

      @java.lang.Override
      public com.google.protobuf.Parser<ModelMonitoringBigQuerySource> getParserForType() {
        return PARSER;
      }

      @java.lang.Override
      public com.google.cloud.aiplatform.v1beta1.ModelMonitoringInput.ModelMonitoringDataset
              .ModelMonitoringBigQuerySource
          getDefaultInstanceForType() {
        return DEFAULT_INSTANCE;
      }
    }

    private int dataLocationCase_ = 0;

    @SuppressWarnings("serial")
    private java.lang.Object dataLocation_;

    public enum DataLocationCase
        implements
            com.google.protobuf.Internal.EnumLite,
            com.google.protobuf.AbstractMessage.InternalOneOfEnum {
      VERTEX_DATASET(1),
      GCS_SOURCE(2),
      BIGQUERY_SOURCE(6),
      DATALOCATION_NOT_SET(0);
      private final int value;

      private DataLocationCase(int value) {
        this.value = value;
      }
      /**
       * @param value The number of the enum to look for.
       * @return The enum associated with the given number.
       * @deprecated Use {@link #forNumber(int)} instead.
       */
      @java.lang.Deprecated
      public static DataLocationCase valueOf(int value) {
        return forNumber(value);
      }

      public static DataLocationCase forNumber(int value) {
        switch (value) {
          case 1:
            return VERTEX_DATASET;
          case 2:
            return GCS_SOURCE;
          case 6:
            return BIGQUERY_SOURCE;
          case 0:
            return DATALOCATION_NOT_SET;
          default:
            return null;
        }
      }

      public int getNumber() {
        return this.value;
      }
    };

    public DataLocationCase getDataLocationCase() {
      return DataLocationCase.forNumber(dataLocationCase_);
    }

    public static final int VERTEX_DATASET_FIELD_NUMBER = 1;
    /**
     *
     *
     * <pre>
     * Resource name of the Vertex AI managed dataset.
     * </pre>
     *
     * <code>string vertex_dataset = 1 [(.google.api.resource_reference) = { ... }</code>
     *
     * @return Whether the vertexDataset field is set.
     */
    public boolean hasVertexDataset() {
      return dataLocationCase_ == 1;
    }
    /**
     *
     *
     * <pre>
     * Resource name of the Vertex AI managed dataset.
     * </pre>
     *
     * <code>string vertex_dataset = 1 [(.google.api.resource_reference) = { ... }</code>
     *
     * @return The vertexDataset.
     */
    public java.lang.String getVertexDataset() {
      java.lang.Object ref = "";
      if (dataLocationCase_ == 1) {
        ref = dataLocation_;
      }
      if (ref instanceof java.lang.String) {
        return (java.lang.String) ref;
      } else {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        if (dataLocationCase_ == 1) {
          dataLocation_ = s;
        }
        return s;
      }
    }
    /**
     *
     *
     * <pre>
     * Resource name of the Vertex AI managed dataset.
     * </pre>
     *
     * <code>string vertex_dataset = 1 [(.google.api.resource_reference) = { ... }</code>
     *
     * @return The bytes for vertexDataset.
     */
    public com.google.protobuf.ByteString getVertexDatasetBytes() {
      java.lang.Object ref = "";
      if (dataLocationCase_ == 1) {
        ref = dataLocation_;
      }
      if (ref instanceof java.lang.String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        if (dataLocationCase_ == 1) {
          dataLocation_ = b;
        }
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    public static final int GCS_SOURCE_FIELD_NUMBER = 2;
    /**
     *
     *
     * <pre>
     * Google Cloud Storage data source.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.ModelMonitoringInput.ModelMonitoringDataset.ModelMonitoringGcsSource gcs_source = 2;
     * </code>
     *
     * @return Whether the gcsSource field is set.
     */
    @java.lang.Override
    public boolean hasGcsSource() {
      return dataLocationCase_ == 2;
    }
    /**
     *
     *
     * <pre>
     * Google Cloud Storage data source.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.ModelMonitoringInput.ModelMonitoringDataset.ModelMonitoringGcsSource gcs_source = 2;
     * </code>
     *
     * @return The gcsSource.
     */
    @java.lang.Override
    public com.google.cloud.aiplatform.v1beta1.ModelMonitoringInput.ModelMonitoringDataset
            .ModelMonitoringGcsSource
        getGcsSource() {
      if (dataLocationCase_ == 2) {
        return (com.google.cloud.aiplatform.v1beta1.ModelMonitoringInput.ModelMonitoringDataset
                .ModelMonitoringGcsSource)
            dataLocation_;
      }
      return com.google.cloud.aiplatform.v1beta1.ModelMonitoringInput.ModelMonitoringDataset
          .ModelMonitoringGcsSource.getDefaultInstance();
    }
    /**
     *
     *
     * <pre>
     * Google Cloud Storage data source.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.ModelMonitoringInput.ModelMonitoringDataset.ModelMonitoringGcsSource gcs_source = 2;
     * </code>
     */
    @java.lang.Override
    public com.google.cloud.aiplatform.v1beta1.ModelMonitoringInput.ModelMonitoringDataset
            .ModelMonitoringGcsSourceOrBuilder
        getGcsSourceOrBuilder() {
      if (dataLocationCase_ == 2) {
        return (com.google.cloud.aiplatform.v1beta1.ModelMonitoringInput.ModelMonitoringDataset
                .ModelMonitoringGcsSource)
            dataLocation_;
      }
      return com.google.cloud.aiplatform.v1beta1.ModelMonitoringInput.ModelMonitoringDataset
          .ModelMonitoringGcsSource.getDefaultInstance();
    }

    public static final int BIGQUERY_SOURCE_FIELD_NUMBER = 6;
    /**
     *
     *
     * <pre>
     * BigQuery data source.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.ModelMonitoringInput.ModelMonitoringDataset.ModelMonitoringBigQuerySource bigquery_source = 6;
     * </code>
     *
     * @return Whether the bigquerySource field is set.
     */
    @java.lang.Override
    public boolean hasBigquerySource() {
      return dataLocationCase_ == 6;
    }
    /**
     *
     *
     * <pre>
     * BigQuery data source.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.ModelMonitoringInput.ModelMonitoringDataset.ModelMonitoringBigQuerySource bigquery_source = 6;
     * </code>
     *
     * @return The bigquerySource.
     */
    @java.lang.Override
    public com.google.cloud.aiplatform.v1beta1.ModelMonitoringInput.ModelMonitoringDataset
            .ModelMonitoringBigQuerySource
        getBigquerySource() {
      if (dataLocationCase_ == 6) {
        return (com.google.cloud.aiplatform.v1beta1.ModelMonitoringInput.ModelMonitoringDataset
                .ModelMonitoringBigQuerySource)
            dataLocation_;
      }
      return com.google.cloud.aiplatform.v1beta1.ModelMonitoringInput.ModelMonitoringDataset
          .ModelMonitoringBigQuerySource.getDefaultInstance();
    }
    /**
     *
     *
     * <pre>
     * BigQuery data source.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.ModelMonitoringInput.ModelMonitoringDataset.ModelMonitoringBigQuerySource bigquery_source = 6;
     * </code>
     */
    @java.lang.Override
    public com.google.cloud.aiplatform.v1beta1.ModelMonitoringInput.ModelMonitoringDataset
            .ModelMonitoringBigQuerySourceOrBuilder
        getBigquerySourceOrBuilder() {
      if (dataLocationCase_ == 6) {
        return (com.google.cloud.aiplatform.v1beta1.ModelMonitoringInput.ModelMonitoringDataset
                .ModelMonitoringBigQuerySource)
            dataLocation_;
      }
      return com.google.cloud.aiplatform.v1beta1.ModelMonitoringInput.ModelMonitoringDataset
          .ModelMonitoringBigQuerySource.getDefaultInstance();
    }

    public static final int TIMESTAMP_FIELD_FIELD_NUMBER = 7;

    @SuppressWarnings("serial")
    private volatile java.lang.Object timestampField_ = "";
    /**
     *
     *
     * <pre>
     * The timestamp field. Usually for serving data.
     * </pre>
     *
     * <code>string timestamp_field = 7;</code>
     *
     * @return The timestampField.
     */
    @java.lang.Override
    public java.lang.String getTimestampField() {
      java.lang.Object ref = timestampField_;
      if (ref instanceof java.lang.String) {
        return (java.lang.String) ref;
      } else {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        timestampField_ = s;
        return s;
      }
    }
    /**
     *
     *
     * <pre>
     * The timestamp field. Usually for serving data.
     * </pre>
     *
     * <code>string timestamp_field = 7;</code>
     *
     * @return The bytes for timestampField.
     */
    @java.lang.Override
    public com.google.protobuf.ByteString getTimestampFieldBytes() {
      java.lang.Object ref = timestampField_;
      if (ref instanceof java.lang.String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        timestampField_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    private byte memoizedIsInitialized = -1;

    @java.lang.Override
    public final boolean isInitialized() {
      byte isInitialized = memoizedIsInitialized;
      if (isInitialized == 1) return true;
      if (isInitialized == 0) return false;

      memoizedIsInitialized = 1;
      return true;
    }

    @java.lang.Override
    public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
      if (dataLocationCase_ == 1) {
        com.google.protobuf.GeneratedMessageV3.writeString(output, 1, dataLocation_);
      }
      if (dataLocationCase_ == 2) {
        output.writeMessage(
            2,
            (com.google.cloud.aiplatform.v1beta1.ModelMonitoringInput.ModelMonitoringDataset
                    .ModelMonitoringGcsSource)
                dataLocation_);
      }
      if (dataLocationCase_ == 6) {
        output.writeMessage(
            6,
            (com.google.cloud.aiplatform.v1beta1.ModelMonitoringInput.ModelMonitoringDataset
                    .ModelMonitoringBigQuerySource)
                dataLocation_);
      }
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(timestampField_)) {
        com.google.protobuf.GeneratedMessageV3.writeString(output, 7, timestampField_);
      }
      getUnknownFields().writeTo(output);
    }

    @java.lang.Override
    public int getSerializedSize() {
      int size = memoizedSize;
      if (size != -1) return size;

      size = 0;
      if (dataLocationCase_ == 1) {
        size += com.google.protobuf.GeneratedMessageV3.computeStringSize(1, dataLocation_);
      }
      if (dataLocationCase_ == 2) {
        size +=
            com.google.protobuf.CodedOutputStream.computeMessageSize(
                2,
                (com.google.cloud.aiplatform.v1beta1.ModelMonitoringInput.ModelMonitoringDataset
                        .ModelMonitoringGcsSource)
                    dataLocation_);
      }
      if (dataLocationCase_ == 6) {
        size +=
            com.google.protobuf.CodedOutputStream.computeMessageSize(
                6,
                (com.google.cloud.aiplatform.v1beta1.ModelMonitoringInput.ModelMonitoringDataset
                        .ModelMonitoringBigQuerySource)
                    dataLocation_);
      }
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(timestampField_)) {
        size += com.google.protobuf.GeneratedMessageV3.computeStringSize(7, timestampField_);
      }
      size += getUnknownFields().getSerializedSize();
      memoizedSize = size;
      return size;
    }

    @java.lang.Override
    public boolean equals(final java.lang.Object obj) {
      if (obj == this) {
        return true;
      }
      if (!(obj
          instanceof
          com.google.cloud.aiplatform.v1beta1.ModelMonitoringInput.ModelMonitoringDataset)) {
        return super.equals(obj);
      }
      com.google.cloud.aiplatform.v1beta1.ModelMonitoringInput.ModelMonitoringDataset other =
          (com.google.cloud.aiplatform.v1beta1.ModelMonitoringInput.ModelMonitoringDataset) obj;

      if (!getTimestampField().equals(other.getTimestampField())) return false;
      if (!getDataLocationCase().equals(other.getDataLocationCase())) return false;
      switch (dataLocationCase_) {
        case 1:
          if (!getVertexDataset().equals(other.getVertexDataset())) return false;
          break;
        case 2:
          if (!getGcsSource().equals(other.getGcsSource())) return false;
          break;
        case 6:
          if (!getBigquerySource().equals(other.getBigquerySource())) return false;
          break;
        case 0:
        default:
      }
      if (!getUnknownFields().equals(other.getUnknownFields())) return false;
      return true;
    }

    @java.lang.Override
    public int hashCode() {
      if (memoizedHashCode != 0) {
        return memoizedHashCode;
      }
      int hash = 41;
      hash = (19 * hash) + getDescriptor().hashCode();
      hash = (37 * hash) + TIMESTAMP_FIELD_FIELD_NUMBER;
      hash = (53 * hash) + getTimestampField().hashCode();
      switch (dataLocationCase_) {
        case 1:
          hash = (37 * hash) + VERTEX_DATASET_FIELD_NUMBER;
          hash = (53 * hash) + getVertexDataset().hashCode();
          break;
        case 2:
          hash = (37 * hash) + GCS_SOURCE_FIELD_NUMBER;
          hash = (53 * hash) + getGcsSource().hashCode();
          break;
        case 6:
          hash = (37 * hash) + BIGQUERY_SOURCE_FIELD_NUMBER;
          hash = (53 * hash) + getBigquerySource().hashCode();
          break;
        case 0:
        default:
      }
      hash = (29 * hash) + getUnknownFields().hashCode();
      memoizedHashCode = hash;
      return hash;
    }

    public static com.google.cloud.aiplatform.v1beta1.ModelMonitoringInput.ModelMonitoringDataset
        parseFrom(java.nio.ByteBuffer data)
            throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.aiplatform.v1beta1.ModelMonitoringInput.ModelMonitoringDataset
        parseFrom(
            java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.aiplatform.v1beta1.ModelMonitoringInput.ModelMonitoringDataset
        parseFrom(com.google.protobuf.ByteString data)
            throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.aiplatform.v1beta1.ModelMonitoringInput.ModelMonitoringDataset
        parseFrom(
            com.google.protobuf.ByteString data,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.aiplatform.v1beta1.ModelMonitoringInput.ModelMonitoringDataset
        parseFrom(byte[] data) throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.aiplatform.v1beta1.ModelMonitoringInput.ModelMonitoringDataset
        parseFrom(byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.aiplatform.v1beta1.ModelMonitoringInput.ModelMonitoringDataset
        parseFrom(java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.cloud.aiplatform.v1beta1.ModelMonitoringInput.ModelMonitoringDataset
        parseFrom(
            java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.cloud.aiplatform.v1beta1.ModelMonitoringInput.ModelMonitoringDataset
        parseDelimitedFrom(java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
    }

    public static com.google.cloud.aiplatform.v1beta1.ModelMonitoringInput.ModelMonitoringDataset
        parseDelimitedFrom(
            java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.cloud.aiplatform.v1beta1.ModelMonitoringInput.ModelMonitoringDataset
        parseFrom(com.google.protobuf.CodedInputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.cloud.aiplatform.v1beta1.ModelMonitoringInput.ModelMonitoringDataset
        parseFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    @java.lang.Override
    public Builder newBuilderForType() {
      return newBuilder();
    }

    public static Builder newBuilder() {
      return DEFAULT_INSTANCE.toBuilder();
    }

    public static Builder newBuilder(
        com.google.cloud.aiplatform.v1beta1.ModelMonitoringInput.ModelMonitoringDataset prototype) {
      return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }

    @java.lang.Override
    public Builder toBuilder() {
      return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
    }

    @java.lang.Override
    protected Builder newBuilderForType(
        com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      Builder builder = new Builder(parent);
      return builder;
    }
    /**
     *
     *
     * <pre>
     * Input dataset spec.
     * </pre>
     *
     * Protobuf type {@code
     * google.cloud.aiplatform.v1beta1.ModelMonitoringInput.ModelMonitoringDataset}
     */
    public static final class Builder
        extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
        implements
        // @@protoc_insertion_point(builder_implements:google.cloud.aiplatform.v1beta1.ModelMonitoringInput.ModelMonitoringDataset)
        com.google.cloud.aiplatform.v1beta1.ModelMonitoringInput.ModelMonitoringDatasetOrBuilder {
      public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
        return com.google.cloud.aiplatform.v1beta1.ModelMonitoringSpecProto
            .internal_static_google_cloud_aiplatform_v1beta1_ModelMonitoringInput_ModelMonitoringDataset_descriptor;
      }

      @java.lang.Override
      protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return com.google.cloud.aiplatform.v1beta1.ModelMonitoringSpecProto
            .internal_static_google_cloud_aiplatform_v1beta1_ModelMonitoringInput_ModelMonitoringDataset_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                com.google.cloud.aiplatform.v1beta1.ModelMonitoringInput.ModelMonitoringDataset
                    .class,
                com.google.cloud.aiplatform.v1beta1.ModelMonitoringInput.ModelMonitoringDataset
                    .Builder.class);
      }

      // Construct using
      // com.google.cloud.aiplatform.v1beta1.ModelMonitoringInput.ModelMonitoringDataset.newBuilder()
      private Builder() {}

      private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
        super(parent);
      }

      @java.lang.Override
      public Builder clear() {
        super.clear();
        bitField0_ = 0;
        if (gcsSourceBuilder_ != null) {
          gcsSourceBuilder_.clear();
        }
        if (bigquerySourceBuilder_ != null) {
          bigquerySourceBuilder_.clear();
        }
        timestampField_ = "";
        dataLocationCase_ = 0;
        dataLocation_ = null;
        return this;
      }

      @java.lang.Override
      public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
        return com.google.cloud.aiplatform.v1beta1.ModelMonitoringSpecProto
            .internal_static_google_cloud_aiplatform_v1beta1_ModelMonitoringInput_ModelMonitoringDataset_descriptor;
      }

      @java.lang.Override
      public com.google.cloud.aiplatform.v1beta1.ModelMonitoringInput.ModelMonitoringDataset
          getDefaultInstanceForType() {
        return com.google.cloud.aiplatform.v1beta1.ModelMonitoringInput.ModelMonitoringDataset
            .getDefaultInstance();
      }

      @java.lang.Override
      public com.google.cloud.aiplatform.v1beta1.ModelMonitoringInput.ModelMonitoringDataset
          build() {
        com.google.cloud.aiplatform.v1beta1.ModelMonitoringInput.ModelMonitoringDataset result =
            buildPartial();
        if (!result.isInitialized()) {
          throw newUninitializedMessageException(result);
        }
        return result;
      }

      @java.lang.Override
      public com.google.cloud.aiplatform.v1beta1.ModelMonitoringInput.ModelMonitoringDataset
          buildPartial() {
        com.google.cloud.aiplatform.v1beta1.ModelMonitoringInput.ModelMonitoringDataset result =
            new com.google.cloud.aiplatform.v1beta1.ModelMonitoringInput.ModelMonitoringDataset(
                this);
        if (bitField0_ != 0) {
          buildPartial0(result);
        }
        buildPartialOneofs(result);
        onBuilt();
        return result;
      }

      private void buildPartial0(
          com.google.cloud.aiplatform.v1beta1.ModelMonitoringInput.ModelMonitoringDataset result) {
        int from_bitField0_ = bitField0_;
        if (((from_bitField0_ & 0x00000008) != 0)) {
          result.timestampField_ = timestampField_;
        }
      }

      private void buildPartialOneofs(
          com.google.cloud.aiplatform.v1beta1.ModelMonitoringInput.ModelMonitoringDataset result) {
        result.dataLocationCase_ = dataLocationCase_;
        result.dataLocation_ = this.dataLocation_;
        if (dataLocationCase_ == 2 && gcsSourceBuilder_ != null) {
          result.dataLocation_ = gcsSourceBuilder_.build();
        }
        if (dataLocationCase_ == 6 && bigquerySourceBuilder_ != null) {
          result.dataLocation_ = bigquerySourceBuilder_.build();
        }
      }

      @java.lang.Override
      public Builder clone() {
        return super.clone();
      }

      @java.lang.Override
      public Builder setField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.setField(field, value);
      }

      @java.lang.Override
      public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
        return super.clearField(field);
      }

      @java.lang.Override
      public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
        return super.clearOneof(oneof);
      }

      @java.lang.Override
      public Builder setRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          int index,
          java.lang.Object value) {
        return super.setRepeatedField(field, index, value);
      }

      @java.lang.Override
      public Builder addRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.addRepeatedField(field, value);
      }

      @java.lang.Override
      public Builder mergeFrom(com.google.protobuf.Message other) {
        if (other
            instanceof
            com.google.cloud.aiplatform.v1beta1.ModelMonitoringInput.ModelMonitoringDataset) {
          return mergeFrom(
              (com.google.cloud.aiplatform.v1beta1.ModelMonitoringInput.ModelMonitoringDataset)
                  other);
        } else {
          super.mergeFrom(other);
          return this;
        }
      }

      public Builder mergeFrom(
          com.google.cloud.aiplatform.v1beta1.ModelMonitoringInput.ModelMonitoringDataset other) {
        if (other
            == com.google.cloud.aiplatform.v1beta1.ModelMonitoringInput.ModelMonitoringDataset
                .getDefaultInstance()) return this;
        if (!other.getTimestampField().isEmpty()) {
          timestampField_ = other.timestampField_;
          bitField0_ |= 0x00000008;
          onChanged();
        }
        switch (other.getDataLocationCase()) {
          case VERTEX_DATASET:
            {
              dataLocationCase_ = 1;
              dataLocation_ = other.dataLocation_;
              onChanged();
              break;
            }
          case GCS_SOURCE:
            {
              mergeGcsSource(other.getGcsSource());
              break;
            }
          case BIGQUERY_SOURCE:
            {
              mergeBigquerySource(other.getBigquerySource());
              break;
            }
          case DATALOCATION_NOT_SET:
            {
              break;
            }
        }
        this.mergeUnknownFields(other.getUnknownFields());
        onChanged();
        return this;
      }

      @java.lang.Override
      public final boolean isInitialized() {
        return true;
      }

      @java.lang.Override
      public Builder mergeFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        if (extensionRegistry == null) {
          throw new java.lang.NullPointerException();
        }
        try {
          boolean done = false;
          while (!done) {
            int tag = input.readTag();
            switch (tag) {
              case 0:
                done = true;
                break;
              case 10:
                {
                  java.lang.String s = input.readStringRequireUtf8();
                  dataLocationCase_ = 1;
                  dataLocation_ = s;
                  break;
                } // case 10
              case 18:
                {
                  input.readMessage(getGcsSourceFieldBuilder().getBuilder(), extensionRegistry);
                  dataLocationCase_ = 2;
                  break;
                } // case 18
              case 50:
                {
                  input.readMessage(
                      getBigquerySourceFieldBuilder().getBuilder(), extensionRegistry);
                  dataLocationCase_ = 6;
                  break;
                } // case 50
              case 58:
                {
                  timestampField_ = input.readStringRequireUtf8();
                  bitField0_ |= 0x00000008;
                  break;
                } // case 58
              default:
                {
                  if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                    done = true; // was an endgroup tag
                  }
                  break;
                } // default:
            } // switch (tag)
          } // while (!done)
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          throw e.unwrapIOException();
        } finally {
          onChanged();
        } // finally
        return this;
      }

      private int dataLocationCase_ = 0;
      private java.lang.Object dataLocation_;

      public DataLocationCase getDataLocationCase() {
        return DataLocationCase.forNumber(dataLocationCase_);
      }

      public Builder clearDataLocation() {
        dataLocationCase_ = 0;
        dataLocation_ = null;
        onChanged();
        return this;
      }

      private int bitField0_;

      /**
       *
       *
       * <pre>
       * Resource name of the Vertex AI managed dataset.
       * </pre>
       *
       * <code>string vertex_dataset = 1 [(.google.api.resource_reference) = { ... }</code>
       *
       * @return Whether the vertexDataset field is set.
       */
      @java.lang.Override
      public boolean hasVertexDataset() {
        return dataLocationCase_ == 1;
      }
      /**
       *
       *
       * <pre>
       * Resource name of the Vertex AI managed dataset.
       * </pre>
       *
       * <code>string vertex_dataset = 1 [(.google.api.resource_reference) = { ... }</code>
       *
       * @return The vertexDataset.
       */
      @java.lang.Override
      public java.lang.String getVertexDataset() {
        java.lang.Object ref = "";
        if (dataLocationCase_ == 1) {
          ref = dataLocation_;
        }
        if (!(ref instanceof java.lang.String)) {
          com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
          java.lang.String s = bs.toStringUtf8();
          if (dataLocationCase_ == 1) {
            dataLocation_ = s;
          }
          return s;
        } else {
          return (java.lang.String) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * Resource name of the Vertex AI managed dataset.
       * </pre>
       *
       * <code>string vertex_dataset = 1 [(.google.api.resource_reference) = { ... }</code>
       *
       * @return The bytes for vertexDataset.
       */
      @java.lang.Override
      public com.google.protobuf.ByteString getVertexDatasetBytes() {
        java.lang.Object ref = "";
        if (dataLocationCase_ == 1) {
          ref = dataLocation_;
        }
        if (ref instanceof String) {
          com.google.protobuf.ByteString b =
              com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
          if (dataLocationCase_ == 1) {
            dataLocation_ = b;
          }
          return b;
        } else {
          return (com.google.protobuf.ByteString) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * Resource name of the Vertex AI managed dataset.
       * </pre>
       *
       * <code>string vertex_dataset = 1 [(.google.api.resource_reference) = { ... }</code>
       *
       * @param value The vertexDataset to set.
       * @return This builder for chaining.
       */
      public Builder setVertexDataset(java.lang.String value) {
        if (value == null) {
          throw new NullPointerException();
        }
        dataLocationCase_ = 1;
        dataLocation_ = value;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Resource name of the Vertex AI managed dataset.
       * </pre>
       *
       * <code>string vertex_dataset = 1 [(.google.api.resource_reference) = { ... }</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearVertexDataset() {
        if (dataLocationCase_ == 1) {
          dataLocationCase_ = 0;
          dataLocation_ = null;
          onChanged();
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * Resource name of the Vertex AI managed dataset.
       * </pre>
       *
       * <code>string vertex_dataset = 1 [(.google.api.resource_reference) = { ... }</code>
       *
       * @param value The bytes for vertexDataset to set.
       * @return This builder for chaining.
       */
      public Builder setVertexDatasetBytes(com.google.protobuf.ByteString value) {
        if (value == null) {
          throw new NullPointerException();
        }
        checkByteStringIsUtf8(value);
        dataLocationCase_ = 1;
        dataLocation_ = value;
        onChanged();
        return this;
      }

      private com.google.protobuf.SingleFieldBuilderV3<
              com.google.cloud.aiplatform.v1beta1.ModelMonitoringInput.ModelMonitoringDataset
                  .ModelMonitoringGcsSource,
              com.google.cloud.aiplatform.v1beta1.ModelMonitoringInput.ModelMonitoringDataset
                  .ModelMonitoringGcsSource.Builder,
              com.google.cloud.aiplatform.v1beta1.ModelMonitoringInput.ModelMonitoringDataset
                  .ModelMonitoringGcsSourceOrBuilder>
          gcsSourceBuilder_;
      /**
       *
       *
       * <pre>
       * Google Cloud Storage data source.
       * </pre>
       *
       * <code>
       * .google.cloud.aiplatform.v1beta1.ModelMonitoringInput.ModelMonitoringDataset.ModelMonitoringGcsSource gcs_source = 2;
       * </code>
       *
       * @return Whether the gcsSource field is set.
       */
      @java.lang.Override
      public boolean hasGcsSource() {
        return dataLocationCase_ == 2;
      }
      /**
       *
       *
       * <pre>
       * Google Cloud Storage data source.
       * </pre>
       *
       * <code>
       * .google.cloud.aiplatform.v1beta1.ModelMonitoringInput.ModelMonitoringDataset.ModelMonitoringGcsSource gcs_source = 2;
       * </code>
       *
       * @return The gcsSource.
       */
      @java.lang.Override
      public com.google.cloud.aiplatform.v1beta1.ModelMonitoringInput.ModelMonitoringDataset
              .ModelMonitoringGcsSource
          getGcsSource() {
        if (gcsSourceBuilder_ == null) {
          if (dataLocationCase_ == 2) {
            return (com.google.cloud.aiplatform.v1beta1.ModelMonitoringInput.ModelMonitoringDataset
                    .ModelMonitoringGcsSource)
                dataLocation_;
          }
          return com.google.cloud.aiplatform.v1beta1.ModelMonitoringInput.ModelMonitoringDataset
              .ModelMonitoringGcsSource.getDefaultInstance();
        } else {
          if (dataLocationCase_ == 2) {
            return gcsSourceBuilder_.getMessage();
          }
          return com.google.cloud.aiplatform.v1beta1.ModelMonitoringInput.ModelMonitoringDataset
              .ModelMonitoringGcsSource.getDefaultInstance();
        }
      }
      /**
       *
       *
       * <pre>
       * Google Cloud Storage data source.
       * </pre>
       *
       * <code>
       * .google.cloud.aiplatform.v1beta1.ModelMonitoringInput.ModelMonitoringDataset.ModelMonitoringGcsSource gcs_source = 2;
       * </code>
       */
      public Builder setGcsSource(
          com.google.cloud.aiplatform.v1beta1.ModelMonitoringInput.ModelMonitoringDataset
                  .ModelMonitoringGcsSource
              value) {
        if (gcsSourceBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          dataLocation_ = value;
          onChanged();
        } else {
          gcsSourceBuilder_.setMessage(value);
        }
        dataLocationCase_ = 2;
        return this;
      }
      /**
       *
       *
       * <pre>
       * Google Cloud Storage data source.
       * </pre>
       *
       * <code>
       * .google.cloud.aiplatform.v1beta1.ModelMonitoringInput.ModelMonitoringDataset.ModelMonitoringGcsSource gcs_source = 2;
       * </code>
       */
      public Builder setGcsSource(
          com.google.cloud.aiplatform.v1beta1.ModelMonitoringInput.ModelMonitoringDataset
                  .ModelMonitoringGcsSource.Builder
              builderForValue) {
        if (gcsSourceBuilder_ == null) {
          dataLocation_ = builderForValue.build();
          onChanged();
        } else {
          gcsSourceBuilder_.setMessage(builderForValue.build());
        }
        dataLocationCase_ = 2;
        return this;
      }
      /**
       *
       *
       * <pre>
       * Google Cloud Storage data source.
       * </pre>
       *
       * <code>
       * .google.cloud.aiplatform.v1beta1.ModelMonitoringInput.ModelMonitoringDataset.ModelMonitoringGcsSource gcs_source = 2;
       * </code>
       */
      public Builder mergeGcsSource(
          com.google.cloud.aiplatform.v1beta1.ModelMonitoringInput.ModelMonitoringDataset
                  .ModelMonitoringGcsSource
              value) {
        if (gcsSourceBuilder_ == null) {
          if (dataLocationCase_ == 2
              && dataLocation_
                  != com.google.cloud.aiplatform.v1beta1.ModelMonitoringInput.ModelMonitoringDataset
                      .ModelMonitoringGcsSource.getDefaultInstance()) {
            dataLocation_ =
                com.google.cloud.aiplatform.v1beta1.ModelMonitoringInput.ModelMonitoringDataset
                    .ModelMonitoringGcsSource.newBuilder(
                        (com.google.cloud.aiplatform.v1beta1.ModelMonitoringInput
                                .ModelMonitoringDataset.ModelMonitoringGcsSource)
                            dataLocation_)
                    .mergeFrom(value)
                    .buildPartial();
          } else {
            dataLocation_ = value;
          }
          onChanged();
        } else {
          if (dataLocationCase_ == 2) {
            gcsSourceBuilder_.mergeFrom(value);
          } else {
            gcsSourceBuilder_.setMessage(value);
          }
        }
        dataLocationCase_ = 2;
        return this;
      }
      /**
       *
       *
       * <pre>
       * Google Cloud Storage data source.
       * </pre>
       *
       * <code>
       * .google.cloud.aiplatform.v1beta1.ModelMonitoringInput.ModelMonitoringDataset.ModelMonitoringGcsSource gcs_source = 2;
       * </code>
       */
      public Builder clearGcsSource() {
        if (gcsSourceBuilder_ == null) {
          if (dataLocationCase_ == 2) {
            dataLocationCase_ = 0;
            dataLocation_ = null;
            onChanged();
          }
        } else {
          if (dataLocationCase_ == 2) {
            dataLocationCase_ = 0;
            dataLocation_ = null;
          }
          gcsSourceBuilder_.clear();
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * Google Cloud Storage data source.
       * </pre>
       *
       * <code>
       * .google.cloud.aiplatform.v1beta1.ModelMonitoringInput.ModelMonitoringDataset.ModelMonitoringGcsSource gcs_source = 2;
       * </code>
       */
      public com.google.cloud.aiplatform.v1beta1.ModelMonitoringInput.ModelMonitoringDataset
              .ModelMonitoringGcsSource.Builder
          getGcsSourceBuilder() {
        return getGcsSourceFieldBuilder().getBuilder();
      }
      /**
       *
       *
       * <pre>
       * Google Cloud Storage data source.
       * </pre>
       *
       * <code>
       * .google.cloud.aiplatform.v1beta1.ModelMonitoringInput.ModelMonitoringDataset.ModelMonitoringGcsSource gcs_source = 2;
       * </code>
       */
      @java.lang.Override
      public com.google.cloud.aiplatform.v1beta1.ModelMonitoringInput.ModelMonitoringDataset
              .ModelMonitoringGcsSourceOrBuilder
          getGcsSourceOrBuilder() {
        if ((dataLocationCase_ == 2) && (gcsSourceBuilder_ != null)) {
          return gcsSourceBuilder_.getMessageOrBuilder();
        } else {
          if (dataLocationCase_ == 2) {
            return (com.google.cloud.aiplatform.v1beta1.ModelMonitoringInput.ModelMonitoringDataset
                    .ModelMonitoringGcsSource)
                dataLocation_;
          }
          return com.google.cloud.aiplatform.v1beta1.ModelMonitoringInput.ModelMonitoringDataset
              .ModelMonitoringGcsSource.getDefaultInstance();
        }
      }
      /**
       *
       *
       * <pre>
       * Google Cloud Storage data source.
       * </pre>
       *
       * <code>
       * .google.cloud.aiplatform.v1beta1.ModelMonitoringInput.ModelMonitoringDataset.ModelMonitoringGcsSource gcs_source = 2;
       * </code>
       */
      private com.google.protobuf.SingleFieldBuilderV3<
              com.google.cloud.aiplatform.v1beta1.ModelMonitoringInput.ModelMonitoringDataset
                  .ModelMonitoringGcsSource,
              com.google.cloud.aiplatform.v1beta1.ModelMonitoringInput.ModelMonitoringDataset
                  .ModelMonitoringGcsSource.Builder,
              com.google.cloud.aiplatform.v1beta1.ModelMonitoringInput.ModelMonitoringDataset
                  .ModelMonitoringGcsSourceOrBuilder>
          getGcsSourceFieldBuilder() {
        if (gcsSourceBuilder_ == null) {
          if (!(dataLocationCase_ == 2)) {
            dataLocation_ =
                com.google.cloud.aiplatform.v1beta1.ModelMonitoringInput.ModelMonitoringDataset
                    .ModelMonitoringGcsSource.getDefaultInstance();
          }
          gcsSourceBuilder_ =
              new com.google.protobuf.SingleFieldBuilderV3<
                  com.google.cloud.aiplatform.v1beta1.ModelMonitoringInput.ModelMonitoringDataset
                      .ModelMonitoringGcsSource,
                  com.google.cloud.aiplatform.v1beta1.ModelMonitoringInput.ModelMonitoringDataset
                      .ModelMonitoringGcsSource.Builder,
                  com.google.cloud.aiplatform.v1beta1.ModelMonitoringInput.ModelMonitoringDataset
                      .ModelMonitoringGcsSourceOrBuilder>(
                  (com.google.cloud.aiplatform.v1beta1.ModelMonitoringInput.ModelMonitoringDataset
                          .ModelMonitoringGcsSource)
                      dataLocation_,
                  getParentForChildren(),
                  isClean());
          dataLocation_ = null;
        }
        dataLocationCase_ = 2;
        onChanged();
        return gcsSourceBuilder_;
      }

      private com.google.protobuf.SingleFieldBuilderV3<
              com.google.cloud.aiplatform.v1beta1.ModelMonitoringInput.ModelMonitoringDataset
                  .ModelMonitoringBigQuerySource,
              com.google.cloud.aiplatform.v1beta1.ModelMonitoringInput.ModelMonitoringDataset
                  .ModelMonitoringBigQuerySource.Builder,
              com.google.cloud.aiplatform.v1beta1.ModelMonitoringInput.ModelMonitoringDataset
                  .ModelMonitoringBigQuerySourceOrBuilder>
          bigquerySourceBuilder_;
      /**
       *
       *
       * <pre>
       * BigQuery data source.
       * </pre>
       *
       * <code>
       * .google.cloud.aiplatform.v1beta1.ModelMonitoringInput.ModelMonitoringDataset.ModelMonitoringBigQuerySource bigquery_source = 6;
       * </code>
       *
       * @return Whether the bigquerySource field is set.
       */
      @java.lang.Override
      public boolean hasBigquerySource() {
        return dataLocationCase_ == 6;
      }
      /**
       *
       *
       * <pre>
       * BigQuery data source.
       * </pre>
       *
       * <code>
       * .google.cloud.aiplatform.v1beta1.ModelMonitoringInput.ModelMonitoringDataset.ModelMonitoringBigQuerySource bigquery_source = 6;
       * </code>
       *
       * @return The bigquerySource.
       */
      @java.lang.Override
      public com.google.cloud.aiplatform.v1beta1.ModelMonitoringInput.ModelMonitoringDataset
              .ModelMonitoringBigQuerySource
          getBigquerySource() {
        if (bigquerySourceBuilder_ == null) {
          if (dataLocationCase_ == 6) {
            return (com.google.cloud.aiplatform.v1beta1.ModelMonitoringInput.ModelMonitoringDataset
                    .ModelMonitoringBigQuerySource)
                dataLocation_;
          }
          return com.google.cloud.aiplatform.v1beta1.ModelMonitoringInput.ModelMonitoringDataset
              .ModelMonitoringBigQuerySource.getDefaultInstance();
        } else {
          if (dataLocationCase_ == 6) {
            return bigquerySourceBuilder_.getMessage();
          }
          return com.google.cloud.aiplatform.v1beta1.ModelMonitoringInput.ModelMonitoringDataset
              .ModelMonitoringBigQuerySource.getDefaultInstance();
        }
      }
      /**
       *
       *
       * <pre>
       * BigQuery data source.
       * </pre>
       *
       * <code>
       * .google.cloud.aiplatform.v1beta1.ModelMonitoringInput.ModelMonitoringDataset.ModelMonitoringBigQuerySource bigquery_source = 6;
       * </code>
       */
      public Builder setBigquerySource(
          com.google.cloud.aiplatform.v1beta1.ModelMonitoringInput.ModelMonitoringDataset
                  .ModelMonitoringBigQuerySource
              value) {
        if (bigquerySourceBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          dataLocation_ = value;
          onChanged();
        } else {
          bigquerySourceBuilder_.setMessage(value);
        }
        dataLocationCase_ = 6;
        return this;
      }
      /**
       *
       *
       * <pre>
       * BigQuery data source.
       * </pre>
       *
       * <code>
       * .google.cloud.aiplatform.v1beta1.ModelMonitoringInput.ModelMonitoringDataset.ModelMonitoringBigQuerySource bigquery_source = 6;
       * </code>
       */
      public Builder setBigquerySource(
          com.google.cloud.aiplatform.v1beta1.ModelMonitoringInput.ModelMonitoringDataset
                  .ModelMonitoringBigQuerySource.Builder
              builderForValue) {
        if (bigquerySourceBuilder_ == null) {
          dataLocation_ = builderForValue.build();
          onChanged();
        } else {
          bigquerySourceBuilder_.setMessage(builderForValue.build());
        }
        dataLocationCase_ = 6;
        return this;
      }
      /**
       *
       *
       * <pre>
       * BigQuery data source.
       * </pre>
       *
       * <code>
       * .google.cloud.aiplatform.v1beta1.ModelMonitoringInput.ModelMonitoringDataset.ModelMonitoringBigQuerySource bigquery_source = 6;
       * </code>
       */
      public Builder mergeBigquerySource(
          com.google.cloud.aiplatform.v1beta1.ModelMonitoringInput.ModelMonitoringDataset
                  .ModelMonitoringBigQuerySource
              value) {
        if (bigquerySourceBuilder_ == null) {
          if (dataLocationCase_ == 6
              && dataLocation_
                  != com.google.cloud.aiplatform.v1beta1.ModelMonitoringInput.ModelMonitoringDataset
                      .ModelMonitoringBigQuerySource.getDefaultInstance()) {
            dataLocation_ =
                com.google.cloud.aiplatform.v1beta1.ModelMonitoringInput.ModelMonitoringDataset
                    .ModelMonitoringBigQuerySource.newBuilder(
                        (com.google.cloud.aiplatform.v1beta1.ModelMonitoringInput
                                .ModelMonitoringDataset.ModelMonitoringBigQuerySource)
                            dataLocation_)
                    .mergeFrom(value)
                    .buildPartial();
          } else {
            dataLocation_ = value;
          }
          onChanged();
        } else {
          if (dataLocationCase_ == 6) {
            bigquerySourceBuilder_.mergeFrom(value);
          } else {
            bigquerySourceBuilder_.setMessage(value);
          }
        }
        dataLocationCase_ = 6;
        return this;
      }
      /**
       *
       *
       * <pre>
       * BigQuery data source.
       * </pre>
       *
       * <code>
       * .google.cloud.aiplatform.v1beta1.ModelMonitoringInput.ModelMonitoringDataset.ModelMonitoringBigQuerySource bigquery_source = 6;
       * </code>
       */
      public Builder clearBigquerySource() {
        if (bigquerySourceBuilder_ == null) {
          if (dataLocationCase_ == 6) {
            dataLocationCase_ = 0;
            dataLocation_ = null;
            onChanged();
          }
        } else {
          if (dataLocationCase_ == 6) {
            dataLocationCase_ = 0;
            dataLocation_ = null;
          }
          bigquerySourceBuilder_.clear();
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * BigQuery data source.
       * </pre>
       *
       * <code>
       * .google.cloud.aiplatform.v1beta1.ModelMonitoringInput.ModelMonitoringDataset.ModelMonitoringBigQuerySource bigquery_source = 6;
       * </code>
       */
      public com.google.cloud.aiplatform.v1beta1.ModelMonitoringInput.ModelMonitoringDataset
              .ModelMonitoringBigQuerySource.Builder
          getBigquerySourceBuilder() {
        return getBigquerySourceFieldBuilder().getBuilder();
      }
      /**
       *
       *
       * <pre>
       * BigQuery data source.
       * </pre>
       *
       * <code>
       * .google.cloud.aiplatform.v1beta1.ModelMonitoringInput.ModelMonitoringDataset.ModelMonitoringBigQuerySource bigquery_source = 6;
       * </code>
       */
      @java.lang.Override
      public com.google.cloud.aiplatform.v1beta1.ModelMonitoringInput.ModelMonitoringDataset
              .ModelMonitoringBigQuerySourceOrBuilder
          getBigquerySourceOrBuilder() {
        if ((dataLocationCase_ == 6) && (bigquerySourceBuilder_ != null)) {
          return bigquerySourceBuilder_.getMessageOrBuilder();
        } else {
          if (dataLocationCase_ == 6) {
            return (com.google.cloud.aiplatform.v1beta1.ModelMonitoringInput.ModelMonitoringDataset
                    .ModelMonitoringBigQuerySource)
                dataLocation_;
          }
          return com.google.cloud.aiplatform.v1beta1.ModelMonitoringInput.ModelMonitoringDataset
              .ModelMonitoringBigQuerySource.getDefaultInstance();
        }
      }
      /**
       *
       *
       * <pre>
       * BigQuery data source.
       * </pre>
       *
       * <code>
       * .google.cloud.aiplatform.v1beta1.ModelMonitoringInput.ModelMonitoringDataset.ModelMonitoringBigQuerySource bigquery_source = 6;
       * </code>
       */
      private com.google.protobuf.SingleFieldBuilderV3<
              com.google.cloud.aiplatform.v1beta1.ModelMonitoringInput.ModelMonitoringDataset
                  .ModelMonitoringBigQuerySource,
              com.google.cloud.aiplatform.v1beta1.ModelMonitoringInput.ModelMonitoringDataset
                  .ModelMonitoringBigQuerySource.Builder,
              com.google.cloud.aiplatform.v1beta1.ModelMonitoringInput.ModelMonitoringDataset
                  .ModelMonitoringBigQuerySourceOrBuilder>
          getBigquerySourceFieldBuilder() {
        if (bigquerySourceBuilder_ == null) {
          if (!(dataLocationCase_ == 6)) {
            dataLocation_ =
                com.google.cloud.aiplatform.v1beta1.ModelMonitoringInput.ModelMonitoringDataset
                    .ModelMonitoringBigQuerySource.getDefaultInstance();
          }
          bigquerySourceBuilder_ =
              new com.google.protobuf.SingleFieldBuilderV3<
                  com.google.cloud.aiplatform.v1beta1.ModelMonitoringInput.ModelMonitoringDataset
                      .ModelMonitoringBigQuerySource,
                  com.google.cloud.aiplatform.v1beta1.ModelMonitoringInput.ModelMonitoringDataset
                      .ModelMonitoringBigQuerySource.Builder,
                  com.google.cloud.aiplatform.v1beta1.ModelMonitoringInput.ModelMonitoringDataset
                      .ModelMonitoringBigQuerySourceOrBuilder>(
                  (com.google.cloud.aiplatform.v1beta1.ModelMonitoringInput.ModelMonitoringDataset
                          .ModelMonitoringBigQuerySource)
                      dataLocation_,
                  getParentForChildren(),
                  isClean());
          dataLocation_ = null;
        }
        dataLocationCase_ = 6;
        onChanged();
        return bigquerySourceBuilder_;
      }

      private java.lang.Object timestampField_ = "";
      /**
       *
       *
       * <pre>
       * The timestamp field. Usually for serving data.
       * </pre>
       *
       * <code>string timestamp_field = 7;</code>
       *
       * @return The timestampField.
       */
      public java.lang.String getTimestampField() {
        java.lang.Object ref = timestampField_;
        if (!(ref instanceof java.lang.String)) {
          com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
          java.lang.String s = bs.toStringUtf8();
          timestampField_ = s;
          return s;
        } else {
          return (java.lang.String) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * The timestamp field. Usually for serving data.
       * </pre>
       *
       * <code>string timestamp_field = 7;</code>
       *
       * @return The bytes for timestampField.
       */
      public com.google.protobuf.ByteString getTimestampFieldBytes() {
        java.lang.Object ref = timestampField_;
        if (ref instanceof String) {
          com.google.protobuf.ByteString b =
              com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
          timestampField_ = b;
          return b;
        } else {
          return (com.google.protobuf.ByteString) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * The timestamp field. Usually for serving data.
       * </pre>
       *
       * <code>string timestamp_field = 7;</code>
       *
       * @param value The timestampField to set.
       * @return This builder for chaining.
       */
      public Builder setTimestampField(java.lang.String value) {
        if (value == null) {
          throw new NullPointerException();
        }
        timestampField_ = value;
        bitField0_ |= 0x00000008;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * The timestamp field. Usually for serving data.
       * </pre>
       *
       * <code>string timestamp_field = 7;</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearTimestampField() {
        timestampField_ = getDefaultInstance().getTimestampField();
        bitField0_ = (bitField0_ & ~0x00000008);
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * The timestamp field. Usually for serving data.
       * </pre>
       *
       * <code>string timestamp_field = 7;</code>
       *
       * @param value The bytes for timestampField to set.
       * @return This builder for chaining.
       */
      public Builder setTimestampFieldBytes(com.google.protobuf.ByteString value) {
        if (value == null) {
          throw new NullPointerException();
        }
        checkByteStringIsUtf8(value);
        timestampField_ = value;
        bitField0_ |= 0x00000008;
        onChanged();
        return this;
      }

      @java.lang.Override
      public final Builder setUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.setUnknownFields(unknownFields);
      }

      @java.lang.Override
      public final Builder mergeUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.mergeUnknownFields(unknownFields);
      }

      // @@protoc_insertion_point(builder_scope:google.cloud.aiplatform.v1beta1.ModelMonitoringInput.ModelMonitoringDataset)
    }

    // @@protoc_insertion_point(class_scope:google.cloud.aiplatform.v1beta1.ModelMonitoringInput.ModelMonitoringDataset)
    private static final com.google.cloud.aiplatform.v1beta1.ModelMonitoringInput
            .ModelMonitoringDataset
        DEFAULT_INSTANCE;

    static {
      DEFAULT_INSTANCE =
          new com.google.cloud.aiplatform.v1beta1.ModelMonitoringInput.ModelMonitoringDataset();
    }

    public static com.google.cloud.aiplatform.v1beta1.ModelMonitoringInput.ModelMonitoringDataset
        getDefaultInstance() {
      return DEFAULT_INSTANCE;
    }

    private static final com.google.protobuf.Parser<ModelMonitoringDataset> PARSER =
        new com.google.protobuf.AbstractParser<ModelMonitoringDataset>() {
          @java.lang.Override
          public ModelMonitoringDataset parsePartialFrom(
              com.google.protobuf.CodedInputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
            Builder builder = newBuilder();
            try {
              builder.mergeFrom(input, extensionRegistry);
            } catch (com.google.protobuf.InvalidProtocolBufferException e) {
              throw e.setUnfinishedMessage(builder.buildPartial());
            } catch (com.google.protobuf.UninitializedMessageException e) {
              throw e.asInvalidProtocolBufferException()
                  .setUnfinishedMessage(builder.buildPartial());
            } catch (java.io.IOException e) {
              throw new com.google.protobuf.InvalidProtocolBufferException(e)
                  .setUnfinishedMessage(builder.buildPartial());
            }
            return builder.buildPartial();
          }
        };

    public static com.google.protobuf.Parser<ModelMonitoringDataset> parser() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.protobuf.Parser<ModelMonitoringDataset> getParserForType() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.cloud.aiplatform.v1beta1.ModelMonitoringInput.ModelMonitoringDataset
        getDefaultInstanceForType() {
      return DEFAULT_INSTANCE;
    }
  }

  public interface BatchPredictionOutputOrBuilder
      extends
      // @@protoc_insertion_point(interface_extends:google.cloud.aiplatform.v1beta1.ModelMonitoringInput.BatchPredictionOutput)
      com.google.protobuf.MessageOrBuilder {

    /**
     *
     *
     * <pre>
     * Vertex AI Batch prediction job resource name. The job must match the
     * model version specified in [ModelMonitor].[model_monitoring_target].
     * </pre>
     *
     * <code>string batch_prediction_job = 1 [(.google.api.resource_reference) = { ... }</code>
     *
     * @return The batchPredictionJob.
     */
    java.lang.String getBatchPredictionJob();
    /**
     *
     *
     * <pre>
     * Vertex AI Batch prediction job resource name. The job must match the
     * model version specified in [ModelMonitor].[model_monitoring_target].
     * </pre>
     *
     * <code>string batch_prediction_job = 1 [(.google.api.resource_reference) = { ... }</code>
     *
     * @return The bytes for batchPredictionJob.
     */
    com.google.protobuf.ByteString getBatchPredictionJobBytes();
  }
  /**
   *
   *
   * <pre>
   * Data from Vertex AI Batch prediction job output.
   * </pre>
   *
   * Protobuf type {@code
   * google.cloud.aiplatform.v1beta1.ModelMonitoringInput.BatchPredictionOutput}
   */
  public static final class BatchPredictionOutput extends com.google.protobuf.GeneratedMessageV3
      implements
      // @@protoc_insertion_point(message_implements:google.cloud.aiplatform.v1beta1.ModelMonitoringInput.BatchPredictionOutput)
      BatchPredictionOutputOrBuilder {
    private static final long serialVersionUID = 0L;
    // Use BatchPredictionOutput.newBuilder() to construct.
    private BatchPredictionOutput(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
      super(builder);
    }

    private BatchPredictionOutput() {
      batchPredictionJob_ = "";
    }

    @java.lang.Override
    @SuppressWarnings({"unused"})
    protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
      return new BatchPredictionOutput();
    }

    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.aiplatform.v1beta1.ModelMonitoringSpecProto
          .internal_static_google_cloud_aiplatform_v1beta1_ModelMonitoringInput_BatchPredictionOutput_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.aiplatform.v1beta1.ModelMonitoringSpecProto
          .internal_static_google_cloud_aiplatform_v1beta1_ModelMonitoringInput_BatchPredictionOutput_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.aiplatform.v1beta1.ModelMonitoringInput.BatchPredictionOutput.class,
              com.google.cloud.aiplatform.v1beta1.ModelMonitoringInput.BatchPredictionOutput.Builder
                  .class);
    }

    public static final int BATCH_PREDICTION_JOB_FIELD_NUMBER = 1;

    @SuppressWarnings("serial")
    private volatile java.lang.Object batchPredictionJob_ = "";
    /**
     *
     *
     * <pre>
     * Vertex AI Batch prediction job resource name. The job must match the
     * model version specified in [ModelMonitor].[model_monitoring_target].
     * </pre>
     *
     * <code>string batch_prediction_job = 1 [(.google.api.resource_reference) = { ... }</code>
     *
     * @return The batchPredictionJob.
     */
    @java.lang.Override
    public java.lang.String getBatchPredictionJob() {
      java.lang.Object ref = batchPredictionJob_;
      if (ref instanceof java.lang.String) {
        return (java.lang.String) ref;
      } else {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        batchPredictionJob_ = s;
        return s;
      }
    }
    /**
     *
     *
     * <pre>
     * Vertex AI Batch prediction job resource name. The job must match the
     * model version specified in [ModelMonitor].[model_monitoring_target].
     * </pre>
     *
     * <code>string batch_prediction_job = 1 [(.google.api.resource_reference) = { ... }</code>
     *
     * @return The bytes for batchPredictionJob.
     */
    @java.lang.Override
    public com.google.protobuf.ByteString getBatchPredictionJobBytes() {
      java.lang.Object ref = batchPredictionJob_;
      if (ref instanceof java.lang.String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        batchPredictionJob_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    private byte memoizedIsInitialized = -1;

    @java.lang.Override
    public final boolean isInitialized() {
      byte isInitialized = memoizedIsInitialized;
      if (isInitialized == 1) return true;
      if (isInitialized == 0) return false;

      memoizedIsInitialized = 1;
      return true;
    }

    @java.lang.Override
    public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(batchPredictionJob_)) {
        com.google.protobuf.GeneratedMessageV3.writeString(output, 1, batchPredictionJob_);
      }
      getUnknownFields().writeTo(output);
    }

    @java.lang.Override
    public int getSerializedSize() {
      int size = memoizedSize;
      if (size != -1) return size;

      size = 0;
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(batchPredictionJob_)) {
        size += com.google.protobuf.GeneratedMessageV3.computeStringSize(1, batchPredictionJob_);
      }
      size += getUnknownFields().getSerializedSize();
      memoizedSize = size;
      return size;
    }

    @java.lang.Override
    public boolean equals(final java.lang.Object obj) {
      if (obj == this) {
        return true;
      }
      if (!(obj
          instanceof
          com.google.cloud.aiplatform.v1beta1.ModelMonitoringInput.BatchPredictionOutput)) {
        return super.equals(obj);
      }
      com.google.cloud.aiplatform.v1beta1.ModelMonitoringInput.BatchPredictionOutput other =
          (com.google.cloud.aiplatform.v1beta1.ModelMonitoringInput.BatchPredictionOutput) obj;

      if (!getBatchPredictionJob().equals(other.getBatchPredictionJob())) return false;
      if (!getUnknownFields().equals(other.getUnknownFields())) return false;
      return true;
    }

    @java.lang.Override
    public int hashCode() {
      if (memoizedHashCode != 0) {
        return memoizedHashCode;
      }
      int hash = 41;
      hash = (19 * hash) + getDescriptor().hashCode();
      hash = (37 * hash) + BATCH_PREDICTION_JOB_FIELD_NUMBER;
      hash = (53 * hash) + getBatchPredictionJob().hashCode();
      hash = (29 * hash) + getUnknownFields().hashCode();
      memoizedHashCode = hash;
      return hash;
    }

    public static com.google.cloud.aiplatform.v1beta1.ModelMonitoringInput.BatchPredictionOutput
        parseFrom(java.nio.ByteBuffer data)
            throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.aiplatform.v1beta1.ModelMonitoringInput.BatchPredictionOutput
        parseFrom(
            java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.aiplatform.v1beta1.ModelMonitoringInput.BatchPredictionOutput
        parseFrom(com.google.protobuf.ByteString data)
            throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.aiplatform.v1beta1.ModelMonitoringInput.BatchPredictionOutput
        parseFrom(
            com.google.protobuf.ByteString data,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.aiplatform.v1beta1.ModelMonitoringInput.BatchPredictionOutput
        parseFrom(byte[] data) throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.aiplatform.v1beta1.ModelMonitoringInput.BatchPredictionOutput
        parseFrom(byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.aiplatform.v1beta1.ModelMonitoringInput.BatchPredictionOutput
        parseFrom(java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.cloud.aiplatform.v1beta1.ModelMonitoringInput.BatchPredictionOutput
        parseFrom(
            java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.cloud.aiplatform.v1beta1.ModelMonitoringInput.BatchPredictionOutput
        parseDelimitedFrom(java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
    }

    public static com.google.cloud.aiplatform.v1beta1.ModelMonitoringInput.BatchPredictionOutput
        parseDelimitedFrom(
            java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.cloud.aiplatform.v1beta1.ModelMonitoringInput.BatchPredictionOutput
        parseFrom(com.google.protobuf.CodedInputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.cloud.aiplatform.v1beta1.ModelMonitoringInput.BatchPredictionOutput
        parseFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    @java.lang.Override
    public Builder newBuilderForType() {
      return newBuilder();
    }

    public static Builder newBuilder() {
      return DEFAULT_INSTANCE.toBuilder();
    }

    public static Builder newBuilder(
        com.google.cloud.aiplatform.v1beta1.ModelMonitoringInput.BatchPredictionOutput prototype) {
      return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }

    @java.lang.Override
    public Builder toBuilder() {
      return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
    }

    @java.lang.Override
    protected Builder newBuilderForType(
        com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      Builder builder = new Builder(parent);
      return builder;
    }
    /**
     *
     *
     * <pre>
     * Data from Vertex AI Batch prediction job output.
     * </pre>
     *
     * Protobuf type {@code
     * google.cloud.aiplatform.v1beta1.ModelMonitoringInput.BatchPredictionOutput}
     */
    public static final class Builder
        extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
        implements
        // @@protoc_insertion_point(builder_implements:google.cloud.aiplatform.v1beta1.ModelMonitoringInput.BatchPredictionOutput)
        com.google.cloud.aiplatform.v1beta1.ModelMonitoringInput.BatchPredictionOutputOrBuilder {
      public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
        return com.google.cloud.aiplatform.v1beta1.ModelMonitoringSpecProto
            .internal_static_google_cloud_aiplatform_v1beta1_ModelMonitoringInput_BatchPredictionOutput_descriptor;
      }

      @java.lang.Override
      protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return com.google.cloud.aiplatform.v1beta1.ModelMonitoringSpecProto
            .internal_static_google_cloud_aiplatform_v1beta1_ModelMonitoringInput_BatchPredictionOutput_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                com.google.cloud.aiplatform.v1beta1.ModelMonitoringInput.BatchPredictionOutput
                    .class,
                com.google.cloud.aiplatform.v1beta1.ModelMonitoringInput.BatchPredictionOutput
                    .Builder.class);
      }

      // Construct using
      // com.google.cloud.aiplatform.v1beta1.ModelMonitoringInput.BatchPredictionOutput.newBuilder()
      private Builder() {}

      private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
        super(parent);
      }

      @java.lang.Override
      public Builder clear() {
        super.clear();
        bitField0_ = 0;
        batchPredictionJob_ = "";
        return this;
      }

      @java.lang.Override
      public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
        return com.google.cloud.aiplatform.v1beta1.ModelMonitoringSpecProto
            .internal_static_google_cloud_aiplatform_v1beta1_ModelMonitoringInput_BatchPredictionOutput_descriptor;
      }

      @java.lang.Override
      public com.google.cloud.aiplatform.v1beta1.ModelMonitoringInput.BatchPredictionOutput
          getDefaultInstanceForType() {
        return com.google.cloud.aiplatform.v1beta1.ModelMonitoringInput.BatchPredictionOutput
            .getDefaultInstance();
      }

      @java.lang.Override
      public com.google.cloud.aiplatform.v1beta1.ModelMonitoringInput.BatchPredictionOutput
          build() {
        com.google.cloud.aiplatform.v1beta1.ModelMonitoringInput.BatchPredictionOutput result =
            buildPartial();
        if (!result.isInitialized()) {
          throw newUninitializedMessageException(result);
        }
        return result;
      }

      @java.lang.Override
      public com.google.cloud.aiplatform.v1beta1.ModelMonitoringInput.BatchPredictionOutput
          buildPartial() {
        com.google.cloud.aiplatform.v1beta1.ModelMonitoringInput.BatchPredictionOutput result =
            new com.google.cloud.aiplatform.v1beta1.ModelMonitoringInput.BatchPredictionOutput(
                this);
        if (bitField0_ != 0) {
          buildPartial0(result);
        }
        onBuilt();
        return result;
      }

      private void buildPartial0(
          com.google.cloud.aiplatform.v1beta1.ModelMonitoringInput.BatchPredictionOutput result) {
        int from_bitField0_ = bitField0_;
        if (((from_bitField0_ & 0x00000001) != 0)) {
          result.batchPredictionJob_ = batchPredictionJob_;
        }
      }

      @java.lang.Override
      public Builder clone() {
        return super.clone();
      }

      @java.lang.Override
      public Builder setField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.setField(field, value);
      }

      @java.lang.Override
      public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
        return super.clearField(field);
      }

      @java.lang.Override
      public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
        return super.clearOneof(oneof);
      }

      @java.lang.Override
      public Builder setRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          int index,
          java.lang.Object value) {
        return super.setRepeatedField(field, index, value);
      }

      @java.lang.Override
      public Builder addRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.addRepeatedField(field, value);
      }

      @java.lang.Override
      public Builder mergeFrom(com.google.protobuf.Message other) {
        if (other
            instanceof
            com.google.cloud.aiplatform.v1beta1.ModelMonitoringInput.BatchPredictionOutput) {
          return mergeFrom(
              (com.google.cloud.aiplatform.v1beta1.ModelMonitoringInput.BatchPredictionOutput)
                  other);
        } else {
          super.mergeFrom(other);
          return this;
        }
      }

      public Builder mergeFrom(
          com.google.cloud.aiplatform.v1beta1.ModelMonitoringInput.BatchPredictionOutput other) {
        if (other
            == com.google.cloud.aiplatform.v1beta1.ModelMonitoringInput.BatchPredictionOutput
                .getDefaultInstance()) return this;
        if (!other.getBatchPredictionJob().isEmpty()) {
          batchPredictionJob_ = other.batchPredictionJob_;
          bitField0_ |= 0x00000001;
          onChanged();
        }
        this.mergeUnknownFields(other.getUnknownFields());
        onChanged();
        return this;
      }

      @java.lang.Override
      public final boolean isInitialized() {
        return true;
      }

      @java.lang.Override
      public Builder mergeFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        if (extensionRegistry == null) {
          throw new java.lang.NullPointerException();
        }
        try {
          boolean done = false;
          while (!done) {
            int tag = input.readTag();
            switch (tag) {
              case 0:
                done = true;
                break;
              case 10:
                {
                  batchPredictionJob_ = input.readStringRequireUtf8();
                  bitField0_ |= 0x00000001;
                  break;
                } // case 10
              default:
                {
                  if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                    done = true; // was an endgroup tag
                  }
                  break;
                } // default:
            } // switch (tag)
          } // while (!done)
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          throw e.unwrapIOException();
        } finally {
          onChanged();
        } // finally
        return this;
      }

      private int bitField0_;

      private java.lang.Object batchPredictionJob_ = "";
      /**
       *
       *
       * <pre>
       * Vertex AI Batch prediction job resource name. The job must match the
       * model version specified in [ModelMonitor].[model_monitoring_target].
       * </pre>
       *
       * <code>string batch_prediction_job = 1 [(.google.api.resource_reference) = { ... }</code>
       *
       * @return The batchPredictionJob.
       */
      public java.lang.String getBatchPredictionJob() {
        java.lang.Object ref = batchPredictionJob_;
        if (!(ref instanceof java.lang.String)) {
          com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
          java.lang.String s = bs.toStringUtf8();
          batchPredictionJob_ = s;
          return s;
        } else {
          return (java.lang.String) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * Vertex AI Batch prediction job resource name. The job must match the
       * model version specified in [ModelMonitor].[model_monitoring_target].
       * </pre>
       *
       * <code>string batch_prediction_job = 1 [(.google.api.resource_reference) = { ... }</code>
       *
       * @return The bytes for batchPredictionJob.
       */
      public com.google.protobuf.ByteString getBatchPredictionJobBytes() {
        java.lang.Object ref = batchPredictionJob_;
        if (ref instanceof String) {
          com.google.protobuf.ByteString b =
              com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
          batchPredictionJob_ = b;
          return b;
        } else {
          return (com.google.protobuf.ByteString) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * Vertex AI Batch prediction job resource name. The job must match the
       * model version specified in [ModelMonitor].[model_monitoring_target].
       * </pre>
       *
       * <code>string batch_prediction_job = 1 [(.google.api.resource_reference) = { ... }</code>
       *
       * @param value The batchPredictionJob to set.
       * @return This builder for chaining.
       */
      public Builder setBatchPredictionJob(java.lang.String value) {
        if (value == null) {
          throw new NullPointerException();
        }
        batchPredictionJob_ = value;
        bitField0_ |= 0x00000001;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Vertex AI Batch prediction job resource name. The job must match the
       * model version specified in [ModelMonitor].[model_monitoring_target].
       * </pre>
       *
       * <code>string batch_prediction_job = 1 [(.google.api.resource_reference) = { ... }</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearBatchPredictionJob() {
        batchPredictionJob_ = getDefaultInstance().getBatchPredictionJob();
        bitField0_ = (bitField0_ & ~0x00000001);
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Vertex AI Batch prediction job resource name. The job must match the
       * model version specified in [ModelMonitor].[model_monitoring_target].
       * </pre>
       *
       * <code>string batch_prediction_job = 1 [(.google.api.resource_reference) = { ... }</code>
       *
       * @param value The bytes for batchPredictionJob to set.
       * @return This builder for chaining.
       */
      public Builder setBatchPredictionJobBytes(com.google.protobuf.ByteString value) {
        if (value == null) {
          throw new NullPointerException();
        }
        checkByteStringIsUtf8(value);
        batchPredictionJob_ = value;
        bitField0_ |= 0x00000001;
        onChanged();
        return this;
      }

      @java.lang.Override
      public final Builder setUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.setUnknownFields(unknownFields);
      }

      @java.lang.Override
      public final Builder mergeUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.mergeUnknownFields(unknownFields);
      }

      // @@protoc_insertion_point(builder_scope:google.cloud.aiplatform.v1beta1.ModelMonitoringInput.BatchPredictionOutput)
    }

    // @@protoc_insertion_point(class_scope:google.cloud.aiplatform.v1beta1.ModelMonitoringInput.BatchPredictionOutput)
    private static final com.google.cloud.aiplatform.v1beta1.ModelMonitoringInput
            .BatchPredictionOutput
        DEFAULT_INSTANCE;

    static {
      DEFAULT_INSTANCE =
          new com.google.cloud.aiplatform.v1beta1.ModelMonitoringInput.BatchPredictionOutput();
    }

    public static com.google.cloud.aiplatform.v1beta1.ModelMonitoringInput.BatchPredictionOutput
        getDefaultInstance() {
      return DEFAULT_INSTANCE;
    }

    private static final com.google.protobuf.Parser<BatchPredictionOutput> PARSER =
        new com.google.protobuf.AbstractParser<BatchPredictionOutput>() {
          @java.lang.Override
          public BatchPredictionOutput parsePartialFrom(
              com.google.protobuf.CodedInputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
            Builder builder = newBuilder();
            try {
              builder.mergeFrom(input, extensionRegistry);
            } catch (com.google.protobuf.InvalidProtocolBufferException e) {
              throw e.setUnfinishedMessage(builder.buildPartial());
            } catch (com.google.protobuf.UninitializedMessageException e) {
              throw e.asInvalidProtocolBufferException()
                  .setUnfinishedMessage(builder.buildPartial());
            } catch (java.io.IOException e) {
              throw new com.google.protobuf.InvalidProtocolBufferException(e)
                  .setUnfinishedMessage(builder.buildPartial());
            }
            return builder.buildPartial();
          }
        };

    public static com.google.protobuf.Parser<BatchPredictionOutput> parser() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.protobuf.Parser<BatchPredictionOutput> getParserForType() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.cloud.aiplatform.v1beta1.ModelMonitoringInput.BatchPredictionOutput
        getDefaultInstanceForType() {
      return DEFAULT_INSTANCE;
    }
  }

  public interface VertexEndpointLogsOrBuilder
      extends
      // @@protoc_insertion_point(interface_extends:google.cloud.aiplatform.v1beta1.ModelMonitoringInput.VertexEndpointLogs)
      com.google.protobuf.MessageOrBuilder {

    /**
     *
     *
     * <pre>
     * List of endpoint resource names. The endpoints must enable the logging
     * with the [Endpoint].[request_response_logging_config], and must contain
     * the deployed model corresponding to the model version specified in
     * [ModelMonitor].[model_monitoring_target].
     * </pre>
     *
     * <code>repeated string endpoints = 1 [(.google.api.resource_reference) = { ... }</code>
     *
     * @return A list containing the endpoints.
     */
    java.util.List<java.lang.String> getEndpointsList();
    /**
     *
     *
     * <pre>
     * List of endpoint resource names. The endpoints must enable the logging
     * with the [Endpoint].[request_response_logging_config], and must contain
     * the deployed model corresponding to the model version specified in
     * [ModelMonitor].[model_monitoring_target].
     * </pre>
     *
     * <code>repeated string endpoints = 1 [(.google.api.resource_reference) = { ... }</code>
     *
     * @return The count of endpoints.
     */
    int getEndpointsCount();
    /**
     *
     *
     * <pre>
     * List of endpoint resource names. The endpoints must enable the logging
     * with the [Endpoint].[request_response_logging_config], and must contain
     * the deployed model corresponding to the model version specified in
     * [ModelMonitor].[model_monitoring_target].
     * </pre>
     *
     * <code>repeated string endpoints = 1 [(.google.api.resource_reference) = { ... }</code>
     *
     * @param index The index of the element to return.
     * @return The endpoints at the given index.
     */
    java.lang.String getEndpoints(int index);
    /**
     *
     *
     * <pre>
     * List of endpoint resource names. The endpoints must enable the logging
     * with the [Endpoint].[request_response_logging_config], and must contain
     * the deployed model corresponding to the model version specified in
     * [ModelMonitor].[model_monitoring_target].
     * </pre>
     *
     * <code>repeated string endpoints = 1 [(.google.api.resource_reference) = { ... }</code>
     *
     * @param index The index of the value to return.
     * @return The bytes of the endpoints at the given index.
     */
    com.google.protobuf.ByteString getEndpointsBytes(int index);
  }
  /**
   *
   *
   * <pre>
   * Data from Vertex AI Endpoint request response logging.
   * </pre>
   *
   * Protobuf type {@code google.cloud.aiplatform.v1beta1.ModelMonitoringInput.VertexEndpointLogs}
   */
  public static final class VertexEndpointLogs extends com.google.protobuf.GeneratedMessageV3
      implements
      // @@protoc_insertion_point(message_implements:google.cloud.aiplatform.v1beta1.ModelMonitoringInput.VertexEndpointLogs)
      VertexEndpointLogsOrBuilder {
    private static final long serialVersionUID = 0L;
    // Use VertexEndpointLogs.newBuilder() to construct.
    private VertexEndpointLogs(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
      super(builder);
    }

    private VertexEndpointLogs() {
      endpoints_ = com.google.protobuf.LazyStringArrayList.emptyList();
    }

    @java.lang.Override
    @SuppressWarnings({"unused"})
    protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
      return new VertexEndpointLogs();
    }

    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.aiplatform.v1beta1.ModelMonitoringSpecProto
          .internal_static_google_cloud_aiplatform_v1beta1_ModelMonitoringInput_VertexEndpointLogs_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.aiplatform.v1beta1.ModelMonitoringSpecProto
          .internal_static_google_cloud_aiplatform_v1beta1_ModelMonitoringInput_VertexEndpointLogs_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.aiplatform.v1beta1.ModelMonitoringInput.VertexEndpointLogs.class,
              com.google.cloud.aiplatform.v1beta1.ModelMonitoringInput.VertexEndpointLogs.Builder
                  .class);
    }

    public static final int ENDPOINTS_FIELD_NUMBER = 1;

    @SuppressWarnings("serial")
    private com.google.protobuf.LazyStringArrayList endpoints_ =
        com.google.protobuf.LazyStringArrayList.emptyList();
    /**
     *
     *
     * <pre>
     * List of endpoint resource names. The endpoints must enable the logging
     * with the [Endpoint].[request_response_logging_config], and must contain
     * the deployed model corresponding to the model version specified in
     * [ModelMonitor].[model_monitoring_target].
     * </pre>
     *
     * <code>repeated string endpoints = 1 [(.google.api.resource_reference) = { ... }</code>
     *
     * @return A list containing the endpoints.
     */
    public com.google.protobuf.ProtocolStringList getEndpointsList() {
      return endpoints_;
    }
    /**
     *
     *
     * <pre>
     * List of endpoint resource names. The endpoints must enable the logging
     * with the [Endpoint].[request_response_logging_config], and must contain
     * the deployed model corresponding to the model version specified in
     * [ModelMonitor].[model_monitoring_target].
     * </pre>
     *
     * <code>repeated string endpoints = 1 [(.google.api.resource_reference) = { ... }</code>
     *
     * @return The count of endpoints.
     */
    public int getEndpointsCount() {
      return endpoints_.size();
    }
    /**
     *
     *
     * <pre>
     * List of endpoint resource names. The endpoints must enable the logging
     * with the [Endpoint].[request_response_logging_config], and must contain
     * the deployed model corresponding to the model version specified in
     * [ModelMonitor].[model_monitoring_target].
     * </pre>
     *
     * <code>repeated string endpoints = 1 [(.google.api.resource_reference) = { ... }</code>
     *
     * @param index The index of the element to return.
     * @return The endpoints at the given index.
     */
    public java.lang.String getEndpoints(int index) {
      return endpoints_.get(index);
    }
    /**
     *
     *
     * <pre>
     * List of endpoint resource names. The endpoints must enable the logging
     * with the [Endpoint].[request_response_logging_config], and must contain
     * the deployed model corresponding to the model version specified in
     * [ModelMonitor].[model_monitoring_target].
     * </pre>
     *
     * <code>repeated string endpoints = 1 [(.google.api.resource_reference) = { ... }</code>
     *
     * @param index The index of the value to return.
     * @return The bytes of the endpoints at the given index.
     */
    public com.google.protobuf.ByteString getEndpointsBytes(int index) {
      return endpoints_.getByteString(index);
    }

    private byte memoizedIsInitialized = -1;

    @java.lang.Override
    public final boolean isInitialized() {
      byte isInitialized = memoizedIsInitialized;
      if (isInitialized == 1) return true;
      if (isInitialized == 0) return false;

      memoizedIsInitialized = 1;
      return true;
    }

    @java.lang.Override
    public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
      for (int i = 0; i < endpoints_.size(); i++) {
        com.google.protobuf.GeneratedMessageV3.writeString(output, 1, endpoints_.getRaw(i));
      }
      getUnknownFields().writeTo(output);
    }

    @java.lang.Override
    public int getSerializedSize() {
      int size = memoizedSize;
      if (size != -1) return size;

      size = 0;
      {
        int dataSize = 0;
        for (int i = 0; i < endpoints_.size(); i++) {
          dataSize += computeStringSizeNoTag(endpoints_.getRaw(i));
        }
        size += dataSize;
        size += 1 * getEndpointsList().size();
      }
      size += getUnknownFields().getSerializedSize();
      memoizedSize = size;
      return size;
    }

    @java.lang.Override
    public boolean equals(final java.lang.Object obj) {
      if (obj == this) {
        return true;
      }
      if (!(obj
          instanceof com.google.cloud.aiplatform.v1beta1.ModelMonitoringInput.VertexEndpointLogs)) {
        return super.equals(obj);
      }
      com.google.cloud.aiplatform.v1beta1.ModelMonitoringInput.VertexEndpointLogs other =
          (com.google.cloud.aiplatform.v1beta1.ModelMonitoringInput.VertexEndpointLogs) obj;

      if (!getEndpointsList().equals(other.getEndpointsList())) return false;
      if (!getUnknownFields().equals(other.getUnknownFields())) return false;
      return true;
    }

    @java.lang.Override
    public int hashCode() {
      if (memoizedHashCode != 0) {
        return memoizedHashCode;
      }
      int hash = 41;
      hash = (19 * hash) + getDescriptor().hashCode();
      if (getEndpointsCount() > 0) {
        hash = (37 * hash) + ENDPOINTS_FIELD_NUMBER;
        hash = (53 * hash) + getEndpointsList().hashCode();
      }
      hash = (29 * hash) + getUnknownFields().hashCode();
      memoizedHashCode = hash;
      return hash;
    }

    public static com.google.cloud.aiplatform.v1beta1.ModelMonitoringInput.VertexEndpointLogs
        parseFrom(java.nio.ByteBuffer data)
            throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.aiplatform.v1beta1.ModelMonitoringInput.VertexEndpointLogs
        parseFrom(
            java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.aiplatform.v1beta1.ModelMonitoringInput.VertexEndpointLogs
        parseFrom(com.google.protobuf.ByteString data)
            throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.aiplatform.v1beta1.ModelMonitoringInput.VertexEndpointLogs
        parseFrom(
            com.google.protobuf.ByteString data,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.aiplatform.v1beta1.ModelMonitoringInput.VertexEndpointLogs
        parseFrom(byte[] data) throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.aiplatform.v1beta1.ModelMonitoringInput.VertexEndpointLogs
        parseFrom(byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.aiplatform.v1beta1.ModelMonitoringInput.VertexEndpointLogs
        parseFrom(java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.cloud.aiplatform.v1beta1.ModelMonitoringInput.VertexEndpointLogs
        parseFrom(
            java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.cloud.aiplatform.v1beta1.ModelMonitoringInput.VertexEndpointLogs
        parseDelimitedFrom(java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
    }

    public static com.google.cloud.aiplatform.v1beta1.ModelMonitoringInput.VertexEndpointLogs
        parseDelimitedFrom(
            java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.cloud.aiplatform.v1beta1.ModelMonitoringInput.VertexEndpointLogs
        parseFrom(com.google.protobuf.CodedInputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.cloud.aiplatform.v1beta1.ModelMonitoringInput.VertexEndpointLogs
        parseFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    @java.lang.Override
    public Builder newBuilderForType() {
      return newBuilder();
    }

    public static Builder newBuilder() {
      return DEFAULT_INSTANCE.toBuilder();
    }

    public static Builder newBuilder(
        com.google.cloud.aiplatform.v1beta1.ModelMonitoringInput.VertexEndpointLogs prototype) {
      return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }

    @java.lang.Override
    public Builder toBuilder() {
      return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
    }

    @java.lang.Override
    protected Builder newBuilderForType(
        com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      Builder builder = new Builder(parent);
      return builder;
    }
    /**
     *
     *
     * <pre>
     * Data from Vertex AI Endpoint request response logging.
     * </pre>
     *
     * Protobuf type {@code google.cloud.aiplatform.v1beta1.ModelMonitoringInput.VertexEndpointLogs}
     */
    public static final class Builder
        extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
        implements
        // @@protoc_insertion_point(builder_implements:google.cloud.aiplatform.v1beta1.ModelMonitoringInput.VertexEndpointLogs)
        com.google.cloud.aiplatform.v1beta1.ModelMonitoringInput.VertexEndpointLogsOrBuilder {
      public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
        return com.google.cloud.aiplatform.v1beta1.ModelMonitoringSpecProto
            .internal_static_google_cloud_aiplatform_v1beta1_ModelMonitoringInput_VertexEndpointLogs_descriptor;
      }

      @java.lang.Override
      protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return com.google.cloud.aiplatform.v1beta1.ModelMonitoringSpecProto
            .internal_static_google_cloud_aiplatform_v1beta1_ModelMonitoringInput_VertexEndpointLogs_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                com.google.cloud.aiplatform.v1beta1.ModelMonitoringInput.VertexEndpointLogs.class,
                com.google.cloud.aiplatform.v1beta1.ModelMonitoringInput.VertexEndpointLogs.Builder
                    .class);
      }

      // Construct using
      // com.google.cloud.aiplatform.v1beta1.ModelMonitoringInput.VertexEndpointLogs.newBuilder()
      private Builder() {}

      private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
        super(parent);
      }

      @java.lang.Override
      public Builder clear() {
        super.clear();
        bitField0_ = 0;
        endpoints_ = com.google.protobuf.LazyStringArrayList.emptyList();
        return this;
      }

      @java.lang.Override
      public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
        return com.google.cloud.aiplatform.v1beta1.ModelMonitoringSpecProto
            .internal_static_google_cloud_aiplatform_v1beta1_ModelMonitoringInput_VertexEndpointLogs_descriptor;
      }

      @java.lang.Override
      public com.google.cloud.aiplatform.v1beta1.ModelMonitoringInput.VertexEndpointLogs
          getDefaultInstanceForType() {
        return com.google.cloud.aiplatform.v1beta1.ModelMonitoringInput.VertexEndpointLogs
            .getDefaultInstance();
      }

      @java.lang.Override
      public com.google.cloud.aiplatform.v1beta1.ModelMonitoringInput.VertexEndpointLogs build() {
        com.google.cloud.aiplatform.v1beta1.ModelMonitoringInput.VertexEndpointLogs result =
            buildPartial();
        if (!result.isInitialized()) {
          throw newUninitializedMessageException(result);
        }
        return result;
      }

      @java.lang.Override
      public com.google.cloud.aiplatform.v1beta1.ModelMonitoringInput.VertexEndpointLogs
          buildPartial() {
        com.google.cloud.aiplatform.v1beta1.ModelMonitoringInput.VertexEndpointLogs result =
            new com.google.cloud.aiplatform.v1beta1.ModelMonitoringInput.VertexEndpointLogs(this);
        if (bitField0_ != 0) {
          buildPartial0(result);
        }
        onBuilt();
        return result;
      }

      private void buildPartial0(
          com.google.cloud.aiplatform.v1beta1.ModelMonitoringInput.VertexEndpointLogs result) {
        int from_bitField0_ = bitField0_;
        if (((from_bitField0_ & 0x00000001) != 0)) {
          endpoints_.makeImmutable();
          result.endpoints_ = endpoints_;
        }
      }

      @java.lang.Override
      public Builder clone() {
        return super.clone();
      }

      @java.lang.Override
      public Builder setField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.setField(field, value);
      }

      @java.lang.Override
      public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
        return super.clearField(field);
      }

      @java.lang.Override
      public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
        return super.clearOneof(oneof);
      }

      @java.lang.Override
      public Builder setRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          int index,
          java.lang.Object value) {
        return super.setRepeatedField(field, index, value);
      }

      @java.lang.Override
      public Builder addRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.addRepeatedField(field, value);
      }

      @java.lang.Override
      public Builder mergeFrom(com.google.protobuf.Message other) {
        if (other
            instanceof
            com.google.cloud.aiplatform.v1beta1.ModelMonitoringInput.VertexEndpointLogs) {
          return mergeFrom(
              (com.google.cloud.aiplatform.v1beta1.ModelMonitoringInput.VertexEndpointLogs) other);
        } else {
          super.mergeFrom(other);
          return this;
        }
      }

      public Builder mergeFrom(
          com.google.cloud.aiplatform.v1beta1.ModelMonitoringInput.VertexEndpointLogs other) {
        if (other
            == com.google.cloud.aiplatform.v1beta1.ModelMonitoringInput.VertexEndpointLogs
                .getDefaultInstance()) return this;
        if (!other.endpoints_.isEmpty()) {
          if (endpoints_.isEmpty()) {
            endpoints_ = other.endpoints_;
            bitField0_ |= 0x00000001;
          } else {
            ensureEndpointsIsMutable();
            endpoints_.addAll(other.endpoints_);
          }
          onChanged();
        }
        this.mergeUnknownFields(other.getUnknownFields());
        onChanged();
        return this;
      }

      @java.lang.Override
      public final boolean isInitialized() {
        return true;
      }

      @java.lang.Override
      public Builder mergeFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        if (extensionRegistry == null) {
          throw new java.lang.NullPointerException();
        }
        try {
          boolean done = false;
          while (!done) {
            int tag = input.readTag();
            switch (tag) {
              case 0:
                done = true;
                break;
              case 10:
                {
                  java.lang.String s = input.readStringRequireUtf8();
                  ensureEndpointsIsMutable();
                  endpoints_.add(s);
                  break;
                } // case 10
              default:
                {
                  if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                    done = true; // was an endgroup tag
                  }
                  break;
                } // default:
            } // switch (tag)
          } // while (!done)
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          throw e.unwrapIOException();
        } finally {
          onChanged();
        } // finally
        return this;
      }

      private int bitField0_;

      private com.google.protobuf.LazyStringArrayList endpoints_ =
          com.google.protobuf.LazyStringArrayList.emptyList();

      private void ensureEndpointsIsMutable() {
        if (!endpoints_.isModifiable()) {
          endpoints_ = new com.google.protobuf.LazyStringArrayList(endpoints_);
        }
        bitField0_ |= 0x00000001;
      }
      /**
       *
       *
       * <pre>
       * List of endpoint resource names. The endpoints must enable the logging
       * with the [Endpoint].[request_response_logging_config], and must contain
       * the deployed model corresponding to the model version specified in
       * [ModelMonitor].[model_monitoring_target].
       * </pre>
       *
       * <code>repeated string endpoints = 1 [(.google.api.resource_reference) = { ... }</code>
       *
       * @return A list containing the endpoints.
       */
      public com.google.protobuf.ProtocolStringList getEndpointsList() {
        endpoints_.makeImmutable();
        return endpoints_;
      }
      /**
       *
       *
       * <pre>
       * List of endpoint resource names. The endpoints must enable the logging
       * with the [Endpoint].[request_response_logging_config], and must contain
       * the deployed model corresponding to the model version specified in
       * [ModelMonitor].[model_monitoring_target].
       * </pre>
       *
       * <code>repeated string endpoints = 1 [(.google.api.resource_reference) = { ... }</code>
       *
       * @return The count of endpoints.
       */
      public int getEndpointsCount() {
        return endpoints_.size();
      }
      /**
       *
       *
       * <pre>
       * List of endpoint resource names. The endpoints must enable the logging
       * with the [Endpoint].[request_response_logging_config], and must contain
       * the deployed model corresponding to the model version specified in
       * [ModelMonitor].[model_monitoring_target].
       * </pre>
       *
       * <code>repeated string endpoints = 1 [(.google.api.resource_reference) = { ... }</code>
       *
       * @param index The index of the element to return.
       * @return The endpoints at the given index.
       */
      public java.lang.String getEndpoints(int index) {
        return endpoints_.get(index);
      }
      /**
       *
       *
       * <pre>
       * List of endpoint resource names. The endpoints must enable the logging
       * with the [Endpoint].[request_response_logging_config], and must contain
       * the deployed model corresponding to the model version specified in
       * [ModelMonitor].[model_monitoring_target].
       * </pre>
       *
       * <code>repeated string endpoints = 1 [(.google.api.resource_reference) = { ... }</code>
       *
       * @param index The index of the value to return.
       * @return The bytes of the endpoints at the given index.
       */
      public com.google.protobuf.ByteString getEndpointsBytes(int index) {
        return endpoints_.getByteString(index);
      }
      /**
       *
       *
       * <pre>
       * List of endpoint resource names. The endpoints must enable the logging
       * with the [Endpoint].[request_response_logging_config], and must contain
       * the deployed model corresponding to the model version specified in
       * [ModelMonitor].[model_monitoring_target].
       * </pre>
       *
       * <code>repeated string endpoints = 1 [(.google.api.resource_reference) = { ... }</code>
       *
       * @param index The index to set the value at.
       * @param value The endpoints to set.
       * @return This builder for chaining.
       */
      public Builder setEndpoints(int index, java.lang.String value) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureEndpointsIsMutable();
        endpoints_.set(index, value);
        bitField0_ |= 0x00000001;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * List of endpoint resource names. The endpoints must enable the logging
       * with the [Endpoint].[request_response_logging_config], and must contain
       * the deployed model corresponding to the model version specified in
       * [ModelMonitor].[model_monitoring_target].
       * </pre>
       *
       * <code>repeated string endpoints = 1 [(.google.api.resource_reference) = { ... }</code>
       *
       * @param value The endpoints to add.
       * @return This builder for chaining.
       */
      public Builder addEndpoints(java.lang.String value) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureEndpointsIsMutable();
        endpoints_.add(value);
        bitField0_ |= 0x00000001;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * List of endpoint resource names. The endpoints must enable the logging
       * with the [Endpoint].[request_response_logging_config], and must contain
       * the deployed model corresponding to the model version specified in
       * [ModelMonitor].[model_monitoring_target].
       * </pre>
       *
       * <code>repeated string endpoints = 1 [(.google.api.resource_reference) = { ... }</code>
       *
       * @param values The endpoints to add.
       * @return This builder for chaining.
       */
      public Builder addAllEndpoints(java.lang.Iterable<java.lang.String> values) {
        ensureEndpointsIsMutable();
        com.google.protobuf.AbstractMessageLite.Builder.addAll(values, endpoints_);
        bitField0_ |= 0x00000001;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * List of endpoint resource names. The endpoints must enable the logging
       * with the [Endpoint].[request_response_logging_config], and must contain
       * the deployed model corresponding to the model version specified in
       * [ModelMonitor].[model_monitoring_target].
       * </pre>
       *
       * <code>repeated string endpoints = 1 [(.google.api.resource_reference) = { ... }</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearEndpoints() {
        endpoints_ = com.google.protobuf.LazyStringArrayList.emptyList();
        bitField0_ = (bitField0_ & ~0x00000001);
        ;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * List of endpoint resource names. The endpoints must enable the logging
       * with the [Endpoint].[request_response_logging_config], and must contain
       * the deployed model corresponding to the model version specified in
       * [ModelMonitor].[model_monitoring_target].
       * </pre>
       *
       * <code>repeated string endpoints = 1 [(.google.api.resource_reference) = { ... }</code>
       *
       * @param value The bytes of the endpoints to add.
       * @return This builder for chaining.
       */
      public Builder addEndpointsBytes(com.google.protobuf.ByteString value) {
        if (value == null) {
          throw new NullPointerException();
        }
        checkByteStringIsUtf8(value);
        ensureEndpointsIsMutable();
        endpoints_.add(value);
        bitField0_ |= 0x00000001;
        onChanged();
        return this;
      }

      @java.lang.Override
      public final Builder setUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.setUnknownFields(unknownFields);
      }

      @java.lang.Override
      public final Builder mergeUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.mergeUnknownFields(unknownFields);
      }

      // @@protoc_insertion_point(builder_scope:google.cloud.aiplatform.v1beta1.ModelMonitoringInput.VertexEndpointLogs)
    }

    // @@protoc_insertion_point(class_scope:google.cloud.aiplatform.v1beta1.ModelMonitoringInput.VertexEndpointLogs)
    private static final com.google.cloud.aiplatform.v1beta1.ModelMonitoringInput.VertexEndpointLogs
        DEFAULT_INSTANCE;

    static {
      DEFAULT_INSTANCE =
          new com.google.cloud.aiplatform.v1beta1.ModelMonitoringInput.VertexEndpointLogs();
    }

    public static com.google.cloud.aiplatform.v1beta1.ModelMonitoringInput.VertexEndpointLogs
        getDefaultInstance() {
      return DEFAULT_INSTANCE;
    }

    private static final com.google.protobuf.Parser<VertexEndpointLogs> PARSER =
        new com.google.protobuf.AbstractParser<VertexEndpointLogs>() {
          @java.lang.Override
          public VertexEndpointLogs parsePartialFrom(
              com.google.protobuf.CodedInputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
            Builder builder = newBuilder();
            try {
              builder.mergeFrom(input, extensionRegistry);
            } catch (com.google.protobuf.InvalidProtocolBufferException e) {
              throw e.setUnfinishedMessage(builder.buildPartial());
            } catch (com.google.protobuf.UninitializedMessageException e) {
              throw e.asInvalidProtocolBufferException()
                  .setUnfinishedMessage(builder.buildPartial());
            } catch (java.io.IOException e) {
              throw new com.google.protobuf.InvalidProtocolBufferException(e)
                  .setUnfinishedMessage(builder.buildPartial());
            }
            return builder.buildPartial();
          }
        };

    public static com.google.protobuf.Parser<VertexEndpointLogs> parser() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.protobuf.Parser<VertexEndpointLogs> getParserForType() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.cloud.aiplatform.v1beta1.ModelMonitoringInput.VertexEndpointLogs
        getDefaultInstanceForType() {
      return DEFAULT_INSTANCE;
    }
  }

  public interface TimeOffsetOrBuilder
      extends
      // @@protoc_insertion_point(interface_extends:google.cloud.aiplatform.v1beta1.ModelMonitoringInput.TimeOffset)
      com.google.protobuf.MessageOrBuilder {

    /**
     *
     *
     * <pre>
     * [offset] is the time difference from the cut-off time.
     * For scheduled jobs, the cut-off time is the scheduled time.
     * For non-scheduled jobs, it's the time when the job was created.
     * Currently we support the following format:
     * 'w|W': Week, 'd|D': Day, 'h|H': Hour
     * E.g. '1h' stands for 1 hour, '2d' stands for 2 days.
     * </pre>
     *
     * <code>string offset = 1;</code>
     *
     * @return The offset.
     */
    java.lang.String getOffset();
    /**
     *
     *
     * <pre>
     * [offset] is the time difference from the cut-off time.
     * For scheduled jobs, the cut-off time is the scheduled time.
     * For non-scheduled jobs, it's the time when the job was created.
     * Currently we support the following format:
     * 'w|W': Week, 'd|D': Day, 'h|H': Hour
     * E.g. '1h' stands for 1 hour, '2d' stands for 2 days.
     * </pre>
     *
     * <code>string offset = 1;</code>
     *
     * @return The bytes for offset.
     */
    com.google.protobuf.ByteString getOffsetBytes();

    /**
     *
     *
     * <pre>
     * [window] refers to the scope of data selected for analysis.
     * It allows you to specify the quantity of data you wish to examine.
     * Currently we support the following format:
     * 'w|W': Week, 'd|D': Day, 'h|H': Hour
     * E.g. '1h' stands for 1 hour, '2d' stands for 2 days.
     * </pre>
     *
     * <code>string window = 2;</code>
     *
     * @return The window.
     */
    java.lang.String getWindow();
    /**
     *
     *
     * <pre>
     * [window] refers to the scope of data selected for analysis.
     * It allows you to specify the quantity of data you wish to examine.
     * Currently we support the following format:
     * 'w|W': Week, 'd|D': Day, 'h|H': Hour
     * E.g. '1h' stands for 1 hour, '2d' stands for 2 days.
     * </pre>
     *
     * <code>string window = 2;</code>
     *
     * @return The bytes for window.
     */
    com.google.protobuf.ByteString getWindowBytes();
  }
  /**
   *
   *
   * <pre>
   * Time offset setting.
   * </pre>
   *
   * Protobuf type {@code google.cloud.aiplatform.v1beta1.ModelMonitoringInput.TimeOffset}
   */
  public static final class TimeOffset extends com.google.protobuf.GeneratedMessageV3
      implements
      // @@protoc_insertion_point(message_implements:google.cloud.aiplatform.v1beta1.ModelMonitoringInput.TimeOffset)
      TimeOffsetOrBuilder {
    private static final long serialVersionUID = 0L;
    // Use TimeOffset.newBuilder() to construct.
    private TimeOffset(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
      super(builder);
    }

    private TimeOffset() {
      offset_ = "";
      window_ = "";
    }

    @java.lang.Override
    @SuppressWarnings({"unused"})
    protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
      return new TimeOffset();
    }

    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.aiplatform.v1beta1.ModelMonitoringSpecProto
          .internal_static_google_cloud_aiplatform_v1beta1_ModelMonitoringInput_TimeOffset_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.aiplatform.v1beta1.ModelMonitoringSpecProto
          .internal_static_google_cloud_aiplatform_v1beta1_ModelMonitoringInput_TimeOffset_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.aiplatform.v1beta1.ModelMonitoringInput.TimeOffset.class,
              com.google.cloud.aiplatform.v1beta1.ModelMonitoringInput.TimeOffset.Builder.class);
    }

    public static final int OFFSET_FIELD_NUMBER = 1;

    @SuppressWarnings("serial")
    private volatile java.lang.Object offset_ = "";
    /**
     *
     *
     * <pre>
     * [offset] is the time difference from the cut-off time.
     * For scheduled jobs, the cut-off time is the scheduled time.
     * For non-scheduled jobs, it's the time when the job was created.
     * Currently we support the following format:
     * 'w|W': Week, 'd|D': Day, 'h|H': Hour
     * E.g. '1h' stands for 1 hour, '2d' stands for 2 days.
     * </pre>
     *
     * <code>string offset = 1;</code>
     *
     * @return The offset.
     */
    @java.lang.Override
    public java.lang.String getOffset() {
      java.lang.Object ref = offset_;
      if (ref instanceof java.lang.String) {
        return (java.lang.String) ref;
      } else {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        offset_ = s;
        return s;
      }
    }
    /**
     *
     *
     * <pre>
     * [offset] is the time difference from the cut-off time.
     * For scheduled jobs, the cut-off time is the scheduled time.
     * For non-scheduled jobs, it's the time when the job was created.
     * Currently we support the following format:
     * 'w|W': Week, 'd|D': Day, 'h|H': Hour
     * E.g. '1h' stands for 1 hour, '2d' stands for 2 days.
     * </pre>
     *
     * <code>string offset = 1;</code>
     *
     * @return The bytes for offset.
     */
    @java.lang.Override
    public com.google.protobuf.ByteString getOffsetBytes() {
      java.lang.Object ref = offset_;
      if (ref instanceof java.lang.String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        offset_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    public static final int WINDOW_FIELD_NUMBER = 2;

    @SuppressWarnings("serial")
    private volatile java.lang.Object window_ = "";
    /**
     *
     *
     * <pre>
     * [window] refers to the scope of data selected for analysis.
     * It allows you to specify the quantity of data you wish to examine.
     * Currently we support the following format:
     * 'w|W': Week, 'd|D': Day, 'h|H': Hour
     * E.g. '1h' stands for 1 hour, '2d' stands for 2 days.
     * </pre>
     *
     * <code>string window = 2;</code>
     *
     * @return The window.
     */
    @java.lang.Override
    public java.lang.String getWindow() {
      java.lang.Object ref = window_;
      if (ref instanceof java.lang.String) {
        return (java.lang.String) ref;
      } else {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        window_ = s;
        return s;
      }
    }
    /**
     *
     *
     * <pre>
     * [window] refers to the scope of data selected for analysis.
     * It allows you to specify the quantity of data you wish to examine.
     * Currently we support the following format:
     * 'w|W': Week, 'd|D': Day, 'h|H': Hour
     * E.g. '1h' stands for 1 hour, '2d' stands for 2 days.
     * </pre>
     *
     * <code>string window = 2;</code>
     *
     * @return The bytes for window.
     */
    @java.lang.Override
    public com.google.protobuf.ByteString getWindowBytes() {
      java.lang.Object ref = window_;
      if (ref instanceof java.lang.String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        window_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    private byte memoizedIsInitialized = -1;

    @java.lang.Override
    public final boolean isInitialized() {
      byte isInitialized = memoizedIsInitialized;
      if (isInitialized == 1) return true;
      if (isInitialized == 0) return false;

      memoizedIsInitialized = 1;
      return true;
    }

    @java.lang.Override
    public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(offset_)) {
        com.google.protobuf.GeneratedMessageV3.writeString(output, 1, offset_);
      }
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(window_)) {
        com.google.protobuf.GeneratedMessageV3.writeString(output, 2, window_);
      }
      getUnknownFields().writeTo(output);
    }

    @java.lang.Override
    public int getSerializedSize() {
      int size = memoizedSize;
      if (size != -1) return size;

      size = 0;
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(offset_)) {
        size += com.google.protobuf.GeneratedMessageV3.computeStringSize(1, offset_);
      }
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(window_)) {
        size += com.google.protobuf.GeneratedMessageV3.computeStringSize(2, window_);
      }
      size += getUnknownFields().getSerializedSize();
      memoizedSize = size;
      return size;
    }

    @java.lang.Override
    public boolean equals(final java.lang.Object obj) {
      if (obj == this) {
        return true;
      }
      if (!(obj instanceof com.google.cloud.aiplatform.v1beta1.ModelMonitoringInput.TimeOffset)) {
        return super.equals(obj);
      }
      com.google.cloud.aiplatform.v1beta1.ModelMonitoringInput.TimeOffset other =
          (com.google.cloud.aiplatform.v1beta1.ModelMonitoringInput.TimeOffset) obj;

      if (!getOffset().equals(other.getOffset())) return false;
      if (!getWindow().equals(other.getWindow())) return false;
      if (!getUnknownFields().equals(other.getUnknownFields())) return false;
      return true;
    }

    @java.lang.Override
    public int hashCode() {
      if (memoizedHashCode != 0) {
        return memoizedHashCode;
      }
      int hash = 41;
      hash = (19 * hash) + getDescriptor().hashCode();
      hash = (37 * hash) + OFFSET_FIELD_NUMBER;
      hash = (53 * hash) + getOffset().hashCode();
      hash = (37 * hash) + WINDOW_FIELD_NUMBER;
      hash = (53 * hash) + getWindow().hashCode();
      hash = (29 * hash) + getUnknownFields().hashCode();
      memoizedHashCode = hash;
      return hash;
    }

    public static com.google.cloud.aiplatform.v1beta1.ModelMonitoringInput.TimeOffset parseFrom(
        java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.aiplatform.v1beta1.ModelMonitoringInput.TimeOffset parseFrom(
        java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.aiplatform.v1beta1.ModelMonitoringInput.TimeOffset parseFrom(
        com.google.protobuf.ByteString data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.aiplatform.v1beta1.ModelMonitoringInput.TimeOffset parseFrom(
        com.google.protobuf.ByteString data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.aiplatform.v1beta1.ModelMonitoringInput.TimeOffset parseFrom(
        byte[] data) throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.aiplatform.v1beta1.ModelMonitoringInput.TimeOffset parseFrom(
        byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.aiplatform.v1beta1.ModelMonitoringInput.TimeOffset parseFrom(
        java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.cloud.aiplatform.v1beta1.ModelMonitoringInput.TimeOffset parseFrom(
        java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.cloud.aiplatform.v1beta1.ModelMonitoringInput.TimeOffset
        parseDelimitedFrom(java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
    }

    public static com.google.cloud.aiplatform.v1beta1.ModelMonitoringInput.TimeOffset
        parseDelimitedFrom(
            java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.cloud.aiplatform.v1beta1.ModelMonitoringInput.TimeOffset parseFrom(
        com.google.protobuf.CodedInputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.cloud.aiplatform.v1beta1.ModelMonitoringInput.TimeOffset parseFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    @java.lang.Override
    public Builder newBuilderForType() {
      return newBuilder();
    }

    public static Builder newBuilder() {
      return DEFAULT_INSTANCE.toBuilder();
    }

    public static Builder newBuilder(
        com.google.cloud.aiplatform.v1beta1.ModelMonitoringInput.TimeOffset prototype) {
      return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }

    @java.lang.Override
    public Builder toBuilder() {
      return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
    }

    @java.lang.Override
    protected Builder newBuilderForType(
        com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      Builder builder = new Builder(parent);
      return builder;
    }
    /**
     *
     *
     * <pre>
     * Time offset setting.
     * </pre>
     *
     * Protobuf type {@code google.cloud.aiplatform.v1beta1.ModelMonitoringInput.TimeOffset}
     */
    public static final class Builder
        extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
        implements
        // @@protoc_insertion_point(builder_implements:google.cloud.aiplatform.v1beta1.ModelMonitoringInput.TimeOffset)
        com.google.cloud.aiplatform.v1beta1.ModelMonitoringInput.TimeOffsetOrBuilder {
      public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
        return com.google.cloud.aiplatform.v1beta1.ModelMonitoringSpecProto
            .internal_static_google_cloud_aiplatform_v1beta1_ModelMonitoringInput_TimeOffset_descriptor;
      }

      @java.lang.Override
      protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return com.google.cloud.aiplatform.v1beta1.ModelMonitoringSpecProto
            .internal_static_google_cloud_aiplatform_v1beta1_ModelMonitoringInput_TimeOffset_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                com.google.cloud.aiplatform.v1beta1.ModelMonitoringInput.TimeOffset.class,
                com.google.cloud.aiplatform.v1beta1.ModelMonitoringInput.TimeOffset.Builder.class);
      }

      // Construct using
      // com.google.cloud.aiplatform.v1beta1.ModelMonitoringInput.TimeOffset.newBuilder()
      private Builder() {}

      private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
        super(parent);
      }

      @java.lang.Override
      public Builder clear() {
        super.clear();
        bitField0_ = 0;
        offset_ = "";
        window_ = "";
        return this;
      }

      @java.lang.Override
      public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
        return com.google.cloud.aiplatform.v1beta1.ModelMonitoringSpecProto
            .internal_static_google_cloud_aiplatform_v1beta1_ModelMonitoringInput_TimeOffset_descriptor;
      }

      @java.lang.Override
      public com.google.cloud.aiplatform.v1beta1.ModelMonitoringInput.TimeOffset
          getDefaultInstanceForType() {
        return com.google.cloud.aiplatform.v1beta1.ModelMonitoringInput.TimeOffset
            .getDefaultInstance();
      }

      @java.lang.Override
      public com.google.cloud.aiplatform.v1beta1.ModelMonitoringInput.TimeOffset build() {
        com.google.cloud.aiplatform.v1beta1.ModelMonitoringInput.TimeOffset result = buildPartial();
        if (!result.isInitialized()) {
          throw newUninitializedMessageException(result);
        }
        return result;
      }

      @java.lang.Override
      public com.google.cloud.aiplatform.v1beta1.ModelMonitoringInput.TimeOffset buildPartial() {
        com.google.cloud.aiplatform.v1beta1.ModelMonitoringInput.TimeOffset result =
            new com.google.cloud.aiplatform.v1beta1.ModelMonitoringInput.TimeOffset(this);
        if (bitField0_ != 0) {
          buildPartial0(result);
        }
        onBuilt();
        return result;
      }

      private void buildPartial0(
          com.google.cloud.aiplatform.v1beta1.ModelMonitoringInput.TimeOffset result) {
        int from_bitField0_ = bitField0_;
        if (((from_bitField0_ & 0x00000001) != 0)) {
          result.offset_ = offset_;
        }
        if (((from_bitField0_ & 0x00000002) != 0)) {
          result.window_ = window_;
        }
      }

      @java.lang.Override
      public Builder clone() {
        return super.clone();
      }

      @java.lang.Override
      public Builder setField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.setField(field, value);
      }

      @java.lang.Override
      public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
        return super.clearField(field);
      }

      @java.lang.Override
      public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
        return super.clearOneof(oneof);
      }

      @java.lang.Override
      public Builder setRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          int index,
          java.lang.Object value) {
        return super.setRepeatedField(field, index, value);
      }

      @java.lang.Override
      public Builder addRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.addRepeatedField(field, value);
      }

      @java.lang.Override
      public Builder mergeFrom(com.google.protobuf.Message other) {
        if (other instanceof com.google.cloud.aiplatform.v1beta1.ModelMonitoringInput.TimeOffset) {
          return mergeFrom(
              (com.google.cloud.aiplatform.v1beta1.ModelMonitoringInput.TimeOffset) other);
        } else {
          super.mergeFrom(other);
          return this;
        }
      }

      public Builder mergeFrom(
          com.google.cloud.aiplatform.v1beta1.ModelMonitoringInput.TimeOffset other) {
        if (other
            == com.google.cloud.aiplatform.v1beta1.ModelMonitoringInput.TimeOffset
                .getDefaultInstance()) return this;
        if (!other.getOffset().isEmpty()) {
          offset_ = other.offset_;
          bitField0_ |= 0x00000001;
          onChanged();
        }
        if (!other.getWindow().isEmpty()) {
          window_ = other.window_;
          bitField0_ |= 0x00000002;
          onChanged();
        }
        this.mergeUnknownFields(other.getUnknownFields());
        onChanged();
        return this;
      }

      @java.lang.Override
      public final boolean isInitialized() {
        return true;
      }

      @java.lang.Override
      public Builder mergeFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        if (extensionRegistry == null) {
          throw new java.lang.NullPointerException();
        }
        try {
          boolean done = false;
          while (!done) {
            int tag = input.readTag();
            switch (tag) {
              case 0:
                done = true;
                break;
              case 10:
                {
                  offset_ = input.readStringRequireUtf8();
                  bitField0_ |= 0x00000001;
                  break;
                } // case 10
              case 18:
                {
                  window_ = input.readStringRequireUtf8();
                  bitField0_ |= 0x00000002;
                  break;
                } // case 18
              default:
                {
                  if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                    done = true; // was an endgroup tag
                  }
                  break;
                } // default:
            } // switch (tag)
          } // while (!done)
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          throw e.unwrapIOException();
        } finally {
          onChanged();
        } // finally
        return this;
      }

      private int bitField0_;

      private java.lang.Object offset_ = "";
      /**
       *
       *
       * <pre>
       * [offset] is the time difference from the cut-off time.
       * For scheduled jobs, the cut-off time is the scheduled time.
       * For non-scheduled jobs, it's the time when the job was created.
       * Currently we support the following format:
       * 'w|W': Week, 'd|D': Day, 'h|H': Hour
       * E.g. '1h' stands for 1 hour, '2d' stands for 2 days.
       * </pre>
       *
       * <code>string offset = 1;</code>
       *
       * @return The offset.
       */
      public java.lang.String getOffset() {
        java.lang.Object ref = offset_;
        if (!(ref instanceof java.lang.String)) {
          com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
          java.lang.String s = bs.toStringUtf8();
          offset_ = s;
          return s;
        } else {
          return (java.lang.String) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * [offset] is the time difference from the cut-off time.
       * For scheduled jobs, the cut-off time is the scheduled time.
       * For non-scheduled jobs, it's the time when the job was created.
       * Currently we support the following format:
       * 'w|W': Week, 'd|D': Day, 'h|H': Hour
       * E.g. '1h' stands for 1 hour, '2d' stands for 2 days.
       * </pre>
       *
       * <code>string offset = 1;</code>
       *
       * @return The bytes for offset.
       */
      public com.google.protobuf.ByteString getOffsetBytes() {
        java.lang.Object ref = offset_;
        if (ref instanceof String) {
          com.google.protobuf.ByteString b =
              com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
          offset_ = b;
          return b;
        } else {
          return (com.google.protobuf.ByteString) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * [offset] is the time difference from the cut-off time.
       * For scheduled jobs, the cut-off time is the scheduled time.
       * For non-scheduled jobs, it's the time when the job was created.
       * Currently we support the following format:
       * 'w|W': Week, 'd|D': Day, 'h|H': Hour
       * E.g. '1h' stands for 1 hour, '2d' stands for 2 days.
       * </pre>
       *
       * <code>string offset = 1;</code>
       *
       * @param value The offset to set.
       * @return This builder for chaining.
       */
      public Builder setOffset(java.lang.String value) {
        if (value == null) {
          throw new NullPointerException();
        }
        offset_ = value;
        bitField0_ |= 0x00000001;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * [offset] is the time difference from the cut-off time.
       * For scheduled jobs, the cut-off time is the scheduled time.
       * For non-scheduled jobs, it's the time when the job was created.
       * Currently we support the following format:
       * 'w|W': Week, 'd|D': Day, 'h|H': Hour
       * E.g. '1h' stands for 1 hour, '2d' stands for 2 days.
       * </pre>
       *
       * <code>string offset = 1;</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearOffset() {
        offset_ = getDefaultInstance().getOffset();
        bitField0_ = (bitField0_ & ~0x00000001);
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * [offset] is the time difference from the cut-off time.
       * For scheduled jobs, the cut-off time is the scheduled time.
       * For non-scheduled jobs, it's the time when the job was created.
       * Currently we support the following format:
       * 'w|W': Week, 'd|D': Day, 'h|H': Hour
       * E.g. '1h' stands for 1 hour, '2d' stands for 2 days.
       * </pre>
       *
       * <code>string offset = 1;</code>
       *
       * @param value The bytes for offset to set.
       * @return This builder for chaining.
       */
      public Builder setOffsetBytes(com.google.protobuf.ByteString value) {
        if (value == null) {
          throw new NullPointerException();
        }
        checkByteStringIsUtf8(value);
        offset_ = value;
        bitField0_ |= 0x00000001;
        onChanged();
        return this;
      }

      private java.lang.Object window_ = "";
      /**
       *
       *
       * <pre>
       * [window] refers to the scope of data selected for analysis.
       * It allows you to specify the quantity of data you wish to examine.
       * Currently we support the following format:
       * 'w|W': Week, 'd|D': Day, 'h|H': Hour
       * E.g. '1h' stands for 1 hour, '2d' stands for 2 days.
       * </pre>
       *
       * <code>string window = 2;</code>
       *
       * @return The window.
       */
      public java.lang.String getWindow() {
        java.lang.Object ref = window_;
        if (!(ref instanceof java.lang.String)) {
          com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
          java.lang.String s = bs.toStringUtf8();
          window_ = s;
          return s;
        } else {
          return (java.lang.String) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * [window] refers to the scope of data selected for analysis.
       * It allows you to specify the quantity of data you wish to examine.
       * Currently we support the following format:
       * 'w|W': Week, 'd|D': Day, 'h|H': Hour
       * E.g. '1h' stands for 1 hour, '2d' stands for 2 days.
       * </pre>
       *
       * <code>string window = 2;</code>
       *
       * @return The bytes for window.
       */
      public com.google.protobuf.ByteString getWindowBytes() {
        java.lang.Object ref = window_;
        if (ref instanceof String) {
          com.google.protobuf.ByteString b =
              com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
          window_ = b;
          return b;
        } else {
          return (com.google.protobuf.ByteString) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * [window] refers to the scope of data selected for analysis.
       * It allows you to specify the quantity of data you wish to examine.
       * Currently we support the following format:
       * 'w|W': Week, 'd|D': Day, 'h|H': Hour
       * E.g. '1h' stands for 1 hour, '2d' stands for 2 days.
       * </pre>
       *
       * <code>string window = 2;</code>
       *
       * @param value The window to set.
       * @return This builder for chaining.
       */
      public Builder setWindow(java.lang.String value) {
        if (value == null) {
          throw new NullPointerException();
        }
        window_ = value;
        bitField0_ |= 0x00000002;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * [window] refers to the scope of data selected for analysis.
       * It allows you to specify the quantity of data you wish to examine.
       * Currently we support the following format:
       * 'w|W': Week, 'd|D': Day, 'h|H': Hour
       * E.g. '1h' stands for 1 hour, '2d' stands for 2 days.
       * </pre>
       *
       * <code>string window = 2;</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearWindow() {
        window_ = getDefaultInstance().getWindow();
        bitField0_ = (bitField0_ & ~0x00000002);
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * [window] refers to the scope of data selected for analysis.
       * It allows you to specify the quantity of data you wish to examine.
       * Currently we support the following format:
       * 'w|W': Week, 'd|D': Day, 'h|H': Hour
       * E.g. '1h' stands for 1 hour, '2d' stands for 2 days.
       * </pre>
       *
       * <code>string window = 2;</code>
       *
       * @param value The bytes for window to set.
       * @return This builder for chaining.
       */
      public Builder setWindowBytes(com.google.protobuf.ByteString value) {
        if (value == null) {
          throw new NullPointerException();
        }
        checkByteStringIsUtf8(value);
        window_ = value;
        bitField0_ |= 0x00000002;
        onChanged();
        return this;
      }

      @java.lang.Override
      public final Builder setUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.setUnknownFields(unknownFields);
      }

      @java.lang.Override
      public final Builder mergeUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.mergeUnknownFields(unknownFields);
      }

      // @@protoc_insertion_point(builder_scope:google.cloud.aiplatform.v1beta1.ModelMonitoringInput.TimeOffset)
    }

    // @@protoc_insertion_point(class_scope:google.cloud.aiplatform.v1beta1.ModelMonitoringInput.TimeOffset)
    private static final com.google.cloud.aiplatform.v1beta1.ModelMonitoringInput.TimeOffset
        DEFAULT_INSTANCE;

    static {
      DEFAULT_INSTANCE = new com.google.cloud.aiplatform.v1beta1.ModelMonitoringInput.TimeOffset();
    }

    public static com.google.cloud.aiplatform.v1beta1.ModelMonitoringInput.TimeOffset
        getDefaultInstance() {
      return DEFAULT_INSTANCE;
    }

    private static final com.google.protobuf.Parser<TimeOffset> PARSER =
        new com.google.protobuf.AbstractParser<TimeOffset>() {
          @java.lang.Override
          public TimeOffset parsePartialFrom(
              com.google.protobuf.CodedInputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
            Builder builder = newBuilder();
            try {
              builder.mergeFrom(input, extensionRegistry);
            } catch (com.google.protobuf.InvalidProtocolBufferException e) {
              throw e.setUnfinishedMessage(builder.buildPartial());
            } catch (com.google.protobuf.UninitializedMessageException e) {
              throw e.asInvalidProtocolBufferException()
                  .setUnfinishedMessage(builder.buildPartial());
            } catch (java.io.IOException e) {
              throw new com.google.protobuf.InvalidProtocolBufferException(e)
                  .setUnfinishedMessage(builder.buildPartial());
            }
            return builder.buildPartial();
          }
        };

    public static com.google.protobuf.Parser<TimeOffset> parser() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.protobuf.Parser<TimeOffset> getParserForType() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.cloud.aiplatform.v1beta1.ModelMonitoringInput.TimeOffset
        getDefaultInstanceForType() {
      return DEFAULT_INSTANCE;
    }
  }

  private int datasetCase_ = 0;

  @SuppressWarnings("serial")
  private java.lang.Object dataset_;

  public enum DatasetCase
      implements
          com.google.protobuf.Internal.EnumLite,
          com.google.protobuf.AbstractMessage.InternalOneOfEnum {
    COLUMNIZED_DATASET(1),
    BATCH_PREDICTION_OUTPUT(2),
    VERTEX_ENDPOINT_LOGS(3),
    DATASET_NOT_SET(0);
    private final int value;

    private DatasetCase(int value) {
      this.value = value;
    }
    /**
     * @param value The number of the enum to look for.
     * @return The enum associated with the given number.
     * @deprecated Use {@link #forNumber(int)} instead.
     */
    @java.lang.Deprecated
    public static DatasetCase valueOf(int value) {
      return forNumber(value);
    }

    public static DatasetCase forNumber(int value) {
      switch (value) {
        case 1:
          return COLUMNIZED_DATASET;
        case 2:
          return BATCH_PREDICTION_OUTPUT;
        case 3:
          return VERTEX_ENDPOINT_LOGS;
        case 0:
          return DATASET_NOT_SET;
        default:
          return null;
      }
    }

    public int getNumber() {
      return this.value;
    }
  };

  public DatasetCase getDatasetCase() {
    return DatasetCase.forNumber(datasetCase_);
  }

  private int timeSpecCase_ = 0;

  @SuppressWarnings("serial")
  private java.lang.Object timeSpec_;

  public enum TimeSpecCase
      implements
          com.google.protobuf.Internal.EnumLite,
          com.google.protobuf.AbstractMessage.InternalOneOfEnum {
    TIME_INTERVAL(6),
    TIME_OFFSET(7),
    TIMESPEC_NOT_SET(0);
    private final int value;

    private TimeSpecCase(int value) {
      this.value = value;
    }
    /**
     * @param value The number of the enum to look for.
     * @return The enum associated with the given number.
     * @deprecated Use {@link #forNumber(int)} instead.
     */
    @java.lang.Deprecated
    public static TimeSpecCase valueOf(int value) {
      return forNumber(value);
    }

    public static TimeSpecCase forNumber(int value) {
      switch (value) {
        case 6:
          return TIME_INTERVAL;
        case 7:
          return TIME_OFFSET;
        case 0:
          return TIMESPEC_NOT_SET;
        default:
          return null;
      }
    }

    public int getNumber() {
      return this.value;
    }
  };

  public TimeSpecCase getTimeSpecCase() {
    return TimeSpecCase.forNumber(timeSpecCase_);
  }

  public static final int COLUMNIZED_DATASET_FIELD_NUMBER = 1;
  /**
   *
   *
   * <pre>
   * Columnized dataset.
   * </pre>
   *
   * <code>
   * .google.cloud.aiplatform.v1beta1.ModelMonitoringInput.ModelMonitoringDataset columnized_dataset = 1;
   * </code>
   *
   * @return Whether the columnizedDataset field is set.
   */
  @java.lang.Override
  public boolean hasColumnizedDataset() {
    return datasetCase_ == 1;
  }
  /**
   *
   *
   * <pre>
   * Columnized dataset.
   * </pre>
   *
   * <code>
   * .google.cloud.aiplatform.v1beta1.ModelMonitoringInput.ModelMonitoringDataset columnized_dataset = 1;
   * </code>
   *
   * @return The columnizedDataset.
   */
  @java.lang.Override
  public com.google.cloud.aiplatform.v1beta1.ModelMonitoringInput.ModelMonitoringDataset
      getColumnizedDataset() {
    if (datasetCase_ == 1) {
      return (com.google.cloud.aiplatform.v1beta1.ModelMonitoringInput.ModelMonitoringDataset)
          dataset_;
    }
    return com.google.cloud.aiplatform.v1beta1.ModelMonitoringInput.ModelMonitoringDataset
        .getDefaultInstance();
  }
  /**
   *
   *
   * <pre>
   * Columnized dataset.
   * </pre>
   *
   * <code>
   * .google.cloud.aiplatform.v1beta1.ModelMonitoringInput.ModelMonitoringDataset columnized_dataset = 1;
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.aiplatform.v1beta1.ModelMonitoringInput.ModelMonitoringDatasetOrBuilder
      getColumnizedDatasetOrBuilder() {
    if (datasetCase_ == 1) {
      return (com.google.cloud.aiplatform.v1beta1.ModelMonitoringInput.ModelMonitoringDataset)
          dataset_;
    }
    return com.google.cloud.aiplatform.v1beta1.ModelMonitoringInput.ModelMonitoringDataset
        .getDefaultInstance();
  }

  public static final int BATCH_PREDICTION_OUTPUT_FIELD_NUMBER = 2;
  /**
   *
   *
   * <pre>
   * Vertex AI Batch prediction Job.
   * </pre>
   *
   * <code>
   * .google.cloud.aiplatform.v1beta1.ModelMonitoringInput.BatchPredictionOutput batch_prediction_output = 2;
   * </code>
   *
   * @return Whether the batchPredictionOutput field is set.
   */
  @java.lang.Override
  public boolean hasBatchPredictionOutput() {
    return datasetCase_ == 2;
  }
  /**
   *
   *
   * <pre>
   * Vertex AI Batch prediction Job.
   * </pre>
   *
   * <code>
   * .google.cloud.aiplatform.v1beta1.ModelMonitoringInput.BatchPredictionOutput batch_prediction_output = 2;
   * </code>
   *
   * @return The batchPredictionOutput.
   */
  @java.lang.Override
  public com.google.cloud.aiplatform.v1beta1.ModelMonitoringInput.BatchPredictionOutput
      getBatchPredictionOutput() {
    if (datasetCase_ == 2) {
      return (com.google.cloud.aiplatform.v1beta1.ModelMonitoringInput.BatchPredictionOutput)
          dataset_;
    }
    return com.google.cloud.aiplatform.v1beta1.ModelMonitoringInput.BatchPredictionOutput
        .getDefaultInstance();
  }
  /**
   *
   *
   * <pre>
   * Vertex AI Batch prediction Job.
   * </pre>
   *
   * <code>
   * .google.cloud.aiplatform.v1beta1.ModelMonitoringInput.BatchPredictionOutput batch_prediction_output = 2;
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.aiplatform.v1beta1.ModelMonitoringInput.BatchPredictionOutputOrBuilder
      getBatchPredictionOutputOrBuilder() {
    if (datasetCase_ == 2) {
      return (com.google.cloud.aiplatform.v1beta1.ModelMonitoringInput.BatchPredictionOutput)
          dataset_;
    }
    return com.google.cloud.aiplatform.v1beta1.ModelMonitoringInput.BatchPredictionOutput
        .getDefaultInstance();
  }

  public static final int VERTEX_ENDPOINT_LOGS_FIELD_NUMBER = 3;
  /**
   *
   *
   * <pre>
   * Vertex AI Endpoint request &amp; response logging.
   * </pre>
   *
   * <code>
   * .google.cloud.aiplatform.v1beta1.ModelMonitoringInput.VertexEndpointLogs vertex_endpoint_logs = 3;
   * </code>
   *
   * @return Whether the vertexEndpointLogs field is set.
   */
  @java.lang.Override
  public boolean hasVertexEndpointLogs() {
    return datasetCase_ == 3;
  }
  /**
   *
   *
   * <pre>
   * Vertex AI Endpoint request &amp; response logging.
   * </pre>
   *
   * <code>
   * .google.cloud.aiplatform.v1beta1.ModelMonitoringInput.VertexEndpointLogs vertex_endpoint_logs = 3;
   * </code>
   *
   * @return The vertexEndpointLogs.
   */
  @java.lang.Override
  public com.google.cloud.aiplatform.v1beta1.ModelMonitoringInput.VertexEndpointLogs
      getVertexEndpointLogs() {
    if (datasetCase_ == 3) {
      return (com.google.cloud.aiplatform.v1beta1.ModelMonitoringInput.VertexEndpointLogs) dataset_;
    }
    return com.google.cloud.aiplatform.v1beta1.ModelMonitoringInput.VertexEndpointLogs
        .getDefaultInstance();
  }
  /**
   *
   *
   * <pre>
   * Vertex AI Endpoint request &amp; response logging.
   * </pre>
   *
   * <code>
   * .google.cloud.aiplatform.v1beta1.ModelMonitoringInput.VertexEndpointLogs vertex_endpoint_logs = 3;
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.aiplatform.v1beta1.ModelMonitoringInput.VertexEndpointLogsOrBuilder
      getVertexEndpointLogsOrBuilder() {
    if (datasetCase_ == 3) {
      return (com.google.cloud.aiplatform.v1beta1.ModelMonitoringInput.VertexEndpointLogs) dataset_;
    }
    return com.google.cloud.aiplatform.v1beta1.ModelMonitoringInput.VertexEndpointLogs
        .getDefaultInstance();
  }

  public static final int TIME_INTERVAL_FIELD_NUMBER = 6;
  /**
   *
   *
   * <pre>
   * The time interval (pair of start_time and end_time) for which results
   * should be returned.
   * </pre>
   *
   * <code>.google.type.Interval time_interval = 6;</code>
   *
   * @return Whether the timeInterval field is set.
   */
  @java.lang.Override
  public boolean hasTimeInterval() {
    return timeSpecCase_ == 6;
  }
  /**
   *
   *
   * <pre>
   * The time interval (pair of start_time and end_time) for which results
   * should be returned.
   * </pre>
   *
   * <code>.google.type.Interval time_interval = 6;</code>
   *
   * @return The timeInterval.
   */
  @java.lang.Override
  public com.google.type.Interval getTimeInterval() {
    if (timeSpecCase_ == 6) {
      return (com.google.type.Interval) timeSpec_;
    }
    return com.google.type.Interval.getDefaultInstance();
  }
  /**
   *
   *
   * <pre>
   * The time interval (pair of start_time and end_time) for which results
   * should be returned.
   * </pre>
   *
   * <code>.google.type.Interval time_interval = 6;</code>
   */
  @java.lang.Override
  public com.google.type.IntervalOrBuilder getTimeIntervalOrBuilder() {
    if (timeSpecCase_ == 6) {
      return (com.google.type.Interval) timeSpec_;
    }
    return com.google.type.Interval.getDefaultInstance();
  }

  public static final int TIME_OFFSET_FIELD_NUMBER = 7;
  /**
   *
   *
   * <pre>
   * The time offset setting for which results should be returned.
   * </pre>
   *
   * <code>.google.cloud.aiplatform.v1beta1.ModelMonitoringInput.TimeOffset time_offset = 7;</code>
   *
   * @return Whether the timeOffset field is set.
   */
  @java.lang.Override
  public boolean hasTimeOffset() {
    return timeSpecCase_ == 7;
  }
  /**
   *
   *
   * <pre>
   * The time offset setting for which results should be returned.
   * </pre>
   *
   * <code>.google.cloud.aiplatform.v1beta1.ModelMonitoringInput.TimeOffset time_offset = 7;</code>
   *
   * @return The timeOffset.
   */
  @java.lang.Override
  public com.google.cloud.aiplatform.v1beta1.ModelMonitoringInput.TimeOffset getTimeOffset() {
    if (timeSpecCase_ == 7) {
      return (com.google.cloud.aiplatform.v1beta1.ModelMonitoringInput.TimeOffset) timeSpec_;
    }
    return com.google.cloud.aiplatform.v1beta1.ModelMonitoringInput.TimeOffset.getDefaultInstance();
  }
  /**
   *
   *
   * <pre>
   * The time offset setting for which results should be returned.
   * </pre>
   *
   * <code>.google.cloud.aiplatform.v1beta1.ModelMonitoringInput.TimeOffset time_offset = 7;</code>
   */
  @java.lang.Override
  public com.google.cloud.aiplatform.v1beta1.ModelMonitoringInput.TimeOffsetOrBuilder
      getTimeOffsetOrBuilder() {
    if (timeSpecCase_ == 7) {
      return (com.google.cloud.aiplatform.v1beta1.ModelMonitoringInput.TimeOffset) timeSpec_;
    }
    return com.google.cloud.aiplatform.v1beta1.ModelMonitoringInput.TimeOffset.getDefaultInstance();
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    if (datasetCase_ == 1) {
      output.writeMessage(
          1,
          (com.google.cloud.aiplatform.v1beta1.ModelMonitoringInput.ModelMonitoringDataset)
              dataset_);
    }
    if (datasetCase_ == 2) {
      output.writeMessage(
          2,
          (com.google.cloud.aiplatform.v1beta1.ModelMonitoringInput.BatchPredictionOutput)
              dataset_);
    }
    if (datasetCase_ == 3) {
      output.writeMessage(
          3,
          (com.google.cloud.aiplatform.v1beta1.ModelMonitoringInput.VertexEndpointLogs) dataset_);
    }
    if (timeSpecCase_ == 6) {
      output.writeMessage(6, (com.google.type.Interval) timeSpec_);
    }
    if (timeSpecCase_ == 7) {
      output.writeMessage(
          7, (com.google.cloud.aiplatform.v1beta1.ModelMonitoringInput.TimeOffset) timeSpec_);
    }
    getUnknownFields().writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    if (datasetCase_ == 1) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(
              1,
              (com.google.cloud.aiplatform.v1beta1.ModelMonitoringInput.ModelMonitoringDataset)
                  dataset_);
    }
    if (datasetCase_ == 2) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(
              2,
              (com.google.cloud.aiplatform.v1beta1.ModelMonitoringInput.BatchPredictionOutput)
                  dataset_);
    }
    if (datasetCase_ == 3) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(
              3,
              (com.google.cloud.aiplatform.v1beta1.ModelMonitoringInput.VertexEndpointLogs)
                  dataset_);
    }
    if (timeSpecCase_ == 6) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(
              6, (com.google.type.Interval) timeSpec_);
    }
    if (timeSpecCase_ == 7) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(
              7, (com.google.cloud.aiplatform.v1beta1.ModelMonitoringInput.TimeOffset) timeSpec_);
    }
    size += getUnknownFields().getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.cloud.aiplatform.v1beta1.ModelMonitoringInput)) {
      return super.equals(obj);
    }
    com.google.cloud.aiplatform.v1beta1.ModelMonitoringInput other =
        (com.google.cloud.aiplatform.v1beta1.ModelMonitoringInput) obj;

    if (!getDatasetCase().equals(other.getDatasetCase())) return false;
    switch (datasetCase_) {
      case 1:
        if (!getColumnizedDataset().equals(other.getColumnizedDataset())) return false;
        break;
      case 2:
        if (!getBatchPredictionOutput().equals(other.getBatchPredictionOutput())) return false;
        break;
      case 3:
        if (!getVertexEndpointLogs().equals(other.getVertexEndpointLogs())) return false;
        break;
      case 0:
      default:
    }
    if (!getTimeSpecCase().equals(other.getTimeSpecCase())) return false;
    switch (timeSpecCase_) {
      case 6:
        if (!getTimeInterval().equals(other.getTimeInterval())) return false;
        break;
      case 7:
        if (!getTimeOffset().equals(other.getTimeOffset())) return false;
        break;
      case 0:
      default:
    }
    if (!getUnknownFields().equals(other.getUnknownFields())) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    switch (datasetCase_) {
      case 1:
        hash = (37 * hash) + COLUMNIZED_DATASET_FIELD_NUMBER;
        hash = (53 * hash) + getColumnizedDataset().hashCode();
        break;
      case 2:
        hash = (37 * hash) + BATCH_PREDICTION_OUTPUT_FIELD_NUMBER;
        hash = (53 * hash) + getBatchPredictionOutput().hashCode();
        break;
      case 3:
        hash = (37 * hash) + VERTEX_ENDPOINT_LOGS_FIELD_NUMBER;
        hash = (53 * hash) + getVertexEndpointLogs().hashCode();
        break;
      case 0:
      default:
    }
    switch (timeSpecCase_) {
      case 6:
        hash = (37 * hash) + TIME_INTERVAL_FIELD_NUMBER;
        hash = (53 * hash) + getTimeInterval().hashCode();
        break;
      case 7:
        hash = (37 * hash) + TIME_OFFSET_FIELD_NUMBER;
        hash = (53 * hash) + getTimeOffset().hashCode();
        break;
      case 0:
      default:
    }
    hash = (29 * hash) + getUnknownFields().hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.cloud.aiplatform.v1beta1.ModelMonitoringInput parseFrom(
      java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.aiplatform.v1beta1.ModelMonitoringInput parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.aiplatform.v1beta1.ModelMonitoringInput parseFrom(
      com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.aiplatform.v1beta1.ModelMonitoringInput parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.aiplatform.v1beta1.ModelMonitoringInput parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.aiplatform.v1beta1.ModelMonitoringInput parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.aiplatform.v1beta1.ModelMonitoringInput parseFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.aiplatform.v1beta1.ModelMonitoringInput parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.aiplatform.v1beta1.ModelMonitoringInput parseDelimitedFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.cloud.aiplatform.v1beta1.ModelMonitoringInput parseDelimitedFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.aiplatform.v1beta1.ModelMonitoringInput parseFrom(
      com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.aiplatform.v1beta1.ModelMonitoringInput parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(
      com.google.cloud.aiplatform.v1beta1.ModelMonitoringInput prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }
  /**
   *
   *
   * <pre>
   * Model monitoring data input spec.
   * </pre>
   *
   * Protobuf type {@code google.cloud.aiplatform.v1beta1.ModelMonitoringInput}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.cloud.aiplatform.v1beta1.ModelMonitoringInput)
      com.google.cloud.aiplatform.v1beta1.ModelMonitoringInputOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.aiplatform.v1beta1.ModelMonitoringSpecProto
          .internal_static_google_cloud_aiplatform_v1beta1_ModelMonitoringInput_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.aiplatform.v1beta1.ModelMonitoringSpecProto
          .internal_static_google_cloud_aiplatform_v1beta1_ModelMonitoringInput_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.aiplatform.v1beta1.ModelMonitoringInput.class,
              com.google.cloud.aiplatform.v1beta1.ModelMonitoringInput.Builder.class);
    }

    // Construct using com.google.cloud.aiplatform.v1beta1.ModelMonitoringInput.newBuilder()
    private Builder() {}

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      bitField0_ = 0;
      if (columnizedDatasetBuilder_ != null) {
        columnizedDatasetBuilder_.clear();
      }
      if (batchPredictionOutputBuilder_ != null) {
        batchPredictionOutputBuilder_.clear();
      }
      if (vertexEndpointLogsBuilder_ != null) {
        vertexEndpointLogsBuilder_.clear();
      }
      if (timeIntervalBuilder_ != null) {
        timeIntervalBuilder_.clear();
      }
      if (timeOffsetBuilder_ != null) {
        timeOffsetBuilder_.clear();
      }
      datasetCase_ = 0;
      dataset_ = null;
      timeSpecCase_ = 0;
      timeSpec_ = null;
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.cloud.aiplatform.v1beta1.ModelMonitoringSpecProto
          .internal_static_google_cloud_aiplatform_v1beta1_ModelMonitoringInput_descriptor;
    }

    @java.lang.Override
    public com.google.cloud.aiplatform.v1beta1.ModelMonitoringInput getDefaultInstanceForType() {
      return com.google.cloud.aiplatform.v1beta1.ModelMonitoringInput.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.cloud.aiplatform.v1beta1.ModelMonitoringInput build() {
      com.google.cloud.aiplatform.v1beta1.ModelMonitoringInput result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.cloud.aiplatform.v1beta1.ModelMonitoringInput buildPartial() {
      com.google.cloud.aiplatform.v1beta1.ModelMonitoringInput result =
          new com.google.cloud.aiplatform.v1beta1.ModelMonitoringInput(this);
      if (bitField0_ != 0) {
        buildPartial0(result);
      }
      buildPartialOneofs(result);
      onBuilt();
      return result;
    }

    private void buildPartial0(com.google.cloud.aiplatform.v1beta1.ModelMonitoringInput result) {
      int from_bitField0_ = bitField0_;
    }

    private void buildPartialOneofs(
        com.google.cloud.aiplatform.v1beta1.ModelMonitoringInput result) {
      result.datasetCase_ = datasetCase_;
      result.dataset_ = this.dataset_;
      if (datasetCase_ == 1 && columnizedDatasetBuilder_ != null) {
        result.dataset_ = columnizedDatasetBuilder_.build();
      }
      if (datasetCase_ == 2 && batchPredictionOutputBuilder_ != null) {
        result.dataset_ = batchPredictionOutputBuilder_.build();
      }
      if (datasetCase_ == 3 && vertexEndpointLogsBuilder_ != null) {
        result.dataset_ = vertexEndpointLogsBuilder_.build();
      }
      result.timeSpecCase_ = timeSpecCase_;
      result.timeSpec_ = this.timeSpec_;
      if (timeSpecCase_ == 6 && timeIntervalBuilder_ != null) {
        result.timeSpec_ = timeIntervalBuilder_.build();
      }
      if (timeSpecCase_ == 7 && timeOffsetBuilder_ != null) {
        result.timeSpec_ = timeOffsetBuilder_.build();
      }
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.cloud.aiplatform.v1beta1.ModelMonitoringInput) {
        return mergeFrom((com.google.cloud.aiplatform.v1beta1.ModelMonitoringInput) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(com.google.cloud.aiplatform.v1beta1.ModelMonitoringInput other) {
      if (other == com.google.cloud.aiplatform.v1beta1.ModelMonitoringInput.getDefaultInstance())
        return this;
      switch (other.getDatasetCase()) {
        case COLUMNIZED_DATASET:
          {
            mergeColumnizedDataset(other.getColumnizedDataset());
            break;
          }
        case BATCH_PREDICTION_OUTPUT:
          {
            mergeBatchPredictionOutput(other.getBatchPredictionOutput());
            break;
          }
        case VERTEX_ENDPOINT_LOGS:
          {
            mergeVertexEndpointLogs(other.getVertexEndpointLogs());
            break;
          }
        case DATASET_NOT_SET:
          {
            break;
          }
      }
      switch (other.getTimeSpecCase()) {
        case TIME_INTERVAL:
          {
            mergeTimeInterval(other.getTimeInterval());
            break;
          }
        case TIME_OFFSET:
          {
            mergeTimeOffset(other.getTimeOffset());
            break;
          }
        case TIMESPEC_NOT_SET:
          {
            break;
          }
      }
      this.mergeUnknownFields(other.getUnknownFields());
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 10:
              {
                input.readMessage(
                    getColumnizedDatasetFieldBuilder().getBuilder(), extensionRegistry);
                datasetCase_ = 1;
                break;
              } // case 10
            case 18:
              {
                input.readMessage(
                    getBatchPredictionOutputFieldBuilder().getBuilder(), extensionRegistry);
                datasetCase_ = 2;
                break;
              } // case 18
            case 26:
              {
                input.readMessage(
                    getVertexEndpointLogsFieldBuilder().getBuilder(), extensionRegistry);
                datasetCase_ = 3;
                break;
              } // case 26
            case 50:
              {
                input.readMessage(getTimeIntervalFieldBuilder().getBuilder(), extensionRegistry);
                timeSpecCase_ = 6;
                break;
              } // case 50
            case 58:
              {
                input.readMessage(getTimeOffsetFieldBuilder().getBuilder(), extensionRegistry);
                timeSpecCase_ = 7;
                break;
              } // case 58
            default:
              {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
          } // switch (tag)
        } // while (!done)
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.unwrapIOException();
      } finally {
        onChanged();
      } // finally
      return this;
    }

    private int datasetCase_ = 0;
    private java.lang.Object dataset_;

    public DatasetCase getDatasetCase() {
      return DatasetCase.forNumber(datasetCase_);
    }

    public Builder clearDataset() {
      datasetCase_ = 0;
      dataset_ = null;
      onChanged();
      return this;
    }

    private int timeSpecCase_ = 0;
    private java.lang.Object timeSpec_;

    public TimeSpecCase getTimeSpecCase() {
      return TimeSpecCase.forNumber(timeSpecCase_);
    }

    public Builder clearTimeSpec() {
      timeSpecCase_ = 0;
      timeSpec_ = null;
      onChanged();
      return this;
    }

    private int bitField0_;

    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.aiplatform.v1beta1.ModelMonitoringInput.ModelMonitoringDataset,
            com.google.cloud.aiplatform.v1beta1.ModelMonitoringInput.ModelMonitoringDataset.Builder,
            com.google.cloud.aiplatform.v1beta1.ModelMonitoringInput
                .ModelMonitoringDatasetOrBuilder>
        columnizedDatasetBuilder_;
    /**
     *
     *
     * <pre>
     * Columnized dataset.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.ModelMonitoringInput.ModelMonitoringDataset columnized_dataset = 1;
     * </code>
     *
     * @return Whether the columnizedDataset field is set.
     */
    @java.lang.Override
    public boolean hasColumnizedDataset() {
      return datasetCase_ == 1;
    }
    /**
     *
     *
     * <pre>
     * Columnized dataset.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.ModelMonitoringInput.ModelMonitoringDataset columnized_dataset = 1;
     * </code>
     *
     * @return The columnizedDataset.
     */
    @java.lang.Override
    public com.google.cloud.aiplatform.v1beta1.ModelMonitoringInput.ModelMonitoringDataset
        getColumnizedDataset() {
      if (columnizedDatasetBuilder_ == null) {
        if (datasetCase_ == 1) {
          return (com.google.cloud.aiplatform.v1beta1.ModelMonitoringInput.ModelMonitoringDataset)
              dataset_;
        }
        return com.google.cloud.aiplatform.v1beta1.ModelMonitoringInput.ModelMonitoringDataset
            .getDefaultInstance();
      } else {
        if (datasetCase_ == 1) {
          return columnizedDatasetBuilder_.getMessage();
        }
        return com.google.cloud.aiplatform.v1beta1.ModelMonitoringInput.ModelMonitoringDataset
            .getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * Columnized dataset.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.ModelMonitoringInput.ModelMonitoringDataset columnized_dataset = 1;
     * </code>
     */
    public Builder setColumnizedDataset(
        com.google.cloud.aiplatform.v1beta1.ModelMonitoringInput.ModelMonitoringDataset value) {
      if (columnizedDatasetBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        dataset_ = value;
        onChanged();
      } else {
        columnizedDatasetBuilder_.setMessage(value);
      }
      datasetCase_ = 1;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Columnized dataset.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.ModelMonitoringInput.ModelMonitoringDataset columnized_dataset = 1;
     * </code>
     */
    public Builder setColumnizedDataset(
        com.google.cloud.aiplatform.v1beta1.ModelMonitoringInput.ModelMonitoringDataset.Builder
            builderForValue) {
      if (columnizedDatasetBuilder_ == null) {
        dataset_ = builderForValue.build();
        onChanged();
      } else {
        columnizedDatasetBuilder_.setMessage(builderForValue.build());
      }
      datasetCase_ = 1;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Columnized dataset.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.ModelMonitoringInput.ModelMonitoringDataset columnized_dataset = 1;
     * </code>
     */
    public Builder mergeColumnizedDataset(
        com.google.cloud.aiplatform.v1beta1.ModelMonitoringInput.ModelMonitoringDataset value) {
      if (columnizedDatasetBuilder_ == null) {
        if (datasetCase_ == 1
            && dataset_
                != com.google.cloud.aiplatform.v1beta1.ModelMonitoringInput.ModelMonitoringDataset
                    .getDefaultInstance()) {
          dataset_ =
              com.google.cloud.aiplatform.v1beta1.ModelMonitoringInput.ModelMonitoringDataset
                  .newBuilder(
                      (com.google.cloud.aiplatform.v1beta1.ModelMonitoringInput
                              .ModelMonitoringDataset)
                          dataset_)
                  .mergeFrom(value)
                  .buildPartial();
        } else {
          dataset_ = value;
        }
        onChanged();
      } else {
        if (datasetCase_ == 1) {
          columnizedDatasetBuilder_.mergeFrom(value);
        } else {
          columnizedDatasetBuilder_.setMessage(value);
        }
      }
      datasetCase_ = 1;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Columnized dataset.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.ModelMonitoringInput.ModelMonitoringDataset columnized_dataset = 1;
     * </code>
     */
    public Builder clearColumnizedDataset() {
      if (columnizedDatasetBuilder_ == null) {
        if (datasetCase_ == 1) {
          datasetCase_ = 0;
          dataset_ = null;
          onChanged();
        }
      } else {
        if (datasetCase_ == 1) {
          datasetCase_ = 0;
          dataset_ = null;
        }
        columnizedDatasetBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Columnized dataset.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.ModelMonitoringInput.ModelMonitoringDataset columnized_dataset = 1;
     * </code>
     */
    public com.google.cloud.aiplatform.v1beta1.ModelMonitoringInput.ModelMonitoringDataset.Builder
        getColumnizedDatasetBuilder() {
      return getColumnizedDatasetFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Columnized dataset.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.ModelMonitoringInput.ModelMonitoringDataset columnized_dataset = 1;
     * </code>
     */
    @java.lang.Override
    public com.google.cloud.aiplatform.v1beta1.ModelMonitoringInput.ModelMonitoringDatasetOrBuilder
        getColumnizedDatasetOrBuilder() {
      if ((datasetCase_ == 1) && (columnizedDatasetBuilder_ != null)) {
        return columnizedDatasetBuilder_.getMessageOrBuilder();
      } else {
        if (datasetCase_ == 1) {
          return (com.google.cloud.aiplatform.v1beta1.ModelMonitoringInput.ModelMonitoringDataset)
              dataset_;
        }
        return com.google.cloud.aiplatform.v1beta1.ModelMonitoringInput.ModelMonitoringDataset
            .getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * Columnized dataset.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.ModelMonitoringInput.ModelMonitoringDataset columnized_dataset = 1;
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.aiplatform.v1beta1.ModelMonitoringInput.ModelMonitoringDataset,
            com.google.cloud.aiplatform.v1beta1.ModelMonitoringInput.ModelMonitoringDataset.Builder,
            com.google.cloud.aiplatform.v1beta1.ModelMonitoringInput
                .ModelMonitoringDatasetOrBuilder>
        getColumnizedDatasetFieldBuilder() {
      if (columnizedDatasetBuilder_ == null) {
        if (!(datasetCase_ == 1)) {
          dataset_ =
              com.google.cloud.aiplatform.v1beta1.ModelMonitoringInput.ModelMonitoringDataset
                  .getDefaultInstance();
        }
        columnizedDatasetBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.aiplatform.v1beta1.ModelMonitoringInput.ModelMonitoringDataset,
                com.google.cloud.aiplatform.v1beta1.ModelMonitoringInput.ModelMonitoringDataset
                    .Builder,
                com.google.cloud.aiplatform.v1beta1.ModelMonitoringInput
                    .ModelMonitoringDatasetOrBuilder>(
                (com.google.cloud.aiplatform.v1beta1.ModelMonitoringInput.ModelMonitoringDataset)
                    dataset_,
                getParentForChildren(),
                isClean());
        dataset_ = null;
      }
      datasetCase_ = 1;
      onChanged();
      return columnizedDatasetBuilder_;
    }

    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.aiplatform.v1beta1.ModelMonitoringInput.BatchPredictionOutput,
            com.google.cloud.aiplatform.v1beta1.ModelMonitoringInput.BatchPredictionOutput.Builder,
            com.google.cloud.aiplatform.v1beta1.ModelMonitoringInput.BatchPredictionOutputOrBuilder>
        batchPredictionOutputBuilder_;
    /**
     *
     *
     * <pre>
     * Vertex AI Batch prediction Job.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.ModelMonitoringInput.BatchPredictionOutput batch_prediction_output = 2;
     * </code>
     *
     * @return Whether the batchPredictionOutput field is set.
     */
    @java.lang.Override
    public boolean hasBatchPredictionOutput() {
      return datasetCase_ == 2;
    }
    /**
     *
     *
     * <pre>
     * Vertex AI Batch prediction Job.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.ModelMonitoringInput.BatchPredictionOutput batch_prediction_output = 2;
     * </code>
     *
     * @return The batchPredictionOutput.
     */
    @java.lang.Override
    public com.google.cloud.aiplatform.v1beta1.ModelMonitoringInput.BatchPredictionOutput
        getBatchPredictionOutput() {
      if (batchPredictionOutputBuilder_ == null) {
        if (datasetCase_ == 2) {
          return (com.google.cloud.aiplatform.v1beta1.ModelMonitoringInput.BatchPredictionOutput)
              dataset_;
        }
        return com.google.cloud.aiplatform.v1beta1.ModelMonitoringInput.BatchPredictionOutput
            .getDefaultInstance();
      } else {
        if (datasetCase_ == 2) {
          return batchPredictionOutputBuilder_.getMessage();
        }
        return com.google.cloud.aiplatform.v1beta1.ModelMonitoringInput.BatchPredictionOutput
            .getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * Vertex AI Batch prediction Job.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.ModelMonitoringInput.BatchPredictionOutput batch_prediction_output = 2;
     * </code>
     */
    public Builder setBatchPredictionOutput(
        com.google.cloud.aiplatform.v1beta1.ModelMonitoringInput.BatchPredictionOutput value) {
      if (batchPredictionOutputBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        dataset_ = value;
        onChanged();
      } else {
        batchPredictionOutputBuilder_.setMessage(value);
      }
      datasetCase_ = 2;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Vertex AI Batch prediction Job.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.ModelMonitoringInput.BatchPredictionOutput batch_prediction_output = 2;
     * </code>
     */
    public Builder setBatchPredictionOutput(
        com.google.cloud.aiplatform.v1beta1.ModelMonitoringInput.BatchPredictionOutput.Builder
            builderForValue) {
      if (batchPredictionOutputBuilder_ == null) {
        dataset_ = builderForValue.build();
        onChanged();
      } else {
        batchPredictionOutputBuilder_.setMessage(builderForValue.build());
      }
      datasetCase_ = 2;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Vertex AI Batch prediction Job.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.ModelMonitoringInput.BatchPredictionOutput batch_prediction_output = 2;
     * </code>
     */
    public Builder mergeBatchPredictionOutput(
        com.google.cloud.aiplatform.v1beta1.ModelMonitoringInput.BatchPredictionOutput value) {
      if (batchPredictionOutputBuilder_ == null) {
        if (datasetCase_ == 2
            && dataset_
                != com.google.cloud.aiplatform.v1beta1.ModelMonitoringInput.BatchPredictionOutput
                    .getDefaultInstance()) {
          dataset_ =
              com.google.cloud.aiplatform.v1beta1.ModelMonitoringInput.BatchPredictionOutput
                  .newBuilder(
                      (com.google.cloud.aiplatform.v1beta1.ModelMonitoringInput
                              .BatchPredictionOutput)
                          dataset_)
                  .mergeFrom(value)
                  .buildPartial();
        } else {
          dataset_ = value;
        }
        onChanged();
      } else {
        if (datasetCase_ == 2) {
          batchPredictionOutputBuilder_.mergeFrom(value);
        } else {
          batchPredictionOutputBuilder_.setMessage(value);
        }
      }
      datasetCase_ = 2;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Vertex AI Batch prediction Job.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.ModelMonitoringInput.BatchPredictionOutput batch_prediction_output = 2;
     * </code>
     */
    public Builder clearBatchPredictionOutput() {
      if (batchPredictionOutputBuilder_ == null) {
        if (datasetCase_ == 2) {
          datasetCase_ = 0;
          dataset_ = null;
          onChanged();
        }
      } else {
        if (datasetCase_ == 2) {
          datasetCase_ = 0;
          dataset_ = null;
        }
        batchPredictionOutputBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Vertex AI Batch prediction Job.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.ModelMonitoringInput.BatchPredictionOutput batch_prediction_output = 2;
     * </code>
     */
    public com.google.cloud.aiplatform.v1beta1.ModelMonitoringInput.BatchPredictionOutput.Builder
        getBatchPredictionOutputBuilder() {
      return getBatchPredictionOutputFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Vertex AI Batch prediction Job.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.ModelMonitoringInput.BatchPredictionOutput batch_prediction_output = 2;
     * </code>
     */
    @java.lang.Override
    public com.google.cloud.aiplatform.v1beta1.ModelMonitoringInput.BatchPredictionOutputOrBuilder
        getBatchPredictionOutputOrBuilder() {
      if ((datasetCase_ == 2) && (batchPredictionOutputBuilder_ != null)) {
        return batchPredictionOutputBuilder_.getMessageOrBuilder();
      } else {
        if (datasetCase_ == 2) {
          return (com.google.cloud.aiplatform.v1beta1.ModelMonitoringInput.BatchPredictionOutput)
              dataset_;
        }
        return com.google.cloud.aiplatform.v1beta1.ModelMonitoringInput.BatchPredictionOutput
            .getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * Vertex AI Batch prediction Job.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.ModelMonitoringInput.BatchPredictionOutput batch_prediction_output = 2;
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.aiplatform.v1beta1.ModelMonitoringInput.BatchPredictionOutput,
            com.google.cloud.aiplatform.v1beta1.ModelMonitoringInput.BatchPredictionOutput.Builder,
            com.google.cloud.aiplatform.v1beta1.ModelMonitoringInput.BatchPredictionOutputOrBuilder>
        getBatchPredictionOutputFieldBuilder() {
      if (batchPredictionOutputBuilder_ == null) {
        if (!(datasetCase_ == 2)) {
          dataset_ =
              com.google.cloud.aiplatform.v1beta1.ModelMonitoringInput.BatchPredictionOutput
                  .getDefaultInstance();
        }
        batchPredictionOutputBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.aiplatform.v1beta1.ModelMonitoringInput.BatchPredictionOutput,
                com.google.cloud.aiplatform.v1beta1.ModelMonitoringInput.BatchPredictionOutput
                    .Builder,
                com.google.cloud.aiplatform.v1beta1.ModelMonitoringInput
                    .BatchPredictionOutputOrBuilder>(
                (com.google.cloud.aiplatform.v1beta1.ModelMonitoringInput.BatchPredictionOutput)
                    dataset_,
                getParentForChildren(),
                isClean());
        dataset_ = null;
      }
      datasetCase_ = 2;
      onChanged();
      return batchPredictionOutputBuilder_;
    }

    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.aiplatform.v1beta1.ModelMonitoringInput.VertexEndpointLogs,
            com.google.cloud.aiplatform.v1beta1.ModelMonitoringInput.VertexEndpointLogs.Builder,
            com.google.cloud.aiplatform.v1beta1.ModelMonitoringInput.VertexEndpointLogsOrBuilder>
        vertexEndpointLogsBuilder_;
    /**
     *
     *
     * <pre>
     * Vertex AI Endpoint request &amp; response logging.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.ModelMonitoringInput.VertexEndpointLogs vertex_endpoint_logs = 3;
     * </code>
     *
     * @return Whether the vertexEndpointLogs field is set.
     */
    @java.lang.Override
    public boolean hasVertexEndpointLogs() {
      return datasetCase_ == 3;
    }
    /**
     *
     *
     * <pre>
     * Vertex AI Endpoint request &amp; response logging.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.ModelMonitoringInput.VertexEndpointLogs vertex_endpoint_logs = 3;
     * </code>
     *
     * @return The vertexEndpointLogs.
     */
    @java.lang.Override
    public com.google.cloud.aiplatform.v1beta1.ModelMonitoringInput.VertexEndpointLogs
        getVertexEndpointLogs() {
      if (vertexEndpointLogsBuilder_ == null) {
        if (datasetCase_ == 3) {
          return (com.google.cloud.aiplatform.v1beta1.ModelMonitoringInput.VertexEndpointLogs)
              dataset_;
        }
        return com.google.cloud.aiplatform.v1beta1.ModelMonitoringInput.VertexEndpointLogs
            .getDefaultInstance();
      } else {
        if (datasetCase_ == 3) {
          return vertexEndpointLogsBuilder_.getMessage();
        }
        return com.google.cloud.aiplatform.v1beta1.ModelMonitoringInput.VertexEndpointLogs
            .getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * Vertex AI Endpoint request &amp; response logging.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.ModelMonitoringInput.VertexEndpointLogs vertex_endpoint_logs = 3;
     * </code>
     */
    public Builder setVertexEndpointLogs(
        com.google.cloud.aiplatform.v1beta1.ModelMonitoringInput.VertexEndpointLogs value) {
      if (vertexEndpointLogsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        dataset_ = value;
        onChanged();
      } else {
        vertexEndpointLogsBuilder_.setMessage(value);
      }
      datasetCase_ = 3;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Vertex AI Endpoint request &amp; response logging.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.ModelMonitoringInput.VertexEndpointLogs vertex_endpoint_logs = 3;
     * </code>
     */
    public Builder setVertexEndpointLogs(
        com.google.cloud.aiplatform.v1beta1.ModelMonitoringInput.VertexEndpointLogs.Builder
            builderForValue) {
      if (vertexEndpointLogsBuilder_ == null) {
        dataset_ = builderForValue.build();
        onChanged();
      } else {
        vertexEndpointLogsBuilder_.setMessage(builderForValue.build());
      }
      datasetCase_ = 3;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Vertex AI Endpoint request &amp; response logging.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.ModelMonitoringInput.VertexEndpointLogs vertex_endpoint_logs = 3;
     * </code>
     */
    public Builder mergeVertexEndpointLogs(
        com.google.cloud.aiplatform.v1beta1.ModelMonitoringInput.VertexEndpointLogs value) {
      if (vertexEndpointLogsBuilder_ == null) {
        if (datasetCase_ == 3
            && dataset_
                != com.google.cloud.aiplatform.v1beta1.ModelMonitoringInput.VertexEndpointLogs
                    .getDefaultInstance()) {
          dataset_ =
              com.google.cloud.aiplatform.v1beta1.ModelMonitoringInput.VertexEndpointLogs
                  .newBuilder(
                      (com.google.cloud.aiplatform.v1beta1.ModelMonitoringInput.VertexEndpointLogs)
                          dataset_)
                  .mergeFrom(value)
                  .buildPartial();
        } else {
          dataset_ = value;
        }
        onChanged();
      } else {
        if (datasetCase_ == 3) {
          vertexEndpointLogsBuilder_.mergeFrom(value);
        } else {
          vertexEndpointLogsBuilder_.setMessage(value);
        }
      }
      datasetCase_ = 3;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Vertex AI Endpoint request &amp; response logging.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.ModelMonitoringInput.VertexEndpointLogs vertex_endpoint_logs = 3;
     * </code>
     */
    public Builder clearVertexEndpointLogs() {
      if (vertexEndpointLogsBuilder_ == null) {
        if (datasetCase_ == 3) {
          datasetCase_ = 0;
          dataset_ = null;
          onChanged();
        }
      } else {
        if (datasetCase_ == 3) {
          datasetCase_ = 0;
          dataset_ = null;
        }
        vertexEndpointLogsBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Vertex AI Endpoint request &amp; response logging.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.ModelMonitoringInput.VertexEndpointLogs vertex_endpoint_logs = 3;
     * </code>
     */
    public com.google.cloud.aiplatform.v1beta1.ModelMonitoringInput.VertexEndpointLogs.Builder
        getVertexEndpointLogsBuilder() {
      return getVertexEndpointLogsFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Vertex AI Endpoint request &amp; response logging.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.ModelMonitoringInput.VertexEndpointLogs vertex_endpoint_logs = 3;
     * </code>
     */
    @java.lang.Override
    public com.google.cloud.aiplatform.v1beta1.ModelMonitoringInput.VertexEndpointLogsOrBuilder
        getVertexEndpointLogsOrBuilder() {
      if ((datasetCase_ == 3) && (vertexEndpointLogsBuilder_ != null)) {
        return vertexEndpointLogsBuilder_.getMessageOrBuilder();
      } else {
        if (datasetCase_ == 3) {
          return (com.google.cloud.aiplatform.v1beta1.ModelMonitoringInput.VertexEndpointLogs)
              dataset_;
        }
        return com.google.cloud.aiplatform.v1beta1.ModelMonitoringInput.VertexEndpointLogs
            .getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * Vertex AI Endpoint request &amp; response logging.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.ModelMonitoringInput.VertexEndpointLogs vertex_endpoint_logs = 3;
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.aiplatform.v1beta1.ModelMonitoringInput.VertexEndpointLogs,
            com.google.cloud.aiplatform.v1beta1.ModelMonitoringInput.VertexEndpointLogs.Builder,
            com.google.cloud.aiplatform.v1beta1.ModelMonitoringInput.VertexEndpointLogsOrBuilder>
        getVertexEndpointLogsFieldBuilder() {
      if (vertexEndpointLogsBuilder_ == null) {
        if (!(datasetCase_ == 3)) {
          dataset_ =
              com.google.cloud.aiplatform.v1beta1.ModelMonitoringInput.VertexEndpointLogs
                  .getDefaultInstance();
        }
        vertexEndpointLogsBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.aiplatform.v1beta1.ModelMonitoringInput.VertexEndpointLogs,
                com.google.cloud.aiplatform.v1beta1.ModelMonitoringInput.VertexEndpointLogs.Builder,
                com.google.cloud.aiplatform.v1beta1.ModelMonitoringInput
                    .VertexEndpointLogsOrBuilder>(
                (com.google.cloud.aiplatform.v1beta1.ModelMonitoringInput.VertexEndpointLogs)
                    dataset_,
                getParentForChildren(),
                isClean());
        dataset_ = null;
      }
      datasetCase_ = 3;
      onChanged();
      return vertexEndpointLogsBuilder_;
    }

    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.type.Interval,
            com.google.type.Interval.Builder,
            com.google.type.IntervalOrBuilder>
        timeIntervalBuilder_;
    /**
     *
     *
     * <pre>
     * The time interval (pair of start_time and end_time) for which results
     * should be returned.
     * </pre>
     *
     * <code>.google.type.Interval time_interval = 6;</code>
     *
     * @return Whether the timeInterval field is set.
     */
    @java.lang.Override
    public boolean hasTimeInterval() {
      return timeSpecCase_ == 6;
    }
    /**
     *
     *
     * <pre>
     * The time interval (pair of start_time and end_time) for which results
     * should be returned.
     * </pre>
     *
     * <code>.google.type.Interval time_interval = 6;</code>
     *
     * @return The timeInterval.
     */
    @java.lang.Override
    public com.google.type.Interval getTimeInterval() {
      if (timeIntervalBuilder_ == null) {
        if (timeSpecCase_ == 6) {
          return (com.google.type.Interval) timeSpec_;
        }
        return com.google.type.Interval.getDefaultInstance();
      } else {
        if (timeSpecCase_ == 6) {
          return timeIntervalBuilder_.getMessage();
        }
        return com.google.type.Interval.getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * The time interval (pair of start_time and end_time) for which results
     * should be returned.
     * </pre>
     *
     * <code>.google.type.Interval time_interval = 6;</code>
     */
    public Builder setTimeInterval(com.google.type.Interval value) {
      if (timeIntervalBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        timeSpec_ = value;
        onChanged();
      } else {
        timeIntervalBuilder_.setMessage(value);
      }
      timeSpecCase_ = 6;
      return this;
    }
    /**
     *
     *
     * <pre>
     * The time interval (pair of start_time and end_time) for which results
     * should be returned.
     * </pre>
     *
     * <code>.google.type.Interval time_interval = 6;</code>
     */
    public Builder setTimeInterval(com.google.type.Interval.Builder builderForValue) {
      if (timeIntervalBuilder_ == null) {
        timeSpec_ = builderForValue.build();
        onChanged();
      } else {
        timeIntervalBuilder_.setMessage(builderForValue.build());
      }
      timeSpecCase_ = 6;
      return this;
    }
    /**
     *
     *
     * <pre>
     * The time interval (pair of start_time and end_time) for which results
     * should be returned.
     * </pre>
     *
     * <code>.google.type.Interval time_interval = 6;</code>
     */
    public Builder mergeTimeInterval(com.google.type.Interval value) {
      if (timeIntervalBuilder_ == null) {
        if (timeSpecCase_ == 6 && timeSpec_ != com.google.type.Interval.getDefaultInstance()) {
          timeSpec_ =
              com.google.type.Interval.newBuilder((com.google.type.Interval) timeSpec_)
                  .mergeFrom(value)
                  .buildPartial();
        } else {
          timeSpec_ = value;
        }
        onChanged();
      } else {
        if (timeSpecCase_ == 6) {
          timeIntervalBuilder_.mergeFrom(value);
        } else {
          timeIntervalBuilder_.setMessage(value);
        }
      }
      timeSpecCase_ = 6;
      return this;
    }
    /**
     *
     *
     * <pre>
     * The time interval (pair of start_time and end_time) for which results
     * should be returned.
     * </pre>
     *
     * <code>.google.type.Interval time_interval = 6;</code>
     */
    public Builder clearTimeInterval() {
      if (timeIntervalBuilder_ == null) {
        if (timeSpecCase_ == 6) {
          timeSpecCase_ = 0;
          timeSpec_ = null;
          onChanged();
        }
      } else {
        if (timeSpecCase_ == 6) {
          timeSpecCase_ = 0;
          timeSpec_ = null;
        }
        timeIntervalBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * The time interval (pair of start_time and end_time) for which results
     * should be returned.
     * </pre>
     *
     * <code>.google.type.Interval time_interval = 6;</code>
     */
    public com.google.type.Interval.Builder getTimeIntervalBuilder() {
      return getTimeIntervalFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * The time interval (pair of start_time and end_time) for which results
     * should be returned.
     * </pre>
     *
     * <code>.google.type.Interval time_interval = 6;</code>
     */
    @java.lang.Override
    public com.google.type.IntervalOrBuilder getTimeIntervalOrBuilder() {
      if ((timeSpecCase_ == 6) && (timeIntervalBuilder_ != null)) {
        return timeIntervalBuilder_.getMessageOrBuilder();
      } else {
        if (timeSpecCase_ == 6) {
          return (com.google.type.Interval) timeSpec_;
        }
        return com.google.type.Interval.getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * The time interval (pair of start_time and end_time) for which results
     * should be returned.
     * </pre>
     *
     * <code>.google.type.Interval time_interval = 6;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.type.Interval,
            com.google.type.Interval.Builder,
            com.google.type.IntervalOrBuilder>
        getTimeIntervalFieldBuilder() {
      if (timeIntervalBuilder_ == null) {
        if (!(timeSpecCase_ == 6)) {
          timeSpec_ = com.google.type.Interval.getDefaultInstance();
        }
        timeIntervalBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.type.Interval,
                com.google.type.Interval.Builder,
                com.google.type.IntervalOrBuilder>(
                (com.google.type.Interval) timeSpec_, getParentForChildren(), isClean());
        timeSpec_ = null;
      }
      timeSpecCase_ = 6;
      onChanged();
      return timeIntervalBuilder_;
    }

    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.aiplatform.v1beta1.ModelMonitoringInput.TimeOffset,
            com.google.cloud.aiplatform.v1beta1.ModelMonitoringInput.TimeOffset.Builder,
            com.google.cloud.aiplatform.v1beta1.ModelMonitoringInput.TimeOffsetOrBuilder>
        timeOffsetBuilder_;
    /**
     *
     *
     * <pre>
     * The time offset setting for which results should be returned.
     * </pre>
     *
     * <code>.google.cloud.aiplatform.v1beta1.ModelMonitoringInput.TimeOffset time_offset = 7;
     * </code>
     *
     * @return Whether the timeOffset field is set.
     */
    @java.lang.Override
    public boolean hasTimeOffset() {
      return timeSpecCase_ == 7;
    }
    /**
     *
     *
     * <pre>
     * The time offset setting for which results should be returned.
     * </pre>
     *
     * <code>.google.cloud.aiplatform.v1beta1.ModelMonitoringInput.TimeOffset time_offset = 7;
     * </code>
     *
     * @return The timeOffset.
     */
    @java.lang.Override
    public com.google.cloud.aiplatform.v1beta1.ModelMonitoringInput.TimeOffset getTimeOffset() {
      if (timeOffsetBuilder_ == null) {
        if (timeSpecCase_ == 7) {
          return (com.google.cloud.aiplatform.v1beta1.ModelMonitoringInput.TimeOffset) timeSpec_;
        }
        return com.google.cloud.aiplatform.v1beta1.ModelMonitoringInput.TimeOffset
            .getDefaultInstance();
      } else {
        if (timeSpecCase_ == 7) {
          return timeOffsetBuilder_.getMessage();
        }
        return com.google.cloud.aiplatform.v1beta1.ModelMonitoringInput.TimeOffset
            .getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * The time offset setting for which results should be returned.
     * </pre>
     *
     * <code>.google.cloud.aiplatform.v1beta1.ModelMonitoringInput.TimeOffset time_offset = 7;
     * </code>
     */
    public Builder setTimeOffset(
        com.google.cloud.aiplatform.v1beta1.ModelMonitoringInput.TimeOffset value) {
      if (timeOffsetBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        timeSpec_ = value;
        onChanged();
      } else {
        timeOffsetBuilder_.setMessage(value);
      }
      timeSpecCase_ = 7;
      return this;
    }
    /**
     *
     *
     * <pre>
     * The time offset setting for which results should be returned.
     * </pre>
     *
     * <code>.google.cloud.aiplatform.v1beta1.ModelMonitoringInput.TimeOffset time_offset = 7;
     * </code>
     */
    public Builder setTimeOffset(
        com.google.cloud.aiplatform.v1beta1.ModelMonitoringInput.TimeOffset.Builder
            builderForValue) {
      if (timeOffsetBuilder_ == null) {
        timeSpec_ = builderForValue.build();
        onChanged();
      } else {
        timeOffsetBuilder_.setMessage(builderForValue.build());
      }
      timeSpecCase_ = 7;
      return this;
    }
    /**
     *
     *
     * <pre>
     * The time offset setting for which results should be returned.
     * </pre>
     *
     * <code>.google.cloud.aiplatform.v1beta1.ModelMonitoringInput.TimeOffset time_offset = 7;
     * </code>
     */
    public Builder mergeTimeOffset(
        com.google.cloud.aiplatform.v1beta1.ModelMonitoringInput.TimeOffset value) {
      if (timeOffsetBuilder_ == null) {
        if (timeSpecCase_ == 7
            && timeSpec_
                != com.google.cloud.aiplatform.v1beta1.ModelMonitoringInput.TimeOffset
                    .getDefaultInstance()) {
          timeSpec_ =
              com.google.cloud.aiplatform.v1beta1.ModelMonitoringInput.TimeOffset.newBuilder(
                      (com.google.cloud.aiplatform.v1beta1.ModelMonitoringInput.TimeOffset)
                          timeSpec_)
                  .mergeFrom(value)
                  .buildPartial();
        } else {
          timeSpec_ = value;
        }
        onChanged();
      } else {
        if (timeSpecCase_ == 7) {
          timeOffsetBuilder_.mergeFrom(value);
        } else {
          timeOffsetBuilder_.setMessage(value);
        }
      }
      timeSpecCase_ = 7;
      return this;
    }
    /**
     *
     *
     * <pre>
     * The time offset setting for which results should be returned.
     * </pre>
     *
     * <code>.google.cloud.aiplatform.v1beta1.ModelMonitoringInput.TimeOffset time_offset = 7;
     * </code>
     */
    public Builder clearTimeOffset() {
      if (timeOffsetBuilder_ == null) {
        if (timeSpecCase_ == 7) {
          timeSpecCase_ = 0;
          timeSpec_ = null;
          onChanged();
        }
      } else {
        if (timeSpecCase_ == 7) {
          timeSpecCase_ = 0;
          timeSpec_ = null;
        }
        timeOffsetBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * The time offset setting for which results should be returned.
     * </pre>
     *
     * <code>.google.cloud.aiplatform.v1beta1.ModelMonitoringInput.TimeOffset time_offset = 7;
     * </code>
     */
    public com.google.cloud.aiplatform.v1beta1.ModelMonitoringInput.TimeOffset.Builder
        getTimeOffsetBuilder() {
      return getTimeOffsetFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * The time offset setting for which results should be returned.
     * </pre>
     *
     * <code>.google.cloud.aiplatform.v1beta1.ModelMonitoringInput.TimeOffset time_offset = 7;
     * </code>
     */
    @java.lang.Override
    public com.google.cloud.aiplatform.v1beta1.ModelMonitoringInput.TimeOffsetOrBuilder
        getTimeOffsetOrBuilder() {
      if ((timeSpecCase_ == 7) && (timeOffsetBuilder_ != null)) {
        return timeOffsetBuilder_.getMessageOrBuilder();
      } else {
        if (timeSpecCase_ == 7) {
          return (com.google.cloud.aiplatform.v1beta1.ModelMonitoringInput.TimeOffset) timeSpec_;
        }
        return com.google.cloud.aiplatform.v1beta1.ModelMonitoringInput.TimeOffset
            .getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * The time offset setting for which results should be returned.
     * </pre>
     *
     * <code>.google.cloud.aiplatform.v1beta1.ModelMonitoringInput.TimeOffset time_offset = 7;
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.aiplatform.v1beta1.ModelMonitoringInput.TimeOffset,
            com.google.cloud.aiplatform.v1beta1.ModelMonitoringInput.TimeOffset.Builder,
            com.google.cloud.aiplatform.v1beta1.ModelMonitoringInput.TimeOffsetOrBuilder>
        getTimeOffsetFieldBuilder() {
      if (timeOffsetBuilder_ == null) {
        if (!(timeSpecCase_ == 7)) {
          timeSpec_ =
              com.google.cloud.aiplatform.v1beta1.ModelMonitoringInput.TimeOffset
                  .getDefaultInstance();
        }
        timeOffsetBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.aiplatform.v1beta1.ModelMonitoringInput.TimeOffset,
                com.google.cloud.aiplatform.v1beta1.ModelMonitoringInput.TimeOffset.Builder,
                com.google.cloud.aiplatform.v1beta1.ModelMonitoringInput.TimeOffsetOrBuilder>(
                (com.google.cloud.aiplatform.v1beta1.ModelMonitoringInput.TimeOffset) timeSpec_,
                getParentForChildren(),
                isClean());
        timeSpec_ = null;
      }
      timeSpecCase_ = 7;
      onChanged();
      return timeOffsetBuilder_;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.cloud.aiplatform.v1beta1.ModelMonitoringInput)
  }

  // @@protoc_insertion_point(class_scope:google.cloud.aiplatform.v1beta1.ModelMonitoringInput)
  private static final com.google.cloud.aiplatform.v1beta1.ModelMonitoringInput DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.cloud.aiplatform.v1beta1.ModelMonitoringInput();
  }

  public static com.google.cloud.aiplatform.v1beta1.ModelMonitoringInput getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<ModelMonitoringInput> PARSER =
      new com.google.protobuf.AbstractParser<ModelMonitoringInput>() {
        @java.lang.Override
        public ModelMonitoringInput parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          Builder builder = newBuilder();
          try {
            builder.mergeFrom(input, extensionRegistry);
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.setUnfinishedMessage(builder.buildPartial());
          } catch (com.google.protobuf.UninitializedMessageException e) {
            throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
          } catch (java.io.IOException e) {
            throw new com.google.protobuf.InvalidProtocolBufferException(e)
                .setUnfinishedMessage(builder.buildPartial());
          }
          return builder.buildPartial();
        }
      };

  public static com.google.protobuf.Parser<ModelMonitoringInput> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<ModelMonitoringInput> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.cloud.aiplatform.v1beta1.ModelMonitoringInput getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
