/*
 * Copyright 2024 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/cloud/aiplatform/v1beta1/feature_online_store_service.proto

// Protobuf Java Version: 3.25.5
package com.google.cloud.aiplatform.v1beta1;

/**
 *
 *
 * <pre>
 * Nearest neighbors for one query.
 * </pre>
 *
 * Protobuf type {@code google.cloud.aiplatform.v1beta1.NearestNeighbors}
 */
public final class NearestNeighbors extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.cloud.aiplatform.v1beta1.NearestNeighbors)
    NearestNeighborsOrBuilder {
  private static final long serialVersionUID = 0L;
  // Use NearestNeighbors.newBuilder() to construct.
  private NearestNeighbors(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private NearestNeighbors() {
    neighbors_ = java.util.Collections.emptyList();
  }

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new NearestNeighbors();
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.cloud.aiplatform.v1beta1.FeatureOnlineStoreServiceProto
        .internal_static_google_cloud_aiplatform_v1beta1_NearestNeighbors_descriptor;
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.cloud.aiplatform.v1beta1.FeatureOnlineStoreServiceProto
        .internal_static_google_cloud_aiplatform_v1beta1_NearestNeighbors_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.cloud.aiplatform.v1beta1.NearestNeighbors.class,
            com.google.cloud.aiplatform.v1beta1.NearestNeighbors.Builder.class);
  }

  public interface NeighborOrBuilder
      extends
      // @@protoc_insertion_point(interface_extends:google.cloud.aiplatform.v1beta1.NearestNeighbors.Neighbor)
      com.google.protobuf.MessageOrBuilder {

    /**
     *
     *
     * <pre>
     * The id of the similar entity.
     * </pre>
     *
     * <code>string entity_id = 1;</code>
     *
     * @return The entityId.
     */
    java.lang.String getEntityId();
    /**
     *
     *
     * <pre>
     * The id of the similar entity.
     * </pre>
     *
     * <code>string entity_id = 1;</code>
     *
     * @return The bytes for entityId.
     */
    com.google.protobuf.ByteString getEntityIdBytes();

    /**
     *
     *
     * <pre>
     * The distance between the neighbor and the query vector.
     * </pre>
     *
     * <code>double distance = 2;</code>
     *
     * @return The distance.
     */
    double getDistance();

    /**
     *
     *
     * <pre>
     * The attributes of the neighbor, e.g. filters, crowding and metadata
     * Note that full entities are returned only when "return_full_entity"
     * is set to true. Otherwise, only the "entity_id" and "distance" fields
     * are populated.
     * </pre>
     *
     * <code>.google.cloud.aiplatform.v1beta1.FetchFeatureValuesResponse entity_key_values = 3;
     * </code>
     *
     * @return Whether the entityKeyValues field is set.
     */
    boolean hasEntityKeyValues();
    /**
     *
     *
     * <pre>
     * The attributes of the neighbor, e.g. filters, crowding and metadata
     * Note that full entities are returned only when "return_full_entity"
     * is set to true. Otherwise, only the "entity_id" and "distance" fields
     * are populated.
     * </pre>
     *
     * <code>.google.cloud.aiplatform.v1beta1.FetchFeatureValuesResponse entity_key_values = 3;
     * </code>
     *
     * @return The entityKeyValues.
     */
    com.google.cloud.aiplatform.v1beta1.FetchFeatureValuesResponse getEntityKeyValues();
    /**
     *
     *
     * <pre>
     * The attributes of the neighbor, e.g. filters, crowding and metadata
     * Note that full entities are returned only when "return_full_entity"
     * is set to true. Otherwise, only the "entity_id" and "distance" fields
     * are populated.
     * </pre>
     *
     * <code>.google.cloud.aiplatform.v1beta1.FetchFeatureValuesResponse entity_key_values = 3;
     * </code>
     */
    com.google.cloud.aiplatform.v1beta1.FetchFeatureValuesResponseOrBuilder
        getEntityKeyValuesOrBuilder();
  }
  /**
   *
   *
   * <pre>
   * A neighbor of the query vector.
   * </pre>
   *
   * Protobuf type {@code google.cloud.aiplatform.v1beta1.NearestNeighbors.Neighbor}
   */
  public static final class Neighbor extends com.google.protobuf.GeneratedMessageV3
      implements
      // @@protoc_insertion_point(message_implements:google.cloud.aiplatform.v1beta1.NearestNeighbors.Neighbor)
      NeighborOrBuilder {
    private static final long serialVersionUID = 0L;
    // Use Neighbor.newBuilder() to construct.
    private Neighbor(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
      super(builder);
    }

    private Neighbor() {
      entityId_ = "";
    }

    @java.lang.Override
    @SuppressWarnings({"unused"})
    protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
      return new Neighbor();
    }

    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.aiplatform.v1beta1.FeatureOnlineStoreServiceProto
          .internal_static_google_cloud_aiplatform_v1beta1_NearestNeighbors_Neighbor_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.aiplatform.v1beta1.FeatureOnlineStoreServiceProto
          .internal_static_google_cloud_aiplatform_v1beta1_NearestNeighbors_Neighbor_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.aiplatform.v1beta1.NearestNeighbors.Neighbor.class,
              com.google.cloud.aiplatform.v1beta1.NearestNeighbors.Neighbor.Builder.class);
    }

    private int bitField0_;
    public static final int ENTITY_ID_FIELD_NUMBER = 1;

    @SuppressWarnings("serial")
    private volatile java.lang.Object entityId_ = "";
    /**
     *
     *
     * <pre>
     * The id of the similar entity.
     * </pre>
     *
     * <code>string entity_id = 1;</code>
     *
     * @return The entityId.
     */
    @java.lang.Override
    public java.lang.String getEntityId() {
      java.lang.Object ref = entityId_;
      if (ref instanceof java.lang.String) {
        return (java.lang.String) ref;
      } else {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        entityId_ = s;
        return s;
      }
    }
    /**
     *
     *
     * <pre>
     * The id of the similar entity.
     * </pre>
     *
     * <code>string entity_id = 1;</code>
     *
     * @return The bytes for entityId.
     */
    @java.lang.Override
    public com.google.protobuf.ByteString getEntityIdBytes() {
      java.lang.Object ref = entityId_;
      if (ref instanceof java.lang.String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        entityId_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    public static final int DISTANCE_FIELD_NUMBER = 2;
    private double distance_ = 0D;
    /**
     *
     *
     * <pre>
     * The distance between the neighbor and the query vector.
     * </pre>
     *
     * <code>double distance = 2;</code>
     *
     * @return The distance.
     */
    @java.lang.Override
    public double getDistance() {
      return distance_;
    }

    public static final int ENTITY_KEY_VALUES_FIELD_NUMBER = 3;
    private com.google.cloud.aiplatform.v1beta1.FetchFeatureValuesResponse entityKeyValues_;
    /**
     *
     *
     * <pre>
     * The attributes of the neighbor, e.g. filters, crowding and metadata
     * Note that full entities are returned only when "return_full_entity"
     * is set to true. Otherwise, only the "entity_id" and "distance" fields
     * are populated.
     * </pre>
     *
     * <code>.google.cloud.aiplatform.v1beta1.FetchFeatureValuesResponse entity_key_values = 3;
     * </code>
     *
     * @return Whether the entityKeyValues field is set.
     */
    @java.lang.Override
    public boolean hasEntityKeyValues() {
      return ((bitField0_ & 0x00000001) != 0);
    }
    /**
     *
     *
     * <pre>
     * The attributes of the neighbor, e.g. filters, crowding and metadata
     * Note that full entities are returned only when "return_full_entity"
     * is set to true. Otherwise, only the "entity_id" and "distance" fields
     * are populated.
     * </pre>
     *
     * <code>.google.cloud.aiplatform.v1beta1.FetchFeatureValuesResponse entity_key_values = 3;
     * </code>
     *
     * @return The entityKeyValues.
     */
    @java.lang.Override
    public com.google.cloud.aiplatform.v1beta1.FetchFeatureValuesResponse getEntityKeyValues() {
      return entityKeyValues_ == null
          ? com.google.cloud.aiplatform.v1beta1.FetchFeatureValuesResponse.getDefaultInstance()
          : entityKeyValues_;
    }
    /**
     *
     *
     * <pre>
     * The attributes of the neighbor, e.g. filters, crowding and metadata
     * Note that full entities are returned only when "return_full_entity"
     * is set to true. Otherwise, only the "entity_id" and "distance" fields
     * are populated.
     * </pre>
     *
     * <code>.google.cloud.aiplatform.v1beta1.FetchFeatureValuesResponse entity_key_values = 3;
     * </code>
     */
    @java.lang.Override
    public com.google.cloud.aiplatform.v1beta1.FetchFeatureValuesResponseOrBuilder
        getEntityKeyValuesOrBuilder() {
      return entityKeyValues_ == null
          ? com.google.cloud.aiplatform.v1beta1.FetchFeatureValuesResponse.getDefaultInstance()
          : entityKeyValues_;
    }

    private byte memoizedIsInitialized = -1;

    @java.lang.Override
    public final boolean isInitialized() {
      byte isInitialized = memoizedIsInitialized;
      if (isInitialized == 1) return true;
      if (isInitialized == 0) return false;

      memoizedIsInitialized = 1;
      return true;
    }

    @java.lang.Override
    public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(entityId_)) {
        com.google.protobuf.GeneratedMessageV3.writeString(output, 1, entityId_);
      }
      if (java.lang.Double.doubleToRawLongBits(distance_) != 0) {
        output.writeDouble(2, distance_);
      }
      if (((bitField0_ & 0x00000001) != 0)) {
        output.writeMessage(3, getEntityKeyValues());
      }
      getUnknownFields().writeTo(output);
    }

    @java.lang.Override
    public int getSerializedSize() {
      int size = memoizedSize;
      if (size != -1) return size;

      size = 0;
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(entityId_)) {
        size += com.google.protobuf.GeneratedMessageV3.computeStringSize(1, entityId_);
      }
      if (java.lang.Double.doubleToRawLongBits(distance_) != 0) {
        size += com.google.protobuf.CodedOutputStream.computeDoubleSize(2, distance_);
      }
      if (((bitField0_ & 0x00000001) != 0)) {
        size += com.google.protobuf.CodedOutputStream.computeMessageSize(3, getEntityKeyValues());
      }
      size += getUnknownFields().getSerializedSize();
      memoizedSize = size;
      return size;
    }

    @java.lang.Override
    public boolean equals(final java.lang.Object obj) {
      if (obj == this) {
        return true;
      }
      if (!(obj instanceof com.google.cloud.aiplatform.v1beta1.NearestNeighbors.Neighbor)) {
        return super.equals(obj);
      }
      com.google.cloud.aiplatform.v1beta1.NearestNeighbors.Neighbor other =
          (com.google.cloud.aiplatform.v1beta1.NearestNeighbors.Neighbor) obj;

      if (!getEntityId().equals(other.getEntityId())) return false;
      if (java.lang.Double.doubleToLongBits(getDistance())
          != java.lang.Double.doubleToLongBits(other.getDistance())) return false;
      if (hasEntityKeyValues() != other.hasEntityKeyValues()) return false;
      if (hasEntityKeyValues()) {
        if (!getEntityKeyValues().equals(other.getEntityKeyValues())) return false;
      }
      if (!getUnknownFields().equals(other.getUnknownFields())) return false;
      return true;
    }

    @java.lang.Override
    public int hashCode() {
      if (memoizedHashCode != 0) {
        return memoizedHashCode;
      }
      int hash = 41;
      hash = (19 * hash) + getDescriptor().hashCode();
      hash = (37 * hash) + ENTITY_ID_FIELD_NUMBER;
      hash = (53 * hash) + getEntityId().hashCode();
      hash = (37 * hash) + DISTANCE_FIELD_NUMBER;
      hash =
          (53 * hash)
              + com.google.protobuf.Internal.hashLong(
                  java.lang.Double.doubleToLongBits(getDistance()));
      if (hasEntityKeyValues()) {
        hash = (37 * hash) + ENTITY_KEY_VALUES_FIELD_NUMBER;
        hash = (53 * hash) + getEntityKeyValues().hashCode();
      }
      hash = (29 * hash) + getUnknownFields().hashCode();
      memoizedHashCode = hash;
      return hash;
    }

    public static com.google.cloud.aiplatform.v1beta1.NearestNeighbors.Neighbor parseFrom(
        java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.aiplatform.v1beta1.NearestNeighbors.Neighbor parseFrom(
        java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.aiplatform.v1beta1.NearestNeighbors.Neighbor parseFrom(
        com.google.protobuf.ByteString data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.aiplatform.v1beta1.NearestNeighbors.Neighbor parseFrom(
        com.google.protobuf.ByteString data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.aiplatform.v1beta1.NearestNeighbors.Neighbor parseFrom(
        byte[] data) throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.aiplatform.v1beta1.NearestNeighbors.Neighbor parseFrom(
        byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.aiplatform.v1beta1.NearestNeighbors.Neighbor parseFrom(
        java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.cloud.aiplatform.v1beta1.NearestNeighbors.Neighbor parseFrom(
        java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.cloud.aiplatform.v1beta1.NearestNeighbors.Neighbor parseDelimitedFrom(
        java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
    }

    public static com.google.cloud.aiplatform.v1beta1.NearestNeighbors.Neighbor parseDelimitedFrom(
        java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.cloud.aiplatform.v1beta1.NearestNeighbors.Neighbor parseFrom(
        com.google.protobuf.CodedInputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.cloud.aiplatform.v1beta1.NearestNeighbors.Neighbor parseFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    @java.lang.Override
    public Builder newBuilderForType() {
      return newBuilder();
    }

    public static Builder newBuilder() {
      return DEFAULT_INSTANCE.toBuilder();
    }

    public static Builder newBuilder(
        com.google.cloud.aiplatform.v1beta1.NearestNeighbors.Neighbor prototype) {
      return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }

    @java.lang.Override
    public Builder toBuilder() {
      return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
    }

    @java.lang.Override
    protected Builder newBuilderForType(
        com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      Builder builder = new Builder(parent);
      return builder;
    }
    /**
     *
     *
     * <pre>
     * A neighbor of the query vector.
     * </pre>
     *
     * Protobuf type {@code google.cloud.aiplatform.v1beta1.NearestNeighbors.Neighbor}
     */
    public static final class Builder
        extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
        implements
        // @@protoc_insertion_point(builder_implements:google.cloud.aiplatform.v1beta1.NearestNeighbors.Neighbor)
        com.google.cloud.aiplatform.v1beta1.NearestNeighbors.NeighborOrBuilder {
      public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
        return com.google.cloud.aiplatform.v1beta1.FeatureOnlineStoreServiceProto
            .internal_static_google_cloud_aiplatform_v1beta1_NearestNeighbors_Neighbor_descriptor;
      }

      @java.lang.Override
      protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return com.google.cloud.aiplatform.v1beta1.FeatureOnlineStoreServiceProto
            .internal_static_google_cloud_aiplatform_v1beta1_NearestNeighbors_Neighbor_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                com.google.cloud.aiplatform.v1beta1.NearestNeighbors.Neighbor.class,
                com.google.cloud.aiplatform.v1beta1.NearestNeighbors.Neighbor.Builder.class);
      }

      // Construct using com.google.cloud.aiplatform.v1beta1.NearestNeighbors.Neighbor.newBuilder()
      private Builder() {
        maybeForceBuilderInitialization();
      }

      private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
        super(parent);
        maybeForceBuilderInitialization();
      }

      private void maybeForceBuilderInitialization() {
        if (com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders) {
          getEntityKeyValuesFieldBuilder();
        }
      }

      @java.lang.Override
      public Builder clear() {
        super.clear();
        bitField0_ = 0;
        entityId_ = "";
        distance_ = 0D;
        entityKeyValues_ = null;
        if (entityKeyValuesBuilder_ != null) {
          entityKeyValuesBuilder_.dispose();
          entityKeyValuesBuilder_ = null;
        }
        return this;
      }

      @java.lang.Override
      public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
        return com.google.cloud.aiplatform.v1beta1.FeatureOnlineStoreServiceProto
            .internal_static_google_cloud_aiplatform_v1beta1_NearestNeighbors_Neighbor_descriptor;
      }

      @java.lang.Override
      public com.google.cloud.aiplatform.v1beta1.NearestNeighbors.Neighbor
          getDefaultInstanceForType() {
        return com.google.cloud.aiplatform.v1beta1.NearestNeighbors.Neighbor.getDefaultInstance();
      }

      @java.lang.Override
      public com.google.cloud.aiplatform.v1beta1.NearestNeighbors.Neighbor build() {
        com.google.cloud.aiplatform.v1beta1.NearestNeighbors.Neighbor result = buildPartial();
        if (!result.isInitialized()) {
          throw newUninitializedMessageException(result);
        }
        return result;
      }

      @java.lang.Override
      public com.google.cloud.aiplatform.v1beta1.NearestNeighbors.Neighbor buildPartial() {
        com.google.cloud.aiplatform.v1beta1.NearestNeighbors.Neighbor result =
            new com.google.cloud.aiplatform.v1beta1.NearestNeighbors.Neighbor(this);
        if (bitField0_ != 0) {
          buildPartial0(result);
        }
        onBuilt();
        return result;
      }

      private void buildPartial0(
          com.google.cloud.aiplatform.v1beta1.NearestNeighbors.Neighbor result) {
        int from_bitField0_ = bitField0_;
        if (((from_bitField0_ & 0x00000001) != 0)) {
          result.entityId_ = entityId_;
        }
        if (((from_bitField0_ & 0x00000002) != 0)) {
          result.distance_ = distance_;
        }
        int to_bitField0_ = 0;
        if (((from_bitField0_ & 0x00000004) != 0)) {
          result.entityKeyValues_ =
              entityKeyValuesBuilder_ == null ? entityKeyValues_ : entityKeyValuesBuilder_.build();
          to_bitField0_ |= 0x00000001;
        }
        result.bitField0_ |= to_bitField0_;
      }

      @java.lang.Override
      public Builder clone() {
        return super.clone();
      }

      @java.lang.Override
      public Builder setField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.setField(field, value);
      }

      @java.lang.Override
      public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
        return super.clearField(field);
      }

      @java.lang.Override
      public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
        return super.clearOneof(oneof);
      }

      @java.lang.Override
      public Builder setRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          int index,
          java.lang.Object value) {
        return super.setRepeatedField(field, index, value);
      }

      @java.lang.Override
      public Builder addRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.addRepeatedField(field, value);
      }

      @java.lang.Override
      public Builder mergeFrom(com.google.protobuf.Message other) {
        if (other instanceof com.google.cloud.aiplatform.v1beta1.NearestNeighbors.Neighbor) {
          return mergeFrom((com.google.cloud.aiplatform.v1beta1.NearestNeighbors.Neighbor) other);
        } else {
          super.mergeFrom(other);
          return this;
        }
      }

      public Builder mergeFrom(
          com.google.cloud.aiplatform.v1beta1.NearestNeighbors.Neighbor other) {
        if (other
            == com.google.cloud.aiplatform.v1beta1.NearestNeighbors.Neighbor.getDefaultInstance())
          return this;
        if (!other.getEntityId().isEmpty()) {
          entityId_ = other.entityId_;
          bitField0_ |= 0x00000001;
          onChanged();
        }
        if (other.getDistance() != 0D) {
          setDistance(other.getDistance());
        }
        if (other.hasEntityKeyValues()) {
          mergeEntityKeyValues(other.getEntityKeyValues());
        }
        this.mergeUnknownFields(other.getUnknownFields());
        onChanged();
        return this;
      }

      @java.lang.Override
      public final boolean isInitialized() {
        return true;
      }

      @java.lang.Override
      public Builder mergeFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        if (extensionRegistry == null) {
          throw new java.lang.NullPointerException();
        }
        try {
          boolean done = false;
          while (!done) {
            int tag = input.readTag();
            switch (tag) {
              case 0:
                done = true;
                break;
              case 10:
                {
                  entityId_ = input.readStringRequireUtf8();
                  bitField0_ |= 0x00000001;
                  break;
                } // case 10
              case 17:
                {
                  distance_ = input.readDouble();
                  bitField0_ |= 0x00000002;
                  break;
                } // case 17
              case 26:
                {
                  input.readMessage(
                      getEntityKeyValuesFieldBuilder().getBuilder(), extensionRegistry);
                  bitField0_ |= 0x00000004;
                  break;
                } // case 26
              default:
                {
                  if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                    done = true; // was an endgroup tag
                  }
                  break;
                } // default:
            } // switch (tag)
          } // while (!done)
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          throw e.unwrapIOException();
        } finally {
          onChanged();
        } // finally
        return this;
      }

      private int bitField0_;

      private java.lang.Object entityId_ = "";
      /**
       *
       *
       * <pre>
       * The id of the similar entity.
       * </pre>
       *
       * <code>string entity_id = 1;</code>
       *
       * @return The entityId.
       */
      public java.lang.String getEntityId() {
        java.lang.Object ref = entityId_;
        if (!(ref instanceof java.lang.String)) {
          com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
          java.lang.String s = bs.toStringUtf8();
          entityId_ = s;
          return s;
        } else {
          return (java.lang.String) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * The id of the similar entity.
       * </pre>
       *
       * <code>string entity_id = 1;</code>
       *
       * @return The bytes for entityId.
       */
      public com.google.protobuf.ByteString getEntityIdBytes() {
        java.lang.Object ref = entityId_;
        if (ref instanceof String) {
          com.google.protobuf.ByteString b =
              com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
          entityId_ = b;
          return b;
        } else {
          return (com.google.protobuf.ByteString) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * The id of the similar entity.
       * </pre>
       *
       * <code>string entity_id = 1;</code>
       *
       * @param value The entityId to set.
       * @return This builder for chaining.
       */
      public Builder setEntityId(java.lang.String value) {
        if (value == null) {
          throw new NullPointerException();
        }
        entityId_ = value;
        bitField0_ |= 0x00000001;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * The id of the similar entity.
       * </pre>
       *
       * <code>string entity_id = 1;</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearEntityId() {
        entityId_ = getDefaultInstance().getEntityId();
        bitField0_ = (bitField0_ & ~0x00000001);
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * The id of the similar entity.
       * </pre>
       *
       * <code>string entity_id = 1;</code>
       *
       * @param value The bytes for entityId to set.
       * @return This builder for chaining.
       */
      public Builder setEntityIdBytes(com.google.protobuf.ByteString value) {
        if (value == null) {
          throw new NullPointerException();
        }
        checkByteStringIsUtf8(value);
        entityId_ = value;
        bitField0_ |= 0x00000001;
        onChanged();
        return this;
      }

      private double distance_;
      /**
       *
       *
       * <pre>
       * The distance between the neighbor and the query vector.
       * </pre>
       *
       * <code>double distance = 2;</code>
       *
       * @return The distance.
       */
      @java.lang.Override
      public double getDistance() {
        return distance_;
      }
      /**
       *
       *
       * <pre>
       * The distance between the neighbor and the query vector.
       * </pre>
       *
       * <code>double distance = 2;</code>
       *
       * @param value The distance to set.
       * @return This builder for chaining.
       */
      public Builder setDistance(double value) {

        distance_ = value;
        bitField0_ |= 0x00000002;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * The distance between the neighbor and the query vector.
       * </pre>
       *
       * <code>double distance = 2;</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearDistance() {
        bitField0_ = (bitField0_ & ~0x00000002);
        distance_ = 0D;
        onChanged();
        return this;
      }

      private com.google.cloud.aiplatform.v1beta1.FetchFeatureValuesResponse entityKeyValues_;
      private com.google.protobuf.SingleFieldBuilderV3<
              com.google.cloud.aiplatform.v1beta1.FetchFeatureValuesResponse,
              com.google.cloud.aiplatform.v1beta1.FetchFeatureValuesResponse.Builder,
              com.google.cloud.aiplatform.v1beta1.FetchFeatureValuesResponseOrBuilder>
          entityKeyValuesBuilder_;
      /**
       *
       *
       * <pre>
       * The attributes of the neighbor, e.g. filters, crowding and metadata
       * Note that full entities are returned only when "return_full_entity"
       * is set to true. Otherwise, only the "entity_id" and "distance" fields
       * are populated.
       * </pre>
       *
       * <code>.google.cloud.aiplatform.v1beta1.FetchFeatureValuesResponse entity_key_values = 3;
       * </code>
       *
       * @return Whether the entityKeyValues field is set.
       */
      public boolean hasEntityKeyValues() {
        return ((bitField0_ & 0x00000004) != 0);
      }
      /**
       *
       *
       * <pre>
       * The attributes of the neighbor, e.g. filters, crowding and metadata
       * Note that full entities are returned only when "return_full_entity"
       * is set to true. Otherwise, only the "entity_id" and "distance" fields
       * are populated.
       * </pre>
       *
       * <code>.google.cloud.aiplatform.v1beta1.FetchFeatureValuesResponse entity_key_values = 3;
       * </code>
       *
       * @return The entityKeyValues.
       */
      public com.google.cloud.aiplatform.v1beta1.FetchFeatureValuesResponse getEntityKeyValues() {
        if (entityKeyValuesBuilder_ == null) {
          return entityKeyValues_ == null
              ? com.google.cloud.aiplatform.v1beta1.FetchFeatureValuesResponse.getDefaultInstance()
              : entityKeyValues_;
        } else {
          return entityKeyValuesBuilder_.getMessage();
        }
      }
      /**
       *
       *
       * <pre>
       * The attributes of the neighbor, e.g. filters, crowding and metadata
       * Note that full entities are returned only when "return_full_entity"
       * is set to true. Otherwise, only the "entity_id" and "distance" fields
       * are populated.
       * </pre>
       *
       * <code>.google.cloud.aiplatform.v1beta1.FetchFeatureValuesResponse entity_key_values = 3;
       * </code>
       */
      public Builder setEntityKeyValues(
          com.google.cloud.aiplatform.v1beta1.FetchFeatureValuesResponse value) {
        if (entityKeyValuesBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          entityKeyValues_ = value;
        } else {
          entityKeyValuesBuilder_.setMessage(value);
        }
        bitField0_ |= 0x00000004;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * The attributes of the neighbor, e.g. filters, crowding and metadata
       * Note that full entities are returned only when "return_full_entity"
       * is set to true. Otherwise, only the "entity_id" and "distance" fields
       * are populated.
       * </pre>
       *
       * <code>.google.cloud.aiplatform.v1beta1.FetchFeatureValuesResponse entity_key_values = 3;
       * </code>
       */
      public Builder setEntityKeyValues(
          com.google.cloud.aiplatform.v1beta1.FetchFeatureValuesResponse.Builder builderForValue) {
        if (entityKeyValuesBuilder_ == null) {
          entityKeyValues_ = builderForValue.build();
        } else {
          entityKeyValuesBuilder_.setMessage(builderForValue.build());
        }
        bitField0_ |= 0x00000004;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * The attributes of the neighbor, e.g. filters, crowding and metadata
       * Note that full entities are returned only when "return_full_entity"
       * is set to true. Otherwise, only the "entity_id" and "distance" fields
       * are populated.
       * </pre>
       *
       * <code>.google.cloud.aiplatform.v1beta1.FetchFeatureValuesResponse entity_key_values = 3;
       * </code>
       */
      public Builder mergeEntityKeyValues(
          com.google.cloud.aiplatform.v1beta1.FetchFeatureValuesResponse value) {
        if (entityKeyValuesBuilder_ == null) {
          if (((bitField0_ & 0x00000004) != 0)
              && entityKeyValues_ != null
              && entityKeyValues_
                  != com.google.cloud.aiplatform.v1beta1.FetchFeatureValuesResponse
                      .getDefaultInstance()) {
            getEntityKeyValuesBuilder().mergeFrom(value);
          } else {
            entityKeyValues_ = value;
          }
        } else {
          entityKeyValuesBuilder_.mergeFrom(value);
        }
        if (entityKeyValues_ != null) {
          bitField0_ |= 0x00000004;
          onChanged();
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * The attributes of the neighbor, e.g. filters, crowding and metadata
       * Note that full entities are returned only when "return_full_entity"
       * is set to true. Otherwise, only the "entity_id" and "distance" fields
       * are populated.
       * </pre>
       *
       * <code>.google.cloud.aiplatform.v1beta1.FetchFeatureValuesResponse entity_key_values = 3;
       * </code>
       */
      public Builder clearEntityKeyValues() {
        bitField0_ = (bitField0_ & ~0x00000004);
        entityKeyValues_ = null;
        if (entityKeyValuesBuilder_ != null) {
          entityKeyValuesBuilder_.dispose();
          entityKeyValuesBuilder_ = null;
        }
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * The attributes of the neighbor, e.g. filters, crowding and metadata
       * Note that full entities are returned only when "return_full_entity"
       * is set to true. Otherwise, only the "entity_id" and "distance" fields
       * are populated.
       * </pre>
       *
       * <code>.google.cloud.aiplatform.v1beta1.FetchFeatureValuesResponse entity_key_values = 3;
       * </code>
       */
      public com.google.cloud.aiplatform.v1beta1.FetchFeatureValuesResponse.Builder
          getEntityKeyValuesBuilder() {
        bitField0_ |= 0x00000004;
        onChanged();
        return getEntityKeyValuesFieldBuilder().getBuilder();
      }
      /**
       *
       *
       * <pre>
       * The attributes of the neighbor, e.g. filters, crowding and metadata
       * Note that full entities are returned only when "return_full_entity"
       * is set to true. Otherwise, only the "entity_id" and "distance" fields
       * are populated.
       * </pre>
       *
       * <code>.google.cloud.aiplatform.v1beta1.FetchFeatureValuesResponse entity_key_values = 3;
       * </code>
       */
      public com.google.cloud.aiplatform.v1beta1.FetchFeatureValuesResponseOrBuilder
          getEntityKeyValuesOrBuilder() {
        if (entityKeyValuesBuilder_ != null) {
          return entityKeyValuesBuilder_.getMessageOrBuilder();
        } else {
          return entityKeyValues_ == null
              ? com.google.cloud.aiplatform.v1beta1.FetchFeatureValuesResponse.getDefaultInstance()
              : entityKeyValues_;
        }
      }
      /**
       *
       *
       * <pre>
       * The attributes of the neighbor, e.g. filters, crowding and metadata
       * Note that full entities are returned only when "return_full_entity"
       * is set to true. Otherwise, only the "entity_id" and "distance" fields
       * are populated.
       * </pre>
       *
       * <code>.google.cloud.aiplatform.v1beta1.FetchFeatureValuesResponse entity_key_values = 3;
       * </code>
       */
      private com.google.protobuf.SingleFieldBuilderV3<
              com.google.cloud.aiplatform.v1beta1.FetchFeatureValuesResponse,
              com.google.cloud.aiplatform.v1beta1.FetchFeatureValuesResponse.Builder,
              com.google.cloud.aiplatform.v1beta1.FetchFeatureValuesResponseOrBuilder>
          getEntityKeyValuesFieldBuilder() {
        if (entityKeyValuesBuilder_ == null) {
          entityKeyValuesBuilder_ =
              new com.google.protobuf.SingleFieldBuilderV3<
                  com.google.cloud.aiplatform.v1beta1.FetchFeatureValuesResponse,
                  com.google.cloud.aiplatform.v1beta1.FetchFeatureValuesResponse.Builder,
                  com.google.cloud.aiplatform.v1beta1.FetchFeatureValuesResponseOrBuilder>(
                  getEntityKeyValues(), getParentForChildren(), isClean());
          entityKeyValues_ = null;
        }
        return entityKeyValuesBuilder_;
      }

      @java.lang.Override
      public final Builder setUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.setUnknownFields(unknownFields);
      }

      @java.lang.Override
      public final Builder mergeUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.mergeUnknownFields(unknownFields);
      }

      // @@protoc_insertion_point(builder_scope:google.cloud.aiplatform.v1beta1.NearestNeighbors.Neighbor)
    }

    // @@protoc_insertion_point(class_scope:google.cloud.aiplatform.v1beta1.NearestNeighbors.Neighbor)
    private static final com.google.cloud.aiplatform.v1beta1.NearestNeighbors.Neighbor
        DEFAULT_INSTANCE;

    static {
      DEFAULT_INSTANCE = new com.google.cloud.aiplatform.v1beta1.NearestNeighbors.Neighbor();
    }

    public static com.google.cloud.aiplatform.v1beta1.NearestNeighbors.Neighbor
        getDefaultInstance() {
      return DEFAULT_INSTANCE;
    }

    private static final com.google.protobuf.Parser<Neighbor> PARSER =
        new com.google.protobuf.AbstractParser<Neighbor>() {
          @java.lang.Override
          public Neighbor parsePartialFrom(
              com.google.protobuf.CodedInputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
            Builder builder = newBuilder();
            try {
              builder.mergeFrom(input, extensionRegistry);
            } catch (com.google.protobuf.InvalidProtocolBufferException e) {
              throw e.setUnfinishedMessage(builder.buildPartial());
            } catch (com.google.protobuf.UninitializedMessageException e) {
              throw e.asInvalidProtocolBufferException()
                  .setUnfinishedMessage(builder.buildPartial());
            } catch (java.io.IOException e) {
              throw new com.google.protobuf.InvalidProtocolBufferException(e)
                  .setUnfinishedMessage(builder.buildPartial());
            }
            return builder.buildPartial();
          }
        };

    public static com.google.protobuf.Parser<Neighbor> parser() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.protobuf.Parser<Neighbor> getParserForType() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.cloud.aiplatform.v1beta1.NearestNeighbors.Neighbor
        getDefaultInstanceForType() {
      return DEFAULT_INSTANCE;
    }
  }

  public static final int NEIGHBORS_FIELD_NUMBER = 1;

  @SuppressWarnings("serial")
  private java.util.List<com.google.cloud.aiplatform.v1beta1.NearestNeighbors.Neighbor> neighbors_;
  /**
   *
   *
   * <pre>
   * All its neighbors.
   * </pre>
   *
   * <code>repeated .google.cloud.aiplatform.v1beta1.NearestNeighbors.Neighbor neighbors = 1;</code>
   */
  @java.lang.Override
  public java.util.List<com.google.cloud.aiplatform.v1beta1.NearestNeighbors.Neighbor>
      getNeighborsList() {
    return neighbors_;
  }
  /**
   *
   *
   * <pre>
   * All its neighbors.
   * </pre>
   *
   * <code>repeated .google.cloud.aiplatform.v1beta1.NearestNeighbors.Neighbor neighbors = 1;</code>
   */
  @java.lang.Override
  public java.util.List<
          ? extends com.google.cloud.aiplatform.v1beta1.NearestNeighbors.NeighborOrBuilder>
      getNeighborsOrBuilderList() {
    return neighbors_;
  }
  /**
   *
   *
   * <pre>
   * All its neighbors.
   * </pre>
   *
   * <code>repeated .google.cloud.aiplatform.v1beta1.NearestNeighbors.Neighbor neighbors = 1;</code>
   */
  @java.lang.Override
  public int getNeighborsCount() {
    return neighbors_.size();
  }
  /**
   *
   *
   * <pre>
   * All its neighbors.
   * </pre>
   *
   * <code>repeated .google.cloud.aiplatform.v1beta1.NearestNeighbors.Neighbor neighbors = 1;</code>
   */
  @java.lang.Override
  public com.google.cloud.aiplatform.v1beta1.NearestNeighbors.Neighbor getNeighbors(int index) {
    return neighbors_.get(index);
  }
  /**
   *
   *
   * <pre>
   * All its neighbors.
   * </pre>
   *
   * <code>repeated .google.cloud.aiplatform.v1beta1.NearestNeighbors.Neighbor neighbors = 1;</code>
   */
  @java.lang.Override
  public com.google.cloud.aiplatform.v1beta1.NearestNeighbors.NeighborOrBuilder
      getNeighborsOrBuilder(int index) {
    return neighbors_.get(index);
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    for (int i = 0; i < neighbors_.size(); i++) {
      output.writeMessage(1, neighbors_.get(i));
    }
    getUnknownFields().writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    for (int i = 0; i < neighbors_.size(); i++) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(1, neighbors_.get(i));
    }
    size += getUnknownFields().getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.cloud.aiplatform.v1beta1.NearestNeighbors)) {
      return super.equals(obj);
    }
    com.google.cloud.aiplatform.v1beta1.NearestNeighbors other =
        (com.google.cloud.aiplatform.v1beta1.NearestNeighbors) obj;

    if (!getNeighborsList().equals(other.getNeighborsList())) return false;
    if (!getUnknownFields().equals(other.getUnknownFields())) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    if (getNeighborsCount() > 0) {
      hash = (37 * hash) + NEIGHBORS_FIELD_NUMBER;
      hash = (53 * hash) + getNeighborsList().hashCode();
    }
    hash = (29 * hash) + getUnknownFields().hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.cloud.aiplatform.v1beta1.NearestNeighbors parseFrom(
      java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.aiplatform.v1beta1.NearestNeighbors parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.aiplatform.v1beta1.NearestNeighbors parseFrom(
      com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.aiplatform.v1beta1.NearestNeighbors parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.aiplatform.v1beta1.NearestNeighbors parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.aiplatform.v1beta1.NearestNeighbors parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.aiplatform.v1beta1.NearestNeighbors parseFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.aiplatform.v1beta1.NearestNeighbors parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.aiplatform.v1beta1.NearestNeighbors parseDelimitedFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.cloud.aiplatform.v1beta1.NearestNeighbors parseDelimitedFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.aiplatform.v1beta1.NearestNeighbors parseFrom(
      com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.aiplatform.v1beta1.NearestNeighbors parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(com.google.cloud.aiplatform.v1beta1.NearestNeighbors prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }
  /**
   *
   *
   * <pre>
   * Nearest neighbors for one query.
   * </pre>
   *
   * Protobuf type {@code google.cloud.aiplatform.v1beta1.NearestNeighbors}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.cloud.aiplatform.v1beta1.NearestNeighbors)
      com.google.cloud.aiplatform.v1beta1.NearestNeighborsOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.aiplatform.v1beta1.FeatureOnlineStoreServiceProto
          .internal_static_google_cloud_aiplatform_v1beta1_NearestNeighbors_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.aiplatform.v1beta1.FeatureOnlineStoreServiceProto
          .internal_static_google_cloud_aiplatform_v1beta1_NearestNeighbors_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.aiplatform.v1beta1.NearestNeighbors.class,
              com.google.cloud.aiplatform.v1beta1.NearestNeighbors.Builder.class);
    }

    // Construct using com.google.cloud.aiplatform.v1beta1.NearestNeighbors.newBuilder()
    private Builder() {}

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      bitField0_ = 0;
      if (neighborsBuilder_ == null) {
        neighbors_ = java.util.Collections.emptyList();
      } else {
        neighbors_ = null;
        neighborsBuilder_.clear();
      }
      bitField0_ = (bitField0_ & ~0x00000001);
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.cloud.aiplatform.v1beta1.FeatureOnlineStoreServiceProto
          .internal_static_google_cloud_aiplatform_v1beta1_NearestNeighbors_descriptor;
    }

    @java.lang.Override
    public com.google.cloud.aiplatform.v1beta1.NearestNeighbors getDefaultInstanceForType() {
      return com.google.cloud.aiplatform.v1beta1.NearestNeighbors.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.cloud.aiplatform.v1beta1.NearestNeighbors build() {
      com.google.cloud.aiplatform.v1beta1.NearestNeighbors result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.cloud.aiplatform.v1beta1.NearestNeighbors buildPartial() {
      com.google.cloud.aiplatform.v1beta1.NearestNeighbors result =
          new com.google.cloud.aiplatform.v1beta1.NearestNeighbors(this);
      buildPartialRepeatedFields(result);
      if (bitField0_ != 0) {
        buildPartial0(result);
      }
      onBuilt();
      return result;
    }

    private void buildPartialRepeatedFields(
        com.google.cloud.aiplatform.v1beta1.NearestNeighbors result) {
      if (neighborsBuilder_ == null) {
        if (((bitField0_ & 0x00000001) != 0)) {
          neighbors_ = java.util.Collections.unmodifiableList(neighbors_);
          bitField0_ = (bitField0_ & ~0x00000001);
        }
        result.neighbors_ = neighbors_;
      } else {
        result.neighbors_ = neighborsBuilder_.build();
      }
    }

    private void buildPartial0(com.google.cloud.aiplatform.v1beta1.NearestNeighbors result) {
      int from_bitField0_ = bitField0_;
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.cloud.aiplatform.v1beta1.NearestNeighbors) {
        return mergeFrom((com.google.cloud.aiplatform.v1beta1.NearestNeighbors) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(com.google.cloud.aiplatform.v1beta1.NearestNeighbors other) {
      if (other == com.google.cloud.aiplatform.v1beta1.NearestNeighbors.getDefaultInstance())
        return this;
      if (neighborsBuilder_ == null) {
        if (!other.neighbors_.isEmpty()) {
          if (neighbors_.isEmpty()) {
            neighbors_ = other.neighbors_;
            bitField0_ = (bitField0_ & ~0x00000001);
          } else {
            ensureNeighborsIsMutable();
            neighbors_.addAll(other.neighbors_);
          }
          onChanged();
        }
      } else {
        if (!other.neighbors_.isEmpty()) {
          if (neighborsBuilder_.isEmpty()) {
            neighborsBuilder_.dispose();
            neighborsBuilder_ = null;
            neighbors_ = other.neighbors_;
            bitField0_ = (bitField0_ & ~0x00000001);
            neighborsBuilder_ =
                com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders
                    ? getNeighborsFieldBuilder()
                    : null;
          } else {
            neighborsBuilder_.addAllMessages(other.neighbors_);
          }
        }
      }
      this.mergeUnknownFields(other.getUnknownFields());
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 10:
              {
                com.google.cloud.aiplatform.v1beta1.NearestNeighbors.Neighbor m =
                    input.readMessage(
                        com.google.cloud.aiplatform.v1beta1.NearestNeighbors.Neighbor.parser(),
                        extensionRegistry);
                if (neighborsBuilder_ == null) {
                  ensureNeighborsIsMutable();
                  neighbors_.add(m);
                } else {
                  neighborsBuilder_.addMessage(m);
                }
                break;
              } // case 10
            default:
              {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
          } // switch (tag)
        } // while (!done)
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.unwrapIOException();
      } finally {
        onChanged();
      } // finally
      return this;
    }

    private int bitField0_;

    private java.util.List<com.google.cloud.aiplatform.v1beta1.NearestNeighbors.Neighbor>
        neighbors_ = java.util.Collections.emptyList();

    private void ensureNeighborsIsMutable() {
      if (!((bitField0_ & 0x00000001) != 0)) {
        neighbors_ =
            new java.util.ArrayList<com.google.cloud.aiplatform.v1beta1.NearestNeighbors.Neighbor>(
                neighbors_);
        bitField0_ |= 0x00000001;
      }
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.cloud.aiplatform.v1beta1.NearestNeighbors.Neighbor,
            com.google.cloud.aiplatform.v1beta1.NearestNeighbors.Neighbor.Builder,
            com.google.cloud.aiplatform.v1beta1.NearestNeighbors.NeighborOrBuilder>
        neighborsBuilder_;

    /**
     *
     *
     * <pre>
     * All its neighbors.
     * </pre>
     *
     * <code>repeated .google.cloud.aiplatform.v1beta1.NearestNeighbors.Neighbor neighbors = 1;
     * </code>
     */
    public java.util.List<com.google.cloud.aiplatform.v1beta1.NearestNeighbors.Neighbor>
        getNeighborsList() {
      if (neighborsBuilder_ == null) {
        return java.util.Collections.unmodifiableList(neighbors_);
      } else {
        return neighborsBuilder_.getMessageList();
      }
    }
    /**
     *
     *
     * <pre>
     * All its neighbors.
     * </pre>
     *
     * <code>repeated .google.cloud.aiplatform.v1beta1.NearestNeighbors.Neighbor neighbors = 1;
     * </code>
     */
    public int getNeighborsCount() {
      if (neighborsBuilder_ == null) {
        return neighbors_.size();
      } else {
        return neighborsBuilder_.getCount();
      }
    }
    /**
     *
     *
     * <pre>
     * All its neighbors.
     * </pre>
     *
     * <code>repeated .google.cloud.aiplatform.v1beta1.NearestNeighbors.Neighbor neighbors = 1;
     * </code>
     */
    public com.google.cloud.aiplatform.v1beta1.NearestNeighbors.Neighbor getNeighbors(int index) {
      if (neighborsBuilder_ == null) {
        return neighbors_.get(index);
      } else {
        return neighborsBuilder_.getMessage(index);
      }
    }
    /**
     *
     *
     * <pre>
     * All its neighbors.
     * </pre>
     *
     * <code>repeated .google.cloud.aiplatform.v1beta1.NearestNeighbors.Neighbor neighbors = 1;
     * </code>
     */
    public Builder setNeighbors(
        int index, com.google.cloud.aiplatform.v1beta1.NearestNeighbors.Neighbor value) {
      if (neighborsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureNeighborsIsMutable();
        neighbors_.set(index, value);
        onChanged();
      } else {
        neighborsBuilder_.setMessage(index, value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * All its neighbors.
     * </pre>
     *
     * <code>repeated .google.cloud.aiplatform.v1beta1.NearestNeighbors.Neighbor neighbors = 1;
     * </code>
     */
    public Builder setNeighbors(
        int index,
        com.google.cloud.aiplatform.v1beta1.NearestNeighbors.Neighbor.Builder builderForValue) {
      if (neighborsBuilder_ == null) {
        ensureNeighborsIsMutable();
        neighbors_.set(index, builderForValue.build());
        onChanged();
      } else {
        neighborsBuilder_.setMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * All its neighbors.
     * </pre>
     *
     * <code>repeated .google.cloud.aiplatform.v1beta1.NearestNeighbors.Neighbor neighbors = 1;
     * </code>
     */
    public Builder addNeighbors(
        com.google.cloud.aiplatform.v1beta1.NearestNeighbors.Neighbor value) {
      if (neighborsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureNeighborsIsMutable();
        neighbors_.add(value);
        onChanged();
      } else {
        neighborsBuilder_.addMessage(value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * All its neighbors.
     * </pre>
     *
     * <code>repeated .google.cloud.aiplatform.v1beta1.NearestNeighbors.Neighbor neighbors = 1;
     * </code>
     */
    public Builder addNeighbors(
        int index, com.google.cloud.aiplatform.v1beta1.NearestNeighbors.Neighbor value) {
      if (neighborsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureNeighborsIsMutable();
        neighbors_.add(index, value);
        onChanged();
      } else {
        neighborsBuilder_.addMessage(index, value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * All its neighbors.
     * </pre>
     *
     * <code>repeated .google.cloud.aiplatform.v1beta1.NearestNeighbors.Neighbor neighbors = 1;
     * </code>
     */
    public Builder addNeighbors(
        com.google.cloud.aiplatform.v1beta1.NearestNeighbors.Neighbor.Builder builderForValue) {
      if (neighborsBuilder_ == null) {
        ensureNeighborsIsMutable();
        neighbors_.add(builderForValue.build());
        onChanged();
      } else {
        neighborsBuilder_.addMessage(builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * All its neighbors.
     * </pre>
     *
     * <code>repeated .google.cloud.aiplatform.v1beta1.NearestNeighbors.Neighbor neighbors = 1;
     * </code>
     */
    public Builder addNeighbors(
        int index,
        com.google.cloud.aiplatform.v1beta1.NearestNeighbors.Neighbor.Builder builderForValue) {
      if (neighborsBuilder_ == null) {
        ensureNeighborsIsMutable();
        neighbors_.add(index, builderForValue.build());
        onChanged();
      } else {
        neighborsBuilder_.addMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * All its neighbors.
     * </pre>
     *
     * <code>repeated .google.cloud.aiplatform.v1beta1.NearestNeighbors.Neighbor neighbors = 1;
     * </code>
     */
    public Builder addAllNeighbors(
        java.lang.Iterable<? extends com.google.cloud.aiplatform.v1beta1.NearestNeighbors.Neighbor>
            values) {
      if (neighborsBuilder_ == null) {
        ensureNeighborsIsMutable();
        com.google.protobuf.AbstractMessageLite.Builder.addAll(values, neighbors_);
        onChanged();
      } else {
        neighborsBuilder_.addAllMessages(values);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * All its neighbors.
     * </pre>
     *
     * <code>repeated .google.cloud.aiplatform.v1beta1.NearestNeighbors.Neighbor neighbors = 1;
     * </code>
     */
    public Builder clearNeighbors() {
      if (neighborsBuilder_ == null) {
        neighbors_ = java.util.Collections.emptyList();
        bitField0_ = (bitField0_ & ~0x00000001);
        onChanged();
      } else {
        neighborsBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * All its neighbors.
     * </pre>
     *
     * <code>repeated .google.cloud.aiplatform.v1beta1.NearestNeighbors.Neighbor neighbors = 1;
     * </code>
     */
    public Builder removeNeighbors(int index) {
      if (neighborsBuilder_ == null) {
        ensureNeighborsIsMutable();
        neighbors_.remove(index);
        onChanged();
      } else {
        neighborsBuilder_.remove(index);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * All its neighbors.
     * </pre>
     *
     * <code>repeated .google.cloud.aiplatform.v1beta1.NearestNeighbors.Neighbor neighbors = 1;
     * </code>
     */
    public com.google.cloud.aiplatform.v1beta1.NearestNeighbors.Neighbor.Builder
        getNeighborsBuilder(int index) {
      return getNeighborsFieldBuilder().getBuilder(index);
    }
    /**
     *
     *
     * <pre>
     * All its neighbors.
     * </pre>
     *
     * <code>repeated .google.cloud.aiplatform.v1beta1.NearestNeighbors.Neighbor neighbors = 1;
     * </code>
     */
    public com.google.cloud.aiplatform.v1beta1.NearestNeighbors.NeighborOrBuilder
        getNeighborsOrBuilder(int index) {
      if (neighborsBuilder_ == null) {
        return neighbors_.get(index);
      } else {
        return neighborsBuilder_.getMessageOrBuilder(index);
      }
    }
    /**
     *
     *
     * <pre>
     * All its neighbors.
     * </pre>
     *
     * <code>repeated .google.cloud.aiplatform.v1beta1.NearestNeighbors.Neighbor neighbors = 1;
     * </code>
     */
    public java.util.List<
            ? extends com.google.cloud.aiplatform.v1beta1.NearestNeighbors.NeighborOrBuilder>
        getNeighborsOrBuilderList() {
      if (neighborsBuilder_ != null) {
        return neighborsBuilder_.getMessageOrBuilderList();
      } else {
        return java.util.Collections.unmodifiableList(neighbors_);
      }
    }
    /**
     *
     *
     * <pre>
     * All its neighbors.
     * </pre>
     *
     * <code>repeated .google.cloud.aiplatform.v1beta1.NearestNeighbors.Neighbor neighbors = 1;
     * </code>
     */
    public com.google.cloud.aiplatform.v1beta1.NearestNeighbors.Neighbor.Builder
        addNeighborsBuilder() {
      return getNeighborsFieldBuilder()
          .addBuilder(
              com.google.cloud.aiplatform.v1beta1.NearestNeighbors.Neighbor.getDefaultInstance());
    }
    /**
     *
     *
     * <pre>
     * All its neighbors.
     * </pre>
     *
     * <code>repeated .google.cloud.aiplatform.v1beta1.NearestNeighbors.Neighbor neighbors = 1;
     * </code>
     */
    public com.google.cloud.aiplatform.v1beta1.NearestNeighbors.Neighbor.Builder
        addNeighborsBuilder(int index) {
      return getNeighborsFieldBuilder()
          .addBuilder(
              index,
              com.google.cloud.aiplatform.v1beta1.NearestNeighbors.Neighbor.getDefaultInstance());
    }
    /**
     *
     *
     * <pre>
     * All its neighbors.
     * </pre>
     *
     * <code>repeated .google.cloud.aiplatform.v1beta1.NearestNeighbors.Neighbor neighbors = 1;
     * </code>
     */
    public java.util.List<com.google.cloud.aiplatform.v1beta1.NearestNeighbors.Neighbor.Builder>
        getNeighborsBuilderList() {
      return getNeighborsFieldBuilder().getBuilderList();
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.cloud.aiplatform.v1beta1.NearestNeighbors.Neighbor,
            com.google.cloud.aiplatform.v1beta1.NearestNeighbors.Neighbor.Builder,
            com.google.cloud.aiplatform.v1beta1.NearestNeighbors.NeighborOrBuilder>
        getNeighborsFieldBuilder() {
      if (neighborsBuilder_ == null) {
        neighborsBuilder_ =
            new com.google.protobuf.RepeatedFieldBuilderV3<
                com.google.cloud.aiplatform.v1beta1.NearestNeighbors.Neighbor,
                com.google.cloud.aiplatform.v1beta1.NearestNeighbors.Neighbor.Builder,
                com.google.cloud.aiplatform.v1beta1.NearestNeighbors.NeighborOrBuilder>(
                neighbors_, ((bitField0_ & 0x00000001) != 0), getParentForChildren(), isClean());
        neighbors_ = null;
      }
      return neighborsBuilder_;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.cloud.aiplatform.v1beta1.NearestNeighbors)
  }

  // @@protoc_insertion_point(class_scope:google.cloud.aiplatform.v1beta1.NearestNeighbors)
  private static final com.google.cloud.aiplatform.v1beta1.NearestNeighbors DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.cloud.aiplatform.v1beta1.NearestNeighbors();
  }

  public static com.google.cloud.aiplatform.v1beta1.NearestNeighbors getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<NearestNeighbors> PARSER =
      new com.google.protobuf.AbstractParser<NearestNeighbors>() {
        @java.lang.Override
        public NearestNeighbors parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          Builder builder = newBuilder();
          try {
            builder.mergeFrom(input, extensionRegistry);
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.setUnfinishedMessage(builder.buildPartial());
          } catch (com.google.protobuf.UninitializedMessageException e) {
            throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
          } catch (java.io.IOException e) {
            throw new com.google.protobuf.InvalidProtocolBufferException(e)
                .setUnfinishedMessage(builder.buildPartial());
          }
          return builder.buildPartial();
        }
      };

  public static com.google.protobuf.Parser<NearestNeighbors> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<NearestNeighbors> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.cloud.aiplatform.v1beta1.NearestNeighbors getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
