/*
 * Copyright 2024 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/cloud/aiplatform/v1beta1/ui_pipeline_spec.proto

// Protobuf Java Version: 3.25.5
package com.google.cloud.aiplatform.v1beta1;

/**
 *
 *
 * <pre>
 * The definition of a runtime artifact.
 * </pre>
 *
 * Protobuf type {@code google.cloud.aiplatform.v1beta1.RuntimeArtifact}
 */
public final class RuntimeArtifact extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.cloud.aiplatform.v1beta1.RuntimeArtifact)
    RuntimeArtifactOrBuilder {
  private static final long serialVersionUID = 0L;
  // Use RuntimeArtifact.newBuilder() to construct.
  private RuntimeArtifact(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private RuntimeArtifact() {
    name_ = "";
    uri_ = "";
  }

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new RuntimeArtifact();
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.cloud.aiplatform.v1beta1.UiPipelineSpecProto
        .internal_static_google_cloud_aiplatform_v1beta1_RuntimeArtifact_descriptor;
  }

  @SuppressWarnings({"rawtypes"})
  @java.lang.Override
  protected com.google.protobuf.MapFieldReflectionAccessor internalGetMapFieldReflection(
      int number) {
    switch (number) {
      case 4:
        return internalGetProperties();
      case 5:
        return internalGetCustomProperties();
      default:
        throw new RuntimeException("Invalid map field number: " + number);
    }
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.cloud.aiplatform.v1beta1.UiPipelineSpecProto
        .internal_static_google_cloud_aiplatform_v1beta1_RuntimeArtifact_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.cloud.aiplatform.v1beta1.RuntimeArtifact.class,
            com.google.cloud.aiplatform.v1beta1.RuntimeArtifact.Builder.class);
  }

  private int bitField0_;
  public static final int NAME_FIELD_NUMBER = 1;

  @SuppressWarnings("serial")
  private volatile java.lang.Object name_ = "";
  /**
   *
   *
   * <pre>
   * The name of an artifact.
   * </pre>
   *
   * <code>string name = 1;</code>
   *
   * @return The name.
   */
  @java.lang.Override
  public java.lang.String getName() {
    java.lang.Object ref = name_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      name_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * The name of an artifact.
   * </pre>
   *
   * <code>string name = 1;</code>
   *
   * @return The bytes for name.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getNameBytes() {
    java.lang.Object ref = name_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      name_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int TYPE_FIELD_NUMBER = 2;
  private com.google.cloud.aiplatform.v1beta1.ArtifactTypeSchema type_;
  /**
   *
   *
   * <pre>
   * The type of the artifact.
   * </pre>
   *
   * <code>.google.cloud.aiplatform.v1beta1.ArtifactTypeSchema type = 2;</code>
   *
   * @return Whether the type field is set.
   */
  @java.lang.Override
  public boolean hasType() {
    return ((bitField0_ & 0x00000001) != 0);
  }
  /**
   *
   *
   * <pre>
   * The type of the artifact.
   * </pre>
   *
   * <code>.google.cloud.aiplatform.v1beta1.ArtifactTypeSchema type = 2;</code>
   *
   * @return The type.
   */
  @java.lang.Override
  public com.google.cloud.aiplatform.v1beta1.ArtifactTypeSchema getType() {
    return type_ == null
        ? com.google.cloud.aiplatform.v1beta1.ArtifactTypeSchema.getDefaultInstance()
        : type_;
  }
  /**
   *
   *
   * <pre>
   * The type of the artifact.
   * </pre>
   *
   * <code>.google.cloud.aiplatform.v1beta1.ArtifactTypeSchema type = 2;</code>
   */
  @java.lang.Override
  public com.google.cloud.aiplatform.v1beta1.ArtifactTypeSchemaOrBuilder getTypeOrBuilder() {
    return type_ == null
        ? com.google.cloud.aiplatform.v1beta1.ArtifactTypeSchema.getDefaultInstance()
        : type_;
  }

  public static final int URI_FIELD_NUMBER = 3;

  @SuppressWarnings("serial")
  private volatile java.lang.Object uri_ = "";
  /**
   *
   *
   * <pre>
   * The URI of the artifact.
   * </pre>
   *
   * <code>string uri = 3;</code>
   *
   * @return The uri.
   */
  @java.lang.Override
  public java.lang.String getUri() {
    java.lang.Object ref = uri_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      uri_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * The URI of the artifact.
   * </pre>
   *
   * <code>string uri = 3;</code>
   *
   * @return The bytes for uri.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getUriBytes() {
    java.lang.Object ref = uri_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      uri_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int PROPERTIES_FIELD_NUMBER = 4;

  private static final class PropertiesDefaultEntryHolder {
    static final com.google.protobuf.MapEntry<
            java.lang.String, com.google.cloud.aiplatform.v1beta1.Value>
        defaultEntry =
            com.google.protobuf.MapEntry
                .<java.lang.String, com.google.cloud.aiplatform.v1beta1.Value>newDefaultInstance(
                    com.google.cloud.aiplatform.v1beta1.UiPipelineSpecProto
                        .internal_static_google_cloud_aiplatform_v1beta1_RuntimeArtifact_PropertiesEntry_descriptor,
                    com.google.protobuf.WireFormat.FieldType.STRING,
                    "",
                    com.google.protobuf.WireFormat.FieldType.MESSAGE,
                    com.google.cloud.aiplatform.v1beta1.Value.getDefaultInstance());
  }

  @SuppressWarnings("serial")
  private com.google.protobuf.MapField<java.lang.String, com.google.cloud.aiplatform.v1beta1.Value>
      properties_;

  private com.google.protobuf.MapField<java.lang.String, com.google.cloud.aiplatform.v1beta1.Value>
      internalGetProperties() {
    if (properties_ == null) {
      return com.google.protobuf.MapField.emptyMapField(PropertiesDefaultEntryHolder.defaultEntry);
    }
    return properties_;
  }

  @java.lang.Deprecated
  public int getPropertiesCount() {
    return internalGetProperties().getMap().size();
  }
  /**
   *
   *
   * <pre>
   * The properties of the artifact.
   * Deprecated. Use
   * [RuntimeArtifact.metadata][google.cloud.aiplatform.v1beta1.RuntimeArtifact.metadata]
   * instead.
   * </pre>
   *
   * <code>
   * map&lt;string, .google.cloud.aiplatform.v1beta1.Value&gt; properties = 4 [deprecated = true];
   * </code>
   */
  @java.lang.Override
  @java.lang.Deprecated
  public boolean containsProperties(java.lang.String key) {
    if (key == null) {
      throw new NullPointerException("map key");
    }
    return internalGetProperties().getMap().containsKey(key);
  }
  /** Use {@link #getPropertiesMap()} instead. */
  @java.lang.Override
  @java.lang.Deprecated
  public java.util.Map<java.lang.String, com.google.cloud.aiplatform.v1beta1.Value>
      getProperties() {
    return getPropertiesMap();
  }
  /**
   *
   *
   * <pre>
   * The properties of the artifact.
   * Deprecated. Use
   * [RuntimeArtifact.metadata][google.cloud.aiplatform.v1beta1.RuntimeArtifact.metadata]
   * instead.
   * </pre>
   *
   * <code>
   * map&lt;string, .google.cloud.aiplatform.v1beta1.Value&gt; properties = 4 [deprecated = true];
   * </code>
   */
  @java.lang.Override
  @java.lang.Deprecated
  public java.util.Map<java.lang.String, com.google.cloud.aiplatform.v1beta1.Value>
      getPropertiesMap() {
    return internalGetProperties().getMap();
  }
  /**
   *
   *
   * <pre>
   * The properties of the artifact.
   * Deprecated. Use
   * [RuntimeArtifact.metadata][google.cloud.aiplatform.v1beta1.RuntimeArtifact.metadata]
   * instead.
   * </pre>
   *
   * <code>
   * map&lt;string, .google.cloud.aiplatform.v1beta1.Value&gt; properties = 4 [deprecated = true];
   * </code>
   */
  @java.lang.Override
  @java.lang.Deprecated
  public /* nullable */ com.google.cloud.aiplatform.v1beta1.Value getPropertiesOrDefault(
      java.lang.String key,
      /* nullable */
      com.google.cloud.aiplatform.v1beta1.Value defaultValue) {
    if (key == null) {
      throw new NullPointerException("map key");
    }
    java.util.Map<java.lang.String, com.google.cloud.aiplatform.v1beta1.Value> map =
        internalGetProperties().getMap();
    return map.containsKey(key) ? map.get(key) : defaultValue;
  }
  /**
   *
   *
   * <pre>
   * The properties of the artifact.
   * Deprecated. Use
   * [RuntimeArtifact.metadata][google.cloud.aiplatform.v1beta1.RuntimeArtifact.metadata]
   * instead.
   * </pre>
   *
   * <code>
   * map&lt;string, .google.cloud.aiplatform.v1beta1.Value&gt; properties = 4 [deprecated = true];
   * </code>
   */
  @java.lang.Override
  @java.lang.Deprecated
  public com.google.cloud.aiplatform.v1beta1.Value getPropertiesOrThrow(java.lang.String key) {
    if (key == null) {
      throw new NullPointerException("map key");
    }
    java.util.Map<java.lang.String, com.google.cloud.aiplatform.v1beta1.Value> map =
        internalGetProperties().getMap();
    if (!map.containsKey(key)) {
      throw new java.lang.IllegalArgumentException();
    }
    return map.get(key);
  }

  public static final int CUSTOM_PROPERTIES_FIELD_NUMBER = 5;

  private static final class CustomPropertiesDefaultEntryHolder {
    static final com.google.protobuf.MapEntry<
            java.lang.String, com.google.cloud.aiplatform.v1beta1.Value>
        defaultEntry =
            com.google.protobuf.MapEntry
                .<java.lang.String, com.google.cloud.aiplatform.v1beta1.Value>newDefaultInstance(
                    com.google.cloud.aiplatform.v1beta1.UiPipelineSpecProto
                        .internal_static_google_cloud_aiplatform_v1beta1_RuntimeArtifact_CustomPropertiesEntry_descriptor,
                    com.google.protobuf.WireFormat.FieldType.STRING,
                    "",
                    com.google.protobuf.WireFormat.FieldType.MESSAGE,
                    com.google.cloud.aiplatform.v1beta1.Value.getDefaultInstance());
  }

  @SuppressWarnings("serial")
  private com.google.protobuf.MapField<java.lang.String, com.google.cloud.aiplatform.v1beta1.Value>
      customProperties_;

  private com.google.protobuf.MapField<java.lang.String, com.google.cloud.aiplatform.v1beta1.Value>
      internalGetCustomProperties() {
    if (customProperties_ == null) {
      return com.google.protobuf.MapField.emptyMapField(
          CustomPropertiesDefaultEntryHolder.defaultEntry);
    }
    return customProperties_;
  }

  @java.lang.Deprecated
  public int getCustomPropertiesCount() {
    return internalGetCustomProperties().getMap().size();
  }
  /**
   *
   *
   * <pre>
   * The custom properties of the artifact.
   * Deprecated. Use
   * [RuntimeArtifact.metadata][google.cloud.aiplatform.v1beta1.RuntimeArtifact.metadata]
   * instead.
   * </pre>
   *
   * <code>
   * map&lt;string, .google.cloud.aiplatform.v1beta1.Value&gt; custom_properties = 5 [deprecated = true];
   * </code>
   */
  @java.lang.Override
  @java.lang.Deprecated
  public boolean containsCustomProperties(java.lang.String key) {
    if (key == null) {
      throw new NullPointerException("map key");
    }
    return internalGetCustomProperties().getMap().containsKey(key);
  }
  /** Use {@link #getCustomPropertiesMap()} instead. */
  @java.lang.Override
  @java.lang.Deprecated
  public java.util.Map<java.lang.String, com.google.cloud.aiplatform.v1beta1.Value>
      getCustomProperties() {
    return getCustomPropertiesMap();
  }
  /**
   *
   *
   * <pre>
   * The custom properties of the artifact.
   * Deprecated. Use
   * [RuntimeArtifact.metadata][google.cloud.aiplatform.v1beta1.RuntimeArtifact.metadata]
   * instead.
   * </pre>
   *
   * <code>
   * map&lt;string, .google.cloud.aiplatform.v1beta1.Value&gt; custom_properties = 5 [deprecated = true];
   * </code>
   */
  @java.lang.Override
  @java.lang.Deprecated
  public java.util.Map<java.lang.String, com.google.cloud.aiplatform.v1beta1.Value>
      getCustomPropertiesMap() {
    return internalGetCustomProperties().getMap();
  }
  /**
   *
   *
   * <pre>
   * The custom properties of the artifact.
   * Deprecated. Use
   * [RuntimeArtifact.metadata][google.cloud.aiplatform.v1beta1.RuntimeArtifact.metadata]
   * instead.
   * </pre>
   *
   * <code>
   * map&lt;string, .google.cloud.aiplatform.v1beta1.Value&gt; custom_properties = 5 [deprecated = true];
   * </code>
   */
  @java.lang.Override
  @java.lang.Deprecated
  public /* nullable */ com.google.cloud.aiplatform.v1beta1.Value getCustomPropertiesOrDefault(
      java.lang.String key,
      /* nullable */
      com.google.cloud.aiplatform.v1beta1.Value defaultValue) {
    if (key == null) {
      throw new NullPointerException("map key");
    }
    java.util.Map<java.lang.String, com.google.cloud.aiplatform.v1beta1.Value> map =
        internalGetCustomProperties().getMap();
    return map.containsKey(key) ? map.get(key) : defaultValue;
  }
  /**
   *
   *
   * <pre>
   * The custom properties of the artifact.
   * Deprecated. Use
   * [RuntimeArtifact.metadata][google.cloud.aiplatform.v1beta1.RuntimeArtifact.metadata]
   * instead.
   * </pre>
   *
   * <code>
   * map&lt;string, .google.cloud.aiplatform.v1beta1.Value&gt; custom_properties = 5 [deprecated = true];
   * </code>
   */
  @java.lang.Override
  @java.lang.Deprecated
  public com.google.cloud.aiplatform.v1beta1.Value getCustomPropertiesOrThrow(
      java.lang.String key) {
    if (key == null) {
      throw new NullPointerException("map key");
    }
    java.util.Map<java.lang.String, com.google.cloud.aiplatform.v1beta1.Value> map =
        internalGetCustomProperties().getMap();
    if (!map.containsKey(key)) {
      throw new java.lang.IllegalArgumentException();
    }
    return map.get(key);
  }

  public static final int METADATA_FIELD_NUMBER = 6;
  private com.google.protobuf.Struct metadata_;
  /**
   *
   *
   * <pre>
   * Properties of the Artifact.
   * </pre>
   *
   * <code>.google.protobuf.Struct metadata = 6;</code>
   *
   * @return Whether the metadata field is set.
   */
  @java.lang.Override
  public boolean hasMetadata() {
    return ((bitField0_ & 0x00000002) != 0);
  }
  /**
   *
   *
   * <pre>
   * Properties of the Artifact.
   * </pre>
   *
   * <code>.google.protobuf.Struct metadata = 6;</code>
   *
   * @return The metadata.
   */
  @java.lang.Override
  public com.google.protobuf.Struct getMetadata() {
    return metadata_ == null ? com.google.protobuf.Struct.getDefaultInstance() : metadata_;
  }
  /**
   *
   *
   * <pre>
   * Properties of the Artifact.
   * </pre>
   *
   * <code>.google.protobuf.Struct metadata = 6;</code>
   */
  @java.lang.Override
  public com.google.protobuf.StructOrBuilder getMetadataOrBuilder() {
    return metadata_ == null ? com.google.protobuf.Struct.getDefaultInstance() : metadata_;
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(name_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 1, name_);
    }
    if (((bitField0_ & 0x00000001) != 0)) {
      output.writeMessage(2, getType());
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(uri_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 3, uri_);
    }
    com.google.protobuf.GeneratedMessageV3.serializeStringMapTo(
        output, internalGetProperties(), PropertiesDefaultEntryHolder.defaultEntry, 4);
    com.google.protobuf.GeneratedMessageV3.serializeStringMapTo(
        output, internalGetCustomProperties(), CustomPropertiesDefaultEntryHolder.defaultEntry, 5);
    if (((bitField0_ & 0x00000002) != 0)) {
      output.writeMessage(6, getMetadata());
    }
    getUnknownFields().writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(name_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(1, name_);
    }
    if (((bitField0_ & 0x00000001) != 0)) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(2, getType());
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(uri_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(3, uri_);
    }
    for (java.util.Map.Entry<java.lang.String, com.google.cloud.aiplatform.v1beta1.Value> entry :
        internalGetProperties().getMap().entrySet()) {
      com.google.protobuf.MapEntry<java.lang.String, com.google.cloud.aiplatform.v1beta1.Value>
          properties__ =
              PropertiesDefaultEntryHolder.defaultEntry
                  .newBuilderForType()
                  .setKey(entry.getKey())
                  .setValue(entry.getValue())
                  .build();
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(4, properties__);
    }
    for (java.util.Map.Entry<java.lang.String, com.google.cloud.aiplatform.v1beta1.Value> entry :
        internalGetCustomProperties().getMap().entrySet()) {
      com.google.protobuf.MapEntry<java.lang.String, com.google.cloud.aiplatform.v1beta1.Value>
          customProperties__ =
              CustomPropertiesDefaultEntryHolder.defaultEntry
                  .newBuilderForType()
                  .setKey(entry.getKey())
                  .setValue(entry.getValue())
                  .build();
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(5, customProperties__);
    }
    if (((bitField0_ & 0x00000002) != 0)) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(6, getMetadata());
    }
    size += getUnknownFields().getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.cloud.aiplatform.v1beta1.RuntimeArtifact)) {
      return super.equals(obj);
    }
    com.google.cloud.aiplatform.v1beta1.RuntimeArtifact other =
        (com.google.cloud.aiplatform.v1beta1.RuntimeArtifact) obj;

    if (!getName().equals(other.getName())) return false;
    if (hasType() != other.hasType()) return false;
    if (hasType()) {
      if (!getType().equals(other.getType())) return false;
    }
    if (!getUri().equals(other.getUri())) return false;
    if (!internalGetProperties().equals(other.internalGetProperties())) return false;
    if (!internalGetCustomProperties().equals(other.internalGetCustomProperties())) return false;
    if (hasMetadata() != other.hasMetadata()) return false;
    if (hasMetadata()) {
      if (!getMetadata().equals(other.getMetadata())) return false;
    }
    if (!getUnknownFields().equals(other.getUnknownFields())) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    hash = (37 * hash) + NAME_FIELD_NUMBER;
    hash = (53 * hash) + getName().hashCode();
    if (hasType()) {
      hash = (37 * hash) + TYPE_FIELD_NUMBER;
      hash = (53 * hash) + getType().hashCode();
    }
    hash = (37 * hash) + URI_FIELD_NUMBER;
    hash = (53 * hash) + getUri().hashCode();
    if (!internalGetProperties().getMap().isEmpty()) {
      hash = (37 * hash) + PROPERTIES_FIELD_NUMBER;
      hash = (53 * hash) + internalGetProperties().hashCode();
    }
    if (!internalGetCustomProperties().getMap().isEmpty()) {
      hash = (37 * hash) + CUSTOM_PROPERTIES_FIELD_NUMBER;
      hash = (53 * hash) + internalGetCustomProperties().hashCode();
    }
    if (hasMetadata()) {
      hash = (37 * hash) + METADATA_FIELD_NUMBER;
      hash = (53 * hash) + getMetadata().hashCode();
    }
    hash = (29 * hash) + getUnknownFields().hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.cloud.aiplatform.v1beta1.RuntimeArtifact parseFrom(
      java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.aiplatform.v1beta1.RuntimeArtifact parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.aiplatform.v1beta1.RuntimeArtifact parseFrom(
      com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.aiplatform.v1beta1.RuntimeArtifact parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.aiplatform.v1beta1.RuntimeArtifact parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.aiplatform.v1beta1.RuntimeArtifact parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.aiplatform.v1beta1.RuntimeArtifact parseFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.aiplatform.v1beta1.RuntimeArtifact parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.aiplatform.v1beta1.RuntimeArtifact parseDelimitedFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.cloud.aiplatform.v1beta1.RuntimeArtifact parseDelimitedFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.aiplatform.v1beta1.RuntimeArtifact parseFrom(
      com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.aiplatform.v1beta1.RuntimeArtifact parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(com.google.cloud.aiplatform.v1beta1.RuntimeArtifact prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }
  /**
   *
   *
   * <pre>
   * The definition of a runtime artifact.
   * </pre>
   *
   * Protobuf type {@code google.cloud.aiplatform.v1beta1.RuntimeArtifact}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.cloud.aiplatform.v1beta1.RuntimeArtifact)
      com.google.cloud.aiplatform.v1beta1.RuntimeArtifactOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.aiplatform.v1beta1.UiPipelineSpecProto
          .internal_static_google_cloud_aiplatform_v1beta1_RuntimeArtifact_descriptor;
    }

    @SuppressWarnings({"rawtypes"})
    protected com.google.protobuf.MapFieldReflectionAccessor internalGetMapFieldReflection(
        int number) {
      switch (number) {
        case 4:
          return internalGetProperties();
        case 5:
          return internalGetCustomProperties();
        default:
          throw new RuntimeException("Invalid map field number: " + number);
      }
    }

    @SuppressWarnings({"rawtypes"})
    protected com.google.protobuf.MapFieldReflectionAccessor internalGetMutableMapFieldReflection(
        int number) {
      switch (number) {
        case 4:
          return internalGetMutableProperties();
        case 5:
          return internalGetMutableCustomProperties();
        default:
          throw new RuntimeException("Invalid map field number: " + number);
      }
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.aiplatform.v1beta1.UiPipelineSpecProto
          .internal_static_google_cloud_aiplatform_v1beta1_RuntimeArtifact_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.aiplatform.v1beta1.RuntimeArtifact.class,
              com.google.cloud.aiplatform.v1beta1.RuntimeArtifact.Builder.class);
    }

    // Construct using com.google.cloud.aiplatform.v1beta1.RuntimeArtifact.newBuilder()
    private Builder() {
      maybeForceBuilderInitialization();
    }

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
      maybeForceBuilderInitialization();
    }

    private void maybeForceBuilderInitialization() {
      if (com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders) {
        getTypeFieldBuilder();
        getMetadataFieldBuilder();
      }
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      bitField0_ = 0;
      name_ = "";
      type_ = null;
      if (typeBuilder_ != null) {
        typeBuilder_.dispose();
        typeBuilder_ = null;
      }
      uri_ = "";
      internalGetMutableProperties().clear();
      internalGetMutableCustomProperties().clear();
      metadata_ = null;
      if (metadataBuilder_ != null) {
        metadataBuilder_.dispose();
        metadataBuilder_ = null;
      }
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.cloud.aiplatform.v1beta1.UiPipelineSpecProto
          .internal_static_google_cloud_aiplatform_v1beta1_RuntimeArtifact_descriptor;
    }

    @java.lang.Override
    public com.google.cloud.aiplatform.v1beta1.RuntimeArtifact getDefaultInstanceForType() {
      return com.google.cloud.aiplatform.v1beta1.RuntimeArtifact.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.cloud.aiplatform.v1beta1.RuntimeArtifact build() {
      com.google.cloud.aiplatform.v1beta1.RuntimeArtifact result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.cloud.aiplatform.v1beta1.RuntimeArtifact buildPartial() {
      com.google.cloud.aiplatform.v1beta1.RuntimeArtifact result =
          new com.google.cloud.aiplatform.v1beta1.RuntimeArtifact(this);
      if (bitField0_ != 0) {
        buildPartial0(result);
      }
      onBuilt();
      return result;
    }

    private void buildPartial0(com.google.cloud.aiplatform.v1beta1.RuntimeArtifact result) {
      int from_bitField0_ = bitField0_;
      if (((from_bitField0_ & 0x00000001) != 0)) {
        result.name_ = name_;
      }
      int to_bitField0_ = 0;
      if (((from_bitField0_ & 0x00000002) != 0)) {
        result.type_ = typeBuilder_ == null ? type_ : typeBuilder_.build();
        to_bitField0_ |= 0x00000001;
      }
      if (((from_bitField0_ & 0x00000004) != 0)) {
        result.uri_ = uri_;
      }
      if (((from_bitField0_ & 0x00000008) != 0)) {
        result.properties_ =
            internalGetProperties().build(PropertiesDefaultEntryHolder.defaultEntry);
      }
      if (((from_bitField0_ & 0x00000010) != 0)) {
        result.customProperties_ =
            internalGetCustomProperties().build(CustomPropertiesDefaultEntryHolder.defaultEntry);
      }
      if (((from_bitField0_ & 0x00000020) != 0)) {
        result.metadata_ = metadataBuilder_ == null ? metadata_ : metadataBuilder_.build();
        to_bitField0_ |= 0x00000002;
      }
      result.bitField0_ |= to_bitField0_;
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.cloud.aiplatform.v1beta1.RuntimeArtifact) {
        return mergeFrom((com.google.cloud.aiplatform.v1beta1.RuntimeArtifact) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(com.google.cloud.aiplatform.v1beta1.RuntimeArtifact other) {
      if (other == com.google.cloud.aiplatform.v1beta1.RuntimeArtifact.getDefaultInstance())
        return this;
      if (!other.getName().isEmpty()) {
        name_ = other.name_;
        bitField0_ |= 0x00000001;
        onChanged();
      }
      if (other.hasType()) {
        mergeType(other.getType());
      }
      if (!other.getUri().isEmpty()) {
        uri_ = other.uri_;
        bitField0_ |= 0x00000004;
        onChanged();
      }
      internalGetMutableProperties().mergeFrom(other.internalGetProperties());
      bitField0_ |= 0x00000008;
      internalGetMutableCustomProperties().mergeFrom(other.internalGetCustomProperties());
      bitField0_ |= 0x00000010;
      if (other.hasMetadata()) {
        mergeMetadata(other.getMetadata());
      }
      this.mergeUnknownFields(other.getUnknownFields());
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 10:
              {
                name_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000001;
                break;
              } // case 10
            case 18:
              {
                input.readMessage(getTypeFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000002;
                break;
              } // case 18
            case 26:
              {
                uri_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000004;
                break;
              } // case 26
            case 34:
              {
                com.google.protobuf.MapEntry<
                        java.lang.String, com.google.cloud.aiplatform.v1beta1.Value>
                    properties__ =
                        input.readMessage(
                            PropertiesDefaultEntryHolder.defaultEntry.getParserForType(),
                            extensionRegistry);
                internalGetMutableProperties()
                    .ensureBuilderMap()
                    .put(properties__.getKey(), properties__.getValue());
                bitField0_ |= 0x00000008;
                break;
              } // case 34
            case 42:
              {
                com.google.protobuf.MapEntry<
                        java.lang.String, com.google.cloud.aiplatform.v1beta1.Value>
                    customProperties__ =
                        input.readMessage(
                            CustomPropertiesDefaultEntryHolder.defaultEntry.getParserForType(),
                            extensionRegistry);
                internalGetMutableCustomProperties()
                    .ensureBuilderMap()
                    .put(customProperties__.getKey(), customProperties__.getValue());
                bitField0_ |= 0x00000010;
                break;
              } // case 42
            case 50:
              {
                input.readMessage(getMetadataFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000020;
                break;
              } // case 50
            default:
              {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
          } // switch (tag)
        } // while (!done)
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.unwrapIOException();
      } finally {
        onChanged();
      } // finally
      return this;
    }

    private int bitField0_;

    private java.lang.Object name_ = "";
    /**
     *
     *
     * <pre>
     * The name of an artifact.
     * </pre>
     *
     * <code>string name = 1;</code>
     *
     * @return The name.
     */
    public java.lang.String getName() {
      java.lang.Object ref = name_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        name_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * The name of an artifact.
     * </pre>
     *
     * <code>string name = 1;</code>
     *
     * @return The bytes for name.
     */
    public com.google.protobuf.ByteString getNameBytes() {
      java.lang.Object ref = name_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        name_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * The name of an artifact.
     * </pre>
     *
     * <code>string name = 1;</code>
     *
     * @param value The name to set.
     * @return This builder for chaining.
     */
    public Builder setName(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      name_ = value;
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The name of an artifact.
     * </pre>
     *
     * <code>string name = 1;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearName() {
      name_ = getDefaultInstance().getName();
      bitField0_ = (bitField0_ & ~0x00000001);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The name of an artifact.
     * </pre>
     *
     * <code>string name = 1;</code>
     *
     * @param value The bytes for name to set.
     * @return This builder for chaining.
     */
    public Builder setNameBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      name_ = value;
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }

    private com.google.cloud.aiplatform.v1beta1.ArtifactTypeSchema type_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.aiplatform.v1beta1.ArtifactTypeSchema,
            com.google.cloud.aiplatform.v1beta1.ArtifactTypeSchema.Builder,
            com.google.cloud.aiplatform.v1beta1.ArtifactTypeSchemaOrBuilder>
        typeBuilder_;
    /**
     *
     *
     * <pre>
     * The type of the artifact.
     * </pre>
     *
     * <code>.google.cloud.aiplatform.v1beta1.ArtifactTypeSchema type = 2;</code>
     *
     * @return Whether the type field is set.
     */
    public boolean hasType() {
      return ((bitField0_ & 0x00000002) != 0);
    }
    /**
     *
     *
     * <pre>
     * The type of the artifact.
     * </pre>
     *
     * <code>.google.cloud.aiplatform.v1beta1.ArtifactTypeSchema type = 2;</code>
     *
     * @return The type.
     */
    public com.google.cloud.aiplatform.v1beta1.ArtifactTypeSchema getType() {
      if (typeBuilder_ == null) {
        return type_ == null
            ? com.google.cloud.aiplatform.v1beta1.ArtifactTypeSchema.getDefaultInstance()
            : type_;
      } else {
        return typeBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * The type of the artifact.
     * </pre>
     *
     * <code>.google.cloud.aiplatform.v1beta1.ArtifactTypeSchema type = 2;</code>
     */
    public Builder setType(com.google.cloud.aiplatform.v1beta1.ArtifactTypeSchema value) {
      if (typeBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        type_ = value;
      } else {
        typeBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The type of the artifact.
     * </pre>
     *
     * <code>.google.cloud.aiplatform.v1beta1.ArtifactTypeSchema type = 2;</code>
     */
    public Builder setType(
        com.google.cloud.aiplatform.v1beta1.ArtifactTypeSchema.Builder builderForValue) {
      if (typeBuilder_ == null) {
        type_ = builderForValue.build();
      } else {
        typeBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The type of the artifact.
     * </pre>
     *
     * <code>.google.cloud.aiplatform.v1beta1.ArtifactTypeSchema type = 2;</code>
     */
    public Builder mergeType(com.google.cloud.aiplatform.v1beta1.ArtifactTypeSchema value) {
      if (typeBuilder_ == null) {
        if (((bitField0_ & 0x00000002) != 0)
            && type_ != null
            && type_
                != com.google.cloud.aiplatform.v1beta1.ArtifactTypeSchema.getDefaultInstance()) {
          getTypeBuilder().mergeFrom(value);
        } else {
          type_ = value;
        }
      } else {
        typeBuilder_.mergeFrom(value);
      }
      if (type_ != null) {
        bitField0_ |= 0x00000002;
        onChanged();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * The type of the artifact.
     * </pre>
     *
     * <code>.google.cloud.aiplatform.v1beta1.ArtifactTypeSchema type = 2;</code>
     */
    public Builder clearType() {
      bitField0_ = (bitField0_ & ~0x00000002);
      type_ = null;
      if (typeBuilder_ != null) {
        typeBuilder_.dispose();
        typeBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The type of the artifact.
     * </pre>
     *
     * <code>.google.cloud.aiplatform.v1beta1.ArtifactTypeSchema type = 2;</code>
     */
    public com.google.cloud.aiplatform.v1beta1.ArtifactTypeSchema.Builder getTypeBuilder() {
      bitField0_ |= 0x00000002;
      onChanged();
      return getTypeFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * The type of the artifact.
     * </pre>
     *
     * <code>.google.cloud.aiplatform.v1beta1.ArtifactTypeSchema type = 2;</code>
     */
    public com.google.cloud.aiplatform.v1beta1.ArtifactTypeSchemaOrBuilder getTypeOrBuilder() {
      if (typeBuilder_ != null) {
        return typeBuilder_.getMessageOrBuilder();
      } else {
        return type_ == null
            ? com.google.cloud.aiplatform.v1beta1.ArtifactTypeSchema.getDefaultInstance()
            : type_;
      }
    }
    /**
     *
     *
     * <pre>
     * The type of the artifact.
     * </pre>
     *
     * <code>.google.cloud.aiplatform.v1beta1.ArtifactTypeSchema type = 2;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.aiplatform.v1beta1.ArtifactTypeSchema,
            com.google.cloud.aiplatform.v1beta1.ArtifactTypeSchema.Builder,
            com.google.cloud.aiplatform.v1beta1.ArtifactTypeSchemaOrBuilder>
        getTypeFieldBuilder() {
      if (typeBuilder_ == null) {
        typeBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.aiplatform.v1beta1.ArtifactTypeSchema,
                com.google.cloud.aiplatform.v1beta1.ArtifactTypeSchema.Builder,
                com.google.cloud.aiplatform.v1beta1.ArtifactTypeSchemaOrBuilder>(
                getType(), getParentForChildren(), isClean());
        type_ = null;
      }
      return typeBuilder_;
    }

    private java.lang.Object uri_ = "";
    /**
     *
     *
     * <pre>
     * The URI of the artifact.
     * </pre>
     *
     * <code>string uri = 3;</code>
     *
     * @return The uri.
     */
    public java.lang.String getUri() {
      java.lang.Object ref = uri_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        uri_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * The URI of the artifact.
     * </pre>
     *
     * <code>string uri = 3;</code>
     *
     * @return The bytes for uri.
     */
    public com.google.protobuf.ByteString getUriBytes() {
      java.lang.Object ref = uri_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        uri_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * The URI of the artifact.
     * </pre>
     *
     * <code>string uri = 3;</code>
     *
     * @param value The uri to set.
     * @return This builder for chaining.
     */
    public Builder setUri(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      uri_ = value;
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The URI of the artifact.
     * </pre>
     *
     * <code>string uri = 3;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearUri() {
      uri_ = getDefaultInstance().getUri();
      bitField0_ = (bitField0_ & ~0x00000004);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The URI of the artifact.
     * </pre>
     *
     * <code>string uri = 3;</code>
     *
     * @param value The bytes for uri to set.
     * @return This builder for chaining.
     */
    public Builder setUriBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      uri_ = value;
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }

    private static final class PropertiesConverter
        implements com.google.protobuf.MapFieldBuilder.Converter<
            java.lang.String,
            com.google.cloud.aiplatform.v1beta1.ValueOrBuilder,
            com.google.cloud.aiplatform.v1beta1.Value> {
      @java.lang.Override
      public com.google.cloud.aiplatform.v1beta1.Value build(
          com.google.cloud.aiplatform.v1beta1.ValueOrBuilder val) {
        if (val instanceof com.google.cloud.aiplatform.v1beta1.Value) {
          return (com.google.cloud.aiplatform.v1beta1.Value) val;
        }
        return ((com.google.cloud.aiplatform.v1beta1.Value.Builder) val).build();
      }

      @java.lang.Override
      public com.google.protobuf.MapEntry<
              java.lang.String, com.google.cloud.aiplatform.v1beta1.Value>
          defaultEntry() {
        return PropertiesDefaultEntryHolder.defaultEntry;
      }
    };

    private static final PropertiesConverter propertiesConverter = new PropertiesConverter();

    private com.google.protobuf.MapFieldBuilder<
            java.lang.String,
            com.google.cloud.aiplatform.v1beta1.ValueOrBuilder,
            com.google.cloud.aiplatform.v1beta1.Value,
            com.google.cloud.aiplatform.v1beta1.Value.Builder>
        properties_;

    @java.lang.Deprecated
    private com.google.protobuf.MapFieldBuilder<
            java.lang.String,
            com.google.cloud.aiplatform.v1beta1.ValueOrBuilder,
            com.google.cloud.aiplatform.v1beta1.Value,
            com.google.cloud.aiplatform.v1beta1.Value.Builder>
        internalGetProperties() {
      if (properties_ == null) {
        return new com.google.protobuf.MapFieldBuilder<>(propertiesConverter);
      }
      return properties_;
    }

    @java.lang.Deprecated
    private com.google.protobuf.MapFieldBuilder<
            java.lang.String,
            com.google.cloud.aiplatform.v1beta1.ValueOrBuilder,
            com.google.cloud.aiplatform.v1beta1.Value,
            com.google.cloud.aiplatform.v1beta1.Value.Builder>
        internalGetMutableProperties() {
      if (properties_ == null) {
        properties_ = new com.google.protobuf.MapFieldBuilder<>(propertiesConverter);
      }
      bitField0_ |= 0x00000008;
      onChanged();
      return properties_;
    }

    @java.lang.Deprecated
    public int getPropertiesCount() {
      return internalGetProperties().ensureBuilderMap().size();
    }
    /**
     *
     *
     * <pre>
     * The properties of the artifact.
     * Deprecated. Use
     * [RuntimeArtifact.metadata][google.cloud.aiplatform.v1beta1.RuntimeArtifact.metadata]
     * instead.
     * </pre>
     *
     * <code>
     * map&lt;string, .google.cloud.aiplatform.v1beta1.Value&gt; properties = 4 [deprecated = true];
     * </code>
     */
    @java.lang.Override
    @java.lang.Deprecated
    public boolean containsProperties(java.lang.String key) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      return internalGetProperties().ensureBuilderMap().containsKey(key);
    }
    /** Use {@link #getPropertiesMap()} instead. */
    @java.lang.Override
    @java.lang.Deprecated
    public java.util.Map<java.lang.String, com.google.cloud.aiplatform.v1beta1.Value>
        getProperties() {
      return getPropertiesMap();
    }
    /**
     *
     *
     * <pre>
     * The properties of the artifact.
     * Deprecated. Use
     * [RuntimeArtifact.metadata][google.cloud.aiplatform.v1beta1.RuntimeArtifact.metadata]
     * instead.
     * </pre>
     *
     * <code>
     * map&lt;string, .google.cloud.aiplatform.v1beta1.Value&gt; properties = 4 [deprecated = true];
     * </code>
     */
    @java.lang.Override
    @java.lang.Deprecated
    public java.util.Map<java.lang.String, com.google.cloud.aiplatform.v1beta1.Value>
        getPropertiesMap() {
      return internalGetProperties().getImmutableMap();
    }
    /**
     *
     *
     * <pre>
     * The properties of the artifact.
     * Deprecated. Use
     * [RuntimeArtifact.metadata][google.cloud.aiplatform.v1beta1.RuntimeArtifact.metadata]
     * instead.
     * </pre>
     *
     * <code>
     * map&lt;string, .google.cloud.aiplatform.v1beta1.Value&gt; properties = 4 [deprecated = true];
     * </code>
     */
    @java.lang.Override
    @java.lang.Deprecated
    public /* nullable */ com.google.cloud.aiplatform.v1beta1.Value getPropertiesOrDefault(
        java.lang.String key,
        /* nullable */
        com.google.cloud.aiplatform.v1beta1.Value defaultValue) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      java.util.Map<java.lang.String, com.google.cloud.aiplatform.v1beta1.ValueOrBuilder> map =
          internalGetMutableProperties().ensureBuilderMap();
      return map.containsKey(key) ? propertiesConverter.build(map.get(key)) : defaultValue;
    }
    /**
     *
     *
     * <pre>
     * The properties of the artifact.
     * Deprecated. Use
     * [RuntimeArtifact.metadata][google.cloud.aiplatform.v1beta1.RuntimeArtifact.metadata]
     * instead.
     * </pre>
     *
     * <code>
     * map&lt;string, .google.cloud.aiplatform.v1beta1.Value&gt; properties = 4 [deprecated = true];
     * </code>
     */
    @java.lang.Override
    @java.lang.Deprecated
    public com.google.cloud.aiplatform.v1beta1.Value getPropertiesOrThrow(java.lang.String key) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      java.util.Map<java.lang.String, com.google.cloud.aiplatform.v1beta1.ValueOrBuilder> map =
          internalGetMutableProperties().ensureBuilderMap();
      if (!map.containsKey(key)) {
        throw new java.lang.IllegalArgumentException();
      }
      return propertiesConverter.build(map.get(key));
    }

    @java.lang.Deprecated
    public Builder clearProperties() {
      bitField0_ = (bitField0_ & ~0x00000008);
      internalGetMutableProperties().clear();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The properties of the artifact.
     * Deprecated. Use
     * [RuntimeArtifact.metadata][google.cloud.aiplatform.v1beta1.RuntimeArtifact.metadata]
     * instead.
     * </pre>
     *
     * <code>
     * map&lt;string, .google.cloud.aiplatform.v1beta1.Value&gt; properties = 4 [deprecated = true];
     * </code>
     */
    @java.lang.Deprecated
    public Builder removeProperties(java.lang.String key) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      internalGetMutableProperties().ensureBuilderMap().remove(key);
      return this;
    }
    /** Use alternate mutation accessors instead. */
    @java.lang.Deprecated
    public java.util.Map<java.lang.String, com.google.cloud.aiplatform.v1beta1.Value>
        getMutableProperties() {
      bitField0_ |= 0x00000008;
      return internalGetMutableProperties().ensureMessageMap();
    }
    /**
     *
     *
     * <pre>
     * The properties of the artifact.
     * Deprecated. Use
     * [RuntimeArtifact.metadata][google.cloud.aiplatform.v1beta1.RuntimeArtifact.metadata]
     * instead.
     * </pre>
     *
     * <code>
     * map&lt;string, .google.cloud.aiplatform.v1beta1.Value&gt; properties = 4 [deprecated = true];
     * </code>
     */
    @java.lang.Deprecated
    public Builder putProperties(
        java.lang.String key, com.google.cloud.aiplatform.v1beta1.Value value) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      if (value == null) {
        throw new NullPointerException("map value");
      }
      internalGetMutableProperties().ensureBuilderMap().put(key, value);
      bitField0_ |= 0x00000008;
      return this;
    }
    /**
     *
     *
     * <pre>
     * The properties of the artifact.
     * Deprecated. Use
     * [RuntimeArtifact.metadata][google.cloud.aiplatform.v1beta1.RuntimeArtifact.metadata]
     * instead.
     * </pre>
     *
     * <code>
     * map&lt;string, .google.cloud.aiplatform.v1beta1.Value&gt; properties = 4 [deprecated = true];
     * </code>
     */
    @java.lang.Deprecated
    public Builder putAllProperties(
        java.util.Map<java.lang.String, com.google.cloud.aiplatform.v1beta1.Value> values) {
      for (java.util.Map.Entry<java.lang.String, com.google.cloud.aiplatform.v1beta1.Value> e :
          values.entrySet()) {
        if (e.getKey() == null || e.getValue() == null) {
          throw new NullPointerException();
        }
      }
      internalGetMutableProperties().ensureBuilderMap().putAll(values);
      bitField0_ |= 0x00000008;
      return this;
    }
    /**
     *
     *
     * <pre>
     * The properties of the artifact.
     * Deprecated. Use
     * [RuntimeArtifact.metadata][google.cloud.aiplatform.v1beta1.RuntimeArtifact.metadata]
     * instead.
     * </pre>
     *
     * <code>
     * map&lt;string, .google.cloud.aiplatform.v1beta1.Value&gt; properties = 4 [deprecated = true];
     * </code>
     */
    @java.lang.Deprecated
    public com.google.cloud.aiplatform.v1beta1.Value.Builder putPropertiesBuilderIfAbsent(
        java.lang.String key) {
      java.util.Map<java.lang.String, com.google.cloud.aiplatform.v1beta1.ValueOrBuilder>
          builderMap = internalGetMutableProperties().ensureBuilderMap();
      com.google.cloud.aiplatform.v1beta1.ValueOrBuilder entry = builderMap.get(key);
      if (entry == null) {
        entry = com.google.cloud.aiplatform.v1beta1.Value.newBuilder();
        builderMap.put(key, entry);
      }
      if (entry instanceof com.google.cloud.aiplatform.v1beta1.Value) {
        entry = ((com.google.cloud.aiplatform.v1beta1.Value) entry).toBuilder();
        builderMap.put(key, entry);
      }
      return (com.google.cloud.aiplatform.v1beta1.Value.Builder) entry;
    }

    private static final class CustomPropertiesConverter
        implements com.google.protobuf.MapFieldBuilder.Converter<
            java.lang.String,
            com.google.cloud.aiplatform.v1beta1.ValueOrBuilder,
            com.google.cloud.aiplatform.v1beta1.Value> {
      @java.lang.Override
      public com.google.cloud.aiplatform.v1beta1.Value build(
          com.google.cloud.aiplatform.v1beta1.ValueOrBuilder val) {
        if (val instanceof com.google.cloud.aiplatform.v1beta1.Value) {
          return (com.google.cloud.aiplatform.v1beta1.Value) val;
        }
        return ((com.google.cloud.aiplatform.v1beta1.Value.Builder) val).build();
      }

      @java.lang.Override
      public com.google.protobuf.MapEntry<
              java.lang.String, com.google.cloud.aiplatform.v1beta1.Value>
          defaultEntry() {
        return CustomPropertiesDefaultEntryHolder.defaultEntry;
      }
    };

    private static final CustomPropertiesConverter customPropertiesConverter =
        new CustomPropertiesConverter();

    private com.google.protobuf.MapFieldBuilder<
            java.lang.String,
            com.google.cloud.aiplatform.v1beta1.ValueOrBuilder,
            com.google.cloud.aiplatform.v1beta1.Value,
            com.google.cloud.aiplatform.v1beta1.Value.Builder>
        customProperties_;

    @java.lang.Deprecated
    private com.google.protobuf.MapFieldBuilder<
            java.lang.String,
            com.google.cloud.aiplatform.v1beta1.ValueOrBuilder,
            com.google.cloud.aiplatform.v1beta1.Value,
            com.google.cloud.aiplatform.v1beta1.Value.Builder>
        internalGetCustomProperties() {
      if (customProperties_ == null) {
        return new com.google.protobuf.MapFieldBuilder<>(customPropertiesConverter);
      }
      return customProperties_;
    }

    @java.lang.Deprecated
    private com.google.protobuf.MapFieldBuilder<
            java.lang.String,
            com.google.cloud.aiplatform.v1beta1.ValueOrBuilder,
            com.google.cloud.aiplatform.v1beta1.Value,
            com.google.cloud.aiplatform.v1beta1.Value.Builder>
        internalGetMutableCustomProperties() {
      if (customProperties_ == null) {
        customProperties_ = new com.google.protobuf.MapFieldBuilder<>(customPropertiesConverter);
      }
      bitField0_ |= 0x00000010;
      onChanged();
      return customProperties_;
    }

    @java.lang.Deprecated
    public int getCustomPropertiesCount() {
      return internalGetCustomProperties().ensureBuilderMap().size();
    }
    /**
     *
     *
     * <pre>
     * The custom properties of the artifact.
     * Deprecated. Use
     * [RuntimeArtifact.metadata][google.cloud.aiplatform.v1beta1.RuntimeArtifact.metadata]
     * instead.
     * </pre>
     *
     * <code>
     * map&lt;string, .google.cloud.aiplatform.v1beta1.Value&gt; custom_properties = 5 [deprecated = true];
     * </code>
     */
    @java.lang.Override
    @java.lang.Deprecated
    public boolean containsCustomProperties(java.lang.String key) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      return internalGetCustomProperties().ensureBuilderMap().containsKey(key);
    }
    /** Use {@link #getCustomPropertiesMap()} instead. */
    @java.lang.Override
    @java.lang.Deprecated
    public java.util.Map<java.lang.String, com.google.cloud.aiplatform.v1beta1.Value>
        getCustomProperties() {
      return getCustomPropertiesMap();
    }
    /**
     *
     *
     * <pre>
     * The custom properties of the artifact.
     * Deprecated. Use
     * [RuntimeArtifact.metadata][google.cloud.aiplatform.v1beta1.RuntimeArtifact.metadata]
     * instead.
     * </pre>
     *
     * <code>
     * map&lt;string, .google.cloud.aiplatform.v1beta1.Value&gt; custom_properties = 5 [deprecated = true];
     * </code>
     */
    @java.lang.Override
    @java.lang.Deprecated
    public java.util.Map<java.lang.String, com.google.cloud.aiplatform.v1beta1.Value>
        getCustomPropertiesMap() {
      return internalGetCustomProperties().getImmutableMap();
    }
    /**
     *
     *
     * <pre>
     * The custom properties of the artifact.
     * Deprecated. Use
     * [RuntimeArtifact.metadata][google.cloud.aiplatform.v1beta1.RuntimeArtifact.metadata]
     * instead.
     * </pre>
     *
     * <code>
     * map&lt;string, .google.cloud.aiplatform.v1beta1.Value&gt; custom_properties = 5 [deprecated = true];
     * </code>
     */
    @java.lang.Override
    @java.lang.Deprecated
    public /* nullable */ com.google.cloud.aiplatform.v1beta1.Value getCustomPropertiesOrDefault(
        java.lang.String key,
        /* nullable */
        com.google.cloud.aiplatform.v1beta1.Value defaultValue) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      java.util.Map<java.lang.String, com.google.cloud.aiplatform.v1beta1.ValueOrBuilder> map =
          internalGetMutableCustomProperties().ensureBuilderMap();
      return map.containsKey(key) ? customPropertiesConverter.build(map.get(key)) : defaultValue;
    }
    /**
     *
     *
     * <pre>
     * The custom properties of the artifact.
     * Deprecated. Use
     * [RuntimeArtifact.metadata][google.cloud.aiplatform.v1beta1.RuntimeArtifact.metadata]
     * instead.
     * </pre>
     *
     * <code>
     * map&lt;string, .google.cloud.aiplatform.v1beta1.Value&gt; custom_properties = 5 [deprecated = true];
     * </code>
     */
    @java.lang.Override
    @java.lang.Deprecated
    public com.google.cloud.aiplatform.v1beta1.Value getCustomPropertiesOrThrow(
        java.lang.String key) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      java.util.Map<java.lang.String, com.google.cloud.aiplatform.v1beta1.ValueOrBuilder> map =
          internalGetMutableCustomProperties().ensureBuilderMap();
      if (!map.containsKey(key)) {
        throw new java.lang.IllegalArgumentException();
      }
      return customPropertiesConverter.build(map.get(key));
    }

    @java.lang.Deprecated
    public Builder clearCustomProperties() {
      bitField0_ = (bitField0_ & ~0x00000010);
      internalGetMutableCustomProperties().clear();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The custom properties of the artifact.
     * Deprecated. Use
     * [RuntimeArtifact.metadata][google.cloud.aiplatform.v1beta1.RuntimeArtifact.metadata]
     * instead.
     * </pre>
     *
     * <code>
     * map&lt;string, .google.cloud.aiplatform.v1beta1.Value&gt; custom_properties = 5 [deprecated = true];
     * </code>
     */
    @java.lang.Deprecated
    public Builder removeCustomProperties(java.lang.String key) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      internalGetMutableCustomProperties().ensureBuilderMap().remove(key);
      return this;
    }
    /** Use alternate mutation accessors instead. */
    @java.lang.Deprecated
    public java.util.Map<java.lang.String, com.google.cloud.aiplatform.v1beta1.Value>
        getMutableCustomProperties() {
      bitField0_ |= 0x00000010;
      return internalGetMutableCustomProperties().ensureMessageMap();
    }
    /**
     *
     *
     * <pre>
     * The custom properties of the artifact.
     * Deprecated. Use
     * [RuntimeArtifact.metadata][google.cloud.aiplatform.v1beta1.RuntimeArtifact.metadata]
     * instead.
     * </pre>
     *
     * <code>
     * map&lt;string, .google.cloud.aiplatform.v1beta1.Value&gt; custom_properties = 5 [deprecated = true];
     * </code>
     */
    @java.lang.Deprecated
    public Builder putCustomProperties(
        java.lang.String key, com.google.cloud.aiplatform.v1beta1.Value value) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      if (value == null) {
        throw new NullPointerException("map value");
      }
      internalGetMutableCustomProperties().ensureBuilderMap().put(key, value);
      bitField0_ |= 0x00000010;
      return this;
    }
    /**
     *
     *
     * <pre>
     * The custom properties of the artifact.
     * Deprecated. Use
     * [RuntimeArtifact.metadata][google.cloud.aiplatform.v1beta1.RuntimeArtifact.metadata]
     * instead.
     * </pre>
     *
     * <code>
     * map&lt;string, .google.cloud.aiplatform.v1beta1.Value&gt; custom_properties = 5 [deprecated = true];
     * </code>
     */
    @java.lang.Deprecated
    public Builder putAllCustomProperties(
        java.util.Map<java.lang.String, com.google.cloud.aiplatform.v1beta1.Value> values) {
      for (java.util.Map.Entry<java.lang.String, com.google.cloud.aiplatform.v1beta1.Value> e :
          values.entrySet()) {
        if (e.getKey() == null || e.getValue() == null) {
          throw new NullPointerException();
        }
      }
      internalGetMutableCustomProperties().ensureBuilderMap().putAll(values);
      bitField0_ |= 0x00000010;
      return this;
    }
    /**
     *
     *
     * <pre>
     * The custom properties of the artifact.
     * Deprecated. Use
     * [RuntimeArtifact.metadata][google.cloud.aiplatform.v1beta1.RuntimeArtifact.metadata]
     * instead.
     * </pre>
     *
     * <code>
     * map&lt;string, .google.cloud.aiplatform.v1beta1.Value&gt; custom_properties = 5 [deprecated = true];
     * </code>
     */
    @java.lang.Deprecated
    public com.google.cloud.aiplatform.v1beta1.Value.Builder putCustomPropertiesBuilderIfAbsent(
        java.lang.String key) {
      java.util.Map<java.lang.String, com.google.cloud.aiplatform.v1beta1.ValueOrBuilder>
          builderMap = internalGetMutableCustomProperties().ensureBuilderMap();
      com.google.cloud.aiplatform.v1beta1.ValueOrBuilder entry = builderMap.get(key);
      if (entry == null) {
        entry = com.google.cloud.aiplatform.v1beta1.Value.newBuilder();
        builderMap.put(key, entry);
      }
      if (entry instanceof com.google.cloud.aiplatform.v1beta1.Value) {
        entry = ((com.google.cloud.aiplatform.v1beta1.Value) entry).toBuilder();
        builderMap.put(key, entry);
      }
      return (com.google.cloud.aiplatform.v1beta1.Value.Builder) entry;
    }

    private com.google.protobuf.Struct metadata_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Struct,
            com.google.protobuf.Struct.Builder,
            com.google.protobuf.StructOrBuilder>
        metadataBuilder_;
    /**
     *
     *
     * <pre>
     * Properties of the Artifact.
     * </pre>
     *
     * <code>.google.protobuf.Struct metadata = 6;</code>
     *
     * @return Whether the metadata field is set.
     */
    public boolean hasMetadata() {
      return ((bitField0_ & 0x00000020) != 0);
    }
    /**
     *
     *
     * <pre>
     * Properties of the Artifact.
     * </pre>
     *
     * <code>.google.protobuf.Struct metadata = 6;</code>
     *
     * @return The metadata.
     */
    public com.google.protobuf.Struct getMetadata() {
      if (metadataBuilder_ == null) {
        return metadata_ == null ? com.google.protobuf.Struct.getDefaultInstance() : metadata_;
      } else {
        return metadataBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Properties of the Artifact.
     * </pre>
     *
     * <code>.google.protobuf.Struct metadata = 6;</code>
     */
    public Builder setMetadata(com.google.protobuf.Struct value) {
      if (metadataBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        metadata_ = value;
      } else {
        metadataBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000020;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Properties of the Artifact.
     * </pre>
     *
     * <code>.google.protobuf.Struct metadata = 6;</code>
     */
    public Builder setMetadata(com.google.protobuf.Struct.Builder builderForValue) {
      if (metadataBuilder_ == null) {
        metadata_ = builderForValue.build();
      } else {
        metadataBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000020;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Properties of the Artifact.
     * </pre>
     *
     * <code>.google.protobuf.Struct metadata = 6;</code>
     */
    public Builder mergeMetadata(com.google.protobuf.Struct value) {
      if (metadataBuilder_ == null) {
        if (((bitField0_ & 0x00000020) != 0)
            && metadata_ != null
            && metadata_ != com.google.protobuf.Struct.getDefaultInstance()) {
          getMetadataBuilder().mergeFrom(value);
        } else {
          metadata_ = value;
        }
      } else {
        metadataBuilder_.mergeFrom(value);
      }
      if (metadata_ != null) {
        bitField0_ |= 0x00000020;
        onChanged();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Properties of the Artifact.
     * </pre>
     *
     * <code>.google.protobuf.Struct metadata = 6;</code>
     */
    public Builder clearMetadata() {
      bitField0_ = (bitField0_ & ~0x00000020);
      metadata_ = null;
      if (metadataBuilder_ != null) {
        metadataBuilder_.dispose();
        metadataBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Properties of the Artifact.
     * </pre>
     *
     * <code>.google.protobuf.Struct metadata = 6;</code>
     */
    public com.google.protobuf.Struct.Builder getMetadataBuilder() {
      bitField0_ |= 0x00000020;
      onChanged();
      return getMetadataFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Properties of the Artifact.
     * </pre>
     *
     * <code>.google.protobuf.Struct metadata = 6;</code>
     */
    public com.google.protobuf.StructOrBuilder getMetadataOrBuilder() {
      if (metadataBuilder_ != null) {
        return metadataBuilder_.getMessageOrBuilder();
      } else {
        return metadata_ == null ? com.google.protobuf.Struct.getDefaultInstance() : metadata_;
      }
    }
    /**
     *
     *
     * <pre>
     * Properties of the Artifact.
     * </pre>
     *
     * <code>.google.protobuf.Struct metadata = 6;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Struct,
            com.google.protobuf.Struct.Builder,
            com.google.protobuf.StructOrBuilder>
        getMetadataFieldBuilder() {
      if (metadataBuilder_ == null) {
        metadataBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.protobuf.Struct,
                com.google.protobuf.Struct.Builder,
                com.google.protobuf.StructOrBuilder>(
                getMetadata(), getParentForChildren(), isClean());
        metadata_ = null;
      }
      return metadataBuilder_;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.cloud.aiplatform.v1beta1.RuntimeArtifact)
  }

  // @@protoc_insertion_point(class_scope:google.cloud.aiplatform.v1beta1.RuntimeArtifact)
  private static final com.google.cloud.aiplatform.v1beta1.RuntimeArtifact DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.cloud.aiplatform.v1beta1.RuntimeArtifact();
  }

  public static com.google.cloud.aiplatform.v1beta1.RuntimeArtifact getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<RuntimeArtifact> PARSER =
      new com.google.protobuf.AbstractParser<RuntimeArtifact>() {
        @java.lang.Override
        public RuntimeArtifact parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          Builder builder = newBuilder();
          try {
            builder.mergeFrom(input, extensionRegistry);
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.setUnfinishedMessage(builder.buildPartial());
          } catch (com.google.protobuf.UninitializedMessageException e) {
            throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
          } catch (java.io.IOException e) {
            throw new com.google.protobuf.InvalidProtocolBufferException(e)
                .setUnfinishedMessage(builder.buildPartial());
          }
          return builder.buildPartial();
        }
      };

  public static com.google.protobuf.Parser<RuntimeArtifact> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<RuntimeArtifact> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.cloud.aiplatform.v1beta1.RuntimeArtifact getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
