/*
 * Copyright 2024 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/cloud/aiplatform/v1beta1/feature_online_store_service.proto

// Protobuf Java Version: 3.25.5
package com.google.cloud.aiplatform.v1beta1;

/**
 *
 *
 * <pre>
 * Request message for
 * [FeatureOnlineStoreService.StreamingFetchFeatureValues][google.cloud.aiplatform.v1beta1.FeatureOnlineStoreService.StreamingFetchFeatureValues].
 * For the entities requested, all features under the requested feature view
 * will be returned.
 * </pre>
 *
 * Protobuf type {@code google.cloud.aiplatform.v1beta1.StreamingFetchFeatureValuesRequest}
 */
public final class StreamingFetchFeatureValuesRequest extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.cloud.aiplatform.v1beta1.StreamingFetchFeatureValuesRequest)
    StreamingFetchFeatureValuesRequestOrBuilder {
  private static final long serialVersionUID = 0L;
  // Use StreamingFetchFeatureValuesRequest.newBuilder() to construct.
  private StreamingFetchFeatureValuesRequest(
      com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private StreamingFetchFeatureValuesRequest() {
    featureView_ = "";
    dataKeys_ = java.util.Collections.emptyList();
    dataFormat_ = 0;
  }

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new StreamingFetchFeatureValuesRequest();
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.cloud.aiplatform.v1beta1.FeatureOnlineStoreServiceProto
        .internal_static_google_cloud_aiplatform_v1beta1_StreamingFetchFeatureValuesRequest_descriptor;
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.cloud.aiplatform.v1beta1.FeatureOnlineStoreServiceProto
        .internal_static_google_cloud_aiplatform_v1beta1_StreamingFetchFeatureValuesRequest_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.cloud.aiplatform.v1beta1.StreamingFetchFeatureValuesRequest.class,
            com.google.cloud.aiplatform.v1beta1.StreamingFetchFeatureValuesRequest.Builder.class);
  }

  public static final int FEATURE_VIEW_FIELD_NUMBER = 1;

  @SuppressWarnings("serial")
  private volatile java.lang.Object featureView_ = "";
  /**
   *
   *
   * <pre>
   * Required. FeatureView resource format
   * `projects/{project}/locations/{location}/featureOnlineStores/{featureOnlineStore}/featureViews/{featureView}`
   * </pre>
   *
   * <code>
   * string feature_view = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
   * </code>
   *
   * @return The featureView.
   */
  @java.lang.Override
  public java.lang.String getFeatureView() {
    java.lang.Object ref = featureView_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      featureView_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Required. FeatureView resource format
   * `projects/{project}/locations/{location}/featureOnlineStores/{featureOnlineStore}/featureViews/{featureView}`
   * </pre>
   *
   * <code>
   * string feature_view = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
   * </code>
   *
   * @return The bytes for featureView.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getFeatureViewBytes() {
    java.lang.Object ref = featureView_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      featureView_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int DATA_KEYS_FIELD_NUMBER = 2;

  @SuppressWarnings("serial")
  private java.util.List<com.google.cloud.aiplatform.v1beta1.FeatureViewDataKey> dataKeys_;
  /** <code>repeated .google.cloud.aiplatform.v1beta1.FeatureViewDataKey data_keys = 2;</code> */
  @java.lang.Override
  public java.util.List<com.google.cloud.aiplatform.v1beta1.FeatureViewDataKey> getDataKeysList() {
    return dataKeys_;
  }
  /** <code>repeated .google.cloud.aiplatform.v1beta1.FeatureViewDataKey data_keys = 2;</code> */
  @java.lang.Override
  public java.util.List<? extends com.google.cloud.aiplatform.v1beta1.FeatureViewDataKeyOrBuilder>
      getDataKeysOrBuilderList() {
    return dataKeys_;
  }
  /** <code>repeated .google.cloud.aiplatform.v1beta1.FeatureViewDataKey data_keys = 2;</code> */
  @java.lang.Override
  public int getDataKeysCount() {
    return dataKeys_.size();
  }
  /** <code>repeated .google.cloud.aiplatform.v1beta1.FeatureViewDataKey data_keys = 2;</code> */
  @java.lang.Override
  public com.google.cloud.aiplatform.v1beta1.FeatureViewDataKey getDataKeys(int index) {
    return dataKeys_.get(index);
  }
  /** <code>repeated .google.cloud.aiplatform.v1beta1.FeatureViewDataKey data_keys = 2;</code> */
  @java.lang.Override
  public com.google.cloud.aiplatform.v1beta1.FeatureViewDataKeyOrBuilder getDataKeysOrBuilder(
      int index) {
    return dataKeys_.get(index);
  }

  public static final int DATA_FORMAT_FIELD_NUMBER = 3;
  private int dataFormat_ = 0;
  /**
   *
   *
   * <pre>
   * Specify response data format. If not set, KeyValue format will be used.
   * </pre>
   *
   * <code>.google.cloud.aiplatform.v1beta1.FeatureViewDataFormat data_format = 3;</code>
   *
   * @return The enum numeric value on the wire for dataFormat.
   */
  @java.lang.Override
  public int getDataFormatValue() {
    return dataFormat_;
  }
  /**
   *
   *
   * <pre>
   * Specify response data format. If not set, KeyValue format will be used.
   * </pre>
   *
   * <code>.google.cloud.aiplatform.v1beta1.FeatureViewDataFormat data_format = 3;</code>
   *
   * @return The dataFormat.
   */
  @java.lang.Override
  public com.google.cloud.aiplatform.v1beta1.FeatureViewDataFormat getDataFormat() {
    com.google.cloud.aiplatform.v1beta1.FeatureViewDataFormat result =
        com.google.cloud.aiplatform.v1beta1.FeatureViewDataFormat.forNumber(dataFormat_);
    return result == null
        ? com.google.cloud.aiplatform.v1beta1.FeatureViewDataFormat.UNRECOGNIZED
        : result;
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(featureView_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 1, featureView_);
    }
    for (int i = 0; i < dataKeys_.size(); i++) {
      output.writeMessage(2, dataKeys_.get(i));
    }
    if (dataFormat_
        != com.google.cloud.aiplatform.v1beta1.FeatureViewDataFormat
            .FEATURE_VIEW_DATA_FORMAT_UNSPECIFIED
            .getNumber()) {
      output.writeEnum(3, dataFormat_);
    }
    getUnknownFields().writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(featureView_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(1, featureView_);
    }
    for (int i = 0; i < dataKeys_.size(); i++) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(2, dataKeys_.get(i));
    }
    if (dataFormat_
        != com.google.cloud.aiplatform.v1beta1.FeatureViewDataFormat
            .FEATURE_VIEW_DATA_FORMAT_UNSPECIFIED
            .getNumber()) {
      size += com.google.protobuf.CodedOutputStream.computeEnumSize(3, dataFormat_);
    }
    size += getUnknownFields().getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.cloud.aiplatform.v1beta1.StreamingFetchFeatureValuesRequest)) {
      return super.equals(obj);
    }
    com.google.cloud.aiplatform.v1beta1.StreamingFetchFeatureValuesRequest other =
        (com.google.cloud.aiplatform.v1beta1.StreamingFetchFeatureValuesRequest) obj;

    if (!getFeatureView().equals(other.getFeatureView())) return false;
    if (!getDataKeysList().equals(other.getDataKeysList())) return false;
    if (dataFormat_ != other.dataFormat_) return false;
    if (!getUnknownFields().equals(other.getUnknownFields())) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    hash = (37 * hash) + FEATURE_VIEW_FIELD_NUMBER;
    hash = (53 * hash) + getFeatureView().hashCode();
    if (getDataKeysCount() > 0) {
      hash = (37 * hash) + DATA_KEYS_FIELD_NUMBER;
      hash = (53 * hash) + getDataKeysList().hashCode();
    }
    hash = (37 * hash) + DATA_FORMAT_FIELD_NUMBER;
    hash = (53 * hash) + dataFormat_;
    hash = (29 * hash) + getUnknownFields().hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.cloud.aiplatform.v1beta1.StreamingFetchFeatureValuesRequest parseFrom(
      java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.aiplatform.v1beta1.StreamingFetchFeatureValuesRequest parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.aiplatform.v1beta1.StreamingFetchFeatureValuesRequest parseFrom(
      com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.aiplatform.v1beta1.StreamingFetchFeatureValuesRequest parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.aiplatform.v1beta1.StreamingFetchFeatureValuesRequest parseFrom(
      byte[] data) throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.aiplatform.v1beta1.StreamingFetchFeatureValuesRequest parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.aiplatform.v1beta1.StreamingFetchFeatureValuesRequest parseFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.aiplatform.v1beta1.StreamingFetchFeatureValuesRequest parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.aiplatform.v1beta1.StreamingFetchFeatureValuesRequest
      parseDelimitedFrom(java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.cloud.aiplatform.v1beta1.StreamingFetchFeatureValuesRequest
      parseDelimitedFrom(
          java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.aiplatform.v1beta1.StreamingFetchFeatureValuesRequest parseFrom(
      com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.aiplatform.v1beta1.StreamingFetchFeatureValuesRequest parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(
      com.google.cloud.aiplatform.v1beta1.StreamingFetchFeatureValuesRequest prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }
  /**
   *
   *
   * <pre>
   * Request message for
   * [FeatureOnlineStoreService.StreamingFetchFeatureValues][google.cloud.aiplatform.v1beta1.FeatureOnlineStoreService.StreamingFetchFeatureValues].
   * For the entities requested, all features under the requested feature view
   * will be returned.
   * </pre>
   *
   * Protobuf type {@code google.cloud.aiplatform.v1beta1.StreamingFetchFeatureValuesRequest}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.cloud.aiplatform.v1beta1.StreamingFetchFeatureValuesRequest)
      com.google.cloud.aiplatform.v1beta1.StreamingFetchFeatureValuesRequestOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.aiplatform.v1beta1.FeatureOnlineStoreServiceProto
          .internal_static_google_cloud_aiplatform_v1beta1_StreamingFetchFeatureValuesRequest_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.aiplatform.v1beta1.FeatureOnlineStoreServiceProto
          .internal_static_google_cloud_aiplatform_v1beta1_StreamingFetchFeatureValuesRequest_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.aiplatform.v1beta1.StreamingFetchFeatureValuesRequest.class,
              com.google.cloud.aiplatform.v1beta1.StreamingFetchFeatureValuesRequest.Builder.class);
    }

    // Construct using
    // com.google.cloud.aiplatform.v1beta1.StreamingFetchFeatureValuesRequest.newBuilder()
    private Builder() {}

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      bitField0_ = 0;
      featureView_ = "";
      if (dataKeysBuilder_ == null) {
        dataKeys_ = java.util.Collections.emptyList();
      } else {
        dataKeys_ = null;
        dataKeysBuilder_.clear();
      }
      bitField0_ = (bitField0_ & ~0x00000002);
      dataFormat_ = 0;
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.cloud.aiplatform.v1beta1.FeatureOnlineStoreServiceProto
          .internal_static_google_cloud_aiplatform_v1beta1_StreamingFetchFeatureValuesRequest_descriptor;
    }

    @java.lang.Override
    public com.google.cloud.aiplatform.v1beta1.StreamingFetchFeatureValuesRequest
        getDefaultInstanceForType() {
      return com.google.cloud.aiplatform.v1beta1.StreamingFetchFeatureValuesRequest
          .getDefaultInstance();
    }

    @java.lang.Override
    public com.google.cloud.aiplatform.v1beta1.StreamingFetchFeatureValuesRequest build() {
      com.google.cloud.aiplatform.v1beta1.StreamingFetchFeatureValuesRequest result =
          buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.cloud.aiplatform.v1beta1.StreamingFetchFeatureValuesRequest buildPartial() {
      com.google.cloud.aiplatform.v1beta1.StreamingFetchFeatureValuesRequest result =
          new com.google.cloud.aiplatform.v1beta1.StreamingFetchFeatureValuesRequest(this);
      buildPartialRepeatedFields(result);
      if (bitField0_ != 0) {
        buildPartial0(result);
      }
      onBuilt();
      return result;
    }

    private void buildPartialRepeatedFields(
        com.google.cloud.aiplatform.v1beta1.StreamingFetchFeatureValuesRequest result) {
      if (dataKeysBuilder_ == null) {
        if (((bitField0_ & 0x00000002) != 0)) {
          dataKeys_ = java.util.Collections.unmodifiableList(dataKeys_);
          bitField0_ = (bitField0_ & ~0x00000002);
        }
        result.dataKeys_ = dataKeys_;
      } else {
        result.dataKeys_ = dataKeysBuilder_.build();
      }
    }

    private void buildPartial0(
        com.google.cloud.aiplatform.v1beta1.StreamingFetchFeatureValuesRequest result) {
      int from_bitField0_ = bitField0_;
      if (((from_bitField0_ & 0x00000001) != 0)) {
        result.featureView_ = featureView_;
      }
      if (((from_bitField0_ & 0x00000004) != 0)) {
        result.dataFormat_ = dataFormat_;
      }
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.cloud.aiplatform.v1beta1.StreamingFetchFeatureValuesRequest) {
        return mergeFrom(
            (com.google.cloud.aiplatform.v1beta1.StreamingFetchFeatureValuesRequest) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(
        com.google.cloud.aiplatform.v1beta1.StreamingFetchFeatureValuesRequest other) {
      if (other
          == com.google.cloud.aiplatform.v1beta1.StreamingFetchFeatureValuesRequest
              .getDefaultInstance()) return this;
      if (!other.getFeatureView().isEmpty()) {
        featureView_ = other.featureView_;
        bitField0_ |= 0x00000001;
        onChanged();
      }
      if (dataKeysBuilder_ == null) {
        if (!other.dataKeys_.isEmpty()) {
          if (dataKeys_.isEmpty()) {
            dataKeys_ = other.dataKeys_;
            bitField0_ = (bitField0_ & ~0x00000002);
          } else {
            ensureDataKeysIsMutable();
            dataKeys_.addAll(other.dataKeys_);
          }
          onChanged();
        }
      } else {
        if (!other.dataKeys_.isEmpty()) {
          if (dataKeysBuilder_.isEmpty()) {
            dataKeysBuilder_.dispose();
            dataKeysBuilder_ = null;
            dataKeys_ = other.dataKeys_;
            bitField0_ = (bitField0_ & ~0x00000002);
            dataKeysBuilder_ =
                com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders
                    ? getDataKeysFieldBuilder()
                    : null;
          } else {
            dataKeysBuilder_.addAllMessages(other.dataKeys_);
          }
        }
      }
      if (other.dataFormat_ != 0) {
        setDataFormatValue(other.getDataFormatValue());
      }
      this.mergeUnknownFields(other.getUnknownFields());
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 10:
              {
                featureView_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000001;
                break;
              } // case 10
            case 18:
              {
                com.google.cloud.aiplatform.v1beta1.FeatureViewDataKey m =
                    input.readMessage(
                        com.google.cloud.aiplatform.v1beta1.FeatureViewDataKey.parser(),
                        extensionRegistry);
                if (dataKeysBuilder_ == null) {
                  ensureDataKeysIsMutable();
                  dataKeys_.add(m);
                } else {
                  dataKeysBuilder_.addMessage(m);
                }
                break;
              } // case 18
            case 24:
              {
                dataFormat_ = input.readEnum();
                bitField0_ |= 0x00000004;
                break;
              } // case 24
            default:
              {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
          } // switch (tag)
        } // while (!done)
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.unwrapIOException();
      } finally {
        onChanged();
      } // finally
      return this;
    }

    private int bitField0_;

    private java.lang.Object featureView_ = "";
    /**
     *
     *
     * <pre>
     * Required. FeatureView resource format
     * `projects/{project}/locations/{location}/featureOnlineStores/{featureOnlineStore}/featureViews/{featureView}`
     * </pre>
     *
     * <code>
     * string feature_view = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @return The featureView.
     */
    public java.lang.String getFeatureView() {
      java.lang.Object ref = featureView_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        featureView_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Required. FeatureView resource format
     * `projects/{project}/locations/{location}/featureOnlineStores/{featureOnlineStore}/featureViews/{featureView}`
     * </pre>
     *
     * <code>
     * string feature_view = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @return The bytes for featureView.
     */
    public com.google.protobuf.ByteString getFeatureViewBytes() {
      java.lang.Object ref = featureView_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        featureView_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Required. FeatureView resource format
     * `projects/{project}/locations/{location}/featureOnlineStores/{featureOnlineStore}/featureViews/{featureView}`
     * </pre>
     *
     * <code>
     * string feature_view = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @param value The featureView to set.
     * @return This builder for chaining.
     */
    public Builder setFeatureView(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      featureView_ = value;
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. FeatureView resource format
     * `projects/{project}/locations/{location}/featureOnlineStores/{featureOnlineStore}/featureViews/{featureView}`
     * </pre>
     *
     * <code>
     * string feature_view = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @return This builder for chaining.
     */
    public Builder clearFeatureView() {
      featureView_ = getDefaultInstance().getFeatureView();
      bitField0_ = (bitField0_ & ~0x00000001);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. FeatureView resource format
     * `projects/{project}/locations/{location}/featureOnlineStores/{featureOnlineStore}/featureViews/{featureView}`
     * </pre>
     *
     * <code>
     * string feature_view = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @param value The bytes for featureView to set.
     * @return This builder for chaining.
     */
    public Builder setFeatureViewBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      featureView_ = value;
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }

    private java.util.List<com.google.cloud.aiplatform.v1beta1.FeatureViewDataKey> dataKeys_ =
        java.util.Collections.emptyList();

    private void ensureDataKeysIsMutable() {
      if (!((bitField0_ & 0x00000002) != 0)) {
        dataKeys_ =
            new java.util.ArrayList<com.google.cloud.aiplatform.v1beta1.FeatureViewDataKey>(
                dataKeys_);
        bitField0_ |= 0x00000002;
      }
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.cloud.aiplatform.v1beta1.FeatureViewDataKey,
            com.google.cloud.aiplatform.v1beta1.FeatureViewDataKey.Builder,
            com.google.cloud.aiplatform.v1beta1.FeatureViewDataKeyOrBuilder>
        dataKeysBuilder_;

    /** <code>repeated .google.cloud.aiplatform.v1beta1.FeatureViewDataKey data_keys = 2;</code> */
    public java.util.List<com.google.cloud.aiplatform.v1beta1.FeatureViewDataKey>
        getDataKeysList() {
      if (dataKeysBuilder_ == null) {
        return java.util.Collections.unmodifiableList(dataKeys_);
      } else {
        return dataKeysBuilder_.getMessageList();
      }
    }
    /** <code>repeated .google.cloud.aiplatform.v1beta1.FeatureViewDataKey data_keys = 2;</code> */
    public int getDataKeysCount() {
      if (dataKeysBuilder_ == null) {
        return dataKeys_.size();
      } else {
        return dataKeysBuilder_.getCount();
      }
    }
    /** <code>repeated .google.cloud.aiplatform.v1beta1.FeatureViewDataKey data_keys = 2;</code> */
    public com.google.cloud.aiplatform.v1beta1.FeatureViewDataKey getDataKeys(int index) {
      if (dataKeysBuilder_ == null) {
        return dataKeys_.get(index);
      } else {
        return dataKeysBuilder_.getMessage(index);
      }
    }
    /** <code>repeated .google.cloud.aiplatform.v1beta1.FeatureViewDataKey data_keys = 2;</code> */
    public Builder setDataKeys(
        int index, com.google.cloud.aiplatform.v1beta1.FeatureViewDataKey value) {
      if (dataKeysBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureDataKeysIsMutable();
        dataKeys_.set(index, value);
        onChanged();
      } else {
        dataKeysBuilder_.setMessage(index, value);
      }
      return this;
    }
    /** <code>repeated .google.cloud.aiplatform.v1beta1.FeatureViewDataKey data_keys = 2;</code> */
    public Builder setDataKeys(
        int index, com.google.cloud.aiplatform.v1beta1.FeatureViewDataKey.Builder builderForValue) {
      if (dataKeysBuilder_ == null) {
        ensureDataKeysIsMutable();
        dataKeys_.set(index, builderForValue.build());
        onChanged();
      } else {
        dataKeysBuilder_.setMessage(index, builderForValue.build());
      }
      return this;
    }
    /** <code>repeated .google.cloud.aiplatform.v1beta1.FeatureViewDataKey data_keys = 2;</code> */
    public Builder addDataKeys(com.google.cloud.aiplatform.v1beta1.FeatureViewDataKey value) {
      if (dataKeysBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureDataKeysIsMutable();
        dataKeys_.add(value);
        onChanged();
      } else {
        dataKeysBuilder_.addMessage(value);
      }
      return this;
    }
    /** <code>repeated .google.cloud.aiplatform.v1beta1.FeatureViewDataKey data_keys = 2;</code> */
    public Builder addDataKeys(
        int index, com.google.cloud.aiplatform.v1beta1.FeatureViewDataKey value) {
      if (dataKeysBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureDataKeysIsMutable();
        dataKeys_.add(index, value);
        onChanged();
      } else {
        dataKeysBuilder_.addMessage(index, value);
      }
      return this;
    }
    /** <code>repeated .google.cloud.aiplatform.v1beta1.FeatureViewDataKey data_keys = 2;</code> */
    public Builder addDataKeys(
        com.google.cloud.aiplatform.v1beta1.FeatureViewDataKey.Builder builderForValue) {
      if (dataKeysBuilder_ == null) {
        ensureDataKeysIsMutable();
        dataKeys_.add(builderForValue.build());
        onChanged();
      } else {
        dataKeysBuilder_.addMessage(builderForValue.build());
      }
      return this;
    }
    /** <code>repeated .google.cloud.aiplatform.v1beta1.FeatureViewDataKey data_keys = 2;</code> */
    public Builder addDataKeys(
        int index, com.google.cloud.aiplatform.v1beta1.FeatureViewDataKey.Builder builderForValue) {
      if (dataKeysBuilder_ == null) {
        ensureDataKeysIsMutable();
        dataKeys_.add(index, builderForValue.build());
        onChanged();
      } else {
        dataKeysBuilder_.addMessage(index, builderForValue.build());
      }
      return this;
    }
    /** <code>repeated .google.cloud.aiplatform.v1beta1.FeatureViewDataKey data_keys = 2;</code> */
    public Builder addAllDataKeys(
        java.lang.Iterable<? extends com.google.cloud.aiplatform.v1beta1.FeatureViewDataKey>
            values) {
      if (dataKeysBuilder_ == null) {
        ensureDataKeysIsMutable();
        com.google.protobuf.AbstractMessageLite.Builder.addAll(values, dataKeys_);
        onChanged();
      } else {
        dataKeysBuilder_.addAllMessages(values);
      }
      return this;
    }
    /** <code>repeated .google.cloud.aiplatform.v1beta1.FeatureViewDataKey data_keys = 2;</code> */
    public Builder clearDataKeys() {
      if (dataKeysBuilder_ == null) {
        dataKeys_ = java.util.Collections.emptyList();
        bitField0_ = (bitField0_ & ~0x00000002);
        onChanged();
      } else {
        dataKeysBuilder_.clear();
      }
      return this;
    }
    /** <code>repeated .google.cloud.aiplatform.v1beta1.FeatureViewDataKey data_keys = 2;</code> */
    public Builder removeDataKeys(int index) {
      if (dataKeysBuilder_ == null) {
        ensureDataKeysIsMutable();
        dataKeys_.remove(index);
        onChanged();
      } else {
        dataKeysBuilder_.remove(index);
      }
      return this;
    }
    /** <code>repeated .google.cloud.aiplatform.v1beta1.FeatureViewDataKey data_keys = 2;</code> */
    public com.google.cloud.aiplatform.v1beta1.FeatureViewDataKey.Builder getDataKeysBuilder(
        int index) {
      return getDataKeysFieldBuilder().getBuilder(index);
    }
    /** <code>repeated .google.cloud.aiplatform.v1beta1.FeatureViewDataKey data_keys = 2;</code> */
    public com.google.cloud.aiplatform.v1beta1.FeatureViewDataKeyOrBuilder getDataKeysOrBuilder(
        int index) {
      if (dataKeysBuilder_ == null) {
        return dataKeys_.get(index);
      } else {
        return dataKeysBuilder_.getMessageOrBuilder(index);
      }
    }
    /** <code>repeated .google.cloud.aiplatform.v1beta1.FeatureViewDataKey data_keys = 2;</code> */
    public java.util.List<? extends com.google.cloud.aiplatform.v1beta1.FeatureViewDataKeyOrBuilder>
        getDataKeysOrBuilderList() {
      if (dataKeysBuilder_ != null) {
        return dataKeysBuilder_.getMessageOrBuilderList();
      } else {
        return java.util.Collections.unmodifiableList(dataKeys_);
      }
    }
    /** <code>repeated .google.cloud.aiplatform.v1beta1.FeatureViewDataKey data_keys = 2;</code> */
    public com.google.cloud.aiplatform.v1beta1.FeatureViewDataKey.Builder addDataKeysBuilder() {
      return getDataKeysFieldBuilder()
          .addBuilder(com.google.cloud.aiplatform.v1beta1.FeatureViewDataKey.getDefaultInstance());
    }
    /** <code>repeated .google.cloud.aiplatform.v1beta1.FeatureViewDataKey data_keys = 2;</code> */
    public com.google.cloud.aiplatform.v1beta1.FeatureViewDataKey.Builder addDataKeysBuilder(
        int index) {
      return getDataKeysFieldBuilder()
          .addBuilder(
              index, com.google.cloud.aiplatform.v1beta1.FeatureViewDataKey.getDefaultInstance());
    }
    /** <code>repeated .google.cloud.aiplatform.v1beta1.FeatureViewDataKey data_keys = 2;</code> */
    public java.util.List<com.google.cloud.aiplatform.v1beta1.FeatureViewDataKey.Builder>
        getDataKeysBuilderList() {
      return getDataKeysFieldBuilder().getBuilderList();
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.cloud.aiplatform.v1beta1.FeatureViewDataKey,
            com.google.cloud.aiplatform.v1beta1.FeatureViewDataKey.Builder,
            com.google.cloud.aiplatform.v1beta1.FeatureViewDataKeyOrBuilder>
        getDataKeysFieldBuilder() {
      if (dataKeysBuilder_ == null) {
        dataKeysBuilder_ =
            new com.google.protobuf.RepeatedFieldBuilderV3<
                com.google.cloud.aiplatform.v1beta1.FeatureViewDataKey,
                com.google.cloud.aiplatform.v1beta1.FeatureViewDataKey.Builder,
                com.google.cloud.aiplatform.v1beta1.FeatureViewDataKeyOrBuilder>(
                dataKeys_, ((bitField0_ & 0x00000002) != 0), getParentForChildren(), isClean());
        dataKeys_ = null;
      }
      return dataKeysBuilder_;
    }

    private int dataFormat_ = 0;
    /**
     *
     *
     * <pre>
     * Specify response data format. If not set, KeyValue format will be used.
     * </pre>
     *
     * <code>.google.cloud.aiplatform.v1beta1.FeatureViewDataFormat data_format = 3;</code>
     *
     * @return The enum numeric value on the wire for dataFormat.
     */
    @java.lang.Override
    public int getDataFormatValue() {
      return dataFormat_;
    }
    /**
     *
     *
     * <pre>
     * Specify response data format. If not set, KeyValue format will be used.
     * </pre>
     *
     * <code>.google.cloud.aiplatform.v1beta1.FeatureViewDataFormat data_format = 3;</code>
     *
     * @param value The enum numeric value on the wire for dataFormat to set.
     * @return This builder for chaining.
     */
    public Builder setDataFormatValue(int value) {
      dataFormat_ = value;
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Specify response data format. If not set, KeyValue format will be used.
     * </pre>
     *
     * <code>.google.cloud.aiplatform.v1beta1.FeatureViewDataFormat data_format = 3;</code>
     *
     * @return The dataFormat.
     */
    @java.lang.Override
    public com.google.cloud.aiplatform.v1beta1.FeatureViewDataFormat getDataFormat() {
      com.google.cloud.aiplatform.v1beta1.FeatureViewDataFormat result =
          com.google.cloud.aiplatform.v1beta1.FeatureViewDataFormat.forNumber(dataFormat_);
      return result == null
          ? com.google.cloud.aiplatform.v1beta1.FeatureViewDataFormat.UNRECOGNIZED
          : result;
    }
    /**
     *
     *
     * <pre>
     * Specify response data format. If not set, KeyValue format will be used.
     * </pre>
     *
     * <code>.google.cloud.aiplatform.v1beta1.FeatureViewDataFormat data_format = 3;</code>
     *
     * @param value The dataFormat to set.
     * @return This builder for chaining.
     */
    public Builder setDataFormat(com.google.cloud.aiplatform.v1beta1.FeatureViewDataFormat value) {
      if (value == null) {
        throw new NullPointerException();
      }
      bitField0_ |= 0x00000004;
      dataFormat_ = value.getNumber();
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Specify response data format. If not set, KeyValue format will be used.
     * </pre>
     *
     * <code>.google.cloud.aiplatform.v1beta1.FeatureViewDataFormat data_format = 3;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearDataFormat() {
      bitField0_ = (bitField0_ & ~0x00000004);
      dataFormat_ = 0;
      onChanged();
      return this;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.cloud.aiplatform.v1beta1.StreamingFetchFeatureValuesRequest)
  }

  // @@protoc_insertion_point(class_scope:google.cloud.aiplatform.v1beta1.StreamingFetchFeatureValuesRequest)
  private static final com.google.cloud.aiplatform.v1beta1.StreamingFetchFeatureValuesRequest
      DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.cloud.aiplatform.v1beta1.StreamingFetchFeatureValuesRequest();
  }

  public static com.google.cloud.aiplatform.v1beta1.StreamingFetchFeatureValuesRequest
      getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<StreamingFetchFeatureValuesRequest> PARSER =
      new com.google.protobuf.AbstractParser<StreamingFetchFeatureValuesRequest>() {
        @java.lang.Override
        public StreamingFetchFeatureValuesRequest parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          Builder builder = newBuilder();
          try {
            builder.mergeFrom(input, extensionRegistry);
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.setUnfinishedMessage(builder.buildPartial());
          } catch (com.google.protobuf.UninitializedMessageException e) {
            throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
          } catch (java.io.IOException e) {
            throw new com.google.protobuf.InvalidProtocolBufferException(e)
                .setUnfinishedMessage(builder.buildPartial());
          }
          return builder.buildPartial();
        }
      };

  public static com.google.protobuf.Parser<StreamingFetchFeatureValuesRequest> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<StreamingFetchFeatureValuesRequest> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.cloud.aiplatform.v1beta1.StreamingFetchFeatureValuesRequest
      getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
