/*
 * Copyright 2024 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/cloud/aiplatform/v1beta1/schema/predict/prediction/video_classification.proto

// Protobuf Java Version: 3.25.5
package com.google.cloud.aiplatform.v1beta1.schema.predict.prediction;

/**
 *
 *
 * <pre>
 * Prediction output format for Video Classification.
 * </pre>
 *
 * Protobuf type {@code
 * google.cloud.aiplatform.v1beta1.schema.predict.prediction.VideoClassificationPredictionResult}
 */
public final class VideoClassificationPredictionResult
    extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.cloud.aiplatform.v1beta1.schema.predict.prediction.VideoClassificationPredictionResult)
    VideoClassificationPredictionResultOrBuilder {
  private static final long serialVersionUID = 0L;
  // Use VideoClassificationPredictionResult.newBuilder() to construct.
  private VideoClassificationPredictionResult(
      com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private VideoClassificationPredictionResult() {
    id_ = "";
    displayName_ = "";
    type_ = "";
  }

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new VideoClassificationPredictionResult();
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.cloud.aiplatform.v1beta1.schema.predict.prediction
        .VideoClassificationPredictionResultProto
        .internal_static_google_cloud_aiplatform_v1beta1_schema_predict_prediction_VideoClassificationPredictionResult_descriptor;
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.cloud.aiplatform.v1beta1.schema.predict.prediction
        .VideoClassificationPredictionResultProto
        .internal_static_google_cloud_aiplatform_v1beta1_schema_predict_prediction_VideoClassificationPredictionResult_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.cloud.aiplatform.v1beta1.schema.predict.prediction
                .VideoClassificationPredictionResult.class,
            com.google.cloud.aiplatform.v1beta1.schema.predict.prediction
                .VideoClassificationPredictionResult.Builder.class);
  }

  private int bitField0_;
  public static final int ID_FIELD_NUMBER = 1;

  @SuppressWarnings("serial")
  private volatile java.lang.Object id_ = "";
  /**
   *
   *
   * <pre>
   * The resource ID of the AnnotationSpec that had been identified.
   * </pre>
   *
   * <code>string id = 1;</code>
   *
   * @return The id.
   */
  @java.lang.Override
  public java.lang.String getId() {
    java.lang.Object ref = id_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      id_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * The resource ID of the AnnotationSpec that had been identified.
   * </pre>
   *
   * <code>string id = 1;</code>
   *
   * @return The bytes for id.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getIdBytes() {
    java.lang.Object ref = id_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      id_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int DISPLAY_NAME_FIELD_NUMBER = 2;

  @SuppressWarnings("serial")
  private volatile java.lang.Object displayName_ = "";
  /**
   *
   *
   * <pre>
   * The display name of the AnnotationSpec that had been identified.
   * </pre>
   *
   * <code>string display_name = 2;</code>
   *
   * @return The displayName.
   */
  @java.lang.Override
  public java.lang.String getDisplayName() {
    java.lang.Object ref = displayName_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      displayName_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * The display name of the AnnotationSpec that had been identified.
   * </pre>
   *
   * <code>string display_name = 2;</code>
   *
   * @return The bytes for displayName.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getDisplayNameBytes() {
    java.lang.Object ref = displayName_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      displayName_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int TYPE_FIELD_NUMBER = 3;

  @SuppressWarnings("serial")
  private volatile java.lang.Object type_ = "";
  /**
   *
   *
   * <pre>
   * The type of the prediction. The requested types can be configured
   * via parameters. This will be one of
   * - segment-classification
   * - shot-classification
   * - one-sec-interval-classification
   * </pre>
   *
   * <code>string type = 3;</code>
   *
   * @return The type.
   */
  @java.lang.Override
  public java.lang.String getType() {
    java.lang.Object ref = type_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      type_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * The type of the prediction. The requested types can be configured
   * via parameters. This will be one of
   * - segment-classification
   * - shot-classification
   * - one-sec-interval-classification
   * </pre>
   *
   * <code>string type = 3;</code>
   *
   * @return The bytes for type.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getTypeBytes() {
    java.lang.Object ref = type_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      type_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int TIME_SEGMENT_START_FIELD_NUMBER = 4;
  private com.google.protobuf.Duration timeSegmentStart_;
  /**
   *
   *
   * <pre>
   * The beginning, inclusive, of the video's time segment in which the
   * AnnotationSpec has been identified. Expressed as a number of seconds as
   * measured from the start of the video, with fractions up to a microsecond
   * precision, and with "s" appended at the end. Note that for
   * 'segment-classification' prediction type, this equals the original
   * 'timeSegmentStart' from the input instance, for other types it is the
   * start of a shot or a 1 second interval respectively.
   * </pre>
   *
   * <code>.google.protobuf.Duration time_segment_start = 4;</code>
   *
   * @return Whether the timeSegmentStart field is set.
   */
  @java.lang.Override
  public boolean hasTimeSegmentStart() {
    return ((bitField0_ & 0x00000001) != 0);
  }
  /**
   *
   *
   * <pre>
   * The beginning, inclusive, of the video's time segment in which the
   * AnnotationSpec has been identified. Expressed as a number of seconds as
   * measured from the start of the video, with fractions up to a microsecond
   * precision, and with "s" appended at the end. Note that for
   * 'segment-classification' prediction type, this equals the original
   * 'timeSegmentStart' from the input instance, for other types it is the
   * start of a shot or a 1 second interval respectively.
   * </pre>
   *
   * <code>.google.protobuf.Duration time_segment_start = 4;</code>
   *
   * @return The timeSegmentStart.
   */
  @java.lang.Override
  public com.google.protobuf.Duration getTimeSegmentStart() {
    return timeSegmentStart_ == null
        ? com.google.protobuf.Duration.getDefaultInstance()
        : timeSegmentStart_;
  }
  /**
   *
   *
   * <pre>
   * The beginning, inclusive, of the video's time segment in which the
   * AnnotationSpec has been identified. Expressed as a number of seconds as
   * measured from the start of the video, with fractions up to a microsecond
   * precision, and with "s" appended at the end. Note that for
   * 'segment-classification' prediction type, this equals the original
   * 'timeSegmentStart' from the input instance, for other types it is the
   * start of a shot or a 1 second interval respectively.
   * </pre>
   *
   * <code>.google.protobuf.Duration time_segment_start = 4;</code>
   */
  @java.lang.Override
  public com.google.protobuf.DurationOrBuilder getTimeSegmentStartOrBuilder() {
    return timeSegmentStart_ == null
        ? com.google.protobuf.Duration.getDefaultInstance()
        : timeSegmentStart_;
  }

  public static final int TIME_SEGMENT_END_FIELD_NUMBER = 5;
  private com.google.protobuf.Duration timeSegmentEnd_;
  /**
   *
   *
   * <pre>
   * The end, exclusive, of the video's time segment in which the
   * AnnotationSpec has been identified. Expressed as a number of seconds as
   * measured from the start of the video, with fractions up to a microsecond
   * precision, and with "s" appended at the end. Note that for
   * 'segment-classification' prediction type, this equals the original
   * 'timeSegmentEnd' from the input instance, for other types it is the end
   * of a shot or a 1 second interval respectively.
   * </pre>
   *
   * <code>.google.protobuf.Duration time_segment_end = 5;</code>
   *
   * @return Whether the timeSegmentEnd field is set.
   */
  @java.lang.Override
  public boolean hasTimeSegmentEnd() {
    return ((bitField0_ & 0x00000002) != 0);
  }
  /**
   *
   *
   * <pre>
   * The end, exclusive, of the video's time segment in which the
   * AnnotationSpec has been identified. Expressed as a number of seconds as
   * measured from the start of the video, with fractions up to a microsecond
   * precision, and with "s" appended at the end. Note that for
   * 'segment-classification' prediction type, this equals the original
   * 'timeSegmentEnd' from the input instance, for other types it is the end
   * of a shot or a 1 second interval respectively.
   * </pre>
   *
   * <code>.google.protobuf.Duration time_segment_end = 5;</code>
   *
   * @return The timeSegmentEnd.
   */
  @java.lang.Override
  public com.google.protobuf.Duration getTimeSegmentEnd() {
    return timeSegmentEnd_ == null
        ? com.google.protobuf.Duration.getDefaultInstance()
        : timeSegmentEnd_;
  }
  /**
   *
   *
   * <pre>
   * The end, exclusive, of the video's time segment in which the
   * AnnotationSpec has been identified. Expressed as a number of seconds as
   * measured from the start of the video, with fractions up to a microsecond
   * precision, and with "s" appended at the end. Note that for
   * 'segment-classification' prediction type, this equals the original
   * 'timeSegmentEnd' from the input instance, for other types it is the end
   * of a shot or a 1 second interval respectively.
   * </pre>
   *
   * <code>.google.protobuf.Duration time_segment_end = 5;</code>
   */
  @java.lang.Override
  public com.google.protobuf.DurationOrBuilder getTimeSegmentEndOrBuilder() {
    return timeSegmentEnd_ == null
        ? com.google.protobuf.Duration.getDefaultInstance()
        : timeSegmentEnd_;
  }

  public static final int CONFIDENCE_FIELD_NUMBER = 6;
  private com.google.protobuf.FloatValue confidence_;
  /**
   *
   *
   * <pre>
   * The Model's confidence in correction of this prediction, higher
   * value means higher confidence.
   * </pre>
   *
   * <code>.google.protobuf.FloatValue confidence = 6;</code>
   *
   * @return Whether the confidence field is set.
   */
  @java.lang.Override
  public boolean hasConfidence() {
    return ((bitField0_ & 0x00000004) != 0);
  }
  /**
   *
   *
   * <pre>
   * The Model's confidence in correction of this prediction, higher
   * value means higher confidence.
   * </pre>
   *
   * <code>.google.protobuf.FloatValue confidence = 6;</code>
   *
   * @return The confidence.
   */
  @java.lang.Override
  public com.google.protobuf.FloatValue getConfidence() {
    return confidence_ == null ? com.google.protobuf.FloatValue.getDefaultInstance() : confidence_;
  }
  /**
   *
   *
   * <pre>
   * The Model's confidence in correction of this prediction, higher
   * value means higher confidence.
   * </pre>
   *
   * <code>.google.protobuf.FloatValue confidence = 6;</code>
   */
  @java.lang.Override
  public com.google.protobuf.FloatValueOrBuilder getConfidenceOrBuilder() {
    return confidence_ == null ? com.google.protobuf.FloatValue.getDefaultInstance() : confidence_;
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(id_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 1, id_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(displayName_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 2, displayName_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(type_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 3, type_);
    }
    if (((bitField0_ & 0x00000001) != 0)) {
      output.writeMessage(4, getTimeSegmentStart());
    }
    if (((bitField0_ & 0x00000002) != 0)) {
      output.writeMessage(5, getTimeSegmentEnd());
    }
    if (((bitField0_ & 0x00000004) != 0)) {
      output.writeMessage(6, getConfidence());
    }
    getUnknownFields().writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(id_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(1, id_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(displayName_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(2, displayName_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(type_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(3, type_);
    }
    if (((bitField0_ & 0x00000001) != 0)) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(4, getTimeSegmentStart());
    }
    if (((bitField0_ & 0x00000002) != 0)) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(5, getTimeSegmentEnd());
    }
    if (((bitField0_ & 0x00000004) != 0)) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(6, getConfidence());
    }
    size += getUnknownFields().getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj
        instanceof
        com.google.cloud.aiplatform.v1beta1.schema.predict.prediction
            .VideoClassificationPredictionResult)) {
      return super.equals(obj);
    }
    com.google.cloud.aiplatform.v1beta1.schema.predict.prediction
            .VideoClassificationPredictionResult
        other =
            (com.google.cloud.aiplatform.v1beta1.schema.predict.prediction
                    .VideoClassificationPredictionResult)
                obj;

    if (!getId().equals(other.getId())) return false;
    if (!getDisplayName().equals(other.getDisplayName())) return false;
    if (!getType().equals(other.getType())) return false;
    if (hasTimeSegmentStart() != other.hasTimeSegmentStart()) return false;
    if (hasTimeSegmentStart()) {
      if (!getTimeSegmentStart().equals(other.getTimeSegmentStart())) return false;
    }
    if (hasTimeSegmentEnd() != other.hasTimeSegmentEnd()) return false;
    if (hasTimeSegmentEnd()) {
      if (!getTimeSegmentEnd().equals(other.getTimeSegmentEnd())) return false;
    }
    if (hasConfidence() != other.hasConfidence()) return false;
    if (hasConfidence()) {
      if (!getConfidence().equals(other.getConfidence())) return false;
    }
    if (!getUnknownFields().equals(other.getUnknownFields())) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    hash = (37 * hash) + ID_FIELD_NUMBER;
    hash = (53 * hash) + getId().hashCode();
    hash = (37 * hash) + DISPLAY_NAME_FIELD_NUMBER;
    hash = (53 * hash) + getDisplayName().hashCode();
    hash = (37 * hash) + TYPE_FIELD_NUMBER;
    hash = (53 * hash) + getType().hashCode();
    if (hasTimeSegmentStart()) {
      hash = (37 * hash) + TIME_SEGMENT_START_FIELD_NUMBER;
      hash = (53 * hash) + getTimeSegmentStart().hashCode();
    }
    if (hasTimeSegmentEnd()) {
      hash = (37 * hash) + TIME_SEGMENT_END_FIELD_NUMBER;
      hash = (53 * hash) + getTimeSegmentEnd().hashCode();
    }
    if (hasConfidence()) {
      hash = (37 * hash) + CONFIDENCE_FIELD_NUMBER;
      hash = (53 * hash) + getConfidence().hashCode();
    }
    hash = (29 * hash) + getUnknownFields().hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.cloud.aiplatform.v1beta1.schema.predict.prediction
          .VideoClassificationPredictionResult
      parseFrom(java.nio.ByteBuffer data)
          throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.aiplatform.v1beta1.schema.predict.prediction
          .VideoClassificationPredictionResult
      parseFrom(
          java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.aiplatform.v1beta1.schema.predict.prediction
          .VideoClassificationPredictionResult
      parseFrom(com.google.protobuf.ByteString data)
          throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.aiplatform.v1beta1.schema.predict.prediction
          .VideoClassificationPredictionResult
      parseFrom(
          com.google.protobuf.ByteString data,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.aiplatform.v1beta1.schema.predict.prediction
          .VideoClassificationPredictionResult
      parseFrom(byte[] data) throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.aiplatform.v1beta1.schema.predict.prediction
          .VideoClassificationPredictionResult
      parseFrom(byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.aiplatform.v1beta1.schema.predict.prediction
          .VideoClassificationPredictionResult
      parseFrom(java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.aiplatform.v1beta1.schema.predict.prediction
          .VideoClassificationPredictionResult
      parseFrom(
          java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.aiplatform.v1beta1.schema.predict.prediction
          .VideoClassificationPredictionResult
      parseDelimitedFrom(java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.cloud.aiplatform.v1beta1.schema.predict.prediction
          .VideoClassificationPredictionResult
      parseDelimitedFrom(
          java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.aiplatform.v1beta1.schema.predict.prediction
          .VideoClassificationPredictionResult
      parseFrom(com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.aiplatform.v1beta1.schema.predict.prediction
          .VideoClassificationPredictionResult
      parseFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(
      com.google.cloud.aiplatform.v1beta1.schema.predict.prediction
              .VideoClassificationPredictionResult
          prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }
  /**
   *
   *
   * <pre>
   * Prediction output format for Video Classification.
   * </pre>
   *
   * Protobuf type {@code
   * google.cloud.aiplatform.v1beta1.schema.predict.prediction.VideoClassificationPredictionResult}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.cloud.aiplatform.v1beta1.schema.predict.prediction.VideoClassificationPredictionResult)
      com.google.cloud.aiplatform.v1beta1.schema.predict.prediction
          .VideoClassificationPredictionResultOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.aiplatform.v1beta1.schema.predict.prediction
          .VideoClassificationPredictionResultProto
          .internal_static_google_cloud_aiplatform_v1beta1_schema_predict_prediction_VideoClassificationPredictionResult_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.aiplatform.v1beta1.schema.predict.prediction
          .VideoClassificationPredictionResultProto
          .internal_static_google_cloud_aiplatform_v1beta1_schema_predict_prediction_VideoClassificationPredictionResult_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.aiplatform.v1beta1.schema.predict.prediction
                  .VideoClassificationPredictionResult.class,
              com.google.cloud.aiplatform.v1beta1.schema.predict.prediction
                  .VideoClassificationPredictionResult.Builder.class);
    }

    // Construct using
    // com.google.cloud.aiplatform.v1beta1.schema.predict.prediction.VideoClassificationPredictionResult.newBuilder()
    private Builder() {
      maybeForceBuilderInitialization();
    }

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
      maybeForceBuilderInitialization();
    }

    private void maybeForceBuilderInitialization() {
      if (com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders) {
        getTimeSegmentStartFieldBuilder();
        getTimeSegmentEndFieldBuilder();
        getConfidenceFieldBuilder();
      }
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      bitField0_ = 0;
      id_ = "";
      displayName_ = "";
      type_ = "";
      timeSegmentStart_ = null;
      if (timeSegmentStartBuilder_ != null) {
        timeSegmentStartBuilder_.dispose();
        timeSegmentStartBuilder_ = null;
      }
      timeSegmentEnd_ = null;
      if (timeSegmentEndBuilder_ != null) {
        timeSegmentEndBuilder_.dispose();
        timeSegmentEndBuilder_ = null;
      }
      confidence_ = null;
      if (confidenceBuilder_ != null) {
        confidenceBuilder_.dispose();
        confidenceBuilder_ = null;
      }
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.cloud.aiplatform.v1beta1.schema.predict.prediction
          .VideoClassificationPredictionResultProto
          .internal_static_google_cloud_aiplatform_v1beta1_schema_predict_prediction_VideoClassificationPredictionResult_descriptor;
    }

    @java.lang.Override
    public com.google.cloud.aiplatform.v1beta1.schema.predict.prediction
            .VideoClassificationPredictionResult
        getDefaultInstanceForType() {
      return com.google.cloud.aiplatform.v1beta1.schema.predict.prediction
          .VideoClassificationPredictionResult.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.cloud.aiplatform.v1beta1.schema.predict.prediction
            .VideoClassificationPredictionResult
        build() {
      com.google.cloud.aiplatform.v1beta1.schema.predict.prediction
              .VideoClassificationPredictionResult
          result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.cloud.aiplatform.v1beta1.schema.predict.prediction
            .VideoClassificationPredictionResult
        buildPartial() {
      com.google.cloud.aiplatform.v1beta1.schema.predict.prediction
              .VideoClassificationPredictionResult
          result =
              new com.google.cloud.aiplatform.v1beta1.schema.predict.prediction
                  .VideoClassificationPredictionResult(this);
      if (bitField0_ != 0) {
        buildPartial0(result);
      }
      onBuilt();
      return result;
    }

    private void buildPartial0(
        com.google.cloud.aiplatform.v1beta1.schema.predict.prediction
                .VideoClassificationPredictionResult
            result) {
      int from_bitField0_ = bitField0_;
      if (((from_bitField0_ & 0x00000001) != 0)) {
        result.id_ = id_;
      }
      if (((from_bitField0_ & 0x00000002) != 0)) {
        result.displayName_ = displayName_;
      }
      if (((from_bitField0_ & 0x00000004) != 0)) {
        result.type_ = type_;
      }
      int to_bitField0_ = 0;
      if (((from_bitField0_ & 0x00000008) != 0)) {
        result.timeSegmentStart_ =
            timeSegmentStartBuilder_ == null ? timeSegmentStart_ : timeSegmentStartBuilder_.build();
        to_bitField0_ |= 0x00000001;
      }
      if (((from_bitField0_ & 0x00000010) != 0)) {
        result.timeSegmentEnd_ =
            timeSegmentEndBuilder_ == null ? timeSegmentEnd_ : timeSegmentEndBuilder_.build();
        to_bitField0_ |= 0x00000002;
      }
      if (((from_bitField0_ & 0x00000020) != 0)) {
        result.confidence_ = confidenceBuilder_ == null ? confidence_ : confidenceBuilder_.build();
        to_bitField0_ |= 0x00000004;
      }
      result.bitField0_ |= to_bitField0_;
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other
          instanceof
          com.google.cloud.aiplatform.v1beta1.schema.predict.prediction
              .VideoClassificationPredictionResult) {
        return mergeFrom(
            (com.google.cloud.aiplatform.v1beta1.schema.predict.prediction
                    .VideoClassificationPredictionResult)
                other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(
        com.google.cloud.aiplatform.v1beta1.schema.predict.prediction
                .VideoClassificationPredictionResult
            other) {
      if (other
          == com.google.cloud.aiplatform.v1beta1.schema.predict.prediction
              .VideoClassificationPredictionResult.getDefaultInstance()) return this;
      if (!other.getId().isEmpty()) {
        id_ = other.id_;
        bitField0_ |= 0x00000001;
        onChanged();
      }
      if (!other.getDisplayName().isEmpty()) {
        displayName_ = other.displayName_;
        bitField0_ |= 0x00000002;
        onChanged();
      }
      if (!other.getType().isEmpty()) {
        type_ = other.type_;
        bitField0_ |= 0x00000004;
        onChanged();
      }
      if (other.hasTimeSegmentStart()) {
        mergeTimeSegmentStart(other.getTimeSegmentStart());
      }
      if (other.hasTimeSegmentEnd()) {
        mergeTimeSegmentEnd(other.getTimeSegmentEnd());
      }
      if (other.hasConfidence()) {
        mergeConfidence(other.getConfidence());
      }
      this.mergeUnknownFields(other.getUnknownFields());
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 10:
              {
                id_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000001;
                break;
              } // case 10
            case 18:
              {
                displayName_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000002;
                break;
              } // case 18
            case 26:
              {
                type_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000004;
                break;
              } // case 26
            case 34:
              {
                input.readMessage(
                    getTimeSegmentStartFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000008;
                break;
              } // case 34
            case 42:
              {
                input.readMessage(getTimeSegmentEndFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000010;
                break;
              } // case 42
            case 50:
              {
                input.readMessage(getConfidenceFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000020;
                break;
              } // case 50
            default:
              {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
          } // switch (tag)
        } // while (!done)
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.unwrapIOException();
      } finally {
        onChanged();
      } // finally
      return this;
    }

    private int bitField0_;

    private java.lang.Object id_ = "";
    /**
     *
     *
     * <pre>
     * The resource ID of the AnnotationSpec that had been identified.
     * </pre>
     *
     * <code>string id = 1;</code>
     *
     * @return The id.
     */
    public java.lang.String getId() {
      java.lang.Object ref = id_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        id_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * The resource ID of the AnnotationSpec that had been identified.
     * </pre>
     *
     * <code>string id = 1;</code>
     *
     * @return The bytes for id.
     */
    public com.google.protobuf.ByteString getIdBytes() {
      java.lang.Object ref = id_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        id_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * The resource ID of the AnnotationSpec that had been identified.
     * </pre>
     *
     * <code>string id = 1;</code>
     *
     * @param value The id to set.
     * @return This builder for chaining.
     */
    public Builder setId(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      id_ = value;
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The resource ID of the AnnotationSpec that had been identified.
     * </pre>
     *
     * <code>string id = 1;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearId() {
      id_ = getDefaultInstance().getId();
      bitField0_ = (bitField0_ & ~0x00000001);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The resource ID of the AnnotationSpec that had been identified.
     * </pre>
     *
     * <code>string id = 1;</code>
     *
     * @param value The bytes for id to set.
     * @return This builder for chaining.
     */
    public Builder setIdBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      id_ = value;
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }

    private java.lang.Object displayName_ = "";
    /**
     *
     *
     * <pre>
     * The display name of the AnnotationSpec that had been identified.
     * </pre>
     *
     * <code>string display_name = 2;</code>
     *
     * @return The displayName.
     */
    public java.lang.String getDisplayName() {
      java.lang.Object ref = displayName_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        displayName_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * The display name of the AnnotationSpec that had been identified.
     * </pre>
     *
     * <code>string display_name = 2;</code>
     *
     * @return The bytes for displayName.
     */
    public com.google.protobuf.ByteString getDisplayNameBytes() {
      java.lang.Object ref = displayName_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        displayName_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * The display name of the AnnotationSpec that had been identified.
     * </pre>
     *
     * <code>string display_name = 2;</code>
     *
     * @param value The displayName to set.
     * @return This builder for chaining.
     */
    public Builder setDisplayName(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      displayName_ = value;
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The display name of the AnnotationSpec that had been identified.
     * </pre>
     *
     * <code>string display_name = 2;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearDisplayName() {
      displayName_ = getDefaultInstance().getDisplayName();
      bitField0_ = (bitField0_ & ~0x00000002);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The display name of the AnnotationSpec that had been identified.
     * </pre>
     *
     * <code>string display_name = 2;</code>
     *
     * @param value The bytes for displayName to set.
     * @return This builder for chaining.
     */
    public Builder setDisplayNameBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      displayName_ = value;
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }

    private java.lang.Object type_ = "";
    /**
     *
     *
     * <pre>
     * The type of the prediction. The requested types can be configured
     * via parameters. This will be one of
     * - segment-classification
     * - shot-classification
     * - one-sec-interval-classification
     * </pre>
     *
     * <code>string type = 3;</code>
     *
     * @return The type.
     */
    public java.lang.String getType() {
      java.lang.Object ref = type_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        type_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * The type of the prediction. The requested types can be configured
     * via parameters. This will be one of
     * - segment-classification
     * - shot-classification
     * - one-sec-interval-classification
     * </pre>
     *
     * <code>string type = 3;</code>
     *
     * @return The bytes for type.
     */
    public com.google.protobuf.ByteString getTypeBytes() {
      java.lang.Object ref = type_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        type_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * The type of the prediction. The requested types can be configured
     * via parameters. This will be one of
     * - segment-classification
     * - shot-classification
     * - one-sec-interval-classification
     * </pre>
     *
     * <code>string type = 3;</code>
     *
     * @param value The type to set.
     * @return This builder for chaining.
     */
    public Builder setType(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      type_ = value;
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The type of the prediction. The requested types can be configured
     * via parameters. This will be one of
     * - segment-classification
     * - shot-classification
     * - one-sec-interval-classification
     * </pre>
     *
     * <code>string type = 3;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearType() {
      type_ = getDefaultInstance().getType();
      bitField0_ = (bitField0_ & ~0x00000004);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The type of the prediction. The requested types can be configured
     * via parameters. This will be one of
     * - segment-classification
     * - shot-classification
     * - one-sec-interval-classification
     * </pre>
     *
     * <code>string type = 3;</code>
     *
     * @param value The bytes for type to set.
     * @return This builder for chaining.
     */
    public Builder setTypeBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      type_ = value;
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }

    private com.google.protobuf.Duration timeSegmentStart_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Duration,
            com.google.protobuf.Duration.Builder,
            com.google.protobuf.DurationOrBuilder>
        timeSegmentStartBuilder_;
    /**
     *
     *
     * <pre>
     * The beginning, inclusive, of the video's time segment in which the
     * AnnotationSpec has been identified. Expressed as a number of seconds as
     * measured from the start of the video, with fractions up to a microsecond
     * precision, and with "s" appended at the end. Note that for
     * 'segment-classification' prediction type, this equals the original
     * 'timeSegmentStart' from the input instance, for other types it is the
     * start of a shot or a 1 second interval respectively.
     * </pre>
     *
     * <code>.google.protobuf.Duration time_segment_start = 4;</code>
     *
     * @return Whether the timeSegmentStart field is set.
     */
    public boolean hasTimeSegmentStart() {
      return ((bitField0_ & 0x00000008) != 0);
    }
    /**
     *
     *
     * <pre>
     * The beginning, inclusive, of the video's time segment in which the
     * AnnotationSpec has been identified. Expressed as a number of seconds as
     * measured from the start of the video, with fractions up to a microsecond
     * precision, and with "s" appended at the end. Note that for
     * 'segment-classification' prediction type, this equals the original
     * 'timeSegmentStart' from the input instance, for other types it is the
     * start of a shot or a 1 second interval respectively.
     * </pre>
     *
     * <code>.google.protobuf.Duration time_segment_start = 4;</code>
     *
     * @return The timeSegmentStart.
     */
    public com.google.protobuf.Duration getTimeSegmentStart() {
      if (timeSegmentStartBuilder_ == null) {
        return timeSegmentStart_ == null
            ? com.google.protobuf.Duration.getDefaultInstance()
            : timeSegmentStart_;
      } else {
        return timeSegmentStartBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * The beginning, inclusive, of the video's time segment in which the
     * AnnotationSpec has been identified. Expressed as a number of seconds as
     * measured from the start of the video, with fractions up to a microsecond
     * precision, and with "s" appended at the end. Note that for
     * 'segment-classification' prediction type, this equals the original
     * 'timeSegmentStart' from the input instance, for other types it is the
     * start of a shot or a 1 second interval respectively.
     * </pre>
     *
     * <code>.google.protobuf.Duration time_segment_start = 4;</code>
     */
    public Builder setTimeSegmentStart(com.google.protobuf.Duration value) {
      if (timeSegmentStartBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        timeSegmentStart_ = value;
      } else {
        timeSegmentStartBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000008;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The beginning, inclusive, of the video's time segment in which the
     * AnnotationSpec has been identified. Expressed as a number of seconds as
     * measured from the start of the video, with fractions up to a microsecond
     * precision, and with "s" appended at the end. Note that for
     * 'segment-classification' prediction type, this equals the original
     * 'timeSegmentStart' from the input instance, for other types it is the
     * start of a shot or a 1 second interval respectively.
     * </pre>
     *
     * <code>.google.protobuf.Duration time_segment_start = 4;</code>
     */
    public Builder setTimeSegmentStart(com.google.protobuf.Duration.Builder builderForValue) {
      if (timeSegmentStartBuilder_ == null) {
        timeSegmentStart_ = builderForValue.build();
      } else {
        timeSegmentStartBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000008;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The beginning, inclusive, of the video's time segment in which the
     * AnnotationSpec has been identified. Expressed as a number of seconds as
     * measured from the start of the video, with fractions up to a microsecond
     * precision, and with "s" appended at the end. Note that for
     * 'segment-classification' prediction type, this equals the original
     * 'timeSegmentStart' from the input instance, for other types it is the
     * start of a shot or a 1 second interval respectively.
     * </pre>
     *
     * <code>.google.protobuf.Duration time_segment_start = 4;</code>
     */
    public Builder mergeTimeSegmentStart(com.google.protobuf.Duration value) {
      if (timeSegmentStartBuilder_ == null) {
        if (((bitField0_ & 0x00000008) != 0)
            && timeSegmentStart_ != null
            && timeSegmentStart_ != com.google.protobuf.Duration.getDefaultInstance()) {
          getTimeSegmentStartBuilder().mergeFrom(value);
        } else {
          timeSegmentStart_ = value;
        }
      } else {
        timeSegmentStartBuilder_.mergeFrom(value);
      }
      if (timeSegmentStart_ != null) {
        bitField0_ |= 0x00000008;
        onChanged();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * The beginning, inclusive, of the video's time segment in which the
     * AnnotationSpec has been identified. Expressed as a number of seconds as
     * measured from the start of the video, with fractions up to a microsecond
     * precision, and with "s" appended at the end. Note that for
     * 'segment-classification' prediction type, this equals the original
     * 'timeSegmentStart' from the input instance, for other types it is the
     * start of a shot or a 1 second interval respectively.
     * </pre>
     *
     * <code>.google.protobuf.Duration time_segment_start = 4;</code>
     */
    public Builder clearTimeSegmentStart() {
      bitField0_ = (bitField0_ & ~0x00000008);
      timeSegmentStart_ = null;
      if (timeSegmentStartBuilder_ != null) {
        timeSegmentStartBuilder_.dispose();
        timeSegmentStartBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The beginning, inclusive, of the video's time segment in which the
     * AnnotationSpec has been identified. Expressed as a number of seconds as
     * measured from the start of the video, with fractions up to a microsecond
     * precision, and with "s" appended at the end. Note that for
     * 'segment-classification' prediction type, this equals the original
     * 'timeSegmentStart' from the input instance, for other types it is the
     * start of a shot or a 1 second interval respectively.
     * </pre>
     *
     * <code>.google.protobuf.Duration time_segment_start = 4;</code>
     */
    public com.google.protobuf.Duration.Builder getTimeSegmentStartBuilder() {
      bitField0_ |= 0x00000008;
      onChanged();
      return getTimeSegmentStartFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * The beginning, inclusive, of the video's time segment in which the
     * AnnotationSpec has been identified. Expressed as a number of seconds as
     * measured from the start of the video, with fractions up to a microsecond
     * precision, and with "s" appended at the end. Note that for
     * 'segment-classification' prediction type, this equals the original
     * 'timeSegmentStart' from the input instance, for other types it is the
     * start of a shot or a 1 second interval respectively.
     * </pre>
     *
     * <code>.google.protobuf.Duration time_segment_start = 4;</code>
     */
    public com.google.protobuf.DurationOrBuilder getTimeSegmentStartOrBuilder() {
      if (timeSegmentStartBuilder_ != null) {
        return timeSegmentStartBuilder_.getMessageOrBuilder();
      } else {
        return timeSegmentStart_ == null
            ? com.google.protobuf.Duration.getDefaultInstance()
            : timeSegmentStart_;
      }
    }
    /**
     *
     *
     * <pre>
     * The beginning, inclusive, of the video's time segment in which the
     * AnnotationSpec has been identified. Expressed as a number of seconds as
     * measured from the start of the video, with fractions up to a microsecond
     * precision, and with "s" appended at the end. Note that for
     * 'segment-classification' prediction type, this equals the original
     * 'timeSegmentStart' from the input instance, for other types it is the
     * start of a shot or a 1 second interval respectively.
     * </pre>
     *
     * <code>.google.protobuf.Duration time_segment_start = 4;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Duration,
            com.google.protobuf.Duration.Builder,
            com.google.protobuf.DurationOrBuilder>
        getTimeSegmentStartFieldBuilder() {
      if (timeSegmentStartBuilder_ == null) {
        timeSegmentStartBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.protobuf.Duration,
                com.google.protobuf.Duration.Builder,
                com.google.protobuf.DurationOrBuilder>(
                getTimeSegmentStart(), getParentForChildren(), isClean());
        timeSegmentStart_ = null;
      }
      return timeSegmentStartBuilder_;
    }

    private com.google.protobuf.Duration timeSegmentEnd_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Duration,
            com.google.protobuf.Duration.Builder,
            com.google.protobuf.DurationOrBuilder>
        timeSegmentEndBuilder_;
    /**
     *
     *
     * <pre>
     * The end, exclusive, of the video's time segment in which the
     * AnnotationSpec has been identified. Expressed as a number of seconds as
     * measured from the start of the video, with fractions up to a microsecond
     * precision, and with "s" appended at the end. Note that for
     * 'segment-classification' prediction type, this equals the original
     * 'timeSegmentEnd' from the input instance, for other types it is the end
     * of a shot or a 1 second interval respectively.
     * </pre>
     *
     * <code>.google.protobuf.Duration time_segment_end = 5;</code>
     *
     * @return Whether the timeSegmentEnd field is set.
     */
    public boolean hasTimeSegmentEnd() {
      return ((bitField0_ & 0x00000010) != 0);
    }
    /**
     *
     *
     * <pre>
     * The end, exclusive, of the video's time segment in which the
     * AnnotationSpec has been identified. Expressed as a number of seconds as
     * measured from the start of the video, with fractions up to a microsecond
     * precision, and with "s" appended at the end. Note that for
     * 'segment-classification' prediction type, this equals the original
     * 'timeSegmentEnd' from the input instance, for other types it is the end
     * of a shot or a 1 second interval respectively.
     * </pre>
     *
     * <code>.google.protobuf.Duration time_segment_end = 5;</code>
     *
     * @return The timeSegmentEnd.
     */
    public com.google.protobuf.Duration getTimeSegmentEnd() {
      if (timeSegmentEndBuilder_ == null) {
        return timeSegmentEnd_ == null
            ? com.google.protobuf.Duration.getDefaultInstance()
            : timeSegmentEnd_;
      } else {
        return timeSegmentEndBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * The end, exclusive, of the video's time segment in which the
     * AnnotationSpec has been identified. Expressed as a number of seconds as
     * measured from the start of the video, with fractions up to a microsecond
     * precision, and with "s" appended at the end. Note that for
     * 'segment-classification' prediction type, this equals the original
     * 'timeSegmentEnd' from the input instance, for other types it is the end
     * of a shot or a 1 second interval respectively.
     * </pre>
     *
     * <code>.google.protobuf.Duration time_segment_end = 5;</code>
     */
    public Builder setTimeSegmentEnd(com.google.protobuf.Duration value) {
      if (timeSegmentEndBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        timeSegmentEnd_ = value;
      } else {
        timeSegmentEndBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000010;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The end, exclusive, of the video's time segment in which the
     * AnnotationSpec has been identified. Expressed as a number of seconds as
     * measured from the start of the video, with fractions up to a microsecond
     * precision, and with "s" appended at the end. Note that for
     * 'segment-classification' prediction type, this equals the original
     * 'timeSegmentEnd' from the input instance, for other types it is the end
     * of a shot or a 1 second interval respectively.
     * </pre>
     *
     * <code>.google.protobuf.Duration time_segment_end = 5;</code>
     */
    public Builder setTimeSegmentEnd(com.google.protobuf.Duration.Builder builderForValue) {
      if (timeSegmentEndBuilder_ == null) {
        timeSegmentEnd_ = builderForValue.build();
      } else {
        timeSegmentEndBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000010;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The end, exclusive, of the video's time segment in which the
     * AnnotationSpec has been identified. Expressed as a number of seconds as
     * measured from the start of the video, with fractions up to a microsecond
     * precision, and with "s" appended at the end. Note that for
     * 'segment-classification' prediction type, this equals the original
     * 'timeSegmentEnd' from the input instance, for other types it is the end
     * of a shot or a 1 second interval respectively.
     * </pre>
     *
     * <code>.google.protobuf.Duration time_segment_end = 5;</code>
     */
    public Builder mergeTimeSegmentEnd(com.google.protobuf.Duration value) {
      if (timeSegmentEndBuilder_ == null) {
        if (((bitField0_ & 0x00000010) != 0)
            && timeSegmentEnd_ != null
            && timeSegmentEnd_ != com.google.protobuf.Duration.getDefaultInstance()) {
          getTimeSegmentEndBuilder().mergeFrom(value);
        } else {
          timeSegmentEnd_ = value;
        }
      } else {
        timeSegmentEndBuilder_.mergeFrom(value);
      }
      if (timeSegmentEnd_ != null) {
        bitField0_ |= 0x00000010;
        onChanged();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * The end, exclusive, of the video's time segment in which the
     * AnnotationSpec has been identified. Expressed as a number of seconds as
     * measured from the start of the video, with fractions up to a microsecond
     * precision, and with "s" appended at the end. Note that for
     * 'segment-classification' prediction type, this equals the original
     * 'timeSegmentEnd' from the input instance, for other types it is the end
     * of a shot or a 1 second interval respectively.
     * </pre>
     *
     * <code>.google.protobuf.Duration time_segment_end = 5;</code>
     */
    public Builder clearTimeSegmentEnd() {
      bitField0_ = (bitField0_ & ~0x00000010);
      timeSegmentEnd_ = null;
      if (timeSegmentEndBuilder_ != null) {
        timeSegmentEndBuilder_.dispose();
        timeSegmentEndBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The end, exclusive, of the video's time segment in which the
     * AnnotationSpec has been identified. Expressed as a number of seconds as
     * measured from the start of the video, with fractions up to a microsecond
     * precision, and with "s" appended at the end. Note that for
     * 'segment-classification' prediction type, this equals the original
     * 'timeSegmentEnd' from the input instance, for other types it is the end
     * of a shot or a 1 second interval respectively.
     * </pre>
     *
     * <code>.google.protobuf.Duration time_segment_end = 5;</code>
     */
    public com.google.protobuf.Duration.Builder getTimeSegmentEndBuilder() {
      bitField0_ |= 0x00000010;
      onChanged();
      return getTimeSegmentEndFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * The end, exclusive, of the video's time segment in which the
     * AnnotationSpec has been identified. Expressed as a number of seconds as
     * measured from the start of the video, with fractions up to a microsecond
     * precision, and with "s" appended at the end. Note that for
     * 'segment-classification' prediction type, this equals the original
     * 'timeSegmentEnd' from the input instance, for other types it is the end
     * of a shot or a 1 second interval respectively.
     * </pre>
     *
     * <code>.google.protobuf.Duration time_segment_end = 5;</code>
     */
    public com.google.protobuf.DurationOrBuilder getTimeSegmentEndOrBuilder() {
      if (timeSegmentEndBuilder_ != null) {
        return timeSegmentEndBuilder_.getMessageOrBuilder();
      } else {
        return timeSegmentEnd_ == null
            ? com.google.protobuf.Duration.getDefaultInstance()
            : timeSegmentEnd_;
      }
    }
    /**
     *
     *
     * <pre>
     * The end, exclusive, of the video's time segment in which the
     * AnnotationSpec has been identified. Expressed as a number of seconds as
     * measured from the start of the video, with fractions up to a microsecond
     * precision, and with "s" appended at the end. Note that for
     * 'segment-classification' prediction type, this equals the original
     * 'timeSegmentEnd' from the input instance, for other types it is the end
     * of a shot or a 1 second interval respectively.
     * </pre>
     *
     * <code>.google.protobuf.Duration time_segment_end = 5;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Duration,
            com.google.protobuf.Duration.Builder,
            com.google.protobuf.DurationOrBuilder>
        getTimeSegmentEndFieldBuilder() {
      if (timeSegmentEndBuilder_ == null) {
        timeSegmentEndBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.protobuf.Duration,
                com.google.protobuf.Duration.Builder,
                com.google.protobuf.DurationOrBuilder>(
                getTimeSegmentEnd(), getParentForChildren(), isClean());
        timeSegmentEnd_ = null;
      }
      return timeSegmentEndBuilder_;
    }

    private com.google.protobuf.FloatValue confidence_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.FloatValue,
            com.google.protobuf.FloatValue.Builder,
            com.google.protobuf.FloatValueOrBuilder>
        confidenceBuilder_;
    /**
     *
     *
     * <pre>
     * The Model's confidence in correction of this prediction, higher
     * value means higher confidence.
     * </pre>
     *
     * <code>.google.protobuf.FloatValue confidence = 6;</code>
     *
     * @return Whether the confidence field is set.
     */
    public boolean hasConfidence() {
      return ((bitField0_ & 0x00000020) != 0);
    }
    /**
     *
     *
     * <pre>
     * The Model's confidence in correction of this prediction, higher
     * value means higher confidence.
     * </pre>
     *
     * <code>.google.protobuf.FloatValue confidence = 6;</code>
     *
     * @return The confidence.
     */
    public com.google.protobuf.FloatValue getConfidence() {
      if (confidenceBuilder_ == null) {
        return confidence_ == null
            ? com.google.protobuf.FloatValue.getDefaultInstance()
            : confidence_;
      } else {
        return confidenceBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * The Model's confidence in correction of this prediction, higher
     * value means higher confidence.
     * </pre>
     *
     * <code>.google.protobuf.FloatValue confidence = 6;</code>
     */
    public Builder setConfidence(com.google.protobuf.FloatValue value) {
      if (confidenceBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        confidence_ = value;
      } else {
        confidenceBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000020;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The Model's confidence in correction of this prediction, higher
     * value means higher confidence.
     * </pre>
     *
     * <code>.google.protobuf.FloatValue confidence = 6;</code>
     */
    public Builder setConfidence(com.google.protobuf.FloatValue.Builder builderForValue) {
      if (confidenceBuilder_ == null) {
        confidence_ = builderForValue.build();
      } else {
        confidenceBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000020;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The Model's confidence in correction of this prediction, higher
     * value means higher confidence.
     * </pre>
     *
     * <code>.google.protobuf.FloatValue confidence = 6;</code>
     */
    public Builder mergeConfidence(com.google.protobuf.FloatValue value) {
      if (confidenceBuilder_ == null) {
        if (((bitField0_ & 0x00000020) != 0)
            && confidence_ != null
            && confidence_ != com.google.protobuf.FloatValue.getDefaultInstance()) {
          getConfidenceBuilder().mergeFrom(value);
        } else {
          confidence_ = value;
        }
      } else {
        confidenceBuilder_.mergeFrom(value);
      }
      if (confidence_ != null) {
        bitField0_ |= 0x00000020;
        onChanged();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * The Model's confidence in correction of this prediction, higher
     * value means higher confidence.
     * </pre>
     *
     * <code>.google.protobuf.FloatValue confidence = 6;</code>
     */
    public Builder clearConfidence() {
      bitField0_ = (bitField0_ & ~0x00000020);
      confidence_ = null;
      if (confidenceBuilder_ != null) {
        confidenceBuilder_.dispose();
        confidenceBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The Model's confidence in correction of this prediction, higher
     * value means higher confidence.
     * </pre>
     *
     * <code>.google.protobuf.FloatValue confidence = 6;</code>
     */
    public com.google.protobuf.FloatValue.Builder getConfidenceBuilder() {
      bitField0_ |= 0x00000020;
      onChanged();
      return getConfidenceFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * The Model's confidence in correction of this prediction, higher
     * value means higher confidence.
     * </pre>
     *
     * <code>.google.protobuf.FloatValue confidence = 6;</code>
     */
    public com.google.protobuf.FloatValueOrBuilder getConfidenceOrBuilder() {
      if (confidenceBuilder_ != null) {
        return confidenceBuilder_.getMessageOrBuilder();
      } else {
        return confidence_ == null
            ? com.google.protobuf.FloatValue.getDefaultInstance()
            : confidence_;
      }
    }
    /**
     *
     *
     * <pre>
     * The Model's confidence in correction of this prediction, higher
     * value means higher confidence.
     * </pre>
     *
     * <code>.google.protobuf.FloatValue confidence = 6;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.FloatValue,
            com.google.protobuf.FloatValue.Builder,
            com.google.protobuf.FloatValueOrBuilder>
        getConfidenceFieldBuilder() {
      if (confidenceBuilder_ == null) {
        confidenceBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.protobuf.FloatValue,
                com.google.protobuf.FloatValue.Builder,
                com.google.protobuf.FloatValueOrBuilder>(
                getConfidence(), getParentForChildren(), isClean());
        confidence_ = null;
      }
      return confidenceBuilder_;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.cloud.aiplatform.v1beta1.schema.predict.prediction.VideoClassificationPredictionResult)
  }

  // @@protoc_insertion_point(class_scope:google.cloud.aiplatform.v1beta1.schema.predict.prediction.VideoClassificationPredictionResult)
  private static final com.google.cloud.aiplatform.v1beta1.schema.predict.prediction
          .VideoClassificationPredictionResult
      DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE =
        new com.google.cloud.aiplatform.v1beta1.schema.predict.prediction
            .VideoClassificationPredictionResult();
  }

  public static com.google.cloud.aiplatform.v1beta1.schema.predict.prediction
          .VideoClassificationPredictionResult
      getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<VideoClassificationPredictionResult> PARSER =
      new com.google.protobuf.AbstractParser<VideoClassificationPredictionResult>() {
        @java.lang.Override
        public VideoClassificationPredictionResult parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          Builder builder = newBuilder();
          try {
            builder.mergeFrom(input, extensionRegistry);
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.setUnfinishedMessage(builder.buildPartial());
          } catch (com.google.protobuf.UninitializedMessageException e) {
            throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
          } catch (java.io.IOException e) {
            throw new com.google.protobuf.InvalidProtocolBufferException(e)
                .setUnfinishedMessage(builder.buildPartial());
          }
          return builder.buildPartial();
        }
      };

  public static com.google.protobuf.Parser<VideoClassificationPredictionResult> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<VideoClassificationPredictionResult> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.cloud.aiplatform.v1beta1.schema.predict.prediction
          .VideoClassificationPredictionResult
      getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
