/*
 * Copyright 2025 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/cloud/aiplatform/v1beta1/explanation.proto

// Protobuf Java Version: 3.25.5
package com.google.cloud.aiplatform.v1beta1;

/**
 *
 *
 * <pre>
 * An attribution method that computes the Aumann-Shapley value taking advantage
 * of the model's fully differentiable structure. Refer to this paper for
 * more details: https://arxiv.org/abs/1703.01365
 * </pre>
 *
 * Protobuf type {@code google.cloud.aiplatform.v1beta1.IntegratedGradientsAttribution}
 */
public final class IntegratedGradientsAttribution extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.cloud.aiplatform.v1beta1.IntegratedGradientsAttribution)
    IntegratedGradientsAttributionOrBuilder {
  private static final long serialVersionUID = 0L;
  // Use IntegratedGradientsAttribution.newBuilder() to construct.
  private IntegratedGradientsAttribution(
      com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private IntegratedGradientsAttribution() {}

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new IntegratedGradientsAttribution();
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.cloud.aiplatform.v1beta1.ExplanationProto
        .internal_static_google_cloud_aiplatform_v1beta1_IntegratedGradientsAttribution_descriptor;
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.cloud.aiplatform.v1beta1.ExplanationProto
        .internal_static_google_cloud_aiplatform_v1beta1_IntegratedGradientsAttribution_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.cloud.aiplatform.v1beta1.IntegratedGradientsAttribution.class,
            com.google.cloud.aiplatform.v1beta1.IntegratedGradientsAttribution.Builder.class);
  }

  private int bitField0_;
  public static final int STEP_COUNT_FIELD_NUMBER = 1;
  private int stepCount_ = 0;
  /**
   *
   *
   * <pre>
   * Required. The number of steps for approximating the path integral.
   * A good value to start is 50 and gradually increase until the
   * sum to diff property is within the desired error range.
   *
   * Valid range of its value is [1, 100], inclusively.
   * </pre>
   *
   * <code>int32 step_count = 1 [(.google.api.field_behavior) = REQUIRED];</code>
   *
   * @return The stepCount.
   */
  @java.lang.Override
  public int getStepCount() {
    return stepCount_;
  }

  public static final int SMOOTH_GRAD_CONFIG_FIELD_NUMBER = 2;
  private com.google.cloud.aiplatform.v1beta1.SmoothGradConfig smoothGradConfig_;
  /**
   *
   *
   * <pre>
   * Config for SmoothGrad approximation of gradients.
   *
   * When enabled, the gradients are approximated by averaging the gradients
   * from noisy samples in the vicinity of the inputs. Adding
   * noise can help improve the computed gradients. Refer to this paper for more
   * details: https://arxiv.org/pdf/1706.03825.pdf
   * </pre>
   *
   * <code>.google.cloud.aiplatform.v1beta1.SmoothGradConfig smooth_grad_config = 2;</code>
   *
   * @return Whether the smoothGradConfig field is set.
   */
  @java.lang.Override
  public boolean hasSmoothGradConfig() {
    return ((bitField0_ & 0x00000001) != 0);
  }
  /**
   *
   *
   * <pre>
   * Config for SmoothGrad approximation of gradients.
   *
   * When enabled, the gradients are approximated by averaging the gradients
   * from noisy samples in the vicinity of the inputs. Adding
   * noise can help improve the computed gradients. Refer to this paper for more
   * details: https://arxiv.org/pdf/1706.03825.pdf
   * </pre>
   *
   * <code>.google.cloud.aiplatform.v1beta1.SmoothGradConfig smooth_grad_config = 2;</code>
   *
   * @return The smoothGradConfig.
   */
  @java.lang.Override
  public com.google.cloud.aiplatform.v1beta1.SmoothGradConfig getSmoothGradConfig() {
    return smoothGradConfig_ == null
        ? com.google.cloud.aiplatform.v1beta1.SmoothGradConfig.getDefaultInstance()
        : smoothGradConfig_;
  }
  /**
   *
   *
   * <pre>
   * Config for SmoothGrad approximation of gradients.
   *
   * When enabled, the gradients are approximated by averaging the gradients
   * from noisy samples in the vicinity of the inputs. Adding
   * noise can help improve the computed gradients. Refer to this paper for more
   * details: https://arxiv.org/pdf/1706.03825.pdf
   * </pre>
   *
   * <code>.google.cloud.aiplatform.v1beta1.SmoothGradConfig smooth_grad_config = 2;</code>
   */
  @java.lang.Override
  public com.google.cloud.aiplatform.v1beta1.SmoothGradConfigOrBuilder
      getSmoothGradConfigOrBuilder() {
    return smoothGradConfig_ == null
        ? com.google.cloud.aiplatform.v1beta1.SmoothGradConfig.getDefaultInstance()
        : smoothGradConfig_;
  }

  public static final int BLUR_BASELINE_CONFIG_FIELD_NUMBER = 3;
  private com.google.cloud.aiplatform.v1beta1.BlurBaselineConfig blurBaselineConfig_;
  /**
   *
   *
   * <pre>
   * Config for IG with blur baseline.
   *
   * When enabled, a linear path from the maximally blurred image to the input
   * image is created. Using a blurred baseline instead of zero (black image) is
   * motivated by the BlurIG approach explained here:
   * https://arxiv.org/abs/2004.03383
   * </pre>
   *
   * <code>.google.cloud.aiplatform.v1beta1.BlurBaselineConfig blur_baseline_config = 3;</code>
   *
   * @return Whether the blurBaselineConfig field is set.
   */
  @java.lang.Override
  public boolean hasBlurBaselineConfig() {
    return ((bitField0_ & 0x00000002) != 0);
  }
  /**
   *
   *
   * <pre>
   * Config for IG with blur baseline.
   *
   * When enabled, a linear path from the maximally blurred image to the input
   * image is created. Using a blurred baseline instead of zero (black image) is
   * motivated by the BlurIG approach explained here:
   * https://arxiv.org/abs/2004.03383
   * </pre>
   *
   * <code>.google.cloud.aiplatform.v1beta1.BlurBaselineConfig blur_baseline_config = 3;</code>
   *
   * @return The blurBaselineConfig.
   */
  @java.lang.Override
  public com.google.cloud.aiplatform.v1beta1.BlurBaselineConfig getBlurBaselineConfig() {
    return blurBaselineConfig_ == null
        ? com.google.cloud.aiplatform.v1beta1.BlurBaselineConfig.getDefaultInstance()
        : blurBaselineConfig_;
  }
  /**
   *
   *
   * <pre>
   * Config for IG with blur baseline.
   *
   * When enabled, a linear path from the maximally blurred image to the input
   * image is created. Using a blurred baseline instead of zero (black image) is
   * motivated by the BlurIG approach explained here:
   * https://arxiv.org/abs/2004.03383
   * </pre>
   *
   * <code>.google.cloud.aiplatform.v1beta1.BlurBaselineConfig blur_baseline_config = 3;</code>
   */
  @java.lang.Override
  public com.google.cloud.aiplatform.v1beta1.BlurBaselineConfigOrBuilder
      getBlurBaselineConfigOrBuilder() {
    return blurBaselineConfig_ == null
        ? com.google.cloud.aiplatform.v1beta1.BlurBaselineConfig.getDefaultInstance()
        : blurBaselineConfig_;
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    if (stepCount_ != 0) {
      output.writeInt32(1, stepCount_);
    }
    if (((bitField0_ & 0x00000001) != 0)) {
      output.writeMessage(2, getSmoothGradConfig());
    }
    if (((bitField0_ & 0x00000002) != 0)) {
      output.writeMessage(3, getBlurBaselineConfig());
    }
    getUnknownFields().writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    if (stepCount_ != 0) {
      size += com.google.protobuf.CodedOutputStream.computeInt32Size(1, stepCount_);
    }
    if (((bitField0_ & 0x00000001) != 0)) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(2, getSmoothGradConfig());
    }
    if (((bitField0_ & 0x00000002) != 0)) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(3, getBlurBaselineConfig());
    }
    size += getUnknownFields().getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.cloud.aiplatform.v1beta1.IntegratedGradientsAttribution)) {
      return super.equals(obj);
    }
    com.google.cloud.aiplatform.v1beta1.IntegratedGradientsAttribution other =
        (com.google.cloud.aiplatform.v1beta1.IntegratedGradientsAttribution) obj;

    if (getStepCount() != other.getStepCount()) return false;
    if (hasSmoothGradConfig() != other.hasSmoothGradConfig()) return false;
    if (hasSmoothGradConfig()) {
      if (!getSmoothGradConfig().equals(other.getSmoothGradConfig())) return false;
    }
    if (hasBlurBaselineConfig() != other.hasBlurBaselineConfig()) return false;
    if (hasBlurBaselineConfig()) {
      if (!getBlurBaselineConfig().equals(other.getBlurBaselineConfig())) return false;
    }
    if (!getUnknownFields().equals(other.getUnknownFields())) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    hash = (37 * hash) + STEP_COUNT_FIELD_NUMBER;
    hash = (53 * hash) + getStepCount();
    if (hasSmoothGradConfig()) {
      hash = (37 * hash) + SMOOTH_GRAD_CONFIG_FIELD_NUMBER;
      hash = (53 * hash) + getSmoothGradConfig().hashCode();
    }
    if (hasBlurBaselineConfig()) {
      hash = (37 * hash) + BLUR_BASELINE_CONFIG_FIELD_NUMBER;
      hash = (53 * hash) + getBlurBaselineConfig().hashCode();
    }
    hash = (29 * hash) + getUnknownFields().hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.cloud.aiplatform.v1beta1.IntegratedGradientsAttribution parseFrom(
      java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.aiplatform.v1beta1.IntegratedGradientsAttribution parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.aiplatform.v1beta1.IntegratedGradientsAttribution parseFrom(
      com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.aiplatform.v1beta1.IntegratedGradientsAttribution parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.aiplatform.v1beta1.IntegratedGradientsAttribution parseFrom(
      byte[] data) throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.aiplatform.v1beta1.IntegratedGradientsAttribution parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.aiplatform.v1beta1.IntegratedGradientsAttribution parseFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.aiplatform.v1beta1.IntegratedGradientsAttribution parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.aiplatform.v1beta1.IntegratedGradientsAttribution
      parseDelimitedFrom(java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.cloud.aiplatform.v1beta1.IntegratedGradientsAttribution
      parseDelimitedFrom(
          java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.aiplatform.v1beta1.IntegratedGradientsAttribution parseFrom(
      com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.aiplatform.v1beta1.IntegratedGradientsAttribution parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(
      com.google.cloud.aiplatform.v1beta1.IntegratedGradientsAttribution prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }
  /**
   *
   *
   * <pre>
   * An attribution method that computes the Aumann-Shapley value taking advantage
   * of the model's fully differentiable structure. Refer to this paper for
   * more details: https://arxiv.org/abs/1703.01365
   * </pre>
   *
   * Protobuf type {@code google.cloud.aiplatform.v1beta1.IntegratedGradientsAttribution}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.cloud.aiplatform.v1beta1.IntegratedGradientsAttribution)
      com.google.cloud.aiplatform.v1beta1.IntegratedGradientsAttributionOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.aiplatform.v1beta1.ExplanationProto
          .internal_static_google_cloud_aiplatform_v1beta1_IntegratedGradientsAttribution_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.aiplatform.v1beta1.ExplanationProto
          .internal_static_google_cloud_aiplatform_v1beta1_IntegratedGradientsAttribution_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.aiplatform.v1beta1.IntegratedGradientsAttribution.class,
              com.google.cloud.aiplatform.v1beta1.IntegratedGradientsAttribution.Builder.class);
    }

    // Construct using
    // com.google.cloud.aiplatform.v1beta1.IntegratedGradientsAttribution.newBuilder()
    private Builder() {
      maybeForceBuilderInitialization();
    }

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
      maybeForceBuilderInitialization();
    }

    private void maybeForceBuilderInitialization() {
      if (com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders) {
        getSmoothGradConfigFieldBuilder();
        getBlurBaselineConfigFieldBuilder();
      }
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      bitField0_ = 0;
      stepCount_ = 0;
      smoothGradConfig_ = null;
      if (smoothGradConfigBuilder_ != null) {
        smoothGradConfigBuilder_.dispose();
        smoothGradConfigBuilder_ = null;
      }
      blurBaselineConfig_ = null;
      if (blurBaselineConfigBuilder_ != null) {
        blurBaselineConfigBuilder_.dispose();
        blurBaselineConfigBuilder_ = null;
      }
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.cloud.aiplatform.v1beta1.ExplanationProto
          .internal_static_google_cloud_aiplatform_v1beta1_IntegratedGradientsAttribution_descriptor;
    }

    @java.lang.Override
    public com.google.cloud.aiplatform.v1beta1.IntegratedGradientsAttribution
        getDefaultInstanceForType() {
      return com.google.cloud.aiplatform.v1beta1.IntegratedGradientsAttribution
          .getDefaultInstance();
    }

    @java.lang.Override
    public com.google.cloud.aiplatform.v1beta1.IntegratedGradientsAttribution build() {
      com.google.cloud.aiplatform.v1beta1.IntegratedGradientsAttribution result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.cloud.aiplatform.v1beta1.IntegratedGradientsAttribution buildPartial() {
      com.google.cloud.aiplatform.v1beta1.IntegratedGradientsAttribution result =
          new com.google.cloud.aiplatform.v1beta1.IntegratedGradientsAttribution(this);
      if (bitField0_ != 0) {
        buildPartial0(result);
      }
      onBuilt();
      return result;
    }

    private void buildPartial0(
        com.google.cloud.aiplatform.v1beta1.IntegratedGradientsAttribution result) {
      int from_bitField0_ = bitField0_;
      if (((from_bitField0_ & 0x00000001) != 0)) {
        result.stepCount_ = stepCount_;
      }
      int to_bitField0_ = 0;
      if (((from_bitField0_ & 0x00000002) != 0)) {
        result.smoothGradConfig_ =
            smoothGradConfigBuilder_ == null ? smoothGradConfig_ : smoothGradConfigBuilder_.build();
        to_bitField0_ |= 0x00000001;
      }
      if (((from_bitField0_ & 0x00000004) != 0)) {
        result.blurBaselineConfig_ =
            blurBaselineConfigBuilder_ == null
                ? blurBaselineConfig_
                : blurBaselineConfigBuilder_.build();
        to_bitField0_ |= 0x00000002;
      }
      result.bitField0_ |= to_bitField0_;
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.cloud.aiplatform.v1beta1.IntegratedGradientsAttribution) {
        return mergeFrom(
            (com.google.cloud.aiplatform.v1beta1.IntegratedGradientsAttribution) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(
        com.google.cloud.aiplatform.v1beta1.IntegratedGradientsAttribution other) {
      if (other
          == com.google.cloud.aiplatform.v1beta1.IntegratedGradientsAttribution
              .getDefaultInstance()) return this;
      if (other.getStepCount() != 0) {
        setStepCount(other.getStepCount());
      }
      if (other.hasSmoothGradConfig()) {
        mergeSmoothGradConfig(other.getSmoothGradConfig());
      }
      if (other.hasBlurBaselineConfig()) {
        mergeBlurBaselineConfig(other.getBlurBaselineConfig());
      }
      this.mergeUnknownFields(other.getUnknownFields());
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 8:
              {
                stepCount_ = input.readInt32();
                bitField0_ |= 0x00000001;
                break;
              } // case 8
            case 18:
              {
                input.readMessage(
                    getSmoothGradConfigFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000002;
                break;
              } // case 18
            case 26:
              {
                input.readMessage(
                    getBlurBaselineConfigFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000004;
                break;
              } // case 26
            default:
              {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
          } // switch (tag)
        } // while (!done)
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.unwrapIOException();
      } finally {
        onChanged();
      } // finally
      return this;
    }

    private int bitField0_;

    private int stepCount_;
    /**
     *
     *
     * <pre>
     * Required. The number of steps for approximating the path integral.
     * A good value to start is 50 and gradually increase until the
     * sum to diff property is within the desired error range.
     *
     * Valid range of its value is [1, 100], inclusively.
     * </pre>
     *
     * <code>int32 step_count = 1 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return The stepCount.
     */
    @java.lang.Override
    public int getStepCount() {
      return stepCount_;
    }
    /**
     *
     *
     * <pre>
     * Required. The number of steps for approximating the path integral.
     * A good value to start is 50 and gradually increase until the
     * sum to diff property is within the desired error range.
     *
     * Valid range of its value is [1, 100], inclusively.
     * </pre>
     *
     * <code>int32 step_count = 1 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @param value The stepCount to set.
     * @return This builder for chaining.
     */
    public Builder setStepCount(int value) {

      stepCount_ = value;
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. The number of steps for approximating the path integral.
     * A good value to start is 50 and gradually increase until the
     * sum to diff property is within the desired error range.
     *
     * Valid range of its value is [1, 100], inclusively.
     * </pre>
     *
     * <code>int32 step_count = 1 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearStepCount() {
      bitField0_ = (bitField0_ & ~0x00000001);
      stepCount_ = 0;
      onChanged();
      return this;
    }

    private com.google.cloud.aiplatform.v1beta1.SmoothGradConfig smoothGradConfig_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.aiplatform.v1beta1.SmoothGradConfig,
            com.google.cloud.aiplatform.v1beta1.SmoothGradConfig.Builder,
            com.google.cloud.aiplatform.v1beta1.SmoothGradConfigOrBuilder>
        smoothGradConfigBuilder_;
    /**
     *
     *
     * <pre>
     * Config for SmoothGrad approximation of gradients.
     *
     * When enabled, the gradients are approximated by averaging the gradients
     * from noisy samples in the vicinity of the inputs. Adding
     * noise can help improve the computed gradients. Refer to this paper for more
     * details: https://arxiv.org/pdf/1706.03825.pdf
     * </pre>
     *
     * <code>.google.cloud.aiplatform.v1beta1.SmoothGradConfig smooth_grad_config = 2;</code>
     *
     * @return Whether the smoothGradConfig field is set.
     */
    public boolean hasSmoothGradConfig() {
      return ((bitField0_ & 0x00000002) != 0);
    }
    /**
     *
     *
     * <pre>
     * Config for SmoothGrad approximation of gradients.
     *
     * When enabled, the gradients are approximated by averaging the gradients
     * from noisy samples in the vicinity of the inputs. Adding
     * noise can help improve the computed gradients. Refer to this paper for more
     * details: https://arxiv.org/pdf/1706.03825.pdf
     * </pre>
     *
     * <code>.google.cloud.aiplatform.v1beta1.SmoothGradConfig smooth_grad_config = 2;</code>
     *
     * @return The smoothGradConfig.
     */
    public com.google.cloud.aiplatform.v1beta1.SmoothGradConfig getSmoothGradConfig() {
      if (smoothGradConfigBuilder_ == null) {
        return smoothGradConfig_ == null
            ? com.google.cloud.aiplatform.v1beta1.SmoothGradConfig.getDefaultInstance()
            : smoothGradConfig_;
      } else {
        return smoothGradConfigBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Config for SmoothGrad approximation of gradients.
     *
     * When enabled, the gradients are approximated by averaging the gradients
     * from noisy samples in the vicinity of the inputs. Adding
     * noise can help improve the computed gradients. Refer to this paper for more
     * details: https://arxiv.org/pdf/1706.03825.pdf
     * </pre>
     *
     * <code>.google.cloud.aiplatform.v1beta1.SmoothGradConfig smooth_grad_config = 2;</code>
     */
    public Builder setSmoothGradConfig(com.google.cloud.aiplatform.v1beta1.SmoothGradConfig value) {
      if (smoothGradConfigBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        smoothGradConfig_ = value;
      } else {
        smoothGradConfigBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Config for SmoothGrad approximation of gradients.
     *
     * When enabled, the gradients are approximated by averaging the gradients
     * from noisy samples in the vicinity of the inputs. Adding
     * noise can help improve the computed gradients. Refer to this paper for more
     * details: https://arxiv.org/pdf/1706.03825.pdf
     * </pre>
     *
     * <code>.google.cloud.aiplatform.v1beta1.SmoothGradConfig smooth_grad_config = 2;</code>
     */
    public Builder setSmoothGradConfig(
        com.google.cloud.aiplatform.v1beta1.SmoothGradConfig.Builder builderForValue) {
      if (smoothGradConfigBuilder_ == null) {
        smoothGradConfig_ = builderForValue.build();
      } else {
        smoothGradConfigBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Config for SmoothGrad approximation of gradients.
     *
     * When enabled, the gradients are approximated by averaging the gradients
     * from noisy samples in the vicinity of the inputs. Adding
     * noise can help improve the computed gradients. Refer to this paper for more
     * details: https://arxiv.org/pdf/1706.03825.pdf
     * </pre>
     *
     * <code>.google.cloud.aiplatform.v1beta1.SmoothGradConfig smooth_grad_config = 2;</code>
     */
    public Builder mergeSmoothGradConfig(
        com.google.cloud.aiplatform.v1beta1.SmoothGradConfig value) {
      if (smoothGradConfigBuilder_ == null) {
        if (((bitField0_ & 0x00000002) != 0)
            && smoothGradConfig_ != null
            && smoothGradConfig_
                != com.google.cloud.aiplatform.v1beta1.SmoothGradConfig.getDefaultInstance()) {
          getSmoothGradConfigBuilder().mergeFrom(value);
        } else {
          smoothGradConfig_ = value;
        }
      } else {
        smoothGradConfigBuilder_.mergeFrom(value);
      }
      if (smoothGradConfig_ != null) {
        bitField0_ |= 0x00000002;
        onChanged();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Config for SmoothGrad approximation of gradients.
     *
     * When enabled, the gradients are approximated by averaging the gradients
     * from noisy samples in the vicinity of the inputs. Adding
     * noise can help improve the computed gradients. Refer to this paper for more
     * details: https://arxiv.org/pdf/1706.03825.pdf
     * </pre>
     *
     * <code>.google.cloud.aiplatform.v1beta1.SmoothGradConfig smooth_grad_config = 2;</code>
     */
    public Builder clearSmoothGradConfig() {
      bitField0_ = (bitField0_ & ~0x00000002);
      smoothGradConfig_ = null;
      if (smoothGradConfigBuilder_ != null) {
        smoothGradConfigBuilder_.dispose();
        smoothGradConfigBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Config for SmoothGrad approximation of gradients.
     *
     * When enabled, the gradients are approximated by averaging the gradients
     * from noisy samples in the vicinity of the inputs. Adding
     * noise can help improve the computed gradients. Refer to this paper for more
     * details: https://arxiv.org/pdf/1706.03825.pdf
     * </pre>
     *
     * <code>.google.cloud.aiplatform.v1beta1.SmoothGradConfig smooth_grad_config = 2;</code>
     */
    public com.google.cloud.aiplatform.v1beta1.SmoothGradConfig.Builder
        getSmoothGradConfigBuilder() {
      bitField0_ |= 0x00000002;
      onChanged();
      return getSmoothGradConfigFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Config for SmoothGrad approximation of gradients.
     *
     * When enabled, the gradients are approximated by averaging the gradients
     * from noisy samples in the vicinity of the inputs. Adding
     * noise can help improve the computed gradients. Refer to this paper for more
     * details: https://arxiv.org/pdf/1706.03825.pdf
     * </pre>
     *
     * <code>.google.cloud.aiplatform.v1beta1.SmoothGradConfig smooth_grad_config = 2;</code>
     */
    public com.google.cloud.aiplatform.v1beta1.SmoothGradConfigOrBuilder
        getSmoothGradConfigOrBuilder() {
      if (smoothGradConfigBuilder_ != null) {
        return smoothGradConfigBuilder_.getMessageOrBuilder();
      } else {
        return smoothGradConfig_ == null
            ? com.google.cloud.aiplatform.v1beta1.SmoothGradConfig.getDefaultInstance()
            : smoothGradConfig_;
      }
    }
    /**
     *
     *
     * <pre>
     * Config for SmoothGrad approximation of gradients.
     *
     * When enabled, the gradients are approximated by averaging the gradients
     * from noisy samples in the vicinity of the inputs. Adding
     * noise can help improve the computed gradients. Refer to this paper for more
     * details: https://arxiv.org/pdf/1706.03825.pdf
     * </pre>
     *
     * <code>.google.cloud.aiplatform.v1beta1.SmoothGradConfig smooth_grad_config = 2;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.aiplatform.v1beta1.SmoothGradConfig,
            com.google.cloud.aiplatform.v1beta1.SmoothGradConfig.Builder,
            com.google.cloud.aiplatform.v1beta1.SmoothGradConfigOrBuilder>
        getSmoothGradConfigFieldBuilder() {
      if (smoothGradConfigBuilder_ == null) {
        smoothGradConfigBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.aiplatform.v1beta1.SmoothGradConfig,
                com.google.cloud.aiplatform.v1beta1.SmoothGradConfig.Builder,
                com.google.cloud.aiplatform.v1beta1.SmoothGradConfigOrBuilder>(
                getSmoothGradConfig(), getParentForChildren(), isClean());
        smoothGradConfig_ = null;
      }
      return smoothGradConfigBuilder_;
    }

    private com.google.cloud.aiplatform.v1beta1.BlurBaselineConfig blurBaselineConfig_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.aiplatform.v1beta1.BlurBaselineConfig,
            com.google.cloud.aiplatform.v1beta1.BlurBaselineConfig.Builder,
            com.google.cloud.aiplatform.v1beta1.BlurBaselineConfigOrBuilder>
        blurBaselineConfigBuilder_;
    /**
     *
     *
     * <pre>
     * Config for IG with blur baseline.
     *
     * When enabled, a linear path from the maximally blurred image to the input
     * image is created. Using a blurred baseline instead of zero (black image) is
     * motivated by the BlurIG approach explained here:
     * https://arxiv.org/abs/2004.03383
     * </pre>
     *
     * <code>.google.cloud.aiplatform.v1beta1.BlurBaselineConfig blur_baseline_config = 3;</code>
     *
     * @return Whether the blurBaselineConfig field is set.
     */
    public boolean hasBlurBaselineConfig() {
      return ((bitField0_ & 0x00000004) != 0);
    }
    /**
     *
     *
     * <pre>
     * Config for IG with blur baseline.
     *
     * When enabled, a linear path from the maximally blurred image to the input
     * image is created. Using a blurred baseline instead of zero (black image) is
     * motivated by the BlurIG approach explained here:
     * https://arxiv.org/abs/2004.03383
     * </pre>
     *
     * <code>.google.cloud.aiplatform.v1beta1.BlurBaselineConfig blur_baseline_config = 3;</code>
     *
     * @return The blurBaselineConfig.
     */
    public com.google.cloud.aiplatform.v1beta1.BlurBaselineConfig getBlurBaselineConfig() {
      if (blurBaselineConfigBuilder_ == null) {
        return blurBaselineConfig_ == null
            ? com.google.cloud.aiplatform.v1beta1.BlurBaselineConfig.getDefaultInstance()
            : blurBaselineConfig_;
      } else {
        return blurBaselineConfigBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Config for IG with blur baseline.
     *
     * When enabled, a linear path from the maximally blurred image to the input
     * image is created. Using a blurred baseline instead of zero (black image) is
     * motivated by the BlurIG approach explained here:
     * https://arxiv.org/abs/2004.03383
     * </pre>
     *
     * <code>.google.cloud.aiplatform.v1beta1.BlurBaselineConfig blur_baseline_config = 3;</code>
     */
    public Builder setBlurBaselineConfig(
        com.google.cloud.aiplatform.v1beta1.BlurBaselineConfig value) {
      if (blurBaselineConfigBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        blurBaselineConfig_ = value;
      } else {
        blurBaselineConfigBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Config for IG with blur baseline.
     *
     * When enabled, a linear path from the maximally blurred image to the input
     * image is created. Using a blurred baseline instead of zero (black image) is
     * motivated by the BlurIG approach explained here:
     * https://arxiv.org/abs/2004.03383
     * </pre>
     *
     * <code>.google.cloud.aiplatform.v1beta1.BlurBaselineConfig blur_baseline_config = 3;</code>
     */
    public Builder setBlurBaselineConfig(
        com.google.cloud.aiplatform.v1beta1.BlurBaselineConfig.Builder builderForValue) {
      if (blurBaselineConfigBuilder_ == null) {
        blurBaselineConfig_ = builderForValue.build();
      } else {
        blurBaselineConfigBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Config for IG with blur baseline.
     *
     * When enabled, a linear path from the maximally blurred image to the input
     * image is created. Using a blurred baseline instead of zero (black image) is
     * motivated by the BlurIG approach explained here:
     * https://arxiv.org/abs/2004.03383
     * </pre>
     *
     * <code>.google.cloud.aiplatform.v1beta1.BlurBaselineConfig blur_baseline_config = 3;</code>
     */
    public Builder mergeBlurBaselineConfig(
        com.google.cloud.aiplatform.v1beta1.BlurBaselineConfig value) {
      if (blurBaselineConfigBuilder_ == null) {
        if (((bitField0_ & 0x00000004) != 0)
            && blurBaselineConfig_ != null
            && blurBaselineConfig_
                != com.google.cloud.aiplatform.v1beta1.BlurBaselineConfig.getDefaultInstance()) {
          getBlurBaselineConfigBuilder().mergeFrom(value);
        } else {
          blurBaselineConfig_ = value;
        }
      } else {
        blurBaselineConfigBuilder_.mergeFrom(value);
      }
      if (blurBaselineConfig_ != null) {
        bitField0_ |= 0x00000004;
        onChanged();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Config for IG with blur baseline.
     *
     * When enabled, a linear path from the maximally blurred image to the input
     * image is created. Using a blurred baseline instead of zero (black image) is
     * motivated by the BlurIG approach explained here:
     * https://arxiv.org/abs/2004.03383
     * </pre>
     *
     * <code>.google.cloud.aiplatform.v1beta1.BlurBaselineConfig blur_baseline_config = 3;</code>
     */
    public Builder clearBlurBaselineConfig() {
      bitField0_ = (bitField0_ & ~0x00000004);
      blurBaselineConfig_ = null;
      if (blurBaselineConfigBuilder_ != null) {
        blurBaselineConfigBuilder_.dispose();
        blurBaselineConfigBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Config for IG with blur baseline.
     *
     * When enabled, a linear path from the maximally blurred image to the input
     * image is created. Using a blurred baseline instead of zero (black image) is
     * motivated by the BlurIG approach explained here:
     * https://arxiv.org/abs/2004.03383
     * </pre>
     *
     * <code>.google.cloud.aiplatform.v1beta1.BlurBaselineConfig blur_baseline_config = 3;</code>
     */
    public com.google.cloud.aiplatform.v1beta1.BlurBaselineConfig.Builder
        getBlurBaselineConfigBuilder() {
      bitField0_ |= 0x00000004;
      onChanged();
      return getBlurBaselineConfigFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Config for IG with blur baseline.
     *
     * When enabled, a linear path from the maximally blurred image to the input
     * image is created. Using a blurred baseline instead of zero (black image) is
     * motivated by the BlurIG approach explained here:
     * https://arxiv.org/abs/2004.03383
     * </pre>
     *
     * <code>.google.cloud.aiplatform.v1beta1.BlurBaselineConfig blur_baseline_config = 3;</code>
     */
    public com.google.cloud.aiplatform.v1beta1.BlurBaselineConfigOrBuilder
        getBlurBaselineConfigOrBuilder() {
      if (blurBaselineConfigBuilder_ != null) {
        return blurBaselineConfigBuilder_.getMessageOrBuilder();
      } else {
        return blurBaselineConfig_ == null
            ? com.google.cloud.aiplatform.v1beta1.BlurBaselineConfig.getDefaultInstance()
            : blurBaselineConfig_;
      }
    }
    /**
     *
     *
     * <pre>
     * Config for IG with blur baseline.
     *
     * When enabled, a linear path from the maximally blurred image to the input
     * image is created. Using a blurred baseline instead of zero (black image) is
     * motivated by the BlurIG approach explained here:
     * https://arxiv.org/abs/2004.03383
     * </pre>
     *
     * <code>.google.cloud.aiplatform.v1beta1.BlurBaselineConfig blur_baseline_config = 3;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.aiplatform.v1beta1.BlurBaselineConfig,
            com.google.cloud.aiplatform.v1beta1.BlurBaselineConfig.Builder,
            com.google.cloud.aiplatform.v1beta1.BlurBaselineConfigOrBuilder>
        getBlurBaselineConfigFieldBuilder() {
      if (blurBaselineConfigBuilder_ == null) {
        blurBaselineConfigBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.aiplatform.v1beta1.BlurBaselineConfig,
                com.google.cloud.aiplatform.v1beta1.BlurBaselineConfig.Builder,
                com.google.cloud.aiplatform.v1beta1.BlurBaselineConfigOrBuilder>(
                getBlurBaselineConfig(), getParentForChildren(), isClean());
        blurBaselineConfig_ = null;
      }
      return blurBaselineConfigBuilder_;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.cloud.aiplatform.v1beta1.IntegratedGradientsAttribution)
  }

  // @@protoc_insertion_point(class_scope:google.cloud.aiplatform.v1beta1.IntegratedGradientsAttribution)
  private static final com.google.cloud.aiplatform.v1beta1.IntegratedGradientsAttribution
      DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.cloud.aiplatform.v1beta1.IntegratedGradientsAttribution();
  }

  public static com.google.cloud.aiplatform.v1beta1.IntegratedGradientsAttribution
      getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<IntegratedGradientsAttribution> PARSER =
      new com.google.protobuf.AbstractParser<IntegratedGradientsAttribution>() {
        @java.lang.Override
        public IntegratedGradientsAttribution parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          Builder builder = newBuilder();
          try {
            builder.mergeFrom(input, extensionRegistry);
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.setUnfinishedMessage(builder.buildPartial());
          } catch (com.google.protobuf.UninitializedMessageException e) {
            throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
          } catch (java.io.IOException e) {
            throw new com.google.protobuf.InvalidProtocolBufferException(e)
                .setUnfinishedMessage(builder.buildPartial());
          }
          return builder.buildPartial();
        }
      };

  public static com.google.protobuf.Parser<IntegratedGradientsAttribution> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<IntegratedGradientsAttribution> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.cloud.aiplatform.v1beta1.IntegratedGradientsAttribution
      getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
